/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../../inc/MarlinConfigPre.h"

#if ALL(HAS_GRAPHICAL_TFT, SHOW_BOOTSCREEN)

#include "../tft_image.h"

const uint16_t marlin_logo_1024x600x16[614400] = {
  0x20EF,0x20EF,0x20EF,0x210F,0x210F,0x210F,0x20EE,0x20EE,0x20EE,0x20EF,0x20EF,0x20EF,0x20EE,0x210E,0x210E,0x210E,0x190E,0x190E,0x190E,0x190E,0x190E,0x190E,0x190F,0x190F,0x210F,0x20EF,0x210F,0x210F,0x190F,0x210F,0x210E,0x210F,0x210F,0x210F,0x210F,0x210E,0x210E,0x210F,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210F,0x210F,0x210F,0x20EF,0x210F,0x190F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x20EF,0x290F,0x28EF,0x210F,0x2110,0x1931,0x1933,0x0934,0x0155,0x0177,0x0197,0x01B8,0x01FA,0x01DA,0x01FA,0x01FA,0x01D9,0x01D9,0x01FA,0x01F9,0x01D8,0x0197,0x0155,0x0135,0x08F3,0x1113,0x1952,0x2131,0x2111,0x2910,0x2910,0x2910,0x20EF,0x290F,0x20EF,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x210F,0x2110,0x2110,0x2110,0x2930,0x2910,0x2110,0x2110,0x2110,0x2910,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x290F,0x290F,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2930,0x212F,0x212F,0x210F,0x2930,0x210F,0x2110,0x20EF,0x2110,0x2110,0x2110,0x2131,0x2132,0x1953,0x1954,0x1174,0x11B6,0x19F7,0x11D6,0x0995,0x0974,0x0954,0x0953,0x1133,0x1132,0x1972,0x2172,0x2192,0x2992,0x2171,0x2971,0x2151,0x2151,0x2151,0x2151,0x2130,0x2151,0x2151,0x2951,0x2131,0x2951,0x2131,0x2931,0x2930,0x2951,0x2130,0x2151,0x2151,0x2151,0x2151,0x2151,0x2171,0x2192,0x2151,0x2151,0x1931,0x1930,0x2151,0x2172,0x1952,0x1972,0x1973,0x1174,0x1195,0x11B6,0x09B7,0x09D7,0x09B7,0x09D7,0x09F8,0x09F8,0x09F8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D7,0x0997,0x0975,0x1133,0x1112,0x1911,0x1911,0x1910,0x2110,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x20F0,0x2910,0x2110,0x2110,0x2131,0x1932,0x1952,0x1953,0x1995,0x19D6,0x1A18,0x19F8,0x19F8,0x11D7,0x0975,0x0113,0x0933,0x1132,0x1132,0x1931,0x1910,0x2110,0x210F,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x1932,0x1953,0x1195,0x11D6,0x11F7,0x11D6,0x11B6,0x0974,0x0974,0x1174,0x0973,0x0973,0x0954,0x0975,0x09B6,0x09D7,0x11F7,0x19D7,0x1974,0x1933,0x1911,0x2111,0x2131,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x20F0,0x20F0,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x2131,0x2132,0x1933,0x1154,0x1996,0x19D7,0x11D7,0x11B7,0x0954,0x1132,0x1131,0x1951,0x1951,0x10F1,0x1112,0x1133,0x1996,0x1A19,0x11F9,0x11B8,0x0956,0x1134,0x1134,0x1133,0x1134,0x1154,0x1175,0x0976,0x09B7,0x11F7,0x19F7,0x1195,0x1174,0x1133,0x1132,0x1952,0x1132,0x1153,0x0973,0x0974,0x11B6,0x1A17,0x1A17,0x11B6,0x1154,0x1132,0x1911,0x1910,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x20EF,0x210F,0x20EF,0x2910,0x2910,0x2110,0x2130,0x2110,0x2110,0x2130,0x1931,0x1932,0x0913,0x19D7,0x1A19,0x19F8,0x19B7,0x10F3,0x18F2,0x1911,0x2130,0x2130,0x2130,0x18EF,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2110,0x2110,0x2131,0x1931,0x1132,0x0933,0x19B6,0x19D7,0x19F7,0x19B6,0x1132,0x1131,0x1931,0x1930,0x2131,0x1931,0x1112,0x0913,0x11B6,0x11F7,0x1A18,0x19D7,0x1133,0x1912,0x2111,0x2111,0x2110,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x214F,0x192F,0x1930,0x1910,0x10F0,0x2153,0x2174,0x2195,0x2195,0x1996,0x19B6,0x0975,0x0954,0x0913,0x0912,0x1131,0x1930,0x2110,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x1930,0x1930,0x1910,0x1930,0x1931,0x1111,0x08F2,0x19F6,0x11F7,0x11F7,0x11B5,0x0912,0x1932,0x2131,0x2130,0x2110,0x2110,0x2110,0x2110,0x2131,0x1931,0x1132,0x1994,0x19F7,0x19D7,0x11B7,0x0975,0x1154,0x1153,0x1931,0x1931,0x1910,0x2110,0x210F,0x210F,0x292F,0x292F,0x292F,0x2930,0x2110,0x2930,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2910,0x2930,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2110,0x2910,0x2930,0x2110,0x212F,0x212F,0x212F,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2131,0x2131,0x1912,0x08F2,0x1994,0x21F6,0x29F6,0x1995,0x1113,0x1132,0x1932,0x1132,0x1132,0x1132,0x1132,0x0933,0x1995,0x19B6,0x21F6,0x19B5,0x0912,0x1932,0x1931,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x290F,0x210F,0x210F,0x2930,0x2910,0x20F0,0x18F1,0x10F2,0x0934,0x0955,0x0176,0x0176,0x0196,0x0197,0x0176,0x0976,0x0955,0x0934,0x1113,0x1133,0x1932,0x1911,0x1911,0x1910,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210E,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x2130,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x20EF,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x20EF,0x2110,0x210F,0x210F,0x2130,0x2130,0x2150,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x20EF,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2110,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x20EF,0x210F,0x20EF,0x20EF,0x20EF,0x210F,0x20EF,0x210F,0x190F,0x1910,0x1910,0x1910,0x1910,0x1911,0x10F1,0x1133,0x11D7,0x09D8,0x09FA,0x01DA,0x01BA,0x01BA,0x01BA,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01BA,0x01DA,0x01D9,0x01B9,0x01DA,0x01B9,0x01B9,0x01DA,0x01BA,0x01BA,0x01DA,0x01DA,0x01BA,0x01BA,0x01DA,0x01B9,0x01D9,0x01DA,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01B9,0x01B8,0x11D9,0x19D7,0x08B1,0x18D0,0x20F0,0x20EF,0x20EE,0x210E,0x20EE,0x20EE,0x210F,0x210F,0x210F,0x20EF,0x20EF,0x20EF,0x18EF,0x18EF,
  0x20EF,0x20EF,0x20EF,0x20EF,0x210F,0x18EE,0x20EE,0x20EE,0x20EE,0x20EE,0x20EE,0x20EE,0x210F,0x210E,0x210E,0x210E,0x212F,0x190E,0x212E,0x190E,0x190E,0x190E,0x190E,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x190F,0x210F,0x210F,0x210F,0x20EE,0x210F,0x20EE,0x210F,0x210E,0x210F,0x20EE,0x210E,0x210E,0x210F,0x20EE,0x210E,0x210E,0x210F,0x20EE,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x20EF,0x28EF,0x28EF,0x290F,0x2910,0x2110,0x1931,0x1132,0x0933,0x0975,0x0177,0x01B8,0x01D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01D9,0x01F9,0x01D8,0x01D8,0x0997,0x0955,0x0913,0x1113,0x1932,0x1911,0x2111,0x20F0,0x2910,0x2910,0x28EF,0x20EF,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2910,0x2110,0x2910,0x2110,0x2110,0x210F,0x2130,0x210F,0x210F,0x210F,0x2130,0x212F,0x212F,0x210F,0x210F,0x2110,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2130,0x210F,0x212F,0x210F,0x2930,0x210F,0x212F,0x210F,0x2930,0x2110,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2111,0x2131,0x1932,0x1933,0x1174,0x1195,0x19F7,0x19F7,0x11D6,0x1195,0x0954,0x0933,0x0912,0x0912,0x10F1,0x1111,0x1110,0x1110,0x1910,0x1911,0x1910,0x1931,0x1910,0x1910,0x1910,0x1930,0x1910,0x1910,0x1910,0x1910,0x2110,0x2110,0x1910,0x1910,0x1910,0x1910,0x1910,0x1910,0x1931,0x1931,0x1110,0x1110,0x1910,0x1110,0x1910,0x1931,0x1910,0x1911,0x1111,0x1111,0x0912,0x0933,0x0134,0x1196,0x09B7,0x09D7,0x09D7,0x11F8,0x09F8,0x09F8,0x09D8,0x09B7,0x09D8,0x09D8,0x09D8,0x09D7,0x09B7,0x1175,0x1133,0x1112,0x1932,0x1910,0x2110,0x210F,0x212F,0x212F,0x212F,0x190F,0x212F,0x210F,0x212F,0x210F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2910,0x2110,0x2910,0x2910,0x2910,0x290F,0x2910,0x2910,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2131,0x1931,0x1932,0x1133,0x1174,0x1195,0x11B6,0x19D7,0x19D7,0x11B7,0x19D7,0x1175,0x0912,0x1132,0x1932,0x1931,0x2131,0x2110,0x2130,0x210F,0x210F,0x210F,0x290F,0x20EE,0x210F,0x210F,0x290F,0x290F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x1932,0x1133,0x1195,0x11D6,0x11F7,0x11F7,0x11B6,0x0974,0x0953,0x0953,0x0953,0x0953,0x0954,0x0975,0x09D6,0x11F7,0x11D7,0x11B6,0x1974,0x1932,0x1911,0x2111,0x2131,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2111,0x2131,0x2132,0x1932,0x1154,0x1995,0x19D7,0x19D7,0x11B6,0x0954,0x0932,0x1131,0x1951,0x1931,0x1911,0x1112,0x1954,0x19B6,0x19F8,0x11F8,0x0997,0x0956,0x0934,0x0913,0x0913,0x1133,0x0934,0x0955,0x0996,0x11D7,0x11F8,0x11F7,0x11B5,0x1174,0x1153,0x1132,0x1132,0x1132,0x1153,0x0953,0x0974,0x11B6,0x1A17,0x19F7,0x1195,0x1134,0x1132,0x1911,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x20EF,0x2910,0x290F,0x2110,0x210F,0x2110,0x2130,0x2130,0x1931,0x1111,0x0913,0x19F7,0x19F8,0x19F8,0x1996,0x1113,0x1912,0x1911,0x1910,0x2130,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x210F,0x2110,0x2130,0x2130,0x1931,0x1132,0x0933,0x19B6,0x19D7,0x19F7,0x19B5,0x1132,0x1111,0x1931,0x1910,0x2131,0x1931,0x1112,0x0912,0x11B6,0x11F7,0x1A18,0x19D6,0x1113,0x1912,0x2111,0x2110,0x2110,0x2110,0x2110,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x210F,0x2930,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x292F,0x292F,0x210F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2130,0x212F,0x212F,0x212F,0x192F,0x190F,0x1910,0x1911,0x2152,0x2153,0x2174,0x1975,0x21B6,0x19B6,0x11B6,0x1195,0x0933,0x1132,0x1932,0x1930,0x2130,0x210F,0x210F,0x210F,0x2130,0x210F,0x212F,0x1930,0x2130,0x1930,0x2130,0x1931,0x1131,0x0912,0x19D6,0x11F7,0x11F7,0x1195,0x0912,0x1932,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x1931,0x1932,0x1153,0x19D7,0x19F8,0x11B7,0x1176,0x1154,0x1153,0x1932,0x1931,0x2130,0x190F,0x210F,0x210F,0x210F,0x212F,0x2930,0x210F,0x2930,0x2930,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2110,0x2930,0x2910,0x2910,0x2910,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2930,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x2930,0x210F,0x210F,0x290F,0x212F,0x210F,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2131,0x2131,0x1912,0x08F2,0x1994,0x21D6,0x29F6,0x1994,0x1112,0x1132,0x1952,0x1132,0x1932,0x1132,0x1133,0x0933,0x1995,0x19D6,0x21F6,0x1995,0x0912,0x1132,0x1931,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x210F,0x2930,0x210F,0x2110,0x2111,0x1912,0x1133,0x1175,0x0996,0x0997,0x09B7,0x01B7,0x01B7,0x0197,0x0997,0x0976,0x0934,0x1133,0x1133,0x1932,0x1931,0x1931,0x2131,0x2130,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x292F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x212F,0x212F,0x2130,0x212F,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x210F,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2110,0x210F,0x20EF,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x20EF,0x210F,0x210F,0x210F,0x20EF,0x210F,0x20EF,0x210F,0x20EF,0x210F,0x20EF,0x210F,0x20EF,0x20EF,0x210F,0x210F,0x210F,0x18EF,0x190F,0x1910,0x1910,0x1910,0x1911,0x10F1,0x0913,0x11D7,0x09F9,0x01D9,0x01BA,0x01BA,0x01BA,0x01BA,0x01BA,0x01DA,0x01DA,0x01BA,0x01DA,0x01BA,0x01BA,0x01B9,0x01DA,0x01B9,0x01B9,0x01B9,0x01B9,0x01B9,0x01BA,0x01BA,0x01DA,0x01BA,0x01BA,0x01BA,0x01BA,0x01BA,0x01BA,0x01B9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01B8,0x11F9,0x11B7,0x08D2,0x18D0,0x20F0,0x20EF,0x20EF,0x20EE,0x20EE,0x20EE,0x210F,0x210F,0x210F,0x20EF,0x20EF,0x20EF,0x20EF,0x18EF,
  0x210F,0x20EF,0x20EF,0x20EF,0x210F,0x210F,0x20EE,0x210F,0x20EE,0x210E,0x20EE,0x20EF,0x20EE,0x20EE,0x210E,0x210E,0x210E,0x212F,0x210F,0x212F,0x190E,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210E,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x292F,0x210F,0x292F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2110,0x2130,0x212F,0x210F,0x212F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2110,0x1911,0x1953,0x1154,0x0996,0x09B8,0x01D8,0x01D9,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01D9,0x01F9,0x01D9,0x01D9,0x01D8,0x09D8,0x11D7,0x1195,0x1133,0x2153,0x2111,0x20F0,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x292F,0x210F,0x2930,0x2130,0x210F,0x2130,0x2130,0x2110,0x2130,0x2110,0x2910,0x2910,0x2910,0x2910,0x210F,0x2110,0x210F,0x212F,0x2130,0x212F,0x2930,0x2130,0x2930,0x212F,0x2930,0x2930,0x2130,0x2930,0x2110,0x210F,0x2930,0x210F,0x2930,0x290F,0x212F,0x210F,0x2930,0x2930,0x2930,0x212F,0x212F,0x2930,0x2930,0x290F,0x212F,0x292F,0x212F,0x2930,0x2130,0x210F,0x2130,0x210F,0x2130,0x2130,0x2110,0x2131,0x1911,0x1932,0x1953,0x1994,0x1195,0x19D6,0x19D6,0x19D6,0x1196,0x0954,0x0933,0x0912,0x08F1,0x08F1,0x08F0,0x08F0,0x10F1,0x10F0,0x10F0,0x10F0,0x10F0,0x10F0,0x10F0,0x10F0,0x1111,0x1111,0x1111,0x10F1,0x10F1,0x18F1,0x10F1,0x1111,0x10F1,0x1911,0x1111,0x10F1,0x1111,0x1111,0x08F0,0x08F1,0x1111,0x10F1,0x10F1,0x10F1,0x10F0,0x10F1,0x08F1,0x0911,0x0912,0x0933,0x0975,0x0996,0x1218,0x09D7,0x11D7,0x09D7,0x0996,0x0997,0x0196,0x0176,0x09B7,0x09D8,0x1219,0x11F8,0x11B7,0x1175,0x1113,0x1912,0x1931,0x2131,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2930,0x210F,0x2110,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x210F,0x2110,0x2110,0x2130,0x2130,0x210F,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2930,0x2110,0x2910,0x2910,0x2930,0x2910,0x210F,0x290F,0x2910,0x2910,0x2910,0x210F,0x2910,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2930,0x2930,0x2910,0x2910,0x2110,0x2110,0x2130,0x2151,0x1931,0x1932,0x1133,0x1154,0x1175,0x19B6,0x19D7,0x19D7,0x19B6,0x19D6,0x1995,0x0912,0x1111,0x1931,0x2151,0x2130,0x2150,0x2130,0x210F,0x210F,0x210F,0x290F,0x292F,0x292F,0x292F,0x290F,0x210F,0x212F,0x2110,0x2930,0x2930,0x2130,0x2130,0x2110,0x2110,0x2131,0x1911,0x1932,0x1174,0x19D6,0x19F7,0x1A17,0x11B6,0x0995,0x0933,0x0954,0x0953,0x0954,0x0954,0x0975,0x0996,0x11D7,0x11D7,0x11B6,0x1974,0x1932,0x1911,0x2111,0x2131,0x2130,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2950,0x2130,0x2110,0x2110,0x2131,0x2131,0x2132,0x1932,0x1954,0x1995,0x19B6,0x19D7,0x11B6,0x0974,0x0912,0x1131,0x1951,0x1951,0x1931,0x1932,0x1953,0x19B6,0x19D7,0x11D8,0x0997,0x0976,0x0954,0x0913,0x0913,0x0913,0x0934,0x0954,0x0996,0x11D7,0x19F7,0x19F7,0x11B5,0x1174,0x1152,0x1132,0x1131,0x1132,0x1132,0x1173,0x0974,0x11D6,0x1A17,0x19F7,0x1175,0x1133,0x1112,0x1911,0x2131,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x2130,0x2110,0x2130,0x2131,0x1932,0x0933,0x19F7,0x1A18,0x1A18,0x1196,0x1113,0x1911,0x1931,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x1910,0x1911,0x1132,0x1153,0x11B6,0x19D7,0x19F7,0x19B6,0x1132,0x1111,0x2131,0x2130,0x1931,0x1911,0x1112,0x1113,0x1195,0x11F7,0x1A18,0x19D6,0x1112,0x1912,0x2111,0x2110,0x2130,0x2130,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x290F,0x290F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x1911,0x1932,0x1953,0x1933,0x1954,0x1995,0x21D6,0x11B6,0x1195,0x1174,0x1133,0x1952,0x1931,0x2130,0x2110,0x210F,0x210F,0x2130,0x2930,0x212F,0x212F,0x2130,0x1930,0x2130,0x1931,0x1932,0x1132,0x11D6,0x11D6,0x11F7,0x1195,0x1112,0x1931,0x2131,0x2131,0x20F0,0x2110,0x2110,0x2130,0x2110,0x1931,0x1932,0x1153,0x19B5,0x19F7,0x19D7,0x19B7,0x1175,0x1133,0x1132,0x1951,0x2131,0x2130,0x2130,0x210F,0x210F,0x212F,0x2930,0x2910,0x2930,0x2930,0x2930,0x2910,0x2910,0x2930,0x2910,0x2910,0x210F,0x210F,0x2910,0x210F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2910,0x2910,0x2110,0x2110,0x2930,0x2910,0x2110,0x2110,0x2910,0x2930,0x2910,0x2910,0x2910,0x2930,0x210F,0x212F,0x210F,0x2930,0x212F,0x210F,0x2110,0x2110,0x2130,0x2930,0x210F,0x210F,0x290F,0x210F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2131,0x2131,0x1932,0x1112,0x1974,0x21F6,0x2A17,0x1994,0x1112,0x1112,0x1932,0x1932,0x1932,0x1132,0x1132,0x1133,0x1995,0x21D6,0x21F6,0x1194,0x1132,0x1132,0x1932,0x2131,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x2130,0x2130,0x2110,0x2130,0x2130,0x2132,0x1953,0x1995,0x1196,0x11F8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x11B7,0x1196,0x1154,0x1112,0x1932,0x1931,0x2131,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x2910,0x2930,0x210F,0x210F,0x2130,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2110,0x210F,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x210F,0x210F,0x212F,0x212F,0x210F,0x2910,0x2910,0x210F,0x2930,0x210F,0x210F,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x290F,0x2930,0x2930,0x2930,0x2110,0x290F,0x290F,0x210F,0x292F,0x210F,0x210F,0x292F,0x290F,0x292F,0x2930,0x2930,0x2130,0x210F,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x210F,0x18EF,0x2130,0x2110,0x1910,0x1910,0x1111,0x0912,0x11D7,0x09D8,0x01D9,0x01BA,0x01BA,0x01BA,0x01BA,0x01DA,0x01DA,0x01DA,0x01BA,0x01DA,0x01B9,0x01BA,0x01B9,0x01DA,0x01B9,0x01B9,0x01B9,0x01BA,0x01B9,0x01DA,0x01BA,0x01BA,0x01DA,0x01DA,0x01BA,0x01BA,0x01BA,0x01BA,0x01DA,0x01DA,0x01D9,0x01F9,0x01B9,0x01B9,0x01B9,0x0198,0x11F9,0x11B6,0x08D1,0x18F0,0x2110,0x210F,0x20EE,0x210E,0x20EE,0x20EE,0x20EE,0x20EE,0x210F,0x210F,0x210F,0x20EE,0x18EE,0x210F,
  0x210F,0x20EF,0x210F,0x210F,0x20EE,0x210E,0x210F,0x210E,0x210E,0x210E,0x210E,0x210E,0x20EE,0x210E,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210E,0x212F,0x210E,0x210F,0x210E,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210E,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x290F,0x210F,0x210F,0x2130,0x2110,0x2130,0x212F,0x212F,0x212F,0x292F,0x292F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2110,0x1911,0x1133,0x11B5,0x11F8,0x09D8,0x09F9,0x01D9,0x01D9,0x01B9,0x01DA,0x01FA,0x01DA,0x01FA,0x01F9,0x01D9,0x0A1A,0x01F9,0x09F8,0x11F8,0x19D7,0x1133,0x1932,0x2111,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x292F,0x290F,0x212F,0x2930,0x210F,0x2130,0x2130,0x210F,0x2130,0x210F,0x2110,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2130,0x210F,0x2130,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x290F,0x2930,0x2930,0x210F,0x210F,0x2930,0x210F,0x2930,0x210F,0x290F,0x2930,0x292F,0x212F,0x2130,0x210F,0x212F,0x2130,0x212F,0x292F,0x2930,0x2110,0x2130,0x2111,0x1931,0x1932,0x1932,0x1953,0x1974,0x1195,0x19B6,0x19D6,0x19D7,0x19D7,0x19B6,0x19B5,0x1154,0x1153,0x1153,0x0932,0x1132,0x0912,0x1133,0x1132,0x1132,0x1132,0x1153,0x1153,0x1153,0x1132,0x1153,0x1953,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1153,0x1133,0x0933,0x0933,0x0933,0x1133,0x1133,0x1133,0x1132,0x1133,0x1132,0x1133,0x0933,0x0954,0x0975,0x0996,0x11D7,0x11D7,0x09D7,0x09B7,0x0996,0x0976,0x0155,0x0156,0x0156,0x0176,0x09B7,0x11F8,0x11F8,0x11D7,0x1196,0x1153,0x1932,0x2131,0x2131,0x2130,0x2130,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2910,0x2910,0x2110,0x2130,0x212F,0x212F,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x2130,0x2130,0x2110,0x2110,0x2930,0x2930,0x212F,0x212F,0x2930,0x210F,0x210F,0x2130,0x210F,0x2930,0x2130,0x210F,0x212F,0x2130,0x212F,0x212F,0x2930,0x2130,0x2130,0x2130,0x212F,0x210F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2930,0x2930,0x2110,0x2930,0x2910,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2930,0x2110,0x2110,0x2130,0x2110,0x2130,0x1931,0x1931,0x1932,0x1133,0x1134,0x1154,0x19B6,0x19B6,0x19D7,0x19D6,0x19D6,0x1994,0x0912,0x1111,0x1931,0x2151,0x2151,0x2130,0x2110,0x290F,0x290F,0x290F,0x292F,0x3150,0x292F,0x210F,0x210F,0x212F,0x2110,0x2930,0x2930,0x2130,0x2930,0x2130,0x2110,0x2110,0x1911,0x1932,0x1153,0x19B6,0x19F7,0x1A17,0x11D7,0x1196,0x0954,0x0954,0x0954,0x0954,0x0974,0x0975,0x09B6,0x11D7,0x11D7,0x1196,0x1974,0x1932,0x2131,0x2131,0x2130,0x2130,0x2930,0x2950,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2930,0x2930,0x2130,0x2130,0x2130,0x2150,0x2950,0x2130,0x2130,0x2130,0x2110,0x2131,0x1911,0x1932,0x1974,0x1995,0x19D7,0x19D7,0x11B7,0x1175,0x0932,0x1131,0x1931,0x1951,0x1931,0x1932,0x1133,0x1995,0x11B6,0x11D7,0x11F7,0x11B7,0x0975,0x0954,0x0934,0x0934,0x0934,0x0955,0x0996,0x11D7,0x11F7,0x1A17,0x11B5,0x1173,0x1952,0x1931,0x1131,0x1132,0x1152,0x1153,0x0974,0x11D6,0x19F7,0x19F7,0x1195,0x1133,0x1112,0x1911,0x2111,0x2110,0x2130,0x2130,0x2130,0x2930,0x210F,0x290F,0x292F,0x2930,0x2930,0x2110,0x2130,0x2930,0x2930,0x210F,0x292F,0x292F,0x290F,0x292F,0x290F,0x290F,0x2930,0x2930,0x2110,0x2110,0x2130,0x1931,0x1932,0x0913,0x19F7,0x1A18,0x19F8,0x19B6,0x1132,0x1911,0x2131,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,0x290F,0x212F,0x2130,0x2110,0x2110,0x2130,0x1931,0x1932,0x1133,0x19B6,0x19D7,0x19F7,0x19D6,0x1112,0x1911,0x2131,0x2130,0x2131,0x1931,0x1912,0x1112,0x11B6,0x11F7,0x1A17,0x19D6,0x1112,0x1912,0x1911,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2130,0x212F,0x210F,0x210F,0x2110,0x212F,0x210F,0x212F,0x2930,0x210F,0x210F,0x210F,0x2930,0x212F,0x210F,0x212F,0x212F,0x212F,0x2930,0x290F,0x290F,0x210F,0x290F,0x292F,0x292F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x2150,0x2130,0x1910,0x1911,0x1912,0x1932,0x1933,0x1974,0x21D6,0x19D6,0x1195,0x19D5,0x1173,0x1952,0x1931,0x1930,0x2110,0x210F,0x2130,0x2930,0x2130,0x212F,0x212F,0x2130,0x2150,0x2130,0x1931,0x1932,0x0912,0x19D6,0x11F7,0x19F7,0x1195,0x1112,0x1931,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x1910,0x1911,0x1132,0x1174,0x19D6,0x19F7,0x19D7,0x19D6,0x1154,0x1132,0x1952,0x1931,0x2151,0x2130,0x2110,0x210F,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2910,0x2930,0x2910,0x2910,0x290F,0x210F,0x290F,0x210F,0x290F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x2910,0x2930,0x2910,0x210F,0x210F,0x2930,0x210F,0x2930,0x2930,0x212F,0x2110,0x2110,0x2130,0x210F,0x2930,0x212F,0x210F,0x290F,0x292F,0x292F,0x212F,0x212F,0x212F,0x2150,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2111,0x2131,0x1932,0x1112,0x1974,0x21D6,0x2A17,0x1995,0x1132,0x1132,0x1932,0x1932,0x1932,0x1932,0x1133,0x1133,0x19B5,0x21D6,0x21F6,0x19B4,0x1132,0x1932,0x1931,0x2131,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x2110,0x2131,0x1953,0x1994,0x11B6,0x11D8,0x09F9,0x09D8,0x09F9,0x01F9,0x09F9,0x01D8,0x09D8,0x09D7,0x19D7,0x19B6,0x1153,0x1932,0x1932,0x2152,0x2131,0x2151,0x2151,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x210F,0x2930,0x210F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2130,0x2110,0x2930,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2950,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2950,0x212F,0x2930,0x2930,0x2110,0x2130,0x2130,0x2930,0x210F,0x210F,0x292F,0x290F,0x292F,0x290F,0x292F,0x292F,0x290F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2930,0x212F,0x212F,0x210F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x290F,0x292F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x1910,0x10F0,0x08F2,0x11D7,0x09D8,0x01D9,0x01DA,0x01BA,0x01DA,0x01BA,0x01BA,0x01DA,0x01BA,0x01DA,0x01B9,0x01B9,0x01BA,0x01BA,0x01BA,0x01BA,0x01B9,0x01DA,0x01B9,0x01DA,0x01BA,0x01BA,0x01DA,0x01BA,0x01DA,0x01BA,0x01BA,0x01BA,0x01DA,0x01BA,0x01D9,0x01D9,0x01D9,0x01D9,0x01B9,0x01D9,0x09D9,0x11D8,0x11B6,0x08F1,0x18F0,0x2110,0x210F,0x210F,0x210E,0x20EE,0x210E,0x210F,0x210E,0x20EF,0x20EF,0x210F,0x20EE,0x210E,0x210E,
  0x210F,0x210F,0x20EF,0x20EE,0x210F,0x210F,0x20EE,0x210E,0x210E,0x20EE,0x210E,0x210F,0x210F,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210E,0x210E,0x210E,0x210E,0x210F,0x210F,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x212F,0x212F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x290F,0x290F,0x210F,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,0x2930,0x290F,0x2930,0x2930,0x2110,0x10F1,0x1153,0x11D6,0x11F8,0x09D8,0x09F9,0x01D9,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01D9,0x01FA,0x01D9,0x01F9,0x01D9,0x09F9,0x09D8,0x19F7,0x1154,0x1912,0x2111,0x2110,0x2910,0x28EF,0x290F,0x28EF,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x210F,0x210F,0x2110,0x2910,0x210F,0x212F,0x212F,0x212F,0x210F,0x2930,0x210F,0x210F,0x210F,0x212F,0x2130,0x2930,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x210F,0x2910,0x210F,0x210F,0x210F,0x20EF,0x2930,0x2130,0x210F,0x210F,0x212F,0x210F,0x212F,0x292F,0x2930,0x2130,0x2130,0x2130,0x2131,0x1911,0x1931,0x1932,0x1953,0x1174,0x19B5,0x19B6,0x11B6,0x19B7,0x19D7,0x19F7,0x19D7,0x19F7,0x19F7,0x19D6,0x19D7,0x19D6,0x19B6,0x11B6,0x11B6,0x11B6,0x1196,0x1195,0x1196,0x11B6,0x1195,0x1195,0x1195,0x1196,0x1195,0x1195,0x1196,0x19B6,0x1196,0x11B6,0x11B6,0x11B6,0x11B6,0x1196,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19D6,0x19D6,0x11D7,0x11B7,0x11D7,0x11D8,0x11D8,0x11B7,0x0996,0x0976,0x0996,0x0155,0x0155,0x0135,0x0156,0x0996,0x11D7,0x11F8,0x19D7,0x19B6,0x1974,0x1932,0x1911,0x2110,0x2130,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2110,0x2110,0x2930,0x210F,0x2930,0x212F,0x212F,0x212F,0x210F,0x210F,0x2930,0x212F,0x2130,0x2110,0x2110,0x210F,0x290F,0x210F,0x2930,0x2110,0x2110,0x2110,0x210F,0x212F,0x212F,0x210F,0x2930,0x2930,0x212F,0x210F,0x2930,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x212F,0x212F,0x2930,0x212F,0x290F,0x2930,0x2930,0x210F,0x210F,0x2910,0x210F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x2910,0x2930,0x2930,0x212F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x1910,0x1911,0x1932,0x1112,0x1153,0x1995,0x1995,0x21D6,0x21F7,0x19D6,0x19D6,0x1974,0x1112,0x1111,0x1931,0x2131,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2110,0x2130,0x2950,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1153,0x1174,0x19F7,0x1A17,0x11D7,0x11B7,0x0976,0x0955,0x0975,0x0975,0x0975,0x1196,0x11D7,0x11D7,0x11D7,0x1996,0x1953,0x1932,0x2131,0x2111,0x2110,0x2130,0x2130,0x2130,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x210F,0x2130,0x2930,0x2130,0x2110,0x2110,0x2130,0x2131,0x1911,0x1953,0x1995,0x19D7,0x19F7,0x19D7,0x1195,0x0933,0x1132,0x1951,0x1951,0x1951,0x1932,0x1932,0x1154,0x1195,0x11D7,0x11D7,0x11D7,0x11B7,0x0975,0x0955,0x0955,0x0975,0x0996,0x11B6,0x11D7,0x19F7,0x19D6,0x1994,0x1153,0x1952,0x1951,0x1911,0x1132,0x1153,0x1173,0x11B5,0x1A17,0x19F7,0x19F7,0x1195,0x1154,0x1112,0x1911,0x2111,0x2110,0x2130,0x2130,0x210F,0x2930,0x2930,0x290F,0x2910,0x2930,0x2930,0x2110,0x2110,0x2130,0x2930,0x2930,0x210F,0x210F,0x210F,0x292F,0x292F,0x290F,0x2930,0x2130,0x2130,0x2110,0x2110,0x1931,0x1912,0x1113,0x19D7,0x19F8,0x19F8,0x1196,0x1112,0x1911,0x1911,0x2110,0x2150,0x2130,0x210F,0x212F,0x212F,0x292F,0x290F,0x290F,0x210F,0x2930,0x2130,0x2110,0x2130,0x1931,0x1932,0x1133,0x19B6,0x19D7,0x19F8,0x19B6,0x08F2,0x1111,0x1931,0x2131,0x2131,0x1932,0x1932,0x1112,0x11B6,0x19F7,0x1A38,0x19D6,0x1112,0x1912,0x2111,0x2110,0x2130,0x2110,0x2110,0x2130,0x212F,0x212F,0x2930,0x2110,0x210F,0x210F,0x2930,0x210F,0x212F,0x212F,0x2930,0x2110,0x212F,0x212F,0x212F,0x2930,0x210F,0x2930,0x210F,0x2110,0x210F,0x210F,0x212F,0x212F,0x2930,0x210F,0x2930,0x290F,0x210F,0x210F,0x290F,0x210F,0x2930,0x212F,0x2130,0x2130,0x2130,0x2930,0x2110,0x2930,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2150,0x2130,0x1910,0x1931,0x1932,0x1912,0x1932,0x1953,0x19B5,0x19B6,0x1195,0x19F6,0x19D5,0x1973,0x1952,0x1931,0x1910,0x2110,0x2130,0x2110,0x2930,0x212F,0x212F,0x212F,0x212F,0x2130,0x2131,0x1932,0x1112,0x19D6,0x11F7,0x1A17,0x1195,0x1111,0x2152,0x2151,0x2951,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x1931,0x1932,0x1153,0x1995,0x19D7,0x19F7,0x19D7,0x19B6,0x1154,0x1133,0x1952,0x2152,0x2151,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x2130,0x2110,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x292F,0x290F,0x2130,0x2110,0x2110,0x2130,0x2950,0x212F,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x2110,0x2930,0x210F,0x210F,0x210F,0x2110,0x2910,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x290F,0x2930,0x210F,0x2130,0x212F,0x212F,0x210F,0x210F,0x2930,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2111,0x1932,0x1932,0x1112,0x1974,0x21F6,0x2A17,0x1994,0x1112,0x1132,0x1932,0x1932,0x1932,0x1132,0x1152,0x1153,0x19B5,0x21F6,0x2216,0x1994,0x0912,0x1932,0x1931,0x2131,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2930,0x2130,0x2130,0x2131,0x1931,0x1932,0x1994,0x19B6,0x11D7,0x09D8,0x09F9,0x01F9,0x01F9,0x01D9,0x01D9,0x01F9,0x01D8,0x09D8,0x11D8,0x19D7,0x1975,0x1953,0x1952,0x1952,0x1931,0x1931,0x2131,0x1931,0x2131,0x2130,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2931,0x2931,0x2931,0x2130,0x2131,0x2131,0x2131,0x2130,0x2931,0x2930,0x2130,0x2130,0x2130,0x2130,0x2131,0x2130,0x2131,0x2130,0x2130,0x2130,0x2931,0x2131,0x2130,0x2131,0x2131,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2110,0x2131,0x2131,0x2130,0x2130,0x2131,0x2110,0x2130,0x2130,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x292F,0x290F,0x292F,0x292F,0x292F,0x2930,0x2910,0x2110,0x2110,0x2110,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2110,0x2110,0x2130,0x2110,0x10F0,0x08F2,0x19F7,0x1219,0x01B9,0x01BA,0x0199,0x01BA,0x01DA,0x01DA,0x01BA,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01B9,0x01BA,0x01BA,0x01B9,0x01DA,0x01DA,0x01FA,0x01DA,0x01B9,0x01B9,0x01BA,0x01DA,0x01BA,0x01BA,0x01BA,0x01BA,0x01DA,0x01D9,0x01FA,0x01F9,0x01D9,0x01B9,0x01D9,0x09D9,0x1219,0x1196,0x08D1,0x18F0,0x2110,0x210F,0x210F,0x212F,0x20EE,0x20EE,0x20EE,0x210F,0x20EF,0x20EE,0x210F,0x210E,0x210E,0x210E,
  0x210F,0x190F,0x210F,0x210E,0x210E,0x210E,0x210E,0x20EE,0x210E,0x210E,0x210E,0x210E,0x210F,0x210E,0x210F,0x210F,0x210F,0x20EF,0x20EF,0x210F,0x210F,0x210F,0x210E,0x210E,0x210E,0x210E,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x290F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x292F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x292F,0x290F,0x2930,0x290F,0x2930,0x2130,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x2930,0x2910,0x2910,0x2110,0x2110,0x10F1,0x1154,0x11B6,0x11F8,0x09F9,0x01F9,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01D9,0x01DA,0x01FA,0x01D9,0x01FA,0x01F9,0x01D9,0x09D8,0x11D7,0x1175,0x1112,0x2131,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x292F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2130,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x2130,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2910,0x2110,0x2110,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x1930,0x1931,0x1931,0x1932,0x1953,0x1974,0x1995,0x1996,0x19B6,0x19D7,0x11D7,0x19D7,0x11D7,0x1A18,0x1A18,0x2238,0x1A18,0x2238,0x1A18,0x2238,0x1A18,0x1A18,0x1A38,0x19F8,0x1A18,0x2218,0x2218,0x1A18,0x1A18,0x2218,0x2218,0x1A18,0x1A18,0x1A18,0x19F8,0x19F8,0x19F8,0x1A19,0x1A39,0x2239,0x19F8,0x21F8,0x19D7,0x21F8,0x19F7,0x19F7,0x19F7,0x19F7,0x11F8,0x11D8,0x11D8,0x09B8,0x0997,0x0976,0x0955,0x0955,0x0135,0x0135,0x0135,0x0955,0x0976,0x11B7,0x19F8,0x19D7,0x19B6,0x1994,0x1932,0x1911,0x2110,0x2110,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x2930,0x210F,0x210F,0x2910,0x2110,0x2930,0x212F,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x2110,0x2930,0x210F,0x290F,0x290F,0x2910,0x2930,0x2110,0x2110,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x2930,0x210F,0x290F,0x2930,0x2910,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2130,0x2930,0x2930,0x2110,0x2110,0x2110,0x2910,0x2930,0x2110,0x2910,0x2110,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x210F,0x2130,0x2110,0x2130,0x1931,0x1911,0x1932,0x1153,0x1974,0x19B5,0x19D6,0x19D6,0x19D6,0x21D6,0x1174,0x1133,0x1112,0x1931,0x2131,0x2131,0x2130,0x2930,0x292F,0x210F,0x210F,0x290F,0x2930,0x2930,0x210F,0x210F,0x210F,0x2130,0x2950,0x2130,0x2130,0x2130,0x2130,0x1931,0x1911,0x1953,0x1174,0x19D6,0x1A17,0x11D7,0x11B7,0x1197,0x1196,0x0996,0x0996,0x11B6,0x11B6,0x11D7,0x11D7,0x19B7,0x1975,0x1953,0x1911,0x1911,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x1911,0x1953,0x1994,0x19B6,0x19D7,0x19D7,0x1196,0x1153,0x1132,0x1131,0x1931,0x1931,0x1931,0x1952,0x1153,0x1195,0x19D6,0x11F7,0x1218,0x09D7,0x09B6,0x0976,0x0996,0x0996,0x09B6,0x11D6,0x19F6,0x19D6,0x1194,0x1973,0x1952,0x1952,0x1931,0x1932,0x1932,0x1133,0x1153,0x1195,0x19F7,0x19F7,0x19D6,0x1175,0x1154,0x1112,0x1911,0x2111,0x2110,0x2130,0x2130,0x2110,0x2110,0x210F,0x2930,0x2930,0x2930,0x2930,0x210F,0x2110,0x2930,0x2110,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2130,0x2110,0x2110,0x2130,0x2130,0x1911,0x1912,0x0912,0x19D7,0x1A18,0x19F8,0x1175,0x1132,0x1911,0x1910,0x2110,0x2130,0x2130,0x2130,0x2930,0x212F,0x2930,0x210F,0x212F,0x210F,0x2130,0x2130,0x2110,0x2130,0x1930,0x1111,0x1153,0x11B6,0x11D7,0x19F8,0x19B6,0x10F2,0x10F1,0x2111,0x2111,0x2131,0x1932,0x1912,0x1112,0x11B5,0x11F7,0x1A17,0x19D6,0x1112,0x1911,0x2111,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2930,0x210F,0x2110,0x210F,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x2110,0x212F,0x212F,0x210F,0x212F,0x290F,0x290F,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x212F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x190F,0x2130,0x1931,0x1931,0x1932,0x1932,0x1132,0x1153,0x1174,0x1174,0x2216,0x19F6,0x1174,0x1152,0x1952,0x1931,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1911,0x0912,0x19D6,0x11D6,0x19D6,0x1195,0x1111,0x1931,0x2151,0x2130,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x1911,0x1911,0x1932,0x1153,0x19B6,0x21F7,0x19F7,0x19D7,0x19B6,0x1154,0x1133,0x1932,0x2132,0x2131,0x2131,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x210F,0x292F,0x290F,0x292F,0x290F,0x292F,0x290F,0x210F,0x212F,0x2130,0x210F,0x2130,0x212F,0x210F,0x2130,0x212F,0x210F,0x290F,0x210F,0x2930,0x210F,0x2110,0x290F,0x210F,0x210F,0x2110,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x290F,0x2910,0x210F,0x2910,0x290F,0x290F,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x210F,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2131,0x1931,0x1932,0x1112,0x1974,0x21B6,0x2A17,0x1995,0x1112,0x1132,0x1932,0x1932,0x1952,0x1932,0x1132,0x1153,0x1994,0x21D6,0x21F6,0x1994,0x0912,0x1932,0x1931,0x1910,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x1174,0x11B6,0x09B8,0x09D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x09D8,0x09B8,0x11D8,0x19B6,0x1174,0x1953,0x1932,0x1932,0x1931,0x1911,0x1931,0x1931,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2151,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2151,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x1931,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2131,0x2111,0x2111,0x2131,0x2130,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x210F,0x210F,0x212F,0x2930,0x210F,0x290F,0x2930,0x210F,0x210F,0x2910,0x2110,0x2110,0x2910,0x290F,0x290F,0x2930,0x290F,0x290F,0x210F,0x2930,0x212F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x2130,0x1910,0x08F1,0x11D7,0x09F8,0x01B9,0x01BA,0x01BA,0x01BA,0x01BA,0x01BA,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01B9,0x01BA,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01BA,0x01DA,0x01BA,0x01DA,0x01BA,0x01BA,0x01BA,0x01DA,0x01DA,0x01FA,0x01D9,0x01D9,0x01D9,0x01D9,0x01B8,0x01D8,0x11D8,0x1195,0x08D1,0x18F0,0x20F0,0x210F,0x210F,0x210F,0x20EE,0x20EE,0x20EE,0x210E,0x210F,0x20EE,0x20EE,0x210E,0x210E,0x210E,
  0x190F,0x190F,0x210F,0x210F,0x210E,0x210E,0x20EE,0x20EE,0x210E,0x210E,0x210E,0x210E,0x210E,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x20EF,0x210E,0x20EE,0x210E,0x210E,0x210E,0x210E,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EE,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x212F,0x212F,0x210F,0x212F,0x2110,0x2110,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2130,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x210F,0x290F,0x2930,0x2910,0x2910,0x2110,0x2110,0x1911,0x1112,0x19B6,0x1A18,0x09D8,0x01D9,0x01B9,0x01B9,0x01DA,0x01DA,0x01DA,0x01FA,0x01D9,0x01DA,0x01DA,0x01DA,0x01D9,0x01D9,0x01D9,0x01D8,0x09D7,0x1195,0x1112,0x2131,0x2931,0x2910,0x2930,0x2930,0x20EF,0x210F,0x2930,0x210F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2910,0x2110,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x212F,0x212F,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2930,0x2930,0x2930,0x2910,0x2110,0x2110,0x2130,0x2930,0x2930,0x212F,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x1930,0x1931,0x2152,0x1932,0x1953,0x1953,0x1995,0x1995,0x19D6,0x19F7,0x2218,0x1A18,0x19F8,0x19F7,0x1A18,0x2218,0x2218,0x2238,0x2218,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2218,0x2218,0x2218,0x2218,0x2218,0x2218,0x2238,0x2238,0x2238,0x1A18,0x2239,0x1A19,0x19F8,0x19F8,0x19F8,0x19F8,0x21F8,0x21F7,0x21F7,0x19D7,0x19F7,0x1A18,0x19F8,0x11D7,0x11B7,0x11B7,0x11D8,0x0997,0x0155,0x0135,0x0935,0x0955,0x0134,0x0135,0x0155,0x0996,0x1196,0x11D7,0x19D7,0x1996,0x1974,0x1912,0x18F1,0x2110,0x2130,0x212F,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2110,0x210F,0x2930,0x210F,0x290F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x2910,0x2930,0x2910,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x2930,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x2910,0x2910,0x2910,0x2110,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x210F,0x212F,0x2130,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2151,0x1931,0x1952,0x1953,0x1974,0x1995,0x19B6,0x19D7,0x21F7,0x21F7,0x1174,0x0912,0x1111,0x1931,0x2131,0x2130,0x2930,0x2930,0x210F,0x20EF,0x210F,0x290F,0x292F,0x2930,0x212F,0x210F,0x212F,0x210F,0x212F,0x2130,0x2150,0x2130,0x2131,0x1931,0x1932,0x1953,0x19B5,0x19D7,0x11D7,0x11D7,0x11D7,0x1197,0x11B7,0x11B6,0x11B7,0x19D7,0x11D7,0x11B6,0x19B6,0x1974,0x1953,0x2131,0x2111,0x2110,0x2110,0x2110,0x2130,0x2130,0x2150,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x1931,0x1953,0x1974,0x19B6,0x19D7,0x19F7,0x19D7,0x1174,0x0932,0x1131,0x1931,0x1931,0x1931,0x1932,0x1952,0x1173,0x11B5,0x1A17,0x1218,0x11F7,0x09B7,0x09B6,0x09B6,0x11D7,0x11D7,0x11D6,0x19D6,0x1994,0x1173,0x1953,0x1932,0x1931,0x1931,0x1931,0x1132,0x1153,0x1174,0x11B6,0x19F7,0x1A18,0x19D6,0x1175,0x1153,0x1111,0x1911,0x2131,0x2110,0x2110,0x2130,0x2110,0x210F,0x210F,0x212F,0x290F,0x2910,0x210F,0x210F,0x2110,0x2930,0x2110,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2131,0x2131,0x1912,0x1133,0x19D7,0x1A18,0x19F8,0x1195,0x1132,0x1951,0x1930,0x2110,0x2130,0x2130,0x2130,0x2930,0x2130,0x2930,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1153,0x19B6,0x19D7,0x19F8,0x19B6,0x08F2,0x10F1,0x2111,0x2111,0x2111,0x1932,0x1912,0x1112,0x11B5,0x11D6,0x1A17,0x19D6,0x1112,0x1931,0x2111,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2110,0x212F,0x210F,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x210F,0x210F,0x210F,0x292F,0x212F,0x210F,0x210F,0x2130,0x2110,0x2930,0x2930,0x2110,0x210F,0x212F,0x290F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2131,0x2152,0x1932,0x1911,0x1132,0x1153,0x1153,0x0954,0x19F6,0x2216,0x19B5,0x1132,0x1132,0x1931,0x1931,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x2130,0x2130,0x2131,0x1911,0x1112,0x19D6,0x19F7,0x19F7,0x1195,0x1112,0x1931,0x2151,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x1910,0x1911,0x1911,0x1932,0x1974,0x19B6,0x21F7,0x21F7,0x19D7,0x1196,0x1154,0x1113,0x1112,0x2132,0x2131,0x2131,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2930,0x210F,0x2930,0x290F,0x290F,0x2910,0x2930,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x2930,0x210F,0x290F,0x210F,0x2910,0x210F,0x210F,0x2930,0x210F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x212F,0x2930,0x2930,0x210F,0x212F,0x210F,0x212F,0x212F,0x2950,0x2130,0x2130,0x2130,0x2130,0x2131,0x2132,0x1932,0x1113,0x1975,0x21D6,0x2A17,0x1994,0x0912,0x1132,0x1932,0x1932,0x1932,0x1952,0x1132,0x1153,0x1994,0x21D6,0x21F6,0x1994,0x0912,0x1132,0x1931,0x2131,0x2130,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1132,0x1153,0x11B6,0x11D8,0x09B8,0x01D9,0x01B9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x09D9,0x11D8,0x1196,0x0955,0x1154,0x1133,0x08F2,0x08F2,0x08F1,0x10F2,0x1112,0x1111,0x1912,0x1931,0x1931,0x1911,0x1111,0x1111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1912,0x1911,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1111,0x1911,0x1911,0x1911,0x1911,0x1111,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x10F1,0x1911,0x1911,0x1911,0x10F1,0x10F1,0x1911,0x1911,0x1911,0x1111,0x1911,0x1911,0x1111,0x1911,0x1111,0x1112,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1131,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x10F1,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1931,0x1931,0x1931,0x2131,0x2131,0x2131,0x2131,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2110,0x2110,0x2910,0x2930,0x210F,0x2910,0x2930,0x2930,0x2930,0x2930,0x292F,0x292F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2110,0x18F0,0x1112,0x11D6,0x1219,0x09D9,0x01DA,0x01BA,0x01DA,0x0199,0x01B9,0x01BA,0x01B9,0x01DA,0x01DA,0x01DA,0x01B9,0x01B9,0x0199,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01DA,0x01BA,0x01B9,0x01B9,0x0199,0x01BA,0x01DA,0x01DA,0x01FA,0x01D9,0x01D9,0x01D9,0x01D9,0x01B9,0x01B8,0x11D8,0x1175,0x08F1,0x1910,0x2110,0x210F,0x210F,0x210E,0x20EE,0x20EE,0x210E,0x210F,0x210E,0x20EE,0x20EE,0x210E,0x210E,0x210E,
  0x190E,0x190F,0x210E,0x210F,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x20EF,0x290F,0x20EE,0x210E,0x210E,0x210E,0x210E,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x2930,0x210F,0x210F,0x2930,0x210F,0x2110,0x212F,0x210F,0x210F,0x2930,0x290F,0x210F,0x210F,0x212F,0x210F,0x2110,0x2930,0x2910,0x2130,0x2110,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x2910,0x2110,0x2110,0x2111,0x2131,0x1112,0x19D6,0x11B7,0x09D8,0x01B9,0x01B9,0x01B9,0x01BA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01D9,0x01DA,0x01D9,0x01F9,0x01D8,0x09D8,0x11B6,0x1112,0x2132,0x2131,0x2931,0x2910,0x2930,0x2910,0x2930,0x2110,0x2130,0x2130,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2930,0x2110,0x2110,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x1930,0x1931,0x1911,0x1932,0x1932,0x1953,0x1153,0x1174,0x1195,0x1195,0x1195,0x19B6,0x1995,0x1995,0x1995,0x1195,0x1195,0x11B6,0x19B6,0x11B6,0x19D6,0x19B6,0x19B6,0x19B6,0x1995,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x1195,0x19B6,0x11B6,0x19B6,0x19B6,0x11B6,0x19B6,0x1996,0x1996,0x19B6,0x1995,0x1995,0x1995,0x19B6,0x11B6,0x19D6,0x11B7,0x11B7,0x11F8,0x11D8,0x11B7,0x0976,0x0955,0x0935,0x0955,0x0135,0x0135,0x0955,0x0996,0x11B7,0x19D7,0x19B7,0x1996,0x1954,0x1912,0x1911,0x2110,0x2130,0x2930,0x210F,0x292F,0x210F,0x292F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2910,0x2910,0x2110,0x210F,0x2910,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2910,0x210F,0x292F,0x290F,0x290F,0x210F,0x210F,0x290F,0x2910,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x290F,0x290F,0x2110,0x210F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2910,0x2110,0x2910,0x210F,0x210F,0x2930,0x2930,0x212F,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x292F,0x2930,0x2930,0x2930,0x2150,0x2151,0x1931,0x1932,0x1933,0x1954,0x1995,0x19D6,0x19F7,0x2217,0x21F7,0x1154,0x1112,0x1111,0x1911,0x2131,0x2130,0x2130,0x212F,0x210F,0x290F,0x210F,0x292F,0x2930,0x212F,0x210F,0x212F,0x210F,0x212F,0x2130,0x2150,0x2150,0x2131,0x1931,0x1932,0x1933,0x1174,0x19D6,0x19B7,0x11D7,0x19F8,0x11B7,0x1197,0x11B7,0x19B7,0x11B7,0x19D7,0x19B6,0x1995,0x1953,0x1932,0x2111,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2110,0x2130,0x1931,0x1932,0x1974,0x1995,0x19D7,0x19D7,0x19D7,0x11B5,0x0933,0x1132,0x1931,0x1931,0x1931,0x1931,0x1952,0x1153,0x1174,0x11D5,0x19F7,0x11D7,0x11D6,0x11D7,0x11D7,0x11D6,0x11B6,0x19D6,0x19B5,0x1994,0x1953,0x1952,0x1932,0x1932,0x1932,0x1932,0x1933,0x1153,0x1174,0x19B6,0x2218,0x2218,0x19B6,0x1174,0x1953,0x1911,0x2131,0x2131,0x2110,0x2130,0x2930,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x1912,0x1113,0x19F7,0x1A18,0x19D8,0x1996,0x1133,0x1931,0x1910,0x2130,0x2110,0x2950,0x2110,0x2930,0x2130,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1133,0x1195,0x19F7,0x19D8,0x19B6,0x1112,0x10F1,0x2111,0x2111,0x2131,0x1932,0x1912,0x1133,0x19B6,0x19F7,0x1A17,0x19D6,0x1112,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x210F,0x2930,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x2930,0x212F,0x212F,0x210F,0x290F,0x290F,0x2930,0x2130,0x2930,0x210F,0x210F,0x290F,0x290F,0x2930,0x292F,0x290F,0x210F,0x2930,0x290F,0x210F,0x292F,0x210F,0x212F,0x2130,0x2110,0x2110,0x2110,0x210F,0x210F,0x292F,0x292F,0x212F,0x292F,0x292F,0x210F,0x210F,0x212F,0x2110,0x2131,0x2152,0x1931,0x1111,0x1132,0x1132,0x1153,0x1154,0x19B5,0x21F6,0x21D6,0x1132,0x1132,0x1932,0x1931,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2131,0x1931,0x1112,0x19D6,0x19F7,0x19D7,0x19B5,0x0911,0x1931,0x2151,0x2951,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2111,0x1931,0x1911,0x1132,0x1974,0x19D6,0x19F7,0x2218,0x19D7,0x1996,0x1134,0x1133,0x1932,0x2132,0x2131,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x292F,0x292F,0x290F,0x292F,0x290F,0x292F,0x292F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x290F,0x2930,0x210F,0x290F,0x210F,0x2930,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x210F,0x210F,0x2930,0x210F,0x2930,0x2110,0x2930,0x2110,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2950,0x2130,0x2130,0x2130,0x2130,0x2131,0x1932,0x1932,0x1112,0x1974,0x29F6,0x2A17,0x1994,0x1112,0x1132,0x1932,0x1932,0x1932,0x1932,0x1132,0x1133,0x1994,0x21F6,0x21F6,0x1194,0x0912,0x1132,0x1952,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1952,0x1132,0x1174,0x1196,0x11D8,0x09F9,0x01B9,0x01DA,0x01DA,0x01DA,0x01D9,0x01D9,0x01D9,0x01D9,0x01B9,0x09D9,0x09D8,0x11D8,0x11B7,0x1196,0x1175,0x0954,0x0954,0x0934,0x1133,0x1133,0x1133,0x1133,0x0912,0x1112,0x0912,0x0912,0x1112,0x0912,0x0912,0x0912,0x0912,0x1113,0x0912,0x0913,0x1113,0x08F2,0x1112,0x08F2,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x1113,0x0913,0x0912,0x0912,0x1112,0x0912,0x0912,0x1112,0x0912,0x0912,0x0912,0x1112,0x0912,0x0912,0x1112,0x1112,0x08F2,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x0912,0x0932,0x0912,0x0932,0x0932,0x0912,0x0912,0x0912,0x0912,0x0912,0x1112,0x1112,0x1112,0x1132,0x1112,0x1112,0x1112,0x1132,0x1132,0x1132,0x1112,0x1912,0x1912,0x2132,0x2111,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x212F,0x2930,0x210F,0x290F,0x290F,0x2910,0x2910,0x210F,0x2910,0x290F,0x2930,0x2910,0x2910,0x2910,0x2110,0x210F,0x2930,0x292F,0x212F,0x292F,0x292F,0x292F,0x292F,0x290F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x20EF,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x18F0,0x1132,0x11B6,0x1A39,0x09D9,0x01B9,0x01BA,0x01BA,0x01B9,0x01B9,0x01BA,0x01B9,0x01DA,0x01D9,0x01DA,0x01B9,0x01BA,0x01BA,0x01BA,0x01DA,0x01BA,0x01BA,0x01DA,0x01DA,0x01DA,0x01BA,0x01BA,0x0199,0x01B9,0x01B9,0x01B9,0x01B9,0x01B9,0x01B9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x09B8,0x11D8,0x1175,0x08F1,0x18F0,0x2110,0x20EF,0x212F,0x210F,0x20EE,0x210F,0x210F,0x20EE,0x210E,0x20EE,0x20EE,0x210E,0x210E,0x210E,
  0x190E,0x210E,0x190E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x292F,0x210F,0x212F,0x210F,0x212F,0x212F,0x292F,0x210F,0x290F,0x2930,0x290F,0x210F,0x212F,0x212F,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2110,0x2110,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x2110,0x2110,0x2110,0x2111,0x1912,0x1133,0x21F7,0x11F9,0x01B8,0x01D9,0x0199,0x01BA,0x01DA,0x01DA,0x01FA,0x01FA,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01D9,0x01F9,0x01F9,0x09F8,0x19F7,0x1153,0x1932,0x2131,0x2131,0x2131,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2131,0x2130,0x2130,0x2130,0x2110,0x2131,0x2131,0x2131,0x2131,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1931,0x1952,0x1952,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1112,0x1132,0x1132,0x1132,0x1153,0x1153,0x1153,0x1153,0x1132,0x1132,0x1953,0x1132,0x1132,0x1112,0x1112,0x1112,0x1132,0x1133,0x1132,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1953,0x1953,0x1953,0x1973,0x1153,0x1153,0x0934,0x0954,0x0976,0x11B7,0x11F8,0x11F8,0x11B7,0x0976,0x0955,0x0955,0x0955,0x0955,0x0996,0x11D7,0x19F8,0x19F7,0x19B6,0x1175,0x1933,0x1912,0x2111,0x2110,0x2130,0x210F,0x292F,0x210F,0x292F,0x292F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x210F,0x2930,0x2130,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2930,0x290F,0x2110,0x2930,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x290F,0x290F,0x2930,0x212F,0x2930,0x210F,0x212F,0x210F,0x2930,0x2930,0x210F,0x2910,0x2110,0x2910,0x2910,0x290F,0x290F,0x2930,0x2930,0x210F,0x2910,0x2910,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x2910,0x2910,0x2910,0x290F,0x210F,0x2930,0x2930,0x212F,0x212F,0x212F,0x2130,0x2930,0x2930,0x290F,0x292F,0x210F,0x212F,0x2950,0x2130,0x2130,0x1931,0x1912,0x1933,0x1154,0x1996,0x19F7,0x2217,0x2217,0x19F6,0x1174,0x1112,0x1112,0x1911,0x2151,0x2131,0x2950,0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x210F,0x212F,0x210F,0x212F,0x210F,0x2150,0x2151,0x2131,0x2131,0x1911,0x1932,0x1954,0x1975,0x1176,0x1196,0x19D7,0x11B7,0x11B7,0x11B7,0x1196,0x19B6,0x1196,0x1175,0x1974,0x1932,0x1931,0x1910,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2930,0x2130,0x2130,0x1931,0x1952,0x1953,0x1975,0x19B6,0x19D7,0x19D7,0x19B6,0x1174,0x1132,0x1132,0x1952,0x1931,0x1952,0x1952,0x1152,0x1173,0x1194,0x1195,0x1195,0x11B5,0x19F7,0x19D6,0x1195,0x11B5,0x19B5,0x1994,0x1152,0x1132,0x1952,0x1932,0x2152,0x1932,0x1112,0x1133,0x1154,0x1195,0x19D7,0x19F7,0x19D7,0x1195,0x1994,0x1932,0x1911,0x2110,0x2110,0x2130,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x212F,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x1911,0x1912,0x1113,0x21F7,0x2219,0x19D8,0x1175,0x1153,0x1931,0x1910,0x2110,0x2110,0x2930,0x2930,0x290F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1153,0x19B6,0x19D7,0x19F8,0x19B6,0x1112,0x10F1,0x2111,0x2111,0x2131,0x2132,0x1932,0x1113,0x19B6,0x19F7,0x1A18,0x19D6,0x1112,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2930,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2151,0x2131,0x1931,0x1911,0x1932,0x1132,0x1133,0x1153,0x1195,0x21D6,0x21F6,0x0933,0x1132,0x1932,0x1931,0x1930,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2131,0x1911,0x1112,0x19D6,0x19F7,0x19D7,0x1175,0x08F1,0x1931,0x2131,0x2130,0x210F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2110,0x2130,0x2131,0x1911,0x1911,0x1132,0x1154,0x19B6,0x2217,0x2218,0x19D7,0x1995,0x1134,0x1133,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x292F,0x292F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2130,0x210F,0x2110,0x2910,0x210F,0x290F,0x290F,0x210F,0x2930,0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x210F,0x290F,0x290F,0x2910,0x210F,0x2930,0x210F,0x290F,0x210F,0x2910,0x2910,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2930,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x212F,0x2130,0x210F,0x2130,0x2131,0x1932,0x1932,0x1132,0x1974,0x21F6,0x2A16,0x19B4,0x1132,0x1132,0x1932,0x1932,0x1932,0x1932,0x1132,0x1133,0x1994,0x21F6,0x21F6,0x1995,0x0912,0x1932,0x1931,0x1931,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x2110,0x2111,0x2132,0x1932,0x1153,0x1196,0x11B8,0x09D9,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01B9,0x01B9,0x01B9,0x09D9,0x09F8,0x11F8,0x11F8,0x11F8,0x11D7,0x11D7,0x11D7,0x11B7,0x11B6,0x11B6,0x11B6,0x1195,0x11B6,0x1195,0x1195,0x1196,0x1196,0x1196,0x11B6,0x1196,0x1196,0x1196,0x1197,0x1196,0x11B6,0x1196,0x1196,0x1196,0x11B6,0x11B6,0x11B6,0x11B6,0x1196,0x11B6,0x11B6,0x1196,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x1196,0x11B6,0x11B6,0x1196,0x1196,0x1196,0x11B6,0x19B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11D6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11D6,0x11D6,0x11D6,0x11D6,0x11D6,0x11D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D7,0x19D7,0x19D6,0x19D7,0x19B6,0x19D6,0x19D6,0x19B6,0x19B6,0x1975,0x1134,0x1113,0x1912,0x1912,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x212F,0x210F,0x210F,0x2910,0x210F,0x2930,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x210F,0x290F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x18EF,0x1911,0x1953,0x1175,0x1218,0x09F9,0x01DA,0x01B9,0x01B9,0x0199,0x01B9,0x01D9,0x01D9,0x01D9,0x01D9,0x01DA,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01B9,0x01DA,0x01B9,0x01B9,0x01BA,0x01DA,0x0199,0x01B9,0x01B9,0x01B9,0x01B9,0x01D9,0x01DA,0x01B9,0x01D9,0x01B9,0x01B9,0x01D9,0x01B9,0x09B8,0x11D8,0x1155,0x08F1,0x1911,0x2110,0x210F,0x210F,0x212F,0x210E,0x210E,0x210E,0x210F,0x210F,0x210E,0x210E,0x210E,0x210E,0x210E,
  0x190E,0x190E,0x190E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210F,0x210F,0x20EE,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x290F,0x290F,0x20EF,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2130,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x290F,0x292F,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x292F,0x212F,0x210F,0x212F,0x2930,0x210F,0x290F,0x2930,0x290F,0x210F,0x210F,0x2130,0x2110,0x2110,0x2930,0x2930,0x210F,0x212F,0x210F,0x210F,0x2930,0x2910,0x210F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x210F,0x212F,0x212F,0x212F,0x292F,0x210F,0x212F,0x2130,0x2130,0x2110,0x2111,0x1912,0x1154,0x19F8,0x11F9,0x09D9,0x01B9,0x01B9,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01D9,0x021A,0x09F9,0x09D8,0x11F8,0x0954,0x1133,0x1932,0x1931,0x1931,0x1911,0x1910,0x1910,0x1910,0x1910,0x2131,0x2131,0x2131,0x2131,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x1931,0x1931,0x2131,0x2131,0x1931,0x2131,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x2111,0x2111,0x2131,0x2111,0x2111,0x2131,0x1911,0x1911,0x2131,0x2131,0x1911,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x1910,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2131,0x1930,0x1931,0x1911,0x1931,0x1931,0x1911,0x1931,0x1911,0x1911,0x1911,0x18F1,0x1911,0x1911,0x1911,0x1111,0x1911,0x1111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1111,0x1132,0x1132,0x1133,0x0933,0x0955,0x11B6,0x11D7,0x19F8,0x11F8,0x11B7,0x0976,0x0976,0x0955,0x0976,0x11B7,0x19F8,0x19F8,0x19D7,0x1996,0x1954,0x1933,0x2132,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2110,0x210F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2930,0x210F,0x212F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2930,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2130,0x2130,0x2930,0x210F,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x210F,0x2130,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1133,0x1975,0x1195,0x19D7,0x19F7,0x2217,0x19D6,0x1154,0x0912,0x10F1,0x1931,0x2151,0x2151,0x2130,0x212F,0x212F,0x210F,0x210F,0x2130,0x212F,0x2130,0x212F,0x2130,0x2130,0x2150,0x2150,0x2130,0x1910,0x1911,0x1932,0x1933,0x1154,0x1155,0x1196,0x11D7,0x11D7,0x11B7,0x1196,0x1196,0x1196,0x1175,0x1153,0x1952,0x1911,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2910,0x210F,0x210F,0x292F,0x210F,0x210F,0x292F,0x290F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2950,0x2130,0x2130,0x2130,0x1930,0x1931,0x1952,0x1154,0x1996,0x19B7,0x19F8,0x19D7,0x1195,0x0933,0x1132,0x1932,0x1931,0x1931,0x1951,0x1952,0x1952,0x1973,0x1173,0x1174,0x1195,0x1195,0x19B5,0x1174,0x1174,0x1973,0x1973,0x1952,0x1952,0x1931,0x1932,0x1932,0x1932,0x1113,0x1133,0x1175,0x1196,0x19D7,0x2218,0x19D7,0x1975,0x1973,0x1932,0x1911,0x2110,0x2130,0x2130,0x210F,0x2930,0x290F,0x210F,0x210F,0x2930,0x290F,0x210F,0x2930,0x290F,0x2910,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x1911,0x1912,0x1112,0x21F7,0x2219,0x19D8,0x1175,0x1953,0x1931,0x2130,0x2130,0x2930,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2131,0x1932,0x1133,0x19B6,0x19D7,0x19F7,0x19B6,0x1112,0x1111,0x1911,0x2111,0x2131,0x2132,0x1912,0x1133,0x19D6,0x19F7,0x1A17,0x19D6,0x0912,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x210F,0x212F,0x212F,0x2930,0x290F,0x212F,0x2930,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2930,0x212F,0x2930,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2110,0x212F,0x2930,0x2930,0x2110,0x2910,0x2910,0x2930,0x2910,0x292F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1952,0x1132,0x1153,0x1153,0x1174,0x21F6,0x2A17,0x1153,0x1112,0x1952,0x1952,0x1931,0x1910,0x2110,0x2130,0x292F,0x210F,0x210F,0x2130,0x2130,0x1931,0x1112,0x19D6,0x19F7,0x19F7,0x1195,0x0911,0x1910,0x2151,0x2950,0x212F,0x212F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1111,0x1133,0x1174,0x19D6,0x19F7,0x19F7,0x19D7,0x1995,0x1154,0x1133,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x212F,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x290F,0x210F,0x210F,0x2930,0x2930,0x210F,0x2110,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x210F,0x210F,0x290F,0x290F,0x2930,0x2930,0x2910,0x2110,0x2110,0x2930,0x2930,0x2110,0x210F,0x2110,0x2110,0x2910,0x210F,0x212F,0x212F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1932,0x1112,0x1974,0x21F6,0x2216,0x19B5,0x1112,0x1132,0x1952,0x1112,0x1932,0x1932,0x1132,0x1133,0x1994,0x21F6,0x21F6,0x19B5,0x0912,0x1132,0x1952,0x1951,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2111,0x1931,0x1932,0x1133,0x1196,0x11D8,0x09F9,0x01FA,0x01BA,0x01DA,0x01DA,0x01DA,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x09D9,0x09F9,0x11F9,0x11F9,0x1219,0x1219,0x1219,0x1A19,0x1A39,0x1A39,0x1A38,0x2239,0x2239,0x2259,0x2259,0x2259,0x2259,0x2A59,0x2A59,0x2A7A,0x225A,0x2A5A,0x2A5A,0x2A5A,0x2A5A,0x2A5A,0x225A,0x2A5A,0x2A5A,0x2A7A,0x2A5A,0x2A5A,0x227A,0x227A,0x227A,0x227A,0x2A7A,0x2259,0x2259,0x2A79,0x2A79,0x2A79,0x2A79,0x2A79,0x2259,0x2A59,0x2A59,0x2A59,0x2A59,0x2A59,0x2A59,0x2A59,0x2259,0x2A79,0x2259,0x2259,0x2259,0x2259,0x2259,0x2279,0x2279,0x2279,0x2259,0x2279,0x2279,0x2279,0x2279,0x2259,0x2259,0x2259,0x2259,0x2259,0x2239,0x2259,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x1A18,0x2238,0x1A38,0x1A18,0x2238,0x2218,0x21F8,0x21D7,0x1975,0x1113,0x1933,0x1912,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2930,0x2910,0x2910,0x2110,0x2930,0x2130,0x2130,0x2930,0x2930,0x210F,0x2930,0x2930,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x2930,0x292F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x210F,0x18EF,0x1911,0x1953,0x0954,0x1A18,0x09F9,0x09DA,0x01DA,0x01B9,0x01B9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01DA,0x01B9,0x01B9,0x01D9,0x01B9,0x01B9,0x01DA,0x01B9,0x01DA,0x01B9,0x01B9,0x01B9,0x09B9,0x01B9,0x01D9,0x01D9,0x01B9,0x01D9,0x01D9,0x01B9,0x01D9,0x01B9,0x09B8,0x19D8,0x0934,0x1112,0x1911,0x2110,0x2110,0x210F,0x210F,0x210E,0x210E,0x210F,0x292F,0x210F,0x210F,0x20EE,0x20EE,0x210E,0x210E,
  0x210F,0x210F,0x210E,0x212E,0x210E,0x212E,0x212F,0x210E,0x210E,0x210E,0x210E,0x210F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x210F,0x210F,0x212F,0x210F,0x212F,0x2930,0x210F,0x210F,0x210F,0x290F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x212F,0x2930,0x2930,0x210F,0x212F,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x2930,0x2130,0x2930,0x2930,0x290F,0x290F,0x2930,0x212F,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x210F,0x2110,0x2130,0x2110,0x1911,0x1932,0x1133,0x2239,0x09F9,0x09FA,0x01BA,0x01DA,0x01DA,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01D9,0x01F9,0x01D9,0x09D8,0x09B7,0x0954,0x0912,0x0912,0x1112,0x1111,0x1111,0x1911,0x1931,0x1911,0x1931,0x1911,0x1911,0x1911,0x1932,0x1911,0x1911,0x1931,0x1111,0x1911,0x1931,0x1911,0x1911,0x1911,0x1931,0x1111,0x1111,0x1111,0x1911,0x1911,0x1111,0x1931,0x1931,0x1111,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1931,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1910,0x1910,0x1910,0x2130,0x2131,0x2110,0x2130,0x2110,0x2110,0x20F0,0x18F0,0x18F0,0x1911,0x1931,0x1931,0x1910,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x1910,0x2111,0x2110,0x2131,0x2131,0x1910,0x1911,0x2131,0x1931,0x1931,0x1931,0x2131,0x1910,0x2131,0x1931,0x1911,0x1111,0x1111,0x1112,0x1174,0x1195,0x19B6,0x19D7,0x19D7,0x11D7,0x1196,0x1196,0x11B6,0x11B7,0x19F7,0x19F8,0x19D7,0x1996,0x1974,0x1133,0x1932,0x2132,0x2951,0x2931,0x2930,0x292F,0x292F,0x292F,0x210F,0x292F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x2930,0x2930,0x2930,0x212F,0x2930,0x2930,0x2930,0x2110,0x2110,0x2910,0x2910,0x2930,0x2930,0x2910,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2930,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x2110,0x2110,0x210F,0x2110,0x2930,0x210F,0x210F,0x2110,0x2110,0x2910,0x2910,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x292F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x1911,0x1931,0x1932,0x1954,0x1155,0x1196,0x19D7,0x2218,0x19F7,0x19D6,0x1174,0x0912,0x10F1,0x1911,0x2131,0x2150,0x2130,0x212F,0x20EF,0x210F,0x210F,0x212F,0x2150,0x212F,0x212F,0x2130,0x2130,0x2150,0x2110,0x2110,0x2131,0x1931,0x1932,0x1933,0x1134,0x1175,0x19D7,0x11D7,0x11B7,0x1196,0x1175,0x1175,0x1153,0x1132,0x1931,0x1931,0x190F,0x190F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2910,0x2910,0x290F,0x2930,0x290F,0x292F,0x292F,0x292F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1132,0x1153,0x1175,0x19D7,0x19D7,0x19F7,0x19B6,0x1154,0x1133,0x1112,0x1932,0x1131,0x1931,0x1131,0x1952,0x1952,0x1152,0x1153,0x1153,0x1974,0x1974,0x1153,0x1153,0x1952,0x1952,0x1932,0x1931,0x1911,0x1931,0x1932,0x1133,0x1133,0x1154,0x1175,0x19D6,0x2218,0x2218,0x1995,0x1154,0x1953,0x1931,0x1910,0x2110,0x2110,0x2930,0x2130,0x210F,0x2910,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x1911,0x1911,0x1133,0x21F7,0x19F8,0x19B7,0x1175,0x1153,0x1931,0x2131,0x2130,0x2130,0x2930,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1133,0x19B6,0x19F7,0x19F8,0x19B6,0x1112,0x1911,0x1911,0x2131,0x2111,0x2132,0x1112,0x1133,0x19D6,0x11F7,0x1A17,0x19B6,0x1112,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x210F,0x2110,0x212F,0x212F,0x290F,0x210F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2110,0x2110,0x2110,0x210F,0x212F,0x210F,0x2130,0x2110,0x2910,0x2910,0x210F,0x2930,0x210F,0x212F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2950,0x2110,0x2130,0x2130,0x1930,0x1951,0x1952,0x1153,0x1133,0x1154,0x21F6,0x2A17,0x1153,0x1132,0x1952,0x1952,0x1951,0x1930,0x2130,0x212F,0x212F,0x210F,0x2130,0x2130,0x2131,0x1931,0x1112,0x19D6,0x19F8,0x19F8,0x1196,0x0912,0x1931,0x2151,0x2150,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2150,0x2131,0x1911,0x1911,0x1132,0x1133,0x1174,0x19D6,0x19F7,0x19F7,0x21F7,0x1995,0x1974,0x1933,0x1912,0x2131,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x292F,0x292F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2910,0x210F,0x290F,0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x2910,0x2910,0x210F,0x290F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2930,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x290F,0x210F,0x210F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1132,0x1132,0x1994,0x21F6,0x2A17,0x1994,0x1132,0x1132,0x1952,0x1932,0x1932,0x1932,0x1132,0x1132,0x1974,0x21F6,0x21F6,0x1995,0x0912,0x1932,0x1972,0x1931,0x2130,0x2130,0x212F,0x2130,0x210F,0x210F,0x2110,0x2130,0x2131,0x2131,0x1912,0x1113,0x1175,0x11D7,0x11F9,0x09D9,0x01BA,0x01BA,0x01B9,0x01DA,0x01DA,0x01B9,0x01D9,0x01D9,0x09F9,0x09F9,0x09D9,0x09D8,0x11D8,0x11D8,0x11D8,0x11F8,0x11F8,0x19F8,0x19F8,0x1A18,0x1A18,0x19F8,0x2218,0x2218,0x2218,0x2238,0x1A18,0x1A18,0x2219,0x19F8,0x19F8,0x1A18,0x19F8,0x19D8,0x19F8,0x19F8,0x19F8,0x19F8,0x1A18,0x19F8,0x1A18,0x1A18,0x1A18,0x1A18,0x19F8,0x19F8,0x19F8,0x1A18,0x1A18,0x19F8,0x19F8,0x1A18,0x19F8,0x19F8,0x19F7,0x19F7,0x19D7,0x21F8,0x19F8,0x19F7,0x19D7,0x19F7,0x19F8,0x19D7,0x19D7,0x19F7,0x19D7,0x19D7,0x19F7,0x19D7,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x19D7,0x19F7,0x19F7,0x19D7,0x19F8,0x19D8,0x19D8,0x19D8,0x19D8,0x19D8,0x19D8,0x19D7,0x19F7,0x19D7,0x19F7,0x2218,0x1A18,0x19F7,0x19F8,0x19F8,0x19F8,0x19D8,0x21D7,0x19B6,0x1134,0x1113,0x1911,0x1911,0x2131,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x290F,0x210F,0x2110,0x2110,0x2910,0x2910,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x210F,0x212F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x292F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x20EF,0x190F,0x1931,0x1952,0x0933,0x11D7,0x09D8,0x09D9,0x09FA,0x01DA,0x01B9,0x01B9,0x01D9,0x09F9,0x01B8,0x01B8,0x01D9,0x01B8,0x01B9,0x01D9,0x01B9,0x01B9,0x01D9,0x01D9,0x01D9,0x01D9,0x01B9,0x01B9,0x09B9,0x0998,0x09B8,0x09B8,0x09B8,0x09D8,0x01B8,0x01B9,0x09FA,0x01D9,0x01D9,0x09F9,0x09B8,0x0997,0x19F7,0x1134,0x1112,0x1911,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x20EE,0x20EE,0x20EE,0x210E,
  0x212F,0x212F,0x210F,0x212F,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2930,0x210F,0x212F,0x212F,0x210F,0x292F,0x212F,0x210F,0x212F,0x212F,0x292F,0x212F,0x292F,0x212F,0x212F,0x2930,0x290F,0x210F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x212F,0x210F,0x210F,0x2110,0x2930,0x290F,0x2930,0x2930,0x212F,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2110,0x2110,0x2111,0x1911,0x1912,0x1134,0x1A18,0x1219,0x01B9,0x01DA,0x01DA,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01F9,0x01D9,0x09F9,0x09B7,0x0996,0x0954,0x0934,0x0933,0x1133,0x1133,0x1133,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1132,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1133,0x1133,0x1133,0x1132,0x1132,0x1112,0x1112,0x1112,0x1911,0x1911,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1932,0x1132,0x1154,0x1175,0x1196,0x19B6,0x19D7,0x19B7,0x19F7,0x19F7,0x19F7,0x21F7,0x19D6,0x19B6,0x1154,0x1133,0x1912,0x2132,0x2131,0x2931,0x2930,0x2930,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2930,0x2930,0x292F,0x292F,0x2930,0x212F,0x2130,0x2130,0x2130,0x2930,0x2930,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x210F,0x2930,0x2130,0x2130,0x2130,0x212F,0x212F,0x290F,0x290F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x210F,0x2910,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x290F,0x2910,0x2910,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1911,0x1933,0x1133,0x1154,0x1195,0x19B6,0x2218,0x2217,0x19D6,0x1154,0x1133,0x1111,0x1931,0x2131,0x2150,0x210F,0x210F,0x210F,0x212F,0x2950,0x212F,0x212F,0x2150,0x212F,0x212F,0x210F,0x2110,0x2110,0x2131,0x2131,0x1932,0x1933,0x1134,0x1155,0x19D7,0x11D7,0x11D7,0x11B6,0x1175,0x1154,0x1132,0x1132,0x1931,0x1910,0x212F,0x212F,0x212F,0x212F,0x212F,0x2950,0x2130,0x210F,0x2130,0x2130,0x2930,0x2930,0x2910,0x2910,0x2910,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x210F,0x2130,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1932,0x1153,0x1174,0x1196,0x19D7,0x19D7,0x19D7,0x1996,0x1134,0x1133,0x1132,0x1932,0x1932,0x1952,0x1952,0x1952,0x1952,0x1932,0x1932,0x1132,0x1132,0x1152,0x1132,0x1932,0x1932,0x1931,0x1911,0x1911,0x1932,0x1132,0x1133,0x1154,0x1175,0x11B6,0x19F7,0x2218,0x19F7,0x1174,0x1953,0x1932,0x1911,0x2130,0x2110,0x2110,0x2930,0x2110,0x210F,0x2930,0x2930,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x1911,0x1912,0x1113,0x21F8,0x2219,0x19B8,0x1175,0x1933,0x1931,0x1910,0x2110,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x2130,0x1910,0x1931,0x1133,0x19B6,0x19F7,0x19F8,0x19B6,0x1112,0x1911,0x1911,0x2111,0x2131,0x1931,0x1932,0x0933,0x11B6,0x11F7,0x1A17,0x19B6,0x1112,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2930,0x212F,0x210F,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x210F,0x2930,0x290F,0x290F,0x210F,0x2110,0x2110,0x2930,0x212F,0x210F,0x212F,0x2110,0x2110,0x2110,0x290F,0x290F,0x292F,0x210F,0x210F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1930,0x1931,0x1952,0x1132,0x1153,0x1174,0x21D6,0x21F6,0x1174,0x1112,0x1952,0x1931,0x1951,0x1930,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2132,0x1112,0x19B6,0x19F8,0x19F8,0x11B6,0x0932,0x1131,0x2151,0x2151,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x1931,0x1111,0x1132,0x1133,0x1174,0x19D6,0x21F7,0x21F7,0x21F7,0x1995,0x1954,0x1932,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x212F,0x292F,0x2930,0x2930,0x290F,0x210F,0x210F,0x290F,0x2910,0x2910,0x290F,0x2930,0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x2910,0x2910,0x210F,0x210F,0x290F,0x2930,0x210F,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x2910,0x2110,0x2110,0x2930,0x2930,0x210F,0x290F,0x290F,0x292F,0x212F,0x292F,0x212F,0x212F,0x2130,0x2130,0x1931,0x1931,0x1152,0x1132,0x1994,0x21F6,0x2216,0x19B5,0x0912,0x1132,0x1932,0x1932,0x1932,0x1932,0x1132,0x1132,0x1994,0x21D6,0x21F6,0x19B5,0x0912,0x1932,0x1952,0x1931,0x2131,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2111,0x1912,0x1133,0x1175,0x11B7,0x11D8,0x09D9,0x09DA,0x01BA,0x01DA,0x01BA,0x01DA,0x01B9,0x01D9,0x01D9,0x09F9,0x09D8,0x09B8,0x11B8,0x0997,0x11B7,0x1196,0x1196,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1155,0x1175,0x1175,0x1155,0x1175,0x1196,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1154,0x1175,0x1155,0x1155,0x1155,0x1155,0x1175,0x1155,0x1154,0x1154,0x1175,0x1154,0x1154,0x1175,0x1154,0x1175,0x1154,0x1175,0x1175,0x1175,0x1175,0x1175,0x1154,0x1155,0x1175,0x1155,0x1155,0x1155,0x1155,0x1155,0x1175,0x1155,0x1175,0x1154,0x1175,0x1175,0x1174,0x1175,0x1195,0x11B6,0x19D7,0x19F8,0x19D8,0x21F8,0x19B7,0x19B6,0x1954,0x1112,0x1911,0x2131,0x2131,0x2130,0x2130,0x2130,0x2930,0x2930,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x210F,0x292F,0x210F,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x292F,0x212F,0x210F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x292F,0x210F,0x292F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2110,0x2131,0x1952,0x1133,0x1175,0x09B7,0x09F9,0x09D9,0x01D9,0x01D9,0x09D9,0x09D8,0x01B8,0x09B7,0x09D8,0x09B7,0x09B8,0x09B8,0x09B8,0x09D9,0x09B9,0x01B8,0x09D9,0x01D9,0x09D9,0x09B8,0x0998,0x11B8,0x11B8,0x11D8,0x11B7,0x11D8,0x11B7,0x0997,0x09D9,0x01D9,0x01F9,0x09F9,0x09D9,0x09B8,0x0997,0x11B6,0x1133,0x1111,0x1911,0x2110,0x210F,0x210F,0x210F,0x210F,0x292F,0x210E,0x210F,0x210F,0x20EE,0x20EE,0x210E,0x210E,0x210E,
  0x212F,0x190F,0x210F,0x210F,0x210F,0x210E,0x210F,0x210E,0x210E,0x210F,0x210F,0x210F,0x210E,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x290F,0x290F,0x20EF,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x292F,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x212F,0x210F,0x212F,0x212F,0x2930,0x210F,0x2930,0x2910,0x290F,0x210F,0x212F,0x2930,0x212F,0x2130,0x2110,0x2110,0x212F,0x210F,0x2930,0x210F,0x210F,0x212F,0x2110,0x2130,0x2130,0x210F,0x2130,0x2110,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2131,0x1911,0x1112,0x1134,0x19F8,0x09D9,0x01D9,0x01DA,0x01FB,0x01FA,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01D9,0x01FA,0x01FA,0x09F9,0x09D9,0x09F8,0x09D7,0x11D7,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x1196,0x19B6,0x1196,0x1196,0x11B6,0x11B6,0x11B6,0x1196,0x1196,0x1195,0x1195,0x1195,0x1196,0x11B6,0x11B6,0x11B6,0x11B6,0x1196,0x1196,0x1196,0x1195,0x1196,0x1196,0x11B6,0x1196,0x1196,0x1196,0x11B6,0x1196,0x19B6,0x1196,0x1196,0x11B6,0x1196,0x1196,0x11B6,0x11B6,0x11B6,0x19B6,0x11B6,0x11B6,0x11B6,0x11B6,0x19B6,0x11B6,0x19B6,0x1195,0x1154,0x1153,0x1932,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2150,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1953,0x1133,0x1154,0x1174,0x1996,0x19D7,0x19D7,0x2217,0x2217,0x21D6,0x19B5,0x1154,0x1133,0x1912,0x1912,0x2131,0x2931,0x2910,0x2910,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x212F,0x212F,0x2130,0x212F,0x2930,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2930,0x212F,0x2930,0x2930,0x290F,0x2930,0x210F,0x2930,0x290F,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x212F,0x2930,0x2130,0x212F,0x212F,0x210F,0x2130,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x2910,0x210F,0x2930,0x210F,0x290F,0x210F,0x290F,0x292F,0x212F,0x290F,0x290F,0x2930,0x212F,0x2130,0x2110,0x2110,0x2130,0x212F,0x292F,0x292F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1932,0x1912,0x1133,0x1154,0x1195,0x19F7,0x2238,0x2217,0x19D6,0x1154,0x0912,0x1132,0x1931,0x2151,0x2130,0x212F,0x212F,0x210F,0x2950,0x2130,0x212F,0x2150,0x2950,0x212F,0x210F,0x210F,0x2110,0x2130,0x2131,0x2152,0x1933,0x1133,0x1154,0x19D7,0x19F7,0x19F7,0x11B6,0x1175,0x0933,0x1132,0x1111,0x1930,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2930,0x2910,0x2910,0x2910,0x2930,0x2930,0x2910,0x290F,0x2910,0x2910,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1951,0x1953,0x1154,0x1195,0x19D7,0x19D7,0x19D7,0x1196,0x1154,0x0913,0x1112,0x1933,0x1932,0x1952,0x1952,0x1952,0x1952,0x1932,0x1932,0x1932,0x1932,0x1952,0x1952,0x1952,0x1932,0x1131,0x1131,0x1132,0x1133,0x1133,0x1154,0x1175,0x1196,0x19D7,0x1A18,0x21F7,0x19B6,0x1133,0x1932,0x1931,0x2131,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2930,0x2930,0x2910,0x2910,0x210F,0x2930,0x2930,0x2110,0x2930,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1911,0x1912,0x1133,0x2218,0x2219,0x19B7,0x1155,0x1953,0x2132,0x2130,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2930,0x2930,0x2130,0x2111,0x1911,0x1133,0x19B5,0x19F7,0x19F8,0x19B6,0x1112,0x1911,0x2131,0x2111,0x2131,0x1932,0x1932,0x1133,0x11D6,0x11F7,0x1A18,0x19B6,0x1112,0x1912,0x2111,0x2111,0x2130,0x2110,0x2130,0x2930,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x2110,0x2930,0x212F,0x212F,0x2930,0x210F,0x212F,0x2930,0x212F,0x210F,0x212F,0x212F,0x210F,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x292F,0x212F,0x212F,0x210F,0x2130,0x1930,0x1931,0x1932,0x1132,0x1133,0x1995,0x2A17,0x2A17,0x1174,0x1112,0x1132,0x1951,0x1951,0x1930,0x1930,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2132,0x1112,0x1995,0x19F8,0x19F8,0x19D7,0x1154,0x1111,0x1931,0x2131,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2130,0x2130,0x210F,0x210F,0x2130,0x2151,0x1931,0x1931,0x1112,0x1133,0x1175,0x19B6,0x2218,0x2217,0x19D6,0x1995,0x1153,0x1133,0x1952,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2930,0x2110,0x210F,0x210F,0x290F,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2910,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x2910,0x2110,0x2910,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x212F,0x210F,0x1910,0x1930,0x1931,0x1952,0x1132,0x1994,0x2216,0x2216,0x1994,0x0912,0x1112,0x1932,0x1932,0x1932,0x1932,0x1932,0x1133,0x1995,0x21F6,0x21F7,0x1175,0x0912,0x1132,0x1931,0x1931,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2130,0x2110,0x2110,0x2111,0x1911,0x1932,0x1974,0x19B6,0x09B7,0x09D9,0x09D9,0x09DA,0x01B9,0x01B9,0x01DA,0x01DA,0x09FA,0x09F9,0x09F9,0x11F9,0x11B7,0x0976,0x1175,0x1154,0x0933,0x0912,0x1113,0x1113,0x1133,0x1133,0x1133,0x1953,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1132,0x1132,0x1132,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1112,0x1133,0x1132,0x1132,0x1112,0x1112,0x1132,0x1132,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1933,0x1933,0x1933,0x1132,0x1132,0x1932,0x1112,0x1112,0x1132,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1112,0x1133,0x1133,0x1133,0x1133,0x1933,0x1113,0x1933,0x1933,0x1113,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x08F2,0x0913,0x1154,0x1996,0x19D8,0x19D8,0x21D8,0x21D7,0x1996,0x1954,0x1112,0x1912,0x2132,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x212F,0x212F,0x2930,0x2930,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x2930,0x212F,0x210F,0x210F,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x290F,0x290F,0x292F,0x292F,0x2930,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2130,0x2151,0x1931,0x1132,0x1134,0x0976,0x11D8,0x09D8,0x09B8,0x09D9,0x09B8,0x09D8,0x09B7,0x0996,0x0996,0x1196,0x1196,0x1196,0x0997,0x0997,0x0997,0x11F9,0x09D9,0x1219,0x09D8,0x0997,0x0956,0x1176,0x1176,0x19B6,0x1996,0x1155,0x0955,0x0976,0x0997,0x09D8,0x09D9,0x09D9,0x09D8,0x0997,0x0955,0x1154,0x0912,0x1931,0x1910,0x2110,0x212F,0x210F,0x20EE,0x210E,0x210E,0x210E,0x210F,0x210E,0x210E,0x210E,0x210E,0x20EE,0x210E,
  0x1910,0x190F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210E,0x210E,0x210F,0x210F,0x210F,0x210E,0x210F,0x210F,0x212F,0x210F,0x210F,0x2130,0x210F,0x20EF,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x2130,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x290F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x290F,0x2910,0x210F,0x2930,0x2930,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x210F,0x210F,0x290F,0x290F,0x212F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x292F,0x292F,0x2130,0x2110,0x2110,0x2111,0x1911,0x1933,0x0934,0x1A19,0x09D9,0x01B9,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01FA,0x01FA,0x01FA,0x01F9,0x01D9,0x1219,0x1219,0x1219,0x1A18,0x1A18,0x1A39,0x1A18,0x1A18,0x2218,0x1A18,0x2218,0x2218,0x2218,0x2218,0x2239,0x1A18,0x2239,0x2238,0x1A18,0x2218,0x1A18,0x1A18,0x2238,0x2238,0x2238,0x1A18,0x2239,0x2218,0x2218,0x2218,0x2218,0x1A18,0x2219,0x1A18,0x2218,0x1A18,0x2218,0x2218,0x2219,0x2218,0x2218,0x1A18,0x2218,0x2218,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x19F8,0x1A18,0x19F8,0x19F8,0x1A18,0x1A18,0x19F7,0x19B6,0x1174,0x1133,0x1932,0x1931,0x1931,0x2131,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x292F,0x210F,0x290F,0x210F,0x290F,0x212F,0x212F,0x2930,0x210F,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x210F,0x212F,0x212F,0x2110,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x292F,0x2930,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1932,0x1933,0x1154,0x1174,0x1174,0x1995,0x1994,0x1994,0x1974,0x1953,0x1932,0x1932,0x1911,0x1911,0x2131,0x2110,0x2910,0x210F,0x290F,0x292F,0x210F,0x292F,0x292F,0x210F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x212F,0x210F,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x290F,0x2930,0x212F,0x212F,0x2930,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x210F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x290F,0x2930,0x290F,0x2110,0x210F,0x2110,0x2130,0x2130,0x212F,0x292F,0x210F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1912,0x1932,0x1133,0x1174,0x19B6,0x19F7,0x2218,0x19F7,0x19D6,0x0933,0x1112,0x1931,0x1930,0x2130,0x2150,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2110,0x2130,0x2151,0x2132,0x1932,0x1133,0x1154,0x19D6,0x19F7,0x19F7,0x11B6,0x1154,0x0932,0x1111,0x1931,0x2150,0x2150,0x214F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x2910,0x2130,0x2130,0x2930,0x2110,0x2110,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1932,0x1153,0x1175,0x1996,0x19D7,0x19D7,0x19D7,0x1196,0x1154,0x1133,0x1113,0x1132,0x1932,0x1952,0x1952,0x1932,0x1932,0x1931,0x1111,0x1932,0x1111,0x1131,0x1952,0x1932,0x1132,0x1132,0x1133,0x1153,0x1154,0x0954,0x1195,0x19D7,0x1A18,0x1A17,0x19D6,0x1154,0x1132,0x1932,0x1911,0x2110,0x2130,0x2130,0x2930,0x210F,0x210F,0x2130,0x2110,0x2930,0x2110,0x2930,0x2910,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1911,0x1112,0x1154,0x2218,0x2219,0x19B7,0x1155,0x1933,0x1911,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2131,0x1931,0x1132,0x19B5,0x19F7,0x19F8,0x19B6,0x1112,0x1911,0x1931,0x2131,0x2131,0x1932,0x1932,0x0933,0x11D6,0x11F7,0x19F7,0x19D6,0x08F2,0x1912,0x2111,0x2110,0x2130,0x2930,0x2110,0x2930,0x2930,0x2930,0x212F,0x212F,0x2930,0x212F,0x2110,0x2110,0x212F,0x212F,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x290F,0x2930,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x290F,0x210F,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x292F,0x292F,0x292F,0x292F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x2130,0x1931,0x1932,0x1132,0x1133,0x1975,0x29F7,0x29F7,0x1974,0x08F2,0x1932,0x1952,0x1951,0x1930,0x2130,0x2130,0x2150,0x2130,0x2110,0x2130,0x2151,0x2131,0x1912,0x1174,0x19F7,0x19F8,0x19F7,0x1154,0x1132,0x1131,0x1931,0x2131,0x2130,0x2930,0x2930,0x210F,0x210F,0x210F,0x2930,0x292F,0x210F,0x210F,0x2130,0x2130,0x1931,0x1911,0x1132,0x1133,0x1175,0x19B6,0x19D7,0x21F7,0x19D6,0x1995,0x1153,0x1153,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x2930,0x290F,0x210F,0x2910,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x2910,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x210F,0x2930,0x2110,0x210F,0x210F,0x292F,0x292F,0x292F,0x292F,0x212F,0x210F,0x2130,0x1930,0x1951,0x1152,0x1132,0x1994,0x21F6,0x21F6,0x19B5,0x0912,0x1112,0x1932,0x1932,0x1932,0x1932,0x1952,0x1132,0x1995,0x21D6,0x21F7,0x1995,0x0912,0x1132,0x1931,0x1931,0x2130,0x2130,0x2110,0x212F,0x2130,0x2130,0x2930,0x2110,0x2110,0x2110,0x1911,0x1932,0x1133,0x1995,0x19B7,0x11D8,0x09F9,0x09D9,0x01B9,0x09D9,0x09D9,0x09D9,0x09F9,0x09F9,0x11F8,0x11D7,0x1175,0x1174,0x1133,0x1132,0x1112,0x1112,0x1932,0x1912,0x1932,0x1932,0x1931,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1931,0x1911,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1931,0x1931,0x1931,0x1911,0x1911,0x1911,0x1912,0x1912,0x1912,0x1912,0x1912,0x18F1,0x1911,0x1912,0x18F1,0x1911,0x1911,0x1931,0x1911,0x1931,0x1111,0x1111,0x1112,0x0913,0x1134,0x1155,0x19B7,0x21D7,0x19D7,0x21D7,0x1996,0x1134,0x1113,0x1912,0x2132,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x2930,0x290F,0x290F,0x290F,0x2930,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x210F,0x212F,0x2930,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x292F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x2130,0x2130,0x1931,0x1932,0x1113,0x1175,0x11B7,0x11D8,0x09B8,0x09D8,0x11D8,0x0996,0x0134,0x0934,0x1174,0x0954,0x0934,0x1155,0x0955,0x0955,0x0956,0x0997,0x11F8,0x11D8,0x09B7,0x0955,0x00F4,0x08F3,0x1113,0x1154,0x1113,0x1133,0x0912,0x0913,0x0955,0x09B7,0x09B8,0x09D8,0x11D8,0x0976,0x0934,0x0912,0x1111,0x1910,0x1910,0x2130,0x210F,0x210E,0x210F,0x210E,0x210E,0x210F,0x210E,0x210F,0x210E,0x20EE,0x210E,0x210E,0x210E,
  0x1930,0x1910,0x1910,0x190F,0x190F,0x210F,0x190F,0x190E,0x210E,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x212F,0x212F,0x2930,0x210F,0x290F,0x212F,0x292F,0x292F,0x290F,0x292F,0x292F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2930,0x2930,0x2930,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2110,0x2910,0x2910,0x212F,0x2930,0x210F,0x2130,0x2130,0x2130,0x2130,0x2930,0x210F,0x292F,0x210F,0x210F,0x292F,0x292F,0x292F,0x292F,0x2930,0x2930,0x2130,0x2130,0x2111,0x1911,0x1112,0x1155,0x1A39,0x09F9,0x01B9,0x01BA,0x01DA,0x01FB,0x01FB,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01D9,0x01D8,0x1219,0x1219,0x1218,0x1A18,0x1A18,0x19F8,0x19F8,0x1A18,0x19F8,0x19F7,0x19F8,0x19F8,0x19F8,0x21F8,0x19F8,0x21F8,0x19F8,0x19F8,0x1A18,0x1A18,0x1A18,0x1A18,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x1A18,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19D8,0x19D8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x1A18,0x1A18,0x1A18,0x1A18,0x19F8,0x19D7,0x19F7,0x19F7,0x19D6,0x1174,0x1133,0x1112,0x1931,0x1931,0x2131,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x212F,0x292F,0x2930,0x292F,0x292F,0x290F,0x290F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x2930,0x2110,0x2130,0x2930,0x2110,0x2910,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x292F,0x290F,0x290F,0x292F,0x210F,0x210F,0x2110,0x2110,0x2130,0x2131,0x2132,0x1932,0x1952,0x1953,0x1132,0x1132,0x1132,0x1132,0x1932,0x1932,0x1911,0x1911,0x2131,0x2130,0x2130,0x2930,0x2110,0x210F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x292F,0x292F,0x2130,0x2130,0x212F,0x210F,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x2110,0x210F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x2130,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x212F,0x212F,0x212F,0x2930,0x212F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2910,0x2910,0x210F,0x2930,0x290F,0x290F,0x2930,0x210F,0x2910,0x2930,0x2110,0x2110,0x2130,0x2130,0x210F,0x212F,0x292F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x290F,0x2930,0x292F,0x292F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x2930,0x2930,0x2131,0x2131,0x2131,0x1912,0x1912,0x1133,0x1154,0x1195,0x19F7,0x2217,0x2217,0x19D6,0x1133,0x1111,0x1911,0x1930,0x2150,0x2150,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2131,0x1931,0x1932,0x1112,0x1154,0x19D6,0x19F7,0x19F7,0x11B6,0x0953,0x0912,0x1111,0x1930,0x2151,0x2970,0x2950,0x212F,0x210F,0x212F,0x212F,0x214F,0x212F,0x212F,0x210F,0x2930,0x2930,0x2910,0x2910,0x2930,0x2910,0x2910,0x290F,0x2910,0x290F,0x2910,0x2930,0x2130,0x2130,0x2930,0x2910,0x2910,0x2910,0x2110,0x2930,0x2130,0x2130,0x2110,0x212F,0x2130,0x2130,0x1931,0x1931,0x1132,0x1133,0x1175,0x19B6,0x19D7,0x21F8,0x19D7,0x19B6,0x1155,0x1134,0x1133,0x0912,0x1112,0x1132,0x1132,0x1952,0x1952,0x1932,0x1932,0x1112,0x1132,0x1953,0x1953,0x1132,0x1153,0x1154,0x1154,0x1175,0x1195,0x19D7,0x2218,0x2218,0x19F7,0x1133,0x10F2,0x1912,0x1911,0x1910,0x2110,0x2110,0x2130,0x2130,0x212F,0x210F,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1112,0x1154,0x2239,0x21F8,0x19B7,0x1154,0x1953,0x1931,0x1910,0x2110,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x1910,0x1931,0x1953,0x11B5,0x19F7,0x19F8,0x1995,0x1112,0x10F1,0x1911,0x2131,0x2131,0x1932,0x1132,0x0933,0x11D7,0x11F8,0x1A18,0x11B6,0x10F2,0x1911,0x2131,0x2130,0x2130,0x2110,0x2930,0x2930,0x2110,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x2110,0x212F,0x210F,0x290F,0x290F,0x2930,0x212F,0x2930,0x210F,0x212F,0x212F,0x2110,0x2110,0x2930,0x210F,0x210F,0x2930,0x210F,0x212F,0x212F,0x292F,0x290F,0x290F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x290F,0x290F,0x210F,0x292F,0x292F,0x292F,0x2930,0x292F,0x212F,0x290F,0x210F,0x290F,0x2930,0x290F,0x210F,0x212F,0x2130,0x1931,0x1932,0x1932,0x1133,0x1995,0x2A17,0x21F7,0x1154,0x08F2,0x1112,0x1952,0x1951,0x2131,0x1930,0x2130,0x2130,0x210F,0x2130,0x2130,0x2151,0x1931,0x1932,0x1154,0x2217,0x19F8,0x19F7,0x0974,0x0913,0x1112,0x1952,0x1931,0x2131,0x2951,0x2130,0x2130,0x212F,0x210F,0x292F,0x292F,0x212F,0x210F,0x2130,0x2130,0x2131,0x2131,0x1931,0x1112,0x1133,0x1174,0x19B6,0x19D7,0x21F7,0x21F7,0x1995,0x0933,0x1132,0x1932,0x1931,0x2151,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x2110,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x290F,0x2910,0x210F,0x2910,0x2910,0x2110,0x2110,0x2930,0x2110,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2910,0x2910,0x2110,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x210F,0x2930,0x210F,0x292F,0x210F,0x292F,0x212F,0x212F,0x2130,0x2130,0x1931,0x1132,0x1132,0x1994,0x21F6,0x21F6,0x1994,0x0912,0x1112,0x1932,0x1911,0x1932,0x1932,0x1932,0x1133,0x19B5,0x21F6,0x21D6,0x1995,0x0912,0x1132,0x1952,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2110,0x2110,0x1911,0x1932,0x1953,0x1995,0x19D7,0x1A19,0x11F9,0x09F9,0x09D9,0x09D9,0x11F9,0x1219,0x11F8,0x1196,0x1174,0x1133,0x1132,0x1932,0x1932,0x1931,0x1911,0x1931,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x1910,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1910,0x1931,0x2131,0x2131,0x2131,0x2131,0x1910,0x2131,0x2131,0x2131,0x2131,0x2131,0x2110,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x1931,0x1911,0x2110,0x2111,0x2110,0x2110,0x2131,0x1910,0x2131,0x1930,0x2151,0x2130,0x1910,0x1910,0x1930,0x1910,0x1931,0x1911,0x2131,0x2131,0x2131,0x1911,0x2111,0x2111,0x2111,0x2111,0x2131,0x2111,0x2110,0x2130,0x2130,0x2131,0x2131,0x2131,0x2151,0x1911,0x1112,0x1112,0x1134,0x1155,0x1996,0x21D7,0x21F8,0x21D7,0x19D7,0x1134,0x08F2,0x1912,0x2132,0x2131,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2930,0x2110,0x2130,0x212F,0x210F,0x210F,0x2930,0x290F,0x290F,0x210F,0x2930,0x2910,0x2910,0x210F,0x2910,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2110,0x2131,0x1911,0x1112,0x1134,0x1196,0x11D7,0x09D8,0x09B7,0x09B7,0x0935,0x00F3,0x08F2,0x1112,0x0912,0x1113,0x1133,0x0913,0x0934,0x0934,0x0996,0x11B7,0x11F8,0x1196,0x0934,0x08D3,0x08F2,0x10F2,0x1932,0x1132,0x08F1,0x08F1,0x08F2,0x0954,0x11D7,0x11F8,0x11D8,0x09B7,0x0975,0x0913,0x1132,0x1111,0x1910,0x2130,0x210F,0x20EF,0x20EE,0x20EE,0x210E,0x210E,0x292F,0x210F,0x210F,0x210E,0x20EE,0x210E,0x210F,0x210F,
  0x1911,0x1931,0x1910,0x1910,0x190F,0x190F,0x190F,0x190F,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2110,0x2110,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x212F,0x210F,0x210F,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x2930,0x212F,0x212F,0x210F,0x2930,0x212F,0x292F,0x292F,0x212F,0x292F,0x292F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x290F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2930,0x212F,0x212F,0x212F,0x2110,0x2110,0x2910,0x2930,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x212F,0x292F,0x210F,0x292F,0x210F,0x292F,0x2930,0x2930,0x212F,0x2130,0x2130,0x2110,0x2111,0x1931,0x1112,0x1155,0x1A19,0x01B9,0x01B9,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01D9,0x01B8,0x09D7,0x09B6,0x11B6,0x11B6,0x1196,0x11B6,0x1196,0x1196,0x19B6,0x19B6,0x1195,0x1996,0x1996,0x1996,0x1996,0x19B6,0x1996,0x19B6,0x19B6,0x19B6,0x19B6,0x11B5,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x11B6,0x11B6,0x19B6,0x19B6,0x1996,0x19B6,0x19B6,0x19B6,0x19B6,0x1996,0x1996,0x19B6,0x1996,0x19B6,0x1996,0x1996,0x19B6,0x19B6,0x19B6,0x1196,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19D6,0x19D6,0x19F7,0x19F7,0x21F7,0x19D6,0x1994,0x1133,0x1111,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x210F,0x210F,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2110,0x2110,0x210F,0x2930,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x292F,0x290F,0x290F,0x292F,0x290F,0x290F,0x2930,0x2130,0x2131,0x2131,0x1931,0x1932,0x1931,0x1932,0x1912,0x1932,0x1931,0x1911,0x1931,0x1911,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2130,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x290F,0x212F,0x2130,0x212F,0x2130,0x212F,0x2130,0x2930,0x2930,0x212F,0x2930,0x210F,0x210F,0x2130,0x2130,0x2910,0x210F,0x210F,0x2130,0x2130,0x2930,0x212F,0x2130,0x212F,0x210F,0x290F,0x2930,0x210F,0x210F,0x292F,0x292F,0x212F,0x292F,0x292F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2910,0x210F,0x290F,0x290F,0x290F,0x2930,0x2910,0x210F,0x2910,0x2110,0x2110,0x210F,0x210F,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x28F0,0x2910,0x2910,0x290F,0x290F,0x2930,0x292F,0x292F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2111,0x2111,0x1912,0x1912,0x1133,0x1154,0x19B6,0x2217,0x19F7,0x21F7,0x1995,0x1132,0x1912,0x1910,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x212F,0x2950,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2131,0x1932,0x1133,0x1133,0x19D6,0x1A17,0x19F7,0x11B6,0x1153,0x0912,0x1111,0x1930,0x2151,0x2950,0x2950,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x20EF,0x2110,0x2930,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x1910,0x1931,0x1932,0x1133,0x1154,0x1175,0x19B7,0x19D7,0x21D7,0x19D7,0x19B6,0x1175,0x1154,0x0933,0x0912,0x0912,0x0912,0x1132,0x1132,0x1132,0x1112,0x1132,0x1133,0x1133,0x1133,0x1153,0x1154,0x1154,0x1175,0x11B6,0x19D7,0x1A18,0x2218,0x2217,0x1995,0x1112,0x10F1,0x1911,0x1911,0x2110,0x2110,0x2110,0x2950,0x2130,0x210F,0x2130,0x2130,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2131,0x1931,0x1931,0x1112,0x0913,0x21D7,0x2239,0x21F8,0x19B6,0x1954,0x1952,0x2131,0x2130,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2131,0x1931,0x1153,0x1195,0x19F7,0x2218,0x1195,0x1112,0x1911,0x1911,0x2131,0x1911,0x1932,0x1132,0x1133,0x11D6,0x11F8,0x1A18,0x19B6,0x10F2,0x1911,0x2111,0x2130,0x2110,0x2930,0x2930,0x2110,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x2110,0x2110,0x212F,0x212F,0x210F,0x210F,0x212F,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x2110,0x2930,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x2930,0x290F,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x2930,0x210F,0x292F,0x210F,0x292F,0x292F,0x292F,0x2930,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x2130,0x2131,0x1932,0x1132,0x1133,0x1975,0x2A17,0x29F7,0x1974,0x08F2,0x1112,0x1932,0x2151,0x2131,0x2110,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x1911,0x1932,0x1133,0x19D6,0x19F8,0x19F8,0x11B6,0x0934,0x1133,0x1132,0x1932,0x1931,0x2151,0x2130,0x210F,0x210F,0x212F,0x212F,0x2950,0x292F,0x210F,0x210F,0x2110,0x2151,0x2131,0x1931,0x1911,0x1112,0x1133,0x1975,0x1996,0x21F7,0x21F7,0x19D6,0x19B5,0x1153,0x1132,0x1932,0x1931,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x2910,0x290F,0x290F,0x210F,0x2930,0x2110,0x210F,0x2910,0x2910,0x210F,0x2910,0x2110,0x2110,0x210F,0x2910,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2910,0x210F,0x212F,0x2130,0x212F,0x212F,0x292F,0x292F,0x210F,0x212F,0x2130,0x2131,0x1931,0x1932,0x1132,0x1994,0x21F6,0x21F6,0x19B5,0x0912,0x1112,0x1932,0x1932,0x1932,0x1932,0x1932,0x1133,0x19B5,0x21D6,0x21D6,0x19B5,0x0912,0x1132,0x1952,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2930,0x212F,0x2930,0x2130,0x2110,0x2130,0x1931,0x1932,0x1954,0x1995,0x11B6,0x11D7,0x19F8,0x11D8,0x11D7,0x11B7,0x1196,0x1175,0x1154,0x1133,0x1932,0x1932,0x1931,0x1931,0x1931,0x1930,0x2131,0x2131,0x2131,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2131,0x2131,0x1931,0x1931,0x1112,0x1112,0x1133,0x1154,0x19B6,0x19D7,0x21F8,0x21F7,0x1996,0x1134,0x08F2,0x1912,0x2152,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x290F,0x292F,0x290F,0x292F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x2910,0x210F,0x2910,0x210F,0x290F,0x210F,0x290F,0x290F,0x292F,0x290F,0x290F,0x292F,0x290F,0x292F,0x290F,0x290F,0x290F,0x292F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2130,0x2110,0x2110,0x1911,0x1111,0x1113,0x1996,0x11D7,0x11D8,0x11B7,0x1196,0x0934,0x0912,0x1112,0x1112,0x1912,0x1912,0x1112,0x1133,0x1133,0x0933,0x1196,0x19F7,0x11D7,0x11B6,0x0914,0x08F2,0x1112,0x1111,0x1111,0x1111,0x1111,0x1111,0x0912,0x0933,0x11B7,0x11D8,0x11B7,0x11D7,0x0954,0x08F2,0x10F1,0x1110,0x1910,0x210F,0x210F,0x210F,0x210E,0x210F,0x210E,0x210F,0x210F,0x210F,0x212F,0x212F,0x20EE,0x292F,0x210F,0x210F,
  0x1132,0x1131,0x1931,0x1910,0x1910,0x1910,0x190F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x212F,0x212F,0x290F,0x210F,0x212F,0x2930,0x212F,0x210F,0x2930,0x212F,0x210F,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x290F,0x2930,0x2910,0x2910,0x290F,0x210F,0x2930,0x2110,0x210F,0x290F,0x2930,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x290F,0x290F,0x210F,0x292F,0x212F,0x212F,0x2930,0x2130,0x2130,0x2110,0x2131,0x1932,0x1132,0x0934,0x1A19,0x09D9,0x01B9,0x01DA,0x01DA,0x01DB,0x01FA,0x01DA,0x01FA,0x01DA,0x01FA,0x01FB,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01D9,0x01B8,0x0976,0x0934,0x0933,0x1133,0x1153,0x1154,0x1153,0x1133,0x1153,0x1153,0x1153,0x1974,0x1933,0x1133,0x1933,0x1933,0x1933,0x1933,0x1953,0x1153,0x1152,0x1153,0x1953,0x1153,0x1133,0x1133,0x1133,0x1133,0x1153,0x1153,0x1153,0x1133,0x1153,0x1153,0x1153,0x1153,0x1153,0x1153,0x1133,0x1153,0x1153,0x1133,0x1153,0x1153,0x1133,0x1133,0x1153,0x1133,0x1153,0x1153,0x1153,0x1153,0x1153,0x1153,0x1154,0x1995,0x19F6,0x2217,0x2217,0x19D6,0x19B5,0x1153,0x1111,0x1911,0x1931,0x2151,0x2150,0x2130,0x2110,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x210F,0x212F,0x292F,0x210F,0x290F,0x290F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x290F,0x290F,0x290F,0x212F,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2110,0x2130,0x2131,0x2131,0x2131,0x1931,0x1931,0x2131,0x1931,0x2131,0x2131,0x1930,0x2130,0x2110,0x210F,0x210F,0x212F,0x210F,0x210F,0x290F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x210F,0x212F,0x2130,0x2930,0x2130,0x2930,0x2930,0x2130,0x2130,0x212F,0x210F,0x212F,0x2930,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2910,0x2910,0x2930,0x210F,0x2910,0x210F,0x2910,0x2930,0x210F,0x290F,0x2910,0x210F,0x290F,0x290F,0x292F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x2930,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2111,0x1931,0x1932,0x1153,0x1174,0x19B6,0x19D6,0x19F7,0x21F6,0x1994,0x1932,0x1911,0x1911,0x2130,0x2130,0x210F,0x212F,0x210F,0x212F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1932,0x1132,0x1153,0x19D6,0x1A17,0x11D6,0x11B5,0x1154,0x1132,0x1911,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2930,0x2930,0x210F,0x2110,0x2930,0x2930,0x2910,0x210F,0x2910,0x2910,0x2910,0x2930,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x210F,0x212F,0x2130,0x2130,0x2151,0x1931,0x1932,0x1933,0x1154,0x1175,0x1996,0x19B7,0x19D7,0x19D7,0x19D7,0x19B6,0x1195,0x0954,0x0933,0x0933,0x0933,0x0933,0x1153,0x1133,0x1133,0x1133,0x0933,0x1154,0x1175,0x1175,0x11B6,0x19D7,0x1A17,0x1A18,0x2218,0x19D7,0x1995,0x1133,0x10F1,0x1911,0x1931,0x2131,0x2130,0x2130,0x2130,0x210F,0x2130,0x210F,0x2130,0x212F,0x2130,0x2130,0x212F,0x210F,0x290F,0x290F,0x292F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2930,0x2130,0x210F,0x2110,0x2110,0x2130,0x2131,0x1931,0x1932,0x1112,0x1133,0x19B6,0x2A58,0x2218,0x19B7,0x1155,0x1133,0x1932,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x212F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x2130,0x2110,0x1910,0x1931,0x1132,0x11B5,0x1A18,0x2218,0x1195,0x1132,0x1932,0x1911,0x2131,0x1931,0x2152,0x1132,0x0933,0x11D6,0x11F8,0x1A18,0x19D6,0x10F2,0x1911,0x2111,0x2110,0x2110,0x2930,0x2930,0x2110,0x210F,0x212F,0x2930,0x2130,0x212F,0x212F,0x2930,0x2930,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2930,0x212F,0x210F,0x212F,0x210F,0x212F,0x2930,0x212F,0x210F,0x2930,0x210F,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x210F,0x292F,0x210F,0x212F,0x292F,0x212F,0x2930,0x2110,0x210F,0x2910,0x210F,0x210F,0x2930,0x210F,0x2130,0x2130,0x2131,0x1952,0x1932,0x1113,0x1975,0x2A17,0x21F7,0x1974,0x1112,0x1932,0x1932,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x2130,0x2131,0x1932,0x1133,0x0933,0x19F7,0x1A18,0x19F7,0x11B6,0x0934,0x0913,0x1953,0x1932,0x2152,0x2131,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2151,0x2131,0x1911,0x1932,0x1133,0x1174,0x19B6,0x21F7,0x21F7,0x19D6,0x1195,0x1153,0x1132,0x1931,0x1931,0x2131,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2910,0x210F,0x2910,0x210F,0x2910,0x2910,0x2910,0x210F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x210F,0x212F,0x210F,0x212F,0x292F,0x292F,0x292F,0x2130,0x2130,0x2131,0x1952,0x1952,0x1153,0x1995,0x21F6,0x21F6,0x19B5,0x0912,0x1112,0x1112,0x1911,0x1932,0x1952,0x1952,0x1153,0x19B5,0x21D6,0x2217,0x19B5,0x0912,0x1112,0x1932,0x2131,0x1930,0x2130,0x210F,0x212F,0x2130,0x2130,0x212F,0x212F,0x2130,0x212F,0x210F,0x2130,0x2130,0x1931,0x1932,0x1953,0x1153,0x1974,0x1995,0x1175,0x1154,0x1154,0x1154,0x1153,0x1952,0x1931,0x1931,0x1931,0x1910,0x1910,0x1930,0x1930,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2150,0x2130,0x2131,0x1931,0x1931,0x1932,0x1112,0x1153,0x1174,0x19B6,0x19D7,0x21F7,0x19D7,0x1996,0x1154,0x08F2,0x1932,0x2132,0x2131,0x2151,0x2131,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x210F,0x290F,0x290F,0x2930,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x2930,0x290F,0x210F,0x2930,0x210F,0x2130,0x2130,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x292F,0x290F,0x292F,0x292F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x292F,0x212F,0x292F,0x290F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2111,0x1911,0x10F2,0x1154,0x11B7,0x11B7,0x11D8,0x11B7,0x0934,0x1112,0x1111,0x1911,0x1932,0x1911,0x1932,0x1132,0x1133,0x0933,0x19D6,0x2238,0x19D7,0x1195,0x0913,0x1112,0x1912,0x1931,0x1911,0x1931,0x1931,0x1131,0x1111,0x1153,0x11B6,0x11D8,0x1A18,0x11D7,0x0933,0x08F1,0x1111,0x1930,0x18EF,0x210F,0x210F,0x210E,0x210E,0x210E,0x210F,0x212F,0x210F,0x210E,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,
  0x1974,0x1153,0x1932,0x1931,0x1931,0x1910,0x1910,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x212F,0x210F,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x290F,0x290F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x290F,0x2930,0x210F,0x2930,0x212F,0x212F,0x212F,0x2930,0x210F,0x290F,0x2910,0x2910,0x2930,0x210F,0x210F,0x2110,0x290F,0x290F,0x290F,0x210F,0x290F,0x212F,0x212F,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x290F,0x290F,0x292F,0x292F,0x212F,0x212F,0x2930,0x2110,0x2110,0x2130,0x2131,0x1931,0x1112,0x1154,0x1A19,0x09F9,0x01DA,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x09F9,0x0197,0x0975,0x0933,0x1132,0x1132,0x1112,0x1112,0x1912,0x1912,0x1112,0x1112,0x1932,0x1912,0x1912,0x1912,0x1912,0x1911,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1932,0x1912,0x1932,0x1932,0x1932,0x1932,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1932,0x1932,0x1932,0x1932,0x1931,0x1111,0x1932,0x1911,0x1931,0x1111,0x1932,0x1112,0x1132,0x1132,0x1132,0x1133,0x1174,0x19F6,0x21F7,0x21F7,0x19D6,0x1994,0x1153,0x1132,0x1931,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x210F,0x2110,0x2110,0x290F,0x290F,0x290F,0x292F,0x292F,0x212F,0x210F,0x210F,0x2910,0x2910,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x2930,0x2110,0x2930,0x2910,0x210F,0x2910,0x210F,0x210F,0x210F,0x290F,0x292F,0x290F,0x290F,0x292F,0x290F,0x292F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2131,0x2131,0x2131,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x292F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x292F,0x292F,0x292F,0x290F,0x210F,0x210F,0x2130,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2930,0x210F,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2910,0x290F,0x290F,0x2910,0x2930,0x210F,0x2910,0x290F,0x290F,0x2910,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x292F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2910,0x210F,0x210F,0x292F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2131,0x1931,0x1932,0x1153,0x1194,0x11D6,0x19D7,0x1A17,0x21F6,0x1133,0x1912,0x1911,0x1910,0x2951,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x212F,0x2110,0x2130,0x2131,0x1932,0x1132,0x1133,0x19D6,0x1A17,0x11D6,0x19B6,0x1154,0x1112,0x1911,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x212F,0x2910,0x2910,0x290F,0x2910,0x2910,0x290F,0x292F,0x292F,0x2930,0x2910,0x2910,0x2910,0x2910,0x28F0,0x2910,0x2110,0x2930,0x2110,0x210F,0x212F,0x212F,0x2130,0x2130,0x1931,0x1931,0x1932,0x1933,0x1154,0x1955,0x1175,0x19B6,0x19D7,0x19D7,0x19F7,0x19D7,0x19D6,0x1195,0x1175,0x0954,0x0954,0x0954,0x0954,0x0954,0x0934,0x1155,0x1175,0x1196,0x19D7,0x19F8,0x19F8,0x2218,0x19F7,0x19D6,0x1195,0x1153,0x1112,0x1911,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x290F,0x290F,0x290F,0x292F,0x292F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x210F,0x2930,0x2110,0x2130,0x2131,0x2131,0x1932,0x1132,0x1133,0x1195,0x2A58,0x2218,0x19D7,0x1996,0x1133,0x1933,0x1931,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2930,0x2930,0x2110,0x2130,0x2130,0x1930,0x1932,0x1133,0x19B6,0x1A18,0x19F7,0x1195,0x1132,0x1911,0x1911,0x1911,0x2131,0x1932,0x1932,0x0933,0x11D6,0x11F8,0x19F8,0x19D6,0x10F2,0x1911,0x2111,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2930,0x212F,0x212F,0x212F,0x2130,0x210F,0x210F,0x2110,0x212F,0x212F,0x2930,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x2930,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2910,0x210F,0x2930,0x290F,0x210F,0x2110,0x2130,0x2130,0x1931,0x1932,0x1932,0x1133,0x1975,0x2A17,0x21F7,0x1995,0x08F2,0x1932,0x2152,0x2131,0x2130,0x2110,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2131,0x1931,0x1932,0x0933,0x1195,0x19F8,0x19F8,0x19F8,0x1196,0x0934,0x1133,0x1132,0x1932,0x2131,0x2130,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2131,0x2131,0x1932,0x1132,0x1153,0x1174,0x19B6,0x21F7,0x21F7,0x21F6,0x1995,0x1153,0x1932,0x1932,0x2131,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x292F,0x210F,0x292F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x2110,0x2910,0x210F,0x210F,0x210F,0x2930,0x210F,0x2930,0x2910,0x2910,0x2910,0x2930,0x2930,0x210F,0x2910,0x2110,0x2130,0x210F,0x212F,0x212F,0x212F,0x292F,0x2930,0x2130,0x2130,0x2131,0x1952,0x1952,0x1133,0x1995,0x21F6,0x21F7,0x19B5,0x0912,0x1112,0x1112,0x1932,0x1932,0x1952,0x1132,0x1153,0x19B5,0x21F6,0x2217,0x19D6,0x0912,0x1112,0x1932,0x2151,0x2131,0x2130,0x2130,0x210F,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1910,0x1931,0x1931,0x1932,0x1932,0x1132,0x1132,0x1933,0x1953,0x1932,0x1932,0x1931,0x1910,0x1910,0x2130,0x1910,0x2110,0x1930,0x1930,0x2110,0x210F,0x2130,0x210F,0x2130,0x210F,0x210F,0x212F,0x210F,0x2130,0x212F,0x212F,0x2110,0x2110,0x210F,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x210F,0x2130,0x210F,0x210F,0x212F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2110,0x210F,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2930,0x2130,0x2930,0x2910,0x2910,0x2110,0x2930,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2151,0x1931,0x1932,0x1132,0x1153,0x1154,0x1996,0x19D7,0x19D7,0x21F7,0x19B6,0x1134,0x1112,0x1912,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x292F,0x292F,0x292F,0x292F,0x210F,0x2110,0x2930,0x2110,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x2930,0x210F,0x290F,0x290F,0x210F,0x210F,0x2130,0x212F,0x210F,0x290F,0x2930,0x290F,0x290F,0x292F,0x290F,0x210F,0x210F,0x2930,0x292F,0x292F,0x2930,0x290F,0x290F,0x292F,0x290F,0x292F,0x290F,0x290F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2110,0x2131,0x1911,0x10F1,0x1133,0x19B7,0x19F8,0x11D7,0x11B6,0x0933,0x1112,0x1911,0x1911,0x1911,0x1911,0x1911,0x1912,0x1132,0x0933,0x19B6,0x19F7,0x19D7,0x1995,0x0913,0x10F2,0x1911,0x1910,0x1930,0x1910,0x1930,0x1910,0x1111,0x1133,0x11B6,0x11D7,0x11D8,0x11B7,0x0933,0x08F1,0x1911,0x1910,0x1910,0x210F,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,
  0x2217,0x1174,0x1153,0x1132,0x1932,0x1931,0x1931,0x2130,0x190F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x212F,0x212F,0x2930,0x2110,0x212F,0x212F,0x290F,0x290F,0x212F,0x2930,0x2930,0x210F,0x2930,0x212F,0x2930,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x290F,0x210F,0x292F,0x210F,0x292F,0x210F,0x290F,0x2930,0x2930,0x2130,0x2131,0x1911,0x1112,0x1154,0x1A19,0x09D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01FA,0x09F9,0x09B7,0x0975,0x1153,0x1153,0x1932,0x1932,0x1912,0x1932,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1930,0x1931,0x1911,0x1931,0x1931,0x1931,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x2131,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1932,0x1932,0x1132,0x1153,0x1154,0x19B5,0x21F7,0x19F6,0x19D6,0x19B5,0x1153,0x1132,0x1911,0x1931,0x2151,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2930,0x2930,0x210F,0x210F,0x290F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2110,0x2910,0x2910,0x210F,0x290F,0x290F,0x292F,0x290F,0x292F,0x290F,0x292F,0x292F,0x290F,0x290F,0x212F,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2130,0x210F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x212F,0x212F,0x2930,0x2930,0x212F,0x212F,0x2130,0x2130,0x210F,0x210F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x292F,0x290F,0x210F,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2930,0x2930,0x2930,0x292F,0x290F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2131,0x1931,0x1953,0x1174,0x1195,0x11D6,0x19F7,0x19D6,0x1174,0x1133,0x1911,0x1931,0x2131,0x2130,0x2130,0x2930,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1952,0x1133,0x1133,0x19F7,0x2217,0x19F7,0x1195,0x1153,0x1112,0x1911,0x2131,0x2130,0x2130,0x2110,0x2130,0x210F,0x2130,0x212F,0x212F,0x210F,0x212F,0x292F,0x210F,0x210F,0x290F,0x212F,0x212F,0x290F,0x210F,0x292F,0x290F,0x292F,0x292F,0x290F,0x292F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1932,0x1912,0x1933,0x1134,0x1955,0x1175,0x1196,0x1196,0x11B6,0x11B6,0x11D7,0x11D6,0x19D6,0x11D6,0x11D6,0x11D6,0x11D6,0x11B6,0x19D7,0x19D7,0x19D7,0x19F7,0x19F8,0x19D7,0x19D7,0x19B6,0x1175,0x1154,0x1133,0x1933,0x1932,0x1931,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x292F,0x292F,0x290F,0x290F,0x292F,0x290F,0x292F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2110,0x2110,0x2111,0x2131,0x1932,0x1132,0x1153,0x1995,0x2A38,0x2A18,0x19B7,0x1996,0x1954,0x1112,0x1932,0x1931,0x2110,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x212F,0x2930,0x210F,0x2110,0x2130,0x2110,0x2151,0x1951,0x1132,0x1133,0x19D6,0x2238,0x19F7,0x1175,0x1132,0x1932,0x1931,0x1911,0x2131,0x2152,0x1932,0x1133,0x19D7,0x1A18,0x1A18,0x19B6,0x10F2,0x1911,0x2111,0x2130,0x2110,0x2930,0x2110,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x2110,0x2910,0x210F,0x2930,0x2110,0x2930,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x290F,0x290F,0x2910,0x2130,0x2130,0x1910,0x1931,0x1932,0x1133,0x1995,0x2A17,0x21F7,0x1975,0x1112,0x1932,0x2152,0x2131,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2131,0x1952,0x1133,0x1154,0x19B6,0x19D7,0x19F8,0x2218,0x1175,0x0933,0x1133,0x1132,0x1932,0x2171,0x2130,0x2130,0x212F,0x212F,0x2130,0x212F,0x212F,0x210F,0x292F,0x2930,0x2930,0x2130,0x2131,0x1911,0x1932,0x1953,0x1153,0x1174,0x19B6,0x19F7,0x2217,0x19D6,0x1995,0x1153,0x1132,0x1932,0x2131,0x2111,0x2131,0x2130,0x2130,0x2110,0x2130,0x2930,0x292F,0x212F,0x212F,0x212F,0x212F,0x290F,0x2910,0x2910,0x210F,0x210F,0x2930,0x2910,0x290F,0x210F,0x2910,0x210F,0x2910,0x2910,0x210F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2930,0x210F,0x210F,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x292F,0x210F,0x292F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1932,0x0912,0x1995,0x21F6,0x2217,0x19B6,0x0912,0x1112,0x1932,0x1932,0x1932,0x1952,0x1932,0x1132,0x1994,0x21F6,0x19F6,0x19D6,0x0913,0x1112,0x1932,0x1951,0x2151,0x2130,0x2130,0x210F,0x2130,0x2950,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x1930,0x1930,0x1931,0x1931,0x1952,0x1932,0x1932,0x1911,0x1931,0x2131,0x2131,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2930,0x212F,0x292F,0x212F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x2110,0x2110,0x2930,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2930,0x210F,0x2110,0x2110,0x2110,0x210F,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x2110,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2150,0x212F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2910,0x2910,0x20EF,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2131,0x1931,0x1931,0x1112,0x1153,0x1174,0x1196,0x19F7,0x2218,0x21F7,0x19B6,0x1134,0x1933,0x1112,0x1911,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x212F,0x212F,0x214F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x210F,0x290F,0x2930,0x210F,0x210F,0x212F,0x212F,0x290F,0x210F,0x2930,0x2910,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x290F,0x292F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x1911,0x18F1,0x1953,0x19D7,0x11D7,0x19F8,0x11B6,0x1133,0x1111,0x1911,0x2130,0x2110,0x2110,0x1911,0x1911,0x1132,0x1133,0x19B6,0x2217,0x19D7,0x1995,0x0913,0x10F2,0x1931,0x1931,0x1910,0x1910,0x1910,0x1930,0x1931,0x1153,0x11B6,0x19F8,0x19F8,0x19D7,0x0913,0x1111,0x1931,0x1930,0x190F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,
  0x2238,0x19B6,0x1175,0x1133,0x1132,0x1932,0x1931,0x1931,0x1910,0x1910,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x290F,0x210F,0x212F,0x290F,0x210F,0x212F,0x210F,0x210F,0x2910,0x2910,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x2910,0x2910,0x212F,0x212F,0x290F,0x290F,0x212F,0x212F,0x290F,0x290F,0x2930,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x2930,0x210F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x210F,0x292F,0x292F,0x290F,0x2910,0x2110,0x2110,0x2110,0x1931,0x1932,0x1134,0x1A18,0x09D9,0x09FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01FA,0x01FA,0x01F9,0x09D9,0x09B7,0x0975,0x0933,0x1132,0x1932,0x1932,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x2131,0x2111,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1931,0x2151,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1932,0x1932,0x1132,0x1153,0x1174,0x19B5,0x21F7,0x21F7,0x21D6,0x1995,0x1153,0x1112,0x1911,0x1931,0x2131,0x2151,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2950,0x2130,0x2130,0x2130,0x2130,0x2930,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x292F,0x212F,0x292F,0x212F,0x212F,0x2130,0x2110,0x210F,0x212F,0x2130,0x210F,0x2130,0x210F,0x210F,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2930,0x212F,0x292F,0x290F,0x290F,0x210F,0x2130,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x212F,0x2930,0x2930,0x292F,0x292F,0x212F,0x212F,0x210F,0x2110,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x210F,0x2130,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2910,0x2110,0x2110,0x2910,0x2910,0x210F,0x2930,0x2930,0x2930,0x290F,0x210F,0x212F,0x292F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x290F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x1931,0x1932,0x1973,0x1174,0x11B6,0x19F7,0x19F7,0x19B6,0x1154,0x1932,0x1931,0x2110,0x2130,0x2110,0x2930,0x2130,0x212F,0x292F,0x212F,0x292F,0x212F,0x2130,0x2110,0x2131,0x1932,0x1132,0x1153,0x19D6,0x2217,0x19D6,0x1995,0x1154,0x1112,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x292F,0x292F,0x292F,0x290F,0x290F,0x212F,0x212F,0x2930,0x210F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x2930,0x2910,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x292F,0x210F,0x2930,0x2130,0x2110,0x2130,0x1911,0x1931,0x1932,0x1932,0x1933,0x1154,0x1175,0x1175,0x1175,0x11B6,0x11D6,0x11B6,0x11D7,0x19F7,0x1A17,0x2218,0x1A17,0x1A17,0x19F7,0x19D7,0x19D7,0x19D7,0x19B6,0x19B7,0x1195,0x1175,0x1154,0x1133,0x1933,0x1932,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x292F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2930,0x2931,0x2111,0x1911,0x1112,0x1133,0x1995,0x2217,0x2218,0x21F7,0x1996,0x1134,0x1133,0x1912,0x1911,0x2131,0x2110,0x2130,0x210F,0x212F,0x212F,0x212F,0x2950,0x292F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2130,0x2131,0x1951,0x1931,0x1132,0x0933,0x21F7,0x2238,0x19D7,0x1175,0x1933,0x1931,0x1911,0x1911,0x2131,0x2152,0x1932,0x1133,0x11B6,0x19F8,0x1A18,0x19D6,0x08F2,0x1911,0x2131,0x2110,0x2110,0x2110,0x2130,0x2930,0x210F,0x2930,0x2930,0x290F,0x2110,0x2110,0x290F,0x210F,0x2930,0x2110,0x210F,0x212F,0x212F,0x210F,0x210F,0x290F,0x210F,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x2930,0x210F,0x2930,0x212F,0x212F,0x2930,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2910,0x2910,0x2110,0x2110,0x2910,0x210F,0x210F,0x210F,0x2130,0x2130,0x2131,0x1932,0x1932,0x1133,0x1975,0x2A18,0x21F7,0x1995,0x08F2,0x1933,0x2152,0x2131,0x2130,0x2130,0x212F,0x212F,0x292F,0x292F,0x212F,0x210F,0x2130,0x2131,0x1952,0x1932,0x1133,0x1154,0x19B6,0x19F7,0x21F8,0x19F7,0x1175,0x0933,0x1133,0x1932,0x2152,0x2151,0x1910,0x2130,0x2130,0x2130,0x210F,0x210F,0x292F,0x2930,0x290F,0x2910,0x2130,0x2130,0x2131,0x1952,0x1932,0x1153,0x1133,0x1154,0x19B6,0x19F7,0x2217,0x19D6,0x1995,0x1953,0x1112,0x1932,0x2152,0x2131,0x2131,0x2110,0x2110,0x2110,0x2130,0x2930,0x210F,0x210F,0x210F,0x212F,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2930,0x2910,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x2910,0x2910,0x2110,0x2930,0x290F,0x290F,0x2930,0x2930,0x210F,0x290F,0x290F,0x212F,0x212F,0x210F,0x210F,0x2130,0x210F,0x2110,0x2130,0x2930,0x290F,0x292F,0x210F,0x210F,0x2110,0x2131,0x1911,0x1912,0x1112,0x1995,0x21F6,0x21F7,0x21D6,0x0913,0x1112,0x1932,0x1932,0x1932,0x1952,0x1932,0x1132,0x1994,0x21D6,0x21F7,0x21F7,0x1134,0x1112,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2950,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1931,0x1911,0x1931,0x1911,0x1910,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x2130,0x210F,0x2930,0x2110,0x2930,0x2930,0x292F,0x292F,0x292F,0x210F,0x210F,0x2930,0x212F,0x212F,0x210F,0x2110,0x2110,0x2930,0x2130,0x2930,0x2930,0x212F,0x2930,0x2930,0x290F,0x2930,0x2930,0x292F,0x292F,0x292F,0x292F,0x210F,0x2930,0x292F,0x212F,0x2930,0x2930,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x210F,0x2110,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x2930,0x2910,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x1930,0x1931,0x1131,0x1132,0x1153,0x1174,0x19D6,0x19D7,0x2218,0x2217,0x1996,0x1154,0x1113,0x1112,0x1911,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x292F,0x290F,0x290F,0x212F,0x210F,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2910,0x2910,0x2910,0x210F,0x2910,0x2910,0x2110,0x210F,0x210F,0x2930,0x290F,0x2910,0x2910,0x290F,0x2930,0x210F,0x290F,0x290F,0x292F,0x290F,0x290F,0x292F,0x290F,0x292F,0x292F,0x210F,0x292F,0x292F,0x212F,0x210F,0x292F,0x210F,0x210F,0x2930,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x1910,0x1911,0x1133,0x19D7,0x11D7,0x11B7,0x19B6,0x1133,0x1911,0x1911,0x2110,0x2110,0x2110,0x2111,0x1911,0x1932,0x1133,0x19B5,0x2217,0x19D7,0x1195,0x0912,0x10F1,0x1911,0x1910,0x2130,0x2130,0x1910,0x1930,0x1931,0x1153,0x11B6,0x11D7,0x19F8,0x19D7,0x0933,0x1111,0x1931,0x1930,0x190F,0x190F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,
  0x19F7,0x19F7,0x1195,0x1154,0x1133,0x1132,0x1932,0x1932,0x1931,0x1930,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x210F,0x210F,0x210F,0x2930,0x212F,0x2930,0x212F,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x2110,0x2910,0x2910,0x210F,0x212F,0x212F,0x210F,0x2910,0x210F,0x292F,0x210F,0x290F,0x290F,0x212F,0x212F,0x292F,0x292F,0x212F,0x210F,0x290F,0x290F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x2930,0x2930,0x290F,0x290F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x212F,0x212F,0x212F,0x210F,0x292F,0x212F,0x212F,0x292F,0x292F,0x212F,0x210F,0x290F,0x210F,0x2910,0x2930,0x2110,0x2130,0x1931,0x1932,0x1154,0x1A18,0x09F9,0x01D9,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01F9,0x01F9,0x09D9,0x09B7,0x1195,0x1153,0x1132,0x1932,0x1931,0x1931,0x1911,0x1911,0x2151,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1931,0x2131,0x2131,0x1931,0x1931,0x2131,0x2151,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1930,0x2131,0x1931,0x1931,0x2131,0x2131,0x2131,0x2131,0x1931,0x1931,0x2131,0x2151,0x1931,0x1952,0x1931,0x1931,0x1931,0x1932,0x1932,0x1132,0x1133,0x1133,0x1154,0x19B6,0x21F7,0x2217,0x19D6,0x1174,0x1153,0x1132,0x1112,0x1932,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2110,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x292F,0x292F,0x292F,0x292F,0x2930,0x2130,0x2130,0x2930,0x2910,0x2930,0x2930,0x210F,0x210F,0x290F,0x2930,0x2930,0x290F,0x292F,0x292F,0x292F,0x292F,0x292F,0x210F,0x292F,0x292F,0x292F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x2930,0x2910,0x2910,0x2910,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x212F,0x292F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2930,0x2110,0x210F,0x2110,0x2930,0x2910,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x210F,0x290F,0x292F,0x212F,0x2930,0x2130,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x210F,0x2910,0x2910,0x2930,0x2930,0x290F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2930,0x2930,0x292F,0x212F,0x210F,0x2130,0x2930,0x2130,0x2130,0x2131,0x1911,0x1132,0x1153,0x1195,0x11D7,0x1A17,0x19D7,0x1154,0x1953,0x1931,0x2111,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x292F,0x212F,0x2130,0x2110,0x2131,0x2132,0x1112,0x1153,0x19D6,0x2217,0x19D6,0x1995,0x1153,0x1112,0x1931,0x2131,0x2131,0x2131,0x2110,0x2130,0x2930,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2130,0x212F,0x212F,0x2130,0x2930,0x292F,0x292F,0x292F,0x292F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2910,0x2110,0x290F,0x210F,0x210F,0x290F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1932,0x1933,0x1953,0x1954,0x1995,0x19B5,0x19D6,0x19F7,0x2217,0x1A17,0x1A17,0x1A17,0x2217,0x19D6,0x19B6,0x19D6,0x19B6,0x19B6,0x19B5,0x1995,0x1154,0x1153,0x1132,0x1912,0x1911,0x1911,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x292F,0x292F,0x290F,0x292F,0x210F,0x210F,0x292F,0x292F,0x210F,0x212F,0x212F,0x2130,0x2951,0x2131,0x2111,0x1911,0x1112,0x1133,0x1995,0x19D6,0x2238,0x21F7,0x1995,0x1134,0x1112,0x1932,0x1931,0x2131,0x2110,0x2110,0x2110,0x2130,0x212F,0x212F,0x294F,0x292F,0x212F,0x210F,0x2930,0x2130,0x210F,0x2110,0x2131,0x2151,0x1951,0x1132,0x0912,0x1195,0x2218,0x1A18,0x19B6,0x1154,0x1933,0x1931,0x2111,0x2111,0x2131,0x2132,0x1932,0x1133,0x11D6,0x11F7,0x19F8,0x19D6,0x08F2,0x1911,0x2131,0x2130,0x2110,0x2110,0x2110,0x2930,0x2130,0x210F,0x290F,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x2930,0x212F,0x212F,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2910,0x210F,0x2930,0x210F,0x210F,0x290F,0x2110,0x2930,0x210F,0x210F,0x210F,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x2110,0x2110,0x2930,0x2110,0x2110,0x210F,0x210F,0x2130,0x210F,0x1910,0x1910,0x1932,0x1932,0x1133,0x1995,0x2A18,0x2217,0x1995,0x08F2,0x1112,0x1932,0x2131,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2151,0x2151,0x1932,0x1112,0x1113,0x1154,0x19B6,0x19D7,0x2218,0x19D6,0x0974,0x0933,0x0912,0x1952,0x1952,0x2151,0x2130,0x190F,0x2130,0x2130,0x2130,0x210F,0x290F,0x290F,0x290F,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x1132,0x1133,0x1194,0x19D6,0x2217,0x2217,0x19D6,0x1995,0x1153,0x1112,0x1932,0x2131,0x2131,0x2111,0x2110,0x2110,0x2930,0x2930,0x2930,0x212F,0x2130,0x2110,0x210F,0x290F,0x2930,0x2930,0x2930,0x290F,0x210F,0x2910,0x2930,0x2110,0x2910,0x210F,0x290F,0x290F,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x210F,0x210F,0x2930,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x292F,0x290F,0x292F,0x210F,0x2130,0x2130,0x2930,0x2930,0x2910,0x2930,0x2110,0x2130,0x2110,0x1911,0x1911,0x1132,0x1995,0x21F7,0x21F7,0x19B6,0x0913,0x1113,0x1932,0x1952,0x1932,0x1932,0x1932,0x1132,0x1974,0x21D6,0x19D6,0x19F6,0x1175,0x0912,0x1132,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2930,0x2910,0x2930,0x290F,0x2930,0x2930,0x290F,0x290F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2930,0x2930,0x210F,0x2930,0x290F,0x290F,0x290F,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2150,0x2150,0x210F,0x210F,0x210F,0x212F,0x2930,0x2110,0x2930,0x2910,0x2910,0x2910,0x210F,0x290F,0x290F,0x2910,0x2930,0x2910,0x210F,0x210F,0x210F,0x212F,0x2130,0x2150,0x2150,0x1930,0x1110,0x1131,0x1173,0x1174,0x19D6,0x21F7,0x2218,0x21F7,0x1995,0x1154,0x1112,0x1112,0x1911,0x2111,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2910,0x2930,0x2110,0x210F,0x2110,0x2110,0x2110,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x212F,0x292F,0x2930,0x210F,0x210F,0x210F,0x290F,0x292F,0x210F,0x292F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x1911,0x1912,0x1953,0x19F7,0x19F8,0x19D7,0x1995,0x1133,0x1931,0x1910,0x2110,0x2110,0x2110,0x2111,0x1911,0x1112,0x1133,0x19B6,0x2218,0x21F7,0x1995,0x1113,0x1112,0x1911,0x1930,0x1910,0x190F,0x2130,0x1930,0x1111,0x1132,0x11D6,0x11F8,0x1A19,0x19D7,0x0933,0x1132,0x1931,0x1910,0x2110,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,
  0x11B6,0x11D7,0x19F7,0x19B6,0x1174,0x1133,0x1133,0x1112,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2930,0x2930,0x212F,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2930,0x210F,0x2910,0x210F,0x2930,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x292F,0x212F,0x212F,0x210F,0x2930,0x290F,0x210F,0x212F,0x2930,0x212F,0x2930,0x212F,0x2930,0x2930,0x2930,0x210F,0x2930,0x210F,0x2930,0x212F,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x212F,0x212F,0x292F,0x292F,0x210F,0x292F,0x210F,0x212F,0x210F,0x212F,0x290F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2130,0x1931,0x1112,0x1154,0x1A38,0x09D8,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01D9,0x01FA,0x01D9,0x01D9,0x09D8,0x09B7,0x0975,0x1153,0x1132,0x1932,0x1932,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x1931,0x2131,0x1931,0x1931,0x1931,0x1932,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x1931,0x1931,0x1931,0x1932,0x1932,0x1952,0x1932,0x1952,0x1952,0x1952,0x1952,0x1952,0x1932,0x1932,0x1132,0x1133,0x1154,0x1154,0x19D6,0x19F7,0x19D7,0x19D6,0x1195,0x1133,0x1133,0x1132,0x1931,0x1931,0x2131,0x2131,0x1910,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2930,0x2950,0x2930,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2930,0x2110,0x2930,0x212F,0x2930,0x2930,0x2930,0x2930,0x292F,0x210F,0x292F,0x210F,0x292F,0x292F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2910,0x2910,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x1930,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1930,0x2131,0x2131,0x2131,0x2131,0x2130,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x210F,0x2110,0x2110,0x2910,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x290F,0x2910,0x2110,0x2930,0x2910,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x212F,0x210F,0x212F,0x2130,0x2110,0x2930,0x210F,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x210F,0x292F,0x210F,0x210F,0x292F,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1132,0x1133,0x1195,0x11F7,0x1A18,0x11D7,0x1175,0x1132,0x1932,0x2111,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2152,0x1932,0x1133,0x19D6,0x2217,0x19D6,0x19B5,0x1153,0x1112,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x212F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x292F,0x210F,0x290F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1932,0x1952,0x1953,0x1953,0x1974,0x1995,0x1995,0x1995,0x19B5,0x1195,0x1995,0x1995,0x1995,0x1974,0x1974,0x1974,0x1954,0x1133,0x1132,0x1132,0x1911,0x1911,0x1911,0x1910,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x290F,0x290F,0x290F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x2131,0x18F1,0x10F2,0x1953,0x1995,0x21F6,0x2238,0x21F7,0x1995,0x1154,0x1113,0x1912,0x1911,0x2131,0x2130,0x2130,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1112,0x1154,0x19D7,0x2238,0x19D7,0x1175,0x1174,0x1932,0x1911,0x2131,0x2111,0x2131,0x2132,0x1932,0x1133,0x11B6,0x11F7,0x1A18,0x19D7,0x08F2,0x1931,0x2131,0x2131,0x2130,0x2110,0x2110,0x2110,0x212F,0x212F,0x210F,0x2930,0x210F,0x210F,0x2930,0x290F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x290F,0x210F,0x210F,0x290F,0x2910,0x2910,0x210F,0x290F,0x2930,0x2910,0x2110,0x2910,0x2910,0x2910,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2110,0x210F,0x2110,0x210F,0x2130,0x2130,0x1931,0x1931,0x1132,0x1113,0x1975,0x21F7,0x21F7,0x1995,0x08F2,0x1932,0x2152,0x2131,0x2130,0x2110,0x210F,0x212F,0x212F,0x2930,0x210F,0x212F,0x2130,0x2131,0x2131,0x1931,0x1932,0x1912,0x1133,0x1975,0x1996,0x21F7,0x2217,0x19D6,0x1174,0x1153,0x1132,0x1932,0x1952,0x1931,0x2130,0x1910,0x2130,0x2130,0x210F,0x210F,0x292F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1911,0x1912,0x1132,0x1133,0x1994,0x19D6,0x2217,0x19F6,0x19D6,0x19B5,0x1153,0x1132,0x1912,0x2131,0x2131,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x210F,0x2930,0x2930,0x212F,0x290F,0x2930,0x2110,0x2930,0x2110,0x210F,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x290F,0x290F,0x2910,0x210F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x292F,0x292F,0x210F,0x292F,0x210F,0x212F,0x2930,0x2930,0x2130,0x2930,0x2930,0x2930,0x2110,0x2110,0x2131,0x2111,0x1932,0x1112,0x1995,0x21F7,0x19D7,0x19D6,0x1133,0x1113,0x1933,0x1952,0x1932,0x1932,0x1932,0x1932,0x1973,0x21D5,0x19D6,0x19F6,0x19D6,0x1154,0x1112,0x1932,0x1931,0x2131,0x2151,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2930,0x290F,0x290F,0x2930,0x210F,0x2930,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x292F,0x290F,0x210F,0x2930,0x2930,0x210F,0x2930,0x290F,0x2930,0x2930,0x2130,0x212F,0x212F,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x212F,0x212F,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2950,0x2130,0x2130,0x212F,0x212F,0x2130,0x210F,0x210F,0x2130,0x2110,0x2110,0x210F,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2110,0x212F,0x210F,0x212F,0x212F,0x2130,0x2150,0x2130,0x1930,0x1931,0x1131,0x1153,0x1174,0x19B6,0x19F7,0x19F7,0x21F7,0x19B6,0x1974,0x1133,0x1912,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x292F,0x292F,0x292F,0x210F,0x292F,0x210F,0x290F,0x290F,0x2910,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x210F,0x2110,0x2930,0x2910,0x210F,0x290F,0x210F,0x210F,0x292F,0x210F,0x290F,0x210F,0x212F,0x290F,0x210F,0x212F,0x210F,0x292F,0x212F,0x210F,0x292F,0x210F,0x290F,0x210F,0x210F,0x292F,0x2930,0x210F,0x210F,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2111,0x1911,0x1933,0x19F7,0x19F7,0x19B7,0x1995,0x1953,0x1911,0x1910,0x2110,0x2110,0x2110,0x2111,0x1912,0x1912,0x0913,0x19B6,0x2217,0x19F7,0x1195,0x1113,0x1112,0x1931,0x1930,0x2130,0x212F,0x1930,0x1930,0x1131,0x1133,0x11B6,0x1A18,0x1A18,0x19D7,0x0913,0x1111,0x1931,0x1930,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,
  0x1196,0x11B6,0x19D6,0x1A17,0x19D6,0x1174,0x1133,0x1113,0x1932,0x1912,0x1931,0x2131,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x292F,0x210F,0x210F,0x292F,0x210F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x2110,0x212F,0x212F,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2930,0x210F,0x212F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x2910,0x210F,0x210F,0x290F,0x210F,0x290F,0x2930,0x2930,0x290F,0x212F,0x212F,0x2930,0x212F,0x2930,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2930,0x292F,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x292F,0x290F,0x2930,0x210F,0x2930,0x290F,0x290F,0x292F,0x210F,0x292F,0x210F,0x292F,0x212F,0x292F,0x292F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x210F,0x2110,0x2110,0x2130,0x2111,0x1912,0x1134,0x2239,0x09F9,0x01D9,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01D9,0x01D9,0x01D9,0x01D9,0x09D8,0x09B7,0x0975,0x0933,0x1133,0x1133,0x1132,0x1132,0x1111,0x1911,0x1932,0x1932,0x1932,0x1932,0x1911,0x1911,0x1932,0x1932,0x1911,0x1111,0x1912,0x1112,0x1111,0x1111,0x1132,0x1132,0x1112,0x1932,0x1111,0x1912,0x1111,0x1111,0x1111,0x1911,0x1111,0x1111,0x1911,0x1111,0x1111,0x1111,0x1911,0x1911,0x1111,0x1111,0x1911,0x1111,0x1111,0x1111,0x1111,0x1111,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1133,0x1953,0x1133,0x1113,0x1113,0x0933,0x1154,0x19B6,0x19D7,0x19F7,0x19D6,0x1175,0x1153,0x1133,0x1132,0x1931,0x1931,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x2930,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x2111,0x2131,0x1911,0x1931,0x1911,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1910,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2930,0x2910,0x2910,0x2930,0x292F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2910,0x2930,0x2110,0x2110,0x2910,0x290F,0x2930,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2110,0x2930,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x2910,0x290F,0x2930,0x292F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1931,0x1911,0x1112,0x1154,0x11D7,0x1A18,0x11D7,0x1155,0x1112,0x1911,0x1911,0x2131,0x2130,0x2130,0x2930,0x290F,0x210F,0x292F,0x210F,0x290F,0x210F,0x2110,0x2110,0x2131,0x1132,0x1133,0x19D6,0x2217,0x19D6,0x19B5,0x1153,0x1112,0x1931,0x2131,0x2131,0x2130,0x2110,0x2930,0x2110,0x2910,0x2930,0x292F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2110,0x2110,0x2110,0x2110,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x1931,0x1911,0x1932,0x1912,0x1932,0x1132,0x1933,0x1133,0x1133,0x1133,0x1133,0x1133,0x1953,0x1933,0x1112,0x1912,0x1112,0x1912,0x1911,0x1911,0x1931,0x1931,0x2131,0x2130,0x2130,0x212F,0x290F,0x292F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x210F,0x2930,0x2930,0x290F,0x210F,0x210F,0x292F,0x2930,0x2150,0x2951,0x2131,0x2111,0x1911,0x1912,0x1953,0x1974,0x21D6,0x2217,0x21F7,0x19B6,0x1154,0x1112,0x1112,0x1911,0x1911,0x2131,0x2130,0x2130,0x2130,0x2110,0x210F,0x2130,0x2950,0x212F,0x212F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2131,0x1931,0x1932,0x1132,0x1174,0x19D6,0x2218,0x21D7,0x1196,0x1175,0x1954,0x1952,0x1931,0x2111,0x2110,0x2131,0x2131,0x1912,0x1113,0x11B6,0x1A18,0x1A18,0x19D6,0x08F2,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x212F,0x212F,0x2110,0x2930,0x210F,0x212F,0x290F,0x290F,0x212F,0x2930,0x2110,0x2910,0x2930,0x210F,0x2930,0x290F,0x210F,0x290F,0x210F,0x2910,0x2930,0x2930,0x2910,0x2910,0x210F,0x290F,0x2910,0x2910,0x210F,0x2130,0x2130,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x1931,0x1932,0x1132,0x1113,0x1995,0x2A18,0x2218,0x1996,0x08F2,0x1932,0x2152,0x2131,0x2130,0x210F,0x212F,0x212F,0x210F,0x2930,0x210F,0x210F,0x2130,0x2130,0x1910,0x2131,0x1931,0x1932,0x1912,0x1133,0x1154,0x19B6,0x2217,0x2238,0x19F6,0x1174,0x0933,0x1132,0x1932,0x1951,0x1930,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2151,0x2151,0x2131,0x1911,0x1911,0x1112,0x1132,0x1994,0x21D6,0x19D6,0x21F7,0x19D6,0x19B5,0x1153,0x1132,0x1912,0x2131,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x2930,0x212F,0x2130,0x2110,0x290F,0x210F,0x2110,0x2110,0x210F,0x2910,0x210F,0x2110,0x2910,0x2910,0x2910,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x290F,0x210F,0x212F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2130,0x2130,0x2130,0x2930,0x2930,0x2110,0x2130,0x2110,0x2131,0x1932,0x1933,0x1975,0x21F7,0x19D7,0x19D6,0x1134,0x1113,0x1933,0x1953,0x1932,0x1932,0x1931,0x1111,0x1153,0x1994,0x19B6,0x19F6,0x19D6,0x19B6,0x1154,0x1112,0x1912,0x1931,0x2151,0x2151,0x2131,0x2130,0x190F,0x2130,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x210F,0x210F,0x2110,0x2930,0x2930,0x210F,0x2930,0x212F,0x212F,0x2930,0x210F,0x210F,0x2930,0x2930,0x210F,0x290F,0x210F,0x2110,0x210F,0x2930,0x212F,0x212F,0x2930,0x2130,0x2130,0x210F,0x2130,0x2930,0x2930,0x2110,0x210F,0x2130,0x2930,0x212F,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x2910,0x210F,0x210F,0x2930,0x2110,0x2110,0x2930,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x1911,0x1932,0x1133,0x1174,0x1195,0x21F7,0x21F7,0x21D7,0x19B6,0x1153,0x1112,0x1912,0x1911,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x292F,0x290F,0x210F,0x210F,0x292F,0x292F,0x292F,0x212F,0x212F,0x292F,0x290F,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x2910,0x2910,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x292F,0x292F,0x292F,0x210F,0x212F,0x210F,0x292F,0x210F,0x212F,0x292F,0x292F,0x292F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1911,0x1911,0x1133,0x21F7,0x1A18,0x19B7,0x1995,0x1953,0x1931,0x1910,0x2110,0x2110,0x2110,0x2131,0x1932,0x1932,0x1133,0x19B6,0x2217,0x19F7,0x1995,0x1112,0x1111,0x1931,0x1930,0x2130,0x2130,0x2130,0x1930,0x1932,0x1153,0x11B6,0x1A18,0x1A18,0x19B7,0x1133,0x1111,0x1911,0x1910,0x1910,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,
  0x0954,0x1175,0x11D6,0x19F7,0x19F7,0x19D6,0x1175,0x1133,0x1113,0x1112,0x1932,0x1931,0x2131,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x292F,0x292F,0x212F,0x292F,0x210F,0x212F,0x210F,0x292F,0x292F,0x212F,0x212F,0x2110,0x210F,0x212F,0x212F,0x290F,0x290F,0x212F,0x2930,0x2930,0x2110,0x210F,0x290F,0x290F,0x2930,0x290F,0x2930,0x2930,0x2930,0x2130,0x2930,0x2930,0x210F,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x292F,0x290F,0x210F,0x290F,0x2910,0x2110,0x2110,0x2110,0x1911,0x1912,0x1133,0x1A18,0x09D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01D9,0x01D9,0x01FA,0x01D9,0x01D9,0x09D9,0x0997,0x0996,0x0975,0x0954,0x1154,0x1154,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1112,0x1133,0x1133,0x1133,0x1113,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1113,0x1133,0x1133,0x1133,0x1133,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1133,0x0912,0x1133,0x1133,0x1133,0x1133,0x1133,0x0933,0x0933,0x0933,0x0933,0x1133,0x1154,0x1954,0x1154,0x0913,0x0933,0x0933,0x1175,0x19B6,0x19F7,0x19F7,0x19D6,0x1175,0x1174,0x1133,0x1132,0x1932,0x2151,0x2151,0x2131,0x2130,0x2131,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x1911,0x1931,0x1911,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1132,0x1112,0x1132,0x1112,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1932,0x1132,0x1132,0x1132,0x1132,0x1932,0x1931,0x1911,0x1911,0x1931,0x2131,0x2110,0x2130,0x2110,0x2930,0x2930,0x2930,0x2110,0x212F,0x212F,0x210F,0x212F,0x210F,0x290F,0x2910,0x2910,0x2110,0x210F,0x2910,0x290F,0x290F,0x2910,0x210F,0x2910,0x2110,0x2910,0x2910,0x2910,0x2110,0x2130,0x2110,0x2130,0x212F,0x212F,0x212F,0x2130,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x2910,0x290F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1911,0x1112,0x1134,0x11D6,0x1A18,0x19F7,0x1195,0x1133,0x1932,0x2131,0x2110,0x2130,0x2130,0x2110,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x2130,0x2110,0x2131,0x1932,0x1133,0x19D6,0x2217,0x19D6,0x19B5,0x1153,0x1112,0x1931,0x2131,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x292F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2111,0x1911,0x1911,0x1911,0x1912,0x1912,0x1932,0x1932,0x1932,0x1932,0x1912,0x1911,0x1911,0x1911,0x18F1,0x1911,0x1911,0x2111,0x2131,0x2151,0x2130,0x210F,0x2930,0x292F,0x290F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x2130,0x212F,0x292F,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x212F,0x290F,0x2930,0x2130,0x2151,0x2151,0x2131,0x1911,0x1112,0x1133,0x1995,0x21D6,0x21F7,0x21F7,0x19B5,0x1154,0x1112,0x1112,0x1911,0x2131,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1952,0x1932,0x1132,0x1153,0x19D6,0x2217,0x2218,0x1996,0x1154,0x1954,0x1953,0x2152,0x2131,0x2130,0x2130,0x2130,0x2131,0x1932,0x1113,0x11B6,0x11F7,0x1A18,0x19D6,0x08F2,0x1932,0x2131,0x2110,0x2110,0x2130,0x2130,0x2110,0x2930,0x212F,0x2930,0x210F,0x212F,0x212F,0x2930,0x290F,0x212F,0x2930,0x2910,0x2910,0x290F,0x2930,0x290F,0x290F,0x210F,0x210F,0x2910,0x2930,0x2930,0x210F,0x210F,0x2910,0x290F,0x290F,0x2910,0x2930,0x210F,0x212F,0x2130,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2110,0x2110,0x210F,0x2110,0x2130,0x1931,0x1932,0x1932,0x1113,0x1995,0x29F7,0x21F7,0x21B6,0x08F2,0x1932,0x1952,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x2930,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x2131,0x1911,0x1912,0x1133,0x1174,0x19B6,0x2237,0x2237,0x19D6,0x1194,0x1153,0x1132,0x1952,0x1931,0x1931,0x1930,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2151,0x1931,0x1911,0x1112,0x1132,0x1974,0x19B5,0x21D6,0x21F7,0x21D6,0x19B5,0x1153,0x1933,0x1932,0x1911,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x210F,0x2930,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x212F,0x210F,0x290F,0x292F,0x292F,0x210F,0x212F,0x212F,0x292F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2110,0x2110,0x2110,0x2131,0x1932,0x1932,0x1954,0x21F7,0x21F7,0x19D7,0x1155,0x0913,0x1113,0x1953,0x1932,0x1932,0x1952,0x1132,0x1132,0x1153,0x1995,0x19D6,0x2217,0x21F7,0x21D6,0x1133,0x1112,0x1912,0x2152,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2930,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x212F,0x2130,0x210F,0x2930,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x2130,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x210F,0x210F,0x210F,0x290F,0x2930,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x290F,0x290F,0x290F,0x290F,0x2910,0x210F,0x2110,0x2110,0x2930,0x2110,0x2130,0x210F,0x290F,0x210F,0x212F,0x212F,0x2110,0x2130,0x2130,0x1911,0x1932,0x1133,0x1174,0x19B6,0x21F7,0x2218,0x21F7,0x19B5,0x1153,0x1112,0x1911,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2930,0x210F,0x292F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x210F,0x290F,0x2930,0x2110,0x290F,0x290F,0x290F,0x290F,0x2910,0x2930,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x292F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x292F,0x210F,0x210F,0x2130,0x2930,0x2130,0x2130,0x2150,0x2131,0x2131,0x1911,0x1912,0x1112,0x19D6,0x19F7,0x19B6,0x1995,0x1973,0x1931,0x1910,0x2110,0x2110,0x2110,0x1910,0x1911,0x1132,0x0933,0x19B6,0x2217,0x19F7,0x1995,0x1112,0x1911,0x1931,0x1930,0x2130,0x2130,0x1930,0x1931,0x1132,0x1133,0x11B6,0x11F8,0x19F8,0x19D7,0x1113,0x1111,0x1910,0x1910,0x190F,0x2130,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,
  0x0933,0x0933,0x1175,0x19B6,0x1A17,0x19F7,0x19D7,0x1175,0x1134,0x1112,0x1112,0x1931,0x1931,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x212F,0x292F,0x292F,0x210F,0x292F,0x292F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x210F,0x2930,0x2930,0x2930,0x210F,0x2930,0x2930,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x210F,0x210F,0x2930,0x2910,0x210F,0x210F,0x2910,0x210F,0x210F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x2930,0x290F,0x2910,0x2910,0x290F,0x290F,0x2910,0x2910,0x210F,0x210F,0x292F,0x212F,0x210F,0x212F,0x292F,0x212F,0x292F,0x212F,0x292F,0x290F,0x290F,0x210F,0x2110,0x2130,0x2110,0x2111,0x1912,0x1154,0x2239,0x09D9,0x01D9,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01F9,0x09F9,0x09D9,0x09B8,0x0997,0x09B7,0x1197,0x11B7,0x1196,0x1196,0x1196,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1196,0x1195,0x1195,0x1195,0x1196,0x1196,0x1996,0x1196,0x1196,0x1196,0x1196,0x1196,0x1196,0x1196,0x1196,0x1196,0x11B6,0x1196,0x11B6,0x1196,0x1195,0x11B6,0x11B5,0x1195,0x1195,0x1195,0x11B5,0x11B5,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11D6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B7,0x1196,0x0954,0x1154,0x1154,0x1134,0x1133,0x0913,0x1154,0x1175,0x19B6,0x19D7,0x19F7,0x19D6,0x1995,0x1174,0x1153,0x1132,0x1911,0x1911,0x2111,0x2110,0x2110,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x212F,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x210F,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2111,0x2131,0x1932,0x1132,0x1153,0x1153,0x1174,0x1154,0x1154,0x1154,0x1154,0x0954,0x1174,0x1174,0x1174,0x1154,0x1154,0x1154,0x1174,0x1174,0x1174,0x1154,0x1174,0x1175,0x1154,0x1154,0x1154,0x1174,0x1174,0x1174,0x1174,0x1174,0x1174,0x1174,0x1174,0x1174,0x1174,0x1174,0x1194,0x1174,0x1174,0x1153,0x1153,0x1932,0x1932,0x1932,0x1931,0x2131,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x2910,0x2110,0x2110,0x2910,0x2930,0x210F,0x2910,0x2930,0x2910,0x2910,0x290F,0x2910,0x2930,0x2110,0x2110,0x2130,0x210F,0x210F,0x212F,0x212F,0x2130,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x210F,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x212F,0x2930,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2150,0x2131,0x2131,0x1931,0x1112,0x1154,0x11D7,0x19F8,0x11D7,0x1195,0x1132,0x1932,0x2131,0x2131,0x2110,0x2930,0x2110,0x210F,0x210F,0x292F,0x290F,0x290F,0x210F,0x210F,0x2130,0x2131,0x1932,0x1133,0x19D6,0x2217,0x19D6,0x19B5,0x1973,0x1111,0x1911,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2910,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x2930,0x210F,0x290F,0x290F,0x2930,0x2930,0x210F,0x210F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x292F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2110,0x2111,0x1911,0x1911,0x1931,0x1931,0x1931,0x1911,0x1911,0x1911,0x18F0,0x2111,0x2110,0x2111,0x2131,0x2130,0x2130,0x2930,0x2130,0x2930,0x212F,0x210F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x292F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2151,0x2131,0x1912,0x1112,0x1153,0x1995,0x21F7,0x21F7,0x21F7,0x19B6,0x1154,0x1112,0x1111,0x1931,0x1911,0x2131,0x2130,0x2110,0x2110,0x2130,0x210F,0x2130,0x2130,0x212F,0x210F,0x2130,0x210F,0x210F,0x2130,0x2151,0x2131,0x1911,0x1911,0x1132,0x1974,0x1995,0x2217,0x2A38,0x19D6,0x1134,0x1133,0x1953,0x1952,0x2152,0x2130,0x2130,0x2110,0x2130,0x2131,0x1912,0x1133,0x11D6,0x11F7,0x1A38,0x19F7,0x0912,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x212F,0x212F,0x210F,0x210F,0x2930,0x212F,0x2930,0x290F,0x210F,0x210F,0x2910,0x2910,0x210F,0x210F,0x2930,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x292F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2110,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2131,0x1932,0x1932,0x1113,0x1995,0x29F7,0x21F7,0x1995,0x08F2,0x1912,0x1952,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2131,0x2131,0x2131,0x1932,0x1912,0x1132,0x1174,0x19D6,0x2217,0x2217,0x19F6,0x1174,0x1153,0x1132,0x1952,0x1931,0x2131,0x2131,0x1930,0x2130,0x2130,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2151,0x2131,0x1931,0x1911,0x1112,0x1133,0x1154,0x19B5,0x21F7,0x21F7,0x21F7,0x19B5,0x1174,0x1132,0x1912,0x1911,0x2131,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x210F,0x2930,0x2910,0x2910,0x2930,0x2910,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x292F,0x210F,0x292F,0x292F,0x212F,0x212F,0x210F,0x292F,0x2930,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x1911,0x1932,0x1974,0x21F7,0x21F7,0x21F7,0x1996,0x0913,0x08F2,0x1112,0x1932,0x1932,0x1973,0x1952,0x1132,0x1152,0x1153,0x1195,0x1A17,0x2238,0x21F7,0x1995,0x1133,0x1112,0x1912,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x210F,0x210F,0x210F,0x2910,0x210F,0x2110,0x210F,0x2110,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x212F,0x2930,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2930,0x210F,0x2110,0x2110,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x210F,0x210F,0x2110,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x1931,0x2131,0x2130,0x2110,0x1910,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x292F,0x292F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2930,0x2930,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x292F,0x2930,0x2130,0x2130,0x2130,0x1931,0x1932,0x1133,0x1154,0x19D6,0x2217,0x2217,0x21F6,0x1995,0x1153,0x1132,0x1911,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x2930,0x2930,0x290F,0x290F,0x2930,0x290F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x290F,0x210F,0x292F,0x292F,0x210F,0x290F,0x210F,0x212F,0x212F,0x292F,0x212F,0x292F,0x212F,0x292F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x10F1,0x1133,0x19D6,0x19F7,0x19D7,0x19B5,0x1953,0x1911,0x2130,0x2110,0x2110,0x2131,0x2111,0x1932,0x1112,0x1133,0x19D6,0x2217,0x21F7,0x1195,0x1132,0x1932,0x1931,0x1910,0x2130,0x2130,0x1930,0x1931,0x1132,0x1153,0x11D6,0x1A18,0x1A19,0x11B6,0x1112,0x1111,0x1931,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,
  0x1112,0x1132,0x0933,0x1175,0x11B6,0x19F7,0x2218,0x19D7,0x1995,0x1133,0x1133,0x1932,0x1932,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x210F,0x292F,0x292F,0x292F,0x212F,0x2930,0x2930,0x2110,0x212F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x212F,0x2930,0x2930,0x2930,0x2130,0x2930,0x2930,0x2930,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x2930,0x2110,0x2910,0x2110,0x2910,0x2930,0x210F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x210F,0x2910,0x2910,0x2930,0x212F,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x290F,0x210F,0x2910,0x210F,0x290F,0x290F,0x2910,0x2910,0x2110,0x212F,0x210F,0x212F,0x210F,0x212F,0x292F,0x292F,0x212F,0x212F,0x2930,0x290F,0x2930,0x2910,0x2110,0x2110,0x2110,0x2111,0x1912,0x1133,0x1A39,0x09D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01D9,0x01FA,0x09FA,0x09F9,0x09D9,0x11F9,0x11F9,0x19F9,0x19F9,0x19F9,0x1A19,0x1A18,0x19F8,0x19F8,0x2218,0x19F7,0x2218,0x2218,0x2218,0x2218,0x2218,0x1A18,0x2218,0x21F8,0x2218,0x21F8,0x2218,0x2218,0x2218,0x2239,0x1A18,0x2238,0x2238,0x1A18,0x2238,0x1A18,0x2239,0x2238,0x1A18,0x1A18,0x1A38,0x2238,0x1A18,0x2238,0x2238,0x1A18,0x1A38,0x1A18,0x1A38,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x11F8,0x11F8,0x11F8,0x1A39,0x1A18,0x1196,0x0955,0x0954,0x1154,0x1133,0x1133,0x0933,0x0934,0x1175,0x19B6,0x19F7,0x19F7,0x19D6,0x19B5,0x1154,0x1153,0x1932,0x1911,0x1911,0x2111,0x2111,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2130,0x1910,0x1910,0x2130,0x1930,0x1930,0x1930,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x1930,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2131,0x2130,0x2131,0x2130,0x2131,0x2131,0x1911,0x1932,0x1953,0x1174,0x1195,0x1195,0x11B5,0x11B6,0x11B6,0x1196,0x11B6,0x11B6,0x11B6,0x11B6,0x11B7,0x11B7,0x11B7,0x11B7,0x11B7,0x11B7,0x11D7,0x11D7,0x11B7,0x11B7,0x11D7,0x11B7,0x11B6,0x11B6,0x11B6,0x11B6,0x11B7,0x11D7,0x11B7,0x11B7,0x11B6,0x11B6,0x11B6,0x11B6,0x11D6,0x11B6,0x11B6,0x1195,0x1195,0x1174,0x1153,0x1153,0x1932,0x1932,0x1931,0x2131,0x2110,0x2110,0x2130,0x2130,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2910,0x210F,0x2110,0x2110,0x2910,0x210F,0x2910,0x2930,0x2910,0x2910,0x2910,0x290F,0x210F,0x2910,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x212F,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x210F,0x290F,0x212F,0x2930,0x2930,0x212F,0x2930,0x2930,0x2930,0x2930,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2150,0x2151,0x2131,0x1911,0x1112,0x0933,0x11D7,0x19F8,0x11F7,0x1195,0x1133,0x1932,0x2131,0x2131,0x2130,0x2110,0x210F,0x2130,0x210F,0x210F,0x292F,0x290F,0x210F,0x210F,0x2110,0x2131,0x1932,0x1133,0x19D6,0x21F7,0x19D6,0x19B5,0x1153,0x1111,0x1911,0x2131,0x2130,0x2930,0x2110,0x2110,0x2910,0x290F,0x290F,0x290F,0x292F,0x292F,0x212F,0x2130,0x210F,0x210F,0x2130,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x290F,0x2930,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x210F,0x2130,0x2130,0x210F,0x212F,0x212F,0x290F,0x290F,0x292F,0x292F,0x2930,0x212F,0x2930,0x2130,0x2930,0x2130,0x2130,0x2130,0x2110,0x2131,0x1910,0x1910,0x2110,0x1910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x292F,0x292F,0x212F,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2151,0x2131,0x1911,0x1112,0x1133,0x1995,0x21F7,0x21F7,0x2217,0x19D6,0x1154,0x1132,0x1111,0x1931,0x1911,0x1910,0x2130,0x2130,0x2110,0x2110,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2131,0x1931,0x1111,0x1132,0x1153,0x1995,0x2A17,0x2A38,0x21F7,0x1995,0x1134,0x1133,0x1932,0x1931,0x2151,0x2130,0x2130,0x2110,0x2130,0x2131,0x1932,0x1112,0x11B6,0x11F7,0x1A18,0x19F7,0x08F2,0x1932,0x2132,0x2131,0x2110,0x2130,0x2110,0x2930,0x212F,0x212F,0x290F,0x290F,0x212F,0x2930,0x2930,0x210F,0x210F,0x2930,0x2910,0x2910,0x210F,0x210F,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x292F,0x210F,0x290F,0x290F,0x2930,0x290F,0x2110,0x210F,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x2130,0x2130,0x212F,0x212F,0x2130,0x212F,0x2930,0x210F,0x2930,0x2130,0x210F,0x210F,0x2130,0x2130,0x2110,0x2130,0x1931,0x1932,0x1112,0x1112,0x1995,0x21F7,0x21D7,0x21B6,0x10F2,0x1912,0x2152,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2131,0x2131,0x2131,0x1931,0x1112,0x1133,0x1174,0x19D6,0x2217,0x2217,0x21F6,0x1174,0x1153,0x1952,0x1931,0x1931,0x1931,0x2151,0x1930,0x2130,0x2130,0x212F,0x212F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1132,0x1133,0x1174,0x19B6,0x21F7,0x2217,0x19D6,0x19B6,0x1154,0x1133,0x1912,0x1911,0x2131,0x2131,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2910,0x2110,0x2110,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x290F,0x210F,0x292F,0x210F,0x212F,0x212F,0x292F,0x212F,0x210F,0x292F,0x210F,0x210F,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2130,0x2110,0x1911,0x1912,0x1953,0x21D6,0x21F7,0x21F7,0x19B6,0x1175,0x1133,0x0912,0x1933,0x1932,0x1952,0x1952,0x1131,0x1132,0x1153,0x1174,0x11D6,0x2238,0x21F7,0x21D6,0x1995,0x1133,0x1132,0x1912,0x1931,0x2131,0x2151,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x2110,0x210F,0x210F,0x210F,0x290F,0x2930,0x2110,0x2110,0x210F,0x2930,0x212F,0x212F,0x212F,0x210F,0x212F,0x290F,0x290F,0x292F,0x212F,0x210F,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2910,0x2910,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x292F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x1931,0x1932,0x1932,0x1931,0x1932,0x1911,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x290F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2930,0x2130,0x210F,0x210F,0x290F,0x210F,0x290F,0x2930,0x210F,0x2130,0x2131,0x2151,0x2152,0x1132,0x1153,0x1174,0x19D6,0x21F7,0x21F7,0x21F6,0x19B5,0x1153,0x1132,0x1912,0x1911,0x2131,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x210F,0x212F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x290F,0x210F,0x212F,0x212F,0x210F,0x292F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x210F,0x292F,0x212F,0x210F,0x212F,0x292F,0x212F,0x212F,0x292F,0x210F,0x292F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1932,0x1133,0x19D6,0x19F7,0x19D7,0x19B5,0x1952,0x1931,0x2110,0x2110,0x2110,0x2110,0x2131,0x1911,0x1132,0x0933,0x19D6,0x2217,0x19F7,0x1995,0x1132,0x1911,0x1931,0x1930,0x2130,0x212F,0x2130,0x1931,0x1932,0x1133,0x11B6,0x1A18,0x1A18,0x19B7,0x1133,0x1911,0x1911,0x2110,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,
  0x1111,0x1111,0x0912,0x0933,0x0954,0x19B6,0x19F7,0x21F8,0x19D7,0x1195,0x1154,0x1113,0x1932,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x212F,0x292F,0x212F,0x210F,0x292F,0x210F,0x292F,0x2930,0x2930,0x2930,0x292F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x212F,0x2930,0x210F,0x2130,0x212F,0x2930,0x2930,0x212F,0x212F,0x2930,0x2110,0x2930,0x290F,0x2110,0x2930,0x2930,0x290F,0x2910,0x2910,0x290F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x290F,0x210F,0x2910,0x2910,0x2930,0x290F,0x290F,0x210F,0x2910,0x2910,0x290F,0x290F,0x290F,0x2110,0x2110,0x2110,0x2110,0x2130,0x212F,0x210F,0x210F,0x292F,0x212F,0x212F,0x2930,0x210F,0x290F,0x2910,0x2110,0x2110,0x2110,0x1911,0x1912,0x1154,0x2239,0x11F9,0x09DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FB,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x09FA,0x09FA,0x09D9,0x11F9,0x1A19,0x1A19,0x1A19,0x1A19,0x19F8,0x19F8,0x19D7,0x19F8,0x19D7,0x19B7,0x19D7,0x19D7,0x19D7,0x19D7,0x19D7,0x19D7,0x19D7,0x19D7,0x21D8,0x19B7,0x21F8,0x19D8,0x19D7,0x19D7,0x19D7,0x19D7,0x19F7,0x19F7,0x19F7,0x19D7,0x19F7,0x19F7,0x19F7,0x19F7,0x19D7,0x19D7,0x19D7,0x19D7,0x19D7,0x19D7,0x19F8,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x11D7,0x11D7,0x11D7,0x19F7,0x19F8,0x11D7,0x11D7,0x19F8,0x19F8,0x11B6,0x1195,0x0954,0x0933,0x1133,0x0913,0x1133,0x1154,0x1175,0x11B6,0x19F7,0x19F7,0x19D6,0x19B5,0x1174,0x1153,0x1132,0x1932,0x1911,0x1911,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2151,0x2131,0x2131,0x2131,0x2151,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2151,0x1931,0x2151,0x2151,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x2131,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1931,0x1931,0x1931,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x1911,0x1911,0x1911,0x1911,0x1931,0x1932,0x1953,0x1174,0x11B5,0x11D6,0x11D7,0x11D7,0x09D7,0x09D7,0x09D8,0x09D8,0x09D8,0x09F8,0x09F8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x09D8,0x11F8,0x11F8,0x11F8,0x09F8,0x1218,0x11F8,0x11F8,0x11D7,0x11D7,0x11B6,0x1195,0x1174,0x1174,0x1153,0x1932,0x1911,0x1911,0x2110,0x2110,0x2130,0x2930,0x2930,0x290F,0x2930,0x212F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2910,0x2110,0x2930,0x2910,0x2110,0x2110,0x210F,0x290F,0x2910,0x2910,0x2110,0x210F,0x2910,0x290F,0x292F,0x210F,0x292F,0x210F,0x290F,0x2930,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2110,0x210F,0x290F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2110,0x210F,0x212F,0x212F,0x212F,0x210F,0x2930,0x212F,0x212F,0x212F,0x2130,0x2131,0x2131,0x1931,0x1112,0x1133,0x19F7,0x1A18,0x1A18,0x1195,0x1133,0x1931,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2110,0x2110,0x1931,0x1932,0x1133,0x21F6,0x2217,0x19D6,0x19B5,0x1153,0x1111,0x1911,0x2131,0x2110,0x2110,0x2110,0x210F,0x2930,0x292F,0x290F,0x210F,0x290F,0x210F,0x2150,0x2130,0x2130,0x2130,0x212F,0x2130,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2930,0x290F,0x2930,0x2930,0x292F,0x292F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x292F,0x212F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2930,0x210F,0x210F,0x290F,0x210F,0x210F,0x292F,0x292F,0x290F,0x210F,0x210F,0x292F,0x292F,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2150,0x2151,0x2131,0x1910,0x1111,0x1112,0x1134,0x1996,0x21D7,0x21F7,0x21F7,0x19B6,0x1154,0x1132,0x1111,0x1931,0x1930,0x2131,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x2110,0x1911,0x1931,0x1932,0x1132,0x1153,0x1974,0x2A17,0x21F7,0x19B6,0x19B6,0x1974,0x1133,0x1932,0x1911,0x1911,0x2151,0x2130,0x2110,0x2110,0x2130,0x2131,0x1931,0x1133,0x11B6,0x11F8,0x1A19,0x19D7,0x08F2,0x1932,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x212F,0x212F,0x2930,0x2930,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2910,0x290F,0x210F,0x2930,0x2110,0x2930,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1911,0x1931,0x1932,0x1112,0x21B5,0x29F7,0x21D7,0x1995,0x1112,0x1112,0x1931,0x2131,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2151,0x2151,0x1931,0x1111,0x1133,0x1174,0x19D6,0x19F6,0x2217,0x21F6,0x1174,0x1153,0x1953,0x1932,0x1931,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2151,0x1931,0x1111,0x1132,0x1133,0x1174,0x19D6,0x21F7,0x2217,0x21F7,0x19B5,0x1153,0x1132,0x1911,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2930,0x2930,0x210F,0x2910,0x2910,0x2910,0x2910,0x290F,0x2930,0x2110,0x210F,0x2910,0x210F,0x210F,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x292F,0x290F,0x2930,0x2930,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x2130,0x2111,0x1911,0x1932,0x1974,0x21F6,0x21F7,0x19D6,0x19B6,0x1175,0x08F2,0x1112,0x1132,0x1973,0x1952,0x1111,0x1132,0x1132,0x1153,0x1194,0x19D6,0x19F7,0x21F7,0x21F7,0x1995,0x1133,0x1112,0x1912,0x2132,0x2131,0x2131,0x2110,0x2110,0x2110,0x210F,0x210F,0x2130,0x2130,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2930,0x2110,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x292F,0x212F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x290F,0x210F,0x2130,0x210F,0x2130,0x212F,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2930,0x210F,0x210F,0x290F,0x2930,0x20EF,0x290F,0x290F,0x290F,0x2930,0x2930,0x2130,0x2130,0x2130,0x1930,0x1910,0x1911,0x1931,0x1932,0x1953,0x1953,0x1153,0x1132,0x1932,0x1932,0x1931,0x1931,0x1910,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x210F,0x290F,0x290F,0x2930,0x2130,0x2130,0x2151,0x2152,0x2152,0x1132,0x1133,0x1154,0x19B5,0x21F6,0x2217,0x19D6,0x19B5,0x1153,0x1132,0x1932,0x1911,0x2111,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2930,0x292F,0x290F,0x210F,0x290F,0x292F,0x210F,0x210F,0x290F,0x292F,0x212F,0x292F,0x210F,0x290F,0x290F,0x2930,0x2930,0x212F,0x210F,0x290F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x292F,0x292F,0x212F,0x212F,0x210F,0x212F,0x212F,0x292F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1930,0x1931,0x1932,0x1132,0x1154,0x19D6,0x19D7,0x21F7,0x19B5,0x1932,0x1911,0x1910,0x2110,0x2110,0x2130,0x2131,0x1912,0x1133,0x1154,0x19D6,0x19F7,0x19F6,0x1994,0x1132,0x1931,0x1910,0x2110,0x2130,0x2130,0x2130,0x1931,0x1932,0x1154,0x11D7,0x1A18,0x1A18,0x19B7,0x1133,0x1911,0x2111,0x2110,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x210F,0x292F,
  0x1931,0x1911,0x1111,0x1112,0x0912,0x0954,0x1196,0x19D7,0x2218,0x21F7,0x1996,0x1134,0x1133,0x1932,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x210F,0x2130,0x2930,0x212F,0x212F,0x292F,0x292F,0x292F,0x2930,0x2930,0x2110,0x2930,0x2930,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x2130,0x212F,0x210F,0x2110,0x2130,0x2930,0x210F,0x2110,0x2910,0x2910,0x2110,0x2110,0x290F,0x210F,0x2910,0x2910,0x2910,0x290F,0x2910,0x2910,0x210F,0x210F,0x2910,0x2910,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x290F,0x210F,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x2910,0x2930,0x290F,0x290F,0x290F,0x2910,0x2110,0x2130,0x2110,0x210F,0x212F,0x212F,0x212F,0x292F,0x210F,0x212F,0x212F,0x212F,0x290F,0x2910,0x2930,0x2110,0x2110,0x1911,0x1911,0x1134,0x2219,0x09D9,0x09D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x09FA,0x09D9,0x0997,0x1197,0x1197,0x11B7,0x1197,0x1996,0x1996,0x1196,0x1195,0x1195,0x1175,0x19B5,0x1195,0x1195,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1996,0x1996,0x1976,0x1976,0x1996,0x1996,0x1996,0x1996,0x1195,0x1195,0x1195,0x1995,0x1195,0x1195,0x1195,0x1195,0x1195,0x19B5,0x1995,0x19B6,0x1195,0x1995,0x1196,0x1196,0x11B6,0x11B6,0x1196,0x1195,0x11B6,0x11B6,0x1196,0x11B6,0x11B6,0x11B6,0x11B6,0x19F7,0x1A18,0x1A18,0x11B6,0x1175,0x0954,0x1154,0x1133,0x1133,0x1133,0x1154,0x1175,0x11B6,0x19F7,0x19F7,0x19D6,0x1195,0x1154,0x1153,0x1133,0x1112,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1931,0x1932,0x1932,0x1952,0x1931,0x1932,0x1931,0x1932,0x1932,0x1932,0x2132,0x1932,0x2132,0x2132,0x1932,0x1952,0x1952,0x1931,0x1931,0x1932,0x1931,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1952,0x1931,0x1931,0x1931,0x1931,0x2131,0x2131,0x2131,0x1931,0x1931,0x1931,0x1932,0x1932,0x1932,0x1931,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x18F1,0x1911,0x1911,0x1911,0x1911,0x1911,0x1112,0x1112,0x1133,0x0954,0x0996,0x09B7,0x09D8,0x09F8,0x09D8,0x09D8,0x09F8,0x09F9,0x09F9,0x01D9,0x01D9,0x09F9,0x09D9,0x09D9,0x09D9,0x09D9,0x09D9,0x09D9,0x01D9,0x01D9,0x09D9,0x09D9,0x01D8,0x09D9,0x01D8,0x09D9,0x01D8,0x09D9,0x09D9,0x09D9,0x09D9,0x01D9,0x09F9,0x09F9,0x09D9,0x09F9,0x09F8,0x09F9,0x09F8,0x11F8,0x11D8,0x11D7,0x11B6,0x1195,0x1174,0x1953,0x1932,0x1931,0x1911,0x2130,0x2110,0x2130,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2910,0x290F,0x2910,0x2910,0x2110,0x2930,0x2910,0x2910,0x290F,0x292F,0x290F,0x292F,0x210F,0x210F,0x2910,0x210F,0x2930,0x2910,0x2930,0x2930,0x210F,0x212F,0x290F,0x2930,0x2110,0x2930,0x2930,0x2110,0x2110,0x2930,0x2110,0x2930,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1112,0x1133,0x19D6,0x1A18,0x1A18,0x1195,0x1132,0x1931,0x1931,0x2130,0x2130,0x2130,0x212F,0x292F,0x292F,0x292F,0x290F,0x290F,0x210F,0x2130,0x2131,0x1931,0x1132,0x1133,0x19D6,0x2217,0x19D6,0x19B5,0x1153,0x1112,0x1931,0x2131,0x2110,0x2110,0x2110,0x2930,0x292F,0x292F,0x292F,0x292F,0x290F,0x2110,0x2150,0x2130,0x2130,0x2110,0x210F,0x2130,0x210F,0x290F,0x210F,0x210F,0x2130,0x2130,0x210F,0x2930,0x2930,0x2930,0x290F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2110,0x2110,0x212F,0x292F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x20EF,0x210F,0x210F,0x290F,0x2110,0x2910,0x2130,0x2110,0x2110,0x210F,0x2930,0x2930,0x2910,0x2110,0x2130,0x2130,0x2130,0x2110,0x210F,0x212F,0x210F,0x292F,0x292F,0x292F,0x292F,0x212F,0x210F,0x2930,0x290F,0x292F,0x290F,0x290F,0x292F,0x2930,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2151,0x2131,0x1931,0x1111,0x1112,0x1134,0x1995,0x21F7,0x2218,0x21F7,0x19B6,0x1154,0x1112,0x1111,0x1911,0x1930,0x1930,0x2130,0x2130,0x2130,0x210F,0x212F,0x2930,0x210F,0x212F,0x2130,0x210F,0x2110,0x2110,0x2110,0x2131,0x2131,0x1932,0x1932,0x1112,0x1153,0x1174,0x2A17,0x2A17,0x21D7,0x1975,0x1133,0x1133,0x1953,0x1932,0x1911,0x1910,0x2130,0x2130,0x2110,0x2130,0x2130,0x2151,0x1931,0x1133,0x11B6,0x11F8,0x1A18,0x19D7,0x08F2,0x1912,0x2131,0x2110,0x2110,0x2930,0x2110,0x2110,0x212F,0x212F,0x290F,0x210F,0x212F,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x2930,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x2930,0x290F,0x2910,0x2910,0x290F,0x2930,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x212F,0x210F,0x2930,0x210F,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x2110,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x1112,0x1995,0x21F7,0x21F7,0x1995,0x1112,0x1112,0x1931,0x2131,0x2131,0x2110,0x2110,0x2130,0x210F,0x2930,0x210F,0x2130,0x210F,0x2110,0x2930,0x2930,0x2110,0x2110,0x2930,0x2130,0x2151,0x1931,0x1931,0x1132,0x1133,0x1995,0x19B6,0x21F7,0x2237,0x19D6,0x1174,0x1154,0x1133,0x1932,0x1931,0x2131,0x2111,0x2130,0x2130,0x2130,0x210F,0x2130,0x210F,0x212F,0x2130,0x2130,0x2950,0x2130,0x2130,0x1931,0x1131,0x1132,0x1133,0x1154,0x19D6,0x2217,0x19F7,0x19F6,0x19B5,0x1133,0x1932,0x1932,0x2131,0x2131,0x2130,0x2110,0x2130,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2930,0x2110,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x290F,0x2910,0x290F,0x2110,0x2110,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2110,0x1911,0x1912,0x1953,0x1995,0x21D7,0x19D7,0x19D7,0x19B5,0x1154,0x1113,0x1112,0x1932,0x1952,0x1952,0x1932,0x1952,0x1153,0x1133,0x1154,0x19D6,0x21F7,0x21F7,0x21D7,0x1975,0x1133,0x1112,0x1912,0x2132,0x2131,0x2111,0x2110,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2130,0x212F,0x212F,0x210F,0x212F,0x292F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2910,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x210F,0x2110,0x2110,0x2110,0x2930,0x210F,0x290F,0x210F,0x290F,0x292F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x2110,0x2130,0x2110,0x1910,0x1931,0x1911,0x1111,0x1132,0x1153,0x1974,0x19B5,0x19D6,0x19D6,0x1995,0x1154,0x1133,0x1132,0x1932,0x1911,0x1911,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x2930,0x2130,0x2130,0x2131,0x2152,0x1932,0x1112,0x1133,0x1174,0x21F6,0x21F7,0x2237,0x19D6,0x1194,0x1154,0x1953,0x1932,0x1931,0x1911,0x2131,0x2931,0x2951,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x212F,0x210F,0x2930,0x2930,0x290F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x2930,0x212F,0x210F,0x212F,0x2130,0x2131,0x1931,0x1931,0x1132,0x1153,0x1175,0x19D6,0x19D7,0x21F7,0x19B5,0x1932,0x1911,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1133,0x1154,0x19D6,0x21F7,0x19D6,0x1994,0x1932,0x1931,0x2130,0x2110,0x2130,0x2130,0x2130,0x1931,0x1932,0x1154,0x11D7,0x1A18,0x1A18,0x19D7,0x1133,0x1911,0x2111,0x2110,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x210E,0x210F,0x210F,0x210F,0x210F,0x210F,
  0x2131,0x1931,0x1951,0x1131,0x1111,0x1132,0x0954,0x19B6,0x2217,0x2218,0x21F7,0x19B6,0x0913,0x1133,0x1912,0x1932,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2930,0x290F,0x290F,0x290F,0x2110,0x2930,0x2130,0x2930,0x2930,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x2930,0x2110,0x210F,0x2930,0x290F,0x2110,0x210F,0x2930,0x2930,0x2110,0x210F,0x210F,0x2110,0x2910,0x210F,0x2910,0x2910,0x2110,0x2910,0x290F,0x210F,0x2910,0x290F,0x290F,0x2910,0x2910,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2110,0x2110,0x290F,0x290F,0x290F,0x2930,0x212F,0x212F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2910,0x210F,0x290F,0x290F,0x2910,0x2910,0x2130,0x2130,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x210F,0x2930,0x2110,0x2110,0x2111,0x1912,0x1133,0x2219,0x11F9,0x09D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x09D9,0x0997,0x0976,0x0934,0x1154,0x1154,0x1954,0x1954,0x1933,0x1953,0x1953,0x1153,0x1973,0x1953,0x1973,0x1973,0x1973,0x1153,0x1953,0x1953,0x1953,0x1933,0x1933,0x1133,0x1933,0x1953,0x1933,0x1133,0x1953,0x1153,0x1153,0x1153,0x1953,0x1953,0x1953,0x1153,0x1153,0x1133,0x1153,0x1153,0x1153,0x1133,0x1153,0x1153,0x1153,0x1153,0x1153,0x1973,0x1153,0x1153,0x1153,0x1153,0x1974,0x1974,0x1174,0x1174,0x1174,0x1195,0x2258,0x1A38,0x11B6,0x1196,0x1175,0x1154,0x1174,0x1133,0x0933,0x1133,0x1154,0x1175,0x11B5,0x19F7,0x19F7,0x19D6,0x1175,0x1155,0x1154,0x1133,0x1113,0x1112,0x1112,0x1111,0x1111,0x1111,0x10F1,0x1112,0x1112,0x1112,0x1133,0x1132,0x1112,0x1112,0x1932,0x1932,0x1112,0x1932,0x1912,0x1912,0x1912,0x1912,0x1112,0x1112,0x1112,0x1112,0x1112,0x1932,0x1132,0x1112,0x1112,0x1112,0x1932,0x1132,0x1932,0x1132,0x1932,0x1932,0x1111,0x1932,0x1932,0x1912,0x1932,0x1932,0x1112,0x1912,0x1112,0x1112,0x1132,0x1132,0x1112,0x1112,0x1112,0x1112,0x1111,0x1112,0x1912,0x1112,0x10F2,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1113,0x1133,0x1154,0x0975,0x0996,0x09D8,0x09D8,0x09F9,0x09F9,0x01D9,0x01F9,0x01D9,0x01D9,0x01F9,0x01D9,0x01D9,0x01D9,0x01FA,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01B9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01F9,0x01F9,0x01D9,0x01D9,0x01D9,0x01D9,0x01F9,0x09F9,0x09D8,0x09D8,0x09D7,0x11B6,0x1195,0x1154,0x1153,0x1932,0x1931,0x1911,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x210F,0x2930,0x2130,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x2110,0x2110,0x2910,0x2930,0x290F,0x210F,0x210F,0x210F,0x290F,0x2910,0x290F,0x210F,0x2930,0x2930,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x290F,0x2930,0x210F,0x210F,0x210F,0x290F,0x212F,0x210F,0x2110,0x2910,0x2110,0x2910,0x210F,0x210F,0x290F,0x210F,0x290F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x1911,0x1111,0x1133,0x19B6,0x1A18,0x19F8,0x11B6,0x1133,0x1931,0x1931,0x2110,0x2130,0x2130,0x210F,0x210F,0x292F,0x210F,0x292F,0x212F,0x2130,0x2130,0x1931,0x1952,0x1133,0x1133,0x19F6,0x2217,0x19D6,0x19B5,0x1153,0x1112,0x1911,0x2131,0x2930,0x2930,0x2930,0x210F,0x292F,0x292F,0x290F,0x290F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x2930,0x210F,0x2930,0x212F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x290F,0x2910,0x2930,0x2130,0x2130,0x210F,0x210F,0x2130,0x2930,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x212F,0x210F,0x210F,0x290F,0x2930,0x290F,0x290F,0x290F,0x2930,0x210F,0x212F,0x2930,0x212F,0x212F,0x212F,0x2130,0x2130,0x2150,0x2131,0x1951,0x1932,0x1112,0x1154,0x1175,0x19D7,0x21F8,0x21F7,0x21D6,0x1154,0x1112,0x1111,0x1911,0x1930,0x1930,0x2130,0x2110,0x2110,0x2130,0x212F,0x210F,0x2930,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2111,0x2131,0x2132,0x1932,0x1113,0x1154,0x1175,0x21D7,0x2A38,0x21F7,0x1174,0x1133,0x0912,0x1132,0x2172,0x2131,0x1910,0x2110,0x2130,0x2130,0x20EF,0x210F,0x2110,0x2130,0x1911,0x1132,0x11B6,0x19F8,0x1A18,0x19D7,0x10F2,0x1912,0x2131,0x2131,0x2110,0x2110,0x2110,0x2110,0x212F,0x212F,0x2910,0x2910,0x212F,0x212F,0x2930,0x2930,0x210F,0x210F,0x2110,0x2110,0x2910,0x2910,0x290F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2110,0x210F,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x212F,0x2930,0x290F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x1931,0x1931,0x1932,0x1112,0x21B5,0x21F7,0x21F7,0x19B6,0x1113,0x1932,0x1931,0x2131,0x2130,0x2110,0x2110,0x2130,0x2110,0x210F,0x210F,0x210F,0x2130,0x2110,0x2930,0x2930,0x2110,0x210F,0x210F,0x2130,0x2130,0x2151,0x2151,0x1931,0x1132,0x1133,0x1174,0x19B6,0x2217,0x2217,0x1195,0x1175,0x1154,0x1933,0x1932,0x1911,0x1911,0x2131,0x2130,0x2110,0x2110,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x1951,0x1931,0x1111,0x1132,0x1174,0x19D5,0x19D6,0x2217,0x19D6,0x1995,0x1133,0x1112,0x2132,0x2131,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x290F,0x290F,0x2930,0x2930,0x2930,0x210F,0x290F,0x210F,0x2910,0x2930,0x2930,0x2110,0x2110,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1954,0x1995,0x19B6,0x21D7,0x19D6,0x19B5,0x1133,0x1112,0x1112,0x1932,0x1952,0x1952,0x1952,0x1152,0x1112,0x0932,0x1174,0x19B6,0x2218,0x2218,0x19B6,0x1195,0x1133,0x1112,0x1932,0x1911,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x2930,0x210F,0x2930,0x290F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x290F,0x210F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2110,0x210F,0x2910,0x210F,0x2110,0x2930,0x210F,0x2110,0x2110,0x210F,0x210F,0x212F,0x210F,0x2930,0x2130,0x2130,0x2110,0x2110,0x2910,0x2110,0x2930,0x2930,0x210F,0x290F,0x290F,0x2910,0x210F,0x210F,0x290F,0x290F,0x292F,0x292F,0x292F,0x210F,0x2130,0x2110,0x2130,0x2131,0x1931,0x1931,0x1952,0x1153,0x1174,0x19B5,0x19D6,0x19F7,0x1A18,0x1A18,0x1A18,0x1A18,0x11B6,0x1154,0x1133,0x1932,0x1931,0x1911,0x2130,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x2130,0x2130,0x212F,0x2130,0x210F,0x2110,0x2130,0x2930,0x2110,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2130,0x2110,0x2110,0x2151,0x2152,0x1911,0x1112,0x1153,0x1174,0x21F7,0x2217,0x19D6,0x19D6,0x1174,0x1153,0x1953,0x1912,0x1911,0x2111,0x2111,0x2131,0x2110,0x2110,0x2130,0x2130,0x2950,0x2110,0x2110,0x2130,0x212F,0x210F,0x292F,0x212F,0x290F,0x292F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x292F,0x292F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x292F,0x292F,0x2930,0x210F,0x210F,0x2130,0x2130,0x1910,0x1911,0x1932,0x1153,0x1174,0x19D6,0x19D7,0x19D7,0x19D6,0x1994,0x1932,0x1931,0x2131,0x2131,0x2130,0x2131,0x1931,0x1112,0x1133,0x1174,0x19D6,0x19F7,0x19D6,0x1974,0x1932,0x1931,0x2110,0x2110,0x2130,0x2110,0x2130,0x2131,0x1932,0x1134,0x11B7,0x1A18,0x1A19,0x19B7,0x1133,0x1932,0x2131,0x2130,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,
  0x2130,0x2151,0x1931,0x1931,0x1111,0x1111,0x0932,0x1154,0x19B6,0x2217,0x2218,0x19D7,0x19B6,0x1134,0x1113,0x1932,0x2132,0x2131,0x2131,0x2110,0x2130,0x2150,0x2130,0x212F,0x2130,0x2130,0x2130,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2930,0x212F,0x212F,0x2930,0x212F,0x2930,0x210F,0x2130,0x2110,0x2110,0x2110,0x290F,0x2930,0x210F,0x2130,0x2130,0x212F,0x212F,0x2930,0x2910,0x210F,0x2910,0x2910,0x210F,0x2910,0x2910,0x210F,0x2910,0x2910,0x210F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2110,0x210F,0x2930,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x2910,0x2910,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2111,0x18F2,0x1133,0x2219,0x11D9,0x09D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x021B,0x01FA,0x01DA,0x01D9,0x01F9,0x09D8,0x0997,0x0955,0x1133,0x1113,0x1912,0x1912,0x1912,0x1912,0x1911,0x1911,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1932,0x1911,0x1912,0x1912,0x1912,0x1912,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1931,0x1931,0x1932,0x1931,0x1931,0x1931,0x1931,0x1932,0x1931,0x1931,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x0932,0x0933,0x0995,0x1A38,0x19F7,0x11B6,0x1195,0x1195,0x1154,0x1133,0x1133,0x0913,0x1133,0x1134,0x1175,0x19B6,0x19F7,0x19F7,0x11B6,0x1196,0x0955,0x1155,0x1134,0x1133,0x1113,0x1133,0x1112,0x1112,0x1112,0x1113,0x0913,0x1133,0x0913,0x1133,0x1133,0x1133,0x1132,0x1133,0x1133,0x1133,0x1133,0x1113,0x1113,0x1113,0x1112,0x1112,0x1112,0x1113,0x1113,0x1133,0x1132,0x1133,0x1133,0x1133,0x1133,0x1132,0x1132,0x1133,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1133,0x1132,0x1132,0x1133,0x1133,0x1133,0x1133,0x1113,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1113,0x1133,0x1133,0x1133,0x1153,0x1153,0x1153,0x1154,0x1154,0x1175,0x1175,0x0996,0x09B7,0x09B8,0x09D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01D9,0x01DA,0x01DA,0x01DA,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01D9,0x01DA,0x01FA,0x01FA,0x01D9,0x01D9,0x01FA,0x01DA,0x01FA,0x01D9,0x01F9,0x01F9,0x01D9,0x01F9,0x09F9,0x09D8,0x09D7,0x11B7,0x1195,0x1174,0x1153,0x1132,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2110,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x210F,0x210F,0x2130,0x210F,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2930,0x290F,0x290F,0x290F,0x210F,0x2130,0x2130,0x2110,0x2130,0x2131,0x1911,0x1111,0x1133,0x11B6,0x1A18,0x19F7,0x19B6,0x1133,0x1931,0x2131,0x2110,0x2110,0x2130,0x212F,0x210F,0x292F,0x292F,0x210F,0x210F,0x2130,0x2130,0x1931,0x1952,0x1133,0x0933,0x19D6,0x2217,0x19D6,0x19B5,0x1153,0x1112,0x1911,0x2131,0x2930,0x2110,0x210F,0x210F,0x290F,0x292F,0x292F,0x290F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2130,0x2130,0x2930,0x2110,0x2130,0x210F,0x290F,0x290F,0x2930,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2930,0x210F,0x2110,0x2110,0x2910,0x210F,0x2910,0x2910,0x2910,0x2930,0x2930,0x212F,0x212F,0x2930,0x210F,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x2130,0x210F,0x212F,0x2930,0x2110,0x2910,0x2930,0x2930,0x290F,0x290F,0x290F,0x210F,0x2930,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x2151,0x1111,0x1132,0x1154,0x1995,0x21F7,0x2218,0x21F8,0x19B6,0x1154,0x1112,0x1912,0x1911,0x2131,0x1910,0x2130,0x212F,0x2130,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2131,0x2132,0x1912,0x1113,0x1134,0x1996,0x21D7,0x2218,0x21F7,0x1175,0x1154,0x1133,0x1132,0x1111,0x1931,0x1910,0x2110,0x2110,0x2930,0x2130,0x2110,0x2110,0x2130,0x2130,0x1931,0x1132,0x11B6,0x19F8,0x1A19,0x19D7,0x10F2,0x1911,0x2111,0x2130,0x2110,0x2110,0x2110,0x2110,0x212F,0x212F,0x2910,0x2930,0x210F,0x2930,0x2910,0x2910,0x2910,0x2110,0x210F,0x2110,0x2910,0x2910,0x2930,0x210F,0x212F,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2910,0x2910,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x212F,0x292F,0x210F,0x212F,0x2930,0x210F,0x210F,0x290F,0x210F,0x210F,0x2110,0x2130,0x2130,0x1931,0x1931,0x1932,0x1112,0x21B5,0x2A17,0x21F7,0x19B6,0x1113,0x1932,0x2132,0x2131,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x210F,0x210F,0x2930,0x2110,0x2130,0x2130,0x210F,0x212F,0x292F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1931,0x1132,0x1133,0x1174,0x19B6,0x21F7,0x2218,0x19B6,0x1975,0x1954,0x1112,0x1912,0x2131,0x2131,0x2110,0x2110,0x2130,0x2930,0x210F,0x212F,0x212F,0x210F,0x2930,0x2950,0x210F,0x2130,0x2151,0x1931,0x1111,0x1111,0x1132,0x1194,0x11B5,0x19D6,0x2217,0x19D6,0x1995,0x1133,0x1932,0x2111,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2910,0x2930,0x2930,0x2110,0x210F,0x290F,0x2910,0x2910,0x2910,0x2930,0x2930,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2110,0x2130,0x1931,0x1932,0x1153,0x1975,0x1175,0x19D7,0x21D7,0x19B6,0x1995,0x1153,0x1132,0x1932,0x1932,0x1952,0x1952,0x1131,0x1131,0x1132,0x0933,0x1195,0x11B6,0x19F7,0x1A17,0x19D6,0x1995,0x1133,0x1132,0x1912,0x2131,0x2111,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x2930,0x290F,0x290F,0x212F,0x212F,0x212F,0x292F,0x212F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2930,0x2110,0x210F,0x2910,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x292F,0x210F,0x210F,0x292F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1953,0x1994,0x1195,0x1A17,0x1A17,0x2238,0x1A38,0x11F8,0x1A39,0x1A59,0x1A39,0x1A18,0x19D7,0x1155,0x1133,0x1932,0x1931,0x2131,0x2151,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x2130,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2930,0x2110,0x2930,0x2930,0x2110,0x2930,0x2130,0x2130,0x210F,0x2130,0x2110,0x2130,0x2130,0x1931,0x1932,0x1112,0x1153,0x1174,0x19B6,0x21F7,0x19F7,0x19D6,0x1995,0x1154,0x1133,0x1112,0x1912,0x2111,0x2111,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x212F,0x292F,0x292F,0x290F,0x290F,0x290F,0x2930,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x292F,0x292F,0x292F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x212F,0x210F,0x2130,0x2130,0x2151,0x1911,0x1911,0x1153,0x1154,0x1995,0x19D7,0x21F7,0x21F7,0x1995,0x1974,0x1932,0x1931,0x2131,0x2131,0x2131,0x2131,0x1932,0x1112,0x1133,0x1195,0x19D6,0x21F7,0x21D6,0x1974,0x1952,0x2131,0x2130,0x2110,0x2110,0x2130,0x2131,0x1931,0x1933,0x1134,0x19B7,0x1A18,0x1A18,0x19D7,0x1133,0x1912,0x2111,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,
  0x210F,0x210F,0x2130,0x2131,0x1931,0x1131,0x1132,0x1133,0x1995,0x19B6,0x21F7,0x2218,0x19F7,0x1995,0x1134,0x1113,0x1932,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x210F,0x2910,0x2110,0x2110,0x210F,0x2930,0x2930,0x2110,0x2930,0x212F,0x2930,0x212F,0x212F,0x2930,0x212F,0x2930,0x290F,0x290F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x2910,0x210F,0x2910,0x2910,0x2930,0x290F,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2110,0x2110,0x2110,0x18F1,0x10F1,0x1134,0x2219,0x09D9,0x01B9,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01FA,0x021A,0x021A,0x01FA,0x01FA,0x01F9,0x01F9,0x09B8,0x0976,0x1154,0x1113,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1910,0x1910,0x1910,0x1910,0x1910,0x1930,0x1910,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x2131,0x1911,0x1911,0x1911,0x1931,0x1911,0x1931,0x1911,0x1931,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x1911,0x1911,0x1931,0x1911,0x1931,0x1932,0x1932,0x1932,0x1931,0x1932,0x1132,0x1112,0x0933,0x0954,0x19F7,0x2238,0x2238,0x11B6,0x1175,0x1174,0x1133,0x1133,0x0913,0x0933,0x1154,0x1195,0x19D7,0x19F8,0x1A18,0x19F7,0x11D7,0x19D7,0x19B6,0x19B5,0x19B6,0x19B5,0x21D6,0x21D6,0x19B6,0x19B6,0x19B5,0x19B6,0x19B6,0x19B5,0x19B5,0x19B5,0x19B5,0x19B5,0x21B5,0x21B5,0x21B5,0x21B5,0x21B5,0x21B5,0x21B5,0x2195,0x2195,0x2195,0x2195,0x1995,0x21B5,0x21B5,0x21B5,0x2195,0x19B5,0x19B5,0x21B5,0x19B5,0x21B5,0x21B5,0x21B4,0x1994,0x1994,0x1994,0x19B5,0x19B5,0x19B5,0x1995,0x19B5,0x1995,0x19B5,0x19B5,0x21B5,0x19B5,0x21B5,0x19B5,0x1995,0x21B5,0x21B5,0x2195,0x21B5,0x19B5,0x19B5,0x19B5,0x19B5,0x19B6,0x1996,0x19B6,0x19B6,0x11B6,0x09B7,0x09B8,0x09F9,0x01D9,0x01D9,0x01FA,0x01D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01D9,0x01D9,0x01F9,0x01D9,0x09F9,0x09D8,0x09B7,0x0996,0x0954,0x1153,0x1932,0x1931,0x2131,0x2131,0x2131,0x2110,0x2110,0x2130,0x2110,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x210F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x2110,0x210F,0x2130,0x210F,0x210F,0x212F,0x292F,0x210F,0x210F,0x210F,0x210F,0x292F,0x2930,0x212F,0x2930,0x2910,0x210F,0x2110,0x2910,0x210F,0x290F,0x290F,0x2930,0x2910,0x2930,0x2130,0x2110,0x2130,0x2130,0x1931,0x1932,0x1133,0x11B6,0x1A18,0x19F7,0x1195,0x1132,0x1931,0x1931,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x2110,0x1910,0x1932,0x1132,0x1113,0x0933,0x19D6,0x21F7,0x19D6,0x19B5,0x1174,0x1132,0x1932,0x2131,0x2130,0x2930,0x290F,0x292F,0x210F,0x290F,0x290F,0x290F,0x2910,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x2930,0x292F,0x292F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x290F,0x290F,0x2910,0x2910,0x2910,0x210F,0x290F,0x2910,0x210F,0x210F,0x2110,0x2930,0x210F,0x2930,0x2910,0x2910,0x2910,0x2110,0x210F,0x212F,0x210F,0x212F,0x210F,0x2930,0x2930,0x2110,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2110,0x210F,0x2930,0x2110,0x2930,0x290F,0x2110,0x2930,0x2930,0x2130,0x212F,0x2130,0x2130,0x2151,0x1910,0x10F1,0x1132,0x1153,0x19B6,0x19F7,0x2218,0x21F7,0x19B6,0x1154,0x1112,0x1112,0x1911,0x1910,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2951,0x2131,0x1911,0x1912,0x1133,0x1133,0x1175,0x21D7,0x2A38,0x21F7,0x1975,0x1134,0x1133,0x1132,0x1952,0x2152,0x1910,0x1910,0x2130,0x2130,0x2930,0x2110,0x2130,0x2110,0x2110,0x2131,0x1932,0x1133,0x11B6,0x1A18,0x1A19,0x19D7,0x08F2,0x1911,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x212F,0x2930,0x290F,0x290F,0x2930,0x210F,0x2910,0x2110,0x2110,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2910,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x290F,0x210F,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x210F,0x212F,0x212F,0x292F,0x212F,0x210F,0x212F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2130,0x2130,0x1931,0x1911,0x1912,0x1132,0x21B5,0x21F7,0x21F7,0x1995,0x1113,0x1112,0x2132,0x2131,0x2130,0x2130,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x2110,0x2930,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1953,0x1153,0x1154,0x19B6,0x2218,0x2218,0x1996,0x1975,0x1954,0x1912,0x18F1,0x1911,0x1911,0x2110,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x2930,0x2950,0x18EF,0x190F,0x2151,0x2171,0x1911,0x1931,0x1132,0x1132,0x1153,0x1995,0x2217,0x2217,0x19D6,0x1174,0x1112,0x1932,0x2131,0x2111,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2910,0x2930,0x210F,0x292F,0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x2910,0x290F,0x2930,0x2910,0x290F,0x290F,0x290F,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x1134,0x1996,0x21D7,0x21D7,0x19B6,0x1975,0x1974,0x1132,0x10F1,0x1932,0x1952,0x1951,0x1931,0x1152,0x1132,0x0933,0x1174,0x19B6,0x1A17,0x2218,0x21F7,0x1995,0x1133,0x1112,0x18F1,0x2131,0x2111,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x212F,0x212F,0x210F,0x2930,0x210F,0x290F,0x2930,0x2930,0x290F,0x2930,0x210F,0x2110,0x2110,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1930,0x1931,0x1132,0x1153,0x1174,0x11D6,0x1A17,0x2238,0x1A18,0x11D7,0x09B7,0x0996,0x09B7,0x11F8,0x1A39,0x1A18,0x11B6,0x1154,0x1112,0x1931,0x1931,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2930,0x2930,0x2110,0x2130,0x2130,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2131,0x2152,0x1932,0x1112,0x1133,0x1174,0x19D6,0x2217,0x21F7,0x19D6,0x1175,0x1154,0x1112,0x1912,0x1911,0x2131,0x2111,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x292F,0x290F,0x210F,0x210F,0x2930,0x290F,0x212F,0x212F,0x290F,0x210F,0x212F,0x210F,0x212F,0x210F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2950,0x2130,0x210F,0x2110,0x2151,0x2151,0x1931,0x1132,0x1153,0x1175,0x19D7,0x19F7,0x21F7,0x19D6,0x1974,0x1133,0x1131,0x1931,0x2151,0x2151,0x2131,0x1932,0x1112,0x1113,0x0913,0x0934,0x19D7,0x21F7,0x21D6,0x1973,0x1952,0x1931,0x2130,0x2110,0x2110,0x2110,0x2131,0x1932,0x1133,0x1154,0x11B6,0x19F8,0x2218,0x19B6,0x1133,0x1912,0x2131,0x2110,0x2110,0x212F,0x210F,0x210F,0x212F,0x292F,0x292F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,
  0x210F,0x210F,0x2130,0x2130,0x2131,0x1931,0x1111,0x1132,0x1153,0x1174,0x19D6,0x2217,0x2217,0x21F7,0x1996,0x1133,0x1133,0x1952,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2910,0x2110,0x2930,0x210F,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x212F,0x2130,0x210F,0x212F,0x2130,0x212F,0x210F,0x210F,0x290F,0x2110,0x2930,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2910,0x210F,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x18F1,0x18F2,0x1133,0x19F8,0x11F9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x021A,0x01FA,0x01FA,0x01F9,0x01F9,0x09D8,0x0996,0x1154,0x1112,0x1912,0x1911,0x2111,0x2111,0x2111,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x1930,0x1930,0x1930,0x2131,0x2131,0x1910,0x2131,0x2131,0x2131,0x2131,0x2111,0x2111,0x2131,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1930,0x2131,0x2131,0x1910,0x1931,0x1931,0x2131,0x1931,0x1911,0x2131,0x1931,0x1931,0x1931,0x1931,0x1132,0x1132,0x0912,0x0974,0x2238,0x2217,0x19F7,0x11B6,0x1175,0x1154,0x1133,0x0933,0x0933,0x0933,0x1154,0x1196,0x19F7,0x1A18,0x1A18,0x2238,0x2218,0x2217,0x2217,0x21F7,0x2A17,0x2A38,0x2A38,0x2A38,0x2A38,0x2A38,0x2237,0x2A37,0x2A37,0x2A37,0x2A37,0x2A37,0x2A17,0x2A37,0x2A17,0x2A38,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x2A37,0x2A17,0x2A17,0x2A16,0x2A17,0x29F6,0x2A16,0x2A16,0x2A16,0x2A17,0x2A17,0x21F7,0x2A37,0x2217,0x2217,0x2217,0x2217,0x2217,0x2A17,0x2217,0x2A17,0x2A17,0x2A17,0x21F7,0x29F7,0x21F7,0x2A17,0x21F6,0x21F7,0x21F7,0x21F7,0x19D6,0x21F7,0x19D7,0x19D7,0x11B7,0x09D8,0x09D8,0x01D9,0x01F9,0x01D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01D9,0x01FA,0x01D9,0x01D9,0x09D8,0x09D8,0x09D7,0x11B6,0x1174,0x1133,0x1932,0x1931,0x2131,0x2131,0x2130,0x2110,0x2130,0x2110,0x2110,0x210F,0x2130,0x2110,0x2130,0x212F,0x210F,0x2130,0x212F,0x210F,0x2930,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x210F,0x2930,0x2910,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x2930,0x2930,0x2930,0x210F,0x2130,0x2110,0x2130,0x2131,0x1932,0x1133,0x19D6,0x19F7,0x19F7,0x1996,0x1132,0x1911,0x1931,0x2130,0x2130,0x2130,0x212F,0x292F,0x292F,0x212F,0x212F,0x210F,0x2130,0x1910,0x1911,0x1132,0x1133,0x0933,0x19D6,0x19F7,0x19D6,0x19D5,0x1174,0x1112,0x1931,0x2131,0x2130,0x210F,0x292F,0x292F,0x290F,0x290F,0x2930,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x210F,0x290F,0x290F,0x2930,0x292F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2930,0x290F,0x290F,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x2910,0x2110,0x2930,0x2930,0x2930,0x2110,0x2110,0x2910,0x2910,0x210F,0x210F,0x212F,0x212F,0x2930,0x2930,0x212F,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x2130,0x210F,0x210F,0x2130,0x2130,0x210F,0x2110,0x2110,0x2930,0x290F,0x2930,0x2130,0x2110,0x2110,0x2110,0x2130,0x2131,0x1911,0x1111,0x1112,0x1133,0x19B6,0x21F7,0x2217,0x2218,0x19B6,0x1154,0x1112,0x1112,0x1911,0x1931,0x1910,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1911,0x1912,0x1133,0x1133,0x1995,0x21F7,0x21F8,0x21F7,0x19B6,0x1154,0x1133,0x1112,0x1111,0x2152,0x2151,0x1930,0x190F,0x2130,0x2130,0x2930,0x2130,0x2130,0x2110,0x2130,0x2131,0x1932,0x1113,0x19D6,0x11F8,0x1A18,0x19D7,0x08F2,0x1931,0x2131,0x2110,0x2110,0x2930,0x2930,0x2930,0x210F,0x210F,0x2910,0x2910,0x2910,0x2930,0x210F,0x2910,0x2110,0x210F,0x2930,0x210F,0x210F,0x2930,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x2930,0x290F,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x2110,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x290F,0x292F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2110,0x1931,0x1931,0x1932,0x1112,0x19B5,0x2A17,0x21F7,0x19B6,0x08F2,0x1912,0x2132,0x2131,0x2131,0x2130,0x210F,0x210F,0x2930,0x2910,0x210F,0x210F,0x2110,0x2110,0x2110,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x1133,0x1154,0x19B6,0x2A38,0x21F8,0x1996,0x1995,0x1133,0x1912,0x1912,0x2131,0x2131,0x2131,0x2130,0x2110,0x210F,0x2130,0x210F,0x2930,0x2950,0x20EF,0x18EF,0x2151,0x2151,0x1931,0x1931,0x1131,0x1131,0x1132,0x1154,0x19D6,0x2217,0x2217,0x19B5,0x1133,0x1932,0x1911,0x2131,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x210F,0x2910,0x290F,0x290F,0x290F,0x210F,0x2110,0x2910,0x2110,0x2110,0x2930,0x2110,0x2910,0x2910,0x2930,0x2930,0x2930,0x212F,0x212F,0x292F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2151,0x1932,0x1932,0x1133,0x1974,0x19B6,0x21D6,0x21D6,0x21B6,0x1995,0x1954,0x1112,0x10F1,0x1932,0x1952,0x1952,0x1952,0x1152,0x0912,0x1154,0x1154,0x11D6,0x2238,0x2217,0x19D6,0x1995,0x1133,0x1112,0x1911,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x292F,0x292F,0x212F,0x210F,0x210F,0x210F,0x292F,0x212F,0x210F,0x210F,0x2110,0x2110,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x210F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x292F,0x292F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2110,0x2130,0x2130,0x1931,0x1931,0x1132,0x1153,0x11B6,0x19F7,0x11F8,0x11B7,0x0996,0x0976,0x0976,0x0996,0x0976,0x0976,0x0997,0x11F8,0x19D8,0x1996,0x1133,0x1912,0x1911,0x1910,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x210F,0x212F,0x2130,0x2930,0x2930,0x2930,0x2130,0x210F,0x2130,0x2930,0x2930,0x2130,0x2930,0x212F,0x212F,0x2130,0x2130,0x2131,0x2952,0x2131,0x1911,0x1112,0x1133,0x1174,0x21F7,0x21F7,0x21F7,0x19D6,0x1175,0x1154,0x1112,0x1932,0x1932,0x2111,0x2111,0x2111,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x292F,0x292F,0x290F,0x210F,0x212F,0x292F,0x210F,0x212F,0x210F,0x290F,0x292F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x1931,0x1112,0x1153,0x1174,0x19B6,0x19F7,0x2218,0x21F7,0x1995,0x1153,0x1932,0x1931,0x1931,0x1931,0x2151,0x1931,0x1912,0x1133,0x1133,0x1154,0x1196,0x21D7,0x21D6,0x21B5,0x1973,0x1952,0x2131,0x2110,0x2110,0x2130,0x2131,0x2132,0x1932,0x1113,0x1154,0x11B6,0x2218,0x2218,0x19B6,0x1133,0x1911,0x2111,0x2110,0x2130,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2110,0x2110,
  0x210F,0x2110,0x2110,0x2150,0x2130,0x1930,0x1910,0x1111,0x1111,0x1153,0x1174,0x19B6,0x19F7,0x2218,0x21F7,0x1995,0x0933,0x1133,0x1953,0x1932,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x2950,0x2130,0x2130,0x2930,0x2930,0x2910,0x2910,0x2910,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x210F,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x2910,0x2910,0x210F,0x2910,0x210F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x2930,0x290F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2930,0x2110,0x2110,0x1911,0x1912,0x1974,0x1A18,0x09B8,0x09FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01FA,0x021A,0x01DA,0x01DA,0x01D9,0x01D9,0x1219,0x1A18,0x0934,0x1133,0x1912,0x2132,0x2111,0x2111,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1930,0x1930,0x1931,0x2131,0x2131,0x2131,0x2151,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2130,0x2131,0x2131,0x2131,0x2131,0x2110,0x2131,0x2110,0x2131,0x2151,0x2131,0x2131,0x2131,0x2131,0x1910,0x1931,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1932,0x1132,0x0912,0x0933,0x0954,0x1195,0x19D6,0x19D7,0x19D6,0x19B6,0x1154,0x1154,0x0933,0x0933,0x0933,0x1154,0x1174,0x19B5,0x19D6,0x19D6,0x19D6,0x21F7,0x21F6,0x21F6,0x21F7,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21F6,0x21F6,0x21F6,0x21D6,0x21F6,0x21F6,0x21F6,0x21D6,0x21F6,0x21F7,0x21D6,0x21F6,0x21F6,0x21D6,0x21D6,0x21F7,0x21D6,0x21D6,0x21D6,0x21D6,0x21F6,0x21D6,0x21D6,0x21F6,0x21F6,0x21F6,0x21F6,0x21F6,0x21F6,0x21F6,0x21D6,0x21D6,0x21D6,0x21D6,0x21F6,0x21F6,0x21F6,0x21F6,0x21F7,0x19D6,0x19D6,0x21D6,0x21D6,0x19D6,0x21F7,0x21D6,0x21D6,0x21D6,0x21D6,0x21D7,0x21D6,0x21F7,0x21F6,0x19D6,0x21F7,0x21F7,0x19D7,0x19D7,0x11D8,0x11D8,0x09D9,0x09F9,0x01D9,0x01B9,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FB,0x01FB,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01F9,0x01F9,0x01D9,0x09D9,0x09D8,0x11F8,0x11B6,0x1175,0x1133,0x1111,0x1931,0x1910,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x212F,0x210F,0x212F,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x2910,0x2910,0x2910,0x2930,0x2930,0x2930,0x2910,0x2110,0x2110,0x2110,0x2130,0x212F,0x210F,0x210F,0x210F,0x290F,0x2930,0x290F,0x290F,0x210F,0x290F,0x2930,0x2910,0x2910,0x210F,0x2930,0x210F,0x290F,0x290F,0x2910,0x210F,0x210F,0x2930,0x2110,0x2130,0x2130,0x1911,0x1932,0x1133,0x19F6,0x1A18,0x19F7,0x1196,0x1153,0x1931,0x2131,0x2110,0x2130,0x2950,0x2130,0x292F,0x292F,0x212F,0x210F,0x212F,0x2130,0x2130,0x1931,0x1132,0x1153,0x1154,0x19F6,0x19F7,0x19D6,0x19D5,0x1174,0x1111,0x1911,0x2130,0x2930,0x2930,0x292F,0x290F,0x290F,0x292F,0x2930,0x2930,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x2151,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x210F,0x2930,0x2930,0x212F,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x2930,0x290F,0x2910,0x2910,0x20EF,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2910,0x290F,0x2930,0x290F,0x2930,0x290F,0x290F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x2130,0x2130,0x2130,0x2151,0x1952,0x1112,0x1112,0x1133,0x19B5,0x2217,0x2217,0x21F7,0x1995,0x1154,0x1132,0x1112,0x1931,0x2131,0x2130,0x2130,0x210F,0x210F,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2930,0x212F,0x2130,0x2130,0x2130,0x2131,0x2132,0x1932,0x1112,0x1133,0x1995,0x2A38,0x21F7,0x19B7,0x1996,0x1154,0x1113,0x1132,0x1932,0x1911,0x2151,0x2151,0x2150,0x210F,0x210F,0x210F,0x212F,0x2130,0x210F,0x2110,0x2150,0x2151,0x1932,0x1133,0x19D6,0x1A18,0x1A19,0x19B7,0x1112,0x1931,0x2131,0x2130,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2910,0x2930,0x2910,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x210F,0x2930,0x210F,0x2910,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x2930,0x210F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2930,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x290F,0x290F,0x210F,0x210F,0x212F,0x2130,0x2110,0x2130,0x1910,0x1931,0x1932,0x1112,0x21B5,0x29F7,0x21F7,0x19B5,0x08F2,0x10F2,0x1932,0x2131,0x2131,0x2130,0x2110,0x20EF,0x2930,0x2930,0x2130,0x2110,0x2130,0x2130,0x2110,0x210F,0x2130,0x212F,0x210F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2131,0x2131,0x2152,0x1932,0x1132,0x1133,0x1154,0x19B6,0x21F7,0x21F7,0x21D7,0x1995,0x1153,0x1112,0x1932,0x1931,0x2131,0x2131,0x2110,0x2110,0x2130,0x2930,0x2930,0x2930,0x2130,0x2110,0x2150,0x2151,0x2151,0x2130,0x2151,0x1931,0x1132,0x1132,0x0954,0x19D6,0x2217,0x21F7,0x19B5,0x1132,0x1931,0x1931,0x2131,0x2131,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x2930,0x210F,0x2930,0x2930,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x212F,0x212F,0x210F,0x212F,0x292F,0x292F,0x292F,0x212F,0x2130,0x2151,0x1931,0x1931,0x1932,0x1932,0x1953,0x1995,0x19B5,0x21D6,0x21D6,0x21D6,0x1995,0x1974,0x1112,0x1111,0x1931,0x1952,0x1952,0x1973,0x1153,0x0912,0x0933,0x0954,0x19D6,0x2238,0x2217,0x19D6,0x1995,0x1953,0x1112,0x1911,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x212F,0x210F,0x210F,0x210F,0x2930,0x2910,0x210F,0x2110,0x2110,0x2910,0x2930,0x2910,0x290F,0x290F,0x290F,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x2110,0x2910,0x210F,0x210F,0x290F,0x2930,0x2930,0x210F,0x210F,0x2930,0x210F,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2110,0x1910,0x1931,0x1132,0x19D6,0x2239,0x19F8,0x11B7,0x0976,0x0975,0x0975,0x0975,0x0955,0x0975,0x0976,0x0976,0x0976,0x11B7,0x2A59,0x1175,0x1112,0x1931,0x2111,0x2110,0x212F,0x210F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x2130,0x2130,0x2930,0x2930,0x2130,0x2930,0x2130,0x2930,0x2110,0x2130,0x2930,0x2930,0x212F,0x210F,0x2110,0x2130,0x2131,0x2131,0x2131,0x1912,0x1912,0x1133,0x1154,0x21D6,0x21F7,0x21F7,0x19D6,0x1995,0x1154,0x1112,0x1912,0x2132,0x2131,0x2111,0x2110,0x2130,0x2130,0x2130,0x2150,0x2130,0x212F,0x210F,0x210F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x1930,0x1931,0x1911,0x1111,0x1133,0x1174,0x19D6,0x2218,0x2218,0x21F7,0x1195,0x1153,0x1133,0x1932,0x1931,0x1931,0x1931,0x1951,0x1932,0x1112,0x1133,0x1975,0x19D7,0x2218,0x19D7,0x19B6,0x1974,0x1953,0x2152,0x2131,0x2110,0x2110,0x2131,0x2152,0x1932,0x1112,0x0913,0x1175,0x21F8,0x2239,0x21F8,0x1995,0x1112,0x1911,0x2131,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,
  0x2130,0x210F,0x2130,0x2130,0x2130,0x1910,0x1910,0x1910,0x1111,0x1132,0x1153,0x1174,0x19B6,0x19D7,0x2218,0x21F7,0x19B6,0x0934,0x1133,0x1932,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2930,0x2930,0x2130,0x2930,0x2110,0x2110,0x2910,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2930,0x2110,0x2110,0x2110,0x2910,0x210F,0x2910,0x2910,0x2110,0x2910,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x210F,0x290F,0x2910,0x2910,0x290F,0x290F,0x210F,0x2910,0x210F,0x290F,0x2910,0x2930,0x2930,0x290F,0x2930,0x2930,0x212F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x1911,0x1112,0x1154,0x19F8,0x09D9,0x09FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x021A,0x01FA,0x01FA,0x01DA,0x01FA,0x01F9,0x1219,0x11D8,0x0954,0x1133,0x1912,0x1932,0x2132,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1931,0x2131,0x2131,0x1931,0x2131,0x1931,0x2131,0x1931,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1952,0x1932,0x1952,0x1953,0x1133,0x0912,0x1133,0x1174,0x1175,0x19D7,0x19F7,0x19F7,0x19B6,0x1174,0x1154,0x0933,0x0913,0x1153,0x1133,0x1174,0x1174,0x1174,0x1995,0x1974,0x1995,0x1974,0x1974,0x1995,0x1975,0x1975,0x1995,0x1995,0x1995,0x1994,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1994,0x19B5,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x19B5,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1195,0x19B5,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1975,0x1995,0x1995,0x1995,0x1995,0x1995,0x1196,0x1196,0x1197,0x09B8,0x09D8,0x01D9,0x01D9,0x01D9,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FB,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01D9,0x01D9,0x09F9,0x09F9,0x09F8,0x11D7,0x0996,0x1154,0x1132,0x1931,0x1931,0x1930,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x212F,0x212F,0x210F,0x210F,0x2930,0x290F,0x290F,0x2930,0x210F,0x2910,0x210F,0x2930,0x210F,0x2110,0x2910,0x210F,0x2110,0x2910,0x2110,0x2110,0x210F,0x210F,0x290F,0x292F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2930,0x210F,0x290F,0x2930,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2130,0x1911,0x1932,0x1133,0x19D6,0x1A38,0x19D7,0x19B6,0x1153,0x1931,0x2131,0x2130,0x2130,0x2950,0x212F,0x210F,0x212F,0x292F,0x212F,0x212F,0x2130,0x2130,0x1931,0x1932,0x1133,0x1154,0x19F6,0x19F7,0x19F6,0x19D5,0x1174,0x1132,0x1931,0x2130,0x2130,0x292F,0x292F,0x292F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2110,0x2130,0x2110,0x210F,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x2930,0x210F,0x290F,0x210F,0x2110,0x2110,0x2110,0x2930,0x2930,0x210F,0x2110,0x2930,0x210F,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x290F,0x20EF,0x2930,0x2930,0x210F,0x210F,0x2130,0x2130,0x2131,0x1931,0x1111,0x1112,0x1133,0x1995,0x21F7,0x2217,0x21F7,0x19B6,0x1154,0x1132,0x1112,0x1911,0x1931,0x1930,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2930,0x2930,0x2130,0x2110,0x2131,0x2131,0x1912,0x1112,0x1133,0x1154,0x2A38,0x21F8,0x21D7,0x19B6,0x1154,0x1133,0x1932,0x1911,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2151,0x1932,0x1133,0x19D6,0x1A18,0x19F8,0x19D7,0x08F2,0x1931,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2910,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x212F,0x290F,0x290F,0x2930,0x2930,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x210F,0x2110,0x2110,0x2110,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x20EF,0x210F,0x2930,0x2930,0x18EF,0x1910,0x1910,0x1931,0x1932,0x1112,0x21B5,0x21F6,0x2217,0x21B6,0x08F2,0x10F2,0x1932,0x2131,0x2131,0x2130,0x20EF,0x210F,0x2930,0x2930,0x2130,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2110,0x2131,0x2131,0x2131,0x1931,0x1932,0x1132,0x1133,0x1154,0x19B6,0x2217,0x2217,0x21F7,0x1995,0x1133,0x1112,0x1912,0x2132,0x2111,0x2130,0x2110,0x2930,0x2930,0x2130,0x210F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1911,0x1132,0x0933,0x1195,0x2217,0x2237,0x21D6,0x1133,0x1112,0x1931,0x2131,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2930,0x290F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2930,0x2110,0x2910,0x2910,0x210F,0x290F,0x2930,0x210F,0x290F,0x2930,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x212F,0x210F,0x292F,0x210F,0x292F,0x292F,0x292F,0x212F,0x2150,0x2150,0x2130,0x2131,0x1931,0x1912,0x1933,0x1933,0x1995,0x19B5,0x21D6,0x19B6,0x21D6,0x21B6,0x1974,0x1132,0x1132,0x1132,0x1952,0x1973,0x1952,0x1132,0x0912,0x0953,0x1174,0x19D6,0x2217,0x2217,0x21F7,0x1975,0x1953,0x1112,0x1911,0x2111,0x2131,0x2110,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x2930,0x212F,0x2930,0x210F,0x212F,0x290F,0x2930,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2910,0x290F,0x2910,0x2930,0x2110,0x2110,0x2930,0x2910,0x2910,0x2110,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x292F,0x212F,0x212F,0x2130,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x1910,0x1931,0x1153,0x19F7,0x1A18,0x1A19,0x09B7,0x0955,0x0955,0x0934,0x0975,0x0955,0x0955,0x0975,0x0975,0x0976,0x11B7,0x2259,0x1996,0x10F2,0x1911,0x2111,0x2110,0x212F,0x212F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x210F,0x2130,0x2110,0x2130,0x2110,0x2110,0x2930,0x2930,0x2930,0x2130,0x2930,0x210F,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2130,0x2131,0x2111,0x1912,0x1912,0x1133,0x1954,0x19B6,0x21F7,0x21F7,0x21D6,0x1995,0x1154,0x1112,0x1912,0x1932,0x1911,0x2111,0x2131,0x2130,0x2130,0x2950,0x2130,0x212F,0x210F,0x210F,0x290F,0x292F,0x292F,0x212F,0x2130,0x212F,0x210F,0x212F,0x210F,0x292F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x1930,0x1931,0x1931,0x1111,0x1112,0x1954,0x1995,0x21F7,0x2218,0x2218,0x19B6,0x1154,0x1133,0x1132,0x1131,0x1931,0x1931,0x1951,0x1932,0x1132,0x1133,0x1175,0x19B6,0x19F7,0x19F7,0x19D7,0x19B5,0x1953,0x1932,0x1931,0x1911,0x2130,0x2131,0x2151,0x2152,0x1112,0x1112,0x1154,0x19D7,0x2238,0x2218,0x19D7,0x1154,0x1111,0x1931,0x2131,0x2130,0x2130,0x212F,0x212F,0x290F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2110,0x2130,0x2110,
  0x2130,0x2130,0x210F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2151,0x1931,0x1932,0x1133,0x1174,0x19D6,0x21F7,0x2218,0x19F7,0x19B6,0x1154,0x1133,0x1932,0x1932,0x2151,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2930,0x2110,0x2110,0x2930,0x2910,0x2930,0x2910,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2930,0x2930,0x290F,0x290F,0x290F,0x2910,0x2930,0x2910,0x290F,0x210F,0x2910,0x2930,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x210F,0x290F,0x290F,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x212F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x1911,0x1912,0x1134,0x1A18,0x09F9,0x09DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x021A,0x021A,0x01FA,0x01FA,0x01F9,0x09D8,0x0976,0x0955,0x0913,0x1113,0x1112,0x1912,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1910,0x1911,0x1931,0x1931,0x1111,0x1932,0x1932,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1111,0x1111,0x1112,0x1932,0x1953,0x1153,0x1133,0x0933,0x1174,0x1175,0x1195,0x11B6,0x11B6,0x19B6,0x1175,0x1174,0x1154,0x1153,0x1133,0x1133,0x1153,0x1153,0x1133,0x1133,0x1133,0x1933,0x1112,0x1933,0x1933,0x1933,0x1933,0x1953,0x1133,0x1153,0x1153,0x1153,0x1153,0x1133,0x1133,0x1153,0x1133,0x1153,0x1133,0x1933,0x1153,0x1153,0x1953,0x1953,0x1153,0x1153,0x1953,0x1953,0x1133,0x1153,0x1153,0x1153,0x1153,0x1953,0x1933,0x1933,0x1953,0x1153,0x1953,0x1953,0x1953,0x1953,0x1133,0x1133,0x1153,0x1153,0x1153,0x1153,0x1153,0x1153,0x1153,0x1153,0x1153,0x1153,0x1153,0x1153,0x1153,0x1954,0x1134,0x1954,0x1133,0x1133,0x1133,0x1133,0x1133,0x1154,0x0934,0x0955,0x0176,0x01B8,0x09F9,0x01D9,0x01D9,0x01D9,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x09F9,0x09F9,0x09D8,0x09B6,0x0975,0x1153,0x1932,0x2152,0x2131,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2930,0x2110,0x212F,0x212F,0x290F,0x210F,0x210F,0x290F,0x2930,0x2910,0x2910,0x2910,0x2930,0x2930,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x210F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x2930,0x290F,0x2910,0x2910,0x2110,0x210F,0x2130,0x2110,0x2110,0x2110,0x1931,0x1932,0x1133,0x19D6,0x1A17,0x19F7,0x1196,0x1133,0x1911,0x1911,0x2130,0x2130,0x2150,0x212F,0x212F,0x212F,0x292F,0x210F,0x212F,0x2130,0x2130,0x1931,0x1931,0x1132,0x1154,0x19D6,0x19D6,0x19D6,0x19B5,0x1153,0x1112,0x1911,0x2130,0x2130,0x292F,0x292F,0x290F,0x292F,0x2930,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2111,0x1911,0x1931,0x1931,0x1931,0x1931,0x2131,0x2131,0x2131,0x2131,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x2110,0x2110,0x2910,0x210F,0x2910,0x2910,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2151,0x2151,0x1911,0x1111,0x1112,0x1154,0x19B5,0x2217,0x21F7,0x19B6,0x19B6,0x1154,0x1132,0x1111,0x1911,0x1910,0x2130,0x2130,0x210F,0x2130,0x2130,0x2110,0x210F,0x2130,0x2110,0x2130,0x2130,0x212F,0x2110,0x2110,0x2130,0x2130,0x2111,0x1912,0x1132,0x1133,0x1995,0x21F7,0x21F7,0x19B7,0x19B6,0x1154,0x1133,0x1932,0x1932,0x1931,0x1931,0x2130,0x2110,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2151,0x1932,0x0912,0x19D7,0x1A18,0x19F8,0x19B6,0x08F2,0x1911,0x2131,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x210F,0x290F,0x290F,0x2930,0x2930,0x2110,0x2110,0x2910,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x2930,0x210F,0x210F,0x210F,0x2930,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x1112,0x21D5,0x2A17,0x2217,0x19B5,0x08F2,0x1912,0x1932,0x2151,0x2130,0x2930,0x2110,0x210F,0x2930,0x2110,0x2130,0x2130,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x2930,0x2110,0x2130,0x2130,0x2110,0x2110,0x2131,0x1931,0x1932,0x1933,0x1933,0x1154,0x19B6,0x21F7,0x2218,0x21F7,0x1175,0x0933,0x1133,0x1112,0x1931,0x2131,0x2110,0x2110,0x2110,0x2930,0x2130,0x2130,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x1910,0x1912,0x1133,0x1995,0x21F7,0x2217,0x21F7,0x1133,0x1112,0x1932,0x2151,0x2131,0x2130,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2110,0x2110,0x2910,0x2910,0x210F,0x2110,0x2930,0x290F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1911,0x1911,0x1912,0x1912,0x1954,0x1974,0x1995,0x1996,0x21D6,0x21D6,0x21D6,0x1974,0x1112,0x1132,0x1111,0x1952,0x1952,0x1952,0x1153,0x1133,0x1153,0x1174,0x19B6,0x19B6,0x21F7,0x21D7,0x1975,0x1133,0x1112,0x1911,0x1911,0x2110,0x2110,0x2130,0x2130,0x2130,0x2930,0x2130,0x210F,0x212F,0x212F,0x212F,0x2930,0x2930,0x210F,0x2930,0x210F,0x2110,0x2110,0x2110,0x2130,0x2110,0x210F,0x290F,0x290F,0x2110,0x2110,0x2930,0x2110,0x2930,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x210F,0x2930,0x2910,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x1910,0x1931,0x1153,0x19D6,0x1A18,0x1A18,0x11D7,0x0976,0x0955,0x0934,0x0954,0x0954,0x0955,0x0955,0x11B6,0x11B7,0x19F8,0x2218,0x1155,0x08F2,0x1911,0x2131,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2930,0x2110,0x210F,0x2930,0x2930,0x212F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2110,0x2130,0x2130,0x2131,0x2131,0x2131,0x1911,0x1912,0x1933,0x1954,0x1995,0x21F7,0x21F7,0x21D6,0x1995,0x1134,0x1133,0x1112,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x292F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x292F,0x292F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2950,0x2930,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x1931,0x1931,0x1132,0x1132,0x1974,0x1995,0x19D6,0x19D7,0x21D7,0x1995,0x1154,0x1153,0x1132,0x1932,0x1931,0x1931,0x1951,0x1931,0x1132,0x1133,0x1995,0x1996,0x19D7,0x21F8,0x19D7,0x19B6,0x1974,0x1932,0x1932,0x1911,0x1911,0x2131,0x2152,0x1931,0x1912,0x1112,0x1154,0x19B6,0x2218,0x2218,0x19D7,0x19B5,0x1153,0x1111,0x1931,0x2151,0x2130,0x2130,0x210F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,
  0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2151,0x2131,0x1931,0x1931,0x1132,0x1133,0x1174,0x19B6,0x1A17,0x1A17,0x19F7,0x19B6,0x0934,0x1133,0x1932,0x2152,0x2131,0x2130,0x2110,0x2110,0x2930,0x2110,0x2930,0x210F,0x2110,0x210F,0x2930,0x2110,0x2910,0x210F,0x2110,0x2110,0x2110,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x2930,0x212F,0x212F,0x210F,0x2930,0x2930,0x212F,0x292F,0x290F,0x2910,0x2910,0x2910,0x2930,0x210F,0x2930,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x212F,0x212F,0x212F,0x210F,0x292F,0x210F,0x292F,0x292F,0x210F,0x2110,0x2130,0x2130,0x2131,0x1911,0x10F2,0x1134,0x1A18,0x09D9,0x01D9,0x01DA,0x01FA,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x021A,0x021A,0x01FA,0x01DA,0x01FA,0x01D9,0x01B8,0x0177,0x0996,0x0955,0x0934,0x1133,0x1113,0x1113,0x1133,0x1133,0x1133,0x1133,0x1132,0x1112,0x1132,0x1132,0x1132,0x1132,0x1133,0x1133,0x1133,0x1133,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1133,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1132,0x1133,0x1132,0x1132,0x1132,0x1133,0x1133,0x1133,0x1133,0x1132,0x1133,0x1112,0x1133,0x1132,0x0912,0x0912,0x1112,0x1133,0x1133,0x1133,0x0933,0x1174,0x1175,0x1195,0x11B6,0x11B6,0x11B6,0x1195,0x1154,0x1154,0x1153,0x1153,0x1953,0x1132,0x1932,0x1932,0x1932,0x1932,0x1912,0x1932,0x1912,0x1932,0x1932,0x1912,0x1932,0x1932,0x1932,0x1112,0x1932,0x1932,0x1132,0x1112,0x1132,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1132,0x1132,0x1932,0x1932,0x1932,0x1932,0x1132,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1132,0x1932,0x1132,0x1932,0x1132,0x1132,0x1132,0x1952,0x1952,0x1932,0x1953,0x1132,0x1932,0x1933,0x1112,0x1932,0x1132,0x1932,0x1932,0x1132,0x1133,0x1134,0x0954,0x0976,0x09D8,0x01D8,0x01D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FB,0x01FB,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01D9,0x09F9,0x09D8,0x09D7,0x11B6,0x1174,0x1952,0x1952,0x2131,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2910,0x2910,0x212F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x210F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2110,0x210F,0x2110,0x2130,0x2130,0x1931,0x1112,0x1133,0x19D6,0x1A18,0x19D7,0x19B6,0x1133,0x1932,0x2131,0x2110,0x2130,0x2130,0x212F,0x292F,0x292F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2131,0x1911,0x1132,0x0953,0x19D6,0x19F7,0x19D6,0x19B5,0x1174,0x1112,0x1931,0x2130,0x2930,0x290F,0x292F,0x292F,0x290F,0x292F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1931,0x1911,0x1932,0x1932,0x1932,0x1932,0x1952,0x1932,0x2132,0x1911,0x2131,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x212F,0x210F,0x2930,0x212F,0x2930,0x210F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2110,0x2110,0x2910,0x210F,0x210F,0x290F,0x210F,0x2930,0x212F,0x212F,0x210F,0x292F,0x292F,0x210F,0x2110,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x210F,0x292F,0x210F,0x212F,0x2130,0x2951,0x2151,0x1931,0x1111,0x1132,0x0933,0x19B5,0x21F7,0x2217,0x19D6,0x1995,0x1153,0x1132,0x1931,0x1911,0x1931,0x1910,0x1910,0x2130,0x210F,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2930,0x2110,0x2131,0x1932,0x1112,0x1153,0x19B5,0x21F7,0x2218,0x19D7,0x1996,0x1154,0x1133,0x1932,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x2110,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x1930,0x2151,0x1932,0x1112,0x19D7,0x1A18,0x19F8,0x19B7,0x08F2,0x1931,0x2111,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2910,0x210F,0x2110,0x210F,0x2910,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2930,0x2110,0x210F,0x2910,0x2910,0x2110,0x2910,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x2930,0x2930,0x210F,0x210F,0x2110,0x2930,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x08F2,0x21B5,0x2A17,0x2217,0x21D6,0x10F2,0x1112,0x2152,0x2151,0x2130,0x2110,0x210F,0x210F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x292F,0x2930,0x2130,0x210F,0x2130,0x2110,0x2130,0x2110,0x2131,0x2131,0x1932,0x1933,0x1133,0x1154,0x1995,0x21F7,0x2217,0x19D7,0x1195,0x1154,0x1133,0x1932,0x1932,0x2111,0x2110,0x2110,0x2110,0x2930,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x1910,0x1911,0x1931,0x1112,0x1154,0x21F7,0x21F7,0x2217,0x1153,0x1112,0x1912,0x2132,0x2131,0x2130,0x2130,0x2110,0x2110,0x2910,0x2910,0x2930,0x2930,0x290F,0x290F,0x2930,0x210F,0x290F,0x2910,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x2910,0x2930,0x210F,0x2910,0x2910,0x2910,0x2910,0x290F,0x2910,0x2910,0x2930,0x210F,0x290F,0x2930,0x210F,0x210F,0x292F,0x292F,0x210F,0x292F,0x292F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x1911,0x1911,0x1912,0x1932,0x1933,0x1954,0x1995,0x21D6,0x19B6,0x21D6,0x19B5,0x1154,0x1133,0x1112,0x1111,0x1131,0x1973,0x1993,0x1132,0x1133,0x0933,0x1154,0x19B6,0x19D7,0x21F7,0x19B6,0x1995,0x1133,0x1932,0x1911,0x2131,0x2130,0x2130,0x2930,0x2930,0x2130,0x2130,0x210F,0x210F,0x212F,0x2930,0x212F,0x210F,0x210F,0x210F,0x2110,0x210F,0x2110,0x2110,0x210F,0x2930,0x290F,0x290F,0x210F,0x210F,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x2930,0x2110,0x2930,0x2910,0x2910,0x210F,0x210F,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2130,0x210F,0x2130,0x210F,0x2110,0x1910,0x1911,0x1153,0x11B6,0x1A18,0x19F8,0x11D8,0x0996,0x0955,0x0954,0x0934,0x0934,0x0955,0x0955,0x11B7,0x11F8,0x1A19,0x19F8,0x0955,0x08F2,0x1911,0x2131,0x2130,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x210F,0x2930,0x2930,0x2930,0x2130,0x2130,0x212F,0x2130,0x2930,0x210F,0x2130,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2110,0x2111,0x2111,0x1911,0x1912,0x1933,0x1954,0x19B6,0x21F7,0x21F7,0x21F7,0x1995,0x1154,0x1113,0x1912,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x292F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2910,0x290F,0x290F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x292F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2950,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x1931,0x1931,0x1112,0x1132,0x1174,0x1995,0x19D6,0x21F7,0x19D6,0x19B6,0x1134,0x1112,0x1112,0x1131,0x1131,0x1951,0x1952,0x1932,0x1932,0x1133,0x1174,0x1996,0x19D7,0x21F7,0x21F7,0x19B6,0x1974,0x1133,0x1932,0x1911,0x1911,0x2131,0x2152,0x1952,0x1912,0x10F2,0x1954,0x1995,0x2218,0x2218,0x19D7,0x19B6,0x1154,0x1132,0x1931,0x2151,0x2130,0x2130,0x2130,0x212F,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2110,0x2130,0x2130,
  0x2131,0x2130,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x1910,0x1911,0x1132,0x1132,0x1174,0x19B6,0x2218,0x2218,0x19D7,0x1195,0x1133,0x1112,0x1912,0x2132,0x2131,0x2130,0x2910,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x210F,0x210F,0x210F,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x290F,0x290F,0x292F,0x290F,0x290F,0x292F,0x210F,0x292F,0x290F,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x2930,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x212F,0x212F,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x210F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x1912,0x1133,0x1A39,0x09F9,0x01B9,0x01DA,0x01FA,0x021A,0x01DA,0x01FA,0x01DA,0x01FB,0x01FB,0x021B,0x01FA,0x01FA,0x01FB,0x01FA,0x021A,0x01FA,0x01B9,0x0198,0x11F8,0x11F8,0x0996,0x1196,0x1196,0x1196,0x11B6,0x1196,0x1196,0x1196,0x1195,0x1195,0x11B5,0x1195,0x1195,0x11B5,0x1196,0x1196,0x11B6,0x1196,0x11B6,0x1195,0x1196,0x1196,0x1196,0x1195,0x1196,0x11B6,0x11B6,0x1195,0x1195,0x1195,0x11B5,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x1196,0x1196,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x19D6,0x11D6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x19D6,0x1195,0x1154,0x1153,0x1153,0x0933,0x0933,0x0933,0x1154,0x1175,0x11B6,0x19D6,0x19D7,0x11B6,0x11B5,0x1154,0x1133,0x1133,0x1132,0x1932,0x1932,0x1932,0x1911,0x1911,0x2132,0x1932,0x2132,0x2132,0x1932,0x1932,0x1932,0x1911,0x1931,0x1932,0x1911,0x1931,0x1931,0x1931,0x1931,0x1911,0x1932,0x1911,0x1931,0x1911,0x1911,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1911,0x1931,0x1931,0x1911,0x1931,0x1931,0x1932,0x1931,0x1931,0x1931,0x1932,0x1932,0x1931,0x1931,0x1931,0x1932,0x1952,0x1132,0x1133,0x0934,0x0955,0x09B7,0x09F9,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x0A1A,0x09F9,0x09D7,0x11B6,0x1195,0x1132,0x1932,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2930,0x2930,0x2930,0x210F,0x210F,0x290F,0x290F,0x2910,0x2930,0x2930,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2930,0x210F,0x2910,0x2930,0x2910,0x290F,0x290F,0x2910,0x2910,0x210F,0x210F,0x2910,0x2930,0x210F,0x210F,0x2930,0x2930,0x290F,0x2930,0x2930,0x290F,0x290F,0x2910,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2130,0x1931,0x1912,0x0913,0x19D6,0x1A18,0x19D7,0x1196,0x1133,0x1932,0x1931,0x2130,0x2130,0x2130,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x1910,0x1911,0x1132,0x1154,0x19D6,0x19F6,0x19D6,0x19B5,0x1173,0x1112,0x1931,0x2130,0x2930,0x2930,0x292F,0x290F,0x290F,0x290F,0x2130,0x2110,0x2130,0x2131,0x1931,0x1931,0x1932,0x1932,0x1132,0x1132,0x1133,0x1133,0x1953,0x1953,0x1953,0x1952,0x1932,0x1931,0x1911,0x2111,0x2131,0x2130,0x2110,0x2110,0x2130,0x210F,0x290F,0x210F,0x2930,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x2930,0x2930,0x290F,0x2910,0x2910,0x210F,0x210F,0x2910,0x2930,0x210F,0x2930,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x290F,0x290F,0x210F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x2930,0x212F,0x2930,0x2930,0x2130,0x2930,0x212F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2150,0x2131,0x1951,0x1132,0x0912,0x1153,0x19B5,0x19F7,0x2217,0x21F6,0x19B5,0x1133,0x1112,0x1131,0x1911,0x1910,0x2130,0x2130,0x2130,0x210F,0x2130,0x212F,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2131,0x1931,0x1112,0x1954,0x1995,0x21F7,0x2A38,0x21F7,0x1995,0x1154,0x1133,0x1132,0x1911,0x1911,0x2131,0x2131,0x2131,0x2130,0x2110,0x210F,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2131,0x1911,0x1112,0x19D7,0x1A18,0x1A19,0x19B7,0x08F2,0x1911,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2930,0x210F,0x2110,0x2910,0x2110,0x2910,0x2910,0x2930,0x210F,0x290F,0x210F,0x290F,0x290F,0x2930,0x210F,0x2110,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x292F,0x292F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2131,0x2152,0x1111,0x10F2,0x21B5,0x2A17,0x21F7,0x21B6,0x1112,0x1912,0x2132,0x2131,0x2131,0x2930,0x2930,0x210F,0x210F,0x2910,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,0x290F,0x290F,0x210F,0x210F,0x2110,0x2130,0x2110,0x2110,0x2130,0x2131,0x2131,0x1932,0x1112,0x1112,0x1174,0x19B5,0x21F7,0x21F7,0x19D6,0x1195,0x1154,0x1112,0x1112,0x1931,0x1911,0x2131,0x2110,0x210F,0x210F,0x210F,0x20EF,0x210F,0x2130,0x2130,0x210F,0x2130,0x1931,0x1931,0x1112,0x1133,0x21D6,0x21F7,0x2A17,0x1974,0x1112,0x1912,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2910,0x2110,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x210F,0x2910,0x2110,0x2930,0x210F,0x2110,0x2110,0x2910,0x2930,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x292F,0x292F,0x2930,0x2930,0x210F,0x210F,0x210F,0x2130,0x2110,0x2110,0x1911,0x1931,0x1932,0x1932,0x1932,0x1953,0x1974,0x1995,0x21D6,0x21F7,0x21D6,0x21D6,0x1954,0x1112,0x10F1,0x1111,0x1952,0x2173,0x1952,0x1132,0x0912,0x1133,0x1174,0x19B6,0x19D6,0x21F7,0x19B6,0x19B5,0x1954,0x1112,0x1911,0x1911,0x2131,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x2930,0x212F,0x292F,0x292F,0x212F,0x212F,0x210F,0x2110,0x2910,0x210F,0x210F,0x2930,0x2930,0x290F,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x210F,0x2930,0x210F,0x2910,0x210F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2110,0x2110,0x1931,0x1153,0x19B6,0x19F7,0x11D8,0x11D8,0x0975,0x0955,0x0954,0x0954,0x0934,0x0934,0x0955,0x0996,0x11D8,0x11F8,0x19F8,0x0955,0x08F2,0x1932,0x2131,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x210F,0x2130,0x212F,0x2130,0x2130,0x212F,0x292F,0x210F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2131,0x2131,0x2131,0x1911,0x1912,0x1953,0x1954,0x21D6,0x21F7,0x21F7,0x21F6,0x19B6,0x1154,0x1112,0x1112,0x1911,0x2131,0x2130,0x2130,0x2130,0x2930,0x212F,0x210F,0x292F,0x210F,0x210F,0x290F,0x210F,0x2110,0x210F,0x2110,0x210F,0x212F,0x292F,0x290F,0x290F,0x292F,0x292F,0x210F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2131,0x1931,0x1911,0x1132,0x1154,0x1995,0x19D6,0x19D7,0x19B6,0x19B6,0x1974,0x1112,0x1111,0x1111,0x1131,0x1931,0x1951,0x1952,0x1132,0x1132,0x1154,0x1995,0x19B6,0x19F7,0x21F7,0x19B6,0x1975,0x1133,0x1112,0x1911,0x1911,0x1931,0x2152,0x1952,0x1112,0x1112,0x1133,0x1995,0x21F7,0x2218,0x21F7,0x19B6,0x1174,0x1132,0x1111,0x1931,0x2130,0x2130,0x2130,0x2930,0x212F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,
  0x1931,0x2131,0x2131,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2131,0x1931,0x1132,0x1133,0x1174,0x11B6,0x1A17,0x2218,0x19F7,0x1195,0x1133,0x1133,0x1932,0x2131,0x2131,0x2110,0x2910,0x2110,0x210F,0x2110,0x2130,0x2110,0x2130,0x2110,0x210F,0x2930,0x210F,0x290F,0x290F,0x2930,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2130,0x2130,0x2130,0x212F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2110,0x2910,0x2910,0x2930,0x2930,0x2110,0x2910,0x2910,0x2910,0x210F,0x2910,0x2910,0x2930,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x290F,0x210F,0x2130,0x212F,0x2130,0x210F,0x2930,0x210F,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2110,0x2130,0x2130,0x2130,0x2131,0x2111,0x1911,0x1912,0x0913,0x1A39,0x09F9,0x01D9,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FB,0x01FB,0x01DB,0x01FB,0x01DA,0x01FB,0x01FB,0x01FA,0x01FA,0x09DA,0x01B9,0x1219,0x1219,0x1219,0x1218,0x1A18,0x1A39,0x1A39,0x1A39,0x1A39,0x2239,0x2239,0x2238,0x2238,0x2258,0x2238,0x2238,0x2259,0x2239,0x2239,0x2238,0x2239,0x2239,0x2239,0x2239,0x2259,0x2238,0x2239,0x2239,0x2259,0x2259,0x2238,0x2238,0x2239,0x2239,0x2239,0x2239,0x2259,0x2259,0x2238,0x2239,0x2259,0x2238,0x2239,0x2259,0x2259,0x2238,0x2238,0x1A18,0x2238,0x1A38,0x1A18,0x1A18,0x1A18,0x1A38,0x1A38,0x1A17,0x11B6,0x1195,0x1154,0x1153,0x0932,0x0933,0x0933,0x1154,0x1195,0x19D6,0x19D6,0x19D7,0x19D6,0x1195,0x1154,0x1133,0x1132,0x1132,0x1911,0x1932,0x1911,0x1932,0x2132,0x1911,0x2132,0x1911,0x1932,0x1932,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x2131,0x1931,0x1911,0x1931,0x1931,0x1931,0x2131,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1132,0x1112,0x0934,0x0955,0x09B7,0x01D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DB,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x09F9,0x09F9,0x09F8,0x11B7,0x1195,0x1153,0x1932,0x2131,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x210F,0x2930,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2910,0x210F,0x290F,0x2930,0x2910,0x2910,0x290F,0x290F,0x2910,0x2910,0x2930,0x2930,0x210F,0x2930,0x2910,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x2110,0x2130,0x2110,0x2110,0x2130,0x1931,0x1932,0x0912,0x19D6,0x1A18,0x11D7,0x19B6,0x1133,0x1912,0x1931,0x2130,0x2130,0x2130,0x212F,0x292F,0x294F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x1911,0x1132,0x1154,0x19D6,0x19F6,0x19D6,0x19D5,0x1173,0x1111,0x1931,0x2130,0x2930,0x2930,0x292F,0x292F,0x290F,0x2930,0x2930,0x2130,0x2130,0x2131,0x1931,0x1932,0x1153,0x1133,0x1154,0x1174,0x1175,0x1175,0x1154,0x0934,0x1133,0x1133,0x1133,0x1932,0x1932,0x2131,0x2131,0x2130,0x2110,0x2110,0x2130,0x212F,0x210F,0x210F,0x212F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2910,0x210F,0x2910,0x2910,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x2130,0x210F,0x2130,0x210F,0x212F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x2930,0x2930,0x212F,0x210F,0x210F,0x212F,0x2950,0x2951,0x2151,0x1931,0x1111,0x1112,0x0933,0x19B5,0x21F7,0x2218,0x19F6,0x19B5,0x1154,0x1112,0x1111,0x1911,0x1910,0x1910,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2130,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1932,0x1153,0x19B5,0x21F7,0x2218,0x21F7,0x1995,0x1174,0x1133,0x1932,0x1911,0x1911,0x1910,0x1930,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2150,0x1931,0x1911,0x1113,0x19D7,0x1A18,0x1A19,0x19B7,0x08F2,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x2910,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x2930,0x290F,0x2930,0x2910,0x2930,0x2930,0x210F,0x2930,0x210F,0x2910,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2930,0x2110,0x2130,0x2130,0x2151,0x2132,0x1911,0x10F1,0x21B5,0x2A17,0x21F7,0x21B6,0x1113,0x1912,0x2132,0x2131,0x2131,0x2110,0x2110,0x2110,0x210F,0x2910,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x290F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1911,0x1932,0x1132,0x1174,0x1995,0x19D6,0x2218,0x2217,0x19B6,0x1154,0x1112,0x1912,0x1931,0x2131,0x2130,0x210F,0x2930,0x2130,0x210F,0x210F,0x2950,0x2150,0x190F,0x2150,0x2151,0x1911,0x1112,0x1133,0x19B6,0x21F7,0x2A17,0x1974,0x1112,0x1932,0x1931,0x2131,0x2130,0x2110,0x2130,0x2130,0x210F,0x2930,0x2930,0x2930,0x290F,0x210F,0x210F,0x290F,0x2910,0x2930,0x2910,0x2910,0x2110,0x210F,0x2110,0x2910,0x210F,0x2910,0x290F,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2930,0x2930,0x290F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2930,0x2130,0x2130,0x2131,0x2131,0x1911,0x1911,0x1932,0x1933,0x1153,0x1974,0x1995,0x19D6,0x21D6,0x19B6,0x19B5,0x1953,0x1132,0x1111,0x1111,0x1952,0x1952,0x1111,0x1132,0x1133,0x1133,0x1995,0x1995,0x19B6,0x2217,0x21F7,0x19B5,0x1154,0x1112,0x1111,0x1911,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2930,0x2930,0x292F,0x292F,0x212F,0x2930,0x210F,0x2930,0x290F,0x290F,0x210F,0x212F,0x210F,0x210F,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x210F,0x210F,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x1931,0x1932,0x1174,0x19D7,0x11D7,0x11D7,0x11B6,0x0975,0x0134,0x0955,0x0934,0x0114,0x0135,0x0997,0x11B8,0x11D8,0x11D8,0x1175,0x08F2,0x1911,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2150,0x212F,0x2130,0x212F,0x210F,0x210F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x1911,0x1912,0x1953,0x1954,0x19B5,0x21F7,0x21F7,0x21F7,0x1995,0x1154,0x1112,0x1912,0x1931,0x2131,0x2150,0x2130,0x212F,0x212F,0x210F,0x292F,0x292F,0x210F,0x210F,0x2910,0x2910,0x210F,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x292F,0x210F,0x210F,0x292F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x1931,0x1112,0x1953,0x1995,0x19D6,0x21F7,0x19D6,0x19D6,0x1974,0x1133,0x1112,0x10F1,0x1111,0x1931,0x1931,0x1931,0x1132,0x1132,0x1153,0x1995,0x19B6,0x19D7,0x21F7,0x19B6,0x1975,0x1133,0x1912,0x1912,0x10F1,0x1931,0x1952,0x1952,0x1132,0x1112,0x1154,0x1995,0x21F7,0x2217,0x21F7,0x19B6,0x1974,0x1132,0x1112,0x1911,0x2131,0x2130,0x2130,0x2130,0x212F,0x292F,0x290F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x292F,0x292F,0x2930,
  0x1911,0x1931,0x2131,0x1911,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2131,0x2131,0x1931,0x1111,0x1133,0x1174,0x19D6,0x19F7,0x2218,0x19F7,0x1175,0x1133,0x1112,0x1932,0x2131,0x2131,0x2910,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x210F,0x290F,0x210F,0x210F,0x210F,0x290F,0x2910,0x2910,0x210F,0x2930,0x2110,0x2110,0x2110,0x2130,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2130,0x2110,0x2910,0x2110,0x2110,0x2910,0x2910,0x2930,0x2910,0x2910,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x2910,0x2910,0x2930,0x290F,0x210F,0x210F,0x290F,0x2930,0x290F,0x210F,0x212F,0x210F,0x212F,0x292F,0x210F,0x210F,0x2930,0x292F,0x212F,0x210F,0x292F,0x292F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2131,0x2111,0x1911,0x1912,0x1133,0x2239,0x0A19,0x01B9,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FB,0x021B,0x01FB,0x01DA,0x01FB,0x01DA,0x01FA,0x01FA,0x01DA,0x09DA,0x09D9,0x1219,0x11F8,0x11D8,0x11D8,0x11D8,0x19F8,0x19F8,0x1A18,0x19F8,0x19F8,0x19F7,0x19F7,0x1A17,0x19F7,0x19F7,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x2218,0x19F8,0x2218,0x19F8,0x19F7,0x19F7,0x19D7,0x19F7,0x2218,0x19F7,0x19F8,0x19F8,0x19F8,0x19F7,0x19D7,0x19F8,0x19F8,0x19F8,0x19F7,0x19F7,0x19D7,0x19D7,0x19D7,0x19F7,0x19F7,0x19F7,0x1A18,0x1A18,0x1A18,0x1A17,0x19F7,0x11D7,0x11B6,0x11B6,0x1195,0x1174,0x0933,0x0933,0x0933,0x0933,0x0954,0x1195,0x19D7,0x19F7,0x19D6,0x11B6,0x1195,0x1154,0x1132,0x1132,0x1112,0x1932,0x1932,0x1911,0x1932,0x1931,0x1911,0x1931,0x1911,0x18F1,0x1911,0x1931,0x1911,0x1932,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x1931,0x1931,0x1931,0x2152,0x1931,0x1931,0x2131,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x2131,0x2131,0x1931,0x1911,0x1931,0x1911,0x2131,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1132,0x1132,0x0934,0x0955,0x09B7,0x01D9,0x01DA,0x01DA,0x01DA,0x01BA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01FB,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01F9,0x09F9,0x11F9,0x11F8,0x19D6,0x1133,0x1932,0x1931,0x2131,0x2110,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x212F,0x212F,0x210F,0x2110,0x2930,0x2110,0x2910,0x2110,0x2930,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2930,0x210F,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2110,0x210F,0x2110,0x2130,0x2110,0x2130,0x1931,0x1932,0x1133,0x19D7,0x1A18,0x19D7,0x19B6,0x1133,0x1111,0x1931,0x2110,0x2130,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2150,0x2131,0x1911,0x1132,0x1154,0x19D6,0x19F7,0x19D6,0x19B5,0x1973,0x1112,0x1931,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2131,0x1931,0x1132,0x1133,0x1174,0x19D6,0x2238,0x1A18,0x2238,0x2258,0x2258,0x2238,0x1A17,0x19D6,0x1195,0x1154,0x1112,0x1932,0x2131,0x2131,0x2130,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x290F,0x2910,0x2910,0x2930,0x210F,0x210F,0x290F,0x2930,0x290F,0x290F,0x210F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x210F,0x210F,0x2130,0x212F,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x2910,0x2930,0x2930,0x290F,0x2930,0x2130,0x2110,0x2151,0x2151,0x1911,0x1111,0x1112,0x1133,0x19B5,0x2217,0x2217,0x21F7,0x19B5,0x1153,0x1132,0x1111,0x1911,0x1910,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x2130,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x1910,0x1911,0x1912,0x1933,0x21B5,0x21F7,0x2217,0x21F7,0x1995,0x1174,0x1133,0x1132,0x1952,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x2950,0x212F,0x212F,0x212F,0x2130,0x2131,0x1932,0x1113,0x19D7,0x19F8,0x1A19,0x19D7,0x08F2,0x1912,0x2151,0x2131,0x2130,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x2930,0x290F,0x2910,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x292F,0x2930,0x2910,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x2930,0x2130,0x2930,0x2110,0x2110,0x2110,0x2130,0x2131,0x2152,0x1912,0x1112,0x21B5,0x2A17,0x21F7,0x21B6,0x1113,0x1912,0x1932,0x2131,0x2931,0x2110,0x2910,0x210F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2130,0x212F,0x212F,0x210F,0x292F,0x292F,0x292F,0x292F,0x290F,0x212F,0x210F,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x1912,0x1112,0x1154,0x11B5,0x2237,0x2238,0x2238,0x19B5,0x0933,0x1112,0x1932,0x1931,0x2130,0x2110,0x2130,0x2130,0x210F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2151,0x1931,0x1111,0x1133,0x19B5,0x2217,0x2217,0x1994,0x1112,0x1932,0x1931,0x2131,0x2110,0x2130,0x2110,0x2130,0x2110,0x2930,0x2930,0x212F,0x210F,0x290F,0x212F,0x210F,0x210F,0x210F,0x2910,0x2930,0x2910,0x2110,0x2110,0x2110,0x2930,0x2930,0x290F,0x210F,0x2110,0x2910,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x210F,0x2930,0x212F,0x2930,0x2110,0x2110,0x2930,0x2930,0x210F,0x210F,0x2910,0x2110,0x2130,0x2110,0x2131,0x2151,0x2131,0x1931,0x1911,0x1932,0x1953,0x1953,0x1954,0x1995,0x21D6,0x21D6,0x19B6,0x19B5,0x1953,0x1112,0x1111,0x1931,0x2172,0x1932,0x1932,0x1112,0x1132,0x1133,0x1174,0x1995,0x21F7,0x2217,0x19D6,0x19B6,0x1974,0x1112,0x18F1,0x2111,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x2930,0x210F,0x292F,0x292F,0x2930,0x290F,0x210F,0x290F,0x210F,0x210F,0x212F,0x2930,0x2110,0x210F,0x2930,0x2930,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x2910,0x210F,0x2910,0x2930,0x2110,0x2110,0x2910,0x2930,0x210F,0x210F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2110,0x2930,0x210F,0x2110,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2930,0x2110,0x2110,0x2110,0x1910,0x1932,0x1174,0x11B6,0x11B7,0x19F7,0x11F7,0x19F7,0x11B6,0x0996,0x0976,0x0976,0x09B7,0x11D8,0x0997,0x11B8,0x19D8,0x0975,0x08F2,0x1111,0x1911,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2930,0x212F,0x210F,0x290F,0x2930,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1931,0x1912,0x1933,0x1974,0x19B5,0x21F7,0x21F7,0x21F7,0x1995,0x1154,0x1112,0x1911,0x2151,0x2131,0x2951,0x2130,0x2130,0x212F,0x292F,0x292F,0x292F,0x290F,0x290F,0x210F,0x2110,0x2110,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x292F,0x210F,0x292F,0x292F,0x2930,0x2930,0x2130,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1931,0x1132,0x1953,0x1154,0x1995,0x21F7,0x21F7,0x19B5,0x1974,0x1153,0x1132,0x1111,0x1911,0x1951,0x1952,0x1111,0x1111,0x1132,0x1153,0x1195,0x19D6,0x19D7,0x19D7,0x19B6,0x1975,0x1133,0x1912,0x1912,0x1912,0x1911,0x1931,0x1952,0x1932,0x1132,0x0933,0x19B5,0x2217,0x2218,0x2217,0x19B6,0x1154,0x1133,0x1112,0x1911,0x2131,0x2130,0x2130,0x2130,0x212F,0x210F,0x290F,0x292F,0x292F,0x210F,0x210F,0x292F,0x292F,0x212F,0x210F,0x210F,0x210F,0x292F,0x292F,0x292F,0x292F,
  0x1932,0x1932,0x1932,0x1931,0x2111,0x2110,0x2130,0x2110,0x2930,0x2930,0x2130,0x2130,0x2110,0x2131,0x1931,0x1112,0x1133,0x1174,0x19B6,0x19F7,0x2218,0x19D7,0x1996,0x1134,0x1112,0x1912,0x2131,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x290F,0x210F,0x210F,0x212F,0x210F,0x290F,0x2930,0x290F,0x2930,0x2930,0x2110,0x2930,0x2110,0x2110,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x2910,0x290F,0x2930,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x2930,0x210F,0x292F,0x292F,0x210F,0x292F,0x290F,0x292F,0x290F,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x2131,0x2110,0x1911,0x1912,0x0913,0x1A38,0x0A19,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01FB,0x01FB,0x01FB,0x01FB,0x01FB,0x01FB,0x01FB,0x01DA,0x01FA,0x01DA,0x01D9,0x09D9,0x09D8,0x09B7,0x0996,0x1196,0x11B6,0x1196,0x11B6,0x1196,0x1195,0x11B6,0x1195,0x1195,0x1195,0x1195,0x1195,0x1995,0x1175,0x1195,0x1195,0x1175,0x1196,0x1196,0x1195,0x1995,0x1995,0x1195,0x1195,0x1995,0x1175,0x1195,0x1195,0x1175,0x1995,0x1175,0x1175,0x1175,0x1175,0x1195,0x1175,0x1195,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1975,0x1175,0x1175,0x1175,0x1195,0x1195,0x1195,0x11B6,0x11B5,0x11B6,0x11D6,0x11D6,0x19F7,0x11B6,0x19B5,0x1174,0x1153,0x0933,0x0913,0x0933,0x0954,0x1195,0x19D6,0x19D6,0x19F7,0x11B6,0x11B5,0x1174,0x1153,0x1132,0x1132,0x1132,0x1132,0x1932,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1932,0x1912,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1952,0x1932,0x1932,0x1932,0x1932,0x1932,0x1931,0x1932,0x1932,0x1932,0x1932,0x1931,0x1932,0x1932,0x1932,0x1932,0x1931,0x1932,0x1932,0x1932,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1132,0x1132,0x1133,0x0934,0x0155,0x09B7,0x01D9,0x01FA,0x01DA,0x01DA,0x01BA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DB,0x01DA,0x01DA,0x01DA,0x01DA,0x01FB,0x01DB,0x01DA,0x01DA,0x01DB,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DB,0x01DB,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01F9,0x09F9,0x09F9,0x11D7,0x11B6,0x1974,0x1111,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x212F,0x212F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2910,0x2910,0x290F,0x2930,0x2910,0x2910,0x290F,0x292F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x2910,0x2930,0x290F,0x2930,0x210F,0x290F,0x290F,0x2910,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x1911,0x1932,0x1133,0x19D6,0x19F8,0x19D7,0x19B6,0x1133,0x1932,0x1931,0x2110,0x2130,0x2930,0x212F,0x292F,0x212F,0x294F,0x292F,0x212F,0x212F,0x2130,0x2131,0x1931,0x1132,0x1154,0x19D6,0x19F7,0x19B6,0x19B5,0x1953,0x1112,0x1931,0x2131,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2130,0x2131,0x2131,0x1932,0x1133,0x1995,0x11B6,0x19F8,0x1218,0x11D7,0x11F8,0x09D7,0x09D8,0x11F8,0x1A38,0x1A38,0x1A18,0x21F7,0x1174,0x1933,0x1932,0x2111,0x2130,0x2110,0x2110,0x2130,0x210F,0x2110,0x2110,0x210F,0x290F,0x290F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2930,0x290F,0x2910,0x290F,0x290F,0x2930,0x2910,0x290F,0x290F,0x2930,0x290F,0x290F,0x2930,0x2910,0x2910,0x2910,0x290F,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x2910,0x210F,0x210F,0x2910,0x2930,0x2930,0x2130,0x2130,0x2151,0x2131,0x10F1,0x1112,0x1133,0x1995,0x21F7,0x2217,0x21F7,0x1995,0x1133,0x1112,0x1111,0x1931,0x1930,0x1910,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2150,0x2130,0x2110,0x2131,0x1931,0x1911,0x1112,0x1953,0x21B5,0x21F7,0x2217,0x21F7,0x19B5,0x1154,0x1133,0x1932,0x1931,0x1931,0x1931,0x2130,0x2130,0x2110,0x2110,0x2130,0x210F,0x2150,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2151,0x1911,0x1113,0x19D7,0x19F9,0x19F9,0x19D7,0x08F2,0x1932,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x212F,0x212F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2910,0x2910,0x2930,0x212F,0x292F,0x290F,0x210F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x292F,0x292F,0x292F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x2131,0x2132,0x1912,0x10F2,0x21B6,0x2A17,0x21F7,0x21B6,0x1113,0x1912,0x1932,0x2111,0x2110,0x2110,0x2910,0x2110,0x290F,0x2910,0x2930,0x2110,0x2110,0x2130,0x212F,0x212F,0x210F,0x292F,0x210F,0x292F,0x292F,0x292F,0x292F,0x212F,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x1931,0x1111,0x1132,0x1174,0x11B5,0x2238,0x2218,0x19F7,0x19B5,0x1133,0x1132,0x1932,0x1931,0x2110,0x2130,0x2130,0x210F,0x210F,0x2110,0x2130,0x210F,0x1910,0x2131,0x1931,0x1112,0x1132,0x19B5,0x2217,0x2217,0x19B5,0x1112,0x1932,0x1931,0x2131,0x2131,0x2110,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x2930,0x290F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2110,0x2910,0x210F,0x2110,0x210F,0x210F,0x290F,0x290F,0x210F,0x2910,0x290F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2110,0x210F,0x2910,0x210F,0x212F,0x290F,0x210F,0x2910,0x2110,0x2930,0x2130,0x2131,0x2131,0x2151,0x2131,0x1931,0x1952,0x1932,0x1932,0x1953,0x1953,0x1995,0x21D6,0x21D6,0x21D6,0x21B5,0x1953,0x1132,0x1131,0x1972,0x1952,0x1932,0x1932,0x1112,0x1112,0x1953,0x1174,0x19B5,0x2238,0x19D6,0x19D7,0x21D6,0x1154,0x1112,0x1911,0x2110,0x2110,0x2110,0x2130,0x210F,0x212F,0x210F,0x210F,0x212F,0x292F,0x2930,0x290F,0x210F,0x2930,0x212F,0x210F,0x212F,0x2930,0x2110,0x2110,0x2930,0x2910,0x2910,0x2910,0x2110,0x2930,0x2910,0x2910,0x2910,0x2930,0x2910,0x2930,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x210F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x210F,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2110,0x1910,0x1931,0x1153,0x1174,0x19B6,0x19F7,0x19F7,0x1A18,0x1A17,0x19F7,0x11B7,0x11D8,0x11F8,0x11F8,0x11D8,0x11B8,0x11D8,0x0975,0x08F2,0x1111,0x1911,0x2131,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x292F,0x292F,0x290F,0x2930,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2150,0x2130,0x2131,0x1911,0x1932,0x1953,0x1174,0x19D6,0x21F7,0x21F7,0x21F7,0x19B5,0x1154,0x1112,0x1912,0x2131,0x2131,0x2130,0x2130,0x2130,0x292F,0x292F,0x292F,0x292F,0x290F,0x2930,0x210F,0x2130,0x212F,0x210F,0x212F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2131,0x1932,0x1133,0x1174,0x19B5,0x19D6,0x21F6,0x21D6,0x1974,0x1153,0x1132,0x1111,0x10F1,0x1931,0x1952,0x1931,0x1111,0x1112,0x1153,0x1195,0x19D6,0x19D7,0x19D7,0x21D7,0x1975,0x1934,0x1912,0x1912,0x1912,0x1912,0x1932,0x1952,0x1932,0x1112,0x1133,0x1195,0x21F7,0x2238,0x2217,0x21D6,0x1154,0x1113,0x1112,0x1911,0x2131,0x2131,0x2130,0x2130,0x2130,0x2930,0x210F,0x292F,0x292F,0x290F,0x290F,0x2930,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,
  0x1994,0x1133,0x1953,0x1932,0x1911,0x2131,0x2130,0x2130,0x2130,0x2930,0x2110,0x2110,0x2110,0x2131,0x2131,0x1911,0x1111,0x1133,0x1195,0x19D6,0x19F7,0x19F7,0x21F7,0x1996,0x1134,0x1112,0x1912,0x2131,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x210F,0x2930,0x210F,0x212F,0x2930,0x292F,0x292F,0x290F,0x290F,0x2910,0x2110,0x2910,0x2910,0x2910,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x28EF,0x290F,0x290F,0x210F,0x2130,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2930,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x210F,0x290F,0x210F,0x212F,0x212F,0x290F,0x290F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2910,0x2910,0x2110,0x2130,0x2130,0x2131,0x2131,0x1911,0x1912,0x1133,0x1A18,0x1219,0x01B9,0x01DA,0x01DA,0x01DA,0x01FA,0x01FB,0x01DA,0x01FB,0x01FB,0x01DB,0x01FB,0x01FB,0x01BA,0x01BA,0x01DA,0x01D9,0x09D9,0x09D8,0x0976,0x0954,0x0954,0x0933,0x1153,0x1153,0x1153,0x1133,0x1133,0x1132,0x1132,0x1132,0x1152,0x1952,0x1132,0x1932,0x1133,0x1133,0x1133,0x1953,0x1133,0x1133,0x1133,0x1112,0x1133,0x1953,0x1933,0x1133,0x1133,0x1133,0x1132,0x1132,0x1933,0x1133,0x1133,0x1133,0x1133,0x1133,0x1132,0x1132,0x1133,0x1133,0x1133,0x1933,0x1112,0x1112,0x1112,0x1132,0x1132,0x1132,0x1133,0x1133,0x1153,0x1153,0x0913,0x1174,0x19F6,0x19F7,0x19F7,0x11D6,0x11B5,0x1174,0x0933,0x0913,0x0913,0x0933,0x1154,0x1175,0x19B6,0x19D7,0x19F7,0x11D6,0x1195,0x1174,0x1154,0x1153,0x0933,0x0932,0x1132,0x1112,0x1112,0x1132,0x1132,0x1112,0x1132,0x1132,0x1932,0x1132,0x1112,0x1112,0x1112,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1132,0x1132,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1132,0x1132,0x1112,0x1112,0x1932,0x1932,0x1112,0x1132,0x1132,0x1132,0x1132,0x1112,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1132,0x1132,0x1133,0x0933,0x0954,0x0176,0x01B8,0x01B9,0x01DA,0x01BA,0x01DA,0x01FB,0x01DA,0x01FA,0x01FB,0x01DA,0x01DA,0x01BA,0x01DA,0x01BA,0x01BA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DB,0x01DB,0x01DA,0x01DA,0x01DB,0x01DA,0x01DA,0x01DA,0x01FB,0x01DB,0x01DB,0x01DA,0x01FB,0x01FB,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01D9,0x01D9,0x01F9,0x09F9,0x09F9,0x09D7,0x19D6,0x1173,0x10F1,0x1911,0x2131,0x2130,0x2130,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2930,0x2930,0x210F,0x210F,0x2910,0x2910,0x210F,0x2930,0x290F,0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2130,0x2130,0x2131,0x1931,0x1932,0x0933,0x19D7,0x1A18,0x19F8,0x1196,0x1133,0x1911,0x2131,0x2131,0x2130,0x2130,0x212F,0x210F,0x212F,0x292F,0x212F,0x212F,0x2130,0x2130,0x1910,0x1911,0x1132,0x1174,0x19F6,0x19F7,0x19B5,0x19B5,0x1973,0x1111,0x1910,0x2110,0x2930,0x2930,0x2930,0x2910,0x2930,0x2130,0x2130,0x2110,0x1931,0x1932,0x1174,0x19D6,0x19F8,0x11D8,0x09B8,0x01B7,0x01B8,0x01B8,0x0197,0x01B8,0x09D8,0x09F8,0x11F8,0x11F7,0x19F7,0x1974,0x1932,0x2131,0x2131,0x2110,0x2130,0x2130,0x2110,0x2110,0x2930,0x210F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x2910,0x210F,0x210F,0x2930,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x292F,0x292F,0x290F,0x2110,0x210F,0x2110,0x2930,0x2930,0x2130,0x2131,0x2131,0x1111,0x1112,0x1132,0x1995,0x2217,0x2238,0x21F7,0x1995,0x1133,0x1112,0x1112,0x1911,0x1931,0x2131,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x214F,0x212F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x1111,0x1132,0x1153,0x1995,0x21F7,0x21F7,0x21F7,0x19B6,0x1133,0x1112,0x1932,0x1911,0x1931,0x2131,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1911,0x1113,0x19B7,0x1A19,0x1A19,0x19B7,0x10F3,0x1912,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2910,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2930,0x210F,0x290F,0x210F,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x210F,0x290F,0x292F,0x210F,0x210F,0x2930,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2130,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x2110,0x2130,0x2151,0x2132,0x1112,0x1113,0x21D6,0x21F7,0x2A17,0x21B6,0x1113,0x1932,0x1911,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x210F,0x2110,0x2130,0x2110,0x2110,0x212F,0x292F,0x292F,0x292F,0x212F,0x210F,0x292F,0x292F,0x292F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2110,0x2131,0x2131,0x1952,0x1132,0x1112,0x1153,0x11B5,0x1A17,0x2217,0x21F7,0x1995,0x1154,0x1112,0x1931,0x1910,0x2151,0x2930,0x2110,0x2110,0x2110,0x2950,0x210F,0x2110,0x1931,0x1931,0x1111,0x1112,0x19B5,0x2A37,0x21F6,0x1994,0x1112,0x1932,0x1952,0x1931,0x2131,0x2131,0x2130,0x2110,0x2110,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2910,0x210F,0x2930,0x2930,0x210F,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x290F,0x2930,0x2930,0x2930,0x210F,0x2110,0x2930,0x2130,0x2130,0x2131,0x2131,0x2131,0x1931,0x1951,0x1932,0x1932,0x1932,0x1953,0x1995,0x21D6,0x21D6,0x21F6,0x2195,0x1953,0x1112,0x1932,0x1952,0x1972,0x1932,0x1912,0x1112,0x1132,0x1133,0x1174,0x19B6,0x19B6,0x19D7,0x2218,0x19D6,0x1133,0x1912,0x1911,0x2110,0x2930,0x2930,0x2130,0x212F,0x210F,0x210F,0x2930,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2110,0x2910,0x2930,0x2110,0x2910,0x2110,0x2910,0x2930,0x210F,0x212F,0x2930,0x210F,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x1911,0x1932,0x1153,0x1174,0x11B6,0x19F7,0x19F7,0x19F7,0x19F7,0x19D7,0x11B7,0x11B7,0x19F8,0x1218,0x11F8,0x11D8,0x1196,0x0913,0x1112,0x10F1,0x1931,0x2151,0x2130,0x2130,0x2130,0x210F,0x212F,0x2130,0x210F,0x212F,0x2130,0x2130,0x2930,0x212F,0x212F,0x212F,0x292F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2110,0x2110,0x212F,0x210F,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2130,0x2131,0x1931,0x1932,0x1133,0x1974,0x19B5,0x21F7,0x2217,0x21F7,0x19B6,0x1154,0x1112,0x1111,0x1911,0x2131,0x2130,0x2130,0x2130,0x212F,0x292F,0x212F,0x292F,0x292F,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x2110,0x2930,0x210F,0x290F,0x292F,0x292F,0x210F,0x290F,0x210F,0x2930,0x2930,0x212F,0x2110,0x2110,0x2130,0x2130,0x2131,0x2151,0x2151,0x2132,0x1912,0x1132,0x1974,0x19B6,0x21F6,0x19D6,0x19B6,0x1995,0x1133,0x1132,0x10F1,0x10F0,0x1911,0x2152,0x1951,0x1111,0x1132,0x1133,0x1175,0x19F7,0x19D7,0x19D7,0x19D7,0x1995,0x1934,0x1933,0x1932,0x2132,0x1932,0x1932,0x1932,0x1132,0x1132,0x0933,0x1195,0x21F7,0x2217,0x19F7,0x19D6,0x1174,0x1113,0x10F2,0x1111,0x2151,0x2151,0x2130,0x210F,0x210F,0x210F,0x2930,0x2930,0x290F,0x2930,0x210F,0x2110,0x2930,0x2930,0x210F,0x212F,0x212F,0x292F,0x212F,0x292F,0x292F,0x292F,0x292F,
  0x21F6,0x1175,0x1154,0x1953,0x1932,0x1911,0x2131,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2131,0x2131,0x1111,0x1132,0x1133,0x1995,0x19B6,0x21F7,0x21F8,0x19D7,0x1996,0x1134,0x1933,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x292F,0x292F,0x290F,0x290F,0x2910,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x2910,0x2910,0x2910,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x292F,0x212F,0x210F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2930,0x2110,0x2910,0x2110,0x2130,0x2110,0x2130,0x2110,0x1910,0x1911,0x0912,0x19F7,0x1219,0x09D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DB,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01D9,0x01B8,0x09B8,0x09B7,0x0134,0x0913,0x0932,0x1132,0x1132,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1931,0x1911,0x1931,0x1932,0x1912,0x1912,0x1932,0x1911,0x1912,0x1932,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1112,0x1112,0x0933,0x1195,0x1A17,0x19F7,0x19D6,0x11D6,0x11B5,0x1174,0x1133,0x0913,0x0913,0x0934,0x0934,0x1175,0x19D7,0x19F7,0x19F7,0x11D6,0x11B6,0x1195,0x1195,0x0974,0x0953,0x0953,0x0953,0x0933,0x1153,0x1153,0x1153,0x1153,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x0932,0x1133,0x0933,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1132,0x1132,0x1132,0x1133,0x1153,0x1132,0x1133,0x1133,0x1153,0x0933,0x0933,0x0933,0x0933,0x0933,0x0933,0x0953,0x1153,0x1153,0x1153,0x1153,0x1174,0x1175,0x0976,0x09B7,0x09D8,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DB,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DB,0x01DB,0x01DB,0x01DB,0x01DB,0x01DB,0x01DA,0x01DA,0x01DA,0x01DA,0x01DB,0x01DB,0x01DB,0x01DA,0x01DA,0x01DA,0x01DB,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01D9,0x01D9,0x01D8,0x11F8,0x19F7,0x1174,0x1111,0x1931,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2110,0x2910,0x2930,0x2910,0x290F,0x2910,0x2910,0x290F,0x2930,0x210F,0x2930,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x292F,0x210F,0x290F,0x212F,0x2130,0x2110,0x2130,0x2130,0x1931,0x1932,0x0933,0x19D6,0x1A18,0x11D7,0x19B6,0x1133,0x1911,0x1931,0x2131,0x2110,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2131,0x1931,0x1132,0x1154,0x19D6,0x2217,0x19D6,0x19B5,0x1973,0x10F1,0x1931,0x2130,0x2930,0x2930,0x2930,0x2930,0x2110,0x2110,0x2130,0x2131,0x1931,0x1132,0x1154,0x11D7,0x11D8,0x09B8,0x01B8,0x01B8,0x01B8,0x01D9,0x01D9,0x01D9,0x01D9,0x09D9,0x09F8,0x09D8,0x11D7,0x1195,0x1132,0x1911,0x2111,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2910,0x2910,0x210F,0x2930,0x210F,0x210F,0x290F,0x210F,0x2910,0x2930,0x210F,0x2110,0x2110,0x2110,0x210F,0x2910,0x290F,0x210F,0x210F,0x212F,0x210F,0x290F,0x292F,0x292F,0x292F,0x290F,0x210F,0x290F,0x290F,0x2910,0x210F,0x2110,0x2110,0x2931,0x2131,0x2131,0x1911,0x10F1,0x1112,0x1174,0x2217,0x2217,0x2217,0x19B6,0x1134,0x1113,0x1112,0x1111,0x1931,0x1910,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2130,0x2131,0x1931,0x1911,0x1132,0x1154,0x1175,0x21F7,0x2218,0x21F7,0x19B6,0x1154,0x1133,0x1932,0x1911,0x1931,0x1910,0x2110,0x2130,0x2930,0x2130,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2131,0x1911,0x1113,0x19B7,0x19F9,0x19F9,0x19B7,0x08F2,0x1912,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2910,0x2910,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x210F,0x290F,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2930,0x2130,0x210F,0x210F,0x2130,0x2130,0x2131,0x1911,0x1112,0x1134,0x21F7,0x21F7,0x21F7,0x21B6,0x1133,0x1912,0x1931,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x210F,0x2930,0x2110,0x2110,0x2130,0x2130,0x292F,0x212F,0x210F,0x212F,0x212F,0x210F,0x292F,0x292F,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2131,0x2172,0x2152,0x1111,0x0912,0x0933,0x19D6,0x19F7,0x2217,0x19F7,0x1174,0x1153,0x1132,0x1911,0x2151,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2131,0x1931,0x1112,0x1112,0x19B5,0x2A17,0x21F6,0x1995,0x1112,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x2110,0x210F,0x2910,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2910,0x2110,0x2910,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2930,0x290F,0x2110,0x2110,0x2930,0x2110,0x2110,0x2910,0x2910,0x2910,0x2930,0x2930,0x290F,0x2930,0x212F,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x1930,0x1931,0x1931,0x1931,0x1932,0x1933,0x1953,0x1975,0x21D6,0x21D6,0x21D6,0x1995,0x1133,0x1132,0x1952,0x1952,0x1932,0x1932,0x1911,0x1932,0x1133,0x1153,0x1174,0x11B6,0x19D7,0x1A18,0x19F7,0x1995,0x1133,0x1911,0x2111,0x2110,0x2130,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x212F,0x212F,0x212F,0x292F,0x210F,0x212F,0x2110,0x2910,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x2930,0x2930,0x2910,0x2910,0x2910,0x210F,0x210F,0x212F,0x2110,0x2910,0x2110,0x2110,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x210F,0x2110,0x1910,0x1911,0x1132,0x1153,0x1174,0x1195,0x19B6,0x11B6,0x1196,0x1196,0x0976,0x0976,0x11B7,0x11F8,0x11F8,0x11F8,0x11D7,0x0954,0x0912,0x1112,0x1911,0x2131,0x2131,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2930,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x2930,0x2910,0x290F,0x292F,0x210F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2110,0x2110,0x2110,0x2131,0x2131,0x1932,0x1932,0x1133,0x1174,0x19D6,0x19F7,0x2217,0x21F7,0x19B5,0x1154,0x1112,0x1911,0x1911,0x2131,0x2130,0x2130,0x2130,0x2930,0x2930,0x212F,0x2930,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x2110,0x2130,0x210F,0x2130,0x210F,0x2930,0x2930,0x290F,0x2910,0x2930,0x2930,0x2110,0x2110,0x2130,0x2130,0x2131,0x2131,0x2132,0x1932,0x1932,0x1133,0x1954,0x19B5,0x19F6,0x19D6,0x19D6,0x1995,0x1154,0x1132,0x1111,0x1911,0x1910,0x1931,0x1931,0x1931,0x1132,0x1153,0x1194,0x19D6,0x19F7,0x19D7,0x19D7,0x1996,0x1954,0x1933,0x1912,0x1932,0x2132,0x1932,0x1932,0x1932,0x1132,0x1133,0x1175,0x21F7,0x2217,0x19F7,0x19D6,0x1154,0x1133,0x1112,0x1111,0x1931,0x2151,0x2951,0x2130,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x2110,0x210F,0x2110,0x2910,0x290F,0x210F,0x292F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,
  0x19F7,0x11D6,0x1195,0x1134,0x1132,0x1932,0x1911,0x2131,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2131,0x2151,0x1931,0x1911,0x1112,0x1133,0x1174,0x19B6,0x21D7,0x21F8,0x19D7,0x1995,0x1134,0x1113,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x292F,0x292F,0x292F,0x210F,0x210F,0x292F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2130,0x2930,0x2110,0x2930,0x2930,0x290F,0x210F,0x290F,0x290F,0x2930,0x2910,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x290F,0x210F,0x2910,0x2910,0x290F,0x290F,0x2930,0x2930,0x210F,0x210F,0x290F,0x290F,0x2930,0x212F,0x210F,0x290F,0x290F,0x292F,0x292F,0x210F,0x292F,0x290F,0x2910,0x2930,0x2910,0x2910,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x1910,0x1911,0x1953,0x19D7,0x1219,0x09D9,0x01D9,0x01B9,0x01D9,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01B9,0x01B9,0x01B8,0x09D8,0x11F8,0x11D7,0x0113,0x0932,0x1132,0x1131,0x1931,0x1931,0x1910,0x1910,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2131,0x1910,0x2131,0x1931,0x1911,0x1911,0x2131,0x2111,0x2131,0x1911,0x1911,0x2111,0x2131,0x1911,0x2131,0x2131,0x2110,0x1910,0x2111,0x2131,0x2131,0x1931,0x1910,0x2130,0x2131,0x2110,0x2131,0x1911,0x2131,0x2111,0x2131,0x1911,0x2131,0x1931,0x2131,0x2131,0x2131,0x1931,0x1931,0x1931,0x1932,0x1112,0x1153,0x1174,0x11B6,0x19D7,0x19F7,0x19D6,0x19D6,0x1154,0x0933,0x0933,0x0913,0x0934,0x0954,0x1175,0x11B6,0x19F7,0x19F7,0x19F7,0x11D6,0x11B6,0x11B6,0x11B5,0x11B5,0x11B5,0x11B5,0x1195,0x11B5,0x11B6,0x1195,0x1995,0x1995,0x1995,0x19B5,0x1995,0x1995,0x1995,0x19B5,0x1995,0x19B6,0x1995,0x19B5,0x1195,0x1995,0x1996,0x1195,0x1195,0x1996,0x1195,0x1195,0x11B5,0x1195,0x1195,0x11B5,0x1195,0x1995,0x1995,0x1195,0x1195,0x19B5,0x1995,0x19B5,0x19B5,0x19B5,0x19B5,0x19B5,0x1995,0x19B5,0x19B5,0x19B5,0x1995,0x19B5,0x19B5,0x19B5,0x11B5,0x19B5,0x19B5,0x19D5,0x19D5,0x19D5,0x19D5,0x19D5,0x19D6,0x19D5,0x19D5,0x19D6,0x11D6,0x11D7,0x09B7,0x09F8,0x01D9,0x01FA,0x01DA,0x01B9,0x01BA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01DB,0x01FB,0x01DB,0x01DB,0x01DA,0x01DA,0x01FB,0x01DA,0x01DB,0x01DA,0x01FB,0x01DA,0x01DB,0x01DA,0x01FB,0x01DA,0x01DB,0x01DA,0x01FB,0x01DA,0x01DB,0x01DB,0x01DA,0x01DA,0x01DA,0x01DA,0x01FB,0x01FB,0x01FB,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01F9,0x09F9,0x09F8,0x19F7,0x1174,0x1112,0x1911,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x210F,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2930,0x2910,0x2910,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x210F,0x2930,0x290F,0x210F,0x212F,0x210F,0x2110,0x2130,0x2130,0x1931,0x1932,0x0933,0x19F7,0x1A18,0x11D7,0x1196,0x1133,0x1932,0x2131,0x2110,0x2130,0x2130,0x210F,0x2930,0x210F,0x210F,0x292F,0x210F,0x2130,0x2130,0x2131,0x1931,0x1132,0x1154,0x19D6,0x19F7,0x11B5,0x19B5,0x1953,0x1111,0x1931,0x2131,0x2930,0x2930,0x2110,0x2110,0x2130,0x2130,0x2110,0x2131,0x1911,0x1132,0x1154,0x11D7,0x11D8,0x09B8,0x01B8,0x01D9,0x01FA,0x01D9,0x01FA,0x01F9,0x01F9,0x09F9,0x09F9,0x11F9,0x11F8,0x1175,0x1112,0x1911,0x2111,0x2110,0x2110,0x2110,0x2130,0x2930,0x2930,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x2910,0x290F,0x210F,0x2910,0x2930,0x2110,0x2930,0x2110,0x210F,0x210F,0x290F,0x2930,0x2930,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x290F,0x292F,0x212F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x2131,0x1111,0x1112,0x1174,0x21F7,0x2217,0x21F7,0x19B6,0x1154,0x0913,0x1112,0x1932,0x1931,0x2131,0x2110,0x2130,0x2130,0x2930,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2150,0x2130,0x2130,0x1910,0x1931,0x1112,0x1133,0x1974,0x1995,0x21F7,0x21F8,0x21F7,0x19B6,0x1154,0x1133,0x1932,0x1931,0x1931,0x2130,0x2130,0x2110,0x210F,0x2930,0x212F,0x2930,0x210F,0x212F,0x292F,0x210F,0x212F,0x2130,0x2110,0x210F,0x2130,0x2130,0x2130,0x210F,0x212F,0x2130,0x2131,0x1911,0x1112,0x19B7,0x1A19,0x19F9,0x19B7,0x10F2,0x1911,0x2131,0x2110,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x210F,0x210F,0x2110,0x2110,0x290F,0x290F,0x2910,0x290F,0x210F,0x2910,0x2910,0x2910,0x2110,0x210F,0x210F,0x210F,0x292F,0x290F,0x290F,0x290F,0x2910,0x2910,0x210F,0x2110,0x2930,0x2930,0x290F,0x210F,0x210F,0x212F,0x2930,0x2930,0x210F,0x210F,0x210F,0x292F,0x2930,0x2930,0x2130,0x2150,0x2131,0x1911,0x1112,0x1154,0x21D7,0x21F7,0x21F7,0x1995,0x1133,0x1932,0x1911,0x2110,0x2110,0x2930,0x2930,0x2930,0x210F,0x210F,0x2110,0x2130,0x2110,0x2130,0x2930,0x292F,0x210F,0x210F,0x210F,0x292F,0x210F,0x292F,0x292F,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x2130,0x2930,0x2110,0x20EF,0x2110,0x2130,0x2972,0x2172,0x1931,0x10F1,0x1132,0x1153,0x11B5,0x19F7,0x2217,0x19D6,0x1174,0x1132,0x1931,0x1931,0x2151,0x2130,0x2130,0x2110,0x2110,0x210F,0x1910,0x2131,0x1931,0x1932,0x1132,0x21D5,0x2A37,0x21F6,0x1994,0x1112,0x1111,0x1931,0x1931,0x2131,0x2130,0x2130,0x2130,0x2110,0x2910,0x2930,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x212F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x290F,0x210F,0x290F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2151,0x2131,0x1931,0x1931,0x1932,0x1932,0x1953,0x21B5,0x21F7,0x21F7,0x19B6,0x1994,0x1112,0x1132,0x1952,0x1952,0x1932,0x1931,0x1932,0x1932,0x1132,0x1153,0x1154,0x19D7,0x1A18,0x19F7,0x19B7,0x1134,0x1912,0x2111,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x2930,0x2930,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2910,0x2910,0x2110,0x2110,0x2930,0x2910,0x2910,0x2910,0x2110,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x2910,0x2930,0x2910,0x2910,0x210F,0x210F,0x210F,0x290F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x2130,0x2130,0x2131,0x1911,0x1912,0x1912,0x1133,0x1153,0x1174,0x1174,0x1174,0x1154,0x0955,0x0955,0x0956,0x11B7,0x11F8,0x11F8,0x19F8,0x11B6,0x0954,0x1113,0x10F1,0x1911,0x2131,0x2131,0x2110,0x2110,0x2130,0x2110,0x210F,0x2130,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x292F,0x212F,0x212F,0x292F,0x290F,0x290F,0x210F,0x210F,0x210F,0x292F,0x210F,0x292F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x2131,0x1911,0x1932,0x1133,0x1154,0x19B6,0x19F7,0x19F7,0x19F7,0x19B5,0x1153,0x1112,0x10F1,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x2110,0x2110,0x2130,0x2130,0x2131,0x2111,0x1911,0x1111,0x1932,0x1133,0x1974,0x19B6,0x19D6,0x19F6,0x19D6,0x1995,0x1133,0x1132,0x1932,0x1932,0x1931,0x1931,0x1931,0x1932,0x1132,0x1133,0x1174,0x19D6,0x19F7,0x19F7,0x19D7,0x1996,0x1154,0x1133,0x1112,0x1912,0x1912,0x1932,0x1932,0x1912,0x1133,0x1153,0x1175,0x21F7,0x2217,0x19F7,0x19B6,0x1154,0x1133,0x1112,0x1912,0x1931,0x2151,0x2151,0x2130,0x210F,0x210F,0x210F,0x2930,0x2930,0x290F,0x290F,0x210F,0x2930,0x2910,0x2910,0x210F,0x2910,0x210F,0x210F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,
  0x11F8,0x11D8,0x11B7,0x1175,0x1154,0x1132,0x1931,0x1931,0x2131,0x2110,0x2130,0x2930,0x2110,0x2130,0x2110,0x2131,0x2131,0x2131,0x1911,0x1112,0x1133,0x1154,0x19B6,0x19D7,0x21F8,0x21D7,0x1996,0x1154,0x1132,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x210F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2110,0x212F,0x2930,0x290F,0x290F,0x210F,0x290F,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2910,0x290F,0x290F,0x2910,0x2910,0x210F,0x290F,0x2110,0x210F,0x290F,0x210F,0x290F,0x292F,0x212F,0x2110,0x2110,0x290F,0x210F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x2910,0x2930,0x2110,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2110,0x1911,0x1911,0x1953,0x1175,0x1A18,0x09D8,0x09D9,0x01D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01D9,0x01B9,0x09D9,0x09F8,0x1A18,0x11B6,0x0933,0x1152,0x1131,0x1951,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2131,0x2131,0x2131,0x2110,0x2110,0x2110,0x2111,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2131,0x2130,0x2131,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1911,0x1911,0x1132,0x1133,0x1175,0x19D6,0x19F7,0x19F7,0x19D6,0x1996,0x1155,0x0934,0x0913,0x0913,0x0934,0x0954,0x1175,0x19B6,0x19F7,0x19F7,0x1A17,0x19F7,0x11F6,0x19F6,0x19F6,0x19F6,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x19D6,0x19D6,0x21F7,0x21F7,0x21F6,0x2217,0x21F7,0x21F7,0x21F7,0x21F7,0x21F7,0x2217,0x21F7,0x2217,0x21F7,0x2217,0x19F7,0x21F7,0x21F7,0x21F7,0x21F7,0x2217,0x2217,0x2217,0x21F7,0x2217,0x21F7,0x2217,0x2217,0x2217,0x2217,0x2217,0x21F7,0x2217,0x2217,0x2217,0x2217,0x2217,0x21F6,0x2217,0x2217,0x2217,0x2217,0x2217,0x2217,0x19F6,0x19F6,0x1A16,0x19F6,0x19F6,0x19F6,0x19F6,0x19F6,0x19F6,0x19F6,0x11D6,0x11D7,0x11D7,0x09D7,0x09D8,0x01D9,0x01D9,0x01B9,0x01B9,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01FB,0x01DA,0x01FB,0x01DA,0x01FB,0x01DA,0x01FB,0x01DA,0x01DB,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01D9,0x09F9,0x11F8,0x11D7,0x1175,0x1112,0x1911,0x2131,0x2131,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2910,0x2910,0x2930,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x290F,0x2930,0x290F,0x2930,0x210F,0x2910,0x210F,0x2930,0x290F,0x290F,0x2930,0x2130,0x2110,0x2130,0x2130,0x2131,0x1932,0x1133,0x19D7,0x1A18,0x11D7,0x11B6,0x1133,0x1932,0x2131,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x292F,0x292F,0x2930,0x2130,0x2130,0x2131,0x1911,0x1112,0x1154,0x19D6,0x19F7,0x19B6,0x1995,0x1973,0x1111,0x2131,0x2130,0x2930,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1133,0x1175,0x11B7,0x09D8,0x01B9,0x01B9,0x01D9,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01D9,0x09D9,0x09F9,0x11D8,0x1195,0x1112,0x2131,0x2110,0x2110,0x2930,0x2930,0x2110,0x2930,0x210F,0x210F,0x212F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2930,0x210F,0x2910,0x2910,0x292F,0x210F,0x2910,0x2110,0x210F,0x212F,0x290F,0x290F,0x290F,0x292F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2930,0x210F,0x292F,0x290F,0x292F,0x210F,0x212F,0x2110,0x2110,0x2130,0x2110,0x2110,0x2111,0x2131,0x1932,0x1112,0x1133,0x21D6,0x21F7,0x2218,0x19B6,0x0914,0x08F3,0x1112,0x1112,0x1952,0x1931,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x1112,0x1154,0x19B6,0x21D7,0x2218,0x21D7,0x19B6,0x1134,0x1113,0x1112,0x1931,0x2131,0x2131,0x2130,0x2110,0x2110,0x210F,0x290F,0x290F,0x2930,0x290F,0x292F,0x292F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2930,0x210F,0x210F,0x2130,0x2130,0x2131,0x1911,0x10F2,0x19B7,0x19F8,0x19F9,0x19B7,0x10F2,0x1931,0x1910,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x290F,0x290F,0x210F,0x290F,0x210F,0x2130,0x2130,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x2910,0x290F,0x2910,0x2910,0x210F,0x210F,0x2110,0x2110,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2910,0x210F,0x210F,0x210F,0x2930,0x292F,0x290F,0x290F,0x210F,0x290F,0x2930,0x212F,0x210F,0x210F,0x292F,0x212F,0x2930,0x2930,0x2130,0x2131,0x1931,0x1112,0x1133,0x1155,0x21F7,0x21D7,0x21F7,0x1995,0x1933,0x1932,0x2131,0x2110,0x2110,0x2930,0x2930,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x292F,0x210F,0x212F,0x292F,0x292F,0x292F,0x210F,0x212F,0x2130,0x212F,0x2130,0x212F,0x212F,0x210F,0x2130,0x2930,0x2130,0x2110,0x20EF,0x2110,0x2951,0x2151,0x2131,0x1911,0x1131,0x0932,0x1194,0x11B5,0x19F7,0x2217,0x19B5,0x1153,0x1132,0x1931,0x2131,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x1911,0x1952,0x1132,0x1112,0x19B5,0x2A17,0x21D6,0x19B5,0x1112,0x1932,0x1931,0x1931,0x2131,0x2130,0x2130,0x2130,0x210F,0x2930,0x2130,0x2130,0x210F,0x2930,0x2930,0x290F,0x2910,0x2930,0x2110,0x2110,0x2110,0x2930,0x210F,0x2110,0x2930,0x212F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2930,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x2930,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1132,0x1974,0x19B6,0x21F7,0x19B6,0x1995,0x1153,0x1132,0x1952,0x1952,0x1931,0x1931,0x1932,0x1932,0x1952,0x1153,0x0954,0x19B6,0x11D7,0x2218,0x19B7,0x1154,0x1112,0x1911,0x2111,0x2110,0x2110,0x210F,0x210F,0x290F,0x212F,0x2930,0x290F,0x290F,0x212F,0x2930,0x212F,0x212F,0x210F,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x2930,0x2930,0x2130,0x2110,0x2111,0x1911,0x1911,0x1932,0x1132,0x1132,0x1953,0x1153,0x1154,0x1154,0x1155,0x0935,0x0975,0x11B7,0x19F8,0x1A18,0x1A17,0x11D6,0x0954,0x0912,0x1112,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x292F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x290F,0x210F,0x292F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x2111,0x1931,0x1112,0x1153,0x1154,0x1195,0x19F7,0x19F7,0x21F7,0x19D6,0x1154,0x1112,0x1912,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x1911,0x1911,0x10F2,0x1112,0x1133,0x1995,0x19B6,0x19D6,0x19F7,0x19D6,0x1995,0x1153,0x1132,0x1112,0x1932,0x1932,0x1931,0x1952,0x1932,0x1132,0x1153,0x1174,0x19D6,0x19F7,0x19F7,0x19D6,0x1995,0x1154,0x1133,0x1112,0x1912,0x1912,0x1932,0x1932,0x1932,0x1112,0x1154,0x1195,0x19F6,0x2217,0x19F7,0x19D6,0x1155,0x1133,0x1112,0x1112,0x1932,0x2131,0x2131,0x2130,0x210F,0x210F,0x210F,0x212F,0x2130,0x2930,0x290F,0x2930,0x2910,0x2910,0x290F,0x290F,0x2930,0x2910,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2930,0x292F,
  0x11F9,0x11F8,0x11D8,0x11B7,0x1175,0x1153,0x1132,0x1931,0x1911,0x2131,0x2131,0x2131,0x2130,0x2110,0x2110,0x2130,0x2131,0x2151,0x2131,0x1911,0x1112,0x1133,0x1154,0x1996,0x21F7,0x21F8,0x19D7,0x19B6,0x0933,0x1133,0x1952,0x1931,0x1930,0x2110,0x2110,0x2130,0x212F,0x212F,0x292F,0x212F,0x292F,0x212F,0x292F,0x292F,0x292F,0x292F,0x2110,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x212F,0x2930,0x2930,0x290F,0x210F,0x2930,0x2930,0x290F,0x290F,0x2910,0x2910,0x210F,0x210F,0x290F,0x2930,0x290F,0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x2930,0x290F,0x2930,0x290F,0x2930,0x2110,0x2110,0x2110,0x2110,0x292F,0x212F,0x210F,0x210F,0x212F,0x292F,0x290F,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2131,0x1931,0x1953,0x1134,0x19B7,0x11D8,0x09D9,0x09D9,0x09D9,0x01D9,0x01D9,0x01DA,0x01DA,0x01B9,0x01DA,0x01DA,0x01D9,0x01D9,0x09D9,0x11F9,0x09D8,0x19D7,0x1175,0x1153,0x1152,0x1952,0x1951,0x2151,0x2151,0x2130,0x2130,0x212F,0x212F,0x2930,0x2930,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2131,0x1911,0x1111,0x1112,0x1133,0x1174,0x19B6,0x19D7,0x19B7,0x19D7,0x1196,0x1154,0x1154,0x0913,0x1134,0x0933,0x1154,0x1174,0x1195,0x11B5,0x11D6,0x19F6,0x19F6,0x1A17,0x1A17,0x19F6,0x19F6,0x19F6,0x19D6,0x19D6,0x19D6,0x19B6,0x19D6,0x19D6,0x19B6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19B6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x21D6,0x19D6,0x21D6,0x21D6,0x19D6,0x21F6,0x19D6,0x19D6,0x19D6,0x19D6,0x19D6,0x19F6,0x19D6,0x19D6,0x19D6,0x19D6,0x19B5,0x19D6,0x19D5,0x11B5,0x19D5,0x19D6,0x19F6,0x19F6,0x19F6,0x11D6,0x11D6,0x19F7,0x11D7,0x09B7,0x09D8,0x09F9,0x01D9,0x01DA,0x01B9,0x01B9,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01FB,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x021B,0x01FA,0x01FA,0x01FA,0x01DA,0x01D9,0x09F9,0x09F9,0x19F8,0x1175,0x1112,0x1911,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2910,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2910,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x1911,0x1111,0x0933,0x19D6,0x19F8,0x19F7,0x1196,0x1132,0x1111,0x1911,0x2110,0x2110,0x2130,0x2130,0x2930,0x292F,0x292F,0x210F,0x210F,0x2930,0x2130,0x2131,0x1931,0x1132,0x1154,0x19F6,0x19F7,0x19D6,0x1995,0x1974,0x1112,0x2131,0x2131,0x2930,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1132,0x11B5,0x1A18,0x09F9,0x09D9,0x01B9,0x01B9,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01B9,0x01D9,0x09F9,0x11F8,0x19B6,0x10F2,0x1911,0x2111,0x2110,0x2930,0x2110,0x2110,0x2110,0x210F,0x212F,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x290F,0x210F,0x2910,0x290F,0x290F,0x2110,0x2110,0x210F,0x290F,0x290F,0x290F,0x2930,0x2930,0x2130,0x2130,0x210F,0x2130,0x2110,0x2930,0x292F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2111,0x1931,0x1912,0x1112,0x19B5,0x2217,0x21F7,0x21D7,0x1134,0x08F3,0x10F2,0x1132,0x1931,0x1951,0x2131,0x2130,0x2130,0x2130,0x210F,0x212F,0x2950,0x212F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2151,0x1931,0x1952,0x1952,0x1113,0x1154,0x1995,0x21D7,0x2218,0x21F7,0x19B6,0x1154,0x1113,0x1112,0x1932,0x1931,0x2151,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x292F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2110,0x2131,0x1931,0x1113,0x19D7,0x1A19,0x1A19,0x19B7,0x1112,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x212F,0x212F,0x290F,0x290F,0x212F,0x210F,0x290F,0x290F,0x290F,0x2110,0x2130,0x2130,0x2910,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2930,0x2930,0x212F,0x212F,0x292F,0x292F,0x290F,0x292F,0x292F,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x2130,0x2130,0x1931,0x1932,0x1933,0x1134,0x21D7,0x21D7,0x21D7,0x21D6,0x1954,0x1912,0x1932,0x2131,0x2131,0x2130,0x2110,0x2930,0x2110,0x2910,0x210F,0x2930,0x2930,0x2110,0x2130,0x292F,0x210F,0x212F,0x210F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2930,0x2130,0x20F0,0x20F0,0x2110,0x2110,0x2130,0x2130,0x2131,0x1931,0x1132,0x1153,0x0954,0x19B6,0x2238,0x21F7,0x1994,0x1132,0x1932,0x1931,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x1931,0x1932,0x1932,0x1112,0x21B5,0x2A17,0x21F6,0x1974,0x1112,0x1932,0x1931,0x1931,0x2131,0x2110,0x2130,0x2110,0x2930,0x2110,0x210F,0x2130,0x210F,0x210F,0x212F,0x210F,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x292F,0x210F,0x210F,0x290F,0x210F,0x2910,0x2930,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x20EF,0x20EF,0x210F,0x2930,0x2930,0x292F,0x292F,0x210F,0x212F,0x292F,0x210F,0x2130,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1112,0x1112,0x1154,0x19B6,0x19B6,0x19B6,0x1174,0x1132,0x1952,0x1932,0x1952,0x1931,0x1931,0x1931,0x1932,0x1153,0x0933,0x1196,0x19D7,0x19F8,0x19B7,0x1154,0x1112,0x1931,0x2111,0x2110,0x2110,0x210F,0x210F,0x2910,0x210F,0x212F,0x290F,0x290F,0x2930,0x212F,0x2130,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x2110,0x2110,0x2130,0x2110,0x2111,0x1911,0x1911,0x1932,0x1932,0x1932,0x1932,0x1953,0x1153,0x1974,0x1154,0x0954,0x0975,0x11D7,0x1A18,0x1A18,0x1A17,0x11B6,0x1133,0x0912,0x1111,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x210F,0x212F,0x2110,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2151,0x1932,0x1932,0x1132,0x1154,0x1195,0x19D6,0x2217,0x19F7,0x1995,0x1134,0x08F2,0x1112,0x1952,0x2151,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2131,0x2131,0x2131,0x2132,0x1932,0x1112,0x1113,0x1134,0x1154,0x1996,0x19D7,0x21F7,0x19D6,0x1195,0x1174,0x1132,0x1111,0x1111,0x1932,0x1932,0x1952,0x1932,0x1953,0x1174,0x1174,0x11B6,0x19F7,0x2217,0x19D6,0x1995,0x1154,0x1153,0x1132,0x1912,0x1932,0x1932,0x1932,0x1912,0x1133,0x1154,0x1174,0x19D6,0x2217,0x2217,0x19D6,0x1174,0x1134,0x1113,0x1932,0x1931,0x2131,0x2131,0x2110,0x210F,0x210F,0x210F,0x2130,0x2130,0x210F,0x2130,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,
  0x09D9,0x09D8,0x11F9,0x11D8,0x11B6,0x1175,0x1153,0x1132,0x1931,0x1931,0x2131,0x2131,0x2131,0x2110,0x2130,0x2110,0x2110,0x2131,0x2130,0x1911,0x1911,0x1112,0x1133,0x1975,0x19B6,0x21F7,0x21F7,0x19F7,0x19B6,0x1154,0x1133,0x1132,0x1931,0x1930,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x292F,0x210F,0x292F,0x292F,0x212F,0x2930,0x2930,0x2130,0x2930,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x2930,0x2110,0x2910,0x290F,0x290F,0x2910,0x210F,0x2110,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2930,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2930,0x2110,0x2110,0x2110,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2910,0x2910,0x2910,0x2910,0x2110,0x2130,0x2110,0x2130,0x2130,0x2131,0x1931,0x1952,0x0912,0x1175,0x19F8,0x11D8,0x09D8,0x09D9,0x09D9,0x09D9,0x09FA,0x01B9,0x01D9,0x09DA,0x01D9,0x09D9,0x01D9,0x09D8,0x09B7,0x11B7,0x1195,0x1154,0x1132,0x1952,0x1951,0x2151,0x2150,0x2150,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x2930,0x210F,0x2110,0x2130,0x2110,0x2110,0x2930,0x2110,0x2130,0x2930,0x2110,0x210F,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2930,0x2110,0x2110,0x2110,0x2130,0x2930,0x2110,0x2130,0x2110,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x1910,0x1911,0x1111,0x1112,0x1153,0x1174,0x1996,0x19D7,0x19B7,0x19D7,0x1996,0x1155,0x0934,0x0933,0x0913,0x1134,0x1154,0x1154,0x1174,0x1194,0x11B5,0x1194,0x11B5,0x11B5,0x11B5,0x11B5,0x1195,0x1174,0x1995,0x1194,0x1995,0x1995,0x1194,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1175,0x1194,0x1995,0x1995,0x1175,0x1195,0x1995,0x1195,0x1195,0x1995,0x1995,0x1194,0x1194,0x1174,0x1174,0x1194,0x1995,0x1174,0x1974,0x1174,0x1174,0x1174,0x1194,0x1174,0x1174,0x1195,0x1195,0x1174,0x1194,0x1995,0x1995,0x1194,0x1194,0x1194,0x1994,0x1994,0x1994,0x1194,0x19B4,0x1995,0x1995,0x19B5,0x1194,0x11B5,0x11B5,0x11B5,0x11B5,0x11B6,0x09B6,0x09B7,0x0A19,0x01F9,0x01D9,0x01D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01D9,0x09D8,0x11D8,0x1175,0x1112,0x1932,0x2151,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x2110,0x2930,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x292F,0x292F,0x290F,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x2910,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2110,0x210F,0x2910,0x2910,0x210F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2130,0x2131,0x1911,0x1912,0x1133,0x11B6,0x1A18,0x19F8,0x1196,0x1133,0x1911,0x2131,0x2110,0x2130,0x2930,0x2110,0x2930,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2151,0x1931,0x1132,0x1154,0x19D6,0x2217,0x19B6,0x19B5,0x1953,0x10F1,0x2131,0x2151,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2131,0x1911,0x1132,0x1195,0x1A38,0x09F8,0x01D9,0x01B9,0x01DA,0x01DA,0x01DA,0x01FA,0x01B9,0x01DA,0x01DA,0x09D9,0x11F9,0x19F8,0x1175,0x1112,0x2131,0x2110,0x2130,0x2130,0x2110,0x2110,0x2930,0x2130,0x2110,0x2910,0x2110,0x210F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x290F,0x290F,0x210F,0x2910,0x290F,0x210F,0x2110,0x2110,0x210F,0x290F,0x290F,0x210F,0x212F,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x292F,0x290F,0x292F,0x292F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2110,0x2111,0x1932,0x1111,0x1133,0x21F6,0x2217,0x2A18,0x1155,0x08F3,0x10F2,0x1112,0x1931,0x1911,0x1910,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2950,0x292F,0x2950,0x212F,0x212F,0x210F,0x1930,0x1931,0x1931,0x1932,0x1153,0x1133,0x1995,0x21F7,0x21F7,0x21F8,0x1996,0x1154,0x1133,0x1932,0x1911,0x1931,0x2131,0x2130,0x2130,0x210F,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x292F,0x292F,0x292F,0x210F,0x292F,0x210F,0x212F,0x210F,0x2110,0x212F,0x210F,0x210F,0x2930,0x2110,0x2131,0x1911,0x1112,0x19D7,0x1A18,0x19F9,0x19B7,0x0912,0x1931,0x2151,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x290F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2910,0x2110,0x2930,0x2930,0x2110,0x2110,0x2130,0x2930,0x2130,0x210F,0x2930,0x2930,0x212F,0x212F,0x212F,0x210F,0x292F,0x210F,0x290F,0x2930,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x212F,0x2130,0x2130,0x1930,0x1931,0x1932,0x1133,0x1175,0x19B7,0x19D7,0x21D7,0x1996,0x1133,0x1912,0x1931,0x2131,0x2130,0x2110,0x2110,0x2110,0x2930,0x210F,0x210F,0x2930,0x2930,0x2110,0x210F,0x212F,0x210F,0x210F,0x292F,0x292F,0x290F,0x290F,0x292F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x210F,0x2110,0x2130,0x2130,0x1931,0x1931,0x1132,0x1133,0x1175,0x21F7,0x2217,0x19B5,0x1133,0x1112,0x1931,0x2131,0x2110,0x2130,0x2110,0x2130,0x1910,0x1911,0x1931,0x1132,0x1132,0x19B5,0x2A17,0x21F6,0x1994,0x1112,0x1112,0x1931,0x2131,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2110,0x210F,0x2930,0x210F,0x2110,0x2930,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2930,0x2110,0x210F,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2910,0x20EF,0x210F,0x290F,0x210F,0x290F,0x292F,0x292F,0x290F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2131,0x1931,0x1911,0x1112,0x1133,0x19B6,0x19D7,0x19B6,0x19B5,0x1153,0x1152,0x1952,0x1931,0x1931,0x2131,0x1931,0x1931,0x1952,0x0913,0x1175,0x19F7,0x19D8,0x19D7,0x1155,0x1112,0x1911,0x2111,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x210F,0x210F,0x212F,0x2130,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2930,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x290F,0x292F,0x290F,0x290F,0x210F,0x290F,0x2910,0x2930,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x2110,0x2110,0x2930,0x2110,0x2130,0x2110,0x2110,0x2131,0x1911,0x1911,0x1911,0x1911,0x1932,0x1952,0x1953,0x1133,0x1133,0x0933,0x0954,0x19F7,0x1A17,0x1A17,0x2217,0x1195,0x1154,0x1112,0x1111,0x1931,0x2131,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x212F,0x210F,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x292F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x2950,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x1132,0x1153,0x1154,0x1195,0x19D6,0x21F7,0x21F7,0x1195,0x1154,0x0912,0x1132,0x1952,0x1951,0x1930,0x1930,0x1951,0x1930,0x1930,0x1930,0x1910,0x2130,0x1930,0x2131,0x2131,0x1911,0x2111,0x2111,0x2111,0x2131,0x2131,0x2131,0x1911,0x2131,0x1931,0x1912,0x1112,0x1112,0x1133,0x1134,0x1175,0x19B6,0x19F7,0x19F7,0x19D6,0x19B5,0x1974,0x1133,0x1112,0x1932,0x1931,0x1932,0x1912,0x1932,0x1953,0x1154,0x1174,0x11B6,0x19F7,0x19F7,0x19D6,0x1995,0x1154,0x1133,0x1132,0x1112,0x1932,0x1932,0x1932,0x1932,0x1133,0x1133,0x1175,0x19D6,0x2217,0x2217,0x19D6,0x1154,0x0933,0x1133,0x1132,0x1932,0x1931,0x2131,0x2130,0x2110,0x210F,0x210F,0x210F,0x2930,0x2130,0x210F,0x2110,0x2110,0x210F,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,
  0x09D8,0x09D8,0x09D8,0x11F8,0x11F8,0x1196,0x1175,0x1133,0x1132,0x1932,0x1911,0x2111,0x2131,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2131,0x2131,0x1931,0x1953,0x1133,0x1174,0x19B6,0x19F7,0x1A17,0x2238,0x11B6,0x0933,0x1133,0x1132,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x212F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x292F,0x292F,0x2930,0x2110,0x2930,0x2910,0x2110,0x2110,0x2910,0x2910,0x2110,0x2910,0x2910,0x210F,0x210F,0x212F,0x2930,0x2110,0x2110,0x2910,0x2910,0x2910,0x290F,0x210F,0x290F,0x2930,0x2910,0x210F,0x2930,0x2910,0x290F,0x2910,0x2910,0x2910,0x2110,0x2910,0x290F,0x210F,0x210F,0x290F,0x290F,0x2930,0x210F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2930,0x2930,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x2930,0x2930,0x210F,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2130,0x2130,0x2110,0x1911,0x1911,0x10F1,0x0933,0x19F7,0x11F7,0x09B7,0x09D8,0x09B8,0x11F9,0x09B9,0x09D9,0x09D9,0x09B9,0x09B8,0x09B8,0x09F8,0x11F8,0x11F8,0x19D7,0x0954,0x1133,0x1952,0x1951,0x2151,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2110,0x2130,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x212F,0x2130,0x210F,0x2130,0x210F,0x2110,0x210F,0x210F,0x2110,0x2930,0x210F,0x2110,0x210F,0x2110,0x2130,0x2110,0x2110,0x2930,0x210F,0x210F,0x2110,0x2130,0x2110,0x210F,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2131,0x1931,0x1931,0x1112,0x1133,0x1154,0x1996,0x19B7,0x19D7,0x19D7,0x1175,0x1155,0x0934,0x0933,0x1133,0x1133,0x1153,0x1153,0x1153,0x1153,0x0953,0x0953,0x0953,0x0953,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1133,0x1133,0x1133,0x1133,0x1153,0x1133,0x1153,0x1153,0x1153,0x1153,0x1153,0x1153,0x1133,0x1153,0x1153,0x1133,0x1153,0x1133,0x1133,0x1153,0x1153,0x1153,0x1153,0x1132,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1132,0x1132,0x1132,0x1132,0x1133,0x1133,0x1153,0x1153,0x1153,0x1153,0x1154,0x0954,0x0975,0x0176,0x09D8,0x09D9,0x01D9,0x01D9,0x01D9,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01D9,0x09F9,0x11F9,0x11F8,0x1175,0x10F2,0x1912,0x2131,0x2131,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x210F,0x290F,0x2910,0x2930,0x2910,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x290F,0x2930,0x2130,0x2110,0x2110,0x2130,0x1931,0x1932,0x1133,0x19D6,0x19F8,0x11D7,0x1196,0x1133,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2930,0x292F,0x210F,0x292F,0x210F,0x2130,0x2130,0x2131,0x1911,0x1132,0x1154,0x19D6,0x19F7,0x11B5,0x1995,0x1953,0x1111,0x1911,0x2130,0x2110,0x2930,0x210F,0x2110,0x2110,0x2130,0x2931,0x2131,0x1911,0x1933,0x1174,0x11D7,0x09D8,0x09D9,0x01B9,0x01B9,0x01B9,0x01DA,0x01DA,0x01DA,0x01D9,0x01D9,0x09F9,0x1219,0x19F8,0x1154,0x1112,0x1911,0x2110,0x2130,0x2930,0x2110,0x2110,0x210F,0x210F,0x2930,0x2930,0x2910,0x2930,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2930,0x290F,0x210F,0x290F,0x2930,0x210F,0x2930,0x2110,0x2910,0x290F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2110,0x2930,0x2110,0x210F,0x290F,0x210F,0x290F,0x290F,0x292F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2131,0x2152,0x1911,0x08D1,0x1954,0x2A17,0x2217,0x21D7,0x08F3,0x08D2,0x1953,0x2152,0x1911,0x1910,0x2130,0x2130,0x2130,0x2130,0x212F,0x190F,0x210F,0x210F,0x2930,0x2930,0x2930,0x212F,0x2110,0x1930,0x1951,0x1932,0x1133,0x1133,0x19B6,0x21F7,0x2218,0x21F7,0x1996,0x1134,0x1112,0x1112,0x1932,0x2131,0x2151,0x2130,0x210F,0x210F,0x210F,0x292F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x292F,0x292F,0x292F,0x292F,0x210F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x210F,0x2130,0x2131,0x1911,0x1113,0x19D7,0x1A18,0x1A19,0x19B6,0x1112,0x1931,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x212F,0x2130,0x212F,0x210F,0x210F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x210F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2910,0x2910,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2930,0x2110,0x210F,0x210F,0x2930,0x2930,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x2930,0x290F,0x210F,0x210F,0x2930,0x2910,0x2930,0x2130,0x2110,0x2131,0x1931,0x1932,0x1133,0x1174,0x19B6,0x19D7,0x21F8,0x21D7,0x1974,0x1132,0x1911,0x1911,0x2131,0x2130,0x2130,0x2110,0x2930,0x2930,0x210F,0x210F,0x2130,0x2130,0x2110,0x210F,0x210F,0x210F,0x212F,0x292F,0x292F,0x292F,0x290F,0x290F,0x210F,0x2130,0x210F,0x210F,0x210F,0x292F,0x2930,0x2130,0x2110,0x2110,0x2130,0x2930,0x2930,0x290F,0x210F,0x2110,0x2130,0x2131,0x1931,0x1132,0x1133,0x1175,0x19D6,0x2217,0x21F6,0x1153,0x1132,0x1911,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x1910,0x1911,0x1132,0x1112,0x19B5,0x2A37,0x21F6,0x19B5,0x1112,0x1932,0x1931,0x2131,0x2110,0x2110,0x2130,0x2110,0x2110,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x290F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x290F,0x210F,0x290F,0x2930,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x210F,0x292F,0x292F,0x292F,0x212F,0x2930,0x2130,0x2151,0x2131,0x1911,0x1912,0x1133,0x1975,0x19B6,0x19B6,0x2217,0x1974,0x1152,0x1951,0x1911,0x1910,0x1931,0x2151,0x1931,0x1132,0x1113,0x1154,0x19F7,0x19F8,0x19F8,0x1175,0x1112,0x1911,0x2110,0x2110,0x2130,0x2110,0x2930,0x2910,0x2930,0x2930,0x212F,0x210F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x2930,0x2910,0x2910,0x2110,0x2910,0x2910,0x2930,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2130,0x2130,0x2930,0x2130,0x2110,0x2110,0x1910,0x1911,0x1931,0x1932,0x1932,0x1932,0x1932,0x1132,0x0912,0x0933,0x11B5,0x1A17,0x2238,0x2217,0x1995,0x1133,0x1112,0x1932,0x2152,0x2131,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x212F,0x2110,0x2110,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x292F,0x292F,0x212F,0x210F,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2931,0x2131,0x2131,0x2131,0x1932,0x1132,0x1153,0x1154,0x1195,0x19D6,0x19D7,0x19D7,0x19B6,0x1154,0x0912,0x0912,0x1111,0x1131,0x1111,0x1131,0x1111,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x10F1,0x10F1,0x10F2,0x0912,0x1133,0x1154,0x1195,0x19B6,0x19F7,0x19D7,0x19F7,0x19B6,0x1174,0x1133,0x1112,0x1111,0x1931,0x1952,0x1912,0x1112,0x1132,0x1133,0x1174,0x1195,0x19F7,0x19F7,0x19D6,0x19B5,0x1173,0x1153,0x1112,0x1932,0x1932,0x1952,0x1952,0x1933,0x1133,0x1153,0x1195,0x21F7,0x2217,0x2218,0x19B6,0x1154,0x1133,0x1112,0x1111,0x1931,0x2131,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2130,0x2930,0x2130,0x2110,0x2110,0x2110,0x2130,0x210F,0x2930,0x290F,0x210F,0x290F,0x290F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,
  0x09D8,0x09B8,0x09D8,0x09F8,0x11F8,0x11D7,0x11B6,0x1175,0x1153,0x1132,0x1932,0x1911,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2130,0x2131,0x2131,0x2152,0x1932,0x1932,0x1133,0x1174,0x19B6,0x2218,0x1A17,0x2218,0x1195,0x0933,0x1153,0x1932,0x1911,0x2131,0x2131,0x2130,0x2130,0x212F,0x212F,0x292F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x2930,0x2110,0x2910,0x2910,0x210F,0x290F,0x210F,0x290F,0x290F,0x2910,0x2110,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x210F,0x2910,0x2930,0x210F,0x212F,0x2130,0x2130,0x210F,0x212F,0x212F,0x290F,0x2930,0x290F,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x1911,0x1911,0x0912,0x11B5,0x19F6,0x11B6,0x11D7,0x11B7,0x11B8,0x09B8,0x0998,0x09B8,0x09B8,0x09B7,0x09B7,0x11D7,0x1A18,0x19F7,0x1174,0x1132,0x1932,0x1931,0x1930,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x290F,0x292F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x2130,0x210F,0x2930,0x210F,0x210F,0x2910,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x212F,0x210F,0x2130,0x210F,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2131,0x2131,0x1931,0x1911,0x1112,0x1133,0x1154,0x19B6,0x19B7,0x19B7,0x19B7,0x1996,0x1154,0x1134,0x1133,0x1133,0x1153,0x1132,0x1153,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1152,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1112,0x1932,0x1132,0x1111,0x1112,0x1932,0x1132,0x1132,0x1132,0x1132,0x1132,0x1133,0x1133,0x0934,0x0175,0x09F8,0x01D8,0x01F9,0x01D9,0x01B9,0x01D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01DA,0x01FA,0x01F9,0x0A19,0x11F8,0x1175,0x1112,0x1932,0x2131,0x2131,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x290F,0x2930,0x2930,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x2930,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2131,0x1932,0x1133,0x19D6,0x11F7,0x11D7,0x11B6,0x1133,0x1932,0x2131,0x2110,0x2110,0x2130,0x210F,0x292F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2131,0x1911,0x1112,0x1154,0x19B6,0x21F7,0x19B6,0x19B5,0x1973,0x1112,0x1911,0x2130,0x2130,0x2930,0x210F,0x2110,0x2110,0x2130,0x2110,0x2110,0x1911,0x1932,0x1154,0x11B6,0x11F8,0x09F9,0x01D9,0x01B9,0x01B9,0x01DA,0x01DA,0x01D9,0x01DA,0x01D9,0x09F9,0x1219,0x11B6,0x1133,0x1912,0x1911,0x2131,0x2130,0x2130,0x2930,0x2910,0x2930,0x2110,0x2930,0x2110,0x2930,0x2930,0x2110,0x2110,0x2930,0x2110,0x2930,0x2110,0x210F,0x290F,0x210F,0x290F,0x2930,0x210F,0x210F,0x2910,0x2910,0x2910,0x2930,0x210F,0x210F,0x2130,0x2110,0x2110,0x2930,0x2110,0x2910,0x2110,0x2110,0x2910,0x290F,0x290F,0x290F,0x2930,0x212F,0x210F,0x2130,0x2130,0x2130,0x2131,0x2151,0x1911,0x08D1,0x1974,0x2A17,0x21F7,0x19D6,0x08D3,0x08D2,0x2153,0x1931,0x1910,0x2110,0x2110,0x2130,0x2110,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2130,0x1931,0x1952,0x1132,0x1153,0x1175,0x21D7,0x21F7,0x21F7,0x1996,0x1954,0x1113,0x1912,0x1911,0x1911,0x2131,0x2130,0x2130,0x210F,0x210F,0x210F,0x2930,0x290F,0x2910,0x290F,0x290F,0x210F,0x210F,0x212F,0x210F,0x292F,0x210F,0x290F,0x292F,0x292F,0x210F,0x290F,0x210F,0x210F,0x2110,0x2130,0x2131,0x1912,0x1113,0x19D7,0x1A19,0x1A19,0x19D7,0x1112,0x1931,0x2131,0x2130,0x2130,0x2130,0x210F,0x2130,0x212F,0x210F,0x2130,0x212F,0x210F,0x290F,0x210F,0x212F,0x212F,0x2130,0x212F,0x212F,0x2930,0x2130,0x212F,0x212F,0x210F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2110,0x2930,0x292F,0x212F,0x292F,0x292F,0x212F,0x292F,0x292F,0x212F,0x290F,0x210F,0x2930,0x2930,0x2930,0x2130,0x2130,0x2131,0x1931,0x1932,0x1132,0x1154,0x19B5,0x21F7,0x2218,0x21D7,0x1975,0x1953,0x1932,0x1911,0x1910,0x2131,0x2130,0x2130,0x210F,0x2930,0x290F,0x210F,0x210F,0x212F,0x2130,0x2930,0x210F,0x212F,0x292F,0x212F,0x210F,0x212F,0x292F,0x290F,0x290F,0x2930,0x2130,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x210F,0x210F,0x2130,0x2930,0x2930,0x210F,0x290F,0x2910,0x2130,0x2130,0x1931,0x1931,0x1112,0x1154,0x19B6,0x2238,0x19F6,0x1153,0x1112,0x1932,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x1911,0x1911,0x1132,0x1132,0x19B5,0x2A37,0x21F6,0x19B5,0x1112,0x1932,0x1952,0x1931,0x2130,0x2110,0x2130,0x2110,0x2930,0x2930,0x2930,0x212F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x210F,0x290F,0x210F,0x2930,0x212F,0x210F,0x2110,0x2910,0x2110,0x2910,0x2910,0x2910,0x2930,0x290F,0x292F,0x290F,0x210F,0x290F,0x290F,0x290F,0x292F,0x210F,0x292F,0x292F,0x212F,0x292F,0x292F,0x2930,0x2130,0x2131,0x2131,0x1932,0x1113,0x1154,0x19B6,0x19B6,0x21F6,0x1994,0x1111,0x1931,0x1931,0x1931,0x1931,0x2131,0x1911,0x1932,0x1133,0x1154,0x19F7,0x19F8,0x19F8,0x1175,0x1112,0x1911,0x2110,0x2130,0x2110,0x2930,0x2930,0x2910,0x2110,0x2110,0x212F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2910,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x2930,0x2110,0x2130,0x2110,0x2110,0x2111,0x2111,0x2111,0x1911,0x1932,0x1112,0x1112,0x1112,0x1133,0x19B6,0x21F7,0x2237,0x2217,0x1995,0x1133,0x1112,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x210F,0x292F,0x292F,0x292F,0x210F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2930,0x2930,0x2930,0x2130,0x2130,0x2131,0x2131,0x1931,0x1932,0x1932,0x1133,0x1174,0x1195,0x19D6,0x19F7,0x21F7,0x19D7,0x1154,0x0933,0x0932,0x0932,0x0932,0x0932,0x0932,0x1132,0x1132,0x1152,0x1152,0x1132,0x1132,0x1132,0x1132,0x1112,0x1132,0x1112,0x1112,0x1112,0x1112,0x1112,0x1133,0x0933,0x1153,0x1154,0x1195,0x19D6,0x19F7,0x19F7,0x19F7,0x19D7,0x1195,0x1994,0x1153,0x1112,0x1131,0x1932,0x1952,0x1932,0x1112,0x1112,0x1133,0x1154,0x1195,0x19F7,0x1A17,0x1A17,0x19B5,0x1174,0x1132,0x1132,0x1932,0x1911,0x1932,0x1953,0x1953,0x1133,0x1154,0x1195,0x19D7,0x2218,0x21F7,0x21F7,0x1174,0x1113,0x1112,0x1111,0x1931,0x2131,0x2130,0x2110,0x2110,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x212F,0x212F,0x292F,0x292F,0x210F,0x290F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,
  0x09B8,0x09B7,0x09D8,0x09D8,0x11F8,0x11F8,0x11D8,0x11B6,0x1175,0x1133,0x1933,0x1932,0x1931,0x2131,0x2131,0x2110,0x2110,0x2110,0x2130,0x2131,0x2151,0x2131,0x1910,0x1911,0x1111,0x1132,0x1174,0x19B6,0x19D7,0x19F7,0x21F7,0x1175,0x0933,0x1133,0x1932,0x1931,0x2131,0x2130,0x2130,0x2110,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2910,0x2910,0x210F,0x210F,0x2910,0x2110,0x2930,0x2110,0x2910,0x2930,0x2930,0x290F,0x210F,0x2910,0x2910,0x2910,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x210F,0x2910,0x2910,0x290F,0x2930,0x210F,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x2910,0x2910,0x2930,0x2930,0x2110,0x2110,0x2110,0x2130,0x212F,0x212F,0x2130,0x2930,0x212F,0x210F,0x212F,0x212F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2130,0x2130,0x2130,0x2131,0x2131,0x1951,0x1132,0x1153,0x1994,0x1195,0x19D6,0x19D7,0x19D7,0x11D7,0x11D7,0x19F7,0x19F7,0x19D7,0x19F7,0x19D6,0x19B5,0x1974,0x1132,0x1932,0x1911,0x1910,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x210F,0x20EF,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2910,0x210F,0x210F,0x210F,0x292F,0x210F,0x212F,0x210F,0x212F,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x292F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2131,0x1931,0x1931,0x1112,0x1113,0x1154,0x1175,0x19B7,0x19F7,0x19D7,0x19D6,0x1154,0x0933,0x1133,0x0912,0x1132,0x1132,0x1132,0x1132,0x1152,0x1952,0x1952,0x1932,0x1932,0x1931,0x1911,0x1932,0x1932,0x1932,0x1912,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1931,0x1931,0x1931,0x1131,0x1131,0x1131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1952,0x1131,0x1931,0x1931,0x1931,0x1931,0x1131,0x1931,0x1931,0x1111,0x1131,0x1931,0x1911,0x1932,0x1952,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1931,0x1932,0x1932,0x2152,0x1932,0x1932,0x1932,0x1931,0x1931,0x1952,0x1932,0x1952,0x1132,0x1113,0x0913,0x0155,0x09D8,0x09F9,0x09F9,0x01D9,0x01D9,0x01FA,0x01DA,0x01B9,0x01FA,0x01B9,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FB,0x01DA,0x01FA,0x01FA,0x01F9,0x01D9,0x09F8,0x11D8,0x1175,0x1133,0x2152,0x2131,0x2131,0x2110,0x210F,0x212F,0x210F,0x290F,0x210F,0x210F,0x2910,0x2110,0x2930,0x2110,0x2910,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x2110,0x2930,0x2910,0x290F,0x2930,0x210F,0x210F,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x2930,0x290F,0x2930,0x2930,0x290F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x1911,0x1932,0x1133,0x19D7,0x1A18,0x19F8,0x1195,0x1133,0x1912,0x2132,0x2131,0x2110,0x210F,0x2130,0x212F,0x210F,0x210F,0x292F,0x212F,0x2930,0x2130,0x2131,0x1911,0x1112,0x1154,0x19B6,0x19D7,0x19B6,0x19B5,0x1153,0x1112,0x2131,0x2131,0x2130,0x2110,0x2910,0x2910,0x2930,0x2130,0x2130,0x2110,0x1911,0x1932,0x1154,0x1196,0x11F8,0x11F9,0x09D9,0x01D9,0x01B9,0x01B9,0x01B9,0x01DA,0x09FA,0x0A1A,0x1219,0x1A18,0x1175,0x1132,0x1932,0x2131,0x2110,0x2110,0x2110,0x2110,0x2910,0x2930,0x2910,0x2110,0x2930,0x2930,0x2930,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x292F,0x210F,0x2910,0x210F,0x210F,0x2930,0x212F,0x210F,0x210F,0x2110,0x2110,0x2930,0x2930,0x2910,0x2910,0x290F,0x290F,0x292F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1930,0x2131,0x1931,0x1932,0x08F1,0x1994,0x21F6,0x21F7,0x19B6,0x08D2,0x1112,0x1932,0x1911,0x2130,0x2130,0x210F,0x2930,0x2130,0x210F,0x212F,0x212F,0x210F,0x212F,0x292F,0x210F,0x210F,0x2130,0x1931,0x1931,0x1132,0x1133,0x1154,0x21D7,0x21F7,0x21D7,0x19B6,0x1154,0x1112,0x1112,0x1931,0x2131,0x2131,0x2110,0x2130,0x212F,0x210F,0x210F,0x212F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x292F,0x292F,0x292F,0x292F,0x290F,0x210F,0x210F,0x2910,0x2110,0x2130,0x2110,0x1911,0x1113,0x19D7,0x1A18,0x1A19,0x19D7,0x1112,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2930,0x2930,0x2930,0x2910,0x210F,0x2130,0x210F,0x2130,0x2130,0x2930,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2130,0x2930,0x2130,0x2130,0x2110,0x2930,0x210F,0x210F,0x2930,0x292F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x2930,0x292F,0x2930,0x2930,0x2110,0x2110,0x1910,0x1931,0x1932,0x1132,0x1153,0x1995,0x21F7,0x2218,0x21F7,0x1154,0x1113,0x1953,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x212F,0x290F,0x210F,0x290F,0x210F,0x292F,0x212F,0x290F,0x290F,0x212F,0x212F,0x210F,0x210F,0x292F,0x210F,0x292F,0x210F,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x210F,0x2130,0x212F,0x2110,0x2930,0x2930,0x2930,0x2930,0x2110,0x2110,0x2130,0x1931,0x1931,0x1112,0x1133,0x19B6,0x2A38,0x21F6,0x1154,0x08F1,0x1111,0x1931,0x1930,0x2130,0x2110,0x2130,0x1910,0x1931,0x1931,0x1932,0x1132,0x19B5,0x2A37,0x2217,0x1994,0x1112,0x1112,0x2152,0x2151,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x212F,0x210F,0x292F,0x292F,0x212F,0x212F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x212F,0x2930,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x210F,0x210F,0x20EF,0x2910,0x2110,0x2110,0x2930,0x2910,0x2110,0x2110,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x292F,0x292F,0x210F,0x292F,0x292F,0x212F,0x2110,0x2130,0x2151,0x1932,0x1113,0x1134,0x1996,0x21D7,0x21D6,0x1974,0x10F1,0x1911,0x1931,0x1931,0x2131,0x1931,0x1911,0x1931,0x1112,0x1154,0x19F7,0x1A18,0x2218,0x1196,0x1112,0x1911,0x2131,0x2110,0x2110,0x2110,0x2910,0x2930,0x210F,0x2110,0x212F,0x2930,0x2930,0x2130,0x2110,0x2110,0x2110,0x210F,0x290F,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2910,0x2930,0x2930,0x2930,0x2110,0x2110,0x2910,0x2110,0x2910,0x290F,0x290F,0x2930,0x290F,0x2930,0x290F,0x210F,0x210F,0x290F,0x2930,0x2910,0x2110,0x2910,0x2910,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2930,0x2910,0x210F,0x290F,0x290F,0x290F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2131,0x2151,0x2152,0x1911,0x1111,0x1112,0x1133,0x1995,0x2217,0x2A38,0x21F7,0x1995,0x1153,0x08F2,0x1912,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x2930,0x2930,0x2930,0x2130,0x2130,0x2930,0x2930,0x2130,0x2130,0x2930,0x2931,0x2131,0x2131,0x2131,0x1911,0x1932,0x1953,0x1174,0x19B5,0x19D6,0x19D7,0x2217,0x2218,0x19D6,0x11B6,0x11B5,0x11D6,0x11D5,0x11D6,0x11B5,0x11B5,0x11D6,0x11B5,0x11B5,0x11B5,0x11B6,0x11B6,0x11B5,0x11B6,0x11B6,0x19D6,0x11B6,0x19D6,0x19F6,0x19D6,0x19D6,0x19F6,0x19D6,0x2217,0x1A17,0x1A17,0x19F7,0x19B6,0x1195,0x1154,0x1132,0x1111,0x1111,0x1931,0x1952,0x1952,0x1932,0x1133,0x1154,0x1154,0x1196,0x19D7,0x1A18,0x1A17,0x19D6,0x1174,0x1133,0x1932,0x1932,0x1111,0x1911,0x1112,0x1932,0x1953,0x1974,0x1195,0x19F7,0x19F7,0x19F7,0x21F7,0x1175,0x0912,0x10F2,0x1931,0x1951,0x1910,0x2110,0x2110,0x210F,0x290F,0x290F,0x210F,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2950,0x212F,0x212F,0x210F,0x210F,0x292F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x2930,
  0x0997,0x0997,0x09B7,0x09D8,0x11D8,0x11F8,0x11F8,0x11D7,0x11B6,0x1175,0x1154,0x1933,0x1932,0x1931,0x2131,0x2111,0x2130,0x2130,0x2130,0x2951,0x2130,0x2130,0x1910,0x1910,0x1931,0x1132,0x1133,0x1174,0x19B5,0x19D6,0x2218,0x21F7,0x1175,0x1133,0x1133,0x1932,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x210F,0x210F,0x212F,0x292F,0x290F,0x210F,0x2930,0x290F,0x2930,0x2910,0x2930,0x2930,0x2930,0x2910,0x290F,0x2930,0x2910,0x2930,0x210F,0x2930,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2930,0x2110,0x2130,0x212F,0x210F,0x210F,0x2130,0x212F,0x212F,0x212F,0x292F,0x290F,0x2930,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2130,0x2130,0x1931,0x1931,0x1132,0x1132,0x1153,0x1174,0x1175,0x19B6,0x19F6,0x19D6,0x19D6,0x1995,0x19B5,0x1974,0x1153,0x1133,0x1112,0x1911,0x1911,0x1910,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x292F,0x290F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2930,0x2930,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x292F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2130,0x212F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2131,0x1931,0x1911,0x1112,0x1113,0x1154,0x1996,0x19D7,0x2218,0x19F7,0x1195,0x1154,0x0933,0x0932,0x1132,0x1132,0x1152,0x1132,0x1932,0x1932,0x1931,0x1952,0x1931,0x1931,0x1931,0x1932,0x1932,0x1932,0x1932,0x1932,0x1931,0x1931,0x1932,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1952,0x1932,0x1932,0x1952,0x1932,0x1931,0x1952,0x1952,0x1932,0x1931,0x1931,0x1931,0x2132,0x1911,0x1911,0x1931,0x1931,0x1932,0x1932,0x1132,0x1133,0x1154,0x0955,0x09B7,0x09D8,0x01D9,0x01D9,0x01D9,0x01DA,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01F9,0x01F9,0x09F9,0x11D8,0x1195,0x1112,0x1932,0x2131,0x2130,0x2110,0x2130,0x210F,0x212F,0x2930,0x210F,0x290F,0x2930,0x210F,0x2110,0x2910,0x2910,0x2910,0x2910,0x2930,0x290F,0x2930,0x290F,0x290F,0x2930,0x2910,0x2910,0x2930,0x210F,0x290F,0x2930,0x210F,0x210F,0x2930,0x2930,0x210F,0x2930,0x290F,0x2930,0x292F,0x292F,0x2930,0x2930,0x292F,0x292F,0x2930,0x2930,0x290F,0x2930,0x2910,0x2930,0x2110,0x2110,0x2110,0x2130,0x2110,0x1931,0x1111,0x1133,0x11D6,0x1A18,0x19F8,0x1196,0x1113,0x1932,0x2131,0x2131,0x2110,0x210F,0x210F,0x292F,0x210F,0x292F,0x292F,0x2930,0x2930,0x2130,0x2131,0x1911,0x1112,0x1154,0x19B6,0x21F7,0x19B6,0x1995,0x1153,0x1112,0x2131,0x2131,0x2110,0x2110,0x2910,0x2910,0x2930,0x2930,0x2130,0x2110,0x2111,0x1952,0x1153,0x1175,0x11B7,0x1A19,0x11F9,0x09B8,0x01B9,0x01B9,0x01B9,0x09D9,0x09D9,0x1219,0x1219,0x11D7,0x1133,0x1132,0x1931,0x2131,0x2130,0x2130,0x2110,0x2930,0x2110,0x2910,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x210F,0x212F,0x2930,0x290F,0x210F,0x290F,0x2930,0x292F,0x210F,0x210F,0x2110,0x210F,0x212F,0x212F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2910,0x2910,0x290F,0x2930,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x08F1,0x1994,0x21F6,0x21F7,0x1995,0x08F3,0x1112,0x1931,0x2130,0x2130,0x2930,0x2130,0x2930,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x292F,0x212F,0x2130,0x2130,0x1931,0x1132,0x1133,0x0933,0x19D6,0x21F7,0x21F7,0x1996,0x1154,0x1133,0x1932,0x1911,0x1931,0x2110,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x210F,0x210F,0x210F,0x2910,0x2910,0x2110,0x2110,0x1932,0x1113,0x11B7,0x1A19,0x1A19,0x19D7,0x1132,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x2930,0x2110,0x2930,0x2930,0x2110,0x2910,0x2930,0x2130,0x2110,0x2130,0x210F,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2930,0x2130,0x2130,0x2930,0x2930,0x2110,0x2110,0x2910,0x290F,0x292F,0x210F,0x292F,0x212F,0x210F,0x212F,0x210F,0x2930,0x2930,0x2930,0x2110,0x2110,0x1911,0x1931,0x1932,0x1132,0x1153,0x1995,0x21F7,0x2217,0x2217,0x1975,0x1133,0x1132,0x1952,0x1932,0x1931,0x2130,0x2130,0x2130,0x210F,0x292F,0x210F,0x290F,0x290F,0x290F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x210F,0x2130,0x212F,0x2130,0x2930,0x210F,0x210F,0x2930,0x2930,0x2130,0x2130,0x1931,0x1931,0x1132,0x1133,0x19B6,0x21F7,0x21F7,0x1174,0x0912,0x1132,0x1931,0x1910,0x2130,0x2110,0x2110,0x2131,0x1931,0x1931,0x1132,0x1132,0x19B5,0x2217,0x21F6,0x1995,0x1112,0x1112,0x2152,0x2151,0x2130,0x1910,0x2110,0x2130,0x2930,0x2930,0x210F,0x2930,0x210F,0x2930,0x210F,0x212F,0x2930,0x2930,0x210F,0x2110,0x2110,0x2110,0x2130,0x210F,0x2130,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2930,0x2110,0x2930,0x210F,0x210F,0x210F,0x290F,0x292F,0x210F,0x210F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x290F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2130,0x1931,0x1932,0x1132,0x1133,0x1996,0x21D6,0x21D6,0x1994,0x1111,0x1911,0x1931,0x1911,0x2131,0x2131,0x1931,0x1931,0x1112,0x0933,0x19D7,0x1A18,0x19F8,0x1196,0x1112,0x1911,0x2111,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2930,0x212F,0x212F,0x212F,0x210F,0x2110,0x2110,0x210F,0x2930,0x2930,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x210F,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x212F,0x290F,0x2910,0x2930,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2130,0x210F,0x2110,0x2130,0x2131,0x2130,0x2131,0x1931,0x1911,0x1911,0x1112,0x1133,0x1995,0x21F7,0x2A17,0x21F7,0x1995,0x1133,0x1112,0x1912,0x2131,0x2111,0x2130,0x2131,0x2930,0x2130,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x292F,0x210F,0x292F,0x292F,0x292F,0x290F,0x2930,0x2930,0x210F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2130,0x2111,0x1911,0x1932,0x1932,0x1953,0x1974,0x1995,0x19B6,0x19D7,0x2218,0x2218,0x1A38,0x1A38,0x1A17,0x1A38,0x1A17,0x1A17,0x1A17,0x1A17,0x1A38,0x1A38,0x1A18,0x1A18,0x2238,0x1A18,0x1A38,0x1A18,0x1A18,0x19F7,0x1A18,0x19F7,0x19F7,0x11F7,0x19F7,0x19F7,0x19F7,0x19F6,0x19F6,0x19D6,0x1195,0x1174,0x1153,0x1111,0x1111,0x1931,0x2151,0x1952,0x1932,0x1132,0x1153,0x1154,0x1195,0x19D7,0x1A18,0x1A17,0x19D6,0x1194,0x1132,0x1132,0x1932,0x1932,0x1911,0x1912,0x1932,0x1133,0x1154,0x19B6,0x19D7,0x19F7,0x2218,0x19D7,0x1175,0x0933,0x1112,0x1111,0x1931,0x2131,0x2110,0x2110,0x210F,0x210F,0x210F,0x292F,0x290F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x212F,0x212F,0x292F,0x210F,0x292F,0x210F,0x290F,0x210F,0x2130,0x2110,0x2110,0x2930,0x210F,0x2930,0x2930,
  0x0955,0x0975,0x0976,0x09B7,0x11D8,0x11F8,0x11F8,0x11F8,0x11B7,0x11B6,0x0955,0x1154,0x1953,0x1932,0x1931,0x2131,0x2131,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2151,0x1931,0x1132,0x1132,0x1974,0x19B6,0x19F7,0x2218,0x21F7,0x1195,0x1134,0x1133,0x1932,0x2132,0x2151,0x2130,0x2110,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2930,0x210F,0x210F,0x2910,0x210F,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2930,0x2130,0x2130,0x2130,0x2131,0x1931,0x1911,0x1932,0x1132,0x1132,0x1133,0x1133,0x1153,0x1133,0x1113,0x1112,0x1112,0x1132,0x1912,0x1912,0x1911,0x1911,0x2131,0x2130,0x2130,0x210F,0x212F,0x210F,0x290F,0x292F,0x210F,0x290F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x2910,0x2110,0x2130,0x2930,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x2130,0x2930,0x210F,0x210F,0x2110,0x2130,0x2130,0x2131,0x1931,0x1911,0x1112,0x1153,0x1154,0x19B6,0x19B6,0x11B6,0x11B6,0x1195,0x1174,0x1153,0x0933,0x1153,0x1152,0x1132,0x1932,0x1131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1932,0x1932,0x2132,0x1932,0x1911,0x1932,0x1932,0x1932,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1952,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1911,0x1932,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x2132,0x2132,0x2111,0x1911,0x2131,0x1932,0x2152,0x1932,0x1112,0x1133,0x0934,0x0955,0x09D7,0x09F9,0x01D9,0x01B9,0x01D9,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FB,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01F9,0x01D9,0x09D8,0x11D7,0x1175,0x1112,0x1911,0x2131,0x2130,0x2110,0x2130,0x210F,0x210F,0x2930,0x290F,0x210F,0x290F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x2910,0x2910,0x210F,0x210F,0x2910,0x290F,0x290F,0x210F,0x2910,0x2910,0x210F,0x290F,0x2930,0x2910,0x210F,0x210F,0x210F,0x290F,0x2930,0x2910,0x290F,0x290F,0x290F,0x290F,0x2930,0x2110,0x290F,0x210F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x1912,0x1133,0x19D7,0x1A18,0x19F7,0x1196,0x0912,0x1932,0x2131,0x2131,0x2110,0x2130,0x210F,0x212F,0x292F,0x212F,0x292F,0x212F,0x2950,0x2130,0x2131,0x1931,0x1132,0x1154,0x19D6,0x19F7,0x19D6,0x19B5,0x1153,0x1112,0x2131,0x2131,0x2930,0x2930,0x210F,0x210F,0x2930,0x2130,0x2110,0x2110,0x2131,0x1931,0x1932,0x1154,0x1175,0x11B7,0x11B8,0x09B8,0x09D9,0x09D9,0x09D9,0x09D9,0x09D9,0x11F9,0x19F8,0x1175,0x1132,0x1932,0x1931,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2930,0x212F,0x2930,0x2910,0x210F,0x210F,0x290F,0x290F,0x2110,0x2110,0x2110,0x2910,0x290F,0x210F,0x290F,0x2930,0x2930,0x2910,0x2910,0x2910,0x210F,0x2930,0x290F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2130,0x1910,0x2131,0x2151,0x1932,0x08F1,0x19B5,0x21F6,0x21F7,0x19B5,0x0913,0x1112,0x1931,0x2130,0x2110,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2950,0x212F,0x212F,0x212F,0x2110,0x1930,0x1951,0x1152,0x1153,0x1995,0x21F7,0x21F7,0x1996,0x1134,0x1153,0x1932,0x1931,0x2131,0x2130,0x2130,0x210F,0x2110,0x2930,0x210F,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x290F,0x290F,0x2910,0x2910,0x2110,0x2110,0x2111,0x1932,0x1113,0x11B7,0x19F8,0x1A19,0x19D7,0x1132,0x1931,0x1910,0x2110,0x2130,0x2130,0x2110,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x2130,0x210F,0x2130,0x2110,0x2110,0x2910,0x210F,0x2910,0x2930,0x2930,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2111,0x1911,0x1911,0x1932,0x1133,0x1153,0x1974,0x21F7,0x2A17,0x21F7,0x1154,0x1113,0x1932,0x1952,0x1952,0x1931,0x2131,0x2130,0x2130,0x210F,0x212F,0x292F,0x210F,0x210F,0x290F,0x290F,0x212F,0x212F,0x212F,0x2930,0x212F,0x210F,0x290F,0x2930,0x210F,0x210F,0x290F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2930,0x212F,0x212F,0x212F,0x2930,0x2930,0x292F,0x290F,0x2930,0x2110,0x2130,0x2130,0x2131,0x1931,0x1132,0x1133,0x21D6,0x2A38,0x21F7,0x1194,0x0912,0x1132,0x1931,0x1931,0x1910,0x2110,0x2130,0x2131,0x1931,0x1931,0x1932,0x1133,0x21D6,0x2A17,0x21F6,0x1995,0x0912,0x1932,0x2152,0x1931,0x2131,0x2130,0x2130,0x2110,0x2930,0x2930,0x2110,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x2930,0x210F,0x2910,0x2910,0x2930,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x212F,0x290F,0x290F,0x212F,0x212F,0x292F,0x292F,0x292F,0x210F,0x290F,0x290F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x290F,0x292F,0x210F,0x210F,0x212F,0x2130,0x2110,0x2130,0x2151,0x1932,0x1132,0x1133,0x1995,0x21D6,0x19D5,0x1974,0x10F1,0x1911,0x1931,0x2131,0x1910,0x2131,0x1931,0x1931,0x1112,0x1174,0x19F7,0x1A18,0x19F8,0x1195,0x1112,0x1911,0x2111,0x2110,0x2110,0x2130,0x2110,0x2930,0x2110,0x212F,0x210F,0x2930,0x2930,0x212F,0x2110,0x2110,0x210F,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2930,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x1910,0x2131,0x2131,0x1931,0x1911,0x1932,0x1153,0x1995,0x21F7,0x21F7,0x21D6,0x19B5,0x1133,0x1112,0x1912,0x1911,0x2131,0x2131,0x2130,0x2930,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x292F,0x292F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x2930,0x2110,0x210F,0x2110,0x2130,0x2130,0x2930,0x2131,0x2131,0x2131,0x1931,0x1931,0x1953,0x1974,0x19B5,0x19B6,0x1996,0x19D6,0x19D7,0x19F7,0x19F7,0x19F7,0x19F7,0x1A17,0x19F7,0x19F7,0x19F7,0x19D7,0x19D7,0x19D7,0x19D7,0x19D7,0x19F7,0x19F7,0x11D7,0x11D7,0x19F7,0x19F7,0x19F7,0x19F7,0x11D6,0x11B6,0x11B5,0x11B5,0x19B5,0x1994,0x1994,0x1152,0x1132,0x1931,0x1931,0x2151,0x1931,0x1931,0x1132,0x1133,0x1154,0x1195,0x19D7,0x1A18,0x19F7,0x19B6,0x1174,0x1133,0x1112,0x1132,0x1932,0x1932,0x1932,0x1132,0x1133,0x1154,0x1995,0x19D7,0x2218,0x19F8,0x19B6,0x1154,0x0912,0x1112,0x1932,0x1931,0x2130,0x2110,0x2130,0x212F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2930,0x212F,0x2130,0x2110,0x2110,0x210F,0x290F,0x292F,
  0x1133,0x0934,0x1155,0x1196,0x11B7,0x11D8,0x11D8,0x11F8,0x11F8,0x11D7,0x1196,0x1175,0x1154,0x1953,0x1932,0x1911,0x2131,0x2131,0x2110,0x2110,0x2130,0x2130,0x2150,0x2150,0x1930,0x1930,0x1910,0x1131,0x1132,0x1994,0x19B6,0x21F7,0x2218,0x19D7,0x1995,0x1154,0x1933,0x1912,0x2132,0x2111,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x290F,0x2930,0x210F,0x210F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x212F,0x212F,0x210F,0x292F,0x210F,0x210F,0x2930,0x2910,0x2110,0x210F,0x2110,0x2110,0x2110,0x2930,0x2110,0x2130,0x2130,0x1910,0x1911,0x1931,0x1931,0x1932,0x1932,0x1932,0x1932,0x1112,0x1912,0x1912,0x1912,0x1911,0x1911,0x1911,0x2131,0x1910,0x2110,0x2130,0x2130,0x2130,0x2930,0x290F,0x2930,0x290F,0x290F,0x210F,0x210F,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x292F,0x2930,0x2910,0x2930,0x2930,0x210F,0x212F,0x2130,0x2130,0x2110,0x2110,0x210F,0x210F,0x2930,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x1910,0x1911,0x1931,0x1132,0x1153,0x1154,0x1195,0x11B6,0x19D6,0x19D6,0x19D6,0x1174,0x1154,0x1153,0x1132,0x1132,0x1132,0x1131,0x1131,0x1111,0x1931,0x1911,0x1932,0x1912,0x1912,0x1932,0x1932,0x1932,0x1932,0x1912,0x1932,0x1931,0x1931,0x1932,0x1932,0x1931,0x1931,0x1932,0x1932,0x1931,0x1932,0x1931,0x1931,0x1931,0x1931,0x1932,0x1932,0x1932,0x1931,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1931,0x1932,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1912,0x1912,0x1911,0x1911,0x1912,0x1912,0x1912,0x1912,0x1912,0x1911,0x1912,0x1911,0x1932,0x1912,0x1932,0x1953,0x1133,0x0934,0x0155,0x11D8,0x09D9,0x09FA,0x01B9,0x01FA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01DA,0x01DB,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01FA,0x01F9,0x01F9,0x09D8,0x11D7,0x0954,0x1112,0x1932,0x2131,0x2131,0x2110,0x2130,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2930,0x290F,0x290F,0x2930,0x290F,0x210F,0x210F,0x290F,0x2930,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x2910,0x210F,0x290F,0x290F,0x290F,0x210F,0x2110,0x2110,0x210F,0x290F,0x290F,0x210F,0x212F,0x2110,0x2110,0x2130,0x2130,0x1931,0x1112,0x0912,0x19D7,0x11F8,0x11F7,0x1196,0x1112,0x1912,0x2132,0x2131,0x2130,0x2130,0x210F,0x292F,0x292F,0x292F,0x210F,0x210F,0x2930,0x2150,0x2131,0x1911,0x1132,0x1154,0x19D6,0x19F7,0x19B6,0x19B6,0x1153,0x1111,0x2131,0x2931,0x2930,0x2910,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x1931,0x1932,0x1133,0x1154,0x1176,0x11B7,0x11D8,0x11D8,0x09D8,0x09F9,0x09D8,0x11D8,0x11D8,0x1175,0x0933,0x1132,0x1931,0x1930,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x2110,0x2930,0x2910,0x2910,0x2930,0x2930,0x210F,0x2910,0x2930,0x2110,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x290F,0x290F,0x290F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1911,0x10F1,0x1994,0x21F6,0x21F6,0x19B5,0x08F2,0x1112,0x1931,0x2130,0x2130,0x2930,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x1931,0x1132,0x1153,0x1154,0x21F7,0x21F7,0x21F7,0x1154,0x0913,0x1132,0x1931,0x2131,0x2130,0x212F,0x212F,0x210F,0x212F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x2930,0x290F,0x210F,0x2110,0x2110,0x2131,0x1932,0x1113,0x11B6,0x19F8,0x1A19,0x19D7,0x1133,0x1911,0x2131,0x2130,0x2110,0x2930,0x2110,0x2110,0x2910,0x2910,0x210F,0x2130,0x210F,0x2130,0x2110,0x2110,0x2110,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2130,0x210F,0x210F,0x212F,0x212F,0x2130,0x210F,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x212F,0x2930,0x2910,0x2910,0x2110,0x210F,0x2910,0x2110,0x2930,0x212F,0x212F,0x212F,0x2930,0x2130,0x2130,0x1910,0x1911,0x1932,0x1932,0x1133,0x1153,0x1975,0x21F7,0x2A17,0x21F7,0x1954,0x1112,0x1112,0x1932,0x1931,0x1931,0x1910,0x1930,0x2130,0x2130,0x210F,0x212F,0x292F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x292F,0x210F,0x290F,0x2110,0x210F,0x2110,0x2130,0x2130,0x2130,0x212F,0x2930,0x210F,0x212F,0x210F,0x212F,0x212F,0x292F,0x290F,0x210F,0x2930,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x21B6,0x2A38,0x2217,0x1995,0x0912,0x1132,0x1952,0x1931,0x2131,0x2130,0x2130,0x2130,0x1931,0x1931,0x1132,0x1133,0x21B5,0x2A17,0x21F6,0x19B5,0x0912,0x1112,0x1952,0x2151,0x2131,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x210F,0x212F,0x2930,0x292F,0x212F,0x212F,0x2110,0x2930,0x2110,0x2930,0x2130,0x2110,0x2130,0x2130,0x2930,0x2930,0x290F,0x290F,0x290F,0x2910,0x2910,0x210F,0x2910,0x210F,0x290F,0x2930,0x210F,0x210F,0x2930,0x290F,0x210F,0x292F,0x212F,0x292F,0x212F,0x212F,0x290F,0x210F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x292F,0x292F,0x2930,0x210F,0x210F,0x212F,0x2130,0x2130,0x2110,0x1931,0x1931,0x1132,0x1133,0x1995,0x21D6,0x21D5,0x1994,0x1111,0x1911,0x2131,0x2131,0x2131,0x1910,0x1930,0x1931,0x1112,0x1153,0x19F7,0x1A18,0x19F8,0x1196,0x1112,0x1911,0x2131,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x212F,0x212F,0x2930,0x212F,0x212F,0x210F,0x2930,0x210F,0x212F,0x2110,0x210F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2910,0x2910,0x210F,0x2110,0x210F,0x2930,0x2910,0x2910,0x2910,0x210F,0x2930,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2110,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2110,0x2130,0x2131,0x2131,0x2131,0x1911,0x1932,0x1153,0x1974,0x21F6,0x2217,0x21F7,0x1995,0x1133,0x1112,0x1911,0x1911,0x2131,0x2111,0x2930,0x2130,0x2930,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x290F,0x290F,0x292F,0x210F,0x290F,0x290F,0x2910,0x2930,0x290F,0x2930,0x2930,0x210F,0x292F,0x210F,0x210F,0x290F,0x2930,0x212F,0x2930,0x2130,0x2130,0x2130,0x2131,0x2110,0x2131,0x1932,0x1932,0x1953,0x1154,0x1174,0x1174,0x1175,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1995,0x1175,0x1195,0x1175,0x1175,0x1195,0x1195,0x1195,0x1195,0x1195,0x1174,0x1174,0x1194,0x1174,0x1174,0x1153,0x1153,0x1952,0x1131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1132,0x1153,0x1195,0x19D6,0x2218,0x1A17,0x19D6,0x1175,0x1133,0x1132,0x1132,0x1932,0x1931,0x1932,0x1132,0x1133,0x1154,0x1995,0x19D7,0x21F8,0x21F8,0x19D7,0x1175,0x0913,0x1112,0x1111,0x2151,0x2151,0x2130,0x210F,0x210F,0x210F,0x292F,0x292F,0x292F,0x290F,0x290F,0x290F,0x2110,0x2110,0x2130,0x2110,0x2130,0x212F,0x210F,0x212F,0x292F,0x292F,0x212F,0x212F,0x210F,0x212F,0x292F,0x210F,0x210F,0x2110,0x290F,0x210F,0x292F,0x292F,
  0x1112,0x1133,0x1133,0x1154,0x1196,0x11B7,0x11F8,0x11F8,0x11F8,0x11F8,0x11D7,0x1196,0x1175,0x1133,0x1133,0x1952,0x2131,0x2131,0x1910,0x2130,0x2110,0x2130,0x2130,0x2150,0x2150,0x1930,0x1910,0x1911,0x1952,0x1133,0x1995,0x19B6,0x2218,0x2218,0x19D7,0x1175,0x1154,0x1133,0x1912,0x2132,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2930,0x212F,0x2930,0x212F,0x292F,0x212F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x210F,0x2110,0x2910,0x210F,0x2910,0x2930,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x290F,0x2930,0x2130,0x2930,0x2930,0x210F,0x210F,0x210F,0x2910,0x2130,0x2130,0x2130,0x1910,0x1910,0x1931,0x1931,0x1911,0x1952,0x1932,0x1932,0x1912,0x1911,0x1931,0x2131,0x2131,0x2131,0x2130,0x2131,0x2130,0x2110,0x2130,0x2130,0x2110,0x210F,0x210F,0x2910,0x210F,0x2910,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1132,0x1133,0x1154,0x1195,0x19D6,0x1A17,0x11B6,0x0954,0x0954,0x0953,0x1133,0x0932,0x1132,0x0912,0x1112,0x1111,0x1111,0x1112,0x1112,0x1112,0x1112,0x10F2,0x10F2,0x1112,0x1112,0x10F2,0x1112,0x1112,0x1112,0x1112,0x1112,0x1111,0x1111,0x1112,0x1112,0x1112,0x1112,0x10F1,0x1111,0x1112,0x1111,0x1112,0x1112,0x1111,0x1111,0x1112,0x1111,0x1111,0x1112,0x10F1,0x10F1,0x1111,0x1111,0x1112,0x1112,0x1132,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1912,0x1912,0x1912,0x1912,0x1912,0x1912,0x1912,0x10F2,0x10F2,0x1112,0x1112,0x1112,0x1113,0x0913,0x0914,0x0176,0x09B8,0x09D9,0x01B9,0x01D9,0x01D9,0x021A,0x01FA,0x01D9,0x01DA,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x021A,0x01FA,0x01FA,0x01FA,0x01FA,0x01F9,0x01F9,0x11F8,0x11F7,0x1154,0x1112,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2110,0x2930,0x2930,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x2910,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2110,0x1911,0x1112,0x1133,0x19F7,0x1A18,0x1A18,0x1196,0x1113,0x1912,0x2132,0x2131,0x2130,0x2130,0x210F,0x2930,0x292F,0x292F,0x212F,0x210F,0x212F,0x2150,0x2131,0x1931,0x1132,0x1154,0x21F7,0x21F7,0x19D6,0x19B5,0x1133,0x1112,0x2131,0x2931,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2131,0x1932,0x1932,0x1133,0x1154,0x1196,0x11B7,0x11D8,0x09B8,0x11D8,0x11D8,0x1197,0x1176,0x0933,0x1132,0x1931,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2930,0x2910,0x2910,0x2930,0x2110,0x2910,0x2910,0x2110,0x2910,0x2910,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x2930,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x10F1,0x1994,0x21F6,0x19D6,0x1995,0x0912,0x1112,0x1931,0x1930,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2130,0x212F,0x212F,0x2130,0x2130,0x1910,0x1931,0x1932,0x1132,0x1195,0x2217,0x2A38,0x19B6,0x0913,0x1132,0x1111,0x1931,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x294F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x2930,0x20EF,0x210F,0x2110,0x2131,0x1932,0x1113,0x11B6,0x19F8,0x1A19,0x19D7,0x1113,0x1911,0x2111,0x2110,0x2110,0x2930,0x2910,0x2910,0x2910,0x210F,0x2110,0x212F,0x212F,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x210F,0x210F,0x212F,0x2130,0x212F,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2930,0x210F,0x212F,0x2930,0x2930,0x2910,0x2910,0x2930,0x2110,0x2930,0x2110,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1932,0x1933,0x1133,0x1133,0x1975,0x21F7,0x2A17,0x21F6,0x1954,0x1133,0x1112,0x1932,0x1952,0x1951,0x1931,0x1930,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2930,0x2930,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x210F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1932,0x1932,0x1133,0x19B5,0x2A38,0x21F7,0x1195,0x0933,0x1112,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x1930,0x1931,0x1132,0x1112,0x21B5,0x2A17,0x21F6,0x1994,0x0912,0x1111,0x1952,0x2151,0x2131,0x2110,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x210F,0x210F,0x212F,0x2930,0x210F,0x2110,0x2910,0x2110,0x2110,0x2110,0x2130,0x2930,0x290F,0x290F,0x2930,0x2910,0x2910,0x2930,0x2910,0x2910,0x2910,0x2930,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x212F,0x210F,0x212F,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x2930,0x2930,0x210F,0x212F,0x2130,0x210F,0x2110,0x2131,0x1932,0x1932,0x1132,0x19B5,0x21F6,0x21D5,0x1994,0x1112,0x1911,0x1931,0x2131,0x2131,0x2131,0x1910,0x1911,0x1111,0x1153,0x19F7,0x1A18,0x1A18,0x1195,0x1132,0x1931,0x2131,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x2110,0x2130,0x292F,0x212F,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x290F,0x210F,0x210F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2910,0x2910,0x290F,0x28EF,0x290F,0x210F,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x2111,0x1911,0x1912,0x1933,0x1995,0x21F7,0x2217,0x21F7,0x1975,0x1133,0x1932,0x1911,0x1911,0x2131,0x2130,0x2130,0x2930,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x292F,0x290F,0x292F,0x292F,0x212F,0x2110,0x2930,0x290F,0x290F,0x292F,0x292F,0x212F,0x212F,0x292F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2130,0x2130,0x2131,0x1931,0x1932,0x1132,0x1132,0x1132,0x1152,0x1153,0x1153,0x1153,0x1153,0x1953,0x1153,0x1133,0x1953,0x1953,0x1933,0x1133,0x1132,0x1933,0x1133,0x1133,0x1153,0x1133,0x1153,0x1153,0x1153,0x1973,0x1973,0x1153,0x1132,0x1132,0x1132,0x1931,0x1952,0x1931,0x1931,0x1931,0x2152,0x1932,0x1112,0x1112,0x1133,0x1195,0x19D6,0x2217,0x19F7,0x19D6,0x1195,0x1154,0x1153,0x1132,0x1131,0x1131,0x1111,0x1132,0x1133,0x1174,0x1195,0x19D7,0x19F7,0x19F7,0x19D7,0x1175,0x1133,0x1112,0x1111,0x1931,0x2151,0x2150,0x2130,0x2130,0x2130,0x212F,0x210F,0x290F,0x292F,0x292F,0x290F,0x290F,0x2910,0x2930,0x2110,0x210F,0x2130,0x292F,0x292F,0x292F,0x210F,0x292F,0x212F,0x292F,0x210F,0x212F,0x212F,0x292F,0x2930,0x210F,0x210F,0x290F,0x292F,0x292F,
  0x1911,0x1932,0x1932,0x1153,0x1175,0x1196,0x11B7,0x11D8,0x11F8,0x11F9,0x11F8,0x11D7,0x11B6,0x1154,0x1154,0x1132,0x1932,0x1931,0x2131,0x2130,0x2110,0x2130,0x212F,0x2130,0x2130,0x1930,0x2130,0x2131,0x1911,0x1932,0x1133,0x1154,0x19B6,0x2217,0x2218,0x19D7,0x1995,0x1133,0x1112,0x1932,0x2152,0x2151,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x292F,0x290F,0x292F,0x290F,0x290F,0x210F,0x2930,0x2930,0x210F,0x212F,0x210F,0x2910,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x212F,0x292F,0x210F,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x2110,0x210F,0x290F,0x2930,0x290F,0x2930,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1911,0x1931,0x1911,0x1911,0x1911,0x1931,0x1911,0x1910,0x2131,0x2131,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2110,0x210F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x2930,0x210F,0x210F,0x2910,0x210F,0x210F,0x2910,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x212F,0x292F,0x292F,0x210F,0x2930,0x210F,0x2110,0x2910,0x2930,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x1153,0x1154,0x19B6,0x19D6,0x2218,0x1196,0x1175,0x0954,0x1154,0x0953,0x0933,0x0932,0x0932,0x0932,0x1132,0x0932,0x1113,0x1113,0x1113,0x1113,0x10F3,0x1113,0x1113,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1132,0x1133,0x1132,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1112,0x1133,0x1113,0x1113,0x1113,0x1113,0x1113,0x1113,0x1133,0x1133,0x1133,0x1134,0x0934,0x0955,0x0955,0x0176,0x01B8,0x01D9,0x01D9,0x01D9,0x01B9,0x01FA,0x01DA,0x01DA,0x01DA,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FA,0x01FA,0x0A1A,0x09F9,0x11F8,0x19F7,0x1175,0x1112,0x1931,0x1931,0x2131,0x2130,0x2130,0x210F,0x210F,0x2130,0x210F,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2930,0x290F,0x210F,0x212F,0x292F,0x292F,0x210F,0x2930,0x290F,0x2930,0x210F,0x210F,0x2910,0x2930,0x2930,0x210F,0x212F,0x292F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2131,0x1931,0x1932,0x0933,0x19D7,0x1A18,0x1A18,0x11B6,0x1113,0x1932,0x2131,0x2131,0x2130,0x2130,0x212F,0x292F,0x292F,0x212F,0x212F,0x2950,0x212F,0x2130,0x2131,0x1932,0x1132,0x1154,0x19D6,0x19F7,0x19D6,0x19B6,0x1153,0x1112,0x2131,0x2130,0x2930,0x210F,0x212F,0x212F,0x290F,0x2930,0x210F,0x2110,0x2110,0x2110,0x1931,0x1932,0x1933,0x1133,0x1155,0x1196,0x1196,0x11B7,0x11B7,0x11B7,0x1196,0x0934,0x1133,0x1132,0x1931,0x2131,0x2131,0x2130,0x2130,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2930,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x1911,0x10F1,0x1994,0x21F6,0x19D6,0x19B5,0x08F2,0x1112,0x1931,0x1930,0x2150,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x2950,0x212F,0x212F,0x2130,0x2130,0x1910,0x1931,0x1932,0x1132,0x1195,0x2217,0x2A38,0x1195,0x1133,0x1132,0x1931,0x1930,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x290F,0x290F,0x210F,0x290F,0x290F,0x20EF,0x210F,0x2110,0x2131,0x1932,0x1133,0x1196,0x1A19,0x1A19,0x19F8,0x1113,0x1912,0x2131,0x2110,0x2110,0x2110,0x2910,0x2930,0x2930,0x210F,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2930,0x212F,0x210F,0x212F,0x212F,0x2930,0x212F,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x290F,0x2930,0x2910,0x2910,0x2110,0x2910,0x2110,0x2930,0x2130,0x2130,0x210F,0x2130,0x2130,0x2131,0x1911,0x1932,0x1953,0x1153,0x1133,0x1174,0x21F7,0x2A17,0x21F6,0x1974,0x10F2,0x1912,0x1931,0x1931,0x1951,0x1930,0x1930,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2910,0x290F,0x290F,0x2930,0x290F,0x290F,0x2930,0x210F,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2910,0x290F,0x292F,0x290F,0x292F,0x292F,0x292F,0x292F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1932,0x1932,0x1133,0x19B5,0x2A38,0x19D6,0x19B5,0x0933,0x1132,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x1930,0x1931,0x1132,0x1132,0x21D5,0x2217,0x21D6,0x1995,0x1112,0x1112,0x2152,0x2151,0x2131,0x2110,0x2110,0x2130,0x2930,0x2110,0x2110,0x2930,0x210F,0x212F,0x292F,0x212F,0x2910,0x210F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2130,0x2930,0x210F,0x290F,0x2930,0x290F,0x2910,0x2910,0x2910,0x2910,0x210F,0x290F,0x290F,0x2930,0x210F,0x290F,0x2930,0x290F,0x292F,0x212F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x2930,0x2930,0x210F,0x210F,0x2130,0x2130,0x210F,0x2130,0x2131,0x1931,0x1932,0x1132,0x1994,0x21F6,0x21D5,0x1994,0x1112,0x1911,0x1931,0x2131,0x2131,0x2131,0x1910,0x1931,0x1131,0x1153,0x19F7,0x1A18,0x19F7,0x11B6,0x1132,0x1931,0x1910,0x2110,0x2130,0x2130,0x2130,0x2110,0x210F,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x2930,0x290F,0x2930,0x290F,0x2930,0x212F,0x2930,0x212F,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2130,0x212F,0x210F,0x210F,0x2930,0x2930,0x210F,0x2930,0x210F,0x2930,0x2910,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2110,0x2130,0x212F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2910,0x28F0,0x2910,0x290F,0x290F,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2111,0x18F1,0x18F1,0x1932,0x1133,0x1995,0x21F7,0x21F7,0x21F7,0x1995,0x1953,0x1112,0x1911,0x1911,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x2930,0x292F,0x2930,0x292F,0x2130,0x2110,0x2130,0x2930,0x212F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x2930,0x2130,0x2130,0x2131,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1932,0x1932,0x1932,0x1912,0x1932,0x1932,0x1911,0x1911,0x1932,0x1932,0x1911,0x1911,0x1912,0x1932,0x1912,0x1932,0x1932,0x1112,0x1132,0x1132,0x1932,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x2132,0x1931,0x1111,0x1112,0x0933,0x1174,0x19D6,0x21F7,0x2217,0x19D6,0x1174,0x1153,0x1133,0x1932,0x1132,0x1932,0x1132,0x1132,0x1132,0x1153,0x19B5,0x19B6,0x19F7,0x21F8,0x19B7,0x1175,0x1134,0x1132,0x1911,0x1931,0x1910,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x292F,0x292F,0x292F,0x290F,0x290F,0x210F,0x210F,0x2930,0x2110,0x210F,0x210F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x292F,0x210F,0x290F,0x212F,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x292F,
  0x1931,0x1931,0x1912,0x1933,0x1154,0x1175,0x1196,0x11B7,0x11D8,0x11F8,0x1219,0x11F8,0x11D7,0x1196,0x1154,0x1133,0x1112,0x1932,0x2131,0x2131,0x2130,0x2150,0x192F,0x192F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1931,0x10F1,0x1112,0x1154,0x19B6,0x21F7,0x2218,0x19D6,0x1995,0x1113,0x1112,0x1952,0x1952,0x2151,0x2130,0x2130,0x2130,0x2130,0x2930,0x212F,0x212F,0x212F,0x210F,0x210F,0x292F,0x290F,0x292F,0x290F,0x210F,0x290F,0x290F,0x212F,0x210F,0x2930,0x2110,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x2910,0x2930,0x2910,0x2910,0x210F,0x290F,0x290F,0x2930,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x2930,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x290F,0x290F,0x2110,0x2930,0x2130,0x2130,0x1910,0x2130,0x2131,0x2131,0x2131,0x2110,0x2110,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2910,0x2910,0x2930,0x2930,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x210F,0x210F,0x290F,0x290F,0x2930,0x2930,0x210F,0x2910,0x2930,0x2930,0x2110,0x2110,0x210F,0x2910,0x2910,0x290F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2930,0x2930,0x2910,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x1953,0x1154,0x1996,0x19B6,0x21F7,0x19F7,0x19D6,0x19B6,0x19B5,0x19B5,0x19B5,0x19B5,0x19D5,0x19B5,0x19B5,0x19B5,0x19B6,0x1995,0x1996,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x21B5,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1995,0x1994,0x1994,0x1995,0x1994,0x19B5,0x1995,0x1995,0x1995,0x1995,0x1995,0x21B5,0x19B6,0x19B6,0x21B6,0x21D6,0x21D6,0x21D6,0x19B6,0x19D6,0x19D6,0x19D7,0x19D7,0x19D7,0x11D8,0x11F9,0x09D9,0x01F9,0x01FA,0x01B9,0x01B9,0x01D9,0x01D9,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01FA,0x01FA,0x01FA,0x01FA,0x01DA,0x01FA,0x01FB,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01D9,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01D9,0x01D9,0x09F9,0x11F8,0x11D7,0x1154,0x1112,0x1932,0x1931,0x2130,0x2130,0x2110,0x2110,0x210F,0x2130,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x2930,0x290F,0x210F,0x212F,0x2930,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x292F,0x212F,0x212F,0x2930,0x210F,0x290F,0x290F,0x2930,0x290F,0x2930,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2130,0x2110,0x1931,0x1932,0x1133,0x19F7,0x1A18,0x19F8,0x11B6,0x1113,0x1912,0x2131,0x2131,0x2130,0x2130,0x212F,0x292F,0x212F,0x210F,0x210F,0x212F,0x2930,0x2130,0x1910,0x1911,0x1132,0x1154,0x19D6,0x19D7,0x19B6,0x19B5,0x1154,0x1112,0x1931,0x2130,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x210F,0x2130,0x2130,0x2131,0x1952,0x1952,0x1133,0x0933,0x1195,0x1196,0x11B7,0x11B7,0x1196,0x1175,0x1133,0x1132,0x1931,0x1931,0x2131,0x2130,0x2130,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2930,0x2110,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x212F,0x210F,0x210F,0x2930,0x212F,0x210F,0x2130,0x2130,0x2110,0x2130,0x2131,0x2131,0x1911,0x10F1,0x2194,0x2A16,0x21D6,0x1994,0x0912,0x1112,0x1931,0x1951,0x2130,0x212F,0x212F,0x2950,0x210F,0x210F,0x2950,0x2950,0x210F,0x212F,0x212F,0x2130,0x2131,0x1931,0x1132,0x0912,0x19B5,0x2A38,0x19F7,0x1175,0x1113,0x1132,0x1931,0x2151,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x214F,0x214F,0x214F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x210F,0x292F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2110,0x2131,0x2131,0x1932,0x1113,0x1196,0x19F8,0x1A19,0x19D7,0x1113,0x1912,0x2131,0x2131,0x2110,0x2110,0x2910,0x2910,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x290F,0x2930,0x290F,0x210F,0x210F,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x290F,0x2910,0x2910,0x2910,0x2930,0x2130,0x2930,0x2130,0x2130,0x2130,0x2131,0x1931,0x1952,0x1953,0x1133,0x1153,0x1174,0x2217,0x2A17,0x21D6,0x1954,0x1112,0x10F1,0x1911,0x1931,0x1931,0x2151,0x2150,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x292F,0x210F,0x212F,0x2130,0x2130,0x2930,0x2930,0x210F,0x212F,0x290F,0x2930,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2910,0x292F,0x292F,0x290F,0x290F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1932,0x1932,0x1133,0x19B5,0x2A38,0x21F7,0x1195,0x0913,0x1132,0x1952,0x1931,0x2131,0x2130,0x2130,0x2130,0x1910,0x1931,0x1932,0x1132,0x21F6,0x2A37,0x21F6,0x1994,0x0912,0x1132,0x1952,0x2131,0x2131,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x212F,0x2930,0x2930,0x290F,0x210F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2910,0x210F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x292F,0x292F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x292F,0x212F,0x212F,0x2930,0x2930,0x212F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1932,0x1132,0x1994,0x21F6,0x21D5,0x1973,0x1112,0x1911,0x2131,0x2131,0x2131,0x1910,0x1930,0x1931,0x1111,0x1153,0x1A17,0x1A38,0x1A17,0x1195,0x1132,0x1911,0x1910,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x210F,0x2110,0x2930,0x2110,0x210F,0x210F,0x2130,0x2930,0x2130,0x2930,0x210F,0x210F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2951,0x2131,0x2111,0x1911,0x1912,0x1133,0x1975,0x21D7,0x2A18,0x21D7,0x19B5,0x1153,0x1132,0x1111,0x1931,0x2131,0x2951,0x2930,0x2130,0x212F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2930,0x2930,0x2130,0x2130,0x2950,0x2130,0x2130,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1930,0x1930,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x2132,0x1911,0x1911,0x2131,0x1911,0x1910,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x1931,0x2151,0x2131,0x1911,0x1111,0x1112,0x1133,0x1174,0x19B6,0x21F7,0x2217,0x19D6,0x1154,0x1133,0x1132,0x1132,0x1952,0x1952,0x1932,0x1132,0x1132,0x1153,0x1175,0x19B6,0x21F7,0x21F8,0x19D7,0x1175,0x1113,0x1112,0x1111,0x2132,0x2151,0x2151,0x1910,0x210F,0x210F,0x2130,0x2130,0x212F,0x210F,0x290F,0x292F,0x292F,0x210F,0x210F,0x290F,0x2910,0x290F,0x2910,0x290F,0x212F,0x292F,0x212F,0x292F,0x292F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,
  0x2151,0x1911,0x1911,0x1932,0x1933,0x1133,0x1175,0x1196,0x11D7,0x11F8,0x11F8,0x11F9,0x11F8,0x11D7,0x1196,0x1154,0x1133,0x1132,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x2110,0x2151,0x2130,0x2111,0x1911,0x1912,0x1133,0x1974,0x19B6,0x2217,0x2217,0x19D6,0x1995,0x1133,0x1132,0x1132,0x1932,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x292F,0x212F,0x212F,0x2110,0x2110,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x290F,0x2910,0x2910,0x2930,0x290F,0x290F,0x2910,0x2110,0x2930,0x2910,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x212F,0x212F,0x212F,0x210F,0x290F,0x210F,0x290F,0x2110,0x2930,0x2910,0x210F,0x2910,0x2910,0x210F,0x2930,0x290F,0x2930,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x2910,0x2910,0x2910,0x210F,0x2930,0x210F,0x290F,0x2910,0x2910,0x2910,0x290F,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x2930,0x290F,0x2930,0x2910,0x2930,0x2910,0x2110,0x2110,0x2930,0x2930,0x2110,0x2910,0x210F,0x290F,0x210F,0x2110,0x210F,0x2110,0x210F,0x2930,0x2910,0x2110,0x2910,0x2910,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x212F,0x2130,0x2130,0x2130,0x2150,0x2150,0x2130,0x1931,0x1931,0x1932,0x1133,0x1954,0x1975,0x19D6,0x2217,0x2217,0x21F7,0x2217,0x2217,0x2217,0x2217,0x2A37,0x2A37,0x2A38,0x2A38,0x2A38,0x3238,0x3238,0x3238,0x2A38,0x2A38,0x2A38,0x3238,0x2A18,0x2A18,0x2A38,0x2A38,0x2A38,0x2A38,0x2A38,0x2A38,0x2A38,0x2A38,0x3238,0x2A38,0x2A38,0x2A38,0x2A37,0x2A38,0x2A37,0x2A37,0x2A38,0x2A38,0x2A38,0x2A37,0x2A17,0x3238,0x3238,0x2A37,0x2A37,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x2A37,0x2A37,0x2A17,0x29F7,0x2A17,0x2A17,0x2A17,0x21F7,0x2A17,0x21F7,0x21F7,0x21F7,0x2218,0x2217,0x2217,0x19F7,0x19F8,0x1A18,0x19F8,0x11F8,0x1219,0x01F9,0x09FA,0x01D9,0x01D9,0x01D9,0x01B9,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01D9,0x01DA,0x01DA,0x01B9,0x01DA,0x01DA,0x01D9,0x01D9,0x09D8,0x11F8,0x11D7,0x1154,0x1132,0x1931,0x2131,0x1910,0x2130,0x2110,0x2110,0x210F,0x2130,0x210F,0x2930,0x210F,0x290F,0x290F,0x292F,0x290F,0x2910,0x2910,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x290F,0x290F,0x2930,0x210F,0x2130,0x2130,0x2130,0x1911,0x1112,0x1133,0x19D7,0x1A18,0x19F7,0x11B6,0x1113,0x1912,0x2131,0x2110,0x2130,0x2130,0x212F,0x210F,0x292F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x1911,0x1132,0x1154,0x19D6,0x2217,0x19D6,0x19B6,0x1133,0x1112,0x2131,0x2130,0x2930,0x290F,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2110,0x2131,0x1931,0x1931,0x1932,0x1132,0x1133,0x1174,0x11B6,0x1196,0x11B6,0x11B6,0x1154,0x1112,0x1132,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x212F,0x2910,0x2930,0x210F,0x2930,0x2910,0x2110,0x2910,0x2910,0x2910,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2910,0x2110,0x2110,0x2130,0x290F,0x290F,0x2930,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x210F,0x2930,0x212F,0x210F,0x2130,0x2110,0x2130,0x2110,0x2130,0x2131,0x1911,0x10D0,0x1994,0x2A16,0x21F6,0x19B5,0x0912,0x1112,0x1931,0x1931,0x2130,0x210F,0x212F,0x2950,0x210F,0x210F,0x2950,0x2130,0x212F,0x212F,0x2130,0x2130,0x1931,0x1952,0x1132,0x0912,0x19D6,0x2218,0x11B6,0x1175,0x1133,0x1932,0x1951,0x2131,0x2130,0x2130,0x212F,0x2130,0x2150,0x212F,0x210F,0x212F,0x212F,0x212F,0x214F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x292F,0x210F,0x2910,0x2110,0x2131,0x2152,0x1932,0x0913,0x11B7,0x19F8,0x1A19,0x19D8,0x1113,0x1932,0x2111,0x2111,0x2110,0x2110,0x2910,0x2930,0x210F,0x2930,0x2930,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x210F,0x290F,0x2930,0x290F,0x290F,0x2910,0x2930,0x290F,0x2930,0x2930,0x2930,0x210F,0x210F,0x290F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x292F,0x290F,0x2910,0x2910,0x2910,0x20EF,0x2910,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x1931,0x1932,0x1953,0x1153,0x1153,0x1174,0x21F7,0x2A38,0x21D6,0x1974,0x1932,0x1111,0x1911,0x1911,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x212F,0x210F,0x210F,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2110,0x2110,0x2110,0x210F,0x290F,0x290F,0x210F,0x292F,0x290F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x1931,0x1931,0x1132,0x1133,0x19B5,0x2217,0x21F7,0x11B5,0x0913,0x1132,0x1932,0x1931,0x2131,0x2110,0x2130,0x2130,0x2130,0x1931,0x1132,0x1132,0x21F5,0x2216,0x21F6,0x19B5,0x0912,0x1132,0x2152,0x2151,0x2151,0x2130,0x2110,0x2110,0x2110,0x2930,0x210F,0x210F,0x292F,0x2930,0x210F,0x210F,0x290F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x210F,0x2910,0x2910,0x210F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x290F,0x292F,0x292F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x2930,0x2930,0x2930,0x2130,0x2110,0x2110,0x2130,0x2130,0x2131,0x2151,0x1932,0x1112,0x1994,0x21F6,0x21D5,0x21B4,0x1111,0x1911,0x2131,0x2131,0x2131,0x2130,0x2130,0x1931,0x1131,0x1132,0x19F6,0x1A38,0x1A17,0x11B5,0x1132,0x1931,0x2131,0x2130,0x2130,0x2110,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x2930,0x2910,0x2110,0x2910,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x210F,0x2110,0x2930,0x2110,0x2910,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2110,0x2130,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2111,0x1912,0x1912,0x1133,0x1995,0x21D7,0x2A18,0x21F7,0x1995,0x1154,0x1132,0x1111,0x1911,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2930,0x2130,0x2130,0x2150,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x1930,0x1931,0x1931,0x1931,0x1931,0x2111,0x2131,0x2131,0x2131,0x2111,0x2110,0x2131,0x2111,0x2111,0x2111,0x2131,0x2131,0x2111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1931,0x2131,0x1931,0x2131,0x1931,0x1931,0x1931,0x1911,0x1911,0x1132,0x1133,0x1174,0x19B5,0x21F7,0x2217,0x19B6,0x1174,0x1133,0x1132,0x1132,0x1132,0x1932,0x1952,0x1132,0x1153,0x1153,0x1174,0x19B6,0x21F7,0x19F7,0x19D7,0x1175,0x1113,0x1112,0x1911,0x1911,0x2131,0x2151,0x2130,0x210F,0x210F,0x2130,0x2130,0x210F,0x212F,0x292F,0x292F,0x290F,0x290F,0x292F,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x292F,0x210F,0x292F,0x292F,0x212F,0x212F,0x292F,0x290F,0x212F,0x210F,0x290F,0x290F,0x210F,0x292F,0x290F,0x210F,
  0x2131,0x2131,0x1911,0x1911,0x1912,0x1932,0x1133,0x1154,0x1175,0x11B7,0x11F8,0x11F9,0x11F8,0x11F8,0x11D7,0x1195,0x1154,0x1133,0x1132,0x1932,0x1911,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2131,0x1931,0x1911,0x1112,0x1112,0x1174,0x19D6,0x19F7,0x1A17,0x21F7,0x1195,0x0953,0x1132,0x1112,0x2152,0x2131,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x290F,0x292F,0x210F,0x290F,0x290F,0x2130,0x212F,0x210F,0x210F,0x210F,0x290F,0x2930,0x2930,0x290F,0x210F,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x2930,0x2110,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2930,0x2110,0x2930,0x212F,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2930,0x2110,0x2930,0x210F,0x290F,0x290F,0x290F,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x20EF,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x20EF,0x210F,0x2910,0x210F,0x210F,0x290F,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x2910,0x290F,0x210F,0x2910,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x210F,0x210F,0x2910,0x210F,0x2910,0x210F,0x2110,0x2110,0x2910,0x2910,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x2130,0x2150,0x2130,0x2130,0x2131,0x1931,0x1932,0x1933,0x1933,0x21B5,0x21D6,0x1995,0x1995,0x19B5,0x19B5,0x21D6,0x21F6,0x21F6,0x21D6,0x21D6,0x21D6,0x21D6,0x21B6,0x21B6,0x21D6,0x21D6,0x21D6,0x21D7,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21F7,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21F6,0x21D6,0x21F6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21F6,0x21F6,0x21F6,0x21F6,0x21F6,0x21F6,0x21F6,0x21F6,0x21F6,0x21F6,0x21D6,0x21D6,0x21D6,0x21F6,0x21F6,0x21D6,0x21D6,0x21D7,0x19B6,0x19B6,0x19B6,0x11B6,0x11D7,0x11B6,0x11B7,0x09B7,0x09B8,0x09D9,0x01D9,0x01D9,0x01B8,0x01B9,0x01D9,0x01D9,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01DA,0x01DA,0x01DA,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01DA,0x01D9,0x01D9,0x09F9,0x09F9,0x09F9,0x11F8,0x19D7,0x1174,0x1112,0x1931,0x1931,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x2910,0x290F,0x290F,0x210F,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x290F,0x210F,0x2930,0x212F,0x212F,0x290F,0x290F,0x212F,0x212F,0x290F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x1931,0x1111,0x1133,0x19F7,0x1A18,0x19F8,0x1196,0x0912,0x1111,0x1931,0x2131,0x2130,0x2930,0x210F,0x210F,0x292F,0x292F,0x210F,0x212F,0x212F,0x2130,0x2131,0x1911,0x1132,0x1154,0x19B6,0x19F7,0x19D6,0x19B5,0x1133,0x1112,0x2111,0x2130,0x2110,0x290F,0x210F,0x292F,0x2930,0x2930,0x210F,0x210F,0x2110,0x2130,0x1910,0x1931,0x1932,0x1132,0x1133,0x1174,0x19D6,0x19D7,0x19F7,0x11B6,0x1154,0x1132,0x1932,0x1931,0x1910,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x210F,0x290F,0x290F,0x292F,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2910,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x210F,0x290F,0x290F,0x2910,0x210F,0x210F,0x290F,0x2930,0x212F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2131,0x1911,0x10F1,0x1974,0x21F6,0x21D5,0x1994,0x08F2,0x1112,0x1931,0x1931,0x2130,0x2130,0x2150,0x2150,0x210F,0x212F,0x212F,0x2150,0x210F,0x2130,0x2130,0x2130,0x1951,0x1932,0x1132,0x0933,0x2217,0x2238,0x19D6,0x1174,0x1133,0x1953,0x1951,0x2131,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x2130,0x2130,0x2151,0x2152,0x1112,0x0913,0x11D7,0x1A19,0x1A19,0x19D7,0x10F2,0x1912,0x2111,0x2110,0x2910,0x2910,0x210F,0x2910,0x2930,0x210F,0x2930,0x2910,0x210F,0x210F,0x2930,0x2910,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x292F,0x290F,0x2930,0x290F,0x2910,0x2930,0x2910,0x2930,0x2130,0x2130,0x2130,0x2110,0x1931,0x1911,0x1932,0x1953,0x1154,0x1174,0x21D6,0x2A17,0x21D6,0x2195,0x1112,0x10F1,0x1911,0x2131,0x2131,0x2130,0x2130,0x190F,0x2130,0x212F,0x212F,0x2130,0x212F,0x210F,0x212F,0x292F,0x292F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2930,0x2930,0x210F,0x2110,0x2930,0x2910,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x2130,0x2930,0x2130,0x210F,0x210F,0x212F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1112,0x1113,0x19B5,0x2217,0x19F7,0x11B5,0x0933,0x1112,0x1932,0x1931,0x2111,0x2130,0x2130,0x2130,0x1930,0x1931,0x1132,0x1132,0x21D5,0x2216,0x21D6,0x1994,0x1112,0x1112,0x2152,0x2151,0x2131,0x2110,0x2130,0x2110,0x2110,0x2910,0x210F,0x2930,0x2930,0x292F,0x210F,0x290F,0x290F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2930,0x290F,0x2910,0x2910,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x2930,0x210F,0x210F,0x210F,0x212F,0x2130,0x2110,0x210F,0x2130,0x2130,0x2131,0x2131,0x1932,0x1132,0x19B4,0x2A16,0x19D5,0x1994,0x1112,0x1911,0x1931,0x2131,0x1911,0x2131,0x1930,0x1931,0x1131,0x1153,0x1A16,0x1A17,0x19F7,0x11B5,0x1132,0x1931,0x1910,0x2110,0x2130,0x2130,0x2130,0x2930,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x290F,0x210F,0x2930,0x210F,0x2930,0x290F,0x210F,0x2930,0x2930,0x2930,0x2910,0x2910,0x210F,0x2930,0x2930,0x2110,0x2110,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x212F,0x2930,0x2110,0x210F,0x2910,0x210F,0x2930,0x2910,0x210F,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2111,0x1911,0x1932,0x1933,0x1975,0x21F7,0x2217,0x19F6,0x1195,0x1153,0x1112,0x10F1,0x10F0,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2951,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x2151,0x1930,0x1931,0x2131,0x2131,0x2131,0x2111,0x2111,0x2131,0x2111,0x2110,0x2131,0x2131,0x1911,0x2111,0x2131,0x1911,0x1931,0x2131,0x1911,0x1911,0x2111,0x2111,0x2111,0x2111,0x2131,0x2131,0x1911,0x1911,0x1931,0x1911,0x1932,0x1132,0x1133,0x1154,0x19B5,0x21F7,0x21F7,0x19B5,0x1174,0x1153,0x1153,0x1152,0x1132,0x1932,0x1111,0x1111,0x1132,0x1153,0x1195,0x19D6,0x19D7,0x21F7,0x19D7,0x1175,0x1133,0x10F2,0x1911,0x2111,0x2131,0x2110,0x2110,0x210F,0x2130,0x2110,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x290F,0x290F,0x210F,0x2930,0x2930,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,
  0x2131,0x1911,0x2131,0x1911,0x1911,0x1912,0x1933,0x1153,0x1154,0x1176,0x11B7,0x11F8,0x11F9,0x11F9,0x11F8,0x11D7,0x1195,0x1174,0x1133,0x1132,0x1931,0x1911,0x2131,0x2151,0x2130,0x2150,0x2130,0x2110,0x2110,0x2130,0x2131,0x2151,0x1931,0x1111,0x1133,0x1174,0x19D6,0x2217,0x1A17,0x19F6,0x19B5,0x1133,0x1132,0x1932,0x2151,0x2131,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,0x212F,0x292F,0x290F,0x290F,0x212F,0x210F,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x2930,0x2930,0x210F,0x2930,0x2910,0x2910,0x2910,0x210F,0x210F,0x290F,0x2930,0x290F,0x210F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x2130,0x212F,0x292F,0x290F,0x290F,0x2930,0x2110,0x210F,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x2910,0x290F,0x290F,0x2910,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x2910,0x2910,0x28EF,0x290F,0x290F,0x290F,0x2910,0x210F,0x2910,0x210F,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x210F,0x210F,0x210F,0x2910,0x210F,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x212F,0x212F,0x2130,0x2950,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1912,0x1912,0x1932,0x1953,0x1933,0x1953,0x1953,0x1973,0x1153,0x1973,0x1974,0x1954,0x1974,0x1974,0x1974,0x1974,0x1954,0x1954,0x1974,0x1974,0x1954,0x1974,0x1974,0x1974,0x1974,0x1974,0x1974,0x1974,0x1974,0x1974,0x1974,0x1974,0x1974,0x1974,0x1174,0x1974,0x1974,0x1974,0x1974,0x1974,0x1974,0x1954,0x1974,0x1974,0x1954,0x1974,0x1974,0x1974,0x1974,0x1174,0x1994,0x1994,0x1994,0x1974,0x1994,0x1994,0x1994,0x1994,0x1994,0x1994,0x1994,0x1994,0x1994,0x21B5,0x1995,0x19B5,0x19B6,0x21D6,0x19B6,0x19D6,0x19D6,0x19D7,0x19D7,0x11D7,0x11D8,0x11F9,0x09D9,0x09D9,0x01B8,0x09F9,0x01D8,0x01D9,0x01B9,0x01B9,0x01B9,0x09D9,0x01B9,0x01D9,0x01D9,0x01D9,0x01B9,0x01D9,0x01D9,0x01B9,0x01D9,0x01DA,0x01B9,0x01B9,0x01B9,0x01B9,0x01B9,0x01D9,0x01B9,0x01D9,0x01B9,0x01D9,0x01B9,0x01D9,0x01D9,0x01B9,0x01D9,0x01D9,0x01D9,0x01D9,0x01F9,0x01FA,0x01D9,0x01D9,0x01DA,0x01D9,0x01D9,0x09D9,0x09D9,0x09F9,0x09D8,0x11D8,0x11B6,0x1154,0x1112,0x2132,0x2131,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x210F,0x290F,0x290F,0x2930,0x290F,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x2930,0x2130,0x2130,0x2110,0x2130,0x1931,0x1111,0x1133,0x19D6,0x1A18,0x19F8,0x19B6,0x0912,0x1932,0x2131,0x2130,0x2130,0x2930,0x212F,0x292F,0x292F,0x292F,0x210F,0x212F,0x212F,0x2130,0x2130,0x1911,0x1132,0x1154,0x19B6,0x19F7,0x19D6,0x19B6,0x1133,0x1912,0x2131,0x2110,0x2930,0x290F,0x212F,0x210F,0x290F,0x2930,0x210F,0x210F,0x2130,0x2130,0x2110,0x1911,0x1932,0x1932,0x1112,0x1154,0x19B5,0x19D6,0x11D6,0x1195,0x0913,0x1132,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x2930,0x292F,0x290F,0x292F,0x210F,0x290F,0x210F,0x210F,0x212F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2930,0x290F,0x210F,0x212F,0x2930,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x1911,0x10F1,0x1974,0x21D6,0x21D5,0x19B5,0x0912,0x1112,0x1952,0x1931,0x2150,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x2950,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x0932,0x0954,0x1A17,0x1A18,0x19F7,0x1175,0x1133,0x1953,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210E,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2131,0x2151,0x1931,0x1112,0x0913,0x19D7,0x19F8,0x1A19,0x19D7,0x10F2,0x1911,0x2111,0x2110,0x2910,0x2110,0x2930,0x2910,0x210F,0x210F,0x2930,0x290F,0x2930,0x210F,0x2930,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x210F,0x292F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2910,0x2930,0x2930,0x2130,0x2130,0x2131,0x1931,0x1931,0x1932,0x1933,0x1153,0x1174,0x21D6,0x2A17,0x21D6,0x1974,0x1933,0x1932,0x1911,0x1910,0x2131,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x2150,0x212F,0x212F,0x212F,0x292F,0x210F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x212F,0x210F,0x212F,0x210F,0x292F,0x292F,0x290F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1112,0x1995,0x2217,0x19F7,0x11B6,0x0933,0x1132,0x1952,0x1931,0x2131,0x2130,0x2130,0x2130,0x1930,0x1931,0x1132,0x0932,0x19D5,0x2A17,0x21F6,0x1995,0x1112,0x1112,0x2152,0x2151,0x2131,0x2130,0x2130,0x2110,0x2930,0x2910,0x210F,0x2930,0x212F,0x2930,0x292F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2130,0x212F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x210F,0x290F,0x2930,0x2910,0x290F,0x292F,0x292F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x212F,0x292F,0x292F,0x212F,0x210F,0x2130,0x2130,0x210F,0x2130,0x210F,0x210F,0x210F,0x2930,0x210F,0x2930,0x2110,0x2110,0x2130,0x2131,0x2151,0x1931,0x1132,0x1994,0x21F6,0x19D5,0x19B4,0x1112,0x1931,0x1931,0x2131,0x2131,0x2131,0x1910,0x1931,0x1131,0x1153,0x1A17,0x1A17,0x11F7,0x11B6,0x1132,0x1931,0x1930,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x292F,0x212F,0x210F,0x210F,0x2930,0x212F,0x290F,0x290F,0x290F,0x2930,0x212F,0x2930,0x2930,0x210F,0x2930,0x2930,0x212F,0x2930,0x2930,0x2130,0x212F,0x212F,0x2930,0x212F,0x212F,0x210F,0x290F,0x290F,0x210F,0x2110,0x2930,0x2110,0x2930,0x2930,0x2110,0x210F,0x210F,0x2110,0x2110,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x2910,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x210F,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2111,0x2111,0x1911,0x1912,0x1953,0x1975,0x19D7,0x2218,0x19F7,0x19B5,0x0953,0x0912,0x10F1,0x1111,0x1910,0x1910,0x1910,0x1910,0x2131,0x2131,0x1911,0x2111,0x2111,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2131,0x2130,0x1910,0x2131,0x2111,0x2130,0x2131,0x2131,0x2131,0x1931,0x1931,0x1931,0x1931,0x1910,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1132,0x1133,0x1154,0x19B6,0x21F7,0x2217,0x19B5,0x1194,0x1153,0x1133,0x1152,0x1952,0x1932,0x1111,0x1132,0x1132,0x1153,0x19B5,0x19D6,0x19F7,0x21F7,0x19D7,0x1175,0x1133,0x1112,0x1911,0x2131,0x2110,0x2130,0x2110,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x290F,0x290F,0x292F,0x2930,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x292F,
  0x2132,0x1931,0x1911,0x1911,0x1911,0x1911,0x1912,0x1132,0x1153,0x1154,0x1196,0x11B7,0x19F8,0x11F8,0x1A39,0x11F8,0x11D6,0x1195,0x1154,0x1133,0x1132,0x1931,0x1911,0x2131,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2151,0x2152,0x1931,0x1112,0x1133,0x1174,0x19D6,0x2217,0x2217,0x19D6,0x1195,0x1153,0x1132,0x1952,0x1931,0x1910,0x2110,0x2110,0x2130,0x210F,0x2130,0x2130,0x2130,0x2930,0x212F,0x212F,0x2930,0x210F,0x290F,0x212F,0x212F,0x292F,0x292F,0x2930,0x2930,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2930,0x210F,0x2910,0x290F,0x290F,0x2930,0x290F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2910,0x2910,0x210F,0x210F,0x2910,0x2930,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2930,0x210F,0x2910,0x2910,0x2910,0x28F0,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2110,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x28EF,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x2910,0x2910,0x210F,0x2910,0x210F,0x210F,0x210F,0x290F,0x2910,0x2910,0x210F,0x210F,0x2910,0x210F,0x210F,0x2110,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x2930,0x2910,0x2110,0x2110,0x2110,0x2130,0x210F,0x212F,0x2130,0x212F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2111,0x2132,0x1912,0x1912,0x1912,0x1912,0x1112,0x1132,0x1932,0x1112,0x1112,0x1912,0x1112,0x1112,0x1112,0x1132,0x1112,0x1113,0x1133,0x1113,0x1133,0x1933,0x1113,0x1113,0x1113,0x1113,0x1113,0x1112,0x1112,0x1112,0x1113,0x1113,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1132,0x1112,0x1112,0x1133,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1112,0x1132,0x1132,0x1112,0x1112,0x1112,0x1132,0x1933,0x1133,0x1933,0x1153,0x1153,0x1154,0x1974,0x1995,0x1175,0x1195,0x11B7,0x11D7,0x19F8,0x1219,0x1A19,0x11F8,0x1A19,0x1219,0x09B8,0x09D8,0x09F9,0x09F9,0x09D8,0x09D8,0x09D9,0x09D8,0x09D9,0x09F9,0x09D9,0x09D9,0x09F9,0x09D9,0x09F9,0x09D9,0x09D9,0x09D9,0x09D9,0x09D9,0x09F9,0x01D9,0x09D9,0x09D9,0x09D9,0x09D9,0x09D9,0x01D9,0x09F9,0x01D9,0x09D9,0x09D9,0x09D9,0x09D9,0x09B9,0x09B9,0x09D9,0x09D9,0x09D9,0x09D9,0x09F9,0x09F8,0x11F8,0x19F7,0x19D6,0x1153,0x1912,0x1911,0x2131,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x292F,0x290F,0x290F,0x292F,0x292F,0x292F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2130,0x2130,0x2131,0x1931,0x1111,0x1133,0x19D6,0x1A18,0x19F8,0x1196,0x1112,0x1911,0x2131,0x2130,0x2130,0x2930,0x212F,0x212F,0x212F,0x292F,0x292F,0x212F,0x2950,0x2130,0x2130,0x1911,0x1132,0x1174,0x19F6,0x19F7,0x19D6,0x1995,0x1133,0x1912,0x2131,0x2110,0x2110,0x2930,0x210F,0x210F,0x290F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2110,0x2111,0x2131,0x1932,0x1112,0x1153,0x19D6,0x21F7,0x19F7,0x11B5,0x0912,0x1132,0x1931,0x2131,0x2110,0x2130,0x210F,0x212F,0x2130,0x212F,0x2930,0x292F,0x212F,0x292F,0x290F,0x290F,0x290F,0x2930,0x2930,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x210F,0x2930,0x2930,0x2110,0x2110,0x210F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2910,0x2930,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x10F1,0x2174,0x29F6,0x21F6,0x1994,0x1112,0x1112,0x1931,0x1931,0x2130,0x2150,0x2150,0x190F,0x212F,0x212F,0x2950,0x2150,0x2130,0x2130,0x2130,0x2131,0x1931,0x1112,0x0933,0x0954,0x19F7,0x1A18,0x1A18,0x11B6,0x0933,0x1132,0x1931,0x1931,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2151,0x2131,0x1911,0x1112,0x1154,0x19F8,0x1A18,0x1A39,0x19D7,0x1112,0x2111,0x2111,0x2110,0x2910,0x2910,0x2910,0x2930,0x2930,0x290F,0x2930,0x2930,0x290F,0x2930,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x28EF,0x20EF,0x290F,0x290F,0x2950,0x292F,0x292F,0x292F,0x292F,0x290F,0x210F,0x292F,0x292F,0x292F,0x290F,0x290F,0x2910,0x2930,0x2130,0x2130,0x2110,0x1910,0x1931,0x1932,0x1933,0x1954,0x1175,0x21D6,0x21F7,0x21D6,0x1974,0x1132,0x1912,0x1911,0x1931,0x2130,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x210F,0x210F,0x290F,0x292F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1132,0x1133,0x19B5,0x2217,0x19F7,0x11B5,0x0933,0x1132,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x1910,0x1931,0x1132,0x1132,0x19D5,0x2217,0x21F6,0x1995,0x1112,0x1112,0x1932,0x2151,0x2151,0x2130,0x2130,0x2110,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x210F,0x210F,0x2930,0x212F,0x210F,0x210F,0x2910,0x2110,0x2930,0x2930,0x212F,0x210F,0x290F,0x290F,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x210F,0x210F,0x290F,0x210F,0x292F,0x2930,0x2930,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2131,0x2131,0x1931,0x1132,0x19B4,0x21F5,0x21D5,0x1994,0x1112,0x1911,0x2131,0x2131,0x2131,0x2131,0x1931,0x1931,0x1112,0x1133,0x1A17,0x1A38,0x1A18,0x11B5,0x1132,0x1911,0x1930,0x2130,0x2130,0x2130,0x212F,0x212F,0x292F,0x212F,0x212F,0x292F,0x292F,0x212F,0x292F,0x292F,0x292F,0x292F,0x2930,0x2930,0x2930,0x292F,0x2930,0x2930,0x2930,0x212F,0x2930,0x210F,0x212F,0x2930,0x2110,0x2110,0x2930,0x212F,0x2930,0x210F,0x2930,0x2930,0x2930,0x2930,0x212F,0x212F,0x212F,0x210F,0x2110,0x2110,0x2110,0x210F,0x2910,0x2910,0x2930,0x2910,0x210F,0x210F,0x290F,0x2910,0x2910,0x2910,0x2930,0x2910,0x2910,0x2110,0x2910,0x2930,0x2130,0x2130,0x2110,0x2110,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2131,0x2931,0x2131,0x2131,0x2111,0x1911,0x1912,0x1953,0x19B5,0x19D6,0x1A17,0x1A17,0x11B5,0x0954,0x0912,0x08F1,0x08F1,0x10F1,0x10F1,0x10F1,0x10F1,0x10F1,0x1911,0x1911,0x10F1,0x1911,0x1911,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x18F1,0x1911,0x1911,0x1111,0x1111,0x1111,0x1111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1912,0x1912,0x1112,0x1112,0x1112,0x1112,0x10F1,0x10F1,0x1911,0x1911,0x1911,0x1911,0x1912,0x1911,0x18F1,0x10F1,0x10F1,0x1112,0x1112,0x1133,0x1133,0x1154,0x1195,0x21F7,0x21F7,0x19B6,0x1995,0x1153,0x1132,0x1112,0x1132,0x1952,0x1932,0x1132,0x1132,0x1153,0x1994,0x19D6,0x19F7,0x2218,0x19D6,0x1175,0x1133,0x1132,0x1911,0x1911,0x2130,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x212F,0x292F,0x292F,0x292F,0x290F,0x290F,0x2930,0x2930,0x2930,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x292F,0x212F,0x292F,0x210F,0x290F,0x210F,0x292F,0x292F,0x292F,0x292F,
  0x1932,0x1932,0x1911,0x1931,0x1931,0x1931,0x1911,0x1111,0x1132,0x1953,0x1154,0x1175,0x11B7,0x19F8,0x1218,0x1218,0x1218,0x11D6,0x1195,0x1174,0x1133,0x1132,0x1911,0x1931,0x2131,0x2110,0x2930,0x2130,0x2130,0x2130,0x2110,0x2151,0x2151,0x1931,0x1111,0x1112,0x0912,0x1174,0x19D6,0x19F7,0x2217,0x21F6,0x1195,0x1153,0x1132,0x1932,0x2131,0x2111,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x212F,0x212F,0x212F,0x210F,0x2930,0x210F,0x210F,0x292F,0x210F,0x2930,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2910,0x2910,0x290F,0x210F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2110,0x2930,0x2110,0x2930,0x2110,0x2110,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2910,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2130,0x2110,0x2130,0x2130,0x2130,0x212F,0x210F,0x290F,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x210F,0x2110,0x2110,0x210F,0x210F,0x20EF,0x210F,0x210F,0x2910,0x210F,0x210F,0x2910,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x2910,0x2910,0x290F,0x2910,0x2910,0x210F,0x290F,0x2910,0x290F,0x2910,0x290F,0x290F,0x290F,0x2910,0x210F,0x2910,0x290F,0x290F,0x290F,0x210F,0x210F,0x2910,0x2910,0x2910,0x290F,0x2930,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2910,0x2110,0x2910,0x2110,0x210F,0x210F,0x2130,0x2930,0x212F,0x212F,0x210F,0x210F,0x2130,0x210F,0x2110,0x2130,0x2131,0x2111,0x2111,0x2111,0x1911,0x1912,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1912,0x1912,0x1932,0x1932,0x1912,0x1932,0x1912,0x1912,0x1932,0x1912,0x1112,0x1912,0x1932,0x1912,0x1912,0x1912,0x1932,0x1912,0x1912,0x1932,0x1912,0x1932,0x1912,0x1112,0x1112,0x1932,0x1932,0x1912,0x1912,0x1912,0x1912,0x1932,0x1932,0x1912,0x1912,0x1932,0x1912,0x1912,0x1912,0x1932,0x1911,0x1932,0x1932,0x1931,0x1931,0x1932,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1912,0x1912,0x1912,0x1911,0x1912,0x1912,0x1912,0x1132,0x1132,0x1133,0x1134,0x1154,0x1175,0x1196,0x1196,0x11B6,0x11B6,0x19D7,0x11D7,0x19D8,0x19F8,0x11D8,0x11F8,0x19F8,0x11D8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x19F9,0x11D8,0x11F8,0x11F9,0x11D8,0x11D8,0x11F9,0x11D8,0x11F8,0x11D8,0x11F8,0x11D8,0x11F8,0x11F8,0x11F8,0x09D8,0x11F9,0x11D8,0x11D8,0x11D8,0x11B8,0x11D8,0x11B8,0x11B8,0x11D8,0x11D8,0x11D8,0x11F8,0x19D7,0x19D6,0x21B5,0x1932,0x1911,0x2131,0x2131,0x2131,0x2130,0x2130,0x2110,0x2130,0x2110,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x292F,0x290F,0x212F,0x292F,0x292F,0x212F,0x212F,0x292F,0x212F,0x292F,0x212F,0x2130,0x2130,0x2130,0x2130,0x1931,0x1112,0x0933,0x19D6,0x1A18,0x1A18,0x11B6,0x1132,0x1911,0x2131,0x2130,0x2130,0x2130,0x212F,0x292F,0x212F,0x292F,0x292F,0x292F,0x2950,0x2130,0x2130,0x1931,0x1132,0x1154,0x19D6,0x19D6,0x19F7,0x19B5,0x1133,0x1912,0x2111,0x2130,0x2930,0x2930,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2131,0x1932,0x1112,0x1133,0x19B5,0x19F6,0x19D6,0x19B5,0x0912,0x1132,0x1931,0x2131,0x2130,0x2130,0x212F,0x2130,0x2130,0x212F,0x2930,0x212F,0x292F,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x290F,0x2910,0x2910,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1911,0x10F2,0x2174,0x29F6,0x21F6,0x1994,0x1112,0x1112,0x1952,0x1931,0x2151,0x2130,0x212F,0x190F,0x212F,0x2130,0x2150,0x2150,0x2130,0x2130,0x2130,0x1910,0x1932,0x1132,0x1133,0x0954,0x11D7,0x1A18,0x1A18,0x19F7,0x0934,0x1132,0x1932,0x1931,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2150,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2110,0x2130,0x2151,0x1931,0x1111,0x1133,0x1175,0x19F8,0x19F8,0x1A18,0x19B6,0x1932,0x2111,0x2111,0x2910,0x2910,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x292F,0x292F,0x210F,0x292F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x20CE,0x20CE,0x28EF,0x290F,0x3150,0x292F,0x292F,0x290F,0x292F,0x292F,0x290F,0x292F,0x292F,0x290F,0x290F,0x292F,0x290F,0x2930,0x2930,0x2130,0x2131,0x2131,0x1911,0x1132,0x1974,0x1174,0x21D6,0x2A17,0x21F7,0x1154,0x1133,0x1111,0x1911,0x1911,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x210F,0x2930,0x290F,0x290F,0x210F,0x212F,0x2130,0x212F,0x212F,0x2930,0x2930,0x212F,0x2930,0x2910,0x2930,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1133,0x19B5,0x2217,0x1A17,0x19B6,0x0933,0x1132,0x1952,0x1911,0x2131,0x2130,0x2130,0x2130,0x1930,0x1931,0x1132,0x1132,0x19D5,0x2216,0x19F6,0x19B5,0x08F2,0x1932,0x1952,0x2151,0x2131,0x2110,0x2110,0x2930,0x2930,0x2930,0x2110,0x210F,0x212F,0x2930,0x290F,0x290F,0x290F,0x2930,0x2930,0x210F,0x2930,0x2910,0x2110,0x2110,0x2930,0x210F,0x290F,0x290F,0x2910,0x2910,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x292F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x2930,0x210F,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x2110,0x2130,0x2130,0x2130,0x2131,0x2131,0x1931,0x1132,0x1994,0x21F5,0x21D5,0x1994,0x1112,0x1911,0x2131,0x2131,0x2131,0x2131,0x1911,0x1931,0x1932,0x1133,0x19F7,0x1A38,0x1A18,0x11B5,0x1132,0x1931,0x1930,0x2130,0x2110,0x2130,0x212F,0x212F,0x292F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x2930,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x210F,0x2130,0x2110,0x2930,0x210F,0x212F,0x2930,0x2930,0x210F,0x290F,0x2930,0x210F,0x212F,0x212F,0x210F,0x2930,0x2110,0x2110,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x2930,0x210F,0x2910,0x2910,0x2930,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x292F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2931,0x2110,0x2110,0x2131,0x2111,0x1911,0x1932,0x1153,0x19B5,0x19F7,0x1A17,0x2237,0x19F6,0x1195,0x1174,0x0913,0x0912,0x08F2,0x08F2,0x08F2,0x1113,0x08F2,0x0912,0x1113,0x1112,0x0912,0x1112,0x1112,0x1112,0x1112,0x1112,0x0912,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1133,0x1112,0x1112,0x1112,0x0912,0x0912,0x1132,0x1132,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x0912,0x0912,0x1112,0x1112,0x1112,0x0912,0x1113,0x0912,0x1133,0x0933,0x0913,0x1113,0x1113,0x1112,0x1112,0x1133,0x1132,0x1132,0x1113,0x1112,0x1112,0x1112,0x1113,0x1133,0x1133,0x1154,0x1195,0x19D6,0x2217,0x2217,0x19B6,0x1995,0x1153,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1153,0x1174,0x19D6,0x19F7,0x2217,0x21F7,0x1995,0x1133,0x1132,0x1932,0x1931,0x2110,0x2130,0x2110,0x2910,0x210F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x212F,0x2930,0x210F,0x292F,0x210F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,
  0x1953,0x1132,0x1952,0x1932,0x1931,0x1911,0x2131,0x1931,0x1932,0x1112,0x1933,0x1154,0x1175,0x11B7,0x11D8,0x1218,0x1218,0x11F8,0x11D7,0x1196,0x1174,0x1133,0x1132,0x1912,0x1911,0x2131,0x2131,0x2130,0x2110,0x2110,0x2110,0x2110,0x2151,0x2151,0x1931,0x1111,0x1112,0x1133,0x1174,0x19B5,0x2217,0x2217,0x19F6,0x1995,0x1153,0x1132,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x210F,0x212F,0x210F,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x292F,0x292F,0x210F,0x2130,0x212F,0x2130,0x2930,0x212F,0x2930,0x212F,0x210F,0x210F,0x290F,0x2930,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2930,0x2930,0x2910,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2930,0x2910,0x2910,0x2910,0x2910,0x2110,0x2130,0x2130,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x2930,0x2110,0x2110,0x210F,0x2910,0x2910,0x2910,0x210F,0x2110,0x210F,0x210F,0x2930,0x290F,0x2910,0x2930,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2130,0x2110,0x2930,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x2910,0x2910,0x2910,0x2910,0x2930,0x210F,0x290F,0x210F,0x210F,0x292F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x292F,0x290F,0x210F,0x2910,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2131,0x2131,0x2111,0x2111,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x2132,0x1931,0x2152,0x1932,0x1931,0x1931,0x1932,0x1932,0x1931,0x1911,0x1932,0x1911,0x1952,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1911,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x1932,0x1931,0x1931,0x1931,0x2132,0x1911,0x1931,0x1911,0x2132,0x1911,0x1931,0x1911,0x2131,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x1911,0x2151,0x2131,0x2131,0x1911,0x1911,0x1911,0x2131,0x1931,0x1911,0x1911,0x2132,0x1932,0x1932,0x1912,0x1133,0x1133,0x1154,0x1154,0x1154,0x1154,0x1154,0x1955,0x1975,0x1155,0x1155,0x1175,0x1175,0x1155,0x1175,0x1175,0x1176,0x1175,0x1996,0x1175,0x1175,0x1196,0x1176,0x1176,0x1196,0x1175,0x1196,0x1996,0x1196,0x1176,0x1196,0x1196,0x1196,0x1196,0x1196,0x11B6,0x1176,0x1196,0x1196,0x1175,0x1996,0x1996,0x1155,0x1176,0x1996,0x1196,0x19B6,0x19B6,0x19B6,0x19B6,0x1995,0x1974,0x2173,0x1932,0x1910,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x2110,0x2130,0x212F,0x212F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x2910,0x2910,0x2110,0x2910,0x210F,0x210F,0x290F,0x210F,0x2910,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x210F,0x212F,0x290F,0x290F,0x292F,0x212F,0x212F,0x292F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2930,0x2930,0x2130,0x2130,0x2130,0x1931,0x1112,0x1133,0x19F7,0x1A38,0x1A18,0x11B6,0x1133,0x1932,0x2131,0x2110,0x2130,0x2950,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x2930,0x2130,0x2130,0x1931,0x1132,0x1174,0x19F6,0x19F7,0x19F7,0x19B5,0x1133,0x1912,0x2131,0x2110,0x2110,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2930,0x2130,0x2110,0x2110,0x2131,0x1932,0x1912,0x1133,0x1995,0x21F7,0x19D6,0x1195,0x0912,0x1132,0x1931,0x2131,0x2130,0x2130,0x212F,0x212F,0x2930,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2130,0x2130,0x210F,0x2930,0x2930,0x2110,0x2110,0x2910,0x2910,0x2910,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2930,0x2930,0x212F,0x212F,0x210F,0x2930,0x2930,0x210F,0x2910,0x2910,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2131,0x2131,0x1912,0x10F2,0x2174,0x29F6,0x21D6,0x1995,0x1112,0x1112,0x1952,0x2131,0x2151,0x2150,0x2130,0x190F,0x212F,0x2150,0x2150,0x2150,0x2110,0x2131,0x1910,0x1911,0x1932,0x1153,0x0934,0x1175,0x11D7,0x11D7,0x1A18,0x19F8,0x0954,0x0933,0x1132,0x1952,0x2151,0x2131,0x2130,0x2130,0x2110,0x2110,0x2130,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2110,0x1911,0x1931,0x1952,0x1153,0x21F6,0x19F8,0x19F8,0x19F8,0x1995,0x1932,0x2131,0x2130,0x2110,0x2910,0x2910,0x2930,0x2930,0x210F,0x2930,0x290F,0x290F,0x2930,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x290F,0x28EE,0x28EF,0x290F,0x28CE,0x20AD,0x20AD,0x20CE,0x20CE,0x290F,0x292F,0x290F,0x290F,0x292F,0x292F,0x290F,0x290F,0x290F,0x2930,0x292F,0x2930,0x2130,0x2130,0x2130,0x2111,0x1911,0x1953,0x1974,0x1174,0x19B6,0x2A38,0x2A17,0x1974,0x1112,0x1912,0x1931,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x292F,0x212F,0x292F,0x212F,0x212F,0x212F,0x292F,0x290F,0x210F,0x2910,0x2110,0x210F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2110,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x292F,0x210F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x2150,0x2131,0x1931,0x1932,0x1133,0x19B5,0x2218,0x21F7,0x19B6,0x0933,0x1132,0x1952,0x1931,0x2131,0x2130,0x2130,0x2130,0x1951,0x1931,0x1132,0x1132,0x19D5,0x2216,0x21F6,0x1995,0x08F2,0x1112,0x2152,0x2152,0x2131,0x2110,0x2130,0x2130,0x2930,0x2910,0x2110,0x2110,0x2930,0x212F,0x210F,0x290F,0x2930,0x210F,0x2910,0x2910,0x2930,0x2930,0x2110,0x2110,0x210F,0x2930,0x210F,0x290F,0x290F,0x2910,0x290F,0x290F,0x210F,0x292F,0x210F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x210F,0x210F,0x2930,0x2930,0x2910,0x2910,0x210F,0x2910,0x2910,0x210F,0x2930,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2111,0x1931,0x1931,0x1132,0x1994,0x21F5,0x19D5,0x1994,0x1112,0x1931,0x2131,0x2131,0x2131,0x2111,0x1911,0x1931,0x1932,0x1153,0x19F7,0x1218,0x1A18,0x1195,0x1133,0x1931,0x2131,0x2130,0x2130,0x2130,0x212F,0x210F,0x292F,0x292F,0x210F,0x292F,0x212F,0x292F,0x292F,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x2930,0x210F,0x2910,0x2910,0x2110,0x2110,0x2110,0x212F,0x2930,0x210F,0x212F,0x2130,0x2110,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x2910,0x28F0,0x28EF,0x290F,0x2910,0x290F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2110,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x292F,0x292F,0x292F,0x212F,0x292F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x2131,0x1911,0x1112,0x1133,0x1195,0x19F7,0x1A38,0x1A58,0x1A38,0x1A18,0x19F7,0x19F7,0x19D7,0x19B7,0x1196,0x1196,0x11B7,0x1196,0x1196,0x1196,0x11B6,0x1196,0x11B6,0x1195,0x11B6,0x1196,0x19B6,0x1996,0x1996,0x19B6,0x19B6,0x11B6,0x11B6,0x11B6,0x19B6,0x19D6,0x11B6,0x11B6,0x1196,0x11B6,0x11B6,0x1196,0x11D6,0x11B6,0x11B6,0x19B6,0x1196,0x11B6,0x1196,0x1195,0x11B5,0x1195,0x1195,0x1195,0x11B6,0x1196,0x11B6,0x11B6,0x11B6,0x11B6,0x19B6,0x11B6,0x11D6,0x11B6,0x11B6,0x19B6,0x11B6,0x11B5,0x11B6,0x11B5,0x19D6,0x19D6,0x19B6,0x19D6,0x19B6,0x19B6,0x19D6,0x19D6,0x19F7,0x19F7,0x1A17,0x1A17,0x1A17,0x19D6,0x1174,0x1154,0x1133,0x1132,0x1132,0x1932,0x1132,0x1132,0x1133,0x1174,0x1995,0x19F6,0x19D7,0x19D7,0x21F7,0x1995,0x1133,0x1112,0x1111,0x1931,0x2151,0x2130,0x2110,0x2130,0x210F,0x2930,0x2930,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x212F,0x210F,0x292F,0x212F,
  0x21F6,0x1174,0x1153,0x1932,0x1932,0x1911,0x2131,0x2131,0x1911,0x1912,0x1912,0x1933,0x1154,0x1175,0x11D7,0x11F8,0x11F8,0x1218,0x11F8,0x11D7,0x11B6,0x1175,0x1154,0x1933,0x1932,0x1911,0x2131,0x2131,0x2110,0x2110,0x2130,0x2110,0x2130,0x2151,0x2151,0x1931,0x1111,0x1112,0x1133,0x1174,0x19B5,0x2217,0x2217,0x19D6,0x19B5,0x1133,0x1132,0x1932,0x1931,0x2131,0x2131,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x212F,0x2930,0x2930,0x290F,0x290F,0x2930,0x210F,0x2930,0x292F,0x292F,0x2930,0x212F,0x212F,0x2130,0x2130,0x2930,0x2930,0x212F,0x2930,0x210F,0x210F,0x2930,0x212F,0x210F,0x212F,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2110,0x2130,0x2130,0x2110,0x2110,0x210F,0x210F,0x2930,0x210F,0x210F,0x2130,0x210F,0x212F,0x210F,0x2930,0x210F,0x210F,0x2110,0x2130,0x212F,0x212F,0x2930,0x290F,0x2930,0x2930,0x2930,0x212F,0x212F,0x212F,0x210F,0x2130,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2110,0x2910,0x2910,0x210F,0x2930,0x210F,0x292F,0x292F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x292F,0x290F,0x290F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2130,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1931,0x2131,0x2131,0x2131,0x2131,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x1931,0x1931,0x1930,0x2131,0x2111,0x2131,0x2111,0x2111,0x1931,0x1931,0x2131,0x2131,0x1911,0x2131,0x2131,0x2111,0x1911,0x2131,0x2131,0x1910,0x1911,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2111,0x2111,0x2131,0x2111,0x2131,0x2111,0x2131,0x2131,0x2131,0x2110,0x2111,0x1910,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x2131,0x2111,0x1911,0x1932,0x1932,0x1933,0x1932,0x1953,0x1933,0x1933,0x1913,0x1933,0x1113,0x1133,0x1113,0x1133,0x1934,0x1133,0x1113,0x1133,0x1133,0x1134,0x1133,0x1133,0x1133,0x1134,0x1134,0x1133,0x1134,0x1134,0x1113,0x1134,0x1134,0x1134,0x1133,0x1134,0x1134,0x1133,0x1134,0x1134,0x1133,0x1133,0x1133,0x1153,0x1133,0x1133,0x1134,0x1134,0x1134,0x1134,0x1134,0x1154,0x1133,0x1932,0x1912,0x1911,0x2111,0x2110,0x2110,0x2130,0x2930,0x210F,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x2910,0x2910,0x290F,0x292F,0x2930,0x210F,0x2930,0x210F,0x2910,0x2910,0x290F,0x290F,0x210F,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x212F,0x212F,0x212F,0x210F,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x210F,0x292F,0x292F,0x292F,0x292F,0x2130,0x2130,0x2131,0x2131,0x1931,0x1112,0x1133,0x19F7,0x1A18,0x11F7,0x19D6,0x1133,0x1932,0x2131,0x2130,0x2130,0x2950,0x212F,0x210F,0x210F,0x292F,0x210F,0x292F,0x212F,0x2130,0x2130,0x1931,0x1132,0x1174,0x19D6,0x19F7,0x19D6,0x19B5,0x1113,0x1912,0x2131,0x2130,0x2110,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x2130,0x2110,0x2130,0x2110,0x2111,0x1932,0x1932,0x1133,0x1995,0x19D6,0x19D6,0x19B5,0x1132,0x1111,0x1931,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x292F,0x2930,0x292F,0x2930,0x212F,0x2930,0x210F,0x210F,0x2930,0x212F,0x212F,0x2930,0x2930,0x2930,0x2110,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2130,0x210F,0x2130,0x212F,0x212F,0x210F,0x2110,0x210F,0x2930,0x2110,0x2910,0x2910,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2111,0x2132,0x1912,0x10F2,0x1974,0x29F6,0x21D6,0x21B5,0x1112,0x1112,0x1952,0x2151,0x2150,0x2130,0x212F,0x212F,0x212F,0x2150,0x2130,0x2151,0x2130,0x2131,0x1911,0x1911,0x1933,0x1154,0x0954,0x0976,0x11D7,0x11D8,0x11F8,0x11F8,0x11B6,0x0954,0x1153,0x1952,0x1952,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x290F,0x210F,0x290F,0x292F,0x212F,0x210F,0x290F,0x210F,0x2930,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x1931,0x1911,0x1932,0x1132,0x1995,0x21F7,0x19F7,0x19F8,0x19D7,0x1154,0x1932,0x2131,0x2130,0x2110,0x2910,0x2930,0x2930,0x210F,0x292F,0x292F,0x290F,0x2930,0x210F,0x212F,0x292F,0x2930,0x292F,0x292F,0x290F,0x290F,0x292F,0x290F,0x290F,0x28EE,0x28CE,0x28CD,0x28AD,0x184B,0x49F2,0x4190,0x208D,0x20CE,0x28EF,0x292F,0x290F,0x290F,0x292F,0x290F,0x2910,0x2930,0x290F,0x210F,0x2930,0x2930,0x2130,0x2130,0x2131,0x1932,0x1953,0x1174,0x1996,0x2A18,0x2A17,0x1174,0x1113,0x1912,0x1931,0x1910,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x210F,0x210F,0x2930,0x292F,0x292F,0x292F,0x292F,0x212F,0x290F,0x292F,0x210F,0x2910,0x2110,0x210F,0x2110,0x210F,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x2910,0x2930,0x2910,0x210F,0x212F,0x212F,0x210F,0x212F,0x292F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x19B5,0x21F7,0x19F7,0x19B6,0x1133,0x1132,0x1932,0x1931,0x2130,0x2130,0x2130,0x2150,0x1951,0x1931,0x1132,0x1132,0x19B5,0x2217,0x21F6,0x1995,0x08F2,0x1112,0x2152,0x2151,0x2131,0x2110,0x2110,0x2130,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x290F,0x2930,0x2910,0x2910,0x2930,0x2110,0x2910,0x2110,0x2110,0x210F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x292F,0x290F,0x292F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2930,0x210F,0x2910,0x2110,0x2910,0x2110,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x2130,0x2130,0x2111,0x1931,0x1931,0x1132,0x1994,0x21F5,0x19D5,0x1994,0x1132,0x1911,0x2131,0x2131,0x2111,0x2131,0x1911,0x1931,0x1112,0x1153,0x19F7,0x1A38,0x11F8,0x11B6,0x0932,0x1931,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x2930,0x2130,0x212F,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2130,0x210F,0x2130,0x2930,0x2930,0x2930,0x210F,0x2910,0x2110,0x2110,0x2110,0x2930,0x212F,0x210F,0x212F,0x212F,0x2930,0x2110,0x290F,0x290F,0x2910,0x2110,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x210F,0x2930,0x292F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x292F,0x212F,0x212F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x1911,0x1931,0x1111,0x1133,0x1195,0x11D6,0x2238,0x2259,0x2279,0x2259,0x2A5A,0x2A7A,0x2A5A,0x2A5A,0x2A7A,0x2A5A,0x225A,0x2A7A,0x2279,0x2259,0x2259,0x2A79,0x2259,0x2259,0x2A59,0x2A79,0x2A59,0x2A39,0x2259,0x2A59,0x2259,0x2259,0x2259,0x227A,0x2259,0x2A7A,0x2259,0x2239,0x2259,0x2259,0x2259,0x227A,0x227A,0x2A7A,0x2259,0x2259,0x2259,0x2239,0x2259,0x2239,0x2A59,0x2A59,0x2A59,0x2259,0x2259,0x2259,0x2279,0x2279,0x2259,0x2259,0x2259,0x2259,0x2259,0x2259,0x2239,0x2259,0x2259,0x2258,0x2258,0x2259,0x2238,0x2259,0x1A18,0x2238,0x2238,0x1A18,0x19F8,0x1A18,0x19F7,0x1A18,0x19F7,0x19D6,0x1175,0x1154,0x1153,0x1132,0x1132,0x1132,0x1132,0x1132,0x1133,0x1154,0x1195,0x19D6,0x19D7,0x21F7,0x21F7,0x1995,0x1154,0x1132,0x1911,0x1931,0x1910,0x2130,0x2130,0x210F,0x212F,0x2930,0x2930,0x2930,0x210F,0x210F,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x294F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2151,0x2131,0x2131,0x2151,0x2130,0x2130,0x2130,0x2130,0x2930,0x210F,0x290F,0x2930,0x212F,0x212F,0x212F,0x212F,
  0x2237,0x19D6,0x1174,0x1133,0x1112,0x1932,0x1931,0x2131,0x2131,0x1911,0x1911,0x1912,0x1133,0x1154,0x1195,0x11B7,0x11F8,0x1218,0x11F8,0x11F8,0x11B7,0x1196,0x1175,0x1134,0x1133,0x1932,0x1911,0x2111,0x2110,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2151,0x1931,0x1111,0x1112,0x1133,0x1174,0x19B5,0x2217,0x1A17,0x19F6,0x19B5,0x0933,0x1132,0x1932,0x1931,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2930,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x292F,0x2110,0x210F,0x210F,0x2910,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2930,0x2930,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x2910,0x2110,0x2910,0x2110,0x2130,0x2110,0x2930,0x2930,0x2930,0x290F,0x2930,0x210F,0x2130,0x2130,0x210F,0x2930,0x2930,0x290F,0x2930,0x210F,0x2930,0x210F,0x210F,0x292F,0x212F,0x212F,0x210F,0x2130,0x2930,0x2130,0x2130,0x210F,0x210F,0x2110,0x2130,0x212F,0x290F,0x2930,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x292F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x292F,0x212F,0x292F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2930,0x210F,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2930,0x2130,0x212F,0x2930,0x2930,0x210F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2131,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x2111,0x1911,0x2132,0x2132,0x1912,0x1912,0x1911,0x1912,0x1932,0x1912,0x1932,0x1932,0x1112,0x1912,0x1912,0x1912,0x1112,0x1112,0x1912,0x1932,0x1912,0x1912,0x1932,0x1932,0x1912,0x1932,0x1912,0x1912,0x1112,0x1912,0x1912,0x1912,0x1112,0x1112,0x1112,0x1932,0x1912,0x1912,0x1932,0x1912,0x1932,0x1952,0x1112,0x1112,0x1912,0x1932,0x1912,0x1932,0x1912,0x1932,0x1911,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x212F,0x212F,0x2930,0x2910,0x2910,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2930,0x2910,0x2910,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x290F,0x292F,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x290F,0x210F,0x212F,0x212F,0x292F,0x210F,0x212F,0x212F,0x2110,0x2110,0x2131,0x1911,0x1132,0x1133,0x19F7,0x1A38,0x11F8,0x11B6,0x1133,0x1111,0x1931,0x2130,0x2130,0x2930,0x212F,0x212F,0x292F,0x290F,0x210F,0x210F,0x292F,0x2130,0x2110,0x1911,0x1132,0x1154,0x21D6,0x19F7,0x19F7,0x1995,0x1133,0x1912,0x1911,0x2131,0x2930,0x2930,0x290F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x1910,0x1911,0x1932,0x1133,0x19B5,0x2217,0x19D6,0x1995,0x1132,0x1932,0x1911,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x210F,0x2930,0x2930,0x210F,0x290F,0x2930,0x212F,0x212F,0x2930,0x210F,0x212F,0x212F,0x210F,0x2930,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2930,0x2930,0x212F,0x210F,0x2930,0x210F,0x210F,0x2110,0x212F,0x212F,0x2930,0x2110,0x210F,0x290F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2131,0x2132,0x1912,0x10F2,0x1974,0x21D6,0x21B6,0x1995,0x10F2,0x1112,0x1931,0x1910,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x1910,0x1911,0x1932,0x1932,0x1954,0x1175,0x1176,0x1196,0x11F8,0x11F8,0x11D7,0x11D7,0x11D7,0x1196,0x1154,0x1133,0x1932,0x1932,0x2151,0x2131,0x2130,0x2110,0x210F,0x210F,0x290F,0x290F,0x292F,0x292F,0x292F,0x290F,0x290F,0x2930,0x2930,0x212F,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2151,0x1931,0x1911,0x1932,0x1132,0x1974,0x21F6,0x21F7,0x19F7,0x21F7,0x1975,0x1112,0x1911,0x2131,0x2110,0x2110,0x2930,0x2110,0x210F,0x210F,0x292F,0x210F,0x292F,0x292F,0x292F,0x292F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x28CD,0x28AD,0x28AD,0x206C,0x392E,0x9C3A,0xDE3F,0xBD5E,0x102B,0x28CE,0x290F,0x290F,0x28EF,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x2110,0x2130,0x1911,0x1912,0x1154,0x1175,0x21F8,0x2218,0x1975,0x1113,0x1912,0x1932,0x1911,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x212F,0x210F,0x2930,0x210F,0x210F,0x292F,0x292F,0x212F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x292F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x1910,0x1931,0x1112,0x1113,0x21B6,0x2A17,0x21F7,0x1995,0x1133,0x1112,0x1931,0x1930,0x2130,0x2130,0x2130,0x2150,0x1931,0x1931,0x1132,0x1133,0x19B5,0x2217,0x21F6,0x1995,0x08F2,0x1112,0x1952,0x1931,0x2130,0x2110,0x2130,0x2130,0x2930,0x2930,0x2110,0x2110,0x2110,0x2910,0x210F,0x210F,0x210F,0x2910,0x2930,0x2110,0x2910,0x2910,0x2910,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2910,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x292F,0x290F,0x292F,0x290F,0x210F,0x290F,0x290F,0x2930,0x290F,0x210F,0x2930,0x2910,0x210F,0x210F,0x2910,0x2930,0x2930,0x212F,0x210F,0x210F,0x210F,0x212F,0x2110,0x2110,0x2130,0x2130,0x2151,0x1931,0x1131,0x1132,0x1994,0x21F5,0x19D5,0x1994,0x1112,0x1911,0x1931,0x2131,0x1910,0x2111,0x2131,0x1931,0x1112,0x1133,0x19F7,0x1A38,0x1218,0x11B6,0x1133,0x1931,0x2131,0x2110,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x292F,0x210F,0x292F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2930,0x2130,0x2930,0x2130,0x2110,0x210F,0x2110,0x2930,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x212F,0x292F,0x292F,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2930,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1932,0x1132,0x1154,0x1195,0x19D7,0x19D7,0x19D7,0x19D8,0x19D8,0x19D8,0x2219,0x2219,0x19F8,0x21F8,0x1A18,0x19F8,0x2218,0x1A18,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F7,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x1A18,0x19F8,0x1A18,0x1A18,0x19F8,0x19F8,0x19D8,0x19D8,0x19F8,0x19F8,0x1A18,0x19F8,0x1A18,0x1A18,0x19D7,0x19F8,0x21F8,0x19F8,0x2218,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19D8,0x19D8,0x2218,0x19F7,0x19F7,0x1A17,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x19D7,0x19F7,0x19F7,0x19F7,0x1A18,0x19F7,0x19F7,0x19D6,0x19D6,0x1995,0x1174,0x1153,0x1953,0x1133,0x1132,0x1132,0x1132,0x1132,0x1133,0x1154,0x1175,0x19B6,0x19D7,0x19D7,0x21D7,0x1995,0x1133,0x1932,0x1932,0x1931,0x1910,0x2110,0x2110,0x2130,0x2930,0x292F,0x2110,0x210F,0x210F,0x210F,0x210F,0x2930,0x2110,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2151,0x1931,0x2151,0x2151,0x2151,0x2131,0x2151,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,
  0x1218,0x11F7,0x11B6,0x1174,0x1133,0x1132,0x1932,0x2152,0x2131,0x2111,0x1911,0x1911,0x1912,0x1133,0x1154,0x1196,0x11B7,0x11F8,0x11F8,0x11F9,0x11F8,0x11D8,0x1196,0x1175,0x1154,0x1133,0x1932,0x1911,0x2131,0x2130,0x2130,0x2930,0x210F,0x210F,0x2130,0x2151,0x2131,0x1931,0x1111,0x1112,0x1133,0x1174,0x19B5,0x2217,0x19F7,0x19F7,0x19B5,0x0933,0x1132,0x1952,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2930,0x210F,0x2930,0x212F,0x2110,0x2930,0x2930,0x2110,0x2930,0x2130,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2910,0x210F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2910,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2930,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x210F,0x210F,0x210F,0x2130,0x2130,0x210F,0x290F,0x2930,0x2930,0x212F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2910,0x2910,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2910,0x2110,0x210F,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x20F0,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2111,0x2131,0x2131,0x2111,0x2111,0x2111,0x2111,0x2111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1932,0x1911,0x1911,0x1911,0x1931,0x1931,0x1932,0x1911,0x1911,0x1931,0x1931,0x1932,0x1931,0x1911,0x1911,0x2132,0x1911,0x1911,0x1911,0x1932,0x1931,0x1911,0x1911,0x1911,0x1911,0x1931,0x2132,0x1931,0x1911,0x1932,0x1911,0x1911,0x1911,0x2111,0x2111,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x212F,0x210F,0x2130,0x210F,0x210F,0x212F,0x292F,0x210F,0x2910,0x2910,0x2910,0x2910,0x290F,0x2930,0x290F,0x2910,0x2910,0x290F,0x2110,0x2910,0x2910,0x2910,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x2930,0x2930,0x290F,0x290F,0x212F,0x292F,0x210F,0x292F,0x292F,0x290F,0x290F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1112,0x1133,0x19F7,0x1A39,0x1A18,0x19D6,0x0933,0x1932,0x2151,0x2130,0x2130,0x2950,0x212F,0x292F,0x2930,0x290F,0x290F,0x290F,0x2930,0x2110,0x2130,0x1931,0x1132,0x1153,0x19D6,0x21F7,0x19F7,0x19B6,0x1133,0x1912,0x2131,0x2110,0x2130,0x2910,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2110,0x1911,0x1912,0x1133,0x1995,0x2217,0x19F6,0x19B5,0x1133,0x1132,0x1931,0x1910,0x2110,0x210F,0x210F,0x212F,0x212F,0x212F,0x292F,0x212F,0x292F,0x2930,0x290F,0x290F,0x290F,0x2930,0x2130,0x210F,0x2930,0x210F,0x2930,0x2930,0x212F,0x2110,0x2110,0x2110,0x2930,0x2910,0x2930,0x210F,0x2930,0x210F,0x2110,0x2110,0x210F,0x212F,0x2130,0x212F,0x212F,0x210F,0x2910,0x2910,0x210F,0x2130,0x210F,0x2110,0x290F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1912,0x10F2,0x1975,0x21D6,0x21B6,0x19B5,0x1112,0x1112,0x2151,0x2130,0x2130,0x210F,0x2130,0x212F,0x210F,0x2130,0x2130,0x2130,0x1911,0x1911,0x1912,0x1133,0x1154,0x19B6,0x19D7,0x11B7,0x11D8,0x09B7,0x0997,0x0997,0x11F8,0x11D7,0x19D6,0x1174,0x1133,0x1952,0x1952,0x1931,0x2110,0x2130,0x2110,0x210F,0x290F,0x290F,0x292F,0x290F,0x292F,0x292F,0x292F,0x210F,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1931,0x1931,0x1112,0x1132,0x1974,0x21D6,0x2217,0x21F7,0x19D7,0x1995,0x1133,0x1912,0x1911,0x2110,0x2110,0x2110,0x2930,0x2910,0x2930,0x290F,0x292F,0x292F,0x292F,0x2930,0x292F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290E,0x28CD,0x30CD,0x288C,0x202A,0x6A32,0xC51D,0xCD9F,0xD5DF,0x9C5A,0x102B,0x20CE,0x28EE,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x290F,0x2930,0x290F,0x2910,0x2910,0x2130,0x2130,0x1931,0x1932,0x1154,0x19D7,0x2218,0x21D7,0x1114,0x10F2,0x1932,0x1931,0x1910,0x2110,0x2130,0x2130,0x212F,0x2130,0x212F,0x210F,0x292F,0x292F,0x210F,0x210F,0x212F,0x292F,0x210F,0x2930,0x290F,0x290F,0x2930,0x2930,0x210F,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2131,0x1911,0x1912,0x1112,0x1995,0x21F7,0x21F7,0x19B5,0x1133,0x1112,0x1931,0x1910,0x2130,0x2130,0x2130,0x2150,0x1930,0x1951,0x1132,0x1132,0x21D6,0x21F6,0x19D6,0x19B5,0x0912,0x1111,0x2152,0x2151,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2910,0x290F,0x290F,0x290F,0x2930,0x2110,0x2930,0x2110,0x2910,0x2110,0x2110,0x2130,0x212F,0x210F,0x2930,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x2930,0x290F,0x210F,0x2930,0x2930,0x210F,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2110,0x2130,0x2130,0x2131,0x1931,0x1131,0x1131,0x19B4,0x21F5,0x19D5,0x1994,0x1132,0x1931,0x2131,0x2131,0x2111,0x2110,0x2111,0x1931,0x1932,0x0933,0x19F7,0x1A38,0x1218,0x1196,0x1153,0x1932,0x2131,0x2110,0x2130,0x212F,0x292F,0x212F,0x292F,0x210F,0x290F,0x292F,0x212F,0x212F,0x2930,0x2930,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2930,0x2110,0x2130,0x2130,0x2130,0x2110,0x2930,0x2110,0x2130,0x2110,0x210F,0x2930,0x212F,0x212F,0x2930,0x292F,0x212F,0x212F,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x210F,0x210F,0x2910,0x212F,0x212F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1931,0x1932,0x1112,0x1133,0x1133,0x1134,0x1154,0x1155,0x1134,0x1155,0x1155,0x1155,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1995,0x1155,0x1175,0x1155,0x1175,0x1175,0x1175,0x1175,0x1155,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1155,0x1175,0x1175,0x1155,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1155,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1195,0x1175,0x1195,0x1175,0x1174,0x1175,0x1174,0x1154,0x1133,0x1133,0x1133,0x1132,0x1932,0x1132,0x1152,0x1132,0x1133,0x1154,0x1175,0x19B6,0x19F7,0x19D7,0x21F7,0x1996,0x1154,0x1932,0x1911,0x1911,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x290F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x1932,0x1952,0x1932,0x1932,0x1932,0x1931,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,
  0x09F8,0x11F8,0x11D7,0x1196,0x1175,0x1133,0x1132,0x1911,0x1911,0x2131,0x2111,0x2131,0x1932,0x1112,0x1112,0x1134,0x1196,0x11D7,0x11D8,0x11F9,0x1219,0x11F8,0x11D8,0x1196,0x1175,0x1134,0x1112,0x1911,0x1911,0x2130,0x2950,0x2930,0x210F,0x210F,0x2130,0x2130,0x2131,0x2131,0x1910,0x1911,0x1132,0x1153,0x1994,0x19B5,0x19D6,0x19F7,0x2217,0x1195,0x0933,0x1133,0x1953,0x1932,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x292F,0x212F,0x210F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2110,0x2130,0x2130,0x210F,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x2130,0x212F,0x212F,0x210F,0x2930,0x2930,0x2930,0x212F,0x212F,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x210F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2930,0x2110,0x210F,0x210F,0x2910,0x2930,0x290F,0x290F,0x210F,0x210F,0x290F,0x2910,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2910,0x210F,0x2110,0x2930,0x212F,0x2110,0x2910,0x2930,0x2910,0x2910,0x2910,0x290F,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2130,0x2110,0x210F,0x210F,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2110,0x2110,0x2110,0x2110,0x2111,0x2131,0x2131,0x1910,0x1910,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2111,0x2131,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1910,0x2131,0x2131,0x2152,0x2131,0x2131,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2110,0x210F,0x212F,0x212F,0x212F,0x2930,0x292F,0x292F,0x292F,0x290F,0x290F,0x210F,0x210F,0x292F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x210F,0x212F,0x212F,0x212F,0x212F,0x2930,0x290F,0x290F,0x290F,0x2930,0x212F,0x292F,0x292F,0x212F,0x212F,0x212F,0x2930,0x290F,0x2930,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1911,0x1112,0x0934,0x11D7,0x1A18,0x11F8,0x11D6,0x0932,0x1111,0x1951,0x2151,0x2130,0x2130,0x212F,0x210F,0x2930,0x290F,0x290F,0x210F,0x210F,0x2130,0x2130,0x1931,0x1132,0x1974,0x19B6,0x19D6,0x19D6,0x19B5,0x1133,0x1112,0x2131,0x2131,0x2130,0x2110,0x2110,0x210F,0x2930,0x2930,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1912,0x1133,0x1975,0x21F6,0x19F6,0x19D6,0x1153,0x1132,0x1911,0x1930,0x2130,0x2130,0x212F,0x210F,0x210F,0x212F,0x210F,0x292F,0x292F,0x2930,0x290F,0x290F,0x2930,0x212F,0x212F,0x212F,0x2130,0x2110,0x2930,0x210F,0x2130,0x2930,0x2110,0x2110,0x2930,0x2910,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2930,0x2930,0x210F,0x210F,0x2130,0x2130,0x2930,0x290F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1112,0x10F2,0x1995,0x21F6,0x21F6,0x1995,0x0912,0x10F1,0x1931,0x2130,0x2110,0x2130,0x2950,0x2130,0x2130,0x2110,0x2130,0x2131,0x18F0,0x10F1,0x1133,0x1175,0x19F7,0x1A18,0x11D8,0x09B7,0x0997,0x0997,0x0997,0x0997,0x11B7,0x11F8,0x1A39,0x11D7,0x1995,0x1133,0x1952,0x1931,0x2130,0x2110,0x210F,0x210F,0x292F,0x290F,0x290F,0x290F,0x292F,0x292F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x1930,0x1931,0x1111,0x1132,0x1174,0x21D6,0x2A38,0x2217,0x19D7,0x1975,0x1133,0x1112,0x1911,0x2131,0x2110,0x2130,0x2110,0x2930,0x2930,0x2910,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x2910,0x290F,0x292F,0x292F,0x290F,0x290F,0x28CD,0x30CD,0x284B,0x38AC,0xA3D8,0xDD7E,0xC4DC,0xBCDC,0xCD9F,0x4990,0x184C,0x20CE,0x290F,0x290F,0x292F,0x290F,0x210F,0x292F,0x292F,0x290F,0x2930,0x2930,0x2910,0x2910,0x2130,0x2131,0x1911,0x1112,0x1995,0x2218,0x2218,0x1996,0x08F3,0x1112,0x1932,0x2131,0x2130,0x2130,0x2110,0x210F,0x212F,0x2130,0x212F,0x212F,0x292F,0x292F,0x290F,0x290F,0x290F,0x292F,0x290F,0x292F,0x290F,0x210F,0x292F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x2910,0x2910,0x290F,0x292F,0x2930,0x2930,0x2910,0x2910,0x290F,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x292F,0x290F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2131,0x2131,0x1912,0x1132,0x21B5,0x2217,0x19D6,0x19B6,0x1154,0x1132,0x1932,0x1931,0x2130,0x2130,0x2130,0x210F,0x2130,0x1931,0x1111,0x0932,0x21D6,0x2217,0x21F6,0x1994,0x0912,0x1131,0x2151,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x292F,0x290F,0x2930,0x210F,0x2130,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x210F,0x2930,0x210F,0x2910,0x2910,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x292F,0x212F,0x292F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x2110,0x210F,0x290F,0x210F,0x2110,0x2130,0x2130,0x2130,0x1931,0x1931,0x1132,0x19B4,0x21F5,0x19D5,0x1994,0x1132,0x1932,0x1931,0x2131,0x2131,0x2110,0x2110,0x1911,0x1932,0x1154,0x1A17,0x1A38,0x1218,0x11B6,0x1133,0x1931,0x2131,0x2130,0x2130,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x292F,0x292F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x212F,0x212F,0x2930,0x212F,0x2130,0x2110,0x2930,0x2930,0x2930,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x290F,0x290F,0x210F,0x2930,0x210F,0x290F,0x210F,0x210F,0x290F,0x292F,0x290F,0x290F,0x292F,0x290F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2111,0x1911,0x1931,0x1932,0x1912,0x1912,0x1912,0x1112,0x1912,0x1912,0x1912,0x1112,0x1112,0x1112,0x1933,0x1132,0x1112,0x1132,0x1112,0x1132,0x1112,0x1112,0x1112,0x1112,0x1112,0x1113,0x1113,0x1133,0x1133,0x1133,0x1133,0x1113,0x1112,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1112,0x1113,0x1113,0x1133,0x1133,0x1133,0x1113,0x1113,0x1112,0x1112,0x1112,0x1133,0x1133,0x1113,0x1112,0x1133,0x1133,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1132,0x1132,0x1132,0x1132,0x1112,0x1112,0x1112,0x1112,0x1133,0x1133,0x1153,0x1153,0x1133,0x1132,0x1112,0x1112,0x1111,0x1911,0x1111,0x1112,0x1132,0x1132,0x1153,0x1153,0x1154,0x1195,0x19F7,0x19F7,0x2217,0x19B6,0x1133,0x1112,0x1931,0x1931,0x2111,0x2130,0x2130,0x210F,0x210F,0x210F,0x2130,0x212F,0x210F,0x2110,0x2130,0x2930,0x210F,0x210F,0x210F,0x210F,0x292F,0x2930,0x294F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1911,0x1132,0x1133,0x1133,0x1133,0x1132,0x1132,0x1112,0x1932,0x1932,0x1931,0x1931,0x1910,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,
  0x09F9,0x09F8,0x11D8,0x11D8,0x11B6,0x1175,0x1153,0x1112,0x1911,0x2131,0x2131,0x2131,0x2131,0x1911,0x1112,0x1112,0x1154,0x11B6,0x11B7,0x1A19,0x11F9,0x1219,0x11F9,0x09D7,0x11B7,0x1175,0x1154,0x1132,0x1931,0x2131,0x2110,0x2130,0x2930,0x2930,0x2130,0x2130,0x2130,0x2110,0x2130,0x2131,0x1911,0x1932,0x1153,0x1174,0x19D5,0x19D6,0x2217,0x2217,0x1195,0x0933,0x1133,0x1952,0x2132,0x2131,0x2130,0x2110,0x2930,0x2930,0x2110,0x210F,0x210F,0x212F,0x2130,0x2930,0x212F,0x212F,0x292F,0x290F,0x290F,0x2910,0x2110,0x2110,0x2930,0x2110,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x210F,0x2130,0x2930,0x2110,0x2110,0x2110,0x2930,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x210F,0x2910,0x2910,0x2110,0x2110,0x210F,0x2910,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2930,0x210F,0x2910,0x2910,0x2910,0x210F,0x210F,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x210F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2151,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x212F,0x2130,0x2130,0x212F,0x212F,0x292F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2110,0x2110,0x2930,0x212F,0x210F,0x210F,0x2930,0x2930,0x210F,0x2930,0x290F,0x2930,0x210F,0x212F,0x212F,0x210F,0x212F,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2150,0x2130,0x1931,0x1112,0x1113,0x0934,0x19F8,0x1218,0x1218,0x11D7,0x0933,0x1111,0x1951,0x2151,0x2130,0x2130,0x2130,0x2930,0x212F,0x2930,0x210F,0x210F,0x210F,0x2130,0x2110,0x1931,0x1932,0x1154,0x19B6,0x19D6,0x21F7,0x19B5,0x1112,0x1111,0x2131,0x2131,0x2110,0x2110,0x2110,0x210F,0x2930,0x2930,0x210F,0x210F,0x2930,0x2930,0x2130,0x2130,0x2131,0x1931,0x1912,0x1133,0x1974,0x19B6,0x19D6,0x21F6,0x1154,0x1952,0x1931,0x1930,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x292F,0x212F,0x290F,0x2930,0x2930,0x292F,0x290F,0x210F,0x212F,0x2130,0x2130,0x2130,0x212F,0x210F,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x2930,0x290F,0x290F,0x292F,0x212F,0x212F,0x290F,0x290F,0x212F,0x2930,0x212F,0x210F,0x210F,0x2110,0x210F,0x2110,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1112,0x08F2,0x1995,0x21D6,0x21D6,0x19B5,0x1112,0x1111,0x1931,0x2130,0x2130,0x2930,0x212F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1911,0x10F1,0x0933,0x19D6,0x19F7,0x11F8,0x09B7,0x0976,0x0976,0x0976,0x0976,0x0996,0x0996,0x11D7,0x1218,0x19F8,0x1195,0x1133,0x1932,0x1931,0x2151,0x2110,0x210F,0x292F,0x292F,0x292F,0x292F,0x290F,0x292F,0x292F,0x210F,0x2130,0x2930,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1132,0x1154,0x21D6,0x2217,0x2217,0x21F7,0x1975,0x1133,0x1112,0x1911,0x1911,0x2131,0x2130,0x2110,0x2130,0x2930,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x2930,0x2930,0x210F,0x290F,0x2910,0x290F,0x290F,0x290E,0x28CD,0x28AC,0x284A,0x490D,0xC4BB,0xD51D,0xC4BB,0xC4BB,0xC4FD,0xAC7B,0x288C,0x208D,0x20CE,0x290F,0x290F,0x290F,0x290F,0x210F,0x292F,0x2930,0x2930,0x290F,0x2930,0x2110,0x2110,0x2110,0x2131,0x1911,0x1112,0x19B6,0x19F7,0x19D7,0x1196,0x0913,0x1112,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x290F,0x290F,0x290F,0x2930,0x290F,0x292F,0x290F,0x290F,0x210F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x292F,0x2930,0x2930,0x2910,0x2910,0x290F,0x2930,0x212F,0x210F,0x212F,0x292F,0x210F,0x292F,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2131,0x1932,0x1112,0x19B5,0x2217,0x19D6,0x19D6,0x1154,0x1112,0x1932,0x1931,0x2130,0x2110,0x210F,0x210F,0x2130,0x2131,0x1131,0x1132,0x19D5,0x2217,0x21F6,0x1994,0x0912,0x1932,0x2151,0x2130,0x2130,0x2950,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x290F,0x210F,0x2930,0x2910,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x292F,0x212F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x2930,0x210F,0x2910,0x2110,0x2130,0x2130,0x2130,0x1931,0x1931,0x1131,0x19B4,0x21F5,0x19D5,0x19B4,0x1132,0x1932,0x2152,0x2131,0x2131,0x2110,0x2110,0x2131,0x1932,0x1133,0x1A17,0x1A18,0x11F8,0x11B6,0x1132,0x1931,0x2131,0x2130,0x2130,0x2130,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x2930,0x2930,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2951,0x2131,0x2131,0x2111,0x2110,0x2110,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2930,0x2110,0x2110,0x2110,0x290F,0x210F,0x2930,0x210F,0x2910,0x2910,0x2910,0x210F,0x290F,0x2930,0x2930,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2130,0x2130,0x2110,0x2110,0x2131,0x2111,0x2111,0x1911,0x1911,0x2111,0x2111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1911,0x1911,0x1932,0x1911,0x1912,0x1932,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1912,0x1932,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1912,0x1111,0x1912,0x1912,0x1932,0x1111,0x1911,0x1911,0x1911,0x1911,0x1932,0x1932,0x1132,0x1153,0x0953,0x1174,0x11B5,0x19F7,0x19F7,0x19F7,0x19B6,0x1154,0x1112,0x1111,0x1931,0x1910,0x2110,0x2110,0x2130,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2110,0x2130,0x210F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1931,0x1932,0x1132,0x1133,0x1154,0x1154,0x1174,0x1174,0x1174,0x1133,0x1153,0x1153,0x1132,0x1911,0x1931,0x1930,0x1930,0x2130,0x2130,0x212F,0x212F,0x212F,
  0x09F9,0x09F9,0x11D8,0x11D8,0x11D7,0x11B6,0x1175,0x1133,0x1112,0x1911,0x1911,0x2131,0x2131,0x2131,0x2132,0x1932,0x1132,0x1154,0x1175,0x11B7,0x11D8,0x11F9,0x11F9,0x11F9,0x11D8,0x11B6,0x1195,0x1153,0x1952,0x1931,0x2131,0x2130,0x210F,0x2110,0x2110,0x2930,0x2930,0x2130,0x2151,0x2130,0x2131,0x1931,0x1132,0x1153,0x1194,0x19B5,0x19F6,0x1A17,0x2217,0x11B5,0x0934,0x1133,0x1912,0x2131,0x2131,0x2130,0x2930,0x2110,0x2130,0x2130,0x212F,0x2130,0x2930,0x2930,0x210F,0x292F,0x292F,0x290F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x212F,0x2930,0x2110,0x210F,0x290F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x2930,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2910,0x2910,0x2930,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x2930,0x290F,0x210F,0x210F,0x2930,0x2110,0x210F,0x2110,0x2930,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x20F0,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2930,0x2130,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x210F,0x210F,0x2110,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x2930,0x2130,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x210F,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x212F,0x210F,0x210F,0x2110,0x2130,0x2930,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2930,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2930,0x2110,0x2130,0x210F,0x2930,0x2930,0x212F,0x212F,0x212F,0x290F,0x290F,0x2930,0x290F,0x210F,0x212F,0x210F,0x212F,0x2930,0x212F,0x212F,0x2130,0x212F,0x2130,0x212F,0x2130,0x2950,0x2151,0x2131,0x1931,0x1112,0x1113,0x0954,0x1A18,0x1219,0x1219,0x1A18,0x0974,0x0912,0x1931,0x1930,0x2150,0x2130,0x2130,0x2930,0x212F,0x2130,0x210F,0x210F,0x212F,0x2130,0x2110,0x1911,0x1132,0x1174,0x19B6,0x19F7,0x2217,0x19D6,0x1133,0x1111,0x2131,0x2130,0x2930,0x2930,0x2110,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x1911,0x1932,0x1933,0x1995,0x21F7,0x19D6,0x19B6,0x1154,0x1132,0x1951,0x2151,0x2131,0x2130,0x2130,0x2930,0x2130,0x212F,0x292F,0x2930,0x2930,0x290F,0x2930,0x2930,0x2910,0x210F,0x2130,0x210F,0x2110,0x210F,0x212F,0x212F,0x2930,0x2110,0x212F,0x292F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x212F,0x2930,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2930,0x212F,0x210F,0x212F,0x2930,0x2930,0x212F,0x210F,0x210F,0x2130,0x2130,0x2110,0x1911,0x1932,0x1133,0x19B5,0x19D6,0x19D6,0x19B5,0x1133,0x1932,0x1951,0x1910,0x2130,0x2950,0x210F,0x210F,0x2130,0x2130,0x2151,0x2151,0x1931,0x1112,0x1195,0x1A17,0x11D7,0x11B7,0x0997,0x0976,0x0976,0x0976,0x0976,0x0976,0x0976,0x11B7,0x11F8,0x11D7,0x11B6,0x0934,0x1132,0x1931,0x2131,0x2130,0x2130,0x212F,0x292F,0x2950,0x292F,0x292F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2131,0x2131,0x1931,0x1932,0x1132,0x1174,0x19D6,0x2217,0x21F7,0x21D7,0x1995,0x1133,0x1112,0x1911,0x1911,0x2111,0x2131,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x2930,0x212F,0x2930,0x290F,0x290F,0x2930,0x2930,0x3130,0x290F,0x28CE,0x28AD,0x288C,0x284A,0x512D,0xD53D,0xD4DB,0xCCBB,0xCCBB,0xC47A,0xD53E,0x6A73,0x208C,0x208D,0x20CE,0x2930,0x292F,0x290F,0x290F,0x210F,0x212F,0x292F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2930,0x2131,0x1911,0x1112,0x19B6,0x19F7,0x19D7,0x19B6,0x0912,0x1932,0x1911,0x2131,0x2130,0x210F,0x2110,0x2130,0x212F,0x212F,0x212F,0x2930,0x290F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x292F,0x290F,0x2930,0x2930,0x210F,0x210F,0x210F,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x2930,0x2110,0x210F,0x2110,0x2110,0x2131,0x1932,0x1132,0x21B5,0x2217,0x19F6,0x19B6,0x1154,0x1112,0x1132,0x1931,0x2130,0x2130,0x212F,0x2130,0x2130,0x2131,0x1131,0x1133,0x19D6,0x19F7,0x19F6,0x1995,0x0912,0x1131,0x1931,0x1910,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2930,0x2930,0x290F,0x210F,0x210F,0x212F,0x2130,0x2130,0x210F,0x2130,0x212F,0x210F,0x2110,0x210F,0x2930,0x2910,0x2910,0x290F,0x290F,0x2910,0x2910,0x290F,0x2910,0x290F,0x2930,0x210F,0x210F,0x2930,0x2930,0x210F,0x290F,0x210F,0x210F,0x292F,0x292F,0x292F,0x212F,0x2130,0x212F,0x210F,0x2110,0x2130,0x2130,0x2110,0x210F,0x2930,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x1931,0x1931,0x1132,0x19B4,0x21D5,0x19D5,0x19B4,0x1132,0x1132,0x1931,0x1931,0x2131,0x2131,0x2111,0x1931,0x1932,0x1153,0x1A17,0x1A18,0x11F8,0x1195,0x1132,0x1931,0x2151,0x2130,0x2130,0x2930,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x2950,0x2130,0x2130,0x2110,0x2951,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2111,0x2131,0x2131,0x2151,0x2131,0x2131,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2930,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x292F,0x292F,0x292F,0x212F,0x292F,0x210F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2111,0x2110,0x2131,0x2131,0x2110,0x2110,0x2111,0x2111,0x2131,0x2110,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2131,0x1911,0x2131,0x2111,0x2111,0x1911,0x2131,0x2111,0x2131,0x1931,0x2131,0x2131,0x1931,0x1911,0x2131,0x1911,0x2131,0x1911,0x2131,0x2131,0x2131,0x1931,0x2131,0x1931,0x1931,0x1911,0x2131,0x2111,0x2131,0x1910,0x2111,0x2131,0x1910,0x2131,0x2131,0x1931,0x2131,0x1931,0x2131,0x1931,0x1931,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1952,0x1932,0x1932,0x1932,0x1133,0x1133,0x1174,0x19B6,0x19F7,0x2217,0x19D6,0x1175,0x1133,0x1132,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x292F,0x210F,0x210F,0x20EF,0x292F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1930,0x1952,0x1953,0x1154,0x1175,0x19D6,0x19F7,0x1A17,0x21F7,0x21F7,0x21F7,0x21F6,0x21D6,0x21B5,0x1994,0x1952,0x1931,0x1910,0x2130,0x2130,0x212F,0x214F,0x214F,
  0x09D9,0x09D8,0x11D8,0x11D8,0x11D8,0x11B7,0x1196,0x1175,0x1153,0x1932,0x1911,0x1911,0x2131,0x2151,0x2152,0x1932,0x1111,0x1112,0x1154,0x1196,0x11B7,0x11F8,0x1219,0x1219,0x1219,0x11F8,0x11B6,0x1175,0x1133,0x1132,0x1931,0x2131,0x2131,0x2130,0x2130,0x2930,0x2930,0x2950,0x2950,0x2151,0x2130,0x1911,0x1931,0x1932,0x1153,0x1194,0x11B5,0x19F6,0x2237,0x2217,0x1195,0x1133,0x1112,0x1932,0x2131,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x292F,0x292F,0x2930,0x2930,0x2910,0x2910,0x2110,0x2930,0x2110,0x2930,0x2930,0x2130,0x2930,0x2110,0x210F,0x290F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2930,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2930,0x2930,0x2110,0x2930,0x2110,0x2910,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x2930,0x2910,0x290F,0x210F,0x210F,0x2930,0x2930,0x210F,0x290F,0x290F,0x2930,0x210F,0x2910,0x2910,0x2930,0x210F,0x2910,0x2930,0x2930,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x2130,0x210F,0x2110,0x2110,0x210F,0x2130,0x210F,0x210F,0x2130,0x2130,0x2110,0x2110,0x210F,0x212F,0x212F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x210F,0x2130,0x2110,0x2110,0x2130,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x2130,0x210F,0x2110,0x2110,0x2130,0x2930,0x2110,0x2930,0x2930,0x2110,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x212F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2930,0x2930,0x2110,0x2930,0x210F,0x2930,0x290F,0x290F,0x2930,0x2930,0x2130,0x212F,0x212F,0x212F,0x210F,0x290F,0x290F,0x2910,0x290F,0x2910,0x290F,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x2930,0x2930,0x2110,0x2930,0x2110,0x2130,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x292F,0x290F,0x290F,0x2930,0x210F,0x212F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x2130,0x212F,0x210F,0x2130,0x2971,0x2130,0x1930,0x1931,0x1132,0x1133,0x0955,0x1218,0x1219,0x1219,0x1A39,0x1195,0x0932,0x1131,0x1931,0x2151,0x2150,0x2130,0x2130,0x210F,0x2930,0x210F,0x290F,0x212F,0x2130,0x2110,0x1931,0x1132,0x1174,0x19D6,0x19D6,0x21F7,0x19D6,0x1112,0x1112,0x1931,0x2131,0x2930,0x2930,0x290F,0x210F,0x210F,0x210F,0x290F,0x20EF,0x2930,0x2130,0x210F,0x210F,0x2110,0x2131,0x1931,0x1933,0x1974,0x21F7,0x19F7,0x1196,0x1154,0x1113,0x1952,0x2151,0x2131,0x2130,0x2130,0x2130,0x2950,0x212F,0x2930,0x292F,0x210F,0x210F,0x210F,0x2930,0x2910,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x212F,0x2930,0x210F,0x212F,0x212F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x210F,0x290F,0x2910,0x2930,0x2910,0x2910,0x2930,0x2930,0x212F,0x2130,0x210F,0x210F,0x210F,0x292F,0x2130,0x2130,0x2131,0x1911,0x1932,0x1112,0x19B5,0x21F6,0x19D6,0x19D5,0x1132,0x1112,0x1931,0x1910,0x2110,0x2930,0x210F,0x210F,0x2130,0x2130,0x2130,0x2151,0x1932,0x1133,0x11B5,0x11D7,0x11D7,0x11B7,0x0976,0x0955,0x0956,0x0955,0x0955,0x0955,0x0976,0x0997,0x11F8,0x11D8,0x11B7,0x0954,0x1953,0x1932,0x2131,0x2130,0x2930,0x212F,0x292F,0x292F,0x292F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2131,0x2131,0x1932,0x1132,0x1174,0x19D6,0x2218,0x2217,0x21D7,0x1995,0x1133,0x1112,0x1911,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x292F,0x2930,0x292F,0x290F,0x2930,0x292F,0x292F,0x290F,0x290F,0x28CE,0x28AD,0x28AC,0x2009,0x61F0,0xCCDB,0xD4DB,0xD4DB,0xCCBA,0xD4DB,0xD4FC,0xB43A,0x30AC,0x208D,0x20AD,0x20EF,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x2130,0x2110,0x2110,0x2930,0x2130,0x2131,0x1911,0x1112,0x19B6,0x19F8,0x19D7,0x19B6,0x1133,0x1931,0x1931,0x2110,0x2130,0x2110,0x2130,0x2130,0x2950,0x2930,0x210F,0x290F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x2910,0x2910,0x2930,0x2930,0x2910,0x2910,0x2930,0x2930,0x290F,0x2930,0x290F,0x2930,0x2930,0x290F,0x2930,0x2930,0x210F,0x210F,0x210F,0x212F,0x2930,0x212F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x210F,0x210F,0x210F,0x2110,0x2910,0x210F,0x210F,0x2110,0x2110,0x1931,0x1931,0x1132,0x19B5,0x21F7,0x19F6,0x19B6,0x1154,0x1112,0x1132,0x1931,0x2130,0x2130,0x212F,0x2130,0x2110,0x1930,0x1131,0x1133,0x19B5,0x2217,0x19F7,0x19B5,0x0912,0x1131,0x1931,0x1910,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x210F,0x2930,0x290F,0x290F,0x290F,0x2130,0x212F,0x2130,0x2130,0x212F,0x212F,0x2130,0x210F,0x2910,0x2910,0x2910,0x210F,0x2910,0x290F,0x290F,0x2910,0x210F,0x2910,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1911,0x1132,0x19B4,0x21F5,0x19D5,0x19B4,0x1132,0x1932,0x1931,0x2131,0x2131,0x2131,0x2131,0x1931,0x1932,0x1133,0x19F7,0x1A18,0x11F7,0x11B6,0x0932,0x1931,0x2131,0x2130,0x2130,0x2930,0x290F,0x292F,0x292F,0x290F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2971,0x2151,0x2131,0x1931,0x1911,0x1911,0x1911,0x1932,0x2173,0x2173,0x2152,0x1932,0x1931,0x1931,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2930,0x2130,0x2930,0x210F,0x210F,0x2930,0x2930,0x2110,0x210F,0x2130,0x212F,0x210F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x292F,0x210F,0x212F,0x212F,0x2930,0x2930,0x210F,0x2930,0x212F,0x2130,0x210F,0x2930,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2131,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2131,0x2131,0x2130,0x1910,0x2131,0x1911,0x1911,0x2131,0x1931,0x1931,0x1931,0x1952,0x1952,0x1952,0x1132,0x1153,0x1154,0x19B5,0x21F7,0x2217,0x21F7,0x1995,0x1133,0x1112,0x1111,0x1932,0x2131,0x2151,0x2130,0x2130,0x2930,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x290F,0x210F,0x210F,0x2930,0x292F,0x212F,0x212F,0x212F,0x1930,0x2130,0x1911,0x1132,0x1174,0x1195,0x19D7,0x19F7,0x1A17,0x1A18,0x19F7,0x2218,0x2218,0x2217,0x19F7,0x19D6,0x21D5,0x1973,0x1952,0x1931,0x1930,0x2130,0x2150,0x2150,0x2170,
  0x09B7,0x09B7,0x09B8,0x11F8,0x11F8,0x11D8,0x11D7,0x1196,0x1174,0x1133,0x1932,0x1911,0x1911,0x2131,0x2152,0x2151,0x1911,0x1131,0x1153,0x1174,0x11B6,0x09B7,0x11F8,0x1219,0x1219,0x1218,0x09D7,0x11D7,0x1175,0x1153,0x1112,0x1912,0x1911,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x1910,0x1931,0x1152,0x1132,0x1174,0x11B5,0x2217,0x2238,0x19D7,0x1195,0x1133,0x1112,0x1912,0x2131,0x2110,0x2110,0x2110,0x2130,0x212F,0x2130,0x212F,0x2130,0x2130,0x2930,0x210F,0x290F,0x2110,0x2930,0x2910,0x2910,0x2930,0x2110,0x2910,0x2930,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x2110,0x2930,0x210F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2930,0x2930,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x2110,0x2930,0x2110,0x2110,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x2910,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x210F,0x2130,0x2130,0x210F,0x2930,0x2110,0x2110,0x2110,0x2130,0x212F,0x212F,0x210F,0x2110,0x2110,0x210F,0x2130,0x2110,0x2110,0x2130,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x2910,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x2110,0x2110,0x210F,0x210F,0x2130,0x2110,0x2930,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2130,0x2130,0x2130,0x2110,0x2130,0x2930,0x2930,0x2130,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x2110,0x2130,0x2930,0x2130,0x2930,0x2110,0x2110,0x2930,0x2930,0x210F,0x290F,0x210F,0x290F,0x210F,0x290F,0x210F,0x212F,0x2930,0x210F,0x210F,0x2930,0x2930,0x2930,0x2910,0x2910,0x2110,0x2910,0x210F,0x2910,0x290F,0x290F,0x292F,0x210F,0x210F,0x210F,0x2110,0x2130,0x212F,0x2930,0x2930,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2130,0x2130,0x190F,0x18F0,0x1111,0x1133,0x1134,0x0955,0x11F8,0x11F9,0x1219,0x11F8,0x11B6,0x0933,0x1132,0x1131,0x1931,0x2151,0x2150,0x2130,0x212F,0x212F,0x20EF,0x210F,0x2930,0x2130,0x2130,0x1931,0x1932,0x1154,0x21F6,0x19F7,0x19F7,0x19B5,0x1112,0x1111,0x1931,0x2130,0x2930,0x2930,0x210F,0x210F,0x210F,0x290F,0x20EF,0x210F,0x2930,0x292F,0x210F,0x210F,0x2110,0x2131,0x1911,0x1132,0x1174,0x21F7,0x2217,0x19F7,0x1195,0x1133,0x1112,0x1932,0x2151,0x2131,0x2130,0x2130,0x2130,0x212F,0x2130,0x212F,0x212F,0x210F,0x2130,0x212F,0x2930,0x2110,0x210F,0x2130,0x2930,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2110,0x1911,0x1932,0x1112,0x21D6,0x21F6,0x19D6,0x19D5,0x1133,0x1112,0x1931,0x2131,0x2110,0x2130,0x210F,0x210F,0x210F,0x2930,0x2130,0x2131,0x1931,0x0912,0x11B5,0x11F7,0x11F8,0x0997,0x0955,0x0955,0x0955,0x0975,0x0934,0x0934,0x0955,0x1197,0x11F8,0x19F8,0x11B7,0x1155,0x1112,0x1932,0x2131,0x2130,0x2930,0x210F,0x290F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2131,0x2131,0x2131,0x1932,0x1133,0x1174,0x19D6,0x2217,0x21F7,0x19D7,0x1996,0x1154,0x10F2,0x18F1,0x1911,0x2111,0x2130,0x2130,0x2130,0x210F,0x2130,0x210F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x290F,0x292F,0x292F,0x292F,0x290F,0x28CE,0x208D,0x288C,0x306B,0x7A93,0xE57E,0xD4DB,0xD4DB,0xD49A,0xD4BA,0xDD3C,0xCCBB,0x48ED,0x30AD,0x20AD,0x28EE,0x2930,0x28EF,0x28EF,0x290F,0x292F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2930,0x2930,0x2110,0x2930,0x2131,0x1911,0x1112,0x19B6,0x19F7,0x19D7,0x19D6,0x1132,0x1931,0x1930,0x2130,0x2110,0x2130,0x2110,0x2130,0x2930,0x2930,0x2130,0x2930,0x290F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x2910,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x2930,0x2930,0x210F,0x290F,0x2930,0x2930,0x212F,0x292F,0x2930,0x212F,0x2130,0x2130,0x212F,0x210F,0x2930,0x290F,0x2930,0x2930,0x210F,0x2110,0x2131,0x2131,0x1932,0x1132,0x19B5,0x2217,0x19D6,0x19B6,0x0933,0x1132,0x1132,0x1911,0x2130,0x2130,0x212F,0x2930,0x2110,0x1910,0x1111,0x1133,0x19B5,0x2217,0x19F7,0x1995,0x0912,0x1132,0x1931,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x290F,0x292F,0x290F,0x290F,0x210F,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2910,0x290F,0x210F,0x2930,0x2910,0x210F,0x2910,0x2910,0x2910,0x210F,0x290F,0x292F,0x210F,0x210F,0x290F,0x290F,0x2930,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x2930,0x2930,0x2930,0x2110,0x2110,0x2110,0x210F,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2110,0x2130,0x2110,0x1931,0x1931,0x1132,0x1994,0x21D5,0x19D5,0x1994,0x1112,0x1111,0x1931,0x1931,0x2131,0x2131,0x2111,0x1911,0x1932,0x1154,0x19F7,0x1A18,0x19F8,0x1195,0x1132,0x1131,0x1930,0x2130,0x210F,0x210F,0x290F,0x210F,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2171,0x2151,0x1911,0x1931,0x1932,0x1932,0x1953,0x1953,0x1953,0x1132,0x1112,0x1132,0x1932,0x1952,0x1932,0x2131,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2930,0x2930,0x2930,0x2930,0x210F,0x212F,0x210F,0x210F,0x210F,0x2910,0x210F,0x2110,0x2910,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x290F,0x292F,0x290F,0x290F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2110,0x2130,0x2110,0x2110,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x2131,0x1931,0x1931,0x1932,0x1153,0x1153,0x1174,0x19D6,0x19F6,0x21F7,0x21F6,0x1995,0x1154,0x1132,0x1111,0x1911,0x1931,0x2131,0x2130,0x2130,0x2130,0x2930,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x290F,0x290F,0x290F,0x290F,0x2930,0x212F,0x212F,0x2130,0x2130,0x2131,0x1911,0x1111,0x1953,0x1995,0x11B6,0x11B7,0x19F8,0x1A18,0x11B6,0x1196,0x11B6,0x19D7,0x19F7,0x19D7,0x19D6,0x19B5,0x1994,0x1152,0x1931,0x1930,0x1930,0x2150,0x2170,0x2150,
  0x0976,0x0996,0x11B7,0x11D8,0x11D8,0x11F8,0x09D8,0x11B7,0x1196,0x1175,0x1133,0x1932,0x1931,0x1911,0x2131,0x2131,0x2131,0x1952,0x1152,0x1173,0x1174,0x1196,0x09B7,0x11F8,0x11F8,0x11F8,0x1218,0x11D7,0x11B7,0x1175,0x1154,0x1132,0x1932,0x1931,0x1911,0x2110,0x2130,0x2930,0x2110,0x2130,0x2130,0x2130,0x1910,0x1931,0x1931,0x1152,0x1153,0x1174,0x11B5,0x19F7,0x2217,0x19D7,0x1995,0x1154,0x1112,0x1912,0x2131,0x2110,0x2110,0x2130,0x2130,0x210F,0x212F,0x2130,0x2130,0x210F,0x2110,0x2930,0x210F,0x2930,0x2910,0x2910,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x210F,0x2910,0x2110,0x2910,0x290F,0x210F,0x2910,0x2110,0x2110,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2110,0x2910,0x2110,0x2910,0x2110,0x2110,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2110,0x2910,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2930,0x2110,0x210F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x210F,0x2930,0x212F,0x210F,0x210F,0x2110,0x210F,0x2110,0x2930,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x2130,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2930,0x2110,0x2110,0x2110,0x210F,0x210F,0x2110,0x2910,0x2910,0x210F,0x210F,0x2930,0x2910,0x2110,0x2910,0x2910,0x2930,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x2930,0x2110,0x2930,0x2930,0x2930,0x2110,0x2930,0x2930,0x2110,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2930,0x2930,0x2110,0x2130,0x2930,0x2930,0x2110,0x2110,0x2930,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x2930,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2930,0x2910,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x210F,0x2110,0x210F,0x212F,0x212F,0x210F,0x212F,0x292F,0x212F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x210F,0x212F,0x212F,0x2930,0x210F,0x2130,0x2130,0x1910,0x1931,0x1132,0x1133,0x0955,0x0976,0x09B8,0x09F9,0x09F9,0x11F9,0x09B6,0x0954,0x1173,0x1132,0x1951,0x2131,0x2131,0x2130,0x2930,0x292F,0x210F,0x210F,0x212F,0x2130,0x2130,0x1931,0x1132,0x1154,0x19F6,0x19F7,0x19D7,0x19B6,0x1112,0x1112,0x1931,0x2131,0x2130,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2130,0x2130,0x1910,0x1932,0x1153,0x19D6,0x2238,0x2218,0x19B6,0x1154,0x1113,0x1112,0x1931,0x2131,0x2130,0x2110,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x212F,0x210F,0x2130,0x2930,0x210F,0x2130,0x2930,0x2110,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x290F,0x292F,0x290F,0x290F,0x2910,0x2910,0x2930,0x210F,0x212F,0x210F,0x212F,0x212F,0x292F,0x292F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x10F1,0x1112,0x21B5,0x21D6,0x19D6,0x19D6,0x0933,0x1132,0x1952,0x1931,0x2131,0x2130,0x210F,0x212F,0x2930,0x2130,0x2130,0x1931,0x1911,0x08F2,0x1195,0x19F7,0x11D7,0x11B7,0x0955,0x0955,0x0955,0x0955,0x0114,0x0114,0x0935,0x1196,0x11F8,0x1A19,0x19D7,0x0954,0x1112,0x1931,0x2111,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2131,0x1911,0x1932,0x1132,0x1974,0x21D6,0x21F7,0x2217,0x21F7,0x1995,0x1133,0x1112,0x18F1,0x1911,0x2131,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x292F,0x212F,0x292F,0x290F,0x210F,0x290F,0x290F,0x28EF,0x28AD,0x28AC,0x2009,0x8AD4,0xDD1C,0xD4DB,0xDCDB,0xDCBA,0xD499,0xD4BA,0xE55D,0xABD8,0x282A,0x286C,0x20AD,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x292F,0x290F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2130,0x2131,0x18F1,0x1133,0x19D6,0x19D7,0x11D7,0x19D6,0x0912,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2930,0x2130,0x2110,0x210F,0x2930,0x2930,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x290F,0x2930,0x2910,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x2930,0x290F,0x210F,0x2930,0x2930,0x290F,0x290F,0x210F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2910,0x2930,0x212F,0x210F,0x2130,0x2131,0x1931,0x1932,0x1112,0x19B5,0x21F7,0x19D6,0x19D6,0x1154,0x1112,0x1932,0x1931,0x2130,0x2130,0x210F,0x2130,0x2130,0x1911,0x1132,0x0933,0x19B6,0x19F7,0x19D6,0x19D6,0x0912,0x1932,0x2152,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x290F,0x290F,0x292F,0x210F,0x2930,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2910,0x2910,0x290F,0x210F,0x2910,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x290F,0x2930,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2910,0x210F,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2111,0x1931,0x1932,0x1132,0x19B5,0x19D5,0x19D5,0x1994,0x1132,0x1111,0x1931,0x2131,0x2131,0x2111,0x1911,0x1932,0x1932,0x1153,0x19F7,0x1A38,0x19F8,0x1195,0x0932,0x1931,0x1931,0x2130,0x2130,0x212F,0x210F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x1931,0x1911,0x1932,0x1133,0x1153,0x1974,0x1994,0x1174,0x1154,0x1154,0x1154,0x1133,0x1133,0x1112,0x1932,0x1931,0x2131,0x2131,0x2111,0x2130,0x2130,0x2110,0x2930,0x2110,0x2130,0x2130,0x2110,0x2930,0x2930,0x2930,0x2110,0x2130,0x210F,0x2110,0x2910,0x210F,0x210F,0x210F,0x2110,0x2110,0x2910,0x2910,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x292F,0x290F,0x290F,0x290F,0x212F,0x292F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x210F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x212F,0x2130,0x2110,0x2110,0x212F,0x2130,0x2130,0x2110,0x2130,0x212F,0x210F,0x2130,0x212F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x1910,0x1910,0x1911,0x1911,0x1932,0x1132,0x1133,0x1174,0x19B5,0x21F7,0x21F7,0x21D6,0x1995,0x1133,0x1132,0x1111,0x1931,0x1931,0x1910,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x2930,0x212F,0x212F,0x2130,0x2130,0x1931,0x1911,0x1112,0x1154,0x1995,0x11B6,0x11D7,0x19F8,0x1196,0x0975,0x0955,0x0955,0x0975,0x11B6,0x11B6,0x19D6,0x11B5,0x1994,0x1953,0x1931,0x1931,0x1930,0x1930,0x1930,0x2150,
  0x1175,0x0975,0x0996,0x11B7,0x11D8,0x11F8,0x11F8,0x11F8,0x09B7,0x1196,0x1154,0x1133,0x1112,0x1911,0x1910,0x2131,0x2131,0x1931,0x1931,0x1132,0x1153,0x1174,0x0975,0x11B7,0x09D8,0x1219,0x11F8,0x11F8,0x11D7,0x11B6,0x1196,0x1154,0x1133,0x1932,0x1931,0x2131,0x18F0,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1132,0x1133,0x1174,0x19B5,0x19D7,0x2218,0x21F7,0x1995,0x1133,0x1112,0x1911,0x2131,0x2110,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2110,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x290F,0x2910,0x2910,0x2910,0x2910,0x210F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2930,0x2110,0x2910,0x2910,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x2130,0x210F,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x210F,0x2110,0x2130,0x2130,0x210F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2910,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x290F,0x2930,0x2130,0x2110,0x2910,0x2930,0x2910,0x210F,0x2910,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x212F,0x290F,0x2930,0x210F,0x2130,0x210F,0x2130,0x2110,0x210F,0x210F,0x2930,0x290F,0x210F,0x2910,0x2910,0x210F,0x2910,0x210F,0x2110,0x2110,0x2110,0x2930,0x2930,0x210F,0x290F,0x2910,0x2910,0x2910,0x210F,0x210F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x210F,0x210F,0x2930,0x210F,0x210F,0x2930,0x2930,0x210F,0x2110,0x2910,0x2930,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x292F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x290F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x212F,0x2930,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x210F,0x292F,0x210F,0x2930,0x2930,0x2130,0x2130,0x2131,0x1932,0x1153,0x1195,0x1197,0x09B8,0x09B8,0x09D9,0x0A1A,0x1219,0x09D7,0x0975,0x1195,0x1153,0x1132,0x1951,0x2131,0x2130,0x2930,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x1931,0x1132,0x1154,0x19D6,0x19F7,0x19B6,0x1195,0x1113,0x1112,0x1931,0x2131,0x2930,0x2910,0x210F,0x210F,0x290F,0x2930,0x2930,0x2930,0x2930,0x292F,0x210F,0x212F,0x2130,0x2130,0x1910,0x1911,0x1132,0x1995,0x2218,0x2238,0x19F7,0x1196,0x1134,0x1112,0x1912,0x2131,0x2111,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x210F,0x212F,0x2930,0x210F,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x292F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2152,0x10F1,0x10F2,0x21B6,0x21D6,0x19D6,0x19D6,0x0933,0x0912,0x1972,0x2151,0x2151,0x2130,0x2130,0x212F,0x2130,0x2130,0x2150,0x2131,0x1911,0x1112,0x1195,0x19F7,0x11F7,0x11D7,0x0955,0x0935,0x0955,0x0934,0x0934,0x0934,0x0134,0x11B6,0x19F8,0x11D8,0x19F7,0x1174,0x1112,0x1931,0x2111,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2131,0x2131,0x2111,0x1932,0x1133,0x1974,0x19D6,0x21F7,0x2217,0x19D7,0x1975,0x1133,0x1112,0x1111,0x1911,0x2111,0x2951,0x2130,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2930,0x292F,0x290F,0x290F,0x28AD,0x288C,0x306B,0x82B3,0xE57E,0xD4BA,0xDCDA,0xD499,0xDC99,0xDCBA,0xD4BA,0xDCFC,0x82B3,0x284A,0x206C,0x28EE,0x28EF,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x1911,0x18F2,0x1133,0x21F7,0x19F8,0x19D7,0x19B6,0x00D1,0x1111,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2110,0x2130,0x2930,0x2930,0x2930,0x292F,0x212F,0x2930,0x212F,0x2110,0x2930,0x212F,0x292F,0x290F,0x290F,0x2930,0x2930,0x2910,0x2930,0x292F,0x2930,0x2930,0x2910,0x290F,0x290F,0x2930,0x2110,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x210F,0x210F,0x2930,0x2130,0x2130,0x2110,0x2131,0x1931,0x1952,0x1132,0x19B5,0x2217,0x19D6,0x19D6,0x1154,0x1132,0x1111,0x1930,0x2130,0x2130,0x212F,0x2130,0x2130,0x1911,0x1132,0x1154,0x19D7,0x21F7,0x19D6,0x1195,0x0913,0x1953,0x2152,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x290F,0x210F,0x290F,0x2910,0x210F,0x2110,0x2110,0x2130,0x292F,0x292F,0x212F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2110,0x210F,0x290F,0x290F,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2910,0x2110,0x210F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1132,0x19B5,0x21F6,0x19D5,0x1994,0x1132,0x1931,0x1931,0x1931,0x2131,0x2131,0x2111,0x1911,0x1112,0x1154,0x19D7,0x1A18,0x1A18,0x1195,0x0932,0x1931,0x1931,0x2130,0x2130,0x212F,0x212F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1932,0x1152,0x1173,0x1195,0x19D6,0x19D6,0x19F6,0x21F6,0x21F7,0x21D6,0x21D6,0x1995,0x1995,0x1112,0x1912,0x1911,0x2111,0x2111,0x2131,0x2130,0x2930,0x2930,0x2110,0x210F,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x210F,0x2910,0x20EF,0x2910,0x210F,0x2110,0x210F,0x2110,0x2930,0x210F,0x290F,0x2930,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x2930,0x212F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2930,0x2110,0x2930,0x2130,0x2130,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2131,0x2131,0x2130,0x2131,0x2110,0x2130,0x1931,0x1931,0x1932,0x1132,0x1132,0x1154,0x19B5,0x21F7,0x21F7,0x21F6,0x1995,0x1112,0x1112,0x1111,0x1931,0x2151,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x2930,0x2130,0x2110,0x2130,0x2130,0x1931,0x1911,0x1112,0x1995,0x21D7,0x11B6,0x11D7,0x11B7,0x0975,0x0955,0x0934,0x0934,0x0955,0x0975,0x1196,0x11B6,0x19D6,0x1995,0x1974,0x1952,0x1931,0x1930,0x1930,0x1930,0x1930,
  0x1134,0x1154,0x1175,0x1196,0x11B7,0x11F8,0x11F8,0x11D8,0x11F8,0x11D7,0x1196,0x1174,0x1153,0x1111,0x1911,0x2131,0x2131,0x2151,0x1910,0x1931,0x1132,0x1153,0x1174,0x0975,0x11D7,0x11F8,0x11F8,0x11F9,0x11F8,0x11F8,0x11B7,0x1196,0x1133,0x1112,0x1952,0x1931,0x2131,0x2130,0x2110,0x2110,0x2950,0x2130,0x2130,0x2150,0x1930,0x1931,0x1911,0x1912,0x1132,0x1174,0x19B6,0x21F7,0x2218,0x21F7,0x1996,0x1133,0x1132,0x1932,0x2131,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2930,0x2110,0x210F,0x2130,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x2110,0x210F,0x2110,0x2910,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2930,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x2910,0x210F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2910,0x2910,0x2110,0x210F,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x212F,0x210F,0x2130,0x210F,0x2130,0x210F,0x2130,0x210F,0x210F,0x210F,0x2130,0x210F,0x2130,0x210F,0x2130,0x210F,0x2110,0x2110,0x2130,0x2130,0x2930,0x2110,0x2110,0x2930,0x2910,0x2110,0x2910,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x290F,0x210F,0x2930,0x2110,0x2930,0x2110,0x2110,0x210F,0x290F,0x2110,0x2110,0x290F,0x290F,0x210F,0x2910,0x2910,0x210F,0x210F,0x2110,0x290F,0x290F,0x2910,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2930,0x210F,0x212F,0x212F,0x212F,0x210F,0x2910,0x2110,0x2110,0x2110,0x210F,0x290F,0x290F,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2910,0x290F,0x210F,0x2910,0x210F,0x2110,0x210F,0x210F,0x2910,0x2930,0x2910,0x2910,0x2930,0x2930,0x290F,0x210F,0x210F,0x2110,0x2910,0x2930,0x2110,0x2110,0x2110,0x210F,0x2930,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x2930,0x210F,0x290F,0x2930,0x2930,0x2910,0x2910,0x2110,0x210F,0x290F,0x2930,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x2110,0x2110,0x2110,0x2930,0x210F,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x210F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x292F,0x292F,0x290F,0x290F,0x212F,0x212F,0x210F,0x210F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2930,0x292F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x2930,0x2130,0x2130,0x1931,0x1932,0x1953,0x19B6,0x19F8,0x11F9,0x09D9,0x01B9,0x01B9,0x09FA,0x09F9,0x09F9,0x11F8,0x19F7,0x11B5,0x1132,0x1952,0x1931,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x2130,0x1931,0x1132,0x1153,0x19D6,0x19F7,0x19F7,0x19B5,0x1133,0x1112,0x1911,0x2131,0x2930,0x2910,0x210F,0x210F,0x290F,0x2930,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x1910,0x1931,0x1132,0x1153,0x19B6,0x2238,0x1A18,0x19F7,0x1996,0x1133,0x1112,0x1912,0x1911,0x2111,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x212F,0x2930,0x210F,0x210F,0x212F,0x212F,0x290F,0x290F,0x210F,0x212F,0x292F,0x290F,0x290F,0x210F,0x210F,0x210F,0x292F,0x212F,0x292F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x2131,0x2152,0x10F1,0x08F2,0x21B6,0x21D7,0x19D7,0x19F7,0x0953,0x08F2,0x1973,0x2152,0x2131,0x2110,0x2130,0x2130,0x2130,0x2130,0x2151,0x2151,0x1911,0x1112,0x1195,0x19F7,0x11D7,0x11D8,0x0996,0x0155,0x0134,0x0934,0x0934,0x0134,0x0955,0x11D7,0x19F8,0x1A18,0x19D7,0x1174,0x1132,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2930,0x2130,0x2130,0x2110,0x2131,0x2131,0x2131,0x1912,0x1132,0x1154,0x21D6,0x21F7,0x2217,0x19D6,0x1995,0x1133,0x1112,0x1911,0x1911,0x2111,0x2130,0x2130,0x2110,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x292F,0x28CD,0x286C,0x2009,0x7251,0xDD1C,0xDCDA,0xDCB9,0xD498,0xD478,0xDC99,0xD499,0xDCBA,0xE55D,0x7211,0x282A,0x288C,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2111,0x1911,0x1112,0x1134,0x19D7,0x19F8,0x19D7,0x19D6,0x0912,0x1111,0x1931,0x2131,0x2151,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2130,0x212F,0x212F,0x212F,0x2930,0x212F,0x2930,0x2930,0x292F,0x292F,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x292F,0x292F,0x210F,0x2930,0x290F,0x290F,0x2110,0x210F,0x210F,0x290F,0x2930,0x290F,0x212F,0x212F,0x210F,0x212F,0x2930,0x212F,0x2930,0x210F,0x212F,0x2130,0x212F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x1910,0x1931,0x1932,0x1132,0x19B5,0x2217,0x19D6,0x19D6,0x1174,0x0912,0x1932,0x1931,0x2130,0x2130,0x2130,0x2130,0x2111,0x1932,0x1133,0x0954,0x19D7,0x19F7,0x19D7,0x11B6,0x0933,0x1133,0x1972,0x1951,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x212F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2930,0x2130,0x212F,0x212F,0x292F,0x290F,0x290F,0x2910,0x2910,0x290F,0x2110,0x2930,0x210F,0x2930,0x212F,0x212F,0x290F,0x2930,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2910,0x2930,0x290F,0x2910,0x290F,0x290F,0x290F,0x2930,0x290F,0x2110,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1112,0x1132,0x19B5,0x19D6,0x19D5,0x19B4,0x1132,0x1931,0x1951,0x1931,0x2131,0x2131,0x1931,0x1911,0x1932,0x1153,0x19F7,0x1A18,0x19F8,0x1195,0x1132,0x1931,0x2151,0x2130,0x2130,0x210F,0x2130,0x2930,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1132,0x1153,0x1995,0x19D6,0x19D6,0x19F7,0x21F7,0x19F7,0x21F7,0x21F7,0x19F7,0x19D7,0x19B6,0x1974,0x1133,0x1912,0x1911,0x1911,0x2131,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x2130,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2150,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2110,0x2131,0x2131,0x1911,0x1931,0x1931,0x1132,0x1132,0x0933,0x19B5,0x21F7,0x21F7,0x21F7,0x1995,0x1133,0x1112,0x1111,0x1911,0x1911,0x2130,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2930,0x2930,0x210F,0x2110,0x2110,0x2130,0x2110,0x2131,0x1932,0x1132,0x21B5,0x19D7,0x11D7,0x11D7,0x0975,0x0955,0x0954,0x0954,0x0934,0x0934,0x0955,0x1176,0x19B6,0x19D6,0x19D6,0x1994,0x1932,0x1931,0x1910,0x1910,0x1930,0x2130,
  0x1113,0x1133,0x1154,0x1175,0x1196,0x11B7,0x11F8,0x1219,0x11F8,0x11F8,0x11D7,0x1195,0x1174,0x1132,0x1111,0x1911,0x1930,0x2130,0x1910,0x1931,0x1111,0x1132,0x1153,0x1174,0x1196,0x09B7,0x11F8,0x11F8,0x11F9,0x11D8,0x19F9,0x11B7,0x0955,0x1154,0x1133,0x1932,0x2152,0x2111,0x2110,0x2130,0x2110,0x2130,0x2930,0x2930,0x2130,0x2131,0x1911,0x1911,0x1932,0x1133,0x1974,0x19B6,0x2217,0x2217,0x21F7,0x19B5,0x1153,0x1132,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2950,0x2130,0x2130,0x2930,0x2110,0x2910,0x2910,0x2930,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x290F,0x2930,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x212F,0x212F,0x2930,0x290F,0x210F,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x210F,0x2910,0x2910,0x2910,0x2930,0x2910,0x2110,0x2110,0x2930,0x290F,0x210F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x210F,0x2930,0x2130,0x2130,0x210F,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x210F,0x2930,0x2130,0x212F,0x212F,0x2130,0x2130,0x212F,0x2130,0x212F,0x210F,0x210F,0x212F,0x2130,0x210F,0x2130,0x2130,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2910,0x2930,0x2910,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x210F,0x2910,0x210F,0x210F,0x2110,0x2910,0x2110,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2910,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2910,0x210F,0x290F,0x290F,0x2930,0x2930,0x210F,0x212F,0x2130,0x210F,0x2930,0x2910,0x2110,0x2110,0x2110,0x2910,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2930,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2910,0x2110,0x2910,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2910,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x2910,0x210F,0x2910,0x210F,0x290F,0x290F,0x210F,0x290F,0x2930,0x210F,0x212F,0x212F,0x2930,0x290F,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x292F,0x292F,0x290F,0x290F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x290F,0x2930,0x2110,0x2930,0x2930,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1932,0x1133,0x1995,0x19D7,0x11F9,0x121A,0x09D9,0x01B9,0x01DA,0x09DA,0x09FA,0x09F9,0x09F9,0x11F8,0x11D7,0x1174,0x1153,0x1932,0x2151,0x2130,0x2130,0x210F,0x212F,0x2130,0x2150,0x2151,0x1931,0x1132,0x1133,0x19D6,0x2217,0x19F7,0x11B6,0x1154,0x1132,0x1931,0x2131,0x2931,0x2930,0x290F,0x290F,0x290F,0x2930,0x292F,0x290F,0x290F,0x210F,0x210F,0x212F,0x2130,0x2110,0x2130,0x1911,0x1931,0x1953,0x1174,0x19B6,0x19F7,0x2218,0x2218,0x1175,0x1133,0x1112,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x210F,0x210F,0x290F,0x210F,0x2930,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x210F,0x2930,0x210F,0x210F,0x210F,0x292F,0x292F,0x290F,0x290F,0x290F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x10F2,0x1134,0x21D7,0x19D7,0x19D7,0x19D7,0x0954,0x00D1,0x1953,0x1952,0x1931,0x2130,0x2130,0x2130,0x2110,0x2130,0x2150,0x2131,0x1931,0x1132,0x1174,0x11B6,0x11D7,0x11D7,0x11D7,0x11D7,0x0155,0x0955,0x0975,0x0976,0x11F7,0x1A18,0x19F8,0x19D7,0x19B6,0x1154,0x1932,0x1931,0x2111,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2131,0x1912,0x1132,0x1954,0x19B6,0x21F7,0x21F7,0x19D6,0x1175,0x1133,0x1112,0x1111,0x1911,0x2131,0x2951,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x210F,0x210F,0x212F,0x292F,0x292F,0x290F,0x20AD,0x206B,0x200A,0x512D,0xE55D,0xD4BA,0xD479,0xD478,0xDC78,0xDC78,0xDC78,0xDC99,0xDCDA,0xE55D,0x510D,0x280A,0x30CD,0x28EE,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2130,0x2110,0x2110,0x2110,0x2111,0x1911,0x1911,0x1113,0x1975,0x19D7,0x11D8,0x11D7,0x19B7,0x0912,0x1112,0x1952,0x2151,0x2131,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x2130,0x2130,0x210F,0x2130,0x2130,0x2930,0x290F,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x2110,0x2110,0x210F,0x212F,0x212F,0x2930,0x212F,0x210F,0x210F,0x210F,0x292F,0x210F,0x2130,0x212F,0x212F,0x1930,0x1930,0x1931,0x1132,0x1112,0x19B5,0x2217,0x19D6,0x19B5,0x1154,0x1132,0x1931,0x1930,0x2130,0x2130,0x2130,0x2130,0x1911,0x1932,0x1153,0x1174,0x19D7,0x19D7,0x19D7,0x19B6,0x0934,0x1153,0x1972,0x1931,0x2151,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2930,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x210F,0x2930,0x212F,0x2930,0x210F,0x2910,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x292F,0x210F,0x210F,0x210F,0x290F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1932,0x1112,0x1133,0x19B5,0x19D5,0x19D5,0x1994,0x1132,0x1932,0x1952,0x1931,0x2151,0x1931,0x1931,0x1931,0x1932,0x1154,0x1A17,0x1A18,0x19F8,0x1195,0x1132,0x1951,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2131,0x1911,0x1931,0x1132,0x19B5,0x19D6,0x19D6,0x19F7,0x19F7,0x11B6,0x1196,0x19B6,0x19B7,0x19D7,0x19D7,0x19B7,0x19B6,0x1174,0x1133,0x1932,0x1912,0x1931,0x2131,0x2131,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2130,0x2130,0x2130,0x2131,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2131,0x2130,0x2130,0x2130,0x2110,0x2131,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2131,0x2110,0x2110,0x2110,0x2110,0x2131,0x2131,0x2131,0x2131,0x1911,0x2131,0x2131,0x1931,0x1932,0x1953,0x1174,0x19D6,0x19D6,0x19D6,0x19D6,0x1995,0x1133,0x1112,0x1931,0x1931,0x2131,0x2110,0x2110,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2930,0x210F,0x210F,0x290F,0x210F,0x2910,0x2110,0x2130,0x2130,0x2131,0x2131,0x1932,0x1133,0x21B6,0x21F7,0x19D7,0x11B6,0x0955,0x0954,0x1195,0x1195,0x0934,0x0934,0x0955,0x1196,0x11B6,0x19B6,0x19D6,0x1995,0x1932,0x1911,0x1910,0x1910,0x1910,0x2130,
  0x1112,0x1132,0x1133,0x1154,0x1195,0x0996,0x11D7,0x11F8,0x11F8,0x11F8,0x11D8,0x11B7,0x1196,0x1174,0x1132,0x1111,0x1911,0x1910,0x2131,0x1910,0x1931,0x1931,0x1132,0x1173,0x1174,0x11B6,0x09B7,0x11F8,0x11D8,0x11D9,0x11F9,0x11D8,0x11D7,0x1195,0x1154,0x1973,0x1932,0x1911,0x2131,0x2110,0x2110,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2111,0x1911,0x1932,0x1133,0x1974,0x19B6,0x19F7,0x2217,0x21F7,0x19B5,0x1153,0x1112,0x1932,0x2152,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2110,0x2130,0x2130,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2930,0x290F,0x290F,0x2930,0x2930,0x2910,0x2110,0x210F,0x2930,0x212F,0x210F,0x212F,0x2930,0x290F,0x2110,0x2110,0x2110,0x2930,0x210F,0x2110,0x2930,0x2930,0x210F,0x2930,0x2910,0x2930,0x2930,0x2930,0x2910,0x290F,0x212F,0x2930,0x290F,0x2910,0x2110,0x2110,0x210F,0x210F,0x2130,0x2110,0x2110,0x2930,0x2110,0x2930,0x2930,0x290F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x210F,0x2130,0x212F,0x2130,0x212F,0x2930,0x2930,0x212F,0x212F,0x2130,0x212F,0x210F,0x212F,0x212F,0x2930,0x210F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x290F,0x290F,0x290F,0x2930,0x2910,0x290F,0x2910,0x2910,0x2110,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2910,0x2110,0x2910,0x2930,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x210F,0x2930,0x2910,0x2930,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x2930,0x210F,0x210F,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2910,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x2910,0x210F,0x2910,0x290F,0x210F,0x290F,0x210F,0x212F,0x210F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x290F,0x210F,0x290F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2110,0x290F,0x2930,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2930,0x290F,0x210F,0x2110,0x2110,0x210F,0x2930,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x212F,0x210F,0x210F,0x290F,0x2930,0x210F,0x290F,0x210F,0x2930,0x210F,0x210F,0x292F,0x292F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x290F,0x290F,0x290F,0x290F,0x210F,0x292F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x290F,0x2110,0x2110,0x2930,0x2110,0x210F,0x2930,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x19B7,0x11D8,0x11FA,0x09FA,0x01B9,0x01B9,0x01B9,0x01BA,0x09DA,0x01D9,0x09F9,0x09D8,0x09B7,0x1195,0x1153,0x1952,0x2152,0x2130,0x2110,0x2130,0x2130,0x2130,0x2151,0x2151,0x1931,0x1932,0x1132,0x19B5,0x19F7,0x19F7,0x19D6,0x0954,0x1132,0x1911,0x2131,0x2931,0x2930,0x2930,0x292F,0x290F,0x290F,0x290F,0x210F,0x292F,0x210F,0x290F,0x212F,0x2110,0x2110,0x2130,0x2131,0x1931,0x1112,0x1133,0x1154,0x19D6,0x2218,0x2218,0x21F7,0x1154,0x1133,0x1932,0x1932,0x1911,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2930,0x210F,0x210F,0x292F,0x210F,0x210F,0x212F,0x290F,0x292F,0x2930,0x210F,0x210F,0x210F,0x212F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x1931,0x1932,0x10F2,0x10F2,0x1975,0x19B7,0x11B7,0x11D8,0x11D7,0x11B6,0x00F2,0x1153,0x1952,0x1931,0x2131,0x2151,0x2130,0x210F,0x210F,0x2130,0x2131,0x1931,0x1932,0x1153,0x1195,0x11B6,0x11F8,0x11F8,0x11F8,0x11D7,0x11B7,0x11B7,0x11D7,0x1A18,0x11D7,0x19F7,0x19B6,0x1175,0x1133,0x1932,0x2131,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2131,0x2131,0x2131,0x1911,0x1112,0x1154,0x19B6,0x21F7,0x21F7,0x19D7,0x1995,0x1133,0x1112,0x1911,0x1911,0x2131,0x2131,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x292F,0x210F,0x292F,0x290F,0x28EE,0x28AC,0x202A,0x40CC,0xCC9A,0xDCDA,0xDCB9,0xDC78,0xDC57,0xDC78,0xDC58,0xDC78,0xDC78,0xDCBA,0xED7D,0x48CC,0x282A,0x30EE,0x28EE,0x28EF,0x290F,0x2910,0x290F,0x290F,0x290F,0x210F,0x2930,0x2130,0x2110,0x2110,0x2110,0x2111,0x1911,0x1911,0x1112,0x1133,0x1175,0x19D8,0x11D8,0x11D8,0x19D7,0x1154,0x0912,0x1932,0x2132,0x2131,0x2110,0x2130,0x2110,0x2130,0x2110,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2910,0x2930,0x212F,0x210F,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x1930,0x1931,0x1132,0x1112,0x19B5,0x2217,0x19D6,0x19B6,0x1154,0x1132,0x1932,0x1931,0x2130,0x2130,0x2130,0x2131,0x1932,0x1132,0x1154,0x0975,0x11B6,0x11F8,0x19F8,0x11B7,0x0954,0x1133,0x1973,0x1952,0x1931,0x2131,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x292F,0x2930,0x210F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x292F,0x292F,0x290F,0x290F,0x290F,0x2910,0x2110,0x2130,0x2110,0x2110,0x212F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x28F0,0x2910,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x210F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x1911,0x1932,0x1932,0x1133,0x19B5,0x21F6,0x19D5,0x1994,0x1132,0x1932,0x1952,0x1931,0x2131,0x2131,0x1931,0x1931,0x1132,0x1154,0x19F7,0x1A18,0x19F8,0x1195,0x1132,0x1931,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1111,0x1953,0x19B5,0x11B6,0x19D7,0x19D7,0x1196,0x0955,0x0955,0x0955,0x1176,0x11B6,0x11D7,0x19F8,0x11B7,0x11B6,0x1195,0x1133,0x1112,0x1932,0x1932,0x1931,0x1931,0x2131,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2130,0x2131,0x2131,0x2131,0x2130,0x2131,0x2131,0x2131,0x2130,0x2131,0x2130,0x2130,0x1930,0x1910,0x1910,0x1931,0x1931,0x1911,0x1931,0x1931,0x1910,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x2111,0x1931,0x1931,0x1911,0x1931,0x1931,0x1911,0x1931,0x2131,0x1911,0x1911,0x1911,0x1911,0x1910,0x1910,0x1910,0x1931,0x1910,0x1911,0x1931,0x2131,0x1911,0x1910,0x1910,0x1910,0x1911,0x1911,0x1931,0x2131,0x1911,0x2111,0x1911,0x1931,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1931,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1910,0x1930,0x1931,0x1931,0x1930,0x1930,0x2130,0x2130,0x1930,0x1930,0x1910,0x2131,0x1910,0x1910,0x1910,0x1910,0x1910,0x1911,0x1911,0x1911,0x1911,0x1911,0x18F1,0x18F1,0x1911,0x1911,0x1911,0x1911,0x1912,0x1932,0x1953,0x1974,0x19D5,0x21F7,0x19F7,0x19D6,0x1995,0x1133,0x1112,0x1911,0x1931,0x1910,0x2131,0x2110,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x292F,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x20EF,0x2910,0x2110,0x2130,0x2110,0x2131,0x1911,0x1932,0x1933,0x19B6,0x21F7,0x19F7,0x11B6,0x0975,0x0954,0x0975,0x0974,0x0133,0x0934,0x0955,0x1196,0x11B6,0x19D7,0x21D6,0x1994,0x1932,0x1931,0x1911,0x2110,0x2110,0x2951,
  0x1932,0x1932,0x1932,0x1153,0x1154,0x1195,0x0996,0x09D7,0x11F8,0x09F8,0x1219,0x11F8,0x11B7,0x11B6,0x1154,0x1132,0x1111,0x1931,0x1931,0x1930,0x1931,0x1931,0x1972,0x1132,0x1153,0x1175,0x1196,0x11B7,0x09B7,0x11D8,0x09D8,0x11D8,0x11D8,0x09B6,0x1196,0x1154,0x1133,0x1932,0x1911,0x2131,0x2110,0x2931,0x2110,0x2110,0x2110,0x2110,0x2130,0x2131,0x2111,0x1911,0x1111,0x1132,0x1174,0x19B6,0x19F7,0x2218,0x19F7,0x1195,0x1174,0x1133,0x1932,0x1931,0x2111,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2930,0x2110,0x2110,0x2110,0x2930,0x2930,0x2910,0x2910,0x2910,0x210F,0x2910,0x2930,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x210F,0x2110,0x2930,0x210F,0x212F,0x210F,0x210F,0x2930,0x2110,0x2910,0x2910,0x2930,0x290F,0x2910,0x2910,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2110,0x2110,0x2110,0x2930,0x210F,0x2910,0x2930,0x2910,0x290F,0x290F,0x210F,0x2110,0x2930,0x2930,0x290F,0x212F,0x2930,0x210F,0x2910,0x2110,0x2930,0x2110,0x2130,0x2130,0x2930,0x2110,0x2110,0x210F,0x292F,0x290F,0x290F,0x290F,0x2930,0x210F,0x212F,0x210F,0x2110,0x2110,0x2110,0x212F,0x212F,0x212F,0x2130,0x2930,0x2930,0x210F,0x210F,0x2130,0x212F,0x212F,0x210F,0x212F,0x2930,0x212F,0x212F,0x2130,0x2930,0x212F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2130,0x212F,0x212F,0x210F,0x212F,0x2930,0x2930,0x2930,0x210F,0x210F,0x290F,0x2910,0x2930,0x2930,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x2110,0x2910,0x2910,0x290F,0x290F,0x2930,0x2910,0x210F,0x210F,0x2910,0x2910,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x210F,0x210F,0x290F,0x292F,0x210F,0x210F,0x290F,0x2930,0x290F,0x210F,0x290F,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2910,0x2910,0x210F,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x210F,0x2910,0x210F,0x210F,0x2930,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x2910,0x2910,0x210F,0x210F,0x2910,0x290F,0x290F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x2930,0x210F,0x210F,0x2910,0x210F,0x210F,0x290F,0x2910,0x210F,0x210F,0x2910,0x2910,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2110,0x2930,0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x210F,0x210F,0x212F,0x2930,0x2930,0x210F,0x210F,0x210F,0x290F,0x2930,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x290F,0x292F,0x292F,0x292F,0x210F,0x292F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x2130,0x2130,0x210F,0x2930,0x2130,0x2930,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2151,0x2151,0x1911,0x1132,0x1154,0x19F8,0x09B8,0x09D9,0x09DA,0x01DA,0x01BA,0x01DA,0x01BA,0x01DA,0x09DA,0x09D9,0x09D9,0x09B7,0x11B6,0x1195,0x1153,0x2152,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x1951,0x1952,0x1132,0x19D5,0x2237,0x1A17,0x11D6,0x1174,0x1132,0x1111,0x1931,0x2131,0x2131,0x2930,0x2930,0x2910,0x2910,0x2930,0x210F,0x292F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2131,0x2131,0x1932,0x1112,0x1133,0x1174,0x19D6,0x21F7,0x2218,0x21F7,0x1155,0x1133,0x1933,0x1932,0x1932,0x1931,0x2131,0x2151,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x292F,0x292F,0x210F,0x2930,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x292F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x2930,0x212F,0x212F,0x292F,0x210F,0x290F,0x290F,0x290F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x1931,0x1931,0x1932,0x1113,0x1134,0x19B7,0x19D8,0x11B8,0x11D8,0x11D8,0x11D7,0x0975,0x0912,0x1952,0x1931,0x1931,0x2151,0x2151,0x2110,0x210F,0x2130,0x2130,0x1910,0x1932,0x1933,0x1134,0x1155,0x11B6,0x19F8,0x1A18,0x19F8,0x11F7,0x11D7,0x11D7,0x19F8,0x19F7,0x19D7,0x1995,0x1112,0x1912,0x1931,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2131,0x2131,0x1911,0x1912,0x1112,0x1154,0x21D6,0x2217,0x21F7,0x19D6,0x1995,0x1153,0x1112,0x1111,0x2131,0x2131,0x2131,0x2110,0x2110,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2930,0x2930,0x210F,0x290F,0x290F,0x210E,0x290E,0x28AD,0x204B,0x306A,0xD51C,0xDCDA,0xDCB9,0xDC78,0xDC98,0xDC78,0xDC57,0xDC78,0xDC78,0xDC78,0xDC99,0xE51C,0xBC5A,0x492E,0x286C,0x28EE,0x28EF,0x290F,0x2930,0x290F,0x290F,0x210F,0x210F,0x210F,0x2130,0x2930,0x2110,0x2110,0x2111,0x1911,0x1912,0x1133,0x1175,0x1196,0x11D8,0x11D8,0x11D9,0x11D8,0x1175,0x0933,0x1953,0x1952,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2950,0x2130,0x2130,0x2130,0x210F,0x2130,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x2910,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x2930,0x2910,0x290F,0x290F,0x2930,0x2930,0x290F,0x212F,0x2930,0x292F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x292F,0x212F,0x212F,0x212F,0x2130,0x1930,0x1931,0x1132,0x1133,0x19B5,0x21F7,0x19B6,0x19B5,0x1153,0x1112,0x1932,0x1931,0x2131,0x2131,0x1911,0x1911,0x1932,0x1153,0x1195,0x11B6,0x11B7,0x11D7,0x11F8,0x11D7,0x0975,0x0934,0x1153,0x1132,0x1911,0x1931,0x2131,0x2130,0x2130,0x2930,0x210F,0x210F,0x2930,0x212F,0x2130,0x212F,0x210F,0x2930,0x2110,0x2130,0x2110,0x2130,0x212F,0x292F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x212F,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x212F,0x210F,0x210F,0x212F,0x292F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x1911,0x1932,0x1132,0x1133,0x19B5,0x19D6,0x19D5,0x1994,0x1132,0x1931,0x1931,0x1951,0x1930,0x1910,0x1931,0x1931,0x1132,0x1154,0x19F7,0x19F8,0x19F8,0x1195,0x1132,0x1111,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2131,0x1911,0x1932,0x1994,0x19F6,0x11B6,0x11D7,0x11B7,0x1176,0x0955,0x0955,0x0955,0x0955,0x0976,0x11B7,0x11F8,0x11D8,0x11D7,0x11B6,0x0955,0x0913,0x1112,0x1112,0x1112,0x1111,0x1111,0x1931,0x1911,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1111,0x1111,0x1911,0x1911,0x1931,0x1111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1111,0x1911,0x1931,0x1111,0x1911,0x1911,0x1911,0x1111,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1111,0x1911,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1912,0x1912,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1932,0x1931,0x1911,0x1931,0x1911,0x1111,0x1911,0x1911,0x1911,0x1931,0x1931,0x1111,0x1911,0x1911,0x1911,0x1111,0x1111,0x1911,0x1111,0x1911,0x1912,0x1912,0x1911,0x1912,0x1912,0x1912,0x1112,0x1112,0x1112,0x1112,0x1132,0x1133,0x1154,0x1174,0x19F6,0x2217,0x19D6,0x1174,0x1133,0x1132,0x1931,0x1911,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x290F,0x212F,0x212F,0x210E,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x2930,0x2930,0x2130,0x2110,0x210F,0x210F,0x210F,0x2110,0x2910,0x2910,0x2930,0x2130,0x2111,0x2111,0x1912,0x1112,0x1995,0x21F7,0x19F8,0x11D7,0x0976,0x0975,0x0975,0x0954,0x0954,0x0954,0x0955,0x1196,0x11B6,0x19D7,0x1995,0x1974,0x1932,0x1911,0x1910,0x1910,0x2130,0x2130,
  0x2131,0x1911,0x1931,0x1932,0x1153,0x1174,0x0975,0x0996,0x09B7,0x11F8,0x11F8,0x11F8,0x11D8,0x11B7,0x1196,0x1174,0x1153,0x1932,0x1931,0x2151,0x2151,0x2151,0x1931,0x1932,0x1132,0x1153,0x1174,0x1195,0x11B6,0x11B7,0x11D8,0x1219,0x11F8,0x11F8,0x11B6,0x0975,0x1133,0x1132,0x1932,0x2132,0x2131,0x2931,0x2910,0x2910,0x2910,0x2930,0x2110,0x2130,0x2130,0x1911,0x1911,0x1932,0x1133,0x1174,0x19B6,0x19F7,0x2217,0x21F7,0x1195,0x1154,0x1132,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x2130,0x2130,0x210F,0x212F,0x2110,0x2110,0x2930,0x2110,0x2910,0x2910,0x210F,0x2930,0x2930,0x210F,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2930,0x2110,0x2110,0x2910,0x2110,0x2930,0x2110,0x212F,0x292F,0x292F,0x210F,0x210F,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x2930,0x2930,0x290F,0x2930,0x290F,0x292F,0x2930,0x210F,0x212F,0x2110,0x210F,0x2910,0x2930,0x2110,0x2910,0x2910,0x2910,0x290F,0x2930,0x290F,0x210F,0x210F,0x2930,0x290F,0x210F,0x210F,0x2930,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x210F,0x2930,0x2110,0x290F,0x290F,0x2930,0x290F,0x290F,0x2930,0x2930,0x210F,0x290F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x290F,0x2930,0x290F,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x2930,0x2110,0x210F,0x2130,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2930,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2930,0x2110,0x2910,0x2910,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x210F,0x290F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x2930,0x2930,0x210F,0x210F,0x290F,0x2930,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x210F,0x212F,0x212F,0x290F,0x290F,0x2930,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x2910,0x2910,0x2910,0x2910,0x290F,0x210F,0x212F,0x2130,0x2130,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2910,0x2910,0x2930,0x210F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2910,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2910,0x210F,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x290F,0x2110,0x2110,0x2110,0x210F,0x210F,0x2910,0x2910,0x290F,0x210F,0x210F,0x290F,0x210F,0x2930,0x290F,0x210F,0x2930,0x290F,0x290F,0x210F,0x212F,0x212F,0x292F,0x210F,0x212F,0x212F,0x292F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x290F,0x292F,0x292F,0x292F,0x212F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2930,0x2930,0x210F,0x2130,0x2130,0x2130,0x2151,0x2131,0x1912,0x1112,0x1154,0x11D8,0x11D9,0x09DA,0x01BA,0x01BA,0x01BA,0x01BA,0x01BA,0x01BA,0x01D9,0x01B9,0x09F9,0x09D8,0x11D7,0x11B6,0x1133,0x1952,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x2151,0x1952,0x1132,0x1995,0x2217,0x1A17,0x19D6,0x1195,0x0933,0x1112,0x1911,0x2131,0x2131,0x2931,0x2930,0x2110,0x2110,0x2110,0x210F,0x2930,0x292F,0x212F,0x210F,0x212F,0x210F,0x2110,0x2131,0x2111,0x1911,0x1911,0x1912,0x1133,0x1975,0x19B6,0x21F7,0x2A38,0x21D7,0x1155,0x1133,0x1933,0x1932,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2930,0x210F,0x292F,0x292F,0x292F,0x290F,0x210F,0x290F,0x2930,0x2910,0x2910,0x2930,0x290F,0x292F,0x292F,0x292F,0x212F,0x210F,0x2930,0x210F,0x212F,0x210F,0x212F,0x210F,0x2930,0x290F,0x290F,0x210F,0x2110,0x2130,0x2130,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x1951,0x1932,0x1133,0x0914,0x19B7,0x11B8,0x11B8,0x09D8,0x11F9,0x09D8,0x11D8,0x11B6,0x0953,0x1153,0x1952,0x1911,0x2151,0x2131,0x2110,0x2110,0x2130,0x2110,0x2131,0x2131,0x1932,0x1133,0x1134,0x1155,0x1195,0x19F7,0x19D7,0x11B6,0x11B6,0x19F7,0x19B6,0x19B6,0x1995,0x1133,0x1912,0x1911,0x2110,0x2130,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x2131,0x1931,0x1912,0x1112,0x1154,0x21F6,0x2217,0x2217,0x21F7,0x1995,0x1133,0x1112,0x1912,0x1931,0x2131,0x2131,0x2130,0x2110,0x2110,0x2110,0x210F,0x2930,0x210F,0x210F,0x210F,0x212F,0x2130,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x290E,0x28CD,0x28AC,0x2829,0xABF7,0xDD1B,0xDCBA,0xDC99,0xDC98,0xDC57,0xDC57,0xDC57,0xDC57,0xDC58,0xD458,0xDC99,0xDCFB,0xDD1D,0x492E,0x288D,0x28CE,0x28EF,0x290F,0x210F,0x290F,0x2930,0x290F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2111,0x1911,0x1912,0x1953,0x1174,0x1196,0x11B7,0x11D9,0x09D9,0x11D9,0x11D8,0x11B7,0x1196,0x1175,0x1133,0x1911,0x1911,0x2131,0x2130,0x2130,0x2130,0x2930,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x2930,0x2930,0x2930,0x2910,0x2930,0x290F,0x2910,0x2910,0x2110,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2910,0x290F,0x2930,0x210F,0x210F,0x212F,0x2930,0x210F,0x210F,0x292F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1931,0x1932,0x1132,0x1133,0x19B5,0x21F7,0x19B6,0x19B5,0x1154,0x1112,0x1932,0x1931,0x2131,0x1931,0x1911,0x1932,0x1953,0x1174,0x11B6,0x09B7,0x09B7,0x09B8,0x11F8,0x1218,0x0976,0x0954,0x1195,0x1153,0x1132,0x1911,0x2131,0x2130,0x2130,0x2110,0x210F,0x210F,0x290F,0x2930,0x212F,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x212F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x212F,0x212F,0x2930,0x2110,0x2910,0x2910,0x2910,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2111,0x1911,0x1932,0x1133,0x1153,0x19B5,0x19D6,0x19B5,0x1994,0x1132,0x1931,0x1952,0x1931,0x1930,0x1930,0x1930,0x1931,0x1132,0x1153,0x19F7,0x1A18,0x19D8,0x1196,0x1132,0x1931,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1952,0x1994,0x19B6,0x11D7,0x11B7,0x0976,0x0976,0x0975,0x0934,0x0934,0x0934,0x0955,0x0996,0x11D8,0x11D8,0x11F8,0x09D7,0x0976,0x0935,0x0913,0x0913,0x0913,0x0913,0x0912,0x0912,0x0912,0x1112,0x1112,0x1112,0x0912,0x1112,0x0912,0x1112,0x0912,0x0912,0x0912,0x1112,0x0912,0x0912,0x0912,0x0912,0x0912,0x1112,0x1112,0x0912,0x0912,0x0912,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1133,0x1112,0x1132,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1133,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1133,0x1132,0x1153,0x1153,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1133,0x1132,0x1132,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1113,0x1113,0x1113,0x1133,0x1133,0x1154,0x1154,0x1175,0x21F7,0x2217,0x19F7,0x1174,0x1153,0x1132,0x1931,0x1911,0x2131,0x2130,0x2130,0x2930,0x2930,0x2930,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x2130,0x2930,0x2930,0x2130,0x2130,0x2111,0x1911,0x1912,0x1112,0x1175,0x19F7,0x19F7,0x19F8,0x11B7,0x0976,0x0975,0x0955,0x0975,0x0975,0x0995,0x11B6,0x19B7,0x19B6,0x19B6,0x1974,0x1932,0x1911,0x2110,0x20F0,0x2110,0x2930,
  0x2130,0x2110,0x1911,0x1931,0x1932,0x1133,0x1154,0x1175,0x0996,0x09B7,0x11D8,0x11F8,0x09D8,0x11D8,0x11D7,0x1196,0x1154,0x1133,0x1932,0x1931,0x2131,0x2131,0x1911,0x1931,0x1911,0x1132,0x1153,0x1174,0x1195,0x11B7,0x1218,0x11F8,0x1219,0x1218,0x11D7,0x0996,0x0954,0x1153,0x1132,0x1911,0x2131,0x2131,0x2931,0x2110,0x2110,0x2910,0x2110,0x2130,0x2130,0x2130,0x2131,0x1911,0x1131,0x1132,0x1154,0x19B5,0x2217,0x2217,0x19D6,0x1995,0x1133,0x1133,0x1932,0x2132,0x2131,0x2131,0x2130,0x2130,0x210F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2910,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x210F,0x2910,0x2910,0x290F,0x210F,0x2930,0x2930,0x2910,0x210F,0x2930,0x2110,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x2110,0x2110,0x2910,0x2110,0x2930,0x2930,0x2930,0x2910,0x2930,0x2910,0x2910,0x2910,0x2930,0x2910,0x210F,0x2930,0x2930,0x2910,0x210F,0x2930,0x2910,0x2910,0x2110,0x2910,0x2930,0x2910,0x2110,0x2910,0x2930,0x2910,0x210F,0x2910,0x2930,0x210F,0x2910,0x2910,0x2930,0x2910,0x2910,0x2930,0x2910,0x2110,0x2110,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x210F,0x210F,0x2910,0x2910,0x2110,0x2110,0x210F,0x210F,0x210F,0x2910,0x2930,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2110,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x2110,0x2130,0x2130,0x2130,0x2930,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x2930,0x210F,0x210F,0x290F,0x2910,0x290F,0x2910,0x2910,0x2930,0x210F,0x2930,0x2910,0x290F,0x210F,0x2930,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2930,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2930,0x210F,0x210F,0x2930,0x2910,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x290F,0x292F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2910,0x2930,0x2910,0x2930,0x2930,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x292F,0x290F,0x292F,0x210F,0x292F,0x292F,0x292F,0x292F,0x290F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2151,0x2131,0x1932,0x1133,0x1175,0x1A18,0x11F9,0x01D9,0x01BA,0x01BA,0x01DA,0x01BA,0x01BA,0x01DA,0x01DA,0x09D9,0x09D8,0x09D8,0x11F7,0x19D6,0x1133,0x1932,0x2152,0x2131,0x2130,0x2130,0x2130,0x2131,0x2151,0x2151,0x1931,0x1132,0x1974,0x21F6,0x19F6,0x19F7,0x1195,0x1154,0x1153,0x10F1,0x1932,0x2131,0x2951,0x2131,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1932,0x1133,0x1154,0x19B6,0x2218,0x2238,0x1996,0x1154,0x1154,0x1133,0x1932,0x1931,0x1911,0x2131,0x2110,0x2130,0x2110,0x2110,0x210F,0x290F,0x292F,0x292F,0x292F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2930,0x2930,0x212F,0x2130,0x2130,0x212F,0x210F,0x290F,0x2910,0x2110,0x2930,0x212F,0x2930,0x210F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x1931,0x1952,0x1974,0x0934,0x1196,0x19B8,0x0998,0x11D9,0x09D9,0x09D9,0x09F9,0x09F8,0x11D8,0x11B6,0x0933,0x1953,0x1932,0x2152,0x2130,0x2110,0x2110,0x2130,0x2130,0x2131,0x2131,0x2152,0x1932,0x1112,0x1112,0x1953,0x1974,0x1154,0x1974,0x1994,0x1994,0x1994,0x1953,0x1132,0x1911,0x1910,0x1910,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x1931,0x2152,0x1932,0x1112,0x1174,0x21F6,0x2217,0x2238,0x21F7,0x1995,0x1133,0x1111,0x1911,0x1931,0x2131,0x2130,0x2130,0x2110,0x2110,0x210F,0x20EF,0x2930,0x2910,0x2930,0x210F,0x210F,0x210F,0x2110,0x2930,0x2910,0x210F,0x290F,0x290F,0x290F,0x28CE,0x288C,0x2009,0x8AD3,0xDD3C,0xDCDA,0xDC99,0xDC78,0xDC78,0xDC57,0xDC57,0xDC57,0xDC57,0xDC78,0xDC78,0xDC99,0xE51C,0xBC19,0x304B,0x28AD,0x28CE,0x28EF,0x290F,0x2910,0x2930,0x2930,0x290F,0x210F,0x210F,0x2110,0x2130,0x2131,0x1931,0x1932,0x1953,0x1995,0x11B6,0x0997,0x09B8,0x09D9,0x09D9,0x09D9,0x09D9,0x09D8,0x11B7,0x1196,0x1174,0x1953,0x1931,0x2131,0x2130,0x2130,0x2130,0x2930,0x2130,0x212F,0x212F,0x2110,0x2130,0x2130,0x2930,0x2930,0x210F,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2910,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x2910,0x210F,0x290F,0x2930,0x2930,0x210F,0x210F,0x212F,0x2930,0x210F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x1930,0x1931,0x1931,0x1932,0x1133,0x19B6,0x2217,0x19D6,0x1995,0x1974,0x1132,0x1131,0x1911,0x1931,0x1931,0x1952,0x1953,0x1154,0x1195,0x0996,0x09B7,0x01B8,0x09D9,0x1219,0x1219,0x0997,0x0176,0x0995,0x0974,0x1153,0x1932,0x2131,0x2131,0x2131,0x2930,0x2130,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x210F,0x2110,0x2930,0x210F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x292F,0x210F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2930,0x2930,0x2110,0x2110,0x2130,0x2110,0x1911,0x1931,0x1973,0x1153,0x1154,0x19B5,0x19B5,0x19B5,0x1974,0x1132,0x1932,0x1951,0x2151,0x1910,0x1930,0x1930,0x1931,0x1111,0x1153,0x19F7,0x1A18,0x19D7,0x1195,0x1112,0x1931,0x1910,0x2130,0x2110,0x2130,0x2110,0x210F,0x2130,0x210F,0x2130,0x2130,0x210F,0x2110,0x2130,0x1931,0x1931,0x1132,0x1995,0x19D6,0x11D7,0x0996,0x0956,0x0976,0x1196,0x1175,0x0114,0x0934,0x0955,0x0976,0x09D8,0x09D8,0x11F9,0x11F8,0x09B8,0x0997,0x11B7,0x11B7,0x19D7,0x11D7,0x11B6,0x11B6,0x1196,0x1196,0x1196,0x1196,0x1196,0x1195,0x1196,0x1196,0x1196,0x1196,0x1195,0x1195,0x1196,0x1196,0x11B6,0x1196,0x1196,0x1196,0x1196,0x1196,0x11B6,0x11B6,0x11B6,0x1196,0x19B6,0x19B6,0x19B6,0x19B6,0x11B6,0x1196,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x19B6,0x11B6,0x1196,0x1196,0x1196,0x1196,0x11B6,0x1196,0x1196,0x1196,0x1196,0x1195,0x1195,0x1195,0x1196,0x1196,0x1196,0x1196,0x1196,0x1196,0x11B6,0x1196,0x11B6,0x1196,0x11B6,0x1196,0x11B6,0x11B6,0x1195,0x11B6,0x11B6,0x1195,0x11B6,0x11B6,0x11B6,0x11B6,0x19B6,0x11B6,0x11B6,0x11B6,0x19B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x19B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x19B6,0x11B6,0x11B6,0x11B6,0x11B6,0x19B6,0x19B6,0x11B5,0x11B5,0x1195,0x1195,0x1195,0x11B6,0x1195,0x1195,0x1195,0x11B5,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x11B6,0x11B6,0x11B6,0x1196,0x11B6,0x11B6,0x11B6,0x11B6,0x1196,0x1196,0x19D7,0x19D7,0x19F7,0x19F7,0x19D6,0x1174,0x1153,0x1132,0x1131,0x1931,0x2131,0x2110,0x2110,0x2110,0x210F,0x2930,0x2930,0x2930,0x2930,0x20EF,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1112,0x1113,0x1175,0x19D7,0x11D8,0x11D8,0x09B7,0x0997,0x0996,0x0176,0x0996,0x09B6,0x11B7,0x11D7,0x11B7,0x19B6,0x1995,0x1953,0x1932,0x2111,0x2110,0x2110,0x2110,0x2110,
  0x2110,0x2110,0x2131,0x2131,0x1911,0x1111,0x1133,0x1154,0x1175,0x0996,0x11B7,0x11D8,0x11F8,0x11F8,0x11D8,0x11D7,0x11B6,0x0954,0x1133,0x1932,0x1931,0x1911,0x2131,0x1911,0x1931,0x1931,0x1932,0x1153,0x1174,0x1195,0x11D7,0x11F8,0x09F8,0x1218,0x11F8,0x11D7,0x11B6,0x1195,0x1133,0x1932,0x1932,0x2111,0x2931,0x2111,0x2110,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x1931,0x1931,0x1111,0x1132,0x1174,0x19B5,0x21F7,0x2217,0x19B6,0x1995,0x1134,0x1112,0x1932,0x1932,0x2111,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2910,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x210F,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2930,0x210F,0x212F,0x2930,0x2130,0x212F,0x210F,0x2930,0x212F,0x210F,0x210F,0x2910,0x2910,0x2930,0x210F,0x2930,0x290F,0x2910,0x210F,0x210F,0x212F,0x2910,0x2930,0x2910,0x210F,0x210F,0x2910,0x210F,0x2910,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x2930,0x2910,0x210F,0x290F,0x210F,0x2910,0x2110,0x2110,0x210F,0x210F,0x2130,0x2110,0x2110,0x2130,0x2930,0x2930,0x2930,0x292F,0x292F,0x290F,0x292F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2930,0x2930,0x2930,0x212F,0x210F,0x210F,0x292F,0x210F,0x292F,0x210F,0x292F,0x292F,0x212F,0x292F,0x210F,0x212F,0x292F,0x290F,0x290F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x212F,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2131,0x2152,0x1932,0x1133,0x1195,0x11D8,0x09D8,0x01D9,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01D9,0x09D9,0x09D8,0x11D7,0x19D6,0x0912,0x1932,0x2152,0x2151,0x2131,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1153,0x21D6,0x2217,0x19F7,0x11D6,0x1195,0x1153,0x0912,0x1111,0x1931,0x2131,0x2111,0x2931,0x2130,0x2130,0x2930,0x2110,0x2930,0x210F,0x212F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2111,0x2131,0x2131,0x1912,0x1912,0x1933,0x1154,0x19B6,0x2218,0x2A38,0x19B6,0x1975,0x1133,0x1112,0x1912,0x1932,0x2131,0x2110,0x2130,0x2110,0x2110,0x210F,0x2930,0x290F,0x290F,0x292F,0x292F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x212F,0x2130,0x2110,0x2110,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x212F,0x2930,0x290F,0x290F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x1931,0x1953,0x1174,0x0955,0x11D8,0x0998,0x0998,0x09B9,0x09D9,0x09D9,0x09D9,0x09D9,0x09D8,0x11F7,0x1175,0x1153,0x1932,0x2131,0x2131,0x2131,0x2130,0x2130,0x2131,0x2131,0x2131,0x2131,0x2131,0x1911,0x2152,0x1932,0x1932,0x1932,0x1932,0x1112,0x1932,0x1911,0x10F1,0x1931,0x1910,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x2930,0x2130,0x2130,0x2130,0x1931,0x1931,0x1931,0x1132,0x1132,0x1154,0x21F6,0x2217,0x2217,0x21F7,0x1995,0x1133,0x1112,0x1911,0x1931,0x2131,0x1910,0x2130,0x2110,0x2110,0x2110,0x210F,0x210F,0x2910,0x2930,0x2110,0x210F,0x210F,0x210F,0x2910,0x2910,0x2910,0x210F,0x290F,0x290F,0x28EE,0x28AD,0x202A,0x61D0,0xDD3C,0xDCDA,0xDC99,0xDC98,0xDC78,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC78,0xDC78,0xDC99,0xED5D,0x9AF5,0x302B,0x28AD,0x28EE,0x290F,0x2910,0x2930,0x2930,0x2910,0x2110,0x2130,0x2930,0x2130,0x2130,0x1911,0x1911,0x1932,0x1974,0x1195,0x11B7,0x09D8,0x01B8,0x01B9,0x01DA,0x09DA,0x09DA,0x09D9,0x09D8,0x11B7,0x1196,0x1974,0x1932,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x2910,0x2930,0x290F,0x210F,0x210F,0x212F,0x2930,0x2930,0x210F,0x2930,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x1931,0x1952,0x1132,0x1113,0x19B6,0x2217,0x19B6,0x19B5,0x1174,0x1112,0x1132,0x1931,0x1931,0x1952,0x1952,0x1974,0x1195,0x11D7,0x11D8,0x09F9,0x01B8,0x01B9,0x09F9,0x09F9,0x01D8,0x09F8,0x1218,0x11D6,0x1154,0x1132,0x1932,0x2131,0x2130,0x2130,0x2930,0x210F,0x2910,0x2910,0x2110,0x2130,0x2110,0x2110,0x2930,0x290F,0x290F,0x290F,0x292F,0x292F,0x290F,0x290F,0x290F,0x292F,0x292F,0x290F,0x212F,0x212F,0x210F,0x290F,0x2910,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x1931,0x1952,0x1973,0x1153,0x1174,0x19B5,0x21D6,0x19B5,0x1973,0x1132,0x1931,0x2151,0x2131,0x1930,0x1930,0x1930,0x1931,0x1932,0x1153,0x19F7,0x1A18,0x19D7,0x1195,0x1132,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x1930,0x1931,0x1931,0x1132,0x1195,0x19F7,0x11B7,0x09B7,0x0976,0x0976,0x0975,0x0955,0x0934,0x0934,0x0955,0x0976,0x0197,0x09D8,0x11F9,0x09D8,0x1219,0x11F9,0x11F9,0x225A,0x225A,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2239,0x2219,0x2239,0x2239,0x2218,0x2218,0x2219,0x2218,0x2238,0x2218,0x2218,0x2218,0x2218,0x1A18,0x2218,0x1A18,0x1A18,0x1A18,0x2218,0x2218,0x1A18,0x1A18,0x2218,0x2218,0x1A18,0x1A18,0x2218,0x1A18,0x2218,0x2218,0x1A18,0x1A18,0x2218,0x1A18,0x2218,0x2218,0x2238,0x1A18,0x2218,0x2218,0x2218,0x1A18,0x2218,0x19F8,0x2218,0x1A18,0x2218,0x1A18,0x2238,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2218,0x1A18,0x2218,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x19F8,0x1A18,0x1A18,0x19F8,0x1A18,0x2218,0x1A18,0x2238,0x1A18,0x2238,0x1A18,0x1A18,0x1A18,0x2218,0x1A18,0x1A18,0x2218,0x1A18,0x1A18,0x2238,0x2238,0x2218,0x2218,0x2238,0x2218,0x2238,0x2218,0x2238,0x2218,0x2238,0x2238,0x2238,0x2238,0x2239,0x2238,0x2239,0x1A18,0x2238,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2218,0x19D6,0x1175,0x1153,0x1132,0x1932,0x1931,0x1931,0x2110,0x2110,0x2110,0x2110,0x290F,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x292F,0x212F,0x292F,0x212F,0x212F,0x292F,0x212F,0x212F,0x2150,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x1932,0x1132,0x1133,0x1175,0x11D7,0x11D7,0x09D8,0x09B8,0x09B8,0x09B7,0x09B7,0x11D7,0x11D7,0x11F8,0x19F7,0x19D7,0x19B6,0x1174,0x1952,0x1931,0x2111,0x2110,0x2110,0x2110,0x2110,
  0x2110,0x2110,0x2110,0x2110,0x2131,0x1931,0x1932,0x1132,0x1154,0x1175,0x11D7,0x11D8,0x1219,0x11F9,0x11F8,0x09D8,0x11D7,0x1196,0x1154,0x1133,0x1911,0x1931,0x2131,0x2131,0x2131,0x2131,0x1911,0x1132,0x1133,0x1174,0x1196,0x09B7,0x09D7,0x09F8,0x09F8,0x11F8,0x11F8,0x1196,0x1995,0x1133,0x1932,0x1932,0x18F1,0x2131,0x2931,0x2110,0x2110,0x2110,0x2930,0x2130,0x2151,0x2131,0x1931,0x1931,0x1131,0x1132,0x1174,0x19B5,0x19F7,0x19F7,0x19D7,0x1995,0x1133,0x1133,0x1912,0x2132,0x2111,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x212F,0x212F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x210F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2930,0x210F,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x2930,0x290F,0x2910,0x2110,0x2110,0x2910,0x210F,0x2910,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x2930,0x290F,0x290F,0x210F,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x2110,0x2130,0x210F,0x212F,0x292F,0x210F,0x292F,0x292F,0x292F,0x212F,0x212F,0x292F,0x292F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x292F,0x292F,0x212F,0x2130,0x2130,0x2130,0x2150,0x2150,0x1930,0x1930,0x2150,0x2130,0x2150,0x2130,0x2130,0x2130,0x210F,0x2930,0x212F,0x212F,0x212F,0x2130,0x2131,0x2131,0x1911,0x1112,0x1195,0x19F8,0x09B8,0x01B9,0x01B9,0x01BA,0x01BA,0x01DA,0x01BA,0x01BA,0x01B9,0x09D9,0x09D9,0x11D8,0x1A17,0x1195,0x0912,0x1131,0x1951,0x2151,0x2151,0x2130,0x2130,0x2130,0x2131,0x2151,0x1931,0x1931,0x1132,0x1994,0x2217,0x2238,0x1A17,0x19D7,0x11B5,0x1133,0x10F2,0x1912,0x1931,0x2131,0x2131,0x2130,0x2130,0x2930,0x2110,0x2130,0x212F,0x212F,0x210F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x1912,0x1932,0x1133,0x1154,0x1995,0x2A38,0x2218,0x19B6,0x1975,0x1133,0x1112,0x1912,0x1931,0x2131,0x2131,0x2130,0x2110,0x2110,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x210F,0x2110,0x2110,0x2130,0x210F,0x212F,0x212F,0x210F,0x210F,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1932,0x1133,0x0934,0x1A19,0x11F9,0x0998,0x09B9,0x01B9,0x01DA,0x01DA,0x01D9,0x01D9,0x01B8,0x1219,0x1A18,0x0933,0x1132,0x1931,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2110,0x2131,0x2131,0x2131,0x1931,0x1932,0x1932,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2131,0x1931,0x1931,0x1132,0x1132,0x1174,0x21F7,0x2217,0x2217,0x21F6,0x1174,0x1133,0x1132,0x1931,0x1931,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x210F,0x2910,0x210F,0x2910,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x28EE,0x20AD,0x286B,0x40CC,0xD4DB,0xD4BA,0xDC99,0xDCB9,0xDC78,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC77,0xDC57,0xDC78,0xD478,0xE51C,0x8A93,0x302A,0x288C,0x28EE,0x290F,0x290F,0x210F,0x210F,0x2930,0x2110,0x2130,0x2110,0x2130,0x2131,0x1911,0x1911,0x1933,0x19B6,0x11D7,0x11F8,0x09D9,0x09D9,0x01D9,0x01DA,0x01DA,0x09DA,0x09FA,0x09D9,0x11D8,0x11B7,0x1175,0x1133,0x1932,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x2110,0x2910,0x210F,0x290F,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x292F,0x2930,0x290F,0x290F,0x290F,0x2930,0x2930,0x210F,0x210F,0x292F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x1930,0x1930,0x1931,0x1132,0x1113,0x19B6,0x21F7,0x19B6,0x19B6,0x1174,0x1132,0x1131,0x1131,0x1931,0x1952,0x1973,0x1175,0x1196,0x11D8,0x1219,0x09F9,0x01B9,0x01D9,0x01F9,0x01F9,0x01F9,0x0A1A,0x123A,0x11F7,0x0975,0x1133,0x1932,0x2131,0x2131,0x2110,0x2110,0x210F,0x290F,0x2910,0x2130,0x2130,0x2130,0x2130,0x212F,0x292F,0x210F,0x210F,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x292F,0x290F,0x292F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1932,0x1952,0x1974,0x1154,0x1195,0x19B6,0x19B6,0x21B5,0x1153,0x1132,0x1931,0x2151,0x2131,0x2130,0x1930,0x1930,0x1930,0x1131,0x1173,0x1A17,0x1A18,0x19F7,0x1195,0x1132,0x1931,0x1910,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x212F,0x2930,0x2130,0x2110,0x2130,0x2131,0x1931,0x1911,0x1112,0x1194,0x19D7,0x11B6,0x11D7,0x0996,0x0955,0x0955,0x0934,0x0955,0x0935,0x0135,0x0976,0x09B7,0x09D8,0x09D8,0x09D8,0x11F8,0x11F8,0x11F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19D8,0x21F8,0x19F8,0x19D7,0x21F8,0x19D7,0x19F8,0x21F8,0x21F8,0x19F8,0x19F8,0x19F8,0x19F8,0x2218,0x2218,0x19F8,0x19F8,0x21F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x21F8,0x21F8,0x19F8,0x2218,0x19F7,0x19F8,0x2218,0x19F7,0x19F7,0x19F8,0x19F7,0x19F8,0x19F8,0x19F7,0x19F7,0x19F7,0x19F7,0x19F8,0x19D7,0x19F7,0x19F8,0x19D7,0x19F8,0x19F7,0x19F7,0x19F8,0x19F8,0x19F7,0x19F7,0x19D7,0x19F8,0x19F8,0x19F7,0x19F7,0x19F8,0x19D7,0x19D7,0x19D7,0x19F7,0x19F8,0x19F7,0x19F7,0x19F7,0x19F7,0x19D7,0x19F7,0x19D7,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x19D7,0x19D7,0x19F7,0x19F7,0x19D7,0x19D7,0x19F7,0x19D7,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x19D7,0x19D7,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x1A17,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x21F8,0x19F7,0x19F7,0x2218,0x2218,0x19F8,0x1A18,0x19F8,0x19F7,0x19F7,0x19F7,0x19F7,0x19F8,0x19F8,0x1A18,0x1A18,0x2218,0x2218,0x19D7,0x19D7,0x19B6,0x1174,0x1133,0x1132,0x1932,0x1931,0x1931,0x2110,0x2110,0x2130,0x2110,0x2930,0x2910,0x290F,0x210F,0x210F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x190F,0x1910,0x2151,0x1932,0x1153,0x1154,0x1175,0x19D7,0x11D8,0x09B8,0x09D8,0x09B8,0x09D8,0x11D8,0x19F8,0x1A18,0x1A38,0x1A17,0x19B6,0x1974,0x1132,0x1931,0x1931,0x2110,0x2930,0x2910,0x2910,0x20F0,
  0x2110,0x2110,0x2110,0x2130,0x2130,0x1910,0x1911,0x1932,0x1132,0x1174,0x1195,0x11B7,0x11D8,0x11F8,0x1218,0x11F8,0x11F8,0x11D7,0x1196,0x1154,0x1132,0x1911,0x2131,0x2151,0x2131,0x1931,0x1911,0x1931,0x1132,0x1133,0x1174,0x1196,0x11D7,0x11F8,0x11F8,0x1219,0x11F8,0x11D7,0x1196,0x1155,0x1133,0x1912,0x1912,0x2111,0x2951,0x2131,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2131,0x1931,0x1131,0x1132,0x1174,0x19D6,0x2217,0x21F7,0x21F7,0x1995,0x1134,0x1933,0x1932,0x1911,0x2111,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x292F,0x290F,0x2930,0x292F,0x290F,0x290F,0x292F,0x210F,0x210F,0x210F,0x292F,0x210F,0x292F,0x292F,0x212F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2930,0x2910,0x2910,0x210F,0x2910,0x2910,0x2930,0x2910,0x2110,0x210F,0x2110,0x2910,0x2910,0x2110,0x2930,0x212F,0x210F,0x2110,0x2110,0x2110,0x2930,0x2930,0x212F,0x210F,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x212F,0x212F,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x212F,0x212F,0x2110,0x2110,0x210F,0x210F,0x290F,0x290F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x290F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x290F,0x290F,0x290F,0x2930,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x2930,0x2930,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x2110,0x2910,0x2910,0x290F,0x290F,0x210F,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2910,0x2110,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x2930,0x2110,0x210F,0x2110,0x2130,0x210F,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2930,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x292F,0x292F,0x292F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x292F,0x292F,0x290F,0x292F,0x212F,0x292F,0x212F,0x2130,0x2130,0x2130,0x1950,0x1130,0x090F,0x1150,0x1130,0x1930,0x2130,0x2130,0x2130,0x210F,0x2130,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1132,0x1174,0x19F8,0x11D8,0x09D9,0x01B9,0x01B9,0x01BA,0x01DA,0x01DA,0x01BA,0x01B9,0x01B9,0x09D8,0x09D7,0x19F7,0x1174,0x1132,0x1931,0x1951,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1910,0x1931,0x1932,0x1953,0x19B5,0x2217,0x1A18,0x1A18,0x19D7,0x1174,0x1133,0x1112,0x1912,0x2132,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x2130,0x2930,0x2930,0x2110,0x2110,0x2110,0x2111,0x2111,0x2132,0x1912,0x1133,0x1134,0x1995,0x2A38,0x21F7,0x19B6,0x1995,0x1153,0x1132,0x1932,0x1931,0x2131,0x2111,0x2110,0x2110,0x2110,0x290F,0x290F,0x292F,0x292F,0x290F,0x292F,0x292F,0x292F,0x292F,0x2930,0x210F,0x2910,0x2110,0x2110,0x212F,0x212F,0x212F,0x2130,0x212F,0x2930,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2131,0x1932,0x1133,0x0955,0x11F9,0x09D9,0x01B9,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x01D9,0x09D8,0x11F8,0x1195,0x1133,0x1932,0x1931,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2131,0x2131,0x2131,0x2131,0x1931,0x2131,0x1911,0x1931,0x1911,0x1910,0x1910,0x2130,0x2130,0x2930,0x2930,0x2130,0x210F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1112,0x0912,0x1174,0x21F6,0x2217,0x2217,0x19F6,0x1194,0x1133,0x1112,0x1911,0x1911,0x2131,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x2930,0x2110,0x210F,0x2930,0x2910,0x2910,0x2930,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x28CD,0x286C,0x2009,0xB3F8,0xDCDA,0xDCB9,0xE4B9,0xDC78,0xDC77,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC78,0xDC99,0xE51B,0x9B15,0x386B,0x28AD,0x28EE,0x28EF,0x290F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2110,0x2110,0x2111,0x1911,0x1912,0x1133,0x1196,0x11D7,0x09D9,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x09D9,0x09D9,0x11B8,0x19D7,0x1174,0x1932,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2930,0x2930,0x290F,0x290F,0x2910,0x2930,0x2930,0x290F,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x210F,0x292F,0x290F,0x290F,0x2930,0x210F,0x212F,0x210F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1930,0x1931,0x1132,0x1113,0x19B6,0x21F7,0x19B6,0x19B6,0x1154,0x1132,0x1132,0x1131,0x1131,0x1152,0x1174,0x1195,0x1197,0x11D9,0x09F9,0x01FA,0x01D9,0x01D9,0x01FA,0x01FA,0x01D9,0x01D9,0x09F9,0x09F8,0x11D7,0x1154,0x1932,0x2131,0x2131,0x2110,0x2110,0x2930,0x2910,0x2910,0x2130,0x2130,0x2130,0x210F,0x292F,0x292F,0x290F,0x210F,0x210F,0x212F,0x290F,0x210F,0x212F,0x212F,0x290F,0x290F,0x290F,0x292F,0x212F,0x292F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x290F,0x290F,0x292F,0x292F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x2131,0x2131,0x1911,0x1932,0x1953,0x1174,0x1154,0x19B6,0x19B6,0x19B5,0x21B5,0x1953,0x1932,0x1931,0x2131,0x2130,0x2151,0x2130,0x1930,0x1931,0x1132,0x1153,0x19F7,0x1A18,0x19F7,0x11B5,0x1132,0x1931,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x1930,0x1931,0x1931,0x1132,0x1154,0x19B6,0x11D7,0x11D8,0x09B7,0x0976,0x0155,0x0135,0x0955,0x0955,0x0976,0x0997,0x09B7,0x09D7,0x11D8,0x11D7,0x11B7,0x11B7,0x11B6,0x1196,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1995,0x1996,0x1195,0x1195,0x1996,0x1996,0x1195,0x1995,0x1995,0x1996,0x1996,0x19B6,0x1995,0x1996,0x1995,0x1995,0x1996,0x1996,0x1995,0x1995,0x1195,0x1996,0x1195,0x19B6,0x1195,0x19B6,0x1195,0x1995,0x1995,0x1995,0x1995,0x1996,0x1995,0x1996,0x1195,0x1195,0x1995,0x1996,0x1195,0x1996,0x1996,0x1995,0x1195,0x1195,0x1195,0x1995,0x1195,0x1995,0x1195,0x1195,0x1195,0x1995,0x1195,0x1995,0x1175,0x1195,0x1195,0x1195,0x1995,0x1995,0x1195,0x1995,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1995,0x1995,0x1175,0x1195,0x1195,0x1995,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1995,0x1995,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1995,0x19B5,0x1995,0x1995,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1175,0x1195,0x1175,0x1175,0x1175,0x1195,0x1195,0x1195,0x1195,0x1155,0x1154,0x1154,0x1133,0x1133,0x1132,0x1932,0x1931,0x1931,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x290F,0x290F,0x210F,0x210F,0x290F,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x1910,0x1931,0x1932,0x1132,0x1974,0x1154,0x11B6,0x19D7,0x11D8,0x11D8,0x11D8,0x11D8,0x11B7,0x11D7,0x19F7,0x19D7,0x19D6,0x19B5,0x1994,0x1953,0x1932,0x1931,0x1930,0x2110,0x2130,0x2930,0x2910,0x2910,
  0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x1931,0x1952,0x1152,0x1153,0x0975,0x0996,0x09D7,0x1218,0x1219,0x11F8,0x11F8,0x11B7,0x1196,0x1154,0x1112,0x1911,0x1931,0x2151,0x2131,0x1931,0x1931,0x1931,0x1132,0x1133,0x1174,0x1195,0x09B7,0x09D7,0x11F8,0x1219,0x11F8,0x11B7,0x1196,0x1155,0x1133,0x1912,0x1912,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2131,0x2151,0x1931,0x1132,0x1153,0x1174,0x19B6,0x19D7,0x19F7,0x21F7,0x1975,0x1154,0x1933,0x1932,0x1911,0x2111,0x2131,0x2130,0x2110,0x2930,0x2930,0x210F,0x210F,0x212F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x210F,0x292F,0x212F,0x212F,0x292F,0x292F,0x292F,0x212F,0x290F,0x290F,0x210F,0x2910,0x2930,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x290F,0x290F,0x2930,0x212F,0x210F,0x210F,0x212F,0x292F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x292F,0x212F,0x210F,0x210F,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x290F,0x210F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x2930,0x210F,0x210F,0x210F,0x2910,0x2930,0x2910,0x2930,0x2910,0x2930,0x2910,0x2930,0x210F,0x2910,0x2910,0x2930,0x210F,0x2910,0x210F,0x210F,0x212F,0x212F,0x210F,0x290F,0x210F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2930,0x210F,0x210F,0x210F,0x290F,0x292F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2930,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x210F,0x2930,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2910,0x2910,0x210F,0x292F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x210F,0x2930,0x290F,0x290F,0x210F,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x292F,0x210F,0x210F,0x210F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x292F,0x292F,0x212F,0x2130,0x210F,0x212F,0x2150,0x2171,0x1950,0x00CE,0x32D6,0x4358,0x0930,0x1130,0x1930,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x1112,0x1154,0x11B6,0x11D8,0x11F9,0x0A1A,0x09FA,0x01DA,0x01B9,0x09DA,0x01B9,0x09D9,0x09F9,0x11F9,0x11F8,0x1195,0x1153,0x1953,0x1952,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x1911,0x1932,0x1932,0x1133,0x1174,0x19D7,0x2218,0x2218,0x19D6,0x1174,0x1113,0x1112,0x1912,0x2132,0x2151,0x2131,0x2130,0x2110,0x2130,0x210F,0x2130,0x212F,0x212F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2111,0x2152,0x2152,0x1932,0x1132,0x1133,0x1995,0x21F7,0x21F7,0x21F7,0x1975,0x1133,0x1113,0x1932,0x1932,0x2131,0x2111,0x2110,0x2110,0x2910,0x292F,0x292F,0x290F,0x290F,0x292F,0x210F,0x290F,0x210F,0x290F,0x2910,0x2910,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1952,0x0954,0x11B7,0x09D8,0x01B9,0x09DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01FA,0x09FA,0x09F9,0x09D8,0x19F8,0x1154,0x1112,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2131,0x2110,0x2131,0x2131,0x2131,0x1911,0x2131,0x2131,0x2131,0x2130,0x2130,0x210F,0x2110,0x2930,0x2930,0x210F,0x2110,0x2110,0x2110,0x2150,0x2151,0x2131,0x1931,0x1931,0x1132,0x1133,0x1174,0x19F6,0x2237,0x2217,0x19D6,0x1995,0x1133,0x1112,0x1911,0x1911,0x2131,0x2110,0x2110,0x2110,0x2130,0x210F,0x2130,0x2110,0x210F,0x210F,0x210F,0x2910,0x2930,0x2930,0x210F,0x210F,0x2930,0x2910,0x2910,0x290F,0x28EF,0x28CE,0x206C,0x282A,0x8293,0xE53C,0xDC99,0xDCB9,0xDC78,0xDC78,0xDC78,0xDC57,0xDC57,0xDC37,0xDC57,0xDC57,0xDC57,0xDC78,0xDC78,0xDC99,0xE4FB,0x92D3,0x302A,0x30CD,0x28CE,0x28EF,0x290F,0x20EF,0x210F,0x2110,0x2930,0x2130,0x2130,0x2110,0x2111,0x1911,0x1112,0x1995,0x19F8,0x1219,0x09D9,0x01D9,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01FA,0x01D9,0x09D9,0x09D8,0x2239,0x19B6,0x1112,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2930,0x2930,0x2930,0x290F,0x210F,0x2930,0x210F,0x2930,0x2930,0x2910,0x290F,0x290F,0x210F,0x2930,0x2930,0x290F,0x290F,0x2930,0x210F,0x2110,0x2930,0x210F,0x210F,0x2930,0x2930,0x292F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2150,0x1930,0x1931,0x1112,0x1113,0x19B6,0x2217,0x19D6,0x1995,0x1154,0x0912,0x1952,0x1952,0x1132,0x1153,0x1994,0x11B6,0x11D8,0x09D9,0x01D9,0x01FA,0x01FA,0x01FA,0x01FA,0x021A,0x01D9,0x01B9,0x09F9,0x11F9,0x1A18,0x1175,0x1112,0x1931,0x2131,0x2930,0x2930,0x2110,0x2910,0x2930,0x210F,0x2130,0x2130,0x2130,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x292F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x2130,0x212F,0x212F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2131,0x2132,0x1932,0x1132,0x1174,0x1995,0x19D6,0x21F7,0x19B6,0x1995,0x1994,0x1953,0x1932,0x2151,0x2131,0x1910,0x2130,0x1930,0x1950,0x1931,0x1132,0x1174,0x19F7,0x19F8,0x19F7,0x1195,0x1152,0x1951,0x2151,0x2130,0x2130,0x2110,0x2130,0x210F,0x2130,0x2930,0x210F,0x2110,0x2130,0x2130,0x2131,0x2131,0x1931,0x1112,0x1153,0x1195,0x11D7,0x11F8,0x1A19,0x11F8,0x0996,0x0175,0x0976,0x0996,0x11D7,0x09D7,0x11F8,0x11F8,0x11B6,0x0975,0x1154,0x1134,0x1133,0x1133,0x1112,0x1132,0x1133,0x1133,0x1133,0x1132,0x1132,0x1933,0x1133,0x1933,0x1133,0x1112,0x1133,0x1133,0x1133,0x1133,0x1133,0x1112,0x1133,0x1133,0x1133,0x1133,0x1133,0x1112,0x1132,0x1933,0x1933,0x1132,0x1133,0x1132,0x1132,0x1133,0x1933,0x1133,0x1133,0x1133,0x1132,0x1133,0x1133,0x1133,0x1933,0x1933,0x1133,0x1133,0x1933,0x1933,0x1933,0x1133,0x1133,0x1133,0x1133,0x1133,0x1132,0x1132,0x1133,0x1133,0x1132,0x1132,0x1132,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1132,0x1133,0x1953,0x1953,0x1133,0x1133,0x1133,0x1132,0x1133,0x1133,0x1132,0x1133,0x1933,0x1933,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1933,0x1132,0x1132,0x1133,0x1133,0x1132,0x1132,0x1133,0x1133,0x1133,0x1133,0x1153,0x1153,0x1133,0x1132,0x1133,0x1133,0x1133,0x1112,0x1133,0x1933,0x1133,0x1133,0x1112,0x1112,0x1132,0x1132,0x1112,0x1112,0x1132,0x1133,0x1133,0x1133,0x1112,0x1112,0x1112,0x1932,0x1951,0x1931,0x1930,0x2130,0x2110,0x2110,0x2130,0x2110,0x2930,0x290F,0x290F,0x290F,0x292F,0x212F,0x210F,0x210F,0x2130,0x210F,0x2130,0x212F,0x2930,0x212F,0x292F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2150,0x2130,0x190F,0x1910,0x1910,0x1931,0x1952,0x1953,0x1154,0x1195,0x19D7,0x19F8,0x19F8,0x11D7,0x0976,0x0955,0x1175,0x1175,0x1154,0x1153,0x1153,0x1132,0x1952,0x1932,0x1931,0x1930,0x2130,0x2130,0x2130,0x2110,0x2930,0x2930,
  0x2130,0x2130,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x1931,0x1931,0x1132,0x0953,0x0995,0x09B6,0x11F8,0x1219,0x11F8,0x11D8,0x11D8,0x19D7,0x1195,0x1154,0x1132,0x1911,0x1931,0x1931,0x2151,0x2131,0x1911,0x1931,0x1132,0x1153,0x1174,0x11B6,0x09B6,0x11D7,0x11F8,0x11F8,0x11F8,0x11B7,0x1196,0x1175,0x1133,0x1912,0x1912,0x1911,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x2131,0x2151,0x1931,0x1132,0x1133,0x1154,0x19B6,0x19D7,0x21F8,0x21D7,0x1975,0x1954,0x1912,0x1932,0x1911,0x2131,0x2131,0x2110,0x2930,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x212F,0x2930,0x212F,0x210F,0x212F,0x212F,0x292F,0x292F,0x212F,0x212F,0x212F,0x2930,0x2910,0x2910,0x2910,0x2110,0x210F,0x2930,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x2930,0x212F,0x212F,0x2930,0x212F,0x292F,0x212F,0x210F,0x212F,0x210F,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x290F,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x210F,0x2910,0x2910,0x210F,0x2930,0x290F,0x2930,0x2910,0x210F,0x290F,0x290F,0x290F,0x2930,0x2910,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2910,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x290F,0x210F,0x2910,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x290F,0x2910,0x2910,0x292F,0x290F,0x210F,0x210F,0x290F,0x2930,0x290F,0x290F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x212F,0x2130,0x212F,0x210F,0x2130,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2131,0x2131,0x2151,0x2152,0x2131,0x2131,0x2131,0x2130,0x2110,0x2110,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x292F,0x212F,0x292F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x292F,0x292F,0x292F,0x2930,0x2130,0x212F,0x212F,0x2150,0x2171,0x1150,0x010F,0x0170,0x4C3B,0x545B,0x1A33,0x0130,0x1110,0x1930,0x2150,0x2130,0x210F,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1153,0x1175,0x11B7,0x11F9,0x11FA,0x09FA,0x09DA,0x09B9,0x01B9,0x01B9,0x09D9,0x09F9,0x1219,0x19F7,0x1174,0x1153,0x1972,0x2152,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x1931,0x1912,0x1953,0x1153,0x1995,0x21F7,0x2218,0x2217,0x21D6,0x1975,0x1113,0x1112,0x1912,0x2132,0x2131,0x2110,0x2931,0x2930,0x2110,0x2130,0x210F,0x210F,0x210F,0x2950,0x2110,0x2110,0x2110,0x2110,0x2130,0x2131,0x2131,0x2131,0x1931,0x1912,0x1133,0x1133,0x19B6,0x2218,0x21F7,0x21D7,0x1975,0x1133,0x1133,0x1932,0x1932,0x2111,0x2111,0x2110,0x2930,0x2930,0x210F,0x290F,0x290F,0x292F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2930,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2950,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x292F,0x292F,0x2930,0x2130,0x2130,0x1931,0x1132,0x1195,0x11F8,0x09B8,0x01D9,0x01DA,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01D9,0x09F9,0x1A19,0x1175,0x1112,0x1911,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2131,0x2130,0x2131,0x2130,0x2130,0x2151,0x2150,0x2130,0x210F,0x20EF,0x2110,0x2930,0x2110,0x2130,0x2130,0x2130,0x2131,0x2151,0x1931,0x1911,0x1132,0x0932,0x1174,0x21F6,0x2217,0x2217,0x21F7,0x1995,0x0912,0x1111,0x1111,0x1911,0x2131,0x2110,0x2110,0x2110,0x2110,0x210F,0x2130,0x2130,0x210F,0x210F,0x210F,0x2110,0x2930,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x28EF,0x28EE,0x28AD,0x202B,0x514E,0xCCBB,0xDCDA,0xDCB9,0xDC98,0xDC77,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC78,0xDC99,0xDCDA,0xB3B7,0x302A,0x38EE,0x28CE,0x290F,0x290F,0x290F,0x2910,0x2110,0x2110,0x2130,0x2130,0x1910,0x2111,0x1911,0x1933,0x1175,0x1A18,0x11F9,0x01B8,0x01B9,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x01DA,0x01D9,0x09D9,0x09D8,0x1A18,0x19D6,0x08F2,0x1932,0x2131,0x2131,0x2110,0x2110,0x2110,0x2130,0x210F,0x2130,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x210F,0x2930,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x2110,0x210F,0x210F,0x210F,0x2930,0x2930,0x212F,0x2930,0x292F,0x210F,0x212F,0x292F,0x2950,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x1930,0x1931,0x1112,0x1113,0x19B6,0x21F7,0x19D7,0x19B6,0x1154,0x1112,0x1152,0x1952,0x1132,0x1153,0x1175,0x1196,0x09B8,0x09D9,0x01D9,0x01FA,0x01DA,0x01DA,0x01FA,0x01FA,0x01B9,0x01B9,0x09F9,0x09F9,0x19F8,0x1175,0x1112,0x1931,0x2131,0x2951,0x2110,0x210F,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x2130,0x2130,0x1931,0x2152,0x1932,0x1132,0x1133,0x1995,0x19D6,0x21F7,0x19D6,0x19B6,0x1974,0x1953,0x1932,0x2152,0x2131,0x2130,0x1910,0x2130,0x2130,0x1930,0x1931,0x1132,0x1174,0x1A18,0x11F8,0x11F8,0x11B6,0x1153,0x1952,0x2131,0x2130,0x2130,0x210F,0x210F,0x212F,0x2930,0x2110,0x210F,0x2110,0x2130,0x2110,0x2110,0x1911,0x1911,0x1931,0x1132,0x1154,0x11B6,0x19F8,0x11F8,0x1218,0x11F8,0x11F8,0x11D7,0x11F7,0x11F8,0x11F7,0x1218,0x11B6,0x1175,0x1154,0x1133,0x1112,0x1112,0x1911,0x1911,0x1911,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1932,0x1911,0x1911,0x1911,0x1911,0x1932,0x1911,0x1911,0x1932,0x1911,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1932,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x1911,0x1931,0x1931,0x1931,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1932,0x1932,0x1911,0x1911,0x1911,0x1932,0x1932,0x1931,0x1931,0x1932,0x1911,0x1931,0x1931,0x1932,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1932,0x1931,0x1911,0x1931,0x1931,0x1931,0x1911,0x1911,0x1932,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1911,0x1931,0x1931,0x1931,0x1931,0x1930,0x1930,0x2130,0x2130,0x2110,0x2130,0x2110,0x210F,0x290F,0x290F,0x290F,0x290F,0x292F,0x212F,0x210F,0x2110,0x2130,0x2130,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x1910,0x1931,0x1911,0x1932,0x1133,0x1154,0x1195,0x19F7,0x2218,0x19F8,0x19D7,0x0975,0x0934,0x1134,0x1154,0x1153,0x1933,0x1932,0x1931,0x1931,0x1931,0x1931,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,
  0x2130,0x2110,0x210F,0x210F,0x210F,0x212F,0x2130,0x2110,0x2130,0x1931,0x1932,0x1152,0x1174,0x0995,0x11B6,0x11D7,0x11F8,0x11F8,0x1A19,0x11F8,0x19F7,0x1175,0x1154,0x1112,0x1112,0x2152,0x1931,0x2131,0x1931,0x1931,0x1931,0x1132,0x1173,0x1194,0x1195,0x11B6,0x11D7,0x11F8,0x11F8,0x19F8,0x11B7,0x1196,0x1175,0x1133,0x1932,0x1932,0x1911,0x2131,0x2131,0x2130,0x2130,0x2110,0x2130,0x2130,0x2131,0x2151,0x1931,0x1931,0x1932,0x1133,0x1174,0x19D6,0x21F7,0x21F7,0x19B6,0x1975,0x1954,0x1112,0x1932,0x2131,0x2131,0x2131,0x2950,0x2930,0x2930,0x290F,0x2930,0x212F,0x2930,0x292F,0x212F,0x212F,0x2130,0x2930,0x292F,0x292F,0x212F,0x292F,0x292F,0x292F,0x292F,0x210F,0x2930,0x2930,0x2910,0x2910,0x2910,0x2930,0x212F,0x2130,0x2930,0x2930,0x210F,0x210F,0x2130,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2930,0x210F,0x292F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2930,0x2930,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x212F,0x212F,0x292F,0x292F,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x292F,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x2930,0x210F,0x210F,0x290F,0x292F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x292F,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x212F,0x292F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x290F,0x290F,0x210F,0x210F,0x212F,0x2930,0x212F,0x212F,0x2110,0x2110,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x2130,0x212F,0x210F,0x212F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x212F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2930,0x2930,0x290F,0x210F,0x212F,0x210F,0x212F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2132,0x1932,0x1932,0x1931,0x2132,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x292F,0x292F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2991,0x1930,0x092F,0x010F,0x3358,0x441A,0x443A,0x3357,0x0130,0x0930,0x1130,0x1950,0x2150,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2131,0x1931,0x1952,0x1974,0x1175,0x1197,0x11B8,0x11D9,0x11D9,0x11D9,0x11F9,0x11F9,0x11F8,0x11F8,0x19F8,0x19B6,0x1153,0x1132,0x1931,0x1930,0x1910,0x2110,0x2110,0x210F,0x2130,0x212F,0x2130,0x2110,0x2130,0x2130,0x2131,0x1931,0x1932,0x1953,0x1154,0x1175,0x19D7,0x2217,0x2217,0x19D6,0x1974,0x1112,0x10F1,0x1911,0x1911,0x2131,0x2130,0x2930,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2110,0x2130,0x2110,0x2130,0x2130,0x2111,0x2132,0x1932,0x1133,0x1154,0x19B6,0x21F7,0x2218,0x21F7,0x1175,0x1113,0x1113,0x1112,0x2132,0x2132,0x2131,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x210F,0x290F,0x292F,0x290F,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x290F,0x2930,0x292F,0x292F,0x292F,0x292F,0x292F,0x2930,0x2110,0x2130,0x1931,0x1132,0x11D6,0x1219,0x09D9,0x09DA,0x01BA,0x01BA,0x01BA,0x01DA,0x01BA,0x01BA,0x01DA,0x01DA,0x01D9,0x09F9,0x1A19,0x19B6,0x08F1,0x1931,0x1910,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2131,0x2151,0x1930,0x1931,0x1931,0x1932,0x1132,0x1174,0x19F6,0x2217,0x2217,0x19D6,0x1994,0x1133,0x1111,0x1911,0x1911,0x2110,0x2110,0x2130,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x2930,0x2930,0x210F,0x2930,0x2910,0x290F,0x2930,0x290F,0x28EF,0x28EF,0x28CE,0x286C,0x282A,0xBC39,0xDCFB,0xE4DA,0xDC98,0xDC78,0xDC77,0xDC37,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC78,0xDCBA,0xDD3C,0x512D,0x308C,0x28CE,0x28EF,0x20EF,0x210F,0x2930,0x2110,0x2130,0x2130,0x2110,0x2110,0x1931,0x1911,0x1132,0x1154,0x11B7,0x09D8,0x01D9,0x01B9,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01B9,0x01D9,0x09B9,0x09B8,0x19F8,0x19D6,0x0912,0x1932,0x2152,0x2130,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x290F,0x290F,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2930,0x2930,0x290F,0x2910,0x210F,0x2930,0x2930,0x2930,0x290F,0x212F,0x210F,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x292F,0x292F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1930,0x1911,0x1112,0x1133,0x21D6,0x21F7,0x19B6,0x1995,0x1133,0x1133,0x1152,0x1152,0x1132,0x1174,0x1195,0x11D7,0x09D8,0x09F9,0x01D9,0x01FA,0x01DA,0x01DA,0x01FB,0x01DA,0x01B9,0x01B9,0x09F9,0x1219,0x11F8,0x1175,0x1112,0x1932,0x2131,0x2130,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x292F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x290F,0x2930,0x290F,0x210F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2131,0x2152,0x1111,0x1132,0x1133,0x1994,0x19B6,0x19B6,0x21F7,0x19D6,0x1975,0x1933,0x1932,0x1912,0x1931,0x1931,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1132,0x0954,0x1A18,0x1A19,0x11F8,0x11B6,0x1132,0x1131,0x1931,0x2130,0x2130,0x2150,0x212F,0x212F,0x212F,0x2930,0x2910,0x2110,0x2130,0x2130,0x2131,0x2131,0x1910,0x1911,0x1912,0x1133,0x1175,0x11B6,0x11D7,0x19F8,0x1A18,0x11F7,0x11D7,0x11F7,0x11D7,0x11D6,0x11B6,0x1174,0x0932,0x1132,0x1932,0x1911,0x1931,0x1911,0x1931,0x1910,0x1911,0x1931,0x1931,0x1931,0x1910,0x1910,0x2131,0x1910,0x1910,0x1910,0x2131,0x1910,0x2131,0x1911,0x2111,0x2111,0x2111,0x1910,0x2111,0x1911,0x2131,0x1910,0x2111,0x1910,0x1910,0x1910,0x2110,0x1910,0x2111,0x1910,0x2131,0x1910,0x2131,0x1911,0x2131,0x1910,0x1911,0x1911,0x1911,0x1910,0x2111,0x2110,0x2111,0x2110,0x2111,0x2111,0x2111,0x2111,0x2131,0x1910,0x2131,0x1910,0x1931,0x1911,0x2111,0x2111,0x2130,0x1910,0x1931,0x1910,0x2131,0x1931,0x2131,0x2131,0x2131,0x1911,0x2131,0x1911,0x1911,0x2131,0x1910,0x1910,0x1910,0x1910,0x2131,0x2111,0x2111,0x1911,0x2111,0x2111,0x2131,0x1910,0x2111,0x2131,0x1931,0x1910,0x1910,0x1910,0x1910,0x1910,0x2131,0x2111,0x2131,0x1911,0x2131,0x2131,0x1931,0x1911,0x2131,0x1931,0x1911,0x1911,0x1931,0x1931,0x1931,0x1911,0x2111,0x1911,0x1911,0x1911,0x2131,0x1911,0x2131,0x1910,0x2131,0x1931,0x1931,0x1910,0x2131,0x2131,0x2131,0x1931,0x2131,0x2131,0x1911,0x1910,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2110,0x2110,0x290F,0x210F,0x210F,0x292F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2130,0x1910,0x1931,0x1132,0x1133,0x1154,0x19B5,0x21F7,0x2218,0x21F7,0x1996,0x0934,0x0913,0x1113,0x1113,0x1953,0x1932,0x1932,0x1931,0x1911,0x1931,0x1910,0x1910,0x2130,0x2150,0x212F,0x210F,0x2130,0x210F,0x2930,0x2910,
  0x2110,0x2110,0x2130,0x2930,0x212F,0x212F,0x2930,0x2130,0x2130,0x1930,0x1931,0x1952,0x1152,0x1154,0x1175,0x1196,0x11D7,0x1A18,0x11F8,0x1A19,0x11F8,0x11D7,0x1195,0x1154,0x1133,0x1132,0x1932,0x1952,0x2151,0x1931,0x1931,0x1931,0x1132,0x1153,0x1174,0x1195,0x11B7,0x11D8,0x11F8,0x11F8,0x11F8,0x11D7,0x1196,0x1154,0x1953,0x1932,0x1911,0x1911,0x2151,0x2151,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2151,0x1911,0x1932,0x1133,0x1995,0x19B6,0x21F7,0x21F7,0x19B6,0x1975,0x1954,0x1933,0x1912,0x1911,0x2131,0x2130,0x2130,0x2130,0x2930,0x2130,0x212F,0x2930,0x2930,0x2930,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x290F,0x290F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x2130,0x2130,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x212F,0x292F,0x212F,0x210F,0x290F,0x210F,0x2110,0x2910,0x2910,0x212F,0x210F,0x210F,0x2930,0x212F,0x210F,0x2930,0x290F,0x290F,0x210F,0x212F,0x210F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x292F,0x210F,0x212F,0x212F,0x292F,0x210F,0x212F,0x212F,0x2930,0x210F,0x212F,0x292F,0x292F,0x210F,0x210F,0x292F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x292F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x212F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x290F,0x210F,0x210F,0x290F,0x2910,0x2910,0x2110,0x210F,0x2930,0x210F,0x290F,0x292F,0x2930,0x210F,0x2910,0x290F,0x210F,0x212F,0x292F,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x292F,0x292F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x212F,0x210F,0x290F,0x2930,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x290F,0x2930,0x2930,0x210F,0x210F,0x210F,0x2930,0x290F,0x210F,0x210F,0x210F,0x212F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x292F,0x290F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x212F,0x2130,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2152,0x1932,0x1932,0x1932,0x1932,0x1132,0x1932,0x1932,0x1931,0x2131,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x212F,0x2930,0x2930,0x292F,0x210F,0x212F,0x2130,0x2150,0x2170,0x2171,0x090F,0x010F,0x01B1,0x3C1A,0x341A,0x341A,0x33D9,0x0A12,0x010F,0x0930,0x1150,0x1950,0x2150,0x2130,0x2130,0x2150,0x2950,0x2130,0x2110,0x2130,0x2130,0x2131,0x1931,0x1952,0x1954,0x1175,0x1176,0x1197,0x11B8,0x11D8,0x1A18,0x11D7,0x11D7,0x11D6,0x1175,0x1153,0x1152,0x1931,0x1930,0x1930,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1952,0x1932,0x1933,0x1154,0x1175,0x19D7,0x21F7,0x2217,0x21F6,0x1174,0x1133,0x1111,0x1911,0x2131,0x2131,0x2131,0x2110,0x2110,0x2130,0x2130,0x210F,0x210F,0x2130,0x212F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x2132,0x1953,0x1133,0x1954,0x1996,0x21D7,0x2218,0x21D7,0x1175,0x1113,0x1113,0x1933,0x2132,0x2132,0x2110,0x2110,0x2130,0x2930,0x2110,0x2930,0x210F,0x212F,0x210F,0x210F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x290F,0x290F,0x2930,0x210F,0x292F,0x292F,0x290F,0x290F,0x2930,0x2110,0x1931,0x1133,0x11B6,0x11F8,0x09D9,0x01B9,0x01DA,0x01DA,0x01DA,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x09FA,0x09F9,0x11F8,0x19D7,0x0912,0x1931,0x2130,0x2130,0x2130,0x2950,0x2130,0x2130,0x2930,0x2110,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1911,0x1132,0x1112,0x1174,0x21F6,0x2217,0x2237,0x19D6,0x1994,0x1132,0x1111,0x1911,0x1911,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x2930,0x2930,0x210F,0x212F,0x292F,0x2930,0x210F,0x2130,0x2110,0x2110,0x290F,0x290F,0x290F,0x28EF,0x28EF,0x28AD,0x282B,0x8AF4,0xDCFB,0xDCDA,0xDCB9,0xDC98,0xDC78,0xDC36,0xDC57,0xDC57,0xDC57,0xE457,0xDC37,0xE457,0xDC37,0xDC57,0xDC37,0xDC58,0xDC78,0xDCBA,0xE53C,0x61CF,0x284B,0x28CE,0x20CE,0x290F,0x2910,0x2930,0x2110,0x2130,0x2110,0x2130,0x2131,0x1911,0x1932,0x1953,0x1174,0x19D7,0x11F9,0x01B9,0x01D9,0x01DA,0x01DA,0x01FA,0x01FA,0x01DA,0x01DA,0x09DA,0x09D9,0x09B8,0x11D7,0x19D6,0x1133,0x1111,0x2131,0x2131,0x2130,0x2110,0x210F,0x210F,0x2130,0x210F,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x210F,0x2930,0x290F,0x2930,0x2930,0x290F,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x292F,0x2930,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x1930,0x1931,0x1112,0x1113,0x19B6,0x21F8,0x19B6,0x1995,0x1134,0x1112,0x1153,0x1152,0x1152,0x1174,0x1195,0x11D7,0x09D8,0x09D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01FA,0x01FA,0x01BA,0x01B9,0x0A1A,0x1219,0x11D8,0x1175,0x1112,0x1911,0x2131,0x2130,0x2110,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x210F,0x292F,0x292F,0x290F,0x290F,0x2930,0x2910,0x210F,0x2910,0x210F,0x2930,0x2930,0x210F,0x210F,0x292F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x210F,0x212F,0x2930,0x2930,0x292F,0x212F,0x210F,0x2130,0x2130,0x1931,0x1932,0x1132,0x1133,0x1174,0x19D6,0x19D6,0x19B6,0x21D6,0x1995,0x1954,0x1933,0x1932,0x1911,0x2131,0x2131,0x2130,0x2130,0x2110,0x2131,0x1931,0x1131,0x1132,0x1174,0x1A18,0x1219,0x11F8,0x11B6,0x1133,0x1131,0x1931,0x2130,0x2130,0x2950,0x2930,0x212F,0x212F,0x212F,0x210F,0x2930,0x2110,0x2130,0x2131,0x2110,0x2110,0x2131,0x1931,0x1953,0x1154,0x1175,0x1175,0x11B6,0x11D6,0x11B5,0x1195,0x1195,0x0974,0x1174,0x1153,0x1132,0x1132,0x1931,0x1931,0x1911,0x1910,0x1910,0x2131,0x2110,0x2130,0x2130,0x2130,0x1910,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x1910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x1910,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x1910,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x210F,0x2930,0x210F,0x2110,0x290F,0x290F,0x210F,0x212F,0x2130,0x210F,0x210F,0x2110,0x2130,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x292F,0x292F,0x292F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2130,0x1931,0x1911,0x1932,0x1132,0x1153,0x19B5,0x21D6,0x2217,0x21F7,0x19B6,0x1134,0x0913,0x0912,0x1132,0x1932,0x1932,0x1931,0x2131,0x2130,0x1910,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2910,
  0x2130,0x2110,0x2130,0x210F,0x212F,0x210F,0x212F,0x2930,0x2930,0x2130,0x2130,0x1931,0x1952,0x1133,0x1133,0x1154,0x1196,0x11D7,0x1A18,0x1218,0x1A39,0x1A18,0x11B7,0x1176,0x0954,0x1133,0x1953,0x1952,0x1952,0x1931,0x1931,0x1931,0x1931,0x1132,0x1153,0x1174,0x1195,0x11B6,0x11F8,0x11F8,0x1218,0x11F8,0x11D7,0x1196,0x1174,0x1133,0x1932,0x1932,0x2131,0x2131,0x2151,0x2150,0x2130,0x212F,0x210F,0x2130,0x2130,0x2130,0x1910,0x1911,0x1912,0x1133,0x1995,0x21D7,0x21F7,0x19F7,0x19B6,0x1975,0x1153,0x1132,0x1912,0x1931,0x2131,0x2130,0x2130,0x2130,0x2110,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x2110,0x2110,0x210F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2110,0x2930,0x210F,0x2130,0x210F,0x2930,0x2910,0x210F,0x2910,0x2930,0x210F,0x2110,0x210F,0x210F,0x2930,0x212F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x2930,0x210F,0x2910,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x2910,0x2910,0x290F,0x2930,0x2910,0x2910,0x290F,0x290F,0x2910,0x2910,0x2930,0x210F,0x2910,0x2910,0x2930,0x290F,0x2110,0x210F,0x2930,0x2930,0x2930,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2910,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2110,0x2930,0x210F,0x210F,0x210F,0x210F,0x2910,0x2910,0x2930,0x2110,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x210F,0x290F,0x210F,0x2910,0x210F,0x2930,0x2930,0x2910,0x2930,0x2930,0x2110,0x2930,0x2930,0x290F,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x210F,0x290F,0x210F,0x2110,0x210F,0x2930,0x2110,0x2930,0x2930,0x2930,0x2910,0x2110,0x2130,0x2130,0x2110,0x210F,0x2930,0x2930,0x2930,0x2130,0x212F,0x212F,0x2930,0x2930,0x2930,0x210F,0x210F,0x2930,0x210F,0x210F,0x2910,0x2910,0x210F,0x212F,0x210F,0x290F,0x210F,0x2930,0x210F,0x2910,0x290F,0x2930,0x2910,0x2910,0x210F,0x210F,0x210F,0x2910,0x2930,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x290F,0x290F,0x292F,0x2910,0x2910,0x2930,0x210F,0x290F,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x210F,0x2930,0x2930,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2930,0x2130,0x2131,0x2131,0x2132,0x1932,0x1933,0x1933,0x1133,0x1153,0x1133,0x1133,0x1133,0x1132,0x1932,0x1931,0x1931,0x2130,0x2110,0x2130,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2130,0x2130,0x2130,0x2150,0x110F,0x010F,0x010F,0x2B57,0x2BF9,0x2C3A,0x2419,0x2C19,0x2B98,0x0191,0x0130,0x090F,0x1950,0x1950,0x2150,0x2130,0x2130,0x210F,0x2130,0x2930,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x1954,0x1154,0x1155,0x1155,0x1995,0x1975,0x1154,0x1153,0x1112,0x1111,0x1951,0x1931,0x1930,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x210F,0x2910,0x2910,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1912,0x1133,0x1154,0x1175,0x19D7,0x2217,0x19F7,0x21D6,0x1174,0x1112,0x1111,0x1911,0x2131,0x2131,0x2931,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x210F,0x2130,0x210F,0x2110,0x2110,0x2110,0x2131,0x2132,0x1912,0x1133,0x1154,0x19B6,0x21F7,0x2218,0x19D7,0x1175,0x1133,0x1113,0x1933,0x1932,0x1911,0x2131,0x2130,0x2130,0x2110,0x2110,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x212F,0x210F,0x212F,0x290F,0x2910,0x2910,0x2930,0x2930,0x292F,0x292F,0x290F,0x212F,0x2130,0x2130,0x2131,0x1132,0x1195,0x09D7,0x09B8,0x01D9,0x01DA,0x01DA,0x01DA,0x01DB,0x01DA,0x01DA,0x01DA,0x09FA,0x09FA,0x09D9,0x11F8,0x1195,0x0912,0x1931,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2151,0x2131,0x2152,0x1911,0x1111,0x1111,0x1132,0x1974,0x21D6,0x2217,0x2217,0x19D6,0x1995,0x1112,0x10F1,0x18F1,0x1911,0x2111,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2130,0x292F,0x290F,0x290F,0x290F,0x28CE,0x204B,0x40ED,0xD4DB,0xD4DA,0xDCB9,0xDC78,0xDC78,0xDC77,0xDC57,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC57,0xDC37,0xDC57,0xDC78,0xDCB9,0xDD1B,0xABF8,0x202A,0x30EE,0x28CE,0x20EF,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2131,0x2131,0x1911,0x1932,0x1174,0x11B7,0x09F8,0x01D9,0x01B9,0x01DA,0x01DA,0x01FA,0x01DA,0x01BA,0x01DA,0x01B9,0x09B9,0x11F9,0x19F7,0x19D6,0x1112,0x1932,0x1931,0x2110,0x2130,0x2110,0x210F,0x210F,0x2930,0x2110,0x2930,0x2930,0x2930,0x292F,0x212F,0x212F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x2930,0x210F,0x210F,0x2930,0x2910,0x290F,0x2930,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x2130,0x2130,0x212F,0x212F,0x2150,0x2150,0x1930,0x1931,0x1112,0x1113,0x19B6,0x21F7,0x19B6,0x19B6,0x1154,0x1112,0x1152,0x1152,0x1152,0x1153,0x1195,0x1196,0x09D8,0x09F9,0x01B9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01B9,0x09F9,0x1219,0x11D8,0x1175,0x1112,0x1932,0x2151,0x2130,0x2110,0x210F,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x292F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2930,0x210F,0x212F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2910,0x290F,0x2910,0x2930,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,0x212F,0x2130,0x2130,0x1911,0x1932,0x1132,0x1133,0x1174,0x19D6,0x2237,0x19B6,0x1995,0x1995,0x1954,0x1933,0x1912,0x1911,0x1931,0x2131,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1132,0x0933,0x0975,0x11F8,0x11F9,0x11F8,0x11B7,0x0933,0x1112,0x1911,0x1910,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x1911,0x1932,0x1953,0x1953,0x1953,0x1153,0x1974,0x1153,0x1133,0x1133,0x1953,0x1132,0x1932,0x1932,0x1911,0x1910,0x1910,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x2930,0x2930,0x2130,0x2110,0x210F,0x2130,0x2130,0x2131,0x2111,0x1931,0x1932,0x1133,0x1153,0x1995,0x19D6,0x21D7,0x21D6,0x1995,0x1154,0x1113,0x08F1,0x1111,0x1931,0x1951,0x1930,0x1930,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2150,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,
  0x2130,0x210F,0x2130,0x2130,0x212F,0x212F,0x212F,0x2930,0x2130,0x2130,0x2130,0x2131,0x1911,0x1932,0x1133,0x1154,0x1154,0x11B6,0x11D7,0x19F8,0x1219,0x11F8,0x11D8,0x11D7,0x1196,0x0954,0x1153,0x1153,0x1952,0x1952,0x2151,0x1931,0x1931,0x1931,0x1932,0x1153,0x1174,0x1196,0x11B7,0x11F8,0x11F8,0x1A19,0x1A18,0x11B7,0x1196,0x1154,0x1133,0x1932,0x1911,0x1931,0x1930,0x2130,0x2130,0x2130,0x2130,0x212F,0x2150,0x2130,0x2110,0x1910,0x1911,0x1912,0x1133,0x1995,0x19D6,0x2218,0x19D6,0x19B6,0x1994,0x1153,0x1132,0x1111,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x212F,0x2130,0x210F,0x2130,0x210F,0x212F,0x2130,0x212F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x210F,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2930,0x2110,0x2910,0x2910,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x2110,0x2910,0x2110,0x210F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x2910,0x2110,0x2910,0x2910,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x2910,0x210F,0x2910,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2110,0x210F,0x210F,0x2910,0x2910,0x290F,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x210F,0x2110,0x2910,0x2110,0x212F,0x212F,0x2110,0x2910,0x2910,0x2910,0x2910,0x2110,0x210F,0x2910,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x212F,0x210F,0x2110,0x210F,0x2930,0x210F,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2930,0x2930,0x2930,0x2110,0x2930,0x2910,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x210F,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x210F,0x2930,0x2930,0x210F,0x210F,0x2930,0x210F,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2930,0x210F,0x2130,0x210F,0x290F,0x210F,0x290F,0x2910,0x2910,0x2110,0x2930,0x210F,0x2110,0x2110,0x2930,0x2130,0x210F,0x210F,0x2110,0x2910,0x2910,0x2910,0x210F,0x2930,0x2930,0x2910,0x290F,0x290F,0x210F,0x2930,0x212F,0x2950,0x2130,0x2130,0x2130,0x1911,0x1932,0x1932,0x1133,0x1154,0x1174,0x1195,0x1195,0x1195,0x1195,0x1175,0x1174,0x1133,0x1132,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2130,0x2130,0x2130,0x2110,0x2150,0x2130,0x2130,0x210F,0x2130,0x2930,0x2930,0x212F,0x2130,0x2130,0x1950,0x112F,0x010F,0x01D1,0x2BD9,0x2419,0x2419,0x1BF9,0x2419,0x2C19,0x1AD5,0x0150,0x012F,0x110F,0x1970,0x1930,0x2130,0x210F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1932,0x1932,0x1932,0x1933,0x1113,0x1112,0x1112,0x1132,0x1112,0x1931,0x1931,0x1930,0x1930,0x1930,0x210F,0x2130,0x2130,0x2110,0x2930,0x2910,0x2930,0x2910,0x2910,0x2930,0x2110,0x2130,0x2130,0x2110,0x2111,0x1911,0x1932,0x1133,0x1154,0x1195,0x19D6,0x2217,0x2217,0x21D6,0x1994,0x1133,0x1112,0x1911,0x2111,0x2111,0x2110,0x2931,0x2130,0x210F,0x210F,0x212F,0x210F,0x212F,0x2950,0x212F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2110,0x2111,0x1911,0x1932,0x1133,0x1975,0x19B6,0x21D7,0x2218,0x19D7,0x1175,0x1134,0x1133,0x1932,0x1932,0x2131,0x2131,0x2110,0x2110,0x2130,0x210F,0x210F,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x292F,0x212F,0x210F,0x212F,0x292F,0x2930,0x2910,0x2910,0x2910,0x2930,0x292F,0x290F,0x290F,0x212F,0x2130,0x2130,0x1931,0x1932,0x1195,0x11F8,0x09B8,0x09D9,0x01DA,0x09FA,0x01DA,0x01DA,0x01FB,0x01FA,0x01DA,0x09FA,0x09D9,0x11D8,0x19D7,0x1174,0x1112,0x1931,0x2130,0x2130,0x2130,0x210F,0x212F,0x2930,0x212F,0x210F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x292F,0x2930,0x210F,0x210F,0x2131,0x2152,0x1931,0x1911,0x1112,0x1112,0x1154,0x21F6,0x2217,0x2217,0x21F6,0x1994,0x1132,0x10F1,0x18F1,0x18F0,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2930,0x2910,0x210F,0x212F,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x28EE,0x288D,0x1809,0x9B55,0xDCFB,0xDCB9,0xDCB9,0xDC58,0xDC78,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC16,0xE457,0xDC37,0xDC37,0xDC57,0xE478,0xDCB9,0xDCDA,0xCCFB,0x2009,0x28CE,0x28CE,0x20EF,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2131,0x2131,0x1931,0x1932,0x1154,0x19D7,0x11F8,0x09F9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01B9,0x01B9,0x01B9,0x09D9,0x11F9,0x1A17,0x19B5,0x1112,0x1932,0x1931,0x2130,0x2130,0x2130,0x2130,0x212F,0x2110,0x2110,0x212F,0x212F,0x292F,0x2930,0x212F,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x290F,0x210F,0x2930,0x2910,0x2930,0x290F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2930,0x2130,0x210F,0x2930,0x2930,0x2110,0x2930,0x2110,0x210F,0x210F,0x212F,0x2130,0x2130,0x212F,0x2150,0x2150,0x1930,0x1911,0x1112,0x1133,0x19B6,0x21F7,0x19D7,0x19B6,0x1154,0x1112,0x1152,0x1152,0x1132,0x1153,0x1174,0x11B6,0x11D7,0x09D9,0x09D9,0x01D9,0x01B9,0x01D9,0x01DA,0x01D9,0x01D9,0x01D9,0x09F9,0x1219,0x11B7,0x1154,0x1112,0x1932,0x2131,0x2130,0x2110,0x210F,0x2930,0x2930,0x2130,0x2110,0x2110,0x210F,0x212F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2930,0x212F,0x210F,0x2930,0x212F,0x210F,0x2110,0x2910,0x2910,0x2910,0x2910,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x292F,0x210F,0x210F,0x2930,0x2130,0x2130,0x1931,0x1931,0x1112,0x1133,0x1154,0x19D6,0x2217,0x19F6,0x1995,0x1154,0x1134,0x1133,0x1933,0x1932,0x1931,0x1931,0x2131,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x0934,0x0975,0x11F8,0x11F9,0x11F9,0x11D8,0x0954,0x1133,0x1931,0x1931,0x2130,0x2130,0x2130,0x210F,0x2930,0x212F,0x212F,0x210F,0x210F,0x2130,0x2110,0x2110,0x2130,0x2131,0x2131,0x2131,0x1931,0x1931,0x1932,0x1932,0x1112,0x1111,0x1932,0x1932,0x1911,0x1931,0x1911,0x1911,0x1911,0x2130,0x1910,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2110,0x2110,0x210F,0x212F,0x210F,0x2110,0x2130,0x210F,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x210F,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x2130,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x210F,0x2110,0x2130,0x2110,0x2130,0x2110,0x210F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x210F,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2130,0x2130,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x2110,0x210F,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2130,0x2131,0x2131,0x1911,0x1911,0x1133,0x1133,0x1995,0x21D6,0x21D7,0x21D6,0x1995,0x1133,0x1112,0x1112,0x1931,0x1951,0x1951,0x1930,0x1930,0x1930,0x2130,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x290F,0x290F,
  0x2130,0x2130,0x2930,0x2130,0x212F,0x2130,0x210F,0x290F,0x210F,0x210F,0x2130,0x2130,0x2131,0x1931,0x1912,0x1132,0x1153,0x1154,0x1196,0x11B7,0x11F8,0x1219,0x11F8,0x11F8,0x11D7,0x0995,0x1174,0x1133,0x1132,0x1952,0x1951,0x1951,0x1930,0x1931,0x1931,0x1132,0x1153,0x1174,0x1176,0x11B7,0x11F8,0x11F8,0x1A19,0x11F8,0x11B7,0x1196,0x1174,0x1133,0x1112,0x1931,0x1931,0x2151,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2930,0x2131,0x1911,0x1911,0x1112,0x1133,0x1995,0x19D6,0x19D6,0x19D6,0x19D5,0x1994,0x1153,0x1132,0x1132,0x1931,0x1931,0x2131,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2910,0x2110,0x2910,0x2910,0x2930,0x2930,0x2930,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2930,0x2130,0x2930,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x2110,0x2930,0x2110,0x2110,0x2930,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x20F0,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2930,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2910,0x2110,0x2930,0x2110,0x2910,0x2910,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x210F,0x2110,0x2110,0x210F,0x2110,0x2110,0x2930,0x2110,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2930,0x210F,0x210F,0x212F,0x210F,0x1910,0x1930,0x1911,0x1932,0x1153,0x1175,0x19B6,0x11D7,0x11F8,0x1218,0x1218,0x11F8,0x11F7,0x11D7,0x1195,0x1153,0x1952,0x1931,0x1910,0x2130,0x2130,0x2110,0x2130,0x2930,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x1930,0x1950,0x092F,0x014F,0x2B57,0x23F9,0x1C19,0x13F9,0x13F9,0x1C19,0x243A,0x2BB8,0x01B1,0x014F,0x092F,0x1970,0x2150,0x2150,0x2130,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2151,0x2131,0x2152,0x2152,0x1911,0x1932,0x1932,0x1912,0x1932,0x1931,0x1931,0x1910,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x2110,0x2910,0x2930,0x2910,0x2910,0x2930,0x2930,0x2110,0x2130,0x2130,0x2110,0x2110,0x2131,0x2132,0x1912,0x1133,0x1133,0x1195,0x19F6,0x2237,0x2237,0x21D6,0x1994,0x1133,0x10F1,0x1911,0x18F0,0x2111,0x2130,0x2930,0x2950,0x2130,0x212F,0x210F,0x212F,0x2150,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2111,0x1932,0x1132,0x1133,0x1155,0x19B7,0x2218,0x2218,0x21F8,0x1175,0x0913,0x1133,0x1933,0x1932,0x2131,0x2131,0x2110,0x2130,0x2130,0x212F,0x2130,0x212F,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x290F,0x290F,0x2930,0x2910,0x2930,0x2930,0x292F,0x290F,0x210F,0x210F,0x2130,0x2110,0x1910,0x1931,0x1154,0x19D7,0x11D8,0x09D9,0x09B9,0x09DA,0x01BA,0x01B9,0x09FA,0x01D9,0x09D9,0x09D9,0x09D8,0x11D8,0x19F7,0x1174,0x1132,0x1931,0x2130,0x2130,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x2930,0x2930,0x210F,0x2110,0x2131,0x2152,0x1932,0x1112,0x1112,0x1154,0x21F6,0x2217,0x2237,0x19D6,0x1174,0x1132,0x10F1,0x1911,0x2111,0x2110,0x2130,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x290F,0x28EF,0x20AD,0x286B,0x490D,0xDD3C,0xDCDA,0xDCB9,0xDC78,0xDC57,0xDC57,0xDC37,0xDC57,0xE457,0xE457,0xDC16,0xE437,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xDC57,0xDC78,0xDC99,0xDCFB,0xABB7,0x286B,0x28AD,0x28CE,0x20EF,0x210F,0x210F,0x210F,0x2130,0x210F,0x2130,0x2131,0x2131,0x1911,0x1911,0x1133,0x1175,0x11D7,0x09D8,0x09F9,0x01D9,0x01D9,0x01D9,0x01DA,0x01B9,0x01B9,0x09D9,0x09D8,0x11F8,0x2217,0x1994,0x1112,0x1911,0x1910,0x2130,0x2130,0x2110,0x2130,0x212F,0x290F,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x2930,0x210F,0x210F,0x290F,0x290F,0x2930,0x290F,0x2930,0x2930,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x210F,0x2930,0x2930,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2930,0x2110,0x2930,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x2150,0x2150,0x1930,0x1911,0x1112,0x1133,0x19D6,0x2218,0x19D7,0x1195,0x1154,0x1133,0x1152,0x1952,0x1132,0x1132,0x1173,0x11B5,0x11B7,0x09D8,0x09D9,0x01D9,0x09F9,0x09F9,0x01D9,0x01D9,0x09F9,0x09F9,0x11F8,0x11D8,0x1175,0x1133,0x1112,0x1931,0x2131,0x2110,0x2130,0x210F,0x2110,0x2930,0x2130,0x2110,0x2130,0x2930,0x210F,0x292F,0x210F,0x2910,0x2910,0x2930,0x2910,0x2110,0x2110,0x210F,0x212F,0x2930,0x2930,0x2130,0x2130,0x210F,0x2930,0x2930,0x2910,0x2910,0x210F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2950,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1931,0x1132,0x1112,0x1174,0x19D6,0x21F7,0x21F7,0x19B6,0x1175,0x1133,0x1113,0x1932,0x1932,0x1931,0x1931,0x1910,0x2130,0x2130,0x2110,0x2110,0x2131,0x1931,0x1932,0x1133,0x0934,0x0996,0x11F9,0x09F9,0x09F9,0x09D8,0x0975,0x0933,0x1132,0x1931,0x1911,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2131,0x2131,0x1931,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x2111,0x2111,0x2110,0x1910,0x2130,0x2130,0x2110,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x2130,0x2110,0x2110,0x2110,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x2930,0x210F,0x2110,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x210F,0x2130,0x2930,0x210F,0x210F,0x2130,0x210F,0x2130,0x2130,0x210F,0x2130,0x210F,0x210F,0x210F,0x2930,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2930,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x212F,0x212F,0x2130,0x2110,0x2130,0x2930,0x2110,0x2130,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x294F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2131,0x1911,0x1932,0x1133,0x1154,0x1995,0x21F6,0x21F7,0x21D6,0x1975,0x1113,0x1112,0x1112,0x1931,0x2152,0x1951,0x2151,0x2130,0x192F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x292F,0x292F,
  0x2930,0x2130,0x2130,0x2130,0x2150,0x2130,0x210F,0x210F,0x210F,0x290F,0x2930,0x2110,0x2130,0x2131,0x2111,0x1932,0x1132,0x1153,0x1155,0x1196,0x11D7,0x11F8,0x1219,0x1219,0x11F8,0x11D7,0x11B6,0x0954,0x1153,0x1132,0x1952,0x1951,0x1951,0x1931,0x1931,0x1931,0x1132,0x1153,0x1175,0x1196,0x11B7,0x19F8,0x11F8,0x11F8,0x11F8,0x11B7,0x1196,0x1174,0x1153,0x1132,0x1931,0x1931,0x2151,0x2130,0x2130,0x2130,0x212F,0x2950,0x2130,0x2130,0x2111,0x2111,0x18F1,0x1112,0x1133,0x1175,0x19D6,0x19F6,0x19D6,0x19D6,0x1174,0x1153,0x1132,0x1132,0x1931,0x1931,0x2151,0x2151,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x1910,0x1930,0x1931,0x1952,0x1974,0x1995,0x11D6,0x11F8,0x11F8,0x09F8,0x09D8,0x09F9,0x09F8,0x1218,0x11F8,0x11D7,0x11B5,0x1994,0x1952,0x1931,0x2131,0x2130,0x2130,0x2130,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x2150,0x2150,0x112F,0x092F,0x01D1,0x33F9,0x23F9,0x1419,0x1419,0x1419,0x13F9,0x243A,0x2C3A,0x12D4,0x0150,0x012F,0x112F,0x2150,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1910,0x1911,0x2131,0x1911,0x1911,0x2131,0x1930,0x2130,0x2130,0x2130,0x2150,0x212F,0x212F,0x2130,0x2930,0x2930,0x2910,0x2910,0x2910,0x290F,0x2930,0x290F,0x2930,0x2110,0x2930,0x2930,0x2130,0x2111,0x2111,0x1911,0x1912,0x1133,0x1154,0x1195,0x2217,0x2217,0x2217,0x21F6,0x1954,0x1933,0x1912,0x1911,0x2111,0x2131,0x2931,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1132,0x1134,0x1175,0x19B7,0x2218,0x2218,0x19D7,0x1175,0x1133,0x1133,0x1932,0x1931,0x1931,0x2131,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x292F,0x212F,0x290F,0x2930,0x2930,0x2910,0x2910,0x210F,0x290F,0x290F,0x210F,0x210F,0x2110,0x2110,0x1911,0x1132,0x1995,0x11D7,0x11F9,0x09B9,0x09B9,0x09B9,0x09B9,0x01B9,0x01B9,0x09D9,0x11D8,0x11F8,0x19D7,0x1194,0x1132,0x1131,0x1931,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x212F,0x292F,0x212F,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x290F,0x2930,0x2110,0x1910,0x2131,0x2132,0x1912,0x1112,0x1133,0x21D6,0x2217,0x2217,0x19D6,0x1994,0x1132,0x10F1,0x1911,0x1910,0x2110,0x2130,0x2130,0x2110,0x2110,0x2910,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x20CE,0x28AD,0x282A,0xABF8,0xDCFB,0xDCB9,0xD478,0xD457,0xDC78,0xDC37,0xDC37,0xDC37,0xE457,0xDC16,0xE457,0xDC37,0xE437,0xE437,0xDC16,0xDC37,0xE478,0xDC37,0xE478,0xDC99,0xDCBA,0x8AD4,0x308C,0x28AD,0x28EE,0x20EF,0x210F,0x210F,0x2930,0x2130,0x210F,0x2130,0x2130,0x2111,0x2131,0x1931,0x1932,0x1154,0x11B6,0x11D8,0x09D9,0x09D9,0x09D9,0x09D9,0x01B9,0x01B9,0x09D9,0x11F8,0x11D8,0x19D7,0x1995,0x1133,0x1132,0x1931,0x1910,0x2110,0x2130,0x2130,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x2910,0x290F,0x2930,0x2930,0x210F,0x2930,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x2930,0x2130,0x210F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2930,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2150,0x1930,0x1911,0x1112,0x1133,0x19B6,0x2218,0x19D7,0x19B6,0x1133,0x1133,0x1952,0x1952,0x1132,0x1152,0x1173,0x1195,0x11B6,0x11B7,0x11D8,0x09F9,0x0A19,0x09F9,0x09F9,0x09D8,0x09F8,0x11F8,0x11F8,0x11B7,0x1175,0x1133,0x1932,0x1931,0x2131,0x2130,0x2130,0x210F,0x2930,0x2930,0x2130,0x2130,0x210F,0x2110,0x292F,0x292F,0x210F,0x2930,0x2110,0x2910,0x2910,0x2910,0x2910,0x210F,0x2930,0x212F,0x212F,0x2930,0x2130,0x2130,0x2930,0x2930,0x2910,0x2910,0x292F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1112,0x1974,0x19B6,0x21F7,0x21F7,0x19D6,0x1995,0x1154,0x1133,0x1132,0x1932,0x1931,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1953,0x1175,0x0976,0x09B8,0x09F9,0x09F9,0x09F9,0x09D8,0x09B7,0x1195,0x1174,0x1932,0x1931,0x1911,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x1910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2930,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x290F,0x210F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x2930,0x210F,0x210F,0x2930,0x2110,0x210F,0x210F,0x212F,0x212F,0x212F,0x2930,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2110,0x2910,0x290F,0x210F,0x210F,0x212F,0x292F,0x210F,0x212F,0x212F,0x292F,0x210F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2930,0x212F,0x2930,0x2930,0x2930,0x2930,0x212F,0x2930,0x2930,0x2110,0x210F,0x2110,0x210F,0x2930,0x210F,0x212F,0x212F,0x2930,0x2930,0x212F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2110,0x2930,0x2930,0x2930,0x210F,0x210F,0x212F,0x2110,0x2110,0x2110,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x292F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x210E,0x212F,0x2950,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1932,0x1932,0x1112,0x1154,0x1995,0x21D6,0x21F6,0x21D6,0x1995,0x1133,0x1112,0x1911,0x1911,0x1931,0x2151,0x2150,0x2150,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,
  0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x210F,0x2930,0x2930,0x2930,0x2130,0x2131,0x2132,0x1932,0x1132,0x1133,0x1175,0x0996,0x11B7,0x11F8,0x1219,0x1A39,0x11F8,0x09B6,0x0975,0x0953,0x1133,0x1132,0x1931,0x1951,0x1931,0x1931,0x1931,0x1931,0x1932,0x1153,0x1174,0x1196,0x11B7,0x11D8,0x11F8,0x11D8,0x19F8,0x11B7,0x1195,0x1154,0x1132,0x1132,0x1951,0x2171,0x2130,0x2150,0x2150,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2111,0x1912,0x1112,0x1133,0x1174,0x19B6,0x21F6,0x19D6,0x21D6,0x1974,0x1153,0x1112,0x1111,0x1932,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2151,0x2131,0x2131,0x2131,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2131,0x2131,0x2131,0x2130,0x2110,0x2110,0x2130,0x2110,0x2111,0x2110,0x2110,0x2110,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2111,0x2111,0x2131,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2111,0x2130,0x2110,0x2111,0x2111,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2111,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x2110,0x2110,0x2110,0x2110,0x2111,0x2111,0x2110,0x2111,0x2110,0x2110,0x2110,0x2111,0x2110,0x2131,0x2110,0x2111,0x2110,0x2110,0x2110,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x2110,0x2131,0x2110,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x1910,0x1931,0x1931,0x1952,0x1952,0x1974,0x1195,0x11D6,0x11D7,0x09D8,0x09D9,0x01D9,0x01D9,0x09F9,0x09D9,0x0A19,0x1219,0x11F8,0x11D7,0x19D5,0x1173,0x1111,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x210F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2150,0x212F,0x212F,0x212F,0x212F,0x194F,0x112F,0x012F,0x12B4,0x2C19,0x2439,0x1419,0x0BF8,0x1419,0x13F8,0x1C19,0x2C39,0x343A,0x01F2,0x012F,0x090F,0x192F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x2110,0x2111,0x2151,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x2110,0x2130,0x2131,0x2131,0x1932,0x1952,0x1132,0x1153,0x1194,0x19D6,0x2217,0x2217,0x21D6,0x1954,0x1933,0x1912,0x18F1,0x2111,0x2110,0x2951,0x2130,0x2930,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x2131,0x1932,0x1132,0x1133,0x1175,0x19B7,0x21F8,0x2218,0x21D7,0x1175,0x1133,0x1133,0x1952,0x1931,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x292F,0x292F,0x290F,0x292F,0x212F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x212F,0x290F,0x210F,0x2930,0x2130,0x2110,0x1931,0x1912,0x1133,0x1996,0x19F8,0x1A19,0x11F9,0x11F9,0x09D9,0x11F9,0x1219,0x1A19,0x1A38,0x2217,0x19B5,0x0912,0x1111,0x1931,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x210F,0x212F,0x292F,0x292F,0x292F,0x210F,0x210F,0x292F,0x292F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2111,0x1911,0x1912,0x1912,0x1113,0x1995,0x21F7,0x2217,0x21D6,0x1995,0x1132,0x1111,0x1911,0x1931,0x2110,0x2951,0x2130,0x2110,0x2110,0x210F,0x2110,0x2910,0x2110,0x2910,0x2910,0x2930,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x290F,0x290F,0x20AD,0x182A,0x61D0,0xDD3C,0xD4B9,0xDC99,0xDC78,0xDC78,0xDC57,0xDC57,0xDC37,0xDC36,0xDC37,0xDC37,0xDC37,0xDC37,0xE437,0xE437,0xDC37,0xDC57,0xE457,0xDC57,0xDC78,0xDC99,0xDCDB,0x7A31,0x202A,0x28CD,0x20CE,0x20EF,0x290F,0x290F,0x2930,0x2130,0x2130,0x2110,0x2131,0x2131,0x2131,0x1931,0x1932,0x1994,0x21F6,0x11F7,0x11F8,0x11D8,0x09D8,0x11F9,0x11F9,0x11D8,0x11F8,0x19F8,0x1196,0x1155,0x1113,0x1112,0x1932,0x1931,0x2131,0x2130,0x2130,0x2110,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x212F,0x212F,0x2930,0x210F,0x290F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x210F,0x210F,0x2930,0x2930,0x290F,0x290F,0x2930,0x2930,0x212F,0x292F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2130,0x2930,0x2930,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2150,0x1930,0x1911,0x1112,0x1134,0x19D6,0x21F7,0x19B6,0x1195,0x1133,0x1132,0x1932,0x1932,0x1131,0x1131,0x1153,0x1174,0x1195,0x11B6,0x11D7,0x11F8,0x1A19,0x11F8,0x11F8,0x11F8,0x11F8,0x11F7,0x11B6,0x1195,0x1954,0x1112,0x1931,0x2131,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x212F,0x212F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x2930,0x2930,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2150,0x2130,0x2131,0x1911,0x1111,0x1132,0x1974,0x19B5,0x21F7,0x21F7,0x19D6,0x1174,0x1133,0x1953,0x1952,0x1932,0x2152,0x1911,0x1910,0x1910,0x1910,0x2130,0x2130,0x2151,0x1931,0x1932,0x1133,0x1174,0x11B6,0x09B7,0x09D9,0x09D9,0x09FA,0x09D9,0x09D9,0x09D8,0x11B7,0x11B6,0x1154,0x1932,0x1932,0x1931,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x210F,0x212F,0x210F,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x210F,0x210F,0x2910,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2110,0x2130,0x210F,0x210F,0x210F,0x2910,0x210F,0x210F,0x2910,0x2110,0x2930,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x290F,0x2930,0x290F,0x2930,0x2910,0x2110,0x2910,0x2910,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x210F,0x210F,0x210F,0x290F,0x210F,0x2910,0x2910,0x210F,0x210F,0x212F,0x2130,0x2110,0x2110,0x2110,0x210F,0x210F,0x2910,0x290F,0x290F,0x2930,0x290F,0x2910,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x292F,0x2130,0x2130,0x212F,0x210F,0x212F,0x292F,0x212F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2951,0x2151,0x2131,0x1911,0x1931,0x10F1,0x1113,0x1154,0x1995,0x19D6,0x21D6,0x21D6,0x1995,0x1112,0x10F2,0x1911,0x1911,0x2131,0x2131,0x1930,0x1930,0x190F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212E,0x212E,0x212F,0x212F,0x212F,0x212F,0x212F,
  0x212F,0x210F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x212F,0x2930,0x290F,0x290F,0x2930,0x2930,0x2130,0x2111,0x1931,0x1932,0x1133,0x1154,0x1175,0x11B7,0x11B7,0x11F8,0x1218,0x1218,0x11F8,0x11B7,0x1195,0x1174,0x1153,0x1132,0x1931,0x1951,0x1951,0x1931,0x1931,0x1932,0x1132,0x1153,0x1154,0x1176,0x11B7,0x11B7,0x11F8,0x11F8,0x11D8,0x11D7,0x1195,0x1174,0x1153,0x1132,0x1951,0x1931,0x2151,0x2150,0x2130,0x210F,0x2130,0x2130,0x2130,0x2951,0x2131,0x1911,0x1912,0x1112,0x1133,0x1995,0x19B5,0x21D6,0x21D6,0x19B5,0x1974,0x1153,0x1112,0x1112,0x1111,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x1911,0x1911,0x2131,0x2131,0x2130,0x2111,0x2111,0x2111,0x1911,0x2111,0x1911,0x1931,0x1931,0x1931,0x2111,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x1910,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2131,0x1931,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2111,0x1911,0x2131,0x2111,0x1911,0x2131,0x2131,0x2131,0x2131,0x1931,0x2131,0x2111,0x2111,0x1931,0x1911,0x2111,0x2111,0x1931,0x2131,0x2111,0x2111,0x1931,0x1911,0x1931,0x1911,0x1931,0x1931,0x2111,0x2131,0x1911,0x1911,0x1911,0x1931,0x1931,0x1911,0x1931,0x2131,0x1911,0x1911,0x1931,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1910,0x1931,0x1931,0x1911,0x1931,0x1931,0x1911,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x1911,0x2111,0x2111,0x2111,0x2111,0x1911,0x2111,0x2111,0x2111,0x1911,0x2111,0x2111,0x2111,0x2131,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2131,0x2111,0x2111,0x2131,0x2111,0x1911,0x2111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x2111,0x1911,0x2111,0x1911,0x2111,0x2111,0x2111,0x2111,0x1911,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x2111,0x2111,0x1911,0x2111,0x2111,0x1911,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x1911,0x1911,0x1911,0x1911,0x2111,0x2111,0x2111,0x2111,0x2111,0x1911,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2131,0x2111,0x2111,0x2131,0x1931,0x2111,0x2111,0x2131,0x1911,0x2131,0x2111,0x2111,0x1911,0x2111,0x2111,0x1911,0x2111,0x2111,0x2111,0x2111,0x1911,0x2111,0x1911,0x1911,0x1911,0x2111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1132,0x1132,0x1153,0x0954,0x0996,0x09B7,0x09D8,0x01D8,0x01D9,0x01F9,0x01D9,0x01D9,0x01D9,0x01D9,0x09F9,0x09D8,0x09B7,0x11D6,0x1174,0x1912,0x1911,0x1910,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x192F,0x192F,0x112F,0x0190,0x2B98,0x2419,0x13F8,0x13F8,0x0BF8,0x0BF9,0x1419,0x1419,0x2C5A,0x3C7A,0x1AD5,0x0150,0x090F,0x190F,0x2130,0x2130,0x210F,0x2130,0x2950,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x212F,0x2150,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x290F,0x2110,0x2110,0x2110,0x2131,0x2131,0x1931,0x1932,0x1153,0x1153,0x1195,0x19D6,0x2217,0x21F6,0x21B5,0x2195,0x1953,0x1912,0x1911,0x2111,0x2131,0x2130,0x2951,0x2130,0x210F,0x212F,0x212F,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1932,0x1133,0x1154,0x19D6,0x21F7,0x2218,0x21F7,0x1174,0x1153,0x1953,0x1932,0x1931,0x2131,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x292F,0x210E,0x292F,0x292F,0x210F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x210F,0x2130,0x2110,0x2130,0x1911,0x1931,0x1912,0x1133,0x1996,0x11B7,0x19D8,0x2219,0x19F9,0x2239,0x19F8,0x19D7,0x19B6,0x1174,0x1132,0x1111,0x1931,0x1910,0x1910,0x2130,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2131,0x1911,0x1931,0x1912,0x1113,0x1954,0x21F6,0x2217,0x21F7,0x1995,0x0912,0x10F1,0x1911,0x1931,0x2131,0x2110,0x2130,0x2110,0x2110,0x210F,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x210F,0x292F,0x210F,0x290F,0x290F,0x20CE,0x206C,0x2009,0xCCDB,0xD4DA,0xDC99,0xDC99,0xDC78,0xDC57,0xDC57,0xDC57,0xDC36,0xE457,0xDC37,0xDC37,0xDC37,0xDC37,0xE457,0xDC37,0xDC37,0xE457,0xE457,0xE478,0xDC58,0xDC78,0xDCDA,0x7A51,0x1809,0x28EE,0x28CE,0x210F,0x292F,0x290F,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2131,0x1931,0x1973,0x21D5,0x19B5,0x19D7,0x19D7,0x19D8,0x11D8,0x1A18,0x19F8,0x19D7,0x19B6,0x1955,0x1133,0x1912,0x1912,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x290F,0x290F,0x290F,0x210F,0x2930,0x212F,0x212F,0x2930,0x212F,0x210F,0x290F,0x290F,0x2910,0x2930,0x212F,0x292F,0x290F,0x2930,0x212F,0x212F,0x2910,0x2930,0x2930,0x2930,0x290F,0x210F,0x212F,0x292F,0x210F,0x210F,0x212F,0x212F,0x2130,0x212F,0x2930,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1910,0x1911,0x1132,0x1133,0x19B6,0x21F7,0x19D7,0x1995,0x1133,0x1133,0x1952,0x1931,0x1931,0x1931,0x1132,0x1973,0x1994,0x1995,0x1195,0x19B6,0x11D7,0x11D7,0x19F7,0x11D7,0x19D7,0x19B6,0x1995,0x1974,0x1933,0x1912,0x1911,0x2131,0x2150,0x2110,0x2130,0x212F,0x290F,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x210F,0x210F,0x2910,0x2110,0x2110,0x210F,0x2930,0x2910,0x2930,0x2930,0x290F,0x210F,0x2930,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2150,0x2130,0x1911,0x1111,0x1132,0x1954,0x21B5,0x21F6,0x21F7,0x21D6,0x1174,0x1133,0x1132,0x1132,0x1932,0x1951,0x1931,0x2130,0x1910,0x1910,0x1910,0x2130,0x2151,0x2151,0x1931,0x1132,0x1154,0x1175,0x11D7,0x09D9,0x09D9,0x09FA,0x01DA,0x01D9,0x09D9,0x09F9,0x09D8,0x11B7,0x1175,0x1153,0x1932,0x1931,0x2111,0x2131,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2930,0x2930,0x2910,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x210F,0x2130,0x2130,0x2110,0x2930,0x2110,0x2110,0x2930,0x2110,0x2910,0x2110,0x210F,0x2910,0x290F,0x212F,0x212F,0x210F,0x210F,0x2110,0x2110,0x210F,0x2930,0x2910,0x2910,0x2930,0x210F,0x2110,0x2910,0x2910,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2910,0x2110,0x2930,0x2110,0x2910,0x2910,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x2930,0x290F,0x2930,0x210F,0x290F,0x210F,0x2930,0x2930,0x290F,0x210F,0x2930,0x290F,0x2910,0x2910,0x2910,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2910,0x2910,0x290F,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x212F,0x210F,0x210F,0x212F,0x2130,0x210F,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2151,0x2131,0x2131,0x1911,0x1112,0x1933,0x1954,0x1995,0x19D6,0x21F7,0x21F6,0x1995,0x1153,0x1112,0x1911,0x1911,0x2111,0x2131,0x2130,0x2130,0x212F,0x210F,0x210F,0x212F,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212E,0x212F,0x210F,0x210F,0x212F,0x212F,
  0x210F,0x210F,0x210F,0x2930,0x2130,0x2130,0x2130,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2110,0x2131,0x1931,0x1932,0x1133,0x1154,0x1175,0x1196,0x11D7,0x11F8,0x1218,0x1A18,0x11F8,0x19F7,0x0975,0x0933,0x1133,0x1112,0x1952,0x1931,0x1931,0x1931,0x1952,0x1932,0x1132,0x1133,0x1154,0x1175,0x1197,0x11D8,0x11D8,0x11F8,0x11D7,0x11D7,0x1195,0x1154,0x1133,0x1132,0x1952,0x1931,0x2131,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2951,0x2131,0x1911,0x1111,0x1132,0x1133,0x1974,0x1995,0x19B6,0x21D6,0x19B5,0x1995,0x1174,0x1133,0x1112,0x1112,0x1112,0x1112,0x1111,0x1111,0x1112,0x1112,0x1112,0x1932,0x1112,0x1912,0x1912,0x1932,0x1912,0x1911,0x1911,0x1911,0x1931,0x1911,0x1912,0x1912,0x1912,0x1912,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1912,0x1912,0x1912,0x1932,0x1912,0x1912,0x1911,0x1932,0x1911,0x1912,0x1912,0x1912,0x1912,0x1932,0x1932,0x1932,0x1912,0x1912,0x1911,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1912,0x1932,0x1932,0x1932,0x1932,0x1912,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1912,0x1912,0x1912,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1931,0x1931,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1931,0x1932,0x1932,0x1931,0x1931,0x1931,0x1932,0x1932,0x1932,0x1912,0x1931,0x1932,0x1931,0x1931,0x1932,0x1931,0x1931,0x1932,0x1932,0x1932,0x1932,0x1932,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1912,0x1912,0x1911,0x1932,0x1912,0x1912,0x1912,0x1911,0x1912,0x1912,0x1912,0x1912,0x1932,0x1932,0x1932,0x1912,0x1912,0x1911,0x1911,0x1911,0x1912,0x1932,0x1932,0x1932,0x1932,0x1912,0x1932,0x1932,0x1932,0x1912,0x1912,0x1932,0x1912,0x1912,0x1912,0x1912,0x1912,0x1912,0x1932,0x1912,0x1912,0x1912,0x1912,0x1912,0x1912,0x1912,0x1932,0x1932,0x1912,0x1912,0x1912,0x1912,0x1912,0x1912,0x1932,0x1932,0x1912,0x1912,0x1932,0x1912,0x1912,0x1912,0x1912,0x1911,0x1912,0x1912,0x1932,0x1912,0x1912,0x1912,0x1932,0x1912,0x1932,0x1912,0x1912,0x1912,0x1912,0x1912,0x1912,0x1912,0x1932,0x1912,0x1932,0x1912,0x1912,0x1912,0x1932,0x1911,0x1912,0x1912,0x1932,0x1932,0x1932,0x1911,0x1911,0x1932,0x1912,0x1912,0x1932,0x1932,0x1911,0x1911,0x1932,0x1912,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1111,0x1111,0x1911,0x1111,0x10F1,0x1112,0x1112,0x1112,0x1112,0x1112,0x0933,0x0954,0x1196,0x09B7,0x09D8,0x09D9,0x01D9,0x01DA,0x01FA,0x01D9,0x01FA,0x01FA,0x09FA,0x09D9,0x09B8,0x09B7,0x11B6,0x1995,0x1132,0x2132,0x2131,0x2131,0x2130,0x2130,0x2110,0x2130,0x2130,0x2930,0x2110,0x2110,0x2130,0x210F,0x2130,0x2150,0x212F,0x212F,0x192F,0x112F,0x010E,0x1232,0x33F9,0x23F8,0x13F8,0x1419,0x0BF9,0x0BF9,0x0BF9,0x13D8,0x2439,0x3C7B,0x3398,0x0170,0x092F,0x1930,0x2150,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2130,0x2110,0x2930,0x2930,0x2930,0x2110,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x210F,0x210F,0x292F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2130,0x2131,0x2151,0x1951,0x1132,0x1132,0x1173,0x1194,0x19B6,0x2217,0x2217,0x21B6,0x1995,0x1133,0x1912,0x1911,0x1910,0x2131,0x2130,0x2150,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x2131,0x2131,0x1932,0x1112,0x1133,0x1174,0x19D6,0x21F7,0x2217,0x21F7,0x1174,0x1153,0x1133,0x1932,0x1932,0x1911,0x1931,0x2131,0x2110,0x2130,0x2130,0x2130,0x2930,0x212F,0x212F,0x292F,0x292F,0x210F,0x210F,0x212F,0x2930,0x212F,0x2130,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1931,0x1953,0x1953,0x1134,0x1134,0x1135,0x1134,0x1134,0x1134,0x1133,0x1133,0x1973,0x1932,0x1911,0x1910,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x292F,0x210F,0x292F,0x292F,0x292F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2131,0x1931,0x1931,0x1132,0x1133,0x21B6,0x2217,0x21F7,0x19B5,0x0913,0x08F1,0x1111,0x1931,0x2131,0x2151,0x2130,0x2110,0x2130,0x210F,0x2110,0x210F,0x2110,0x2910,0x2910,0x2930,0x2930,0x2930,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x290F,0x290F,0x20EE,0x208D,0x284B,0x8AF5,0xDD3C,0xDCBA,0xDC99,0xDC78,0xDC78,0xDC57,0xDC37,0xDC36,0xDC36,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xDC36,0xDC36,0xDC37,0xDC37,0xDC57,0xDC57,0xE478,0xDC99,0xE4DA,0xA376,0x2009,0x28AD,0x28CE,0x20EE,0x292F,0x2930,0x210F,0x2930,0x20EF,0x20EF,0x2110,0x2130,0x2130,0x2130,0x2111,0x1911,0x1932,0x1953,0x1954,0x1975,0x0934,0x1155,0x19B6,0x1995,0x1995,0x1974,0x1933,0x1932,0x1912,0x1911,0x2131,0x2131,0x2130,0x2110,0x2130,0x210F,0x210F,0x210F,0x290F,0x290F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2930,0x2930,0x2930,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x2910,0x210F,0x2930,0x2930,0x2930,0x2930,0x210F,0x212F,0x212F,0x210F,0x212F,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x2930,0x290F,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x1930,0x1911,0x1132,0x1133,0x19B6,0x2218,0x19D7,0x1995,0x1133,0x1133,0x1952,0x1951,0x1931,0x1931,0x1951,0x1952,0x1973,0x1973,0x1153,0x1974,0x1174,0x1995,0x1995,0x1175,0x1975,0x1974,0x1953,0x1932,0x18F1,0x1911,0x2131,0x2131,0x2130,0x210F,0x212F,0x292F,0x210F,0x292F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x290F,0x210F,0x2930,0x2910,0x2910,0x2930,0x2110,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x1910,0x1931,0x1911,0x1112,0x1974,0x21D6,0x21F7,0x21F7,0x19B6,0x1995,0x1133,0x1112,0x1111,0x1931,0x1931,0x2151,0x2131,0x2130,0x18EF,0x210F,0x2130,0x2130,0x1930,0x2152,0x1932,0x1133,0x1995,0x11D7,0x11D8,0x09F9,0x09FA,0x01FA,0x01DA,0x01DA,0x01D9,0x09F9,0x11F9,0x11D8,0x11B6,0x1154,0x1133,0x1932,0x2132,0x2111,0x2131,0x2131,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x210F,0x210F,0x210F,0x212F,0x292F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x210F,0x2930,0x210F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2110,0x210F,0x210F,0x2930,0x210F,0x210F,0x2930,0x2110,0x210F,0x210F,0x210F,0x290F,0x2930,0x2930,0x290F,0x290F,0x210F,0x2910,0x2910,0x290F,0x2930,0x2910,0x2910,0x210F,0x210F,0x2930,0x2910,0x2110,0x2110,0x2930,0x2910,0x210F,0x210F,0x210F,0x2130,0x2110,0x2110,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x2910,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x2110,0x210F,0x210F,0x290F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x2930,0x2910,0x2910,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x2930,0x2930,0x212F,0x2930,0x2930,0x292F,0x210F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2131,0x2131,0x1931,0x10F1,0x1112,0x1933,0x1153,0x1995,0x21D6,0x21F7,0x19D6,0x1995,0x1954,0x1132,0x1911,0x1911,0x2131,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x292F,0x210F,0x210F,0x212F,0x210E,0x212F,0x212F,0x212F,0x212F,0x212F,
  0x212F,0x212F,0x2930,0x2130,0x210F,0x210F,0x2130,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x2110,0x2130,0x2131,0x1931,0x1932,0x1133,0x1154,0x1175,0x1196,0x11B7,0x11F8,0x1A18,0x1A19,0x19F8,0x11D7,0x1195,0x0954,0x1132,0x1112,0x1931,0x1931,0x1931,0x1931,0x1931,0x1912,0x1932,0x1153,0x1154,0x1196,0x11B7,0x11F8,0x11F8,0x11F8,0x11F8,0x11D7,0x1195,0x0954,0x1133,0x1132,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2950,0x2130,0x2131,0x1931,0x1931,0x1911,0x1132,0x1953,0x1974,0x19B5,0x21D6,0x19D6,0x19D6,0x19B5,0x1195,0x1174,0x1154,0x1133,0x1133,0x1133,0x1133,0x1113,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1132,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1113,0x1133,0x1133,0x1113,0x1113,0x1133,0x1133,0x1112,0x1133,0x1133,0x1133,0x1133,0x1133,0x1113,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1153,0x1133,0x1133,0x1133,0x1133,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1132,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1112,0x1132,0x1133,0x1133,0x1112,0x1133,0x1133,0x1133,0x0912,0x0912,0x1113,0x0913,0x0933,0x0933,0x0934,0x0954,0x0955,0x0996,0x0996,0x09D8,0x09D8,0x01D9,0x01D9,0x01DA,0x01DA,0x01FA,0x01DA,0x01DA,0x01D9,0x01D9,0x09D9,0x09B8,0x11D7,0x19D6,0x1112,0x1911,0x1911,0x2131,0x2130,0x2110,0x2130,0x2130,0x2930,0x2130,0x2110,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x194F,0x112F,0x094F,0x43D9,0x3C3A,0x2419,0x13F9,0x0BF9,0x0BF9,0x0BF9,0x1419,0x13D8,0x2419,0x345A,0x3BF9,0x09D1,0x094F,0x112F,0x2150,0x2130,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2110,0x2130,0x2930,0x2910,0x210F,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x210F,0x210F,0x292F,0x292F,0x290F,0x290F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x1152,0x1153,0x1194,0x19D6,0x21F7,0x2A17,0x21D6,0x1974,0x1933,0x1912,0x1911,0x1931,0x2131,0x2151,0x2130,0x2130,0x210F,0x2130,0x212F,0x2930,0x212F,0x210F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1911,0x1132,0x1132,0x1174,0x19B5,0x21F7,0x2A38,0x21D6,0x1174,0x1154,0x1933,0x1932,0x1932,0x1911,0x2111,0x1910,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x2930,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2131,0x2131,0x1932,0x1932,0x1932,0x1933,0x1913,0x1113,0x1113,0x1112,0x1932,0x1932,0x1931,0x1931,0x2131,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x210F,0x212F,0x2930,0x212F,0x210F,0x2110,0x2130,0x2131,0x1931,0x1932,0x1132,0x1153,0x21F7,0x2217,0x21F7,0x1133,0x08D2,0x1111,0x1932,0x2131,0x2131,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2110,0x210F,0x2910,0x2930,0x210F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x290F,0x28EF,0x28CE,0x206B,0x40ED,0xCC9A,0xDCDB,0xDCB9,0xDC78,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xE457,0xDC37,0xDC37,0xE457,0xDC36,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xE477,0xDC78,0xDC98,0xDCDA,0xC438,0x284A,0x286C,0x20AD,0x20EE,0x290F,0x210F,0x290F,0x210F,0x20EF,0x2110,0x2110,0x2110,0x2130,0x2110,0x2111,0x2111,0x1911,0x1912,0x1932,0x1933,0x1933,0x1933,0x1113,0x1133,0x1112,0x1912,0x1932,0x1911,0x1911,0x2111,0x2131,0x2130,0x2110,0x2110,0x2110,0x2130,0x210F,0x212F,0x292F,0x292F,0x210F,0x210F,0x290F,0x2930,0x2110,0x2110,0x2910,0x290F,0x290F,0x290F,0x2910,0x2910,0x2930,0x2910,0x2910,0x2910,0x2930,0x2930,0x290F,0x290F,0x210F,0x212F,0x2930,0x210F,0x212F,0x212F,0x2930,0x2930,0x2930,0x212F,0x212F,0x212F,0x292F,0x2930,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1930,0x1911,0x1132,0x1133,0x19D6,0x21F7,0x19D7,0x1996,0x1134,0x1133,0x1952,0x1951,0x1930,0x1930,0x1931,0x1931,0x1931,0x1932,0x1932,0x1933,0x1933,0x1133,0x1133,0x1133,0x1933,0x1912,0x1912,0x1911,0x18F1,0x1910,0x2130,0x2131,0x2130,0x2930,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x2930,0x2910,0x2910,0x2910,0x2910,0x292F,0x212F,0x2930,0x212F,0x210F,0x210F,0x212F,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1112,0x1112,0x1974,0x21D6,0x21F6,0x21F7,0x21F6,0x1995,0x1153,0x1112,0x1931,0x1931,0x2131,0x1910,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1154,0x1996,0x11D8,0x09D9,0x09FA,0x01DA,0x01DA,0x01B9,0x01B9,0x01D9,0x01D9,0x09F9,0x09D8,0x11B7,0x1195,0x1954,0x1932,0x2132,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x2110,0x290F,0x210F,0x210F,0x210F,0x2110,0x2110,0x20EF,0x2130,0x2110,0x2110,0x2130,0x2110,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x210F,0x210F,0x212F,0x2930,0x210F,0x210F,0x2930,0x2910,0x210F,0x210F,0x2110,0x2930,0x210F,0x210F,0x290F,0x210F,0x2930,0x2930,0x210F,0x2910,0x210F,0x2910,0x210F,0x2910,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2910,0x210F,0x2130,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x2910,0x2110,0x2930,0x2110,0x2910,0x2110,0x2110,0x2910,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x2930,0x2910,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2930,0x290F,0x290F,0x2910,0x2910,0x2910,0x2110,0x210F,0x2910,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x212F,0x2930,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x292F,0x2930,0x210F,0x210F,0x210F,0x2130,0x2130,0x2131,0x1911,0x1111,0x1112,0x1133,0x1153,0x1995,0x21F6,0x21F7,0x19D6,0x1995,0x1153,0x1132,0x1931,0x1911,0x1910,0x2130,0x2110,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,
  0x210F,0x210F,0x20EF,0x210F,0x2130,0x210F,0x210F,0x212F,0x290F,0x2930,0x290F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x1931,0x1931,0x1132,0x1132,0x1154,0x1175,0x1196,0x11B7,0x11F8,0x19F8,0x1A18,0x19F8,0x11B7,0x1175,0x1133,0x1132,0x1132,0x1932,0x1931,0x1931,0x1911,0x1931,0x1911,0x1932,0x1953,0x1154,0x1195,0x0996,0x11D7,0x11F8,0x1A19,0x1A18,0x11B6,0x1175,0x1154,0x1133,0x1932,0x1931,0x1931,0x2110,0x2110,0x2130,0x2130,0x212F,0x2130,0x2130,0x2151,0x2151,0x1931,0x1911,0x1112,0x1153,0x1994,0x19B6,0x21F7,0x19D7,0x19D7,0x19D7,0x11B6,0x11B6,0x1196,0x1196,0x11B6,0x1196,0x1196,0x1196,0x11B6,0x1196,0x1196,0x1196,0x1196,0x1196,0x1196,0x1196,0x1196,0x1195,0x1196,0x1196,0x1196,0x1195,0x1195,0x1175,0x1175,0x1175,0x1175,0x1175,0x1195,0x1175,0x1175,0x1175,0x1175,0x0975,0x1175,0x1175,0x1175,0x1175,0x1175,0x0975,0x1175,0x1175,0x0975,0x1175,0x1175,0x1175,0x1175,0x1175,0x0975,0x1175,0x1175,0x1175,0x1195,0x1175,0x1195,0x1195,0x1175,0x1175,0x1175,0x1175,0x0975,0x1195,0x1195,0x1175,0x1175,0x1175,0x1175,0x1175,0x1195,0x1195,0x1195,0x1175,0x1195,0x1195,0x1195,0x1175,0x1195,0x1195,0x1175,0x1175,0x1175,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1175,0x1195,0x1195,0x1175,0x1195,0x1195,0x1195,0x1175,0x1175,0x1195,0x1195,0x1175,0x1195,0x1195,0x1195,0x0975,0x1195,0x1195,0x1195,0x1175,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1175,0x1175,0x1175,0x0975,0x1195,0x1175,0x1195,0x1175,0x1195,0x1195,0x1196,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1196,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1175,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1195,0x1175,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1195,0x1195,0x1195,0x1195,0x1195,0x1195,0x1175,0x1175,0x1195,0x1175,0x1195,0x0975,0x1195,0x1196,0x1196,0x0996,0x11B6,0x11D7,0x1197,0x11B7,0x09B7,0x0997,0x09D8,0x09D8,0x09F9,0x09FA,0x01D9,0x01DA,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01D9,0x09D9,0x11D8,0x19F8,0x21F7,0x1112,0x1911,0x1911,0x2131,0x2110,0x2130,0x2130,0x210F,0x2130,0x2930,0x2110,0x2930,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x194F,0x092F,0x32D5,0x64DD,0x44BB,0x2439,0x1419,0x0BF9,0x0C19,0x0C19,0x1419,0x1C19,0x2C5A,0x3C5A,0x549B,0x3316,0x094F,0x114F,0x1950,0x2150,0x2150,0x2130,0x2130,0x2150,0x212F,0x212F,0x2130,0x192F,0x2150,0x1930,0x2130,0x2130,0x2130,0x2130,0x2930,0x2910,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x210F,0x210F,0x2930,0x2910,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2131,0x2151,0x1952,0x1152,0x1153,0x1194,0x19F6,0x2217,0x19D6,0x21D6,0x1974,0x1133,0x1932,0x1911,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1932,0x1132,0x1174,0x19B5,0x2217,0x2217,0x19B6,0x1175,0x1974,0x1133,0x1932,0x1912,0x1911,0x2131,0x2110,0x2110,0x2110,0x2110,0x2930,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x290F,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x1911,0x1912,0x1932,0x1932,0x1932,0x1911,0x1911,0x1931,0x2131,0x2131,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2110,0x210F,0x290F,0x2910,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x1910,0x1911,0x1932,0x1112,0x1995,0x2A17,0x2A17,0x19B6,0x08F3,0x08D2,0x1932,0x2152,0x2131,0x2130,0x2130,0x2110,0x210F,0x210F,0x212F,0x2930,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x212F,0x212F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x28EE,0x288D,0x200A,0xA397,0xE51C,0xDCBA,0xDC78,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC36,0xDC37,0xDC37,0xDC36,0xDC37,0xE457,0xDC57,0xDC57,0xDC57,0xE457,0xDC16,0xDC36,0xDC57,0xDC98,0xD498,0xC438,0x61CF,0x204A,0x28AD,0x28EE,0x290F,0x290F,0x290F,0x2910,0x210F,0x210F,0x2110,0x2930,0x2130,0x2110,0x2110,0x2111,0x1911,0x1931,0x1911,0x1911,0x1912,0x1912,0x1932,0x1932,0x1911,0x1911,0x1911,0x2131,0x2131,0x2131,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x2930,0x2930,0x2110,0x2910,0x2910,0x2910,0x2110,0x2110,0x2930,0x2910,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x210F,0x2930,0x2930,0x290F,0x290F,0x210F,0x210F,0x290F,0x2930,0x290F,0x210F,0x2930,0x2930,0x210F,0x2930,0x212F,0x212F,0x2930,0x210F,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1930,0x1911,0x1112,0x1133,0x19D6,0x21F7,0x21F7,0x1195,0x1154,0x1132,0x1952,0x1931,0x1930,0x1930,0x1930,0x1950,0x1910,0x1911,0x1911,0x1911,0x1932,0x1932,0x1932,0x1932,0x1911,0x18F1,0x1911,0x2111,0x2111,0x1910,0x2130,0x2130,0x2110,0x210F,0x292F,0x292F,0x290F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x2910,0x2910,0x290F,0x2930,0x290F,0x2910,0x2910,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x212F,0x2930,0x2930,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x2152,0x1932,0x1132,0x1113,0x1974,0x21D6,0x21F7,0x21F7,0x21D6,0x1995,0x1133,0x1112,0x1911,0x1931,0x1931,0x2130,0x2110,0x2110,0x210F,0x2110,0x2110,0x2150,0x2151,0x2130,0x1931,0x1932,0x1133,0x1996,0x19F8,0x11D8,0x09D9,0x09DA,0x09FA,0x01BA,0x01BA,0x01B9,0x01B9,0x01DA,0x09D9,0x09D9,0x11D8,0x19D7,0x1154,0x1932,0x1932,0x2131,0x2131,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x210F,0x2110,0x2130,0x2130,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x2130,0x210F,0x212F,0x210F,0x2910,0x210F,0x210F,0x210F,0x2930,0x210F,0x2110,0x210F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x210F,0x2130,0x210F,0x2130,0x210F,0x2110,0x2930,0x2930,0x2930,0x2110,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x212F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x210F,0x210F,0x290F,0x210F,0x2910,0x2910,0x210F,0x2910,0x2910,0x2930,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2930,0x290F,0x290F,0x2930,0x210F,0x210F,0x290F,0x292F,0x210F,0x210F,0x210F,0x292F,0x292F,0x290F,0x2930,0x292F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x2930,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2930,0x2930,0x2930,0x2930,0x2910,0x2910,0x2930,0x292F,0x212F,0x210F,0x292F,0x290F,0x210F,0x210F,0x2930,0x210F,0x212F,0x2930,0x2930,0x212F,0x210F,0x210F,0x212F,0x292F,0x292F,0x210F,0x2930,0x210F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1911,0x1111,0x1953,0x1153,0x19B5,0x21F6,0x19F7,0x21F7,0x19B5,0x1133,0x1112,0x1111,0x1931,0x2131,0x2130,0x2110,0x2110,0x210F,0x212F,0x210F,0x212F,0x214F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x2130,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,
  0x2130,0x210F,0x2110,0x210F,0x210F,0x210F,0x212F,0x212F,0x292F,0x292F,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x2130,0x2110,0x2130,0x1931,0x1931,0x1132,0x1133,0x1153,0x1175,0x1196,0x11B7,0x19F8,0x1A18,0x19F8,0x19F8,0x11B7,0x1175,0x1154,0x1133,0x1932,0x1932,0x1931,0x1931,0x1931,0x1931,0x1932,0x1932,0x1153,0x1174,0x1196,0x11B7,0x11D8,0x11F8,0x11F8,0x11F8,0x11B7,0x1175,0x1154,0x1153,0x1932,0x1932,0x2131,0x2110,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2151,0x2131,0x1911,0x1931,0x1132,0x1133,0x1174,0x19B5,0x19F7,0x1A18,0x1A18,0x1A18,0x11F8,0x19F8,0x19F8,0x19F8,0x1A18,0x2218,0x19F8,0x2239,0x2219,0x2219,0x19F8,0x2219,0x2219,0x1A18,0x2219,0x2239,0x1A18,0x2239,0x2239,0x2238,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2218,0x1A18,0x2218,0x1A18,0x2239,0x2238,0x2218,0x2218,0x2238,0x2218,0x2218,0x2238,0x1A18,0x1A18,0x2239,0x1A18,0x1A18,0x2218,0x1A18,0x2218,0x2218,0x1A18,0x2218,0x1A18,0x1A18,0x1A18,0x2238,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2218,0x1A18,0x1A18,0x2238,0x1A18,0x1A18,0x1A18,0x2238,0x1A18,0x1A18,0x1A18,0x2238,0x2218,0x2238,0x1A18,0x2218,0x1A18,0x1A18,0x1A18,0x2238,0x1A18,0x2218,0x1A18,0x2238,0x2218,0x1A18,0x1A18,0x2218,0x2218,0x1A18,0x1A18,0x2238,0x2238,0x1A18,0x1A18,0x2218,0x2218,0x1A18,0x1A18,0x2238,0x2238,0x2218,0x1A18,0x2238,0x2218,0x1A18,0x1A18,0x2218,0x2218,0x1A18,0x1A18,0x1A18,0x1A18,0x2238,0x1A18,0x1A18,0x2238,0x1A18,0x1A18,0x2218,0x2218,0x1A18,0x1A18,0x1A38,0x1A18,0x1A18,0x1A18,0x2238,0x1A18,0x2238,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2238,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2238,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2218,0x1A18,0x2218,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2218,0x1A18,0x1A18,0x1A18,0x2218,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2238,0x1A18,0x1A18,0x1A18,0x2238,0x1A18,0x2218,0x1A18,0x1A18,0x1A18,0x2218,0x1A18,0x1A18,0x2218,0x1A18,0x1A18,0x2238,0x1A18,0x1A18,0x1A18,0x2238,0x1A38,0x1A18,0x2218,0x2238,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2238,0x2218,0x1A18,0x1A18,0x1A18,0x1A18,0x1A38,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x2238,0x2238,0x1A18,0x1A38,0x1A38,0x1A18,0x1A38,0x2238,0x2238,0x1A18,0x2238,0x1A18,0x1A38,0x1A38,0x1A18,0x11F7,0x1A18,0x1A18,0x1A18,0x11F8,0x1A19,0x11D8,0x11F8,0x11F9,0x09D8,0x09F9,0x01D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x01BA,0x01DA,0x09DA,0x09D9,0x11D8,0x11D7,0x19D6,0x08F2,0x1911,0x1931,0x2110,0x2130,0x2110,0x210F,0x210F,0x2130,0x2930,0x2930,0x2110,0x2930,0x2130,0x2130,0x212F,0x212F,0x192F,0x194F,0x114F,0x2233,0x22B5,0x2356,0x23D8,0x1C19,0x0BF9,0x0C19,0x0C19,0x1439,0x1C39,0x2BD8,0x3BF9,0x43F9,0x3B36,0x1170,0x114F,0x194F,0x1950,0x1950,0x2150,0x194F,0x192F,0x192F,0x192F,0x1930,0x1950,0x1950,0x1930,0x2150,0x2150,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x210F,0x210F,0x212F,0x2130,0x2130,0x212F,0x210F,0x2910,0x2910,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x1931,0x1931,0x1152,0x1173,0x1194,0x19D6,0x2217,0x19D6,0x19B6,0x1995,0x1113,0x1112,0x1912,0x2131,0x2131,0x2130,0x2930,0x2130,0x210F,0x210F,0x212F,0x292F,0x2150,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x1931,0x1131,0x1132,0x1174,0x19B5,0x2217,0x2217,0x1996,0x1995,0x1954,0x1133,0x1912,0x1912,0x2111,0x2131,0x2110,0x2110,0x2910,0x2910,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x290F,0x290F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2110,0x2131,0x2131,0x2111,0x2131,0x2131,0x1911,0x1911,0x2111,0x2130,0x2130,0x2130,0x2110,0x2110,0x2930,0x2910,0x210F,0x210F,0x2130,0x210F,0x210F,0x2910,0x2930,0x2910,0x2910,0x210F,0x212F,0x210F,0x210F,0x2130,0x210F,0x210F,0x2110,0x2130,0x2130,0x2131,0x1911,0x1932,0x1112,0x19B5,0x2A17,0x21F7,0x1995,0x08F3,0x10F2,0x1952,0x1931,0x1910,0x2130,0x2130,0x2130,0x210F,0x212F,0x2130,0x2930,0x2130,0x210F,0x210F,0x210F,0x2930,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x28EE,0x28CD,0x286C,0x514E,0xE53D,0xDCBA,0xDC99,0xDC78,0xDC58,0xDC57,0xDC37,0xDC37,0xDC37,0xDC36,0xDC37,0xDC37,0xDC37,0xDC37,0xE457,0xDC37,0xE457,0xDC57,0xDC57,0xE457,0xDC16,0xE457,0xDC77,0xDC98,0xDC99,0xCC99,0xDD7E,0x412D,0x206B,0x28CE,0x28EE,0x290F,0x2910,0x2910,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2110,0x2110,0x2131,0x1910,0x1911,0x1910,0x1931,0x1931,0x1911,0x1911,0x1911,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x210F,0x2110,0x210F,0x2910,0x2910,0x2930,0x212F,0x212F,0x2110,0x2930,0x2910,0x290F,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x290F,0x2930,0x290F,0x2930,0x2130,0x212F,0x212F,0x2130,0x212F,0x290F,0x2930,0x290F,0x2930,0x212F,0x214F,0x2130,0x212F,0x2150,0x2130,0x1930,0x1931,0x1132,0x1133,0x19D6,0x2217,0x19D7,0x1996,0x1133,0x1132,0x1932,0x1930,0x2130,0x2130,0x2130,0x2130,0x2110,0x1910,0x1910,0x2131,0x1911,0x1911,0x1911,0x18F1,0x1911,0x1911,0x2111,0x18F0,0x2110,0x2110,0x2130,0x2930,0x210F,0x210F,0x292F,0x292F,0x210F,0x210F,0x292F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x2910,0x290F,0x2930,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x210F,0x292F,0x212F,0x2930,0x2930,0x2930,0x2110,0x2130,0x2110,0x2110,0x2131,0x2131,0x1931,0x1932,0x1112,0x1133,0x1175,0x21F7,0x21F7,0x21F7,0x21D6,0x1995,0x1133,0x1112,0x1111,0x1911,0x2151,0x1910,0x2130,0x2130,0x210F,0x210F,0x2910,0x2110,0x2150,0x2151,0x1931,0x1911,0x1111,0x1113,0x1996,0x11D8,0x11D8,0x09B9,0x01DA,0x01DA,0x01DA,0x01BA,0x01DA,0x01DA,0x01DA,0x01D9,0x09D9,0x11D8,0x19B7,0x1174,0x1112,0x1931,0x2131,0x2151,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x2930,0x210F,0x2110,0x210F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x212F,0x210F,0x2930,0x290F,0x212F,0x2930,0x2110,0x2930,0x210F,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x210F,0x2110,0x212F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2930,0x2110,0x2110,0x2110,0x210F,0x212F,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x290F,0x2930,0x290F,0x290F,0x2930,0x2910,0x2910,0x2930,0x2110,0x2110,0x2930,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x2110,0x2910,0x2910,0x2930,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2930,0x210F,0x2930,0x2930,0x2910,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2110,0x2930,0x2930,0x2930,0x290F,0x290F,0x210F,0x2930,0x2910,0x210F,0x292F,0x210F,0x210F,0x290F,0x292F,0x210F,0x290F,0x210F,0x292F,0x2930,0x212F,0x2930,0x2930,0x212F,0x210F,0x2930,0x2930,0x2930,0x210F,0x2130,0x2930,0x2130,0x2130,0x2131,0x18F1,0x1112,0x1133,0x1153,0x19B5,0x21F6,0x21F7,0x21F7,0x19B5,0x1153,0x1112,0x1111,0x1911,0x1930,0x2110,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x2950,0x212F,0x210F,0x210F,0x210F,0x2130,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,
  0x2950,0x2130,0x2110,0x2110,0x2910,0x210F,0x210F,0x2930,0x2930,0x292F,0x292F,0x292F,0x290F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2151,0x1931,0x1952,0x1132,0x1133,0x1154,0x1196,0x11B7,0x19F8,0x1A19,0x19F8,0x11F8,0x11B7,0x1175,0x1174,0x1133,0x1132,0x1932,0x1932,0x1931,0x2151,0x1952,0x1932,0x1132,0x1153,0x1174,0x1196,0x11B7,0x11B7,0x11F8,0x1218,0x11F8,0x19D7,0x1175,0x1154,0x1133,0x1932,0x1931,0x2131,0x2130,0x2110,0x210F,0x210F,0x2130,0x2950,0x2150,0x2151,0x2151,0x2131,0x1931,0x1912,0x1132,0x1132,0x1974,0x19B6,0x19F7,0x2218,0x1A18,0x19F8,0x19F8,0x2218,0x2218,0x2218,0x21F8,0x21F8,0x21F8,0x21F9,0x21F9,0x21F8,0x19F8,0x19F8,0x2219,0x2239,0x1A18,0x2259,0x2239,0x1A18,0x1A18,0x1A18,0x2238,0x1A18,0x2238,0x2218,0x2218,0x2238,0x2238,0x2239,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2218,0x2238,0x2218,0x2238,0x2238,0x2238,0x2238,0x2238,0x2218,0x2238,0x2238,0x2218,0x2238,0x2218,0x2238,0x2238,0x2238,0x2239,0x2238,0x2218,0x2218,0x2238,0x2238,0x2238,0x2238,0x1A18,0x2238,0x2238,0x2238,0x2238,0x1A18,0x2238,0x2238,0x2218,0x2238,0x2238,0x2218,0x2218,0x2238,0x2218,0x2218,0x2218,0x2218,0x2218,0x2218,0x2218,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2218,0x2238,0x2238,0x2238,0x2218,0x2238,0x2238,0x2218,0x2218,0x2218,0x2218,0x2238,0x2238,0x2238,0x2238,0x2238,0x2218,0x2238,0x2238,0x2218,0x2218,0x2218,0x2238,0x2238,0x2238,0x2238,0x2238,0x2218,0x2218,0x2238,0x2238,0x2238,0x2218,0x2238,0x1A18,0x2238,0x1A18,0x19F8,0x2218,0x2218,0x2218,0x2238,0x2238,0x1A18,0x2218,0x2218,0x2218,0x1A18,0x2218,0x1A18,0x2238,0x2218,0x1A18,0x2218,0x2238,0x2239,0x2238,0x2218,0x2218,0x2218,0x2218,0x2238,0x2218,0x2238,0x2218,0x2238,0x2218,0x2218,0x2218,0x2238,0x2238,0x2238,0x1A18,0x1A18,0x2238,0x2238,0x2218,0x2238,0x2218,0x2218,0x2238,0x2238,0x2238,0x2238,0x2218,0x2238,0x2238,0x2238,0x2218,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2218,0x2218,0x2238,0x2238,0x2218,0x2238,0x2238,0x2238,0x2218,0x1A18,0x1A18,0x2218,0x2238,0x2238,0x2218,0x2238,0x2238,0x1A18,0x2238,0x2238,0x2218,0x2238,0x2238,0x1A18,0x2238,0x1A38,0x1A38,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2238,0x2259,0x2238,0x2258,0x2258,0x2238,0x2238,0x1A38,0x2258,0x2238,0x2238,0x2258,0x2238,0x1A38,0x2238,0x2258,0x2259,0x2238,0x1A38,0x1A18,0x1A39,0x1A19,0x19F9,0x11F9,0x11D8,0x09D8,0x09F9,0x01D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01DA,0x01BA,0x09DA,0x09D9,0x11D8,0x19F8,0x19B5,0x08F1,0x1911,0x1931,0x2131,0x2130,0x2130,0x2130,0x212F,0x2130,0x2930,0x2930,0x2910,0x2930,0x2930,0x2950,0x212F,0x212F,0x214F,0x192F,0x112F,0x010E,0x00EE,0x014F,0x0212,0x1BF9,0x1419,0x1439,0x1439,0x1419,0x2419,0x0190,0x00CD,0x00CD,0x010E,0x114F,0x112F,0x194F,0x112F,0x112F,0x090E,0x090E,0x090E,0x090E,0x090E,0x090E,0x090E,0x112F,0x110F,0x110F,0x112F,0x190F,0x190F,0x2130,0x2110,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210E,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x2910,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1951,0x1952,0x1952,0x1153,0x1195,0x19D6,0x2217,0x21F7,0x19B6,0x1995,0x1133,0x1112,0x1911,0x1911,0x2151,0x2130,0x2130,0x2130,0x2130,0x212F,0x2930,0x212F,0x212F,0x212F,0x210F,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x1930,0x1910,0x1952,0x1132,0x1153,0x19B6,0x2A38,0x2218,0x19B6,0x1995,0x1154,0x1133,0x1932,0x1932,0x2132,0x2131,0x2930,0x2930,0x2110,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x290F,0x290F,0x290F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x2110,0x2131,0x2130,0x2130,0x2110,0x2110,0x2910,0x210F,0x2910,0x290F,0x2910,0x2130,0x2130,0x210F,0x210F,0x2930,0x210F,0x2910,0x210F,0x2930,0x212F,0x210F,0x212F,0x2930,0x2930,0x2110,0x2110,0x2130,0x2130,0x2131,0x1932,0x1932,0x1112,0x21D5,0x2A17,0x21F6,0x1995,0x08F2,0x1932,0x2152,0x2131,0x2130,0x2130,0x210F,0x2130,0x210F,0x212F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x290F,0x290F,0x28EE,0x28AD,0x304B,0xB3D8,0xDCBA,0xDC99,0xDC78,0xDC58,0xDC57,0xDC37,0xE457,0xE457,0xDC37,0xDC37,0xDC37,0xDC37,0xDC36,0xE457,0xE457,0xE457,0xDC37,0xDC36,0xDC57,0xDC37,0xDC37,0xDC57,0xDC57,0xDC98,0xD478,0xDD1B,0xDD7D,0x9BF8,0x180A,0x28AD,0x28EE,0x290F,0x2930,0x2930,0x2930,0x2930,0x210F,0x20EF,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2131,0x2131,0x2130,0x2130,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x212F,0x212F,0x2110,0x2110,0x2910,0x2910,0x2930,0x290F,0x2930,0x210F,0x290F,0x2930,0x2930,0x2930,0x2910,0x2910,0x210F,0x290F,0x2110,0x2110,0x2930,0x2930,0x2930,0x2130,0x2930,0x212F,0x2130,0x2930,0x290F,0x210F,0x2910,0x210F,0x212F,0x212F,0x212F,0x212F,0x2150,0x2130,0x1930,0x1911,0x1112,0x1133,0x19B6,0x21F7,0x21D7,0x1995,0x1113,0x1112,0x1931,0x1910,0x2130,0x192F,0x2150,0x2130,0x2130,0x2130,0x2130,0x2111,0x2131,0x2131,0x2131,0x1931,0x2111,0x2110,0x2131,0x2130,0x2110,0x2110,0x2130,0x2930,0x210F,0x210F,0x2930,0x292F,0x210F,0x210F,0x212F,0x292F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x2910,0x290F,0x292F,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x292F,0x2930,0x212F,0x212F,0x212F,0x212F,0x2130,0x2930,0x2930,0x2130,0x2930,0x2131,0x2131,0x2131,0x1111,0x10F2,0x1133,0x1174,0x21F7,0x2218,0x21F7,0x21D6,0x1974,0x1133,0x10F2,0x1911,0x1931,0x1931,0x2130,0x190F,0x210F,0x2930,0x2930,0x210F,0x2110,0x210F,0x2150,0x2130,0x1911,0x1911,0x10F2,0x1133,0x19B6,0x19F8,0x09B8,0x09D9,0x01B9,0x01BA,0x01BA,0x01DA,0x01DA,0x01DA,0x01D9,0x01D9,0x09D9,0x11D8,0x19D7,0x1975,0x10F2,0x1911,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x292F,0x290F,0x2930,0x290F,0x210F,0x2910,0x2110,0x212F,0x212F,0x212F,0x2130,0x210F,0x210F,0x2110,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x2130,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2930,0x2110,0x2930,0x2110,0x2930,0x210F,0x2110,0x210F,0x2110,0x2910,0x2910,0x290F,0x2910,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x290F,0x290F,0x290F,0x210F,0x2930,0x2910,0x2110,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x2910,0x2910,0x2930,0x2930,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x292F,0x290F,0x2930,0x2930,0x210F,0x210F,0x210F,0x2910,0x2110,0x2110,0x2930,0x2930,0x2910,0x2910,0x2910,0x2930,0x2910,0x2910,0x2910,0x290F,0x2930,0x2930,0x2930,0x2930,0x290F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x292F,0x212F,0x210F,0x212F,0x210F,0x292F,0x210F,0x2930,0x2930,0x292F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2110,0x1911,0x1912,0x1133,0x1173,0x19B5,0x21F6,0x21F7,0x19F6,0x1995,0x1133,0x0912,0x1111,0x1931,0x1911,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x292F,
  0x2950,0x2130,0x2110,0x2910,0x2930,0x2910,0x290F,0x210F,0x210F,0x212F,0x292F,0x290F,0x290F,0x290F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x1931,0x1931,0x1931,0x1132,0x1153,0x1154,0x1196,0x19B7,0x19F8,0x19F9,0x19F8,0x11D8,0x11D7,0x1196,0x1154,0x1153,0x1132,0x1932,0x1932,0x1931,0x1931,0x1931,0x1932,0x1132,0x1153,0x1174,0x1196,0x11B7,0x11B7,0x11F8,0x1A19,0x19F8,0x11B7,0x1196,0x1154,0x1133,0x1932,0x1932,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2951,0x2131,0x2131,0x2151,0x1931,0x1911,0x1932,0x1132,0x1133,0x1174,0x1175,0x1195,0x1996,0x1996,0x1996,0x19B6,0x1996,0x19B6,0x19B6,0x1996,0x19B7,0x19B7,0x19B6,0x19B6,0x19B7,0x19B6,0x11B6,0x11B6,0x11B6,0x11B6,0x19D6,0x19D6,0x11B6,0x19B6,0x19B6,0x19B6,0x19D6,0x19D6,0x19B6,0x19B6,0x19B6,0x19B6,0x19D6,0x19D6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B5,0x19B5,0x19D6,0x19B6,0x19D6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B5,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19D6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x1996,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x1996,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x11B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x1996,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19D6,0x19B6,0x19B6,0x19B6,0x19D6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B5,0x19B6,0x19B6,0x19B6,0x19B5,0x19B6,0x19B6,0x19B6,0x19B5,0x19B6,0x19B6,0x19B6,0x11B5,0x19B5,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x19D6,0x19B5,0x19B6,0x19B6,0x19B5,0x19B5,0x19B6,0x19B6,0x19B6,0x19B6,0x19D6,0x19B6,0x19B6,0x19D5,0x11B5,0x19D6,0x19D6,0x19B5,0x19B5,0x19B6,0x19B6,0x19B5,0x19D6,0x19D6,0x19B6,0x19D6,0x19D6,0x19D6,0x11D6,0x19D6,0x19D7,0x19B7,0x19D7,0x11B7,0x11B7,0x11B8,0x09B8,0x09D8,0x09F9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x09D9,0x09D9,0x11D8,0x19F7,0x1175,0x1112,0x1931,0x2131,0x2131,0x2130,0x2130,0x2930,0x212F,0x212F,0x212F,0x2110,0x2910,0x2930,0x2930,0x212F,0x212F,0x214F,0x212F,0x192F,0x194F,0x114F,0x092F,0x014F,0x01F1,0x23F9,0x1C19,0x1419,0x1419,0x1C19,0x23D9,0x014F,0x00CD,0x00EE,0x092F,0x1970,0x114F,0x114F,0x092F,0x010E,0x00EE,0x010E,0x010E,0x012E,0x012E,0x010E,0x010E,0x00ED,0x00ED,0x010E,0x00ED,0x00AD,0x00CE,0x1910,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x2151,0x1952,0x1132,0x1153,0x1195,0x2217,0x21F8,0x21F7,0x19D6,0x1174,0x1953,0x1112,0x1911,0x2131,0x2131,0x2930,0x2130,0x2130,0x212F,0x2930,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1132,0x1154,0x19D6,0x2A38,0x19D7,0x19B6,0x1995,0x1153,0x1933,0x1912,0x2131,0x2131,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x290F,0x290F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2930,0x2910,0x2910,0x2930,0x290F,0x2930,0x210F,0x2130,0x210F,0x210F,0x2110,0x210F,0x2930,0x290F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x1931,0x1931,0x1932,0x1112,0x21B5,0x2A17,0x19D6,0x1995,0x1112,0x1932,0x2152,0x2131,0x2130,0x2130,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x2130,0x2950,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2950,0x290F,0x290F,0x28EF,0x28AD,0x286B,0x512E,0xD4BB,0xDC9A,0xE4B9,0xDC78,0xDC37,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC36,0xDC57,0xE457,0xDC36,0xDC36,0xDC37,0xE457,0xDC36,0xDC37,0xE457,0xE457,0xDC37,0xE457,0xDC57,0xDC78,0xDC98,0xE51B,0xD51B,0xBCBA,0x1809,0x20AD,0x20CE,0x290F,0x2910,0x2930,0x210F,0x2110,0x20EF,0x2910,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x1910,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x2110,0x2930,0x2930,0x2110,0x2110,0x210F,0x2930,0x212F,0x212F,0x210F,0x2930,0x210F,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x2910,0x2930,0x2930,0x2930,0x2110,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x2130,0x2930,0x2930,0x210F,0x2930,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1930,0x1931,0x1112,0x1133,0x21D6,0x21F7,0x21D7,0x1995,0x1133,0x1112,0x1931,0x1930,0x1930,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x1910,0x1910,0x2130,0x2110,0x2130,0x2130,0x2110,0x2930,0x2130,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x2930,0x2910,0x292F,0x292F,0x290F,0x2910,0x2910,0x290F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2930,0x2130,0x2131,0x2131,0x1932,0x1112,0x0912,0x1154,0x21F7,0x2218,0x21F7,0x21D6,0x1974,0x1133,0x10F1,0x10F1,0x18F0,0x2131,0x2130,0x190F,0x190F,0x210F,0x2930,0x2930,0x2910,0x210F,0x2110,0x2130,0x2130,0x1911,0x1911,0x1112,0x1133,0x19D7,0x11D8,0x11D9,0x09D9,0x01BA,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01B9,0x01B9,0x09D9,0x11F9,0x19D7,0x1975,0x1112,0x1911,0x1911,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2110,0x2930,0x290F,0x2110,0x2110,0x2110,0x2110,0x2950,0x2110,0x2130,0x2110,0x2110,0x2930,0x2910,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2930,0x210F,0x2130,0x2130,0x212F,0x2930,0x2110,0x2110,0x2110,0x210F,0x210F,0x212F,0x212F,0x212F,0x2930,0x2110,0x2110,0x210F,0x210F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x2130,0x210F,0x210F,0x212F,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2930,0x2110,0x2910,0x2910,0x2930,0x2930,0x2930,0x290F,0x2930,0x210F,0x2910,0x210F,0x210F,0x212F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2110,0x2930,0x2910,0x2930,0x2910,0x2930,0x2930,0x2930,0x2910,0x2930,0x2910,0x290F,0x210F,0x290F,0x290F,0x292F,0x210F,0x290F,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x2910,0x2910,0x210F,0x210F,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2910,0x2110,0x2930,0x2930,0x290F,0x290F,0x2930,0x210F,0x2930,0x2930,0x2930,0x290F,0x2930,0x2110,0x212F,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2930,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x2111,0x1911,0x1911,0x1132,0x1154,0x1995,0x21F6,0x19F6,0x21F6,0x1995,0x1133,0x1112,0x1111,0x1931,0x1931,0x2131,0x2130,0x2110,0x2130,0x2110,0x2930,0x2130,0x2130,0x210F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x210F,0x2110,0x2910,0x2930,
  0x2130,0x2110,0x2110,0x210F,0x2110,0x212F,0x212F,0x210F,0x2930,0x290F,0x290F,0x292F,0x290F,0x290F,0x2930,0x210F,0x212F,0x292F,0x210F,0x2110,0x2130,0x2130,0x2131,0x1931,0x1952,0x1152,0x1153,0x1174,0x1195,0x11B7,0x19F8,0x19F9,0x19F8,0x11F8,0x11D7,0x1175,0x1154,0x1133,0x1112,0x1932,0x1931,0x2131,0x1931,0x1931,0x1932,0x1132,0x1132,0x1154,0x1196,0x11D7,0x11B7,0x11F8,0x11F8,0x19F8,0x11B7,0x1176,0x1154,0x1133,0x1112,0x1932,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x2131,0x2131,0x2131,0x1931,0x1932,0x1952,0x1132,0x1132,0x1112,0x1112,0x1112,0x1112,0x1113,0x1113,0x1933,0x1933,0x1933,0x1933,0x1133,0x1133,0x1133,0x1133,0x1133,0x1153,0x1153,0x1153,0x1133,0x1153,0x1153,0x1133,0x1153,0x1153,0x1133,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1932,0x1132,0x1932,0x1132,0x1932,0x1912,0x1932,0x1132,0x1132,0x1132,0x1933,0x1933,0x1933,0x1933,0x1132,0x1132,0x1953,0x1132,0x1133,0x1133,0x1133,0x1933,0x1933,0x1133,0x1933,0x1933,0x1933,0x1932,0x1132,0x1933,0x1133,0x1133,0x1133,0x1133,0x1133,0x1933,0x1133,0x1133,0x1933,0x1133,0x1132,0x1132,0x1132,0x1132,0x1132,0x1133,0x1132,0x1933,0x1932,0x1132,0x1933,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1933,0x1133,0x1133,0x1133,0x1133,0x1132,0x1132,0x1132,0x1132,0x1933,0x1133,0x1133,0x1933,0x1933,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1933,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1933,0x1133,0x1132,0x1133,0x1133,0x1133,0x1133,0x1133,0x1933,0x1133,0x1133,0x1933,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1132,0x1132,0x1132,0x1133,0x1132,0x1132,0x1133,0x1132,0x1132,0x1133,0x1132,0x1932,0x1932,0x1932,0x1132,0x1932,0x1932,0x1132,0x1132,0x1132,0x1132,0x1932,0x1132,0x1132,0x1132,0x1132,0x1932,0x1932,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1132,0x1132,0x1112,0x1132,0x1112,0x1132,0x1953,0x1932,0x1132,0x1132,0x1132,0x1132,0x1932,0x1132,0x1132,0x1932,0x1132,0x1932,0x1132,0x1132,0x1132,0x1932,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1132,0x1132,0x1132,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1133,0x1133,0x1133,0x1154,0x1154,0x1154,0x1155,0x1176,0x1197,0x11D8,0x09D8,0x09F9,0x01FA,0x01D9,0x01DA,0x01FA,0x01FA,0x01D9,0x09D9,0x09F8,0x19F8,0x21F7,0x1154,0x1112,0x1931,0x2131,0x2110,0x2951,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x2130,0x210F,0x212F,0x212F,0x192F,0x1950,0x1950,0x1150,0x0950,0x014F,0x01F1,0x2C19,0x1C19,0x1419,0x1419,0x1C19,0x2C19,0x014F,0x00ED,0x094F,0x114F,0x1990,0x114F,0x114F,0x00EE,0x3336,0x4C5B,0x3C3A,0x3C3A,0x3C7A,0x3C7A,0x44BB,0x44BB,0x44BB,0x447A,0x443A,0x3BF9,0x4C1A,0x32D5,0x00CE,0x190F,0x2150,0x2130,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x292F,0x292F,0x210F,0x212F,0x2930,0x2910,0x2110,0x2110,0x2910,0x2910,0x2110,0x210F,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1132,0x1153,0x1175,0x19D6,0x21F7,0x21F7,0x19B6,0x1974,0x1133,0x1111,0x1911,0x2131,0x2131,0x2930,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2151,0x2151,0x1931,0x1111,0x1132,0x1154,0x19B6,0x21F7,0x19D7,0x21F7,0x19B5,0x1153,0x1112,0x1911,0x1911,0x2111,0x2110,0x2130,0x2130,0x210F,0x2130,0x210F,0x210F,0x212F,0x210F,0x212F,0x2930,0x290F,0x210F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x210F,0x2110,0x2930,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2910,0x2930,0x2930,0x210F,0x2110,0x210F,0x2130,0x212F,0x2130,0x210F,0x2110,0x210F,0x290F,0x2930,0x210F,0x212F,0x212F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1932,0x1932,0x1112,0x21B5,0x2217,0x19B6,0x1974,0x10F2,0x1912,0x2132,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2930,0x2130,0x2130,0x2930,0x2930,0x212F,0x210F,0x210F,0x212F,0x292F,0x2930,0x292F,0x28EF,0x28CE,0x286C,0x2009,0xB419,0xDCDA,0xDC99,0xDC78,0xDC57,0xDC57,0xE457,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC36,0xDC57,0xDC57,0xDC37,0xDC57,0xDC57,0xE457,0xDC57,0xDC37,0xDC57,0xDC78,0xDC78,0xC437,0xDD5C,0xAC59,0x1809,0x208C,0x20EE,0x290F,0x2910,0x2910,0x2110,0x2110,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x290F,0x210F,0x2930,0x210F,0x212F,0x2930,0x2930,0x2910,0x2910,0x2910,0x290F,0x210F,0x2910,0x2110,0x2930,0x2930,0x2930,0x290F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2930,0x2130,0x2130,0x212F,0x2130,0x2110,0x2930,0x290F,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x1931,0x1911,0x1112,0x1133,0x21D6,0x2217,0x21F7,0x1995,0x1133,0x1932,0x1931,0x1930,0x1930,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x290F,0x290F,0x210F,0x2930,0x2910,0x2930,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x210F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2110,0x2131,0x1932,0x1112,0x0913,0x1154,0x19D7,0x2238,0x21F7,0x19B6,0x1995,0x1953,0x10D1,0x10D0,0x1910,0x2131,0x2151,0x2150,0x2130,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2950,0x2130,0x1910,0x1911,0x1912,0x1133,0x21D7,0x19D8,0x09D8,0x09B9,0x09DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01BA,0x01BA,0x01B9,0x09D9,0x11F9,0x19D7,0x1174,0x1112,0x1911,0x1910,0x1910,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2130,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x210F,0x210F,0x290F,0x290F,0x2930,0x212F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2930,0x2130,0x210F,0x2110,0x2910,0x2930,0x2930,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x2910,0x2910,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2930,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x2130,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2910,0x2930,0x2910,0x2910,0x210F,0x2910,0x210F,0x2930,0x2930,0x2110,0x2110,0x2910,0x2930,0x2110,0x2930,0x2930,0x2110,0x2930,0x2930,0x2110,0x2930,0x2910,0x2910,0x2110,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x2110,0x212F,0x212F,0x2110,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2910,0x2110,0x2110,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x292F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x290F,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x2930,0x210F,0x2930,0x2930,0x2930,0x292F,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x2930,0x292F,0x212F,0x212F,0x210F,0x212F,0x2950,0x2130,0x210F,0x2110,0x2130,0x2131,0x2111,0x1911,0x1112,0x1133,0x1154,0x1995,0x21F6,0x21F7,0x21F7,0x1195,0x1133,0x1112,0x1111,0x1931,0x1931,0x2151,0x2131,0x2130,0x2130,0x2110,0x2110,0x2930,0x2130,0x2110,0x2110,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,
  0x2110,0x2110,0x2110,0x2130,0x212F,0x210F,0x212F,0x212F,0x2930,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x292F,0x290F,0x210F,0x210F,0x2130,0x2130,0x2131,0x1951,0x1932,0x1953,0x1153,0x1174,0x1196,0x19B7,0x19F8,0x19F9,0x11F8,0x11F8,0x11B7,0x1196,0x1154,0x1133,0x1932,0x1911,0x1911,0x2131,0x1931,0x1931,0x1931,0x1132,0x1153,0x1174,0x19B6,0x11B7,0x11D7,0x11F8,0x11F8,0x19F8,0x11B7,0x1196,0x1154,0x1133,0x1932,0x2131,0x2131,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2131,0x2131,0x2131,0x2131,0x2131,0x1931,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1912,0x1912,0x1912,0x1911,0x1912,0x1932,0x1111,0x1912,0x1932,0x1111,0x1932,0x1931,0x1931,0x1932,0x1911,0x1911,0x1931,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1912,0x1912,0x1911,0x18F1,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1911,0x1932,0x1932,0x1911,0x1932,0x1912,0x1912,0x1932,0x1912,0x1912,0x1911,0x1932,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1931,0x1911,0x1912,0x1911,0x1912,0x1912,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1932,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x18F1,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x18F1,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1932,0x1932,0x1932,0x1912,0x1933,0x1954,0x1154,0x1196,0x11B7,0x11D8,0x09F9,0x09F9,0x01D9,0x01F9,0x01F9,0x01F9,0x01D9,0x09F8,0x11F8,0x2218,0x1175,0x1112,0x1912,0x1911,0x2130,0x2110,0x2130,0x2110,0x210F,0x292F,0x292F,0x212F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x192F,0x1950,0x1150,0x0950,0x014F,0x01D1,0x2BF9,0x1BF9,0x1C19,0x1C3A,0x1BF9,0x2BD9,0x014F,0x00ED,0x114F,0x112F,0x1990,0x114F,0x092F,0x012E,0x3397,0x44BB,0x2C5A,0x2439,0x1C39,0x1C18,0x1C59,0x1C39,0x2439,0x2439,0x347A,0x3C9B,0x4C7B,0x3B98,0x00AE,0x10EF,0x1930,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x210F,0x210F,0x212F,0x2930,0x210F,0x2930,0x210F,0x290F,0x290F,0x2110,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1952,0x1133,0x1133,0x1175,0x19B6,0x21F7,0x21F7,0x19B6,0x1974,0x1132,0x1112,0x10F1,0x2131,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2150,0x2130,0x1930,0x1931,0x1112,0x1132,0x1154,0x19D6,0x2217,0x19F7,0x21D6,0x1995,0x1954,0x1933,0x1911,0x1911,0x2131,0x2931,0x2130,0x2110,0x2130,0x2130,0x212F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x292F,0x290F,0x210F,0x2130,0x2130,0x2110,0x210F,0x2930,0x2930,0x2110,0x2110,0x210F,0x210F,0x210F,0x2110,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x2910,0x2930,0x210F,0x2110,0x210F,0x2930,0x210F,0x212F,0x212F,0x212F,0x2930,0x2110,0x2930,0x290F,0x212F,0x210F,0x212F,0x210F,0x212F,0x2130,0x2930,0x2130,0x2130,0x2110,0x1931,0x1932,0x1932,0x1112,0x19B5,0x21F7,0x21D6,0x1974,0x1112,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x2930,0x292F,0x210F,0x212F,0x292F,0x292F,0x210F,0x290F,0x28EF,0x28AD,0x202B,0x48ED,0xDD1C,0xDC99,0xDC78,0xDC78,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xDC57,0xE457,0xDC57,0xDC37,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC57,0xDC37,0xE457,0xE457,0xDC58,0xDC99,0xCC78,0xD51C,0x7251,0x1809,0x208C,0x20CE,0x28EF,0x290F,0x2910,0x2110,0x2110,0x2910,0x2930,0x2930,0x2130,0x212F,0x210F,0x210F,0x2130,0x2130,0x210F,0x212F,0x2130,0x2110,0x2110,0x2130,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2910,0x2910,0x2930,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2910,0x290F,0x2910,0x2110,0x2930,0x2910,0x2930,0x2930,0x290F,0x210F,0x2930,0x212F,0x2930,0x212F,0x212F,0x2110,0x2110,0x2930,0x210F,0x2110,0x2930,0x2930,0x210F,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x2110,0x1931,0x1911,0x1112,0x1133,0x21D6,0x2217,0x21F7,0x1996,0x1133,0x1912,0x1931,0x1910,0x2130,0x2130,0x190F,0x190F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2930,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x2910,0x2930,0x290F,0x2930,0x290F,0x210F,0x290F,0x2910,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2111,0x2131,0x1932,0x1133,0x1154,0x19D6,0x2238,0x2218,0x21D7,0x1995,0x1953,0x1111,0x10F0,0x1910,0x2131,0x2151,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x1910,0x2111,0x1912,0x1933,0x1996,0x19D7,0x11D8,0x09D9,0x09D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01B9,0x09D9,0x11F8,0x19D6,0x1174,0x1112,0x1911,0x1930,0x2130,0x2950,0x2930,0x2130,0x2130,0x210F,0x2130,0x2130,0x212F,0x2130,0x2130,0x212F,0x2130,0x2110,0x2130,0x210F,0x2110,0x2930,0x2930,0x210F,0x210F,0x290F,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x212F,0x212F,0x2130,0x210F,0x2930,0x210F,0x2110,0x2910,0x2930,0x2910,0x2110,0x2110,0x2110,0x210F,0x290F,0x2930,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2130,0x210F,0x2130,0x2130,0x212F,0x210F,0x2110,0x2110,0x2110,0x2930,0x2910,0x2110,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x290F,0x2930,0x2910,0x2910,0x290F,0x2910,0x2910,0x2930,0x2930,0x210F,0x210F,0x2930,0x2910,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2110,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x212F,0x212F,0x2130,0x210F,0x2930,0x2930,0x2910,0x2910,0x2110,0x2130,0x2110,0x2110,0x2910,0x2910,0x2110,0x2910,0x2110,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x292F,0x292F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x2910,0x2910,0x290F,0x2910,0x2910,0x2910,0x2910,0x290F,0x2910,0x290F,0x290F,0x2930,0x292F,0x290F,0x290F,0x292F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2950,0x2950,0x212F,0x212F,0x210F,0x210F,0x212F,0x2930,0x2130,0x2110,0x2130,0x2130,0x2131,0x1911,0x1112,0x1133,0x1133,0x1995,0x21F6,0x21F7,0x21F6,0x1995,0x1153,0x1132,0x1111,0x1931,0x1931,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,
  0x2130,0x2110,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2930,0x212F,0x210F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2110,0x1910,0x1931,0x1931,0x1932,0x1133,0x1154,0x1174,0x1175,0x19B7,0x19F8,0x19F9,0x11F8,0x11F8,0x11B7,0x1195,0x1154,0x1133,0x1932,0x1932,0x1932,0x1931,0x2152,0x1931,0x1932,0x1132,0x1133,0x1154,0x1175,0x11B7,0x19F8,0x11F8,0x11F8,0x19F8,0x11B7,0x1175,0x0933,0x1133,0x1112,0x1911,0x1931,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2131,0x2130,0x2131,0x1910,0x2130,0x2130,0x2130,0x2110,0x2111,0x2131,0x1910,0x2111,0x2111,0x2131,0x2111,0x2111,0x2131,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x1931,0x1931,0x1931,0x1910,0x1910,0x2130,0x1910,0x2131,0x2110,0x2110,0x2110,0x2111,0x2110,0x2110,0x1910,0x2111,0x2110,0x1910,0x2130,0x2110,0x1910,0x2111,0x1910,0x1910,0x2110,0x2110,0x2111,0x2111,0x18F0,0x2111,0x2131,0x2110,0x2110,0x2111,0x1910,0x2111,0x2110,0x2110,0x1910,0x2111,0x2110,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2110,0x2111,0x2110,0x2111,0x2110,0x2111,0x1910,0x2110,0x2110,0x2111,0x2110,0x2110,0x1910,0x2110,0x2131,0x2111,0x1910,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2131,0x1911,0x1911,0x2111,0x1910,0x1910,0x2111,0x1910,0x2131,0x1910,0x2131,0x2110,0x2110,0x1910,0x2111,0x1910,0x2111,0x1911,0x2111,0x1911,0x2111,0x1910,0x2111,0x2110,0x1910,0x1910,0x2110,0x2111,0x2110,0x1910,0x2111,0x2111,0x2111,0x1910,0x2111,0x2110,0x2110,0x1910,0x1910,0x2111,0x1911,0x1910,0x2111,0x1911,0x1911,0x1910,0x2111,0x18F0,0x1931,0x2131,0x1910,0x1910,0x2131,0x1911,0x2111,0x2111,0x1911,0x1910,0x2111,0x2111,0x2131,0x1911,0x2111,0x2111,0x2131,0x1910,0x2131,0x2131,0x2110,0x1910,0x2111,0x2111,0x2110,0x1910,0x2111,0x2110,0x1910,0x1910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x1910,0x1910,0x1910,0x2110,0x1910,0x2110,0x2110,0x2111,0x1910,0x2111,0x2111,0x2110,0x1910,0x2111,0x2111,0x1910,0x1910,0x2111,0x2110,0x2111,0x2110,0x2110,0x2110,0x2130,0x1910,0x2110,0x1910,0x1910,0x2130,0x2130,0x2110,0x2130,0x1910,0x2110,0x2130,0x1910,0x1910,0x2110,0x2110,0x1910,0x1910,0x2110,0x2110,0x1910,0x1910,0x2131,0x1910,0x2130,0x1910,0x2110,0x2110,0x2110,0x1910,0x2110,0x2131,0x1910,0x1910,0x2131,0x2110,0x2131,0x1910,0x1911,0x1931,0x1931,0x1911,0x1932,0x1932,0x1932,0x1912,0x1933,0x1954,0x1175,0x1196,0x11D7,0x11F8,0x09F8,0x09F8,0x0A39,0x0A19,0x1218,0x1218,0x19D7,0x1975,0x1112,0x1111,0x1911,0x1931,0x2130,0x2130,0x2110,0x210F,0x212F,0x212F,0x292F,0x292F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x192F,0x192F,0x112F,0x0950,0x014F,0x01D1,0x2BFA,0x243A,0x1C19,0x1C3A,0x1BF9,0x23B8,0x016F,0x010E,0x112F,0x112F,0x1990,0x196F,0x092E,0x014E,0x2377,0x349B,0x245A,0x1439,0x0C18,0x0C38,0x0C19,0x0C18,0x0BF8,0x13F8,0x1C39,0x2C5A,0x3C5A,0x2B57,0x00EE,0x08EF,0x1930,0x1930,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x210F,0x210F,0x290F,0x2930,0x2110,0x2110,0x2930,0x2930,0x290F,0x290F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1952,0x1133,0x1154,0x1175,0x19B6,0x21F7,0x21F7,0x21D6,0x1975,0x1133,0x10F1,0x1911,0x1910,0x2130,0x2930,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x210F,0x210F,0x212F,0x2130,0x210F,0x2130,0x2130,0x2131,0x1931,0x1952,0x1133,0x1174,0x19D6,0x19D7,0x21F7,0x19D6,0x1995,0x1154,0x1112,0x1911,0x1911,0x2111,0x2931,0x2931,0x2930,0x2130,0x212F,0x2110,0x2930,0x210F,0x2930,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x210F,0x2910,0x210F,0x210F,0x210F,0x210F,0x2930,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x210F,0x290F,0x210F,0x2110,0x210F,0x212F,0x2930,0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2130,0x2131,0x2131,0x1932,0x1932,0x1112,0x21B5,0x2A17,0x21D6,0x1974,0x10F2,0x1912,0x1931,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2910,0x2930,0x2930,0x2930,0x2110,0x2930,0x212F,0x212F,0x212F,0x292F,0x292F,0x210F,0x28EF,0x28CE,0x28AD,0x280A,0xABB8,0xD49A,0xDC99,0xE499,0xE478,0xDC57,0xDC37,0xDC57,0xDC37,0xDC37,0xDC57,0xDC37,0xDC57,0xDC36,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC58,0xDC98,0xDCBA,0xDD1C,0x48EC,0x1809,0x28CD,0x312F,0x290F,0x290F,0x2910,0x210F,0x2110,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2930,0x2110,0x2910,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x210F,0x210F,0x2910,0x2910,0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x210F,0x212F,0x2110,0x210F,0x2930,0x2930,0x2930,0x2930,0x2110,0x2130,0x212F,0x212F,0x212F,0x2930,0x210F,0x2930,0x2930,0x212F,0x210F,0x210F,0x2910,0x210F,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x2150,0x2130,0x1931,0x1911,0x1132,0x1133,0x21D6,0x21F7,0x21D7,0x1995,0x1133,0x1932,0x1931,0x1931,0x1930,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x210F,0x2130,0x2130,0x210F,0x210F,0x2110,0x2930,0x2930,0x290F,0x290F,0x2930,0x2930,0x2930,0x210F,0x210F,0x290F,0x290F,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x292F,0x290F,0x290F,0x292F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1932,0x1133,0x19B6,0x2218,0x19F7,0x19D7,0x1975,0x1133,0x1932,0x1111,0x18F0,0x1910,0x2131,0x2131,0x20F0,0x20EF,0x210F,0x210F,0x210F,0x2950,0x210F,0x210F,0x210F,0x210F,0x2130,0x2110,0x2110,0x2131,0x1911,0x1912,0x1954,0x19B6,0x19D8,0x11F8,0x09B8,0x01D9,0x01B9,0x01D9,0x01B9,0x01B9,0x09D9,0x09D9,0x11D8,0x19D7,0x19B6,0x1153,0x10F1,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x2110,0x210F,0x212F,0x210F,0x210F,0x2930,0x2930,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x290F,0x2930,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x292F,0x212F,0x212F,0x210F,0x2930,0x210F,0x212F,0x212F,0x210F,0x2130,0x2930,0x2930,0x2910,0x2110,0x2910,0x210F,0x212F,0x212F,0x2930,0x2130,0x212F,0x212F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x2930,0x210F,0x2930,0x2930,0x2930,0x210F,0x290F,0x2930,0x290F,0x210F,0x2930,0x2130,0x2930,0x2110,0x2110,0x210F,0x2910,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2930,0x290F,0x290F,0x2930,0x2130,0x2110,0x2130,0x2110,0x2910,0x2110,0x2910,0x210F,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x2910,0x290F,0x290F,0x210F,0x290F,0x2910,0x290F,0x290F,0x2910,0x210F,0x210F,0x290F,0x2910,0x290F,0x290F,0x2930,0x290F,0x210F,0x210F,0x292F,0x290F,0x292F,0x210F,0x292F,0x2930,0x2130,0x2130,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2110,0x2110,0x1931,0x1911,0x1912,0x1133,0x1154,0x1995,0x21F7,0x2217,0x19D6,0x1195,0x1133,0x1112,0x1132,0x1931,0x2152,0x2151,0x2151,0x2131,0x2131,0x1910,0x2110,0x2110,0x2110,0x2110,0x2131,0x2110,0x2130,0x2130,0x2131,0x2131,0x2131,0x2130,0x2131,0x2131,0x2131,0x2131,0x2131,0x1910,0x2131,0x1910,0x1931,0x2131,0x2131,0x1910,0x2111,0x2131,
  0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2130,0x2110,0x1930,0x1931,0x1932,0x1952,0x1953,0x1133,0x1155,0x1196,0x11D7,0x19F8,0x11F8,0x19F9,0x19F8,0x11B7,0x1175,0x1154,0x1153,0x1932,0x1932,0x1931,0x1931,0x2152,0x1952,0x1932,0x1132,0x1112,0x1154,0x1196,0x11B6,0x19D8,0x11F8,0x11F8,0x11F8,0x11B7,0x1175,0x1154,0x0912,0x1132,0x1932,0x1931,0x1931,0x2110,0x2111,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2131,0x2111,0x2111,0x2111,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2151,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2131,0x2131,0x2131,0x1911,0x2131,0x2131,0x1912,0x1912,0x1953,0x1174,0x1195,0x19D7,0x11D7,0x11F7,0x1A18,0x1A18,0x1A17,0x19D6,0x1174,0x1133,0x1111,0x1911,0x1910,0x2130,0x2130,0x2110,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x190F,0x192F,0x192F,0x1150,0x0970,0x014F,0x01D1,0x2BFA,0x241A,0x1C3A,0x1C19,0x1BF9,0x23B8,0x014F,0x00ED,0x114F,0x114F,0x1970,0x114F,0x090E,0x014E,0x2376,0x2C7A,0x1419,0x1439,0x0C38,0x0C38,0x0C39,0x0418,0x0C18,0x0C19,0x1C19,0x243A,0x345A,0x2357,0x00EE,0x090F,0x1930,0x1950,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x292F,0x212F,0x210F,0x210F,0x210F,0x292F,0x290F,0x2930,0x2930,0x2110,0x2930,0x290F,0x2930,0x2930,0x2930,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x1154,0x1175,0x19D6,0x21F7,0x21F7,0x21F6,0x1974,0x1133,0x1111,0x1931,0x2131,0x2131,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x212F,0x2130,0x210F,0x210F,0x2130,0x2130,0x2131,0x2172,0x1952,0x1132,0x0933,0x1174,0x19B6,0x19D6,0x2217,0x19D6,0x1995,0x1154,0x1112,0x1911,0x2111,0x2131,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x210F,0x2130,0x212F,0x212F,0x210F,0x212F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2910,0x2110,0x2110,0x2110,0x210F,0x210F,0x290F,0x210F,0x2910,0x290F,0x2930,0x210F,0x2910,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2910,0x2910,0x210F,0x2930,0x2910,0x2110,0x2130,0x210F,0x210F,0x2930,0x292F,0x290F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1932,0x1112,0x21B5,0x2A17,0x21D6,0x1974,0x1112,0x1932,0x2132,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2110,0x2930,0x2930,0x212F,0x292F,0x292F,0x212F,0x212F,0x210F,0x290F,0x28EF,0x28CE,0x286C,0x512E,0xD4BB,0xD499,0xDC99,0xDC78,0xDC57,0xDC57,0xDC57,0xDC57,0xE457,0xE457,0xDC57,0xDC36,0xDC57,0xDC57,0xDC36,0xDC37,0xE457,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC37,0xDC37,0xE457,0xE457,0xDC57,0xDC78,0xDCB9,0xD4DB,0x61AF,0x2009,0x30EE,0x290E,0x28EF,0x290F,0x20EF,0x2910,0x2910,0x2110,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x2130,0x210F,0x210F,0x210F,0x2930,0x2110,0x210F,0x2110,0x2910,0x2910,0x2910,0x2110,0x2110,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x210F,0x2930,0x210F,0x210F,0x2930,0x290F,0x2930,0x212F,0x212F,0x210F,0x290F,0x2930,0x290F,0x2910,0x2930,0x2110,0x210F,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x212F,0x2930,0x290F,0x2930,0x210F,0x210F,0x2930,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1932,0x1132,0x1133,0x19B6,0x29F7,0x21D7,0x21B6,0x1113,0x1932,0x1931,0x1931,0x2130,0x2150,0x190F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x2130,0x210F,0x210F,0x212F,0x2930,0x210F,0x210F,0x2930,0x290F,0x290F,0x2930,0x210F,0x2930,0x2930,0x210F,0x2930,0x290F,0x2910,0x210F,0x290F,0x2930,0x2930,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x210F,0x212F,0x210F,0x290F,0x292F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2130,0x2131,0x1932,0x1132,0x1174,0x21F7,0x2218,0x19F7,0x19B6,0x1133,0x10F2,0x1111,0x1911,0x2131,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x2130,0x2110,0x2110,0x2111,0x1911,0x1912,0x1933,0x1995,0x19D7,0x11D7,0x09D8,0x09D9,0x01B8,0x01D9,0x01B9,0x01B9,0x09D8,0x09D8,0x11B7,0x19B6,0x1995,0x1132,0x1911,0x1911,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x2930,0x2130,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x210F,0x2910,0x210F,0x2930,0x212F,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2930,0x2930,0x2110,0x2930,0x290F,0x210F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x292F,0x210F,0x210F,0x2130,0x2130,0x210F,0x210F,0x212F,0x2930,0x2110,0x210F,0x210F,0x210F,0x2110,0x2930,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x212F,0x2930,0x212F,0x2930,0x212F,0x212F,0x2930,0x210F,0x290F,0x210F,0x290F,0x212F,0x212F,0x2930,0x212F,0x210F,0x210F,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x2910,0x290F,0x210F,0x2130,0x212F,0x212F,0x2130,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2130,0x2110,0x2930,0x2910,0x2930,0x2910,0x292F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x210F,0x290F,0x290F,0x20EF,0x2910,0x290F,0x290F,0x2930,0x2910,0x290F,0x290F,0x290F,0x2910,0x210F,0x210F,0x290F,0x290F,0x210F,0x292F,0x290F,0x292F,0x290F,0x210F,0x2930,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2131,0x1911,0x1932,0x1113,0x1154,0x1995,0x21F7,0x2217,0x21F6,0x1975,0x1133,0x1112,0x1111,0x1932,0x1952,0x2152,0x2151,0x2151,0x1931,0x1931,0x1931,0x1931,0x2131,0x2131,0x2111,0x2131,0x2111,0x2131,0x2111,0x2111,0x2131,0x1911,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1931,0x1931,0x1931,0x1911,0x1911,
  0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x210F,0x2930,0x2130,0x2130,0x210F,0x2110,0x2910,0x2910,0x2930,0x292F,0x290F,0x290F,0x210F,0x210F,0x2130,0x2130,0x2150,0x1930,0x1931,0x1932,0x1953,0x1133,0x1133,0x1155,0x1196,0x11D7,0x11D8,0x19F9,0x19F9,0x11F8,0x19D7,0x1175,0x1154,0x1133,0x1112,0x1932,0x1931,0x1931,0x2152,0x2132,0x1932,0x1112,0x1133,0x1154,0x1175,0x1196,0x11D7,0x19F8,0x11F8,0x11D8,0x19D7,0x1196,0x1195,0x0933,0x1112,0x1932,0x2152,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2130,0x1930,0x1930,0x1930,0x2130,0x2130,0x1910,0x2130,0x2110,0x2111,0x2111,0x2110,0x2131,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x2110,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x2130,0x210F,0x210F,0x210F,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x2110,0x2110,0x2130,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2131,0x2131,0x2110,0x2131,0x2111,0x1911,0x1932,0x1933,0x1974,0x1974,0x1974,0x1174,0x1995,0x1974,0x1133,0x1132,0x1112,0x1931,0x1931,0x1930,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x292F,0x292F,0x292F,0x2930,0x292F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2150,0x1950,0x1950,0x1170,0x012F,0x01D1,0x2BF9,0x243A,0x245A,0x1C3A,0x1BF9,0x2398,0x014F,0x010E,0x112F,0x112F,0x1970,0x1970,0x090E,0x014F,0x23B7,0x247A,0x0C18,0x0C39,0x0418,0x0418,0x0C59,0x0C39,0x0418,0x0C18,0x13F8,0x1C19,0x2C39,0x2B77,0x00EE,0x090F,0x1950,0x1950,0x2130,0x2130,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x292F,0x212F,0x212F,0x290F,0x290F,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x290F,0x290F,0x212F,0x2130,0x2930,0x2130,0x212F,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1132,0x1154,0x1174,0x19D6,0x2217,0x21F7,0x19D6,0x1994,0x1112,0x1111,0x1911,0x2151,0x2151,0x2130,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2930,0x2110,0x210F,0x2110,0x2130,0x2130,0x2130,0x2151,0x1931,0x1931,0x1112,0x1133,0x1174,0x19B5,0x2217,0x21F7,0x19D6,0x1995,0x1153,0x1112,0x1932,0x2131,0x2131,0x2130,0x2930,0x2930,0x2930,0x2930,0x2130,0x210F,0x212F,0x212F,0x2930,0x290F,0x2930,0x2930,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2930,0x2930,0x210F,0x292F,0x2930,0x2930,0x2930,0x2910,0x210F,0x2110,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2110,0x2110,0x2110,0x2110,0x2131,0x1932,0x1932,0x1112,0x21B5,0x2A17,0x21F6,0x1974,0x1112,0x1932,0x2152,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x2930,0x2930,0x2910,0x2910,0x2110,0x212F,0x212F,0x292F,0x292F,0x212F,0x292F,0x210F,0x28EF,0x28AD,0x180A,0xA397,0xDCDB,0xDCDA,0xE499,0xDC57,0xDC57,0xDC37,0xDC37,0xDC57,0xDC57,0xDC36,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC37,0xE477,0xE457,0xDC58,0xDC99,0xDCBA,0xD4FB,0x306B,0x206B,0x20AD,0x28EE,0x290F,0x2910,0x2910,0x2110,0x2110,0x2130,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2110,0x2110,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x2930,0x2910,0x2930,0x290F,0x290F,0x290F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2910,0x2110,0x2930,0x290F,0x290F,0x290F,0x2910,0x2930,0x290F,0x290F,0x290F,0x2930,0x2930,0x2910,0x2910,0x290F,0x2930,0x210F,0x2930,0x212F,0x212F,0x212F,0x2930,0x212F,0x2930,0x2930,0x2930,0x210F,0x2930,0x2950,0x2930,0x210F,0x2130,0x2130,0x2130,0x1930,0x1931,0x1932,0x1133,0x1133,0x19B6,0x21F7,0x21D7,0x1996,0x1133,0x1112,0x1952,0x1931,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x210F,0x2110,0x2110,0x2930,0x2130,0x2930,0x210F,0x210F,0x210F,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2930,0x290F,0x2910,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x2910,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2111,0x1912,0x1133,0x21D6,0x2238,0x19F7,0x19D6,0x0954,0x1112,0x1111,0x1911,0x1910,0x2130,0x2130,0x2110,0x2130,0x2110,0x210F,0x210F,0x210F,0x2130,0x2930,0x210F,0x2110,0x210F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1911,0x1912,0x1933,0x1954,0x19B6,0x19F7,0x11D7,0x09D8,0x09D8,0x09F8,0x09D8,0x09D8,0x11D7,0x11F7,0x11B6,0x1995,0x2194,0x1953,0x1931,0x1931,0x2130,0x2150,0x2150,0x2130,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2930,0x2930,0x290F,0x292F,0x292F,0x292F,0x2930,0x212F,0x210F,0x212F,0x292F,0x292F,0x292F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x2930,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x2930,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x290F,0x292F,0x292F,0x290F,0x2930,0x210F,0x290F,0x290F,0x210F,0x2910,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x290F,0x292F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x292F,0x212F,0x2930,0x212F,0x210F,0x2930,0x212F,0x210F,0x210F,0x2910,0x290F,0x290F,0x210F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2110,0x210F,0x2130,0x212F,0x2130,0x2930,0x290F,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2930,0x2110,0x2110,0x212F,0x212F,0x2930,0x2930,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x290F,0x2930,0x290F,0x210F,0x210F,0x290F,0x290F,0x2930,0x2930,0x2930,0x290F,0x290F,0x2930,0x2930,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x2950,0x2130,0x2130,0x2110,0x2110,0x1911,0x1111,0x1112,0x1154,0x1996,0x21F7,0x2217,0x19D6,0x1975,0x1133,0x1112,0x1131,0x1931,0x1931,0x1931,0x2152,0x2151,0x1951,0x1931,0x1951,0x1931,0x1931,0x1932,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1912,0x1912,0x1911,0x1911,0x1912,0x1912,0x1912,0x1912,0x1912,0x1912,0x1111,0x1911,0x1912,0x1912,0x1111,0x1932,0x1932,0x1912,
  0x212F,0x210F,0x2930,0x2930,0x210F,0x212F,0x2930,0x2130,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2930,0x2910,0x210F,0x2930,0x2930,0x290F,0x212F,0x292F,0x212F,0x2150,0x2150,0x1930,0x1931,0x1931,0x1932,0x1932,0x1133,0x1154,0x1175,0x11B6,0x11D7,0x11F8,0x19F9,0x1A19,0x11D8,0x11B7,0x1176,0x1154,0x1133,0x1132,0x1932,0x1931,0x2131,0x2131,0x1931,0x1932,0x1112,0x1133,0x1154,0x1175,0x1196,0x11D7,0x19F8,0x1A19,0x11F8,0x11D7,0x11D7,0x1175,0x0933,0x0912,0x1132,0x1932,0x1932,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1951,0x1951,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x2111,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2130,0x2130,0x2150,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x210F,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x2110,0x210F,0x2110,0x2110,0x2110,0x2130,0x210F,0x2110,0x2130,0x210F,0x2110,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2110,0x210F,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x210F,0x210F,0x2130,0x212F,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x210F,0x210F,0x2110,0x210F,0x210F,0x2110,0x2110,0x2130,0x210F,0x2110,0x2130,0x2110,0x210F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x210F,0x2110,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2111,0x2131,0x2131,0x1931,0x1932,0x1932,0x1932,0x1932,0x1112,0x1111,0x1911,0x1911,0x1911,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x292F,0x292F,0x292F,0x212F,0x292F,0x292F,0x210F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2150,0x2150,0x194F,0x114F,0x0950,0x012F,0x01D1,0x2BD9,0x2419,0x1C39,0x2439,0x1C19,0x2398,0x014F,0x00EE,0x194F,0x110E,0x194F,0x1970,0x090E,0x012E,0x2BD8,0x1C39,0x0C18,0x0418,0x0418,0x0439,0x0418,0x03F8,0x0418,0x0C19,0x1439,0x1C19,0x2C5A,0x2357,0x010F,0x090F,0x1150,0x1950,0x1930,0x2130,0x212F,0x212F,0x292F,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x210F,0x292F,0x290F,0x212F,0x210F,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x210F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2151,0x1952,0x1133,0x1154,0x1175,0x19D6,0x2217,0x2217,0x21F6,0x1974,0x1132,0x1111,0x1911,0x2131,0x2151,0x2130,0x2950,0x2130,0x212F,0x292F,0x210F,0x290F,0x2930,0x2110,0x2130,0x2130,0x2130,0x2150,0x2110,0x2130,0x1930,0x1911,0x1111,0x1132,0x1132,0x1974,0x19D6,0x21F7,0x21F7,0x19B6,0x1995,0x1133,0x1112,0x1911,0x2131,0x2130,0x2110,0x2930,0x2110,0x2930,0x2130,0x212F,0x2130,0x2930,0x210F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x2930,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2930,0x2910,0x210F,0x210F,0x2930,0x210F,0x212F,0x212F,0x2930,0x292F,0x2930,0x2930,0x210F,0x2930,0x2110,0x2930,0x212F,0x212F,0x212F,0x210F,0x210F,0x292F,0x212F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2131,0x1932,0x1932,0x1112,0x21B5,0x2A17,0x21D6,0x1994,0x1112,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x292F,0x210F,0x212F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2930,0x292F,0x212F,0x292F,0x292F,0x212F,0x292F,0x290F,0x28EE,0x288C,0x388C,0xD4FC,0xDCDA,0xDCB9,0xE498,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC36,0xDC57,0xDC57,0xDC37,0xDC36,0xDC57,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC57,0xE457,0xDC36,0xDC37,0xE457,0xE457,0xDC58,0xDC78,0xDCB9,0xE55D,0x6A11,0x200A,0x28AD,0x28EE,0x290F,0x2910,0x210F,0x210F,0x2110,0x2930,0x210F,0x2130,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x210F,0x2910,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2910,0x2110,0x2930,0x210F,0x290F,0x290F,0x210F,0x2910,0x210F,0x290F,0x210F,0x290F,0x2910,0x2910,0x2930,0x290F,0x290F,0x290F,0x210F,0x2930,0x212F,0x2930,0x212F,0x212F,0x2930,0x2110,0x210F,0x210F,0x290F,0x2930,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x1930,0x1952,0x1132,0x1133,0x19B6,0x21D7,0x21D7,0x19B6,0x1113,0x1112,0x1932,0x1931,0x2130,0x2130,0x190F,0x210F,0x210F,0x2930,0x212F,0x212F,0x2110,0x2130,0x2110,0x2110,0x210F,0x2110,0x210F,0x2130,0x210F,0x210F,0x212F,0x292F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2930,0x212F,0x2930,0x2130,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2131,0x1932,0x1153,0x2217,0x1A17,0x2218,0x1195,0x0913,0x1112,0x1911,0x1931,0x1910,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2930,0x210F,0x2110,0x2930,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x2131,0x2110,0x2111,0x1911,0x1912,0x1133,0x1174,0x1995,0x11B6,0x19F7,0x11D7,0x11D7,0x11D7,0x11D7,0x11D6,0x19B5,0x1994,0x1973,0x1952,0x1931,0x2151,0x2151,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2930,0x212F,0x292F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x292F,0x2930,0x2930,0x210F,0x290F,0x210F,0x210F,0x2930,0x210F,0x2130,0x210F,0x210F,0x212F,0x212F,0x292F,0x212F,0x212F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x292F,0x212F,0x210F,0x2930,0x210F,0x290F,0x292F,0x210F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x2910,0x210F,0x210F,0x210F,0x290F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2930,0x2930,0x2110,0x212F,0x212F,0x212F,0x2930,0x212F,0x2930,0x290F,0x210F,0x210F,0x2930,0x290F,0x210F,0x210F,0x210F,0x2910,0x290F,0x210F,0x2930,0x290F,0x210F,0x2930,0x2930,0x210F,0x290F,0x210F,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x2150,0x2150,0x2130,0x2130,0x2130,0x1911,0x1911,0x1112,0x1133,0x1995,0x21F7,0x21F7,0x21F7,0x1995,0x1133,0x1112,0x1111,0x1932,0x1931,0x1951,0x1931,0x1931,0x1931,0x1931,0x1931,0x1952,0x1952,0x1132,0x1932,0x1932,0x1932,0x1132,0x1132,0x1132,0x1132,0x1112,0x1112,0x1133,0x1133,0x1112,0x1133,0x1132,0x1112,0x1112,0x1112,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,
  0x290F,0x210F,0x210F,0x2110,0x2930,0x2930,0x210F,0x210F,0x212F,0x2130,0x210F,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x2930,0x290F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2150,0x2150,0x2130,0x1931,0x1931,0x1932,0x1933,0x1113,0x1154,0x1175,0x1196,0x11D7,0x19F9,0x19F9,0x19F9,0x19F8,0x1197,0x1175,0x1154,0x1133,0x1111,0x1931,0x1910,0x2131,0x2131,0x2131,0x1931,0x1932,0x1953,0x1154,0x1196,0x19B7,0x11D7,0x11D7,0x19F8,0x11F8,0x11B7,0x11B6,0x0975,0x0934,0x00F2,0x08F2,0x1112,0x1112,0x1111,0x1111,0x1112,0x1111,0x1131,0x1111,0x1111,0x1111,0x1131,0x1111,0x1111,0x1111,0x10F1,0x10F1,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1930,0x1930,0x2130,0x2130,0x2130,0x2930,0x2130,0x2130,0x2930,0x210F,0x210F,0x210F,0x210F,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x2110,0x2110,0x2130,0x2130,0x2930,0x210F,0x2130,0x2110,0x2110,0x210F,0x2110,0x2910,0x210F,0x210F,0x2930,0x2930,0x2130,0x210F,0x210F,0x2110,0x2930,0x210F,0x2130,0x2130,0x2110,0x2130,0x2130,0x2930,0x292F,0x210F,0x210F,0x210F,0x292F,0x210F,0x292F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2130,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x210F,0x210F,0x210F,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x210F,0x210F,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2130,0x2130,0x2110,0x210F,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2131,0x2131,0x2131,0x1931,0x1911,0x1911,0x1911,0x2131,0x1931,0x1910,0x1910,0x2130,0x2130,0x2130,0x2130,0x2950,0x212F,0x210F,0x292F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x214F,0x192F,0x114F,0x1150,0x012F,0x01B1,0x2BD9,0x241A,0x245A,0x1C19,0x1C19,0x23B8,0x016F,0x010E,0x194F,0x194F,0x194F,0x194F,0x092F,0x012F,0x2BF8,0x247A,0x1439,0x0C39,0x0418,0x0438,0x0418,0x0418,0x0418,0x0418,0x1439,0x1C39,0x2C39,0x2B97,0x010F,0x0930,0x1150,0x1930,0x192F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x212F,0x290F,0x290F,0x2930,0x2930,0x2910,0x290F,0x290F,0x290F,0x2930,0x292F,0x292F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2151,0x2172,0x1932,0x1132,0x1133,0x1174,0x19F7,0x2217,0x2217,0x21F6,0x1974,0x1133,0x1112,0x1911,0x2131,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x1930,0x1931,0x1911,0x1112,0x1133,0x1154,0x19D6,0x2217,0x19D7,0x21F7,0x1174,0x1112,0x1912,0x1911,0x2131,0x2130,0x2130,0x2130,0x2110,0x2130,0x210F,0x210F,0x2110,0x290F,0x290F,0x2930,0x2110,0x2930,0x2930,0x210F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2930,0x212F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2930,0x2930,0x2930,0x210F,0x2930,0x2930,0x210F,0x210F,0x2910,0x2110,0x2930,0x212F,0x2930,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2132,0x1952,0x1112,0x21B5,0x2A17,0x21D6,0x1174,0x1112,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2910,0x2910,0x290F,0x2930,0x2930,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x30EE,0x284B,0x8AF4,0xDD1B,0xDCB9,0xDCB9,0xDC57,0xDC57,0xDC57,0xDC37,0xDC57,0xDC57,0xDC57,0xDC36,0xDC57,0xDC57,0xDC57,0xDC37,0xDC57,0xDC36,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xE457,0xE457,0xDC37,0xDC37,0xDC57,0xE457,0xDC58,0xDC78,0xDC99,0xE55C,0xB459,0x284A,0x28CD,0x28EE,0x290F,0x290F,0x290F,0x2910,0x2110,0x2930,0x210F,0x2130,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2910,0x2910,0x2110,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x210F,0x2110,0x2930,0x210F,0x210F,0x2930,0x290F,0x290F,0x2930,0x2110,0x2930,0x2910,0x290F,0x210F,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x212F,0x212F,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x2930,0x2930,0x212F,0x210F,0x2130,0x2150,0x2130,0x2151,0x1931,0x1131,0x1132,0x1133,0x19B6,0x21F8,0x21F7,0x19B6,0x0913,0x10F2,0x1932,0x2151,0x2130,0x2130,0x210F,0x210F,0x212F,0x2930,0x210F,0x2130,0x2130,0x2110,0x210F,0x2110,0x2110,0x210F,0x212F,0x2930,0x210F,0x210F,0x210F,0x212F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2930,0x2930,0x2130,0x2130,0x2930,0x2130,0x2110,0x2111,0x1911,0x1112,0x19B5,0x2238,0x2218,0x19F7,0x0913,0x08F2,0x1112,0x1931,0x2151,0x2131,0x2130,0x2110,0x210F,0x2110,0x2110,0x2930,0x2930,0x2110,0x2930,0x2950,0x2930,0x2110,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2131,0x2111,0x1931,0x1932,0x1112,0x1153,0x1974,0x1195,0x1175,0x1195,0x1195,0x1154,0x1154,0x1953,0x1112,0x1111,0x1911,0x1910,0x2131,0x1930,0x2130,0x210F,0x210F,0x2130,0x2150,0x2150,0x2130,0x2150,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2930,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x210F,0x290F,0x2930,0x290F,0x290F,0x210F,0x210F,0x290F,0x2930,0x210F,0x2130,0x2130,0x2930,0x2930,0x212F,0x210F,0x210F,0x210F,0x212F,0x292F,0x212F,0x210F,0x210F,0x2130,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x210F,0x2930,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x290F,0x292F,0x292F,0x212F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2930,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x2930,0x290F,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x290F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2150,0x2130,0x2131,0x1911,0x1931,0x1932,0x1133,0x1995,0x19D6,0x21F7,0x21F7,0x1995,0x1112,0x1112,0x1111,0x1931,0x2152,0x2172,0x1931,0x1111,0x1111,0x1111,0x1132,0x1152,0x1153,0x1173,0x1153,0x1153,0x1153,0x1153,0x1173,0x1174,0x1154,0x1974,0x1954,0x1974,0x1974,0x1974,0x1974,0x1974,0x1974,0x1994,0x1974,0x1974,0x1995,0x1994,0x1994,0x1995,0x1994,0x1994,0x1994,0x1994,
  0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x2110,0x2930,0x2110,0x2930,0x2110,0x2110,0x2110,0x210F,0x292F,0x212F,0x292F,0x212F,0x2930,0x2130,0x2130,0x2130,0x2131,0x2111,0x1931,0x1932,0x1932,0x1133,0x1153,0x1175,0x11B6,0x11B7,0x19F9,0x19F9,0x11F9,0x11F8,0x11B7,0x1175,0x1154,0x1153,0x1931,0x1931,0x1931,0x2131,0x2131,0x1931,0x1932,0x1932,0x1953,0x1175,0x1996,0x1196,0x11D7,0x11D8,0x11D8,0x11D8,0x11D7,0x11D7,0x11B6,0x0975,0x0954,0x1154,0x1154,0x1153,0x0953,0x0953,0x0933,0x0953,0x0933,0x0932,0x0932,0x0932,0x0932,0x0912,0x1133,0x1133,0x1112,0x1112,0x1132,0x1132,0x0912,0x1132,0x1112,0x0932,0x0912,0x1112,0x1112,0x0911,0x1112,0x1112,0x1111,0x1111,0x1931,0x1911,0x1931,0x2130,0x2130,0x2130,0x2930,0x2130,0x2930,0x210F,0x210F,0x210F,0x2110,0x2930,0x2130,0x2130,0x2130,0x210F,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2110,0x210F,0x210F,0x2930,0x2930,0x212F,0x210F,0x2930,0x292F,0x212F,0x212F,0x2110,0x2930,0x290F,0x290F,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x212F,0x2930,0x2110,0x2930,0x212F,0x210F,0x2930,0x2110,0x2930,0x2930,0x2930,0x212F,0x212F,0x292F,0x292F,0x290F,0x210F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x292F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2130,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x210F,0x212F,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x210F,0x2110,0x210F,0x2110,0x2110,0x210F,0x2110,0x2930,0x210F,0x2110,0x210F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x1910,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x212F,0x214F,0x194F,0x1950,0x1150,0x012F,0x01B1,0x2BD9,0x2419,0x1C39,0x1C3A,0x2419,0x23B8,0x014F,0x00EE,0x194F,0x192F,0x192F,0x1950,0x092F,0x012F,0x2BD8,0x247A,0x1459,0x0C39,0x0418,0x0418,0x0418,0x0439,0x0439,0x0C19,0x0C18,0x1419,0x2C3A,0x2357,0x010E,0x092F,0x1150,0x1930,0x1930,0x2130,0x212F,0x212F,0x210F,0x292F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x210F,0x290F,0x210F,0x2930,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x2930,0x290F,0x292F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2130,0x2130,0x2151,0x1931,0x1132,0x1133,0x1154,0x1195,0x21F7,0x2217,0x2217,0x21F6,0x1974,0x1133,0x1112,0x1931,0x1931,0x2130,0x2130,0x2130,0x210F,0x290F,0x2930,0x2130,0x2130,0x2110,0x2930,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2131,0x1931,0x1911,0x1112,0x1133,0x1175,0x19D7,0x19F7,0x19F7,0x19B6,0x1133,0x1932,0x1932,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x210F,0x2110,0x292F,0x290F,0x2110,0x2110,0x2930,0x2930,0x210F,0x2910,0x2910,0x290F,0x290F,0x210F,0x2930,0x290F,0x2910,0x2910,0x2930,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x2930,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2910,0x2110,0x2110,0x210F,0x212F,0x292F,0x212F,0x210F,0x212F,0x2130,0x2110,0x2110,0x2130,0x2131,0x2131,0x1932,0x1932,0x1112,0x1995,0x2A17,0x21D6,0x1974,0x1112,0x1932,0x2152,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x292F,0x2930,0x2930,0x2930,0x2110,0x2930,0x2930,0x290F,0x290F,0x292F,0x212F,0x292F,0x292F,0x292F,0x290F,0x28EE,0x30EE,0x308B,0xC47A,0xDCDA,0xDCB9,0xDC78,0xDC57,0xDC57,0xDC37,0xDC37,0xDC57,0xDC57,0xDC36,0xDC37,0xDC57,0xDC37,0xDC37,0xDC57,0xDC37,0xDC37,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xE457,0xE457,0xDC37,0xDC57,0xDC37,0xE458,0xDC58,0xDC78,0xDC99,0xE51C,0xCCBB,0x40ED,0x28AC,0x20AD,0x28EF,0x290F,0x290F,0x210F,0x2930,0x2910,0x2110,0x212F,0x2930,0x212F,0x2930,0x212F,0x2930,0x2930,0x212F,0x212F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2910,0x2930,0x212F,0x212F,0x212F,0x210F,0x290F,0x290F,0x292F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x210F,0x2110,0x2110,0x210F,0x210F,0x2930,0x290F,0x2910,0x290F,0x210F,0x2930,0x292F,0x290F,0x212F,0x210F,0x210F,0x2930,0x2930,0x212F,0x2930,0x2910,0x212F,0x212F,0x292F,0x292F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x1931,0x1932,0x1132,0x1134,0x1996,0x21F8,0x21D8,0x19B7,0x0913,0x10F2,0x1932,0x2151,0x2131,0x2130,0x2130,0x212F,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2930,0x210F,0x212F,0x212F,0x2930,0x210F,0x212F,0x2930,0x290F,0x210F,0x292F,0x2930,0x2910,0x2930,0x290F,0x290F,0x2930,0x2930,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2930,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2930,0x2930,0x212F,0x2130,0x2110,0x2130,0x2110,0x2110,0x2111,0x10F1,0x19B5,0x2238,0x1A18,0x19D6,0x0913,0x10F1,0x1931,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2130,0x2950,0x2130,0x2130,0x2110,0x2930,0x2930,0x2930,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2131,0x2131,0x1911,0x1931,0x1931,0x1932,0x1132,0x1133,0x1133,0x1133,0x1933,0x1132,0x1111,0x1931,0x1931,0x1930,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x290F,0x290F,0x292F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x290F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2930,0x2110,0x2130,0x2930,0x210F,0x210F,0x212F,0x2130,0x210F,0x2930,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x292F,0x210F,0x212F,0x2930,0x2930,0x290F,0x210F,0x2110,0x210F,0x2130,0x2130,0x212F,0x210F,0x2130,0x2150,0x2150,0x2130,0x2130,0x2130,0x2131,0x1911,0x1911,0x1932,0x1153,0x1995,0x21F6,0x21F7,0x21F7,0x1175,0x1133,0x1112,0x1111,0x1931,0x1952,0x2152,0x1931,0x1911,0x1131,0x1111,0x1132,0x1973,0x21D5,0x21F6,0x21F6,0x2216,0x2A17,0x2A17,0x2A37,0x2A57,0x2A37,0x3237,0x3237,0x2A17,0x3237,0x2A17,0x3237,0x3237,0x2A37,0x3237,0x2A37,0x3237,0x2A37,0x2A37,0x2A17,0x2A17,0x2A16,0x2A16,0x21F6,0x29D6,0x29D6,
  0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2130,0x212F,0x212F,0x2130,0x2130,0x2110,0x2930,0x2910,0x2110,0x2110,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2111,0x2131,0x1932,0x1912,0x1132,0x1153,0x1175,0x11B6,0x11B8,0x11F9,0x1219,0x1219,0x11F8,0x11B7,0x1175,0x1174,0x1132,0x1131,0x1931,0x1931,0x2131,0x2131,0x1911,0x1932,0x1932,0x1133,0x1154,0x1155,0x1196,0x11B7,0x11F8,0x11F8,0x11F8,0x09D7,0x11D7,0x11F7,0x11D7,0x19F7,0x19F7,0x19F7,0x19F7,0x11F7,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x1A17,0x1A17,0x19F7,0x19F7,0x19D7,0x19D7,0x19D7,0x19F7,0x19D7,0x19D7,0x19D7,0x19F6,0x11D6,0x19D6,0x19D6,0x19D6,0x11D6,0x19D6,0x11B5,0x1174,0x1153,0x1952,0x1911,0x1911,0x1911,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x212F,0x2130,0x212F,0x2130,0x210F,0x212F,0x210F,0x210F,0x212F,0x2130,0x212F,0x2130,0x2130,0x210F,0x2110,0x2910,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x212F,0x210F,0x2110,0x2110,0x210F,0x210F,0x210F,0x2110,0x210F,0x2110,0x2930,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2130,0x212F,0x210F,0x210F,0x2130,0x210F,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2930,0x2130,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2110,0x2110,0x210F,0x2130,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2130,0x210F,0x2110,0x2110,0x2110,0x2910,0x2110,0x210F,0x210F,0x210F,0x2110,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x210F,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2150,0x212F,0x2150,0x212F,0x212F,0x212F,0x2130,0x2150,0x212F,0x212F,0x212F,0x194F,0x1950,0x1170,0x012F,0x01D2,0x2BF9,0x2419,0x1C39,0x243A,0x243A,0x23B8,0x012F,0x00EE,0x1950,0x110F,0x194F,0x1950,0x092F,0x012E,0x2BD8,0x1C39,0x0C19,0x0418,0x0438,0x0418,0x0418,0x0439,0x0418,0x0C19,0x0BF8,0x1419,0x2C5A,0x1B36,0x010F,0x092F,0x1130,0x1930,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x290F,0x290F,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x290F,0x292F,0x290F,0x290F,0x290F,0x2930,0x292F,0x212F,0x212F,0x292F,0x292F,0x292F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1952,0x1952,0x1133,0x1153,0x1174,0x19D6,0x2217,0x21F7,0x19D6,0x1174,0x1133,0x1112,0x1912,0x1931,0x2130,0x2130,0x210F,0x2110,0x2930,0x20EF,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x2130,0x2151,0x2151,0x1931,0x1932,0x1132,0x1154,0x1175,0x19F7,0x19F8,0x19D7,0x1154,0x1112,0x1932,0x2131,0x2131,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x210F,0x2930,0x290F,0x2930,0x2930,0x290F,0x2910,0x210F,0x2110,0x210F,0x210F,0x2930,0x290F,0x290F,0x210F,0x290F,0x2930,0x210F,0x210F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x2930,0x2930,0x2930,0x210F,0x290F,0x2910,0x2110,0x2930,0x2110,0x2910,0x290F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2131,0x2131,0x2132,0x1932,0x1112,0x1995,0x29F7,0x21D6,0x1954,0x10F2,0x1912,0x2152,0x2151,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x212F,0x2930,0x2930,0x2110,0x2910,0x2910,0x2910,0x2930,0x292F,0x292F,0x290F,0x290F,0x290F,0x290E,0x28CE,0x206B,0x59AF,0xDD1B,0xDCDA,0xDCB9,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xE457,0xDC37,0xDC37,0xDC36,0xDC37,0xDC37,0xDC57,0xDC57,0xDC37,0xDC57,0xDC57,0xDC37,0xDC37,0xDC58,0xDC58,0xDC78,0xD499,0xCC9A,0x512D,0x412E,0x20AD,0x28EE,0x20EF,0x290F,0x2910,0x210F,0x2930,0x2910,0x210F,0x2910,0x2930,0x2930,0x2930,0x2930,0x2110,0x2930,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x212F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2910,0x2930,0x210F,0x2930,0x290F,0x210F,0x212F,0x2930,0x210F,0x2910,0x2930,0x2930,0x2930,0x2930,0x292F,0x2950,0x210F,0x210F,0x210F,0x210F,0x2950,0x2150,0x2130,0x2130,0x1931,0x1932,0x1133,0x1134,0x19B7,0x21F8,0x19F8,0x19B7,0x0914,0x1112,0x1112,0x1931,0x2151,0x2130,0x2110,0x2130,0x2130,0x2130,0x212F,0x210F,0x2930,0x212F,0x2930,0x210F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2910,0x210F,0x210F,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x2910,0x2910,0x2930,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2111,0x1911,0x1112,0x19B5,0x1A18,0x1A18,0x19B6,0x08F2,0x1111,0x1931,0x2131,0x2130,0x2110,0x2130,0x2930,0x2110,0x2930,0x2130,0x2130,0x2130,0x2930,0x2110,0x2930,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x1910,0x1931,0x1952,0x1952,0x1932,0x1932,0x1912,0x1932,0x2152,0x1951,0x1931,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2150,0x192F,0x2150,0x2150,0x2150,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x214F,0x214F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x192F,0x212F,0x212F,0x212F,0x214F,0x214F,0x212F,0x212F,0x214F,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x292F,0x212F,0x210F,0x212F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x292F,0x210F,0x290F,0x210F,0x210F,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x292F,0x212F,0x212F,0x212F,0x2930,0x2130,0x2110,0x2130,0x2110,0x2131,0x2110,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2930,0x212F,0x212F,0x210F,0x210F,0x2910,0x2910,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x2130,0x210F,0x212F,0x2930,0x2130,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x2950,0x2150,0x2130,0x2130,0x1910,0x1911,0x1931,0x1952,0x1153,0x1995,0x21F6,0x2217,0x21F6,0x1995,0x1153,0x1112,0x1111,0x1931,0x1951,0x1952,0x1931,0x1111,0x1112,0x1112,0x1974,0x21D5,0x21F6,0x21F6,0x2217,0x2A37,0x21F7,0x21F7,0x2217,0x2A17,0x2A37,0x2A37,0x2A37,0x2A37,0x2A17,0x21F6,0x21F6,0x21F6,0x29F6,0x29F6,0x29F6,0x29F6,0x2A16,0x2A16,0x2A16,0x29F6,0x2A16,0x29F6,0x21F6,0x21D6,0x21D6,0x21D6,
  0x2910,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2910,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x2110,0x2110,0x2131,0x2111,0x1911,0x1932,0x1132,0x1154,0x1175,0x0996,0x11D8,0x1A19,0x1219,0x1A19,0x11F8,0x11B7,0x1195,0x1154,0x1132,0x1932,0x1911,0x1931,0x1931,0x1931,0x1931,0x1911,0x1912,0x1133,0x1154,0x1995,0x1196,0x19D7,0x11D7,0x11D8,0x11D8,0x11F8,0x11F8,0x1218,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x11D8,0x11F8,0x11F8,0x11F8,0x11D8,0x11F8,0x11F8,0x11F8,0x11D8,0x1218,0x1218,0x1218,0x11F8,0x1218,0x1A18,0x1A18,0x1A18,0x19F7,0x11B5,0x1154,0x1133,0x1112,0x1931,0x2111,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x212F,0x212F,0x2130,0x2130,0x212F,0x2130,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2930,0x2910,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x212F,0x212F,0x210F,0x2110,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x212F,0x212F,0x210F,0x2110,0x212F,0x212F,0x212F,0x292F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x210F,0x2130,0x2930,0x210F,0x210F,0x2130,0x210F,0x2130,0x212F,0x2130,0x210F,0x212F,0x210F,0x2930,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x2930,0x2130,0x210F,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2110,0x2110,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x2930,0x2930,0x212F,0x212F,0x212F,0x2130,0x210F,0x210F,0x2930,0x212F,0x2130,0x212F,0x212F,0x212F,0x2930,0x210F,0x2910,0x2110,0x2910,0x2910,0x2910,0x2930,0x212F,0x2110,0x2110,0x2110,0x210F,0x2930,0x290F,0x212F,0x212F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x212F,0x212F,0x2130,0x212F,0x2130,0x212F,0x192F,0x2150,0x194F,0x192F,0x192F,0x192F,0x2150,0x2150,0x212F,0x212F,0x212F,0x212F,0x194F,0x114F,0x1170,0x012F,0x01D1,0x2BD9,0x241A,0x245A,0x1C39,0x1BF9,0x2398,0x014F,0x00CD,0x1950,0x194F,0x194F,0x112F,0x092F,0x010E,0x2BD8,0x1C19,0x0C18,0x0C39,0x0418,0x0439,0x0439,0x0419,0x0419,0x0C19,0x1439,0x1C39,0x347B,0x1AF5,0x010F,0x092F,0x1150,0x1930,0x2130,0x2130,0x212F,0x210F,0x292F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x2910,0x2910,0x2110,0x2930,0x2110,0x2910,0x292F,0x292F,0x292F,0x290F,0x290F,0x292F,0x212F,0x292F,0x210F,0x292F,0x212F,0x210F,0x212F,0x210F,0x2130,0x2110,0x2131,0x2151,0x2152,0x1932,0x1132,0x1133,0x1175,0x19D6,0x2217,0x2218,0x19D6,0x1154,0x1153,0x1112,0x1911,0x1931,0x2131,0x2130,0x2130,0x2110,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x2130,0x212F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1132,0x1133,0x0934,0x19B6,0x19F8,0x19F7,0x19B5,0x1132,0x1932,0x1932,0x2131,0x2110,0x2930,0x2110,0x2110,0x2930,0x2930,0x210F,0x212F,0x212F,0x290F,0x210F,0x290F,0x2910,0x210F,0x2930,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2930,0x290F,0x290F,0x2930,0x290F,0x210F,0x2910,0x2910,0x2110,0x2110,0x2930,0x2910,0x292F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2132,0x1932,0x1112,0x21B5,0x21F6,0x21D6,0x1995,0x10F2,0x1912,0x2152,0x2151,0x2130,0x2110,0x2930,0x2930,0x292F,0x2930,0x2930,0x2930,0x2130,0x2930,0x2930,0x2930,0x290F,0x292F,0x292F,0x210F,0x292F,0x290F,0x290F,0x28EE,0x28CE,0x202A,0xA3B6,0xD4DA,0xDC99,0xDC98,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC57,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC57,0xDC58,0xDC99,0xDC99,0xCC59,0x48EC,0x38ED,0x28AD,0x28CE,0x20EE,0x290F,0x290F,0x290F,0x2930,0x2930,0x290F,0x2910,0x2930,0x2110,0x2110,0x2910,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x210F,0x292F,0x210F,0x210F,0x290F,0x210F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x210F,0x2910,0x2910,0x210F,0x210F,0x290F,0x2930,0x2930,0x210F,0x2930,0x2930,0x212F,0x2930,0x2930,0x210F,0x2950,0x2930,0x212F,0x212F,0x210F,0x212F,0x2950,0x2150,0x2130,0x2151,0x1931,0x1932,0x1133,0x0934,0x19B7,0x19F8,0x19D8,0x19D7,0x1155,0x0913,0x1132,0x1952,0x2151,0x2130,0x2130,0x2130,0x210F,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2930,0x210F,0x2930,0x210F,0x212F,0x210F,0x210F,0x2930,0x2910,0x212F,0x212F,0x2930,0x290F,0x290F,0x2930,0x210F,0x2930,0x290F,0x210F,0x2930,0x2930,0x210F,0x290F,0x2910,0x2910,0x2910,0x210F,0x2910,0x2910,0x2110,0x2930,0x2110,0x2110,0x210F,0x2910,0x210F,0x290F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x1911,0x1112,0x19D6,0x1A18,0x19F7,0x11B6,0x0912,0x1111,0x2131,0x2131,0x2130,0x210F,0x2130,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x2130,0x2930,0x2950,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x1930,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x2151,0x2150,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x1930,0x1930,0x1950,0x2150,0x2150,0x192F,0x1950,0x2150,0x192F,0x2150,0x2130,0x212F,0x212F,0x212F,0x2150,0x212F,0x2150,0x212F,0x214F,0x214F,0x212F,0x212F,0x2130,0x2150,0x2130,0x2130,0x2130,0x1930,0x1930,0x1930,0x192F,0x192F,0x192F,0x2150,0x214F,0x212F,0x212F,0x2150,0x194F,0x1950,0x192F,0x2150,0x192F,0x1930,0x1930,0x1930,0x192F,0x1930,0x2130,0x212F,0x212F,0x2130,0x212F,0x2130,0x212F,0x210F,0x2130,0x2130,0x2130,0x1930,0x1930,0x2130,0x1930,0x1930,0x1930,0x2130,0x2130,0x2110,0x2130,0x2130,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2130,0x2130,0x2131,0x2131,0x2131,0x2131,0x2131,0x1911,0x1932,0x1931,0x1931,0x1932,0x1931,0x2131,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x210F,0x2110,0x2910,0x210F,0x210F,0x2110,0x2130,0x2130,0x210F,0x210F,0x2110,0x2910,0x290F,0x290F,0x210F,0x2910,0x210F,0x210F,0x212F,0x212F,0x2130,0x210F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x2130,0x2150,0x1910,0x1910,0x1911,0x1932,0x1132,0x1153,0x1194,0x19D6,0x2217,0x2217,0x1995,0x1153,0x1112,0x1111,0x1131,0x1931,0x1952,0x1952,0x1111,0x1111,0x1132,0x1974,0x21D6,0x21F6,0x21F7,0x21F7,0x21D6,0x21D6,0x21D6,0x21D6,0x19B5,0x21B5,0x1995,0x1995,0x1995,0x1974,0x1994,0x1994,0x1974,0x1994,0x1994,0x1974,0x1974,0x2194,0x1974,0x1994,0x1994,0x1994,0x1994,0x2195,0x1974,0x1974,0x1974,0x1974,
  0x290F,0x290F,0x210F,0x210F,0x292F,0x290F,0x210F,0x2930,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2930,0x210F,0x2110,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2110,0x2130,0x2130,0x2151,0x1931,0x1932,0x1132,0x1133,0x1175,0x0996,0x11D8,0x1219,0x1219,0x1A19,0x11F8,0x11D7,0x1175,0x1153,0x1133,0x1952,0x1932,0x1931,0x1931,0x1911,0x1911,0x1912,0x1932,0x1933,0x1154,0x19B6,0x11B6,0x11D7,0x11B7,0x09B7,0x09B7,0x0996,0x0996,0x0997,0x0997,0x0997,0x09B7,0x09B7,0x0997,0x09B7,0x0997,0x09B7,0x09B7,0x09B7,0x09B7,0x09B7,0x09B7,0x09B7,0x09B7,0x09B7,0x0997,0x09B7,0x09B7,0x09B7,0x0997,0x09B7,0x09B7,0x0997,0x09B7,0x09B7,0x09B7,0x09B7,0x11D8,0x1218,0x1A18,0x11B6,0x1154,0x1133,0x1932,0x1911,0x2131,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x210F,0x290F,0x2910,0x210F,0x2930,0x210F,0x290F,0x290F,0x210F,0x212F,0x210F,0x210F,0x212F,0x2930,0x2930,0x2930,0x2110,0x2110,0x210F,0x2930,0x210F,0x210F,0x2130,0x2130,0x212F,0x210F,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x292F,0x290F,0x210F,0x212F,0x212F,0x2130,0x210F,0x2130,0x212F,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2130,0x212F,0x290F,0x290F,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x2930,0x2930,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x292F,0x212F,0x212F,0x2130,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2930,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2930,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2110,0x212F,0x212F,0x2130,0x210F,0x2930,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2930,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2930,0x290F,0x2910,0x210F,0x290F,0x290F,0x2930,0x210F,0x2930,0x290F,0x210F,0x210F,0x290F,0x210F,0x2110,0x210F,0x210F,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2110,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2150,0x194F,0x194F,0x1950,0x194F,0x192F,0x192F,0x192F,0x192F,0x192F,0x2130,0x192F,0x2150,0x2170,0x1970,0x1170,0x012F,0x01B1,0x2BD9,0x241A,0x243A,0x1C3A,0x241A,0x2398,0x014F,0x00EE,0x112F,0x110F,0x1970,0x1950,0x092F,0x012E,0x2397,0x2419,0x1419,0x0C19,0x03F8,0x0418,0x0418,0x0439,0x03F8,0x03F8,0x1439,0x245A,0x3C7B,0x12B4,0x010F,0x090F,0x1130,0x1930,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2930,0x2930,0x210F,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x290F,0x210F,0x290F,0x292F,0x210F,0x210F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2110,0x2130,0x2151,0x2152,0x1952,0x1111,0x1132,0x1154,0x1995,0x19D6,0x2218,0x2218,0x19B6,0x1975,0x1153,0x1132,0x1911,0x1911,0x2130,0x2130,0x2130,0x2930,0x2930,0x2110,0x2110,0x210F,0x2130,0x2130,0x2950,0x212F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1132,0x1133,0x1154,0x19F7,0x2218,0x2217,0x1133,0x1112,0x1911,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x212F,0x212F,0x210F,0x2930,0x2930,0x2910,0x2910,0x2910,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2930,0x210F,0x2930,0x290F,0x210F,0x210F,0x210F,0x2910,0x290F,0x290F,0x290F,0x2910,0x2910,0x2110,0x2110,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1932,0x1112,0x21B5,0x2A17,0x21D6,0x1974,0x10F1,0x1932,0x2152,0x2131,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x212F,0x2930,0x2110,0x2110,0x2110,0x2930,0x2910,0x292F,0x292F,0x292F,0x292F,0x292F,0x290E,0x28EE,0x288C,0x30AC,0xCCDB,0xDCB9,0xDCB9,0xDC78,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC57,0xDC36,0xDC37,0xDC37,0xDC57,0xE457,0xDC37,0xDC37,0xDC36,0xDC36,0xDC37,0xDC36,0xDC36,0xDC37,0xDC57,0xE457,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC78,0xE4BA,0xE4FB,0x8251,0x282A,0x288C,0x20AD,0x28EE,0x290F,0x292F,0x290F,0x2930,0x2930,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x210F,0x290F,0x2910,0x210F,0x210F,0x2930,0x290F,0x290F,0x2110,0x2110,0x2910,0x2910,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x290F,0x292F,0x2930,0x212F,0x2930,0x210F,0x2930,0x290F,0x212F,0x210F,0x212F,0x2150,0x2150,0x2130,0x1931,0x1931,0x1132,0x1153,0x0954,0x19D7,0x1A18,0x19D8,0x11B7,0x1155,0x0913,0x1112,0x1932,0x2151,0x2131,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2930,0x2930,0x210F,0x210F,0x2930,0x212F,0x210F,0x2930,0x210F,0x290F,0x212F,0x2930,0x290F,0x290F,0x210F,0x210F,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2910,0x2930,0x2110,0x210F,0x210F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x1912,0x1112,0x19D6,0x1A18,0x19F7,0x1195,0x0912,0x1931,0x2151,0x2130,0x18EF,0x210F,0x210F,0x2930,0x2130,0x210F,0x210F,0x210F,0x2110,0x2930,0x2110,0x210F,0x210F,0x210F,0x2110,0x212F,0x2130,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x1910,0x1910,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2150,0x1930,0x1950,0x1950,0x1950,0x194F,0x1950,0x1950,0x1950,0x1950,0x1950,0x1950,0x1950,0x192F,0x194F,0x192F,0x192F,0x192F,0x212F,0x192F,0x212F,0x212F,0x214F,0x2150,0x2150,0x2150,0x2150,0x1930,0x1950,0x1930,0x1950,0x1950,0x1950,0x1950,0x1950,0x1950,0x1950,0x194F,0x192F,0x1950,0x1950,0x1950,0x1950,0x192F,0x1950,0x1950,0x1930,0x1930,0x1930,0x192F,0x192F,0x1950,0x1950,0x1930,0x1930,0x1930,0x2150,0x2150,0x1930,0x1950,0x1930,0x1950,0x1950,0x1930,0x1950,0x1950,0x1930,0x1930,0x1930,0x1930,0x1950,0x1930,0x192F,0x192F,0x192F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x212F,0x210F,0x212F,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2130,0x210F,0x2950,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x1911,0x1911,0x1932,0x1132,0x1132,0x1112,0x1132,0x1112,0x1112,0x1932,0x1931,0x1931,0x2131,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2930,0x210F,0x210F,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x210F,0x2930,0x290F,0x2930,0x2130,0x210F,0x2130,0x2930,0x2130,0x2930,0x2930,0x2130,0x2130,0x2130,0x2930,0x2930,0x212F,0x210F,0x2110,0x2130,0x2130,0x2131,0x1910,0x1911,0x1111,0x1132,0x1153,0x19B5,0x19F6,0x2217,0x21D6,0x1995,0x1153,0x1112,0x1111,0x1111,0x1952,0x1952,0x1931,0x1111,0x1111,0x1133,0x1974,0x21D6,0x21D6,0x21F7,0x21D6,0x1995,0x1154,0x1954,0x1133,0x1133,0x1133,0x1113,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1132,0x1132,0x1132,0x1132,0x1112,0x1112,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1112,0x1912,
  0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x210F,0x2130,0x210F,0x2130,0x212F,0x210F,0x2130,0x2110,0x2110,0x2930,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x292F,0x2130,0x2130,0x2131,0x2131,0x1931,0x1131,0x1132,0x1154,0x1175,0x11B7,0x11D7,0x1A19,0x1219,0x11F9,0x11D8,0x11B7,0x1195,0x1154,0x1153,0x1932,0x1932,0x1911,0x2131,0x1931,0x1911,0x1932,0x1932,0x1933,0x1154,0x1995,0x19D6,0x11D7,0x11D7,0x11D7,0x11B7,0x11B7,0x09B7,0x11B7,0x09B7,0x0997,0x11B7,0x11D8,0x09B7,0x09B7,0x11B8,0x09B7,0x09B7,0x11D8,0x11B8,0x11D8,0x11D8,0x11D8,0x11D8,0x11D8,0x11D8,0x09B7,0x11D8,0x11D8,0x09B7,0x09B7,0x11D8,0x09D7,0x09D7,0x09B7,0x09B7,0x09B7,0x09D7,0x11D8,0x11D8,0x11B7,0x1175,0x1153,0x1132,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2110,0x290F,0x290F,0x210F,0x290F,0x292F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x2930,0x290F,0x210F,0x210F,0x210F,0x2910,0x210F,0x2910,0x2930,0x210F,0x2930,0x290F,0x210F,0x2930,0x2930,0x210F,0x210F,0x2130,0x210F,0x210F,0x2110,0x210F,0x2110,0x2110,0x2130,0x2110,0x2110,0x210F,0x2930,0x2930,0x212F,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x2930,0x210F,0x212F,0x212F,0x210F,0x2130,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x212F,0x292F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x210F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x210F,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x2110,0x210F,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x292F,0x290F,0x290F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x210F,0x2110,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x212F,0x210F,0x2130,0x210F,0x2930,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2930,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x210F,0x2910,0x2910,0x210F,0x290F,0x210F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x290F,0x290F,0x2930,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2150,0x1950,0x194F,0x1150,0x1150,0x1150,0x114F,0x1150,0x112F,0x1950,0x1930,0x1930,0x1950,0x1950,0x1950,0x114F,0x1150,0x012F,0x01B2,0x2BB9,0x241A,0x1C1A,0x243A,0x2419,0x2398,0x014F,0x00CD,0x112F,0x192F,0x1950,0x194F,0x114F,0x010E,0x2B97,0x2C39,0x1C19,0x0C19,0x03F8,0x0418,0x03F8,0x0418,0x0418,0x0C19,0x1419,0x245A,0x3C7B,0x1294,0x00EE,0x090F,0x110F,0x190F,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2930,0x290F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2910,0x2930,0x290F,0x292F,0x2930,0x292F,0x210F,0x292F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x1132,0x1954,0x1995,0x19D6,0x2217,0x2217,0x21D6,0x1975,0x1953,0x1932,0x1911,0x1911,0x2131,0x2130,0x2930,0x2930,0x2110,0x2110,0x210F,0x2130,0x210F,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1112,0x0933,0x19D7,0x2238,0x21F7,0x1153,0x10F2,0x1912,0x2131,0x2131,0x2110,0x2110,0x2130,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2110,0x2910,0x2910,0x2110,0x2910,0x2910,0x290F,0x2930,0x210F,0x290F,0x2930,0x290F,0x290F,0x2930,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2910,0x290F,0x290F,0x210F,0x2910,0x2110,0x2110,0x2930,0x292F,0x210F,0x292F,0x292F,0x210F,0x210F,0x2130,0x2110,0x2110,0x2131,0x2131,0x1932,0x1932,0x1112,0x21B5,0x2A17,0x21D6,0x1974,0x10F2,0x1932,0x2152,0x2131,0x2130,0x2930,0x2130,0x2930,0x2930,0x2930,0x2130,0x2930,0x2130,0x2930,0x2930,0x2910,0x2930,0x290F,0x292F,0x292F,0x292F,0x292F,0x28EE,0x28CD,0x204B,0x6A32,0xD4DB,0xDCDA,0xDC78,0xDC57,0xDC57,0xDC57,0xDC57,0xE457,0xDC36,0xDC36,0xDC37,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xE457,0xE457,0xDC36,0xE457,0xDC37,0xDC57,0xDC57,0xDC57,0xDC37,0xDC57,0xDC57,0xDC57,0xDC37,0xDC58,0xE499,0xE4FB,0xCC9A,0x2809,0x30AC,0x28AD,0x28EE,0x290F,0x2930,0x290F,0x210F,0x2930,0x2930,0x2930,0x2910,0x2110,0x2110,0x2110,0x210F,0x210F,0x292F,0x292F,0x292F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x2930,0x2930,0x290F,0x290F,0x2930,0x290F,0x210F,0x2910,0x210F,0x210F,0x210F,0x2910,0x2910,0x290F,0x210F,0x2930,0x210F,0x210F,0x2110,0x2110,0x210F,0x2930,0x290F,0x290F,0x292F,0x210F,0x290F,0x2930,0x2930,0x292F,0x292F,0x2930,0x2930,0x290F,0x2930,0x290F,0x2110,0x2130,0x2130,0x2130,0x2151,0x1930,0x1951,0x1952,0x1152,0x1133,0x0954,0x19F7,0x19F8,0x11D8,0x11B7,0x1196,0x0913,0x1112,0x1932,0x2151,0x2131,0x2130,0x2130,0x2130,0x212F,0x2130,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x210F,0x2930,0x2930,0x2130,0x2930,0x2930,0x290F,0x290F,0x2930,0x212F,0x212F,0x2930,0x2930,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x290F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2110,0x2131,0x2111,0x1912,0x1113,0x19F7,0x1217,0x11D7,0x1195,0x1112,0x1931,0x2131,0x2110,0x210F,0x210F,0x212F,0x2930,0x2130,0x210F,0x20EF,0x2930,0x2110,0x2130,0x2110,0x210F,0x210F,0x210F,0x2930,0x2930,0x2130,0x2130,0x210F,0x2130,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x1950,0x1950,0x1950,0x112F,0x1950,0x114F,0x1950,0x114F,0x1150,0x1150,0x1150,0x114F,0x1150,0x112F,0x112F,0x112F,0x192F,0x192F,0x192F,0x194F,0x194F,0x194F,0x192F,0x1950,0x1950,0x1950,0x1950,0x1950,0x1950,0x112F,0x1150,0x1150,0x1150,0x1150,0x1950,0x1950,0x1950,0x1950,0x1950,0x1950,0x1950,0x1150,0x1150,0x1150,0x1150,0x1150,0x1150,0x1150,0x1150,0x114F,0x1150,0x1150,0x1150,0x1930,0x1930,0x1950,0x112F,0x1130,0x1950,0x1150,0x1150,0x1150,0x1150,0x1150,0x1150,0x1150,0x1150,0x1150,0x1150,0x1130,0x1130,0x1130,0x112F,0x112F,0x192F,0x192F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x2930,0x212F,0x2130,0x2950,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2150,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2110,0x1911,0x1911,0x1911,0x1112,0x1132,0x1133,0x1174,0x1195,0x1195,0x1195,0x1154,0x1153,0x1133,0x1132,0x1931,0x1931,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x210F,0x2110,0x2130,0x2130,0x2110,0x2930,0x2130,0x2930,0x2130,0x2130,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x1131,0x1152,0x1153,0x1195,0x19F6,0x2217,0x2217,0x1995,0x1153,0x1132,0x1111,0x1911,0x1931,0x1931,0x1931,0x1111,0x1132,0x1132,0x1174,0x19B6,0x21D6,0x21F7,0x21D6,0x1974,0x1154,0x1133,0x1113,0x1113,0x1112,0x1112,0x1112,0x1112,0x10F1,0x1112,0x1112,0x1112,0x1912,0x1932,0x1932,0x1932,0x1911,0x1931,0x1931,0x1911,0x1911,0x1931,0x1911,0x1931,0x1911,0x1932,0x1911,0x1912,0x1912,
  0x2910,0x290F,0x2910,0x20EF,0x210F,0x290F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2110,0x2930,0x2930,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2951,0x2130,0x1931,0x1931,0x1111,0x1132,0x1154,0x1175,0x11B7,0x11D8,0x11F8,0x11F9,0x11D8,0x11D8,0x11B7,0x1195,0x1154,0x1133,0x1932,0x1932,0x2152,0x2132,0x2132,0x1932,0x1912,0x1932,0x1132,0x1133,0x1974,0x19B5,0x19B6,0x19D6,0x1A17,0x19F7,0x1A18,0x1A18,0x1A18,0x19F8,0x1A18,0x19F8,0x19F8,0x1A18,0x19F8,0x19F8,0x1A18,0x19F8,0x19F8,0x1A18,0x1A18,0x19F8,0x1A18,0x1A18,0x1A18,0x1A18,0x19F8,0x1A18,0x11F7,0x1A18,0x11F8,0x11F8,0x11F8,0x11F8,0x11F8,0x09D8,0x11F8,0x11D8,0x11D8,0x11F8,0x11B7,0x1175,0x1174,0x1132,0x1952,0x1931,0x2151,0x2151,0x2130,0x2150,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x212F,0x210F,0x2930,0x290F,0x2930,0x2930,0x290F,0x2910,0x2910,0x210F,0x2110,0x2130,0x2130,0x210F,0x210F,0x290F,0x2930,0x210F,0x210F,0x2910,0x2910,0x210F,0x210F,0x2110,0x2110,0x2910,0x210F,0x2930,0x2910,0x2910,0x2930,0x210F,0x2110,0x2110,0x2930,0x2110,0x2110,0x210F,0x2110,0x2110,0x2130,0x2930,0x2930,0x2110,0x210F,0x2930,0x2930,0x2110,0x210F,0x2110,0x2930,0x2110,0x2110,0x2930,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x210F,0x212F,0x2930,0x2130,0x2930,0x210F,0x2930,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x212F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x290F,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2930,0x210F,0x2930,0x210F,0x290F,0x212F,0x2930,0x210F,0x210F,0x212F,0x292F,0x212F,0x210F,0x212F,0x212F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2130,0x210F,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2930,0x212F,0x212F,0x210F,0x212F,0x2110,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x292F,0x210F,0x210F,0x210F,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x2110,0x2130,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2150,0x1950,0x114F,0x114F,0x1150,0x0970,0x0970,0x094F,0x094F,0x0950,0x1150,0x1150,0x1130,0x1930,0x192F,0x112F,0x112F,0x1150,0x012F,0x01D2,0x2BD9,0x2C3A,0x1BF9,0x1BF9,0x1BF9,0x23B8,0x016F,0x00EE,0x114F,0x190F,0x2150,0x1950,0x194F,0x012F,0x3377,0x449B,0x2C5A,0x1C5A,0x1439,0x0C18,0x0C39,0x0C19,0x0C39,0x1439,0x1C39,0x2C5A,0x449B,0x1AB5,0x010E,0x112F,0x1930,0x2130,0x2130,0x2930,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2910,0x2930,0x212F,0x212F,0x2930,0x2930,0x2930,0x292F,0x2930,0x2930,0x290F,0x210F,0x2110,0x2930,0x2110,0x2110,0x210F,0x2910,0x2910,0x290F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2151,0x1932,0x1932,0x1133,0x1954,0x1995,0x21F7,0x2A38,0x21F7,0x19B6,0x1995,0x1153,0x1933,0x1911,0x2131,0x2131,0x2951,0x2930,0x2110,0x2930,0x2110,0x2110,0x210F,0x212F,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2131,0x1932,0x1112,0x0913,0x19D7,0x2A38,0x2217,0x1153,0x10F2,0x1911,0x2131,0x2131,0x2130,0x2130,0x2130,0x2930,0x2130,0x2930,0x210F,0x2930,0x210F,0x2110,0x2910,0x2910,0x2910,0x290F,0x2910,0x290F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x292F,0x210F,0x210F,0x292F,0x212F,0x210F,0x2110,0x2130,0x2110,0x2130,0x2131,0x2132,0x1932,0x1112,0x21D5,0x2A17,0x21D6,0x1974,0x1112,0x1912,0x2152,0x2131,0x2130,0x2130,0x2930,0x2930,0x2930,0x2130,0x2930,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x292F,0x292F,0x292F,0x290F,0x290E,0x30CD,0x306B,0xABF8,0xD4BA,0xDC98,0xDC78,0xDC77,0xDC57,0xE457,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xDC36,0xE436,0xE457,0xDC37,0xDC57,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xE457,0xDC57,0xDC37,0xDC78,0xE4DA,0xED7D,0x7A52,0x306B,0x30AD,0x28CE,0x28EF,0x290F,0x290F,0x292F,0x2930,0x2930,0x2910,0x2930,0x210F,0x2110,0x2910,0x2910,0x2910,0x2930,0x290F,0x292F,0x212F,0x292F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x2930,0x2930,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2930,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x2930,0x290F,0x210F,0x2910,0x2910,0x290F,0x290F,0x212F,0x212F,0x292F,0x2930,0x210F,0x210F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2930,0x210F,0x2110,0x2110,0x2110,0x2130,0x2131,0x1931,0x1931,0x1952,0x1173,0x0974,0x0995,0x1A18,0x11F8,0x11B7,0x11B7,0x11B6,0x1154,0x1133,0x1952,0x2152,0x2131,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x212F,0x2130,0x212F,0x212F,0x2930,0x290F,0x210F,0x2110,0x210F,0x2110,0x210F,0x290F,0x2910,0x2910,0x212F,0x212F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x210F,0x2910,0x2910,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2930,0x2110,0x2131,0x2131,0x1912,0x1133,0x19F7,0x1A18,0x19F7,0x1175,0x1111,0x1931,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2930,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x212F,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x2130,0x1950,0x112F,0x092F,0x092F,0x092F,0x092F,0x092F,0x092F,0x092F,0x092F,0x092F,0x094F,0x094F,0x092F,0x092F,0x092F,0x092F,0x112F,0x114F,0x112F,0x192F,0x194F,0x1950,0x1950,0x1950,0x112F,0x112F,0x092F,0x092F,0x092F,0x092F,0x092F,0x092F,0x092F,0x092F,0x1150,0x1150,0x0930,0x1150,0x1150,0x1150,0x0950,0x0950,0x1150,0x0950,0x092F,0x092F,0x094F,0x092F,0x092F,0x092F,0x092F,0x092F,0x092F,0x090F,0x090F,0x090F,0x010F,0x012F,0x012F,0x012F,0x012F,0x012F,0x012F,0x012F,0x012F,0x012F,0x092F,0x092F,0x092F,0x092F,0x094F,0x092F,0x092F,0x090E,0x090F,0x110F,0x110F,0x190F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x212F,0x2930,0x2930,0x212F,0x2130,0x2110,0x2130,0x2131,0x1931,0x1932,0x1933,0x1153,0x1175,0x19F7,0x1A18,0x2259,0x2279,0x1A59,0x1A38,0x1A18,0x19D6,0x1194,0x1153,0x1132,0x1931,0x1911,0x2131,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1952,0x1973,0x1174,0x1195,0x19D6,0x19D6,0x21F6,0x1995,0x1153,0x1112,0x1111,0x1111,0x1931,0x2152,0x1931,0x1111,0x1132,0x1133,0x1174,0x19D6,0x21D6,0x21F7,0x19D6,0x1974,0x1133,0x1112,0x1112,0x1112,0x1112,0x1912,0x1932,0x1932,0x1932,0x1911,0x2152,0x1931,0x2152,0x1952,0x1911,0x1911,0x2131,0x1931,0x1931,0x1910,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x2131,0x2111,0x2111,0x2111,
  0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x210F,0x210F,0x212F,0x2930,0x212F,0x212F,0x2130,0x2130,0x210F,0x2110,0x2110,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x292F,0x292F,0x290F,0x290F,0x210F,0x292F,0x2130,0x2130,0x2130,0x2131,0x1911,0x1932,0x1132,0x1154,0x1175,0x1196,0x11D8,0x11D8,0x11F9,0x11F9,0x11D8,0x11B7,0x1196,0x1154,0x1133,0x1932,0x1932,0x2152,0x2152,0x1931,0x1932,0x1932,0x1911,0x1932,0x1932,0x1153,0x1173,0x1174,0x11B5,0x11B5,0x19B5,0x1195,0x19B6,0x19B6,0x19B6,0x19B6,0x19B6,0x11B6,0x19B6,0x19B6,0x19D7,0x19B6,0x19B6,0x11B6,0x11B6,0x11B6,0x19B6,0x11B6,0x19D6,0x11B6,0x19D6,0x19D6,0x11D6,0x11D6,0x19D7,0x19D7,0x19F7,0x11F7,0x19F8,0x1A19,0x1218,0x11F9,0x11F9,0x11F8,0x11D7,0x11B7,0x0954,0x1154,0x1153,0x1932,0x1951,0x2151,0x2150,0x2150,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2910,0x2110,0x2110,0x210F,0x2110,0x290F,0x210F,0x290F,0x290F,0x2910,0x210F,0x2930,0x2910,0x2910,0x210F,0x2110,0x2110,0x2910,0x2110,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2930,0x2110,0x2930,0x2930,0x2110,0x2930,0x2930,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x212F,0x2930,0x210F,0x2930,0x2930,0x212F,0x2930,0x212F,0x210F,0x290F,0x2930,0x210F,0x210F,0x212F,0x212F,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x2930,0x212F,0x210F,0x292F,0x210F,0x212F,0x2930,0x290F,0x290F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x210F,0x2930,0x290F,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2930,0x212F,0x210F,0x212F,0x2930,0x212F,0x2110,0x2130,0x212F,0x212F,0x290F,0x290F,0x210F,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x290F,0x290F,0x212F,0x2930,0x210F,0x212F,0x212F,0x212F,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2110,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x2110,0x2110,0x2910,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x2110,0x210F,0x2110,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x210F,0x2110,0x2110,0x2110,0x2130,0x212F,0x2930,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x2150,0x1950,0x1950,0x094F,0x094F,0x016F,0x014F,0x01B0,0x0A12,0x0A12,0x0190,0x012F,0x012F,0x1150,0x1130,0x1150,0x112F,0x1150,0x0950,0x0130,0x01B1,0x2BD9,0x2419,0x1C19,0x243A,0x23F9,0x2BB8,0x016F,0x090E,0x194F,0x10EE,0x194F,0x1950,0x1950,0x094F,0x1A74,0x3378,0x2BD8,0x2419,0x1C5A,0x0BF8,0x0C19,0x0C19,0x1419,0x1C5A,0x2C3A,0x3419,0x3BD9,0x1A74,0x094F,0x1130,0x1930,0x2130,0x2130,0x2930,0x210F,0x210F,0x212F,0x212F,0x290F,0x2930,0x210F,0x2930,0x2130,0x212F,0x2930,0x212F,0x212F,0x2930,0x290F,0x2930,0x210F,0x2930,0x2930,0x2930,0x2130,0x2110,0x2110,0x2110,0x2930,0x2910,0x292F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x210F,0x2110,0x2130,0x2131,0x2151,0x2131,0x1932,0x1933,0x1154,0x1995,0x21F7,0x2217,0x21F7,0x19B6,0x1995,0x1153,0x1132,0x1911,0x2131,0x2131,0x2110,0x2930,0x2110,0x2930,0x2130,0x210F,0x210F,0x2150,0x2130,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1112,0x08F3,0x19D6,0x2A38,0x21F7,0x1154,0x1112,0x1911,0x2131,0x2111,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2930,0x210F,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x2910,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2930,0x290F,0x290F,0x2930,0x210F,0x2930,0x2910,0x210F,0x2110,0x2910,0x2110,0x2930,0x2110,0x2910,0x290F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2110,0x2110,0x2130,0x2131,0x2132,0x1912,0x1112,0x21B5,0x21F6,0x21D6,0x1974,0x1112,0x1932,0x2151,0x2131,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x292F,0x292F,0x292F,0x292F,0x28EE,0x28AC,0x40AC,0xCC7A,0xD499,0xDC99,0xDC78,0xDC37,0xE457,0xDC57,0xDC57,0xDC36,0xDC57,0xDC56,0xDC36,0xE457,0xDC57,0xDC57,0xDC37,0xDC57,0xDC37,0xE457,0xDC36,0xDC36,0xDC36,0xDC36,0xE457,0xDC37,0xDC37,0xDC57,0xDC57,0xE457,0xE457,0xE457,0xDC57,0xDC57,0xDC57,0xDC58,0xDC99,0xE4FB,0xCCBB,0x61AF,0x286B,0x30CE,0x28EE,0x290F,0x290F,0x292F,0x2930,0x290F,0x2910,0x2930,0x2910,0x2930,0x2910,0x2910,0x210F,0x2910,0x210F,0x290F,0x210F,0x212F,0x292F,0x2930,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x212F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2930,0x210F,0x290F,0x2910,0x2910,0x290F,0x290F,0x212F,0x212F,0x210F,0x210F,0x2930,0x2930,0x212F,0x212F,0x2110,0x2930,0x2910,0x2930,0x2930,0x2130,0x2130,0x2130,0x2131,0x2131,0x1931,0x1952,0x1153,0x1174,0x1175,0x11B6,0x1A18,0x11F8,0x11D8,0x11D7,0x11D7,0x1175,0x1153,0x1132,0x2152,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x2930,0x290F,0x2110,0x2930,0x2110,0x2110,0x210F,0x2930,0x2910,0x210F,0x212F,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x210F,0x2910,0x210F,0x2110,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2111,0x1912,0x1133,0x19F7,0x19F7,0x11D7,0x1174,0x1111,0x1931,0x2110,0x2130,0x212F,0x212F,0x2130,0x210F,0x210F,0x210F,0x2110,0x2930,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x210F,0x210F,0x2130,0x2930,0x2930,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2150,0x1930,0x110F,0x00CE,0x010E,0x012F,0x012F,0x010E,0x010E,0x010E,0x010E,0x012E,0x014F,0x016F,0x012E,0x012E,0x012E,0x012E,0x010E,0x012E,0x094F,0x114F,0x112F,0x1950,0x1950,0x1950,0x1970,0x092F,0x010E,0x010E,0x012F,0x014F,0x014F,0x016F,0x012F,0x012E,0x010E,0x010E,0x014F,0x0950,0x0950,0x0950,0x0150,0x014F,0x012F,0x010E,0x012F,0x012F,0x014F,0x014F,0x014F,0x016F,0x016F,0x0190,0x11B1,0x094F,0x010F,0x010F,0x012F,0x014F,0x016F,0x0190,0x0190,0x0190,0x0190,0x0190,0x0170,0x0190,0x016F,0x016F,0x016F,0x016F,0x014F,0x016F,0x016F,0x016F,0x012E,0x012E,0x012F,0x112F,0x110F,0x192F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2150,0x2150,0x2150,0x1930,0x192F,0x192F,0x190F,0x190F,0x190F,0x190F,0x192F,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x210F,0x2130,0x2110,0x2131,0x1931,0x1932,0x1953,0x1974,0x19B6,0x11F7,0x1218,0x1218,0x1219,0x0A19,0x1219,0x09F9,0x1218,0x11F8,0x11F7,0x19F6,0x1994,0x1952,0x1932,0x1931,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x1910,0x1910,0x1930,0x1931,0x1931,0x1931,0x1931,0x1952,0x1153,0x1174,0x1195,0x19F6,0x19D6,0x19D6,0x1995,0x1133,0x1132,0x1112,0x1931,0x1911,0x1932,0x1931,0x1111,0x1132,0x1133,0x1174,0x19D6,0x21F7,0x21D6,0x21D6,0x1974,0x1133,0x1112,0x1111,0x1912,0x1932,0x1932,0x1932,0x1931,0x1911,0x1931,0x1931,0x2131,0x2131,0x2151,0x2131,0x1931,0x1910,0x2130,0x2130,0x2110,0x1910,0x2110,0x2130,0x2110,0x2110,0x2111,0x2111,0x2111,0x2110,0x2111,0x2111,
  0x2910,0x2910,0x2910,0x2910,0x2930,0x290F,0x2910,0x210F,0x212F,0x212F,0x210F,0x2130,0x212F,0x210F,0x2130,0x2110,0x2930,0x2910,0x2930,0x2910,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x20EE,0x20EE,0x20EF,0x210F,0x2130,0x2131,0x2131,0x1931,0x1932,0x1132,0x1153,0x1195,0x11B7,0x11D8,0x11F8,0x11F9,0x11F8,0x11F8,0x11D7,0x1196,0x1154,0x1113,0x1112,0x1932,0x1931,0x1931,0x2131,0x2131,0x1931,0x1911,0x1932,0x1952,0x1952,0x1952,0x1152,0x1132,0x1132,0x1132,0x1113,0x1113,0x0913,0x1113,0x1113,0x0913,0x1113,0x0913,0x0913,0x1133,0x1113,0x0913,0x0913,0x0913,0x1133,0x1133,0x0933,0x0933,0x0913,0x0933,0x0913,0x0933,0x1134,0x0933,0x0933,0x0954,0x0934,0x0955,0x11B7,0x11D8,0x11F9,0x1219,0x1219,0x11F8,0x11B6,0x0954,0x0912,0x1112,0x1111,0x1931,0x2151,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2910,0x2110,0x2110,0x2930,0x2910,0x2930,0x2930,0x2930,0x2910,0x2110,0x2130,0x2110,0x2930,0x2910,0x2110,0x2110,0x2930,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2110,0x2110,0x2130,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x290F,0x2910,0x2910,0x210F,0x210F,0x210F,0x2910,0x290F,0x210F,0x210F,0x2910,0x2110,0x2130,0x2130,0x210F,0x212F,0x2130,0x212F,0x212F,0x2130,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x210F,0x290F,0x290F,0x210F,0x210F,0x290F,0x210F,0x2130,0x2130,0x2930,0x2930,0x2930,0x290F,0x2930,0x290F,0x290F,0x210F,0x2910,0x2110,0x292F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x210F,0x210F,0x2930,0x2930,0x2110,0x2130,0x212F,0x212F,0x290F,0x290F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x290F,0x210F,0x2110,0x2130,0x212F,0x212F,0x292F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x210F,0x212F,0x210F,0x210F,0x290F,0x290F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2110,0x2930,0x2110,0x2130,0x212F,0x210F,0x210F,0x212F,0x2130,0x212F,0x2930,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2130,0x192F,0x112F,0x092F,0x014F,0x016F,0x0A52,0x2336,0x3C3A,0x3C5A,0x447B,0x445A,0x3BF9,0x1A94,0x0991,0x0970,0x1150,0x1150,0x092F,0x0970,0x0130,0x01F2,0x2BD9,0x2419,0x2419,0x1C19,0x23F9,0x2377,0x014F,0x00EE,0x192F,0x192F,0x2150,0x1950,0x192F,0x112F,0x0950,0x012F,0x012F,0x01D1,0x23F9,0x1419,0x1419,0x0BF8,0x13F8,0x2419,0x12D5,0x014F,0x012E,0x010E,0x1150,0x1950,0x2150,0x2130,0x210F,0x290F,0x210F,0x210F,0x212F,0x212F,0x292F,0x290F,0x292F,0x210F,0x292F,0x2930,0x210F,0x290F,0x290F,0x210F,0x290F,0x2930,0x212F,0x210F,0x212F,0x292F,0x2930,0x2130,0x2930,0x2110,0x2930,0x210F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x210F,0x292F,0x212F,0x2130,0x2130,0x2131,0x2111,0x1931,0x1932,0x1933,0x1133,0x1975,0x21D6,0x2237,0x19F6,0x19B6,0x1174,0x1953,0x1112,0x1911,0x18F0,0x2110,0x2931,0x2930,0x2950,0x2930,0x2130,0x210F,0x212F,0x2130,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1932,0x1113,0x21D6,0x2A38,0x21D6,0x1133,0x1132,0x1932,0x1931,0x1910,0x2110,0x2110,0x2130,0x2130,0x2930,0x2930,0x212F,0x210F,0x290F,0x2930,0x290F,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x210F,0x2910,0x290F,0x290F,0x290F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2930,0x290F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2131,0x1932,0x1912,0x1112,0x21D5,0x2217,0x21D6,0x1974,0x1112,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x2930,0x2930,0x2130,0x2130,0x2930,0x2930,0x2910,0x2910,0x2930,0x292F,0x292F,0x292F,0x290F,0x290F,0x28CD,0x204B,0x69F0,0xDCFB,0xDCB9,0xDC98,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC37,0xDC36,0xDC36,0xE457,0xDC37,0xDC57,0xDC37,0xDC37,0xDC57,0xDC37,0xDC57,0xDC57,0xDC56,0xDC36,0xE457,0xE437,0xDC37,0xDC36,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC37,0xDC57,0xDC58,0xDC78,0xD479,0xDCFB,0xCCFC,0x40CD,0x30AD,0x28EE,0x290E,0x290F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x210F,0x2930,0x292F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2910,0x2910,0x290F,0x290F,0x210F,0x290F,0x210F,0x292F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x2930,0x2910,0x2910,0x290F,0x290F,0x210F,0x2910,0x290F,0x2930,0x290F,0x210F,0x212F,0x210F,0x2930,0x2930,0x2930,0x212F,0x210F,0x2930,0x2910,0x2910,0x2930,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1132,0x1174,0x1195,0x1196,0x11B7,0x1A18,0x11F8,0x11D8,0x11D8,0x19F8,0x11D7,0x0954,0x1133,0x1952,0x1952,0x2151,0x2131,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x210F,0x210F,0x2930,0x210F,0x210F,0x290F,0x210F,0x2910,0x2910,0x2930,0x2930,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2930,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2111,0x1932,0x1133,0x19F7,0x11F7,0x11F7,0x1174,0x1132,0x2151,0x2110,0x210F,0x210F,0x2150,0x2950,0x2130,0x210F,0x210F,0x210F,0x2930,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x292F,0x20EF,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x110F,0x00CD,0x2AF5,0x4419,0x33D9,0x3BF9,0x445B,0x4C7B,0x4C9B,0x4C7B,0x4CBC,0x4CDC,0x4CBB,0x4C9B,0x4C9B,0x445A,0x445A,0x4C5A,0x43F9,0x3B57,0x0970,0x1150,0x1150,0x1150,0x1950,0x1170,0x0950,0x4378,0x43B8,0x3BD8,0x441A,0x443A,0x445B,0x3C3A,0x3BF9,0x33B8,0x3BF9,0x09F2,0x012F,0x0130,0x0150,0x0191,0x0190,0x1AD5,0x3C19,0x3C19,0x33F9,0x3C19,0x445A,0x445A,0x443A,0x4C7B,0x5C9C,0x3357,0x010F,0x00EE,0x3B57,0x5CBC,0x443A,0x445A,0x447B,0x447B,0x447B,0x3C5A,0x449B,0x44BB,0x44BB,0x449B,0x4CBC,0x4CBC,0x449B,0x449B,0x4CBB,0x449A,0x447A,0x445A,0x4C7B,0x43D9,0x012F,0x112F,0x1930,0x1930,0x2150,0x2130,0x2130,0x2130,0x2150,0x2150,0x1950,0x1950,0x112F,0x112F,0x112F,0x110F,0x110F,0x10EF,0x08EF,0x10EF,0x110F,0x110F,0x1910,0x2110,0x2130,0x2930,0x2930,0x2930,0x2110,0x2130,0x2130,0x2131,0x2152,0x1952,0x1953,0x1175,0x11D7,0x11D8,0x09D8,0x09F9,0x01D9,0x01D9,0x01D9,0x01D9,0x09F9,0x09D8,0x09F8,0x11D7,0x1195,0x1154,0x1132,0x1932,0x1932,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x1911,0x1931,0x1931,0x1910,0x2131,0x2151,0x1911,0x1911,0x1931,0x1931,0x1952,0x1973,0x1952,0x1132,0x1153,0x1195,0x19D6,0x19D6,0x21F7,0x1995,0x0933,0x1112,0x1132,0x1952,0x1932,0x1932,0x1911,0x1111,0x1132,0x1153,0x1174,0x19D6,0x19F6,0x19D6,0x21F6,0x1994,0x1132,0x1112,0x1932,0x1931,0x2132,0x1911,0x2131,0x1931,0x2131,0x2131,0x2110,0x1910,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x20F0,
  0x2910,0x2910,0x2910,0x210F,0x210F,0x2910,0x2910,0x2910,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2910,0x2110,0x210F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x20EF,0x210F,0x210F,0x2130,0x2950,0x2151,0x2131,0x1931,0x1931,0x1132,0x1154,0x1175,0x11B6,0x11D7,0x11F8,0x11F9,0x11F9,0x11D8,0x19D7,0x1996,0x1154,0x1113,0x1112,0x1912,0x1931,0x2131,0x2151,0x2131,0x2131,0x1931,0x1931,0x1931,0x1931,0x1111,0x1131,0x1112,0x1932,0x1932,0x1932,0x1932,0x1112,0x1912,0x1112,0x1112,0x1112,0x1112,0x1112,0x1912,0x1912,0x1932,0x1932,0x1112,0x1112,0x1933,0x1132,0x1132,0x1112,0x1132,0x1112,0x1112,0x1112,0x1133,0x1112,0x1133,0x0933,0x0934,0x1196,0x11D8,0x1A19,0x1218,0x1218,0x11F7,0x0996,0x0954,0x0933,0x1111,0x1111,0x1931,0x2131,0x2150,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2110,0x2910,0x2910,0x2930,0x2910,0x210F,0x2930,0x2930,0x2910,0x210F,0x2130,0x2110,0x2930,0x2110,0x2110,0x2910,0x2110,0x2910,0x2910,0x2110,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x210F,0x2110,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x2910,0x290F,0x2910,0x2910,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x2110,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2930,0x210F,0x210F,0x2930,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x290F,0x2930,0x290F,0x2910,0x2910,0x2910,0x2910,0x2130,0x2130,0x2130,0x2110,0x2910,0x2910,0x2910,0x210F,0x210F,0x290F,0x2910,0x2930,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2930,0x212F,0x212F,0x2110,0x2110,0x212F,0x210F,0x210F,0x210F,0x212F,0x2930,0x212F,0x212F,0x212F,0x210F,0x210F,0x2930,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x210F,0x212F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x2910,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2910,0x210F,0x290F,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2930,0x2110,0x2930,0x2930,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2930,0x2910,0x2930,0x2910,0x2130,0x210F,0x210F,0x2130,0x212F,0x212F,0x2130,0x2150,0x212F,0x1950,0x112F,0x094F,0x0170,0x3377,0x3C3A,0x2C19,0x2C3A,0x2419,0x2C39,0x2C19,0x343A,0x3C3A,0x3377,0x09B1,0x0950,0x1150,0x0950,0x0950,0x0150,0x01B1,0x2BD9,0x2C1A,0x2419,0x2419,0x241A,0x2378,0x012F,0x00EE,0x112F,0x192F,0x192F,0x192F,0x1950,0x1950,0x1150,0x092F,0x012F,0x0190,0x23F9,0x1C19,0x1419,0x13F8,0x1BF9,0x347B,0x0212,0x010E,0x010E,0x092F,0x1950,0x1950,0x2130,0x2130,0x210F,0x290F,0x290F,0x290F,0x210F,0x212F,0x292F,0x292F,0x292F,0x290F,0x292F,0x212F,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x2930,0x212F,0x292F,0x292F,0x2130,0x2930,0x2930,0x2930,0x2110,0x2930,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x1153,0x1195,0x21F7,0x21F7,0x19D6,0x19D6,0x1174,0x1953,0x1912,0x1911,0x2111,0x2131,0x2931,0x2130,0x2130,0x2110,0x212F,0x212F,0x2150,0x2130,0x2130,0x2130,0x2110,0x2130,0x1911,0x1932,0x1133,0x19B5,0x2A17,0x21F7,0x1154,0x1132,0x1932,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2930,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2910,0x290F,0x210F,0x290F,0x290F,0x210F,0x2930,0x290F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1932,0x1112,0x21B5,0x21F6,0x21D6,0x1974,0x1112,0x1911,0x2131,0x2131,0x2131,0x2130,0x2130,0x2930,0x2930,0x2930,0x2130,0x2130,0x2930,0x2930,0x2910,0x2930,0x2910,0x290F,0x292F,0x290F,0x290F,0x28EE,0x28CD,0x200A,0xA396,0xDCDA,0xDC99,0xDC98,0xDC78,0xDC57,0xDC57,0xDC57,0xDC57,0xE457,0xE457,0xE457,0xDC36,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC36,0xE457,0xDC36,0xDC36,0xDC37,0xDC57,0xDC37,0xE457,0xDC37,0xDC37,0xDC57,0xDC37,0xDC57,0xDC57,0xDC58,0xDC78,0xDC79,0xDCBA,0xFE1F,0x6A11,0x308C,0x28CD,0x28EE,0x290F,0x290F,0x290F,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2110,0x2930,0x2930,0x290F,0x2930,0x210F,0x292F,0x292F,0x210F,0x2930,0x2110,0x2910,0x290F,0x2930,0x290F,0x290F,0x290F,0x292F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2910,0x210F,0x210F,0x2930,0x2930,0x210F,0x290F,0x210F,0x290F,0x2930,0x2930,0x210F,0x210F,0x2930,0x210F,0x210F,0x2930,0x2910,0x2910,0x2930,0x2130,0x2130,0x2130,0x2110,0x1931,0x1132,0x1153,0x0974,0x11B6,0x11B7,0x11B7,0x11F8,0x11F8,0x11F8,0x11D8,0x1A18,0x19F8,0x0975,0x0934,0x1133,0x1952,0x1931,0x2111,0x2130,0x2110,0x2130,0x2930,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2930,0x2930,0x212F,0x212F,0x212F,0x210F,0x2930,0x290F,0x290F,0x2930,0x212F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2130,0x2130,0x210F,0x2110,0x212F,0x212F,0x210F,0x2110,0x210F,0x210F,0x210F,0x2110,0x2110,0x2111,0x1932,0x1113,0x19D6,0x1A18,0x11D6,0x11B5,0x1132,0x1931,0x2130,0x210F,0x212F,0x2150,0x2950,0x2130,0x210F,0x2930,0x2110,0x2130,0x2950,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x292F,0x292F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2910,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x212F,0x192F,0x110F,0x00CD,0x549B,0x54FD,0x345A,0x2C3A,0x2C19,0x2419,0x2419,0x1BD8,0x23F8,0x1BF8,0x23F8,0x23D8,0x23F8,0x2BF8,0x3419,0x3419,0x3C39,0x43D8,0x014F,0x0950,0x1150,0x1150,0x1170,0x1170,0x012F,0x4BD9,0x64FD,0x4C7B,0x3419,0x23F8,0x2C19,0x2C19,0x3C9B,0x3C9B,0x3C7A,0x2356,0x0170,0x0150,0x0170,0x0191,0x0A94,0x449B,0x347A,0x2C39,0x2C39,0x23F9,0x2C19,0x2BF8,0x3439,0x3C5A,0x4C5B,0x0A12,0x010F,0x012F,0x4C3A,0x443A,0x33F9,0x2C19,0x2419,0x1BD8,0x2419,0x1BF8,0x2439,0x2419,0x2419,0x1C18,0x2419,0x1C18,0x1C18,0x1BF8,0x23F8,0x23F8,0x2C39,0x3459,0x3C5A,0x4419,0x012F,0x112F,0x192F,0x1930,0x192F,0x2130,0x2150,0x2150,0x1950,0x1950,0x1150,0x0950,0x014F,0x012E,0x010E,0x010E,0x00EE,0x00EE,0x00EE,0x00CE,0x00CE,0x00EF,0x1110,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x2132,0x1953,0x1154,0x1196,0x11D7,0x09F8,0x09D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x01D9,0x09D9,0x09D8,0x09B7,0x0996,0x1175,0x1133,0x1133,0x1132,0x1932,0x1932,0x1932,0x1911,0x1931,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1911,0x1932,0x1911,0x1911,0x1911,0x1911,0x2131,0x1911,0x1911,0x1931,0x1932,0x1911,0x1911,0x1911,0x1931,0x1932,0x1952,0x1932,0x1932,0x1932,0x1132,0x1952,0x1153,0x1132,0x0933,0x1195,0x19B6,0x19D6,0x19D6,0x1995,0x1154,0x1112,0x1132,0x1932,0x1932,0x1912,0x1932,0x1912,0x1112,0x1153,0x1174,0x19B6,0x19F6,0x21F7,0x21F6,0x1995,0x1133,0x1132,0x1931,0x1931,0x1931,0x2131,0x2131,0x2131,0x2131,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x20F0,
  0x2910,0x2110,0x2910,0x2930,0x210F,0x210F,0x2910,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2910,0x2910,0x2910,0x210F,0x290F,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x292F,0x212F,0x292F,0x290F,0x292F,0x212F,0x2130,0x2130,0x2950,0x2151,0x2131,0x1931,0x1952,0x1132,0x1133,0x1175,0x1196,0x11D7,0x1A19,0x11F9,0x19F9,0x11D8,0x11B7,0x1176,0x1154,0x1133,0x1112,0x1911,0x1911,0x2131,0x2111,0x2131,0x1910,0x2131,0x1930,0x1931,0x1931,0x1911,0x1911,0x1931,0x1931,0x1931,0x1932,0x1911,0x1932,0x1932,0x1911,0x1912,0x1912,0x1911,0x2132,0x1911,0x1931,0x1932,0x1911,0x1911,0x1931,0x1931,0x1932,0x1931,0x1931,0x1911,0x1911,0x1932,0x1932,0x1112,0x1932,0x1153,0x0933,0x0954,0x1196,0x11D7,0x1A18,0x1A19,0x1218,0x11D7,0x11B6,0x0954,0x1133,0x1112,0x1111,0x1931,0x2131,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2130,0x212F,0x2130,0x2130,0x2930,0x2110,0x2110,0x2110,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x2910,0x290F,0x290F,0x2910,0x2910,0x210F,0x210F,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x210F,0x2910,0x2930,0x2910,0x2930,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2910,0x2110,0x2910,0x2910,0x2110,0x2130,0x2110,0x2110,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2130,0x2130,0x210F,0x2130,0x210F,0x210F,0x2130,0x212F,0x2930,0x2930,0x2930,0x210F,0x290F,0x290F,0x292F,0x290F,0x290F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x2930,0x2910,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x2110,0x2110,0x210F,0x2910,0x210F,0x212F,0x2930,0x2930,0x212F,0x2930,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x210F,0x210F,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x212F,0x210F,0x2930,0x290F,0x2930,0x210F,0x210F,0x2110,0x212F,0x212F,0x210F,0x210F,0x2930,0x212F,0x2930,0x2110,0x210F,0x210F,0x212F,0x2930,0x210F,0x290F,0x290F,0x2930,0x2930,0x212F,0x290F,0x2930,0x290F,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x212F,0x292F,0x212F,0x292F,0x212F,0x290F,0x210F,0x292F,0x212F,0x290F,0x290F,0x292F,0x210F,0x290F,0x290F,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2910,0x2910,0x2930,0x2130,0x2930,0x212F,0x212F,0x2930,0x2930,0x2930,0x210F,0x2910,0x2910,0x2930,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x192F,0x112F,0x092F,0x0150,0x3BB9,0x33F9,0x23D8,0x23F9,0x1BD8,0x1BD8,0x1BD8,0x1BD8,0x1BD8,0x23D8,0x33D9,0x2B57,0x0170,0x014F,0x0950,0x0950,0x0150,0x01D2,0x2BD9,0x23F9,0x1BD9,0x1BF9,0x2C1A,0x2B98,0x014F,0x090E,0x192F,0x190F,0x214F,0x214F,0x192F,0x1950,0x112F,0x112F,0x010F,0x01B0,0x2BF9,0x1C19,0x13F8,0x13F9,0x1BF9,0x345B,0x0A12,0x012F,0x0970,0x1170,0x1950,0x1930,0x2130,0x210F,0x212F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2910,0x2910,0x2930,0x290F,0x2930,0x210F,0x2930,0x2930,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2110,0x210F,0x210F,0x2130,0x212F,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x1153,0x1174,0x19D6,0x21F7,0x2217,0x19D6,0x1974,0x1133,0x1932,0x1911,0x2131,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x1995,0x2A38,0x2A17,0x1174,0x1112,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2930,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x292F,0x292F,0x2910,0x2910,0x290F,0x290F,0x290F,0x2910,0x2910,0x2930,0x2930,0x2930,0x212F,0x210F,0x292F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1932,0x1933,0x1133,0x21B5,0x21F7,0x21D6,0x1974,0x1112,0x1932,0x2151,0x2131,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2950,0x2930,0x290F,0x28CE,0x208C,0x282A,0xCC9A,0xDCDA,0xDC99,0xDC98,0xDC57,0xDC37,0xDC57,0xDC57,0xDC36,0xDC37,0xDC37,0xDC36,0xE457,0xDC37,0xDC57,0xDC57,0xDC37,0xDC57,0xDC57,0xDC57,0xDC56,0xDC56,0xDC36,0xE457,0xDC37,0xDC37,0xE457,0xE457,0xDC36,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC78,0xDC99,0xDC99,0xD4BA,0x618F,0x286B,0x30EE,0x28EE,0x20EE,0x290F,0x2930,0x2930,0x2930,0x2110,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x212F,0x210F,0x210F,0x2110,0x2930,0x2110,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2910,0x2930,0x2930,0x290F,0x210F,0x2930,0x210F,0x210F,0x2910,0x290F,0x2930,0x2910,0x2930,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x290F,0x2110,0x2110,0x210F,0x2930,0x290F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x2930,0x2130,0x2110,0x2130,0x2130,0x2110,0x1911,0x1132,0x1154,0x11D6,0x19F7,0x11B7,0x09B7,0x11D7,0x11D7,0x11D7,0x11B7,0x11F8,0x1A19,0x19F8,0x1196,0x1175,0x1133,0x1932,0x2111,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x212F,0x212F,0x2930,0x2130,0x212F,0x212F,0x2930,0x2910,0x2930,0x2930,0x2930,0x292F,0x212F,0x212F,0x2930,0x2930,0x210F,0x210F,0x210F,0x212F,0x2930,0x212F,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x210F,0x2110,0x2110,0x1911,0x1932,0x1133,0x19D6,0x11F7,0x11D6,0x1195,0x1131,0x1910,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x210F,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x292F,0x210F,0x292F,0x290F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x192F,0x110F,0x010E,0x445A,0x345A,0x2439,0x1C19,0x13F8,0x1419,0x13F8,0x13F8,0x13F8,0x1C18,0x1C18,0x1BF8,0x1BF8,0x1BF8,0x23F8,0x2BD8,0x33F8,0x3BD8,0x014F,0x0950,0x1150,0x1150,0x1150,0x1150,0x0950,0x0190,0x4C1A,0x445A,0x2C3A,0x23F9,0x13B8,0x13B8,0x1BF8,0x1C18,0x2439,0x23F8,0x1316,0x01F1,0x01D1,0x0233,0x23F9,0x2419,0x1C19,0x13F8,0x13F8,0x13F8,0x1BD8,0x23F8,0x23F8,0x3C3A,0x3398,0x0190,0x012F,0x0150,0x3BF9,0x33F9,0x2C19,0x23F8,0x1BD8,0x1BF9,0x1C19,0x1418,0x1419,0x1419,0x1439,0x1418,0x1418,0x1418,0x13F8,0x1418,0x1BF8,0x1BF8,0x2418,0x2C18,0x3C5A,0x4419,0x010E,0x1150,0x1930,0x1930,0x1930,0x2130,0x2130,0x2150,0x1950,0x1150,0x0970,0x0170,0x01D0,0x0A93,0x2376,0x3418,0x3C7A,0x447B,0x4C9B,0x4C7B,0x549C,0x3B78,0x0130,0x1110,0x1930,0x1930,0x2130,0x2130,0x2130,0x2130,0x2110,0x1911,0x1932,0x1933,0x19B5,0x19F7,0x11D8,0x09D8,0x09D9,0x01DA,0x01DA,0x01DA,0x01FA,0x01DA,0x09FA,0x01D9,0x09F9,0x09D8,0x09B7,0x0976,0x0955,0x0934,0x0912,0x1112,0x1132,0x1112,0x1112,0x1932,0x1912,0x1912,0x1932,0x1932,0x1912,0x1912,0x1111,0x1912,0x1912,0x1112,0x1112,0x1112,0x1112,0x1912,0x1112,0x1912,0x1912,0x1912,0x1912,0x1112,0x1112,0x1932,0x1932,0x1112,0x1932,0x1932,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x0912,0x0953,0x11B5,0x21F7,0x19F7,0x19B6,0x1174,0x1154,0x1133,0x1132,0x1932,0x1912,0x1932,0x1932,0x1912,0x1133,0x1954,0x1174,0x19B6,0x19F7,0x21F7,0x19D6,0x1974,0x1112,0x1112,0x1931,0x1931,0x1931,0x1930,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,
  0x2910,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2910,0x210F,0x290F,0x290F,0x292F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2930,0x210F,0x290F,0x290F,0x292F,0x290F,0x290F,0x212F,0x212F,0x292F,0x212F,0x2930,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2151,0x1931,0x1931,0x1132,0x1153,0x1175,0x11B6,0x11D8,0x19F9,0x19F9,0x11D8,0x19D8,0x19D7,0x1196,0x1174,0x1133,0x1932,0x1931,0x1931,0x2131,0x2110,0x2130,0x2130,0x2130,0x1930,0x2130,0x1930,0x1910,0x1930,0x1930,0x1931,0x1931,0x1931,0x1931,0x1911,0x2111,0x1911,0x1911,0x2131,0x2131,0x2111,0x1911,0x1910,0x1931,0x1931,0x1910,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x1932,0x1132,0x1133,0x1155,0x1196,0x11D7,0x1218,0x1A19,0x1A19,0x11D7,0x11B6,0x1155,0x1133,0x1112,0x1111,0x1931,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2910,0x2910,0x2930,0x290F,0x2930,0x2910,0x2910,0x292F,0x290F,0x2110,0x2910,0x2110,0x2930,0x2910,0x2910,0x290F,0x2930,0x210F,0x2910,0x2930,0x210F,0x210F,0x2910,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x290F,0x290F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2930,0x2930,0x210F,0x212F,0x2930,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x292F,0x210F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2110,0x210F,0x210F,0x2110,0x2110,0x210F,0x2910,0x210F,0x212F,0x212F,0x210F,0x292F,0x212F,0x210F,0x290F,0x210F,0x210F,0x212F,0x212F,0x2930,0x210F,0x212F,0x2930,0x210F,0x210F,0x2930,0x2910,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x210F,0x210F,0x2930,0x2930,0x2930,0x210F,0x2110,0x2130,0x2130,0x212F,0x290F,0x2930,0x212F,0x212F,0x2110,0x2110,0x210F,0x212F,0x210F,0x212F,0x2930,0x290F,0x2910,0x2930,0x212F,0x212F,0x210F,0x2930,0x292F,0x210F,0x2910,0x2910,0x210F,0x210F,0x290F,0x2930,0x212F,0x212F,0x212F,0x292F,0x212F,0x292F,0x2930,0x2930,0x292F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x2930,0x2930,0x210F,0x2930,0x2910,0x2110,0x2110,0x2910,0x2910,0x2110,0x2930,0x2930,0x290F,0x2930,0x2930,0x210F,0x290F,0x290F,0x2930,0x2910,0x290F,0x290F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2150,0x192F,0x112F,0x012F,0x22B5,0x3BF9,0x23B8,0x1BB8,0x1BD9,0x13D9,0x13D8,0x13B8,0x13D8,0x1BF9,0x1BD8,0x23B8,0x33D8,0x1A74,0x014F,0x014F,0x0970,0x0150,0x01D2,0x33D9,0x23D9,0x23F9,0x23F9,0x23D9,0x2B98,0x014F,0x08EE,0x192F,0x192F,0x212F,0x2150,0x214F,0x1950,0x110F,0x112F,0x092F,0x0170,0x2BF9,0x1BD9,0x1BF9,0x1BF9,0x23F9,0x3C3A,0x01B1,0x010F,0x0970,0x1150,0x1950,0x2130,0x2130,0x212F,0x2930,0x2930,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x2930,0x290F,0x2930,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x292F,0x2930,0x2910,0x2930,0x210F,0x2110,0x2930,0x2110,0x2930,0x2110,0x2110,0x2130,0x210F,0x210F,0x212F,0x212F,0x292F,0x210F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1932,0x1932,0x1133,0x1153,0x1195,0x21F6,0x2217,0x2217,0x19D6,0x1974,0x1133,0x1912,0x18F1,0x2131,0x2130,0x2130,0x2130,0x2130,0x2150,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1953,0x1133,0x1975,0x2A17,0x2A17,0x1974,0x1112,0x1932,0x1931,0x2131,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2910,0x290F,0x290F,0x2930,0x210F,0x2930,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x290F,0x2910,0x210F,0x2930,0x2930,0x290F,0x2930,0x2910,0x2110,0x2930,0x210F,0x210F,0x290F,0x210F,0x292F,0x292F,0x2130,0x210F,0x2130,0x2130,0x2131,0x2131,0x1932,0x1933,0x1113,0x21B5,0x21F7,0x21D6,0x1974,0x1112,0x2152,0x2152,0x2151,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x28CE,0x204B,0x48ED,0xDCFC,0xDCBA,0xDC98,0xDC78,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC36,0xDC37,0xDC36,0xDC37,0xDC37,0xDC57,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xE457,0xDC36,0xDC37,0xE457,0xE477,0xDC36,0xDC37,0xDC37,0xDC57,0xDC57,0xDC37,0xDC57,0xDC57,0xDC58,0xDC78,0xD479,0xCC79,0x8AB3,0x2809,0x30CD,0x28ED,0x20EE,0x290F,0x290F,0x2930,0x2910,0x2930,0x2930,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x212F,0x2110,0x2110,0x210F,0x2110,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2910,0x210F,0x2110,0x212F,0x210F,0x2930,0x290F,0x290F,0x290F,0x2930,0x212F,0x2930,0x210F,0x2930,0x290F,0x2930,0x212F,0x210F,0x2130,0x2130,0x2130,0x2111,0x1911,0x1133,0x1195,0x19F7,0x11F8,0x0996,0x0996,0x0996,0x0976,0x0976,0x0976,0x0996,0x19F8,0x1A19,0x11D8,0x1996,0x1133,0x1932,0x1911,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x212F,0x2930,0x2930,0x212F,0x212F,0x2930,0x210F,0x2930,0x2930,0x2930,0x292F,0x292F,0x292F,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2110,0x2110,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x1911,0x1932,0x1133,0x11D6,0x19F7,0x11D6,0x1194,0x1131,0x1931,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x210F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x292F,0x2930,0x290F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x192F,0x090F,0x010E,0x3C3A,0x2419,0x13F8,0x1419,0x1419,0x1419,0x0C18,0x0C18,0x0BF8,0x1418,0x1418,0x13F8,0x1BF8,0x1BF8,0x23F8,0x2BF8,0x33F8,0x33B8,0x0170,0x0950,0x1150,0x1150,0x1150,0x1170,0x1170,0x0150,0x1253,0x445B,0x23F9,0x1BF8,0x13D8,0x13D8,0x0BD8,0x1418,0x1419,0x1C18,0x1BD8,0x02B4,0x0232,0x0B16,0x13D8,0x1418,0x0BF8,0x0BF8,0x0BF8,0x1419,0x1BF8,0x1BF8,0x2C19,0x3C3A,0x1274,0x0170,0x014F,0x0190,0x3BF9,0x2BD9,0x23D8,0x1BF8,0x1BF8,0x13F8,0x13F8,0x0C19,0x0BF8,0x0BF8,0x0C19,0x0C18,0x0C19,0x0BF8,0x0C18,0x1418,0x13F8,0x1C19,0x1C19,0x2439,0x345A,0x3BD9,0x012F,0x1130,0x1930,0x1930,0x2130,0x2130,0x2130,0x2150,0x1150,0x094F,0x1212,0x3BD8,0x3C5A,0x3C9A,0x349A,0x2479,0x2459,0x2439,0x2C7A,0x3C7A,0x44BC,0x441A,0x0130,0x0930,0x1130,0x1930,0x2110,0x2130,0x2130,0x2130,0x2110,0x2131,0x1912,0x1133,0x1995,0x11B7,0x09D8,0x09D9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01D9,0x09F9,0x09D9,0x09D8,0x09B7,0x0996,0x1175,0x0934,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1132,0x1133,0x1133,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1133,0x1112,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1112,0x1132,0x1112,0x1113,0x1113,0x0912,0x0913,0x1133,0x1134,0x19B5,0x2A38,0x2217,0x19D6,0x1995,0x1154,0x1133,0x1112,0x1932,0x1912,0x1912,0x1912,0x1912,0x1112,0x1134,0x1975,0x19B6,0x21F7,0x21F7,0x21D6,0x1995,0x1133,0x1112,0x1911,0x1931,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,
  0x2910,0x2110,0x2110,0x2930,0x2910,0x2930,0x2910,0x2910,0x210F,0x210F,0x292F,0x292F,0x292F,0x290F,0x290F,0x210F,0x292F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2930,0x2910,0x2110,0x2130,0x2930,0x290F,0x210F,0x212F,0x210F,0x292F,0x212F,0x2930,0x210F,0x2930,0x212F,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x1974,0x1175,0x1196,0x11B7,0x19F8,0x19F8,0x19F9,0x19D8,0x11B7,0x1196,0x1154,0x1133,0x1112,0x1932,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1910,0x2131,0x2131,0x2131,0x2132,0x1932,0x1132,0x1154,0x1195,0x11B6,0x11D7,0x1218,0x1A19,0x1A19,0x11D8,0x1196,0x0955,0x1134,0x1112,0x1912,0x1911,0x2151,0x2951,0x2951,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x2130,0x210F,0x2130,0x2110,0x2110,0x2910,0x210F,0x2110,0x2130,0x2110,0x2110,0x2930,0x2910,0x2910,0x2910,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2930,0x2930,0x2110,0x2110,0x2110,0x2130,0x2110,0x2930,0x290F,0x290F,0x2930,0x292F,0x2930,0x292F,0x292F,0x290F,0x210F,0x212F,0x2930,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x2930,0x2130,0x2130,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x212F,0x210F,0x210F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x2930,0x290F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x210F,0x290F,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x292F,0x2930,0x210F,0x2910,0x2910,0x2930,0x290F,0x2910,0x210F,0x2110,0x2910,0x2910,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x290F,0x290F,0x2930,0x2930,0x212F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x210F,0x2110,0x2110,0x2130,0x2930,0x290F,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x2930,0x2130,0x210F,0x2930,0x212F,0x2930,0x212F,0x2930,0x212F,0x212F,0x212F,0x2110,0x210F,0x2130,0x212F,0x2130,0x2130,0x2130,0x210F,0x2110,0x2930,0x212F,0x2930,0x290F,0x2910,0x2110,0x2910,0x2910,0x2910,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2910,0x2930,0x292F,0x290F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x214F,0x192F,0x090F,0x0970,0x43D9,0x2B98,0x1BB9,0x1BF9,0x13F9,0x13D9,0x13F9,0x13D9,0x13D9,0x13D9,0x1BD8,0x1BB8,0x2377,0x3357,0x0190,0x014F,0x0150,0x0130,0x01B1,0x33B9,0x2BD9,0x23F9,0x23F9,0x23D9,0x2B78,0x012F,0x08EE,0x192F,0x212F,0x212F,0x212F,0x212F,0x192F,0x192F,0x112F,0x010F,0x0170,0x33F9,0x1BF9,0x241A,0x23F9,0x23D9,0x33FA,0x0150,0x010F,0x1170,0x1970,0x1950,0x2150,0x2130,0x2130,0x210F,0x210F,0x290F,0x292F,0x290F,0x210F,0x210F,0x210F,0x2910,0x2930,0x290F,0x290F,0x290F,0x2910,0x290F,0x210F,0x290F,0x290F,0x292F,0x212F,0x292F,0x292F,0x292F,0x2930,0x2930,0x292F,0x290F,0x2930,0x2910,0x2930,0x2930,0x2130,0x2930,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1932,0x1932,0x1953,0x1153,0x1195,0x19D6,0x2217,0x21F7,0x19B5,0x1174,0x1133,0x1912,0x1911,0x2131,0x2130,0x2110,0x2130,0x212F,0x2150,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1953,0x1153,0x1995,0x2A17,0x2A17,0x1974,0x1112,0x1932,0x2131,0x2131,0x2131,0x2130,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x2110,0x210F,0x2130,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2910,0x210F,0x210F,0x290F,0x290F,0x2930,0x2930,0x2110,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2131,0x2111,0x1912,0x1932,0x1113,0x21B5,0x21F6,0x21F6,0x1974,0x1112,0x1932,0x2151,0x2151,0x2131,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x290F,0x310E,0x284B,0x8293,0xDCDB,0xDC99,0xDC99,0xDC78,0xDC57,0xDC37,0xDC57,0xDC37,0xDC57,0xE457,0xDC36,0xDC36,0xDC36,0xE457,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC57,0xDC36,0xE457,0xDC36,0xDC36,0xDC37,0xE457,0xDC36,0xDC37,0xDC37,0xDC37,0xDC57,0xDC36,0xDC36,0xDC37,0xDC57,0xDC58,0xDC58,0xD478,0xD499,0xD4BA,0x510D,0x202A,0x28CD,0x290E,0x290F,0x2930,0x2930,0x210F,0x210F,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2130,0x2930,0x2110,0x2110,0x2930,0x2910,0x2930,0x2910,0x2910,0x2910,0x2930,0x2930,0x2910,0x210F,0x2930,0x2930,0x2930,0x2910,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x210F,0x2110,0x2930,0x210F,0x292F,0x210F,0x2910,0x2930,0x2930,0x2930,0x2930,0x2130,0x212F,0x210F,0x290F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2131,0x2131,0x1932,0x1154,0x19F7,0x19F8,0x11D8,0x0976,0x0975,0x0955,0x0135,0x0134,0x0134,0x0955,0x11B7,0x11F8,0x19F8,0x19D7,0x1134,0x1932,0x2131,0x2131,0x2930,0x210F,0x210F,0x2910,0x210F,0x210F,0x212F,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2930,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x2130,0x2110,0x2130,0x1931,0x1932,0x1133,0x11B5,0x19F7,0x19F7,0x1194,0x1111,0x1931,0x1910,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x210F,0x2130,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x292F,0x210F,0x210F,0x290F,0x210F,0x290F,0x2930,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x192F,0x192F,0x090E,0x012E,0x3C5A,0x1C19,0x1419,0x1439,0x0C19,0x0C18,0x0C18,0x0C18,0x0C18,0x0BF8,0x1418,0x13F8,0x13F8,0x1BF8,0x23F8,0x23D8,0x33F8,0x3397,0x0150,0x0950,0x1150,0x1150,0x1150,0x1170,0x1150,0x0950,0x0170,0x3398,0x2C19,0x1BF9,0x13F8,0x1419,0x0BD8,0x0BF8,0x0C18,0x0C18,0x1418,0x0BB7,0x0315,0x0BB7,0x1418,0x0BF8,0x0C19,0x0BF8,0x0BF8,0x13F8,0x1BF9,0x23F9,0x2C19,0x2357,0x01F2,0x014F,0x014F,0x01B1,0x3BF9,0x23B8,0x23D8,0x1BD8,0x13D8,0x13F8,0x1419,0x0C19,0x0C19,0x0C19,0x0418,0x0C19,0x0C19,0x0C19,0x0BF8,0x0BF8,0x1419,0x1419,0x1BF8,0x23F8,0x3439,0x4419,0x012F,0x1150,0x1930,0x1930,0x2150,0x2130,0x1930,0x1950,0x1150,0x012F,0x3BB8,0x447B,0x2418,0x1C18,0x1418,0x1418,0x0BF8,0x0BD8,0x1418,0x2419,0x345A,0x33B9,0x0170,0x0950,0x1130,0x1930,0x1930,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1133,0x21D7,0x19F7,0x09D8,0x09D9,0x01D9,0x01FA,0x01DA,0x01DA,0x01BA,0x01DA,0x01DA,0x01DA,0x09FA,0x09D9,0x09D9,0x11D8,0x11B8,0x1196,0x11B6,0x1195,0x1995,0x1995,0x1995,0x1994,0x1994,0x1995,0x1994,0x1974,0x1994,0x1974,0x1994,0x1994,0x1974,0x1974,0x1974,0x1994,0x1994,0x1974,0x1974,0x1974,0x1974,0x1974,0x1994,0x1994,0x1974,0x1974,0x1974,0x1974,0x1994,0x1994,0x1994,0x1995,0x1995,0x21B5,0x21D5,0x21D6,0x21D6,0x21D6,0x21F6,0x19F6,0x21D6,0x1995,0x1153,0x1133,0x1932,0x1932,0x1912,0x1912,0x1912,0x1912,0x1113,0x1134,0x1155,0x1996,0x21F8,0x19D7,0x21F7,0x1995,0x1133,0x1132,0x1931,0x1931,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x210F,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2910,0x2910,
  0x2110,0x2110,0x2110,0x2110,0x210F,0x2910,0x2910,0x210F,0x292F,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2930,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x2930,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x1931,0x2152,0x1932,0x1954,0x1175,0x1196,0x11B7,0x19F8,0x11D9,0x11F9,0x11F8,0x11B7,0x1196,0x1154,0x1133,0x1112,0x1931,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x210F,0x2110,0x2110,0x210F,0x210F,0x2130,0x2130,0x2130,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x1910,0x2130,0x2130,0x2130,0x2131,0x1931,0x1952,0x1132,0x1153,0x1175,0x11B6,0x11D7,0x11F8,0x1A39,0x11F9,0x11D8,0x11B7,0x1175,0x1133,0x1112,0x10F1,0x2131,0x2151,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x2130,0x210F,0x2110,0x212F,0x210F,0x2130,0x2130,0x210F,0x210F,0x2910,0x2930,0x210F,0x2930,0x290F,0x2930,0x290F,0x2930,0x2930,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2910,0x210F,0x2930,0x2110,0x2110,0x212F,0x212F,0x210F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2110,0x210F,0x2110,0x2930,0x210F,0x2130,0x2130,0x2110,0x210F,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x210F,0x292F,0x212F,0x292F,0x210F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x2930,0x290F,0x210F,0x2110,0x2910,0x2910,0x212F,0x212F,0x2930,0x290F,0x2930,0x2930,0x2930,0x212F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x290F,0x290F,0x2930,0x290F,0x290F,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2930,0x2110,0x2110,0x2930,0x2930,0x2110,0x2930,0x2110,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2930,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x210F,0x212F,0x212F,0x2130,0x210F,0x2130,0x210F,0x2130,0x2130,0x212F,0x212F,0x2930,0x2910,0x2910,0x2910,0x210F,0x2910,0x2930,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x2910,0x2910,0x290F,0x292F,0x2930,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x214F,0x192F,0x090F,0x1A13,0x441A,0x2BB9,0x1BD9,0x13D9,0x13B9,0x13D9,0x13D9,0x13F9,0x13D9,0x1BF9,0x1BD9,0x23D9,0x2B98,0x3378,0x09D1,0x012F,0x012F,0x0130,0x01B1,0x33D9,0x341A,0x2C1A,0x23FA,0x2BF9,0x2B78,0x012F,0x08EE,0x194F,0x212F,0x212F,0x212F,0x212F,0x212F,0x192F,0x112F,0x010F,0x0170,0x33F9,0x23D9,0x23F9,0x23F9,0x2BF9,0x33D9,0x012F,0x010F,0x1170,0x1950,0x1930,0x2130,0x212F,0x212F,0x212F,0x292F,0x212F,0x292F,0x292F,0x210F,0x290F,0x290F,0x210F,0x210F,0x2930,0x290F,0x2910,0x2910,0x290F,0x290F,0x292F,0x292F,0x292F,0x212F,0x2930,0x292F,0x2930,0x292F,0x292F,0x292F,0x290F,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2110,0x2930,0x212F,0x290F,0x290F,0x292F,0x292F,0x292F,0x210F,0x292F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1953,0x1174,0x1195,0x21F7,0x2217,0x19D6,0x1995,0x1954,0x1953,0x1911,0x1931,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x1931,0x1932,0x1132,0x1153,0x1995,0x2A17,0x2A17,0x1994,0x1112,0x1912,0x1931,0x2131,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x210F,0x212F,0x2910,0x2110,0x212F,0x212F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2930,0x2930,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2910,0x210F,0x2930,0x210F,0x290F,0x2110,0x2110,0x2110,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1912,0x1932,0x1113,0x21B5,0x21F6,0x21D6,0x1994,0x1112,0x1932,0x2151,0x2151,0x2130,0x2130,0x2130,0x2950,0x2930,0x2930,0x2930,0x2930,0x2930,0x2950,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x290E,0x310E,0x306B,0xABD8,0xD4BA,0xDC99,0xDC78,0xDC78,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC37,0xDC36,0xDC36,0xE457,0xDC37,0xDC57,0xDC37,0xDC57,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC36,0xDC36,0xDC37,0xE437,0xDC37,0xE457,0xDC37,0xDC57,0xDC37,0xDC37,0xDC57,0xDC57,0xDC37,0xDC58,0xDC58,0xDC78,0xD479,0xD479,0x92F3,0x2008,0x288B,0x30EE,0x290F,0x292F,0x290F,0x2930,0x290F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2110,0x2930,0x2110,0x2930,0x2130,0x2130,0x2130,0x2130,0x2930,0x2910,0x2930,0x2930,0x2910,0x2910,0x2910,0x210F,0x290F,0x210F,0x2910,0x290F,0x210F,0x2930,0x2930,0x292F,0x290F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2930,0x2910,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x2930,0x210F,0x2130,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1175,0x19F8,0x19F8,0x11D8,0x0976,0x0955,0x0935,0x0134,0x0934,0x0134,0x0155,0x0976,0x11F8,0x1A19,0x19D7,0x1155,0x1112,0x2131,0x2111,0x2110,0x2930,0x2910,0x2910,0x210F,0x210F,0x210F,0x212F,0x210F,0x2930,0x212F,0x2930,0x212F,0x212F,0x210F,0x2930,0x290F,0x212F,0x2930,0x2110,0x2130,0x2130,0x2930,0x290F,0x290F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x292F,0x210F,0x210F,0x292F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1133,0x19D6,0x11F6,0x11D6,0x1195,0x1132,0x1931,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x212F,0x212F,0x212F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2110,0x2130,0x2110,0x2130,0x2110,0x2930,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x1930,0x112F,0x090E,0x012F,0x345A,0x1C19,0x0C19,0x0C39,0x0C19,0x0C39,0x0C18,0x0BF8,0x0BF8,0x0BF8,0x0BF8,0x0BD8,0x1BF8,0x1BD8,0x23D8,0x23D8,0x33F8,0x2B77,0x014F,0x0950,0x1150,0x1970,0x1150,0x1150,0x1150,0x0950,0x0150,0x1253,0x345A,0x1BF9,0x1419,0x1419,0x0C18,0x0C18,0x0C18,0x0C18,0x0C18,0x0C18,0x03D7,0x0BF8,0x0C18,0x03F8,0x0C39,0x0C18,0x0BF8,0x13F8,0x1C19,0x23F9,0x3419,0x0212,0x0190,0x012F,0x012F,0x01B1,0x441A,0x2BB8,0x23D8,0x1BD8,0x13F8,0x1419,0x0BF8,0x0C18,0x0C39,0x0419,0x0419,0x03F8,0x0419,0x0C19,0x0C19,0x0BF8,0x13F9,0x13F8,0x1BF9,0x23F9,0x3419,0x43F9,0x012F,0x1130,0x1930,0x1930,0x2130,0x2150,0x1930,0x1950,0x1150,0x012F,0x33B8,0x3439,0x1C18,0x1418,0x0BF8,0x03F8,0x0C18,0x0C19,0x1439,0x1C19,0x2C5A,0x2BB8,0x0170,0x0930,0x1150,0x1130,0x1930,0x2130,0x2130,0x2131,0x2131,0x1931,0x1932,0x1153,0x11B5,0x11D7,0x09D8,0x09F9,0x01D9,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01DA,0x01D9,0x09D9,0x09F9,0x11D9,0x11B8,0x11D7,0x2238,0x2217,0x2A17,0x2A17,0x2A17,0x2A17,0x2A37,0x2A17,0x2A37,0x2A17,0x2A17,0x2A17,0x3237,0x2A37,0x2A37,0x2A17,0x2A17,0x2A16,0x2A17,0x2A17,0x2A17,0x2A17,0x2A37,0x2A17,0x3237,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x2A17,0x29F6,0x2A17,0x29F6,0x2A17,0x21F6,0x21F6,0x21F6,0x21F6,0x19B5,0x19B5,0x19B5,0x1994,0x1974,0x1933,0x1112,0x1912,0x1912,0x1912,0x1912,0x1933,0x1933,0x1134,0x1155,0x19B7,0x21F8,0x21F8,0x21F7,0x1975,0x1133,0x1112,0x1911,0x2151,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x212F,0x2130,0x2130,0x210F,0x212F,0x212F,0x2930,0x2130,0x210F,0x2130,0x2130,0x2130,0x210F,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x2110,0x2910,0x2930,
  0x2110,0x2110,0x210F,0x2110,0x2910,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2110,0x2910,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x2930,0x212F,0x2930,0x212F,0x210F,0x210F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2131,0x2131,0x2152,0x1932,0x1133,0x1155,0x1196,0x11B7,0x19D8,0x11F9,0x11F9,0x19F9,0x11B7,0x1196,0x1154,0x1133,0x1132,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x210F,0x2130,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1931,0x1932,0x1132,0x1133,0x1175,0x1196,0x11D8,0x1A39,0x1A39,0x1A19,0x11D8,0x1197,0x1155,0x1134,0x1113,0x18F2,0x1911,0x2111,0x2111,0x2110,0x2110,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x2130,0x2930,0x2930,0x2130,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x290F,0x210F,0x292F,0x292F,0x210F,0x212F,0x210F,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x292F,0x212F,0x210F,0x290F,0x2930,0x2930,0x2130,0x2130,0x2130,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x210F,0x212F,0x2930,0x2910,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x212F,0x2930,0x210F,0x212F,0x212F,0x212F,0x2930,0x292F,0x212F,0x212F,0x210F,0x292F,0x212F,0x212F,0x212F,0x2930,0x212F,0x210F,0x290F,0x290F,0x2110,0x2110,0x2910,0x210F,0x2930,0x292F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x292F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x290F,0x210F,0x210F,0x2130,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2910,0x2110,0x2110,0x210F,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x212F,0x210F,0x290F,0x210F,0x2930,0x2930,0x292F,0x212F,0x2930,0x2930,0x2930,0x2130,0x212F,0x2130,0x2930,0x2110,0x2910,0x2930,0x292F,0x292F,0x292F,0x212F,0x210F,0x212F,0x212F,0x212F,0x214F,0x192F,0x00EE,0x2AB5,0x4C5B,0x2BD9,0x23FA,0x13D9,0x13D9,0x13D9,0x13D9,0x13F9,0x13D9,0x13D9,0x1BD9,0x1BB8,0x2BB8,0x3B98,0x09D1,0x012F,0x0130,0x0130,0x01B2,0x33DA,0x23B9,0x23D9,0x23D9,0x2BD9,0x33B9,0x014F,0x090E,0x192F,0x212F,0x214F,0x212F,0x210F,0x212F,0x1950,0x112F,0x010F,0x0170,0x33D9,0x2BF9,0x23B9,0x23D9,0x2BF9,0x443A,0x0170,0x0950,0x1150,0x1930,0x2150,0x2130,0x210F,0x210F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2910,0x2910,0x290F,0x290F,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x2930,0x212F,0x290F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x290F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x210F,0x2930,0x2930,0x290F,0x292F,0x292F,0x212F,0x292F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2131,0x2131,0x1931,0x1932,0x1953,0x1974,0x1995,0x19D6,0x19F7,0x19B5,0x1995,0x1994,0x1932,0x1931,0x1931,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1932,0x1133,0x1133,0x1995,0x2A17,0x2A17,0x1974,0x1112,0x1912,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x290F,0x2930,0x2930,0x290F,0x2930,0x2930,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x2110,0x2110,0x290F,0x2930,0x210F,0x290F,0x210F,0x2910,0x290F,0x290F,0x290F,0x290F,0x2930,0x2110,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2111,0x1932,0x1932,0x1133,0x19B5,0x21D6,0x21D6,0x1974,0x1132,0x1952,0x2152,0x2151,0x2131,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x30EE,0x40CD,0xD4BB,0xDC9A,0xDC99,0xDC78,0xDC58,0xDC58,0xDC37,0xDC57,0xDC57,0xDC37,0xDC57,0xDC57,0xDC36,0xDC36,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC37,0xDC57,0xDC56,0xE456,0xDC36,0xE437,0xDC16,0xE437,0xE457,0xE457,0xDC57,0xDC37,0xDC37,0xDC57,0xDC37,0xDC57,0xDC17,0xDC37,0xDC58,0xDC99,0xD499,0xC439,0x594E,0x282A,0x288C,0x30EE,0x310F,0x2930,0x2930,0x2930,0x212F,0x2130,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2130,0x2930,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x290F,0x2930,0x2910,0x2910,0x290F,0x2910,0x2910,0x2910,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x2930,0x210F,0x2130,0x2130,0x212F,0x2930,0x2930,0x2110,0x2930,0x2930,0x2110,0x2131,0x1911,0x1112,0x1175,0x1A18,0x1A39,0x11F8,0x0976,0x0135,0x0954,0x0934,0x0134,0x0954,0x0955,0x0976,0x1A19,0x223A,0x19D8,0x1134,0x10F2,0x2131,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x212F,0x2930,0x210F,0x2930,0x2930,0x210F,0x290F,0x2930,0x210F,0x210F,0x210F,0x2130,0x212F,0x212F,0x2930,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x292F,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x2110,0x1910,0x1931,0x1132,0x1153,0x19D6,0x19F7,0x19F6,0x1194,0x1132,0x1931,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x2110,0x2910,0x2110,0x2110,0x2130,0x212F,0x210F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2110,0x210F,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x1930,0x112F,0x00EE,0x014F,0x3C9B,0x1C39,0x1439,0x0C39,0x03F8,0x0418,0x03F8,0x0C18,0x0BF8,0x1419,0x1C39,0x245A,0x2419,0x2C39,0x345A,0x3C5A,0x4C9B,0x3BB8,0x012F,0x1170,0x1950,0x112F,0x1930,0x1950,0x1150,0x1150,0x0130,0x014F,0x2397,0x2439,0x1419,0x0C19,0x0C18,0x0C19,0x03F8,0x0418,0x0418,0x0C39,0x03F8,0x0418,0x0418,0x0418,0x0C39,0x0C19,0x0C18,0x1419,0x1BF9,0x2C1A,0x2337,0x0170,0x014F,0x010E,0x010F,0x09D1,0x545B,0x3C1A,0x33F9,0x2C39,0x1C19,0x13F8,0x0C19,0x0C39,0x03F8,0x0419,0x0418,0x0419,0x03F8,0x03F9,0x0BF9,0x0BF9,0x1419,0x1C39,0x243A,0x343A,0x445B,0x543A,0x092F,0x1950,0x1950,0x1930,0x2130,0x1930,0x1930,0x1950,0x112F,0x010E,0x3BD8,0x345A,0x1C18,0x0C18,0x0BF8,0x0C39,0x0C18,0x0C18,0x0BF9,0x1419,0x243A,0x2BF9,0x0150,0x0950,0x1150,0x1950,0x1930,0x2130,0x2130,0x2130,0x2131,0x1931,0x1931,0x1133,0x11B5,0x11D7,0x09D7,0x01F9,0x01D9,0x01DA,0x01B9,0x01BA,0x01BA,0x01BA,0x01BA,0x09DA,0x09FA,0x09D9,0x09D9,0x11D8,0x11B7,0x19B7,0x21F7,0x21F7,0x21F7,0x21F7,0x29F7,0x29F7,0x29F7,0x2A17,0x2A17,0x29F6,0x29F6,0x2A17,0x2A16,0x29F6,0x29F6,0x29F6,0x29F6,0x29F6,0x29D6,0x29F6,0x29F6,0x21F6,0x2A16,0x29F6,0x29F6,0x21F6,0x21F6,0x21F6,0x21F6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21D6,0x21F6,0x21D5,0x21B5,0x21B5,0x1974,0x1953,0x1932,0x1111,0x1911,0x1911,0x1912,0x1912,0x1932,0x1113,0x1134,0x1155,0x19B7,0x21F8,0x21F8,0x21D7,0x1995,0x1133,0x1112,0x1931,0x1931,0x2151,0x2130,0x2130,0x2130,0x210F,0x2130,0x212F,0x2130,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x2130,0x210F,0x212F,0x2130,0x210F,0x210F,0x210F,0x2130,0x2130,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x210F,0x210F,0x2130,0x2110,0x2930,
  0x2110,0x210F,0x2110,0x210F,0x2910,0x2910,0x2930,0x2930,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x292F,0x2930,0x2910,0x2910,0x2910,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2111,0x1911,0x1933,0x1954,0x1155,0x1196,0x11B7,0x11D8,0x11F9,0x11F9,0x11F8,0x11B7,0x0976,0x1174,0x1133,0x1132,0x1931,0x2131,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x210F,0x210F,0x212F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1931,0x1911,0x1132,0x1154,0x1175,0x11B7,0x11D8,0x1A19,0x1A19,0x11F9,0x11B8,0x1197,0x1155,0x1134,0x1933,0x18F2,0x1911,0x2111,0x2111,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x2110,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x212F,0x210F,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x212F,0x212F,0x2930,0x2930,0x212F,0x212F,0x2930,0x212F,0x210F,0x2930,0x2110,0x2110,0x2930,0x212F,0x2930,0x212F,0x210F,0x210F,0x210F,0x2930,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2930,0x2930,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2930,0x212F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2910,0x2910,0x2110,0x210F,0x2910,0x2930,0x2930,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x212F,0x212F,0x210F,0x2930,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x292F,0x212F,0x292F,0x2930,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2930,0x2930,0x212F,0x212F,0x292F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x192F,0x00CE,0x2A95,0x4C5B,0x2BDA,0x1BD9,0x1BD9,0x13D9,0x13D9,0x13FA,0x1BFA,0x1BFA,0x13D9,0x1BD9,0x23B8,0x2BB8,0x3357,0x11F2,0x012F,0x012F,0x012F,0x01B1,0x3BDA,0x2399,0x23B9,0x23D9,0x2BFA,0x33B9,0x014F,0x08EE,0x192F,0x212F,0x212F,0x212F,0x190F,0x212F,0x1950,0x112F,0x010F,0x09B1,0x33D9,0x2BB9,0x23D9,0x2BD9,0x33FA,0x441A,0x0170,0x092F,0x1150,0x1930,0x2130,0x2130,0x212F,0x212F,0x2930,0x292F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2110,0x2110,0x2910,0x2110,0x2910,0x2930,0x2930,0x292F,0x292F,0x292F,0x2930,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x1931,0x1932,0x1953,0x1133,0x1154,0x1195,0x19B6,0x21F7,0x19D6,0x21D6,0x1994,0x1111,0x1931,0x1930,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x1133,0x1995,0x2217,0x21F7,0x1995,0x1112,0x1932,0x1931,0x2131,0x2131,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x212F,0x290F,0x2930,0x212F,0x2930,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2930,0x210F,0x290F,0x2930,0x2910,0x210F,0x290F,0x290F,0x290F,0x2910,0x2930,0x210F,0x2110,0x2110,0x210F,0x212F,0x292F,0x292F,0x210F,0x210F,0x2110,0x2110,0x2130,0x2131,0x2131,0x1931,0x1932,0x1133,0x19B5,0x21F6,0x21D6,0x1994,0x1132,0x1952,0x2152,0x2151,0x2131,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x312F,0x30CD,0x596F,0xDCFC,0xDC99,0xDCB9,0xDC78,0xDC58,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC36,0xDC37,0xDC36,0xE457,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC36,0xDC56,0xDC56,0xE457,0xDC36,0xDC36,0xE437,0xE437,0xE457,0xDC36,0xDC37,0xDC37,0xDC37,0xDC57,0xDC57,0xDC37,0xDC37,0xDC58,0xDC79,0xDC79,0xD479,0xC459,0x7A72,0x200A,0x28AD,0x28EE,0x3130,0x2930,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2930,0x2930,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x2930,0x210F,0x2910,0x2930,0x290F,0x2910,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x2910,0x2110,0x2130,0x210F,0x210F,0x2130,0x2110,0x2930,0x2110,0x2110,0x2111,0x1912,0x1112,0x1175,0x1A18,0x1A18,0x11F8,0x0976,0x0955,0x0954,0x0954,0x0954,0x0954,0x0155,0x0976,0x1A19,0x223A,0x19D8,0x0934,0x1112,0x1911,0x2131,0x2130,0x2110,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x212F,0x210F,0x2930,0x2930,0x290F,0x210F,0x210F,0x2930,0x212F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x292F,0x292F,0x292F,0x290F,0x212F,0x212F,0x2130,0x212F,0x2130,0x212F,0x212F,0x210F,0x2130,0x2130,0x1931,0x1932,0x1133,0x19D6,0x19F6,0x19F6,0x1195,0x1132,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2930,0x2910,0x2910,0x2930,0x2910,0x210F,0x212F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x210F,0x2130,0x2930,0x212F,0x212F,0x212F,0x2130,0x2130,0x1930,0x192F,0x08EE,0x014F,0x3C9B,0x1439,0x0C19,0x0C19,0x0418,0x0418,0x0C19,0x1419,0x1C5A,0x2C5A,0x345A,0x343A,0x3439,0x33F8,0x33B8,0x3BD8,0x545A,0x3316,0x012F,0x1150,0x194F,0x192F,0x1950,0x1950,0x1950,0x1150,0x0950,0x014F,0x0232,0x2C5A,0x1C19,0x1419,0x0C18,0x0C39,0x0418,0x0418,0x0438,0x0418,0x0418,0x0418,0x0418,0x0439,0x0418,0x0C19,0x0C39,0x13F8,0x23F9,0x2BF9,0x01B0,0x010F,0x010F,0x010F,0x0950,0x0991,0x2274,0x2AF5,0x3398,0x3C19,0x2C19,0x1BF8,0x1418,0x0418,0x0418,0x0419,0x0439,0x0439,0x03F8,0x03F8,0x0C19,0x1419,0x2C3A,0x343A,0x3419,0x3BF9,0x3B98,0x1A53,0x1150,0x1950,0x1930,0x1930,0x2130,0x1930,0x1950,0x1950,0x112F,0x00EE,0x2B77,0x345A,0x1C18,0x0BF8,0x0BF8,0x03F8,0x0C39,0x03F8,0x1439,0x13F9,0x243A,0x23B8,0x0150,0x0950,0x0930,0x1150,0x1950,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1152,0x1194,0x11D7,0x09F8,0x09F8,0x01D9,0x01D9,0x01DA,0x01BA,0x01BA,0x01BA,0x01B9,0x09FA,0x09F9,0x09D9,0x11D8,0x11B7,0x1996,0x1976,0x1995,0x1975,0x1974,0x1974,0x1974,0x1974,0x1995,0x1974,0x1994,0x1994,0x1994,0x1974,0x1994,0x1994,0x1974,0x1974,0x1994,0x1994,0x1974,0x1994,0x1974,0x1994,0x1994,0x1974,0x1994,0x1994,0x1994,0x1994,0x1994,0x1974,0x1974,0x1974,0x1974,0x1974,0x1153,0x1974,0x1974,0x1953,0x1953,0x1953,0x1133,0x1932,0x1932,0x1911,0x1911,0x1911,0x1911,0x1932,0x1932,0x1112,0x1154,0x1155,0x1996,0x2218,0x21F8,0x21D7,0x1995,0x1133,0x1112,0x1911,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x2930,0x290F,
  0x290F,0x210F,0x210F,0x2110,0x2930,0x2910,0x2910,0x2110,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2930,0x2910,0x2910,0x2110,0x2130,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x212F,0x2130,0x2930,0x212F,0x210F,0x2130,0x2130,0x2110,0x2131,0x1932,0x1932,0x1954,0x1155,0x1176,0x11B8,0x11D8,0x11F9,0x1219,0x11F8,0x11D7,0x0975,0x1154,0x1133,0x1111,0x1931,0x1931,0x2131,0x2110,0x2130,0x2110,0x2110,0x2130,0x2110,0x20EF,0x210F,0x20EF,0x210F,0x210F,0x210F,0x292F,0x292F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2130,0x212F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2111,0x1931,0x10F1,0x1112,0x1133,0x1175,0x1196,0x11D8,0x11F9,0x1A19,0x11F8,0x11D8,0x1197,0x1155,0x1134,0x1113,0x1912,0x2112,0x2111,0x2111,0x2111,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x212F,0x2130,0x212F,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x290F,0x2930,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x2130,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2930,0x2130,0x2130,0x2950,0x2930,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x2930,0x212F,0x2110,0x2930,0x2110,0x210F,0x212F,0x210F,0x2930,0x2930,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2110,0x210F,0x2110,0x2110,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x2910,0x2930,0x2910,0x2910,0x210F,0x2930,0x2930,0x2930,0x2930,0x210F,0x212F,0x212F,0x2930,0x210F,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x2110,0x2110,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x210F,0x2930,0x212F,0x212F,0x212F,0x210F,0x290F,0x290F,0x212F,0x210F,0x210F,0x292F,0x210F,0x210F,0x212F,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x2930,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x1930,0x090F,0x11D2,0x4C3B,0x3C1A,0x23D9,0x1BD9,0x1BDA,0x1BD9,0x1BFA,0x1BFA,0x1BDA,0x1BD9,0x23D9,0x2BD9,0x3BFA,0x3B57,0x0970,0x010F,0x010F,0x010F,0x09B1,0x43FA,0x341A,0x2BFA,0x2BFA,0x2BD9,0x3BD9,0x0970,0x08EE,0x190F,0x18EF,0x212F,0x214F,0x190F,0x212F,0x192F,0x090E,0x00CE,0x1A74,0x3C1A,0x33D9,0x33FA,0x33FA,0x3BFA,0x43FA,0x0130,0x0930,0x1130,0x1930,0x2110,0x2130,0x212F,0x2950,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290E,0x290E,0x290E,0x290F,0x290F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x290F,0x292F,0x212F,0x292F,0x292F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2131,0x1932,0x1932,0x1133,0x1153,0x1175,0x19D6,0x19F7,0x2217,0x19B5,0x1153,0x1131,0x1931,0x1931,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x1911,0x1932,0x1933,0x1153,0x1995,0x2217,0x2217,0x1974,0x10F2,0x1912,0x1931,0x2131,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2930,0x210F,0x290F,0x2930,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2910,0x290F,0x210F,0x2910,0x2910,0x210F,0x210F,0x2910,0x2910,0x2110,0x2930,0x290F,0x290F,0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x2930,0x210F,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2131,0x2111,0x1931,0x1932,0x1132,0x21B5,0x21F6,0x21F6,0x1974,0x1112,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x3150,0x2930,0x2930,0x290F,0x310F,0x288C,0x8AB3,0xE51C,0xDCB9,0xDC99,0xDC58,0xDC57,0xDC37,0xDC37,0xDC57,0xE457,0xDC37,0xDC16,0xDC37,0xDC36,0xDC36,0xDC36,0xDC57,0xDC57,0xDC57,0xE457,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xE457,0xE437,0xE437,0xDC37,0xE457,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC38,0xDC58,0xDC79,0xDC9A,0xDCDB,0xD51D,0x82D4,0x200A,0x28AD,0x3110,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2110,0x2110,0x2930,0x2930,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2910,0x2910,0x2110,0x2110,0x290F,0x290F,0x2930,0x2910,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2930,0x2930,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2110,0x2910,0x2910,0x210F,0x290F,0x2910,0x2910,0x2910,0x2930,0x212F,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2131,0x1911,0x1112,0x1175,0x19F8,0x1A18,0x11D8,0x0976,0x0135,0x0134,0x0134,0x0954,0x0154,0x0155,0x0996,0x19F8,0x19F8,0x19D7,0x1154,0x1112,0x1931,0x2131,0x2130,0x2130,0x2110,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x210F,0x210F,0x290F,0x210F,0x2930,0x212F,0x212F,0x2930,0x2930,0x212F,0x2130,0x2110,0x210F,0x210F,0x212F,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x292F,0x290F,0x290F,0x292F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x1931,0x1932,0x1153,0x19D6,0x19F7,0x19F6,0x1195,0x1132,0x1111,0x1931,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x2110,0x2910,0x2930,0x2110,0x210F,0x210F,0x292F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x2930,0x2930,0x2110,0x2110,0x2910,0x2110,0x2930,0x212F,0x2930,0x212F,0x212F,0x2150,0x212F,0x212F,0x1950,0x112F,0x00EE,0x014F,0x3CBB,0x1439,0x0C19,0x0418,0x0419,0x0418,0x0C19,0x0BB7,0x0273,0x01F0,0x018F,0x014E,0x014E,0x012E,0x00ED,0x00CD,0x00AD,0x00EE,0x1150,0x112F,0x1970,0x192F,0x1930,0x1930,0x1950,0x1950,0x1150,0x014F,0x016F,0x2377,0x2439,0x1419,0x0C39,0x0419,0x03F8,0x0418,0x0438,0x0438,0x0439,0x0439,0x0418,0x0419,0x0418,0x03F8,0x1439,0x1C19,0x2BD9,0x0233,0x012F,0x010E,0x1170,0x19B1,0x1170,0x092F,0x00EE,0x00EE,0x00EE,0x012F,0x014F,0x0293,0x1C39,0x0C18,0x0C39,0x0419,0x03F8,0x0439,0x0C19,0x0C19,0x0BF9,0x2C7B,0x01F2,0x0170,0x012F,0x012F,0x010F,0x092F,0x1150,0x1930,0x1930,0x1910,0x2150,0x2150,0x1930,0x1950,0x092F,0x010E,0x22F5,0x449B,0x1C19,0x1419,0x0C18,0x0C19,0x0C19,0x0C19,0x1439,0x1C3A,0x245A,0x2BB8,0x0150,0x0950,0x0930,0x1950,0x1930,0x2130,0x2150,0x2130,0x2131,0x2131,0x1911,0x1132,0x1153,0x11D6,0x1218,0x0A19,0x09F9,0x01D9,0x01D9,0x01DA,0x09FA,0x09FA,0x0A1A,0x0A1A,0x11F9,0x11D8,0x11B7,0x1196,0x1175,0x1134,0x1113,0x1112,0x1112,0x1112,0x1132,0x1933,0x1132,0x1112,0x1132,0x1932,0x1912,0x1932,0x1932,0x1132,0x1933,0x1933,0x1133,0x1133,0x1132,0x1933,0x1133,0x1132,0x1933,0x1932,0x1932,0x1953,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1953,0x1952,0x1953,0x1953,0x1932,0x1932,0x1112,0x1912,0x1932,0x1931,0x1932,0x1931,0x1931,0x1931,0x1931,0x1932,0x1953,0x1974,0x1154,0x19B6,0x21F7,0x21F7,0x21F7,0x1995,0x1112,0x1111,0x1111,0x1931,0x2151,0x2131,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2930,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x290F,0x292F,
  0x2930,0x212F,0x212F,0x2930,0x2910,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x212F,0x2930,0x2930,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1933,0x1134,0x1175,0x1196,0x11B7,0x11F9,0x1219,0x1219,0x11F8,0x11B7,0x1196,0x1154,0x1132,0x1932,0x1931,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x2110,0x1910,0x1931,0x1112,0x1133,0x1175,0x1196,0x11D7,0x1A19,0x1A19,0x19F8,0x11D8,0x1196,0x1175,0x1154,0x1933,0x1912,0x1911,0x2111,0x2111,0x2131,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x212F,0x210F,0x290F,0x210F,0x212F,0x212F,0x292F,0x210F,0x292F,0x212F,0x212F,0x292F,0x290F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x212F,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2131,0x2131,0x2151,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2110,0x2930,0x2930,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2910,0x2910,0x2930,0x210F,0x290F,0x210F,0x2910,0x2910,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x212F,0x292F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2930,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x192F,0x1930,0x1130,0x0950,0x4399,0x441A,0x33FA,0x23FA,0x23FA,0x23FA,0x23FA,0x1BDA,0x1BD9,0x23DA,0x2BFA,0x33D9,0x43DA,0x3AF6,0x090F,0x08EF,0x090F,0x010F,0x09D2,0x43FA,0x33DA,0x33FA,0x2BD9,0x33B9,0x43D9,0x094F,0x08EE,0x212F,0x212F,0x212F,0x2150,0x212F,0x192F,0x112F,0x00CE,0x0991,0x4BDA,0x3BDA,0x33DA,0x33D9,0x33DA,0x3BFA,0x43DA,0x0130,0x1150,0x1930,0x1930,0x2110,0x2130,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2910,0x2910,0x210F,0x2910,0x210F,0x290F,0x2910,0x2910,0x2910,0x2930,0x2110,0x210F,0x2130,0x210F,0x290F,0x290F,0x290F,0x290F,0x290E,0x290E,0x290F,0x290F,0x290F,0x290F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2930,0x2930,0x2930,0x212F,0x2930,0x2130,0x212F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2131,0x2131,0x1931,0x1932,0x1153,0x1174,0x1175,0x19F7,0x19F6,0x21D6,0x21B5,0x1132,0x1931,0x1931,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x1931,0x1932,0x1933,0x1133,0x1995,0x21F7,0x2217,0x1995,0x1112,0x1912,0x1931,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x2930,0x212F,0x210F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2910,0x2930,0x210F,0x210F,0x2910,0x290F,0x210F,0x2910,0x2910,0x2930,0x2930,0x2910,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x210F,0x212F,0x2130,0x212F,0x2130,0x2130,0x2110,0x2130,0x2131,0x2131,0x1931,0x1932,0x1133,0x19B5,0x21D6,0x21D6,0x1994,0x1132,0x1932,0x2151,0x2131,0x2131,0x2130,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x3130,0x3130,0x3130,0x290F,0x30EF,0x284B,0xABD8,0xE4FB,0xDC99,0xDC98,0xDC78,0xDC57,0xDC58,0xDC57,0xDC57,0xDC37,0xDC37,0xE437,0xDC37,0xDC36,0xE436,0xDC37,0xDC57,0xDC57,0xDC37,0xDC57,0xDC37,0xDC57,0xDC57,0xDC36,0xDC36,0xDC36,0xDC37,0xDC37,0xDC37,0xDC37,0xE457,0xE457,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC58,0xDC79,0xDC79,0xDCBA,0xED7E,0xABF9,0x284B,0x286C,0x28EF,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x290F,0x290F,0x2930,0x2910,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2110,0x2110,0x2910,0x210F,0x2910,0x290F,0x2910,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1932,0x1132,0x1154,0x19D7,0x11D8,0x11D8,0x0997,0x0155,0x0134,0x0134,0x0134,0x0134,0x0155,0x09B7,0x1A18,0x1A18,0x19D7,0x1154,0x1112,0x1931,0x2131,0x2110,0x2110,0x2110,0x210F,0x210F,0x2930,0x2930,0x290F,0x2930,0x2930,0x212F,0x212F,0x2930,0x210F,0x2930,0x210F,0x2930,0x2930,0x212F,0x2930,0x210F,0x212F,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x290F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x212F,0x2130,0x2130,0x212F,0x2130,0x212F,0x212F,0x210F,0x2130,0x2130,0x1931,0x1132,0x1153,0x19D6,0x19F7,0x11D6,0x11B5,0x1132,0x1931,0x1931,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2930,0x2930,0x2910,0x210F,0x2910,0x210F,0x210F,0x290F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2930,0x290F,0x2110,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x194F,0x194F,0x00EE,0x012F,0x3C9B,0x1C39,0x0BF8,0x0419,0x0C39,0x0419,0x0C19,0x0BD8,0x02B4,0x0232,0x0232,0x0232,0x0A52,0x1252,0x09F1,0x012F,0x00EE,0x00AD,0x112F,0x1950,0x1950,0x1950,0x2130,0x192F,0x1930,0x1950,0x1150,0x0950,0x016F,0x0211,0x345A,0x1C19,0x0C19,0x0C39,0x0418,0x0439,0x0438,0x0418,0x0439,0x0439,0x0418,0x0419,0x0439,0x0C39,0x1419,0x2439,0x2357,0x016F,0x010F,0x092F,0x1970,0x1950,0x1150,0x1150,0x1150,0x1150,0x092F,0x012F,0x010E,0x01F1,0x2439,0x0C18,0x0418,0x0C39,0x03F8,0x0419,0x0C39,0x0C19,0x13F9,0x347B,0x0190,0x012F,0x0150,0x0930,0x1150,0x1150,0x1930,0x1930,0x1930,0x1930,0x2130,0x2150,0x192F,0x1950,0x112F,0x010E,0x1253,0x449B,0x1BF9,0x1439,0x0C19,0x0C39,0x0C19,0x0C39,0x1439,0x1C39,0x243A,0x2398,0x0150,0x0950,0x1150,0x1130,0x1950,0x2150,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1153,0x1195,0x11D6,0x1218,0x09F9,0x09F9,0x09D9,0x09FA,0x0A1A,0x09F9,0x1219,0x09D8,0x11D8,0x11B7,0x1175,0x1174,0x1133,0x1113,0x1912,0x1912,0x1912,0x1912,0x1912,0x1912,0x1932,0x1932,0x1911,0x1911,0x1932,0x1932,0x1932,0x1932,0x1932,0x1912,0x1932,0x1912,0x1912,0x1932,0x1932,0x1912,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1952,0x1932,0x1111,0x1932,0x1911,0x1911,0x1911,0x1931,0x2131,0x1931,0x2151,0x1931,0x1931,0x1932,0x1952,0x1153,0x1994,0x19B6,0x19F7,0x2217,0x21F7,0x1995,0x1153,0x1111,0x1111,0x1931,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x212F,0x210F,0x210F,0x2130,0x210F,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x292F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x210F,0x212F,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x2930,0x290F,
  0x212F,0x210F,0x210F,0x210F,0x2910,0x210F,0x2910,0x2910,0x2910,0x2910,0x210F,0x290F,0x292F,0x290F,0x292F,0x210F,0x292F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x212F,0x2930,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2132,0x1932,0x1933,0x1133,0x1155,0x1196,0x11B7,0x1A19,0x1219,0x1219,0x11F8,0x11B6,0x1175,0x1154,0x1133,0x1952,0x1931,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x292F,0x2930,0x212F,0x2130,0x2130,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x1911,0x1911,0x1112,0x1133,0x1154,0x11B6,0x19D8,0x11F8,0x1A19,0x1A19,0x19D8,0x11B6,0x1175,0x1954,0x1933,0x1932,0x1911,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x292F,0x292F,0x210F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2110,0x210F,0x210F,0x210F,0x2130,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x1910,0x1910,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2130,0x212F,0x210F,0x212F,0x2130,0x212F,0x2130,0x210F,0x212F,0x212F,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2930,0x210F,0x212F,0x2130,0x210F,0x2110,0x2110,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x2930,0x290F,0x2930,0x2930,0x2930,0x290F,0x212F,0x212F,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x2930,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2930,0x212F,0x210F,0x212F,0x212F,0x2110,0x2110,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x290F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x1930,0x1930,0x1130,0x2234,0x43DA,0x3BFA,0x33FA,0x2BFA,0x2BDA,0x2BDA,0x23DA,0x2BDA,0x2BB9,0x33DA,0x43DA,0x4399,0x2A33,0x110F,0x08EF,0x08EF,0x010F,0x09B2,0x4C1A,0x33D9,0x33D9,0x2BB9,0x33B9,0x3B99,0x092F,0x08CE,0x210F,0x210F,0x212F,0x2130,0x192F,0x1950,0x00EE,0x2233,0x541B,0x43FA,0x3BFA,0x33DA,0x33B9,0x3BDA,0x441A,0x4BFA,0x010F,0x1130,0x1930,0x2130,0x2130,0x210F,0x212F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2910,0x2910,0x2910,0x210F,0x210F,0x2910,0x2110,0x2910,0x2910,0x2130,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x310F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2930,0x2110,0x2930,0x2930,0x290F,0x292F,0x290F,0x292F,0x2930,0x212F,0x210F,0x2130,0x210F,0x2110,0x2130,0x2130,0x2130,0x2131,0x1911,0x1931,0x1132,0x1153,0x1154,0x1195,0x21F7,0x19D6,0x29F6,0x1953,0x1131,0x1931,0x2151,0x2130,0x212F,0x210F,0x2130,0x2110,0x2131,0x1932,0x1933,0x1133,0x19B6,0x2217,0x2217,0x1995,0x1112,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x210F,0x292F,0x210F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x212F,0x210F,0x2910,0x2910,0x2110,0x2930,0x2910,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2110,0x2910,0x2930,0x2110,0x290F,0x290F,0x292F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2131,0x2131,0x1932,0x1932,0x1133,0x21D6,0x21F6,0x21D6,0x1974,0x1132,0x1932,0x2151,0x2131,0x2931,0x2930,0x2950,0x2930,0x2930,0x2930,0x2950,0x2950,0x2950,0x2930,0x2950,0x2930,0x3130,0x3130,0x3130,0x310F,0x30EE,0x282B,0xCCBB,0xE4FA,0xDC98,0xDC78,0xDC58,0xDC57,0xDC57,0xDC37,0xDC57,0xDC37,0xE457,0xDC37,0xDC37,0xDC57,0xE457,0xDC36,0xDC57,0xDC57,0xDC57,0xE457,0xDC37,0xDC36,0xDC57,0xDC57,0xE457,0xDC37,0xE457,0xDC37,0xE457,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xDC36,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC17,0xDC37,0xDC38,0xDC58,0xD479,0xDCDB,0x8293,0x38AC,0x30CE,0x28CE,0x28EF,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x2130,0x210F,0x2110,0x2110,0x2130,0x2130,0x2131,0x2132,0x1932,0x1154,0x1996,0x11B7,0x11D7,0x09D7,0x0197,0x0156,0x0156,0x0176,0x0176,0x0997,0x1A18,0x11D7,0x11D7,0x19B6,0x1154,0x1932,0x2131,0x2130,0x2110,0x2130,0x2130,0x2110,0x210F,0x2930,0x2930,0x210F,0x210F,0x2930,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x2930,0x210F,0x290F,0x290F,0x210F,0x212F,0x212F,0x210F,0x212F,0x2930,0x212F,0x212F,0x2930,0x210F,0x290F,0x210F,0x212F,0x2130,0x212F,0x2130,0x212F,0x210F,0x210F,0x2110,0x2130,0x1931,0x1132,0x1153,0x19D6,0x1A17,0x19F6,0x1194,0x1112,0x1911,0x1911,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x210F,0x2930,0x2930,0x2110,0x2910,0x2910,0x210F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x2930,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x292F,0x290F,0x292F,0x212F,0x212F,0x2130,0x212F,0x2150,0x192F,0x00EE,0x012F,0x3C7B,0x1419,0x0C18,0x0C39,0x03F8,0x0419,0x0419,0x0C19,0x1419,0x1C39,0x245A,0x2C3A,0x2C5A,0x345A,0x3C3A,0x4C5B,0x1A33,0x00CE,0x112F,0x1950,0x192F,0x212F,0x2130,0x2130,0x2130,0x1930,0x192F,0x1150,0x094F,0x016F,0x1B15,0x2C5A,0x1C5A,0x0C18,0x0419,0x0418,0x0438,0x0438,0x0438,0x0439,0x0418,0x0418,0x0419,0x0C19,0x13F9,0x343A,0x0212,0x012F,0x092F,0x1970,0x1950,0x192F,0x1950,0x192F,0x1930,0x1130,0x114F,0x094F,0x00EE,0x0190,0x2439,0x1419,0x0418,0x03F8,0x0418,0x0C19,0x03F8,0x0BF9,0x1C19,0x44BC,0x0170,0x0150,0x0950,0x1171,0x1150,0x1950,0x1950,0x1930,0x1930,0x1930,0x2130,0x192F,0x1930,0x1950,0x112F,0x012F,0x0170,0x3C3A,0x1BD8,0x0BF8,0x0BF8,0x0BF9,0x0C19,0x0C19,0x1419,0x1419,0x243A,0x23B8,0x0150,0x0950,0x1170,0x1950,0x1950,0x2130,0x2130,0x2110,0x2130,0x2131,0x2131,0x1931,0x1952,0x1974,0x1195,0x11D6,0x11D7,0x11D8,0x11F9,0x09D8,0x11F9,0x11F9,0x11D8,0x11B7,0x1196,0x1175,0x1174,0x1933,0x1932,0x1932,0x1931,0x1911,0x1911,0x2131,0x1931,0x1911,0x1931,0x1931,0x1931,0x1931,0x2132,0x1911,0x1931,0x2131,0x1911,0x1911,0x1931,0x1931,0x1931,0x1911,0x1911,0x1911,0x1911,0x1931,0x1931,0x1911,0x1911,0x1931,0x1931,0x1911,0x1931,0x1931,0x1951,0x1931,0x1931,0x1931,0x1931,0x1911,0x2131,0x2131,0x2131,0x2131,0x2131,0x1931,0x1931,0x1931,0x1132,0x1133,0x1174,0x19D6,0x2217,0x2217,0x19D7,0x1995,0x1133,0x1111,0x1111,0x1931,0x2151,0x2130,0x2130,0x2110,0x2130,0x2110,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2930,0x2930,
  0x212F,0x212F,0x212F,0x2110,0x2910,0x2930,0x2910,0x2910,0x2910,0x2930,0x2910,0x2910,0x210F,0x290F,0x292F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2110,0x2110,0x2110,0x2110,0x2910,0x210F,0x2930,0x210F,0x210F,0x290F,0x290F,0x2910,0x210F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x1932,0x1933,0x1154,0x1155,0x1196,0x11D7,0x11F8,0x1219,0x1218,0x19F8,0x19D7,0x1175,0x1174,0x1133,0x1912,0x1932,0x2111,0x2131,0x2931,0x2130,0x2110,0x2930,0x292F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1910,0x1911,0x1112,0x1153,0x1175,0x1196,0x11D7,0x1A18,0x1A18,0x1A18,0x19D7,0x1196,0x1175,0x1954,0x1113,0x1912,0x1912,0x1912,0x1932,0x1931,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x2930,0x212F,0x210F,0x210F,0x210F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x210F,0x290F,0x2930,0x2110,0x210F,0x212F,0x2110,0x2130,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1931,0x1931,0x1930,0x2151,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2110,0x2130,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x2130,0x210F,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x2910,0x290F,0x2930,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2110,0x2110,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2910,0x2910,0x210F,0x210F,0x290F,0x290F,0x210F,0x212F,0x212F,0x292F,0x212F,0x212F,0x212F,0x292F,0x292F,0x212F,0x212F,0x292F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2110,0x210F,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x2130,0x1930,0x1130,0x1171,0x3B38,0x43FA,0x3BDA,0x33DA,0x2BD9,0x2BDA,0x2BDA,0x33DA,0x33BA,0x43DA,0x4B99,0x2A54,0x110F,0x10EE,0x190F,0x08EF,0x010F,0x11B2,0x4C1B,0x3BDA,0x33DA,0x33DA,0x3BDA,0x4379,0x090F,0x08AE,0x210F,0x212F,0x212F,0x2130,0x1930,0x110F,0x21F2,0x53DA,0x4BDA,0x43DA,0x3BB9,0x33B9,0x3BBA,0x43DA,0x4C1B,0x4399,0x00EF,0x1130,0x1930,0x2130,0x2130,0x210F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2910,0x2910,0x2910,0x2930,0x210F,0x210F,0x290F,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x2930,0x212F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x2130,0x2130,0x210F,0x210F,0x212F,0x2130,0x2130,0x2110,0x2131,0x1931,0x1932,0x1132,0x1133,0x1174,0x19D6,0x21F6,0x21D6,0x1973,0x1112,0x1931,0x2131,0x2150,0x2130,0x2130,0x2130,0x2130,0x2131,0x1932,0x1933,0x1133,0x19B6,0x2A17,0x21F7,0x1995,0x1112,0x1932,0x1931,0x2131,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x210F,0x292F,0x292F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x2930,0x292F,0x210F,0x2910,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x2930,0x290F,0x2910,0x2910,0x290F,0x2910,0x2910,0x2110,0x210F,0x290F,0x2930,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2110,0x2131,0x2131,0x1932,0x1932,0x1133,0x21D6,0x21F6,0x21F6,0x1974,0x1112,0x1952,0x2152,0x2131,0x2931,0x2930,0x2930,0x2930,0x2930,0x2950,0x2930,0x2950,0x2950,0x2950,0x2930,0x3151,0x3130,0x3130,0x3110,0x310F,0x30AE,0x38AC,0xE53D,0xDCB9,0xDC78,0xDC78,0xDC57,0xDC57,0xDC57,0xE457,0xDC57,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC57,0xDC36,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xDC17,0xDC37,0xDC38,0xDC58,0xDC99,0xDCDB,0x7A11,0x302A,0x410E,0x30EE,0x28EE,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x2930,0x2930,0x2930,0x2930,0x2110,0x2930,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x2930,0x2930,0x290F,0x210F,0x290F,0x210F,0x2930,0x290F,0x290F,0x2930,0x2910,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2930,0x2110,0x2110,0x2930,0x2110,0x210F,0x2130,0x2130,0x2131,0x2131,0x1932,0x1933,0x1175,0x19B6,0x19F8,0x1218,0x1219,0x11F8,0x11F8,0x11D8,0x11D8,0x1A18,0x19F8,0x19D7,0x1175,0x1154,0x1953,0x1932,0x2131,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2930,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2130,0x212F,0x212F,0x212F,0x2930,0x210F,0x2930,0x212F,0x212F,0x2930,0x2930,0x212F,0x2930,0x2930,0x290F,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x212F,0x210F,0x290F,0x2930,0x290F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x1931,0x1932,0x0933,0x19D6,0x19F7,0x19D6,0x11B5,0x1112,0x1911,0x1911,0x2130,0x2130,0x2110,0x2130,0x212F,0x212F,0x212F,0x2930,0x2930,0x2910,0x2110,0x2930,0x2910,0x290F,0x292F,0x290F,0x290F,0x290F,0x292F,0x290F,0x292F,0x290F,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2110,0x2930,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x192F,0x192F,0x00EE,0x012F,0x3C5A,0x1C19,0x1439,0x0418,0x0C19,0x0419,0x0419,0x0C19,0x0C19,0x0C19,0x1419,0x13F9,0x1C19,0x1BF8,0x23F9,0x3C3A,0x1212,0x00CE,0x1130,0x1930,0x192F,0x212F,0x2130,0x2130,0x212F,0x192F,0x1950,0x112F,0x1170,0x016F,0x01B0,0x343A,0x245A,0x1439,0x03F8,0x0419,0x0439,0x0459,0x0439,0x0439,0x0418,0x0C39,0x0C19,0x1419,0x2419,0x2377,0x012F,0x012F,0x1150,0x1150,0x1950,0x192F,0x192F,0x192F,0x192F,0x1930,0x112F,0x1150,0x010E,0x014F,0x2C3A,0x0BF8,0x0C19,0x0C39,0x0C19,0x0BF9,0x1439,0x13F9,0x1C19,0x343A,0x0150,0x0950,0x0950,0x1150,0x1130,0x1950,0x1950,0x1930,0x1930,0x192F,0x2130,0x192F,0x1950,0x192F,0x1150,0x010F,0x010F,0x2B77,0x23F9,0x1419,0x0BF8,0x0C19,0x0BF9,0x0C19,0x13F9,0x13F9,0x2C5A,0x2398,0x0150,0x0950,0x1150,0x1950,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1953,0x1154,0x1175,0x1196,0x11B6,0x11D7,0x11D7,0x11D7,0x11B7,0x1196,0x1195,0x1174,0x1153,0x1932,0x1932,0x1911,0x1911,0x2131,0x2131,0x2131,0x2111,0x2131,0x2110,0x2131,0x2131,0x2110,0x2111,0x2131,0x2131,0x2131,0x1910,0x2110,0x2110,0x2130,0x2130,0x2111,0x2110,0x2131,0x2110,0x2111,0x1910,0x2131,0x2131,0x2111,0x1910,0x2110,0x1910,0x2131,0x1930,0x1930,0x1930,0x1931,0x1930,0x1930,0x1910,0x2130,0x2110,0x2110,0x2110,0x2131,0x1931,0x1931,0x1132,0x1953,0x1994,0x19B5,0x2217,0x1A17,0x21F7,0x19B5,0x1133,0x1112,0x1111,0x1931,0x2151,0x2150,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2110,0x210F,0x2910,0x290F,0x210F,0x290F,0x212F,0x210F,0x2930,0x210F,0x210F,0x2930,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2110,
  0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x210F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x2110,0x2110,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x2131,0x1931,0x1952,0x1953,0x1154,0x1175,0x1176,0x11B7,0x11F8,0x1218,0x1A39,0x19F8,0x19D7,0x1175,0x1134,0x1933,0x1932,0x2132,0x2111,0x2110,0x2110,0x2130,0x2930,0x212F,0x292F,0x292F,0x292F,0x292F,0x290F,0x292F,0x290F,0x290F,0x292F,0x212F,0x2130,0x2930,0x2130,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x1931,0x1932,0x1932,0x1133,0x1175,0x1196,0x11D7,0x1A39,0x1A39,0x11D8,0x11D7,0x1196,0x1175,0x1133,0x1133,0x1112,0x1932,0x1932,0x1932,0x1932,0x1931,0x1931,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x290F,0x292F,0x292F,0x210F,0x290F,0x212F,0x292F,0x210F,0x212F,0x2930,0x2930,0x212F,0x212F,0x2930,0x210F,0x212F,0x2110,0x2130,0x292F,0x212F,0x290F,0x292F,0x292F,0x290F,0x290F,0x292F,0x2130,0x2130,0x2150,0x2130,0x2131,0x2131,0x1931,0x1932,0x1932,0x1132,0x1132,0x1932,0x1952,0x1952,0x1952,0x1951,0x1931,0x1931,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2930,0x2110,0x2110,0x2930,0x2110,0x2910,0x2910,0x2110,0x2110,0x2110,0x210F,0x290F,0x292F,0x212F,0x212F,0x2930,0x210F,0x2930,0x2930,0x210F,0x212F,0x210F,0x2930,0x292F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2930,0x210F,0x2930,0x290F,0x2930,0x2930,0x2930,0x210F,0x2930,0x212F,0x2930,0x290F,0x2930,0x210F,0x2930,0x210F,0x212F,0x212F,0x290F,0x290F,0x2930,0x2930,0x2930,0x290F,0x2930,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,0x210F,0x210F,0x290F,0x2930,0x210F,0x210F,0x2110,0x210F,0x210F,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1930,0x1910,0x1110,0x19D2,0x4BDA,0x43DA,0x3BDA,0x33B9,0x33B9,0x3BBA,0x43DA,0x439A,0x4379,0x3295,0x1130,0x10EE,0x18EE,0x2150,0x192F,0x00EE,0x19D2,0x4BFB,0x3BB9,0x3BDA,0x3BDA,0x3BBA,0x4399,0x090F,0x10AE,0x2110,0x2130,0x2130,0x1950,0x00CE,0x2A13,0x5BFB,0x4BBA,0x4BBA,0x3B99,0x3BB9,0x43DA,0x3BBA,0x43DA,0x541B,0x32B6,0x1150,0x1950,0x1930,0x2130,0x2130,0x2930,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2910,0x2910,0x2930,0x2110,0x2930,0x212F,0x210F,0x2110,0x2930,0x2930,0x210F,0x2110,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x2930,0x2130,0x210F,0x2110,0x2130,0x2130,0x2110,0x2110,0x2930,0x2930,0x2910,0x210F,0x290F,0x212F,0x2130,0x212F,0x210F,0x210F,0x212F,0x2130,0x2110,0x2130,0x2130,0x1931,0x1931,0x1132,0x1132,0x1153,0x19B6,0x21D6,0x21D6,0x1154,0x1132,0x1932,0x1951,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1912,0x1134,0x21B6,0x2A17,0x2217,0x1995,0x1112,0x1932,0x1931,0x2131,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2910,0x2910,0x212F,0x210F,0x2930,0x2910,0x210F,0x210F,0x2930,0x290F,0x210F,0x212F,0x212F,0x210F,0x290F,0x2930,0x210F,0x210F,0x2930,0x2110,0x2930,0x2910,0x2910,0x290F,0x2930,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2131,0x2131,0x1932,0x1932,0x1153,0x21D6,0x21D6,0x21F6,0x1995,0x1132,0x1952,0x2152,0x2131,0x2131,0x2930,0x2930,0x2930,0x2950,0x2950,0x2950,0x2950,0x2950,0x2930,0x2950,0x3130,0x3131,0x3131,0x3110,0x30EF,0x308D,0x596F,0xE55C,0xDCB9,0xDC98,0xDC78,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC37,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xE457,0xE457,0xE457,0xDC37,0xDC37,0xE457,0xDC37,0xDC57,0xDC37,0xDC37,0xDC16,0xDC37,0xDC37,0xDC37,0xDC16,0xDC17,0xDC37,0xDC37,0xDC17,0xDC37,0xDC17,0xDC58,0xDC59,0xDCBA,0xAB56,0x3009,0x410E,0x392F,0x310F,0x312F,0x3130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x2910,0x2930,0x290F,0x210F,0x210F,0x2930,0x2930,0x290F,0x292F,0x292F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2910,0x210F,0x2910,0x2930,0x212F,0x212F,0x2130,0x2930,0x2930,0x2110,0x2130,0x2130,0x2130,0x2131,0x1931,0x1912,0x1133,0x1995,0x19F7,0x1A38,0x1A59,0x1A39,0x1A19,0x19F8,0x1A18,0x2259,0x2238,0x19B6,0x1154,0x1953,0x1932,0x1931,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2930,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x212F,0x292F,0x292F,0x212F,0x210F,0x210F,0x2930,0x2930,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x2130,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1133,0x19D6,0x19F6,0x11D6,0x1195,0x1112,0x1931,0x2131,0x2110,0x2110,0x2130,0x210F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2930,0x2930,0x2910,0x290F,0x290F,0x292F,0x290F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2930,0x210F,0x2110,0x2930,0x2110,0x2110,0x210F,0x292F,0x2930,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x2130,0x1930,0x192F,0x00EE,0x012F,0x449B,0x1C39,0x1439,0x0C39,0x0C18,0x0C19,0x0C19,0x0C19,0x0C19,0x0C19,0x0C19,0x1439,0x1419,0x13D8,0x1BF8,0x343A,0x01B1,0x00CE,0x1150,0x1950,0x2150,0x2150,0x212F,0x212F,0x212F,0x2130,0x2150,0x1950,0x1170,0x0970,0x012F,0x0A73,0x347B,0x1C3A,0x0C19,0x0419,0x0418,0x0439,0x0439,0x0418,0x0439,0x0419,0x1419,0x2419,0x2BF9,0x01D1,0x010E,0x114F,0x114F,0x1950,0x192F,0x2150,0x212F,0x2150,0x192F,0x192F,0x192F,0x114F,0x010E,0x0170,0x343A,0x13F9,0x1419,0x0C19,0x0BF8,0x0C19,0x0BD8,0x1C19,0x243A,0x341A,0x0150,0x0950,0x0950,0x1150,0x1130,0x1950,0x1930,0x190F,0x212F,0x212F,0x212F,0x2150,0x192F,0x1950,0x1950,0x092F,0x00EE,0x1274,0x23B8,0x13F8,0x0BF8,0x0C19,0x0C19,0x1419,0x13F9,0x1C19,0x2C1A,0x2398,0x0150,0x0950,0x1150,0x1150,0x1930,0x190F,0x2110,0x210F,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1132,0x1153,0x1154,0x1174,0x1175,0x1195,0x1175,0x1175,0x1174,0x1173,0x1132,0x1952,0x1931,0x1931,0x2111,0x2131,0x2131,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x1930,0x1930,0x1910,0x2130,0x2131,0x2151,0x2130,0x2131,0x1910,0x1911,0x1932,0x1953,0x1174,0x19D5,0x19F6,0x2217,0x2217,0x1995,0x1133,0x1112,0x1111,0x1910,0x2130,0x2150,0x2130,0x2110,0x20EF,0x210F,0x2130,0x2130,0x2130,0x210F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2110,0x210F,0x210F,0x2930,0x290F,0x210F,0x290F,0x292F,0x292F,0x292F,0x210F,0x212F,0x210F,0x210F,0x2130,0x2130,0x212F,0x2130,0x210F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2930,
  0x292F,0x212F,0x292F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x210F,0x290F,0x292F,0x292F,0x290F,0x290F,0x2910,0x290F,0x212F,0x2930,0x2110,0x210F,0x2930,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x2930,0x210F,0x210F,0x212F,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2131,0x2131,0x1932,0x1932,0x1153,0x1153,0x1154,0x1175,0x11B7,0x1A18,0x1218,0x1A19,0x19F8,0x11B7,0x1176,0x1134,0x1933,0x1912,0x2131,0x2111,0x2130,0x2130,0x2130,0x2130,0x2950,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x290F,0x292F,0x212F,0x2130,0x210F,0x2130,0x2930,0x2930,0x2910,0x2110,0x2110,0x2110,0x2110,0x212F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x2131,0x1911,0x1911,0x1912,0x1133,0x1174,0x11B6,0x11D7,0x1A18,0x1A39,0x11F8,0x11D7,0x11B6,0x1195,0x1154,0x1134,0x1133,0x1133,0x1133,0x1132,0x1932,0x1932,0x1932,0x1931,0x1931,0x2131,0x1910,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2110,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2930,0x2110,0x2130,0x2110,0x2110,0x210F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x2930,0x212F,0x2130,0x2130,0x1931,0x1931,0x1932,0x1932,0x1153,0x1974,0x1994,0x1994,0x19B5,0x1994,0x1974,0x1973,0x1973,0x1953,0x1932,0x1931,0x1931,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x2130,0x210F,0x2130,0x2110,0x2110,0x2110,0x210F,0x2110,0x2110,0x210F,0x210F,0x2110,0x2110,0x210F,0x212F,0x212F,0x212F,0x212F,0x2930,0x290F,0x290F,0x212F,0x2930,0x2130,0x210F,0x210F,0x212F,0x2930,0x2930,0x212F,0x212F,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x2930,0x290F,0x2930,0x290F,0x2930,0x290F,0x2930,0x212F,0x2930,0x2930,0x290F,0x2930,0x210F,0x290F,0x2930,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x210F,0x290F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x292F,0x290F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x2110,0x212F,0x212F,0x2930,0x212F,0x210F,0x212F,0x2130,0x2130,0x210F,0x190F,0x1910,0x1110,0x0910,0x4338,0x4BBA,0x43DA,0x3BB9,0x3BDA,0x43BA,0x4BDB,0x3B38,0x19B2,0x08EF,0x10CE,0x18EE,0x212F,0x2150,0x190F,0x08CE,0x19B2,0x541B,0x3B99,0x43FB,0x43DA,0x4399,0x4B79,0x0910,0x08AE,0x2110,0x2110,0x190F,0x10EF,0x3254,0x5BBA,0x539A,0x4B99,0x439A,0x439A,0x43BA,0x43BA,0x4BDA,0x4BDA,0x4B99,0x1171,0x1150,0x1950,0x2130,0x210F,0x2130,0x2930,0x2130,0x210F,0x210F,0x212F,0x212F,0x2930,0x212F,0x2130,0x2910,0x2110,0x2910,0x2910,0x2110,0x2110,0x2130,0x2130,0x2130,0x2930,0x210F,0x210F,0x210F,0x2110,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x212F,0x292F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2110,0x2130,0x210F,0x2110,0x2930,0x2910,0x2910,0x2930,0x290F,0x210F,0x212F,0x210F,0x210F,0x2130,0x212F,0x2130,0x2130,0x2130,0x1930,0x1931,0x1932,0x1132,0x1133,0x19D6,0x21F7,0x1995,0x1974,0x1133,0x1932,0x2151,0x2130,0x2130,0x2130,0x2110,0x2130,0x2131,0x1932,0x1933,0x1133,0x1996,0x21F7,0x2A17,0x19B5,0x1112,0x1932,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x210F,0x2930,0x2910,0x212F,0x2930,0x2930,0x290F,0x212F,0x212F,0x212F,0x210F,0x290F,0x2930,0x210F,0x212F,0x212F,0x2930,0x2910,0x2910,0x210F,0x2930,0x2910,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x210F,0x292F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2110,0x2131,0x1932,0x1932,0x1153,0x21D6,0x21F6,0x21D6,0x1995,0x1112,0x1952,0x2152,0x2151,0x2931,0x2931,0x2930,0x2950,0x2930,0x2950,0x3150,0x2950,0x2950,0x3151,0x2930,0x3130,0x3130,0x3131,0x3130,0x30EF,0x308C,0x7A73,0xE55C,0xDCB9,0xDC78,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xE437,0xE437,0xDC37,0xE437,0xE457,0xDC37,0xDC37,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC17,0xDC37,0xDC17,0xDC37,0xDC17,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC38,0xDC58,0xDC79,0xCC39,0x404A,0x308C,0x390E,0x310F,0x310F,0x312F,0x2930,0x2930,0x2930,0x2930,0x2950,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x212F,0x290F,0x2930,0x2930,0x290F,0x2930,0x2910,0x2910,0x2930,0x290F,0x2930,0x290F,0x290F,0x292F,0x290F,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2130,0x2130,0x2130,0x2131,0x2111,0x1931,0x1932,0x1133,0x1995,0x11B5,0x19F7,0x19D7,0x11B6,0x11B6,0x19B6,0x19B6,0x1195,0x1154,0x1133,0x1932,0x1931,0x1931,0x2130,0x2130,0x2110,0x2130,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2110,0x212F,0x212F,0x210F,0x210F,0x212F,0x2930,0x210F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x290F,0x210F,0x210F,0x212F,0x212F,0x2110,0x210F,0x210F,0x2910,0x210F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1133,0x19D6,0x19F7,0x19D7,0x1195,0x1132,0x1911,0x2131,0x2110,0x2130,0x2930,0x210F,0x210F,0x292F,0x292F,0x2130,0x2130,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x210F,0x212F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x290F,0x290F,0x292F,0x2930,0x292F,0x292F,0x2930,0x212F,0x2130,0x1930,0x1930,0x08EE,0x012F,0x447B,0x243A,0x1C39,0x0C19,0x0C18,0x0C19,0x0C19,0x0C39,0x0C19,0x0BF9,0x0BF9,0x0BF9,0x1419,0x1419,0x1C19,0x3C5A,0x0190,0x00AD,0x1950,0x2170,0x2150,0x2150,0x212F,0x212F,0x2150,0x2130,0x2130,0x1950,0x114F,0x1150,0x0950,0x0150,0x2BD9,0x243A,0x13F9,0x0C19,0x0C19,0x0419,0x0419,0x0C39,0x0C19,0x0C39,0x1419,0x2C1A,0x2B98,0x010E,0x012F,0x1150,0x112F,0x192F,0x212F,0x2130,0x212F,0x212F,0x212F,0x192F,0x192F,0x194F,0x010E,0x014F,0x341A,0x1C19,0x1C19,0x0BF8,0x0BF8,0x13F9,0x1C19,0x1BF9,0x2C1A,0x2BD9,0x012F,0x0950,0x1150,0x1150,0x1950,0x1930,0x192F,0x192F,0x212F,0x212F,0x212F,0x212F,0x212F,0x1950,0x1950,0x112F,0x00EE,0x09F2,0x341A,0x1BF9,0x13F9,0x1419,0x0BF9,0x13F9,0x1C19,0x1BF9,0x2C3A,0x2378,0x0150,0x0950,0x1150,0x1950,0x1930,0x2130,0x2130,0x2130,0x2130,0x2931,0x2130,0x2110,0x2131,0x2131,0x1932,0x1932,0x1932,0x1133,0x1133,0x1133,0x1133,0x1953,0x1132,0x1132,0x1131,0x1931,0x1931,0x2131,0x2131,0x2131,0x2131,0x2130,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2130,0x2930,0x2110,0x210F,0x2130,0x2110,0x2110,0x210F,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2151,0x2131,0x1931,0x1911,0x1932,0x1953,0x1174,0x19D6,0x2217,0x2217,0x19F6,0x1195,0x1153,0x1152,0x1111,0x1931,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x2930,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2910,0x2110,0x2930,0x2910,0x210F,0x2930,0x292F,0x292F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x2930,0x210F,0x210F,0x2930,0x210F,0x212F,0x2130,0x210F,0x2930,0x2930,
  0x292F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x210F,0x210F,0x212F,0x292F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x2910,0x2910,0x2930,0x290F,0x2930,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2131,0x2131,0x2132,0x1932,0x1132,0x1133,0x1154,0x1195,0x11B7,0x19F8,0x1A19,0x11F9,0x11D8,0x1197,0x1176,0x1134,0x1133,0x1932,0x2131,0x1911,0x2131,0x2130,0x2130,0x2150,0x2150,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2910,0x2110,0x210F,0x210F,0x290F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2951,0x2951,0x2131,0x2131,0x1911,0x1112,0x1133,0x1154,0x1196,0x11D7,0x1A18,0x1A18,0x11F8,0x11D7,0x11B7,0x0996,0x0975,0x0954,0x1154,0x1134,0x1133,0x1133,0x1133,0x1952,0x1932,0x1932,0x1931,0x2131,0x2131,0x2131,0x1910,0x2110,0x2110,0x2130,0x2110,0x2130,0x2110,0x2110,0x210F,0x210F,0x2930,0x2110,0x210F,0x212F,0x2930,0x2110,0x290F,0x290F,0x210F,0x210F,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2930,0x2110,0x2910,0x210F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x212F,0x2150,0x2130,0x2131,0x1931,0x1932,0x1133,0x1154,0x1995,0x19D6,0x19F7,0x19F7,0x19F7,0x1A17,0x19F7,0x19D6,0x11B5,0x1195,0x1153,0x1112,0x1932,0x1951,0x2151,0x2151,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2151,0x2131,0x2130,0x2130,0x2130,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2131,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x290F,0x2930,0x210F,0x212F,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x2130,0x210F,0x210F,0x212F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x212F,0x210F,0x210F,0x2930,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2110,0x2930,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x212F,0x2130,0x190F,0x18EF,0x08EF,0x21F3,0x53DA,0x4BDA,0x43B9,0x43BA,0x43BA,0x4359,0x21F4,0x008E,0x10AE,0x10CE,0x212F,0x212F,0x2130,0x190F,0x08CF,0x19B2,0x5C1C,0x4BDB,0x43BA,0x43BA,0x439A,0x53BA,0x0910,0x10AF,0x2110,0x18EF,0x1930,0x5318,0x63FB,0x5BBA,0x4B79,0x4B59,0x4B7A,0x4BBA,0x4B9A,0x4BBA,0x4BBA,0x539A,0x1191,0x0910,0x1930,0x1930,0x2130,0x2130,0x2130,0x2930,0x2930,0x292F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x210F,0x290F,0x292F,0x292F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x210F,0x2930,0x2950,0x2130,0x1930,0x1931,0x1931,0x1153,0x1133,0x19D6,0x21F7,0x1995,0x1154,0x1133,0x1932,0x1931,0x2151,0x2130,0x2130,0x2130,0x2130,0x1910,0x1911,0x1912,0x1133,0x21B6,0x21F7,0x21F7,0x1995,0x1112,0x1912,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x212F,0x212F,0x2930,0x290F,0x212F,0x212F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x210F,0x2110,0x2930,0x210F,0x2930,0x2930,0x290F,0x210F,0x2910,0x2910,0x210F,0x2910,0x2110,0x2110,0x2930,0x290F,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2110,0x2130,0x2130,0x2131,0x2131,0x1932,0x1132,0x1153,0x21D6,0x21F6,0x21D6,0x1995,0x1112,0x1952,0x2152,0x2151,0x2131,0x2931,0x2931,0x2951,0x2930,0x2930,0x2950,0x3150,0x2950,0x2950,0x3151,0x3130,0x3151,0x3131,0x310F,0x390F,0x308C,0x9336,0xE51C,0xDC99,0xDC98,0xDC78,0xDC57,0xDC57,0xDC37,0xDC37,0xDC36,0xDC37,0xE457,0xDC37,0xE457,0xDC37,0xDC57,0xDC36,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC37,0xDC37,0xE457,0xDC37,0xE437,0xDC37,0xDC37,0xDC16,0xDC16,0xDC37,0xDC37,0xDC37,0xDC37,0xDC38,0xDC38,0xDC58,0xDC59,0xE4FB,0x614E,0x2009,0x28AC,0x310E,0x310F,0x290F,0x290F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x290F,0x292F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2910,0x2930,0x290F,0x290F,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2131,0x2111,0x1911,0x1932,0x1932,0x1953,0x1953,0x1133,0x1954,0x1153,0x1133,0x1953,0x1933,0x1932,0x1931,0x1911,0x2131,0x2130,0x2110,0x2130,0x2110,0x2930,0x2930,0x2910,0x2110,0x2930,0x212F,0x210F,0x2130,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x212F,0x212F,0x210F,0x2930,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2930,0x2930,0x2930,0x290F,0x210F,0x210F,0x2910,0x2910,0x2110,0x2910,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1133,0x19D6,0x19F7,0x19F7,0x1195,0x1132,0x1911,0x2131,0x2131,0x2130,0x2930,0x210F,0x210F,0x210F,0x292F,0x2930,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x290F,0x290F,0x292F,0x292F,0x292F,0x212F,0x2930,0x2130,0x2130,0x1930,0x08EF,0x010F,0x3C3B,0x23F9,0x1C19,0x1419,0x0BD8,0x0BD8,0x0BF9,0x0BF9,0x141A,0x0C19,0x1419,0x1419,0x13F9,0x1BF9,0x1BF9,0x44BC,0x09D1,0x00CE,0x1130,0x1930,0x2150,0x192F,0x2150,0x2130,0x2130,0x212F,0x2130,0x192F,0x1950,0x1970,0x092F,0x010F,0x0253,0x241A,0x13F9,0x13F9,0x1419,0x0C19,0x0C19,0x0C39,0x0C19,0x1419,0x1BF9,0x343A,0x1AB5,0x010E,0x010F,0x1150,0x1950,0x192F,0x212F,0x212F,0x2150,0x212F,0x210F,0x212F,0x2150,0x1950,0x08EE,0x012F,0x33D9,0x23D9,0x1BF9,0x1BF9,0x13D8,0x13D9,0x13D9,0x23F9,0x2C1A,0x33D9,0x012F,0x0950,0x1150,0x1950,0x1950,0x1950,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x192F,0x192F,0x192F,0x112F,0x00EF,0x11F2,0x3C5B,0x2419,0x1C19,0x1419,0x0BD8,0x13D9,0x1BF9,0x241A,0x343A,0x2B98,0x0150,0x0950,0x1150,0x1930,0x2130,0x2130,0x2110,0x2110,0x2930,0x2910,0x2110,0x2110,0x2111,0x2131,0x2131,0x1931,0x1932,0x1932,0x1932,0x1932,0x1932,0x1932,0x1952,0x1951,0x1951,0x1931,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2130,0x210F,0x210F,0x2930,0x2130,0x212F,0x2130,0x212F,0x2130,0x210F,0x2130,0x2130,0x2130,0x210F,0x212F,0x2130,0x2930,0x2930,0x2130,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2131,0x1911,0x1932,0x1953,0x1174,0x19F6,0x21F7,0x21F7,0x19D6,0x1995,0x1153,0x1132,0x1131,0x1931,0x1931,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x212F,0x210F,0x2910,0x2910,0x2910,0x210F,0x210F,0x2930,0x210F,0x292F,0x292F,
  0x292F,0x292F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x210F,0x210F,0x292F,0x292F,0x290F,0x210F,0x290F,0x2930,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x2930,0x2930,0x2930,0x210F,0x210F,0x292F,0x212F,0x210F,0x2130,0x2930,0x2910,0x2110,0x2110,0x2130,0x2130,0x1931,0x1931,0x1932,0x1132,0x1153,0x1174,0x1195,0x11B7,0x11D8,0x11F9,0x19F9,0x11D8,0x11B7,0x1175,0x1154,0x1133,0x1932,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2930,0x2930,0x212F,0x212F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x2110,0x2930,0x2110,0x2930,0x2130,0x2131,0x2131,0x1911,0x1932,0x1132,0x1133,0x1175,0x1196,0x11F7,0x1A19,0x11F8,0x11F8,0x11F8,0x09D7,0x0996,0x0996,0x0975,0x0954,0x1154,0x1154,0x1154,0x1154,0x1953,0x1953,0x1952,0x1932,0x2131,0x1931,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x210F,0x2110,0x210F,0x2110,0x210F,0x210F,0x2110,0x2110,0x210F,0x210F,0x2910,0x2110,0x2110,0x210F,0x210F,0x2110,0x210F,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2130,0x2130,0x1931,0x1932,0x1112,0x1153,0x1195,0x19F7,0x19F7,0x1A17,0x1A17,0x19F7,0x1A18,0x1A18,0x19F7,0x19F7,0x19D6,0x1195,0x0933,0x1133,0x1952,0x1931,0x1931,0x2131,0x1931,0x1931,0x1931,0x1931,0x1931,0x1931,0x2131,0x2131,0x1931,0x2131,0x2131,0x2111,0x2131,0x2111,0x2111,0x2111,0x2131,0x2131,0x2111,0x2111,0x2111,0x2131,0x1911,0x1911,0x1910,0x2131,0x2111,0x2111,0x2131,0x2111,0x2111,0x2111,0x2111,0x2111,0x2111,0x2131,0x2131,0x2131,0x2111,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x212F,0x212F,0x210F,0x2130,0x2110,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2930,0x290F,0x2930,0x292F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x212F,0x290F,0x290F,0x210F,0x210F,0x2110,0x2110,0x210F,0x2110,0x2110,0x212F,0x212F,0x2130,0x210F,0x2110,0x290F,0x290F,0x212F,0x212F,0x290F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2930,0x2130,0x210F,0x2110,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2910,0x2910,0x2910,0x290F,0x210F,0x2110,0x2130,0x2130,0x2130,0x210F,0x2130,0x210F,0x212F,0x210F,0x212F,0x2110,0x18EF,0x10EF,0x1971,0x5BDA,0x53DA,0x4BDA,0x4BBA,0x4B9A,0x4B79,0x1951,0x088E,0x10AE,0x2110,0x212F,0x210F,0x190F,0x18EF,0x10CF,0x21B2,0x5BDB,0x4BBA,0x4BBA,0x4B9A,0x4B9A,0x539A,0x08EF,0x10AF,0x10CF,0x18F0,0x5318,0x6BDB,0x63BB,0x5B9A,0x4B7A,0x4B7A,0x4B9A,0x4BBA,0x4BBA,0x4B9A,0x539A,0x19B2,0x090F,0x1110,0x1910,0x2130,0x2130,0x2110,0x2930,0x2930,0x2930,0x292F,0x210F,0x212F,0x212F,0x292F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2910,0x2910,0x2910,0x2110,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2110,0x2930,0x290F,0x290F,0x292F,0x290F,0x290F,0x292F,0x212F,0x212F,0x212F,0x210F,0x2950,0x2130,0x210F,0x1910,0x1930,0x1952,0x1132,0x1133,0x19B6,0x21F7,0x21B6,0x1974,0x1133,0x1952,0x1951,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x21B6,0x21F7,0x21F7,0x1995,0x1112,0x1912,0x2131,0x2131,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x212F,0x2930,0x210F,0x212F,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2910,0x210F,0x2910,0x210F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2930,0x2110,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1132,0x1153,0x21D6,0x21F6,0x21F6,0x19B5,0x1133,0x1953,0x2152,0x2151,0x2951,0x2931,0x2951,0x2950,0x2950,0x2930,0x2950,0x2950,0x3150,0x3151,0x3150,0x3151,0x3151,0x3950,0x310F,0x38EE,0x308C,0xABD8,0xDCFB,0xDCB9,0xDC78,0xDC78,0xDC57,0xDC37,0xDC57,0xDC37,0xDC57,0xDC37,0xDC37,0xDC36,0xE457,0xDC37,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xE437,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC17,0xDC17,0xDC37,0xDC17,0xDC17,0xDC17,0xDC17,0xDC37,0xDC17,0xDC37,0xDC38,0xDC38,0xDC9A,0xC3F8,0x2808,0x306B,0x30CD,0x30EE,0x310F,0x290F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x2930,0x2930,0x2930,0x212F,0x2930,0x2930,0x2910,0x2930,0x210F,0x210F,0x2930,0x290F,0x2910,0x2910,0x210F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x2910,0x2910,0x2910,0x2930,0x290F,0x2910,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2111,0x1911,0x1911,0x1911,0x1911,0x1912,0x1932,0x1911,0x1911,0x1931,0x1911,0x1911,0x1931,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2110,0x210F,0x2930,0x210F,0x2130,0x2130,0x212F,0x212F,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2110,0x212F,0x212F,0x210F,0x290F,0x2930,0x2910,0x210F,0x2930,0x2910,0x2110,0x2910,0x2110,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2130,0x1931,0x1932,0x1133,0x11D6,0x1A17,0x19D7,0x1995,0x1132,0x1911,0x2131,0x2131,0x2130,0x2930,0x2930,0x2930,0x290F,0x292F,0x212F,0x210F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x210F,0x2130,0x212F,0x210F,0x212F,0x292F,0x290F,0x292F,0x290F,0x2930,0x290F,0x212F,0x210F,0x2130,0x1910,0x1930,0x08EF,0x010F,0x441B,0x23B9,0x23FA,0x1BFA,0x13B8,0x0BB8,0x0BB9,0x0BB8,0x0BD9,0x13F9,0x1C1A,0x13D9,0x13D9,0x2419,0x2C1A,0x447B,0x11F2,0x00CE,0x1130,0x1930,0x2150,0x2150,0x212F,0x2130,0x212F,0x212F,0x2130,0x2150,0x2150,0x1930,0x08EF,0x00AE,0x2B37,0x2BFA,0x23D9,0x1BD9,0x1BF9,0x1C19,0x13F9,0x13F9,0x13D9,0x1BF9,0x23D9,0x33FA,0x1A74,0x00EE,0x090F,0x1130,0x192F,0x192F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x192F,0x08EE,0x00EE,0x3BFA,0x2398,0x23F9,0x23F9,0x1BD9,0x1BD9,0x1BB9,0x2BD9,0x33FA,0x3BD9,0x010F,0x1150,0x1150,0x1130,0x1930,0x2150,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x192F,0x2130,0x1930,0x08EF,0x0991,0x3C1A,0x2BF9,0x23F9,0x13D9,0x13B8,0x1BD9,0x23D9,0x2BFA,0x33FA,0x3378,0x012F,0x0930,0x1130,0x1930,0x2130,0x2130,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2131,0x2131,0x2131,0x1911,0x1911,0x1931,0x1931,0x1931,0x1931,0x1951,0x1930,0x2150,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x212F,0x2130,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2930,0x2930,0x2930,0x212F,0x212F,0x2130,0x212F,0x212F,0x2930,0x210F,0x212F,0x212F,0x212F,0x2130,0x210F,0x2130,0x2110,0x2110,0x2110,0x2130,0x2131,0x1911,0x1932,0x1153,0x1974,0x19D6,0x2217,0x2217,0x21F7,0x1995,0x1133,0x1132,0x1131,0x1931,0x1930,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x210F,0x210F,0x212F,0x210F,0x212F,0x292F,0x210F,0x290F,0x210F,0x2910,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2110,0x2930,0x2910,0x2910,0x210F,0x210F,0x2910,0x2930,0x210F,0x2910,0x290F,0x290F,0x210F,0x210F,0x292F,0x290F,
  0x292F,0x292F,0x212F,0x210F,0x2930,0x290F,0x290F,0x2930,0x2910,0x2910,0x2110,0x2110,0x2910,0x2910,0x2910,0x2930,0x290F,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x2910,0x2910,0x2930,0x2110,0x210F,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x2110,0x210F,0x210F,0x2110,0x2130,0x2130,0x2130,0x1931,0x1931,0x1931,0x1132,0x1153,0x1174,0x19B6,0x19B7,0x19D8,0x19F9,0x1A19,0x19F9,0x11D7,0x1175,0x1975,0x1133,0x1932,0x1932,0x2152,0x2131,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2130,0x210F,0x292F,0x210F,0x292F,0x292F,0x290F,0x210F,0x292F,0x210F,0x290F,0x290F,0x2110,0x210F,0x2110,0x2930,0x2110,0x2110,0x2130,0x2131,0x1931,0x1931,0x2152,0x1932,0x1133,0x1154,0x11B6,0x11F7,0x11F8,0x09F8,0x0A19,0x0A19,0x09D8,0x09B7,0x0996,0x0976,0x11B6,0x19B6,0x19B6,0x19B6,0x19B5,0x1974,0x1953,0x1953,0x1932,0x2132,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2930,0x2930,0x2930,0x2110,0x2110,0x2930,0x2930,0x2930,0x2930,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2910,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x292F,0x210F,0x210F,0x2130,0x2130,0x1931,0x1132,0x1153,0x19D6,0x19F7,0x19F7,0x19F7,0x19F7,0x11B6,0x11B6,0x11B6,0x11D7,0x19F8,0x19F8,0x11D8,0x11D7,0x11B6,0x0934,0x08F2,0x1112,0x1111,0x1111,0x10F1,0x10F1,0x1911,0x1911,0x1111,0x1111,0x1932,0x1911,0x1111,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1111,0x10F1,0x18F1,0x18F1,0x18F1,0x10F1,0x10F1,0x10F1,0x1111,0x10F1,0x18F1,0x18F1,0x10F1,0x10F1,0x18F1,0x18F1,0x10F1,0x1911,0x10F1,0x10F1,0x10F1,0x10F1,0x1911,0x18F1,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x2131,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x2130,0x212F,0x212F,0x210F,0x212F,0x2930,0x2930,0x212F,0x210F,0x2930,0x210F,0x210F,0x212F,0x2930,0x292F,0x210F,0x290F,0x2930,0x212F,0x2110,0x2930,0x290F,0x210F,0x210F,0x210F,0x212F,0x292F,0x292F,0x212F,0x212F,0x210F,0x210F,0x2130,0x210F,0x2930,0x290F,0x2930,0x210F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2910,0x2110,0x210F,0x2110,0x2110,0x210F,0x290F,0x210F,0x290F,0x292F,0x210F,0x210F,0x290F,0x2930,0x2910,0x210F,0x2110,0x2930,0x2110,0x2110,0x2110,0x210F,0x2910,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x2110,0x2110,0x210F,0x2130,0x2950,0x212F,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x18EF,0x18EF,0x1951,0x63FB,0x5BDA,0x53BA,0x53BA,0x53BA,0x5B9A,0x08CF,0x086E,0x18EF,0x2930,0x2130,0x210F,0x20EF,0x18EF,0x08AE,0x2192,0x5BDB,0x539A,0x539A,0x539A,0x539A,0x535A,0x08AF,0x002D,0x18CF,0x5B19,0x637A,0x637A,0x5B7A,0x5359,0x537A,0x539A,0x539A,0x53BA,0x539A,0x5BBA,0x21F3,0x1110,0x1930,0x1910,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2930,0x2930,0x2930,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2930,0x2110,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x290F,0x290F,0x210F,0x290F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2151,0x1932,0x1112,0x1112,0x21B6,0x29F7,0x21F6,0x1995,0x1133,0x1132,0x1951,0x1950,0x2130,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1113,0x21B5,0x29F7,0x2A17,0x2195,0x1112,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x212F,0x212F,0x2930,0x212F,0x212F,0x2930,0x2110,0x2110,0x2930,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x2930,0x2930,0x2910,0x2930,0x2930,0x210F,0x2910,0x2910,0x2910,0x210F,0x2910,0x2930,0x2910,0x2110,0x2110,0x212F,0x212F,0x290F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1932,0x1132,0x1153,0x21D6,0x21F6,0x19F6,0x19B5,0x1133,0x1953,0x2173,0x2952,0x2951,0x2931,0x2951,0x2950,0x2950,0x3171,0x3150,0x3150,0x3151,0x3151,0x3151,0x3151,0x3151,0x3930,0x392F,0x390E,0x388C,0xB3F8,0xDCDB,0xDC99,0xDC78,0xDC57,0xDC57,0xDC37,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xE457,0xDC36,0xDC36,0xDC36,0xDC57,0xDC57,0xDC57,0xDC37,0xE457,0xDC37,0xE437,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC36,0xDC37,0xDC37,0xDC37,0xDC37,0xDC17,0xDC17,0xE437,0xDC16,0xDC16,0xDC17,0xDC17,0xDBF6,0xDC17,0xDC37,0xDC38,0xDC58,0xDC9A,0xBC19,0x40AC,0x306B,0x30CE,0x30EE,0x290F,0x290F,0x292F,0x292F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2950,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x290F,0x290F,0x2930,0x2930,0x2910,0x2910,0x210F,0x290F,0x210F,0x210F,0x210F,0x290F,0x2910,0x290F,0x290F,0x290F,0x2930,0x2910,0x2930,0x210F,0x2910,0x210F,0x2930,0x2110,0x210F,0x2130,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2131,0x2111,0x2111,0x2111,0x2111,0x2131,0x2131,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x210F,0x210F,0x290F,0x210F,0x2910,0x2910,0x210F,0x2930,0x2130,0x2130,0x2930,0x212F,0x2930,0x2930,0x212F,0x210F,0x210F,0x2930,0x212F,0x210F,0x212F,0x2930,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2110,0x210F,0x210F,0x2930,0x2930,0x212F,0x212F,0x2110,0x2910,0x2910,0x2110,0x2910,0x2110,0x2110,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x11D6,0x11F7,0x11D7,0x1195,0x1132,0x1911,0x2111,0x2110,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x292F,0x290F,0x210F,0x290F,0x290F,0x210F,0x292F,0x290F,0x210F,0x292F,0x292F,0x212F,0x212F,0x2130,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x292F,0x292F,0x290F,0x2910,0x290F,0x290F,0x2930,0x210F,0x2110,0x1910,0x1910,0x08EF,0x00EF,0x545C,0x33DA,0x2BDA,0x23B9,0x1378,0x1BB9,0x1BB9,0x1BB9,0x23FA,0x23FA,0x2C1B,0x2C1A,0x23FA,0x2BFA,0x343A,0x549C,0x11B2,0x00CE,0x1930,0x2150,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1930,0x1110,0x008E,0x3275,0x4BFB,0x3BBA,0x33DA,0x2BDA,0x23B9,0x23B9,0x23DA,0x23B9,0x23B9,0x2399,0x33DA,0x441B,0x3B38,0x00AE,0x1110,0x190F,0x2130,0x2130,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x190F,0x190F,0x110F,0x012F,0x543B,0x33D9,0x33B9,0x2BB9,0x2399,0x2BB9,0x2BB9,0x33BA,0x3BFA,0x3B79,0x00EF,0x090F,0x1130,0x1950,0x1930,0x2130,0x190F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2150,0x1930,0x08CF,0x0950,0x43B9,0x33D9,0x2BFA,0x23D9,0x1BB9,0x23D9,0x2BDA,0x33FA,0x3BFA,0x3B78,0x010F,0x1130,0x110F,0x1910,0x2130,0x2130,0x2110,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x2131,0x1931,0x1931,0x1931,0x1931,0x1930,0x1930,0x1930,0x1930,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x210F,0x212F,0x210F,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x292F,0x210F,0x210F,0x210F,0x2930,0x212F,0x212F,0x210F,0x2130,0x2130,0x2930,0x2130,0x2130,0x1910,0x1911,0x1932,0x1133,0x1174,0x19B6,0x2217,0x21F7,0x21F7,0x1995,0x1133,0x1112,0x1911,0x1931,0x1931,0x1930,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x292F,0x290F,0x290F,0x290F,0x292F,0x292F,0x212F,0x210F,0x210F,0x290F,0x210F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x2910,0x2910,0x2910,0x2910,0x2110,0x2930,0x290F,0x290F,0x210F,0x292F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,
  0x210F,0x210F,0x212F,0x212F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2110,0x2910,0x2910,0x2910,0x2910,0x2930,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x210F,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x2910,0x2110,0x2110,0x2110,0x212F,0x2930,0x292F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x1930,0x1931,0x1951,0x1132,0x1153,0x1174,0x1196,0x19B7,0x19F9,0x1A19,0x1A39,0x1A19,0x11B7,0x1196,0x1174,0x1133,0x1132,0x1932,0x1932,0x2131,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x210F,0x2110,0x210F,0x292F,0x212F,0x292F,0x292F,0x290F,0x290F,0x210F,0x210F,0x2930,0x2930,0x2130,0x2130,0x210F,0x2110,0x2110,0x2130,0x2130,0x2130,0x2131,0x2131,0x2132,0x1932,0x1912,0x1133,0x1154,0x11D6,0x11F8,0x1218,0x09F8,0x0A19,0x09F8,0x09B7,0x09B7,0x11B7,0x11B7,0x11B6,0x11B7,0x19F7,0x2218,0x19D7,0x1995,0x1154,0x1953,0x1952,0x1911,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x2930,0x2110,0x2110,0x2930,0x2110,0x2110,0x2930,0x2910,0x210F,0x210F,0x2930,0x2910,0x2930,0x2930,0x2910,0x2910,0x2110,0x2110,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2130,0x2130,0x2130,0x1931,0x1112,0x1195,0x19D7,0x19D7,0x11D7,0x11B6,0x0996,0x0976,0x0975,0x0975,0x0975,0x11B6,0x11D7,0x11D8,0x11D8,0x11D8,0x1196,0x0934,0x0933,0x0912,0x0912,0x0912,0x0912,0x0912,0x1112,0x1112,0x0912,0x0912,0x0913,0x0912,0x0912,0x0912,0x1112,0x0912,0x08F2,0x08F2,0x0912,0x08F2,0x0912,0x08F2,0x08F2,0x0912,0x08F2,0x08F2,0x0912,0x08F2,0x08F2,0x08F2,0x08F2,0x08F2,0x08F2,0x08F2,0x08F2,0x08F2,0x08F2,0x08D2,0x08D2,0x08F2,0x08F2,0x08D2,0x08F2,0x08F2,0x08F2,0x0912,0x08F2,0x08F1,0x08F1,0x10F2,0x1112,0x1932,0x1932,0x1931,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x2930,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x2110,0x210F,0x2930,0x2930,0x290F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x212F,0x210F,0x290F,0x210F,0x290F,0x210F,0x2910,0x290F,0x290F,0x210F,0x2910,0x210F,0x2110,0x210F,0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x210F,0x2930,0x290F,0x290F,0x2910,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2930,0x2910,0x2910,0x210F,0x290F,0x210F,0x2930,0x210F,0x2910,0x2910,0x2910,0x2910,0x210F,0x2110,0x210F,0x2130,0x2930,0x2130,0x2930,0x2130,0x2110,0x2130,0x2130,0x210F,0x210F,0x18CF,0x10EF,0x63BA,0x5BBA,0x539A,0x539A,0x539A,0x5B7A,0x088E,0x108E,0x20F0,0x2110,0x210F,0x210F,0x210F,0x18CF,0x10CF,0x2171,0x63DB,0x53BB,0x539B,0x539B,0x537B,0x5B7B,0x004E,0x18F0,0x6339,0x635A,0x5B39,0x5B5A,0x5B5A,0x535A,0x537A,0x5B9B,0x5BBB,0x5B9A,0x5B9A,0x21D3,0x10EF,0x1930,0x190F,0x2110,0x2130,0x2130,0x2130,0x2110,0x2910,0x290F,0x210F,0x210F,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x292F,0x290F,0x210F,0x210F,0x210F,0x2110,0x210F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x290F,0x292F,0x292F,0x292F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x212F,0x2151,0x2972,0x1932,0x1112,0x1112,0x1975,0x29F7,0x21D6,0x1974,0x1133,0x1932,0x1951,0x2151,0x2150,0x212F,0x2130,0x2130,0x2130,0x2131,0x1932,0x1133,0x21B5,0x21F7,0x29F7,0x21B5,0x1112,0x1912,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x212F,0x2930,0x2930,0x212F,0x212F,0x212F,0x2110,0x2110,0x210F,0x210F,0x290F,0x2930,0x210F,0x2930,0x290F,0x210F,0x2910,0x2910,0x2930,0x2930,0x2110,0x2930,0x2910,0x2910,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x210F,0x290F,0x292F,0x290F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1911,0x1132,0x1174,0x19D6,0x19F7,0x19F6,0x19B5,0x1133,0x1933,0x2973,0x2952,0x2952,0x2931,0x2951,0x3151,0x2950,0x3150,0x3150,0x3151,0x3151,0x3171,0x3151,0x3151,0x3150,0x3950,0x392F,0x390E,0x40AC,0xBC19,0xDCDA,0xE4B9,0xDC78,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC56,0xDC36,0xDC56,0xDC57,0xDC57,0xDC57,0xDC37,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC17,0xE437,0xDC17,0xDC17,0xE437,0xE417,0xDBF6,0xDC16,0xDC16,0xDBF6,0xDBF7,0xDC17,0xDC37,0xDC38,0xD418,0xD438,0xDCBB,0xCC9B,0x6190,0x308C,0x38EE,0x310F,0x310F,0x290F,0x292F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x290F,0x290F,0x290F,0x290F,0x2910,0x2930,0x290F,0x290F,0x290F,0x2930,0x2910,0x2930,0x2910,0x2930,0x2110,0x2130,0x2930,0x212F,0x210F,0x2110,0x2110,0x2930,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x2910,0x210F,0x2910,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x212F,0x2930,0x210F,0x210F,0x212F,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x2910,0x2110,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2110,0x2910,0x2910,0x2910,0x20F0,0x210F,0x210F,0x210F,0x2930,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1932,0x1133,0x11D6,0x11F7,0x11D7,0x1995,0x1132,0x1911,0x2111,0x2110,0x2110,0x2110,0x2930,0x290F,0x212F,0x212F,0x290F,0x290F,0x210F,0x292F,0x290F,0x290F,0x290F,0x292F,0x290F,0x292F,0x212F,0x212F,0x2130,0x2130,0x210F,0x2130,0x2130,0x210F,0x2930,0x212F,0x212F,0x212F,0x292F,0x2930,0x290F,0x2930,0x2930,0x2110,0x2110,0x210F,0x2130,0x1910,0x08CF,0x00AF,0x647D,0x4BFB,0x43FB,0x339A,0x3BFB,0x4C7D,0x443C,0x443C,0x441B,0x3BBA,0x3BDB,0x3BDB,0x441B,0x43FB,0x4C1B,0x53DA,0x0910,0x10CF,0x1910,0x2130,0x2130,0x212F,0x212F,0x212F,0x214F,0x212F,0x2150,0x2130,0x2130,0x18F0,0x10F0,0x5B9A,0x4B7A,0x437A,0x439A,0x3B9A,0x3B9A,0x339A,0x339A,0x339A,0x33BA,0x3BBA,0x43BA,0x4B9A,0x641C,0x1951,0x10F0,0x1910,0x2110,0x2130,0x210F,0x2130,0x212F,0x292F,0x2930,0x212F,0x210F,0x190F,0x10EF,0x00EE,0x5C1B,0x439A,0x3B9A,0x3B9A,0x3379,0x3BBA,0x3B79,0x3B7A,0x4BFB,0x4379,0x00CE,0x1110,0x1930,0x1930,0x192F,0x212F,0x192F,0x190F,0x212F,0x2130,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x10CF,0x0910,0x53DB,0x43BA,0x3BDA,0x33DA,0x33BA,0x33BA,0x339A,0x3BDA,0x4BFB,0x4358,0x010F,0x1130,0x1910,0x1910,0x2130,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x2131,0x1931,0x1930,0x1931,0x1930,0x1930,0x1930,0x1930,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x292F,0x292F,0x292F,0x212F,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x212F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2950,0x2130,0x2130,0x1911,0x1932,0x1133,0x1174,0x19D6,0x2217,0x2217,0x19F6,0x1175,0x1153,0x1132,0x1112,0x1931,0x1910,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x292F,0x290F,0x2930,0x290F,0x290F,0x290F,0x292F,0x212F,0x292F,0x210F,0x290F,0x210F,0x290F,0x290F,0x2910,0x2930,0x2910,0x2910,0x2910,0x290F,0x2910,0x290F,0x2910,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,
  0x210F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2930,0x2930,0x290F,0x210F,0x290F,0x2930,0x2910,0x2910,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x2930,0x2910,0x290F,0x290F,0x290F,0x2910,0x290F,0x2910,0x2910,0x290F,0x210F,0x2930,0x2930,0x2110,0x2930,0x212F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2150,0x2151,0x1951,0x1972,0x1952,0x1153,0x1174,0x1196,0x19B7,0x19F8,0x1A19,0x1A19,0x11F8,0x19D7,0x1195,0x1154,0x1133,0x1112,0x1932,0x1932,0x2131,0x2131,0x2130,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2930,0x2130,0x2130,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x2110,0x210F,0x210F,0x2130,0x2130,0x2130,0x2151,0x2131,0x2131,0x2131,0x1912,0x1112,0x1133,0x1175,0x11D7,0x11F8,0x09F8,0x09F9,0x09D8,0x09B8,0x09B7,0x11B7,0x11B6,0x0975,0x1176,0x11B7,0x2219,0x2218,0x19D7,0x19B7,0x21D6,0x1153,0x1111,0x1911,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x2930,0x2110,0x210F,0x2910,0x2110,0x2110,0x2110,0x2910,0x2110,0x2130,0x2130,0x210F,0x290F,0x210F,0x2910,0x2910,0x210F,0x2910,0x210F,0x2930,0x290F,0x212F,0x210F,0x292F,0x210F,0x212F,0x212F,0x210F,0x2110,0x2110,0x2131,0x1911,0x1112,0x19D6,0x19F7,0x11D7,0x11B7,0x0996,0x1196,0x0975,0x0955,0x0954,0x0955,0x0955,0x0976,0x11D8,0x11D8,0x11D8,0x11F8,0x11D7,0x11B6,0x11B6,0x11B6,0x11D7,0x11B7,0x11D7,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x11B6,0x1196,0x11B6,0x1196,0x11B6,0x11B6,0x19D7,0x19D7,0x19D7,0x11B6,0x19B7,0x11B6,0x11B6,0x11B6,0x11D6,0x11D6,0x11B6,0x11B6,0x11B6,0x11B6,0x19D6,0x11B6,0x11B7,0x19D7,0x19D7,0x19D7,0x19D7,0x19D7,0x19D7,0x19D7,0x19D7,0x19F7,0x19F7,0x19F7,0x19F7,0x19D7,0x19D7,0x19D6,0x19B6,0x1154,0x1133,0x1112,0x1112,0x1932,0x1931,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x2930,0x210F,0x212F,0x212F,0x210F,0x212F,0x292F,0x2930,0x2930,0x210F,0x210F,0x210F,0x2110,0x2110,0x2910,0x2910,0x2910,0x2910,0x2910,0x212F,0x212F,0x212F,0x2930,0x212F,0x212F,0x212F,0x2130,0x2930,0x210F,0x212F,0x2930,0x2930,0x2910,0x2930,0x210F,0x2930,0x2910,0x2910,0x290F,0x2930,0x290F,0x2930,0x290F,0x290F,0x210F,0x2130,0x212F,0x210F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2910,0x2910,0x2930,0x2130,0x2930,0x2130,0x2130,0x2130,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x18EF,0x18EF,0x6BBA,0x63BB,0x5B9A,0x5BBA,0x5B9A,0x5B7A,0x088E,0x18AF,0x2110,0x2110,0x210F,0x210F,0x20EF,0x20EF,0x10CF,0x29B2,0x63BB,0x5B9A,0x5B9B,0x5B7A,0x5B7B,0x639B,0x3A15,0x633A,0x6B7B,0x635A,0x637B,0x5B5A,0x5319,0x5B5A,0x5B9A,0x5BBB,0x5B9A,0x5B79,0x21B2,0x10EF,0x1930,0x1930,0x2130,0x2110,0x2130,0x2130,0x2110,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x210F,0x2930,0x2930,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2130,0x2130,0x2930,0x2910,0x2110,0x2910,0x2110,0x2930,0x2130,0x2130,0x210F,0x212F,0x212F,0x2130,0x2130,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x290F,0x210F,0x292F,0x292F,0x210F,0x292F,0x292F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2151,0x2151,0x1932,0x1112,0x1133,0x21B5,0x21F7,0x21D6,0x1974,0x1133,0x1112,0x1931,0x1930,0x2150,0x2150,0x212F,0x2130,0x2110,0x1931,0x1132,0x1133,0x21B5,0x21F7,0x2A17,0x19B5,0x1112,0x1932,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x212F,0x210F,0x212F,0x2930,0x2930,0x212F,0x212F,0x212F,0x2930,0x210F,0x2910,0x290F,0x2930,0x2910,0x2910,0x2930,0x210F,0x290F,0x2930,0x290F,0x2910,0x2910,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2110,0x2930,0x2930,0x2110,0x2930,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2130,0x2130,0x2130,0x2130,0x2151,0x2151,0x1931,0x1111,0x1133,0x19B5,0x19F7,0x19F7,0x19F7,0x19B6,0x1154,0x1953,0x2173,0x2952,0x2972,0x2951,0x2951,0x3171,0x2950,0x3150,0x2950,0x3151,0x3151,0x3171,0x3171,0x3171,0x3150,0x3930,0x392F,0x412F,0x48ED,0xD4BB,0xDCBA,0xDC99,0xDC58,0xDC58,0xDC37,0xDC37,0xE457,0xDC36,0xE457,0xDC57,0xDC56,0xDC56,0xE457,0xDC56,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC37,0xDC57,0xDC57,0xDC57,0xDC37,0xDC37,0xDC16,0xDC17,0xDC37,0xE417,0xDC17,0xE417,0xDC16,0xDC17,0xDC16,0xDC17,0xDC17,0xDC17,0xDC17,0xDC17,0xDC17,0xDC18,0xDC38,0xDC59,0xD47A,0xDCFC,0xA397,0x40CD,0x38EE,0x310F,0x310F,0x3130,0x3130,0x2930,0x2950,0x2950,0x2930,0x2930,0x2930,0x2950,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2950,0x2950,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2910,0x2930,0x2910,0x2910,0x2930,0x2910,0x2930,0x2930,0x2930,0x210F,0x290F,0x290F,0x2930,0x2930,0x290F,0x210F,0x290F,0x210F,0x2930,0x290F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2110,0x2930,0x2910,0x2110,0x2930,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2110,0x2930,0x2910,0x290F,0x2930,0x2930,0x292F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x2930,0x212F,0x2130,0x2130,0x210F,0x2930,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x2910,0x290F,0x212F,0x292F,0x210F,0x210F,0x212F,0x2930,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x1910,0x1931,0x1132,0x0933,0x11D6,0x19F7,0x19F7,0x1995,0x1132,0x1911,0x2111,0x2110,0x2110,0x210F,0x2110,0x2930,0x212F,0x210F,0x290F,0x290F,0x210F,0x210F,0x212F,0x210F,0x292F,0x292F,0x290F,0x210F,0x2930,0x212F,0x2930,0x2930,0x212F,0x292F,0x2930,0x210F,0x212F,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2110,0x2930,0x2110,0x2130,0x1910,0x10CF,0x008E,0x6C3D,0x4B5A,0x537B,0x3AF9,0x3B19,0x32F8,0x6C9E,0x19F4,0x006E,0x006E,0x004E,0x004E,0x004E,0x004E,0x004E,0x002D,0x108F,0x18AF,0x20EF,0x210F,0x2950,0x2130,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x18F0,0x10AF,0x5AD8,0x6B7B,0x5B5A,0x5B5B,0x535B,0x4B5A,0x537B,0x4B7B,0x4B7A,0x4B7A,0x4B9B,0x4B9B,0x537A,0x535A,0x637A,0x637A,0x086E,0x20F0,0x2110,0x2110,0x2910,0x210F,0x292F,0x292F,0x212F,0x212F,0x212F,0x212F,0x10EE,0x08CE,0x63DB,0x4B5A,0x4B7A,0x4B7A,0x4B7A,0x4B7A,0x435A,0x4B7A,0x5BFC,0x63FC,0x008F,0x1110,0x1930,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2130,0x2110,0x10CF,0x1110,0x6BFC,0x53BB,0x4B9B,0x437A,0x437A,0x439A,0x437A,0x4BBB,0x5BDB,0x5379,0x08EF,0x1110,0x1910,0x1910,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2131,0x2131,0x2131,0x1911,0x1931,0x1931,0x1951,0x1931,0x1931,0x1930,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x2130,0x2130,0x2130,0x212F,0x212F,0x292F,0x292F,0x210F,0x292F,0x292F,0x292F,0x212F,0x210F,0x212F,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x2930,0x2110,0x2930,0x2130,0x2131,0x1911,0x1111,0x1133,0x1174,0x19D6,0x2217,0x2217,0x19F6,0x1995,0x1133,0x1112,0x1932,0x1931,0x2151,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x210F,0x292F,0x210F,0x290F,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x290F,0x212F,0x292F,0x290F,0x210F,0x210F,0x290F,0x2110,0x2910,0x2930,0x290F,0x2930,0x2930,0x290F,0x2910,0x2910,0x2910,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x292F,0x292F,
  0x210F,0x212F,0x210F,0x290F,0x290F,0x2930,0x210F,0x2930,0x2910,0x2910,0x2910,0x210F,0x2930,0x2930,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x2930,0x290F,0x210F,0x290F,0x210F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x290F,0x290F,0x2930,0x2910,0x2910,0x210F,0x212F,0x210F,0x290F,0x290F,0x210F,0x292F,0x290F,0x292F,0x210F,0x210F,0x210F,0x212F,0x2150,0x2130,0x2151,0x1951,0x1932,0x1932,0x1153,0x1175,0x1196,0x11B7,0x19F8,0x1A19,0x1A19,0x1A18,0x11D7,0x1195,0x1154,0x1133,0x1132,0x1932,0x2152,0x2131,0x2130,0x2110,0x2130,0x212F,0x212F,0x2930,0x212F,0x210F,0x210F,0x210F,0x2930,0x2130,0x2130,0x212F,0x210F,0x210F,0x292F,0x292F,0x292F,0x210F,0x210F,0x210F,0x2130,0x210F,0x2130,0x210F,0x290F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x2111,0x1931,0x1912,0x1112,0x1153,0x11B6,0x11F7,0x09F8,0x09F8,0x09D8,0x09D8,0x09B7,0x0996,0x0955,0x0955,0x0976,0x0976,0x11B7,0x19F8,0x11F8,0x19F8,0x19B7,0x1154,0x1111,0x1911,0x1910,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2110,0x210F,0x2930,0x2110,0x2910,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x2930,0x212F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2131,0x1911,0x1112,0x19B6,0x11D7,0x11D7,0x0996,0x0975,0x0975,0x0955,0x0954,0x0954,0x0954,0x0955,0x0956,0x0997,0x09B8,0x09D8,0x11F9,0x1219,0x1A39,0x1A39,0x1A39,0x2259,0x2239,0x225A,0x2259,0x227A,0x2259,0x2259,0x2259,0x225A,0x227A,0x225A,0x225A,0x2A7A,0x225A,0x225A,0x225A,0x227A,0x225A,0x225A,0x225A,0x225A,0x225A,0x227A,0x227A,0x227A,0x2259,0x2259,0x2A79,0x2A7A,0x2259,0x227A,0x225A,0x225A,0x2259,0x225A,0x2259,0x225A,0x2239,0x2259,0x2239,0x2259,0x2259,0x2259,0x2239,0x2259,0x2239,0x2259,0x2A59,0x21F7,0x1995,0x1133,0x1132,0x1932,0x1951,0x1931,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2930,0x290F,0x212F,0x2930,0x212F,0x210F,0x212F,0x212F,0x2130,0x2930,0x210F,0x210F,0x2110,0x210F,0x2110,0x2910,0x2910,0x2910,0x210F,0x2910,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x212F,0x210F,0x210F,0x2930,0x210F,0x212F,0x2910,0x2910,0x210F,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x2930,0x212F,0x212F,0x212F,0x210F,0x210F,0x2930,0x2930,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2110,0x210F,0x210F,0x210F,0x212F,0x210F,0x2930,0x2930,0x210F,0x2930,0x290F,0x2110,0x210F,0x2110,0x290F,0x210F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2110,0x210F,0x20EF,0x10AE,0x6B9A,0x6BBB,0x639A,0x639A,0x5B7A,0x635A,0x108F,0x18AF,0x2110,0x20EF,0x2930,0x2930,0x20EF,0x2110,0x10AE,0x2992,0x63BB,0x639B,0x639B,0x5B7B,0x5B3A,0x5B3A,0x631A,0x631A,0x633A,0x6B5B,0x635A,0x635A,0x5B3A,0x5B5A,0x639B,0x639A,0x5B7A,0x2192,0x10EF,0x190F,0x2130,0x190F,0x2130,0x2110,0x2130,0x2130,0x2930,0x2930,0x2930,0x290F,0x2930,0x290F,0x210F,0x210F,0x212F,0x2930,0x2930,0x210F,0x210F,0x210F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2910,0x2110,0x290F,0x2910,0x2110,0x2930,0x2110,0x2130,0x212F,0x212F,0x2130,0x210F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2930,0x292F,0x290F,0x292F,0x292F,0x210F,0x292F,0x212F,0x212F,0x210F,0x212F,0x2930,0x210F,0x2130,0x2130,0x2131,0x1911,0x1132,0x1133,0x19D5,0x2217,0x19D6,0x1995,0x1133,0x1932,0x1931,0x2130,0x2150,0x2150,0x210F,0x210F,0x2110,0x1931,0x1132,0x1133,0x21B5,0x2A17,0x21F6,0x21B5,0x1112,0x1932,0x2131,0x2131,0x2130,0x2130,0x2110,0x2130,0x2130,0x2930,0x210F,0x2930,0x210F,0x2930,0x2130,0x210F,0x212F,0x212F,0x212F,0x2930,0x2910,0x2930,0x2930,0x2930,0x210F,0x2910,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x2910,0x2110,0x2910,0x2910,0x2930,0x2910,0x2930,0x2110,0x2110,0x2110,0x2930,0x292F,0x290F,0x292F,0x290F,0x292F,0x290F,0x2910,0x2930,0x2130,0x2130,0x2151,0x2151,0x1931,0x1111,0x1132,0x1153,0x19B6,0x19F7,0x19F7,0x19F7,0x11B6,0x1174,0x1953,0x2173,0x2153,0x2952,0x2951,0x2951,0x2951,0x3151,0x3151,0x3151,0x3171,0x3151,0x3171,0x3171,0x3151,0x3150,0x3930,0x392F,0x410E,0x48ED,0xDCDC,0xDCBA,0xDC99,0xDC78,0xDC57,0xDC57,0xDC37,0xDC37,0xDC36,0xDC57,0xDC36,0xDC57,0xDC56,0xDC57,0xE457,0xDC36,0xDC37,0xDC37,0xDC57,0xDC57,0xDC57,0xDC36,0xDC37,0xDC37,0xDC37,0xDC36,0xDC36,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC16,0xDC16,0xE417,0xDC17,0xDC16,0xDC16,0xDC17,0xDC17,0xDBF6,0xDC17,0xDC17,0xDC17,0xDBF7,0xDC17,0xDC18,0xDC38,0xDC59,0xDC59,0xD49A,0xDD1D,0x8AB4,0x308C,0x390F,0x310F,0x310F,0x3130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x290F,0x2930,0x2930,0x2930,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2910,0x2910,0x2910,0x2930,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2930,0x212F,0x210F,0x210F,0x2110,0x2110,0x2930,0x2930,0x212F,0x2930,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2930,0x2930,0x2130,0x2130,0x2130,0x210F,0x290F,0x210F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2930,0x210F,0x212F,0x212F,0x210F,0x290F,0x210F,0x2930,0x2930,0x290F,0x2930,0x2930,0x2110,0x210F,0x2930,0x2130,0x212F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x1931,0x1131,0x1153,0x11D6,0x19F7,0x19D7,0x1995,0x1132,0x1911,0x2131,0x2110,0x2130,0x2110,0x2110,0x2930,0x210F,0x212F,0x2930,0x210F,0x292F,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x210F,0x210F,0x2930,0x2930,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x212F,0x2930,0x2110,0x2130,0x2930,0x2130,0x2110,0x18EF,0x10AF,0x004E,0x73DC,0x637B,0x6B7C,0x5B1A,0x52FA,0x635A,0x6BBC,0x31B4,0x1890,0x186F,0x102F,0x102F,0x102F,0x102F,0x102F,0x102E,0x102E,0x20AF,0x20AF,0x20EF,0x210F,0x2130,0x212F,0x212F,0x2150,0x2930,0x2110,0x20F0,0x188F,0x3153,0x733A,0x6B1A,0x6B1B,0x6B1B,0x633B,0x633B,0x635B,0x5B5B,0x635B,0x5B3B,0x5B5B,0x633B,0x633B,0x631A,0x631A,0x7B7B,0x49F5,0x20B0,0x20F0,0x2910,0x2910,0x290F,0x290F,0x292F,0x292F,0x212F,0x212F,0x210F,0x10EE,0x088E,0x637B,0x635B,0x637B,0x637C,0x5B5B,0x5B3B,0x635B,0x637B,0x639C,0x73DD,0x088F,0x18D0,0x1910,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2110,0x18CF,0x10AF,0x6BBB,0x637B,0x637B,0x533B,0x535B,0x533B,0x535B,0x639B,0x63BB,0x5B59,0x10CF,0x18F0,0x1910,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2930,0x2110,0x2110,0x2130,0x2130,0x2131,0x1931,0x1931,0x1931,0x1931,0x1952,0x1951,0x1931,0x1951,0x1931,0x2151,0x2151,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x210F,0x212F,0x210F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x212F,0x292F,0x2930,0x2130,0x2110,0x2130,0x2130,0x2131,0x1911,0x1112,0x1133,0x1154,0x19D6,0x1A17,0x2217,0x21F7,0x1995,0x1133,0x1112,0x1911,0x1952,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x292F,0x210F,0x292F,0x212F,0x212F,0x290F,0x210F,0x290F,0x292F,0x2910,0x2930,0x290F,0x292F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2910,0x2930,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x292F,0x292F,
  0x212F,0x210F,0x2930,0x212F,0x2930,0x2930,0x210F,0x210F,0x2910,0x2910,0x210F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x210F,0x290F,0x2110,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2930,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x292F,0x210F,0x210F,0x212F,0x212F,0x2130,0x2151,0x1931,0x1931,0x1911,0x1132,0x1974,0x1975,0x1196,0x11B7,0x11F8,0x1219,0x11F8,0x11F8,0x11B7,0x0975,0x1134,0x1133,0x1912,0x1932,0x2131,0x2131,0x2150,0x2130,0x212F,0x212F,0x2130,0x2930,0x2130,0x212F,0x2930,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x292F,0x292F,0x290F,0x210F,0x290F,0x212F,0x2930,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2131,0x2131,0x1911,0x1911,0x1132,0x1194,0x19D7,0x11F8,0x11F8,0x09D8,0x09B7,0x0996,0x0955,0x0955,0x0935,0x0955,0x0976,0x0996,0x11B7,0x11D8,0x11D8,0x19D7,0x1154,0x1112,0x1911,0x2131,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x210F,0x210F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x210F,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2930,0x2130,0x2130,0x2131,0x1911,0x1133,0x19D6,0x19F7,0x11D7,0x11B7,0x0996,0x0975,0x0955,0x0975,0x0954,0x0954,0x0955,0x0976,0x0997,0x11D8,0x09D8,0x09D8,0x11F8,0x1A19,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x1A18,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19D8,0x19F8,0x19F8,0x19F8,0x19F8,0x19F8,0x19D8,0x19F8,0x19F8,0x19F8,0x19F8,0x19D7,0x19F8,0x19F7,0x19D7,0x19D7,0x19F7,0x19F8,0x19D8,0x19F8,0x19F8,0x19D8,0x19D8,0x19D8,0x19F8,0x19F8,0x19D7,0x19F8,0x19F8,0x19D7,0x19F8,0x19F8,0x19F8,0x19F8,0x1A18,0x1A18,0x2217,0x19D6,0x1154,0x1132,0x1111,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2930,0x290F,0x292F,0x290F,0x290F,0x2930,0x2930,0x212F,0x212F,0x2130,0x212F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x212F,0x2110,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2930,0x2930,0x212F,0x2930,0x210F,0x212F,0x2130,0x210F,0x2930,0x290F,0x210F,0x2910,0x210F,0x2110,0x2910,0x210F,0x2930,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2930,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x20EF,0x20EF,0x18CF,0x6B9A,0x6BBB,0x637A,0x637B,0x637A,0x633A,0x10AF,0x18AF,0x20F0,0x20F0,0x2930,0x2930,0x20EF,0x20EF,0x10AF,0x2151,0x6BBB,0x637B,0x635B,0x633B,0x633B,0x633B,0x631A,0x631A,0x633B,0x633A,0x635B,0x6B7B,0x635A,0x637A,0x639A,0x637A,0x2171,0x190F,0x1930,0x1930,0x2130,0x210F,0x210F,0x210F,0x210F,0x2110,0x2930,0x2930,0x2930,0x2930,0x290F,0x210F,0x210F,0x210F,0x2930,0x2930,0x2110,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2930,0x2910,0x210F,0x2910,0x2910,0x2930,0x2910,0x290F,0x292F,0x210F,0x210F,0x2910,0x210F,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2930,0x2110,0x2130,0x2110,0x2110,0x210F,0x290F,0x290F,0x292F,0x292F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x210F,0x2110,0x2110,0x1910,0x1911,0x1132,0x1153,0x19B5,0x21D6,0x21D6,0x1995,0x1133,0x1952,0x1931,0x2130,0x2150,0x2130,0x212F,0x210F,0x2110,0x1931,0x1132,0x1153,0x19B5,0x21F6,0x21F6,0x1994,0x1112,0x1912,0x1911,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x212F,0x212F,0x2930,0x2110,0x2110,0x2110,0x2110,0x290F,0x290F,0x210F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x210F,0x2930,0x290F,0x290F,0x2910,0x2930,0x2910,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x212F,0x290F,0x290F,0x292F,0x292F,0x2930,0x2930,0x2930,0x2130,0x2130,0x2131,0x2152,0x1931,0x1132,0x1133,0x1154,0x0975,0x19F7,0x19F8,0x19F7,0x11D7,0x11B6,0x1174,0x1974,0x2173,0x2152,0x2952,0x2951,0x2951,0x3151,0x3151,0x3151,0x3171,0x3171,0x3171,0x3171,0x3171,0x3951,0x3950,0x414F,0x410E,0x48CD,0xDCDC,0xDCBA,0xDC99,0xDC78,0xDC58,0xDC57,0xDC37,0xDC37,0xDC37,0xDC57,0xDC57,0xDC36,0xE457,0xDC36,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC37,0xDC37,0xE457,0xDC37,0xDC36,0xDC57,0xDC57,0xDC57,0xDC57,0xDC57,0xDC36,0xDC36,0xDC37,0xDC16,0xDC16,0xDC17,0xDC17,0xDC17,0xDC17,0xDC17,0xDC16,0xDC16,0xDC17,0xDC17,0xDC17,0xDC17,0xDC17,0xDC17,0xDC17,0xDBF7,0xDC38,0xDC38,0xD439,0xCC39,0xDD1D,0x408C,0x40EE,0x392F,0x3930,0x3130,0x2930,0x2930,0x2950,0x2950,0x2930,0x2930,0x2950,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x210F,0x210F,0x2930,0x290F,0x290F,0x2930,0x212F,0x210F,0x290F,0x292F,0x210F,0x290F,0x2930,0x210F,0x210F,0x290F,0x290F,0x20EF,0x290F,0x210F,0x210F,0x2110,0x2110,0x210F,0x2930,0x210F,0x292F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x210F,0x212F,0x292F,0x212F,0x2930,0x2930,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x210F,0x2130,0x212F,0x212F,0x212F,0x212F,0x2930,0x2130,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2930,0x212F,0x2930,0x2930,0x290F,0x290F,0x210F,0x212F,0x290F,0x2930,0x2930,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1111,0x1132,0x19D6,0x19F7,0x19D7,0x1175,0x1112,0x1911,0x2131,0x2110,0x2110,0x2930,0x2910,0x2930,0x292F,0x292F,0x290F,0x292F,0x212F,0x212F,0x212F,0x212F,0x2930,0x292F,0x290F,0x290F,0x290F,0x210F,0x2930,0x2930,0x210F,0x210F,0x290F,0x210F,0x292F,0x292F,0x212F,0x210F,0x290F,0x2930,0x2930,0x2110,0x2930,0x2130,0x2130,0x2110,0x2110,0x20F0,0x18AF,0x108F,0x8BFD,0x7B5B,0x733B,0x731B,0x7B3C,0x7B5C,0x72DA,0x8B9D,0x9BFF,0x9BDE,0x9BBE,0x9BBE,0x9BBE,0x9BDE,0x937C,0x93BD,0x9C1D,0x7319,0x206E,0x28F0,0x20EF,0x210F,0x212F,0x212F,0x2930,0x2930,0x20F0,0x20AF,0x2090,0x72B9,0x831B,0x82FB,0x831C,0x7B1C,0x7B1C,0x733C,0x6AFB,0x6B1B,0x733B,0x733B,0x733C,0x731C,0x7B3C,0x7B3C,0x7AFB,0x72B9,0x831B,0x30D1,0x28D0,0x28D0,0x28F0,0x28EF,0x20EF,0x210F,0x292F,0x292F,0x210E,0x18EE,0x18CE,0x106E,0x737B,0x735C,0x7B7D,0x733C,0x6AFB,0x6AFB,0x733C,0x733C,0x735C,0x7BBC,0x106F,0x18D0,0x18F0,0x18EF,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2950,0x212F,0x210F,0x2110,0x20D0,0x20D0,0x737B,0x735B,0x737C,0x733C,0x62FB,0x62FB,0x6B3B,0x739C,0x7BBC,0x6B3A,0x18AF,0x18CF,0x18CF,0x18EF,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x1911,0x1931,0x1931,0x1932,0x1132,0x1132,0x1152,0x1152,0x1152,0x1952,0x1932,0x1911,0x1911,0x1911,0x2131,0x2131,0x2131,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x210F,0x212F,0x210F,0x292F,0x210F,0x210F,0x292F,0x292F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x292F,0x210F,0x210F,0x2110,0x210F,0x2130,0x2131,0x2131,0x1931,0x1932,0x1133,0x1154,0x19B6,0x21F7,0x2217,0x19D6,0x1174,0x1133,0x1112,0x1932,0x2132,0x2131,0x2130,0x2130,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2930,0x210F,0x290F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x210F,0x212F,0x212F,0x292F,0x290F,
  0x212F,0x210F,0x212F,0x212F,0x2930,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2930,0x290F,0x290F,0x210F,0x2110,0x290F,0x210F,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x2910,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x212F,0x292F,0x212F,0x212F,0x212F,0x2130,0x1930,0x1931,0x1931,0x1952,0x1953,0x1954,0x1175,0x1196,0x11D7,0x11F8,0x1219,0x1219,0x11F8,0x11B7,0x1175,0x1134,0x1113,0x1912,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x292F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x2131,0x1911,0x18F1,0x1912,0x1133,0x11B6,0x11F7,0x11F8,0x09F8,0x09B7,0x0976,0x0135,0x0134,0x0955,0x0955,0x0955,0x0976,0x09B7,0x11D8,0x11D8,0x19B7,0x1154,0x1112,0x1911,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x2910,0x2910,0x2930,0x2110,0x210F,0x210F,0x212F,0x212F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x1112,0x19D6,0x19F7,0x11D7,0x11B7,0x0996,0x0975,0x0955,0x0954,0x0954,0x0954,0x0975,0x0996,0x09B7,0x11D8,0x09B8,0x11D8,0x11B7,0x1196,0x1196,0x1196,0x1195,0x1196,0x1195,0x1175,0x1175,0x1175,0x1175,0x1196,0x1195,0x1196,0x1176,0x1175,0x1175,0x1176,0x1155,0x1155,0x1175,0x1155,0x1175,0x1175,0x1175,0x1175,0x1175,0x1155,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1175,0x1155,0x1175,0x1175,0x1175,0x1175,0x1175,0x1996,0x1196,0x1196,0x1196,0x11B6,0x11D7,0x19F7,0x1A18,0x19F7,0x19D6,0x1974,0x1132,0x1912,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x2130,0x2930,0x212F,0x212F,0x292F,0x292F,0x2930,0x210F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2930,0x210F,0x210F,0x212F,0x212F,0x290F,0x210F,0x290F,0x210F,0x2930,0x212F,0x212F,0x210F,0x212F,0x2130,0x210F,0x212F,0x210F,0x212F,0x210F,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2110,0x210F,0x212F,0x210F,0x212F,0x212F,0x292F,0x292F,0x212F,0x212F,0x210F,0x2930,0x210F,0x2110,0x2110,0x2110,0x2910,0x2910,0x2110,0x210F,0x2930,0x210F,0x2130,0x210F,0x2130,0x2130,0x2930,0x210F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x20EF,0x10AE,0x73BB,0x6B7B,0x6B7B,0x635B,0x635B,0x633A,0x18B0,0x18AF,0x20CF,0x20EF,0x2910,0x290F,0x20EF,0x20EF,0x10AE,0x2952,0x6B9B,0x6B7B,0x635B,0x633B,0x6B3B,0x631A,0x6B1A,0x6B1B,0x6B3B,0x6B3B,0x635A,0x6B7B,0x637A,0x6B9B,0x6359,0x2171,0x18CF,0x2110,0x212F,0x190F,0x2130,0x210F,0x212F,0x212F,0x290F,0x290F,0x2930,0x2930,0x2930,0x2930,0x210F,0x2910,0x210F,0x2910,0x2930,0x212F,0x210F,0x2910,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2910,0x2910,0x2910,0x2910,0x2930,0x210F,0x2910,0x290F,0x290F,0x290F,0x210F,0x2930,0x2910,0x212F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x2110,0x2130,0x2131,0x1911,0x1132,0x1153,0x19D6,0x21F6,0x19B6,0x1995,0x1153,0x1932,0x1931,0x1930,0x2130,0x2110,0x2110,0x2130,0x2131,0x1931,0x1932,0x1133,0x19B5,0x21F7,0x21F6,0x19B5,0x1112,0x1932,0x2131,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2930,0x2930,0x290F,0x2910,0x2110,0x2930,0x2910,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2930,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x290F,0x2910,0x2930,0x2130,0x2131,0x1911,0x1912,0x1112,0x1154,0x1175,0x1175,0x0996,0x11D7,0x11F8,0x11F8,0x11D7,0x19D7,0x19B6,0x1995,0x1974,0x2153,0x2952,0x2951,0x2951,0x3151,0x3171,0x3171,0x3171,0x3171,0x3171,0x3171,0x3971,0x3971,0x3950,0x4150,0x410E,0x48ED,0xDCDC,0xDC9A,0xDC99,0xDC78,0xDC58,0xE457,0xDC37,0xE457,0xDC37,0xDC37,0xE457,0xDC36,0xDC36,0xDC36,0xDC57,0xDC57,0xDC37,0xDC57,0xDC36,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC16,0xDC37,0xDC16,0xDC37,0xDC17,0xDC16,0xDC16,0xDC16,0xDC16,0xDC17,0xDC16,0xDBF6,0xDC16,0xDC16,0xDBF6,0xDBF6,0xDC17,0xDC17,0xDBF7,0xDBF7,0xDC17,0xDC38,0xDC59,0xD459,0xC439,0x408B,0x304B,0x410F,0x310F,0x3130,0x3130,0x3130,0x3150,0x2950,0x2950,0x2930,0x2950,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2110,0x2110,0x210F,0x210F,0x2910,0x2930,0x292F,0x292F,0x212F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x20EF,0x290F,0x210F,0x290F,0x290F,0x290F,0x2910,0x2930,0x290F,0x210F,0x210F,0x292F,0x292F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x2930,0x2130,0x2130,0x212F,0x212F,0x2130,0x212F,0x210F,0x2130,0x2930,0x2930,0x212F,0x212F,0x212F,0x212F,0x2130,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x290F,0x290F,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x290F,0x290F,0x212F,0x2930,0x2930,0x210F,0x2130,0x210F,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x1930,0x1931,0x1931,0x0912,0x11B5,0x19F7,0x11D6,0x1195,0x1132,0x1911,0x2111,0x2131,0x2930,0x2930,0x2910,0x2930,0x2930,0x292F,0x2930,0x290F,0x210F,0x212F,0x210F,0x212F,0x2930,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x212F,0x292F,0x2930,0x212F,0x210F,0x2930,0x2110,0x2110,0x2930,0x2930,0x2110,0x2930,0x2110,0x20EF,0x188F,0x104E,0x93BD,0x8B3C,0x831C,0x8AFC,0x82DB,0x82BB,0x8ADB,0x829A,0x8A9B,0x8A9B,0x92BB,0x8A9B,0x92DB,0x92FB,0x9B3C,0x9B7C,0x9BBD,0x939B,0x206E,0x28D0,0x20EF,0x210F,0x212F,0x2930,0x210F,0x2910,0x28F0,0x204F,0x4954,0x8AFB,0x8ADB,0x92DC,0x8ADC,0x8AFC,0x82DC,0x82FC,0x7AFB,0x7AFB,0x7B1B,0x831C,0x82FC,0x82DB,0x8B1C,0x8AFC,0x8AFC,0x82BB,0x82DB,0x7A99,0x202F,0x30B0,0x28D0,0x28F0,0x290F,0x210F,0x292F,0x292F,0x212F,0x20EE,0x18AE,0x102E,0x7B3B,0x831C,0x8B1D,0x82DC,0x82DC,0x82DC,0x82DC,0x7AFB,0x833C,0x8B9D,0x2090,0x20B0,0x20D0,0x20EF,0x2930,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x20F0,0x20D0,0x2090,0x833B,0x833C,0x8B5D,0x82FC,0x7ABB,0x7ADC,0x7AFC,0x833C,0x8B7C,0x731A,0x208F,0x20AF,0x20CF,0x20EF,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2111,0x1911,0x1911,0x1932,0x1132,0x1153,0x1174,0x1194,0x1994,0x19B5,0x19B4,0x1174,0x1153,0x1112,0x1912,0x1911,0x1911,0x2151,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2930,0x290F,0x2930,0x212F,0x212F,0x212F,0x210F,0x2110,0x2930,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x212F,0x2130,0x210F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2131,0x2131,0x1911,0x1932,0x1133,0x1154,0x19B6,0x21F7,0x2217,0x21F7,0x1174,0x0913,0x1112,0x1932,0x1931,0x2131,0x2130,0x2110,0x2110,0x2130,0x2110,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x212F,0x212F,0x292F,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x2910,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x292F,0x290F,
  0x210F,0x210F,0x210F,0x212F,0x2930,0x2930,0x210F,0x210F,0x290F,0x2930,0x2930,0x210F,0x290F,0x290F,0x2910,0x2910,0x290F,0x290F,0x2930,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x2910,0x2910,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x2930,0x292F,0x2910,0x210F,0x210F,0x2930,0x212F,0x292F,0x210F,0x212F,0x210F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x1932,0x1932,0x1953,0x1153,0x1174,0x1196,0x11D7,0x1218,0x1A19,0x1A19,0x19F8,0x11B7,0x1155,0x1134,0x1133,0x1933,0x1932,0x2131,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x292F,0x292F,0x292F,0x212F,0x292F,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x18F0,0x1111,0x1112,0x1174,0x11F7,0x11F8,0x1219,0x11F8,0x0996,0x0114,0x0114,0x0934,0x1175,0x1195,0x0976,0x0976,0x11B7,0x19F8,0x11B7,0x1175,0x1112,0x1931,0x2110,0x2130,0x210F,0x210F,0x212F,0x212F,0x2130,0x210F,0x2110,0x210F,0x210F,0x290F,0x2910,0x2910,0x2110,0x2930,0x2110,0x2110,0x212F,0x2130,0x2930,0x2930,0x210F,0x210F,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2110,0x2130,0x2130,0x2111,0x1911,0x10F2,0x19D6,0x19F7,0x11B7,0x11B7,0x0976,0x0955,0x0934,0x0934,0x0954,0x0954,0x0955,0x0976,0x09B7,0x11D8,0x11D8,0x11B7,0x0954,0x0933,0x1133,0x1113,0x1132,0x0912,0x1133,0x1133,0x1133,0x1132,0x1133,0x1133,0x1132,0x1132,0x1113,0x1112,0x1113,0x1113,0x1113,0x1913,0x1113,0x1112,0x1112,0x1113,0x1113,0x1113,0x1133,0x1133,0x1133,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1112,0x1132,0x1112,0x1112,0x1112,0x1112,0x1132,0x1133,0x1133,0x1174,0x1174,0x0934,0x1155,0x11B6,0x19F7,0x2218,0x19F7,0x19B6,0x1974,0x1112,0x1112,0x1932,0x2131,0x2131,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2130,0x2130,0x212F,0x212F,0x210F,0x210F,0x2130,0x210F,0x2110,0x2930,0x212F,0x210F,0x210F,0x2910,0x210F,0x210F,0x212F,0x2130,0x212F,0x212F,0x2130,0x210F,0x2130,0x2930,0x210F,0x2930,0x212F,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x212F,0x212F,0x210F,0x210F,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x210F,0x290F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2910,0x2930,0x290F,0x210F,0x210F,0x210F,0x2130,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x20F0,0x18CF,0x83FC,0x739B,0x737B,0x737B,0x6B5B,0x735B,0x186F,0x188F,0x20D0,0x28F0,0x20EF,0x20EF,0x20EF,0x20F0,0x10AF,0x2952,0x73BC,0x6B7B,0x6B7C,0x6B5C,0x631B,0x6B1B,0x733B,0x6B1B,0x6B1B,0x6B3B,0x6B5B,0x6B5A,0x6B9B,0x635A,0x2971,0x18EF,0x1910,0x2110,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x2930,0x290F,0x210F,0x2930,0x210F,0x210F,0x2930,0x210F,0x2110,0x210F,0x2930,0x212F,0x2930,0x2910,0x210F,0x2910,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x290F,0x2910,0x2910,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x210F,0x212F,0x290F,0x210F,0x290F,0x212F,0x210F,0x290F,0x210F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2110,0x2930,0x2910,0x210F,0x212F,0x212F,0x212F,0x210F,0x2130,0x212F,0x210F,0x2110,0x2130,0x2110,0x1931,0x1932,0x1133,0x1994,0x19D6,0x19D6,0x19B5,0x1994,0x1132,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2131,0x1932,0x1932,0x1153,0x19B6,0x2217,0x21F7,0x1994,0x1112,0x1911,0x2131,0x2131,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x212F,0x2930,0x290F,0x290F,0x2930,0x2110,0x2930,0x2930,0x210F,0x290F,0x2110,0x2930,0x212F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2930,0x290F,0x292F,0x290F,0x2930,0x2910,0x290F,0x2910,0x2910,0x2930,0x2110,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x2110,0x2110,0x2930,0x2151,0x1931,0x1911,0x1113,0x1154,0x1996,0x19D7,0x19F8,0x11D7,0x11B7,0x11D8,0x11F8,0x11D8,0x19D8,0x19D7,0x19B6,0x1995,0x2174,0x2973,0x2952,0x2951,0x3171,0x3171,0x3171,0x3171,0x3151,0x3171,0x3171,0x3971,0x3971,0x3950,0x4150,0x410E,0x510E,0xDCDC,0xDCBA,0xDC99,0xDC58,0xDC58,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xE457,0xDC16,0xDC36,0xDC57,0xDC57,0xDC57,0xDC57,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC16,0xDC17,0xDC37,0xDC37,0xDC17,0xDC17,0xDC17,0xDBF6,0xDC16,0xDC16,0xDC17,0xDC16,0xDC16,0xDC16,0xDBF6,0xDC17,0xDC17,0xDBF7,0xDBF7,0xDC17,0xDC17,0xDC38,0xDC59,0xD459,0x79F0,0x2809,0x38AD,0x390F,0x310F,0x3130,0x3150,0x3150,0x3150,0x2950,0x2950,0x2950,0x2950,0x2950,0x2930,0x2951,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2950,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2110,0x2910,0x2930,0x2930,0x2930,0x2950,0x2930,0x2930,0x2930,0x290F,0x290F,0x292F,0x210F,0x290F,0x210F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x292F,0x290F,0x290F,0x290F,0x20EF,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x292F,0x212F,0x292F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x212F,0x210F,0x210F,0x2130,0x2130,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x2930,0x212F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x210F,0x212F,0x2130,0x210F,0x210F,0x210F,0x2130,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x1930,0x1931,0x1931,0x1133,0x19D6,0x1A17,0x11D6,0x1195,0x1132,0x1911,0x2111,0x2110,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x292F,0x290F,0x210F,0x2930,0x2930,0x2930,0x290F,0x210F,0x292F,0x292F,0x2930,0x290F,0x290F,0x290F,0x292F,0x292F,0x2930,0x2930,0x2930,0x292F,0x292F,0x210F,0x2110,0x2930,0x2930,0x2930,0x2110,0x210F,0x20CF,0x188F,0x204F,0x9B9D,0x931C,0x9B1D,0x9AFC,0x9ADC,0x9ABC,0x9A9C,0x9A7C,0x9A7C,0xA29C,0x9A7C,0x9A7B,0x9A9B,0x9A9B,0x9A9B,0x92BA,0x92FA,0x935B,0x286F,0x28D0,0x28EF,0x290F,0x210F,0x290F,0x20EF,0x28D0,0x286F,0x282F,0x92DB,0x9ADC,0xA2DD,0x9ABC,0x927C,0x92BC,0x929C,0x8ADC,0x8ADC,0x7A7A,0x82BB,0x931D,0x8ADC,0x92DC,0x92BC,0x92BC,0x929C,0x92BC,0x92DC,0x9B5D,0x5154,0x3070,0x30D0,0x28F0,0x2930,0x290F,0x292F,0x210F,0x210F,0x20EF,0x208E,0x206F,0x935C,0x92FD,0x92DD,0x9ABD,0x929C,0x92BD,0x8A7B,0x8A9B,0x931C,0xA3FF,0x2870,0x206F,0x20CF,0x20EF,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x28F0,0x20AF,0x2870,0x9B7C,0x9B3D,0x9AFD,0x92BC,0x92BC,0x92BC,0x8ABC,0x92FC,0x933C,0x82FA,0x2870,0x28B0,0x20D0,0x2910,0x20F0,0x2110,0x2110,0x2110,0x2110,0x2110,0x2111,0x1911,0x1932,0x1932,0x1153,0x1174,0x11B5,0x11B6,0x19F7,0x1A17,0x19F7,0x19F7,0x19F7,0x19D6,0x1995,0x1133,0x1112,0x1911,0x1932,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2130,0x2130,0x2110,0x2930,0x2930,0x2930,0x2930,0x2130,0x2130,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2930,0x2130,0x2110,0x2131,0x2152,0x1911,0x1911,0x1932,0x1133,0x1174,0x19B6,0x21F7,0x2218,0x19D6,0x1174,0x1133,0x1112,0x1911,0x1931,0x2131,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,
  0x210F,0x212F,0x210F,0x2930,0x210F,0x2930,0x2930,0x210F,0x290F,0x290F,0x2910,0x210F,0x210F,0x290F,0x2910,0x210F,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x210F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x2910,0x2910,0x290F,0x2910,0x292F,0x290F,0x290F,0x290F,0x210F,0x212F,0x290F,0x290F,0x2910,0x2930,0x210F,0x210F,0x292F,0x292F,0x292F,0x292F,0x212F,0x292F,0x212F,0x2130,0x2130,0x2130,0x1931,0x1931,0x1932,0x1932,0x1133,0x1153,0x1175,0x11B6,0x11D7,0x11F8,0x1A19,0x1A19,0x19F9,0x1197,0x1175,0x1154,0x1133,0x1912,0x1931,0x2131,0x2131,0x2130,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x292F,0x292F,0x210F,0x210F,0x2930,0x212F,0x292F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x1910,0x1911,0x1111,0x1153,0x11B6,0x11F8,0x1218,0x1218,0x09B6,0x0955,0x0114,0x0934,0x0975,0x0975,0x0976,0x0976,0x11D7,0x1A18,0x19D7,0x1174,0x1132,0x1931,0x2130,0x2110,0x210F,0x210F,0x212F,0x2130,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x210F,0x210F,0x2110,0x2110,0x2910,0x2110,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x2930,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2111,0x1911,0x1112,0x1174,0x21F7,0x19D7,0x11B7,0x0996,0x0955,0x0955,0x0934,0x0934,0x0134,0x0975,0x11B7,0x11D7,0x11D7,0x19D7,0x1155,0x1133,0x1133,0x1112,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1931,0x1931,0x1911,0x1931,0x1111,0x1911,0x1911,0x1911,0x1911,0x1911,0x18F1,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x10F1,0x1911,0x1911,0x1911,0x1111,0x1111,0x1112,0x1112,0x1133,0x0934,0x11B6,0x19D7,0x21F7,0x21F7,0x19B6,0x1974,0x1133,0x1912,0x1932,0x2132,0x2111,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x2130,0x2930,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x2930,0x212F,0x212F,0x212F,0x2930,0x210F,0x212F,0x210F,0x2930,0x210F,0x210F,0x2930,0x2930,0x210F,0x2930,0x210F,0x210F,0x212F,0x212F,0x212F,0x2930,0x290F,0x290F,0x2930,0x290F,0x212F,0x212F,0x2930,0x290F,0x2930,0x210F,0x212F,0x212F,0x210F,0x2930,0x2930,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x210F,0x2930,0x2930,0x210F,0x2110,0x2110,0x2930,0x2110,0x2910,0x2930,0x290F,0x210F,0x212F,0x2950,0x2930,0x210F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2110,0x2110,0x20F0,0x18AF,0x7BBB,0x737B,0x735B,0x735B,0x735B,0x7B7C,0x5237,0x2090,0x28D0,0x28D0,0x20EF,0x20EF,0x2110,0x2110,0x18AF,0x2931,0x739C,0x739C,0x6B5B,0x6B1B,0x6B1B,0x731B,0x731B,0x731B,0x6B1B,0x6B3B,0x6B5B,0x739B,0x6B5A,0x2952,0x18EF,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x2930,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x2110,0x210F,0x210F,0x2930,0x210F,0x290F,0x290F,0x210F,0x2910,0x290F,0x210F,0x290F,0x2930,0x210F,0x210F,0x2930,0x2930,0x290F,0x290F,0x2910,0x290F,0x2910,0x2910,0x2910,0x2110,0x2930,0x212F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x212F,0x212F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x1931,0x1132,0x1153,0x1195,0x19D6,0x19D6,0x19B5,0x1994,0x1152,0x1932,0x2151,0x2131,0x2130,0x2110,0x2130,0x2130,0x2131,0x2152,0x1933,0x1153,0x19B5,0x21F7,0x21F7,0x1994,0x1112,0x1911,0x2131,0x2131,0x2110,0x2130,0x2110,0x2930,0x2110,0x2930,0x2930,0x212F,0x290F,0x2930,0x2930,0x212F,0x2930,0x2930,0x210F,0x2930,0x2110,0x2110,0x210F,0x210F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x292F,0x2930,0x2930,0x290F,0x2910,0x2910,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x292F,0x2930,0x2130,0x2130,0x2131,0x1911,0x1112,0x1113,0x1996,0x19D7,0x1A19,0x19F8,0x11D8,0x09B7,0x11B7,0x11B8,0x11B8,0x19D8,0x19D7,0x19D7,0x21B6,0x2195,0x2173,0x2972,0x2951,0x3151,0x3171,0x3171,0x3171,0x3171,0x3992,0x3151,0x3971,0x3951,0x4151,0x4150,0x40EE,0x592E,0xDCDC,0xDC9A,0xDC99,0xDC78,0xE458,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC36,0xDC36,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC17,0xE437,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC17,0xDC17,0xDC16,0xDC17,0xDC16,0xDC16,0xDC17,0xDBF6,0xDC16,0xDC16,0xDC16,0xDBF6,0xDBF6,0xDBF6,0xDC16,0xDBF6,0xDBF6,0xDC17,0xDBF6,0xDBF7,0xDC17,0xDC17,0xDC18,0xD438,0xDC59,0xD47A,0x698F,0x388C,0x410E,0x390F,0x3130,0x3130,0x3130,0x3130,0x3151,0x3151,0x3151,0x2950,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2930,0x210F,0x2130,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2951,0x2930,0x2930,0x2930,0x290F,0x290F,0x292F,0x210F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x28EF,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x292F,0x210F,0x210F,0x212F,0x292F,0x210F,0x212F,0x212F,0x210F,0x2130,0x210F,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x212F,0x2930,0x212F,0x210F,0x2930,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x2110,0x2110,0x2110,0x2130,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x11D6,0x11F7,0x11D6,0x1195,0x1132,0x1911,0x2131,0x2110,0x2130,0x2930,0x2910,0x290F,0x2930,0x2930,0x210F,0x290F,0x2930,0x2930,0x210F,0x2930,0x292F,0x2930,0x2930,0x210F,0x210F,0x290F,0x292F,0x2930,0x210F,0x292F,0x292F,0x292F,0x212F,0x2930,0x2930,0x2930,0x292F,0x292F,0x210F,0x2930,0x2110,0x2930,0x210F,0x2110,0x2110,0x20CF,0x208F,0x204F,0x9B7D,0xA31D,0xA2BC,0xA2BC,0xA29C,0xA27C,0xA25C,0xAA5C,0xAA7D,0xAA5C,0xAA5C,0xAA5C,0xAA7C,0xA27C,0xAA9C,0xA2BB,0x9ADB,0xA37C,0x284F,0x30D0,0x28CF,0x20EF,0x290F,0x2910,0x28D0,0x28B0,0x304F,0x69B6,0x9ADC,0xA2BC,0xAA9C,0xAA9D,0xA27C,0xA29C,0x9ABC,0x9ABC,0x9B1D,0x7A19,0x4893,0x92DC,0x9ADC,0x9ABC,0x9ABC,0xA2BD,0xA29D,0xA2BD,0x9A9C,0x9ADC,0x8ABB,0x3891,0x30B0,0x30D0,0x28EF,0x290F,0x292F,0x292F,0x210F,0x20EF,0x208E,0x284F,0x9B1D,0x9ADD,0xA2BD,0xA29D,0xA2BD,0xA29D,0xA29C,0x9A9C,0x9AFC,0xABDF,0x3050,0x2870,0x20AF,0x28EF,0x2910,0x210F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x20CF,0x288F,0x284F,0x9B1C,0xA2FC,0xA2BC,0xA29C,0xA29C,0xA29D,0x9A9C,0x9ABC,0x9B1D,0x8ADB,0x3070,0x30B0,0x28D0,0x2910,0x28F0,0x20F0,0x2110,0x2110,0x2111,0x2111,0x2131,0x1932,0x1932,0x1954,0x1995,0x19D6,0x19F7,0x19F7,0x1A18,0x11F7,0x1A18,0x19F8,0x11F7,0x19F7,0x19D7,0x1995,0x1133,0x1112,0x1932,0x1932,0x2132,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2931,0x2130,0x2930,0x2130,0x2110,0x2130,0x2130,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2131,0x2131,0x2130,0x2130,0x2130,0x2131,0x2131,0x2131,0x2131,0x2132,0x2132,0x1912,0x1132,0x1133,0x1174,0x19B6,0x2217,0x21F8,0x21D7,0x1995,0x1113,0x1112,0x1911,0x1931,0x2131,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x212F,0x2130,0x212F,0x2130,0x212F,0x210F,0x2930,0x210F,0x290F,0x290F,0x2930,0x2930,0x210F,0x290F,0x290F,0x290F,0x2910,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,
  0x212F,0x212F,0x212F,0x210F,0x2930,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2930,0x290F,0x2930,0x210F,0x290F,0x290F,0x2910,0x290F,0x290F,0x2910,0x2910,0x292F,0x290F,0x210F,0x290F,0x2930,0x2930,0x290F,0x290F,0x2910,0x2930,0x2930,0x2910,0x2930,0x292F,0x292F,0x290F,0x292F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2131,0x1931,0x2152,0x1952,0x1952,0x1133,0x1154,0x1175,0x11B6,0x11D8,0x1A19,0x1A19,0x1A19,0x11D8,0x11B7,0x1155,0x1134,0x1133,0x1111,0x1931,0x1931,0x2131,0x1910,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x292F,0x292F,0x212F,0x210F,0x210F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x292F,0x290F,0x210F,0x2130,0x210F,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1111,0x1132,0x1175,0x19F7,0x1A19,0x1218,0x11D7,0x0955,0x0114,0x0934,0x0954,0x0975,0x0955,0x0976,0x19F7,0x19F8,0x19D7,0x1174,0x1132,0x2131,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x210F,0x210F,0x2930,0x2930,0x290F,0x2930,0x210F,0x2910,0x2110,0x2930,0x2130,0x2930,0x2930,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x1911,0x1112,0x1133,0x19B5,0x19B6,0x11D7,0x11D7,0x11D7,0x0976,0x0975,0x0996,0x1196,0x19D7,0x19F7,0x11B7,0x1196,0x1155,0x1134,0x1933,0x1932,0x1932,0x1931,0x1911,0x1910,0x1911,0x1911,0x1931,0x1930,0x2131,0x2131,0x2131,0x1910,0x1910,0x1910,0x2131,0x2111,0x2131,0x2111,0x2111,0x2111,0x2111,0x2111,0x2131,0x1910,0x2111,0x2131,0x2131,0x2111,0x2131,0x2131,0x2110,0x1910,0x2110,0x2110,0x2110,0x1910,0x2131,0x2131,0x1931,0x1930,0x2131,0x2131,0x2131,0x1911,0x1931,0x1931,0x1931,0x1911,0x10F1,0x10F2,0x1133,0x0933,0x19B6,0x21F7,0x21F7,0x21F7,0x19B6,0x1154,0x1133,0x1912,0x1911,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x292F,0x210F,0x212F,0x212F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2910,0x290F,0x210F,0x212F,0x212F,0x2130,0x212F,0x2930,0x210F,0x212F,0x210F,0x2930,0x210F,0x292F,0x290F,0x2930,0x290F,0x2930,0x212F,0x2110,0x2110,0x2930,0x290F,0x2930,0x210F,0x2930,0x212F,0x2930,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x2110,0x2110,0x2910,0x2910,0x290F,0x290F,0x212F,0x210F,0x2930,0x2950,0x210F,0x210F,0x210F,0x210F,0x2930,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x18AF,0x739A,0x7B9B,0x735B,0x733B,0x731B,0x7B1B,0x837C,0x5A37,0x28B0,0x28D0,0x28F0,0x20CF,0x20CF,0x20F0,0x188F,0x3993,0x737B,0x735B,0x733B,0x731B,0x731B,0x6AFB,0x731B,0x733B,0x735B,0x735B,0x739B,0x6B3A,0x18D0,0x18CF,0x2110,0x2110,0x210F,0x210F,0x210F,0x212F,0x210F,0x292F,0x212F,0x210F,0x2930,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x290F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x290F,0x2910,0x2910,0x2910,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x212F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x212F,0x292F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x2131,0x1932,0x1133,0x1153,0x19D5,0x19F6,0x19F6,0x19D5,0x1993,0x1131,0x1931,0x2172,0x2151,0x2130,0x2110,0x2130,0x2131,0x2152,0x1932,0x1933,0x1133,0x19B5,0x21F7,0x21F7,0x1995,0x1132,0x1932,0x2131,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2930,0x212F,0x212F,0x290F,0x290F,0x212F,0x212F,0x2930,0x2930,0x212F,0x2930,0x210F,0x2930,0x290F,0x290F,0x210F,0x2910,0x2930,0x290F,0x290F,0x290F,0x292F,0x210F,0x2930,0x2930,0x210F,0x2930,0x2110,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2131,0x2131,0x1911,0x1112,0x1134,0x19D8,0x19F8,0x19F9,0x19F8,0x11B7,0x0997,0x1197,0x0997,0x1197,0x1197,0x19D7,0x2218,0x21D7,0x21B6,0x2194,0x2973,0x3172,0x3172,0x3172,0x3151,0x3171,0x3171,0x3972,0x3971,0x3971,0x3951,0x4151,0x4130,0x40EE,0x616F,0xDCFC,0xDC9A,0xDC79,0xDC58,0xE458,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC36,0xDC37,0xDC37,0xDC37,0xDC37,0xE457,0xDC37,0xDC37,0xE437,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC17,0xDC37,0xDC17,0xDC17,0xDC37,0xDC16,0xDC17,0xDC17,0xDC16,0xDC17,0xDC17,0xDC17,0xDC16,0xDC16,0xDBF6,0xDC17,0xDBF6,0xDC17,0xDBF6,0xDBF6,0xDBF6,0xDBD6,0xDBF6,0xDBF7,0xDC17,0xDC17,0xDC17,0xD417,0xDC58,0xDC7A,0xCC59,0x614F,0x386C,0x38EE,0x390F,0x3130,0x3130,0x3151,0x3151,0x3151,0x3131,0x2930,0x3151,0x2930,0x2951,0x2951,0x2930,0x2930,0x2930,0x2930,0x3151,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2110,0x2930,0x2910,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x28EF,0x28EF,0x28EF,0x28EE,0x28EF,0x28EE,0x28EE,0x28EE,0x28EE,0x28EE,0x28EE,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x212F,0x292F,0x292F,0x2930,0x2130,0x2930,0x2130,0x2130,0x2130,0x212F,0x292F,0x210F,0x290F,0x290F,0x212F,0x212F,0x212F,0x2130,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x292F,0x2930,0x210F,0x290F,0x292F,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x210F,0x2930,0x212F,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x19D6,0x19F7,0x11F7,0x1195,0x1112,0x1911,0x2131,0x2130,0x2130,0x2930,0x2110,0x2910,0x210F,0x212F,0x2930,0x2110,0x212F,0x212F,0x210F,0x210F,0x292F,0x2930,0x2930,0x210F,0x290F,0x292F,0x2930,0x292F,0x2930,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2950,0x2930,0x212F,0x210F,0x2930,0x2110,0x2930,0x210F,0x210F,0x20EF,0x20CF,0x208F,0x3070,0xAB7E,0xAAFD,0xAABD,0xAA7D,0xB27D,0xB27D,0xBA9E,0xBA7E,0xB23C,0xB23D,0xBA7D,0xB25D,0xB27D,0xBA9D,0xB2BD,0xAABC,0xA2DB,0xA35C,0x282E,0x308F,0x28CF,0x20CF,0x28EF,0x28F0,0x30D0,0x38D1,0x4091,0x9ABB,0xAABC,0xB29D,0xB29D,0xB27D,0xB27D,0xAA7C,0xAABC,0xA2DC,0xA33D,0x50B3,0x4031,0x8A7A,0xAAFD,0xA2BC,0xA29D,0xAA9D,0xB2BE,0xB2BE,0xAABD,0xAADD,0xAB1D,0x6976,0x3850,0x30D0,0x28AF,0x20EF,0x20EE,0x210E,0x210F,0x20CE,0x206E,0x282F,0xAB5E,0xAADD,0xB2BE,0xAA7D,0xB29E,0xB27D,0xAA9D,0xAA9D,0xAAFD,0xAB9E,0x3030,0x2870,0x288F,0x28CF,0x2910,0x2930,0x2930,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x20EF,0x28CF,0x288F,0x3870,0xA31C,0xAADC,0xB2DD,0xB2BD,0xAA5C,0xAA5C,0xAA9D,0xAABD,0xAB1D,0x9AFC,0x3030,0x3070,0x28D0,0x20CF,0x20EF,0x2910,0x2910,0x2910,0x2111,0x2131,0x2132,0x1932,0x1954,0x19B5,0x19D6,0x19D7,0x19D7,0x11D7,0x11D7,0x11D7,0x11B7,0x11B7,0x11D7,0x19F8,0x19F7,0x19D7,0x1175,0x1113,0x1133,0x1932,0x2153,0x1932,0x1911,0x1931,0x1931,0x1931,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2111,0x2111,0x2111,0x2131,0x1911,0x2131,0x2132,0x1931,0x2131,0x2131,0x2131,0x1931,0x2131,0x2131,0x2111,0x2131,0x1932,0x1912,0x1932,0x1112,0x1133,0x1154,0x1995,0x21F7,0x21F7,0x21F7,0x1975,0x1113,0x10F2,0x1911,0x2131,0x2131,0x2131,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x210F,0x210F,0x210F,0x210F,0x212F,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x2930,0x2930,0x2930,0x2910,0x2910,0x2910,0x210F,0x2110,0x2910,0x210F,0x210F,0x2930,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,
  0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x290F,0x210F,0x210F,0x210F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x2910,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x290F,0x2910,0x2910,0x2910,0x2910,0x2110,0x210F,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x2151,0x2151,0x2131,0x1931,0x1932,0x1932,0x1133,0x1154,0x1175,0x1196,0x11D8,0x11F9,0x1A1A,0x1A19,0x19F8,0x1197,0x1155,0x1134,0x1133,0x1932,0x1931,0x2131,0x1910,0x1910,0x2150,0x2130,0x2130,0x2130,0x210F,0x212F,0x2930,0x2930,0x2130,0x212F,0x210F,0x2110,0x2110,0x2930,0x292F,0x292F,0x292F,0x290F,0x292F,0x292F,0x292F,0x290F,0x290F,0x2930,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x1931,0x1911,0x1132,0x1154,0x11B6,0x11F8,0x1A39,0x1A18,0x0996,0x0155,0x0955,0x0955,0x0955,0x0955,0x11B6,0x19F8,0x19F7,0x19D6,0x1974,0x1911,0x1910,0x2130,0x2110,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x210F,0x210F,0x290F,0x290F,0x210F,0x2930,0x210F,0x2910,0x2910,0x2110,0x2930,0x2930,0x2930,0x2930,0x2930,0x210F,0x2930,0x2930,0x210F,0x2930,0x2110,0x2910,0x2910,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x1911,0x1911,0x1112,0x1153,0x19B6,0x19F7,0x19F7,0x19F7,0x19F7,0x19F7,0x19D7,0x19F7,0x19D7,0x19D7,0x19D7,0x1995,0x1134,0x1933,0x1932,0x1932,0x2131,0x2131,0x2151,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x1930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x1910,0x1931,0x2131,0x1911,0x1112,0x1113,0x1134,0x1995,0x19D7,0x2218,0x21F7,0x1996,0x1974,0x1113,0x1912,0x1911,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2910,0x290F,0x210F,0x2130,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2930,0x2930,0x292F,0x292F,0x290F,0x290F,0x212F,0x2930,0x210F,0x2110,0x290F,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x210F,0x212F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x2930,0x210F,0x290F,0x210F,0x2110,0x2910,0x2930,0x2930,0x212F,0x2930,0x210F,0x2930,0x2930,0x210F,0x290F,0x210F,0x210F,0x212F,0x210F,0x210F,0x20EF,0x2110,0x20EF,0x2110,0x108E,0x6B39,0x83BC,0x7B5B,0x7B1B,0x7B1B,0x7B1B,0x7B1B,0x8B7C,0x6A78,0x28B0,0x28D0,0x28F0,0x20AF,0x20AF,0x186E,0x3994,0x7B5C,0x733B,0x733C,0x731C,0x731B,0x7B1C,0x731B,0x7B3B,0x7B5B,0x7B9C,0x6B1A,0x2911,0x18AF,0x20F0,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x212F,0x2930,0x210F,0x210F,0x210F,0x2930,0x210F,0x290F,0x210F,0x210F,0x210F,0x2930,0x290F,0x210F,0x210F,0x290F,0x2910,0x2930,0x2910,0x2910,0x2910,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x292F,0x292F,0x212F,0x212F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1930,0x1931,0x1932,0x1153,0x1174,0x19D6,0x19F7,0x21F6,0x21D5,0x1152,0x1111,0x1931,0x2151,0x2151,0x1910,0x2110,0x2130,0x2131,0x2131,0x1932,0x1112,0x1133,0x19B6,0x21F7,0x21F7,0x1995,0x1932,0x1932,0x2131,0x2111,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x212F,0x210F,0x290F,0x2930,0x292F,0x210F,0x212F,0x2930,0x210F,0x210F,0x290F,0x2930,0x290F,0x290F,0x2910,0x2930,0x2930,0x210F,0x292F,0x290F,0x210F,0x210F,0x290F,0x2930,0x210F,0x2930,0x2110,0x2130,0x2130,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x2130,0x212F,0x212F,0x2130,0x2930,0x2130,0x2131,0x1911,0x1112,0x1175,0x21F8,0x19D8,0x19D8,0x0977,0x0956,0x0976,0x1176,0x0976,0x0976,0x1176,0x19B7,0x2218,0x19D7,0x21B6,0x2195,0x2973,0x2972,0x3152,0x3172,0x3172,0x3172,0x3172,0x3972,0x3972,0x3971,0x4171,0x4151,0x4150,0x40CE,0x6990,0xDCDC,0xD479,0xDC99,0xDC58,0xDC58,0xDC37,0xDC37,0xDC37,0xDC17,0xE457,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xE437,0xDC37,0xDC37,0xDC37,0xDC37,0xE437,0xDC37,0xDC17,0xDC37,0xDC37,0xDC37,0xDC17,0xDC17,0xDC16,0xDC17,0xDC17,0xDC17,0xDC17,0xDC17,0xDC17,0xDBF6,0xDBF6,0xDC17,0xDC16,0xDC17,0xDBF6,0xDBF6,0xDBF6,0xDBF6,0xDBF6,0xDBD6,0xDBD6,0xDBF7,0xDC17,0xDC17,0xDC17,0xDC17,0xDC38,0xD459,0xCC39,0xB3B7,0x48AC,0x40AD,0x390F,0x3930,0x3150,0x3150,0x3151,0x3151,0x3151,0x3131,0x3151,0x3151,0x2950,0x2951,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x212F,0x2950,0x292F,0x210F,0x2930,0x2910,0x2910,0x2910,0x2910,0x20EF,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x310F,0x310F,0x30EF,0x28EE,0x30EE,0x30CE,0x30EE,0x30EE,0x30EE,0x30EE,0x30EE,0x30EE,0x30EE,0x30EE,0x30EE,0x30EE,0x28EE,0x30EE,0x28EE,0x290F,0x290F,0x290F,0x290F,0x210F,0x292F,0x292F,0x292F,0x2930,0x2930,0x2130,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x2930,0x290F,0x210F,0x210F,0x210F,0x212F,0x210F,0x210F,0x290F,0x290F,0x2930,0x2930,0x290F,0x292F,0x212F,0x212F,0x210F,0x292F,0x290F,0x290F,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2930,0x2930,0x2930,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x19D6,0x19F7,0x11F7,0x1195,0x1132,0x1911,0x2131,0x2130,0x2130,0x2130,0x2930,0x2930,0x210F,0x292F,0x2110,0x210F,0x212F,0x2930,0x210F,0x210F,0x2930,0x2930,0x210F,0x290F,0x290F,0x292F,0x2930,0x2930,0x290F,0x292F,0x2930,0x2930,0x2110,0x210F,0x2930,0x2950,0x2930,0x212F,0x2930,0x2930,0x2930,0x2130,0x210F,0x210F,0x210F,0x20AF,0x206F,0x304F,0xB39E,0xB2DD,0xB27C,0xBA7D,0xB25D,0xC27E,0xC29E,0xC25E,0xBA3D,0xBA3D,0xC25D,0xC27E,0xC27E,0xBA7D,0xBA9D,0xB2BD,0xA2BB,0xA33C,0x302F,0x30B0,0x28AF,0x28D0,0x28F0,0x30D0,0x38B1,0x3891,0x7196,0xAAFC,0xB2BD,0xBA9D,0xBA7D,0xBA9E,0xBABE,0xB29D,0xB2BC,0xB31D,0x927A,0x3810,0x3810,0x7176,0xAADD,0xAA9C,0xB29D,0xB2BE,0xBABE,0xBABE,0xBADE,0xB2DE,0xB2DD,0xB33E,0x4051,0x3891,0x28D0,0x28EF,0x210F,0x210F,0x210F,0x20CE,0x206E,0x280E,0xAB5E,0xB2DE,0xB29D,0xBA7E,0xBA7E,0xBA7D,0xB29D,0xB2BD,0xB2DD,0xBB9F,0x3830,0x3070,0x288F,0x28EF,0x2910,0x2930,0x290F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x210F,0x20EF,0x28CF,0x288F,0x3850,0xAB1C,0xBAFD,0xBA9D,0xBA7D,0xB25D,0xBA7D,0xB27D,0xB2BD,0xB2FE,0xA2FD,0x3830,0x3090,0x28B0,0x28F0,0x28EF,0x2910,0x2930,0x2930,0x2110,0x2111,0x1911,0x1932,0x1174,0x19D6,0x19D7,0x19F7,0x11D7,0x11B7,0x0976,0x0976,0x0976,0x0976,0x0996,0x11D7,0x19F8,0x11D7,0x19B6,0x1175,0x1133,0x1113,0x1132,0x1912,0x1932,0x1912,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1911,0x1912,0x1932,0x1912,0x1912,0x1931,0x1911,0x1931,0x1911,0x1911,0x1911,0x1911,0x1911,0x1111,0x1112,0x1112,0x1133,0x1133,0x1154,0x19B6,0x21F7,0x21F7,0x21F7,0x1175,0x1134,0x10F2,0x18F1,0x1911,0x2131,0x2131,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x210F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2910,0x2110,0x2930,0x2110,0x2110,0x2910,0x2930,0x2910,0x2910,0x2930,0x2910,0x2930,0x2930,0x2910,0x2910,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,
  0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2930,0x2910,0x210F,0x210F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x2910,0x2910,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x210F,0x2110,0x2910,0x2910,0x210F,0x2910,0x2910,0x290F,0x290F,0x292F,0x210F,0x210F,0x212F,0x2130,0x2130,0x2150,0x2130,0x2131,0x1931,0x1931,0x1132,0x1133,0x1154,0x1175,0x1196,0x11D8,0x11F9,0x1A1A,0x1A19,0x19F8,0x1197,0x1155,0x1133,0x1132,0x1932,0x1931,0x1931,0x1910,0x2131,0x2151,0x2130,0x2130,0x2130,0x2110,0x2130,0x2930,0x210F,0x212F,0x210F,0x210F,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x1931,0x1911,0x1112,0x1133,0x1175,0x11D7,0x1A18,0x11F8,0x11F7,0x0976,0x0975,0x0976,0x0976,0x0996,0x19F8,0x11D7,0x11B6,0x19D6,0x1974,0x1911,0x1910,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x212F,0x210F,0x210F,0x290F,0x2910,0x212F,0x2130,0x2110,0x2910,0x2110,0x2110,0x2930,0x2930,0x290F,0x210F,0x210F,0x290F,0x210F,0x210F,0x2930,0x210F,0x2910,0x210F,0x210F,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x2130,0x2131,0x1931,0x1111,0x1132,0x1995,0x19F7,0x2217,0x19F7,0x19F7,0x19F7,0x19D7,0x19F7,0x19F7,0x19D6,0x21D6,0x1174,0x1112,0x1932,0x2152,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2110,0x2930,0x2930,0x2110,0x2110,0x2110,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x290F,0x2930,0x2110,0x2930,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2150,0x2130,0x2151,0x2152,0x1932,0x10F2,0x1133,0x1154,0x19B6,0x21F7,0x2218,0x21F7,0x19B6,0x1154,0x1113,0x1912,0x1932,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x210F,0x210F,0x2110,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x210F,0x212F,0x212F,0x2930,0x290F,0x290F,0x210F,0x290F,0x2910,0x2910,0x2910,0x210F,0x2930,0x2930,0x292F,0x210F,0x2110,0x2110,0x2930,0x290F,0x290F,0x210F,0x212F,0x212F,0x2930,0x210F,0x212F,0x212F,0x2110,0x2110,0x2930,0x290F,0x210F,0x2930,0x212F,0x212F,0x2930,0x210F,0x212F,0x212F,0x210F,0x210F,0x2110,0x2130,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x2110,0x2110,0x2110,0x210F,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2930,0x2930,0x212F,0x210F,0x2110,0x2930,0x2930,0x2930,0x5A97,0x83BC,0x7B5B,0x7B3B,0x7B1B,0x7AFB,0x82FB,0x831B,0x833B,0x72D9,0x3932,0x28D0,0x288F,0x208F,0x206F,0x4173,0x837C,0x7B3C,0x833C,0x7B1C,0x72FB,0x7B1C,0x7B3C,0x7B5C,0x7B7C,0x62D9,0x20F1,0x20D0,0x20D0,0x20EF,0x2110,0x210F,0x210F,0x210F,0x210F,0x292F,0x292F,0x210F,0x210F,0x292F,0x290F,0x210F,0x212F,0x212F,0x210F,0x210F,0x2930,0x210F,0x210F,0x210F,0x210F,0x2930,0x290F,0x210F,0x212F,0x210F,0x2910,0x210F,0x290F,0x210F,0x210F,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x212F,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x212F,0x210F,0x212F,0x2130,0x2950,0x2130,0x1930,0x1911,0x1131,0x1132,0x1154,0x19B5,0x19F7,0x21F7,0x19D6,0x1994,0x1952,0x1910,0x1930,0x2151,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1912,0x1112,0x1133,0x19B6,0x21F7,0x21F7,0x1974,0x1932,0x1912,0x2111,0x2131,0x2111,0x2110,0x2130,0x2130,0x2110,0x210F,0x212F,0x2930,0x290F,0x2930,0x212F,0x212F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2930,0x212F,0x2910,0x2110,0x2930,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x2930,0x2930,0x2930,0x2110,0x2131,0x1911,0x1112,0x21F7,0x2239,0x19D8,0x1197,0x0935,0x0956,0x1176,0x1196,0x1196,0x1196,0x1176,0x19B7,0x2218,0x21F8,0x21B6,0x2195,0x2973,0x3173,0x3172,0x3172,0x3171,0x3151,0x3992,0x3972,0x3992,0x4172,0x4172,0x4171,0x4150,0x40EE,0x7211,0xDCFC,0xD499,0xDC99,0xDC58,0xDC58,0xDC37,0xDC37,0xDC57,0xDC57,0xDC37,0xE457,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC17,0xDC37,0xE437,0xDC17,0xDC17,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC16,0xDC16,0xDC16,0xDC16,0xDC17,0xDC17,0xDC17,0xDC17,0xDC17,0xDC17,0xDBF6,0xDBF6,0xDBF6,0xDC17,0xDBF6,0xDBF6,0xDBF6,0xDC17,0xDBF6,0xDBF6,0xDBF7,0xDBF6,0xDBF7,0xDBF6,0xDC17,0xDC17,0xDC38,0xDC38,0xD438,0xCC39,0xCC9B,0x594F,0x40EE,0x3930,0x3951,0x3151,0x3151,0x3151,0x3151,0x3151,0x3151,0x3151,0x2930,0x2930,0x2950,0x2950,0x2950,0x2950,0x2930,0x2950,0x2950,0x2930,0x2951,0x3131,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2930,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x310F,0x290F,0x290E,0x30EE,0x30EE,0x30CD,0x30CD,0x30CD,0x30CD,0x30AD,0x30AD,0x308C,0x308C,0x306C,0x306C,0x306C,0x306C,0x308D,0x30AD,0x30AD,0x30CE,0x30CE,0x30EE,0x30EE,0x30EE,0x28EE,0x28EE,0x290F,0x290F,0x210F,0x210F,0x290F,0x2110,0x2110,0x2930,0x2110,0x210F,0x210F,0x292F,0x292F,0x290F,0x212F,0x212F,0x210F,0x212F,0x210F,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x2930,0x2930,0x2930,0x2110,0x210F,0x2930,0x290F,0x290F,0x210F,0x2930,0x2930,0x210F,0x210F,0x210F,0x210F,0x290F,0x2930,0x292F,0x2930,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x19D6,0x1A17,0x11D7,0x11B5,0x1132,0x1911,0x2131,0x2130,0x2930,0x2930,0x210F,0x210F,0x210F,0x292F,0x210F,0x210F,0x210F,0x2930,0x212F,0x210F,0x2930,0x2930,0x212F,0x210F,0x292F,0x2930,0x2930,0x2930,0x2110,0x2930,0x2930,0x2930,0x2910,0x2110,0x2930,0x2930,0x2930,0x212F,0x210F,0x210F,0x2930,0x2930,0x2930,0x210F,0x210F,0x20CF,0x208F,0x38B1,0xBBBF,0xBAFD,0xBABE,0xBA7D,0xC25D,0xC25E,0xCA5E,0xCA5E,0xCA5E,0xCA5E,0xC23D,0xCA9E,0xC25D,0xC27D,0xBA7C,0xB29C,0xB2DC,0xBB9E,0x300F,0x3090,0x28B0,0x28AF,0x28D0,0x30D0,0x38B1,0x48B2,0xBB7E,0xB2DD,0xBABD,0xC2BE,0xC2BE,0xCABE,0xBA9D,0xBA9D,0xB2BC,0xBB3E,0x50B2,0x300F,0x3810,0x58B3,0x9A7B,0xB2DD,0xBADE,0xBABE,0xBA7D,0xBA9E,0xC2BE,0xBADE,0xBADE,0xC37F,0x79B7,0x4071,0x30B0,0x28EF,0x290F,0x290F,0x292F,0x28EF,0x288F,0x3050,0xB37E,0xBADE,0xBABE,0xC29E,0xBA7E,0xC29E,0xC29E,0xBABD,0xB2DD,0xC3BF,0x4050,0x3070,0x30B0,0x28F0,0x2910,0x2930,0x290F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x210F,0x2910,0x28CF,0x308F,0x48D2,0xAB1C,0xBADD,0xC2BE,0xC29E,0xC27D,0xC29E,0xBA7D,0xBABE,0xBB1E,0xB33E,0x3830,0x3890,0x30D0,0x28EF,0x2910,0x290F,0x2910,0x2930,0x2111,0x2111,0x1911,0x1112,0x1174,0x19D6,0x19F7,0x19F7,0x0996,0x0975,0x0975,0x0955,0x0135,0x0155,0x0976,0x0996,0x11D8,0x19F8,0x19F8,0x1196,0x0934,0x1134,0x1153,0x1133,0x1132,0x1112,0x1132,0x1132,0x1911,0x1911,0x1931,0x1131,0x1111,0x1932,0x1932,0x1932,0x1932,0x1112,0x1112,0x1112,0x1112,0x1132,0x1132,0x1132,0x1131,0x1132,0x1111,0x1111,0x1112,0x1132,0x1132,0x1133,0x1134,0x1114,0x1175,0x19B6,0x21F7,0x21F7,0x19B6,0x1175,0x1113,0x10F2,0x1911,0x2152,0x2131,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x210F,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2930,0x2910,0x2110,0x2930,0x2930,0x2930,0x2110,0x2130,0x2110,0x2930,0x2930,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,
  0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x2910,0x2910,0x212F,0x210F,0x290F,0x2930,0x290F,0x210F,0x210F,0x2930,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x212F,0x2930,0x2930,0x210F,0x2930,0x210F,0x2110,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2130,0x1931,0x1931,0x1132,0x1133,0x1154,0x1175,0x1197,0x11B8,0x19F9,0x1A19,0x1A19,0x19F8,0x11B7,0x1175,0x1154,0x1133,0x1932,0x1931,0x1911,0x2131,0x2151,0x2130,0x2110,0x2130,0x2130,0x210F,0x2930,0x2130,0x2110,0x210F,0x2110,0x2110,0x210F,0x292F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x292F,0x2910,0x2910,0x2910,0x210F,0x2110,0x2110,0x2110,0x2110,0x1911,0x1912,0x1133,0x1154,0x1196,0x11F8,0x1A18,0x1218,0x11D7,0x11D7,0x11B7,0x11B7,0x19F7,0x19F7,0x19D7,0x1195,0x1994,0x1953,0x1911,0x2110,0x2130,0x2110,0x210F,0x2130,0x2110,0x210F,0x2130,0x2130,0x2130,0x212F,0x210F,0x292F,0x290F,0x2910,0x2130,0x210F,0x2110,0x2910,0x2110,0x210F,0x2110,0x2110,0x290F,0x210F,0x2930,0x290F,0x210F,0x210F,0x2910,0x210F,0x290F,0x210F,0x2930,0x2930,0x2110,0x2110,0x2110,0x2930,0x2130,0x2130,0x2131,0x1931,0x1931,0x1132,0x1153,0x1995,0x19B5,0x19B6,0x19B6,0x11B6,0x11B5,0x11B5,0x1995,0x1995,0x1974,0x1133,0x1932,0x1931,0x1931,0x2131,0x2130,0x2130,0x2130,0x2150,0x2130,0x212F,0x2130,0x212F,0x212F,0x210F,0x212F,0x2130,0x210F,0x2930,0x210F,0x210F,0x2910,0x2910,0x2110,0x2110,0x2110,0x2930,0x2110,0x2110,0x2110,0x2130,0x2130,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x212F,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x210F,0x2950,0x2130,0x2130,0x2951,0x2152,0x1932,0x1112,0x1133,0x1134,0x1995,0x21F7,0x21F7,0x21F7,0x19B6,0x1974,0x1133,0x1932,0x1931,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x210F,0x210F,0x210F,0x290F,0x2930,0x210F,0x2930,0x2910,0x2910,0x290F,0x2930,0x210F,0x2110,0x210F,0x210F,0x210F,0x2110,0x2910,0x290F,0x290F,0x210F,0x212F,0x212F,0x2930,0x290F,0x212F,0x2930,0x2110,0x2110,0x2930,0x290F,0x2930,0x212F,0x212F,0x212F,0x2930,0x212F,0x2930,0x210F,0x2930,0x290F,0x2130,0x2130,0x212F,0x2930,0x210F,0x2930,0x210F,0x210F,0x2910,0x2910,0x2110,0x2110,0x2130,0x210F,0x2930,0x210F,0x210F,0x212F,0x210F,0x210F,0x212F,0x292F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2110,0x2910,0x2910,0x39B3,0x8BDC,0x7B5B,0x7B3B,0x831B,0x831C,0x82FC,0x82FB,0x8B1B,0x8B3B,0x7AD9,0x4974,0x2890,0x204F,0x180E,0x4154,0x8B5D,0x831C,0x831C,0x831C,0x7B1C,0x7B1C,0x7B3C,0x839D,0x6298,0x20B0,0x18AF,0x20F0,0x20F0,0x20EF,0x2910,0x210F,0x290F,0x2930,0x292F,0x292F,0x292F,0x292F,0x292F,0x290F,0x290F,0x292F,0x212F,0x2930,0x212F,0x2930,0x2930,0x210F,0x210F,0x290F,0x210F,0x2910,0x210F,0x210F,0x210F,0x2110,0x2910,0x210F,0x290F,0x290F,0x2910,0x2930,0x210F,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x212F,0x212F,0x292F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x292F,0x212F,0x212F,0x210F,0x2110,0x2130,0x2130,0x2130,0x2110,0x2130,0x2130,0x210F,0x2130,0x2130,0x2150,0x1930,0x1931,0x1111,0x1132,0x1174,0x1995,0x19D6,0x19F7,0x21F7,0x21B5,0x1973,0x1931,0x1930,0x1930,0x2150,0x2130,0x2130,0x2130,0x2130,0x2131,0x2131,0x1912,0x1112,0x1133,0x19B6,0x21F7,0x21F7,0x1975,0x1932,0x1932,0x2131,0x2111,0x2110,0x2110,0x2110,0x2130,0x2110,0x2110,0x212F,0x212F,0x290F,0x290F,0x212F,0x212F,0x290F,0x210F,0x2930,0x210F,0x2930,0x2930,0x2930,0x290F,0x290F,0x2930,0x290F,0x2930,0x210F,0x290F,0x2930,0x2930,0x2930,0x210F,0x212F,0x2130,0x212F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x212F,0x212F,0x212F,0x212F,0x2930,0x2130,0x2130,0x2131,0x1932,0x1133,0x2217,0x19F8,0x19D8,0x0976,0x0955,0x0955,0x1175,0x1196,0x1175,0x1175,0x1175,0x19B7,0x19F8,0x21F8,0x21D7,0x2195,0x2974,0x3173,0x3172,0x3972,0x3172,0x3972,0x3992,0x4192,0x4192,0x4172,0x4171,0x4151,0x4971,0x40CD,0x7A32,0xDCFC,0xD479,0xDC79,0xDC58,0xDC58,0xDC37,0xDC57,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC57,0xDC37,0xDC37,0xE437,0xE437,0xE437,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC36,0xDC36,0xDC16,0xDC16,0xDC37,0xDC16,0xDC16,0xDC16,0xDBF6,0xDC17,0xDC17,0xDC17,0xDBF6,0xDC16,0xDC16,0xDBF6,0xDC16,0xDBF6,0xDBF6,0xDBF6,0xDBF6,0xDC17,0xDC17,0xDBF7,0xDBF6,0xDBF6,0xDBF6,0xDC17,0xDBF7,0xDBF7,0xDC17,0xDC58,0xD459,0xD47A,0x9AF5,0x386C,0x410F,0x3910,0x3951,0x3151,0x3151,0x3151,0x3151,0x3131,0x3151,0x3151,0x2950,0x2950,0x2950,0x2950,0x2950,0x2950,0x2930,0x2930,0x2930,0x2930,0x3131,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x3150,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2910,0x2910,0x290F,0x290F,0x310F,0x28EF,0x28EF,0x30EF,0x30EE,0x28CE,0x30CD,0x30AD,0x30AD,0x308C,0x308C,0x304B,0x280A,0x280A,0x280A,0x300A,0x300A,0x300A,0x300A,0x382B,0x382B,0x382B,0x302B,0x300B,0x280B,0x280B,0x304C,0x308D,0x30AD,0x30CD,0x30CE,0x30EE,0x28EE,0x28EE,0x290F,0x290F,0x20EF,0x290F,0x210F,0x210F,0x2910,0x2910,0x290F,0x2930,0x290F,0x290F,0x292F,0x292F,0x212F,0x210F,0x210F,0x212F,0x210F,0x2110,0x210F,0x290F,0x290F,0x2930,0x210F,0x210F,0x2110,0x2930,0x210F,0x290F,0x2930,0x290F,0x2930,0x212F,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x212F,0x2930,0x212F,0x212F,0x212F,0x210F,0x212F,0x212F,0x2110,0x2130,0x2130,0x2131,0x1931,0x1932,0x1133,0x19D6,0x1A17,0x11D6,0x11B5,0x1132,0x1911,0x2131,0x2131,0x2130,0x2930,0x210F,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x2930,0x212F,0x212F,0x2930,0x2930,0x210F,0x210F,0x212F,0x292F,0x2930,0x2930,0x2110,0x2110,0x2930,0x2930,0x2910,0x2910,0x2930,0x2930,0x2930,0x2930,0x210F,0x2930,0x212F,0x2930,0x212F,0x210F,0x210F,0x20CF,0x206E,0x3890,0xC3DF,0xBAFE,0xC2DE,0xC29E,0xC27E,0xCA5E,0xCA5E,0xCA5E,0xD27E,0xCA7E,0xCA5E,0xCA7E,0xCA7E,0xC29D,0xBA9C,0xB2BC,0xB2DC,0xC3FF,0x380F,0x3890,0x288F,0x28B0,0x30B0,0x30B0,0x3870,0x8A79,0xC39F,0xBB1E,0xC2DD,0xC2BE,0xCABE,0xC2BE,0xC2BD,0xBADD,0xBAFD,0xAB1D,0x380F,0x300F,0x300F,0x3810,0x9239,0xBAFE,0xC2FE,0xC2BE,0xBA9E,0xC29E,0xBA9D,0xBABE,0xBAFE,0xBB3E,0xB33D,0x50B2,0x3090,0x30F0,0x290F,0x292F,0x20EF,0x28EF,0x206E,0x302F,0xB37E,0xBAFE,0xC2DE,0xC2BF,0xC2BE,0xC29E,0xC2BE,0xC2DD,0xBAFD,0xC3BF,0x4051,0x3070,0x28AF,0x28EF,0x2910,0x290F,0x2930,0x210F,0x2930,0x212F,0x212F,0x2150,0x212F,0x210F,0x20EF,0x28EF,0x286F,0x48D1,0xBB5D,0xC2FD,0xC2DE,0xCABE,0xC29E,0xC29E,0xC29E,0xC2DE,0xC33F,0xB35E,0x3830,0x3890,0x30D0,0x28EF,0x28EF,0x290F,0x2910,0x2930,0x2111,0x2131,0x1932,0x1132,0x1174,0x19D6,0x19F7,0x11D7,0x0955,0x0955,0x0935,0x0934,0x0935,0x0935,0x0155,0x0976,0x09B7,0x11F8,0x11F8,0x11D7,0x0955,0x1155,0x0934,0x1154,0x1154,0x1153,0x1133,0x1153,0x1132,0x1132,0x1152,0x1152,0x1132,0x1132,0x1153,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1133,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1132,0x1153,0x1133,0x1134,0x1154,0x1975,0x19D7,0x2218,0x21D7,0x21D7,0x1995,0x1113,0x1112,0x1911,0x2131,0x2131,0x2131,0x2110,0x2110,0x2110,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2130,0x2110,0x2131,0x2110,0x2110,0x2110,0x2110,0x2131,0x2110,0x2130,0x2130,0x2110,0x2131,0x2131,0x2111,0x2111,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x2110,
  0x210F,0x212F,0x210F,0x210F,0x212F,0x210F,0x290F,0x210F,0x210F,0x210F,0x2910,0x2910,0x290F,0x290F,0x2110,0x2110,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2910,0x290F,0x290F,0x290F,0x210F,0x210F,0x290F,0x2910,0x2930,0x290F,0x210F,0x210F,0x290F,0x2930,0x212F,0x2930,0x290F,0x2910,0x2930,0x2110,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2130,0x212F,0x2110,0x2130,0x2151,0x1951,0x1131,0x1132,0x1154,0x1175,0x1197,0x11B8,0x11F9,0x19F9,0x1A19,0x19D8,0x19B7,0x1175,0x1154,0x1133,0x1932,0x1931,0x2131,0x2131,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x2930,0x2110,0x2110,0x2110,0x210F,0x210F,0x290F,0x290F,0x292F,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2110,0x2110,0x1910,0x1931,0x1132,0x1133,0x1175,0x11B6,0x11D7,0x1A18,0x1A18,0x11F8,0x11D7,0x11D7,0x2238,0x1A17,0x1195,0x1154,0x1974,0x1952,0x18F0,0x1910,0x2130,0x2130,0x2130,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x212F,0x210F,0x212F,0x290F,0x210F,0x210F,0x210F,0x2110,0x2930,0x2910,0x210F,0x2910,0x2910,0x290F,0x210F,0x2930,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x210F,0x210F,0x210F,0x290F,0x2110,0x2110,0x2110,0x2130,0x2131,0x1931,0x1931,0x1932,0x1953,0x1154,0x1974,0x1154,0x1174,0x1174,0x1153,0x1153,0x1133,0x1112,0x1932,0x1931,0x1931,0x1931,0x2130,0x2110,0x2110,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x210F,0x2910,0x2930,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x2110,0x210F,0x210F,0x210F,0x210F,0x210F,0x290F,0x292F,0x210F,0x210F,0x210F,0x2130,0x2130,0x2130,0x212F,0x210F,0x2130,0x2130,0x212F,0x2130,0x212F,0x210F,0x210F,0x210F,0x210F,0x2130,0x2151,0x2152,0x1911,0x1111,0x1112,0x1134,0x1995,0x21F7,0x19F7,0x19D7,0x21D6,0x1174,0x1133,0x1932,0x1911,0x1931,0x1910,0x2130,0x2130,0x2130,0x2130,0x2130,0x212F,0x212F,0x212F,0x210F,0x2930,0x2130,0x2130,0x2130,0x2130,0x2130,0x2110,0x2110,0x2130,0x2930,0x210F,0x2930,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x290F,0x290F,0x290F,0x2930,0x210F,0x2930,0x210F,0x2910,0x2930,0x2930,0x2930,0x290F,0x212F,0x212F,0x2910,0x2910,0x212F,0x212F,0x2930,0x210F,0x290F,0x2930,0x290F,0x2930,0x290F,0x2930,0x2930,0x290F,0x2930,0x290F,0x290F,0x2930,0x212F,0x212F,0x210F,0x210F,0x2110,0x2930,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x2930,0x2930,0x212F,0x2930,0x292F,0x290F,0x292F,0x212F,0x292F,0x292F,0x210F,0x210F,0x210F,0x210F,0x2110,0x20EF,0x18CF,0x18AF,0x18AF,0x5236,0x837C,0x7B3B,0x831C,0x831C,0x82FC,0x8B1C,0x8B1C,0x8B3C,0x8B1B,0x82FA,0x40F2,0x200F,0x200F,0x4934,0x8B3C,0x82FC,0x8B3D,0x831C,0x831C,0x831C,0x8B7D,0x6258,0x184F,0x20AF,0x18CF,0x20EF,0x2110,0x210F,0x2930,0x2930,0x2910,0x290F,0x292F,0x292F,0x210F,0x212F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x2930,0x2930,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x2910,0x2910,0x2910,0x210F,0x210F,0x210F,0x2930,0x2930,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x292F,0x292F,0x292F,0x292F,0x292F,0x292F,0x210F,0x210F,0x212F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x210F,0x2110,0x2130,0x2130,0x1910,0x1111,0x1132,0x1994,0x1174,0x19B6,0x19F7,0x21F7,0x19B5,0x1974,0x1932,0x1931,0x1930,0x2150,0x2130,0x2130,0x2130,0x2130,0x2130,0x2131,0x1911,0x10F1,0x1112,0x1154,0x19D6,0x2217,0x21F7,0x1974,0x1933,0x1932,0x2131,0x2110,0x2110,0x2110,0x2110,0x2930,0x2930,0x2930,0x2930,0x212F,0x290F,0x290F,0x210F,0x292F,0x2930,0x210F,0x210F,0x210F,0x2930,0x2930,0x2930,0x2930,0x290F,0x290F,0x290F,0x292F,0x290F,0x290F,0x2910,0x210F,0x2910,0x210F,0x212F,0x212F,0x210F,0x210F,0x212F,0x212F,0x212F,0x212F,0x212F,0x212F,0x2130,0x2130,0x2130,0x212F,0x2930,0x2930,0x2130,0x2131,0x1932,0x1133,0x21D7,0x2218,0x19D8,0x1197,0x0955,0x0955,0x0955,0x1175,0x1155,0x1155,0x1155,0x21D8,0x2219,0x21F8,0x21B7,0x2195,0x2974,0x3173,0x3172,0x3972,0x3171,0x3972,0x3992,0x4192,0x4192,0x4192,0x4171,0x4151,0x4950,0x48EE,0x8AB4,0xDCFC,0xD499,0xDC79,0xDC58,0xDC58,0xDC37,0xDC37,0xE458,0xE437,0xDC37,0xDC36,0xDC37,0xDC36,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC37,0xDC16,0xDC17,0xDC17,0xDC37,0xDC37,0xDC36,0xDC16,0xDC16,0xDC16,0xDC16,0xDC16,0xDC16,0xDC17,0xDC16,0xDC16,0xDC17,0xDC17,0xDC17,0xDC16,0xDC17,0xDBF6,0xDBF6,0xDBF6,0xDBF6,0xDBF6,0xDBF6,0xDBF6,0xD3D6,0xDBD6,0xDBF6,0xDBF7,0xDC17,0xD3D6,0xDBF6,0xDBF7,0xDC17,0xDC18,0xDC39,0xDC7A,0xAB56,0x48AD,0x40AE,0x38EF,0x3930,0x3951,0x3151,0x3151,0x3151,0x3151,0x3151,0x3151,0x3151,0x3151,0x3151,0x3150,0x2930,0x2930,0x2951,0x2950,0x3151,0x2930,0x3131,0x3130,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x292F,0x292F,0x292F,0x290F,0x290F,0x2930,0x3130,0x3110,0x28EF,0x30EF,0x30CE,0x30CE,0x30CE,0x308D,0x286C,0x284C,0x282B,0x302A,0x302A,0x48AC,0x592E,0x71B0,0x8232,0x9294,0xAB57,0xBBB8,0xC3F9,0xC41A,0xC43A,0xC43A,0xBBFA,0xBBD9,0xB398,0xA336,0x9AF5,0x8253,0x616F,0x48AC,0x382B,0x302A,0x282B,0x308C,0x30CE,0x30EE,0x28EE,0x28EE,0x28EF,0x28EF,0x290F,0x290F,0x2930,0x2910,0x290F,0x290F,0x2930,0x290F,0x210F,0x290F,0x290F,0x212F,0x212F,0x212F,0x210F,0x2930,0x212F,0x212F,0x2930,0x2930,0x290F,0x210F,0x210F,0x212F,0x212F,0x2930,0x290F,0x210F,0x212F,0x2130,0x212F,0x2930,0x212F,0x210F,0x210F,0x212F,0x210F,0x212F,0x212F,0x212F,0x210F,0x210F,0x210F,0x212F,0x210F,0x2130,0x2110,0x2130,0x2131,0x1931,0x1932,0x1133,0x19D6,0x1A17,0x11D6,0x1195,0x1132,0x1911,0x2131,0x2130,0x2930,0x2130,0x210F,0x210F,0x292F,0x212F,0x290F,0x290F,0x2930,0x2930,0x212F,0x2930,0x2930,0x2930,0x2110,0x2130,0x210F,0x212F,0x2930,0x2930,0x210F,0x290F,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x2930,0x290F,0x28EF,0x28AF,0x3890,0xCC3F,0xCB9F,0xCB5F,0xCB1F,0xD2FF,0xD2FF,0xD2DF,0xD2DF,0xD2FF,0xD2FF,0xD2DF,0xD2FF,0xD2FF,0xD31F,0xCB3E,0xC33E,0xCBDF,0xDCBF,0x300F,0x3890,0x30B0,0x30D0,0x30D0,0x38B0,0x5954,0xBBFF,0xC3BF,0xC35E,0xC2FE,0xCB1F,0xCB1F,0xCB1E,0xCB1E,0xCB5E,0xC39F,0x9A9A,0x300F,0x302F,0x3030,0x3830,0x8A18,0xC35E,0xC33F,0xCB1F,0xC2FE,0xCB1F,0xCB1F,0xCB3F,0xCB7F,0xC37F,0xCC1F,0x8A99,0x304F,0x30F0,0x3130,0x290F,0x210F,0x20CE,0x28AF,0x3890,0xC3FF,0xCB9F,0xCB5F,0xCB1F,0xCAFE,0xCAFE,0xCAFE,0xC31E,0xCB9F,0xD43F,0x3850,0x3070,0x28B0,0x28F0,0x2930,0x2930,0x292F,0x290F,0x2930,0x212F,0x212F,0x212F,0x2950,0x2930,0x20EF,0x28CF,0x288F,0x40B0,0xCC1F,0xD39F,0xD35F,0xCB1F,0xCADE,0xC2DE,0xC2FE,0xC31F,0xCB9F,0xC3DF,0x382F,0x3090,0x28CF,0x20EF,0x290F,0x292F,0x210F,0x2110,0x2110,0x1911,0x1912,0x1133,0x1174,0x19F7,0x1A18,0x11D7,0x0955,0x0935,0x0955,0x0955,0x0935,0x0955,0x0955,0x0956,0x0997,0x11D8,0x1A18,0x11D7,0x0975,0x1175,0x1195,0x1195,0x1195,0x1195,0x1174,0x1174,0x1974,0x1973,0x1973,0x1973,0x1974,0x1974,0x1974,0x1974,0x1974,0x1995,0x1174,0x1174,0x1974,0x1174,0x1174,0x1974,0x1173,0x1173,0x1994,0x1973,0x1994,0x19B5,0x19B5,0x19B6,0x21B6,0x21D7,0x21D7,0x21D7,0x21D7,0x1995,0x1133,0x10F2,0x1911,0x1911,0x2131,0x2951,0x2130,0x2130,0x210F,0x2110,0x2130,0x2930,0x210F,0x2130,0x2110,0x2130,0x2130,0x2110,0x2130,0x2110,0x2130,0x2130,0x2110,0x2110,0x2130,0x2131,0x2110,0x2130,0x2131,0x2131,0x2131,0x2131,0x2131,0x2110,0x2111,0x2111,0x2131,0x2131,0x2131,0x2111,0x2131,0x2131,0x2131,0x2131,0x2111,0x2111,0x2111,0x2111,0x2131,0x2111,0x2131,0x2110,0x2110,0x2110,0x2131,0x2131,0x2131,0x1910,0x2110,0x2111,
  0x210F,0x210F,0x2930,0x210F,0x212F,0x2930,0x210F,0x290F,0x212F,0x210F,0x210F,0x210F,0x2930,0x210F,0x2110,0x210F,0x290F,0x210F,0x2910,0x2910,0x290F,0x290F,0x210F,0x290F,0x210F,0x290F,0x2930,0x290F,0x290F,0x290F,0x290F,0x290F,0x210F,0x2110,0x2910,0x2910,0x210F,0x290F,0x290F,0x290F,0x212F,0x210F,0x2930,0x290F,0x210F,0x2910,0x2930,0x2110,0x2910,0x2910,0x290F,0x2910,0x290F,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x212F,0x212F,0x212F,0x2130,0x2130,0x1951,0x1930,0x1931,0x1132,0x1154,0x1155,0x1196,0x11B7,0x19F9,0x1A19,0x1A19,0x19F8,0x11B6,0x1175,0x1154,0x1933,0x1911,0x1931,0x1931,0x2131,0x2130,0x2130,0x2130,0x2130,0x2130,0x2930,0x2110,0x2110,0x210F,0x290F,0x210F,0x290F,0x210F,0x292F,0x292F,0x210F,0x210F,0x292F,0x210F,0x292F,0x212F,0x210F,0x2930,0x212F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2130,0x2131,0x1932,0x1152,0x1153,0x1174,0x11B5,0x19F7,0x19D6,0x19D6,0x19D6,0x19B6,0x19D6,0x19B5,0x1174,0x1153,0x1952,0x1932,0x18F0,0x2110,0x2130,0x2930,0x2110,0x2110,0x2910,0x2110,0x2110,0x2110,0x210F,0x210F,0x212F,0x212F,0x212F,0x292F,0x212F,0x2930,0x210F,0x210F,0x2910,0x2930,0x2910,0x210F,0x210F,0x290F,0x290F,0x290F,0x210F,0x290F,0x290F,0x290F,0x2930,0x290F,0x290F,0x290F,0x210F,0x210F,0x210F,0x210F,0x2110,0x2110,0x2110,0x2130,0x2130,0x1931,0x1931,0x1932,0x1953,0x1953,0x1973,0x1153,0x1153,0x1153,0x1952,0x1932,0x1931,0x1911,0x1911,0x2131,0x2110,0x2110,0x2130,0x2130,0x210F,0x212F,0x212F,0x210F,0x210F,0x210F,0x290F,0x210F,0x210F,0x290F,0x290F,0x290F,0x2930,0x210F,0x210F,0x2110,0x2130,0x2130,0x210F,0x2110,0x2110,0x2110,0x2110,0x210F,0x2110,0x210F,0x290F,0x290F,0x210F,0x210F,0x210F,0x2110,0x210F,0x2110,0x2110,0x210F,0x212F,0x212F,0x210F,0x2130,0x210F,0x210F,0x212F,0x210F,0x212F,0x210F,0x2130,0x2130,0x2130,0x2131,0x2151,0x1911,0x1112,0x1112,0x1134,0x1995,0x19D7,0x2218,0x2217,0x19D6,0x1154,0x1133,0x1132,0x1932,0x1931,0x1931,0x2131,0x2130,0x2130,0x2150,0x2130,0x2130,0x210F,0x210F,0x2110,0x210F,0x2110,0x210F,0x2130,0x2130,0x2130,0x2130,0x2110,0x2130,0x210F,0x210F,0x290F,0x2910,0x2910,0x2910,0x2910,0x2910,0x290F,0x2930,0x290F,0x290F,0x2930,0x290F,0x290F,0x2910,0x2910,0x2910,0x290F,0x210F,0x210F,0x2930,0x2910,0x2910,0x210F,0x2930,0x2910,0x210F,0x2910,0x2930,0x2930,0x2930,0x2930,0x2930,0x