/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Katakana 48pt, capital 'A' height: 30px, width: 100%, range: 0x30a0-0x8868, glyphs: 103
extern const uint8_t Unifont_Katakana_30[15707] = {
  161,30,160,48,104,136,42,250, // unifont_t
  // 0x30a0  ゠
  160,48,18,15,45,48,15,6,255,255,192,255,255,192,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,192,255,255,192,255,255,192,
  // 0x30a1  ァ
  161,48,27,24,96,48,6,253,224,1,255,224,224,1,255,224,224,1,255,224,31,254,0,224,31,254,0,224,31,254,0,224,0,14,7,0,0,14,7,0,0,14,7,0,0,1,248,0,0,1,248,0,0,1,248,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,14,0,0,0,14,0,0,0,14,0,0,0,112,0,0,0,112,0,0,0,112,0,0,
  // 0x30a2  ア
  162,48,30,36,144,48,6,253,224,1,255,252,224,1,255,252,224,1,255,252,31,254,0,28,31,254,0,28,31,254,0,28,0,0,0,224,0,0,0,224,0,0,0,224,0,14,7,0,0,14,7,0,0,14,7,0,0,1,248,0,0,1,248,0,0,1,248,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,14,0,0,0,14,0,0,0,14,0,0,0,14,0,0,0,14,0,0,0,14,0,0,0,112,0,0,0,112,0,0,0,112,0,0,3,128,0,0,3,128,0,0,3,128,0,0,
  // 0x30a3  ィ
  163,48,24,30,90,48,9,253,0,0,7,0,0,7,0,0,7,0,0,56,0,0,56,0,0,56,0,1,192,0,1,192,0,1,192,0,127,192,0,127,192,0,127,192,255,129,192,255,129,192,255,129,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,
  // 0x30a4  イ
  164,48,27,39,156,48,6,253,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,7,0,0,0,7,0,0,0,7,0,0,0,56,0,0,0,56,0,0,0,56,0,0,15,192,0,0,15,192,0,0,15,192,0,3,241,192,0,3,241,192,0,3,241,192,0,252,0,56,0,252,0,56,0,252,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,
  // 0x30a5  ゥ
  165,48,24,30,90,48,9,253,0,112,0,0,112,0,0,112,0,0,14,0,0,14,0,0,14,0,0,15,255,0,15,255,0,15,255,255,240,7,255,240,7,255,240,7,28,0,7,28,0,7,28,0,7,28,0,56,28,0,56,28,0,56,0,0,56,0,0,56,0,0,56,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,
  // 0x30a6  ウ
  166,48,30,39,156,48,6,253,0,14,0,0,0,14,0,0,0,14,0,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,255,252,0,1,255,252,0,1,255,252,255,254,0,28,255,254,0,28,255,254,0,28,28,0,0,28,28,0,0,28,28,0,0,28,28,0,0,224,28,0,0,224,28,0,0,224,3,128,0,224,3,128,0,224,3,128,0,224,3,128,7,0,3,128,7,0,3,128,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,56,0,0,0,56,0,0,0,56,0,0,1,192,0,0,1,192,0,0,1,192,0,0,14,0,0,0,14,0,0,0,14,0,0,
  // 0x30a7  ェ
  167,48,27,21,84,48,9,0,0,1,255,0,0,1,255,0,0,1,255,0,31,254,0,0,31,254,0,0,31,254,0,0,0,14,0,0,0,14,0,0,0,14,0,0,0,14,0,0,0,14,0,0,0,14,0,0,0,14,0,0,0,14,0,0,0,14,0,0,0,15,255,0,0,15,255,0,0,15,255,0,255,240,0,224,255,240,0,224,255,240,0,224,
  // 0x30a8  エ
  168,48,33,27,135,48,6,3,0,0,7,252,0,0,0,7,252,0,0,0,7,252,0,31,255,248,0,0,31,255,248,0,0,31,255,248,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,15,255,252,0,0,15,255,252,0,0,15,255,252,0,255,240,0,3,128,255,240,0,3,128,255,240,0,3,128,
  // 0x30a9  ォ
  169,48,24,30,90,48,9,253,0,14,0,0,14,0,0,14,0,0,1,192,0,1,192,0,1,192,224,1,255,224,1,255,224,1,255,31,255,192,31,255,192,31,255,192,0,15,192,0,15,192,0,15,192,0,113,192,0,113,192,0,113,192,3,129,192,3,129,192,3,129,192,28,1,192,28,1,192,28,1,192,224,15,192,224,15,192,224,15,192,0,1,192,0,1,192,0,1,192,
  // 0x30aa  オ
  170,48,33,39,195,48,6,253,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,224,0,7,255,128,224,0,7,255,128,224,0,7,255,128,31,255,255,0,0,31,255,255,0,0,31,255,255,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,1,199,0,0,0,1,199,0,0,0,1,199,0,0,0,14,7,0,0,0,14,7,0,0,0,14,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,28,0,7,0,0,28,0,7,0,0,28,0,7,0,0,0,0,63,0,0,0,0,63,0,0,0,0,63,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,
  // 0x30ab  カ
  171,48,30,39,156,48,6,253,0,14,0,0,0,14,0,0,0,14,0,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,224,1,255,252,224,1,255,252,224,1,255,252,31,255,192,28,31,255,192,28,31,255,192,28,0,14,0,28,0,14,0,28,0,14,0,28,0,14,0,28,0,14,0,28,0,14,0,28,0,112,0,224,0,112,0,224,0,112,0,224,0,112,0,224,0,112,0,224,0,112,0,224,3,128,0,224,3,128,0,224,3,128,0,224,28,1,199,0,28,1,199,0,28,1,199,0,224,0,63,0,224,0,63,0,224,0,63,0,0,0,56,0,0,0,56,0,0,0,56,0,
  // 0x30ac  ガ
  172,48,36,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,14,0,224,112,0,14,0,224,112,0,14,0,224,112,0,1,192,28,112,0,1,192,28,112,0,1,192,28,112,0,1,192,28,0,0,1,192,28,0,0,1,192,28,0,224,1,255,252,0,224,1,255,252,0,224,1,255,252,0,31,255,192,28,0,31,255,192,28,0,31,255,192,28,0,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,112,0,224,0,0,112,0,224,0,0,112,0,224,0,0,112,0,224,0,0,112,0,224,0,0,112,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,28,1,199,0,0,28,1,199,0,0,28,1,199,0,0,224,0,63,0,0,224,0,63,0,0,224,0,63,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,
  // 0x30ad  キ
  173,48,33,39,195,48,6,253,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,7,252,0,0,14,7,252,0,0,14,7,252,0,0,15,248,0,0,0,15,248,0,0,0,15,248,0,0,31,241,192,0,0,31,241,192,0,0,31,241,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,199,255,128,0,1,199,255,128,0,1,199,255,128,0,15,248,0,0,0,15,248,0,0,0,15,248,0,0,255,240,56,0,0,255,240,56,0,0,255,240,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,
  // 0x30ae  ギ
  174,48,36,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,112,0,224,112,0,112,0,224,112,0,112,0,224,112,0,14,0,28,112,0,14,0,28,112,0,14,0,28,112,0,14,7,252,0,0,14,7,252,0,0,14,7,252,0,0,15,248,0,0,0,15,248,0,0,0,15,248,0,0,31,241,192,0,0,31,241,192,0,0,31,241,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,199,255,128,0,1,199,255,128,0,1,199,255,128,0,15,248,0,0,0,15,248,0,0,0,15,248,0,0,255,240,56,0,0,255,240,56,0,0,255,240,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,
  // 0x30af  ク
  175,48,27,39,156,48,9,253,3,128,0,0,3,128,0,0,3,128,0,0,0,112,63,224,0,112,63,224,0,112,63,224,0,127,192,224,0,127,192,224,0,127,192,224,0,112,7,0,0,112,7,0,0,112,7,0,3,128,7,0,3,128,7,0,3,128,7,0,3,128,56,0,3,128,56,0,3,128,56,0,28,0,56,0,28,0,56,0,28,0,56,0,224,1,192,0,224,1,192,0,224,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,14,0,0,0,14,0,0,0,14,0,0,0,112,0,0,0,112,0,0,0,112,0,0,3,128,0,0,3,128,0,0,3,128,0,0,28,0,0,0,28,0,0,0,28,0,0,0,
  // 0x30b0  グ
  176,48,36,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,3,128,0,224,112,3,128,0,224,112,3,128,0,224,112,0,112,63,28,112,0,112,63,28,112,0,112,63,28,112,0,127,199,28,0,0,127,199,28,0,0,127,199,28,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,56,0,0,3,128,56,0,0,3,128,56,0,0,28,0,56,0,0,28,0,56,0,0,28,0,56,0,0,224,1,192,0,0,224,1,192,0,0,224,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,
  // 0x30b1  ケ
  177,48,33,39,195,48,6,253,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,255,128,0,112,0,255,128,0,112,0,255,128,3,255,255,0,0,3,255,255,0,0,3,255,255,0,0,3,129,192,0,0,3,129,192,0,0,3,129,192,0,0,28,0,56,0,0,28,0,56,0,0,28,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,
  // 0x30b2  ゲ
  178,48,36,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,3,128,0,224,112,3,128,0,224,112,3,128,0,224,112,0,112,0,28,112,0,112,0,28,112,0,112,0,28,112,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,0,255,128,0,112,0,255,128,0,112,0,255,128,3,255,255,0,0,3,255,255,0,0,3,255,255,0,0,3,129,192,0,0,3,129,192,0,0,3,129,192,0,0,28,0,56,0,0,28,0,56,0,0,28,0,56,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,
  // 0x30b3  コ
  179,48,30,27,108,48,6,3,224,1,255,252,224,1,255,252,224,1,255,252,31,254,0,28,31,254,0,28,31,254,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,15,255,224,0,15,255,224,0,15,255,224,31,240,0,224,31,240,0,224,31,240,0,224,
  // 0x30b4  ゴ
  180,48,39,36,180,48,3,3,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,224,1,255,227,128,224,1,255,227,128,224,1,255,227,128,31,254,0,224,0,31,254,0,224,0,31,254,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,15,255,0,0,0,15,255,0,0,0,15,255,0,0,31,240,7,0,0,31,240,7,0,0,31,240,7,0,0,
  // 0x30b5  サ
  181,48,33,39,195,48,6,253,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,224,112,63,255,128,224,112,63,255,128,224,112,63,255,128,31,255,199,0,0,31,255,199,0,0,31,255,199,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,
  // 0x30b6  ザ
  182,48,36,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,56,224,112,0,0,56,224,112,0,0,56,224,112,3,128,7,28,112,3,128,7,28,112,3,128,7,28,112,0,112,7,28,0,0,112,7,28,0,0,112,7,28,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,224,112,63,255,128,224,112,63,255,128,224,112,63,255,128,31,255,199,0,0,31,255,199,0,0,31,255,199,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,
  // 0x30b7  シ
  183,48,30,33,132,48,9,0,31,128,0,0,31,128,0,0,31,128,0,0,0,112,0,0,0,112,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,0,0,0,252,0,0,0,252,0,0,0,3,128,0,28,3,128,0,28,3,128,0,28,0,0,0,224,0,0,0,224,0,0,0,224,0,0,7,0,0,0,7,0,0,0,7,0,0,0,56,0,0,0,56,0,0,0,56,0,0,1,192,0,0,1,192,0,0,1,192,0,224,126,0,0,224,126,0,0,224,126,0,0,31,128,0,0,31,128,0,0,31,128,0,0,
  // 0x30b8  ジ
  184,48,33,36,180,48,9,0,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,31,128,7,3,128,31,128,7,3,128,31,128,7,3,128,0,112,0,227,128,0,112,0,227,128,0,112,0,227,128,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,224,126,0,0,0,224,126,0,0,0,224,126,0,0,0,31,128,0,0,0,31,128,0,0,0,31,128,0,0,0,
  // 0x30b9  ス
  185,48,30,30,120,48,6,3,28,0,63,224,28,0,63,224,28,0,63,224,3,255,192,224,3,255,192,224,3,255,192,224,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,1,199,0,0,1,199,0,0,1,199,0,0,14,0,224,0,14,0,224,0,14,0,224,3,240,0,28,3,240,0,28,3,240,0,28,252,0,0,28,252,0,0,28,252,0,0,28,
  // 0x30ba  ズ
  186,48,39,36,180,48,3,3,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,28,0,63,227,142,28,0,63,227,142,28,0,63,227,142,3,255,192,227,128,3,255,192,227,128,3,255,192,227,128,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,199,0,0,0,1,199,0,0,0,1,199,0,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,3,240,0,28,0,3,240,0,28,0,3,240,0,28,0,252,0,0,28,0,252,0,0,28,0,252,0,0,28,0,
  // 0x30bb  セ
  187,48,33,36,180,48,6,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,7,255,128,0,112,7,255,128,0,112,7,255,128,0,113,248,3,128,0,113,248,3,128,0,113,248,3,128,224,126,0,28,0,224,126,0,28,0,224,126,0,28,0,31,240,0,224,0,31,240,0,224,0,31,240,0,224,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,1,255,252,0,0,1,255,252,0,0,1,255,252,0,
  // 0x30bc  ゼ
  188,48,36,39,195,48,6,0,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,3,128,0,224,112,3,128,0,224,112,3,128,0,224,112,0,112,0,28,112,0,112,0,28,112,0,112,0,28,112,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,0,112,7,255,128,0,112,7,255,128,0,112,7,255,128,0,113,248,3,128,0,113,248,3,128,0,113,248,3,128,224,126,0,28,0,224,126,0,28,0,224,126,0,28,0,31,240,0,224,0,31,240,0,224,0,31,240,0,224,0,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,1,255,255,128,0,1,255,255,128,0,1,255,255,128,
  // 0x30bd  ソ
  189,48,27,39,156,48,9,253,0,0,7,0,0,0,7,0,0,0,7,0,224,0,0,224,224,0,0,224,224,0,0,224,28,0,0,224,28,0,0,224,28,0,0,224,3,128,0,224,3,128,0,224,3,128,0,224,3,128,7,0,3,128,7,0,3,128,7,0,3,128,7,0,3,128,7,0,3,128,7,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,14,0,0,0,14,0,0,0,14,0,0,0,112,0,0,0,112,0,0,0,112,0,0,3,128,0,0,3,128,0,0,3,128,0,0,
  // 0x30be  ゾ
  190,48,36,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,56,224,112,0,0,56,224,112,0,0,56,224,112,224,0,7,28,112,224,0,7,28,112,224,0,7,28,112,28,0,7,28,0,28,0,7,28,0,28,0,7,28,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,
  // 0x30bf  タ
  191,48,30,39,156,48,6,253,0,14,0,0,0,14,0,0,0,14,0,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,255,252,0,1,255,252,0,1,255,252,0,14,0,28,0,14,0,28,0,14,0,28,0,14,0,224,0,14,0,224,0,14,0,224,0,113,192,224,0,113,192,224,0,113,192,224,3,128,63,0,3,128,63,0,3,128,63,0,28,0,7,0,28,0,7,0,28,0,7,0,0,0,56,0,0,0,56,0,0,0,56,0,0,1,192,0,0,1,192,0,0,1,192,0,0,14,0,0,0,14,0,0,0,14,0,0,3,240,0,0,3,240,0,0,3,240,0,0,252,0,0,0,252,0,0,0,252,0,0,0,
  // 0x30c0  ダ
  192,48,39,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,14,0,28,14,0,14,0,28,14,0,14,0,28,14,0,1,192,3,142,0,1,192,3,142,0,1,192,3,142,0,1,255,255,128,0,1,255,255,128,0,1,255,255,128,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,113,192,224,0,0,113,192,224,0,0,113,192,224,0,3,128,56,224,0,3,128,56,224,0,3,128,56,224,0,28,0,7,0,0,28,0,7,0,0,28,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,
  // 0x30c1  チ
  193,48,33,39,195,48,6,253,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,1,248,0,0,0,1,248,0,0,0,1,248,0,0,31,254,0,0,0,31,254,0,0,0,31,254,0,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,0,63,255,128,0,0,63,255,128,0,0,63,255,128,224,15,248,0,0,224,15,248,0,0,224,15,248,0,0,31,240,56,0,0,31,240,56,0,0,31,240,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,
  // 0x30c2  ヂ
  194,48,36,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,7,224,112,0,0,7,224,112,0,0,7,224,112,0,1,248,28,112,0,1,248,28,112,0,1,248,28,112,31,254,0,28,0,31,254,0,28,0,31,254,0,28,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,0,63,255,128,0,0,63,255,128,0,0,63,255,128,224,15,248,0,0,224,15,248,0,0,224,15,248,0,0,31,240,56,0,0,31,240,56,0,0,31,240,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,
  // 0x30c3  ッ
  195,48,24,24,72,48,9,253,3,128,56,3,128,56,3,128,56,224,112,7,224,112,7,224,112,7,28,112,7,28,112,7,28,112,7,28,0,56,28,0,56,28,0,56,0,0,56,0,0,56,0,0,56,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,
  // 0x30c4  ツ
  196,48,33,33,165,48,6,0,0,112,0,28,0,0,112,0,28,0,0,112,0,28,0,224,14,0,3,128,224,14,0,3,128,224,14,0,3,128,28,1,192,3,128,28,1,192,3,128,28,1,192,3,128,3,129,192,28,0,3,129,192,28,0,3,129,192,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,
  // 0x30c5  ヅ
  197,48,39,39,195,48,3,0,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,3,128,7,3,142,3,128,7,3,142,3,128,7,3,142,0,112,0,227,128,0,112,0,227,128,0,112,0,227,128,224,14,0,224,0,224,14,0,224,0,224,14,0,224,0,28,14,0,224,0,28,14,0,224,0,28,14,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,7,0,0,3,128,7,0,0,3,128,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,
  // 0x30c6  テ
  198,48,33,36,180,48,6,253,28,1,255,224,0,28,1,255,224,0,28,1,255,224,0,3,254,0,0,0,3,254,0,0,0,3,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,255,128,0,0,7,255,128,0,0,7,255,128,224,15,248,0,0,224,15,248,0,0,224,15,248,0,0,31,240,56,0,0,31,240,56,0,0,31,240,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,
  // 0x30c7  デ
  199,48,36,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,224,112,0,0,0,224,112,0,0,0,224,112,28,1,255,28,112,28,1,255,28,112,28,1,255,28,112,3,254,0,28,0,3,254,0,28,0,3,254,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,63,252,0,224,0,63,252,0,224,0,63,252,0,31,255,192,0,0,31,255,192,0,0,31,255,192,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,
  // 0x30c8  ト
  200,48,21,39,117,48,12,253,224,0,0,224,0,0,224,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,31,240,0,31,240,0,31,240,0,28,15,192,28,15,192,28,15,192,28,0,56,28,0,56,28,0,56,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,28,0,0,
  // 0x30c9  ド
  201,48,27,42,168,48,9,253,0,0,7,0,0,0,7,0,0,0,7,0,224,1,192,224,224,1,192,224,224,1,192,224,28,0,56,224,28,0,56,224,28,0,56,224,28,0,56,0,28,0,56,0,28,0,56,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,31,240,0,0,31,240,0,0,31,240,0,0,28,15,192,0,28,15,192,0,28,15,192,0,28,0,56,0,28,0,56,0,28,0,56,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,
  // 0x30ca  ナ
  202,48,33,39,195,48,6,253,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,224,0,63,255,128,224,0,63,255,128,224,0,63,255,128,31,255,248,0,0,31,255,248,0,0,31,255,248,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,
  // 0x30cb  ニ
  203,48,33,24,120,48,6,6,0,0,63,224,0,0,0,63,224,0,0,0,63,224,0,31,255,192,0,0,31,255,192,0,0,31,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,252,0,0,1,255,252,0,0,1,255,252,0,255,254,0,3,128,255,254,0,3,128,255,254,0,3,128,
  // 0x30cc  ヌ
  204,48,30,33,132,48,6,0,28,0,63,252,28,0,63,252,28,0,63,252,3,255,192,28,3,255,192,28,3,255,192,28,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,3,254,7,0,3,254,7,0,3,254,7,0,0,1,255,0,0,1,255,0,0,1,255,0,0,0,63,0,0,0,63,0,0,0,63,0,0,1,192,224,0,1,192,224,0,1,192,224,0,14,0,28,0,14,0,28,0,14,0,28,3,240,0,28,3,240,0,28,3,240,0,28,252,0,0,0,252,0,0,0,252,0,0,0,
  // 0x30cd  ネ
  205,48,33,39,195,48,6,253,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,255,224,0,0,1,255,224,0,0,1,255,224,0,31,254,0,224,0,31,254,0,224,0,31,254,0,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,15,199,0,0,0,15,199,0,0,0,15,199,0,0,3,241,192,252,0,3,241,192,252,0,3,241,192,252,0,252,1,192,3,128,252,1,192,3,128,252,1,192,3,128,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,
  // 0x30ce  ノ
  206,48,24,39,117,48,9,253,0,0,56,0,0,56,0,0,56,0,0,7,0,0,7,0,0,7,0,0,7,0,0,7,0,0,7,0,0,7,0,0,7,0,0,7,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,0,56,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,28,0,0,28,0,0,28,0,0,224,0,0,224,0,0,224,0,0,
  // 0x30cf  ハ
  207,48,36,24,120,48,3,3,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x30d0  バ
  208,48,39,33,165,48,3,3,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,3,142,0,0,0,3,142,0,0,0,3,142,0,112,7,3,128,0,112,7,3,128,0,112,7,3,128,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x30d1  パ
  209,48,39,36,180,48,3,3,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,112,7,0,0,0,112,7,0,0,0,112,7,0,0,0,14,0,224,0,0,14,0,224,0,0,14,0,224,0,0,14,0,28,0,0,14,0,28,0,0,14,0,28,0,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,0,112,0,3,128,3,128,0,0,112,3,128,0,0,112,3,128,0,0,112,28,0,0,0,112,28,0,0,0,112,28,0,0,0,112,224,0,0,0,112,224,0,0,0,112,224,0,0,0,112,
  // 0x30d2  ヒ
  210,48,27,33,132,48,9,0,224,0,0,0,224,0,0,0,224,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,1,255,0,28,1,255,0,28,1,255,0,31,254,0,0,31,254,0,0,31,254,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,3,128,0,0,3,128,0,0,3,128,0,0,0,127,255,224,0,127,255,224,0,127,255,224,
  // 0x30d3  ビ
  211,48,30,36,144,48,9,0,0,0,0,224,0,0,0,224,0,0,0,224,224,0,56,28,224,0,56,28,224,0,56,28,28,0,7,28,28,0,7,28,28,0,7,28,28,0,7,0,28,0,7,0,28,0,7,0,28,0,0,0,28,0,0,0,28,0,0,0,28,1,255,0,28,1,255,0,28,1,255,0,31,254,0,0,31,254,0,0,31,254,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,3,128,0,0,3,128,0,0,3,128,0,0,0,127,255,224,0,127,255,224,0,127,255,224,
  // 0x30d4  ピ
  212,48,30,36,144,48,9,0,0,0,7,224,0,0,7,224,0,0,7,224,224,0,56,28,224,0,56,28,224,0,56,28,28,0,56,28,28,0,56,28,28,0,56,28,28,0,7,224,28,0,7,224,28,0,7,224,28,0,0,0,28,0,0,0,28,0,0,0,28,1,255,0,28,1,255,0,28,1,255,0,31,254,0,0,31,254,0,0,31,254,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,3,128,0,0,3,128,0,0,3,128,0,0,0,127,255,224,0,127,255,224,0,127,255,224,
  // 0x30d5  フ
  213,48,27,33,132,48,9,0,224,1,255,224,224,1,255,224,224,1,255,224,31,254,0,224,31,254,0,224,31,254,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,1,192,0,0,1,192,0,0,1,192,0,0,14,0,0,0,14,0,0,0,14,0,0,0,112,0,0,0,112,0,0,0,112,0,0,3,128,0,0,3,128,0,0,3,128,0,0,
  // 0x30d6  ブ
  214,48,36,39,195,48,6,0,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,224,112,0,0,0,224,112,0,0,0,224,112,224,15,255,28,112,224,15,255,28,112,224,15,255,28,112,31,240,7,28,0,31,240,7,28,0,31,240,7,28,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,
  // 0x30d7  プ
  215,48,36,39,195,48,6,0,0,0,0,31,128,0,0,0,31,128,0,0,0,31,128,0,0,0,224,112,0,0,0,224,112,0,0,0,224,112,224,15,255,224,112,224,15,255,224,112,224,15,255,224,112,31,240,7,31,128,31,240,7,31,128,31,240,7,31,128,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,
  // 0x30d8  ヘ
  216,48,39,18,90,48,3,9,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,56,0,0,0,14,56,0,0,0,14,56,0,0,224,112,7,0,0,224,112,7,0,0,224,112,7,0,0,31,128,0,224,0,31,128,0,224,0,31,128,0,224,0,0,0,0,31,128,0,0,0,31,128,0,0,0,31,128,0,0,0,0,126,0,0,0,0,126,0,0,0,0,126,
  // 0x30d9  ベ
  217,48,39,27,135,48,3,9,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,7,3,128,0,0,7,3,128,0,0,7,3,128,0,0,0,227,128,0,0,0,227,128,0,0,0,227,128,0,1,192,224,0,0,1,192,224,0,0,1,192,224,0,0,14,56,0,0,0,14,56,0,0,0,14,56,0,0,224,112,7,0,0,224,112,7,0,0,224,112,7,0,0,31,128,0,224,0,31,128,0,224,0,31,128,0,224,0,0,0,0,31,128,0,0,0,31,128,0,0,0,31,128,0,0,0,0,126,0,0,0,0,126,0,0,0,0,126,
  // 0x30da  ペ
  218,48,39,27,135,48,3,9,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,7,3,128,0,0,7,3,128,0,0,7,3,128,0,0,7,3,128,0,0,7,3,128,0,0,7,3,128,0,1,192,252,0,0,1,192,252,0,0,1,192,252,0,0,14,56,0,0,0,14,56,0,0,0,14,56,0,0,224,112,7,0,0,224,112,7,0,0,224,112,7,0,0,31,128,0,224,0,31,128,0,224,0,31,128,0,224,0,0,0,0,31,128,0,0,0,31,128,0,0,0,31,128,0,0,0,0,126,0,0,0,0,126,0,0,0,0,126,
  // 0x30db  ホ
  219,48,30,39,156,48,6,253,0,14,0,0,0,14,0,0,0,14,0,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,224,1,255,252,224,1,255,252,224,1,255,252,31,255,192,0,31,255,192,0,31,255,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,199,0,0,1,199,0,0,1,199,0,3,129,192,224,3,129,192,224,3,129,192,224,3,129,192,28,3,129,192,28,3,129,192,28,28,1,192,28,28,1,192,28,28,1,192,28,224,1,192,0,224,1,192,0,224,1,192,0,0,15,192,0,0,15,192,0,0,15,192,0,0,1,192,0,0,1,192,0,0,1,192,0,
  // 0x30dc  ボ
  220,48,36,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,14,0,224,112,0,14,0,224,112,0,14,0,224,112,0,1,192,28,112,0,1,192,28,112,0,1,192,28,112,0,1,192,28,0,0,1,192,28,0,0,1,192,28,0,224,1,255,252,0,224,1,255,252,0,224,1,255,252,0,31,255,192,0,0,31,255,192,0,0,31,255,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,199,0,0,0,1,199,0,0,0,1,199,0,0,3,129,192,224,0,3,129,192,224,0,3,129,192,224,0,3,129,192,28,0,3,129,192,28,0,3,129,192,28,0,28,1,192,28,0,28,1,192,28,0,28,1,192,28,0,224,1,192,0,0,224,1,192,0,0,224,1,192,0,0,0,15,192,0,0,0,15,192,0,0,0,15,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,
  // 0x30dd  ポ
  221,48,36,42,210,48,6,253,0,0,0,31,128,0,0,0,31,128,0,0,0,31,128,0,14,0,224,112,0,14,0,224,112,0,14,0,224,112,0,1,192,224,112,0,1,192,224,112,0,1,192,224,112,0,1,192,31,128,0,1,192,31,128,0,1,192,31,128,224,1,255,252,0,224,1,255,252,0,224,1,255,252,0,31,255,192,0,0,31,255,192,0,0,31,255,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,199,0,0,0,1,199,0,0,0,1,199,0,0,3,129,192,224,0,3,129,192,224,0,3,129,192,224,0,3,129,192,28,0,3,129,192,28,0,3,129,192,28,0,28,1,192,28,0,28,1,192,28,0,28,1,192,28,0,224,1,192,0,0,224,1,192,0,0,224,1,192,0,0,0,15,192,0,0,0,15,192,0,0,0,15,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,
  // 0x30de  マ
  222,48,33,27,135,48,6,3,224,0,63,252,0,224,0,63,252,0,224,0,63,252,0,31,255,192,3,128,31,255,192,3,128,31,255,192,3,128,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,3,240,56,0,0,3,240,56,0,0,3,240,56,0,0,0,15,192,0,0,0,15,192,0,0,0,15,192,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,
  // 0x30df  ミ
  223,48,24,39,117,48,9,253,3,128,0,3,128,0,3,128,0,0,126,0,0,126,0,0,126,0,0,1,248,0,1,248,0,1,248,0,0,7,0,0,7,0,0,7,28,0,0,28,0,0,28,0,0,3,240,0,3,240,0,3,240,0,0,15,192,0,15,192,0,15,192,0,0,56,0,0,56,0,0,56,224,0,0,224,0,0,224,0,0,31,128,0,31,128,0,31,128,0,0,126,0,0,126,0,0,126,0,0,1,248,0,1,248,0,1,248,0,0,7,0,0,7,0,0,7,
  // 0x30e0  ム
  224,48,33,33,165,48,6,3,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,7,0,0,0,14,7,0,0,0,14,7,0,0,0,112,0,224,0,0,112,0,224,0,0,112,0,224,0,0,112,0,252,0,0,112,0,252,0,0,112,0,252,0,227,129,255,3,128,227,129,255,3,128,227,129,255,3,128,31,254,0,3,128,31,254,0,3,128,31,254,0,3,128,
  // 0x30e1  メ
  225,48,30,39,156,48,6,253,0,0,7,0,0,0,7,0,0,0,7,0,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,126,0,224,0,126,0,224,0,126,0,224,0,1,255,0,0,1,255,0,0,1,255,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,56,224,0,0,56,224,0,0,56,224,0,0,56,28,0,0,56,28,0,0,56,28,0,1,192,0,0,1,192,0,0,1,192,0,0,14,0,0,0,14,0,0,0,14,0,0,3,240,0,0,3,240,0,0,3,240,0,0,252,0,0,0,252,0,0,0,252,0,0,0,
  // 0x30e2  モ
  226,48,33,30,150,48,6,3,28,0,63,224,0,28,0,63,224,0,28,0,63,224,0,3,255,192,0,0,3,255,192,0,0,3,255,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,224,15,255,255,128,224,15,255,255,128,224,15,255,255,128,31,254,0,0,0,31,254,0,0,0,31,254,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,1,255,252,0,0,1,255,252,0,0,1,255,252,0,
  // 0x30e3  ャ
  227,48,27,27,108,48,9,253,3,128,0,0,3,128,0,0,3,128,0,0,0,112,63,224,0,112,63,224,0,112,63,224,0,127,192,224,0,127,192,224,0,127,192,224,255,240,7,0,255,240,7,0,255,240,7,0,0,14,56,0,0,14,56,0,0,14,56,0,0,14,0,0,0,14,0,0,0,14,0,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,0,1,192,0,
  // 0x30e4  ヤ
  228,48,33,36,180,48,6,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,7,255,128,0,112,7,255,128,0,112,7,255,128,0,15,248,3,128,0,15,248,3,128,0,15,248,3,128,224,126,0,28,0,224,126,0,28,0,224,126,0,28,0,31,142,0,224,0,31,142,0,224,0,31,142,0,224,0,0,1,199,0,0,0,1,199,0,0,0,1,199,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,
  // 0x30e5  ュ
  229,48,27,18,72,48,9,3,0,15,248,0,0,15,248,0,0,15,248,0,31,240,56,0,31,240,56,0,31,240,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,1,192,0,0,1,192,0,0,1,192,0,0,15,255,0,0,15,255,0,0,15,255,0,255,240,0,224,255,240,0,224,255,240,0,224,
  // 0x30e6  ユ
  230,48,33,21,105,48,6,6,28,1,255,0,0,28,1,255,0,0,28,1,255,0,0,3,254,7,0,0,3,254,7,0,0,3,254,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,255,252,0,0,1,255,252,0,0,1,255,252,0,255,254,0,3,128,255,254,0,3,128,255,254,0,3,128,
  // 0x30e7  ョ
  231,48,21,24,72,48,12,0,0,127,248,0,127,248,0,127,248,255,128,56,255,128,56,255,128,56,0,0,56,0,0,56,0,0,56,0,127,248,0,127,248,0,127,248,255,129,192,255,129,192,255,129,192,0,1,192,0,1,192,0,1,192,0,127,192,0,127,192,0,127,192,255,128,56,255,128,56,255,128,56,
  // 0x30e8  ヨ
  232,48,27,33,132,48,9,0,0,15,255,224,0,15,255,224,0,15,255,224,255,240,0,224,255,240,0,224,255,240,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,15,255,0,0,15,255,0,0,15,255,0,31,240,7,0,31,240,7,0,31,240,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,15,255,0,0,15,255,0,0,15,255,0,31,240,0,224,31,240,0,224,31,240,0,224,
  // 0x30e9  ラ
  233,48,30,36,144,48,6,253,28,1,255,0,28,1,255,0,28,1,255,0,3,254,0,0,3,254,0,0,3,254,0,0,0,0,7,252,0,0,7,252,0,0,7,252,224,15,248,28,224,15,248,28,224,15,248,28,31,240,0,28,31,240,0,28,31,240,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,7,0,0,0,7,0,0,0,7,0,0,0,56,0,0,0,56,0,0,0,56,0,0,15,192,0,0,15,192,0,0,15,192,0,3,240,0,0,3,240,0,0,3,240,0,0,
  // 0x30ea  リ
  234,48,21,39,117,48,12,253,0,1,192,0,1,192,0,1,192,224,0,56,224,0,56,224,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,28,0,56,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,
  // 0x30eb  ル
  235,48,33,33,165,48,6,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,3,128,56,0,0,3,128,56,0,0,3,128,56,0,0,0,112,56,0,0,0,112,56,0,0,0,112,56,0,0,0,112,56,0,0,0,112,56,0,0,0,112,56,0,0,0,112,56,3,128,0,112,56,3,128,0,112,56,3,128,0,112,56,3,128,0,112,56,3,128,0,112,56,3,128,0,112,56,28,0,0,112,56,28,0,0,112,56,28,0,3,128,56,28,0,3,128,56,28,0,3,128,56,28,0,3,128,56,224,0,3,128,56,224,0,3,128,56,224,0,28,0,63,0,0,28,0,63,0,0,28,0,63,0,0,224,0,56,0,0,224,0,56,0,0,224,0,56,0,0,
  // 0x30ec  レ
  236,48,27,36,144,48,9,0,224,0,0,0,224,0,0,0,224,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,224,28,0,0,224,28,0,0,224,28,0,7,0,28,0,7,0,28,0,7,0,28,0,56,0,28,0,56,0,28,0,56,0,28,1,192,0,28,1,192,0,28,1,192,0,28,126,0,0,28,126,0,0,28,126,0,0,31,128,0,0,31,128,0,0,31,128,0,0,
  // 0x30ed  ロ
  237,48,30,27,108,48,6,3,224,1,255,252,224,1,255,252,224,1,255,252,31,254,0,28,31,254,0,28,31,254,0,28,28,0,0,28,28,0,0,28,28,0,0,28,28,0,0,28,28,0,0,28,28,0,0,28,3,128,0,224,3,128,0,224,3,128,0,224,3,128,0,224,3,128,0,224,3,128,0,224,3,129,255,224,3,129,255,224,3,129,255,224,3,254,0,28,3,254,0,28,3,254,0,28,3,128,0,0,3,128,0,0,3,128,0,0,
  // 0x30ee  ヮ
  238,48,27,24,96,48,9,253,224,1,255,224,224,1,255,224,224,1,255,224,31,254,0,224,31,254,0,224,31,254,0,224,28,0,7,0,28,0,7,0,28,0,7,0,3,128,7,0,3,128,7,0,3,128,7,0,3,128,56,0,3,128,56,0,3,128,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,1,192,0,0,1,192,0,0,1,192,0,0,14,0,0,0,14,0,0,0,14,0,0,
  // 0x30ef  ワ
  239,48,30,36,144,48,6,253,224,1,255,252,224,1,255,252,224,1,255,252,31,254,0,28,31,254,0,28,31,254,0,28,28,0,0,28,28,0,0,28,28,0,0,28,3,128,0,28,3,128,0,28,3,128,0,28,3,128,0,224,3,128,0,224,3,128,0,224,3,128,0,224,3,128,0,224,3,128,0,224,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,56,0,0,0,56,0,0,0,56,0,0,1,192,0,0,1,192,0,0,1,192,0,0,14,0,0,0,14,0,0,0,14,0,0,0,112,0,0,0,112,0,0,0,112,0,0,
  // 0x30f0  ヰ
  240,48,33,39,195,48,6,253,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,255,252,0,0,1,255,252,0,0,1,255,252,0,31,254,56,0,0,31,254,56,0,0,31,254,56,0,0,3,128,56,0,0,3,128,56,0,0,3,128,56,0,0,0,112,56,0,0,0,112,56,0,0,0,112,56,0,0,0,113,255,252,0,0,113,255,252,0,0,113,255,252,0,255,254,56,3,128,255,254,56,3,128,255,254,56,3,128,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,
  // 0x30f1  ヱ
  241,48,33,24,120,48,6,6,0,1,255,224,0,0,1,255,224,0,0,1,255,224,0,31,254,0,224,0,31,254,0,224,0,31,254,0,224,0,0,14,7,0,0,0,14,7,0,0,0,14,7,0,0,0,1,248,0,0,0,1,248,0,0,0,1,248,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,255,252,0,0,1,255,252,0,0,1,255,252,0,255,254,0,3,128,255,254,0,3,128,255,254,0,3,128,
  // 0x30f2  ヲ
  242,48,27,36,144,48,9,253,0,15,255,224,0,15,255,224,0,15,255,224,255,240,0,224,255,240,0,224,255,240,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,7,0,0,0,7,0,0,0,7,0,0,15,255,0,0,15,255,0,0,15,255,0,31,240,7,0,31,240,7,0,31,240,7,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,0,56,0,0,1,192,0,0,1,192,0,0,1,192,0,0,14,0,0,0,14,0,0,0,14,0,0,3,240,0,0,3,240,0,0,3,240,0,0,252,0,0,0,252,0,0,0,252,0,0,0,
  // 0x30f3  ン
  243,48,30,30,120,48,9,0,252,0,0,0,252,0,0,0,252,0,0,0,3,128,0,28,3,128,0,28,3,128,0,28,0,112,0,28,0,112,0,28,0,112,0,28,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,0,224,0,0,7,0,0,0,7,0,0,0,7,0,0,0,56,0,0,0,56,0,0,0,56,0,0,1,192,0,0,1,192,0,0,1,192,0,224,126,0,0,224,126,0,0,224,126,0,0,31,128,0,0,31,128,0,0,31,128,0,0,
  // 0x30f4  ヴ
  244,48,39,42,210,48,3,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,14,0,28,14,0,14,0,28,14,0,14,0,28,14,0,1,192,3,142,0,1,192,3,142,0,1,192,3,142,0,1,192,3,128,0,1,192,3,128,0,1,192,3,128,224,1,255,252,0,224,1,255,252,0,224,1,255,252,0,31,254,0,28,0,31,254,0,28,0,31,254,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,
  // 0x30f5  ヵ
  245,48,24,27,81,48,9,253,0,112,0,0,112,0,0,112,0,0,14,0,0,14,0,0,14,0,224,15,255,224,15,255,224,15,255,31,240,7,31,240,7,31,240,7,0,112,7,0,112,7,0,112,7,0,112,7,0,112,7,0,112,7,3,128,7,3,128,7,3,128,7,28,1,248,28,1,248,28,1,248,224,0,56,224,0,56,224,0,56,
  // 0x30f6  ヶ
  246,48,24,27,81,48,9,253,28,0,0,28,0,0,28,0,0,3,128,0,3,128,0,3,128,0,3,128,63,3,128,63,3,128,63,3,255,192,3,255,192,3,255,192,28,1,192,28,1,192,28,1,192,224,1,192,224,1,192,224,1,192,0,14,0,0,14,0,0,14,0,0,112,0,0,112,0,0,112,0,3,128,0,3,128,0,3,128,0,
  // 0x30f7  ヷ
  247,48,39,45,225,48,6,253,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,28,14,0,0,0,28,14,0,0,0,28,14,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,224,1,255,252,0,224,1,255,252,0,224,1,255,252,0,31,254,0,28,0,31,254,0,28,0,31,254,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,
  // 0x30f8  ヸ
  248,48,36,42,210,48,6,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,1,192,0,112,0,1,192,0,112,0,1,192,0,112,0,0,56,28,0,0,0,56,28,0,0,0,56,28,0,0,0,56,3,128,0,0,56,3,128,0,0,56,3,128,0,1,255,252,0,0,1,255,252,0,0,1,255,252,0,31,254,56,0,0,31,254,56,0,0,31,254,56,0,0,3,128,56,0,0,3,128,56,0,0,3,128,56,0,0,0,112,56,0,0,0,112,56,0,0,0,112,56,0,0,0,113,255,252,0,0,113,255,252,0,0,113,255,252,0,255,254,56,3,128,255,254,56,3,128,255,254,56,3,128,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,
  // 0x30f9  ヹ
  249,48,36,33,165,48,6,6,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,1,255,227,128,0,1,255,227,128,0,1,255,227,128,31,254,0,224,0,31,254,0,224,0,31,254,0,224,0,0,14,7,0,0,0,14,7,0,0,0,14,7,0,0,0,1,248,0,0,0,1,248,0,0,0,1,248,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,1,255,252,0,0,1,255,252,0,0,1,255,252,0,255,254,0,3,128,255,254,0,3,128,255,254,0,3,128,
  // 0x30fa  ヺ
  250,48,36,45,225,48,9,253,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,0,112,0,0,0,0,112,0,0,0,0,112,0,0,0,28,0,0,0,0,28,0,0,0,0,28,0,0,15,255,227,128,0,15,255,227,128,0,15,255,227,128,255,240,0,224,0,255,240,0,224,0,255,240,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,15,255,0,0,0,15,255,0,0,0,15,255,0,0,31,240,7,0,0,31,240,7,0,0,31,240,7,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,192,0,0,0,1,192,0,0,0,1,192,0,0,0,14,0,0,0,0,14,0,0,0,0,14,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,
  // 0x30fb  ・
  251,48,12,12,24,48,15,12,31,128,31,128,31,128,255,240,255,240,255,240,255,240,255,240,255,240,31,128,31,128,31,128,
  // 0x30fc  ー
  252,48,36,6,30,48,3,15,224,0,7,255,240,224,0,7,255,240,224,0,7,255,240,31,255,248,0,0,31,255,248,0,0,31,255,248,0,0,
  // 0x30fd  ヽ
  253,48,21,15,45,48,12,12,252,0,0,252,0,0,252,0,0,3,240,0,3,240,0,3,240,0,0,14,0,0,14,0,0,14,0,0,1,192,0,1,192,0,1,192,0,0,56,0,0,56,0,0,56,
  // 0x30fe  ヾ
  254,48,24,21,63,48,12,12,0,0,56,0,0,56,0,0,56,0,14,7,0,14,7,0,14,7,252,1,192,252,1,192,252,1,192,3,240,0,3,240,0,3,240,0,0,14,0,0,14,0,0,14,0,0,1,192,0,1,192,0,1,192,0,0,56,0,0,56,0,0,56,
  // 0x30ff  ヿ
  255,48,30,39,156,48,6,253,224,1,255,224,224,1,255,224,224,1,255,224,31,254,0,28,31,254,0,28,31,254,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,0,0,0,28,
  // 0x4eee  仮
  238,78,45,48,32,48,0,250,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,0,14,0,3,255,192,0,14,0,3,255,192,0,14,0,3,255,192,0,14,63,252,0,0,0,14,63,252,0,0,0,14,63,252,0,0,0,112,56,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,0,112,56,0,0,0,3,240,56,0,0,0,3,240,56,0,0,0,3,240,56,0,0,0,3,240,63,255,254,0,3,240,63,255,254,0,3,240,63,255,254,0,28,112,56,224,14,0,28,112,56,224,14,0,28,112,56,224,14,0,224,112,56,224,14,0,224,112,56,224,14,0,224,112,56,224,14,0,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,224,14,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,28,112,0,0,112,56,3,128,0,0,112,56,3,128,0,0,112,56,3,128,0,0,113,192,28,112,0,0,113,192,28,112,0,0,113,192,28,112,0,0,113,192,224,14,0,0,113,192,224,14,0,0,113,192,224,14,0,0,126,7,0,1,248,0,126,7,0,1,248,0,126,7,0,1,248,
  // 0x540d  名
  13,84,39,48,240,48,0,250,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,0,56,0,0,0,1,255,255,240,0,1,255,255,240,0,1,255,255,240,0,14,0,0,112,0,14,0,0,112,0,14,0,0,112,0,113,192,3,128,0,113,192,3,128,0,113,192,3,128,31,128,56,28,0,31,128,56,28,0,31,128,56,28,0,0,0,56,224,0,0,0,56,224,0,0,0,56,224,0,0,0,7,0,0,0,0,7,0,0,0,0,7,0,0,0,1,248,0,0,0,1,248,0,0,0,1,248,0,0,0,127,255,255,254,0,127,255,255,254,0,127,255,255,254,255,142,0,0,14,255,142,0,0,14,255,142,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,0,15,255,255,254,0,15,255,255,254,0,15,255,255,254,0,14,0,0,14,0,14,0,0,14,0,14,0,0,14,
  // 0x5b9a  定
  154,91,45,48,32,48,0,250,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,248,31,255,255,255,255,248,31,255,255,255,255,248,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,224,0,0,0,1,192,224,0,0,0,1,192,224,0,0,0,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,255,254,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,0,112,7,0,0,0,3,142,7,0,0,0,3,142,7,0,0,0,3,142,7,0,0,0,28,1,255,255,255,248,28,1,255,255,255,248,28,1,255,255,255,248,224,0,0,0,0,0,224,0,0,0,0,0,224,0,0,0,0,0,
  // 0x7247  片
  71,114,39,48,240,48,3,250,0,0,0,224,0,0,0,0,224,0,0,0,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,128,0,224,0,3,255,255,255,254,3,255,255,255,254,3,255,255,255,254,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,128,0,0,0,3,255,255,252,0,3,255,255,252,0,3,255,255,252,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,3,128,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,28,0,0,28,0,224,0,0,28,0,224,0,0,28,0,224,0,0,28,0,
  // 0x793a  示
  58,121,45,45,14,48,0,250,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,112,0,0,112,7,0,14,0,0,112,7,0,14,0,0,112,7,0,14,0,3,128,7,0,1,192,3,128,7,0,1,192,3,128,7,0,1,192,28,0,7,0,0,56,28,0,7,0,0,56,28,0,7,0,0,56,224,0,7,0,0,56,224,0,7,0,0,56,224,0,7,0,0,56,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,0,0,56,0,0,0,
  // 0x7fa9  義
  169,127,45,48,32,48,0,250,0,14,0,3,128,0,0,14,0,3,128,0,0,14,0,3,128,0,0,1,192,28,0,0,0,1,192,28,0,0,0,1,192,28,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,0,56,28,0,0,0,0,56,28,0,0,0,0,56,28,0,0,3,255,192,28,112,0,3,255,192,28,112,0,3,255,192,28,112,0,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,14,0,28,14,0,0,14,0,28,14,0,0,14,0,28,14,0,0,15,248,28,112,0,0,15,248,28,112,0,0,15,248,28,112,0,31,254,0,3,129,192,31,254,0,3,129,192,31,254,0,3,129,192,0,14,0,28,113,192,0,14,0,28,113,192,0,14,0,28,113,192,0,126,7,224,15,192,0,126,7,224,15,192,0,126,7,224,15,192,
  // 0x8868  表
  104,136,45,48,32,48,0,250,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,31,255,255,255,255,192,31,255,255,255,255,192,31,255,255,255,255,192,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,3,255,255,255,254,0,3,255,255,255,254,0,3,255,255,255,254,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,255,255,255,255,255,248,255,255,255,255,255,248,255,255,255,255,255,248,0,1,199,0,0,0,0,1,199,0,0,0,0,1,199,0,0,0,0,14,0,224,14,0,0,14,0,224,14,0,0,14,0,224,14,0,0,126,0,28,112,0,0,126,0,28,112,0,0,126,0,28,112,0,3,142,0,3,128,0,3,142,0,3,128,0,3,142,0,3,128,0,252,14,7,0,126,0,252,14,7,0,126,0,252,14,7,0,126,0,0,14,56,0,1,248,0,14,56,0,1,248,0,14,56,0,1,248,0,15,192,0,0,0,0,15,192,0,0,0,0,15,192,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
