/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Vietnamese 32pt, capital 'A' height: 20px, width: 100%, range: 0x0102-0x1ef9, glyphs: 107
extern const uint8_t Unifont_Vietnamese_20[6262] = {
  161,20,2,1,249,30,28,252, // unifont_t
  // 0x0102  Ă
  2,1,12,28,56,16,2,0,192,48,192,48,192,48,192,48,63,192,63,192,0,0,0,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x0103  ă
  3,1,12,26,52,16,2,0,192,48,192,48,192,48,192,48,63,192,63,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x0110  Đ
  16,1,14,20,40,16,0,0,63,192,63,192,48,48,48,48,48,12,48,12,48,12,48,12,255,12,255,12,48,12,48,12,48,12,48,12,48,12,48,12,48,48,48,48,63,192,63,192,
  // 0x0111  đ
  17,1,14,22,44,16,2,0,0,48,0,48,3,252,3,252,0,48,0,48,63,48,63,48,192,240,192,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x0128  Ĩ
  40,1,12,28,56,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,0,0,0,63,240,63,240,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,63,240,63,240,
  // 0x0129  ĩ
  41,1,12,24,48,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,0,0,0,15,0,15,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,63,240,63,240,
  // 0x0168  Ũ
  104,1,12,28,56,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0169  ũ
  105,1,12,24,48,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x01a0  Ơ
  160,1,12,22,44,16,2,0,0,48,0,48,63,48,63,48,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x01a1  ơ
  161,1,12,18,36,16,2,0,0,48,0,48,63,48,63,48,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x01af  Ư
  175,1,14,24,48,16,2,0,0,12,0,12,0,12,0,12,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x01b0  ư
  176,1,14,20,40,16,2,0,0,12,0,12,0,12,0,12,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,195,192,195,192,60,192,60,192,
  // 0x0303  ̃
  3,3,12,4,8,0,242,22,60,48,60,48,195,192,195,192,
  // 0x0309  ̉
  9,3,8,10,10,0,244,18,60,60,195,195,3,3,12,12,12,12,
  // 0x0323  ̣
  35,3,4,4,4,0,246,252,240,240,240,240,
  // 0x0340  ̀
  64,3,6,6,6,0,242,20,192,192,48,48,12,12,
  // 0x0341  ́
  65,3,6,6,6,0,248,20,12,12,48,48,192,192,
  // 0x1ea0  Ạ
  160,30,10,24,48,16,2,252,12,0,12,0,51,0,51,0,51,0,51,0,192,192,192,192,192,192,192,192,255,192,255,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,0,0,0,0,12,0,12,0,
  // 0x1ea1  ạ
  161,30,12,20,40,16,2,252,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,0,0,0,0,12,0,12,0,
  // 0x1ea2  Ả
  162,30,12,28,56,16,2,0,192,0,192,0,48,0,48,0,48,0,48,0,192,0,192,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x1ea3  ả
  163,30,12,26,52,16,2,0,3,0,3,0,0,192,0,192,0,192,0,192,3,0,3,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x1ea4  Ấ
  164,30,12,28,56,16,2,0,0,48,0,48,12,192,12,192,51,0,51,0,192,192,192,192,12,0,12,0,51,0,51,0,51,0,51,0,192,192,192,192,192,192,192,192,255,192,255,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x1ea5  ấ
  165,30,12,26,52,16,2,0,0,48,0,48,12,192,12,192,51,0,51,0,192,192,192,192,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x1ea6  Ầ
  166,30,12,28,56,16,2,0,192,0,192,0,51,0,51,0,12,192,12,192,48,48,48,48,3,0,3,0,12,192,12,192,12,192,12,192,48,48,48,48,48,48,48,48,63,240,63,240,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
  // 0x1ea7  ầ
  167,30,12,26,52,16,2,0,192,0,192,0,51,0,51,0,12,192,12,192,48,48,48,48,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x1ea8  Ẩ
  168,30,12,28,56,16,2,0,0,192,0,192,0,48,0,48,12,192,12,192,51,0,51,0,204,192,204,192,51,0,51,0,51,0,51,0,192,192,192,192,192,192,192,192,255,192,255,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x1ea9  ẩ
  169,30,14,28,56,16,2,0,0,48,0,48,0,12,0,12,3,48,3,48,12,192,12,192,48,48,48,48,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x1eaa  Ẫ
  170,30,12,28,56,16,4,0,60,48,60,48,195,192,195,192,12,0,12,0,51,0,51,0,192,192,192,192,12,0,12,0,51,0,51,0,51,0,51,0,192,192,192,192,192,192,192,192,255,192,255,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x1eab  ẫ
  171,30,14,28,56,16,2,0,15,12,15,12,48,240,48,240,3,0,3,0,12,192,12,192,48,48,48,48,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x1eac  Ậ
  172,30,10,30,60,16,4,252,12,0,12,0,51,0,51,0,192,192,192,192,12,0,12,0,51,0,51,0,51,0,51,0,192,192,192,192,192,192,192,192,255,192,255,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,0,0,0,0,12,0,12,0,
  // 0x1ead  ậ
  173,30,12,28,56,16,2,252,15,0,15,0,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,0,0,0,0,3,0,3,0,
  // 0x1eae  Ắ
  174,30,10,28,56,16,2,0,3,0,3,0,12,0,12,0,192,192,192,192,63,0,63,0,12,0,12,0,51,0,51,0,51,0,51,0,192,192,192,192,192,192,192,192,255,192,255,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x1eaf  ắ
  175,30,12,28,56,16,2,0,0,192,0,192,3,0,3,0,12,0,12,0,192,192,192,192,63,0,63,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x1eb0  Ằ
  176,30,10,28,56,16,2,0,48,0,48,0,12,0,12,0,192,192,192,192,63,0,63,0,12,0,12,0,51,0,51,0,51,0,51,0,192,192,192,192,192,192,192,192,255,192,255,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x1eb1  ằ
  177,30,12,28,56,16,2,0,48,0,48,0,12,0,12,0,3,0,3,0,48,48,48,48,15,192,15,192,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x1eb2  Ẳ
  178,30,14,28,56,16,0,0,3,0,3,0,0,192,0,192,207,12,207,12,63,240,63,240,3,0,3,0,12,192,12,192,12,192,12,192,48,48,48,48,48,48,48,48,63,240,63,240,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
  // 0x1eb3  ẳ
  179,30,12,28,56,16,2,0,3,0,3,0,3,0,3,0,12,0,12,0,192,192,192,192,63,0,63,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x1eb4  Ẵ
  180,30,14,28,56,16,0,0,15,12,15,12,48,240,48,240,192,12,192,12,63,240,63,240,3,0,3,0,12,192,12,192,12,192,12,192,48,48,48,48,48,48,48,48,63,240,63,240,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
  // 0x1eb5  ẵ
  181,30,12,28,56,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,192,48,192,48,63,192,63,192,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x1eb6  Ặ
  182,30,10,28,56,16,2,252,192,192,192,192,63,0,63,0,12,0,12,0,51,0,51,0,51,0,51,0,192,192,192,192,192,192,192,192,255,192,255,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,0,0,0,0,12,0,12,0,
  // 0x1eb7  ặ
  183,30,12,26,52,16,2,252,48,192,48,192,15,0,15,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,0,0,0,0,12,0,12,0,
  // 0x1eb8  Ẹ
  184,30,12,24,48,16,2,252,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,0,0,0,0,12,0,12,0,
  // 0x1eb9  ẹ
  185,30,12,20,40,16,2,252,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,0,0,0,0,12,0,12,0,
  // 0x1eba  Ẻ
  186,30,12,28,56,16,2,0,12,0,12,0,3,0,3,0,3,0,3,0,12,0,12,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x1ebb  ẻ
  187,30,12,28,56,16,2,0,12,0,12,0,3,0,3,0,3,0,3,0,12,0,12,0,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x1ebc  Ẽ
  188,30,12,26,52,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x1ebd  ẽ
  189,30,12,22,44,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x1ebe  Ế
  190,30,12,28,56,16,2,0,0,48,0,48,12,192,12,192,51,0,51,0,192,192,192,192,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x1ebf  ế
  191,30,12,26,52,16,2,0,0,48,0,48,12,192,12,192,51,0,51,0,192,192,192,192,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x1ec0  Ề
  192,30,12,28,56,16,2,0,192,0,192,0,51,0,51,0,12,192,12,192,48,48,48,48,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x1ec1  ề
  193,30,12,26,52,16,2,0,192,0,192,0,51,0,51,0,12,192,12,192,48,48,48,48,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x1ec2  Ể
  194,30,12,28,56,16,2,0,0,192,0,192,12,48,12,48,51,48,51,48,192,192,192,192,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x1ec3  ể
  195,30,12,28,56,16,2,0,0,192,0,192,0,48,0,48,12,48,12,48,51,192,51,192,192,192,192,192,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x1ec4  Ễ
  196,30,12,28,56,16,2,0,60,48,60,48,195,192,195,192,12,0,12,0,51,0,51,0,192,192,192,192,255,240,255,240,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x1ec5  ễ
  197,30,12,28,56,16,2,0,60,48,60,48,195,192,195,192,12,0,12,0,51,0,51,0,192,192,192,192,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x1ec6  Ệ
  198,30,12,30,60,16,2,252,15,0,15,0,48,192,48,192,0,0,0,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,0,0,0,0,3,0,3,0,
  // 0x1ec7  ệ
  199,30,12,28,56,16,2,252,15,0,15,0,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,0,0,0,0,3,0,3,0,
  // 0x1ec8  Ỉ
  200,30,10,28,56,16,4,0,12,0,12,0,3,0,3,0,3,0,3,0,12,0,12,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x1ec9  ỉ
  201,30,10,26,52,16,4,0,48,0,48,0,12,0,12,0,12,0,12,0,48,0,48,0,0,0,0,0,60,0,60,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x1eca  Ị
  202,30,10,24,48,16,4,252,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,0,0,0,0,12,0,12,0,
  // 0x1ecb  ị
  203,30,10,26,52,16,4,252,12,0,12,0,12,0,12,0,0,0,0,0,60,0,60,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,0,0,0,0,12,0,12,0,
  // 0x1ecc  Ọ
  204,30,12,24,48,16,2,252,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,0,0,0,0,3,0,3,0,
  // 0x1ecd  ọ
  205,30,12,20,40,16,2,252,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,0,0,0,0,3,0,3,0,
  // 0x1ece  Ỏ
  206,30,12,28,56,16,2,0,12,0,12,0,3,0,3,0,3,0,3,0,12,0,12,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x1ecf  ỏ
  207,30,12,26,52,16,2,0,12,0,12,0,3,0,3,0,3,0,3,0,12,0,12,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x1ed0  Ố
  208,30,12,28,56,16,2,0,0,48,0,48,12,192,12,192,51,0,51,0,192,192,192,192,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x1ed1  ố
  209,30,12,26,52,16,2,0,0,48,0,48,12,192,12,192,51,0,51,0,192,192,192,192,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x1ed2  Ồ
  210,30,12,28,56,16,2,0,192,0,192,0,51,0,51,0,12,192,12,192,48,48,48,48,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x1ed3  ồ
  211,30,12,26,52,16,2,0,192,0,192,0,51,0,51,0,12,192,12,192,48,48,48,48,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x1ed4  Ổ
  212,30,12,28,56,16,2,0,0,192,0,192,12,48,12,48,51,48,51,48,192,192,192,192,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x1ed5  ổ
  213,30,12,28,56,16,2,0,0,192,0,192,0,48,0,48,12,48,12,48,51,192,51,192,192,192,192,192,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x1ed6  Ỗ
  214,30,12,28,56,16,2,0,60,48,60,48,195,192,195,192,12,0,12,0,51,0,51,0,192,192,192,192,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x1ed7  ỗ
  215,30,12,28,56,16,2,0,60,48,60,48,195,192,195,192,12,0,12,0,51,0,51,0,192,192,192,192,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x1ed8  Ộ
  216,30,12,30,60,16,2,252,15,0,15,0,48,192,48,192,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,0,0,0,0,3,0,3,0,
  // 0x1ed9  ộ
  217,30,12,28,56,16,2,252,15,0,15,0,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,0,0,0,0,3,0,3,0,
  // 0x1eda  Ớ
  218,30,14,28,56,16,2,0,3,0,3,0,12,0,12,0,48,48,48,48,0,12,0,12,63,12,63,12,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1edb  ớ
  219,30,14,24,48,16,2,0,3,0,3,0,12,0,12,0,48,48,48,48,0,12,0,12,63,12,63,12,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1edc  Ờ
  220,30,14,28,56,16,2,0,48,0,48,0,12,0,12,0,3,48,3,48,0,12,0,12,63,12,63,12,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1edd  ờ
  221,30,14,24,48,16,2,0,48,0,48,0,12,0,12,0,3,48,3,48,0,12,0,12,63,12,63,12,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1ede  Ở
  222,30,14,28,56,16,2,0,12,0,12,0,3,0,3,0,3,48,3,48,12,12,12,12,63,12,63,12,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1edf  ở
  223,30,14,26,52,16,2,0,12,0,12,0,3,0,3,0,3,0,3,0,12,48,12,48,0,12,0,12,63,12,63,12,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1ee0  Ỡ
  224,30,14,26,52,16,2,0,60,48,60,48,195,192,195,192,0,48,0,48,63,12,63,12,192,204,192,204,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1ee1  ỡ
  225,30,14,26,52,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,48,0,48,0,12,0,12,63,12,63,12,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1ee2  Ợ
  226,30,14,28,56,16,2,252,0,48,0,48,0,12,0,12,63,12,63,12,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,0,0,0,0,12,0,12,0,
  // 0x1ee3  ợ
  227,30,14,24,48,16,2,252,0,48,0,48,0,12,0,12,63,12,63,12,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,0,0,0,0,12,0,12,0,
  // 0x1ee4  Ụ
  228,30,12,24,48,16,2,252,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,0,0,0,0,3,0,3,0,
  // 0x1ee5  ụ
  229,30,12,20,40,16,2,252,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,0,0,0,0,3,0,3,0,
  // 0x1ee6  Ủ
  230,30,12,28,56,16,2,0,12,0,12,0,3,0,3,0,3,0,3,0,12,0,12,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x1ee7  ủ
  231,30,12,26,52,16,2,0,12,0,12,0,3,0,3,0,3,0,3,0,12,0,12,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x1ee8  Ứ
  232,30,14,28,56,16,2,0,0,192,0,192,3,0,3,0,12,48,12,48,0,12,0,12,192,204,192,204,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1ee9  ứ
  233,30,14,24,48,16,2,0,0,192,0,192,3,0,3,0,12,48,12,48,0,12,0,12,192,204,192,204,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,195,192,195,192,60,192,60,192,
  // 0x1eea  Ừ
  234,30,14,28,56,16,2,0,192,0,192,0,48,0,48,0,12,48,12,48,0,12,0,12,192,204,192,204,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1eeb  ừ
  235,30,14,24,48,16,2,0,192,0,192,0,48,0,48,0,12,48,12,48,0,12,0,12,192,204,192,204,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,195,192,195,192,60,192,60,192,
  // 0x1eec  Ử
  236,30,14,28,56,16,2,0,12,0,12,0,3,0,3,0,3,48,3,48,12,12,12,12,192,204,192,204,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1eed  ử
  237,30,14,26,52,16,2,0,12,0,12,0,3,0,3,0,3,0,3,0,12,48,12,48,0,12,0,12,192,204,192,204,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,195,192,195,192,60,192,60,192,
  // 0x1eee  Ữ
  238,30,14,28,56,16,2,0,60,48,60,48,195,192,195,192,0,48,0,48,0,12,0,12,192,204,192,204,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x1eef  ữ
  239,30,14,26,52,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,48,0,48,0,12,0,12,192,204,192,204,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,195,192,195,192,60,192,60,192,
  // 0x1ef0  Ự
  240,30,14,28,56,16,2,252,0,48,0,48,0,12,0,12,192,204,192,204,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,0,0,0,0,12,0,12,0,
  // 0x1ef1  ự
  241,30,14,24,48,16,2,252,0,48,0,48,0,12,0,12,192,204,192,204,192,240,192,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,195,192,195,192,60,192,60,192,0,0,0,0,12,0,12,0,
  // 0x1ef2  Ỳ
  242,30,14,28,56,16,2,0,48,0,48,0,12,0,12,0,3,0,3,0,0,0,0,0,192,12,192,12,192,12,192,12,48,48,48,48,48,48,48,48,12,192,12,192,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x1ef3  ỳ
  243,30,12,30,60,16,2,252,48,0,48,0,12,0,12,0,3,0,3,0,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,48,240,48,240,15,48,15,48,0,48,0,48,0,48,0,48,63,192,63,192,
  // 0x1ef4  Ỵ
  244,30,14,24,48,16,2,252,192,12,192,12,192,12,192,12,48,48,48,48,48,48,48,48,12,192,12,192,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,0,0,0,0,3,0,3,0,
  // 0x1ef5  ỵ
  245,30,12,20,40,16,2,252,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,48,240,48,240,15,48,15,48,0,48,0,48,63,192,63,192,3,0,3,0,
  // 0x1ef6  Ỷ
  246,30,14,28,56,16,2,0,3,0,3,0,0,192,0,192,0,192,0,192,3,0,3,0,192,12,192,12,192,12,192,12,48,48,48,48,48,48,48,48,12,192,12,192,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x1ef7  ỷ
  247,30,12,30,60,16,2,252,12,0,12,0,3,0,3,0,3,0,3,0,12,0,12,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,48,240,48,240,15,48,15,48,0,48,0,48,0,48,0,48,63,192,63,192,
  // 0x1ef8  Ỹ
  248,30,14,26,52,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,192,12,192,12,192,12,192,12,48,48,48,48,48,48,48,48,12,192,12,192,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x1ef9  ỹ
  249,30,12,28,56,16,2,252,60,48,60,48,195,192,195,192,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,48,240,48,240,15,48,15,48,0,48,0,48,0,48,0,48,63,192,63,192,
};

#endif // HAS_GRAPHICAL_TFT
