/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont Cyrillic 32pt, capital 'A' height: 20px, width: 100%, range: 0x0401-0x0491, glyphs: 74
extern const uint8_t Unifont_Cyrillic_20[3403] = {
  129,20,1,4,145,4,28,252, // unifont_t
  // 0x0401  Ё
  12,28,56,16,2,0,48,192,48,192,48,192,48,192,0,0,0,0,0,0,0,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x0402  Ђ
  255,
  // 0x0403  Ѓ
  255,
  // 0x0404  Є
  12,20,40,16,2,0,15,192,15,192,48,48,48,48,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,48,48,48,48,15,192,15,192,
  // 0x0405  Ѕ
  255,
  // 0x0406  І
  10,20,40,16,4,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x0407  Ї
  10,28,56,16,4,0,195,0,195,0,195,0,195,0,0,0,0,0,0,0,0,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x0408  Ј
  255,
  // 0x0409  Љ
  255,
  // 0x040a  Њ
  255,
  // 0x040b  Ћ
  255,
  // 0x040c  Ќ
  255,
  // 0x040d  Ѝ
  255,
  // 0x040e  Ў
  255,
  // 0x040f  Џ
  255,
  // 0x0410  А
  12,20,40,16,2,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x0411  Б
  12,20,40,16,2,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,255,192,255,192,
  // 0x0412  В
  12,20,40,16,2,0,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,255,192,255,192,
  // 0x0413  Г
  12,20,40,16,2,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0414  Д
  16,24,48,16,0,252,0,252,0,252,3,12,3,12,3,12,3,12,3,12,3,12,12,12,12,12,12,12,12,12,12,12,12,12,48,12,48,12,48,12,48,12,255,255,255,255,192,3,192,3,192,3,192,3,
  // 0x0415  Е
  12,20,40,16,2,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x0416  Ж
  14,20,40,16,2,0,195,12,195,12,195,12,195,12,51,48,51,48,51,48,51,48,15,192,15,192,15,192,15,192,51,48,51,48,51,48,51,48,195,12,195,12,195,12,195,12,
  // 0x0417  З
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,0,48,0,48,0,48,0,48,63,192,63,192,0,192,0,192,0,48,0,48,0,48,0,48,192,48,192,48,63,192,63,192,
  // 0x0418  И
  12,20,40,16,2,0,192,48,192,48,192,240,192,240,192,240,192,240,195,48,195,48,195,48,195,48,204,48,204,48,204,48,204,48,240,48,240,48,240,48,240,48,192,48,192,48,
  // 0x0419  Й
  12,26,52,16,2,0,48,192,48,192,15,0,15,0,0,0,0,0,192,48,192,48,192,240,192,240,192,240,192,240,195,48,195,48,195,48,195,48,204,48,204,48,204,48,204,48,240,48,240,48,240,48,240,48,192,48,192,48,
  // 0x041a  К
  12,20,40,16,2,0,192,240,192,240,195,0,195,0,195,0,195,0,204,0,204,0,204,0,204,0,240,0,240,0,204,0,204,0,195,0,195,0,192,192,192,192,192,48,192,48,
  // 0x041b  Л
  12,20,40,16,2,0,15,240,15,240,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,48,48,48,48,48,48,48,48,192,48,192,48,
  // 0x041c  М
  12,20,40,16,2,0,192,48,192,48,192,48,192,48,240,240,240,240,240,240,240,240,207,48,207,48,207,48,207,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x041d  Н
  12,20,40,16,2,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x041e  О
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x041f  П
  12,20,40,16,2,0,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x0420  Р
  12,20,40,16,2,0,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0421  С
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0422  Т
  14,20,40,16,2,0,255,252,255,252,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x0423  У
  14,20,40,16,2,0,192,12,192,12,192,12,192,12,48,48,48,48,48,48,48,48,12,192,12,192,12,192,12,192,3,0,3,0,3,0,3,0,12,0,12,0,60,0,60,0,
  // 0x0424  Ф
  14,22,44,16,2,0,3,0,3,0,63,240,63,240,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,63,240,63,240,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x0425  Х
  12,20,40,16,2,0,192,48,192,48,192,48,192,48,48,192,48,192,48,192,48,192,15,0,15,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,
  // 0x0426  Ц
  14,24,48,16,2,252,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,255,252,255,252,0,12,0,12,0,12,0,12,
  // 0x0427  Ч
  12,20,40,16,2,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,0,48,0,48,0,48,0,48,0,48,0,48,
  // 0x0428  Ш
  14,20,40,16,2,0,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,255,252,255,252,
  // 0x0429  Щ
  16,24,48,16,0,252,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,255,255,255,255,0,3,0,3,0,3,0,3,
  // 0x042a  Ъ
  14,20,40,16,2,0,252,0,252,0,12,0,12,0,12,0,12,0,12,0,12,0,15,240,15,240,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,15,240,15,240,
  // 0x042b  Ы
  12,20,40,16,2,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,252,48,252,48,195,48,195,48,195,48,195,48,195,48,195,48,195,48,195,48,252,48,252,48,
  // 0x042c  Ь
  12,20,40,16,2,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,255,192,255,192,
  // 0x042d  Э
  12,20,40,16,2,0,63,0,63,0,192,192,192,192,0,48,0,48,0,48,0,48,63,240,63,240,0,48,0,48,0,48,0,48,0,48,0,48,192,192,192,192,63,0,63,0,
  // 0x042e  Ю
  12,20,40,16,2,0,195,192,195,192,204,48,204,48,204,48,204,48,204,48,204,48,252,48,252,48,204,48,204,48,204,48,204,48,204,48,204,48,204,48,204,48,195,192,195,192,
  // 0x042f  Я
  12,20,40,16,2,0,63,240,63,240,192,48,192,48,192,48,192,48,192,48,192,48,63,240,63,240,12,48,12,48,48,48,48,48,48,48,48,48,192,48,192,48,192,48,192,48,
  // 0x0430  а
  12,16,32,16,2,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x0431  б
  12,24,48,16,2,0,0,48,0,48,15,192,15,192,48,0,48,0,192,0,192,0,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0432  в
  12,16,32,16,2,0,255,192,255,192,192,48,192,48,192,48,192,48,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,255,192,255,192,
  // 0x0433  г
  12,16,32,16,2,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0434  д
  14,18,36,16,2,254,15,240,15,240,12,48,12,48,48,48,48,48,48,48,48,48,192,48,192,48,192,48,192,48,192,48,192,48,255,252,255,252,192,12,192,12,
  // 0x0435  е
  12,16,32,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x0436  ж
  14,16,32,16,2,0,195,12,195,12,195,12,195,12,51,48,51,48,15,192,15,192,15,192,15,192,51,48,51,48,195,12,195,12,195,12,195,12,
  // 0x0437  з
  12,16,32,16,2,0,63,192,63,192,192,48,192,48,0,48,0,48,63,192,63,192,0,192,0,192,0,48,0,48,192,48,192,48,63,192,63,192,
  // 0x0438  и
  12,16,32,16,2,0,192,240,192,240,192,240,192,240,195,48,195,48,195,48,195,48,204,48,204,48,204,48,204,48,240,48,240,48,240,48,240,48,
  // 0x0439  й
  12,24,48,16,2,0,48,192,48,192,15,0,15,0,0,0,0,0,0,0,0,0,192,240,192,240,192,240,192,240,195,48,195,48,195,48,195,48,204,48,204,48,204,48,204,48,240,48,240,48,240,48,240,48,
  // 0x043a  к
  12,16,32,16,2,0,192,240,192,240,195,0,195,0,204,0,204,0,240,0,240,0,204,0,204,0,195,0,195,0,192,192,192,192,192,48,192,48,
  // 0x043b  л
  12,16,32,16,2,0,15,240,15,240,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,48,48,48,48,48,48,48,48,192,48,192,48,
  // 0x043c  м
  12,16,32,16,2,0,192,48,192,48,240,240,240,240,240,240,240,240,207,48,207,48,207,48,207,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x043d  н
  12,16,32,16,2,0,192,48,192,48,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x043e  о
  12,16,32,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x043f  п
  12,16,32,16,2,0,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x0440  р
  12,20,40,16,2,252,207,192,207,192,240,48,240,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,240,48,240,48,207,192,207,192,192,0,192,0,192,0,192,0,
  // 0x0441  с
  12,16,32,16,2,0,63,192,63,192,192,48,192,48,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x0442  т
  14,16,32,16,2,0,255,252,255,252,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x0443  у
  12,20,40,16,2,252,192,48,192,48,192,48,192,48,48,192,48,192,48,192,48,192,15,0,15,0,15,0,15,0,12,0,12,0,12,0,12,0,48,0,48,0,240,0,240,0,
  // 0x0444  ф
  14,26,52,16,2,252,3,0,3,0,3,0,3,0,3,0,3,0,63,240,63,240,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,63,240,63,240,3,0,3,0,3,0,3,0,
  // 0x0445  х
  12,16,32,16,2,0,192,48,192,48,192,48,192,48,48,192,48,192,15,0,15,0,15,0,15,0,48,192,48,192,192,48,192,48,192,48,192,48,
  // 0x0446  ц
  14,20,40,16,2,252,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,255,252,255,252,0,12,0,12,0,12,0,12,
  // 0x0447  ч
  12,16,32,16,2,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,0,48,0,48,0,48,0,48,
  // 0x0448  ш
  14,16,32,16,2,0,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,255,252,255,252,
  // 0x0449  щ
  16,20,40,16,0,252,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,255,255,255,255,0,3,0,3,0,3,0,3,
  // 0x044a  ъ
  14,16,32,16,2,0,252,0,252,0,12,0,12,0,12,0,12,0,15,240,15,240,12,12,12,12,12,12,12,12,12,12,12,12,15,240,15,240,
  // 0x044b  ы
  12,16,32,16,2,0,192,48,192,48,192,48,192,48,192,48,192,48,252,48,252,48,195,48,195,48,195,48,195,48,195,48,195,48,252,48,252,48,
  // 0x044c  ь
  12,16,32,16,2,0,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,255,192,255,192,
  // 0x044d  э
  12,16,32,16,2,0,63,0,63,0,192,192,192,192,0,48,0,48,63,240,63,240,0,48,0,48,0,48,0,48,192,192,192,192,63,0,63,0,
  // 0x044e  ю
  12,16,32,16,2,0,195,192,195,192,204,48,204,48,204,48,204,48,252,48,252,48,204,48,204,48,204,48,204,48,204,48,204,48,195,192,195,192,
  // 0x044f  я
  12,16,32,16,2,0,63,240,63,240,192,48,192,48,192,48,192,48,192,48,192,48,63,240,63,240,12,48,12,48,48,48,48,48,192,48,192,48,
  // 0x0450  ѐ
  255,
  // 0x0451  ё
  12,24,48,16,2,0,48,192,48,192,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x0452  ђ
  255,
  // 0x0453  ѓ
  255,
  // 0x0454  є
  12,16,32,16,2,0,15,192,15,192,48,48,48,48,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,48,48,48,48,15,192,15,192,
  // 0x0455  ѕ
  255,
  // 0x0456  і
  10,22,44,16,4,0,12,0,12,0,12,0,12,0,0,0,0,0,60,0,60,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x0457  ї
  10,22,44,16,4,0,195,0,195,0,195,0,195,0,0,0,0,0,60,0,60,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x0458  ј
  255,
  // 0x0459  љ
  255,
  // 0x045a  њ
  255,
  // 0x045b  ћ
  255,
  // 0x045c  ќ
  255,
  // 0x045d  ѝ
  255,
  // 0x045e  ў
  255,
  // 0x045f  џ
  255,
  // 0x0460  Ѡ
  255,
  // 0x0461  ѡ
  255,
  // 0x0462  Ѣ
  255,
  // 0x0463  ѣ
  255,
  // 0x0464  Ѥ
  255,
  // 0x0465  ѥ
  255,
  // 0x0466  Ѧ
  255,
  // 0x0467  ѧ
  255,
  // 0x0468  Ѩ
  255,
  // 0x0469  ѩ
  255,
  // 0x046a  Ѫ
  255,
  // 0x046b  ѫ
  255,
  // 0x046c  Ѭ
  255,
  // 0x046d  ѭ
  255,
  // 0x046e  Ѯ
  255,
  // 0x046f  ѯ
  255,
  // 0x0470  Ѱ
  255,
  // 0x0471  ѱ
  255,
  // 0x0472  Ѳ
  255,
  // 0x0473  ѳ
  255,
  // 0x0474  Ѵ
  255,
  // 0x0475  ѵ
  255,
  // 0x0476  Ѷ
  255,
  // 0x0477  ѷ
  255,
  // 0x0478  Ѹ
  255,
  // 0x0479  ѹ
  255,
  // 0x047a  Ѻ
  255,
  // 0x047b  ѻ
  255,
  // 0x047c  Ѽ
  255,
  // 0x047d  ѽ
  255,
  // 0x047e  Ѿ
  255,
  // 0x047f  ѿ
  255,
  // 0x0480  Ҁ
  255,
  // 0x0481  ҁ
  255,
  // 0x0482  ҂
  255,
  // 0x0483  ҃
  255,
  // 0x0484  ҄
  255,
  // 0x0485  ҅
  255,
  // 0x0486  ҆
  255,
  // 0x0487  ҇
  255,
  // 0x0488  ҈
  255,
  // 0x0489  ҉
  255,
  // 0x048a  Ҋ
  255,
  // 0x048b  ҋ
  255,
  // 0x048c  Ҍ
  255,
  // 0x048d  ҍ
  255,
  // 0x048e  Ҏ
  255,
  // 0x048f  ҏ
  255,
  // 0x0490  Ґ
  12,24,48,16,2,0,0,48,0,48,0,48,0,48,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0491  ґ
  12,20,40,16,2,0,0,48,0,48,0,48,0,48,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,
};

#endif // HAS_GRAPHICAL_TFT
