/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// Unifont 32pt, capital 'A' height: 20px, width: 100%, range: 0x0020-0x00ff
extern const uint8_t Unifont_20[8545] = {
  129,20,32,0,255,0,28,252, // unifont_t
  // 0x0020 " "
  0,0,0,16,0,0,
  // 0x0021  !
  2,20,20,16,8,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,0,0,192,192,192,192,
  // 0x0022  "
  10,8,16,16,4,16,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x0023  #
  12,20,40,16,2,0,12,48,12,48,12,48,12,48,12,48,12,48,255,240,255,240,48,192,48,192,48,192,48,192,255,240,255,240,195,0,195,0,195,0,195,0,195,0,195,0,
  // 0x0024  $
  14,20,40,16,2,0,3,0,3,0,63,240,63,240,195,12,195,12,195,0,195,0,63,0,63,0,3,240,3,240,3,12,3,12,195,12,195,12,63,240,63,240,3,0,3,0,
  // 0x0025  %
  14,20,40,16,2,0,60,12,60,12,195,48,195,48,195,48,195,48,60,192,60,192,3,0,3,0,3,0,3,0,12,240,12,240,51,12,51,12,51,12,51,12,192,240,192,240,
  // 0x0026  &
  14,20,40,16,2,0,15,192,15,192,48,48,48,48,48,48,48,48,12,192,12,192,15,0,15,0,51,12,51,12,192,204,192,204,192,48,192,48,192,240,192,240,63,12,63,12,
  // 0x0027  '
  2,8,8,16,8,16,192,192,192,192,192,192,192,192,
  // 0x0028  (
  6,24,24,16,6,254,12,12,48,48,48,48,192,192,192,192,192,192,192,192,192,192,192,192,48,48,48,48,12,12,
  // 0x0029  )
  6,24,24,16,4,254,192,192,48,48,48,48,12,12,12,12,12,12,12,12,12,12,12,12,48,48,48,48,192,192,
  // 0x002a  *
  14,14,28,16,2,2,3,0,3,0,195,12,195,12,51,48,51,48,15,192,15,192,51,48,51,48,195,12,195,12,3,0,3,0,
  // 0x002b  +
  14,14,28,16,2,2,3,0,3,0,3,0,3,0,3,0,3,0,255,252,255,252,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x002c  ,
  4,8,8,16,6,252,240,240,48,48,48,48,192,192,
  // 0x002d  -
  8,2,2,16,4,8,255,255,
  // 0x002e  .
  4,4,4,16,6,0,240,240,240,240,
  // 0x002f  /
  12,20,40,16,2,0,0,48,0,48,0,48,0,48,0,192,0,192,3,0,3,0,3,0,3,0,12,0,12,0,12,0,12,0,48,0,48,0,192,0,192,0,192,0,192,0,
  // 0x0030  0
  12,20,40,16,2,0,15,0,15,0,48,192,48,192,192,48,192,48,192,240,192,240,195,48,195,48,204,48,204,48,240,48,240,48,192,48,192,48,48,192,48,192,15,0,15,0,
  // 0x0031  1
  10,20,40,16,4,0,12,0,12,0,60,0,60,0,204,0,204,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x0032  2
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,0,48,0,48,3,192,3,192,12,0,12,0,48,0,48,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x0033  3
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,0,48,0,48,15,192,15,192,0,48,0,48,0,48,0,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0034  4
  12,20,40,16,2,0,0,192,0,192,3,192,3,192,12,192,12,192,48,192,48,192,192,192,192,192,192,192,192,192,255,240,255,240,0,192,0,192,0,192,0,192,0,192,0,192,
  // 0x0035  5
  12,20,40,16,2,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,0,48,0,48,0,48,0,48,0,48,0,48,192,48,192,48,63,192,63,192,
  // 0x0036  6
  12,20,40,16,2,0,15,192,15,192,48,0,48,0,192,0,192,0,192,0,192,0,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0037  7
  12,20,40,16,2,0,255,240,255,240,0,48,0,48,0,48,0,48,0,192,0,192,0,192,0,192,0,192,0,192,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x0038  8
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0039  9
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,63,240,63,240,0,48,0,48,0,48,0,48,0,48,0,48,0,192,0,192,63,0,63,0,
  // 0x003a  :
  4,14,14,16,6,2,240,240,240,240,0,0,0,0,0,0,240,240,240,240,
  // 0x003b  ;
  4,18,18,16,6,254,240,240,240,240,0,0,0,0,0,0,240,240,48,48,48,48,192,192,
  // 0x003c  <
  10,18,36,16,4,0,0,192,0,192,3,0,3,0,12,0,12,0,48,0,48,0,192,0,192,0,48,0,48,0,12,0,12,0,3,0,3,0,0,192,0,192,
  // 0x003d  =
  12,10,20,16,2,4,255,240,255,240,0,0,0,0,0,0,0,0,0,0,0,0,255,240,255,240,
  // 0x003e  >
  10,18,36,16,2,0,192,0,192,0,48,0,48,0,12,0,12,0,3,0,3,0,0,192,0,192,3,0,3,0,12,0,12,0,48,0,48,0,192,0,192,0,
  // 0x003f  ?
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,0,48,0,48,0,192,0,192,3,0,3,0,3,0,3,0,0,0,0,0,3,0,3,0,3,0,3,0,
  // 0x0040  @
  12,20,40,16,2,0,15,192,15,192,48,48,48,48,195,48,195,48,204,240,204,240,204,48,204,48,204,48,204,48,204,48,204,48,195,240,195,240,48,0,48,0,15,240,15,240,
  // 0x0041  A
  12,20,40,16,2,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x0042  B
  12,20,40,16,2,0,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,255,192,255,192,
  // 0x0043  C
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0044  D
  12,20,40,16,2,0,255,0,255,0,192,192,192,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,192,192,192,255,0,255,0,
  // 0x0045  E
  12,20,40,16,2,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x0046  F
  12,20,40,16,2,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0047  G
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,192,0,192,0,192,0,192,0,195,240,195,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x0048  H
  12,20,40,16,2,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x0049  I
  10,20,40,16,4,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x004a  J
  14,20,40,16,2,0,15,252,15,252,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,192,192,192,192,192,192,192,192,63,0,63,0,
  // 0x004b  K
  12,20,40,16,2,0,192,48,192,48,192,192,192,192,195,0,195,0,204,0,204,0,240,0,240,0,240,0,240,0,204,0,204,0,195,0,195,0,192,192,192,192,192,48,192,48,
  // 0x004c  L
  12,20,40,16,2,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x004d  M
  12,20,40,16,2,0,192,48,192,48,192,48,192,48,240,240,240,240,240,240,240,240,207,48,207,48,207,48,207,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x004e  N
  12,20,40,16,2,0,192,48,192,48,240,48,240,48,240,48,240,48,204,48,204,48,204,48,204,48,195,48,195,48,195,48,195,48,192,240,192,240,192,240,192,240,192,48,192,48,
  // 0x004f  O
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0050  P
  12,20,40,16,2,0,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0051  Q
  14,22,44,16,2,254,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,207,48,207,48,240,240,240,240,63,192,63,192,0,60,0,60,
  // 0x0052  R
  12,20,40,16,2,0,255,192,255,192,192,48,192,48,192,48,192,48,192,48,192,48,255,192,255,192,195,0,195,0,192,192,192,192,192,192,192,192,192,48,192,48,192,48,192,48,
  // 0x0053  S
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,192,0,192,0,60,0,60,0,3,192,3,192,0,48,0,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0054  T
  14,20,40,16,2,0,255,252,255,252,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x0055  U
  12,20,40,16,2,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0056  V
  14,20,40,16,2,0,192,12,192,12,192,12,192,12,192,12,192,12,48,48,48,48,48,48,48,48,48,48,48,48,12,192,12,192,12,192,12,192,3,0,3,0,3,0,3,0,
  // 0x0057  W
  12,20,40,16,2,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,207,48,207,48,207,48,207,48,240,240,240,240,240,240,240,240,192,48,192,48,192,48,192,48,
  // 0x0058  X
  12,20,40,16,2,0,192,48,192,48,192,48,192,48,48,192,48,192,48,192,48,192,15,0,15,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,
  // 0x0059  Y
  14,20,40,16,2,0,192,12,192,12,192,12,192,12,48,48,48,48,48,48,48,48,12,192,12,192,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x005a  Z
  12,20,40,16,2,0,255,240,255,240,0,48,0,48,0,48,0,48,0,192,0,192,3,0,3,0,12,0,12,0,48,0,48,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x005b  [
  6,24,24,16,8,254,252,252,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,252,252,
  // 0x005c "\"
  12,20,40,16,2,0,192,0,192,0,192,0,192,0,48,0,48,0,12,0,12,0,12,0,12,0,3,0,3,0,3,0,3,0,0,192,0,192,0,48,0,48,0,48,0,48,
  // 0x005d  ]
  6,24,24,16,2,254,252,252,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,252,252,
  // 0x005e  ^
  12,6,12,16,2,18,15,0,15,0,48,192,48,192,192,48,192,48,
  // 0x005f  _
  14,2,4,16,2,254,255,252,255,252,
  // 0x0060  `
  6,6,6,16,4,20,192,192,48,48,12,12,
  // 0x0061  a
  12,16,32,16,2,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x0062  b
  12,22,44,16,2,0,192,0,192,0,192,0,192,0,192,0,192,0,207,192,207,192,240,48,240,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,240,48,240,48,207,192,207,192,
  // 0x0063  c
  12,16,32,16,2,0,63,192,63,192,192,48,192,48,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x0064  d
  12,22,44,16,2,0,0,48,0,48,0,48,0,48,0,48,0,48,63,48,63,48,192,240,192,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x0065  e
  12,16,32,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x0066  f
  10,22,44,16,2,0,3,192,3,192,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,
  // 0x0067  g
  12,22,44,16,2,252,0,48,0,48,63,48,63,48,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,48,0,48,0,63,192,63,192,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0068  h
  12,22,44,16,2,0,192,0,192,0,192,0,192,0,192,0,192,0,207,192,207,192,240,48,240,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x0069  i
  10,22,44,16,4,0,12,0,12,0,12,0,12,0,0,0,0,0,60,0,60,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x006a  j
  10,26,52,16,2,252,0,192,0,192,0,192,0,192,0,0,0,0,3,192,3,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,195,0,195,0,60,0,60,0,
  // 0x006b  k
  12,22,44,16,2,0,192,0,192,0,192,0,192,0,192,0,192,0,192,192,192,192,195,0,195,0,204,0,204,0,240,0,240,0,204,0,204,0,195,0,195,0,192,192,192,192,192,48,192,48,
  // 0x006c  l
  10,22,44,16,4,0,60,0,60,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x006d  m
  14,16,32,16,2,0,252,240,252,240,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,
  // 0x006e  n
  12,16,32,16,2,0,207,192,207,192,240,48,240,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x006f  o
  12,16,32,16,2,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x0070  p
  12,20,40,16,2,252,207,192,207,192,240,48,240,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,240,48,240,48,207,192,207,192,192,0,192,0,192,0,192,0,
  // 0x0071  q
  12,20,40,16,2,252,63,48,63,48,192,240,192,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,0,48,0,48,0,48,0,48,
  // 0x0072  r
  12,16,32,16,2,0,207,192,207,192,240,48,240,48,192,48,192,48,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0073  s
  12,16,32,16,2,0,63,192,63,192,192,48,192,48,192,0,192,0,60,0,60,0,3,192,3,192,0,48,0,48,192,48,192,48,63,192,63,192,
  // 0x0074  t
  10,20,40,16,2,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,3,192,3,192,
  // 0x0075  u
  12,16,32,16,2,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x0076  v
  12,16,32,16,2,0,192,48,192,48,192,48,192,48,192,48,192,48,48,192,48,192,48,192,48,192,48,192,48,192,15,0,15,0,15,0,15,0,
  // 0x0077  w
  14,16,32,16,2,0,192,12,192,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,195,12,60,240,60,240,
  // 0x0078  x
  12,16,32,16,2,0,192,48,192,48,192,48,192,48,48,192,48,192,15,0,15,0,15,0,15,0,48,192,48,192,192,48,192,48,192,48,192,48,
  // 0x0079  y
  12,20,40,16,2,252,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,48,240,48,240,15,48,15,48,0,48,0,48,0,48,0,48,63,192,63,192,
  // 0x007a  z
  12,16,32,16,2,0,255,240,255,240,0,48,0,48,0,192,0,192,3,0,3,0,12,0,12,0,48,0,48,0,192,0,192,0,255,240,255,240,
  // 0x007b  {
  8,26,26,16,4,252,15,15,48,48,48,48,12,12,12,12,48,48,192,192,48,48,12,12,12,12,48,48,48,48,15,15,
  // 0x007c  |
  2,28,28,16,8,252,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x007d  }
  8,26,26,16,4,252,240,240,12,12,12,12,48,48,48,48,12,12,3,3,12,12,48,48,48,48,12,12,12,12,240,240,
  // 0x007e  ~
  14,6,12,16,2,16,60,12,60,12,195,12,195,12,192,240,192,240,
  // 0x007f - 0x009f  Control Characters
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00a0 " "
  0,0,0,16,0,0,
  // 0x00a1  ¡
  2,20,20,16,8,0,192,192,192,192,0,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x00a2  ¢
  14,20,40,16,2,0,3,0,3,0,3,0,3,0,63,240,63,240,195,12,195,12,195,0,195,0,195,0,195,0,195,12,195,12,63,240,63,240,3,0,3,0,3,0,3,0,
  // 0x00a3  £
  14,20,40,16,2,0,3,240,3,240,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,63,240,63,240,240,12,240,12,
  // 0x00a4  ¤
  12,16,32,16,2,2,192,48,192,48,63,192,63,192,48,192,48,192,192,48,192,48,192,48,192,48,48,192,48,192,63,192,63,192,192,48,192,48,
  // 0x00a5  ¥
  14,20,40,16,2,0,192,12,192,12,48,48,48,48,12,192,12,192,3,0,3,0,255,252,255,252,3,0,3,0,255,252,255,252,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x00a6  ¦
  2,20,20,16,8,0,192,192,192,192,192,192,192,192,0,0,0,0,192,192,192,192,192,192,192,192,
  // 0x00a7  §
  12,20,40,16,2,0,63,192,63,192,192,48,192,48,192,0,192,0,63,192,63,192,192,48,192,48,192,48,192,48,63,192,63,192,0,48,0,48,192,48,192,48,63,192,63,192,
  // 0x00a8  ¨
  8,4,4,16,4,24,195,195,195,195,
  // 0x00a9  ©
  16,20,40,16,0,0,15,240,15,240,48,12,48,12,195,195,195,195,204,51,204,51,204,3,204,3,204,3,204,3,204,51,204,51,195,195,195,195,48,12,48,12,15,240,15,240,
  // 0x00aa  ª
  10,14,28,16,4,10,63,0,63,0,0,192,0,192,63,192,63,192,192,192,192,192,63,192,63,192,0,0,0,0,255,192,255,192,
  // 0x00ab  «
  12,18,36,16,2,0,12,48,12,48,12,48,12,48,48,192,48,192,48,192,48,192,195,0,195,0,48,192,48,192,48,192,48,192,12,48,12,48,12,48,12,48,
  // 0x00ac  ¬
  12,8,16,16,2,0,255,240,255,240,0,48,0,48,0,48,0,48,0,48,0,48,
  // 0x00ad  ­
  32,32,128,32,0,252,204,204,204,204,204,204,204,204,0,0,0,3,0,0,0,3,192,0,0,0,192,0,0,0,15,204,60,15,15,204,60,15,240,12,51,48,240,12,51,48,15,15,240,195,15,15,240,195,192,204,48,192,192,204,48,192,63,12,48,195,63,12,48,195,192,0,0,0,192,0,0,0,0,0,0,3,0,0,0,3,192,0,0,0,192,0,0,0,0,15,240,3,0,15,240,3,192,0,0,0,192,0,0,0,0,0,0,3,0,0,0,3,192,0,0,0,192,0,0,0,51,51,51,51,51,51,51,51,
  // 0x00ae  ®
  16,20,40,16,0,0,15,240,15,240,48,12,48,12,207,195,207,195,204,51,204,51,204,51,204,51,207,195,207,195,204,195,204,195,204,51,204,51,48,12,48,12,15,240,15,240,
  // 0x00af  ¯
  12,2,4,16,2,22,255,240,255,240,
  // 0x00b0  °
  8,8,8,16,4,12,60,60,195,195,195,195,60,60,
  // 0x00b1  ±
  14,18,36,16,2,2,3,0,3,0,3,0,3,0,3,0,3,0,255,252,255,252,3,0,3,0,3,0,3,0,3,0,3,0,0,0,0,0,255,252,255,252,
  // 0x00b2  ²
  10,14,28,16,2,8,63,0,63,0,192,192,192,192,0,192,0,192,15,0,15,0,48,0,48,0,192,0,192,0,255,192,255,192,
  // 0x00b3  ³
  10,14,28,16,2,8,63,0,63,0,192,192,192,192,0,192,0,192,63,0,63,0,0,192,0,192,192,192,192,192,63,0,63,0,
  // 0x00b4  ´
  6,6,6,16,6,20,12,12,48,48,192,192,
  // 0x00b5  µ
  16,20,40,16,0,252,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,48,12,60,60,60,60,51,195,51,195,48,0,48,0,192,0,192,0,
  // 0x00b6  ¶
  14,22,44,16,2,254,63,252,63,252,255,48,255,48,255,48,255,48,255,48,255,48,63,48,63,48,3,48,3,48,3,48,3,48,3,48,3,48,3,48,3,48,3,48,3,48,3,48,3,48,
  // 0x00b7  ·
  4,4,4,16,6,8,240,240,240,240,
  // 0x00b8  ¸
  6,4,4,16,4,252,12,12,240,240,
  // 0x00b9  ¹
  10,14,28,16,2,8,12,0,12,0,60,0,60,0,204,0,204,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x00ba  º
  10,14,28,16,4,10,63,0,63,0,192,192,192,192,192,192,192,192,192,192,192,192,63,0,63,0,0,0,0,0,255,192,255,192,
  // 0x00bb  »
  12,18,36,16,2,0,195,0,195,0,195,0,195,0,48,192,48,192,48,192,48,192,12,48,12,48,48,192,48,192,48,192,48,192,195,0,195,0,195,0,195,0,
  // 0x00bc  ¼
  12,20,40,16,2,0,48,48,48,48,240,48,240,48,48,192,48,192,51,0,51,0,51,0,51,0,12,48,12,48,12,240,12,240,51,48,51,48,195,240,195,240,192,48,192,48,
  // 0x00bd  ½
  12,20,40,16,2,0,48,48,48,48,240,48,240,48,48,192,48,192,51,0,51,0,51,0,51,0,12,192,12,192,15,48,15,48,48,48,48,48,192,192,192,192,195,240,195,240,
  // 0x00be  ¾
  12,20,40,16,2,0,240,48,240,48,12,48,12,48,48,192,48,192,15,0,15,0,243,0,243,0,12,48,12,48,12,240,12,240,51,48,51,48,195,240,195,240,192,48,192,48,
  // 0x00bf  ¿
  12,20,40,16,2,0,12,0,12,0,12,0,12,0,0,0,0,0,12,0,12,0,12,0,12,0,48,0,48,0,192,0,192,0,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00c0  À
  12,28,56,16,2,0,60,0,60,0,3,192,3,192,0,0,0,0,0,0,0,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x00c1  Á
  12,28,56,16,2,0,3,192,3,192,60,0,60,0,0,0,0,0,0,0,0,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x00c2  Â
  12,28,56,16,2,0,15,0,15,0,48,192,48,192,0,0,0,0,0,0,0,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x00c3  Ã
  12,28,56,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,0,0,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x00c4  Ä
  12,28,56,16,2,0,48,192,48,192,48,192,48,192,0,0,0,0,0,0,0,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x00c5  Å
  12,28,56,16,2,0,15,0,15,0,48,192,48,192,15,0,15,0,0,0,0,0,15,0,15,0,48,192,48,192,48,192,48,192,192,48,192,48,192,48,192,48,255,240,255,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x00c6  Æ
  14,20,40,16,2,0,15,252,15,252,51,0,51,0,195,0,195,0,195,0,195,0,255,252,255,252,195,0,195,0,195,0,195,0,195,0,195,0,195,0,195,0,195,252,195,252,
  // 0x00c7  Ç
  12,24,48,16,2,252,63,192,63,192,192,48,192,48,192,48,192,48,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,48,192,48,192,48,192,48,63,192,63,192,3,0,3,0,60,0,60,0,
  // 0x00c8  È
  12,28,56,16,2,0,60,0,60,0,3,192,3,192,0,0,0,0,0,0,0,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x00c9  É
  12,28,56,16,2,0,3,192,3,192,60,0,60,0,0,0,0,0,0,0,0,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x00ca  Ê
  12,28,56,16,2,0,15,0,15,0,48,192,48,192,0,0,0,0,0,0,0,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x00cb  Ë
  12,28,56,16,2,0,48,192,48,192,48,192,48,192,0,0,0,0,0,0,0,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x00cc  Ì
  10,28,56,16,4,0,60,0,60,0,3,192,3,192,0,0,0,0,0,0,0,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x00cd  Í
  10,28,56,16,4,0,15,0,15,0,240,0,240,0,0,0,0,0,0,0,0,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x00ce  Î
  10,28,56,16,4,0,60,0,60,0,195,0,195,0,0,0,0,0,0,0,0,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x00cf  Ï
  10,28,56,16,4,0,195,0,195,0,195,0,195,0,0,0,0,0,0,0,0,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x00d0  Ð
  14,20,40,16,0,0,63,192,63,192,48,48,48,48,48,12,48,12,48,12,48,12,255,12,255,12,48,12,48,12,48,12,48,12,48,12,48,12,48,48,48,48,63,192,63,192,
  // 0x00d1  Ñ
  12,28,56,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,0,0,0,192,48,192,48,240,48,240,48,240,48,240,48,204,48,204,48,204,48,204,48,195,48,195,48,195,48,195,48,192,240,192,240,192,240,192,240,192,48,192,48,
  // 0x00d2  Ò
  12,28,56,16,2,0,60,0,60,0,3,192,3,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00d3  Ó
  12,28,56,16,2,0,3,192,3,192,60,0,60,0,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00d4  Ô
  12,28,56,16,2,0,15,0,15,0,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00d5  Õ
  12,28,56,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00d6  Ö
  12,28,56,16,2,0,48,192,48,192,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00d7  ×
  12,10,20,16,2,4,192,48,192,48,48,192,48,192,15,0,15,0,48,192,48,192,192,48,192,48,
  // 0x00d8  Ø
  12,24,48,16,2,254,0,48,0,48,63,48,63,48,192,192,192,192,192,240,192,240,195,48,195,48,195,48,195,48,204,48,204,48,204,48,204,48,240,48,240,48,48,48,48,48,207,192,207,192,192,0,192,0,
  // 0x00d9  Ù
  12,28,56,16,2,0,60,0,60,0,3,192,3,192,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00da  Ú
  12,28,56,16,2,0,3,192,3,192,60,0,60,0,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00db  Û
  12,28,56,16,2,0,15,0,15,0,48,192,48,192,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00dc  Ü
  12,28,56,16,2,0,48,192,48,192,48,192,48,192,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00dd  Ý
  14,28,56,16,2,0,3,192,3,192,60,0,60,0,0,0,0,0,0,0,0,0,192,12,192,12,192,12,192,12,48,48,48,48,48,48,48,48,12,192,12,192,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x00de  Þ
  12,22,44,16,2,0,192,0,192,0,192,0,192,0,255,0,255,0,192,192,192,192,192,48,192,48,192,48,192,48,192,192,192,192,255,0,255,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x00df  ß
  12,20,40,16,2,0,63,0,63,0,192,192,192,192,192,192,192,192,195,0,195,0,207,0,207,0,192,192,192,192,192,48,192,48,192,48,192,48,204,48,204,48,195,192,195,192,
  // 0x00e0  à
  12,24,48,16,2,0,60,0,60,0,3,192,3,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x00e1  á
  12,24,48,16,2,0,3,192,3,192,60,0,60,0,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x00e2  â
  12,24,48,16,2,0,15,0,15,0,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x00e3  ã
  12,24,48,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x00e4  ä
  12,24,48,16,2,0,48,192,48,192,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x00e5  å
  12,26,52,16,2,0,15,0,15,0,48,192,48,192,15,0,15,0,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x00e6  æ
  14,16,32,16,2,0,63,240,63,240,195,12,195,12,3,12,3,12,63,252,63,252,195,0,195,0,195,0,195,0,195,12,195,12,63,240,63,240,
  // 0x00e7  ç
  12,20,40,16,2,252,63,192,63,192,192,48,192,48,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,3,0,3,0,60,0,60,0,
  // 0x00e8  è
  12,24,48,16,2,0,60,0,60,0,3,192,3,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x00e9  é
  12,24,48,16,2,0,3,192,3,192,60,0,60,0,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x00ea  ê
  12,24,48,16,2,0,15,0,15,0,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x00eb  ë
  12,24,48,16,2,0,48,192,48,192,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,255,240,255,240,192,0,192,0,192,0,192,0,192,48,192,48,63,192,63,192,
  // 0x00ec  ì
  10,24,48,16,4,0,240,0,240,0,15,0,15,0,0,0,0,0,0,0,0,0,60,0,60,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x00ed  í
  10,24,48,16,4,0,15,0,15,0,240,0,240,0,0,0,0,0,0,0,0,0,60,0,60,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x00ee  î
  10,24,48,16,4,0,60,0,60,0,195,0,195,0,0,0,0,0,0,0,0,0,60,0,60,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x00ef  ï
  10,24,48,16,4,0,195,0,195,0,195,0,195,0,0,0,0,0,0,0,0,0,60,0,60,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,255,192,255,192,
  // 0x00f0  ð
  12,24,48,16,2,0,60,48,60,48,3,192,3,192,12,192,12,192,48,48,48,48,0,48,0,48,63,240,63,240,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00f1  ñ
  12,24,48,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,0,0,0,207,192,207,192,240,48,240,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,
  // 0x00f2  ò
  12,24,48,16,2,0,60,0,60,0,3,192,3,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00f3  ó
  12,24,48,16,2,0,3,192,3,192,60,0,60,0,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00f4  ô
  12,24,48,16,2,0,15,0,15,0,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00f5  õ
  12,24,48,16,2,0,60,48,60,48,195,192,195,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00f6  ö
  12,24,48,16,2,0,48,192,48,192,48,192,48,192,0,0,0,0,0,0,0,0,63,192,63,192,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,63,192,63,192,
  // 0x00f7  ÷
  12,14,28,16,2,2,15,0,15,0,0,0,0,0,0,0,0,0,255,240,255,240,0,0,0,0,0,0,0,0,15,0,15,0,
  // 0x00f8  ø
  12,20,40,16,2,254,0,48,0,48,63,192,63,192,192,240,192,240,195,48,195,48,195,48,195,48,204,48,204,48,204,48,204,48,240,48,240,48,63,192,63,192,192,0,192,0,
  // 0x00f9  ù
  12,24,48,16,2,0,60,0,60,0,3,192,3,192,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x00fa  ú
  12,24,48,16,2,0,3,192,3,192,60,0,60,0,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x00fb  û
  12,24,48,16,2,0,15,0,15,0,48,192,48,192,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x00fc  ü
  12,24,48,16,2,0,48,192,48,192,48,192,48,192,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,240,192,240,63,48,63,48,
  // 0x00fd  ý
  12,28,56,16,2,252,3,192,3,192,60,0,60,0,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,48,240,48,240,15,48,15,48,0,48,0,48,0,48,0,48,63,192,63,192,
  // 0x00fe  þ
  12,26,52,16,2,252,192,0,192,0,192,0,192,0,192,0,192,0,207,192,207,192,240,48,240,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,240,48,240,48,207,192,207,192,192,0,192,0,192,0,192,0,
  // 0x00ff  ÿ
  12,28,56,16,2,252,48,192,48,192,48,192,48,192,0,0,0,0,0,0,0,0,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,192,48,48,240,48,240,15,48,15,48,0,48,0,48,0,48,0,48,63,192,63,192,
};

#endif // HAS_GRAPHICAL_TFT
