/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Traditional Chinese 40pt, capital 'A' height: 29px, width: 100%, range: 0x22bf-0xff1a, glyphs: 307
extern const uint8_t NotoSans_Medium_Traditional_Chinese_29[34391] = {
  162,29,191,34,26,255,38,246, // unifont_t
  // 0x22bf  ⊿
  191,34,31,32,0,40,4,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,184,0,0,0,0,0,0,2,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,47,248,0,0,0,0,0,0,191,248,0,0,0,0,0,2,255,248,0,0,0,0,0,11,255,248,0,0,0,0,0,47,242,248,0,0,0,0,0,191,194,248,0,0,0,0,2,255,2,248,0,0,0,0,11,252,2,248,0,0,0,0,47,240,2,248,0,0,0,0,191,192,2,248,0,0,0,1,255,0,2,248,0,0,0,7,252,0,2,248,0,0,0,31,240,0,2,248,0,0,0,127,192,0,2,248,0,0,1,255,64,0,2,248,0,0,7,253,0,0,2,248,0,0,31,244,0,0,2,248,0,0,127,208,0,0,2,248,0,1,255,64,0,0,2,248,0,7,253,0,0,0,2,248,0,31,244,0,0,0,2,248,0,127,208,0,0,0,2,248,1,255,64,0,0,0,2,248,3,254,85,85,85,85,87,248,15,255,255,255,255,255,255,248,63,255,255,255,255,255,255,248,255,255,255,255,255,255,255,248,
  // 0x4e00  一
  0,78,37,4,40,40,2,13,255,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,255,64,
  // 0x4e09  三
  9,78,34,31,23,40,3,255,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,128,0,0,127,255,255,255,255,255,192,0,0,127,255,255,255,255,255,192,0,0,127,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x4e0a  上
  10,78,36,35,59,40,2,254,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,255,255,255,255,192,0,0,0,7,255,255,255,255,192,0,0,0,7,255,255,255,255,192,0,0,0,7,254,170,170,170,128,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,254,
  // 0x4e0b  下
  11,78,36,35,59,40,2,252,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,254,128,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,3,255,255,64,0,0,0,0,0,3,255,255,240,0,0,0,0,0,3,253,255,254,0,0,0,0,0,3,252,47,255,208,0,0,0,0,3,252,3,255,252,0,0,0,0,3,252,0,127,255,64,0,0,0,3,252,0,11,255,208,0,0,0,3,252,0,1,255,192,0,0,0,3,252,0,0,63,0,0,0,0,3,252,0,0,9,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,2,168,0,0,0,0,
  // 0x4e0d  不
  13,78,36,35,59,40,2,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,0,0,47,240,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,2,255,64,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,63,255,10,0,0,0,0,0,0,255,255,47,192,0,0,0,0,3,255,255,191,244,0,0,0,0,15,254,255,47,254,0,0,0,0,63,248,255,7,255,192,0,0,1,255,240,255,0,255,244,0,0,11,255,192,255,0,47,253,0,0,47,254,0,255,0,11,255,128,1,255,248,0,255,0,1,255,240,15,255,208,0,255,0,0,127,252,191,255,0,0,255,0,0,15,255,191,248,0,0,255,0,0,3,255,63,208,0,0,255,0,0,0,248,14,0,0,0,255,0,0,0,32,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,
  // 0x4e26  並
  38,78,36,36,68,40,2,254,0,0,32,0,0,0,9,0,0,0,3,248,0,0,0,31,240,0,0,3,252,0,0,0,63,224,0,0,1,255,0,0,0,127,192,0,0,0,255,64,0,0,255,128,0,0,0,127,192,0,1,255,0,0,0,0,63,208,0,3,253,0,0,0,0,31,128,0,7,248,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,42,170,170,255,170,255,170,170,168,0,0,0,254,0,191,0,0,0,0,0,0,254,0,191,0,0,0,0,0,0,254,0,191,0,0,0,0,100,0,254,0,191,0,46,64,3,252,0,254,0,191,0,63,192,2,252,0,254,0,191,0,63,192,0,254,0,254,0,191,0,127,128,0,191,0,254,0,191,0,191,0,0,127,64,254,0,191,0,255,0,0,63,128,254,0,191,1,254,0,0,63,192,254,0,191,2,252,0,0,47,192,254,0,191,3,252,0,0,31,208,254,0,191,7,244,0,0,15,224,254,0,191,11,240,0,0,15,240,254,0,191,15,224,0,0,11,240,254,0,191,31,208,0,0,6,64,254,0,191,1,128,0,0,0,0,254,0,191,0,0,0,0,0,0,254,0,191,0,0,0,0,0,0,254,0,191,0,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,
  // 0x4e2d  中
  45,78,32,38,48,40,4,252,0,0,0,15,224,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,170,170,170,175,250,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,175,250,170,170,255,254,0,0,15,240,0,0,255,254,0,0,15,240,0,0,191,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,224,0,0,0,
  // 0x4e3b  主
  59,78,36,37,77,40,2,253,0,0,0,2,0,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,0,47,248,0,0,0,0,0,0,0,11,224,0,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,10,170,170,170,255,170,170,170,160,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,170,170,170,255,170,170,170,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,106,170,170,170,170,170,170,170,170,
  // 0x4e4b  之
  75,78,37,38,124,40,1,252,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,3,255,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,255,248,0,2,170,170,170,170,170,170,191,240,0,0,0,0,0,0,0,0,127,208,0,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,0,11,253,0,0,0,0,0,0,0,0,47,244,0,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,1,255,128,0,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,0,63,240,0,0,0,0,2,224,0,0,255,192,0,0,0,0,3,252,0,7,255,0,0,0,0,0,11,248,0,31,252,0,0,0,0,0,15,244,0,127,240,0,0,0,0,0,31,248,2,255,192,0,0,0,0,0,63,252,15,255,0,0,0,0,0,0,127,255,127,248,0,0,0,0,0,0,255,255,255,224,0,0,0,0,0,1,255,63,255,64,0,0,0,0,0,3,253,15,255,64,0,0,0,0,0,11,252,3,255,249,0,0,0,0,0,31,244,0,255,255,255,170,170,170,128,63,240,0,31,255,255,255,255,255,192,127,192,0,1,191,255,255,255,255,128,15,128,0,0,5,175,255,255,255,0,1,0,0,0,0,0,0,0,0,0,
  // 0x4ea4  交
  164,78,36,38,86,40,2,252,0,0,0,0,170,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,106,170,170,170,255,170,170,170,169,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,15,64,0,0,248,0,0,0,0,63,240,0,7,255,0,0,0,0,255,208,0,3,255,208,0,0,3,255,64,0,0,191,248,0,0,15,254,0,0,0,31,254,0,0,127,248,0,0,0,3,255,192,2,255,224,0,0,0,0,255,240,31,255,66,192,0,3,224,63,252,191,253,31,224,0,11,252,11,254,47,240,15,240,0,15,244,3,248,11,128,11,248,0,31,240,0,208,0,0,3,252,0,63,208,0,0,0,0,2,255,0,191,192,0,0,0,0,0,255,130,255,64,0,0,0,0,0,127,215,254,0,0,0,0,0,0,47,255,252,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,11,255,224,0,0,0,0,0,0,127,255,253,0,0,0,0,0,7,255,255,255,208,0,0,0,0,127,255,130,255,253,0,0,0,27,255,253,0,127,255,228,0,6,255,255,224,0,11,255,255,144,255,255,254,0,0,0,255,255,255,191,255,208,0,0,0,11,255,253,63,248,0,0,0,0,0,111,252,30,0,0,0,0,0,0,0,96,
  // 0x4eae  亮
  174,78,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,250,170,170,170,175,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,10,170,170,170,170,170,160,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,0,0,0,0,0,0,0,252,63,0,1,80,0,0,0,0,252,63,0,7,244,0,191,64,0,252,63,0,11,244,0,191,64,0,252,63,0,11,240,0,191,64,0,252,0,0,15,240,0,191,64,0,0,0,0,31,240,0,191,64,0,0,0,0,47,208,0,191,64,0,0,0,0,127,192,0,191,64,0,184,0,1,255,128,0,191,64,0,191,0,15,255,0,0,191,64,0,254,2,255,252,0,0,191,128,1,254,255,255,224,0,0,127,255,255,253,191,255,64,0,0,63,255,255,252,63,224,0,0,0,31,255,255,240,20,0,0,0,0,0,21,84,0,
  // 0x4ee4  令
  228,78,37,38,124,40,2,252,0,0,0,1,254,0,0,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,0,15,255,208,0,0,0,0,0,0,0,47,255,244,0,0,0,0,0,0,0,191,219,252,0,0,0,0,0,0,2,255,131,255,64,0,0,0,0,0,11,254,0,255,208,0,0,0,0,0,47,252,0,63,244,0,0,0,0,0,191,240,0,15,253,0,0,0,0,2,255,192,0,3,255,128,0,0,0,15,254,0,0,0,191,244,0,0,0,127,248,0,0,0,47,254,0,0,2,255,255,255,255,255,255,255,208,0,31,255,95,255,255,255,245,255,248,0,255,252,31,255,255,255,244,63,255,64,255,224,5,85,85,85,80,11,255,0,127,64,0,0,0,0,0,1,253,0,40,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,255,255,254,0,0,2,255,255,255,255,255,255,254,0,0,2,255,255,255,255,255,255,254,0,0,1,85,85,127,213,85,85,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,0,0,254,0,0,0,0,0,47,192,10,170,254,0,0,0,0,0,47,192,11,255,253,0,0,0,0,0,47,192,3,255,252,0,0,0,0,0,47,192,3,255,144,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,
  // 0x4ef6  件
  246,78,37,38,124,40,1,252,0,0,20,0,0,1,80,0,0,0,0,0,63,128,0,3,248,0,0,0,0,0,127,64,144,3,248,0,0,0,0,0,255,0,254,3,248,0,0,0,0,1,254,1,253,3,248,0,0,0,0,2,253,2,252,3,248,0,0,0,0,7,252,3,252,3,248,0,0,0,0,15,244,3,248,3,248,0,0,0,0,31,240,7,254,171,254,170,168,0,0,63,208,11,255,255,255,255,253,0,0,191,192,15,255,255,255,255,253,0,0,255,192,31,255,255,255,255,253,0,3,255,192,63,192,3,248,0,0,0,11,255,192,127,128,3,248,0,0,0,31,255,192,255,0,3,248,0,0,0,63,255,193,254,0,3,248,0,0,0,191,239,192,188,0,3,248,0,0,0,63,111,192,24,0,3,248,0,0,0,30,47,192,0,0,3,248,0,0,0,12,47,192,0,0,3,248,0,0,0,0,47,192,170,170,171,254,170,170,128,0,47,192,255,255,255,255,255,255,192,0,47,192,255,255,255,255,255,255,192,0,47,192,255,255,255,255,255,255,192,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,31,128,0,0,3,244,0,0,0,
  // 0x4efd  份
  253,78,38,38,124,40,1,252,0,0,36,0,0,0,0,0,0,0,0,0,127,128,3,255,255,244,0,0,0,0,191,0,3,255,255,248,0,0,0,0,254,0,3,255,255,252,0,0,0,2,253,0,65,85,87,252,0,0,0,3,252,0,254,0,1,253,0,0,0,11,244,1,254,0,0,254,0,0,0,15,240,2,252,0,0,255,0,0,0,47,208,3,248,0,0,127,128,0,0,127,192,11,244,0,0,63,192,0,0,255,128,15,240,0,0,47,224,0,2,255,128,31,208,0,0,15,240,0,3,255,128,63,192,0,0,11,252,0,15,255,128,191,64,0,0,3,254,0,63,255,129,254,0,0,0,2,255,64,191,255,131,252,0,0,0,0,255,224,255,191,143,249,85,85,85,85,191,208,191,63,143,235,255,255,255,255,223,64,60,63,131,203,255,255,255,255,198,0,20,63,128,11,255,255,255,255,192,0,0,63,128,0,2,252,0,63,192,0,0,63,128,0,3,252,0,63,192,0,0,63,128,0,3,248,0,63,192,0,0,63,128,0,3,244,0,63,128,0,0,63,128,0,7,244,0,63,128,0,0,63,128,0,11,240,0,63,128,0,0,63,128,0,15,240,0,63,128,0,0,63,128,0,15,224,0,63,128,0,0,63,128,0,47,192,0,63,128,0,0,63,128,0,63,192,0,127,64,0,0,63,128,0,191,64,0,127,64,0,0,63,128,1,255,0,0,191,64,0,0,63,128,7,252,0,0,191,0,0,0,63,128,47,244,0,0,255,0,0,0,63,128,255,224,3,255,255,0,0,0,63,129,255,128,1,255,253,0,0,0,63,128,125,0,0,255,248,0,0,0,47,128,32,0,0,106,64,0,0,
  // 0x4f11  休
  17,79,38,38,124,40,1,252,0,0,4,0,0,0,0,0,0,0,0,0,15,224,0,11,240,0,0,0,0,0,47,224,0,11,240,0,0,0,0,0,63,192,0,11,240,0,0,0,0,0,127,192,0,11,240,0,0,0,0,0,255,64,0,11,240,0,0,0,0,1,255,0,0,11,240,0,0,0,0,3,253,0,0,11,240,0,0,0,0,11,252,0,0,11,240,0,0,0,0,31,244,0,0,11,240,0,0,0,0,63,241,170,170,175,250,170,170,128,0,191,241,255,255,255,255,255,255,192,1,255,241,255,255,255,255,255,255,192,7,255,241,255,255,255,255,255,255,192,31,255,240,0,0,191,255,0,0,0,127,255,240,0,0,255,255,128,0,0,255,239,240,0,2,255,255,192,0,0,127,143,240,0,3,255,255,208,0,0,63,15,240,0,7,255,251,240,0,0,28,15,240,0,15,255,247,244,0,0,0,15,240,0,47,219,243,252,0,0,0,15,240,0,63,203,241,254,0,0,0,15,240,0,191,75,240,255,0,0,0,15,240,1,255,11,240,127,192,0,0,15,240,3,253,11,240,63,224,0,0,15,240,15,248,11,240,15,244,0,0,15,240,47,240,11,240,11,252,0,0,15,240,127,208,11,240,3,255,0,0,15,242,255,128,11,240,1,255,192,0,15,251,255,0,11,240,0,191,240,0,15,251,252,0,11,240,0,47,208,0,15,242,240,0,11,240,0,15,64,0,15,240,128,0,11,240,0,1,0,0,15,240,0,0,11,240,0,0,0,0,15,240,0,0,11,240,0,0,0,0,15,240,0,0,11,240,0,0,0,0,15,240,0,0,11,240,0,0,0,0,10,160,0,0,11,240,0,0,0,
  // 0x4f4d  位
  77,79,38,38,124,40,1,252,0,0,4,0,0,1,80,0,0,0,0,0,47,192,0,11,240,0,0,0,0,0,63,192,0,11,240,0,0,0,0,0,191,64,0,11,240,0,0,0,0,0,255,0,0,11,240,0,0,0,0,2,254,0,0,11,240,0,0,0,0,3,252,0,0,11,240,0,0,0,0,11,244,0,0,11,240,0,0,0,0,31,240,191,255,255,255,255,255,128,0,63,208,191,255,255,255,255,255,128,0,191,208,191,255,255,255,255,255,128,1,255,208,106,170,170,170,170,170,64,3,255,208,0,0,0,0,0,0,0,15,255,208,0,0,0,0,0,0,0,63,255,208,0,188,0,0,47,208,0,191,239,208,1,253,0,0,63,192,0,255,207,208,0,253,0,0,63,192,0,127,15,208,0,254,0,0,63,128,0,60,15,208,0,191,0,0,127,64,0,20,15,208,0,127,0,0,191,64,0,0,15,208,0,63,64,0,255,0,0,0,15,208,0,63,128,0,255,0,0,0,15,208,0,63,192,1,254,0,0,0,15,208,0,47,192,2,253,0,0,0,15,208,0,47,192,3,252,0,0,0,15,208,0,31,208,3,248,0,0,0,15,208,0,31,208,7,244,0,0,0,15,208,0,15,224,11,240,0,0,0,15,208,0,15,224,15,240,0,0,0,15,208,0,15,240,15,224,0,0,0,15,208,0,15,144,31,208,0,0,0,15,208,0,0,0,47,192,0,0,0,15,208,170,170,170,191,234,170,144,0,15,209,255,255,255,255,255,255,224,0,15,209,255,255,255,255,255,255,224,0,15,209,255,255,255,255,255,255,224,0,15,208,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,
  // 0x4f4e  低
  78,79,38,38,124,40,1,252,0,0,36,0,0,0,0,0,0,0,0,0,127,64,0,0,0,0,64,0,0,0,191,0,0,0,0,111,240,0,0,0,255,0,0,1,175,255,248,0,0,2,253,25,26,255,255,255,248,0,0,3,252,31,255,255,255,249,0,0,0,11,244,31,255,255,255,0,0,0,0,15,240,31,250,80,191,0,0,0,0,47,208,31,192,0,191,0,0,0,0,127,192,31,192,0,191,0,0,0,0,255,128,31,192,0,127,64,0,0,2,255,128,31,192,0,127,64,0,0,7,255,128,31,192,0,127,64,0,0,15,255,128,31,192,0,127,64,0,0,63,255,128,31,255,255,255,255,255,208,255,255,128,31,255,255,255,255,255,208,255,127,128,31,255,255,255,255,255,208,126,63,128,31,229,85,127,213,85,64,60,63,128,31,192,0,47,192,0,0,16,63,128,31,192,0,47,192,0,0,0,63,128,31,192,0,31,192,0,0,0,63,128,31,192,0,31,208,0,0,0,63,128,31,192,0,15,224,0,0,0,63,128,31,192,0,15,240,0,0,0,63,128,31,192,0,11,240,0,0,0,63,128,31,192,0,71,244,0,0,0,63,128,31,209,175,227,248,0,0,0,63,128,47,255,255,227,252,2,0,0,63,131,255,255,255,226,252,3,224,0,63,130,255,255,250,65,254,3,240,0,63,130,255,228,0,0,255,3,240,0,63,128,144,0,0,0,127,135,224,0,63,128,0,0,0,0,63,255,224,0,63,128,21,85,85,85,31,255,192,0,63,128,255,255,255,255,135,255,128,0,63,128,255,255,255,255,129,190,0,0,63,128,255,255,255,255,128,0,0,0,63,128,0,0,0,0,0,0,0,
  // 0x4f5c  作
  92,79,38,38,124,40,1,252,0,0,4,0,0,0,0,0,0,0,0,0,47,192,1,248,0,0,0,0,0,0,63,192,3,252,0,0,0,0,0,0,127,128,3,248,0,0,0,0,0,0,255,64,11,244,0,0,0,0,0,0,255,0,15,240,0,0,0,0,0,3,253,0,31,224,0,0,0,0,0,7,252,0,63,255,255,255,255,208,0,15,244,0,127,255,255,255,255,208,0,31,240,0,255,255,255,255,255,208,0,63,224,2,254,175,250,170,170,128,0,191,224,3,252,15,224,0,0,0,1,255,224,15,244,15,224,0,0,0,3,255,224,31,240,15,224,0,0,0,15,255,224,127,208,15,224,0,0,0,63,255,224,255,128,15,224,0,0,0,127,255,226,255,0,15,255,255,255,64,63,207,224,125,0,15,255,255,255,64,31,15,224,20,0,15,255,255,255,64,12,15,224,0,0,15,245,85,85,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,245,85,85,64,0,15,224,0,0,15,255,255,255,192,0,15,224,0,0,15,255,255,255,192,0,15,224,0,0,15,255,255,255,192,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,15,224,0,0,15,224,0,0,0,0,10,144,0,0,10,144,0,0,0,
  // 0x4f9b  供
  155,79,38,38,124,40,1,252,0,0,20,0,21,64,0,84,0,0,0,0,63,128,47,192,0,253,0,0,0,0,191,64,47,192,0,253,0,0,0,0,255,0,47,192,0,253,0,0,0,1,254,0,47,192,0,253,0,0,0,3,252,0,47,192,0,253,0,0,0,7,248,0,47,192,0,253,0,0,0,15,240,0,47,192,0,253,0,0,0,47,224,42,191,234,170,255,170,128,0,63,192,127,255,255,255,255,255,192,0,255,192,127,255,255,255,255,255,192,1,255,192,127,255,255,255,255,255,192,3,255,192,0,47,192,0,253,0,0,15,255,192,0,47,192,0,253,0,0,63,255,192,0,47,192,0,253,0,0,191,255,192,0,47,192,0,253,0,0,191,175,192,0,47,192,0,253,0,0,63,47,192,0,47,192,0,253,0,0,44,47,192,0,47,192,0,253,0,0,4,47,192,0,47,192,0,253,0,0,0,47,192,0,47,192,0,253,0,0,0,47,193,170,191,234,170,255,170,128,0,47,193,255,255,255,255,255,255,208,0,47,193,255,255,255,255,255,255,208,0,47,193,255,255,255,255,255,255,208,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,14,64,0,36,0,0,0,47,192,0,47,224,1,253,0,0,0,47,192,0,127,192,1,255,64,0,0,47,192,0,255,64,0,127,192,0,0,47,192,3,254,0,0,47,240,0,0,47,192,15,252,0,0,11,248,0,0,47,192,63,240,0,0,3,254,0,0,47,192,255,192,0,0,1,255,0,0,47,194,255,64,0,0,0,191,192,0,47,192,125,0,0,0,0,62,0,0,47,128,4,0,0,0,0,20,0,
  // 0x4fdd  保
  221,79,38,38,124,40,1,252,0,0,20,0,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,63,203,255,255,255,255,252,0,0,0,191,75,255,255,255,255,252,0,0,0,255,11,255,255,255,255,252,0,0,2,253,11,245,85,85,87,252,0,0,3,252,11,240,0,0,2,252,0,0,11,244,11,240,0,0,2,252,0,0,15,240,11,240,0,0,2,252,0,0,63,208,11,240,0,0,2,252,0,0,191,208,11,240,0,0,2,252,0,1,255,208,11,240,0,0,2,252,0,3,255,208,11,255,255,255,255,252,0,15,255,208,11,255,255,255,255,252,0,47,255,208,11,255,255,255,255,252,0,191,255,208,1,85,91,249,85,84,0,191,207,208,0,0,7,244,0,0,0,63,15,208,0,0,7,244,0,0,0,45,15,208,0,0,7,244,0,0,0,4,15,208,0,0,7,244,0,0,0,0,15,209,255,255,255,255,255,255,192,0,15,209,255,255,255,255,255,255,192,0,15,209,255,255,255,255,255,255,192,0,15,208,85,85,255,255,149,85,64,0,15,208,0,0,255,255,192,0,0,0,15,208,0,3,255,255,240,0,0,0,15,208,0,11,255,251,248,0,0,0,15,208,0,47,231,246,253,0,0,0,15,208,0,191,199,244,255,64,0,0,15,208,2,255,7,244,127,208,0,0,15,208,15,253,7,244,31,244,0,0,15,208,127,244,7,244,11,254,0,0,15,210,255,208,7,244,2,255,208,0,15,215,255,64,7,244,0,191,240,0,15,209,252,0,7,244,0,47,192,0,15,208,160,0,7,244,0,7,0,0,15,208,0,0,7,244,0,0,0,0,10,144,0,0,7,244,0,0,0,
  // 0x4fe1  信
  225,79,38,38,124,40,1,252,0,0,4,0,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,63,193,255,255,255,255,240,0,0,0,191,65,255,255,255,255,240,0,0,0,255,1,255,255,255,255,240,0,0,2,254,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,0,31,240,255,255,255,255,255,255,208,0,63,224,255,255,255,255,255,255,208,0,191,208,255,255,255,255,255,255,208,1,255,208,0,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,0,15,255,208,3,255,255,255,255,244,0,63,255,208,3,255,255,255,255,244,0,255,223,208,3,255,255,255,255,244,0,191,79,208,0,0,0,0,0,0,0,62,15,208,0,0,0,0,0,0,0,44,15,208,0,0,0,0,0,0,0,0,15,208,3,255,255,255,255,244,0,0,15,208,3,255,255,255,255,244,0,0,15,208,3,255,255,255,255,244,0,0,15,208,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,240,0,0,3,252,0,0,15,208,7,240,0,0,3,252,0,0,15,208,7,240,0,0,3,252,0,0,15,208,7,240,0,0,3,252,0,0,15,208,7,240,0,0,3,252,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,255,255,255,255,252,0,0,15,208,7,240,0,0,3,252,0,0,10,128,7,240,0,0,2,168,0,
  // 0x500b  個
  11,80,36,38,86,40,1,252,0,0,64,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,3,252,127,255,255,255,255,255,0,3,248,127,255,255,255,255,255,0,11,240,127,255,255,255,255,255,0,15,240,127,0,0,0,0,127,0,47,208,127,0,3,240,0,127,0,63,192,127,0,3,240,0,127,0,191,128,127,0,3,240,0,127,1,255,128,127,0,3,240,0,127,3,255,128,127,26,175,250,169,127,7,255,128,127,31,255,255,253,127,15,255,128,127,31,255,255,253,127,63,255,128,127,0,3,240,0,127,191,255,128,127,0,3,240,0,127,255,127,128,127,0,3,240,0,127,190,63,128,127,0,3,240,0,127,60,63,128,127,2,171,250,160,127,32,63,128,127,3,255,255,240,127,0,63,128,127,3,255,255,240,127,0,63,128,127,3,224,3,240,127,0,63,128,127,3,224,3,240,127,0,63,128,127,3,224,3,240,127,0,63,128,127,3,224,3,240,127,0,63,128,127,3,224,3,240,127,0,63,128,127,3,250,171,240,127,0,63,128,127,3,255,255,240,127,0,63,128,127,3,255,255,240,127,0,63,128,127,0,0,0,0,127,0,63,128,127,0,0,0,0,127,0,63,128,127,0,0,0,0,127,0,63,128,127,255,255,255,255,255,0,63,128,127,255,255,255,255,255,0,63,128,127,255,255,255,255,255,0,63,128,127,85,85,85,85,191,0,63,128,127,0,0,0,0,127,0,63,64,42,0,0,0,0,21,
  // 0x503c  值
  60,80,37,38,124,40,1,252,0,0,36,0,0,7,164,0,0,0,0,0,127,64,0,7,244,0,0,0,0,0,191,0,0,11,240,0,0,0,0,0,254,0,0,11,240,0,0,0,0,2,253,191,255,255,255,255,255,0,0,3,252,191,255,255,255,255,255,0,0,7,244,191,255,255,255,255,255,0,0,15,240,0,0,31,208,0,0,0,0,31,224,0,0,31,192,0,0,0,0,63,192,0,0,47,192,0,0,0,0,191,128,0,0,63,128,0,0,0,1,255,128,11,255,255,255,255,240,0,3,255,128,11,255,255,255,255,240,0,11,255,128,11,255,255,255,255,240,0,47,255,128,11,224,0,0,7,240,0,127,255,128,11,224,0,0,7,240,0,127,191,128,11,250,170,170,175,240,0,47,63,128,11,255,255,255,255,240,0,28,63,128,11,255,255,255,255,240,0,4,63,128,11,224,0,0,7,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,250,170,170,175,240,0,0,63,128,11,255,255,255,255,240,0,0,63,128,11,255,255,255,255,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,255,255,255,255,240,0,0,63,128,11,255,255,255,255,240,0,0,63,128,11,250,170,170,175,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,11,224,0,0,7,240,0,0,63,128,15,224,0,0,11,240,0,0,63,135,255,255,255,255,255,255,192,0,63,135,255,255,255,255,255,255,192,0,63,135,255,255,255,255,255,255,192,0,63,128,0,0,0,0,0,0,0,
  // 0x504f  偏
  79,80,38,39,134,40,1,251,0,0,144,0,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,0,2,252,255,255,255,255,255,255,208,0,3,248,255,255,255,255,255,255,208,0,7,244,255,255,255,255,255,255,208,0,15,240,0,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,47,255,255,255,255,254,0,0,255,64,47,255,255,255,255,254,0,1,255,64,47,255,255,255,255,254,0,3,255,64,47,192,0,0,0,254,0,7,255,64,47,192,0,0,0,254,0,15,255,64,47,192,0,0,0,254,0,63,255,64,47,255,255,255,255,254,0,191,255,64,47,255,255,255,255,254,0,255,127,64,47,255,255,255,255,254,0,190,63,64,47,128,0,0,0,0,0,60,63,64,47,128,0,0,0,0,0,36,63,64,63,128,0,0,0,0,0,0,63,64,63,255,255,255,255,255,64,0,63,64,63,255,255,255,255,255,64,0,63,64,63,255,255,255,255,255,64,0,63,64,63,248,31,66,240,63,64,0,63,64,127,248,31,66,240,63,64,0,63,64,191,248,31,66,240,63,64,0,63,64,255,248,31,66,240,63,64,0,63,64,255,255,255,255,255,255,64,0,63,65,253,255,255,255,255,255,64,0,63,67,253,255,255,255,255,255,64,0,63,67,249,248,31,66,240,63,64,0,63,75,245,248,31,66,240,63,64,0,63,79,241,248,31,66,240,63,64,0,63,127,209,248,31,66,240,63,64,0,63,95,193,248,31,66,240,63,64,0,63,71,1,248,31,66,247,255,64,0,63,64,1,248,31,66,243,255,0,0,63,64,1,248,31,66,242,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x505c  停
  92,80,38,38,124,40,1,252,0,0,36,0,0,6,160,0,0,0,0,0,127,64,0,11,240,0,0,0,0,0,191,0,0,11,240,0,0,0,0,0,255,0,0,11,240,0,0,0,0,2,254,255,255,255,255,255,255,192,0,3,252,255,255,255,255,255,255,192,0,11,244,255,255,255,255,255,255,192,0,15,240,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,0,127,192,7,255,255,255,255,244,0,0,255,128,7,255,255,255,255,244,0,2,255,128,7,250,170,170,171,244,0,7,255,128,7,240,0,0,7,244,0,15,255,128,7,240,0,0,7,244,0,63,255,128,7,240,0,0,7,244,0,191,255,128,7,255,255,255,255,244,0,255,191,128,7,255,255,255,255,244,0,127,63,128,2,170,170,170,170,160,0,60,63,128,0,0,0,0,0,0,0,20,63,131,255,255,255,255,255,255,224,0,63,131,255,255,255,255,255,255,224,0,63,131,255,255,255,255,255,255,224,0,63,131,244,0,0,0,0,15,224,0,63,131,244,0,0,0,0,15,224,0,63,131,244,0,0,0,0,15,224,0,63,131,244,255,255,255,255,207,224,0,63,131,244,255,255,255,255,207,224,0,63,128,0,255,255,255,255,192,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,0,11,240,0,0,0,0,63,128,0,21,95,240,0,0,0,0,63,128,0,63,255,240,0,0,0,0,63,128,0,47,255,224,0,0,0,0,47,128,0,31,254,64,0,0,0,
  // 0x5075  偵
  117,80,37,38,124,40,1,252,0,0,4,0,0,10,160,0,0,0,0,0,47,128,0,15,240,0,0,0,0,0,63,192,0,15,240,0,0,0,0,0,191,64,0,15,240,0,0,0,0,0,255,0,0,15,255,255,255,128,0,1,254,0,0,15,255,255,255,128,0,3,252,0,0,15,255,255,255,128,0,11,248,0,0,15,240,0,0,0,0,15,240,0,0,15,240,0,0,0,0,63,224,0,0,15,240,0,0,0,0,191,208,15,255,255,255,255,252,0,0,255,208,15,255,255,255,255,252,0,3,255,208,15,255,255,255,255,252,0,15,255,208,15,224,0,0,3,252,0,63,255,208,15,224,0,0,3,252,0,255,239,208,15,250,170,170,171,252,0,191,143,208,15,255,255,255,255,252,0,63,15,208,15,255,255,255,255,252,0,44,15,208,15,224,0,0,3,252,0,0,15,208,15,224,0,0,3,252,0,0,15,208,15,224,0,0,3,252,0,0,15,208,15,250,170,170,171,252,0,0,15,208,15,255,255,255,255,252,0,0,15,208,15,255,255,255,255,252,0,0,15,208,15,224,0,0,3,252,0,0,15,208,15,224,0,0,3,252,0,0,15,208,15,224,0,0,3,252,0,0,15,208,15,255,255,255,255,252,0,0,15,208,15,255,255,255,255,252,0,0,15,208,15,255,255,255,255,248,0,0,15,208,0,1,0,0,16,0,0,0,15,208,0,15,224,1,253,0,0,0,15,208,0,191,240,3,255,128,0,0,15,208,7,255,192,0,191,244,0,0,15,208,127,254,0,0,31,254,0,0,15,211,255,244,0,0,3,255,192,0,15,208,191,128,0,0,0,191,64,0,10,128,40,0,0,0,0,24,0,
  // 0x5099  備
  153,80,38,38,124,40,1,252,0,0,128,0,10,128,0,168,0,0,0,1,253,0,31,192,0,253,0,0,0,2,252,0,31,192,0,253,0,0,0,3,248,85,111,213,85,254,85,64,0,7,245,255,255,255,255,255,255,192,0,15,241,255,255,255,255,255,255,192,0,31,209,255,255,255,255,255,255,192,0,47,192,0,31,192,0,253,0,0,0,63,128,0,31,192,0,253,0,0,0,191,64,0,31,192,0,253,0,0,0,255,64,0,0,0,0,0,0,0,3,255,64,85,85,85,85,85,85,64,7,255,64,255,255,255,255,255,255,208,15,255,64,255,255,255,255,255,255,208,47,255,64,255,255,255,255,255,255,208,127,255,64,253,0,0,0,0,0,0,255,191,64,253,0,0,0,0,0,0,191,63,64,253,31,255,255,255,255,64,60,63,64,253,47,255,255,255,255,64,36,63,64,253,47,255,255,255,255,64,0,63,64,253,47,128,47,0,63,64,0,63,64,253,47,128,47,0,63,64,0,63,64,253,47,128,47,0,63,64,0,63,64,253,47,255,255,255,255,64,0,63,64,253,47,255,255,255,255,64,0,63,64,252,47,213,127,149,127,64,0,63,65,252,47,128,47,0,63,64,0,63,65,252,47,128,47,0,63,64,0,63,66,252,47,213,127,149,127,64,0,63,67,248,47,255,255,255,255,64,0,63,67,244,47,255,255,255,255,64,0,63,71,240,47,128,47,0,63,64,0,63,75,240,47,128,47,0,63,64,0,63,79,224,47,128,47,0,63,64,0,63,111,208,47,128,47,0,63,64,0,63,127,192,47,128,47,15,255,64,0,63,79,64,47,128,47,15,255,0,0,63,66,0,31,64,26,11,228,0,
  // 0x50b3  傳
  179,80,38,38,124,40,1,252,0,0,16,0,0,1,80,0,0,0,0,0,63,64,0,7,240,0,0,0,0,0,191,64,0,7,240,0,0,0,0,0,255,255,255,255,255,255,255,192,0,1,253,255,255,255,255,255,255,192,0,3,252,255,255,255,255,255,255,192,0,11,244,0,0,7,240,0,0,0,0,15,240,0,0,7,240,0,0,0,0,47,208,31,255,255,255,255,254,0,0,63,192,31,255,255,255,255,254,0,0,255,192,31,192,11,244,0,254,0,2,255,128,31,192,7,240,0,254,0,3,255,128,31,255,255,255,255,254,0,15,255,128,31,255,255,255,255,254,0,63,255,128,31,192,11,244,0,254,0,191,255,128,31,192,7,240,0,254,0,255,191,128,31,192,11,244,0,254,0,127,63,128,31,255,255,255,255,254,0,60,63,128,31,255,255,255,255,254,0,16,63,128,0,0,7,240,31,224,0,0,63,128,0,0,11,240,7,248,0,0,63,128,255,255,255,255,255,255,0,0,63,128,255,255,255,255,255,255,192,0,63,128,255,255,170,169,255,175,208,0,63,128,0,0,0,0,191,7,0,0,63,128,0,0,0,0,191,0,0,0,63,131,255,255,255,255,255,255,208,0,63,131,255,255,255,255,255,255,208,0,63,131,255,255,255,255,255,255,208,0,63,128,0,248,0,0,191,0,0,0,63,128,3,254,0,0,191,0,0,0,63,128,0,255,128,0,191,0,0,0,63,128,0,63,208,0,191,0,0,0,63,128,0,31,240,0,191,0,0,0,63,128,0,7,240,0,191,0,0,0,63,128,0,2,131,255,255,0,0,0,63,128,0,0,2,255,254,0,0,0,42,128,0,0,0,255,228,0,0,
  // 0x50be  傾
  190,80,38,38,124,40,1,252,0,1,64,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,7,240,0,15,255,255,255,255,208,0,11,240,0,15,255,255,255,255,208,0,15,211,240,15,255,255,255,255,208,0,31,199,240,0,0,15,240,0,0,0,63,199,240,0,0,31,208,0,0,0,127,71,240,0,0,31,192,0,0,0,191,7,240,0,255,255,255,255,0,0,255,7,240,0,255,255,255,255,0,2,255,7,240,52,255,255,255,255,0,3,255,7,240,253,253,0,0,127,0,11,255,7,242,254,253,0,0,127,0,31,255,7,251,248,253,0,0,127,0,63,255,7,255,224,255,170,170,255,0,191,255,7,255,128,255,255,255,255,0,255,127,7,253,0,255,255,255,255,0,189,127,7,244,0,253,0,0,127,0,60,127,7,240,0,253,0,0,127,0,48,127,7,240,0,253,0,0,127,0,0,127,7,240,0,253,0,0,127,0,0,127,7,240,0,255,255,255,255,0,0,127,7,240,16,255,255,255,255,0,0,127,7,240,62,255,170,170,255,0,0,127,7,240,63,253,0,0,127,0,0,127,7,240,63,253,0,0,127,0,0,127,7,240,63,253,0,0,127,0,0,127,3,240,63,255,255,255,255,0,0,127,3,255,254,255,255,255,255,0,0,127,3,255,252,255,255,255,255,0,0,127,0,255,244,2,0,1,0,0,0,127,0,0,0,15,224,15,208,0,0,127,0,0,0,127,240,47,248,0,0,127,0,0,3,255,192,7,254,0,0,127,0,0,47,254,0,1,255,192,0,127,0,0,255,244,0,0,63,224,0,127,0,0,63,128,0,0,15,192,0,127,0,0,24,0,0,0,2,0,
  // 0x5132  儲
  50,81,38,38,124,40,1,252,0,1,0,0,0,0,47,64,0,0,0,3,244,0,0,0,47,128,14,64,0,7,246,255,255,64,47,128,47,192,0,11,242,255,255,64,47,128,63,64,0,15,226,255,255,64,47,128,127,0,0,31,208,0,0,11,255,254,190,0,0,63,192,0,0,15,255,255,253,0,0,127,79,255,255,223,255,255,252,0,0,191,15,255,255,224,47,131,244,0,0,255,15,255,255,224,47,139,240,0,3,255,0,0,0,0,47,143,208,0,7,255,0,0,0,0,47,175,192,0,15,255,0,0,0,47,255,255,255,208,47,255,3,255,255,111,255,255,255,208,127,255,3,255,255,111,255,255,255,208,255,255,3,255,255,64,11,244,128,0,191,127,0,0,0,0,31,231,240,0,60,127,0,0,0,0,127,194,252,0,52,127,3,255,255,64,255,0,190,0,0,127,3,255,255,71,253,0,52,0,0,127,3,255,255,95,255,255,255,0,0,127,0,0,0,191,255,255,255,0,0,127,0,0,0,191,255,255,255,0,0,127,0,0,0,62,190,0,127,0,0,127,3,255,255,196,190,0,127,0,0,127,3,255,255,192,190,0,127,0,0,127,3,255,255,192,190,0,127,0,0,127,3,240,15,192,191,255,255,0,0,127,3,240,15,192,191,255,255,0,0,127,3,240,15,192,191,255,255,0,0,127,3,240,15,192,190,0,127,0,0,127,3,240,15,192,190,0,127,0,0,127,3,255,255,192,190,0,127,0,0,127,3,255,255,192,191,255,255,0,0,127,3,255,255,192,191,255,255,0,0,127,3,240,0,0,191,255,255,0,0,127,3,240,0,0,190,0,127,0,0,106,1,80,0,0,105,0,21,0,
  // 0x5145  充
  69,81,37,38,124,40,2,252,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,63,255,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,255,253,0,42,170,171,255,170,170,170,170,168,0,0,0,3,253,0,0,208,0,0,0,0,0,7,252,0,11,244,0,0,0,0,0,11,244,0,11,254,0,0,0,0,0,15,240,0,2,255,128,0,0,0,0,47,208,0,0,191,224,0,0,0,0,63,128,0,0,31,248,0,0,0,0,127,170,175,255,255,254,0,0,15,255,255,255,255,255,255,255,128,0,15,255,255,255,255,255,255,255,224,0,15,255,255,255,255,234,165,111,244,0,15,234,85,0,0,0,0,15,248,0,0,0,1,84,0,42,128,3,208,0,0,0,7,248,0,63,192,0,0,0,0,0,7,248,0,63,192,0,0,0,0,0,7,244,0,63,192,0,0,0,0,0,11,244,0,63,192,0,0,0,0,0,15,240,0,63,192,0,0,0,0,0,15,240,0,63,192,0,0,0,0,0,31,224,0,63,192,0,32,0,0,0,63,208,0,63,192,0,62,0,0,0,191,192,0,63,192,0,63,64,0,1,255,64,0,63,192,0,63,64,0,7,255,0,0,63,192,0,127,0,0,63,252,0,0,63,192,0,127,0,6,255,240,0,0,47,192,0,255,0,191,255,192,0,0,47,255,255,254,0,191,253,0,0,0,31,255,255,252,0,63,224,0,0,0,11,255,255,248,0,24,0,0,0,0,0,106,170,64,0,
  // 0x5148  先
  72,81,36,38,86,40,2,252,0,0,0,0,191,0,0,0,0,0,2,228,0,255,0,0,0,0,0,3,252,0,255,0,0,0,0,0,3,248,0,255,0,0,0,0,0,7,244,0,255,0,0,0,0,0,15,240,0,255,0,0,0,0,0,15,255,255,255,255,255,255,128,0,47,255,255,255,255,255,255,128,0,63,255,255,255,255,255,255,128,0,127,170,170,255,170,170,170,64,0,255,0,0,255,0,0,0,0,2,254,0,0,255,0,0,0,0,3,252,0,0,255,0,0,0,0,15,248,0,0,255,0,0,0,0,2,240,0,0,255,0,0,0,0,0,80,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,106,170,170,170,255,170,170,170,169,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,0,0,11,244,0,63,192,0,0,0,0,15,240,0,63,192,0,0,0,0,15,240,0,63,192,0,0,0,0,15,224,0,63,192,0,0,0,0,31,224,0,63,192,0,0,0,0,47,208,0,63,192,0,0,0,0,63,192,0,63,192,0,0,0,0,191,128,0,63,192,0,116,0,1,255,0,0,63,192,0,127,0,3,254,0,0,63,192,0,191,0,31,252,0,0,63,192,0,191,0,191,244,0,0,63,192,0,254,7,255,208,0,0,63,234,170,253,191,255,64,0,0,47,255,255,252,127,252,0,0,0,15,255,255,248,47,208,0,0,0,2,255,255,224,13,0,0,0,0,0,0,0,0,
  // 0x5149  光
  73,81,38,38,124,40,1,252,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,7,0,0,63,128,0,15,64,0,0,127,128,0,63,128,0,31,240,0,0,63,192,0,63,128,0,63,208,0,0,47,224,0,63,128,0,127,192,0,0,15,240,0,63,128,0,191,64,0,0,11,248,0,63,128,0,255,0,0,0,3,252,0,63,128,2,253,0,0,0,2,254,0,63,128,3,252,0,0,0,0,255,0,63,128,11,244,0,0,0,0,255,64,63,128,31,224,0,0,0,0,125,0,63,128,7,192,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,26,170,170,170,191,234,170,170,170,64,47,255,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,255,192,0,0,2,253,0,15,240,0,0,0,0,0,2,252,0,15,240,0,0,0,0,0,3,252,0,15,240,0,0,0,0,0,3,252,0,15,240,0,0,0,0,0,3,252,0,15,240,0,0,0,0,0,7,248,0,15,240,0,0,0,0,0,11,244,0,15,240,0,0,0,0,0,15,240,0,15,240,0,0,0,0,0,31,240,0,15,240,0,4,0,0,0,63,208,0,15,240,0,14,64,0,0,191,192,0,15,240,0,15,208,0,2,255,64,0,15,240,0,31,192,0,11,254,0,0,15,240,0,31,192,0,127,252,0,0,15,240,0,47,192,7,255,240,0,0,15,240,0,63,192,127,255,128,0,0,11,255,255,255,128,47,253,0,0,0,7,255,255,255,0,15,208,0,0,0,2,255,255,253,0,5,0,0,0,0,0,21,85,80,0,
  // 0x5165  入
  101,81,37,36,104,40,2,252,0,2,170,170,170,64,0,0,0,0,0,3,255,255,255,64,0,0,0,0,0,3,255,255,255,64,0,0,0,0,0,3,255,255,255,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,1,63,192,0,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,0,7,255,224,0,0,0,0,0,0,0,11,255,240,0,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,0,31,251,244,0,0,0,0,0,0,0,47,231,252,0,0,0,0,0,0,0,63,211,252,0,0,0,0,0,0,0,127,194,254,0,0,0,0,0,0,0,255,128,255,0,0,0,0,0,0,1,255,0,255,128,0,0,0,0,0,3,255,0,127,192,0,0,0,0,0,7,253,0,63,224,0,0,0,0,0,15,252,0,31,244,0,0,0,0,0,47,244,0,15,252,0,0,0,0,0,127,224,0,7,254,0,0,0,0,0,255,192,0,2,255,128,0,0,0,3,255,64,0,0,255,208,0,0,0,15,254,0,0,0,127,244,0,0,0,47,252,0,0,0,47,253,0,0,0,255,240,0,0,0,11,255,128,0,7,255,192,0,0,0,2,255,240,0,47,255,64,0,0,0,0,191,253,0,255,252,0,0,0,0,0,47,255,64,127,224,0,0,0,0,0,7,253,0,31,64,0,0,0,0,0,0,248,0,5,0,0,0,0,0,0,0,16,0,
  // 0x5168  全
  104,81,37,37,114,40,1,253,0,0,0,0,191,192,0,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,0,11,255,253,0,0,0,0,0,0,0,31,246,255,0,0,0,0,0,0,0,127,224,255,192,0,0,0,0,0,1,255,192,63,240,0,0,0,0,0,7,255,0,15,253,0,0,0,0,0,31,252,0,3,255,64,0,0,0,0,191,240,0,0,255,224,0,0,0,2,255,192,0,0,63,248,0,0,0,15,255,0,0,0,15,255,64,0,0,127,252,0,0,0,3,255,224,0,2,255,224,0,0,0,0,191,253,0,31,255,64,0,0,0,0,31,255,192,127,255,255,255,255,255,255,255,255,192,47,226,255,255,255,255,255,252,127,64,15,2,255,255,255,255,255,252,10,0,0,0,85,85,127,213,85,80,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,47,255,255,255,255,255,255,64,0,0,47,255,255,255,255,255,255,64,0,0,47,255,255,255,255,255,255,64,0,0,0,0,0,127,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,5,85,85,85,127,213,85,85,85,0,15,255,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,255,0,
  // 0x5171  共
  113,81,36,38,86,40,2,252,0,0,21,64,0,1,84,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,10,170,191,234,170,171,254,170,164,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,0,0,63,192,0,3,252,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,15,128,0,7,224,0,0,0,0,63,244,0,31,252,0,0,0,0,255,224,0,11,255,64,0,0,3,255,128,0,1,255,224,0,0,15,254,0,0,0,63,248,0,0,127,248,0,0,0,15,255,0,2,255,208,0,0,0,2,255,208,31,255,64,0,0,0,0,191,244,63,252,0,0,0,0,0,47,252,15,208,0,0,0,0,0,7,240,2,0,0,0,0,0,0,1,64,
  // 0x5177  具
  119,81,36,36,68,40,2,252,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,250,170,170,170,175,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,250,170,170,170,175,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,0,11,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,85,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,11,208,0,3,208,0,0,0,0,127,248,0,31,254,0,0,0,11,255,248,0,47,255,244,0,1,191,255,128,0,2,255,255,128,47,255,248,0,0,0,31,255,248,127,255,128,0,0,0,0,191,254,31,244,0,0,0,0,0,11,244,10,0,0,0,0,0,0,1,128,
  // 0x5197  冗
  151,81,37,35,94,40,2,252,47,255,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,255,252,0,47,234,170,170,170,170,170,171,252,0,47,192,0,0,0,0,0,3,252,0,47,192,0,0,0,0,0,3,252,0,47,192,0,0,0,0,0,3,252,0,47,192,0,0,0,0,0,3,252,0,47,192,0,0,0,0,0,3,252,0,47,192,0,0,0,0,0,3,252,0,21,64,63,255,255,255,248,1,84,0,0,0,63,255,255,255,248,0,0,0,0,0,63,255,255,255,248,0,0,0,0,0,63,229,85,91,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,63,192,0,3,248,0,0,0,0,0,127,128,0,3,248,0,0,0,0,0,191,64,0,3,248,0,16,0,0,0,255,0,0,3,248,0,61,0,0,2,254,0,0,3,248,0,63,64,0,7,253,0,0,3,248,0,127,64,0,31,248,0,0,3,248,0,127,0,0,127,240,0,0,3,248,0,127,0,3,255,208,0,0,3,252,0,191,0,47,255,64,0,0,3,255,170,255,0,255,253,0,0,0,3,255,255,253,0,127,224,0,0,0,1,255,255,252,0,47,64,0,0,0,0,127,255,224,0,4,0,0,0,0,0,0,0,0,0,
  // 0x51b7  冷
  183,81,37,38,124,40,2,252,0,0,0,0,0,170,0,0,0,0,0,0,0,0,2,255,64,0,0,0,4,0,0,0,7,255,192,0,0,0,31,0,0,0,15,255,240,0,0,0,127,208,0,0,47,255,248,0,0,0,191,248,0,0,191,195,254,0,0,0,31,254,0,1,255,65,255,128,0,0,7,255,128,7,255,0,191,208,0,0,0,255,208,31,252,0,47,248,0,0,0,63,128,127,240,0,11,254,0,0,0,14,1,255,208,0,3,255,192,0,0,0,7,255,64,0,0,191,244,0,0,0,47,254,85,85,85,111,254,0,0,1,255,243,255,255,255,203,255,128,0,2,255,195,255,255,255,193,255,0,0,0,254,3,255,255,255,192,61,0,0,0,116,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,66,255,255,255,255,255,208,0,0,15,210,255,255,255,255,255,208,0,0,47,226,255,255,255,255,255,208,0,0,63,193,85,95,245,85,111,208,0,0,191,128,0,15,240,0,15,208,0,1,255,0,0,15,240,0,15,208,0,3,254,0,0,15,240,0,15,208,0,11,252,0,0,15,240,0,15,208,0,15,244,0,0,15,240,0,15,208,0,63,240,0,0,15,240,0,15,208,0,127,208,0,0,15,240,42,175,208,0,255,128,0,0,15,240,63,255,208,0,255,0,0,0,15,240,31,255,192,0,45,0,0,0,15,240,15,253,0,0,4,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,10,160,0,0,0,0,
  // 0x51c6  准
  198,81,37,38,124,40,2,252,0,0,0,0,36,0,5,0,0,0,0,0,0,0,191,64,11,240,0,0,0,0,0,0,255,0,15,240,0,0,15,64,0,1,254,0,15,224,0,0,63,224,0,3,252,0,47,192,0,0,63,252,0,7,248,0,63,192,0,0,11,255,64,15,244,0,63,64,0,0,1,255,208,31,240,0,191,0,0,0,0,63,240,63,255,255,255,255,253,0,0,15,192,127,255,255,255,255,253,0,0,3,0,255,255,255,255,255,253,0,0,0,2,255,213,86,253,85,84,0,0,0,7,255,192,1,252,0,0,0,0,0,15,255,192,1,252,0,0,0,0,0,63,255,192,1,252,0,0,0,0,0,255,239,192,1,252,0,0,0,0,0,127,159,255,255,255,255,244,0,0,0,30,31,255,255,255,255,244,0,0,0,4,31,255,255,255,255,244,0,0,0,0,31,213,86,253,85,80,0,0,0,0,31,192,1,252,0,0,0,0,11,0,31,192,1,252,0,0,0,0,31,208,31,192,1,252,0,0,0,0,63,208,31,192,1,252,0,0,0,0,127,192,31,255,255,255,255,244,0,0,255,0,31,255,255,255,255,244,0,2,254,0,31,255,255,255,255,244,0,7,252,0,31,213,86,253,85,80,0,15,248,0,31,192,1,252,0,0,0,47,240,0,31,192,1,252,0,0,0,127,208,0,31,192,1,252,0,0,0,255,128,0,31,192,1,252,0,0,0,255,0,0,31,229,86,254,85,85,0,61,0,0,31,255,255,255,255,255,64,8,0,0,31,255,255,255,255,255,64,0,0,0,31,255,255,255,255,255,64,0,0,0,31,192,0,0,0,0,0,0,0,0,31,192,0,0,0,0,0,
  // 0x51fa  出
  250,81,32,38,48,40,4,252,0,0,0,10,144,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,224,0,15,224,0,15,240,15,250,170,175,250,170,175,240,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,106,0,0,15,224,0,0,169,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,0,0,15,224,0,0,254,191,170,170,175,250,170,170,254,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,191,0,0,0,0,0,0,254,191,0,0,0,0,0,0,254,106,0,0,0,0,0,0,169,
  // 0x5206  分
  6,82,38,37,114,40,1,252,0,0,1,228,0,0,180,0,0,0,0,0,3,254,0,7,252,0,0,0,0,0,7,252,0,3,254,0,0,0,0,0,15,248,0,1,255,0,0,0,0,0,31,240,0,0,255,192,0,0,0,0,63,224,0,0,63,224,0,0,0,0,255,192,0,0,47,244,0,0,0,1,255,64,0,0,15,252,0,0,0,3,255,0,0,0,3,255,0,0,0,15,252,0,0,0,1,255,192,0,0,63,244,0,0,0,0,255,224,0,0,191,224,0,0,0,0,63,248,0,2,255,192,0,0,0,0,15,254,0,15,255,0,0,0,0,0,7,255,192,63,255,170,170,170,170,170,171,255,224,191,251,255,255,255,255,255,253,191,192,47,195,255,255,255,255,255,253,47,0,11,3,255,255,255,255,255,253,4,0,0,0,0,15,240,0,2,253,0,0,0,0,0,15,240,0,2,253,0,0,0,0,0,31,240,0,2,253,0,0,0,0,0,31,224,0,2,252,0,0,0,0,0,47,208,0,2,252,0,0,0,0,0,63,192,0,3,252,0,0,0,0,0,127,192,0,3,252,0,0,0,0,0,255,128,0,3,252,0,0,0,0,1,255,0,0,3,252,0,0,0,0,3,254,0,0,3,252,0,0,0,0,15,252,0,0,3,248,0,0,0,0,47,248,0,0,7,248,0,0,0,0,255,224,0,0,11,244,0,0,0,7,255,192,0,0,15,244,0,0,0,127,255,0,0,0,47,240,0,0,7,255,248,0,7,255,255,224,0,0,3,255,208,0,3,255,255,208,0,0,1,254,0,0,2,255,255,64,0,0,0,224,0,0,0,170,148,0,0,0,
  // 0x5217  列
  23,82,36,37,77,40,1,252,0,0,0,0,0,0,0,0,254,31,255,255,255,255,192,0,0,254,31,255,255,255,255,192,0,0,254,31,255,255,255,255,192,0,0,254,5,86,255,85,85,75,240,0,254,0,1,254,0,0,11,240,0,254,0,2,252,0,0,11,240,0,254,0,3,252,0,0,11,240,0,254,0,3,248,0,0,11,240,0,254,0,7,244,0,0,11,240,0,254,0,15,255,255,254,11,240,0,254,0,31,255,255,255,11,240,0,254,0,47,255,255,254,11,240,0,254,0,63,213,85,254,11,240,0,254,0,191,64,1,253,11,240,0,254,0,255,0,2,252,11,240,0,254,3,253,0,3,252,11,240,0,254,7,255,0,3,248,11,240,0,254,15,255,224,7,244,11,240,0,254,63,255,252,15,240,11,240,0,254,255,203,255,79,224,11,240,0,254,127,1,255,255,208,11,240,0,254,12,0,63,255,192,11,240,0,254,0,0,11,255,64,11,240,0,254,0,0,1,255,0,11,240,0,254,0,0,2,253,0,11,240,0,254,0,0,7,252,0,0,0,0,254,0,0,15,244,0,0,0,0,254,0,0,63,224,0,0,0,0,254,0,0,191,192,0,0,0,0,254,0,2,255,64,0,0,0,0,254,0,15,253,0,0,0,0,0,254,0,127,248,0,0,0,0,1,254,2,255,224,0,0,0,47,255,253,3,255,64,0,0,0,15,255,252,0,252,0,0,0,0,15,255,244,0,32,0,0,0,0,6,169,64,
  // 0x521d  初
  29,82,37,39,134,40,1,251,0,3,244,0,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,0,7,244,0,170,170,170,170,170,64,0,7,244,1,255,255,255,255,255,128,0,7,244,1,255,255,255,255,255,128,0,7,244,1,255,255,255,255,255,128,21,91,249,80,0,15,224,0,127,64,63,255,255,253,0,15,224,0,127,64,63,255,255,253,0,15,224,0,127,64,63,255,255,252,0,31,224,0,127,64,0,0,3,248,0,31,208,0,127,64,0,0,11,240,0,31,208,0,127,64,0,0,31,224,0,31,208,0,127,64,0,0,63,192,0,31,208,0,127,64,0,0,191,70,0,47,192,0,191,64,0,1,255,15,128,47,192,0,191,64,0,3,252,47,192,47,192,0,191,0,0,11,252,127,0,63,192,0,191,0,0,47,255,252,0,63,192,0,191,0,0,191,255,244,0,63,128,0,191,0,1,255,255,240,0,127,64,0,191,0,11,255,251,252,0,191,0,0,255,0,47,255,245,255,0,255,0,0,255,0,191,231,244,191,64,255,0,0,255,0,63,199,244,62,2,253,0,0,255,0,46,7,244,12,3,252,0,0,255,0,8,7,244,0,7,252,0,0,255,0,0,7,244,0,15,244,0,0,254,0,0,7,244,0,31,240,0,1,254,0,0,7,244,0,63,208,0,1,253,0,0,7,244,0,191,192,0,2,253,0,0,7,244,2,255,64,0,3,252,0,0,7,244,11,254,0,0,11,252,0,0,7,244,47,252,0,191,255,248,0,0,7,244,63,240,0,63,255,240,0,0,7,244,15,192,0,63,255,208,0,0,3,244,2,0,0,42,169,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5230  到
  48,82,36,37,77,40,1,252,0,0,0,0,0,0,0,0,170,0,0,0,0,0,0,0,0,254,63,255,255,255,255,208,0,0,254,63,255,255,255,255,208,0,0,254,63,255,255,255,255,211,244,0,254,21,87,253,85,85,67,244,0,254,0,7,248,0,0,3,244,0,254,0,11,244,7,192,3,244,0,254,0,15,240,31,224,3,244,0,254,0,31,208,11,244,3,244,0,254,0,47,192,3,252,3,244,0,254,0,63,128,0,255,3,244,0,254,42,255,255,255,255,67,244,0,254,63,255,255,255,255,195,244,0,254,63,255,255,255,255,227,244,0,254,63,254,170,85,11,243,244,0,254,0,0,21,64,3,131,244,0,254,0,0,47,192,0,3,244,0,254,0,0,47,192,0,3,244,0,254,0,0,47,192,0,3,244,0,254,0,0,47,192,0,3,244,0,254,11,255,255,255,255,3,244,0,254,11,255,255,255,255,3,244,0,254,11,255,255,255,255,3,244,0,254,1,85,111,213,85,3,244,0,254,0,0,47,192,0,3,244,0,254,0,0,47,192,0,2,164,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,5,144,0,0,254,0,0,47,239,255,208,0,0,254,5,175,255,255,255,208,0,0,254,127,255,255,255,255,208,0,0,254,63,255,255,254,148,0,31,255,254,63,255,165,0,0,0,15,255,253,41,0,0,0,0,0,11,255,248,0,0,0,0,0,0,7,170,64,
  // 0x5236  制
  54,82,36,38,86,40,1,252,0,0,6,144,0,0,0,0,0,0,164,11,240,0,0,0,0,191,0,254,11,240,0,0,0,0,191,1,253,11,240,0,0,0,0,191,2,252,11,240,0,0,47,192,191,3,252,11,240,0,0,47,192,191,3,255,255,255,255,208,47,192,191,7,255,255,255,255,208,47,192,191,15,255,255,255,255,208,47,192,191,31,229,95,245,85,64,47,192,191,63,192,11,240,0,0,47,192,191,127,128,11,240,0,0,47,192,191,7,0,11,240,0,0,47,192,191,63,255,255,255,255,252,47,192,191,63,255,255,255,255,252,47,192,191,63,255,255,255,255,252,47,192,191,21,85,95,245,85,84,47,192,191,0,0,11,240,0,0,47,192,191,0,0,11,240,0,0,47,192,191,0,0,11,240,0,0,47,192,191,7,255,255,255,255,240,47,192,191,7,255,255,255,255,240,47,192,191,7,255,255,255,255,240,47,192,191,7,245,95,245,91,240,47,192,191,7,240,11,240,11,240,47,192,191,7,240,11,240,11,240,47,192,191,7,240,11,240,11,240,21,64,191,7,240,11,240,11,240,0,0,191,7,240,11,240,11,240,0,0,191,7,240,11,240,11,240,0,0,191,7,240,11,240,11,240,0,0,191,7,240,11,240,11,240,0,0,191,7,240,11,243,255,224,0,0,191,7,240,11,241,255,208,0,0,191,7,224,11,240,254,64,7,255,255,0,0,11,240,0,0,3,255,254,0,0,11,240,0,0,2,255,252,0,0,11,240,0,0,1,250,144,
  // 0x5237  刷
  55,82,36,37,77,40,1,252,0,0,0,0,0,0,0,0,190,1,85,85,85,85,80,0,0,191,3,255,255,255,255,240,0,0,191,3,255,255,255,255,240,21,0,191,3,255,255,255,255,240,191,0,191,3,244,0,0,11,240,191,0,191,3,244,0,0,11,240,191,0,191,3,244,0,0,11,240,191,0,191,3,244,0,0,11,240,191,0,191,3,255,255,255,255,240,191,0,191,3,255,255,255,255,240,191,0,191,3,255,255,255,255,240,191,0,191,3,249,85,191,85,80,191,0,191,3,244,0,127,0,0,191,0,191,3,244,0,127,0,0,191,0,191,3,244,0,127,0,0,191,0,191,3,244,0,127,0,0,191,0,191,3,251,255,255,255,240,191,0,191,3,251,255,255,255,240,191,0,191,3,251,255,255,255,240,191,0,191,3,251,224,127,3,240,191,0,191,3,247,224,127,3,240,191,0,191,3,247,224,127,3,240,191,0,191,3,247,224,127,3,240,191,0,191,7,243,224,127,3,240,191,0,191,7,243,224,127,3,240,191,0,191,11,227,224,127,3,240,21,0,191,15,227,224,127,3,240,0,0,191,15,211,224,127,3,240,0,0,191,15,195,224,127,191,240,0,0,191,47,195,224,127,63,224,0,0,191,63,131,224,127,63,128,0,0,191,63,65,64,127,0,0,0,0,255,191,0,0,127,0,0,7,255,255,62,0,0,127,0,0,3,255,254,8,0,0,127,0,0,2,255,252,0,0,0,126,0,0,1,234,80,
  // 0x5275  創
  117,82,36,38,86,40,1,252,0,0,1,80,0,0,0,0,0,0,0,15,252,0,0,0,0,254,0,0,47,255,0,0,0,0,254,0,0,127,255,208,0,0,0,254,0,1,255,111,248,0,0,0,254,0,3,253,7,254,2,252,0,254,0,15,248,1,255,130,252,0,254,0,127,224,0,127,242,252,0,254,1,255,255,255,255,242,252,0,254,11,254,255,255,231,210,252,0,254,127,248,106,170,145,66,252,0,254,63,224,0,0,0,2,252,0,254,31,234,170,170,170,66,252,0,254,8,191,255,255,255,66,252,0,254,0,191,255,255,255,66,252,0,254,0,190,0,0,63,66,252,0,254,0,190,0,0,63,66,252,0,254,0,191,255,255,255,66,252,0,254,0,191,255,255,255,66,252,0,254,0,191,85,85,127,66,252,0,254,0,190,0,0,63,66,252,0,254,0,190,0,0,63,66,252,0,254,0,191,255,255,255,66,252,0,254,0,255,255,255,255,66,252,0,254,0,255,170,170,170,66,252,0,254,0,252,0,0,0,2,252,0,254,0,254,170,170,170,130,252,0,254,1,255,255,255,255,194,252,0,254,2,255,255,255,255,192,0,0,254,3,251,224,0,15,192,0,0,254,7,247,224,0,15,192,0,0,254,11,231,224,0,15,192,0,0,254,15,215,224,0,15,192,0,0,254,63,199,255,255,255,192,0,0,254,127,7,255,255,255,192,15,255,254,30,7,255,255,255,192,15,255,253,4,7,224,0,15,192,11,255,248,0,6,144,0,5,64,2,170,64,
  // 0x529b  力
  155,82,34,39,95,40,2,251,0,0,0,10,160,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,0,0,0,31,224,0,0,15,240,0,0,0,31,224,0,0,15,240,0,0,0,47,208,0,0,15,240,0,0,0,47,208,0,0,15,240,0,0,0,63,192,0,0,15,240,0,0,0,63,192,0,0,15,224,0,0,0,127,128,0,0,15,224,0,0,0,255,64,0,0,15,224,0,0,0,255,0,0,0,31,224,0,0,1,255,0,0,0,31,208,0,0,3,253,0,0,0,31,208,0,0,7,252,0,0,0,47,208,0,0,15,248,0,0,0,47,192,0,0,47,240,0,0,0,63,192,0,0,63,224,0,0,0,63,192,0,0,255,192,0,0,0,63,192,0,3,255,64,0,0,0,127,128,0,11,254,0,0,0,0,127,128,0,63,252,0,0,0,0,191,64,0,255,240,0,0,0,0,255,0,7,255,192,0,0,0,3,255,0,47,255,0,0,0,255,255,254,0,127,252,0,0,0,255,255,252,0,31,208,0,0,0,127,255,240,0,11,0,0,0,0,42,170,64,0,0,0,0,0,0,0,0,0,0,
  // 0x52a0  加
  160,82,36,37,77,40,1,252,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,31,255,255,253,0,11,240,0,0,31,255,255,253,0,11,240,0,0,31,255,255,253,47,255,255,255,252,31,234,170,253,47,255,255,255,252,31,192,0,253,47,255,255,255,252,31,192,0,253,26,175,250,171,248,31,192,0,253,0,11,240,3,248,31,192,0,253,0,15,240,3,248,31,192,0,253,0,15,240,3,248,31,192,0,253,0,15,224,3,248,31,192,0,253,0,15,224,3,248,31,192,0,253,0,15,224,3,248,31,192,0,253,0,15,224,3,248,31,192,0,253,0,15,208,3,248,31,192,0,253,0,31,208,3,248,31,192,0,253,0,31,192,3,248,31,192,0,253,0,47,192,3,244,31,192,0,253,0,63,192,3,244,31,192,0,253,0,63,128,3,244,31,192,0,253,0,63,128,7,244,31,192,0,253,0,127,64,7,244,31,192,0,253,0,191,0,7,244,31,192,0,253,0,255,0,7,240,31,192,0,253,1,254,0,11,240,31,192,0,253,3,252,0,11,240,31,234,170,253,7,248,0,15,240,31,255,255,253,15,244,0,15,240,31,255,255,253,47,240,106,191,224,31,255,255,253,127,208,63,255,208,31,192,0,253,127,128,63,255,128,31,192,0,253,15,0,47,253,0,31,192,0,169,4,0,0,0,0,0,0,0,0,
  // 0x52d5  動
  213,82,37,38,124,40,1,252,0,0,0,0,80,0,0,0,0,0,0,0,86,191,252,0,127,64,0,0,47,255,255,255,254,0,127,64,0,0,47,255,255,255,228,0,127,64,0,0,15,250,191,128,0,0,127,64,0,0,0,0,63,64,0,0,127,64,0,0,0,0,63,64,0,0,127,64,0,0,42,170,191,234,170,64,127,0,0,0,63,255,255,255,255,128,127,0,0,0,63,255,255,255,255,149,191,149,85,0,0,0,63,64,0,191,255,255,255,64,0,0,63,64,0,191,255,255,255,64,15,255,255,255,255,191,255,255,255,64,15,255,255,255,255,0,127,0,63,64,15,213,127,149,191,0,191,0,63,64,15,192,63,64,127,0,191,0,63,64,15,192,63,64,127,0,191,0,127,64,15,255,255,255,255,0,190,0,127,64,15,255,255,255,255,0,254,0,127,64,15,213,127,149,127,0,254,0,127,0,15,192,63,64,127,0,253,0,127,0,15,192,63,64,127,1,253,0,127,0,15,255,255,255,255,2,252,0,127,0,15,255,255,255,255,2,252,0,191,0,5,85,127,149,85,3,248,0,191,0,0,0,63,64,0,7,244,0,191,0,10,170,191,234,170,11,240,0,191,0,15,255,255,255,255,15,240,0,191,0,15,255,255,255,255,47,208,0,255,0,0,0,63,64,0,63,192,0,254,0,0,0,63,64,0,191,128,0,254,0,0,0,63,133,175,255,0,0,253,0,0,86,191,255,255,254,0,1,253,0,127,255,255,255,255,252,0,3,252,0,63,255,255,254,191,244,15,255,252,0,63,234,80,0,127,208,15,255,244,0,0,0,0,0,31,64,11,255,224,0,0,0,0,0,5,0,1,85,0,0,
  // 0x5316  化
  22,83,38,37,114,40,1,252,0,0,3,144,11,240,0,0,0,0,0,0,11,248,11,240,0,0,0,0,0,0,15,240,11,240,0,0,0,0,0,0,47,224,11,240,0,0,0,0,0,0,63,192,11,240,0,0,0,0,0,0,255,128,11,240,0,0,0,0,0,1,255,0,11,240,0,0,0,0,0,3,254,0,11,240,0,0,160,0,0,11,252,0,11,240,0,2,244,0,0,31,244,0,11,240,0,15,253,0,0,63,244,0,11,240,0,127,253,0,0,255,244,0,11,240,2,255,240,0,2,255,244,0,11,240,31,255,128,0,11,255,244,0,11,240,255,252,0,0,47,255,244,0,11,251,255,208,0,0,191,247,244,0,11,255,254,0,0,0,255,215,244,0,11,255,224,0,0,0,63,71,244,0,11,255,64,0,0,0,45,7,244,0,11,244,0,0,0,0,4,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,0,0,0,7,244,0,11,240,0,0,4,0,0,7,244,0,11,240,0,0,15,128,0,7,244,0,11,240,0,0,15,224,0,7,244,0,11,240,0,0,15,208,0,7,244,0,11,240,0,0,15,208,0,7,244,0,11,240,0,0,31,192,0,7,244,0,11,244,0,0,63,192,0,7,244,0,7,254,85,86,255,128,0,7,244,0,3,255,255,255,255,64,0,7,244,0,2,255,255,255,254,0,0,7,244,0,0,111,255,255,244,0,0,2,160,0,0,0,0,0,0,0,
  // 0x534a  半
  74,83,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,9,0,0,255,0,0,164,0,0,191,0,0,255,0,0,255,64,0,255,64,0,255,0,1,255,0,0,127,192,0,255,0,3,253,0,0,47,224,0,255,0,7,252,0,0,15,240,0,255,0,15,244,0,0,11,248,0,255,0,31,240,0,0,3,252,0,255,0,63,208,0,0,3,253,0,255,0,191,128,0,0,1,253,0,255,0,191,0,0,0,0,128,0,255,0,5,0,0,0,0,0,0,255,0,0,0,0,2,170,170,170,255,170,170,170,144,7,255,255,255,255,255,255,255,224,7,255,255,255,255,255,255,255,224,7,255,255,255,255,255,255,255,224,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,171,255,170,170,170,170,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,
  // 0x5354  協
  84,83,37,38,124,40,1,252,0,47,192,0,0,7,240,0,0,0,0,47,192,0,0,7,240,0,0,0,0,47,192,0,0,11,240,0,0,0,0,47,192,0,0,11,240,0,0,0,0,47,192,3,255,255,255,255,253,0,0,47,192,3,255,255,255,255,253,0,0,47,192,3,255,255,255,255,252,0,0,47,192,0,0,63,192,1,252,0,0,47,192,0,0,127,64,1,252,0,0,47,192,0,0,255,0,2,252,0,21,127,213,64,2,253,0,2,252,0,127,255,255,208,7,252,0,3,248,0,127,255,255,208,47,240,0,7,244,0,127,255,255,209,255,192,15,255,240,0,0,47,192,31,254,0,15,255,224,0,0,47,192,15,244,0,11,255,64,0,0,47,192,3,64,0,0,0,0,0,0,47,192,3,240,0,0,252,0,0,0,47,192,3,240,0,0,252,0,0,0,47,192,3,240,0,0,252,0,0,0,47,192,3,240,0,0,252,0,0,0,47,194,255,255,253,191,255,255,128,0,47,195,255,255,253,191,255,255,192,0,47,195,255,255,253,191,255,255,128,0,47,192,7,224,189,1,248,31,128,0,47,192,11,224,189,2,248,31,128,0,47,192,11,208,252,3,244,31,128,0,47,192,15,192,252,3,240,31,128,0,47,192,15,192,252,3,240,31,128,0,47,192,31,128,252,11,224,47,128,0,47,192,47,64,252,15,208,47,64,0,47,192,63,0,252,31,192,47,64,0,47,192,191,0,252,63,128,63,64,0,47,192,253,1,252,127,0,63,0,0,47,195,252,2,249,254,0,127,0,0,47,203,240,191,247,252,31,255,0,0,47,195,208,127,240,240,15,253,0,0,47,193,64,63,128,64,15,244,0,
  // 0x5361  卡
  97,83,36,38,86,40,2,252,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,254,170,170,169,0,0,0,0,3,255,255,255,254,0,0,0,0,3,255,255,255,254,0,0,0,0,3,255,255,255,254,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,171,254,170,170,170,170,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,64,0,0,0,0,0,0,3,255,249,0,0,0,0,0,0,3,255,255,228,0,0,0,0,0,3,255,255,255,144,0,0,0,0,3,252,111,255,253,0,0,0,0,3,252,1,255,255,192,0,0,0,3,252,0,11,255,128,0,0,0,3,252,0,0,127,0,0,0,0,3,252,0,0,5,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,2,252,0,0,0,0,
  // 0x5370  印
  112,83,33,38,86,40,4,252,0,0,1,64,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,2,255,244,0,0,0,0,0,0,127,255,248,63,255,255,255,192,251,255,255,128,63,255,255,255,192,255,255,228,0,63,255,255,255,192,255,249,0,0,63,234,170,191,192,255,64,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,255,255,244,63,128,0,63,192,255,255,255,244,63,128,0,63,192,255,255,255,244,63,128,0,63,192,255,170,170,160,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,0,0,0,63,128,0,63,192,255,255,255,244,63,128,0,63,192,255,255,255,244,63,129,255,255,128,255,255,255,244,63,128,255,255,128,255,170,170,164,63,128,191,255,0,255,0,0,0,63,128,63,228,0,255,0,0,0,63,128,0,0,0,255,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,42,64,0,0,0,
  // 0x5378  卸
  120,83,36,38,86,40,1,252,0,10,64,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,47,192,0,0,5,85,85,85,0,63,128,0,0,15,255,255,255,0,127,149,85,84,15,255,255,255,0,255,255,255,254,15,255,255,255,1,255,255,255,254,15,208,0,191,3,255,255,255,254,15,208,0,191,11,244,31,192,0,15,208,0,191,31,240,31,192,0,15,208,0,191,63,208,31,192,0,15,208,0,191,11,128,31,192,0,15,208,0,191,1,0,31,192,0,15,208,0,191,63,255,255,255,255,79,208,0,191,63,255,255,255,255,79,208,0,191,63,255,255,255,255,79,208,0,191,21,85,111,213,85,15,208,0,191,0,0,31,192,0,15,208,0,191,0,0,31,192,0,15,208,0,191,2,244,31,192,0,15,208,0,191,3,244,31,192,0,15,208,0,191,3,244,31,255,252,15,208,0,191,3,244,31,255,252,15,208,0,191,3,244,31,255,252,15,208,0,191,3,244,31,192,0,15,208,0,191,3,244,31,192,0,15,208,0,191,3,244,31,192,0,15,208,0,191,3,244,31,192,0,15,208,0,255,3,244,31,192,0,15,208,255,255,3,244,31,192,26,79,208,191,254,3,244,31,255,255,79,208,127,252,3,255,255,255,255,79,208,62,144,127,255,255,255,255,79,208,0,0,127,255,255,249,64,15,208,0,0,127,255,148,0,0,15,208,0,0,57,64,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,
  // 0x537b  卻
  123,83,36,37,77,40,1,252,0,0,47,224,0,0,0,0,0,0,0,127,252,0,10,170,170,169,0,0,255,255,0,15,255,255,255,0,3,255,255,208,15,255,255,255,0,11,252,63,244,15,255,255,255,0,47,240,15,253,15,208,0,191,0,255,192,3,255,79,208,0,191,7,255,0,0,255,143,208,0,191,47,252,0,0,63,15,208,0,191,15,240,0,0,12,15,208,0,191,7,128,47,240,0,15,208,0,191,0,0,127,252,0,15,208,0,191,0,0,255,255,0,15,208,0,191,0,3,255,255,192,15,208,0,191,0,11,252,63,240,15,208,0,191,0,47,244,15,252,15,208,0,191,0,191,224,7,254,15,208,0,191,2,255,128,1,255,143,208,0,191,15,254,0,0,191,207,208,0,191,127,248,0,0,63,15,208,0,191,127,240,0,0,29,15,208,0,191,31,191,255,255,244,15,208,0,191,4,191,255,255,244,15,208,0,191,0,191,255,255,244,15,208,0,191,0,191,0,3,244,15,208,0,191,0,191,0,3,244,15,208,0,255,0,191,0,3,244,15,208,255,255,0,191,0,3,244,15,208,191,254,0,191,0,3,244,15,208,127,252,0,191,0,3,244,15,208,42,144,0,191,0,7,244,15,208,0,0,0,191,255,255,244,15,208,0,0,0,191,255,255,244,15,208,0,0,0,191,255,255,244,15,208,0,0,0,191,0,3,244,15,208,0,0,0,191,0,3,244,15,208,0,0,0,20,0,0,0,15,208,0,0,
  // 0x539f  原
  159,83,37,36,104,40,1,252,0,255,255,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,255,128,0,255,85,85,86,255,85,85,85,64,0,254,0,0,1,255,0,0,0,0,0,254,0,0,2,254,0,0,0,0,0,254,0,0,3,253,0,0,0,0,0,254,3,255,255,255,255,255,224,0,0,254,3,255,255,255,255,255,224,0,0,254,3,255,255,255,255,255,224,0,0,254,3,248,0,0,0,15,224,0,0,254,3,248,0,0,0,15,224,0,0,254,3,248,0,0,0,15,224,0,0,254,3,254,170,170,170,191,224,0,0,254,3,255,255,255,255,255,224,0,0,254,3,255,255,255,255,255,224,0,0,254,3,248,0,0,0,15,224,0,0,254,3,248,0,0,0,15,224,0,0,254,3,248,0,0,0,15,224,0,0,253,3,255,255,255,255,255,224,0,1,253,3,255,255,255,255,255,224,0,1,253,3,255,255,255,255,255,224,0,1,252,0,0,0,191,0,0,0,0,2,252,0,0,0,191,0,0,0,0,3,252,0,62,64,191,0,184,0,0,3,248,0,127,192,191,3,254,0,0,3,248,0,255,0,191,1,255,128,0,7,244,3,254,0,191,0,63,224,0,11,240,11,252,0,191,0,31,248,0,15,240,47,240,0,191,0,7,253,0,15,224,191,208,0,191,0,1,255,0,47,211,255,64,0,191,0,0,191,192,63,195,253,1,65,255,0,0,63,128,127,128,180,3,255,255,0,0,13,0,47,0,0,1,255,253,0,0,0,0,2,0,0,0,255,228,0,0,0,0,
  // 0x53cd  反
  205,83,36,36,68,40,2,252,0,42,170,170,170,170,170,170,160,0,127,255,255,255,255,255,255,240,0,127,255,255,255,255,255,255,240,0,127,255,255,255,255,255,255,240,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,255,255,255,255,255,253,0,0,127,255,255,255,255,255,255,0,0,127,255,255,255,255,255,254,0,0,127,239,254,170,170,171,253,0,0,127,67,252,0,0,3,252,0,0,127,66,253,0,0,11,248,0,0,127,1,255,0,0,15,240,0,0,191,0,255,64,0,47,224,0,0,191,0,127,192,0,63,208,0,0,255,0,63,208,0,255,192,0,0,255,0,31,244,2,255,0,0,0,254,0,11,252,11,254,0,0,0,253,0,3,255,31,252,0,0,1,253,0,1,255,255,240,0,0,2,252,0,0,191,255,208,0,0,3,252,0,0,47,255,64,0,0,3,248,0,0,47,255,64,0,0,11,244,0,1,255,255,240,0,0,15,240,0,15,255,255,254,0,0,31,224,1,255,254,31,255,228,0,63,208,111,255,244,3,255,255,144,127,195,255,255,128,0,127,255,253,191,65,255,248,0,0,7,255,252,31,0,191,64,0,0,0,111,240,0,0,32,0,0,0,0,1,144,
  // 0x53d6  取
  214,83,38,36,104,40,1,252,21,85,85,85,85,64,0,0,0,0,63,255,255,255,255,128,0,0,0,0,63,255,255,255,255,128,0,0,0,0,63,255,255,255,255,234,170,170,169,0,0,254,0,11,241,255,255,255,255,64,0,254,0,11,241,255,255,255,255,0,0,254,0,11,241,255,255,255,255,0,0,254,0,11,240,26,0,0,255,0,0,254,0,11,240,255,0,0,254,0,0,255,255,255,240,191,0,0,254,0,0,255,255,255,240,127,64,1,253,0,0,255,255,255,240,63,128,2,252,0,0,254,85,95,240,63,192,3,252,0,0,254,0,11,240,47,192,3,248,0,0,254,0,11,240,31,208,7,244,0,0,254,0,11,240,15,224,11,240,0,0,254,0,11,240,15,240,15,240,0,0,254,85,95,240,11,244,31,224,0,0,255,255,255,240,3,248,47,192,0,0,255,255,255,240,3,252,63,192,0,0,255,255,255,240,1,253,191,128,0,0,254,0,11,240,0,255,255,0,0,0,254,0,11,240,0,191,254,0,0,0,254,0,11,240,0,63,252,0,0,0,254,0,11,240,0,47,248,0,0,0,254,0,111,240,0,47,244,0,0,0,255,255,255,240,0,127,253,0,0,191,255,255,255,240,0,255,255,0,0,191,255,255,255,240,3,255,255,192,0,127,255,229,11,240,15,252,127,240,0,62,80,0,11,240,127,240,31,252,0,0,0,0,11,242,255,192,11,255,128,0,0,0,11,255,255,64,2,255,224,0,0,0,11,243,248,0,0,127,192,0,0,0,11,241,208,0,0,15,0,0,0,0,11,224,0,0,0,0,0,
  // 0x53f0  台
  240,83,36,38,86,40,2,252,0,0,0,120,0,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,253,0,0,16,0,0,0,0,11,252,0,0,184,0,0,0,0,15,244,0,3,254,0,0,0,0,47,224,0,2,255,192,0,0,0,63,192,0,0,191,240,0,0,0,255,64,0,0,31,252,0,0,1,255,0,0,0,7,255,0,0,3,254,86,170,191,255,255,128,127,255,255,255,255,255,255,255,224,127,255,255,255,255,255,255,255,244,63,255,255,255,255,255,234,175,252,63,250,169,85,0,0,0,3,255,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,0,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,170,170,170,170,170,164,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,234,170,170,170,171,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,192,0,0,0,3,252,0,0,42,128,0,0,0,2,168,0,
  // 0x5408  合
  8,84,38,38,124,40,1,252,0,0,0,0,106,128,0,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,0,2,255,244,0,0,0,0,0,0,0,7,255,252,0,0,0,0,0,0,0,31,251,255,0,0,0,0,0,0,0,63,240,255,192,0,0,0,0,0,0,255,192,127,240,0,0,0,0,0,3,255,64,31,252,0,0,0,0,0,15,253,0,7,255,64,0,0,0,0,127,244,0,1,255,208,0,0,0,1,255,208,0,0,127,248,0,0,0,11,255,64,0,0,15,255,64,0,0,63,253,0,0,0,3,255,224,0,2,255,249,85,85,85,85,255,254,0,31,255,127,255,255,255,255,223,255,208,127,252,63,255,255,255,255,195,255,208,47,208,63,255,255,255,255,192,127,128,15,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,85,85,85,85,85,84,0,0,0,3,255,255,255,255,255,253,0,0,0,3,255,255,255,255,255,253,0,0,0,3,255,255,255,255,255,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,244,0,0,0,1,253,0,0,0,3,255,255,255,255,255,253,0,0,0,3,255,255,255,255,255,253,0,0,0,3,255,255,255,255,255,253,0,0,0,3,249,85,85,85,86,253,0,0,0,3,244,0,0,0,1,253,0,0,
  // 0x5426  否
  38,84,37,36,104,40,1,252,5,85,85,85,85,85,85,85,85,0,15,255,255,255,255,255,255,255,255,64,15,255,255,255,255,255,255,255,255,64,15,255,255,255,255,255,255,255,255,64,0,0,0,0,15,252,0,0,0,0,0,0,0,0,127,244,0,0,0,0,0,0,0,1,255,208,0,0,0,0,0,0,0,11,255,192,0,0,0,0,0,0,0,127,255,193,253,0,0,0,0,0,2,255,255,199,255,208,0,0,0,0,47,255,191,194,255,248,0,0,0,2,255,252,63,192,47,255,128,0,0,47,255,224,63,192,2,255,244,0,7,255,255,0,63,192,0,63,255,0,127,255,244,0,63,192,0,7,255,192,47,255,64,0,63,192,0,0,191,64,15,244,0,0,63,192,0,0,29,0,2,0,0,0,63,192,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,255,64,0,0,15,255,255,255,255,255,255,64,0,0,15,255,255,255,255,255,255,64,0,0,15,240,0,0,0,0,255,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,191,64,0,0,15,240,0,0,0,0,255,64,0,0,15,255,255,255,255,255,255,64,0,0,15,255,255,255,255,255,255,64,0,0,15,255,255,255,255,255,255,64,0,0,15,240,0,0,0,0,191,64,0,0,15,224,0,0,0,0,170,0,0,
  // 0x544a  告
  74,84,36,39,95,40,2,251,0,0,0,0,42,128,0,0,0,0,3,248,0,63,192,0,0,0,0,3,252,0,63,192,0,0,0,0,11,248,0,63,192,0,0,0,0,15,240,0,63,192,0,0,0,0,31,224,0,63,192,0,0,0,0,63,255,255,255,255,255,255,128,0,191,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,128,3,254,85,85,127,213,85,85,64,11,252,0,0,63,192,0,0,0,31,244,0,0,63,192,0,0,0,63,224,0,0,63,192,0,0,0,7,192,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,21,85,85,85,85,85,85,85,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,252,0,0,47,255,255,255,255,255,252,0,0,47,255,255,255,255,255,252,0,0,47,229,85,85,85,87,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,47,213,85,85,85,87,252,0,0,47,255,255,255,255,255,252,0,0,47,255,255,255,255,255,252,0,0,47,255,255,255,255,255,252,0,0,47,192,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,0,0,0,0,0,0,0,0,
  // 0x547d  命
  125,84,38,38,124,40,1,252,0,0,0,0,191,192,0,0,0,0,0,0,0,1,255,240,0,0,0,0,0,0,0,3,255,252,0,0,0,0,0,0,0,15,255,255,0,0,0,0,0,0,0,63,241,255,192,0,0,0,0,0,1,255,208,191,240,0,0,0,0,0,7,255,64,47,253,0,0,0,0,0,47,253,0,7,255,128,0,0,0,0,255,240,0,1,255,244,0,0,0,7,255,192,0,0,63,254,0,0,0,47,255,85,85,85,95,255,208,0,2,255,247,255,255,255,253,255,253,0,47,255,131,255,255,255,252,47,255,224,255,253,3,255,255,255,252,3,255,224,63,224,0,0,0,0,0,0,127,192,30,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,192,255,255,255,240,0,0,191,255,255,192,255,255,255,240,0,0,191,255,255,192,255,255,255,240,0,0,191,0,47,192,254,85,91,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,190,0,31,192,254,0,7,240,0,0,191,255,255,192,254,0,7,240,0,0,191,255,255,192,254,0,11,240,0,0,191,255,255,192,254,15,255,240,0,0,191,0,0,0,254,15,255,240,0,0,190,0,0,0,254,11,255,192,0,0,190,0,0,0,254,1,80,0,0,0,106,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,
  // 0x548c  和
  140,84,35,37,77,40,1,252,0,0,0,31,192,0,0,0,0,0,0,27,255,240,0,0,0,0,1,175,255,255,244,0,0,0,0,31,255,255,254,64,255,255,255,252,15,255,255,64,0,255,255,255,252,11,164,191,64,0,255,255,255,252,0,0,127,64,0,255,170,171,252,0,0,127,64,0,254,0,2,252,0,0,127,64,0,254,0,2,252,0,0,127,64,0,254,0,2,252,0,0,127,64,0,254,0,2,252,63,255,255,255,248,254,0,2,252,63,255,255,255,248,254,0,2,252,63,255,255,255,248,254,0,2,252,21,86,255,149,84,254,0,2,252,0,3,255,64,0,254,0,2,252,0,3,255,208,0,254,0,2,252,0,11,255,240,0,254,0,2,252,0,15,255,252,0,254,0,2,252,0,31,255,255,0,254,0,2,252,0,63,255,191,128,254,0,2,252,0,127,127,111,208,254,0,2,252,0,253,127,79,240,254,0,2,252,2,252,127,71,244,254,0,2,252,7,248,127,66,224,254,0,2,252,15,240,127,64,192,254,0,2,252,47,208,127,64,0,254,0,2,252,191,192,127,64,0,254,0,2,252,127,64,127,64,0,255,255,255,252,62,0,127,64,0,255,255,255,252,28,0,127,64,0,255,255,255,252,0,0,127,64,0,255,170,171,252,0,0,127,64,0,254,0,2,252,0,0,127,64,0,254,0,2,252,0,0,127,64,0,254,0,1,168,0,0,127,64,0,0,0,0,0,0,0,106,0,0,0,0,0,0,
  // 0x555f  啟
  95,85,38,39,134,40,1,251,0,0,5,0,0,0,25,64,0,0,0,0,191,0,0,0,47,192,0,0,0,0,63,64,0,0,63,128,0,0,0,0,63,192,0,0,63,64,0,0,0,0,31,192,0,0,63,64,0,0,0,85,95,229,84,0,127,0,0,0,2,255,255,255,252,0,191,0,0,0,2,255,255,255,252,0,254,0,0,0,2,255,255,255,252,0,255,255,255,192,2,248,0,0,252,1,255,255,255,192,2,248,0,0,252,2,255,255,255,192,2,248,0,0,252,3,249,86,254,64,2,248,0,0,252,11,248,1,252,0,2,248,0,0,252,15,248,1,252,0,2,253,85,85,252,31,252,2,252,0,2,255,255,255,252,63,252,3,248,0,2,255,255,255,252,191,253,3,248,0,2,255,255,255,253,255,253,3,244,0,2,248,0,0,0,126,126,7,240,0,3,248,0,0,0,28,63,11,240,0,3,248,0,0,0,0,63,79,224,0,3,248,0,0,0,0,47,143,208,0,3,247,255,255,255,0,31,239,192,0,3,247,255,255,255,0,15,255,192,0,3,247,255,255,255,0,11,255,64,0,7,243,240,0,191,0,7,255,0,0,7,243,240,0,191,0,3,254,0,0,11,243,240,0,191,0,3,253,0,0,15,227,240,0,191,0,7,254,0,0,15,211,240,0,191,0,15,255,64,0,31,195,240,0,191,0,63,255,192,0,47,195,240,0,191,0,191,239,240,0,63,195,255,255,255,2,255,15,248,0,127,67,255,255,255,11,253,3,254,0,191,3,255,255,255,63,248,1,255,192,30,3,240,0,191,127,224,0,127,208,0,3,240,0,106,47,64,0,15,64,0,1,80,0,0,12,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  // 0x55ae  單
  174,85,36,37,77,40,2,252,1,85,85,85,64,85,85,85,64,3,255,255,255,130,255,255,255,192,3,255,255,255,130,255,255,255,192,3,244,0,63,130,252,0,31,192,3,244,0,63,130,252,0,31,192,3,244,0,63,130,252,0,31,192,3,249,85,127,130,253,85,111,192,3,255,255,255,130,255,255,255,192,3,255,255,255,130,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,254,0,0,191,0,0,191,0,0,254,0,0,191,0,0,191,170,171,255,170,170,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,254,0,0,191,0,0,191,0,0,254,0,0,191,0,0,191,0,0,254,0,0,191,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,1,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,169,0,0,0,0,
  // 0x5634  嘴
  52,86,36,38,86,40,3,252,0,0,0,0,252,0,248,0,0,0,0,0,0,252,0,252,0,0,0,0,0,80,252,0,252,0,0,85,85,65,240,252,0,252,11,192,255,255,209,240,254,168,252,127,240,255,255,209,240,255,252,255,255,64,255,255,209,240,255,252,255,248,0,248,11,209,240,252,0,255,64,0,248,11,209,240,252,0,252,0,0,248,11,209,240,252,0,252,0,116,248,11,209,240,253,188,252,0,125,248,11,210,251,255,252,252,0,188,248,11,239,255,255,252,255,255,252,248,11,239,255,255,64,191,255,244,248,11,223,148,255,0,26,170,144,248,11,208,2,255,255,248,0,0,248,11,208,7,255,255,254,0,0,248,11,208,15,245,87,252,0,0,248,11,208,63,192,7,244,0,0,248,11,209,255,213,95,245,85,64,248,11,219,255,255,255,255,255,192,248,11,255,255,255,255,255,255,192,253,91,239,255,128,47,64,31,192,255,255,215,127,128,47,64,31,192,255,255,208,63,128,47,128,31,192,255,255,208,63,255,255,255,255,192,248,0,0,63,255,255,255,255,192,248,0,0,63,64,47,64,31,192,248,0,0,63,64,47,64,31,192,84,0,0,127,149,127,149,111,192,0,0,0,191,255,255,255,255,192,0,0,0,255,255,255,255,255,192,0,0,1,253,0,0,0,31,192,0,0,7,252,0,0,0,31,192,0,0,31,244,0,0,0,31,192,0,0,191,224,0,0,127,255,192,0,0,63,128,0,0,63,255,128,0,0,9,0,0,0,31,169,0,
  // 0x5668  器
  104,86,38,36,104,40,1,252,0,255,255,255,192,63,255,255,244,0,0,255,255,255,192,63,255,255,244,0,0,255,255,255,192,63,255,255,244,0,0,252,0,47,192,63,64,7,244,0,0,252,0,47,192,63,64,7,244,0,0,252,0,47,192,63,64,7,244,0,0,252,0,47,192,63,64,7,244,0,0,252,0,47,192,63,64,7,244,0,0,255,255,255,192,63,255,255,244,0,0,255,255,255,192,63,255,255,244,0,0,255,255,255,253,63,255,255,244,0,0,0,0,0,255,0,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,0,7,252,0,0,0,0,0,63,255,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,255,192,5,85,91,255,85,95,253,85,85,64,0,0,47,252,0,3,255,64,0,0,0,0,255,240,0,1,255,224,0,0,0,11,255,208,0,0,127,253,0,0,1,191,255,0,0,0,15,255,224,0,31,255,248,0,0,0,3,255,255,64,191,255,255,255,192,127,255,255,255,224,47,255,255,255,192,127,255,255,255,192,14,191,255,255,192,127,255,255,235,0,0,190,0,15,192,127,0,15,224,0,0,190,0,15,192,127,0,15,224,0,0,190,0,15,192,127,0,15,224,0,0,190,0,15,192,127,0,15,224,0,0,190,0,15,192,127,0,15,224,0,0,191,255,255,192,127,255,255,224,0,0,191,255,255,192,127,255,255,224,0,0,191,255,255,192,127,255,255,224,0,0,190,0,31,192,127,0,15,224,0,0,106,0,15,192,127,0,10,144,0,
  // 0x5674  噴
  116,86,36,38,86,40,3,252,0,0,0,0,0,47,128,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,47,128,0,0,0,0,0,191,255,255,255,255,224,85,85,80,191,255,255,255,255,224,255,255,240,106,170,191,234,170,144,255,255,240,0,0,47,128,0,0,255,255,240,2,248,47,130,244,0,252,3,240,2,248,47,130,244,0,252,3,246,171,254,170,171,254,168,252,3,247,255,255,255,255,255,253,252,3,247,255,255,255,255,255,253,252,3,240,2,248,0,2,244,0,252,3,240,2,248,0,2,244,0,252,3,240,0,0,0,0,0,0,252,3,240,63,255,255,255,255,128,252,3,240,63,255,255,255,255,128,252,3,240,63,128,0,0,63,128,252,3,240,63,128,0,0,63,128,252,3,240,63,128,0,0,63,128,252,3,240,63,255,255,255,255,128,252,3,240,63,255,255,255,255,128,252,3,240,63,128,0,0,63,128,255,255,240,63,128,0,0,63,128,255,255,240,63,128,0,0,63,128,255,255,240,63,255,255,255,255,128,253,85,80,63,255,255,255,255,128,252,0,0,63,128,0,0,63,128,252,0,0,63,128,0,0,63,128,168,0,0,63,255,255,255,255,128,0,0,0,63,255,255,255,255,128,0,0,0,0,185,0,31,144,0,0,0,0,2,255,64,63,244,0,0,0,0,111,253,0,31,255,0,0,0,27,255,240,0,1,255,224,0,0,127,255,64,0,0,47,253,0,0,31,228,0,0,0,7,248,0,0,10,0,0,0,0,0,128,
  // 0x56de  回
  222,86,34,36,68,40,3,252,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,63,255,255,255,128,31,224,191,0,63,255,255,255,128,31,224,191,0,63,255,255,255,128,31,224,191,0,63,149,85,127,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,128,0,63,128,31,224,191,0,63,255,255,255,128,31,224,191,0,63,255,255,255,128,31,224,191,0,63,255,255,255,128,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,31,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,149,85,85,85,85,85,111,224,191,0,0,0,0,0,0,31,224,191,0,0,0,0,0,0,15,224,
  // 0x56e0  因
  224,86,34,36,68,40,3,252,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,170,170,170,170,170,170,175,240,191,0,0,0,0,0,0,15,240,191,0,0,3,248,0,0,15,240,191,0,0,3,248,0,0,15,240,191,0,0,3,244,0,0,15,240,191,0,0,3,244,0,0,15,240,191,0,0,3,244,0,0,15,240,191,0,0,3,244,0,0,15,240,191,15,255,255,255,255,255,15,240,191,15,255,255,255,255,255,15,240,191,15,255,255,255,255,255,15,240,191,5,85,95,254,85,85,15,240,191,0,0,15,254,0,0,15,240,191,0,0,15,255,0,0,15,240,191,0,0,31,255,0,0,15,240,191,0,0,63,255,128,0,15,240,191,0,0,127,159,208,0,15,240,191,0,0,255,15,240,0,15,240,191,0,1,255,11,248,0,15,240,191,0,7,252,3,254,0,15,240,191,0,31,244,0,255,128,15,240,191,0,255,224,0,191,244,15,240,191,11,255,128,0,47,255,15,240,191,15,254,0,0,7,254,15,240,191,7,224,0,0,0,252,15,240,191,2,64,0,0,0,20,15,240,191,0,0,0,0,0,0,15,240,191,170,170,170,170,170,170,175,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,0,0,0,0,0,0,15,240,191,0,0,0,0,0,0,15,224,
  // 0x56fa  固
  250,86,34,36,68,40,3,252,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,149,85,85,85,85,85,111,224,191,0,0,0,0,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,11,255,255,255,255,255,15,224,191,11,255,255,255,255,255,15,224,191,11,255,255,255,255,255,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,0,3,248,0,0,15,224,191,0,127,255,255,255,224,15,224,191,0,127,255,255,255,224,15,224,191,0,127,255,255,255,224,15,224,191,0,127,0,0,15,224,15,224,191,0,127,0,0,15,224,15,224,191,0,127,0,0,15,224,15,224,191,0,127,0,0,15,224,15,224,191,0,127,255,255,255,224,15,224,191,0,127,255,255,255,224,15,224,191,0,127,255,255,255,224,15,224,191,0,0,0,0,0,0,15,224,191,0,0,0,0,0,0,15,224,191,0,0,0,0,0,0,15,224,191,149,85,85,85,85,85,111,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,0,0,0,0,0,0,15,224,127,0,0,0,0,0,0,15,224,
  // 0x5716  圖
  22,87,34,36,68,40,3,252,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,0,0,0,0,0,0,15,240,191,0,0,0,0,0,0,15,240,191,0,63,255,255,255,192,15,240,191,0,63,255,255,255,192,15,240,191,0,63,0,0,31,192,15,240,191,0,63,0,0,31,192,15,240,191,0,63,255,255,255,192,15,240,191,0,63,255,255,255,192,15,240,191,0,0,2,244,0,0,15,240,191,0,0,3,248,0,0,15,240,191,47,255,255,255,255,255,143,240,191,47,255,255,255,255,255,143,240,191,0,0,0,0,0,0,15,240,191,0,255,255,255,255,240,15,240,191,0,255,255,255,255,240,15,240,191,0,248,0,0,3,240,15,240,191,0,248,0,0,3,240,15,240,191,0,248,63,255,195,240,15,240,191,0,248,63,255,195,240,15,240,191,0,248,60,3,195,240,15,240,191,0,248,60,3,195,240,15,240,191,0,248,63,255,195,240,15,240,191,0,248,63,255,195,240,15,240,191,0,248,0,0,3,240,15,240,191,0,255,255,255,255,240,15,240,191,0,255,255,255,255,240,15,240,191,0,0,0,0,0,0,15,240,191,0,0,0,0,0,0,15,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,0,0,0,0,0,0,15,240,106,0,0,0,0,0,0,10,160,
  // 0x5728  在
  40,87,37,38,124,40,1,252,0,0,0,10,64,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,127,128,0,0,0,0,0,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,26,170,171,254,170,170,170,170,170,64,0,0,15,244,0,0,0,0,0,0,0,0,31,240,0,1,80,0,0,0,0,0,63,208,0,7,244,0,0,0,0,0,127,192,0,7,244,0,0,0,0,0,255,64,0,7,244,0,0,0,0,3,254,0,0,7,244,0,0,0,0,11,252,0,0,7,244,0,0,0,0,31,244,0,0,7,244,0,0,0,0,127,240,0,0,7,244,0,0,0,1,255,240,15,255,255,255,255,252,0,7,255,240,15,255,255,255,255,252,0,47,255,240,15,255,255,255,255,252,0,127,251,240,5,85,91,249,85,84,0,63,203,240,0,0,7,244,0,0,0,31,11,240,0,0,7,244,0,0,0,8,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,0,0,7,244,0,0,0,0,11,240,21,85,91,249,85,85,0,0,11,240,127,255,255,255,255,255,64,0,11,240,127,255,255,255,255,255,64,0,11,240,127,255,255,255,255,255,64,0,11,240,0,0,0,0,0,0,0,
  // 0x578b  型
  139,87,36,37,77,40,2,253,0,0,0,0,0,0,0,5,80,5,85,85,85,85,0,0,11,240,15,255,255,255,255,2,160,11,240,15,255,255,255,255,3,244,11,240,15,255,255,255,255,3,244,11,240,0,31,192,63,128,3,244,11,240,0,31,192,63,128,3,244,11,240,0,31,192,63,128,3,244,11,240,0,31,192,63,128,3,244,11,240,0,31,192,63,128,3,244,11,240,127,255,255,255,255,195,244,11,240,127,255,255,255,255,195,244,11,240,127,255,255,255,255,195,244,11,240,21,127,149,127,213,67,244,11,240,0,63,64,63,128,3,244,11,240,0,191,0,63,128,3,244,11,240,0,255,0,63,128,0,0,11,240,2,253,0,63,128,0,0,11,240,11,252,0,63,128,0,0,15,240,47,244,0,63,128,0,63,255,224,191,224,0,63,128,0,31,255,208,47,64,0,63,234,0,15,255,64,9,0,0,0,255,0,5,64,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,85,85,85,255,85,85,85,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,85,85,85,85,85,
  // 0x57f7  執
  247,87,38,39,134,40,1,251,0,0,253,0,0,3,244,0,0,0,0,0,253,0,0,3,244,0,0,0,0,0,253,0,0,3,244,0,0,0,0,0,253,0,0,3,244,0,0,0,15,255,255,255,192,3,244,0,0,0,15,255,255,255,192,3,244,0,0,0,15,255,255,255,192,3,244,0,0,0,0,0,254,0,0,3,244,0,0,0,0,0,253,0,15,255,255,255,240,0,0,0,253,0,15,255,255,255,240,0,0,0,253,0,15,255,255,255,240,0,127,255,255,255,255,255,249,95,240,0,127,255,255,255,248,3,244,11,240,0,127,255,255,255,248,3,244,11,240,0,1,244,0,63,64,3,244,11,240,0,1,252,0,63,0,3,244,11,240,0,0,252,0,127,0,3,244,11,240,0,0,189,0,253,3,67,244,11,240,0,0,126,0,252,15,231,240,11,240,0,0,126,1,248,47,255,240,11,240,0,47,255,255,255,243,255,240,11,240,0,47,255,255,255,240,191,240,11,240,0,47,255,255,255,240,31,253,11,240,0,0,0,253,0,0,15,255,75,240,0,0,0,253,0,0,31,255,219,240,0,0,0,253,0,0,63,255,255,240,0,0,0,254,0,0,63,143,251,240,0,15,255,255,255,208,191,67,199,240,0,15,255,255,255,208,255,0,71,240,128,15,255,255,255,210,254,0,3,240,224,0,0,253,0,3,252,0,3,240,240,0,0,253,0,15,244,0,3,245,240,0,0,253,0,47,240,0,3,249,240,0,0,253,0,191,192,0,2,254,224,0,0,253,2,255,64,0,1,255,224,0,0,253,11,254,0,0,0,255,208,0,0,253,1,244,0,0,0,127,192,0,0,169,0,80,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,
  // 0x584a  塊
  74,88,38,38,124,40,1,252,0,10,128,0,0,7,232,0,0,0,0,31,192,0,0,15,244,0,0,0,0,31,192,0,0,15,240,0,0,0,0,31,192,0,0,47,208,0,0,0,0,31,192,15,255,255,255,255,254,0,0,31,192,15,255,255,255,255,254,0,0,31,192,15,255,255,255,255,254,0,0,31,192,15,224,3,244,0,254,0,0,31,192,15,208,3,244,0,254,0,63,255,255,207,208,3,244,0,254,0,63,255,255,207,208,3,244,0,254,0,63,255,255,207,255,255,255,255,254,0,26,175,234,143,255,255,255,255,254,0,0,31,192,15,255,255,255,255,254,0,0,31,192,15,208,3,244,0,254,0,0,31,192,15,208,3,244,0,254,0,0,31,192,15,208,3,244,0,254,0,0,31,192,15,208,3,244,0,254,0,0,31,192,15,255,255,255,255,254,0,0,31,192,15,255,255,255,255,254,0,0,31,192,15,255,255,255,255,254,0,0,31,192,0,31,209,252,4,0,0,0,31,199,208,31,193,252,31,64,0,0,31,255,224,47,193,252,47,0,0,0,47,255,240,47,193,252,63,45,0,6,255,255,128,63,193,252,61,62,0,127,255,248,0,63,129,252,124,31,0,127,255,64,0,63,129,252,190,191,128,63,228,0,0,191,65,254,255,255,192,46,0,0,0,255,1,253,255,235,192,0,0,0,2,254,1,252,80,2,0,0,0,0,7,252,1,252,0,10,0,0,0,0,47,248,1,252,0,11,208,0,0,1,255,240,1,253,0,15,208,0,0,31,255,192,0,255,255,255,192,0,0,47,254,0,0,255,255,255,192,0,0,15,244,0,0,63,255,255,0,0,0,3,64,0,0,0,0,0,0,
  // 0x586b  填
  107,88,38,38,124,40,1,252,0,0,0,0,0,3,248,0,0,0,0,31,192,0,0,3,248,0,0,0,0,31,192,0,0,3,248,0,0,0,0,31,192,63,255,255,255,255,255,192,0,31,192,63,255,255,255,255,255,192,0,31,192,63,255,255,255,255,255,192,0,31,192,0,0,3,248,0,0,0,0,31,192,0,0,3,248,0,0,0,0,31,192,0,0,3,248,0,0,0,0,31,192,0,255,255,255,255,240,0,63,255,255,192,255,255,255,255,240,0,63,255,255,192,254,85,85,95,240,0,63,255,255,192,253,0,0,11,240,0,26,175,234,128,253,85,85,91,240,0,0,31,192,0,255,255,255,255,240,0,0,31,192,0,255,255,255,255,240,0,0,31,192,0,253,0,0,11,240,0,0,31,192,0,253,0,0,11,240,0,0,31,192,0,255,255,255,255,240,0,0,31,192,0,255,255,255,255,240,0,0,31,192,0,254,85,85,95,240,0,0,31,192,0,253,0,0,11,240,0,0,31,192,0,254,85,85,95,240,0,0,31,199,208,255,255,255,255,240,0,0,31,255,224,255,255,255,255,240,0,0,47,255,240,0,0,0,0,0,0,2,255,255,128,0,0,0,0,0,0,127,255,249,255,255,255,255,255,255,208,127,255,64,255,255,255,255,255,255,208,63,244,0,255,255,255,255,255,255,208,46,64,0,0,1,0,0,96,0,0,0,0,0,0,15,228,1,252,0,0,0,0,0,0,127,240,3,255,128,0,0,0,0,7,255,128,0,191,244,0,0,0,0,191,253,0,0,15,254,0,0,0,3,255,224,0,0,2,255,192,0,0,0,255,64,0,0,0,127,128,0,0,0,36,0,0,0,0,8,0,
  // 0x588a  墊
  138,88,38,37,114,40,1,253,0,0,169,0,0,0,168,0,0,0,0,0,254,0,0,1,252,0,0,0,0,0,254,0,0,1,252,0,0,0,11,255,255,255,208,1,252,0,0,0,11,255,255,255,208,1,252,0,0,0,6,170,255,170,130,255,255,255,208,0,0,0,254,0,2,255,255,255,208,0,0,0,255,85,86,255,255,255,208,0,127,255,255,255,248,1,252,15,208,0,127,255,255,255,248,2,248,15,208,0,42,254,170,191,164,2,248,15,208,0,0,252,0,126,1,211,248,15,208,0,0,189,0,252,3,255,244,15,208,0,42,191,170,254,171,255,240,15,208,0,63,255,255,255,248,127,244,15,208,0,63,255,255,255,248,15,254,11,224,0,0,0,254,0,0,15,255,203,224,0,0,0,254,0,0,47,255,235,225,64,6,170,255,170,144,127,75,199,225,208,15,255,255,255,224,255,2,7,241,224,15,255,255,255,227,253,0,3,242,224,0,0,254,0,15,248,0,3,251,224,0,0,254,0,63,240,0,2,255,208,0,0,254,0,15,128,0,0,255,192,0,0,254,0,63,128,0,0,63,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,63,255,255,255,255,255,255,192,0,0,63,255,255,255,255,255,255,192,0,0,63,255,255,255,255,255,255,192,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,47,255,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,255,192,
  // 0x5916  外
  22,89,38,38,124,40,1,252,0,0,25,0,0,0,26,144,0,0,0,0,63,192,0,0,31,208,0,0,0,0,63,192,0,0,31,208,0,0,0,0,127,64,0,0,31,208,0,0,0,0,191,0,0,0,31,208,0,0,0,0,255,0,0,0,31,208,0,0,0,1,255,170,169,0,31,208,0,0,0,3,255,255,255,192,31,208,0,0,0,7,255,255,255,192,31,208,0,0,0,11,255,255,255,192,31,208,0,0,0,15,240,0,63,228,31,208,0,0,0,63,208,0,127,252,31,208,0,0,0,127,192,0,127,254,31,208,0,0,0,255,64,0,191,191,95,208,0,0,2,255,0,0,255,63,239,208,0,0,7,255,0,0,253,31,255,208,0,0,15,255,208,2,252,11,255,208,0,0,63,255,252,3,252,3,255,208,0,0,191,223,255,71,248,0,255,208,0,0,47,66,255,235,240,0,127,240,0,0,6,0,63,255,240,0,31,252,0,0,0,0,11,255,208,0,31,255,64,0,0,0,2,255,192,0,31,255,224,0,0,0,0,255,64,0,31,255,252,0,0,0,1,255,0,0,31,239,255,128,0,0,3,253,0,0,31,211,255,240,0,0,11,252,0,0,31,208,191,192,0,0,31,244,0,0,31,208,15,64,0,0,63,224,0,0,31,208,1,0,0,0,255,192,0,0,31,208,0,0,0,3,255,0,0,0,31,208,0,0,0,31,253,0,0,0,31,208,0,0,0,127,244,0,0,0,31,208,0,0,3,255,208,0,0,0,31,208,0,0,31,255,64,0,0,0,31,208,0,0,15,252,0,0,0,0,31,208,0,0,3,224,0,0,0,0,31,208,0,0,0,64,0,0,0,0,26,144,0,0,
  // 0x591a  多
  26,89,34,38,86,40,3,252,0,0,0,6,64,0,0,0,0,0,0,0,31,248,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,11,255,255,255,254,0,0,0,0,63,255,255,255,255,128,0,0,2,255,255,255,255,255,0,0,0,47,255,0,0,3,252,0,0,2,255,252,0,0,15,248,0,0,127,255,255,128,0,63,224,0,0,127,249,191,244,1,255,128,0,0,31,128,31,255,11,254,0,0,0,4,0,2,255,255,248,0,0,0,0,0,0,63,255,208,0,0,0,0,0,0,47,255,121,0,0,0,0,0,7,255,244,255,192,0,0,0,0,191,255,131,255,0,0,0,0,111,255,248,31,253,0,0,0,111,255,255,128,191,255,255,255,208,255,255,228,7,255,255,255,255,240,127,249,0,63,255,255,255,255,224,62,64,2,255,224,0,0,127,192,0,0,111,255,64,0,0,255,128,0,7,255,255,128,0,2,255,0,0,191,255,255,244,0,11,252,0,0,63,248,31,254,0,47,244,0,0,31,128,3,255,192,191,224,0,0,4,0,0,127,247,255,128,0,0,0,0,0,15,255,253,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,31,255,192,0,0,0,0,0,2,255,253,0,0,0,0,0,1,191,255,224,0,0,0,0,1,191,255,254,0,0,0,0,3,255,255,255,208,0,0,0,0,2,255,255,248,0,0,0,0,0,0,255,249,0,0,0,0,0,0,0,165,0,0,0,0,0,0,0,
  // 0x5920  夠
  32,89,36,38,86,40,2,252,0,2,144,0,0,25,0,0,0,0,7,240,0,0,47,192,0,0,0,15,224,0,0,63,128,0,0,0,47,192,0,0,127,0,0,0,0,127,255,254,0,191,0,0,0,0,255,255,255,64,254,0,0,0,3,255,255,255,2,255,255,255,253,15,244,0,254,3,255,255,255,253,63,208,1,252,11,255,255,255,252,255,128,3,248,15,224,0,1,252,190,56,11,240,47,192,0,0,252,56,255,31,224,63,128,0,0,252,0,127,255,192,255,64,0,0,252,0,31,255,2,255,0,0,0,252,0,11,253,3,254,255,255,208,252,0,47,244,0,181,255,255,208,252,1,255,254,64,17,255,255,208,252,47,254,255,0,1,248,11,209,252,127,245,253,0,1,248,11,209,252,47,67,255,255,209,248,11,209,252,4,15,255,255,241,248,11,209,252,0,63,255,255,225,248,11,209,252,1,255,0,31,193,248,11,209,252,11,252,0,63,193,248,11,209,252,127,240,0,127,65,248,11,209,252,255,199,0,255,1,255,255,210,252,62,31,210,253,1,255,255,210,252,16,31,255,252,1,255,255,210,248,0,3,255,240,1,248,0,2,248,0,0,255,208,1,248,0,3,248,0,1,255,128,1,248,0,3,244,0,7,254,0,0,0,0,3,244,0,63,248,0,0,0,0,7,244,2,255,224,0,0,0,0,15,240,111,255,64,0,0,0,63,255,240,255,248,0,0,0,0,47,255,208,127,128,0,0,0,0,31,255,64,56,0,0,0,0,0,5,80,0,
  // 0x5927  大
  39,89,36,38,86,40,2,252,0,0,0,0,170,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,253,0,0,0,0,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,253,0,0,0,7,255,192,0,0,0,0,0,0,11,255,224,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,31,255,244,0,0,0,0,0,0,47,231,252,0,0,0,0,0,0,63,211,253,0,0,0,0,0,0,127,193,255,0,0,0,0,0,0,255,128,255,128,0,0,0,0,2,255,0,191,192,0,0,0,0,3,254,0,63,240,0,0,0,0,15,252,0,31,244,0,0,0,0,47,244,0,11,253,0,0,0,0,127,224,0,3,255,0,0,0,1,255,192,0,1,255,192,0,0,11,255,0,0,0,191,244,0,0,47,253,0,0,0,63,253,0,1,255,244,0,0,0,15,255,192,31,255,208,0,0,0,3,255,248,191,255,0,0,0,0,0,191,255,127,248,0,0,0,0,0,31,252,31,128,0,0,0,0,0,2,244,5,0,0,0,0,0,0,0,32,
  // 0x5929  天
  41,89,37,35,94,40,2,252,127,255,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,255,253,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,31,255,255,255,255,255,255,255,244,0,31,255,255,255,255,255,255,255,244,0,31,255,255,255,255,255,255,255,244,0,15,255,255,255,255,255,255,255,244,0,0,0,0,3,255,192,0,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,0,11,255,240,0,0,0,0,0,0,0,15,255,244,0,0,0,0,0,0,0,31,247,252,0,0,0,0,0,0,0,63,227,253,0,0,0,0,0,0,0,191,193,255,0,0,0,0,0,0,2,255,128,255,192,0,0,0,0,0,11,255,0,63,240,0,0,0,0,0,47,252,0,31,252,0,0,0,0,0,255,244,0,11,255,64,0,0,0,7,255,208,0,2,255,224,0,0,0,127,255,0,0,0,255,254,0,0,11,255,248,0,0,0,47,255,228,0,255,255,208,0,0,0,7,255,255,64,191,254,0,0,0,0,0,191,254,0,63,224,0,0,0,0,0,11,252,0,25,0,0,0,0,0,0,0,100,0,
  // 0x5931  失
  49,89,37,38,124,40,2,252,0,0,0,0,254,0,0,0,0,0,0,3,228,0,254,0,0,0,0,0,0,11,248,0,254,0,0,0,0,0,0,15,244,0,254,0,0,0,0,0,0,15,240,0,254,0,0,0,0,0,0,47,224,0,254,0,0,0,0,0,0,63,208,0,254,0,0,0,0,0,0,127,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,255,64,0,1,255,255,255,255,255,255,255,64,0,3,255,255,255,255,255,255,255,64,0,7,252,0,0,254,0,0,0,0,0,15,248,0,0,254,0,0,0,0,0,63,240,0,0,254,0,0,0,0,0,127,208,0,0,254,0,0,0,0,0,31,128,0,1,254,0,0,0,0,0,2,0,0,1,254,0,0,0,0,0,0,0,0,1,254,0,0,0,0,0,170,170,170,171,255,170,170,170,170,0,255,255,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,255,254,0,0,0,0,11,255,208,0,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,0,47,251,248,0,0,0,0,0,0,0,63,211,252,0,0,0,0,0,0,0,255,193,255,0,0,0,0,0,0,2,255,64,255,192,0,0,0,0,0,11,254,0,127,240,0,0,0,0,0,63,252,0,47,252,0,0,0,0,1,255,240,0,11,255,64,0,0,0,11,255,192,0,2,255,224,0,0,0,191,255,0,0,0,255,254,0,0,27,255,248,0,0,0,31,255,248,0,255,255,208,0,0,0,3,255,255,64,191,253,0,0,0,0,0,127,255,0,63,208,0,0,0,0,0,7,252,0,8,0,0,0,0,0,0,0,36,0,
  // 0x59cb  始
  203,89,37,38,124,40,2,252,0,26,64,0,0,10,64,0,0,0,0,47,192,0,0,15,240,0,0,0,0,63,128,0,0,31,240,0,0,0,0,63,128,0,0,47,224,0,0,0,0,63,64,0,0,63,192,0,0,0,0,127,0,0,0,63,192,0,0,0,0,191,0,0,0,127,128,0,0,0,0,254,0,0,0,191,0,125,0,0,85,254,85,144,0,255,0,255,0,0,255,255,255,252,1,253,0,127,192,0,255,255,255,252,2,252,0,47,208,0,255,255,255,248,3,248,0,15,240,0,3,248,3,248,7,244,0,7,248,0,3,244,3,244,11,245,170,255,252,0,7,240,3,247,255,255,255,255,254,0,11,240,7,243,255,255,255,255,255,0,15,224,7,243,255,255,255,234,191,128,15,208,11,241,165,64,0,0,63,128,31,192,15,224,0,0,0,0,44,0,47,192,15,208,0,0,0,0,0,0,63,128,31,192,0,0,0,0,0,0,63,128,47,192,31,255,255,255,248,0,127,240,63,192,31,255,255,255,248,0,191,253,127,64,31,255,255,255,248,0,255,255,255,0,31,213,85,87,248,0,45,191,255,0,31,192,0,3,248,0,4,31,254,0,31,192,0,3,248,0,0,7,255,128,31,192,0,3,248,0,0,11,255,224,31,192,0,3,248,0,0,31,255,248,31,192,0,3,248,0,0,63,219,253,31,192,0,3,248,0,0,255,194,253,31,192,0,3,248,0,3,255,0,184,31,213,85,87,248,0,15,253,0,32,31,255,255,255,248,0,127,244,0,0,31,255,255,255,248,0,127,208,0,0,31,255,255,255,248,0,47,64,0,0,31,192,0,3,248,0,8,0,0,0,31,192,0,2,164,0,
  // 0x5a92  媒
  146,90,38,38,124,40,1,252,0,10,64,0,15,208,0,15,208,0,0,31,192,0,15,208,0,15,208,0,0,47,192,0,15,208,0,15,208,0,0,63,192,0,15,208,0,15,208,0,0,63,128,0,15,208,0,31,208,0,0,63,64,15,255,255,255,255,255,192,0,127,0,15,255,255,255,255,255,192,0,127,0,15,255,255,255,255,255,192,21,255,85,80,15,208,0,15,208,0,127,255,255,244,15,208,0,15,208,0,127,255,255,244,15,208,0,15,208,0,127,255,255,244,15,255,255,255,208,0,1,252,3,240,15,255,255,255,208,0,2,252,3,240,15,255,255,255,208,0,2,248,7,240,15,208,0,15,208,0,3,244,7,240,15,208,0,15,208,0,3,244,11,240,15,208,0,31,208,0,7,240,15,224,15,255,255,255,208,0,11,240,15,208,15,255,255,255,208,0,11,224,15,208,15,255,255,255,208,0,15,208,31,192,0,0,253,0,0,0,15,208,47,192,0,0,253,0,0,0,31,244,63,128,0,0,253,0,0,0,47,254,127,79,255,255,255,255,255,192,63,255,255,15,255,255,255,255,255,192,11,127,255,15,255,255,255,255,255,192,1,15,253,0,0,47,255,224,0,0,0,3,255,0,0,127,255,244,0,0,0,7,255,192,0,255,255,252,0,0,0,15,255,240,3,253,253,255,64,0,0,47,239,248,31,244,253,63,208,0,0,127,195,240,191,224,253,31,248,0,1,255,64,211,255,128,253,7,254,0,7,254,0,111,254,0,253,2,255,208,47,252,0,63,244,0,253,0,191,192,31,240,0,15,208,0,253,0,31,0,11,128,0,6,0,0,253,0,1,0,1,0,0,0,0,0,253,0,0,0,
  // 0x5b50  子
  80,91,36,35,59,40,2,252,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,255,64,0,255,255,255,255,255,255,255,64,0,170,170,170,170,170,191,252,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,191,244,0,0,0,0,0,0,87,255,192,0,0,0,0,0,0,255,254,0,0,0,0,0,0,0,255,244,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,170,170,170,170,255,170,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,191,255,255,0,0,0,0,0,0,63,255,254,0,0,0,0,0,0,47,255,248,0,0,0,0,0,0,31,234,64,0,0,0,0,
  // 0x5b58  存
  88,91,37,38,124,40,1,252,0,0,0,10,64,0,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,26,170,170,255,234,170,170,170,170,64,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,0,0,7,252,0,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,0,191,192,255,255,255,255,208,0,0,0,255,64,255,255,255,255,248,0,0,3,254,0,255,255,255,255,240,0,0,11,252,0,85,85,85,255,192,0,0,31,244,0,0,0,2,255,0,0,0,127,240,0,0,0,11,252,0,0,0,255,240,0,0,0,63,240,0,0,7,255,240,0,0,2,255,128,0,0,31,255,240,0,0,2,254,0,0,0,127,255,240,0,0,2,252,0,0,0,63,219,240,42,170,171,254,170,170,128,47,75,240,127,255,255,255,255,255,192,12,11,240,127,255,255,255,255,255,192,0,11,240,127,255,255,255,255,255,192,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,0,2,252,0,0,0,0,11,240,0,47,255,252,0,0,0,0,11,240,0,31,255,252,0,0,0,0,11,240,0,15,255,240,0,0,0,0,5,80,0,5,85,0,0,0,0,
  // 0x5b89  安
  137,91,36,38,86,40,2,252,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,229,85,85,85,85,85,91,248,47,192,0,0,0,0,0,3,248,47,192,0,10,80,0,0,3,248,47,192,0,31,240,0,0,3,248,47,192,0,47,224,0,0,3,248,47,192,0,63,192,0,0,3,248,0,0,0,191,128,0,0,0,0,0,0,0,255,0,0,0,0,0,106,170,171,255,170,170,170,170,169,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,47,224,0,0,191,64,0,0,0,63,192,0,0,255,0,0,0,0,191,128,0,1,255,0,0,0,0,255,0,0,3,253,0,0,0,3,254,0,0,7,252,0,0,0,7,252,0,0,15,244,0,0,0,15,255,144,0,47,240,0,0,0,31,255,254,64,127,208,0,0,0,63,255,255,249,255,128,0,0,0,47,198,255,255,255,0,0,0,0,0,0,27,255,254,0,0,0,0,0,0,2,255,255,224,0,0,0,0,0,47,255,255,254,64,0,0,0,7,255,253,47,255,244,0,0,22,255,255,224,2,255,254,0,31,255,255,254,0,0,47,255,208,15,255,255,144,0,0,2,255,192,3,255,228,0,0,0,0,127,0,2,148,0,0,0,0,0,9,0,
  // 0x5b8c  完
  140,91,37,38,124,40,1,252,0,0,0,0,42,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,6,170,170,170,191,234,170,170,169,0,15,255,255,255,255,255,255,255,254,0,15,255,255,255,255,255,255,255,254,0,15,255,255,255,255,255,255,255,254,0,15,240,0,0,0,0,0,0,254,0,15,240,0,0,0,0,0,0,254,0,15,240,0,0,0,0,0,0,254,0,15,240,0,0,0,0,0,0,254,0,15,240,191,255,255,255,255,208,254,0,6,160,191,255,255,255,255,208,169,0,0,0,191,255,255,255,255,208,0,0,0,0,21,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,170,170,170,170,170,170,170,170,64,47,255,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,255,128,0,0,3,252,0,31,208,0,0,0,0,0,3,252,0,31,208,0,0,0,0,0,3,252,0,31,208,0,0,0,0,0,7,248,0,31,208,0,0,0,0,0,15,244,0,31,208,0,0,0,0,0,15,240,0,31,208,0,0,0,0,0,63,224,0,31,208,0,30,64,0,0,191,192,0,31,208,0,31,192,0,2,255,128,0,31,208,0,31,192,0,31,255,0,0,31,208,0,47,192,1,255,252,0,0,31,245,85,191,128,127,255,224,0,0,15,255,255,255,64,63,255,64,0,0,11,255,255,255,0,15,244,0,0,0,1,255,255,248,0,5,0,0,0,0,0,0,0,0,0,
  // 0x5b9a  定
  154,91,37,38,124,40,1,252,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,6,170,170,170,191,234,170,170,169,0,11,255,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,255,254,0,11,240,0,0,0,0,0,0,254,0,11,240,0,0,0,0,0,0,254,0,11,240,0,0,0,0,0,0,254,0,11,240,0,0,0,0,0,0,254,0,11,240,170,170,170,170,170,160,254,0,11,240,255,255,255,255,255,244,254,0,0,0,255,255,255,255,255,244,0,0,0,0,255,255,255,255,255,244,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,1,253,0,63,192,0,0,0,0,0,2,253,0,63,192,0,0,0,0,0,3,252,0,63,192,0,0,0,0,0,3,252,0,63,255,255,255,64,0,0,3,248,0,63,255,255,255,64,0,0,7,248,0,63,255,255,255,64,0,0,11,252,0,63,213,85,85,0,0,0,15,253,0,63,192,0,0,0,0,0,31,255,0,63,192,0,0,0,0,0,47,255,128,63,192,0,0,0,0,0,127,255,224,63,192,0,0,0,0,0,255,143,248,63,192,0,0,0,0,1,255,7,255,127,192,0,0,0,0,3,254,1,255,255,192,0,0,0,0,15,252,0,127,255,255,234,170,170,128,63,244,0,15,255,255,255,255,255,128,127,208,0,0,191,255,255,255,255,0,15,128,0,0,5,175,255,255,255,0,2,0,0,0,0,0,0,0,0,0,
  // 0x5ba2  客
  162,91,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,21,85,85,85,255,85,85,85,84,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,192,0,36,0,0,0,3,252,63,192,0,255,128,0,0,3,252,63,192,2,255,0,0,0,3,252,63,192,11,255,255,255,253,3,252,63,192,47,255,255,255,255,131,252,0,0,255,255,255,255,255,64,0,0,11,255,192,0,3,254,0,0,0,127,255,240,0,15,248,0,0,7,255,239,252,0,127,240,0,0,11,255,67,255,66,255,128,0,0,3,248,0,255,255,254,0,0,0,0,128,0,47,255,244,0,0,0,0,0,0,15,255,244,0,0,0,0,0,1,191,255,255,144,0,0,0,0,47,255,255,255,254,64,0,0,6,255,255,65,255,255,255,148,6,255,255,244,0,27,255,255,255,255,255,254,0,0,0,127,255,253,191,255,255,255,255,255,255,255,252,63,231,255,255,255,255,255,208,96,20,3,255,255,255,255,255,208,0,0,3,248,0,0,0,47,208,0,0,3,248,0,0,0,47,208,0,0,3,248,0,0,0,47,208,0,0,3,248,0,0,0,47,208,0,0,3,248,0,0,0,47,208,0,0,3,255,255,255,255,255,208,0,0,3,255,255,255,255,255,208,0,0,3,255,255,255,255,255,208,0,0,3,248,0,0,0,47,208,0,0,2,164,0,0,0,21,64,0,
  // 0x5bb9  容
  185,91,37,38,124,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,5,85,85,85,255,85,85,85,80,0,47,255,255,255,255,255,255,255,248,0,47,255,255,255,255,255,255,255,248,0,47,255,255,255,255,255,255,255,248,0,47,192,0,0,0,0,0,3,248,0,47,192,0,0,0,0,0,3,248,0,47,192,11,144,0,7,128,3,248,0,47,192,31,244,0,47,244,3,248,0,47,128,127,208,0,31,254,3,248,0,0,2,255,128,0,2,255,208,0,0,0,15,254,0,170,0,127,248,0,0,0,127,248,3,255,128,15,254,0,0,7,255,208,11,255,224,2,255,192,0,11,255,0,31,255,248,0,127,208,0,2,248,0,191,231,254,0,31,64,0,0,208,2,255,130,255,192,5,0,0,0,0,11,255,0,191,244,0,0,0,0,0,63,248,0,31,253,0,0,0,0,1,255,224,0,7,255,208,0,0,0,11,255,64,0,0,255,248,0,0,0,127,253,0,0,0,47,255,64,0,7,255,255,255,255,255,255,255,248,0,127,255,255,255,255,255,255,255,255,64,191,251,255,255,255,255,255,219,254,0,63,195,249,85,85,85,111,193,252,0,29,3,248,0,0,0,47,192,20,0,0,3,248,0,0,0,47,192,0,0,0,3,248,0,0,0,47,192,0,0,0,3,248,0,0,0,47,192,0,0,0,3,248,0,0,0,47,192,0,0,0,3,255,255,255,255,255,192,0,0,0,3,255,255,255,255,255,192,0,0,0,3,255,255,255,255,255,192,0,0,0,3,249,85,85,85,111,192,0,0,0,2,164,0,0,0,26,128,0,0,
  // 0x5c0d  對
  13,92,37,39,134,40,2,251,0,10,65,160,0,0,0,42,0,0,4,31,131,240,36,0,0,63,64,0,188,31,131,240,63,64,0,63,64,0,191,31,131,240,191,0,0,63,64,0,63,95,131,240,254,0,0,63,64,0,47,223,131,241,252,0,0,63,64,0,15,223,131,247,244,0,0,63,64,0,15,223,131,247,240,0,0,63,64,0,5,31,131,244,144,0,0,63,64,0,255,255,255,255,255,0,0,63,64,0,255,255,255,255,255,0,0,127,64,0,255,255,255,255,255,255,255,255,255,64,1,176,0,31,128,255,255,255,255,64,3,248,0,47,192,255,255,255,255,64,1,252,0,63,128,85,85,191,149,0,0,253,0,127,0,0,0,63,64,0,0,190,0,190,0,0,0,63,64,0,0,125,0,189,0,1,0,63,64,0,63,255,255,255,248,63,128,63,64,0,63,255,255,255,248,47,192,63,64,0,63,255,255,255,248,15,208,63,64,0,0,0,190,0,0,11,240,63,64,0,0,0,190,0,0,7,244,63,64,0,0,0,190,0,0,3,248,63,64,0,15,255,255,255,240,2,252,63,64,0,15,255,255,255,240,1,253,63,64,0,15,255,255,255,240,0,224,63,64,0,0,0,190,0,0,0,0,63,64,0,0,0,190,0,0,0,0,63,64,0,0,0,190,0,0,0,0,63,64,0,0,0,190,1,174,0,0,63,64,0,0,1,255,255,255,0,0,63,64,0,107,255,255,255,255,0,0,63,64,0,255,255,255,255,254,0,0,127,64,0,255,255,255,233,0,1,85,255,64,0,191,233,64,0,0,3,255,255,0,0,0,0,0,0,0,1,255,254,0,0,0,0,0,0,0,0,255,228,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5c0f  小
  15,92,38,37,114,40,1,252,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,6,80,0,63,192,0,120,0,0,0,11,252,0,63,192,3,252,0,0,0,11,248,0,63,192,2,254,0,0,0,15,244,0,63,192,0,255,0,0,0,15,240,0,63,192,0,191,192,0,0,31,240,0,63,192,0,63,192,0,0,63,224,0,63,192,0,47,224,0,0,63,192,0,63,192,0,31,240,0,0,127,192,0,63,192,0,15,248,0,0,191,128,0,63,192,0,7,252,0,0,255,64,0,63,192,0,3,253,0,2,255,0,0,63,192,0,2,255,0,3,253,0,0,63,192,0,1,255,0,7,252,0,0,63,192,0,0,255,128,15,248,0,0,63,192,0,0,191,192,47,240,0,0,63,192,0,0,63,192,127,208,0,0,63,192,0,0,63,224,47,192,0,0,63,192,0,0,47,240,3,64,0,0,63,192,0,0,31,144,0,0,0,0,63,192,0,0,8,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,31,255,255,192,0,0,0,0,0,0,15,255,255,128,0,0,0,0,0,0,7,255,255,0,0,0,0,0,0,0,3,255,164,0,0,0,0,0,
  // 0x5c31  就
  49,92,38,38,124,40,1,252,0,0,63,128,0,0,63,128,0,0,0,0,63,128,0,0,63,129,128,0,0,0,63,128,0,0,63,143,224,0,0,0,63,128,0,0,63,139,244,0,0,0,63,128,0,0,63,131,253,0,63,255,255,255,255,0,63,128,255,0,63,255,255,255,255,0,63,128,127,64,63,255,255,255,255,0,63,128,63,192,21,85,85,85,85,0,63,128,29,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,170,191,234,170,128,3,255,255,255,244,255,255,255,255,192,3,255,255,255,244,255,255,255,255,192,3,255,255,255,244,255,255,255,255,192,3,248,0,7,244,0,63,128,0,0,3,248,0,3,244,0,63,128,0,0,3,248,0,3,244,0,127,252,0,0,3,248,0,3,244,0,127,252,0,0,3,248,0,3,244,0,191,252,0,0,3,255,255,255,244,0,191,252,0,0,3,255,255,255,244,0,255,252,0,0,3,255,255,255,244,0,255,252,0,0,0,0,63,128,0,1,255,252,0,0,0,0,63,128,0,2,254,252,0,0,1,228,63,135,208,3,253,252,0,0,2,252,63,139,240,3,249,252,0,0,3,248,63,131,244,11,245,252,0,0,7,244,63,130,252,15,241,252,0,0,11,240,63,129,252,31,225,252,2,0,15,224,63,128,254,63,209,252,3,208,31,208,63,128,190,191,193,252,3,224,63,192,63,128,80,255,65,252,3,224,191,64,63,128,3,254,1,252,3,224,47,0,63,128,11,252,1,252,11,208,9,63,255,64,47,244,1,255,255,208,0,31,255,64,127,224,0,255,255,192,0,15,254,0,31,128,0,191,255,64,0,5,64,0,2,0,0,22,164,0,
  // 0x5de5  工
  229,93,36,30,14,40,2,255,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,224,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,170,170,170,170,170,
  // 0x5dee  差
  238,93,36,38,86,40,2,252,0,0,4,0,0,0,36,0,0,0,0,189,0,0,0,191,128,0,0,0,255,0,0,0,255,64,0,0,0,191,128,0,1,254,0,0,0,0,63,192,0,3,252,0,0,0,0,47,224,0,11,248,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,21,85,255,85,85,85,85,85,84,0,1,254,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,3,253,255,255,255,255,255,0,0,7,252,255,255,255,255,255,0,0,11,244,255,255,255,255,255,0,0,15,240,0,2,253,0,0,0,0,47,224,0,2,252,0,0,0,0,127,192,0,2,252,0,0,0,0,255,128,0,2,252,0,0,0,2,255,0,0,2,252,0,0,0,7,253,0,0,2,252,0,0,0,31,248,85,85,86,253,85,85,80,191,240,255,255,255,255,255,255,252,255,192,255,255,255,255,255,255,252,63,0,255,255,255,255,255,255,252,8,0,0,0,0,0,0,0,0,
  // 0x5df2  已
  242,93,34,34,50,40,4,253,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,192,0,170,170,170,170,170,170,191,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,10,144,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,250,170,170,170,170,191,192,0,31,255,255,255,255,255,255,192,0,31,255,255,255,255,255,255,192,0,31,255,255,255,255,255,255,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,63,192,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,4,0,31,224,0,0,0,0,0,15,128,31,224,0,0,0,0,0,15,240,31,224,0,0,0,0,0,15,240,31,224,0,0,0,0,0,15,240,15,224,0,0,0,0,0,47,224,15,240,0,0,0,0,0,63,208,15,249,0,0,0,0,1,255,192,11,255,255,255,255,255,255,255,128,3,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,248,0,0,6,170,170,170,170,170,64,0,
  // 0x5e73  平
  115,94,36,35,59,40,2,252,11,255,255,255,255,255,255,255,224,11,255,255,255,255,255,255,255,224,11,255,255,255,255,255,255,255,224,6,170,170,170,255,170,170,170,144,0,0,0,0,255,0,0,0,0,0,1,64,0,255,0,1,144,0,0,63,192,0,255,0,3,253,0,0,47,192,0,255,0,7,252,0,0,15,224,0,255,0,11,248,0,0,15,240,0,255,0,15,240,0,0,7,248,0,255,0,31,224,0,0,3,252,0,255,0,63,192,0,0,2,253,0,255,0,127,128,0,0,1,254,0,255,0,255,0,0,0,0,248,0,255,0,189,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,254,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,
  // 0x5e8a  床
  138,94,38,38,124,40,1,252,0,0,0,0,5,80,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,170,170,170,175,250,170,170,170,128,0,255,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,255,192,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,127,64,0,0,0,0,254,0,0,0,127,64,0,0,0,0,254,0,0,0,127,64,0,0,0,0,254,0,0,0,127,64,0,0,0,0,254,0,0,0,127,64,0,0,0,0,254,26,170,170,191,170,170,170,64,0,254,47,255,255,255,255,255,255,192,0,254,47,255,255,255,255,255,255,192,0,253,47,255,255,255,255,255,255,192,1,253,0,0,3,255,240,0,0,0,1,253,0,0,15,255,248,0,0,0,1,253,0,0,31,255,253,0,0,0,1,252,0,0,63,255,255,0,0,0,2,252,0,0,255,255,191,192,0,0,2,252,0,2,255,127,111,224,0,0,2,252,0,7,252,127,79,248,0,0,3,252,0,31,244,127,71,254,0,0,3,248,0,127,224,127,65,255,128,0,7,244,1,255,192,127,64,191,224,0,11,240,7,255,0,127,64,47,252,0,11,240,47,252,0,127,64,11,255,64,15,240,255,240,0,127,64,2,255,208,31,224,255,192,0,127,64,0,191,128,47,192,63,0,0,127,64,0,31,0,63,192,8,0,0,127,64,0,4,0,127,128,0,0,0,127,64,0,0,0,31,0,0,0,0,127,64,0,0,0,1,0,0,0,0,127,0,0,0,0,
  // 0x5ea6  度
  166,94,37,38,124,40,1,252,0,0,0,0,11,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,255,255,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,255,128,0,254,85,85,85,85,85,85,85,0,0,253,0,6,160,0,2,160,0,0,0,253,0,11,240,0,7,244,0,0,0,253,0,11,240,0,7,244,0,0,0,253,0,11,240,0,7,244,0,0,0,253,127,255,255,255,255,255,255,64,0,253,127,255,255,255,255,255,255,64,0,253,127,255,255,255,255,255,255,64,0,253,0,11,240,0,7,244,0,0,0,253,0,11,240,0,7,244,0,0,0,253,0,11,240,0,7,244,0,0,0,253,0,11,255,255,255,244,0,0,1,253,0,11,255,255,255,244,0,0,1,253,0,11,255,255,255,244,0,0,1,252,0,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,0,2,252,63,255,255,255,255,255,128,0,2,252,63,255,255,255,255,255,224,0,2,252,63,255,255,255,255,255,192,0,3,248,0,11,208,0,0,255,128,0,3,244,0,15,244,0,3,255,0,0,7,244,0,3,253,0,15,252,0,0,11,240,0,1,255,192,191,240,0,0,11,240,0,0,127,251,255,192,0,0,15,224,0,0,15,255,254,0,0,0,31,208,0,0,31,255,254,0,0,0,47,192,0,27,255,255,255,249,64,0,63,129,191,255,255,230,255,255,255,128,127,64,255,255,254,0,31,255,255,128,31,0,191,254,64,0,0,111,255,0,1,0,41,0,0,0,0,0,105,0,
  // 0x5ee2  廢
  226,94,38,38,124,40,1,252,0,0,0,0,11,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,2,255,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,255,192,2,252,0,0,0,0,0,0,0,0,2,248,0,0,0,1,144,0,0,0,2,248,26,170,170,7,240,45,0,0,2,248,47,255,255,195,244,191,64,0,2,248,47,255,255,65,255,252,0,0,2,248,0,0,191,0,255,208,20,0,2,248,30,1,252,0,63,128,191,0,2,248,63,215,244,0,31,231,253,0,2,248,11,255,224,0,11,255,224,0,2,248,2,255,128,0,1,255,192,0,2,248,11,255,84,10,170,255,249,0,2,248,191,255,252,31,255,255,255,208,2,255,255,255,252,31,255,253,255,192,2,250,248,0,188,31,64,252,27,0,3,248,128,0,188,31,64,252,36,0,3,248,0,0,188,47,64,252,61,0,3,244,31,255,252,127,0,253,189,0,3,244,47,255,254,253,0,255,252,0,3,244,63,170,169,248,0,63,240,0,3,240,63,0,0,16,0,0,0,0,7,240,126,0,0,255,255,255,208,0,7,240,191,255,252,255,255,255,208,0,11,240,255,255,252,91,149,111,192,0,15,224,254,170,252,31,128,63,64,0,15,208,0,1,252,15,208,191,0,0,31,192,0,2,248,3,250,252,0,0,47,192,0,2,244,1,255,244,0,0,63,128,0,3,244,0,255,244,0,0,127,64,0,7,240,31,255,255,144,0,191,0,15,255,243,255,245,255,255,64,30,0,15,255,210,255,64,27,255,0,4,0,6,169,0,144,0,0,24,0,
  // 0x5efa  建
  250,94,38,38,124,40,1,252,0,0,0,0,0,5,80,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,64,0,0,15,240,0,0,0,127,255,253,11,255,255,255,255,244,0,127,255,252,11,255,255,255,255,244,0,127,255,244,11,255,255,255,255,244,0,0,11,240,0,0,15,240,7,244,0,0,15,224,0,0,15,240,7,244,0,0,47,193,255,255,255,255,255,255,208,0,63,129,255,255,255,255,255,255,208,0,127,1,255,255,255,255,255,255,208,0,255,0,0,0,15,240,7,244,0,1,253,0,0,0,15,240,7,244,0,3,252,0,0,0,15,240,7,244,0,7,255,255,79,255,255,255,255,244,0,15,255,255,143,255,255,255,255,244,0,31,255,255,79,255,255,255,255,244,0,47,208,127,64,0,15,240,0,0,0,1,64,127,0,0,15,240,0,0,0,0,0,127,15,255,255,255,255,248,0,1,128,191,15,255,255,255,255,248,0,15,192,254,15,255,255,255,255,248,0,15,208,254,0,0,15,240,0,0,0,11,241,253,0,0,15,240,0,0,0,3,246,252,0,0,15,240,0,0,0,3,255,252,255,255,255,255,255,255,64,1,255,244,255,255,255,255,255,255,64,0,255,240,255,255,255,255,255,255,64,0,63,240,0,0,15,240,0,0,0,0,47,244,0,0,15,240,0,0,0,0,127,255,0,0,15,240,0,0,0,0,255,255,244,0,10,160,0,0,0,2,254,127,255,229,0,0,0,0,0,15,252,11,255,255,255,255,255,255,208,63,244,1,191,255,255,255,255,255,192,63,224,0,6,255,255,255,255,255,128,15,128,0,0,1,85,170,170,170,0,1,0,0,0,0,0,0,0,0,0,
  // 0x5f15  引
  21,95,31,37,40,40,3,252,0,0,0,0,0,0,3,252,63,255,255,255,192,0,3,252,63,255,255,255,192,0,3,252,63,255,255,255,192,0,3,252,21,85,85,111,192,0,3,252,0,0,0,31,192,0,3,252,0,0,0,31,192,0,3,252,0,0,0,31,192,0,3,252,0,0,0,31,192,0,3,252,0,0,0,31,192,0,3,252,15,255,255,255,192,0,3,252,15,255,255,255,192,0,3,252,15,255,255,255,192,0,3,252,31,229,85,85,64,0,3,252,31,192,0,0,0,0,3,252,47,192,0,0,0,0,3,252,63,192,0,0,0,0,3,252,63,192,0,0,0,0,3,252,63,128,0,0,0,0,3,252,127,255,255,255,208,0,3,252,191,255,255,255,208,0,3,252,191,255,255,255,192,0,3,252,255,85,85,127,192,0,3,252,254,0,0,47,192,0,3,252,0,0,0,63,192,0,3,252,0,0,0,63,192,0,3,252,0,0,0,63,192,0,3,252,0,0,0,63,128,0,3,252,0,0,0,127,128,0,3,252,0,0,0,127,64,0,3,252,0,0,0,191,0,0,3,252,0,0,0,255,0,0,3,252,0,0,2,255,0,0,3,252,0,255,255,253,0,0,3,252,0,191,255,252,0,0,3,252,0,127,255,240,0,0,3,252,0,42,170,64,0,0,2,252,
  // 0x5f85  待
  133,95,38,38,124,40,1,252,0,0,96,0,0,2,164,0,0,0,0,0,254,0,0,3,248,0,0,0,0,2,255,0,0,3,248,0,0,0,0,11,252,0,0,3,248,0,0,0,0,47,244,0,0,3,248,0,0,0,0,191,208,11,255,255,255,255,253,0,3,255,64,11,255,255,255,255,253,0,31,253,0,11,255,255,255,255,253,0,63,244,0,1,85,87,253,85,84,0,31,192,41,0,0,3,248,0,0,0,15,0,63,128,0,3,248,0,0,0,0,0,255,64,0,3,248,0,0,0,0,2,254,0,0,3,248,0,0,0,0,7,252,255,255,255,255,255,255,208,0,15,244,255,255,255,255,255,255,208,0,63,240,255,255,255,255,255,255,208,0,255,240,85,85,85,85,255,85,64,3,255,240,0,0,0,0,191,0,0,15,255,240,0,0,0,0,191,0,0,127,255,240,0,0,0,0,191,0,0,191,239,240,21,85,85,85,255,85,64,63,143,240,127,255,255,255,255,255,192,46,15,240,127,255,255,255,255,255,192,4,15,240,127,255,255,255,255,255,192,0,15,240,0,0,0,0,191,0,0,0,15,240,0,124,0,0,191,0,0,0,15,240,1,254,0,0,191,0,0,0,15,240,0,255,64,0,191,0,0,0,15,240,0,63,192,0,191,0,0,0,15,240,0,31,240,0,191,0,0,0,15,240,0,15,244,0,191,0,0,0,15,240,0,3,252,0,191,0,0,0,15,240,0,2,224,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,3,255,255,0,0,0,15,240,0,0,3,255,254,0,0,0,15,240,0,0,2,255,252,0,0,0,6,144,0,0,0,169,64,0,0,
  // 0x5f8c  後
  140,95,38,38,124,40,1,252,0,0,144,0,0,36,0,0,0,0,0,1,253,0,0,127,64,0,0,0,0,3,252,0,0,255,0,0,0,0,0,15,244,0,3,253,0,32,0,0,0,63,224,0,11,248,0,253,0,0,0,255,128,14,47,224,3,255,0,0,3,254,0,63,255,128,11,252,0,0,31,248,0,63,255,0,47,240,0,0,127,224,0,11,254,0,191,192,0,0,63,128,62,1,255,194,255,0,0,0,13,0,255,0,63,251,252,2,0,0,0,1,254,0,15,255,240,47,128,0,0,3,252,0,3,255,192,63,208,0,0,15,244,0,3,255,0,15,240,0,0,47,224,0,15,248,0,7,252,0,0,191,210,255,255,255,255,255,254,0,2,255,210,255,255,255,255,255,255,64,11,255,210,255,255,255,255,255,255,192,63,255,208,85,1,255,80,0,47,224,255,239,208,0,3,253,0,0,15,192,127,143,208,0,11,252,0,0,5,0,62,15,208,0,47,255,255,255,128,0,4,15,208,0,191,255,255,255,224,0,0,15,208,2,255,255,255,255,192,0,0,15,208,15,255,0,0,127,128,0,0,15,208,127,255,192,1,255,0,0,0,15,211,255,239,224,3,253,0,0,0,15,209,255,11,248,15,248,0,0,0,15,208,184,3,255,127,224,0,0,0,15,208,16,0,255,255,128,0,0,0,15,208,0,0,63,254,0,0,0,0,15,208,0,1,191,255,128,0,0,0,15,208,0,31,255,255,248,0,0,0,15,208,6,255,254,127,255,228,0,0,15,210,255,255,224,7,255,255,208,0,15,211,255,254,0,0,127,255,192,0,15,208,255,144,0,0,6,255,64,0,15,208,164,0,0,0,0,10,0,
  // 0x5f91  徑
  145,95,38,38,124,40,1,252,0,0,160,0,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,0,7,252,63,255,255,255,255,255,192,0,31,240,63,255,255,255,255,255,192,0,63,208,63,255,255,255,255,255,192,1,255,64,21,85,85,85,85,85,64,7,254,0,0,0,0,0,0,0,0,47,248,0,0,191,0,253,2,248,0,127,224,16,0,254,2,252,3,248,0,63,64,126,2,252,3,248,11,240,0,13,0,255,67,248,11,240,31,208,0,0,1,254,11,240,31,208,63,192,0,0,3,252,15,208,63,128,191,0,0,0,15,244,63,192,191,1,253,0,0,0,47,240,63,128,255,1,252,0,0,0,191,208,31,192,63,128,255,0,0,2,255,208,15,240,47,192,63,128,0,11,255,208,3,248,15,240,31,224,0,47,255,208,2,252,3,248,7,244,0,191,255,208,0,254,2,252,3,252,0,191,207,208,0,127,64,255,0,254,0,63,15,208,0,63,64,126,0,190,0,28,15,208,0,16,0,16,0,16,0,0,15,208,5,85,85,85,85,84,0,0,15,208,31,255,255,255,255,253,0,0,15,208,31,255,255,255,255,253,0,0,15,208,31,255,255,255,255,253,0,0,15,208,0,0,7,244,0,0,0,0,15,208,0,0,7,244,0,0,0,0,15,208,0,0,7,244,0,0,0,0,15,208,0,0,7,244,0,0,0,0,15,208,0,0,7,244,0,0,0,0,15,208,0,0,7,244,0,0,0,0,15,208,85,85,91,249,85,85,64,0,15,210,255,255,255,255,255,255,208,0,15,210,255,255,255,255,255,255,208,0,15,210,255,255,255,255,255,255,208,0,15,208,0,0,0,0,0,0,0,
  // 0x5f9e  從
  158,95,38,38,124,40,1,252,0,0,144,0,10,80,0,41,0,0,0,1,253,0,15,240,0,63,64,0,0,3,252,0,15,208,0,127,0,0,0,15,244,0,31,192,0,191,0,0,0,63,224,0,47,192,0,255,0,0,0,255,128,0,63,128,0,254,0,0,3,255,0,0,127,64,1,253,0,0,31,248,0,0,191,192,3,252,0,0,127,224,0,0,255,244,3,255,0,0,63,128,61,2,255,253,11,255,192,0,13,0,255,67,253,255,95,255,244,0,0,1,254,15,244,127,63,203,252,0,0,3,252,47,224,29,191,130,255,0,0,15,244,127,192,2,255,0,191,192,0,47,225,255,64,11,253,0,47,208,0,191,208,254,0,3,244,0,15,64,2,255,208,44,0,1,244,0,1,0,11,255,208,0,0,2,252,0,0,0,47,255,208,0,0,2,252,0,0,0,191,255,208,1,164,2,252,0,0,0,191,207,208,1,252,2,252,0,0,0,63,15,208,2,252,2,252,0,0,0,24,15,208,2,252,2,252,0,0,0,0,15,208,3,252,2,255,255,252,0,0,15,208,3,248,2,255,255,252,0,0,15,208,3,248,2,255,255,252,0,0,15,208,7,252,2,252,0,0,0,0,15,208,11,253,2,252,0,0,0,0,15,208,15,255,2,252,0,0,0,0,15,208,15,255,66,252,0,0,0,0,15,208,47,255,194,252,0,0,0,0,15,208,63,207,242,252,0,0,0,0,15,208,191,71,255,252,0,0,0,0,15,210,255,2,255,252,0,0,0,0,15,215,253,0,191,255,255,255,192,0,15,219,248,0,31,255,255,255,128,0,15,210,240,0,1,191,255,255,64,0,15,208,64,0,0,0,21,85,0,
  // 0x5fa9  復
  169,95,38,38,124,40,1,252,0,0,144,0,25,0,0,0,0,0,0,2,253,0,63,192,0,0,0,0,0,7,252,0,127,128,0,0,0,0,0,15,244,0,255,64,0,0,0,0,0,63,208,1,255,255,255,255,255,192,0,255,128,3,255,255,255,255,255,192,7,254,0,11,255,255,255,255,255,192,31,248,0,15,240,0,0,0,0,0,127,224,16,63,224,0,0,0,0,0,63,64,62,191,229,85,85,85,80,0,13,0,255,255,255,255,255,255,244,0,0,1,255,254,255,255,255,255,244,0,0,3,252,44,253,0,0,3,244,0,0,15,244,0,253,0,0,3,244,0,0,47,240,0,254,85,85,87,244,0,0,191,208,0,255,255,255,255,244,0,2,255,208,0,255,255,255,255,244,0,11,255,208,0,253,0,0,3,244,0,63,255,208,0,253,0,0,3,244,0,255,239,208,0,255,255,255,255,244,0,127,79,208,0,255,255,255,255,244,0,45,15,208,0,86,255,85,85,80,0,4,15,208,0,3,252,0,0,0,0,0,15,208,0,11,248,0,0,0,0,0,15,208,0,47,255,255,255,224,0,0,15,208,0,191,255,255,255,240,0,0,15,208,2,255,234,170,191,224,0,0,15,208,15,255,224,0,127,192,0,0,15,208,191,251,248,1,255,64,0,0,15,208,191,130,254,11,253,0,0,0,15,208,45,0,191,255,244,0,0,0,15,208,0,0,47,255,192,0,0,0,15,208,0,0,191,255,224,0,0,0,15,208,0,111,255,255,255,144,0,0,15,208,175,255,255,95,255,255,144,0,15,208,255,255,224,1,191,255,192,0,15,208,191,249,0,0,10,255,64,0,15,208,36,0,0,0,0,6,0,
  // 0x5fae  微
  174,95,38,38,124,40,1,252,0,6,64,1,244,0,2,144,0,0,0,15,240,1,244,0,3,244,0,0,0,47,208,1,244,0,7,240,0,0,0,191,193,65,244,20,7,240,0,0,1,255,3,209,244,62,11,240,0,0,7,252,3,209,244,62,15,224,0,0,31,244,3,209,244,62,15,208,0,0,127,224,3,209,244,62,15,192,0,0,127,129,67,209,244,62,47,255,255,208,46,3,251,209,244,62,63,255,255,208,4,11,247,209,244,62,63,255,255,208,0,15,227,255,255,254,127,64,190,0,0,47,195,255,255,254,255,64,190,0,0,127,131,255,255,255,255,64,253,0,0,255,0,0,0,3,255,128,253,0,2,255,0,0,0,7,255,128,252,0,7,255,0,0,0,15,255,192,252,0,31,255,0,0,0,3,235,193,252,0,63,255,15,255,255,255,199,210,248,0,255,255,15,255,255,255,7,227,244,0,191,127,15,255,255,255,3,243,240,0,60,63,0,127,11,224,3,247,240,0,20,63,0,126,7,224,2,255,224,0,0,63,0,126,7,224,1,255,208,0,0,63,0,126,7,224,0,255,192,0,0,63,0,126,7,224,0,255,192,0,0,63,0,189,7,224,0,191,64,0,0,63,0,253,7,224,64,191,0,0,0,63,0,252,7,251,192,255,128,0,0,63,1,252,11,255,211,255,192,0,0,63,2,248,63,255,139,255,240,0,0,63,3,244,47,248,15,247,248,0,0,63,11,240,14,64,63,195,253,0,0,63,31,208,0,1,255,64,255,64,0,63,47,192,0,11,254,0,191,224,0,63,11,0,0,11,244,0,47,208,0,63,1,0,0,3,208,0,11,128,0,63,0,0,0,1,64,0,1,0,
  // 0x5fc3  心
  195,95,38,38,124,40,1,252,0,0,0,20,0,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,255,248,0,0,0,0,0,0,0,0,255,255,128,0,0,0,0,0,0,0,11,255,248,0,0,0,0,0,0,0,0,191,255,64,0,0,0,0,0,0,0,11,255,240,0,0,0,0,0,0,0,0,255,252,0,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,0,2,224,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,1,84,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,3,252,0,0,0,4,0,0,0,0,3,252,0,0,0,189,0,0,0,249,3,252,0,0,1,255,0,0,0,255,3,252,0,0,0,255,128,0,0,254,3,252,0,0,0,63,208,0,0,254,3,252,0,0,0,47,240,0,1,253,3,252,0,0,0,15,244,0,2,252,3,252,0,0,0,11,252,0,3,252,3,252,0,0,0,3,253,0,3,252,3,252,0,0,0,1,255,0,7,248,3,252,0,0,0,0,255,64,11,244,3,252,0,0,0,0,191,192,15,240,3,252,0,0,0,0,63,192,31,224,3,252,0,0,6,0,63,208,63,208,3,252,0,0,7,240,47,224,127,192,3,252,0,0,7,240,15,224,191,128,3,252,0,0,7,240,14,0,31,0,3,252,0,0,11,240,0,0,0,0,3,252,0,0,11,240,0,0,0,0,3,252,0,0,15,224,0,0,0,0,2,254,0,0,47,208,0,0,0,0,2,255,255,255,255,192,0,0,0,0,0,255,255,255,255,128,0,0,0,0,0,127,255,255,254,0,0,0,0,0,0,1,85,85,80,0,0,0,
  // 0x6027  性
  39,96,37,38,124,40,1,252,0,31,208,0,0,1,168,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,62,65,253,0,0,0,0,31,208,0,127,65,253,0,0,0,0,31,208,0,191,1,253,0,0,0,0,31,208,0,191,1,253,0,0,0,0,31,208,0,255,1,253,0,0,0,0,31,239,0,254,1,253,0,0,0,15,159,255,129,254,170,254,170,169,0,15,159,223,194,255,255,255,255,255,0,15,159,219,211,255,255,255,255,255,0,31,159,215,247,255,255,255,255,255,0,31,95,211,255,240,1,253,0,0,0,47,31,210,255,240,1,253,0,0,0,63,31,208,95,208,1,253,0,0,0,63,31,208,63,192,1,253,0,0,0,126,31,208,63,128,1,253,0,0,0,189,31,208,7,0,1,253,0,0,0,188,31,208,0,0,1,253,0,0,0,4,31,208,0,0,1,253,0,0,0,0,31,208,2,255,255,255,255,252,0,0,31,208,2,255,255,255,255,252,0,0,31,208,2,255,255,255,255,252,0,0,31,208,1,85,86,254,85,84,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,31,208,191,255,255,255,255,255,192,0,31,208,191,255,255,255,255,255,192,0,31,208,191,255,255,255,255,255,192,0,31,208,106,170,170,170,170,170,128,0,31,208,0,0,0,0,0,0,0,
  // 0x6062  恢
  98,96,38,38,124,40,1,252,0,10,128,1,160,0,0,0,0,0,0,31,192,3,244,0,0,0,0,0,0,31,192,3,244,0,0,0,0,0,0,31,192,3,244,0,0,0,0,0,0,31,192,87,249,85,85,85,85,64,0,31,192,255,255,255,255,255,255,192,0,31,192,255,255,255,255,255,255,192,0,31,233,255,255,255,255,255,255,192,10,95,255,3,244,0,0,0,0,0,15,159,239,3,244,0,15,192,0,0,15,95,207,131,244,0,15,192,0,0,15,95,203,195,244,0,15,192,0,0,31,95,199,211,244,0,15,192,0,0,31,31,195,227,244,0,15,192,9,0,47,31,195,227,244,184,15,192,31,192,63,31,194,67,244,252,15,192,47,128,62,31,192,3,244,248,15,192,63,64,125,31,192,3,240,248,15,192,63,0,188,31,192,3,240,244,15,192,190,0,20,31,192,3,241,244,31,192,252,0,0,31,192,3,242,240,31,193,248,0,0,31,192,7,243,240,31,210,244,0,0,31,192,7,251,208,47,211,240,0,0,31,192,11,225,192,63,224,0,0,0,31,192,11,224,0,63,240,0,0,0,31,192,15,208,0,127,244,0,0,0,31,192,15,208,0,254,248,0,0,0,31,192,31,192,1,252,252,0,0,0,31,192,47,192,3,248,190,0,0,0,31,192,63,128,11,240,63,64,0,0,31,192,127,64,31,224,63,192,0,0,31,192,191,0,127,192,31,240,0,0,31,192,254,1,255,64,11,252,0,0,31,194,252,11,254,0,3,255,0,0,31,199,248,63,248,0,1,255,208,0,31,203,240,127,224,0,0,127,208,0,31,193,224,47,64,0,0,31,128,0,31,192,64,8,0,0,0,2,0,
  // 0x606f  息
  111,96,37,39,134,40,2,252,0,0,0,0,64,0,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,250,170,170,170,171,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,250,170,170,170,175,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,208,0,0,0,3,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,0,0,0,144,0,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,0,7,254,0,0,16,0,0,0,228,10,129,255,128,0,248,0,0,1,253,15,208,127,224,3,254,0,0,3,252,15,208,31,244,1,255,128,0,3,248,15,208,7,240,0,127,224,0,15,244,15,208,2,128,64,31,244,0,31,240,15,208,0,0,185,11,252,0,63,208,15,208,0,0,254,3,255,0,255,128,15,224,0,1,254,0,255,64,255,0,15,255,255,255,252,0,127,0,28,0,11,255,255,255,252,0,56,0,0,0,2,255,255,255,224,0,0,0,0,0,0,5,85,84,0,0,0,0,
  // 0x61b6  憶
  182,97,38,38,124,40,1,252,0,10,128,0,0,2,168,0,0,0,0,31,192,0,0,3,252,0,0,0,0,31,192,0,0,3,252,0,0,0,0,31,192,10,170,171,254,170,170,0,0,31,192,15,255,255,255,255,255,0,0,31,192,15,255,255,255,255,255,0,0,31,192,0,15,192,0,63,64,0,0,31,217,0,15,224,0,127,0,0,10,95,255,0,7,240,0,190,0,0,15,159,239,0,3,240,0,252,0,0,15,95,207,191,255,255,255,255,255,208,15,95,203,255,255,255,255,255,255,208,31,95,199,255,255,255,255,255,255,192,31,31,195,224,0,0,0,0,0,0,47,31,195,224,85,85,85,85,84,0,63,31,193,1,255,255,255,255,252,0,62,31,192,1,255,255,255,255,252,0,125,31,192,1,252,0,0,1,252,0,188,31,192,1,252,0,0,1,252,0,20,31,192,1,255,255,255,255,252,0,0,31,192,1,255,255,255,255,252,0,0,31,192,1,252,0,0,2,252,0,0,31,192,1,252,0,0,1,252,0,0,31,192,1,253,85,85,86,252,0,0,31,192,1,255,255,255,255,252,0,0,31,192,1,255,255,255,255,252,0,0,31,192,0,0,15,208,0,0,0,0,31,192,0,0,15,248,0,0,0,0,31,192,6,66,246,255,7,192,0,0,31,192,11,226,248,127,15,240,0,0,31,192,15,210,248,13,7,248,0,0,31,192,31,194,248,0,2,253,0,0,31,192,63,130,248,0,36,255,0,0,31,192,127,66,248,0,47,127,128,0,31,193,255,2,248,0,63,47,192,0,31,194,252,2,255,255,255,15,208,0,31,192,116,1,255,255,254,11,64,0,31,192,0,0,127,255,248,0,0,
  // 0x61c9  應
  201,97,37,38,124,40,1,252,0,0,0,0,11,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,15,240,0,0,0,0,2,255,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,255,192,2,252,0,57,0,244,1,64,0,0,2,248,0,127,1,253,3,248,0,0,2,248,0,253,2,252,7,240,0,0,2,248,2,252,7,244,15,224,0,0,2,248,7,244,15,255,255,255,254,0,2,248,15,240,47,255,255,255,254,0,2,248,63,240,127,229,111,213,84,0,2,248,191,240,255,208,31,192,0,0,2,254,255,243,255,255,255,255,248,0,2,255,255,247,255,255,255,255,248,0,2,255,247,241,223,208,31,192,0,0,2,249,199,240,15,208,31,192,0,0,2,248,7,240,15,255,255,255,248,0,2,248,7,240,15,255,255,255,248,0,3,248,7,240,15,208,31,192,0,0,3,248,7,240,15,208,31,192,0,0,3,244,7,240,15,229,111,213,85,0,3,244,7,240,15,255,255,255,255,64,3,244,7,240,15,255,255,255,255,64,3,240,1,80,3,208,0,0,0,0,7,240,0,0,15,253,0,0,0,0,11,240,0,0,7,255,128,6,0,0,11,224,10,66,252,127,240,63,192,0,15,224,15,210,252,11,224,47,224,0,15,208,47,194,252,1,64,11,244,0,31,192,63,66,252,0,2,147,253,0,47,192,191,2,252,0,3,244,255,0,63,130,254,1,252,0,3,240,127,128,127,71,252,1,255,255,255,240,63,192,191,1,240,0,255,255,255,208,31,64,30,0,0,0,47,255,255,64,4,0,4,0,0,0,0,0,0,0,0,0,
  // 0x6210  成
  16,98,37,39,134,40,1,251,0,0,0,0,0,170,1,64,0,0,0,0,0,0,0,255,7,244,0,0,0,0,0,0,0,191,15,254,0,0,0,0,0,0,0,191,2,255,192,0,0,0,0,0,0,191,0,127,244,0,0,0,0,0,0,191,0,15,244,0,0,0,0,0,0,191,0,2,208,0,0,255,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,255,192,0,255,170,170,170,255,234,170,170,128,0,255,0,0,0,127,128,0,0,0,0,255,0,0,0,63,128,0,0,0,0,255,0,0,0,63,128,1,0,0,0,255,0,0,0,63,192,7,244,0,0,255,85,85,80,63,192,15,240,0,0,255,255,255,240,63,192,15,240,0,0,255,255,255,240,47,192,47,208,0,0,255,255,255,240,31,208,63,192,0,0,255,0,15,240,31,224,127,128,0,0,255,0,15,240,15,240,255,0,0,0,254,0,15,224,15,242,255,0,0,0,254,0,15,224,15,247,253,0,0,0,254,0,15,224,11,255,248,0,0,1,254,0,15,224,7,255,240,0,0,1,253,0,15,224,3,255,224,0,0,2,253,0,15,224,3,255,192,0,0,2,252,0,31,208,2,255,0,13,0,3,252,85,127,208,7,255,0,15,192,3,252,127,255,192,31,255,64,15,192,7,248,63,255,128,127,255,192,15,192,11,244,47,253,2,255,255,208,31,192,15,240,0,0,15,255,31,240,47,192,31,240,0,0,127,252,15,253,63,128,63,208,0,2,255,240,7,255,255,64,127,192,0,2,255,192,1,255,255,0,47,128,0,0,189,0,0,127,253,0,7,0,0,0,32,0,0,10,160,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6236  戶
  54,98,32,38,48,40,2,252,0,0,0,0,0,0,6,0,0,0,0,0,0,6,255,192,0,0,0,0,6,255,255,240,0,0,0,91,255,255,255,208,0,62,175,255,255,255,228,0,0,63,255,255,255,164,0,0,0,63,255,250,64,0,0,0,0,63,228,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,255,255,255,255,255,254,0,63,255,255,255,255,255,254,0,63,255,255,255,255,255,254,0,63,213,85,85,85,86,254,0,63,192,0,0,0,0,254,0,63,192,0,0,0,0,254,0,63,192,0,0,0,0,254,0,63,192,0,0,0,0,254,0,63,192,0,0,0,0,254,0,63,128,0,0,0,0,254,0,63,213,85,85,85,86,254,0,127,255,255,255,255,255,254,0,127,255,255,255,255,255,254,0,191,255,255,255,255,255,254,0,191,0,0,0,0,0,254,0,255,0,0,0,0,0,254,0,254,0,0,0,0,0,0,2,253,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,248,0,0,0,0,0,0,15,244,0,0,0,0,0,0,31,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,255,192,0,0,0,0,0,0,255,64,0,0,0,0,0,0,46,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,
  // 0x6240  所
  64,98,38,37,114,40,1,252,0,0,0,0,0,0,0,0,180,0,5,85,85,85,84,0,0,11,254,0,31,255,255,255,252,0,1,255,255,128,31,255,255,255,252,80,191,255,253,0,31,255,255,255,252,191,255,255,128,0,0,0,0,0,0,191,255,228,0,0,0,0,0,0,0,191,228,0,0,0,0,0,0,0,0,191,0,0,0,0,1,85,85,85,80,191,0,0,0,0,3,255,255,255,240,191,0,0,0,0,3,255,255,255,240,191,0,0,0,0,3,255,255,255,240,191,0,0,0,0,3,244,0,15,240,191,0,0,0,0,3,244,0,15,240,191,255,255,255,208,3,244,0,15,240,191,255,255,255,208,3,244,0,15,240,191,255,255,255,208,3,244,0,15,240,255,170,175,250,144,3,244,0,15,240,255,0,15,208,0,3,255,255,255,240,254,0,15,208,0,3,255,255,255,240,254,0,15,208,0,3,255,255,255,240,254,0,15,208,0,3,249,85,85,81,253,0,15,208,0,3,244,0,0,1,253,0,15,208,0,7,240,0,0,2,252,0,15,208,0,7,240,0,0,3,252,0,15,208,0,7,240,0,0,3,248,0,15,208,0,11,240,0,0,7,244,0,15,208,0,11,240,0,0,15,240,0,15,208,0,15,224,0,0,15,240,0,15,208,0,15,208,0,0,47,208,0,15,208,0,31,192,0,0,63,192,0,15,208,0,63,192,0,0,255,128,0,15,208,0,63,128,0,2,255,0,0,15,208,0,191,64,0,7,253,0,0,15,208,0,255,0,0,7,248,0,0,15,208,0,45,0,0,0,240,0,0,15,208,0,4,0,0,0,0,0,0,15,208,0,
  // 0x6247  扇
  71,98,36,36,68,40,1,252,15,255,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,255,224,0,63,255,255,255,255,255,255,224,0,63,255,255,255,255,255,255,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,255,255,255,255,255,255,224,0,127,255,255,255,255,255,255,224,0,127,255,255,255,255,255,255,224,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,127,255,255,15,255,255,244,0,127,127,255,255,15,255,255,244,0,191,63,255,255,15,255,255,244,0,191,1,0,127,0,80,3,244,0,255,15,192,127,3,244,3,244,0,254,15,224,127,3,253,3,244,0,254,7,248,127,0,255,3,244,1,253,1,252,127,0,63,67,244,2,252,0,240,127,0,28,3,244,3,252,0,0,127,0,0,99,244,3,248,0,47,127,0,11,243,244,7,244,7,255,127,1,191,243,244,15,241,191,254,127,47,255,131,244,31,241,255,224,127,47,248,3,244,63,208,253,0,127,31,128,3,244,127,192,144,0,127,4,0,3,244,191,64,0,63,255,0,3,255,244,31,0,0,47,254,0,2,255,240,0,0,0,31,228,0,1,255,128,
  // 0x624b  手
  75,98,36,38,86,40,2,252,0,0,0,0,0,0,0,96,0,0,0,0,0,0,1,175,248,0,0,0,0,1,90,255,255,253,0,1,86,175,255,255,255,255,254,0,3,255,255,255,255,255,254,64,0,3,255,255,255,255,165,0,0,0,2,255,170,85,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,2,170,170,170,255,170,170,170,144,3,255,255,255,255,255,255,255,224,3,255,255,255,255,255,255,255,224,3,255,255,255,255,255,255,255,224,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,255,170,170,170,170,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,255,255,255,0,0,0,0,0,0,191,255,253,0,0,0,0,0,0,63,255,248,0,0,0,0,0,0,42,169,0,0,0,0,0,
  // 0x6253  打
  83,98,37,38,124,40,2,252,0,31,208,0,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,0,31,208,2,170,170,170,170,170,64,0,31,208,3,255,255,255,255,255,64,0,31,208,3,255,255,255,255,255,64,0,31,208,3,255,255,255,255,255,64,0,31,208,0,0,0,31,224,0,0,255,255,255,244,0,0,31,224,0,0,255,255,255,244,0,0,31,224,0,0,255,255,255,244,0,0,31,224,0,0,170,175,234,160,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,20,0,0,31,224,0,0,0,31,235,248,0,0,31,224,0,0,0,47,255,248,0,0,31,224,0,0,27,255,255,252,0,0,31,224,0,0,255,255,255,144,0,0,31,224,0,0,255,255,224,0,0,0,31,224,0,0,191,255,208,0,0,0,31,224,0,0,120,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,31,208,0,0,0,31,224,0,0,0,47,208,0,0,0,47,224,0,0,63,255,208,0,11,255,255,208,0,0,31,255,192,0,3,255,255,192,0,0,15,255,64,0,3,255,255,64,0,0,5,80,0,0,2,255,228,0,0,0,
  // 0x6279  批
  121,98,38,38,124,40,1,252,0,31,128,1,80,0,21,64,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,63,255,255,199,240,0,47,192,0,0,63,255,255,199,240,0,47,192,4,0,63,255,255,199,240,0,47,192,45,0,21,127,213,71,240,0,47,192,191,64,0,47,192,7,240,0,47,194,255,128,0,47,192,7,255,255,47,207,254,0,0,47,192,7,255,255,47,255,244,0,0,47,192,7,255,255,47,255,192,0,0,47,192,7,250,169,47,253,0,0,0,47,193,71,240,0,47,240,0,0,0,47,255,135,240,0,47,192,0,0,0,127,255,199,240,0,47,192,0,0,27,255,255,199,240,0,47,192,0,0,191,255,249,7,240,0,47,192,0,0,127,255,192,7,240,0,47,192,0,0,63,175,192,7,240,0,47,192,0,0,16,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,0,0,0,47,192,7,240,0,47,192,9,0,0,47,192,7,240,0,47,192,15,208,0,47,192,7,240,0,47,192,15,208,0,47,192,7,240,27,47,192,15,208,0,47,192,7,255,255,47,192,15,192,0,47,194,255,255,255,47,192,31,192,21,127,195,255,255,254,31,255,255,192,31,255,130,255,249,0,15,255,255,64,15,255,1,249,0,0,7,255,254,0,15,248,0,0,0,0,0,21,80,0,
  // 0x6296  抖
  150,98,38,38,124,40,1,252,0,11,224,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,3,128,0,191,0,0,0,15,240,0,15,248,0,191,0,0,0,15,240,0,15,255,0,191,0,0,0,15,240,0,1,255,208,191,0,0,0,15,240,0,0,63,244,191,0,0,63,255,255,248,0,11,240,191,0,0,63,255,255,248,0,1,192,191,0,0,63,255,255,248,0,0,0,191,0,0,21,95,245,80,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,61,0,0,191,0,0,0,15,240,0,191,208,0,191,0,0,0,15,240,0,255,248,0,191,0,0,0,15,240,0,31,255,64,191,0,0,0,15,240,20,2,255,192,191,0,0,0,15,251,248,0,127,64,191,0,0,0,15,255,248,0,14,0,191,0,0,6,255,255,252,0,0,0,191,0,0,127,255,255,144,0,0,0,191,0,0,63,255,240,0,0,0,0,191,107,192,63,239,240,0,0,0,6,255,255,192,24,15,240,0,0,107,255,255,255,208,0,15,240,2,191,255,255,255,255,144,0,15,240,7,255,255,255,255,64,0,0,15,240,3,255,255,164,191,0,0,0,15,240,3,250,64,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,0,15,240,0,0,0,0,191,0,0,31,255,224,0,0,0,0,191,0,0,15,255,208,0,0,0,0,191,0,0,11,255,64,0,0,0,0,191,0,0,1,80,0,0,0,0,0,106,0,0,
  // 0x62bd  抽
  189,98,37,39,134,40,1,251,0,15,208,0,0,0,168,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,0,15,224,0,0,0,253,0,0,0,63,255,255,224,0,0,253,0,0,0,63,255,255,226,170,170,254,170,170,64,63,255,255,227,255,255,255,255,255,128,21,95,245,83,255,255,255,255,255,128,0,15,224,3,255,255,255,255,255,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,231,243,244,0,253,0,63,128,0,15,255,243,244,0,253,0,63,128,1,191,255,243,255,255,255,255,255,128,127,255,255,147,255,255,255,255,255,128,127,255,244,3,255,255,255,255,255,128,127,255,224,3,249,86,254,85,191,128,61,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,244,0,253,0,63,128,0,15,224,3,250,170,254,170,191,128,0,15,224,3,255,255,255,255,255,128,0,15,224,3,255,255,255,255,255,128,5,95,224,3,255,255,255,255,255,128,31,255,208,3,244,0,0,0,63,128,15,255,192,3,244,0,0,0,63,128,11,254,0,3,244,0,0,0,42,64,0,0,0,0,0,0,0,0,0,0,
  // 0x62d4  拔
  212,98,38,39,134,40,1,251,0,15,208,0,0,253,0,0,0,0,0,15,224,0,1,253,0,244,0,0,0,15,224,0,1,253,3,254,0,0,0,15,224,0,1,253,2,255,208,0,0,15,224,0,1,253,0,127,244,0,0,15,224,0,1,252,0,11,254,0,0,15,224,0,1,252,0,1,252,0,0,15,224,0,1,252,0,0,116,0,63,255,255,224,1,252,0,0,0,0,63,255,255,235,255,255,255,255,255,192,63,255,255,235,255,255,255,255,255,192,63,255,255,235,255,255,255,255,255,192,0,15,224,0,2,252,0,0,0,0,0,15,224,0,2,252,0,0,0,0,0,15,224,0,3,253,0,0,0,0,0,15,224,0,3,254,0,6,160,0,0,15,224,0,3,255,0,11,240,0,0,15,224,0,3,255,0,15,240,0,0,15,225,160,3,255,64,15,224,0,0,15,255,240,7,255,128,31,208,0,0,111,255,240,11,255,192,31,192,0,111,255,255,224,15,239,224,47,192,0,191,255,248,0,15,231,240,63,128,0,127,255,224,0,31,211,244,127,64,0,62,79,224,0,47,194,252,255,0,0,0,15,224,0,63,192,254,254,0,0,0,15,224,0,127,64,191,252,0,0,0,15,224,0,191,0,63,248,0,0,0,15,224,0,254,0,47,240,0,0,0,15,224,2,253,0,47,244,0,0,0,15,224,3,252,0,127,253,0,0,0,15,224,15,244,1,255,255,64,0,0,15,224,31,240,3,254,255,208,0,0,15,224,127,192,31,248,63,248,0,5,95,224,255,128,191,240,11,255,64,31,255,211,255,3,255,192,2,255,224,15,255,193,252,1,254,0,0,127,128,11,254,0,112,0,116,0,0,7,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6309  按
  9,99,38,39,134,40,1,251,0,15,208,0,0,1,168,0,0,0,0,15,224,0,0,2,252,0,0,0,0,15,224,0,0,2,252,0,0,0,0,15,224,0,0,2,252,0,0,0,0,15,224,0,0,2,252,0,0,0,0,15,224,1,85,87,253,85,85,64,0,15,224,11,255,255,255,255,255,192,0,15,224,11,255,255,255,255,255,192,63,255,255,235,255,255,255,255,255,192,63,255,255,235,240,0,0,0,47,192,63,255,255,235,240,15,144,0,47,192,21,95,245,91,240,31,224,0,47,192,0,15,224,11,240,47,208,0,47,192,0,15,224,11,240,63,192,0,47,192,0,15,224,0,0,63,128,0,0,0,0,15,224,0,0,127,64,0,0,0,0,15,224,5,85,255,85,85,85,64,0,15,224,15,255,255,255,255,255,208,0,15,225,175,255,255,255,255,255,208,0,15,255,255,255,255,255,255,255,208,1,191,255,240,3,248,0,31,224,0,111,255,255,224,7,244,0,47,208,0,191,255,244,0,15,240,0,63,192,0,127,255,224,0,15,224,0,63,192,0,62,79,224,0,31,192,0,127,64,0,0,15,224,0,63,208,0,255,0,0,0,15,224,0,63,253,2,254,0,0,0,15,224,0,191,255,227,252,0,0,0,15,224,0,255,255,255,248,0,0,0,15,224,0,9,31,255,240,0,0,0,15,224,0,0,1,255,253,0,0,0,15,224,0,0,7,255,255,192,0,0,15,224,0,0,111,254,255,244,0,0,15,224,0,11,255,240,63,254,0,5,95,224,22,255,255,128,7,255,192,31,255,208,63,255,248,0,0,255,192,15,255,192,31,254,64,0,0,47,0,11,254,0,15,144,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6389  掉
  137,99,38,38,124,40,1,252,0,26,128,0,0,2,160,0,0,0,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,255,255,255,128,0,47,192,0,0,3,255,255,255,128,0,47,192,0,0,3,255,255,255,128,0,47,192,0,0,3,244,0,0,0,63,255,255,192,0,3,244,0,0,0,63,255,255,192,0,3,244,0,0,0,63,255,255,203,255,255,255,255,252,0,21,127,229,75,255,255,255,255,252,0,0,47,192,11,255,255,255,255,252,0,0,47,192,11,240,0,0,3,252,0,0,47,192,11,240,0,0,3,252,0,0,47,192,11,240,0,0,3,252,0,0,47,192,11,255,255,255,255,252,0,0,47,192,11,255,255,255,255,252,0,0,47,219,203,255,255,255,255,252,0,0,47,255,203,240,0,0,3,252,0,1,255,255,219,240,0,0,3,252,0,127,255,255,139,240,0,0,3,252,0,63,255,224,11,255,255,255,255,252,0,63,255,192,11,255,255,255,255,252,0,41,47,192,11,255,255,255,255,252,0,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,244,0,0,0,0,47,192,255,255,255,255,255,255,208,0,47,192,255,255,255,255,255,255,208,0,47,192,255,255,255,255,255,255,208,0,47,192,85,85,87,249,85,85,64,0,47,192,0,0,3,244,0,0,0,0,47,192,0,0,3,244,0,0,0,63,255,192,0,0,3,244,0,0,0,47,255,128,0,0,3,244,0,0,0,31,254,0,0,0,3,244,0,0,0,5,64,0,0,0,2,164,0,0,0,
  // 0x63a2  探
  162,99,38,38,124,40,1,252,0,47,128,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,15,255,255,255,255,255,128,0,47,192,15,255,255,255,255,255,128,0,47,192,15,255,255,255,255,255,128,0,47,192,15,192,0,0,0,47,128,0,47,192,15,192,84,0,0,47,128,0,47,192,15,192,253,11,224,47,128,63,255,255,207,192,253,11,224,47,128,63,255,255,207,193,252,11,224,47,128,63,255,255,192,2,252,11,224,0,0,21,127,213,64,3,248,11,224,9,0,0,47,192,0,11,244,11,224,11,208,0,47,192,0,47,240,11,240,15,192,0,47,192,2,255,192,11,255,255,192,0,47,192,47,255,0,3,255,255,128,0,47,192,15,248,0,1,255,254,0,0,47,198,135,64,3,252,0,0,0,0,47,255,128,0,3,252,0,0,0,0,127,255,192,0,3,252,0,0,0,47,255,255,128,0,3,252,0,0,0,191,255,244,47,255,255,255,255,255,192,127,255,192,47,255,255,255,255,255,192,62,111,192,47,255,255,255,255,255,192,0,47,192,5,85,191,255,213,85,64,0,47,192,0,0,255,255,240,0,0,0,47,192,0,2,255,255,244,0,0,0,47,192,0,7,251,255,253,0,0,0,47,192,0,31,243,252,255,0,0,0,47,192,0,63,211,252,127,192,0,0,47,192,1,255,131,252,47,244,0,0,47,192,11,254,3,252,15,253,0,0,47,192,63,252,3,252,3,255,128,0,47,194,255,224,3,252,0,255,224,21,127,192,255,128,3,252,0,63,192,31,255,128,124,0,3,252,0,11,0,15,255,0,16,0,3,252,0,0,0,15,248,0,0,0,3,252,0,0,0,
  // 0x63a5  接
  165,99,37,38,124,40,1,252,0,15,208,0,0,3,252,0,0,0,0,15,224,0,0,3,252,0,0,0,0,15,224,0,0,3,252,0,0,0,0,15,224,0,0,3,252,0,0,0,0,15,224,15,255,255,255,255,255,0,0,15,224,15,255,255,255,255,255,0,0,15,224,15,255,255,255,255,255,0,0,15,224,0,11,208,0,63,128,0,63,255,255,192,15,208,0,127,64,0,63,255,255,192,15,224,0,191,0,0,63,255,255,192,11,240,0,254,0,0,21,95,245,64,7,240,0,253,0,0,0,15,224,0,3,244,1,252,0,0,0,15,224,0,7,248,3,248,0,0,0,15,224,127,255,255,255,255,255,192,0,15,224,127,255,255,255,255,255,192,0,15,224,127,255,255,255,255,255,192,0,15,224,0,0,63,192,0,0,0,0,15,226,192,0,127,128,0,0,0,0,15,255,192,0,255,0,0,0,0,0,111,255,208,1,255,0,0,0,0,27,255,255,255,255,255,255,255,255,192,191,255,249,127,255,255,255,255,255,192,127,255,224,63,255,255,255,255,255,192,62,79,224,0,15,240,0,127,64,0,16,15,224,0,47,208,0,191,0,0,0,15,224,0,63,192,0,254,0,0,0,15,224,0,191,64,2,253,0,0,0,15,224,0,255,249,7,252,0,0,0,15,224,2,255,255,239,240,0,0,0,15,224,1,186,255,255,224,0,0,0,15,224,0,0,27,255,244,0,0,0,15,224,0,0,47,255,255,128,0,0,15,224,0,27,255,251,255,244,0,31,255,208,175,255,255,128,127,255,0,15,255,192,255,255,244,0,7,255,0,11,255,64,127,249,0,0,0,188,0,6,148,0,36,0,0,0,0,0,0,
  // 0x63a7  控
  167,99,38,38,124,40,1,252,0,31,128,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,63,255,255,255,255,255,192,0,47,192,63,255,255,255,255,255,192,0,47,192,63,255,255,255,255,255,192,0,47,192,63,65,253,11,240,31,192,63,255,255,191,64,252,11,240,31,192,63,255,255,191,65,252,11,240,31,192,63,255,255,191,65,252,11,240,31,192,21,127,213,64,2,252,11,240,0,0,0,47,192,0,3,248,11,240,4,0,0,47,192,0,7,244,11,240,15,64,0,47,192,0,15,240,11,240,15,192,0,47,192,0,63,208,11,240,15,192,0,47,192,1,255,192,11,255,255,128,0,47,199,175,255,0,3,255,255,64,0,47,255,143,248,0,1,255,253,0,0,127,255,203,128,0,0,0,0,0,27,255,255,64,0,0,0,0,0,0,191,255,224,0,0,0,0,0,0,0,127,255,192,7,255,255,255,255,253,0,62,111,192,7,255,255,255,255,253,0,16,47,192,7,255,255,255,255,253,0,0,47,192,1,85,87,253,85,84,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,255,255,255,255,255,255,208,21,127,192,255,255,255,255,255,255,208,31,255,128,255,255,255,255,255,255,208,15,255,0,85,85,85,85,85,85,64,15,248,0,0,0,0,0,0,0,0,
  // 0x63d0  提
  208,99,38,38,124,40,1,252,0,47,128,0,0,0,0,0,0,0,0,47,128,1,170,170,170,170,164,0,0,47,128,2,255,255,255,255,244,0,0,47,128,2,255,255,255,255,244,0,0,47,128,2,252,0,0,3,244,0,0,47,128,2,252,0,0,3,244,0,0,47,128,2,252,0,0,3,244,0,0,47,128,2,255,255,255,255,244,0,127,255,255,194,255,255,255,255,244,0,127,255,255,194,254,170,170,171,244,0,127,255,255,194,252,0,0,3,244,0,21,127,213,66,252,0,0,3,244,0,0,47,128,2,254,170,170,175,244,0,0,47,128,2,255,255,255,255,244,0,0,47,128,2,255,255,255,255,244,0,0,47,128,0,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,0,47,134,95,255,255,255,255,255,128,0,47,255,223,255,255,255,255,255,128,1,191,255,223,255,255,255,255,255,128,111,255,255,128,0,3,248,0,0,0,191,255,224,0,80,3,248,0,0,0,127,255,128,0,253,3,248,0,0,0,57,47,128,1,252,3,248,0,0,0,0,47,128,1,252,3,255,255,248,0,0,47,128,2,248,3,255,255,248,0,0,47,128,3,252,3,255,255,248,0,0,47,128,7,253,3,248,0,0,0,0,47,128,11,255,3,248,0,0,0,0,47,128,15,255,67,248,0,0,0,0,47,128,47,223,211,248,0,0,0,0,47,128,63,139,251,248,0,0,0,0,63,128,255,2,255,248,0,0,0,47,255,131,254,0,191,255,255,255,224,31,255,71,252,0,31,255,255,255,192,15,253,1,240,0,1,191,255,255,192,5,64,0,64,0,0,0,0,0,0,
  // 0x63d2  插
  210,99,37,38,124,40,1,252,0,31,128,0,0,0,0,0,0,0,0,47,192,0,0,0,0,91,240,0,0,47,192,0,5,106,255,255,252,0,0,47,192,15,255,255,255,255,253,0,0,47,192,11,255,255,255,233,64,0,0,47,192,7,254,171,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,63,255,255,192,0,3,248,0,0,0,63,255,255,213,85,87,253,85,85,64,63,255,255,255,255,255,255,255,255,192,21,127,213,63,255,255,255,255,255,192,0,47,192,63,255,255,255,255,255,192,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,3,248,0,0,0,0,47,192,0,0,67,248,0,0,0,0,47,192,0,7,243,248,0,0,0,0,47,192,15,191,255,248,255,255,0,0,47,223,143,255,251,248,255,255,0,0,47,255,143,254,3,248,255,255,0,6,255,255,207,208,3,248,0,127,0,191,255,253,15,208,3,248,0,127,0,127,255,192,15,208,3,248,0,127,0,63,175,192,15,208,3,248,0,127,0,16,47,192,15,255,227,248,191,255,0,0,47,192,15,255,227,248,191,255,0,0,47,192,15,255,227,248,191,255,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,208,3,248,0,127,0,0,47,192,15,255,255,255,255,255,0,21,127,192,15,255,255,255,255,255,0,31,255,128,15,255,255,255,255,255,0,15,255,0,15,208,0,0,0,127,0,15,248,0,15,208,0,0,0,127,0,
  // 0x63db  換
  219,99,37,39,134,40,1,251,0,31,128,0,3,164,0,0,0,0,0,47,192,0,7,244,0,0,0,0,0,47,192,0,15,240,0,0,0,0,0,47,192,0,31,255,255,192,0,0,0,47,192,0,63,255,255,244,0,0,0,47,192,0,191,255,255,240,0,0,0,47,192,1,254,0,31,224,0,0,0,47,192,7,252,0,47,192,0,0,63,255,255,223,244,0,63,64,0,0,63,255,255,255,224,0,191,0,0,0,63,255,255,255,255,255,255,255,253,0,21,127,213,111,255,255,255,255,253,0,0,47,192,15,255,255,255,255,253,0,0,47,192,11,224,62,15,128,189,0,0,47,192,11,224,125,15,128,189,0,0,47,192,11,224,188,15,128,189,0,0,47,192,11,224,252,15,128,253,0,0,47,192,11,227,244,15,255,253,0,0,47,239,139,255,224,11,255,253,0,0,47,255,139,239,128,0,85,253,0,7,255,255,203,225,0,0,0,189,0,191,255,254,11,224,2,160,0,189,0,127,255,192,11,224,3,244,0,189,0,63,255,192,5,80,7,240,0,84,0,56,47,192,0,0,7,240,0,0,0,0,47,192,191,255,255,255,255,255,192,0,47,192,191,255,255,255,255,255,192,0,47,192,191,255,255,255,255,255,192,0,47,192,0,0,31,254,0,0,0,0,47,192,0,0,63,255,64,0,0,0,47,192,0,0,191,127,192,0,0,0,47,192,0,2,254,31,244,0,0,0,47,192,0,11,252,11,253,0,0,0,47,192,0,191,240,2,255,208,0,21,127,192,27,255,192,0,191,254,64,31,255,130,255,254,0,0,31,255,192,15,255,0,255,224,0,0,2,255,0,15,248,0,185,0,0,0,0,26,0,0,0,0,0,0,0,0,0,0,0,
  // 0x64c7  擇
  199,100,38,39,134,40,1,251,0,31,128,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,7,255,255,255,255,255,0,0,47,192,7,255,255,255,255,255,0,0,47,192,7,250,255,171,250,191,0,0,47,192,7,224,126,3,224,63,0,0,47,192,7,224,126,3,224,63,0,0,47,192,7,224,126,3,224,63,0,63,255,255,199,255,255,255,255,255,0,63,255,255,199,255,255,255,255,255,0,63,255,255,198,170,171,254,170,170,0,21,127,213,64,0,2,252,0,0,0,0,47,192,0,0,2,252,0,0,0,0,47,192,3,255,255,255,255,253,0,0,47,192,3,255,255,255,255,253,0,0,47,192,2,170,171,254,170,169,0,0,47,192,0,0,2,252,0,0,0,0,47,193,64,0,2,252,0,0,0,0,47,239,191,255,255,255,255,255,208,0,127,255,255,255,255,255,255,255,208,27,255,255,255,255,255,255,255,255,208,191,255,248,0,15,208,0,63,128,0,127,255,192,0,11,240,0,127,0,0,62,111,192,0,7,240,0,253,0,0,0,47,192,47,255,255,255,255,255,128,0,47,192,47,255,255,255,255,255,192,0,47,192,47,255,255,255,255,255,192,0,47,192,0,0,2,252,0,0,0,0,47,192,0,0,2,252,0,0,0,0,47,192,0,0,2,252,0,0,0,0,47,192,11,255,255,255,255,255,0,0,47,192,11,255,255,255,255,255,0,0,47,192,11,255,255,255,255,255,0,0,47,192,0,0,2,252,0,0,0,21,127,192,0,0,2,252,0,0,0,31,255,128,0,0,2,252,0,0,0,15,255,0,0,0,2,252,0,0,0,15,248,0,0,0,2,252,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x64ca  擊
  202,100,36,38,86,40,2,252,0,1,244,0,0,0,0,0,0,0,1,248,0,0,42,170,168,0,127,255,255,255,240,127,255,252,0,127,255,255,255,240,127,255,252,0,0,1,248,0,0,126,0,252,8,10,170,254,170,64,253,0,252,31,15,255,255,255,129,252,0,254,191,15,65,248,15,139,248,0,191,254,15,255,255,255,143,240,0,47,248,15,150,249,95,131,192,0,0,0,15,65,248,15,135,255,255,255,224,15,255,255,255,135,255,255,255,208,5,86,253,85,65,190,85,127,192,0,1,248,0,0,127,0,127,0,255,255,255,255,240,47,210,253,0,255,255,255,255,240,15,255,244,0,15,129,248,26,64,3,255,208,0,15,129,248,31,69,191,255,249,0,15,255,255,255,79,255,235,255,249,15,255,255,255,71,249,0,191,255,0,0,0,0,22,90,191,134,252,0,191,255,255,255,255,255,208,4,0,127,255,255,255,233,80,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,1,85,85,85,255,85,85,85,64,0,0,0,0,255,0,0,0,0,106,170,170,170,255,170,170,170,169,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,11,255,254,0,0,0,0,0,0,3,255,253,0,0,0,0,0,0,2,254,144,0,0,0,0,
  // 0x64cb  擋
  203,100,37,38,124,40,1,252,0,31,128,0,0,2,164,0,0,0,0,47,192,1,180,3,248,2,244,0,0,47,192,2,252,3,248,3,248,0,0,47,192,0,254,3,248,7,240,0,0,47,192,0,191,3,248,15,224,0,0,47,192,0,63,67,248,31,192,0,0,47,192,0,62,3,248,31,64,0,0,47,192,31,255,255,255,255,255,128,63,255,255,223,255,255,255,255,255,128,63,255,255,223,255,255,255,255,255,128,63,255,255,223,192,0,0,0,47,128,21,127,213,95,192,0,0,0,47,128,0,47,192,31,255,255,255,255,255,128,0,47,192,10,127,255,255,255,234,64,0,47,192,0,63,234,170,175,192,0,0,47,192,0,63,64,0,15,192,0,0,47,192,0,63,64,0,15,192,0,0,47,193,64,63,64,0,15,192,0,0,47,239,128,63,255,255,255,192,0,1,191,255,192,63,255,255,255,192,0,111,255,255,128,42,170,170,170,128,0,191,255,228,0,0,0,0,0,0,0,127,255,192,2,170,170,170,170,169,0,61,47,192,3,255,255,255,255,253,0,0,47,192,3,255,255,255,255,253,0,0,47,192,3,240,3,244,0,253,0,0,47,192,3,240,3,244,0,253,0,0,47,192,3,240,3,244,0,253,0,0,47,192,3,255,255,255,255,253,0,0,47,192,3,255,255,255,255,253,0,0,47,192,3,250,171,254,170,253,0,0,47,192,3,240,3,244,0,253,0,0,47,192,3,240,3,244,0,253,0,0,47,192,3,255,255,255,255,253,0,21,127,192,3,255,255,255,255,253,0,31,255,128,3,255,255,255,255,253,0,15,255,0,3,240,0,0,0,253,0,15,248,0,2,160,0,0,0,169,0,
  // 0x64e0  擠
  224,100,38,39,134,40,1,251,0,26,64,0,0,2,164,0,0,0,0,47,128,0,0,3,248,0,0,0,0,47,128,0,0,3,248,0,0,0,0,47,128,0,0,3,248,0,0,0,0,47,128,255,255,255,255,255,255,192,0,47,128,255,255,255,255,255,255,192,0,47,128,255,255,255,255,255,255,192,0,47,128,0,0,180,3,224,0,0,63,255,255,0,0,188,7,208,8,0,63,255,255,21,85,126,15,193,191,64,63,255,255,127,255,255,31,255,254,0,21,127,213,63,255,251,249,255,248,0,0,47,128,7,211,226,240,248,124,0,0,47,128,11,195,226,240,248,61,0,0,47,128,15,195,226,240,248,62,0,0,47,128,15,67,210,240,248,47,0,0,47,128,63,7,210,240,254,223,192,0,47,155,190,127,194,243,255,219,224,0,47,255,252,63,130,242,254,67,192,1,191,255,96,20,2,240,0,0,0,127,255,253,2,252,0,0,3,244,0,191,255,192,2,252,0,0,3,244,0,127,255,128,2,255,255,255,255,244,0,56,47,128,2,255,255,255,255,244,0,0,47,128,2,255,255,255,255,244,0,0,47,128,2,252,0,0,3,244,0,0,47,128,2,252,0,0,3,244,0,0,47,128,2,252,0,0,3,244,0,0,47,128,3,255,255,255,255,244,0,0,47,128,3,255,255,255,255,244,0,0,47,128,3,255,255,255,255,244,0,0,47,128,11,240,0,0,3,244,0,0,47,128,15,240,0,0,3,244,0,0,47,128,47,208,0,0,3,244,0,21,127,128,63,192,0,0,3,244,0,47,255,64,255,64,0,0,3,244,0,31,255,0,254,0,0,0,3,244,0,15,248,0,40,0,0,0,3,244,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6536  收
  54,101,38,38,124,40,1,252,0,0,2,164,0,41,0,0,0,0,0,0,3,248,0,63,192,0,0,0,0,0,3,248,0,63,192,0,0,0,0,0,3,248,0,127,128,0,0,0,0,0,3,248,0,191,0,0,0,0,3,248,3,248,0,255,0,0,0,0,3,248,3,248,1,254,0,0,0,0,3,248,3,248,2,254,170,170,170,144,3,248,3,248,3,255,255,255,255,208,3,248,3,248,7,255,255,255,255,208,3,248,3,248,15,255,255,255,255,208,3,248,3,248,31,244,0,3,252,0,3,248,3,248,63,252,0,3,252,0,3,248,3,248,127,252,0,3,248,0,3,248,3,248,255,253,0,7,244,0,3,248,3,251,255,254,0,15,240,0,3,248,3,255,253,255,0,15,240,0,3,248,3,255,248,127,0,31,208,0,3,248,3,249,240,63,128,63,192,0,3,248,3,248,144,63,192,63,192,0,3,248,3,248,0,31,208,191,64,0,3,248,3,248,0,15,240,255,0,0,3,248,3,248,0,11,246,254,0,0,3,248,27,248,0,3,255,252,0,0,3,254,255,248,0,3,255,248,0,0,7,255,255,248,0,1,255,240,0,0,127,255,255,248,0,0,255,208,0,0,63,255,211,248,0,0,255,208,0,0,63,228,3,248,0,3,255,240,0,0,25,0,3,248,0,15,255,252,0,0,0,0,3,248,0,63,251,255,0,0,0,0,3,248,1,255,209,255,192,0,0,0,3,248,11,255,64,127,244,0,0,0,3,248,191,253,0,47,254,0,0,0,3,251,255,244,0,11,255,224,0,0,3,250,255,128,0,1,255,192,0,0,3,248,253,0,0,0,63,64,0,0,3,244,96,0,0,0,6,0,
  // 0x653e  放
  62,101,38,38,124,40,1,252,0,0,253,0,0,3,144,0,0,0,0,1,253,0,0,7,248,0,0,0,0,1,253,0,0,11,244,0,0,0,0,1,253,0,0,15,240,0,0,0,0,1,253,0,0,15,240,0,0,0,0,1,253,0,0,15,224,0,0,0,21,86,254,85,80,31,208,0,0,0,63,255,255,255,244,47,229,85,85,64,63,255,255,255,244,63,255,255,255,208,63,255,255,255,244,127,255,255,255,208,0,63,128,0,0,191,255,255,255,208,0,63,128,0,0,255,0,7,244,0,0,63,128,0,1,255,64,7,240,0,0,63,128,0,3,255,64,11,240,0,0,63,128,0,7,255,128,15,240,0,0,63,255,255,207,255,192,15,224,0,0,63,255,255,223,255,192,31,208,0,0,63,255,255,255,239,208,47,192,0,0,63,213,127,255,207,240,63,192,0,0,63,128,63,203,71,240,63,128,0,0,63,128,63,129,3,248,127,64,0,0,63,128,63,128,3,252,255,0,0,0,63,128,63,128,2,254,254,0,0,0,63,64,63,128,0,255,252,0,0,0,127,64,63,128,0,191,248,0,0,0,127,0,63,128,0,63,240,0,0,0,191,0,63,128,0,63,240,0,0,0,255,0,63,128,0,127,240,0,0,0,254,0,63,64,0,255,252,0,0,2,253,0,63,64,3,255,254,0,0,3,252,0,63,64,15,254,255,128,0,11,248,0,127,0,127,240,191,224,0,15,240,0,191,2,255,208,47,252,0,63,224,0,255,47,255,0,15,255,128,191,192,255,255,191,252,0,3,255,208,127,64,255,253,63,224,0,0,191,64,13,0,191,244,47,0,0,0,30,0,0,0,21,0,4,0,0,0,0,0,
  // 0x6557  敗
  87,101,38,38,124,40,1,252,0,0,0,0,0,6,64,0,0,0,0,0,0,0,0,15,244,0,0,0,7,255,255,255,192,15,240,0,0,0,7,255,255,255,192,15,240,0,0,0,7,255,255,255,192,31,224,0,0,0,7,240,0,47,192,47,208,0,0,0,7,240,0,47,192,63,192,0,0,0,7,240,0,47,192,127,234,170,170,128,7,240,0,47,192,191,255,255,255,208,7,255,255,255,192,255,255,255,255,208,7,255,255,255,193,255,255,255,255,208,7,255,255,255,195,254,0,11,244,0,7,240,0,47,199,255,0,15,240,0,7,240,0,47,207,255,0,15,240,0,7,240,0,47,223,255,64,15,224,0,7,240,0,47,255,255,128,31,224,0,7,240,0,47,255,255,192,47,208,0,7,255,255,255,255,111,192,63,192,0,7,255,255,255,254,15,208,63,128,0,7,255,255,255,200,15,240,127,64,0,7,240,0,47,192,11,240,191,0,0,7,240,0,47,192,7,248,255,0,0,7,240,0,47,192,3,254,253,0,0,7,240,0,47,192,1,255,252,0,0,7,255,255,255,192,0,255,248,0,0,7,255,255,255,192,0,191,240,0,0,7,255,255,255,192,0,63,224,0,0,0,0,0,16,0,0,191,240,0,0,0,63,65,244,0,2,255,252,0,0,0,191,67,252,0,7,255,254,0,0,0,255,1,255,0,31,254,255,128,0,2,254,0,191,128,191,240,255,224,0,3,252,0,63,195,255,192,63,252,0,15,244,0,31,255,255,0,15,255,64,47,240,0,15,255,253,0,7,255,224,127,192,0,5,63,240,0,0,255,192,31,64,0,0,31,128,0,0,47,0,2,0,0,0,8,0,0,0,5,0,
  // 0x6574  整
  116,101,36,37,77,40,2,253,0,0,252,0,0,2,64,0,0,0,0,252,0,0,3,244,0,0,106,170,254,170,164,7,240,0,0,191,255,255,255,248,15,240,0,0,191,255,255,255,248,31,224,0,0,0,0,252,0,0,63,255,255,255,0,0,252,0,0,191,255,255,255,47,255,255,255,240,255,255,255,255,47,255,255,255,243,255,0,31,192,47,149,253,87,255,255,192,63,128,47,64,252,3,255,255,208,127,0,47,64,252,3,243,195,244,254,0,47,255,255,255,240,2,255,252,0,47,255,255,255,240,0,255,244,0,5,95,255,149,80,0,127,224,0,0,47,255,240,0,0,255,244,0,0,255,255,254,0,7,255,254,0,7,253,253,191,224,47,254,255,208,47,240,252,31,231,255,224,127,253,255,192,252,3,223,255,64,31,255,127,0,252,0,11,248,0,2,253,40,0,252,0,3,128,0,0,44,0,0,0,0,0,0,0,0,0,7,255,255,255,255,255,255,255,208,7,255,255,255,255,255,255,255,208,7,255,255,255,255,255,255,255,208,0,0,0,0,254,0,0,0,0,0,6,144,0,254,0,0,0,0,0,11,240,0,255,255,255,248,0,0,11,240,0,255,255,255,248,0,0,11,240,0,255,255,255,248,0,0,11,240,0,254,0,0,0,0,0,11,240,0,254,0,0,0,0,0,15,240,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x6578  數
  120,101,38,38,124,40,1,252,0,0,31,128,0,0,57,0,0,0,0,0,31,192,0,0,63,64,0,0,1,85,111,213,85,0,127,64,0,0,2,255,255,255,254,0,127,0,0,0,2,255,255,255,254,0,191,0,0,0,2,244,31,192,190,0,255,0,0,0,2,244,31,192,190,0,254,0,0,0,127,255,255,255,255,245,254,85,85,64,127,255,255,255,255,245,255,255,255,208,107,249,111,213,255,162,255,255,255,208,2,244,31,192,190,3,255,255,255,208,2,249,111,213,254,7,244,1,252,0,2,255,255,255,254,11,248,2,252,0,2,255,255,255,254,15,252,2,252,0,0,0,31,192,0,31,252,3,248,0,5,85,111,213,85,63,252,3,244,0,11,255,255,255,255,191,253,3,244,0,11,255,255,255,255,255,254,7,240,0,11,208,31,192,63,255,191,11,240,0,11,208,31,192,63,188,127,15,224,0,11,255,255,255,255,88,63,95,208,0,11,255,255,255,255,64,63,175,192,0,5,85,254,85,85,0,47,255,192,0,0,1,252,0,0,0,31,255,64,0,0,3,252,0,0,0,15,255,0,0,127,255,255,255,255,244,11,254,0,0,127,255,255,255,255,244,7,253,0,0,63,255,255,255,240,0,3,252,0,0,0,63,128,7,240,0,11,254,0,0,0,191,64,15,208,0,15,255,0,0,0,255,248,47,192,0,63,255,192,0,2,255,255,255,64,0,255,191,224,0,0,16,127,255,0,3,254,15,248,0,0,0,127,255,208,31,252,7,254,0,1,111,255,255,252,191,240,2,255,192,15,255,253,7,253,255,128,0,191,192,11,255,144,0,180,62,0,0,47,0,3,144,0,0,0,36,0,0,5,0,
  // 0x6599  料
  153,101,38,38,124,40,1,252,0,2,164,0,0,0,0,42,64,0,0,3,248,0,0,0,0,63,128,0,0,3,248,0,0,0,0,63,128,0,47,3,248,31,192,52,0,63,128,0,47,3,248,31,128,254,0,63,128,0,31,131,248,47,65,255,192,63,128,0,15,195,248,63,0,127,240,63,128,0,15,195,248,63,0,15,252,63,128,0,11,211,248,125,0,2,252,63,128,0,7,227,248,188,0,0,184,63,128,0,7,227,248,252,0,0,32,63,128,0,3,243,249,244,0,0,0,63,128,0,3,67,248,96,0,0,0,63,128,0,0,3,248,0,2,0,0,63,128,0,63,255,255,255,203,208,0,63,128,0,63,255,255,255,223,252,0,63,128,0,63,255,255,255,203,255,64,63,128,0,21,111,253,85,64,255,224,63,128,0,0,31,252,0,0,47,208,63,128,0,0,47,255,0,0,7,192,63,128,0,0,63,255,128,0,1,0,63,128,0,0,191,255,208,0,0,0,63,128,0,0,255,255,244,0,0,0,63,134,128,1,251,250,252,0,0,0,63,255,192,3,243,248,255,0,1,111,255,255,208,7,243,248,127,70,255,255,255,255,208,15,211,248,62,63,255,255,255,208,0,47,195,248,28,63,255,250,127,128,0,127,131,248,0,63,229,0,63,128,0,191,3,248,0,16,0,0,63,128,0,62,3,248,0,0,0,0,63,128,0,44,3,248,0,0,0,0,63,128,0,4,3,248,0,0,0,0,63,128,0,0,3,248,0,0,0,0,63,128,0,0,3,248,0,0,0,0,63,128,0,0,3,248,0,0,0,0,63,128,0,0,3,248,0,0,0,0,63,128,0,0,2,244,0,0,0,0,47,128,0,
  // 0x659c  斜
  156,101,38,38,124,40,1,252,0,0,127,64,0,0,0,11,224,0,0,0,255,224,0,0,0,15,224,0,0,1,255,248,0,0,0,15,224,0,0,3,255,254,0,2,64,15,224,0,0,11,250,255,128,15,208,15,224,0,0,31,240,191,224,31,248,15,224,0,0,63,208,47,248,7,254,15,224,0,0,191,128,15,253,0,255,143,224,0,2,255,0,3,255,0,63,223,224,0,7,252,0,0,252,0,15,207,224,0,31,244,0,0,112,0,7,15,224,0,127,255,255,255,224,0,0,15,224,0,255,255,255,255,224,0,0,15,224,0,62,255,255,255,224,8,0,15,224,0,8,21,127,213,64,127,64,15,224,0,0,0,63,128,0,191,224,15,224,0,0,0,63,128,0,31,248,15,224,0,0,0,63,128,0,7,255,15,224,0,63,255,255,255,254,0,255,143,224,0,63,255,255,255,254,0,62,15,224,0,63,255,255,255,254,0,8,15,224,0,21,85,127,213,84,0,0,15,224,0,0,0,63,128,0,0,0,15,251,192,0,64,63,128,128,0,0,95,255,208,2,252,63,139,224,0,111,255,255,224,3,248,63,135,240,111,255,255,255,144,3,244,63,131,244,255,255,255,240,0,7,240,63,130,252,255,255,159,224,0,11,240,63,128,252,254,64,15,224,0,15,208,63,128,254,0,0,15,224,0,47,192,63,128,191,0,0,15,224,0,63,128,63,128,63,0,0,15,224,0,127,0,63,128,52,0,0,15,224,0,30,0,63,128,0,0,0,15,224,0,0,21,127,128,0,0,0,15,224,0,0,63,255,128,0,0,0,15,224,0,0,31,255,0,0,0,0,15,224,0,0,15,248,0,0,0,0,15,224,0,
  // 0x65b0  新
  176,101,38,38,124,40,1,252,0,0,106,0,0,0,0,0,16,0,0,0,127,0,0,0,0,1,252,0,0,0,127,0,0,0,0,127,255,64,0,0,127,0,0,36,111,255,254,64,31,255,255,255,252,63,255,255,144,0,31,255,255,255,252,63,255,228,0,0,31,255,255,255,252,63,208,0,0,0,0,104,0,30,64,63,64,0,0,0,0,252,0,47,192,63,64,0,0,0,0,253,0,63,64,63,64,0,0,0,0,190,0,63,0,63,64,0,0,0,0,127,0,191,0,63,64,0,0,0,0,63,0,253,0,63,64,0,0,0,0,62,0,108,0,63,64,0,0,0,63,255,255,255,254,63,255,255,255,208,63,255,255,255,254,63,255,255,255,208,63,255,255,255,254,63,255,255,255,208,0,0,127,0,0,63,149,111,229,64,0,0,127,0,0,63,64,31,192,0,0,0,127,0,0,63,64,31,192,0,0,0,191,0,0,127,64,31,192,0,63,255,255,255,252,127,0,31,192,0,63,255,255,255,252,127,0,31,192,0,63,255,255,255,252,191,0,31,192,0,0,2,255,0,0,191,0,31,192,0,0,3,255,208,0,255,0,31,192,0,0,15,255,244,0,254,0,31,192,0,0,47,255,254,0,253,0,31,192,0,0,191,255,191,193,252,0,31,192,0,1,254,127,47,243,252,0,31,192,0,7,252,127,11,211,248,0,31,192,0,47,240,127,2,139,240,0,31,192,0,191,208,127,0,31,240,0,31,192,0,63,64,127,0,63,208,0,31,192,0,13,0,127,0,191,192,0,31,192,0,0,0,127,0,255,0,0,31,192,0,0,0,127,0,61,0,0,31,192,0,0,0,127,0,24,0,0,26,128,0,
  // 0x65b7  斷
  183,101,36,38,86,40,3,252,0,4,0,4,0,0,0,1,0,84,15,0,31,0,0,0,31,192,252,31,0,46,0,0,1,255,240,252,61,0,60,0,0,127,255,224,253,252,242,244,240,191,255,254,0,254,245,243,242,240,191,255,144,0,252,191,208,247,192,191,228,0,0,252,63,192,127,128,191,0,0,0,252,15,64,47,0,191,0,0,0,252,46,176,61,176,191,0,0,0,252,60,116,124,120,191,0,0,0,255,255,255,255,252,191,0,0,0,254,255,191,255,189,191,0,0,0,252,0,20,0,8,191,85,85,84,255,170,170,170,168,191,255,255,253,255,255,255,255,252,191,255,255,253,255,255,255,255,252,191,255,255,253,252,15,0,31,0,191,0,190,0,252,31,0,62,0,191,0,190,0,252,61,0,124,0,190,0,190,0,253,252,162,244,144,190,0,190,0,254,245,243,241,240,190,0,190,0,252,254,225,247,208,190,0,190,0,252,63,192,191,192,254,0,190,0,252,47,64,63,0,253,0,190,0,252,15,96,46,96,253,0,190,0,252,44,180,60,180,252,0,190,0,252,125,184,185,189,252,0,190,0,255,255,255,255,255,252,0,190,0,254,250,111,233,111,248,0,190,0,252,0,0,0,3,244,0,190,0,255,255,255,255,255,240,0,190,0,255,255,255,255,255,240,0,190,0,255,255,255,255,255,208,0,190,0,252,0,0,0,63,192,0,190,0,252,0,0,0,63,128,0,190,0,252,0,0,0,11,0,0,190,0,0,0,0,0,1,0,0,105,0,
  // 0x65bc  於
  188,101,38,39,134,40,1,251,0,1,252,0,0,0,127,128,0,0,0,1,252,0,0,0,191,192,0,0,0,1,252,0,0,0,255,208,0,0,0,1,252,0,0,1,255,240,0,0,0,1,252,0,0,3,255,244,0,0,0,1,252,0,0,7,247,252,0,0,21,86,254,85,80,15,241,253,0,0,63,255,255,255,240,31,224,255,0,0,63,255,255,255,240,63,192,127,128,0,63,255,255,255,240,191,128,63,208,0,0,63,128,0,1,255,0,31,240,0,0,63,128,0,3,253,0,11,252,0,0,63,128,0,15,248,0,3,254,0,0,63,128,0,47,240,0,1,255,192,0,63,64,0,191,208,0,0,191,224,0,63,255,255,127,64,0,0,47,192,0,63,255,255,45,1,244,0,11,64,0,63,255,255,20,7,254,0,2,0,0,127,149,191,0,2,255,192,0,0,0,127,0,127,0,0,127,240,0,0,0,191,0,127,0,0,31,252,0,0,0,191,0,127,0,0,3,255,0,0,0,191,0,127,0,0,0,252,0,0,0,255,0,191,0,0,0,116,0,0,0,254,0,191,0,0,0,0,0,0,0,254,0,191,0,0,0,0,0,0,0,253,0,191,0,32,0,0,0,0,1,252,0,191,0,190,0,0,0,0,2,252,0,191,1,255,224,0,0,0,3,252,0,191,1,255,253,0,0,0,7,248,0,255,0,47,255,192,0,0,11,240,0,254,0,2,255,248,0,0,15,240,0,254,0,0,127,255,0,0,47,224,0,253,0,0,11,255,208,0,63,193,71,253,0,0,1,255,244,0,191,130,255,252,0,0,0,47,244,0,47,1,255,248,0,0,0,7,224,0,9,0,255,208,0,0,0,1,192,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6607  昇
  7,102,36,36,68,40,2,252,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,254,0,0,0,0,0,255,0,0,254,0,0,0,0,0,255,0,0,254,0,0,0,0,0,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,254,0,0,0,0,0,255,0,0,254,0,0,0,0,0,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,0,0,0,96,0,0,0,0,0,0,0,27,252,0,255,0,0,0,1,111,255,255,0,255,0,0,6,255,255,255,249,0,255,0,0,11,255,255,254,64,0,255,0,0,3,255,239,240,0,0,255,0,0,1,64,15,240,0,0,255,0,0,0,0,15,240,0,0,255,0,0,85,85,95,245,85,85,255,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,31,208,0,0,255,0,0,0,0,63,192,0,0,255,0,0,0,0,191,192,0,0,255,0,0,0,1,255,64,0,0,255,0,0,0,11,255,0,0,0,255,0,0,0,127,252,0,0,0,255,0,0,11,255,240,0,0,0,255,0,0,15,255,128,0,0,0,255,0,0,3,248,0,0,0,0,255,0,0,2,128,0,0,0,0,170,0,0,
  // 0x660e  明
  14,102,34,36,68,40,3,252,85,85,85,64,63,255,255,255,240,255,255,255,224,63,255,255,255,240,255,255,255,224,63,255,255,255,240,255,255,255,224,63,149,85,91,240,254,0,15,224,63,64,0,11,240,254,0,15,224,63,64,0,11,240,254,0,15,224,63,64,0,11,240,254,0,15,224,63,64,0,11,240,254,0,15,224,63,64,0,11,240,254,0,15,224,63,149,85,91,240,254,0,15,224,63,255,255,255,240,255,255,255,224,63,255,255,255,240,255,255,255,224,63,255,255,255,240,255,255,255,224,63,64,0,11,240,255,85,95,224,63,64,0,11,240,254,0,15,224,63,64,0,11,240,254,0,15,224,127,64,0,11,240,254,0,15,224,127,64,0,11,240,254,0,15,224,127,64,0,11,240,254,0,15,224,127,149,85,91,240,254,0,15,224,191,255,255,255,240,255,85,95,224,191,255,255,255,240,255,255,255,224,255,255,255,255,240,255,255,255,224,254,0,0,11,240,255,255,255,225,253,0,0,11,240,254,0,0,3,252,0,0,11,240,254,0,0,3,252,0,0,11,240,254,0,0,11,244,0,0,11,240,169,0,0,15,240,0,0,11,240,0,0,0,63,224,0,0,11,240,0,0,0,191,192,0,0,11,240,0,0,1,255,64,0,0,11,240,0,0,11,254,0,0,255,255,240,0,0,15,252,0,0,127,255,224,0,0,3,224,0,0,63,255,128,0,0,0,128,0,0,26,148,0,
  // 0x662f  是
  47,102,36,36,68,40,2,252,0,191,255,255,255,255,255,253,0,0,191,255,255,255,255,255,253,0,0,191,255,255,255,255,255,253,0,0,191,0,0,0,0,1,253,0,0,191,0,0,0,0,1,253,0,0,191,170,170,170,170,170,253,0,0,191,255,255,255,255,255,253,0,0,191,255,255,255,255,255,253,0,0,191,0,0,0,0,1,253,0,0,191,0,0,0,0,1,253,0,0,191,0,0,0,0,1,253,0,0,191,255,255,255,255,255,253,0,0,191,255,255,255,255,255,253,0,0,127,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,21,85,85,85,191,85,85,85,84,0,2,80,0,127,0,0,0,0,0,7,248,0,127,0,0,0,0,0,11,244,0,127,0,0,0,0,0,15,240,0,127,255,255,255,192,0,15,240,0,127,255,255,255,192,0,47,240,0,127,255,255,255,192,0,63,252,0,127,64,0,0,0,0,127,254,0,127,0,0,0,0,0,255,255,64,127,0,0,0,0,3,254,127,240,127,0,0,0,0,11,252,31,254,191,0,0,0,0,47,244,7,255,255,170,85,85,85,191,224,0,255,255,255,255,255,255,255,128,0,31,255,255,255,255,254,62,0,0,0,27,255,255,255,253,8,0,0,0,0,0,0,0,0,
  // 0x6642  時
  66,102,36,38,86,40,3,252,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,85,85,85,0,0,15,224,0,0,255,255,255,0,0,15,224,0,0,255,255,255,0,0,15,240,0,0,255,255,255,15,255,255,255,255,240,253,0,191,15,255,255,255,255,240,253,0,191,15,255,255,255,255,240,253,0,191,0,0,15,224,0,0,253,0,191,0,0,15,224,0,0,253,0,191,0,0,15,224,0,0,253,0,191,0,0,15,224,0,0,253,0,191,21,85,95,245,85,84,253,0,191,191,255,255,255,255,253,254,85,255,191,255,255,255,255,253,255,255,255,191,255,255,255,255,253,255,255,255,0,0,0,3,252,0,255,255,255,0,0,0,3,252,0,253,0,191,0,0,0,3,252,0,253,0,191,0,0,0,3,252,0,253,0,191,127,255,255,255,255,252,253,0,191,127,255,255,255,255,252,253,0,191,127,255,255,255,255,252,253,0,191,21,85,85,87,253,84,253,0,191,0,16,0,3,252,0,253,0,191,0,248,0,3,252,0,254,85,255,3,253,0,3,252,0,255,255,255,1,255,0,3,252,0,255,255,255,0,191,192,3,252,0,255,255,255,0,63,224,3,252,0,253,0,0,0,15,240,3,252,0,253,0,0,0,7,244,3,252,0,253,0,0,0,3,128,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,31,255,248,0,0,0,0,0,0,15,255,244,0,0,0,0,0,0,15,255,224,0,0,0,0,0,0,1,84,0,0,
  // 0x66ab  暫
  171,102,36,38,86,40,2,252,0,0,252,0,0,0,0,1,64,0,0,252,0,0,0,0,111,208,21,85,253,85,80,229,175,255,244,127,255,255,255,244,255,255,255,144,127,255,255,255,244,255,255,144,0,0,0,252,0,0,254,64,0,0,26,171,255,170,144,252,0,0,0,31,255,255,255,224,252,0,0,0,31,64,252,7,224,252,0,0,0,31,64,252,7,224,255,255,255,255,31,255,255,255,224,255,255,255,255,31,234,254,175,225,255,255,255,255,31,64,252,7,225,252,0,253,0,31,255,255,255,226,252,0,253,0,31,255,255,255,227,248,0,253,0,0,0,252,0,3,244,0,253,0,0,1,253,0,11,240,0,253,0,255,255,255,255,255,224,0,253,0,255,255,255,255,255,192,0,253,0,0,0,252,0,191,64,0,253,0,0,0,252,0,62,0,0,253,0,0,0,168,0,8,0,0,84,0,0,31,255,255,255,255,255,244,0,0,31,255,255,255,255,255,244,0,0,31,255,255,255,255,255,244,0,0,31,208,0,0,0,7,244,0,0,31,208,0,0,0,7,244,0,0,31,208,0,0,0,7,244,0,0,31,255,255,255,255,255,244,0,0,31,255,255,255,255,255,244,0,0,31,234,170,170,170,175,244,0,0,31,208,0,0,0,7,244,0,0,31,208,0,0,0,7,244,0,0,31,255,255,255,255,255,244,0,0,31,255,255,255,255,255,244,0,0,31,255,255,255,255,255,244,0,0,31,208,0,0,0,7,244,0,0,10,128,0,0,0,2,164,0,
  // 0x66f4  更
  244,102,37,36,104,40,2,252,127,255,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,255,253,0,21,85,85,85,255,149,85,85,84,0,0,0,0,0,191,0,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,254,0,0,191,0,0,63,192,0,0,254,0,0,191,0,0,63,192,0,0,254,0,0,191,0,0,63,192,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,254,0,0,191,0,0,63,192,0,0,254,0,0,191,0,0,63,192,0,0,254,0,0,191,0,0,63,192,0,0,255,0,0,191,0,0,63,192,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,255,192,0,0,1,128,1,254,0,0,0,0,0,0,31,224,3,252,0,0,0,0,0,0,15,244,7,252,0,0,0,0,0,0,7,254,15,244,0,0,0,0,0,0,1,255,191,240,0,0,0,0,0,0,0,127,255,192,0,0,0,0,0,0,0,47,255,192,0,0,0,0,0,0,1,191,255,254,64,0,0,0,0,0,111,255,255,255,255,165,64,0,0,111,255,255,71,255,255,255,255,255,64,127,255,244,0,47,255,255,255,255,0,47,254,0,0,0,27,255,255,254,0,14,64,0,0,0,0,0,86,168,0,
  // 0x6700  最
  0,103,36,37,77,40,2,252,0,26,170,170,170,170,170,168,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,128,0,0,0,2,252,0,0,63,128,0,0,0,2,252,0,0,63,213,85,85,85,87,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,128,0,0,0,2,252,0,0,63,128,0,0,0,2,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,21,85,85,85,85,85,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,253,191,255,255,255,255,255,255,255,253,191,255,255,255,255,255,255,255,253,1,252,0,47,192,0,0,0,0,1,252,0,47,192,0,0,0,0,1,255,255,255,207,255,255,255,224,1,255,255,255,207,255,255,255,240,1,254,170,191,203,255,255,255,224,1,252,0,47,192,188,0,47,208,1,252,0,47,192,254,0,63,192,1,254,170,191,192,127,0,255,64,1,255,255,255,192,63,194,255,0,1,255,255,255,192,31,231,252,0,1,252,0,47,192,11,255,244,0,1,252,0,47,192,3,255,224,0,1,252,21,191,192,2,255,192,0,191,255,255,255,192,31,255,244,0,255,255,255,255,193,255,255,254,0,191,255,165,111,239,255,210,255,248,84,0,0,47,239,254,0,127,255,0,0,0,47,207,224,0,11,252,0,0,0,47,198,0,0,0,104,
  // 0x6709  有
  9,103,36,38,86,40,2,252,0,0,0,36,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,0,0,0,0,0,21,85,86,255,85,85,85,85,84,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,0,0,31,240,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,2,255,255,255,255,255,252,0,0,7,255,255,255,255,255,252,0,0,15,255,255,255,255,255,252,0,0,63,254,0,0,0,3,252,0,0,255,254,0,0,0,2,252,0,2,255,254,0,0,0,2,252,0,11,254,254,0,0,0,3,252,0,63,248,255,255,255,255,255,252,0,255,224,255,255,255,255,255,252,0,255,128,255,255,255,255,255,252,0,61,0,254,0,0,0,2,252,0,20,0,254,0,0,0,2,252,0,0,0,254,0,0,0,2,252,0,0,0,254,0,0,0,3,252,0,0,0,255,255,255,255,255,252,0,0,0,255,255,255,255,255,252,0,0,0,255,255,255,255,255,252,0,0,0,254,0,0,0,2,252,0,0,0,254,0,0,0,2,252,0,0,0,254,0,0,0,2,252,0,0,0,254,0,0,0,3,252,0,0,0,254,0,0,63,255,252,0,0,0,254,0,0,31,255,248,0,0,0,254,0,0,15,255,224,0,0,0,169,0,0,10,149,0,0,
  // 0x677f  板
  127,103,38,38,124,40,1,252,0,3,240,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,3,244,0,21,85,85,85,85,64,0,3,244,0,63,255,255,255,255,128,0,3,244,0,63,255,255,255,255,128,0,3,244,0,63,255,255,255,255,128,0,3,244,0,63,128,0,0,0,0,0,3,244,0,63,128,0,0,0,0,0,3,244,0,63,128,0,0,0,0,63,255,255,252,63,128,0,0,0,0,63,255,255,252,63,128,0,0,0,0,63,255,255,252,63,128,0,0,0,0,21,95,249,84,63,128,0,0,0,0,0,15,244,0,63,255,255,255,254,0,0,15,244,0,63,255,255,255,255,0,0,31,248,0,63,255,255,255,255,0,0,63,253,0,63,255,85,85,254,0,0,63,255,0,63,255,0,0,253,0,0,191,255,192,63,191,64,2,252,0,0,255,255,224,63,127,128,3,252,0,1,255,247,244,63,95,192,3,248,0,3,247,246,252,127,79,208,11,240,0,7,243,244,253,127,11,240,15,240,0,11,211,244,124,191,7,244,47,208,0,31,195,244,48,191,3,252,63,192,0,63,131,244,0,254,1,254,191,128,0,191,3,244,0,254,0,255,255,0,0,126,3,244,1,253,0,127,253,0,0,60,3,244,2,252,0,47,248,0,0,24,3,244,3,252,0,47,248,0,0,0,3,244,7,244,0,191,254,0,0,0,3,244,11,240,2,255,255,128,0,0,3,244,15,240,11,254,191,224,0,0,3,244,47,208,127,248,47,254,0,0,3,244,127,195,255,208,11,255,208,0,3,244,191,67,255,64,2,255,192,0,3,244,31,0,248,0,0,63,0,0,3,240,4,0,80,0,0,5,0,
  // 0x67f1  柱
  241,103,38,38,124,40,1,252,0,2,248,0,0,2,0,0,0,0,0,2,252,0,0,15,208,0,0,0,0,2,252,0,0,63,248,0,0,0,0,2,252,0,0,15,255,0,0,0,0,2,252,0,0,2,255,192,0,0,0,2,252,0,0,0,127,240,0,0,0,2,252,0,0,0,31,248,0,0,0,2,252,0,0,0,7,240,0,0,0,2,252,0,42,170,171,234,170,64,63,255,255,255,63,255,255,255,255,192,63,255,255,255,63,255,255,255,255,192,63,255,255,255,63,255,255,255,255,192,26,171,254,170,0,0,63,192,0,0,0,7,252,0,0,0,63,192,0,0,0,15,252,0,0,0,63,192,0,0,0,15,252,0,0,0,63,192,0,0,0,31,254,0,0,0,63,192,0,0,0,63,255,128,0,0,63,192,0,0,0,63,255,208,0,0,63,192,0,0,0,191,255,244,0,0,63,192,0,0,0,254,254,252,15,255,255,255,255,64,2,250,252,255,15,255,255,255,255,64,3,242,252,127,79,255,255,255,255,64,11,226,252,46,5,85,191,213,85,0,15,210,252,12,0,0,63,192,0,0,63,194,252,0,0,0,63,192,0,0,127,66,252,0,0,0,63,192,0,0,127,2,252,0,0,0,63,192,0,0,61,2,252,0,0,0,63,192,0,0,24,2,252,0,0,0,63,192,0,0,0,2,252,0,0,0,63,192,0,0,0,2,252,0,0,0,63,192,0,0,0,2,252,0,0,0,63,192,0,0,0,2,252,3,255,255,255,255,255,224,0,2,252,3,255,255,255,255,255,224,0,2,252,3,255,255,255,255,255,224,0,2,252,2,170,170,170,170,170,144,0,2,248,0,0,0,0,0,0,0,
  // 0x6821  校
  33,104,38,38,124,40,1,252,0,7,240,0,0,0,255,0,0,0,0,7,240,0,0,0,255,0,0,0,0,7,240,0,0,0,255,0,0,0,0,7,240,0,0,0,255,0,0,0,0,7,240,0,0,0,255,0,0,0,0,7,240,0,0,0,255,0,0,0,0,7,240,3,255,255,255,255,255,192,0,7,240,3,255,255,255,255,255,192,0,7,240,3,255,255,255,255,255,192,63,255,255,250,255,255,255,255,255,128,63,255,255,248,0,0,0,0,0,0,63,255,255,248,1,244,0,47,0,0,21,95,249,84,3,252,0,127,192,0,0,15,240,0,11,248,0,47,224,0,0,31,240,0,15,240,0,15,248,0,0,47,244,0,63,208,0,3,253,0,0,63,252,0,191,128,0,0,255,0,0,63,255,2,255,0,0,0,127,128,0,191,255,139,253,176,0,62,127,208,0,255,255,195,247,248,0,191,79,128,1,255,251,240,210,252,0,255,9,0,2,251,243,244,0,254,0,254,0,0,3,247,241,252,0,191,2,253,0,0,11,215,240,244,0,127,131,252,0,0,15,199,240,96,0,47,219,244,0,0,47,135,240,0,0,15,255,240,0,0,127,71,240,0,0,11,255,192,0,0,127,7,240,0,0,3,255,128,0,0,61,7,240,0,0,2,255,128,0,0,24,7,240,0,0,11,255,224,0,0,0,7,240,0,0,47,255,248,0,0,0,7,240,0,0,255,223,255,0,0,0,7,240,0,11,255,66,255,208,0,0,7,240,0,127,253,0,191,253,0,0,7,240,11,255,224,0,47,255,208,0,7,240,15,255,64,0,7,255,192,0,7,240,7,248,0,0,0,191,0,0,7,240,3,64,0,0,0,9,0,
  // 0x683c  格
  60,104,38,38,124,40,1,252,0,2,160,0,0,9,0,0,0,0,0,3,244,0,0,31,208,0,0,0,0,3,244,0,0,63,192,0,0,0,0,3,244,0,0,127,128,0,0,0,0,3,244,0,0,255,64,0,64,0,0,3,244,0,1,255,255,255,244,0,0,3,244,0,3,255,255,255,244,0,0,3,244,0,15,255,255,255,240,0,0,3,244,0,31,240,0,31,224,0,63,255,255,252,127,244,0,63,192,0,63,255,255,253,255,252,0,127,128,0,63,255,255,255,255,255,0,255,0,0,21,95,249,111,252,127,131,253,0,0,0,15,244,11,240,63,219,248,0,0,0,15,252,1,192,15,255,240,0,0,0,31,254,0,0,3,255,192,0,0,0,47,255,128,0,3,255,192,0,0,0,63,255,208,0,31,255,244,0,0,0,127,251,240,0,191,255,254,0,0,0,255,247,252,3,255,195,255,208,0,0,255,244,248,127,254,0,191,254,64,2,247,244,183,255,244,0,31,255,224,3,243,244,63,255,208,0,3,255,192,11,211,244,31,255,255,255,255,255,64,15,195,244,15,175,255,255,255,245,0,63,131,244,0,47,255,255,255,244,0,127,3,244,0,47,192,0,3,244,0,127,3,244,0,47,192,0,3,244,0,60,3,244,0,47,192,0,3,244,0,24,3,244,0,47,192,0,3,244,0,0,3,244,0,47,192,0,3,244,0,0,3,244,0,47,192,0,3,244,0,0,3,244,0,47,192,0,3,244,0,0,3,244,0,47,255,255,255,244,0,0,3,244,0,47,255,255,255,244,0,0,3,244,0,47,255,255,255,244,0,0,3,244,0,47,192,0,7,244,0,0,3,240,0,31,128,0,2,160,0,
  // 0x689d  條
  157,104,38,38,124,40,1,252,0,0,64,0,0,24,0,0,0,0,0,1,248,0,0,47,192,0,0,0,0,2,252,0,0,63,128,0,0,0,0,3,252,0,0,191,0,0,0,0,0,7,248,0,0,254,0,0,0,0,0,11,241,80,3,255,255,255,255,192,0,15,243,244,7,255,255,255,255,192,0,47,211,244,31,255,255,255,255,192,0,63,195,244,63,240,0,31,224,0,0,127,131,244,255,248,0,63,192,0,0,255,67,251,255,253,0,191,64,0,2,255,67,251,252,191,65,255,0,0,3,255,67,244,240,63,231,252,0,0,11,255,67,244,0,15,255,240,0,0,31,255,67,244,0,3,255,208,0,0,63,255,67,244,0,11,255,244,0,0,255,255,67,244,1,255,255,255,128,0,255,127,67,244,111,255,210,255,254,64,125,63,67,247,255,253,0,47,255,208,56,63,67,244,255,208,106,2,255,128,16,63,67,244,120,0,191,0,27,0,0,63,67,244,0,0,191,0,0,0,0,63,67,244,0,0,191,0,0,0,0,63,67,244,255,255,255,255,255,192,0,63,67,244,255,255,255,255,255,192,0,63,67,244,255,255,255,255,255,192,0,63,67,244,0,3,255,224,0,0,0,63,67,244,0,15,255,244,0,0,0,63,67,244,0,63,255,253,0,0,0,63,67,244,0,255,255,255,0,0,0,63,67,244,3,254,191,63,192,0,0,63,64,0,31,248,191,15,244,0,0,63,64,0,191,224,191,7,254,0,0,63,64,11,255,128,191,1,255,208,0,63,64,15,253,0,191,0,127,208,0,63,64,3,240,0,191,0,15,64,0,63,64,1,64,0,191,0,1,0,0,63,64,0,0,0,127,0,0,0,
  // 0x68c4  棄
  196,104,36,38,86,40,2,252,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,0,0,15,244,0,3,252,0,0,0,0,47,224,0,7,255,128,0,0,0,127,192,0,0,127,248,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,224,15,255,255,255,255,250,170,175,240,0,0,0,0,84,0,0,2,192,0,11,224,0,254,0,15,224,0,0,11,224,0,254,0,15,224,0,127,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,11,224,0,254,0,15,224,0,0,11,224,0,254,0,15,224,0,0,11,224,0,254,0,15,224,0,0,11,255,255,255,255,255,224,0,0,11,255,255,255,255,255,224,0,0,11,255,255,255,255,255,224,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,1,255,255,255,64,0,0,0,0,11,253,255,127,224,0,0,0,0,191,240,255,15,254,0,0,0,27,255,128,255,2,255,244,0,6,255,248,0,255,0,47,255,144,191,255,208,0,255,0,7,255,255,191,253,0,0,255,0,0,47,254,63,128,0,0,255,0,0,1,248,4,0,0,0,254,0,0,0,0,
  // 0x69fd  槽
  253,105,38,38,124,40,1,252,0,15,224,0,0,127,3,240,0,0,0,15,224,0,0,127,3,240,0,0,0,15,224,0,0,127,3,240,0,0,0,15,224,31,255,255,255,255,255,208,0,15,224,31,255,255,255,255,255,208,0,15,224,31,255,255,255,255,255,208,0,15,224,0,0,127,3,240,0,0,0,15,224,0,0,127,3,240,0,0,0,15,224,2,170,191,171,250,170,0,63,255,255,227,255,255,255,255,255,0,63,255,255,227,255,255,255,255,255,0,63,255,255,227,240,63,3,224,63,0,21,111,245,83,240,63,3,224,63,0,0,31,224,3,240,63,3,224,63,0,0,47,224,3,255,255,255,255,255,0,0,63,240,3,255,255,255,255,255,0,0,63,244,3,245,127,87,245,127,0,0,191,252,3,240,63,3,224,63,0,0,255,255,3,240,63,3,224,63,0,0,255,255,67,255,255,255,255,255,0,2,255,239,195,255,255,255,255,255,0,3,255,231,226,170,170,170,170,170,0,7,223,227,240,0,0,0,0,0,0,15,207,225,192,127,255,255,255,248,0,31,207,224,64,191,255,255,255,248,0,63,79,224,0,191,255,255,255,248,0,127,15,224,0,191,0,0,3,248,0,126,15,224,0,191,0,0,3,248,0,60,15,224,0,191,170,170,171,248,0,20,15,224,0,191,255,255,255,248,0,0,15,224,0,191,255,255,255,248,0,0,15,224,0,191,0,0,3,248,0,0,15,224,0,191,0,0,3,248,0,0,15,224,0,191,0,0,3,248,0,0,15,224,0,191,255,255,255,248,0,0,15,224,0,191,255,255,255,248,0,0,15,224,0,191,255,255,255,248,0,0,15,208,0,191,0,0,3,248,0,
  // 0x6a59  橙
  89,106,38,38,124,40,1,252,0,6,160,0,0,0,0,0,0,0,0,11,240,0,0,0,11,192,0,0,0,11,240,3,255,254,15,192,208,0,0,11,240,3,255,255,75,227,240,0,0,11,240,3,255,255,7,255,244,0,0,11,240,0,0,190,3,255,128,0,0,11,240,1,0,253,2,253,2,0,0,11,240,7,226,252,1,252,15,128,0,11,240,15,255,244,0,255,127,192,63,255,255,242,255,240,0,127,254,0,63,255,255,240,127,224,0,63,244,0,63,255,255,240,63,255,255,255,240,0,21,95,245,80,255,255,255,255,252,0,0,15,240,3,254,191,255,247,255,0,0,31,240,15,248,0,0,0,255,208,0,47,240,127,240,0,0,0,63,224,0,63,252,63,192,0,0,0,15,128,0,127,254,30,127,255,255,255,242,0,0,191,255,68,127,255,255,255,240,0,0,255,255,192,127,234,170,175,240,0,1,255,251,240,127,0,0,7,240,0,3,251,243,248,127,0,0,7,240,0,3,251,241,240,127,0,0,7,240,0,11,219,240,208,127,0,0,7,240,0,15,203,240,0,127,255,255,255,240,0,47,139,240,0,127,255,255,255,240,0,127,75,240,0,63,255,255,255,240,0,191,11,240,0,1,144,0,61,0,0,61,11,240,0,15,224,0,127,128,0,28,11,240,0,7,240,0,191,0,0,0,11,240,0,3,244,0,254,0,0,0,11,240,0,3,248,1,252,0,0,0,11,240,0,2,252,2,248,0,0,0,11,240,0,1,228,1,244,0,0,0,11,240,47,255,255,255,255,255,208,0,11,240,47,255,255,255,255,255,208,0,11,240,47,255,255,255,255,255,208,0,11,240,0,0,0,0,0,0,0,
  // 0x6a5f  機
  95,106,38,38,124,40,1,252,0,15,192,0,0,2,160,0,0,0,0,15,192,0,189,3,240,15,128,0,0,15,192,0,253,3,240,31,192,0,0,15,192,1,248,3,240,47,64,0,0,15,192,2,240,3,240,62,0,0,0,15,192,3,225,231,240,188,45,0,0,15,192,63,195,251,247,248,63,0,0,15,192,127,135,243,255,240,189,0,0,15,192,47,207,211,247,248,252,0,63,255,255,203,255,131,240,255,240,0,63,255,255,194,255,3,240,63,224,0,63,255,255,192,253,3,244,15,192,0,21,111,229,64,249,163,244,47,95,0,0,47,192,3,242,243,244,126,15,64,0,63,208,11,208,246,244,253,95,192,0,63,240,127,255,250,255,255,255,192,0,127,248,63,255,254,255,255,255,208,0,255,252,63,250,190,255,174,67,224,0,255,255,0,0,33,252,31,129,0,1,255,223,64,0,0,252,31,240,0,2,255,207,192,0,0,252,3,244,0,3,239,199,255,255,255,255,255,255,192,11,223,195,191,255,255,255,255,255,192,15,207,193,63,255,255,255,255,255,192,31,143,192,1,252,0,127,1,64,0,63,15,192,2,252,0,63,3,244,0,127,15,192,2,253,0,63,7,244,0,125,15,192,3,255,128,63,143,224,0,60,15,192,3,255,244,47,255,192,0,20,15,192,7,251,253,15,255,64,0,0,15,192,11,241,253,15,254,0,0,0,15,192,15,208,120,15,248,3,128,0,15,192,47,192,0,127,248,3,240,0,15,192,127,128,2,255,253,3,224,0,15,193,255,0,47,253,255,75,208,0,15,195,253,1,255,240,127,255,192,0,15,192,244,0,255,64,31,255,128,0,15,192,80,0,36,0,2,254,0,
  // 0x6aa2  檢
  162,106,38,38,124,40,1,252,0,7,224,0,0,2,168,0,0,0,0,11,240,0,0,7,255,0,0,0,0,11,240,0,0,15,255,128,0,0,0,11,240,0,0,47,255,224,0,0,0,11,240,0,0,191,207,244,0,0,0,11,240,0,1,255,7,253,0,0,0,11,240,0,7,253,1,255,128,0,0,11,240,0,31,244,0,191,224,0,0,11,240,0,191,208,0,31,252,0,63,255,255,243,255,128,0,7,255,128,63,255,255,255,255,255,255,255,255,224,63,255,255,255,247,255,255,254,63,192,21,95,245,95,195,255,255,254,11,64,0,15,240,6,0,0,0,0,1,0,0,31,240,0,0,0,0,0,0,0,0,47,244,2,170,170,70,170,170,0,0,63,252,3,255,255,139,255,255,0,0,127,254,3,255,255,139,255,255,0,0,191,255,67,240,31,139,192,63,0,0,255,255,195,240,31,139,192,63,0,1,255,251,227,240,31,139,192,63,0,2,251,243,247,240,31,139,192,63,0,3,235,241,243,250,175,139,234,191,0,11,219,240,211,255,255,139,255,255,0,15,203,240,67,255,255,139,255,255,0,47,139,240,0,0,0,0,16,0,0,127,11,240,0,11,224,0,63,64,0,126,11,240,0,15,224,0,63,0,0,60,11,240,0,15,208,0,127,0,0,24,11,240,0,47,192,0,254,0,0,0,11,240,0,63,224,1,255,64,0,0,11,240,0,191,248,3,255,208,0,0,11,240,1,255,255,11,255,248,0,0,11,240,7,252,191,95,243,255,0,0,11,240,31,240,46,191,192,255,192,0,11,240,127,208,5,255,64,63,224,0,11,240,47,64,0,188,0,15,128,0,7,224,8,0,0,32,0,2,0,
  // 0x6b62  止
  98,107,36,36,68,40,2,254,0,0,0,0,26,144,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,250,170,170,160,0,47,192,0,31,255,255,255,240,0,47,192,0,31,255,255,255,240,0,47,192,0,31,255,255,255,240,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,170,170,170,170,170,
  // 0x6b63  正
  99,107,36,33,41,40,2,254,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,26,170,170,170,191,234,170,170,164,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,255,255,255,192,0,47,192,0,63,255,255,255,192,0,47,192,0,63,255,255,255,192,0,47,192,0,63,234,170,170,128,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,170,191,234,170,191,234,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x6b65  步
  101,107,36,38,86,40,2,252,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,15,224,0,255,0,0,0,0,0,15,224,0,255,170,170,169,0,0,15,224,0,255,255,255,254,0,0,15,224,0,255,255,255,254,0,0,15,224,0,255,255,255,254,0,0,15,224,0,255,0,0,0,0,0,15,224,0,255,0,0,0,0,0,15,224,0,255,0,0,0,0,0,15,224,0,255,0,0,0,0,255,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,255,254,106,170,170,170,255,170,170,170,169,0,0,0,0,255,0,0,0,0,0,1,248,0,255,0,0,0,0,0,3,254,0,255,0,0,228,0,0,15,252,0,255,0,2,254,0,0,63,240,0,255,0,3,253,0,0,255,208,0,255,0,7,252,0,3,255,64,0,255,0,15,244,0,31,254,0,0,255,0,47,240,0,191,248,0,0,255,0,127,208,0,63,208,3,255,255,0,255,128,0,11,64,1,255,254,3,255,0,0,0,0,0,255,248,15,253,0,0,0,0,0,85,0,127,244,0,0,0,0,0,0,2,255,208,0,0,0,0,0,0,47,255,64,0,0,0,0,0,6,255,252,0,0,0,0,0,1,191,255,224,0,0,0,0,5,191,255,254,0,0,0,0,2,255,255,255,224,0,0,0,0,0,255,255,249,0,0,0,0,0,0,191,254,64,0,0,0,0,0,0,57,0,0,0,0,0,0,0,
  // 0x6b78  歸
  120,107,38,38,124,40,1,252,0,7,160,0,0,0,0,0,0,0,0,11,240,0,2,170,170,170,160,0,0,15,224,0,3,255,255,255,240,0,6,175,250,169,3,255,255,255,240,0,7,255,255,253,0,0,0,7,240,0,7,255,255,253,0,0,0,7,240,0,7,224,0,189,106,170,170,171,250,128,7,224,0,189,191,255,255,255,255,208,7,224,0,189,191,255,255,255,255,208,7,255,255,253,0,0,0,7,240,0,7,255,255,253,0,0,0,7,240,0,7,250,170,169,3,255,255,255,240,0,7,224,0,0,3,255,255,255,240,0,7,250,170,169,2,170,170,170,160,0,7,255,255,254,0,0,0,0,0,0,7,255,255,254,47,255,255,255,255,64,7,224,0,190,63,255,255,255,255,128,7,224,0,190,63,255,255,255,255,128,7,250,170,254,63,0,63,64,47,128,7,255,255,254,63,0,63,64,47,128,7,255,255,254,63,0,63,64,47,128,0,1,248,0,5,0,63,64,5,0,0,1,248,0,11,255,255,255,252,0,0,1,248,0,11,255,255,255,253,0,11,193,248,0,11,255,255,255,253,0,11,193,255,255,11,224,63,64,253,0,11,193,255,255,11,224,63,64,253,0,11,193,255,255,11,224,63,64,253,0,11,193,248,0,11,224,63,64,253,0,11,193,248,0,11,224,63,64,253,0,11,193,248,0,11,224,63,64,253,0,11,193,249,111,75,224,63,64,253,0,11,214,255,255,139,224,63,111,252,0,127,255,255,255,139,224,63,95,252,0,127,255,255,233,11,224,63,74,144,0,63,254,144,0,0,0,63,64,0,0,37,0,0,0,0,0,63,64,0,0,0,0,0,0,0,0,63,64,0,0,
  // 0x6bbc  殼
  188,107,37,38,124,40,2,252,0,2,248,0,0,0,0,0,0,0,0,2,252,0,0,21,85,85,0,0,0,2,252,0,0,63,255,255,0,0,170,171,254,170,160,63,255,255,0,0,255,255,255,255,224,63,255,255,0,0,255,255,255,255,224,63,0,127,0,0,0,2,252,0,0,63,0,127,0,0,0,2,252,0,0,127,0,127,0,0,26,171,254,170,64,127,0,127,0,0,47,255,255,255,128,127,0,127,9,0,47,255,255,255,128,190,0,127,11,192,0,0,0,0,0,253,0,127,15,192,0,0,0,0,1,252,0,127,15,128,170,170,170,170,147,248,0,63,255,128,255,255,255,255,255,240,0,63,255,0,255,255,255,255,255,224,0,11,249,0,252,0,0,7,227,128,0,0,0,0,252,0,0,7,224,0,0,0,0,0,254,255,255,251,227,255,255,255,244,0,85,255,255,245,67,255,255,255,244,0,0,170,170,160,3,255,255,255,240,0,0,0,0,0,1,110,85,95,240,0,0,0,0,0,0,191,0,15,224,0,2,255,255,248,0,127,0,47,192,0,2,255,255,248,0,63,128,63,128,0,2,255,255,248,0,31,208,255,64,0,2,248,2,248,0,15,241,254,0,0,3,248,2,248,0,7,251,252,0,0,3,248,2,248,0,3,255,244,0,0,3,244,2,248,16,0,255,224,0,0,3,244,2,255,244,1,255,208,0,0,7,240,7,255,244,11,255,248,0,0,15,240,47,255,244,127,255,255,64,0,47,208,15,253,11,255,226,255,244,0,191,192,15,128,255,255,0,127,255,64,191,64,0,0,255,248,0,15,255,0,45,0,0,0,127,128,0,1,252,0,0,0,0,0,36,0,0,0,20,0,
  // 0x6bd4  比
  212,107,37,37,114,40,2,253,0,21,64,0,0,85,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,192,0,0,63,128,0,0,254,0,11,240,0,0,63,128,0,0,254,0,127,252,0,0,63,234,170,128,254,7,255,248,0,0,63,255,255,192,254,63,255,208,0,0,63,255,255,192,255,255,253,0,0,0,63,255,255,192,255,255,144,0,0,0,63,128,0,0,255,248,0,0,0,0,63,128,0,0,255,128,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,0,0,0,63,128,0,0,254,0,0,32,0,0,63,128,0,0,254,0,0,62,0,0,63,128,0,0,254,0,0,63,128,0,63,128,1,176,254,0,0,63,128,0,63,134,255,240,254,0,0,63,64,0,63,255,255,244,254,0,0,127,64,27,255,255,255,244,255,0,0,191,0,255,255,255,249,0,255,234,170,255,0,255,255,249,0,0,191,255,255,254,0,191,249,0,0,0,63,255,255,252,0,101,0,0,0,0,11,255,255,224,0,
  // 0x6c92  沒
  146,108,37,38,124,40,2,252,0,0,0,0,41,64,0,0,0,0,3,224,0,0,63,192,0,0,0,0,11,254,0,0,63,192,0,0,0,0,15,255,208,0,63,128,0,0,0,0,1,255,248,0,127,255,255,255,240,0,0,31,252,0,191,255,255,255,240,0,0,3,240,0,255,255,255,255,240,0,0,0,144,1,255,85,85,95,240,0,0,0,0,2,253,0,0,15,224,0,0,0,0,3,252,0,0,15,224,0,0,0,0,11,248,0,0,15,208,0,16,0,0,15,240,0,0,31,208,0,127,64,0,47,224,0,0,47,192,0,255,244,0,127,192,0,0,63,192,0,191,254,1,255,128,3,255,255,128,0,11,255,199,255,0,1,255,255,0,0,0,191,2,252,0,0,255,253,0,0,0,30,0,116,0,0,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,208,0,0,0,0,127,255,255,255,255,240,0,0,0,0,127,255,255,255,255,208,0,0,1,192,21,189,85,85,191,192,0,0,3,240,2,254,0,0,255,128,0,0,7,248,0,255,0,1,255,0,0,0,15,240,0,127,192,3,253,0,0,0,31,224,0,47,240,15,248,0,0,0,63,192,0,15,252,63,240,0,0,0,191,128,0,3,255,255,192,0,0,0,255,0,0,0,255,255,0,0,0,2,254,0,0,0,191,253,0,0,0,3,252,0,0,7,255,255,128,0,0,15,248,0,0,191,255,255,249,0,0,31,240,0,111,255,248,127,255,228,0,63,224,15,255,255,208,11,255,255,64,15,192,7,255,248,0,0,191,254,0,3,64,3,254,64,0,0,7,252,0,0,0,1,128,0,0,0,0,36,0,
  // 0x6d88  消
  136,109,35,38,86,40,2,252,0,0,0,0,0,15,208,0,0,3,208,0,0,0,15,224,0,128,15,248,0,127,0,15,224,2,252,15,255,64,191,64,15,224,3,252,2,255,224,63,192,15,224,7,248,0,63,244,31,224,15,224,15,240,0,11,224,15,240,15,224,47,224,0,1,128,7,248,15,224,63,192,0,0,0,3,252,15,224,191,64,0,0,0,2,224,15,224,30,0,0,0,0,0,0,15,224,0,0,20,0,0,21,85,111,245,85,80,127,0,0,63,255,255,255,255,240,255,224,0,63,255,255,255,255,240,127,253,0,63,255,255,255,255,240,11,255,64,63,192,0,0,11,240,1,255,64,63,192,0,0,11,240,0,62,0,63,192,0,0,11,240,0,8,0,63,192,0,0,11,240,0,0,0,63,255,255,255,255,240,0,0,0,63,255,255,255,255,240,0,0,0,63,255,255,255,255,240,0,2,64,63,192,0,0,11,240,0,7,208,63,192,0,0,11,240,0,11,240,63,192,0,0,11,240,0,15,224,63,192,0,0,11,240,0,47,192,63,255,255,255,255,240,0,63,192,63,255,255,255,255,240,0,191,64,63,255,255,255,255,240,0,255,0,63,192,0,0,11,240,2,253,0,63,192,0,0,11,240,7,252,0,63,192,0,0,11,240,15,244,0,63,192,0,0,11,240,31,240,0,63,192,0,0,15,240,63,224,0,63,192,0,63,255,240,47,192,0,63,192,0,47,255,224,7,64,0,63,192,0,31,255,128,0,0,0,42,128,0,10,84,0,
  // 0x6de1  淡
  225,109,37,37,114,40,2,253,0,0,0,0,0,26,128,0,0,0,2,128,0,0,0,47,192,0,0,0,11,248,0,0,0,47,192,0,0,0,15,255,64,11,224,47,192,11,208,0,2,255,224,15,224,47,192,15,240,0,0,127,248,31,192,63,192,47,224,0,0,11,240,47,192,63,128,63,192,0,0,1,192,127,64,63,128,191,0,0,0,0,0,255,0,127,65,254,0,0,0,0,1,253,0,191,131,252,0,0,0,0,0,40,0,255,244,96,0,0,0,0,0,0,2,255,255,0,0,0,61,0,0,0,11,255,255,224,0,0,255,208,0,0,47,244,127,253,0,0,255,248,0,1,255,224,11,255,192,0,31,255,64,111,255,128,0,255,244,0,2,255,67,255,253,0,0,31,252,0,0,126,0,255,208,47,192,3,244,0,0,4,0,185,0,47,192,0,144,0,0,0,0,0,0,63,192,0,0,0,0,0,0,14,64,63,192,3,208,0,0,1,0,15,208,63,128,11,252,0,0,11,128,47,192,63,128,15,240,0,0,15,224,63,128,63,192,47,224,0,0,47,224,127,64,127,208,63,192,0,0,63,192,255,0,191,240,255,64,0,0,191,130,253,0,255,241,254,0,0,0,255,3,252,1,255,253,252,0,0,2,255,0,116,3,255,254,0,0,0,3,253,0,0,15,248,255,64,0,0,11,252,0,0,63,240,127,208,0,0,15,244,0,1,255,208,47,248,0,0,63,240,0,47,255,64,11,255,128,0,127,208,27,255,253,0,2,255,254,64,47,128,31,255,224,0,0,127,255,0,7,0,11,254,0,0,0,11,253,0,0,0,3,144,0,0,0,0,40,0,
  // 0x6e05  清
  5,110,37,38,124,40,2,252,0,0,0,0,0,47,192,0,0,0,3,208,0,0,0,47,192,0,0,0,11,253,0,170,170,191,234,170,168,0,15,255,128,255,255,255,255,255,252,0,2,255,240,255,255,255,255,255,252,0,0,47,244,0,0,47,192,0,0,0,0,3,224,0,0,47,192,0,0,0,0,0,64,42,170,191,234,170,160,0,0,0,0,63,255,255,255,255,240,0,0,0,0,63,255,255,255,255,240,0,0,0,0,0,0,47,192,0,0,0,36,0,0,0,0,47,192,0,0,0,127,64,6,170,170,191,234,170,170,64,255,244,7,255,255,255,255,255,255,64,127,255,7,255,255,255,255,255,255,64,11,255,128,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,45,0,11,255,255,255,255,208,0,0,0,0,15,255,255,255,255,208,0,0,0,0,15,255,255,255,255,208,0,0,0,0,15,224,0,0,15,208,0,0,0,0,15,224,0,0,15,208,0,0,2,192,15,229,85,85,111,208,0,0,3,240,15,255,255,255,255,208,0,0,11,244,15,255,255,255,255,208,0,0,15,240,15,224,0,0,15,208,0,0,47,208,15,224,0,0,15,208,0,0,63,192,15,224,0,0,15,208,0,0,191,64,15,255,255,255,255,208,0,0,255,0,15,255,255,255,255,208,0,3,253,0,15,250,170,170,175,208,0,7,252,0,15,224,0,0,15,208,0,15,244,0,15,224,0,0,15,208,0,47,240,0,15,224,0,0,15,208,0,63,208,0,15,224,0,63,255,192,0,15,128,0,15,224,0,47,255,192,0,2,0,0,15,224,0,31,254,0,0,0,0,0,5,64,0,0,0,0,0,
  // 0x6e2c  測
  44,110,35,38,86,40,2,252,0,0,0,0,0,0,0,1,248,7,128,0,0,0,0,0,1,252,15,248,11,255,255,240,0,1,252,31,255,75,255,255,240,0,1,252,3,255,219,255,255,240,42,1,252,0,127,203,224,7,240,63,1,252,0,15,11,224,3,240,63,1,252,0,1,11,224,3,240,63,1,252,0,0,11,224,3,240,63,1,252,0,0,11,224,3,240,63,1,252,0,0,11,255,255,240,63,1,252,16,0,11,255,255,240,63,1,252,62,0,11,255,255,240,63,1,252,255,224,11,224,3,240,63,1,252,255,253,11,224,3,240,63,1,252,31,255,11,224,3,240,63,1,252,1,252,11,224,3,240,63,1,252,0,52,11,255,255,240,63,1,252,0,0,11,255,255,240,63,1,252,0,0,11,255,255,240,63,1,252,0,0,11,224,3,240,63,1,252,0,0,11,224,3,240,63,1,252,0,16,11,224,3,240,63,1,252,0,61,11,224,3,240,63,1,252,0,63,139,229,87,240,63,1,252,0,191,11,255,255,240,63,1,252,0,255,11,255,255,240,63,1,252,1,254,11,255,255,240,63,1,252,2,252,0,0,0,0,0,1,252,3,252,2,248,11,192,0,1,252,11,244,3,252,15,240,0,1,252,15,240,11,244,7,248,0,1,252,31,224,31,224,2,253,0,1,252,63,192,63,192,0,255,0,2,252,127,192,255,64,0,127,79,255,252,127,67,254,0,0,56,11,255,244,11,0,252,0,0,0,7,255,224,0,0,16,0,0,0,2,149,0,
  // 0x6e90  源
  144,110,37,39,134,40,2,251,1,0,0,0,0,0,0,0,0,0,7,224,0,0,0,0,0,0,0,0,15,254,2,255,255,255,255,255,255,0,11,255,194,255,255,255,255,255,255,0,0,255,242,255,255,255,255,255,255,0,0,47,226,253,85,86,255,85,85,0,0,7,194,252,0,1,254,0,0,0,0,1,2,252,0,2,253,0,0,0,0,0,2,252,0,2,252,0,0,0,0,0,2,252,0,3,252,0,0,0,0,0,2,252,63,255,255,255,248,0,0,0,2,252,63,255,255,255,248,0,61,0,2,252,63,255,255,255,248,0,255,208,2,252,63,64,0,3,248,0,255,252,2,252,63,64,0,3,248,0,31,255,2,252,63,170,170,171,248,0,1,253,2,252,63,255,255,255,248,0,0,56,2,252,63,255,255,255,248,0,0,0,2,252,63,64,0,3,248,0,0,0,2,252,63,64,0,3,248,0,0,0,3,252,63,64,0,3,248,0,0,0,3,248,63,234,170,171,248,0,0,8,3,248,63,255,255,255,248,0,0,31,3,244,63,255,255,255,248,0,0,63,199,244,0,0,253,0,0,0,0,127,135,240,0,0,253,0,0,0,0,191,11,240,14,64,253,11,192,0,0,255,15,240,47,192,253,31,224,0,2,253,15,224,63,128,253,15,240,0,3,252,31,208,191,0,253,7,252,0,7,248,47,192,254,0,253,2,253,0,15,240,63,131,252,0,253,0,255,0,31,224,191,75,248,0,253,0,191,64,63,208,255,15,240,0,253,0,127,128,127,194,254,7,208,1,253,0,61,0,127,67,252,0,65,255,252,0,0,0,11,1,248,0,0,255,252,0,0,0,0,0,32,0,0,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6e96  準
  150,110,36,38,86,40,2,252,0,64,0,1,144,0,144,0,0,1,248,0,3,252,0,255,0,0,3,255,128,7,248,2,253,0,0,2,255,244,15,240,3,252,0,0,0,47,240,47,224,11,244,0,0,0,7,224,127,255,255,255,255,244,0,0,64,255,255,255,255,255,244,20,0,3,255,255,255,255,255,240,127,128,15,255,64,15,224,0,0,255,253,127,255,64,15,224,0,0,31,253,255,255,255,255,255,255,192,1,248,63,127,255,255,255,255,192,0,16,8,63,234,175,250,170,128,0,0,0,63,64,15,224,0,0,0,1,208,63,64,15,224,0,0,0,3,240,63,234,175,250,170,128,0,15,244,63,255,255,255,255,192,0,63,224,63,255,255,255,255,192,0,191,192,63,64,15,224,0,0,2,255,0,63,64,15,224,0,0,11,252,0,63,64,15,224,0,0,47,244,0,63,255,255,255,255,253,63,208,0,63,255,255,255,255,253,15,128,0,63,255,255,255,255,252,6,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,255,85,85,85,85,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,
  // 0x6eab  溫
  171,110,37,38,124,40,2,252,1,0,0,0,0,0,0,0,0,0,3,224,0,0,0,0,0,0,0,0,15,254,0,63,255,255,255,255,64,0,15,255,208,63,255,255,255,255,64,0,1,255,244,63,255,255,255,255,64,0,0,31,240,63,128,9,0,63,64,0,0,3,192,63,128,47,0,63,64,0,0,0,64,63,128,63,0,63,64,0,0,0,0,63,128,126,0,63,64,0,0,0,0,63,128,255,128,63,64,0,0,0,0,63,130,255,224,63,64,0,20,0,0,63,135,242,248,63,64,0,127,64,0,63,175,192,190,63,64,0,255,244,0,63,159,0,45,63,64,0,191,254,0,63,132,0,0,63,64,0,11,255,0,63,255,255,255,255,64,0,0,254,0,63,255,255,255,255,64,0,0,44,0,63,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,255,255,255,240,0,0,6,1,255,255,255,255,255,240,0,0,15,129,255,255,255,255,255,240,0,0,31,225,252,15,192,188,11,240,0,0,63,193,252,15,192,188,11,240,0,0,127,129,252,15,192,188,11,240,0,0,255,1,252,15,192,188,11,240,0,1,255,1,252,15,192,188,11,240,0,3,253,1,252,15,192,188,11,240,0,7,252,1,252,15,192,188,11,240,0,15,244,1,252,15,192,188,11,240,0,31,240,1,252,15,192,188,11,240,0,63,208,191,255,255,255,255,255,255,64,127,192,191,255,255,255,255,255,255,64,47,64,191,255,255,255,255,255,255,64,3,0,21,85,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6fc0  激
  192,111,37,38,124,40,2,252,1,0,0,6,144,0,25,64,0,0,7,208,0,11,244,0,47,192,0,0,31,248,0,15,240,0,63,128,0,0,31,255,64,15,224,0,63,128,0,0,2,255,218,175,250,164,63,64,0,0,0,63,207,255,255,244,127,0,0,0,0,11,15,255,255,244,127,0,0,0,0,0,15,192,2,244,191,0,0,0,0,0,15,192,2,244,255,255,255,64,0,0,15,234,171,244,255,255,255,64,0,0,15,255,255,245,255,255,255,64,40,0,15,255,255,246,253,87,249,0,127,64,15,192,2,247,252,3,244,0,255,244,15,192,2,255,252,3,244,0,127,253,15,192,2,255,252,3,240,0,7,254,15,255,255,255,253,7,240,0,0,252,15,255,255,255,254,7,240,0,0,32,10,175,250,191,190,11,224,0,0,0,0,11,224,15,47,11,224,0,0,0,0,11,224,1,31,15,208,0,0,0,191,255,255,255,31,143,192,0,0,0,191,255,255,255,15,223,192,0,0,36,191,255,255,255,15,239,128,0,0,62,0,190,0,0,7,255,64,0,0,63,64,126,0,0,3,255,0,0,0,191,0,190,0,0,3,254,0,0,0,255,0,191,255,240,2,253,0,0,1,253,0,191,255,240,2,252,0,0,2,252,0,255,255,240,3,254,0,0,3,252,1,252,3,240,11,255,64,0,11,244,2,252,7,240,31,255,192,0,15,240,3,248,7,240,63,223,224,0,31,224,15,240,7,240,255,11,248,0,63,192,47,224,11,227,253,3,254,0,127,192,191,203,255,239,248,1,255,128,127,66,255,3,255,239,224,0,127,0,11,0,252,3,255,75,128,0,28,0,0,0,32,0,0,1,0,0,0,0,
  // 0x7121  無
  33,113,36,38,86,40,2,252,0,0,144,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,47,245,85,85,85,85,85,80,0,127,255,255,255,255,255,255,244,1,255,255,255,255,255,255,255,244,3,255,255,255,255,255,255,255,244,15,255,192,63,0,252,3,244,0,127,255,192,63,0,252,3,244,0,255,223,192,63,0,252,3,244,0,47,31,192,63,0,252,3,244,0,8,31,192,63,0,252,3,244,0,0,31,192,63,0,252,3,244,0,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,85,111,213,191,86,253,87,249,85,0,31,192,63,0,252,3,244,0,0,31,192,63,0,252,3,244,0,0,31,192,63,0,252,3,244,0,0,31,192,63,0,252,3,244,0,0,31,192,63,0,252,3,244,0,0,31,192,63,0,252,3,244,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,21,85,85,85,85,85,85,85,84,0,0,0,0,0,0,0,4,0,0,190,0,20,0,24,0,191,0,0,255,1,252,0,254,0,255,128,2,253,0,253,0,255,0,63,208,3,252,0,254,0,127,64,47,240,11,248,0,255,0,63,128,15,248,31,240,0,191,0,63,192,3,253,127,208,0,191,0,47,192,2,255,191,128,0,191,0,31,208,0,255,6,0,0,16,0,4,0,0,160,
  // 0x71b1  熱
  177,113,37,38,124,40,2,252,0,1,168,0,0,7,240,0,0,0,0,1,252,0,0,7,240,0,0,0,0,1,252,0,0,7,240,0,0,0,15,255,255,255,128,7,240,0,0,0,15,255,255,255,128,7,240,0,0,0,10,171,254,170,65,91,245,85,0,0,0,1,252,0,7,255,255,255,64,0,0,1,252,0,7,255,255,255,64,0,127,255,255,255,231,255,255,255,64,0,127,255,255,255,224,11,224,63,64,0,106,191,175,234,160,11,224,63,64,0,0,126,11,192,0,11,224,63,64,0,0,253,11,192,211,143,224,63,64,0,2,252,11,193,247,255,208,63,64,0,111,240,7,255,255,255,208,63,64,0,255,192,171,255,210,255,192,63,64,0,62,1,252,85,0,127,244,63,64,0,0,1,252,0,0,47,253,63,64,0,26,171,254,170,128,63,255,191,64,0,47,255,255,255,128,127,191,127,74,0,47,255,255,255,128,191,31,63,75,192,0,1,252,0,0,254,5,63,75,192,0,1,252,0,2,252,0,63,75,192,0,1,252,86,167,248,0,63,75,128,21,171,255,255,255,240,0,63,79,128,255,255,255,255,255,208,0,63,255,128,191,255,255,169,127,128,0,47,255,0,190,149,0,0,14,0,0,11,249,0,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,0,0,25,0,0,0,255,1,188,1,253,0,255,0,0,1,254,1,252,0,254,0,127,192,0,3,252,0,253,0,191,0,63,224,0,11,248,0,254,0,127,64,15,244,0,31,240,0,254,0,63,192,7,252,0,127,208,0,255,0,63,192,3,254,0,191,128,0,254,0,47,128,0,254,0,6,0,0,0,0,0,0,0,80,0,
  // 0x71c8  燈
  200,113,38,38,124,40,1,252,0,0,0,0,0,0,25,0,0,0,0,11,224,0,0,0,127,3,64,0,0,11,224,3,255,254,63,11,224,0,0,11,224,3,255,255,47,175,208,0,0,11,224,3,255,255,15,255,64,0,0,11,224,0,0,189,15,248,4,0,0,11,224,145,192,252,7,240,47,64,0,11,225,255,246,248,3,252,191,128,6,75,227,251,255,240,0,255,253,0,11,203,227,240,191,224,0,127,224,0,11,203,235,208,63,192,0,63,208,0,15,203,255,192,255,255,255,255,248,0,15,139,255,3,255,255,255,251,254,0,15,139,234,15,245,255,255,245,255,208,31,75,224,127,224,0,0,0,127,224,47,11,225,255,128,0,0,0,15,192,63,15,224,189,0,0,0,0,2,0,126,15,224,32,191,255,255,255,240,0,124,15,224,0,191,255,255,255,240,0,4,15,208,0,191,255,255,255,240,0,0,15,208,0,190,0,0,11,240,0,0,15,208,0,190,0,0,11,240,0,0,15,192,0,190,0,0,11,240,0,0,31,208,0,190,0,0,11,240,0,0,47,240,0,191,255,255,255,240,0,0,47,252,0,191,255,255,255,240,0,0,63,254,0,191,255,255,255,224,0,0,127,255,64,1,128,0,101,0,0,0,191,63,192,15,208,0,191,0,0,0,254,15,240,11,240,0,254,0,0,1,253,11,244,3,244,1,253,0,0,3,252,3,240,3,248,2,252,0,0,11,244,1,192,2,252,3,244,0,0,31,240,0,0,1,224,1,176,0,0,63,208,0,63,255,255,255,255,255,192,63,128,0,63,255,255,255,255,255,192,15,0,0,63,255,255,255,255,255,192,4,0,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,34,38,86,40,2,252,0,0,0,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,255,255,255,255,255,255,224,0,63,255,255,255,255,255,255,240,0,63,255,255,255,255,255,255,240,0,63,255,255,255,255,255,255,240,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,191,255,255,255,255,255,64,0,0,191,255,255,255,255,255,64,0,0,255,0,0,0,0,191,64,0,0,255,0,0,0,0,191,64,0,0,255,0,0,0,0,191,64,0,2,254,0,0,0,0,191,64,0,3,253,0,0,0,0,191,64,0,7,252,0,0,0,0,191,64,0,11,248,0,0,0,0,191,64,0,15,244,0,0,0,0,191,64,0,63,240,0,0,0,0,191,64,0,191,208,0,0,0,0,191,64,0,255,192,0,0,0,0,191,64,0,191,0,0,0,0,0,191,64,0,45,0,0,0,0,0,191,64,0,8,0,0,0,0,0,191,64,0,
  // 0x7269  物
  105,114,37,38,124,40,1,252,0,0,252,0,0,148,0,0,0,0,0,0,252,0,1,253,0,0,0,0,1,0,252,0,2,252,0,0,0,0,7,240,252,0,3,248,0,0,0,0,11,224,252,0,3,244,0,0,0,0,11,224,252,0,7,240,0,0,0,0,15,208,252,0,11,240,0,0,0,0,15,208,252,0,15,255,255,255,255,192,15,234,254,164,31,255,255,255,255,192,15,255,255,252,63,255,255,255,255,192,31,255,255,252,127,151,249,127,191,192,47,255,255,252,255,3,240,63,47,192,47,64,252,1,253,7,224,127,47,192,63,0,252,3,252,15,208,190,47,192,127,0,252,15,244,15,192,253,63,128,190,0,252,31,240,47,193,252,63,128,45,0,252,11,192,63,66,252,63,128,4,0,252,2,64,127,3,248,63,128,0,0,252,5,0,254,3,244,63,64,0,0,254,254,1,252,11,240,63,64,0,1,255,254,3,248,15,224,63,64,0,127,255,254,11,240,31,192,63,64,47,255,255,144,31,224,47,192,127,0,63,255,252,0,63,192,63,64,127,0,63,250,252,0,255,64,191,0,127,0,46,64,252,3,254,0,254,0,191,0,0,0,252,11,252,2,252,0,191,0,0,0,252,2,240,3,248,0,255,0,0,0,252,0,64,15,240,0,254,0,0,0,252,0,0,31,224,0,254,0,0,0,252,0,0,63,192,1,253,0,0,0,252,0,0,255,64,2,252,0,0,0,252,0,3,254,0,3,252,0,0,0,252,0,15,252,0,11,252,0,0,0,252,0,63,240,31,255,244,0,0,0,252,0,47,208,15,255,240,0,0,0,252,0,7,0,15,255,192,0,0,0,252,0,0,0,6,164,0,0,
  // 0x7387  率
  135,115,36,38,86,40,2,252,0,0,0,0,169,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,5,85,85,85,255,85,85,85,80,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,31,255,255,255,255,255,255,255,248,0,0,0,7,244,0,0,0,0,1,0,0,15,224,0,0,7,64,11,224,0,47,192,36,0,31,240,31,252,2,127,0,191,0,127,208,7,255,75,253,1,253,2,255,64,0,191,239,252,7,244,15,252,0,0,31,210,255,79,224,31,224,0,0,7,0,127,255,128,1,64,0,0,0,0,31,255,28,0,0,0,0,0,0,3,252,191,11,64,0,0,1,240,7,240,63,191,240,0,0,31,244,31,192,31,255,254,0,6,255,248,127,255,255,242,255,208,191,255,175,255,255,255,244,127,248,127,248,31,255,255,234,252,11,253,63,64,30,149,64,0,252,1,244,4,0,0,0,255,0,80,0,16,0,0,0,0,255,0,0,0,0,85,85,85,85,255,85,85,85,85,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,
  // 0x7528  用
  40,117,35,35,59,40,1,252,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,0,63,234,170,191,234,170,171,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,213,85,127,229,85,91,248,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,128,0,47,192,0,3,248,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,0,127,255,255,255,255,255,255,248,0,127,170,170,191,234,170,171,248,0,191,0,0,47,192,0,3,248,0,255,0,0,47,192,0,3,248,0,254,0,0,47,192,0,3,248,1,253,0,0,47,192,0,3,248,3,252,0,0,47,192,0,3,248,3,252,0,0,47,192,0,3,248,11,244,0,0,47,192,0,3,248,15,240,0,0,47,192,0,7,248,63,224,0,0,47,192,255,255,244,127,192,0,0,47,192,127,255,240,31,64,0,0,47,192,63,255,208,6,0,0,0,5,64,42,84,0,
  // 0x754c  界
  76,117,36,37,77,40,2,251,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,0,3,254,0,127,208,0,0,0,0,15,252,0,31,244,0,0,0,0,127,240,0,11,254,0,0,0,2,255,192,0,2,255,208,0,0,31,255,0,0,0,127,253,0,1,255,253,80,0,6,191,255,208,47,255,223,240,0,7,250,255,255,255,254,15,240,0,7,244,63,254,63,244,15,240,0,7,244,7,252,14,0,15,240,0,7,244,0,32,0,0,15,240,0,7,244,0,0,0,0,31,224,0,7,244,0,0,0,0,63,208,0,7,244,0,0,0,0,191,192,0,7,244,0,0,0,2,255,128,0,7,244,0,0,0,15,255,0,0,7,244,0,0,1,191,252,0,0,7,244,0,0,3,255,240,0,0,7,244,0,0,0,255,64,0,0,7,244,0,0,0,56,0,0,0,6,164,0,0,0,0,0,0,0,0,0,0,0,
  // 0x767d  白
  125,118,30,38,48,40,5,252,0,0,0,249,64,0,0,0,0,0,0,255,192,0,0,0,0,0,1,255,64,0,0,0,0,0,2,255,0,0,0,0,0,0,3,253,0,0,0,0,0,0,7,252,0,0,0,0,106,170,175,254,170,170,170,144,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,234,170,170,170,170,191,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,234,170,170,170,170,191,208,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,255,255,255,255,255,255,208,127,64,0,0,0,0,31,208,127,64,0,0,0,0,31,208,127,0,0,0,0,0,26,144,
  // 0x7684  的
  132,118,34,38,86,40,3,252,0,10,144,0,0,100,0,0,0,0,15,240,0,0,191,0,0,0,0,15,240,0,0,255,0,0,0,0,31,208,0,1,253,0,0,0,0,47,192,0,2,252,0,0,0,0,63,128,0,3,252,0,0,0,0,127,128,0,7,253,85,85,80,191,255,255,248,11,255,255,255,240,191,255,255,248,15,255,255,255,240,191,255,255,248,31,255,255,255,240,191,0,2,248,63,192,0,7,240,191,0,2,248,127,128,0,7,240,191,0,2,248,255,0,0,7,240,191,0,2,250,254,0,0,7,240,191,0,2,255,252,0,0,7,240,191,0,2,249,244,0,0,11,240,191,0,2,248,48,112,0,11,240,191,0,2,248,2,248,0,11,240,191,255,255,248,2,253,0,11,240,191,255,255,248,0,255,0,11,224,191,255,255,248,0,127,192,15,224,191,0,3,248,0,47,224,15,224,191,0,2,248,0,15,240,15,224,191,0,2,248,0,7,252,15,224,191,0,2,248,0,3,253,15,208,191,0,2,248,0,1,253,15,208,191,0,2,248,0,0,224,15,208,191,0,2,248,0,0,0,31,208,191,0,2,248,0,0,0,31,192,191,0,2,248,0,0,0,47,192,191,255,255,248,0,0,0,47,192,191,255,255,248,0,0,0,63,192,191,255,255,248,0,0,0,63,128,191,85,85,80,0,0,0,255,64,191,0,0,0,0,63,255,255,0,191,0,0,0,0,31,255,253,0,105,0,0,0,0,15,255,244,0,0,0,0,0,0,5,85,0,0,
  // 0x76e3  監
  227,118,36,37,77,40,2,253,0,0,0,0,0,1,0,0,0,0,0,0,0,0,7,240,0,0,63,255,255,255,240,11,224,0,0,63,255,255,255,240,15,208,0,0,63,255,255,255,240,31,192,0,0,63,128,126,0,0,47,128,0,0,63,128,126,0,0,63,255,255,254,63,255,255,255,208,127,255,255,254,63,255,255,255,208,255,255,255,254,63,213,85,95,209,252,0,0,0,63,128,0,11,211,248,0,0,0,63,128,0,11,219,240,0,0,0,63,128,0,11,239,224,0,0,0,63,255,255,255,215,192,0,0,0,63,255,255,255,208,64,0,0,0,63,213,191,85,64,0,0,0,0,63,128,126,0,0,63,255,255,248,63,128,126,0,0,63,255,255,248,63,255,255,255,244,63,255,255,248,63,255,255,255,248,0,0,0,0,63,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,190,0,254,0,254,0,255,0,0,190,0,254,0,254,0,255,0,0,190,0,254,0,254,0,255,0,0,190,0,254,0,254,0,255,0,0,190,0,254,0,254,0,255,0,0,190,0,254,0,254,0,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,85,85,85,85,85,
  // 0x76f4  直
  244,118,36,38,86,40,2,252,0,0,0,0,127,192,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,127,128,0,0,0,21,85,85,85,191,213,85,85,84,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,127,255,255,255,255,255,255,255,254,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,15,255,255,255,255,252,0,7,240,15,255,255,255,255,252,0,7,240,15,250,170,170,171,252,0,7,240,15,224,0,0,1,252,0,7,240,15,224,0,0,1,252,0,7,240,15,250,170,170,171,252,0,7,240,15,255,255,255,255,252,0,7,240,15,255,255,255,255,252,0,7,240,15,224,0,0,1,252,0,7,240,15,224,0,0,1,252,0,7,240,15,224,0,0,1,252,0,7,240,15,255,255,255,255,252,0,7,240,15,255,255,255,255,252,0,7,240,15,250,170,170,170,252,0,7,240,15,224,0,0,1,252,0,7,240,15,224,0,0,1,252,0,7,240,15,250,170,170,171,252,0,7,240,15,255,255,255,255,252,0,7,240,15,255,255,255,255,252,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,249,85,85,85,85,85,85,85,7,255,255,255,255,255,255,255,255,7,255,255,255,255,255,255,255,255,7,255,255,255,255,255,255,255,255,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,
  // 0x7720  眠
  32,119,36,36,68,40,3,252,255,255,254,3,255,255,255,255,240,255,255,254,3,255,255,255,255,240,255,255,254,3,255,255,255,255,240,254,85,254,3,249,85,85,91,240,253,0,254,3,244,0,0,7,240,253,0,254,3,244,0,0,7,240,253,0,254,3,244,0,0,7,240,253,0,254,3,244,0,0,7,240,253,0,254,3,249,85,85,91,240,255,255,254,3,255,255,255,255,240,255,255,254,3,255,255,255,255,240,255,255,254,3,255,255,255,255,240,253,0,254,3,244,1,252,0,0,253,0,254,3,244,0,253,0,0,253,0,254,3,244,0,253,0,0,253,0,254,3,244,0,253,0,0,253,0,254,3,244,0,253,0,0,255,255,254,3,255,255,255,255,252,255,255,254,3,255,255,255,255,252,255,255,254,3,255,255,255,255,252,253,0,254,3,249,85,255,85,84,253,0,254,3,244,0,127,0,0,253,0,254,3,244,0,127,0,0,253,0,254,3,244,0,63,64,0,253,0,254,3,244,0,63,128,0,254,85,254,3,244,0,63,192,0,255,255,254,3,244,0,47,192,16,255,255,254,3,244,0,31,208,61,255,255,254,3,244,0,15,224,63,253,0,0,3,244,22,219,240,63,253,0,0,3,255,255,211,244,63,253,0,1,191,255,255,227,253,126,84,0,2,255,255,255,144,255,253,0,0,1,255,254,64,0,191,252,0,0,0,249,64,0,0,47,244,0,0,0,0,0,0,0,1,64,
  // 0x780d  砍
  13,120,38,38,124,40,1,252,0,0,0,0,1,164,0,0,0,0,0,0,0,0,2,253,0,0,0,0,21,85,85,85,2,252,0,0,0,0,63,255,255,255,131,252,0,0,0,0,63,255,255,255,131,252,0,0,0,0,63,255,255,255,131,248,0,0,0,0,0,31,192,0,7,244,0,0,0,0,0,47,192,0,11,249,85,85,89,0,0,63,128,0,15,255,255,255,255,208,0,63,64,0,15,255,255,255,255,192,0,63,64,0,31,255,255,255,255,192,0,127,0,0,63,192,253,0,63,128,0,191,0,0,63,192,253,0,127,64,0,254,0,0,127,128,253,0,191,0,0,254,0,0,255,0,253,0,255,0,1,255,255,253,255,0,253,0,254,0,2,255,255,255,253,0,253,0,253,0,3,255,255,255,252,0,253,2,252,0,7,252,1,252,244,1,253,2,248,0,15,252,1,252,16,1,254,0,36,0,31,252,1,252,0,2,254,0,0,0,63,252,1,252,0,2,255,0,0,0,127,252,1,252,0,3,255,0,0,0,191,252,1,252,0,7,255,64,0,0,62,252,1,252,0,11,239,192,0,0,28,252,1,252,0,15,223,208,0,0,4,252,1,252,0,47,203,240,0,0,0,252,1,252,0,63,135,244,0,0,0,253,85,252,0,191,3,252,0,0,0,255,255,252,1,254,1,254,0,0,0,255,255,252,7,252,0,255,128,0,0,255,255,252,31,244,0,63,224,0,0,252,0,0,127,224,0,47,248,0,0,252,0,2,255,192,0,11,255,64,0,252,0,31,255,0,0,3,255,208,0,168,0,15,248,0,0,0,191,192,0,0,0,7,224,0,0,0,31,64,0,0,0,2,0,0,0,0,2,0,
  // 0x78ba  確
  186,120,38,38,124,40,1,252,0,0,0,0,0,0,169,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,254,0,0,0,63,255,255,253,0,1,253,0,0,0,63,255,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,255,192,21,127,213,87,255,255,255,255,255,192,0,63,192,3,244,31,224,0,31,192,0,63,128,3,244,47,192,16,15,192,0,63,64,3,244,63,128,191,15,192,0,127,0,3,244,191,0,254,15,192,0,127,0,0,1,254,1,252,0,0,0,191,0,0,3,252,2,248,0,0,0,254,0,0,11,255,255,255,255,0,0,254,0,0,47,255,255,255,255,0,1,255,255,244,191,255,255,255,255,0,2,255,255,246,255,224,15,224,0,0,3,255,255,255,255,224,11,224,0,0,7,252,2,255,255,224,11,224,0,0,15,252,2,246,255,224,11,224,0,0,15,252,2,244,79,255,255,255,253,0,47,252,2,244,15,255,255,255,253,0,63,252,2,244,15,255,255,255,253,0,255,252,2,244,15,224,11,224,0,0,191,252,2,244,15,224,11,224,0,0,61,252,2,244,15,224,11,224,0,0,24,252,2,244,15,255,255,255,253,0,0,252,2,244,15,255,255,255,253,0,0,252,2,244,15,255,255,255,253,0,0,252,3,244,15,224,11,224,0,0,0,255,255,244,15,224,11,224,0,0,0,255,255,244,15,224,11,224,0,0,0,255,255,244,15,224,11,224,0,0,0,252,0,0,15,255,255,255,255,208,0,252,0,0,15,255,255,255,255,208,0,252,0,0,15,255,255,255,255,208,0,0,0,0,15,224,0,0,0,0,0,0,0,0,15,208,0,0,0,0,
  // 0x79fb  移
  251,121,37,38,124,40,1,252,0,0,0,0,0,0,148,0,0,0,0,0,2,224,0,2,254,0,0,0,0,1,191,248,0,3,252,0,0,0,1,191,255,253,0,15,244,0,0,0,63,255,255,228,0,63,255,255,248,0,63,255,252,0,0,255,255,255,252,0,31,151,248,0,7,255,255,255,248,0,0,3,248,0,47,248,0,15,240,0,0,3,248,1,255,248,0,47,224,0,0,3,248,7,255,255,64,127,192,0,0,3,248,2,252,191,209,255,64,0,42,171,254,168,144,31,255,253,0,0,63,255,255,253,0,3,255,244,0,0,63,255,255,253,0,1,255,208,0,0,63,255,255,253,0,11,255,64,0,0,0,11,248,0,0,191,253,0,0,0,0,15,252,0,111,255,255,224,0,0,0,31,253,2,255,253,63,192,0,0,0,63,255,128,255,208,255,64,0,0,0,127,255,224,120,2,255,255,255,64,0,255,255,244,0,11,255,255,255,192,1,255,250,253,0,63,255,255,255,192,3,247,248,255,1,255,192,0,191,64,7,243,248,60,11,255,0,0,255,0,15,211,248,36,127,255,64,3,253,0,63,195,248,2,255,255,224,11,252,0,127,131,248,0,255,31,252,31,240,0,127,3,248,0,52,3,255,127,224,0,61,3,248,0,0,0,255,255,128,0,24,3,248,0,0,0,47,255,0,0,0,3,248,0,0,0,63,248,0,0,0,3,248,0,0,2,255,224,0,0,0,3,248,0,0,111,255,64,0,0,0,3,248,0,27,255,252,0,0,0,0,3,248,7,255,255,208,0,0,0,0,3,248,3,255,253,0,0,0,0,0,3,248,1,255,128,0,0,0,0,0,2,168,0,144,0,0,0,0,0,
  // 0x7a4d  積
  77,122,37,39,134,40,1,251,0,0,0,64,0,0,169,0,0,0,0,0,27,224,0,0,254,0,0,0,0,91,255,248,85,85,255,85,85,0,47,255,255,249,255,255,255,255,255,64,63,255,254,64,255,255,255,255,255,64,31,251,244,0,0,0,254,0,0,0,4,3,244,0,21,85,254,85,84,0,0,3,244,0,127,255,255,255,253,0,0,3,244,0,127,255,255,255,253,0,0,3,244,0,0,0,254,0,0,0,0,3,244,1,85,85,255,85,85,64,42,175,254,175,255,255,255,255,255,192,63,255,255,255,255,255,255,255,255,192,63,255,255,248,0,0,0,0,0,0,63,255,255,248,0,0,0,0,0,0,0,11,244,0,63,255,255,255,252,0,0,15,244,0,63,255,255,255,252,0,0,31,252,0,63,149,85,86,252,0,0,63,255,0,63,64,0,1,252,0,0,127,255,192,63,149,85,86,252,0,0,191,255,240,63,255,255,255,252,0,0,255,251,252,63,255,255,255,252,0,3,251,245,253,63,64,0,1,252,0,7,243,244,184,63,64,0,1,252,0,15,211,244,48,63,255,255,255,252,0,47,195,244,0,63,255,255,255,252,0,127,131,244,0,63,149,85,86,252,0,191,3,244,0,63,64,0,1,252,0,61,3,244,0,63,64,0,1,252,0,44,3,244,0,63,255,255,255,252,0,0,3,244,0,63,255,255,255,252,0,0,3,244,0,21,121,85,109,84,0,0,3,244,0,1,253,0,127,0,0,0,3,244,0,31,255,0,255,224,0,0,3,244,1,255,248,0,31,253,0,0,3,244,47,255,128,0,3,255,128,0,3,244,31,248,0,0,0,127,128,0,2,164,7,64,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7aef  端
  239,122,38,38,124,40,1,252,0,5,64,0,0,0,169,0,0,0,0,15,192,0,0,0,253,0,0,0,0,15,192,0,168,0,253,0,106,0,0,15,192,1,252,0,253,0,191,0,0,15,192,1,252,0,253,0,191,0,0,15,192,1,252,0,253,0,191,0,0,15,192,1,252,0,253,0,191,0,0,15,192,1,252,0,253,0,191,0,63,255,255,225,253,1,253,0,191,0,63,255,255,225,255,255,255,255,255,0,63,255,255,225,255,255,255,255,255,0,21,85,85,81,255,255,255,255,255,0,0,0,4,0,0,0,0,0,0,0,15,128,31,192,0,0,0,0,0,0,15,192,47,193,85,85,85,85,85,64,15,192,47,143,255,255,255,255,255,208,11,208,63,143,255,255,255,255,255,208,11,208,63,79,255,255,255,255,255,208,7,224,63,0,0,2,253,0,0,0,7,224,63,0,0,3,252,0,0,0,3,240,127,0,0,3,248,0,0,0,3,240,126,0,0,7,248,0,0,0,3,240,189,3,255,255,255,255,255,64,3,240,253,3,255,255,255,255,255,64,3,240,252,3,255,255,255,255,255,64,3,240,252,3,248,47,2,240,63,64,0,1,248,99,248,47,2,240,63,64,0,1,255,247,248,47,2,240,63,64,1,175,255,251,248,47,2,240,63,64,127,255,255,247,248,47,2,240,63,64,127,255,249,3,248,47,2,240,63,64,63,249,0,3,248,47,2,240,63,64,57,0,0,3,248,47,2,240,63,64,0,0,0,3,248,47,2,240,63,64,0,0,0,3,248,47,2,240,63,64,0,0,0,3,248,47,2,247,255,64,0,0,0,3,248,47,2,243,255,0,0,0,0,2,244,21,1,82,248,0,
  // 0x7b49  等
  73,123,37,38,124,40,1,252,0,15,144,0,0,15,144,0,0,0,0,31,224,0,0,47,208,0,0,0,0,63,192,0,0,63,192,0,0,0,0,127,255,255,248,191,255,255,255,128,0,255,255,255,249,255,255,255,255,128,3,255,255,255,251,255,255,255,255,128,11,252,191,0,15,248,47,208,0,0,31,240,63,64,63,240,15,240,0,0,127,224,63,192,63,192,7,244,0,0,63,192,31,192,47,192,3,248,0,0,11,0,8,0,63,192,1,128,0,0,0,0,0,0,63,192,0,0,0,0,0,63,255,255,255,255,255,255,208,0,0,63,255,255,255,255,255,255,208,0,0,63,255,255,255,255,255,255,208,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,63,255,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,255,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,11,255,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,255,0,0,0,47,0,0,0,63,192,0,0,0,0,191,192,0,0,63,192,0,0,0,0,127,244,0,0,63,192,0,0,0,0,15,253,0,0,63,192,0,0,0,0,3,255,0,0,63,192,0,0,0,0,0,255,192,0,63,192,0,0,0,0,0,63,65,85,191,192,0,0,0,0,0,28,3,255,255,128,0,0,0,0,0,0,1,255,255,0,0,0,0,0,0,0,0,255,232,0,0,0,
  // 0x7ba1  管
  161,123,36,39,95,40,2,251,0,62,0,0,0,57,0,0,0,0,127,64,0,0,255,64,0,0,0,255,0,0,1,255,0,0,0,2,255,255,255,211,255,255,255,255,7,255,255,255,219,255,255,255,255,15,255,255,255,255,255,255,255,255,63,226,252,0,191,192,127,192,0,255,192,254,2,255,64,47,208,0,191,0,191,0,254,0,15,240,0,28,0,56,0,254,0,7,144,0,0,0,0,0,254,0,0,0,0,47,255,255,255,255,255,255,255,252,47,255,255,255,255,255,255,255,252,47,255,255,255,255,255,255,255,252,47,128,0,0,0,0,0,2,252,47,128,0,0,0,0,0,2,252,47,128,0,0,0,0,0,2,252,47,131,255,255,255,255,255,194,252,47,131,255,255,255,255,255,194,252,0,3,255,255,255,255,255,192,0,0,3,248,0,0,0,47,192,0,0,3,248,0,0,0,47,192,0,0,3,254,170,170,170,191,192,0,0,3,255,255,255,255,255,192,0,0,3,255,255,255,255,255,192,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,255,255,255,255,255,255,0,0,3,255,255,255,255,255,255,0,0,3,255,255,255,255,255,255,0,0,3,248,0,0,0,0,255,0,0,3,248,0,0,0,0,255,0,0,3,248,0,0,0,0,255,0,0,3,255,255,255,255,255,255,0,0,3,255,255,255,255,255,255,0,0,3,255,255,255,255,255,255,0,0,3,248,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,
  // 0x7bb1  箱
  177,123,37,38,124,40,1,252,0,10,64,0,0,14,64,0,0,0,0,15,240,0,0,31,224,0,0,0,0,31,208,0,0,63,192,0,0,0,0,63,192,0,0,63,192,0,0,0,0,127,255,255,248,191,255,255,255,192,0,255,255,255,249,255,255,255,255,192,1,255,255,255,251,255,255,255,255,192,3,252,191,64,11,252,63,208,0,0,15,244,63,128,31,240,15,240,0,0,47,240,47,192,127,208,7,244,0,0,127,192,15,208,63,128,3,252,0,0,15,64,15,64,11,0,1,224,0,0,1,0,191,0,0,0,0,0,0,0,0,0,191,0,3,255,255,255,254,0,0,0,191,0,3,255,255,255,254,0,0,0,191,0,3,255,255,255,254,0,31,255,255,255,227,249,85,85,254,0,31,255,255,255,227,244,0,0,254,0,31,255,255,255,227,244,0,0,254,0,5,87,255,85,83,244,0,0,254,0,0,3,255,0,3,255,255,255,254,0,0,7,255,128,3,255,255,255,254,0,0,15,255,240,3,255,255,255,254,0,0,47,255,252,3,244,0,0,254,0,0,63,255,255,3,244,0,0,254,0,0,191,255,191,195,244,0,0,254,0,1,254,191,47,243,255,255,255,254,0,3,252,191,15,211,255,255,255,254,0,15,244,191,3,131,255,255,255,254,0,63,224,191,1,3,244,0,0,254,0,127,192,191,0,3,244,0,0,254,0,47,64,191,0,3,244,0,0,254,0,13,0,191,0,3,244,0,0,254,0,0,0,191,0,3,255,255,255,254,0,0,0,191,0,3,255,255,255,254,0,0,0,191,0,3,255,255,255,254,0,0,0,191,0,3,244,0,0,254,0,0,0,190,0,2,164,0,0,85,0,
  // 0x7cfb  系
  251,124,36,38,86,40,2,252,0,0,0,0,0,0,0,4,0,0,0,0,0,0,1,107,253,0,0,1,85,170,191,255,255,255,0,31,255,255,255,255,255,255,255,192,15,255,255,255,255,255,254,144,0,15,255,255,255,249,80,0,0,0,5,80,0,255,192,0,0,0,0,0,0,2,255,64,1,208,0,0,0,0,7,253,0,7,253,0,0,0,0,31,248,0,15,252,0,0,0,56,63,224,0,63,240,0,0,0,255,255,128,0,255,192,0,0,1,255,254,0,3,255,0,0,0,0,63,253,0,15,252,0,0,0,0,11,255,128,127,240,0,0,0,0,1,255,225,255,192,4,0,0,0,0,63,255,255,0,47,0,0,0,0,15,255,248,0,255,192,0,0,0,2,255,224,0,63,244,0,0,0,2,255,64,0,15,253,0,0,0,15,253,0,0,3,255,64,85,85,127,254,255,255,255,255,208,191,255,255,255,255,255,255,255,244,191,255,255,255,255,255,255,255,252,127,255,255,255,255,170,165,87,255,21,85,0,0,255,0,0,1,254,0,0,0,0,255,0,0,0,180,0,0,244,0,255,0,62,0,0,0,3,255,0,255,1,255,192,0,0,15,252,0,255,0,191,244,0,0,63,244,0,255,0,31,253,0,1,255,208,0,255,0,7,255,128,11,255,64,0,255,0,0,255,240,63,253,0,0,255,0,0,63,252,255,240,0,0,255,0,0,15,254,63,192,0,0,255,0,0,3,248,14,0,0,0,255,0,0,0,208,0,0,0,0,254,0,0,0,0,
  // 0x7d05  紅
  5,125,38,38,124,40,1,252,0,1,144,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,0,47,192,16,26,170,170,170,170,64,0,63,128,253,47,255,255,255,255,128,13,255,1,255,47,255,255,255,255,128,47,252,3,252,47,255,255,255,255,128,63,244,11,248,0,0,63,192,0,0,31,248,31,240,0,0,63,192,0,0,7,253,63,192,0,0,63,192,0,0,0,255,255,64,0,0,63,192,0,0,0,127,254,0,0,0,63,192,0,0,0,31,252,9,0,0,63,192,0,0,0,15,244,127,0,0,63,192,0,0,0,47,224,63,128,0,63,192,0,0,0,127,192,31,208,0,63,192,0,0,21,255,65,95,240,0,63,192,0,0,127,255,255,255,244,0,63,192,0,0,127,255,255,255,252,0,63,192,0,0,63,255,255,254,254,0,63,192,0,0,0,0,254,0,190,0,63,192,0,0,0,0,254,0,48,0,63,192,0,0,0,0,254,0,0,0,63,192,0,0,3,224,254,47,64,0,63,192,0,0,7,240,254,47,192,0,63,192,0,0,11,240,254,31,208,0,63,192,0,0,11,240,254,15,224,0,63,192,0,0,15,224,254,11,240,0,63,192,0,0,15,208,254,3,244,0,63,192,0,0,47,192,254,3,248,0,63,192,0,0,63,192,254,2,252,0,63,192,0,0,127,64,254,1,208,0,63,192,0,0,127,0,254,0,255,255,255,255,255,208,6,0,254,0,255,255,255,255,255,208,0,0,254,0,255,255,255,255,255,208,0,0,254,0,170,170,170,170,170,128,0,0,254,0,0,0,0,0,0,0,
  // 0x7d22  索
  34,125,35,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,5,85,85,85,255,85,85,85,80,63,255,255,255,255,255,255,255,248,63,255,255,255,255,255,255,255,248,63,255,255,255,255,255,255,255,248,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,128,0,47,224,0,0,2,252,63,128,0,127,208,0,0,2,252,63,128,1,255,64,7,64,2,252,63,129,11,253,0,47,240,2,252,63,139,239,240,0,191,224,2,252,0,47,255,192,3,255,64,0,0,0,11,255,64,31,253,0,0,0,0,1,255,224,191,240,36,0,0,0,0,47,254,255,128,254,0,0,0,0,7,255,253,1,255,192,0,0,0,1,255,224,0,63,244,0,0,0,11,255,64,0,11,254,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,252,21,85,16,0,255,0,0,2,244,0,0,121,0,254,0,56,0,64,0,2,255,64,254,2,255,64,0,0,15,253,0,254,1,255,244,0,0,191,244,0,254,0,31,254,0,11,255,192,0,254,0,2,255,208,191,254,0,0,254,0,0,127,248,127,240,0,0,254,0,0,11,252,15,64,0,0,254,0,0,1,224,0,0,0,0,254,0,0,0,0,
  // 0x7d2b  紫
  43,125,36,38,86,40,2,252,0,0,127,0,1,168,0,0,0,0,0,127,0,1,252,0,0,0,0,0,127,0,1,252,0,2,64,11,208,127,0,1,252,0,111,208,11,224,127,255,241,252,27,255,244,11,224,127,255,241,255,255,255,208,11,224,127,255,241,255,255,244,0,11,224,127,0,1,255,249,0,0,11,224,127,0,1,253,0,0,0,11,224,127,0,1,252,0,0,120,11,224,127,0,81,252,0,0,127,11,224,191,255,241,253,0,0,255,95,255,255,255,241,255,255,255,254,255,255,255,255,160,255,255,255,252,255,255,233,79,144,47,255,255,244,250,80,0,63,240,0,0,0,0,0,0,0,255,192,2,64,0,0,0,1,3,254,0,31,244,0,0,0,31,239,248,0,127,240,0,0,0,127,255,208,2,255,128,0,0,0,31,255,192,15,253,0,0,0,0,1,255,244,127,240,31,64,0,0,0,31,255,255,128,127,224,0,0,0,2,255,252,0,15,252,0,0,0,1,255,224,0,3,255,0,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,253,85,85,80,0,255,0,0,2,255,0,0,0,0,255,0,4,0,248,0,1,253,0,255,0,127,0,0,0,7,255,0,255,1,255,224,0,0,63,248,0,255,0,63,253,0,2,255,224,0,255,0,7,255,128,47,255,64,0,255,0,0,191,244,127,248,0,0,255,0,0,31,253,31,192,0,0,255,0,0,3,240,1,0,0,0,254,0,0,0,64,
  // 0x7d30  細
  48,125,36,38,86,40,1,252,0,6,0,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,47,192,0,21,85,85,85,85,0,63,64,0,63,255,255,255,255,0,191,2,128,63,255,255,255,255,0,253,7,244,63,255,255,255,255,31,252,15,240,63,64,63,0,127,63,240,31,208,63,64,63,0,127,63,224,63,128,63,64,63,0,127,15,244,191,0,63,64,63,0,127,7,253,253,0,63,64,63,0,127,1,255,248,0,63,64,63,0,127,0,191,240,160,63,64,63,0,127,0,63,195,240,63,64,63,0,127,0,47,66,248,63,64,63,0,127,0,126,0,253,63,64,63,0,127,0,255,255,255,63,149,191,85,191,127,255,255,255,127,255,255,255,255,127,255,255,255,191,255,255,255,255,127,255,244,31,255,255,255,255,255,21,3,244,15,191,64,63,0,127,0,3,244,8,63,64,63,0,127,0,3,244,0,63,64,63,0,127,11,211,245,244,63,64,63,0,127,15,211,245,252,63,64,63,0,127,15,195,244,252,63,64,63,0,127,15,195,244,190,63,64,63,0,127,31,195,244,127,63,64,63,0,127,47,131,244,63,63,64,63,0,127,63,67,244,47,127,64,63,0,127,63,3,244,30,127,149,191,85,191,191,3,244,0,63,255,255,255,255,109,3,244,0,63,255,255,255,255,4,3,244,0,63,255,255,255,255,0,3,244,0,63,64,0,0,127,0,3,244,0,63,64,0,0,127,0,2,164,0,0,0,0,0,0,
  // 0x7d42  終
  66,125,38,39,134,40,1,251,0,6,0,0,0,14,80,0,0,0,0,15,224,0,0,47,208,0,0,0,0,31,208,0,0,63,192,0,0,0,0,47,192,0,0,191,64,0,0,0,0,63,64,0,0,255,255,255,224,0,0,190,7,144,3,255,255,255,252,0,4,252,15,240,11,255,255,255,248,0,31,248,31,208,31,244,0,31,240,0,63,240,63,128,63,248,0,31,224,0,63,224,127,0,255,253,0,63,192,0,15,244,254,3,254,255,0,191,64,0,3,254,252,15,248,63,194,254,0,0,1,255,244,11,240,31,231,252,0,0,0,191,225,66,192,11,255,244,0,0,0,63,207,192,0,3,255,208,0,0,0,63,75,224,0,2,255,192,0,0,0,190,3,240,0,11,255,224,0,0,1,252,2,244,0,63,255,252,0,0,191,255,255,252,1,255,231,255,64,0,127,255,255,252,31,255,64,255,244,0,127,255,255,255,255,252,0,63,255,64,20,7,240,63,255,208,0,11,255,224,0,3,240,52,254,3,208,0,191,192,0,3,240,80,96,15,253,0,11,0,11,211,243,240,0,11,255,192,0,0,15,211,242,244,0,0,191,248,0,0,15,195,241,248,0,0,15,253,0,0,15,195,240,252,0,0,1,248,0,0,31,195,240,189,0,0,0,32,0,0,47,131,240,126,3,144,0,0,0,0,63,67,240,63,15,254,64,0,0,0,63,3,240,36,31,255,248,0,0,0,191,3,240,0,1,191,255,144,0,0,125,3,240,0,0,7,255,253,0,0,4,3,240,0,0,0,111,255,208,0,0,3,240,0,0,0,2,255,240,0,0,3,240,0,0,0,0,47,208,0,0,3,240,0,0,0,0,2,128,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7d71  統
  113,125,38,38,124,40,1,252,0,6,0,0,0,1,253,0,0,0,0,15,224,0,0,1,253,0,0,0,0,31,208,0,0,1,253,0,0,0,0,47,192,0,0,1,253,0,0,0,0,63,64,0,0,1,253,0,0,0,0,190,7,147,255,255,255,255,255,192,4,252,15,243,255,255,255,255,255,192,31,248,31,211,255,255,255,255,255,192,63,240,63,129,85,127,213,85,85,64,63,224,127,0,0,127,192,0,0,0,15,244,253,0,0,191,64,47,0,0,3,254,252,0,0,255,0,127,128,0,1,255,240,0,1,254,0,47,208,0,0,127,225,64,2,252,0,15,240,0,0,63,207,192,3,248,0,27,252,0,0,63,75,209,91,255,255,255,253,0,0,254,3,242,255,255,255,255,255,0,1,252,2,246,255,255,255,255,255,128,191,255,255,254,255,254,165,64,63,192,127,255,255,253,0,0,0,0,31,192,127,255,255,254,0,84,1,84,9,0,20,7,240,63,0,253,2,252,0,0,0,3,240,56,0,253,2,252,0,0,0,3,240,80,0,253,2,252,0,0,11,211,243,240,1,252,2,252,0,0,15,211,242,244,1,252,2,252,0,0,15,195,241,248,2,252,2,252,0,0,15,195,240,252,3,252,2,252,0,0,31,195,240,189,3,248,2,252,0,0,47,131,240,126,7,244,2,252,6,0,63,67,240,63,15,240,2,252,7,224,63,3,240,16,47,224,2,252,7,240,191,3,240,0,127,192,2,252,7,224,125,3,240,2,255,64,2,252,11,224,4,3,240,31,254,0,2,255,255,208,0,3,240,47,244,0,1,255,255,192,0,3,240,15,208,0,0,191,255,64,0,3,240,5,0,0,0,1,80,0,
  // 0x7d72  絲
  114,125,38,38,124,40,1,252,0,2,128,0,0,0,40,0,0,0,0,3,248,0,0,0,127,128,0,0,0,11,244,0,0,0,255,64,0,0,0,15,240,0,0,0,254,0,0,0,0,47,192,0,0,3,252,0,0,0,0,63,128,244,0,7,244,11,64,0,4,191,2,254,0,15,240,31,240,0,30,253,3,252,3,239,192,63,208,0,63,248,11,244,11,255,64,191,128,0,63,240,31,224,7,255,0,255,0,0,15,248,63,192,1,255,131,253,0,0,3,254,191,64,0,63,219,248,0,0,0,255,254,0,0,15,255,240,0,0,0,63,252,20,0,3,255,194,192,0,0,31,240,252,0,1,255,79,224,0,0,47,208,254,0,2,253,7,244,0,0,127,64,127,0,7,248,3,252,0,0,254,1,127,192,31,240,22,254,0,127,255,255,255,203,255,255,255,255,0,127,255,255,255,231,255,255,255,255,128,127,255,255,255,247,255,255,255,255,192,21,85,253,3,246,85,111,192,15,208,0,0,253,2,128,0,31,192,11,0,1,0,253,0,0,0,31,192,0,0,3,244,253,47,0,121,31,193,224,0,7,240,253,63,64,191,31,203,240,0,7,240,253,63,128,254,31,195,248,0,11,224,253,31,193,253,31,194,252,0,15,224,253,15,226,252,31,192,254,0,15,208,253,11,243,248,31,192,191,0,47,192,253,3,231,244,31,192,63,128,63,128,253,1,15,240,31,192,63,192,127,64,253,0,47,208,31,192,31,208,127,0,253,0,47,192,31,192,15,208,1,0,253,0,2,64,31,192,5,0,0,0,253,0,0,0,31,192,0,0,0,0,253,0,0,0,31,192,0,0,0,0,253,0,0,0,31,192,0,0,
  // 0x7da0  綠
  160,125,38,38,124,40,1,252,0,5,0,0,0,232,0,0,0,0,0,15,224,0,1,253,0,0,0,0,0,15,208,0,1,252,0,0,0,0,0,47,192,0,2,255,255,255,224,0,0,63,64,0,3,255,255,255,240,0,0,127,3,64,3,255,255,255,224,0,0,253,11,240,7,240,0,15,224,0,14,252,15,224,11,240,0,15,208,0,63,244,47,192,15,224,0,31,192,0,127,224,63,64,15,255,255,255,192,0,31,240,254,0,31,255,255,255,192,0,7,249,252,0,63,255,255,255,128,0,2,255,244,0,63,128,0,63,64,0,0,255,224,0,0,0,0,127,64,0,0,63,203,192,0,0,0,191,64,0,0,63,79,211,255,255,255,255,255,192,0,254,7,243,255,255,255,255,255,192,2,252,3,247,255,255,255,255,255,192,191,255,255,252,0,0,191,0,0,0,191,255,255,252,0,0,191,0,0,0,127,255,255,254,28,0,191,64,45,0,16,7,240,127,127,0,191,192,191,128,0,7,240,57,127,192,191,194,255,0,0,7,240,0,31,240,191,219,252,0,15,199,242,224,7,252,191,255,224,0,15,199,243,240,2,244,191,255,128,0,15,199,242,244,0,192,191,253,0,0,31,199,241,248,0,8,191,254,0,0,31,135,240,252,0,189,190,127,64,0,47,71,240,252,3,254,190,63,208,0,63,7,240,189,47,252,190,15,240,0,63,7,240,101,255,224,190,11,253,0,190,7,240,15,255,64,190,2,255,128,189,7,240,11,252,0,190,0,255,208,8,7,240,3,224,0,254,0,47,128,0,7,240,1,64,191,254,0,7,0,0,7,240,0,0,127,253,0,0,0,0,7,224,0,0,63,228,0,0,0,
  // 0x7db2  網
  178,125,37,39,134,40,1,251,0,6,0,0,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,0,15,208,2,255,255,255,255,255,64,0,47,192,2,255,255,255,255,255,64,0,63,64,2,255,255,255,255,255,64,0,191,3,130,253,85,85,85,127,64,0,253,11,242,252,0,0,80,63,64,30,248,15,210,252,124,0,189,63,64,63,240,63,194,252,125,0,252,63,64,63,224,127,2,252,62,1,248,63,64,31,240,254,2,252,47,2,240,63,64,11,249,252,2,252,31,3,224,63,64,2,255,244,2,252,14,2,208,63,64,0,255,224,2,252,255,255,254,63,64,0,63,207,194,252,255,255,254,63,64,0,63,79,210,252,255,255,254,63,64,0,254,7,242,252,0,253,0,63,64,2,252,3,250,252,0,253,0,63,64,191,255,255,254,252,0,253,0,63,64,191,255,255,255,252,255,255,254,63,64,127,255,255,255,252,255,255,254,63,64,16,7,240,127,252,255,255,254,63,64,0,7,240,63,252,47,64,0,63,64,5,7,240,98,252,47,64,0,63,64,15,215,243,242,252,47,64,0,63,64,15,199,243,242,252,47,64,0,63,64,15,199,242,246,252,47,64,0,63,64,31,199,241,250,252,47,64,0,63,64,31,135,240,254,252,47,128,0,63,64,47,71,240,255,252,31,255,252,63,64,63,71,240,191,252,15,255,253,63,64,63,7,240,102,252,7,255,253,63,64,190,7,240,2,252,0,0,0,63,64,189,7,240,2,252,0,0,0,63,64,8,7,240,2,252,0,0,0,127,64,0,7,240,2,252,0,0,191,255,0,0,7,240,2,252,0,0,63,255,0,0,7,240,2,252,0,0,63,244,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7dd2  緒
  210,125,38,38,124,40,1,252,0,5,0,0,0,15,208,0,0,0,0,15,224,0,0,15,208,0,40,0,0,15,208,0,0,15,208,0,63,128,0,47,192,0,0,15,208,0,127,0,0,63,64,0,0,15,208,0,254,0,0,127,2,0,255,255,255,249,252,0,0,253,11,224,255,255,255,251,252,0,14,252,15,224,255,255,255,255,244,0,63,240,63,192,0,15,208,31,224,0,63,224,127,0,0,15,208,63,192,0,31,240,254,0,0,15,208,255,64,0,7,254,252,0,0,15,210,254,0,0,1,255,240,11,255,255,255,255,255,208,0,191,226,139,255,255,255,255,255,208,0,63,207,203,255,255,255,255,255,208,0,127,11,224,0,2,255,64,0,0,0,254,7,240,0,7,253,0,0,0,2,252,3,244,0,31,244,0,0,0,191,255,255,252,0,127,224,0,0,0,191,255,255,253,2,255,255,255,252,0,127,255,255,254,31,255,255,255,252,0,16,7,240,127,191,255,255,255,252,0,0,7,240,63,255,240,0,2,252,0,0,7,240,31,255,240,0,2,252,0,15,215,243,243,215,240,0,2,252,0,15,199,243,240,7,240,0,2,252,0,15,199,242,244,7,255,255,255,252,0,31,199,241,252,7,255,255,255,252,0,31,135,240,252,7,255,255,255,252,0,47,71,240,189,7,240,0,2,252,0,63,7,240,189,7,240,0,2,252,0,127,7,240,80,7,240,0,2,252,0,190,7,240,0,7,240,0,2,252,0,124,7,240,0,7,255,255,255,252,0,4,7,240,0,7,255,255,255,252,0,0,7,240,0,7,255,255,255,252,0,0,7,240,0,7,240,0,2,252,0,0,7,224,0,6,160,0,1,168,0,
  // 0x7dda  線
  218,125,38,38,124,40,1,252,0,5,0,0,0,0,185,0,0,0,0,15,224,0,0,0,255,64,0,0,0,15,208,0,0,1,254,0,0,0,0,47,192,0,0,3,252,0,0,0,0,63,64,0,127,255,255,255,254,0,0,127,3,64,127,255,255,255,254,0,0,253,11,240,127,255,255,255,254,0,14,252,15,224,127,0,0,0,254,0,63,244,47,192,127,0,0,0,254,0,127,224,63,64,127,0,0,0,254,0,31,240,254,0,127,170,170,170,254,0,7,249,252,0,127,255,255,255,254,0,2,255,244,0,127,255,255,255,254,0,0,255,224,0,127,0,0,0,254,0,0,63,203,192,127,0,0,0,254,0,0,63,79,208,127,0,0,0,254,0,0,254,7,240,127,255,255,255,254,0,2,252,3,244,127,255,255,255,254,0,191,255,255,252,127,255,255,255,254,0,191,255,255,252,0,0,191,0,0,0,127,255,255,254,0,0,191,0,4,0,16,7,240,127,0,0,191,64,46,0,0,7,240,59,255,253,191,192,191,192,5,7,240,82,255,255,191,194,255,64,15,215,243,242,255,253,191,235,253,0,15,199,243,240,1,252,191,255,240,0,15,199,241,248,2,252,191,255,192,0,31,199,240,252,3,248,191,254,0,0,31,135,240,252,11,240,191,191,0,0,47,71,240,188,31,208,191,63,192,0,63,7,240,188,63,192,191,31,240,0,63,7,240,0,255,64,191,11,252,0,190,7,240,7,254,0,191,3,255,64,189,7,240,31,248,0,191,0,255,224,8,7,240,11,224,0,191,0,63,192,0,7,240,3,64,191,254,0,11,64,0,7,240,0,0,63,253,0,0,0,0,7,224,0,0,63,228,0,0,0,
  // 0x7de8  編
  232,125,37,38,124,40,1,252,0,5,0,0,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,0,47,192,7,255,255,255,255,255,128,0,63,64,7,255,255,255,255,255,128,0,127,6,7,255,255,255,255,255,128,0,253,15,224,0,0,0,0,0,0,30,252,31,208,0,0,0,0,0,0,63,244,63,128,255,255,255,255,254,0,63,224,127,0,255,255,255,255,254,0,31,240,253,0,255,255,255,255,254,0,7,249,252,0,253,0,0,0,254,0,1,255,244,0,253,0,0,0,254,0,0,191,225,0,253,0,0,0,254,0,0,63,223,128,253,0,0,0,254,0,0,63,79,192,255,255,255,255,254,0,0,254,11,208,255,255,255,255,254,0,1,252,7,240,255,255,255,255,254,0,191,255,255,244,253,0,0,0,0,0,191,255,255,248,253,0,0,0,0,0,127,255,255,252,255,255,255,255,255,64,16,11,224,253,255,255,255,255,255,128,0,11,224,184,255,255,255,255,255,128,5,11,224,64,255,209,240,188,47,128,15,203,235,193,255,209,240,188,47,128,15,203,231,209,255,209,240,188,47,128,15,203,227,242,255,209,240,188,47,128,31,139,227,243,255,251,254,254,191,128,31,75,225,247,251,255,255,255,255,128,47,75,225,255,247,255,255,255,255,128,63,11,224,255,231,209,240,188,47,128,127,11,224,159,215,209,240,188,47,128,189,11,224,31,199,209,240,188,47,128,124,11,224,63,199,209,240,188,47,128,0,11,224,127,71,209,240,188,47,128,0,11,224,191,7,209,240,190,255,64,0,11,224,29,7,209,240,188,255,0,0,11,208,0,7,208,160,104,249,0,
  // 0x7e2e  縮
  46,126,37,38,124,40,1,252,0,6,0,0,0,1,253,0,0,0,0,15,224,0,0,1,253,0,0,0,0,15,208,0,0,1,253,0,0,0,0,47,192,0,0,1,253,0,0,0,0,63,64,7,255,255,255,255,255,128,0,127,7,71,255,255,255,255,255,128,0,252,15,231,255,255,255,255,255,128,30,248,31,199,240,0,0,0,47,128,63,240,63,135,240,0,0,0,47,128,63,224,127,7,240,0,0,0,47,128,15,240,253,7,243,224,0,0,21,64,7,254,252,0,7,255,255,255,255,192,1,255,240,0,15,239,255,255,255,192,0,191,226,64,15,223,255,255,255,192,0,63,207,192,31,192,2,252,0,0,0,63,75,208,47,128,2,252,0,0,0,254,7,240,63,64,3,248,0,0,1,252,3,240,127,0,3,244,0,0,191,255,255,244,255,3,255,255,255,0,191,255,255,253,255,3,255,255,255,0,127,255,255,255,255,3,255,255,255,0,16,11,224,191,255,3,240,0,63,0,0,11,224,31,255,3,240,0,63,0,0,11,224,15,127,3,240,0,63,0,15,203,231,193,63,3,240,0,63,0,15,203,231,208,63,3,255,255,255,0,15,203,227,224,63,3,255,255,255,0,31,139,227,240,63,3,255,255,255,0,31,75,226,244,63,3,240,0,63,0,47,75,225,248,63,3,240,0,63,0,63,11,224,248,63,3,240,0,63,0,127,11,224,144,63,3,240,0,63,0,189,11,224,0,63,3,240,0,63,0,124,11,224,0,63,3,255,255,255,0,4,11,224,0,63,3,255,255,255,0,0,11,224,0,63,3,255,255,255,0,0,11,224,0,63,3,240,0,63,0,0,11,208,0,42,2,160,0,21,0,
  // 0x7e3d  總
  61,126,38,38,124,40,1,252,0,5,0,0,0,0,185,0,0,0,0,15,224,0,0,0,255,0,0,0,0,15,208,0,0,0,255,0,0,0,0,47,192,0,0,2,253,0,0,0,0,63,64,0,255,255,255,255,255,0,0,127,6,0,255,255,255,255,255,0,0,253,15,224,255,255,255,255,255,0,30,252,31,208,252,0,124,0,63,0,63,244,63,128,252,0,252,0,63,0,63,224,127,0,252,1,255,254,63,0,31,240,253,0,252,183,255,254,63,0,7,249,252,0,252,255,192,188,63,0,1,255,244,0,252,63,244,248,63,0,0,191,225,0,252,190,255,240,63,0,0,63,223,128,253,244,47,224,63,0,0,63,79,192,252,16,63,248,63,0,0,254,11,208,252,1,253,190,63,0,1,252,7,240,252,31,240,40,63,0,191,255,255,244,252,31,128,0,63,0,191,255,255,248,255,255,255,255,255,0,127,255,255,252,255,255,255,255,255,0,16,11,224,253,255,255,255,255,255,0,0,11,224,184,0,11,192,0,0,0,0,11,224,128,0,31,248,0,0,0,15,139,235,192,0,7,255,0,0,0,15,203,231,224,0,0,255,192,0,0,15,203,227,240,16,127,47,224,176,0,31,139,226,240,189,127,11,131,244,0,31,139,225,244,253,127,1,2,252,0,47,75,225,248,252,127,0,0,254,0,63,11,224,248,252,127,0,0,191,0,63,11,224,145,248,127,0,16,63,64,190,11,224,3,244,127,0,61,47,192,124,11,224,7,240,127,0,63,15,192,4,11,224,15,224,127,0,63,15,224,0,11,224,31,192,63,255,254,7,224,0,11,224,2,64,63,255,253,2,0,0,11,208,0,0,11,255,244,0,0,
  // 0x7e7c  繼
  124,126,37,38,124,40,1,252,0,20,0,10,128,0,0,0,0,0,0,63,64,31,192,56,0,15,64,0,0,63,64,31,192,124,0,15,64,0,0,127,0,31,192,248,0,47,0,0,0,189,0,31,197,240,241,124,45,0,0,252,20,31,207,210,243,248,125,0,1,248,63,95,207,195,211,244,248,0,31,240,127,31,195,255,128,254,240,0,63,224,254,31,192,255,0,63,192,0,63,193,252,31,192,125,208,31,168,0,31,227,244,31,192,245,240,62,61,0,11,251,240,31,194,240,244,188,31,0,2,255,208,31,223,255,255,255,255,128,0,255,128,31,207,255,255,255,255,192,0,127,189,31,192,0,16,0,2,64,0,189,127,31,255,255,255,255,255,192,1,252,63,95,255,255,255,255,255,192,3,240,47,159,255,255,255,255,255,192,191,255,255,223,192,52,0,10,64,0,191,255,255,239,192,124,0,15,128,0,191,255,255,255,192,184,0,31,0,0,16,31,195,255,192,240,224,61,29,0,0,31,130,95,207,225,243,252,62,0,5,31,129,31,207,195,211,244,188,0,15,159,159,31,199,235,192,253,240,0,31,159,143,159,193,255,0,127,224,0,31,95,143,223,192,190,64,31,228,0,47,95,139,239,192,186,224,31,124,0,47,31,135,255,193,240,240,61,47,0,63,31,131,255,203,250,254,254,175,64,63,31,131,255,223,255,255,255,255,192,126,31,129,31,206,148,47,229,3,192,189,31,128,31,192,0,4,0,1,0,44,31,128,31,255,255,255,255,255,192,0,31,128,31,255,255,255,255,255,192,0,31,128,31,255,255,255,255,255,192,0,31,128,31,192,0,0,0,0,0,0,31,128,10,128,0,0,0,0,0,
  // 0x7e8c  續
  140,126,37,38,124,40,1,252,0,5,0,0,0,0,253,0,0,0,0,15,224,0,0,1,253,0,0,0,0,31,192,5,85,86,254,85,85,64,0,47,128,11,255,255,255,255,255,192,0,63,0,11,255,255,255,255,255,192,0,190,10,64,0,1,253,0,0,0,0,252,15,224,21,85,254,85,84,0,14,248,47,192,255,255,255,255,253,0,63,240,63,64,255,255,255,255,253,0,63,208,191,0,0,0,0,0,0,0,31,240,253,2,255,255,255,255,255,0,7,250,248,2,255,255,255,255,255,0,2,255,240,2,244,15,71,208,63,0,0,255,210,2,244,127,3,250,191,0,0,63,239,66,251,248,2,255,255,0,0,63,15,194,245,128,0,0,63,0,0,253,11,210,255,255,255,255,255,0,1,252,7,242,255,255,255,255,255,0,127,255,255,240,0,0,0,0,0,0,127,255,255,248,0,0,0,0,0,0,63,255,255,252,127,255,255,255,252,0,20,11,224,252,127,255,255,255,252,0,0,11,224,80,127,0,0,1,252,0,5,11,225,128,127,170,170,171,252,0,15,203,235,192,127,255,255,255,252,0,15,203,231,224,127,0,0,1,252,0,15,203,227,240,127,0,0,1,252,0,31,139,226,240,127,255,255,255,252,0,47,75,225,244,127,170,170,171,252,0,63,75,224,248,127,0,0,1,252,0,63,11,224,128,127,255,255,255,252,0,127,11,224,0,127,255,255,255,252,0,189,11,224,0,1,244,0,189,0,0,124,11,224,0,31,254,2,255,208,0,0,11,224,6,255,244,0,127,253,0,0,11,224,63,255,128,0,7,255,192,0,11,224,31,244,0,0,0,191,64,0,7,208,6,0,0,0,0,8,0,
  // 0x7ea2  红
  162,126,37,36,104,40,1,254,0,0,144,0,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,0,7,248,0,255,255,255,255,255,64,0,15,240,0,255,255,255,255,255,64,0,31,224,0,255,255,255,255,255,64,0,63,192,0,170,170,255,234,170,0,0,191,128,0,0,0,255,0,0,0,0,255,0,244,0,0,255,0,0,0,3,253,2,254,0,0,255,0,0,0,7,248,3,253,0,0,255,0,0,0,15,240,11,248,0,0,255,0,0,0,127,255,255,240,0,0,255,0,0,0,127,255,255,208,0,0,255,0,0,0,63,255,255,128,0,0,255,0,0,0,47,167,255,0,0,0,255,0,0,0,0,7,252,0,0,0,255,0,0,0,0,15,244,0,0,0,255,0,0,0,0,63,224,0,0,0,255,0,0,0,0,191,128,0,0,0,255,0,0,0,2,255,0,88,0,0,255,0,0,0,11,254,191,252,0,0,255,0,0,0,63,255,255,252,0,0,255,0,0,0,63,255,255,252,0,0,255,0,0,0,63,255,233,0,0,0,255,0,0,0,31,144,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,20,0,0,255,0,0,0,0,0,107,248,0,0,255,0,0,0,0,111,255,253,170,170,255,234,170,128,127,255,255,254,255,255,255,255,255,192,127,255,255,146,255,255,255,255,255,192,63,254,64,2,255,255,255,255,255,192,58,64,0,0,0,0,0,0,0,0,
  // 0x7f6e  置
  110,127,35,36,68,40,3,252,31,255,255,255,255,255,255,255,128,31,255,255,255,255,255,255,255,128,31,234,175,250,170,254,170,191,128,31,192,7,240,0,252,0,63,128,31,192,7,240,0,252,0,63,128,31,234,171,250,170,254,170,191,128,31,255,255,255,255,255,255,255,128,31,255,255,255,255,255,255,255,128,0,0,0,2,253,0,0,0,0,0,0,0,2,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,3,244,0,0,0,0,0,0,0,7,244,0,0,0,0,5,80,63,255,255,255,255,252,0,15,224,63,255,255,255,255,252,0,15,224,63,128,0,0,2,252,0,15,224,63,128,0,0,1,252,0,15,224,63,255,255,255,255,252,0,15,224,63,255,255,255,255,252,0,15,224,63,128,0,0,1,252,0,15,224,63,128,0,0,1,252,0,15,224,63,255,255,255,255,252,0,15,224,63,255,255,255,255,252,0,15,224,63,128,0,0,1,252,0,15,224,63,128,0,0,1,252,0,15,224,63,255,255,255,255,252,0,15,224,63,255,255,255,255,252,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,255,255,255,255,255,255,255,252,15,255,255,255,255,255,255,255,252,15,255,255,255,255,255,255,255,252,15,224,0,0,0,0,0,0,0,10,144,0,0,0,0,0,0,0,
  // 0x7f72  署
  114,127,37,36,104,40,1,252,1,255,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,255,248,0,1,254,170,255,170,175,234,171,248,0,1,252,0,127,0,15,192,3,248,0,1,252,0,127,0,15,192,3,248,0,1,252,0,127,0,15,192,3,248,0,1,255,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,255,248,0,1,170,170,170,255,170,170,170,164,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,2,208,0,0,47,255,255,255,255,255,15,248,0,0,47,255,255,255,255,255,127,240,0,0,31,255,255,255,255,255,255,192,0,0,0,0,0,254,0,15,254,0,0,0,0,0,0,254,0,191,240,0,0,47,255,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,255,128,0,0,0,1,255,254,0,0,0,0,0,0,0,111,255,240,0,0,0,0,0,0,11,255,255,64,0,0,0,0,0,6,255,255,255,255,255,255,192,0,1,255,255,255,255,255,255,255,192,0,127,255,255,234,170,170,170,191,192,0,63,255,255,192,0,0,0,31,192,0,31,248,31,192,0,0,0,31,192,0,9,0,31,255,255,255,255,255,192,0,0,0,31,255,255,255,255,255,192,0,0,0,31,213,85,85,85,111,192,0,0,0,31,192,0,0,0,31,192,0,0,0,31,192,0,0,0,31,192,0,0,0,31,255,255,255,255,255,192,0,0,0,31,255,255,255,255,255,192,0,0,0,31,234,170,170,170,191,192,0,0,0,31,192,0,0,0,26,128,0,
  // 0x8070  聰
  112,128,38,38,124,40,1,252,0,0,0,0,0,0,105,0,0,0,0,0,0,0,0,0,191,64,0,0,63,255,255,255,128,0,255,0,0,0,63,255,255,255,128,0,254,0,0,0,63,255,255,255,191,255,255,255,255,0,23,249,87,249,127,255,255,255,255,0,2,248,3,244,63,255,255,255,255,0,2,248,3,244,63,0,60,0,63,0,2,248,3,244,63,0,124,0,63,0,2,248,3,244,63,0,255,253,63,0,2,255,255,244,63,47,255,252,63,0,2,255,255,244,63,63,208,188,63,0,2,255,255,244,63,47,248,244,63,0,2,248,3,244,63,125,191,224,63,0,2,248,3,244,63,20,31,208,63,0,2,248,3,244,63,0,63,244,63,0,2,248,3,244,63,1,253,188,63,0,2,248,3,244,63,15,240,32,63,0,2,248,3,244,63,11,64,0,63,0,2,255,255,244,63,255,255,255,255,0,2,255,255,244,63,255,255,255,255,0,2,255,255,244,63,255,255,255,255,0,2,248,3,244,0,3,252,0,0,0,2,248,3,244,0,7,255,128,0,0,2,248,3,244,0,0,191,224,0,0,2,248,3,244,0,26,79,244,0,0,2,248,3,244,9,47,130,209,176,0,2,250,191,244,47,175,128,67,248,0,111,255,255,244,63,111,128,1,252,0,127,255,255,244,63,47,128,0,254,0,63,255,151,244,127,47,128,0,127,0,58,64,3,244,254,47,128,30,63,128,0,0,3,245,252,47,128,31,159,192,0,0,3,251,248,47,128,47,79,208,0,0,3,251,240,31,255,255,15,224,0,0,3,244,144,15,255,255,6,0,0,0,3,244,0,7,255,248,0,0,0,0,2,160,0,0,0,0,0,0,
  // 0x81ea  自
  234,129,28,38,10,40,6,252,0,0,1,233,0,0,0,0,0,2,255,0,0,0,0,0,3,253,0,0,0,0,0,3,252,0,0,0,0,0,7,248,0,0,0,106,170,175,250,170,170,170,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,85,85,85,85,85,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,85,85,85,85,85,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,0,0,0,0,0,191,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,85,85,85,85,85,255,191,0,0,0,0,0,191,191,0,0,0,0,0,106,
  // 0x85cd  藍
  205,133,36,37,77,40,2,253,0,0,26,128,0,2,164,0,0,0,0,47,192,0,7,244,0,0,0,0,47,192,0,7,244,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,47,192,0,7,244,0,0,0,0,47,192,0,7,244,0,0,5,85,85,85,80,7,144,0,0,15,255,255,255,248,15,240,0,0,15,255,255,255,248,15,208,0,0,15,192,63,64,0,47,192,0,0,15,208,63,64,0,63,255,255,252,15,255,255,255,224,255,255,255,252,15,255,255,255,225,255,255,255,252,15,192,0,7,231,252,0,0,0,15,192,0,7,239,240,0,0,0,15,255,255,255,226,208,0,0,0,15,255,255,255,224,0,0,0,0,15,208,63,64,0,47,255,255,244,15,192,63,64,0,47,255,255,244,15,229,127,149,84,47,255,255,244,15,255,255,255,252,0,0,0,0,15,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,126,0,126,0,191,0,0,191,0,126,0,126,0,191,0,0,191,0,126,0,126,0,191,0,0,191,0,126,0,126,0,191,0,0,191,0,126,0,126,0,191,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,
  // 0x884c  行
  76,136,37,38,124,40,1,252,0,0,40,0,0,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,1,255,64,42,170,170,170,170,0,0,7,254,0,127,255,255,255,255,0,0,31,248,0,127,255,255,255,255,0,0,127,224,0,127,255,255,255,255,0,2,255,192,0,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,0,0,63,224,7,128,0,0,0,0,0,0,31,128,15,244,0,0,0,0,0,0,13,0,47,240,0,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,3,255,3,255,255,255,255,255,192,0,11,252,3,255,255,255,255,255,192,0,47,244,3,255,255,255,255,255,192,0,191,244,2,170,170,171,254,170,128,2,255,244,0,0,0,1,253,0,0,11,255,244,0,0,0,1,253,0,0,63,255,244,0,0,0,1,253,0,0,191,251,244,0,0,0,1,253,0,0,63,199,244,0,0,0,1,253,0,0,14,7,244,0,0,0,1,253,0,0,4,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,1,253,0,0,0,7,244,0,0,0,2,253,0,0,0,7,244,0,0,63,255,252,0,0,0,7,244,0,0,63,255,252,0,0,0,7,244,0,0,47,255,244,0,0,0,7,240,0,0,10,169,64,0,0,
  // 0x8868  表
  104,136,38,38,124,40,1,252,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,3,255,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,255,252,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,63,255,255,255,255,255,255,224,0,0,63,255,255,255,255,255,255,224,0,0,63,255,255,255,255,255,255,224,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,0,0,0,15,255,252,0,0,0,0,0,0,0,127,241,253,0,0,144,0,0,0,7,255,192,254,0,3,248,0,0,0,47,254,0,191,0,31,253,0,0,2,255,244,0,63,128,191,240,0,0,127,255,224,0,47,195,255,128,0,27,255,255,224,0,31,255,253,0,0,127,255,223,224,0,15,255,224,0,0,47,248,15,224,0,3,255,0,0,0,15,128,15,224,0,2,255,0,0,0,0,0,15,224,0,0,255,192,0,0,0,0,15,224,0,108,63,244,0,0,0,0,15,224,111,252,31,254,0,0,0,0,15,255,255,253,7,255,208,0,0,1,191,255,255,248,0,255,253,0,0,127,255,255,249,0,0,63,255,208,0,63,255,249,0,0,0,7,255,128,0,63,249,0,0,0,0,0,191,0,0,25,0,0,0,0,0,0,5,0,
  // 0x88ab  被
  171,136,38,38,124,40,1,252,0,10,144,0,0,0,63,64,0,0,0,15,224,0,0,0,63,64,0,0,0,15,224,0,0,0,63,64,0,0,0,15,224,0,0,0,63,64,0,0,0,15,224,0,0,0,63,64,0,0,0,15,224,0,0,0,63,64,0,0,0,15,224,0,127,255,255,255,255,128,21,95,245,64,127,255,255,255,255,192,63,255,255,244,127,255,255,255,255,192,63,255,255,248,127,85,127,149,127,128,63,255,255,240,127,0,63,64,63,64,0,0,15,224,127,0,63,64,127,0,0,0,31,192,127,0,63,64,191,0,0,0,63,128,127,0,63,64,253,0,0,0,191,0,127,0,63,64,108,0,0,1,253,24,127,0,63,64,0,0,0,3,252,63,191,255,255,255,253,0,0,15,244,189,191,255,255,255,254,0,0,63,253,248,191,255,255,255,253,0,0,191,255,240,191,254,85,87,252,0,2,255,255,192,191,254,0,3,252,0,15,255,255,208,190,127,0,11,244,0,63,255,231,244,254,63,128,15,240,0,191,223,226,252,254,47,192,31,224,0,63,79,224,248,253,31,224,63,192,0,45,15,224,96,253,15,244,191,128,0,0,15,224,1,252,3,253,255,0,0,0,15,224,2,252,2,255,254,0,0,0,15,224,3,248,0,255,252,0,0,0,15,224,3,244,0,127,240,0,0,0,15,224,7,240,0,191,248,0,0,0,15,224,15,240,3,255,255,0,0,0,15,224,31,224,31,255,255,208,0,0,15,224,63,193,255,244,191,254,0,0,15,224,127,143,255,192,31,255,208,0,15,224,255,15,254,0,3,255,192,0,15,224,62,3,240,0,0,127,64,0,11,224,4,1,64,0,0,6,0,
  // 0x88c5  装
  197,136,36,38,86,40,2,252,0,0,191,0,0,3,244,0,0,0,0,191,0,0,3,244,0,0,9,0,191,0,0,3,244,0,0,47,128,191,0,0,3,244,0,0,63,240,191,0,0,3,244,0,0,11,252,191,0,0,7,248,0,0,2,253,191,15,255,255,255,255,255,0,116,191,15,255,255,255,255,255,0,0,191,15,255,255,255,255,255,0,0,191,0,0,3,244,0,0,0,0,191,0,0,3,244,0,0,0,10,191,0,0,3,244,0,0,0,191,191,0,0,3,244,0,0,11,255,191,0,0,3,244,0,0,255,254,191,0,0,7,248,0,0,255,224,191,3,255,255,255,255,248,190,0,191,3,255,255,255,255,248,80,0,191,3,255,255,255,255,248,0,0,191,0,0,0,0,0,0,0,0,106,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,1,255,207,224,0,6,0,0,0,31,254,7,244,0,47,192,0,2,255,240,2,252,1,255,208,1,191,255,128,0,255,15,254,0,191,255,255,64,0,127,255,244,0,191,254,127,64,0,31,255,64,0,63,128,63,64,0,11,254,0,0,0,0,63,64,90,194,255,224,0,0,0,127,255,255,192,127,254,64,0,191,255,255,255,192,11,255,249,0,191,255,255,249,64,1,255,255,0,127,254,80,0,0,0,27,253,0,20,0,0,0,0,0,0,104,
  // 0x88dd  裝
  221,136,36,38,86,40,2,252,5,64,15,224,0,2,168,0,0,15,208,15,224,0,2,252,0,0,15,208,15,224,0,2,252,0,0,15,208,15,224,0,2,252,0,0,15,208,15,224,0,2,252,0,0,15,255,255,224,0,2,252,0,0,15,255,255,227,255,255,255,255,253,15,255,255,227,255,255,255,255,253,15,208,15,227,255,255,255,255,253,0,0,15,224,0,2,252,0,0,0,0,15,224,0,2,252,0,0,255,255,255,224,0,2,252,0,0,255,255,255,224,0,2,252,0,0,191,255,255,224,0,2,252,0,0,3,244,15,224,0,2,252,0,0,7,240,15,224,255,255,255,255,248,15,224,15,224,255,255,255,255,248,47,208,15,224,255,255,255,255,248,255,128,15,224,0,0,0,0,0,255,0,15,224,255,0,0,0,0,56,0,5,64,255,0,0,0,0,0,0,0,0,255,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,2,255,143,224,0,6,0,0,0,47,253,7,244,0,47,192,0,7,255,224,2,252,1,255,208,6,255,255,64,0,255,15,254,0,255,255,255,64,0,127,255,244,0,127,249,63,64,0,31,255,64,0,62,64,63,64,0,7,254,0,0,0,0,63,65,107,209,255,224,0,0,0,127,255,255,208,127,254,64,0,255,255,255,255,208,11,255,249,0,255,255,255,164,0,1,255,255,0,255,233,0,0,0,0,27,253,0,0,0,0,0,0,0,0,104,
  // 0x8907  複
  7,137,38,38,124,40,1,252,0,10,128,0,2,148,0,0,0,0,0,15,192,0,3,248,0,0,0,0,0,15,192,0,11,240,0,0,0,0,0,15,192,0,15,224,0,0,0,0,0,15,192,0,47,255,255,255,255,192,0,15,192,0,63,255,255,255,255,192,0,15,192,0,255,255,255,255,255,192,5,95,213,2,254,0,0,0,0,0,63,255,255,215,252,0,0,0,0,0,63,255,255,255,249,85,85,85,84,0,63,255,255,255,255,255,255,255,248,0,0,0,47,199,239,255,255,255,248,0,0,0,63,64,47,192,0,3,248,0,0,0,191,0,47,192,0,3,248,0,0,0,254,0,47,255,255,255,248,0,0,2,252,32,47,255,255,255,248,0,0,3,244,124,47,213,85,87,248,0,0,15,240,252,47,192,0,3,248,0,0,31,242,244,47,192,0,3,248,0,0,63,255,224,47,255,255,255,248,0,0,255,255,192,47,255,255,255,248,0,2,255,255,128,5,111,245,85,84,0,7,255,239,192,0,63,192,0,0,0,31,255,219,240,0,255,128,0,0,0,127,239,211,244,3,255,255,255,224,0,127,143,209,224,15,255,255,255,248,0,62,15,208,128,127,255,255,255,240,0,24,15,208,2,255,244,0,63,208,0,0,15,208,31,255,253,0,191,128,0,0,15,208,15,240,255,131,255,0,0,0,15,208,3,128,63,255,248,0,0,0,15,208,0,0,15,255,224,0,0,0,15,208,0,0,47,255,228,0,0,0,15,208,0,11,255,255,255,144,0,0,15,208,27,255,255,219,255,255,144,0,15,208,47,255,248,0,191,255,192,0,15,208,15,254,64,0,7,255,64,0,15,192,6,64,0,0,0,26,0,
  // 0x89d2  角
  210,137,34,39,95,40,1,251,0,0,0,164,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,15,255,255,255,224,0,0,0,0,31,255,255,255,252,0,0,0,0,63,255,255,255,244,0,0,0,0,255,128,0,31,240,0,0,0,3,255,0,0,63,192,0,0,0,15,252,0,0,191,64,0,0,0,47,249,85,85,255,85,85,80,0,255,255,255,255,255,255,255,240,7,255,255,255,255,255,255,255,240,31,255,255,255,255,255,255,255,240,15,251,240,0,15,224,0,11,240,3,199,240,0,15,224,0,11,240,0,7,240,0,15,224,0,11,240,0,7,240,0,15,224,0,11,240,0,7,244,0,15,240,0,15,240,0,7,255,255,255,255,255,255,240,0,7,255,255,255,255,255,255,240,0,7,255,255,255,255,255,255,240,0,7,240,0,15,224,0,11,240,0,7,240,0,15,224,0,11,240,0,11,240,0,15,224,0,11,240,0,11,240,0,15,224,0,11,240,0,15,245,85,95,245,85,95,240,0,15,255,255,255,255,255,255,240,0,31,255,255,255,255,255,255,240,0,47,255,255,255,255,255,255,240,0,63,192,0,0,0,0,11,240,0,127,64,0,0,0,0,11,240,0,255,0,0,0,0,0,11,240,2,254,0,0,0,0,0,11,240,11,252,0,0,0,0,0,15,240,47,244,0,0,0,6,149,111,240,127,224,0,0,0,7,255,255,224,47,192,0,0,0,3,255,255,192,10,0,0,0,0,2,255,249,0,0,0,0,0,0,0,0,0,0,
  // 0x8a08  計
  8,138,38,38,124,40,1,252,0,0,0,0,0,0,26,128,0,0,0,0,0,0,0,0,47,192,0,0,7,255,255,252,0,0,47,192,0,0,7,255,255,252,0,0,47,192,0,0,7,255,255,252,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,127,255,255,255,128,0,47,192,0,0,127,255,255,255,128,0,47,192,0,0,127,255,255,255,128,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,7,255,255,252,0,0,47,192,0,0,11,255,255,252,0,0,47,192,0,0,11,255,255,252,191,255,255,255,255,224,0,0,0,0,191,255,255,255,255,224,0,0,0,0,191,255,255,255,255,224,0,0,0,0,106,170,191,234,170,160,11,255,255,252,0,0,47,192,0,0,11,255,255,252,0,0,47,192,0,0,7,255,255,252,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,0,11,255,255,252,0,0,47,192,0,0,11,255,255,252,0,0,47,192,0,0,11,255,255,252,0,0,47,192,0,0,11,224,1,252,0,0,47,192,0,0,11,224,1,252,0,0,47,192,0,0,11,224,1,252,0,0,47,192,0,0,11,224,1,252,0,0,47,192,0,0,11,224,1,252,0,0,47,192,0,0,11,224,1,252,0,0,47,192,0,0,11,255,255,252,0,0,47,192,0,0,11,255,255,252,0,0,47,192,0,0,11,255,255,252,0,0,47,192,0,0,11,224,0,0,0,0,47,192,0,0,6,144,0,0,0,0,47,192,0,0,
  // 0x8a0a  訊
  10,138,39,37,114,40,1,251,7,255,255,240,255,255,255,255,208,0,7,255,255,240,255,255,255,255,208,0,7,255,255,240,255,255,255,255,208,0,0,0,0,0,170,255,170,175,208,0,0,0,0,0,0,191,0,31,208,0,127,255,255,254,0,191,0,31,208,0,127,255,255,254,0,191,0,31,208,0,127,255,255,253,0,191,0,31,208,0,0,0,0,0,0,191,0,31,208,0,0,0,0,0,0,191,0,31,208,0,7,255,255,240,0,191,0,31,208,0,11,255,255,240,0,191,0,31,208,0,11,255,255,240,0,191,0,31,208,0,0,0,0,0,0,191,0,31,208,0,0,0,0,1,255,255,255,95,208,0,0,0,0,1,255,255,255,95,208,0,11,255,255,241,255,255,255,95,208,0,11,255,255,240,85,255,85,31,208,0,11,255,255,240,0,254,0,31,208,0,0,0,0,0,0,254,0,31,208,0,0,0,0,0,0,253,0,15,208,0,0,0,0,0,0,253,0,15,208,0,11,255,255,240,1,252,0,15,208,0,11,255,255,240,2,252,0,15,224,0,11,255,255,240,3,248,0,15,224,0,11,224,3,240,3,244,0,15,224,0,11,224,3,240,11,240,0,15,240,64,11,224,3,240,15,240,0,11,240,208,11,224,3,240,47,224,0,7,240,240,11,224,3,240,63,192,0,7,244,244,11,224,3,240,191,128,0,3,248,240,11,255,255,241,255,0,0,3,253,240,11,255,255,247,253,0,0,2,255,240,11,255,255,255,252,0,0,0,255,224,11,224,0,3,240,0,0,0,191,192,6,144,0,0,192,0,0,0,47,64,0,0,0,0,0,0,0,0,0,0,
  // 0x8a18  記
  24,138,38,36,104,40,1,252,7,255,255,252,6,170,170,170,168,0,7,255,255,252,11,255,255,255,253,0,7,255,255,252,11,255,255,255,253,0,0,0,0,0,11,255,255,255,253,0,0,0,0,0,0,0,0,1,253,0,127,255,255,255,128,0,0,1,253,0,127,255,255,255,128,0,0,1,253,0,127,255,255,255,128,0,0,1,253,0,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,0,1,253,0,7,255,255,252,0,0,0,1,253,0,11,255,255,252,0,0,0,1,253,0,11,255,255,252,0,0,0,1,253,0,0,0,0,0,2,170,170,170,253,0,0,0,0,0,7,255,255,255,253,0,0,0,0,0,7,255,255,255,253,0,11,255,255,252,7,255,255,255,253,0,11,255,255,252,7,244,0,1,253,0,7,255,255,252,7,244,0,1,253,0,0,0,0,0,7,244,0,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,0,7,244,0,0,0,0,11,255,255,252,7,244,0,0,0,0,11,255,255,252,7,244,0,0,0,0,11,255,255,252,7,244,0,0,0,0,11,224,1,252,7,244,0,0,0,0,11,224,1,252,7,244,0,0,14,0,11,224,1,252,7,244,0,0,15,208,11,224,1,252,7,244,0,0,15,208,11,224,1,252,7,244,0,0,31,192,11,224,1,252,7,244,0,0,47,192,11,255,255,252,7,248,0,0,127,192,11,255,255,252,3,255,255,255,255,128,11,255,255,252,2,255,255,255,255,0,11,224,0,0,0,255,255,255,253,0,6,144,0,0,0,6,170,170,80,0,
  // 0x8a2d  設
  45,138,38,37,114,40,1,252,0,0,0,0,1,85,85,84,0,0,7,255,255,244,7,255,255,253,0,0,7,255,255,244,7,255,255,253,0,0,7,255,255,244,7,255,255,253,0,0,0,0,0,0,7,240,0,253,0,0,0,0,0,0,7,240,0,253,0,0,127,255,255,255,7,240,0,253,0,0,127,255,255,255,11,240,0,253,6,0,127,255,255,255,15,240,0,253,11,208,0,0,0,0,15,224,0,254,11,208,0,0,0,0,47,208,0,254,15,208,7,255,255,244,127,192,0,255,255,192,11,255,255,245,255,128,0,191,255,192,11,255,255,255,255,0,0,63,255,0,0,0,0,3,253,0,0,0,0,0,0,0,0,0,180,0,0,0,0,0,0,0,0,0,101,85,85,85,80,0,11,255,255,244,191,255,255,255,252,0,11,255,255,244,191,255,255,255,252,0,7,255,255,244,191,255,255,255,252,0,0,0,0,0,0,160,0,11,244,0,0,0,0,0,11,240,0,15,240,0,0,0,0,0,7,244,0,31,224,0,11,255,255,244,3,252,0,63,192,0,11,255,255,244,1,254,0,127,192,0,11,255,255,244,0,255,65,255,0,0,11,224,3,244,0,63,211,254,0,0,11,224,3,244,0,31,255,252,0,0,11,224,3,244,0,11,255,240,0,0,11,224,3,244,0,3,255,208,0,0,11,224,3,244,0,11,255,224,0,0,11,224,3,244,0,127,255,254,0,0,11,255,255,244,7,255,251,255,208,0,11,255,255,249,255,255,65,255,255,64,11,255,255,251,255,248,0,47,255,192,11,224,0,1,255,128,0,2,255,64,6,144,0,0,164,0,0,0,26,0,
  // 0x8a66  試
  102,138,38,38,124,40,1,252,0,0,0,0,0,0,1,168,0,0,0,0,0,0,0,0,2,252,180,0,7,255,255,224,0,0,2,253,253,0,7,255,255,224,0,0,2,252,191,0,7,255,255,224,0,0,2,252,63,192,0,0,0,0,0,0,2,252,15,208,0,0,0,0,0,0,2,252,11,64,127,255,255,252,0,0,2,252,0,0,127,255,255,253,255,255,255,255,255,192,127,255,255,254,255,255,255,255,255,192,0,0,0,2,255,255,255,255,255,192,0,0,0,0,85,85,86,253,85,64,11,255,255,240,0,0,1,252,0,0,11,255,255,240,0,0,1,252,0,0,11,255,255,240,0,0,1,252,0,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,0,1,252,0,0,0,0,0,1,255,255,245,252,0,0,11,255,255,241,255,255,244,252,0,0,11,255,255,241,255,255,244,252,0,0,11,255,255,240,2,252,0,253,0,0,0,0,0,0,2,252,0,253,0,0,0,0,0,0,2,252,0,253,0,0,0,0,0,0,2,252,0,254,0,0,11,255,255,240,2,252,0,254,0,0,11,255,255,240,2,252,0,191,0,0,11,255,255,240,2,252,0,191,0,0,11,208,7,240,2,252,0,127,0,0,11,208,7,240,2,252,0,63,2,0,11,208,7,240,2,252,5,63,67,208,11,208,7,240,2,255,254,63,131,240,11,208,7,241,111,255,254,47,195,240,11,208,7,243,255,255,253,31,231,224,11,255,255,243,255,250,64,15,255,208,11,255,255,242,249,0,0,11,255,192,11,255,255,240,0,0,0,3,255,128,11,208,0,0,0,0,0,0,255,0,6,128,0,0,0,0,0,0,20,0,
  // 0x8a8d  認
  141,138,38,36,104,40,1,252,7,255,255,224,127,255,255,255,255,0,7,255,255,224,127,255,255,255,255,0,7,255,255,224,127,255,255,255,255,0,0,0,0,0,0,3,244,0,191,0,0,0,0,0,0,3,240,0,191,0,127,255,255,252,30,7,240,0,191,0,127,255,255,252,63,255,224,0,191,0,127,255,255,252,127,255,208,0,254,0,0,0,0,0,7,255,244,0,254,0,0,0,0,0,0,63,255,64,254,0,11,255,255,224,0,191,255,208,253,0,11,255,255,224,1,255,127,192,253,0,11,255,255,224,3,252,7,1,252,0,0,0,0,0,31,244,1,71,252,0,0,0,0,0,191,224,7,255,252,0,0,0,0,3,255,128,3,255,244,0,11,255,255,224,253,3,131,255,208,0,11,255,255,224,96,15,244,0,0,0,11,255,255,224,0,15,254,0,0,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,42,15,244,0,0,11,255,255,240,0,127,2,224,160,0,11,255,255,240,16,127,0,71,244,0,11,255,255,240,126,127,0,3,252,0,11,208,7,240,190,127,0,1,253,0,11,208,7,240,254,127,0,0,255,0,11,208,7,240,253,127,0,0,127,64,11,208,7,240,252,127,0,45,63,192,11,208,7,242,252,127,0,47,95,208,11,208,7,243,244,127,0,47,79,224,11,255,255,251,240,63,64,63,15,240,11,255,255,251,224,63,255,255,11,64,11,255,255,241,192,63,255,254,0,0,11,208,0,0,0,31,255,252,0,0,6,128,0,0,0,0,0,0,0,0,
  // 0x8aa4  誤
  164,138,38,37,114,40,1,252,0,0,0,0,0,11,255,255,253,0,7,255,255,192,0,11,255,255,253,0,7,255,255,192,0,11,255,255,253,0,7,255,255,192,20,11,224,0,253,0,0,0,0,0,190,11,224,0,253,0,0,0,0,0,190,11,224,0,253,0,127,255,255,244,190,11,224,0,253,0,127,255,255,244,190,11,224,0,253,0,127,255,255,244,190,11,224,0,253,0,0,0,0,0,190,11,255,255,253,0,0,0,0,0,190,11,255,255,253,0,11,255,255,192,190,11,255,255,253,0,11,255,255,192,190,0,0,0,0,0,11,255,255,192,190,0,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,0,191,255,255,255,244,0,0,0,0,0,191,255,255,255,244,0,11,255,255,192,191,255,255,255,244,0,11,255,255,192,190,0,0,7,244,0,11,255,255,192,190,0,0,7,244,0,0,0,0,0,85,0,0,7,244,0,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,0,7,244,0,11,255,255,199,255,255,255,255,255,208,11,255,255,199,255,255,255,255,255,208,11,255,255,199,255,255,255,255,255,208,11,208,15,193,85,85,85,85,85,64,11,208,15,192,0,96,0,5,0,0,11,208,15,192,0,255,0,191,64,0,11,208,15,192,3,254,0,127,224,0,11,208,15,192,15,252,0,15,248,0,11,255,255,192,127,240,0,7,253,0,11,255,255,193,255,192,0,1,255,64,11,255,255,219,255,0,0,0,191,192,11,208,0,11,252,0,0,0,63,208,11,208,0,2,224,0,0,0,15,0,0,0,0,0,64,0,0,0,4,0,
  // 0x8abf  調
  191,138,36,36,68,40,1,252,11,255,255,66,255,255,255,255,255,11,255,255,66,255,255,255,255,255,7,255,255,66,255,255,255,255,255,0,0,0,2,248,0,0,0,63,0,0,0,2,248,0,252,0,63,127,255,255,226,248,0,252,0,63,127,255,255,226,248,0,252,0,63,127,255,255,226,248,191,255,252,63,0,0,0,2,248,191,255,252,63,0,0,0,2,248,127,255,248,63,11,255,255,66,248,0,252,0,63,15,255,255,130,248,0,252,0,63,15,255,255,130,248,0,252,0,63,0,0,0,2,248,191,255,252,63,0,0,0,2,248,255,255,253,63,0,0,0,2,248,255,255,253,63,15,255,255,130,248,0,0,0,63,15,255,255,130,248,0,0,0,63,11,255,255,66,248,0,0,0,63,0,0,0,2,248,127,255,248,63,0,0,0,3,248,127,255,248,63,0,0,0,3,244,127,171,248,63,15,255,255,67,244,125,0,248,63,15,255,255,67,244,125,0,248,63,15,255,255,67,240,125,0,248,63,15,192,47,71,240,125,0,248,63,15,192,47,75,240,127,171,248,63,15,192,47,75,224,127,255,248,63,15,192,47,79,208,127,255,248,63,15,192,47,95,208,125,0,0,63,15,255,255,111,192,40,0,0,63,15,255,255,191,192,0,0,0,127,15,255,255,255,64,0,1,255,255,15,192,0,191,0,0,0,255,255,15,192,0,30,0,0,0,191,252,0,0,0,4,0,0,0,106,80,
  // 0x8acb  請
  203,138,37,39,134,40,1,251,0,0,0,0,0,0,106,0,0,0,0,0,0,0,0,0,127,0,0,0,7,255,255,240,0,0,127,0,0,0,7,255,255,240,191,255,255,255,255,64,7,255,255,240,191,255,255,255,255,64,0,0,0,0,106,170,255,170,170,64,0,0,0,0,0,0,127,0,0,0,127,255,255,254,26,170,255,170,169,0,127,255,255,254,47,255,255,255,255,0,127,255,255,253,47,255,255,255,255,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,0,127,0,0,0,7,255,255,241,170,170,255,170,170,128,11,255,255,242,255,255,255,255,255,192,11,255,255,242,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,170,170,170,168,0,11,255,255,240,11,255,255,255,252,0,11,255,255,240,11,255,255,255,252,0,11,255,255,240,11,224,0,2,252,0,0,0,0,0,11,224,0,2,252,0,0,0,0,0,11,250,170,171,252,0,0,0,0,0,11,255,255,255,252,0,11,255,255,240,11,255,255,255,252,0,11,255,255,240,11,224,0,2,252,0,11,255,255,240,11,224,0,2,252,0,11,224,3,240,11,250,170,171,252,0,11,224,3,240,11,255,255,255,252,0,11,224,3,240,11,255,255,255,252,0,11,224,3,240,11,224,0,2,252,0,11,224,3,240,11,224,0,2,252,0,11,224,3,240,11,224,0,2,252,0,11,255,255,240,11,224,0,2,252,0,11,255,255,240,11,224,0,2,252,0,11,255,255,240,11,224,3,255,252,0,11,224,0,0,11,224,1,255,248,0,6,144,0,0,11,224,0,255,144,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8b70  議
  112,139,38,38,124,40,1,252,0,0,0,0,2,128,0,9,0,0,0,0,0,0,15,208,0,31,192,0,11,255,255,64,7,240,0,63,128,0,11,255,255,64,3,244,0,191,0,0,7,255,255,67,255,255,255,255,255,0,0,0,0,3,255,255,255,255,255,0,0,0,0,2,170,171,254,170,170,0,127,255,255,224,0,2,252,0,0,0,127,255,255,224,0,2,252,0,0,0,127,255,255,224,255,255,255,255,252,0,0,0,0,0,255,255,255,255,252,0,0,0,0,0,85,86,253,85,84,0,11,255,255,64,0,2,252,0,0,0,15,255,255,128,0,2,252,0,0,0,15,255,255,175,255,255,255,255,255,192,0,0,0,47,255,255,255,255,255,192,0,0,0,31,255,255,255,255,255,192,0,0,0,0,0,6,11,208,64,0,15,255,255,128,91,255,207,211,240,0,15,255,255,143,255,254,79,211,252,0,11,255,255,75,255,240,11,208,255,0,0,0,0,0,3,240,11,208,63,64,0,0,0,0,3,240,11,224,8,0,0,0,0,26,175,250,175,250,170,128,15,255,255,111,255,255,255,255,255,192,15,255,255,111,255,255,255,255,255,192,15,255,255,64,3,240,3,240,0,0,15,192,47,64,3,240,3,240,180,0,15,192,47,64,27,255,243,245,252,0,15,192,47,111,255,255,242,251,244,0,15,192,47,111,255,255,145,255,224,0,15,192,47,95,235,240,0,255,128,0,15,255,255,64,3,240,2,255,2,128,15,255,255,64,3,240,15,255,3,208,15,255,255,64,7,240,191,255,195,208,15,192,0,3,255,243,254,31,255,192,15,192,0,3,255,224,244,11,255,128,0,0,0,1,169,0,0,1,254,0,
  // 0x8b80  讀
  128,139,37,38,124,40,1,252,0,0,0,0,0,1,252,0,0,0,0,0,0,0,0,1,252,0,0,0,11,255,255,71,255,255,255,255,255,128,11,255,255,71,255,255,255,255,255,128,7,255,255,65,85,86,254,85,85,64,0,0,0,0,0,1,252,0,0,0,0,0,0,0,85,86,253,85,84,0,127,255,255,224,255,255,255,255,254,0,127,255,255,224,255,255,255,255,254,0,127,255,255,224,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,64,0,0,0,3,255,255,255,255,255,64,11,255,255,67,240,15,7,192,47,64,15,255,255,131,240,126,7,234,191,64,15,255,255,131,251,248,2,255,255,64,0,0,0,3,242,64,0,0,47,64,0,0,0,3,240,0,0,0,47,64,0,0,0,3,255,255,255,255,255,64,15,255,255,131,255,255,255,255,255,64,15,255,255,128,0,0,0,0,0,0,11,255,255,64,255,255,255,255,253,0,0,0,0,0,255,255,255,255,253,0,0,0,0,0,253,0,0,0,253,0,0,0,0,0,255,170,170,170,253,0,15,255,255,64,255,255,255,255,253,0,15,255,255,64,253,0,0,0,253,0,15,255,255,64,254,170,170,170,253,0,15,192,47,64,255,255,255,255,253,0,15,192,47,64,253,0,0,0,253,0,15,192,47,64,253,0,0,0,253,0,15,192,47,64,255,255,255,255,253,0,15,192,47,64,255,255,255,255,253,0,15,255,255,64,1,240,0,189,0,0,15,255,255,64,31,253,2,255,208,0,15,255,255,65,255,244,0,127,253,0,15,192,0,47,255,128,0,7,255,192,15,192,0,31,248,0,0,0,191,128,0,0,0,6,64,0,0,0,9,0,
  // 0x8b8a  變
  138,139,36,38,86,40,2,252,0,36,0,0,0,0,1,128,0,0,126,0,47,255,240,3,240,0,0,252,0,47,255,240,7,224,0,2,244,64,0,0,0,15,193,0,47,224,248,0,0,0,239,7,224,127,195,244,255,255,255,253,15,208,47,219,224,255,255,254,254,63,64,11,255,128,0,0,0,63,254,0,2,255,16,47,255,240,15,248,128,0,252,252,47,255,240,11,227,224,3,240,126,0,0,0,31,129,248,171,255,255,0,0,2,191,255,253,255,255,255,239,255,251,255,255,255,255,255,91,175,255,247,255,253,95,0,63,0,0,0,0,1,248,4,30,63,124,47,255,244,165,248,96,47,127,125,63,255,244,249,249,244,63,63,63,63,1,245,245,248,252,62,63,31,63,1,246,241,248,125,125,63,15,127,1,247,241,248,63,252,63,4,63,255,255,209,248,47,248,63,7,255,255,250,193,248,8,16,63,15,240,0,0,1,248,0,0,21,63,208,0,0,0,80,0,0,0,255,255,255,255,255,255,248,0,7,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,2,255,254,0,0,2,255,0,0,47,255,255,208,0,15,252,0,0,63,248,47,253,0,191,240,0,0,15,128,7,255,215,255,128,0,0,1,0,0,191,255,253,0,0,0,0,0,0,127,255,253,64,0,0,0,1,191,255,255,255,254,80,0,107,255,255,255,150,255,255,255,250,255,255,255,228,0,27,255,255,255,127,255,228,0,0,0,27,255,253,42,80,0,0,0,0,0,1,168,
  // 0x8cc7  資
  199,140,36,38,86,40,2,252,0,0,0,0,41,0,0,0,0,3,144,0,0,127,64,0,0,0,11,255,64,0,254,0,0,0,0,15,255,248,2,255,255,255,255,248,0,127,253,11,255,255,255,255,252,0,2,252,31,250,191,234,175,240,0,0,32,191,192,63,208,15,224,0,0,0,255,0,191,240,47,192,0,0,4,44,1,255,248,63,64,0,6,252,0,7,254,254,1,0,6,255,253,0,47,244,255,208,0,255,255,248,11,255,208,63,254,64,191,254,64,255,254,0,11,255,254,63,144,0,127,224,0,1,255,253,36,21,85,126,85,85,85,111,252,0,63,255,255,255,255,255,253,20,0,63,255,255,255,255,255,253,0,0,63,192,0,0,0,1,253,0,0,63,192,0,0,0,1,253,0,0,63,192,0,0,0,2,253,0,0,63,255,255,255,255,255,253,0,0,63,255,255,255,255,255,253,0,0,63,192,0,0,0,1,253,0,0,63,192,0,0,0,1,253,0,0,63,255,255,255,255,255,253,0,0,63,255,255,255,255,255,253,0,0,63,213,85,85,85,86,253,0,0,63,192,0,0,0,1,253,0,0,63,213,85,85,85,86,253,0,0,63,255,255,255,255,255,253,0,0,63,255,255,255,255,255,253,0,0,0,7,128,0,2,128,0,0,0,0,127,248,0,31,253,0,0,0,27,255,224,0,31,255,228,0,27,255,254,0,0,0,191,255,64,127,255,224,0,0,0,7,255,248,31,249,0,0,0,0,0,127,248,6,64,0,0,0,0,0,6,64,
  // 0x8ddd  距
  221,141,38,36,104,40,1,252,7,255,255,255,7,255,255,255,255,192,7,255,255,255,7,255,255,255,255,192,7,255,255,255,7,255,255,255,255,192,7,240,0,127,7,249,85,85,85,64,7,240,0,127,7,240,0,0,0,0,7,240,0,127,7,240,0,0,0,0,7,240,0,127,7,240,0,0,0,0,7,240,0,127,7,240,0,0,0,0,7,240,0,127,7,240,0,0,0,0,7,240,0,191,7,249,85,85,84,0,7,255,255,255,7,255,255,255,253,0,7,255,255,255,7,255,255,255,253,0,7,255,255,255,7,255,255,255,253,0,0,0,253,0,7,240,0,1,253,0,0,0,253,0,7,240,0,1,253,0,0,0,253,0,7,240,0,1,253,0,7,208,253,0,7,240,0,1,253,0,11,224,253,0,7,240,0,1,253,0,11,224,255,255,135,240,0,1,253,0,11,224,255,255,135,240,0,1,253,0,11,224,255,255,135,249,85,86,253,0,11,224,253,85,7,255,255,255,253,0,11,224,253,0,7,255,255,255,253,0,11,224,253,0,7,255,255,255,253,0,11,224,253,0,7,240,0,0,0,0,11,224,253,0,7,240,0,0,0,0,11,224,253,0,71,240,0,0,0,0,11,224,253,111,199,240,0,0,0,0,11,224,255,255,199,240,0,0,0,0,11,255,255,255,199,240,0,0,0,0,111,255,255,254,71,249,85,85,85,64,191,255,254,64,7,255,255,255,255,208,127,254,64,0,7,255,255,255,255,208,62,64,0,0,7,255,255,255,255,208,0,0,0,0,7,240,0,0,0,0,0,0,0,0,7,240,0,0,0,0,
  // 0x8eca  車
  202,142,36,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,21,85,85,85,255,85,85,85,84,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,85,85,85,85,255,85,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,
  // 0x8edf  軟
  223,142,38,38,124,40,1,252,0,0,254,0,0,14,64,0,0,0,0,0,254,0,0,31,208,0,0,0,0,0,254,0,0,31,192,0,0,0,0,0,254,0,0,47,192,0,0,0,63,255,255,255,244,47,192,0,0,0,63,255,255,255,244,63,128,0,0,0,63,255,255,255,244,63,64,0,0,0,0,0,254,0,0,127,149,85,85,0,0,0,254,0,0,191,255,255,255,192,0,0,254,0,0,255,255,255,255,192,10,170,255,170,145,255,255,255,255,128,15,255,255,255,226,252,47,192,63,64,15,255,255,255,227,252,47,192,127,0,15,192,188,7,231,244,47,192,127,0,15,192,188,7,239,240,47,192,190,0,15,192,188,7,255,224,47,192,254,0,15,234,254,171,255,192,47,192,253,0,15,255,255,255,255,128,47,192,252,0,15,255,255,255,227,0,47,193,248,0,15,192,188,7,224,0,63,192,0,0,15,192,188,7,224,0,63,192,0,0,15,192,188,7,224,0,63,208,0,0,15,255,255,255,224,0,127,224,0,0,15,255,255,255,224,0,191,240,0,0,10,170,255,170,160,0,255,240,0,0,0,0,254,0,0,1,250,248,0,0,0,0,254,0,0,3,245,252,0,0,21,85,254,85,80,7,240,253,0,0,127,255,255,255,252,15,240,191,0,0,127,255,255,255,252,47,208,63,128,0,127,255,255,255,252,127,192,47,208,0,0,0,254,0,1,255,0,15,244,0,0,0,254,0,7,253,0,11,252,0,0,0,254,0,47,248,0,3,255,64,0,0,254,0,255,240,0,0,255,224,0,0,254,0,255,128,0,0,63,208,0,0,254,0,62,0,0,0,15,128,0,0,253,0,20,0,0,0,2,0,
  // 0x8ef8  軸
  248,142,36,38,86,40,1,252,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,0,0,2,252,0,0,0,31,192,0,63,255,255,255,208,0,31,192,0,63,255,255,255,208,0,31,192,0,63,255,255,255,208,0,31,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,7,255,255,255,255,10,171,254,170,135,255,255,255,255,15,255,255,255,199,255,255,255,255,15,255,255,255,199,245,111,213,127,15,128,248,15,199,240,31,192,63,15,128,248,15,199,240,31,192,63,15,128,248,15,199,240,31,192,63,15,234,254,175,199,240,31,192,63,15,255,255,255,199,240,31,192,63,15,255,255,255,199,240,31,192,63,15,128,248,15,199,240,31,192,63,15,128,248,15,199,255,255,255,255,15,128,248,15,199,255,255,255,255,15,255,255,255,199,255,255,255,255,15,255,255,255,199,245,111,213,127,10,171,254,170,135,240,31,192,63,0,1,252,0,7,240,31,192,63,0,1,252,0,7,240,31,192,63,21,86,253,85,87,240,31,192,63,127,255,255,255,247,240,31,192,63,127,255,255,255,247,240,31,192,63,127,255,255,255,247,240,31,192,63,0,1,252,0,7,240,31,192,63,0,1,252,0,7,255,255,255,255,0,1,252,0,7,255,255,255,255,0,1,252,0,7,255,255,255,255,0,1,252,0,7,245,85,85,127,0,1,252,0,7,240,0,0,63,0,1,252,0,3,224,0,0,21,
  // 0x8f09  載
  9,143,37,38,124,40,2,252,0,0,63,64,0,47,192,16,0,0,0,0,63,64,0,47,192,188,0,0,0,0,63,64,0,47,194,255,0,0,15,255,255,255,252,47,192,191,192,0,15,255,255,255,252,47,192,47,240,0,15,255,255,255,252,47,192,15,248,0,0,0,63,64,0,47,192,3,244,0,0,0,63,64,0,47,192,1,192,0,0,0,63,64,0,47,192,0,0,0,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,0,0,0,63,64,0,31,208,0,0,0,0,0,63,64,0,31,208,0,0,0,26,170,191,234,170,15,208,2,64,0,47,255,255,255,255,15,224,7,240,0,47,255,255,255,255,15,224,15,240,0,0,0,63,64,0,15,224,15,224,0,0,0,63,64,0,15,240,47,192,0,15,255,255,255,252,11,240,63,128,0,15,255,255,255,252,11,240,127,64,0,15,192,63,0,188,7,244,255,0,0,15,192,63,0,188,7,245,254,0,0,15,255,255,255,252,3,251,252,0,0,15,255,255,255,252,3,255,244,0,0,15,192,63,0,188,2,255,240,0,0,15,192,63,0,188,2,255,192,0,0,15,255,255,255,252,1,255,128,16,0,15,255,255,255,252,1,255,0,45,0,0,0,63,0,0,3,255,0,47,64,0,0,63,0,0,15,255,128,63,64,42,170,255,234,170,63,255,192,63,0,127,255,255,255,255,255,239,224,63,0,127,255,255,255,255,255,15,248,191,0,0,0,63,0,47,252,7,255,254,0,0,0,63,0,63,240,2,255,252,0,0,0,63,0,15,128,0,191,244,0,0,0,63,0,5,0,0,6,64,0,
  // 0x8f2f  輯
  47,143,38,38,124,40,1,252,0,1,252,0,0,0,0,0,0,0,0,1,252,0,0,170,170,170,168,0,0,1,252,0,0,255,255,255,253,0,0,1,252,0,0,255,255,255,253,0,0,2,252,0,0,253,0,1,253,0,63,255,255,255,208,253,0,1,253,0,63,255,255,255,208,253,0,1,253,0,63,255,255,255,208,255,170,171,253,0,0,1,252,0,0,255,255,255,253,0,0,1,252,0,0,255,255,255,253,0,10,171,254,170,128,0,0,0,0,0,15,255,255,255,192,0,0,0,0,0,15,255,255,255,223,255,255,255,255,208,15,128,248,15,223,255,255,255,255,208,15,128,248,15,223,255,255,255,255,208,15,128,248,15,192,254,0,1,252,0,15,234,254,175,192,254,0,1,252,0,15,255,255,255,192,254,0,1,252,0,15,255,255,255,192,255,170,171,252,0,15,128,248,15,192,255,255,255,252,0,15,128,248,15,192,255,255,255,252,0,15,128,248,15,192,254,0,1,252,0,15,255,255,255,192,254,0,1,252,0,15,255,255,255,192,254,0,1,252,0,10,171,254,170,128,255,170,171,252,0,0,1,252,0,0,255,255,255,252,0,0,1,252,0,0,255,255,255,252,0,21,86,253,85,80,254,0,1,252,0,127,255,255,255,240,254,0,1,252,0,127,255,255,255,240,254,0,1,252,0,127,255,255,255,240,254,106,255,255,208,0,1,252,0,63,255,255,255,255,208,0,1,252,0,63,255,255,255,255,208,0,1,252,0,63,255,234,81,252,0,0,1,252,0,20,0,0,1,252,0,0,1,252,0,0,0,0,1,252,0,0,1,252,0,0,0,0,1,252,0,0,1,252,0,0,0,0,0,168,0,
  // 0x8f38  輸
  56,143,38,38,124,40,1,252,0,3,240,0,0,0,106,64,0,0,0,3,240,0,0,0,255,192,0,0,0,3,240,0,0,1,255,224,0,0,0,3,240,0,0,3,255,248,0,0,63,255,255,255,64,15,242,253,0,0,63,255,255,255,64,47,208,255,64,0,63,255,255,255,64,191,128,63,208,0,0,7,244,0,2,255,0,31,244,0,0,3,240,0,11,252,0,7,254,0,0,3,240,0,63,240,0,1,255,208,26,175,254,170,255,255,255,255,127,240,31,255,255,254,255,191,255,255,31,192,31,255,255,254,189,63,255,255,3,128,31,66,224,62,52,0,0,0,0,0,31,66,224,62,0,0,0,0,0,0,31,66,224,62,0,0,0,0,21,0,31,171,250,190,42,170,160,0,47,64,31,255,255,254,63,255,240,168,47,64,31,255,255,254,63,255,240,252,47,64,31,66,224,62,63,1,240,252,47,64,31,66,224,62,63,1,240,252,47,64,31,66,224,62,63,170,240,252,47,64,31,255,255,254,63,255,240,252,47,64,31,255,255,254,63,255,240,252,47,64,26,171,250,169,63,1,240,252,47,64,0,3,240,0,63,1,240,252,47,64,0,3,240,0,63,1,240,252,47,64,21,87,245,85,63,171,240,252,47,64,127,255,255,255,63,255,240,252,47,64,127,255,255,255,63,255,240,252,47,64,127,255,255,255,63,1,240,252,47,64,0,3,240,0,63,1,240,84,47,64,0,3,240,0,63,1,240,0,47,64,0,3,240,0,63,1,240,0,47,64,0,3,240,0,63,1,240,0,47,64,0,3,240,0,63,31,240,47,255,0,0,3,240,0,63,15,240,15,255,0,0,3,240,0,21,6,64,10,164,0,
  // 0x8f49  轉
  73,143,38,38,124,40,1,252,0,2,248,0,0,0,47,64,0,0,0,2,248,0,0,0,47,128,0,0,0,2,248,0,0,0,47,128,0,0,0,2,248,0,47,255,255,255,255,192,0,3,254,170,111,255,255,255,255,192,63,255,255,255,159,255,255,255,255,128,63,255,255,255,128,0,47,128,0,0,63,255,255,255,128,0,47,128,0,0,0,2,248,0,15,255,255,255,255,0,0,2,248,0,15,255,255,255,255,0,10,171,254,170,15,192,47,128,63,0,15,255,255,255,15,192,47,128,63,0,15,255,255,255,15,255,255,255,255,0,15,129,240,47,15,255,255,255,255,0,15,129,240,47,15,208,47,128,63,0,15,129,240,47,15,192,47,128,63,0,15,234,250,191,15,255,255,255,255,0,15,255,255,255,15,255,255,255,255,0,15,255,255,255,0,0,47,130,244,0,15,129,240,47,0,0,47,131,248,0,15,129,240,47,0,0,47,129,254,0,15,129,240,47,63,255,255,255,255,0,15,255,255,255,63,255,255,255,255,192,15,255,255,255,47,234,170,169,95,208,10,171,254,170,0,0,0,47,134,0,0,2,248,0,0,0,0,63,128,0,0,2,248,0,63,255,255,255,255,208,21,87,248,0,63,255,255,255,255,208,127,255,255,255,255,255,255,255,255,208,127,255,255,255,192,180,0,63,128,0,127,255,255,255,194,253,0,63,128,0,0,2,248,0,0,255,0,63,128,0,0,2,248,0,0,63,192,63,128,0,0,2,248,0,0,31,192,63,128,0,0,2,248,0,0,14,0,63,128,0,0,2,248,0,0,0,191,255,128,0,0,2,248,0,0,0,63,255,0,0,0,2,248,0,0,0,63,248,0,0,
  // 0x8fd1  近
  209,143,38,38,124,40,1,252,0,0,0,0,0,0,0,2,0,0,1,64,0,0,0,0,1,191,208,0,11,224,0,0,0,5,191,255,244,0,31,252,0,2,234,255,255,255,228,0,7,255,0,2,255,255,255,249,0,0,1,255,192,2,255,255,229,0,0,0,0,63,240,2,254,80,0,0,0,0,0,15,248,2,252,0,0,0,0,0,0,3,224,2,252,0,0,0,0,0,0,1,128,2,252,0,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,2,255,255,255,255,255,192,0,0,0,2,255,255,255,255,255,192,0,0,0,2,255,255,255,255,255,192,0,0,0,2,253,85,95,245,85,64,63,255,240,3,252,0,15,240,0,0,63,255,240,3,248,0,15,240,0,0,63,255,240,3,248,0,15,240,0,0,21,95,240,3,244,0,15,240,0,0,0,15,240,7,240,0,15,240,0,0,0,15,240,11,240,0,15,240,0,0,0,15,240,15,224,0,15,240,0,0,0,15,240,31,208,0,15,240,0,0,0,15,240,63,192,0,15,240,0,0,0,15,240,127,128,0,15,240,0,0,0,15,240,255,0,0,15,240,0,0,0,15,243,254,0,0,15,240,0,0,0,15,242,252,0,0,15,240,0,0,0,15,240,180,0,0,15,240,0,0,0,127,252,16,0,0,15,240,0,0,2,255,255,64,0,0,6,144,0,0,15,255,191,244,0,0,0,0,0,0,127,252,47,255,250,170,170,170,171,208,63,224,11,255,255,255,255,255,255,192,47,128,0,191,255,255,255,255,255,128,13,0,0,6,191,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x8fd4  返
  212,143,38,37,114,40,1,252,1,64,0,0,0,0,0,0,0,0,11,224,0,11,255,255,255,255,255,0,31,252,0,11,255,255,255,255,255,0,7,255,0,11,255,255,255,255,255,0,1,255,192,11,245,85,85,85,85,0,0,127,224,11,240,0,0,0,0,0,0,31,244,11,240,0,0,0,0,0,0,11,224,11,240,0,0,0,0,0,0,3,64,11,240,0,0,0,0,0,0,0,0,11,245,85,85,85,64,0,0,0,0,11,255,255,255,255,248,0,0,0,0,15,255,255,255,255,244,0,0,0,0,15,255,255,255,255,240,0,0,0,0,15,251,240,0,15,240,0,0,0,0,15,243,248,0,31,208,0,63,255,208,15,226,252,0,63,192,0,63,255,208,15,225,253,0,127,128,0,63,255,208,15,208,255,0,255,0,0,21,111,208,31,208,127,194,254,0,0,0,15,208,31,192,47,215,252,0,0,0,15,208,63,192,15,255,244,0,0,0,15,208,63,192,7,255,224,0,0,0,15,208,127,64,3,255,192,0,0,0,15,208,191,0,7,255,208,0,0,0,15,208,255,0,47,255,248,0,0,0,15,209,253,0,255,255,255,64,0,0,15,211,252,27,255,195,255,248,0,0,15,219,244,255,254,0,191,255,128,0,31,242,240,127,244,0,31,255,128,0,191,248,80,47,64,0,1,255,0,2,255,255,0,4,0,0,0,29,0,15,254,255,228,0,0,0,0,0,0,127,248,63,255,234,149,86,170,170,208,63,224,11,255,255,255,255,255,255,192,47,64,1,255,255,255,255,255,255,128,13,0,0,6,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x9000  退
  0,144,38,37,114,40,1,252,0,64,0,0,0,0,0,0,0,0,3,224,0,3,255,255,255,255,208,0,15,252,0,3,255,255,255,255,208,0,7,255,64,3,255,255,255,255,208,0,0,255,208,3,248,0,0,15,208,0,0,63,244,3,248,0,0,15,208,0,0,15,252,3,248,0,0,15,208,0,0,3,240,3,255,255,255,255,208,0,0,0,128,3,255,255,255,255,208,0,0,0,0,3,255,255,255,255,208,0,0,0,0,3,248,0,0,15,208,0,0,0,0,3,248,0,0,15,208,0,0,0,0,3,248,0,0,15,208,0,0,0,0,3,255,255,255,255,208,0,0,0,0,3,255,255,255,255,208,0,63,255,240,3,255,255,255,255,224,0,63,255,240,3,248,7,244,0,120,0,63,255,240,3,248,3,248,1,255,0,21,95,240,3,248,1,252,11,255,0,0,15,240,3,248,0,254,63,244,0,0,15,240,3,248,0,191,255,192,0,0,15,240,3,248,0,63,253,0,0,0,15,240,3,248,0,47,240,0,0,0,15,240,3,248,0,15,248,0,0,0,15,240,3,248,27,231,255,0,0,0,15,240,3,255,255,241,255,208,0,0,15,240,111,255,255,240,127,253,0,0,15,240,191,255,254,64,31,255,192,0,15,240,127,254,64,0,7,255,0,0,127,252,62,64,0,0,0,125,0,2,255,255,64,0,0,0,0,4,0,15,255,191,244,0,0,0,0,0,0,127,252,47,255,250,170,170,170,171,208,63,224,11,255,255,255,255,255,255,192,47,128,0,191,255,255,255,255,255,128,13,0,0,6,191,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x901f  速
  31,144,38,38,124,40,1,252,0,0,0,0,0,11,224,0,0,0,1,128,0,0,0,15,224,0,0,0,11,240,0,0,0,15,224,0,0,0,31,253,0,0,0,15,224,0,0,0,7,255,64,255,255,255,255,255,255,128,0,255,208,255,255,255,255,255,255,128,0,63,244,255,255,255,255,255,255,128,0,15,248,0,0,15,240,0,0,0,0,3,208,0,0,15,224,0,0,0,0,1,64,0,0,15,224,0,0,0,0,0,0,47,255,255,255,255,252,0,0,0,0,47,255,255,255,255,252,0,0,0,0,47,255,255,255,255,252,0,0,0,0,47,128,15,224,2,252,0,0,0,0,47,128,15,224,2,252,0,0,0,0,47,128,15,224,2,252,0,63,255,240,47,128,15,224,2,252,0,63,255,240,47,128,15,224,2,252,0,63,255,240,47,255,255,255,255,252,0,21,95,240,47,255,255,255,255,252,0,0,15,240,47,255,255,255,255,252,0,0,15,240,0,0,255,254,0,0,0,0,15,240,0,3,255,255,128,0,0,0,15,240,0,15,255,255,224,0,0,0,15,240,0,63,223,231,252,0,0,0,15,240,1,255,79,225,255,64,0,0,15,240,11,253,15,224,127,240,0,0,15,240,127,244,15,224,31,254,0,0,15,242,255,208,15,224,7,255,128,0,15,240,255,0,15,224,0,254,0,0,127,252,52,0,15,224,0,28,0,2,255,255,64,0,15,224,0,0,0,15,255,191,244,0,0,0,0,0,0,127,252,47,255,250,170,170,170,171,208,63,224,11,255,255,255,255,255,255,192,47,128,0,191,255,255,255,255,255,128,13,0,0,6,191,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x9023  連
  35,144,36,38,86,40,2,252,0,0,0,0,0,42,0,0,0,0,0,0,0,0,127,64,0,0,31,0,0,0,0,127,64,0,0,127,208,0,0,0,127,64,0,0,63,244,11,255,255,255,255,255,252,15,253,11,255,255,255,255,255,252,2,255,11,255,255,255,255,255,252,0,255,192,0,0,127,64,0,0,0,63,128,0,0,127,64,0,0,0,13,0,255,255,255,255,255,208,0,0,0,255,255,255,255,255,208,0,0,0,255,170,191,234,175,208,0,0,0,253,0,127,64,31,208,0,0,0,253,0,127,64,31,208,0,0,0,255,170,191,170,175,208,0,0,0,255,255,255,255,255,208,255,255,64,255,255,255,255,255,208,255,255,64,253,0,127,64,31,208,255,255,64,253,0,127,64,31,208,85,191,64,253,0,127,64,31,208,0,127,64,255,255,255,255,255,208,0,127,64,255,255,255,255,255,208,0,127,64,170,170,255,234,170,128,0,127,64,0,0,127,64,0,0,0,127,64,0,0,127,64,0,0,0,127,79,255,255,255,255,255,254,0,127,79,255,255,255,255,255,254,0,127,79,255,255,255,255,255,254,0,127,64,0,0,127,64,0,0,0,127,128,0,0,127,64,0,0,1,255,208,0,0,127,64,0,0,11,255,248,0,0,127,64,0,0,63,251,255,64,0,0,0,0,0,255,208,255,254,149,85,85,86,170,255,64,63,255,255,255,255,255,255,189,0,7,255,255,255,255,255,254,52,0,0,27,255,255,255,255,253,0,0,0,0,0,0,0,0,0,
  // 0x9032  進
  50,144,36,38,86,40,2,252,0,0,0,0,144,0,16,0,0,9,0,0,0,255,0,63,192,0,63,128,0,2,254,0,127,128,0,127,224,0,3,252,0,191,0,0,31,252,0,11,248,0,255,0,0,7,255,0,31,240,1,253,0,0,1,255,128,63,255,255,255,255,252,0,127,192,191,255,255,255,255,252,0,47,1,255,255,255,255,255,252,0,8,7,255,192,7,248,0,0,0,0,15,255,128,3,244,0,0,0,0,63,255,128,3,244,0,0,0,0,255,255,128,3,244,0,0,0,0,255,191,255,255,255,255,240,0,0,62,63,255,255,255,255,240,0,0,8,63,255,255,255,255,240,255,255,64,63,128,3,244,0,0,255,255,64,63,128,3,244,0,0,255,255,64,63,128,3,244,0,0,85,191,64,63,128,3,244,0,0,0,127,64,63,255,255,255,255,224,0,127,64,63,255,255,255,255,224,0,127,64,63,255,255,255,255,224,0,127,64,63,128,3,244,0,0,0,127,64,63,128,3,244,0,0,0,127,64,63,128,3,244,0,0,0,127,64,63,128,7,248,0,0,0,127,64,63,255,255,255,255,253,0,127,64,63,255,255,255,255,253,0,127,128,63,255,255,255,255,253,1,255,208,0,0,0,0,0,0,11,255,248,0,0,0,0,0,0,63,251,255,64,0,0,0,0,0,255,208,255,254,149,85,85,86,170,255,64,63,255,255,255,255,255,255,189,0,7,255,255,255,255,255,254,52,0,0,27,255,255,255,255,253,0,0,0,0,0,0,0,0,0,
  // 0x904b  運
  75,144,36,37,77,40,2,252,5,0,6,170,170,170,170,170,168,47,64,7,255,255,255,255,255,252,191,224,7,255,255,255,255,255,252,47,248,7,240,0,0,0,0,252,11,254,7,240,0,42,64,0,252,2,255,70,160,0,63,128,0,168,0,191,192,0,0,63,128,0,0,0,63,130,255,255,255,255,255,240,0,13,2,255,255,255,255,255,240,0,0,1,170,170,191,234,170,160,0,0,0,0,0,63,128,0,0,0,0,0,21,85,127,149,85,64,0,0,0,127,255,255,255,255,192,0,0,0,127,255,255,255,255,192,0,0,0,126,0,63,128,15,192,255,255,64,126,0,63,128,15,192,255,255,64,127,255,255,255,255,192,255,255,64,127,255,255,255,255,192,85,191,64,127,0,127,128,31,192,0,127,64,126,0,63,128,15,192,0,127,64,126,0,63,128,15,192,0,127,64,127,255,255,255,255,192,0,127,64,127,255,255,255,255,192,0,127,64,21,85,127,149,85,64,0,127,64,0,0,63,128,0,0,0,127,79,255,255,255,255,255,254,0,127,79,255,255,255,255,255,255,0,127,79,255,255,255,255,255,255,0,127,128,0,0,63,128,0,0,1,255,208,0,0,63,128,0,0,11,255,248,0,0,63,128,0,0,63,251,255,64,0,21,0,0,0,255,208,255,254,149,85,85,86,170,255,64,63,255,255,255,255,255,255,189,0,7,255,255,255,255,255,254,52,0,0,27,255,255,255,255,253,0,0,0,0,0,0,0,0,0,
  // 0x9054  達
  84,144,37,38,124,40,1,252,0,0,0,0,0,15,208,0,0,0,1,64,0,0,0,15,224,0,0,0,11,208,0,0,0,15,224,0,0,0,47,248,0,31,255,255,255,255,240,0,11,254,0,31,255,255,255,255,240,0,2,255,128,26,170,175,250,170,160,0,0,127,208,0,0,15,224,0,0,0,0,47,240,0,0,15,224,0,0,0,0,11,210,170,170,191,250,170,170,128,0,3,3,255,255,255,255,255,255,192,0,0,3,255,255,255,255,255,255,192,0,0,0,0,253,0,0,253,0,0,0,0,0,0,191,0,2,253,0,0,0,0,0,0,127,64,3,252,0,0,0,0,0,0,63,128,7,240,0,0,0,0,0,170,191,234,171,250,170,0,63,255,209,255,255,255,255,255,255,64,63,255,209,255,255,255,255,255,255,64,63,255,208,0,0,15,224,0,0,0,21,111,208,0,0,15,224,0,0,0,0,31,208,42,170,175,250,170,168,0,0,31,208,63,255,255,255,255,252,0,0,31,208,63,255,255,255,255,252,0,0,31,208,0,0,15,224,0,0,0,0,31,208,0,0,15,224,0,0,0,0,31,209,255,255,255,255,255,255,64,0,31,210,255,255,255,255,255,255,64,0,31,210,255,255,255,255,255,255,64,0,31,208,0,0,15,224,0,0,0,0,47,224,0,0,15,224,0,0,0,0,191,248,0,0,15,224,0,0,0,2,255,254,0,0,10,144,0,0,0,15,254,255,224,0,0,0,0,0,0,127,244,63,255,165,85,85,85,170,128,63,208,15,255,255,255,255,255,255,192,47,64,1,255,255,255,255,255,255,128,13,0,0,6,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x9078  選
  120,144,38,37,114,40,1,252,2,0,1,85,85,80,85,85,84,0,31,192,3,255,255,244,255,255,253,0,63,240,3,255,255,244,255,255,253,0,15,252,0,0,3,244,0,0,253,0,3,255,0,0,3,244,0,0,253,0,0,255,128,170,171,244,42,170,253,0,0,127,209,255,255,244,127,255,253,0,0,47,193,255,255,244,127,255,253,0,0,13,1,248,0,0,127,0,0,0,0,0,1,252,0,57,127,0,11,128,0,0,0,254,170,254,63,170,175,192,0,0,0,255,255,252,63,255,255,128,0,0,0,47,255,244,11,255,254,0,0,0,0,0,21,64,1,80,0,0,0,0,0,0,63,128,11,240,0,0,63,255,192,0,63,128,11,240,0,0,63,255,193,170,191,234,175,250,170,0,63,255,193,255,255,255,255,255,254,0,21,127,193,255,255,255,255,255,254,0,0,47,192,0,63,128,11,240,0,0,0,47,192,0,63,128,11,240,0,0,0,47,192,0,63,128,11,240,0,0,0,47,203,255,255,255,255,255,255,192,0,47,203,255,255,255,255,255,255,192,0,47,203,255,255,255,255,255,255,192,0,47,192,0,10,0,0,128,0,0,0,47,192,0,127,208,11,248,0,0,0,47,192,7,255,128,7,255,128,0,0,47,192,127,253,0,0,127,244,0,0,191,241,255,224,0,0,15,254,0,2,255,252,62,0,0,0,2,254,0,15,254,255,144,0,0,0,0,80,0,63,244,127,254,85,0,0,21,85,144,127,208,31,255,255,255,255,255,255,192,63,64,2,255,255,255,255,255,255,192,28,0,0,27,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,
  // 0x9084  還
  132,144,36,37,77,40,2,252,10,0,2,255,255,255,255,255,240,127,192,2,255,255,255,255,255,240,127,240,2,248,31,192,253,11,240,31,252,2,248,15,128,252,7,240,7,254,2,248,15,128,252,7,240,1,255,130,248,15,128,252,7,240,0,191,194,255,255,255,255,255,240,0,47,66,255,255,255,255,255,240,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,255,0,0,47,255,255,255,255,255,255,0,0,26,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,128,255,255,64,127,255,255,255,255,128,255,255,64,127,0,0,0,63,128,255,255,64,127,0,0,0,63,128,85,191,64,127,0,0,0,63,128,0,127,64,127,0,0,0,63,128,0,127,64,127,255,255,255,255,128,0,127,64,127,255,255,255,255,208,0,127,64,0,7,255,64,11,248,0,127,64,0,47,255,208,47,224,0,127,64,1,255,255,248,255,64,0,127,64,31,254,255,255,252,0,0,127,66,255,244,191,127,244,0,0,127,79,255,128,191,15,255,144,0,127,135,253,0,191,1,255,253,1,255,209,128,0,191,0,31,248,11,255,248,0,0,191,0,0,160,63,251,255,64,0,106,0,0,0,255,208,255,254,149,85,85,86,170,255,64,63,255,255,255,255,255,255,189,0,7,255,255,255,255,255,254,52,0,0,27,255,255,255,255,253,0,0,0,0,0,0,0,0,0,
  // 0x908a  邊
  138,144,38,38,124,40,1,252,0,0,0,0,0,15,144,0,0,0,1,244,0,0,0,31,192,0,0,0,7,254,0,15,255,255,255,255,208,0,2,255,192,15,250,170,170,175,208,0,0,127,240,15,224,0,0,15,208,0,0,15,252,15,250,170,170,175,208,0,0,3,240,15,255,255,255,255,208,0,0,0,128,15,224,0,0,15,208,0,0,0,0,15,250,170,170,175,208,0,7,128,0,15,255,255,255,255,208,0,31,244,0,15,224,0,0,15,208,0,47,254,0,15,224,0,0,15,208,0,7,255,128,15,255,255,255,255,208,0,0,191,224,10,170,191,250,170,144,0,0,31,192,0,0,15,192,0,0,0,0,7,2,255,255,255,255,255,255,64,0,0,2,255,255,255,255,255,255,64,0,0,2,248,7,208,188,1,63,64,0,0,2,248,31,192,189,3,255,64,63,255,192,1,255,0,127,255,192,0,63,255,192,127,252,15,255,255,64,0,63,255,192,63,144,15,192,0,0,0,21,111,192,20,0,31,208,0,0,0,0,31,195,255,255,255,255,255,255,128,0,31,195,255,255,255,255,255,255,128,0,31,192,0,7,240,0,0,0,0,0,31,192,0,11,255,255,255,128,0,0,31,192,0,47,255,255,255,64,0,0,31,192,0,191,64,0,63,64,0,0,47,192,11,254,0,0,63,0,0,0,127,241,255,244,0,0,191,0,0,2,255,252,191,64,2,255,253,0,0,15,254,255,244,0,1,255,244,0,0,127,244,127,255,165,85,85,85,90,144,127,208,31,255,255,255,255,255,255,192,63,64,1,255,255,255,255,255,255,128,29,0,0,10,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x90e8  部
  232,144,38,38,124,40,1,252,0,0,21,64,0,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,0,47,192,0,1,85,85,88,0,0,0,47,192,0,7,255,255,255,128,0,0,47,192,0,7,255,255,255,208,31,255,255,255,255,135,255,255,255,192,31,255,255,255,255,135,244,0,191,64,31,255,255,255,255,135,244,0,255,0,0,4,0,1,64,7,244,1,254,0,0,189,0,3,244,7,244,2,252,0,0,191,0,7,240,7,244,3,252,0,0,63,0,15,224,7,244,7,244,0,0,63,64,15,208,7,244,15,240,0,0,47,128,31,192,7,244,15,224,0,0,47,128,47,64,7,244,47,192,0,21,105,85,86,85,71,244,63,128,0,127,255,255,255,255,199,244,127,128,0,127,255,255,255,255,199,244,63,208,0,127,255,255,255,255,199,244,15,240,0,0,0,0,0,0,7,244,3,252,0,0,0,0,0,0,7,244,1,253,0,0,0,0,0,0,7,244,0,255,0,0,85,85,85,84,7,244,0,127,0,3,255,255,255,252,7,244,0,63,128,3,255,255,255,252,7,244,0,63,128,3,255,255,255,252,7,244,0,63,192,3,248,0,1,252,7,244,0,63,192,3,248,0,1,252,7,244,0,63,128,3,248,0,1,252,7,244,0,255,128,3,248,0,1,252,7,244,255,255,64,3,248,0,1,252,7,244,191,255,0,3,248,0,1,252,7,244,127,252,0,3,255,255,255,252,7,244,42,144,0,3,255,255,255,252,7,244,0,0,0,3,255,255,255,252,7,244,0,0,0,3,252,0,2,252,7,244,0,0,0,3,248,0,1,252,7,244,0,0,0,2,164,0,0,84,7,240,0,0,0,
  // 0x91cb  釋
  203,145,38,38,124,40,1,252,0,0,0,16,0,0,0,0,0,0,0,0,27,248,42,170,170,170,170,0,1,107,255,254,63,255,255,255,255,0,63,255,255,244,63,255,255,255,255,0,63,255,248,0,63,7,192,240,63,0,25,67,244,0,63,7,192,240,63,0,1,3,244,61,63,7,192,240,63,0,15,67,244,63,63,7,192,240,63,0,15,195,244,127,63,175,234,250,191,0,15,195,244,189,63,255,255,255,255,0,7,211,244,252,63,255,255,255,255,0,3,227,244,248,0,0,127,0,0,0,3,243,246,240,0,0,127,0,0,0,3,211,245,240,15,255,255,255,252,0,0,3,244,0,15,255,255,255,252,0,127,255,255,255,6,170,191,170,168,0,127,255,255,255,0,0,127,0,0,0,127,255,255,255,0,0,127,0,0,0,0,15,244,0,255,255,255,255,255,208,0,31,244,0,255,255,255,255,255,208,0,47,253,0,170,254,170,175,234,128,0,63,255,64,0,252,0,15,192,0,0,127,255,208,0,253,0,31,128,0,0,255,255,244,0,127,0,63,0,0,1,251,246,253,0,63,0,125,0,0,3,243,244,254,191,255,255,255,255,128,7,227,244,60,191,255,255,255,255,128,15,211,244,16,106,170,255,170,170,64,47,195,244,0,0,0,127,0,0,0,127,67,244,0,0,0,127,0,0,0,127,3,244,0,47,255,255,255,254,0,45,3,244,0,47,255,255,255,254,0,24,3,244,0,26,170,255,170,169,0,0,3,244,0,0,0,127,0,0,0,0,3,244,0,0,0,127,0,0,0,0,3,244,0,0,0,127,0,0,0,0,3,244,0,0,0,127,0,0,0,0,2,240,0,0,0,127,0,0,0,
  // 0x91cd  重
  205,145,36,37,77,40,2,253,0,0,0,0,0,0,21,180,0,0,0,0,85,170,255,255,252,0,1,255,255,255,255,255,255,254,0,0,255,255,255,255,255,250,80,0,0,255,255,255,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,106,170,170,255,170,170,169,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,85,85,255,85,85,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,254,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,170,170,255,170,170,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x91cf  量
  207,145,36,36,68,40,2,253,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,192,0,0,0,3,252,0,0,63,128,0,0,0,3,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,3,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,255,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,255,0,0,255,0,0,191,0,0,254,0,0,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,1,170,170,170,255,170,170,170,64,2,255,255,255,255,255,255,255,128,2,255,255,255,255,255,255,255,128,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x91dd  針
  221,145,38,38,124,40,1,252,0,0,254,0,0,0,5,80,0,0,0,2,255,192,0,0,15,224,0,0,0,3,255,240,0,0,15,224,0,0,0,11,255,252,0,0,15,224,0,0,0,15,243,255,0,0,15,224,0,0,0,63,208,255,192,0,15,224,0,0,0,191,128,63,240,0,15,224,0,0,1,255,0,15,252,0,15,224,0,0,3,252,0,3,252,0,15,224,0,0,15,244,0,1,240,0,15,224,0,0,127,240,0,0,128,0,15,224,0,0,191,255,255,255,0,0,15,224,0,0,47,255,255,255,0,0,15,224,0,0,8,255,255,255,10,170,175,250,170,144,0,0,254,0,15,255,255,255,255,208,0,0,254,0,15,255,255,255,255,208,0,0,254,0,15,255,255,255,255,208,5,85,255,85,80,0,15,224,0,0,31,255,255,255,240,0,15,224,0,0,31,255,255,255,240,0,15,224,0,0,31,255,255,255,240,0,15,224,0,0,0,0,254,0,0,0,15,224,0,0,0,0,254,1,0,0,15,224,0,0,7,192,254,11,224,0,15,224,0,0,7,208,254,15,208,0,15,224,0,0,3,224,254,15,192,0,15,224,0,0,3,240,254,31,128,0,15,224,0,0,2,240,254,47,64,0,15,224,0,0,1,244,254,63,0,0,15,224,0,0,1,248,254,46,0,0,15,224,0,0,0,144,254,0,16,0,15,224,0,0,0,0,255,111,244,0,15,224,0,0,0,22,255,255,244,0,15,224,0,0,47,255,255,255,244,0,15,224,0,0,63,255,255,250,64,0,15,224,0,0,47,255,164,0,0,0,15,224,0,0,30,80,0,0,0,0,15,224,0,0,0,0,0,0,0,0,10,160,0,0,
  // 0x9215  鈕
  21,146,38,37,114,40,1,253,0,3,248,0,0,0,0,0,0,0,0,11,254,0,0,0,0,0,0,0,0,15,255,128,10,170,170,170,160,0,0,47,255,240,15,255,255,255,244,0,0,63,207,252,15,255,255,255,244,0,0,255,3,254,15,255,255,255,244,0,2,254,0,255,128,11,240,7,244,0,7,252,0,127,192,15,240,7,244,0,31,240,0,31,128,15,224,7,244,0,127,208,0,10,0,15,224,7,240,0,191,255,255,252,0,15,224,7,240,0,47,255,255,252,0,15,208,7,240,0,7,255,255,252,0,15,208,7,240,0,0,3,248,0,0,15,208,7,240,0,0,3,244,0,0,31,192,7,240,0,0,3,244,0,0,31,192,7,240,0,0,3,244,0,0,31,192,11,240,0,47,255,255,255,63,255,255,255,255,208,47,255,255,255,63,255,255,255,255,208,47,255,255,255,63,255,255,255,255,208,0,3,248,0,42,191,234,175,250,144,0,3,244,0,0,63,128,11,240,0,1,67,244,61,0,63,128,15,240,0,15,131,244,62,0,63,64,15,240,0,11,195,244,125,0,63,64,15,224,0,7,211,244,188,0,127,0,15,224,0,3,227,244,252,0,127,0,15,224,0,3,227,244,248,0,191,0,15,224,0,3,243,245,240,0,191,0,15,224,0,2,243,244,176,0,191,0,15,208,0,0,3,244,1,64,254,0,15,208,0,0,3,250,191,128,254,0,31,208,0,0,91,255,255,128,253,0,31,208,0,63,255,255,255,255,255,255,255,255,208,63,255,255,147,255,255,255,255,255,208,47,254,64,3,255,255,255,255,255,208,25,0,0,1,170,170,170,170,170,144,
  // 0x932f  錯
  47,147,38,38,124,40,1,252,0,3,248,0,0,63,64,63,64,0,0,11,254,0,0,63,64,63,64,0,0,15,255,128,0,63,64,63,64,0,0,47,255,240,0,63,64,63,64,0,0,63,143,252,0,63,64,63,64,0,0,255,3,254,47,255,255,255,255,64,2,254,0,255,175,255,255,255,255,64,7,252,0,127,255,255,255,255,255,64,31,240,0,31,128,63,64,63,64,0,127,208,0,10,0,63,64,63,64,0,191,255,255,252,0,63,64,63,64,0,47,255,255,252,0,63,64,63,64,0,7,255,255,252,0,63,64,63,64,0,0,3,248,0,85,127,149,127,149,64,0,3,244,0,255,255,255,255,255,208,0,3,244,0,255,255,255,255,255,208,0,3,244,0,255,255,255,255,255,208,47,255,255,255,0,0,0,0,0,0,47,255,255,255,0,0,0,0,0,0,47,255,255,255,0,0,0,0,0,0,0,3,248,0,3,255,255,255,252,0,0,3,244,0,3,255,255,255,252,0,1,67,244,57,3,255,255,255,252,0,15,131,244,63,3,244,0,1,252,0,11,195,244,125,3,244,0,1,252,0,7,211,244,188,3,244,0,1,252,0,3,227,244,252,3,255,255,255,252,0,3,227,244,248,3,255,255,255,252,0,3,243,245,240,3,255,255,255,252,0,2,243,244,176,3,244,0,1,252,0,0,3,244,1,67,244,0,1,252,0,0,3,254,255,131,244,0,1,252,0,0,111,255,255,131,244,0,1,252,0,63,255,255,255,131,255,255,255,252,0,63,255,255,144,3,255,255,255,252,0,47,254,64,0,3,255,255,255,252,0,25,0,0,0,3,244,0,1,252,0,0,0,0,0,2,160,0,1,168,0,
  // 0x9375  鍵
  117,147,38,38,124,40,1,252,0,7,224,0,0,0,2,240,0,0,0,15,248,0,0,0,3,244,0,0,0,31,254,0,0,0,3,244,0,0,0,63,255,75,255,226,255,255,254,0,0,191,127,203,255,226,255,255,254,0,0,254,15,255,255,194,255,255,254,0,3,252,7,253,95,192,3,244,62,0,11,244,2,252,31,128,3,244,62,0,31,224,0,240,47,64,3,244,63,64,127,192,0,64,63,31,255,255,255,224,255,255,255,208,126,31,255,255,255,224,63,255,255,208,189,31,255,255,255,224,11,255,255,208,252,0,3,244,62,0,0,11,208,1,252,0,3,244,62,0,0,11,208,2,248,1,255,255,254,0,0,11,208,3,255,250,255,255,254,0,0,11,208,7,255,246,255,255,254,0,63,255,255,251,255,244,3,244,0,0,63,255,255,246,194,244,3,244,0,0,63,255,255,240,2,240,3,244,0,0,0,15,208,0,67,243,255,255,255,0,0,11,208,7,195,243,255,255,255,0,6,11,211,231,211,227,255,255,255,0,15,11,211,227,215,224,3,244,0,0,15,75,211,211,251,208,3,244,0,0,15,139,215,194,255,192,3,244,0,0,11,203,215,193,255,207,255,255,255,192,7,203,219,128,255,79,255,255,255,192,7,203,223,64,191,15,255,255,255,192,3,203,209,0,127,0,3,244,0,0,1,11,208,0,255,128,3,244,0,0,0,11,235,246,255,208,3,244,0,0,0,31,255,251,255,248,2,240,0,0,47,255,255,255,243,255,144,0,0,0,63,255,254,191,192,255,255,255,255,224,63,254,65,255,64,47,255,255,255,192,25,0,0,189,0,1,191,255,255,192,0,0,0,32,0,0,0,0,0,0,
  // 0x9577  長
  119,149,36,36,68,40,2,252,0,3,255,255,255,255,255,255,0,0,3,255,255,255,255,255,255,0,0,3,255,255,255,255,255,255,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,255,255,255,255,255,248,0,0,3,255,255,255,255,255,248,0,0,3,255,255,255,255,255,248,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,255,255,255,255,255,248,0,0,3,255,255,255,255,255,248,0,0,3,255,255,255,255,255,248,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,85,87,253,85,85,85,85,85,84,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,3,252,0,191,0,0,7,0,0,3,252,0,63,128,0,47,208,0,3,252,0,47,208,1,255,224,0,3,252,0,15,240,11,255,64,0,3,252,0,11,252,127,248,0,0,3,252,0,3,255,255,192,0,0,3,252,0,0,255,253,0,0,0,3,252,0,0,63,248,0,0,0,3,252,0,22,95,255,64,0,0,3,253,175,255,131,255,244,0,0,91,255,255,255,128,191,255,144,15,255,255,255,255,64,31,255,255,11,255,255,249,64,0,2,255,254,7,255,148,0,0,0,0,31,252,1,64,0,0,0,0,0,0,100,
  // 0x9589  閉
  137,149,34,36,68,40,3,252,127,255,255,253,7,255,255,255,224,127,255,255,253,7,255,255,255,224,127,255,255,253,7,255,255,255,224,127,64,0,253,7,240,0,15,224,127,64,0,253,7,240,0,15,224,127,170,170,253,7,250,170,175,224,127,255,255,253,7,255,255,255,224,127,255,255,253,7,255,255,255,224,127,64,0,253,7,240,0,15,224,127,64,0,253,7,240,0,15,224,127,64,0,253,7,240,0,15,224,127,234,171,253,7,254,170,191,224,127,255,255,253,7,255,255,255,224,127,255,255,253,7,255,255,255,224,127,64,0,0,0,0,0,15,224,127,64,0,0,15,208,0,15,224,127,64,0,0,15,208,0,15,224,127,64,0,0,15,208,0,15,224,127,67,255,255,255,255,252,15,224,127,67,255,255,255,255,252,15,224,127,67,255,255,255,255,252,15,224,127,64,0,0,255,208,0,15,224,127,64,0,3,255,208,0,15,224,127,64,0,11,255,208,0,15,224,127,64,0,47,239,208,0,15,224,127,64,0,255,143,208,0,15,224,127,64,3,254,15,208,0,15,224,127,64,31,248,15,208,0,15,224,127,64,255,224,15,208,0,15,224,127,75,255,128,15,208,0,15,224,127,71,253,0,15,208,0,15,224,127,66,224,0,15,208,0,31,224,127,64,64,15,255,195,255,255,208,127,64,0,11,255,193,255,255,192,127,64,0,7,254,0,255,255,128,127,0,0,0,0,0,170,164,0,
  // 0x958b  開
  139,149,34,36,68,40,3,252,127,255,255,253,11,255,255,255,224,127,255,255,253,11,255,255,255,224,127,255,255,253,11,255,255,255,224,127,0,0,253,11,240,0,15,224,127,0,0,253,11,240,0,15,224,127,170,170,253,11,250,170,175,224,127,255,255,253,11,255,255,255,224,127,255,255,253,11,255,255,255,224,127,0,0,253,11,240,0,15,224,127,0,0,253,11,240,0,15,224,127,0,0,253,11,240,0,15,224,127,255,255,253,11,255,255,255,224,127,255,255,253,11,255,255,255,224,127,234,170,169,6,170,170,175,224,127,0,0,0,0,0,0,15,224,127,0,0,0,0,0,0,15,224,127,2,255,255,255,255,248,15,224,127,2,255,255,255,255,248,15,224,127,2,255,255,255,255,248,15,224,127,0,3,244,3,248,0,15,224,127,0,3,244,3,248,0,15,224,127,0,3,244,3,248,0,15,224,127,0,3,244,3,248,0,15,224,127,7,255,255,255,255,253,15,224,127,7,255,255,255,255,253,15,224,127,7,255,255,255,255,253,15,224,127,0,3,244,3,248,0,15,224,127,0,3,240,3,248,0,15,224,127,0,11,240,3,248,0,15,224,127,0,15,224,3,248,0,15,224,127,0,47,192,3,248,0,15,224,127,0,63,128,3,248,0,15,224,127,1,255,0,3,248,127,255,224,127,3,253,0,3,248,63,255,208,127,0,244,0,3,248,47,255,128,127,0,16,0,0,0,26,164,0,
  // 0x9593  間
  147,149,34,36,68,40,3,252,127,255,255,253,7,255,255,255,224,127,255,255,253,7,255,255,255,224,127,255,255,253,7,255,255,255,224,127,64,0,253,7,240,0,15,224,127,64,0,253,7,240,0,15,224,127,170,170,253,7,250,170,175,224,127,255,255,253,7,255,255,255,224,127,255,255,253,7,255,255,255,224,127,64,0,253,7,240,0,15,224,127,64,0,253,7,240,0,15,224,127,64,0,253,7,240,0,15,224,127,234,171,253,7,254,170,191,224,127,255,255,253,7,255,255,255,224,127,255,255,253,7,255,255,255,224,127,64,0,0,0,0,0,15,224,127,64,0,0,0,0,0,15,224,127,64,0,0,0,0,0,15,224,127,64,47,255,255,255,64,15,224,127,64,47,255,255,255,64,15,224,127,64,47,255,255,255,64,15,224,127,64,47,192,0,63,64,15,224,127,64,47,192,0,63,64,15,224,127,64,47,192,0,63,64,15,224,127,64,47,255,255,255,64,15,224,127,64,47,255,255,255,64,15,224,127,64,47,234,170,191,64,15,224,127,64,47,192,0,63,64,15,224,127,64,47,192,0,63,64,15,224,127,64,47,192,0,63,64,15,224,127,64,47,255,255,255,64,15,224,127,64,47,255,255,255,64,15,224,127,64,47,255,255,255,64,31,224,127,64,47,192,0,0,255,255,224,127,64,47,192,0,0,255,255,192,127,64,0,0,0,0,191,255,128,127,0,0,0,0,0,42,164,0,
  // 0x95dc  關
  220,149,34,36,68,40,3,252,127,255,255,253,7,255,255,255,224,127,255,255,253,7,255,255,255,224,127,170,170,253,7,250,170,175,224,127,0,0,253,7,240,0,15,224,127,0,0,253,7,240,0,15,224,127,255,255,253,7,255,255,255,224,127,255,255,253,7,255,255,255,224,127,85,85,253,7,245,85,95,224,127,0,0,253,7,240,0,15,224,127,0,0,253,7,240,0,15,224,127,255,255,253,7,255,255,255,224,127,255,255,253,7,255,255,255,224,127,170,171,232,6,254,170,175,224,127,0,11,192,0,252,0,15,224,127,0,31,0,2,240,0,15,224,127,3,253,29,127,194,128,15,224,127,3,248,125,127,71,208,15,224,127,0,188,248,15,223,64,15,224,127,0,47,224,3,254,0,15,224,127,0,15,157,1,248,240,15,224,127,0,62,31,7,224,248,15,224,127,15,255,255,191,255,252,15,224,127,11,255,255,255,255,254,15,224,127,1,84,3,64,0,30,15,224,127,1,160,62,15,128,164,15,224,127,1,240,62,15,128,244,15,224,127,1,240,62,15,128,244,15,224,127,1,240,62,15,128,244,15,224,127,1,255,254,15,255,244,15,224,127,1,255,254,15,255,244,15,224,127,0,0,253,15,128,0,15,224,127,0,2,252,15,128,0,15,224,127,0,31,244,15,128,15,255,224,127,0,127,208,15,128,15,255,208,127,0,47,0,15,128,11,255,128,127,0,0,0,0,0,2,164,0,
  // 0x964d  降
  77,150,36,38,86,40,3,252,0,0,0,0,0,148,0,0,0,0,0,0,0,1,254,0,0,0,191,255,248,0,3,252,0,0,0,191,255,255,0,7,248,0,0,0,191,255,254,0,15,255,255,254,0,190,86,253,0,63,255,255,255,64,190,1,252,0,255,255,255,255,0,190,3,248,3,255,64,1,253,0,190,3,244,15,255,192,3,252,0,190,7,240,127,255,240,15,244,0,190,11,224,255,135,248,63,208,0,190,15,208,61,1,255,255,128,0,190,31,192,4,0,191,254,0,0,190,47,128,0,0,63,252,0,0,190,63,64,0,1,255,255,128,0,190,31,192,0,31,255,255,248,0,190,11,240,6,255,248,47,255,228,190,3,244,191,255,192,7,255,253,190,2,252,191,253,0,254,111,248,190,0,252,63,128,0,254,1,176,190,0,253,20,0,0,254,0,0,190,0,253,31,255,255,255,255,224,190,0,254,31,255,255,255,255,224,190,0,253,31,255,255,255,255,224,190,1,253,0,254,0,254,0,0,190,191,252,0,254,0,254,0,0,190,63,248,0,254,0,254,0,0,190,63,208,0,254,0,254,0,0,190,0,0,0,254,0,254,0,0,190,0,1,255,255,255,255,255,252,190,0,1,255,255,255,255,255,252,190,0,1,255,255,255,255,255,252,190,0,0,0,0,0,254,0,0,190,0,0,0,0,0,254,0,0,190,0,0,0,0,0,254,0,0,190,0,0,0,0,0,254,0,0,190,0,0,0,0,0,254,0,0,189,0,0,0,0,0,254,0,0,
  // 0x9664  除
  100,150,36,38,86,40,3,252,0,0,0,0,0,42,64,0,0,0,0,0,0,0,191,208,0,0,191,255,248,0,1,255,240,0,0,191,255,255,0,3,255,252,0,0,191,255,254,0,15,246,254,0,0,190,86,253,0,47,224,255,128,0,190,1,252,0,191,192,63,224,0,190,3,248,2,255,0,15,248,0,190,3,244,11,252,0,7,255,0,190,7,240,47,240,0,0,255,208,190,11,225,255,192,0,0,63,248,190,15,219,255,0,0,0,15,254,190,31,195,255,255,255,255,255,252,190,47,129,226,255,255,255,248,116,190,63,128,66,255,255,255,248,0,190,31,192,0,0,63,128,0,0,190,11,240,0,0,63,128,0,0,190,3,244,0,0,63,128,0,0,190,2,252,0,0,63,128,0,0,190,0,252,0,0,63,192,0,0,190,0,253,63,255,255,255,255,224,190,0,253,63,255,255,255,255,224,190,0,254,63,255,255,255,255,224,190,0,253,0,0,63,128,0,0,190,1,253,0,0,63,128,0,0,190,191,252,7,224,63,129,244,0,190,63,248,15,240,63,130,252,0,190,63,208,15,208,63,128,255,0,190,0,0,63,192,63,128,127,64,190,0,0,127,64,63,128,63,192,190,0,0,255,0,63,128,31,224,190,0,2,253,0,63,128,11,240,190,0,7,252,0,63,128,3,248,190,0,15,240,0,63,128,3,252,190,0,3,208,21,127,128,1,224,190,0,0,64,63,255,128,0,0,190,0,0,0,31,255,0,0,0,190,0,0,0,15,248,0,0,0,
  // 0x968e  階
  142,150,36,38,86,40,3,252,0,0,0,21,0,0,84,0,0,0,0,0,47,128,0,252,0,0,191,255,244,47,128,0,252,0,0,191,255,254,47,128,0,252,1,128,191,255,253,47,128,0,252,11,240,190,86,252,47,255,244,252,191,248,190,2,252,47,255,244,255,255,128,190,3,244,47,255,244,255,248,0,190,3,240,47,128,0,255,128,0,190,7,240,47,128,0,252,0,0,190,15,208,47,128,0,252,0,0,190,15,192,47,128,0,252,0,120,190,31,128,47,128,84,252,0,189,190,47,64,47,239,248,253,0,253,190,63,66,191,255,252,255,255,252,190,31,195,255,255,144,255,255,248,190,11,242,255,144,105,47,255,224,190,3,241,144,0,191,64,0,0,190,2,248,0,0,255,0,0,0,190,1,252,0,0,254,0,0,0,190,0,252,15,255,255,255,255,208,190,0,252,15,255,255,255,255,208,190,0,253,15,255,255,255,255,208,190,0,253,15,208,0,0,31,208,190,2,252,15,208,0,0,15,208,190,191,252,15,208,0,0,15,208,190,63,244,15,208,0,0,15,208,190,63,208,15,255,255,255,255,208,190,0,0,15,255,255,255,255,208,190,0,0,15,255,255,255,255,208,190,0,0,15,208,0,0,15,208,190,0,0,15,208,0,0,15,208,190,0,0,15,208,0,0,15,208,190,0,0,15,255,255,255,255,208,190,0,0,15,255,255,255,255,208,190,0,0,15,255,255,255,255,208,190,0,0,15,208,0,0,31,208,189,0,0,10,128,0,0,5,64,
  // 0x96d9  雙
  217,150,36,38,86,40,2,252,0,36,0,0,0,9,0,0,0,0,127,3,224,0,31,192,248,0,0,190,7,240,0,47,130,248,0,0,252,15,192,0,63,3,240,0,2,253,111,213,80,191,91,229,84,3,255,255,255,224,255,255,255,252,15,255,255,255,227,255,255,255,252,47,244,47,64,11,253,7,208,0,127,244,47,64,31,253,7,208,0,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,244,119,245,111,149,61,253,91,229,80,19,244,47,64,8,253,7,208,0,3,249,111,149,64,254,91,229,80,3,255,255,255,192,255,255,255,244,3,255,255,255,192,255,255,255,244,3,244,47,64,0,253,7,208,0,3,244,47,64,0,253,7,208,0,3,255,255,255,240,255,255,255,254,3,255,255,255,240,255,255,255,254,1,85,85,85,80,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,255,244,0,15,255,255,255,255,255,255,254,0,15,255,255,255,255,255,255,252,0,0,0,190,0,0,0,63,240,0,0,1,255,192,0,1,255,192,0,0,0,127,244,0,11,255,0,0,0,0,31,255,64,191,252,0,0,0,0,3,255,251,255,224,0,0,0,0,0,127,255,255,0,0,0,0,0,1,191,255,254,144,0,0,0,5,191,255,255,255,255,148,0,175,255,255,255,219,255,255,255,254,127,255,255,228,0,27,255,255,252,63,255,228,0,0,0,111,255,248,42,80,0,0,0,0,0,22,240,
  // 0x96e2  離
  226,150,38,38,124,40,1,252,0,0,106,0,0,0,144,0,0,0,0,0,127,0,0,0,254,3,244,0,0,0,127,0,0,1,252,3,244,0,0,0,127,0,0,2,252,7,240,0,127,255,255,255,255,3,248,15,224,0,127,255,255,255,255,7,240,15,208,0,127,255,255,255,255,11,240,31,192,0,0,0,0,0,0,15,224,63,128,0,7,192,2,241,240,31,255,255,255,192,7,195,67,225,244,63,255,255,255,192,7,203,255,193,244,127,255,255,255,192,7,193,255,129,244,255,213,127,149,64,7,192,127,209,245,255,192,63,64,0,7,193,255,245,247,255,192,63,64,0,7,219,240,249,255,255,192,63,64,0,7,219,192,33,255,255,192,63,64,0,7,193,0,1,251,239,255,255,255,128,7,255,255,255,244,143,255,255,255,128,7,255,255,255,244,15,255,255,255,128,6,170,191,170,160,15,208,63,64,0,0,0,126,0,0,15,192,63,64,0,0,0,189,0,0,15,192,63,64,0,31,255,255,255,253,15,192,63,64,0,31,255,255,255,253,15,192,63,64,0,31,255,255,255,253,15,255,255,255,128,31,128,248,0,253,15,255,255,255,128,31,129,244,160,253,15,255,255,255,128,31,130,240,240,253,15,208,63,64,0,31,130,240,184,253,15,192,63,64,0,31,155,255,252,253,15,192,63,64,0,31,175,255,253,253,15,192,63,64,0,31,159,165,110,253,15,192,63,64,0,31,128,0,29,253,15,213,127,149,64,31,128,0,0,253,15,255,255,255,208,31,128,0,0,253,15,255,255,255,208,31,128,0,255,252,15,255,255,255,208,31,128,0,127,252,15,192,0,0,0,31,128,0,63,144,15,192,0,0,0,
  // 0x96fb  電
  251,150,36,36,68,40,3,252,11,255,255,255,255,255,255,253,0,11,255,255,255,255,255,255,253,0,11,255,255,255,255,255,255,253,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,254,170,170,171,254,170,170,171,240,253,0,0,3,248,0,0,7,240,253,63,255,211,248,127,255,135,240,253,63,255,211,248,127,255,135,240,253,0,0,3,248,0,0,7,240,253,0,0,3,248,0,0,7,240,0,191,255,211,248,127,255,224,0,0,191,255,211,248,127,255,224,0,0,0,0,3,248,0,0,0,0,0,0,0,0,0,0,0,0,0,1,170,170,170,170,170,170,164,0,2,255,255,255,255,255,255,248,0,2,255,255,255,255,255,255,248,0,2,252,0,3,244,0,3,248,0,2,252,0,3,244,0,3,248,0,2,253,85,87,249,85,87,248,0,2,255,255,255,255,255,255,248,0,2,255,255,255,255,255,255,248,0,2,252,0,3,244,0,3,248,0,2,252,0,3,244,0,3,248,0,2,254,170,171,254,170,171,248,0,2,255,255,255,255,255,255,248,144,2,255,255,255,255,255,255,248,253,2,252,0,3,244,0,0,0,253,2,252,0,3,244,0,0,0,252,0,84,0,3,252,0,0,2,252,0,0,0,2,255,255,255,255,248,0,0,0,0,255,255,255,255,240,0,0,0,0,43,255,255,255,128,
  // 0x9752  青
  82,151,36,39,95,40,2,251,0,0,0,0,170,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,191,255,255,255,255,255,254,0,0,191,255,255,255,255,255,254,0,0,106,170,170,255,170,170,170,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,224,0,0,0,7,244,0,0,15,224,0,0,0,7,244,0,0,15,250,170,170,170,171,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,224,0,0,0,7,244,0,0,15,224,0,0,0,7,244,0,0,15,224,0,0,0,7,244,0,0,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,15,250,170,170,170,171,244,0,0,15,224,0,0,0,7,244,0,0,15,224,0,0,0,7,244,0,0,15,224,0,0,0,11,244,0,0,15,224,0,0,127,255,244,0,0,15,224,0,0,63,255,240,0,0,15,224,0,0,47,254,64,0,0,0,0,0,0,0,0,0,0,
  // 0x975e  非
  94,151,38,39,134,40,1,251,0,0,0,170,0,10,144,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,15,255,255,255,0,31,255,255,255,128,15,255,255,255,0,31,255,255,255,128,15,255,255,255,0,31,255,255,255,128,5,85,85,255,0,31,229,85,85,64,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,7,255,255,255,0,31,255,255,254,0,7,255,255,255,0,31,255,255,254,0,7,255,255,255,0,31,255,255,254,0,1,85,85,255,0,31,229,85,85,0,0,0,0,255,0,31,208,0,0,0,0,0,0,255,0,31,208,0,0,0,0,0,0,254,0,31,208,0,0,0,0,0,0,254,84,31,208,0,0,0,0,0,6,255,252,31,208,0,0,0,0,107,255,255,252,31,229,85,85,64,127,255,255,255,252,31,255,255,255,208,63,255,255,253,0,31,255,255,255,208,63,255,159,244,0,31,255,255,255,208,41,64,31,240,0,31,208,0,0,0,0,0,63,208,0,31,208,0,0,0,0,0,191,192,0,31,208,0,0,0,0,2,255,0,0,31,208,0,0,0,0,11,254,0,0,31,208,0,0,0,0,63,248,0,0,31,208,0,0,0,2,255,224,0,0,31,208,0,0,0,15,255,128,0,0,31,208,0,0,0,3,253,0,0,0,31,208,0,0,0,0,224,0,0,0,15,208,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9762  面
  98,151,36,35,59,40,2,252,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,106,170,170,171,255,170,170,170,169,0,0,0,3,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,244,0,0,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,245,91,245,85,111,213,95,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,255,255,255,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,224,7,240,0,47,192,15,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,245,85,85,85,85,85,95,240,15,224,0,0,0,0,0,15,240,10,160,0,0,0,0,0,10,160,
  // 0x9805  項
  5,152,38,36,104,40,1,252,0,0,0,3,255,255,255,255,255,208,0,0,0,3,255,255,255,255,255,208,21,85,85,87,255,255,255,255,255,208,63,255,255,248,0,0,255,0,0,0,63,255,255,248,0,1,255,0,0,0,63,255,255,248,0,1,253,0,0,0,21,95,245,84,0,2,252,0,0,0,0,15,240,0,63,255,255,255,255,0,0,15,240,0,63,255,255,255,255,0,0,15,240,0,63,255,255,255,255,0,0,15,240,0,63,64,0,0,191,0,0,15,240,0,63,64,0,0,191,0,0,15,240,0,63,64,0,0,191,0,0,15,240,0,63,255,255,255,255,0,0,15,240,0,63,255,255,255,255,0,0,15,240,0,63,170,170,170,255,0,0,15,240,0,63,64,0,0,191,0,0,15,240,0,63,64,0,0,191,0,0,15,240,0,63,64,0,0,191,0,0,15,240,0,63,255,255,255,255,0,0,15,240,45,63,255,255,255,255,0,0,15,251,253,63,170,170,170,255,0,0,15,255,254,63,64,0,0,191,0,1,191,255,249,63,64,0,0,191,0,111,255,255,64,63,64,0,0,191,0,127,255,224,0,63,255,255,255,255,0,63,249,0,0,63,255,255,255,255,0,46,64,0,0,63,255,255,255,255,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,1,248,0,62,0,0,0,0,0,0,31,255,1,255,224,0,0,0,0,1,255,248,0,127,253,0,0,0,0,31,255,208,0,11,255,128,0,0,0,255,253,0,0,0,255,240,0,0,0,63,208,0,0,0,47,192,0,0,0,25,0,0,0,0,6,0,
  // 0x9810  預
  16,152,38,36,104,40,1,252,47,255,255,253,63,255,255,255,255,192,47,255,255,255,191,255,255,255,255,192,47,255,255,255,127,255,255,255,255,192,0,0,7,253,0,0,127,192,0,0,0,0,7,248,0,0,127,128,0,0,0,128,15,240,0,0,127,64,0,0,2,244,63,192,0,0,191,0,0,0,7,255,255,64,11,255,255,255,254,0,2,255,253,0,11,255,255,255,254,0,0,47,252,0,11,255,255,255,254,0,0,7,255,64,11,240,0,0,254,0,0,0,255,208,11,240,0,0,254,0,0,0,47,192,11,240,0,0,254,0,127,255,255,255,235,255,255,255,254,0,127,255,255,255,235,255,255,255,254,0,127,255,255,255,203,250,170,170,254,0,21,87,249,111,203,240,0,0,254,0,0,3,244,47,139,240,0,0,254,0,0,3,244,63,75,240,0,0,254,0,0,3,244,63,11,255,255,255,254,0,0,3,244,190,11,255,255,255,254,0,0,3,244,252,11,250,170,170,254,0,0,3,244,24,11,240,0,0,254,0,0,3,244,0,11,240,0,0,254,0,0,3,244,0,11,240,0,0,254,0,0,3,244,0,11,255,255,255,254,0,0,3,244,0,11,255,255,255,254,0,0,3,244,0,11,255,255,255,254,0,0,3,244,0,0,8,0,0,0,0,0,3,244,0,0,127,64,31,64,0,0,3,244,0,2,255,192,127,240,0,0,7,244,0,31,255,0,31,253,0,15,255,244,1,255,248,0,3,255,128,11,255,240,11,255,192,0,0,191,224,7,255,208,3,253,0,0,0,31,128,2,149,0,0,144,0,0,0,5,0,
  // 0x984d  額
  77,152,38,38,124,40,1,252,0,0,168,0,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,0,253,0,11,255,255,255,255,128,0,0,253,0,11,255,255,255,255,128,63,255,255,255,251,255,255,255,255,128,63,255,255,255,240,0,47,208,0,0,63,255,255,255,240,0,63,192,0,0,63,65,64,3,240,0,63,128,0,0,63,67,244,3,240,0,63,64,0,0,63,75,240,3,241,255,255,255,255,0,0,31,250,169,1,255,255,255,255,0,0,63,255,255,65,255,255,255,255,0,0,191,255,255,1,252,0,0,191,0,2,253,0,254,1,252,0,0,191,0,11,253,1,252,1,252,0,0,191,0,63,255,131,248,1,255,255,255,255,0,127,255,255,240,1,255,255,255,255,0,30,15,255,208,1,254,170,170,255,0,0,2,255,192,1,252,0,0,191,0,0,2,255,240,1,252,0,0,191,0,0,15,255,253,1,252,0,0,191,0,0,127,226,255,129,255,255,255,255,0,7,255,64,127,241,255,255,255,255,0,127,253,0,15,241,254,170,170,255,0,127,255,255,255,193,252,0,0,191,0,47,255,255,254,1,252,0,0,191,0,6,255,255,254,1,252,0,0,191,0,2,248,0,190,1,255,255,255,255,0,2,248,0,190,1,255,255,255,255,0,2,248,0,190,1,255,255,255,254,0,2,248,0,190,0,5,0,1,0,0,2,248,0,190,0,31,192,31,128,0,2,255,255,254,0,191,224,63,244,0,2,255,255,254,7,255,128,11,254,0,2,255,255,254,191,253,0,1,255,128,2,248,0,1,255,224,0,0,127,224,2,248,0,0,127,0,0,0,15,128,0,0,0,0,20,0,0,0,1,0,
  // 0x985e  類
  94,152,38,38,124,40,1,252,0,0,84,0,0,0,0,0,0,0,2,64,252,10,64,0,0,0,0,0,15,192,252,15,223,255,255,255,255,192,11,224,252,31,207,255,255,255,255,192,3,240,252,63,79,255,255,255,255,192,2,244,252,62,0,0,47,208,0,0,0,64,252,4,0,0,63,192,0,0,63,255,255,255,240,0,63,128,0,0,63,255,255,255,241,255,255,255,254,0,63,255,255,255,242,255,255,255,255,0,0,11,253,0,2,255,255,255,255,0,0,31,255,192,2,252,0,0,191,0,0,63,255,244,2,252,0,0,191,0,0,255,255,254,2,252,0,0,191,0,3,253,252,255,194,252,0,0,191,0,15,244,252,47,242,255,255,255,255,0,127,224,252,7,210,255,255,255,255,0,47,64,252,1,130,254,170,170,255,0,13,0,252,0,2,252,0,0,191,0,0,0,84,0,2,252,0,0,191,0,0,0,252,0,2,252,0,0,191,0,0,0,252,0,2,255,255,255,255,0,0,1,253,0,2,255,255,255,255,0,63,255,255,255,242,254,170,170,255,0,63,255,255,255,242,252,0,0,191,0,63,255,255,255,242,252,0,0,191,0,0,2,252,0,2,252,0,0,191,0,0,3,252,0,2,255,255,255,255,0,0,3,255,128,2,255,255,255,255,0,0,11,255,240,1,255,255,255,254,0,0,31,255,253,0,1,0,1,0,0,0,63,211,255,128,31,192,31,128,0,1,255,128,191,224,191,224,63,240,0,15,254,0,31,199,255,128,15,253,0,127,248,0,7,111,253,0,2,255,128,47,208,0,1,255,240,0,0,127,224,14,0,0,0,127,64,0,0,31,192,0,0,0,0,24,0,0,0,2,0,
  // 0x98a8  風
  168,152,38,36,104,40,1,252,0,63,255,255,255,255,255,255,192,0,0,63,255,255,255,255,255,255,192,0,0,63,255,255,255,255,255,255,192,0,0,63,149,85,85,85,85,127,192,0,0,63,128,0,0,0,0,63,192,0,0,63,128,0,0,91,240,63,192,0,0,63,128,90,191,255,252,63,192,0,0,63,159,255,255,255,253,63,192,0,0,63,143,255,255,233,64,63,192,0,0,63,138,165,127,0,0,63,192,0,0,63,128,0,63,0,0,63,192,0,0,63,128,0,63,0,0,63,192,0,0,63,139,255,255,255,252,63,192,0,0,63,139,255,255,255,252,63,192,0,0,63,75,255,255,255,252,47,192,0,0,63,75,208,63,0,252,47,192,0,0,63,75,208,63,0,252,47,192,0,0,63,75,208,63,0,252,47,192,0,0,63,75,208,63,0,252,47,192,0,0,127,75,208,63,0,252,47,192,0,0,127,11,208,63,0,252,47,192,0,0,127,11,255,255,255,252,47,192,0,0,191,11,255,255,255,252,31,192,0,0,191,11,255,255,255,252,31,192,0,0,254,0,0,63,0,16,31,192,0,0,254,0,0,63,3,240,15,192,0,1,253,0,0,63,3,248,15,209,0,2,252,0,0,63,1,252,15,209,192,3,252,0,0,63,0,254,15,225,224,3,248,106,191,255,255,255,11,226,224,11,240,191,255,255,255,255,135,242,224,15,240,191,255,255,255,255,195,247,224,47,208,127,234,149,64,15,211,255,208,127,192,0,0,0,0,11,225,255,192,47,64,0,0,0,0,5,0,255,128,6,0,0,0,0,0,0,0,46,0,
  // 0x98fd  飽
  253,152,38,38,124,40,1,252,0,1,254,0,0,46,64,0,0,0,0,3,255,128,0,63,128,0,0,0,0,11,255,240,0,63,64,0,0,0,0,15,251,252,0,191,0,0,0,0,0,63,194,255,0,254,0,0,0,0,0,191,128,191,193,255,255,255,255,64,1,255,0,47,227,255,255,255,255,64,3,252,127,15,215,255,255,255,255,0,15,244,127,3,143,244,0,0,127,0,63,224,127,1,31,224,0,0,63,0,255,192,127,0,63,192,0,0,63,0,63,255,255,255,255,128,0,0,63,0,15,255,255,255,255,255,255,208,127,0,3,254,170,255,191,255,255,208,127,0,3,248,0,63,73,255,255,208,127,0,3,248,0,63,64,0,15,208,127,0,3,253,85,191,64,0,15,208,127,0,3,255,255,255,64,0,15,208,127,0,3,255,255,255,64,0,15,208,127,0,3,248,0,63,64,0,15,208,191,0,3,248,0,63,67,255,255,208,191,0,3,248,0,63,67,255,255,208,191,0,3,255,255,255,67,255,255,208,254,0,3,255,255,255,67,248,1,81,254,0,3,255,255,255,3,244,0,255,253,0,3,248,0,0,3,244,0,191,252,0,3,248,2,224,3,244,0,127,224,0,3,248,7,244,3,244,0,0,0,0,3,248,3,252,3,244,0,0,0,0,3,248,1,254,3,244,0,0,10,64,3,248,27,255,3,244,0,0,11,224,3,255,255,255,131,244,0,0,15,224,27,255,255,255,195,244,0,0,15,208,63,255,249,15,227,252,0,0,47,192,63,254,64,15,243,255,255,255,255,192,30,64,0,7,65,255,255,255,255,64,0,0,0,0,0,127,255,255,253,0,0,0,0,0,0,0,85,85,64,0,
  // 0x9918  餘
  24,153,38,38,124,40,1,252,0,3,252,0,0,0,127,64,0,0,0,11,255,0,0,0,255,192,0,0,0,15,255,192,0,1,255,224,0,0,0,47,223,240,0,3,255,240,0,0,0,127,131,252,0,11,247,252,0,0,0,255,1,254,0,31,225,254,0,0,3,252,0,191,64,63,192,191,64,0,11,254,170,191,192,255,64,63,208,0,47,255,255,239,67,254,0,15,244,0,255,207,255,217,11,248,0,7,253,0,127,0,0,0,63,240,0,1,255,128,28,0,0,0,255,192,0,0,191,224,3,255,255,254,255,255,255,255,255,192,3,255,255,254,125,255,255,255,239,128,3,250,170,254,52,255,255,255,226,0,3,240,0,190,0,0,63,64,0,0,3,240,0,190,0,0,63,64,0,0,3,255,255,254,0,0,63,64,0,0,3,255,255,254,0,0,63,64,0,0,3,249,85,254,0,0,63,128,0,0,3,240,0,190,63,255,255,255,255,128,3,240,0,190,63,255,255,255,255,128,3,255,255,254,63,255,255,255,255,128,3,255,255,254,0,0,63,64,0,0,3,250,170,169,0,0,63,64,0,0,3,240,0,0,3,244,63,67,240,0,3,240,0,0,3,240,63,67,244,0,3,255,255,254,7,240,63,66,252,0,3,255,255,254,15,208,63,64,253,0,3,255,255,254,31,192,63,64,191,0,3,240,0,0,63,128,63,64,63,64,3,240,0,0,127,0,63,64,63,192,3,255,255,255,254,0,63,64,31,192,3,255,255,255,124,0,63,64,15,192,3,255,255,255,0,0,127,64,9,0,3,240,0,0,0,63,255,0,0,0,3,240,0,0,0,31,255,0,0,0,3,240,0,0,0,15,248,0,0,0,
  // 0x99ac  馬
  172,153,37,37,114,40,1,251,0,31,255,255,255,255,255,255,224,0,0,31,255,255,255,255,255,255,224,0,0,31,255,255,255,255,255,255,224,0,0,31,208,0,47,208,0,0,0,0,0,31,192,0,31,208,0,0,0,0,0,31,192,0,31,208,0,0,0,0,0,31,192,0,31,208,0,0,0,0,0,31,255,255,255,255,255,255,64,0,0,31,255,255,255,255,255,255,64,0,0,31,255,255,255,255,255,255,64,0,0,31,192,0,31,208,0,0,0,0,0,31,192,0,31,208,0,0,0,0,0,31,192,0,31,208,0,0,0,0,0,31,255,255,255,255,255,255,64,0,0,31,255,255,255,255,255,255,64,0,0,31,255,255,255,255,255,255,64,0,0,31,192,0,31,208,0,0,0,0,0,31,192,0,31,208,0,0,0,0,0,31,192,0,31,208,0,0,0,0,0,31,213,85,111,213,85,85,85,0,0,31,255,255,255,255,255,255,255,64,0,31,255,255,255,255,255,255,255,64,0,31,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,191,0,0,16,0,0,0,0,20,0,191,0,0,127,0,80,6,64,252,0,191,0,0,191,7,240,31,128,191,0,255,0,0,254,3,240,15,192,63,128,255,0,1,253,3,244,15,224,31,192,254,0,2,252,3,248,7,240,15,208,254,0,3,248,2,248,3,240,7,65,253,0,11,244,2,252,3,244,0,2,253,0,31,240,1,252,2,244,5,7,252,0,127,208,1,252,0,0,31,255,248,0,47,128,0,64,0,0,15,255,240,0,2,0,0,0,0,0,15,255,128,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9a45  驅
  69,154,38,36,104,40,1,252,11,255,255,255,31,255,255,255,255,128,11,255,255,255,31,255,255,255,255,128,11,255,255,255,31,255,255,255,255,128,11,208,188,0,31,128,0,0,0,0,11,208,188,0,31,128,0,0,0,0,11,208,188,0,31,128,255,255,244,0,11,255,255,252,31,128,255,255,244,0,11,255,255,252,31,128,253,86,244,0,11,255,255,252,31,128,252,2,244,0,11,208,188,0,31,128,252,2,244,0,11,208,188,0,31,128,252,2,244,0,11,208,188,0,31,128,252,2,244,0,11,255,255,252,31,128,255,255,244,0,11,255,255,252,31,128,255,255,244,0,11,255,255,252,31,128,85,85,80,0,11,208,188,0,31,128,0,0,0,0,11,208,188,0,31,128,0,0,0,0,11,208,188,0,31,143,255,79,255,64,11,255,255,255,31,143,255,79,255,64,11,255,255,255,31,143,95,79,95,64,11,255,255,255,31,143,11,79,11,64,0,0,0,63,31,143,11,79,11,64,0,0,0,63,31,143,11,79,11,64,9,1,142,63,31,143,11,79,11,64,15,122,207,63,31,143,11,79,11,64,15,57,215,127,31,143,11,79,11,64,15,60,227,255,31,143,255,79,255,64,31,60,242,255,31,143,255,79,255,64,30,60,176,127,31,133,85,5,85,0,46,60,176,126,31,128,0,0,0,0,61,60,0,126,31,128,0,0,0,0,124,20,0,189,31,255,255,255,255,208,120,0,0,253,31,255,255,255,255,208,0,0,127,252,31,255,255,255,255,208,0,0,63,248,31,128,0,0,0,0,0,0,42,144,26,64,0,0,0,0,
  // 0x9ad4  體
  212,154,37,38,124,40,2,252,0,0,0,0,0,6,129,160,0,0,2,170,170,164,0,11,193,240,0,0,7,255,255,244,0,11,193,240,0,0,7,255,255,244,0,11,193,240,0,0,7,208,1,244,15,255,255,255,252,0,7,208,1,244,15,255,255,255,252,0,7,208,2,244,15,219,230,245,252,0,7,211,255,244,15,131,193,224,252,0,7,211,255,244,15,215,214,245,252,0,7,211,209,244,15,255,255,255,252,0,7,211,209,244,15,255,255,255,252,0,7,211,209,244,15,131,193,224,252,0,7,211,209,244,15,131,193,224,252,0,191,255,255,255,207,215,230,245,252,0,191,255,255,255,207,255,255,255,252,0,190,170,170,175,207,255,255,255,252,0,188,0,0,15,192,0,0,0,0,0,189,0,0,15,192,0,0,0,0,0,191,255,255,255,255,255,255,255,255,0,3,255,255,244,63,255,255,255,255,0,3,250,171,244,42,170,170,170,170,0,3,240,3,244,0,0,0,0,0,0,3,240,3,244,7,255,255,255,244,0,3,255,255,244,7,255,255,255,244,0,3,255,255,244,7,229,85,87,244,0,3,250,171,244,7,224,0,3,244,0,3,240,3,244,7,224,0,3,244,0,3,240,3,244,7,229,85,87,244,0,3,255,255,244,7,255,255,255,244,0,3,255,255,244,7,255,255,255,244,0,3,250,171,244,0,44,0,46,64,0,3,240,3,244,0,126,0,63,0,0,3,240,3,244,0,63,0,126,0,0,3,240,3,244,0,47,64,252,0,0,3,240,3,244,170,191,235,254,170,64,3,240,255,240,255,255,255,255,255,64,3,240,127,240,255,255,255,255,255,64,3,224,62,64,0,0,0,0,0,0,
  // 0x9ad8  高
  216,154,35,38,86,40,2,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,254,0,0,0,0,127,255,255,255,255,255,255,255,252,127,255,255,255,255,255,255,255,252,127,255,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,128,0,0,3,255,255,255,255,255,128,0,0,3,254,170,170,170,191,128,0,0,3,252,0,0,0,63,128,0,0,3,252,0,0,0,63,128,0,0,3,252,0,0,0,63,128,0,0,3,255,255,255,255,255,128,0,0,3,255,255,255,255,255,128,0,0,1,170,170,170,170,170,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,240,0,0,0,0,0,15,240,11,240,0,0,0,0,0,15,240,11,240,6,170,170,170,144,15,240,11,240,11,255,255,255,224,15,240,11,240,11,255,255,255,224,15,240,11,240,11,224,0,15,224,15,240,11,240,11,224,0,15,224,15,240,11,240,11,224,0,15,224,15,240,11,240,11,250,170,175,224,15,240,11,240,11,255,255,255,224,15,240,11,240,11,255,255,255,224,15,240,11,240,11,224,0,0,127,255,240,11,240,11,224,0,0,63,255,208,11,240,0,0,0,0,63,255,128,7,240,0,0,0,0,21,84,0,
  // 0x9ec3  黃
  195,158,36,38,86,40,2,252,0,0,47,192,0,2,252,0,0,0,0,47,192,0,3,252,0,0,0,0,47,192,0,3,252,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,0,0,47,192,0,3,252,0,0,0,0,47,192,0,3,252,0,0,0,0,47,234,170,171,252,0,0,0,0,47,255,255,255,252,0,0,0,0,47,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,127,255,255,255,255,255,254,0,0,127,255,255,255,255,255,254,0,0,127,170,170,255,170,170,254,0,0,127,64,0,254,0,0,254,0,0,127,64,0,254,0,0,254,0,0,127,255,255,255,255,255,254,0,0,127,255,255,255,255,255,254,0,0,127,149,85,255,85,86,254,0,0,127,64,0,254,0,0,254,0,0,127,64,0,254,0,0,254,0,0,127,170,170,255,170,170,254,0,0,127,255,255,255,255,255,254,0,0,127,255,255,255,255,255,254,0,0,0,31,128,0,3,248,0,0,0,1,255,240,0,15,255,208,0,0,111,255,208,0,6,255,255,64,27,255,253,0,0,0,31,255,248,255,255,144,0,0,0,1,191,255,63,244,0,0,0,0,0,11,248,9,0,0,0,0,0,0,0,80,
  // 0x9ede  點
  222,158,38,38,124,40,1,252,0,0,0,0,0,0,26,128,0,0,10,170,170,170,160,0,31,192,0,0,15,255,255,255,240,0,31,192,0,0,15,255,255,255,240,0,31,192,0,0,15,192,60,2,240,0,31,192,0,0,15,196,60,18,240,0,31,192,0,0,15,236,60,63,240,0,31,192,0,0,15,221,60,122,240,0,31,192,0,0,15,206,60,182,240,0,31,192,0,0,15,207,60,242,240,0,31,255,255,208,15,207,125,226,240,0,31,255,255,208,15,202,125,210,240,0,31,255,255,208,15,192,60,2,240,0,31,229,85,64,15,234,190,171,240,0,31,192,0,0,15,255,255,255,240,0,31,192,0,0,15,255,255,255,240,0,31,192,0,0,0,0,190,0,0,0,31,192,0,0,0,0,190,0,0,0,31,192,0,0,0,0,190,0,0,0,31,192,0,0,15,255,255,255,244,85,111,229,85,0,15,255,255,255,244,255,255,255,255,0,15,255,255,255,244,255,255,255,255,0,0,0,190,0,0,255,255,255,255,0,0,0,190,0,0,253,0,0,191,0,1,85,255,175,252,253,0,0,191,0,63,255,255,255,252,253,0,0,191,0,63,255,255,255,252,253,0,0,191,0,63,250,165,80,0,253,0,0,191,0,0,0,0,7,128,253,0,0,191,0,2,6,139,203,208,253,0,0,191,0,7,215,199,195,240,253,0,0,191,0,11,199,195,209,248,253,0,0,191,0,11,195,210,240,252,254,85,85,255,0,15,195,225,240,125,255,255,255,255,0,31,131,224,244,52,255,255,255,255,0,63,3,224,144,0,255,255,255,255,0,126,1,64,0,0,253,0,0,191,0,8,0,0,0,0,189,0,0,106,0,
  // 0x9f4a  齊
  74,159,37,39,134,40,2,251,0,0,0,0,169,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,254,0,0,0,0,0,191,255,255,255,255,255,255,255,253,0,191,255,255,255,255,255,255,255,253,0,191,255,255,255,255,255,255,255,253,0,0,0,0,46,0,120,0,1,0,0,0,0,0,63,64,252,0,31,192,0,63,255,255,223,193,249,91,255,240,0,63,255,255,203,211,243,255,255,64,0,42,254,175,195,150,195,255,253,0,0,0,252,15,192,253,3,240,62,0,0,1,248,15,192,253,3,240,47,0,0,2,244,15,192,253,3,240,31,192,0,7,240,15,192,253,3,240,15,208,0,15,224,47,128,253,3,245,171,244,0,127,207,255,64,253,47,255,246,254,0,255,7,255,0,253,47,255,244,255,64,124,2,164,0,253,31,164,0,61,0,16,5,64,0,0,0,1,84,4,0,0,15,224,0,0,0,3,248,0,0,0,15,224,0,0,0,3,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,255,255,255,255,255,248,0,0,0,15,224,0,0,0,3,248,0,0,0,31,208,0,0,0,3,248,0,0,0,47,255,255,255,255,255,248,0,0,0,63,255,255,255,255,255,248,0,0,0,127,255,255,255,255,255,248,0,0,0,255,64,0,0,0,3,248,0,0,2,255,0,0,0,0,3,248,0,0,11,254,0,0,0,0,3,248,0,0,47,252,0,0,0,0,3,248,0,0,63,240,0,0,0,0,3,248,0,0,15,192,0,0,0,0,3,248,0,0,7,0,0,0,0,0,3,248,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0xff1a  ：
  26,255,8,27,54,40,16,1,11,224,47,248,63,252,127,253,63,252,47,248,6,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,224,63,248,63,252,127,253,63,252,47,244,6,128,
};

#endif // HAS_GRAPHICAL_TFT
