/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Katakana 40pt, capital 'A' height: 29px, width: 100%, range: 0x30a0-0x8868, glyphs: 103
extern const uint8_t NotoSans_Medium_Katakana_29[11808] = {
  162,29,160,48,104,136,38,246, // unifont_t
  // 0x30a0  ゠
  160,48,18,8,40,40,11,11,191,255,255,255,224,106,170,170,170,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,144,191,255,255,255,224,
  // 0x30a1  ァ
  161,48,28,27,189,40,7,251,255,255,255,255,255,255,244,255,255,255,255,255,255,254,255,255,255,255,255,255,254,250,170,170,170,170,175,252,0,0,0,0,0,31,240,0,0,0,0,0,63,224,0,0,15,244,0,255,192,0,0,15,244,2,255,0,0,0,11,244,11,253,0,0,0,11,244,47,244,0,0,0,11,240,255,224,0,0,0,15,240,63,128,0,0,0,15,240,9,0,0,0,0,15,240,0,0,0,0,0,31,240,0,0,0,0,0,47,224,0,0,0,0,0,63,192,0,0,0,0,0,127,192,0,0,0,0,0,255,64,0,0,0,0,3,255,0,0,0,0,0,15,253,0,0,0,0,0,127,248,0,0,0,0,2,255,224,0,0,0,0,15,255,128,0,0,0,0,3,253,0,0,0,0,0,0,176,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30a2  ア
  162,48,33,33,41,40,5,253,64,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,252,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,254,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,127,224,0,0,0,0,170,64,1,255,192,0,0,0,0,255,64,3,255,0,0,0,0,0,255,64,31,253,0,0,0,0,0,255,64,127,244,0,0,0,0,0,255,66,255,208,0,0,0,0,0,255,71,255,64,0,0,0,0,0,255,65,253,0,0,0,0,0,0,255,64,48,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,255,208,0,0,0,0,0,0,7,255,128,0,0,0,0,0,0,47,255,0,0,0,0,0,0,1,255,252,0,0,0,0,0,0,15,255,224,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,0,188,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,
  // 0x30a3  ィ
  163,48,27,29,203,40,5,252,0,0,0,0,0,2,64,0,0,0,0,0,11,208,0,0,0,0,0,47,244,0,0,0,0,0,191,244,0,0,0,0,3,255,208,0,0,0,0,15,255,64,0,0,0,0,127,252,0,0,0,0,2,255,224,0,0,0,0,31,255,64,0,0,0,1,255,252,0,0,0,0,31,255,240,0,0,0,1,255,255,240,0,0,0,111,255,255,240,0,0,27,255,255,95,240,0,0,255,255,244,31,240,0,0,191,254,64,31,240,0,0,63,208,0,31,240,0,0,40,0,0,31,240,0,0,0,0,0,31,240,0,0,0,0,0,31,240,0,0,0,0,0,31,240,0,0,0,0,0,31,240,0,0,0,0,0,31,240,0,0,0,0,0,31,240,0,0,0,0,0,31,240,0,0,0,0,0,31,240,0,0,0,0,0,47,240,0,0,0,0,0,47,240,0,0,0,0,0,5,80,0,0,
  // 0x30a4  イ
  164,48,32,33,8,40,3,254,0,0,0,0,0,0,0,208,0,0,0,0,0,0,3,244,0,0,0,0,0,0,15,253,0,0,0,0,0,0,63,253,0,0,0,0,0,0,255,244,0,0,0,0,0,7,255,192,0,0,0,0,0,47,255,0,0,0,0,0,0,255,252,0,0,0,0,0,7,255,224,0,0,0,0,0,63,255,64,0,0,0,0,2,255,248,0,0,0,0,0,47,255,224,0,0,0,0,2,255,255,192,0,0,0,0,111,255,255,192,0,0,0,7,255,255,191,192,0,0,1,255,255,248,63,192,0,0,127,255,255,64,63,192,0,0,191,255,244,0,63,192,0,0,63,254,0,0,63,192,0,0,47,144,0,0,63,192,0,0,4,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,208,0,0,0,0,0,0,127,208,0,0,
  // 0x30a5  ゥ
  165,48,27,29,203,40,7,252,0,0,7,252,0,0,0,0,0,7,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,255,255,255,255,255,255,208,191,255,255,255,255,255,248,191,255,255,255,255,255,244,191,170,170,170,170,191,240,191,0,0,0,0,31,240,191,0,0,0,0,47,240,191,0,0,0,0,63,224,191,0,0,0,0,63,208,191,0,0,0,0,127,192,191,0,0,0,0,255,128,255,0,0,0,0,255,64,21,0,0,0,2,255,0,0,0,0,0,3,254,0,0,0,0,0,15,252,0,0,0,0,0,47,248,0,0,0,0,0,191,240,0,0,0,0,3,255,192,0,0,0,0,47,255,64,0,0,0,1,255,252,0,0,0,0,111,255,240,0,0,0,15,255,255,128,0,0,0,3,255,252,0,0,0,0,1,255,144,0,0,0,0,0,116,0,0,0,0,
  // 0x30a6  ウ
  166,48,31,36,32,40,5,253,0,0,0,106,128,0,0,0,0,0,0,191,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,254,170,170,255,234,170,175,192,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,240,255,0,0,0,0,0,47,240,255,0,0,0,0,0,63,240,255,0,0,0,0,0,63,224,255,0,0,0,0,0,63,208,255,0,0,0,0,0,127,192,255,0,0,0,0,0,191,192,255,0,0,0,0,0,255,128,255,0,0,0,0,1,255,64,255,64,0,0,0,2,255,0,85,0,0,0,0,3,254,0,0,0,0,0,0,11,252,0,0,0,0,0,0,31,248,0,0,0,0,0,0,63,240,0,0,0,0,0,0,255,208,0,0,0,0,0,3,255,192,0,0,0,0,0,15,255,0,0,0,0,0,0,127,253,0,0,0,0,0,2,255,244,0,0,0,0,0,47,255,208,0,0,0,0,7,255,255,0,0,0,0,2,255,255,248,0,0,0,0,1,255,255,192,0,0,0,0,0,127,253,0,0,0,0,0,0,47,128,0,0,0,0,0,0,4,0,0,0,0,0,
  // 0x30a7  ェ
  167,48,28,23,161,40,6,254,14,170,170,170,170,170,176,15,255,255,255,255,255,244,15,255,255,255,255,255,244,15,255,255,255,255,255,244,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,
  // 0x30a8  エ
  168,48,34,27,243,40,3,0,7,255,255,255,255,255,255,254,0,7,255,255,255,255,255,255,254,0,7,255,255,255,255,255,255,254,0,7,255,255,255,255,255,255,254,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,80,0,0,7,252,0,0,0,80,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,
  // 0x30a9  ォ
  169,48,28,29,203,40,7,252,0,0,0,1,169,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,58,170,170,170,254,170,169,63,255,255,255,255,255,254,63,255,255,255,255,255,254,63,255,255,255,255,255,254,0,0,0,31,253,0,0,0,0,0,63,253,0,0,0,0,0,255,253,0,0,0,0,3,255,253,0,0,0,0,15,253,253,0,0,0,0,63,240,253,0,0,0,1,255,208,254,0,0,0,7,255,64,254,0,0,0,47,253,0,254,0,0,1,255,244,0,254,0,0,11,255,192,0,254,0,0,191,254,0,0,254,0,0,255,248,0,0,254,0,0,63,192,0,0,254,0,0,29,0,4,1,254,0,0,0,0,15,255,254,0,0,0,0,15,255,253,0,0,0,0,11,255,248,0,0,0,0,1,85,80,0,0,
  // 0x30aa  オ
  170,48,33,34,50,40,3,254,0,0,0,0,2,254,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,0,0,0,0,31,254,0,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,255,254,0,0,0,0,0,0,2,255,255,0,0,0,0,0,0,11,254,255,0,0,0,0,0,0,31,248,255,0,0,0,0,0,0,127,240,255,0,0,0,0,0,2,255,192,255,0,0,0,0,0,11,255,0,255,0,0,0,0,0,63,252,0,255,0,0,0,0,1,255,240,0,255,0,0,0,0,11,255,192,0,255,0,0,0,0,63,254,0,0,255,0,0,0,2,255,248,0,0,255,0,0,0,31,255,208,0,0,255,0,0,0,191,255,0,0,0,255,0,0,0,63,248,0,0,0,255,0,0,0,31,192,0,0,0,255,0,0,0,6,0,0,16,1,255,0,0,0,0,0,0,63,255,255,0,0,0,0,0,0,63,255,255,0,0,0,0,0,0,63,255,253,0,0,0,0,0,0,47,255,244,0,0,0,
  // 0x30ab  カ
  171,48,31,34,16,40,4,254,0,0,0,255,128,0,0,0,0,0,0,255,128,0,0,0,0,0,0,191,128,0,0,0,0,0,0,191,128,0,0,0,0,0,0,191,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,63,250,170,255,234,170,255,128,63,255,255,255,255,255,255,244,63,255,255,255,255,255,255,244,63,255,255,255,255,255,255,240,0,0,1,255,0,0,15,240,0,0,1,254,0,0,15,240,0,0,2,253,0,0,15,240,0,0,3,253,0,0,15,240,0,0,3,252,0,0,15,240,0,0,7,252,0,0,15,240,0,0,11,248,0,0,15,240,0,0,15,244,0,0,15,240,0,0,31,240,0,0,31,224,0,0,63,224,0,0,31,224,0,0,127,208,0,0,31,224,0,0,255,192,0,0,47,208,0,1,255,64,0,0,63,208,0,3,255,0,0,0,63,192,0,15,253,0,0,0,63,192,0,63,248,0,0,0,127,192,0,255,240,0,0,0,191,128,3,255,192,0,80,2,255,64,31,255,64,0,191,255,255,0,191,253,0,0,191,255,254,0,63,244,0,0,127,255,252,0,11,192,0,0,127,255,224,0,1,0,0,0,0,0,0,0,
  // 0x30ac  ガ
  172,48,35,37,77,40,3,253,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,31,128,0,0,0,106,64,0,6,15,192,0,0,0,191,192,0,63,7,240,0,0,0,191,192,0,31,195,244,0,0,0,191,128,0,15,209,252,0,0,0,127,128,0,7,240,180,0,0,0,191,128,0,3,244,0,0,0,0,191,128,0,0,144,0,0,0,0,191,128,0,0,0,0,63,255,255,255,255,255,255,208,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,248,0,63,255,255,255,255,255,255,244,0,0,0,0,255,0,0,11,244,0,0,0,1,255,0,0,11,244,0,0,0,2,254,0,0,11,244,0,0,0,2,253,0,0,15,240,0,0,0,3,253,0,0,15,240,0,0,0,3,252,0,0,15,240,0,0,0,11,252,0,0,15,240,0,0,0,15,248,0,0,15,240,0,0,0,15,240,0,0,15,240,0,0,0,47,240,0,0,15,240,0,0,0,63,208,0,0,31,224,0,0,0,255,192,0,0,31,224,0,0,1,255,128,0,0,47,208,0,0,3,255,0,0,0,47,208,0,0,15,253,0,0,0,63,192,0,0,47,252,0,0,0,63,192,0,0,191,240,0,0,0,191,192,0,3,255,208,0,80,1,255,128,0,31,255,64,0,127,255,255,64,0,191,253,0,0,127,255,255,0,0,47,244,0,0,127,255,253,0,0,11,208,0,0,63,255,224,0,0,1,0,0,0,0,0,0,0,0,
  // 0x30ad  キ
  173,48,32,35,24,40,4,253,0,0,1,188,0,0,0,0,0,0,7,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,253,0,0,0,0,0,0,2,254,0,0,0,0,0,0,1,255,0,1,111,0,0,0,0,255,22,255,255,64,0,0,1,255,255,255,255,64,0,90,255,255,255,255,255,128,255,255,255,255,255,254,144,0,191,255,255,255,229,0,0,0,127,255,250,191,192,0,0,0,127,164,0,63,192,0,0,0,16,0,0,63,208,0,0,0,0,0,0,47,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,240,0,6,253,0,0,0,15,240,107,255,254,0,0,0,15,255,255,255,255,0,0,107,255,255,255,255,255,90,255,255,255,255,255,249,64,255,255,255,255,255,148,0,0,191,255,255,235,252,0,0,0,127,254,144,3,253,0,0,0,57,64,0,2,253,0,0,0,0,0,0,2,254,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,191,128,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,208,0,0,0,0,0,0,62,64,0,0,0,0,0,0,0,0,0,0,
  // 0x30ae  ギ
  174,48,35,37,77,40,3,253,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,47,15,208,0,0,1,189,0,0,63,67,240,0,0,3,253,0,0,15,194,248,0,0,3,254,0,0,11,224,244,0,0,1,254,0,0,3,240,0,0,0,1,255,0,0,2,208,0,0,0,0,255,0,1,175,64,0,0,0,0,255,86,255,255,128,0,0,0,1,255,255,255,255,192,0,1,107,255,255,255,255,255,192,0,191,255,255,255,255,254,80,0,0,127,255,255,255,229,0,0,0,0,63,255,250,127,208,0,0,0,0,63,164,0,47,208,0,0,0,0,16,0,0,47,224,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,15,240,0,0,1,0,0,0,0,15,240,0,6,255,0,0,0,0,11,244,107,255,255,0,0,0,0,11,255,255,255,255,0,0,1,107,255,255,255,255,255,64,90,255,255,255,255,255,233,64,0,127,255,255,255,255,144,0,0,0,127,255,255,235,253,0,0,0,0,63,254,144,2,254,0,0,0,0,41,64,0,1,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,62,64,0,0,0,
  // 0x30af  ク
  175,48,31,36,32,40,4,253,0,0,0,40,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,127,224,0,0,0,0,0,0,255,192,0,0,0,0,0,1,255,64,0,0,0,0,0,3,255,0,0,0,0,0,0,11,255,170,170,171,128,0,0,31,255,255,255,255,248,0,0,63,255,255,255,255,252,0,0,191,255,255,255,255,248,0,2,255,128,0,0,47,240,0,7,255,0,0,0,63,240,0,31,252,0,0,0,63,224,0,127,244,0,0,0,191,192,2,255,208,0,0,0,255,192,15,255,64,0,0,1,255,64,127,253,0,0,0,3,255,0,255,244,0,0,0,7,253,0,63,192,0,0,0,15,252,0,10,0,0,0,0,47,244,0,0,0,0,0,0,127,240,0,0,0,0,0,0,255,192,0,0,0,0,0,3,255,128,0,0,0,0,0,15,255,0,0,0,0,0,0,47,252,0,0,0,0,0,0,191,240,0,0,0,0,0,3,255,208,0,0,0,0,0,31,255,64,0,0,0,0,0,191,253,0,0,0,0,0,11,255,240,0,0,0,0,0,191,255,192,0,0,0,0,27,255,253,0,0,0,0,0,255,255,224,0,0,0,0,0,127,255,64,0,0,0,0,0,31,228,0,0,0,0,0,0,2,0,0,0,0,0,0,
  // 0x30b0  グ
  176,48,37,38,124,40,2,252,0,0,0,0,0,0,0,1,240,0,0,0,0,0,0,0,0,67,248,0,0,0,0,9,0,0,7,208,252,0,0,0,0,31,224,0,3,240,190,0,0,0,0,63,240,0,2,248,63,0,0,0,0,127,224,0,0,252,31,64,0,0,0,255,192,0,0,126,4,0,0,0,1,255,64,0,0,61,0,0,0,0,3,255,170,170,171,224,0,0,0,0,11,255,255,255,255,252,0,0,0,0,31,255,255,255,255,254,0,0,0,0,63,255,255,255,255,252,0,0,0,0,255,208,0,0,15,252,0,0,0,3,255,64,0,0,31,244,0,0,0,15,254,0,0,0,47,240,0,0,0,63,252,0,0,0,63,240,0,0,0,255,240,0,0,0,127,208,0,0,7,255,192,0,0,0,255,192,0,0,47,255,0,0,0,1,255,128,0,0,191,248,0,0,0,3,255,0,0,0,47,224,0,0,0,7,254,0,0,0,7,64,0,0,0,15,252,0,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,0,7,255,64,0,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,0,127,248,0,0,0,0,0,0,0,2,255,240,0,0,0,0,0,0,0,11,255,192,0,0,0,0,0,0,0,127,255,0,0,0,0,0,0,0,7,255,248,0,0,0,0,0,0,0,127,255,208,0,0,0,0,0,0,7,255,255,0,0,0,0,0,0,0,191,255,244,0,0,0,0,0,0,0,47,255,128,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,0,2,64,0,0,0,0,0,0,0,
  // 0x30b1  ケ
  177,48,35,35,59,40,2,253,0,0,15,232,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,255,255,255,255,255,248,0,2,255,255,255,255,255,255,248,0,3,255,255,255,255,255,255,248,0,15,255,255,255,255,255,255,248,0,47,244,0,0,255,64,0,0,0,127,240,0,0,255,64,0,0,0,255,208,0,0,255,64,0,0,3,255,128,0,0,255,0,0,0,11,255,0,0,1,255,0,0,0,47,252,0,0,2,255,0,0,0,127,244,0,0,3,254,0,0,0,15,224,0,0,3,253,0,0,0,1,128,0,0,7,252,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,255,208,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,127,252,0,0,0,0,0,0,2,255,240,0,0,0,0,0,0,15,255,192,0,0,0,0,0,0,127,255,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,2,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30b2  ゲ
  178,48,36,38,86,40,2,252,0,0,0,0,0,0,0,0,144,0,0,0,0,0,0,0,3,240,0,0,4,0,0,0,6,194,248,0,0,31,228,0,0,11,224,253,0,0,47,240,0,0,3,244,127,0,0,63,240,0,0,1,252,63,0,0,63,208,0,0,0,253,4,0,0,127,192,0,0,0,125,0,0,0,255,128,0,0,0,16,0,0,0,255,64,0,0,0,0,0,0,2,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,31,255,255,255,255,255,255,240,0,63,240,0,1,255,0,0,0,0,255,208,0,1,255,0,0,0,2,255,192,0,2,255,0,0,0,7,255,0,0,2,254,0,0,0,31,253,0,0,3,254,0,0,0,127,248,0,0,3,253,0,0,0,255,240,0,0,7,252,0,0,0,31,192,0,0,11,252,0,0,0,2,0,0,0,15,248,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,1,255,128,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,63,252,0,0,0,0,0,0,0,255,244,0,0,0,0,0,0,7,255,208,0,0,0,0,0,0,47,255,128,0,0,0,0,0,0,255,254,0,0,0,0,0,0,0,47,244,0,0,0,0,0,0,0,7,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30b3  コ
  179,48,29,30,240,40,6,254,127,255,255,255,255,255,255,64,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,80,0,0,0,0,0,255,0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,0,
  // 0x30b4  ゴ
  180,48,33,38,86,40,5,253,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,2,244,0,0,0,0,0,0,7,193,252,0,0,0,0,0,0,11,224,190,0,0,0,0,0,0,3,244,63,0,0,0,0,0,0,2,252,47,128,0,0,0,0,0,0,253,15,64,0,0,0,0,0,0,189,0,0,0,0,0,0,0,0,16,0,0,63,255,255,255,255,255,255,64,0,63,255,255,255,255,255,255,64,0,63,255,255,255,255,255,255,64,0,63,255,255,255,255,255,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,191,255,255,255,255,255,255,64,0,191,255,255,255,255,255,255,64,0,191,255,255,255,255,255,255,64,0,191,255,255,255,255,255,255,64,0,16,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,85,0,0,
  // 0x30b5  サ
  181,48,35,35,59,40,2,253,0,0,0,0,0,2,169,0,0,0,0,191,192,0,3,253,0,0,0,0,191,128,0,3,253,0,0,0,0,127,128,0,3,253,0,0,0,0,127,128,0,3,253,0,0,0,0,127,128,0,3,253,0,0,0,0,127,128,0,3,253,0,0,0,0,127,128,0,3,253,0,0,0,0,127,128,0,3,253,0,0,127,255,255,255,255,255,255,255,252,127,255,255,255,255,255,255,255,252,127,255,255,255,255,255,255,255,252,127,255,255,255,255,255,255,255,252,0,0,127,128,0,3,253,0,0,0,0,127,128,0,3,253,0,0,0,0,127,128,0,3,252,0,0,0,0,127,128,0,3,252,0,0,0,0,127,128,0,3,252,0,0,0,0,127,128,0,3,252,0,0,0,0,127,128,0,3,252,0,0,0,0,127,128,0,7,252,0,0,0,0,191,128,0,11,248,0,0,0,0,191,128,0,15,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,127,252,0,0,0,0,0,0,7,255,240,0,0,0,0,0,0,127,255,192,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,2,64,0,0,0,0,
  // 0x30b6  ザ
  182,48,37,36,104,40,2,252,0,0,0,0,0,0,0,0,184,0,0,0,170,0,0,11,248,116,188,0,0,1,255,0,0,11,248,188,62,0,0,0,255,0,0,11,248,125,47,0,0,0,255,0,0,11,248,62,31,64,0,0,255,0,0,11,248,31,14,0,0,0,255,0,0,11,248,15,0,0,0,0,255,0,0,11,248,0,0,0,0,0,255,0,0,11,248,0,0,0,255,255,255,255,255,255,255,255,244,0,255,255,255,255,255,255,255,255,244,0,255,255,255,255,255,255,255,255,244,0,255,255,255,255,255,255,255,255,244,0,0,0,255,0,0,11,248,0,0,0,0,0,255,0,0,11,248,0,0,0,0,0,255,0,0,11,248,0,0,0,0,0,255,0,0,11,248,0,0,0,0,0,255,0,0,11,244,0,0,0,0,0,255,0,0,11,244,0,0,0,0,0,255,0,0,15,244,0,0,0,0,0,255,0,0,15,240,0,0,0,0,0,255,0,0,15,240,0,0,0,0,1,255,0,0,31,240,0,0,0,0,0,85,0,0,63,224,0,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,1,255,128,0,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,0,15,253,0,0,0,0,0,0,0,0,127,252,0,0,0,0,0,0,0,3,255,240,0,0,0,0,0,0,0,111,255,192,0,0,0,0,0,0,0,255,254,0,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,0,15,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30b7  シ
  183,48,33,33,41,40,4,254,0,0,192,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,7,255,64,0,0,0,0,0,0,15,255,224,0,0,0,0,0,0,1,255,253,0,0,0,0,0,0,0,47,255,128,0,0,0,0,0,0,7,255,128,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,28,0,0,0,0,0,8,0,0,0,0,0,0,4,0,63,128,0,0,0,0,0,44,0,191,244,0,0,0,0,0,63,0,255,254,0,0,0,0,0,255,64,47,255,208,0,0,0,2,255,128,2,255,248,0,0,0,11,255,0,0,127,244,0,0,0,31,252,0,0,11,240,0,0,0,127,244,0,0,1,192,0,0,1,255,224,0,0,0,0,0,0,7,255,128,0,0,0,0,0,0,47,254,0,0,0,0,0,0,0,191,248,0,0,0,0,0,0,7,255,224,0,0,0,0,0,0,47,255,64,0,0,0,0,0,1,255,253,0,0,0,0,0,0,31,255,240,0,0,0,0,0,1,255,255,128,0,0,0,0,0,47,255,252,0,0,0,0,0,27,255,255,208,0,0,0,0,11,255,255,254,0,0,0,0,0,15,255,255,224,0,0,0,0,0,7,255,253,0,0,0,0,0,0,2,254,64,0,0,0,0,0,0,0,144,0,0,0,0,0,0,0,
  // 0x30b8  ジ
  184,48,35,34,50,40,3,254,0,0,0,0,0,0,0,26,0,0,0,80,0,0,0,0,127,64,0,0,248,0,0,0,116,47,192,0,3,255,64,0,2,252,15,224,0,7,255,240,0,0,254,7,240,0,1,255,253,0,0,127,3,248,0,0,47,255,128,0,47,128,244,0,0,7,255,192,0,15,192,0,0,0,0,191,64,0,11,128,0,0,0,0,31,0,0,0,0,0,4,0,0,0,0,0,0,0,0,15,128,0,0,0,0,0,14,0,63,244,0,0,0,0,0,47,0,127,255,0,0,0,0,0,63,128,31,255,224,0,0,0,0,255,192,2,255,252,0,0,0,3,255,128,0,127,252,0,0,0,11,255,0,0,11,244,0,0,0,47,252,0,0,0,224,0,0,0,191,244,0,0,0,0,0,0,2,255,208,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,63,253,0,0,0,0,0,0,1,255,244,0,0,0,0,0,0,11,255,208,0,0,0,0,0,0,127,255,0,0,0,0,0,0,7,255,248,0,0,0,0,0,0,127,255,208,0,0,0,0,0,11,255,255,0,0,0,0,0,2,255,255,244,0,0,0,0,6,191,255,255,128,0,0,0,0,11,255,255,248,0,0,0,0,0,3,255,255,64,0,0,0,0,0,1,255,208,0,0,0,0,0,0,0,164,0,0,0,0,0,0,0,
  // 0x30b9  ス
  185,48,32,32,0,40,4,254,0,0,0,0,0,0,16,0,2,255,255,255,255,255,253,0,2,255,255,255,255,255,255,64,2,255,255,255,255,255,255,0,2,255,255,255,255,255,253,0,0,0,0,0,0,15,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,47,240,0,0,0,0,0,0,63,224,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,128,0,0,0,0,0,3,255,0,0,0,0,0,0,7,253,0,0,0,0,0,0,15,248,0,0,0,0,0,0,63,240,0,0,0,0,0,0,191,208,0,0,0,0,0,1,255,192,0,0,0,0,0,7,255,240,0,0,0,0,0,31,255,252,0,0,0,0,0,127,255,255,0,0,0,0,1,255,211,255,192,0,0,0,11,255,128,255,240,0,0,0,47,254,0,127,252,0,0,1,255,248,0,31,255,0,0,11,255,208,0,7,255,128,0,127,255,64,0,1,255,224,2,255,252,0,0,0,191,244,47,255,224,0,0,0,47,253,255,255,64,0,0,0,15,255,127,248,0,0,0,0,3,253,31,208,0,0,0,0,1,244,5,0,0,0,0,0,0,144,
  // 0x30ba  ズ
  186,48,36,38,86,40,3,253,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,31,11,224,0,0,0,0,0,0,47,131,240,0,0,0,0,0,0,15,193,252,0,0,0,0,0,0,11,224,253,0,0,0,0,0,0,19,244,100,1,255,255,255,255,255,255,244,0,1,255,255,255,255,255,255,128,0,1,255,255,255,255,255,255,0,0,1,255,255,255,255,255,254,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,127,208,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,47,244,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,1,255,208,0,0,0,0,0,0,7,255,240,0,0,0,0,0,0,15,255,253,0,0,0,0,0,0,127,255,255,64,0,0,0,0,1,255,227,255,208,0,0,0,0,11,255,128,255,244,0,0,0,0,47,254,0,63,252,0,0,0,0,255,248,0,15,255,0,0,0,11,255,208,0,3,255,192,0,0,63,255,64,0,0,255,240,0,2,255,252,0,0,0,127,248,0,47,255,224,0,0,0,31,254,0,255,255,64,0,0,0,11,255,64,63,248,0,0,0,0,3,254,0,15,192,0,0,0,0,0,244,0,1,0,0,0,0,0,0,80,0,
  // 0x30bb  セ
  187,48,34,34,50,40,2,254,0,0,5,80,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,110,0,0,0,15,240,0,1,191,255,192,0,0,15,240,6,191,255,255,224,0,0,15,246,255,255,255,255,192,0,0,111,255,255,255,255,255,128,5,191,255,255,255,254,82,255,0,191,255,255,255,250,64,3,253,0,191,255,255,249,0,0,15,252,0,127,255,239,240,0,0,31,240,0,63,144,15,240,0,0,63,224,0,16,0,15,240,0,0,255,192,0,0,0,15,240,0,2,255,0,0,0,0,15,240,0,11,253,0,0,0,0,15,240,0,47,248,0,0,0,0,15,240,0,31,240,0,0,0,0,15,240,0,2,192,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,254,0,0,86,191,0,0,0,15,255,255,255,255,255,0,0,0,7,255,255,255,255,255,0,0,0,1,255,255,255,255,255,0,0,0,0,26,255,255,170,84,0,
  // 0x30bc  ゼ
  188,48,36,36,68,40,2,254,0,0,0,0,0,0,0,1,224,0,0,0,0,0,0,0,67,244,0,0,0,0,0,0,7,209,252,0,0,42,144,0,0,7,240,190,0,0,63,224,0,0,3,244,63,0,0,63,224,0,0,0,252,47,0,0,63,208,0,0,0,190,0,0,0,47,208,0,0,0,57,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,24,0,0,0,47,208,0,0,27,255,0,0,0,47,208,0,107,255,255,192,0,0,47,209,175,255,255,255,192,0,0,63,255,255,255,255,255,0,0,27,255,255,255,255,231,254,0,175,255,255,255,255,144,7,252,0,255,255,255,254,64,0,15,244,0,255,255,255,208,0,0,47,240,0,255,229,47,208,0,0,127,192,0,100,0,47,208,0,0,255,128,0,0,0,47,208,0,3,255,0,0,0,0,47,208,0,15,252,0,0,0,0,47,208,0,63,244,0,0,0,0,47,208,0,63,224,0,0,0,0,47,208,0,7,128,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,47,248,0,0,22,189,0,0,0,31,255,255,255,255,253,0,0,0,15,255,255,255,255,253,0,0,0,3,255,255,255,255,253,0,0,0,0,43,255,255,250,84,0,
  // 0x30bd  ソ
  189,48,31,31,248,40,4,254,0,64,0,0,0,0,46,144,11,192,0,0,0,0,47,244,127,240,0,0,0,0,63,240,63,244,0,0,0,0,63,224,15,252,0,0,0,0,63,208,11,254,0,0,0,0,127,208,3,255,0,0,0,0,191,192,1,255,192,0,0,0,255,192,0,255,208,0,0,0,255,128,0,127,240,0,0,1,255,0,0,47,248,0,0,3,255,0,0,15,252,0,0,3,254,0,0,11,244,0,0,11,252,0,0,3,64,0,0,15,248,0,0,0,0,0,0,47,244,0,0,0,0,0,0,63,240,0,0,0,0,0,0,255,208,0,0,0,0,0,2,255,128,0,0,0,0,0,7,255,0,0,0,0,0,0,15,253,0,0,0,0,0,0,63,248,0,0,0,0,0,0,255,240,0,0,0,0,0,3,255,192,0,0,0,0,0,31,255,0,0,0,0,0,0,255,252,0,0,0,0,0,7,255,240,0,0,0,0,0,127,255,192,0,0,0,0,7,255,254,0,0,0,0,0,3,255,244,0,0,0,0,0,0,191,128,0,0,0,0,0,0,40,0,0,0,0,0,
  // 0x30be  ゾ
  190,48,34,37,77,40,4,253,0,0,0,0,0,0,0,29,0,0,0,0,0,0,0,32,127,0,0,0,0,0,0,2,248,63,128,0,0,0,0,0,0,253,15,192,0,0,0,0,0,0,127,11,240,0,0,0,0,0,0,63,67,224,2,0,0,0,0,0,31,128,0,47,128,0,0,0,0,8,0,0,255,208,0,0,0,0,191,128,0,127,240,0,0,0,0,191,192,0,47,248,0,0,0,0,255,192,0,15,252,0,0,0,0,255,128,0,7,254,0,0,0,1,255,64,0,3,255,64,0,0,2,255,0,0,1,255,192,0,0,3,255,0,0,0,255,208,0,0,3,253,0,0,0,63,240,0,0,11,252,0,0,0,47,244,0,0,15,252,0,0,0,15,192,0,0,31,244,0,0,0,9,0,0,0,63,240,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,2,255,64,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,15,253,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,127,253,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,31,255,208,0,0,0,0,0,1,255,255,0,0,0,0,0,0,15,255,248,0,0,0,0,0,0,7,255,208,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,
  // 0x30bf  タ
  191,48,32,36,32,40,3,253,0,0,0,15,64,0,0,0,0,0,0,15,248,0,0,0,0,0,0,47,244,0,0,0,0,0,0,63,240,0,0,0,0,0,0,191,208,0,0,0,0,0,0,255,128,0,0,64,0,0,3,255,255,255,255,248,0,0,7,255,255,255,255,255,0,0,15,255,255,255,255,255,0,0,63,250,170,170,175,254,0,0,191,208,0,0,11,252,0,2,255,128,0,0,15,248,0,11,255,0,0,0,31,244,0,47,252,0,0,0,47,240,0,191,240,0,0,0,63,224,3,255,192,60,0,0,191,192,31,255,0,255,128,0,255,128,191,252,2,255,244,3,255,0,47,224,0,191,254,7,254,0,7,128,0,31,255,223,252,0,0,0,0,2,255,255,244,0,0,0,0,0,127,255,224,0,0,0,0,0,15,255,208,0,0,0,0,0,7,255,248,0,0,0,0,0,31,255,255,0,0,0,0,0,127,255,255,208,0,0,0,2,255,226,255,192,0,0,0,15,255,128,191,64,0,0,0,127,254,0,29,0,0,0,7,255,244,0,0,0,0,0,47,255,192,0,0,0,0,7,255,254,0,0,0,0,0,191,255,244,0,0,0,0,0,63,255,128,0,0,0,0,0,15,244,0,0,0,0,0,0,2,64,0,0,0,0,0,
  // 0x30c0  ダ
  192,48,37,38,124,40,2,252,0,0,0,0,0,0,0,2,240,0,0,0,0,0,0,0,0,66,248,0,0,0,0,14,64,0,7,224,252,0,0,0,0,15,248,0,3,240,190,0,0,0,0,47,240,0,2,248,63,0,0,0,0,63,224,0,0,252,31,64,0,0,0,191,192,0,0,126,4,0,0,0,1,255,128,0,0,125,0,0,0,0,3,255,255,255,255,244,0,0,0,0,11,255,255,255,255,255,0,0,0,0,31,255,255,255,255,255,0,0,0,0,63,250,170,170,175,253,0,0,0,0,255,208,0,0,11,252,0,0,0,3,255,64,0,0,15,248,0,0,0,15,254,0,0,0,31,244,0,0,0,47,252,0,0,0,63,240,0,0,0,255,240,0,0,0,127,208,0,0,3,255,192,56,0,0,255,192,0,0,31,255,0,255,64,1,255,64,0,0,191,252,3,255,240,3,255,0,0,0,63,224,0,191,254,7,253,0,0,0,11,64,0,31,255,223,252,0,0,0,0,0,0,2,255,255,240,0,0,0,0,0,0,0,127,255,224,0,0,0,0,0,0,0,15,255,208,0,0,0,0,0,0,0,7,255,248,0,0,0,0,0,0,0,47,255,255,0,0,0,0,0,0,0,191,255,255,192,0,0,0,0,0,2,255,211,255,192,0,0,0,0,0,15,255,64,191,0,0,0,0,0,0,191,253,0,45,0,0,0,0,0,7,255,244,0,0,0,0,0,0,0,127,255,192,0,0,0,0,0,0,7,255,254,0,0,0,0,0,0,0,191,255,240,0,0,0,0,0,0,0,63,255,64,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,0,2,64,0,0,0,0,0,0,0,
  // 0x30c1  チ
  193,48,34,34,50,40,3,253,0,0,0,0,0,1,191,0,0,0,0,0,0,5,191,255,128,0,0,85,85,171,255,255,255,208,0,1,255,255,255,255,255,254,64,0,0,255,255,255,255,254,64,0,0,0,255,255,255,255,0,0,0,0,0,21,64,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,2,254,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,191,208,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,47,253,0,0,0,0,0,0,1,255,248,0,0,0,0,0,0,11,255,224,0,0,0,0,0,0,11,255,64,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,
  // 0x30c2  ヂ
  194,48,36,35,59,40,2,252,0,0,0,0,0,0,46,0,0,0,0,0,0,0,111,255,64,0,0,0,1,86,191,255,255,192,0,1,255,255,255,255,255,255,144,0,0,255,255,255,255,255,144,2,224,0,255,255,255,255,64,0,130,244,0,106,85,1,254,0,7,224,252,0,0,0,1,254,0,3,240,190,0,0,0,1,254,0,1,248,63,0,0,0,1,254,0,0,252,24,0,0,0,1,254,0,0,126,0,0,0,0,1,254,0,0,32,0,0,0,0,1,254,0,0,0,0,191,170,170,171,255,170,170,175,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,2,254,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,127,208,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,3,255,64,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,191,252,0,0,0,0,0,0,7,255,240,0,0,0,0,0,0,15,255,192,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30c3  ッ
  195,48,27,27,189,40,7,252,0,0,6,192,0,0,0,0,0,63,208,0,2,64,10,0,47,224,0,7,248,255,0,15,240,0,11,252,255,64,11,244,0,11,248,127,192,7,252,0,15,244,63,208,3,252,0,31,240,47,224,2,254,0,47,240,15,240,1,254,0,63,208,15,244,0,224,0,127,192,7,252,0,0,0,255,128,3,228,0,0,1,255,64,1,0,0,0,3,254,0,0,0,0,0,11,252,0,0,0,0,0,15,248,0,0,0,0,0,63,240,0,0,0,0,0,255,208,0,0,0,0,3,255,64,0,0,0,0,31,254,0,0,0,0,0,191,248,0,0,0,0,7,255,224,0,0,0,0,127,255,64,0,0,0,7,255,253,0,0,0,0,63,255,224,0,0,0,0,31,255,64,0,0,0,0,7,244,0,0,0,0,0,1,64,0,0,0,0,
  // 0x30c4  ツ
  196,48,34,32,32,40,3,254,0,0,0,31,0,0,0,0,0,0,0,0,255,0,0,0,16,0,1,64,0,255,128,0,0,127,128,47,192,0,127,192,0,0,191,208,127,208,0,63,208,0,0,255,192,63,240,0,47,240,0,0,255,128,31,240,0,15,240,0,0,255,64,15,248,0,15,248,0,2,255,0,11,252,0,11,252,0,3,255,0,3,253,0,3,253,0,3,253,0,2,255,0,3,253,0,7,252,0,1,255,0,1,128,0,15,248,0,0,255,128,0,0,0,31,244,0,0,191,128,0,0,0,63,240,0,0,36,0,0,0,0,127,208,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,2,255,64,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,127,253,0,0,0,0,0,0,2,255,244,0,0,0,0,0,0,31,255,192,0,0,0,0,0,1,255,255,0,0,0,0,0,0,47,255,248,0,0,0,0,0,2,255,255,208,0,0,0,0,0,0,255,254,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,29,0,0,0,0,0,0,
  // 0x30c5  ヅ
  197,48,35,37,77,40,3,253,0,0,0,0,0,0,0,6,128,0,0,0,0,0,0,9,15,208,0,0,0,0,0,0,127,7,240,0,0,0,0,0,0,47,131,248,0,0,0,0,0,0,15,192,252,0,0,0,108,0,0,11,224,184,0,0,3,254,0,0,3,240,0,1,0,1,255,0,0,1,64,0,191,0,0,255,64,0,0,0,0,255,128,0,191,128,0,1,249,0,127,192,0,127,192,0,2,255,0,63,224,0,63,208,0,3,255,0,47,240,0,47,240,0,3,253,0,15,244,0,15,240,0,7,252,0,15,252,0,15,248,0,15,252,0,7,252,0,7,248,0,15,244,0,3,254,0,2,64,0,47,240,0,2,255,0,0,0,0,63,224,0,0,254,0,0,0,0,127,208,0,0,144,0,0,0,0,255,192,0,0,0,0,0,0,2,255,64,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,47,248,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,11,255,64,0,0,0,0,0,0,47,253,0,0,0,0,0,0,0,255,244,0,0,0,0,0,0,7,255,224,0,0,0,0,0,0,127,255,64,0,0,0,0,0,3,255,252,0,0,0,0,0,0,127,255,240,0,0,0,0,0,7,255,255,64,0,0,0,0,0,3,255,248,0,0,0,0,0,0,0,255,144,0,0,0,0,0,0,0,56,0,0,0,0,0,0,
  // 0x30c6  テ
  198,48,34,33,41,40,3,253,0,47,255,255,255,255,255,208,0,0,47,255,255,255,255,255,208,0,0,47,255,255,255,255,255,208,0,0,47,170,170,170,170,175,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,240,127,255,255,255,255,255,255,255,240,127,255,255,255,255,255,255,255,240,127,255,255,255,255,255,255,255,240,0,0,0,0,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,255,208,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,127,252,0,0,0,0,0,0,2,255,244,0,0,0,0,0,0,7,255,192,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,36,0,0,0,0,0,0,
  // 0x30c7  デ
  199,48,36,39,95,40,3,252,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,2,131,244,0,0,0,0,0,0,15,208,252,0,0,0,0,0,0,3,240,190,0,63,170,170,170,171,246,248,63,0,63,255,255,255,255,244,252,24,0,63,255,255,255,255,244,189,0,0,63,255,255,255,255,244,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,208,0,0,0,2,254,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,255,208,0,0,0,0,0,0,2,255,128,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,63,252,0,0,0,0,0,0,1,255,244,0,0,0,0,0,0,15,255,208,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,0,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30c8  ト
  200,48,21,33,198,40,13,254,255,128,0,0,0,0,255,128,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,249,0,0,0,0,255,255,224,0,0,0,255,255,255,64,0,0,255,255,255,249,0,0,255,175,255,255,224,0,255,65,191,255,254,0,255,64,7,255,255,192,255,64,0,111,255,128,255,64,0,2,255,64,255,64,0,0,47,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,128,0,0,0,0,170,64,0,0,0,0,
  // 0x30c9  ド
  201,48,24,34,204,40,11,253,21,64,0,0,1,192,127,208,0,0,11,224,127,192,0,6,3,244,63,192,0,63,129,252,63,192,0,15,208,254,63,192,0,11,240,127,63,192,0,3,244,45,63,192,0,1,252,0,63,192,0,0,244,0,63,192,0,0,0,0,63,192,0,0,0,0,63,228,0,0,0,0,63,255,144,0,0,0,63,255,254,0,0,0,63,255,255,244,0,0,63,255,255,255,144,0,63,198,255,255,253,0,63,192,31,255,255,224,63,192,0,191,255,224,63,192,0,7,255,192,63,192,0,0,47,192,63,192,0,0,2,64,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,127,192,0,0,0,0,127,208,0,0,0,0,127,208,0,0,0,0,21,64,0,0,0,0,
  // 0x30ca  ナ
  202,48,34,35,59,40,3,253,0,0,0,0,85,0,0,0,0,0,0,0,1,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,127,255,255,255,255,255,255,255,240,127,255,255,255,255,255,255,255,240,127,255,255,255,255,255,255,255,240,127,255,255,255,255,255,255,255,240,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,31,248,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,191,224,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,7,255,64,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,191,252,0,0,0,0,0,0,7,255,240,0,0,0,0,0,0,47,255,192,0,0,0,0,0,0,11,254,0,0,0,0,0,0,0,1,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30cb  ニ
  203,48,33,26,234,40,3,1,0,85,0,0,0,0,5,64,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,128,127,255,255,255,255,255,255,255,128,127,255,255,255,255,255,255,255,128,127,255,255,255,255,255,255,255,128,105,85,85,85,85,85,85,86,64,
  // 0x30cc  ヌ
  204,48,28,32,224,40,5,253,0,0,0,0,0,0,80,15,255,255,255,255,255,248,15,255,255,255,255,255,255,15,255,255,255,255,255,255,15,255,255,255,255,255,253,0,0,0,0,0,11,252,0,0,0,0,0,15,248,0,0,0,0,0,31,244,0,0,0,0,0,47,240,0,0,0,0,0,63,224,0,15,64,0,0,191,192,0,63,224,0,0,255,128,0,191,254,0,2,255,64,0,47,255,208,3,254,0,0,3,255,248,11,252,0,0,0,127,255,95,248,0,0,0,11,255,255,240,0,0,0,1,255,255,208,0,0,0,0,63,255,192,0,0,0,0,15,255,224,0,0,0,0,47,255,252,0,0,0,0,255,255,255,64,0,0,3,255,215,255,224,0,0,47,255,65,255,248,0,0,255,253,0,63,255,0,11,255,244,0,11,255,0,191,255,192,0,2,252,27,255,254,0,0,0,180,255,255,240,0,0,0,0,63,255,64,0,0,0,0,15,244,0,0,0,0,0,2,64,0,0,0,0,0,
  // 0x30cd  ネ
  205,48,34,36,68,40,3,253,0,0,0,2,169,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,253,0,0,0,0,3,255,170,171,255,170,191,128,0,3,255,255,255,255,255,255,224,0,3,255,255,255,255,255,255,244,0,3,255,255,255,255,255,255,224,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,127,252,0,0,0,0,0,0,2,255,224,0,0,0,0,0,0,31,255,128,0,0,0,0,0,1,255,254,0,180,0,0,0,0,31,255,252,2,254,0,0,0,2,255,255,252,7,255,224,0,0,111,255,255,252,2,255,253,0,31,255,255,131,252,0,63,255,128,255,255,248,3,252,0,7,255,240,127,255,128,3,252,0,0,255,240,47,228,0,3,252,0,0,47,208,9,0,0,3,252,0,0,7,128,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,2,168,0,0,0,0,
  // 0x30ce  ノ
  206,48,28,32,224,40,5,254,0,0,0,0,0,7,144,0,0,0,0,0,11,253,0,0,0,0,0,15,252,0,0,0,0,0,15,252,0,0,0,0,0,31,244,0,0,0,0,0,63,240,0,0,0,0,0,63,224,0,0,0,0,0,127,208,0,0,0,0,0,255,192,0,0,0,0,1,255,64,0,0,0,0,3,255,0,0,0,0,0,7,254,0,0,0,0,0,15,252,0,0,0,0,0,31,248,0,0,0,0,0,63,240,0,0,0,0,0,191,224,0,0,0,0,1,255,192,0,0,0,0,3,255,64,0,0,0,0,15,254,0,0,0,0,0,63,252,0,0,0,0,0,255,240,0,0,0,0,7,255,192,0,0,0,0,47,255,64,0,0,0,0,191,253,0,0,0,0,7,255,240,0,0,0,0,127,255,192,0,0,0,7,255,254,0,0,0,0,127,255,244,0,0,0,0,63,255,192,0,0,0,0,15,253,0,0,0,0,0,3,208,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30cf  ハ
  207,48,34,29,5,40,3,255,0,0,4,0,0,11,0,0,0,0,0,47,224,0,255,128,0,0,0,0,47,240,0,191,192,0,0,0,0,63,224,0,63,224,0,0,0,0,63,208,0,47,240,0,0,0,0,63,192,0,15,244,0,0,0,0,127,192,0,15,252,0,0,0,0,191,128,0,7,253,0,0,0,0,255,64,0,3,255,0,0,0,0,255,0,0,1,255,64,0,0,2,255,0,0,0,255,128,0,0,3,254,0,0,0,191,192,0,0,3,253,0,0,0,63,224,0,0,11,252,0,0,0,63,240,0,0,15,248,0,0,0,31,244,0,0,31,244,0,0,0,15,248,0,0,47,240,0,0,0,11,252,0,0,63,224,0,0,0,7,253,0,0,191,192,0,0,0,3,255,0,0,255,128,0,0,0,2,255,0,2,255,0,0,0,0,1,255,64,7,255,0,0,0,0,0,255,192,15,253,0,0,0,0,0,255,192,47,252,0,0,0,0,0,127,208,63,240,0,0,0,0,0,63,240,255,224,0,0,0,0,0,63,240,255,192,0,0,0,0,0,47,240,27,64,0,0,0,0,0,30,64,0,0,0,0,0,0,0,0,0,
  // 0x30d0  バ
  208,48,37,34,84,40,2,255,0,0,0,0,0,0,0,0,160,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,2,209,252,0,0,0,0,0,0,0,7,240,190,0,0,0,0,0,0,0,2,248,63,0,0,0,0,0,0,0,0,252,47,64,0,0,14,144,0,47,192,190,4,0,0,0,15,248,0,127,208,61,0,0,0,0,15,244,0,63,240,0,0,0,0,0,31,240,0,31,244,0,0,0,0,0,47,240,0,15,252,0,0,0,0,0,63,224,0,11,252,0,0,0,0,0,63,208,0,3,254,0,0,0,0,0,127,192,0,2,255,0,0,0,0,0,191,192,0,0,255,128,0,0,0,0,255,128,0,0,191,192,0,0,0,0,255,64,0,0,127,208,0,0,0,1,255,0,0,0,63,240,0,0,0,3,254,0,0,0,47,240,0,0,0,3,253,0,0,0,15,248,0,0,0,11,252,0,0,0,15,252,0,0,0,15,248,0,0,0,7,253,0,0,0,31,244,0,0,0,3,254,0,0,0,63,240,0,0,0,2,255,0,0,0,127,224,0,0,0,1,255,64,0,0,255,192,0,0,0,0,255,192,0,1,255,128,0,0,0,0,191,192,0,3,255,0,0,0,0,0,127,208,0,11,254,0,0,0,0,0,63,240,0,15,252,0,0,0,0,0,63,240,0,63,244,0,0,0,0,0,47,244,0,191,240,0,0,0,0,0,31,248,0,47,208,0,0,0,0,0,15,228,0,1,128,0,0,0,0,0,5,0,0,
  // 0x30d1  パ
  209,48,37,35,94,40,2,254,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,0,127,254,0,0,0,0,0,0,0,0,248,47,0,0,0,0,0,0,0,1,240,11,128,0,0,0,0,0,0,1,224,7,128,0,0,4,0,0,6,65,240,11,128,0,0,15,228,0,127,192,248,31,0,0,0,15,244,0,127,224,127,254,0,0,0,31,240,0,63,240,15,244,0,0,0,31,240,0,31,244,0,0,0,0,0,47,224,0,15,252,0,0,0,0,0,63,224,0,7,253,0,0,0,0,0,63,208,0,3,255,0,0,0,0,0,127,192,0,1,255,0,0,0,0,0,191,192,0,0,255,128,0,0,0,0,255,128,0,0,191,192,0,0,0,0,255,64,0,0,63,208,0,0,0,2,255,0,0,0,63,240,0,0,0,3,254,0,0,0,31,244,0,0,0,3,253,0,0,0,15,248,0,0,0,11,252,0,0,0,11,252,0,0,0,15,248,0,0,0,7,253,0,0,0,31,244,0,0,0,3,254,0,0,0,63,240,0,0,0,2,255,0,0,0,127,224,0,0,0,1,255,64,0,0,255,192,0,0,0,0,255,128,0,1,255,128,0,0,0,0,191,192,0,3,255,0,0,0,0,0,127,208,0,7,254,0,0,0,0,0,63,224,0,15,252,0,0,0,0,0,63,240,0,47,248,0,0,0,0,0,47,244,0,127,240,0,0,0,0,0,31,248,0,127,208,0,0,0,0,0,15,248,0,7,192,0,0,0,0,0,14,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30d2  ヒ
  210,48,27,33,231,40,8,255,21,64,0,0,0,0,0,127,192,0,0,0,0,0,127,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,2,0,63,192,0,0,0,47,64,63,192,0,0,6,255,192,63,192,0,0,127,255,192,63,192,0,31,255,255,128,63,192,7,255,255,248,0,63,198,255,255,254,64,0,63,255,255,255,208,0,0,63,255,255,248,0,0,0,63,255,253,0,0,0,0,63,254,64,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,208,0,0,0,0,16,63,249,64,0,21,175,244,47,255,255,255,255,255,244,15,255,255,255,255,255,244,3,255,255,255,255,255,244,0,26,255,255,255,170,80,
  // 0x30d3  ビ
  211,48,30,36,32,40,7,254,0,0,0,0,0,0,8,0,0,0,0,0,0,0,126,0,0,0,0,0,0,40,63,0,85,64,0,0,0,252,31,192,255,128,0,0,0,127,15,208,255,128,0,0,0,63,71,240,255,64,0,0,0,31,195,128,255,64,0,0,0,15,208,0,255,64,0,0,0,6,0,0,255,64,0,0,0,8,0,0,255,64,0,0,0,189,0,0,255,64,0,0,11,255,0,0,255,64,0,1,255,255,64,0,255,64,0,127,255,255,64,0,255,64,31,255,255,224,0,0,255,91,255,255,253,0,0,0,255,255,255,255,128,0,0,0,255,255,255,224,0,0,0,0,255,255,248,0,0,0,0,0,255,249,0,0,0,0,0,0,255,128,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,191,192,0,0,0,0,16,0,191,249,0,0,21,175,240,0,127,255,255,255,255,255,240,0,47,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,0,107,255,255,255,169,64,0,
  // 0x30d4  ピ
  212,48,31,35,24,40,7,254,0,0,0,0,0,0,190,0,0,0,0,0,0,7,255,208,170,64,0,0,0,15,146,240,255,128,0,0,0,31,0,180,255,64,0,0,0,30,0,120,255,64,0,0,0,31,0,184,255,64,0,0,0,15,129,240,255,64,0,0,0,7,255,224,255,64,0,0,0,45,255,64,255,64,0,0,2,254,0,0,255,64,0,0,111,255,0,0,255,64,0,11,255,255,64,0,255,64,1,255,255,253,0,0,255,64,191,255,255,144,0,0,255,175,255,255,244,0,0,0,255,255,255,254,0,0,0,0,255,255,255,144,0,0,0,0,255,255,224,0,0,0,0,0,255,228,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,191,192,0,0,0,0,16,0,191,249,0,0,21,175,240,0,63,255,255,255,255,255,240,0,47,255,255,255,255,255,240,0,11,255,255,255,255,255,240,0,0,107,255,255,255,169,64,0,
  // 0x30d5  フ
  213,48,30,30,240,40,5,254,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,224,127,255,255,255,255,255,255,224,127,255,255,255,255,255,255,208,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,192,0,0,0,0,0,0,255,128,0,0,0,0,0,1,255,64,0,0,0,0,0,2,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,7,253,0,0,0,0,0,0,11,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,47,240,0,0,0,0,0,0,63,240,0,0,0,0,0,0,255,208,0,0,0,0,0,2,255,128,0,0,0,0,0,7,255,0,0,0,0,0,0,31,253,0,0,0,0,0,0,127,248,0,0,0,0,0,2,255,240,0,0,0,0,0,11,255,192,0,0,0,0,0,127,255,0,0,0,0,0,7,255,252,0,0,0,0,0,127,255,224,0,0,0,0,27,255,255,64,0,0,0,0,191,255,248,0,0,0,0,0,63,255,192,0,0,0,0,0,15,248,0,0,0,0,0,0,3,64,0,0,0,0,0,
  // 0x30d6  ブ
  214,48,35,38,86,40,4,253,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,20,63,64,0,0,0,0,0,0,252,31,192,0,0,0,0,0,0,190,11,224,0,0,0,0,0,0,63,3,240,0,0,0,0,0,0,47,194,248,0,0,0,0,0,0,15,192,128,127,255,255,255,255,255,255,64,0,127,255,255,255,255,255,255,224,0,127,255,255,255,255,255,255,240,0,127,255,255,255,255,255,255,224,0,0,0,0,0,0,0,127,208,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,7,253,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,191,224,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,3,255,64,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,63,252,0,0,0,0,0,0,0,255,244,0,0,0,0,0,0,7,255,208,0,0,0,0,0,0,47,255,128,0,0,0,0,0,1,255,253,0,0,0,0,0,0,31,255,244,0,0,0,0,0,2,255,255,192,0,0,0,0,0,127,255,254,0,0,0,0,0,0,63,255,224,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,7,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30d7  プ
  215,48,35,37,77,40,5,253,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,11,255,192,0,0,0,0,0,0,31,71,224,0,0,0,0,0,0,45,0,240,0,0,0,0,0,0,60,0,244,0,0,0,0,0,0,61,0,240,255,255,255,255,255,255,255,67,240,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,64,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,127,208,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,2,255,128,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,253,0,0,0,0,0,0,0,63,252,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,31,255,64,0,0,0,0,0,0,127,254,0,0,0,0,0,0,7,255,244,0,0,0,0,0,0,127,255,208,0,0,0,0,0,11,255,255,0,0,0,0,0,1,255,255,248,0,0,0,0,0,0,255,255,192,0,0,0,0,0,0,63,253,0,0,0,0,0,0,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30d8  ヘ
  216,48,36,26,234,40,2,0,0,0,0,47,64,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,3,255,248,0,0,0,0,0,0,15,255,255,0,0,0,0,0,0,63,255,255,192,0,0,0,0,0,191,225,255,224,0,0,0,0,1,255,192,63,248,0,0,0,0,7,255,0,15,254,0,0,0,0,15,253,0,7,255,128,0,0,0,63,248,0,1,255,224,0,0,0,255,240,0,0,127,244,0,0,2,255,192,0,0,47,253,0,0,11,255,64,0,0,11,255,64,0,47,254,0,0,0,3,255,192,0,191,252,0,0,0,0,255,240,0,63,240,0,0,0,0,63,252,0,15,208,0,0,0,0,31,255,0,3,128,0,0,0,0,7,255,128,0,0,0,0,0,0,2,255,224,0,0,0,0,0,0,0,255,248,0,0,0,0,0,0,0,63,253,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,2,240,0,0,0,0,0,0,0,0,144,0,0,0,0,0,0,0,0,0,
  // 0x30d9  ベ
  217,48,36,29,5,40,2,0,0,0,0,0,0,0,0,47,0,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,180,47,192,0,0,0,0,0,2,252,15,224,0,0,0,126,0,0,254,7,244,0,0,2,255,208,0,127,66,252,0,0,11,255,244,0,47,192,224,0,0,31,255,254,0,15,208,0,0,0,63,255,255,128,11,128,0,0,0,255,209,255,208,0,0,0,0,3,255,64,127,244,0,0,0,0,11,254,0,31,253,0,0,0,0,31,252,0,7,255,64,0,0,0,127,240,0,2,255,208,0,0,0,255,208,0,0,191,240,0,0,3,255,128,0,0,47,252,0,0,15,255,0,0,0,15,255,0,0,63,252,0,0,0,3,255,192,0,255,244,0,0,0,0,255,240,0,63,224,0,0,0,0,127,248,0,31,192,0,0,0,0,31,254,0,7,0,0,0,0,0,11,255,128,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,0,255,244,0,0,0,0,0,0,0,63,253,0,0,0,0,0,0,0,31,253,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,2,224,0,0,0,0,0,0,0,0,128,
  // 0x30da  ペ
  218,48,36,29,5,40,2,0,0,0,0,0,0,0,7,254,0,0,0,0,0,0,0,31,255,192,0,0,0,0,0,0,62,7,224,0,0,0,0,0,0,124,1,240,0,0,0,127,0,0,184,0,240,0,0,2,255,208,0,184,0,240,0,0,11,255,244,0,124,2,240,0,0,31,255,254,0,63,91,208,0,0,63,255,255,128,31,255,128,0,0,255,209,255,208,2,253,0,0,3,255,64,127,244,0,0,0,0,11,254,0,31,253,0,0,0,0,31,252,0,7,255,64,0,0,0,127,240,0,2,255,208,0,0,0,255,208,0,0,191,240,0,0,3,255,128,0,0,47,252,0,0,15,255,0,0,0,15,255,0,0,63,252,0,0,0,3,255,192,0,255,244,0,0,0,0,255,240,0,127,224,0,0,0,0,127,248,0,31,192,0,0,0,0,31,254,0,7,64,0,0,0,0,11,255,128,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,0,255,244,0,0,0,0,0,0,0,63,253,0,0,0,0,0,0,0,31,253,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,2,224,0,0,0,0,0,0,0,0,128,
  // 0x30db  ホ
  219,48,35,34,50,40,3,254,0,0,0,2,255,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,1,0,1,254,0,1,0,0,0,7,224,1,254,0,31,128,0,0,15,248,1,254,0,127,208,0,0,31,240,1,254,0,63,240,0,0,63,224,1,254,0,15,248,0,0,191,192,1,254,0,7,253,0,1,255,64,1,254,0,3,255,0,3,254,0,1,254,0,0,255,128,15,252,0,1,254,0,0,191,192,63,244,0,1,254,0,0,63,224,191,224,0,1,254,0,0,31,244,191,192,0,1,254,0,0,15,240,31,0,0,1,254,0,0,7,64,0,0,0,2,254,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,31,255,254,0,0,0,0,0,0,31,255,253,0,0,0,0,0,0,31,255,252,0,0,0,0,0,0,11,255,224,0,0,0,0,
  // 0x30dc  ボ
  220,48,36,36,68,40,2,253,0,0,0,0,0,0,0,1,224,0,0,0,0,0,0,2,131,244,0,0,0,1,255,0,15,193,252,0,0,0,0,255,0,7,240,189,0,0,0,0,255,0,3,244,63,0,0,0,0,255,0,1,252,47,0,0,0,0,255,0,0,252,0,0,0,0,0,255,0,0,80,0,0,0,0,0,255,0,0,0,0,31,255,255,255,255,255,255,255,224,31,255,255,255,255,255,255,255,224,31,255,255,255,255,255,255,255,224,31,255,255,255,255,255,255,255,208,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,1,64,0,255,0,1,64,0,0,3,244,0,255,0,31,192,0,0,11,252,0,255,0,63,240,0,0,15,244,0,255,0,31,244,0,0,63,240,0,255,0,11,252,0,0,191,192,0,255,0,3,255,0,0,255,128,0,255,0,1,255,64,3,255,0,0,255,0,0,191,192,11,252,0,0,255,0,0,63,224,47,244,0,0,255,0,0,47,240,191,240,0,0,255,0,0,15,248,63,192,0,0,255,0,0,11,240,11,0,0,0,255,0,0,3,64,0,0,0,0,255,0,0,0,0,0,0,4,2,255,0,0,0,0,0,0,15,255,255,0,0,0,0,0,0,15,255,255,0,0,0,0,0,0,15,255,253,0,0,0,0,0,0,6,191,224,0,0,0,0,
  // 0x30dd  ポ
  221,48,36,37,77,40,2,253,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,1,255,244,0,0,0,0,0,0,3,224,188,0,0,0,1,255,0,7,192,60,0,0,0,0,255,0,11,128,45,0,0,0,0,255,0,7,192,60,0,0,0,0,255,0,3,224,188,0,0,0,0,255,0,1,255,240,0,0,0,0,255,0,0,47,128,0,0,0,0,255,0,0,0,0,31,255,255,255,255,255,255,255,224,31,255,255,255,255,255,255,255,224,31,255,255,255,255,255,255,255,224,31,255,255,255,255,255,255,255,208,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,1,64,0,255,0,1,64,0,0,3,244,0,255,0,31,192,0,0,11,252,0,255,0,63,240,0,0,15,244,0,255,0,31,244,0,0,63,240,0,255,0,11,252,0,0,191,192,0,255,0,3,255,0,0,255,128,0,255,0,1,255,64,3,255,0,0,255,0,0,191,192,11,252,0,0,255,0,0,63,224,47,244,0,0,255,0,0,47,240,191,240,0,0,255,0,0,15,248,63,192,0,0,255,0,0,11,240,11,0,0,0,255,0,0,3,64,0,0,0,0,255,0,0,0,0,0,0,4,2,255,0,0,0,0,0,0,15,255,255,0,0,0,0,0,0,15,255,255,0,0,0,0,0,0,15,255,253,0,0,0,0,0,0,6,191,224,0,0,0,0,
  // 0x30de  マ
  222,48,34,31,23,40,4,253,255,255,255,255,255,255,255,253,0,255,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,128,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,3,255,64,0,0,0,0,0,0,15,254,0,0,0,1,64,0,0,47,252,0,0,0,7,224,0,0,191,240,0,0,0,47,252,0,2,255,192,0,0,0,47,255,0,11,255,64,0,0,0,7,255,192,47,253,0,0,0,0,1,255,244,255,244,0,0,0,0,0,63,255,255,208,0,0,0,0,0,15,255,255,64,0,0,0,0,0,3,255,252,0,0,0,0,0,0,0,255,248,0,0,0,0,0,0,0,63,253,0,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,0,63,252,0,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,7,255,128,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,0,248,0,0,0,0,0,0,0,0,16,0,0,0,
  // 0x30df  ミ
  223,48,27,32,224,40,6,254,0,63,148,0,0,0,0,0,63,255,229,0,0,0,0,191,255,255,249,0,0,0,191,255,255,255,249,0,0,0,111,255,255,255,244,0,0,0,27,255,255,244,0,0,0,0,27,255,240,0,0,0,0,0,27,224,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,64,0,0,0,0,0,2,254,144,0,0,0,0,3,255,255,144,0,0,0,11,255,255,255,144,0,0,6,255,255,255,255,144,0,0,1,191,255,255,255,0,0,0,0,111,255,254,0,0,0,0,0,111,253,0,0,0,0,0,1,188,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,0,0,0,0,0,63,255,144,0,0,0,0,127,255,255,144,0,0,0,255,255,255,255,144,0,0,22,255,255,255,255,144,0,0,5,191,255,255,254,64,0,0,1,191,255,255,208,0,0,0,1,191,255,192,0,0,0,0,1,255,128,0,0,0,0,0,7,0,
  // 0x30e0  ム
  224,48,35,34,50,40,3,253,0,0,0,47,144,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,127,208,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,47,240,0,0,32,0,0,0,0,63,224,0,2,248,0,0,0,0,127,192,0,11,252,0,0,0,0,191,192,0,3,255,0,0,0,0,255,128,0,1,255,64,0,0,1,255,0,0,0,255,192,0,0,2,255,0,0,0,127,224,0,0,3,254,0,0,0,47,240,0,0,7,252,0,0,0,15,248,0,0,11,252,0,0,0,11,252,0,0,15,248,0,0,90,255,254,0,0,31,245,107,255,255,255,255,0,170,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,192,255,255,255,255,255,233,64,127,224,255,255,255,165,0,0,0,63,240,186,84,0,0,0,0,0,47,244,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,
  // 0x30e1  メ
  225,48,30,32,0,40,5,254,0,0,0,0,0,3,228,0,0,0,0,0,0,3,254,0,0,0,0,0,0,7,253,0,0,0,0,0,0,15,252,0,0,0,0,0,0,15,244,0,0,4,0,0,0,47,240,0,0,31,0,0,0,63,224,0,0,63,208,0,0,127,192,0,0,255,252,0,0,255,192,0,0,63,255,64,1,255,64,0,0,11,255,224,3,255,0,0,0,0,255,253,11,252,0,0,0,0,47,255,143,248,0,0,0,0,7,255,255,240,0,0,0,0,0,255,255,224,0,0,0,0,0,47,255,192,0,0,0,0,0,7,255,224,0,0,0,0,0,15,255,248,0,0,0,0,0,63,255,255,0,0,0,0,0,191,251,255,192,0,0,0,2,255,194,255,240,0,0,0,15,255,0,191,252,0,0,0,63,253,0,31,255,0,0,0,255,244,0,7,255,192,0,11,255,208,0,1,255,240,0,63,255,0,0,0,127,240,1,255,252,0,0,0,31,192,31,255,224,0,0,0,11,0,255,255,64,0,0,0,0,0,255,248,0,0,0,0,0,0,63,208,0,0,0,0,0,0,10,0,0,0,0,0,0,0,
  // 0x30e2  モ
  226,48,33,31,23,40,4,254,3,250,170,170,170,170,170,208,0,3,255,255,255,255,255,255,208,0,3,255,255,255,255,255,255,208,0,3,255,255,255,255,255,255,208,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,191,255,255,255,255,255,255,255,64,191,255,255,255,255,255,255,255,64,191,255,255,255,255,255,255,255,64,191,255,255,255,255,255,255,255,64,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,224,0,0,84,0,0,0,0,255,255,255,255,252,0,0,0,0,127,255,255,255,252,0,0,0,0,31,255,255,255,252,0,0,0,0,1,255,255,255,252,0,0,0,0,0,0,0,0,0,0,
  // 0x30e3  ャ
  227,48,29,29,232,40,6,252,0,0,80,0,0,0,0,0,0,31,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,11,244,0,0,0,0,0,0,7,248,0,0,0,24,0,0,3,252,0,0,107,255,0,0,3,252,1,175,255,255,128,0,2,255,255,255,255,255,0,0,91,255,255,255,251,254,0,191,255,255,255,233,7,252,0,255,255,255,228,0,15,240,0,255,255,255,128,0,63,224,0,190,64,63,192,0,191,192,0,0,0,63,192,1,255,0,0,0,0,47,208,7,253,0,0,0,0,31,224,31,248,0,0,0,0,15,240,47,224,0,0,0,0,15,240,2,192,0,0,0,0,11,248,0,0,0,0,0,0,7,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,253,0,0,0,0,0,0,2,254,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,57,0,0,0,0,
  // 0x30e4  ヤ
  228,48,35,35,59,40,2,253,0,0,27,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,63,192,0,0,0,27,208,0,0,63,208,0,1,111,255,248,0,0,47,224,6,191,255,255,248,0,0,31,250,255,255,255,255,240,0,0,111,255,255,255,255,191,224,22,191,255,255,255,254,64,191,192,191,255,255,255,249,0,1,255,64,127,255,255,253,0,0,3,254,0,63,255,147,253,0,0,15,252,0,62,64,3,254,0,0,47,244,0,0,0,1,255,0,0,191,208,0,0,0,0,255,0,1,255,128,0,0,0,0,255,128,7,255,0,0,0,0,0,191,192,31,252,0,0,0,0,0,127,192,31,244,0,0,0,0,0,63,208,1,208,0,0,0,0,0,63,224,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,7,253,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,0,185,64,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30e5  ュ
  229,48,29,21,168,40,6,255,1,255,255,255,255,244,0,0,1,255,255,255,255,254,0,0,1,255,255,255,255,254,0,0,1,255,255,255,255,253,0,0,0,0,0,0,3,253,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,15,244,0,0,0,0,0,0,15,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,47,224,0,0,0,0,0,0,47,224,0,0,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,64,
  // 0x30e6  ユ
  230,48,34,27,243,40,3,1,0,0,0,0,0,0,16,0,0,0,191,255,255,255,255,253,0,0,0,191,255,255,255,255,255,128,0,0,191,255,255,255,255,255,64,0,0,191,255,255,255,255,255,64,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,224,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,80,0,0,0,0,0,0,0,16,
  // 0x30e7  ョ
  231,48,23,26,156,40,8,252,127,255,255,255,255,252,127,255,255,255,255,252,127,255,255,255,255,252,42,170,170,170,171,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,10,170,170,170,171,252,31,255,255,255,255,252,31,255,255,255,255,252,31,255,255,255,255,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,191,255,255,255,255,252,191,255,255,255,255,252,191,255,255,255,255,252,186,170,170,170,171,252,0,0,0,0,2,252,0,0,0,0,0,84,
  // 0x30e8  ヨ
  232,48,28,30,210,40,6,254,127,255,255,255,255,255,254,127,255,255,255,255,255,254,127,255,255,255,255,255,253,127,255,255,255,255,255,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,31,255,255,255,255,255,253,31,255,255,255,255,255,253,31,255,255,255,255,255,253,31,255,255,255,255,255,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,0,0,0,0,0,2,253,255,255,255,255,255,255,253,255,255,255,255,255,255,253,255,255,255,255,255,255,253,255,255,255,255,255,255,254,0,0,0,0,0,2,254,0,0,0,0,0,2,253,
  // 0x30e9  ラ
  233,48,31,33,8,40,5,253,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,170,170,170,170,170,175,128,191,255,255,255,255,255,255,244,191,255,255,255,255,255,255,240,191,255,255,255,255,255,255,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,127,192,0,0,0,0,0,0,255,192,0,0,0,0,0,0,255,64,0,0,0,0,0,2,255,0,0,0,0,0,0,7,253,0,0,0,0,0,0,15,252,0,0,0,0,0,0,47,244,0,0,0,0,0,0,191,224,0,0,0,0,0,2,255,192,0,0,0,0,0,11,255,0,0,0,0,0,0,127,253,0,0,0,0,0,2,255,244,0,0,0,0,0,47,255,192,0,0,0,0,6,255,255,0,0,0,0,1,191,255,244,0,0,0,0,3,255,255,128,0,0,0,0,0,255,248,0,0,0,0,0,0,63,128,0,0,0,0,0,0,20,0,0,0,0,0,
  // 0x30ea  リ
  234,48,24,33,198,40,8,254,0,0,0,0,2,169,191,192,0,0,3,253,191,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,253,127,192,0,0,3,252,127,192,0,0,7,252,127,192,0,0,7,252,191,192,0,0,11,252,191,192,0,0,15,248,21,64,0,0,15,244,0,0,0,0,31,240,0,0,0,0,63,240,0,0,0,0,191,208,0,0,0,2,255,192,0,0,0,11,255,0,0,0,0,63,253,0,0,0,2,255,248,0,0,0,47,255,224,0,0,7,255,255,64,0,0,3,255,248,0,0,0,0,255,144,0,0,0,0,56,0,0,0,
  // 0x30eb  ル
  235,48,36,32,32,40,2,254,0,0,255,64,7,252,0,0,0,0,0,255,64,3,252,0,0,0,0,0,255,64,3,252,0,0,0,0,0,255,64,3,252,0,0,0,0,0,255,64,3,252,0,0,0,0,0,255,64,3,252,0,0,0,0,0,255,64,3,252,0,0,0,0,0,255,64,3,252,0,0,0,0,0,255,64,3,252,0,0,0,0,0,255,0,3,252,0,0,0,0,0,255,0,3,252,0,0,0,0,0,255,0,3,252,0,0,0,0,0,255,0,3,252,0,0,0,0,0,255,0,3,252,0,0,0,0,0,255,0,3,252,0,0,0,0,0,255,0,3,252,0,0,0,0,1,255,0,3,252,0,0,16,0,1,254,0,3,252,0,0,60,0,2,253,0,3,252,0,0,254,0,3,253,0,3,252,0,3,255,0,7,252,0,3,252,0,15,254,0,15,248,0,3,252,0,63,248,0,31,244,0,3,252,1,255,240,0,63,240,0,3,252,11,255,128,0,127,208,0,3,252,127,254,0,0,255,192,0,3,255,255,244,0,3,255,64,0,3,255,255,208,0,15,254,0,0,3,255,254,0,0,127,252,0,0,7,255,244,0,0,127,240,0,0,3,255,128,0,0,11,192,0,0,0,252,0,0,0,1,0,0,0,0,16,0,0,0,
  // 0x30ec  レ
  236,48,29,32,0,40,8,254,127,208,0,0,0,0,0,0,127,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,44,0,63,192,0,0,0,0,126,0,63,192,0,0,0,1,255,64,63,192,0,0,0,11,255,0,63,192,0,0,0,47,253,0,63,192,0,0,1,255,244,0,63,192,0,0,11,255,208,0,63,192,0,0,63,255,0,0,63,192,0,2,255,248,0,0,63,192,0,47,255,208,0,0,63,192,2,255,255,0,0,0,63,192,47,255,248,0,0,0,63,219,255,255,128,0,0,0,63,255,255,248,0,0,0,0,127,255,255,128,0,0,0,0,127,255,244,0,0,0,0,0,47,254,0,0,0,0,0,0,7,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30ed  ロ
  237,48,30,30,240,40,5,254,191,255,255,255,255,255,255,224,127,255,255,255,255,255,255,224,127,255,255,255,255,255,255,224,127,255,255,255,255,255,255,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,128,0,0,0,0,47,224,127,255,255,255,255,255,255,224,127,255,255,255,255,255,255,224,127,255,255,255,255,255,255,224,127,255,255,255,255,255,255,224,191,128,0,0,0,0,47,224,191,192,0,0,0,0,47,224,0,0,0,0,0,0,0,0,
  // 0x30ee  ヮ
  238,48,27,27,189,40,7,251,170,170,170,170,170,175,64,191,255,255,255,255,255,240,191,255,255,255,255,255,244,191,255,255,255,255,255,240,191,64,0,0,0,47,240,191,64,0,0,0,47,224,191,64,0,0,0,63,208,191,64,0,0,0,63,208,191,64,0,0,0,127,192,191,64,0,0,0,191,192,191,64,0,0,0,255,128,255,64,0,0,1,255,0,85,0,0,0,2,255,0,0,0,0,0,3,253,0,0,0,0,0,15,252,0,0,0,0,0,47,244,0,0,0,0,0,127,240,0,0,0,0,1,255,208,0,0,0,0,11,255,64,0,0,0,0,63,254,0,0,0,0,2,255,248,0,0,0,0,31,255,208,0,0,0,6,255,255,64,0,0,0,7,255,248,0,0,0,0,2,255,192,0,0,0,0,0,184,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30ef  ワ
  239,48,31,32,0,40,5,253,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,240,255,64,0,0,0,0,63,240,255,64,0,0,0,0,63,224,255,64,0,0,0,0,63,208,255,64,0,0,0,0,127,208,255,64,0,0,0,0,127,192,255,64,0,0,0,0,191,192,255,64,0,0,0,0,255,128,255,64,0,0,0,0,255,64,255,64,0,0,0,1,255,0,255,64,0,0,0,3,255,0,170,64,0,0,0,3,254,0,0,0,0,0,0,11,252,0,0,0,0,0,0,15,252,0,0,0,0,0,0,47,244,0,0,0,0,0,0,127,240,0,0,0,0,0,1,255,208,0,0,0,0,0,3,255,128,0,0,0,0,0,15,255,0,0,0,0,0,0,127,252,0,0,0,0,0,2,255,244,0,0,0,0,0,31,255,192,0,0,0,0,0,191,255,0,0,0,0,0,27,255,252,0,0,0,0,2,255,255,224,0,0,0,0,2,255,255,0,0,0,0,0,0,191,244,0,0,0,0,0,0,46,64,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30f0  ヰ
  240,48,34,35,59,40,3,253,0,0,0,0,0,21,64,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,234,255,234,170,191,250,171,192,0,0,127,128,0,47,208,0,0,0,0,127,128,0,47,208,0,0,0,0,127,128,0,47,208,0,0,0,0,127,128,0,47,208,0,0,0,0,127,128,0,47,208,0,0,0,0,127,128,0,47,208,0,0,0,0,127,128,0,47,208,0,0,0,0,127,128,0,47,208,0,0,0,0,127,128,0,47,208,0,0,0,0,127,128,0,47,208,0,0,0,0,127,128,0,47,208,0,0,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,21,64,0,0,
  // 0x30f1  ヱ
  241,48,34,28,252,40,3,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,208,11,255,255,255,255,255,255,255,192,11,255,255,255,255,255,255,255,64,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,31,248,0,0,0,0,15,248,0,63,240,0,0,0,0,15,248,0,255,192,0,0,0,0,15,248,3,255,64,0,0,0,0,15,244,15,254,0,0,0,0,0,15,244,63,248,0,0,0,0,0,15,244,11,224,0,0,0,0,0,15,244,1,128,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,84,0,0,0,0,0,0,0,16,
  // 0x30f2  ヲ
  242,48,30,32,0,40,6,253,255,255,255,255,255,255,253,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,192,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,128,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,2,254,0,0,0,0,0,0,3,253,0,63,255,255,255,255,255,252,0,63,255,255,255,255,255,252,0,63,255,255,255,255,255,248,0,47,234,170,170,170,191,240,0,0,0,0,0,0,47,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,255,192,0,0,0,0,0,2,255,64,0,0,0,0,0,7,255,0,0,0,0,0,0,31,252,0,0,0,0,0,0,127,244,0,0,0,0,0,2,255,224,0,0,0,0,0,11,255,128,0,0,0,0,0,127,254,0,0,0,0,0,7,255,244,0,0,0,0,0,127,255,208,0,0,0,0,27,255,254,0,0,0,0,0,191,255,244,0,0,0,0,0,47,255,64,0,0,0,0,0,11,244,0,0,0,0,0,0,2,0,0,0,0,0,0,
  // 0x30f3  ン
  243,48,32,31,248,40,5,255,0,128,0,0,0,0,0,0,3,244,0,0,0,0,0,0,15,254,0,0,0,0,0,0,31,255,128,0,0,0,0,0,3,255,240,0,0,0,0,0,0,191,253,0,0,0,0,0,0,31,255,64,0,0,0,16,0,7,255,208,0,0,0,52,0,0,255,244,0,0,0,188,0,0,63,224,0,0,0,254,0,0,15,128,0,0,3,255,0,0,1,0,0,0,11,254,0,0,0,0,0,0,31,252,0,0,0,0,0,0,63,244,0,0,0,0,0,0,255,224,0,0,0,0,0,3,255,192,0,0,0,0,0,15,255,0,0,0,0,0,0,63,252,0,0,0,0,0,1,255,244,0,0,0,0,0,11,255,192,0,0,0,0,0,63,255,0,0,0,0,0,1,255,252,0,0,0,0,0,31,255,224,0,0,0,0,1,255,255,64,0,0,0,0,47,255,252,0,0,0,0,27,255,255,208,0,0,0,27,255,255,254,0,0,0,0,127,255,255,224,0,0,0,0,63,255,253,0,0,0,0,0,15,255,128,0,0,0,0,0,7,144,0,0,0,0,0,0,
  // 0x30f4  ヴ
  244,48,34,38,86,40,4,253,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,125,0,0,0,0,0,0,0,116,63,0,0,0,0,191,192,1,252,47,128,0,0,0,127,192,0,190,15,208,0,0,0,127,192,0,63,7,240,0,0,0,127,192,0,47,131,224,0,0,0,127,192,0,15,192,0,0,0,0,127,192,0,5,0,0,0,0,0,127,192,0,0,0,0,255,255,255,255,255,255,255,224,0,255,255,255,255,255,255,255,248,0,191,255,255,255,255,255,255,248,0,191,234,170,170,170,170,191,244,0,191,64,0,0,0,0,47,240,0,191,64,0,0,0,0,47,240,0,191,64,0,0,0,0,63,224,0,191,64,0,0,0,0,63,208,0,191,64,0,0,0,0,127,192,0,191,64,0,0,0,0,191,192,0,191,64,0,0,0,0,255,128,0,255,64,0,0,0,1,255,64,0,255,64,0,0,0,3,255,0,0,0,0,0,0,0,7,254,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,31,248,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,0,255,208,0,0,0,0,0,0,7,255,128,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,191,252,0,0,0,0,0,0,7,255,240,0,0,0,0,0,0,191,255,192,0,0,0,0,0,111,255,254,0,0,0,0,0,2,255,255,240,0,0,0,0,0,0,255,255,64,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,14,0,0,0,0,0,0,
  // 0x30f5  ヵ
  245,48,26,29,203,40,6,252,0,0,6,164,0,0,0,0,0,11,244,0,0,0,0,0,11,244,0,0,0,0,0,7,244,0,0,0,0,0,11,244,0,0,0,0,0,11,240,0,0,0,58,170,175,250,170,170,64,63,255,255,255,255,255,240,63,255,255,255,255,255,240,63,255,255,255,255,255,240,0,0,15,224,0,15,240,0,0,15,224,0,15,240,0,0,31,208,0,15,240,0,0,47,192,0,15,240,0,0,63,192,0,15,240,0,0,63,128,0,15,224,0,0,191,64,0,15,224,0,0,255,0,0,15,224,0,2,254,0,0,31,208,0,3,253,0,0,31,208,0,11,252,0,0,47,192,0,47,240,0,0,63,192,0,191,224,0,0,63,192,2,255,192,0,0,191,128,11,255,0,15,235,255,64,127,252,0,15,255,255,0,63,240,0,15,255,253,0,11,128,0,11,255,244,0,1,0,0,0,0,0,0,
  // 0x30f6  ヶ
  246,48,30,30,240,40,5,251,0,0,164,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,255,0,0,0,0,0,0,2,255,0,0,0,0,0,0,3,253,0,0,0,0,0,0,3,252,0,0,0,0,0,0,11,254,170,170,170,170,128,0,31,255,255,255,255,255,208,0,63,255,255,255,255,255,208,0,191,255,255,255,255,255,208,1,255,64,0,127,128,0,0,3,255,0,0,191,64,0,0,15,252,0,0,191,64,0,0,63,244,0,0,255,0,0,0,255,224,0,0,255,0,0,0,191,192,0,1,255,0,0,0,15,0,0,2,254,0,0,0,0,0,0,3,252,0,0,0,0,0,0,11,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,63,240,0,0,0,0,0,0,127,224,0,0,0,0,0,1,255,192,0,0,0,0,0,7,255,64,0,0,0,0,0,31,254,0,0,0,0,0,0,191,248,0,0,0,0,0,3,255,224,0,0,0,0,0,0,255,128,0,0,0,0,0,0,45,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30f7  ヷ
  247,48,34,39,95,40,4,252,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,80,190,0,0,0,0,0,0,3,244,63,64,0,0,0,0,0,2,252,47,192,0,0,0,0,0,0,253,15,208,0,0,0,0,0,0,191,11,208,0,0,0,0,0,0,62,0,0,0,0,0,0,0,0,16,0,0,255,255,255,255,255,255,255,128,0,255,255,255,255,255,255,255,244,0,255,255,255,255,255,255,255,244,0,255,255,255,255,255,255,255,240,0,255,128,0,0,0,0,63,240,0,255,128,0,0,0,0,63,240,0,255,128,0,0,0,0,63,224,0,255,128,0,0,0,0,63,208,0,255,128,0,0,0,0,127,192,0,255,128,0,0,0,0,191,192,0,255,128,0,0,0,0,255,192,0,255,128,0,0,0,0,255,128,0,255,128,0,0,0,1,255,0,0,255,128,0,0,0,3,255,0,0,85,0,0,0,0,3,254,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,191,224,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,7,255,64,0,0,0,0,0,0,47,254,0,0,0,0,0,0,0,255,248,0,0,0,0,0,0,7,255,224,0,0,0,0,0,0,127,255,128,0,0,0,0,0,6,255,254,0,0,0,0,0,1,191,255,244,0,0,0,0,0,2,255,255,128,0,0,0,0,0,0,191,252,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,4,0,0,0,0,0,0,
  // 0x30f8  ヸ
  248,48,36,37,77,40,3,253,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,3,224,0,0,0,0,0,0,3,210,240,0,0,0,0,0,63,194,240,248,0,0,0,0,0,63,193,244,188,0,0,0,0,0,63,192,248,125,0,0,0,0,0,63,192,188,32,0,0,0,0,0,63,192,52,0,0,0,0,0,0,63,192,0,0,47,234,170,170,170,191,234,191,64,47,255,255,255,255,255,255,255,64,47,255,255,255,255,255,255,255,64,47,255,255,255,255,255,255,255,64,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,208,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,21,64,0,0,
  // 0x30f9  ヹ
  249,48,36,36,68,40,2,255,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,7,224,0,0,0,0,0,0,31,3,240,0,0,0,0,0,0,47,130,248,0,0,0,0,0,0,15,208,252,0,0,0,0,0,0,7,240,189,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,1,64,0,3,255,255,255,255,255,255,255,128,3,255,255,255,255,255,255,255,240,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,192,0,0,0,0,0,0,1,255,64,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,11,252,0,0,0,0,7,252,0,47,244,0,0,0,0,7,252,0,191,224,0,0,0,0,7,252,2,255,192,0,0,0,0,7,252,11,255,0,0,0,0,0,7,252,31,252,0,0,0,0,0,7,252,3,240,0,0,0,0,0,7,252,0,128,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,7,252,0,0,0,0,127,255,255,255,255,255,255,255,248,127,255,255,255,255,255,255,255,248,127,255,255,255,255,255,255,255,248,127,255,255,255,255,255,255,255,248,21,0,0,0,0,0,0,0,20,
  // 0x30fa  ヺ
  250,48,34,39,95,40,4,252,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,96,191,0,0,0,0,0,0,3,244,63,64,0,0,0,0,0,1,252,31,192,0,0,0,0,0,0,253,15,208,0,0,0,0,0,0,127,7,64,0,0,0,0,0,0,56,0,0,127,255,255,255,255,255,255,0,0,127,255,255,255,255,255,255,224,0,127,255,255,255,255,255,255,240,0,127,255,255,255,255,255,255,224,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,255,0,0,15,255,255,255,255,255,254,0,0,15,255,255,255,255,255,253,0,0,15,255,255,255,255,255,252,0,0,15,234,170,170,170,175,248,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,3,255,64,0,0,0,0,0,0,11,254,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,47,255,0,0,0,0,0,0,1,255,252,0,0,0,0,0,0,31,255,240,0,0,0,0,0,6,255,255,64,0,0,0,0,0,63,255,248,0,0,0,0,0,0,31,255,208,0,0,0,0,0,0,7,253,0,0,0,0,0,0,0,1,128,0,0,0,0,0,0,
  // 0x30fb  ・
  251,48,10,10,30,40,15,10,2,248,0,31,255,64,63,255,192,127,255,208,191,255,224,127,255,208,63,255,192,47,255,128,7,253,0,0,0,0,
  // 0x30fc  ー
  252,48,32,6,48,40,4,12,170,170,170,170,170,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
  // 0x30fd  ヽ
  253,48,19,20,100,40,11,4,2,0,0,0,0,15,208,0,0,0,127,244,0,0,0,127,253,0,0,0,15,255,64,0,0,3,255,208,0,0,0,255,244,0,0,0,63,253,0,0,0,15,255,0,0,0,3,255,192,0,0,0,255,240,0,0,0,63,252,0,0,0,31,254,0,0,0,11,255,128,0,0,2,255,208,0,0,0,255,240,0,0,0,63,252,0,0,0,31,248,0,0,0,11,208,0,0,0,2,0,
  // 0x30fe  ヾ
  254,48,22,26,156,40,10,3,0,0,0,0,28,0,0,0,0,0,191,0,0,0,1,240,63,64,0,0,3,248,31,192,0,0,0,253,15,224,0,0,0,191,7,240,7,128,0,63,66,208,47,224,0,31,192,0,191,248,0,13,0,0,47,254,0,0,0,0,11,255,128,0,0,0,2,255,224,0,0,0,0,191,248,0,0,0,0,47,254,0,0,0,0,11,255,128,0,0,0,2,255,208,0,0,0,0,191,244,0,0,0,0,63,252,0,0,0,0,15,255,0,0,0,0,3,255,192,0,0,0,1,255,224,0,0,0,0,191,244,0,0,0,0,47,252,0,0,0,0,15,244,0,0,0,0,7,192,0,0,0,0,1,0,0,
  // 0x30ff  ヿ
  255,48,25,34,238,40,7,253,127,255,255,255,255,255,128,127,255,255,255,255,255,128,127,255,255,255,255,255,128,63,255,255,255,255,255,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,106,128,
  // 0x4eee  仮
  238,78,38,38,124,40,1,252,0,0,4,0,0,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,0,63,193,170,170,170,170,170,64,0,0,191,67,255,255,255,255,255,128,0,0,255,3,255,255,255,255,255,128,0,2,254,3,255,255,255,255,255,128,0,3,252,3,248,0,0,0,0,0,0,11,248,3,248,0,0,0,0,0,0,31,240,3,248,0,0,0,0,0,0,63,208,3,248,0,0,0,0,0,0,191,208,3,248,0,0,0,0,0,1,255,208,3,248,0,0,0,0,0,3,255,208,3,248,0,0,0,0,0,15,255,208,3,255,255,255,255,253,0,63,255,208,3,255,255,255,255,255,0,255,239,208,3,255,255,255,255,254,0,191,143,208,3,255,245,85,86,253,0,63,15,208,3,255,244,0,2,252,0,44,15,208,3,251,248,0,3,252,0,0,15,208,3,250,252,0,7,248,0,0,15,208,3,244,254,0,11,240,0,0,15,208,7,244,191,0,15,240,0,0,15,208,7,244,127,128,47,208,0,0,15,208,11,240,63,192,63,192,0,0,15,208,11,240,31,240,191,64,0,0,15,208,15,240,11,245,255,0,0,0,15,208,15,224,3,255,253,0,0,0,15,208,31,224,2,255,252,0,0,0,15,208,47,208,0,255,240,0,0,0,15,208,63,192,0,191,240,0,0,0,15,208,63,128,2,255,252,0,0,0,15,208,127,64,15,255,255,64,0,0,15,208,255,0,127,250,255,224,0,0,15,209,255,2,255,224,127,254,0,0,15,211,253,47,255,64,15,255,224,0,15,215,252,47,253,0,2,255,192,0,15,208,244,15,224,0,0,63,64,0,10,128,32,2,0,0,0,6,0,
  // 0x540d  名
  13,84,35,38,86,40,1,252,0,0,0,46,144,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,255,255,255,255,0,0,0,0,31,255,255,255,255,192,0,0,0,63,255,255,255,255,128,0,0,1,255,213,85,85,255,0,0,0,7,255,0,0,2,255,0,0,0,31,252,0,0,3,253,0,0,0,191,253,0,0,15,248,0,0,7,255,255,128,0,31,240,0,0,47,255,255,240,0,63,208,0,0,63,248,63,252,0,255,192,0,0,15,208,11,255,3,255,0,0,0,6,0,2,255,203,253,0,0,0,0,0,0,127,255,244,0,0,0,0,0,0,31,255,224,0,0,0,0,0,0,11,255,128,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,191,255,255,255,255,244,0,0,7,255,255,255,255,255,244,0,0,63,255,255,255,255,255,244,0,2,255,254,85,85,85,91,244,0,111,255,254,0,0,0,7,244,11,255,254,254,0,0,0,7,244,127,255,224,254,0,0,0,7,244,47,254,0,254,0,0,0,7,244,15,208,0,254,0,0,0,7,244,5,0,0,254,0,0,0,7,244,0,0,0,254,0,0,0,7,244,0,0,0,254,0,0,0,7,244,0,0,0,254,85,85,85,91,244,0,0,0,255,255,255,255,255,244,0,0,0,255,255,255,255,255,244,0,0,0,255,255,255,255,255,244,0,0,0,254,0,0,0,7,244,0,0,0,169,0,0,0,7,244,
  // 0x5b9a  定
  154,91,37,38,124,40,1,252,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,6,170,170,170,191,234,170,170,169,0,11,255,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,255,254,0,11,240,0,0,0,0,0,0,254,0,11,240,0,0,0,0,0,0,254,0,11,240,0,0,0,0,0,0,254,0,11,240,0,0,0,0,0,0,254,0,11,240,170,170,170,170,170,160,254,0,11,240,255,255,255,255,255,244,254,0,0,0,255,255,255,255,255,244,0,0,0,0,255,255,255,255,255,244,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,1,253,0,63,192,0,0,0,0,0,2,253,0,63,192,0,0,0,0,0,3,252,0,63,192,0,0,0,0,0,3,252,0,63,255,255,255,64,0,0,3,248,0,63,255,255,255,64,0,0,7,248,0,63,255,255,255,64,0,0,11,252,0,63,213,85,85,0,0,0,15,253,0,63,192,0,0,0,0,0,31,255,0,63,192,0,0,0,0,0,47,255,128,63,192,0,0,0,0,0,127,255,224,63,192,0,0,0,0,0,255,143,248,63,192,0,0,0,0,1,255,7,255,127,192,0,0,0,0,3,254,1,255,255,192,0,0,0,0,15,252,0,127,255,255,234,170,170,128,63,244,0,15,255,255,255,255,255,128,127,208,0,0,191,255,255,255,255,0,15,128,0,0,5,175,255,255,255,0,2,0,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,34,38,86,40,2,252,0,0,0,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,192,0,1,253,0,0,0,0,63,255,255,255,255,255,255,224,0,63,255,255,255,255,255,255,240,0,63,255,255,255,255,255,255,240,0,63,255,255,255,255,255,255,240,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,191,255,255,255,255,255,64,0,0,191,255,255,255,255,255,64,0,0,255,0,0,0,0,191,64,0,0,255,0,0,0,0,191,64,0,0,255,0,0,0,0,191,64,0,2,254,0,0,0,0,191,64,0,3,253,0,0,0,0,191,64,0,7,252,0,0,0,0,191,64,0,11,248,0,0,0,0,191,64,0,15,244,0,0,0,0,191,64,0,63,240,0,0,0,0,191,64,0,191,208,0,0,0,0,191,64,0,255,192,0,0,0,0,191,64,0,191,0,0,0,0,0,191,64,0,45,0,0,0,0,0,191,64,0,8,0,0,0,0,0,191,64,0,
  // 0x793a  示
  58,121,36,35,59,40,2,252,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,170,170,170,170,170,170,170,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,191,255,255,255,255,255,255,255,254,106,170,170,170,255,170,170,170,169,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,2,64,0,255,0,1,128,0,0,11,244,0,255,0,31,208,0,0,15,240,0,255,0,31,240,0,0,47,240,0,255,0,15,248,0,0,63,208,0,255,0,3,253,0,0,191,192,0,255,0,2,255,0,0,255,64,0,255,0,0,255,128,3,255,0,0,255,0,0,127,192,11,252,0,0,255,0,0,63,224,31,248,0,0,255,0,0,31,240,63,240,0,0,255,0,0,15,248,255,192,0,0,255,0,0,7,252,191,64,0,0,255,0,0,3,252,30,0,0,0,255,0,0,2,224,0,0,47,255,255,0,0,0,0,0,0,31,255,255,0,0,0,0,0,0,15,255,252,0,0,0,0,0,0,11,254,144,0,0,0,0,
  // 0x7fa9  義
  169,127,37,38,124,40,2,252,0,0,25,0,0,0,165,0,0,0,0,0,255,0,0,0,255,0,0,0,0,0,127,192,0,2,254,0,0,0,0,0,47,208,0,3,252,0,0,0,11,255,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,255,240,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,170,170,170,255,170,170,170,0,0,0,255,255,255,255,255,255,255,0,0,0,255,255,255,255,255,255,255,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,255,0,0,0,0,0,191,255,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,255,254,0,0,0,0,26,0,0,1,0,0,0,0,21,175,255,194,252,11,208,0,0,63,255,255,255,226,252,47,253,0,0,47,255,255,229,2,252,7,255,192,0,0,0,191,0,1,252,0,127,208,0,0,0,191,0,0,253,0,7,64,0,191,255,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,255,255,0,191,255,255,255,255,255,255,255,255,0,0,0,191,0,0,63,128,20,0,0,0,0,191,0,0,63,192,63,128,0,0,0,191,171,248,47,208,255,0,0,106,255,255,255,248,15,231,252,0,0,191,255,255,255,228,11,255,244,0,0,191,255,255,0,0,7,255,192,24,0,0,0,191,0,0,47,255,0,47,64,0,0,191,0,6,255,255,192,63,64,0,0,191,1,191,255,191,249,191,0,3,255,255,7,255,248,15,255,255,0,1,255,254,2,255,64,2,255,253,0,0,255,164,0,224,0,0,47,244,0,
  // 0x8868  表
  104,136,38,38,124,40,1,252,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,3,255,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,255,252,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,63,255,255,255,255,255,255,224,0,0,63,255,255,255,255,255,255,224,0,0,63,255,255,255,255,255,255,224,0,0,0,0,0,63,192,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,0,63,192,0,0,0,0,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,255,64,0,0,0,15,255,252,0,0,0,0,0,0,0,127,241,253,0,0,144,0,0,0,7,255,192,254,0,3,248,0,0,0,47,254,0,191,0,31,253,0,0,2,255,244,0,63,128,191,240,0,0,127,255,224,0,47,195,255,128,0,27,255,255,224,0,31,255,253,0,0,127,255,223,224,0,15,255,224,0,0,47,248,15,224,0,3,255,0,0,0,15,128,15,224,0,2,255,0,0,0,0,0,15,224,0,0,255,192,0,0,0,0,15,224,0,108,63,244,0,0,0,0,15,224,111,252,31,254,0,0,0,0,15,255,255,253,7,255,208,0,0,1,191,255,255,248,0,255,253,0,0,127,255,255,249,0,0,63,255,208,0,63,255,249,0,0,0,7,255,128,0,63,249,0,0,0,0,0,191,0,0,25,0,0,0,0,0,0,5,0,
};

#endif // HAS_GRAPHICAL_TFT
