/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium 40pt, capital 'A' height: 29px, width: 100%, range: 0x0020-0x00ff
extern const uint8_t NotoSans_Medium_29[25485] = {
  130,29,32,0,255,0,38,246, // unifont_t
  // 0x0020 " "
  0,0,0,10,0,0,
  // 0x0021  !
  5,30,60,11,3,255,170,128,255,192,255,192,255,192,255,192,255,128,191,128,191,128,191,128,191,128,191,64,127,64,127,64,127,64,127,64,127,0,63,0,63,0,63,0,63,0,42,0,0,0,0,0,0,0,127,64,255,192,255,192,255,192,191,128,25,0,
  // 0x0022  "
  13,11,44,17,2,18,42,64,106,64,127,192,191,64,63,128,191,64,63,128,191,0,63,128,127,0,63,64,127,0,63,64,127,0,63,64,127,0,63,64,63,0,47,0,63,0,31,0,62,0,
  // 0x0023  #
  24,29,174,26,1,0,0,0,42,0,26,0,0,0,127,0,63,64,0,0,190,0,63,0,0,0,253,0,127,0,0,0,253,0,126,0,0,0,252,0,190,0,0,1,252,0,253,0,0,2,248,0,252,0,0,3,248,1,252,0,47,255,255,255,255,255,47,255,255,255,255,255,31,255,255,255,255,254,0,7,224,3,240,0,0,11,224,7,240,0,0,15,208,7,240,0,0,15,192,11,224,0,0,31,192,15,208,0,85,111,213,95,213,80,255,255,255,255,255,244,255,255,255,255,255,244,255,255,255,255,255,244,0,127,0,63,64,0,0,127,0,63,0,0,0,190,0,127,0,0,0,253,0,127,0,0,0,252,0,190,0,0,0,252,0,253,0,0,1,252,0,252,0,0,2,248,0,252,0,0,
  // 0x0024  $
  19,34,170,23,2,253,0,0,84,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,47,255,233,0,2,255,255,255,224,15,255,255,255,224,63,254,254,255,208,127,208,248,6,192,191,128,248,0,0,191,64,248,0,0,191,128,248,0,0,191,192,248,0,0,63,248,248,0,0,47,255,248,0,0,7,255,255,64,0,0,191,255,248,0,0,11,255,255,128,0,0,255,255,224,0,0,249,191,240,0,0,248,15,248,0,0,248,11,252,0,0,248,7,252,0,0,248,11,248,164,0,248,31,244,191,233,254,255,240,191,255,255,255,192,191,255,255,254,0,6,255,255,144,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,80,0,0,
  // 0x0025  %
  31,30,240,34,2,255,2,254,64,0,0,42,64,0,15,255,224,0,0,127,0,0,63,255,248,0,0,254,0,0,127,131,252,0,2,252,0,0,191,0,253,0,3,244,0,0,254,0,254,0,11,240,0,0,253,0,191,0,15,208,0,0,253,0,127,0,63,192,0,0,252,0,127,0,127,0,0,0,252,0,127,0,254,0,0,0,253,0,127,1,252,0,0,0,253,0,191,3,248,5,80,0,254,0,254,11,240,127,253,0,191,0,253,15,209,255,255,64,63,131,252,47,195,254,191,192,47,255,248,63,71,244,15,224,15,255,224,255,11,240,11,240,1,254,65,253,15,224,7,240,0,0,3,248,15,224,7,240,0,0,7,240,15,224,3,244,0,0,15,224,15,208,3,244,0,0,47,192,15,224,3,244,0,0,63,64,15,224,7,240,0,0,191,0,15,224,7,240,0,0,253,0,11,240,11,240,0,2,252,0,3,244,31,224,0,7,244,0,2,254,191,192,0,15,224,0,0,255,255,64,0,31,192,0,0,63,253,0,0,0,0,0,0,1,64,0,
  // 0x0026  &
  27,30,210,29,2,255,0,6,255,144,0,0,0,0,63,255,253,0,0,0,0,255,255,255,64,0,0,3,255,150,255,192,0,0,3,253,0,127,208,0,0,7,252,0,63,208,0,0,7,248,0,47,208,0,0,7,252,0,63,208,0,0,3,252,0,127,192,0,0,2,254,0,255,128,0,0,0,255,71,255,0,0,0,0,127,255,252,0,0,0,0,47,255,224,0,0,0,0,47,255,64,0,0,0,1,255,255,64,0,26,144,7,255,255,224,0,63,224,31,253,63,248,0,63,192,63,240,15,254,0,127,192,191,192,3,255,128,255,64,255,128,0,255,225,255,0,255,64,0,47,251,253,0,255,64,0,11,255,252,0,255,128,0,2,255,240,0,255,192,0,0,255,240,0,191,240,0,11,255,252,0,63,254,85,191,255,255,0,31,255,255,255,242,255,192,7,255,255,255,128,191,240,0,127,255,248,0,47,252,0,1,84,0,0,0,0,
  // 0x0027  '
  5,11,22,9,2,18,42,64,127,192,63,128,63,128,63,128,63,64,63,64,63,64,63,64,47,0,31,0,
  // 0x0028  (
  10,36,108,12,1,249,0,6,160,0,31,224,0,63,192,0,191,64,0,255,0,2,253,0,3,252,0,11,248,0,15,240,0,15,240,0,31,224,0,47,208,0,63,192,0,63,192,0,63,192,0,127,128,0,127,128,0,127,128,0,127,128,0,127,128,0,127,192,0,63,192,0,63,192,0,63,192,0,47,208,0,31,224,0,15,240,0,15,240,0,11,248,0,3,252,0,2,253,0,0,255,0,0,191,64,0,63,192,0,15,224,0,1,80,
  // 0x0029  )
  10,36,108,12,1,249,106,0,0,63,192,0,31,224,0,15,240,0,7,248,0,3,252,0,1,254,0,0,255,0,0,191,64,0,127,128,0,63,192,0,63,192,0,47,208,0,47,224,0,31,224,0,31,240,0,31,240,0,15,240,0,15,240,0,31,240,0,31,240,0,31,224,0,47,224,0,47,208,0,63,192,0,63,192,0,127,128,0,191,64,0,255,0,1,254,0,3,252,0,7,248,0,15,240,0,47,208,0,63,128,0,21,0,0,
  // 0x002a  *
  20,19,95,22,1,12,0,0,85,0,0,0,0,255,0,0,0,0,255,0,0,0,0,254,0,0,0,0,254,0,0,0,0,190,0,0,57,0,189,0,108,63,244,125,47,252,63,255,255,255,252,127,255,255,255,253,1,91,255,165,64,0,3,255,192,0,0,15,239,224,0,0,47,199,244,0,0,127,195,252,0,0,255,65,255,0,2,255,0,255,128,0,189,0,126,0,0,8,0,32,0,
  // 0x002b  +
  19,20,100,23,2,4,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,170,171,254,170,168,255,255,255,255,252,255,255,255,255,252,170,170,254,170,164,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,168,0,0,
  // 0x002c  ,
  7,11,22,11,1,250,6,168,11,252,15,248,15,240,15,240,31,224,47,192,63,128,63,64,127,0,0,0,
  // 0x002d  -
  11,5,15,13,1,8,106,170,160,191,255,244,191,255,244,191,255,244,0,0,0,
  // 0x002e  .
  5,6,12,11,3,255,127,64,255,192,255,192,255,192,191,128,25,0,
  // 0x002f  /
  15,29,116,15,0,0,0,0,2,168,0,0,7,248,0,0,15,244,0,0,15,240,0,0,47,224,0,0,63,192,0,0,127,192,0,0,191,64,0,0,255,0,0,1,254,0,0,3,253,0,0,3,252,0,0,7,248,0,0,15,240,0,0,15,240,0,0,47,208,0,0,63,192,0,0,127,128,0,0,191,64,0,0,255,0,0,1,254,0,0,3,252,0,0,3,252,0,0,11,244,0,0,15,240,0,0,31,224,0,0,47,208,0,0,63,192,0,0,127,128,0,0,
  // 0x0030  0
  19,30,150,23,2,255,0,11,255,64,0,0,191,255,244,0,3,255,255,254,0,11,255,171,255,64,31,248,0,255,192,63,224,0,63,208,63,192,0,31,240,127,192,0,15,240,191,128,0,15,244,255,64,0,11,248,255,64,0,7,252,255,0,0,7,252,255,0,0,7,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,7,252,255,0,0,7,252,255,0,0,7,252,255,64,0,11,248,191,128,0,11,248,127,128,0,15,244,63,192,0,31,240,63,208,0,47,240,31,240,0,127,208,15,254,70,255,192,3,255,255,255,0,0,255,255,252,0,0,47,255,224,0,0,0,84,0,0,
  // 0x0031  1
  12,29,87,23,3,0,0,0,169,0,3,255,0,31,255,0,191,255,2,255,255,15,253,255,127,240,255,127,193,255,30,1,255,4,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,
  // 0x0032  2
  19,29,145,23,2,0,0,27,254,128,0,2,255,255,248,0,31,255,255,255,0,191,255,175,255,192,127,208,0,255,208,30,0,0,63,224,0,0,0,47,240,0,0,0,31,240,0,0,0,31,240,0,0,0,31,240,0,0,0,63,224,0,0,0,63,192,0,0,0,255,128,0,0,1,255,0,0,0,7,253,0,0,0,15,248,0,0,0,63,224,0,0,0,255,192,0,0,3,255,0,0,0,15,252,0,0,0,63,240,0,0,0,255,192,0,0,3,254,0,0,0,15,248,0,0,0,63,224,0,0,0,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,
  // 0x0033  3
  20,30,150,23,1,255,0,27,255,160,0,2,255,255,254,0,31,255,255,255,192,63,255,171,255,240,15,208,0,47,244,6,0,0,15,248,0,0,0,11,252,0,0,0,7,252,0,0,0,7,252,0,0,0,15,248,0,0,0,31,240,0,0,0,191,208,0,21,175,255,64,0,63,255,244,0,0,63,255,249,0,0,63,255,255,192,0,0,1,191,244,0,0,0,15,252,0,0,0,3,253,0,0,0,3,254,0,0,0,2,255,0,0,0,2,255,0,0,0,3,254,0,0,0,7,253,96,0,0,31,252,127,148,5,255,244,127,255,255,255,224,127,255,255,255,64,11,255,255,244,0,0,5,84,0,0,
  // 0x0034  4
  21,29,174,23,1,0,0,0,0,42,128,0,0,0,0,255,192,0,0,0,2,255,192,0,0,0,7,255,192,0,0,0,15,255,192,0,0,0,47,255,192,0,0,0,127,127,192,0,0,0,255,63,192,0,0,2,252,63,192,0,0,7,244,63,192,0,0,15,224,63,192,0,0,63,192,63,192,0,0,127,64,63,192,0,0,254,0,63,192,0,3,252,0,63,192,0,11,244,0,63,192,0,31,224,0,63,192,0,63,192,0,63,192,0,191,0,0,63,192,0,255,255,255,255,255,192,255,255,255,255,255,192,255,255,255,255,255,192,170,170,170,191,234,128,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,
  // 0x0035  5
  19,30,150,23,2,255,10,170,170,170,64,15,255,255,255,192,15,255,255,255,192,15,255,255,255,192,15,240,0,0,0,31,224,0,0,0,31,224,0,0,0,31,208,0,0,0,47,208,0,0,0,47,208,0,0,0,47,192,0,0,0,63,218,170,64,0,63,255,255,248,0,63,255,255,255,0,47,255,255,255,192,1,0,1,255,224,0,0,0,63,240,0,0,0,15,244,0,0,0,15,248,0,0,0,11,248,0,0,0,11,248,0,0,0,11,248,0,0,0,15,244,0,0,0,47,240,144,0,0,191,224,191,144,27,255,192,191,255,255,255,0,191,255,255,252,0,27,255,255,144,0,0,21,80,0,0,
  // 0x0036  6
  19,30,150,23,2,255,0,0,27,255,128,0,7,255,255,192,0,47,255,255,192,0,255,254,170,192,3,255,128,0,0,11,253,0,0,0,15,244,0,0,0,47,224,0,0,0,63,192,0,0,0,63,192,0,0,0,127,128,0,0,0,191,65,255,228,0,255,79,255,255,0,255,127,255,255,192,255,255,85,255,240,255,244,0,47,244,255,192,0,15,248,255,128,0,7,252,255,64,0,3,252,255,64,0,3,252,191,64,0,3,252,191,128,0,3,252,127,192,0,7,252,63,224,0,15,248,31,244,0,47,240,15,254,65,255,224,3,255,255,255,192,0,255,255,255,0,0,31,255,244,0,0,0,85,0,0,
  // 0x0037  7
  20,29,145,23,1,0,42,170,170,170,170,127,255,255,255,255,127,255,255,255,255,127,255,255,255,255,0,0,0,2,254,0,0,0,3,252,0,0,0,7,252,0,0,0,15,244,0,0,0,31,240,0,0,0,63,208,0,0,0,127,192,0,0,0,255,128,0,0,1,255,0,0,0,2,254,0,0,0,3,252,0,0,0,11,252,0,0,0,15,244,0,0,0,47,240,0,0,0,63,208,0,0,0,127,192,0,0,0,255,128,0,0,1,255,0,0,0,3,254,0,0,0,7,252,0,0,0,15,252,0,0,0,15,244,0,0,0,47,240,0,0,0,63,208,0,0,0,191,192,0,0,
  // 0x0038  8
  19,30,150,23,2,255,0,27,255,144,0,1,255,255,253,0,7,255,255,255,64,31,254,90,255,192,63,240,0,127,224,63,192,0,31,240,127,192,0,15,240,63,192,0,15,240,63,192,0,15,240,63,224,0,47,224,31,248,0,191,192,11,255,71,255,0,2,255,255,252,0,0,127,255,208,0,0,127,255,224,0,2,255,255,253,0,15,254,11,255,128,63,240,0,191,224,127,192,0,31,244,255,64,0,11,248,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,7,252,191,192,0,15,248,127,244,0,127,240,47,255,255,255,192,7,255,255,255,0,0,191,255,244,0,0,1,84,0,0,
  // 0x0039  9
  19,30,150,23,2,255,0,27,254,64,0,1,255,255,244,0,7,255,255,253,0,31,255,175,255,64,63,240,0,255,192,127,192,0,63,224,255,128,0,31,240,255,0,0,15,244,255,0,0,11,248,255,0,0,7,252,255,0,0,7,252,255,0,0,7,252,255,64,0,15,252,191,192,0,47,252,63,244,1,255,252,47,255,255,251,252,11,255,255,215,252,1,255,255,71,248,0,6,148,11,244,0,0,0,15,244,0,0,0,15,240,0,0,0,31,224,0,0,0,63,192,0,0,0,255,128,0,0,3,255,0,4,0,111,253,0,15,255,255,244,0,15,255,255,192,0,15,255,249,0,0,1,85,0,0,0,
  // 0x003a  :
  5,23,46,11,3,255,127,64,255,192,255,192,255,192,255,128,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,64,255,192,255,192,255,192,191,128,25,0,
  // 0x003b  ;
  7,28,56,11,1,250,7,240,15,252,31,252,31,252,15,248,2,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,164,15,248,15,244,31,240,31,224,47,208,63,192,63,64,127,0,190,0,0,0,
  // 0x003c  <
  19,21,105,23,2,4,0,0,0,0,4,0,0,0,0,124,0,0,0,7,252,0,0,0,127,252,0,0,7,255,224,0,0,127,254,0,0,7,255,224,0,0,127,254,0,0,7,255,208,0,0,127,253,0,0,0,255,208,0,0,0,255,224,0,0,0,127,255,64,0,0,7,255,248,0,0,0,47,255,144,0,0,2,255,253,0,0,0,31,255,224,0,0,1,191,252,0,0,0,11,252,0,0,0,0,124,0,0,0,0,4,
  // 0x003d  =
  19,12,60,23,2,8,170,170,170,170,164,255,255,255,255,248,255,255,255,255,248,170,170,170,170,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,248,255,255,255,255,248,255,255,255,255,248,85,85,85,85,84,
  // 0x003e  >
  19,20,100,23,2,4,224,0,0,0,0,254,0,0,0,0,255,224,0,0,0,127,254,0,0,0,6,255,224,0,0,0,47,254,0,0,0,2,255,224,0,0,0,47,255,64,0,0,2,255,244,0,0,0,31,252,0,0,0,47,252,0,0,7,255,244,0,0,191,254,64,0,27,255,224,0,1,255,253,0,0,47,255,208,0,0,255,248,0,0,0,255,128,0,0,0,244,0,0,0,0,64,0,0,0,0,
  // 0x003f  ?
  17,30,150,18,0,255,0,111,254,64,0,31,255,255,240,0,127,255,255,252,0,63,254,175,255,0,46,64,1,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,127,128,0,0,0,255,64,0,0,2,255,0,0,0,11,253,0,0,0,47,244,0,0,0,255,208,0,0,3,255,64,0,0,11,252,0,0,0,15,240,0,0,0,31,208,0,0,0,31,192,0,0,0,31,192,0,0,0,10,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,208,0,0,0,63,240,0,0,0,63,240,0,0,0,63,240,0,0,0,47,224,0,0,0,6,64,0,0,
  // 0x0040  @
  32,33,8,36,2,252,0,0,0,5,165,0,0,0,0,0,6,255,255,249,0,0,0,0,127,255,255,255,208,0,0,3,255,250,86,255,248,0,0,31,253,0,0,11,255,0,0,127,208,0,0,0,191,128,0,255,0,0,0,0,47,208,3,252,0,0,0,0,11,240,7,240,0,27,254,144,3,248,15,224,0,255,255,252,2,252,31,192,7,255,255,252,0,252,63,128,15,244,2,252,0,253,63,0,63,192,1,252,0,190,127,0,127,64,1,252,0,190,191,0,191,0,2,252,0,190,190,0,254,0,2,252,0,190,190,0,254,0,2,252,0,190,254,0,254,0,3,252,0,253,190,0,254,0,3,252,0,252,190,0,191,0,7,252,1,252,191,0,127,64,15,252,3,244,127,0,63,224,127,190,31,240,63,0,31,255,253,63,255,208,63,128,7,255,244,31,255,64,47,192,0,106,64,2,164,0,15,240,0,0,0,0,0,0,7,248,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,255,224,0,0,27,0,0,0,47,255,169,107,255,0,0,0,7,255,255,255,255,0,0,0,0,111,255,255,228,0,0,0,0,0,86,84,0,0,0,
  // 0x0041  A
  26,29,203,26,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x0042  B
  20,29,145,26,4,0,170,170,165,0,0,255,255,255,249,0,255,255,255,255,192,255,255,255,255,240,255,0,1,191,248,255,0,0,31,252,255,0,0,11,252,255,0,0,7,252,255,0,0,7,252,255,0,0,7,252,255,0,0,15,248,255,0,0,47,240,255,170,171,255,192,255,255,255,249,0,255,255,255,254,0,255,255,255,255,224,255,0,0,111,248,255,0,0,11,253,255,0,0,3,255,255,0,0,2,255,255,0,0,1,255,255,0,0,2,255,255,0,0,3,255,255,0,0,7,254,255,0,0,31,253,255,170,171,255,248,255,255,255,255,224,255,255,255,255,64,255,255,255,228,0,
  // 0x0043  C
  22,30,180,25,2,255,0,0,27,255,228,0,0,2,255,255,255,208,0,31,255,255,255,224,0,127,255,255,255,208,1,255,244,0,27,192,3,255,128,0,0,0,11,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,127,208,0,0,0,0,63,224,0,0,0,0,63,240,0,0,0,0,47,244,0,0,0,0,15,252,0,0,0,0,11,255,0,0,0,0,3,255,208,0,0,64,1,255,254,85,175,192,0,127,255,255,255,192,0,15,255,255,255,192,0,1,191,255,254,64,0,0,1,85,0,0,
  // 0x0044  D
  23,29,174,29,4,0,170,170,165,0,0,0,255,255,255,248,0,0,255,255,255,255,192,0,255,255,255,255,244,0,255,0,1,191,253,0,255,0,0,11,255,64,255,0,0,1,255,192,255,0,0,0,191,224,255,0,0,0,63,240,255,0,0,0,31,244,255,0,0,0,15,248,255,0,0,0,15,248,255,0,0,0,11,252,255,0,0,0,11,252,255,0,0,0,11,252,255,0,0,0,11,252,255,0,0,0,11,252,255,0,0,0,15,248,255,0,0,0,15,248,255,0,0,0,31,244,255,0,0,0,63,240,255,0,0,0,127,224,255,0,0,0,255,192,255,0,0,7,255,64,255,0,0,127,254,0,255,170,191,255,248,0,255,255,255,255,208,0,255,255,255,253,0,0,255,255,254,64,0,0,
  // 0x0045  E
  16,29,116,22,4,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0046  F
  16,29,116,21,4,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,170,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,
  // 0x0047  G
  24,30,180,29,2,255,0,0,6,255,250,64,0,1,191,255,255,249,0,11,255,255,255,253,0,63,255,255,255,252,0,255,249,0,1,184,3,255,192,0,0,0,11,255,0,0,0,0,15,252,0,0,0,0,47,244,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,5,85,85,191,192,0,31,255,255,191,192,0,31,255,255,127,192,0,31,255,255,127,192,0,5,86,255,127,208,0,0,0,255,63,224,0,0,0,255,63,240,0,0,0,255,31,244,0,0,0,255,15,252,0,0,0,255,11,255,0,0,0,255,3,255,208,0,0,255,0,255,254,85,91,255,0,63,255,255,255,255,0,11,255,255,255,255,0,0,191,255,255,228,0,0,0,85,64,0,
  // 0x0048  H
  22,29,174,30,4,0,170,0,0,0,10,160,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,234,170,170,191,240,255,255,255,255,255,240,255,255,255,255,255,240,255,255,255,255,255,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,255,0,0,0,15,240,
  // 0x0049  I
  12,29,87,14,1,0,106,170,169,127,255,254,127,255,254,11,255,228,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,1,255,128,127,255,253,127,255,254,127,255,254,
  // 0x004a  J
  11,37,111,12,253,248,0,2,168,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,7,252,0,11,252,0,15,248,0,63,240,255,255,224,255,255,192,255,254,0,111,160,0,
  // 0x004b  K
  21,29,174,25,4,0,170,0,0,0,170,64,255,0,0,3,255,0,255,0,0,15,252,0,255,0,0,47,244,0,255,0,0,127,208,0,255,0,1,255,128,0,255,0,3,254,0,0,255,0,15,252,0,0,255,0,63,240,0,0,255,0,255,192,0,0,255,2,255,0,0,0,255,11,253,0,0,0,255,31,244,0,0,0,255,127,244,0,0,0,255,255,252,0,0,0,255,255,255,0,0,0,255,242,255,128,0,0,255,192,255,208,0,0,255,0,63,240,0,0,255,0,31,248,0,0,255,0,15,253,0,0,255,0,3,255,0,0,255,0,1,255,128,0,255,0,0,191,208,0,255,0,0,63,240,0,255,0,0,15,252,0,255,0,0,11,254,0,255,0,0,3,255,0,255,0,0,0,255,192,
  // 0x004c  L
  17,29,145,21,4,0,170,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,234,170,170,0,255,255,255,255,64,255,255,255,255,64,255,255,255,255,64,
  // 0x004d  M
  29,29,232,37,4,0,170,160,0,0,0,2,170,128,255,244,0,0,0,11,255,192,255,248,0,0,0,15,255,192,255,252,0,0,0,31,255,192,255,253,0,0,0,47,255,192,254,255,0,0,0,63,191,192,254,255,0,0,0,127,127,192,254,127,64,0,0,255,63,192,254,63,192,0,0,253,63,192,254,47,192,0,2,252,63,192,254,31,224,0,3,248,63,192,254,15,240,0,7,244,127,192,254,11,244,0,11,240,127,192,254,7,248,0,15,224,127,192,254,3,252,0,31,208,127,192,254,2,253,0,63,192,127,192,254,0,254,0,63,128,127,192,254,0,255,0,191,0,127,192,254,0,191,64,255,0,127,192,254,0,63,193,253,0,127,192,254,0,63,194,252,0,127,192,254,0,31,211,248,0,127,192,254,0,15,247,244,0,127,192,254,0,11,255,240,0,127,192,254,0,7,255,224,0,127,192,254,0,3,255,192,0,127,192,254,0,2,255,192,0,127,192,254,0,1,255,128,0,127,192,254,0,0,255,0,0,127,192,
  // 0x004e  N
  23,29,174,31,4,0,170,128,0,0,1,168,255,224,0,0,3,252,255,244,0,0,3,252,255,252,0,0,3,252,255,254,0,0,3,252,255,255,0,0,3,252,254,255,192,0,3,252,253,127,208,0,3,252,254,63,240,0,3,252,254,15,248,0,3,252,254,11,253,0,3,252,254,3,255,0,3,252,254,1,255,128,3,252,254,0,191,192,3,252,254,0,63,240,3,252,254,0,31,244,3,252,254,0,15,252,2,252,254,0,3,254,2,252,254,0,2,255,66,252,254,0,0,255,194,252,254,0,0,127,226,252,254,0,0,47,242,252,254,0,0,15,254,252,254,0,0,7,255,252,254,0,0,3,255,252,254,0,0,0,255,252,254,0,0,0,191,252,254,0,0,0,63,252,254,0,0,0,31,252,
  // 0x004f  O
  27,30,210,31,2,255,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x0050  P
  19,29,145,24,4,0,170,170,148,0,0,255,255,255,224,0,255,255,255,254,0,255,255,255,255,128,255,0,7,255,208,255,0,0,127,240,255,0,0,47,240,255,0,0,15,244,255,0,0,15,244,255,0,0,15,244,255,0,0,15,244,255,0,0,31,240,255,0,0,63,240,255,0,1,255,208,255,150,175,255,192,255,255,255,255,0,255,255,255,248,0,255,255,254,64,0,255,64,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,
  // 0x0051  Q
  27,36,252,31,2,249,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,248,0,0,11,255,255,255,208,0,0,0,191,255,253,0,0,0,0,1,87,255,0,0,0,0,0,1,255,192,0,0,0,0,0,191,240,0,0,0,0,0,63,252,0,0,0,0,0,15,254,0,0,0,0,0,3,255,128,0,0,0,0,1,255,208,
  // 0x0052  R
  21,29,174,25,4,0,170,170,148,0,0,0,255,255,255,228,0,0,255,255,255,254,0,0,255,255,255,255,192,0,255,0,22,255,224,0,255,0,0,127,240,0,255,0,0,31,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,15,244,0,255,0,0,47,240,0,255,0,0,127,224,0,255,64,23,255,192,0,255,255,255,255,0,0,255,255,255,248,0,0,255,255,255,192,0,0,255,149,127,224,0,0,255,0,31,244,0,0,255,0,11,252,0,0,255,0,3,254,0,0,255,0,2,255,0,0,255,0,0,255,192,0,255,0,0,127,208,0,255,0,0,47,240,0,255,0,0,15,248,0,255,0,0,11,253,0,255,0,0,3,255,0,255,0,0,1,255,128,
  // 0x0053  S
  18,30,150,22,2,255,0,27,255,164,0,1,255,255,255,128,11,255,255,255,208,31,255,255,255,192,63,244,0,27,128,127,208,0,0,0,191,192,0,0,0,191,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,240,0,0,0,47,253,0,0,0,15,255,224,0,0,3,255,254,0,0,0,191,255,224,0,0,11,255,253,0,0,0,127,255,64,0,0,7,255,192,0,0,0,191,224,0,0,0,47,240,0,0,0,31,240,0,0,0,15,240,0,0,0,15,240,0,0,0,47,240,224,0,0,127,224,255,165,91,255,192,255,255,255,255,0,255,255,255,252,0,47,255,255,144,0,0,21,80,0,0,
  // 0x0054  T
  22,29,174,23,0,0,106,170,170,170,170,160,127,255,255,255,255,240,127,255,255,255,255,240,127,255,255,255,255,240,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,
  // 0x0055  U
  23,30,180,30,3,255,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x0056  V
  25,29,203,25,0,0,170,64,0,0,0,170,64,191,192,0,0,0,255,0,127,192,0,0,2,255,0,63,208,0,0,3,254,0,47,240,0,0,7,252,0,15,240,0,0,11,252,0,15,248,0,0,15,244,0,11,252,0,0,31,240,0,3,252,0,0,47,224,0,3,254,0,0,63,208,0,1,255,0,0,127,192,0,0,255,0,0,191,128,0,0,255,128,0,255,64,0,0,127,192,1,255,0,0,0,63,192,2,254,0,0,0,47,224,3,253,0,0,0,31,240,7,252,0,0,0,15,244,11,248,0,0,0,11,248,15,240,0,0,0,7,252,31,240,0,0,0,3,253,47,224,0,0,0,2,254,63,192,0,0,0,0,255,127,192,0,0,0,0,255,191,64,0,0,0,0,191,255,0,0,0,0,0,63,254,0,0,0,0,0,63,253,0,0,0,0,0,31,252,0,0,0,0,0,15,248,0,0,0,
  // 0x0057  W
  37,29,34,38,0,0,106,64,0,0,106,128,0,0,42,128,127,192,0,0,191,192,0,0,127,192,63,208,0,0,255,208,0,0,191,128,63,224,0,1,255,240,0,0,255,64,47,240,0,2,255,240,0,0,255,0,31,240,0,3,255,244,0,1,255,0,15,244,0,3,251,248,0,2,254,0,15,248,0,7,247,252,0,3,253,0,11,252,0,11,242,252,0,3,252,0,7,252,0,15,241,254,0,7,252,0,3,253,0,31,224,255,0,11,248,0,3,254,0,47,208,255,0,15,244,0,2,255,0,63,192,191,64,15,240,0,1,255,0,63,192,127,128,31,240,0,0,255,64,127,128,63,192,47,224,0,0,191,128,191,0,47,192,63,208,0,0,127,192,255,0,31,224,63,192,0,0,63,193,254,0,15,240,127,192,0,0,63,194,253,0,15,240,191,128,0,0,47,211,252,0,11,244,255,64,0,0,31,227,252,0,7,248,255,0,0,0,15,243,248,0,3,252,254,0,0,0,15,247,240,0,2,253,253,0,0,0,11,255,240,0,1,254,252,0,0,0,7,255,224,0,0,255,252,0,0,0,3,255,208,0,0,255,248,0,0,0,3,255,192,0,0,191,244,0,0,0,2,255,192,0,0,127,240,0,0,0,1,255,128,0,0,63,240,0,0,
  // 0x0058  X
  24,29,174,24,0,0,42,144,0,0,2,168,47,240,0,0,11,252,15,252,0,0,31,244,7,253,0,0,63,224,2,255,0,0,191,192,0,255,128,0,255,64,0,127,192,3,254,0,0,47,240,7,252,0,0,15,244,15,244,0,0,7,252,47,224,0,0,3,254,63,192,0,0,0,255,255,64,0,0,0,127,255,0,0,0,0,63,252,0,0,0,0,47,252,0,0,0,0,127,254,0,0,0,0,255,255,0,0,0,2,255,191,192,0,0,3,252,63,208,0,0,15,248,31,240,0,0,31,240,15,252,0,0,63,208,3,253,0,0,191,128,2,255,0,1,255,0,0,255,128,3,253,0,0,127,208,11,252,0,0,63,240,31,244,0,0,15,248,63,224,0,0,11,253,191,192,0,0,3,255,
  // 0x0059  Y
  23,29,174,23,0,0,106,64,0,0,6,168,127,192,0,0,15,248,63,240,0,0,31,240,31,244,0,0,63,224,15,252,0,0,127,192,7,253,0,0,255,128,2,255,0,1,255,0,0,255,64,3,253,0,0,191,192,11,252,0,0,63,208,15,244,0,0,47,240,47,240,0,0,15,244,63,208,0,0,7,252,191,128,0,0,3,254,255,0,0,0,1,255,254,0,0,0,0,255,252,0,0,0,0,127,248,0,0,0,0,63,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,
  // 0x005a  Z
  21,29,174,23,1,0,42,170,170,170,170,0,63,255,255,255,255,0,63,255,255,255,255,0,63,255,255,255,255,0,0,0,0,7,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,224,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,208,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,253,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,208,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,7,253,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,127,250,170,170,170,64,191,255,255,255,255,128,191,255,255,255,255,128,191,255,255,255,255,128,
  // 0x005b  [
  9,36,108,13,3,249,170,170,128,255,255,192,255,255,192,255,170,128,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,255,192,255,255,192,255,255,192,85,85,64,
  // 0x005c "\"
  15,29,116,15,0,0,106,64,0,0,63,192,0,0,63,192,0,0,47,224,0,0,15,240,0,0,15,244,0,0,7,248,0,0,3,252,0,0,2,253,0,0,1,254,0,0,0,255,0,0,0,191,64,0,0,63,192,0,0,63,192,0,0,31,224,0,0,15,240,0,0,11,244,0,0,7,248,0,0,3,252,0,0,2,253,0,0,0,255,0,0,0,255,0,0,0,127,128,0,0,63,192,0,0,47,208,0,0,31,224,0,0,15,240,0,0,11,244,0,0,3,252,
  // 0x005d  ]
  9,36,108,13,1,249,170,170,128,255,255,192,255,255,192,170,191,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,255,255,192,255,255,192,255,255,192,85,85,64,
  // 0x005e  ^
  20,19,95,23,1,10,0,0,124,0,0,0,0,190,0,0,0,0,255,0,0,0,2,255,192,0,0,3,255,208,0,0,11,235,240,0,0,15,195,244,0,0,47,194,252,0,0,63,64,253,0,0,127,0,191,0,0,253,0,63,64,1,252,0,47,192,3,248,0,15,208,7,240,0,11,240,15,224,0,3,244,31,192,0,2,252,47,192,0,0,253,63,64,0,0,191,85,0,0,0,21,
  // 0x005f  _
  18,4,20,17,0,249,85,85,85,85,64,255,255,255,255,208,255,255,255,255,208,0,0,0,0,0,
  // 0x0060  `
  9,7,21,12,2,24,170,64,0,255,192,0,63,240,0,15,248,0,3,252,0,0,191,0,0,47,64,
  // 0x0061  a
  18,23,115,23,2,255,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x0062  b
  20,32,160,25,3,255,85,0,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,191,224,0,191,75,255,254,0,191,127,255,255,192,191,255,170,255,224,191,248,0,63,244,191,224,0,15,252,191,192,0,7,252,191,192,0,3,253,191,128,0,3,254,191,128,0,2,254,191,128,0,2,254,191,128,0,2,254,191,128,0,2,254,191,128,0,3,254,191,192,0,3,253,191,192,0,7,252,191,224,0,15,252,191,240,0,31,248,191,254,65,191,240,191,191,255,255,208,191,31,255,255,64,190,2,255,248,0,0,0,21,64,0,
  // 0x0063  c
  16,23,92,20,2,255,0,6,255,228,0,127,255,255,2,255,255,255,11,255,234,253,31,253,0,8,63,240,0,0,127,208,0,0,191,192,0,0,191,128,0,0,255,128,0,0,255,64,0,0,255,64,0,0,255,64,0,0,255,128,0,0,191,192,0,0,127,192,0,0,63,224,0,0,47,244,0,1,15,254,64,111,7,255,255,255,1,255,255,255,0,47,255,248,0,0,85,0,
  // 0x0064  d
  20,32,160,25,2,255,0,0,0,1,84,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,27,254,2,253,0,255,255,226,253,3,255,255,250,253,15,255,170,255,253,47,248,0,47,253,63,240,0,15,253,127,208,0,7,253,191,192,0,3,253,191,128,0,3,253,255,128,0,2,253,255,64,0,2,253,255,64,0,2,253,255,64,0,2,253,255,128,0,2,253,191,192,0,3,253,127,192,0,3,253,63,224,0,7,253,63,244,0,15,253,31,254,1,191,253,11,255,255,254,253,2,255,255,240,253,0,127,255,128,253,0,1,80,0,0,
  // 0x0065  e
  19,23,115,23,2,255,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x0066  f
  16,31,124,14,0,0,0,0,26,84,0,2,255,255,0,15,255,254,0,63,255,252,0,63,224,4,0,127,192,0,0,191,128,0,0,191,128,0,0,191,128,0,1,255,234,144,47,255,255,240,127,255,255,240,42,255,234,160,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,
  // 0x0067  g
  20,32,160,25,2,246,0,27,254,0,169,0,255,255,224,253,3,255,255,249,253,15,255,171,255,253,31,248,0,63,253,63,240,0,15,253,127,208,0,7,253,191,192,0,3,253,191,128,0,3,253,255,128,0,2,253,255,64,0,2,253,255,64,0,2,253,255,64,0,2,253,255,128,0,2,253,191,192,0,3,253,127,192,0,3,253,63,208,0,7,253,63,240,0,15,253,15,253,0,191,253,11,255,255,254,253,2,255,255,242,253,0,127,255,130,253,0,1,80,2,253,0,0,0,3,253,0,0,0,3,253,0,0,0,7,252,0,0,0,15,252,30,64,0,127,244,31,255,255,255,224,31,255,255,255,128,11,255,255,253,0,0,22,169,64,0,
  // 0x0068  h
  19,31,155,25,3,0,85,0,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,111,228,0,191,75,255,255,64,191,111,255,255,208,191,255,170,255,240,191,248,0,47,244,191,240,0,15,248,191,208,0,7,252,191,192,0,7,252,191,192,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,
  // 0x0069  i
  5,30,60,11,3,0,42,0,191,128,255,192,255,128,127,0,0,0,0,0,0,0,106,64,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,
  // 0x006a  j
  11,40,120,11,253,246,0,2,160,0,11,248,0,15,252,0,15,248,0,7,240,0,0,0,0,0,0,0,0,0,0,6,164,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,11,248,0,15,244,0,47,240,127,255,240,127,255,192,127,255,64,22,148,0,
  // 0x006b  k
  19,31,155,22,3,0,85,0,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,26,160,191,128,0,127,224,191,128,1,255,128,191,128,3,254,0,191,128,15,248,0,191,128,63,240,0,191,128,255,192,0,191,67,255,0,0,191,79,252,0,0,191,111,240,0,0,191,191,244,0,0,191,255,252,0,0,191,255,255,0,0,191,224,255,128,0,191,128,127,208,0,191,128,47,244,0,191,128,15,252,0,191,128,3,254,0,191,128,1,255,64,191,128,0,191,208,191,128,0,63,240,191,128,0,31,248,
  // 0x006c  l
  5,31,62,11,3,0,85,0,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,191,128,
  // 0x006d  m
  32,22,176,38,3,0,105,0,191,228,0,27,254,0,191,11,255,254,1,255,255,208,191,63,255,255,135,255,255,244,191,255,171,255,239,250,191,252,191,248,0,127,255,64,11,253,191,224,0,47,253,0,3,254,191,208,0,31,252,0,2,254,191,192,0,15,244,0,2,255,191,192,0,15,244,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,191,128,0,15,240,0,1,255,
  // 0x006e  n
  19,22,110,25,3,0,105,0,191,228,0,191,11,255,255,64,191,63,255,255,208,191,255,170,255,240,191,248,0,47,248,191,240,0,15,252,191,208,0,7,252,191,192,0,7,252,191,192,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,
  // 0x006f  o
  21,23,138,24,2,255,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x0070  p
  20,32,160,25,3,246,105,0,191,228,0,191,11,255,254,0,191,47,255,255,192,191,255,170,255,240,191,248,0,63,244,191,224,0,15,252,191,192,0,7,252,191,192,0,3,253,191,128,0,3,254,191,128,0,2,254,191,128,0,2,254,191,128,0,2,254,191,128,0,2,254,191,128,0,3,254,191,192,0,3,253,191,192,0,7,252,191,224,0,15,252,191,244,0,47,248,191,254,65,191,240,191,191,255,255,208,191,95,255,255,64,191,130,255,248,0,191,128,21,64,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,106,64,0,0,0,
  // 0x0071  q
  20,32,160,25,2,246,0,27,254,0,169,0,255,255,224,253,3,255,255,249,253,15,255,170,255,253,47,248,0,47,253,63,240,0,15,253,127,208,0,7,253,191,192,0,3,253,191,128,0,3,253,255,128,0,2,253,255,64,0,2,253,255,64,0,2,253,255,64,0,2,253,255,128,0,2,253,191,192,0,3,253,127,192,0,3,253,63,208,0,11,253,63,240,0,15,253,31,254,0,191,253,11,255,255,254,253,2,255,255,242,253,0,127,255,130,253,0,1,80,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,3,253,0,0,0,1,169,
  // 0x0072  r
  13,22,88,17,3,0,105,0,127,192,191,3,255,192,191,15,255,192,191,63,255,192,191,255,64,0,191,248,0,0,191,240,0,0,191,192,0,0,191,192,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,
  // 0x0073  s
  16,23,92,19,2,255,0,111,254,64,11,255,255,248,63,255,255,252,191,249,91,244,255,128,0,96,255,0,0,0,255,64,0,0,255,208,0,0,127,253,0,0,47,255,208,0,7,255,254,0,0,191,255,208,0,7,255,244,0,0,127,252,0,0,7,253,0,0,2,254,0,0,2,254,64,0,3,253,249,0,11,252,255,255,255,248,255,255,255,224,111,255,254,0,0,85,64,0,
  // 0x0074  t
  15,28,112,15,0,255,0,21,0,0,0,63,0,0,0,127,0,0,0,191,0,0,0,255,0,0,2,255,170,160,47,255,255,240,127,255,255,240,43,255,170,160,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,1,255,0,0,0,255,0,0,0,255,64,0,0,255,208,16,0,191,255,244,0,63,255,244,0,11,255,240,0,0,21,0,
  // 0x0075  u
  19,23,115,25,3,255,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x0076  v
  21,22,132,21,0,0,170,64,0,0,106,128,191,192,0,0,255,128,63,192,0,0,255,64,63,224,0,2,255,0,31,240,0,3,254,0,15,244,0,3,252,0,11,248,0,11,248,0,7,252,0,15,244,0,3,253,0,31,240,0,2,254,0,47,224,0,0,255,0,63,192,0,0,255,64,127,192,0,0,127,192,191,64,0,0,63,192,255,0,0,0,47,209,254,0,0,0,31,226,253,0,0,0,15,243,252,0,0,0,11,251,248,0,0,0,3,255,240,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,255,192,0,0,
  // 0x0077  w
  32,22,176,32,0,0,106,64,0,10,164,0,1,169,127,192,0,31,252,0,2,254,63,208,0,63,252,0,3,253,47,224,0,63,253,0,7,252,31,240,0,127,254,0,11,248,15,240,0,191,191,0,15,244,15,244,0,254,127,0,15,240,11,248,1,253,63,128,31,240,7,252,2,252,63,192,47,224,3,252,3,252,47,192,63,208,3,253,3,248,31,208,63,192,1,254,7,240,15,224,127,128,0,255,11,240,15,240,191,64,0,255,15,224,7,240,255,0,0,191,79,208,3,244,255,0,0,127,95,192,3,249,254,0,0,63,175,128,2,253,253,0,0,63,255,64,1,254,252,0,0,47,255,0,0,255,252,0,0,31,255,0,0,255,244,0,0,15,254,0,0,127,240,0,0,11,253,0,0,63,240,0,
  // 0x0078  x
  20,22,110,22,1,0,106,128,0,2,169,127,208,0,11,252,47,240,0,31,244,15,252,0,63,224,7,253,0,191,192,2,255,1,255,64,0,255,131,254,0,0,63,219,252,0,0,31,255,240,0,0,15,255,224,0,0,3,255,192,0,0,3,255,192,0,0,15,255,224,0,0,47,255,240,0,0,63,219,252,0,0,255,131,254,0,2,255,1,255,64,7,253,0,191,192,15,248,0,63,224,47,240,0,31,244,127,208,0,11,252,255,128,0,3,255,
  // 0x0079  y
  21,32,192,21,0,246,106,64,0,0,106,128,191,192,0,0,255,128,63,208,0,0,255,64,47,224,0,2,255,0,31,240,0,3,254,0,15,244,0,3,252,0,11,252,0,11,252,0,3,252,0,15,244,0,2,254,0,31,240,0,1,255,0,47,224,0,0,255,64,63,208,0,0,191,128,127,192,0,0,63,192,191,128,0,0,47,208,255,0,0,0,31,225,255,0,0,0,15,242,253,0,0,0,11,243,252,0,0,0,3,251,248,0,0,0,2,255,244,0,0,0,1,255,240,0,0,0,0,255,224,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,255,64,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,7,252,0,0,0,0,47,248,0,0,0,127,255,240,0,0,0,127,255,192,0,0,0,127,254,0,0,0,0,26,144,0,0,0,0,
  // 0x007a  z
  17,22,110,19,1,0,42,170,170,170,0,63,255,255,255,0,63,255,255,255,0,42,170,171,255,0,0,0,3,253,0,0,0,11,252,0,0,0,31,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,192,0,0,0,255,64,0,0,3,254,0,0,0,11,252,0,0,0,31,240,0,0,0,63,229,85,85,0,191,255,255,255,128,191,255,255,255,128,191,255,255,255,128,
  // 0x007b  {
  13,36,144,15,1,249,0,0,5,128,0,1,255,192,0,11,255,192,0,31,255,192,0,63,244,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,191,128,0,2,255,0,0,255,253,0,0,255,208,0,0,255,244,0,0,175,254,0,0,1,255,64,0,0,191,128,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,208,0,0,63,248,0,0,31,255,192,0,7,255,192,0,0,191,192,0,0,0,64,
  // 0x007c  |
  4,41,41,22,9,246,20,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,85,
  // 0x007d  }
  14,36,144,15,1,249,84,0,0,0,191,224,0,0,191,252,0,0,191,255,0,0,2,255,0,0,0,255,64,0,0,191,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,128,0,0,127,192,0,0,63,244,0,0,15,255,208,0,1,191,208,0,2,255,208,0,31,255,128,0,63,224,0,0,127,192,0,0,127,128,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,191,64,0,0,255,64,0,7,255,0,0,191,254,0,0,191,248,0,0,191,144,0,0,16,0,0,0,
  // 0x007e  ~
  19,6,30,23,2,11,11,250,64,0,4,127,255,244,0,60,255,255,255,235,252,254,107,255,255,252,208,0,111,255,224,0,0,1,170,0,
  // 0x007f - 0x009a  Control Characters
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00a0 "�"
  0,0,0,10,0,0,
  // 0x00a1  ¡
  5,30,60,11,3,248,46,0,255,192,255,192,255,192,255,192,46,0,0,0,0,0,0,0,63,0,63,0,63,0,63,0,127,0,127,0,127,64,127,64,127,64,191,64,191,64,191,128,191,128,191,128,255,128,255,128,255,192,255,192,255,192,255,192,0,0,
  // 0x00a2  ¢
  17,30,150,23,3,255,0,0,188,0,0,0,0,188,0,0,0,0,188,0,0,0,1,255,164,0,0,63,255,255,64,1,255,255,255,64,7,255,255,255,0,15,254,0,25,0,47,244,0,0,0,63,224,0,0,0,63,208,0,0,0,127,192,0,0,0,191,192,0,0,0,191,192,0,0,0,191,128,0,0,0,191,192,0,0,0,127,192,0,0,0,127,192,0,0,0,63,208,0,0,0,63,224,0,0,0,47,248,0,0,0,15,255,64,27,0,7,255,255,255,0,1,255,255,255,0,0,47,255,254,0,0,1,254,80,0,0,0,188,0,0,0,0,188,0,0,0,0,188,0,0,0,0,84,0,0,
  // 0x00a3  £
  21,29,174,23,1,0,0,0,43,254,64,0,0,2,255,255,253,0,0,15,255,255,253,0,0,47,254,175,252,0,0,63,224,0,100,0,0,191,192,0,0,0,0,191,128,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,127,255,255,255,64,0,191,255,255,255,64,0,191,255,255,255,64,0,0,255,128,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,0,0,0,0,2,254,0,0,0,0,11,248,0,0,0,0,127,255,255,255,255,64,191,255,255,255,255,128,191,255,255,255,255,128,191,255,255,255,255,128,
  // 0x00a4  ¤
  18,18,90,23,2,5,13,0,0,1,192,63,70,254,7,240,63,255,255,255,240,15,255,255,255,192,7,254,2,255,0,11,240,0,127,64,15,208,0,31,192,15,192,0,15,192,31,192,0,15,192,31,192,0,15,192,15,192,0,15,192,15,224,0,47,192,7,244,0,191,64,7,255,155,255,64,31,255,255,255,192,127,239,255,239,240,63,1,169,3,224,8,0,0,0,128,
  // 0x00a5  ¥
  21,29,174,23,1,0,170,0,0,0,42,128,255,64,0,0,191,192,127,192,0,0,255,64,63,208,0,2,254,0,31,240,0,3,252,0,15,244,0,11,248,0,7,252,0,15,240,0,3,253,0,47,224,0,1,255,0,63,192,0,0,255,64,191,128,0,0,127,192,255,0,0,0,63,209,254,0,0,0,31,243,252,0,0,0,11,251,244,0,0,0,3,255,240,0,0,2,171,255,250,160,0,7,255,255,255,240,0,7,255,255,255,240,0,0,0,191,128,0,0,0,0,191,64,0,0,0,0,191,64,0,0,3,255,255,255,240,0,7,255,255,255,240,0,7,255,255,255,240,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,
  // 0x00a6  ¦
  4,41,41,22,9,246,20,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,0,0,0,0,0,0,0,0,0,190,190,190,190,190,190,190,190,190,190,190,190,190,190,190,85,
  // 0x00a7  §
  16,32,128,20,2,255,0,22,165,0,2,255,255,244,15,255,255,252,63,249,91,252,63,192,0,36,127,64,0,0,63,128,0,0,63,224,0,0,31,253,0,0,7,255,228,0,3,255,255,0,15,251,255,224,47,192,127,248,63,64,7,253,127,0,1,254,127,0,0,254,127,128,0,190,63,224,0,254,31,253,2,252,7,255,235,244,0,191,255,224,0,11,255,224,0,0,127,248,0,0,7,253,0,0,1,254,0,0,0,254,0,0,1,254,185,0,7,253,191,254,255,248,191,255,255,224,27,255,254,0,0,0,0,0,
  // 0x00a8  ¨
  12,5,15,24,6,25,20,0,16,254,0,253,255,2,254,255,1,254,124,0,184,
  // 0x00a9  ©
  30,30,240,33,2,255,0,0,6,255,228,0,0,0,0,0,191,255,255,208,0,0,0,11,254,85,111,248,0,0,0,63,208,0,1,255,0,0,0,253,0,0,0,31,208,0,3,240,0,1,0,3,240,0,11,192,1,255,253,0,252,0,15,64,11,255,255,0,125,0,47,0,47,249,190,0,47,0,61,0,127,64,0,0,15,64,124,0,254,0,0,0,15,128,184,0,252,0,0,0,11,192,248,1,248,0,0,0,7,192,244,2,248,0,0,0,3,208,244,2,248,0,0,0,3,208,244,2,248,0,0,0,3,208,244,2,248,0,0,0,7,192,248,1,252,0,0,0,7,192,188,0,252,0,0,0,11,192,124,0,254,0,0,0,15,128,62,0,127,128,5,0,31,64,47,0,31,255,254,0,63,0,15,192,7,255,254,0,188,0,7,224,0,106,144,2,248,0,2,252,0,0,0,11,240,0,0,191,64,0,0,127,192,0,0,31,248,0,11,254,0,0,0,2,255,255,255,244,0,0,0,0,47,255,254,64,0,0,0,0,0,85,64,0,0,0,
  // 0x00aa  ª
  12,14,42,15,1,15,1,191,128,47,255,244,47,171,252,4,0,190,0,0,126,0,22,190,11,255,254,63,233,190,190,0,126,252,0,126,253,0,254,191,155,254,63,255,110,6,248,25,
  // 0x00ab  «
  19,17,85,22,1,2,0,3,128,2,208,0,15,240,7,248,0,47,224,31,240,0,191,192,63,208,1,255,0,255,128,7,253,2,255,0,15,244,11,252,0,63,224,31,240,0,127,192,63,224,0,47,240,15,244,0,15,248,7,253,0,3,254,1,255,0,0,255,64,191,192,0,127,192,63,224,0,31,240,15,248,0,11,224,3,244,0,2,64,1,128,
  // 0x00ac  ¬
  19,11,55,23,2,5,170,170,170,170,168,255,255,255,255,252,255,255,255,255,252,170,170,170,170,252,0,0,0,1,252,0,0,0,1,252,0,0,0,1,252,0,0,0,1,252,0,0,0,1,252,0,0,0,1,252,0,0,0,1,252,
  // 0x00ad  ­
  11,5,15,13,1,8,106,170,160,191,255,244,191,255,244,191,255,244,0,0,0,
  // 0x00ae  ®
  30,30,240,33,2,255,0,0,6,255,228,0,0,0,0,0,191,255,255,208,0,0,0,11,254,85,111,248,0,0,0,63,208,0,1,255,0,0,0,253,0,0,0,31,208,0,3,240,0,0,0,3,240,0,11,192,63,255,224,0,252,0,15,64,63,255,253,0,125,0,47,0,63,170,255,0,47,0,61,0,63,0,63,64,15,64,124,0,63,0,47,128,15,128,184,0,63,0,47,128,11,192,248,0,63,0,63,64,7,192,244,0,63,0,191,0,3,208,244,0,63,255,253,0,3,208,244,0,63,255,240,0,3,208,244,0,63,171,240,0,7,192,248,0,63,3,248,0,7,192,188,0,63,0,252,0,11,192,124,0,63,0,190,0,15,128,62,0,63,0,63,64,31,64,47,0,63,0,47,192,63,0,15,192,63,0,15,224,188,0,7,224,21,0,1,82,248,0,2,252,0,0,0,11,240,0,0,191,64,0,0,127,192,0,0,31,248,0,11,254,0,0,0,2,255,255,255,244,0,0,0,0,47,255,254,64,0,0,0,0,0,85,64,0,0,0,
  // 0x00af  ¯
  20,4,20,20,0,30,85,85,85,85,85,255,255,255,255,255,255,255,255,255,255,170,170,170,170,170,
  // 0x00b0  °
  13,13,52,17,2,16,1,191,144,0,11,255,252,0,63,255,255,0,127,64,127,64,189,0,31,192,252,0,15,192,252,0,15,192,252,0,15,192,190,0,47,128,63,144,191,64,47,255,254,0,7,255,248,0,0,106,64,0,
  // 0x00b1  ±
  19,24,120,23,2,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,1,252,0,0,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,0,1,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,252,0,0,0,0,0,0,0,85,85,85,85,84,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,
  // 0x00b2  ²
  12,18,54,14,1,16,6,255,128,63,255,244,191,235,252,60,1,253,0,0,254,0,0,253,0,0,252,0,2,252,0,11,240,0,47,208,0,191,64,2,253,0,11,244,0,47,192,0,191,170,169,255,255,254,255,255,254,85,85,84,
  // 0x00b3  ³
  12,18,54,14,1,16,11,255,128,191,255,244,191,171,252,52,0,253,0,0,253,0,0,253,0,2,252,6,175,240,11,255,192,7,255,248,0,1,253,0,0,127,0,0,127,0,0,191,228,1,254,255,255,252,255,255,240,6,169,0,
  // 0x00b4  ´
  10,7,21,12,1,24,0,106,144,0,255,192,2,255,0,7,252,0,15,240,0,63,192,0,126,0,0,
  // 0x00b5  µ
  19,32,160,25,3,246,106,64,0,2,168,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,7,252,191,128,0,7,252,191,128,0,11,252,191,128,0,15,252,191,192,0,15,252,191,224,0,63,252,191,249,1,255,252,191,255,255,251,252,191,255,255,226,252,191,95,255,65,252,191,65,80,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,106,64,0,0,0,
  // 0x00b6  ¶
  20,37,185,26,2,250,0,1,85,85,85,0,127,255,255,255,3,255,255,255,255,15,255,255,245,111,47,255,255,240,31,63,255,255,240,31,127,255,255,240,31,191,255,255,240,31,191,255,255,240,31,255,255,255,240,31,255,255,255,240,31,255,255,255,240,31,191,255,255,240,31,191,255,255,240,31,127,255,255,240,31,63,255,255,240,31,47,255,255,240,31,15,255,255,240,31,7,255,255,240,31,0,191,255,240,31,0,1,83,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,3,240,31,0,0,0,0,0,
  // 0x00b7  ·
  5,6,12,11,3,11,127,64,255,192,255,192,255,192,191,128,25,0,
  // 0x00b8  ¸
  9,10,30,9,0,246,3,224,0,11,192,0,15,248,0,11,255,0,0,127,64,0,63,64,0,127,0,255,255,0,255,248,0,106,64,0,
  // 0x00b9  ¹
  8,18,36,14,2,16,0,127,2,255,15,255,127,255,254,63,116,63,0,63,0,63,0,63,0,63,0,63,0,63,0,63,0,63,0,63,0,63,0,63,0,21,
  // 0x00ba  º
  13,14,56,15,1,15,0,191,144,0,11,255,248,0,47,234,254,0,63,0,63,64,126,0,31,128,189,0,15,192,188,0,15,192,188,0,15,192,189,0,15,192,126,0,31,128,63,0,63,0,31,234,254,0,7,255,248,0,0,191,144,0,
  // 0x00bb  »
  18,17,85,22,2,2,44,0,30,0,0,255,0,191,128,0,191,192,63,208,0,63,224,31,240,0,15,248,7,252,0,3,253,2,255,0,1,255,0,255,128,0,191,192,63,224,0,63,208,47,240,0,255,128,127,208,2,255,0,255,64,7,252,3,254,0,31,244,11,248,0,63,208,47,240,0,255,128,127,192,0,190,0,127,0,0,24,0,9,0,0,
  // 0x00bc  ¼
  30,29,232,31,1,0,0,26,64,0,0,26,64,0,0,191,192,0,0,127,0,0,7,255,192,0,0,254,0,0,47,255,192,0,1,252,0,0,191,111,192,0,3,244,0,0,61,47,192,0,11,240,0,0,0,47,192,0,15,192,0,0,0,47,192,0,63,128,0,0,0,47,192,0,127,0,0,0,0,47,192,0,253,0,0,0,0,47,192,2,252,0,0,0,0,47,192,3,244,0,0,0,0,47,192,15,224,3,252,0,0,47,192,31,192,11,252,0,0,47,192,63,64,31,252,0,0,47,192,191,0,63,252,0,0,47,192,253,0,189,252,0,0,26,67,248,1,245,252,0,0,0,7,240,3,225,252,0,0,0,15,224,11,193,252,0,0,0,47,192,31,65,252,0,0,0,63,64,62,1,252,0,0,0,190,0,253,2,252,0,0,1,252,0,255,255,255,208,0,3,248,0,255,255,255,208,0,11,240,0,85,86,253,64,0,15,208,0,0,1,252,0,0,47,192,0,0,1,252,0,0,127,0,0,0,1,252,0,
  // 0x00bd  ½
  30,29,232,32,1,0,0,42,0,0,0,105,0,0,1,255,64,0,0,253,0,0,11,255,64,0,2,252,0,0,63,255,64,0,7,240,0,0,255,63,64,0,15,224,0,0,124,63,64,0,31,192,0,0,16,63,64,0,63,64,0,0,0,63,64,0,191,0,0,0,0,63,64,1,252,0,0,0,0,63,64,3,248,0,0,0,0,63,64,7,240,0,0,0,0,63,64,15,208,5,80,0,0,63,64,47,193,255,253,0,0,63,64,63,11,255,255,64,0,63,64,254,11,229,127,192,0,63,65,252,2,64,31,192,0,63,67,244,0,0,15,208,0,42,11,240,0,0,31,192,0,0,15,208,0,0,47,192,0,0,63,128,0,0,127,64,0,0,127,0,0,0,254,0,0,0,253,0,0,3,248,0,0,2,252,0,0,15,224,0,0,3,244,0,0,127,128,0,0,15,224,0,1,254,0,0,0,31,192,0,7,248,0,0,0,63,128,0,15,255,255,208,0,191,0,0,31,255,255,208,0,253,0,0,31,255,255,208,
  // 0x00be  ¾
  31,29,232,32,1,0,6,255,128,0,0,2,160,0,63,255,244,0,0,11,240,0,191,239,252,0,0,15,208,0,56,0,253,0,0,63,128,0,0,0,190,0,0,127,0,0,0,0,253,0,0,254,0,0,0,1,252,0,2,252,0,0,1,107,244,0,3,244,0,0,7,255,192,0,15,224,0,0,7,255,244,0,31,192,0,0,0,1,253,0,63,128,0,0,0,0,127,0,191,0,0,0,0,0,63,0,253,0,191,0,0,0,127,3,252,1,255,0,208,0,255,7,240,3,255,0,255,239,253,15,224,15,255,0,255,255,244,47,192,31,127,0,27,254,64,63,64,62,127,0,0,0,0,191,0,252,127,0,0,0,1,252,2,244,127,0,0,0,3,248,3,224,127,0,0,0,11,240,15,192,127,0,0,0,15,208,47,64,127,64,0,0,47,192,63,255,255,248,0,0,127,0,63,255,255,248,0,0,254,0,21,85,191,148,0,1,252,0,0,0,127,0,0,3,244,0,0,0,127,0,0,11,240,0,0,0,127,0,
  // 0x00bf  ¿
  17,30,150,18,1,248,0,0,184,0,0,0,3,255,0,0,0,7,255,0,0,0,7,255,0,0,0,3,255,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,0,0,0,0,253,0,0,0,1,252,0,0,0,3,252,0,0,0,11,248,0,0,0,47,240,0,0,0,191,208,0,0,3,255,64,0,0,15,253,0,0,0,47,240,0,0,0,127,192,0,0,0,191,64,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,128,0,4,0,127,224,1,189,0,63,255,255,255,0,15,255,255,255,64,2,255,255,244,0,0,26,169,0,0,
  // 0x00c0  À
  26,38,10,26,0,0,0,1,170,0,0,0,0,0,0,255,192,0,0,0,0,0,127,208,0,0,0,0,0,31,240,0,0,0,0,0,7,252,0,0,0,0,0,0,254,0,0,0,0,0,0,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x00c1  Á
  26,38,10,26,0,0,0,0,0,6,169,0,0,0,0,0,15,252,0,0,0,0,0,47,240,0,0,0,0,0,63,192,0,0,0,0,0,255,0,0,0,0,0,2,252,0,0,0,0,0,3,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x00c2  Â
  26,38,10,26,0,0,0,0,6,169,0,0,0,0,0,15,255,0,0,0,0,0,63,255,192,0,0,0,0,191,175,224,0,0,0,2,254,11,248,0,0,0,7,244,1,254,0,0,0,15,128,0,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x00c3  Ã
  26,37,3,26,0,0,0,0,105,0,10,64,0,0,2,255,208,15,64,0,0,11,255,254,127,0,0,0,15,235,255,254,0,0,0,31,64,127,252,0,0,0,30,0,6,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x00c4  Ä
  26,37,3,26,0,0,0,0,80,0,80,0,0,0,2,252,3,248,0,0,0,3,253,3,252,0,0,0,2,252,3,252,0,0,0,0,180,1,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,169,0,0,0,0,0,11,255,0,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x00c5  Å
  26,35,245,26,0,0,0,0,6,249,0,0,0,0,0,31,255,64,0,0,0,0,63,95,192,0,0,0,0,124,3,208,0,0,0,0,188,3,224,0,0,0,0,124,3,208,0,0,0,0,63,255,192,0,0,0,0,31,255,64,0,0,0,0,15,255,0,0,0,0,0,31,255,128,0,0,0,0,47,255,192,0,0,0,0,63,175,208,0,0,0,0,127,95,224,0,0,0,0,255,15,240,0,0,0,1,255,11,244,0,0,0,2,253,7,252,0,0,0,3,252,3,252,0,0,0,7,252,2,254,0,0,0,15,244,1,255,0,0,0,15,240,0,255,64,0,0,47,224,0,191,128,0,0,63,208,0,63,192,0,0,127,192,0,63,208,0,0,191,255,255,255,240,0,0,255,255,255,255,240,0,1,255,255,255,255,248,0,3,255,255,255,255,252,0,3,252,0,0,3,253,0,11,252,0,0,3,254,0,15,248,0,0,1,255,0,31,240,0,0,0,255,64,47,240,0,0,0,191,192,63,208,0,0,0,127,192,127,192,0,0,0,63,224,255,128,0,0,0,47,240,
  // 0x00c6  Æ
  34,29,5,36,0,0,0,0,0,26,170,170,170,170,144,0,0,0,63,255,255,255,255,224,0,0,0,191,255,255,255,255,224,0,0,0,255,255,255,255,255,224,0,0,2,254,15,248,0,0,0,0,0,3,252,15,244,0,0,0,0,0,11,248,15,244,0,0,0,0,0,15,244,15,244,0,0,0,0,0,31,240,15,244,0,0,0,0,0,63,208,15,244,0,0,0,0,0,127,192,15,244,0,0,0,0,0,255,64,15,244,0,0,0,0,1,255,0,15,254,170,170,128,0,3,254,0,15,255,255,255,192,0,7,252,0,15,255,255,255,192,0,11,248,0,15,255,255,255,192,0,15,240,0,15,244,0,0,0,0,47,255,255,255,244,0,0,0,0,63,255,255,255,244,0,0,0,0,191,255,255,255,244,0,0,0,0,255,255,255,255,244,0,0,0,2,255,0,0,15,244,0,0,0,3,253,0,0,15,244,0,0,0,7,252,0,0,15,244,0,0,0,15,248,0,0,15,244,0,0,0,31,240,0,0,15,254,170,170,144,63,224,0,0,15,255,255,255,224,127,192,0,0,15,255,255,255,224,255,128,0,0,15,255,255,255,224,
  // 0x00c7  Ç
  22,39,234,25,2,246,0,0,27,255,228,0,0,2,255,255,255,208,0,31,255,255,255,224,0,127,255,255,255,208,1,255,244,0,27,192,3,255,128,0,0,0,11,254,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,127,208,0,0,0,0,63,224,0,0,0,0,63,240,0,0,0,0,47,244,0,0,0,0,15,252,0,0,0,0,11,255,0,0,0,0,3,255,208,0,0,64,1,255,254,85,175,192,0,127,255,255,255,192,0,15,255,255,255,192,0,1,191,255,254,64,0,0,2,249,0,0,0,0,3,240,0,0,0,0,7,253,0,0,0,0,6,255,64,0,0,0,0,47,192,0,0,0,0,31,192,0,0,0,0,47,192,0,0,0,63,255,64,0,0,0,63,254,0,0,0,0,26,144,0,0,
  // 0x00c8  È
  16,38,152,22,4,0,6,169,0,0,3,255,0,0,0,255,128,0,0,63,208,0,0,15,240,0,0,3,248,0,0,0,188,0,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00c9  É
  16,38,152,22,4,0,0,0,10,168,0,0,63,240,0,0,127,208,0,0,255,64,0,3,253,0,0,11,240,0,0,15,128,0,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00ca  Ê
  16,38,152,22,4,0,0,10,164,0,0,63,252,0,0,191,255,0,2,254,191,192,7,248,31,224,31,224,7,248,62,0,0,189,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00cb  Ë
  16,37,148,22,4,0,1,64,1,64,7,240,15,224,15,244,15,240,11,244,15,240,2,224,7,208,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,168,255,255,255,252,255,255,255,252,255,255,255,252,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,234,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00cc  Ì
  12,38,114,14,1,0,106,144,0,63,240,0,15,248,0,3,252,0,0,255,0,0,63,128,0,11,192,0,0,0,0,0,0,106,170,169,127,255,254,127,255,254,11,255,228,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,1,255,128,127,255,253,127,255,254,127,255,254,
  // 0x00cd  Í
  13,38,152,14,1,0,0,1,170,64,0,3,255,0,0,11,252,0,0,15,240,0,0,63,192,0,0,191,0,0,0,248,0,0,0,0,0,0,0,0,0,0,106,170,169,0,127,255,254,0,127,255,254,0,11,255,228,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,1,255,128,0,127,255,253,0,127,255,254,0,127,255,254,0,
  // 0x00ce  Î
  14,38,152,14,0,0,0,106,144,0,0,255,240,0,3,255,252,0,11,250,255,0,31,224,191,128,127,64,31,224,248,0,2,240,0,0,0,0,0,0,0,0,26,170,170,64,31,255,255,128,31,255,255,128,2,255,249,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,127,224,0,31,255,255,64,31,255,255,128,31,255,255,128,
  // 0x00cf  Ï
  12,37,111,14,1,0,20,0,20,191,0,254,255,64,255,191,64,255,45,0,124,0,0,0,0,0,0,0,0,0,106,170,169,127,255,254,127,255,254,11,255,228,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,1,255,128,127,255,253,127,255,254,127,255,254,
  // 0x00d0  Ð
  26,29,203,29,1,0,2,170,170,148,0,0,0,3,255,255,255,224,0,0,3,255,255,255,255,0,0,3,255,255,255,255,208,0,3,253,0,6,255,244,0,3,253,0,0,47,253,0,3,253,0,0,7,255,0,3,253,0,0,2,255,128,3,253,0,0,0,255,192,3,253,0,0,0,127,208,3,253,0,0,0,63,224,3,253,0,0,0,63,224,3,253,0,0,0,47,240,255,255,255,224,0,47,240,255,255,255,224,0,47,240,255,255,255,224,0,47,240,171,255,170,160,0,47,240,3,253,0,0,0,63,224,3,253,0,0,0,63,224,3,253,0,0,0,127,192,3,253,0,0,0,255,192,3,253,0,0,1,255,128,3,253,0,0,3,255,0,3,253,0,0,31,253,0,3,253,0,1,255,248,0,3,255,170,255,255,224,0,3,255,255,255,255,64,0,3,255,255,255,244,0,0,3,255,255,249,0,0,0,
  // 0x00d1  Ñ
  23,37,222,31,4,0,0,1,144,0,40,0,0,31,254,0,188,0,0,63,255,230,248,0,0,191,191,255,240,0,0,252,3,255,208,0,0,244,0,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,128,0,0,1,168,255,224,0,0,3,252,255,244,0,0,3,252,255,252,0,0,3,252,255,254,0,0,3,252,255,255,0,0,3,252,254,255,192,0,3,252,253,127,208,0,3,252,254,63,240,0,3,252,254,15,248,0,3,252,254,11,253,0,3,252,254,3,255,0,3,252,254,1,255,128,3,252,254,0,191,192,3,252,254,0,63,240,3,252,254,0,31,244,3,252,254,0,15,252,2,252,254,0,3,254,2,252,254,0,2,255,66,252,254,0,0,255,194,252,254,0,0,127,226,252,254,0,0,47,242,252,254,0,0,15,254,252,254,0,0,7,255,252,254,0,0,3,255,252,254,0,0,0,255,252,254,0,0,0,191,252,254,0,0,0,63,252,254,0,0,0,31,252,
  // 0x00d2  Ò
  27,39,17,31,2,255,0,0,170,128,0,0,0,0,0,127,224,0,0,0,0,0,47,240,0,0,0,0,0,11,252,0,0,0,0,0,2,254,0,0,0,0,0,0,127,64,0,0,0,0,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x00d3  Ó
  27,39,17,31,2,255,0,0,0,1,170,0,0,0,0,0,7,254,0,0,0,0,0,15,252,0,0,0,0,0,47,240,0,0,0,0,0,127,192,0,0,0,0,0,254,0,0,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x00d4  Ô
  27,39,17,31,2,255,0,0,2,170,0,0,0,0,0,7,255,128,0,0,0,0,15,255,224,0,0,0,0,63,223,244,0,0,0,0,255,67,253,0,0,0,3,252,0,191,0,0,0,7,224,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x00d5  Õ
  27,38,10,31,2,255,0,0,26,0,2,128,0,0,0,255,240,7,192,0,0,3,255,254,111,192,0,0,7,250,255,255,64,0,0,11,192,47,254,0,0,0,11,64,2,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x00d6  Ö
  27,38,10,31,2,255,0,0,20,0,16,0,0,0,0,254,0,253,0,0,0,0,255,2,254,0,0,0,0,255,1,254,0,0,0,0,124,0,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,228,0,0,0,7,255,255,255,64,0,0,47,255,255,255,240,0,0,191,255,239,255,252,0,2,255,224,0,31,255,0,7,255,64,0,2,255,128,15,252,0,0,0,255,208,31,248,0,0,0,63,224,47,240,0,0,0,47,240,63,224,0,0,0,31,244,63,208,0,0,0,15,248,127,192,0,0,0,15,252,127,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,191,192,0,0,0,11,252,127,192,0,0,0,15,252,127,208,0,0,0,15,248,63,224,0,0,0,15,244,63,240,0,0,0,47,240,31,244,0,0,0,63,240,15,252,0,0,0,191,208,11,254,0,0,1,255,192,3,255,192,0,11,255,64,0,255,254,85,191,254,0,0,63,255,255,255,244,0,0,11,255,255,255,208,0,0,0,191,255,249,0,0,0,0,1,85,0,0,0,
  // 0x00d7  ×
  17,18,90,23,3,5,36,0,0,5,0,189,0,0,47,64,255,64,0,191,192,127,208,2,255,0,31,244,11,252,0,7,253,47,240,0,1,255,191,192,0,0,127,255,0,0,0,31,252,0,0,0,47,253,0,0,0,191,255,64,0,2,255,191,208,0,11,252,31,244,0,47,240,7,253,0,191,192,1,255,64,255,0,0,127,192,124,0,0,31,0,16,0,0,4,0,
  // 0x00d8  Ø
  27,32,224,31,2,254,0,0,0,0,0,9,0,0,0,27,255,228,31,128,0,7,255,255,255,127,128,0,47,255,255,255,255,0,0,191,255,239,255,253,0,2,255,224,0,31,255,0,7,255,64,0,15,255,128,15,252,0,0,47,255,192,31,248,0,0,127,191,224,47,240,0,0,255,47,240,63,224,0,2,252,31,244,63,208,0,7,244,15,248,127,192,0,15,240,15,252,127,192,0,47,192,11,252,191,192,0,127,64,11,252,191,192,0,254,0,11,252,191,192,3,252,0,11,252,127,192,11,244,0,11,252,127,192,15,224,0,15,252,127,208,63,192,0,15,248,63,224,191,64,0,15,244,63,241,254,0,0,47,240,31,247,252,0,0,63,240,15,255,240,0,0,191,208,11,255,208,0,1,255,192,3,255,208,0,11,255,64,0,255,254,85,191,254,0,1,255,255,255,255,244,0,3,255,255,255,255,208,0,11,240,191,255,249,0,0,2,208,1,85,0,0,0,0,0,0,0,0,0,0,
  // 0x00d9  Ù
  23,39,234,30,3,255,0,10,168,0,0,0,0,7,254,0,0,0,0,2,255,0,0,0,0,0,191,192,0,0,0,0,31,224,0,0,0,0,7,244,0,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x00da  Ú
  23,39,234,30,3,255,0,0,0,26,164,0,0,0,0,63,240,0,0,0,0,255,192,0,0,0,2,255,0,0,0,0,3,252,0,0,0,0,15,224,0,0,0,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x00db  Û
  23,39,234,30,3,255,0,0,26,160,0,0,0,0,127,252,0,0,0,0,255,254,0,0,0,3,253,255,64,0,0,15,244,63,208,0,0,47,192,11,244,0,0,126,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x00dc  Ü
  23,38,228,30,3,255,0,1,64,1,0,0,0,15,240,15,208,0,0,15,240,31,224,0,0,15,240,31,224,0,0,7,208,11,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,64,0,0,2,168,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,127,192,0,0,7,252,63,208,0,0,11,248,63,224,0,0,15,244,47,244,0,0,47,240,15,253,0,0,191,224,7,255,229,91,255,192,2,255,255,255,255,0,0,127,255,255,248,0,0,11,255,255,144,0,0,0,21,80,0,0,
  // 0x00dd  Ý
  23,38,228,23,0,0,0,0,0,42,160,0,0,0,0,127,224,0,0,0,0,255,128,0,0,0,2,254,0,0,0,0,7,248,0,0,0,0,15,224,0,0,0,0,31,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,6,168,127,192,0,0,15,248,63,240,0,0,31,240,31,244,0,0,63,224,15,252,0,0,127,192,7,253,0,0,255,128,2,255,0,1,255,0,0,255,64,3,253,0,0,191,192,11,252,0,0,63,208,15,244,0,0,47,240,47,240,0,0,15,244,63,208,0,0,7,252,191,128,0,0,3,254,255,0,0,0,1,255,254,0,0,0,0,255,252,0,0,0,0,127,248,0,0,0,0,63,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,0,0,31,240,0,0,
  // 0x00de  Þ
  19,29,145,24,4,0,170,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,255,169,0,0,255,255,255,244,0,255,255,255,255,0,255,255,255,255,192,255,0,2,255,208,255,0,0,63,240,255,0,0,31,240,255,0,0,15,244,255,0,0,15,244,255,0,0,15,244,255,0,0,15,244,255,0,0,31,240,255,0,0,63,240,255,0,1,255,208,255,170,191,255,128,255,255,255,254,0,255,255,255,244,0,255,255,250,64,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,
  // 0x00df  ß
  22,32,192,26,3,255,0,1,169,64,0,0,0,191,255,253,0,0,7,255,255,255,192,0,31,255,255,255,240,0,63,248,0,127,248,0,127,208,0,15,252,0,191,192,0,7,252,0,191,128,0,7,252,0,191,128,0,15,248,0,191,128,0,47,240,0,191,128,0,255,192,0,191,128,3,255,0,0,191,128,15,248,0,0,191,128,47,240,0,0,191,128,63,208,0,0,191,128,63,224,0,0,191,128,47,248,0,0,191,128,15,255,0,0,191,128,3,255,224,0,191,128,0,255,252,0,191,128,0,31,255,0,191,128,0,3,255,128,191,128,0,0,191,192,191,128,0,0,63,208,191,128,0,0,63,208,191,128,0,0,63,208,191,128,0,0,63,208,191,128,228,0,255,192,191,128,255,255,255,128,191,128,255,255,254,0,191,128,127,255,244,0,0,0,1,85,0,0,
  // 0x00e0  à
  18,32,160,23,2,255,0,170,128,0,0,0,191,208,0,0,0,63,240,0,0,0,15,248,0,0,0,2,253,0,0,0,0,191,0,0,0,0,31,64,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x00e1  á
  18,32,160,23,2,255,0,0,2,170,0,0,0,7,254,0,0,0,15,248,0,0,0,63,224,0,0,0,191,128,0,0,1,254,0,0,0,2,244,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x00e2  â
  18,32,160,23,2,255,0,2,170,0,0,0,11,255,128,0,0,31,255,208,0,0,127,223,240,0,0,255,3,252,0,3,252,0,255,0,11,208,0,47,128,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x00e3  ã
  18,31,155,23,2,255,0,25,0,2,128,1,255,224,11,192,3,255,254,111,128,11,251,255,255,0,15,192,63,253,0,15,64,6,160,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x00e4  ä
  18,31,155,23,2,255,0,20,0,80,0,0,253,1,252,0,1,255,3,253,0,1,254,2,253,0,0,184,0,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x00e5  å
  18,34,170,23,2,255,0,2,253,0,0,0,15,255,192,0,0,47,155,224,0,0,61,2,240,0,0,61,1,240,0,0,62,3,240,0,0,47,155,224,0,0,15,255,128,0,0,1,169,0,0,0,0,0,0,0,0,0,0,0,0,0,27,255,144,0,6,255,255,253,0,11,255,255,255,64,7,254,91,255,192,2,128,0,127,208,0,0,0,63,224,0,0,0,47,224,0,0,0,31,240,0,0,0,31,240,0,27,255,255,240,3,255,255,255,240,31,255,250,191,240,127,244,0,31,240,255,192,0,31,240,255,64,0,47,240,255,0,0,47,240,255,64,0,63,240,255,128,0,255,240,255,208,7,255,240,127,255,255,223,240,47,255,255,75,240,7,255,248,7,240,0,21,64,0,0,
  // 0x00e6  æ
  31,23,184,35,2,255,0,27,254,64,1,191,208,0,7,255,255,244,31,255,253,0,15,255,255,253,127,255,255,128,11,249,91,255,255,149,255,208,3,64,0,255,253,0,47,240,0,0,0,63,244,0,15,248,0,0,0,63,240,0,7,252,0,0,0,63,224,0,3,252,0,0,0,63,224,0,3,252,0,43,255,255,255,255,255,252,7,255,255,255,255,255,255,252,31,255,250,191,255,255,255,252,127,244,0,63,224,0,0,0,255,192,0,63,224,0,0,0,255,64,0,63,224,0,0,0,255,0,0,63,240,0,0,0,255,0,0,191,244,0,0,0,255,128,1,255,253,0,0,16,191,208,11,250,255,144,6,240,127,255,255,224,255,255,255,240,47,255,255,128,63,255,255,240,7,255,253,0,7,255,255,128,0,21,64,0,0,21,80,0,
  // 0x00e7  ç
  16,32,128,20,2,246,0,6,255,228,0,127,255,255,2,255,255,255,11,255,234,253,31,253,0,8,63,240,0,0,127,208,0,0,191,192,0,0,191,128,0,0,255,128,0,0,255,64,0,0,255,64,0,0,255,64,0,0,255,128,0,0,191,192,0,0,127,192,0,0,63,224,0,0,47,244,0,1,15,254,64,111,7,255,255,255,1,255,255,255,0,47,255,248,0,0,253,0,0,1,244,0,0,3,254,0,0,1,191,192,0,0,31,208,0,0,15,224,0,0,31,208,0,47,255,192,0,47,255,0,0,10,144,0,
  // 0x00e8  è
  19,32,160,23,2,255,0,170,128,0,0,0,191,208,0,0,0,47,240,0,0,0,11,248,0,0,0,2,253,0,0,0,0,191,0,0,0,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x00e9  é
  19,32,160,23,2,255,0,0,2,170,0,0,0,7,254,0,0,0,15,248,0,0,0,63,224,0,0,0,127,128,0,0,0,254,0,0,0,2,244,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x00ea  ê
  19,32,160,23,2,255,0,2,170,0,0,0,11,255,128,0,0,31,255,208,0,0,63,223,244,0,0,255,3,252,0,3,252,0,255,0,11,224,0,47,128,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x00eb  ë
  19,31,155,23,2,255,0,20,0,16,0,0,254,1,252,0,1,255,2,253,0,0,254,2,253,0,0,120,0,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,127,255,252,0,2,255,255,255,64,11,255,86,255,192,31,244,0,63,224,63,224,0,15,240,63,192,0,11,244,127,192,0,7,248,191,128,0,7,252,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,255,128,0,0,0,255,128,0,0,0,191,192,0,0,0,127,192,0,0,0,63,224,0,0,0,47,248,0,0,16,15,255,64,22,240,3,255,255,255,240,0,255,255,255,240,0,27,255,255,64,0,0,21,64,0,
  // 0x00ec  ì
  9,31,93,11,0,0,170,64,0,191,208,0,63,240,0,15,248,0,3,253,0,0,191,0,0,47,64,0,0,0,0,0,0,1,169,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,2,254,0,
  // 0x00ed  í
  9,31,93,11,3,0,0,170,128,2,255,64,3,254,0,15,248,0,47,224,0,127,64,0,189,0,0,0,0,0,0,0,0,106,64,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,191,128,0,
  // 0x00ee  î
  15,31,124,11,254,0,0,42,160,0,0,191,244,0,1,255,253,0,7,253,255,0,15,240,127,192,63,128,15,240,189,0,2,244,0,0,0,0,0,0,0,0,0,26,144,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,0,47,224,0,
  // 0x00ef  ï
  13,30,120,11,255,0,4,0,20,0,63,64,191,0,127,128,255,64,127,128,191,0,46,0,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,0,191,128,0,
  // 0x00f0  ð
  21,31,186,24,2,255,0,15,128,7,192,0,0,31,248,63,224,0,0,31,255,255,192,0,0,2,255,253,0,0,0,1,255,248,0,0,0,11,255,253,0,0,0,127,246,255,64,0,0,63,128,191,192,0,0,24,0,63,224,0,0,0,0,15,240,0,0,0,0,7,248,0,0,27,255,147,252,0,0,255,255,250,253,0,7,255,255,255,254,0,15,254,85,191,255,0,63,244,0,15,255,0,63,208,0,3,255,0,191,192,0,1,255,0,191,128,0,0,255,64,255,64,0,0,255,64,255,64,0,0,255,0,255,64,0,0,255,0,255,128,0,1,255,0,191,192,0,2,254,0,127,208,0,3,253,0,63,240,0,11,252,0,15,253,0,127,244,0,7,255,255,255,224,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x00f1  ñ
  19,30,150,25,3,0,0,25,0,2,128,0,255,224,11,192,3,255,254,111,128,7,250,255,255,0,15,192,47,253,0,11,64,2,160,0,0,0,0,0,0,0,0,0,0,0,105,0,191,228,0,191,11,255,255,64,191,63,255,255,208,191,255,170,255,240,191,248,0,47,248,191,240,0,15,252,191,208,0,7,252,191,192,0,7,252,191,192,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,191,128,0,3,252,
  // 0x00f2  ò
  21,32,192,24,2,255,0,106,144,0,0,0,0,63,240,0,0,0,0,15,248,0,0,0,0,3,253,0,0,0,0,0,255,0,0,0,0,0,63,128,0,0,0,0,11,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x00f3  ó
  21,32,192,24,2,255,0,0,0,170,128,0,0,0,3,255,64,0,0,0,7,253,0,0,0,0,15,244,0,0,0,0,63,208,0,0,0,0,191,64,0,0,0,0,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x00f4  ô
  21,32,192,24,2,255,0,0,170,64,0,0,0,3,255,192,0,0,0,11,255,240,0,0,0,47,235,252,0,0,0,127,129,254,0,0,1,254,0,127,128,0,2,244,0,11,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x00f5  õ
  21,31,186,24,2,255,0,6,64,1,144,0,0,191,248,3,224,0,1,255,255,159,208,0,3,250,255,255,192,0,3,208,31,255,0,0,3,192,1,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x00f6  ö
  21,31,186,24,2,255,0,4,0,20,0,0,0,127,0,191,0,0,0,191,128,255,0,0,0,191,64,255,0,0,0,46,0,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,0,127,255,254,0,0,2,255,255,255,192,0,11,255,234,255,240,0,31,252,0,47,248,0,63,240,0,11,252,0,63,208,0,3,254,0,127,192,0,2,255,0,191,128,0,1,255,0,255,128,0,0,255,0,255,64,0,0,255,64,255,64,0,0,255,64,255,128,0,0,255,0,255,128,0,0,255,0,191,192,0,1,255,0,127,192,0,2,254,0,63,224,0,3,253,0,31,244,0,15,252,0,15,254,64,127,244,0,3,255,255,255,208,0,0,255,255,255,64,0,0,31,255,248,0,0,0,0,85,0,0,0,
  // 0x00f7  ÷
  19,20,100,23,2,4,0,0,80,0,0,0,2,253,0,0,0,3,254,0,0,0,3,254,0,0,0,2,253,0,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,168,255,255,255,255,252,255,255,255,255,252,170,170,170,170,164,0,0,0,0,0,0,0,0,0,0,0,0,184,0,0,0,3,254,0,0,0,3,254,0,0,0,3,254,0,0,0,1,252,0,0,0,0,16,0,0,
  // 0x00f8  ø
  21,25,150,24,2,254,0,0,0,0,64,0,0,6,255,144,248,0,0,127,255,255,252,0,2,255,255,255,244,0,11,255,234,255,240,0,31,252,0,63,248,0,63,240,0,191,252,0,63,208,1,255,254,0,127,192,3,254,255,0,191,128,11,241,255,0,255,128,31,208,255,0,255,64,63,128,255,64,255,64,255,0,255,64,255,129,253,0,255,0,191,131,248,0,255,0,191,207,240,1,255,0,127,239,192,2,254,0,63,255,64,3,253,0,31,254,0,15,252,0,15,254,64,127,244,0,7,255,255,255,208,0,15,255,255,255,64,0,47,223,255,248,0,0,11,0,85,0,0,0,0,0,0,0,0,0,
  // 0x00f9  ù
  19,32,160,25,3,255,0,170,128,0,0,0,191,208,0,0,0,47,240,0,0,0,11,248,0,0,0,2,253,0,0,0,0,191,0,0,0,0,31,128,0,0,0,0,0,0,0,0,0,0,0,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x00fa  ú
  19,32,160,25,3,255,0,0,2,170,0,0,0,7,254,0,0,0,15,248,0,0,0,47,224,0,0,0,127,128,0,0,0,254,0,0,0,2,244,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x00fb  û
  19,32,160,25,3,255,0,2,170,0,0,0,11,255,128,0,0,31,255,208,0,0,63,223,244,0,0,255,3,252,0,3,252,0,255,0,7,224,0,31,128,0,0,0,0,0,0,0,0,0,0,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x00fc  ü
  19,31,155,25,3,255,0,20,0,16,0,0,254,1,252,0,1,255,2,253,0,0,255,2,253,0,0,120,0,184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,2,164,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,7,252,255,64,0,11,252,255,64,0,11,252,255,128,0,15,252,191,192,0,31,252,191,208,0,63,252,63,248,6,255,252,47,255,255,247,252,15,255,255,211,252,1,255,254,2,252,0,5,80,0,0,
  // 0x00fd  ý
  21,41,246,21,0,246,0,0,0,170,128,0,0,0,1,255,128,0,0,0,3,254,0,0,0,0,11,248,0,0,0,0,31,224,0,0,0,0,63,128,0,0,0,0,189,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,106,128,191,192,0,0,255,128,63,208,0,0,255,64,47,224,0,2,255,0,31,240,0,3,254,0,15,244,0,3,252,0,11,252,0,11,252,0,3,252,0,15,244,0,2,254,0,31,240,0,1,255,0,47,224,0,0,255,64,63,208,0,0,191,128,127,192,0,0,63,192,191,128,0,0,47,208,255,0,0,0,31,225,255,0,0,0,15,242,253,0,0,0,11,243,252,0,0,0,3,251,248,0,0,0,2,255,244,0,0,0,1,255,240,0,0,0,0,255,224,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,255,64,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,7,252,0,0,0,0,47,248,0,0,0,127,255,240,0,0,0,127,255,192,0,0,0,127,254,0,0,0,0,26,144,0,0,0,0,
  // 0x00fe  þ
  20,41,205,25,3,246,85,0,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,191,224,0,191,139,255,254,0,191,111,255,255,192,191,255,170,255,224,191,248,0,47,244,191,224,0,15,252,191,192,0,7,252,191,192,0,3,253,191,128,0,3,254,191,128,0,2,254,191,128,0,2,254,191,128,0,2,254,191,128,0,2,254,191,128,0,3,254,191,192,0,3,253,191,192,0,7,252,191,224,0,11,252,191,244,0,31,248,191,254,65,191,240,191,191,255,255,208,191,95,255,255,64,191,130,255,248,0,191,128,21,64,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,191,128,0,0,0,106,64,0,0,0,
  // 0x00ff  ÿ
  21,40,240,21,0,246,0,5,0,4,0,0,0,63,128,127,0,0,0,127,192,191,64,0,0,63,128,191,64,0,0,30,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,0,106,128,191,192,0,0,255,128,63,208,0,0,255,64,47,224,0,2,255,0,31,240,0,3,254,0,15,244,0,3,252,0,11,252,0,11,252,0,3,252,0,15,244,0,2,254,0,31,240,0,1,255,0,47,224,0,0,255,64,63,208,0,0,191,128,127,192,0,0,63,192,191,128,0,0,47,208,255,0,0,0,31,225,255,0,0,0,15,242,253,0,0,0,11,243,252,0,0,0,3,251,248,0,0,0,2,255,244,0,0,0,1,255,240,0,0,0,0,255,224,0,0,0,0,191,192,0,0,0,0,191,192,0,0,0,0,255,64,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,7,252,0,0,0,0,47,248,0,0,0,127,255,240,0,0,0,127,255,192,0,0,0,127,254,0,0,0,0,26,144,0,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
