/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Vietnamese 38pt, capital 'A' height: 28px, width: 100%, range: 0x0102-0x1ef9, glyphs: 107
extern const uint8_t NotoSans_Medium_Vietnamese_28[15066] = {
  162,28,2,1,249,30,37,246, // unifont_t
  // 0x0102  Ă
  2,1,25,36,252,25,0,0,0,5,0,0,84,0,0,0,15,128,0,248,0,0,0,11,228,7,240,0,0,0,3,255,255,224,0,0,0,1,255,255,128,0,0,0,0,47,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x0103  ă
  3,1,18,30,150,22,1,255,0,80,0,5,0,1,240,0,47,0,0,253,1,190,0,0,127,255,252,0,0,47,255,244,0,0,6,255,128,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,
  // 0x0110  Đ
  16,1,25,27,189,28,1,0,3,255,255,254,64,0,0,3,255,255,255,244,0,0,3,255,255,255,255,0,0,3,253,85,111,255,192,0,3,252,0,1,255,240,0,3,252,0,0,47,248,0,3,252,0,0,11,252,0,3,252,0,0,3,254,0,3,252,0,0,2,255,0,3,252,0,0,0,255,0,3,252,0,0,0,255,64,7,252,0,0,0,255,64,255,255,255,192,0,255,128,255,255,255,192,0,191,128,255,255,255,192,0,255,64,87,253,85,64,0,255,64,3,252,0,0,0,255,64,3,252,0,0,1,255,0,3,252,0,0,2,255,0,3,252,0,0,3,253,0,3,252,0,0,15,252,0,3,252,0,0,63,244,0,3,252,0,2,255,224,0,3,253,86,191,255,128,0,3,255,255,255,253,0,0,3,255,255,255,224,0,0,3,255,255,233,0,0,0,
  // 0x0111  đ
  17,1,22,30,180,24,2,255,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,2,170,175,254,128,0,3,255,255,255,208,0,3,255,255,255,208,0,0,0,11,248,0,0,0,0,11,244,0,0,5,80,11,244,0,0,191,255,75,244,0,3,255,255,215,244,0,15,255,255,255,244,0,47,248,1,255,244,0,63,224,0,63,244,0,127,192,0,15,244,0,191,128,0,15,244,0,255,64,0,11,244,0,255,0,0,11,244,0,255,0,0,7,244,0,255,0,0,7,244,0,255,0,0,11,244,0,255,64,0,11,244,0,191,128,0,15,244,0,127,192,0,15,244,0,63,224,0,47,244,0,47,248,1,255,244,0,15,255,255,251,244,0,3,255,255,211,244,0,0,191,254,3,244,0,0,1,64,0,0,0,
  // 0x0128  Ĩ
  40,1,15,35,140,13,255,0,7,253,0,124,15,255,209,248,63,255,255,240,61,7,255,224,124,0,127,64,0,0,0,0,0,0,0,0,0,0,0,0,11,255,255,192,11,255,255,192,2,255,254,64,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,0,31,240,0,2,255,255,64,11,255,255,192,11,255,255,192,
  // 0x0129  ĩ
  41,1,15,28,112,10,254,0,11,248,0,244,63,255,130,240,127,255,255,224,188,11,255,192,244,0,190,0,0,0,0,0,0,0,0,0,0,21,64,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,
  // 0x0168  Ũ
  104,1,22,36,216,28,3,255,0,11,248,0,240,0,0,63,255,67,240,0,0,191,255,255,224,0,0,248,11,255,192,0,0,240,1,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,128,0,0,31,224,191,128,0,0,47,224,127,192,0,0,47,208,63,192,0,0,63,192,63,224,0,0,191,192,31,248,0,1,255,64,15,255,64,31,255,0,3,255,255,255,252,0,0,255,255,255,224,0,0,27,255,254,64,0,0,0,21,64,0,0,
  // 0x0169  ũ
  105,1,18,29,145,24,3,255,0,191,64,31,0,3,255,244,63,0,11,255,255,253,0,15,129,255,252,0,15,0,27,224,0,0,0,0,0,0,0,0,0,0,0,85,0,0,5,80,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,240,255,0,0,31,240,255,0,0,31,240,255,0,0,47,240,255,64,0,63,240,191,192,0,191,240,127,224,7,255,240,63,255,255,239,240,15,255,255,143,240,2,255,253,11,240,0,5,64,0,0,
  // 0x01a0  Ơ
  160,1,29,30,240,30,2,255,0,0,0,0,0,0,127,192,0,0,5,165,0,0,127,192,0,2,255,255,244,0,191,128,0,47,255,255,255,64,255,0,0,255,255,255,255,225,254,0,2,255,228,1,191,255,252,0,7,255,0,0,15,255,240,0,15,252,0,0,3,255,128,0,47,240,0,0,1,255,64,0,63,224,0,0,0,255,128,0,63,208,0,0,0,127,192,0,127,192,0,0,0,63,192,0,191,192,0,0,0,63,208,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,208,0,127,192,0,0,0,63,208,0,127,192,0,0,0,63,192,0,63,208,0,0,0,191,192,0,63,224,0,0,0,255,128,0,31,244,0,0,1,255,0,0,15,252,0,0,3,254,0,0,7,255,0,0,31,252,0,0,2,255,228,1,255,244,0,0,0,191,255,255,255,208,0,0,0,31,255,255,255,0,0,0,0,1,255,255,228,0,0,0,0,0,1,84,0,0,0,0,
  // 0x01a1  ơ
  161,1,23,25,150,24,2,255,0,0,0,0,2,168,0,0,0,0,3,252,0,0,0,0,3,252,0,6,254,64,7,248,0,191,255,248,15,240,3,255,255,255,127,224,15,255,171,255,255,128,47,244,0,63,253,0,63,208,0,15,240,0,127,192,0,11,248,0,191,64,0,7,252,0,255,64,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,64,0,3,252,0,191,128,0,7,248,0,63,192,0,15,244,0,63,224,0,31,240,0,15,249,0,191,208,0,7,255,255,255,128,0,1,255,255,254,0,0,0,47,255,224,0,0,0,0,84,0,0,0,
  // 0x01af  Ư
  175,1,29,30,240,31,3,255,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,191,64,0,0,31,224,191,64,191,64,0,0,31,224,255,0,191,64,0,0,31,226,254,0,191,64,0,0,31,255,252,0,191,64,0,0,31,255,240,0,191,64,0,0,31,254,64,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,128,0,0,31,224,0,0,127,128,0,0,47,208,0,0,63,192,0,0,63,208,0,0,63,224,0,0,127,192,0,0,31,248,0,1,255,128,0,0,15,255,64,27,255,0,0,0,3,255,255,255,252,0,0,0,0,191,255,255,240,0,0,0,0,11,255,254,64,0,0,0,0,0,21,64,0,0,0,0,
  // 0x01b0  ư
  176,1,25,25,175,27,3,255,0,0,0,0,0,106,128,0,0,0,0,0,127,192,0,0,0,0,0,191,128,85,0,0,5,80,255,0,255,0,0,15,241,255,0,255,0,0,15,247,252,0,255,0,0,15,255,244,0,255,0,0,15,255,128,0,255,0,0,15,244,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,47,240,0,0,255,64,0,63,240,0,0,191,192,0,191,240,0,0,127,224,7,255,240,0,0,63,255,255,239,240,0,0,15,255,255,143,240,0,0,2,255,253,11,240,0,0,0,5,64,0,0,0,0,
  // 0x0303  ̃
  3,3,15,5,20,0,237,23,11,248,0,244,47,255,130,240,127,255,255,224,188,11,255,192,244,0,190,0,
  // 0x0309  ̉
  9,3,8,10,20,0,241,22,5,0,127,244,127,253,0,191,0,127,0,190,11,252,15,208,15,192,6,64,
  // 0x0323  ̣
  35,3,5,6,12,0,242,248,25,0,191,64,255,128,191,128,63,0,0,0,
  // 0x0340  ̀
  64,3,9,6,18,0,249,23,127,208,0,47,240,0,11,248,0,2,253,0,0,191,0,0,31,128,
  // 0x0341  ́
  65,3,9,6,18,0,254,23,1,255,64,3,254,0,11,248,0,31,224,0,63,128,0,189,0,0,
  // 0x1ea0  Ạ
  160,30,25,36,252,25,0,248,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,144,0,0,0,0,0,7,244,0,0,0,0,0,15,248,0,0,0,0,0,11,248,0,0,0,0,0,3,240,0,0,0,0,0,0,0,0,0,0,
  // 0x1ea1  ạ
  161,30,18,29,145,22,1,248,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,0,0,0,0,0,0,0,36,0,0,0,0,255,0,0,0,1,255,0,0,0,1,255,0,0,0,0,189,0,0,0,0,0,0,0,
  // 0x1ea2  Ả
  162,30,25,39,17,25,0,0,0,0,5,64,0,0,0,0,0,63,248,0,0,0,0,0,63,255,0,0,0,0,0,0,127,64,0,0,0,0,0,63,64,0,0,0,0,0,127,0,0,0,0,0,7,254,0,0,0,0,0,7,228,0,0,0,0,0,7,208,0,0,0,0,0,2,128,0,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x1ea3  ả
  163,30,18,33,165,22,1,255,0,0,80,0,0,0,7,255,64,0,0,7,255,208,0,0,0,11,240,0,0,0,3,240,0,0,0,11,224,0,0,0,191,192,0,0,0,254,0,0,0,0,252,0,0,0,0,100,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,
  // 0x1ea4  Ấ
  164,30,25,37,3,25,0,0,0,0,0,0,3,252,0,0,0,0,0,11,240,0,0,0,10,168,15,192,0,0,0,47,253,63,0,0,0,0,127,255,0,0,0,0,1,253,47,192,0,0,0,3,240,7,240,0,0,0,6,128,0,164,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x1ea5  ấ
  165,30,21,32,192,22,1,255,0,0,0,0,127,64,0,0,0,0,254,0,0,0,85,2,248,0,0,3,255,135,224,0,0,15,255,209,64,0,0,47,199,240,0,0,0,127,1,252,0,0,0,248,0,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,0,1,255,255,253,0,0,3,255,255,255,64,0,1,254,86,255,192,0,0,144,0,63,208,0,0,0,0,31,224,0,0,0,0,31,224,0,0,0,0,15,240,0,0,0,21,111,240,0,0,111,255,255,240,0,3,255,255,255,240,0,15,255,148,31,240,0,47,240,0,15,240,0,63,208,0,31,240,0,63,192,0,31,240,0,127,192,0,47,240,0,63,192,0,127,240,0,63,240,2,255,240,0,47,255,255,239,240,0,15,255,255,139,240,0,1,255,253,3,240,0,0,5,64,0,0,0,
  // 0x1ea6  Ầ
  166,30,25,37,3,25,0,0,15,224,0,0,0,0,0,3,240,0,0,0,0,0,1,252,10,168,0,0,0,0,62,47,253,0,0,0,0,0,127,255,0,0,0,0,1,253,47,192,0,0,0,3,240,7,240,0,0,0,10,128,0,164,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x1ea7  ầ
  167,30,19,32,160,22,0,255,191,0,0,0,0,63,128,0,0,0,15,208,21,64,0,3,240,255,224,0,0,82,255,244,0,0,7,241,253,0,0,31,192,127,0,0,62,0,11,192,0,0,0,0,0,0,0,0,0,0,0,1,191,228,0,0,127,255,255,64,0,255,255,255,208,0,127,149,191,240,0,36,0,15,244,0,0,0,7,248,0,0,0,7,248,0,0,0,3,252,0,0,5,91,252,0,27,255,255,252,0,255,255,255,252,3,255,229,7,252,11,252,0,3,252,15,244,0,7,252,15,240,0,7,252,31,240,0,11,252,15,240,0,31,252,15,252,0,191,252,11,255,255,251,252,3,255,255,226,252,0,127,255,64,252,0,1,80,0,0,
  // 0x1ea8  Ẩ
  168,30,25,40,24,25,0,0,0,0,0,0,20,0,0,0,0,0,0,191,192,0,0,0,0,0,91,224,0,0,0,0,0,2,224,0,0,0,0,0,7,208,0,0,0,10,164,47,64,0,0,0,63,253,45,0,0,0,0,191,255,0,0,0,0,1,253,47,192,0,0,0,3,240,7,224,0,0,0,10,128,0,160,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x1ea9  ẩ
  169,30,20,34,170,22,1,255,0,0,0,15,244,0,0,0,10,252,0,0,0,0,61,0,0,0,0,124,0,0,85,3,244,0,3,255,131,192,0,11,255,225,64,0,31,215,244,0,0,127,0,252,0,0,248,0,47,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,
  // 0x1eaa  Ẫ
  170,30,25,40,24,25,0,0,0,0,190,0,120,0,0,0,2,255,229,244,0,0,0,3,235,255,240,0,0,0,11,64,191,192,0,0,0,1,0,0,0,0,0,0,0,6,164,0,0,0,0,0,31,252,0,0,0,0,0,63,255,0,0,0,0,0,253,47,192,0,0,0,3,244,7,240,0,0,0,6,128,0,164,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x1eab  ẫ
  171,30,18,35,175,22,1,255,0,6,64,10,0,0,63,248,31,0,0,191,255,253,0,0,240,47,252,0,0,144,1,144,0,0,0,85,0,0,0,2,255,64,0,0,11,255,208,0,0,31,219,240,0,0,127,1,252,0,0,248,0,47,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,
  // 0x1eac  Ậ
  172,30,25,44,52,25,0,248,0,0,15,252,0,0,0,0,0,63,254,0,0,0,0,0,191,255,128,0,0,0,2,253,47,208,0,0,0,7,244,7,244,0,0,0,31,192,1,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,144,0,0,0,0,0,7,244,0,0,0,0,0,11,252,0,0,0,0,0,11,248,0,0,0,0,0,3,240,0,0,0,0,0,0,0,0,0,0,
  // 0x1ead  ậ
  173,30,18,37,185,22,1,248,0,2,255,128,0,0,7,255,208,0,0,15,255,240,0,0,63,195,252,0,0,254,0,255,0,3,244,0,47,128,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,0,0,0,0,0,0,0,100,0,0,0,1,254,0,0,0,2,255,0,0,0,2,254,0,0,0,0,252,0,0,0,0,0,0,0,
  // 0x1eae  Ắ
  174,30,25,39,17,25,0,0,0,0,0,21,64,0,0,0,0,0,63,64,0,0,0,0,0,190,0,0,0,0,0,1,248,0,0,0,0,6,131,208,160,0,0,0,7,192,1,240,0,0,0,3,244,7,240,0,0,0,1,255,255,208,0,0,0,0,191,255,64,0,0,0,0,6,164,0,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x1eaf  ắ
  175,30,18,33,165,22,1,255,0,0,11,240,0,0,0,15,192,0,0,0,63,64,0,0,80,124,5,0,0,244,0,46,0,0,188,0,189,0,0,127,255,252,0,0,31,255,240,0,0,2,255,64,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,
  // 0x1eb0  Ằ
  176,30,25,39,17,25,0,0,0,0,84,0,0,0,0,0,0,191,0,0,0,0,0,0,63,64,0,0,0,0,0,15,192,0,0,0,0,6,130,224,160,0,0,0,7,192,1,240,0,0,0,3,244,7,240,0,0,0,2,255,255,208,0,0,0,0,191,255,64,0,0,0,0,6,164,0,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x1eb1  ằ
  177,30,18,33,165,22,1,255,0,47,192,0,0,0,11,224,0,0,0,2,244,0,0,0,80,188,5,0,0,244,0,62,0,0,188,0,189,0,0,127,255,252,0,0,47,255,240,0,0,6,255,64,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,
  // 0x1eb2  Ẳ
  178,30,25,40,24,25,0,0,0,0,10,144,0,0,0,0,0,15,248,0,0,0,0,0,0,124,0,0,0,0,0,0,60,0,0,0,0,0,3,248,0,0,0,0,6,131,192,160,0,0,0,7,192,1,240,0,0,0,3,244,7,240,0,0,0,2,255,255,208,0,0,0,0,191,255,64,0,0,0,0,6,164,0,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x1eb3  ẳ
  179,30,18,35,175,22,1,255,0,0,80,0,0,0,1,255,0,0,0,0,95,128,0,0,0,11,128,0,0,0,47,64,0,0,80,124,5,0,0,248,16,46,0,0,189,0,125,0,0,63,255,252,0,0,31,255,240,0,0,2,255,128,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,
  // 0x1eb4  Ẵ
  180,30,25,40,24,25,0,0,0,0,126,0,120,0,0,0,2,255,224,244,0,0,0,3,235,255,240,0,0,0,11,128,191,208,0,0,0,1,0,0,0,0,0,0,1,64,0,80,0,0,0,7,192,1,240,0,0,0,3,224,7,240,0,0,0,2,255,255,208,0,0,0,0,191,255,64,0,0,0,0,10,164,0,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x1eb5  ẵ
  181,30,18,35,175,22,1,255,0,6,64,6,0,0,63,248,15,0,0,191,255,254,0,0,240,47,252,0,0,144,1,144,0,0,0,0,0,0,0,244,0,46,0,0,252,0,125,0,0,127,239,252,0,0,47,255,244,0,0,6,255,128,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,
  // 0x1eb6  Ặ
  182,30,25,44,52,25,0,248,0,5,64,0,84,0,0,0,11,192,0,248,0,0,0,7,228,7,244,0,0,0,3,255,255,240,0,0,0,0,255,255,192,0,0,0,0,31,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,144,0,0,0,0,0,7,244,0,0,0,0,0,11,252,0,0,0,0,0,11,248,0,0,0,0,0,3,240,0,0,0,0,0,0,0,0,0,0,
  // 0x1eb7  ặ
  183,30,18,37,185,22,1,248,0,80,0,5,0,0,244,0,31,0,0,253,1,191,0,0,127,255,253,0,0,31,255,244,0,0,2,255,128,0,0,0,0,0,0,0,0,0,0,0,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,0,0,0,0,0,0,0,96,0,0,0,2,252,0,0,0,3,253,0,0,0,3,253,0,0,0,1,248,0,0,0,0,0,0,0,
  // 0x1eb8  Ẹ
  184,30,16,35,140,21,3,248,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,0,0,0,0,0,0,0,0,0,1,144,0,0,11,244,0,0,15,248,0,0,15,248,0,0,3,240,0,0,0,0,0,
  // 0x1eb9  ẹ
  185,30,18,29,145,22,2,248,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,0,0,0,0,0,0,0,100,0,0,0,2,253,0,0,0,3,254,0,0,0,3,254,0,0,0,1,252,0,0,0,0,0,0,0,
  // 0x1eba  Ẻ
  186,30,16,39,156,21,3,0,0,1,64,0,0,47,253,0,0,47,255,0,0,0,127,128,0,0,47,128,0,0,63,64,0,3,254,0,0,3,244,0,0,3,208,0,0,2,128,0,0,0,0,0,0,0,0,0,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x1ebb  ẻ
  187,30,18,33,165,22,2,255,0,0,80,0,0,0,11,255,64,0,0,11,255,208,0,0,0,15,224,0,0,0,7,224,0,0,0,15,224,0,0,0,191,192,0,0,0,253,0,0,0,0,248,0,0,0,0,164,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,
  // 0x1ebc  Ẽ
  188,30,16,35,140,21,3,0,1,254,64,46,7,255,228,125,15,255,255,252,31,65,255,244,46,0,47,144,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x1ebd  ẽ
  189,30,18,29,145,22,2,255,0,191,64,31,0,3,255,244,63,0,11,255,255,253,0,15,129,255,248,0,15,0,27,224,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,
  // 0x1ebe  Ế
  190,30,19,37,185,21,3,0,0,0,0,3,248,0,0,0,11,240,0,10,164,31,192,0,47,253,62,0,0,191,255,0,0,1,253,47,192,0,3,240,7,224,0,10,128,0,164,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,0,127,255,255,255,0,127,255,255,255,0,127,213,85,85,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,255,255,252,0,127,255,255,252,0,127,255,255,252,0,127,234,170,168,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,234,170,169,0,127,255,255,255,0,127,255,255,255,0,127,255,255,255,0,
  // 0x1ebf  ế
  191,30,20,32,160,22,2,255,0,0,0,0,254,0,0,0,2,252,0,1,84,3,240,0,11,255,15,192,0,31,255,133,0,0,127,79,224,0,0,253,3,244,0,3,240,0,188,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,
  // 0x1ec0  Ề
  192,30,18,37,185,21,1,0,254,0,0,0,0,63,64,0,0,0,31,192,170,128,0,3,226,255,208,0,0,7,255,240,0,0,15,210,252,0,0,63,0,127,0,0,104,0,10,64,0,0,0,0,0,0,0,0,0,0,7,255,255,255,240,7,255,255,255,240,7,255,255,255,240,7,253,85,85,80,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,255,255,255,192,7,255,255,255,192,7,255,255,255,192,7,254,170,170,128,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,254,170,170,144,7,255,255,255,240,7,255,255,255,240,7,255,255,255,240,
  // 0x1ec1  ề
  193,30,19,32,160,22,1,255,253,0,0,0,0,127,0,0,0,0,47,128,85,0,0,7,210,255,192,0,0,87,255,240,0,0,15,227,248,0,0,63,64,190,0,0,188,0,31,64,0,0,0,0,0,0,0,0,0,0,0,1,191,144,0,0,47,255,253,0,0,255,255,255,64,3,255,149,255,192,11,252,0,47,240,15,240,0,15,240,31,224,0,7,248,47,208,0,7,248,63,213,85,87,252,63,255,255,255,252,63,255,255,255,252,63,234,170,170,168,63,192,0,0,0,63,208,0,0,0,47,224,0,0,0,31,240,0,0,0,15,252,0,0,0,7,255,64,1,240,1,255,255,255,240,0,127,255,255,240,0,11,255,255,128,0,0,21,64,0,
  // 0x1ec2  Ể
  194,30,18,40,200,21,3,0,0,0,0,20,0,0,0,0,191,192,0,0,0,91,224,0,0,0,2,224,0,0,0,7,208,0,10,164,47,64,0,63,253,45,0,0,191,255,0,0,1,253,47,192,0,7,240,7,224,0,10,128,0,160,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,0,127,255,255,255,0,127,255,255,255,0,127,213,85,85,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,255,255,252,0,127,255,255,252,0,127,255,255,252,0,127,234,170,168,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,234,170,169,0,127,255,255,255,0,127,255,255,255,0,127,255,255,255,0,
  // 0x1ec3  ể
  195,30,19,34,170,22,2,255,0,0,0,63,208,0,0,0,43,240,0,0,0,0,244,0,0,0,1,244,0,1,84,15,208,0,15,255,15,0,0,47,255,133,0,0,127,95,208,0,0,252,3,244,0,3,224,0,188,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,
  // 0x1ec4  Ễ
  196,30,16,40,160,21,3,0,0,189,0,116,3,255,225,240,7,235,255,224,11,64,191,192,5,0,0,0,0,10,160,0,0,31,252,0,0,127,255,0,1,253,47,128,3,240,7,224,10,128,0,160,0,0,0,0,0,0,0,0,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x1ec5  ễ
  197,30,18,35,175,22,2,255,0,25,0,24,0,0,255,224,60,0,1,255,255,248,0,3,208,127,240,0,2,128,6,64,0,0,1,84,0,0,0,7,254,0,0,0,31,255,128,0,0,63,95,208,0,0,253,3,244,0,3,224,0,188,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,
  // 0x1ec6  Ệ
  198,30,16,44,176,21,3,248,0,15,252,0,0,47,255,0,0,191,255,128,1,254,31,224,7,244,7,248,15,192,0,253,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,0,0,0,0,0,0,0,0,0,1,144,0,0,11,244,0,0,15,248,0,0,15,248,0,0,3,240,0,0,0,0,0,
  // 0x1ec7  ệ
  199,30,18,37,185,22,2,248,0,11,254,0,0,0,31,255,64,0,0,63,255,192,0,0,255,15,240,0,3,252,3,252,0,11,208,0,190,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,0,0,0,0,0,0,0,100,0,0,0,2,253,0,0,0,3,254,0,0,0,3,254,0,0,0,1,252,0,0,0,0,0,0,0,
  // 0x1ec8  Ỉ
  200,30,11,38,114,13,1,0,1,165,0,3,255,192,3,255,240,0,7,240,0,3,240,0,11,240,0,191,192,0,189,0,0,188,0,0,16,0,0,0,0,191,255,252,191,255,252,47,255,228,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,47,255,244,191,255,252,191,255,252,
  // 0x1ec9  ỉ
  201,30,8,32,64,10,2,0,5,0,255,240,255,252,1,253,0,190,0,253,15,248,31,208,15,64,10,0,0,0,21,64,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,
  // 0x1eca  Ị
  202,30,11,35,105,13,1,248,191,255,252,191,255,252,47,255,228,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,47,255,244,191,255,252,191,255,252,0,0,0,0,0,0,0,100,0,1,254,0,2,255,0,1,255,0,0,253,0,0,0,0,
  // 0x1ecb  ị
  203,30,5,36,72,10,3,248,191,0,255,64,255,64,191,0,4,0,0,0,0,0,85,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,0,0,0,0,24,0,255,0,255,64,255,64,126,0,0,0,
  // 0x1ecc  Ọ
  204,30,26,36,252,30,2,248,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,3,252,0,0,0,0,0,7,252,0,0,0,0,0,3,252,0,0,0,0,0,2,244,0,0,0,0,0,0,0,0,0,0,
  // 0x1ecd  ọ
  205,30,19,29,145,23,2,248,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,0,0,0,0,0,0,0,100,0,0,0,1,253,0,0,0,2,254,0,0,0,2,254,0,0,0,0,252,0,0,0,0,0,0,0,
  // 0x1ece  Ỏ
  206,30,26,39,17,30,2,255,0,0,6,164,0,0,0,0,0,15,255,64,0,0,0,0,15,255,192,0,0,0,0,0,15,208,0,0,0,0,0,15,208,0,0,0,0,0,47,192,0,0,0,0,2,255,64,0,0,0,0,1,248,0,0,0,0,0,1,240,0,0,0,0,0,0,80,0,0,0,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,
  // 0x1ecf  ỏ
  207,30,19,33,165,23,2,255,0,0,80,0,0,0,7,255,64,0,0,7,255,208,0,0,0,11,240,0,0,0,3,240,0,0,0,11,224,0,0,0,191,192,0,0,0,254,0,0,0,0,252,0,0,0,0,100,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,
  // 0x1ed0  Ố
  208,30,26,38,10,30,2,255,0,0,0,0,1,253,0,0,0,0,0,3,244,0,0,0,6,168,11,208,0,0,0,15,255,31,64,0,0,0,63,255,128,0,0,0,0,190,15,208,0,0,0,2,248,3,244,0,0,0,2,144,0,104,0,0,0,0,0,0,0,0,0,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,
  // 0x1ed1  ố
  209,30,20,32,160,23,2,255,0,0,0,0,191,0,0,0,0,253,0,1,85,3,244,0,7,255,75,208,0,15,255,197,0,0,63,139,240,0,0,190,2,248,0,1,244,0,125,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,
  // 0x1ed2  Ồ
  210,30,26,38,10,30,2,255,7,244,0,0,0,0,0,2,252,0,0,0,0,0,0,190,6,168,0,0,0,0,31,15,255,0,0,0,0,0,63,255,128,0,0,0,0,191,15,224,0,0,0,2,248,2,244,0,0,0,2,144,0,104,0,0,0,0,0,0,0,0,0,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,
  // 0x1ed3  ồ
  211,30,20,32,160,23,1,255,254,0,0,0,0,127,64,0,0,0,31,192,85,64,0,3,225,255,208,0,0,83,255,240,0,0,15,242,252,0,0,47,128,127,0,0,125,0,31,128,0,0,0,0,0,0,0,0,0,0,0,1,191,144,0,0,47,255,254,0,0,255,255,255,192,3,255,234,255,240,11,253,0,31,248,15,244,0,3,252,31,240,0,2,254,47,224,0,1,255,63,208,0,0,255,63,192,0,0,255,63,192,0,0,255,63,192,0,0,255,63,192,0,0,255,63,208,0,0,255,47,224,0,1,254,15,240,0,3,253,15,248,0,11,252,3,255,64,47,244,1,255,255,255,224,0,127,255,255,128,0,11,255,248,0,0,0,21,0,0,
  // 0x1ed4  Ổ
  212,30,26,41,31,30,2,255,0,0,0,0,21,0,0,0,0,0,0,63,208,0,0,0,0,0,22,240,0,0,0,0,0,0,240,0,0,0,0,0,6,240,0,0,0,6,168,15,128,0,0,0,15,255,15,0,0,0,0,63,255,128,0,0,0,0,254,15,208,0,0,0,2,248,3,244,0,0,0,2,144,0,168,0,0,0,0,0,0,0,0,0,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,
  // 0x1ed5  ổ
  213,30,19,34,170,23,2,255,0,0,0,31,224,0,0,0,10,248,0,0,0,0,124,0,0,0,0,184,0,1,85,7,224,0,7,255,71,128,0,15,255,193,0,0,63,139,240,0,0,190,2,248,0,1,244,0,125,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,
  // 0x1ed6  Ỗ
  214,30,26,41,31,30,2,255,0,0,110,64,60,0,0,0,0,255,244,188,0,0,0,3,251,255,244,0,0,0,3,192,127,224,0,0,0,1,0,1,0,0,0,0,0,2,168,0,0,0,0,0,15,254,0,0,0,0,0,47,255,128,0,0,0,0,191,15,208,0,0,0,2,248,2,244,0,0,0,2,144,0,104,0,0,0,0,0,0,0,0,0,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,
  // 0x1ed7  ỗ
  215,30,19,35,175,23,2,255,0,10,64,9,0,0,127,244,46,0,0,255,255,252,0,1,240,111,248,0,1,128,1,144,0,0,0,84,0,0,0,3,255,0,0,0,15,255,192,0,0,47,207,240,0,0,190,2,248,0,1,244,0,62,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,
  // 0x1ed8  Ộ
  216,30,26,44,52,30,2,248,0,0,11,254,0,0,0,0,0,31,255,64,0,0,0,0,63,255,192,0,0,0,0,255,15,240,0,0,0,3,252,3,252,0,0,0,11,208,0,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,3,252,0,0,0,0,0,7,252,0,0,0,0,0,3,252,0,0,0,0,0,2,244,0,0,0,0,0,0,0,0,0,0,
  // 0x1ed9  ộ
  217,30,19,37,185,23,2,248,0,3,255,0,0,0,11,255,192,0,0,47,255,224,0,0,127,135,248,0,1,253,1,254,0,3,240,0,63,64,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,0,0,0,0,0,0,0,100,0,0,0,1,253,0,0,0,2,254,0,0,0,2,254,0,0,0,0,252,0,0,0,0,0,0,0,
  // 0x1eda  Ớ
  218,30,29,37,40,30,2,255,0,0,0,15,248,0,0,0,0,0,0,63,224,0,0,0,0,0,0,127,192,0,0,0,0,0,0,255,0,0,0,0,0,0,3,248,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,192,0,0,5,165,0,0,127,192,0,2,255,255,244,0,191,128,0,47,255,255,255,64,255,0,0,255,255,255,255,225,254,0,2,255,228,1,191,255,252,0,7,255,0,0,15,255,240,0,15,252,0,0,3,255,128,0,47,240,0,0,1,255,64,0,63,224,0,0,0,255,128,0,63,208,0,0,0,127,192,0,127,192,0,0,0,63,192,0,191,192,0,0,0,63,208,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,208,0,127,192,0,0,0,63,208,0,127,192,0,0,0,63,192,0,63,208,0,0,0,191,192,0,63,224,0,0,0,255,128,0,31,244,0,0,1,255,0,0,15,252,0,0,3,254,0,0,7,255,0,0,31,252,0,0,2,255,228,1,255,244,0,0,0,191,255,255,255,208,0,0,0,31,255,255,255,0,0,0,0,1,255,255,228,0,0,0,0,0,1,84,0,0,0,0,
  // 0x1edb  ớ
  219,30,23,30,180,24,2,255,0,0,11,253,0,0,0,0,15,244,0,0,0,0,63,208,0,0,0,0,191,64,0,0,0,1,253,0,0,0,0,3,244,0,2,168,0,0,0,0,3,252,0,0,0,0,3,252,0,6,254,64,7,248,0,191,255,248,15,240,3,255,255,255,127,224,15,255,171,255,255,128,47,244,0,63,253,0,63,208,0,15,240,0,127,192,0,11,248,0,191,64,0,7,252,0,255,64,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,64,0,3,252,0,191,128,0,7,248,0,63,192,0,15,244,0,63,224,0,31,240,0,15,249,0,191,208,0,7,255,255,255,128,0,1,255,255,254,0,0,0,47,255,224,0,0,0,0,84,0,0,0,
  // 0x1edc  Ờ
  220,30,29,37,40,30,2,255,0,2,255,64,0,0,0,0,0,0,191,192,0,0,0,0,0,0,47,224,0,0,0,0,0,0,11,244,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,192,0,0,5,165,0,0,127,192,0,2,255,255,244,0,191,128,0,47,255,255,255,64,255,0,0,255,255,255,255,225,254,0,2,255,228,1,191,255,252,0,7,255,0,0,15,255,240,0,15,252,0,0,3,255,128,0,47,240,0,0,1,255,64,0,63,224,0,0,0,255,128,0,63,208,0,0,0,127,192,0,127,192,0,0,0,63,192,0,191,192,0,0,0,63,208,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,208,0,127,192,0,0,0,63,208,0,127,192,0,0,0,63,192,0,63,208,0,0,0,191,192,0,63,224,0,0,0,255,128,0,31,244,0,0,1,255,0,0,15,252,0,0,3,254,0,0,7,255,0,0,31,252,0,0,2,255,228,1,255,244,0,0,0,191,255,255,255,208,0,0,0,31,255,255,255,0,0,0,0,1,255,255,228,0,0,0,0,0,1,84,0,0,0,0,
  // 0x1edd  ờ
  221,30,23,30,180,24,2,255,0,255,192,0,0,0,0,63,224,0,0,0,0,15,240,0,0,0,0,3,252,0,0,0,0,0,254,0,0,0,0,0,47,64,2,168,0,0,0,0,3,252,0,0,0,0,3,252,0,6,254,64,7,248,0,191,255,248,15,240,3,255,255,255,127,224,15,255,171,255,255,128,47,244,0,63,253,0,63,208,0,15,240,0,127,192,0,11,248,0,191,64,0,7,252,0,255,64,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,64,0,3,252,0,191,128,0,7,248,0,63,192,0,15,244,0,63,224,0,31,240,0,15,249,0,191,208,0,7,255,255,255,128,0,1,255,255,254,0,0,0,47,255,224,0,0,0,0,84,0,0,0,
  // 0x1ede  Ở
  222,30,29,40,64,30,2,255,0,0,1,64,0,0,0,0,0,0,31,254,0,0,0,0,0,0,31,255,128,0,0,0,0,0,0,47,192,0,0,0,0,0,0,15,192,0,0,0,0,0,0,47,192,0,0,0,0,0,2,255,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,240,0,0,0,0,0,0,1,144,0,0,0,0,0,0,0,0,0,0,127,192,0,0,5,165,0,0,127,192,0,2,255,255,244,0,191,128,0,47,255,255,255,64,255,0,0,255,255,255,255,225,254,0,2,255,228,1,191,255,252,0,7,255,0,0,15,255,240,0,15,252,0,0,3,255,128,0,47,240,0,0,1,255,64,0,63,224,0,0,0,255,128,0,63,208,0,0,0,127,192,0,127,192,0,0,0,63,192,0,191,192,0,0,0,63,208,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,208,0,127,192,0,0,0,63,208,0,127,192,0,0,0,63,192,0,63,208,0,0,0,191,192,0,63,224,0,0,0,255,128,0,31,244,0,0,1,255,0,0,15,252,0,0,3,254,0,0,7,255,0,0,31,252,0,0,2,255,228,1,255,244,0,0,0,191,255,255,255,208,0,0,0,31,255,255,255,0,0,0,0,1,255,255,228,0,0,0,0,0,1,84,0,0,0,0,
  // 0x1edf  ở
  223,30,23,33,198,24,2,255,0,0,80,0,0,0,0,11,255,64,0,0,0,11,255,192,0,0,0,0,31,224,0,0,0,0,11,224,0,0,0,0,15,208,0,0,0,0,255,128,0,0,0,0,253,0,0,0,0,0,244,0,2,168,0,0,160,0,3,252,0,0,0,0,3,252,0,6,254,64,7,248,0,191,255,248,15,240,3,255,255,255,127,224,15,255,171,255,255,128,47,244,0,63,253,0,63,208,0,15,240,0,127,192,0,11,248,0,191,64,0,7,252,0,255,64,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,64,0,3,252,0,191,128,0,7,248,0,63,192,0,15,244,0,63,224,0,31,240,0,15,249,0,191,208,0,7,255,255,255,128,0,1,255,255,254,0,0,0,47,255,224,0,0,0,0,84,0,0,0,
  // 0x1ee0  Ỡ
  224,30,29,36,32,30,2,255,0,0,255,64,31,0,0,0,0,3,255,244,63,0,0,0,0,11,255,255,253,0,0,0,0,15,129,255,248,0,0,0,0,15,0,27,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,192,0,0,5,165,0,0,127,192,0,2,255,255,244,0,191,128,0,47,255,255,255,64,255,0,0,255,255,255,255,225,254,0,2,255,228,1,191,255,252,0,7,255,0,0,15,255,240,0,15,252,0,0,3,255,128,0,47,240,0,0,1,255,64,0,63,224,0,0,0,255,128,0,63,208,0,0,0,127,192,0,127,192,0,0,0,63,192,0,191,192,0,0,0,63,208,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,208,0,127,192,0,0,0,63,208,0,127,192,0,0,0,63,192,0,63,208,0,0,0,191,192,0,63,224,0,0,0,255,128,0,31,244,0,0,1,255,0,0,15,252,0,0,3,254,0,0,7,255,0,0,31,252,0,0,2,255,228,1,255,244,0,0,0,191,255,255,255,208,0,0,0,31,255,255,255,0,0,0,0,1,255,255,228,0,0,0,0,0,1,84,0,0,0,0,
  // 0x1ee1  ỡ
  225,30,23,29,174,24,2,255,0,127,208,11,128,0,1,255,249,31,64,0,3,255,255,255,0,0,7,208,127,253,0,0,11,128,11,244,2,168,0,0,0,0,3,252,0,0,0,0,3,252,0,6,254,64,7,248,0,191,255,248,15,240,3,255,255,255,127,224,15,255,171,255,255,128,47,244,0,63,253,0,63,208,0,15,240,0,127,192,0,11,248,0,191,64,0,7,252,0,255,64,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,64,0,3,252,0,191,128,0,7,248,0,63,192,0,15,244,0,63,224,0,31,240,0,15,249,0,191,208,0,7,255,255,255,128,0,1,255,255,254,0,0,0,47,255,224,0,0,0,0,84,0,0,0,
  // 0x1ee2  Ợ
  226,30,29,37,40,30,2,248,0,0,0,0,0,0,127,192,0,0,5,165,0,0,127,192,0,2,255,255,244,0,191,128,0,47,255,255,255,64,255,0,0,255,255,255,255,225,254,0,2,255,228,1,191,255,252,0,7,255,0,0,15,255,240,0,15,252,0,0,3,255,128,0,47,240,0,0,1,255,64,0,63,224,0,0,0,255,128,0,63,208,0,0,0,127,192,0,127,192,0,0,0,63,192,0,191,192,0,0,0,63,208,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,224,0,191,128,0,0,0,63,208,0,191,128,0,0,0,63,208,0,127,192,0,0,0,63,208,0,127,192,0,0,0,63,192,0,63,208,0,0,0,191,192,0,63,224,0,0,0,255,128,0,31,244,0,0,1,255,0,0,15,252,0,0,3,254,0,0,7,255,0,0,31,252,0,0,2,255,228,1,255,244,0,0,0,191,255,255,255,208,0,0,0,31,255,255,255,0,0,0,0,1,255,255,228,0,0,0,0,0,1,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,2,244,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x1ee3  ợ
  227,30,23,32,192,24,2,248,0,0,0,0,2,168,0,0,0,0,3,252,0,0,0,0,3,252,0,6,254,64,7,248,0,191,255,248,15,240,3,255,255,255,127,224,15,255,171,255,255,128,47,244,0,63,253,0,63,208,0,15,240,0,127,192,0,11,248,0,191,64,0,7,252,0,255,64,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,0,0,3,252,0,255,64,0,3,252,0,191,128,0,7,248,0,63,192,0,15,244,0,63,224,0,31,240,0,15,249,0,191,208,0,7,255,255,255,128,0,1,255,255,254,0,0,0,47,255,224,0,0,0,0,84,0,0,0,0,0,0,0,0,0,0,0,100,0,0,0,0,1,253,0,0,0,0,2,255,0,0,0,0,2,254,0,0,0,0,0,252,0,0,0,0,0,0,0,0,0,
  // 0x1ee4  Ụ
  228,30,22,35,210,28,3,248,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,128,0,0,31,224,191,128,0,0,47,224,127,192,0,0,47,208,63,192,0,0,63,192,63,224,0,0,191,192,31,248,0,1,255,64,15,255,64,31,255,0,3,255,255,255,252,0,0,255,255,255,224,0,0,27,255,254,64,0,0,0,21,64,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,63,192,0,0,0,0,127,192,0,0,0,0,63,192,0,0,0,0,47,64,0,0,0,0,0,0,0,0,
  // 0x1ee5  ụ
  229,30,18,29,145,24,3,248,85,0,0,5,80,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,240,255,0,0,31,240,255,0,0,31,240,255,0,0,47,240,255,64,0,63,240,191,192,0,191,240,127,224,7,255,240,63,255,255,239,240,15,255,255,143,240,2,255,253,11,240,0,5,64,0,0,0,0,0,0,0,0,1,144,0,0,0,11,244,0,0,0,15,248,0,0,0,15,248,0,0,0,3,240,0,0,0,0,0,0,0,
  // 0x1ee6  Ủ
  230,30,22,39,234,28,3,255,0,0,106,64,0,0,0,0,255,240,0,0,0,0,255,252,0,0,0,0,0,252,0,0,0,0,0,252,0,0,0,0,2,252,0,0,0,0,47,240,0,0,0,0,47,64,0,0,0,0,31,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,64,0,0,31,224,191,128,0,0,31,224,191,128,0,0,47,224,127,192,0,0,47,208,63,192,0,0,63,192,63,224,0,0,191,192,31,248,0,1,255,64,15,255,64,31,255,0,3,255,255,255,252,0,0,255,255,255,224,0,0,27,255,254,64,0,0,0,21,64,0,0,
  // 0x1ee7  ủ
  231,30,18,33,165,24,3,255,0,1,64,0,0,0,15,254,0,0,0,15,255,128,0,0,0,47,192,0,0,0,15,192,0,0,0,47,192,0,0,2,255,64,0,0,3,248,0,0,0,2,240,0,0,0,1,144,0,0,0,0,0,0,0,85,0,0,5,80,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,240,255,0,0,31,240,255,0,0,31,240,255,0,0,47,240,255,64,0,63,240,191,192,0,191,240,127,224,7,255,240,63,255,255,239,240,15,255,255,143,240,2,255,253,11,240,0,5,64,0,0,
  // 0x1ee8  Ứ
  232,30,29,37,40,31,3,255,0,0,0,255,192,0,0,0,0,0,2,255,0,0,0,0,0,0,7,252,0,0,0,0,0,0,15,240,0,0,0,0,0,0,63,192,0,0,0,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,191,64,0,0,31,224,191,64,191,64,0,0,31,224,255,0,191,64,0,0,31,226,254,0,191,64,0,0,31,255,252,0,191,64,0,0,31,255,240,0,191,64,0,0,31,254,64,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,128,0,0,31,224,0,0,127,128,0,0,47,208,0,0,63,192,0,0,63,208,0,0,63,224,0,0,127,192,0,0,31,248,0,1,255,128,0,0,15,255,64,27,255,0,0,0,3,255,255,255,252,0,0,0,0,191,255,255,240,0,0,0,0,11,255,254,64,0,0,0,0,0,21,64,0,0,0,0,
  // 0x1ee9  ứ
  233,30,25,30,210,27,3,255,0,0,15,248,0,0,0,0,0,63,240,0,0,0,0,0,127,192,0,0,0,0,0,255,0,0,0,0,0,3,248,0,0,0,0,0,11,224,0,0,106,128,0,0,0,0,0,127,192,0,0,0,0,0,191,128,85,0,0,5,80,255,0,255,0,0,15,241,255,0,255,0,0,15,247,252,0,255,0,0,15,255,244,0,255,0,0,15,255,128,0,255,0,0,15,244,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,47,240,0,0,255,64,0,63,240,0,0,191,192,0,191,240,0,0,127,224,7,255,240,0,0,63,255,255,239,240,0,0,15,255,255,143,240,0,0,2,255,253,11,240,0,0,0,5,64,0,0,0,0,
  // 0x1eea  Ừ
  234,30,29,37,40,31,3,255,0,31,244,0,0,0,0,0,0,11,252,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,47,192,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,191,64,0,0,31,224,191,64,191,64,0,0,31,224,255,0,191,64,0,0,31,226,254,0,191,64,0,0,31,255,252,0,191,64,0,0,31,255,240,0,191,64,0,0,31,254,64,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,128,0,0,31,224,0,0,127,128,0,0,47,208,0,0,63,192,0,0,63,208,0,0,63,224,0,0,127,192,0,0,31,248,0,1,255,128,0,0,15,255,64,27,255,0,0,0,3,255,255,255,252,0,0,0,0,191,255,255,240,0,0,0,0,11,255,254,64,0,0,0,0,0,21,64,0,0,0,0,
  // 0x1eeb  ừ
  235,30,25,30,210,27,3,255,1,255,64,0,0,0,0,0,191,192,0,0,0,0,0,47,224,0,0,0,0,0,11,244,0,0,0,0,0,2,252,0,0,0,0,0,0,126,0,0,106,128,0,0,0,0,0,127,192,0,0,0,0,0,191,128,85,0,0,5,80,255,0,255,0,0,15,241,255,0,255,0,0,15,247,252,0,255,0,0,15,255,244,0,255,0,0,15,255,128,0,255,0,0,15,244,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,47,240,0,0,255,64,0,63,240,0,0,191,192,0,191,240,0,0,127,224,7,255,240,0,0,63,255,255,239,240,0,0,15,255,255,143,240,0,0,2,255,253,11,240,0,0,0,5,64,0,0,0,0,
  // 0x1eec  Ử
  236,30,29,39,56,31,3,255,0,0,106,64,0,0,0,0,0,0,255,244,0,0,0,0,0,0,255,252,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,189,0,0,0,0,0,0,1,252,0,0,0,0,0,0,31,244,0,0,0,0,0,0,31,128,0,0,0,0,0,0,15,64,0,0,0,0,0,0,5,0,0,0,127,192,0,0,0,0,0,0,191,128,191,64,0,0,31,224,191,64,191,64,0,0,31,224,255,0,191,64,0,0,31,226,254,0,191,64,0,0,31,255,252,0,191,64,0,0,31,255,240,0,191,64,0,0,31,254,64,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,128,0,0,31,224,0,0,127,128,0,0,47,208,0,0,63,192,0,0,63,208,0,0,63,224,0,0,127,192,0,0,31,248,0,1,255,128,0,0,15,255,64,27,255,0,0,0,3,255,255,255,252,0,0,0,0,191,255,255,240,0,0,0,0,11,255,254,64,0,0,0,0,0,21,64,0,0,0,0,
  // 0x1eed  ử
  237,30,25,33,231,27,3,255,0,1,64,0,0,0,0,0,15,254,0,0,0,0,0,15,255,128,0,0,0,0,0,31,192,0,0,0,0,0,15,192,0,0,0,0,0,31,192,0,0,0,0,1,255,64,0,0,0,0,2,248,0,0,0,0,0,2,240,0,0,106,128,0,1,160,0,0,127,192,0,0,0,0,0,191,128,85,0,0,5,80,255,0,255,0,0,15,241,255,0,255,0,0,15,247,252,0,255,0,0,15,255,244,0,255,0,0,15,255,128,0,255,0,0,15,244,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,47,240,0,0,255,64,0,63,240,0,0,191,192,0,191,240,0,0,127,224,7,255,240,0,0,63,255,255,239,240,0,0,15,255,255,143,240,0,0,2,255,253,11,240,0,0,0,5,64,0,0,0,0,
  // 0x1eee  Ữ
  238,30,29,36,32,31,3,255,0,11,248,0,240,0,0,0,0,63,255,67,240,0,0,0,0,191,255,255,208,0,0,0,0,248,11,255,192,0,0,0,0,240,1,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,191,64,0,0,31,224,191,64,191,64,0,0,31,224,255,0,191,64,0,0,31,226,254,0,191,64,0,0,31,255,252,0,191,64,0,0,31,255,240,0,191,64,0,0,31,254,64,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,128,0,0,31,224,0,0,127,128,0,0,47,208,0,0,63,192,0,0,63,208,0,0,63,224,0,0,127,192,0,0,31,248,0,1,255,128,0,0,15,255,64,27,255,0,0,0,3,255,255,255,252,0,0,0,0,191,255,255,240,0,0,0,0,11,255,254,64,0,0,0,0,0,21,64,0,0,0,0,
  // 0x1eef  ữ
  239,30,25,29,203,27,3,255,0,191,64,31,0,0,0,3,255,244,63,0,0,0,11,255,255,253,0,0,0,15,129,255,248,0,0,0,15,0,27,224,0,106,128,0,0,0,0,0,127,192,0,0,0,0,0,191,128,85,0,0,5,80,255,0,255,0,0,15,241,255,0,255,0,0,15,247,252,0,255,0,0,15,255,244,0,255,0,0,15,255,128,0,255,0,0,15,244,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,47,240,0,0,255,64,0,63,240,0,0,191,192,0,191,240,0,0,127,224,7,255,240,0,0,63,255,255,239,240,0,0,15,255,255,143,240,0,0,2,255,253,11,240,0,0,0,5,64,0,0,0,0,
  // 0x1ef0  Ự
  240,30,29,37,40,31,3,248,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,191,64,0,0,31,224,191,64,191,64,0,0,31,224,255,0,191,64,0,0,31,226,254,0,191,64,0,0,31,255,252,0,191,64,0,0,31,255,240,0,191,64,0,0,31,254,64,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,64,0,0,31,224,0,0,191,128,0,0,31,224,0,0,127,128,0,0,47,208,0,0,63,192,0,0,63,208,0,0,63,224,0,0,127,192,0,0,31,248,0,1,255,128,0,0,15,255,64,27,255,0,0,0,3,255,255,255,252,0,0,0,0,191,255,255,240,0,0,0,0,11,255,254,64,0,0,0,0,0,21,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,31,128,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x1ef1  ự
  241,30,25,32,224,27,3,248,0,0,0,0,0,106,128,0,0,0,0,0,127,192,0,0,0,0,0,191,128,85,0,0,5,80,255,0,255,0,0,15,241,255,0,255,0,0,15,247,252,0,255,0,0,15,255,244,0,255,0,0,15,255,128,0,255,0,0,15,244,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,15,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,31,240,0,0,255,0,0,47,240,0,0,255,64,0,63,240,0,0,191,192,0,191,240,0,0,127,224,7,255,240,0,0,63,255,255,239,240,0,0,15,255,255,143,240,0,0,2,255,253,11,240,0,0,0,5,64,0,0,0,0,0,0,0,0,0,0,0,0,1,144,0,0,0,0,0,11,244,0,0,0,0,0,15,248,0,0,0,0,0,15,248,0,0,0,0,0,3,240,0,0,0,0,0,0,0,0,0,0,0,
  // 0x1ef2  Ỳ
  242,30,22,36,216,22,0,0,0,15,248,0,0,0,0,7,252,0,0,0,0,1,255,0,0,0,0,0,127,128,0,0,0,0,31,208,0,0,0,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,192,0,0,47,240,63,208,0,0,63,208,47,240,0,0,191,128,15,244,0,0,255,0,11,252,0,2,254,0,3,253,0,3,252,0,1,255,0,11,248,0,0,255,64,31,240,0,0,127,192,63,208,0,0,63,208,127,192,0,0,31,240,255,64,0,0,11,249,255,0,0,0,3,255,253,0,0,0,2,255,248,0,0,0,0,255,240,0,0,0,0,191,224,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x1ef3  ỳ
  243,30,20,39,195,20,0,246,0,127,224,0,0,0,31,240,0,0,0,7,252,0,0,0,1,254,0,0,0,0,127,64,0,0,0,31,192,0,0,0,0,0,0,0,0,0,0,0,85,0,0,0,85,191,128,0,2,254,63,192,0,3,253,63,208,0,7,252,31,240,0,11,248,15,240,0,15,240,11,248,0,31,240,3,252,0,47,208,3,253,0,63,192,1,254,0,127,128,0,255,0,255,64,0,191,64,255,0,0,63,129,254,0,0,63,195,252,0,0,31,211,252,0,0,15,231,244,0,0,11,251,240,0,0,3,255,224,0,0,3,255,192,0,0,1,255,192,0,0,0,255,64,0,0,0,255,0,0,0,1,254,0,0,0,2,253,0,0,0,3,252,0,0,0,15,244,0,0,16,127,240,0,0,127,255,192,0,0,127,255,64,0,0,127,248,0,0,0,0,0,0,0,0,
  // 0x1ef4  Ỵ
  244,30,22,35,210,22,0,248,191,192,0,0,47,240,63,208,0,0,63,208,47,240,0,0,191,128,15,244,0,0,255,0,11,252,0,2,254,0,3,253,0,3,252,0,1,255,0,11,248,0,0,255,64,31,240,0,0,127,192,63,208,0,0,63,208,127,192,0,0,31,240,255,64,0,0,11,249,255,0,0,0,3,255,253,0,0,0,2,255,248,0,0,0,0,255,240,0,0,0,0,191,224,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,47,128,0,0,0,0,0,0,0,0,
  // 0x1ef5  ỵ
  245,30,20,31,155,20,0,246,85,0,0,0,85,191,128,0,2,254,63,192,0,3,253,63,208,0,7,252,31,240,0,11,248,15,240,0,15,240,11,248,0,31,240,3,252,0,47,208,3,253,0,63,192,1,254,0,127,128,0,255,0,255,64,0,191,64,255,0,0,63,129,254,0,0,63,195,252,0,0,31,211,252,0,0,15,231,244,0,0,11,251,240,0,0,3,255,224,0,0,3,255,192,0,0,1,255,192,0,0,0,255,64,0,0,0,255,0,0,0,1,254,0,0,0,2,253,6,64,0,3,252,47,208,0,15,244,63,224,16,127,240,63,224,127,255,192,15,192,127,255,64,0,0,127,248,0,0,0,0,0,0,0,0,
  // 0x1ef6  Ỷ
  246,30,22,38,228,22,0,0,0,0,106,64,0,0,0,0,255,244,0,0,0,0,255,252,0,0,0,0,0,253,0,0,0,0,0,253,0,0,0,0,2,252,0,0,0,0,31,244,0,0,0,0,31,128,0,0,0,0,31,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,191,192,0,0,47,240,63,208,0,0,63,208,47,240,0,0,191,128,15,244,0,0,255,0,11,252,0,2,254,0,3,253,0,3,252,0,1,255,0,11,248,0,0,255,64,31,240,0,0,127,192,63,208,0,0,63,208,127,192,0,0,31,240,255,64,0,0,11,249,255,0,0,0,3,255,253,0,0,0,2,255,248,0,0,0,0,255,240,0,0,0,0,191,224,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x1ef7  ỷ
  247,30,20,42,210,20,0,246,0,0,80,0,0,0,3,255,128,0,0,3,255,240,0,0,0,7,240,0,0,0,3,240,0,0,0,7,240,0,0,0,127,208,0,0,0,190,0,0,0,0,124,0,0,0,0,40,0,0,0,0,0,0,0,85,0,0,0,85,191,128,0,2,254,63,192,0,3,253,63,208,0,7,252,31,240,0,11,248,15,240,0,15,240,11,248,0,31,240,3,252,0,47,208,3,253,0,63,192,1,254,0,127,128,0,255,0,255,64,0,191,64,255,0,0,63,129,254,0,0,63,195,252,0,0,31,211,252,0,0,15,231,244,0,0,11,251,240,0,0,3,255,224,0,0,3,255,192,0,0,1,255,192,0,0,0,255,64,0,0,0,255,0,0,0,1,254,0,0,0,2,253,0,0,0,3,252,0,0,0,15,244,0,0,16,127,240,0,0,127,255,192,0,0,127,255,64,0,0,127,248,0,0,0,0,0,0,0,0,
  // 0x1ef8  Ỹ
  248,30,22,35,210,22,0,0,0,11,248,0,240,0,0,63,255,67,240,0,0,191,255,255,224,0,0,248,11,255,192,0,0,240,1,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,192,0,0,47,240,63,208,0,0,63,208,47,240,0,0,191,128,15,244,0,0,255,0,11,252,0,2,254,0,3,253,0,3,252,0,1,255,0,11,248,0,0,255,64,31,240,0,0,127,192,63,208,0,0,63,208,127,192,0,0,31,240,255,64,0,0,11,249,255,0,0,0,3,255,253,0,0,0,2,255,248,0,0,0,0,255,240,0,0,0,0,191,224,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x1ef9  ỹ
  249,30,20,38,190,20,0,246,0,47,224,3,192,0,255,253,15,192,2,255,255,255,64,3,224,63,255,0,3,192,6,248,0,0,0,0,0,0,0,0,0,0,0,85,0,0,0,85,191,128,0,2,254,63,192,0,3,253,63,208,0,7,252,31,240,0,11,248,15,240,0,15,240,11,248,0,31,240,3,252,0,47,208,3,253,0,63,192,1,254,0,127,128,0,255,0,255,64,0,191,64,255,0,0,63,129,254,0,0,63,195,252,0,0,31,211,252,0,0,15,231,244,0,0,11,251,240,0,0,3,255,224,0,0,3,255,192,0,0,1,255,192,0,0,0,255,64,0,0,0,255,0,0,0,1,254,0,0,0,2,253,0,0,0,3,252,0,0,0,15,244,0,0,16,127,240,0,0,127,255,192,0,0,127,255,64,0,0,127,248,0,0,0,0,0,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
