/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Simplified Chinese 38pt, capital 'A' height: 28px, width: 100%, range: 0x201c-0xff1a, glyphs: 373
extern const uint8_t NotoSans_Medium_Simplified_Chinese_28[27451] = {
  162,28,28,32,26,255,37,246, // unifont_t
  // 0x201c  “
  28,32,14,10,40,15,0,17,2,248,3,240,3,244,11,240,7,240,15,224,15,240,31,208,15,224,47,192,47,208,63,192,63,192,127,128,63,192,191,128,127,192,255,64,0,0,0,0,
  // 0x201d  ”
  29,32,14,10,40,15,0,17,15,248,31,240,15,244,31,240,15,240,47,208,31,224,63,192,47,208,63,192,47,192,63,64,63,128,127,0,63,0,190,0,126,0,252,0,0,0,0,0,
  // 0x22bf  ⊿
  191,34,29,31,248,38,4,255,0,0,0,0,0,0,0,128,0,0,0,0,0,0,2,192,0,0,0,0,0,0,11,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,191,192,0,0,0,0,0,2,255,192,0,0,0,0,0,11,255,192,0,0,0,0,0,47,255,192,0,0,0,0,0,191,223,192,0,0,0,0,2,255,31,192,0,0,0,0,11,252,31,192,0,0,0,0,31,240,31,192,0,0,0,0,127,192,31,192,0,0,0,1,255,0,31,192,0,0,0,7,252,0,31,192,0,0,0,31,240,0,31,192,0,0,0,127,192,0,31,192,0,0,1,255,0,0,31,192,0,0,7,252,0,0,31,192,0,0,31,240,0,0,31,192,0,0,127,192,0,0,31,192,0,1,255,0,0,0,31,192,0,7,252,0,0,0,31,192,0,31,240,0,0,0,31,192,0,127,192,0,0,0,31,192,1,255,0,0,0,0,31,192,7,252,0,0,0,0,31,192,15,255,255,255,255,255,255,192,63,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0x4e00  一
  0,78,35,4,36,38,2,12,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,244,255,255,255,255,255,255,255,255,244,
  // 0x4e09  三
  9,78,34,29,5,38,2,255,3,255,255,255,255,255,255,253,0,3,255,255,255,255,255,255,253,0,3,255,255,255,255,255,255,253,0,2,170,170,170,170,170,170,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,170,170,170,170,170,0,0,0,47,255,255,255,255,255,64,0,0,47,255,255,255,255,255,64,0,0,47,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,170,170,170,170,170,170,170,128,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,
  // 0x4e0a  上
  10,78,34,34,50,38,2,254,0,0,0,5,64,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,250,170,170,168,0,0,0,0,15,255,255,255,253,0,0,0,0,15,255,255,255,253,0,0,0,0,15,255,255,255,253,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,170,170,170,175,250,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x4e0b  下
  11,78,34,33,41,38,2,252,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,106,170,170,175,250,170,170,170,144,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,255,128,0,0,0,0,0,0,11,255,248,0,0,0,0,0,0,11,255,255,64,0,0,0,0,0,11,251,255,244,0,0,0,0,0,11,240,191,254,0,0,0,0,0,11,240,31,255,208,0,0,0,0,11,240,2,255,248,0,0,0,0,11,240,0,63,254,0,0,0,0,11,240,0,11,252,0,0,0,0,11,240,0,1,244,0,0,0,0,11,240,0,0,16,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,
  // 0x4e0d  不
  13,78,34,33,41,38,2,252,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,42,170,170,170,255,234,170,170,128,0,0,0,0,255,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,191,252,0,0,0,0,0,0,1,255,252,124,0,0,0,0,0,7,255,254,255,64,0,0,0,0,31,255,252,255,240,0,0,0,0,127,243,252,47,253,0,0,0,2,255,195,252,7,255,64,0,0,11,255,3,252,1,255,224,0,0,63,252,3,252,0,63,252,0,2,255,240,3,252,0,11,255,0,31,255,128,3,252,0,2,255,192,191,253,0,3,252,0,0,191,240,191,240,0,3,252,0,0,31,224,63,128,0,3,252,0,0,7,128,8,0,0,3,252,0,0,1,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,
  // 0x4e13  专
  19,78,34,37,77,38,2,251,0,0,0,31,128,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,128,0,0,0,0,2,255,255,255,255,255,255,248,0,2,255,255,255,255,255,255,248,0,2,255,255,255,255,255,255,248,0,1,85,86,254,85,85,85,80,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,85,85,91,249,85,85,85,85,64,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,255,208,0,0,47,192,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,255,255,255,255,208,0,0,1,255,255,255,255,255,248,0,0,2,255,255,255,255,255,240,0,0,1,85,85,85,85,255,192,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,63,240,0,0,0,0,41,0,0,255,192,0,0,0,0,127,228,3,255,0,0,0,0,0,255,255,159,252,0,0,0,0,0,31,255,255,240,0,0,0,0,0,0,127,255,244,0,0,0,0,0,0,2,255,255,64,0,0,0,0,0,0,31,255,244,0,0,0,0,0,0,0,191,252,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,0,144,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4e1d  丝
  29,78,34,34,50,38,2,254,0,0,16,0,0,0,80,0,0,0,0,190,0,0,0,254,0,0,0,0,255,0,0,1,253,0,0,0,1,253,0,0,2,252,0,0,0,3,252,0,0,3,244,0,0,0,7,244,0,0,11,240,0,0,0,11,240,0,0,15,208,0,0,0,15,208,8,0,47,192,9,0,0,47,192,31,64,127,64,47,128,0,63,64,63,192,254,0,63,192,0,191,0,191,129,252,0,255,64,1,253,0,255,3,244,1,254,0,3,248,2,253,15,240,3,252,0,11,240,3,248,63,255,255,240,0,47,255,255,240,63,255,255,224,0,47,255,255,208,47,255,255,192,0,15,255,255,128,25,64,255,0,0,9,64,255,0,0,2,253,0,0,0,2,252,0,0,7,248,0,0,0,11,244,0,0,15,240,0,0,0,31,208,0,0,63,192,0,0,0,127,128,0,0,255,0,0,0,1,254,0,0,3,252,0,0,0,7,254,191,255,31,255,255,255,192,31,255,255,255,63,255,255,255,192,15,255,255,255,31,255,255,255,128,11,254,149,64,15,234,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,64,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x4e2a  个
  42,78,36,35,59,38,1,252,0,0,0,2,255,0,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,15,255,208,0,0,0,0,0,0,47,255,244,0,0,0,0,0,0,191,219,252,0,0,0,0,0,1,255,130,255,0,0,0,0,0,7,254,0,255,192,0,0,0,0,31,252,0,63,244,0,0,0,0,127,240,0,15,253,0,0,0,2,255,192,0,3,255,128,0,0,11,255,0,0,0,255,240,0,0,63,248,0,0,0,47,253,0,1,255,224,0,85,0,7,255,128,11,255,64,0,254,0,1,255,248,127,252,0,0,254,0,0,63,255,191,224,0,0,254,0,0,7,254,63,64,0,0,254,0,0,0,252,8,0,0,0,254,0,0,0,16,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,
  // 0x4e2d  中
  45,78,32,36,32,38,3,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,149,85,95,245,85,86,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,1,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,149,85,95,245,85,86,253,127,0,0,15,224,0,1,253,127,0,0,15,224,0,0,168,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,
  // 0x4e3a  为
  58,78,32,36,32,38,2,252,0,0,0,42,128,0,0,0,0,8,0,63,192,0,0,0,0,191,0,63,192,0,0,0,0,127,128,63,192,0,0,0,0,63,208,63,192,0,0,0,0,15,240,63,192,0,0,0,0,7,248,63,192,0,0,0,0,3,224,63,128,0,0,0,0,0,0,63,128,0,0,0,26,170,170,191,234,170,170,170,63,255,255,255,255,255,255,255,63,255,255,255,255,255,255,255,63,255,255,255,255,255,255,255,0,0,0,127,64,0,0,191,0,0,0,191,0,0,0,191,0,0,0,255,0,0,0,191,0,0,0,254,0,0,0,191,0,0,1,253,2,0,0,191,0,0,2,252,47,128,0,255,0,0,3,252,63,208,0,255,0,0,7,248,15,240,0,255,0,0,15,240,7,252,0,255,0,0,31,240,2,253,0,254,0,0,63,208,0,255,0,254,0,0,191,192,0,127,64,254,0,0,255,64,0,56,1,253,0,3,254,0,0,0,1,253,0,15,252,0,0,0,1,253,0,47,244,0,0,0,2,252,0,191,208,0,0,0,3,252,3,255,128,0,0,0,3,252,31,254,0,0,0,0,11,248,127,248,0,0,2,255,255,244,63,208,0,0,0,255,255,240,15,0,0,0,0,255,255,192,0,0,0,0,0,106,164,0,
  // 0x4e3b  主
  59,78,34,35,59,38,2,253,0,0,0,9,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,191,224,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,0,63,208,0,0,0,5,85,85,85,111,149,85,85,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,85,85,87,253,85,85,80,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,85,85,85,85,85,80,
  // 0x4e49  义
  73,78,34,36,68,38,2,252,0,0,0,6,128,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,11,240,0,1,224,0,0,0,0,3,244,0,3,252,0,0,188,0,2,252,0,3,252,0,1,253,0,1,253,0,11,244,0,0,255,0,0,254,0,15,240,0,0,127,64,0,191,0,31,224,0,0,63,128,0,61,0,63,208,0,0,47,208,0,0,0,127,192,0,0,15,240,0,0,0,255,64,0,0,11,244,0,0,1,255,0,0,0,3,252,0,0,3,253,0,0,0,2,254,0,0,7,252,0,0,0,0,255,64,0,15,240,0,0,0,0,127,192,0,63,224,0,0,0,0,47,224,0,127,192,0,0,0,0,15,248,1,255,0,0,0,0,0,7,253,3,254,0,0,0,0,0,2,255,79,248,0,0,0,0,0,0,191,255,240,0,0,0,0,0,0,63,255,192,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,31,255,128,0,0,0,0,0,0,191,255,240,0,0,0,0,0,3,255,255,253,0,0,0,0,0,47,254,11,255,128,0,0,0,1,255,244,1,255,248,0,0,0,31,255,128,0,63,255,128,0,2,255,253,0,0,11,255,249,0,127,255,224,0,0,0,191,255,224,255,254,0,0,0,0,11,255,240,191,208,0,0,0,0,0,191,192,56,0,0,0,0,0,0,6,64,0,0,0,0,0,0,0,0,0,
  // 0x4e4b  之
  75,78,35,36,68,38,1,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,1,85,85,85,255,85,85,89,0,3,255,255,255,255,255,255,255,128,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,128,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,11,253,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,127,224,0,0,0,1,0,0,1,255,128,0,0,0,3,224,0,7,254,0,0,0,0,11,244,0,47,248,0,0,0,0,15,240,0,191,224,0,0,0,0,31,224,2,255,128,0,0,0,0,63,240,15,253,0,0,0,0,0,127,252,127,244,0,0,0,0,0,255,255,255,192,0,0,0,0,2,254,255,254,0,0,0,0,0,3,252,63,252,0,0,0,0,0,11,248,15,255,144,0,0,0,0,31,240,3,255,255,250,165,85,88,63,208,0,127,255,255,255,255,252,191,192,0,6,255,255,255,255,248,31,64,0,0,6,191,255,255,244,1,0,0,0,0,0,0,0,0,
  // 0x4e86  了
  134,78,30,33,8,38,4,252,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,208,255,255,255,255,255,255,255,208,170,170,170,170,170,171,255,64,0,0,0,0,0,11,254,0,0,0,0,0,0,63,248,0,0,0,0,0,0,255,224,0,0,0,0,0,3,255,128,0,0,0,0,0,31,253,0,0,0,0,0,0,191,244,0,0,0,0,0,43,255,192,0,0,0,0,0,63,254,0,0,0,0,0,0,63,244,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,26,170,191,192,0,0,0,0,15,255,255,128,0,0,0,0,11,255,255,0,0,0,0,0,7,255,228,0,0,0,0,
  // 0x4e8c  二
  140,78,34,28,252,38,2,255,1,255,255,255,255,255,255,244,0,2,255,255,255,255,255,255,248,0,2,255,255,255,255,255,255,248,0,2,255,255,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x4e8e  于
  142,78,34,33,41,38,2,252,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,1,85,85,86,254,85,85,84,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,85,85,85,86,254,85,85,85,80,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,255,255,252,0,0,0,0,0,0,191,255,252,0,0,0,0,0,0,127,255,240,0,0,0,0,0,0,42,169,0,0,0,0,0,
  // 0x4ea4  交
  164,78,34,37,77,38,2,251,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,85,85,85,85,85,85,85,85,80,0,0,20,0,0,2,128,0,0,0,0,63,128,0,15,240,0,0,0,0,255,192,0,47,253,0,0,0,3,255,0,0,7,255,128,0,0,15,252,0,0,0,255,240,0,0,127,240,0,0,0,47,252,0,2,255,192,0,0,0,11,255,0,31,255,6,64,0,30,65,255,192,191,248,63,192,0,47,224,127,224,63,224,47,208,0,63,192,31,128,15,0,15,240,0,191,128,9,0,0,0,11,244,0,255,0,0,0,0,0,3,252,3,254,0,0,0,0,0,2,255,11,252,0,0,0,0,0,0,255,175,240,0,0,0,0,0,0,63,255,208,0,0,0,0,0,0,31,255,128,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,127,255,208,0,0,0,0,0,2,255,255,248,0,0,0,0,0,47,255,95,255,128,0,0,0,7,255,252,3,255,249,0,0,1,191,255,208,0,191,255,228,0,191,255,253,0,0,11,255,255,240,255,255,208,0,0,0,191,255,240,63,248,0,0,0,0,6,255,192,46,0,0,0,0,0,0,6,64,0,0,0,0,0,0,0,0,0,
  // 0x4eae  亮
  174,78,34,37,77,38,2,251,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,85,85,85,85,85,64,0,0,47,255,255,255,255,255,128,0,0,47,255,255,255,255,255,128,0,0,47,192,0,0,0,63,128,0,0,47,192,0,0,0,63,128,0,0,47,192,0,0,0,63,128,0,0,47,255,255,255,255,255,128,0,0,47,255,255,255,255,255,128,0,0,5,85,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,0,0,0,0,0,0,15,208,127,0,0,0,0,0,0,15,208,127,0,15,224,3,252,0,15,208,127,0,15,224,3,252,0,15,208,127,0,31,208,3,252,0,15,208,0,0,47,192,3,252,0,0,0,0,0,63,192,3,252,0,0,0,0,0,127,128,3,252,0,0,0,0,0,255,64,3,252,0,7,128,0,3,254,0,3,252,0,7,240,0,47,252,0,3,252,0,11,240,6,255,240,0,2,253,0,15,224,255,255,128,0,2,255,255,255,208,191,249,0,0,0,255,255,255,192,62,64,0,0,0,47,255,254,0,0,0,0,0,0,0,0,0,0,
  // 0x4ece  从
  206,78,34,34,50,38,2,252,0,1,253,0,0,47,192,0,0,0,2,253,0,0,47,192,0,0,0,2,253,0,0,47,192,0,0,0,2,253,0,0,47,192,0,0,0,2,252,0,0,63,192,0,0,0,2,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,192,0,0,0,3,252,0,0,63,208,0,0,0,3,248,0,0,127,208,0,0,0,7,248,0,0,127,224,0,0,0,7,244,0,0,191,240,0,0,0,11,244,0,0,255,240,0,0,0,11,252,0,0,255,240,0,0,0,15,255,0,0,255,244,0,0,0,15,255,192,1,255,252,0,0,0,31,255,224,2,255,252,0,0,0,31,255,244,3,253,253,0,0,0,47,203,252,7,248,254,0,0,0,63,195,255,11,244,255,0,0,0,127,128,255,79,240,191,64,0,0,191,64,191,111,224,63,192,0,0,255,0,62,63,192,47,208,0,1,255,0,28,191,192,31,240,0,3,253,0,1,255,64,15,248,0,7,252,0,3,255,0,7,253,0,15,248,0,11,252,0,3,255,0,47,240,0,47,248,0,0,255,192,127,224,0,191,240,0,0,191,240,255,192,2,255,192,0,0,63,240,255,64,0,191,0,0,0,15,208,46,0,0,44,0,0,0,3,128,4,0,0,0,0,0,0,0,0,
  // 0x4ee4  令
  228,78,36,36,68,38,1,252,0,0,0,1,254,0,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,11,255,208,0,0,0,0,0,0,47,255,240,0,0,0,0,0,0,127,219,252,0,0,0,0,0,1,255,131,255,0,0,0,0,0,7,254,0,255,192,0,0,0,0,31,252,0,63,244,0,0,0,0,127,240,0,15,253,0,0,0,2,255,192,0,3,255,128,0,0,11,255,0,0,0,255,240,0,0,63,253,0,0,0,127,253,0,1,255,223,255,255,255,247,255,208,15,255,79,255,255,255,240,255,248,127,252,15,255,255,255,240,47,253,63,208,0,0,0,0,0,7,248,15,0,0,0,0,0,0,0,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,0,0,47,208,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,0,2,252,0,0,0,0,31,192,15,255,252,0,0,0,0,31,192,11,255,248,0,0,0,0,31,192,7,255,224,0,0,0,0,31,192,1,84,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,
  // 0x4ee5  以
  229,78,36,33,41,38,1,252,0,63,64,0,0,0,0,249,0,0,63,128,0,0,0,1,254,0,0,63,128,0,0,0,1,253,0,0,63,128,11,128,0,2,253,0,0,63,128,63,208,0,2,252,0,0,63,128,31,240,0,3,252,0,0,63,128,11,252,0,3,252,0,0,63,128,3,254,0,3,248,0,0,63,128,0,255,0,7,248,0,0,63,192,0,191,192,11,244,0,0,63,192,0,63,208,15,240,0,0,63,192,0,31,224,15,240,0,0,63,192,0,15,64,31,224,0,0,63,192,0,0,0,47,208,0,0,47,192,0,0,0,63,192,0,0,47,192,0,0,0,127,128,0,0,47,192,0,0,0,255,64,0,0,47,192,0,0,0,255,0,0,0,47,192,0,0,2,254,0,0,0,47,192,31,0,7,252,0,0,0,47,193,255,0,15,254,0,0,0,47,239,255,64,47,255,128,0,0,31,255,254,0,127,255,208,0,0,191,255,224,1,255,175,244,0,31,255,253,0,7,255,15,253,0,127,255,144,0,31,252,3,255,0,63,248,0,0,191,244,0,255,192,63,64,0,7,255,192,0,127,240,20,0,0,127,255,0,0,31,248,0,0,7,255,248,0,0,11,253,0,0,11,255,208,0,0,3,253,0,0,2,254,0,0,0,0,240,0,0,0,160,0,0,0,0,64,
  // 0x4ef6  件
  246,78,35,36,68,38,1,252,0,0,32,0,0,5,64,0,0,0,0,191,0,0,31,192,0,0,0,0,254,2,144,31,192,0,0,0,1,253,3,244,31,192,0,0,0,3,252,7,240,31,192,0,0,0,7,248,11,240,31,192,0,0,0,15,240,15,224,31,192,0,0,0,31,224,15,208,31,192,0,0,0,63,192,31,255,255,255,255,224,0,127,128,47,255,255,255,255,224,0,255,64,63,255,255,255,255,224,3,255,64,127,149,111,229,85,64,7,255,64,255,0,31,192,0,0,31,255,65,253,0,31,192,0,0,63,255,67,252,0,31,192,0,0,191,255,66,244,0,31,192,0,0,63,63,64,32,0,31,192,0,0,44,63,64,0,0,31,192,0,0,4,63,64,0,0,31,192,0,0,0,63,67,255,255,255,255,255,252,0,63,67,255,255,255,255,255,252,0,63,67,255,255,255,255,255,252,0,63,65,85,85,111,229,85,84,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,63,64,0,0,31,192,0,0,0,47,64,0,0,31,192,0,0,
  // 0x4efd  份
  253,78,36,36,68,38,1,252,0,0,100,0,0,0,0,0,0,0,0,255,0,15,255,255,128,0,0,1,253,0,15,255,255,192,0,0,2,252,0,15,255,255,208,0,0,3,248,1,64,0,15,224,0,0,11,240,3,248,0,15,240,0,0,15,224,3,244,0,7,240,0,0,47,192,11,240,0,3,248,0,0,63,128,15,224,0,3,252,0,0,255,64,47,192,0,1,254,0,1,255,64,63,128,0,0,255,0,3,255,64,191,0,0,0,127,192,15,255,64,254,0,0,0,63,224,47,255,67,252,0,0,0,31,248,127,255,75,244,0,0,0,11,254,255,191,95,240,0,0,0,7,253,190,63,111,239,255,255,255,253,248,60,63,71,95,255,255,255,252,32,32,63,64,31,255,255,255,252,0,0,63,64,0,11,224,1,252,0,0,63,64,0,15,224,1,252,0,0,63,64,0,15,208,1,252,0,0,63,64,0,15,208,1,252,0,0,63,64,0,31,192,2,252,0,0,63,64,0,47,192,2,252,0,0,63,64,0,63,64,2,252,0,0,63,64,0,127,0,2,252,0,0,63,64,0,255,0,3,252,0,0,63,64,1,253,0,3,248,0,0,63,64,3,252,0,3,248,0,0,63,64,15,244,0,3,248,0,0,63,64,63,224,0,11,244,0,0,63,66,255,128,15,255,240,0,0,63,67,254,0,11,255,240,0,0,63,64,244,0,7,255,192,0,0,42,0,64,0,1,84,0,0,
  // 0x4f11  休
  17,79,36,36,68,38,1,252,0,0,4,0,0,0,0,0,0,0,0,47,128,0,63,128,0,0,0,0,63,192,0,63,128,0,0,0,0,191,64,0,63,128,0,0,0,0,255,0,0,63,128,0,0,0,1,254,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,11,248,0,0,63,128,0,0,0,15,240,0,0,63,128,0,0,0,63,224,0,0,63,128,0,0,0,191,211,255,255,255,255,255,252,1,255,211,255,255,255,255,255,252,3,255,211,255,255,255,255,255,252,15,255,209,85,87,255,253,85,84,63,255,208,0,3,255,252,0,0,255,239,208,0,7,255,253,0,0,191,143,208,0,15,255,255,0,0,63,15,208,0,31,255,255,0,0,44,15,208,0,63,255,175,192,0,0,15,208,0,127,127,159,208,0,0,15,208,0,255,63,143,240,0,0,15,208,2,253,63,135,248,0,0,15,208,7,252,63,130,252,0,0,15,208,15,240,63,128,255,0,0,15,208,47,224,63,128,191,128,0,15,208,191,192,63,128,63,208,0,15,209,255,0,63,128,31,244,0,15,219,253,0,63,128,11,253,0,15,239,248,0,63,128,3,255,0,15,219,240,0,63,128,0,252,0,15,210,192,0,63,128,0,48,0,15,208,0,0,63,128,0,0,0,15,208,0,0,63,128,0,0,0,15,208,0,0,63,128,0,0,0,15,208,0,0,63,128,0,0,0,15,192,0,0,63,128,0,0,
  // 0x4f20  传
  32,79,35,36,68,38,1,252,0,0,16,0,0,80,0,0,0,0,0,190,0,0,255,0,0,0,0,0,254,0,0,254,0,0,0,0,1,253,0,1,253,0,0,0,0,3,252,0,2,253,0,0,0,0,7,244,191,255,255,255,255,208,0,15,240,191,255,255,255,255,208,0,31,208,191,255,255,255,255,208,0,63,192,0,11,240,0,0,0,0,191,64,0,15,224,0,0,0,1,255,64,0,15,208,0,0,0,3,255,65,85,111,213,85,85,84,15,255,79,255,255,255,255,255,252,47,255,79,255,255,255,255,255,252,191,255,79,255,255,255,255,255,252,255,191,64,0,191,0,0,0,0,126,63,64,0,255,0,0,0,0,60,63,64,0,253,0,0,0,0,16,63,64,1,252,0,0,0,0,0,63,64,3,255,255,255,255,64,0,63,64,3,255,255,255,255,208,0,63,64,7,255,255,255,255,128,0,63,64,1,85,85,87,254,0,0,63,64,0,0,0,11,252,0,0,63,64,0,0,0,47,240,0,0,63,64,0,0,0,127,192,0,0,63,64,0,15,65,255,0,0,0,63,64,0,63,231,253,0,0,0,63,64,0,47,255,244,0,0,0,63,64,0,7,255,224,0,0,0,63,64,0,0,191,240,0,0,0,63,64,0,0,31,253,0,0,0,63,64,0,0,7,255,64,0,0,63,64,0,0,0,255,192,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,8,0,0,
  // 0x4f4d  位
  77,79,36,36,68,38,1,252,0,0,36,0,0,21,64,0,0,0,0,127,64,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,2,252,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,11,244,0,0,63,128,0,0,0,31,224,85,85,127,213,85,80,0,63,192,255,255,255,255,255,248,0,191,192,255,255,255,255,255,248,1,255,192,255,255,255,255,255,248,3,255,192,0,0,0,0,0,0,11,255,192,0,0,0,0,0,0,47,255,192,1,96,0,0,249,0,191,255,192,3,240,0,1,254,0,255,175,192,3,244,0,1,253,0,127,47,192,2,248,0,2,252,0,60,47,192,1,252,0,3,252,0,16,47,192,1,252,0,3,248,0,0,47,192,0,253,0,7,244,0,0,47,192,0,254,0,11,240,0,0,47,192,0,190,0,15,240,0,0,47,192,0,191,0,15,224,0,0,47,192,0,127,0,15,208,0,0,47,192,0,127,0,47,192,0,0,47,192,0,63,64,63,192,0,0,47,192,0,63,128,63,64,0,0,47,192,0,63,128,127,0,0,0,47,192,0,63,128,191,0,0,0,47,192,0,16,0,254,0,0,0,47,193,85,85,85,253,85,84,0,47,195,255,255,255,255,255,254,0,47,195,255,255,255,255,255,254,0,47,195,255,255,255,255,255,254,0,47,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,
  // 0x4f4e  低
  78,79,36,36,68,38,1,252,0,0,80,0,0,0,0,0,0,0,0,254,0,0,0,0,4,0,0,0,254,0,0,0,6,255,0,0,2,252,0,0,22,255,255,192,0,3,252,53,111,255,255,255,128,0,7,244,63,255,255,255,144,0,0,15,240,63,255,255,248,0,0,0,47,208,63,229,3,248,0,0,0,63,192,63,64,3,248,0,0,0,191,64,63,64,3,252,0,0,1,255,64,63,64,2,252,0,0,3,255,64,63,64,2,252,0,0,11,255,64,63,64,2,252,0,0,31,255,64,63,64,2,252,0,0,127,255,64,63,255,255,255,255,253,255,255,64,63,255,255,255,255,253,255,63,64,63,255,255,255,255,253,60,63,64,63,64,0,253,0,0,36,63,64,63,64,0,254,0,0,0,63,64,63,64,0,254,0,0,0,63,64,63,64,0,191,0,0,0,63,64,63,64,0,191,0,0,0,63,64,63,64,0,127,0,0,0,63,64,63,64,0,63,64,0,0,63,64,63,64,5,63,128,0,0,63,64,63,155,255,111,192,0,0,63,65,191,255,255,95,208,32,0,63,71,255,255,255,79,224,46,0,63,67,255,250,64,11,240,63,0,63,67,229,0,0,7,248,63,0,63,64,0,0,0,3,253,127,0,63,64,0,0,0,1,255,254,0,63,65,255,255,255,252,191,252,0,63,65,255,255,255,252,47,248,0,63,65,255,255,255,252,6,144,0,63,64,0,0,0,0,0,0,
  // 0x4f53  体
  83,79,36,36,68,38,1,252,0,0,144,0,0,42,0,0,0,0,1,253,0,0,63,64,0,0,0,2,252,0,0,63,64,0,0,0,3,248,0,0,63,64,0,0,0,7,244,0,0,63,64,0,0,0,15,240,0,0,63,64,0,0,0,31,208,0,0,63,64,0,0,0,63,193,85,85,127,149,85,84,0,127,135,255,255,255,255,255,252,0,255,71,255,255,255,255,255,252,1,255,71,255,255,255,255,255,252,3,255,64,0,7,255,244,0,0,11,255,64,0,11,255,252,0,0,31,255,64,0,15,255,252,0,0,127,255,64,0,31,255,190,0,0,191,255,64,0,63,127,127,0,0,63,63,64,0,127,63,111,128,0,44,63,64,0,253,63,95,192,0,4,63,64,1,252,63,79,224,0,0,63,64,3,244,63,71,240,0,0,63,64,11,240,63,67,248,0,0,63,64,31,208,63,65,253,0,0,63,64,63,192,63,64,255,0,0,63,64,191,64,63,64,127,192,0,63,65,254,0,63,64,47,224,0,63,71,253,0,127,64,31,244,0,63,95,247,255,255,255,247,254,0,63,111,227,255,255,255,242,253,0,63,75,131,255,255,255,240,244,0,63,66,0,0,63,64,0,16,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,0,0,0,42,0,0,0,
  // 0x4f59  余
  89,79,36,37,77,38,1,251,0,0,0,1,254,0,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,15,255,208,0,0,0,0,0,0,47,255,244,0,0,0,0,0,0,191,199,253,0,0,0,0,0,2,255,1,255,128,0,0,0,0,15,253,0,127,224,0,0,0,0,63,244,0,31,252,0,0,0,1,255,192,0,7,255,64,0,0,11,255,0,0,0,255,224,0,0,63,248,0,0,0,47,253,0,2,255,224,0,0,0,11,255,208,47,255,255,255,255,255,255,255,253,127,248,255,255,255,255,254,47,252,31,208,255,255,255,255,254,7,244,9,0,0,0,254,0,0,0,96,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,1,85,85,85,255,85,85,85,64,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,180,0,254,0,60,0,0,0,1,254,0,254,1,255,64,0,0,7,252,0,254,0,191,224,0,0,31,240,0,254,0,31,248,0,0,191,208,0,254,0,7,254,0,2,255,64,0,254,0,1,255,192,31,253,0,0,254,0,0,127,240,63,240,1,85,254,0,0,31,244,15,192,3,255,254,0,0,7,208,1,0,3,255,252,0,0,1,0,0,0,1,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4f5c  作
  92,79,36,36,68,38,1,252,0,0,20,0,0,0,0,0,0,0,0,63,64,11,224,0,0,0,0,0,191,64,15,240,0,0,0,0,0,255,0,31,208,0,0,0,0,1,253,0,47,192,0,0,0,0,3,252,0,63,128,0,0,0,0,7,248,0,191,149,85,85,84,0,15,240,0,255,255,255,255,253,0,31,224,2,255,255,255,255,253,0,63,192,3,255,255,255,255,253,0,255,192,15,240,127,64,0,0,1,255,192,31,224,127,64,0,0,3,255,192,63,192,127,64,0,0,15,255,192,255,64,127,64,0,0,63,255,194,255,0,127,64,0,0,127,255,195,252,0,127,255,255,248,63,111,192,244,0,127,255,255,248,30,47,192,16,0,127,255,255,248,8,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,85,85,84,0,47,192,0,0,127,255,255,252,0,47,192,0,0,127,255,255,252,0,47,192,0,0,127,255,255,252,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,47,192,0,0,127,64,0,0,0,31,192,0,0,127,0,0,0,
  // 0x4f7f  使
  127,79,36,37,77,38,1,251,0,0,57,0,0,26,128,0,0,0,0,127,64,0,47,192,0,0,0,0,255,0,0,47,192,0,0,0,1,253,0,0,47,192,0,0,0,2,254,255,255,255,255,255,253,0,7,250,255,255,255,255,255,253,0,15,242,255,255,255,255,255,253,0,31,224,0,0,47,192,0,0,0,63,192,0,0,47,192,0,0,0,191,192,0,0,47,192,0,0,1,255,192,0,0,47,192,0,0,3,255,192,191,255,255,255,255,244,15,255,192,191,255,255,255,255,244,47,255,192,191,255,255,255,255,244,191,255,192,190,0,47,192,3,244,255,175,192,190,0,47,192,3,244,127,47,192,190,0,47,192,3,244,60,47,192,190,0,47,192,3,244,16,47,192,190,0,47,192,3,244,0,47,192,191,255,255,255,255,244,0,47,192,191,255,255,255,255,244,0,47,192,191,255,255,255,255,244,0,47,192,0,0,63,128,0,0,0,47,192,127,0,63,64,0,0,0,47,192,63,128,127,0,0,0,0,47,192,15,224,191,0,0,0,0,47,192,11,248,254,0,0,0,0,47,192,2,255,252,0,0,0,0,47,192,0,191,248,0,0,0,0,47,192,0,63,253,0,0,0,0,47,192,0,255,255,228,0,0,0,47,192,11,255,191,255,144,0,0,47,193,255,253,11,255,255,229,0,47,203,255,224,0,191,255,253,0,47,195,254,0,0,6,255,248,0,47,192,224,0,0,0,6,176,0,0,0,0,0,0,0,0,0,
  // 0x4f9b  供
  155,79,36,36,68,38,1,252,0,0,36,0,105,0,6,160,0,0,0,191,0,191,0,11,240,0,0,0,254,0,191,0,11,240,0,0,1,253,0,191,0,11,240,0,0,3,252,0,191,0,11,240,0,0,7,244,0,191,0,11,240,0,0,15,240,0,191,0,11,240,0,0,47,208,0,191,0,11,240,0,0,63,192,255,255,255,255,255,252,0,191,64,255,255,255,255,255,252,1,255,64,255,255,255,255,255,252,3,255,64,85,191,85,91,245,84,15,255,64,0,191,0,11,240,0,47,255,64,0,191,0,11,240,0,127,255,64,0,191,0,11,240,0,255,191,64,0,191,0,11,240,0,127,63,64,0,191,0,11,240,0,60,63,64,0,191,0,11,240,0,20,63,64,0,191,0,11,240,0,0,63,64,0,191,0,11,240,0,0,63,65,85,255,85,95,245,84,0,63,67,255,255,255,255,255,253,0,63,67,255,255,255,255,255,253,0,63,67,255,255,255,255,255,253,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,61,0,1,192,0,0,63,64,0,191,64,15,240,0,0,63,64,1,254,0,7,252,0,0,63,64,7,252,0,2,254,0,0,63,64,15,244,0,0,191,128,0,63,64,63,208,0,0,63,208,0,63,65,255,128,0,0,15,240,0,63,67,254,0,0,0,7,252,0,63,65,248,0,0,0,2,244,0,63,64,32,0,0,0,0,128,
  // 0x4fb5  侵
  181,79,36,36,68,38,1,251,0,0,190,0,0,0,0,0,0,0,0,254,47,255,255,255,255,128,0,2,252,47,255,255,255,255,128,0,3,252,26,170,170,170,191,128,0,7,244,0,0,0,0,63,128,0,15,240,0,0,0,0,63,128,0,47,208,15,255,255,255,255,128,0,63,192,15,255,255,255,255,128,0,191,64,6,170,170,170,191,128,1,255,64,0,0,0,0,63,128,3,255,64,0,0,0,0,63,128,15,255,64,63,255,255,255,255,128,47,255,64,63,255,255,255,255,128,191,255,64,42,170,170,170,170,64,255,191,64,0,0,0,0,0,0,126,63,66,170,170,170,170,170,168,56,63,67,255,255,255,255,255,252,0,63,67,255,255,255,255,255,252,0,63,67,240,0,0,0,1,252,0,63,67,240,0,0,0,1,252,0,63,67,240,0,0,0,1,252,0,63,67,255,255,255,255,255,252,0,63,64,15,255,255,255,255,0,0,63,64,15,255,255,255,252,0,0,63,64,1,253,0,3,248,0,0,63,64,0,255,0,15,240,0,0,63,64,0,63,208,63,208,0,0,63,64,0,31,249,255,64,0,0,63,64,0,7,255,253,0,0,0,63,64,0,2,255,248,0,0,0,63,64,0,111,255,255,208,0,0,63,64,111,255,254,255,255,164,0,63,67,255,255,128,47,255,253,0,63,66,255,244,0,1,191,248,0,63,0,228,0,0,0,1,176,0,0,0,0,0,0,0,0,0,
  // 0x4fdd  保
  221,79,36,36,68,38,1,252,0,0,36,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,191,31,255,255,255,255,192,0,0,254,31,255,255,255,255,192,0,2,252,31,255,255,255,255,192,0,3,248,31,192,0,0,31,192,0,15,240,31,192,0,0,31,192,0,31,224,31,192,0,0,31,192,0,63,192,31,192,0,0,31,192,0,191,192,31,192,0,0,31,192,1,255,192,31,192,0,0,31,192,3,255,192,31,255,255,255,255,192,15,255,192,31,255,255,255,255,192,63,255,192,31,255,255,255,255,192,191,239,192,0,0,47,192,0,0,191,111,192,0,0,47,192,0,0,62,47,192,0,0,47,192,0,0,44,47,192,0,0,47,192,0,0,0,47,192,0,0,47,192,0,0,0,47,195,255,255,255,255,255,252,0,47,195,255,255,255,255,255,252,0,47,195,255,255,255,255,255,252,0,47,192,0,3,255,252,0,0,0,47,192,0,11,255,255,0,0,0,47,192,0,31,255,255,128,0,0,47,192,0,63,239,223,208,0,0,47,192,0,255,47,207,244,0,0,47,192,3,253,47,195,253,0,0,47,192,31,248,47,193,255,64,0,47,192,127,224,47,192,127,208,0,47,195,255,128,47,192,47,248,0,47,207,254,0,47,192,11,255,0,47,199,248,0,47,192,2,253,0,47,193,208,0,47,192,0,116,0,47,192,0,0,47,192,0,0,0,31,128,0,0,47,192,0,0,
  // 0x4fe1  信
  225,79,36,36,68,38,1,252,0,0,36,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,191,7,255,255,255,255,0,0,0,254,7,255,255,255,255,0,0,2,252,3,255,255,255,255,0,0,3,248,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,31,227,255,255,255,255,255,253,0,63,195,255,255,255,255,255,253,0,191,195,255,255,255,255,255,253,0,255,192,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,11,255,192,0,0,0,0,0,0,47,255,192,15,255,255,255,255,128,127,255,192,15,255,255,255,255,128,255,175,192,11,255,255,255,255,128,191,47,192,0,0,0,0,0,0,60,47,192,0,0,0,0,0,0,16,47,192,11,255,255,255,255,64,0,47,192,15,255,255,255,255,128,0,47,192,15,255,255,255,255,128,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,15,255,255,255,255,192,0,47,192,31,255,255,255,255,192,0,47,192,31,255,255,255,255,192,0,47,192,31,192,0,0,31,192,0,47,192,31,192,0,0,31,192,0,47,192,31,192,0,0,31,192,0,47,192,31,192,0,0,31,192,0,47,192,31,192,0,0,31,192,0,47,192,31,255,255,255,255,192,0,47,192,31,255,255,255,255,192,0,47,192,31,255,255,255,255,192,0,47,192,31,192,0,0,31,192,0,26,128,15,192,0,0,26,128,
  // 0x503c  值
  60,80,36,36,68,38,1,252,0,0,96,0,0,30,128,0,0,0,0,254,0,0,47,192,0,0,0,0,253,0,0,63,192,0,0,0,2,252,0,0,63,128,0,0,0,3,249,255,255,255,255,255,244,0,7,241,255,255,255,255,255,244,0,15,241,255,255,255,255,255,244,0,31,208,0,0,127,0,0,0,0,63,192,0,0,190,0,0,0,0,191,64,0,0,253,0,0,0,0,255,0,26,170,254,170,170,0,3,255,0,31,255,255,255,255,0,11,255,0,31,255,255,255,255,0,31,255,0,31,128,0,0,63,0,63,255,0,31,128,0,0,63,0,191,255,0,31,128,0,0,63,0,63,127,0,31,255,255,255,255,0,45,63,0,31,255,255,255,255,0,8,63,0,31,234,170,170,191,0,0,63,0,31,128,0,0,63,0,0,63,0,31,128,0,0,63,0,0,63,0,31,255,255,255,255,0,0,63,0,31,255,255,255,255,0,0,63,0,31,213,85,85,191,0,0,63,0,31,128,0,0,63,0,0,63,0,31,128,0,0,63,0,0,63,0,31,213,85,85,191,0,0,63,0,31,255,255,255,255,0,0,63,0,31,255,255,255,255,0,0,63,0,31,128,0,0,63,0,0,63,0,31,128,0,0,63,0,0,63,0,31,128,0,0,63,0,0,63,15,255,255,255,255,255,253,0,63,15,255,255,255,255,255,253,0,63,15,255,255,255,255,255,253,0,63,0,0,0,0,0,0,0,
  // 0x503e  倾
  62,80,36,37,77,38,1,251,0,7,144,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,15,208,0,15,255,255,255,253,0,31,192,0,15,255,255,255,253,0,47,199,224,15,255,255,255,253,0,63,71,224,0,0,63,64,0,0,127,7,224,0,0,127,0,0,0,254,7,224,0,0,190,0,0,1,253,7,224,0,0,253,0,0,3,253,7,224,2,255,255,255,224,7,253,7,224,2,255,255,255,224,15,253,7,224,2,255,255,255,224,31,253,7,255,242,248,0,11,224,63,253,7,255,242,248,20,11,224,191,253,7,255,242,248,63,11,224,255,189,7,224,2,248,63,11,224,188,189,7,224,2,248,63,11,224,56,189,7,224,2,248,63,11,224,32,189,7,224,2,248,63,11,224,0,189,7,224,2,248,63,11,224,0,189,7,224,2,248,63,11,224,0,189,7,224,2,248,63,11,224,0,189,7,224,18,248,62,11,224,0,189,7,225,242,248,62,11,224,0,189,7,255,242,248,62,11,224,0,189,7,255,226,248,126,11,224,0,189,15,255,66,248,253,11,224,0,189,15,244,0,0,252,0,0,0,189,11,128,0,2,248,224,0,0,189,5,0,0,7,247,252,0,0,189,0,0,0,31,226,255,64,0,189,0,0,0,127,192,127,208,0,189,0,0,2,255,0,15,248,0,189,0,0,47,252,0,3,252,0,189,0,0,47,224,0,0,248,0,189,0,0,14,0,0,0,32,0,0,0,0,0,0,0,0,0,
  // 0x504f  偏
  79,80,36,36,68,38,1,252,0,1,128,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,246,255,255,255,255,255,253,0,11,243,255,255,255,255,255,253,0,15,227,255,255,255,255,255,253,0,31,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,64,42,170,170,170,170,160,0,191,0,127,255,255,255,255,240,0,255,0,127,255,255,255,255,240,3,255,0,127,0,0,0,11,240,7,255,0,127,0,0,0,11,240,15,255,0,127,0,0,0,11,240,47,255,0,127,0,0,0,11,240,127,255,0,127,255,255,255,255,240,255,255,0,127,255,255,255,255,240,255,127,0,127,170,170,170,170,160,124,127,0,127,0,0,0,0,0,52,127,0,127,0,0,0,0,0,0,127,0,191,255,255,255,255,248,0,127,0,191,255,255,255,255,248,0,127,0,255,255,255,255,255,248,0,127,0,255,240,124,15,66,248,0,127,0,255,240,124,15,66,248,0,127,1,255,240,124,15,66,248,0,127,2,255,240,124,15,66,248,0,127,3,251,255,255,255,255,248,0,127,3,247,255,255,255,255,248,0,127,7,243,250,255,191,235,248,0,127,15,227,240,124,15,66,248,0,127,31,211,240,124,15,66,248,0,127,63,195,240,124,15,66,248,0,127,127,67,240,124,15,66,248,0,127,30,3,240,124,15,127,244,0,127,0,3,240,124,15,95,240,0,127,0,3,240,124,15,79,208,
  // 0x505c  停
  92,80,36,36,68,38,1,252,0,0,80,0,0,42,128,0,0,0,0,255,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,2,252,0,0,63,192,0,0,0,3,251,255,255,255,255,255,252,0,11,243,255,255,255,255,255,252,0,15,243,255,255,255,255,255,252,0,47,192,0,0,0,0,0,0,0,63,128,5,85,85,85,85,0,0,255,64,15,255,255,255,255,64,2,255,64,15,255,255,255,255,64,7,255,64,15,192,0,0,63,64,15,255,64,15,192,0,0,63,64,63,255,64,15,192,0,0,63,64,191,255,64,15,255,255,255,255,64,255,127,64,15,255,255,255,255,64,125,63,64,5,85,85,85,85,0,56,63,64,0,0,0,0,0,0,16,63,71,255,255,255,255,255,254,0,63,75,255,255,255,255,255,254,0,63,75,255,255,255,255,255,254,0,63,75,224,0,0,0,0,190,0,63,75,224,0,0,0,0,190,0,63,75,226,255,255,255,252,190,0,63,75,227,255,255,255,252,190,0,63,75,227,255,255,255,252,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,255,255,128,0,0,0,63,64,0,191,255,64,0,0,0,63,0,0,127,249,0,0,0,
  // 0x50a8  储
  168,80,36,36,68,38,1,252,0,7,144,0,0,11,224,0,0,0,11,224,0,0,11,224,0,228,0,15,193,128,0,11,224,2,252,0,31,203,224,0,11,224,3,244,0,47,135,244,15,255,255,235,240,0,63,2,253,15,255,255,255,208,0,127,0,255,15,255,255,255,192,0,190,0,63,64,11,224,63,128,0,252,0,29,0,11,224,255,0,2,252,0,4,0,11,225,253,0,3,252,0,0,0,11,227,252,0,11,252,0,0,0,11,235,244,0,15,252,21,84,63,255,255,255,253,47,252,191,252,63,255,255,255,253,127,252,191,252,63,255,255,255,253,255,252,191,252,0,3,253,0,0,189,252,0,252,0,15,248,0,0,56,252,0,252,0,63,224,0,0,32,252,0,252,1,255,192,0,0,0,252,0,252,11,255,255,255,240,0,252,0,252,127,255,255,255,240,0,252,0,252,255,255,255,255,240,0,252,0,252,63,253,0,7,240,0,252,0,252,24,189,0,7,240,0,252,0,252,0,189,0,7,240,0,252,0,252,0,191,255,255,240,0,252,0,252,0,191,255,255,240,0,252,0,252,36,191,170,171,240,0,252,0,254,248,189,0,7,240,0,252,0,255,252,189,0,7,240,0,252,2,255,224,189,0,7,240,0,252,7,255,64,191,255,255,240,0,252,3,248,0,191,255,255,240,0,252,1,208,0,191,255,255,240,0,252,0,0,0,189,0,7,240,0,168,0,0,0,105,0,2,144,
  // 0x50cf  像
  207,80,36,36,68,38,1,252,0,1,144,0,121,0,0,0,0,0,3,248,0,254,0,0,0,0,0,3,244,2,254,170,168,0,0,0,11,240,7,255,255,255,0,0,0,15,224,15,255,255,255,0,0,0,31,208,63,192,1,253,0,0,0,63,192,255,64,3,252,0,0,0,63,130,254,0,11,244,0,0,0,191,15,255,255,255,255,255,240,0,255,63,255,255,255,255,255,240,3,255,15,254,85,127,149,91,240,7,255,2,252,0,63,64,7,240,15,255,0,252,0,63,64,7,240,47,255,0,252,0,63,64,7,240,127,255,0,255,255,255,255,255,240,255,191,0,255,255,255,255,255,240,190,127,0,85,111,250,253,85,80,60,127,0,0,191,208,252,0,0,48,127,0,11,255,192,189,1,240,0,127,1,255,255,240,126,7,252,0,127,15,255,131,248,63,31,244,0,127,7,248,7,253,63,255,192,0,127,2,64,47,255,47,254,0,0,127,0,1,255,127,79,244,0,0,127,0,47,248,31,203,224,0,0,127,6,255,208,47,199,240,0,0,127,11,253,0,255,211,252,0,0,127,3,208,7,255,225,254,0,0,127,0,0,63,251,224,191,64,0,127,0,2,255,139,224,63,208,0,127,0,47,253,11,224,31,244,0,127,6,255,224,15,208,11,253,0,127,31,255,64,63,192,2,252,0,127,15,244,127,255,128,0,176,0,127,2,0,63,255,0,0,0,0,127,0,0,63,228,0,0,0,
  // 0x5145  充
  69,81,35,36,68,38,2,252,0,0,0,2,164,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,21,85,85,87,253,85,85,85,64,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,0,0,7,248,0,1,0,0,0,0,0,15,240,0,31,128,0,0,0,0,15,224,0,63,224,0,0,0,0,47,192,0,15,252,0,0,0,0,63,128,0,3,255,0,0,0,0,191,0,0,0,255,192,0,0,0,255,170,191,255,255,240,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,255,0,15,255,255,255,234,149,80,255,128,14,149,0,0,0,0,0,63,128,0,0,10,160,0,254,0,28,0,0,0,15,240,0,254,0,0,0,0,0,15,224,0,254,0,0,0,0,0,15,224,0,254,0,0,0,0,0,31,208,0,254,0,0,0,0,0,47,192,0,254,0,0,0,0,0,63,192,0,254,0,0,0,0,0,127,128,0,254,0,3,144,0,0,255,64,0,254,0,3,244,0,2,255,0,0,254,0,3,244,0,11,252,0,0,254,0,3,244,0,127,244,0,0,254,0,3,240,7,255,224,0,0,255,0,11,240,191,255,64,0,0,255,255,255,224,191,248,0,0,0,127,255,255,208,63,128,0,0,0,47,255,255,128,20,0,0,0,0,0,85,80,0,
  // 0x5148  先
  72,81,34,37,77,38,2,251,0,0,0,2,248,0,0,0,0,0,3,160,3,252,0,0,0,0,0,7,244,3,252,0,0,0,0,0,11,240,3,252,0,0,0,0,0,15,240,3,252,0,0,0,0,0,31,208,3,252,0,0,0,0,0,47,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,127,255,255,255,255,255,252,0,0,255,85,87,253,85,85,84,0,1,253,0,3,252,0,0,0,0,3,252,0,3,252,0,0,0,0,11,244,0,3,252,0,0,0,0,11,240,0,3,252,0,0,0,0,1,208,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,21,85,85,87,253,85,85,85,80,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,15,208,0,254,0,0,0,0,0,31,208,0,254,0,0,0,0,0,47,192,0,254,0,0,0,0,0,63,192,0,254,0,0,0,0,0,63,128,0,254,0,0,0,0,0,127,128,0,254,0,0,0,0,0,255,0,0,254,0,1,0,0,1,255,0,0,254,0,3,208,0,3,253,0,0,254,0,3,240,0,15,252,0,0,254,0,7,240,0,63,240,0,0,254,0,7,240,2,255,208,0,0,254,0,15,224,47,255,64,0,0,255,255,255,208,191,252,0,0,0,191,255,255,192,63,224,0,0,0,47,255,255,64,30,0,0,0,0,1,85,80,0,0,0,0,0,0,0,0,0,0,
  // 0x5149  光
  73,81,36,37,77,38,1,251,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,30,0,0,254,0,0,189,0,0,191,0,0,254,0,0,255,0,0,63,128,0,254,0,1,254,0,0,47,208,0,254,0,3,252,0,0,15,240,0,254,0,7,248,0,0,11,244,0,254,0,15,240,0,0,3,248,0,254,0,31,224,0,0,3,252,0,254,0,63,192,0,0,1,253,0,254,0,127,64,0,0,0,253,0,254,0,127,0,0,0,0,80,0,254,0,4,0,0,0,0,0,0,254,0,0,0,0,21,85,85,85,255,85,85,85,84,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,3,248,0,63,64,0,0,0,0,7,244,0,63,64,0,0,0,0,7,244,0,63,64,0,0,0,0,11,240,0,63,64,0,0,0,0,11,240,0,63,64,0,0,0,0,15,240,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,47,208,0,63,64,0,0,0,0,63,192,0,63,64,0,64,0,0,191,128,0,63,64,0,248,0,1,255,0,0,63,64,0,253,0,7,254,0,0,63,64,0,253,0,31,252,0,0,63,64,0,252,0,255,240,0,0,63,128,1,252,31,255,192,0,0,63,213,87,252,127,254,0,0,0,63,255,255,248,47,244,0,0,0,31,255,255,240,14,64,0,0,0,7,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x5165  入
  101,81,35,34,50,38,2,252,0,2,170,170,168,0,0,0,0,0,3,255,255,253,0,0,0,0,0,3,255,255,253,0,0,0,0,0,3,255,255,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,5,255,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,31,255,128,0,0,0,0,0,0,47,255,192,0,0,0,0,0,0,63,255,192,0,0,0,0,0,0,127,223,208,0,0,0,0,0,0,191,79,240,0,0,0,0,0,0,255,11,244,0,0,0,0,0,2,254,7,248,0,0,0,0,0,3,253,3,252,0,0,0,0,0,7,252,2,254,0,0,0,0,0,15,244,0,255,64,0,0,0,0,47,240,0,191,192,0,0,0,0,127,192,0,63,224,0,0,0,0,255,128,0,31,244,0,0,0,3,255,0,0,15,253,0,0,0,11,253,0,0,3,255,0,0,0,47,248,0,0,1,255,192,0,0,191,224,0,0,0,127,244,0,3,255,192,0,0,0,47,254,0,31,255,0,0,0,0,11,255,192,255,252,0,0,0,0,1,255,244,255,224,0,0,0,0,0,127,224,47,64,0,0,0,0,0,15,192,8,0,0,0,0,0,0,1,0,
  // 0x5168  全
  104,81,36,35,59,38,1,253,0,0,0,1,255,0,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,15,255,224,0,0,0,0,0,0,47,255,244,0,0,0,0,0,0,191,199,253,0,0,0,0,0,2,255,66,255,64,0,0,0,0,7,254,0,191,208,0,0,0,0,31,248,0,47,244,0,0,0,0,191,224,0,11,254,0,0,0,2,255,128,0,2,255,192,0,0,15,254,0,0,0,191,244,0,0,127,244,0,0,0,31,254,0,2,255,208,0,0,0,3,255,208,31,255,0,0,0,0,0,255,253,127,251,255,255,255,255,255,239,252,47,211,255,255,255,255,255,195,244,14,3,255,255,255,255,255,192,176,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,
  // 0x5171  共
  113,81,34,36,68,38,2,252,0,0,106,0,0,10,144,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,21,85,191,85,85,95,245,85,64,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,85,85,85,85,85,80,0,0,0,0,0,0,0,0,0,0,0,4,0,0,5,0,0,0,0,0,63,144,0,63,128,0,0,0,0,191,208,0,191,240,0,0,0,3,255,64,0,31,253,0,0,0,15,253,0,0,3,255,128,0,0,127,244,0,0,0,255,240,0,2,255,208,0,0,0,47,252,0,31,255,0,0,0,0,7,255,0,127,248,0,0,0,0,1,255,192,31,208,0,0,0,0,0,127,64,6,0,0,0,0,0,0,24,0,
  // 0x5173  关
  115,81,27,36,252,38,5,252,0,0,0,0,0,160,0,0,47,0,0,0,255,0,0,127,64,0,2,254,0,0,63,192,0,3,252,0,0,15,240,0,11,244,0,0,11,244,0,15,224,0,0,3,252,0,47,192,0,0,2,240,0,31,64,0,1,86,149,85,86,85,64,3,255,255,255,255,255,192,3,255,255,255,255,255,192,3,255,255,255,255,255,192,0,0,0,254,0,0,0,0,0,0,254,0,0,0,0,0,0,254,0,0,0,0,0,0,254,0,0,0,0,0,0,254,0,0,0,0,0,0,254,0,0,0,31,255,255,255,255,255,248,31,255,255,255,255,255,248,31,255,255,255,255,255,248,5,85,86,255,149,85,80,0,0,2,255,192,0,0,0,0,3,255,208,0,0,0,0,7,255,240,0,0,0,0,15,251,244,0,0,0,0,31,227,252,0,0,0,0,63,193,255,0,0,0,0,255,64,191,192,0,0,7,254,0,63,240,0,0,47,252,0,15,253,0,1,255,240,0,7,255,208,31,255,128,0,1,255,252,127,253,0,0,0,63,252,47,224,0,0,0,7,240,10,0,0,0,0,0,80,
  // 0x5177  具
  119,81,34,34,50,38,2,252,0,31,255,255,255,255,255,128,0,0,31,255,255,255,255,255,128,0,0,31,250,170,170,170,191,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,234,170,170,170,191,128,0,0,31,255,255,255,255,255,128,0,0,31,255,255,255,255,255,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,234,170,170,170,191,128,0,0,31,255,255,255,255,255,128,0,0,31,255,255,255,255,255,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,255,255,255,255,255,128,0,0,31,255,255,255,255,255,128,0,0,31,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,21,85,85,85,85,85,85,85,64,0,0,11,0,0,9,0,0,0,0,0,127,208,0,63,224,0,0,0,11,255,240,0,255,255,64,0,0,191,255,64,0,31,255,244,0,47,255,244,0,0,1,191,255,128,191,255,64,0,0,0,11,255,240,47,228,0,0,0,0,0,191,128,9,0,0,0,0,0,0,9,0,
  // 0x5197  冗
  151,81,35,34,50,38,2,252,21,85,85,85,85,85,85,85,64,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,128,0,0,0,0,0,47,192,63,128,0,0,0,0,0,47,192,63,128,0,0,0,0,0,47,192,63,128,0,0,0,0,0,47,192,63,128,0,0,0,0,0,47,192,63,128,0,0,0,0,0,47,192,63,128,21,85,85,85,64,47,192,0,0,127,255,255,255,208,0,0,0,0,127,255,255,255,208,0,0,0,0,127,255,255,255,208,0,0,0,0,127,64,0,31,208,0,0,0,0,127,64,0,31,208,0,0,0,0,127,64,0,31,208,0,0,0,0,127,64,0,31,208,0,0,0,0,127,64,0,31,208,0,0,0,0,191,0,0,31,208,0,0,0,0,191,0,0,31,208,0,0,0,0,191,0,0,31,208,0,0,0,0,255,0,0,31,208,0,0,0,0,254,0,0,31,208,1,0,0,2,253,0,0,31,208,3,208,0,3,252,0,0,31,208,3,244,0,15,248,0,0,31,208,3,244,0,63,240,0,0,31,208,3,244,1,255,208,0,0,31,208,3,240,11,255,64,0,0,31,224,11,240,191,253,0,0,0,31,255,255,240,255,244,0,0,0,15,255,255,208,63,128,0,0,0,7,255,255,128,40,0,0,0,0,0,85,84,0,
  // 0x51b7  冷
  183,81,36,36,68,38,1,252,0,0,0,0,0,169,0,0,0,0,0,0,0,3,255,64,0,0,2,0,0,0,7,255,192,0,0,15,192,0,0,15,255,224,0,0,47,244,0,0,63,223,248,0,0,31,254,0,0,191,131,254,0,0,3,255,128,1,255,1,255,64,0,0,191,224,7,253,0,127,208,0,0,47,208,31,244,0,47,248,0,0,11,64,127,224,0,11,254,0,0,1,1,255,128,0,2,255,192,0,0,11,255,85,85,85,191,248,0,0,63,250,255,255,255,95,254,0,0,255,226,255,255,255,67,252,0,0,191,66,255,255,255,64,180,0,0,60,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,0,0,3,129,255,255,255,255,255,128,0,7,241,255,255,255,255,255,128,0,15,241,255,255,255,255,255,128,0,47,224,0,15,224,0,63,128,0,63,192,0,15,224,0,63,128,0,191,64,0,15,224,0,63,128,1,255,0,0,15,224,0,63,128,3,253,0,0,15,224,0,63,128,11,252,0,0,15,224,0,63,128,15,244,0,0,15,224,0,63,128,63,224,0,0,15,224,127,255,128,127,192,0,0,15,224,63,255,64,31,64,0,0,15,224,47,254,0,2,0,0,0,15,224,5,64,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,11,224,0,0,0,
  // 0x51c6  准
  198,81,36,36,68,38,1,252,0,0,0,0,36,0,5,0,0,0,0,0,0,191,0,15,224,0,0,0,0,0,255,0,31,208,0,3,192,0,1,253,0,47,192,0,15,244,0,2,252,0,63,128,0,15,254,0,3,248,0,127,0,0,2,255,192,11,240,0,191,0,0,0,127,240,15,240,0,254,0,0,0,31,240,47,255,255,255,255,248,0,3,208,127,255,255,255,255,248,0,0,64,255,255,255,255,255,248,0,0,2,255,192,2,248,0,0,0,0,11,255,192,2,248,0,0,0,0,31,255,192,2,248,0,0,0,0,127,239,192,2,248,0,0,0,0,63,143,255,255,255,255,224,0,0,15,15,255,255,255,255,224,0,0,0,15,255,255,255,255,224,0,0,0,15,208,3,248,0,0,0,1,0,15,192,2,248,0,0,0,3,128,15,192,2,248,0,0,0,15,224,15,192,2,248,0,0,0,31,240,15,192,2,248,0,0,0,63,192,15,255,255,255,255,224,0,191,128,15,255,255,255,255,224,0,255,0,15,255,255,255,255,224,3,253,0,15,208,3,248,0,0,7,252,0,15,192,2,248,0,0,15,240,0,15,192,2,248,0,0,63,224,0,15,192,2,248,0,0,127,192,0,15,213,87,253,85,84,31,64,0,15,255,255,255,255,253,6,0,0,15,255,255,255,255,253,0,0,0,15,255,255,255,255,253,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,
  // 0x51fa  出
  250,81,30,36,32,38,4,252,0,0,0,42,64,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,192,0,63,128,0,127,64,31,255,255,255,255,255,255,64,31,255,255,255,255,255,255,64,31,255,255,255,255,255,255,64,5,85,85,127,213,85,85,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,0,0,63,128,0,11,240,191,255,255,255,255,255,255,240,191,255,255,255,255,255,255,240,191,255,255,255,255,255,255,240,191,85,85,85,85,85,95,240,191,0,0,0,0,0,11,240,190,0,0,0,0,0,11,224,
  // 0x51fb  击
  251,81,34,36,68,38,2,252,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,1,85,85,87,253,85,85,84,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,85,85,85,87,253,85,85,85,80,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,1,168,0,2,252,0,3,244,0,1,253,0,2,252,0,3,244,0,1,253,0,2,252,0,3,244,0,1,253,0,2,252,0,3,244,0,1,253,0,2,252,0,3,244,0,1,253,0,2,252,0,3,244,0,1,253,0,2,252,0,3,244,0,1,253,0,2,252,0,3,244,0,1,253,0,2,252,0,3,244,0,1,254,85,87,253,85,91,244,0,1,255,255,255,255,255,255,244,0,1,255,255,255,255,255,255,244,0,1,255,255,255,255,255,255,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,
  // 0x5206  分
  6,82,36,35,59,38,1,252,0,0,3,224,0,7,192,0,0,0,0,11,248,0,31,224,0,0,0,0,15,240,0,15,244,0,0,0,0,47,224,0,7,252,0,0,0,0,63,192,0,3,254,0,0,0,0,255,128,0,0,255,64,0,0,2,255,0,0,0,191,192,0,0,3,253,0,0,0,63,240,0,0,15,252,0,0,0,15,248,0,0,63,240,0,0,0,7,254,0,0,255,208,0,0,0,3,255,128,2,255,128,0,0,0,0,255,224,15,254,0,0,0,0,0,63,248,63,254,85,85,85,85,85,111,254,191,235,255,255,255,255,255,247,252,47,139,255,255,255,255,255,241,240,10,11,255,255,255,255,255,240,80,0,0,0,47,192,0,15,224,0,0,0,0,63,192,0,15,224,0,0,0,0,63,192,0,15,224,0,0,0,0,127,128,0,15,224,0,0,0,0,127,64,0,15,224,0,0,0,0,255,0,0,15,208,0,0,0,0,255,0,0,31,208,0,0,0,3,253,0,0,31,208,0,0,0,7,252,0,0,31,192,0,0,0,15,244,0,0,47,192,0,0,0,63,240,0,0,47,192,0,0,0,255,192,0,0,63,192,0,0,11,255,64,0,0,63,128,0,0,127,253,0,0,0,191,64,0,11,255,244,0,31,255,255,0,0,7,255,128,0,15,255,254,0,0,2,253,0,0,11,255,248,0,0,0,128,0,0,1,85,64,0,0,
  // 0x5207  切
  7,82,35,36,68,38,1,251,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,15,255,255,255,255,248,0,127,0,15,255,255,255,255,248,0,127,0,15,255,255,255,255,248,0,127,0,5,85,191,85,87,248,0,127,0,0,0,191,0,3,248,0,127,0,0,0,191,0,3,248,0,127,1,191,0,191,0,3,248,0,127,191,255,64,191,0,3,248,6,255,255,255,128,254,0,3,248,191,255,255,233,0,254,0,3,244,191,255,228,0,0,254,0,3,244,127,255,0,0,0,254,0,3,244,16,127,0,0,0,254,0,3,244,0,127,0,0,0,253,0,7,244,0,127,0,0,0,253,0,7,244,0,127,0,0,1,252,0,7,244,0,127,0,0,2,252,0,7,240,0,127,0,52,3,252,0,7,240,0,127,0,63,3,248,0,7,240,0,127,0,63,7,244,0,11,240,0,127,0,127,11,240,0,11,240,0,127,0,190,15,240,0,11,240,0,127,255,253,31,208,0,15,240,0,63,255,252,63,192,0,15,240,0,31,255,244,127,128,0,15,224,0,1,85,64,255,0,0,15,224,0,0,0,3,254,0,0,31,208,0,0,0,15,252,0,0,47,208,0,0,0,63,244,0,0,127,192,0,0,1,255,208,3,255,255,192,0,0,3,255,128,2,255,255,64,0,0,0,253,0,1,255,253,0,0,0,0,48,0,0,106,80,0,0,0,0,0,0,0,0,0,0,
  // 0x521b  创
  27,82,34,36,68,38,1,252,0,0,6,64,0,0,0,0,0,0,0,15,240,0,0,0,15,224,0,0,31,208,0,0,0,15,224,0,0,63,240,0,0,0,15,224,0,0,191,252,0,1,80,15,224,0,1,255,254,0,3,244,15,224,0,3,252,191,128,3,244,15,224,0,11,244,63,224,3,244,15,224,0,47,224,15,244,3,244,15,224,0,127,192,3,252,3,244,15,224,1,255,64,1,255,3,244,15,224,7,253,0,0,191,195,244,15,224,47,244,0,0,63,211,244,15,224,191,224,0,0,15,195,244,15,224,63,255,255,255,255,3,244,15,224,13,191,255,255,248,3,244,15,224,0,191,255,255,244,3,244,15,224,0,191,0,3,244,3,244,15,224,0,191,0,3,244,3,244,15,224,0,191,0,3,244,3,244,15,224,0,191,0,3,240,3,244,15,224,0,191,0,7,240,3,244,15,224,0,191,0,11,240,3,244,15,224,0,191,0,15,240,3,244,15,224,0,191,15,255,224,3,244,15,224,0,191,7,255,192,3,244,15,224,0,191,3,254,0,0,0,15,224,0,191,0,0,13,0,0,15,224,0,191,0,0,15,192,0,15,224,0,191,0,0,15,192,0,15,224,0,191,0,0,31,192,0,15,224,0,191,0,0,63,128,0,15,224,0,127,255,255,255,64,85,95,224,0,63,255,255,255,0,255,255,208,0,11,255,255,248,0,191,255,192,0,0,0,0,0,0,127,249,0,
  // 0x521d  初
  29,82,35,36,68,38,1,252,0,11,224,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,1,85,85,85,85,80,0,11,240,3,255,255,255,255,248,0,11,240,3,255,255,255,255,248,0,11,240,3,255,255,255,255,248,63,255,255,240,0,127,64,3,248,63,255,255,248,0,127,64,3,248,63,255,255,244,0,127,0,3,248,0,0,15,240,0,127,0,3,248,0,0,15,208,0,127,0,3,248,0,0,63,192,0,191,0,3,248,0,0,127,64,0,191,0,3,244,0,0,255,0,0,191,0,3,244,0,2,253,29,0,191,0,3,244,0,7,248,63,0,254,0,3,244,0,15,244,254,0,254,0,7,244,0,63,254,248,0,253,0,7,244,0,255,255,224,1,253,0,7,244,3,255,255,208,2,252,0,7,240,15,255,251,240,2,252,0,7,240,127,255,243,252,3,248,0,7,240,191,203,240,253,7,244,0,11,240,63,11,240,120,11,240,0,11,240,44,11,240,16,15,240,0,11,240,0,11,240,0,47,208,0,15,240,0,11,240,0,63,192,0,15,240,0,11,240,0,191,64,0,15,224,0,11,240,1,255,0,0,15,224,0,11,240,7,253,0,0,31,208,0,11,240,31,248,0,0,63,192,0,11,240,127,240,3,255,255,192,0,11,240,191,192,2,255,255,64,0,11,240,47,0,1,255,254,0,0,11,224,8,0,0,106,80,0,
  // 0x522b  别
  43,82,34,36,68,38,1,251,0,0,0,0,0,0,0,15,224,11,255,255,255,240,0,0,15,224,11,255,255,255,240,0,0,15,224,11,255,255,255,240,1,64,15,224,11,224,0,11,240,11,224,15,224,11,224,0,11,240,11,224,15,224,11,224,0,11,240,11,224,15,224,11,224,0,11,240,11,224,15,224,11,224,0,11,240,11,224,15,224,11,224,0,11,240,11,224,15,224,11,240,0,11,240,11,224,15,224,11,255,255,255,240,11,224,15,224,11,255,255,255,240,11,224,15,224,11,255,255,255,240,11,224,15,224,0,0,0,0,0,11,224,15,224,0,1,252,0,0,11,224,15,224,0,2,252,0,0,11,224,15,224,0,2,252,0,0,11,224,15,224,47,255,255,255,248,11,224,15,224,47,255,255,255,244,11,224,15,224,47,255,255,255,244,11,224,15,224,0,3,244,3,244,11,224,15,224,0,3,240,3,244,11,224,15,224,0,7,240,3,244,11,224,15,224,0,11,240,3,240,11,224,15,224,0,15,224,7,240,1,64,15,224,0,31,192,7,240,0,0,15,224,0,63,192,7,240,0,0,15,224,0,127,64,11,240,0,0,15,224,0,255,0,15,240,0,0,15,224,3,253,0,31,224,0,0,15,224,31,248,47,255,208,0,106,175,224,127,240,15,255,192,0,127,255,208,63,128,15,255,0,0,63,255,192,13,0,0,0,0,0,63,249,0,0,0,0,0,0,0,0,0,0,
  // 0x5230  到
  48,82,34,35,59,38,1,252,0,0,0,0,0,0,0,6,160,0,0,0,0,0,0,0,11,240,63,255,255,255,255,0,0,11,240,63,255,255,255,255,0,0,11,240,63,255,255,255,255,31,192,11,240,0,11,244,0,0,31,192,11,240,0,15,240,1,0,31,192,11,240,0,15,208,47,0,31,192,11,240,0,47,192,47,192,31,192,11,240,0,63,128,15,240,31,192,11,240,0,127,0,3,248,31,192,11,240,21,255,175,255,253,31,192,11,240,63,255,255,255,255,31,192,11,240,63,255,255,255,255,95,192,11,240,63,250,165,64,47,223,192,11,240,0,0,42,0,14,31,192,11,240,0,0,63,64,0,31,192,11,240,0,0,63,64,0,31,192,11,240,0,0,63,64,0,31,192,11,240,0,0,63,64,0,31,192,11,240,15,255,255,255,252,31,192,11,240,15,255,255,255,252,31,192,11,240,15,255,255,255,252,31,192,11,240,0,0,127,64,0,31,192,11,240,0,0,63,64,0,31,192,11,240,0,0,63,64,0,5,64,11,240,0,0,63,64,0,0,0,11,240,0,0,63,64,0,0,0,11,240,0,0,63,70,191,64,0,11,240,0,5,191,255,255,64,0,11,240,111,255,255,255,255,64,0,11,240,127,255,255,255,233,0,106,175,240,63,255,250,80,0,0,127,255,224,62,148,0,0,0,0,63,255,192,0,0,0,0,0,0,63,250,0,
  // 0x5236  制
  54,82,34,36,68,38,1,252,0,0,10,128,0,0,0,1,80,0,228,31,192,0,0,0,3,240,1,252,31,192,0,0,0,3,240,2,252,31,192,0,0,0,3,240,3,248,31,192,0,0,253,3,240,3,248,31,192,0,0,253,3,240,7,255,255,255,255,64,253,3,240,11,255,255,255,255,64,253,3,240,15,255,255,255,255,64,253,3,240,47,192,31,192,0,0,253,3,240,63,128,31,192,0,0,253,3,240,127,0,31,192,0,0,253,3,240,11,0,31,208,0,0,253,3,240,63,255,255,255,255,240,253,3,240,63,255,255,255,255,240,253,3,240,63,255,255,255,255,240,253,3,240,0,0,31,192,0,0,253,3,240,0,0,31,192,0,0,253,3,240,0,0,31,192,0,0,253,3,240,11,255,255,255,255,128,253,3,240,11,255,255,255,255,128,253,3,240,11,255,255,255,255,128,253,3,240,11,224,31,192,47,128,253,3,240,11,224,31,192,47,128,253,3,240,11,224,31,192,47,128,253,3,240,11,224,31,192,47,128,0,3,240,11,224,31,192,47,128,0,3,240,11,224,31,192,47,128,0,3,240,11,224,31,192,47,128,0,3,240,11,224,31,192,47,128,0,3,240,11,224,31,203,255,128,0,3,240,11,224,31,199,255,64,0,7,240,11,224,31,195,249,0,47,255,240,0,0,31,192,0,0,15,255,240,0,0,31,192,0,0,15,255,192,0,0,31,192,0,0,6,148,0,
  // 0x5237  刷
  55,82,34,36,68,38,1,252,0,0,0,0,0,0,0,1,80,0,0,0,0,0,0,0,7,240,3,255,255,255,255,192,0,7,240,3,255,255,255,255,192,0,7,240,3,255,255,255,255,195,244,7,240,3,240,0,0,47,195,244,7,240,3,240,0,0,47,195,244,7,240,3,240,0,0,47,195,244,7,240,3,240,0,0,47,195,244,7,240,3,240,0,0,47,195,244,7,240,3,255,255,255,255,195,244,7,240,3,255,255,255,255,195,244,7,240,3,255,255,255,255,195,244,7,240,3,240,0,252,0,3,244,7,240,3,240,0,252,0,3,244,7,240,3,240,0,252,0,3,244,7,240,3,240,0,252,0,3,244,7,240,3,251,255,255,255,195,244,7,240,3,251,255,255,255,195,244,7,240,3,251,255,255,255,195,244,7,240,3,251,192,252,15,195,244,7,240,7,251,192,252,15,195,244,7,240,7,235,192,252,15,195,244,7,240,7,235,192,252,15,195,244,7,240,11,235,192,252,15,195,244,7,240,11,219,192,252,15,194,244,7,240,15,219,192,252,15,192,0,7,240,15,203,192,252,15,192,0,7,240,31,203,192,253,255,192,0,7,240,47,139,192,252,255,128,0,7,240,63,75,192,252,254,0,0,7,240,127,1,64,252,0,0,0,7,240,190,0,0,252,0,0,63,255,240,61,0,0,252,0,0,31,255,224,8,0,0,252,0,0,15,255,192,0,0,0,168,0,0,10,148,0,
  // 0x5272  割
  114,82,33,36,68,38,2,252,0,0,169,0,0,0,0,0,0,0,0,254,0,0,0,0,31,192,0,0,254,0,0,0,0,31,192,0,0,254,0,0,0,0,31,192,255,255,255,255,255,10,128,31,192,255,255,255,255,255,15,192,31,192,255,255,255,255,255,15,192,31,192,252,0,20,0,127,15,192,31,192,252,0,254,0,127,15,192,31,192,252,0,254,0,127,15,192,31,192,15,255,255,255,240,15,192,31,192,15,255,255,255,240,15,192,31,192,10,170,255,170,144,15,192,31,192,0,0,254,0,0,15,192,31,192,5,85,254,85,64,15,192,31,192,11,255,255,255,208,15,192,31,192,11,255,255,255,208,15,192,31,192,0,0,254,0,0,15,192,31,192,0,0,254,0,0,15,192,31,192,170,170,255,170,169,15,192,31,192,255,255,255,255,253,15,192,31,192,255,255,255,255,253,15,192,31,192,0,0,0,0,0,15,192,31,192,0,0,0,0,0,15,192,31,192,11,255,255,255,240,15,192,31,192,11,255,255,255,240,10,128,31,192,11,250,170,175,240,0,0,31,192,11,208,0,11,240,0,0,31,192,11,208,0,11,240,0,0,31,192,11,208,0,11,240,0,0,31,192,11,208,0,11,240,0,0,31,192,11,250,170,175,240,0,0,47,192,11,255,255,255,240,0,255,255,192,11,255,255,255,240,0,255,255,128,11,208,0,11,240,0,191,255,0,11,208,0,1,80,0,42,144,0,
  // 0x529b  力
  155,82,33,37,77,38,2,251,0,0,0,47,128,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,26,170,170,191,234,170,170,170,64,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,64,0,0,0,63,128,0,0,127,0,0,0,0,63,128,0,0,127,0,0,0,0,127,64,0,0,191,0,0,0,0,191,64,0,0,191,0,0,0,0,191,0,0,0,191,0,0,0,0,255,0,0,0,191,0,0,0,0,254,0,0,0,255,0,0,0,2,253,0,0,0,255,0,0,0,3,252,0,0,0,254,0,0,0,7,252,0,0,0,254,0,0,0,15,244,0,0,0,254,0,0,0,31,240,0,0,0,253,0,0,0,63,224,0,0,1,253,0,0,0,191,192,0,0,1,253,0,0,1,255,64,0,0,2,252,0,0,3,255,0,0,0,3,252,0,0,15,252,0,0,0,3,252,0,0,63,244,0,0,0,3,248,0,1,255,224,0,0,0,11,244,0,11,255,128,0,0,0,31,240,0,63,253,0,0,7,255,255,240,0,191,244,0,0,3,255,255,192,0,47,192,0,0,2,255,255,64,0,10,0,0,0,0,90,80,0,0,0,0,0,0,0,0,0,0,0,
  // 0x529f  功
  159,82,35,35,59,38,1,252,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,21,85,85,84,0,63,192,0,0,63,255,255,252,0,63,128,0,0,63,255,255,252,0,63,128,0,0,63,255,255,252,0,63,128,0,0,0,15,224,1,85,127,213,85,80,0,15,224,2,255,255,255,255,248,0,15,224,2,255,255,255,255,248,0,15,224,2,255,255,255,255,248,0,15,224,0,0,63,64,3,244,0,15,224,0,0,63,64,3,244,0,15,224,0,0,127,0,3,244,0,15,224,0,0,127,0,3,244,0,15,224,0,0,191,0,3,244,0,15,224,0,0,191,0,3,244,0,15,224,0,0,255,0,7,240,0,15,224,0,0,254,0,7,240,0,15,224,0,0,253,0,7,240,0,15,224,5,1,252,0,7,240,0,15,230,254,3,252,0,7,240,0,15,255,254,3,248,0,11,240,1,191,255,254,11,244,0,11,240,127,255,255,144,15,240,0,11,240,127,255,228,0,47,224,0,15,224,63,244,0,0,63,192,0,15,224,41,0,0,0,255,128,0,15,224,0,0,0,3,255,0,0,31,208,0,0,0,15,252,0,0,47,192,0,0,0,63,244,0,0,127,192,0,0,2,255,208,7,255,255,128,0,0,2,255,64,3,255,255,0,0,0,0,189,0,2,255,252,0,0,0,0,32,0,0,85,64,0,
  // 0x52a0  加
  160,82,34,36,68,38,1,252,0,1,64,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,21,85,85,80,0,15,224,0,0,127,255,255,224,0,15,224,0,0,127,255,255,224,21,95,245,85,80,127,255,255,224,63,255,255,255,240,127,0,15,224,63,255,255,255,240,127,0,15,224,63,255,255,255,240,127,0,15,224,0,15,208,11,240,127,0,15,224,0,15,208,11,224,127,0,15,224,0,15,208,11,224,127,0,15,224,0,15,192,11,224,127,0,15,224,0,31,192,11,224,127,0,15,224,0,31,192,15,224,127,0,15,224,0,31,192,15,224,127,0,15,224,0,47,192,15,224,127,0,15,224,0,47,192,15,224,127,0,15,224,0,63,128,15,224,127,0,15,224,0,63,64,15,208,127,0,15,224,0,63,64,15,208,127,0,15,224,0,127,0,15,208,127,0,15,224,0,191,0,15,208,127,0,15,224,0,255,0,15,208,127,0,15,224,1,253,0,15,208,127,0,15,224,2,252,0,31,192,127,0,15,224,3,252,0,31,192,127,0,15,224,7,244,0,47,192,127,255,255,224,15,240,0,63,192,127,255,255,224,47,224,85,191,128,127,255,255,224,127,192,191,255,64,127,85,95,224,127,128,127,255,0,127,0,15,224,31,0,63,248,0,127,0,15,224,4,0,0,0,0,0,0,0,0,
  // 0x52a8  动
  168,82,34,36,68,38,2,252,0,0,0,0,0,5,64,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,47,255,255,255,0,15,224,0,0,47,255,255,255,0,15,224,0,0,47,255,255,255,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,63,255,255,255,240,0,0,0,0,63,255,255,255,240,0,0,0,0,63,255,255,255,240,255,255,255,255,149,95,229,95,224,255,255,255,255,128,15,208,15,224,255,255,255,255,128,15,192,15,224,0,63,128,0,0,31,192,15,224,0,63,64,0,0,31,192,15,224,0,127,0,0,0,31,192,15,224,0,191,0,96,0,47,192,15,224,0,254,3,244,0,63,128,15,208,0,253,1,252,0,63,128,15,208,2,252,0,252,0,63,64,15,208,3,248,0,190,0,127,0,15,208,3,244,0,127,0,191,0,15,208,7,240,0,127,64,254,0,15,192,15,224,107,255,128,254,0,31,192,31,239,255,255,194,252,0,31,192,63,255,255,255,195,252,0,47,192,127,255,249,15,215,248,0,47,192,63,249,0,11,79,240,0,63,192,46,64,0,0,47,224,0,63,128,0,0,0,0,127,192,0,191,64,0,0,0,0,255,67,255,255,0,0,0,0,1,255,3,255,254,0,0,0,0,0,124,2,255,248,0,0,0,0,0,16,0,85,64,0,
  // 0x5316  化
  22,83,36,35,59,38,1,252,0,0,15,144,47,192,0,0,0,0,0,31,224,47,192,0,0,0,0,0,63,192,47,192,0,0,0,0,0,127,128,47,192,0,0,0,0,0,255,64,47,192,0,0,0,0,1,255,0,47,192,0,0,0,0,3,252,0,47,192,0,0,0,0,11,248,0,47,192,0,11,64,0,31,240,0,47,192,0,63,192,0,63,240,0,47,192,1,255,224,0,255,240,0,47,192,11,255,128,2,255,240,0,47,192,127,253,0,11,255,240,0,47,194,255,240,0,47,255,240,0,47,223,255,64,0,191,251,240,0,47,255,248,0,0,255,203,240,0,47,255,128,0,0,127,75,240,0,47,253,0,0,0,61,11,240,0,47,208,0,0,0,20,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,192,0,0,80,0,11,240,0,47,192,0,0,189,0,11,240,0,47,192,0,0,254,0,11,240,0,47,192,0,0,254,0,11,240,0,47,192,0,0,253,0,11,240,0,47,192,0,1,252,0,11,240,0,47,208,0,3,252,0,11,240,0,31,255,255,255,248,0,11,240,0,15,255,255,255,240,0,11,240,0,2,255,255,255,208,0,11,224,0,0,5,85,84,0,
  // 0x5347  升
  71,83,34,36,68,38,2,252,0,0,0,0,64,0,0,0,0,0,0,0,7,208,7,240,0,0,0,0,0,127,244,7,240,0,0,0,0,27,255,248,7,240,0,0,0,2,255,255,208,7,240,0,0,1,191,255,248,0,7,240,0,0,127,255,255,64,0,7,240,0,0,63,255,255,0,0,7,240,0,0,63,144,191,0,0,7,240,0,0,0,0,191,0,0,7,240,0,0,0,0,191,0,0,7,240,0,0,0,0,191,0,0,7,240,0,0,0,0,191,0,0,7,240,0,0,0,0,191,0,0,7,240,0,0,0,0,191,0,0,7,240,0,0,85,85,255,85,85,91,245,85,80,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,254,0,0,7,240,0,0,0,0,254,0,0,7,240,0,0,0,0,253,0,0,7,240,0,0,0,1,253,0,0,7,240,0,0,0,1,252,0,0,7,240,0,0,0,3,252,0,0,7,240,0,0,0,3,248,0,0,7,240,0,0,0,11,244,0,0,7,240,0,0,0,31,240,0,0,7,240,0,0,0,63,224,0,0,7,240,0,0,0,191,192,0,0,7,240,0,0,2,255,64,0,0,7,240,0,0,15,253,0,0,0,7,240,0,0,127,248,0,0,0,7,240,0,0,255,224,0,0,0,7,240,0,0,63,64,0,0,0,7,240,0,0,8,0,0,0,0,7,240,0,0,
  // 0x534a  半
  74,83,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,24,0,3,248,0,3,144,0,1,253,0,3,248,0,11,248,0,0,255,0,3,248,0,15,240,0,0,127,128,3,248,0,47,224,0,0,63,192,3,248,0,63,192,0,0,31,224,3,248,0,127,128,0,0,15,240,3,248,0,255,0,0,0,7,248,3,248,2,253,0,0,0,3,248,3,248,3,252,0,0,0,2,128,3,248,0,112,0,0,0,0,0,3,248,0,0,0,0,5,85,85,87,253,85,85,85,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,106,170,170,171,254,170,170,170,144,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x534f  协
  79,83,35,36,68,38,2,252,0,252,0,0,5,80,0,0,0,0,252,0,0,11,240,0,0,0,0,252,0,0,11,240,0,0,0,0,252,0,0,11,240,0,0,0,0,252,0,0,11,240,0,0,0,0,252,0,0,11,240,0,0,0,0,252,0,0,11,240,0,0,0,0,252,0,85,91,245,85,80,0,0,252,0,255,255,255,255,224,0,255,255,252,255,255,255,255,224,0,255,255,252,255,255,255,255,224,0,255,255,252,0,11,224,15,224,0,85,253,84,0,11,224,15,224,0,0,252,0,0,15,224,15,224,0,0,252,0,164,15,208,15,230,64,0,252,0,253,15,208,15,255,128,0,252,1,252,15,208,15,239,192,0,252,2,248,31,192,15,223,192,0,252,3,244,47,192,15,223,208,0,252,3,240,47,192,15,219,224,0,252,11,240,63,128,15,215,240,0,252,15,208,127,64,15,211,240,0,252,47,192,191,0,15,195,244,0,252,63,128,254,0,15,194,248,0,252,15,2,253,0,31,193,252,0,252,0,3,252,0,31,193,228,0,252,0,11,244,0,31,192,0,0,252,0,15,240,0,31,192,0,0,252,0,63,208,0,47,192,0,0,252,0,191,192,0,63,128,0,0,252,1,255,0,0,63,128,0,0,252,7,253,0,0,191,64,0,0,252,47,248,3,255,255,0,0,0,252,63,224,3,255,254,0,0,0,252,15,128,2,255,248,0,0,0,168,2,0,0,20,0,0,0,
  // 0x5355  单
  85,83,34,36,68,38,2,252,0,0,32,0,0,0,80,0,0,0,2,248,0,0,0,254,0,0,0,3,253,0,0,2,255,0,0,0,0,255,0,0,3,252,0,0,0,0,127,192,0,11,248,0,0,0,0,47,208,0,15,240,0,0,0,0,15,192,0,63,192,0,0,1,255,255,255,255,255,255,252,0,1,255,255,255,255,255,255,252,0,1,255,255,255,255,255,255,252,0,1,252,0,3,248,0,3,252,0,1,252,0,3,248,0,3,252,0,1,252,0,3,248,0,3,252,0,1,255,255,255,255,255,255,252,0,1,255,255,255,255,255,255,252,0,1,255,255,255,255,255,255,252,0,1,252,0,3,248,0,3,252,0,1,252,0,3,248,0,3,252,0,1,252,0,3,248,0,3,252,0,1,252,0,3,248,0,3,252,0,1,255,255,255,255,255,255,252,0,1,255,255,255,255,255,255,252,0,1,255,255,255,255,255,255,248,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,21,85,85,87,253,85,85,85,64,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x5361  卡
  97,83,34,36,68,38,2,252,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,245,85,85,80,0,0,0,0,11,255,255,255,240,0,0,0,0,11,255,255,255,240,0,0,0,0,11,255,255,255,240,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,95,249,85,85,85,80,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,246,64,0,0,0,0,0,0,11,255,249,0,0,0,0,0,0,11,255,255,224,0,0,0,0,0,11,251,255,255,64,0,0,0,0,11,240,111,255,248,0,0,0,0,11,240,1,255,252,0,0,0,0,11,240,0,11,248,0,0,0,0,11,240,0,0,176,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,
  // 0x5370  印
  112,83,31,36,32,38,4,252,0,0,6,0,0,0,0,0,0,0,127,128,0,0,0,0,0,7,255,224,0,0,0,0,0,191,255,145,255,255,255,252,255,255,248,1,255,255,255,252,255,255,64,1,255,255,255,252,255,208,0,1,254,85,87,252,254,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,254,85,85,65,253,0,2,252,255,255,255,209,253,0,2,252,255,255,255,209,253,0,2,252,255,255,255,209,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,253,0,0,1,253,0,2,252,254,85,85,65,253,0,2,252,255,255,255,225,253,10,171,252,255,255,255,225,253,7,255,248,255,255,255,225,253,3,255,244,253,0,0,1,253,2,255,128,253,0,0,1,253,0,0,0,253,0,0,1,253,0,0,0,0,0,0,1,253,0,0,0,0,0,0,1,253,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,168,0,0,0,
  // 0x5371  危
  113,83,36,36,68,38,1,252,0,0,6,80,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,255,255,255,0,0,0,0,0,255,255,255,255,208,0,0,0,2,255,255,255,255,192,0,0,0,7,253,0,0,255,64,0,0,0,15,244,0,2,254,0,0,0,0,63,224,0,3,252,0,0,0,0,255,255,255,255,255,255,255,248,7,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,127,255,192,0,0,0,0,0,0,47,239,192,0,0,0,0,0,0,15,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,191,255,255,255,240,0,0,47,192,191,255,255,255,240,0,0,47,192,191,255,255,255,224,0,0,47,128,190,0,0,15,224,0,0,63,128,190,0,0,15,224,0,0,63,128,190,0,0,15,224,0,0,63,64,190,0,0,15,208,0,0,63,64,190,0,0,31,208,0,0,127,0,190,0,0,47,192,0,0,191,0,190,0,127,255,192,0,0,255,0,190,0,63,255,64,0,0,253,0,190,0,63,249,0,208,2,252,0,190,0,0,0,0,253,3,252,0,190,0,0,0,0,252,11,244,0,190,0,0,0,1,252,15,240,0,191,64,0,0,7,252,63,208,0,127,255,255,255,255,244,127,192,0,63,255,255,255,255,240,31,0,0,11,255,255,255,255,128,4,0,0,0,0,0,0,0,0,
  // 0x5374  却
  116,83,34,36,68,38,1,252,0,0,190,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,21,85,85,80,0,0,191,0,0,127,255,255,240,0,0,191,0,0,127,255,255,240,0,0,191,0,0,127,255,255,240,15,255,255,255,240,127,0,11,240,15,255,255,255,240,127,0,11,240,15,255,255,255,240,127,0,11,240,0,0,191,0,0,127,0,11,240,0,0,191,0,0,127,0,11,240,0,0,191,0,0,127,0,11,240,0,0,191,0,0,127,0,11,240,0,0,191,0,0,127,0,11,240,0,0,191,0,0,127,0,11,240,127,255,255,255,252,127,0,11,240,127,255,255,255,252,127,0,11,240,127,255,255,255,252,127,0,11,240,21,95,245,85,84,127,0,11,240,0,15,240,0,0,127,0,11,240,0,15,224,0,0,127,0,11,240,0,31,208,0,0,127,0,11,240,0,63,192,124,0,127,0,11,240,0,63,128,254,0,127,0,11,240,0,127,0,127,0,127,0,11,240,0,191,0,63,128,127,0,11,240,0,253,0,31,208,127,15,255,224,1,252,0,31,240,127,7,255,224,3,254,255,255,240,127,3,255,128,127,255,255,255,248,127,2,164,0,127,255,255,255,252,127,0,0,0,63,254,148,0,253,127,0,0,0,16,0,0,0,253,127,0,0,0,0,0,0,0,80,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,
  // 0x5378  卸
  120,83,34,36,68,38,1,252,0,30,64,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,64,0,0,21,85,85,80,0,191,0,0,0,127,255,255,240,0,255,255,255,248,127,255,255,240,1,255,255,255,248,127,255,255,240,3,255,255,255,248,127,0,7,240,11,240,63,64,0,127,0,7,240,31,224,63,64,0,127,0,7,240,63,192,63,64,0,127,0,7,240,15,64,63,64,0,127,0,7,240,1,0,63,64,0,127,0,7,240,63,255,255,255,253,127,0,7,240,63,255,255,255,253,127,0,7,240,63,255,255,255,253,127,0,7,240,0,0,63,64,0,127,0,7,240,0,0,63,64,0,127,0,7,240,0,0,63,64,0,127,0,7,240,3,240,63,64,0,127,0,7,240,3,240,63,64,0,127,0,7,240,3,240,63,255,240,127,0,7,240,3,240,63,255,240,127,0,7,240,3,240,63,255,240,127,0,7,240,3,240,63,64,0,127,0,7,240,3,240,63,64,0,127,0,7,240,3,240,63,64,0,127,0,7,240,3,240,63,64,0,127,6,175,240,3,240,63,64,4,127,7,255,240,3,240,63,171,253,127,3,255,208,3,246,255,255,253,127,2,254,64,111,255,255,255,253,127,0,0,0,191,255,255,249,64,127,0,0,0,127,255,164,0,0,127,0,0,0,58,64,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,
  // 0x538b  压
  139,83,36,34,50,38,1,252,2,255,255,255,255,255,255,255,253,2,255,255,255,255,255,255,255,253,2,255,255,255,255,255,255,255,253,2,253,85,85,85,85,85,85,84,2,248,0,0,0,0,0,0,0,2,248,0,0,3,244,0,0,0,2,248,0,0,3,244,0,0,0,2,248,0,0,3,244,0,0,0,2,248,0,0,3,244,0,0,0,2,248,0,0,3,244,0,0,0,2,248,0,0,3,244,0,0,0,2,248,0,0,3,244,0,0,0,2,248,0,0,3,244,0,0,0,2,248,63,255,255,255,255,255,208,2,248,63,255,255,255,255,255,208,2,248,63,255,255,255,255,255,208,2,248,21,85,87,249,85,85,64,2,248,0,0,3,244,0,0,0,3,244,0,0,3,244,0,0,0,3,244,0,0,3,244,15,64,0,3,244,0,0,3,244,63,208,0,3,240,0,0,3,244,15,244,0,3,240,0,0,3,244,3,253,0,7,240,0,0,3,244,0,255,0,11,240,0,0,3,244,0,127,64,11,224,0,0,3,244,0,45,0,15,208,0,0,3,244,0,0,0,15,208,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,63,199,255,255,255,255,255,255,252,63,135,255,255,255,255,255,255,252,191,7,255,255,255,255,255,255,252,47,1,85,85,85,85,85,85,84,5,0,0,0,0,0,0,0,0,
  // 0x539f  原
  159,83,35,34,50,38,1,252,0,255,255,255,255,255,255,255,252,0,255,255,255,255,255,255,255,252,0,255,255,255,255,255,255,255,252,0,253,0,0,11,252,0,0,0,0,253,0,0,11,248,0,0,0,0,253,0,0,11,244,0,0,0,0,253,0,0,15,240,0,0,0,0,253,11,255,255,255,255,255,0,0,253,11,255,255,255,255,255,0,0,253,11,250,170,170,170,255,0,0,253,11,240,0,0,0,255,0,0,253,11,240,0,0,0,255,0,0,253,11,250,170,170,170,255,0,0,253,11,255,255,255,255,255,0,0,253,11,255,255,255,255,255,0,1,252,11,240,0,0,0,255,0,1,252,11,240,0,0,0,255,0,1,252,11,240,0,0,0,255,0,1,252,11,255,255,255,255,255,0,2,252,11,255,255,255,255,255,0,2,252,6,170,171,254,170,170,0,2,248,0,0,2,248,0,0,0,3,248,0,16,2,248,1,64,0,3,244,0,191,2,248,11,208,0,7,244,1,254,2,248,15,244,0,7,240,3,252,2,248,3,253,0,11,240,15,244,2,248,0,255,64,15,224,63,224,2,248,0,63,208,15,208,255,192,2,248,0,31,240,47,199,255,0,2,248,0,7,252,63,203,252,0,3,248,0,2,252,127,65,240,11,255,248,0,0,208,47,0,0,3,255,240,0,0,0,5,0,0,3,255,128,0,0,0,
  // 0x53cc  双
  204,83,34,33,41,38,2,252,127,255,255,248,127,255,255,255,128,127,255,255,252,127,255,255,255,192,127,255,255,252,127,255,255,255,128,21,85,86,252,47,213,85,127,128,0,0,2,252,47,192,0,63,64,0,0,3,248,31,192,0,127,0,0,0,3,248,15,208,0,127,0,6,0,3,244,15,208,0,191,0,47,64,7,240,15,224,0,254,0,63,208,11,240,11,240,0,253,0,31,240,15,240,7,240,1,252,0,7,252,15,224,3,244,3,252,0,2,254,31,208,3,248,3,248,0,0,255,111,192,2,252,7,244,0,0,63,255,192,1,252,15,240,0,0,31,255,64,0,254,31,224,0,0,15,255,0,0,191,47,192,0,0,3,255,0,0,127,127,192,0,0,2,255,0,0,63,255,64,0,0,3,255,128,0,47,255,0,0,0,7,255,208,0,15,253,0,0,0,15,255,240,0,15,252,0,0,0,31,239,248,0,31,252,0,0,0,63,195,252,0,63,254,0,0,0,191,130,254,0,255,255,0,0,1,255,0,254,3,255,191,192,0,3,253,0,184,15,252,63,240,0,15,252,0,16,127,244,15,252,0,63,240,0,2,255,208,7,255,64,255,192,0,31,255,64,1,255,224,255,64,0,15,252,0,0,127,224,61,0,0,7,224,0,0,15,192,20,0,0,2,0,0,0,2,0,
  // 0x53cd  反
  205,83,34,34,50,38,2,252,0,85,85,85,85,85,85,85,0,0,191,255,255,255,255,255,255,64,0,191,255,255,255,255,255,255,64,0,191,255,255,255,255,255,255,64,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,255,255,255,255,255,224,0,0,191,255,255,255,255,255,244,0,0,191,255,255,255,255,255,240,0,0,191,95,245,85,85,111,224,0,0,191,11,240,0,0,63,208,0,0,190,7,248,0,0,127,192,0,0,254,3,252,0,0,255,64,0,0,254,1,254,0,0,255,0,0,0,254,0,255,0,2,254,0,0,0,253,0,127,192,7,252,0,0,1,252,0,63,224,31,244,0,0,1,252,0,15,244,63,224,0,0,2,252,0,11,253,255,192,0,0,3,252,0,3,255,255,64,0,0,3,248,0,0,255,253,0,0,0,7,244,0,0,127,252,0,0,0,11,240,0,2,255,255,0,0,0,15,224,0,31,255,255,224,0,0,31,208,1,255,253,191,254,0,0,63,192,111,255,224,31,255,244,0,191,135,255,255,0,2,255,255,208,255,3,255,244,0,0,127,255,192,46,1,254,0,0,0,2,255,64,4,0,144,0,0,0,0,26,0,
  // 0x53d6  取
  214,83,36,34,50,38,1,252,21,85,85,85,84,0,0,0,0,63,255,255,255,254,0,0,0,0,63,255,255,255,254,0,0,0,0,63,255,255,255,255,170,170,170,144,1,252,0,31,199,255,255,255,244,1,252,0,31,199,255,255,255,240,1,252,0,31,199,255,255,255,240,1,252,0,31,194,180,0,11,240,1,255,255,255,195,252,0,15,240,1,255,255,255,193,252,0,15,224,1,255,255,255,192,253,0,31,208,1,252,0,47,192,254,0,31,192,1,252,0,31,192,191,0,47,192,1,252,0,31,192,127,0,63,128,1,252,0,31,192,63,64,127,64,1,252,0,31,192,63,192,191,0,1,255,255,255,192,47,192,254,0,1,255,255,255,192,15,225,253,0,1,255,255,255,192,15,243,252,0,1,253,0,47,192,7,255,248,0,1,252,0,31,192,3,255,240,0,1,252,0,31,192,2,255,224,0,1,252,0,31,192,0,255,192,0,1,252,0,111,192,0,255,192,0,1,254,191,255,192,1,255,224,0,175,255,255,255,192,7,255,244,0,191,255,255,255,192,15,255,252,0,191,255,229,31,192,127,243,255,0,126,144,0,31,193,255,192,255,208,0,0,0,31,203,255,0,63,248,0,0,0,31,255,252,0,31,254,0,0,0,31,207,224,0,3,252,0,0,0,31,199,64,0,0,180,0,0,0,31,192,0,0,0,0,
  // 0x53d8  变
  216,83,34,37,77,38,2,251,0,0,0,6,240,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,1,254,0,0,0,0,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,0,0,7,244,1,252,0,0,0,0,4,3,244,1,252,0,0,0,0,31,195,244,1,252,45,0,0,0,63,131,244,1,252,255,64,0,0,191,3,244,1,252,63,208,0,0,254,3,244,1,252,15,244,0,3,252,3,244,1,252,3,252,0,11,244,3,244,1,252,0,255,0,47,224,3,244,1,252,0,127,128,15,192,3,244,1,252,0,47,0,2,0,3,244,1,252,0,8,0,0,0,3,244,1,252,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,255,64,0,3,255,255,255,255,255,255,208,0,3,255,255,255,255,255,255,128,0,0,11,244,0,0,1,255,0,0,0,2,253,0,0,7,253,0,0,0,0,255,128,0,31,244,0,0,0,0,63,240,0,191,208,0,0,0,0,11,254,7,255,0,0,0,0,0,1,255,255,248,0,0,0,0,0,0,127,255,208,0,0,0,0,0,6,255,255,248,0,0,0,0,1,191,255,255,255,228,0,0,26,255,255,253,11,255,255,249,64,191,255,255,128,0,111,255,255,240,63,255,144,0,0,1,175,255,192,46,64,0,0,0,0,0,91,64,0,0,0,0,0,0,0,0,0,
  // 0x53f0  台
  240,83,34,36,68,38,2,252,0,0,0,228,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,0,0,64,0,0,0,0,31,240,0,11,208,0,0,0,0,63,208,0,31,244,0,0,0,0,191,192,0,11,254,0,0,0,0,255,0,0,2,255,128,0,0,2,254,0,0,0,191,224,0,0,7,252,0,0,0,63,244,0,106,175,254,255,255,255,255,253,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,192,127,255,254,170,149,84,0,63,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,11,128,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,149,85,85,85,111,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,149,85,85,85,111,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,64,0,0,0,47,192,0,0,42,64,0,0,0,26,128,0,
  // 0x5403  吃
  3,84,34,36,68,38,3,252,0,0,0,0,57,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,255,0,0,0,0,85,85,80,0,254,0,0,0,0,255,255,244,2,252,0,0,0,0,255,255,244,3,253,85,85,85,0,255,255,244,11,255,255,255,255,192,252,3,244,15,255,255,255,255,192,252,3,244,47,255,255,255,255,192,252,3,244,127,192,0,0,0,0,252,3,244,255,64,0,0,0,0,252,3,246,254,0,0,0,0,0,252,3,255,252,0,0,0,0,0,252,3,245,244,0,0,0,0,0,252,3,244,99,255,255,255,240,0,252,3,244,3,255,255,255,252,0,252,3,244,3,255,255,255,240,0,252,3,244,1,85,87,255,128,0,252,3,244,0,0,11,254,0,0,252,3,244,0,0,63,244,0,0,252,3,244,0,0,255,208,0,0,252,3,244,0,3,255,0,0,0,252,3,244,0,15,252,0,0,0,255,255,244,0,63,240,0,0,0,255,255,244,0,255,128,0,0,0,255,255,244,3,254,0,0,0,0,254,85,80,11,248,0,0,5,0,252,0,0,31,224,0,0,11,208,252,0,0,63,192,0,0,11,224,168,0,0,127,64,0,0,11,208,0,0,0,191,0,0,0,15,208,0,0,0,191,128,0,0,31,192,0,0,0,127,255,255,255,255,192,0,0,0,63,255,255,255,255,64,0,0,0,11,255,255,255,254,0,0,0,0,0,21,85,85,80,0,
  // 0x5408  合
  8,84,36,36,68,38,1,252,0,0,0,1,254,0,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,11,255,208,0,0,0,0,0,0,31,255,244,0,0,0,0,0,0,127,219,252,0,0,0,0,0,1,255,131,255,0,0,0,0,0,3,255,0,255,208,0,0,0,0,15,252,0,63,244,0,0,0,0,127,240,0,15,254,0,0,0,1,255,192,0,3,255,192,0,0,11,255,0,0,0,255,244,0,0,63,252,0,0,0,47,254,0,2,255,240,0,0,0,11,255,224,31,254,191,255,255,255,254,191,253,127,244,127,255,255,255,253,31,253,63,192,127,255,255,255,253,2,248,13,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,240,0,0,0,15,240,0,0,7,224,0,0,0,11,224,0,
  // 0x540d  名
  13,84,33,36,68,38,1,252,0,0,0,122,64,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,15,255,255,255,248,0,0,0,0,63,255,255,255,254,0,0,0,0,255,255,255,255,252,0,0,0,3,255,64,0,7,248,0,0,0,15,252,0,0,15,240,0,0,0,127,244,0,0,47,224,0,0,2,255,253,0,0,63,192,0,0,31,255,255,128,0,255,64,0,0,127,248,255,224,2,255,0,0,0,47,208,47,252,11,252,0,0,0,11,0,11,255,31,244,0,0,0,0,0,1,255,255,208,0,0,0,0,0,0,127,255,128,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,1,255,255,255,255,255,128,0,0,11,255,255,255,255,255,128,0,0,191,255,255,255,255,255,128,0,11,255,252,0,0,0,63,128,0,191,255,248,0,0,0,63,128,31,255,247,248,0,0,0,63,128,127,255,67,248,0,0,0,63,128,47,248,3,248,0,0,0,63,128,14,64,3,248,0,0,0,63,128,0,0,3,248,0,0,0,63,128,0,0,3,248,0,0,0,63,128,0,0,3,248,0,0,0,63,128,0,0,3,255,255,255,255,255,128,0,0,3,255,255,255,255,255,128,0,0,3,255,255,255,255,255,128,0,0,3,252,0,0,0,63,128,0,0,2,248,0,0,0,63,128,
  // 0x540e  后
  14,84,36,36,68,38,1,252,0,0,0,0,0,0,0,80,0,0,0,0,0,0,1,111,248,0,0,0,0,0,90,255,255,254,0,0,121,106,255,255,255,255,250,0,0,127,255,255,255,255,249,0,0,0,127,255,255,254,148,0,0,0,0,127,250,80,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,127,149,85,85,85,85,85,84,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,3,255,255,255,255,255,64,0,191,3,255,255,255,255,255,64,0,254,3,255,255,255,255,255,64,0,254,3,249,85,85,85,127,64,0,253,3,244,0,0,0,127,64,1,253,3,244,0,0,0,127,64,2,252,3,244,0,0,0,127,64,3,252,3,244,0,0,0,127,64,3,248,3,244,0,0,0,127,64,7,244,3,244,0,0,0,127,64,11,240,3,244,0,0,0,127,64,15,240,3,249,85,85,85,127,64,47,208,3,255,255,255,255,255,64,63,192,3,255,255,255,255,255,64,127,64,3,255,255,255,255,255,64,31,0,3,244,0,0,0,127,64,5,0,3,244,0,0,0,63,0,
  // 0x5411  向
  17,84,32,36,32,38,3,252,0,0,0,62,64,0,0,0,0,0,0,63,208,0,0,0,0,0,0,127,192,0,0,0,0,0,0,255,128,0,0,0,0,0,0,255,0,0,0,0,0,0,2,254,0,0,0,0,21,85,87,254,85,85,85,84,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,0,0,0,0,0,0,253,127,0,0,0,0,0,0,253,127,0,0,0,0,0,0,253,127,0,0,0,0,0,0,253,127,0,0,0,0,0,0,253,127,0,127,255,255,253,0,253,127,0,127,255,255,253,0,253,127,0,127,255,255,253,0,253,127,0,127,0,0,253,0,253,127,0,127,0,0,253,0,253,127,0,127,0,0,253,0,253,127,0,127,0,0,253,0,253,127,0,127,0,0,253,0,253,127,0,127,0,0,253,0,253,127,0,127,0,0,253,0,253,127,0,127,255,255,253,0,253,127,0,127,255,255,253,0,253,127,0,127,255,255,253,0,253,127,0,127,0,0,0,0,253,127,0,127,0,0,0,0,253,127,0,106,0,0,0,0,253,127,0,0,0,0,0,0,253,127,0,0,0,0,26,170,253,127,0,0,0,0,31,255,252,127,0,0,0,0,15,255,248,127,0,0,0,0,15,255,144,
  // 0x5426  否
  38,84,35,34,50,38,1,252,31,255,255,255,255,255,255,255,244,31,255,255,255,255,255,255,255,244,31,255,255,255,255,255,255,255,244,5,85,85,85,127,245,85,85,80,0,0,0,0,255,208,0,0,0,0,0,0,3,255,64,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,191,254,7,208,0,0,0,0,3,255,254,31,253,0,0,0,0,47,255,254,31,255,192,0,0,2,255,248,254,1,255,248,0,0,47,255,192,254,0,31,255,64,7,255,254,0,254,0,2,255,240,127,255,224,0,254,0,0,127,252,63,254,0,0,254,0,0,11,248,15,224,0,0,254,0,0,1,224,6,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,255,255,255,255,255,248,0,0,31,255,255,255,255,255,248,0,0,31,255,255,255,255,255,248,0,0,31,208,0,0,0,7,248,0,0,31,208,0,0,0,3,248,0,0,31,208,0,0,0,3,248,0,0,31,208,0,0,0,3,248,0,0,31,208,0,0,0,3,248,0,0,31,208,0,0,0,3,248,0,0,31,208,0,0,0,3,248,0,0,31,255,255,255,255,255,248,0,0,31,255,255,255,255,255,248,0,0,31,255,255,255,255,255,248,0,0,31,208,0,0,0,7,248,0,0,31,192,0,0,0,3,248,0,
  // 0x542f  启
  47,84,32,36,32,38,2,252,0,0,0,0,0,0,26,0,0,0,0,0,1,107,255,192,0,0,1,106,255,255,255,240,2,175,255,255,255,255,249,0,2,255,255,255,255,164,0,0,2,255,254,149,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,255,255,255,255,255,255,252,2,255,255,255,255,255,255,252,2,255,255,255,255,255,255,252,2,252,0,0,0,0,1,252,2,252,0,0,0,0,1,252,2,252,0,0,0,0,1,252,2,252,0,0,0,0,1,252,2,252,0,0,0,0,1,252,2,255,255,255,255,255,255,252,2,255,255,255,255,255,255,252,2,255,255,255,255,255,255,252,3,252,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,244,255,255,255,255,255,254,3,244,255,255,255,255,255,254,7,240,255,255,255,255,255,254,11,240,254,0,0,0,0,254,15,240,254,0,0,0,0,254,15,224,254,0,0,0,0,254,31,208,254,0,0,0,0,254,63,192,254,0,0,0,0,254,63,128,254,0,0,0,0,254,191,64,255,255,255,255,255,254,255,0,255,255,255,255,255,254,189,0,255,255,255,255,255,254,44,0,254,0,0,0,0,254,0,0,169,0,0,0,0,169,
  // 0x544a  告
  74,84,34,37,77,38,2,251,0,1,0,0,190,0,0,0,0,0,7,244,0,255,0,0,0,0,0,11,240,0,255,0,0,0,0,0,15,240,0,255,0,0,0,0,0,31,208,0,255,0,0,0,0,0,63,208,0,255,0,0,0,0,0,127,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,2,255,255,255,255,255,255,252,0,7,252,0,0,255,0,0,0,0,31,240,0,0,255,0,0,0,0,63,208,0,0,255,0,0,0,0,11,128,0,0,255,0,0,0,0,1,0,0,0,255,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,21,85,85,85,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,149,85,85,85,95,224,0,0,63,128,0,0,0,15,224,0,0,63,128,0,0,0,15,224,0,0,63,128,0,0,0,15,224,0,0,63,128,0,0,0,15,224,0,0,63,128,0,0,0,15,224,0,0,63,149,85,85,85,95,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,128,0,0,0,15,224,0,0,63,128,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,
  // 0x5468  周
  104,84,33,35,59,38,1,251,0,191,255,255,255,255,255,255,128,0,191,255,255,255,255,255,255,128,0,191,255,255,255,255,255,255,128,0,191,85,85,85,85,85,127,128,0,191,0,0,191,0,0,63,128,0,191,0,0,191,0,0,63,128,0,191,0,0,191,0,0,63,128,0,191,15,255,255,255,244,63,128,0,191,15,255,255,255,244,63,128,0,191,11,255,255,255,244,63,128,0,191,0,0,191,0,0,63,128,0,191,0,0,191,0,0,63,128,0,191,0,0,191,0,0,63,128,0,191,47,255,255,255,252,63,128,0,191,47,255,255,255,253,63,128,0,191,47,255,255,255,253,63,128,0,191,0,0,0,0,0,63,128,0,191,0,0,0,0,0,63,128,0,254,0,0,0,0,0,63,128,0,254,3,255,255,255,224,63,128,0,253,3,255,255,255,224,63,128,0,253,3,254,170,175,224,63,128,1,252,3,240,0,11,224,63,128,1,252,3,240,0,11,224,63,128,2,252,3,240,0,11,224,63,128,3,248,3,240,0,11,224,63,128,7,244,3,255,255,255,224,63,128,11,240,3,255,255,255,224,63,128,15,240,3,255,255,255,224,63,128,31,224,3,240,0,0,0,63,128,63,192,3,240,0,0,0,127,128,127,128,1,80,0,2,255,255,64,63,0,0,0,0,1,255,255,0,10,0,0,0,0,0,255,248,0,0,0,0,0,0,0,0,0,0,
  // 0x547d  命
  125,84,36,37,77,38,1,251,0,0,0,2,255,0,0,0,0,0,0,0,7,255,192,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,63,255,248,0,0,0,0,0,1,255,199,255,0,0,0,0,0,7,255,1,255,192,0,0,0,0,31,252,0,127,244,0,0,0,0,191,240,0,15,254,0,0,0,7,255,128,0,3,255,208,0,0,47,254,0,0,0,191,248,0,1,255,255,255,255,255,255,255,128,31,255,139,255,255,255,226,255,248,255,253,11,255,255,255,224,127,255,127,224,0,0,0,0,0,7,252,46,0,0,0,0,0,0,0,116,0,0,0,0,0,0,0,0,0,0,255,255,255,3,255,255,255,64,0,255,255,255,3,255,255,255,64,0,255,255,255,3,255,255,255,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,253,0,63,3,244,0,63,64,0,255,255,255,3,244,0,63,64,0,255,255,255,3,244,0,127,64,0,255,255,255,3,244,127,255,0,0,253,0,0,3,244,63,255,0,0,253,0,0,3,244,63,248,0,0,253,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x548c  和
  140,84,34,36,68,38,1,252,0,0,0,5,0,0,0,0,0,0,0,1,191,0,0,0,0,0,0,5,191,255,192,0,0,0,0,26,255,255,255,129,85,85,85,64,31,255,255,144,3,255,255,255,208,15,254,254,0,3,255,255,255,208,4,0,254,0,3,255,255,255,208,0,0,254,0,3,244,0,15,208,0,0,254,0,3,244,0,15,208,0,0,254,0,3,244,0,15,208,0,0,254,0,3,244,0,15,208,21,85,254,85,67,244,0,15,208,63,255,255,255,227,244,0,15,208,63,255,255,255,227,244,0,15,208,63,255,255,255,227,244,0,15,208,0,3,254,0,3,244,0,15,208,0,7,255,0,3,244,0,15,208,0,15,255,192,3,244,0,15,208,0,15,255,240,3,244,0,15,208,0,47,255,252,3,244,0,15,208,0,63,254,254,3,244,0,15,208,0,189,254,127,67,244,0,15,208,1,252,254,47,211,244,0,15,208,3,248,254,15,211,244,0,15,208,11,240,254,7,131,244,0,15,208,31,224,254,2,3,244,0,15,208,63,192,254,0,3,244,0,15,208,191,64,254,0,3,249,85,111,208,126,0,254,0,3,255,255,255,208,44,0,254,0,3,255,255,255,208,0,0,254,0,3,255,255,255,208,0,0,254,0,3,244,0,15,208,0,0,254,0,3,244,0,15,208,0,0,254,0,3,244,0,15,208,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,
  // 0x54cd  响
  205,84,33,37,77,38,3,251,0,0,0,0,0,164,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,255,0,0,0,85,85,64,0,2,253,0,0,0,255,255,224,0,3,252,0,0,0,255,255,224,0,7,248,0,0,0,255,255,224,0,11,240,0,0,0,252,7,224,255,255,255,255,255,64,252,7,224,255,255,255,255,255,64,252,7,224,255,255,255,255,255,64,252,7,224,253,0,0,0,63,64,252,7,224,253,0,0,0,63,64,252,7,224,253,0,0,0,63,64,252,7,224,253,6,170,160,63,64,252,7,224,253,15,255,244,63,64,252,7,224,253,15,255,244,63,64,252,7,224,253,15,128,244,63,64,252,7,224,253,15,128,244,63,64,252,7,224,253,15,128,244,63,64,252,7,224,253,15,128,244,63,64,252,7,224,253,15,128,244,63,64,252,7,224,253,15,128,244,63,64,253,87,224,253,15,128,244,63,64,255,255,224,253,15,128,244,63,64,255,255,224,253,15,255,244,63,64,255,255,224,253,15,255,244,63,64,252,0,0,253,15,234,164,63,64,252,0,0,253,15,128,0,63,64,252,0,0,253,15,64,0,63,64,168,0,0,253,0,0,0,63,64,0,0,0,253,0,0,0,63,64,0,0,0,253,0,0,0,63,64,0,0,0,253,0,0,0,63,64,0,0,0,253,0,0,63,255,64,0,0,0,253,0,0,31,255,0,0,0,0,253,0,0,15,248,0,0,0,0,0,0,0,0,0,0,
  // 0x55b7  喷
  183,85,35,36,68,38,2,252,0,0,0,0,0,42,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,21,85,64,127,255,255,255,255,128,127,255,224,191,255,255,255,255,128,127,255,224,191,255,255,255,255,128,127,255,224,0,0,63,0,0,0,125,3,224,0,0,63,0,0,0,125,3,224,3,244,63,7,240,0,125,3,224,3,244,0,7,240,0,125,3,227,255,255,255,255,255,240,125,3,227,255,255,255,255,255,240,125,3,227,255,255,255,255,255,240,125,3,224,3,244,0,7,240,0,125,3,224,3,244,0,7,240,0,125,3,224,0,80,0,1,64,0,125,3,224,31,255,255,255,254,0,125,3,224,31,255,255,255,254,0,125,3,224,31,255,255,255,254,0,125,3,224,31,128,0,0,190,0,125,3,224,31,128,0,0,190,0,125,3,224,31,128,0,0,190,0,126,87,224,31,128,63,0,190,0,127,255,224,31,128,63,0,190,0,127,255,224,31,128,63,0,190,0,127,255,224,31,128,63,0,190,0,125,0,0,31,128,127,0,190,0,125,0,0,31,128,127,0,190,0,125,0,0,31,128,254,0,190,0,41,0,0,5,2,252,56,0,0,0,0,0,0,15,248,255,144,0,0,0,0,1,191,224,47,253,0,0,0,0,111,255,64,2,255,208,0,0,31,255,244,0,0,63,248,0,0,11,254,64,0,0,7,240,0,0,2,64,0,0,0,0,96,
  // 0x5634  嘴
  52,86,34,37,77,38,3,251,0,0,0,2,224,11,208,0,0,0,0,0,3,240,11,208,0,0,0,0,0,3,240,11,208,24,0,255,255,131,195,240,11,209,255,0,255,255,131,195,250,155,239,253,0,255,255,131,195,255,235,255,208,0,248,31,131,195,255,235,253,0,0,244,15,131,195,240,11,224,0,0,244,15,131,195,240,11,208,1,0,244,15,131,195,240,11,208,3,208,244,15,131,195,251,235,208,7,208,244,15,155,255,255,247,250,175,192,244,15,191,255,255,147,255,255,128,244,15,191,255,252,1,255,254,0,244,15,153,3,253,85,64,0,0,244,15,128,11,255,255,224,0,0,244,15,128,47,255,255,240,0,0,244,15,128,191,64,31,192,0,0,244,15,130,255,85,127,149,84,0,244,15,159,255,255,255,255,253,0,244,15,255,255,255,255,255,253,0,255,255,159,254,0,252,0,253,0,255,255,128,190,0,252,0,253,0,255,255,128,191,255,255,255,253,0,248,0,0,191,255,255,255,253,0,244,0,0,190,0,252,0,253,0,244,0,0,253,0,252,0,253,0,244,0,0,253,0,252,0,253,0,0,0,0,255,255,255,255,253,0,0,0,2,255,255,255,255,253,0,0,0,3,249,85,85,85,253,0,0,0,11,240,0,0,0,253,0,0,0,47,224,0,0,0,253,0,0,0,191,192,0,1,170,253,0,0,0,255,0,0,1,255,252,0,0,0,44,0,0,0,255,224,0,0,0,0,0,0,0,0,0,0,
  // 0x5668  器
  104,86,36,35,59,38,1,251,1,255,255,255,0,255,255,255,64,1,255,255,255,0,255,255,255,64,1,255,255,255,0,255,255,255,64,1,252,0,127,0,252,0,63,64,1,252,0,127,0,252,0,63,64,1,252,0,127,0,252,0,63,64,1,252,0,127,0,252,0,63,64,1,252,0,127,0,252,0,63,64,1,255,255,255,0,255,255,255,64,1,255,255,255,64,255,255,255,64,1,255,255,255,248,255,255,255,64,0,0,0,7,252,0,0,0,0,0,0,0,15,240,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,31,252,0,63,224,0,0,0,0,191,240,0,15,252,0,0,0,3,255,192,0,3,255,64,0,0,47,254,0,0,0,255,240,0,6,255,244,0,0,0,47,255,64,127,255,255,255,65,255,255,255,249,191,255,255,255,65,255,255,255,254,63,255,255,255,65,255,255,255,252,30,253,0,63,65,248,0,127,112,0,253,0,63,65,248,0,127,0,0,253,0,63,65,248,0,127,0,0,253,0,63,65,248,0,127,0,0,253,0,63,65,248,0,127,0,0,253,0,63,65,248,0,127,0,0,255,255,255,65,255,255,255,0,0,255,255,255,65,255,255,255,0,0,255,255,255,65,255,255,255,0,0,253,0,63,65,248,0,127,0,0,0,0,0,0,0,0,0,0,
  // 0x5674  噴
  116,86,34,37,77,38,3,251,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,1,255,255,255,255,255,0,255,255,225,255,255,255,255,255,0,255,255,224,85,85,254,85,85,0,255,255,224,6,144,253,10,128,0,252,11,224,11,208,253,15,192,0,252,11,224,11,208,0,15,192,0,252,11,239,255,255,255,255,255,208,252,11,239,255,255,255,255,255,208,252,11,229,95,229,85,111,213,64,252,11,224,11,208,0,15,192,0,252,11,224,5,64,0,5,64,0,252,11,224,191,255,255,255,252,0,252,11,224,191,255,255,255,252,0,252,11,224,190,0,0,1,252,0,252,11,224,190,0,0,1,252,0,252,11,224,190,0,0,1,252,0,252,11,224,191,255,255,255,252,0,252,11,224,191,255,255,255,252,0,252,11,224,190,0,0,1,252,0,255,255,224,190,0,0,1,252,0,255,255,224,191,255,255,255,252,0,255,255,224,191,255,255,255,252,0,252,0,0,190,0,0,1,252,0,252,0,0,190,0,0,1,252,0,252,0,0,190,0,0,1,252,0,84,0,0,191,255,255,255,252,0,0,0,0,191,255,255,255,252,0,0,0,0,2,228,0,125,0,0,0,0,0,47,252,1,255,208,0,0,0,6,255,224,0,47,253,0,0,0,191,255,0,0,3,255,128,0,0,127,224,0,0,0,127,192,0,0,29,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,
  // 0x56de  回
  222,86,32,35,24,38,3,252,170,170,170,170,170,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,191,255,255,253,0,255,255,0,191,255,255,253,0,255,255,0,191,255,255,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,190,0,0,253,0,255,255,0,191,0,0,253,0,255,255,0,191,255,255,253,0,255,255,0,191,255,255,253,0,255,255,0,191,255,255,253,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,255,85,85,85,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,255,255,0,0,0,0,0,0,255,
  // 0x56e0  因
  224,86,32,34,16,38,3,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,85,85,255,254,0,0,5,64,0,0,191,254,0,0,15,208,0,0,191,254,0,0,15,208,0,0,191,254,0,0,15,208,0,0,191,254,0,0,15,208,0,0,191,254,0,0,15,208,0,0,191,254,47,255,255,255,255,248,191,254,47,255,255,255,255,248,191,254,47,255,255,255,255,248,191,254,0,0,47,244,0,0,191,254,0,0,63,244,0,0,191,254,0,0,63,252,0,0,191,254,0,0,127,252,0,0,191,254,0,0,255,190,0,0,191,254,0,1,253,63,64,0,191,254,0,3,252,63,192,0,191,254,0,11,248,31,224,0,191,254,0,47,240,11,252,0,191,254,0,191,208,3,255,64,191,254,7,255,64,0,255,224,191,254,63,252,0,0,63,248,191,254,15,224,0,0,11,224,191,254,7,0,0,0,1,192,191,254,0,0,0,0,0,0,191,255,85,85,85,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,0,0,0,0,0,0,191,190,0,0,0,0,0,0,190,
  // 0x56fa  固
  250,86,32,35,24,38,3,251,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,85,85,85,85,85,85,255,191,0,0,0,0,0,0,255,191,0,0,11,224,0,0,255,191,0,0,11,224,0,0,255,191,0,0,11,224,0,0,255,191,0,0,11,224,0,0,255,191,15,255,255,255,255,244,255,191,15,255,255,255,255,244,255,191,15,255,255,255,255,240,255,191,0,0,11,224,0,0,255,191,0,0,11,224,0,0,255,191,0,0,11,224,0,0,255,191,0,170,175,250,170,0,255,191,0,255,255,255,255,0,255,191,0,255,255,255,255,0,255,191,0,252,0,0,63,0,255,191,0,252,0,0,63,0,255,191,0,252,0,0,63,0,255,191,0,252,0,0,63,0,255,191,0,252,0,0,63,0,255,191,0,255,255,255,255,0,255,191,0,255,255,255,255,0,255,191,0,170,170,170,170,0,255,191,0,0,0,0,0,0,255,191,0,0,0,0,0,0,255,191,0,0,0,0,0,0,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,85,85,85,85,85,85,255,191,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,
  // 0x56fe  图
  254,86,32,34,16,38,3,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,0,0,80,0,0,0,191,254,0,0,252,0,0,0,191,254,0,3,248,0,0,0,191,254,0,15,254,170,170,64,191,254,0,63,255,255,255,208,191,254,0,255,255,255,255,192,191,254,7,255,64,0,191,0,191,254,47,255,208,3,252,0,191,254,63,199,248,47,240,0,191,254,14,1,255,255,128,0,191,254,0,0,63,254,0,0,191,254,0,2,255,255,144,0,191,254,0,127,255,255,254,64,191,254,111,255,244,11,255,254,191,254,255,255,64,0,191,253,191,254,63,224,249,0,2,248,191,254,36,2,255,248,0,0,191,254,0,0,111,255,192,0,191,254,0,0,0,191,192,0,191,254,0,20,0,6,64,0,191,254,0,191,250,64,0,0,191,254,1,255,255,254,64,0,191,254,0,5,191,255,254,0,191,254,0,0,1,191,255,0,191,254,0,0,0,1,188,0,191,254,0,0,0,0,0,0,191,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,0,0,0,0,0,0,191,189,0,0,0,0,0,0,190,
  // 0x5728  在
  40,87,35,36,68,38,1,252,0,0,0,25,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,5,85,95,245,85,85,85,85,80,0,0,31,224,0,0,0,0,0,0,0,63,192,0,31,192,0,0,0,0,191,64,0,47,192,0,0,0,1,255,0,0,47,192,0,0,0,3,253,0,0,47,192,0,0,0,11,248,0,0,47,192,0,0,0,47,240,0,0,47,192,0,0,0,191,224,0,0,47,192,0,0,1,255,224,47,255,255,255,255,192,11,255,224,47,255,255,255,255,192,63,255,224,47,255,255,255,255,192,127,239,224,5,85,111,213,85,64,63,79,224,0,0,47,192,0,0,29,15,224,0,0,47,192,0,0,4,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,85,85,111,213,85,80,0,15,224,255,255,255,255,255,248,0,15,224,255,255,255,255,255,248,0,15,224,255,255,255,255,255,248,0,15,224,0,0,0,0,0,0,
  // 0x574f  坏
  79,87,36,35,59,38,1,252,0,47,128,0,0,0,0,0,0,0,47,128,21,85,85,85,85,84,0,47,128,191,255,255,255,255,253,0,47,128,191,255,255,255,255,253,0,47,128,191,255,255,255,255,253,0,47,128,0,0,2,253,0,0,0,47,128,0,0,3,252,0,0,0,47,128,0,0,15,244,0,0,21,111,213,0,0,31,240,0,0,63,255,255,128,0,63,192,0,0,63,255,255,128,0,255,192,0,0,63,255,255,128,3,255,203,0,0,0,47,128,0,11,255,239,208,0,0,47,128,0,47,255,239,244,0,0,47,128,0,255,255,203,254,0,0,47,128,3,255,95,193,255,128,0,47,128,31,253,31,192,127,240,0,47,128,255,244,31,192,15,252,0,47,131,255,192,31,192,3,254,0,47,128,254,0,31,192,0,252,0,47,128,52,0,31,192,0,48,0,47,129,128,0,31,192,0,0,0,47,239,192,0,31,192,0,0,0,47,255,208,0,31,192,0,0,1,255,255,208,0,31,192,0,0,127,255,253,0,0,31,192,0,0,127,255,128,0,0,31,192,0,0,63,228,0,0,0,31,192,0,0,61,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,
  // 0x5757  块
  87,87,35,36,68,38,1,252,0,21,64,0,0,21,0,0,0,0,47,128,0,0,127,0,0,0,0,47,128,0,0,127,0,0,0,0,47,128,0,0,127,0,0,0,0,47,128,0,0,127,0,0,0,0,47,128,0,0,127,0,0,0,0,47,128,1,85,191,85,85,0,0,47,128,11,255,255,255,255,64,0,47,128,11,255,255,255,255,64,63,255,255,139,255,255,255,255,64,63,255,255,128,0,127,0,63,64,63,255,255,128,0,127,0,63,64,21,127,213,0,0,127,0,63,64,0,47,128,0,0,127,0,63,64,0,47,128,0,0,127,0,63,64,0,47,128,0,0,127,0,63,64,0,47,128,0,0,191,0,63,64,0,47,128,21,85,191,85,127,148,0,47,128,63,255,255,255,255,252,0,47,128,63,255,255,255,255,252,0,47,128,63,255,255,255,255,252,0,47,135,128,0,255,240,0,0,0,47,255,192,2,255,244,0,0,0,47,255,192,3,254,252,0,0,1,255,255,64,7,244,253,0,0,47,255,244,0,15,240,255,0,0,127,255,64,0,31,240,127,128,0,63,244,0,0,63,192,63,192,0,46,64,0,0,255,128,31,240,0,0,0,0,3,255,0,11,252,0,0,0,0,15,253,0,3,255,0,0,0,0,127,244,0,0,255,208,0,0,3,255,208,0,0,127,252,0,0,15,255,0,0,0,31,252,0,0,3,248,0,0,0,3,240,0,0,0,128,0,0,0,0,80,
  // 0x578b  型
  139,87,34,35,59,38,2,253,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,127,0,15,255,255,255,252,5,64,127,0,15,255,255,255,252,31,192,127,0,15,255,255,255,252,31,192,127,0,0,63,64,190,0,31,192,127,0,0,63,64,190,0,31,192,127,0,0,63,64,190,0,31,192,127,0,0,63,64,190,0,31,192,127,0,0,63,64,191,0,31,192,127,0,127,255,255,255,254,31,192,127,0,127,255,255,255,254,31,192,127,0,127,255,255,255,254,31,192,127,0,0,127,0,190,0,31,192,127,0,0,191,0,190,0,31,192,127,0,0,253,0,190,0,5,64,127,0,3,252,0,190,0,0,0,127,0,11,248,0,190,0,0,0,127,0,63,240,0,190,0,0,255,255,0,191,192,0,190,0,0,255,254,0,47,0,0,107,252,0,191,248,0,4,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,85,85,85,85,85,80,
  // 0x57ab  垫
  171,87,35,35,59,38,2,253,0,15,192,0,1,248,0,0,0,0,15,192,0,2,252,0,0,0,0,15,192,0,2,248,0,0,0,0,15,192,0,2,248,0,0,0,191,255,255,215,255,255,255,244,0,191,255,255,215,255,255,255,244,0,191,255,255,215,255,255,255,244,0,0,31,208,0,3,244,3,244,0,0,15,192,0,3,244,3,240,0,0,15,192,1,211,240,3,240,0,0,15,219,227,255,240,3,240,0,1,111,255,247,255,240,3,240,0,191,255,255,240,191,240,3,240,0,255,255,249,0,31,253,3,240,0,191,255,192,0,47,255,131,240,0,100,15,192,0,63,255,243,244,64,0,15,192,0,255,15,242,244,184,0,15,192,3,253,2,193,248,252,0,31,192,31,248,0,0,252,248,31,255,192,63,224,0,0,255,244,15,255,128,31,128,0,0,127,240,11,254,0,7,248,0,0,31,192,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,1,255,255,255,255,255,255,244,0,1,255,255,255,255,255,255,244,0,1,255,255,255,255,255,255,244,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x586b  填
  107,88,36,36,68,38,1,252,0,5,0,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,191,255,255,255,255,252,0,63,64,255,255,255,255,255,252,0,63,64,255,255,255,255,255,252,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,31,208,0,0,21,127,149,3,255,255,255,255,0,63,255,255,3,255,255,255,255,0,63,255,255,3,244,0,0,63,0,63,255,255,3,244,0,0,127,0,0,63,64,3,255,255,255,255,0,0,63,64,3,255,255,255,255,0,0,63,64,3,244,0,0,63,0,0,63,64,3,244,0,0,63,0,0,63,64,3,255,255,255,255,0,0,63,64,3,255,255,255,255,0,0,63,64,3,244,0,0,127,0,0,63,64,3,244,0,0,63,0,0,63,64,3,245,85,85,127,0,0,63,75,131,255,255,255,255,0,0,63,255,195,255,255,255,255,0,0,127,255,192,0,0,0,0,0,11,255,253,0,0,0,0,0,0,127,255,211,255,255,255,255,255,253,127,253,3,255,255,255,255,255,253,63,128,3,255,255,255,255,255,253,24,0,0,0,30,0,3,128,0,0,0,0,0,191,192,31,244,0,0,0,0,7,255,0,11,255,0,0,0,0,191,248,0,0,255,208,0,0,11,255,208,0,0,47,248,0,0,3,254,0,0,0,7,253,0,0,0,160,0,0,0,0,144,
  // 0x58f3  壳
  243,88,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,106,170,170,171,254,170,170,170,144,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,1,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,248,0,1,170,170,170,170,170,170,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,234,170,170,170,170,170,191,192,63,64,0,0,0,0,0,47,192,63,69,85,85,85,85,85,47,192,63,75,255,255,255,255,254,47,192,0,11,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,255,255,208,0,0,0,1,255,255,255,255,208,0,0,0,1,255,255,255,255,208,0,0,0,1,252,0,0,31,208,0,0,0,1,252,0,0,31,208,0,0,0,2,252,0,0,31,208,0,0,0,3,252,0,0,31,208,6,0,0,11,244,0,0,31,208,7,224,0,47,240,0,0,31,208,11,224,1,255,192,0,0,15,208,15,208,111,255,64,0,0,15,255,255,208,127,252,0,0,0,15,255,255,192,47,208,0,0,0,3,255,255,0,9,0,0,0,0,0,0,0,0,
  // 0x5907  备
  7,89,36,37,77,38,1,251,0,0,0,190,64,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,15,255,255,255,255,128,0,0,0,63,255,255,255,255,224,0,0,1,255,255,255,255,255,192,0,0,11,255,0,0,1,255,64,0,0,127,255,192,0,7,253,0,0,2,255,255,244,0,47,248,0,0,15,255,11,254,1,255,208,0,0,3,248,2,255,219,255,0,0,0,0,192,0,127,255,252,0,0,0,0,0,0,31,255,244,0,0,0,0,0,6,255,255,255,224,0,0,0,1,191,255,239,255,255,148,0,6,255,255,254,0,191,255,255,249,191,255,255,208,0,6,255,255,253,63,255,244,0,0,0,27,255,248,47,249,0,0,0,0,0,26,240,4,47,255,255,255,255,255,244,0,0,47,255,255,255,255,255,244,0,0,47,255,255,255,255,255,244,0,0,47,192,0,254,0,7,244,0,0,47,192,0,254,0,7,244,0,0,47,192,0,254,0,7,244,0,0,47,255,255,255,255,255,244,0,0,47,255,255,255,255,255,244,0,0,47,255,255,255,255,255,244,0,0,47,192,0,254,0,7,244,0,0,47,192,0,254,0,7,244,0,0,47,192,0,254,0,7,244,0,0,47,192,0,254,0,7,244,0,0,47,255,255,255,255,255,244,0,0,47,255,255,255,255,255,244,0,0,47,255,255,255,255,255,244,0,0,47,192,0,0,0,7,244,0,0,0,0,0,0,0,0,0,0,
  // 0x590d  复
  13,89,25,37,3,38,6,251,0,3,64,0,0,0,0,0,11,240,0,0,0,0,0,15,240,0,0,0,0,0,47,208,0,0,0,0,0,63,255,255,255,253,0,0,255,255,255,255,253,0,2,255,255,255,255,253,0,7,252,0,0,0,0,0,31,244,0,0,0,0,0,127,255,255,255,255,224,0,191,255,255,255,255,224,0,46,63,85,85,95,224,0,4,63,0,0,15,224,0,0,63,64,0,15,224,0,0,63,255,255,255,224,0,0,63,255,255,255,224,0,0,63,0,0,15,224,0,0,63,0,0,15,224,0,0,63,255,255,255,224,0,0,63,255,255,255,224,0,0,21,191,149,85,64,0,0,0,255,0,0,0,0,0,3,255,170,170,64,0,0,15,255,255,255,240,0,0,63,255,255,255,208,0,2,255,208,0,63,128,0,31,255,244,0,255,0,0,127,245,254,7,253,0,0,47,128,127,239,244,0,0,9,0,31,255,192,0,0,0,0,31,255,128,0,0,0,2,255,255,254,0,0,1,191,255,159,255,254,64,63,255,248,1,255,255,192,31,254,64,0,27,255,0,14,64,0,0,0,29,0,0,0,0,0,0,0,0,
  // 0x5916  外
  22,89,36,36,68,38,1,252,0,0,57,0,0,0,191,0,0,0,0,127,64,0,0,191,0,0,0,0,191,0,0,0,191,0,0,0,0,254,0,0,0,191,0,0,0,1,253,0,0,0,191,0,0,0,2,252,0,0,0,191,0,0,0,3,255,255,254,0,191,0,0,0,11,255,255,255,0,191,0,0,0,15,255,255,255,0,191,0,0,0,31,229,85,255,64,191,0,0,0,63,192,0,255,224,191,0,0,0,191,64,1,255,244,191,0,0,0,255,0,2,255,252,191,0,0,2,253,0,3,252,254,191,0,0,7,253,0,3,244,191,255,0,0,31,255,128,7,240,63,255,0,0,63,255,244,11,240,15,255,0,0,191,223,254,15,224,7,255,0,0,47,2,255,239,192,1,255,64,0,5,0,127,255,192,0,255,224,0,0,0,15,255,64,0,191,252,0,0,0,3,255,0,0,191,255,64,0,0,1,253,0,0,191,255,224,0,0,3,252,0,0,191,127,254,0,0,15,244,0,0,191,15,254,0,0,31,240,0,0,191,2,252,0,0,127,192,0,0,191,0,48,0,0,255,128,0,0,191,0,0,0,3,255,0,0,0,191,0,0,0,15,252,0,0,0,191,0,0,0,127,240,0,0,0,191,0,0,2,255,192,0,0,0,191,0,0,31,255,0,0,0,0,191,0,0,31,252,0,0,0,0,191,0,0,7,224,0,0,0,0,191,0,0,1,0,0,0,0,0,190,0,0,
  // 0x591a  多
  26,89,33,36,68,38,3,252,0,0,0,46,64,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,15,255,255,255,240,0,0,0,0,127,255,255,255,252,0,0,0,3,255,255,255,255,244,0,0,0,47,253,0,0,31,240,0,0,6,255,244,0,0,127,192,0,0,127,255,254,0,1,255,64,0,0,191,250,255,208,7,253,0,0,0,47,64,47,252,47,244,0,0,0,4,0,7,255,255,208,0,0,0,0,0,0,255,255,64,0,0,0,0,0,0,127,249,144,0,0,0,0,0,7,255,215,254,0,0,0,0,0,191,254,15,248,0,0,0,0,47,255,224,127,224,0,0,0,91,255,254,2,255,255,255,253,0,255,255,208,15,255,255,255,255,64,191,248,0,191,255,255,255,255,0,57,0,11,255,128,0,3,252,0,0,0,191,253,0,0,11,248,0,0,31,255,255,0,0,31,240,0,0,255,254,255,224,0,63,208,0,0,127,208,63,252,1,255,128,0,0,45,0,7,255,75,254,0,0,0,0,0,0,255,255,248,0,0,0,0,0,0,47,255,224,0,0,0,0,0,0,31,255,64,0,0,0,0,0,2,255,248,0,0,0,0,0,0,127,255,208,0,0,0,0,0,111,255,253,0,0,0,0,2,191,255,255,144,0,0,0,0,3,255,255,244,0,0,0,0,0,2,255,249,0,0,0,0,0,0,0,229,0,0,0,0,0,0,0,
  // 0x5927  大
  39,89,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,106,170,170,175,255,170,170,170,144,0,0,0,31,255,0,0,0,0,0,0,0,47,255,128,0,0,0,0,0,0,63,255,192,0,0,0,0,0,0,63,239,208,0,0,0,0,0,0,191,79,240,0,0,0,0,0,0,255,15,240,0,0,0,0,0,1,254,7,252,0,0,0,0,0,3,253,3,253,0,0,0,0,0,11,252,1,255,0,0,0,0,0,15,244,0,255,192,0,0,0,0,63,240,0,63,208,0,0,0,0,191,192,0,47,244,0,0,0,2,255,128,0,15,252,0,0,0,11,254,0,0,7,255,64,0,0,47,252,0,0,1,255,208,0,1,255,240,0,0,0,127,248,0,11,255,192,0,0,0,31,255,128,191,254,0,0,0,0,7,255,240,191,244,0,0,0,0,0,255,208,47,128,0,0,0,0,0,47,128,8,0,0,0,0,0,0,2,0,
  // 0x5929  天
  41,89,35,33,41,38,2,252,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,106,170,170,171,254,170,170,170,144,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,31,255,255,255,255,255,255,255,128,31,255,255,255,255,255,255,255,128,31,255,255,255,255,255,255,255,128,26,170,170,175,255,170,170,170,64,0,0,0,15,255,0,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,47,255,192,0,0,0,0,0,0,63,255,208,0,0,0,0,0,0,127,223,240,0,0,0,0,0,0,255,75,248,0,0,0,0,0,3,255,3,253,0,0,0,0,0,11,253,2,255,0,0,0,0,0,47,248,0,255,192,0,0,0,0,255,224,0,63,244,0,0,0,7,255,192,0,31,254,0,0,0,127,254,0,0,7,255,208,0,7,255,248,0,0,1,255,253,0,191,255,192,0,0,0,47,255,244,255,253,0,0,0,0,7,255,240,63,208,0,0,0,0,0,191,192,41,0,0,0,0,0,0,6,128,
  // 0x592a  太
  42,89,35,36,68,38,2,252,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,106,170,170,175,255,170,170,170,160,0,0,0,31,255,64,0,0,0,0,0,0,47,255,192,0,0,0,0,0,0,63,239,192,0,0,0,0,0,0,63,143,224,0,0,0,0,0,0,127,79,240,0,0,0,0,0,0,255,7,244,0,0,0,0,0,1,255,3,252,0,0,0,0,0,2,253,2,254,0,0,0,0,0,7,252,1,255,0,0,0,0,0,15,248,0,191,128,0,0,0,0,31,240,0,63,208,0,0,0,0,127,210,0,47,240,0,0,0,0,255,223,192,15,252,0,0,0,3,255,127,240,7,254,0,0,0,15,253,31,252,2,255,128,0,0,127,248,7,255,0,255,240,0,2,255,224,1,255,192,63,253,0,31,255,128,0,127,240,15,255,128,255,253,0,0,47,244,3,255,244,255,240,0,0,11,224,0,191,240,63,64,0,0,3,64,0,31,192,24,0,0,0,0,0,0,2,64,
  // 0x5931  失
  49,89,35,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,11,240,3,248,0,0,0,0,0,15,240,3,248,0,0,0,0,0,31,224,3,248,0,0,0,0,0,47,192,3,248,0,0,0,0,0,63,192,3,248,0,0,0,0,0,191,234,171,254,170,170,164,0,0,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,248,0,3,255,255,255,255,255,255,248,0,7,248,0,3,248,0,0,0,0,15,240,0,3,248,0,0,0,0,63,224,0,3,248,0,0,0,0,191,192,0,3,248,0,0,0,0,47,128,0,3,248,0,0,0,0,6,0,0,3,244,0,0,0,0,0,0,0,7,244,0,0,0,0,106,170,170,171,250,170,170,170,144,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,47,255,64,0,0,0,0,0,0,63,255,192,0,0,0,0,0,0,191,239,224,0,0,0,0,0,0,255,79,240,0,0,0,0,0,3,255,7,252,0,0,0,0,0,11,253,3,255,0,0,0,0,0,47,248,0,255,192,0,0,0,0,255,224,0,127,240,0,0,0,7,255,192,0,31,254,0,0,0,127,254,0,0,7,255,208,0,7,255,248,0,0,1,255,254,0,191,255,192,0,0,0,47,255,244,255,253,0,0,0,0,7,255,240,63,208,0,0,0,0,0,127,208,24,0,0,0,0,0,0,6,128,
  // 0x5934  头
  52,89,34,36,68,38,2,252,0,0,0,0,10,144,0,0,0,0,0,0,0,15,208,0,0,0,0,11,144,0,15,208,0,0,0,0,31,253,0,15,208,0,0,0,0,31,255,208,15,208,0,0,0,0,1,255,252,15,208,0,0,0,0,0,31,253,15,208,0,0,0,0,0,1,248,15,208,0,0,0,0,0,0,48,31,208,0,0,0,2,208,0,0,31,208,0,0,0,11,253,0,0,31,208,0,0,0,15,255,208,0,31,192,0,0,0,1,255,252,0,31,192,0,0,0,0,31,255,0,47,192,0,0,0,0,1,255,0,47,192,0,0,0,0,0,60,0,63,192,0,0,0,0,0,0,0,63,128,0,0,0,21,85,85,85,127,149,85,85,64,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,1,254,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,128,0,0,0,0,0,0,47,242,248,0,0,0,0,0,0,191,199,255,128,0,0,0,0,2,255,65,255,248,0,0,0,0,15,254,0,31,255,64,0,0,0,127,248,0,2,255,224,0,0,7,255,208,0,0,63,253,0,1,191,255,0,0,0,7,255,128,111,255,244,0,0,0,0,255,224,127,255,128,0,0,0,0,47,192,47,244,0,0,0,0,0,7,64,9,0,0,0,0,0,0,0,0,
  // 0x597d  好
  125,89,36,37,77,38,1,251,0,15,144,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,31,192,0,255,255,255,255,208,0,31,192,0,255,255,255,255,244,0,47,128,0,255,255,255,255,240,0,63,128,0,85,85,85,127,208,0,63,64,0,0,0,0,255,128,0,63,0,0,0,0,2,254,0,127,255,255,252,0,0,7,252,0,127,255,255,252,0,0,31,240,0,127,255,255,252,0,0,127,192,0,21,253,86,252,0,2,255,0,0,0,252,2,252,0,2,252,0,0,1,252,2,248,0,2,252,0,0,2,248,3,244,0,2,252,0,0,3,244,3,245,85,87,253,85,84,3,240,3,247,255,255,255,255,254,7,240,7,243,255,255,255,255,254,11,224,11,243,255,255,255,255,254,15,208,15,224,0,2,252,0,0,15,208,15,208,0,2,252,0,0,15,244,47,192,0,2,252,0,0,31,255,63,192,0,2,252,0,0,63,255,255,64,0,2,252,0,0,11,127,255,0,0,2,252,0,0,1,11,255,0,0,2,252,0,0,0,2,255,192,0,2,252,0,0,0,3,255,240,0,2,252,0,0,0,15,255,252,0,2,252,0,0,0,47,227,254,0,2,252,0,0,0,127,192,253,0,2,252,0,0,1,255,64,56,0,2,252,0,0,11,253,0,0,5,87,252,0,0,47,248,0,0,15,255,248,0,0,15,208,0,0,11,255,240,0,0,7,0,0,0,7,255,128,0,0,0,0,0,0,0,0,0,0,0,
  // 0x59cb  始
  203,89,35,36,68,38,2,252,0,62,64,0,0,57,0,0,0,0,63,64,0,0,127,192,0,0,0,127,0,0,0,127,64,0,0,0,127,0,0,0,255,0,0,0,0,190,0,0,0,254,0,0,0,0,254,0,0,1,253,0,0,0,0,253,0,0,2,252,0,144,0,0,252,0,0,3,248,7,240,0,255,255,255,240,7,244,3,248,0,255,255,255,240,11,240,1,253,0,255,255,255,240,15,224,0,255,0,87,245,91,240,31,192,0,63,128,7,240,11,224,47,213,170,191,192,11,240,15,239,255,255,255,255,240,15,224,15,223,255,255,255,255,244,15,208,15,203,255,255,234,151,248,15,192,31,197,80,0,0,2,248,31,192,31,192,0,0,0,1,128,47,128,47,128,0,0,0,0,0,63,64,63,64,0,0,0,0,0,63,64,127,0,127,255,255,255,192,127,224,191,0,127,255,255,255,192,191,253,254,0,127,255,255,255,192,255,255,253,0,127,0,0,47,192,44,191,252,0,127,0,0,47,192,0,31,252,0,127,0,0,47,192,0,15,255,64,127,0,0,47,192,0,31,255,208,127,0,0,47,192,0,63,255,240,127,0,0,47,192,0,255,139,252,127,0,0,47,192,2,255,2,240,127,0,0,47,192,11,252,0,208,127,255,255,255,192,127,244,0,0,127,255,255,255,192,191,192,0,0,127,255,255,255,192,63,0,0,0,127,0,0,47,192,8,0,0,0,127,0,0,26,128,
  // 0x5b50  子
  80,91,34,35,59,38,2,251,0,85,85,85,85,85,85,128,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,240,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,127,244,0,0,0,0,0,0,2,255,208,0,0,0,0,0,0,31,254,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,170,170,170,171,254,170,170,170,160,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,170,171,252,0,0,0,0,0,0,255,255,248,0,0,0,0,0,0,127,255,240,0,0,0,0,0,0,63,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5b58  存
  88,91,35,36,68,38,1,252,0,0,0,41,0,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,0,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,5,85,95,249,85,85,85,85,84,0,0,15,240,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,128,0,0,0,4,0,0,1,255,3,255,255,255,255,0,0,3,253,3,255,255,255,255,128,0,11,252,3,255,255,255,255,0,0,47,240,0,0,0,11,252,0,0,127,224,0,0,0,47,224,0,1,255,224,0,0,0,255,128,0,7,255,224,0,0,15,253,0,0,47,255,224,0,0,15,240,0,0,191,239,224,0,0,15,224,0,0,63,143,224,255,255,255,255,255,252,29,15,224,255,255,255,255,255,252,0,15,224,255,255,255,255,255,252,0,15,224,85,85,95,245,85,84,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,85,95,224,0,0,0,15,224,0,127,255,224,0,0,0,15,224,0,63,255,192,0,0,0,15,224,0,63,254,0,0,0,
  // 0x5b89  安
  137,91,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,213,85,85,85,85,85,127,192,63,192,0,0,0,0,0,63,192,63,192,0,63,128,0,0,63,192,63,192,0,127,192,0,0,63,192,63,192,0,255,64,0,0,63,192,21,64,0,255,0,0,0,21,64,0,0,2,253,0,0,0,0,0,85,85,87,253,85,85,85,85,80,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,63,192,0,3,252,0,0,0,0,255,64,0,7,248,0,0,0,1,255,0,0,11,244,0,0,0,3,253,0,0,15,240,0,0,0,7,252,0,0,47,208,0,0,0,15,248,0,0,127,192,0,0,0,31,255,144,0,255,64,0,0,0,63,255,254,67,254,0,0,0,0,191,175,255,255,252,0,0,0,0,11,1,255,255,240,0,0,0,0,0,0,11,255,254,0,0,0,0,0,0,47,255,255,224,0,0,0,0,6,255,250,255,254,0,0,0,6,191,255,192,47,255,224,0,26,255,255,253,0,2,255,253,0,15,255,255,128,0,0,47,254,0,11,255,228,0,0,0,2,248,0,3,148,0,0,0,0,0,96,0,
  // 0x5b8c  完
  140,91,34,36,68,38,2,252,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,213,85,85,85,85,85,127,192,63,128,0,0,0,0,0,63,192,63,128,0,0,0,0,0,63,192,63,128,0,0,0,0,0,63,192,63,131,255,255,255,255,252,63,192,21,67,255,255,255,255,252,21,64,0,3,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,255,224,85,85,111,229,87,253,85,85,80,0,0,47,208,2,252,0,0,0,0,0,47,192,2,252,0,0,0,0,0,63,192,2,252,0,0,0,0,0,63,128,2,252,0,0,0,0,0,191,64,2,252,0,0,0,0,0,255,0,2,252,0,3,64,0,3,254,0,2,252,0,3,240,0,11,252,0,2,252,0,3,240,0,63,244,0,2,252,0,3,240,2,255,224,0,2,252,0,11,240,191,255,128,0,1,255,255,255,224,255,253,0,0,0,255,255,255,192,127,208,0,0,0,127,255,255,64,57,0,0,0,0,1,85,80,0,
  // 0x5b9a  定
  154,91,35,37,77,38,1,251,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,5,85,85,85,255,85,85,85,80,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,224,0,0,0,0,0,11,240,15,224,0,0,0,0,0,11,240,15,224,0,0,0,0,0,11,240,15,224,0,0,0,0,0,11,240,15,226,255,255,255,255,255,139,240,5,66,255,255,255,255,255,133,80,0,2,255,255,255,255,255,128,0,0,1,85,85,255,85,85,64,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,2,164,0,255,0,0,0,0,0,3,248,0,255,0,0,0,0,0,3,244,0,255,0,0,0,0,0,7,244,0,255,255,255,248,0,0,11,240,0,255,255,255,248,0,0,15,240,0,255,255,255,248,0,0,15,244,0,255,85,85,80,0,0,31,252,0,255,0,0,0,0,0,63,253,0,255,0,0,0,0,0,63,255,0,255,0,0,0,0,0,191,191,192,255,0,0,0,0,0,255,31,244,255,0,0,0,0,3,253,11,255,255,0,0,0,0,11,252,2,255,255,64,0,0,0,47,244,0,191,255,255,255,255,252,127,224,0,11,255,255,255,255,248,47,192,0,0,127,255,255,255,244,11,0,0,0,0,85,85,85,80,0,0,0,0,0,0,0,0,0,
  // 0x5ba2  客
  162,91,35,37,77,38,1,251,0,0,0,0,190,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,255,0,0,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,208,0,36,0,0,0,11,240,15,208,0,191,128,0,0,11,240,15,208,1,255,0,0,0,11,240,15,208,7,255,255,255,253,11,240,0,0,47,255,255,255,255,0,0,0,0,255,234,170,171,253,0,0,0,7,255,208,0,11,248,0,0,0,127,255,248,0,47,240,0,0,3,255,231,254,0,255,192,0,0,1,255,0,255,215,255,0,0,0,0,180,0,63,255,248,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,127,255,254,64,0,0,0,0,11,255,255,255,249,0,0,0,1,255,255,65,255,255,250,64,1,191,255,248,0,31,255,255,252,127,255,255,64,0,0,191,255,248,63,255,255,255,255,255,255,255,240,31,230,255,255,255,255,255,129,80,4,1,255,255,255,255,255,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,255,255,255,255,255,128,0,0,1,255,255,255,255,255,128,0,0,1,255,255,255,255,255,128,0,0,1,252,0,0,0,63,128,0,0,0,0,0,0,0,0,0,0,
  // 0x5bab  宫
  171,91,32,36,32,38,3,252,0,0,0,27,128,0,0,0,0,0,0,63,192,0,0,0,0,0,0,47,224,0,0,0,0,0,0,15,240,0,0,0,85,85,85,95,249,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,254,0,0,0,0,0,0,191,254,0,0,0,0,0,0,191,254,0,0,0,0,0,0,191,254,63,255,255,255,255,252,191,190,63,255,255,255,255,252,191,0,63,255,255,255,255,252,0,0,63,64,0,0,2,252,0,0,63,64,0,0,2,252,0,0,63,64,0,0,2,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,255,208,3,255,255,255,255,255,255,208,3,255,255,255,255,255,255,208,3,244,0,0,0,0,15,208,3,244,0,0,0,0,15,208,3,244,0,0,0,0,15,208,3,244,0,0,0,0,15,208,3,244,0,0,0,0,15,208,3,255,255,255,255,255,255,208,3,255,255,255,255,255,255,208,3,255,255,255,255,255,255,208,3,244,0,0,0,0,15,208,2,160,0,0,0,0,10,128,
  // 0x5bf9  对
  249,91,35,36,68,38,2,252,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,63,255,255,253,0,0,7,240,0,63,255,255,254,0,0,7,240,0,63,255,255,253,0,0,7,240,0,21,85,85,253,0,0,7,240,0,0,0,1,252,191,255,255,255,244,0,0,2,252,191,255,255,255,244,0,0,3,252,191,255,255,255,244,0,0,3,248,85,85,91,245,80,3,64,3,244,0,0,7,240,0,15,208,7,240,0,0,7,240,0,31,244,11,240,0,0,7,240,0,11,253,15,224,6,0,7,240,0,1,255,95,208,63,64,7,240,0,0,127,255,192,63,192,7,240,0,0,47,255,192,15,224,7,240,0,0,11,255,128,11,240,7,240,0,0,2,255,64,3,248,7,240,0,0,0,255,192,2,252,7,240,0,0,2,255,240,0,253,7,240,0,0,3,255,248,0,253,7,240,0,0,11,251,253,0,160,7,240,0,0,31,242,255,0,0,7,240,0,0,63,208,255,128,0,7,240,0,0,255,128,63,192,0,7,240,0,2,255,0,47,0,0,7,240,0,11,253,0,8,0,0,7,240,0,47,248,0,0,0,0,11,240,0,255,224,0,0,0,63,255,240,0,191,128,0,0,0,47,255,224,0,46,0,0,0,0,31,255,192,0,4,0,0,0,0,10,165,0,0,
  // 0x5c06  将
  6,92,36,36,68,38,1,252,0,2,248,0,0,0,0,29,0,0,2,248,0,0,0,107,255,0,0,2,248,0,5,191,255,255,192,0,2,248,175,255,255,255,249,0,0,2,248,255,255,255,249,0,0,10,2,248,127,254,148,0,0,0,127,2,248,20,0,25,0,3,128,63,130,248,1,0,190,0,7,244,47,210,248,47,64,127,0,15,240,15,242,248,47,128,63,64,47,208,7,242,248,15,192,47,128,63,192,3,250,248,15,224,47,192,255,0,2,255,248,7,240,31,194,253,0,1,251,248,3,244,14,71,248,0,0,130,248,3,244,0,15,240,0,0,2,248,1,64,0,31,208,0,0,2,248,0,0,0,3,244,0,0,2,248,0,0,0,3,244,0,0,2,248,21,85,85,87,249,84,0,2,248,255,255,255,255,255,253,0,2,248,255,255,255,255,255,253,0,7,248,255,255,255,255,255,253,0,63,248,0,0,0,3,244,0,2,255,248,0,112,0,3,244,0,31,255,248,3,252,0,3,244,0,191,251,248,1,254,0,3,244,0,127,210,248,0,191,128,3,244,0,63,2,248,0,63,208,3,244,0,40,2,248,0,15,240,3,244,0,0,2,248,0,11,244,3,244,0,0,2,248,0,3,208,3,244,0,0,2,248,0,1,0,3,244,0,0,2,248,0,0,21,91,244,0,0,2,248,0,0,31,255,240,0,0,2,248,0,0,15,255,240,0,0,2,248,0,0,15,254,64,0,
  // 0x5c0f  小
  15,92,36,36,68,38,1,252,0,0,0,0,85,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,4,0,0,255,0,1,128,0,0,15,240,0,255,0,31,208,0,0,15,240,0,255,0,15,240,0,0,31,240,0,255,0,11,244,0,0,31,224,0,255,0,3,252,0,0,63,208,0,255,0,2,254,0,0,63,192,0,255,0,0,255,0,0,127,128,0,255,0,0,255,64,0,191,64,0,255,0,0,127,192,0,255,0,0,255,0,0,63,208,1,254,0,0,255,0,0,47,224,3,253,0,0,255,0,0,15,240,7,252,0,0,255,0,0,15,248,15,244,0,0,255,0,0,7,252,47,240,0,0,255,0,0,3,252,63,208,0,0,255,0,0,2,253,127,192,0,0,255,0,0,1,254,11,0,0,0,255,0,0,0,254,0,0,0,0,255,0,0,0,208,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,63,255,255,0,0,0,0,0,0,31,255,254,0,0,0,0,0,0,15,255,248,0,0,0,0,0,0,6,170,64,0,0,0,0,
  // 0x5c31  就
  49,92,36,36,68,38,1,252,0,0,190,0,0,0,252,0,0,0,0,191,0,0,0,252,8,0,0,0,191,0,0,0,252,191,0,0,0,191,0,0,0,252,63,192,0,0,191,0,0,0,252,31,224,63,255,255,255,252,0,252,11,240,63,255,255,255,252,0,252,3,248,63,255,255,255,252,0,252,1,248,0,0,0,0,0,0,252,0,128,0,0,0,0,0,0,252,0,0,0,0,0,0,3,255,255,255,253,3,255,255,255,211,255,255,255,253,3,255,255,255,211,255,255,255,253,3,255,255,255,209,86,253,85,84,3,240,0,15,208,1,252,0,0,3,240,0,15,208,2,255,208,0,3,240,0,15,208,2,255,208,0,3,240,0,15,208,3,255,208,0,3,255,255,255,208,3,255,208,0,3,255,255,255,208,3,255,208,0,3,255,255,255,208,7,255,208,0,0,0,127,0,0,11,255,208,0,0,0,127,0,0,15,255,208,0,2,228,127,31,128,15,223,208,0,3,244,127,15,192,31,207,208,0,7,240,127,15,208,63,207,208,0,11,240,127,7,240,127,79,208,16,15,208,127,3,240,255,15,208,61,31,192,127,2,249,254,15,208,62,63,192,127,1,247,252,15,208,62,127,64,127,0,75,248,15,208,62,127,0,127,0,31,240,15,224,126,13,0,191,0,127,208,15,255,253,0,63,255,0,255,128,11,255,252,0,47,253,0,126,0,3,255,244,0,31,228,0,8,0,0,85,64,
  // 0x5c4f  屏
  79,92,35,35,59,38,1,251,0,191,255,255,255,255,255,255,128,0,191,255,255,255,255,255,255,128,0,191,255,255,255,255,255,255,128,0,191,0,0,0,0,0,63,128,0,191,0,0,0,0,0,63,128,0,191,0,0,0,0,0,63,128,0,191,0,0,0,0,0,63,128,0,191,255,255,255,255,255,255,128,0,191,255,255,255,255,255,255,128,0,191,255,255,255,255,255,255,128,0,191,0,111,0,0,15,224,0,0,191,0,63,128,0,31,224,0,0,191,0,31,192,0,63,192,0,0,191,0,15,224,0,127,0,0,0,255,63,255,255,255,255,255,240,0,254,63,255,255,255,255,255,240,0,254,63,255,255,255,255,255,240,0,254,0,11,240,0,190,0,0,0,254,0,11,240,0,190,0,0,0,253,0,11,240,0,190,0,0,0,253,0,11,240,0,190,0,0,1,252,0,11,240,0,190,0,0,1,252,255,255,255,255,255,255,252,2,252,255,255,255,255,255,255,252,3,248,255,255,255,255,255,255,252,3,244,0,31,208,0,191,0,0,7,240,0,63,192,0,190,0,0,11,240,0,127,128,0,190,0,0,15,224,1,255,0,0,190,0,0,31,208,7,254,0,0,190,0,0,63,192,47,248,0,0,190,0,0,127,128,255,224,0,0,190,0,0,47,0,127,128,0,0,190,0,0,6,0,24,0,0,0,190,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5de5  工
  229,93,34,29,5,38,2,255,10,170,170,170,170,170,170,170,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,170,170,170,171,254,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x5dee  差
  238,93,35,36,68,38,1,252,0,0,8,0,0,0,164,0,0,0,0,191,0,0,0,255,0,0,0,0,127,128,0,1,254,0,0,0,0,47,192,0,3,252,0,0,0,0,15,224,0,11,240,0,0,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,63,255,255,255,255,255,253,0,0,63,255,255,255,255,255,253,0,0,63,255,255,255,255,255,253,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,0,0,191,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,253,255,255,255,255,253,0,0,3,252,255,255,255,255,253,0,0,7,248,255,255,255,255,253,0,0,15,240,0,2,252,0,0,0,0,31,224,0,2,252,0,0,0,0,63,208,0,2,252,0,0,0,0,191,192,0,2,252,0,0,0,1,255,0,0,2,252,0,0,0,7,253,0,0,2,252,0,0,0,47,248,191,255,255,255,255,255,240,127,240,191,255,255,255,255,255,240,31,192,191,255,255,255,255,255,240,2,0,0,0,0,0,0,0,0,
  // 0x5df2  已
  242,93,33,33,41,38,3,253,21,85,85,85,85,85,85,0,0,127,255,255,255,255,255,255,64,0,127,255,255,255,255,255,255,64,0,127,255,255,255,255,255,255,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,5,80,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,245,85,85,85,85,191,64,0,11,255,255,255,255,255,255,64,0,11,255,255,255,255,255,255,64,0,11,255,255,255,255,255,255,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,127,64,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,20,0,11,240,0,0,0,0,0,47,128,11,240,0,0,0,0,0,47,192,11,240,0,0,0,0,0,63,192,11,240,0,0,0,0,0,63,192,11,240,0,0,0,0,0,127,128,7,248,0,0,0,0,0,255,64,3,255,165,85,85,85,107,255,0,3,255,255,255,255,255,255,253,0,0,255,255,255,255,255,255,244,0,0,27,255,255,255,255,255,128,0,
  // 0x5e73  平
  115,94,34,34,50,38,2,252,5,85,85,85,85,85,85,85,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,4,0,0,0,47,0,3,252,0,15,208,0,0,63,128,3,252,0,47,208,0,0,47,192,3,252,0,63,192,0,0,31,208,3,252,0,127,128,0,0,15,240,3,252,0,191,0,0,0,7,240,3,252,0,254,0,0,0,3,248,3,252,2,252,0,0,0,3,252,3,252,3,248,0,0,0,2,228,3,252,3,240,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,170,170,170,171,254,170,170,170,160,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x5e76  并
  118,94,34,37,77,38,2,251,0,0,160,0,0,0,228,0,0,0,11,244,0,0,1,255,0,0,0,3,252,0,0,2,254,0,0,0,1,254,0,0,3,252,0,0,0,0,255,0,0,15,244,0,0,0,0,127,128,0,31,224,0,0,0,0,63,192,0,63,192,0,0,0,0,30,0,0,11,0,0,0,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,5,85,191,85,85,95,229,85,64,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,255,85,85,111,229,85,80,0,0,254,0,0,15,208,0,0,0,0,254,0,0,15,208,0,0,0,2,253,0,0,15,208,0,0,0,3,252,0,0,15,208,0,0,0,11,248,0,0,15,208,0,0,0,15,240,0,0,15,208,0,0,0,63,224,0,0,15,208,0,0,0,255,192,0,0,15,208,0,0,3,255,64,0,0,15,208,0,0,31,253,0,0,0,15,208,0,0,191,244,0,0,0,15,208,0,0,63,208,0,0,0,15,208,0,0,14,0,0,0,0,15,208,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5e8a  床
  138,94,36,36,68,38,1,252,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,253,85,85,85,85,85,85,84,1,252,0,0,0,84,0,0,0,1,252,0,0,1,252,0,0,0,1,252,0,0,1,252,0,0,0,1,252,0,0,1,252,0,0,0,1,252,0,0,1,252,0,0,0,1,252,0,0,1,252,0,0,0,1,252,63,255,255,255,255,255,252,1,252,63,255,255,255,255,255,252,1,252,63,255,255,255,255,255,252,1,252,21,85,95,255,149,85,84,2,252,0,0,47,255,192,0,0,2,252,0,0,127,255,240,0,0,2,252,0,0,255,255,244,0,0,3,248,0,2,255,255,253,0,0,3,248,0,7,249,252,255,0,0,3,248,0,15,241,252,127,192,0,3,244,0,63,209,252,47,240,0,7,240,0,255,129,252,11,253,0,11,240,3,255,1,252,3,255,64,15,240,31,252,1,252,0,255,224,15,224,191,240,1,252,0,63,253,31,210,255,192,1,252,0,15,253,63,192,254,0,1,252,0,2,244,63,128,56,0,1,252,0,0,96,191,0,0,0,1,252,0,0,0,47,0,0,0,1,252,0,0,0,5,0,0,0,1,252,0,0,0,
  // 0x5e94  应
  148,94,35,37,77,38,1,251,0,0,0,0,47,64,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,15,240,0,0,0,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,253,85,85,85,85,85,85,84,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,47,64,0,47,64,1,252,0,0,63,128,0,63,192,1,252,31,64,47,192,0,63,192,1,252,47,192,31,192,0,127,64,1,252,31,192,15,208,0,191,0,1,252,15,224,15,240,0,255,0,1,252,11,240,11,240,1,253,0,2,252,7,244,7,244,2,252,0,2,252,3,248,3,248,3,248,0,2,252,2,252,3,248,7,244,0,2,252,1,252,2,252,15,240,0,3,252,0,254,1,252,15,208,0,3,248,0,255,1,253,47,192,0,3,248,0,191,0,144,63,128,0,3,248,0,127,0,0,191,0,0,7,244,0,52,0,0,254,0,0,7,240,0,0,0,2,252,0,0,11,240,0,0,0,3,248,0,0,15,224,0,0,0,11,240,0,0,15,225,85,85,85,95,229,85,84,47,211,255,255,255,255,255,255,252,63,195,255,255,255,255,255,255,252,127,131,255,255,255,255,255,255,252,47,0,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5e9f  废
  159,94,35,37,77,38,1,251,0,0,0,0,43,128,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,47,224,0,0,0,0,85,85,85,95,245,85,85,84,2,255,255,255,255,255,255,255,252,2,255,255,255,255,255,255,255,252,2,255,255,255,255,255,255,255,252,2,252,0,0,1,0,0,0,0,2,252,1,232,3,244,2,0,0,2,252,3,252,7,240,31,192,0,2,252,3,248,11,240,15,240,0,2,252,7,244,15,240,7,252,0,2,252,15,240,15,224,1,254,0,2,252,31,224,31,208,0,180,0,2,252,63,255,255,255,255,255,240,2,252,63,255,255,255,255,255,240,2,252,47,255,255,255,255,255,240,2,252,21,0,191,0,0,0,0,2,252,0,0,254,0,0,0,0,3,252,0,1,253,0,0,0,0,3,248,0,3,252,0,0,0,0,3,248,0,7,255,255,255,248,0,3,248,0,15,255,255,255,253,0,3,244,0,47,255,255,255,252,0,3,244,0,127,240,0,15,244,0,7,244,0,255,252,0,63,224,0,11,240,3,254,255,64,191,192,0,11,240,15,248,63,211,255,0,0,15,224,127,240,15,255,252,0,0,15,226,255,192,3,255,240,0,0,31,223,255,0,7,255,248,0,0,47,199,248,0,191,255,255,208,0,63,129,208,47,255,230,255,255,144,127,64,2,255,254,0,47,255,248,47,0,0,255,224,0,1,191,240,6,0,0,121,0,0,0,6,192,0,0,0,0,0,0,0,0,0,
  // 0x5ea6  度
  166,94,35,36,68,38,1,252,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,63,192,0,0,0,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,252,0,0,0,0,0,0,0,1,252,0,31,192,0,47,128,0,1,252,0,31,192,0,47,128,0,1,252,0,31,192,0,47,128,0,1,252,255,255,255,255,255,255,248,1,252,255,255,255,255,255,255,248,1,252,255,255,255,255,255,255,244,1,252,0,31,192,0,47,128,0,1,252,0,31,192,0,47,128,0,1,252,0,31,192,0,47,128,0,1,252,0,31,234,170,191,128,0,1,252,0,31,255,255,255,128,0,2,252,0,31,255,255,255,128,0,2,252,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,3,248,127,255,255,255,255,248,0,3,244,191,255,255,255,255,255,0,3,244,191,255,255,255,255,253,0,3,244,0,47,64,0,7,252,0,7,240,0,47,224,0,31,240,0,11,240,0,15,248,0,191,192,0,15,224,0,3,255,71,255,0,0,15,208,0,0,191,255,248,0,0,31,192,0,0,47,255,224,0,0,63,192,0,6,255,255,254,64,0,63,64,91,255,255,255,255,254,148,191,2,255,255,249,1,255,255,252,46,0,255,254,64,0,11,255,244,5,0,185,0,0,0,0,6,224,
  // 0x5f00  开
  0,95,34,35,59,38,2,251,5,85,85,85,85,85,85,85,64,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,0,0,63,64,0,15,240,0,0,0,0,63,64,0,15,240,0,0,0,0,63,64,0,15,240,0,0,0,0,63,64,0,15,240,0,0,0,0,63,64,0,15,240,0,0,0,0,63,64,0,15,240,0,0,0,0,63,64,0,15,240,0,0,0,0,63,64,0,15,240,0,0,0,0,63,64,0,15,240,0,0,0,0,63,64,0,15,240,0,0,85,85,127,149,85,95,245,85,80,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,191,0,0,15,240,0,0,0,0,191,0,0,15,240,0,0,0,0,255,0,0,15,240,0,0,0,0,254,0,0,15,240,0,0,0,2,253,0,0,15,240,0,0,0,3,252,0,0,15,240,0,0,0,7,252,0,0,15,240,0,0,0,15,244,0,0,15,240,0,0,0,47,240,0,0,15,240,0,0,0,127,208,0,0,15,240,0,0,1,255,128,0,0,15,240,0,0,7,255,0,0,0,15,240,0,0,47,252,0,0,0,15,240,0,0,191,240,0,0,0,15,240,0,0,47,192,0,0,0,15,240,0,0,10,0,0,0,0,15,240,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5f03  弃
  3,95,35,37,77,38,1,251,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,63,255,255,255,255,255,255,255,248,63,255,255,255,255,255,255,255,248,63,255,255,255,255,255,255,255,248,0,0,0,255,0,0,0,0,0,0,0,2,253,0,1,224,0,0,0,0,3,252,0,11,253,0,0,0,0,11,240,0,2,255,128,0,0,0,31,208,0,0,127,240,0,5,85,127,234,171,255,255,253,0,15,255,255,255,255,255,255,255,64,11,255,255,255,255,255,255,255,224,11,255,250,170,149,84,0,31,244,0,0,0,0,0,1,80,7,208,0,0,31,192,0,3,244,1,0,0,0,31,192,0,3,244,0,0,0,0,31,192,0,3,244,0,0,0,0,31,192,0,3,244,0,0,0,0,31,192,0,3,244,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,127,128,0,7,244,0,0,0,0,127,64,0,3,244,0,0,0,0,255,0,0,3,244,0,0,0,2,254,0,0,3,244,0,0,0,7,252,0,0,3,244,0,0,0,31,248,0,0,3,244,0,0,0,255,224,0,0,3,244,0,0,27,255,128,0,0,3,244,0,0,127,253,0,0,0,3,244,0,0,31,224,0,0,0,3,244,0,0,10,0,0,0,0,3,244,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5f0f  式
  15,95,35,36,68,38,2,252,0,0,0,0,2,168,1,0,0,0,0,0,0,3,252,15,128,0,0,0,0,0,3,252,47,240,0,0,0,0,0,3,252,11,253,0,0,0,0,0,3,252,1,255,0,0,0,0,0,3,252,0,126,0,0,0,0,0,3,252,0,24,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,85,86,254,85,85,80,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,31,255,255,255,240,255,0,0,0,31,255,255,255,240,255,0,0,0,31,255,255,255,240,191,0,0,0,5,85,254,85,80,191,0,0,0,0,0,253,0,0,127,64,0,0,0,0,253,0,0,63,128,0,0,0,0,253,0,0,63,192,0,0,0,0,253,0,0,63,192,0,0,0,0,253,0,0,47,192,0,0,0,0,253,0,0,31,208,1,0,0,0,253,0,0,15,240,2,208,0,0,253,0,4,15,240,2,248,0,0,253,22,252,7,248,2,248,0,0,255,255,252,3,252,3,244,1,111,255,255,252,2,254,3,244,127,255,255,254,80,0,255,71,240,127,255,254,64,0,0,191,255,240,63,250,64,0,0,0,63,255,208,41,0,0,0,0,0,11,255,192,0,0,0,0,0,0,1,254,0,
  // 0x5f15  引
  21,95,30,37,40,38,3,251,0,0,0,0,0,0,5,64,21,85,85,85,0,0,31,208,63,255,255,255,0,0,31,208,63,255,255,255,0,0,31,208,63,255,255,255,0,0,31,208,0,0,0,127,0,0,31,208,0,0,0,127,0,0,31,208,0,0,0,127,0,0,31,208,0,0,0,127,0,0,31,208,0,0,0,127,0,0,31,208,5,85,85,127,0,0,31,208,15,255,255,255,0,0,31,208,31,255,255,255,0,0,31,208,47,255,255,255,0,0,31,208,47,192,0,0,0,0,31,208,63,128,0,0,0,0,31,208,63,128,0,0,0,0,31,208,63,64,0,0,0,0,31,208,127,85,85,85,0,0,31,208,191,255,255,255,64,0,31,208,191,255,255,255,64,0,31,208,255,255,255,255,0,0,31,208,253,0,0,127,0,0,31,208,109,0,0,191,0,0,31,208,0,0,0,191,0,0,31,208,0,0,0,255,0,0,31,208,0,0,0,255,0,0,31,208,0,0,0,254,0,0,31,208,0,0,0,254,0,0,31,208,0,0,1,253,0,0,31,208,0,0,2,252,0,0,31,208,0,0,3,252,0,0,31,208,2,170,175,248,0,0,31,208,1,255,255,244,0,0,31,208,0,255,255,224,0,0,31,208,0,191,254,64,0,0,31,208,0,0,0,0,0,0,0,0,
  // 0x5f39  弹
  57,95,35,36,68,38,2,252,0,0,0,0,16,0,0,144,0,0,0,0,1,248,0,2,253,0,191,255,252,1,253,0,3,252,0,191,255,252,0,255,0,7,244,0,191,255,252,0,63,128,15,240,0,0,1,252,0,47,192,31,192,0,0,0,252,0,15,192,63,128,0,0,0,252,0,5,0,191,0,0,0,0,252,31,255,255,255,255,128,0,0,252,31,255,255,255,255,192,63,255,252,31,255,255,255,255,192,63,255,252,31,192,47,192,31,192,63,255,252,31,192,47,192,31,192,63,0,0,31,192,47,192,31,192,63,0,0,31,234,191,234,191,192,63,0,0,31,255,255,255,255,192,63,0,0,31,255,255,255,255,192,126,0,0,31,192,47,192,31,192,126,0,0,31,192,47,192,31,192,127,255,252,31,192,47,192,31,192,127,255,252,31,255,255,255,255,192,127,255,252,31,255,255,255,255,192,0,1,252,31,255,255,255,255,192,0,1,252,0,0,47,192,0,0,0,1,252,0,0,47,192,0,0,0,1,252,0,0,47,192,0,0,0,2,249,255,255,255,255,255,244,0,2,249,255,255,255,255,255,244,0,3,249,255,255,255,255,255,244,0,3,244,0,0,47,192,0,0,0,3,244,0,0,47,192,0,0,0,11,240,0,0,47,192,0,0,63,255,240,0,0,47,192,0,0,31,255,208,0,0,47,192,0,0,15,255,64,0,0,47,192,0,0,5,80,0,0,0,47,192,0,0,
  // 0x5f52  归
  82,95,32,37,40,38,3,251,0,0,168,0,0,0,0,0,0,0,252,0,0,0,0,0,0,0,252,0,0,0,0,0,0,0,252,5,85,85,85,85,0,0,252,15,255,255,255,254,190,0,252,15,255,255,255,254,190,0,252,15,255,255,255,254,190,0,252,0,0,0,0,254,190,0,252,0,0,0,0,254,190,0,252,0,0,0,0,254,190,0,252,0,0,0,0,254,190,0,252,0,0,0,0,254,190,0,252,0,0,0,0,254,190,0,252,0,0,0,0,254,190,0,252,0,0,0,0,254,190,1,252,0,0,0,0,254,190,1,252,3,255,255,255,254,190,1,252,3,255,255,255,254,190,1,252,3,255,255,255,254,190,1,252,1,85,85,85,254,190,1,252,0,0,0,0,254,190,2,252,0,0,0,0,254,190,3,252,0,0,0,0,254,190,3,248,0,0,0,0,254,0,3,248,0,0,0,0,254,0,7,244,0,0,0,0,254,0,15,240,0,0,0,0,254,0,15,224,0,0,0,0,254,0,47,208,0,0,0,0,254,0,127,192,63,255,255,255,254,0,255,64,63,255,255,255,254,3,255,0,63,255,255,255,254,15,252,0,21,85,85,85,254,47,244,0,0,0,0,0,254,11,224,0,0,0,0,0,254,2,64,0,0,0,0,0,84,0,0,0,0,0,0,0,0,
  // 0x5f84  径
  132,95,36,36,68,38,1,252,0,0,144,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,7,252,31,255,255,255,255,128,0,15,244,31,255,255,255,255,208,0,63,224,31,255,255,255,255,192,1,255,128,0,108,0,0,127,64,7,254,0,0,255,0,0,255,0,47,248,0,0,63,128,3,252,0,127,208,45,0,47,208,11,248,0,47,64,127,192,15,244,47,240,0,12,0,255,0,3,253,191,192,0,0,2,254,0,0,255,255,0,0,0,11,252,0,0,127,252,0,0,0,31,240,0,0,191,254,0,0,0,127,208,0,31,255,255,224,0,1,255,208,1,255,253,127,255,64,11,255,208,127,255,208,11,255,254,47,255,208,255,253,0,0,191,253,255,239,208,191,128,10,144,7,248,127,143,208,36,0,15,208,0,16,61,15,208,0,0,15,208,0,0,4,15,208,0,0,15,208,0,0,0,15,208,0,0,15,208,0,0,0,15,208,15,255,255,255,255,208,0,15,208,15,255,255,255,255,208,0,15,208,15,255,255,255,255,208,0,15,208,0,0,15,208,0,0,0,15,208,0,0,15,208,0,0,0,15,208,0,0,15,208,0,0,0,15,208,0,0,15,208,0,0,0,15,208,0,0,15,208,0,0,0,15,208,0,0,15,224,0,0,0,15,209,255,255,255,255,255,253,0,15,209,255,255,255,255,255,253,0,15,209,255,255,255,255,255,253,0,15,208,0,0,0,0,0,0,
  // 0x5f85  待
  133,95,36,36,68,38,1,252,0,0,144,0,0,10,128,0,0,0,1,253,0,0,31,192,0,0,0,3,252,0,0,31,192,0,0,0,15,244,0,0,31,192,0,0,0,63,224,0,0,31,192,0,0,0,255,128,31,255,255,255,255,224,7,255,0,31,255,255,255,255,224,47,252,0,31,255,255,255,255,224,63,224,0,0,0,31,208,0,0,31,128,56,0,0,31,192,0,0,13,0,255,0,0,31,192,0,0,0,1,253,0,0,31,192,0,0,0,3,252,0,0,31,208,0,0,0,15,241,255,255,255,255,255,253,0,47,225,255,255,255,255,255,253,0,191,209,255,255,255,255,255,253,2,255,192,0,0,0,3,244,0,11,255,192,0,0,0,3,244,0,63,255,192,0,0,0,3,244,0,191,239,192,0,0,0,7,248,0,63,79,192,255,255,255,255,255,252,45,15,192,255,255,255,255,255,252,4,15,192,255,255,255,255,255,252,0,15,192,0,0,0,3,244,0,0,15,192,1,240,0,3,244,0,0,15,192,7,248,0,3,244,0,0,15,192,2,253,0,3,244,0,0,15,192,0,255,0,3,244,0,0,15,192,0,127,192,3,244,0,0,15,192,0,47,208,3,244,0,0,15,192,0,15,208,3,244,0,0,15,192,0,10,0,3,244,0,0,15,192,0,0,5,87,244,0,0,15,192,0,0,15,255,244,0,0,15,192,0,0,15,255,240,0,0,15,192,0,0,11,254,64,0,
  // 0x5faa  循
  170,95,36,36,68,38,1,252,0,1,144,0,0,0,0,0,0,0,3,252,0,0,0,1,191,0,0,11,244,0,0,90,255,255,192,0,47,224,62,191,255,255,254,64,0,191,128,63,255,255,254,64,0,2,255,0,63,254,148,253,0,0,11,252,0,63,0,0,253,0,0,63,240,0,63,0,0,253,0,0,127,192,96,63,0,0,253,0,0,46,0,254,63,255,255,255,255,253,4,2,252,63,255,255,255,255,253,0,7,248,63,255,255,255,255,253,0,15,240,63,0,0,252,0,0,0,47,208,63,0,0,252,0,0,0,191,192,63,0,0,252,0,0,1,255,192,63,0,1,252,0,0,7,255,192,63,15,255,255,255,240,31,255,192,63,15,255,255,255,240,191,255,192,63,15,255,255,255,240,191,159,192,63,15,192,0,11,240,62,31,192,127,15,192,0,11,240,24,31,192,127,15,229,85,91,240,0,31,192,127,15,255,255,255,240,0,31,192,190,15,255,255,255,240,0,31,192,190,15,192,0,11,240,0,31,192,254,15,192,0,11,240,0,31,192,253,15,229,85,91,240,0,31,192,252,15,255,255,255,240,0,31,193,252,15,255,255,255,240,0,31,194,248,15,192,0,11,240,0,31,195,244,15,192,0,11,240,0,31,199,240,15,192,0,11,240,0,31,207,240,15,255,255,255,240,0,31,207,208,15,255,255,255,240,0,31,194,192,15,229,85,95,240,0,31,192,64,15,192,0,6,160,
  // 0x5fae  微
  174,95,36,36,68,38,1,252,0,9,0,3,208,0,26,64,0,0,31,208,3,208,0,31,192,0,0,63,192,3,208,0,47,128,0,0,255,69,67,208,80,63,64,0,2,254,15,131,208,244,63,64,0,7,252,15,131,208,244,63,0,0,31,240,15,131,208,244,127,0,0,127,192,15,131,208,244,190,0,0,127,66,15,131,208,244,255,255,253,61,7,255,131,208,244,255,255,253,4,15,239,131,208,245,255,255,253,0,47,207,255,255,247,248,7,240,0,63,143,255,255,251,252,7,224,0,255,11,255,255,255,252,11,224,2,254,0,0,0,15,252,11,208,7,254,0,0,0,63,253,15,192,15,254,0,0,0,47,126,15,192,63,254,31,255,255,254,63,15,192,255,254,31,255,255,248,47,31,128,190,190,31,255,255,248,31,111,64,60,126,0,252,31,128,31,191,0,16,126,0,252,31,128,15,255,0,0,126,0,252,31,128,15,254,0,0,126,0,252,31,128,7,253,0,0,126,0,248,31,128,3,252,0,0,126,1,248,31,128,3,248,0,0,126,2,244,31,138,7,248,0,0,126,3,244,31,255,15,252,0,0,126,3,240,127,255,47,255,0,0,126,11,224,191,244,127,191,64,0,126,15,208,126,0,255,47,208,0,126,47,192,16,3,252,15,244,0,126,63,64,0,31,244,7,253,0,126,30,0,0,63,208,2,254,0,126,8,0,0,31,0,0,184,0,126,0,0,0,4,0,0,16,
  // 0x5fc3  心
  195,95,36,36,68,38,1,252,0,0,0,32,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,1,255,255,64,0,0,0,0,0,0,11,255,244,0,0,0,0,0,0,0,191,254,0,0,0,0,0,0,0,11,255,208,0,0,0,0,0,0,1,255,208,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,2,224,0,0,248,7,240,0,0,15,244,0,0,253,7,240,0,0,7,252,0,1,252,7,240,0,0,2,254,0,1,252,7,240,0,0,0,255,0,2,252,7,240,0,0,0,127,192,3,252,7,240,0,0,0,63,208,3,248,7,240,0,0,0,31,240,7,244,7,240,0,0,0,15,240,11,240,7,240,0,0,0,11,248,15,240,7,240,0,0,0,3,252,31,224,7,240,0,0,16,2,253,63,192,7,240,0,0,46,1,254,127,192,7,240,0,0,47,128,255,255,64,7,240,0,0,63,128,244,47,0,7,240,0,0,63,64,0,0,0,7,240,0,0,63,64,0,0,0,7,240,0,0,127,0,0,0,0,7,248,0,0,255,0,0,0,0,3,255,255,255,254,0,0,0,0,2,255,255,255,252,0,0,0,0,0,191,255,255,240,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5ffd  忽
  253,95,35,36,68,38,2,252,0,0,57,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,7,255,255,255,255,255,253,0,0,15,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,255,128,191,64,191,2,252,0,3,254,0,255,0,254,1,252,0,15,252,3,252,2,252,2,252,0,127,240,7,248,3,248,2,252,0,191,192,31,240,11,240,2,252,0,47,0,127,192,31,224,3,252,0,4,1,255,64,63,192,3,248,0,0,7,253,0,191,64,3,248,0,0,47,244,1,254,0,3,244,0,0,255,208,7,252,0,7,244,0,11,255,64,31,240,0,11,240,0,11,252,0,127,208,0,31,240,0,2,224,3,255,64,63,255,224,0,0,64,31,253,0,47,255,192,0,0,0,15,240,0,47,254,0,0,0,0,3,199,208,0,0,0,0,0,0,0,31,252,0,0,0,0,0,16,5,71,255,64,7,0,0,0,189,31,192,191,224,63,192,0,0,253,31,192,31,208,31,240,0,2,252,31,192,3,64,7,252,0,3,248,31,192,0,2,66,255,0,11,244,31,192,0,2,244,191,128,31,240,31,192,0,3,244,63,208,127,192,31,208,0,7,244,31,240,255,64,31,255,255,255,240,11,244,61,0,15,255,255,255,224,3,128,4,0,2,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6027  性
  39,96,35,36,68,38,1,252,0,47,192,0,0,7,224,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,253,11,240,0,0,0,47,192,1,253,11,240,0,0,0,47,192,1,252,11,240,0,0,0,47,192,2,252,11,240,0,0,0,47,196,3,248,11,240,0,0,9,47,254,3,244,11,240,0,0,15,111,255,7,255,255,255,255,240,31,111,223,139,255,255,255,255,240,31,111,207,207,255,255,255,255,240,47,47,203,239,229,95,245,85,80,47,47,199,255,192,11,240,0,0,63,47,194,127,128,11,240,0,0,62,47,192,191,64,11,240,0,0,125,47,192,255,0,11,240,0,0,189,47,192,29,0,11,240,0,0,188,47,192,0,0,11,240,0,0,4,47,192,0,0,11,240,0,0,0,47,192,7,255,255,255,255,208,0,47,192,7,255,255,255,255,208,0,47,192,7,255,255,255,255,208,0,47,192,1,85,95,245,85,64,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,255,255,255,255,255,252,0,47,192,255,255,255,255,255,252,0,47,192,255,255,255,255,255,252,0,47,192,85,85,85,85,85,84,0,42,128,0,0,0,0,0,0,
  // 0x603b  总
  59,96,34,36,68,38,2,252,0,0,24,0,0,2,64,0,0,0,0,253,0,0,3,248,0,0,0,0,255,0,0,11,248,0,0,0,0,63,192,0,15,240,0,0,0,0,47,208,0,47,208,0,0,0,0,15,240,0,63,192,0,0,0,0,11,244,0,191,64,0,0,0,21,87,213,85,255,85,64,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,63,128,0,0,0,47,208,0,0,63,128,0,0,0,47,208,0,0,63,128,0,0,0,47,208,0,0,63,128,0,0,0,47,208,0,0,63,128,0,0,0,47,208,0,0,63,128,0,0,0,47,208,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,21,85,85,213,85,85,64,0,0,0,0,7,224,0,0,0,0,0,0,0,15,252,0,0,0,0,1,0,127,66,255,64,1,240,0,7,240,127,64,191,208,7,248,0,11,240,127,64,47,244,2,253,0,15,224,127,64,11,248,0,255,0,15,208,127,64,2,208,0,127,128,47,192,127,64,0,64,16,47,208,63,192,127,64,0,0,126,15,240,127,64,127,64,0,0,191,7,240,255,0,127,128,0,0,255,3,224,125,0,63,255,255,255,253,1,64,4,0,47,255,255,255,252,0,0,0,0,11,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6062  恢
  98,96,36,36,68,38,1,252,0,47,128,11,208,0,0,0,0,0,47,128,11,208,0,0,0,0,0,47,128,11,208,0,0,0,0,0,47,128,11,208,0,0,0,0,0,47,130,255,255,255,255,255,253,0,47,130,255,255,255,255,255,253,0,47,150,255,255,255,255,255,253,5,47,253,95,229,85,85,85,84,15,47,189,11,208,0,105,0,0,15,47,175,11,208,0,190,0,0,31,47,159,11,208,0,190,0,0,31,47,143,139,208,0,190,0,0,31,47,139,203,208,0,190,0,80,47,47,135,203,211,208,190,0,252,62,47,129,15,211,224,190,1,248,61,47,128,15,211,224,190,2,244,188,47,128,15,211,208,190,3,240,184,47,128,15,199,208,190,7,224,0,47,128,15,203,192,190,11,192,0,47,128,15,207,192,190,15,192,0,47,128,15,207,128,255,31,64,0,47,128,31,223,0,255,27,0,0,47,128,31,129,0,255,0,0,0,47,128,47,128,2,255,128,0,0,47,128,63,64,3,255,192,0,0,47,128,63,64,7,235,208,0,0,47,128,63,0,15,215,240,0,0,47,128,191,0,47,195,244,0,0,47,128,254,0,127,65,252,0,0,47,129,252,0,255,0,255,0,0,47,130,252,3,252,0,127,192,0,47,131,244,31,248,0,47,240,0,47,139,240,191,224,0,15,253,0,47,143,225,255,128,0,3,254,0,47,135,192,190,0,0,0,252,0,47,128,64,32,0,0,0,32,
  // 0x606f  息
  111,96,36,36,68,38,1,252,0,0,0,0,255,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,2,253,0,0,0,0,0,7,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,240,0,0,0,11,240,0,0,11,240,0,0,0,11,240,0,0,11,250,170,170,170,175,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,240,0,0,0,11,240,0,0,11,240,0,0,0,11,240,0,0,11,240,0,0,0,11,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,11,250,170,170,170,175,240,0,0,11,240,0,0,0,11,240,0,0,11,240,0,0,0,11,240,0,0,11,250,170,170,170,175,240,0,0,11,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,0,0,0,144,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,254,0,0,0,0,0,120,5,81,255,128,1,240,0,0,191,15,224,63,208,7,252,0,0,254,15,224,15,240,3,255,0,2,252,15,224,7,224,0,255,128,3,252,15,224,2,64,64,63,224,11,244,15,224,0,0,248,15,244,31,240,15,224,0,0,252,7,252,127,208,11,244,0,2,252,2,253,47,128,11,255,255,255,248,0,252,6,0,3,255,255,255,240,0,144,0,0,0,191,255,255,128,0,0,
  // 0x611f  感
  31,97,36,36,68,38,1,252,0,0,0,0,1,248,14,64,0,0,0,0,0,1,252,63,244,0,0,0,0,0,1,252,27,254,0,0,0,0,0,1,252,1,252,0,0,255,255,255,255,255,255,255,248,0,255,255,255,255,255,255,255,248,0,255,255,255,255,255,255,255,244,0,252,0,0,0,190,0,0,0,0,252,0,0,0,127,0,80,0,0,252,255,255,254,63,0,253,0,0,252,255,255,254,63,66,252,0,1,252,85,85,84,47,131,248,0,1,252,0,0,0,31,199,240,0,1,252,0,0,0,15,223,240,0,2,248,127,255,252,11,255,192,0,2,248,127,255,252,7,255,128,0,3,244,126,85,252,3,255,0,16,3,240,125,0,252,3,253,0,120,7,240,125,0,252,15,255,0,125,15,224,126,85,252,63,255,128,189,31,208,127,255,253,255,239,240,252,63,192,127,255,255,255,15,255,252,127,64,0,2,65,248,3,255,244,63,0,0,11,224,96,0,127,208,12,0,0,15,253,0,0,0,0,0,16,6,162,255,128,0,160,0,0,62,11,240,127,224,7,248,0,0,127,11,240,15,192,3,254,0,0,255,11,240,3,0,128,255,128,1,253,11,240,0,0,248,63,208,3,252,11,240,0,0,252,15,240,15,244,11,240,0,2,252,7,248,63,224,11,255,255,255,248,3,253,47,192,3,255,255,255,240,0,244,6,0,1,255,255,255,208,0,64,0,0,0,0,0,0,0,0,0,
  // 0x620f  戏
  15,98,36,37,77,38,1,251,0,0,0,0,1,168,0,0,0,0,0,0,0,1,252,3,192,0,0,0,0,0,1,252,15,240,0,0,0,0,0,1,253,7,252,0,0,0,0,0,1,253,1,255,0,63,255,255,252,1,253,0,191,192,63,255,255,252,1,253,0,47,128,63,255,255,252,0,253,0,13,0,0,0,2,252,0,253,0,0,0,0,0,2,252,0,254,0,22,180,2,0,3,248,0,255,191,255,248,15,128,3,245,255,255,255,255,252,47,208,7,242,255,255,255,255,164,15,244,11,241,255,255,165,0,0,3,252,15,224,148,191,0,4,0,1,254,31,208,0,191,0,15,128,0,191,111,192,0,127,64,31,192,0,63,255,128,0,127,64,63,192,0,31,255,64,0,63,128,127,64,0,11,255,0,0,63,128,255,0,0,3,254,0,0,63,194,253,0,0,3,255,0,0,47,199,252,0,0,7,255,128,0,31,223,240,0,0,15,255,208,0,31,255,208,0,0,47,255,240,0,15,255,128,0,0,127,203,248,0,15,255,0,0,0,255,131,252,0,11,253,0,160,3,255,1,255,0,31,252,0,252,15,252,0,253,0,191,253,0,253,63,244,0,112,2,255,255,0,252,191,208,0,0,31,254,255,129,252,47,128,0,0,191,248,127,247,248,13,0,0,2,255,208,63,255,244,0,0,0,0,191,0,15,255,240,0,0,0,0,36,0,2,255,208,0,0,0,0,0,0,0,111,64,0,0,0,0,0,0,0,0,0,
  // 0x6210  成
  16,98,36,37,77,38,1,251,0,0,0,0,2,248,9,0,0,0,0,0,0,3,252,63,128,0,0,0,0,0,3,252,127,244,0,0,0,0,0,3,252,11,254,0,0,0,0,0,2,252,1,255,192,0,0,0,0,2,252,0,63,0,0,85,85,85,87,253,85,110,84,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,255,255,255,255,255,255,255,252,1,253,0,0,1,252,0,0,0,1,253,0,0,1,253,0,0,0,1,253,0,0,0,253,0,0,0,1,253,0,0,0,254,0,63,64,1,254,0,0,0,254,0,127,128,1,255,255,255,192,255,0,191,0,1,255,255,255,192,191,0,254,0,1,255,255,255,192,191,1,253,0,1,253,0,47,192,127,3,252,0,1,253,0,47,192,127,75,244,0,1,253,0,47,192,63,143,240,0,1,252,0,47,192,63,239,208,0,1,252,0,47,128,47,255,192,0,2,252,0,47,128,31,255,0,0,2,252,0,63,128,15,254,0,0,3,252,0,63,128,15,252,0,128,3,248,0,127,64,31,244,0,248,3,248,255,255,0,127,248,0,253,7,244,127,255,1,255,252,0,252,11,240,127,248,7,255,255,0,252,15,240,0,0,47,252,255,65,252,47,224,0,1,255,240,127,210,248,63,192,0,11,255,192,47,255,244,127,128,0,7,254,0,15,255,240,47,0,0,1,244,0,2,255,208,6,0,0,0,64,0,0,25,0,0,0,0,0,0,0,0,0,0,
  // 0x6237  户
  55,98,32,37,40,38,1,251,0,0,0,0,108,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,128,0,0,0,63,255,255,255,255,255,253,0,63,255,255,255,255,255,253,0,63,255,255,255,255,255,253,0,63,213,85,85,85,86,253,0,63,192,0,0,0,1,253,0,63,192,0,0,0,1,253,0,63,192,0,0,0,1,253,0,63,192,0,0,0,1,253,0,63,192,0,0,0,1,253,0,63,192,0,0,0,1,253,0,63,213,85,85,85,85,253,0,63,255,255,255,255,255,253,0,63,255,255,255,255,255,253,0,63,255,255,255,255,255,253,0,63,128,0,0,0,1,253,0,63,64,0,0,0,1,253,0,127,64,0,0,0,0,84,0,127,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,254,0,0,0,0,0,0,1,253,0,0,0,0,0,0,2,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,11,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,47,224,0,0,0,0,0,0,127,192,0,0,0,0,0,0,47,64,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6240  所
  64,98,36,36,68,38,1,252,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,31,192,47,255,255,255,240,0,2,255,244,47,255,255,255,241,1,191,255,244,47,255,255,255,242,255,255,254,0,0,0,0,0,2,255,255,144,0,0,0,0,0,2,255,208,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,248,0,0,0,7,255,255,255,194,248,0,0,0,7,255,255,255,194,248,0,0,0,7,255,255,255,194,248,0,0,0,7,240,0,47,194,248,0,0,0,7,240,0,47,194,255,255,255,254,7,240,0,47,195,255,255,255,254,7,240,0,47,195,255,255,255,254,7,240,0,47,195,253,85,255,84,7,240,0,47,195,248,0,191,0,7,255,255,255,195,244,0,191,0,7,255,255,255,195,244,0,191,0,7,255,255,255,195,244,0,191,0,7,240,0,0,7,240,0,191,0,7,240,0,0,7,240,0,191,0,7,240,0,0,11,240,0,191,0,11,240,0,0,15,224,0,191,0,11,224,0,0,15,208,0,191,0,15,224,0,0,47,192,0,191,0,15,208,0,0,63,192,0,191,0,15,192,0,0,127,64,0,191,0,31,192,0,0,255,0,0,191,0,47,192,0,1,254,0,0,191,0,63,64,0,3,252,0,0,191,0,191,0,0,15,244,0,0,191,0,255,0,0,15,240,0,0,191,0,61,0,0,3,192,0,0,191,0,8,0,0,0,64,0,0,190,0,
  // 0x6247  扇
  71,98,34,34,50,38,1,252,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,170,170,170,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,0,0,0,0,0,127,0,0,191,0,0,0,0,0,127,0,0,191,0,0,0,0,0,127,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,170,170,170,170,170,170,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,191,255,252,127,255,255,128,0,190,191,255,252,127,255,255,128,0,254,106,171,252,42,170,191,128,0,254,5,0,252,2,0,47,128,0,253,63,64,252,31,192,47,128,0,252,31,208,252,11,240,47,128,1,252,11,240,252,3,248,47,128,2,252,3,240,252,0,244,47,128,3,248,0,64,252,0,64,47,128,3,244,0,44,252,0,27,111,128,11,240,6,253,252,2,255,175,128,15,241,191,253,252,127,254,47,128,31,211,255,208,252,255,224,47,128,63,194,249,0,252,126,0,47,128,127,128,128,0,252,16,0,63,128,191,0,0,255,252,0,31,255,128,29,0,0,127,248,0,15,255,0,0,0,0,62,144,0,11,232,0,
  // 0x624b  手
  75,98,34,37,77,38,2,251,0,0,0,0,0,0,27,64,0,0,0,0,0,5,175,255,208,0,0,5,106,191,255,255,255,240,0,7,255,255,255,255,255,249,64,0,3,255,255,255,255,164,0,0,0,3,255,250,151,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,7,255,255,255,255,255,255,255,0,7,255,255,255,255,255,255,255,0,7,255,255,255,255,255,255,255,0,1,85,85,87,253,85,85,85,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,87,253,85,85,85,80,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,1,85,91,252,0,0,0,0,0,1,255,255,248,0,0,0,0,0,0,255,255,240,0,0,0,0,0,0,191,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6253  打
  83,98,36,36,68,38,1,252,0,11,224,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,2,170,170,170,170,168,0,11,240,3,255,255,255,255,253,0,11,240,3,255,255,255,255,253,0,11,240,3,255,255,255,255,253,21,95,245,80,0,0,63,192,0,63,255,255,248,0,0,63,192,0,63,255,255,248,0,0,63,192,0,63,255,255,248,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,4,0,0,63,192,0,0,11,246,252,0,0,63,192,0,0,15,255,252,0,0,63,192,0,6,255,255,252,0,0,63,192,0,127,255,255,64,0,0,63,192,0,63,255,240,0,0,0,63,192,0,47,239,240,0,0,0,63,192,0,20,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,63,192,0,0,15,240,0,0,0,63,192,0,15,255,224,0,11,255,255,192,0,11,255,208,0,3,255,255,128,0,7,255,64,0,3,255,254,0,0,1,64,0,0,1,234,144,0,0,
  // 0x6267  执
  103,98,36,37,77,38,1,251,0,47,128,0,7,240,0,0,0,0,47,128,0,7,240,0,0,0,0,47,128,0,7,240,0,0,0,0,47,128,0,7,240,0,0,0,0,47,128,0,7,240,0,0,0,0,47,128,0,7,240,0,0,0,0,47,128,0,7,240,0,0,0,0,47,128,0,7,240,0,0,0,63,255,255,127,255,255,255,244,0,63,255,255,127,255,255,255,244,0,63,255,255,127,255,255,255,244,0,0,47,192,0,11,240,7,244,0,0,47,128,0,11,240,3,244,0,0,47,128,0,11,240,3,244,0,0,47,128,0,11,224,3,244,0,0,47,128,0,15,224,3,240,0,0,47,128,11,15,224,3,240,0,0,47,223,159,239,208,3,240,0,0,47,255,191,255,208,3,240,0,2,255,255,199,255,208,3,240,0,127,255,253,0,191,248,3,240,0,127,255,192,0,47,255,3,240,0,63,255,128,0,63,255,211,240,0,40,47,128,0,127,191,255,240,0,0,47,128,0,191,11,247,240,0,0,47,128,0,254,1,211,240,0,0,47,128,1,253,0,3,240,0,0,47,128,3,252,0,3,244,0,0,47,128,11,244,0,3,244,116,0,47,128,31,240,0,3,244,126,0,47,128,63,208,0,2,248,125,0,47,128,255,128,0,1,252,189,5,127,135,255,0,0,0,254,252,31,255,143,252,0,0,0,255,252,15,255,7,240,0,0,0,127,244,11,248,1,192,0,0,0,31,208,0,0,0,0,0,0,0,0,0,
  // 0x6279  批
  121,98,36,36,68,38,1,252,0,63,64,5,64,0,168,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,21,127,149,15,208,0,253,0,0,127,255,255,15,208,0,253,0,0,127,255,255,15,208,0,253,0,128,127,255,255,15,208,0,253,2,240,0,63,64,15,208,0,253,11,248,0,63,64,15,229,80,253,63,244,0,63,64,15,255,248,254,255,208,0,63,64,15,255,248,255,255,0,0,63,64,15,255,248,255,244,0,0,63,64,15,208,0,255,192,0,0,63,175,15,208,0,254,0,0,0,63,255,15,208,0,253,0,0,27,255,255,15,208,0,253,0,0,191,255,248,15,208,0,253,0,0,127,255,64,15,208,0,253,0,0,62,127,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,0,0,63,64,15,208,0,253,0,64,0,63,64,15,208,0,253,0,184,0,63,64,15,208,0,253,0,190,0,63,64,15,208,20,253,0,189,0,63,64,15,235,252,253,0,253,0,63,70,255,255,252,254,0,252,0,127,75,255,255,228,255,255,252,47,255,3,255,228,0,127,255,248,31,254,3,148,0,0,47,255,224,15,244,0,0,0,0,0,0,0,
  // 0x6296  抖
  150,98,36,36,68,38,1,252,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,15,0,3,244,0,0,15,192,0,63,224,3,244,0,0,15,192,0,47,252,3,244,0,0,15,192,0,7,255,67,244,0,21,95,213,64,0,191,195,244,0,63,255,255,240,0,31,67,244,0,63,255,255,240,0,6,3,244,0,63,255,255,240,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,144,0,3,244,0,0,15,192,1,253,0,3,244,0,0,15,192,3,255,192,3,244,0,0,15,192,0,191,248,3,244,0,0,15,192,16,15,254,3,244,0,0,15,235,240,1,252,3,244,0,0,31,255,240,0,52,3,244,0,27,255,255,240,0,0,3,244,0,127,255,254,64,0,0,3,244,0,63,255,208,0,0,0,3,250,252,63,159,192,0,0,1,175,255,253,16,15,192,0,26,255,255,255,254,0,15,192,15,255,255,255,254,144,0,15,192,15,255,255,235,244,0,0,15,192,15,254,144,3,244,0,0,15,192,5,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,31,192,0,0,0,3,244,0,31,255,192,0,0,0,3,244,0,15,255,192,0,0,0,3,244,0,15,254,0,0,0,0,3,244,0,0,0,0,0,0,0,1,80,0,
  // 0x62a5  报
  165,98,36,36,68,38,1,252,0,10,144,0,0,0,0,0,0,0,15,224,1,85,85,85,85,64,0,15,224,3,255,255,255,255,192,0,15,224,3,255,255,255,255,192,0,15,224,3,255,255,255,255,192,0,15,224,3,244,0,0,31,192,0,15,224,3,244,0,0,47,192,21,95,229,67,244,0,0,47,192,63,255,255,211,244,0,0,63,192,63,255,255,211,244,0,0,127,128,63,255,255,211,244,15,255,255,64,0,15,224,3,244,11,255,255,0,0,15,224,3,244,2,255,228,0,0,15,224,3,244,0,0,0,0,0,15,224,3,248,0,0,0,0,0,15,224,3,255,255,255,255,240,0,15,224,3,255,255,255,255,240,0,15,235,211,255,255,255,255,240,0,15,255,227,246,252,0,15,224,6,255,255,227,244,252,0,31,208,191,255,255,147,244,254,0,47,192,127,255,224,3,244,127,0,63,128,63,255,224,3,244,63,128,191,0,57,15,224,3,244,47,208,255,0,0,15,224,3,244,15,242,253,0,0,15,224,3,244,7,255,252,0,0,15,224,3,244,3,255,240,0,0,15,224,3,244,0,255,224,0,0,15,224,3,244,0,191,208,0,0,15,224,3,244,1,255,248,0,0,15,224,3,244,11,255,255,0,0,15,224,3,244,127,246,255,224,21,111,208,3,250,255,208,127,253,63,255,208,3,255,255,0,31,248,47,255,192,3,245,248,0,2,240,31,249,0,2,160,128,0,0,0,
  // 0x62ac  抬
  172,98,36,37,77,38,1,251,0,15,208,0,0,164,0,0,0,0,15,208,0,0,255,64,0,0,0,15,208,0,0,255,0,0,0,0,15,208,0,2,253,0,0,0,0,15,208,0,3,252,0,0,0,0,15,208,0,3,248,0,0,0,0,15,208,0,11,244,0,144,0,21,95,229,64,15,240,7,240,0,127,255,255,208,31,208,3,252,0,127,255,255,208,47,192,1,254,0,127,255,255,208,63,128,0,191,64,0,15,208,0,127,0,0,63,192,0,15,208,0,255,106,175,255,224,0,15,208,63,255,255,255,255,244,0,15,208,63,255,255,255,255,252,0,15,208,63,255,255,169,86,253,0,15,208,101,80,0,0,0,254,0,15,239,224,0,0,0,0,180,0,31,255,224,0,0,0,0,0,7,255,255,240,0,0,0,0,0,191,255,254,67,255,255,255,255,192,127,255,208,3,255,255,255,255,192,63,159,208,3,255,255,255,255,192,16,15,208,3,253,85,85,127,192,0,15,208,3,248,0,0,47,192,0,15,208,3,248,0,0,47,192,0,15,208,3,248,0,0,47,192,0,15,208,3,248,0,0,47,192,0,15,208,3,248,0,0,47,192,0,15,208,3,248,0,0,47,192,0,15,208,3,248,0,0,47,192,0,15,208,3,255,255,255,255,192,0,31,208,3,255,255,255,255,192,15,255,192,3,255,255,255,255,192,15,255,192,3,248,0,0,63,192,11,254,0,2,248,0,0,42,128,0,0,0,0,0,0,0,0,0,
  // 0x62bd  抽
  189,98,35,37,77,38,1,251,0,31,192,0,0,7,224,0,0,0,31,192,0,0,7,240,0,0,0,31,192,0,0,7,240,0,0,0,31,192,0,0,7,240,0,0,0,31,192,0,0,7,240,0,0,0,31,192,0,0,7,240,0,0,0,31,192,0,0,7,240,0,0,21,111,213,64,0,7,240,0,0,127,255,255,192,0,7,240,0,0,127,255,255,207,255,255,255,255,248,127,255,255,207,255,255,255,255,248,0,31,192,15,255,255,255,255,248,0,31,192,15,229,91,245,87,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,219,207,208,7,240,3,248,0,31,255,207,208,7,240,3,248,2,255,255,223,255,255,255,255,248,191,255,254,79,255,255,255,255,248,191,255,208,15,255,255,255,255,248,127,255,192,15,229,91,245,87,248,52,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,208,7,240,3,248,0,31,192,15,229,91,245,87,248,0,31,192,15,255,255,255,255,248,0,31,192,15,255,255,255,255,248,0,47,192,15,255,255,255,255,248,31,255,192,15,208,0,0,3,248,15,255,64,15,208,0,0,3,248,15,249,0,11,208,0,0,1,164,0,0,0,0,0,0,0,0,0,
  // 0x62d4  拔
  212,98,36,37,77,38,1,251,0,31,192,0,7,240,1,0,0,0,31,192,0,7,240,15,128,0,0,31,192,0,7,240,47,244,0,0,31,192,0,7,240,11,255,0,0,31,192,0,7,240,0,255,208,0,31,192,0,7,240,0,47,224,0,31,192,0,7,240,0,7,192,21,111,213,64,7,240,0,1,0,127,255,255,218,175,250,170,170,168,127,255,255,223,255,255,255,255,252,127,255,255,223,255,255,255,255,252,0,31,192,0,11,240,0,0,0,0,31,192,0,11,240,0,0,0,0,31,192,0,15,240,0,0,0,0,31,192,0,15,244,0,42,0,0,31,192,0,15,248,0,63,0,0,31,192,0,15,252,0,127,0,0,31,199,192,15,252,0,191,0,0,31,255,192,31,253,0,254,0,2,255,255,208,47,255,0,253,0,191,255,254,64,63,191,65,252,0,191,255,208,0,63,111,194,252,0,127,255,192,0,127,15,195,244,0,56,31,192,0,191,11,231,240,0,0,31,192,0,254,7,255,240,0,0,31,192,1,252,2,255,208,0,0,31,192,3,252,0,255,192,0,0,31,192,3,244,0,255,128,0,0,31,192,15,240,1,255,208,0,0,31,192,31,224,7,255,244,0,0,31,192,63,192,15,255,253,0,0,31,192,191,64,127,226,255,128,0,47,194,255,2,255,128,191,244,31,255,203,252,15,254,0,31,254,15,255,67,240,7,248,0,3,252,15,249,0,208,1,208,0,0,112,0,0,0,0,0,0,0,0,0,
  // 0x62e9  择
  233,98,36,37,77,38,1,251,0,31,128,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,15,255,255,255,255,128,0,47,192,15,255,255,255,255,208,0,47,192,15,255,255,255,255,192,0,47,192,0,127,64,0,191,0,0,47,192,0,47,192,1,254,0,21,111,213,64,15,224,7,252,0,63,255,255,192,7,248,31,240,0,63,255,255,192,1,255,191,192,0,63,255,255,192,0,191,255,0,0,0,47,192,0,0,63,252,0,0,0,47,192,0,1,255,255,128,0,0,47,192,0,31,255,255,248,0,0,47,192,6,255,244,47,255,224,0,47,192,127,255,128,2,255,254,0,47,192,127,248,0,0,111,252,0,47,239,206,64,15,224,1,244,0,47,255,192,0,15,224,0,0,7,255,255,192,0,15,224,0,0,127,255,249,3,255,255,255,255,128,127,255,192,3,255,255,255,255,128,63,175,192,3,255,255,255,255,128,16,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,63,255,255,255,255,252,0,47,192,63,255,255,255,255,252,0,47,192,63,255,255,255,255,252,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,5,127,192,0,0,15,224,0,0,15,255,192,0,0,15,224,0,0,15,255,64,0,0,15,224,0,0,11,249,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6309  按
  9,99,36,37,77,38,1,251,0,31,192,0,0,15,224,0,0,0,31,192,0,0,15,224,0,0,0,31,192,0,0,15,224,0,0,0,31,192,0,0,15,224,0,0,0,31,192,0,0,15,224,0,0,0,31,192,31,255,255,255,255,252,0,31,192,31,255,255,255,255,252,21,111,213,95,255,255,255,255,252,127,255,255,223,192,0,0,1,252,127,255,255,223,192,16,0,1,252,127,255,255,223,192,127,64,1,252,0,31,192,31,192,191,0,1,252,0,31,192,31,192,255,0,1,252,0,31,192,0,0,253,0,0,0,0,31,192,0,1,252,0,0,0,0,31,192,0,3,252,0,0,0,0,31,192,47,255,255,255,255,253,0,31,198,239,255,255,255,255,253,0,31,255,255,255,255,255,255,253,1,191,255,208,15,208,0,255,0,127,255,255,128,31,192,0,254,0,191,255,208,0,63,128,1,253,0,127,255,192,0,63,64,2,252,0,57,31,192,0,191,0,3,248,0,0,31,192,0,255,128,11,244,0,0,31,192,1,255,249,15,240,0,0,31,192,2,255,255,255,208,0,0,31,192,1,185,255,255,192,0,0,31,192,0,0,31,255,192,0,0,31,192,0,0,11,255,248,0,0,31,192,0,0,127,255,255,64,0,31,192,0,27,255,194,255,224,0,47,192,22,255,254,0,127,252,31,255,192,191,255,224,0,11,252,15,255,64,63,253,0,0,1,244,15,249,0,46,64,0,0,0,96,0,0,0,0,0,0,0,0,0,
  // 0x6321  挡
  33,99,34,36,68,38,1,252,0,31,192,0,0,6,160,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,7,208,11,240,7,224,0,47,192,11,240,11,240,11,240,0,47,192,7,240,11,240,15,224,0,47,192,3,248,11,240,15,208,21,111,213,66,252,11,240,47,192,63,255,255,192,252,11,240,63,128,63,255,255,192,254,11,240,63,0,63,255,255,192,191,11,240,190,0,0,47,192,0,126,11,240,253,0,0,47,192,0,16,11,240,108,0,0,47,192,0,0,11,240,0,0,0,47,192,5,85,95,245,85,80,0,47,192,15,255,255,255,255,224,0,47,192,15,255,255,255,255,224,0,47,198,207,255,255,255,255,224,0,47,255,192,0,0,0,11,224,6,255,255,192,0,0,0,11,224,191,255,254,64,0,0,0,11,224,191,255,192,0,0,0,0,11,224,127,175,192,11,255,255,255,255,224,16,47,192,11,255,255,255,255,224,0,47,192,11,255,255,255,255,224,0,47,192,0,0,0,0,15,224,0,47,192,0,0,0,0,11,224,0,47,192,0,0,0,0,11,224,0,47,192,0,0,0,0,11,224,0,47,192,0,0,0,0,11,224,0,47,192,63,255,255,255,255,224,0,47,192,63,255,255,255,255,224,47,255,192,63,255,255,255,255,224,15,255,64,21,85,85,85,95,224,15,253,0,0,0,0,0,11,224,0,0,0,0,0,0,0,5,80,
  // 0x6324  挤
  36,99,36,36,68,38,1,252,0,63,0,0,0,47,0,0,0,0,63,0,0,0,127,64,0,0,0,63,0,0,0,63,192,0,0,0,63,0,0,0,31,192,0,0,0,63,0,255,255,255,255,255,252,0,63,0,255,255,255,255,255,252,0,63,0,255,255,255,255,255,252,21,127,84,0,253,0,2,253,0,63,255,254,0,191,0,3,252,0,63,255,254,0,63,128,11,244,0,63,255,254,0,31,208,15,240,0,0,63,0,0,15,244,63,192,0,0,63,0,0,3,254,255,64,0,0,63,0,0,0,255,253,0,0,0,63,0,0,0,191,252,0,0,0,63,0,0,27,255,255,208,0,0,63,8,26,255,255,255,255,164,0,63,253,255,255,224,47,255,253,0,63,253,191,253,0,2,255,248,7,255,254,62,64,0,0,6,240,127,255,224,0,127,0,7,240,0,127,255,0,0,127,0,7,240,0,63,191,0,0,127,0,7,240,0,16,63,0,0,127,0,7,240,0,0,63,0,0,127,0,7,240,0,0,63,0,0,127,0,7,240,0,0,63,0,0,127,0,7,240,0,0,63,0,0,255,0,7,240,0,0,63,0,0,254,0,7,240,0,0,63,0,2,252,0,7,240,0,0,63,0,11,252,0,7,240,0,0,63,0,47,240,0,7,240,0,47,255,1,255,208,0,7,240,0,31,255,3,255,64,0,7,240,0,15,252,0,184,0,0,7,240,0,5,64,0,0,0,0,1,80,0,
  // 0x635f  损
  95,99,36,36,68,38,1,252,0,47,128,0,0,0,0,0,0,0,63,128,1,170,170,170,170,0,0,63,128,2,255,255,255,255,0,0,63,128,2,255,255,255,255,0,0,63,128,2,252,0,0,191,0,0,63,128,2,252,0,0,191,0,0,63,128,2,252,0,0,191,0,21,127,149,2,252,0,0,191,0,127,255,255,194,254,170,170,255,0,127,255,255,194,255,255,255,255,0,127,255,255,194,255,255,255,255,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,11,255,255,255,255,192,0,63,128,11,255,255,255,255,192,0,63,128,11,255,255,255,255,192,0,63,129,75,224,0,0,31,192,0,63,255,203,224,0,0,31,192,0,127,255,203,224,10,144,31,192,27,255,255,139,224,15,208,31,192,191,255,228,11,224,15,208,31,192,191,255,128,11,224,15,208,31,192,126,63,128,11,224,15,208,31,192,0,63,128,11,224,31,208,31,192,0,63,128,11,224,31,192,31,192,0,63,128,11,224,63,192,31,192,0,63,128,11,224,191,128,26,128,0,63,128,0,1,255,11,64,0,0,63,128,0,11,253,47,240,0,0,63,128,0,127,244,31,254,0,0,63,128,11,255,208,2,255,192,63,255,130,255,255,0,0,127,248,31,255,65,255,244,0,0,11,253,15,253,0,190,64,0,0,1,248,5,80,0,16,0,0,0,0,32,
  // 0x6362  换
  98,99,36,36,68,38,1,252,0,42,64,0,2,64,0,0,0,0,63,64,0,7,248,0,0,0,0,63,64,0,15,240,0,0,0,0,63,64,0,31,224,0,0,0,0,63,64,0,63,255,255,248,0,0,63,64,0,191,255,255,254,0,0,63,64,2,255,255,255,252,0,21,127,148,7,252,0,11,244,0,63,255,255,31,244,0,31,224,0,63,255,255,191,208,0,127,128,0,63,255,255,191,255,255,255,255,128,0,63,64,47,255,255,255,255,128,0,63,64,15,255,255,255,255,128,0,63,64,11,224,15,208,63,128,0,63,64,11,224,15,208,63,128,0,63,64,11,224,15,208,63,128,0,63,64,11,224,15,208,63,128,0,63,175,11,224,15,208,63,128,0,63,255,11,224,15,208,63,128,27,255,255,75,224,15,192,63,128,191,255,248,11,224,31,192,63,128,127,255,64,255,255,255,255,255,252,62,127,64,255,255,255,255,255,252,0,63,64,255,255,255,255,255,252,0,63,64,0,0,255,240,0,0,0,63,64,0,1,255,244,0,0,0,63,64,0,3,254,252,0,0,0,63,64,0,15,240,255,0,0,0,63,64,0,63,224,63,192,0,0,63,64,0,255,128,31,244,0,0,63,64,7,254,0,7,254,0,0,63,64,63,248,0,2,255,208,47,255,66,255,208,0,0,127,253,15,255,15,255,0,0,0,15,252,15,253,3,244,0,0,0,1,244,5,64,0,64,0,0,0,0,0,
  // 0x6389  掉
  137,99,36,37,77,38,1,251,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,255,255,252,0,63,128,0,0,31,255,255,252,0,63,128,0,0,31,255,255,252,0,63,128,0,0,31,192,0,0,21,127,149,0,0,31,192,0,0,127,255,255,64,0,31,192,0,0,127,255,255,95,255,255,255,255,192,127,255,255,95,255,255,255,255,192,0,63,128,31,255,255,255,255,192,0,63,128,31,192,0,0,31,192,0,63,128,31,192,0,0,31,192,0,63,128,31,192,0,0,31,192,0,63,128,31,255,255,255,255,192,0,63,128,31,255,255,255,255,192,0,63,175,95,234,170,170,191,192,0,63,255,159,192,0,0,31,192,6,255,255,159,192,0,0,31,192,127,255,254,31,192,0,0,31,192,127,255,208,31,255,255,255,255,192,63,255,128,31,255,255,255,255,192,36,63,128,31,255,255,255,255,192,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,63,130,255,255,255,255,255,253,0,63,130,255,255,255,255,255,253,0,63,130,255,255,255,255,255,253,0,63,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,0,127,128,0,0,31,192,0,0,63,255,64,0,0,31,192,0,0,47,255,0,0,0,31,192,0,0,31,248,0,0,0,31,192,0,0,0,0,0,0,0,0,0,0,0,
  // 0x63a2  探
  162,99,36,36,68,38,1,252,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,63,255,255,255,255,248,0,63,64,63,255,255,255,255,248,0,63,64,63,255,255,255,255,248,0,63,64,63,0,0,0,1,248,0,63,64,63,2,160,63,1,248,21,127,149,63,3,240,63,1,248,127,255,255,63,7,240,63,1,248,127,255,255,42,7,240,63,0,0,127,255,255,0,15,224,63,0,80,0,63,64,0,31,208,63,0,125,0,63,64,0,127,192,63,64,189,0,63,64,6,255,0,63,255,252,0,63,64,127,253,0,47,255,248,0,63,64,63,224,0,11,255,224,0,63,91,14,0,15,208,0,0,0,63,255,0,0,15,208,0,0,0,127,255,0,0,15,208,0,0,111,255,255,0,0,15,208,0,0,191,255,224,127,255,255,255,255,252,127,255,64,127,255,255,255,255,252,57,63,64,127,255,255,255,255,252,0,63,64,0,2,255,255,0,0,0,63,64,0,3,255,255,64,0,0,63,64,0,15,255,255,192,0,0,63,64,0,47,223,223,240,0,0,63,64,0,191,143,215,252,0,0,63,64,2,255,15,210,255,0,0,63,64,15,252,15,208,191,192,0,63,64,127,240,15,208,63,244,0,63,67,255,192,15,208,15,254,0,127,67,255,0,15,208,3,252,47,255,0,244,0,15,208,0,180,31,254,0,0,0,15,208,0,0,15,244,0,0,0,15,208,0,0,
  // 0x63a5  接
  165,99,36,37,77,38,1,251,0,31,192,0,0,15,208,0,0,0,31,192,0,0,15,208,0,0,0,31,192,0,0,15,208,0,0,0,31,192,0,0,15,208,0,0,0,31,192,63,255,255,255,255,244,0,31,192,63,255,255,255,255,244,0,31,192,63,255,255,255,255,244,21,111,213,0,63,0,2,252,0,63,255,255,64,63,64,3,248,0,63,255,255,64,47,128,3,240,0,63,255,255,64,31,192,7,240,0,0,31,192,0,15,192,15,208,0,0,31,192,0,15,192,15,192,0,0,31,192,255,255,255,255,255,253,0,31,192,255,255,255,255,255,253,0,31,192,255,255,255,255,255,253,0,31,192,0,0,254,0,0,0,0,31,219,64,2,252,0,0,0,0,47,255,128,3,248,0,0,0,27,255,255,255,255,255,255,255,252,255,255,248,255,255,255,255,255,252,191,255,192,255,255,255,255,255,252,127,111,192,0,63,128,3,252,0,16,31,192,0,127,0,3,244,0,0,31,192,0,254,0,7,240,0,0,31,192,1,253,0,15,240,0,0,31,192,3,255,144,47,208,0,0,31,192,7,255,253,127,192,0,0,31,192,7,255,255,255,64,0,0,31,192,0,81,255,255,0,0,0,31,192,0,0,47,255,224,0,0,31,192,0,6,255,255,254,0,21,111,192,6,191,255,75,255,208,31,255,194,255,255,244,0,191,244,15,255,64,255,254,64,0,15,224,15,249,0,250,64,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x63a7  控
  167,99,36,36,68,38,1,252,0,47,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,191,255,255,255,255,252,0,63,64,191,255,255,255,255,252,0,63,64,191,255,255,255,255,252,21,127,149,190,3,240,63,0,252,127,255,255,190,7,240,63,0,252,127,255,255,190,7,240,63,0,252,127,255,255,190,11,224,63,0,168,0,63,64,0,15,224,63,0,0,0,63,64,0,15,208,63,0,160,0,63,64,0,47,192,63,0,188,0,63,64,0,191,64,63,64,252,0,63,64,7,255,0,63,255,252,0,63,91,127,252,0,47,255,244,0,63,255,63,208,0,11,255,208,1,191,255,29,0,0,0,0,0,47,255,253,0,0,0,0,0,0,191,255,128,0,0,0,0,0,0,127,255,64,15,255,255,255,255,224,57,63,64,15,255,255,255,255,224,0,63,64,15,255,255,255,255,224,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,15,192,0,0,0,63,64,0,0,31,208,0,0,0,127,65,255,255,255,255,255,253,47,255,1,255,255,255,255,255,253,31,254,1,255,255,255,255,255,253,15,244,0,0,0,0,0,0,0,
  // 0x63d0  提
  208,99,36,36,68,38,1,252,0,63,0,0,0,0,0,0,0,0,63,0,6,170,170,170,170,64,0,63,0,7,255,255,255,255,128,0,63,0,7,255,255,255,255,128,0,63,0,7,240,0,0,47,128,0,63,0,7,240,0,0,47,128,0,63,0,7,245,85,85,127,128,21,127,85,7,255,255,255,255,128,127,255,255,7,255,255,255,255,128,127,255,255,7,240,0,0,47,128,127,255,255,7,240,0,0,47,128,0,63,0,7,250,170,170,191,128,0,63,0,7,255,255,255,255,128,0,63,0,7,255,255,255,255,128,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,6,63,255,255,255,255,248,0,63,255,127,255,255,255,255,248,1,191,255,127,255,255,255,255,248,127,255,254,0,0,15,192,0,0,191,255,144,1,80,15,192,0,0,127,255,0,3,244,15,192,0,0,57,63,0,3,240,15,192,0,0,0,63,0,7,240,15,255,255,192,0,63,0,11,224,15,255,255,192,0,63,0,15,240,15,255,255,128,0,63,0,15,244,15,192,0,0,0,63,0,47,252,15,192,0,0,0,63,0,63,191,15,192,0,0,0,63,0,191,47,223,192,0,0,0,63,1,253,15,255,208,0,0,63,255,7,252,3,255,255,255,254,31,255,15,240,0,191,255,255,252,15,248,3,208,0,6,255,255,252,0,0,0,64,0,0,0,0,0,
  // 0x63d2  插
  210,99,35,36,68,38,1,252,0,47,64,0,0,0,0,0,0,0,63,64,0,0,0,1,111,64,0,63,64,0,1,90,255,255,192,0,63,64,47,255,255,255,255,224,0,63,64,31,255,255,255,164,0,0,63,64,15,250,175,208,0,0,0,63,64,0,0,15,208,0,0,21,127,149,0,0,15,208,0,0,127,255,255,0,0,15,208,0,0,127,255,255,191,255,255,255,255,252,127,255,255,191,255,255,255,255,252,0,63,64,191,255,255,255,255,252,0,63,64,0,0,15,208,0,0,0,63,64,0,0,15,208,0,0,0,63,64,0,1,15,208,0,0,0,63,64,0,15,143,208,0,0,0,63,64,57,191,255,215,255,240,0,63,175,63,255,239,215,255,240,0,63,255,63,249,15,215,255,240,11,255,255,63,128,15,208,3,240,191,255,248,63,64,15,208,3,240,191,255,64,63,64,15,208,3,240,127,127,64,63,64,15,208,3,240,16,63,64,63,255,143,211,255,240,0,63,64,63,255,143,211,255,240,0,63,64,63,255,143,211,255,240,0,63,64,63,64,15,208,3,240,0,63,64,63,64,15,208,3,240,0,63,64,63,64,15,208,3,240,0,63,64,63,64,15,208,3,240,0,63,64,63,64,15,208,3,240,0,63,64,63,255,255,255,255,240,0,127,64,63,255,255,255,255,240,47,255,0,63,255,255,255,255,240,31,254,0,63,64,0,0,3,240,15,244,0,47,64,0,0,3,240,
  // 0x6536  收
  54,101,36,36,68,38,1,252,0,0,6,160,0,169,0,0,0,0,0,11,240,0,254,0,0,0,0,0,11,240,1,253,0,0,0,0,0,11,240,2,252,0,0,0,1,80,11,240,3,252,0,0,0,3,240,11,240,3,248,0,0,0,3,240,11,240,11,244,0,0,0,3,240,11,240,15,255,255,255,254,3,240,11,240,31,255,255,255,254,3,240,11,240,47,255,255,255,254,3,240,11,240,63,229,85,111,228,3,240,11,240,191,208,0,47,192,3,240,11,240,255,240,0,63,192,3,240,11,243,255,240,0,63,128,3,240,11,251,255,244,0,127,64,3,240,11,255,247,248,0,191,0,3,240,11,255,226,252,0,254,0,3,240,11,247,192,253,1,253,0,3,240,11,241,64,254,3,252,0,3,240,11,240,0,191,3,248,0,3,240,11,240,0,63,139,240,0,3,240,11,240,0,63,207,240,0,3,240,111,240,0,31,255,208,0,3,255,255,240,0,15,255,192,0,47,255,255,240,0,7,255,64,0,127,255,255,240,0,3,254,0,0,63,253,11,240,0,11,255,0,0,63,64,11,240,0,47,255,192,0,0,0,11,240,0,191,255,240,0,0,0,11,240,2,255,143,252,0,0,0,11,240,31,253,7,255,64,0,0,11,240,191,244,1,255,224,0,0,11,251,255,208,0,127,253,0,0,11,251,255,0,0,31,253,0,0,11,243,248,0,0,2,248,0,0,11,225,128,0,0,0,96,
  // 0x653e  放
  62,101,36,37,77,38,1,251,0,2,248,0,0,30,128,0,0,0,2,252,0,0,47,192,0,0,0,2,252,0,0,63,192,0,0,0,2,252,0,0,63,128,0,0,0,2,252,0,0,63,64,0,0,0,2,252,0,0,127,0,0,0,63,255,255,255,208,191,0,0,0,63,255,255,255,208,255,255,255,253,63,255,255,255,209,255,255,255,253,21,127,85,85,66,255,255,255,253,0,63,0,0,3,253,85,127,212,0,63,0,0,7,252,0,63,128,0,63,0,0,15,252,0,63,64,0,63,0,0,15,253,0,127,0,0,63,255,255,63,254,0,191,0,0,63,255,255,127,255,0,254,0,0,63,255,255,255,191,0,253,0,0,63,64,191,191,63,65,252,0,0,63,0,127,45,47,195,252,0,0,63,0,127,4,31,195,248,0,0,63,0,191,0,15,231,240,0,0,127,0,191,0,11,255,240,0,0,127,0,191,0,7,255,208,0,0,191,0,190,0,3,255,192,0,0,190,0,190,0,1,255,128,0,0,253,0,190,0,0,255,0,0,0,253,0,190,0,2,255,128,0,1,252,0,254,0,7,255,208,0,3,252,0,254,0,31,255,240,0,7,248,0,253,0,127,239,252,0,15,240,0,253,2,255,131,255,0,31,224,0,253,15,254,1,255,208,63,192,2,252,191,248,0,127,252,255,130,255,254,255,224,0,31,253,63,1,255,244,255,0,0,3,244,12,0,255,208,116,0,0,0,160,0,0,0,0,0,0,0,0,0,
  // 0x6570  数
  112,101,36,36,68,38,1,252,0,0,190,0,0,7,160,0,0,2,192,190,3,208,11,240,0,0,11,224,190,7,240,15,240,0,0,3,240,190,15,208,15,224,0,0,2,248,190,47,192,15,208,0,0,1,252,190,63,0,31,192,0,0,0,224,190,9,0,63,192,0,0,63,255,255,255,252,63,255,255,253,63,255,255,255,252,127,255,255,253,63,255,255,255,252,191,255,255,253,0,3,255,128,0,255,85,111,212,0,15,255,248,1,255,0,47,192,0,127,255,255,67,255,64,63,192,2,254,190,63,247,255,128,63,128,31,248,190,11,223,255,192,63,64,127,224,190,1,159,255,192,127,0,47,64,190,0,63,223,208,191,0,8,2,253,0,63,143,224,254,0,0,3,244,0,15,11,241,253,0,0,11,240,0,1,7,246,252,0,127,255,255,255,252,3,251,252,0,127,255,255,255,252,2,255,244,0,127,255,255,255,252,1,255,240,0,0,191,0,127,0,0,255,224,0,0,253,0,254,0,0,191,192,0,2,252,0,253,0,0,191,192,0,3,255,66,252,0,1,255,224,0,15,255,251,248,0,7,255,240,0,11,239,255,240,0,15,255,252,0,0,66,255,240,0,127,243,255,0,0,1,255,254,1,255,192,255,192,0,31,255,255,223,255,0,127,244,27,255,244,191,255,252,0,47,253,63,255,128,31,255,240,0,7,252,31,248,0,2,47,128,0,1,240,10,0,0,0,8,0,0,0,16,
  // 0x6572  敲
  114,101,36,36,68,38,1,252,0,0,253,0,0,1,252,0,0,0,0,253,0,0,1,252,0,0,0,0,253,0,0,1,252,0,0,0,0,253,0,0,1,252,0,0,63,255,255,255,252,1,252,0,0,127,255,255,255,252,1,255,255,252,127,255,255,255,252,1,255,255,252,0,0,0,0,0,1,255,255,252,0,0,0,0,0,1,253,0,0,0,255,255,255,0,1,252,0,0,0,255,255,255,0,1,252,0,0,0,253,85,191,0,1,252,0,0,0,252,0,127,0,1,252,0,0,0,252,0,127,15,255,255,255,224,0,253,85,191,15,255,255,255,240,0,255,255,255,15,255,255,255,240,0,255,255,255,0,24,0,15,224,0,0,0,0,0,252,0,15,208,0,0,0,0,0,253,0,47,192,31,255,255,255,240,190,0,63,192,31,255,255,255,240,63,0,63,64,31,234,170,171,240,63,128,191,0,31,128,0,3,240,31,192,254,0,31,139,255,195,240,15,227,252,0,31,139,255,195,240,7,251,252,0,31,139,67,195,240,3,255,240,0,31,139,67,195,240,1,255,224,0,31,139,67,195,240,0,255,192,0,31,139,67,195,240,1,255,208,0,31,139,255,195,240,11,255,248,0,31,139,255,195,240,47,255,254,0,31,139,64,3,241,255,226,255,208,31,134,0,3,255,255,64,127,253,31,128,0,255,251,253,0,31,252,31,128,0,255,211,224,0,2,244,10,64,0,85,1,0,0,0,16,
  // 0x6574  整
  116,101,34,35,59,38,2,253,0,2,244,0,0,14,64,0,0,0,2,244,0,0,31,192,0,0,85,87,249,85,80,63,128,0,0,191,255,255,255,224,63,64,0,0,191,255,255,255,224,191,255,255,240,0,2,244,0,0,255,255,255,240,0,2,248,0,2,255,255,255,240,47,255,255,255,199,252,0,253,0,47,255,255,255,223,253,1,252,0,47,2,244,15,255,255,2,248,0,47,2,244,15,255,127,67,240,0,47,66,248,31,206,31,207,240,0,47,255,255,255,192,11,255,192,0,47,255,255,255,192,3,255,64,0,0,47,255,64,0,2,255,0,0,0,255,255,244,0,31,255,224,0,7,254,250,255,64,191,239,253,0,111,226,244,127,159,255,67,255,224,255,130,244,11,63,248,0,191,240,60,2,244,0,31,128,0,11,208,0,0,80,0,4,0,0,0,64,11,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,254,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,15,192,3,248,0,0,0,0,0,15,192,3,255,255,255,192,0,0,15,192,3,255,255,255,192,0,0,15,192,3,254,170,170,128,0,0,15,192,3,248,0,0,0,0,0,15,192,3,248,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x6599  料
  153,101,36,36,68,38,1,252,0,2,160,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,0,7,240,20,0,0,1,252,0,63,7,240,63,2,208,1,252,0,47,7,240,126,3,252,1,252,0,31,71,240,189,3,255,65,252,0,15,135,240,252,0,191,209,252,0,15,199,240,252,0,31,241,252,0,11,199,241,244,0,3,209,252,0,7,215,242,240,0,0,129,252,0,7,215,243,224,0,0,1,252,0,3,71,241,208,0,0,1,252,0,0,7,240,0,8,0,1,252,0,63,255,255,255,47,64,1,252,0,63,255,255,255,127,240,1,252,0,63,255,255,255,31,253,1,252,0,21,111,245,85,2,255,65,252,0,0,63,248,0,0,127,1,252,0,0,63,253,0,0,29,1,252,0,0,191,255,64,0,0,1,252,0,0,255,255,192,0,0,1,252,0,1,251,251,240,0,0,1,253,188,3,247,243,248,0,0,27,255,253,7,231,241,253,0,111,255,255,254,15,215,240,253,191,255,255,255,228,31,199,240,116,255,255,255,252,0,63,71,240,16,255,249,65,252,0,191,7,240,0,164,0,1,252,0,126,7,240,0,0,0,1,252,0,60,7,240,0,0,0,1,252,0,20,7,240,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,0,7,240,0,0,0,1,252,0,
  // 0x659c  斜
  156,101,36,36,68,38,1,252,0,0,255,0,0,0,0,127,0,0,2,255,192,0,0,0,127,0,0,3,255,240,0,0,0,127,0,0,11,255,253,0,30,0,127,0,0,31,227,255,64,191,128,127,0,0,63,192,255,208,63,240,127,0,0,191,64,63,240,11,252,127,0,2,254,0,15,252,2,254,127,0,7,252,0,3,240,0,190,191,0,31,240,0,1,208,0,56,127,0,127,255,255,255,128,0,0,127,0,255,255,255,255,128,0,0,127,0,61,255,255,255,128,112,0,127,0,20,0,127,0,1,253,0,127,0,0,0,127,0,2,255,64,127,0,0,0,127,0,0,127,208,127,0,0,0,127,0,0,31,244,127,0,63,255,255,255,248,7,252,127,0,63,255,255,255,248,1,240,127,0,63,255,255,255,248,0,64,127,0,0,0,127,0,0,0,0,127,0,0,0,127,0,0,0,0,127,253,1,144,127,7,64,0,6,255,254,3,248,127,31,192,27,255,255,254,3,240,127,15,199,255,255,255,228,7,240,127,11,227,255,255,255,0,11,224,127,3,243,255,144,127,0,15,208,127,3,246,144,0,127,0,47,192,127,2,252,0,0,127,0,63,64,127,0,252,0,0,127,0,191,0,127,0,244,0,0,127,0,45,0,127,0,0,0,0,127,0,4,0,191,0,0,0,0,127,0,0,63,255,0,0,0,0,127,0,0,63,253,0,0,0,0,127,0,0,47,228,0,0,0,0,127,0,
  // 0x65ad  断
  173,101,34,37,77,38,3,251,0,0,21,0,0,0,0,0,0,168,0,63,0,0,0,0,125,0,252,0,63,0,0,0,27,255,64,252,120,63,15,133,11,255,255,128,252,188,63,15,203,255,255,228,0,252,61,63,31,75,255,249,0,0,252,62,63,47,11,249,0,0,0,252,47,63,62,11,224,0,0,0,252,47,63,124,11,224,0,0,0,252,30,63,120,11,224,0,0,0,252,0,63,0,11,224,0,0,0,252,0,63,0,11,224,0,0,0,252,255,255,255,203,224,0,0,0,252,255,255,255,203,255,255,255,224,252,255,255,255,203,255,255,255,224,252,0,191,0,11,255,255,255,224,252,0,255,64,11,245,91,245,64,252,2,255,208,11,224,11,240,0,252,3,255,248,15,224,11,240,0,252,11,255,254,15,224,11,240,0,252,31,127,63,143,224,11,240,0,252,63,63,31,79,208,11,240,0,252,253,63,10,15,208,11,240,0,254,252,63,0,15,192,11,240,0,253,240,63,0,31,192,11,240,0,252,144,63,0,31,192,11,240,0,252,0,63,0,47,192,11,240,0,252,0,63,0,63,128,11,240,0,252,0,0,0,127,0,11,240,0,255,255,255,255,255,0,11,240,0,255,255,255,255,254,0,11,240,0,255,255,255,255,252,0,11,240,0,252,0,0,7,248,0,11,240,0,252,0,0,15,240,0,11,240,0,252,0,0,11,208,0,11,240,0,0,0,0,2,128,0,11,240,0,0,0,0,0,0,0,0,0,0,
  // 0x65b0  新
  176,101,36,36,68,38,1,252,0,0,169,0,0,0,0,0,0,0,0,253,0,0,0,0,27,208,0,0,253,0,0,0,6,255,244,0,0,253,0,0,145,191,255,244,47,255,255,255,241,255,255,254,0,47,255,255,255,241,255,254,64,0,47,255,255,255,241,254,64,0,0,0,180,0,57,1,252,0,0,0,1,248,0,127,1,252,0,0,0,0,252,0,189,1,252,0,0,0,0,189,0,252,1,252,0,0,0,0,126,1,248,1,252,0,0,0,0,121,1,180,1,252,0,0,0,63,255,255,255,249,255,255,255,253,63,255,255,255,249,255,255,255,253,63,255,255,255,249,255,255,255,253,0,0,253,0,1,253,85,254,84,0,0,253,0,1,252,0,253,0,0,0,253,0,1,252,0,253,0,63,255,255,255,241,252,0,253,0,63,255,255,255,241,252,0,253,0,63,255,255,255,242,252,0,253,0,0,3,254,0,2,248,0,253,0,0,11,255,64,3,248,0,253,0,0,15,255,224,3,244,0,253,0,0,63,255,252,3,240,0,253,0,0,255,255,255,7,240,0,253,0,2,252,253,127,207,240,0,253,0,11,244,253,31,79,208,0,253,0,47,240,253,10,47,192,0,253,0,191,192,253,0,63,128,0,253,0,63,0,253,0,255,0,0,253,0,12,0,253,2,254,0,0,253,0,0,0,253,3,252,0,0,253,0,0,0,253,0,244,0,0,253,0,0,0,253,0,32,0,0,169,0,
  // 0x65b9  方
  185,101,34,37,77,38,2,251,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,85,85,85,87,253,85,85,85,80,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,255,255,255,255,224,0,0,0,7,255,255,255,255,208,0,0,0,11,255,255,255,255,208,0,0,0,15,245,85,85,111,208,0,0,0,15,240,0,0,31,208,0,0,0,31,224,0,0,31,192,0,0,0,47,208,0,0,47,192,0,0,0,63,192,0,0,47,192,0,0,0,127,128,0,0,47,192,0,0,0,255,64,0,0,63,192,0,0,2,255,0,0,0,63,128,0,0,7,253,0,0,0,63,128,0,0,15,252,0,0,0,63,64,0,0,63,240,0,0,0,127,64,0,0,255,208,0,0,0,191,0,0,7,255,128,0,0,0,255,0,0,47,254,0,1,84,7,254,0,0,255,244,0,0,255,255,252,0,0,127,208,0,0,255,255,248,0,0,46,0,0,0,191,255,208,0,0,0,0,0,0,0,0,0,0,0,
  // 0x65e0  无
  224,101,35,34,50,38,2,252,1,85,85,85,85,85,85,85,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,111,229,85,85,85,80,0,0,0,31,192,0,0,0,0,0,0,0,47,239,192,0,0,0,0,0,0,63,239,192,0,0,0,0,0,0,127,111,192,0,0,0,0,0,0,191,47,192,0,0,0,0,0,0,255,47,192,0,0,0,0,0,2,253,47,192,0,0,0,0,0,7,252,47,192,0,0,0,0,0,15,244,47,192,0,2,64,0,0,63,240,47,192,0,3,244,0,0,255,192,47,192,0,3,248,0,7,255,0,47,192,0,3,244,0,47,253,0,47,192,0,3,244,2,255,240,0,47,208,0,11,240,127,255,192,0,31,255,255,255,240,255,253,0,0,15,255,255,255,208,63,208,0,0,7,255,255,255,128,25,0,0,0,0,85,85,84,0,
  // 0x65f6  时
  246,101,34,36,68,38,3,252,0,0,0,0,0,0,10,128,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,255,255,255,64,0,0,31,192,0,255,255,255,64,0,0,31,192,0,255,255,255,64,0,0,31,192,0,253,0,63,64,0,0,31,192,0,253,0,63,69,85,85,111,229,64,253,0,63,79,255,255,255,255,208,253,0,63,79,255,255,255,255,208,253,0,63,79,255,255,255,255,208,253,0,63,64,0,0,31,192,0,253,0,63,64,0,0,31,192,0,253,0,63,64,0,0,31,192,0,255,255,255,64,176,0,31,192,0,255,255,255,67,252,0,31,192,0,255,255,255,65,254,0,31,192,0,253,0,63,64,255,0,31,192,0,253,0,63,64,127,192,31,192,0,253,0,63,64,47,208,31,192,0,253,0,63,64,15,240,31,192,0,253,0,63,64,11,248,31,192,0,253,0,63,64,3,252,31,192,0,253,0,63,64,1,248,31,192,0,253,0,63,64,0,208,31,192,0,253,0,63,64,0,0,31,192,0,255,255,255,64,0,0,31,192,0,255,255,255,64,0,0,31,192,0,255,255,255,64,0,0,31,192,0,253,0,0,0,0,0,31,192,0,253,0,0,0,0,0,31,192,0,253,0,0,0,0,0,47,192,0,0,0,0,0,11,255,255,192,0,0,0,0,0,3,255,255,192,0,0,0,0,0,3,255,254,0,0,0,0,0,0,1,85,80,0,0,
  // 0x660e  明
  14,102,33,36,68,38,3,251,0,0,0,0,85,85,85,85,0,0,0,0,0,255,255,255,255,64,255,255,255,128,255,255,255,255,64,255,255,255,128,255,255,255,255,64,255,255,255,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,255,255,255,255,64,255,255,255,128,255,255,255,255,64,255,255,255,128,255,255,255,255,64,255,255,255,128,253,0,0,127,64,253,0,47,128,253,0,0,63,64,253,0,47,128,253,0,0,63,64,253,0,47,128,252,0,0,63,64,253,0,47,129,252,0,0,63,64,253,0,47,129,252,0,0,63,64,253,0,47,129,255,255,255,255,64,253,0,47,130,255,255,255,255,64,255,255,255,130,255,255,255,255,64,255,255,255,131,248,0,0,127,64,255,255,255,131,244,0,0,63,64,254,85,85,7,240,0,0,63,64,253,0,0,15,240,0,0,63,64,253,0,0,15,208,0,0,63,64,253,0,0,63,192,0,0,63,64,0,0,0,127,128,0,0,63,64,0,0,0,255,64,0,0,63,64,0,0,2,254,0,0,0,63,64,0,0,11,252,0,1,85,191,0,0,0,47,244,0,3,255,255,0,0,0,31,208,0,2,255,254,0,0,0,7,64,0,1,255,228,0,0,0,0,0,0,0,0,0,0,
  // 0x662f  是
  47,102,36,36,68,38,1,251,0,42,170,170,170,170,170,164,0,0,63,255,255,255,255,255,248,0,0,63,255,255,255,255,255,248,0,0,63,128,0,0,0,3,248,0,0,63,128,0,0,0,3,248,0,0,63,128,0,0,0,3,248,0,0,63,255,255,255,255,255,248,0,0,63,255,255,255,255,255,248,0,0,63,213,85,85,85,87,248,0,0,63,128,0,0,0,3,248,0,0,63,128,0,0,0,3,248,0,0,63,255,255,255,255,255,248,0,0,63,255,255,255,255,255,248,0,0,42,170,170,170,170,170,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,47,255,255,255,255,255,255,255,248,0,0,0,0,127,0,0,0,0,0,1,164,0,127,0,0,0,0,0,3,252,0,127,0,0,0,0,0,3,248,0,127,0,0,0,0,0,7,244,0,127,255,255,255,0,0,11,240,0,127,255,255,255,0,0,15,248,0,127,255,255,255,0,0,47,253,0,127,0,0,0,0,0,63,255,0,127,0,0,0,0,0,191,191,208,127,0,0,0,0,1,255,31,248,127,0,0,0,0,7,252,11,255,255,0,0,0,0,31,248,1,255,255,255,255,255,253,127,224,0,47,255,255,255,255,252,47,128,0,1,191,255,255,255,248,10,0,0,0,0,5,85,85,80,0,0,0,0,0,0,0,0,0,
  // 0x6682  暂
  130,102,34,37,77,38,2,251,0,11,144,0,0,0,0,5,0,0,15,240,0,0,0,22,255,0,170,191,250,170,145,191,255,255,192,255,255,255,255,226,255,255,249,0,255,255,255,255,226,254,148,0,0,1,252,0,0,2,244,0,0,0,3,244,42,0,2,244,0,0,0,11,224,63,0,2,244,0,0,0,47,192,63,0,2,244,0,0,0,127,255,255,255,242,255,255,255,240,63,255,255,255,242,255,255,255,240,63,255,255,255,226,255,255,255,240,0,0,63,0,3,244,7,240,0,0,0,63,0,3,240,7,240,0,0,5,191,255,215,240,7,240,0,191,255,255,255,219,224,7,240,0,191,255,255,250,79,208,7,240,0,191,169,127,0,47,192,7,240,0,0,0,63,0,63,128,7,240,0,0,0,63,0,31,0,7,240,0,0,0,21,0,1,0,1,80,0,0,106,170,170,170,170,170,144,0,0,127,255,255,255,255,255,224,0,0,127,255,255,255,255,255,224,0,0,127,0,0,0,0,15,224,0,0,127,0,0,0,0,15,224,0,0,127,85,85,85,85,95,224,0,0,127,255,255,255,255,255,224,0,0,127,255,255,255,255,255,224,0,0,127,0,0,0,0,15,224,0,0,127,0,0,0,0,15,224,0,0,127,0,0,0,0,15,224,0,0,127,255,255,255,255,255,224,0,0,127,255,255,255,255,255,224,0,0,127,255,255,255,255,255,224,0,0,127,0,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,
  // 0x66ab  暫
  171,102,34,36,68,38,2,252,0,1,244,0,0,0,0,4,0,0,2,244,0,0,0,6,254,0,0,2,248,0,3,150,255,255,128,191,255,255,255,211,255,255,253,0,191,255,255,255,211,255,250,64,0,0,2,244,0,3,245,0,0,0,47,255,255,255,131,240,0,0,0,47,171,254,175,131,240,0,0,0,47,2,244,15,131,240,0,0,0,47,171,254,175,131,255,255,255,240,47,255,255,255,135,255,255,255,240,47,2,244,15,135,255,255,255,240,47,171,254,191,139,224,11,224,0,47,255,255,255,143,208,11,224,0,0,2,244,0,15,192,11,224,0,0,2,248,0,47,192,11,224,0,255,255,255,255,255,64,11,224,0,255,255,255,255,255,0,11,224,0,0,2,244,2,253,0,11,224,0,0,2,244,0,180,0,11,224,0,0,1,80,0,16,0,1,80,0,0,42,170,170,170,170,170,128,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,128,0,0,0,63,192,0,0,47,128,0,0,0,63,192,0,0,47,213,85,85,85,127,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,128,0,0,0,63,192,0,0,47,128,0,0,0,63,192,0,0,47,128,0,0,0,63,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,128,0,0,0,47,128,0,
  // 0x66f4  更
  244,102,35,34,50,38,2,252,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,0,0,0,2,253,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,253,0,2,252,0,1,252,0,0,253,0,2,252,0,1,252,0,0,253,0,2,252,0,1,252,0,0,255,170,171,255,170,171,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,253,0,2,252,0,1,252,0,0,253,0,2,252,0,1,252,0,0,253,0,2,252,0,1,252,0,0,253,0,2,252,0,1,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,7,64,7,244,0,0,0,0,0,63,192,15,240,0,0,0,0,0,15,244,31,224,0,0,0,0,0,7,253,127,192,0,0,0,0,0,1,255,255,64,0,0,0,0,0,0,127,255,0,0,0,0,0,0,1,191,255,228,0,0,0,0,0,111,255,255,255,250,84,0,0,111,255,254,27,255,255,255,255,244,191,255,208,0,111,255,255,255,240,63,249,0,0,0,107,255,255,224,9,0,0,0,0,0,0,85,64,
  // 0x6700  最
  0,103,34,35,59,38,2,252,0,21,85,85,85,85,85,64,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,63,0,0,0,0,15,208,0,0,63,0,0,0,0,15,208,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,63,64,0,0,0,31,208,0,0,63,0,0,0,0,15,208,0,0,63,85,85,85,85,95,208,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,2,248,0,127,0,0,0,0,0,2,248,0,127,0,0,0,0,0,2,255,255,255,63,255,255,254,0,2,255,255,255,63,255,255,255,0,2,254,170,191,43,250,170,255,0,2,248,0,127,3,240,0,253,0,2,248,0,127,3,244,3,252,0,2,255,255,255,1,252,7,244,0,2,255,255,255,0,255,31,240,0,2,254,170,191,0,63,191,192,0,2,248,0,127,0,47,255,64,0,2,248,0,191,0,15,254,0,0,6,255,255,255,0,47,255,64,0,255,255,255,255,1,255,255,224,0,255,255,255,255,31,255,111,254,64,254,148,0,127,255,248,3,255,240,0,0,0,127,63,128,0,127,208,0,0,0,127,24,0,0,6,128,
  // 0x6709  有
  9,103,34,37,77,38,2,251,0,0,0,164,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,21,85,127,213,85,85,85,85,64,0,0,127,128,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,3,255,255,255,255,255,208,0,0,15,255,255,255,255,255,208,0,0,31,255,255,255,255,255,208,0,0,63,252,0,0,0,31,208,0,0,255,252,0,0,0,15,208,0,3,255,252,0,0,0,15,208,0,15,254,252,0,0,0,15,208,0,63,242,255,255,255,255,255,208,0,255,210,255,255,255,255,255,208,0,255,2,255,255,255,255,255,208,0,60,2,252,0,0,0,15,208,0,0,2,252,0,0,0,15,208,0,0,2,252,0,0,0,15,208,0,0,2,255,255,255,255,255,208,0,0,2,255,255,255,255,255,208,0,0,2,255,255,255,255,255,208,0,0,2,252,0,0,0,15,208,0,0,2,252,0,0,0,15,208,0,0,2,252,0,0,0,15,208,0,0,2,252,0,0,0,15,208,0,0,2,252,0,0,85,111,192,0,0,2,252,0,0,255,255,192,0,0,2,252,0,0,127,255,128,0,0,2,252,0,0,63,249,0,0,0,0,0,0,0,0,0,0,0,
  // 0x671f  期
  31,103,34,37,77,38,1,251,0,84,0,21,0,0,0,0,0,0,253,0,63,64,0,0,0,0,0,253,0,63,64,63,255,255,240,0,253,0,63,64,63,255,255,240,0,253,0,63,64,63,255,255,240,63,255,255,255,252,63,64,7,240,63,255,255,255,252,63,0,3,240,63,255,255,255,252,63,0,3,240,0,253,0,63,128,63,0,3,240,0,253,0,63,64,63,0,3,240,0,253,0,63,64,63,0,7,240,0,255,255,255,64,63,255,255,240,0,255,255,255,64,63,255,255,240,0,255,255,255,64,63,255,255,240,0,253,0,63,64,63,0,3,240,0,253,0,63,64,63,0,3,240,0,253,0,63,64,63,0,3,240,0,255,255,255,64,127,0,3,240,0,255,255,255,64,127,0,3,240,0,255,255,255,64,127,0,7,240,0,253,0,63,64,127,255,255,240,0,253,0,63,64,127,255,255,240,0,253,0,63,64,127,255,255,240,127,255,255,255,252,190,0,3,240,127,255,255,255,252,190,0,3,240,127,255,255,255,252,254,0,3,240,0,0,0,16,0,253,0,3,240,0,62,64,180,0,252,0,3,240,0,127,66,252,1,252,0,3,240,0,255,0,255,2,252,0,3,240,2,253,0,127,131,248,0,3,240,7,248,0,47,199,244,0,3,240,31,240,0,15,239,240,5,91,240,127,208,0,11,95,224,15,255,240,31,128,0,0,11,192,11,255,224,2,0,0,0,2,128,7,254,64,0,0,0,0,0,0,0,0,0,
  // 0x673a  机
  58,103,36,36,68,38,1,252,0,2,164,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,5,85,85,80,0,0,3,244,0,31,255,255,248,0,0,3,244,0,31,255,255,248,0,0,3,244,0,31,255,255,248,0,0,3,244,0,31,192,2,248,0,0,3,244,0,31,192,2,248,0,63,255,255,254,31,192,2,248,0,63,255,255,254,31,192,2,248,0,63,255,255,254,31,192,2,248,0,21,91,249,84,31,192,2,248,0,0,15,244,0,31,192,2,248,0,0,15,244,0,31,192,2,248,0,0,31,248,0,31,192,2,248,0,0,47,253,0,31,192,2,248,0,0,63,255,64,31,192,2,248,0,0,191,255,192,31,192,2,248,0,0,255,255,240,31,192,2,248,0,1,251,247,252,31,192,2,248,0,3,243,244,254,47,192,2,248,0,7,227,244,190,63,128,2,248,0,15,211,244,60,63,128,2,248,0,47,195,244,16,63,64,2,248,0,127,67,244,0,63,0,2,248,0,191,3,244,0,191,0,2,248,20,61,3,244,0,255,0,2,248,31,40,3,244,0,254,0,2,248,47,0,3,244,2,252,0,2,248,47,0,3,244,3,252,0,2,248,47,0,3,244,11,244,0,2,248,47,0,3,244,31,240,0,2,252,63,0,3,244,63,208,0,2,255,254,0,3,244,127,128,0,1,255,253,0,3,244,31,0,0,0,191,248,0,2,164,4,0,0,0,0,0,
  // 0x6740  杀
  64,103,34,36,68,38,2,252,0,0,0,0,0,0,13,0,0,0,36,0,0,0,0,127,128,0,0,255,128,0,0,2,255,192,0,1,255,249,0,0,31,254,0,0,0,47,255,208,0,191,244,0,0,0,1,255,254,7,255,192,0,0,0,0,31,255,255,253,0,0,0,0,0,1,191,255,240,0,0,0,0,0,0,127,255,240,0,0,0,0,0,7,255,255,254,0,0,0,0,0,191,255,139,255,224,0,0,0,27,255,248,0,191,254,0,0,6,255,255,64,0,15,255,224,0,127,255,244,0,0,1,255,252,0,47,254,64,1,84,0,31,244,0,15,208,0,3,252,0,2,208,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,3,228,3,252,0,180,0,0,0,11,248,3,252,3,253,0,0,0,31,240,3,252,1,255,64,0,0,127,192,3,252,0,127,224,0,1,255,64,3,252,0,31,248,0,7,253,0,3,252,0,3,254,0,47,248,0,3,252,0,0,255,64,255,208,0,3,252,0,0,127,208,191,64,5,87,252,0,0,31,208,45,0,7,255,252,0,0,10,0,0,0,3,255,244,0,0,0,0,0,0,2,255,128,0,0,0,0,
  // 0x675f  束
  95,103,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,21,85,85,87,253,85,85,85,64,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,1,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,248,0,1,252,0,3,252,0,3,248,0,1,252,0,3,252,0,3,248,0,1,252,0,3,252,0,3,248,0,1,252,0,3,252,0,3,248,0,1,252,0,3,252,0,3,248,0,1,252,0,3,252,0,3,248,0,1,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,248,0,0,0,0,127,255,208,0,0,0,0,0,1,255,255,244,0,0,0,0,0,7,255,255,253,0,0,0,0,0,47,247,252,255,128,0,0,0,1,255,211,252,63,244,0,0,0,11,255,3,252,15,254,0,0,0,127,252,3,252,3,255,224,0,7,255,224,3,252,0,191,254,0,191,255,64,3,252,0,31,255,224,255,248,0,3,252,0,2,255,240,63,128,0,3,252,0,0,47,192,24,0,0,3,252,0,0,2,64,0,0,0,3,248,0,0,0,0,
  // 0x6761  条
  97,103,34,36,68,38,2,252,0,0,0,164,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,63,255,255,255,248,0,0,0,0,255,255,255,255,254,0,0,0,3,255,255,255,255,252,0,0,0,31,255,0,0,15,244,0,0,0,191,255,192,0,63,224,0,0,7,255,175,240,0,255,192,0,0,63,253,11,253,7,255,0,0,0,15,240,2,255,175,248,0,0,0,7,64,0,127,255,224,0,0,0,0,0,0,47,255,192,0,0,0,0,0,1,255,255,253,0,0,0,0,0,111,255,255,255,244,0,0,0,91,255,253,2,255,255,249,64,111,255,255,208,0,47,255,255,240,127,255,248,2,248,1,191,255,208,63,254,64,3,248,0,1,191,128,30,64,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,1,255,255,244,0,0,0,0,0,7,255,255,253,0,0,0,0,0,47,243,248,255,128,0,0,0,1,255,195,248,63,244,0,0,0,11,254,3,248,15,255,64,0,0,191,248,3,248,2,255,244,0,27,255,208,3,248,0,127,255,128,255,254,0,3,248,0,7,255,240,191,224,0,3,248,0,0,191,208,62,0,0,3,248,0,0,7,128,0,0,0,3,248,0,0,0,0,
  // 0x6765  来
  101,103,36,36,68,38,1,252,0,0,0,0,170,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,1,85,85,85,255,85,85,85,64,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,0,0,64,0,255,0,1,64,0,0,11,224,0,255,0,3,248,0,0,11,240,0,255,0,11,244,0,0,3,248,0,255,0,15,240,0,0,2,252,0,255,0,47,208,0,0,0,254,0,255,0,63,192,0,0,0,191,0,255,0,191,0,0,0,0,127,0,255,0,254,0,0,0,0,36,0,255,0,44,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,21,85,85,111,255,249,85,85,84,0,0,0,63,255,252,0,0,0,0,0,0,255,255,255,0,0,0,0,0,2,253,255,127,192,0,0,0,0,15,248,255,47,240,0,0,0,0,63,240,255,15,252,0,0,0,0,255,192,255,3,255,0,0,0,7,255,0,255,0,255,208,0,0,47,252,0,255,0,63,248,0,1,255,224,0,255,0,15,255,64,31,255,128,0,255,0,2,255,244,127,253,0,0,255,0,0,127,253,47,224,0,0,255,0,0,15,248,15,64,0,0,255,0,0,1,240,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,
  // 0x677f  板
  127,103,36,36,68,38,1,252,0,7,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,11,224,0,21,85,85,85,80,0,11,224,0,255,255,255,255,252,0,11,224,0,255,255,255,255,252,0,11,224,0,255,255,255,255,252,0,11,224,0,254,0,0,0,0,0,11,224,0,254,0,0,0,0,63,255,255,244,254,0,0,0,0,63,255,255,244,254,0,0,0,0,63,255,255,244,254,0,0,0,0,21,95,245,80,254,0,0,0,0,0,31,224,0,255,255,255,255,224,0,47,224,0,255,255,255,255,244,0,63,240,0,255,255,255,255,240,0,63,252,0,255,248,0,11,240,0,191,254,0,255,252,0,15,224,0,255,255,64,254,252,0,31,208,1,255,255,192,253,254,0,47,192,2,251,235,240,253,127,0,63,128,3,235,227,249,252,63,64,127,64,11,219,225,245,252,47,192,255,0,15,203,224,225,252,31,209,254,0,47,139,224,66,252,15,243,252,0,127,11,224,3,248,7,251,248,0,190,11,224,3,244,3,255,240,0,60,11,224,7,240,0,255,208,0,40,11,224,11,240,0,255,192,0,0,11,224,15,224,2,255,224,0,0,11,224,31,208,11,255,248,0,0,11,224,63,192,47,251,254,0,0,11,224,127,129,255,209,255,208,0,11,224,255,11,255,64,127,253,0,11,225,254,15,253,0,31,253,0,11,224,124,7,224,0,2,244,0,11,224,4,2,64,0,0,96,
  // 0x6797  林
  151,103,36,36,68,38,1,252,0,1,252,0,0,0,190,0,0,0,1,252,0,0,0,254,0,0,0,1,252,0,0,0,254,0,0,0,1,252,0,0,0,254,0,0,0,1,252,0,0,0,254,0,0,0,1,252,0,0,0,254,0,0,0,1,252,0,0,0,254,0,0,0,1,252,0,0,0,254,0,0,21,86,253,85,5,85,255,85,80,63,255,255,255,31,255,255,255,248,63,255,255,255,31,255,255,255,248,63,255,255,255,31,255,255,255,248,0,3,252,0,0,2,255,128,0,0,7,254,0,0,3,255,192,0,0,15,255,128,0,7,255,208,0,0,15,255,224,0,15,255,224,0,0,47,255,244,0,15,255,240,0,0,63,254,253,0,47,255,248,0,0,127,252,255,0,63,255,252,0,0,254,252,127,192,191,254,253,0,1,249,252,47,64,253,254,127,0,3,245,252,14,3,252,254,63,64,11,241,252,4,7,244,254,47,192,15,209,252,0,15,240,254,15,208,63,193,252,0,63,208,254,15,240,191,65,252,0,191,128,254,7,252,127,1,252,2,255,0,254,3,254,44,1,252,3,253,0,254,0,252,20,1,252,0,248,0,254,0,176,0,1,252,0,160,0,254,0,0,0,1,252,0,0,0,254,0,0,0,1,252,0,0,0,254,0,0,0,1,252,0,0,0,254,0,0,0,1,252,0,0,0,254,0,0,0,1,252,0,0,0,254,0,0,0,1,252,0,0,0,190,0,0,
  // 0x67f1  柱
  241,103,36,36,68,38,1,252,0,3,240,0,0,28,0,0,0,0,3,240,0,0,191,64,0,0,0,3,240,0,0,255,224,0,0,0,3,240,0,0,47,252,0,0,0,3,240,0,0,7,255,0,0,0,3,240,0,0,0,255,192,0,0,3,240,0,0,0,63,128,0,0,3,240,0,85,85,95,85,84,63,255,255,252,255,255,255,255,252,63,255,255,252,255,255,255,255,252,63,255,255,252,255,255,255,255,252,21,95,245,84,0,1,253,0,0,0,15,240,0,0,1,253,0,0,0,15,240,0,0,1,253,0,0,0,47,244,0,0,1,253,0,0,0,63,252,0,0,1,253,0,0,0,63,255,0,0,1,253,0,0,0,191,255,192,0,1,253,0,0,0,255,255,224,0,1,253,0,0,1,251,247,244,63,255,255,255,248,3,243,242,253,63,255,255,255,248,7,227,240,253,63,255,255,255,248,15,211,240,120,21,86,254,85,80,47,195,240,32,0,1,253,0,0,63,67,240,0,0,1,253,0,0,191,3,240,0,0,1,253,0,0,61,3,240,0,0,1,253,0,0,40,3,240,0,0,1,253,0,0,0,3,240,0,0,1,253,0,0,0,3,240,0,0,1,253,0,0,0,3,240,0,0,1,253,0,0,0,3,240,15,255,255,255,255,254,0,3,240,15,255,255,255,255,254,0,3,240,15,255,255,255,255,254,0,3,240,5,85,85,85,85,84,0,2,160,0,0,0,0,0,0,
  // 0x6821  校
  33,104,36,36,68,38,1,252,0,6,144,0,0,2,160,0,0,0,11,224,0,0,3,244,0,0,0,11,224,0,0,3,244,0,0,0,11,224,0,0,3,244,0,0,0,11,224,0,0,3,244,0,0,0,11,224,1,85,87,249,85,84,0,11,224,11,255,255,255,255,252,0,11,224,11,255,255,255,255,252,63,255,250,171,255,255,255,255,252,63,255,255,240,0,0,0,0,0,63,255,255,240,7,128,0,180,0,21,95,229,80,15,240,3,252,0,0,31,224,0,31,208,0,255,0,0,47,224,0,63,192,0,127,192,0,63,240,0,255,64,0,47,224,0,63,248,2,254,0,0,15,244,0,191,253,11,252,0,1,67,252,0,255,255,31,251,192,3,253,253,1,255,255,139,207,224,3,248,248,2,255,239,210,7,240,7,244,64,3,235,231,240,3,248,15,240,0,11,219,226,240,2,252,31,224,0,15,203,224,208,0,254,63,192,0,47,139,224,64,0,191,191,64,0,63,11,224,0,0,63,255,0,0,190,11,224,0,0,31,253,0,0,61,11,224,0,0,15,252,0,0,40,11,224,0,0,47,254,0,0,0,11,224,0,0,191,255,128,0,0,11,224,0,2,255,191,240,0,0,11,224,0,31,253,31,253,0,0,11,224,0,191,244,7,255,208,0,11,224,27,255,192,1,255,253,0,11,224,63,253,0,0,63,252,0,11,224,31,224,0,0,11,244,0,11,208,10,0,0,0,0,160,
  // 0x683c  格
  60,104,36,36,68,38,1,252,0,11,224,0,0,121,0,0,0,0,11,224,0,0,255,0,0,0,0,11,224,0,0,254,0,0,0,0,11,224,0,3,252,0,0,0,0,11,224,0,7,255,255,255,64,0,11,224,0,15,255,255,255,128,0,11,224,0,47,255,255,255,64,0,11,224,0,127,192,0,255,0,63,255,255,245,255,208,1,253,0,63,255,255,251,255,240,3,252,0,63,255,255,255,251,248,7,244,0,21,95,245,127,225,253,31,240,0,0,31,224,15,192,255,63,192,0,0,47,244,3,0,63,255,64,0,0,63,252,0,0,31,254,0,0,0,63,255,0,0,15,253,0,0,0,127,255,128,0,127,255,128,0,0,191,255,208,2,255,255,240,0,0,255,231,240,15,255,47,254,0,1,255,227,240,191,248,7,255,224,3,251,225,219,255,208,0,255,254,7,235,224,255,255,0,0,47,252,15,203,224,127,255,255,255,255,248,31,203,224,47,191,255,255,255,144,63,75,224,0,127,255,255,255,128,191,11,224,0,127,0,0,63,128,125,11,224,0,127,0,0,63,128,56,11,224,0,127,0,0,63,128,16,11,224,0,127,0,0,63,128,0,11,224,0,127,0,0,63,128,0,11,224,0,127,0,0,63,128,0,11,224,0,127,255,255,255,128,0,11,224,0,127,255,255,255,128,0,11,224,0,127,255,255,255,128,0,11,224,0,127,0,0,63,128,0,6,144,0,106,0,0,42,64,
  // 0x68af  梯
  175,104,35,36,68,38,1,252,0,11,208,0,1,0,0,36,0,0,11,224,0,63,0,0,127,64,0,11,224,0,63,128,0,255,0,0,11,224,0,31,192,0,254,0,0,11,224,0,15,208,2,252,0,0,11,224,0,11,240,3,248,0,0,11,224,0,7,208,2,240,0,0,11,224,7,255,255,255,255,240,21,95,229,87,255,255,255,255,240,63,255,255,247,255,255,255,255,240,63,255,255,240,0,7,240,7,240,63,255,255,240,0,7,240,7,240,0,15,224,0,0,7,240,7,240,0,31,224,0,0,7,240,7,240,0,63,240,2,255,255,255,255,240,0,63,248,2,255,255,255,255,240,0,127,253,3,255,255,255,255,240,0,191,255,3,244,7,240,0,0,0,255,255,131,240,7,240,0,0,1,255,239,199,240,7,240,0,0,3,255,231,251,240,7,240,0,0,7,219,227,235,255,255,255,255,252,15,203,225,207,255,255,255,255,252,31,139,224,15,255,255,255,255,252,63,75,224,31,192,63,240,2,252,191,11,224,0,0,255,240,2,248,125,11,224,0,2,255,240,2,248,60,11,224,0,11,255,240,3,248,16,11,224,0,63,215,240,3,244,0,11,224,1,255,135,240,7,244,0,11,224,11,254,7,242,255,240,0,11,224,191,248,7,241,255,224,0,11,224,191,208,7,241,255,128,0,11,224,46,0,7,240,0,0,0,11,224,4,0,7,240,0,0,0,11,208,0,0,7,240,0,0,
  // 0x68c0  检
  192,104,36,36,68,38,1,252,0,31,128,0,0,15,128,0,0,0,31,192,0,0,47,192,0,0,0,31,192,0,0,63,192,0,0,0,31,192,0,0,255,240,0,0,0,31,192,0,2,255,248,0,0,0,31,192,0,7,250,254,0,0,0,31,192,0,15,240,191,192,0,63,255,255,64,63,192,47,240,0,63,255,255,64,255,64,11,253,0,63,255,255,67,253,0,2,255,64,21,127,213,31,248,0,0,191,224,0,63,192,191,224,0,0,47,253,0,63,211,255,255,255,255,251,253,0,127,243,254,63,255,255,241,252,0,191,248,244,63,255,255,240,52,0,255,252,64,0,0,0,0,0,1,255,254,0,0,0,0,0,0,2,255,239,64,0,1,0,5,0,3,255,207,193,128,47,0,15,208,7,239,207,79,192,31,64,15,192,15,223,198,11,208,15,128,31,128,31,159,192,3,240,15,192,63,64,63,95,192,3,240,15,192,63,0,127,31,192,2,244,11,192,190,0,126,31,192,1,248,11,208,252,0,60,31,192,0,252,7,225,248,0,24,31,192,0,252,7,227,240,0,0,31,192,0,252,0,3,240,0,0,31,192,0,0,0,11,208,0,0,31,192,0,0,0,15,192,0,0,31,192,0,0,0,47,64,0,0,31,192,255,255,255,255,255,244,0,31,192,255,255,255,255,255,244,0,31,192,255,255,255,255,255,244,0,31,192,0,0,0,0,0,0,0,31,128,0,0,0,0,0,0,
  // 0x69fd  槽
  253,105,36,36,68,38,1,252,0,15,192,0,1,248,31,128,0,0,15,192,0,1,248,31,128,0,0,15,192,0,1,248,31,128,0,0,15,192,63,255,255,255,255,253,0,15,192,63,255,255,255,255,253,0,15,192,63,255,255,255,255,253,0,15,192,0,1,248,31,128,0,0,15,192,0,1,248,31,128,0,21,95,213,15,255,255,255,255,244,63,255,255,207,255,255,255,255,244,63,255,255,207,213,253,111,151,244,63,255,255,207,192,248,31,2,244,0,47,192,15,192,248,31,2,244,0,63,192,15,255,255,255,255,244,0,63,192,15,255,255,255,255,244,0,127,224,15,213,249,111,87,244,0,191,244,15,192,248,31,2,244,0,255,252,15,192,248,31,2,244,1,255,254,15,255,255,255,255,244,3,255,239,79,255,255,255,255,244,3,239,207,197,85,85,85,85,80,11,223,199,192,0,0,0,0,0,15,207,195,1,255,255,255,255,192,47,79,192,1,255,255,255,255,192,63,15,192,1,254,170,170,191,192,190,15,192,1,252,0,0,47,192,60,15,192,1,252,0,0,47,192,40,15,192,1,255,255,255,255,192,0,15,192,1,255,255,255,255,192,0,15,192,1,253,85,85,127,192,0,15,192,1,252,0,0,47,192,0,15,192,1,252,0,0,47,192,0,15,192,1,255,255,255,255,192,0,15,192,1,255,255,255,255,192,0,15,192,1,254,170,170,191,192,0,15,192,1,252,0,0,31,192,
  // 0x6a21  模
  33,106,36,37,77,38,1,251,0,47,128,0,15,208,7,240,0,0,47,128,0,15,208,7,240,0,0,47,128,0,15,208,7,240,0,0,47,128,63,255,255,255,255,248,0,47,128,63,255,255,255,255,248,0,47,128,63,255,255,255,255,248,0,47,128,0,15,208,7,240,0,21,111,213,0,15,208,7,240,0,63,255,255,64,15,208,7,240,0,63,255,255,70,170,170,170,170,128,63,255,255,75,255,255,255,255,192,0,47,128,11,255,255,255,255,192,0,63,192,11,224,0,0,31,192,0,63,208,11,224,0,0,31,192,0,127,240,11,245,85,85,111,192,0,191,248,11,255,255,255,255,192,0,255,253,11,255,255,255,255,192,1,255,255,11,224,0,0,31,192,2,255,175,139,224,0,0,31,192,3,255,143,203,255,255,255,255,192,7,255,139,139,255,255,255,255,192,15,239,130,6,170,175,234,170,128,31,175,128,0,0,31,192,0,0,63,111,128,0,0,47,192,0,0,127,47,128,0,0,47,192,0,0,190,47,128,255,255,255,255,255,252,60,47,128,255,255,255,255,255,252,40,47,128,255,255,255,255,255,252,0,47,128,0,0,255,254,0,0,0,47,128,0,3,252,127,64,0,0,47,128,0,15,248,63,224,0,0,47,128,0,191,224,15,253,0,0,47,128,27,255,128,3,255,228,0,47,130,255,253,0,0,191,253,0,47,128,255,208,0,0,15,248,0,47,128,120,0,0,0,0,176,0,0,0,0,0,0,0,0,0,
  // 0x6a59  橙
  89,106,36,36,68,38,1,252,0,15,208,0,0,0,25,0,0,0,15,208,11,255,244,126,5,0,0,15,208,15,255,252,63,31,64,0,15,208,15,255,252,63,191,128,0,15,208,0,2,244,47,253,0,0,15,208,4,3,240,15,224,32,0,15,208,15,75,240,15,224,248,0,15,208,47,255,208,7,247,253,63,255,255,219,255,192,3,255,244,63,255,255,209,255,64,1,255,192,63,255,255,208,255,255,255,255,0,21,95,229,66,255,255,255,255,128,0,47,208,11,255,255,255,239,224,0,63,208,47,240,0,0,15,252,0,63,224,255,192,0,0,3,255,0,127,244,255,0,0,0,0,252,0,191,252,61,255,255,255,255,96,0,255,255,0,255,255,255,255,64,1,255,255,128,254,170,170,191,64,2,255,223,208,252,0,0,63,64,3,239,215,240,252,0,0,63,64,11,223,210,192,252,0,0,63,64,15,207,208,64,254,170,170,191,64,47,143,208,0,255,255,255,255,64,127,15,208,0,255,255,255,255,64,190,15,208,0,1,0,1,144,0,60,15,208,0,47,64,2,252,0,40,15,208,0,31,192,3,248,0,0,15,208,0,15,192,7,240,0,0,15,208,0,15,208,11,224,0,0,15,208,0,11,224,15,192,0,0,15,208,0,7,128,11,128,0,0,15,208,127,255,255,255,255,253,0,15,208,127,255,255,255,255,253,0,15,208,127,255,255,255,255,253,0,15,208,0,0,0,0,0,0,
  // 0x6b62  止
  98,107,34,34,50,38,2,254,0,0,0,0,106,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,127,64,0,0,0,0,21,0,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,255,255,255,0,0,63,128,0,127,255,255,255,0,0,63,128,0,127,255,255,255,0,0,63,128,0,127,170,170,170,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,0,63,128,0,127,64,0,0,0,170,191,234,170,191,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x6b63  正
  99,107,34,32,32,38,2,253,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,21,85,85,85,255,85,85,85,64,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,255,255,252,0,0,63,128,0,255,255,255,252,0,0,63,128,0,255,255,255,252,0,0,63,128,0,255,85,85,84,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,0,63,128,0,255,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,85,85,85,85,85,85,85,80,
  // 0x6b65  步
  101,107,34,36,68,38,2,252,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,5,64,2,252,0,0,0,0,0,31,192,2,252,0,0,0,0,0,31,192,2,255,255,255,240,0,0,31,192,2,255,255,255,240,0,0,31,192,2,255,255,255,240,0,0,31,192,2,253,85,85,80,0,0,31,192,2,252,0,0,0,0,0,31,192,2,252,0,0,0,0,0,31,192,2,252,0,0,0,0,85,111,213,87,253,85,85,85,80,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,2,252,0,0,0,0,0,2,144,2,252,0,0,0,0,0,7,252,2,252,0,6,0,0,0,15,244,2,252,0,15,240,0,0,63,224,2,252,0,31,224,0,0,255,192,2,252,0,63,208,0,7,255,0,2,252,0,127,192,0,47,252,0,2,252,0,255,64,0,191,240,0,3,252,2,254,0,0,47,192,7,255,248,11,252,0,0,10,0,3,255,244,47,244,0,0,0,0,2,255,144,191,224,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,47,254,0,0,0,0,0,0,2,255,244,0,0,0,0,0,0,127,255,192,0,0,0,0,0,111,255,253,0,0,0,0,2,191,255,255,208,0,0,0,0,2,255,255,249,0,0,0,0,0,0,255,254,64,0,0,0,0,0,0,185,64,0,0,0,0,0,0,
  // 0x6bd4  比
  212,107,36,35,59,38,1,253,0,26,128,0,0,168,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,7,128,0,47,192,0,1,253,0,47,208,0,47,192,0,1,253,1,255,244,0,47,255,255,193,253,31,255,208,0,47,255,255,193,254,255,254,0,0,47,255,255,193,255,255,224,0,0,47,229,85,65,255,253,0,0,0,47,192,0,1,255,144,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,0,0,47,192,0,1,253,0,0,160,0,47,192,0,1,253,0,0,190,0,47,192,0,17,253,0,0,190,0,47,192,91,241,253,0,0,254,0,47,239,255,245,253,0,0,253,1,191,255,255,244,253,0,0,253,127,255,255,254,64,255,85,87,252,63,255,254,64,0,255,255,255,248,63,254,64,0,0,127,255,255,240,25,0,0,0,0,11,255,255,128,
  // 0x6ca1  没
  161,108,35,36,68,38,2,252,1,0,0,0,0,0,0,0,0,3,208,0,1,85,85,85,0,0,15,253,0,15,255,255,255,0,0,11,255,192,15,255,255,255,0,0,1,255,240,15,255,255,255,0,0,0,31,240,15,224,0,127,0,0,0,2,192,15,224,0,127,0,0,0,0,64,15,224,0,127,0,0,0,0,0,15,208,0,127,1,208,0,0,0,31,192,0,127,1,248,0,0,0,63,192,0,127,1,244,61,0,0,191,128,0,127,2,244,255,208,2,255,0,0,127,255,240,255,252,11,253,0,0,63,255,240,31,255,31,248,0,0,11,255,128,1,255,3,208,0,0,0,0,0,0,60,1,64,0,0,0,0,0,0,4,3,255,255,255,255,248,0,0,0,3,255,255,255,255,253,0,0,0,3,255,255,255,255,252,0,0,0,1,87,213,85,91,248,0,0,3,128,15,240,0,15,240,0,0,7,224,7,244,0,47,224,0,0,15,240,3,252,0,127,192,0,0,47,208,1,255,0,255,64,0,0,63,192,0,191,195,254,0,0,0,191,64,0,63,255,252,0,0,0,255,0,0,15,255,240,0,0,2,253,0,0,7,255,192,0,0,3,252,0,0,47,255,244,0,0,11,244,0,2,255,255,255,64,0,31,240,1,191,255,199,255,249,0,63,208,111,255,253,0,191,255,244,47,192,63,255,208,0,31,255,240,7,0,47,248,0,0,0,191,208,0,0,13,0,0,0,0,2,128,
  // 0x6ce2  波
  226,108,35,36,68,38,1,252,0,0,0,0,0,47,128,0,0,0,244,0,0,0,47,192,0,0,3,255,0,0,0,47,192,0,0,3,255,224,0,0,47,192,0,0,0,127,252,0,0,47,192,0,0,0,11,248,21,85,111,213,85,64,0,1,240,191,255,255,255,255,252,0,0,0,191,255,255,255,255,252,0,0,0,191,255,255,255,255,248,0,0,0,191,0,47,192,7,240,0,0,0,191,0,47,192,15,240,14,0,0,191,0,47,192,15,208,63,224,0,191,0,47,192,47,192,127,254,0,191,0,47,192,7,64,11,255,192,191,0,47,192,0,0,0,191,128,191,255,255,255,255,64,0,31,0,191,255,255,255,255,128,0,0,0,191,255,255,255,255,64,0,0,0,191,191,0,0,191,0,0,0,0,190,63,0,0,254,0,0,0,0,254,63,128,2,253,0,0,3,64,254,31,192,3,252,0,0,7,224,253,15,240,7,244,0,0,15,240,253,7,248,15,240,0,0,15,224,252,2,253,63,208,0,0,47,193,252,0,255,191,128,0,0,63,130,252,0,127,255,0,0,0,191,3,248,0,47,253,0,0,0,255,7,244,0,47,253,0,0,2,253,11,240,0,255,255,128,0,3,252,15,224,7,255,255,244,0,11,244,31,208,127,253,47,255,64,31,240,63,203,255,240,7,255,248,31,208,191,79,255,128,0,191,252,3,192,127,7,248,0,0,11,240,0,0,5,2,128,0,0,0,160,
  // 0x6ce8  注
  232,108,36,36,68,38,1,252,0,64,0,0,6,0,0,0,0,0,253,0,0,31,208,0,0,0,3,255,192,0,63,252,0,0,0,1,255,248,0,31,255,128,0,0,0,47,254,0,2,255,240,0,0,0,2,252,0,0,127,252,0,0,0,0,120,0,0,15,253,0,0,0,0,0,0,0,2,248,0,0,0,0,0,85,85,85,245,85,80,0,0,0,255,255,255,255,255,248,0,0,0,255,255,255,255,255,248,14,0,0,255,255,255,255,255,248,63,244,0,0,0,47,192,0,0,127,255,0,0,0,47,192,0,0,11,255,208,0,0,47,192,0,0,0,191,192,0,0,47,192,0,0,0,15,64,0,0,47,192,0,0,0,1,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,5,85,111,213,85,64,0,0,0,31,255,255,255,255,208,0,0,112,31,255,255,255,255,208,0,0,252,31,255,255,255,255,208,0,1,253,0,0,47,192,0,0,0,3,252,0,0,47,192,0,0,0,11,244,0,0,47,192,0,0,0,15,240,0,0,47,192,0,0,0,47,208,0,0,47,192,0,0,0,127,192,0,0,47,192,0,0,0,255,64,0,0,47,192,0,0,2,254,0,0,0,47,192,0,0,3,252,3,255,255,255,255,255,253,15,248,3,255,255,255,255,255,253,3,240,3,255,255,255,255,255,253,0,208,1,85,85,85,85,85,84,0,0,0,0,0,0,0,0,0,
  // 0x6d17  洗
  23,109,35,36,68,38,2,252,1,0,0,0,0,127,0,0,0,11,208,0,15,224,127,0,0,0,31,248,0,15,224,127,0,0,0,11,255,64,31,208,127,0,0,0,1,255,208,47,192,127,0,0,0,0,47,208,63,192,127,0,0,0,0,7,64,63,255,255,255,255,192,0,0,0,127,255,255,255,255,192,0,0,0,255,255,255,255,255,192,0,0,1,254,85,191,85,85,64,16,0,2,252,0,127,0,0,0,125,0,7,248,0,127,0,0,0,255,192,15,244,0,127,0,0,0,255,244,15,240,0,127,0,0,0,47,254,1,192,0,127,0,0,0,3,255,0,0,0,127,0,0,0,0,188,15,255,255,255,255,255,244,0,20,15,255,255,255,255,255,244,0,0,15,255,255,255,255,255,244,0,0,5,85,255,85,254,85,80,0,0,0,0,254,0,252,0,0,0,14,0,0,253,0,252,0,0,0,15,192,0,253,0,252,0,0,0,47,192,1,252,0,252,0,0,0,63,128,2,252,0,252,0,0,0,191,0,3,252,0,252,0,0,0,254,0,3,248,0,252,0,64,2,252,0,11,240,0,252,0,244,3,252,0,15,240,0,252,0,252,11,244,0,63,208,0,252,0,252,15,240,0,255,192,0,253,1,252,47,208,7,255,0,0,253,2,248,63,192,127,252,0,0,255,255,244,47,64,127,240,0,0,191,255,240,7,0,47,128,0,0,47,255,192,0,0,8,0,0,0,0,0,0,
  // 0x6d3b  活
  59,109,35,36,68,38,2,252,0,0,0,0,0,0,0,36,0,3,192,0,0,0,0,27,253,0,15,248,0,0,1,107,255,255,0,15,255,128,26,255,255,255,254,0,2,255,240,255,255,255,254,64,0,0,47,240,127,255,255,64,0,0,0,7,208,62,148,63,0,0,0,0,0,64,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,16,0,1,85,85,127,149,85,80,62,0,11,255,255,255,255,255,244,255,224,11,255,255,255,255,255,244,127,253,11,255,255,255,255,255,244,11,255,64,0,0,63,0,0,0,0,254,0,0,0,63,0,0,0,0,28,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,127,64,0,0,0,3,64,63,255,255,255,255,0,0,7,208,63,255,255,255,255,0,0,15,240,63,255,255,255,255,0,0,31,208,63,0,0,0,127,0,0,63,192,63,0,0,0,127,0,0,191,64,63,0,0,0,127,0,0,255,0,63,0,0,0,127,0,2,253,0,63,0,0,0,127,0,7,252,0,63,0,0,0,127,0,15,244,0,63,0,0,0,127,0,47,224,0,63,255,255,255,255,0,127,192,0,63,255,255,255,255,0,63,128,0,63,255,255,255,255,0,11,0,0,63,64,0,0,127,0,0,0,0,63,0,0,0,42,0,
  // 0x6d41  流
  65,109,35,36,68,38,2,252,1,0,0,0,0,253,0,0,0,7,224,0,0,0,253,0,0,0,15,254,0,0,0,253,0,0,0,11,255,192,0,0,253,0,0,0,0,191,240,0,0,253,0,0,0,0,31,235,255,255,255,255,255,240,0,2,203,255,255,255,255,255,240,0,0,11,255,255,255,255,255,240,0,0,0,0,63,208,0,0,0,0,0,0,0,63,192,7,0,0,0,0,0,0,127,0,47,208,0,125,0,0,0,254,0,15,240,0,255,208,0,1,252,0,3,252,0,255,253,0,3,254,171,255,255,0,31,255,7,255,255,255,255,255,192,1,254,7,255,255,255,255,255,224,0,44,3,255,250,149,80,15,240,0,0,1,0,0,0,0,3,208,0,0,0,26,64,84,6,145,0,0,0,0,47,128,252,11,224,0,0,1,0,47,128,252,11,224,0,0,7,128,47,128,252,11,224,0,0,15,224,47,128,252,11,224,0,0,31,224,47,128,252,11,224,0,0,63,192,47,64,252,11,224,0,0,127,128,63,64,252,11,224,0,0,255,0,63,64,252,11,224,0,1,254,0,127,0,252,11,224,64,3,252,0,191,0,252,11,224,180,7,248,0,254,0,252,11,224,184,15,240,2,252,0,252,11,224,248,47,224,11,248,0,252,11,224,248,63,192,31,240,0,252,11,255,244,47,128,63,208,0,252,3,255,240,7,0,31,64,0,0,1,255,208,0,0,5,0,0,0,0,0,0,
  // 0x6d4b  测
  75,109,34,36,68,38,2,252,1,0,0,0,0,0,0,1,64,15,208,0,0,0,0,0,11,208,47,252,10,170,170,164,0,11,208,11,255,143,255,255,252,5,11,208,1,255,223,255,255,252,47,11,208,0,47,79,128,0,252,47,11,208,0,9,15,128,0,252,47,11,208,0,0,15,129,64,252,47,11,208,0,0,15,131,208,252,47,11,208,0,0,15,131,208,252,47,11,208,0,0,15,131,208,252,47,11,208,61,0,15,131,208,252,47,11,208,255,128,15,131,208,252,47,11,208,255,244,15,131,208,252,47,11,208,31,253,15,131,208,252,47,11,208,2,252,15,131,208,252,47,11,208,0,112,15,131,208,252,47,11,208,0,0,15,131,208,252,47,11,208,0,0,15,131,208,252,47,11,208,0,0,15,131,208,252,47,11,208,0,0,15,131,208,252,47,11,208,0,32,15,131,208,252,47,11,208,0,125,15,135,208,252,47,11,208,0,255,15,135,208,252,47,11,208,0,253,15,135,208,252,47,11,208,1,252,15,135,192,252,47,11,208,3,252,15,139,192,252,47,11,208,3,244,0,15,192,0,0,11,208,11,240,0,31,72,0,0,11,208,15,224,0,63,127,0,0,11,208,31,208,0,190,47,128,0,11,208,63,192,2,252,15,224,0,11,208,127,128,11,240,3,244,0,11,208,191,0,127,208,0,252,31,255,192,30,0,127,0,0,125,15,255,128,0,0,36,0,0,32,11,249,0,
  // 0x6d88  消
  136,109,34,37,77,38,2,251,1,0,0,0,0,127,0,0,0,7,192,0,20,0,127,0,9,0,31,248,1,252,0,127,0,31,208,15,255,64,254,0,127,0,63,192,1,255,208,191,64,127,0,63,128,0,63,224,63,192,127,0,191,0,0,11,128,47,208,127,1,254,0,0,1,0,15,240,127,3,252,0,0,0,0,11,224,127,3,244,0,0,0,0,2,0,127,0,96,0,0,0,0,0,0,127,0,0,0,56,0,0,191,255,255,255,255,0,255,128,0,191,255,255,255,255,0,255,244,0,191,255,255,255,255,0,31,254,0,191,85,85,85,191,0,2,255,0,191,0,0,0,127,0,0,125,0,191,0,0,0,127,0,0,24,0,191,0,0,0,127,0,0,0,0,191,255,255,255,255,0,0,0,0,191,255,255,255,255,0,0,0,0,191,255,255,255,255,0,0,7,0,191,0,0,0,127,0,0,15,192,191,0,0,0,127,0,0,15,208,191,0,0,0,127,0,0,47,192,191,0,0,0,127,0,0,63,128,191,255,255,255,255,0,0,191,0,191,255,255,255,255,0,0,254,0,191,255,255,255,255,0,2,253,0,191,0,0,0,127,0,3,252,0,191,0,0,0,127,0,11,244,0,191,0,0,0,127,0,15,240,0,191,0,0,0,127,0,63,208,0,191,0,0,80,191,0,63,192,0,191,0,1,255,255,0,15,64,0,191,0,0,255,254,0,2,0,0,191,0,0,191,228,0,0,0,0,0,0,0,0,0,0,
  // 0x6de1  淡
  225,109,36,35,59,38,1,253,0,0,0,0,0,47,128,0,0,0,224,0,0,0,47,128,0,0,3,254,0,1,0,63,128,4,0,7,255,208,11,240,63,128,31,208,0,191,248,15,208,63,128,63,192,0,15,252,31,192,63,64,127,128,0,1,240,47,128,63,64,255,0,0,0,64,127,64,127,2,252,0,0,0,0,255,0,191,3,244,0,0,0,0,124,0,255,209,224,0,0,0,0,0,2,255,252,0,0,14,0,0,0,7,255,255,128,0,63,208,0,0,31,244,255,248,0,127,253,0,0,191,224,31,255,0,11,255,128,31,255,128,2,255,224,0,255,194,255,253,0,0,63,240,0,31,0,255,208,63,128,11,208,0,0,0,121,0,63,128,1,128,0,0,0,0,0,63,128,0,0,0,0,0,11,144,63,64,15,144,0,2,0,15,208,63,64,31,240,0,3,208,31,192,63,64,63,192,0,11,240,63,128,127,192,127,128,0,15,240,127,64,191,192,255,0,0,47,208,255,0,255,226,253,0,0,63,194,253,1,255,247,248,0,0,191,64,184,3,255,252,160,0,0,255,0,0,11,250,254,0,0,2,254,0,0,31,240,255,64,0,7,252,0,0,191,208,127,224,0,15,244,0,11,255,128,31,253,0,31,240,6,255,253,0,7,255,228,15,208,15,255,240,0,0,255,253,2,192,7,255,64,0,0,31,244,0,0,2,144,0,0,0,0,160,
  // 0x6df7  混
  247,109,35,36,68,38,2,252,1,0,0,0,0,0,0,0,0,7,208,0,0,0,0,0,0,0,15,252,2,255,255,255,255,254,0,31,255,130,255,255,255,255,254,0,1,255,226,255,255,255,255,254,0,0,47,194,248,0,0,0,190,0,0,3,66,248,0,0,0,190,0,0,0,2,254,170,170,170,254,0,0,0,2,255,255,255,255,254,0,0,0,2,255,255,255,255,254,0,16,0,2,248,0,0,0,190,0,126,0,2,248,0,0,0,190,0,255,224,2,248,0,0,0,190,0,255,252,2,255,255,255,255,254,0,31,254,2,255,255,255,255,254,0,1,252,2,255,255,255,255,254,0,0,52,0,0,0,0,0,0,0,0,0,0,84,0,1,80,0,0,0,0,1,252,0,11,240,0,0,0,0,1,252,0,11,240,0,0,0,0,1,252,0,11,240,7,0,0,14,1,252,0,11,240,47,192,0,31,193,255,255,219,242,255,224,0,47,193,255,255,219,255,255,64,0,63,129,255,255,219,255,244,0,0,191,1,252,0,11,255,64,0,0,254,1,252,0,11,244,0,0,2,253,1,252,0,11,240,0,0,3,252,1,252,0,11,240,1,208,11,244,1,252,0,75,240,1,248,15,240,1,254,191,219,240,2,244,47,208,91,255,255,219,240,3,244,63,192,191,255,255,215,255,255,240,63,128,127,255,148,3,255,255,224,11,0,58,64,0,1,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x6e05  清
  5,110,36,37,77,38,1,251,0,128,0,0,0,47,128,0,0,2,253,0,0,0,63,128,0,0,7,255,192,106,170,191,234,170,160,0,255,244,255,255,255,255,255,240,0,31,252,255,255,255,255,255,240,0,3,240,0,0,63,128,0,0,0,0,160,0,0,63,128,0,0,0,0,0,63,255,255,255,255,208,0,0,0,63,255,255,255,255,208,0,0,0,21,85,127,213,85,64,0,0,0,0,0,63,128,0,0,14,0,0,0,0,63,128,0,0,63,224,3,255,255,255,255,255,253,127,254,3,255,255,255,255,255,253,11,255,194,170,170,170,170,170,169,0,191,192,0,0,0,0,0,0,0,31,0,6,170,170,170,170,64,0,1,0,11,255,255,255,255,128,0,0,0,11,255,255,255,255,128,0,0,0,11,224,0,0,47,128,0,0,0,11,224,0,0,47,128,0,0,208,11,229,85,85,127,128,0,2,244,11,255,255,255,255,128,0,3,248,11,255,255,255,255,128,0,11,244,11,224,0,0,47,128,0,15,240,11,224,0,0,47,128,0,47,208,11,229,85,85,127,128,0,63,192,11,255,255,255,255,128,0,191,64,11,255,255,255,255,128,0,255,0,11,224,0,0,47,128,2,253,0,11,224,0,0,47,128,7,252,0,11,224,0,0,47,128,15,244,0,11,224,0,0,63,128,15,240,0,11,224,0,127,255,128,3,208,0,11,224,0,63,255,0,0,64,0,11,224,0,47,249,0,0,0,0,0,0,0,0,0,0,
  // 0x6e29  温
  41,110,35,35,59,38,2,252,3,208,0,0,0,0,0,0,0,11,253,0,191,255,255,255,252,0,11,255,192,191,255,255,255,252,0,1,255,244,191,255,255,255,252,0,0,31,240,190,0,0,2,252,0,0,2,208,190,0,0,2,252,0,0,0,0,190,0,0,2,252,0,0,0,0,191,255,255,255,252,0,0,0,0,191,255,255,255,252,0,0,0,0,191,255,255,255,252,0,36,0,0,190,0,0,2,252,0,191,64,0,190,0,0,2,252,0,255,240,0,190,0,0,2,252,0,127,254,0,191,255,255,255,252,0,7,255,0,191,255,255,255,252,0,0,189,0,191,255,255,255,252,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,0,0,6,3,255,255,255,255,255,0,0,15,195,255,255,255,255,255,0,0,31,211,244,47,3,224,63,0,0,63,195,244,47,3,224,63,0,0,127,67,244,47,3,224,63,0,0,255,3,244,47,3,224,63,0,1,253,3,244,47,3,224,63,0,3,252,3,244,47,3,224,63,0,11,244,3,244,47,3,224,63,0,15,240,3,244,47,3,224,63,0,47,208,3,244,47,3,240,127,0,127,192,255,255,255,255,255,255,244,63,64,255,255,255,255,255,255,244,11,0,255,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,
  // 0x6e38  游
  56,110,35,37,77,38,2,251,0,0,0,63,64,1,164,0,0,15,128,0,63,64,2,252,0,0,47,244,0,63,64,3,248,0,0,31,255,0,63,64,3,244,0,0,2,255,128,63,64,7,240,0,0,0,127,0,63,64,11,255,255,244,0,13,255,255,255,207,255,255,244,0,0,255,255,255,239,255,255,244,0,0,255,255,255,255,213,85,80,0,0,87,249,85,191,64,0,0,0,0,3,244,0,255,0,0,0,61,0,3,244,1,254,0,0,0,255,208,3,240,0,127,255,255,208,255,248,3,240,0,11,255,255,240,31,253,3,244,0,7,255,255,224,2,248,3,255,255,64,0,63,192,0,48,3,255,255,64,0,191,0,0,0,7,255,255,64,6,253,0,0,0,7,240,63,64,15,244,0,0,0,11,240,63,0,15,224,0,0,0,11,224,63,0,15,208,0,0,160,11,224,63,63,255,255,244,0,253,15,208,63,63,255,255,244,0,253,15,192,63,63,255,255,244,2,252,15,192,63,0,15,224,0,3,248,31,192,63,0,15,208,0,7,244,47,128,63,0,15,208,0,11,240,63,64,127,0,15,208,0,15,224,127,0,127,0,15,208,0,31,208,254,0,127,0,15,208,0,47,193,252,0,190,0,15,208,0,63,131,252,0,254,0,15,208,0,191,71,244,1,253,0,15,208,0,255,15,224,255,252,15,255,208,0,46,7,192,191,248,15,255,192,0,0,1,64,127,224,11,254,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6e90  源
  144,110,35,37,77,38,2,251,1,0,0,0,0,0,0,0,0,11,208,0,0,0,0,0,0,0,31,253,3,255,255,255,255,255,240,11,255,131,255,255,255,255,255,240,1,255,211,255,255,255,255,255,240,0,47,131,244,0,11,244,0,0,0,7,3,240,0,11,240,0,0,0,0,3,240,0,15,240,0,0,0,0,3,240,0,15,208,0,0,0,0,3,240,255,255,255,255,192,0,0,3,240,255,255,255,255,192,61,0,3,240,254,170,170,191,192,255,192,3,240,252,0,0,47,192,255,248,7,240,252,0,0,47,192,31,254,7,240,254,85,85,127,192,2,252,7,240,255,255,255,255,192,0,116,7,240,255,255,255,255,192,0,0,7,240,252,0,0,47,192,0,0,7,240,252,0,0,47,192,0,0,11,240,252,0,0,47,192,0,0,11,240,255,255,255,255,192,0,40,15,224,255,255,255,255,192,0,63,15,224,170,175,250,170,64,0,127,15,208,0,11,240,0,0,0,255,15,208,16,11,240,24,0,1,253,31,192,127,11,240,254,0,2,252,47,192,254,11,240,191,0,3,248,63,129,252,11,240,63,192,11,244,63,67,252,11,240,47,208,15,240,191,7,244,11,240,15,240,31,208,255,15,224,11,240,11,244,63,193,253,63,192,11,240,3,248,127,131,252,31,64,11,240,2,224,191,11,244,2,11,255,224,0,0,14,7,240,0,3,255,208,0,0,0,0,80,0,3,254,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6ea2  溢
  162,110,35,36,68,38,2,252,2,0,0,0,0,0,0,0,0,11,224,0,0,15,255,253,0,0,31,253,0,5,15,255,255,0,0,11,255,128,15,223,255,255,64,0,0,255,192,47,192,0,63,192,0,0,47,64,127,128,0,31,224,0,0,6,0,255,0,0,11,248,0,0,0,3,253,0,0,3,255,0,0,0,15,251,255,255,255,255,224,0,0,63,227,255,255,254,63,224,0,0,31,131,255,255,253,11,128,61,0,6,0,0,0,0,1,0,255,208,0,0,0,0,0,0,0,255,248,0,0,15,255,255,0,0,31,254,0,0,15,255,255,64,0,2,252,0,10,79,255,255,192,0,0,112,0,31,208,0,31,208,0,0,0,0,63,192,0,15,240,0,0,0,0,255,0,0,11,248,0,0,0,2,254,0,0,3,254,0,0,0,7,252,0,0,0,255,192,0,0,31,240,0,0,0,127,244,0,56,191,255,255,255,255,255,240,0,127,127,255,255,255,255,255,192,0,255,29,255,255,255,255,252,0,0,254,0,248,47,7,192,252,0,2,252,0,248,47,7,192,252,0,3,252,0,248,47,7,192,252,0,7,244,0,248,47,7,192,252,0,15,240,0,248,47,7,192,252,0,31,224,0,248,47,7,192,252,0,47,192,1,248,47,7,208,252,0,63,192,255,255,255,255,255,255,244,191,64,255,255,255,255,255,255,244,31,0,255,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,
  // 0x6ed1  滑
  209,110,35,36,68,38,1,252,0,144,0,0,0,0,0,0,0,2,253,0,7,255,255,255,253,0,3,255,192,11,255,255,255,253,0,0,255,248,11,255,255,255,253,0,0,31,252,11,224,0,0,253,0,0,3,244,11,224,0,0,253,0,0,0,176,11,224,21,85,253,0,0,0,0,11,224,63,255,253,0,0,0,0,11,224,63,255,253,0,0,0,0,11,224,62,0,253,0,0,0,0,11,224,62,0,253,0,14,0,0,11,224,62,0,253,0,63,224,7,255,255,255,255,255,252,127,254,7,255,255,255,255,255,252,11,255,199,250,170,170,170,171,252,0,191,135,240,0,0,0,1,252,0,15,7,240,0,0,0,1,252,0,0,7,251,255,255,255,254,252,0,0,2,171,255,255,255,254,168,0,0,0,11,255,255,255,253,0,0,0,0,11,224,0,0,253,0,0,0,208,11,224,0,0,253,0,0,2,248,11,255,255,255,253,0,0,7,248,11,255,255,255,253,0,0,15,240,11,250,170,170,253,0,0,31,224,11,224,0,0,253,0,0,63,192,11,224,0,0,253,0,0,127,128,11,255,255,255,253,0,0,255,0,11,255,255,255,253,0,1,254,0,11,250,170,170,253,0,3,252,0,11,224,0,0,253,0,11,248,0,11,224,0,0,253,0,15,240,0,11,224,0,0,253,0,11,224,0,11,224,1,255,253,0,1,192,0,11,224,0,255,252,0,0,0,0,10,144,0,170,144,0,
  // 0x6f0f  漏
  15,111,34,36,68,38,2,252,6,0,0,0,0,0,0,0,0,15,208,11,255,255,255,255,255,128,63,252,15,255,255,255,255,255,128,11,255,143,255,255,255,255,255,128,1,255,207,208,0,0,0,47,128,0,63,15,208,0,0,0,47,128,0,14,15,208,0,0,0,47,128,0,0,15,208,0,0,0,47,128,0,0,15,255,255,255,255,255,128,0,0,15,255,255,255,255,255,128,0,0,15,255,255,255,255,255,128,36,0,15,208,0,0,0,0,0,191,64,15,208,0,0,0,0,0,255,244,15,255,255,255,255,255,240,47,255,15,255,255,255,255,255,240,3,253,15,255,255,255,255,255,224,0,120,15,208,0,15,128,0,0,0,0,15,208,0,15,128,0,0,0,0,15,234,170,191,234,170,128,0,0,15,255,255,255,255,255,208,0,0,15,255,255,255,255,255,208,0,112,31,239,0,15,128,11,208,0,189,31,239,4,15,136,11,208,0,254,47,175,126,15,175,75,208,1,252,47,175,47,223,159,219,208,3,252,63,111,11,223,131,219,208,3,248,63,47,1,79,128,139,208,7,240,127,47,0,15,132,11,208,15,240,190,47,60,15,174,11,208,31,208,253,47,127,15,175,139,208,47,193,252,47,31,223,139,219,208,63,130,252,47,7,223,130,139,208,191,67,244,47,0,15,128,11,208,255,11,240,47,0,15,129,95,208,45,2,208,47,0,15,130,255,192,0,0,64,47,0,15,129,254,64,
  // 0x6fc0  激
  192,111,35,37,77,38,2,251,0,0,0,14,128,0,248,0,0,11,128,0,31,208,0,253,0,0,31,244,0,47,192,0,252,0,0,31,254,0,63,128,1,252,0,0,2,255,175,255,255,194,252,0,0,0,127,47,255,255,194,248,0,0,0,13,47,170,175,195,244,0,0,0,0,47,0,15,195,255,255,248,0,0,47,0,15,199,255,255,248,0,0,47,255,255,203,255,255,248,0,0,47,255,255,207,224,47,192,61,0,47,149,95,223,224,47,128,255,192,47,0,15,255,224,47,64,255,244,47,0,15,255,240,63,64,31,252,47,255,255,255,240,63,0,2,248,47,255,255,255,240,63,0,0,112,26,191,234,254,244,63,0,0,0,0,31,192,56,248,126,0,0,0,0,31,192,0,252,190,0,0,0,255,255,255,244,188,253,0,0,0,255,255,255,244,125,252,0,0,52,255,255,255,244,63,252,0,0,126,0,252,0,0,63,248,0,0,191,0,252,0,0,47,240,0,0,253,1,255,255,192,15,240,0,2,252,1,255,255,192,15,208,0,3,252,2,255,255,192,31,240,0,7,244,3,244,15,192,63,244,0,11,240,3,240,31,192,191,252,0,15,224,11,240,31,129,254,254,0,47,208,15,208,31,135,252,191,64,63,192,63,192,47,159,244,63,208,127,128,191,64,63,191,224,31,240,191,2,254,31,255,255,192,11,248,14,3,252,15,255,191,0,2,240,0,0,224,10,164,28,0,0,128,0,0,0,0,0,0,0,0,0,
  // 0x706f  灯
  111,112,35,36,68,38,2,252,0,10,144,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,3,255,255,255,255,244,0,15,208,3,255,255,255,255,244,0,15,208,3,255,255,255,255,244,0,15,208,1,85,85,255,149,80,0,15,208,144,0,0,191,0,0,47,15,208,252,0,0,191,0,0,47,15,209,248,0,0,191,0,0,47,15,210,244,0,0,191,0,0,63,15,211,240,0,0,191,0,0,63,15,215,224,0,0,191,0,0,63,15,219,192,0,0,191,0,0,126,15,223,128,0,0,191,0,0,125,15,235,0,0,0,191,0,0,188,15,208,0,0,0,191,0,0,252,15,208,0,0,0,191,0,0,20,15,192,0,0,0,191,0,0,0,31,192,0,0,0,191,0,0,0,31,192,0,0,0,191,0,0,0,47,192,0,0,0,191,0,0,0,63,224,0,0,0,191,0,0,0,63,248,0,0,0,191,0,0,0,127,254,0,0,0,191,0,0,0,191,191,128,0,0,191,0,0,0,255,47,224,0,0,191,0,0,1,254,15,248,0,0,191,0,0,3,252,3,252,0,0,191,0,0,7,248,1,240,0,0,191,0,0,15,240,0,144,0,0,191,0,0,63,224,0,0,0,0,191,0,0,191,192,0,0,31,255,255,0,0,255,64,0,0,15,255,255,0,0,61,0,0,0,11,255,252,0,0,8,0,0,0,6,170,64,0,0,
  // 0x70b9  点
  185,112,34,36,68,38,2,252,0,0,0,3,244,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,255,255,255,255,64,0,0,0,3,255,255,255,255,64,0,0,0,3,255,255,255,255,64,0,0,0,3,249,85,85,85,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,21,85,87,249,85,85,64,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,254,0,0,0,0,15,240,0,0,254,0,0,0,0,15,240,0,0,254,0,0,0,0,15,240,0,0,254,0,0,0,0,15,240,0,0,254,0,0,0,0,15,240,0,0,254,0,0,0,0,15,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,21,85,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,1,160,0,0,254,2,160,6,240,11,240,0,2,253,3,240,7,244,3,252,0,3,252,3,244,3,248,1,254,0,11,244,3,248,1,252,0,255,0,31,240,3,248,0,254,0,63,192,63,208,2,252,0,255,0,47,208,255,128,2,252,0,127,0,15,240,191,0,2,252,0,62,0,11,208,8,0,1,64,0,16,0,1,0,
  // 0x70ed  热
  237,112,35,37,77,38,2,251,0,10,128,0,3,244,0,0,0,0,15,192,0,3,244,0,0,0,0,15,192,0,3,244,0,0,0,0,15,192,0,3,244,0,0,0,0,15,192,0,3,244,0,0,0,21,95,213,64,3,244,0,0,0,127,255,255,223,255,255,255,240,0,127,255,255,223,255,255,255,240,0,127,255,255,223,255,255,255,240,0,0,15,192,0,3,240,7,240,0,0,15,192,0,3,240,7,240,0,0,15,192,0,7,240,7,240,0,0,15,192,80,7,240,7,240,0,0,15,255,210,11,224,7,240,0,1,191,255,231,239,224,7,224,0,191,255,255,223,255,208,7,224,0,255,255,228,3,255,208,7,224,0,255,239,192,0,127,244,7,240,0,184,15,192,0,63,255,7,240,0,0,15,192,0,191,255,211,240,128,0,15,192,0,255,63,227,240,248,0,15,192,3,253,11,195,240,248,0,15,192,15,248,1,66,249,248,31,255,192,127,240,0,1,255,244,15,255,192,191,192,0,0,255,240,11,254,0,46,0,0,0,47,192,0,0,0,4,0,0,0,0,0,0,164,0,0,0,0,0,176,0,1,254,2,240,7,240,7,244,0,3,252,3,244,3,248,3,252,0,7,244,3,248,2,252,1,255,0,15,240,2,248,1,253,0,191,128,47,208,2,252,0,254,0,63,192,127,192,2,252,0,255,0,31,240,255,0,1,252,0,191,0,15,240,29,0,1,144,0,16,0,7,64,0,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,32,37,40,38,2,251,0,0,0,0,7,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,234,170,170,170,170,170,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,0,0,0,0,0,0,0,191,170,170,170,170,168,0,0,191,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,254,0,0,0,3,252,0,1,254,0,0,0,3,252,0,2,253,0,0,0,3,252,0,3,252,0,0,0,3,252,0,7,252,0,0,0,3,252,0,11,244,0,0,0,3,252,0,15,240,0,0,0,3,252,0,47,224,0,0,0,3,252,0,127,192,0,0,0,3,252,0,255,128,0,0,0,3,252,0,255,0,0,0,0,3,252,0,61,0,0,0,0,3,252,0,24,0,0,0,0,3,252,0,0,0,0,0,0,0,0,0,
  // 0x7269  物
  105,114,35,36,68,38,1,252,0,2,244,0,2,144,0,0,0,0,2,248,0,7,240,0,0,0,5,66,248,0,11,240,0,0,0,11,210,248,0,15,224,0,0,0,11,210,248,0,15,192,0,0,0,15,194,248,0,31,192,0,0,0,15,194,248,0,63,213,85,85,84,15,194,248,0,63,255,255,255,252,15,255,255,240,191,255,255,255,252,31,255,255,240,255,255,255,255,252,47,255,255,242,252,15,194,249,252,63,87,249,83,248,31,131,245,252,63,2,248,11,240,63,3,241,252,126,2,248,31,224,63,7,241,252,189,2,248,63,192,190,11,226,252,124,2,248,47,64,252,15,210,248,4,2,248,6,2,252,15,194,248,0,2,248,4,3,244,47,130,248,0,2,254,248,7,240,63,67,248,0,7,255,252,15,208,127,3,244,1,191,255,248,63,192,190,3,244,127,255,254,64,127,64,252,3,244,127,255,248,0,254,2,252,3,240,63,230,248,3,252,3,244,3,240,40,2,248,15,244,11,240,7,240,0,2,248,15,224,15,224,7,240,0,2,248,2,128,47,192,11,240,0,2,248,0,0,127,128,11,224,0,2,248,0,0,255,0,15,224,0,2,248,0,3,253,0,15,208,0,2,248,0,15,248,0,31,192,0,2,248,0,47,240,0,63,192,0,2,248,0,255,192,191,255,128,0,2,248,0,127,0,127,255,0,0,2,248,0,12,0,63,253,0,0,2,248,0,0,0,21,64,0,
  // 0x7279  特
  121,114,36,36,68,38,1,252,0,2,248,0,0,3,244,0,0,0,2,248,0,0,3,244,0,0,6,66,248,0,0,3,244,0,0,11,210,248,0,0,3,244,0,0,15,210,248,0,255,255,255,255,224,15,194,248,0,255,255,255,255,224,15,194,248,0,255,255,255,255,224,15,195,248,0,0,7,244,0,0,31,255,255,240,0,3,244,0,0,31,255,255,240,0,3,244,0,0,47,255,255,240,0,3,244,0,0,63,2,248,5,85,87,249,85,84,63,2,248,31,255,255,255,255,253,126,2,248,31,255,255,255,255,253,189,2,248,31,255,255,255,255,253,60,2,248,0,0,0,2,252,0,4,2,248,0,0,0,2,252,0,0,2,248,120,0,0,2,252,0,0,2,255,252,0,0,2,252,0,0,47,255,255,255,255,255,255,252,27,255,255,239,255,255,255,255,252,127,255,248,15,255,255,255,255,252,63,255,248,1,85,85,86,253,84,62,66,248,0,28,0,2,252,0,0,2,248,0,191,0,2,252,0,0,2,248,0,127,192,2,252,0,0,2,248,0,47,224,2,252,0,0,2,248,0,15,244,2,252,0,0,2,248,0,3,252,2,252,0,0,2,248,0,1,248,2,252,0,0,2,248,0,0,208,2,252,0,0,2,248,0,0,0,2,252,0,0,2,248,0,0,9,87,252,0,0,2,248,0,0,11,255,252,0,0,2,248,0,0,7,255,244,0,0,2,248,0,0,3,255,144,0,
  // 0x7387  率
  135,115,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,0,0,0,31,208,0,0,0,0,1,0,0,47,192,0,0,52,0,11,208,0,127,0,64,0,255,0,47,248,5,253,2,244,3,254,0,7,255,31,248,7,240,31,244,0,0,191,239,240,31,208,191,192,0,0,31,67,253,63,128,62,0,0,0,5,0,191,254,0,0,0,0,0,0,0,31,248,96,0,0,0,0,0,144,15,243,244,56,0,0,0,31,224,63,192,253,255,64,0,2,255,240,191,0,191,255,244,0,127,255,191,255,255,255,159,254,0,191,244,63,255,255,255,194,255,192,63,64,63,255,250,159,224,63,208,20,0,0,3,248,3,208,11,64,0,0,0,3,248,1,0,0,0,0,0,0,3,248,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,21,85,85,87,253,85,85,85,80,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x73af  环
  175,115,35,34,50,38,1,252,0,0,0,5,85,85,85,85,84,127,255,255,15,255,255,255,255,252,127,255,255,15,255,255,255,255,252,127,255,255,15,255,255,255,255,252,0,63,0,0,0,3,248,0,0,0,63,0,0,0,11,244,0,0,0,63,0,0,0,15,240,0,0,0,63,0,0,0,31,224,0,0,0,63,0,0,0,63,192,0,0,0,63,0,0,0,127,192,0,0,0,63,0,0,0,255,198,0,0,5,127,84,0,2,255,239,64,0,63,255,253,0,3,255,255,208,0,63,255,253,0,15,255,223,240,0,63,255,253,0,47,255,199,252,0,0,63,0,0,127,239,194,254,0,0,63,0,0,255,159,192,255,64,0,63,0,3,255,31,192,63,192,0,63,0,15,252,31,192,31,240,0,63,0,63,244,31,192,15,248,0,63,0,127,208,31,192,3,248,0,63,0,31,128,31,192,2,208,0,63,1,6,0,31,192,0,0,0,63,175,0,0,31,192,0,0,0,63,255,0,0,31,192,0,0,6,255,255,0,0,31,192,0,0,127,255,244,0,0,31,192,0,0,127,253,0,0,0,31,192,0,0,63,128,0,0,0,31,192,0,0,16,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,
  // 0x7528  用
  40,117,33,34,50,38,1,252,0,21,85,85,85,85,85,85,64,0,63,255,255,255,255,255,255,192,0,63,255,255,255,255,255,255,192,0,63,255,255,255,255,255,255,192,0,63,64,0,127,0,0,63,192,0,63,64,0,127,0,0,63,192,0,63,64,0,127,0,0,63,192,0,63,64,0,127,0,0,63,192,0,63,64,0,127,0,0,63,192,0,63,85,85,191,85,85,127,192,0,63,255,255,255,255,255,255,192,0,63,255,255,255,255,255,255,192,0,63,255,255,255,255,255,255,192,0,63,64,0,127,0,0,63,192,0,63,64,0,127,0,0,63,192,0,127,0,0,127,0,0,63,192,0,127,0,0,127,0,0,63,192,0,127,0,0,127,0,0,63,192,0,127,0,0,127,0,0,63,192,0,127,255,255,255,255,255,255,192,0,191,255,255,255,255,255,255,192,0,191,255,255,255,255,255,255,192,0,255,85,85,191,85,85,127,192,0,254,0,0,127,0,0,63,192,1,253,0,0,127,0,0,63,192,2,252,0,0,127,0,0,63,192,3,252,0,0,127,0,0,63,192,7,248,0,0,127,0,0,63,192,11,240,0,0,127,0,0,63,192,31,224,0,0,127,0,0,63,128,63,192,0,0,127,3,255,255,128,127,128,0,0,127,2,255,255,64,31,0,0,0,127,1,255,253,0,5,0,0,0,0,0,85,0,0,
  // 0x7535  电
  53,117,33,36,68,38,4,252,0,0,0,63,64,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,21,85,85,191,213,85,85,64,0,127,255,255,255,255,255,255,192,0,127,255,255,255,255,255,255,192,0,127,255,255,255,255,255,255,192,0,127,64,0,63,128,0,47,192,0,127,64,0,63,128,0,47,192,0,127,64,0,63,128,0,47,192,0,127,64,0,63,128,0,47,192,0,127,64,0,63,128,0,47,192,0,127,255,255,255,255,255,255,192,0,127,255,255,255,255,255,255,192,0,127,255,255,255,255,255,255,192,0,127,64,0,127,128,0,63,192,0,127,64,0,63,128,0,47,192,0,127,64,0,63,128,0,47,192,0,127,64,0,63,128,0,47,192,0,127,64,0,63,128,0,47,192,0,127,255,255,255,255,255,255,192,0,127,255,255,255,255,255,255,192,0,127,255,255,255,255,255,255,192,0,127,149,85,191,213,85,85,64,0,127,64,0,63,128,0,0,56,0,127,64,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,127,64,0,0,0,63,128,0,0,191,0,0,0,0,63,208,0,1,255,0,0,0,0,63,255,255,255,254,0,0,0,0,31,255,255,255,252,0,0,0,0,11,255,255,255,244,0,0,0,0,0,90,170,169,64,0,
  // 0x7565  略
  101,117,34,36,68,38,3,252,0,0,0,0,1,224,0,0,0,0,0,0,0,3,252,0,0,0,255,255,255,128,7,244,0,0,0,255,255,255,128,15,240,0,0,0,255,255,255,128,47,255,255,248,0,248,61,15,128,63,255,255,254,0,248,61,15,128,255,255,255,253,0,248,61,15,130,254,0,3,252,0,248,61,15,139,255,0,11,244,0,248,61,15,175,255,192,15,240,0,248,61,15,255,223,224,63,192,0,248,61,15,255,7,244,191,64,0,248,61,15,173,3,254,254,0,0,255,255,255,128,0,255,252,0,0,255,255,255,128,0,63,240,0,0,255,255,255,128,0,255,244,0,0,248,61,15,128,7,255,254,0,0,248,61,15,128,31,253,255,192,0,248,61,15,128,255,240,127,248,0,248,61,15,139,255,128,15,255,128,248,61,15,255,253,0,2,255,240,248,61,15,255,244,0,0,191,208,248,61,15,255,255,255,255,255,128,248,61,15,151,255,255,255,253,0,248,61,15,131,255,255,255,253,0,255,255,255,131,248,0,0,253,0,255,255,255,131,248,0,0,253,0,255,255,255,131,248,0,0,253,0,248,0,0,3,248,0,0,253,0,248,0,0,3,248,0,0,253,0,248,0,0,3,248,0,0,253,0,0,0,0,3,255,255,255,253,0,0,0,0,3,255,255,255,253,0,0,0,0,3,255,255,255,253,0,0,0,0,3,248,0,1,253,0,0,0,0,1,164,0,0,84,0,
  // 0x767d  白
  125,118,28,36,252,38,5,252,0,0,2,233,0,0,0,0,0,3,254,0,0,0,0,0,3,252,0,0,0,0,0,11,248,0,0,0,0,0,15,244,0,0,0,0,0,15,240,0,0,0,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,170,170,170,170,170,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,85,85,85,85,85,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,170,170,170,170,170,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,190,0,0,0,0,0,170,
  // 0x7684  的
  132,118,33,36,68,38,3,252,0,31,144,0,2,228,0,0,0,0,31,208,0,3,248,0,0,0,0,47,192,0,3,244,0,0,0,0,63,128,0,7,240,0,0,0,0,63,64,0,15,240,0,0,0,0,127,0,0,15,208,0,0,0,191,255,255,240,47,255,255,255,64,191,255,255,240,63,255,255,255,64,191,255,255,240,127,255,255,255,64,190,0,7,240,255,0,0,127,0,189,0,7,241,253,0,0,63,0,189,0,7,243,252,0,0,63,0,189,0,7,251,248,0,0,63,0,189,0,7,255,240,0,0,63,0,189,0,7,247,208,0,0,63,0,189,0,7,240,129,128,0,127,0,190,0,7,240,15,208,0,127,0,191,255,255,240,15,240,0,127,0,191,255,255,240,3,252,0,127,0,191,255,255,240,1,254,0,127,0,189,0,7,240,0,191,64,191,0,189,0,7,240,0,63,192,190,0,189,0,7,240,0,31,224,190,0,189,0,7,240,0,15,240,190,0,189,0,7,240,0,7,192,254,0,189,0,7,240,0,1,0,253,0,189,0,7,240,0,0,0,253,0,189,0,7,240,0,0,0,253,0,190,0,7,240,0,0,1,252,0,191,255,255,240,0,0,1,252,0,191,255,255,240,0,0,3,252,0,191,255,255,240,0,0,7,248,0,189,0,0,0,0,255,255,244,0,189,0,0,0,0,191,255,224,0,189,0,0,0,0,127,255,128,0,0,0,0,0,0,5,80,0,0,
  // 0x76d1  监
  209,118,34,35,59,38,2,253,0,0,10,144,0,36,0,0,0,1,80,15,208,0,127,64,0,0,7,240,15,208,0,191,0,0,0,7,240,15,208,0,254,0,0,0,7,240,15,208,0,253,0,0,0,7,240,15,208,2,253,0,0,0,7,240,15,208,3,255,255,255,240,7,240,15,208,7,255,255,255,240,7,240,15,208,11,255,255,255,240,7,240,15,208,15,224,0,0,0,7,240,15,208,63,192,0,0,0,7,240,15,208,127,128,208,0,0,7,240,15,208,255,7,248,0,0,7,240,15,210,254,7,255,0,0,7,240,15,215,252,0,255,192,0,7,240,15,210,240,0,47,244,0,7,240,15,208,80,0,11,253,0,7,240,15,208,0,0,2,253,0,0,0,15,208,0,0,0,180,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,253,1,252,3,244,3,244,0,0,253,1,252,3,244,3,244,0,0,253,1,252,3,244,3,244,0,0,253,1,252,3,244,3,244,0,0,253,1,252,3,244,3,244,0,0,253,1,252,3,244,3,244,0,0,253,1,252,3,244,3,244,0,0,253,1,252,3,248,7,244,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x76f4  直
  244,118,34,36,68,38,2,252,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,21,85,85,86,254,85,85,85,64,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,26,171,254,170,170,144,0,5,80,31,255,255,255,255,224,0,11,240,31,255,255,255,255,224,0,11,240,31,192,0,0,15,224,0,11,240,31,192,0,0,15,224,0,11,240,31,192,0,0,15,224,0,11,240,31,255,255,255,255,224,0,11,240,31,255,255,255,255,224,0,11,240,31,213,85,85,95,224,0,11,240,31,192,0,0,15,224,0,11,240,31,192,0,0,15,224,0,11,240,31,255,255,255,255,224,0,11,240,31,255,255,255,255,224,0,11,240,31,213,85,85,95,224,0,11,240,31,192,0,0,15,224,0,11,240,31,192,0,0,15,224,0,11,240,31,255,255,255,255,224,0,11,240,31,255,255,255,255,224,0,11,240,26,170,170,170,170,144,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,245,85,85,85,85,85,85,80,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,255,255,255,255,255,255,255,240,11,240,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,
  // 0x7701  省
  1,119,34,37,77,38,2,251,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,1,228,3,248,0,124,0,0,0,7,252,3,248,1,255,64,0,0,15,244,3,248,0,127,224,0,0,63,224,3,248,0,31,252,0,1,255,128,3,248,0,3,255,0,11,254,0,3,248,1,208,255,192,127,248,0,3,248,7,252,47,240,191,208,15,255,248,47,248,15,208,31,64,11,255,244,255,208,2,0,4,0,7,255,155,255,64,0,0,0,0,0,1,191,252,0,0,0,0,0,0,31,255,208,0,0,0,0,0,27,255,254,0,0,0,0,0,22,255,255,208,0,0,0,0,111,255,255,255,255,255,255,224,0,255,255,255,255,255,255,255,224,0,127,255,254,170,170,170,175,224,0,46,67,248,0,0,0,15,224,0,0,3,248,0,0,0,15,224,0,0,3,253,85,85,85,95,224,0,0,3,255,255,255,255,255,224,0,0,3,255,255,255,255,255,224,0,0,3,248,0,0,0,15,224,0,0,3,248,0,0,0,15,224,0,0,3,253,85,85,85,111,224,0,0,3,255,255,255,255,255,224,0,0,3,255,255,255,255,255,224,0,0,3,248,0,0,0,15,224,0,0,3,248,0,0,0,15,224,0,0,3,248,0,0,0,15,224,0,0,3,255,255,255,255,255,224,0,0,3,255,255,255,255,255,224,0,0,3,254,170,170,170,175,224,0,0,3,248,0,0,0,15,208,0,0,0,0,0,0,0,0,0,0,
  // 0x7720  眠
  32,119,34,34,50,38,3,252,255,255,252,15,255,255,255,255,0,255,255,252,15,255,255,255,255,0,255,255,252,15,255,255,255,255,0,252,2,252,15,208,0,0,63,0,252,1,252,15,208,0,0,63,0,252,1,252,15,208,0,0,63,0,252,1,252,15,208,0,0,63,0,252,1,252,15,208,0,0,63,0,255,255,252,15,255,255,255,255,0,255,255,252,15,255,255,255,255,0,255,255,252,15,255,255,255,255,0,252,1,252,15,208,11,224,0,0,252,1,252,15,208,11,224,0,0,252,1,252,15,208,11,240,0,0,252,1,252,15,208,7,240,0,0,252,1,252,15,208,7,240,0,0,255,255,252,15,255,255,255,255,208,255,255,252,15,255,255,255,255,208,255,255,252,15,255,255,255,255,208,252,1,252,15,229,87,249,85,64,252,1,252,15,208,3,248,0,0,252,1,252,15,208,2,248,0,0,252,1,252,15,208,2,252,0,0,252,1,252,15,208,1,252,0,0,255,255,252,15,208,0,252,0,0,255,255,252,15,208,0,253,1,64,255,255,252,15,208,0,191,2,224,253,0,0,15,208,0,127,2,240,252,0,0,15,209,191,63,67,240,252,0,0,31,255,255,47,195,240,84,0,7,255,255,255,15,251,224,0,0,7,255,255,228,11,255,208,0,0,3,255,144,0,2,255,192,0,0,1,64,0,0,0,190,0,
  // 0x786e  确
  110,120,34,37,77,38,1,251,0,0,0,0,0,164,0,0,0,0,0,0,0,0,253,0,0,0,63,255,255,252,2,252,0,0,0,63,255,255,252,3,255,255,208,0,63,255,255,252,7,255,255,244,0,0,63,192,0,15,255,255,240,0,0,63,128,0,47,192,15,224,0,0,63,64,0,63,128,47,192,0,0,63,0,0,255,0,63,128,0,0,127,0,2,254,0,191,0,0,0,191,0,7,255,255,255,255,240,0,254,0,15,255,255,255,255,240,0,253,0,7,255,255,255,255,240,1,253,0,1,255,1,248,3,240,2,255,255,240,191,1,248,3,240,3,255,255,240,127,1,248,3,240,3,255,255,240,127,1,248,3,240,11,252,3,240,127,255,255,255,240,15,252,3,240,127,255,255,255,240,47,252,3,240,127,255,255,255,240,63,252,3,240,191,1,248,3,240,191,252,3,240,190,1,248,3,240,127,252,3,240,190,1,248,3,240,45,252,3,240,191,255,255,255,240,5,252,3,240,255,255,255,255,240,1,252,3,240,255,255,255,255,240,1,252,3,240,252,0,0,3,240,1,252,3,241,252,0,0,3,240,1,255,255,242,252,0,0,3,240,1,255,255,243,248,0,0,3,240,1,255,255,247,240,0,0,3,240,1,252,0,15,240,0,0,3,240,1,252,0,31,208,0,5,91,240,1,252,0,63,192,0,11,255,240,0,0,0,47,64,0,7,255,224,0,0,0,6,0,0,3,255,64,0,0,0,0,0,0,0,0,0,
  // 0x79bb  离
  187,121,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,0,0,64,0,0,0,0,42,0,64,1,248,10,128,0,0,63,2,249,11,240,15,208,0,0,63,3,255,255,208,15,208,0,0,63,0,127,255,64,15,208,0,0,63,0,15,255,192,15,208,0,0,63,1,255,255,248,15,208,0,0,63,31,254,7,252,15,208,0,0,63,15,224,0,180,15,208,0,0,63,2,0,0,16,15,208,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,63,255,255,255,255,255,208,0,0,0,0,31,224,0,0,0,0,0,0,0,31,208,0,0,0,0,11,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,254,0,11,255,255,255,255,255,255,254,0,11,240,0,127,0,104,0,254,0,11,240,0,191,0,253,0,254,0,11,240,0,253,0,127,0,254,0,11,240,0,253,21,127,192,254,0,11,242,255,255,255,255,208,254,0,11,243,255,255,255,255,240,254,0,11,242,255,250,149,3,244,254,0,11,240,0,0,0,1,208,254,0,11,240,0,0,0,0,0,254,0,11,240,0,0,0,2,255,254,0,11,240,0,0,0,0,255,252,0,6,160,0,0,0,0,255,224,0,
  // 0x79fb  移
  251,121,35,36,68,38,1,252,0,0,0,64,0,7,224,0,0,0,0,111,208,0,15,240,0,0,0,111,255,244,0,63,192,0,0,63,255,255,208,0,255,255,255,128,63,255,244,0,2,255,255,255,208,47,151,240,0,15,255,255,255,192,0,3,240,0,127,224,0,127,128,0,3,240,2,255,208,0,255,0,0,3,240,15,255,248,2,253,0,0,3,240,11,247,254,7,252,0,0,3,240,3,192,191,223,240,0,63,255,255,248,0,47,255,192,0,63,255,255,248,0,11,255,64,0,63,255,255,248,0,47,253,0,0,21,95,245,80,2,255,240,0,0,0,15,240,0,127,255,255,0,0,0,47,248,7,255,245,254,0,0,0,63,254,2,255,67,252,0,0,0,191,255,128,224,15,255,255,248,0,255,255,224,0,63,255,255,252,2,251,247,248,0,255,255,255,252,3,247,241,252,7,254,0,7,244,11,211,240,240,47,248,0,15,240,31,195,240,18,255,253,0,47,208,63,131,240,7,255,255,192,127,192,191,3,240,1,244,127,240,255,64,125,3,240,0,128,11,255,253,0,60,3,240,0,0,2,255,248,0,16,3,240,0,0,0,255,224,0,0,3,240,0,0,7,255,128,0,0,3,240,0,0,127,253,0,0,0,3,240,0,27,255,240,0,0,0,3,240,11,255,255,64,0,0,0,3,240,15,255,244,0,0,0,0,3,240,7,254,64,0,0,0,0,3,240,2,144,0,0,0,0,
  // 0x7a7a  空
  122,122,34,35,59,38,2,253,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,128,7,248,3,252,0,47,192,63,128,7,244,2,252,0,47,192,63,128,11,240,2,252,0,47,192,63,128,15,240,2,252,0,47,192,63,128,15,224,2,252,0,0,0,0,0,63,192,2,252,0,8,0,0,0,191,192,2,252,0,15,128,0,7,255,0,2,252,0,47,128,0,127,253,0,2,255,255,255,128,47,255,240,0,0,255,255,255,0,47,255,128,0,0,127,255,253,0,15,244,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,244,0,0,191,255,255,255,255,255,244,0,0,191,255,255,255,255,255,244,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,252,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,
  // 0x7aef  端
  239,122,36,36,68,38,1,252,0,5,0,0,0,7,240,0,0,0,31,128,0,0,7,240,0,0,0,31,128,3,240,7,240,7,240,0,31,128,3,240,7,240,7,240,0,31,128,3,240,7,240,7,240,0,31,128,3,240,7,240,7,240,0,31,128,3,240,7,240,7,240,0,47,128,3,240,7,240,7,240,63,255,255,195,255,255,255,255,240,63,255,255,195,255,255,255,255,240,63,255,255,195,255,255,255,255,240,0,0,0,0,0,0,0,0,0,6,64,58,0,0,0,0,0,0,15,128,63,0,0,0,0,0,0,15,128,63,47,255,255,255,255,253,15,192,127,47,255,255,255,255,253,11,192,126,47,255,255,255,255,253,11,192,189,0,0,15,240,0,0,7,208,189,0,0,15,224,0,0,7,224,252,0,0,31,192,0,0,3,224,252,11,255,255,255,255,248,3,224,248,11,255,255,255,255,248,3,241,244,11,255,255,255,255,248,3,226,244,11,224,188,15,130,248,1,2,240,91,224,188,15,130,248,0,2,255,235,224,188,15,130,248,1,191,255,251,224,188,15,130,248,127,255,255,235,224,188,15,130,248,127,255,248,11,224,188,15,130,248,127,249,0,11,224,188,15,130,248,57,0,0,11,224,188,15,130,248,0,0,0,11,224,188,15,130,248,0,0,0,11,224,188,15,130,248,0,0,0,11,224,188,15,191,248,0,0,0,11,224,188,15,159,240,0,0,0,6,144,20,0,14,128,
  // 0x7b2c  第
  44,123,35,36,68,38,1,252,0,30,64,0,0,126,0,0,0,0,63,192,0,0,255,0,0,0,0,63,64,0,0,254,0,0,0,0,255,255,255,211,255,255,255,252,1,255,255,255,219,255,255,255,252,3,255,255,255,239,255,255,255,252,11,244,253,0,63,192,255,0,0,47,224,255,0,255,128,127,64,0,127,192,127,2,255,0,63,192,0,63,64,63,0,188,0,31,192,0,10,0,36,0,32,0,9,0,0,0,255,255,255,255,255,255,254,0,0,255,255,255,255,255,255,254,0,0,255,255,255,255,255,255,254,0,0,0,0,0,254,0,0,254,0,0,0,0,0,254,0,0,254,0,0,0,0,0,254,0,0,254,0,0,31,255,255,255,255,255,254,0,0,47,255,255,255,255,255,254,0,0,63,255,255,255,255,255,254,0,0,63,64,0,254,0,0,0,0,0,127,64,0,254,0,0,0,0,0,191,0,0,254,0,0,0,0,0,255,255,255,255,255,255,255,240,0,255,255,255,255,255,255,255,240,1,255,255,255,255,255,255,255,224,1,252,0,127,254,0,0,15,224,0,0,2,255,254,0,0,15,208,0,0,31,252,254,0,0,15,208,0,0,255,224,254,0,0,31,192,0,31,255,64,254,0,0,63,192,1,255,248,0,254,0,255,255,128,47,255,208,0,254,0,255,255,0,15,253,0,0,254,0,191,252,0,7,144,0,0,254,0,0,0,0,0,0,0,0,190,0,0,0,0,
  // 0x7b49  等
  73,123,35,36,68,38,1,252,0,14,64,0,0,126,0,0,0,0,47,192,0,0,255,0,0,0,0,63,128,0,0,254,0,0,0,0,255,255,255,227,255,255,255,252,1,255,255,255,231,255,255,255,252,3,255,255,255,255,255,255,255,252,15,244,253,0,63,208,255,0,0,63,224,191,0,255,128,63,128,0,127,192,63,64,191,0,47,192,0,31,0,57,0,255,0,15,64,0,0,0,0,0,255,0,0,0,0,0,127,255,255,255,255,255,254,0,0,127,255,255,255,255,255,254,0,0,127,255,255,255,255,255,254,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,0,0,61,0,0,1,253,0,0,0,0,255,64,0,1,253,0,0,0,0,255,208,0,1,253,0,0,0,0,47,244,0,1,253,0,0,0,0,11,252,0,1,253,0,0,0,0,2,255,0,1,253,0,0,0,0,0,254,5,6,253,0,0,0,0,0,52,15,255,252,0,0,0,0,0,0,11,255,248,0,0,0,0,0,0,3,255,144,0,0,
  // 0x7bb1  箱
  177,123,35,36,68,38,1,252,0,14,64,0,0,57,0,0,0,0,31,192,0,0,191,0,0,0,0,63,192,0,0,255,0,0,0,0,127,128,0,1,254,0,0,0,0,191,255,255,227,255,255,255,252,0,255,255,255,231,255,255,255,252,3,255,255,255,239,255,255,255,252,7,248,254,0,47,224,254,0,0,15,240,127,0,127,192,127,64,0,63,208,63,129,255,64,47,192,0,47,64,47,64,190,0,15,208,0,6,0,252,0,24,0,10,64,0,0,0,252,0,0,0,0,0,0,0,0,252,0,15,255,255,255,224,0,0,252,0,15,255,255,255,224,47,255,255,255,207,255,255,255,224,47,255,255,255,207,192,0,15,224,47,255,255,255,207,192,0,15,224,0,7,253,0,15,192,0,15,224,0,7,253,0,15,255,255,255,224,0,15,255,64,15,255,255,255,224,0,31,255,208,15,250,170,175,224,0,63,255,244,15,192,0,15,224,0,191,255,253,15,192,0,15,224,1,254,252,255,143,192,0,15,224,3,252,252,63,207,255,255,255,224,11,240,252,31,15,255,255,255,224,47,224,252,9,15,250,170,175,224,127,192,252,0,15,192,0,15,224,63,64,252,0,15,192,0,15,224,30,0,252,0,15,192,0,15,224,4,0,252,0,15,255,255,255,224,0,0,252,0,15,255,255,255,224,0,0,252,0,15,255,255,255,224,0,0,252,0,15,192,0,15,224,0,0,252,0,10,128,0,5,80,
  // 0x7c7b  类
  123,124,35,36,68,38,2,252,0,0,0,2,248,0,0,0,0,0,6,0,3,248,0,30,64,0,0,63,192,3,248,0,63,208,0,0,47,224,3,248,0,191,128,0,0,11,248,3,248,1,255,0,0,0,3,252,3,248,3,252,0,0,0,1,254,3,248,11,244,0,0,21,85,249,87,253,91,229,85,64,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,0,0,1,255,255,244,0,0,0,0,0,11,255,255,254,0,0,0,0,0,127,243,248,255,208,0,0,0,3,255,195,248,63,253,0,0,0,127,254,3,248,11,255,224,0,27,255,244,3,248,0,255,255,144,191,255,64,3,248,0,31,255,208,63,248,0,0,80,5,0,191,128,14,64,0,3,252,47,208,6,0,0,0,0,3,248,31,254,0,0,0,0,0,3,248,1,255,128,0,21,85,85,87,249,85,111,85,64,127,255,255,255,255,255,255,255,224,127,255,255,255,255,255,255,255,224,127,255,255,255,255,255,255,255,224,0,0,0,63,255,128,0,0,0,0,0,0,191,255,224,0,0,0,0,0,2,255,15,248,0,0,0,0,0,31,253,7,255,64,0,0,0,1,255,248,1,255,228,0,0,0,111,255,208,0,127,255,144,0,191,255,255,0,0,11,255,255,244,191,255,244,0,0,1,191,255,224,63,253,0,0,0,0,11,255,192,42,64,0,0,0,0,0,26,64,
  // 0x7d22  索
  34,125,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,63,0,0,127,128,0,0,15,208,63,0,1,255,0,4,0,15,208,63,0,11,252,0,127,64,15,208,63,10,47,224,2,255,128,15,208,0,47,255,64,15,253,0,0,0,0,47,254,0,127,240,0,0,0,0,7,255,210,255,129,192,0,0,0,0,191,255,252,11,248,0,0,0,0,31,255,208,3,255,0,0,0,0,3,254,0,0,191,224,0,0,0,31,254,170,170,255,252,0,127,255,255,255,255,255,255,255,0,127,255,255,255,255,255,255,255,192,63,255,255,255,248,0,0,31,128,0,0,0,3,248,1,208,5,0,0,1,249,3,248,11,248,0,0,0,11,253,3,248,7,255,64,0,0,127,244,3,248,0,191,240,0,2,255,192,3,248,0,31,253,0,47,254,0,3,248,0,2,255,128,191,244,0,3,248,0,0,127,208,47,64,0,3,248,0,0,15,0,4,0,0,3,248,0,0,0,0,
  // 0x7d2b  紫
  43,125,35,36,68,38,1,252,0,0,47,64,2,252,0,0,0,0,0,63,64,2,252,0,0,0,0,0,63,64,2,252,0,6,0,3,240,63,64,2,252,0,191,128,3,240,63,255,242,252,31,255,224,3,240,63,255,242,255,255,255,64,3,240,63,255,242,255,255,208,0,3,240,63,64,2,255,228,0,0,3,240,63,64,2,252,0,0,0,3,240,63,64,2,252,0,0,228,3,240,63,65,162,252,0,0,252,3,240,127,255,241,253,0,2,252,27,255,255,255,241,255,255,255,248,127,255,255,255,144,255,255,255,240,63,255,165,15,208,47,255,255,208,41,64,0,63,224,0,0,0,0,0,0,0,255,128,11,128,0,0,0,3,135,253,0,63,240,0,0,0,31,255,240,1,255,192,0,0,0,31,255,192,11,254,0,0,0,0,1,255,244,63,244,30,0,0,0,0,31,255,255,128,191,192,0,0,0,2,255,253,0,47,240,0,0,0,0,255,224,0,11,253,0,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,224,63,255,255,255,255,255,255,175,248,4,0,0,0,254,0,0,7,252,0,0,32,0,254,0,36,1,208,0,0,255,64,254,1,255,0,0,0,11,254,0,254,1,255,224,0,0,127,248,0,254,0,47,253,0,7,255,208,0,254,0,3,255,192,47,254,0,0,254,0,0,127,244,11,244,0,0,254,0,0,15,224,1,64,0,0,254,0,0,2,0,
  // 0x7ea2  红
  162,126,35,34,50,38,1,254,0,1,144,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,11,244,1,170,170,170,170,160,0,15,240,3,255,255,255,255,244,0,47,208,3,255,255,255,255,244,0,63,192,3,255,255,255,255,244,0,191,0,0,0,3,248,0,0,1,254,1,192,0,3,248,0,0,3,252,3,248,0,3,248,0,0,11,244,11,248,0,3,248,0,0,31,224,31,240,0,3,248,0,0,127,255,255,208,0,3,248,0,0,127,255,255,128,0,3,248,0,0,63,255,255,0,0,3,248,0,0,62,87,252,0,0,3,248,0,0,0,15,244,0,0,3,248,0,0,0,47,224,0,0,3,248,0,0,0,127,192,0,0,3,248,0,0,1,255,0,0,0,3,248,0,0,7,253,26,240,0,3,248,0,0,31,255,255,240,0,3,248,0,0,127,255,255,244,0,3,248,0,0,63,255,254,80,0,3,248,0,0,47,229,0,0,0,3,248,0,0,20,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,16,0,3,248,0,0,0,0,107,240,0,3,248,0,0,0,111,255,240,0,3,248,0,0,127,255,255,251,255,255,255,255,252,127,255,254,71,255,255,255,255,252,63,254,64,7,255,255,255,255,252,57,0,0,6,170,170,170,170,168,
  // 0x7ea7  级
  167,126,35,37,77,38,1,251,0,2,128,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,244,1,85,85,85,84,0,0,15,240,11,255,255,255,252,0,0,15,208,11,255,255,255,248,0,0,47,192,11,255,255,255,244,0,0,63,64,0,15,224,7,240,0,0,191,0,0,15,224,11,240,0,0,253,2,0,15,224,15,224,0,2,248,7,208,15,224,15,208,0,7,240,15,240,15,208,31,192,0,15,224,47,208,15,208,47,192,0,47,213,191,128,15,208,63,128,0,191,255,255,0,31,192,63,255,224,127,255,253,0,31,208,191,255,240,63,235,252,0,31,224,255,255,240,16,11,240,0,47,240,0,15,224,0,31,208,0,47,244,0,15,208,0,63,128,0,63,252,0,47,192,0,255,6,224,63,253,0,63,128,2,254,191,224,63,255,0,63,64,11,255,255,224,127,127,64,191,0,47,255,254,64,191,47,192,254,0,127,255,128,0,254,15,227,252,0,63,208,0,0,253,11,251,248,0,40,0,0,17,252,3,255,240,0,0,0,7,243,252,1,255,208,0,0,0,191,243,248,0,255,192,0,0,31,255,251,244,1,255,224,0,7,255,254,79,240,11,255,248,0,63,255,224,47,208,47,251,255,0,63,253,0,63,192,255,209,255,208,47,128,0,255,139,255,64,127,252,20,0,1,255,31,253,0,15,252,0,0,0,189,11,224,0,2,244,0,0,0,24,2,64,0,0,80,0,0,0,0,0,0,0,0,0,
  // 0x7ebf  线
  191,126,35,36,68,38,2,252,0,1,0,0,0,253,0,0,0,0,11,208,0,0,253,15,0,0,0,15,240,0,0,253,63,224,0,0,31,208,0,0,254,15,253,0,0,47,192,0,0,254,1,253,0,0,63,64,0,0,254,0,56,0,0,191,0,0,0,254,0,1,0,0,254,0,0,0,254,26,255,64,2,252,5,0,5,255,255,255,128,3,244,15,135,255,255,255,255,128,15,224,47,215,255,255,254,80,0,31,192,63,131,255,255,0,0,0,127,150,255,2,64,191,0,0,0,255,255,254,0,0,127,0,0,0,255,255,252,0,0,127,0,22,208,127,239,244,0,0,127,107,255,224,16,15,224,0,1,191,255,255,224,0,63,192,6,255,255,255,254,64,0,191,0,15,255,255,249,0,0,1,253,0,15,255,255,128,1,0,7,248,6,142,144,47,192,11,224,15,251,255,128,0,31,192,31,208,127,255,255,128,0,15,208,63,128,191,255,250,0,0,15,209,255,0,127,249,0,0,0,15,231,253,0,57,0,0,0,0,11,255,244,0,0,0,0,0,0,7,255,208,0,0,0,7,192,0,3,255,64,0,0,6,255,192,0,47,253,0,0,1,191,255,192,1,255,253,0,208,127,255,253,0,31,255,255,0,244,191,255,64,6,255,248,127,129,244,127,208,0,63,255,208,63,247,240,36,0,0,47,253,0,15,255,240,0,0,0,15,128,0,7,255,208,0,0,0,0,0,0,0,191,64,
  // 0x7ec6  细
  198,126,35,36,68,38,1,252,0,0,224,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,3,252,2,255,255,255,255,244,0,7,248,2,255,255,255,255,244,0,15,240,2,255,255,255,255,244,0,31,224,2,254,171,250,171,244,0,63,192,2,248,3,244,3,244,0,127,64,2,248,3,244,3,244,0,255,0,2,248,3,244,3,244,2,252,0,210,248,3,244,3,244,7,244,3,250,248,3,244,3,244,15,240,7,250,248,3,244,3,244,127,234,255,242,248,3,244,3,244,127,255,255,194,248,3,244,3,244,63,255,255,66,248,3,244,3,244,63,166,254,2,248,3,244,3,244,0,3,252,2,255,255,255,255,244,0,15,240,2,255,255,255,255,244,0,63,192,2,255,255,255,255,244,0,255,0,2,249,87,249,87,244,3,253,22,182,248,3,244,3,244,15,255,255,246,248,3,244,3,244,127,255,255,246,248,3,244,3,244,63,255,254,146,248,3,244,3,244,47,249,0,2,248,3,244,3,244,24,0,0,2,248,3,244,3,244,0,0,0,2,248,3,244,3,244,0,0,0,2,248,3,244,3,244,0,0,1,182,248,3,244,3,244,0,26,255,246,249,87,249,87,244,47,255,255,246,255,255,255,255,244,127,255,255,146,255,255,255,255,244,63,254,80,2,255,255,255,255,244,57,0,0,2,248,0,0,3,244,0,0,0,2,248,0,0,3,244,0,0,0,0,80,0,0,0,0,
  // 0x7ec8  终
  200,126,36,36,68,38,1,252,0,2,64,0,0,105,0,0,0,0,3,244,0,0,255,0,0,0,0,11,244,0,1,254,0,0,0,0,15,240,0,3,252,0,0,0,0,31,208,0,7,255,255,255,64,0,63,192,0,15,255,255,255,192,0,127,64,0,63,255,255,255,192,0,255,0,0,191,208,0,191,64,1,253,1,1,255,240,0,254,0,3,252,7,199,255,244,3,252,0,7,244,15,255,250,252,7,248,0,15,224,31,255,224,255,31,240,0,47,192,63,203,128,127,255,192,0,191,255,255,1,0,47,255,64,0,127,255,254,0,0,15,254,0,0,63,255,252,0,0,47,255,64,0,37,11,240,0,1,255,255,224,0,0,31,208,0,11,255,111,253,0,0,63,128,0,191,248,7,255,208,0,255,0,31,255,208,0,255,254,2,252,0,95,254,0,0,31,253,11,250,255,211,224,30,64,2,248,63,255,255,209,0,127,244,0,16,63,255,255,208,0,47,255,64,0,63,254,80,0,0,2,255,224,0,41,0,0,0,0,0,47,240,0,0,0,0,0,0,0,3,192,0,0,0,0,0,9,0,0,0,0,0,0,6,240,63,228,0,0,0,0,91,255,240,191,255,144,0,0,127,255,255,244,27,255,253,0,0,127,255,254,64,0,111,255,224,0,127,249,64,0,0,1,255,254,0,37,0,0,0,0,0,11,255,64,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,8,0,
  // 0x7ed3  结
  211,126,35,36,68,38,1,252,0,2,64,0,0,3,248,0,0,0,3,244,0,0,3,248,0,0,0,11,248,0,0,3,248,0,0,0,15,240,0,0,3,248,0,0,0,31,224,0,0,3,248,0,0,0,63,192,7,255,255,255,255,252,0,127,128,7,255,255,255,255,252,0,255,0,7,255,255,255,255,252,2,253,3,129,85,87,253,85,84,3,252,7,244,0,3,248,0,0,11,240,15,244,0,3,248,0,0,31,224,31,224,0,3,248,0,0,127,234,255,192,0,3,248,0,0,191,255,255,64,0,3,248,0,0,127,255,255,1,255,255,255,255,240,63,235,252,1,255,255,255,255,240,0,11,244,1,255,255,255,255,240,0,47,224,0,85,85,85,85,80,0,127,192,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,3,253,26,244,0,0,0,0,0,15,255,255,244,127,255,255,255,208,127,255,255,244,127,255,255,255,208,63,255,254,64,127,255,255,255,208,63,233,0,0,127,0,0,31,208,20,0,0,0,127,0,0,31,208,0,0,0,0,127,0,0,31,208,0,0,0,0,127,0,0,31,208,0,0,27,248,127,0,0,31,208,0,111,255,248,127,0,0,31,208,127,255,255,248,127,0,0,31,208,127,255,255,144,127,255,255,255,208,127,254,64,0,127,255,255,255,208,57,64,0,0,127,255,255,255,208,0,0,0,0,127,0,0,31,208,0,0,0,0,127,0,0,10,128,
  // 0x7ed9  给
  217,126,35,36,68,38,1,252,0,2,64,0,0,6,64,0,0,0,3,244,0,0,15,240,0,0,0,11,244,0,0,31,240,0,0,0,15,240,0,0,47,240,0,0,0,31,208,0,0,63,252,0,0,0,63,192,0,0,191,253,0,0,0,127,64,0,1,255,191,0,0,0,255,0,0,3,252,63,192,0,1,253,3,0,11,248,31,224,0,3,252,11,224,31,240,11,248,0,7,240,15,240,63,208,3,254,0,15,224,47,208,255,128,0,255,128,63,214,191,131,255,0,0,191,240,191,255,255,31,255,255,255,255,252,63,255,253,63,255,255,255,247,248,63,235,252,31,207,255,255,241,224,16,15,240,6,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,3,252,22,224,255,255,255,254,0,15,255,255,208,255,255,255,254,0,63,255,255,208,255,255,255,254,0,63,255,249,0,253,0,0,254,0,47,228,0,0,253,0,0,254,0,24,0,0,0,253,0,0,254,0,0,0,0,0,253,0,0,254,0,0,0,0,0,253,0,0,254,0,0,0,111,224,253,0,0,254,0,0,111,255,240,253,0,0,254,0,63,255,255,224,253,0,0,254,0,63,255,249,0,255,255,255,254,0,63,249,0,0,255,255,255,254,0,41,0,0,0,255,255,255,254,0,0,0,0,0,253,0,0,254,0,0,0,0,0,253,0,0,254,0,
  // 0x7edf  统
  223,126,36,36,68,38,1,252,0,2,64,0,0,6,128,0,0,0,3,248,0,0,31,192,0,0,0,7,248,0,0,15,224,0,0,0,15,240,0,0,11,240,0,0,0,31,224,0,0,7,248,0,0,0,63,192,0,0,3,228,0,0,0,63,192,11,255,255,255,255,252,0,191,64,11,255,255,255,255,252,0,254,1,11,255,255,255,255,252,3,252,11,208,0,191,128,0,0,7,244,15,240,1,255,0,32,0,15,240,47,208,3,252,2,248,0,63,230,191,128,15,244,2,252,0,191,255,255,0,47,224,0,255,0,63,255,253,0,191,192,0,127,128,63,255,252,2,255,154,191,255,208,20,15,240,31,255,255,255,255,240,0,47,208,15,255,255,255,251,244,0,127,128,11,255,165,64,3,252,0,255,0,69,10,144,42,65,224,3,253,111,192,15,208,63,128,0,15,255,255,192,15,208,63,128,0,63,255,255,192,15,208,63,128,0,63,255,228,0,15,208,63,128,0,47,228,0,0,31,192,63,128,0,20,0,0,0,47,192,63,128,0,0,0,0,64,63,192,63,128,0,0,0,31,208,63,128,63,128,180,0,7,255,224,191,0,63,128,189,6,255,255,208,255,0,63,128,189,63,255,248,3,253,0,63,128,252,63,254,64,31,252,0,63,128,252,63,208,1,255,240,0,47,255,252,20,0,0,255,192,0,31,255,244,0,0,0,126,0,0,7,255,224,0,0,0,32,0,0,0,0,0,
  // 0x7ee7  继
  231,126,35,34,50,38,1,254,0,3,64,0,0,0,42,0,0,0,7,240,1,64,0,63,0,0,0,15,240,7,224,0,63,0,0,0,15,208,7,225,224,63,2,224,0,47,192,7,226,240,63,3,240,0,63,128,7,224,244,63,3,224,0,127,0,7,224,248,63,11,192,0,255,0,7,224,188,63,15,128,1,252,1,7,224,125,63,31,64,2,248,11,135,224,62,63,47,0,3,240,15,231,224,16,63,4,0,15,224,47,199,224,0,63,0,0,47,192,63,71,231,255,255,255,252,127,255,255,7,231,255,255,255,252,127,255,253,7,231,255,255,255,252,63,255,248,7,224,0,255,192,0,21,11,240,7,224,2,255,224,0,0,31,208,7,224,3,255,244,0,0,63,128,7,224,11,255,252,0,0,255,0,7,224,15,191,127,0,2,252,5,135,224,47,63,47,128,11,254,255,199,224,126,63,15,224,47,255,255,199,224,252,63,3,244,63,255,250,71,227,248,63,2,248,63,249,0,7,227,240,63,0,240,25,0,0,7,226,208,63,0,64,0,0,0,7,224,64,63,0,0,0,0,1,135,224,0,63,0,0,0,1,191,215,224,0,63,0,0,1,191,255,215,224,0,42,0,0,127,255,255,135,224,0,0,0,0,63,255,144,7,255,255,255,255,252,63,144,0,7,255,255,255,255,252,16,0,0,7,255,255,255,255,252,
  // 0x7eea  绪
  234,126,36,36,68,38,1,252,0,2,0,0,0,47,64,0,0,0,3,224,0,0,63,64,0,0,0,7,240,0,0,63,64,1,64,0,15,224,0,0,63,64,3,244,0,15,208,0,0,63,64,11,240,0,47,192,2,255,255,255,223,224,0,63,64,2,255,255,255,255,192,0,191,0,2,255,255,255,255,128,0,253,0,0,0,63,64,255,0,2,252,3,128,0,63,67,252,0,3,240,15,240,0,63,75,244,0,15,224,31,208,0,63,95,224,0,47,213,191,175,255,255,255,255,253,127,255,255,47,255,255,255,255,253,63,255,253,47,255,255,255,255,253,63,235,252,0,0,47,244,0,0,16,11,240,0,0,191,208,0,0,0,15,208,0,3,255,64,0,0,0,63,128,0,31,254,0,0,0,0,191,0,0,191,255,255,255,208,1,252,1,11,255,255,255,255,208,7,254,255,191,255,255,255,255,208,31,255,255,191,255,192,0,15,208,63,255,250,15,95,192,0,15,208,47,229,0,0,31,192,0,15,208,20,0,0,0,31,255,255,255,208,0,0,0,0,31,255,255,255,208,0,0,0,80,31,255,255,255,208,0,1,175,240,31,192,0,15,208,1,191,255,240,31,192,0,15,208,63,255,255,144,31,192,0,15,208,63,255,144,0,31,255,255,255,208,63,144,0,0,31,255,255,255,208,20,0,0,0,31,255,255,255,208,0,0,0,0,31,192,0,15,208,0,0,0,0,10,128,0,5,64,
  // 0x7eed  续
  237,126,35,37,77,38,1,251,0,1,64,0,0,11,224,0,0,0,3,240,0,0,11,224,0,0,0,7,240,0,0,11,224,0,0,0,11,224,1,255,255,255,255,128,0,15,208,1,255,255,255,255,128,0,47,192,1,255,255,255,255,128,0,63,64,0,0,11,224,0,0,0,127,0,0,0,11,224,0,0,0,253,4,0,0,11,224,0,0,1,252,15,128,0,11,224,0,0,3,240,31,203,255,255,255,255,244,11,224,63,139,255,255,255,255,244,31,193,127,11,255,255,255,255,240,127,255,253,0,0,0,0,7,224,127,255,252,0,13,2,244,11,208,63,255,244,0,63,131,244,15,192,20,11,224,0,15,243,244,31,128,0,31,192,1,2,251,244,11,64,0,63,64,7,208,115,244,0,0,0,190,0,7,252,3,244,0,0,1,253,111,64,255,3,244,0,0,7,255,255,64,47,3,244,0,0,31,255,255,64,4,3,240,0,0,63,255,144,47,255,255,255,255,244,63,228,0,47,255,255,255,255,244,24,0,0,47,255,255,255,255,244,0,0,2,64,0,47,192,0,0,0,0,127,128,0,127,134,0,0,0,31,255,192,0,255,31,192,0,6,255,254,0,3,253,31,244,0,63,255,208,0,31,248,3,254,0,63,248,0,0,191,224,0,191,192,63,64,0,11,255,64,0,47,240,16,0,0,63,253,0,0,7,252,0,0,0,31,224,0,0,1,248,0,0,0,10,0,0,0,0,96,0,0,0,0,0,0,0,0,0,
  // 0x7eff  绿
  255,126,36,35,59,38,1,252,0,11,128,0,0,0,0,0,0,0,15,240,1,255,255,255,255,192,0,31,224,1,255,255,255,255,192,0,47,192,1,255,255,255,255,192,0,63,128,0,0,0,0,47,192,0,191,0,0,0,0,0,47,128,0,254,0,0,106,170,170,191,128,1,252,9,0,191,255,255,255,128,3,248,15,128,191,255,255,255,128,11,240,47,192,0,0,0,63,128,15,224,63,64,0,0,0,63,64,47,192,191,0,0,0,0,63,64,127,255,252,7,255,255,255,255,253,127,255,248,7,255,255,255,255,253,63,255,240,7,255,255,255,255,253,41,15,208,0,0,3,244,0,0,0,47,128,0,0,3,240,0,0,0,63,0,1,240,3,240,0,64,0,253,0,3,252,3,240,3,248,2,248,5,0,255,3,240,11,240,7,255,255,64,63,195,244,63,128,31,255,255,64,31,211,252,254,0,63,255,254,0,7,71,255,244,0,63,254,64,0,0,63,255,192,0,45,0,0,0,1,255,255,208,0,0,0,0,0,11,255,255,244,0,0,0,6,64,127,243,247,253,0,0,1,191,66,255,131,240,255,128,0,127,255,159,253,3,240,63,244,47,255,254,31,240,3,240,15,254,63,255,144,15,128,3,240,2,252,63,228,0,1,0,3,240,0,112,41,0,0,0,2,255,240,0,0,0,0,0,0,1,255,240,0,0,0,0,0,0,0,255,128,0,0,
  // 0x7f16  编
  22,127,35,36,68,38,1,252,0,6,64,0,0,6,208,0,0,0,11,240,0,0,15,240,0,0,0,15,224,0,0,11,244,0,0,0,31,192,0,0,3,248,0,0,0,47,192,7,255,255,255,255,240,0,63,64,7,255,255,255,255,240,0,127,0,7,255,255,255,255,240,0,253,0,7,240,0,0,7,240,1,252,12,7,240,0,0,7,240,3,248,31,135,240,0,0,7,240,3,240,63,135,240,0,0,7,240,15,208,127,7,255,255,255,255,240,31,193,254,7,255,255,255,255,240,127,255,252,7,255,255,255,255,240,127,255,248,7,240,0,0,0,0,63,255,240,7,240,0,0,0,0,41,15,208,11,224,0,0,0,0,0,47,192,11,255,255,255,255,244,0,63,0,11,255,255,255,255,244,0,254,0,11,255,255,255,255,244,2,252,22,15,255,7,195,209,244,11,255,255,15,255,7,195,209,244,63,255,255,15,255,7,195,209,244,63,255,144,15,239,7,195,209,244,47,144,0,31,239,255,255,255,244,0,0,0,47,175,255,255,255,244,0,0,46,63,111,255,255,255,244,0,6,255,63,47,7,195,209,244,0,127,255,127,47,7,195,209,244,27,255,244,190,47,7,195,209,244,127,254,0,253,47,7,195,209,244,63,224,1,252,47,7,195,209,244,62,0,3,248,47,7,195,209,244,16,0,3,244,47,7,195,223,244,0,0,0,176,47,2,130,143,240,0,0,0,0,26,0,0,6,64,
  // 0x7f3a  缺
  58,127,36,36,68,38,1,252,2,228,0,0,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,244,0,0,0,7,240,0,0,7,244,0,0,0,7,240,0,0,11,255,255,255,0,7,240,0,0,15,255,255,255,47,255,255,255,192,15,255,255,255,47,255,255,255,192,47,195,244,0,47,255,255,255,192,63,131,244,0,5,91,245,111,192,127,67,244,0,0,7,240,31,192,127,3,244,0,0,7,240,31,192,5,3,244,0,0,7,240,31,192,127,255,255,255,128,7,240,31,192,127,255,255,255,128,7,240,31,192,127,255,255,255,128,7,240,31,192,0,3,248,0,0,7,240,31,192,0,3,244,0,63,255,255,255,253,5,3,244,0,63,255,255,255,253,31,131,244,63,63,255,255,255,253,31,131,244,63,21,95,254,85,84,31,131,244,63,0,15,255,0,0,31,131,244,63,0,31,255,0,0,31,131,244,63,0,47,255,128,0,31,131,244,63,0,63,175,192,0,31,131,244,63,0,127,79,224,0,31,131,244,63,0,255,15,240,0,31,255,255,255,1,254,7,248,0,31,255,255,255,3,252,3,253,0,31,255,255,255,15,248,1,255,0,31,128,0,63,47,240,0,191,192,31,128,0,63,191,208,0,63,240,31,128,0,23,255,64,0,31,253,10,64,0,11,254,0,0,7,253,0,0,0,3,244,0,0,1,244,0,0,0,0,128,0,0,0,96,
  // 0x7f51  网
  81,127,32,34,16,38,3,252,21,85,85,85,85,85,85,85,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,190,0,11,224,0,253,0,191,190,0,11,224,0,253,0,191,190,0,11,208,0,253,0,191,190,0,11,208,0,253,0,191,190,0,15,208,0,252,0,191,190,0,15,208,128,252,0,191,190,29,15,194,240,252,0,191,190,63,79,195,253,252,0,191,190,63,239,193,255,252,0,191,190,11,255,192,127,252,0,191,190,2,255,128,31,248,0,191,190,0,255,128,7,252,0,191,190,0,63,192,3,254,0,191,190,0,63,240,3,255,128,191,190,0,63,252,3,255,208,191,190,0,127,254,7,255,240,191,190,0,190,191,11,227,252,191,190,0,253,63,15,209,248,191,190,0,252,12,31,192,176,191,190,2,248,0,47,192,0,191,190,3,244,0,63,64,0,191,190,11,240,0,191,0,0,191,190,15,224,0,254,0,0,191,190,63,192,3,252,0,0,191,190,63,128,7,248,0,0,191,190,15,0,1,240,0,0,191,190,0,0,0,64,1,85,255,190,0,0,0,0,3,255,254,190,0,0,0,0,2,255,252,190,0,0,0,0,1,255,224,
  // 0x7f6e  置
  110,127,35,35,59,38,2,252,5,85,85,85,85,85,85,85,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,11,224,3,240,1,252,0,191,0,11,224,3,240,1,252,0,191,0,11,224,3,240,1,252,0,191,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,5,85,85,86,254,85,85,85,0,0,0,0,1,252,0,0,0,0,42,170,170,171,254,170,170,170,128,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,1,80,31,255,255,255,255,244,0,7,240,31,255,255,255,255,244,0,7,240,31,192,0,0,3,244,0,7,240,31,192,0,0,3,244,0,7,240,31,255,255,255,255,244,0,7,240,31,255,255,255,255,244,0,7,240,31,192,0,0,3,244,0,7,240,31,192,0,0,3,244,0,7,240,31,255,255,255,255,244,0,7,240,31,255,255,255,255,244,0,7,240,31,192,0,0,3,244,0,7,240,31,192,0,0,3,244,0,7,240,31,255,255,255,255,244,0,7,240,31,255,255,255,255,244,0,7,240,0,0,0,0,0,0,0,7,255,255,255,255,255,255,255,240,7,255,255,255,255,255,255,255,244,7,255,255,255,255,255,255,255,244,7,240,0,0,0,0,0,0,0,2,160,0,0,0,0,0,0,0,
  // 0x7f72  署
  114,127,35,35,59,38,1,252,1,85,85,85,85,85,85,85,64,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,248,0,252,0,127,0,47,192,2,248,0,252,0,127,0,47,192,2,248,0,252,0,127,0,47,192,2,253,86,254,85,191,85,127,192,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,13,0,0,47,255,255,255,255,248,127,128,0,63,255,255,255,255,249,255,128,0,63,255,255,255,255,255,253,0,0,0,0,3,248,0,127,244,0,0,0,0,3,248,3,255,128,0,47,255,255,255,255,255,255,255,248,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,0,7,255,244,0,0,0,0,0,1,191,255,64,0,0,0,0,0,47,255,254,170,170,169,0,0,27,255,255,255,255,255,253,0,27,255,255,255,255,255,255,253,0,127,255,255,64,0,0,0,253,0,47,254,63,64,0,0,0,253,0,14,64,63,149,85,85,85,253,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,63,64,0,0,0,253,0,0,0,63,64,0,0,0,253,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,63,170,170,170,170,253,0,0,0,63,0,0,0,0,169,0,
  // 0x8005  者
  5,128,35,37,77,38,1,251,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,4,0,0,0,0,31,192,0,0,47,0,0,0,0,31,192,0,0,127,192,0,0,0,31,208,0,0,255,0,0,191,255,255,255,255,243,253,0,0,191,255,255,255,255,255,248,0,0,191,255,255,255,255,255,224,0,0,0,0,31,192,0,255,128,0,0,0,0,31,192,7,254,0,0,0,0,0,31,192,31,248,0,0,0,0,0,31,192,191,208,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,0,0,0,11,255,64,0,0,0,0,0,0,63,252,0,0,0,0,0,0,2,255,224,0,0,0,0,0,0,31,255,64,0,0,0,0,0,1,255,255,255,255,255,244,0,0,47,255,255,255,255,255,244,0,6,255,255,255,255,255,255,244,0,127,255,255,64,0,0,7,244,0,63,249,63,64,0,0,7,244,0,31,128,63,64,0,0,7,244,0,4,0,63,255,255,255,255,244,0,0,0,63,255,255,255,255,244,0,0,0,63,255,255,255,255,244,0,0,0,63,64,0,0,7,244,0,0,0,63,64,0,0,7,244,0,0,0,63,64,0,0,7,244,0,0,0,63,64,0,0,7,244,0,0,0,63,255,255,255,255,244,0,0,0,63,255,255,255,255,244,0,0,0,63,255,255,255,255,244,0,0,0,63,64,0,0,7,244,0,0,0,0,0,0,0,0,0,0,
  // 0x806a  聪
  106,128,36,36,68,38,1,252,0,0,0,0,1,64,0,36,0,0,0,0,0,15,192,0,127,0,63,255,255,252,15,224,0,255,0,63,255,255,252,7,244,0,253,0,63,255,255,252,3,252,2,252,0,3,224,15,192,1,252,3,244,0,3,224,15,192,0,253,7,240,0,3,224,15,192,0,164,15,208,0,3,224,15,192,191,255,255,255,224,3,224,15,192,191,255,255,255,224,3,255,255,192,191,255,255,255,224,3,255,255,192,190,0,0,11,224,3,255,255,192,190,0,0,11,224,3,224,15,192,190,0,0,11,224,3,224,15,192,190,0,0,11,224,3,224,15,192,190,0,0,11,224,3,224,15,192,190,0,0,11,224,3,224,15,192,191,255,255,255,224,3,255,255,192,191,255,255,255,224,3,255,255,192,191,255,255,255,224,3,255,255,192,0,0,64,0,0,3,224,15,192,0,7,208,0,0,3,224,15,192,0,3,240,0,0,3,224,15,192,1,245,252,1,0,3,224,15,232,229,244,190,15,192,3,224,111,252,249,244,63,75,208,7,255,255,253,245,244,31,131,240,127,255,255,230,241,244,8,3,244,127,255,239,194,241,244,0,1,248,63,144,15,195,241,244,0,124,252,16,0,15,199,225,244,0,124,189,0,0,15,207,209,244,0,188,62,0,0,15,203,193,255,255,252,36,0,0,15,192,64,255,255,244,0,0,0,15,192,0,127,255,224,0,0,0,15,192,0,0,0,0,0,
  // 0x80fd  能
  253,128,36,37,77,38,1,251,0,10,64,0,0,253,0,0,0,0,15,240,0,0,253,0,0,0,0,31,224,0,0,253,0,0,0,0,47,192,108,0,253,0,31,0,0,63,193,253,0,253,1,255,128,0,127,64,191,0,253,47,255,192,0,255,0,63,128,255,255,253,0,1,253,0,47,192,255,255,128,0,127,255,255,255,224,255,224,0,0,127,255,255,255,240,253,0,0,0,63,255,255,255,248,253,0,0,224,21,85,80,2,252,253,0,0,253,0,0,0,0,208,253,0,0,252,0,0,0,0,0,254,0,2,252,3,255,255,255,128,255,255,255,252,3,255,255,255,128,191,255,255,244,3,255,255,255,128,47,255,255,208,3,240,0,63,128,0,0,0,0,3,240,0,63,128,253,0,0,0,3,240,0,63,128,253,0,0,0,3,255,255,255,128,253,0,7,0,3,255,255,255,128,253,0,111,192,3,250,170,191,128,253,7,255,224,3,240,0,63,128,254,191,255,64,3,240,0,63,128,255,255,228,0,3,250,170,191,128,255,249,0,0,3,255,255,255,128,255,64,0,0,3,255,255,255,128,253,0,0,80,3,240,0,63,128,253,0,0,125,3,240,0,63,128,253,0,0,190,3,240,0,63,128,253,0,0,190,3,240,0,63,128,254,0,1,253,3,240,0,63,128,255,255,255,252,3,240,63,255,64,191,255,255,248,3,240,31,255,0,31,255,255,208,3,240,15,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x81ea  自
  234,129,27,37,3,38,6,251,0,0,3,164,0,0,0,0,0,7,252,0,0,0,0,0,11,244,0,0,0,0,0,15,240,0,0,0,0,0,15,224,0,0,0,85,85,111,229,85,85,80,255,255,255,255,255,255,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,85,85,85,85,87,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,254,85,85,85,85,87,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,0,0,0,0,3,248,254,85,85,85,85,87,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,254,0,0,0,0,3,248,254,0,0,0,0,3,244,0,0,0,0,0,0,0,
  // 0x81f3  至
  243,129,34,33,41,38,2,253,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,21,85,87,253,85,85,85,85,64,0,0,11,252,0,11,0,0,0,0,0,15,244,0,63,192,0,0,0,0,47,240,0,127,244,0,0,0,0,63,208,0,15,253,0,0,0,0,127,128,0,3,255,128,0,0,0,255,0,0,0,255,224,0,26,171,255,171,255,255,255,248,0,31,255,255,255,255,255,255,254,0,31,255,255,255,255,255,255,255,128,31,255,254,170,165,85,0,191,192,0,0,0,0,0,0,0,47,0,0,0,0,3,248,0,0,8,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,1,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,248,0,1,255,255,255,255,255,255,248,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,21,85,85,85,85,85,85,85,80,
  // 0x83dc  菜
  220,131,34,36,68,38,2,252,0,0,63,64,0,31,192,0,0,0,0,63,64,0,31,192,0,0,0,0,63,128,0,47,192,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,63,64,0,31,192,0,0,0,0,63,64,0,31,192,0,0,0,0,42,64,0,22,255,208,0,0,1,85,170,191,255,255,244,0,31,255,255,255,255,255,255,248,0,15,255,255,255,255,254,148,0,0,15,255,254,169,80,0,0,128,0,0,0,0,6,192,0,2,253,0,1,184,0,15,208,0,3,252,0,2,253,0,11,240,0,11,244,0,0,255,0,7,244,0,15,240,0,0,63,128,3,248,0,47,192,0,0,47,192,2,224,0,127,64,0,0,15,128,3,248,0,190,0,0,0,4,0,3,248,0,8,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,0,0,2,255,255,244,0,0,0,0,0,11,255,255,253,0,0,0,0,0,127,243,248,255,128,0,0,0,2,255,195,248,63,248,0,0,0,47,254,3,248,15,255,128,0,6,255,244,3,248,2,255,249,0,191,255,192,3,248,0,63,255,224,255,253,0,3,248,0,7,255,224,127,208,0,3,248,0,0,127,192,41,0,0,3,248,0,0,6,64,0,0,0,3,248,0,0,0,0,
  // 0x84dd  蓝
  221,132,34,35,59,38,2,253,0,0,42,0,0,10,144,0,0,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,0,0,0,0,1,232,0,0,0,0,0,15,208,2,252,0,0,0,3,240,15,208,3,248,0,0,0,3,240,15,208,7,255,255,255,64,3,240,15,208,11,255,255,255,64,3,240,15,208,15,255,255,255,64,3,240,15,208,47,192,16,0,0,3,240,15,208,63,130,244,0,0,3,240,15,208,255,3,252,0,0,3,240,15,210,254,0,255,0,0,3,240,15,210,252,0,127,64,0,3,240,15,208,116,0,47,192,0,3,240,15,208,0,0,15,208,0,0,0,15,208,0,0,11,64,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,255,255,255,255,255,255,244,0,0,253,0,248,2,244,3,244,0,0,253,0,248,2,244,3,244,0,0,253,0,248,2,244,3,244,0,0,253,0,248,2,244,3,244,0,0,253,0,248,2,244,3,244,0,0,253,0,252,2,244,3,244,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x86c7  蛇
  199,134,35,36,68,38,1,252,0,1,80,0,0,1,168,0,0,0,7,240,0,0,1,252,0,0,0,7,240,0,0,1,252,0,0,0,7,240,0,0,1,252,0,0,0,7,240,0,0,1,252,0,0,0,7,240,0,0,2,252,0,0,0,7,240,0,255,255,255,255,252,15,255,255,248,255,255,255,255,252,31,255,255,252,255,255,255,255,252,31,255,255,252,252,0,0,1,252,31,67,208,252,252,0,0,1,252,31,67,208,252,252,0,0,1,252,31,67,208,252,255,240,0,1,252,31,67,208,252,7,240,0,0,0,31,67,208,252,3,240,0,0,0,31,67,208,252,3,240,0,15,0,31,67,208,252,3,240,0,191,192,31,67,208,252,3,240,11,255,208,31,255,255,252,3,240,191,254,0,31,255,255,252,3,255,255,224,0,31,255,255,252,3,255,253,0,0,31,71,224,0,3,255,144,0,0,31,71,224,0,3,248,0,0,0,0,7,224,96,3,240,0,0,0,0,7,225,248,3,240,0,0,0,0,7,224,252,3,240,0,0,0,0,7,224,252,3,240,0,0,64,0,7,224,125,3,240,0,0,248,0,7,245,191,3,240,0,0,252,0,111,255,255,3,240,0,0,252,127,255,255,255,67,240,0,0,252,127,255,255,175,67,244,0,2,248,63,254,64,31,131,255,255,255,244,37,0,0,15,66,255,255,255,240,0,0,0,0,0,127,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x884c  行
  76,136,35,36,68,38,1,252,0,0,32,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,2,254,0,85,85,85,85,80,0,11,252,1,255,255,255,255,240,0,47,240,1,255,255,255,255,240,0,191,192,1,255,255,255,255,240,3,255,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,127,240,4,0,0,0,0,0,0,63,192,15,144,0,0,0,0,0,14,0,63,208,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,3,253,15,255,255,255,255,252,0,15,248,15,255,255,255,255,252,0,63,240,15,255,255,255,255,252,0,255,224,5,85,85,95,245,84,3,255,224,0,0,0,15,224,0,31,255,224,0,0,0,15,224,0,127,255,224,0,0,0,15,224,0,191,207,224,0,0,0,15,224,0,47,15,224,0,0,0,15,224,0,12,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,0,0,15,224,0,0,15,224,0,1,255,255,224,0,0,15,224,0,0,255,255,208,0,0,15,224,0,0,191,255,128,0,0,10,160,0,0,21,84,0,0,
  // 0x88ab  被
  171,136,36,36,68,38,1,252,0,15,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,0,0,1,252,0,0,0,31,192,1,255,255,255,255,252,63,255,255,193,255,255,255,255,252,63,255,255,241,255,255,255,255,252,63,255,255,209,252,2,252,3,248,0,0,47,193,252,1,252,3,244,0,0,63,129,252,1,252,3,240,0,0,127,1,252,1,252,11,240,0,0,253,1,252,1,252,6,208,0,3,252,33,252,1,252,0,0,0,11,244,189,255,255,255,255,208,0,31,241,249,255,255,255,255,240,0,127,251,225,255,255,255,255,208,0,255,255,193,255,244,0,31,192,3,255,255,66,255,248,0,63,192,31,255,239,194,249,252,0,63,128,191,255,207,226,248,253,0,191,0,191,143,195,243,244,191,0,255,0,62,15,193,211,244,63,130,253,0,40,15,192,67,240,47,199,252,0,0,15,192,7,240,15,255,244,0,0,15,192,11,240,7,255,224,0,0,15,192,15,224,3,255,192,0,0,15,192,15,208,2,255,128,0,0,15,192,31,192,15,255,240,0,0,15,192,63,128,127,255,253,0,0,15,192,127,66,255,215,255,208,0,15,192,255,47,255,1,255,253,0,15,194,253,63,248,0,63,253,0,15,192,188,31,208,0,7,244,0,15,192,20,9,0,0,0,96,
  // 0x88c5  装
  197,136,36,37,77,38,1,251,0,0,63,0,0,7,240,0,0,0,0,63,0,0,7,240,0,0,3,64,63,0,0,7,240,0,0,15,224,63,0,0,7,240,0,0,15,252,63,0,0,7,240,0,0,2,255,63,15,255,255,255,255,252,0,190,63,15,255,255,255,255,252,0,40,63,15,255,255,255,255,252,0,0,63,0,0,7,240,0,0,0,0,63,0,0,7,240,0,0,0,1,63,0,0,7,240,0,0,0,31,127,0,0,7,240,0,0,2,255,191,0,0,7,240,0,0,47,255,191,0,0,7,240,0,0,127,248,63,3,255,255,255,255,240,63,64,63,3,255,255,255,255,240,20,0,63,3,255,255,255,255,240,0,0,63,0,0,0,0,0,0,0,0,42,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,63,255,255,255,255,255,255,255,252,63,255,255,255,255,255,255,255,252,47,255,255,255,255,255,255,255,252,0,0,1,255,143,224,0,29,0,0,0,31,253,3,244,0,191,128,0,6,255,224,2,252,7,255,64,6,255,255,128,0,255,127,244,0,127,255,255,128,0,63,255,128,0,31,249,47,128,0,15,252,0,0,9,0,47,128,1,67,255,64,0,0,0,47,218,255,192,255,244,0,0,26,255,255,255,192,47,255,144,0,63,255,255,254,128,3,255,253,0,63,255,165,0,0,0,111,248,0,25,64,0,0,0,0,1,176,0,0,0,0,0,0,0,0,0,
  // 0x8981  要
  129,137,34,35,59,38,2,251,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,11,240,3,240,2,252,0,191,0,11,240,3,240,2,252,0,191,0,11,240,3,240,2,252,0,191,0,11,240,3,240,2,252,0,191,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,11,255,255,255,255,255,255,255,0,0,0,0,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,248,0,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,255,0,0,7,248,0,0,0,3,253,0,0,15,240,0,0,0,7,248,0,0,63,208,0,0,0,15,255,144,0,255,128,0,0,0,63,255,255,151,255,0,0,0,0,47,239,255,255,252,0,0,0,0,0,0,111,255,255,144,0,0,0,0,1,191,255,255,254,64,0,1,90,255,255,245,191,255,249,0,63,255,255,254,64,2,255,255,128,47,255,254,64,0,0,11,255,0,31,169,0,0,0,0,0,45,0,0,0,0,0,0,0,0,0,0,
  // 0x89d2  角
  210,137,32,37,40,38,1,251,0,0,3,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,15,255,255,255,64,0,0,0,63,255,255,255,208,0,0,0,191,255,255,255,192,0,0,0,255,0,0,191,128,0,0,3,253,0,0,255,0,0,0,15,248,0,2,253,0,0,0,63,240,0,3,248,0,0,0,255,255,255,255,255,255,255,3,255,255,255,255,255,255,255,31,255,255,255,255,255,255,255,15,255,224,0,63,128,0,127,3,139,224,0,63,128,0,127,0,11,224,0,63,128,0,127,0,11,224,0,63,128,0,127,0,11,224,0,63,128,0,127,0,11,255,255,255,255,255,255,0,15,255,255,255,255,255,255,0,15,255,255,255,255,255,255,0,15,224,0,63,128,0,127,0,15,224,0,63,128,0,127,0,15,208,0,63,128,0,127,0,15,208,0,63,128,0,127,0,31,255,255,255,255,255,255,0,47,255,255,255,255,255,255,0,63,255,255,255,255,255,255,0,63,64,0,0,0,0,127,0,191,0,0,0,0,0,127,0,254,0,0,0,0,0,127,3,253,0,0,0,0,0,127,11,248,0,0,0,0,0,127,31,240,0,0,0,21,85,191,127,208,0,0,0,47,255,255,47,128,0,0,0,15,255,253,10,0,0,0,0,15,255,224,0,0,0,0,0,0,0,0,
  // 0x8ba1  计
  161,139,35,36,68,38,2,252,0,0,0,0,0,26,128,0,0,0,176,0,0,0,47,192,0,0,1,253,0,0,0,47,192,0,0,2,255,64,0,0,47,192,0,0,0,191,208,0,0,47,192,0,0,0,31,244,0,0,47,192,0,0,0,7,252,0,0,47,192,0,0,0,2,248,0,0,47,192,0,0,0,0,160,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,255,255,192,0,0,47,192,0,0,255,255,192,255,255,255,255,255,244,255,255,192,255,255,255,255,255,244,85,111,192,255,255,255,255,255,244,0,31,192,170,170,191,234,170,164,0,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,192,96,0,47,192,0,0,0,31,194,240,0,47,192,0,0,0,31,223,244,0,47,192,0,0,0,31,255,240,0,47,192,0,0,0,47,255,128,0,47,192,0,0,0,63,253,0,0,47,192,0,0,0,255,240,0,0,47,192,0,0,0,255,128,0,0,47,192,0,0,0,125,0,0,0,47,192,0,0,0,52,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,
  // 0x8bae  议
  174,139,35,36,68,38,2,251,0,192,0,0,2,240,0,0,0,7,240,0,0,7,244,0,16,0,7,252,0,173,3,252,0,63,128,2,254,0,254,1,253,0,127,64,0,255,64,190,0,255,0,191,0,0,63,192,127,0,191,0,191,0,0,31,128,63,0,63,128,255,0,0,9,0,63,64,47,192,254,0,0,0,0,63,128,29,1,253,0,0,0,0,47,192,0,2,252,0,0,0,0,31,192,0,3,252,0,255,255,0,15,208,0,3,248,0,255,255,0,11,240,0,7,240,0,255,255,0,7,240,0,15,240,0,85,191,0,3,248,0,15,224,0,0,63,0,2,252,0,47,208,0,0,63,0,1,253,0,63,192,0,0,63,0,0,255,0,127,64,0,0,63,0,0,191,64,255,0,0,0,63,0,0,63,193,254,0,0,0,63,0,0,47,227,252,0,0,0,63,0,0,15,251,248,0,0,0,63,0,0,7,255,240,0,0,0,63,0,0,3,255,208,0,0,0,63,1,128,1,255,192,0,0,0,63,11,192,2,255,208,0,0,0,63,127,208,11,255,244,0,0,0,63,255,192,47,255,253,0,0,0,127,254,0,255,211,255,128,0,0,191,244,7,255,64,255,244,0,0,255,208,47,253,0,63,255,64,3,255,2,255,240,0,11,255,244,0,248,15,255,128,0,1,255,244,0,96,3,253,0,0,0,47,224,0,0,1,208,0,0,0,2,192,0,0,0,0,0,0,0,0,0,
  // 0x8bbe  设
  190,139,35,36,68,38,1,251,0,52,0,0,5,85,85,64,0,0,253,0,0,47,255,255,240,0,0,255,128,0,47,255,255,240,0,0,63,224,0,47,255,255,240,0,0,15,248,0,47,128,7,240,0,0,3,253,0,47,128,7,240,0,0,1,252,0,63,64,7,240,0,0,0,112,0,63,64,7,240,0,0,0,0,0,127,0,7,240,0,0,0,0,0,255,0,7,240,0,0,0,0,2,253,0,7,240,0,127,255,192,15,252,0,3,255,252,127,255,192,127,240,0,3,255,252,127,255,192,191,192,0,0,191,252,21,111,192,46,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,31,255,255,255,255,64,0,31,192,31,255,255,255,255,192,0,31,192,31,255,255,255,255,128,0,31,192,7,249,85,85,191,64,0,31,192,2,252,0,0,255,0,0,31,192,0,254,0,2,253,0,0,31,192,0,191,0,3,252,0,0,31,192,0,63,192,15,240,0,0,31,192,192,31,240,63,208,0,0,31,195,208,11,252,255,128,0,0,31,223,240,2,255,255,0,0,0,31,255,208,0,255,252,0,0,0,31,255,64,1,255,253,0,0,0,63,252,0,31,255,255,192,0,0,191,224,1,255,254,255,253,0,0,255,128,191,255,208,47,255,248,0,125,0,255,254,0,3,255,252,0,36,0,127,208,0,0,111,240,0,0,0,36,0,0,0,1,160,0,0,0,0,0,0,0,0,0,
  // 0x8bd5  试
  213,139,35,36,68,38,2,252,0,0,0,0,0,2,168,0,0,0,208,0,0,0,3,252,184,0,3,248,0,0,0,2,252,254,0,3,254,0,0,0,2,252,127,64,0,255,128,0,0,2,252,47,192,0,63,224,0,0,2,252,15,224,0,15,240,0,0,2,252,7,192,0,3,208,0,0,2,252,1,0,0,1,66,255,255,255,255,255,244,0,0,2,255,255,255,255,255,244,0,0,2,255,255,255,255,255,244,0,0,1,85,85,86,253,85,80,255,255,64,0,0,1,252,0,0,255,255,64,0,0,1,252,0,0,255,255,64,0,0,1,252,0,0,85,127,64,0,0,0,253,0,0,0,63,64,21,85,80,253,0,0,0,63,64,191,255,244,253,0,0,0,63,64,191,255,244,254,0,0,0,63,64,191,255,244,254,0,0,0,63,64,0,253,0,254,0,0,0,63,64,0,253,0,191,0,0,0,63,64,0,253,0,191,0,0,0,63,64,0,253,0,127,0,0,0,63,64,0,253,0,127,64,0,0,63,64,0,253,0,63,64,0,0,63,65,0,253,0,63,128,208,0,63,79,128,253,45,63,192,248,0,63,255,192,255,254,47,193,248,0,63,255,155,255,255,31,210,244,0,191,253,255,255,248,15,243,240,1,255,224,255,249,0,11,255,240,2,255,64,190,64,0,3,255,224,0,248,0,0,0,0,2,255,192,0,80,0,0,0,0,0,191,128,0,0,0,0,0,0,0,25,0,
  // 0x8bef  误
  239,139,36,36,68,38,1,251,0,96,0,0,0,0,0,0,0,1,248,0,3,255,255,255,255,192,3,255,0,3,255,255,255,255,192,0,255,192,3,255,255,255,255,192,0,63,240,3,240,0,0,31,192,0,15,252,3,240,0,0,31,192,0,3,248,3,240,0,0,31,192,0,1,224,3,240,0,0,31,192,0,0,64,3,244,0,0,31,192,0,0,0,3,255,255,255,255,192,0,0,0,3,255,255,255,255,192,127,255,192,3,255,255,255,255,192,127,255,192,0,0,0,0,0,0,127,255,192,0,0,0,0,0,0,21,111,192,0,0,0,0,0,0,0,15,192,15,255,255,255,255,240,0,15,192,15,255,255,255,255,240,0,15,192,15,255,255,255,255,240,0,15,192,0,0,15,208,0,0,0,15,192,0,0,15,208,0,0,0,15,192,0,0,15,208,0,0,0,15,192,0,0,15,208,0,0,0,15,192,63,255,255,255,255,253,0,15,192,63,255,255,255,255,253,0,15,192,63,255,255,255,255,253,0,15,192,64,0,63,248,0,0,0,15,195,192,0,255,253,0,0,0,15,239,208,1,254,255,0,0,0,31,255,208,7,252,127,192,0,0,47,255,0,31,244,47,244,0,0,127,248,1,255,224,11,254,0,0,127,208,31,255,128,2,255,244,0,47,0,191,253,0,0,191,253,0,8,0,63,224,0,0,15,244,0,0,0,29,0,0,0,0,176,0,0,0,0,0,0,0,0,0,
  // 0x8bf7  请
  247,139,36,37,77,38,1,251,0,0,0,0,0,15,208,0,0,0,160,0,0,0,15,208,0,0,2,252,0,0,0,15,208,0,0,2,255,0,31,255,255,255,255,240,0,191,192,31,255,255,255,255,240,0,47,240,26,170,175,250,170,160,0,11,248,0,0,15,208,0,0,0,2,240,5,85,95,229,85,64,0,0,128,11,255,255,255,255,192,0,0,0,11,255,255,255,255,192,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,127,255,192,106,170,175,250,170,168,127,255,192,191,255,255,255,255,253,127,255,192,191,255,255,255,255,253,21,95,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,3,255,255,255,255,128,0,15,192,3,255,255,255,255,128,0,15,192,3,254,170,170,191,128,0,15,192,3,240,0,0,63,128,0,15,192,3,240,0,0,63,128,0,15,192,3,249,85,85,127,128,0,15,192,3,255,255,255,255,128,0,15,192,3,255,255,255,255,128,0,15,192,67,240,0,0,63,128,0,15,194,195,240,0,0,63,128,0,15,223,227,249,85,85,127,128,0,15,255,227,255,255,255,255,128,0,15,255,131,255,255,255,255,128,0,47,253,3,240,0,0,63,128,0,63,244,3,240,0,0,63,128,0,255,192,3,240,0,0,63,128,0,127,0,3,240,0,127,255,64,0,40,0,3,240,0,63,255,0,0,0,0,3,240,0,47,248,0,0,0,0,0,0,0,0,0,0,
  // 0x8bfb  读
  251,139,35,37,77,38,1,251,0,0,0,0,0,15,208,0,0,0,240,0,0,0,15,208,0,0,3,253,0,0,0,15,208,0,0,1,255,128,15,255,255,255,255,192,0,127,224,15,255,255,255,255,192,0,31,248,15,255,255,255,255,192,0,11,248,0,0,15,208,0,0,0,2,240,0,0,15,208,0,0,0,0,208,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,63,255,255,255,255,244,0,0,0,63,255,255,255,255,244,127,255,192,63,255,255,255,255,240,127,255,192,0,0,0,0,7,224,127,255,192,0,96,3,240,11,208,21,111,192,0,254,3,240,15,192,0,15,192,0,127,211,240,31,128,0,15,192,13,11,251,240,11,64,0,15,192,63,129,247,240,0,0,0,15,192,31,244,3,240,0,0,0,15,192,2,253,7,240,0,0,0,15,192,0,191,7,240,0,0,0,15,192,0,28,11,240,0,0,0,15,192,255,255,255,255,255,252,0,15,192,255,255,255,255,255,252,0,15,192,255,255,255,255,255,252,0,15,199,64,0,63,128,0,0,0,15,239,128,0,255,10,0,0,0,15,255,192,3,254,47,192,0,0,31,255,0,15,252,47,244,0,0,31,252,0,127,240,7,254,0,0,63,224,2,255,192,0,255,192,0,191,128,47,255,0,0,47,240,0,190,1,255,248,0,0,7,252,0,56,0,191,192,0,0,1,248,0,0,0,57,0,0,0,0,96,0,0,0,0,0,0,0,0,0,
  // 0x8c03  调
  3,140,34,36,68,38,1,251,0,96,0,0,0,0,0,0,0,2,248,0,47,255,255,255,255,240,3,255,0,47,255,255,255,255,240,0,255,192,47,255,255,255,255,240,0,63,240,47,128,0,0,3,240,0,15,248,47,128,11,192,3,240,0,3,244,47,128,11,192,3,240,0,0,208,47,128,11,192,3,240,0,0,0,47,135,255,255,195,240,0,0,0,47,135,255,255,195,240,0,0,0,47,130,175,234,131,240,21,85,64,47,128,11,192,3,240,127,255,192,47,128,11,192,3,240,127,255,192,47,128,11,192,3,240,127,255,192,47,143,255,255,227,240,0,31,192,47,143,255,255,227,240,0,31,192,47,138,170,170,147,240,0,31,192,47,64,0,0,3,240,0,31,192,47,64,0,0,3,240,0,31,192,47,70,170,170,67,240,0,31,192,47,75,255,255,131,240,0,31,192,63,75,255,255,131,240,0,31,192,63,11,192,15,131,240,0,31,192,63,11,192,15,131,240,0,31,192,63,11,192,15,131,240,0,31,203,127,11,192,15,131,240,0,31,255,254,11,255,255,131,240,0,31,255,253,11,255,255,131,240,0,47,254,252,11,234,170,67,240,0,63,249,252,11,192,0,3,240,0,127,211,248,5,64,0,3,240,0,255,71,240,0,0,0,7,240,0,253,15,240,0,0,11,255,240,0,52,11,208,0,0,3,255,224,0,0,1,128,0,0,3,255,64,0,0,0,0,0,0,0,0,0,
  // 0x8d25  败
  37,141,35,36,68,38,2,252,0,0,0,0,0,16,0,0,0,0,0,0,0,0,63,64,0,0,47,255,255,253,0,63,64,0,0,47,255,255,253,0,127,0,0,0,47,255,255,253,0,190,0,0,0,47,64,0,253,0,253,0,0,0,47,0,0,189,0,252,0,0,0,47,1,80,189,1,255,255,255,240,47,3,240,189,3,255,255,255,240,47,3,240,189,3,255,255,255,240,47,3,240,189,11,240,0,189,0,47,3,240,189,15,208,0,189,0,47,3,240,189,31,192,0,252,0,47,3,240,189,63,192,0,252,0,47,3,240,189,191,208,0,252,0,47,3,240,189,255,224,1,248,0,47,3,240,189,255,240,2,244,0,47,3,240,189,123,240,3,240,0,47,7,240,189,34,248,3,240,0,47,7,240,189,0,252,7,224,0,47,7,224,189,0,253,11,208,0,47,7,224,189,0,127,15,192,0,47,11,224,189,0,63,95,192,0,47,11,208,189,0,31,255,64,0,47,15,192,189,0,15,255,0,0,26,15,192,84,0,7,254,0,0,0,31,129,0,0,3,252,0,0,0,63,95,64,0,3,255,0,0,0,127,47,192,0,15,255,128,0,0,254,15,224,0,63,255,224,0,3,252,3,244,0,255,143,248,0,11,244,2,252,3,254,3,255,0,63,224,0,254,47,248,0,255,224,255,128,0,126,191,224,0,63,244,126,0,0,36,47,64,0,11,208,36,0,0,0,8,0,0,0,128,
  // 0x8d2a  贪
  42,141,35,37,77,38,2,251,0,0,0,0,116,0,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,191,255,224,0,0,0,0,0,11,255,159,254,0,0,0,0,0,191,253,2,255,228,0,0,0,31,255,226,192,127,255,144,0,6,255,254,11,244,7,255,254,64,191,255,224,3,253,0,127,255,244,255,254,0,0,255,0,2,255,224,63,208,0,0,61,0,0,27,192,20,63,255,255,255,255,253,0,0,0,63,255,255,255,255,255,64,0,0,63,255,255,255,255,253,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,191,64,0,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,0,0,0,0,31,192,0,0,63,0,2,164,0,31,192,0,0,63,0,3,248,0,31,192,0,0,63,0,3,248,0,31,192,0,0,63,0,3,248,0,31,192,0,0,63,0,3,248,0,31,192,0,0,63,0,7,244,0,31,192,0,0,63,0,15,240,0,31,192,0,0,63,0,63,227,224,26,128,0,0,0,1,255,203,255,128,0,0,0,0,31,255,11,255,253,0,0,0,6,255,248,0,111,255,224,0,1,191,255,208,0,1,255,254,0,47,255,253,0,0,0,27,255,128,11,255,128,0,0,0,0,191,0,3,224,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,
  // 0x8d77  起
  119,141,36,37,77,38,1,251,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,2,255,255,255,208,0,0,253,0,2,255,255,255,208,15,255,255,255,194,255,255,255,208,15,255,255,255,192,0,0,15,208,15,255,255,255,192,0,0,15,208,0,0,253,0,0,0,0,15,208,0,0,253,0,0,0,0,15,208,0,0,253,0,0,0,0,15,208,0,0,253,0,0,0,0,15,208,0,0,253,0,0,0,0,15,208,63,255,255,255,240,170,170,175,208,63,255,255,255,241,255,255,255,208,63,255,255,255,241,255,255,255,208,0,0,127,0,1,252,0,15,208,0,0,127,0,1,252,0,0,0,0,0,127,0,1,252,0,0,0,7,240,127,0,1,252,0,0,0,7,240,127,0,1,252,0,0,0,11,240,127,255,225,252,0,0,0,11,224,127,255,225,252,0,0,164,11,224,127,255,225,252,0,0,189,11,240,127,0,1,252,0,0,253,15,240,127,0,1,252,0,0,252,15,248,127,0,0,253,0,1,252,15,252,127,0,0,255,255,255,252,15,255,127,0,0,191,255,255,244,15,255,255,0,0,47,255,255,208,31,239,255,0,0,0,0,0,0,47,143,255,64,0,0,0,0,0,63,67,255,254,165,85,85,85,85,63,64,191,255,255,255,255,255,253,191,0,27,255,255,255,255,255,252,254,0,0,27,255,255,255,255,248,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8d85  超
  133,141,36,36,68,38,1,252,0,1,248,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,15,255,255,255,244,0,1,252,0,15,255,255,255,240,0,1,252,0,15,255,255,255,240,15,255,255,255,128,11,224,3,240,15,255,255,255,128,15,208,7,240,15,255,255,255,128,15,192,7,240,0,1,252,0,0,47,192,7,240,0,1,252,0,0,63,128,11,240,0,1,252,0,0,191,0,15,224,0,1,252,0,2,254,0,15,224,63,255,255,255,219,248,31,255,208,63,255,255,255,255,240,15,255,192,63,255,255,255,255,128,11,254,0,0,0,253,0,5,0,0,0,0,0,0,253,0,3,255,255,255,208,7,208,253,0,3,255,255,255,208,11,224,253,0,3,255,255,255,208,11,224,253,0,3,240,0,15,208,11,224,255,255,195,240,0,15,208,11,224,255,255,195,240,0,15,208,11,208,255,255,195,240,0,15,208,11,224,253,0,3,240,0,15,208,15,240,253,0,3,240,0,15,208,15,240,253,0,3,240,0,15,208,15,248,253,0,3,255,255,255,208,15,253,253,0,3,255,255,255,208,31,255,253,0,3,255,255,255,208,31,255,253,0,0,0,0,0,0,47,143,254,0,0,0,0,0,0,63,71,255,254,165,85,85,85,85,127,0,255,255,255,255,255,255,253,191,0,31,255,255,255,255,255,252,189,0,0,107,255,255,255,255,248,8,0,0,0,0,0,0,0,0,
  // 0x8ddd  距
  221,141,36,35,59,38,1,252,0,0,0,0,5,85,85,85,84,11,255,255,252,31,255,255,255,252,11,255,255,252,31,255,255,255,252,11,255,255,252,31,255,255,255,252,11,208,0,252,31,192,0,0,0,11,208,0,252,31,192,0,0,0,11,208,0,252,31,192,0,0,0,11,208,0,252,31,192,0,0,0,11,208,0,252,31,192,0,0,0,11,224,0,252,31,213,85,85,64,11,255,255,252,31,255,255,255,208,11,255,255,252,31,255,255,255,208,11,255,255,252,31,255,255,255,208,0,1,248,0,31,192,0,15,208,0,1,248,0,31,192,0,15,208,0,1,248,0,31,192,0,15,208,11,193,248,0,31,192,0,15,208,11,193,248,0,31,192,0,15,208,11,193,255,255,31,192,0,15,208,11,193,255,255,31,192,0,15,208,11,193,255,255,31,213,85,95,208,11,193,248,0,31,255,255,255,208,11,193,248,0,31,255,255,255,208,11,193,248,0,31,255,255,255,208,11,193,248,0,31,192,0,0,0,11,193,248,0,31,192,0,0,0,11,193,248,6,31,192,0,0,0,11,193,254,255,31,192,0,0,0,11,219,255,255,95,192,0,0,0,47,255,255,254,31,213,85,85,84,191,255,254,64,31,255,255,255,253,127,254,64,0,31,255,255,255,253,58,64,0,0,31,255,255,255,253,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,
  // 0x8f6c  转
  108,143,36,37,77,38,1,251,0,6,64,0,0,0,164,0,0,0,11,240,0,0,0,253,0,0,0,15,224,0,0,1,253,0,0,0,15,208,0,0,2,252,0,0,0,31,208,0,0,3,252,0,0,127,255,255,252,127,255,255,255,240,127,255,255,252,127,255,255,255,240,127,255,255,252,127,255,255,255,240,0,63,0,0,0,15,224,0,0,0,190,0,0,0,15,208,0,0,0,252,0,0,0,31,192,0,0,0,252,253,0,85,111,213,85,84,1,248,253,3,255,255,255,255,253,3,240,253,3,255,255,255,255,253,3,240,253,3,255,255,255,255,253,11,208,253,0,0,255,0,0,0,15,208,254,0,0,254,0,0,0,47,255,255,252,1,253,0,0,0,47,255,255,252,2,252,0,0,0,15,255,255,252,3,255,255,255,208,4,0,253,0,7,255,255,255,240,0,0,253,0,11,255,255,255,192,0,0,253,0,5,85,85,255,64,0,0,253,6,0,0,1,255,0,0,0,255,255,0,0,3,252,0,1,111,255,255,0,0,11,244,0,127,255,255,255,0,248,31,224,0,63,255,255,80,3,255,127,192,0,63,249,253,0,1,255,255,0,0,20,0,253,0,0,47,254,0,0,0,0,253,0,0,7,255,128,0,0,0,253,0,0,0,255,224,0,0,0,253,0,0,0,47,252,0,0,0,253,0,0,0,7,254,0,0,0,253,0,0,0,1,248,0,0,0,253,0,0,0,0,48,0,0,0,0,0,0,0,0,0,0,
  // 0x8f6f  软
  111,143,35,36,68,38,1,252,0,0,144,0,0,57,0,0,0,0,1,252,0,0,63,64,0,0,0,2,252,0,0,127,0,0,0,0,3,248,0,0,127,0,0,0,21,87,249,85,64,191,0,0,0,63,255,255,255,192,254,0,0,0,63,255,255,255,192,255,255,255,248,63,255,255,255,193,255,255,255,252,0,31,192,0,2,255,255,255,252,0,47,128,0,3,248,0,2,252,0,63,64,0,7,244,0,2,248,0,127,47,128,11,240,0,3,244,0,190,47,128,15,224,0,3,240,0,253,47,128,47,208,252,7,240,2,252,47,128,63,192,252,7,224,3,244,47,128,191,64,252,11,208,11,244,47,128,31,0,252,11,192,31,255,255,255,193,1,252,0,64,15,255,255,255,192,1,252,0,0,15,255,255,255,192,1,253,0,0,0,0,47,128,0,2,254,0,0,0,0,47,128,0,2,255,0,0,0,0,47,128,0,3,255,0,0,0,0,47,128,0,7,255,64,0,0,0,47,239,192,11,255,192,0,1,107,255,255,208,15,255,208,0,127,255,255,255,208,31,219,240,0,63,255,255,229,0,63,199,244,0,63,254,191,128,0,191,67,252,0,37,0,47,128,1,255,1,254,0,0,0,47,128,3,253,0,255,128,0,0,47,128,15,248,0,63,224,0,0,47,128,127,224,0,31,252,0,0,47,128,255,192,0,11,252,0,0,47,128,126,0,0,1,244,0,0,31,64,24,0,0,0,96,
  // 0x8f74  轴
  116,143,35,37,77,38,1,251,0,10,64,0,0,1,252,0,0,0,15,224,0,0,1,252,0,0,0,15,208,0,0,1,252,0,0,0,15,192,0,0,1,252,0,0,21,95,213,80,0,1,252,0,0,63,255,255,252,0,1,252,0,0,63,255,255,252,0,1,252,0,0,63,255,255,252,0,1,252,0,0,0,127,0,0,0,2,253,0,0,0,190,0,0,191,255,255,255,244,0,253,0,0,191,255,255,255,244,0,252,190,0,191,255,255,255,244,1,252,190,0,190,0,252,3,244,2,244,190,0,190,0,252,3,244,3,240,190,0,190,0,252,3,244,7,224,190,0,190,0,252,3,244,15,208,190,0,190,0,252,3,244,47,255,255,252,190,0,252,3,244,31,255,255,252,190,0,252,3,244,15,255,255,252,191,255,255,255,244,4,0,190,0,191,255,255,255,244,0,0,190,0,191,255,255,255,244,0,0,190,0,190,1,252,3,244,0,0,190,20,190,0,252,3,244,0,0,191,252,190,0,252,3,244,0,107,255,252,190,0,252,3,244,127,255,255,252,190,0,252,3,244,63,255,255,144,190,0,252,3,244,63,254,254,0,190,0,252,3,244,41,0,190,0,190,0,252,3,244,0,0,190,0,190,1,252,3,244,0,0,190,0,191,255,255,255,244,0,0,190,0,191,255,255,255,244,0,0,190,0,191,255,255,255,244,0,0,190,0,190,0,0,3,244,0,0,125,0,190,0,0,3,244,0,0,0,0,0,0,0,0,0,
  // 0x8f7d  载
  125,143,35,36,68,38,2,252,0,0,63,0,0,42,0,0,0,0,0,63,0,0,63,66,192,0,0,0,63,0,0,63,79,244,0,15,255,255,255,248,63,67,252,0,15,255,255,255,248,63,64,255,0,15,255,255,255,248,63,64,127,128,0,0,63,0,0,63,64,47,0,0,0,63,0,0,63,64,8,0,0,0,63,0,0,63,64,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,0,3,228,0,0,63,128,0,0,0,11,240,0,0,47,128,16,0,0,15,224,0,0,47,192,63,64,127,255,255,255,255,47,192,63,0,127,255,255,255,255,31,192,191,0,127,255,255,255,254,31,192,253,0,0,254,0,0,0,31,192,252,0,1,252,11,224,0,15,210,252,0,3,248,11,224,0,15,211,244,0,11,240,11,224,0,15,231,240,0,31,255,255,255,253,11,239,224,0,15,255,255,255,252,11,255,192,0,15,255,255,255,252,7,255,128,0,4,0,11,224,0,3,255,0,0,0,0,11,224,0,3,254,0,0,0,0,11,224,21,3,252,1,208,21,171,255,255,255,11,252,1,244,127,255,255,255,255,31,254,1,244,127,255,255,254,80,127,255,2,240,62,149,11,224,1,255,127,211,240,0,0,11,224,11,253,47,255,240,0,0,11,224,47,244,11,255,208,0,0,11,224,11,208,2,255,128,0,0,5,80,2,0,0,20,0,
  // 0x8f91  辑
  145,143,36,36,68,38,1,252,0,10,64,0,0,0,0,0,0,0,15,224,0,42,170,170,170,64,0,15,208,0,63,255,255,255,192,0,31,192,0,63,255,255,255,192,21,111,213,80,63,64,0,47,192,63,255,255,248,63,64,0,47,192,63,255,255,248,63,64,0,47,192,63,255,255,248,63,255,255,255,192,0,127,0,0,63,255,255,255,192,0,190,0,0,42,170,170,170,128,0,252,84,0,0,0,0,0,0,0,252,253,0,0,0,0,0,0,2,248,253,3,255,255,255,255,252,3,244,253,3,255,255,255,255,252,3,240,253,3,255,255,255,255,252,11,224,253,0,47,128,0,47,128,15,208,253,0,47,128,0,47,128,47,255,255,244,47,234,170,191,128,47,255,255,244,47,255,255,255,128,15,255,255,244,47,255,255,255,128,4,0,253,0,47,128,0,47,128,0,0,253,0,47,128,0,47,128,0,0,253,0,47,128,0,47,128,0,0,253,0,47,255,255,255,128,0,1,255,252,47,255,255,255,128,26,255,255,252,47,234,170,191,128,127,255,255,252,47,128,0,47,128,63,255,253,0,47,128,0,47,128,62,144,253,0,63,150,171,255,253,0,0,253,11,255,255,255,255,253,0,0,253,11,255,255,255,255,253,0,0,253,7,255,234,80,47,128,0,0,253,0,0,0,0,47,128,0,0,253,0,0,0,0,47,128,0,0,253,0,0,0,0,47,128,0,0,169,0,0,0,0,47,128,
  // 0x8f93  输
  147,143,36,36,68,38,1,252,0,41,0,0,0,2,208,0,0,0,63,0,0,0,7,244,0,0,0,63,0,0,0,15,240,0,0,0,127,0,0,0,63,252,0,0,0,191,0,0,0,255,255,0,0,63,255,255,192,7,252,63,192,0,63,255,255,192,47,240,15,244,0,63,255,255,192,255,192,2,254,0,0,252,0,11,254,0,0,127,224,1,248,0,127,255,255,255,255,254,2,244,0,63,255,255,255,255,252,3,242,240,31,127,255,255,253,180,3,243,240,0,0,0,0,0,0,7,211,240,0,0,0,0,0,80,11,195,240,0,0,0,0,2,240,15,195,240,7,255,255,199,194,240,31,131,244,7,255,255,199,210,240,63,255,255,199,255,255,199,210,240,63,255,255,199,208,15,199,210,240,47,255,255,199,208,15,199,210,240,4,3,240,7,255,255,199,210,240,0,3,240,7,255,255,199,210,240,0,3,240,7,250,175,199,210,240,0,3,245,135,208,15,199,210,240,0,3,255,199,208,15,199,210,240,6,255,255,199,250,175,199,210,240,127,255,255,135,255,255,199,210,240,63,255,240,7,255,255,199,210,240,63,147,240,7,208,15,199,210,240,0,3,240,7,208,15,199,194,240,0,3,240,7,208,15,192,2,240,0,3,240,7,208,15,192,2,240,0,3,240,7,208,15,192,2,240,0,3,240,7,210,255,130,255,240,0,3,240,7,209,255,65,255,224,0,2,240,7,208,233,0,250,64,
  // 0x8fb9  边
  185,143,36,37,77,38,1,251,0,0,0,0,0,84,0,0,0,1,224,0,0,1,253,0,0,0,11,248,0,0,1,253,0,0,0,3,254,0,0,1,253,0,0,0,0,255,128,0,1,253,0,0,0,0,127,208,0,1,252,0,0,0,0,31,240,0,2,252,0,0,0,0,11,240,255,255,255,255,255,240,0,3,192,255,255,255,255,255,240,0,0,0,255,255,255,255,255,240,0,0,0,85,87,253,85,95,240,0,0,0,0,3,248,0,11,240,0,0,0,0,3,248,0,11,240,127,255,192,0,7,244,0,15,240,127,255,192,0,7,244,0,15,224,127,255,192,0,11,240,0,15,224,21,127,192,0,15,240,0,15,224,0,47,192,0,31,224,0,15,224,0,47,192,0,47,192,0,15,224,0,47,192,0,63,192,0,15,208,0,47,192,0,127,128,0,31,208,0,47,192,0,255,0,0,31,208,0,47,192,2,254,0,0,47,192,0,47,192,7,252,0,0,47,192,0,47,192,15,244,0,0,63,192,0,47,192,127,240,0,0,127,128,0,47,193,255,192,11,255,255,64,0,47,194,255,0,3,255,255,0,0,127,192,184,0,3,255,252,0,3,255,244,16,0,1,85,64,0,15,255,255,64,0,0,0,0,0,63,245,255,249,64,0,0,21,106,255,192,47,255,255,255,255,255,253,127,64,3,255,255,255,255,255,252,46,0,0,47,255,255,255,255,252,8,0,0,0,21,85,85,85,0,0,0,0,0,0,0,0,0,0,
  // 0x8fc1  迁
  193,143,36,36,68,38,1,252,0,0,0,0,0,0,0,4,0,0,244,0,0,0,0,6,253,0,3,254,0,0,0,22,255,255,64,1,255,192,1,175,255,255,255,64,0,63,244,255,255,255,255,144,0,0,11,252,191,255,255,144,0,0,0,2,240,127,165,63,64,0,0,0,0,128,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,7,192,0,0,0,63,64,0,0,31,248,0,0,0,63,64,0,0,15,255,0,0,0,63,64,0,0,1,255,208,0,0,63,64,0,0,0,63,240,0,0,63,128,0,0,0,11,195,255,255,255,255,255,252,0,2,3,255,255,255,255,255,252,0,0,3,255,255,255,255,255,252,0,0,0,0,0,63,64,0,0,63,255,208,0,0,63,64,0,0,63,255,208,0,0,63,64,0,0,63,255,208,0,0,63,64,0,0,21,95,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,63,240,0,0,63,64,0,0,1,255,253,0,0,63,64,0,0,11,255,255,144,0,0,0,0,0,63,248,127,254,149,85,85,85,89,127,224,15,255,255,255,255,255,252,63,64,1,255,255,255,255,255,252,28,0,0,10,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x8fd0  运
  208,143,36,36,68,38,1,252,0,64,0,0,0,0,0,0,0,1,248,0,0,0,0,0,0,0,3,255,64,31,255,255,255,255,192,1,255,224,31,255,255,255,255,192,0,47,248,31,255,255,255,255,192,0,7,244,5,85,85,85,85,64,0,1,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,64,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,47,253,0,0,0,0,0,0,0,7,255,130,255,255,255,255,255,253,0,191,226,255,255,255,255,255,253,0,47,194,255,255,255,255,255,253,0,7,0,85,95,249,85,85,84,0,0,0,0,15,240,0,0,0,0,0,0,0,31,224,1,64,0,0,0,0,0,47,192,15,208,0,63,255,192,0,63,192,15,240,0,63,255,192,0,127,64,3,248,0,63,255,192,0,191,0,1,253,0,21,111,192,0,254,0,0,255,0,0,31,192,1,252,0,0,63,128,0,31,192,3,248,5,106,255,208,0,31,192,171,255,255,255,255,240,0,31,193,255,255,255,255,255,244,0,31,192,255,255,255,234,87,252,0,31,192,254,165,0,0,2,252,0,127,240,0,0,0,0,0,208,1,255,248,0,0,0,0,0,0,11,255,255,64,0,0,0,0,0,127,244,191,254,85,0,1,85,85,127,208,47,255,255,255,255,255,252,63,64,2,255,255,255,255,255,252,28,0,0,27,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x8fd1  近
  209,143,36,36,68,38,1,252,0,0,0,0,0,0,0,40,0,2,64,0,0,0,0,27,254,0,15,224,0,0,0,111,255,255,192,31,252,0,7,255,255,255,249,0,3,255,0,7,255,255,249,0,0,0,255,192,7,255,164,0,0,0,0,63,240,7,240,0,0,0,0,0,15,224,7,240,0,0,0,0,0,3,64,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,255,255,255,255,252,0,0,0,7,255,255,255,255,252,0,0,0,7,255,255,255,255,252,0,0,0,11,245,85,127,149,84,63,255,208,11,240,0,63,64,0,63,255,208,15,224,0,63,64,0,63,255,208,15,224,0,63,64,0,21,95,208,15,208,0,63,64,0,0,15,208,31,192,0,63,64,0,0,15,208,47,192,0,63,64,0,0,15,208,63,128,0,63,64,0,0,15,208,127,64,0,63,64,0,0,15,208,255,0,0,63,64,0,0,15,209,254,0,0,63,64,0,0,15,211,252,0,0,63,64,0,0,15,219,244,0,0,63,64,0,0,31,210,240,0,0,63,64,0,0,127,240,128,0,0,63,64,0,2,255,253,0,0,0,63,64,0,15,255,255,144,0,0,0,0,0,127,248,127,254,149,85,85,85,169,127,224,31,255,255,255,255,255,252,63,64,2,255,255,255,255,255,252,28,0,0,26,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x8fd4  返
  212,143,36,35,59,38,1,252,2,64,0,0,0,0,0,0,0,15,208,0,31,255,255,255,255,240,31,248,0,31,255,255,255,255,240,7,254,0,31,255,255,255,255,240,1,255,128,31,213,85,85,85,80,0,127,208,31,192,0,0,0,0,0,31,224,31,192,0,0,0,0,0,11,64,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,47,255,255,255,255,128,0,0,0,47,255,255,255,255,128,0,0,0,47,255,255,255,255,64,0,0,0,47,239,192,0,191,0,0,0,0,47,207,208,0,254,0,63,255,192,47,139,240,1,253,0,63,255,192,63,135,244,3,252,0,63,255,192,63,131,252,11,244,0,21,111,192,63,65,254,31,240,0,0,47,192,127,0,191,127,208,0,0,47,192,191,0,63,255,128,0,0,47,192,255,0,31,255,0,0,0,47,192,253,0,15,253,0,0,0,47,193,252,0,63,255,64,0,0,47,195,252,1,255,255,240,0,0,47,199,244,27,255,127,254,0,0,47,207,241,255,252,11,255,228,0,47,203,210,255,224,1,255,252,0,127,241,192,255,0,0,47,244,2,255,252,0,52,0,0,1,224,15,255,255,128,0,0,0,0,0,127,244,191,254,149,85,85,85,105,127,208,47,255,255,255,255,255,252,63,64,2,255,255,255,255,255,252,28,0,0,27,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x8fd8  还
  216,143,36,37,77,38,1,251,0,64,0,0,0,0,0,0,0,2,240,0,0,0,0,0,0,0,11,252,0,85,85,85,85,85,80,3,255,1,255,255,255,255,255,240,0,255,193,255,255,255,255,255,240,0,63,225,255,255,255,255,255,240,0,15,244,0,0,15,240,0,0,0,7,224,0,0,47,208,0,0,0,2,64,0,0,127,192,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,15,255,5,0,0,127,255,192,0,63,255,31,64,0,127,255,192,0,191,255,127,208,0,127,255,192,2,255,191,31,244,0,21,127,192,11,253,127,7,253,0,0,47,192,47,244,127,2,255,64,0,47,192,255,224,127,0,191,208,0,47,199,255,128,127,0,47,240,0,47,207,253,0,127,0,15,252,0,47,199,244,0,127,0,3,240,0,47,193,192,0,127,0,0,192,0,47,192,0,0,127,0,0,0,0,47,192,0,0,127,0,0,0,0,47,192,0,0,127,0,0,0,0,47,192,0,0,127,0,0,0,0,47,192,0,0,127,0,0,0,0,191,208,0,0,127,0,0,0,3,255,248,0,0,127,0,0,0,15,255,255,64,0,0,0,0,0,63,245,255,249,64,0,0,21,170,255,192,47,255,255,255,255,255,253,127,64,3,255,255,255,255,255,252,46,0,0,47,255,255,255,255,252,8,0,0,0,21,85,85,85,0,0,0,0,0,0,0,0,0,0,
  // 0x8fdb  进
  219,143,36,35,59,38,1,252,1,192,0,0,63,128,15,208,0,11,240,0,0,63,128,15,208,0,11,252,0,0,63,128,15,208,0,2,255,0,0,63,128,15,208,0,0,191,192,0,63,128,15,208,0,0,47,240,0,63,128,15,208,0,0,15,240,255,255,255,255,255,240,0,3,128,255,255,255,255,255,240,0,0,0,255,255,255,255,255,240,0,0,0,85,127,149,95,229,80,0,0,0,0,63,128,15,208,0,0,0,0,0,63,128,15,208,0,0,0,0,0,63,128,15,208,0,63,255,208,0,63,128,15,208,0,63,255,208,0,63,64,15,208,0,63,255,208,85,127,149,95,229,84,21,95,209,255,255,255,255,255,252,0,15,209,255,255,255,255,255,252,0,15,209,255,255,255,255,255,252,0,15,208,0,191,0,15,208,0,0,15,208,0,254,0,15,208,0,0,15,208,1,253,0,15,208,0,0,15,208,2,252,0,15,208,0,0,15,208,7,248,0,15,208,0,0,15,208,15,244,0,15,208,0,0,15,208,63,224,0,15,208,0,0,15,208,127,192,0,15,208,0,0,127,224,31,64,0,15,208,0,2,255,253,9,0,0,10,144,0,11,255,255,208,0,0,0,0,0,47,240,63,255,149,85,85,106,253,127,192,11,255,255,255,255,255,252,47,64,0,191,255,255,255,255,252,14,0,0,6,191,255,255,255,164,0,0,0,0,0,0,0,0,0,
  // 0x8fde  连
  222,143,36,37,77,38,1,251,0,64,0,0,10,64,0,0,0,2,224,0,0,15,240,0,0,0,11,248,0,0,15,240,0,0,0,3,253,0,0,47,208,0,0,0,0,255,66,255,255,255,255,255,240,0,127,194,255,255,255,255,255,240,0,31,226,255,255,255,255,255,240,0,15,224,0,254,0,0,0,0,0,3,64,2,252,0,0,0,0,0,0,0,3,252,11,240,0,0,0,0,0,7,244,11,240,0,0,0,0,0,15,240,11,240,0,0,0,0,0,47,192,11,240,0,0,63,255,192,191,255,255,255,255,192,63,255,192,127,255,255,255,255,192,63,255,192,63,255,255,255,255,192,21,111,192,37,85,91,245,85,64,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,195,255,255,255,255,255,248,0,47,195,255,255,255,255,255,248,0,47,195,255,255,255,255,255,248,0,47,193,85,85,91,245,85,80,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,191,208,0,0,11,240,0,0,3,255,248,0,0,11,240,0,0,15,255,255,64,0,11,240,0,0,63,244,255,249,64,0,0,21,170,191,192,47,255,255,255,255,255,253,127,64,3,255,255,255,255,255,252,46,0,0,47,255,255,255,255,252,8,0,0,0,21,85,85,85,0,0,0,0,0,0,0,0,0,0,
  // 0x8ff7  迷
  247,143,36,36,68,38,1,252,0,0,0,0,0,21,0,0,0,2,64,0,0,0,63,64,0,0,15,224,0,29,0,63,64,15,128,31,252,0,191,0,63,64,31,224,7,255,0,63,64,63,64,63,192,0,255,192,47,192,63,64,63,64,0,63,240,15,208,63,64,191,0,0,15,224,15,240,63,64,253,0,0,3,64,7,240,63,66,252,0,0,0,0,3,224,63,66,240,0,0,0,0,1,0,63,64,16,0,0,0,0,0,0,63,64,0,0,0,0,3,255,255,255,255,255,248,0,0,3,255,255,255,255,255,248,0,0,3,255,255,255,255,255,248,63,255,209,85,87,255,249,85,80,63,255,208,0,11,255,252,0,0,63,255,208,0,31,255,254,0,0,21,95,208,0,63,255,191,64,0,0,15,208,0,255,127,111,192,0,0,15,208,2,253,63,79,240,0,0,15,208,7,248,63,71,252,0,0,15,208,31,240,63,66,255,0,0,15,208,191,208,63,64,255,208,0,15,211,255,64,63,64,63,248,0,15,219,253,0,63,64,15,252,0,15,210,244,0,63,64,3,240,0,31,208,208,0,63,64,0,128,0,127,240,0,0,63,64,0,0,2,255,253,0,0,63,64,0,0,15,255,255,144,0,0,0,0,0,127,248,127,254,149,85,85,85,169,127,224,31,255,255,255,255,255,252,63,64,2,255,255,255,255,255,252,28,0,0,26,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x9000  退
  0,144,36,34,50,38,1,252,3,208,0,15,255,255,255,254,0,15,248,0,15,255,255,255,254,0,7,255,0,15,255,255,255,254,0,0,255,192,15,224,0,0,190,0,0,47,240,15,224,0,0,190,0,0,11,240,15,250,170,170,254,0,0,3,128,15,255,255,255,254,0,0,0,0,15,255,255,255,254,0,0,0,0,15,224,0,0,190,0,0,0,0,15,224,0,0,190,0,0,0,0,15,224,0,0,190,0,0,0,0,15,255,255,255,254,0,0,0,0,15,255,255,255,254,0,63,255,208,15,255,255,255,255,0,63,255,208,15,224,31,192,3,192,63,255,208,15,224,15,208,31,244,21,95,208,15,224,11,240,191,224,0,15,208,15,224,3,247,255,64,0,15,208,15,224,3,255,248,0,0,15,208,15,224,0,255,208,0,0,15,208,15,224,0,191,128,0,0,15,208,15,224,6,127,224,0,0,15,208,15,230,255,95,252,0,0,15,208,31,255,255,135,255,128,0,15,209,255,255,254,65,255,248,0,31,208,255,255,144,0,127,248,0,127,240,255,144,0,0,11,240,2,255,253,80,0,0,0,0,128,15,255,255,144,0,0,0,0,0,127,248,127,254,149,85,85,85,169,127,224,31,255,255,255,255,255,252,63,64,2,255,255,255,255,255,252,28,0,0,26,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x9009  选
  9,144,35,36,68,38,2,252,0,0,0,0,0,127,0,0,0,5,0,0,6,64,127,0,0,0,47,64,0,15,224,127,0,0,0,127,208,0,15,208,127,0,0,0,31,248,0,47,192,127,0,0,0,7,253,0,63,255,255,255,255,64,1,255,64,191,255,255,255,255,64,0,191,128,255,255,255,255,255,64,0,61,3,253,0,127,0,0,0,0,0,7,248,0,127,0,0,0,0,0,7,240,0,127,0,0,0,0,0,0,224,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,15,255,255,255,255,255,240,255,255,15,255,255,255,255,255,240,255,255,15,255,255,255,255,255,240,255,255,0,0,127,1,252,0,0,21,191,0,0,191,1,252,0,0,0,127,0,0,255,1,252,0,0,0,127,0,0,254,1,252,0,0,0,127,0,2,253,1,252,0,0,0,127,0,3,252,1,252,2,128,0,127,0,11,244,1,252,2,244,0,127,0,47,240,1,252,3,244,0,127,1,255,192,1,252,3,240,0,127,31,255,64,1,255,255,240,0,127,15,252,0,0,255,255,224,0,127,199,224,0,0,127,255,192,1,255,245,0,0,0,1,84,0,15,255,254,0,0,0,0,0,0,63,248,191,249,0,0,0,21,164,255,208,31,255,255,255,255,255,240,191,64,2,255,255,255,255,255,240,61,0,0,27,255,255,255,255,224,20,0,0,0,1,85,64,0,0,
  // 0x901f  速
  31,144,36,36,68,38,1,252,0,0,0,0,0,63,64,0,0,2,64,0,0,0,63,64,0,0,15,224,0,0,0,63,64,0,0,31,248,0,0,0,63,64,0,0,7,255,3,255,255,255,255,255,248,1,255,195,255,255,255,255,255,248,0,63,243,255,255,255,255,255,248,0,15,240,0,0,63,64,0,0,0,7,128,0,0,63,64,0,0,0,1,0,0,0,63,64,0,0,0,0,0,127,255,255,255,255,192,0,0,0,127,255,255,255,255,192,0,0,0,127,170,255,234,191,192,0,0,0,127,0,63,64,15,192,0,0,0,127,0,63,64,15,192,63,255,208,127,0,63,64,15,192,63,255,208,127,0,63,64,15,192,63,255,208,127,255,255,255,255,192,21,95,208,127,255,255,255,255,192,0,15,208,127,255,255,255,255,192,0,15,208,0,7,255,244,0,0,0,15,208,0,31,255,253,0,0,0,15,208,0,127,191,255,128,0,0,15,208,1,255,63,95,240,0,0,15,208,11,252,63,71,253,0,0,15,208,127,240,63,65,255,192,0,15,211,255,192,63,64,127,248,0,31,211,254,0,63,64,31,240,0,127,240,244,0,63,64,2,208,2,255,253,0,0,63,64,0,0,15,255,255,144,0,21,0,0,0,127,248,127,254,149,85,85,85,169,127,224,31,255,255,255,255,255,252,63,64,2,255,255,255,255,255,252,28,0,0,26,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x90e8  部
  232,144,36,36,68,38,1,252,0,0,42,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,5,85,85,64,0,0,63,0,0,47,255,255,244,31,255,255,255,254,47,255,255,253,31,255,255,255,254,47,255,255,252,31,255,255,255,254,47,192,3,248,0,4,0,5,0,47,192,11,240,0,252,0,15,208,47,192,15,224,0,253,0,15,192,47,192,31,208,0,190,0,31,192,47,192,47,192,0,127,0,63,64,47,192,63,64,0,63,0,63,0,47,192,127,0,0,63,64,126,0,47,192,254,0,0,37,0,25,0,47,193,252,0,127,255,255,255,255,47,194,252,0,127,255,255,255,255,47,194,253,0,127,255,255,255,255,47,192,191,0,0,0,0,0,0,47,192,47,192,0,0,0,0,0,47,192,15,224,0,0,0,0,0,47,192,7,240,3,255,255,255,240,47,192,3,244,3,255,255,255,240,47,192,2,248,3,255,255,255,240,47,192,2,252,3,244,0,7,240,47,192,2,252,3,244,0,7,240,47,192,2,252,3,244,0,7,240,47,192,3,252,3,244,0,7,240,47,193,111,248,3,244,0,7,240,47,195,255,240,3,244,0,7,240,47,195,255,224,3,244,0,7,240,47,194,254,64,3,255,255,255,240,47,192,0,0,3,255,255,255,240,47,192,0,0,3,255,255,255,240,47,192,0,0,3,244,0,7,240,47,192,0,0,3,244,0,3,240,31,192,0,0,
  // 0x914d  配
  77,145,35,34,50,38,2,252,255,255,255,255,199,255,255,255,192,255,255,255,255,199,255,255,255,192,255,255,255,255,199,255,255,255,192,0,47,31,0,1,85,85,95,192,0,47,31,0,0,0,0,15,192,0,47,31,0,0,0,0,15,192,0,47,31,0,0,0,0,15,192,63,255,255,255,64,0,0,15,192,63,255,255,255,64,0,0,15,192,63,255,255,255,64,0,0,15,192,62,14,44,47,64,0,0,15,192,62,14,44,47,64,0,0,15,192,62,14,44,47,67,255,255,255,192,62,14,44,47,67,255,255,255,192,62,14,44,47,67,255,255,255,192,62,29,44,47,67,249,85,95,192,62,60,45,47,67,244,0,15,192,62,60,31,255,67,244,0,15,192,63,244,15,255,67,244,0,0,0,62,160,0,47,67,244,0,0,0,62,0,0,47,67,244,0,0,0,62,0,0,47,67,244,0,0,0,63,170,170,191,67,244,0,0,0,63,255,255,255,67,244,0,0,0,63,255,255,255,67,244,0,2,208,62,0,0,47,67,244,0,2,248,62,0,0,47,67,244,0,2,248,62,0,0,47,67,244,0,3,244,63,255,255,255,67,244,0,3,244,63,255,255,255,67,248,0,11,240,63,255,255,255,67,255,255,255,240,62,0,0,47,66,255,255,255,208,62,0,0,47,64,191,255,255,128,41,0,0,0,0,1,85,80,0,
  // 0x91ca  释
  202,145,36,36,68,38,1,252,0,0,0,80,0,0,0,0,0,0,5,175,248,0,0,0,0,0,47,255,255,252,127,255,255,255,240,63,255,255,248,127,255,255,255,248,47,171,244,0,127,255,255,255,240,0,3,240,0,11,224,0,31,224,6,3,240,61,3,244,0,63,192,47,3,240,126,1,252,0,255,0,15,131,240,252,0,191,3,253,0,11,195,241,248,0,63,223,244,0,7,227,243,240,0,15,255,208,0,3,227,243,224,0,7,255,64,0,1,67,240,0,0,47,255,208,0,0,3,240,0,2,255,255,253,0,63,255,255,252,127,255,7,255,228,63,255,255,255,255,244,0,191,255,63,255,255,254,255,64,0,27,252,0,15,244,0,224,2,252,0,120,0,31,253,0,0,2,252,0,0,0,63,255,64,0,2,252,0,0,0,127,255,208,63,255,255,255,208,0,255,251,244,63,255,255,255,208,2,251,243,253,63,255,255,255,208,3,247,240,252,0,2,252,0,0,15,227,240,116,0,2,252,0,0,47,195,240,0,0,2,252,0,0,127,131,240,0,0,2,252,0,0,127,3,240,2,255,255,255,255,252,61,3,240,2,255,255,255,255,252,24,3,240,2,255,255,255,255,252,0,3,240,0,0,2,252,0,0,0,3,240,0,0,2,252,0,0,0,3,240,0,0,2,252,0,0,0,3,240,0,0,2,252,0,0,0,3,240,0,0,2,252,0,0,0,3,240,0,0,2,252,0,0,
  // 0x91cd  重
  205,145,34,35,59,38,2,253,0,0,0,0,0,0,22,128,0,0,0,0,5,106,255,255,192,0,2,255,255,255,255,255,255,240,0,1,255,255,255,255,255,233,64,0,1,255,170,151,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,254,85,87,253,85,91,240,0,0,254,0,3,248,0,7,240,0,0,254,0,3,248,0,11,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,254,0,3,248,0,7,240,0,0,254,0,3,248,0,7,240,0,0,255,85,87,253,85,91,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,3,255,255,255,255,255,255,253,0,3,255,255,255,255,255,255,254,0,3,255,255,255,255,255,255,254,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x91cf  量
  207,145,34,34,50,38,2,253,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,253,0,3,248,0,7,240,0,0,253,0,3,248,0,7,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,1,85,85,87,253,85,85,84,0,0,0,0,3,248,0,0,0,0,170,170,170,171,254,170,170,170,160,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,
  // 0x9488  针
  136,148,35,36,68,38,1,252,0,8,0,0,0,0,84,0,0,0,47,192,0,0,1,253,0,0,0,63,128,0,0,1,253,0,0,0,127,0,0,0,1,253,0,0,0,255,85,84,0,1,253,0,0,2,255,255,252,0,1,253,0,0,3,255,255,252,0,1,253,0,0,15,255,255,252,0,1,253,0,0,63,208,0,0,0,1,253,0,0,191,128,0,0,0,1,253,0,0,126,0,0,0,0,1,253,0,0,63,255,255,240,0,1,253,0,0,23,255,255,240,0,1,253,0,0,3,255,255,243,255,255,255,255,252,2,175,254,163,255,255,255,255,252,0,3,240,3,255,255,255,255,252,0,3,240,1,85,86,254,85,84,0,3,240,0,0,1,253,0,0,0,3,240,0,0,1,253,0,0,47,255,255,252,0,1,253,0,0,47,255,255,252,0,1,253,0,0,47,255,255,252,0,1,253,0,0,0,7,244,0,0,1,253,0,0,0,3,240,0,0,1,253,0,0,0,3,240,0,0,1,253,0,0,0,3,240,0,0,1,253,0,0,0,3,240,0,0,1,253,0,0,0,3,240,4,0,1,253,0,0,0,3,240,125,0,1,253,0,0,0,7,247,254,0,1,253,0,0,0,7,255,254,0,1,253,0,0,0,15,255,224,0,1,253,0,0,0,63,255,64,0,1,253,0,0,0,47,244,0,0,1,253,0,0,0,15,128,0,0,1,253,0,0,0,4,0,0,0,1,252,0,0,
  // 0x94ae  钮
  174,148,36,36,68,38,1,252,0,100,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,253,0,2,255,255,255,255,240,1,252,0,2,255,255,255,255,240,3,255,255,246,255,255,255,255,224,3,255,255,244,0,47,192,15,224,15,255,255,244,0,47,192,15,224,31,213,85,80,0,47,192,15,224,63,128,0,0,0,63,128,15,208,191,0,0,0,0,63,128,15,208,190,0,0,0,0,63,64,15,208,63,255,255,224,0,63,64,15,208,43,255,255,224,0,63,64,15,192,3,255,255,224,0,127,0,31,192,0,15,224,0,0,127,0,31,192,0,11,208,1,255,255,255,255,192,0,11,208,1,255,255,255,255,192,0,11,208,1,255,255,255,255,192,0,11,208,0,85,254,85,127,128,63,255,255,248,0,253,0,63,128,63,255,255,248,0,253,0,63,128,63,255,255,248,0,252,0,63,64,0,15,224,0,1,252,0,63,64,0,11,208,0,1,252,0,63,64,0,11,208,0,2,252,0,63,64,0,11,208,0,2,248,0,127,0,0,11,208,0,3,248,0,127,0,0,11,208,96,3,244,0,191,0,0,11,211,240,3,244,0,191,0,0,15,255,244,3,240,0,191,0,0,15,255,224,7,240,0,254,0,0,15,255,85,91,245,85,255,84,0,63,248,63,255,255,255,255,253,0,191,208,63,255,255,255,255,253,0,62,0,63,255,255,255,255,253,0,20,0,0,0,0,0,0,0,
  // 0x9519  错
  25,149,36,36,68,38,1,252,0,24,0,0,2,244,3,240,0,0,63,64,0,2,244,3,244,0,0,127,0,0,2,244,3,244,0,0,191,0,0,2,244,3,244,0,1,254,85,80,2,244,3,244,0,3,255,255,244,255,255,255,255,244,11,255,255,244,255,255,255,255,244,31,255,255,244,255,255,255,255,244,63,192,0,0,2,248,3,244,0,127,64,0,0,2,244,3,244,0,62,0,0,0,2,244,3,244,0,27,255,255,240,2,244,3,244,0,3,255,255,240,3,248,3,244,0,3,255,255,243,255,255,255,255,253,0,11,224,3,255,255,255,255,253,0,11,224,3,255,255,255,255,253,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,47,255,255,248,63,255,255,255,192,47,255,255,248,63,255,255,255,192,47,255,255,248,63,255,255,255,192,0,11,224,0,63,64,0,31,192,0,11,224,0,63,64,0,31,192,0,11,224,0,63,64,0,31,192,0,11,224,0,63,255,255,255,192,0,11,224,0,63,255,255,255,192,0,11,224,16,63,255,255,255,192,0,11,225,240,63,64,0,31,192,0,11,255,240,63,64,0,31,192,0,15,255,240,63,64,0,31,192,0,31,255,128,63,255,255,255,192,0,63,248,0,63,255,255,255,192,0,63,208,0,63,255,255,255,192,0,30,0,0,63,64,0,31,192,0,0,0,0,42,0,0,5,64,
  // 0x955c  镜
  92,149,36,37,77,38,1,251,0,41,0,0,0,1,176,0,0,0,63,128,0,0,3,244,0,0,0,127,0,0,0,2,252,0,0,0,254,0,0,255,255,255,255,240,1,255,255,224,255,255,255,255,240,3,255,255,224,255,255,255,255,240,11,255,255,224,2,240,0,168,0,31,224,0,0,3,244,0,253,0,127,192,0,0,2,248,1,252,0,127,64,0,0,1,248,3,244,0,62,0,0,3,255,255,255,255,252,31,255,255,195,255,255,255,255,252,3,255,255,195,255,255,255,255,252,3,255,255,192,0,0,0,0,0,0,15,224,0,21,85,85,85,64,0,15,208,0,127,255,255,255,224,0,15,208,0,127,255,255,255,224,0,15,208,0,126,0,0,11,224,0,15,208,0,126,0,0,11,224,47,255,255,240,127,255,255,255,224,47,255,255,240,127,255,255,255,224,47,255,255,240,126,0,0,15,224,0,15,224,0,126,0,0,11,224,0,15,208,0,126,85,85,95,224,0,15,208,0,127,255,255,255,224,0,15,208,0,127,255,255,255,224,0,15,208,0,0,252,15,208,0,0,15,208,176,1,252,15,208,0,0,15,215,240,2,252,15,208,0,0,15,255,244,3,248,15,208,16,0,31,255,208,11,244,15,208,61,0,63,254,0,31,240,15,208,62,0,255,244,1,255,192,15,208,125,0,127,128,47,255,0,15,255,252,0,45,0,47,248,0,7,255,252,0,0,0,15,128,0,1,170,144,0,0,0,0,0,0,0,0,0,
  // 0x957f  长
  127,149,35,36,68,38,2,252,0,2,168,0,0,0,0,0,0,0,3,252,0,0,0,15,64,0,0,3,252,0,0,0,63,240,0,0,3,252,0,0,0,255,208,0,0,3,252,0,0,3,255,64,0,0,3,252,0,0,31,253,0,0,0,3,252,0,0,191,244,0,0,0,3,252,0,11,255,192,0,0,0,3,252,0,127,254,0,0,0,0,3,252,7,255,244,0,0,0,0,3,252,47,255,128,0,0,0,0,3,252,11,252,0,0,0,0,0,3,252,2,208,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,85,87,253,85,255,149,85,85,80,0,3,252,0,127,64,0,0,0,0,3,252,0,63,192,0,0,0,0,3,252,0,31,224,0,0,0,0,3,252,0,15,240,0,0,0,0,3,252,0,7,252,0,0,0,0,3,252,0,3,255,0,0,0,0,3,252,0,0,255,128,0,0,0,3,252,0,0,127,224,0,0,0,3,252,0,0,31,252,0,0,0,3,252,0,25,11,255,128,0,0,3,252,27,253,2,255,244,0,0,3,255,255,254,0,191,255,128,0,7,255,255,254,0,31,255,244,0,31,255,255,144,0,2,255,224,0,15,255,144,0,0,0,47,192,0,11,228,0,0,0,0,1,64,0,1,0,0,0,0,0,0,0,
  // 0x95ed  闭
  237,149,32,37,40,38,3,251,1,0,0,0,0,0,0,0,31,128,0,0,0,0,0,0,63,224,11,255,255,255,255,255,15,248,11,255,255,255,255,255,3,253,11,255,255,255,255,255,0,255,1,85,85,85,85,191,0,126,0,0,0,0,0,191,0,32,0,0,10,144,0,191,0,0,0,0,15,224,0,191,254,0,0,0,15,224,0,191,254,0,0,0,15,224,0,191,254,0,0,0,15,224,0,191,254,1,85,85,95,245,80,191,254,11,255,255,255,255,248,191,254,11,255,255,255,255,248,191,254,11,255,255,255,255,248,191,254,0,0,1,255,224,0,191,254,0,0,3,255,224,0,191,254,0,0,15,255,224,0,191,254,0,0,47,239,224,0,191,254,0,0,191,207,224,0,191,254,0,2,255,15,224,0,191,254,0,15,252,15,224,0,191,254,0,63,244,15,224,0,191,254,1,255,208,15,224,0,191,254,15,255,0,15,224,0,191,254,63,252,0,15,224,0,191,254,31,208,0,15,224,0,191,254,11,0,0,15,224,0,191,254,0,0,127,255,224,0,191,254,0,0,63,255,192,0,191,254,0,0,47,255,64,0,191,254,0,0,5,64,0,0,255,254,0,0,0,0,0,255,254,254,0,0,0,0,0,191,253,254,0,0,0,0,0,127,228,0,0,0,0,0,0,0,0,
  // 0x95f2  闲
  242,149,32,36,32,38,3,252,1,0,0,0,0,0,0,0,11,192,1,85,85,85,85,84,31,240,7,255,255,255,255,255,7,252,7,255,255,255,255,255,2,254,7,255,255,255,255,255,0,191,64,0,0,0,0,191,0,63,192,0,0,0,0,191,0,31,224,0,0,0,0,191,0,11,64,0,0,0,0,191,253,0,0,11,224,0,0,191,253,0,0,11,224,0,0,191,253,0,0,11,224,0,0,191,253,0,0,11,224,0,0,191,253,0,0,11,224,0,0,191,253,15,255,255,255,255,244,191,253,15,255,255,255,255,244,191,253,15,255,255,255,255,244,191,253,0,0,63,252,0,0,191,253,0,0,255,255,0,0,191,253,0,1,255,255,192,0,191,253,0,3,255,239,240,0,191,253,0,15,235,231,252,0,191,253,0,63,203,225,255,0,191,253,0,255,11,224,127,128,191,253,3,253,11,224,47,208,191,253,31,248,11,224,15,240,191,253,47,224,11,224,3,208,191,253,11,128,11,224,1,0,191,253,1,0,11,224,0,0,191,253,0,0,11,224,0,0,191,253,0,0,11,224,0,0,191,253,0,0,11,224,0,0,191,253,0,0,5,64,15,255,254,253,0,0,0,0,11,255,253,253,0,0,0,0,7,255,244,253,0,0,0,0,1,85,0,
  // 0x95f4  间
  244,149,32,37,40,38,3,251,1,0,0,0,0,0,0,0,31,128,0,0,0,0,0,0,63,224,15,255,255,255,255,255,15,248,15,255,255,255,255,255,3,253,15,255,255,255,255,255,1,255,1,85,85,85,85,255,0,189,0,0,0,0,0,255,0,32,0,0,0,0,0,255,0,0,0,0,0,0,0,255,191,0,0,0,0,0,0,255,191,0,0,0,0,0,0,255,191,0,127,255,255,253,0,255,191,0,127,255,255,253,0,255,191,0,127,255,255,253,0,255,191,0,127,0,0,253,0,255,191,0,127,0,0,253,0,255,191,0,127,0,0,253,0,255,191,0,127,0,0,253,0,255,191,0,127,0,0,253,0,255,191,0,127,255,255,253,0,255,191,0,127,255,255,253,0,255,191,0,127,255,255,253,0,255,191,0,127,0,0,253,0,255,191,0,127,0,0,253,0,255,191,0,127,0,0,253,0,255,191,0,127,0,0,253,0,255,191,0,127,255,255,253,0,255,191,0,127,255,255,253,0,255,191,0,127,255,255,253,0,255,191,0,0,0,0,0,0,255,191,0,0,0,0,0,0,255,191,0,0,0,0,0,0,255,191,0,0,0,0,0,0,255,191,0,0,0,0,0,127,254,191,0,0,0,0,0,63,253,191,0,0,0,0,0,63,228,0,0,0,0,0,0,0,0,
  // 0x9608  阈
  8,150,32,37,40,38,3,251,0,128,0,0,0,0,0,0,7,224,0,0,0,0,0,0,15,248,7,255,255,255,255,254,3,253,7,255,255,255,255,254,0,255,7,255,255,255,255,254,0,127,192,0,0,0,0,254,0,47,224,0,125,0,0,254,0,15,192,0,125,125,0,254,191,2,0,0,125,63,64,254,191,0,0,0,125,15,192,254,191,0,0,0,125,2,0,254,191,31,255,255,255,255,244,254,191,31,255,255,255,255,244,254,191,15,255,255,255,255,244,254,191,0,0,0,62,0,0,254,191,0,0,0,63,2,64,254,191,7,255,252,63,11,208,254,191,7,255,252,63,15,192,254,191,7,192,60,47,15,128,254,191,7,192,60,47,95,64,254,191,7,192,60,31,127,0,254,191,7,192,60,15,190,0,254,191,7,255,252,15,252,0,254,191,7,255,252,15,252,0,254,191,0,0,0,11,244,16,254,191,0,0,1,7,240,56,254,191,0,26,255,15,240,60,254,191,47,255,255,63,244,124,254,191,47,255,249,191,253,248,254,191,31,148,2,252,191,244,254,191,0,0,15,240,63,240,254,191,0,0,11,192,11,192,254,191,0,0,1,0,0,0,254,191,0,0,0,0,11,255,253,191,0,0,0,0,3,255,252,191,0,0,0,0,3,255,208,0,0,0,0,0,0,0,0,
  // 0x964d  降
  77,150,34,36,68,38,3,252,0,0,0,0,3,160,0,0,0,0,0,0,0,11,240,0,0,0,255,255,244,0,31,208,0,0,0,255,255,252,0,63,255,255,224,0,255,255,252,0,255,255,255,248,0,252,3,244,2,255,255,255,240,0,252,3,240,11,252,0,15,224,0,252,7,240,47,255,0,47,192,0,252,11,224,255,255,128,127,128,0,252,15,195,254,31,209,255,0,0,252,31,192,248,11,251,252,0,0,252,47,64,16,3,255,240,0,0,252,63,0,0,0,255,224,0,0,252,63,0,0,7,255,248,0,0,252,63,64,0,127,255,255,144,0,252,31,192,11,255,225,255,254,64,252,11,225,255,255,0,47,255,208,252,3,241,255,244,7,242,255,128,252,3,244,254,64,7,240,11,0,252,2,248,80,0,7,240,0,0,252,1,252,63,255,255,255,255,0,252,1,252,63,255,255,255,255,0,252,1,252,63,255,255,255,255,0,252,3,248,2,244,7,240,0,0,252,255,244,2,244,7,240,0,0,252,191,240,2,244,7,240,0,0,252,127,128,2,244,7,240,0,0,252,0,3,255,255,255,255,255,192,252,0,3,255,255,255,255,255,192,252,0,3,255,255,255,255,255,192,252,0,0,0,0,7,240,0,0,252,0,0,0,0,7,240,0,0,252,0,0,0,0,7,240,0,0,252,0,0,0,0,7,240,0,0,252,0,0,0,0,7,240,0,0,252,0,0,0,0,7,240,0,0,
  // 0x9650  限
  80,150,34,34,50,38,3,252,255,255,253,15,255,255,255,252,0,255,255,255,15,255,255,255,252,0,255,255,254,15,255,255,255,252,0,253,0,253,15,192,0,1,252,0,253,1,252,15,192,0,1,252,0,253,2,248,15,192,0,1,252,0,253,3,244,15,192,0,1,252,0,253,7,240,15,255,255,255,252,0,253,11,224,15,255,255,255,252,0,253,15,192,15,255,255,255,252,0,253,31,128,15,192,0,1,252,0,253,47,64,15,192,0,1,252,0,253,31,192,15,192,0,1,252,0,253,7,240,15,192,0,1,252,0,253,3,244,15,255,255,255,252,0,253,1,252,15,255,255,255,252,0,253,0,253,15,255,255,255,252,0,253,0,190,15,192,63,0,0,0,253,0,190,15,192,63,64,44,0,253,0,190,15,192,47,128,191,64,253,0,190,15,192,31,194,255,0,253,1,254,15,192,15,219,248,0,253,127,253,15,192,11,255,224,0,253,63,252,15,192,3,255,64,0,253,63,224,15,192,2,253,0,0,253,0,0,15,192,0,254,0,0,253,0,0,15,192,0,255,128,0,253,0,0,15,192,106,63,208,0,253,0,0,15,255,255,31,244,0,253,0,6,255,255,255,11,254,0,253,0,15,255,255,249,3,255,208,253,0,11,255,249,0,0,255,192,253,0,7,228,0,0,0,47,0,253,0,0,0,0,0,0,1,0,
  // 0x9664  除
  100,150,34,36,68,38,3,252,0,0,0,0,1,252,0,0,0,0,0,0,0,3,255,0,0,0,255,255,244,0,11,255,128,0,0,255,255,252,0,31,255,224,0,0,255,255,252,0,63,203,244,0,0,252,3,244,0,255,3,253,0,0,252,3,240,3,253,0,255,128,0,252,7,240,15,244,0,63,224,0,252,11,208,127,208,0,15,252,0,252,15,194,255,64,0,3,255,128,252,31,143,253,0,0,0,191,224,252,47,79,251,255,255,255,239,192,252,63,3,139,255,255,255,199,64,252,63,0,11,255,255,255,192,0,252,47,128,0,0,253,0,0,0,252,15,192,0,0,253,0,0,0,252,11,224,0,0,253,0,0,0,252,3,240,0,0,253,0,0,0,252,3,244,0,0,253,0,0,0,252,2,248,255,255,255,255,255,0,252,1,252,255,255,255,255,255,0,252,1,252,255,255,255,255,255,0,252,1,252,0,0,253,0,0,0,252,3,248,0,0,253,0,0,0,252,255,244,31,128,253,11,192,0,252,191,240,47,128,253,15,208,0,252,127,128,63,64,253,11,240,0,252,0,0,191,0,253,3,252,0,252,0,1,253,0,253,1,253,0,252,0,3,252,0,253,0,191,0,252,0,15,240,0,253,0,63,64,252,0,47,224,0,253,0,47,192,252,0,11,128,85,253,0,15,64,252,0,2,0,255,252,0,4,0,252,0,0,0,191,252,0,0,0,252,0,0,0,63,160,0,0,0,
  // 0x9669  险
  105,150,34,36,68,38,3,252,0,0,0,0,0,120,0,0,0,0,0,0,0,0,254,0,0,0,255,255,244,0,2,254,0,0,0,255,255,252,0,3,255,64,0,0,255,255,252,0,15,255,192,0,0,253,3,244,0,47,223,240,0,0,253,3,240,0,191,135,252,0,0,253,7,240,1,255,1,255,0,0,253,11,208,7,252,0,127,208,0,253,15,192,31,240,0,31,248,0,253,31,128,191,208,0,7,255,0,253,47,67,255,64,0,1,255,224,253,63,15,255,255,255,255,127,224,253,63,11,247,255,255,255,15,192,253,47,195,195,255,255,255,2,128,253,15,209,0,0,0,0,0,0,253,7,240,0,0,0,0,0,0,253,3,244,0,0,0,0,0,0,253,2,248,1,0,252,0,126,0,253,1,248,63,0,188,0,190,0,253,1,252,47,0,189,0,253,0,253,1,252,31,128,126,1,252,0,253,1,252,15,192,63,2,244,0,253,3,248,15,192,63,3,240,0,253,255,244,11,208,63,7,224,0,253,127,240,7,224,47,15,192,0,253,127,128,3,240,47,95,192,0,253,0,0,3,240,0,47,64,0,253,0,0,1,0,0,63,0,0,253,0,0,0,0,0,189,0,0,253,0,0,0,0,0,252,0,0,253,0,3,255,255,255,255,255,192,253,0,3,255,255,255,255,255,192,253,0,3,255,255,255,255,255,192,253,0,0,0,0,0,0,0,0,188,0,0,0,0,0,0,0,0,
  // 0x96f6  零
  246,150,35,35,59,38,2,252,2,170,170,170,170,170,170,164,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,85,85,87,249,85,85,95,192,63,0,0,3,248,0,0,15,192,63,26,170,147,248,170,170,79,192,63,31,255,227,248,255,255,79,192,63,0,0,3,248,0,0,15,192,0,0,0,3,248,0,0,0,0,0,63,255,225,80,255,255,208,0,0,63,255,231,252,255,255,208,0,0,0,0,47,255,64,0,0,0,0,0,1,255,255,224,0,0,0,0,0,11,254,15,254,0,0,0,0,0,191,244,1,255,224,0,0,0,27,255,128,0,47,255,64,0,2,255,255,255,255,255,255,249,0,191,255,159,255,255,255,111,255,244,255,248,5,85,85,85,2,255,240,190,64,0,0,0,0,0,11,208,16,85,85,85,85,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,0,0,127,0,0,47,192,0,0,0,0,127,0,0,47,192,0,0,0,0,127,0,0,47,192,0,0,0,0,127,0,42,191,192,0,0,0,0,127,0,47,255,128,0,0,0,0,127,0,15,249,0,0,0,0,0,127,0,0,0,0,0,0,0,0,63,0,0,0,0,0,
  // 0x9700  需
  0,151,34,35,59,38,2,252,2,255,255,255,255,255,255,248,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,21,85,85,87,253,85,85,85,64,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,0,0,3,248,0,0,15,192,63,0,0,3,248,0,0,15,192,63,31,255,227,248,191,255,79,192,63,31,255,227,248,191,255,79,192,63,0,0,3,248,0,0,15,192,0,0,0,3,248,0,0,0,0,0,63,255,227,248,191,255,192,0,0,63,255,227,248,191,255,192,0,0,0,0,3,248,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,224,127,255,255,255,255,255,255,255,224,127,255,255,255,255,255,255,255,208,0,0,0,7,240,0,0,0,0,0,0,0,11,240,0,0,0,0,2,255,255,255,255,255,255,253,0,2,255,255,255,255,255,255,253,0,2,255,255,255,255,255,255,253,0,2,248,1,248,0,252,0,253,0,2,248,1,248,0,252,0,253,0,2,248,1,248,0,252,0,253,0,2,248,1,248,0,252,0,253,0,2,248,1,248,0,252,0,253,0,2,248,1,248,0,252,0,253,0,2,248,1,248,0,252,63,253,0,2,248,1,248,0,252,63,252,0,2,248,1,164,0,168,31,224,0,
  // 0x9752  青
  82,151,34,36,68,38,2,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,2,170,170,171,254,170,170,169,0,7,255,255,255,255,255,255,254,0,7,255,255,255,255,255,255,254,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,170,170,171,254,170,170,160,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,106,170,170,171,254,170,170,170,144,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,170,170,170,170,170,128,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,192,0,0,0,63,192,0,0,47,192,0,0,0,63,192,0,0,47,213,85,85,85,127,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,192,0,0,0,63,192,0,0,47,192,0,0,0,63,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,213,85,85,85,127,192,0,0,47,192,0,0,0,63,192,0,0,47,192,0,0,0,63,192,0,0,47,192,0,0,0,63,192,0,0,47,192,0,1,255,255,128,0,0,47,192,0,0,255,255,0,0,0,31,192,0,0,191,164,0,0,
  // 0x975e  非
  94,151,36,37,77,38,1,251,0,0,1,168,0,106,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,5,85,86,252,0,127,85,85,80,15,255,255,252,0,127,255,255,248,15,255,255,252,0,127,255,255,248,15,255,255,252,0,127,255,255,248,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,0,0,1,252,0,127,0,0,0,1,85,86,252,0,127,85,85,64,11,255,255,252,0,127,255,255,240,11,255,255,252,0,127,255,255,240,11,255,255,252,0,127,255,255,240,0,0,2,252,0,127,0,0,0,0,0,2,252,0,127,0,0,0,0,0,2,252,0,127,0,0,0,0,0,2,252,0,127,0,0,0,0,0,3,255,240,127,0,0,0,0,90,255,255,240,127,85,85,84,127,255,255,255,240,127,255,255,253,127,255,255,249,0,127,255,255,253,63,254,175,224,0,127,255,255,253,41,0,63,192,0,127,0,0,0,0,0,191,128,0,127,0,0,0,0,1,255,0,0,127,0,0,0,0,7,253,0,0,127,0,0,0,0,47,248,0,0,127,0,0,0,0,255,224,0,0,127,0,0,0,11,255,128,0,0,127,0,0,0,7,253,0,0,0,127,0,0,0,1,224,0,0,0,127,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9760  靠
  96,151,35,37,77,38,2,251,0,5,64,2,244,0,0,0,0,0,15,208,3,248,0,0,0,0,0,47,213,87,249,85,85,80,0,0,127,255,255,255,255,255,248,0,0,255,255,255,255,255,255,248,0,3,252,0,3,248,0,0,0,0,3,244,0,3,248,0,0,0,0,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,42,170,170,171,254,170,170,170,128,0,0,0,1,84,0,0,0,0,0,191,255,255,255,255,255,244,0,0,191,255,255,255,255,255,244,0,0,191,85,85,85,85,91,244,0,0,191,0,0,0,0,7,244,0,0,191,0,0,0,0,7,244,0,0,191,255,255,255,255,255,244,0,0,191,255,255,255,255,255,244,0,0,0,7,244,2,253,0,0,0,0,0,3,240,1,252,0,0,0,63,255,255,240,1,255,255,255,192,63,255,255,240,1,255,255,255,192,21,85,87,240,1,253,0,0,0,0,0,3,240,1,252,0,0,0,31,255,255,240,1,255,255,255,64,31,255,255,240,1,255,255,255,64,0,0,7,240,1,253,0,0,0,0,0,7,240,1,252,0,0,0,170,191,255,240,1,253,85,85,80,255,255,255,224,1,255,255,255,244,250,165,127,192,1,255,255,255,244,0,0,255,128,1,252,0,0,0,0,31,254,0,1,252,0,0,0,3,255,244,0,1,252,0,0,0,2,255,128,0,1,252,0,0,0,0,244,0,0,1,168,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9762  面
  98,151,34,34,50,38,2,252,21,85,85,85,85,85,85,85,80,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,191,255,255,255,255,255,255,255,240,0,0,0,11,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,31,208,0,0,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,208,15,208,0,254,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,255,255,253,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,208,15,192,0,189,0,191,0,15,229,95,213,85,254,85,191,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,208,0,0,0,0,0,191,0,15,208,0,0,0,0,0,191,0,
  // 0x9875  页
  117,152,34,35,59,38,2,251,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,21,85,85,95,249,85,85,85,64,0,0,0,15,240,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,47,192,0,0,0,0,0,21,85,127,213,85,85,80,0,0,191,255,255,255,255,255,240,0,0,191,255,255,255,255,255,240,0,0,191,255,255,255,255,255,240,0,0,191,0,0,0,0,11,240,0,0,191,0,0,0,0,11,240,0,0,191,0,2,252,0,11,240,0,0,191,0,2,252,0,11,240,0,0,191,0,2,252,0,11,240,0,0,191,0,2,252,0,11,240,0,0,191,0,2,252,0,11,240,0,0,191,0,2,252,0,11,240,0,0,191,0,2,252,0,11,240,0,0,191,0,3,252,0,11,240,0,0,191,0,3,252,0,11,240,0,0,191,0,3,248,0,11,240,0,0,191,0,7,244,0,11,240,0,0,191,0,15,240,144,11,240,0,0,106,0,63,225,253,6,160,0,0,0,0,255,195,255,208,0,0,0,0,11,255,0,191,253,0,0,0,0,191,252,0,11,255,208,0,0,31,255,224,0,0,255,252,0,27,255,255,64,0,0,31,255,128,191,255,228,0,0,0,1,255,208,63,253,0,0,0,0,0,47,128,14,64,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,
  // 0x9879  项
  121,152,36,34,50,38,1,252,0,0,0,31,255,255,255,255,253,0,0,0,31,255,255,255,255,253,21,85,85,95,255,255,255,255,253,63,255,255,192,0,31,224,0,0,63,255,255,192,0,47,192,0,0,63,255,255,192,0,63,192,0,0,0,47,192,0,0,127,64,0,0,0,47,192,3,255,255,255,255,192,0,47,192,3,255,255,255,255,192,0,47,192,3,255,255,255,255,192,0,47,192,3,240,0,0,47,192,0,47,192,3,240,0,0,47,192,0,47,192,3,240,15,224,47,192,0,47,192,3,240,15,224,47,192,0,47,192,3,240,15,224,47,192,0,47,192,3,240,15,224,47,192,0,47,192,3,240,15,224,47,192,0,47,192,3,240,15,224,47,192,0,47,192,3,240,15,224,47,192,0,47,192,3,240,15,224,47,192,0,47,219,211,240,15,224,47,192,0,47,255,211,240,15,224,47,192,6,255,255,211,240,15,208,47,192,191,255,249,3,240,31,208,47,192,191,255,64,3,240,63,192,26,128,127,208,0,0,0,127,129,0,0,56,0,0,0,1,255,15,192,0,0,0,0,0,7,253,47,248,0,0,0,0,0,47,244,11,255,0,0,0,0,2,255,224,1,255,208,0,0,0,111,255,64,0,47,248,0,0,2,255,248,0,0,7,253,0,0,0,255,128,0,0,1,244,0,0,0,36,0,0,0,0,16,
  // 0x9884  预
  132,152,36,35,59,38,1,251,47,255,255,252,127,255,255,255,253,47,255,255,253,127,255,255,255,253,47,255,255,252,127,255,255,255,253,0,0,11,240,0,0,255,0,0,0,0,31,208,0,0,253,0,0,1,128,127,128,0,1,252,0,0,3,245,254,0,15,255,255,255,240,7,255,248,0,15,255,255,255,240,0,255,240,0,15,255,255,255,240,0,47,248,0,15,192,0,11,240,0,11,255,0,15,192,0,11,240,0,2,255,128,15,192,0,11,240,0,0,191,64,15,192,189,11,240,191,255,255,255,143,192,253,11,240,191,255,255,255,143,192,253,11,240,191,255,255,255,15,192,253,11,240,0,11,240,63,15,192,253,11,240,0,11,240,126,15,192,253,11,240,0,11,240,188,15,192,253,11,240,0,11,240,252,15,192,253,11,240,0,11,241,248,15,192,253,11,240,0,11,241,176,15,192,252,11,240,0,11,240,0,15,192,252,11,240,0,11,240,0,15,193,252,11,240,0,11,240,0,15,195,252,11,240,0,11,240,0,0,7,244,0,0,0,11,240,0,0,15,240,224,0,0,11,240,0,0,63,211,248,0,0,11,240,0,0,255,131,255,0,0,11,240,0,7,255,0,191,192,5,95,240,0,127,248,0,47,244,15,255,224,3,255,208,0,11,252,11,255,208,1,254,0,0,1,248,7,254,0,0,160,0,0,0,160,0,0,0,0,0,0,0,0,0,
  // 0x9891  频
  145,152,36,37,77,38,1,251,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,7,255,255,255,252,0,0,63,0,7,255,255,255,252,3,240,63,0,7,255,255,255,252,3,240,63,255,192,0,47,128,0,3,240,63,255,192,0,63,64,0,3,240,63,255,192,0,63,0,0,3,240,63,0,0,0,190,0,0,3,240,63,0,1,170,255,170,160,3,240,63,0,2,255,255,255,240,3,240,63,0,2,255,255,255,240,127,255,255,255,242,244,0,3,240,127,255,255,255,242,244,5,3,240,127,255,255,255,242,244,47,3,240,0,0,253,0,2,244,47,3,240,0,0,253,0,2,244,47,3,240,1,144,253,0,2,244,63,3,240,2,244,253,7,226,244,63,3,240,3,240,253,11,226,244,63,3,240,7,240,253,15,210,244,63,3,240,15,208,253,31,194,244,63,3,240,31,192,253,47,130,244,63,3,240,63,128,253,127,66,244,63,3,240,127,0,253,255,2,244,62,3,240,29,0,254,253,2,244,126,3,240,0,0,175,252,2,244,189,3,240,0,0,15,240,0,80,252,0,0,0,0,63,208,0,2,254,224,0,0,0,255,128,0,3,251,252,0,0,7,254,0,0,15,241,255,0,0,127,248,0,0,127,192,127,208,7,255,208,0,7,255,64,15,244,63,254,0,0,191,253,0,3,253,31,244,0,0,63,224,0,0,252,14,0,0,0,45,0,0,0,32,0,0,0,0,0,0,0,0,0,
  // 0x989d  额
  157,152,36,37,77,38,1,251,0,0,96,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,1,252,0,7,255,255,255,252,0,0,254,0,7,255,255,255,252,63,255,255,255,247,255,255,255,252,63,255,255,255,240,0,63,0,0,63,255,255,255,240,0,127,0,0,63,64,0,7,240,0,190,0,0,63,75,224,7,240,0,252,0,0,63,79,208,7,242,255,255,255,224,0,63,234,169,3,255,255,255,240,0,191,255,255,131,255,255,255,240,2,255,255,255,67,240,0,3,240,11,248,0,255,3,240,0,3,240,47,224,3,252,3,240,63,3,240,127,143,75,248,3,240,63,3,240,30,63,255,224,3,240,63,3,240,4,47,255,192,3,240,63,3,240,0,7,255,224,3,240,63,3,240,0,47,255,253,3,240,63,3,240,6,255,235,255,195,240,63,3,240,63,255,64,191,243,240,126,3,240,63,248,0,31,211,240,126,3,240,47,192,0,2,67,240,190,3,240,25,255,255,255,3,240,189,3,240,0,255,255,255,3,240,252,3,240,0,255,255,255,3,240,252,3,240,0,252,0,127,2,161,248,2,144,0,252,0,127,0,3,244,160,0,0,252,0,127,0,11,242,252,0,0,252,0,127,0,31,210,255,64,0,252,0,127,0,127,192,127,208,0,255,255,255,2,255,0,31,248,0,255,255,255,47,252,0,3,254,0,255,255,255,127,224,0,0,253,0,248,0,127,46,64,0,0,56,0,0,0,0,0,0,0,0,0,
  // 0x98ce  风
  206,152,36,36,68,38,1,251,0,21,85,85,85,85,85,84,0,0,63,255,255,255,255,255,248,0,0,63,255,255,255,255,255,248,0,0,63,255,255,255,255,255,248,0,0,63,128,0,0,0,3,248,0,0,63,128,0,0,0,3,248,0,0,63,128,0,0,0,3,248,0,0,63,128,0,0,47,67,248,0,0,63,129,128,0,63,67,248,0,0,63,143,240,0,127,3,248,0,0,63,139,248,0,190,3,248,0,0,63,131,253,0,253,3,248,0,0,63,128,255,2,252,3,248,0,0,63,128,127,195,248,3,248,0,0,63,128,47,231,240,2,248,0,0,63,128,15,255,224,2,248,0,0,63,64,3,255,192,2,248,0,0,63,64,1,255,192,2,248,0,0,127,64,0,255,128,2,248,0,0,127,0,1,255,208,2,248,0,0,191,0,3,255,240,2,252,0,0,191,0,11,255,248,2,252,0,0,255,0,31,243,253,1,252,0,0,254,0,63,193,255,1,252,0,0,254,0,255,64,255,129,252,0,1,253,3,255,0,63,192,252,0,2,252,15,252,0,47,240,252,24,3,252,127,240,0,15,244,253,30,7,248,127,208,0,7,240,253,47,11,240,31,64,0,3,64,190,46,15,240,4,0,0,0,0,127,62,47,208,0,0,0,0,0,63,253,127,192,0,0,0,0,0,47,252,47,64,0,0,0,0,0,15,248,7,0,0,0,0,0,0,1,160,0,0,0,0,0,0,0,0,0,
  // 0x9971  饱
  113,153,36,36,68,38,1,252,0,100,0,0,2,0,0,0,0,0,190,0,0,7,240,0,0,0,0,253,0,0,11,224,0,0,0,0,253,0,0,15,208,0,0,0,0,252,0,0,47,192,0,0,0,1,252,0,0,63,255,255,255,208,2,255,255,224,127,255,255,255,208,3,255,255,240,255,255,255,255,208,3,255,255,226,252,0,0,15,208,11,240,15,215,244,0,0,15,208,15,208,15,207,240,0,0,15,208,31,192,47,255,255,255,252,15,208,63,128,63,127,255,255,252,15,208,127,69,127,30,255,255,252,15,208,191,47,128,8,253,0,252,15,208,61,47,128,0,253,0,252,15,208,8,47,128,0,253,0,252,15,208,0,47,128,0,253,0,252,15,208,0,47,128,0,253,0,252,15,208,0,47,128,0,253,0,252,15,192,0,47,128,0,255,255,252,15,192,0,47,128,0,255,255,252,31,192,0,47,128,0,255,255,252,47,192,0,47,128,0,253,0,63,255,192,0,47,128,0,253,0,47,255,64,0,47,128,64,253,0,31,253,0,0,47,131,192,253,0,0,0,0,0,47,159,192,253,0,0,0,64,0,47,255,208,253,0,0,0,184,0,47,255,64,253,0,0,0,253,0,63,253,0,253,0,0,0,252,0,63,240,0,255,0,0,2,252,0,191,192,0,191,255,255,255,248,0,254,0,0,63,255,255,255,240,0,56,0,0,11,255,255,255,128,0,16,0,0,0,0,0,0,0,
  // 0x9a6c  马
  108,154,33,35,59,38,2,251,1,85,85,85,85,85,101,0,0,3,255,255,255,255,255,255,0,0,3,255,255,255,255,255,255,0,0,3,255,255,255,255,255,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,253,0,0,0,6,80,0,0,0,253,0,0,0,11,240,0,0,0,253,0,0,0,11,240,0,0,1,252,0,0,0,15,224,0,0,1,252,0,0,0,15,224,0,0,2,252,0,0,0,15,224,0,0,2,252,0,0,0,15,208,0,0,3,248,0,0,0,15,208,0,0,3,248,0,0,0,31,192,0,0,3,248,0,0,0,31,255,255,255,255,255,255,192,0,47,255,255,255,255,255,255,192,0,47,255,255,255,255,255,255,192,0,21,85,85,85,85,85,127,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,64,85,85,85,85,85,85,64,127,64,191,255,255,255,255,255,192,127,0,191,255,255,255,255,255,192,191,0,191,255,255,255,255,255,192,191,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,64,11,252,0,0,0,0,0,1,255,255,244,0,0,0,0,0,0,255,255,224,0,0,0,0,0,0,191,255,64,0,0,0,0,0,0,0,0,0,0,
  // 0x9a71  驱
  113,154,36,34,50,38,1,252,31,255,255,192,255,255,255,255,248,31,255,255,192,255,255,255,255,248,31,255,255,192,255,255,255,255,248,0,0,15,192,254,0,0,0,0,0,0,15,192,254,0,0,0,0,2,144,15,192,254,0,0,9,0,7,224,15,192,254,8,0,15,208,7,224,31,128,254,63,0,47,192,7,224,31,128,254,63,128,63,128,7,224,31,128,254,31,208,127,64,11,208,47,64,254,15,240,191,0,11,208,47,64,254,3,248,254,0,11,208,47,64,254,1,254,252,0,15,192,63,0,254,0,255,252,0,15,192,63,0,254,0,63,244,0,15,192,63,0,254,0,31,240,0,15,255,255,248,254,0,15,240,0,15,255,255,248,254,0,47,248,0,31,255,255,248,254,0,127,252,0,0,0,2,244,254,0,255,255,0,0,0,2,244,254,1,253,127,64,0,0,2,244,254,3,248,63,192,0,0,99,244,254,15,240,31,208,0,111,243,240,254,47,224,11,240,111,255,243,240,254,127,192,3,244,191,254,67,240,254,191,0,3,224,126,64,3,240,254,29,0,0,0,0,0,7,240,254,4,0,0,0,0,0,7,224,254,0,0,0,0,0,0,11,208,255,255,255,255,253,0,0,31,208,255,255,255,255,253,0,127,255,192,255,255,255,255,253,0,63,255,64,0,0,0,0,0,0,43,232,0,0,0,0,0,0,
  // 0x9ad8  高
  216,154,34,36,68,38,2,252,0,0,0,3,244,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,1,85,85,85,85,84,0,0,0,3,255,255,255,255,252,0,0,0,3,255,255,255,255,252,0,0,0,3,240,0,0,1,252,0,0,0,3,240,0,0,1,252,0,0,0,3,240,0,0,1,252,0,0,0,3,249,85,85,86,252,0,0,0,3,255,255,255,255,252,0,0,0,3,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,224,0,0,0,0,0,127,0,15,224,0,0,0,0,0,127,0,15,224,15,255,255,255,0,127,0,15,224,15,255,255,255,0,127,0,15,224,15,234,170,191,0,127,0,15,224,15,192,0,63,0,127,0,15,224,15,192,0,63,0,127,0,15,224,15,192,0,63,0,127,0,15,224,15,255,255,255,0,127,0,15,224,15,255,255,255,0,127,0,15,224,15,213,85,87,65,191,0,15,224,15,192,0,2,255,255,0,15,224,5,64,0,1,255,254,0,15,224,0,0,0,0,255,228,0,
  // 0x9ec4  黄
  196,158,34,36,68,38,2,252,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,3,255,255,255,255,255,255,253,0,3,255,255,255,255,255,255,253,0,3,255,255,255,255,255,255,253,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,0,0,47,192,0,63,192,0,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,106,170,171,254,170,170,160,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,254,0,3,252,0,7,240,0,0,254,0,3,252,0,7,240,0,0,254,0,3,252,0,7,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,254,85,87,253,85,91,240,0,0,254,0,3,252,0,7,240,0,0,254,0,3,252,0,7,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,106,170,170,170,170,170,160,0,0,0,11,64,0,30,64,0,0,0,0,191,224,0,127,248,0,0,0,31,255,208,0,111,255,208,0,6,255,254,0,0,1,255,254,0,127,255,224,0,0,0,27,255,208,47,249,0,0,0,0,0,191,128,10,64,0,0,0,0,0,9,0,
  // 0x9ede  點
  222,158,36,36,68,38,1,252,0,0,0,0,0,0,190,0,0,5,85,85,85,64,0,190,0,0,15,255,255,255,192,0,190,0,0,15,255,255,255,192,0,190,0,0,15,128,184,11,192,0,190,0,0,15,148,184,91,192,0,190,0,0,15,188,184,251,192,0,190,0,0,15,172,184,251,192,0,190,0,0,15,157,185,219,192,0,191,85,84,15,142,186,203,192,0,191,255,253,15,142,187,203,192,0,191,255,253,15,132,185,75,192,0,191,255,253,15,128,184,11,192,0,190,0,0,15,255,255,255,192,0,190,0,0,15,255,255,255,192,0,190,0,0,5,86,254,85,64,0,190,0,0,0,0,252,0,0,0,190,0,0,0,0,252,0,0,0,190,0,0,15,255,255,255,208,0,255,0,0,15,255,255,255,211,255,255,255,240,10,171,255,170,147,255,255,255,240,0,0,252,0,3,255,255,255,240,0,0,254,170,163,240,0,7,240,47,255,255,255,243,240,0,7,240,63,255,255,255,243,240,0,7,240,63,254,169,80,3,240,0,7,240,0,0,0,0,3,240,0,7,240,0,0,5,31,3,240,0,7,240,7,207,79,15,131,240,0,7,240,11,203,143,135,211,240,0,7,240,15,203,199,195,243,240,0,7,240,15,135,195,193,243,255,255,255,240,47,71,195,208,247,255,255,255,240,63,7,194,208,3,255,255,255,240,125,2,64,0,3,244,0,7,240,24,0,0,0,3,240,0,2,160,
  // 0x9f50  齐
  80,159,35,37,77,38,2,251,0,0,0,3,248,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,0,3,252,0,0,3,252,0,0,0,0,255,0,0,15,244,0,0,0,0,127,192,0,63,224,0,0,0,0,31,240,0,255,192,0,0,0,0,7,254,7,255,0,0,0,0,0,1,255,239,248,0,0,0,0,0,0,63,255,224,0,0,0,0,0,0,47,255,224,0,0,0,0,0,6,255,255,255,64,0,0,0,6,255,255,159,255,254,80,0,91,255,255,248,1,191,255,255,228,255,255,254,64,0,7,255,255,240,127,255,228,0,0,0,111,255,208,62,145,252,0,0,2,252,22,128,0,1,252,0,0,2,252,0,0,0,1,252,0,0,2,252,0,0,0,1,252,0,0,2,252,0,0,0,1,252,0,0,2,252,0,0,0,1,252,0,0,2,252,0,0,0,2,252,0,0,2,252,0,0,0,3,252,0,0,2,252,0,0,0,7,248,0,0,2,252,0,0,0,11,244,0,0,2,252,0,0,0,31,240,0,0,2,252,0,0,0,127,224,0,0,2,252,0,0,2,255,192,0,0,2,252,0,0,31,255,0,0,0,2,252,0,0,11,252,0,0,0,2,252,0,0,1,224,0,0,0,2,252,0,0,0,0,0,0,0,0,0,0,0,
  // 0xff1a  ：
  26,255,6,25,50,38,16,1,63,192,255,240,255,240,255,240,191,224,47,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,192,255,240,255,240,255,240,191,224,47,128,
};

#endif // HAS_GRAPHICAL_TFT
