/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Katakana 38pt, capital 'A' height: 28px, width: 100%, range: 0x30a0-0x8868, glyphs: 103
extern const uint8_t NotoSans_Medium_Katakana_28[12298] = {
  162,28,160,48,104,136,37,246, // unifont_t
  // 0x30a0  ゠
  160,48,18,8,40,38,10,10,127,255,255,255,208,21,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,85,85,85,64,127,255,255,255,208,
  // 0x30a1  ァ
  161,48,27,26,182,38,6,251,106,85,85,85,85,86,144,127,255,255,255,255,255,244,127,255,255,255,255,255,252,127,255,255,255,255,255,244,0,0,0,0,0,47,224,0,0,0,0,0,127,192,0,0,10,164,0,255,64,0,0,11,244,3,254,0,0,0,11,244,15,252,0,0,0,11,240,63,240,0,0,0,11,240,255,192,0,0,0,11,240,63,0,0,0,0,15,240,4,0,0,0,0,15,240,0,0,0,0,0,15,224,0,0,0,0,0,31,208,0,0,0,0,0,63,192,0,0,0,0,0,191,128,0,0,0,0,0,255,0,0,0,0,0,3,254,0,0,0,0,0,31,252,0,0,0,0,0,191,240,0,0,0,0,7,255,192,0,0,0,0,2,255,0,0,0,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30a2  ア
  162,48,32,31,248,38,4,253,127,170,170,170,170,170,170,224,127,255,255,255,255,255,255,252,127,255,255,255,255,255,255,254,127,255,255,255,255,255,255,252,0,0,0,0,0,0,31,240,0,0,0,0,0,0,63,224,0,0,0,0,0,0,255,192,0,0,0,85,0,2,255,0,0,0,0,255,64,11,253,0,0,0,0,255,64,47,248,0,0,0,0,191,64,191,224,0,0,0,0,191,67,255,192,0,0,0,0,255,71,255,0,0,0,0,0,255,1,248,0,0,0,0,0,255,0,16,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,2,254,0,0,0,0,0,0,3,253,0,0,0,0,0,0,7,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,47,240,0,0,0,0,0,0,127,224,0,0,0,0,0,1,255,192,0,0,0,0,0,11,255,0,0,0,0,0,0,127,253,0,0,0,0,0,3,255,244,0,0,0,0,0,2,255,192,0,0,0,0,0,0,126,0,0,0,0,0,0,0,16,0,0,0,0,0,0,
  // 0x30a3  ィ
  163,48,26,27,189,38,4,252,0,0,0,0,0,2,0,0,0,0,0,0,15,192,0,0,0,0,0,63,240,0,0,0,0,0,255,224,0,0,0,0,7,255,128,0,0,0,0,47,253,0,0,0,0,0,255,244,0,0,0,0,7,255,192,0,0,0,0,63,254,0,0,0,0,2,255,244,0,0,0,0,127,255,224,0,0,0,7,255,255,224,0,0,1,191,255,239,224,0,0,127,255,253,31,224,0,0,63,255,128,31,224,0,0,47,244,0,31,224,0,0,14,0,0,31,224,0,0,0,0,0,31,224,0,0,0,0,0,31,224,0,0,0,0,0,31,224,0,0,0,0,0,31,224,0,0,0,0,0,31,224,0,0,0,0,0,31,224,0,0,0,0,0,31,224,0,0,0,0,0,31,224,0,0,0,0,0,31,224,0,0,0,0,0,31,224,0,0,
  // 0x30a4  イ
  164,48,30,31,248,38,3,254,0,0,0,0,0,0,15,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,255,240,0,0,0,0,0,3,255,192,0,0,0,0,0,31,255,0,0,0,0,0,0,127,252,0,0,0,0,0,2,255,224,0,0,0,0,0,31,255,64,0,0,0,0,0,191,252,0,0,0,0,0,7,255,224,0,0,0,0,0,127,255,64,0,0,0,0,7,255,255,0,0,0,0,0,191,255,255,0,0,0,0,27,255,254,255,0,0,0,6,255,255,208,255,0,0,0,191,255,253,0,255,0,0,0,191,255,144,0,255,0,0,0,63,244,0,0,255,0,0,0,46,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,
  // 0x30a5  ゥ
  165,48,25,29,203,38,7,251,0,0,5,80,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,224,0,0,0,0,0,15,224,0,0,0,149,85,95,245,85,104,0,255,255,255,255,255,255,128,255,255,255,255,255,255,192,255,255,255,255,255,255,128,254,0,0,0,0,255,64,254,0,0,0,0,255,0,254,0,0,0,0,255,0,254,0,0,0,1,254,0,254,0,0,0,3,253,0,254,0,0,0,3,252,0,254,0,0,0,11,252,0,0,0,0,0,15,244,0,0,0,0,0,47,240,0,0,0,0,0,127,208,0,0,0,0,1,255,192,0,0,0,0,7,255,0,0,0,0,0,47,253,0,0,0,0,1,255,244,0,0,0,0,47,255,208,0,0,0,27,255,255,0,0,0,0,15,255,244,0,0,0,0,3,255,64,0,0,0,0,1,224,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30a6  ウ
  166,48,29,34,16,38,5,253,0,0,1,170,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,0,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,128,255,170,170,170,170,170,255,64,254,0,0,0,0,0,255,0,254,0,0,0,0,1,255,0,254,0,0,0,0,2,255,0,254,0,0,0,0,3,254,0,254,0,0,0,0,3,253,0,254,0,0,0,0,7,252,0,254,0,0,0,0,15,248,0,255,0,0,0,0,15,244,0,169,0,0,0,0,47,240,0,0,0,0,0,0,63,224,0,0,0,0,0,0,191,192,0,0,0,0,0,2,255,128,0,0,0,0,0,7,255,0,0,0,0,0,0,31,252,0,0,0,0,0,0,191,244,0,0,0,0,0,3,255,224,0,0,0,0,0,47,255,64,0,0,0,0,2,255,253,0,0,0,0,1,191,255,244,0,0,0,0,3,255,255,64,0,0,0,0,1,255,248,0,0,0,0,0,0,191,64,0,0,0,0,0,0,16,0,0,0,0,0,
  // 0x30a7  ェ
  167,48,28,22,154,38,5,254,6,149,85,85,85,86,144,7,255,255,255,255,255,224,7,255,255,255,255,255,224,7,255,255,255,255,255,224,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,58,170,170,255,170,170,173,127,255,255,255,255,255,253,127,255,255,255,255,255,253,127,255,255,255,255,255,253,0,0,0,0,0,0,0,
  // 0x30a8  エ
  168,48,32,26,208,38,3,0,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,240,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
  // 0x30a9  ォ
  169,48,27,27,189,38,6,252,0,0,0,3,252,0,0,0,0,0,2,252,0,0,0,0,0,2,252,0,0,0,0,0,2,252,0,0,0,0,0,2,252,0,0,25,85,85,86,253,85,84,47,255,255,255,255,255,252,47,255,255,255,255,255,252,47,255,255,255,255,255,252,0,0,0,31,252,0,0,0,0,0,63,252,0,0,0,0,0,255,252,0,0,0,0,3,255,252,0,0,0,0,15,249,252,0,0,0,0,127,241,252,0,0,0,1,255,193,252,0,0,0,11,255,1,252,0,0,0,127,248,1,252,0,0,2,255,224,1,253,0,0,47,255,64,1,253,0,0,127,252,0,1,253,0,0,47,224,0,1,253,0,0,15,0,4,2,253,0,0,0,0,11,255,253,0,0,0,0,11,255,252,0,0,0,0,11,255,244,0,0,0,0,0,5,64,0,0,
  // 0x30aa  オ
  170,48,32,32,0,38,3,254,0,0,0,0,15,244,0,0,0,0,0,0,11,244,0,0,0,0,0,0,11,244,0,0,0,0,0,0,11,244,0,0,0,0,0,0,11,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,31,255,255,255,255,255,255,253,31,255,255,255,255,255,255,253,31,255,255,255,255,255,255,253,26,170,170,170,191,254,170,168,0,0,0,0,191,244,0,0,0,0,0,1,255,244,0,0,0,0,0,7,255,244,0,0,0,0,0,15,255,244,0,0,0,0,0,63,231,244,0,0,0,0,0,255,199,244,0,0,0,0,7,255,3,248,0,0,0,0,31,252,3,248,0,0,0,0,191,240,3,248,0,0,0,3,255,192,3,248,0,0,0,31,255,0,3,248,0,0,0,255,248,0,3,248,0,0,11,255,208,0,3,248,0,0,127,255,0,0,3,248,0,0,191,248,0,0,3,248,0,0,63,208,0,0,3,248,0,0,14,0,0,0,7,248,0,0,0,0,0,191,255,248,0,0,0,0,0,191,255,248,0,0,0,0,0,191,255,240,0,0,0,0,0,127,255,128,0,0,
  // 0x30ab  カ
  171,48,29,33,8,38,4,253,0,0,2,254,0,0,0,0,0,0,2,254,0,0,0,0,0,0,2,254,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,127,255,255,255,255,255,254,0,127,255,255,255,255,255,255,128,127,255,255,255,255,255,255,128,106,170,171,254,170,170,191,64,0,0,3,252,0,0,127,64,0,0,7,248,0,0,127,64,0,0,11,244,0,0,127,64,0,0,11,244,0,0,127,64,0,0,15,240,0,0,191,0,0,0,31,240,0,0,191,0,0,0,47,224,0,0,191,0,0,0,63,192,0,0,191,0,0,0,127,192,0,0,255,0,0,0,255,128,0,0,255,0,0,1,255,0,0,0,254,0,0,3,254,0,0,0,254,0,0,11,252,0,0,1,253,0,0,31,248,0,0,2,253,0,0,127,240,0,0,3,252,0,1,255,208,0,0,3,252,0,7,255,64,1,64,15,252,0,47,254,0,2,255,255,244,0,255,248,0,2,255,255,240,0,63,224,0,1,255,255,208,0,11,64,0,0,170,250,0,0,0,0,0,0,0,0,0,0,
  // 0x30ac  ガ
  172,48,33,35,59,38,3,253,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,252,0,0,0,1,170,0,0,112,190,0,0,0,1,255,0,1,252,63,0,0,0,1,255,0,0,189,31,128,0,0,1,254,0,0,63,15,192,0,0,1,254,0,0,47,69,0,0,0,1,254,0,0,15,64,0,0,0,1,254,0,0,0,0,0,58,170,170,255,170,170,168,0,0,63,255,255,255,255,255,255,128,0,63,255,255,255,255,255,255,192,0,63,255,255,255,255,255,255,192,0,0,0,3,252,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,3,248,0,0,63,128,0,0,0,7,248,0,0,63,128,0,0,0,11,244,0,0,127,128,0,0,0,15,240,0,0,127,64,0,0,0,31,240,0,0,127,64,0,0,0,47,224,0,0,127,64,0,0,0,63,192,0,0,191,0,0,0,0,127,192,0,0,191,0,0,0,0,255,64,0,0,255,0,0,0,2,255,0,0,0,255,0,0,0,3,254,0,0,0,254,0,0,0,15,252,0,0,0,254,0,0,0,63,244,0,0,1,253,0,0,0,191,224,0,0,3,253,0,0,3,255,192,0,0,7,252,0,0,31,255,0,1,255,255,252,0,0,191,252,0,1,255,255,244,0,0,63,240,0,1,255,255,224,0,0,15,128,0,0,255,255,64,0,0,1,0,0,0,0,0,0,0,0,
  // 0x30ad  キ
  173,48,30,33,8,38,4,253,0,0,6,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,244,0,0,0,0,0,0,11,244,0,0,0,0,0,0,7,248,0,0,16,0,0,0,3,252,0,91,248,0,0,0,3,253,191,255,248,0,0,0,107,255,255,255,252,0,106,255,255,255,255,255,232,0,255,255,255,255,254,80,0,0,255,255,255,255,0,0,0,0,191,250,64,255,0,0,0,0,100,0,0,255,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,127,128,0,0,0,0,0,0,63,192,0,22,224,0,0,0,63,193,111,255,240,0,0,0,63,255,255,255,240,0,1,111,255,255,255,255,240,90,255,255,255,255,255,164,0,255,255,255,255,249,64,0,0,255,255,255,159,240,0,0,0,191,249,64,15,240,0,0,0,100,0,0,11,244,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,254,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,64,0,0,0,
  // 0x30ae  ギ
  174,48,33,35,59,38,3,253,0,0,0,0,0,0,0,184,0,0,0,0,0,0,0,32,252,0,0,0,0,16,0,1,244,127,0,0,0,11,244,0,0,252,47,64,0,0,11,248,0,0,126,15,192,0,0,7,248,0,0,63,10,0,0,0,3,252,0,0,31,64,0,0,0,3,252,0,0,108,0,0,0,0,2,252,5,191,252,0,0,0,0,2,255,255,255,252,0,0,0,22,191,255,255,255,253,0,0,191,255,255,255,255,254,80,0,0,191,255,255,255,229,0,0,0,0,127,255,250,255,0,0,0,0,0,63,164,0,191,64,0,0,0,0,16,0,0,127,128,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,16,0,0,0,0,63,192,0,111,240,0,0,0,0,47,230,191,255,244,0,0,0,1,127,255,255,255,248,0,0,22,255,255,255,255,255,164,0,191,255,255,255,255,249,64,0,0,191,255,255,255,244,0,0,0,0,127,255,249,75,244,0,0,0,0,63,148,0,7,248,0,0,0,0,16,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,249,0,0,0,0,
  // 0x30af  ク
  175,48,31,34,16,38,3,253,0,0,0,41,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,127,208,0,0,0,0,0,0,255,192,0,0,0,0,0,1,255,64,0,0,0,0,0,3,255,0,0,1,0,0,0,11,255,255,255,255,128,0,0,31,255,255,255,255,244,0,0,63,255,255,255,255,240,0,0,255,213,85,85,127,224,0,2,255,64,0,0,63,208,0,11,254,0,0,0,191,192,0,47,252,0,0,0,255,128,0,191,240,0,0,1,255,64,3,255,192,0,0,2,255,0,31,255,0,0,0,3,253,0,127,248,0,0,0,11,252,0,31,224,0,0,0,31,244,0,3,64,0,0,0,63,240,0,0,0,0,0,0,191,208,0,0,0,0,0,1,255,128,0,0,0,0,0,3,255,0,0,0,0,0,0,15,253,0,0,0,0,0,0,63,244,0,0,0,0,0,1,255,224,0,0,0,0,0,11,255,128,0,0,0,0,0,47,254,0,0,0,0,0,2,255,248,0,0,0,0,0,31,255,208,0,0,0,0,2,255,255,0,0,0,0,0,127,255,244,0,0,0,0,0,63,255,128,0,0,0,0,0,15,248,0,0,0,0,0,0,2,128,0,0,0,0,0,
  // 0x30b0  グ
  176,48,35,36,68,38,2,252,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,5,31,192,0,0,0,56,0,0,63,11,208,0,0,0,127,208,0,47,131,240,0,0,0,191,192,0,15,194,244,0,0,0,255,64,0,7,224,224,0,0,2,255,0,0,3,240,0,0,0,7,253,0,0,5,128,0,0,0,15,255,255,255,255,128,0,0,0,47,255,255,255,255,240,0,0,0,127,255,255,255,255,240,0,0,0,255,213,85,85,191,208,0,0,3,255,0,0,0,191,192,0,0,15,252,0,0,0,255,128,0,0,63,244,0,0,0,255,64,0,0,255,208,0,0,2,255,0,0,7,255,128,0,0,3,253,0,0,47,253,0,0,0,11,252,0,0,191,244,0,0,0,15,248,0,0,47,192,0,0,0,47,240,0,0,6,0,0,0,0,127,208,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,2,255,64,0,0,0,0,0,0,11,254,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,127,253,0,0,0,0,0,0,7,255,240,0,0,0,0,0,0,47,255,192,0,0,0,0,0,7,255,254,0,0,0,0,0,0,191,255,240,0,0,0,0,0,0,127,255,64,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,2,64,0,0,0,0,0,0,
  // 0x30b1  ケ
  177,48,33,33,41,38,2,253,0,0,47,224,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,2,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,15,255,255,255,255,255,255,192,0,31,255,255,255,255,255,255,192,0,63,224,0,3,252,0,0,0,0,255,192,0,3,252,0,0,0,2,255,64,0,3,252,0,0,0,11,255,0,0,7,252,0,0,0,47,252,0,0,11,248,0,0,0,191,244,0,0,15,244,0,0,0,47,208,0,0,15,240,0,0,0,3,64,0,0,31,240,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,11,254,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,2,255,208,0,0,0,0,0,0,15,255,128,0,0,0,0,0,0,191,254,0,0,0,0,0,0,0,127,248,0,0,0,0,0,0,0,11,208,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  // 0x30b2  ゲ
  178,48,35,36,68,38,2,252,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,63,64,0,0,16,0,0,0,46,31,192,0,0,63,208,0,0,63,11,208,0,0,63,208,0,0,31,131,240,0,0,127,192,0,0,15,194,244,0,0,191,128,0,0,7,224,64,0,0,255,64,0,0,3,224,0,0,1,255,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,3,255,255,255,255,255,255,64,0,11,255,255,255,255,255,255,64,0,31,255,255,255,255,255,255,64,0,63,255,255,255,255,255,255,64,0,191,192,0,7,248,0,0,0,1,255,128,0,11,248,0,0,0,3,255,0,0,11,244,0,0,0,15,253,0,0,15,244,0,0,0,63,248,0,0,15,240,0,0,0,255,224,0,0,31,240,0,0,0,63,192,0,0,47,224,0,0,0,7,0,0,0,63,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,7,254,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,7,255,192,0,0,0,0,0,0,47,255,0,0,0,0,0,0,1,255,252,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,0,15,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30b3  コ
  179,48,27,28,196,38,6,254,191,255,255,255,255,255,248,191,255,255,255,255,255,248,191,255,255,255,255,255,248,191,255,255,255,255,255,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,255,255,255,255,255,255,248,0,0,0,0,0,11,248,0,0,0,0,0,11,248,0,0,0,0,0,0,0,
  // 0x30b4  ゴ
  180,48,31,36,32,38,5,253,0,0,0,0,0,0,1,0,0,0,0,0,0,4,15,192,0,0,0,0,0,62,15,208,0,0,0,0,0,63,67,240,0,0,0,0,0,31,194,248,0,0,0,0,0,11,208,252,0,0,0,0,0,3,240,64,0,0,0,0,0,2,64,0,191,255,255,255,255,255,248,0,191,255,255,255,255,255,248,0,191,255,255,255,255,255,248,0,191,255,255,255,255,255,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,255,255,255,255,255,255,248,0,255,255,255,255,255,255,248,0,255,255,255,255,255,255,248,0,255,255,255,255,255,255,248,0,0,0,0,0,0,7,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,1,84,0,
  // 0x30b5  サ
  181,48,33,33,41,38,2,253,0,0,170,0,0,15,240,0,0,0,0,255,0,0,15,240,0,0,0,0,255,0,0,15,240,0,0,0,0,255,0,0,15,240,0,0,0,0,255,0,0,15,240,0,0,0,0,255,0,0,15,240,0,0,0,0,255,0,0,15,240,0,0,0,0,255,0,0,15,240,0,0,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,186,170,255,170,170,175,250,170,192,0,0,255,0,0,15,240,0,0,0,0,255,0,0,15,240,0,0,0,0,255,0,0,15,224,0,0,0,0,255,0,0,15,224,0,0,0,0,255,0,0,15,224,0,0,0,0,255,0,0,31,224,0,0,0,0,255,0,0,31,208,0,0,0,0,255,0,0,47,208,0,0,0,0,255,0,0,63,192,0,0,0,0,85,0,0,63,192,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,11,253,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,11,255,192,0,0,0,0,0,0,191,255,0,0,0,0,0,0,0,191,248,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,9,0,0,0,0,0,
  // 0x30b6  ザ
  182,48,36,34,50,38,1,252,0,0,0,0,0,0,0,1,240,0,0,170,64,0,15,244,177,240,0,0,191,64,0,15,240,244,248,0,0,191,64,0,15,240,248,124,0,0,191,64,0,15,240,124,61,0,0,191,0,0,11,240,61,40,0,0,191,0,0,11,240,45,0,0,0,191,0,0,11,240,0,0,0,0,191,0,0,11,240,0,0,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,58,170,255,234,170,175,250,170,144,0,0,191,0,0,11,240,0,0,0,0,191,0,0,15,240,0,0,0,0,191,0,0,15,240,0,0,0,0,191,0,0,15,240,0,0,0,0,191,0,0,15,240,0,0,0,0,191,64,0,15,240,0,0,0,0,191,64,0,15,240,0,0,0,0,191,64,0,31,224,0,0,0,0,191,64,0,47,208,0,0,0,0,21,0,0,63,192,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,254,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,11,255,208,0,0,0,0,0,0,191,255,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,1,0,0,0,0,0,
  // 0x30b7  シ
  183,48,31,31,248,38,4,254,0,2,64,0,0,0,0,0,0,7,240,0,0,0,0,0,0,15,254,0,0,0,0,0,0,31,255,208,0,0,0,0,0,2,255,248,0,0,0,0,0,0,63,254,0,0,0,0,0,0,7,253,0,0,0,0,0,0,0,248,0,0,0,0,0,0,0,16,0,0,0,0,61,0,0,0,0,0,0,192,127,192,0,0,0,0,2,224,255,248,0,0,0,0,3,244,127,255,64,0,0,0,15,252,11,255,224,0,0,0,63,244,0,255,240,0,0,0,191,224,0,31,192,0,0,2,255,192,0,3,128,0,0,11,255,0,0,0,0,0,0,47,252,0,0,0,0,0,0,255,240,0,0,0,0,0,3,255,192,0,0,0,0,0,31,255,0,0,0,0,0,0,255,252,0,0,0,0,0,7,255,224,0,0,0,0,0,127,255,64,0,0,0,0,11,255,248,0,0,0,0,1,255,255,208,0,0,0,1,191,255,254,0,0,0,0,31,255,255,224,0,0,0,0,15,255,254,0,0,0,0,0,7,255,144,0,0,0,0,0,2,228,0,0,0,0,0,0,
  // 0x30b8  ジ
  184,48,33,32,32,38,3,254,0,0,0,0,0,0,1,176,0,0,0,128,0,0,0,2,248,0,0,3,248,0,0,11,192,253,0,0,11,255,64,0,11,224,127,0,0,11,255,224,0,3,240,63,64,0,1,255,253,0,1,252,15,192,0,0,47,255,64,0,253,9,0,0,0,3,255,0,0,126,0,0,0,0,0,188,0,0,32,0,0,0,0,0,4,0,0,0,0,0,30,0,0,0,0,0,0,96,0,63,224,0,0,0,0,0,240,0,191,253,0,0,0,0,2,252,0,47,255,128,0,0,0,7,253,0,7,255,244,0,0,0,31,252,0,0,127,244,0,0,0,63,240,0,0,15,224,0,0,0,255,208,0,0,1,192,0,0,3,255,128,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,127,248,0,0,0,0,0,0,2,255,224,0,0,0,0,0,0,15,255,128,0,0,0,0,0,0,127,253,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,47,255,192,0,0,0,0,0,6,255,253,0,0,0,0,0,1,191,255,240,0,0,0,0,1,111,255,255,64,0,0,0,0,15,255,255,244,0,0,0,0,0,7,255,254,64,0,0,0,0,0,3,255,208,0,0,0,0,0,0,1,228,0,0,0,0,0,0,0,
  // 0x30b9  ス
  185,48,30,30,240,38,4,253,3,255,255,255,255,255,208,0,3,255,255,255,255,255,248,0,3,255,255,255,255,255,244,0,3,255,255,255,255,255,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,128,0,0,0,0,0,1,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,11,252,0,0,0,0,0,0,15,244,0,0,0,0,0,0,63,224,0,0,0,0,0,0,191,192,0,0,0,0,0,1,255,64,0,0,0,0,0,7,255,0,0,0,0,0,0,15,255,64,0,0,0,0,0,63,255,224,0,0,0,0,0,255,255,248,0,0,0,0,7,255,95,254,0,0,0,0,31,253,7,255,128,0,0,0,191,244,1,255,224,0,0,3,255,208,0,127,244,0,0,47,255,0,0,31,253,0,1,255,252,0,0,7,255,64,31,255,224,0,0,2,255,192,255,255,64,0,0,0,191,240,255,252,0,0,0,0,63,240,63,208,0,0,0,0,15,192,13,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,
  // 0x30ba  ズ
  186,48,34,36,68,38,3,253,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,188,0,0,0,0,0,0,0,180,127,0,0,0,0,0,0,0,252,47,64,0,0,0,0,0,0,190,15,192,0,0,0,0,0,0,63,11,208,0,0,0,0,0,0,95,131,64,3,255,255,255,255,255,255,64,0,3,255,255,255,255,255,252,0,0,3,255,255,255,255,255,248,0,0,3,255,255,255,255,255,240,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,1,255,128,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,255,192,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,255,255,252,0,0,0,0,0,7,255,79,255,0,0,0,0,0,31,253,3,255,192,0,0,0,0,191,244,0,255,240,0,0,0,7,255,208,0,63,252,0,0,0,47,255,64,0,15,254,0,0,1,255,252,0,0,3,255,128,0,31,255,224,0,0,0,255,208,0,255,255,64,0,0,0,127,244,0,127,248,0,0,0,0,47,240,0,47,208,0,0,0,0,11,192,0,9,0,0,0,0,0,2,0,0,
  // 0x30bb  セ
  187,48,32,32,0,38,2,254,0,0,42,128,0,0,0,0,0,0,63,208,0,0,0,0,0,0,63,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,96,0,0,63,192,0,0,111,248,0,0,63,192,1,191,255,255,0,0,63,214,255,255,255,253,0,0,63,255,255,255,255,252,1,111,255,255,255,254,79,244,191,255,255,255,249,0,47,240,191,255,255,228,0,0,63,192,191,255,191,192,0,0,255,128,127,144,63,192,0,2,255,0,0,0,63,192,0,7,253,0,0,0,63,192,0,15,248,0,0,0,63,192,0,63,240,0,0,0,63,192,0,255,192,0,0,0,63,192,0,47,64,0,0,0,63,192,0,5,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,244,0,0,5,176,0,0,31,255,235,255,255,240,0,0,15,255,255,255,255,240,0,0,3,255,255,255,255,240,0,0,0,111,255,255,234,80,
  // 0x30bc  ゼ
  188,48,36,35,59,38,1,253,0,0,0,0,0,0,0,7,192,0,0,0,0,0,0,1,11,224,0,0,0,0,0,0,15,195,240,0,0,31,240,0,0,11,209,248,0,0,31,240,0,0,3,240,253,0,0,31,224,0,0,2,244,120,0,0,31,224,0,0,0,252,0,0,0,31,224,0,0,0,96,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,1,180,0,0,0,31,224,0,1,191,254,0,0,0,31,224,6,255,255,255,64,0,0,31,251,255,255,255,255,0,0,0,111,255,255,255,255,252,0,5,191,255,255,255,249,11,248,0,127,255,255,255,228,0,15,240,0,63,255,255,244,0,0,63,208,0,63,254,175,224,0,0,191,192,0,62,64,31,224,0,0,255,0,0,0,0,31,224,0,3,254,0,0,0,0,31,224,0,15,252,0,0,0,0,31,224,0,47,240,0,0,0,0,31,224,0,127,208,0,0,0,0,31,224,0,11,64,0,0,0,0,31,224,0,1,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,253,0,0,90,248,0,0,0,15,255,255,255,255,248,0,0,0,7,255,255,255,255,248,0,0,0,1,255,255,255,255,248,0,0,0,0,6,170,170,149,0,0,
  // 0x30bd  ソ
  189,48,29,30,240,38,4,254,0,0,0,0,0,0,64,0,7,64,0,0,0,0,255,128,127,192,0,0,0,0,255,64,127,224,0,0,0,1,255,0,47,244,0,0,0,1,255,0,15,252,0,0,0,2,254,0,7,253,0,0,0,3,253,0,3,255,0,0,0,3,252,0,1,255,128,0,0,7,252,0,0,255,192,0,0,15,248,0,0,63,240,0,0,15,244,0,0,47,244,0,0,47,240,0,0,15,208,0,0,63,224,0,0,10,0,0,0,127,192,0,0,0,0,0,0,255,128,0,0,0,0,0,2,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,15,252,0,0,0,0,0,0,63,244,0,0,0,0,0,0,191,224,0,0,0,0,0,2,255,192,0,0,0,0,0,11,255,0,0,0,0,0,0,47,253,0,0,0,0,0,1,255,244,0,0,0,0,0,11,255,208,0,0,0,0,0,127,255,64,0,0,0,0,7,255,252,0,0,0,0,0,11,255,224,0,0,0,0,0,1,254,0,0,0,0,0,0,0,116,0,0,0,0,0,
  // 0x30be  ゾ
  190,48,32,35,24,38,4,253,0,0,0,0,0,0,0,160,0,0,0,0,0,1,131,240,0,0,0,0,0,15,193,252,0,0,0,0,0,7,240,189,0,0,0,0,0,3,244,63,0,0,0,0,0,0,252,45,11,0,0,0,0,0,184,0,191,128,0,0,0,2,144,0,255,192,0,0,0,3,254,0,127,224,0,0,0,3,253,0,47,244,0,0,0,7,252,0,15,252,0,0,0,11,252,0,7,253,0,0,0,15,248,0,3,255,0,0,0,15,240,0,1,255,128,0,0,31,240,0,0,255,192,0,0,63,224,0,0,63,224,0,0,63,208,0,0,47,64,0,0,191,192,0,0,8,0,0,0,255,64,0,0,0,0,0,2,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,15,252,0,0,0,0,0,0,47,244,0,0,0,0,0,0,127,240,0,0,0,0,0,1,255,192,0,0,0,0,0,7,255,64,0,0,0,0,0,31,254,0,0,0,0,0,0,191,248,0,0,0,0,0,3,255,224,0,0,0,0,0,31,255,128,0,0,0,0,1,255,253,0,0,0,0,0,31,255,240,0,0,0,0,0,15,255,128,0,0,0,0,0,3,253,0,0,0,0,0,0,0,144,0,0,0,0,0,
  // 0x30bf  タ
  191,48,31,34,16,38,3,253,0,0,0,46,64,0,0,0,0,0,0,63,224,0,0,0,0,0,0,127,192,0,0,0,0,0,0,255,128,0,0,0,0,0,2,255,0,0,0,0,0,0,3,255,85,85,90,0,0,0,15,255,255,255,255,224,0,0,47,255,255,255,255,244,0,0,127,255,255,255,255,240,0,0,255,192,0,0,63,224,0,3,255,0,0,0,127,192,0,15,253,0,0,0,191,192,0,63,244,0,0,0,255,64,0,255,224,0,0,1,255,0,3,255,128,176,0,3,254,0,31,254,2,254,0,11,252,0,191,244,7,255,192,15,248,0,63,208,1,255,248,63,240,0,11,0,0,63,255,191,208,0,0,0,0,7,255,255,192,0,0,0,0,0,255,255,0,0,0,0,0,0,47,255,64,0,0,0,0,0,47,255,224,0,0,0,0,0,191,255,248,0,0,0,0,2,255,239,254,0,0,0,0,15,255,11,252,0,0,0,0,127,252,1,244,0,0,0,3,255,240,0,80,0,0,0,47,255,128,0,0,0,0,6,255,253,0,0,0,0,0,191,255,224,0,0,0,0,0,191,255,64,0,0,0,0,0,47,244,0,0,0,0,0,0,6,64,0,0,0,0,0,
  // 0x30c0  ダ
  192,48,35,37,77,38,2,252,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,47,64,0,0,0,0,0,0,10,15,192,0,0,0,63,128,0,63,11,224,0,0,0,127,208,0,31,195,240,0,0,0,255,192,0,11,209,244,0,0,1,255,64,0,3,240,64,0,0,3,254,0,0,3,224,0,0,0,11,255,255,255,255,192,0,0,0,15,255,255,255,255,244,0,0,0,63,255,255,255,255,240,0,0,0,191,213,85,85,127,224,0,0,2,255,64,0,0,63,192,0,0,7,254,0,0,0,191,192,0,0,31,252,0,0,0,255,128,0,0,127,240,0,0,1,255,0,0,2,255,192,0,0,3,254,0,0,11,255,0,248,0,7,253,0,0,63,252,3,255,64,15,248,0,0,191,240,7,255,224,31,240,0,0,31,128,0,191,252,63,224,0,0,5,0,0,31,255,255,192,0,0,0,0,0,3,255,255,64,0,0,0,0,0,0,191,255,0,0,0,0,0,0,0,47,255,128,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,255,255,252,0,0,0,0,0,7,255,175,254,0,0,0,0,0,47,254,7,252,0,0,0,0,0,255,248,0,240,0,0,0,0,11,255,208,0,0,0,0,0,0,127,255,64,0,0,0,0,0,7,255,252,0,0,0,0,0,0,191,255,208,0,0,0,0,0,0,191,254,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,
  // 0x30c1  チ
  193,48,32,32,0,38,3,253,0,0,0,0,0,6,244,0,0,0,0,0,22,255,252,0,1,85,90,175,255,255,254,0,2,255,255,255,255,255,249,0,1,255,255,255,255,228,0,0,0,255,255,239,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,248,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,175,254,170,170,170,0,0,0,11,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,47,224,0,0,0,0,0,0,63,208,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,128,0,0,0,0,0,3,255,0,0,0,0,0,0,11,253,0,0,0,0,0,0,63,248,0,0,0,0,0,1,255,240,0,0,0,0,0,11,255,192,0,0,0,0,0,31,255,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,64,0,0,0,0,0,
  // 0x30c2  ヂ
  194,48,34,33,41,38,2,252,0,0,0,0,0,0,176,0,0,0,0,0,0,0,111,248,0,0,0,0,0,22,191,255,253,0,0,2,255,255,255,255,255,254,0,0,1,255,255,255,255,254,64,31,0,0,255,255,255,253,0,5,31,128,0,165,84,7,248,0,63,11,192,0,0,0,7,248,0,31,131,240,0,0,0,7,248,0,11,194,240,0,0,0,7,248,0,3,224,64,0,0,0,7,248,0,2,208,0,0,0,0,7,248,0,0,0,0,170,170,170,171,254,170,170,170,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,2,255,64,0,0,0,0,0,0,7,254,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,191,244,0,0,0,0,0,0,7,255,208,0,0,0,0,0,0,47,255,64,0,0,0,0,0,0,11,253,0,0,0,0,0,0,0,1,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30c3  ッ
  195,48,27,25,175,38,6,252,0,0,11,192,0,0,0,0,0,47,208,0,11,144,31,64,15,240,0,15,244,127,128,15,240,0,15,240,63,192,7,248,0,31,240,47,224,3,252,0,47,224,15,240,2,253,0,63,192,11,244,1,254,0,63,192,7,248,0,228,0,191,128,3,252,0,0,0,255,0,2,248,0,0,2,254,0,0,64,0,0,3,252,0,0,0,0,0,15,248,0,0,0,0,0,31,240,0,0,0,0,0,127,208,0,0,0,0,1,255,128,0,0,0,0,7,255,0,0,0,0,0,47,252,0,0,0,0,0,255,240,0,0,0,0,11,255,192,0,0,0,0,191,254,0,0,0,0,31,255,248,0,0,0,0,31,255,192,0,0,0,0,7,253,0,0,0,0,0,1,208,0,0,0,0,
  // 0x30c4  ツ
  196,48,32,31,248,38,3,254,0,0,0,4,0,0,0,0,0,0,1,252,0,0,0,0,0,0,3,253,0,0,3,144,27,64,1,255,0,0,3,254,191,192,0,255,64,0,7,253,63,192,0,191,128,0,7,252,47,224,0,63,192,0,11,248,31,240,0,63,208,0,15,244,15,244,0,31,240,0,31,240,7,252,0,15,240,0,47,240,3,253,0,11,240,0,63,208,2,254,0,6,64,0,127,192,1,255,0,0,0,0,255,128,0,254,0,0,0,0,255,0,0,80,0,0,0,2,254,0,0,0,0,0,0,7,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,47,240,0,0,0,0,0,0,191,208,0,0,0,0,0,1,255,192,0,0,0,0,0,7,255,0,0,0,0,0,0,31,252,0,0,0,0,0,0,191,244,0,0,0,0,0,3,255,208,0,0,0,0,0,47,255,64,0,0,0,0,1,255,252,0,0,0,0,0,47,255,240,0,0,0,0,7,255,255,64,0,0,0,0,3,255,248,0,0,0,0,0,0,255,144,0,0,0,0,0,0,56,0,0,0,0,0,
  // 0x30c5  ヅ
  197,48,34,35,59,38,3,253,0,0,0,0,0,0,0,108,0,0,0,0,0,0,0,176,190,0,0,0,0,0,0,2,248,63,64,0,0,0,0,0,0,252,31,192,0,0,0,16,0,0,127,11,208,0,0,6,244,0,0,63,67,64,0,0,7,252,0,0,30,0,0,46,0,3,252,0,0,0,0,0,255,0,2,254,0,0,14,64,0,255,128,0,255,0,0,15,244,0,127,192,0,255,64,0,31,240,0,63,208,0,127,128,0,47,240,0,47,240,0,63,192,0,63,208,0,15,240,0,47,208,0,63,192,0,11,248,0,31,224,0,191,192,0,7,252,0,9,0,0,255,64,0,3,253,0,0,0,1,255,0,0,2,253,0,0,0,3,254,0,0,0,64,0,0,0,7,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,255,192,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,253,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,1,255,224,0,0,0,0,0,0,11,255,128,0,0,0,0,0,0,127,254,0,0,0,0,0,0,7,255,244,0,0,0,0,0,0,127,255,208,0,0,0,0,0,11,255,254,0,0,0,0,0,0,11,255,244,0,0,0,0,0,0,2,255,64,0,0,0,0,0,0,0,180,0,0,0,0,0,0,
  // 0x30c6  テ
  198,48,32,31,248,38,3,253,0,63,255,255,255,255,255,0,0,63,255,255,255,255,255,0,0,63,255,255,255,255,255,0,0,42,170,170,170,170,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,170,170,170,170,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,0,0,0,3,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,15,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,224,0,0,0,0,0,0,63,208,0,0,0,0,0,0,127,192,0,0,0,0,0,0,255,128,0,0,0,0,0,3,255,0,0,0,0,0,0,15,253,0,0,0,0,0,0,127,248,0,0,0,0,0,2,255,224,0,0,0,0,0,15,255,128,0,0,0,0,0,2,253,0,0,0,0,0,0,0,96,0,0,0,0,0,
  // 0x30c7  デ
  199,48,34,37,77,38,3,252,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,45,31,128,0,0,0,0,0,0,63,15,208,0,0,0,0,0,0,47,131,240,0,191,255,255,255,255,207,194,240,0,191,255,255,255,255,199,224,64,0,191,255,255,255,255,195,144,0,0,106,170,170,170,170,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,254,0,234,170,170,175,254,170,170,169,0,0,0,0,11,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,1,255,64,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,253,0,0,0,0,0,0,0,127,248,0,0,0,0,0,0,2,255,224,0,0,0,0,0,0,31,255,128,0,0,0,0,0,0,15,253,0,0,0,0,0,0,0,2,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30c8  ト
  200,48,21,31,186,38,12,254,255,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,224,0,0,0,0,191,255,128,0,0,0,191,255,254,0,0,0,191,255,255,244,0,0,191,191,255,255,128,0,191,65,255,255,249,0,191,64,11,255,255,64,191,64,0,127,255,0,191,64,0,6,254,0,191,64,0,0,44,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,255,128,0,0,0,0,
  // 0x30c9  ド
  201,48,23,32,192,38,11,253,85,0,0,0,9,0,255,64,0,0,63,0,255,64,0,40,47,192,255,64,0,253,15,208,255,64,0,127,7,240,255,64,0,47,130,244,255,64,0,15,192,128,255,64,0,11,224,0,255,64,0,2,64,0,255,64,0,0,0,0,255,64,0,0,0,0,255,248,0,0,0,0,255,255,224,0,0,0,255,255,255,64,0,0,255,255,255,249,0,0,255,95,255,255,208,0,255,64,191,255,254,0,255,64,6,255,255,0,255,64,0,47,254,0,255,64,0,1,252,0,255,64,0,0,24,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,170,64,0,0,0,0,
  // 0x30ca  ナ
  202,48,32,33,8,38,3,253,0,0,0,6,168,0,0,0,0,0,0,7,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,127,255,255,255,255,255,255,255,127,255,255,255,255,255,255,255,127,255,255,255,255,255,255,255,127,255,255,255,255,255,255,255,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,11,248,0,0,0,0,0,0,15,248,0,0,0,0,0,0,15,244,0,0,0,0,0,0,31,240,0,0,0,0,0,0,63,224,0,0,0,0,0,0,127,208,0,0,0,0,0,0,255,192,0,0,0,0,0,2,255,64,0,0,0,0,0,11,255,0,0,0,0,0,0,47,252,0,0,0,0,0,0,191,244,0,0,0,0,0,7,255,208,0,0,0,0,0,47,255,64,0,0,0,0,0,31,253,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,64,0,0,0,0,0,
  // 0x30cb  ニ
  203,48,31,25,200,38,3,0,1,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,1,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,0,0,0,0,0,0,84,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,0,0,0,0,0,0,0,0,
  // 0x30cc  ヌ
  204,48,27,30,210,38,5,253,15,234,170,170,170,191,128,15,255,255,255,255,255,240,15,255,255,255,255,255,244,15,255,255,255,255,255,240,0,0,0,0,0,63,208,0,0,0,0,0,127,192,0,0,0,0,0,191,192,0,0,0,0,0,255,64,0,0,0,0,1,255,0,0,46,0,0,3,254,0,0,191,208,0,7,252,0,0,255,252,0,15,248,0,0,47,255,128,31,240,0,0,7,255,240,63,224,0,0,0,127,254,191,192,0,0,0,15,255,255,128,0,0,0,2,255,255,0,0,0,0,0,127,254,0,0,0,0,0,63,255,192,0,0,0,1,255,255,244,0,0,0,7,255,255,254,0,0,0,47,254,15,255,128,0,0,255,248,2,255,240,0,11,255,224,0,191,244,0,191,255,64,0,31,224,11,255,252,0,0,7,192,255,255,224,0,0,1,0,191,254,0,0,0,0,0,47,244,0,0,0,0,0,10,0,0,0,0,0,0,
  // 0x30cd  ネ
  205,48,33,34,50,38,3,253,0,0,0,10,164,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,7,255,255,255,255,255,253,0,0,7,255,255,255,255,255,255,64,0,7,255,255,255,255,255,255,128,0,6,170,170,170,170,175,254,0,0,0,0,0,0,0,47,248,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,7,255,128,0,0,0,0,0,0,63,254,0,0,0,0,0,0,2,255,244,3,128,0,0,0,0,47,255,240,15,244,0,0,0,7,255,255,240,47,255,0,0,1,191,255,239,240,11,255,224,0,111,255,254,15,240,1,255,253,0,255,255,224,15,240,0,47,255,64,127,253,0,15,240,0,7,255,0,47,128,0,15,240,0,0,188,0,4,0,0,15,240,0,0,20,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,10,160,0,0,0,0,
  // 0x30ce  ノ
  206,48,26,30,210,38,5,254,0,0,0,0,0,41,0,0,0,0,0,0,63,240,0,0,0,0,0,127,208,0,0,0,0,0,191,192,0,0,0,0,0,255,192,0,0,0,0,0,255,64,0,0,0,0,2,255,0,0,0,0,0,3,254,0,0,0,0,0,7,252,0,0,0,0,0,15,252,0,0,0,0,0,31,244,0,0,0,0,0,47,240,0,0,0,0,0,127,208,0,0,0,0,0,255,192,0,0,0,0,2,255,64,0,0,0,0,7,255,0,0,0,0,0,15,252,0,0,0,0,0,63,244,0,0,0,0,0,255,224,0,0,0,0,3,255,192,0,0,0,0,15,255,0,0,0,0,0,127,252,0,0,0,0,2,255,240,0,0,0,0,31,255,192,0,0,0,1,255,254,0,0,0,0,31,255,244,0,0,0,0,255,255,192,0,0,0,0,63,254,0,0,0,0,0,15,224,0,0,0,0,0,2,0,0,0,0,0,0,
  // 0x30cf  ハ
  207,48,33,27,243,38,3,0,0,0,16,0,0,40,0,0,0,0,0,63,128,3,252,0,0,0,0,0,127,192,3,254,0,0,0,0,0,127,192,1,255,0,0,0,0,0,191,128,0,255,128,0,0,0,0,255,64,0,127,192,0,0,0,0,255,0,0,63,224,0,0,0,1,255,0,0,31,240,0,0,0,2,254,0,0,15,244,0,0,0,3,253,0,0,11,252,0,0,0,3,252,0,0,3,253,0,0,0,7,252,0,0,3,254,0,0,0,15,244,0,0,1,255,0,0,0,15,240,0,0,0,255,64,0,0,47,240,0,0,0,191,192,0,0,63,208,0,0,0,127,192,0,0,127,192,0,0,0,63,224,0,0,255,128,0,0,0,47,240,0,1,255,0,0,0,0,31,244,0,3,254,0,0,0,0,15,248,0,11,253,0,0,0,0,11,252,0,15,252,0,0,0,0,7,253,0,63,244,0,0,0,0,3,254,0,127,224,0,0,0,0,3,255,0,255,192,0,0,0,0,1,255,64,191,128,0,0,0,0,0,255,64,11,0,0,0,0,0,0,144,0,
  // 0x30d0  バ
  208,48,35,32,32,38,2,255,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,31,128,0,0,0,0,0,0,47,15,208,0,0,0,0,0,0,47,131,240,0,0,0,0,0,0,15,194,244,0,0,0,0,0,24,7,224,224,0,0,47,208,2,254,3,240,0,0,0,47,224,1,255,1,128,0,0,0,63,208,0,255,128,0,0,0,0,63,192,0,127,192,0,0,0,0,127,192,0,63,224,0,0,0,0,191,128,0,31,240,0,0,0,0,255,64,0,15,248,0,0,0,0,255,0,0,11,252,0,0,0,1,255,0,0,3,253,0,0,0,2,254,0,0,2,255,0,0,0,3,253,0,0,1,255,0,0,0,7,252,0,0,0,255,128,0,0,11,248,0,0,0,127,192,0,0,15,244,0,0,0,63,208,0,0,31,240,0,0,0,63,240,0,0,63,224,0,0,0,31,240,0,0,127,192,0,0,0,15,244,0,0,255,128,0,0,0,15,252,0,1,255,64,0,0,0,7,252,0,3,255,0,0,0,0,3,253,0,11,253,0,0,0,0,3,255,0,15,252,0,0,0,0,2,255,0,63,244,0,0,0,0,0,255,64,191,224,0,0,0,0,0,255,192,127,192,0,0,0,0,0,191,128,6,64,0,0,0,0,0,100,0,
  // 0x30d1  パ
  209,48,35,33,41,38,2,254,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,3,255,224,0,0,0,0,0,0,7,209,244,0,0,0,0,0,0,15,64,120,0,0,0,0,0,0,15,0,124,0,0,0,0,0,24,15,64,120,0,0,47,208,2,254,7,209,244,0,0,47,224,1,255,3,255,224,0,0,63,208,0,255,128,127,64,0,0,63,192,0,127,192,0,0,0,0,127,192,0,63,224,0,0,0,0,191,128,0,31,240,0,0,0,0,191,64,0,15,244,0,0,0,0,255,0,0,11,252,0,0,0,1,255,0,0,3,253,0,0,0,2,254,0,0,2,254,0,0,0,3,253,0,0,1,255,0,0,0,3,252,0,0,0,255,128,0,0,11,252,0,0,0,191,192,0,0,15,244,0,0,0,63,208,0,0,31,240,0,0,0,63,224,0,0,63,224,0,0,0,47,240,0,0,63,208,0,0,0,15,244,0,0,191,192,0,0,0,15,248,0,0,255,64,0,0,0,11,252,0,2,255,0,0,0,0,3,253,0,7,254,0,0,0,0,3,254,0,15,252,0,0,0,0,2,255,0,47,244,0,0,0,0,1,255,64,63,240,0,0,0,0,0,255,128,255,208,0,0,0,0,0,255,192,31,128,0,0,0,0,0,189,0,0,0,0,0,0,0,0,0,0,
  // 0x30d2  ヒ
  210,48,25,31,217,38,8,255,85,64,0,0,0,0,0,255,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,184,0,191,64,0,0,7,252,0,191,64,0,1,191,253,0,191,64,0,47,255,254,0,191,64,27,255,255,208,0,191,70,255,255,249,0,0,191,255,255,255,64,0,0,191,255,255,208,0,0,0,191,255,228,0,0,0,0,191,249,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,128,0,0,0,0,0,127,228,0,0,1,107,128,63,255,255,255,255,255,128,47,255,255,255,255,255,128,11,255,255,255,255,255,128,0,107,255,255,254,165,0,
  // 0x30d3  ビ
  211,48,29,34,16,38,6,254,0,0,0,0,0,0,36,0,0,0,0,0,0,0,252,0,0,0,0,0,0,180,190,0,106,128,0,0,1,252,63,0,127,192,0,0,0,189,31,128,63,192,0,0,0,63,15,192,63,192,0,0,0,47,129,0,63,192,0,0,0,15,64,0,63,192,0,0,0,4,0,0,63,192,0,0,0,124,0,0,63,192,0,0,7,252,0,0,63,192,0,1,191,254,0,0,63,192,0,47,255,254,0,0,63,192,27,255,255,224,0,0,63,198,255,255,253,0,0,0,63,255,255,255,128,0,0,0,63,255,255,224,0,0,0,0,63,255,244,0,0,0,0,0,63,249,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,244,0,0,0,91,208,0,47,255,255,255,255,255,208,0,15,255,255,255,255,255,208,0,3,255,255,255,255,255,208,0,0,107,255,255,255,169,64,0,
  // 0x30d4  ピ
  212,48,30,33,8,38,6,254,0,0,0,0,0,1,253,0,0,0,0,0,0,11,255,128,42,128,0,0,0,31,71,208,127,192,0,0,0,61,1,224,63,192,0,0,0,60,0,240,63,192,0,0,0,61,1,224,63,192,0,0,0,31,71,208,63,192,0,0,0,15,255,128,63,192,0,0,0,125,253,0,63,192,0,0,7,252,0,0,63,192,0,0,191,254,0,0,63,192,0,31,255,255,0,0,63,192,11,255,255,224,0,0,63,198,255,255,253,0,0,0,63,255,255,255,128,0,0,0,63,255,255,228,0,0,0,0,63,255,248,0,0,0,0,0,63,249,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,244,0,0,0,91,208,0,47,255,255,255,255,255,208,0,15,255,255,255,255,255,208,0,3,255,255,255,255,255,208,0,0,107,255,255,255,169,64,0,
  // 0x30d5  フ
  213,48,28,30,210,38,5,253,191,255,255,255,255,255,240,191,255,255,255,255,255,254,191,255,255,255,255,255,255,191,255,255,255,255,255,254,0,0,0,0,0,3,253,0,0,0,0,0,7,252,0,0,0,0,0,7,252,0,0,0,0,0,11,248,0,0,0,0,0,15,244,0,0,0,0,0,31,240,0,0,0,0,0,47,224,0,0,0,0,0,63,208,0,0,0,0,0,191,192,0,0,0,0,0,255,64,0,0,0,0,2,255,0,0,0,0,0,7,254,0,0,0,0,0,15,252,0,0,0,0,0,63,244,0,0,0,0,0,255,224,0,0,0,0,3,255,192,0,0,0,0,31,255,0,0,0,0,0,191,252,0,0,0,0,7,255,240,0,0,0,0,127,255,192,0,0,0,27,255,254,0,0,0,0,255,255,244,0,0,0,0,191,255,64,0,0,0,0,47,244,0,0,0,0,0,10,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30d6  ブ
  214,48,33,36,68,38,4,253,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,129,248,0,0,0,0,0,0,11,208,252,0,0,0,0,0,0,3,240,127,0,0,0,0,0,0,2,248,63,64,0,0,0,0,0,0,252,31,128,0,0,0,0,0,0,190,9,0,191,255,255,255,255,255,248,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,191,255,255,255,255,255,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,254,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,7,255,128,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,255,252,0,0,0,0,0,0,11,255,224,0,0,0,0,0,1,191,255,128,0,0,0,0,0,111,255,253,0,0,0,0,0,0,255,255,224,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
  // 0x30d7  プ
  215,48,34,35,59,38,4,253,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,62,11,192,0,0,0,0,0,0,60,3,192,0,0,0,0,0,0,120,2,208,0,0,0,0,0,0,124,3,192,127,255,255,255,255,255,254,11,192,127,255,255,255,255,255,255,255,0,127,255,255,255,255,255,255,248,0,127,255,255,255,255,255,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,254,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,7,255,192,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,191,252,0,0,0,0,0,0,11,255,224,0,0,0,0,0,1,191,255,128,0,0,0,0,0,111,255,253,0,0,0,0,0,0,255,255,224,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
  // 0x30d8  ヘ
  216,48,34,24,216,38,2,0,0,0,0,189,0,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,63,255,252,0,0,0,0,0,0,191,255,255,0,0,0,0,0,1,255,130,255,192,0,0,0,0,7,254,0,191,240,0,0,0,0,15,252,0,47,252,0,0,0,0,63,240,0,15,254,0,0,0,0,255,208,0,3,255,128,0,0,2,255,128,0,0,255,224,0,0,11,255,0,0,0,63,248,0,0,47,252,0,0,0,31,253,0,0,191,244,0,0,0,7,255,64,0,63,224,0,0,0,2,255,208,0,15,192,0,0,0,0,191,240,0,7,64,0,0,0,0,63,252,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,1,255,240,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,15,0,0,0,0,0,0,0,0,0,0,
  // 0x30d9  ベ
  217,48,34,29,5,38,2,255,0,0,0,0,0,0,0,96,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,1,129,252,0,0,0,0,0,0,15,208,190,0,0,0,0,100,0,7,240,63,64,0,0,3,255,64,2,248,47,192,0,0,15,255,208,0,252,15,64,0,0,63,255,244,0,190,0,0,0,0,191,255,253,0,61,0,0,0,2,255,135,255,64,0,0,0,0,7,254,1,255,208,0,0,0,0,15,252,0,127,240,0,0,0,0,63,240,0,31,252,0,0,0,0,191,208,0,11,255,0,0,0,2,255,128,0,2,255,192,0,0,11,255,0,0,0,191,240,0,0,47,252,0,0,0,63,248,0,0,191,244,0,0,0,15,254,0,0,255,224,0,0,0,3,255,128,0,63,192,0,0,0,1,255,208,0,15,64,0,0,0,0,191,244,0,2,0,0,0,0,0,47,253,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,1,255,224,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,47,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,
  // 0x30da  ペ
  218,48,34,29,5,38,2,255,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,191,252,0,0,0,0,0,0,1,248,126,0,0,0,0,0,0,3,224,15,0,0,0,0,184,0,3,192,15,64,0,0,3,255,64,3,192,15,64,0,0,15,255,208,3,208,15,0,0,0,63,255,244,1,244,127,0,0,0,191,255,253,0,191,252,0,0,2,255,135,255,64,31,224,0,0,7,254,1,255,208,0,0,0,0,15,252,0,127,240,0,0,0,0,63,240,0,31,252,0,0,0,0,191,208,0,11,255,0,0,0,2,255,128,0,2,255,192,0,0,11,255,0,0,0,191,240,0,0,47,252,0,0,0,63,248,0,0,191,244,0,0,0,15,254,0,0,255,224,0,0,0,3,255,128,0,63,192,0,0,0,1,255,208,0,15,64,0,0,0,0,191,244,0,2,0,0,0,0,0,47,253,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,1,255,224,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,47,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,
  // 0x30db  ホ
  219,48,33,32,32,38,3,254,0,0,0,11,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,62,170,170,175,254,170,170,173,0,63,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,253,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,5,0,7,244,0,20,0,0,0,15,208,7,244,1,252,0,0,0,31,240,7,244,2,255,0,0,0,63,208,7,244,0,255,128,0,0,191,128,7,244,0,127,208,0,1,255,0,7,244,0,47,240,0,3,253,0,7,244,0,15,244,0,15,252,0,7,244,0,7,252,0,47,240,0,7,244,0,3,254,0,191,208,0,7,244,0,1,255,0,255,128,0,7,244,0,0,255,64,63,0,0,7,244,0,0,60,0,4,0,0,7,244,0,0,16,0,0,0,0,11,244,0,0,0,0,0,0,62,175,244,0,0,0,0,0,0,63,255,244,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,47,255,128,0,0,0,0,
  // 0x30dc  ボ
  220,48,35,34,50,38,2,253,0,0,0,0,0,0,0,47,0,0,0,0,2,168,0,125,31,128,0,0,0,3,252,0,63,11,208,0,0,0,3,252,0,47,131,240,0,0,0,3,252,0,15,194,244,0,0,0,3,252,0,7,224,128,0,0,0,3,252,0,2,64,0,0,0,0,3,252,0,0,0,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,26,170,170,171,254,170,170,170,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,3,64,3,252,0,44,0,0,0,11,244,3,252,1,255,0,0,0,31,240,3,252,0,255,128,0,0,63,208,3,252,0,127,192,0,0,191,192,3,252,0,47,240,0,1,255,0,3,252,0,15,244,0,3,254,0,3,252,0,7,252,0,15,252,0,3,252,0,3,254,0,47,240,0,3,252,0,1,255,0,191,224,0,3,252,0,0,191,192,127,192,0,3,252,0,0,63,64,15,0,0,3,252,0,0,40,0,0,0,0,3,252,0,0,0,0,0,0,16,7,252,0,0,0,0,0,0,47,255,252,0,0,0,0,0,0,47,255,248,0,0,0,0,0,0,47,255,240,0,0,0,0,0,0,5,170,64,0,0,0,0,
  // 0x30dd  ポ
  221,48,34,36,68,38,2,253,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,47,7,192,0,0,0,3,252,0,61,2,208,0,0,0,3,252,0,60,2,224,0,0,0,3,252,0,60,2,208,0,0,0,3,252,0,47,7,192,0,0,0,3,252,0,15,255,64,0,0,0,3,252,0,2,253,0,0,0,0,3,252,0,0,0,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,26,170,170,171,254,170,170,170,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,3,64,3,252,0,44,0,0,0,11,244,3,252,1,255,0,0,0,31,240,3,252,0,255,128,0,0,63,208,3,252,0,127,192,0,0,191,192,3,252,0,47,240,0,1,255,0,3,252,0,15,244,0,3,254,0,3,252,0,7,252,0,15,252,0,3,252,0,3,254,0,47,240,0,3,252,0,1,255,0,191,224,0,3,252,0,0,191,192,127,192,0,3,252,0,0,63,64,15,0,0,3,252,0,0,40,0,0,0,0,3,252,0,0,0,0,0,0,16,7,252,0,0,0,0,0,0,47,255,252,0,0,0,0,0,0,47,255,248,0,0,0,0,0,0,47,255,240,0,0,0,0,0,0,5,170,64,0,0,0,0,
  // 0x30de  マ
  222,48,33,30,14,38,3,253,0,0,0,0,0,0,0,16,0,127,255,255,255,255,255,255,248,0,127,255,255,255,255,255,255,255,0,127,255,255,255,255,255,255,255,64,127,170,170,170,170,170,175,254,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,191,224,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,253,0,0,0,0,64,0,0,47,248,0,0,0,2,224,0,0,191,240,0,0,0,15,252,0,2,255,192,0,0,0,31,255,0,11,255,0,0,0,0,3,255,208,47,252,0,0,0,0,0,191,244,255,240,0,0,0,0,0,47,255,255,192,0,0,0,0,0,11,255,255,0,0,0,0,0,0,1,255,252,0,0,0,0,0,0,0,127,248,0,0,0,0,0,0,0,31,253,0,0,0,0,0,0,0,7,255,64,0,0,0,0,0,0,2,255,208,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,0,248,0,0,0,0,0,0,0,0,80,0,0,0,
  // 0x30df  ミ
  223,48,25,31,217,38,6,254,0,126,64,0,0,0,0,0,191,255,144,0,0,0,0,255,255,255,228,0,0,1,191,255,255,255,228,0,0,0,111,255,255,255,128,0,0,0,91,255,255,128,0,0,0,0,27,255,64,0,0,0,0,0,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,144,0,0,0,0,0,7,255,228,0,0,0,0,15,255,255,249,0,0,0,15,255,255,255,248,0,0,0,27,255,255,255,224,0,0,0,22,255,255,244,0,0,0,0,6,255,240,0,0,0,0,0,27,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,64,0,0,0,0,0,127,254,64,0,0,0,0,255,255,255,144,0,0,0,255,255,255,255,128,0,0,6,191,255,255,254,64,0,0,1,191,255,255,253,0,0,0,0,191,255,255,0,0,0,0,1,191,253,0,0,0,0,0,1,252,0,0,0,0,0,0,0,0,
  // 0x30e0  ム
  224,48,34,32,32,38,2,253,0,0,0,47,224,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,240,0,0,16,0,0,0,0,47,240,0,2,240,0,0,0,0,63,208,0,15,248,0,0,0,0,63,192,0,7,253,0,0,0,0,127,192,0,2,255,0,0,0,0,255,64,0,0,255,64,0,0,0,255,0,0,0,191,192,0,0,1,255,0,0,0,63,208,0,0,3,253,0,0,0,47,240,0,0,3,252,0,0,0,31,248,0,0,11,252,0,21,175,255,252,0,0,15,254,191,255,255,255,254,0,127,255,255,255,255,255,255,255,0,63,255,255,255,255,255,234,255,128,63,255,255,255,169,64,0,255,192,63,254,149,0,0,0,0,127,208,20,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,45,0,0,0,0,0,0,0,0,0,0,
  // 0x30e1  メ
  225,48,30,31,248,38,4,254,0,0,0,0,0,2,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,11,252,0,0,0,0,0,0,15,244,0,0,0,0,0,0,31,240,0,0,0,0,0,0,63,224,0,0,10,0,0,0,63,208,0,0,47,208,0,0,191,192,0,0,127,248,0,0,255,64,0,0,47,255,64,2,255,0,0,0,7,255,224,3,253,0,0,0,0,191,252,11,252,0,0,0,0,31,255,95,244,0,0,0,0,3,255,255,224,0,0,0,0,0,191,255,192,0,0,0,0,0,31,255,128,0,0,0,0,0,7,255,208,0,0,0,0,0,15,255,248,0,0,0,0,0,63,255,254,0,0,0,0,0,255,215,255,192,0,0,0,3,255,129,255,240,0,0,0,15,254,0,127,252,0,0,0,127,248,0,15,255,0,0,2,255,224,0,3,255,192,0,15,255,128,0,0,255,208,0,127,254,0,0,0,127,128,7,255,244,0,0,0,30,0,63,255,192,0,0,0,4,0,127,254,0,0,0,0,0,0,31,224,0,0,0,0,0,0,3,64,0,0,0,0,0,0,
  // 0x30e2  モ
  226,48,31,29,232,38,4,254,7,255,255,255,255,255,254,0,7,255,255,255,255,255,254,0,7,255,255,255,255,255,254,0,2,170,171,254,170,170,169,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,255,255,255,255,255,255,255,248,255,255,255,255,255,255,255,248,255,255,255,255,255,255,255,248,170,170,171,254,170,170,170,164,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,253,0,0,0,0,0,0,3,255,128,0,5,64,0,0,2,255,255,255,255,208,0,0,0,255,255,255,255,208,0,0,0,127,255,255,255,208,0,0,0,6,191,255,234,128,
  // 0x30e3  ャ
  227,48,28,28,196,38,5,251,0,1,176,0,0,0,0,0,15,240,0,0,0,0,0,11,244,0,0,0,0,0,3,248,0,0,0,0,0,3,252,0,0,6,248,0,2,252,0,27,255,255,0,1,254,111,255,255,254,0,6,255,255,255,255,252,43,255,255,255,250,75,244,127,255,255,249,0,31,240,63,255,255,128,0,63,192,63,144,63,192,0,255,64,0,0,47,192,2,254,0,0,0,31,208,11,252,0,0,0,15,224,47,240,0,0,0,15,240,47,208,0,0,0,11,244,2,64,0,0,0,7,248,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,2,253,0,0,0,0,0,1,254,0,0,0,0,0,0,255,0,0,0,0,0,0,255,64,0,0,0,0,0,127,128,0,0,0,0,0,127,192,0,0,0,0,0,62,64,0,0,0,0,0,0,0,0,0,
  // 0x30e4  ヤ
  228,48,33,33,41,38,2,253,0,0,109,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,0,255,0,0,0,0,4,0,0,0,191,128,0,0,6,254,0,0,0,127,192,0,91,255,255,192,0,0,63,193,175,255,255,255,128,0,0,63,255,255,255,255,255,0,0,27,255,255,255,255,147,254,0,191,255,255,255,254,64,11,252,0,191,255,255,249,0,0,31,240,0,127,255,239,244,0,0,63,224,0,63,144,11,248,0,0,255,192,0,0,0,3,252,0,2,255,0,0,0,0,3,253,0,11,253,0,0,0,0,2,254,0,47,248,0,0,0,0,1,255,0,191,224,0,0,0,0,0,255,0,127,192,0,0,0,0,0,255,64,7,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,1,64,0,0,0,0,
  // 0x30e5  ュ
  229,48,28,20,140,38,5,255,0,255,255,255,255,244,0,0,255,255,255,255,252,0,0,255,255,255,255,252,0,0,170,170,170,175,252,0,0,0,0,0,7,252,0,0,0,0,0,7,248,0,0,0,0,0,11,244,0,0,0,0,0,11,244,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,31,240,0,0,0,0,0,31,224,0,0,0,0,0,47,208,0,0,0,0,0,47,208,0,0,0,0,0,63,192,0,127,255,255,255,255,255,254,127,255,255,255,255,255,254,127,255,255,255,255,255,254,106,170,170,170,170,170,169,
  // 0x30e6  ユ
  230,48,32,26,208,38,3,0,0,255,255,255,255,255,208,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,248,0,0,0,0,0,0,15,248,0,0,0,0,0,0,15,244,0,0,0,0,0,0,15,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,47,224,0,0,0,0,0,0,47,224,0,0,0,0,0,0,63,208,0,0,0,0,0,0,63,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
  // 0x30e7  ョ
  231,48,22,25,150,38,8,252,85,85,85,85,85,80,191,255,255,255,255,224,191,255,255,255,255,224,191,255,255,255,255,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,21,85,85,85,95,224,63,255,255,255,255,224,63,255,255,255,255,224,63,255,255,255,255,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,255,255,255,255,255,224,255,255,255,255,255,224,255,255,255,255,255,224,170,85,85,85,111,224,0,0,0,0,15,224,0,0,0,0,0,0,
  // 0x30e8  ヨ
  232,48,27,29,203,38,5,254,42,170,170,170,170,170,168,63,255,255,255,255,255,252,63,255,255,255,255,255,252,63,255,255,255,255,255,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,10,170,170,170,170,171,252,11,255,255,255,255,255,252,11,255,255,255,255,255,252,11,255,255,255,255,255,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,126,170,170,170,170,175,252,127,255,255,255,255,255,252,127,255,255,255,255,255,252,127,255,255,255,255,255,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,
  // 0x30e9  ラ
  233,48,29,32,0,38,5,253,1,170,170,170,170,170,160,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,240,0,1,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,253,0,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,64,170,170,170,170,170,171,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,3,253,0,0,0,0,0,0,11,252,0,0,0,0,0,0,15,244,0,0,0,0,0,0,47,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,255,192,0,0,0,0,0,3,255,0,0,0,0,0,0,15,253,0,0,0,0,0,0,127,248,0,0,0,0,0,2,255,224,0,0,0,0,0,31,255,128,0,0,0,0,1,255,253,0,0,0,0,0,111,255,240,0,0,0,0,11,255,255,128,0,0,0,0,3,255,248,0,0,0,0,0,0,255,128,0,0,0,0,0,0,32,0,0,0,0,0,
  // 0x30ea  リ
  234,48,22,31,186,38,8,254,170,0,0,0,47,240,255,0,0,0,31,240,255,0,0,0,31,240,255,0,0,0,31,240,255,0,0,0,31,240,255,0,0,0,31,240,255,0,0,0,31,240,255,0,0,0,31,240,255,0,0,0,31,240,255,0,0,0,31,240,255,0,0,0,31,240,255,0,0,0,31,240,255,0,0,0,31,224,255,0,0,0,31,224,255,0,0,0,31,224,255,0,0,0,47,224,255,0,0,0,63,208,255,0,0,0,63,208,255,64,0,0,63,192,0,0,0,0,191,192,0,0,0,0,255,128,0,0,0,2,255,0,0,0,0,7,254,0,0,0,0,31,252,0,0,0,0,127,244,0,0,0,3,255,224,0,0,0,111,255,64,0,0,11,255,253,0,0,0,15,255,240,0,0,0,3,255,64,0,0,0,0,228,0,0,0,
  // 0x30eb  ル
  235,48,35,30,14,38,2,254,0,1,254,0,31,240,0,0,0,0,1,254,0,31,240,0,0,0,0,1,254,0,15,240,0,0,0,0,1,254,0,15,240,0,0,0,0,1,254,0,15,240,0,0,0,0,1,254,0,15,240,0,0,0,0,1,254,0,15,240,0,0,0,0,1,254,0,15,240,0,0,0,0,1,254,0,15,240,0,0,0,0,1,253,0,15,240,0,0,0,0,1,253,0,15,240,0,0,0,0,1,253,0,15,240,0,0,0,0,2,253,0,15,240,0,0,0,0,2,253,0,15,240,0,0,0,0,2,252,0,15,240,0,0,0,0,3,252,0,15,240,0,0,64,0,3,252,0,15,240,0,3,192,0,3,252,0,15,240,0,11,224,0,7,248,0,15,240,0,47,244,0,15,244,0,15,240,0,191,224,0,15,240,0,15,240,2,255,128,0,47,224,0,15,240,15,255,0,0,127,208,0,15,240,127,248,0,0,255,192,0,15,247,255,224,0,2,255,0,0,15,255,255,128,0,11,254,0,0,15,255,253,0,0,47,252,0,0,31,255,224,0,0,191,240,0,0,31,255,64,0,0,47,208,0,0,11,244,0,0,0,3,0,0,0,2,128,0,0,0,
  // 0x30ec  レ
  236,48,27,30,210,38,8,254,255,128,0,0,0,0,0,255,128,0,0,0,0,0,191,128,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,0,191,64,0,0,0,0,192,191,64,0,0,0,3,224,191,64,0,0,0,15,244,191,64,0,0,0,63,248,191,64,0,0,0,255,224,191,64,0,0,11,255,128,191,64,0,0,63,254,0,191,64,0,1,255,248,0,191,64,0,31,255,208,0,191,64,0,191,254,0,0,191,64,11,255,244,0,0,191,65,255,255,128,0,0,191,175,255,248,0,0,0,191,255,255,128,0,0,0,255,255,249,0,0,0,0,191,255,64,0,0,0,0,47,224,0,0,0,0,0,5,0,0,0,0,0,0,
  // 0x30ed  ロ
  237,48,28,28,196,38,5,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,0,0,0,0,0,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,191,255,255,255,255,255,255,255,255,255,255,255,255,255,255,64,0,0,0,0,255,255,64,0,0,0,0,255,0,0,0,0,0,0,0,
  // 0x30ee  ヮ
  238,48,25,26,182,38,7,251,149,85,85,85,85,168,0,255,255,255,255,255,255,64,255,255,255,255,255,255,128,255,255,255,255,255,255,64,255,0,0,0,0,255,0,255,0,0,0,0,255,0,255,0,0,0,1,255,0,255,0,0,0,1,254,0,255,0,0,0,2,253,0,255,0,0,0,3,252,0,255,0,0,0,7,252,0,255,0,0,0,11,248,0,0,0,0,0,15,240,0,0,0,0,0,47,240,0,0,0,0,0,127,208,0,0,0,0,0,255,128,0,0,0,0,3,255,0,0,0,0,0,15,253,0,0,0,0,0,127,244,0,0,0,0,2,255,224,0,0,0,0,47,255,64,0,0,0,7,255,253,0,0,0,0,31,255,224,0,0,0,0,7,255,64,0,0,0,0,1,244,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30ef  ワ
  239,48,30,30,240,38,4,253,126,170,170,170,170,170,254,0,127,255,255,255,255,255,255,192,63,255,255,255,255,255,255,224,63,255,255,255,255,255,255,192,63,192,0,0,0,0,127,192,63,192,0,0,0,0,191,192,63,192,0,0,0,0,191,128,63,192,0,0,0,0,255,128,63,192,0,0,0,0,255,64,63,192,0,0,0,0,255,0,63,192,0,0,0,1,255,0,63,192,0,0,0,3,254,0,127,192,0,0,0,3,253,0,127,192,0,0,0,7,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,31,244,0,0,0,0,0,0,63,240,0,0,0,0,0,0,191,208,0,0,0,0,0,2,255,192,0,0,0,0,0,7,255,0,0,0,0,0,0,31,253,0,0,0,0,0,0,191,248,0,0,0,0,0,3,255,224,0,0,0,0,0,47,255,64,0,0,0,0,2,255,253,0,0,0,0,0,111,255,244,0,0,0,0,2,255,255,128,0,0,0,0,0,191,252,0,0,0,0,0,0,47,128,0,0,0,0,0,0,4,0,0,0,0,0,
  // 0x30f0  ヰ
  240,48,32,33,8,38,3,253,0,0,0,0,0,85,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,26,170,170,170,170,255,170,168,31,255,255,255,255,255,255,252,31,255,255,255,255,255,255,252,31,255,255,255,255,255,255,252,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,0,0,255,0,0,255,0,0,186,170,255,170,170,255,170,175,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,85,0,0,
  // 0x30f1  ヱ
  241,48,33,27,243,38,3,255,15,255,255,255,255,255,255,248,0,15,255,255,255,255,255,255,254,0,15,255,255,255,255,255,255,252,0,15,250,170,170,170,170,191,244,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,208,0,0,0,0,21,64,0,255,128,0,0,0,0,63,224,2,255,0,0,0,0,0,63,224,15,252,0,0,0,0,0,47,208,63,244,0,0,0,0,0,47,208,255,224,0,0,0,0,0,47,208,127,128,0,0,0,0,0,47,208,14,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,
  // 0x30f2  ヲ
  242,48,28,30,210,38,6,253,255,255,255,255,255,255,240,255,255,255,255,255,255,253,255,255,255,255,255,255,254,250,170,170,170,170,171,252,0,0,0,0,0,7,252,0,0,0,0,0,7,248,0,0,0,0,0,11,244,0,0,0,0,0,15,244,0,0,0,0,0,15,240,0,0,0,0,0,31,240,63,255,255,255,255,255,224,63,255,255,255,255,255,192,63,255,255,255,255,255,192,42,170,170,170,170,255,128,0,0,0,0,0,255,0,0,0,0,0,2,254,0,0,0,0,0,7,252,0,0,0,0,0,15,248,0,0,0,0,0,63,240,0,0,0,0,0,255,208,0,0,0,0,3,255,128,0,0,0,0,31,254,0,0,0,0,0,127,248,0,0,0,0,7,255,224,0,0,0,0,127,255,128,0,0,0,27,255,252,0,0,0,0,255,255,224,0,0,0,0,127,254,0,0,0,0,0,31,224,0,0,0,0,0,5,0,0,0,0,0,
  // 0x30f3  ン
  243,48,30,30,240,38,5,254,2,128,0,0,0,0,0,0,11,240,0,0,0,0,0,0,31,253,0,0,0,0,0,0,31,255,64,0,0,0,0,0,3,255,224,0,0,0,0,0,0,191,252,0,0,0,0,0,0,31,255,0,0,0,1,64,0,7,255,192,0,0,3,192,0,0,255,192,0,0,11,224,0,0,63,0,0,0,15,240,0,0,12,0,0,0,63,240,0,0,0,0,0,0,191,208,0,0,0,0,0,1,255,128,0,0,0,0,0,7,255,0,0,0,0,0,0,31,253,0,0,0,0,0,0,127,244,0,0,0,0,0,1,255,224,0,0,0,0,0,11,255,128,0,0,0,0,0,63,254,0,0,0,0,0,1,255,248,0,0,0,0,0,11,255,208,0,0,0,0,0,191,255,0,0,0,0,0,11,255,248,0,0,0,0,1,255,255,208,0,0,0,1,191,255,254,0,0,0,0,191,255,255,224,0,0,0,0,127,255,254,0,0,0,0,0,47,255,144,0,0,0,0,0,15,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30f4  ヴ
  244,48,32,36,32,38,4,252,0,0,0,0,0,0,3,240,0,0,0,0,0,6,194,244,0,0,1,255,0,11,224,252,0,0,0,255,0,3,240,190,0,0,0,255,0,1,248,63,0,0,0,255,0,0,252,24,0,0,0,255,0,0,120,0,0,0,0,255,0,0,0,0,170,170,170,255,170,170,173,0,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,128,255,0,0,0,0,0,255,64,255,0,0,0,0,0,255,0,255,0,0,0,0,1,255,0,255,0,0,0,0,2,255,0,255,0,0,0,0,3,254,0,255,0,0,0,0,3,253,0,255,0,0,0,0,7,252,0,255,0,0,0,0,15,248,0,255,0,0,0,0,15,244,0,0,0,0,0,0,47,240,0,0,0,0,0,0,127,208,0,0,0,0,0,0,255,192,0,0,0,0,0,3,255,64,0,0,0,0,0,11,254,0,0,0,0,0,0,63,252,0,0,0,0,0,0,255,240,0,0,0,0,0,11,255,192,0,0,0,0,0,191,255,0,0,0,0,0,27,255,252,0,0,0,0,3,255,255,208,0,0,0,0,2,255,254,0,0,0,0,0,0,191,224,0,0,0,0,0,0,61,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30f5  ヵ
  245,48,25,28,196,38,6,252,0,0,5,64,0,0,0,0,0,31,208,0,0,0,0,0,31,208,0,0,0,0,0,31,208,0,0,0,0,0,31,208,0,0,0,0,0,31,192,0,0,0,41,85,111,229,85,100,0,127,255,255,255,255,255,64,127,255,255,255,255,255,64,127,255,255,255,255,255,64,0,0,63,192,0,63,64,0,0,63,128,0,63,64,0,0,63,64,0,127,64,0,0,127,0,0,127,0,0,0,191,0,0,127,0,0,0,254,0,0,127,0,0,1,253,0,0,191,0,0,3,252,0,0,191,0,0,11,248,0,0,255,0,0,15,240,0,0,254,0,0,63,224,0,0,254,0,0,191,192,0,1,253,0,2,255,0,0,2,252,0,15,253,0,58,155,252,0,191,248,0,63,255,248,0,127,224,0,63,255,240,0,15,64,0,47,255,128,0,0,0,0,0,0,0,0,
  // 0x30f6  ヶ
  246,48,28,28,196,38,5,251,0,2,232,0,0,0,0,0,2,254,0,0,0,0,0,3,252,0,0,0,0,0,7,252,0,0,0,0,0,11,244,0,0,0,0,0,15,240,0,0,0,0,0,47,255,255,255,255,254,0,63,255,255,255,255,254,0,191,255,255,255,255,254,1,255,85,86,254,85,85,3,253,0,2,252,0,0,15,248,0,2,252,0,0,63,240,0,3,252,0,0,255,192,0,3,248,0,0,255,64,0,7,248,0,0,29,0,0,15,244,0,0,0,0,0,15,240,0,0,0,0,0,47,208,0,0,0,0,0,63,192,0,0,0,0,0,255,128,0,0,0,0,2,255,0,0,0,0,0,11,253,0,0,0,0,0,47,248,0,0,0,0,0,255,240,0,0,0,0,11,255,192,0,0,0,0,3,255,0,0,0,0,0,0,184,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30f7  ヷ
  247,48,32,37,40,38,4,252,0,0,0,0,0,0,0,144,0,0,0,0,0,6,67,240,0,0,0,0,0,31,194,248,0,0,0,0,0,15,208,252,0,0,0,0,0,3,240,190,0,0,0,0,0,2,244,36,0,0,0,0,0,0,128,0,250,170,170,170,170,170,248,0,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,64,255,0,0,0,0,0,255,0,255,0,0,0,0,1,255,0,255,0,0,0,0,1,255,0,255,0,0,0,0,2,254,0,255,0,0,0,0,3,254,0,255,0,0,0,0,3,253,0,255,0,0,0,0,7,252,0,255,0,0,0,0,11,252,0,255,0,0,0,0,15,248,0,255,0,0,0,0,31,240,0,0,0,0,0,0,47,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,191,192,0,0,0,0,0,2,255,64,0,0,0,0,0,7,255,0,0,0,0,0,0,15,253,0,0,0,0,0,0,127,244,0,0,0,0,0,1,255,224,0,0,0,0,0,11,255,192,0,0,0,0,0,127,254,0,0,0,0,0,7,255,248,0,0,0,0,1,191,255,208,0,0,0,0,7,255,254,0,0,0,0,0,1,255,244,0,0,0,0,0,0,191,64,0,0,0,0,0,0,16,0,0,0,0,0,
  // 0x30f8  ヸ
  248,48,33,35,59,38,3,253,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,5,47,0,0,0,0,0,0,85,31,15,64,0,0,0,0,1,254,15,75,192,0,0,0,0,1,254,11,199,192,0,0,0,0,1,254,3,195,128,0,0,0,0,1,254,3,208,0,0,0,0,0,1,254,0,0,0,42,170,170,170,170,255,170,164,0,47,255,255,255,255,255,255,248,0,47,255,255,255,255,255,255,248,0,47,255,255,255,255,255,255,248,0,0,1,253,0,1,254,0,0,0,0,1,253,0,1,254,0,0,0,0,1,253,0,1,254,0,0,0,0,1,253,0,1,254,0,0,0,0,1,253,0,1,254,0,0,0,0,1,253,0,1,254,0,0,0,0,1,253,0,1,254,0,0,0,0,1,253,0,1,254,0,0,0,0,1,253,0,1,254,0,0,0,0,1,253,0,1,254,0,0,0,0,1,253,0,1,254,0,0,0,255,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,254,0,234,170,170,170,171,255,170,169,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,1,169,0,0,0,
  // 0x30f9  ヹ
  249,48,34,34,50,38,2,254,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,184,63,64,0,0,0,0,0,0,252,15,192,0,0,0,0,0,0,127,15,208,0,0,0,0,0,0,63,7,208,0,0,0,0,0,0,31,64,0,0,0,0,0,0,0,4,16,0,7,255,255,255,255,255,255,252,0,7,255,255,255,255,255,255,255,0,7,255,255,255,255,255,255,254,0,7,250,170,170,170,170,175,252,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,47,240,0,0,0,0,5,80,0,127,192,0,0,0,0,31,240,1,255,64,0,0,0,0,15,240,7,254,0,0,0,0,0,15,240,31,252,0,0,0,0,0,15,240,127,240,0,0,0,0,0,15,240,63,192,0,0,0,0,0,15,240,11,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,
  // 0x30fa  ヺ
  250,48,32,37,40,38,4,252,0,0,0,0,0,0,0,144,0,0,0,0,0,6,67,240,0,0,0,0,0,31,194,248,0,0,0,0,0,15,208,252,0,0,0,0,0,7,240,190,0,0,0,0,0,3,244,36,0,0,0,0,0,1,144,0,191,255,255,255,255,255,248,0,191,255,255,255,255,255,255,0,191,255,255,255,255,255,255,0,126,170,170,170,170,171,255,0,0,0,0,0,0,2,254,0,0,0,0,0,0,3,253,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,11,248,0,0,0,0,0,0,15,244,0,47,255,255,255,255,255,240,0,47,255,255,255,255,255,240,0,47,255,255,255,255,255,224,0,26,170,170,170,170,191,192,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,64,0,0,0,0,0,2,255,0,0,0,0,0,0,11,253,0,0,0,0,0,0,31,248,0,0,0,0,0,0,63,240,0,0,0,0,0,1,255,192,0,0,0,0,0,11,255,64,0,0,0,0,0,47,253,0,0,0,0,0,2,255,244,0,0,0,0,0,31,255,208,0,0,0,0,6,255,254,0,0,0,0,0,127,255,244,0,0,0,0,0,63,255,128,0,0,0,0,0,15,248,0,0,0,0,0,0,2,64,0,0,0,0,0,
  // 0x30fb  ・
  251,48,10,9,27,38,14,10,1,164,0,15,255,0,63,255,192,63,255,192,127,255,208,63,255,192,63,255,192,31,255,0,2,248,0,
  // 0x30fc  ー
  252,48,32,6,48,38,3,11,21,85,85,85,85,85,85,84,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,0,0,0,0,0,0,0,0,
  // 0x30fd  ヽ
  253,48,18,19,95,38,11,3,10,0,0,0,0,63,128,0,0,0,255,224,0,0,0,127,248,0,0,0,31,254,0,0,0,7,255,128,0,0,1,255,224,0,0,0,127,248,0,0,0,31,254,0,0,0,7,255,64,0,0,1,255,208,0,0,0,191,240,0,0,0,47,252,0,0,0,15,255,0,0,0,3,255,128,0,0,1,255,208,0,0,0,191,208,0,0,0,63,0,0,0,0,8,0,
  // 0x30fe  ヾ
  254,48,21,24,144,38,10,3,0,0,0,2,240,0,0,0,1,66,248,0,0,0,15,192,252,0,0,0,11,240,127,0,0,0,3,244,63,64,5,0,1,252,31,64,47,128,0,254,4,0,255,224,0,56,0,0,191,248,0,0,0,0,31,254,0,0,0,0,7,255,128,0,0,0,1,255,224,0,0,0,0,127,248,0,0,0,0,31,253,0,0,0,0,7,255,64,0,0,0,2,255,208,0,0,0,0,191,240,0,0,0,0,63,252,0,0,0,0,15,255,0,0,0,0,3,255,128,0,0,0,1,255,208,0,0,0,0,191,208,0,0,0,0,63,0,0,0,0,0,8,0,0,
  // 0x30ff  ヿ
  255,48,23,33,198,38,7,253,106,170,170,170,170,168,191,255,255,255,255,252,191,255,255,255,255,252,191,255,255,255,255,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,0,0,0,0,2,252,
  // 0x4eee  仮
  238,78,36,36,68,38,1,252,0,0,36,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,255,15,255,255,255,255,248,0,1,254,15,255,255,255,255,248,0,2,252,15,255,255,255,255,248,0,7,248,15,245,85,85,85,80,0,15,240,15,224,0,0,0,0,0,31,224,15,224,0,0,0,0,0,63,192,15,224,0,0,0,0,0,255,192,15,224,0,0,0,0,2,255,192,15,224,0,0,0,0,7,255,192,15,224,0,0,0,0,15,255,192,15,255,255,255,255,224,63,255,192,15,255,255,255,255,240,255,239,192,15,255,255,255,255,240,191,111,192,15,255,213,85,95,224,61,47,192,15,255,208,0,31,208,40,47,192,15,239,224,0,47,192,0,47,192,15,231,240,0,63,128,0,47,192,15,211,244,0,127,64,0,47,192,15,210,252,0,191,0,0,47,192,15,208,254,1,254,0,0,47,192,31,192,255,3,252,0,0,47,192,31,192,63,135,248,0,0,47,192,47,192,47,223,240,0,0,47,192,63,128,15,255,208,0,0,47,192,63,128,7,255,192,0,0,47,192,127,0,3,255,64,0,0,47,192,191,0,7,255,192,0,0,47,192,254,0,47,255,244,0,0,47,193,253,0,255,239,254,0,0,47,195,252,11,255,131,255,208,0,47,199,248,127,253,0,255,253,0,47,207,240,191,244,0,47,253,0,47,195,224,63,128,0,2,248,0,31,128,128,24,0,0,0,96,
  // 0x540d  名
  13,84,33,36,68,38,1,252,0,0,0,122,64,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,15,255,255,255,248,0,0,0,0,63,255,255,255,254,0,0,0,0,255,255,255,255,252,0,0,0,3,255,64,0,7,248,0,0,0,15,252,0,0,15,240,0,0,0,127,244,0,0,47,224,0,0,2,255,253,0,0,63,192,0,0,31,255,255,128,0,255,64,0,0,127,248,255,224,2,255,0,0,0,47,208,47,252,11,252,0,0,0,11,0,11,255,31,244,0,0,0,0,0,1,255,255,208,0,0,0,0,0,0,127,255,128,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,63,248,0,0,0,0,0,0,1,255,255,255,255,255,128,0,0,11,255,255,255,255,255,128,0,0,191,255,255,255,255,255,128,0,11,255,252,0,0,0,63,128,0,191,255,248,0,0,0,63,128,31,255,247,248,0,0,0,63,128,127,255,67,248,0,0,0,63,128,47,248,3,248,0,0,0,63,128,14,64,3,248,0,0,0,63,128,0,0,3,248,0,0,0,63,128,0,0,3,248,0,0,0,63,128,0,0,3,248,0,0,0,63,128,0,0,3,255,255,255,255,255,128,0,0,3,255,255,255,255,255,128,0,0,3,255,255,255,255,255,128,0,0,3,252,0,0,0,63,128,0,0,2,248,0,0,0,63,128,
  // 0x5b9a  定
  154,91,35,37,77,38,1,251,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,5,85,85,85,255,85,85,85,80,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,255,255,255,255,255,255,255,240,15,224,0,0,0,0,0,11,240,15,224,0,0,0,0,0,11,240,15,224,0,0,0,0,0,11,240,15,224,0,0,0,0,0,11,240,15,226,255,255,255,255,255,139,240,5,66,255,255,255,255,255,133,80,0,2,255,255,255,255,255,128,0,0,1,85,85,255,85,85,64,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,2,164,0,255,0,0,0,0,0,3,248,0,255,0,0,0,0,0,3,244,0,255,0,0,0,0,0,7,244,0,255,255,255,248,0,0,11,240,0,255,255,255,248,0,0,15,240,0,255,255,255,248,0,0,15,244,0,255,85,85,80,0,0,31,252,0,255,0,0,0,0,0,63,253,0,255,0,0,0,0,0,63,255,0,255,0,0,0,0,0,191,191,192,255,0,0,0,0,0,255,31,244,255,0,0,0,0,3,253,11,255,255,0,0,0,0,11,252,2,255,255,64,0,0,0,47,244,0,191,255,255,255,255,252,127,224,0,11,255,255,255,255,248,47,192,0,0,127,255,255,255,244,11,0,0,0,0,85,85,85,80,0,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,32,37,40,38,2,251,0,0,0,0,7,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,64,0,11,240,0,0,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,234,170,170,170,170,170,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,0,0,0,0,0,0,0,191,170,170,170,170,168,0,0,191,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,255,255,255,255,255,252,0,0,254,0,0,0,3,252,0,1,254,0,0,0,3,252,0,2,253,0,0,0,3,252,0,3,252,0,0,0,3,252,0,7,252,0,0,0,3,252,0,11,244,0,0,0,3,252,0,15,240,0,0,0,3,252,0,47,224,0,0,0,3,252,0,127,192,0,0,0,3,252,0,255,128,0,0,0,3,252,0,255,0,0,0,0,3,252,0,61,0,0,0,0,3,252,0,24,0,0,0,0,3,252,0,0,0,0,0,0,0,0,0,
  // 0x793a  示
  58,121,34,33,41,38,2,252,1,255,255,255,255,255,255,240,0,1,255,255,255,255,255,255,240,0,1,255,255,255,255,255,255,240,0,0,85,85,85,85,85,85,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,255,255,255,255,255,224,85,85,85,87,253,85,85,85,80,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,15,128,3,252,0,29,0,0,0,31,240,3,252,0,255,0,0,0,47,208,3,252,0,191,128,0,0,63,192,3,252,0,63,208,0,0,191,128,3,252,0,31,240,0,1,255,0,3,252,0,11,248,0,3,253,0,3,252,0,3,252,0,11,252,0,3,252,0,2,254,0,31,244,0,3,252,0,0,255,0,63,224,0,3,252,0,0,191,128,255,192,0,3,252,0,0,63,192,255,0,0,3,252,0,0,47,208,45,0,0,3,252,0,0,30,0,0,0,63,255,252,0,0,0,0,0,0,63,255,248,0,0,0,0,0,0,31,255,240,0,0,0,0,0,0,10,169,0,0,0,0,0,
  // 0x7fa9  義
  169,127,35,36,68,38,2,252,0,0,40,0,0,3,144,0,0,0,1,254,0,0,7,248,0,0,0,0,255,0,0,15,240,0,0,0,0,63,128,0,47,192,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,10,170,170,171,254,170,170,170,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,170,170,171,254,170,170,160,0,0,0,0,3,248,0,0,0,0,191,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,0,0,0,25,0,0,16,0,0,0,5,175,255,15,224,62,0,0,63,255,255,255,139,224,255,224,0,47,234,255,144,7,240,47,253,0,0,0,253,0,7,240,2,253,0,0,0,253,0,3,240,0,36,0,255,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,255,240,170,170,255,170,171,254,170,170,160,0,0,253,0,0,253,1,224,0,0,0,253,1,80,255,7,252,0,90,175,255,255,224,191,95,240,0,255,255,255,255,224,63,255,192,0,191,255,254,84,0,47,255,0,64,16,0,253,0,0,127,248,1,224,0,0,253,0,7,255,253,1,244,0,0,253,1,191,255,255,151,240,2,171,253,15,255,224,191,255,240,2,255,252,11,254,0,31,255,208,1,255,224,3,128,0,1,255,64,
  // 0x8868  表
  104,136,36,36,68,38,1,252,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,127,255,255,255,255,255,255,0,0,127,255,255,255,255,255,255,0,0,127,255,255,255,255,255,254,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,47,255,255,255,255,255,255,255,244,47,255,255,255,255,255,255,255,244,47,255,255,255,255,255,255,255,244,0,0,0,47,255,240,0,0,0,0,0,1,255,199,240,0,10,0,0,0,11,255,3,248,0,47,192,0,0,191,244,2,252,0,255,208,0,11,255,192,0,254,7,255,0,1,255,255,192,0,191,47,248,0,111,255,255,192,0,127,255,208,0,127,254,47,192,0,47,254,0,0,31,224,47,192,0,15,244,0,0,9,0,47,192,0,7,252,0,0,0,0,47,192,0,18,255,64,0,0,0,47,192,27,240,255,208,0,0,0,47,239,255,240,63,252,0,0,0,127,255,255,240,15,255,128,0,111,255,255,249,0,2,255,253,0,191,255,249,0,0,0,127,252,0,63,249,0,0,0,0,11,244,0,41,0,0,0,0,0,0,96,
};

#endif // HAS_GRAPHICAL_TFT
