/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Greek 38pt, capital 'A' height: 28px, width: 100%, range: 0x0386-0x03ce, glyphs: 63
extern const uint8_t NotoSans_Medium_Greek_28[10071] = {
  130,28,134,3,206,3,37,246, // unifont_t
  // 0x0386  Ά
  28,28,196,28,0,0,5,84,0,5,64,0,0,15,248,0,63,240,0,0,31,240,0,127,244,0,0,47,208,0,191,248,0,0,63,128,0,255,252,0,0,127,0,1,253,253,0,0,189,0,3,252,255,0,0,0,0,3,248,191,0,0,0,0,11,244,127,128,0,0,0,15,240,63,192,0,0,0,31,224,47,208,0,0,0,47,208,31,224,0,0,0,63,192,15,240,0,0,0,127,128,11,244,0,0,0,255,0,3,252,0,0,0,255,0,3,252,0,0,2,254,85,86,254,0,0,3,255,255,255,255,0,0,7,255,255,255,255,64,0,11,255,255,255,255,128,0,15,240,0,0,127,192,0,31,224,0,0,63,208,0,63,208,0,0,31,240,0,63,192,0,0,15,240,0,191,128,0,0,11,248,0,255,64,0,0,7,252,1,255,0,0,0,3,253,2,254,0,0,0,2,254,
  // 0x0387  ·
  255,
  // 0x0388  Έ
  26,28,196,28,0,0,5,84,0,0,0,0,0,15,248,7,255,255,255,240,31,240,7,255,255,255,240,47,208,7,255,255,255,240,63,128,7,253,85,85,80,127,0,7,248,0,0,0,189,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,255,255,255,192,0,0,7,255,255,255,192,0,0,7,255,255,255,192,0,0,7,254,170,170,128,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,254,170,170,144,0,0,7,255,255,255,240,0,0,7,255,255,255,240,0,0,7,255,255,255,240,
  // 0x0389  Ή
  32,28,224,35,0,0,5,84,0,0,0,0,0,0,15,248,7,248,0,0,1,254,31,240,7,248,0,0,1,254,47,208,7,248,0,0,1,254,63,128,7,248,0,0,1,254,127,0,7,248,0,0,1,254,189,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,255,255,255,255,254,0,0,7,255,255,255,255,254,0,0,7,255,255,255,255,254,0,0,7,254,170,170,171,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,0,0,7,248,0,0,1,254,
  // 0x038a  Ί
  20,28,140,21,0,0,5,84,0,0,0,15,248,63,255,254,31,240,63,255,254,47,208,27,255,248,63,128,0,191,128,127,0,0,191,64,189,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,128,0,0,31,255,249,0,0,63,255,254,0,0,63,255,254,
  // 0x038b  ΋
  255,
  // 0x038c  Ό
  33,29,5,35,0,255,5,84,0,0,22,148,0,0,0,15,248,0,11,255,255,224,0,0,31,240,0,191,255,255,253,0,0,47,208,2,255,255,255,255,128,0,63,128,11,255,144,6,255,224,0,127,0,31,252,0,0,63,244,0,189,0,63,240,0,0,15,252,0,0,0,127,192,0,0,7,253,0,0,0,255,128,0,0,3,254,0,0,0,255,64,0,0,1,255,0,0,1,255,0,0,0,0,255,0,0,2,255,0,0,0,0,255,64,0,2,254,0,0,0,0,255,64,0,2,254,0,0,0,0,255,128,0,2,254,0,0,0,0,255,128,0,2,254,0,0,0,0,255,128,0,2,254,0,0,0,0,255,64,0,1,255,0,0,0,0,255,64,0,1,255,0,0,0,0,255,0,0,0,255,64,0,0,2,255,0,0,0,255,192,0,0,3,254,0,0,0,127,208,0,0,7,252,0,0,0,63,240,0,0,15,252,0,0,0,31,253,0,0,127,240,0,0,0,11,255,144,7,255,208,0,0,0,2,255,255,255,255,64,0,0,0,0,127,255,255,252,0,0,0,0,0,7,255,255,144,0,0,0,0,0,0,5,80,0,0,0,
  // 0x038d  ΍
  255,
  // 0x038e  Ύ
  31,28,224,31,0,0,5,84,0,0,0,0,0,0,15,248,63,224,0,0,15,248,31,240,31,240,0,0,31,240,47,208,15,248,0,0,63,224,63,128,3,252,0,0,127,192,127,0,2,254,0,0,255,64,189,0,0,255,0,1,255,0,0,0,0,191,128,3,253,0,0,0,0,63,208,7,252,0,0,0,0,47,240,15,244,0,0,0,0,15,244,31,224,0,0,0,0,7,252,63,192,0,0,0,0,3,253,191,128,0,0,0,0,1,255,255,0,0,0,0,0,0,255,254,0,0,0,0,0,0,127,252,0,0,0,0,0,0,47,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,
  // 0x038f  Ώ
  32,28,224,33,0,0,5,84,0,0,90,80,0,0,15,248,0,31,255,255,128,0,31,240,1,255,255,255,248,0,47,208,7,255,255,255,255,0,63,128,31,254,64,11,255,192,127,0,63,244,0,0,191,224,189,0,191,208,0,0,47,244,0,0,255,128,0,0,15,248,0,2,255,0,0,0,7,252,0,3,254,0,0,0,3,253,0,3,253,0,0,0,3,254,0,3,252,0,0,0,2,254,0,7,252,0,0,0,2,255,0,7,252,0,0,0,1,255,0,3,252,0,0,0,1,254,0,3,252,0,0,0,2,254,0,3,253,0,0,0,2,253,0,2,254,0,0,0,3,252,0,1,255,0,0,0,7,252,0,0,255,0,0,0,11,244,0,0,127,192,0,0,15,240,0,0,47,224,0,0,63,192,0,0,15,244,0,0,255,64,0,0,2,254,0,3,253,0,0,6,170,255,128,31,250,170,0,11,255,255,192,31,255,255,0,11,255,255,192,31,255,255,0,11,255,255,192,31,255,255,
  // 0x0390  ΐ
  255,
  // 0x0391  Α
  25,28,196,25,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x0392  Β
  20,27,135,25,3,0,127,255,255,228,0,127,255,255,255,128,127,255,255,255,224,127,213,86,255,244,127,128,0,31,252,127,128,0,11,252,127,128,0,3,252,127,128,0,3,252,127,128,0,7,252,127,128,0,15,244,127,128,0,127,240,127,255,255,255,128,127,255,255,248,0,127,255,255,255,64,127,234,170,255,240,127,128,0,31,252,127,128,0,3,253,127,128,0,2,254,127,128,0,1,255,127,128,0,1,255,127,128,0,2,255,127,128,0,3,254,127,128,0,15,252,127,213,86,255,248,127,255,255,255,240,127,255,255,255,64,127,255,255,228,0,
  // 0x0393  Γ
  15,27,108,19,3,0,127,255,255,252,127,255,255,252,127,255,255,252,127,213,85,84,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,
  // 0x0394  Δ
  25,28,196,25,0,0,0,0,1,80,0,0,0,0,0,15,248,0,0,0,0,0,47,252,0,0,0,0,0,63,254,0,0,0,0,0,127,255,0,0,0,0,0,191,127,64,0,0,0,0,254,63,128,0,0,0,1,253,47,192,0,0,0,3,252,31,208,0,0,0,3,248,15,240,0,0,0,11,244,11,244,0,0,0,15,240,7,248,0,0,0,31,224,3,252,0,0,0,63,192,2,253,0,0,0,63,192,0,255,0,0,0,191,64,0,255,0,0,0,255,0,0,127,128,0,1,254,0,0,63,192,0,3,253,0,0,47,208,0,3,252,0,0,31,240,0,11,248,0,0,15,240,0,15,240,0,0,11,248,0,31,240,0,0,3,252,0,47,208,0,0,3,253,0,63,234,170,170,171,254,0,191,255,255,255,255,255,0,191,255,255,255,255,255,64,191,255,255,255,255,255,64,
  // 0x0395  Ε
  16,27,108,21,3,0,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x0396  Ζ
  20,27,135,22,1,0,127,255,255,255,252,127,255,255,255,252,127,255,255,255,252,21,85,85,95,248,0,0,0,47,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,3,253,0,0,0,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,255,128,0,0,2,255,0,0,0,7,253,0,0,0,15,248,0,0,0,47,240,0,0,0,127,208,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,248,0,0,0,47,240,0,0,0,127,234,170,170,169,191,255,255,255,253,191,255,255,255,253,191,255,255,255,253,
  // 0x0397  Η
  22,27,162,28,3,0,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,255,255,255,255,240,127,255,255,255,255,240,127,255,255,255,255,240,127,234,170,170,175,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,
  // 0x0398  Θ
  26,29,203,30,2,255,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,129,170,170,160,63,208,191,130,255,255,244,63,224,191,130,255,255,244,63,224,191,130,255,255,244,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,
  // 0x0399  Ι
  11,27,81,13,1,0,191,255,252,191,255,252,47,255,228,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,47,255,244,191,255,252,191,255,252,
  // 0x039a  Κ
  21,27,162,24,3,0,127,128,0,2,255,0,127,128,0,7,253,0,127,128,0,31,244,0,127,128,0,63,224,0,127,128,0,255,128,0,127,128,3,255,0,0,127,128,11,252,0,0,127,128,47,240,0,0,127,128,127,192,0,0,127,129,255,64,0,0,127,131,253,0,0,0,127,143,248,0,0,0,127,255,252,0,0,0,127,255,254,0,0,0,127,255,255,64,0,0,127,240,255,192,0,0,127,192,63,224,0,0,127,128,31,244,0,0,127,128,15,252,0,0,127,128,3,255,0,0,127,128,1,255,64,0,127,128,0,191,192,0,127,128,0,63,240,0,127,128,0,15,248,0,127,128,0,11,253,0,127,128,0,3,255,0,127,128,0,0,255,128,
  // 0x039b  Λ
  24,28,168,24,0,0,0,0,5,80,0,0,0,0,31,244,0,0,0,0,63,248,0,0,0,0,63,252,0,0,0,0,191,253,0,0,0,0,254,254,0,0,0,1,253,191,0,0,0,2,252,127,64,0,0,3,252,63,192,0,0,7,244,47,192,0,0,11,240,31,224,0,0,15,240,15,240,0,0,31,208,11,240,0,0,63,192,7,248,0,0,63,192,3,252,0,0,191,64,2,253,0,0,255,0,1,254,0,0,255,0,0,255,0,2,253,0,0,191,64,3,252,0,0,127,128,7,252,0,0,63,192,11,244,0,0,47,208,15,240,0,0,31,240,31,240,0,0,15,240,47,208,0,0,11,248,63,192,0,0,7,252,127,192,0,0,3,252,255,64,0,0,2,254,
  // 0x039c  Μ
  29,27,216,35,3,0,127,248,0,0,0,15,255,64,127,252,0,0,0,15,255,64,127,253,0,0,0,47,255,64,127,255,0,0,0,63,255,64,127,191,0,0,0,127,191,64,127,127,64,0,0,191,191,64,127,63,192,0,0,253,191,64,127,47,192,0,1,252,191,64,127,79,224,0,3,248,191,64,127,79,240,0,3,244,191,64,127,71,244,0,7,240,191,64,127,67,248,0,15,224,191,64,127,66,252,0,15,208,191,64,127,65,253,0,47,192,191,64,127,64,254,0,63,128,191,64,127,64,191,0,127,0,191,64,127,64,127,64,191,0,191,64,127,64,63,192,253,0,191,64,127,64,47,193,252,0,191,64,127,64,15,211,248,0,191,64,127,64,15,243,244,0,191,64,127,64,11,255,240,0,191,64,127,64,3,255,224,0,191,64,127,64,3,255,192,0,191,64,127,64,1,255,192,0,191,64,127,64,0,255,128,0,191,64,127,64,0,255,0,0,191,64,
  // 0x039d  Ν
  23,27,162,29,3,0,127,240,0,0,3,252,127,248,0,0,3,252,127,252,0,0,3,252,127,255,0,0,3,252,127,255,64,0,3,252,127,191,192,0,3,252,127,63,224,0,3,252,127,31,244,0,3,252,127,11,252,0,3,252,127,3,254,0,3,252,127,65,255,0,3,252,127,64,255,192,3,252,127,64,63,208,3,252,127,64,47,240,3,252,127,64,15,248,3,252,127,64,7,253,3,252,127,64,2,255,3,252,127,64,0,255,131,252,127,64,0,127,195,252,127,64,0,63,243,252,127,64,0,15,246,252,127,64,0,11,255,252,127,64,0,3,255,252,127,64,0,1,255,252,127,64,0,0,191,252,127,64,0,0,63,252,127,64,0,0,31,252,
  // 0x039e  Ξ
  20,27,135,24,2,0,63,255,255,255,248,63,255,255,255,248,63,255,255,255,248,21,85,85,85,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,255,255,255,192,7,255,255,255,192,7,255,255,255,192,6,170,170,170,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,169,191,255,255,255,253,191,255,255,255,253,191,255,255,255,253,
  // 0x039f  Ο
  26,29,203,30,2,255,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,
  // 0x03a0  Π
  22,27,162,28,3,0,127,255,255,255,255,208,127,255,255,255,255,208,127,255,255,255,255,208,127,213,85,85,127,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,127,128,0,0,47,208,
  // 0x03a1  Ρ
  19,27,135,23,3,0,127,255,255,144,0,127,255,255,253,0,127,255,255,255,64,127,213,91,255,192,127,128,0,127,224,127,128,0,47,240,127,128,0,15,244,127,128,0,15,244,127,128,0,15,244,127,128,0,15,244,127,128,0,31,240,127,128,0,63,224,127,128,1,255,192,127,255,255,255,128,127,255,255,253,0,127,255,255,224,0,127,234,169,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,
  // 0x03a2  ΢
  255,
  // 0x03a3  Σ
  20,27,135,22,1,0,127,255,255,255,252,127,255,255,255,252,127,255,255,255,252,63,245,85,85,84,15,248,0,0,0,7,254,0,0,0,1,255,64,0,0,0,191,208,0,0,0,47,240,0,0,0,15,252,0,0,0,3,255,0,0,0,0,255,128,0,0,0,127,192,0,0,0,127,192,0,0,0,255,0,0,0,3,253,0,0,0,15,248,0,0,0,47,224,0,0,0,127,192,0,0,1,255,0,0,0,3,253,0,0,0,15,244,0,0,0,47,224,0,0,0,191,234,170,170,169,191,255,255,255,253,191,255,255,255,253,191,255,255,255,253,
  // 0x03a4  Τ
  21,27,162,21,0,0,191,255,255,255,255,192,191,255,255,255,255,192,191,255,255,255,255,192,21,85,191,213,85,64,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,
  // 0x03a5  Υ
  22,27,162,22,0,0,191,192,0,0,47,240,63,208,0,0,63,208,47,240,0,0,191,128,15,244,0,0,255,0,11,252,0,2,254,0,3,253,0,3,252,0,1,255,0,11,248,0,0,255,64,31,240,0,0,127,192,63,208,0,0,63,208,127,192,0,0,31,240,255,64,0,0,11,249,255,0,0,0,3,255,253,0,0,0,2,255,248,0,0,0,0,255,240,0,0,0,0,191,224,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x03a6  Φ
  29,29,232,33,2,255,0,0,0,21,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,21,255,149,0,0,0,0,11,255,255,255,248,0,0,0,191,255,255,255,255,128,0,3,255,255,255,255,255,240,0,15,255,64,191,64,127,252,0,63,244,0,191,64,7,254,0,63,192,0,191,64,1,255,0,191,128,0,191,64,0,255,64,255,64,0,191,64,0,191,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,63,192,255,0,0,191,64,0,127,192,255,0,0,191,64,0,127,128,255,64,0,191,64,0,191,64,191,128,0,191,64,0,255,0,63,208,0,191,64,2,255,0,47,244,0,191,64,11,253,0,15,254,64,191,64,127,248,0,3,255,255,255,255,255,224,0,0,191,255,255,255,255,64,0,0,11,255,255,255,248,0,0,0,0,22,255,165,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x03a7  Χ
  23,27,162,23,0,0,63,224,0,0,31,240,31,244,0,0,63,208,11,252,0,0,191,128,3,253,0,0,255,0,1,255,0,3,253,0,0,191,128,7,252,0,0,63,208,15,240,0,0,31,240,47,208,0,0,11,248,127,192,0,0,3,252,255,0,0,0,1,255,254,0,0,0,0,255,252,0,0,0,0,63,244,0,0,0,0,127,244,0,0,0,0,255,252,0,0,0,2,255,254,0,0,0,3,252,255,64,0,0,15,244,127,192,0,0,31,224,63,224,0,0,63,192,15,240,0,0,191,64,11,252,0,1,255,0,3,254,0,3,253,0,1,255,0,11,248,0,0,191,192,31,240,0,0,63,208,63,208,0,0,47,240,191,192,0,0,15,248,
  // 0x03a8  Ψ
  26,27,189,32,3,0,191,64,3,252,0,47,208,191,64,3,252,0,47,208,191,64,3,252,0,47,208,191,64,3,252,0,47,208,191,64,3,252,0,47,208,191,64,3,252,0,47,208,191,64,3,252,0,47,208,191,64,3,252,0,47,208,191,64,3,252,0,47,208,191,64,3,252,0,47,208,191,64,3,252,0,47,208,127,128,3,252,0,63,192,63,192,3,252,0,63,192,63,208,3,252,0,191,128,47,240,3,252,0,255,64,15,253,3,252,7,255,0,7,255,235,254,191,252,0,1,255,255,255,255,240,0,0,47,255,255,255,128,0,0,1,191,255,228,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,
  // 0x03a9  Ω
  26,28,196,28,1,0,0,0,5,165,0,0,0,0,2,255,255,244,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,3,255,228,1,191,248,0,11,255,0,0,31,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,127,192,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,192,63,192,0,0,0,127,192,47,208,0,0,0,191,64,31,240,0,0,0,255,0,11,244,0,0,2,253,0,3,252,0,0,7,252,0,0,255,0,0,31,240,0,0,127,192,0,127,192,0,106,175,244,2,255,170,144,255,255,248,3,255,255,224,255,255,248,3,255,255,224,255,255,248,3,255,255,224,
  // 0x03aa  Ϊ
  255,
  // 0x03ab  Ϋ
  255,
  // 0x03ac  ά
  21,31,186,24,2,255,0,0,5,84,0,0,0,0,31,244,0,0,0,0,47,224,0,0,0,0,63,192,0,0,0,0,63,64,0,0,0,0,191,0,0,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,232,1,80,0,1,255,255,131,244,0,7,255,255,247,244,0,15,254,155,255,244,0,63,240,0,127,244,0,63,208,0,47,244,0,191,192,0,15,244,0,191,64,0,15,244,0,255,64,0,11,244,0,255,0,0,11,244,0,255,0,0,7,244,0,255,0,0,7,244,0,255,0,0,11,244,0,255,64,0,11,244,0,191,128,0,15,244,0,127,192,0,15,244,0,63,224,0,63,244,0,47,248,1,255,252,0,15,255,255,247,255,192,3,255,255,210,255,192,0,191,254,0,255,192,0,1,64,0,5,0,
  // 0x03ad  έ
  16,31,124,18,1,255,0,0,5,84,0,0,31,240,0,0,47,224,0,0,63,192,0,0,127,64,0,0,190,0,0,0,252,0,0,0,0,0,0,0,0,0,0,27,254,144,1,255,255,254,11,255,255,254,15,254,86,253,31,240,0,8,47,208,0,0,47,208,0,0,31,224,0,0,11,253,0,0,2,255,255,0,0,127,255,0,7,255,255,0,47,244,0,0,63,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,63,244,0,30,31,255,255,254,7,255,255,254,0,191,255,248,0,1,85,0,
  // 0x03ae  ή
  18,40,200,24,3,246,0,1,85,0,0,0,3,255,0,0,0,3,252,0,0,0,7,248,0,0,0,11,240,0,0,0,15,208,0,0,0,15,128,0,0,0,0,0,0,0,0,0,0,0,0,84,1,191,144,0,254,31,255,252,0,255,127,255,255,0,255,254,155,255,128,255,240,0,191,192,255,208,0,63,208,255,192,0,47,208,255,128,0,47,224,255,64,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,0,0,
  // 0x03af  ί
  10,31,93,13,3,255,1,85,0,3,253,0,7,252,0,15,240,0,15,224,0,31,192,0,47,64,0,0,0,0,0,0,0,85,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,64,0,191,208,0,63,255,208,47,255,208,7,255,208,0,21,0,
  // 0x03b0  ΰ
  255,
  // 0x03b1  α
  21,22,132,24,2,255,0,27,232,1,80,0,1,255,255,131,244,0,7,255,255,247,244,0,15,254,155,255,244,0,63,240,0,127,244,0,63,208,0,47,244,0,191,192,0,15,244,0,191,64,0,15,244,0,255,64,0,11,244,0,255,0,0,11,244,0,255,0,0,7,244,0,255,0,0,7,244,0,255,0,0,11,244,0,255,64,0,11,244,0,191,128,0,15,244,0,127,192,0,15,244,0,63,224,0,63,244,0,47,248,1,255,252,0,15,255,255,247,255,192,3,255,255,210,255,192,0,191,254,0,255,192,0,1,64,0,5,0,
  // 0x03b2  β
  19,39,195,24,3,246,0,31,255,128,0,2,255,255,248,0,11,255,255,254,0,47,253,23,255,64,63,224,0,255,192,127,192,0,63,192,191,64,0,63,192,255,64,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,191,64,255,0,2,254,0,255,6,175,248,0,255,7,255,128,0,255,7,255,248,0,255,1,91,255,64,255,0,0,127,192,255,0,0,47,240,255,0,0,15,240,255,0,0,11,244,255,0,0,11,244,255,0,0,11,248,255,0,0,15,244,255,0,0,15,244,255,64,0,47,240,255,228,1,255,208,255,255,255,255,128,255,255,255,254,0,255,111,255,224,0,255,0,84,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,0,0,0,0,0,
  // 0x03b3  γ
  19,29,145,20,0,248,85,0,0,1,84,191,64,0,3,252,127,192,0,3,252,63,192,0,3,252,47,208,0,3,252,15,240,0,7,248,15,240,0,7,248,11,244,0,11,244,3,252,0,15,240,3,252,0,15,240,1,253,0,31,224,0,255,0,47,208,0,191,0,63,192,0,127,64,127,64,0,63,192,255,0,0,47,194,253,0,0,31,215,252,0,0,15,255,240,0,0,11,255,208,0,0,3,255,128,0,0,3,254,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,
  // 0x03b4  δ
  20,30,150,23,1,255,0,1,191,249,0,0,15,255,255,208,0,63,255,255,248,0,191,208,31,240,0,255,0,1,224,0,254,0,0,0,0,255,0,0,0,0,255,64,0,0,0,191,224,0,0,0,47,253,0,0,0,11,255,192,0,0,7,255,248,0,0,127,255,255,0,1,255,129,255,192,7,253,0,63,240,15,244,0,15,248,47,224,0,7,252,63,192,0,3,253,63,192,0,2,254,127,128,0,1,254,127,128,0,1,254,127,192,0,2,254,63,192,0,3,253,63,224,0,3,252,47,244,0,15,248,15,254,0,127,240,3,255,255,255,208,0,255,255,255,64,0,31,255,248,0,0,0,84,0,0,
  // 0x03b5  ε
  16,22,88,18,1,255,0,27,254,144,1,255,255,254,11,255,255,254,15,254,86,253,31,240,0,8,47,208,0,0,47,208,0,0,31,224,0,0,11,253,0,0,2,255,255,0,0,127,255,0,7,255,255,0,47,244,0,0,63,192,0,0,127,192,0,0,127,192,0,0,127,192,0,0,63,244,0,30,31,255,255,254,7,255,255,254,0,191,255,248,0,1,85,0,
  // 0x03b6  ζ
  16,37,148,18,2,248,63,255,255,254,63,255,255,254,63,255,255,254,0,0,7,252,0,0,15,240,0,0,63,208,0,0,191,128,0,1,255,0,0,3,252,0,0,15,244,0,0,47,224,0,0,127,192,0,0,255,0,0,3,253,0,0,11,248,0,0,15,240,0,0,47,224,0,0,63,192,0,0,127,128,0,0,255,64,0,0,255,0,0,0,255,0,0,0,255,64,0,0,255,192,0,0,127,240,0,0,63,254,64,0,15,255,254,0,2,255,255,240,0,47,255,252,0,0,111,253,0,0,3,254,0,0,2,254,0,0,1,253,0,0,2,252,0,0,3,252,0,0,11,244,0,0,10,160,
  // 0x03b7  η
  18,31,155,24,3,246,84,1,191,144,0,254,31,255,252,0,255,127,255,255,0,255,254,155,255,128,255,240,0,191,192,255,208,0,63,208,255,192,0,47,208,255,128,0,47,224,255,64,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,0,0,
  // 0x03b8  θ
  19,30,150,23,2,255,0,27,255,64,0,0,191,255,244,0,3,255,255,253,0,11,254,70,255,0,15,240,0,127,192,47,208,0,63,208,63,192,0,31,224,127,128,0,15,240,191,128,0,15,240,191,64,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,255,255,255,248,255,255,255,255,252,255,255,255,255,252,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,191,64,0,11,244,191,64,0,11,244,127,128,0,15,240,63,192,0,15,240,47,208,0,47,208,15,240,0,63,192,11,252,1,255,128,3,255,255,255,0,0,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x03b9  ι
  10,22,66,13,3,255,85,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,64,0,191,208,0,63,255,208,47,255,208,7,255,208,0,21,0,
  // 0x03ba  κ
  18,21,105,21,3,0,85,0,0,21,64,255,64,0,255,128,255,64,3,254,0,255,64,11,252,0,255,64,47,240,0,255,64,127,192,0,255,65,255,64,0,255,67,253,0,0,255,15,248,0,0,255,63,240,0,0,255,191,240,0,0,255,255,252,0,0,255,247,254,0,0,255,192,255,64,0,255,64,127,192,0,255,64,47,240,0,255,64,15,248,0,255,64,7,253,0,255,64,2,255,0,255,64,0,255,192,255,64,0,63,224,
  // 0x03bb  λ
  21,30,180,20,0,255,191,228,0,0,0,0,255,255,0,0,0,0,255,255,192,0,0,0,81,191,224,0,0,0,0,31,240,0,0,0,0,11,248,0,0,0,0,3,252,0,0,0,0,2,253,0,0,0,0,1,254,0,0,0,0,2,255,0,0,0,0,3,255,64,0,0,0,7,255,192,0,0,0,11,255,192,0,0,0,15,223,224,0,0,0,31,207,240,0,0,0,63,203,244,0,0,0,63,67,248,0,0,0,191,3,252,0,0,0,255,2,253,0,0,1,254,0,255,0,0,2,253,0,255,0,0,3,252,0,127,128,0,7,248,0,63,192,0,15,244,0,63,208,0,15,240,0,31,240,0,31,224,0,15,244,0,63,208,0,11,255,64,63,192,0,7,255,64,191,192,0,2,255,64,0,0,0,0,20,0,
  // 0x03bc  μ
  21,31,186,24,3,246,85,0,0,5,80,0,255,0,0,31,240,0,255,0,0,31,240,0,255,0,0,31,240,0,255,0,0,31,240,0,255,0,0,31,240,0,255,0,0,31,240,0,255,0,0,31,240,0,255,0,0,31,240,0,255,0,0,31,240,0,255,0,0,31,240,0,255,0,0,31,240,0,255,0,0,31,240,0,255,0,0,47,240,0,255,64,0,63,240,0,255,128,0,63,240,0,255,192,0,191,240,0,255,244,7,255,244,0,255,255,255,239,255,64,255,255,255,199,255,64,255,47,254,2,255,64,255,1,64,0,20,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,0,
  // 0x03bd  ν
  19,21,105,20,0,0,85,0,0,1,84,191,64,0,3,252,127,192,0,3,252,63,192,0,3,252,47,208,0,3,252,15,240,0,7,248,15,240,0,7,248,11,244,0,11,244,3,252,0,15,240,3,252,0,15,240,1,253,0,31,224,0,255,0,47,208,0,255,0,63,192,0,127,64,127,64,0,63,192,255,0,0,47,194,253,0,0,31,215,252,0,0,15,255,240,0,0,11,255,208,0,0,7,255,128,0,0,3,254,0,0,
  // 0x03be  ξ
  16,37,148,19,2,248,47,255,255,254,63,255,255,255,63,255,255,255,0,111,228,0,2,253,0,0,15,240,0,0,31,208,0,0,47,192,0,0,47,192,0,0,47,208,0,0,31,240,0,0,15,252,0,0,3,255,234,168,0,127,255,252,0,191,255,252,7,255,149,84,31,244,0,0,63,192,0,0,191,128,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,64,0,0,255,192,0,0,127,224,0,0,63,254,64,0,15,255,254,64,2,255,255,240,0,47,255,252,0,0,111,253,0,0,3,254,0,0,1,254,0,0,1,254,0,0,2,253,0,0,3,252,0,0,7,248,0,0,10,160,
  // 0x03bf  ο
  19,22,110,23,2,255,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,
  // 0x03c0  π
  25,22,154,26,0,255,21,85,85,85,85,85,64,127,255,255,255,255,255,192,127,255,255,255,255,255,192,42,191,234,170,191,234,128,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,192,0,0,63,192,0,63,208,0,0,63,192,0,63,255,64,0,63,192,0,31,255,64,0,63,192,0,7,255,64,0,0,0,0,0,84,0,
  // 0x03c1  ρ
  19,31,155,23,2,246,0,6,254,64,0,0,127,255,248,0,2,255,255,255,0,11,255,171,255,192,15,248,0,127,224,47,224,0,31,240,63,192,0,15,244,63,192,0,11,248,127,192,0,7,252,127,128,0,3,252,127,128,0,3,252,127,128,0,3,252,127,128,0,3,252,127,128,0,7,252,127,128,0,11,248,127,128,0,15,244,127,192,0,47,240,127,248,0,255,192,127,255,255,255,64,127,255,255,253,0,127,75,255,224,0,127,128,20,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,0,0,0,0,0,
  // 0x03c2  ς
  16,29,116,19,2,248,0,6,254,144,0,191,255,252,3,255,255,252,15,255,171,248,47,244,0,16,63,208,0,0,127,192,0,0,191,128,0,0,255,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,64,0,0,255,64,0,0,191,192,0,0,127,208,0,0,63,244,0,0,31,255,64,0,7,255,254,0,1,255,255,224,0,31,255,252,0,0,111,253,0,0,3,254,0,0,2,254,0,0,1,253,0,0,2,252,0,0,3,252,0,0,11,244,0,0,10,160,
  // 0x03c3  σ
  21,22,132,24,2,255,0,0,85,85,85,0,0,47,255,255,255,64,1,255,255,255,255,64,11,255,234,255,170,64,31,252,0,63,128,0,63,224,0,47,208,0,127,192,0,15,240,0,191,128,0,15,240,0,255,64,0,11,244,0,255,0,0,7,248,0,255,0,0,7,248,0,255,0,0,7,252,0,255,0,0,7,248,0,255,64,0,11,248,0,191,128,0,15,244,0,127,192,0,15,240,0,63,224,0,63,224,0,31,248,1,255,192,0,11,255,255,255,64,0,2,255,255,253,0,0,0,47,255,224,0,0,0,0,84,0,0,0,
  // 0x03c4  τ
  18,22,110,19,0,255,21,85,85,85,80,127,255,255,255,240,127,255,255,255,240,42,175,250,170,160,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,244,0,0,0,11,253,0,0,0,3,255,255,192,0,1,255,255,192,0,0,127,255,128,0,0,1,84,0,
  // 0x03c5  υ
  18,22,110,23,3,255,85,0,0,85,0,255,0,0,127,128,255,0,0,127,192,255,0,0,63,192,255,0,0,63,192,255,0,0,47,208,255,0,0,47,208,255,0,0,47,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,47,224,255,0,0,47,208,255,0,0,63,208,255,0,0,63,192,255,64,0,127,192,191,192,0,255,64,63,224,7,255,0,47,255,255,252,0,15,255,255,240,0,1,255,255,64,0,0,5,80,0,0,
  // 0x03c6  φ
  25,39,17,29,2,246,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,111,250,64,0,0,0,47,255,255,248,0,0,1,255,255,255,255,128,0,7,255,239,250,255,224,0,15,252,11,240,47,248,0,63,240,11,240,7,253,0,127,192,11,240,2,255,0,191,128,11,240,0,255,0,255,64,11,240,0,255,64,255,0,11,240,0,191,64,255,0,11,240,0,191,128,255,0,11,240,0,191,128,255,64,11,240,0,191,64,191,128,11,240,0,255,64,127,192,11,240,1,255,0,63,208,11,240,3,254,0,31,244,11,240,11,252,0,11,254,11,240,127,244,0,2,255,255,255,255,208,0,0,127,255,255,255,0,0,0,6,255,255,228,0,0,0,0,11,244,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,0,0,0,0,0,
  // 0x03c7  χ
  22,31,186,23,1,246,105,0,0,0,21,80,255,208,0,0,63,192,255,240,0,0,191,128,239,248,0,0,255,0,3,252,0,2,253,0,1,254,0,3,252,0,0,255,0,11,240,0,0,127,128,31,224,0,0,63,192,63,192,0,0,31,224,127,64,0,0,15,240,255,0,0,0,7,249,253,0,0,0,3,255,252,0,0,0,2,255,240,0,0,0,0,255,224,0,0,0,0,191,192,0,0,0,0,255,192,0,0,0,1,255,224,0,0,0,3,255,240,0,0,0,11,251,248,0,0,0,31,227,252,0,0,0,63,194,254,0,0,0,191,64,255,0,0,0,255,0,191,128,0,3,252,0,63,192,0,7,248,0,47,224,0,15,240,0,15,249,64,47,208,0,11,255,224,127,192,0,3,255,224,255,0,0,0,191,224,0,0,0,0,0,0,
  // 0x03c8  ψ
  24,39,234,29,3,246,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,85,0,15,224,1,84,255,0,15,224,3,252,255,0,15,224,3,252,255,0,15,224,2,252,255,0,15,224,2,253,255,0,15,224,1,254,255,0,15,224,0,254,255,0,15,224,0,254,255,0,15,224,0,255,255,0,15,224,0,255,255,0,15,224,0,255,255,0,15,224,0,255,255,0,15,224,0,254,255,0,15,224,1,254,191,0,15,224,2,253,127,128,15,224,7,252,63,208,15,224,31,244,47,249,15,225,191,240,15,255,255,255,255,192,2,255,255,255,254,0,0,47,255,255,224,0,0,0,31,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,15,224,0,0,0,0,0,0,0,0,
  // 0x03c9  ω
  27,22,154,31,2,255,0,85,0,0,0,84,0,3,252,0,0,0,255,0,11,244,0,0,0,63,128,15,240,0,0,0,47,192,47,208,0,0,0,15,224,63,192,0,0,0,15,240,63,192,0,0,0,11,244,127,128,0,169,0,7,248,127,64,1,253,0,7,248,191,64,1,253,0,3,248,191,64,1,253,0,3,252,191,64,1,253,0,3,252,191,64,1,253,0,3,248,127,64,1,253,0,7,248,127,128,1,254,0,7,244,63,192,2,255,0,15,240,47,208,3,255,0,31,240,31,244,11,239,192,127,208,11,255,255,207,255,255,192,3,255,255,67,255,255,0,0,191,253,0,255,248,0,0,1,64,0,5,64,0,
  // 0x03ca  ϊ
  255,
  // 0x03cb  ϋ
  255,
  // 0x03cc  ό
  19,31,155,23,2,255,0,0,5,84,0,0,0,15,248,0,0,0,15,240,0,0,0,47,208,0,0,0,63,192,0,0,0,63,0,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,
  // 0x03cd  ύ
  18,31,155,23,3,255,0,0,21,80,0,0,0,127,192,0,0,0,191,128,0,0,0,255,0,0,0,1,253,0,0,0,2,248,0,0,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,85,0,255,0,0,127,128,255,0,0,127,192,255,0,0,63,192,255,0,0,63,192,255,0,0,47,208,255,0,0,47,208,255,0,0,47,224,255,0,0,31,224,255,0,0,31,224,255,0,0,31,224,255,0,0,47,224,255,0,0,47,208,255,0,0,63,208,255,0,0,63,192,255,64,0,127,192,191,192,0,255,64,63,224,7,255,0,47,255,255,252,0,15,255,255,240,0,1,255,255,64,0,0,5,80,0,0,
  // 0x03ce  ώ
  27,31,217,31,2,255,0,0,0,5,84,0,0,0,0,0,15,248,0,0,0,0,0,15,240,0,0,0,0,0,47,208,0,0,0,0,0,63,192,0,0,0,0,0,63,0,0,0,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,0,84,0,3,252,0,0,0,255,0,11,244,0,0,0,63,128,15,240,0,0,0,47,192,47,208,0,0,0,15,224,63,192,0,0,0,15,240,63,192,0,0,0,11,244,127,128,0,169,0,7,248,127,64,1,253,0,7,248,191,64,1,253,0,3,248,191,64,1,253,0,3,252,191,64,1,253,0,3,252,191,64,1,253,0,3,248,127,64,1,253,0,7,248,127,128,1,254,0,7,244,63,192,2,255,0,15,240,47,208,3,255,0,31,240,31,244,11,239,192,127,208,11,255,255,207,255,255,192,3,255,255,67,255,255,0,0,191,253,0,255,248,0,0,1,64,0,5,64,0,
};

#endif // HAS_GRAPHICAL_TFT
