/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Cyrillic 38pt, capital 'A' height: 28px, width: 100%, range: 0x0401-0x0491, glyphs: 74
extern const uint8_t NotoSans_Medium_Cyrillic_28[10988] = {
  130,28,1,4,145,4,37,246, // unifont_t
  // 0x0401  Ё
  16,35,140,21,3,0,1,244,3,208,3,252,15,240,3,252,15,240,2,244,7,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x0402  Ђ
  255,
  // 0x0403  Ѓ
  255,
  // 0x0404  Є
  22,29,174,25,2,255,0,0,1,105,64,0,0,1,191,255,254,64,0,15,255,255,255,208,0,127,255,255,255,192,1,255,244,0,111,128,3,255,64,0,1,0,15,252,0,0,0,0,31,244,0,0,0,0,63,224,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,234,170,170,144,0,191,255,255,255,208,0,191,255,255,255,208,0,191,234,170,170,144,0,191,128,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,63,208,0,0,0,0,63,224,0,0,0,0,31,244,0,0,0,0,15,252,0,0,0,0,7,255,64,0,0,0,2,255,249,1,111,128,0,191,255,255,255,128,0,31,255,255,255,128,0,1,255,255,254,0,0,0,1,85,0,0,
  // 0x0405  Ѕ
  255,
  // 0x0406  І
  11,27,81,13,1,0,191,255,252,191,255,252,47,255,228,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,47,255,244,191,255,252,191,255,252,
  // 0x0407  Ї
  12,35,105,13,1,0,125,0,248,255,2,253,255,2,253,126,0,252,0,0,0,0,0,0,0,0,0,0,0,0,191,255,252,191,255,252,47,255,228,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,1,255,0,47,255,244,191,255,252,191,255,252,
  // 0x0408  Ј
  255,
  // 0x0409  Љ
  255,
  // 0x040a  Њ
  255,
  // 0x040b  Ћ
  255,
  // 0x040c  Ќ
  255,
  // 0x040d  Ѝ
  255,
  // 0x040e  Ў
  255,
  // 0x040f  Џ
  255,
  // 0x0410  А
  25,28,196,25,0,0,0,0,1,80,0,0,0,0,0,15,252,0,0,0,0,0,31,252,0,0,0,0,0,47,254,0,0,0,0,0,63,255,0,0,0,0,0,191,127,64,0,0,0,0,255,63,128,0,0,0,1,254,47,192,0,0,0,2,252,31,208,0,0,0,3,252,15,240,0,0,0,7,248,11,240,0,0,0,15,240,7,248,0,0,0,15,240,3,252,0,0,0,47,208,2,253,0,0,0,63,192,1,254,0,0,0,127,192,0,255,0,0,0,191,149,85,255,64,0,0,255,255,255,255,192,0,1,255,255,255,255,192,0,3,255,255,255,255,224,0,3,252,0,0,31,240,0,11,248,0,0,15,244,0,15,244,0,0,11,248,0,31,240,0,0,3,252,0,47,224,0,0,3,253,0,63,192,0,0,1,255,0,127,192,0,0,0,255,0,255,64,0,0,0,191,128,
  // 0x0411  Б
  19,27,135,24,3,0,127,255,255,255,192,127,255,255,255,192,127,255,255,255,192,127,213,85,85,64,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,255,254,144,0,127,255,255,253,0,127,255,255,255,128,127,234,171,255,224,127,128,0,127,240,127,128,0,15,244,127,128,0,11,248,127,128,0,7,248,127,128,0,7,248,127,128,0,11,248,127,128,0,15,244,127,128,0,127,240,127,213,107,255,224,127,255,255,255,128,127,255,255,253,0,127,255,255,144,0,
  // 0x0412  В
  20,27,135,25,3,0,127,255,255,228,0,127,255,255,255,128,127,255,255,255,224,127,213,86,255,244,127,128,0,31,252,127,128,0,11,252,127,128,0,3,252,127,128,0,3,252,127,128,0,7,252,127,128,0,15,244,127,128,0,127,240,127,255,255,255,128,127,255,255,248,0,127,255,255,255,64,127,234,170,255,240,127,128,0,31,252,127,128,0,3,253,127,128,0,2,254,127,128,0,1,255,127,128,0,1,255,127,128,0,2,255,127,128,0,3,254,127,128,0,15,252,127,213,86,255,248,127,255,255,255,240,127,255,255,255,64,127,255,255,228,0,
  // 0x0413  Г
  17,27,135,20,3,0,127,255,255,255,64,127,255,255,255,64,127,255,255,255,64,127,213,85,85,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,
  // 0x0414  Д
  27,35,245,27,0,248,0,0,63,255,255,252,0,0,0,63,255,255,252,0,0,0,63,255,255,252,0,0,0,63,213,91,252,0,0,0,127,128,7,252,0,0,0,127,64,7,252,0,0,0,191,64,7,252,0,0,0,255,0,7,252,0,0,0,255,0,7,252,0,0,1,254,0,7,252,0,0,2,253,0,7,252,0,0,3,252,0,7,252,0,0,3,252,0,7,252,0,0,7,248,0,7,252,0,0,15,244,0,7,252,0,0,15,240,0,7,252,0,0,47,224,0,7,252,0,0,63,192,0,7,252,0,0,127,192,0,7,252,0,0,255,64,0,7,252,0,0,255,0,0,7,252,0,2,254,0,0,7,252,0,3,252,0,0,7,252,0,111,254,170,170,171,254,160,255,255,255,255,255,255,244,255,255,255,255,255,255,244,255,255,255,255,255,255,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,255,0,0,0,0,11,244,85,0,0,0,0,5,80,
  // 0x0415  Е
  16,27,108,21,3,0,127,255,255,255,127,255,255,255,127,255,255,255,127,213,85,85,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,255,255,252,127,255,255,252,127,255,255,252,127,234,170,168,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,234,170,169,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x0416  Ж
  33,27,243,33,0,0,63,208,0,3,248,0,0,255,128,31,240,0,3,248,0,2,254,0,11,252,0,3,248,0,7,252,0,2,254,0,3,248,0,15,240,0,0,255,64,3,248,0,63,208,0,0,63,192,3,248,0,191,128,0,0,31,240,3,248,1,255,0,0,0,11,248,3,248,3,252,0,0,0,3,253,3,248,15,244,0,0,0,0,255,3,248,47,224,0,0,0,0,127,195,248,127,192,0,0,0,0,47,227,248,255,0,0,0,0,0,15,251,251,253,0,0,0,0,0,15,255,255,253,0,0,0,0,0,47,247,249,255,0,0,0,0,0,127,195,248,191,192,0,0,0,0,255,67,248,63,224,0,0,0,3,254,3,248,15,244,0,0,0,11,252,3,248,7,252,0,0,0,31,240,3,248,2,255,0,0,0,63,208,3,248,0,255,128,0,0,255,128,3,248,0,127,208,0,2,255,0,3,248,0,47,240,0,7,252,0,3,248,0,15,252,0,15,244,0,3,248,0,3,254,0,63,224,0,3,248,0,1,255,64,191,192,0,3,248,0,0,191,192,
  // 0x0417  З
  20,29,145,23,1,255,0,1,85,64,0,0,191,255,254,0,11,255,255,255,192,63,255,255,255,240,47,228,0,47,252,14,0,0,11,252,0,0,0,3,253,0,0,0,2,253,0,0,0,3,253,0,0,0,3,252,0,0,0,15,248,0,0,0,191,224,0,170,255,255,64,0,255,255,228,0,0,255,255,254,0,0,170,175,255,224,0,0,0,111,248,0,0,0,7,253,0,0,0,2,255,0,0,0,0,255,0,0,0,0,255,0,0,0,1,255,0,0,0,2,255,80,0,0,11,253,126,64,0,127,252,127,255,255,255,240,127,255,255,255,128,11,255,255,248,0,0,5,84,0,0,
  // 0x0418  И
  23,27,162,30,3,0,127,64,0,0,15,252,127,64,0,0,47,252,127,64,0,0,63,252,127,64,0,0,255,252,127,64,0,1,255,252,127,64,0,3,254,252,127,64,0,15,249,252,127,64,0,31,241,252,127,64,0,63,209,252,127,64,0,191,129,252,127,64,1,255,2,252,127,64,3,253,2,252,127,64,11,248,2,252,127,64,31,240,2,252,127,64,63,208,2,252,127,64,191,192,2,252,127,65,255,0,2,252,127,67,253,0,2,252,127,75,252,0,2,252,127,79,240,0,2,252,127,63,224,0,2,252,127,191,192,0,2,252,127,255,64,0,2,252,127,254,0,0,2,252,127,252,0,0,2,252,127,244,0,0,2,252,127,224,0,0,2,252,
  // 0x0419  Й
  23,36,216,30,3,0,0,42,64,0,106,0,0,63,128,0,255,0,0,63,192,1,254,0,0,31,249,91,252,0,0,11,255,255,244,0,0,1,255,255,128,0,0,0,1,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,64,0,0,15,252,127,64,0,0,47,252,127,64,0,0,63,252,127,64,0,0,255,252,127,64,0,1,255,252,127,64,0,3,254,252,127,64,0,15,249,252,127,64,0,31,241,252,127,64,0,63,209,252,127,64,0,191,129,252,127,64,1,255,2,252,127,64,3,253,2,252,127,64,11,248,2,252,127,64,31,240,2,252,127,64,63,208,2,252,127,64,191,192,2,252,127,65,255,0,2,252,127,67,253,0,2,252,127,75,252,0,2,252,127,79,240,0,2,252,127,63,224,0,2,252,127,191,192,0,2,252,127,255,64,0,2,252,127,254,0,0,2,252,127,252,0,0,2,252,127,244,0,0,2,252,127,224,0,0,2,252,
  // 0x041a  К
  21,27,162,24,3,0,127,128,0,2,255,0,127,128,0,7,252,0,127,128,0,31,244,0,127,128,0,63,208,0,127,128,0,255,128,0,127,128,3,254,0,0,127,128,11,252,0,0,127,128,47,240,0,0,127,128,127,192,0,0,127,129,255,64,0,0,127,131,253,0,0,0,127,143,248,0,0,0,127,255,240,0,0,0,127,255,224,0,0,0,127,159,248,0,0,0,127,135,253,0,0,0,127,130,255,64,0,0,127,128,191,192,0,0,127,128,63,240,0,0,127,128,15,252,0,0,127,128,3,254,0,0,127,128,1,255,64,0,127,128,0,191,208,0,127,128,0,47,240,0,127,128,0,15,252,0,127,128,0,3,255,0,127,128,0,0,255,128,
  // 0x041b  Л
  24,28,168,27,0,255,0,0,255,255,255,254,0,0,255,255,255,254,0,0,255,255,255,254,0,1,254,85,86,254,0,1,253,0,1,254,0,2,253,0,1,254,0,2,252,0,1,254,0,3,252,0,1,254,0,3,252,0,1,254,0,3,252,0,1,254,0,3,248,0,1,254,0,7,248,0,1,254,0,11,244,0,1,254,0,11,240,0,1,254,0,15,240,0,1,254,0,15,240,0,1,254,0,15,240,0,1,254,0,31,224,0,1,254,0,47,208,0,1,254,0,63,208,0,1,254,0,63,192,0,1,254,0,127,192,0,1,254,0,255,64,0,1,254,2,255,0,0,1,254,255,254,0,0,1,254,255,252,0,0,1,254,255,224,0,0,1,254,21,0,0,0,0,0,
  // 0x041c  М
  29,27,216,35,3,0,127,248,0,0,0,15,255,64,127,252,0,0,0,15,255,64,127,253,0,0,0,47,255,64,127,255,0,0,0,63,255,64,127,191,0,0,0,127,191,64,127,127,64,0,0,191,191,64,127,63,192,0,0,253,191,64,127,47,192,0,1,252,191,64,127,79,224,0,3,248,191,64,127,79,240,0,3,244,191,64,127,71,244,0,7,240,191,64,127,67,248,0,15,224,191,64,127,66,252,0,15,208,191,64,127,65,253,0,47,192,191,64,127,64,254,0,63,128,191,64,127,64,191,0,127,0,191,64,127,64,127,64,191,0,191,64,127,64,63,192,253,0,191,64,127,64,47,193,252,0,191,64,127,64,15,211,248,0,191,64,127,64,15,243,244,0,191,64,127,64,11,255,240,0,191,64,127,64,3,255,224,0,191,64,127,64,3,255,192,0,191,64,127,64,1,255,192,0,191,64,127,64,0,255,128,0,191,64,127,64,0,255,0,0,191,64,
  // 0x041d  Н
  22,27,162,28,3,0,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,255,255,255,255,240,127,255,255,255,255,240,127,255,255,255,255,240,127,234,170,170,175,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,
  // 0x041e  О
  26,29,203,30,2,255,0,0,5,165,0,0,0,0,2,255,255,248,0,0,0,47,255,255,255,64,0,0,191,255,255,255,224,0,2,255,228,1,191,248,0,7,255,0,0,15,253,0,15,252,0,0,3,255,0,47,240,0,0,1,255,64,63,224,0,0,0,255,128,63,208,0,0,0,127,192,127,192,0,0,0,63,192,191,192,0,0,0,63,208,191,128,0,0,0,63,208,191,128,0,0,0,63,224,191,128,0,0,0,63,224,191,128,0,0,0,63,208,191,128,0,0,0,63,208,127,192,0,0,0,63,208,127,192,0,0,0,63,192,63,208,0,0,0,191,192,63,240,0,0,0,255,128,31,244,0,0,1,255,0,15,252,0,0,3,254,0,7,255,0,0,31,252,0,2,255,228,1,255,244,0,0,191,255,255,255,208,0,0,31,255,255,255,0,0,0,1,255,255,228,0,0,0,0,1,84,0,0,0,
  // 0x041f  П
  22,27,162,28,3,0,127,255,255,255,255,208,127,255,255,255,255,208,127,255,255,255,255,208,127,213,85,85,127,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,127,128,0,0,63,208,
  // 0x0420  Р
  19,27,135,23,3,0,127,255,255,144,0,127,255,255,253,0,127,255,255,255,64,127,213,91,255,192,127,128,0,127,224,127,128,0,47,240,127,128,0,15,244,127,128,0,15,244,127,128,0,15,244,127,128,0,15,244,127,128,0,31,240,127,128,0,63,224,127,128,1,255,192,127,255,255,255,128,127,255,255,253,0,127,255,255,224,0,127,234,169,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,
  // 0x0421  С
  21,29,174,24,2,255,0,0,5,85,0,0,0,1,255,255,249,0,0,31,255,255,255,128,0,127,255,255,255,0,1,255,244,1,191,0,3,255,64,0,4,0,15,252,0,0,0,0,31,244,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,128,0,0,0,0,191,192,0,0,0,0,127,192,0,0,0,0,63,208,0,0,0,0,63,240,0,0,0,0,31,244,0,0,0,0,15,252,0,0,0,0,7,255,64,0,0,0,2,255,249,1,111,0,0,191,255,255,255,0,0,31,255,255,255,0,0,2,255,255,249,0,0,0,1,84,0,0,
  // 0x0422  Т
  21,27,162,21,0,0,191,255,255,255,255,192,191,255,255,255,255,192,191,255,255,255,255,192,21,85,191,213,85,64,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,
  // 0x0423  У
  24,28,168,24,0,255,127,192,0,0,1,255,63,224,0,0,3,253,31,240,0,0,7,252,11,248,0,0,11,248,3,252,0,0,15,240,2,254,0,0,47,224,0,255,0,0,63,192,0,191,128,0,127,192,0,63,192,0,255,64,0,47,224,1,255,0,0,15,240,2,253,0,0,11,248,3,252,0,0,3,252,11,248,0,0,2,253,15,240,0,0,0,255,31,224,0,0,0,191,127,192,0,0,0,63,255,192,0,0,0,47,255,64,0,0,0,15,255,0,0,0,0,11,253,0,0,0,0,15,252,0,0,0,0,31,244,0,0,0,0,127,240,0,0,30,86,255,208,0,0,31,255,255,64,0,0,31,255,253,0,0,0,31,255,224,0,0,0,0,84,0,0,0,0,
  // 0x0424  Ф
  28,29,203,31,2,255,0,0,0,169,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,6,255,255,254,64,0,0,191,255,255,255,248,0,3,255,255,255,255,255,64,15,255,150,254,91,255,192,47,248,1,254,0,127,240,63,208,1,254,0,15,244,191,128,1,254,0,11,252,255,64,1,254,0,3,252,255,0,1,254,0,3,252,255,0,1,254,0,3,253,255,0,1,254,0,3,253,255,0,1,254,0,3,252,255,64,1,254,0,3,252,191,128,1,254,0,11,248,63,208,1,254,0,31,244,47,248,1,254,0,127,240,15,255,145,254,27,255,192,3,255,255,255,255,255,0,0,127,255,255,255,248,0,0,6,255,255,254,64,0,0,0,2,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,1,254,0,0,0,0,0,0,84,0,0,0,
  // 0x0425  Х
  23,27,162,23,0,0,63,224,0,0,31,240,31,244,0,0,63,208,11,252,0,0,191,128,3,253,0,0,255,0,1,255,0,3,253,0,0,191,128,7,252,0,0,63,208,15,240,0,0,31,240,47,208,0,0,11,248,127,192,0,0,3,252,255,0,0,0,1,255,254,0,0,0,0,255,252,0,0,0,0,63,244,0,0,0,0,127,244,0,0,0,0,255,252,0,0,0,2,255,254,0,0,0,3,252,255,64,0,0,15,244,127,192,0,0,31,224,63,224,0,0,63,192,15,240,0,0,191,64,11,252,0,1,255,0,3,254,0,3,253,0,1,255,0,11,248,0,0,191,192,31,240,0,0,63,208,63,208,0,0,47,240,191,192,0,0,15,248,
  // 0x0426  Ц
  25,35,245,29,3,248,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,128,0,0,63,208,0,127,234,170,170,191,229,64,127,255,255,255,255,255,192,127,255,255,255,255,255,192,127,255,255,255,255,255,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,21,64,
  // 0x0427  Ч
  22,27,162,27,2,0,127,192,0,0,63,208,127,192,0,0,63,208,127,192,0,0,63,208,127,192,0,0,63,208,127,192,0,0,63,208,127,192,0,0,63,208,127,192,0,0,63,208,127,192,0,0,63,208,127,192,0,0,63,208,127,192,0,0,63,208,127,192,0,0,63,208,63,192,0,0,63,208,63,208,0,0,63,208,63,244,0,7,255,208,31,255,255,255,255,208,11,255,255,255,255,208,1,255,255,254,127,208,0,26,170,64,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,0,0,0,0,63,208,
  // 0x0428  Ш
  33,27,243,40,3,0,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,128,0,3,252,0,0,63,192,127,234,170,171,254,170,170,191,192,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,
  // 0x0429  Щ
  37,35,94,40,3,248,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,128,0,7,252,0,0,63,192,0,127,234,170,171,254,170,170,191,213,0,127,255,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,0,21,0,
  // 0x042a  Ъ
  25,27,189,27,0,0,255,255,252,0,0,0,0,255,255,252,0,0,0,0,255,255,252,0,0,0,0,85,91,252,0,0,0,0,0,7,252,0,0,0,0,0,7,252,0,0,0,0,0,7,252,0,0,0,0,0,7,252,0,0,0,0,0,7,252,0,0,0,0,0,7,252,0,0,0,0,0,7,252,0,0,0,0,0,7,255,255,233,0,0,0,7,255,255,255,208,0,0,7,255,255,255,248,0,0,7,254,170,191,254,0,0,7,252,0,7,255,0,0,7,252,0,0,255,64,0,7,252,0,0,191,128,0,7,252,0,0,127,192,0,7,252,0,0,127,192,0,7,252,0,0,191,128,0,7,252,0,0,255,64,0,7,252,0,7,255,0,0,7,253,86,191,253,0,0,7,255,255,255,248,0,0,7,255,255,255,208,0,0,7,255,255,249,0,0,
  // 0x042b  Ы
  27,27,189,33,3,0,127,128,0,0,0,11,248,127,128,0,0,0,11,248,127,128,0,0,0,11,248,127,128,0,0,0,11,248,127,128,0,0,0,11,248,127,128,0,0,0,11,248,127,128,0,0,0,11,248,127,128,0,0,0,11,248,127,128,0,0,0,11,248,127,128,0,0,0,11,248,127,128,0,0,0,11,248,127,255,254,64,0,11,248,127,255,255,252,0,11,248,127,255,255,255,64,11,248,127,234,175,255,192,11,248,127,128,0,127,240,11,248,127,128,0,31,240,11,248,127,128,0,15,244,11,248,127,128,0,11,244,11,248,127,128,0,15,244,11,248,127,128,0,15,244,11,248,127,128,0,31,240,11,248,127,128,0,127,240,11,248,127,213,91,255,192,11,248,127,255,255,255,64,11,248,127,255,255,252,0,11,248,127,255,254,128,0,11,248,
  // 0x042c  Ь
  20,27,135,24,3,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,255,255,144,0,127,255,255,254,0,127,255,255,255,208,127,234,171,255,240,127,128,0,31,252,127,128,0,7,252,127,128,0,3,253,127,128,0,3,253,127,128,0,3,253,127,128,0,3,253,127,128,0,7,252,127,128,0,47,248,127,213,90,255,240,127,255,255,255,208,127,255,255,255,0,127,255,255,160,0,
  // 0x042d  Э
  21,29,174,24,1,255,0,21,84,0,0,0,27,255,255,224,0,0,191,255,255,254,0,0,63,255,255,255,192,0,63,144,6,255,240,0,4,0,0,47,252,0,0,0,0,11,253,0,0,0,0,3,255,0,0,0,0,0,255,0,0,0,0,0,255,128,0,0,0,0,191,128,0,0,0,0,127,192,0,255,255,255,255,192,0,255,255,255,255,192,0,255,255,255,255,192,0,170,170,170,255,192,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,255,64,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,11,252,0,0,0,0,63,248,0,126,80,27,255,240,0,127,255,255,255,192,0,127,255,255,253,0,0,47,255,255,208,0,0,0,21,80,0,0,0,
  // 0x042e  Ю
  35,29,5,40,3,255,0,0,0,0,0,90,80,0,0,127,128,0,0,47,255,255,64,0,127,128,0,1,255,255,255,240,0,127,128,0,11,255,255,255,252,0,127,128,0,31,254,64,31,255,0,127,128,0,63,240,0,1,255,128,127,128,0,191,192,0,0,127,192,127,128,0,255,128,0,0,63,224,127,128,1,255,0,0,0,31,240,127,128,2,254,0,0,0,15,244,127,128,3,253,0,0,0,15,248,127,128,3,252,0,0,0,11,248,127,255,255,252,0,0,0,11,252,127,255,255,252,0,0,0,7,252,127,255,255,252,0,0,0,7,252,127,234,171,252,0,0,0,7,252,127,128,3,252,0,0,0,11,248,127,128,3,253,0,0,0,11,248,127,128,3,253,0,0,0,15,244,127,128,2,254,0,0,0,15,240,127,128,1,255,0,0,0,31,240,127,128,0,255,128,0,0,63,224,127,128,0,191,208,0,0,191,192,127,128,0,63,244,0,2,255,128,127,128,0,31,255,64,111,255,0,127,128,0,7,255,255,255,252,0,127,128,0,0,255,255,255,224,0,127,128,0,0,27,255,254,0,0,0,0,0,0,0,21,64,0,0,
  // 0x042f  Я
  20,27,135,25,1,0,0,2,255,255,255,0,63,255,255,255,1,255,255,255,255,3,255,229,85,255,11,253,0,0,255,15,248,0,0,255,15,240,0,0,255,15,240,0,0,255,15,240,0,0,255,15,244,0,0,255,11,252,0,0,255,7,254,0,0,255,2,255,233,85,255,0,191,255,255,255,0,31,255,255,255,0,3,255,255,255,0,11,248,0,255,0,31,240,0,255,0,63,208,0,255,0,191,192,0,255,1,255,64,0,255,3,254,0,0,255,11,252,0,0,255,15,244,0,0,255,63,240,0,0,255,191,192,0,0,255,255,128,0,0,255,
  // 0x0430  а
  18,22,110,22,1,255,0,6,255,144,0,1,255,255,253,0,3,255,255,255,64,1,254,86,255,192,0,144,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,15,240,0,0,21,111,240,0,111,255,255,240,3,255,255,255,240,15,255,148,31,240,47,240,0,15,240,63,208,0,31,240,63,192,0,31,240,127,192,0,47,240,63,192,0,127,240,63,240,2,255,240,47,255,255,239,240,15,255,255,139,240,1,255,253,3,240,0,5,64,0,0,
  // 0x0431  б
  19,30,150,23,2,255,0,0,0,22,244,0,0,111,255,248,0,11,255,255,248,0,127,255,255,228,1,255,254,80,0,7,255,64,0,0,15,248,0,0,0,31,240,0,0,0,63,192,0,0,0,63,192,0,0,0,127,129,191,228,0,191,75,255,255,0,191,127,255,255,192,255,255,65,191,224,255,244,0,31,240,255,208,0,15,248,255,64,0,7,252,255,0,0,7,252,255,64,0,3,252,255,64,0,3,252,191,64,0,3,252,127,128,0,7,252,63,192,0,7,248,63,208,0,15,244,31,240,0,47,240,15,253,0,191,208,3,255,255,255,128,0,255,255,254,0,0,31,255,224,0,0,0,84,0,0,
  // 0x0432  в
  18,21,105,23,3,0,85,85,85,0,0,255,255,255,244,0,255,255,255,255,0,255,170,175,255,128,255,0,0,191,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,64,22,255,0,255,255,255,248,0,255,255,255,228,0,255,255,255,255,0,255,0,0,191,192,255,0,0,47,224,255,0,0,31,224,255,0,0,31,224,255,0,0,63,224,255,0,1,255,192,255,255,255,255,128,255,255,255,253,0,255,255,255,144,0,
  // 0x0433  г
  13,21,84,17,3,0,85,85,85,64,255,255,255,192,255,255,255,192,255,255,255,192,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,
  // 0x0434  д
  23,29,174,23,0,248,0,1,85,85,84,0,0,2,255,255,253,0,0,2,255,255,253,0,0,3,254,171,253,0,0,3,252,2,253,0,0,3,248,2,253,0,0,3,248,2,253,0,0,7,244,2,253,0,0,11,240,2,253,0,0,15,240,2,253,0,0,15,224,2,253,0,0,47,208,2,253,0,0,63,192,2,253,0,0,127,128,2,253,0,0,255,64,2,253,0,1,255,0,2,253,0,3,253,0,2,253,0,11,252,0,2,253,0,127,255,255,255,255,244,127,255,255,255,255,244,127,255,255,255,255,244,127,64,0,0,7,244,127,64,0,0,7,244,127,64,0,0,7,244,127,64,0,0,7,244,127,64,0,0,7,244,127,64,0,0,7,244,127,64,0,0,7,244,0,0,0,0,0,0,
  // 0x0435  е
  18,22,110,22,2,255,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,
  // 0x0436  ж
  30,21,168,30,0,0,21,64,0,21,64,0,21,64,31,240,0,63,192,0,255,64,11,248,0,63,192,3,253,0,3,253,0,63,192,11,248,0,0,255,64,63,192,31,240,0,0,63,192,63,192,63,192,0,0,31,240,63,192,255,0,0,0,7,248,63,195,253,0,0,0,2,253,63,203,244,0,0,0,0,255,127,223,224,0,0,0,0,127,255,255,192,0,0,0,0,255,127,223,240,0,0,0,3,253,63,203,248,0,0,0,11,248,63,195,253,0,0,0,31,240,63,192,255,64,0,0,127,192,63,192,63,192,0,0,255,0,63,192,31,240,0,3,253,0,63,192,11,252,0,15,248,0,63,192,2,254,0,47,224,0,63,192,0,255,128,191,192,0,63,192,0,63,208,
  // 0x0437  з
  17,22,110,19,1,255,1,175,249,0,0,63,255,255,224,0,63,255,255,252,0,47,229,91,254,0,4,0,0,255,0,0,0,0,191,0,0,0,0,191,0,0,0,1,254,0,0,0,91,252,0,0,191,255,224,0,0,191,255,128,0,0,191,255,248,0,0,0,7,255,0,0,0,0,255,64,0,0,0,127,128,0,0,0,127,128,0,0,0,191,128,185,0,6,255,0,191,255,255,254,0,191,255,255,248,0,47,255,255,128,0,0,21,80,0,0,
  // 0x0438  и
  19,21,105,25,3,0,85,0,0,5,84,255,0,0,31,252,255,0,0,63,252,255,0,0,191,252,255,0,1,255,252,255,0,3,254,252,255,0,11,246,252,255,0,31,226,252,255,0,63,194,252,255,0,191,66,252,255,0,255,2,252,255,3,252,2,252,255,11,248,2,252,255,15,240,2,252,255,63,208,2,252,255,127,128,2,252,255,255,0,2,252,255,253,0,2,252,255,248,0,2,252,255,240,0,2,252,255,208,0,2,252,
  // 0x0439  й
  19,29,145,25,3,0,11,240,0,15,224,7,244,0,31,208,3,252,0,127,192,2,255,171,255,64,0,191,255,253,0,0,11,255,144,0,0,0,0,0,0,0,0,0,0,0,85,0,0,5,84,255,0,0,31,252,255,0,0,63,252,255,0,0,191,252,255,0,1,255,252,255,0,3,254,252,255,0,11,246,252,255,0,31,226,252,255,0,63,194,252,255,0,191,66,252,255,0,255,2,252,255,3,252,2,252,255,11,248,2,252,255,15,240,2,252,255,63,208,2,252,255,127,128,2,252,255,255,0,2,252,255,253,0,2,252,255,248,0,2,252,255,240,0,2,252,255,208,0,2,252,
  // 0x043a  к
  18,21,105,21,3,0,85,0,0,85,64,255,0,0,255,0,255,0,3,253,0,255,0,15,244,0,255,0,47,224,0,255,0,191,128,0,255,1,255,0,0,255,7,252,0,0,255,15,240,0,0,255,127,208,0,0,255,255,128,0,0,255,127,224,0,0,255,15,244,0,0,255,7,253,0,0,255,1,255,0,0,255,0,191,192,0,255,0,47,240,0,255,0,15,248,0,255,0,3,254,0,255,0,0,255,64,255,0,0,127,208,
  // 0x043b  л
  20,22,110,23,0,255,0,5,85,85,85,0,15,255,255,254,0,15,255,255,254,0,15,255,255,254,0,15,224,2,254,0,15,224,2,254,0,15,208,2,254,0,31,208,2,254,0,31,208,2,254,0,47,192,2,254,0,63,192,2,254,0,63,192,2,254,0,63,128,2,254,0,127,64,2,254,0,191,0,2,254,0,255,0,2,254,2,254,0,2,254,7,253,0,2,254,255,252,0,2,254,255,240,0,2,254,255,192,0,2,254,4,0,0,0,0,
  // 0x043c  м
  24,21,126,29,3,0,85,80,0,0,5,84,255,240,0,0,47,253,255,244,0,0,63,253,255,252,0,0,127,253,255,252,0,0,191,253,254,254,0,0,254,253,255,191,0,1,253,253,255,63,64,3,249,253,255,63,128,7,241,253,255,31,192,11,241,253,255,15,208,15,209,253,255,11,240,31,193,253,255,3,244,63,129,253,255,3,248,63,65,253,255,1,252,191,1,253,255,0,253,253,1,253,255,0,191,252,1,253,255,0,127,248,1,253,255,0,63,244,1,253,255,0,47,240,1,253,255,0,15,208,1,253,
  // 0x043d  н
  19,21,105,24,3,0,85,0,0,5,80,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,255,64,0,11,244,255,255,255,255,244,255,255,255,255,244,255,255,255,255,244,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,255,0,0,11,244,
  // 0x043e  о
  19,22,110,23,2,255,0,6,254,64,0,0,191,255,248,0,3,255,255,255,0,15,255,171,255,192,47,244,0,127,224,63,208,0,15,240,127,192,0,11,248,191,128,0,7,252,255,64,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,64,0,3,252,191,128,0,7,248,63,192,0,15,244,63,224,0,47,240,15,253,0,191,208,7,255,255,255,128,1,255,255,254,0,0,47,255,224,0,0,0,84,0,0,
  // 0x043f  п
  18,21,105,24,3,0,85,85,85,85,80,255,255,255,255,240,255,255,255,255,240,255,255,255,255,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,
  // 0x0440  р
  19,31,155,24,3,246,84,1,191,128,0,254,15,255,248,0,255,63,255,255,0,255,254,155,255,192,255,240,0,191,208,255,192,0,47,240,255,128,0,15,240,255,64,0,15,244,255,64,0,11,244,255,0,0,11,248,255,0,0,11,248,255,0,0,11,248,255,64,0,11,244,255,64,0,15,244,255,128,0,15,240,255,192,0,47,240,255,224,0,63,224,255,248,1,255,192,255,255,255,255,64,255,63,255,253,0,255,7,255,224,0,255,0,21,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,0,0,0,0,0,
  // 0x0441  с
  15,22,88,19,2,255,0,6,254,144,0,191,255,252,3,255,255,252,15,255,171,248,47,244,0,16,63,208,0,0,127,192,0,0,191,128,0,0,255,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,64,0,0,191,128,0,0,127,192,0,0,63,240,0,0,31,253,0,124,11,255,255,252,2,255,255,252,0,47,255,244,0,0,84,0,
  // 0x0442  т
  17,21,105,19,1,0,85,85,85,85,64,255,255,255,255,192,255,255,255,255,192,255,255,255,255,192,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,0,11,244,0,0,
  // 0x0443  у
  20,31,155,20,0,246,85,0,0,0,85,191,128,0,2,254,63,192,0,3,253,63,208,0,7,252,31,240,0,11,248,15,240,0,15,240,11,248,0,31,240,3,252,0,47,208,3,253,0,63,192,1,254,0,127,128,0,255,0,255,64,0,191,64,255,0,0,63,129,254,0,0,63,195,252,0,0,31,211,252,0,0,15,231,244,0,0,11,251,240,0,0,3,255,224,0,0,3,255,192,0,0,1,255,192,0,0,0,255,64,0,0,0,255,0,0,0,1,254,0,0,0,2,253,0,0,0,3,252,0,0,0,15,244,0,0,16,127,240,0,0,127,255,192,0,0,127,255,64,0,0,127,248,0,0,0,0,0,0,0,0,
  // 0x0444  ф
  25,39,17,29,2,246,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,111,249,64,0,0,0,47,255,255,248,0,0,1,255,255,255,255,128,0,7,255,239,251,255,224,0,15,253,11,240,47,248,0,63,240,11,240,7,253,0,127,192,11,240,2,255,0,191,128,11,240,0,255,0,255,64,11,240,0,255,64,255,0,11,240,0,191,64,255,0,11,240,0,191,128,255,0,11,240,0,191,128,255,64,11,240,0,191,64,255,64,11,240,0,255,0,127,192,11,240,1,255,0,63,208,11,240,3,254,0,31,244,11,240,15,252,0,11,255,75,240,191,244,0,2,255,255,255,255,208,0,0,127,255,255,255,0,0,0,7,255,255,228,0,0,0,0,11,244,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,0,0,0,0,0,
  // 0x0445  х
  19,21,105,21,1,0,85,64,0,5,84,127,192,0,31,240,47,240,0,63,208,15,244,0,255,128,7,252,1,255,0,2,255,3,253,0,0,255,75,248,0,0,127,239,240,0,0,47,255,192,0,0,15,255,128,0,0,7,255,0,0,0,15,255,64,0,0,47,255,192,0,0,63,239,240,0,0,255,79,248,0,2,255,3,253,0,7,252,1,255,0,15,244,0,255,128,47,240,0,63,208,127,192,0,31,240,255,64,0,15,252,
  // 0x0446  ц
  21,29,174,25,3,248,85,0,0,5,80,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,64,0,15,244,0,255,255,255,255,255,192,255,255,255,255,255,192,255,255,255,255,255,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,0,0,
  // 0x0447  ч
  19,21,105,24,2,0,21,64,0,1,84,127,128,0,7,248,127,128,0,7,248,127,128,0,7,248,127,128,0,7,248,127,128,0,7,248,127,128,0,7,248,127,128,0,7,248,127,192,0,7,248,63,192,0,11,248,63,224,1,191,248,47,255,255,255,248,15,255,255,251,248,1,255,254,71,248,0,5,64,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,0,0,0,7,248,
  // 0x0448  ш
  29,21,168,35,3,0,85,0,0,85,0,0,21,64,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,64,0,191,128,0,127,128,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,128,
  // 0x0449  щ
  32,29,232,35,3,248,85,0,0,85,0,0,21,64,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,0,0,191,64,0,127,128,255,64,0,191,128,0,127,192,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,
  // 0x044a  ъ
  25,21,147,27,0,0,21,85,84,0,0,0,0,191,255,252,0,0,0,0,191,255,252,0,0,0,0,127,255,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,253,0,0,0,0,0,3,255,255,255,144,0,0,3,255,255,255,252,0,0,3,255,255,255,255,0,0,3,252,0,2,255,64,0,3,252,0,0,191,128,0,3,252,0,0,127,192,0,3,252,0,0,127,128,0,3,252,0,0,191,128,0,3,252,0,7,255,0,0,3,255,255,255,253,0,0,3,255,255,255,244,0,0,3,255,255,254,64,0,
  // 0x044b  ы
  24,21,126,30,3,0,85,0,0,0,0,85,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,0,0,0,0,255,255,64,0,0,0,255,255,255,255,208,0,255,255,255,255,252,0,255,255,255,255,255,0,255,255,0,1,255,128,255,255,0,0,127,192,255,255,0,0,63,192,255,255,0,0,63,192,255,255,0,0,191,128,255,255,0,6,255,64,255,255,255,255,254,0,255,255,255,255,248,0,255,255,255,254,128,0,255,
  // 0x044c  ь
  18,21,105,23,3,0,85,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,64,0,0,0,255,255,255,244,0,255,255,255,255,0,255,255,255,255,192,255,0,0,127,224,255,0,0,31,240,255,0,0,15,240,255,0,0,15,240,255,0,0,47,224,255,0,1,191,208,255,255,255,255,128,255,255,255,254,0,255,255,255,160,0,
  // 0x044d  э
  16,22,88,19,1,255,6,191,144,0,127,255,254,0,63,255,255,208,63,150,255,240,0,0,15,248,0,0,3,252,0,0,2,253,0,0,1,254,0,0,1,255,11,255,255,255,11,255,255,255,11,255,255,255,0,0,0,255,0,0,1,254,0,0,2,254,0,0,3,252,0,0,15,252,228,0,127,240,255,255,255,208,255,255,255,64,127,255,248,0,0,85,0,0,
  // 0x044e  ю
  27,22,154,32,3,255,85,0,0,2,191,144,0,255,0,0,63,255,252,0,255,0,1,255,255,255,64,255,0,3,255,170,255,192,255,0,11,252,0,63,240,255,0,15,240,0,15,244,255,0,47,224,0,11,248,255,0,63,208,0,3,252,255,64,63,192,0,3,252,255,255,255,192,0,3,252,255,255,255,192,0,3,252,255,255,255,192,0,3,252,255,0,63,192,0,3,252,255,0,63,192,0,3,252,255,0,47,208,0,7,252,255,0,31,240,0,11,248,255,0,15,244,0,31,240,255,0,7,254,0,127,224,255,0,2,255,255,255,192,255,0,0,191,255,254,0,255,0,0,31,255,244,0,0,0,0,0,85,0,0,
  // 0x044f  я
  18,21,105,22,1,0,0,5,85,85,64,1,255,255,255,208,11,255,255,255,208,47,254,170,191,208,63,224,0,47,208,63,192,0,47,208,127,128,0,47,208,127,128,0,47,208,63,192,0,47,208,47,248,0,47,208,15,255,255,255,208,3,255,255,255,208,0,127,255,255,208,0,127,128,47,208,0,255,0,47,208,3,253,0,47,208,11,252,0,47,208,15,240,0,47,208,63,224,0,47,208,191,192,0,47,208,255,64,0,47,208,
  // 0x0450  ѐ
  255,
  // 0x0451  ё
  18,29,145,22,2,255,0,248,2,224,0,2,252,7,244,0,2,253,7,244,0,0,248,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,254,64,0,0,191,255,244,0,3,255,255,253,0,15,254,87,255,0,47,240,0,191,192,63,192,0,63,192,127,128,0,31,224,191,64,0,31,224,255,85,85,95,240,255,255,255,255,240,255,255,255,255,240,255,170,170,170,160,255,0,0,0,0,255,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,240,0,0,0,31,253,0,7,192,7,255,255,255,192,1,255,255,255,192,0,47,255,254,0,0,0,85,0,0,
  // 0x0452  ђ
  255,
  // 0x0453  ѓ
  255,
  // 0x0454  є
  16,22,88,19,2,255,0,6,255,144,0,191,255,254,3,255,255,253,15,255,150,252,47,244,0,4,63,208,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,255,255,224,255,255,255,224,255,255,255,224,255,0,0,0,255,64,0,0,191,128,0,0,127,192,0,0,63,224,0,0,31,253,0,29,11,255,255,253,2,255,255,253,0,47,255,248,0,0,85,0,
  // 0x0455  ѕ
  255,
  // 0x0456  і
  5,28,56,10,3,0,191,0,255,64,255,64,191,0,4,0,0,0,0,0,85,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,
  // 0x0457  ї
  12,28,84,10,255,0,46,0,124,127,128,254,127,128,255,63,0,189,0,0,0,0,0,0,0,0,0,0,85,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,
  // 0x0458  ј
  255,
  // 0x0459  љ
  255,
  // 0x045a  њ
  255,
  // 0x045b  ћ
  255,
  // 0x045c  ќ
  255,
  // 0x045d  ѝ
  255,
  // 0x045e  ў
  255,
  // 0x045f  џ
  255,
  // 0x0460  Ѡ
  255,
  // 0x0461  ѡ
  255,
  // 0x0462  Ѣ
  255,
  // 0x0463  ѣ
  255,
  // 0x0464  Ѥ
  255,
  // 0x0465  ѥ
  255,
  // 0x0466  Ѧ
  255,
  // 0x0467  ѧ
  255,
  // 0x0468  Ѩ
  255,
  // 0x0469  ѩ
  255,
  // 0x046a  Ѫ
  255,
  // 0x046b  ѫ
  255,
  // 0x046c  Ѭ
  255,
  // 0x046d  ѭ
  255,
  // 0x046e  Ѯ
  255,
  // 0x046f  ѯ
  255,
  // 0x0470  Ѱ
  255,
  // 0x0471  ѱ
  255,
  // 0x0472  Ѳ
  255,
  // 0x0473  ѳ
  255,
  // 0x0474  Ѵ
  255,
  // 0x0475  ѵ
  255,
  // 0x0476  Ѷ
  255,
  // 0x0477  ѷ
  255,
  // 0x0478  Ѹ
  255,
  // 0x0479  ѹ
  255,
  // 0x047a  Ѻ
  255,
  // 0x047b  ѻ
  255,
  // 0x047c  Ѽ
  255,
  // 0x047d  ѽ
  255,
  // 0x047e  Ѿ
  255,
  // 0x047f  ѿ
  255,
  // 0x0480  Ҁ
  255,
  // 0x0481  ҁ
  255,
  // 0x0482  ҂
  255,
  // 0x0483  ҃
  255,
  // 0x0484  ҄
  255,
  // 0x0485  ҅
  255,
  // 0x0486  ҆
  255,
  // 0x0487  ҇
  255,
  // 0x0488  ҈
  255,
  // 0x0489  ҉
  255,
  // 0x048a  Ҋ
  255,
  // 0x048b  ҋ
  255,
  // 0x048c  Ҍ
  255,
  // 0x048d  ҍ
  255,
  // 0x048e  Ҏ
  255,
  // 0x048f  ҏ
  255,
  // 0x0490  Ґ
  17,33,165,21,3,0,0,0,0,47,128,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,127,255,255,255,192,127,255,255,255,192,127,255,255,255,192,127,213,85,85,64,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,
  // 0x0491  ґ
  14,27,108,17,3,0,0,0,5,64,0,0,31,208,0,0,31,208,0,0,31,208,0,0,31,208,0,0,31,208,85,85,111,208,255,255,255,208,255,255,255,208,255,170,170,144,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
