/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Traditional Chinese 37pt, capital 'A' height: 27px, width: 100%, range: 0x22bf-0xff1a, glyphs: 307
extern const uint8_t NotoSans_Medium_Traditional_Chinese_27[20513] = {
  162,27,191,34,26,255,35,247, // unifont_t
  // 0x22bf  ⊿
  191,34,29,30,240,37,3,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,2,192,0,0,0,0,0,0,11,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,191,192,0,0,0,0,0,2,255,192,0,0,0,0,0,11,255,192,0,0,0,0,0,47,239,192,0,0,0,0,0,191,143,192,0,0,0,0,2,254,15,192,0,0,0,0,11,248,15,192,0,0,0,0,47,224,15,192,0,0,0,0,191,128,15,192,0,0,0,2,254,0,15,192,0,0,0,11,248,0,15,192,0,0,0,31,224,0,15,192,0,0,0,127,128,0,15,192,0,0,1,255,0,0,15,192,0,0,7,252,0,0,15,192,0,0,31,240,0,0,15,192,0,0,127,192,0,0,15,192,0,1,255,0,0,0,15,192,0,7,252,0,0,0,15,192,0,31,240,0,0,0,15,192,0,127,192,0,0,0,15,192,1,255,0,0,0,0,15,192,7,255,255,255,255,255,255,192,31,255,255,255,255,255,255,192,127,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0x4e00  一
  0,78,35,4,36,37,1,13,63,255,255,255,255,255,255,255,244,127,255,255,255,255,255,255,255,244,127,255,255,255,255,255,255,255,244,127,255,255,255,255,255,255,255,244,
  // 0x4e09  三
  9,78,33,30,14,37,2,255,1,85,85,85,85,85,85,80,0,7,255,255,255,255,255,255,244,0,7,255,255,255,255,255,255,244,0,7,255,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,254,0,0,0,63,255,255,255,255,254,0,0,0,63,255,255,255,255,254,0,0,0,26,170,170,170,170,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,21,85,85,85,85,85,85,85,0,
  // 0x4e0a  上
  10,78,33,33,41,37,2,255,0,0,0,5,64,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,255,255,255,248,0,0,0,0,47,255,255,255,248,0,0,0,0,47,255,255,255,248,0,0,0,0,47,229,85,85,80,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,85,85,85,127,229,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x4e0b  下
  11,78,33,32,32,37,2,253,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,106,170,170,175,250,170,170,170,64,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,232,0,0,0,0,0,0,0,15,255,128,0,0,0,0,0,0,15,255,248,0,0,0,0,0,0,15,255,255,64,0,0,0,0,0,15,231,255,240,0,0,0,0,0,15,224,191,254,0,0,0,0,0,15,224,15,255,192,0,0,0,0,15,224,1,255,248,0,0,0,0,15,224,0,63,248,0,0,0,0,15,224,0,11,240,0,0,0,0,15,224,0,1,192,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,208,0,0,0,0,
  // 0x4e0d  不
  13,78,33,33,41,37,2,253,21,85,85,85,85,85,85,85,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,0,0,255,64,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,191,244,0,0,0,0,0,0,2,255,244,176,0,0,0,0,0,7,255,246,253,0,0,0,0,0,31,255,251,255,128,0,0,0,0,127,247,244,191,240,0,0,0,2,255,199,244,31,253,0,0,0,11,255,7,244,7,255,128,0,0,63,252,7,244,0,255,224,0,1,255,240,7,244,0,47,252,0,15,255,128,7,244,0,11,255,0,191,253,0,7,244,0,2,255,192,255,240,0,7,244,0,0,127,192,63,128,0,7,244,0,0,47,0,28,0,0,7,244,0,0,4,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,
  // 0x4e26  並
  38,78,33,34,50,37,2,254,0,1,128,0,0,0,228,0,0,0,15,240,0,0,2,254,0,0,0,7,244,0,0,3,252,0,0,0,3,252,0,0,11,244,0,0,0,0,254,0,0,15,240,0,0,0,0,255,0,0,47,192,0,0,0,0,126,0,0,63,128,0,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,21,85,91,249,91,245,85,85,0,0,0,3,240,7,240,0,0,0,0,0,3,240,7,240,0,0,0,0,0,3,240,7,240,1,0,0,2,240,3,240,7,240,3,248,0,3,244,3,240,7,240,7,244,0,2,248,3,240,7,240,11,240,0,1,252,3,240,7,240,15,240,0,0,253,3,240,7,240,15,208,0,0,190,3,240,7,240,31,192,0,0,127,3,240,7,240,63,192,0,0,63,67,240,7,240,63,64,0,0,63,131,240,7,240,127,0,0,0,47,195,240,7,240,255,0,0,0,31,195,240,7,240,253,0,0,0,31,195,240,7,241,252,0,0,0,9,3,240,7,240,20,0,0,0,0,3,240,7,240,0,0,0,0,0,3,240,7,240,0,0,0,0,0,3,240,7,240,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,106,170,170,170,170,170,170,170,64,
  // 0x4e2d  中
  45,78,31,35,24,37,3,253,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,21,85,85,111,213,85,85,80,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,85,85,111,213,85,87,244,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,
  // 0x4e3b  主
  59,78,33,34,50,37,2,254,0,0,0,24,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,208,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,15,253,0,0,0,0,0,0,0,2,255,64,0,0,0,0,0,0,0,191,192,0,0,0,5,85,85,85,127,85,85,84,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,85,85,91,249,85,85,64,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,85,85,85,85,85,85,64,
  // 0x4e4b  之
  75,78,35,35,59,37,1,253,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,1,85,85,86,253,85,85,84,0,7,255,255,255,255,255,255,254,0,7,255,255,255,255,255,255,255,64,7,255,255,255,255,255,255,254,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,255,128,0,0,0,2,0,0,3,254,0,0,0,0,11,240,0,31,248,0,0,0,0,15,240,0,127,224,0,0,0,0,31,224,1,255,128,0,0,0,0,63,224,11,254,0,0,0,0,0,127,240,63,248,0,0,0,0,0,255,253,255,208,0,0,0,0,1,255,255,255,0,0,0,0,0,3,252,191,252,0,0,0,0,0,7,248,63,249,0,0,0,0,0,15,240,11,255,233,64,0,0,0,63,224,1,255,255,255,255,255,244,191,192,0,47,255,255,255,255,240,47,64,0,1,111,255,255,255,224,6,0,0,0,0,5,85,85,64,
  // 0x4ea4  交
  164,78,33,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,85,85,85,91,249,85,85,85,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,61,0,0,15,128,0,0,0,0,255,128,0,63,240,0,0,0,3,255,0,0,31,253,0,0,0,15,252,0,0,7,255,128,0,0,63,240,0,0,0,255,224,0,1,255,192,0,0,0,47,248,0,11,255,1,0,0,20,11,255,0,127,252,63,0,0,63,130,255,128,127,224,63,128,0,191,64,191,64,15,64,47,192,0,255,0,44,0,4,0,15,224,2,253,0,0,0,0,0,11,244,7,252,0,0,0,0,0,3,252,15,244,0,0,0,0,0,1,255,63,224,0,0,0,0,0,0,191,255,192,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,31,253,0,0,0,0,0,0,0,127,255,64,0,0,0,0,0,2,255,255,240,0,0,0,0,0,47,255,127,254,0,0,0,0,6,255,248,11,255,228,0,0,1,191,255,208,1,255,255,144,0,191,255,253,0,0,47,255,255,128,255,255,208,0,0,2,255,255,192,63,248,0,0,0,0,27,255,0,46,0,0,0,0,0,0,26,0,0,0,0,0,0,0,0,0,0,
  // 0x4eae  亮
  174,78,33,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,213,85,85,85,255,0,0,0,47,128,0,0,0,191,0,0,0,47,128,0,0,0,191,0,0,0,47,213,85,85,85,255,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,170,170,170,170,170,170,191,64,126,0,0,0,0,0,0,63,64,126,0,31,192,7,244,0,63,64,126,0,31,192,7,244,0,63,64,126,0,47,192,7,244,0,63,64,0,0,63,192,7,244,0,0,0,0,0,63,128,7,244,0,0,0,0,0,191,64,7,244,0,0,0,0,0,255,0,7,244,0,13,0,0,3,253,0,7,244,0,15,192,0,47,252,0,7,244,0,31,192,6,255,240,0,3,248,0,47,192,255,255,128,0,3,255,255,255,64,191,248,0,0,2,255,255,255,0,62,64,0,0,0,191,255,248,0,0,0,0,0,0,0,0,0,0,
  // 0x4ee4  令
  228,78,35,35,59,37,1,253,0,0,0,3,253,0,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,31,255,192,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,255,143,248,0,0,0,0,0,3,254,3,255,0,0,0,0,0,15,252,0,255,192,0,0,0,0,63,240,0,63,240,0,0,0,1,255,192,0,15,253,0,0,0,11,255,0,0,3,255,128,0,0,47,248,0,0,0,191,240,0,1,255,255,255,255,255,239,253,0,11,255,79,255,255,255,199,255,208,127,253,15,255,255,255,193,255,248,63,240,0,0,0,0,0,63,240,31,128,0,0,0,0,0,11,208,9,0,0,0,0,0,0,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,11,240,0,0,0,0,63,128,47,255,240,0,0,0,0,63,128,15,255,224,0,0,0,0,63,128,15,255,128,0,0,0,0,63,128,1,64,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,
  // 0x4ef6  件
  246,78,35,35,59,37,1,253,0,0,80,0,0,21,0,0,0,0,0,254,0,0,63,64,0,0,0,1,253,7,144,63,64,0,0,0,2,252,11,240,63,64,0,0,0,3,248,15,224,63,64,0,0,0,11,240,15,208,63,64,0,0,0,15,224,15,192,63,64,0,0,0,47,192,47,213,127,149,85,0,0,63,128,63,255,255,255,255,128,0,255,0,63,255,255,255,255,128,2,255,0,191,255,255,255,255,128,3,255,0,254,0,63,64,0,0,15,255,1,252,0,63,64,0,0,47,255,3,252,0,63,64,0,0,191,255,7,244,0,63,64,0,0,127,127,1,240,0,63,64,0,0,62,63,0,0,0,63,64,0,0,28,63,0,0,0,63,64,0,0,0,63,1,85,85,127,149,85,80,0,63,3,255,255,255,255,255,244,0,63,3,255,255,255,255,255,244,0,63,3,255,255,255,255,255,244,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,
  // 0x4efd  份
  253,78,35,35,59,37,1,253,0,0,160,0,0,0,0,0,0,0,0,253,0,31,255,255,0,0,0,2,252,0,31,255,255,0,0,0,3,248,0,31,255,255,64,0,0,7,244,2,64,0,47,192,0,0,15,240,7,240,0,31,192,0,0,31,208,11,240,0,15,224,0,0,63,192,15,208,0,15,240,0,0,191,64,47,192,0,7,244,0,1,255,0,63,128,0,3,252,0,3,255,0,191,0,0,1,254,0,11,255,1,253,0,0,0,255,64,31,255,3,252,0,0,0,127,192,127,255,11,240,0,0,0,47,244,255,255,31,224,0,0,0,15,248,255,127,63,255,255,255,255,251,240,124,63,15,47,255,255,255,244,192,32,63,0,47,255,255,255,244,0,0,63,0,0,31,208,3,244,0,0,63,0,0,31,192,3,244,0,0,63,0,0,31,192,3,244,0,0,63,0,0,47,128,3,240,0,0,63,0,0,63,128,7,240,0,0,63,0,0,63,64,7,240,0,0,63,0,0,127,0,7,240,0,0,63,0,0,254,0,7,240,0,0,63,0,1,252,0,7,240,0,0,63,0,3,252,0,11,240,0,0,63,0,11,244,0,11,240,0,0,63,0,31,240,0,15,224,0,0,63,0,191,192,0,31,224,0,0,63,3,255,0,47,255,208,0,0,63,3,252,0,15,255,192,0,0,63,1,240,0,15,255,0,0,0,42,0,64,0,1,64,0,0,
  // 0x4f11  休
  17,79,35,35,59,37,1,253,0,0,20,0,0,21,0,0,0,0,0,63,128,0,127,0,0,0,0,0,127,64,0,127,0,0,0,0,0,255,0,0,127,0,0,0,0,1,254,0,0,127,0,0,0,0,3,252,0,0,127,0,0,0,0,7,248,0,0,127,0,0,0,0,15,240,0,0,127,0,0,0,0,47,224,0,0,127,0,0,0,0,127,193,85,85,191,85,85,80,0,255,199,255,255,255,255,255,240,2,255,199,255,255,255,255,255,240,11,255,199,255,255,255,255,255,240,47,255,192,0,7,255,240,0,0,127,255,192,0,11,255,244,0,0,255,223,192,0,15,255,252,0,0,127,31,192,0,47,255,253,0,0,60,31,192,0,63,255,191,0,0,16,31,192,0,191,191,63,64,0,0,31,192,0,253,127,47,192,0,0,31,192,3,252,127,15,208,0,0,31,192,7,244,127,11,240,0,0,31,192,15,240,127,3,252,0,0,31,192,63,208,127,2,254,0,0,31,192,191,128,127,0,255,64,0,31,194,255,0,127,0,127,208,0,31,203,252,0,127,0,47,240,0,31,239,244,0,127,0,15,252,0,31,207,224,0,127,0,3,240,0,31,195,128,0,127,0,0,192,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,
  // 0x4f4d  位
  77,79,35,35,59,37,1,253,0,0,36,0,0,42,0,0,0,0,0,191,0,0,127,0,0,0,0,0,254,0,0,127,0,0,0,0,2,252,0,0,127,0,0,0,0,3,248,0,0,127,0,0,0,0,11,240,0,0,127,0,0,0,0,15,224,0,0,127,0,0,0,0,63,194,255,255,255,255,255,240,0,127,130,255,255,255,255,255,240,0,255,130,255,255,255,255,255,240,3,255,128,85,85,85,85,85,64,11,255,128,0,0,0,0,0,0,31,255,128,0,64,0,2,144,0,127,255,128,11,224,0,3,252,0,255,175,128,7,240,0,3,248,0,191,47,128,3,240,0,7,244,0,60,47,128,3,244,0,11,240,0,32,47,128,3,248,0,15,240,0,0,47,128,2,252,0,15,224,0,0,47,128,1,252,0,15,208,0,0,47,128,0,252,0,31,192,0,0,47,128,0,253,0,47,192,0,0,47,128,0,253,0,63,128,0,0,47,128,0,254,0,63,64,0,0,47,128,0,191,0,127,0,0,0,47,128,0,127,0,191,0,0,0,47,128,0,127,0,254,0,0,0,47,128,0,127,0,252,0,0,0,47,128,0,16,1,252,0,0,0,47,128,0,0,3,248,0,0,0,47,135,255,255,255,255,255,248,0,47,135,255,255,255,255,255,248,0,47,135,255,255,255,255,255,248,0,47,129,85,85,85,85,85,80,0,47,64,0,0,0,0,0,0,
  // 0x4f4e  低
  78,79,35,35,59,37,1,253,0,0,80,0,0,0,0,0,0,0,0,253,0,0,0,0,36,0,0,1,252,0,0,0,27,253,0,0,3,248,0,1,111,255,255,64,0,7,244,122,255,255,255,249,0,0,15,240,127,255,255,249,0,0,0,31,208,127,254,155,240,0,0,0,63,192,127,0,7,240,0,0,0,191,64,127,0,7,240,0,0,0,255,0,127,0,7,240,0,0,3,255,0,127,0,7,240,0,0,11,255,0,127,0,7,240,0,0,31,255,0,127,0,3,240,0,0,63,255,0,127,255,255,255,255,244,255,255,0,127,255,255,255,255,244,255,127,0,127,255,255,255,255,244,124,63,0,127,0,3,248,0,0,52,63,0,127,0,2,252,0,0,0,63,0,127,0,2,252,0,0,0,63,0,127,0,1,252,0,0,0,63,0,127,0,0,252,0,0,0,63,0,127,0,0,253,0,0,0,63,0,127,0,0,254,0,0,0,63,0,127,0,4,191,0,0,0,63,0,127,91,254,127,0,0,0,63,5,255,255,254,63,64,64,0,63,15,255,255,254,63,192,184,0,63,11,255,250,64,31,192,188,0,63,7,229,0,0,15,224,252,0,63,0,0,0,0,11,244,252,0,63,0,0,0,0,3,255,248,0,63,3,255,255,255,245,255,244,0,63,3,255,255,255,244,127,224,0,63,3,255,255,255,244,6,64,0,63,0,0,0,0,0,0,0,
  // 0x4f5c  作
  92,79,35,35,59,37,1,253,0,0,36,0,5,0,0,0,0,0,0,127,0,15,208,0,0,0,0,0,255,0,31,192,0,0,0,0,1,253,0,63,128,0,0,0,0,3,252,0,127,64,0,0,0,0,7,248,0,255,0,0,0,0,0,15,240,0,255,255,255,255,248,0,31,208,2,255,255,255,255,248,0,63,192,3,255,255,255,255,248,0,191,192,15,245,254,85,85,80,0,255,192,31,208,254,0,0,0,3,255,192,63,192,254,0,0,0,11,255,192,191,64,254,0,0,0,31,255,193,255,0,254,0,0,0,63,255,195,252,0,254,0,0,0,127,255,199,248,0,255,255,255,224,63,47,192,240,0,255,255,255,224,29,47,192,0,0,255,255,255,224,4,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,255,255,255,240,0,47,192,0,0,255,255,255,240,0,47,192,0,0,255,255,255,240,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,128,0,0,254,0,0,0,
  // 0x4f9b  供
  155,79,35,35,59,37,1,253,0,0,96,0,168,0,10,128,0,0,0,254,0,253,0,31,192,0,0,1,253,0,253,0,31,192,0,0,2,252,0,253,0,31,192,0,0,3,248,0,253,0,31,192,0,0,11,240,0,253,0,31,192,0,0,15,224,0,253,0,31,192,0,0,47,192,0,253,0,31,192,0,0,127,129,255,255,255,255,255,240,0,255,1,255,255,255,255,255,240,2,255,1,255,255,255,255,255,240,7,255,0,85,254,85,111,213,80,15,255,0,0,253,0,31,192,0,63,255,0,0,253,0,31,192,0,255,255,0,0,253,0,31,192,0,191,127,0,0,253,0,31,192,0,61,63,0,0,253,0,31,192,0,36,63,0,0,253,0,31,192,0,0,63,0,0,253,0,31,192,0,0,63,1,85,254,85,111,213,80,0,63,7,255,255,255,255,255,244,0,63,7,255,255,255,255,255,244,0,63,7,255,255,255,255,255,244,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,185,0,7,64,0,0,63,0,0,254,0,47,192,0,0,63,0,3,252,0,15,240,0,0,63,0,11,244,0,7,252,0,0,63,0,47,224,0,2,254,0,0,63,0,191,192,0,0,191,64,0,63,2,255,0,0,0,63,192,0,63,11,253,0,0,0,15,240,0,63,2,244,0,0,0,11,208,0,63,0,80,0,0,0,2,0,
  // 0x4fdd  保
  221,79,35,35,59,37,1,253,0,0,32,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,254,63,255,255,255,255,64,0,1,253,63,255,255,255,255,64,0,3,252,63,255,255,255,255,64,0,7,244,63,64,0,0,63,64,0,15,240,63,64,0,0,63,64,0,47,208,63,64,0,0,63,64,0,63,192,63,64,0,0,63,64,0,255,128,63,64,0,0,63,64,2,255,128,63,64,0,0,63,64,7,255,128,63,255,255,255,255,64,15,255,128,63,255,255,255,255,64,63,255,128,63,255,255,255,255,64,255,239,128,0,0,63,64,0,0,127,47,128,0,0,63,64,0,0,61,47,128,0,0,63,64,0,0,20,47,128,0,0,63,64,0,0,0,47,135,255,255,255,255,255,240,0,47,135,255,255,255,255,255,240,0,47,135,255,255,255,255,255,240,0,47,128,0,7,255,244,0,0,0,47,128,0,15,255,252,0,0,0,47,128,0,47,255,254,0,0,0,47,128,0,191,191,127,128,0,0,47,128,1,254,63,111,208,0,0,47,128,7,252,63,79,244,0,0,47,128,47,240,63,67,253,0,0,47,128,191,208,63,65,255,64,0,47,135,255,64,63,64,127,224,0,47,159,253,0,63,64,31,252,0,47,139,244,0,63,64,7,244,0,47,131,192,0,63,64,1,208,0,47,128,0,0,63,64,0,0,0,47,64,0,0,63,0,0,0,
  // 0x4fe1  信
  225,79,35,35,59,37,1,253,0,0,32,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,254,11,255,255,255,252,0,0,1,253,11,255,255,255,252,0,0,3,252,11,255,255,255,252,0,0,7,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,47,211,255,255,255,255,255,248,0,63,131,255,255,255,255,255,248,0,255,131,255,255,255,255,255,244,2,255,128,0,0,0,0,0,0,7,255,128,0,0,0,0,0,0,31,255,128,15,255,255,255,254,0,63,255,128,15,255,255,255,255,0,255,239,128,15,255,255,255,255,0,191,47,128,0,0,0,0,0,0,61,47,128,0,0,0,0,0,0,56,47,128,0,0,0,0,0,0,0,47,128,15,255,255,255,254,0,0,47,128,15,255,255,255,254,0,0,47,128,10,170,170,170,170,0,0,47,128,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,47,128,47,255,255,255,255,0,0,47,128,47,255,255,255,255,0,0,47,128,47,234,170,170,255,0,0,47,128,47,128,0,0,63,0,0,47,128,47,128,0,0,63,0,0,47,128,47,128,0,0,63,0,0,47,128,47,128,0,0,63,0,0,47,128,47,255,255,255,255,0,0,47,128,47,255,255,255,255,0,0,47,128,47,255,255,255,255,0,0,47,128,47,128,0,0,63,0,0,26,64,47,128,0,0,42,0,
  // 0x500b  個
  11,80,34,36,68,37,1,252,0,2,144,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,7,241,255,255,255,255,255,208,0,11,241,255,255,255,255,255,208,0,15,209,255,255,255,255,255,208,0,47,193,252,0,0,0,15,208,0,63,129,252,0,63,0,15,208,0,127,1,252,0,63,0,15,208,0,255,1,252,0,63,0,15,208,2,255,1,252,0,63,0,15,208,3,255,1,252,106,191,170,143,208,11,255,1,252,255,255,255,207,208,31,255,1,252,255,255,255,207,208,63,255,1,252,0,63,0,15,208,255,255,1,252,0,63,0,15,208,255,191,1,252,0,63,0,15,208,188,127,1,252,0,63,0,15,208,52,127,1,252,47,255,254,15,208,16,127,1,252,47,255,254,15,208,0,127,1,252,47,85,126,15,208,0,127,1,252,47,0,62,15,208,0,127,1,252,47,0,62,15,208,0,127,1,252,47,0,62,15,208,0,127,1,252,47,0,62,15,208,0,127,1,252,47,85,126,15,208,0,127,1,252,47,255,254,15,208,0,127,1,252,47,255,254,15,208,0,127,1,252,0,0,0,15,208,0,127,1,252,0,0,0,15,208,0,127,1,252,0,0,0,15,208,0,127,1,255,255,255,255,255,208,0,127,1,255,255,255,255,255,208,0,127,1,255,255,255,255,255,208,0,127,1,252,0,0,0,15,208,0,127,1,252,0,0,0,10,128,0,0,0,0,0,0,0,0,0,
  // 0x503c  值
  60,80,35,35,59,37,1,253,0,0,80,0,0,58,64,0,0,0,0,253,0,0,63,64,0,0,0,1,252,0,0,127,0,0,0,0,3,248,0,0,127,0,0,0,0,3,246,255,255,255,255,255,208,0,11,242,255,255,255,255,255,208,0,15,210,255,255,255,255,255,208,0,47,192,0,0,252,0,0,0,0,127,64,0,1,252,0,0,0,0,255,0,0,1,248,0,0,0,2,255,0,63,255,255,255,253,0,3,255,0,63,255,255,255,253,0,15,255,0,63,170,170,170,253,0,47,255,0,63,0,0,0,253,0,127,255,0,63,0,0,0,253,0,191,191,0,63,149,85,85,253,0,62,127,0,63,255,255,255,253,0,28,127,0,63,255,255,255,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,149,85,85,253,0,0,127,0,63,255,255,255,253,0,0,127,0,63,255,255,255,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,255,255,255,253,0,0,127,0,63,255,255,255,253,0,0,127,0,63,149,85,85,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,0,0,0,253,0,0,127,31,255,255,255,255,255,244,0,127,31,255,255,255,255,255,244,0,127,31,255,255,255,255,255,244,0,127,0,0,0,0,0,0,0,
  // 0x504f  偏
  79,80,35,35,59,37,1,253,0,1,64,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,243,255,255,255,255,255,244,0,11,227,255,255,255,255,255,244,0,15,211,255,255,255,255,255,244,0,47,192,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,127,0,106,170,170,170,170,128,0,255,0,191,255,255,255,255,192,1,254,0,191,255,255,255,255,192,3,254,0,189,0,0,0,31,192,11,254,0,189,0,0,0,31,192,31,254,0,189,0,0,0,31,192,63,254,0,191,170,170,170,191,192,191,254,0,191,255,255,255,255,192,255,190,0,191,255,255,255,255,192,188,190,0,253,0,0,0,0,0,52,190,0,253,0,0,0,0,0,16,190,0,255,170,170,170,170,144,0,190,0,255,255,255,255,255,224,0,190,0,255,255,255,255,255,224,0,190,0,255,208,244,46,7,224,0,190,1,255,208,244,46,7,224,0,190,2,255,208,244,46,7,224,0,190,3,255,208,244,46,7,224,0,190,3,251,255,255,255,255,224,0,190,7,251,255,255,255,255,224,0,190,11,235,250,254,191,175,224,0,190,15,219,208,244,46,7,224,0,190,47,203,208,244,46,7,224,0,190,127,75,208,244,46,7,224,0,190,191,11,208,244,46,7,224,0,190,45,11,208,244,46,191,224,0,190,4,11,208,244,46,127,208,0,126,0,11,192,164,41,62,64,
  // 0x505c  停
  92,80,35,35,59,37,1,253,0,0,80,0,0,42,0,0,0,0,0,253,0,0,127,0,0,0,0,1,252,0,0,127,0,0,0,0,3,252,0,0,127,0,0,0,0,7,247,255,255,255,255,255,244,0,15,243,255,255,255,255,255,244,0,31,211,255,255,255,255,255,244,0,63,192,0,0,0,0,0,0,0,127,64,5,85,85,85,84,0,0,255,0,31,255,255,255,254,0,3,255,0,31,255,255,255,254,0,7,255,0,31,128,0,0,254,0,31,255,0,31,128,0,0,254,0,63,255,0,31,213,85,85,254,0,255,255,0,31,255,255,255,254,0,255,127,0,31,255,255,255,254,0,124,63,0,0,0,0,0,0,0,52,63,0,0,0,0,0,0,0,0,63,15,255,255,255,255,255,248,0,63,15,255,255,255,255,255,248,0,63,15,250,170,170,170,171,248,0,63,15,192,0,0,0,1,248,0,63,15,192,0,0,0,1,248,0,63,15,195,255,255,255,245,248,0,63,15,195,255,255,255,245,248,0,63,0,3,255,255,255,240,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,1,255,255,0,0,0,0,63,0,0,255,254,0,0,0,0,63,0,0,191,244,0,0,0,
  // 0x5075  偵
  117,80,34,36,68,37,1,252,0,0,36,0,0,191,0,0,0,0,0,191,0,0,191,0,0,0,0,0,254,0,0,191,0,0,0,0,1,252,0,0,191,255,255,224,0,3,248,0,0,191,255,255,240,0,11,244,0,0,191,255,255,240,0,15,240,0,0,191,0,0,0,0,47,208,0,0,191,0,0,0,0,127,192,0,0,191,0,0,0,0,255,128,63,255,255,255,255,0,2,255,128,63,255,255,255,255,0,7,255,128,63,170,170,170,255,0,31,255,128,63,0,0,0,127,0,127,255,128,63,0,0,0,127,0,255,175,128,63,255,255,255,255,0,191,47,128,63,255,255,255,255,0,60,47,128,63,170,170,170,191,0,36,47,128,63,0,0,0,127,0,0,47,128,63,0,0,0,127,0,0,47,128,63,149,85,85,191,0,0,47,128,63,255,255,255,255,0,0,47,128,63,255,255,255,255,0,0,47,128,63,0,0,0,127,0,0,47,128,63,0,0,0,127,0,0,47,128,63,0,0,0,127,0,0,47,128,63,255,255,255,255,0,0,47,128,63,255,255,255,255,0,0,47,128,42,170,170,170,170,0,0,47,128,0,36,0,6,0,0,0,47,128,0,255,64,63,208,0,0,47,128,7,255,0,47,252,0,0,47,128,127,248,0,7,255,64,0,47,135,255,208,0,0,191,224,0,47,135,254,0,0,0,31,240,0,47,128,244,0,0,0,7,64,0,0,0,0,0,0,0,0,0,
  // 0x5099  備
  153,80,35,36,68,37,1,252,0,2,144,0,189,0,31,128,0,0,3,244,0,253,0,31,192,0,0,7,240,0,253,0,31,192,0,0,15,231,255,255,255,255,255,244,0,15,199,255,255,255,255,255,244,0,47,199,255,255,255,255,255,244,0,63,64,0,253,0,31,192,0,0,191,0,0,253,0,31,192,0,0,254,0,0,189,0,31,192,0,2,254,0,0,0,0,0,0,0,3,254,3,255,255,255,255,255,248,15,254,3,255,255,255,255,255,248,31,254,3,255,255,255,255,255,248,63,254,3,240,0,0,0,0,0,255,254,3,240,0,0,0,0,0,255,190,3,240,0,0,0,0,0,124,190,3,240,255,255,255,255,224,52,190,3,240,255,255,255,255,224,16,190,3,240,254,171,250,171,224,0,190,3,240,252,2,240,7,224,0,190,3,240,252,2,240,7,224,0,190,3,240,253,87,245,91,224,0,190,3,240,255,255,255,255,224,0,190,3,240,255,255,255,255,224,0,190,7,240,252,2,240,7,224,0,190,7,224,252,2,240,7,224,0,190,11,224,253,87,245,91,224,0,190,15,208,255,255,255,255,224,0,190,15,192,255,255,255,255,224,0,190,31,192,252,2,240,7,224,0,190,47,128,252,2,240,7,224,0,190,63,64,252,2,240,7,224,0,190,191,0,252,2,241,175,224,0,190,61,0,252,2,241,255,208,0,190,8,0,168,1,80,255,64,0,0,0,0,0,0,0,0,0,
  // 0x50b3  傳
  179,80,35,35,59,37,1,253,0,0,80,0,0,42,0,0,0,0,0,253,0,0,63,0,0,0,0,1,252,0,0,63,0,0,0,0,3,251,255,255,255,255,255,240,0,7,247,255,255,255,255,255,240,0,15,226,170,170,191,170,170,160,0,31,192,0,0,63,0,0,0,0,63,128,191,255,255,255,255,192,0,191,0,191,255,255,255,255,192,1,255,0,190,0,127,0,47,192,3,255,0,190,0,63,0,31,192,11,255,0,191,255,255,255,255,192,47,255,0,191,255,255,255,255,192,127,255,0,190,0,63,0,31,192,255,191,0,190,0,63,0,31,192,190,63,0,191,255,255,255,255,192,60,63,0,191,255,255,255,255,192,48,63,0,0,0,127,3,252,0,0,63,0,0,0,63,0,255,0,0,63,1,85,85,191,85,191,128,0,63,3,255,255,255,255,255,224,0,63,3,255,255,255,255,255,244,0,63,1,85,80,0,15,225,240,0,63,0,0,0,0,15,224,64,0,63,15,255,255,255,255,255,248,0,63,15,255,255,255,255,255,248,0,63,10,171,234,170,175,250,164,0,63,0,11,208,0,15,224,0,0,63,0,15,244,0,15,224,0,0,63,0,3,253,0,15,224,0,0,63,0,0,255,0,15,224,0,0,63,0,0,63,64,15,224,0,0,63,0,0,28,47,255,208,0,0,63,0,0,0,31,255,192,0,0,63,0,0,0,15,250,0,0,
  // 0x50be  傾
  190,80,35,36,68,37,1,252,0,1,0,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,15,208,0,63,255,255,255,244,0,31,192,0,63,255,255,255,244,0,47,143,192,63,255,255,255,244,0,63,15,192,0,0,253,0,0,0,127,15,192,0,1,252,0,0,0,253,15,192,6,171,254,170,128,1,253,15,192,11,255,255,255,192,3,253,15,193,203,255,255,255,192,7,253,15,195,251,208,0,15,192,15,253,15,207,255,208,0,15,192,31,253,15,239,219,208,0,15,192,63,253,15,255,11,229,85,95,192,255,253,15,252,11,255,255,255,192,254,253,15,240,11,255,255,255,192,188,253,15,192,11,208,0,15,192,52,253,15,192,11,208,0,15,192,16,253,15,192,11,208,0,15,192,0,253,15,192,11,255,255,255,192,0,253,15,192,11,255,255,255,192,0,253,15,192,219,229,85,95,192,0,253,15,192,255,208,0,15,192,0,253,15,192,255,208,0,15,192,0,253,15,193,255,208,0,15,192,0,253,15,193,255,255,255,255,192,0,253,15,255,251,255,255,255,192,0,253,15,255,230,170,170,170,128,0,253,3,255,128,36,0,32,0,0,253,0,0,0,254,2,252,0,0,253,0,0,7,254,1,255,64,0,253,0,0,127,248,0,127,208,0,253,0,3,255,208,0,15,244,0,253,0,2,254,0,0,3,244,0,253,0,0,224,0,0,0,192,0,0,0,0,0,0,0,0,0,
  // 0x5132  儲
  50,81,35,36,68,37,1,252,0,6,64,0,0,2,244,0,0,0,11,230,170,164,2,244,3,224,0,15,203,255,248,2,244,7,240,0,31,203,255,248,2,244,11,208,0,63,64,0,0,107,254,159,192,0,63,0,0,0,191,255,239,128,0,190,42,170,170,191,255,255,64,0,253,63,255,255,2,244,127,0,2,252,63,255,255,2,244,253,0,3,252,0,0,0,2,245,252,0,11,252,0,0,0,2,247,244,0,31,252,10,170,168,255,255,255,244,63,252,15,255,253,255,255,255,248,191,252,15,255,253,255,255,255,248,255,252,0,0,0,0,191,40,0,188,252,0,0,0,2,252,191,0,52,252,0,0,0,7,244,47,128,16,252,15,255,252,31,208,11,0,0,252,15,255,252,191,255,255,192,0,252,10,170,170,255,255,255,192,0,252,0,0,7,255,255,255,192,0,252,0,0,1,251,208,15,192,0,252,15,255,253,71,208,15,192,0,252,15,255,253,7,208,15,192,0,252,15,234,253,7,250,175,192,0,252,15,128,125,7,255,255,192,0,252,15,128,125,7,255,255,192,0,252,15,128,125,7,208,15,192,0,252,15,128,125,7,208,15,192,0,252,15,128,125,7,208,15,192,0,252,15,255,253,7,208,15,192,0,252,15,255,253,7,255,255,192,0,252,15,234,169,7,255,255,192,0,252,15,128,0,7,255,255,192,0,188,10,64,0,7,208,15,192,0,0,0,0,0,0,0,0,0,
  // 0x5145  充
  69,81,34,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,244,0,0,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,11,244,0,4,0,0,0,0,0,15,240,0,63,0,0,0,0,0,47,192,0,191,192,0,0,0,0,63,128,0,47,244,0,0,0,0,191,0,0,11,253,0,0,0,0,254,0,0,1,255,64,0,10,171,255,175,255,255,255,208,0,31,255,255,255,255,255,255,244,0,15,255,255,255,255,255,255,252,0,15,255,254,170,149,80,2,255,0,0,0,0,0,0,0,0,253,0,0,0,15,208,2,252,0,48,0,0,0,31,208,2,252,0,0,0,0,0,31,208,2,252,0,0,0,0,0,47,192,2,252,0,0,0,0,0,47,192,2,252,0,0,0,0,0,63,192,2,252,0,0,0,0,0,127,64,2,252,0,4,0,0,0,255,0,2,252,0,11,128,0,1,255,0,2,252,0,11,208,0,3,253,0,2,252,0,15,208,0,31,248,0,2,252,0,15,208,0,191,240,0,2,252,0,15,192,27,255,192,0,1,253,64,111,192,255,254,0,0,1,255,255,255,128,127,224,0,0,0,255,255,255,0,62,0,0,0,0,47,255,249,0,0,0,0,0,0,0,0,0,0,
  // 0x5148  先
  72,81,33,36,68,37,2,252,0,0,0,3,240,0,0,0,0,0,7,224,3,244,0,0,0,0,0,11,240,3,244,0,0,0,0,0,15,224,3,244,0,0,0,0,0,15,208,3,244,0,0,0,0,0,47,213,87,245,85,85,80,0,0,63,255,255,255,255,255,240,0,0,127,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,1,253,0,3,244,0,0,0,0,3,252,0,3,244,0,0,0,0,7,248,0,3,244,0,0,0,0,15,240,0,3,244,0,0,0,0,7,208,0,3,244,0,0,0,0,0,64,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,21,85,111,213,87,253,85,85,64,0,0,47,192,2,252,0,0,0,0,0,63,192,2,252,0,0,0,0,0,63,128,2,252,0,0,0,0,0,63,64,2,252,0,0,0,0,0,191,0,2,252,0,0,0,0,0,255,0,2,252,0,0,0,0,2,253,0,2,252,0,14,64,0,3,252,0,2,252,0,15,192,0,15,244,0,2,252,0,15,192,0,127,240,0,2,252,0,31,192,2,255,192,0,2,252,0,47,128,111,255,0,0,1,255,255,255,128,255,248,0,0,0,255,255,255,0,63,208,0,0,0,127,255,253,0,29,0,0,0,0,0,85,64,0,0,0,0,0,0,0,0,0,0,
  // 0x5149  光
  73,81,35,36,68,37,1,252,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,64,0,0,109,0,1,252,0,2,248,0,0,191,0,1,252,0,3,252,0,0,63,128,1,252,0,7,248,0,0,47,192,1,252,0,15,240,0,0,15,224,1,252,0,15,224,0,0,11,240,1,252,0,47,192,0,0,3,248,1,252,0,63,128,0,0,3,252,1,252,0,255,0,0,0,1,253,1,252,1,253,0,0,0,0,228,1,252,0,104,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,21,85,91,245,85,255,85,85,80,0,0,11,240,0,191,0,0,0,0,0,11,240,0,191,0,0,0,0,0,15,240,0,191,0,0,0,0,0,15,224,0,191,0,0,0,0,0,15,208,0,191,0,0,0,0,0,31,208,0,191,0,0,0,0,0,63,192,0,191,0,0,0,0,0,63,128,0,191,0,1,0,0,0,255,64,0,191,0,2,208,0,1,255,0,0,191,0,3,244,0,7,253,0,0,191,0,3,244,0,31,248,0,0,191,0,3,244,0,255,240,0,0,191,0,3,240,27,255,192,0,0,191,64,11,240,127,254,0,0,0,127,255,255,224,47,240,0,0,0,63,255,255,192,14,0,0,0,0,11,255,254,64,0,0,0,0,0,0,0,0,0,
  // 0x5165  入
  101,81,34,33,41,37,2,253,0,1,85,85,84,0,0,0,0,0,7,255,255,252,0,0,0,0,0,7,255,255,252,0,0,0,0,0,7,255,255,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,10,253,0,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,47,255,0,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,63,255,64,0,0,0,0,0,0,191,191,128,0,0,0,0,0,0,255,47,192,0,0,0,0,0,0,255,31,208,0,0,0,0,0,2,253,15,240,0,0,0,0,0,3,252,11,244,0,0,0,0,0,11,248,7,248,0,0,0,0,0,15,240,3,253,0,0,0,0,0,47,224,1,255,0,0,0,0,0,127,192,0,255,128,0,0,0,0,255,64,0,127,208,0,0,0,2,255,0,0,47,240,0,0,0,11,253,0,0,15,252,0,0,0,47,248,0,0,3,255,0,0,0,191,224,0,0,1,255,192,0,2,255,192,0,0,0,127,244,0,31,255,0,0,0,0,47,254,0,191,252,0,0,0,0,7,255,208,255,224,0,0,0,0,1,255,192,63,64,0,0,0,0,0,63,0,8,0,0,0,0,0,0,8,0,
  // 0x5168  全
  104,81,35,34,50,37,1,254,0,0,0,3,253,0,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,31,255,192,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,255,143,248,0,0,0,0,0,3,255,3,254,0,0,0,0,0,15,252,1,255,128,0,0,0,0,63,240,0,127,240,0,0,0,0,255,208,0,31,252,0,0,0,7,255,64,0,7,255,64,0,0,31,253,0,0,0,255,224,0,0,191,240,0,0,0,63,253,0,7,255,192,0,0,0,11,255,192,63,254,0,0,0,0,2,255,244,127,247,255,255,255,255,255,175,240,31,71,255,255,255,255,255,71,208,8,7,255,255,255,255,255,64,64,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,253,0,0,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,
  // 0x5171  共
  113,81,33,35,59,37,2,253,0,0,169,0,0,26,128,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,5,85,255,85,85,127,213,85,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,85,85,255,85,85,127,213,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,0,0,45,0,0,0,0,0,191,192,0,255,128,0,0,0,2,255,64,0,127,240,0,0,0,15,253,0,0,15,253,0,0,0,63,244,0,0,3,255,128,0,1,255,208,0,0,0,191,240,0,15,255,0,0,0,0,31,252,0,127,248,0,0,0,0,7,255,0,47,208,0,0,0,0,0,254,0,6,0,0,0,0,0,0,48,0,
  // 0x5177  具
  119,81,33,34,50,37,2,253,0,26,170,170,170,170,170,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,192,0,0,0,191,0,0,0,47,192,0,0,0,191,0,0,0,47,192,0,0,0,191,0,0,0,47,234,170,170,170,255,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,192,0,0,0,191,0,0,0,47,192,0,0,0,191,0,0,0,47,192,0,0,0,191,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,234,170,170,170,255,0,0,0,47,192,0,0,0,191,0,0,0,47,192,0,0,0,191,0,0,0,47,234,170,170,170,255,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,47,64,0,62,0,0,0,0,2,255,224,1,255,228,0,0,0,111,255,128,0,191,255,128,0,11,255,248,0,0,7,255,248,0,191,255,128,0,0,0,111,255,128,63,244,0,0,0,0,2,255,0,14,0,0,0,0,0,0,56,0,
  // 0x5197  冗
  151,81,34,33,41,37,2,253,21,85,85,85,85,85,85,85,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,128,0,0,0,0,0,191,0,63,128,0,0,0,0,0,191,0,63,128,0,0,0,0,0,191,0,63,128,0,0,0,0,0,191,0,63,128,0,0,0,0,0,191,0,63,128,0,0,0,0,0,191,0,42,64,191,255,255,255,128,106,0,0,0,191,255,255,255,128,0,0,0,0,191,255,255,255,128,0,0,0,0,191,0,0,127,128,0,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,255,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,1,253,0,0,63,128,4,0,0,3,252,0,0,63,128,15,64,0,7,248,0,0,63,128,15,224,0,15,240,0,0,63,128,15,208,0,63,224,0,0,63,128,15,208,1,255,192,0,0,63,128,15,192,11,255,0,0,0,63,192,31,192,191,252,0,0,0,63,255,255,192,255,240,0,0,0,47,255,255,64,63,64,0,0,0,15,255,254,0,36,0,0,0,0,0,85,80,0,
  // 0x51b7  冷
  183,81,35,35,59,37,1,253,0,0,0,0,2,248,0,0,0,0,0,0,0,7,254,0,0,0,7,0,0,0,15,255,64,0,0,15,208,0,0,47,255,208,0,0,63,248,0,0,191,143,240,0,0,11,255,0,1,255,7,252,0,0,2,255,192,3,252,2,255,0,0,0,127,208,15,244,0,191,208,0,0,31,128,127,208,0,47,244,0,0,6,1,255,128,0,11,254,0,0,0,7,254,0,0,2,255,208,0,0,47,251,255,255,254,127,248,0,1,255,227,255,255,254,31,244,0,0,255,67,255,255,254,3,224,0,0,124,0,0,0,0,0,128,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,66,255,255,255,255,255,0,0,7,210,255,255,255,255,255,0,0,15,242,255,255,255,255,255,0,0,47,208,0,31,208,0,191,0,0,63,192,0,31,192,0,191,0,0,255,64,0,31,192,0,191,0,1,254,0,0,31,192,0,191,0,3,252,0,0,31,192,0,191,0,11,248,0,0,31,192,0,191,0,31,240,0,0,31,192,0,191,0,63,208,0,0,31,192,255,254,0,127,192,0,0,31,192,191,253,0,31,64,0,0,31,192,127,248,0,6,0,0,0,31,192,20,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,
  // 0x51c6  准
  198,81,35,35,59,37,1,253,0,0,0,0,164,0,25,0,0,0,0,0,0,254,0,63,192,0,2,0,0,1,252,0,63,64,0,11,224,0,3,248,0,127,0,0,31,252,0,7,244,0,254,0,0,7,255,64,15,240,0,252,0,0,0,255,208,31,208,2,252,0,0,0,47,240,63,255,255,255,255,224,0,11,192,127,255,255,255,255,224,0,2,64,255,255,255,255,255,224,0,0,2,255,192,7,240,0,0,0,0,7,255,128,7,240,0,0,0,0,15,255,128,7,240,0,0,0,0,63,255,128,7,240,0,0,0,0,191,239,192,7,240,0,0,0,0,63,111,255,255,255,255,192,0,0,14,47,255,255,255,255,192,0,0,0,47,255,255,255,255,192,0,0,0,47,128,7,240,0,0,0,3,0,47,128,7,240,0,0,0,11,192,47,128,7,240,0,0,0,31,224,47,128,7,240,0,0,0,63,192,47,255,255,255,255,192,0,191,64,47,255,255,255,255,192,0,255,0,47,255,255,255,255,192,3,253,0,47,192,7,240,0,0,7,248,0,47,128,7,240,0,0,15,240,0,47,128,7,240,0,0,63,208,0,47,128,7,240,0,0,127,192,0,47,128,7,240,0,0,47,64,0,47,255,255,255,255,244,10,0,0,47,255,255,255,255,244,0,0,0,47,255,255,255,255,244,0,0,0,47,192,0,0,0,0,0,0,0,31,128,0,0,0,0,
  // 0x51fa  出
  250,81,29,35,24,37,4,253,0,0,0,106,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,127,0,0,0,0,5,64,0,127,0,0,84,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,213,85,191,85,85,254,0,31,255,255,255,255,255,254,0,31,255,255,255,255,255,254,0,31,255,255,255,255,255,254,0,0,0,0,127,0,0,0,0,0,0,0,127,0,0,0,0,189,0,0,127,0,0,31,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,85,85,85,85,85,111,192,254,0,0,0,0,0,47,192,190,0,0,0,0,0,31,192,
  // 0x5206  分
  6,82,35,35,59,37,1,252,0,0,11,208,0,27,128,0,0,0,0,15,240,0,63,192,0,0,0,0,47,224,0,31,224,0,0,0,0,63,192,0,15,244,0,0,0,0,191,128,0,7,252,0,0,0,1,255,0,0,2,255,0,0,0,3,254,0,0,0,255,128,0,0,11,252,0,0,0,127,208,0,0,31,240,0,0,0,47,244,0,0,127,224,0,0,0,15,252,0,1,255,128,0,0,0,3,255,0,7,255,0,0,0,0,1,255,208,47,252,0,0,0,0,0,127,244,191,255,255,255,255,255,255,239,248,127,207,255,255,255,255,255,203,224,31,15,255,255,255,255,255,194,128,4,5,85,127,213,85,127,192,0,0,0,0,63,128,0,47,192,0,0,0,0,127,64,0,47,192,0,0,0,0,191,0,0,63,192,0,0,0,0,191,0,0,63,128,0,0,0,0,255,0,0,63,128,0,0,0,1,254,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,7,252,0,0,63,64,0,0,0,15,244,0,0,63,64,0,0,0,47,240,0,0,127,64,0,0,0,191,192,0,0,127,0,0,0,3,255,64,0,0,191,0,0,0,31,254,0,0,0,255,0,0,1,255,248,0,37,87,254,0,0,15,255,208,0,47,255,253,0,0,3,254,0,0,31,255,248,0,0,1,224,0,0,15,255,144,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5217  列
  23,82,33,36,68,37,1,252,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,47,192,47,255,255,255,253,0,0,47,192,47,255,255,255,253,0,0,47,192,47,255,255,255,253,63,0,47,192,0,3,252,0,0,127,0,47,192,0,3,244,0,0,127,0,47,192,0,7,240,0,0,127,0,47,192,0,11,240,0,0,127,0,47,192,0,15,224,0,0,127,0,47,192,0,31,255,255,224,127,0,47,192,0,63,255,255,244,127,0,47,192,0,63,255,255,240,127,0,47,192,0,191,0,11,240,127,0,47,192,0,253,0,11,240,127,0,47,192,3,252,0,15,224,127,0,47,192,7,248,0,15,208,127,0,47,192,15,255,0,31,192,127,0,47,192,63,255,224,63,128,127,0,47,192,191,175,252,63,64,127,0,47,192,191,7,255,191,0,127,0,47,192,44,0,255,254,0,127,0,47,192,0,0,47,252,0,127,0,47,192,0,0,7,252,0,127,0,47,192,0,0,11,244,0,127,0,47,192,0,0,31,224,0,0,0,47,192,0,0,63,192,0,0,0,47,192,0,0,191,128,0,0,0,47,192,0,2,255,0,0,0,0,47,192,0,11,252,0,0,0,0,47,192,0,47,240,0,0,0,0,47,192,1,255,208,0,0,1,85,127,192,7,255,64,0,0,1,255,255,128,2,252,0,0,0,0,255,255,0,0,160,0,0,0,0,255,248,0,0,0,0,0,0,0,0,0,0,
  // 0x521d  初
  29,82,34,35,59,37,1,253,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,11,255,255,255,255,224,0,15,208,11,255,255,255,255,224,0,15,208,11,255,255,255,255,224,0,15,224,1,85,255,85,95,224,63,255,255,224,0,254,0,15,224,63,255,255,244,0,254,0,15,224,63,255,255,240,0,254,0,15,224,0,0,15,208,0,253,0,15,224,0,0,47,192,0,253,0,15,224,0,0,63,64,0,253,0,15,224,0,0,255,0,0,253,0,15,224,0,1,252,40,1,252,0,15,208,0,3,248,126,1,252,0,15,208,0,15,240,253,1,252,0,15,208,0,47,250,244,2,252,0,15,208,0,191,255,208,3,248,0,15,208,2,255,255,192,3,248,0,15,208,11,255,255,224,3,244,0,15,208,47,255,219,248,7,240,0,31,192,191,223,210,252,15,240,0,31,192,127,79,208,244,15,224,0,31,192,45,15,208,32,47,192,0,31,192,0,15,208,0,63,192,0,47,192,0,15,208,0,191,64,0,47,192,0,15,208,0,255,0,0,63,192,0,15,208,3,253,0,0,63,128,0,15,208,11,252,0,0,63,64,0,15,208,47,240,0,0,255,64,0,15,208,255,208,11,255,255,0,0,15,208,255,128,3,255,253,0,0,15,208,62,0,3,255,248,0,0,15,208,4,0,1,85,64,0,
  // 0x5230  到
  48,82,33,34,50,37,1,253,0,0,0,0,0,0,0,26,128,0,0,0,0,0,0,0,31,192,63,255,255,255,254,0,0,31,192,63,255,255,255,254,0,0,31,192,63,255,255,255,254,63,64,31,192,0,15,240,0,0,63,64,31,192,0,15,224,4,0,63,64,31,192,0,31,192,127,0,63,64,31,192,0,47,192,63,128,63,64,31,192,0,63,64,31,208,63,64,31,192,0,127,0,11,240,63,64,31,192,21,255,255,255,252,63,64,31,192,63,255,255,255,253,63,64,31,192,63,255,255,255,255,63,64,31,192,63,169,84,0,63,63,64,31,192,0,0,127,0,24,63,64,31,192,0,0,127,0,0,63,64,31,192,0,0,127,0,0,63,64,31,192,0,0,127,0,0,63,64,31,192,15,255,255,255,248,63,64,31,192,15,255,255,255,248,63,64,31,192,15,255,255,255,248,63,64,31,192,0,0,127,0,0,63,64,31,192,0,0,127,0,0,63,64,31,192,0,0,127,0,0,21,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,22,190,0,0,31,192,0,5,191,255,255,0,0,31,192,111,255,255,255,255,0,0,31,192,127,255,255,255,233,0,149,127,192,63,255,250,80,0,0,255,255,192,62,148,0,0,0,0,255,255,64,0,0,0,0,0,0,191,248,0,
  // 0x5236  制
  54,82,34,35,59,37,1,253,0,0,31,128,0,0,0,5,64,0,248,47,128,0,0,0,15,208,2,252,47,128,0,0,0,15,208,3,248,47,128,0,1,248,15,208,3,244,47,128,0,2,248,15,208,7,255,255,255,254,2,248,15,208,11,255,255,255,254,2,248,15,208,15,255,255,255,254,2,248,15,208,47,192,47,128,0,2,248,15,208,63,128,47,128,0,2,248,15,208,127,0,47,128,0,2,248,15,208,10,0,47,128,0,2,248,15,208,127,255,255,255,255,194,248,15,208,127,255,255,255,255,194,248,15,208,127,255,255,255,255,194,248,15,208,0,0,47,128,0,2,248,15,208,0,0,47,128,0,2,248,15,208,0,0,47,128,0,2,248,15,208,0,0,47,128,0,2,248,15,208,11,255,255,255,255,2,248,15,208,11,255,255,255,255,2,248,15,208,11,255,255,255,255,2,248,15,208,11,208,47,128,63,2,248,15,208,11,208,47,128,63,2,248,15,208,11,208,47,128,63,1,164,15,208,11,208,47,128,63,0,0,15,208,11,208,47,128,63,0,0,15,208,11,208,47,128,63,0,0,15,208,11,208,47,128,63,0,0,15,208,11,208,47,143,255,0,0,15,208,11,208,47,143,254,0,0,15,208,11,208,47,139,248,0,21,111,192,0,0,47,128,0,0,63,255,192,0,0,47,128,0,0,63,255,128,0,0,31,128,0,0,47,249,0,
  // 0x5237  刷
  55,82,33,35,59,37,1,253,0,0,0,0,0,0,0,5,64,0,0,0,0,0,0,0,15,192,3,255,255,255,255,0,0,15,192,3,255,255,255,255,1,64,15,192,3,255,255,255,255,7,224,15,192,3,240,0,0,63,7,224,15,192,3,240,0,0,63,7,224,15,192,3,240,0,0,63,7,224,15,192,3,240,0,0,63,7,224,15,192,3,255,255,255,255,7,224,15,192,3,255,255,255,255,7,224,15,192,3,255,255,255,255,7,224,15,192,3,240,1,248,0,7,224,15,192,3,240,1,248,0,7,224,15,192,3,240,1,248,0,7,224,15,192,3,240,1,248,0,7,224,15,192,3,251,255,255,255,71,224,15,192,3,255,255,255,255,71,224,15,192,7,255,255,255,255,71,224,15,192,7,239,193,248,31,71,224,15,192,7,239,193,248,31,71,224,15,192,7,239,193,248,31,71,224,15,192,11,239,193,248,31,71,224,15,192,11,223,193,248,31,71,224,15,192,15,223,193,248,31,71,224,15,192,15,207,193,248,31,65,80,15,192,15,207,193,248,31,64,0,15,192,31,207,193,248,31,64,0,15,192,31,143,193,251,255,64,0,15,192,63,79,193,249,255,0,0,15,192,63,15,193,248,164,0,0,15,192,190,0,1,248,0,0,85,111,192,189,0,1,248,0,0,127,255,192,28,0,1,248,0,0,63,255,64,0,0,1,248,0,0,47,249,0,
  // 0x5275  創
  117,82,33,36,68,37,1,252,0,0,5,64,0,0,0,0,0,0,0,63,240,0,0,0,31,192,0,0,191,252,0,0,0,31,192,0,1,255,255,64,0,0,31,192,0,3,252,127,208,0,0,31,192,0,15,244,31,244,31,192,31,192,0,63,208,7,253,31,192,31,192,0,255,213,86,255,95,192,31,192,7,255,255,255,191,31,192,31,192,63,245,255,255,93,31,192,31,192,127,128,0,0,0,31,192,31,192,13,85,85,85,84,31,192,31,192,0,255,255,255,252,31,192,31,192,0,255,255,255,252,31,192,31,192,0,252,0,0,252,31,192,31,192,0,252,0,0,252,31,192,31,192,0,255,255,255,252,31,192,31,192,0,255,255,255,252,31,192,31,192,0,252,0,1,252,31,192,31,192,0,252,0,0,252,31,192,31,192,0,255,255,255,252,31,192,31,192,0,255,255,255,252,31,192,31,192,1,253,85,85,84,31,192,31,192,1,248,0,0,0,31,192,31,192,2,254,170,170,168,31,192,31,192,3,255,255,255,253,31,192,31,192,3,255,255,255,253,0,0,31,192,7,255,192,0,189,0,0,31,192,15,223,192,0,189,0,0,31,192,15,207,192,0,189,0,0,31,192,63,143,192,0,189,0,0,31,192,127,15,255,255,253,0,85,127,192,62,15,255,255,253,0,255,255,192,12,15,234,170,253,0,191,255,64,0,15,192,0,105,0,127,248,0,0,0,0,0,0,0,0,0,0,
  // 0x529b  力
  155,82,32,35,24,37,2,253,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,63,255,255,255,255,255,255,254,63,255,255,255,255,255,255,253,63,255,255,255,255,255,255,253,26,170,170,191,170,170,170,253,0,0,0,191,0,0,0,253,0,0,0,191,0,0,1,253,0,0,0,255,0,0,1,252,0,0,0,254,0,0,1,252,0,0,0,254,0,0,1,252,0,0,1,253,0,0,2,252,0,0,3,252,0,0,2,252,0,0,3,252,0,0,2,252,0,0,11,248,0,0,3,252,0,0,15,240,0,0,3,248,0,0,31,224,0,0,3,248,0,0,63,208,0,0,3,248,0,0,191,192,0,0,3,244,0,1,255,0,0,0,7,244,0,7,254,0,0,0,11,240,0,15,252,0,0,0,11,240,0,63,240,0,0,0,15,240,1,255,208,0,0,0,31,224,11,255,64,0,0,0,63,208,63,253,0,0,15,255,255,192,191,240,0,0,7,255,255,64,47,128,0,0,3,255,253,0,9,0,0,0,1,85,64,0,
  // 0x52a0  加
  160,82,33,36,68,37,1,252,0,5,64,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,85,85,85,64,0,15,208,0,0,255,255,255,192,0,15,208,0,0,255,255,255,192,63,255,255,255,208,255,255,255,192,63,255,255,255,208,252,0,47,192,63,255,255,255,208,252,0,47,192,21,111,213,95,208,252,0,47,192,0,31,192,15,208,252,0,47,192,0,31,192,15,192,252,0,47,192,0,31,192,15,192,252,0,47,192,0,31,192,15,192,252,0,47,192,0,31,192,15,192,252,0,47,192,0,47,192,15,192,252,0,47,192,0,47,128,15,192,252,0,47,192,0,63,128,15,192,252,0,47,192,0,63,64,31,192,252,0,47,192,0,63,64,31,192,252,0,47,192,0,63,0,31,192,252,0,47,192,0,127,0,31,192,252,0,47,192,0,191,0,31,192,252,0,47,192,0,254,0,31,192,252,0,47,192,1,253,0,47,192,252,0,47,192,2,252,0,47,192,252,0,47,192,3,252,0,47,128,252,0,47,192,7,244,0,63,128,255,255,255,192,15,240,0,63,64,255,255,255,192,31,224,0,191,64,255,255,255,192,63,192,255,255,0,253,85,127,192,191,128,191,254,0,252,0,47,192,47,0,191,248,0,252,0,47,128,8,0,21,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x52d5  動
  213,82,34,36,68,37,1,252,0,0,0,0,64,1,80,0,0,0,0,22,191,208,3,240,0,0,42,255,255,255,240,3,240,0,0,63,255,255,255,144,3,240,0,0,31,250,254,0,0,3,240,0,0,0,0,189,0,0,3,240,0,0,42,170,254,170,164,3,240,0,0,127,255,255,255,252,3,240,0,0,127,255,255,255,253,91,240,0,0,0,0,189,0,3,255,255,255,224,0,0,189,0,3,255,255,255,224,31,255,255,255,251,255,255,255,224,31,255,255,255,244,7,240,11,224,31,149,254,86,244,7,240,11,224,31,64,189,2,244,11,224,15,224,31,128,189,2,244,11,224,15,224,31,255,255,255,244,11,224,15,208,31,255,255,255,244,15,208,15,208,31,64,189,2,244,15,208,15,208,31,64,189,2,244,15,208,15,208,31,255,255,255,244,31,192,15,208,31,255,255,255,244,31,192,15,208,5,85,254,85,80,63,128,15,208,0,0,189,0,0,63,64,15,192,10,170,254,170,160,127,0,15,192,31,255,255,255,244,191,0,15,192,31,255,255,255,245,254,0,31,192,0,0,189,0,3,252,0,31,192,0,0,189,0,7,252,0,31,192,0,0,190,107,255,244,0,47,192,1,90,255,255,255,224,0,63,128,127,255,255,255,255,192,0,127,64,63,255,255,171,255,64,255,255,0,62,149,0,1,253,0,191,254,0,0,0,0,0,116,0,191,248,0,0,0,0,0,0,0,0,0,0,
  // 0x5316  化
  22,83,35,34,50,37,1,253,0,0,15,128,63,64,0,0,0,0,0,47,192,63,64,0,0,0,0,0,63,192,63,64,0,0,0,0,0,191,64,63,64,0,0,0,0,0,255,0,63,64,0,0,0,0,3,253,0,63,64,0,0,0,0,7,248,0,63,64,0,8,0,0,15,240,0,63,64,0,62,0,0,63,224,0,63,64,0,255,64,0,191,224,0,63,64,7,255,128,1,255,224,0,63,64,63,253,0,3,255,224,0,63,65,255,240,0,15,255,224,0,63,79,255,64,0,63,255,224,0,63,255,248,0,0,255,223,224,0,63,255,192,0,0,191,79,224,0,63,253,0,0,0,62,15,224,0,63,208,0,0,0,40,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,1,0,0,15,224,0,63,64,0,2,228,0,15,224,0,63,64,0,2,248,0,15,224,0,63,64,0,2,248,0,15,224,0,63,64,0,3,244,0,15,224,0,63,64,0,3,244,0,15,224,0,63,192,0,11,240,0,15,224,0,63,255,255,255,224,0,15,224,0,31,255,255,255,192,0,15,224,0,7,255,255,255,64,0,10,144,0,0,0,0,0,0,
  // 0x534a  半
  74,83,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,104,0,7,240,0,15,64,0,1,253,0,7,240,0,31,224,0,0,255,0,7,240,0,63,192,0,0,127,128,7,240,0,127,128,0,0,63,192,7,240,0,255,0,0,0,31,224,7,240,1,254,0,0,0,15,240,7,240,3,252,0,0,0,7,244,7,240,7,244,0,0,0,3,224,7,240,7,240,0,0,0,1,0,7,240,0,64,0,0,0,0,0,7,240,0,0,0,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,5,85,85,91,249,85,85,84,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,85,91,249,85,85,85,64,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,
  // 0x5354  協
  84,83,34,36,68,37,1,252,0,63,0,0,0,63,0,0,0,0,63,0,0,0,63,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,31,255,255,255,255,128,0,63,0,31,255,255,255,255,128,0,63,0,15,255,255,255,255,64,0,63,0,0,2,248,0,63,64,0,63,0,0,3,244,0,63,64,0,127,0,0,15,240,0,63,0,127,255,255,0,47,192,0,63,0,127,255,255,0,255,64,0,191,0,127,255,255,11,254,0,255,254,0,0,63,0,127,244,0,255,252,0,0,63,0,63,128,0,191,224,0,0,63,0,24,0,0,0,0,0,0,63,0,15,128,0,15,192,0,0,63,0,31,128,0,15,192,0,0,63,0,31,128,0,31,192,0,0,63,0,31,128,0,31,128,0,0,63,15,255,255,235,255,255,240,0,63,15,255,255,235,255,255,240,0,63,10,191,239,230,191,235,240,0,63,0,47,7,208,47,67,240,0,63,0,63,7,208,63,3,240,0,63,0,63,7,208,63,3,240,0,63,0,62,7,208,127,3,240,0,63,0,189,7,208,189,3,224,0,63,0,252,11,208,252,3,224,0,63,1,252,11,193,252,7,224,0,63,3,244,11,195,244,7,224,0,63,11,240,15,203,240,11,208,0,63,31,210,191,239,194,175,192,0,63,31,66,255,95,66,255,192,0,63,6,2,254,5,1,254,0,0,0,0,0,0,0,0,0,0,
  // 0x5361  卡
  97,83,33,35,59,37,2,253,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,255,255,255,192,0,0,0,0,15,255,255,255,192,0,0,0,0,15,255,255,255,192,0,0,0,0,15,229,85,85,64,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,85,85,85,95,229,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,255,144,0,0,0,0,0,0,15,255,254,64,0,0,0,0,0,15,255,255,248,0,0,0,0,0,15,226,255,255,208,0,0,0,0,15,224,27,255,244,0,0,0,0,15,224,0,127,240,0,0,0,0,15,224,0,6,208,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,208,0,0,0,0,
  // 0x5370  印
  112,83,30,35,24,37,4,253,0,0,9,0,0,0,0,0,0,1,191,64,0,0,0,0,0,31,255,209,85,85,85,80,134,255,255,131,255,255,255,240,255,255,244,3,255,255,255,240,255,254,0,3,255,255,255,240,255,128,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,255,255,255,195,248,0,7,240,255,255,255,195,248,0,7,240,255,255,255,195,248,0,7,240,254,85,85,67,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,255,255,255,195,248,26,175,240,255,255,255,195,248,15,255,240,255,255,255,195,248,11,255,208,253,85,85,67,248,7,254,64,253,0,0,3,248,0,0,0,253,0,0,3,248,0,0,0,84,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,2,164,0,0,0,
  // 0x5378  卸
  120,83,33,35,59,37,1,253,0,46,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,127,0,0,0,255,255,255,192,0,190,0,0,0,255,255,255,192,0,255,255,255,240,255,255,255,192,2,255,255,255,240,254,0,31,192,3,255,255,255,240,253,0,15,192,11,240,127,0,0,253,0,15,192,31,208,63,0,0,253,0,15,192,63,192,63,0,0,253,0,15,192,15,0,63,0,0,253,0,15,192,0,0,63,0,0,253,0,15,192,63,255,255,255,252,253,0,15,192,63,255,255,255,252,253,0,15,192,63,255,255,255,252,253,0,15,192,0,0,127,0,0,253,0,15,192,0,0,63,0,0,253,0,15,192,1,80,63,0,0,253,0,15,192,3,240,63,0,0,253,0,15,192,3,240,63,255,224,253,0,15,192,3,240,63,255,224,253,0,15,192,3,240,63,255,224,253,0,15,192,3,240,63,0,0,253,0,15,192,3,240,63,0,0,253,0,15,192,3,240,63,0,0,253,0,15,192,3,240,63,0,0,253,10,175,192,3,240,63,0,20,253,15,255,192,3,240,63,111,252,253,11,255,128,3,246,255,255,252,253,7,249,0,111,255,255,255,252,253,0,0,0,191,255,255,249,0,253,0,0,0,127,255,148,0,0,253,0,0,0,122,64,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,
  // 0x537b  卻
  123,83,33,35,59,37,1,253,0,0,21,0,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,1,255,244,0,255,255,255,192,0,3,255,253,0,255,255,255,192,0,15,245,255,128,255,255,255,192,0,63,208,127,224,254,85,95,192,0,255,64,31,248,254,0,15,192,7,254,0,7,252,254,0,15,192,47,244,0,1,244,254,0,15,192,31,208,21,0,144,254,0,15,192,11,0,191,192,0,254,0,15,192,0,0,255,240,0,254,0,15,192,0,2,255,252,0,254,0,15,192,0,11,250,255,0,254,0,15,192,0,31,240,255,192,254,0,15,192,0,63,192,63,240,254,0,15,192,0,255,64,15,248,254,0,15,192,7,253,0,3,253,254,0,15,192,31,244,0,1,248,254,0,15,192,191,208,0,0,176,254,0,15,192,127,255,255,255,192,254,0,15,192,28,255,255,255,192,254,0,15,192,0,255,255,255,192,254,0,15,192,0,252,0,31,192,254,0,15,192,0,252,0,31,192,254,0,31,192,0,252,0,31,192,254,31,255,192,0,252,0,31,192,254,15,255,192,0,252,0,31,192,254,11,255,0,0,252,0,31,192,254,1,80,0,0,255,255,255,192,254,0,0,0,0,255,255,255,192,254,0,0,0,0,255,255,255,192,254,0,0,0,0,252,0,31,192,254,0,0,0,0,252,0,15,192,254,0,0,0,0,20,0,0,0,189,0,0,0,
  // 0x539f  原
  159,83,34,33,41,37,1,253,1,255,255,255,255,255,255,255,240,1,255,255,255,255,255,255,255,240,1,255,255,255,255,255,255,255,240,1,252,0,0,15,244,0,0,0,1,252,0,0,15,240,0,0,0,1,252,0,0,31,224,0,0,0,1,252,10,170,191,250,170,168,0,1,252,15,255,255,255,255,252,0,1,252,15,255,255,255,255,252,0,1,252,15,208,0,0,2,252,0,1,252,15,208,0,0,2,252,0,1,252,15,208,0,0,2,252,0,1,252,15,255,255,255,255,252,0,1,252,15,255,255,255,255,252,0,1,252,15,234,170,170,171,252,0,1,252,15,208,0,0,2,252,0,1,252,15,208,0,0,2,252,0,2,252,15,250,170,170,171,252,0,2,248,15,255,255,255,255,252,0,2,248,15,255,255,255,255,252,0,3,248,0,0,7,240,0,0,0,3,244,0,0,7,240,0,0,0,3,244,0,249,7,240,31,64,0,7,240,2,253,7,240,63,208,0,11,240,7,248,7,240,15,244,0,11,224,15,240,7,240,3,253,0,15,224,63,208,7,240,0,255,64,31,208,255,128,7,240,0,63,192,47,199,254,0,7,240,0,31,240,63,143,248,0,7,240,0,11,240,127,66,224,15,255,240,0,3,128,127,0,0,11,255,224,0,0,0,5,0,0,7,255,64,0,0,0,
  // 0x53cd  反
  205,83,33,33,41,37,2,253,0,85,85,85,85,85,85,84,0,0,255,255,255,255,255,255,253,0,0,255,255,255,255,255,255,253,0,0,255,255,255,255,255,255,253,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,192,0,0,254,111,229,85,85,127,192,0,0,254,15,240,0,0,191,64,0,0,253,11,244,0,0,255,0,0,0,253,3,252,0,2,254,0,0,0,253,2,253,0,3,252,0,0,0,252,0,255,0,11,248,0,0,1,252,0,191,128,31,240,0,0,1,252,0,63,208,63,208,0,0,2,252,0,31,240,255,128,0,0,3,248,0,11,255,255,0,0,0,3,244,0,3,255,252,0,0,0,7,240,0,0,255,244,0,0,0,11,240,0,2,255,248,0,0,0,15,224,0,31,255,255,64,0,0,31,208,0,191,254,255,244,0,0,63,192,47,255,208,127,255,144,0,127,71,255,254,0,11,255,255,64,255,7,255,240,0,1,255,255,64,61,2,254,0,0,0,11,254,0,8,0,208,0,0,0,0,108,0,
  // 0x53d6  取
  214,83,35,33,41,37,1,253,63,255,255,255,252,0,0,0,0,63,255,255,255,252,0,0,0,0,63,255,255,255,252,0,0,0,0,2,252,0,63,143,255,255,255,208,1,252,0,63,143,255,255,255,208,1,252,0,63,143,255,255,255,208,1,252,0,63,133,165,85,111,192,1,252,0,63,135,240,0,31,192,1,255,255,255,135,240,0,47,192,1,255,255,255,131,244,0,63,128,1,255,255,255,131,248,0,63,64,1,252,0,63,130,252,0,127,0,1,252,0,63,129,252,0,191,0,1,252,0,63,128,253,0,254,0,1,252,0,63,128,191,0,253,0,1,252,0,63,128,127,2,252,0,1,255,255,255,128,63,67,252,0,1,255,255,255,128,47,199,244,0,1,255,255,255,128,31,223,240,0,1,252,0,63,128,15,255,224,0,1,252,0,63,128,7,255,192,0,1,252,0,63,128,3,255,128,0,1,252,0,63,128,2,255,0,0,1,252,26,255,128,2,255,64,0,6,255,255,255,128,11,255,192,0,255,255,255,255,128,31,255,240,0,191,255,254,127,128,127,239,252,0,127,233,0,63,129,255,131,255,0,16,0,0,63,139,254,0,255,208,0,0,0,63,255,248,0,127,248,0,0,0,63,191,208,0,15,244,0,0,0,63,143,0,0,2,208,0,0,0,47,64,0,0,0,64,
  // 0x53f0  台
  240,83,33,35,59,37,2,253,0,0,1,228,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,31,240,0,6,0,0,0,0,0,63,208,0,47,192,0,0,0,0,127,128,0,63,244,0,0,0,0,255,0,0,11,253,0,0,0,2,253,0,0,2,255,64,0,0,3,252,0,0,0,191,208,0,0,11,249,106,171,255,255,240,0,127,255,255,255,255,255,255,252,0,127,255,255,255,255,255,255,255,0,127,255,255,255,250,169,85,255,128,37,84,0,0,0,0,0,127,192,0,0,0,0,0,0,0,47,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,21,85,85,85,85,85,0,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,85,85,85,85,191,64,0,0,127,0,0,0,0,127,64,0,
  // 0x5408  合
  8,84,35,35,59,37,1,253,0,0,0,2,253,0,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,31,255,192,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,255,143,248,0,0,0,0,0,3,255,3,255,0,0,0,0,0,15,252,0,255,192,0,0,0,0,63,240,0,63,240,0,0,0,1,255,192,0,15,253,0,0,0,7,255,0,0,3,255,128,0,0,47,252,0,0,0,191,244,0,1,255,224,0,0,0,31,254,0,15,255,255,255,255,255,255,255,224,127,254,191,255,255,255,248,191,248,63,244,191,255,255,255,248,31,240,31,64,0,0,0,0,0,3,208,4,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,192,0,0,15,255,255,255,255,255,192,0,0,15,255,255,255,255,255,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,255,255,255,255,255,192,0,0,15,255,255,255,255,255,192,0,0,15,255,255,255,255,255,192,0,0,15,224,0,0,0,47,192,0,0,11,208,0,0,0,31,192,0,
  // 0x5426  否
  38,84,34,33,41,37,1,253,31,255,255,255,255,255,255,255,208,31,255,255,255,255,255,255,255,208,31,255,255,255,255,255,255,255,208,0,0,0,0,191,224,0,0,0,0,0,0,1,255,128,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,255,252,15,128,0,0,0,0,7,255,252,63,248,0,0,0,0,127,254,252,47,255,64,0,0,2,255,241,252,2,255,240,0,0,47,255,65,252,0,127,254,0,7,255,252,1,252,0,7,255,192,127,255,208,1,252,0,0,191,240,63,254,0,1,252,0,0,31,224,15,224,0,1,252,0,0,3,192,5,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,240,0,0,47,255,255,255,255,255,240,0,0,47,255,255,255,255,255,240,0,0,47,192,0,0,0,15,240,0,0,47,192,0,0,0,15,240,0,0,47,192,0,0,0,15,240,0,0,47,192,0,0,0,15,240,0,0,47,192,0,0,0,15,240,0,0,47,192,0,0,0,15,240,0,0,47,255,255,255,255,255,240,0,0,47,255,255,255,255,255,240,0,0,47,255,255,255,255,255,240,0,0,47,192,0,0,0,15,240,0,0,31,192,0,0,0,10,160,0,
  // 0x544a  告
  74,84,33,36,68,37,2,252,0,2,64,1,252,0,0,0,0,0,11,240,1,252,0,0,0,0,0,15,224,1,252,0,0,0,0,0,31,208,1,252,0,0,0,0,0,63,192,1,252,0,0,0,0,0,127,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,7,252,0,2,253,0,0,0,0,15,240,0,1,252,0,0,0,0,63,224,0,1,252,0,0,0,0,63,192,0,1,252,0,0,0,0,7,0,0,1,252,0,0,0,0,1,0,0,2,253,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,128,0,0,63,255,255,255,255,255,128,0,0,63,255,255,255,255,255,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,255,255,255,255,255,128,0,0,63,255,255,255,255,255,128,0,0,63,255,255,255,255,255,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,0,0,0,0,0,0,0,0,
  // 0x547d  命
  125,84,35,36,68,37,1,252,0,0,0,3,253,0,0,0,0,0,0,0,11,255,64,0,0,0,0,0,0,47,255,208,0,0,0,0,0,0,191,239,244,0,0,0,0,0,2,255,75,254,0,0,0,0,0,11,254,2,255,128,0,0,0,0,47,248,0,191,240,0,0,0,0,255,208,0,47,253,0,0,0,11,255,64,0,7,255,192,0,0,63,253,0,0,1,255,248,0,2,255,223,255,255,255,223,255,128,47,255,15,255,255,255,194,255,248,255,248,15,255,255,255,192,127,252,127,192,0,0,0,0,0,11,240,45,0,0,0,0,0,0,0,208,0,0,0,0,0,0,0,0,0,0,255,255,254,11,255,255,253,0,0,255,255,254,11,255,255,253,0,0,255,255,254,11,255,255,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,255,255,254,11,224,0,253,0,0,255,255,254,11,224,0,253,0,0,255,255,254,11,224,255,253,0,0,252,0,0,11,224,255,252,0,0,252,0,0,11,224,191,224,0,0,252,0,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x548c  和
  140,84,33,35,59,37,1,253,0,0,0,4,0,0,0,0,0,0,0,1,190,0,0,0,0,0,0,1,191,255,128,0,0,0,0,22,255,255,255,129,85,85,85,0,47,255,255,144,11,255,255,255,64,15,255,253,0,11,255,255,255,64,4,0,253,0,11,255,255,255,64,0,0,253,0,11,224,0,63,64,0,0,253,0,11,224,0,63,64,0,0,253,0,11,224,0,63,64,0,0,253,0,11,224,0,63,64,63,255,255,255,203,224,0,63,64,63,255,255,255,203,224,0,63,64,63,255,255,255,203,224,0,63,64,0,7,253,0,11,224,0,63,64,0,11,254,0,11,224,0,63,64,0,15,255,128,11,224,0,63,64,0,31,255,208,11,224,0,63,64,0,63,255,244,11,224,0,63,64,0,127,255,252,11,224,0,63,64,0,253,253,255,11,224,0,63,64,1,252,253,63,139,224,0,63,64,3,244,253,31,203,224,0,63,64,11,240,253,15,75,224,0,63,64,31,208,253,2,11,224,0,63,64,63,192,253,0,11,224,0,63,64,191,64,253,0,11,245,85,127,64,126,0,253,0,11,255,255,255,64,60,0,253,0,11,255,255,255,64,0,0,253,0,11,255,255,255,64,0,0,253,0,11,224,0,63,64,0,0,253,0,11,224,0,63,64,0,0,253,0,11,224,0,63,64,0,0,253,0,0,0,0,0,0,0,0,252,0,0,0,0,0,0,
  // 0x555f  啟
  95,85,35,36,68,37,1,252,0,0,104,0,0,2,228,0,0,0,0,252,0,0,2,248,0,0,0,0,254,0,0,3,244,0,0,0,0,127,0,0,3,240,0,0,0,0,63,64,0,7,240,0,0,3,255,255,255,224,7,240,0,0,3,255,255,255,224,15,224,0,0,3,255,255,255,224,15,255,255,244,3,240,0,7,224,31,255,255,244,3,240,0,7,224,47,255,255,244,3,240,0,7,224,63,128,47,128,3,240,0,7,224,127,128,63,64,3,240,0,7,224,255,128,63,64,3,255,255,255,225,255,192,63,0,3,255,255,255,227,255,192,127,0,3,255,255,255,231,255,208,127,0,3,240,0,0,7,247,208,190,0,3,240,0,0,1,211,240,253,0,3,240,0,0,0,67,240,252,0,3,240,0,0,0,2,245,252,0,7,247,255,255,240,1,250,248,0,7,251,255,255,240,0,255,244,0,7,235,255,255,240,0,191,240,0,11,235,208,3,240,0,127,224,0,15,219,208,3,240,0,63,192,0,15,219,208,3,240,0,63,192,0,15,203,208,3,240,0,191,208,0,31,203,208,3,240,1,255,240,0,47,139,208,3,240,3,255,252,0,63,75,255,255,240,15,245,254,0,127,11,255,255,240,63,224,255,64,190,11,255,255,240,255,192,63,224,45,11,208,3,247,255,0,31,248,4,11,208,3,242,248,0,3,240,0,1,64,0,0,208,0,0,128,0,0,0,0,0,0,0,0,0,
  // 0x55ae  單
  174,85,33,33,41,37,2,253,7,255,255,253,15,255,255,248,0,7,255,255,253,15,255,255,248,0,7,240,0,253,15,192,2,248,0,7,240,0,253,15,192,2,248,0,7,240,0,253,15,192,3,248,0,7,255,255,253,15,255,255,248,0,7,255,255,253,15,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,255,170,175,254,170,175,224,0,0,252,0,7,240,0,15,224,0,0,252,0,7,240,0,15,224,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,254,170,171,250,170,175,224,0,0,252,0,7,240,0,15,224,0,0,252,0,7,240,0,15,224,0,0,255,170,175,254,170,175,224,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,
  // 0x5634  嘴
  52,86,34,36,68,37,2,252,0,0,0,1,244,3,224,0,0,0,0,0,1,244,3,224,0,0,0,0,1,145,244,3,224,24,0,127,255,210,241,244,3,225,255,0,127,255,210,241,255,243,255,253,0,127,255,210,241,255,243,255,208,0,125,7,210,241,249,83,253,0,0,125,7,210,241,244,3,224,0,0,125,7,210,241,244,3,224,3,64,125,7,210,241,245,103,224,3,208,125,7,210,251,255,247,240,7,208,125,7,239,255,255,243,255,255,192,125,7,239,255,254,2,255,255,128,125,7,223,149,252,0,90,165,0,125,7,208,3,255,255,224,0,0,125,7,208,11,255,255,244,0,0,125,7,208,47,213,95,224,0,0,125,7,208,191,64,47,192,0,0,125,7,211,255,255,255,255,253,0,125,7,255,255,255,255,255,253,0,125,7,255,255,85,190,85,253,0,127,255,219,127,0,125,0,189,0,127,255,208,63,0,125,0,189,0,127,255,208,63,255,255,255,253,0,125,0,0,63,255,255,255,253,0,125,0,0,63,0,125,0,189,0,125,0,0,127,0,125,0,189,0,0,0,0,191,255,255,255,253,0,0,0,0,255,255,255,255,253,0,0,0,1,253,85,85,85,253,0,0,0,3,248,0,0,0,189,0,0,0,15,240,0,0,0,189,0,0,0,63,224,0,0,150,253,0,0,0,127,128,0,0,255,252,0,0,0,14,0,0,0,191,228,0,0,0,0,0,0,0,0,0,0,
  // 0x5668  器
  104,86,35,34,50,37,1,252,2,255,255,254,2,255,255,254,0,2,255,255,254,2,255,255,254,0,2,255,255,254,2,255,255,254,0,2,248,0,190,2,248,0,190,0,2,248,0,190,2,248,0,190,0,2,248,0,190,2,248,0,190,0,2,248,0,190,2,248,0,190,0,2,254,170,254,2,254,170,254,0,2,255,255,254,2,255,255,254,0,2,255,255,255,226,255,255,254,0,0,0,0,7,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,47,224,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,0,0,47,244,0,127,192,0,0,0,1,255,224,0,47,244,0,0,0,11,255,128,0,11,255,0,0,0,191,253,0,0,1,255,224,0,11,255,240,0,0,0,127,255,64,191,255,255,255,3,255,255,255,248,63,255,255,255,3,255,255,255,244,30,255,255,255,3,255,255,255,224,0,252,0,127,3,240,0,252,0,0,252,0,127,3,240,0,252,0,0,252,0,127,3,240,0,252,0,0,252,0,127,3,240,0,252,0,0,252,0,127,3,240,0,252,0,0,255,255,255,3,255,255,252,0,0,255,255,255,3,255,255,252,0,0,255,255,255,3,255,255,252,0,0,252,0,127,3,240,0,252,0,0,0,0,0,0,0,0,0,0,
  // 0x5674  噴
  116,86,33,36,68,37,3,252,0,0,0,0,1,248,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,2,248,0,0,0,0,0,2,255,255,255,255,252,0,255,255,194,255,255,255,255,252,0,255,255,193,85,86,253,85,84,0,255,255,192,10,130,248,42,0,0,248,15,192,15,194,248,63,0,0,248,11,192,15,192,0,63,0,0,248,11,223,255,255,255,255,255,128,248,11,223,255,255,255,255,255,128,248,11,213,95,213,85,127,85,0,248,11,192,15,192,0,63,0,0,248,11,192,5,64,0,21,0,0,248,11,192,255,255,255,255,240,0,248,11,192,255,255,255,255,240,0,248,11,192,252,0,0,3,240,0,248,11,192,252,0,0,3,240,0,248,11,192,255,255,255,255,240,0,248,11,192,255,255,255,255,240,0,248,11,192,252,0,0,3,240,0,255,255,192,252,0,0,3,240,0,255,255,192,252,0,0,3,240,0,255,255,192,255,255,255,255,240,0,248,0,0,255,255,255,255,240,0,248,0,0,252,0,0,3,240,0,248,0,0,252,0,0,3,240,0,0,0,0,255,255,255,255,240,0,0,0,0,255,255,255,255,240,0,0,0,0,3,224,1,244,0,0,0,0,0,47,248,3,255,64,0,0,0,11,255,208,0,191,244,0,0,1,255,253,0,0,11,254,0,0,0,191,208,0,0,1,255,64,0,0,45,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,
  // 0x56de  回
  222,86,31,34,16,37,3,253,85,85,85,85,85,85,85,84,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,255,255,255,248,2,252,254,0,255,255,255,248,2,252,254,0,255,255,255,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,255,255,255,248,2,252,254,0,255,255,255,248,2,252,254,0,255,255,255,248,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,3,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,
  // 0x56e0  因
  224,86,31,34,16,37,3,253,85,85,85,85,85,85,85,84,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,253,0,0,0,0,0,2,252,253,0,0,10,128,0,2,252,253,0,0,31,192,0,2,252,253,0,0,31,192,0,2,252,253,0,0,31,192,0,2,252,253,0,0,31,192,0,2,252,253,0,0,31,128,0,2,252,253,47,255,255,255,255,226,252,253,47,255,255,255,255,226,252,253,47,255,255,255,255,226,252,253,0,0,63,224,0,2,252,253,0,0,63,240,0,2,252,253,0,0,191,244,0,2,252,253,0,0,255,248,0,2,252,253,0,1,253,252,0,2,252,253,0,3,252,191,0,2,252,253,0,7,244,63,128,2,252,253,0,31,240,47,208,2,252,253,0,127,192,15,248,2,252,253,2,255,64,7,255,66,252,253,47,253,0,1,255,242,252,253,47,244,0,0,127,210,252,253,15,128,0,0,11,130,252,253,0,0,0,0,0,2,252,253,0,0,0,0,0,2,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,254,85,85,85,85,85,86,252,253,0,0,0,0,0,2,252,
  // 0x56fa  固
  250,86,31,33,8,37,3,253,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,254,0,0,0,0,0,2,252,254,0,0,10,128,0,2,252,254,0,0,15,192,0,2,252,254,0,0,15,192,0,2,252,254,0,0,15,192,0,2,252,254,15,255,255,255,255,210,252,254,31,255,255,255,255,226,252,254,31,255,255,255,255,226,252,254,0,0,15,192,0,2,252,254,0,0,15,192,0,2,252,254,0,0,15,192,0,2,252,254,0,0,15,192,0,2,252,254,0,255,255,255,253,2,252,254,0,255,255,255,253,2,252,254,0,254,170,170,253,2,252,254,0,252,0,0,189,2,252,254,0,252,0,0,189,2,252,254,0,252,0,0,189,2,252,254,0,252,0,0,189,2,252,254,0,254,170,170,253,2,252,254,0,255,255,255,253,2,252,254,0,255,255,255,253,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,254,0,0,0,0,0,3,252,254,0,0,0,0,0,2,252,
  // 0x5716  圖
  22,87,31,35,24,37,3,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,253,0,0,0,0,0,1,252,253,0,0,0,0,0,1,252,253,0,255,255,255,252,1,252,253,0,255,255,255,252,1,252,253,0,252,0,0,252,1,252,253,0,252,0,0,252,1,252,253,0,255,255,255,252,1,252,253,0,255,255,255,248,1,252,253,0,0,15,192,0,1,252,253,63,255,255,255,255,245,252,253,63,255,255,255,255,245,252,253,0,0,0,0,0,1,252,253,0,0,0,0,0,1,252,253,3,255,255,255,255,1,252,253,3,255,255,255,255,1,252,253,3,224,0,0,63,1,252,253,3,225,170,168,63,1,252,253,3,225,255,252,63,1,252,253,3,225,224,60,63,1,252,253,3,225,224,60,63,1,252,253,3,225,255,252,63,1,252,253,3,225,170,168,63,1,252,253,3,224,0,0,63,1,252,253,3,255,255,255,255,1,252,253,3,255,255,255,255,1,252,253,0,0,0,0,0,1,252,253,0,0,0,0,0,1,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,253,0,0,0,0,0,1,252,0,0,0,0,0,0,0,0,
  // 0x5728  在
  40,87,34,35,59,37,1,253,0,0,0,57,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,5,85,86,253,85,85,85,85,64,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,0,0,31,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,64,0,63,64,0,0,0,0,255,0,0,63,64,0,0,0,2,253,0,0,63,64,0,0,0,7,252,0,0,63,64,0,0,0,15,240,0,0,63,64,0,0,0,63,224,0,0,63,64,0,0,0,255,208,0,0,127,64,0,0,3,255,208,63,255,255,255,255,0,15,255,208,63,255,255,255,255,0,127,255,208,63,255,255,255,255,0,127,223,208,0,0,63,64,0,0,47,15,208,0,0,63,64,0,0,8,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,127,64,0,0,0,15,209,255,255,255,255,255,224,0,15,209,255,255,255,255,255,224,0,15,209,255,255,255,255,255,224,0,15,208,0,0,0,0,0,0,
  // 0x578b  型
  139,87,33,34,50,37,2,254,0,0,0,0,0,0,0,84,0,0,0,0,0,0,0,0,252,0,31,255,255,255,244,63,0,252,0,31,255,255,255,244,63,0,252,0,31,255,255,255,244,63,0,252,0,0,63,0,253,0,63,0,252,0,0,63,0,253,0,63,0,252,0,0,63,0,253,0,63,0,252,0,0,63,0,253,0,63,0,252,0,191,255,255,255,252,63,0,252,0,191,255,255,255,252,63,0,252,0,191,255,255,255,252,63,0,252,0,0,191,0,253,0,63,0,252,0,0,254,0,253,0,63,0,252,0,0,253,0,253,0,63,0,252,0,3,252,0,253,0,0,0,252,0,11,244,0,253,0,0,0,252,0,47,240,0,253,0,0,1,252,0,191,192,0,253,0,3,255,252,0,63,0,0,254,160,1,255,248,0,8,0,0,3,244,0,255,144,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,0,0,0,7,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,244,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x57f7  執
  247,87,35,36,68,37,1,252,0,2,244,0,0,47,64,0,0,0,2,248,0,0,63,64,0,0,0,2,248,0,0,63,64,0,0,0,2,248,0,0,63,64,0,0,15,255,255,254,0,63,64,0,0,15,255,255,254,0,63,64,0,0,15,255,255,254,0,63,64,0,0,0,2,248,0,0,63,128,0,0,0,2,248,0,127,255,255,253,0,0,2,248,0,127,255,255,253,0,127,255,255,255,255,255,255,253,0,127,255,255,255,192,63,64,252,0,127,255,255,255,192,63,64,252,0,2,240,0,252,0,63,64,252,0,2,244,0,252,0,63,64,252,0,0,248,2,244,16,63,64,252,0,0,252,3,240,62,63,0,252,0,0,188,3,208,191,255,0,252,0,63,255,255,255,175,255,0,252,0,63,255,255,255,135,255,0,252,0,63,255,255,255,128,255,192,252,0,0,2,248,0,0,255,240,252,0,0,2,248,0,0,255,252,252,0,0,2,248,0,1,255,255,252,0,0,2,248,0,2,252,254,253,0,31,255,255,255,3,244,60,253,0,31,255,255,255,11,240,4,189,32,31,255,255,255,15,224,0,189,56,0,2,248,0,63,192,0,126,60,0,2,248,0,191,128,0,127,60,0,2,248,1,255,0,0,63,60,0,2,248,7,252,0,0,63,252,0,2,248,47,244,0,0,31,248,0,2,248,15,208,0,0,15,240,0,2,244,2,64,0,0,3,224,0,0,0,0,0,0,0,0,0,
  // 0x584a  塊
  74,88,35,35,59,37,1,253,0,42,64,0,0,126,64,0,0,0,63,64,0,0,191,64,0,0,0,63,64,0,0,255,0,0,0,0,63,64,0,0,253,0,0,0,0,63,64,63,255,255,255,255,192,0,63,64,63,255,255,255,255,192,0,63,64,63,255,255,255,255,192,0,63,64,63,0,63,64,31,192,63,255,255,63,0,63,64,31,192,63,255,255,63,0,63,64,31,192,63,255,255,63,170,191,170,191,192,21,127,148,63,255,255,255,255,192,0,63,64,63,255,255,255,255,192,0,63,64,63,0,63,64,31,192,0,63,64,63,0,63,64,31,192,0,63,64,63,0,63,64,31,192,0,63,64,63,0,63,64,31,192,0,63,64,63,255,255,255,255,192,0,63,64,63,255,255,255,255,192,0,63,64,63,255,255,255,255,192,0,63,66,0,254,15,193,144,0,0,63,191,64,253,15,195,224,0,0,127,255,192,253,15,195,210,64,11,255,254,0,253,15,195,199,192,191,255,208,1,252,15,199,195,208,127,249,0,2,252,15,223,239,240,63,128,0,3,248,15,239,255,240,36,0,0,7,244,15,222,148,224,0,0,0,31,240,15,192,0,64,0,0,0,127,208,15,192,1,244,0,0,2,255,128,15,192,2,248,0,0,127,254,0,15,255,255,244,0,0,63,248,0,11,255,255,240,0,0,47,192,0,2,255,255,128,0,0,8,0,0,0,0,0,0,
  // 0x586b  填
  107,88,35,35,59,37,1,253,0,21,0,0,0,63,64,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,255,255,255,255,255,240,0,63,0,255,255,255,255,255,240,0,63,0,255,255,255,255,255,240,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,7,255,255,255,253,0,63,255,255,7,255,255,255,253,0,63,255,255,7,240,0,0,253,0,63,255,255,7,240,0,0,253,0,21,127,84,7,255,255,255,253,0,0,63,0,7,255,255,255,253,0,0,63,0,7,240,0,0,253,0,0,63,0,7,240,0,0,253,0,0,63,0,7,240,0,0,253,0,0,63,0,7,255,255,255,253,0,0,63,0,7,255,255,255,253,0,0,63,0,7,240,0,0,253,0,0,63,0,7,240,0,0,253,0,0,63,75,71,255,255,255,253,0,0,63,255,135,255,255,255,253,0,0,127,255,128,0,0,0,0,0,7,255,253,0,0,0,0,0,0,127,255,211,255,255,255,255,255,248,127,253,3,255,255,255,255,255,248,63,128,3,255,255,255,255,255,244,40,0,0,0,41,0,10,0,0,0,0,0,0,255,128,63,208,0,0,0,0,11,254,0,31,252,0,0,0,1,191,244,0,2,255,64,0,0,15,255,128,0,0,127,224,0,0,3,253,0,0,0,15,244,0,0,0,208,0,0,0,2,64,
  // 0x588a  墊
  138,88,35,34,50,37,1,254,0,1,248,0,0,10,64,0,0,0,2,248,0,0,15,128,0,0,5,86,249,85,0,15,128,0,0,15,255,255,255,0,15,128,0,0,15,255,255,255,0,15,128,0,0,0,2,248,0,15,255,255,252,0,0,2,248,0,15,255,255,252,0,127,255,255,255,213,111,255,252,0,127,255,255,255,208,31,128,252,0,22,245,86,249,64,31,128,252,0,1,244,1,244,9,47,128,252,0,0,248,3,240,31,255,64,252,0,21,253,91,229,127,255,0,252,0,63,255,255,255,215,255,64,252,0,63,255,255,255,208,191,224,252,0,0,2,248,0,0,255,252,252,0,0,2,248,0,2,254,253,252,32,15,255,255,255,3,244,116,252,56,15,255,255,255,15,240,0,189,124,5,86,253,85,63,192,0,126,120,0,2,248,0,255,64,0,63,244,0,2,248,0,253,0,0,47,240,0,2,248,0,188,0,0,11,208,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,191,255,255,255,255,255,244,0,0,191,255,255,255,255,255,244,0,0,127,255,255,255,255,255,244,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,
  // 0x5916  外
  22,89,35,35,59,37,1,253,0,0,121,0,0,1,252,0,0,0,0,191,0,0,1,252,0,0,0,0,254,0,0,1,252,0,0,0,1,253,0,0,1,252,0,0,0,2,252,0,0,1,252,0,0,0,3,252,0,80,1,252,0,0,0,7,255,255,253,1,252,0,0,0,15,255,255,253,1,252,0,0,0,31,255,255,253,1,252,0,0,0,47,192,1,254,129,252,0,0,0,127,128,2,255,209,252,0,0,0,255,0,3,255,241,252,0,0,1,254,0,3,251,249,252,0,0,3,252,0,7,241,255,252,0,0,15,254,0,11,240,191,252,0,0,63,255,208,15,224,63,252,0,0,191,255,248,31,192,31,252,0,0,127,75,255,47,192,7,253,0,0,13,1,255,255,128,2,255,64,0,0,0,63,255,0,1,255,224,0,0,0,11,254,0,1,255,248,0,0,0,3,252,0,1,255,255,64,0,0,3,248,0,1,254,255,244,0,0,15,240,0,1,252,127,252,0,0,47,224,0,1,252,15,240,0,0,127,192,0,1,252,1,208,0,0,255,64,0,1,252,0,0,0,3,254,0,0,1,252,0,0,0,15,252,0,0,1,252,0,0,0,127,240,0,0,1,252,0,0,2,255,192,0,0,1,252,0,0,31,255,0,0,0,1,252,0,0,47,248,0,0,0,1,252,0,0,7,208,0,0,0,1,252,0,0,1,0,0,0,0,1,252,0,0,
  // 0x591a  多
  26,89,33,35,59,37,2,253,0,0,0,15,144,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,7,255,255,255,240,0,0,0,0,47,255,255,255,252,0,0,0,1,255,255,255,255,248,0,0,0,31,254,0,0,15,240,0,0,1,255,253,0,0,63,208,0,0,47,255,255,128,0,255,64,0,0,31,248,127,248,7,253,0,0,0,11,64,11,255,47,244,0,0,0,0,0,0,255,255,192,0,0,0,0,0,0,63,255,64,0,0,0,0,0,1,255,246,254,0,0,0,0,0,47,255,139,252,0,0,0,0,7,255,248,47,240,0,0,0,26,255,255,128,255,255,255,253,0,127,255,244,7,255,255,255,255,64,47,254,0,127,255,255,255,255,0,14,64,2,255,208,0,2,253,0,0,0,111,255,0,0,7,252,0,0,11,255,255,64,0,15,244,0,0,63,255,255,240,0,63,208,0,0,47,244,31,253,0,255,128,0,0,14,0,2,255,135,255,0,0,0,0,0,0,127,255,252,0,0,0,0,0,0,31,255,224,0,0,0,0,0,0,15,255,128,0,0,0,0,0,1,255,252,0,0,0,0,0,0,111,255,224,0,0,0,0,0,91,255,254,0,0,0,0,1,175,255,255,224,0,0,0,0,1,255,255,249,0,0,0,0,0,0,255,254,64,0,0,0,0,0,0,121,64,0,0,0,0,0,0,
  // 0x5920  夠
  32,89,33,35,59,37,2,253,0,6,64,0,0,144,0,0,0,0,15,208,0,1,252,0,0,0,0,47,192,0,3,248,0,0,0,0,63,64,0,3,244,0,0,0,0,255,255,248,7,240,0,0,0,2,255,255,252,15,224,0,0,0,11,255,255,248,31,255,255,255,128,47,208,3,240,63,255,255,255,64,255,64,15,224,127,255,255,255,64,253,116,47,192,254,0,0,47,64,33,254,127,66,252,0,0,47,64,0,127,254,11,244,0,0,47,64,0,31,248,15,250,170,168,47,64,0,63,224,7,207,255,252,47,64,2,255,248,0,15,255,252,47,64,47,254,252,0,15,128,252,63,64,191,227,244,0,15,128,252,63,64,63,75,255,254,15,128,252,63,64,20,47,255,255,79,128,252,63,64,0,127,255,255,15,128,252,63,0,2,253,0,127,15,128,252,63,0,11,248,0,253,15,128,252,63,0,63,224,1,252,15,128,252,63,0,255,136,3,244,15,234,252,63,0,189,63,75,240,15,255,252,63,0,32,47,239,208,15,255,252,63,0,0,7,255,128,15,128,0,63,0,0,2,255,0,15,128,0,127,0,0,11,252,0,10,64,0,126,0,0,127,240,0,0,0,0,190,0,6,255,192,0,0,0,0,253,0,191,254,0,0,0,3,255,252,0,255,240,0,0,0,2,255,248,0,127,64,0,0,0,2,255,224,0,32,0,0,0,0,0,0,0,0,
  // 0x5927  大
  39,89,33,35,59,37,2,253,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,15,240,0,0,0,0,106,170,170,175,250,170,170,170,64,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,47,253,0,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,191,191,128,0,0,0,0,0,0,255,63,192,0,0,0,0,0,0,254,31,208,0,0,0,0,0,2,253,15,240,0,0,0,0,0,3,252,11,248,0,0,0,0,0,11,248,3,253,0,0,0,0,0,31,240,2,255,0,0,0,0,0,63,224,0,255,128,0,0,0,0,255,192,0,127,208,0,0,0,2,255,64,0,47,244,0,0,0,11,254,0,0,15,253,0,0,0,63,248,0,0,3,255,64,0,1,255,224,0,0,0,255,224,0,11,255,128,0,0,0,63,253,0,191,254,0,0,0,0,31,255,192,191,244,0,0,0,0,3,255,128,47,128,0,0,0,0,0,190,0,8,0,0,0,0,0,0,8,0,
  // 0x5929  天
  41,89,34,33,41,37,2,252,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,106,170,170,175,250,170,170,170,64,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,21,85,85,95,245,85,85,85,0,47,255,255,255,255,255,255,254,0,47,255,255,255,255,255,255,254,0,47,255,255,255,255,255,255,254,0,0,0,0,15,252,0,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,63,255,128,0,0,0,0,0,0,191,127,192,0,0,0,0,0,1,255,31,224,0,0,0,0,0,3,254,15,248,0,0,0,0,0,15,252,7,253,0,0,0,0,0,63,244,2,255,0,0,0,0,0,255,224,0,255,208,0,0,0,7,255,128,0,63,248,0,0,0,127,254,0,0,15,255,64,0,6,255,244,0,0,3,255,244,0,191,255,192,0,0,0,191,255,208,255,253,0,0,0,0,31,255,192,127,208,0,0,0,0,2,255,64,41,0,0,0,0,0,0,26,0,0,0,0,0,0,0,0,0,0,
  // 0x5931  失
  49,89,34,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,15,224,7,240,0,0,0,0,0,15,224,7,240,0,0,0,0,0,47,208,7,240,0,0,0,0,0,63,192,7,240,0,0,0,0,0,127,128,7,240,0,0,0,0,0,191,149,91,249,85,85,80,0,0,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,11,244,0,7,240,0,0,0,0,31,240,0,7,240,0,0,0,0,63,208,0,11,240,0,0,0,0,191,192,0,11,240,0,0,0,0,31,0,0,11,240,0,0,0,0,1,0,0,11,240,0,0,0,0,0,0,0,15,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,85,127,255,85,85,85,64,0,0,0,63,255,0,0,0,0,0,0,0,191,255,128,0,0,0,0,0,0,255,47,192,0,0,0,0,0,3,254,15,240,0,0,0,0,0,11,252,11,252,0,0,0,0,0,47,244,3,255,0,0,0,0,0,255,224,0,255,192,0,0,0,7,255,128,0,127,244,0,0,0,47,254,0,0,31,255,0,0,2,255,244,0,0,7,255,228,0,127,255,192,0,0,0,191,255,208,255,253,0,0,0,0,31,255,208,63,208,0,0,0,0,1,255,128,40,0,0,0,0,0,0,27,0,
  // 0x59cb  始
  203,89,35,35,59,37,1,253,0,15,128,0,0,42,64,0,0,0,31,192,0,0,63,192,0,0,0,31,192,0,0,63,128,0,0,0,47,128,0,0,127,64,0,0,0,63,64,0,0,191,0,0,0,0,63,0,0,0,254,0,0,0,0,63,0,0,0,253,0,160,0,0,191,0,0,2,252,3,244,0,127,255,255,248,3,248,2,252,0,127,255,255,248,3,240,0,254,0,127,255,255,244,11,240,0,127,64,1,252,3,244,15,208,0,63,192,1,248,3,240,31,214,171,255,208,2,248,3,247,255,255,255,255,240,3,244,7,243,255,255,255,255,244,3,240,7,243,255,255,170,87,252,7,240,11,225,64,0,0,1,248,11,224,15,208,0,0,0,0,128,15,208,15,208,0,0,0,0,0,15,192,31,192,0,0,0,0,0,31,208,47,192,63,255,255,255,192,47,248,63,128,63,255,255,255,192,63,255,191,0,63,255,255,255,192,63,255,255,0,63,64,0,31,192,6,31,254,0,63,64,0,31,192,0,3,255,64,63,64,0,31,192,0,7,255,208,63,64,0,31,192,0,15,255,248,63,64,0,31,192,0,63,215,253,63,64,0,31,192,0,191,128,252,63,64,0,31,192,3,255,0,112,63,255,255,255,192,31,252,0,0,63,255,255,255,192,47,240,0,0,63,255,255,255,192,15,128,0,0,63,64,0,31,192,6,0,0,0,63,64,0,26,128,
  // 0x5a92  媒
  146,90,35,35,59,37,1,253,0,46,64,0,126,0,1,248,0,0,63,64,0,126,0,2,248,0,0,63,0,0,126,0,2,248,0,0,127,0,0,126,0,2,248,0,0,127,0,63,255,255,255,255,240,0,190,0,63,255,255,255,255,240,0,253,0,63,255,255,255,255,240,0,253,0,0,126,0,2,248,0,127,255,255,208,126,0,2,248,0,127,255,255,192,126,0,2,248,0,127,255,255,192,127,255,255,248,0,2,244,15,192,127,255,255,248,0,3,244,15,192,127,170,171,248,0,3,240,31,192,126,0,2,248,0,7,240,31,128,126,0,2,248,0,11,224,47,128,127,255,255,248,0,11,208,47,64,127,255,255,248,0,15,192,63,64,127,255,255,248,0,15,192,63,0,0,15,192,0,0,31,192,127,0,0,15,192,0,0,47,224,190,0,0,15,192,0,0,63,252,253,63,255,255,255,255,244,63,255,252,63,255,255,255,255,244,11,127,252,63,255,255,255,255,244,0,31,248,0,1,255,253,0,0,0,11,253,0,3,255,255,0,0,0,15,255,64,15,255,255,192,0,0,47,255,192,63,207,203,240,0,0,127,159,209,255,79,195,253,0,1,255,11,135,253,15,192,255,64,7,253,2,127,244,15,192,127,240,47,248,0,255,208,15,192,31,244,63,224,0,127,64,15,192,7,224,15,64,0,40,0,15,192,0,128,5,0,0,0,0,15,192,0,0,
  // 0x5b50  子
  80,91,33,34,50,37,2,252,0,85,85,85,85,85,85,0,0,1,255,255,255,255,255,255,192,0,1,255,255,255,255,255,255,240,0,1,255,255,255,255,255,255,192,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,11,255,64,0,0,0,0,0,1,127,252,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,85,85,85,91,249,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,1,149,95,244,0,0,0,0,0,0,255,255,240,0,0,0,0,0,0,191,255,224,0,0,0,0,0,0,127,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5b58  存
  88,91,35,35,59,37,1,253,0,0,0,57,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,253,0,0,0,0,0,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,5,85,95,245,85,85,85,85,64,0,0,47,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,1,255,7,255,255,255,248,0,0,3,253,7,255,255,255,255,0,0,11,248,7,255,255,255,252,0,0,31,240,0,0,0,31,244,0,0,63,208,0,0,0,127,208,0,0,255,208,0,0,1,255,64,0,3,255,208,0,0,27,252,0,0,15,255,208,0,0,31,240,0,0,127,255,208,0,0,31,192,0,0,127,223,208,0,0,47,192,0,0,63,15,209,255,255,255,255,255,244,28,15,209,255,255,255,255,255,244,0,15,209,255,255,255,255,255,244,0,15,208,0,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,208,0,64,47,192,0,0,0,15,208,0,255,255,192,0,0,0,15,208,0,191,255,64,0,0,0,15,208,0,127,249,0,0,0,
  // 0x5b89  安
  137,91,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,244,0,0,0,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,128,0,0,0,0,0,191,0,63,128,0,36,0,0,0,191,0,63,128,0,127,128,0,0,191,0,63,128,0,255,0,0,0,191,0,63,128,1,254,0,0,0,191,0,0,0,3,252,0,0,0,0,0,0,0,7,248,0,0,0,0,0,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,21,85,191,149,85,95,245,85,0,0,0,255,0,0,15,240,0,0,0,1,254,0,0,31,224,0,0,0,3,252,0,0,47,208,0,0,0,7,248,0,0,63,192,0,0,0,15,240,0,0,255,64,0,0,0,47,254,64,2,255,0,0,0,0,63,255,249,7,252,0,0,0,0,191,255,255,239,244,0,0,0,0,27,6,255,255,224,0,0,0,0,0,0,31,255,248,0,0,0,0,0,0,47,255,255,128,0,0,0,0,6,255,251,255,248,0,0,0,1,191,255,128,127,255,128,0,26,255,255,248,0,7,255,244,0,31,255,255,128,0,0,127,248,0,11,255,224,0,0,0,11,240,0,3,148,0,0,0,0,1,128,0,
  // 0x5b8c  完
  140,91,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,149,85,85,85,85,85,255,0,63,64,0,0,0,0,0,191,0,63,64,0,0,0,0,0,191,0,63,64,0,0,0,0,0,191,0,63,71,255,255,255,255,240,191,0,21,7,255,255,255,255,240,85,0,0,7,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,85,85,85,85,85,85,85,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,47,192,3,244,0,0,0,0,0,63,192,3,244,0,0,0,0,0,63,128,3,244,0,0,0,0,0,127,64,3,244,0,0,0,0,0,191,0,3,244,0,0,0,0,0,255,0,3,244,0,4,0,0,3,253,0,3,244,0,15,128,0,11,252,0,3,244,0,15,192,0,63,240,0,3,244,0,15,192,2,255,208,0,3,248,0,47,192,191,255,64,0,3,255,255,255,128,255,252,0,0,2,255,255,255,0,127,208,0,0,0,191,255,253,0,56,0,0,0,0,0,0,0,0,
  // 0x5b9a  定
  154,91,34,36,68,37,1,252,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,229,85,85,85,85,85,111,192,15,208,0,0,0,0,0,47,192,15,208,0,0,0,0,0,47,192,15,208,0,0,0,0,0,47,192,15,208,85,85,85,85,85,47,192,15,211,255,255,255,255,255,47,192,0,3,255,255,255,255,255,0,0,0,3,255,255,255,255,255,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,3,244,1,252,0,0,0,0,0,7,244,1,252,0,0,0,0,0,7,240,1,253,0,0,0,0,0,11,240,1,255,255,255,240,0,0,15,240,1,255,255,255,240,0,0,15,240,1,255,255,255,240,0,0,31,244,1,252,0,0,0,0,0,63,252,1,252,0,0,0,0,0,63,254,1,252,0,0,0,0,0,191,255,65,252,0,0,0,0,0,254,63,225,252,0,0,0,0,3,252,15,254,252,0,0,0,0,11,248,3,255,253,0,0,0,0,47,240,0,255,255,255,255,255,240,127,208,0,31,255,255,255,255,224,47,128,0,0,111,255,255,255,208,10,0,0,0,0,21,85,85,64,0,0,0,0,0,0,0,0,0,
  // 0x5ba2  客
  162,91,35,36,68,37,1,252,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,208,0,20,0,0,0,31,192,15,208,0,255,64,0,0,31,192,15,208,2,254,0,0,0,31,192,15,208,11,254,170,170,160,31,192,15,208,47,255,255,255,253,31,192,0,0,191,255,255,255,252,0,0,0,7,255,128,0,15,244,0,0,0,47,255,240,0,63,224,0,0,2,255,235,252,1,255,128,0,0,3,255,66,255,75,254,0,0,0,0,248,0,127,255,244,0,0,0,0,0,0,31,255,208,0,0,0,0,0,0,111,255,248,0,0,0,0,0,7,255,255,255,224,0,0,0,1,191,255,139,255,255,164,0,1,191,255,248,0,191,255,255,244,127,255,255,64,0,6,255,255,224,63,255,255,255,255,255,255,255,192,31,231,255,255,255,255,255,6,64,4,2,255,255,255,255,255,0,0,0,2,248,0,0,0,191,0,0,0,2,248,0,0,0,191,0,0,0,2,248,0,0,0,191,0,0,0,2,248,0,0,0,191,0,0,0,2,248,0,0,0,191,0,0,0,2,255,255,255,255,255,0,0,0,2,255,255,255,255,255,0,0,0,2,255,255,255,255,255,0,0,0,2,248,0,0,0,191,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5bb9  容
  185,91,34,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,64,0,0,0,0,0,191,0,63,64,0,0,0,0,0,191,0,63,64,9,0,0,32,0,191,0,63,64,63,192,0,254,0,191,0,63,64,255,64,1,255,208,191,0,0,3,254,0,0,63,248,0,0,0,31,248,5,80,7,255,0,0,0,255,224,15,252,0,255,208,0,11,255,64,63,255,0,47,244,0,15,252,0,255,255,192,7,248,0,3,224,3,255,47,244,1,208,0,0,0,15,252,11,254,0,0,0,0,0,127,240,2,255,128,0,0,0,2,255,128,0,127,244,0,0,0,31,254,0,0,15,255,0,0,0,191,244,0,0,2,255,224,0,11,255,255,255,255,255,255,254,64,191,255,255,255,255,255,255,255,208,191,239,255,255,255,255,253,255,128,63,75,224,0,0,2,252,31,0,20,11,224,0,0,2,252,1,0,0,11,224,0,0,2,252,0,0,0,11,224,0,0,2,252,0,0,0,11,224,0,0,2,252,0,0,0,11,224,0,0,2,252,0,0,0,11,255,255,255,255,252,0,0,0,11,255,255,255,255,252,0,0,0,11,255,255,255,255,252,0,0,0,11,224,0,0,2,252,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5c0d  對
  13,92,35,36,68,37,1,252,0,10,130,160,0,0,1,168,0,9,15,195,240,56,0,2,252,0,63,15,195,240,191,0,2,252,0,47,143,195,240,252,0,2,252,0,15,207,195,242,248,0,2,252,0,11,223,195,243,240,0,2,252,0,3,239,195,251,208,0,2,252,0,2,79,195,241,128,0,2,252,0,127,255,255,255,254,0,2,252,0,127,255,255,255,254,0,2,252,0,127,255,255,255,255,255,255,255,248,0,184,0,31,67,255,255,255,248,0,252,0,63,67,255,255,255,248,0,189,0,63,0,0,2,252,0,0,127,0,190,0,0,2,252,0,0,62,0,188,0,0,2,252,0,15,255,255,255,240,125,2,252,0,15,255,255,255,240,127,2,252,0,15,255,255,255,240,63,66,252,0,0,0,126,0,0,47,194,252,0,0,0,126,0,0,15,194,252,0,0,0,126,0,0,15,226,252,0,3,255,255,255,208,7,242,252,0,3,255,255,255,208,3,242,252,0,3,255,255,255,208,3,130,252,0,0,0,126,0,0,0,2,252,0,0,0,126,0,0,0,2,252,0,0,0,126,0,0,0,2,252,0,0,0,127,107,252,0,2,252,0,0,90,255,255,252,0,2,252,0,63,255,255,255,252,0,2,252,0,63,255,255,250,80,0,3,248,0,63,254,148,0,0,15,255,248,0,20,0,0,0,0,7,255,240,0,0,0,0,0,0,3,255,128,0,0,0,0,0,0,0,0,0,0,
  // 0x5c0f  小
  15,92,35,36,68,37,1,252,0,0,0,0,84,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,9,0,0,253,0,7,0,0,0,15,240,0,253,0,63,128,0,0,31,224,0,253,0,63,208,0,0,31,208,0,253,0,31,240,0,0,47,192,0,253,0,15,244,0,0,63,192,0,253,0,7,252,0,0,127,128,0,253,0,3,253,0,0,191,64,0,253,0,1,254,0,0,255,0,0,253,0,0,255,0,1,254,0,0,253,0,0,191,128,3,253,0,0,253,0,0,63,192,3,252,0,0,253,0,0,63,208,11,244,0,0,253,0,0,31,224,15,240,0,0,253,0,0,15,240,63,224,0,0,253,0,0,11,244,127,192,0,0,253,0,0,7,248,47,64,0,0,253,0,0,3,252,2,0,0,0,253,0,0,3,224,0,0,0,0,253,0,0,1,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,42,91,253,0,0,0,0,0,0,63,255,252,0,0,0,0,0,0,31,255,248,0,0,0,0,0,0,15,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5c31  就
  49,92,35,35,59,37,1,253,0,0,254,0,0,3,244,0,0,0,0,254,0,0,3,244,36,0,0,0,254,0,0,3,245,252,0,0,0,254,0,0,3,244,255,0,0,0,254,0,0,3,244,63,128,63,255,255,255,248,3,244,31,192,63,255,255,255,248,3,244,15,240,63,255,255,255,248,3,244,3,224,0,0,0,0,0,3,244,1,0,0,0,0,0,0,3,248,0,0,3,255,255,255,203,255,255,255,244,3,255,255,255,203,255,255,255,244,3,255,255,255,203,255,255,255,244,3,240,0,31,192,3,244,0,0,3,240,0,31,192,3,244,0,0,3,240,0,31,192,3,255,128,0,3,240,0,31,192,7,255,128,0,3,240,0,31,192,7,255,128,0,3,255,255,255,192,11,255,128,0,3,255,255,255,192,15,255,128,0,3,255,255,255,192,15,255,128,0,0,0,190,0,0,31,239,128,0,0,0,190,6,0,47,239,128,0,3,244,190,63,64,63,175,128,0,3,240,190,31,128,127,111,128,0,7,240,190,15,192,191,47,128,0,15,208,190,11,224,253,47,128,224,15,192,190,7,243,252,47,128,252,47,192,190,3,247,248,47,128,248,63,64,190,2,79,240,47,128,248,191,0,190,0,47,208,47,129,248,29,0,254,0,191,192,47,255,248,0,127,253,2,255,0,31,255,240,0,63,252,0,253,0,11,255,208,0,47,224,0,36,0,0,84,0,
  // 0x5de5  工
  229,93,33,28,252,37,2,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,10,170,170,175,250,170,170,168,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,85,85,85,91,249,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x5dee  差
  238,93,34,35,59,37,1,253,0,0,24,0,0,0,228,0,0,0,0,254,0,0,2,253,0,0,0,0,191,0,0,3,252,0,0,0,0,63,192,0,11,240,0,0,0,0,31,192,0,15,208,0,0,3,255,255,255,255,255,255,255,64,3,255,255,255,255,255,255,255,64,3,255,255,255,255,255,255,255,64,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,127,255,255,255,255,255,248,0,0,127,255,255,255,255,255,248,0,0,127,255,255,255,255,255,244,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,2,253,255,255,255,255,248,0,0,3,249,255,255,255,255,248,0,0,11,245,255,255,255,255,248,0,0,15,240,0,3,240,0,0,0,0,31,208,0,3,240,0,0,0,0,63,192,0,3,240,0,0,0,0,255,128,0,3,240,0,0,0,2,255,0,0,3,240,0,0,0,7,252,0,0,3,240,0,0,0,47,248,191,255,255,255,255,255,192,127,224,191,255,255,255,255,255,192,31,128,191,255,255,255,255,255,192,2,0,0,0,0,0,0,0,0,
  // 0x5df2  已
  242,93,32,32,0,37,3,254,21,85,85,85,85,85,84,0,127,255,255,255,255,255,254,0,127,255,255,255,255,255,254,0,127,255,255,255,255,255,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,6,160,0,0,0,0,254,0,11,240,0,0,0,0,254,0,11,240,0,0,0,0,254,0,11,240,0,0,0,0,254,0,11,240,0,0,0,0,254,0,11,240,0,0,0,0,254,0,11,255,255,255,255,255,254,0,11,255,255,255,255,255,254,0,11,255,255,255,255,255,254,0,11,245,85,85,85,85,254,0,11,240,0,0,0,0,254,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,121,11,240,0,0,0,0,0,127,11,240,0,0,0,0,0,191,11,240,0,0,0,0,0,255,11,240,0,0,0,0,0,254,11,244,0,0,0,0,2,253,7,254,85,85,85,85,111,252,3,255,255,255,255,255,255,248,0,255,255,255,255,255,255,224,0,27,255,255,255,255,254,0,
  // 0x5e73  平
  115,94,33,33,41,37,2,253,5,85,85,85,85,85,85,84,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,20,0,0,0,127,0,7,240,0,63,128,0,0,63,64,7,240,0,127,128,0,0,63,192,7,240,0,191,0,0,0,31,208,7,240,0,254,0,0,0,15,224,7,240,2,252,0,0,0,11,240,7,240,3,248,0,0,0,7,244,7,240,7,240,0,0,0,3,248,7,240,15,224,0,0,0,2,128,7,240,6,192,0,0,0,0,0,7,240,0,0,0,0,85,85,85,91,249,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,
  // 0x5e8a  床
  138,94,35,35,59,37,1,253,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,85,85,85,127,149,85,85,80,2,255,255,255,255,255,255,255,240,2,255,255,255,255,255,255,255,240,2,255,255,255,255,255,255,255,240,2,252,0,0,0,0,0,0,0,2,252,0,0,3,244,0,0,0,2,252,0,0,3,244,0,0,0,2,252,0,0,3,244,0,0,0,2,252,0,0,3,244,0,0,0,2,252,0,0,3,244,0,0,0,2,252,0,0,7,248,0,0,0,2,252,127,255,255,255,255,255,240,2,252,127,255,255,255,255,255,240,2,252,127,255,255,255,255,255,240,2,252,0,0,47,255,0,0,0,2,252,0,0,127,255,128,0,0,2,248,0,0,255,255,208,0,0,3,248,0,2,255,255,240,0,0,3,244,0,7,251,251,252,0,0,3,244,0,31,243,245,255,0,0,3,244,0,63,195,244,191,192,0,7,240,0,255,67,244,47,240,0,11,240,3,254,3,244,15,252,0,15,224,31,252,3,244,3,255,64,15,208,191,240,3,244,0,255,224,31,195,255,192,3,244,0,63,244,63,193,254,0,3,244,0,11,224,63,128,116,0,3,244,0,1,192,191,0,0,0,3,244,0,0,0,46,0,0,0,3,244,0,0,0,5,0,0,0,3,244,0,0,0,
  // 0x5ea6  度
  166,94,34,35,59,37,1,253,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,127,64,0,0,0,2,255,255,255,255,255,255,255,240,2,255,255,255,255,255,255,255,240,2,255,255,255,255,255,255,255,240,2,252,0,0,0,0,0,0,0,2,252,0,47,128,0,127,0,0,2,252,0,47,128,0,127,0,0,2,252,0,47,128,0,127,0,0,2,252,255,255,255,255,255,255,224,2,252,255,255,255,255,255,255,224,2,252,255,255,255,255,255,255,208,2,252,0,47,128,0,127,0,0,2,248,0,47,128,0,127,0,0,2,248,0,47,128,0,127,0,0,2,248,0,47,255,255,255,0,0,2,248,0,47,255,255,255,0,0,2,248,0,26,170,170,170,0,0,3,248,0,0,0,0,0,0,0,3,244,191,255,255,255,255,224,0,3,244,191,255,255,255,255,252,0,3,240,191,255,255,255,255,248,0,3,240,0,127,0,0,15,240,0,7,240,0,63,192,0,63,208,0,11,224,0,15,244,1,255,64,0,15,208,0,7,254,15,253,0,0,15,208,0,0,255,255,240,0,0,31,192,0,0,63,255,192,0,0,63,192,0,27,255,255,249,0,0,63,64,107,255,255,255,255,254,80,191,3,255,255,244,6,255,255,240,46,1,255,253,0,0,31,255,208,4,0,233,0,0,0,0,27,128,
  // 0x5ee2  廢
  226,94,35,36,68,37,1,252,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,3,255,255,255,255,255,255,255,240,3,255,255,255,255,255,255,255,240,3,255,255,255,255,255,255,255,240,3,240,0,0,0,0,0,0,0,3,240,21,85,80,62,2,128,0,3,240,127,255,252,47,75,224,0,3,240,127,255,248,15,255,128,0,3,240,0,3,240,11,252,2,0,3,240,125,15,224,3,248,31,208,3,240,191,191,128,0,254,255,64,3,240,15,255,0,0,63,248,0,3,240,11,252,0,0,15,248,0,3,240,191,255,224,255,255,255,224,3,255,255,255,224,255,255,255,244,3,251,245,87,224,253,111,75,224,3,242,64,3,224,248,15,65,64,3,240,0,3,225,244,15,71,128,3,240,63,255,227,240,15,155,128,7,240,127,255,255,224,15,255,64,7,240,189,85,71,192,7,254,0,7,224,252,0,1,0,0,0,0,11,224,248,0,7,255,255,252,0,15,209,255,255,231,255,255,252,0,15,210,255,255,209,185,86,244,0,15,194,245,91,208,252,3,240,0,31,192,0,11,192,126,15,208,0,47,128,0,15,192,47,255,64,0,63,64,0,15,192,15,254,0,0,127,0,0,15,192,31,255,144,0,190,0,37,127,134,255,255,254,144,125,0,63,255,31,253,7,255,208,12,0,47,253,15,144,0,111,128,0,0,0,0,0,0,0,0,0,
  // 0x5efa  建
  250,94,35,36,68,37,1,252,0,0,0,0,0,105,0,0,0,0,0,0,0,0,191,0,0,0,127,255,244,0,0,191,0,0,0,127,255,240,63,255,255,255,254,0,127,255,224,63,255,255,255,254,0,0,15,208,42,170,255,170,254,0,0,47,192,0,0,191,0,190,0,0,63,128,0,0,191,0,190,0,0,127,7,255,255,255,255,255,244,0,254,7,255,255,255,255,255,244,0,252,2,170,170,255,170,255,164,2,252,0,0,0,191,0,190,0,3,244,0,0,0,191,0,190,0,11,255,253,63,255,255,255,254,0,15,255,254,63,255,255,255,254,0,47,255,253,42,170,255,170,169,0,47,64,253,0,0,191,0,0,0,1,0,252,0,0,191,0,0,0,0,0,252,63,255,255,255,255,0,7,65,252,63,255,255,255,255,0,15,194,248,42,170,255,170,170,0,15,195,244,0,0,191,0,0,0,7,227,240,0,0,191,0,0,0,3,251,243,255,255,255,255,255,224,2,255,227,255,255,255,255,255,224,0,255,194,255,255,255,255,255,208,0,127,192,0,0,191,0,0,0,0,127,240,0,0,191,0,0,0,0,255,253,0,0,191,0,0,0,2,255,255,224,0,85,0,0,0,7,252,191,255,229,84,5,85,80,31,240,31,255,255,255,255,255,244,127,224,1,191,255,255,255,255,240,47,128,0,1,175,255,255,255,224,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5f15  引
  21,95,29,36,32,37,3,252,0,0,0,0,0,0,21,0,0,0,0,0,0,0,63,64,127,255,255,254,0,0,63,64,127,255,255,254,0,0,63,64,127,255,255,254,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,31,255,255,254,0,0,63,64,31,255,255,254,0,0,63,64,47,255,255,254,0,0,63,64,47,192,0,0,0,0,63,64,63,128,0,0,0,0,63,64,63,64,0,0,0,0,63,64,63,0,0,0,0,0,63,64,127,0,0,0,0,0,63,64,191,255,255,255,0,0,63,64,255,255,255,255,0,0,63,64,255,255,255,254,0,0,63,64,253,0,0,254,0,0,63,64,188,0,0,254,0,0,63,64,0,0,0,253,0,0,63,64,0,0,0,253,0,0,63,64,0,0,0,253,0,0,63,64,0,0,1,252,0,0,63,64,0,0,2,252,0,0,63,64,0,0,2,252,0,0,63,64,0,0,3,248,0,0,63,64,0,0,7,248,0,0,63,64,2,165,111,244,0,0,63,64,1,255,255,240,0,0,63,64,0,255,255,208,0,0,63,64,0,255,254,0,0,0,63,64,0,0,0,0,0,0,0,0,
  // 0x5f85  待
  133,95,35,35,59,37,1,253,0,0,144,0,0,42,64,0,0,0,2,252,0,0,63,128,0,0,0,7,252,0,0,63,128,0,0,0,31,240,0,0,63,128,0,0,0,127,208,0,0,63,128,0,0,1,255,64,47,255,255,255,255,128,11,253,0,47,255,255,255,255,128,63,244,0,47,255,255,255,255,128,63,192,16,0,0,63,128,0,0,31,0,189,0,0,63,128,0,0,4,1,253,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,15,243,255,255,255,255,255,248,0,47,211,255,255,255,255,255,248,0,191,195,255,255,255,255,255,248,2,255,192,0,0,0,15,224,0,11,255,192,0,0,0,15,224,0,47,255,192,0,0,0,15,224,0,191,255,192,0,0,0,15,224,0,127,159,193,255,255,255,255,255,240,61,31,193,255,255,255,255,255,240,20,31,193,255,255,255,255,255,240,0,31,192,0,0,0,15,224,0,0,31,192,1,208,0,15,224,0,0,31,192,11,240,0,15,224,0,0,31,192,3,252,0,15,224,0,0,31,192,2,254,0,15,224,0,0,31,192,0,255,0,15,224,0,0,31,192,0,63,192,15,224,0,0,31,192,0,47,192,15,224,0,0,31,192,0,14,0,15,224,0,0,31,192,0,0,16,31,224,0,0,31,192,0,0,63,255,208,0,0,31,192,0,0,47,255,192,0,0,31,192,0,0,15,254,0,0,
  // 0x5f8c  後
  140,95,35,36,68,37,1,252,0,1,128,0,1,128,0,0,0,0,3,248,0,3,244,0,0,0,0,15,240,0,15,240,0,0,0,0,63,208,0,47,208,10,0,0,0,191,64,16,127,64,31,208,0,3,254,0,189,254,0,127,192,0,15,248,1,255,248,0,255,0,0,127,224,0,127,240,3,253,0,0,127,128,160,15,252,15,244,0,0,45,1,253,2,255,63,208,0,0,0,3,252,0,191,255,66,240,0,0,11,240,0,47,252,3,248,0,0,31,224,0,31,240,1,254,0,0,63,192,0,127,192,0,191,64,0,255,139,255,255,255,255,255,192,3,255,139,255,255,255,255,255,224,31,255,135,255,255,255,255,255,244,127,255,128,0,15,240,0,3,248,255,175,128,0,47,208,0,1,208,61,47,128,0,191,234,170,160,0,36,47,128,2,255,255,255,252,0,0,47,128,11,255,255,255,248,0,0,47,128,63,248,0,11,240,0,0,47,130,255,253,0,31,224,0,0,47,143,254,191,0,127,192,0,0,47,131,244,63,193,255,0,0,0,47,129,192,15,251,252,0,0,0,47,128,0,3,255,240,0,0,0,47,128,0,2,255,224,0,0,0,47,128,0,47,255,253,0,0,0,47,128,6,255,251,255,228,0,0,47,129,191,255,128,191,255,208,0,47,143,255,248,0,15,255,244,0,47,131,255,64,0,1,191,240,0,47,130,144,0,0,0,2,192,0,0,0,0,0,0,0,0,0,
  // 0x5f91  徑
  145,95,35,35,59,37,1,253,0,1,128,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,15,240,255,255,255,255,255,240,0,63,208,255,255,255,255,255,240,0,255,64,255,255,255,255,255,240,3,253,0,0,0,0,0,0,0,15,248,0,1,144,9,0,36,0,127,224,0,3,244,15,208,63,0,127,64,164,11,240,47,128,254,0,45,1,253,15,208,127,1,252,0,0,3,248,47,128,254,3,244,0,0,11,240,63,2,252,11,224,0,0,31,208,253,3,240,31,192,0,0,63,192,253,7,240,47,192,0,0,255,128,127,3,248,15,224,0,3,255,128,63,128,253,3,244,0,15,255,128,15,192,127,1,252,0,127,255,128,11,240,47,128,191,0,255,239,128,3,244,15,208,63,128,127,47,128,2,252,11,240,31,192,60,47,128,0,144,2,64,10,0,0,47,128,0,0,0,0,0,0,0,47,128,127,255,255,255,255,128,0,47,128,127,255,255,255,255,128,0,47,128,127,255,255,255,255,128,0,47,128,0,0,63,64,0,0,0,47,128,0,0,63,64,0,0,0,47,128,0,0,63,64,0,0,0,47,128,0,0,63,64,0,0,0,47,128,0,0,63,64,0,0,0,47,128,0,0,63,64,0,0,0,47,139,255,255,255,255,255,248,0,47,139,255,255,255,255,255,248,0,47,139,255,255,255,255,255,248,0,47,128,0,0,0,0,0,0,
  // 0x5f9e  從
  158,95,35,35,59,37,1,253,0,2,144,0,57,0,7,160,0,0,7,248,0,127,0,11,240,0,0,15,240,0,190,0,11,224,0,0,63,192,0,253,0,15,208,0,0,255,64,0,252,0,15,192,0,3,253,0,2,252,0,31,192,0,15,248,0,3,252,0,63,128,0,127,224,0,7,255,64,63,208,0,63,64,164,15,255,208,191,244,0,29,1,253,31,239,245,255,253,0,0,3,248,63,195,243,252,255,64,0,11,240,191,64,219,244,63,208,0,47,210,254,0,47,240,15,240,0,127,199,252,0,127,192,3,244,1,255,129,240,0,31,0,1,208,3,255,128,144,0,31,128,0,0,31,255,128,0,0,31,192,0,0,127,255,128,0,0,31,192,0,0,255,175,128,11,224,31,192,0,0,62,47,128,15,224,31,192,0,0,40,47,128,15,208,31,192,0,0,0,47,128,15,208,31,255,255,128,0,47,128,15,192,31,255,255,128,0,47,128,31,192,31,255,255,64,0,47,128,47,224,31,192,0,0,0,47,128,63,240,31,192,0,0,0,47,128,63,244,31,192,0,0,0,47,128,191,252,31,192,0,0,0,47,128,254,191,31,192,0,0,0,47,130,252,63,239,192,0,0,0,47,135,248,31,255,192,0,0,0,47,159,240,7,255,255,255,244,0,47,159,208,0,191,255,255,240,0,47,135,128,0,6,255,255,224,0,26,64,0,0,0,0,0,0,
  // 0x5fa9  復
  169,95,35,36,68,37,1,252,0,1,128,0,164,0,0,0,0,0,3,248,1,253,0,0,0,0,0,15,240,3,252,0,0,0,0,0,47,208,3,248,0,0,0,0,0,191,128,11,255,255,255,255,240,2,254,0,15,255,255,255,255,240,15,248,0,63,255,255,255,255,240,127,224,0,191,128,0,0,0,0,63,64,165,255,85,85,85,84,0,28,1,255,255,255,255,255,254,0,0,3,254,251,255,255,255,254,0,0,15,240,83,240,0,0,126,0,0,47,208,3,240,0,0,126,0,0,127,128,3,255,255,255,254,0,1,255,128,3,255,255,255,254,0,7,255,128,3,240,0,0,190,0,31,255,128,3,240,0,0,126,0,127,255,128,3,240,0,0,190,0,255,175,128,3,255,255,255,254,0,126,47,128,3,255,255,255,254,0,40,47,128,0,15,224,0,0,0,0,47,128,0,47,192,0,0,0,0,47,128,0,127,213,85,80,0,0,47,128,1,255,255,255,254,0,0,47,128,7,255,255,255,252,0,0,47,128,47,254,0,3,248,0,0,47,129,255,255,128,31,240,0,0,47,131,253,31,224,127,192,0,0,47,128,176,7,255,255,0,0,0,47,128,0,1,255,248,0,0,0,47,128,0,27,255,254,64,0,0,47,128,26,255,255,255,250,64,0,47,131,255,255,144,127,255,248,0,47,130,255,244,0,2,255,224,0,47,128,228,0,0,0,6,192,0,0,0,0,0,0,0,0,0,
  // 0x5fae  微
  174,95,35,35,59,37,1,253,0,14,0,11,192,0,58,0,0,0,47,192,11,192,0,63,0,0,0,127,64,11,192,0,127,0,0,0,255,15,11,194,224,190,0,0,3,252,15,11,194,240,253,0,0,15,244,15,11,194,240,252,0,0,63,208,15,11,194,240,252,0,0,191,64,15,11,194,241,255,255,244,61,7,223,11,194,243,255,255,244,20,15,239,11,194,243,255,255,244,0,47,207,255,255,247,240,15,192,0,63,79,255,255,255,240,15,128,0,191,15,255,255,255,240,31,128,1,254,0,0,0,47,244,31,64,3,253,0,0,0,63,248,47,64,11,253,0,0,0,191,248,47,0,31,253,0,0,0,60,188,63,0,127,253,47,255,255,244,124,63,0,255,253,47,255,255,240,61,62,0,189,189,47,255,255,240,62,125,0,56,189,1,244,63,0,63,188,0,16,189,1,244,63,0,47,252,0,0,189,1,244,63,0,15,248,0,0,189,1,244,63,0,15,240,0,0,189,2,244,63,0,11,240,0,0,189,2,240,63,0,15,240,0,0,189,3,240,63,188,47,244,0,0,189,7,240,63,253,127,252,0,0,189,11,208,255,248,255,254,0,0,189,15,192,255,66,252,127,64,0,189,63,128,96,11,244,63,208,0,189,191,0,0,63,224,15,244,0,189,61,0,0,191,128,7,248,0,189,8,0,0,62,0,1,240,0,189,0,0,0,4,0,0,64,
  // 0x5fc3  心
  195,95,35,35,59,37,1,253,0,0,0,80,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,1,255,255,0,0,0,0,0,0,0,11,255,224,0,0,0,0,0,0,0,191,254,0,0,0,0,0,0,0,15,255,192,0,0,0,0,0,0,1,255,64,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,0,4,0,0,0,0,0,5,80,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,2,64,0,0,64,15,240,0,0,31,192,0,0,252,15,240,0,0,31,240,0,1,252,15,240,0,0,11,248,0,1,252,15,240,0,0,3,252,0,2,252,15,240,0,0,1,254,0,3,248,15,240,0,0,0,255,0,3,244,15,240,0,0,0,127,128,7,240,15,240,0,0,0,63,192,11,240,15,240,0,0,0,31,224,15,240,15,240,0,0,0,15,240,31,208,15,240,0,0,0,11,244,63,192,15,240,0,0,116,7,248,127,192,15,240,0,0,127,3,252,255,64,15,240,0,0,127,2,224,47,0,15,240,0,0,190,0,0,4,0,15,240,0,0,190,0,0,0,0,11,240,0,0,253,0,0,0,0,11,244,0,2,252,0,0,0,0,7,255,255,255,252,0,0,0,0,3,255,255,255,244,0,0,0,0,0,191,255,255,208,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6027  性
  39,96,34,35,59,37,1,253,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,2,248,15,192,0,0,0,63,128,2,248,15,192,0,0,0,63,128,3,248,15,192,0,0,0,63,128,3,244,15,192,0,0,0,63,136,3,240,15,192,0,0,9,63,253,7,240,15,192,0,0,15,127,191,15,255,255,255,255,192,31,63,175,79,255,255,255,255,192,31,63,159,159,255,255,255,255,192,47,63,143,239,213,95,213,85,64,63,63,139,255,64,15,192,0,0,62,63,129,191,0,15,192,0,0,62,63,128,255,0,15,192,0,0,125,63,128,253,0,15,192,0,0,188,63,128,44,0,15,192,0,0,188,63,128,0,0,15,192,0,0,0,63,128,0,0,31,208,0,0,0,63,128,15,255,255,255,255,64,0,63,128,15,255,255,255,255,64,0,63,128,15,255,255,255,255,64,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,130,255,255,255,255,255,240,0,63,130,255,255,255,255,255,240,0,63,130,255,255,255,255,255,240,0,63,128,85,85,85,85,85,80,0,42,64,0,0,0,0,0,0,
  // 0x6062  恢
  98,96,35,35,59,37,1,253,0,63,64,15,192,0,0,0,0,0,63,64,15,192,0,0,0,0,0,63,64,15,192,0,0,0,0,0,63,64,15,192,0,0,0,0,0,63,67,255,255,255,255,255,244,0,63,67,255,255,255,255,255,244,0,63,167,255,255,255,255,255,244,9,63,252,31,192,0,0,0,0,15,63,188,15,192,0,252,0,0,31,63,126,15,192,0,252,0,0,31,63,95,15,192,0,252,0,0,31,63,79,79,192,0,252,0,0,47,63,79,79,192,0,252,2,144,62,63,75,79,199,192,252,3,240,61,63,64,15,199,192,252,7,224,124,63,64,15,203,192,252,11,208,188,63,64,15,203,192,252,15,192,116,63,64,31,207,128,252,31,128,0,63,64,31,143,65,252,47,0,0,63,64,31,159,1,252,63,0,0,63,64,47,127,2,252,125,0,0,63,64,47,93,3,253,4,0,0,63,64,63,0,3,254,0,0,0,63,64,63,0,7,255,0,0,0,63,64,127,0,15,239,64,0,0,63,64,190,0,31,143,192,0,0,63,64,253,0,63,79,208,0,0,63,64,252,0,191,7,240,0,0,63,66,252,1,253,3,252,0,0,63,67,248,7,248,1,254,0,0,63,71,240,31,240,0,191,128,0,63,79,224,191,192,0,63,244,0,63,95,194,255,64,0,15,248,0,63,75,128,252,0,0,3,240,0,63,65,0,96,0,0,0,144,
  // 0x606f  息
  111,96,35,35,59,37,1,253,0,0,0,1,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,11,255,255,255,255,255,192,0,0,11,255,255,255,255,255,192,0,0,11,250,170,170,170,191,192,0,0,11,224,0,0,0,15,192,0,0,11,224,0,0,0,15,192,0,0,11,250,170,170,170,175,192,0,0,11,255,255,255,255,255,192,0,0,11,255,255,255,255,255,192,0,0,11,224,0,0,0,15,192,0,0,11,224,0,0,0,15,192,0,0,11,250,170,170,170,175,192,0,0,11,255,255,255,255,255,192,0,0,11,255,255,255,255,255,192,0,0,11,224,0,0,0,15,192,0,0,11,224,0,0,0,15,192,0,0,11,224,0,0,0,15,192,0,0,11,255,255,255,255,255,192,0,0,11,255,255,255,255,255,192,0,0,6,170,170,170,170,170,128,0,0,0,0,2,208,0,0,0,0,0,0,0,15,244,0,0,0,0,0,80,0,3,253,0,2,192,0,0,190,15,208,255,64,15,240,0,0,253,15,208,63,208,15,252,0,1,252,15,208,15,208,3,254,0,3,248,15,208,7,0,0,255,64,11,240,15,208,0,2,224,63,208,31,240,15,208,0,3,244,31,240,127,192,15,224,0,7,244,11,244,63,64,15,255,255,255,240,3,244,6,0,7,255,255,255,224,1,128,0,0,1,191,255,255,64,0,0,
  // 0x61b6  憶
  182,97,35,35,59,37,1,253,0,63,64,0,0,31,128,0,0,0,63,64,0,0,47,192,0,0,0,63,64,0,0,47,192,0,0,0,63,64,63,255,255,255,255,192,0,63,64,63,255,255,255,255,192,0,63,64,42,190,170,171,250,128,0,63,148,0,126,0,7,224,0,4,63,252,0,63,0,15,192,0,15,63,189,0,47,64,15,192,0,31,63,126,255,255,255,255,255,244,31,63,95,255,255,255,255,255,244,31,63,79,234,170,170,170,170,164,47,63,79,128,0,0,0,0,0,62,63,74,75,255,255,255,255,64,62,63,64,11,255,255,255,255,64,125,63,64,11,224,0,0,63,64,188,63,64,11,224,0,0,63,64,120,63,64,11,224,0,0,63,64,0,63,64,11,255,255,255,255,64,0,63,64,11,255,255,255,255,64,0,63,64,11,224,0,0,63,64,0,63,64,11,224,0,0,63,64,0,63,64,11,255,255,255,255,64,0,63,64,11,255,255,255,255,64,0,63,64,0,0,253,0,0,0,0,63,64,0,0,191,192,16,0,0,63,64,45,15,207,240,184,0,0,63,64,63,15,195,224,254,0,0,63,64,127,15,192,128,127,64,0,63,64,189,15,192,1,47,192,0,63,64,252,15,192,3,239,224,0,63,67,248,15,192,7,227,240,0,63,75,240,15,255,255,210,248,0,63,66,208,15,255,255,192,208,0,63,64,0,1,191,250,0,0,
  // 0x61c9  應
  201,97,35,35,59,37,1,253,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,3,255,255,255,255,255,255,255,240,3,255,255,255,255,255,255,255,240,3,255,255,255,255,255,255,255,240,3,240,0,228,11,144,41,0,0,3,240,2,248,15,192,127,0,0,3,240,7,240,47,128,253,0,0,3,240,15,208,63,255,255,255,192,3,240,47,192,255,255,255,255,192,3,240,127,194,255,1,248,0,0,3,241,255,199,254,1,248,0,0,3,251,255,223,255,255,255,255,0,3,255,255,239,255,255,255,255,0,3,255,223,199,126,1,248,0,0,3,242,15,192,62,1,248,0,0,3,240,15,192,63,255,255,255,0,3,240,15,192,63,255,255,255,0,3,240,15,192,62,1,248,0,0,3,240,15,192,63,1,248,0,0,7,240,15,192,63,255,255,255,224,7,224,15,192,63,255,255,255,224,7,224,10,64,29,0,0,0,0,11,224,0,0,127,208,0,0,0,15,208,0,0,31,252,0,0,0,15,192,25,11,210,255,2,240,0,15,192,63,79,208,126,3,252,0,31,192,127,15,208,8,0,254,0,47,128,253,15,208,0,36,127,64,63,65,252,15,208,0,63,47,192,127,7,248,11,224,0,127,15,240,190,15,240,11,255,255,254,7,244,61,3,192,3,255,255,252,3,208,8,0,0,0,175,255,160,0,0,
  // 0x6210  成
  16,98,35,36,68,37,1,252,0,0,0,0,7,240,40,0,0,0,0,0,0,7,244,191,64,0,0,0,0,0,7,244,191,240,0,0,0,0,0,7,244,15,253,0,0,0,0,0,7,244,2,254,0,0,0,0,0,3,244,0,60,0,1,255,255,255,255,255,255,255,240,1,255,255,255,255,255,255,255,240,1,255,255,255,255,255,255,255,240,1,253,85,85,87,249,85,85,80,1,252,0,0,3,248,0,0,0,1,252,0,0,3,252,0,0,0,1,252,0,0,2,252,0,185,0,1,252,0,0,2,252,0,255,0,1,255,255,255,65,252,1,253,0,1,255,255,255,65,252,3,252,0,1,255,255,255,64,253,3,248,0,1,253,0,63,64,254,11,240,0,1,252,0,63,64,255,15,224,0,1,252,0,63,64,191,47,208,0,2,252,0,63,64,127,127,128,0,2,252,0,63,64,127,255,0,0,2,252,0,63,0,63,253,0,0,3,252,0,63,0,47,252,0,0,3,248,0,127,0,31,240,1,64,3,248,0,191,0,63,224,2,224,7,244,255,255,0,255,240,2,244,11,240,191,253,3,255,244,3,244,15,240,191,244,15,255,252,3,240,15,224,0,0,127,241,254,3,240,47,208,0,2,255,208,255,139,240,63,192,0,15,255,64,127,255,208,127,128,0,11,252,0,31,255,192,47,0,0,3,224,0,7,255,64,6,0,0,0,64,0,0,84,0,0,0,0,0,0,0,0,0,0,
  // 0x6236  戶
  54,98,29,35,24,37,2,253,0,0,0,0,0,1,160,0,0,0,0,0,0,111,252,0,0,0,0,1,191,255,254,0,0,80,26,255,255,255,228,0,0,127,255,255,255,228,0,0,0,127,255,254,144,0,0,0,0,127,233,0,0,0,0,0,0,127,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,127,255,255,255,255,255,192,0,127,255,255,255,255,255,192,0,127,255,255,255,255,255,192,0,127,0,0,0,0,31,192,0,127,0,0,0,0,31,192,0,127,0,0,0,0,31,192,0,191,0,0,0,0,31,192,0,191,0,0,0,0,31,192,0,191,0,0,0,0,31,192,0,191,0,0,0,0,31,192,0,255,255,255,255,255,255,192,0,255,255,255,255,255,255,192,0,255,255,255,255,255,255,192,0,253,0,0,0,0,47,192,1,252,0,0,0,0,31,192,2,252,0,0,0,0,0,0,3,248,0,0,0,0,0,0,7,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,224,0,0,0,0,0,0,63,192,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,0,0,0,0,0,0,0,125,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,
  // 0x6240  所
  64,98,35,34,50,37,1,253,0,0,0,0,0,0,0,111,64,47,255,255,255,208,0,7,255,208,47,255,255,255,209,2,255,255,208,47,255,255,255,215,255,255,248,0,0,0,0,0,7,255,254,64,0,0,0,0,0,7,255,64,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,7,255,255,255,71,240,0,0,0,7,255,255,255,71,240,0,0,0,7,255,255,255,71,240,0,0,0,7,240,0,63,71,240,0,0,0,7,240,0,63,71,255,255,255,248,7,240,0,63,71,255,255,255,248,7,240,0,63,71,255,255,255,248,7,240,0,63,71,245,86,253,80,7,240,0,63,71,240,2,252,0,7,255,255,255,71,240,2,252,0,7,255,255,255,75,240,2,252,0,7,255,255,255,79,224,2,252,0,7,240,0,0,15,224,2,252,0,11,224,0,0,15,208,2,252,0,11,224,0,0,15,192,2,252,0,11,224,0,0,47,192,2,252,0,15,208,0,0,63,128,2,252,0,15,208,0,0,63,64,2,252,0,15,192,0,0,191,0,2,252,0,31,192,0,0,254,0,2,252,0,47,128,0,2,252,0,2,252,0,63,64,0,7,248,0,2,252,0,191,0,0,15,240,0,2,252,0,254,0,0,47,224,0,2,252,0,125,0,0,11,128,0,2,252,0,8,0,0,2,0,0,1,252,0,
  // 0x6247  扇
  71,98,33,33,41,37,1,253,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,252,0,0,191,255,255,255,255,255,252,0,0,191,170,170,170,170,170,252,0,0,190,0,0,0,0,0,252,0,0,190,0,0,0,0,0,252,0,0,191,170,170,170,170,170,252,0,0,191,255,255,255,255,255,252,0,0,191,255,255,255,255,255,252,0,0,190,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,170,170,164,170,170,169,0,0,253,255,255,248,255,255,254,0,0,253,255,255,248,255,255,254,0,0,253,4,2,248,4,0,126,0,0,252,46,2,248,47,0,126,0,1,252,63,130,248,47,192,126,0,1,252,15,210,248,11,240,126,0,2,252,7,242,248,3,240,126,0,3,248,2,130,248,0,128,126,0,7,244,0,22,248,0,26,126,0,11,240,2,250,248,2,254,126,0,15,224,127,254,248,111,254,126,0,31,211,255,210,249,255,224,126,0,63,195,253,2,248,253,0,126,0,127,130,208,2,248,144,0,190,0,255,0,0,171,244,0,59,254,0,45,0,0,255,240,0,63,253,0,4,0,0,191,144,0,31,228,0,
  // 0x624b  手
  75,98,33,36,68,37,2,252,0,0,0,0,0,0,110,0,0,0,0,0,0,6,191,255,128,0,0,5,106,255,255,255,255,208,0,11,255,255,255,255,255,233,0,0,7,255,255,255,254,148,0,0,0,3,255,170,87,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,1,85,85,87,249,85,85,84,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,85,85,85,91,249,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,1,85,91,244,0,0,0,0,0,2,255,255,240,0,0,0,0,0,0,255,255,224,0,0,0,0,0,0,255,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6253  打
  83,98,34,35,59,37,2,253,0,63,64,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,31,255,255,255,255,224,0,63,128,31,255,255,255,255,224,0,63,128,31,255,255,255,255,224,0,63,128,5,85,86,254,85,64,0,63,128,0,0,1,252,0,0,255,255,255,192,0,1,252,0,0,255,255,255,192,0,1,252,0,0,255,255,255,192,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,135,208,0,1,252,0,0,0,63,255,208,0,1,252,0,0,1,191,255,224,0,1,252,0,0,191,255,255,144,0,1,252,0,0,255,255,208,0,0,1,252,0,0,255,255,128,0,0,1,252,0,0,180,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,2,252,0,0,63,255,64,0,63,255,252,0,0,47,255,0,0,63,255,252,0,0,31,248,0,0,31,255,240,0,0,0,0,0,0,10,169,0,0,0,
  // 0x6279  批
  121,98,35,35,59,37,1,253,0,63,0,5,64,1,164,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,127,255,255,47,192,2,248,0,0,127,255,255,47,192,2,248,2,0,127,255,255,47,192,2,248,11,192,0,63,0,47,192,2,248,63,240,0,63,0,47,255,242,249,255,192,0,63,0,47,255,242,255,254,0,0,63,0,47,255,242,255,244,0,0,63,0,47,213,82,255,128,0,0,63,94,47,192,2,252,0,0,0,63,254,47,192,2,248,0,0,6,255,255,47,192,2,248,0,0,191,255,249,47,192,2,248,0,0,191,255,64,47,192,2,248,0,0,127,127,0,47,192,2,248,0,0,16,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,1,208,0,63,0,47,192,2,248,1,248,0,63,0,47,192,98,248,2,248,0,63,0,47,219,242,248,2,244,0,63,10,255,255,246,252,3,240,0,127,15,255,255,225,255,255,240,47,255,11,255,144,0,255,255,224,31,254,3,144,0,0,127,255,128,15,228,0,0,0,0,0,0,0,
  // 0x6296  抖
  150,98,35,36,68,37,1,252,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,224,0,0,31,192,0,0,0,15,224,0,0,31,192,0,45,0,15,224,0,0,31,192,0,127,192,15,224,0,0,31,192,0,127,244,15,224,0,0,31,192,0,11,254,15,224,0,0,31,192,0,1,255,79,224,0,63,255,255,208,0,63,15,224,0,63,255,255,208,0,12,15,224,0,63,255,255,208,0,0,15,224,0,0,31,192,0,0,0,15,224,0,0,31,192,0,128,0,15,224,0,0,31,192,2,248,0,15,224,0,0,31,192,7,255,128,15,224,0,0,31,192,1,255,240,15,224,0,0,31,192,64,31,252,15,224,0,0,31,223,208,3,244,15,224,0,0,47,255,224,0,176,15,224,0,27,255,255,224,0,0,15,224,0,127,255,249,0,0,0,15,224,0,63,255,192,0,0,0,15,251,244,63,111,192,0,0,6,191,255,244,0,31,192,0,107,255,255,255,248,0,31,192,47,255,255,255,250,64,0,31,192,31,255,255,175,224,0,0,31,192,31,250,64,15,224,0,0,31,192,5,0,0,15,224,0,0,31,192,0,0,0,15,224,0,0,31,192,0,0,0,15,224,0,0,31,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,31,255,192,0,0,0,15,224,0,15,255,64,0,0,0,15,224,0,15,249,0,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,
  // 0x62bd  抽
  189,98,34,36,68,37,1,252,0,31,128,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,127,255,255,133,85,95,213,85,64,127,255,255,159,255,255,255,255,240,127,255,255,159,255,255,255,255,240,0,47,192,31,255,255,255,255,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,95,192,15,192,11,240,0,47,239,159,192,15,192,11,240,0,47,255,223,192,15,208,11,240,27,255,255,223,255,255,255,255,240,191,255,248,31,255,255,255,255,240,127,255,192,31,255,255,255,255,240,62,111,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,213,95,213,95,240,0,47,192,31,255,255,255,255,240,0,47,192,31,255,255,255,255,240,0,47,128,31,255,255,255,255,240,47,255,128,31,192,0,0,11,240,15,255,64,31,192,0,0,11,240,15,249,0,15,192,0,0,6,144,0,0,0,0,0,0,0,0,0,
  // 0x62d4  拔
  212,98,35,36,68,37,1,252,0,31,128,0,11,208,4,0,0,0,47,192,0,15,224,47,64,0,0,47,192,0,15,208,63,224,0,0,47,192,0,15,208,15,253,0,0,47,192,0,15,208,2,255,128,0,47,192,0,15,208,0,127,128,0,47,192,0,15,208,0,15,0,0,47,192,0,15,208,0,0,0,127,255,255,191,255,255,255,255,240,127,255,255,191,255,255,255,255,240,106,191,234,127,255,255,255,255,240,0,47,192,0,15,208,0,0,0,0,47,192,0,15,208,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,240,0,253,0,0,47,192,0,47,240,0,253,0,0,47,193,64,47,244,1,252,0,0,47,255,128,63,248,2,252,0,0,127,255,192,63,252,2,248,0,111,255,255,128,127,253,3,244,0,191,255,228,0,191,127,7,240,0,127,255,192,0,254,63,75,240,0,62,47,192,0,253,47,207,208,0,0,47,192,1,252,15,239,192,0,0,47,192,2,252,11,255,128,0,0,47,192,3,244,3,255,0,0,0,47,192,11,240,2,254,0,0,0,47,192,15,224,3,255,64,0,0,47,192,47,192,11,255,208,0,0,47,192,127,128,47,255,244,0,0,47,192,255,0,191,199,254,0,0,47,131,253,3,255,1,255,208,47,255,143,248,31,252,0,127,248,15,255,71,240,15,240,0,11,240,15,249,1,192,3,128,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x6309  按
  9,99,35,36,68,37,1,252,0,31,128,0,0,31,192,0,0,0,47,192,0,0,31,192,0,0,0,47,192,0,0,31,192,0,0,0,47,192,0,0,31,192,0,0,0,47,192,0,0,31,192,0,0,0,47,192,63,255,255,255,255,240,0,47,192,63,255,255,255,255,240,0,47,192,63,255,255,255,255,240,127,255,255,191,128,0,0,7,240,127,255,255,191,64,0,0,7,240,127,255,255,191,64,254,0,7,240,0,47,192,63,64,253,0,7,240,0,47,192,21,2,252,0,1,80,0,47,192,0,3,248,0,0,0,0,47,192,0,3,244,0,0,0,0,47,192,63,255,255,255,255,248,0,47,193,191,255,255,255,255,248,0,47,255,255,255,255,255,255,248,1,191,255,192,47,192,2,252,0,127,255,255,128,63,128,3,248,0,191,255,208,0,127,0,3,248,0,127,255,192,0,191,0,7,240,0,57,47,192,0,254,0,15,240,0,0,47,192,1,254,0,31,224,0,0,47,192,2,255,244,63,192,0,0,47,192,3,255,255,191,128,0,0,47,192,2,247,255,255,0,0,0,47,192,0,0,127,255,64,0,0,47,192,0,0,31,255,224,0,0,47,192,0,0,191,255,253,0,0,47,192,0,27,255,75,255,128,0,47,128,22,255,252,1,255,224,47,255,128,255,255,208,0,47,240,15,255,64,127,249,0,0,7,208,15,249,0,62,64,0,0,1,128,0,0,0,0,0,0,0,0,0,
  // 0x6389  掉
  137,99,35,36,68,37,1,252,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,255,255,240,0,63,64,0,0,63,255,255,240,0,63,64,0,0,63,255,255,240,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,127,255,255,0,0,63,64,0,0,127,255,255,63,255,255,255,255,0,127,255,255,63,255,255,255,255,0,0,63,64,63,234,170,170,255,0,0,63,64,63,64,0,0,63,0,0,63,64,63,64,0,0,63,0,0,63,64,63,170,170,170,191,0,0,63,64,63,255,255,255,255,0,0,63,91,63,255,255,255,255,0,0,63,255,63,64,0,0,63,0,1,191,255,63,64,0,0,63,0,111,255,255,63,64,0,0,63,0,127,255,208,63,234,170,170,191,0,63,255,64,63,255,255,255,255,0,57,63,64,63,255,255,255,255,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,67,255,255,255,255,255,244,0,63,67,255,255,255,255,255,244,0,63,67,255,255,255,255,255,244,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,127,64,0,0,63,64,0,0,63,255,0,0,0,63,64,0,0,63,255,0,0,0,63,64,0,0,47,248,0,0,0,63,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x63a2  探
  162,99,35,35,59,37,1,253,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,63,255,255,255,255,224,0,63,0,63,255,255,255,255,240,0,63,0,63,255,255,255,255,240,0,63,0,62,0,0,0,7,240,0,63,0,62,11,224,189,7,240,0,63,0,62,11,208,189,7,240,127,255,255,62,15,208,189,3,224,127,255,255,0,15,192,189,0,0,127,255,255,0,31,192,189,0,128,0,63,0,0,63,128,189,1,244,0,63,0,0,255,0,190,1,244,0,63,0,7,254,0,191,171,240,0,63,0,191,248,0,127,255,240,0,63,0,63,208,21,95,255,192,0,63,26,41,0,47,128,0,0,0,63,254,0,0,47,128,0,0,1,191,255,0,0,47,128,0,0,111,255,254,0,0,47,128,0,0,191,255,144,191,255,255,255,255,240,127,255,0,191,255,255,255,255,240,56,63,0,191,255,255,255,255,240,0,63,0,0,3,255,252,0,0,0,63,0,0,15,255,255,0,0,0,63,0,0,47,255,255,128,0,0,63,0,0,191,111,159,224,0,0,63,0,2,254,47,135,248,0,0,63,0,11,252,47,130,254,0,0,63,0,127,240,47,128,255,208,0,63,2,255,192,47,128,63,248,0,127,7,254,0,47,128,15,244,47,255,1,244,0,47,128,2,208,31,254,0,64,0,47,128,0,0,15,228,0,0,0,47,128,0,0,
  // 0x63a5  接
  165,99,35,36,68,37,1,252,0,31,128,0,0,47,192,0,0,0,47,192,0,0,47,192,0,0,0,47,192,0,0,47,192,0,0,0,47,192,0,0,47,192,0,0,0,47,192,63,255,255,255,255,208,0,47,192,63,255,255,255,255,208,0,47,192,63,255,255,255,255,208,0,47,192,0,190,0,7,240,0,63,255,255,0,127,0,11,224,0,63,255,255,0,63,0,15,208,0,63,255,255,0,63,64,15,192,0,0,47,192,0,47,128,47,128,0,0,47,192,0,47,128,63,64,0,0,47,193,255,255,255,255,255,244,0,47,193,255,255,255,255,255,244,0,47,193,255,255,255,255,255,244,0,47,192,0,2,252,0,0,0,0,47,239,0,3,244,0,0,0,0,127,255,0,11,240,0,0,0,111,255,255,255,255,255,255,255,244,191,255,229,255,255,255,255,255,244,191,255,192,255,255,255,255,255,244,125,47,192,0,127,0,11,240,0,0,47,192,0,254,0,15,224,0,0,47,192,1,252,0,31,192,0,0,47,192,3,252,0,63,192,0,0,47,192,7,255,208,127,64,0,0,47,192,15,255,255,255,0,0,0,47,192,1,203,255,253,0,0,0,47,192,0,0,127,255,128,0,0,47,192,0,6,255,255,248,0,5,127,128,5,191,254,47,255,64,31,255,131,255,255,228,2,255,208,15,255,2,255,253,0,0,47,192,15,248,0,249,64,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x63a7  控
  167,99,35,35,59,37,1,253,0,63,0,0,0,47,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,255,255,255,255,255,240,0,63,0,255,255,255,255,255,240,0,63,0,255,255,255,255,255,240,0,63,0,252,11,208,189,3,240,127,255,254,252,15,208,189,3,240,127,255,254,252,15,192,189,3,240,127,255,254,252,15,192,189,0,0,0,63,0,0,47,192,189,1,0,0,63,0,0,63,128,189,2,240,0,63,0,0,191,0,190,2,240,0,63,0,7,253,0,191,255,240,0,63,25,191,248,0,127,255,224,0,63,254,127,208,0,31,255,128,0,191,255,61,0,0,0,0,0,31,255,253,0,0,0,0,0,0,191,255,128,0,0,0,0,0,0,191,255,0,31,255,255,255,255,128,125,63,0,31,255,255,255,255,128,0,63,0,31,255,255,255,255,128,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,127,3,255,255,255,255,255,244,47,255,3,255,255,255,255,255,244,31,254,3,255,255,255,255,255,244,15,228,0,0,0,0,0,0,0,
  // 0x63d0  提
  208,99,35,35,59,37,1,253,0,42,0,0,0,0,0,0,0,0,63,0,6,170,170,170,169,0,0,63,0,15,255,255,255,255,0,0,63,0,15,255,255,255,255,0,0,63,0,15,208,0,0,127,0,0,63,0,15,208,0,0,127,0,0,63,0,15,229,85,85,191,0,127,255,255,15,255,255,255,255,0,127,255,255,15,255,255,255,255,0,127,255,255,15,208,0,0,127,0,0,127,0,15,208,0,0,127,0,0,63,0,15,234,170,170,191,0,0,63,0,15,255,255,255,255,0,0,63,0,15,255,255,255,255,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,5,127,255,255,255,255,224,0,63,254,191,255,255,255,255,240,1,191,255,191,255,255,255,255,240,127,255,254,0,0,47,128,0,0,191,255,144,1,64,47,128,0,0,127,255,0,7,224,47,128,0,0,56,63,0,11,224,47,128,0,0,0,63,0,15,208,47,255,255,0,0,63,0,15,192,47,255,255,0,0,63,0,31,208,47,234,170,0,0,63,0,47,240,47,128,0,0,0,63,0,63,248,47,128,0,0,0,63,0,191,189,47,128,0,0,0,63,0,253,63,191,128,0,0,0,63,2,252,31,255,128,0,0,63,255,11,244,7,255,255,255,248,47,254,31,224,0,255,255,255,244,31,244,7,192,0,6,255,255,240,0,0,0,0,0,0,0,0,0,
  // 0x63d2  插
  210,99,34,35,59,37,1,253,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,5,190,0,0,63,0,0,86,175,255,255,64,0,63,0,63,255,255,255,255,128,0,63,0,63,255,255,250,80,0,0,63,0,26,165,111,128,0,0,0,63,0,0,0,47,128,0,0,0,63,0,0,0,47,128,0,0,127,255,255,0,0,47,128,0,0,127,255,255,255,255,255,255,255,240,127,255,255,255,255,255,255,255,240,0,63,0,255,255,255,255,255,240,0,63,0,0,0,47,128,0,0,0,63,0,0,0,47,128,0,0,0,63,0,0,31,47,128,0,0,0,63,0,57,255,255,143,255,208,0,63,110,63,255,191,143,255,208,0,63,254,63,244,47,143,255,208,11,255,255,63,0,47,128,15,208,191,255,248,63,0,47,128,15,208,191,255,64,63,0,47,128,15,208,127,191,0,63,0,47,128,15,208,16,63,0,63,255,47,143,255,208,0,63,0,63,255,47,143,255,208,0,63,0,63,255,47,143,255,208,0,63,0,63,0,47,128,15,208,0,63,0,63,0,47,128,15,208,0,63,0,63,0,47,128,15,208,0,63,0,63,0,47,128,15,208,0,63,0,63,0,47,128,15,208,0,63,0,63,255,255,255,255,208,0,127,0,63,255,255,255,255,208,47,255,0,63,255,255,255,255,208,31,254,0,63,0,0,0,15,208,15,228,0,63,0,0,0,11,192,
  // 0x63db  換
  219,99,35,36,68,37,1,252,0,63,0,0,30,64,0,0,0,0,63,0,0,63,128,0,0,0,0,63,0,0,63,64,0,0,0,0,63,0,0,255,255,252,0,0,0,63,0,1,255,255,255,0,0,0,63,0,3,254,171,254,0,0,0,63,0,15,240,2,252,0,0,0,63,0,47,192,3,244,0,0,127,255,255,191,64,11,240,0,0,127,255,255,255,255,255,255,255,192,127,255,255,255,255,255,255,255,192,0,63,0,63,255,255,255,255,192,0,63,0,47,3,224,244,15,192,0,63,0,47,3,208,244,15,192,0,63,0,47,7,208,244,15,192,0,63,0,47,15,192,248,31,192,0,63,5,47,127,64,255,255,192,0,63,254,47,254,0,127,255,192,1,191,255,47,116,0,0,15,192,127,255,254,47,0,5,0,15,192,191,255,144,47,0,63,64,15,192,127,255,0,26,0,63,0,10,64,56,63,0,0,0,63,0,0,0,0,63,2,255,255,255,255,255,240,0,63,2,255,255,255,255,255,240,0,63,1,255,255,255,255,255,240,0,63,0,0,1,255,224,0,0,0,63,0,0,3,255,244,0,0,0,63,0,0,11,242,253,0,0,0,63,0,0,47,224,255,64,0,0,63,0,1,255,128,127,244,0,0,127,0,31,254,0,15,255,144,47,255,11,255,244,0,3,255,244,31,254,3,255,64,0,0,127,208,15,228,2,228,0,0,0,2,128,0,0,0,0,0,0,0,0,0,
  // 0x64c7  擇
  199,100,35,36,68,37,1,252,0,63,0,0,0,0,0,0,0,0,63,0,21,85,85,85,85,64,0,63,0,47,255,255,255,255,208,0,63,0,47,255,255,255,255,208,0,63,0,47,3,224,61,7,208,0,63,0,47,3,224,61,7,208,0,63,0,47,3,224,61,7,208,0,63,0,47,255,255,255,255,208,127,255,255,47,255,255,255,255,208,127,255,255,5,85,111,213,85,64,127,255,255,0,0,47,128,0,0,0,63,0,10,170,191,234,170,64,0,63,0,15,255,255,255,255,128,0,63,0,15,255,255,255,255,128,0,63,0,0,0,47,128,0,0,0,63,0,0,0,47,128,0,0,0,63,110,170,170,191,234,170,164,0,63,254,255,255,255,255,255,244,27,255,255,255,255,255,255,255,244,255,255,228,0,126,0,3,240,0,191,255,0,0,63,0,11,224,0,126,127,0,0,63,64,15,192,0,16,63,0,106,191,170,175,234,160,0,63,0,191,255,255,255,255,240,0,63,0,191,255,255,255,255,240,0,63,0,0,0,47,128,0,0,0,63,0,0,0,47,128,0,0,0,63,0,42,170,191,234,170,128,0,63,0,63,255,255,255,255,192,0,63,0,63,255,255,255,255,192,0,63,0,0,0,47,128,0,0,0,127,0,0,0,47,128,0,0,47,255,0,0,0,47,128,0,0,31,254,0,0,0,47,128,0,0,15,228,0,0,0,47,128,0,0,0,0,0,0,0,0,0,0,0,
  // 0x64ca  擊
  202,100,34,35,59,37,2,253,0,3,208,0,0,0,0,0,0,0,3,224,0,3,255,255,128,0,191,255,255,255,67,255,255,128,0,191,255,255,255,67,245,111,129,0,0,3,224,0,7,224,31,131,128,31,255,255,252,15,208,31,131,192,31,87,229,188,47,192,15,255,192,31,87,229,124,191,64,11,255,128,31,255,255,252,29,0,1,85,0,31,3,224,60,63,255,255,252,0,31,255,255,252,63,255,255,248,0,5,87,229,84,7,229,87,240,0,255,255,255,255,67,244,15,208,0,255,255,255,255,64,254,127,128,0,0,3,224,104,0,127,254,0,0,31,3,224,188,1,191,253,0,0,31,3,224,188,191,255,255,229,0,31,255,255,252,63,228,47,255,208,15,255,255,252,20,0,2,255,128,0,0,0,5,90,191,244,6,0,0,255,255,255,255,255,248,0,0,0,255,255,255,250,84,0,0,0,0,0,0,3,240,0,0,0,0,7,255,255,255,255,255,255,248,0,7,255,255,255,255,255,255,248,0,0,0,0,7,244,0,0,0,0,0,0,0,3,240,0,0,0,0,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,21,85,85,87,245,85,85,85,64,0,0,0,3,240,0,0,0,0,0,0,0,3,240,0,0,0,0,0,0,26,175,240,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,15,255,128,0,0,0,0,
  // 0x64cb  擋
  203,100,34,35,59,37,1,253,0,63,0,0,64,47,128,16,0,0,63,0,15,192,47,128,127,0,0,63,0,11,240,47,128,191,0,0,63,0,3,244,47,128,252,0,0,63,0,2,252,47,130,248,0,0,63,0,0,244,47,130,240,0,0,63,0,191,255,255,255,255,240,0,63,0,191,255,255,255,255,240,127,255,255,191,170,170,170,175,240,127,255,255,190,0,0,0,7,240,127,255,255,190,0,0,0,7,240,0,63,0,190,255,255,255,255,240,0,63,0,21,255,255,255,249,80,0,63,0,0,253,85,87,248,0,0,63,0,0,252,0,2,248,0,0,63,0,0,252,0,2,248,0,0,63,25,0,253,85,86,248,0,0,63,254,0,255,255,255,248,0,1,191,255,0,255,255,255,248,0,191,255,253,0,0,0,0,0,0,191,255,128,0,0,0,0,0,0,127,255,0,31,255,255,255,255,192,36,63,0,31,255,255,255,255,192,0,63,0,31,234,191,170,191,192,0,63,0,31,128,47,64,47,192,0,63,0,31,128,47,64,47,192,0,63,0,31,255,255,255,255,192,0,63,0,31,255,255,255,255,192,0,63,0,31,213,127,149,127,192,0,63,0,31,128,47,64,47,192,0,63,0,31,128,47,64,47,192,0,127,0,31,255,255,255,255,192,47,255,0,31,255,255,255,255,192,31,254,0,31,234,170,170,191,192,15,228,0,31,128,0,0,47,128,
  // 0x64e0  擠
  224,100,35,36,68,37,1,252,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,2,255,255,255,255,255,240,0,63,3,255,255,255,255,255,240,0,63,3,255,255,255,255,255,240,0,63,0,0,3,128,61,0,0,0,127,0,0,3,208,188,1,64,127,255,252,0,3,240,248,31,208,127,255,253,255,255,241,255,255,208,127,255,253,255,255,171,159,255,0,0,63,0,31,31,47,15,79,64,0,63,0,46,31,47,15,75,128,0,63,0,62,31,47,15,71,192,0,63,0,124,47,47,15,71,224,0,63,0,252,62,47,47,253,244,0,63,111,243,254,47,63,248,244,0,63,254,210,248,47,20,0,16,6,255,253,69,64,0,0,21,0,191,255,228,15,208,0,0,126,0,191,255,0,15,208,0,0,126,0,127,191,0,15,255,255,255,254,0,36,63,0,15,255,255,255,254,0,0,63,0,15,250,170,170,254,0,0,63,0,15,208,0,0,126,0,0,63,0,15,208,0,0,126,0,0,63,0,15,250,170,170,254,0,0,63,0,15,255,255,255,254,0,0,63,0,31,255,255,255,254,0,0,63,0,63,128,0,0,126,0,0,63,0,127,64,0,0,126,0,0,127,0,255,0,0,0,126,0,63,255,3,253,0,0,0,126,0,47,253,3,248,0,0,0,126,0,31,228,0,160,0,0,0,126,0,0,0,0,0,0,0,0,0,0,
  // 0x6536  收
  54,101,35,36,68,37,1,252,0,0,10,144,1,228,0,0,0,0,0,15,208,2,252,0,0,0,0,0,15,208,3,252,0,0,0,0,0,15,208,3,248,0,0,0,1,80,15,208,7,240,0,0,0,7,240,15,208,11,240,0,0,0,7,240,15,208,15,224,0,0,0,7,240,15,208,31,255,255,255,248,7,240,15,208,63,255,255,255,248,7,240,15,208,63,255,255,255,248,7,240,15,208,191,213,85,127,144,7,240,15,208,255,192,0,127,0,7,240,15,210,255,192,0,191,0,7,240,15,215,255,208,0,254,0,7,240,15,239,255,240,0,253,0,7,240,15,255,231,240,1,252,0,7,240,15,239,195,244,3,252,0,7,240,15,215,66,252,3,244,0,7,240,15,208,1,252,11,240,0,7,240,15,208,0,254,15,224,0,7,240,15,208,0,191,47,208,0,7,240,15,208,0,63,191,192,0,7,246,255,208,0,47,255,64,0,11,255,255,208,0,15,254,0,0,191,255,255,208,0,11,252,0,0,127,255,79,208,0,15,252,0,0,63,144,15,208,0,63,255,0,0,20,0,15,208,0,191,255,128,0,0,0,15,208,3,255,127,224,0,0,0,15,208,31,252,15,252,0,0,0,15,208,191,240,7,255,64,0,0,15,235,255,192,1,255,244,0,0,15,223,254,0,0,127,248,0,0,15,215,240,0,0,11,224,0,0,15,210,64,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x653e  放
  62,101,35,36,68,37,1,252,0,3,244,0,0,58,0,0,0,0,3,244,0,0,63,64,0,0,0,3,244,0,0,127,0,0,0,0,3,244,0,0,191,0,0,0,0,3,244,0,0,255,0,0,0,0,3,244,0,0,254,0,0,0,127,255,255,255,193,253,0,0,0,127,255,255,255,194,255,255,255,248,127,255,255,255,195,255,255,255,248,0,127,0,0,3,255,255,255,248,0,63,0,0,11,244,0,191,0,0,63,0,0,15,244,0,254,0,0,63,0,0,31,248,0,253,0,0,63,0,0,63,252,0,252,0,0,63,255,254,127,252,1,252,0,0,63,255,254,255,253,2,252,0,0,63,255,255,254,190,3,248,0,0,127,0,254,252,127,7,244,0,0,127,0,253,40,63,75,240,0,0,127,0,253,0,63,143,224,0,0,127,0,253,0,31,223,208,0,0,127,0,253,0,15,255,192,0,0,190,0,253,0,11,255,64,0,0,254,0,253,0,7,255,0,0,0,253,0,252,0,3,254,0,0,0,252,0,252,0,3,254,0,0,2,252,0,252,0,15,255,64,0,3,248,0,252,0,47,255,192,0,7,244,0,252,0,191,239,240,0,15,240,1,252,2,255,15,252,0,31,224,2,252,31,252,3,255,64,63,192,3,248,191,240,0,255,224,255,67,255,251,255,192,0,127,244,126,1,255,241,254,0,0,15,224,12,1,255,128,240,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x6557  敗
  87,101,35,35,59,37,1,253,0,0,0,0,0,126,0,0,0,7,255,255,253,0,191,0,0,0,11,255,255,254,0,255,0,0,0,11,255,255,254,0,254,0,0,0,11,224,0,254,1,253,0,0,0,11,224,0,254,2,252,0,0,0,11,224,0,254,3,252,0,0,0,11,224,0,254,3,255,255,255,248,11,250,170,254,11,255,255,255,248,11,255,255,254,15,255,255,255,248,11,255,255,254,31,245,85,255,80,11,224,0,254,47,240,0,253,0,11,224,0,254,127,244,1,253,0,11,224,0,254,255,248,2,252,0,11,224,0,255,255,252,2,252,0,11,250,170,255,254,252,3,248,0,11,255,255,255,248,253,3,244,0,11,255,255,254,240,254,11,240,0,11,224,0,254,0,127,15,240,0,11,224,0,254,0,63,95,208,0,11,224,0,254,0,63,239,192,0,11,224,0,254,0,31,255,128,0,11,255,255,254,0,15,255,64,0,11,255,255,254,0,7,255,0,0,11,255,255,254,0,3,253,0,0,0,0,0,64,0,11,254,0,0,0,190,7,208,0,31,255,64,0,0,254,11,240,0,127,255,208,0,2,252,3,252,1,255,175,244,0,3,248,1,253,11,254,11,253,0,15,240,0,191,127,248,3,255,128,31,224,0,63,255,240,0,255,244,127,192,0,38,255,128,0,63,244,63,64,0,0,252,0,0,11,208,9,0,0,0,96,0,0,1,128,
  // 0x6574  整
  116,101,34,34,50,37,2,254,0,2,240,0,0,41,0,0,0,0,3,240,0,0,63,64,0,0,85,87,245,85,64,127,0,0,0,255,255,255,255,192,254,0,0,0,255,255,255,255,193,255,170,170,128,0,3,240,0,3,255,255,255,192,63,255,255,255,75,255,255,255,192,63,255,255,255,111,240,3,244,0,63,3,244,47,255,252,3,240,0,63,3,240,31,255,189,11,224,0,63,3,240,31,108,63,31,192,0,63,255,255,255,68,31,255,128,0,63,255,255,255,64,15,255,0,0,0,47,254,0,0,7,253,0,0,0,191,255,208,0,31,255,64,0,2,255,255,253,0,191,255,224,0,31,243,241,255,75,255,95,254,0,255,195,240,46,191,252,3,255,208,190,3,240,4,127,208,0,191,192,52,3,240,0,45,0,0,11,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,10,170,170,175,254,170,170,168,0,0,0,0,3,240,0,0,0,0,0,31,192,3,240,0,0,0,0,0,31,192,3,255,255,255,64,0,0,31,192,3,255,255,255,64,0,0,31,192,3,250,170,170,0,0,0,31,192,3,240,0,0,0,0,0,31,192,3,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x6578  數
  120,101,35,36,68,37,1,252,0,0,63,0,0,3,160,0,0,0,0,63,0,0,3,240,0,0,3,255,255,255,240,7,240,0,0,3,255,255,255,240,7,240,0,0,3,245,127,87,240,11,224,0,0,3,240,63,3,240,15,224,0,0,127,255,255,255,255,143,208,0,0,127,255,255,255,255,143,255,255,244,107,240,127,3,250,95,255,255,244,3,240,63,3,240,63,255,255,244,3,245,127,87,240,63,128,63,64,3,255,255,255,240,127,128,63,0,3,255,255,255,240,255,128,63,0,0,0,63,0,0,255,192,127,0,15,255,255,255,254,255,192,190,0,15,255,255,255,255,255,208,189,0,15,192,127,1,255,255,224,253,0,15,192,63,0,255,247,240,252,0,15,192,127,1,254,211,241,252,0,15,255,255,255,252,67,246,248,0,15,255,255,255,252,2,251,244,0,0,3,244,0,0,1,255,240,0,0,7,240,0,0,0,255,224,0,127,255,255,255,255,128,191,208,0,127,255,255,255,255,128,127,192,0,42,191,234,175,128,0,63,192,0,0,191,0,47,64,0,255,208,0,0,255,64,63,0,2,255,240,0,3,255,249,253,0,7,255,248,0,1,183,255,252,0,31,242,253,0,0,0,191,253,0,127,192,255,64,0,27,255,255,130,255,0,127,224,31,255,253,63,251,253,0,31,244,15,255,128,7,195,240,0,7,208,11,144,0,0,1,128,0,1,128,0,0,0,0,0,0,0,0,0,
  // 0x6599  料
  153,101,35,35,59,37,1,253,0,6,160,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,4,7,224,16,0,0,3,240,0,62,7,224,126,3,192,3,240,0,47,7,224,189,15,244,3,240,0,31,7,224,252,7,254,3,240,0,15,135,224,248,0,255,131,240,0,15,199,225,244,0,47,195,240,0,11,199,226,240,0,11,131,240,0,11,199,227,224,0,2,3,240,0,7,215,227,208,0,0,3,240,0,2,71,226,192,0,0,3,240,0,0,11,240,0,20,0,3,240,0,63,255,255,253,62,0,3,240,0,63,255,255,253,191,208,3,240,0,63,255,255,253,47,248,3,240,0,0,47,240,0,7,254,3,240,0,0,63,248,0,0,188,3,240,0,0,127,253,0,0,40,3,240,0,0,255,255,0,0,0,3,240,0,1,255,255,192,0,0,3,240,80,2,251,235,224,0,0,7,255,244,3,231,227,248,0,22,255,255,248,11,215,225,252,107,255,255,255,244,31,199,224,246,255,255,255,244,0,63,135,224,97,255,254,151,240,0,191,7,224,0,249,64,3,240,0,190,7,224,0,0,0,3,240,0,60,7,224,0,0,0,3,240,0,36,7,224,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,
  // 0x659c  斜
  156,101,35,35,59,37,1,253,0,1,254,0,0,0,0,252,0,0,3,255,128,0,0,0,252,0,0,7,255,224,0,0,0,252,0,0,15,255,252,0,60,0,252,0,0,31,211,255,0,255,0,252,0,0,63,192,255,192,127,192,252,0,0,255,0,63,224,31,240,252,0,2,253,0,31,244,7,253,252,0,11,248,0,7,224,1,253,252,0,47,240,0,2,128,0,160,252,0,191,255,255,255,0,0,0,252,0,255,255,255,255,0,0,0,252,0,61,255,255,255,0,208,0,252,0,0,0,190,0,3,248,0,252,0,0,0,190,0,3,255,0,252,0,0,0,190,0,0,255,192,252,0,0,0,190,0,0,47,240,252,0,63,255,255,255,240,11,244,252,0,63,255,255,255,240,2,208,252,0,63,255,255,255,240,0,0,252,0,0,0,190,0,0,0,0,252,16,0,0,190,0,0,0,1,255,244,2,224,190,47,0,1,111,255,248,3,240,190,47,65,191,255,255,248,7,240,190,31,207,255,255,253,0,11,224,190,15,219,255,229,252,0,15,192,190,7,247,228,0,252,0,31,192,190,3,240,0,0,252,0,63,64,190,2,244,0,0,252,0,191,0,190,1,244,0,0,252,0,61,0,190,0,0,0,0,252,0,4,0,190,0,0,0,0,252,0,0,127,253,0,0,0,0,252,0,0,63,252,0,0,0,0,252,0,0,47,224,0,0,0,0,252,0,
  // 0x65b0  新
  176,101,35,36,68,37,1,252,0,0,168,0,0,0,0,1,0,0,0,252,0,0,0,0,111,64,0,0,252,0,0,0,27,255,208,0,0,252,0,2,70,255,255,208,47,255,255,255,227,255,255,244,0,47,255,255,255,227,255,249,0,0,47,255,255,255,227,249,0,0,0,1,244,0,189,3,244,0,0,0,1,248,0,253,3,244,0,0,0,0,252,1,252,3,244,0,0,0,0,189,2,244,3,244,0,0,0,0,125,2,240,3,244,0,0,0,63,255,255,255,243,248,0,0,0,63,255,255,255,243,255,255,255,244,63,255,255,255,243,255,255,255,244,0,0,252,0,3,255,255,255,244,0,0,252,0,3,244,2,248,0,0,0,252,0,3,244,2,248,0,0,0,252,0,3,244,2,248,0,63,255,255,255,227,244,2,248,0,63,255,255,255,227,244,2,248,0,63,255,255,255,227,240,2,248,0,0,3,252,0,3,240,2,248,0,0,15,255,64,7,240,2,248,0,0,47,255,224,11,224,2,248,0,0,127,255,248,15,224,2,248,0,0,254,253,255,15,208,2,248,0,3,248,252,127,95,192,2,248,0,31,240,252,30,63,128,2,248,0,127,192,252,4,127,64,2,248,0,127,64,252,0,255,0,2,248,0,29,0,252,2,253,0,2,248,0,0,0,252,7,248,0,2,248,0,0,0,252,2,240,0,2,248,0,0,0,252,0,128,0,2,164,0,0,0,0,0,0,0,0,0,0,
  // 0x65b7  斷
  183,101,33,35,59,37,3,253,0,20,0,16,0,0,0,64,0,164,45,0,184,0,0,2,244,0,248,60,0,240,0,0,127,253,0,249,181,70,213,1,27,255,248,0,255,243,223,207,71,255,255,64,0,249,247,135,223,7,255,224,0,0,248,191,2,253,7,244,0,0,0,248,62,0,248,7,240,0,0,0,248,61,192,247,135,240,0,0,0,248,181,210,227,199,240,0,0,0,255,255,255,255,215,240,0,0,0,251,250,255,250,247,240,0,0,0,248,0,0,0,71,240,0,0,0,254,170,170,170,135,255,255,255,64,255,255,255,255,199,255,255,255,64,255,255,255,255,199,255,255,255,64,248,45,0,184,7,240,15,192,0,248,60,0,240,7,240,15,192,0,248,180,2,224,7,224,15,192,0,255,242,143,198,71,224,15,192,0,250,227,203,143,71,224,15,192,0,248,255,67,238,7,224,15,192,0,248,127,1,252,11,224,15,192,0,248,61,0,248,11,208,15,192,0,248,125,192,243,79,208,15,192,0,248,241,227,211,207,192,15,192,0,255,255,255,255,239,192,15,192,0,255,233,191,165,255,128,15,192,0,248,0,0,0,63,64,15,192,0,255,255,255,255,255,0,15,192,0,255,255,255,255,255,0,15,192,0,254,170,170,171,253,0,15,192,0,248,0,0,2,252,0,15,192,0,248,0,0,0,180,0,15,192,0,80,0,0,0,32,0,15,192,0,
  // 0x65bc  於
  188,101,35,36,68,37,1,252,0,3,244,0,0,7,244,0,0,0,3,244,0,0,11,252,0,0,0,3,244,0,0,15,253,0,0,0,3,244,0,0,31,254,0,0,0,3,244,0,0,63,191,0,0,0,3,244,0,0,127,47,128,0,127,255,255,255,64,254,31,208,0,127,255,255,255,65,253,15,240,0,127,255,255,255,67,252,7,248,0,0,191,0,0,11,240,2,253,0,0,127,0,0,31,224,0,255,0,0,191,0,0,127,192,0,191,192,0,191,0,0,255,64,0,63,240,0,191,0,3,254,0,0,15,248,0,191,255,254,248,0,0,3,240,0,191,255,252,224,31,64,0,224,0,191,255,252,64,63,224,0,0,0,254,1,252,0,31,252,0,0,0,253,1,252,0,3,255,0,0,0,253,1,252,0,0,191,192,0,0,253,1,252,0,0,47,192,0,0,252,2,248,0,0,11,0,0,0,252,2,248,0,0,0,0,0,1,252,2,248,0,0,0,0,0,2,248,2,248,1,64,0,0,0,3,248,2,248,7,244,0,0,0,3,244,2,248,15,255,0,0,0,7,240,3,248,11,255,224,0,0,11,240,3,244,0,191,253,0,0,15,208,3,244,0,11,255,128,0,47,192,3,244,0,1,255,244,0,63,192,11,240,0,0,47,253,0,191,71,255,240,0,0,7,255,0,62,3,255,208,0,0,0,252,0,12,3,255,64,0,0,0,36,0,0,0,0,0,0,0,0,0,0,
  // 0x6607  昇
  7,102,33,34,50,37,2,253,1,255,255,255,255,255,255,192,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,1,252,0,0,0,0,15,208,0,1,252,0,0,0,0,15,208,0,1,252,0,0,0,0,15,208,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,1,254,170,170,170,170,175,208,0,1,252,0,0,0,0,15,208,0,1,252,0,0,0,0,15,208,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,0,0,0,1,64,0,0,0,0,0,0,1,191,208,15,224,0,0,0,26,255,255,244,15,224,0,0,15,255,255,255,144,15,224,0,0,11,255,255,208,0,15,224,0,0,7,165,63,128,0,15,224,0,0,0,0,47,128,0,15,224,0,0,0,0,47,128,0,15,224,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,127,64,0,15,224,0,0,0,0,255,0,0,15,224,0,0,0,2,254,0,0,15,224,0,0,0,11,252,0,0,15,224,0,0,0,63,244,0,0,15,224,0,0,6,255,224,0,0,15,224,0,0,47,255,64,0,0,15,224,0,0,11,248,0,0,0,15,224,0,0,3,128,0,0,0,15,224,0,0,
  // 0x660e  明
  14,102,32,34,16,37,3,252,255,255,255,66,255,255,255,253,255,255,255,66,255,255,255,253,255,255,255,66,255,255,255,253,253,0,63,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,66,252,0,0,253,252,0,63,66,255,255,255,253,255,255,255,66,255,255,255,253,255,255,255,66,255,255,255,253,255,255,255,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,67,248,0,0,253,252,0,63,67,248,0,0,253,252,0,63,67,248,0,0,253,252,0,63,67,255,255,255,253,253,0,63,67,255,255,255,253,255,255,255,71,255,255,255,253,255,255,255,75,240,0,0,253,255,255,255,79,224,0,0,253,252,0,0,15,208,0,0,253,252,0,0,47,192,0,0,253,252,0,0,63,128,0,0,253,84,0,0,191,64,0,0,253,0,0,0,255,0,0,0,253,0,0,3,253,0,0,0,253,0,0,15,248,0,5,86,253,0,0,63,240,0,11,255,252,0,0,47,192,0,7,255,248,0,0,11,0,0,3,255,144,0,0,0,0,0,0,0,0,
  // 0x662f  是
  47,102,35,34,50,37,1,253,0,42,170,170,170,170,170,144,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,64,0,0,0,11,240,0,0,63,64,0,0,0,11,240,0,0,63,149,85,85,85,95,240,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,64,0,0,0,11,240,0,0,63,64,0,0,0,11,240,0,0,63,170,170,170,170,175,240,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,0,0,0,0,254,0,0,0,0,0,2,148,0,254,0,0,0,0,0,3,248,0,254,0,0,0,0,0,7,244,0,254,0,0,0,0,0,11,240,0,255,255,255,253,0,0,15,240,0,255,255,255,253,0,0,31,244,0,255,255,255,253,0,0,47,252,0,254,0,0,0,0,0,63,255,0,254,0,0,0,0,0,255,191,128,254,0,0,0,0,2,254,47,244,254,0,0,0,0,7,252,15,255,254,0,0,0,0,31,244,2,255,255,255,255,255,244,127,224,0,127,255,255,255,255,240,47,64,0,1,191,255,255,255,224,9,0,0,0,0,0,0,0,0,
  // 0x6642  時
  66,102,33,35,59,37,3,253,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,255,255,248,0,0,254,0,0,0,255,255,248,127,255,255,255,252,0,255,255,248,127,255,255,255,252,0,252,2,248,127,255,255,255,252,0,252,2,248,0,0,254,0,0,0,252,2,248,0,0,254,0,0,0,252,2,248,0,0,254,0,0,0,252,2,248,0,0,254,0,0,0,252,2,248,0,0,254,0,0,0,252,2,250,255,255,255,255,255,128,255,255,250,255,255,255,255,255,128,255,255,250,255,255,255,255,255,128,255,255,248,0,0,0,63,64,0,252,2,248,0,0,0,63,64,0,252,2,248,0,0,0,63,64,0,252,2,248,0,0,0,63,64,0,252,2,250,255,255,255,255,255,0,252,2,250,255,255,255,255,255,0,252,2,250,255,255,255,255,255,0,252,2,248,0,0,0,63,64,0,252,2,248,11,192,0,63,64,0,255,255,248,15,240,0,63,64,0,255,255,248,7,252,0,63,64,0,255,255,248,2,254,0,63,64,0,252,0,0,0,255,0,63,64,0,252,0,0,0,127,128,63,64,0,252,0,0,0,62,0,63,64,0,252,0,0,0,20,0,63,64,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,255,254,0,0,0,0,0,0,0,191,228,0,0,
  // 0x66ab  暫
  171,102,33,35,59,37,2,253,0,3,240,0,0,0,0,96,0,0,3,240,0,0,0,27,252,0,191,255,255,255,203,175,255,254,0,191,255,255,255,203,255,255,144,0,0,3,244,0,11,254,144,0,0,0,3,240,0,11,208,0,0,0,47,255,255,255,11,208,0,0,0,47,171,250,191,11,208,0,0,0,47,3,240,47,15,250,170,170,128,47,255,255,255,15,255,255,255,192,47,171,250,191,15,255,255,255,192,47,3,240,47,15,192,31,192,0,47,171,250,191,15,192,31,192,0,47,255,255,255,47,128,31,192,0,0,3,240,0,63,64,31,192,0,255,255,255,255,255,0,31,192,0,255,255,255,255,253,0,31,192,0,0,3,240,3,252,0,31,192,0,0,3,240,1,240,0,31,192,0,0,1,80,0,64,0,6,64,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,234,170,170,170,255,0,0,0,63,64,0,0,0,191,0,0,0,63,64,0,0,0,191,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,149,85,85,85,191,0,0,0,63,64,0,0,0,191,0,0,0,63,64,0,0,0,191,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,234,170,170,170,255,0,0,0,63,64,0,0,0,127,0,0,
  // 0x66f4  更
  244,102,34,33,41,37,2,253,127,255,255,255,255,255,255,255,128,127,255,255,255,255,255,255,255,128,127,255,255,255,255,255,255,255,128,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,252,0,3,248,0,3,240,0,0,252,0,3,248,0,3,240,0,0,252,0,3,248,0,3,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,254,170,171,254,170,171,240,0,0,252,0,3,248,0,3,240,0,0,252,0,3,248,0,3,240,0,0,252,0,3,248,0,3,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,11,0,15,240,0,0,0,0,0,63,192,31,208,0,0,0,0,0,31,240,63,192,0,0,0,0,0,11,253,191,128,0,0,0,0,0,2,255,255,0,0,0,0,0,0,0,191,253,0,0,0,0,0,0,1,255,255,228,0,0,0,0,0,111,255,255,255,249,84,0,0,175,255,253,31,255,255,255,255,224,191,255,144,0,191,255,255,255,192,63,244,0,0,0,107,255,255,128,9,0,0,0,0,0,0,21,0,
  // 0x6700  最
  0,103,33,34,50,37,2,253,0,127,255,255,255,255,255,128,0,0,127,255,255,255,255,255,128,0,0,127,85,85,85,85,127,128,0,0,127,0,0,0,0,63,128,0,0,127,0,0,0,0,63,128,0,0,127,255,255,255,255,255,128,0,0,127,255,255,255,255,255,128,0,0,127,0,0,0,0,63,128,0,0,127,0,0,0,0,63,128,0,0,127,255,255,255,255,255,128,0,0,127,255,255,255,255,255,128,0,0,21,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,2,244,0,190,0,0,0,0,0,2,244,0,190,0,0,0,0,0,2,249,85,254,42,170,170,164,0,2,255,255,254,127,255,255,253,0,2,255,255,254,127,255,255,252,0,2,244,0,190,7,192,3,248,0,2,244,0,190,11,224,7,240,0,2,255,255,254,3,244,15,224,0,2,255,255,254,2,252,63,192,0,2,249,85,254,0,255,191,64,0,2,244,0,190,0,63,254,0,0,2,244,0,254,0,47,252,0,0,3,255,255,254,0,63,253,0,0,255,255,255,254,2,255,255,192,0,255,255,255,254,111,253,127,253,0,254,148,0,191,255,224,11,255,192,0,0,0,190,127,64,1,191,64,0,0,0,189,32,0,0,6,0,
  // 0x6709  有
  9,103,33,36,68,37,2,252,0,0,0,228,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,63,128,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,255,255,255,255,255,64,0,0,15,255,255,255,255,255,64,0,0,63,255,255,255,255,255,64,0,0,255,248,0,0,0,63,64,0,2,255,248,0,0,0,63,64,0,11,255,248,0,0,0,63,64,0,63,243,255,255,255,255,255,64,0,255,211,255,255,255,255,255,64,0,255,67,255,255,255,255,255,64,0,60,3,248,0,0,0,63,64,0,16,3,248,0,0,0,63,64,0,0,3,248,0,0,0,63,64,0,0,3,248,0,0,0,63,64,0,0,3,255,255,255,255,255,64,0,0,3,255,255,255,255,255,64,0,0,3,255,255,255,255,255,64,0,0,3,248,0,0,0,63,64,0,0,3,248,0,0,0,63,64,0,0,3,248,0,0,0,63,64,0,0,3,248,0,0,80,127,64,0,0,3,248,0,1,255,255,64,0,0,3,248,0,0,255,255,0,0,0,3,248,0,0,255,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x677f  板
  127,103,35,36,68,37,1,252,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,1,255,255,255,255,240,0,15,208,1,255,255,255,255,240,0,15,208,1,255,255,255,255,240,0,15,208,1,252,0,0,0,0,0,15,208,1,252,0,0,0,0,0,15,208,1,252,0,0,0,0,63,255,255,241,252,0,0,0,0,63,255,255,241,252,0,0,0,0,63,255,255,241,252,0,0,0,0,0,31,224,1,252,0,0,0,0,0,47,208,1,255,255,255,255,208,0,63,208,1,255,255,255,255,208,0,63,240,1,255,255,255,255,192,0,127,248,1,255,240,0,47,192,0,255,253,1,255,240,0,63,128,0,255,255,1,254,248,0,63,64,1,255,255,194,253,252,0,127,0,3,255,223,226,248,253,0,254,0,7,223,211,242,248,191,0,253,0,15,207,210,227,248,63,66,252,0,31,143,208,195,244,63,199,244,0,63,79,208,3,240,15,223,240,0,191,15,208,7,240,11,255,208,0,189,15,208,11,240,3,255,192,0,60,15,208,15,224,2,255,64,0,16,15,208,15,208,2,255,64,0,0,15,208,47,192,15,255,208,0,0,15,208,63,128,63,255,248,0,0,15,208,191,65,255,199,255,0,0,15,208,255,15,255,1,255,224,0,15,210,252,47,248,0,127,244,0,15,208,184,15,208,0,11,224,0,11,208,32,2,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x67f1  柱
  241,103,35,36,68,37,1,252,0,7,240,0,0,52,0,0,0,0,7,240,0,0,254,0,0,0,0,7,240,0,1,255,192,0,0,0,7,240,0,0,127,244,0,0,0,7,240,0,0,15,253,0,0,0,7,240,0,0,2,255,0,0,0,7,240,0,0,0,191,0,0,0,7,240,0,0,0,125,0,0,63,255,255,253,255,255,255,255,240,63,255,255,253,255,255,255,255,240,63,255,255,253,255,255,255,255,240,21,95,245,80,0,3,248,0,0,0,15,240,0,0,3,248,0,0,0,31,240,0,0,3,248,0,0,0,47,240,0,0,3,248,0,0,0,63,252,0,0,3,248,0,0,0,127,254,0,0,3,248,0,0,0,191,255,64,0,3,248,0,0,0,255,255,208,0,3,248,0,0,2,251,251,240,191,255,255,255,224,3,247,243,252,191,255,255,255,224,11,215,240,252,191,255,255,255,224,15,199,240,176,0,3,248,0,0,47,135,240,16,0,3,248,0,0,127,7,240,0,0,3,248,0,0,190,7,240,0,0,3,248,0,0,60,7,240,0,0,3,248,0,0,40,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,31,255,255,255,255,248,0,7,240,31,255,255,255,255,248,0,7,240,31,255,255,255,255,248,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6821  校
  33,104,35,36,68,37,1,252,0,15,208,0,0,15,224,0,0,0,15,208,0,0,15,224,0,0,0,15,208,0,0,15,224,0,0,0,15,208,0,0,15,224,0,0,0,15,208,0,0,15,224,0,0,0,15,208,0,0,15,224,0,0,0,15,208,15,255,255,255,255,240,0,15,208,15,255,255,255,255,240,63,255,255,234,170,170,170,170,160,63,255,255,224,0,0,0,64,0,63,255,255,224,15,128,7,224,0,0,31,208,0,47,192,7,248,0,0,47,208,0,63,128,2,253,0,0,63,208,0,255,0,0,255,64,0,63,240,2,253,0,0,63,192,0,127,248,7,248,0,0,31,224,0,255,253,31,241,0,6,91,240,0,255,255,47,239,192,11,243,244,2,255,239,139,15,192,15,225,128,3,239,223,192,11,224,31,208,0,7,223,215,240,7,240,47,192,0,15,207,211,208,3,252,127,128,0,31,143,209,128,1,253,255,0,0,63,79,208,0,0,255,253,0,0,191,15,208,0,0,63,252,0,0,125,15,208,0,0,47,244,0,0,60,15,208,0,0,47,248,0,0,16,15,208,0,0,191,254,0,0,0,15,208,0,3,255,255,192,0,0,15,208,0,31,252,127,244,0,0,15,208,0,255,240,31,254,0,0,15,208,27,255,128,3,255,224,0,15,208,127,253,0,0,255,244,0,15,208,63,208,0,0,31,208,0,15,208,13,0,0,0,2,128,0,0,0,0,0,0,0,0,0,
  // 0x683c  格
  60,104,35,35,59,37,1,253,0,15,208,0,0,228,0,0,0,0,15,208,0,1,253,0,0,0,0,15,208,0,2,252,0,0,0,0,15,208,0,7,244,0,0,0,0,15,208,0,15,255,255,253,0,0,15,208,0,31,255,255,255,0,0,15,208,0,63,255,255,253,0,0,15,208,0,255,64,2,252,0,63,255,255,242,255,192,3,248,0,63,255,255,251,255,208,11,240,0,63,255,255,255,251,240,31,208,0,0,31,224,127,195,252,63,128,0,0,31,224,31,1,254,255,0,0,0,63,244,5,0,127,253,0,0,0,63,252,0,0,47,248,0,0,0,127,255,0,0,127,252,0,0,0,191,255,128,2,255,255,128,0,0,255,223,208,15,254,191,244,0,1,255,215,240,191,244,31,255,64,3,255,211,219,255,192,3,255,248,7,223,209,255,254,0,0,127,244,15,207,208,191,255,255,255,255,224,31,143,208,62,255,255,255,255,64,63,79,208,0,255,255,255,254,0,191,15,208,0,252,0,0,190,0,125,15,208,0,252,0,0,190,0,56,15,208,0,252,0,0,190,0,16,15,208,0,252,0,0,190,0,0,15,208,0,252,0,0,190,0,0,15,208,0,252,0,0,190,0,0,15,208,0,255,255,255,254,0,0,15,208,0,255,255,255,254,0,0,15,208,0,255,255,255,254,0,0,15,208,0,252,0,0,190,0,0,10,144,0,168,0,0,105,0,
  // 0x689d  條
  157,104,35,36,68,37,1,252,0,2,64,0,0,228,0,0,0,0,3,244,0,2,252,0,0,0,0,7,240,0,3,244,0,0,0,0,15,224,0,11,240,0,0,0,0,15,213,64,31,255,255,255,240,0,47,203,208,63,255,255,255,240,0,63,75,208,191,255,255,255,240,0,127,11,210,255,64,2,252,0,0,254,11,219,255,192,7,244,0,1,254,11,255,251,240,15,240,0,3,254,11,223,195,252,63,192,0,11,254,11,210,0,255,255,64,0,15,254,11,208,0,63,253,0,0,63,254,11,208,0,63,253,0,0,191,254,11,208,2,255,255,208,0,255,190,11,208,111,254,191,254,64,189,190,11,223,255,244,11,255,248,56,190,11,219,255,65,80,191,240,32,190,11,211,224,7,240,6,208,0,190,11,208,0,7,240,0,0,0,190,11,208,0,7,240,0,0,0,190,11,215,255,255,255,255,240,0,190,11,215,255,255,255,255,240,0,190,11,215,255,255,255,255,240,0,190,11,208,0,63,253,0,0,0,190,11,208,0,255,255,0,0,0,190,11,208,2,255,255,192,0,0,190,11,208,15,251,251,240,0,0,190,11,192,63,215,243,252,0,0,190,0,1,255,71,240,255,64,0,190,0,31,253,7,240,63,224,0,190,0,127,244,7,240,31,248,0,190,0,47,192,7,240,3,240,0,190,0,9,0,7,240,0,128,0,190,0,0,0,7,240,0,0,0,0,0,0,0,0,0,0,0,
  // 0x68c4  棄
  196,104,33,35,59,37,2,253,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,170,170,191,250,170,191,234,170,128,0,0,63,192,0,127,224,0,0,0,0,255,0,0,11,254,0,0,15,255,255,255,255,255,255,208,0,15,255,255,255,255,255,255,252,0,15,255,255,255,170,165,86,253,0,0,0,0,1,80,0,0,116,0,0,31,192,3,240,0,253,0,0,0,31,192,3,240,0,253,0,0,106,175,234,171,250,170,255,170,128,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,0,31,192,3,240,0,253,0,0,0,31,192,3,240,0,253,0,0,0,31,234,171,250,170,253,0,0,0,31,255,255,255,255,253,0,0,0,31,255,255,255,255,253,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,128,0,0,11,255,255,248,0,0,0,0,0,127,215,242,255,64,0,0,0,7,255,71,240,127,248,0,0,1,191,248,7,240,11,255,208,0,111,255,192,7,240,0,255,255,128,255,249,0,7,240,0,11,255,192,63,128,0,7,240,0,0,191,0,20,0,0,7,240,0,0,1,0,
  // 0x69fd  槽
  253,105,35,36,68,37,1,252,0,31,192,0,3,240,63,0,0,0,31,192,0,3,240,63,0,0,0,31,192,0,3,240,63,0,0,0,31,192,191,255,255,255,255,248,0,31,192,191,255,255,255,255,248,0,31,192,106,171,250,255,170,164,0,31,192,0,3,240,63,0,0,0,31,192,0,3,240,63,0,0,63,255,255,159,255,255,255,255,208,63,255,255,159,255,255,255,255,208,63,255,255,159,150,245,126,91,208,0,63,192,31,66,240,61,7,208,0,63,192,31,130,240,126,11,208,0,63,192,31,255,255,255,255,208,0,127,208,31,255,255,255,255,208,0,255,240,31,66,240,61,7,208,0,255,248,31,66,240,61,7,208,1,255,252,31,150,245,126,91,208,3,255,255,31,255,255,255,255,208,3,255,223,95,255,255,255,255,208,11,223,207,192,0,0,0,0,0,15,159,199,2,170,170,170,170,0,31,95,193,3,255,255,255,255,0,63,31,192,3,255,255,255,255,0,190,31,192,3,244,0,0,127,0,188,31,192,3,244,0,0,127,0,60,31,192,3,249,85,85,191,0,32,31,192,3,255,255,255,255,0,0,31,192,3,255,255,255,255,0,0,31,192,3,244,0,0,127,0,0,31,192,3,244,0,0,127,0,0,31,192,3,250,170,170,191,0,0,31,192,3,255,255,255,255,0,0,31,192,3,255,255,255,255,0,0,31,192,3,244,0,0,127,0,0,0,0,0,0,0,0,0,0,
  // 0x6a59  橙
  89,106,35,35,59,37,1,253,0,15,192,0,0,0,20,0,0,0,15,192,10,170,208,252,20,0,0,15,192,31,255,244,252,125,0,0,15,192,31,255,240,191,254,0,0,15,192,0,7,240,63,244,0,0,15,192,4,11,224,63,192,128,0,15,192,47,79,192,31,194,240,0,15,192,63,255,128,15,219,244,63,255,255,203,255,64,11,255,192,63,255,255,194,255,0,3,253,0,63,255,255,193,255,255,255,253,0,0,47,208,7,255,255,255,255,64,0,47,192,15,246,170,170,63,224,0,63,192,127,192,0,0,15,252,0,127,225,255,64,0,0,3,240,0,191,244,254,170,170,170,169,144,0,255,252,34,255,255,255,253,0,0,255,255,2,255,255,255,253,0,2,255,239,130,248,0,0,253,0,3,255,207,210,248,0,0,253,0,7,223,199,194,248,0,0,253,0,15,207,195,66,248,0,0,253,0,31,143,192,2,255,255,255,253,0,63,15,192,2,255,255,255,253,0,191,15,192,1,170,170,171,169,0,189,15,192,0,26,0,7,224,0,60,15,192,0,63,0,11,240,0,16,15,192,0,47,128,15,208,0,0,15,192,0,31,192,31,192,0,0,15,192,0,15,192,47,64,0,0,15,192,0,15,64,47,0,0,0,15,192,255,255,255,255,255,248,0,15,192,255,255,255,255,255,248,0,15,192,255,255,255,255,255,244,0,15,192,0,0,0,0,0,0,
  // 0x6a5f  機
  95,106,35,35,59,37,1,253,0,47,64,1,0,63,0,64,0,0,47,64,3,240,63,1,244,0,0,47,64,7,224,63,3,240,0,0,47,64,11,192,63,3,224,0,0,47,64,15,69,63,11,194,0,0,47,64,255,15,191,127,75,208,0,47,65,253,47,127,255,15,192,0,47,64,254,62,63,127,111,0,63,255,255,47,252,63,15,254,0,63,255,255,11,244,63,3,252,0,63,255,255,3,240,47,66,244,64,0,63,128,11,223,47,67,227,208,0,127,64,31,79,111,75,194,240,0,191,192,63,31,223,175,255,240,0,255,225,255,255,223,255,255,244,0,255,240,255,255,239,255,229,184,1,255,248,165,67,223,193,224,80,2,255,189,0,0,15,195,252,0,3,255,127,0,0,15,192,191,0,7,255,95,234,170,175,234,191,160,15,239,78,255,255,255,255,255,240,15,111,68,255,255,255,255,255,240,47,47,64,11,208,7,224,32,0,63,47,64,15,208,3,240,127,0,189,47,64,15,244,3,240,254,0,124,47,64,15,254,2,246,252,0,52,47,64,31,255,193,255,244,0,16,47,64,47,175,240,255,224,0,0,47,64,63,7,208,255,128,80,0,47,64,191,1,66,255,0,184,0,47,64,253,0,15,255,128,188,0,47,67,252,0,191,239,224,248,0,47,79,240,11,255,11,255,244,0,47,67,208,7,244,2,255,240,0,47,65,0,2,64,0,111,128,
  // 0x6aa2  檢
  162,106,35,36,68,37,1,252,0,15,192,0,0,47,192,0,0,0,15,192,0,0,127,240,0,0,0,15,192,0,0,255,248,0,0,0,15,192,0,3,254,254,0,0,0,15,192,0,11,244,191,128,0,0,15,192,0,47,224,63,224,0,0,15,192,0,191,192,15,252,0,0,15,192,3,255,0,3,255,64,63,255,255,223,252,0,0,255,224,63,255,255,255,255,255,255,255,252,63,255,255,255,159,255,255,215,240,0,47,192,61,10,170,170,128,224,0,63,192,16,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,240,15,255,248,191,255,192,0,191,244,15,255,248,191,255,192,0,255,252,15,149,248,189,91,192,0,255,255,15,128,248,188,7,192,2,255,239,79,128,248,188,7,192,3,255,207,207,128,248,188,7,192,7,223,203,207,149,248,189,91,192,15,207,195,79,255,248,191,255,192,31,143,193,15,255,248,191,255,192,63,15,192,0,16,0,1,0,0,127,15,192,0,63,0,3,240,0,125,15,192,0,127,0,7,224,0,60,15,192,0,190,0,11,208,0,16,15,192,0,253,0,15,208,0,0,15,192,2,255,64,47,244,0,0,15,192,7,255,208,63,253,0,0,15,192,15,235,244,255,255,128,0,15,192,63,194,247,252,63,224,0,15,193,255,0,159,244,11,248,0,15,192,253,0,11,208,2,240,0,15,192,48,0,2,0,0,128,0,0,0,0,0,0,0,0,0,
  // 0x6b62  止
  98,107,33,33,41,37,2,255,0,0,0,0,190,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,42,0,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,255,85,85,84,0,0,63,64,0,255,255,255,253,0,0,63,64,0,255,255,255,253,0,0,63,64,0,255,255,255,253,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,85,191,149,85,255,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x6b63  正
  99,107,33,32,32,37,2,254,21,85,85,85,85,85,85,85,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,21,0,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,254,85,85,80,0,0,63,64,1,255,255,255,244,0,0,63,64,1,255,255,255,244,0,0,63,64,1,255,255,255,244,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,85,85,85,85,85,85,64,
  // 0x6b65  步
  101,107,33,35,59,37,2,253,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,5,0,3,244,0,0,0,0,0,47,192,3,244,0,0,0,0,0,47,192,3,255,255,255,192,0,0,47,192,3,255,255,255,192,0,0,47,192,3,255,255,255,192,0,0,47,192,3,249,85,85,64,0,0,47,192,3,244,0,0,0,0,0,47,192,3,244,0,0,0,0,0,47,192,3,244,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,21,85,85,87,245,85,85,85,0,0,2,64,3,244,0,0,0,0,0,7,248,3,244,0,4,0,0,0,15,240,3,244,0,47,128,0,0,63,224,3,244,0,63,192,0,0,255,128,3,244,0,127,128,0,3,255,0,3,244,0,255,0,0,31,252,0,3,244,2,254,0,0,191,240,0,3,244,7,252,0,0,63,192,15,255,240,15,244,0,0,14,0,7,255,240,63,240,0,0,0,0,3,255,128,255,192,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,127,252,0,0,0,0,0,0,2,255,240,0,0,0,0,0,0,191,255,128,0,0,0,0,0,111,255,248,0,0,0,0,2,191,255,255,144,0,0,0,0,2,255,255,248,0,0,0,0,0,0,255,249,0,0,0,0,0,0,0,185,0,0,0,0,0,0,0,
  // 0x6b78  歸
  120,107,35,35,59,37,1,253,0,15,144,0,0,0,0,0,0,0,15,192,0,5,85,85,84,0,0,31,128,0,31,255,255,253,0,11,255,255,240,31,255,255,253,0,11,255,255,240,0,0,0,189,0,11,229,87,241,85,85,85,254,80,11,192,2,243,255,255,255,255,248,11,192,2,243,255,255,255,255,248,11,255,255,240,0,0,0,189,0,11,255,255,240,0,0,0,189,0,11,229,85,80,31,255,255,253,0,11,192,0,0,31,255,255,253,0,11,234,170,160,5,85,85,84,0,11,255,255,244,0,0,0,0,0,11,255,255,244,170,170,170,170,144,11,192,2,244,255,255,255,255,240,11,192,2,244,255,255,255,255,240,11,229,87,244,248,3,240,3,240,11,255,255,244,248,3,240,3,240,11,255,255,244,248,3,240,3,240,0,3,240,0,0,3,240,0,0,0,3,240,0,63,255,255,255,128,15,195,240,0,63,255,255,255,128,15,195,255,248,63,171,254,191,128,15,195,255,248,63,3,240,31,128,15,195,250,164,63,3,240,31,128,15,195,240,0,63,3,240,31,128,15,195,240,0,63,3,240,31,128,15,195,241,172,63,3,240,47,128,15,219,255,252,63,3,243,255,64,127,255,255,253,63,3,242,255,0,127,255,254,144,62,3,240,164,0,127,249,0,0,0,3,240,0,0,20,0,0,0,0,3,240,0,0,0,0,0,0,0,2,160,0,0,
  // 0x6bbc  殼
  188,107,34,36,68,37,2,252,0,7,224,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,3,255,255,224,0,255,255,255,255,67,255,255,224,0,255,255,255,255,67,255,255,224,0,170,171,250,170,3,240,11,224,0,0,7,240,0,3,240,11,224,0,0,7,240,0,3,240,11,224,0,63,255,255,252,3,240,11,225,0,63,255,255,252,7,240,11,225,224,21,85,85,84,11,224,11,226,240,0,0,0,0,15,208,11,226,240,255,255,255,255,127,192,7,255,224,255,255,255,255,255,64,3,255,208,253,85,85,127,190,0,0,170,0,252,0,0,47,24,0,0,0,0,252,0,0,47,0,0,0,0,0,254,255,255,239,47,255,255,254,0,2,255,255,192,47,255,255,254,0,0,0,0,0,47,255,255,253,0,0,0,0,0,2,224,1,252,0,2,170,170,144,3,240,3,248,0,3,255,255,208,3,248,7,244,0,3,255,255,208,1,252,15,240,0,3,240,11,208,0,255,47,208,0,3,240,11,208,0,127,191,128,0,3,240,11,208,0,47,255,0,0,7,240,11,209,64,15,252,0,0,11,224,11,255,192,47,253,0,0,15,208,47,255,192,255,255,128,0,47,192,127,254,11,255,191,244,0,127,128,63,145,255,248,31,255,128,255,0,20,11,255,208,3,255,208,60,0,0,3,253,0,0,127,128,0,0,0,1,208,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x6bd4  比
  212,107,34,35,59,37,2,253,0,106,0,0,6,144,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,124,0,0,191,0,0,15,224,3,255,0,0,191,85,85,15,224,47,255,64,0,191,255,254,15,226,255,248,0,0,191,255,254,15,255,255,128,0,0,191,255,254,15,255,248,0,0,0,191,0,0,15,255,128,0,0,0,191,0,0,15,244,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,7,128,0,191,0,0,15,224,0,11,240,0,191,0,27,143,224,0,11,224,0,191,27,255,143,224,0,11,224,0,255,255,255,207,240,0,15,208,175,255,255,254,75,240,0,31,192,255,255,254,64,7,255,255,255,192,255,254,64,0,3,255,255,255,64,190,64,0,0,1,255,255,254,0,0,0,0,0,0,5,85,64,0,
  // 0x6c92  沒
  146,108,33,35,59,37,2,253,1,0,0,0,164,0,0,0,0,7,208,0,1,253,0,0,0,0,15,253,0,1,252,0,0,0,0,15,255,128,2,252,0,0,0,0,1,255,240,3,255,255,255,253,0,0,47,224,3,255,255,255,252,0,0,3,192,7,255,255,255,252,0,0,0,0,15,240,0,1,252,0,0,0,0,15,224,0,1,252,0,0,0,0,47,208,0,2,252,0,16,0,0,63,192,0,2,248,0,125,0,0,191,64,0,3,248,0,255,208,1,255,0,0,7,244,0,191,253,7,252,0,47,255,240,0,11,255,31,248,0,31,255,224,0,0,253,11,240,0,15,255,64,0,0,44,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,255,255,248,0,0,0,1,255,255,255,255,252,0,0,1,1,255,255,255,255,248,0,0,7,128,7,224,0,11,244,0,0,15,224,11,244,0,31,224,0,0,31,208,3,252,0,63,192,0,0,63,192,1,255,0,255,64,0,0,127,64,0,191,195,254,0,0,0,255,0,0,47,255,252,0,0,2,253,0,0,15,255,240,0,0,3,252,0,0,7,255,208,0,0,11,244,0,0,127,255,253,0,0,31,240,0,27,255,255,255,208,0,63,208,27,255,255,66,255,255,128,63,128,47,255,244,0,47,255,192,11,0,15,254,0,0,2,255,64,0,0,6,64,0,0,0,26,0,
  // 0x6d88  消
  136,109,33,36,68,37,2,252,1,0,0,0,0,253,0,0,0,11,128,0,32,0,253,0,40,0,31,248,2,248,0,253,0,63,64,15,255,2,252,0,253,0,191,0,1,255,208,255,0,253,0,254,0,0,63,192,127,64,253,2,252,0,0,11,64,63,192,253,3,248,0,0,1,0,31,208,253,11,240,0,0,0,0,15,128,253,11,208,0,0,0,0,4,0,253,0,64,0,16,0,0,0,0,254,0,0,0,125,0,0,255,255,255,255,252,0,255,192,0,255,255,255,255,252,0,191,244,0,255,255,255,255,252,0,15,254,0,253,0,0,0,252,0,2,254,0,253,0,0,0,252,0,0,188,0,253,0,0,0,252,0,0,20,0,253,0,0,0,252,0,0,0,0,255,255,255,255,252,0,0,0,0,255,255,255,255,252,0,0,0,0,255,255,255,255,252,0,0,11,0,253,0,0,0,252,0,0,15,192,253,0,0,0,252,0,0,47,192,253,0,0,0,252,0,0,63,64,255,255,255,255,252,0,0,191,0,255,255,255,255,252,0,0,254,0,255,255,255,255,252,0,2,252,0,253,0,0,0,252,0,3,248,0,253,0,0,0,252,0,11,240,0,253,0,0,0,252,0,31,224,0,253,0,0,0,252,0,63,208,0,253,0,0,1,252,0,127,192,0,253,0,3,255,252,0,31,64,0,253,0,2,255,248,0,2,0,0,253,0,1,255,208,0,0,0,0,0,0,0,0,0,0,
  // 0x6de1  淡
  225,109,35,34,50,37,1,253,0,0,0,0,0,127,0,0,0,1,224,0,0,0,127,0,0,0,7,254,0,6,64,127,0,36,0,3,255,208,15,192,127,0,63,128,0,127,248,31,192,191,0,191,0,0,11,244,63,128,190,1,253,0,0,1,208,127,0,254,3,252,0,0,0,0,254,0,253,7,240,0,0,0,1,252,1,254,15,208,0,0,0,0,36,3,255,209,64,0,4,0,0,0,7,255,252,0,0,31,64,0,0,31,251,255,128,0,127,244,0,0,191,208,191,244,0,47,254,0,7,255,128,31,255,0,2,255,193,255,253,0,2,255,192,0,127,2,255,224,106,0,63,192,0,13,0,254,0,127,0,11,0,0,0,0,0,0,191,0,0,0,0,0,0,9,0,191,0,25,0,0,1,0,31,192,190,0,63,192,0,3,128,47,128,254,0,127,128,0,11,240,63,64,255,0,255,0,0,15,224,191,0,255,66,253,0,0,47,192,254,1,255,131,248,0,0,63,195,252,3,255,207,240,0,0,191,66,244,3,255,246,192,0,0,255,0,16,15,247,248,0,0,2,253,0,0,47,226,254,0,0,7,252,0,0,255,192,255,128,0,15,244,0,27,255,0,63,244,0,31,240,6,255,252,0,15,255,144,15,208,31,255,224,0,2,255,244,2,128,11,254,0,0,0,127,224,0,0,3,144,0,0,0,1,128,
  // 0x6e05  清
  5,110,34,36,68,37,2,252,2,0,0,0,1,252,0,0,0,15,224,0,0,1,252,0,0,0,31,254,1,85,86,253,85,85,0,7,255,195,255,255,255,255,255,64,0,191,211,255,255,255,255,255,64,0,31,192,0,1,252,0,0,0,0,3,64,0,1,252,0,0,0,0,0,1,255,255,255,255,253,0,0,0,1,255,255,255,255,253,0,0,0,0,85,86,253,85,84,0,16,0,0,0,1,252,0,0,0,125,0,10,170,170,254,170,170,144,255,224,31,255,255,255,255,255,224,191,253,31,255,255,255,255,255,224,11,255,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,0,40,0,63,255,255,255,248,0,0,0,0,63,255,255,255,248,0,0,0,0,63,170,170,171,248,0,0,0,0,63,0,0,2,248,0,0,1,0,63,0,0,2,248,0,0,11,128,63,255,255,255,248,0,0,15,208,63,255,255,255,248,0,0,47,192,63,85,85,86,248,0,0,63,128,63,0,0,2,248,0,0,191,0,63,85,85,86,248,0,0,254,0,63,255,255,255,248,0,2,252,0,63,255,255,255,248,0,7,248,0,63,0,0,2,248,0,15,240,0,63,0,0,2,248,0,31,224,0,63,0,0,2,248,0,63,192,0,63,0,0,2,248,0,63,128,0,63,0,3,255,248,0,15,0,0,63,0,2,255,244,0,1,0,0,63,0,1,255,144,0,0,0,0,0,0,0,0,0,0,
  // 0x6e2c  測
  44,110,33,36,68,37,1,252,0,64,0,0,0,0,0,15,192,3,224,0,0,0,0,0,15,192,11,254,7,255,255,208,0,15,192,3,255,199,255,255,208,0,15,192,0,127,215,255,255,208,248,15,192,0,15,135,208,11,208,252,15,192,0,2,7,208,11,208,252,15,192,0,0,7,208,11,208,252,15,192,0,0,7,208,11,208,252,15,192,0,0,7,255,255,208,252,15,192,4,0,7,255,255,208,252,15,192,47,128,7,255,255,208,252,15,192,127,248,7,208,11,208,252,15,192,47,255,7,208,11,208,252,15,192,2,255,7,208,11,208,252,15,192,0,124,7,208,11,208,252,15,192,0,4,7,255,255,208,252,15,192,0,0,7,255,255,208,252,15,192,0,0,7,255,255,208,252,15,192,0,0,7,208,11,208,252,15,192,0,0,7,208,11,208,252,15,192,0,30,7,208,11,208,252,15,192,0,47,135,208,11,208,252,15,192,0,63,71,255,255,208,252,15,192,0,127,7,255,255,208,252,15,192,0,254,7,255,255,208,248,15,192,0,253,0,0,1,0,0,15,192,2,252,2,248,31,64,0,15,192,3,248,3,244,47,192,0,15,192,7,240,11,240,15,240,0,15,192,15,240,31,208,3,248,0,15,192,31,208,63,192,2,252,16,31,192,47,192,255,0,0,248,63,255,192,7,129,253,0,0,80,47,255,128,0,0,52,0,0,0,31,249,0,0,0,0,0,0,0,0,0,0,
  // 0x6e90  源
  144,110,34,35,59,37,2,253,1,0,0,0,0,0,0,0,0,11,208,0,0,0,0,0,0,0,31,252,11,255,255,255,255,255,192,11,255,75,255,255,255,255,255,192,1,255,203,255,255,255,255,255,192,0,47,75,240,0,31,224,0,0,0,10,11,240,0,31,208,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,128,0,0,0,0,11,241,255,255,255,255,0,16,0,11,241,255,255,255,255,0,125,0,11,241,254,170,170,191,0,255,208,11,241,248,0,0,127,0,191,252,11,241,248,0,0,127,0,11,252,11,225,255,255,255,255,0,0,244,11,225,255,255,255,255,0,0,16,11,225,253,85,85,191,0,0,0,11,225,248,0,0,127,0,0,0,15,225,248,0,0,127,0,0,0,15,209,254,170,170,191,0,0,16,15,209,255,255,255,255,0,0,61,15,193,255,255,255,255,0,0,127,15,192,0,15,192,0,0,0,254,31,192,0,15,192,16,0,1,253,47,192,184,15,193,248,0,2,252,63,128,253,15,194,252,0,3,248,63,66,252,15,192,254,0,11,240,127,3,244,15,192,191,64,15,240,255,11,240,15,192,63,192,31,208,253,31,208,15,192,31,208,63,194,252,63,128,15,192,15,224,127,67,248,63,0,15,192,11,144,191,11,240,5,15,255,192,0,0,30,7,224,0,15,255,128,0,0,0,0,128,0,7,249,0,0,0,
  // 0x6e96  準
  150,110,33,35,59,37,2,253,0,128,0,14,64,10,64,0,0,3,248,0,31,208,31,224,0,0,11,255,128,63,192,47,192,0,0,1,255,224,191,64,63,64,0,0,0,31,192,255,170,255,170,169,0,0,2,3,255,255,255,255,254,0,16,0,15,255,255,255,255,254,0,126,0,47,252,0,190,0,0,0,255,224,191,252,0,190,0,0,0,127,254,255,254,170,255,170,160,0,7,244,254,255,255,255,255,244,0,0,96,53,255,255,255,255,244,0,0,0,1,252,0,190,0,0,0,0,3,129,252,0,190,0,0,0,0,15,209,255,255,255,255,244,0,0,63,193,255,255,255,255,244,0,0,255,65,254,170,255,170,160,0,2,253,1,252,0,190,0,0,0,11,248,1,252,0,190,0,0,0,63,240,1,255,255,255,255,255,64,63,192,1,255,255,255,255,255,64,31,0,0,170,170,170,170,170,64,4,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,
  // 0x6eab  溫
  171,110,34,35,59,37,2,253,1,0,0,0,0,0,0,0,0,11,208,0,0,0,0,0,0,0,15,252,0,255,255,255,255,240,0,15,255,64,255,255,255,255,240,0,1,255,208,254,170,170,175,240,0,0,47,128,252,0,224,11,240,0,0,7,0,252,1,240,11,240,0,0,0,0,252,3,224,11,240,0,0,0,0,252,3,240,11,240,0,0,0,0,252,15,253,11,240,0,16,0,0,252,47,47,75,240,0,126,0,0,253,253,11,219,240,0,255,224,0,252,244,2,203,240,0,191,252,0,252,0,0,11,240,0,11,253,0,255,255,255,255,240,0,1,248,0,255,255,255,255,240,0,0,32,0,170,170,170,170,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,255,255,255,255,252,0,0,8,7,255,255,255,255,252,0,0,47,7,255,255,255,255,252,0,0,63,135,240,125,11,192,252,0,0,127,71,240,125,11,192,252,0,0,255,7,240,125,11,192,252,0,1,253,7,240,125,11,192,252,0,2,252,7,240,125,11,192,252,0,3,248,7,240,125,11,192,252,0,11,240,7,240,125,11,192,252,0,15,224,7,240,125,11,192,252,0,47,208,7,240,125,11,192,252,0,127,193,255,255,255,255,255,255,224,191,65,255,255,255,255,255,255,224,31,1,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x6fc0  激
  192,111,34,36,68,37,2,252,0,0,0,46,64,2,228,0,0,15,128,0,63,192,2,248,0,0,47,244,0,63,64,3,244,0,0,31,254,0,127,0,3,240,0,0,3,255,127,255,255,131,240,0,0,0,127,63,255,255,135,240,0,0,0,28,63,85,111,139,224,0,0,0,0,63,0,31,143,255,255,224,0,0,63,85,111,143,255,255,224,0,0,63,255,255,159,255,255,224,0,0,63,255,255,175,192,127,0,125,0,63,0,31,191,192,126,0,255,128,63,0,31,255,192,190,0,255,244,63,85,111,255,192,189,0,31,252,63,255,255,255,208,253,0,2,244,63,255,255,255,208,252,0,0,96,0,63,64,247,224,252,0,0,0,0,63,64,114,241,252,0,0,0,0,63,64,1,242,248,0,0,1,255,255,255,241,247,244,0,0,1,255,255,255,240,251,240,0,0,53,255,255,255,224,255,240,0,0,190,2,244,0,0,127,224,0,0,254,2,244,0,0,63,208,0,1,252,2,255,255,64,63,192,0,3,252,3,255,255,64,63,128,0,3,244,3,255,255,64,127,192,0,11,240,7,240,63,64,255,240,0,15,224,11,224,63,2,255,244,0,31,208,15,192,63,7,246,252,0,63,192,63,128,63,31,240,255,0,127,64,191,0,127,127,192,127,192,191,2,253,47,255,255,64,47,224,46,7,248,31,253,253,0,11,192,0,1,208,10,144,48,0,2,0,0,0,0,0,0,0,0,0,0,
  // 0x7121  無
  33,113,34,35,59,37,2,253,0,3,144,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,255,255,255,255,255,254,0,1,255,255,255,255,255,255,254,0,7,255,255,255,255,255,255,254,0,31,255,65,248,15,192,127,0,0,191,255,1,248,15,192,63,0,0,255,191,1,248,15,192,63,0,0,62,63,1,248,15,192,63,0,0,8,63,1,248,15,192,63,0,0,0,63,1,248,15,192,63,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,63,65,248,15,192,127,0,0,0,63,1,248,15,192,63,0,0,0,63,1,248,15,192,63,0,0,0,63,1,248,15,192,63,0,0,0,63,1,248,15,192,63,0,0,0,63,1,248,15,192,63,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,144,0,0,0,0,1,128,0,1,253,2,160,10,208,31,224,0,2,252,3,240,11,240,15,244,0,3,244,3,240,7,240,3,252,0,15,240,3,244,3,248,1,254,0,31,224,3,248,2,252,0,255,64,127,192,3,248,1,252,0,127,192,255,64,2,248,0,253,0,47,208,29,0,1,64,0,144,0,13,0,
  // 0x71b1  熱
  177,113,34,35,59,37,2,253,0,3,224,0,0,63,0,0,0,0,3,240,0,0,63,0,0,0,5,87,245,84,0,63,0,0,0,31,255,255,252,0,63,0,0,0,31,255,255,252,0,63,0,0,0,0,3,240,0,63,255,255,240,0,0,3,240,0,63,255,255,240,0,85,91,245,85,63,255,255,240,0,191,255,255,255,64,126,7,240,0,191,255,255,255,64,126,7,240,0,0,252,31,0,0,189,7,240,0,0,248,31,6,24,189,7,240,0,3,240,31,79,191,253,7,240,0,111,224,31,255,191,252,7,240,0,255,66,155,254,31,253,7,240,0,56,3,240,0,3,255,71,240,0,0,3,240,0,1,255,215,240,0,63,255,255,253,3,255,251,240,64,63,255,255,253,3,247,247,240,240,26,171,250,168,7,240,215,240,240,0,3,240,0,15,208,7,241,240,0,3,240,5,47,192,7,241,240,1,91,255,255,191,64,7,242,240,255,255,255,255,255,0,7,255,224,255,255,255,165,252,0,3,255,208,186,148,0,0,112,0,0,170,64,0,0,0,0,0,0,0,0,0,0,228,0,0,0,64,6,192,0,2,252,7,240,15,208,31,240,0,3,248,7,240,11,240,11,248,0,11,240,3,240,3,244,3,253,0,31,224,3,244,3,248,0,255,0,63,192,3,244,2,252,0,191,128,255,64,3,248,1,252,0,63,192,25,0,1,64,0,64,0,25,0,
  // 0x71c8  燈
  200,113,35,35,59,37,1,253,0,10,64,0,0,6,208,16,0,0,15,192,10,170,147,240,184,0,0,15,192,15,255,247,242,252,0,0,15,192,15,255,241,255,240,0,0,15,192,0,3,224,255,128,0,0,15,194,5,11,208,191,3,208,0,15,199,255,143,192,63,79,240,5,15,203,239,255,64,31,255,128,15,79,207,195,255,0,15,253,0,15,79,239,65,253,0,3,252,0,15,79,254,3,255,255,255,255,0,15,15,252,15,255,255,255,191,208,31,15,212,127,207,255,255,47,248,47,15,195,255,0,0,0,11,248,62,31,195,248,0,0,0,1,240,61,31,193,210,170,170,170,168,0,188,31,192,3,255,255,255,252,0,4,31,128,3,255,255,255,252,0,0,31,128,3,240,0,0,252,0,0,47,128,3,240,0,0,252,0,0,47,64,3,240,0,0,252,0,0,63,128,3,240,0,0,252,0,0,63,208,3,255,255,255,252,0,0,63,240,3,255,255,255,252,0,0,127,252,2,170,170,170,168,0,0,190,254,0,29,0,11,144,0,0,252,127,64,127,0,15,208,0,2,252,63,192,63,64,31,192,0,3,248,15,192,31,128,47,128,0,11,240,11,64,15,192,63,0,0,15,224,1,0,15,64,46,0,0,63,192,0,255,255,255,255,255,240,127,64,0,255,255,255,255,255,240,46,0,0,255,255,255,255,255,240,8,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,32,36,32,37,1,252,0,0,0,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,234,170,171,254,170,170,0,31,255,255,255,255,255,255,0,31,255,255,255,255,255,255,0,31,255,255,255,255,255,255,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,234,170,170,171,252,0,0,127,64,0,0,2,252,0,0,191,0,0,0,2,252,0,0,255,0,0,0,2,252,0,0,254,0,0,0,2,252,0,2,253,0,0,0,2,252,0,3,252,0,0,0,2,252,0,11,248,0,0,0,2,252,0,31,240,0,0,0,2,252,0,63,224,0,0,0,2,252,0,127,192,0,0,0,2,252,0,31,64,0,0,0,2,252,0,6,0,0,0,0,2,252,0,0,0,0,0,0,0,0,0,
  // 0x7269  物
  105,114,34,35,59,37,1,253,0,3,244,0,11,128,0,0,0,0,3,244,0,15,208,0,0,0,6,67,244,0,15,192,0,0,0,11,211,244,0,31,192,0,0,0,15,195,244,0,47,64,0,0,0,15,195,244,0,63,0,0,0,0,15,195,244,0,127,255,255,255,240,15,195,244,0,255,255,255,255,240,31,255,255,225,255,255,255,255,240,31,255,255,227,248,47,71,247,240,47,255,255,231,240,63,11,211,240,63,3,244,15,224,126,15,199,240,63,3,244,47,192,189,15,199,240,190,3,244,127,128,252,31,135,240,188,3,244,127,2,248,47,135,240,44,3,244,13,3,240,63,71,240,0,3,244,0,7,240,63,11,224,0,3,250,244,15,208,190,11,224,0,3,255,244,47,192,253,11,224,0,111,255,248,63,65,252,15,208,27,255,255,144,255,3,248,15,208,127,255,244,2,252,3,240,15,208,63,251,244,7,248,11,240,15,208,61,3,244,31,240,15,208,15,192,0,3,244,47,192,47,192,15,192,0,3,244,3,0,127,64,31,192,0,3,244,0,0,255,0,47,192,0,3,244,0,2,253,0,47,128,0,3,244,0,7,248,0,63,128,0,3,244,0,31,240,0,127,64,0,3,244,0,127,192,0,255,0,0,3,244,1,255,65,255,255,0,0,3,244,0,189,0,255,252,0,0,3,244,0,36,0,255,244,0,0,3,244,0,0,0,20,0,0,
  // 0x7387  率
  135,115,33,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,0,0,0,47,192,0,0,0,0,1,0,0,63,64,0,0,224,0,15,192,0,254,2,64,3,253,0,47,248,10,252,7,240,15,248,0,7,255,47,240,15,208,63,208,0,0,255,239,240,63,129,255,64,0,0,47,7,253,190,0,188,0,0,0,4,0,255,252,0,0,0,0,0,0,0,63,242,208,0,0,0,0,1,128,31,199,240,244,0,0,0,31,208,63,2,255,255,64,0,2,255,224,253,85,254,255,224,0,127,255,191,255,255,255,31,253,0,191,228,127,255,255,255,130,255,128,62,0,63,170,164,15,192,127,64,16,0,0,7,240,10,0,28,0,0,0,0,7,240,0,0,0,0,0,0,0,7,244,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7528  用
  40,117,32,34,16,37,1,252,0,21,85,85,85,85,85,85,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,254,0,0,191,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,191,255,255,255,255,255,255,0,191,255,255,255,255,255,255,0,255,255,255,255,255,255,255,0,254,85,85,254,85,85,191,0,253,0,0,253,0,0,191,1,252,0,0,253,0,0,191,2,252,0,0,253,0,0,191,3,248,0,0,253,0,0,191,3,244,0,0,253,0,0,191,11,240,0,0,253,0,0,191,15,240,0,0,253,0,0,191,47,208,0,0,253,5,65,255,127,192,0,0,253,11,255,254,127,64,0,0,253,7,255,252,14,0,0,0,189,3,255,224,0,0,0,0,0,0,0,0,
  // 0x754c  界
  76,117,33,35,59,37,2,252,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,252,0,7,240,0,15,208,0,0,252,0,7,240,0,15,208,0,0,252,0,7,240,0,15,208,0,0,252,0,7,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,254,170,175,250,170,175,208,0,0,252,0,7,240,0,15,208,0,0,252,0,7,240,0,15,208,0,0,252,0,7,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,0,31,240,2,254,0,0,0,0,0,191,192,0,255,128,0,0,0,3,255,64,0,63,244,0,0,0,47,252,0,0,11,255,64,0,2,255,245,64,0,43,255,248,0,111,255,175,192,0,63,111,255,192,255,248,47,192,0,63,71,255,128,63,208,47,192,0,63,64,127,0,24,0,63,128,0,63,64,0,0,0,0,63,128,0,63,64,0,0,0,0,127,64,0,63,64,0,0,0,0,255,0,0,63,64,0,0,0,3,254,0,0,63,64,0,0,0,15,252,0,0,63,64,0,0,0,191,244,0,0,63,64,0,0,7,255,208,0,0,63,64,0,0,2,255,0,0,0,63,64,0,0,0,244,0,0,0,63,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x767d  白
  125,118,27,36,252,37,5,252,0,0,3,228,0,0,0,0,0,7,252,0,0,0,0,0,11,248,0,0,0,0,0,15,240,0,0,0,0,0,31,240,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,85,85,85,85,87,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,254,85,85,85,85,87,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,85,85,85,85,87,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,0,0,0,0,0,0,0,
  // 0x7684  的
  132,118,32,35,24,37,3,253,0,30,128,0,7,144,0,0,0,47,192,0,11,240,0,0,0,63,128,0,15,224,0,0,0,63,64,0,15,208,0,0,0,127,0,0,31,192,0,0,0,190,0,0,63,192,0,0,255,255,255,208,63,255,255,253,255,255,255,208,191,255,255,253,255,255,255,208,255,255,255,253,253,0,15,209,253,0,0,253,253,0,15,211,248,0,0,253,253,0,15,219,240,0,0,252,253,0,15,239,224,0,0,252,253,0,15,239,192,0,0,252,253,0,15,210,66,0,0,252,253,0,15,208,31,128,0,252,255,255,255,208,31,208,0,252,255,255,255,208,11,240,0,252,255,255,255,208,3,252,0,252,253,0,15,208,1,254,1,252,253,0,15,208,0,191,1,252,253,0,15,208,0,63,193,252,253,0,15,208,0,47,194,248,253,0,15,208,0,15,66,248,253,0,15,208,0,4,2,248,253,0,15,208,0,0,3,248,253,0,15,208,0,0,3,244,253,0,15,208,0,0,3,244,255,255,255,208,0,0,7,240,255,255,255,208,0,0,11,240,255,255,255,208,0,0,31,224,253,0,0,0,2,255,255,208,253,0,0,0,0,255,255,192,253,0,0,0,0,255,254,0,0,0,0,0,0,0,0,0,
  // 0x76e3  監
  227,118,33,34,50,37,2,254,0,0,0,0,0,57,0,0,0,42,170,170,170,64,127,0,0,0,63,255,255,255,128,190,0,0,0,63,255,255,255,128,252,0,0,0,63,0,248,0,1,252,0,0,0,63,0,248,0,2,248,0,0,0,63,85,253,85,3,255,255,255,128,63,255,255,255,7,255,255,255,128,63,255,255,255,15,255,255,255,128,63,0,0,63,47,192,0,0,0,63,0,0,63,127,64,0,0,0,63,85,85,127,191,0,0,0,0,63,255,255,255,28,0,0,0,0,63,255,255,255,0,0,0,0,0,63,0,248,0,0,0,0,0,0,63,0,248,0,2,255,255,255,0,63,0,248,0,2,255,255,255,0,63,255,255,255,194,255,255,255,0,63,255,255,255,192,0,0,0,0,42,170,170,170,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,255,171,254,175,250,191,208,0,0,252,3,244,7,224,15,208,0,0,252,3,244,7,224,15,208,0,0,252,3,244,7,224,15,208,0,0,252,3,244,7,224,15,208,0,0,252,3,244,7,224,15,208,0,0,252,3,244,7,224,15,208,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x76f4  直
  244,118,33,35,59,37,2,253,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,7,244,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,26,175,250,170,170,64,0,5,80,63,255,255,255,255,128,0,15,224,63,255,255,255,255,128,0,15,224,63,64,0,0,47,128,0,15,224,63,64,0,0,47,128,0,15,224,63,149,85,85,127,128,0,15,224,63,255,255,255,255,128,0,15,224,63,255,255,255,255,128,0,15,224,63,64,0,0,47,128,0,15,224,63,64,0,0,47,128,0,15,224,63,149,85,85,127,128,0,15,224,63,255,255,255,255,128,0,15,224,63,255,255,255,255,128,0,15,224,63,64,0,0,47,128,0,15,224,63,64,0,0,47,128,0,15,224,63,170,170,170,191,128,0,15,224,63,255,255,255,255,128,0,15,224,63,255,255,255,255,128,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,
  // 0x7720  眠
  32,119,34,33,41,37,2,253,127,255,253,11,255,255,255,255,64,127,255,253,11,255,255,255,255,64,127,255,253,11,255,255,255,255,64,127,0,189,11,224,0,0,63,64,127,0,189,11,224,0,0,63,64,127,0,189,11,224,0,0,63,64,127,0,189,11,224,0,0,63,64,127,0,189,11,240,0,0,63,64,127,255,253,11,255,255,255,255,64,127,255,253,11,255,255,255,255,64,127,255,253,11,255,255,255,255,64,127,0,189,11,224,7,240,0,0,127,0,189,11,224,3,240,0,0,127,0,189,11,224,3,240,0,0,127,0,189,11,224,3,240,0,0,127,0,189,11,240,7,244,0,0,127,255,253,11,255,255,255,255,208,127,255,253,11,255,255,255,255,208,127,255,253,11,255,255,255,255,208,127,0,189,11,224,2,248,0,0,127,0,189,11,224,1,252,0,0,127,0,189,11,224,1,252,0,0,127,0,189,11,224,0,252,0,0,127,0,189,11,224,0,253,0,0,127,255,253,11,224,0,190,0,0,127,255,253,11,224,0,127,1,208,127,255,253,11,224,0,63,2,240,127,0,0,11,224,107,127,130,240,127,0,0,11,255,255,95,195,240,63,0,2,255,255,255,79,247,240,0,0,2,255,255,249,7,255,208,0,0,1,255,228,0,2,255,192,0,0,0,144,0,0,0,127,0,
  // 0x780d  砍
  13,120,35,35,59,37,1,253,0,0,0,0,15,144,0,0,0,0,0,0,0,15,208,0,0,0,63,255,255,253,31,208,0,0,0,63,255,255,253,31,192,0,0,0,63,255,255,253,47,192,0,0,0,0,63,64,0,63,192,0,0,0,0,63,0,0,63,128,0,1,0,0,127,0,0,127,255,255,255,244,0,126,0,0,191,255,255,255,244,0,190,0,0,255,255,255,255,240,0,253,0,0,253,15,208,11,224,0,252,0,2,252,15,208,15,208,1,252,0,3,248,15,208,15,192,2,255,255,251,244,15,208,31,192,3,255,255,255,240,15,208,47,128,7,255,255,255,208,15,208,63,64,11,248,3,247,192,15,208,63,0,15,248,3,240,0,15,208,5,0,47,248,3,240,0,31,224,0,0,63,248,3,240,0,47,240,0,0,191,248,3,240,0,63,240,0,0,191,248,3,240,0,63,244,0,0,62,248,3,240,0,190,252,0,0,21,248,3,240,0,252,252,0,0,1,248,3,240,2,252,191,0,0,1,248,3,240,3,244,63,64,0,1,255,255,240,15,240,47,192,0,1,255,255,240,47,208,15,240,0,1,255,255,240,191,128,11,252,0,1,248,0,2,255,0,3,255,0,1,248,0,15,253,0,0,255,208,1,248,0,127,244,0,0,127,248,1,164,0,63,208,0,0,31,244,0,0,0,31,64,0,0,3,224,0,0,0,8,0,0,0,0,128,
  // 0x78ba  確
  186,120,35,35,59,37,1,253,0,0,0,0,0,6,144,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,15,208,0,0,63,255,255,240,0,31,192,0,0,63,255,255,255,255,255,255,255,244,63,255,255,255,255,255,255,255,244,0,63,0,15,255,255,255,255,244,0,127,0,15,192,254,0,3,244,0,127,0,15,193,252,11,147,244,0,190,0,15,195,248,15,211,244,0,253,0,10,75,240,31,193,160,0,252,0,0,15,208,47,64,0,1,252,0,0,63,255,255,255,208,2,252,0,0,191,255,255,255,208,3,255,255,210,255,255,255,255,208,3,255,255,219,255,0,253,0,0,11,255,255,255,255,0,253,0,0,15,244,11,223,255,0,253,0,0,31,244,11,210,127,170,254,170,64,63,244,11,208,127,255,255,255,192,127,244,11,208,127,255,255,255,192,255,244,11,208,127,0,253,0,0,191,244,11,208,127,0,253,0,0,61,244,11,208,127,0,253,0,0,17,244,11,208,127,170,254,170,64,1,244,11,208,127,255,255,255,192,1,244,11,208,127,255,255,255,192,1,255,255,208,127,0,253,0,0,1,255,255,208,127,0,253,0,0,1,255,255,208,127,0,253,0,0,1,244,0,0,127,255,255,255,244,1,244,0,0,127,255,255,255,244,1,244,0,0,127,255,255,255,244,0,0,0,0,127,0,0,0,0,0,0,0,0,126,0,0,0,0,
  // 0x79fb  移
  251,121,34,35,59,37,1,253,0,0,1,0,0,15,144,0,0,0,0,111,192,0,47,192,0,0,0,111,255,240,0,127,128,0,0,63,255,255,208,1,255,255,254,0,63,255,244,0,7,255,255,255,128,47,155,240,0,47,255,255,255,0,0,7,240,0,191,192,0,254,0,0,7,240,7,255,192,2,252,0,0,7,240,47,255,240,7,248,0,0,7,240,15,231,253,31,240,0,0,11,240,3,0,255,191,192,0,63,255,255,240,0,63,255,64,0,63,255,255,240,0,15,253,0,0,63,255,255,240,0,191,240,0,0,0,15,240,0,7,255,208,0,0,0,31,240,1,255,255,253,0,0,0,63,248,15,255,227,252,0,0,0,127,254,3,254,11,240,0,0,0,255,255,130,144,47,255,255,224,1,255,255,208,0,191,255,255,240,3,251,247,244,2,255,255,255,240,7,231,242,244,15,248,0,31,208,15,199,240,224,191,240,0,63,192,47,135,240,71,255,253,0,191,64,127,71,240,7,254,255,129,255,0,190,7,240,2,208,127,231,252,0,60,7,240,0,0,15,255,244,0,36,7,240,0,0,2,255,208,0,0,7,240,0,0,7,255,64,0,0,7,240,0,0,127,252,0,0,0,7,240,0,7,255,224,0,0,0,7,240,6,255,255,64,0,0,0,7,240,47,255,244,0,0,0,0,7,240,15,254,0,0,0,0,0,7,240,7,144,0,0,0,0,
  // 0x7a4d  積
  77,122,35,36,68,37,1,252,0,0,1,0,0,15,208,0,0,0,0,111,128,0,15,208,0,0,0,111,255,231,255,255,255,255,224,63,255,255,219,255,255,255,255,224,63,255,244,0,0,15,224,0,0,46,159,224,0,0,15,208,0,0,0,11,224,3,255,255,255,255,128,0,11,224,3,255,255,255,255,128,0,11,224,0,0,15,224,0,0,0,11,224,0,0,15,224,0,0,42,175,250,191,255,255,255,255,244,63,255,255,255,255,255,255,255,244,63,255,255,224,0,0,0,0,0,63,255,255,208,0,0,0,0,0,0,15,224,0,255,255,255,255,64,0,47,224,0,255,255,255,255,64,0,63,248,0,252,0,0,63,64,0,127,254,0,252,0,0,63,64,0,255,255,128,255,255,255,255,64,1,255,255,208,255,255,255,255,64,3,251,231,240,252,0,0,63,64,11,219,226,224,252,0,0,63,64,15,203,224,192,255,255,255,255,64,63,139,224,0,255,255,255,255,64,191,11,224,0,252,0,0,63,64,189,11,224,0,252,0,0,63,64,60,11,224,0,252,0,0,63,64,32,11,224,0,255,255,255,255,64,0,11,224,0,255,255,255,255,64,0,11,224,0,3,128,3,128,0,0,11,224,0,47,244,15,244,0,0,11,224,2,255,208,7,255,0,0,11,224,127,254,0,0,191,208,0,11,224,191,224,0,0,31,244,0,11,224,46,0,0,0,3,128,0,0,0,0,0,0,0,0,0,
  // 0x7aef  端
  239,122,35,35,59,37,1,253,0,5,0,0,0,15,192,0,0,0,47,64,0,0,15,192,0,0,0,47,64,11,224,15,192,15,192,0,47,64,11,224,15,192,15,192,0,47,64,11,224,15,192,15,192,0,47,64,11,224,15,192,15,192,0,47,64,11,224,15,192,15,192,0,47,64,11,224,15,192,15,192,63,255,255,139,255,255,255,255,192,63,255,255,139,255,255,255,255,192,63,255,255,139,255,255,255,255,192,0,0,0,0,0,0,0,0,0,6,0,57,0,0,0,0,0,0,31,64,127,0,0,0,0,0,0,15,128,126,63,255,255,255,255,244,15,128,189,63,255,255,255,255,244,15,192,189,63,255,255,255,255,244,11,192,252,0,0,47,192,0,0,11,192,252,0,0,63,192,0,0,7,208,252,0,0,63,64,0,0,7,209,248,15,255,255,255,255,224,3,225,244,15,255,255,255,255,224,3,226,240,15,255,255,255,255,224,3,211,240,15,193,244,63,7,224,0,3,246,223,193,244,63,7,224,0,7,255,223,193,244,63,7,224,27,255,255,239,193,244,63,7,224,191,255,254,79,193,244,63,7,224,127,254,64,15,193,244,63,7,224,62,64,0,15,193,244,63,7,224,0,0,0,15,193,244,63,7,224,0,0,0,15,193,244,63,7,224,0,0,0,15,193,244,63,111,224,0,0,0,15,193,244,63,127,208,0,0,0,10,128,80,0,63,64,
  // 0x7b49  等
  73,123,34,35,59,37,1,253,0,30,64,0,0,249,0,0,0,0,63,192,0,1,253,0,0,0,0,127,64,0,2,252,0,0,0,0,255,255,255,199,255,255,255,240,1,255,255,255,207,255,255,255,240,3,255,255,255,239,255,255,255,240,15,240,252,0,191,130,252,0,0,63,208,254,1,255,0,255,0,0,191,128,127,0,253,0,127,64,0,31,0,56,1,252,0,61,0,0,0,0,0,1,252,0,0,0,0,0,127,255,255,255,255,255,248,0,0,127,255,255,255,255,255,252,0,0,127,255,255,255,255,255,252,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,0,0,124,0,0,3,248,0,0,0,1,255,64,0,3,248,0,0,0,0,191,208,0,3,248,0,0,0,0,31,244,0,3,248,0,0,0,0,7,253,0,3,248,0,0,0,0,1,253,0,7,248,0,0,0,0,0,176,31,255,244,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,11,255,128,0,0,
  // 0x7ba1  管
  161,123,35,35,59,37,1,253,0,46,64,0,0,248,0,0,0,0,63,128,0,1,253,0,0,0,0,127,0,0,3,252,0,0,0,0,255,255,255,203,255,255,255,244,2,255,255,255,223,255,255,255,244,11,255,255,255,255,255,255,255,244,31,224,253,1,255,0,254,0,0,127,192,191,2,252,0,127,64,0,15,0,62,0,252,0,63,64,0,0,0,0,0,252,0,0,0,0,10,170,170,171,254,170,170,170,128,15,255,255,255,255,255,255,255,208,15,255,255,255,255,255,255,255,208,15,192,0,0,0,0,0,15,208,15,192,0,0,0,0,0,15,208,15,193,170,170,170,170,169,15,208,15,193,255,255,255,255,254,15,208,15,193,255,255,255,255,254,15,208,0,1,252,0,0,0,190,0,0,0,1,252,0,0,0,190,0,0,0,1,254,170,170,170,254,0,0,0,1,255,255,255,255,254,0,0,0,1,255,255,255,255,254,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,254,170,170,170,170,160,0,0,1,255,255,255,255,255,244,0,0,1,255,255,255,255,255,244,0,0,1,252,0,0,0,3,244,0,0,1,252,0,0,0,3,244,0,0,1,252,0,0,0,3,244,0,0,1,255,255,255,255,255,244,0,0,1,255,255,255,255,255,244,0,0,1,254,170,170,170,171,244,0,0,1,248,0,0,0,3,240,0,
  // 0x7bb1  箱
  177,123,34,35,59,37,1,253,0,30,0,0,0,228,0,0,0,0,47,192,0,0,254,0,0,0,0,63,128,0,1,252,0,0,0,0,127,64,0,3,252,0,0,0,0,255,255,255,199,255,255,255,240,1,255,255,255,207,255,255,255,240,3,255,255,255,239,255,255,255,240,11,244,253,0,127,194,252,0,0,31,224,191,0,255,0,255,0,0,127,192,63,2,253,0,63,64,0,47,64,62,0,116,0,46,64,0,5,1,252,0,0,0,0,0,0,0,1,252,0,47,255,255,255,192,0,1,252,0,47,255,255,255,192,0,2,252,0,47,255,255,255,192,47,255,255,255,111,128,0,47,192,47,255,255,255,111,128,0,47,192,47,255,255,255,111,128,0,47,192,0,7,252,0,47,234,170,191,192,0,15,253,0,47,255,255,255,192,0,31,255,64,47,255,255,255,192,0,63,255,208,47,128,0,47,192,0,127,255,244,47,128,0,47,192,0,255,254,254,47,128,0,47,192,2,253,252,255,111,234,170,191,192,7,245,252,63,47,255,255,255,192,31,225,252,28,47,255,255,255,192,63,193,252,0,47,128,0,47,192,127,65,252,0,47,128,0,47,192,46,1,252,0,47,128,0,47,192,8,1,252,0,47,255,255,255,192,0,1,252,0,47,255,255,255,192,0,1,252,0,47,255,255,255,192,0,1,252,0,47,128,0,47,192,0,1,252,0,26,64,0,21,64,
  // 0x7cfb  系
  251,124,35,35,59,37,1,253,0,0,0,0,0,0,0,64,0,0,0,0,0,0,21,191,240,0,0,1,85,170,255,255,255,248,0,11,255,255,255,255,255,255,252,0,7,255,255,255,255,255,165,0,0,3,255,255,255,212,0,0,0,0,0,0,0,255,64,1,0,0,0,0,0,3,254,0,11,208,0,0,0,0,15,248,0,47,240,0,0,0,24,63,224,0,191,208,0,0,0,127,255,128,2,255,64,0,0,0,255,254,0,11,253,0,0,0,0,47,253,0,47,240,0,0,0,0,3,255,128,255,192,0,0,0,0,0,191,247,255,0,32,0,0,0,0,47,255,248,2,253,0,0,0,0,7,255,208,1,255,64,0,0,0,1,255,64,0,127,224,0,0,0,7,252,0,0,31,248,0,0,0,47,255,255,255,255,254,0,63,255,255,255,255,255,255,255,128,63,255,255,255,255,255,255,255,208,47,255,255,255,254,85,0,31,244,5,85,0,1,252,0,0,11,224,0,0,80,1,252,0,96,2,64,0,1,254,1,252,2,252,0,0,0,3,254,1,252,7,255,64,0,0,15,252,1,252,0,255,208,0,0,127,240,1,252,0,63,248,0,1,255,192,1,252,0,11,254,0,11,255,0,1,252,0,2,255,192,127,252,0,1,252,0,0,191,240,47,224,0,1,252,0,0,31,208,7,64,0,1,252,0,0,11,0,0,0,0,1,252,0,0,0,0,
  // 0x7d05  紅
  5,125,35,35,59,37,1,253,0,3,64,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,63,65,64,255,255,255,255,240,0,254,3,244,255,255,255,255,240,30,252,11,244,255,255,255,255,240,63,244,15,224,85,87,249,85,80,63,240,63,192,0,3,248,0,0,11,248,191,64,0,3,248,0,0,2,254,254,0,0,3,248,0,0,0,191,248,0,0,3,248,0,0,0,47,240,180,0,3,248,0,0,0,47,193,252,0,3,248,0,0,0,127,64,254,0,3,248,0,0,0,254,0,127,64,3,248,0,0,191,255,255,255,192,3,248,0,0,127,255,255,255,208,3,248,0,0,127,255,255,255,240,3,248,0,0,16,2,248,3,240,3,248,0,0,0,2,248,1,64,3,248,0,0,0,2,248,4,0,3,248,0,0,7,226,248,252,0,3,248,0,0,11,226,248,190,0,3,248,0,0,15,210,248,63,0,3,248,0,0,15,194,248,63,64,3,248,0,0,31,194,248,31,192,3,248,0,0,47,130,248,15,192,3,248,0,0,63,66,248,15,208,3,248,0,0,127,2,248,10,64,3,248,0,0,126,2,248,7,255,255,255,255,248,4,2,248,7,255,255,255,255,248,0,2,248,7,255,255,255,255,248,0,2,248,1,85,85,85,85,80,0,2,164,0,0,0,0,0,0,
  // 0x7d22  索
  34,125,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,64,63,0,0,255,64,0,0,63,64,63,0,3,254,0,16,0,63,64,63,0,15,248,0,188,0,63,64,63,9,63,224,2,255,0,63,64,63,63,255,64,15,252,0,63,64,0,63,253,0,127,224,0,0,0,0,7,255,1,255,129,0,0,0,0,0,191,219,253,11,192,0,0,0,0,31,255,224,31,244,0,0,0,0,7,255,64,7,254,0,0,0,0,31,252,0,0,255,192,0,127,255,255,255,255,255,255,244,0,127,255,255,255,255,255,255,254,0,127,255,255,255,255,250,170,255,64,0,0,64,7,240,0,0,61,0,0,2,248,7,240,11,192,0,0,0,15,252,7,240,47,248,0,0,0,127,240,7,240,7,255,128,0,7,255,128,7,240,0,191,240,0,127,253,0,7,240,0,15,253,0,255,224,0,7,240,0,2,255,64,47,64,0,7,240,0,0,125,0,4,0,0,7,240,0,0,0,0,
  // 0x7d2b  紫
  43,125,34,35,59,37,1,253,0,0,63,0,3,244,0,0,0,0,0,63,0,3,244,0,0,0,0,0,63,0,3,244,0,24,0,3,240,63,0,3,244,1,254,0,3,240,63,255,211,244,111,255,128,3,240,63,255,211,255,255,253,0,3,240,63,255,211,255,254,64,0,3,240,63,0,3,254,64,0,0,3,240,63,0,3,244,0,2,0,3,240,63,0,83,244,0,3,240,3,240,127,255,227,248,0,7,240,27,255,255,255,227,255,255,255,240,127,255,255,255,65,255,255,255,208,127,255,164,31,144,127,255,255,64,41,64,0,127,192,0,0,0,0,0,0,1,255,0,30,0,0,0,0,7,75,252,0,191,208,0,0,0,31,255,224,2,255,64,0,0,0,47,255,128,15,252,0,0,0,0,2,255,224,127,224,40,0,0,0,0,47,254,255,65,255,0,0,0,0,7,255,252,0,191,192,0,0,0,0,255,208,0,31,244,0,63,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,208,21,64,0,1,253,0,0,15,240,0,0,16,1,252,0,16,7,128,0,1,254,1,252,2,253,0,0,0,11,254,1,252,7,255,128,0,0,127,244,1,252,0,127,244,0,7,255,192,1,252,0,11,255,0,47,254,0,1,252,0,1,255,208,11,240,0,1,252,0,0,47,128,2,64,0,1,252,0,0,5,0,
  // 0x7d30  細
  48,125,34,35,59,37,1,253,0,13,0,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,0,0,255,255,255,255,208,0,190,0,0,255,255,255,255,208,0,252,15,128,255,255,255,255,208,26,244,31,192,252,7,240,15,208,63,240,63,64,252,3,240,15,208,127,208,191,0,252,3,240,15,208,47,224,252,0,252,3,240,15,208,11,247,244,0,252,3,240,15,208,3,255,240,0,252,3,240,15,208,0,255,194,64,252,3,240,15,208,0,127,79,192,252,3,240,15,208,0,62,11,224,252,3,240,15,208,0,252,3,240,252,3,240,15,208,2,255,255,248,255,255,255,255,208,191,255,255,253,255,255,255,255,208,191,255,250,254,255,255,255,255,208,121,11,208,127,252,7,240,15,208,0,11,208,57,252,3,240,15,208,0,11,208,64,252,3,240,15,208,15,203,215,208,252,3,240,15,208,15,203,215,224,252,3,240,15,208,15,139,211,240,252,3,240,15,208,31,139,210,244,252,3,240,15,208,47,75,208,248,252,3,240,15,208,63,11,208,253,252,3,240,15,208,63,11,208,189,252,3,240,15,208,126,11,208,80,255,255,255,255,208,188,11,208,0,255,255,255,255,208,8,11,208,0,255,255,255,255,208,0,11,208,0,252,0,0,15,208,0,11,208,0,252,0,0,15,208,0,7,208,0,84,0,0,0,0,
  // 0x7d42  終
  66,125,35,36,68,37,1,252,0,9,0,0,0,169,0,0,0,0,31,192,0,0,253,0,0,0,0,63,128,0,2,252,0,0,0,0,63,0,0,3,244,0,0,0,0,189,0,0,15,255,255,253,0,0,252,15,64,31,255,255,255,0,6,244,63,128,127,255,255,254,0,63,240,127,0,255,128,1,252,0,127,192,253,3,255,208,3,248,0,47,209,252,15,255,240,11,240,0,11,247,240,63,211,248,47,208,0,3,255,208,47,64,254,127,128,0,0,255,133,9,0,127,255,0,0,0,127,47,0,0,47,252,0,0,0,125,15,128,0,47,252,0,0,0,248,11,192,1,255,255,64,0,3,250,255,224,11,255,191,224,0,191,255,255,240,191,248,31,253,0,191,255,255,251,255,192,7,255,224,127,255,208,255,254,0,0,191,248,0,15,192,147,224,61,0,31,240,4,15,193,65,0,255,208,1,192,15,207,207,192,0,127,252,0,0,15,207,203,208,0,7,255,128,0,31,143,195,224,0,0,191,192,0,31,79,195,240,0,0,15,0,0,47,79,194,244,0,0,0,0,0,63,15,193,248,63,144,0,0,0,63,15,192,228,191,253,0,0,0,190,15,192,0,111,255,224,0,0,252,15,192,0,1,191,255,64,0,24,15,192,0,0,11,255,244,0,0,15,192,0,0,0,127,254,0,0,15,192,0,0,0,7,252,0,0,15,192,0,0,0,0,116,0,0,0,0,0,0,0,0,0,0,
  // 0x7d71  統
  113,125,35,36,68,37,1,252,0,9,0,0,0,15,208,0,0,0,31,192,0,0,15,208,0,0,0,63,128,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,190,0,0,0,15,208,0,0,0,252,15,79,255,255,255,255,240,6,244,47,207,255,255,255,255,240,63,240,63,15,255,255,255,255,240,127,208,253,0,2,252,0,0,0,47,209,252,0,3,248,1,192,0,15,243,240,0,7,240,11,240,0,3,255,224,0,15,224,3,252,0,0,255,197,0,15,208,1,254,0,0,127,47,0,47,193,90,255,64,0,125,15,143,255,255,255,255,192,0,248,11,207,255,255,255,255,224,3,250,255,239,255,254,165,91,240,191,255,255,245,64,0,0,3,244,191,255,255,244,5,80,21,1,128,127,255,208,248,11,224,63,64,0,0,15,192,208,11,224,63,64,0,4,15,193,64,15,224,63,64,0,15,207,207,192,15,208,63,64,0,15,207,203,192,15,208,63,64,0,31,143,199,224,15,192,63,64,0,31,79,195,240,31,192,63,64,0,47,79,194,240,47,192,63,64,0,63,15,193,244,63,128,63,64,128,63,15,192,248,127,0,63,64,248,190,15,192,64,255,0,63,64,252,252,15,192,3,253,0,63,64,252,24,15,192,15,248,0,63,129,248,0,15,192,191,240,0,47,255,244,0,15,192,191,128,0,31,255,240,0,15,192,61,0,0,11,255,192,0,0,0,0,0,0,0,0,0,
  // 0x7d72  絲
  114,125,35,35,59,37,1,253,0,7,64,0,0,3,144,0,0,0,15,240,0,0,7,244,0,0,0,31,208,0,0,15,240,0,0,0,63,128,0,0,31,208,0,0,0,127,2,64,0,63,128,128,0,0,253,7,244,0,127,1,248,0,46,248,15,240,13,253,3,252,0,63,240,47,192,63,248,11,244,0,127,208,63,128,63,240,31,224,0,31,240,255,0,15,248,63,192,0,7,254,252,0,3,254,191,0,0,2,255,244,0,0,255,253,0,0,0,191,225,224,0,63,248,188,0,0,63,195,240,0,31,240,253,0,0,63,1,248,0,31,192,191,0,0,188,0,253,0,63,0,63,192,1,255,255,255,0,255,191,255,208,191,255,255,255,127,255,255,255,240,127,255,255,255,191,255,255,255,244,127,255,244,15,255,255,253,3,244,0,2,244,13,0,1,252,1,208,0,2,244,16,0,1,252,0,0,7,146,245,248,3,225,252,108,0,7,226,244,252,7,241,252,254,0,11,210,244,190,11,225,252,127,0,15,210,244,127,15,209,252,63,128,15,194,244,63,15,193,252,31,192,31,194,244,47,175,193,252,15,208,63,130,244,29,63,65,252,11,240,63,2,244,0,191,1,252,3,244,191,2,244,0,253,1,252,3,248,29,2,244,0,44,1,252,1,144,0,2,244,0,0,1,252,0,0,0,2,244,0,0,1,252,0,0,0,2,244,0,0,1,252,0,0,
  // 0x7da0  綠
  160,125,35,35,59,37,1,253,0,13,0,0,11,144,0,0,0,0,31,192,0,15,208,0,0,0,0,63,64,0,15,208,0,0,0,0,63,0,0,31,255,255,253,0,0,189,4,0,47,255,255,252,0,0,252,31,64,63,234,171,252,0,26,244,63,128,63,64,1,252,0,63,240,127,0,127,0,2,248,0,127,192,253,0,191,170,171,248,0,47,210,248,0,255,255,255,244,0,11,247,240,0,255,255,255,240,0,2,255,208,0,188,0,7,240,0,0,255,133,0,0,0,11,224,0,0,127,63,15,255,255,255,255,240,0,252,47,143,255,255,255,255,240,2,248,15,207,255,255,255,255,240,175,250,255,224,0,11,240,0,0,191,255,255,240,0,11,240,0,0,191,255,255,244,160,11,244,3,128,16,15,193,251,248,11,248,15,240,0,15,192,226,254,11,252,63,192,5,15,192,0,191,75,253,255,0,15,207,207,128,63,203,255,248,0,31,143,207,192,15,75,255,224,0,31,79,199,208,4,11,255,192,0,47,79,195,224,1,203,239,224,0,47,15,195,240,11,235,231,244,0,63,15,194,240,127,235,226,252,0,62,15,193,226,255,75,224,255,64,189,15,192,31,253,11,224,127,224,252,15,192,63,240,11,224,31,248,24,15,192,31,128,11,224,7,240,0,15,192,13,7,255,224,0,192,0,15,192,0,3,255,192,0,0,0,15,192,0,2,250,0,0,0,
  // 0x7db2  網
  178,125,34,35,59,37,1,253,0,9,0,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,63,128,15,255,255,255,255,224,0,63,0,15,255,255,255,255,224,0,190,0,15,255,255,255,255,224,0,252,31,79,208,0,0,11,224,6,244,63,143,209,128,10,75,224,63,240,127,15,211,208,15,203,224,127,208,253,15,210,240,31,75,224,63,193,252,15,209,240,47,11,224,15,243,240,15,208,244,61,11,224,3,255,208,15,208,224,60,11,224,1,255,193,15,219,255,255,203,224,0,191,63,15,219,255,255,203,224,0,189,47,79,214,175,234,139,224,2,248,15,207,208,15,192,11,224,175,250,255,223,208,15,192,11,224,191,255,255,255,208,15,192,11,224,191,255,255,255,219,255,255,219,224,16,15,193,255,219,255,255,219,224,0,15,192,239,215,254,170,139,224,0,15,192,15,209,248,0,11,224,15,143,207,143,209,248,0,11,224,15,143,207,207,209,248,0,11,224,31,79,199,223,209,248,0,11,224,47,79,195,239,209,248,0,11,224,47,15,195,255,208,255,171,139,224,63,15,194,255,208,255,255,203,224,62,15,193,223,208,63,255,203,224,189,15,192,15,208,0,0,11,224,252,15,192,15,208,0,0,11,224,24,15,192,15,208,0,0,11,208,0,15,192,15,208,0,15,255,208,0,15,192,15,208,0,7,255,192,0,15,192,15,208,0,3,254,0,
  // 0x7dd2  緒
  210,125,35,35,59,37,1,253,0,9,0,0,0,253,0,0,0,0,31,192,0,0,253,0,7,144,0,63,128,0,0,253,0,15,224,0,63,0,0,0,253,0,31,192,0,190,0,7,255,255,255,127,128,0,252,14,7,255,255,255,191,0,6,244,63,135,255,255,255,254,0,63,240,127,0,0,253,2,252,0,127,192,253,0,0,253,7,244,0,47,210,248,0,0,253,15,240,0,11,247,240,0,0,253,47,208,0,3,255,208,47,255,255,255,255,244,0,255,138,47,255,255,255,255,244,0,127,63,47,255,255,255,255,244,0,252,31,128,0,47,240,0,0,2,248,15,192,0,191,192,0,0,175,250,255,224,2,254,0,0,0,191,255,255,240,15,255,255,255,0,191,255,255,244,191,255,255,255,0,16,15,193,255,255,255,255,255,0,0,15,192,255,255,64,0,63,0,4,15,192,127,255,64,0,63,0,15,207,207,142,63,64,0,63,0,15,143,207,192,63,64,0,63,0,31,79,199,208,63,255,255,255,0,47,79,195,224,63,255,255,255,0,47,15,195,240,63,255,255,255,0,63,15,194,240,63,64,0,63,0,126,15,193,224,63,64,0,63,0,189,15,192,0,63,64,0,63,0,188,15,192,0,63,255,255,255,0,4,15,192,0,63,255,255,255,0,0,15,192,0,63,255,255,255,0,0,15,192,0,63,64,0,63,0,0,15,192,0,42,0,0,42,0,
  // 0x7dda  線
  218,125,35,35,59,37,1,253,0,13,0,0,0,11,144,0,0,0,31,192,0,0,15,240,0,0,0,63,64,0,0,31,224,0,0,0,63,0,0,0,47,192,0,0,0,189,4,2,255,255,255,255,192,0,252,31,66,255,255,255,255,192,26,244,63,130,254,170,170,191,192,63,240,127,2,244,0,0,31,192,127,192,253,2,244,0,0,31,192,47,210,248,2,250,170,170,175,192,11,247,240,2,255,255,255,255,192,2,255,208,2,255,255,255,255,192,0,255,133,2,244,0,0,31,192,0,127,63,2,244,0,0,31,192,0,252,47,130,244,0,0,31,192,2,248,15,194,255,255,255,255,192,175,250,255,226,255,255,255,255,192,191,255,255,242,170,175,250,170,128,191,255,255,244,0,7,240,0,0,16,15,193,248,0,7,240,2,64,0,15,192,239,255,215,244,11,224,5,15,193,79,255,247,252,47,240,15,207,207,143,255,231,253,191,128,15,143,203,192,15,215,255,254,0,31,79,199,208,15,199,255,244,0,47,79,195,224,47,135,255,208,0,47,15,195,240,127,7,235,240,0,63,15,194,240,254,7,227,248,0,62,15,193,147,252,7,225,254,0,189,15,192,15,244,7,224,191,208,252,15,192,127,224,7,224,63,248,40,15,192,63,128,11,224,11,244,0,15,192,29,3,255,224,1,224,0,15,192,0,3,255,208,0,0,0,15,192,0,2,254,64,0,0,
  // 0x7de8  編
  232,125,34,35,59,37,1,253,0,13,0,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,63,64,47,255,255,255,255,240,0,63,0,47,255,255,255,255,240,0,189,4,47,255,255,255,255,240,0,252,47,64,0,0,0,0,0,26,244,63,64,0,0,0,0,0,63,240,190,3,255,255,255,255,128,127,192,252,3,255,255,255,255,192,31,210,244,3,255,255,255,255,192,7,247,240,3,240,0,0,31,192,2,255,208,3,240,0,0,31,192,0,255,137,3,240,0,0,31,192,0,127,62,3,240,0,0,31,192,0,252,47,3,255,255,255,255,192,2,248,15,131,255,255,255,255,192,175,251,255,195,250,170,170,170,128,191,255,255,211,240,0,0,0,0,191,255,255,227,240,0,0,0,0,16,31,131,247,255,255,255,255,224,0,15,130,215,255,255,255,255,224,0,15,128,7,255,175,175,235,224,14,79,159,11,254,15,11,131,224,15,143,159,75,254,15,11,131,224,31,79,143,143,254,15,11,131,224,31,79,139,207,255,175,175,235,224,47,15,135,223,255,255,255,255,224,63,15,131,255,191,255,255,255,224,62,15,131,255,62,15,11,131,224,189,15,128,127,62,15,11,131,224,252,15,128,190,62,15,11,131,224,24,15,128,252,62,15,11,131,224,0,15,130,248,62,15,11,175,224,0,15,128,112,62,15,11,175,208,0,15,128,0,45,5,5,31,128,
  // 0x7e2e  縮
  46,126,34,35,59,37,1,253,0,9,0,0,0,15,208,0,0,0,31,192,0,0,15,208,0,0,0,47,64,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,189,0,31,255,255,255,255,240,0,252,30,31,255,255,255,255,240,6,244,63,95,255,255,255,255,240,63,240,127,31,128,0,0,7,240,127,208,252,31,128,0,0,7,240,47,210,248,31,174,0,0,2,160,11,247,240,0,63,255,255,255,240,3,255,208,0,63,191,255,255,240,0,255,138,0,190,191,255,255,240,0,127,63,0,252,0,47,128,0,0,252,31,65,252,0,63,64,0,2,248,15,194,248,0,63,0,0,175,251,255,195,244,0,63,0,0,191,255,255,235,244,63,255,255,208,191,255,255,255,244,63,255,255,208,16,31,130,255,244,63,255,255,208,0,15,128,191,244,63,0,11,208,0,15,129,62,244,63,0,11,208,15,143,159,21,244,63,0,11,208,15,143,143,65,244,63,170,175,208,31,79,143,129,244,63,255,255,208,47,15,139,193,244,63,255,255,208,47,15,135,209,244,63,0,11,208,63,15,131,209,244,63,0,11,208,62,15,131,209,244,63,0,11,208,189,15,128,1,244,63,0,11,208,252,15,128,1,244,63,170,175,208,24,15,128,1,244,63,255,255,208,0,15,128,1,244,63,255,255,208,0,15,128,1,244,63,0,11,208,0,15,128,1,244,42,0,5,64,
  // 0x7e3d  總
  61,126,35,35,59,37,1,253,0,13,0,0,0,11,224,0,0,0,31,192,0,0,15,240,0,0,0,63,64,0,0,15,208,0,0,0,63,0,2,170,191,234,170,128,0,189,4,7,255,255,255,255,192,0,252,47,71,255,255,255,255,192,26,244,63,71,208,7,128,11,192,63,240,190,7,208,11,128,11,192,127,192,252,7,208,15,255,203,192,31,210,244,7,215,191,255,203,192,7,247,240,7,219,253,15,139,192,2,255,208,7,210,255,95,11,192,0,255,137,7,219,239,254,11,192,0,127,62,7,219,130,253,11,192,0,252,47,7,209,7,255,139,192,2,248,15,135,208,47,219,203,192,175,251,255,199,209,255,2,11,192,191,255,255,215,208,244,0,11,192,191,255,255,231,255,255,255,255,192,16,31,131,247,255,255,255,255,192,0,15,130,214,170,190,170,170,128,0,15,129,0,0,254,0,0,0,15,143,159,0,0,191,208,0,0,15,143,143,64,0,31,248,0,0,31,79,143,193,3,242,253,44,0,47,15,139,195,243,240,180,127,0,47,15,135,195,227,240,0,63,64,63,15,131,215,227,240,0,31,192,62,15,131,155,211,240,0,15,208,189,15,128,15,195,240,3,71,240,252,15,128,31,195,240,3,227,244,20,15,128,63,67,240,7,225,248,0,15,128,127,3,255,255,208,248,0,15,128,8,2,255,255,192,128,0,15,128,0,0,111,254,0,0,
  // 0x7e7c  繼
  124,126,35,35,59,37,1,253,0,36,0,126,0,0,0,0,0,0,127,0,126,3,208,0,240,0,0,189,0,126,3,192,2,224,0,0,252,0,126,11,137,3,194,0,1,248,0,126,63,31,63,75,192,2,240,120,126,189,62,63,15,64,27,240,253,126,63,124,31,126,0,63,209,248,126,15,244,7,252,0,127,195,240,126,3,232,2,246,0,47,199,224,126,7,223,3,219,128,15,239,192,126,15,15,79,67,192,3,255,64,126,255,255,255,255,240,1,255,16,126,191,255,255,255,240,0,189,244,126,0,0,0,0,80,0,248,252,127,255,255,255,255,240,2,240,189,127,255,255,255,255,240,7,250,255,127,171,170,170,234,160,255,255,255,190,3,208,0,240,0,191,255,255,254,3,192,2,240,0,191,191,15,254,11,133,3,194,0,0,63,10,190,63,15,107,135,192,0,63,0,126,189,46,63,15,64,31,127,60,126,63,124,31,110,0,31,63,62,126,15,244,7,252,0,47,63,63,126,3,232,2,251,0,47,63,31,190,7,223,3,219,128,63,63,15,254,15,11,75,131,192,62,63,15,254,255,255,255,255,240,125,63,15,254,191,255,255,255,244,188,63,4,126,21,1,133,64,96,188,63,0,126,0,0,0,0,0,0,63,0,127,255,255,255,255,244,0,63,0,127,255,255,255,255,244,0,63,0,127,170,170,170,170,160,0,63,0,126,0,0,0,0,0,
  // 0x7e8c  續
  140,126,34,35,59,37,1,253,0,13,0,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,63,64,63,255,255,255,255,240,0,127,0,63,255,255,255,255,240,0,252,4,0,0,31,208,0,0,1,248,47,64,0,15,192,0,0,11,240,63,3,255,255,255,255,128,63,224,190,3,255,255,255,255,128,127,192,252,0,0,0,0,0,0,47,211,244,11,255,255,255,255,208,15,251,224,15,255,255,255,255,208,3,255,192,15,192,244,124,7,208,1,255,156,15,194,240,126,91,208,0,191,62,15,239,192,47,255,208,0,188,47,15,201,0,0,7,208,0,244,31,143,255,255,255,255,208,3,250,175,203,255,255,255,255,208,191,255,255,208,0,0,0,0,0,127,255,255,226,255,255,255,255,0,127,255,195,226,255,255,255,255,64,0,15,193,66,244,0,0,63,64,0,15,193,2,250,170,170,191,64,15,143,223,2,255,255,255,255,64,15,143,207,66,244,0,0,63,64,31,79,207,130,244,0,0,63,64,47,15,203,194,255,255,255,255,64,47,15,199,194,250,170,170,191,64,63,15,195,210,244,0,0,63,64,62,15,193,2,255,255,255,255,64,189,15,192,2,255,255,255,255,0,252,15,192,0,31,192,15,224,0,24,15,192,2,255,224,31,254,0,0,15,192,191,254,0,2,255,224,0,15,192,191,224,0,0,47,240,0,15,128,41,0,0,0,3,128,
  // 0x7ea2  红
  162,126,35,34,50,37,1,254,0,1,128,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,15,240,1,85,85,85,85,64,0,31,224,7,255,255,255,255,224,0,63,192,7,255,255,255,255,224,0,127,128,7,255,255,255,255,224,0,255,0,0,0,11,240,0,0,1,253,3,128,0,11,240,0,0,3,248,7,244,0,11,240,0,0,11,240,15,240,0,11,240,0,0,31,208,47,224,0,11,240,0,0,191,255,255,192,0,11,240,0,0,127,255,255,0,0,11,240,0,0,63,255,253,0,0,11,240,0,0,41,71,248,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,255,64,0,0,11,240,0,0,3,253,0,80,0,11,240,0,0,11,254,191,240,0,11,240,0,0,63,255,255,240,0,11,240,0,0,63,255,255,224,0,11,240,0,0,63,254,144,0,0,11,240,0,0,41,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,27,208,0,11,240,0,0,0,107,255,224,0,11,240,0,0,127,255,255,239,255,255,255,255,244,127,255,254,79,255,255,255,255,244,63,254,64,15,255,255,255,255,244,57,64,0,5,85,85,85,85,80,0,0,0,0,0,0,0,0,0,
  // 0x7f6e  置
  110,127,34,35,59,37,2,252,5,85,85,85,85,85,85,84,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,11,224,7,240,3,240,1,252,0,11,224,7,240,3,240,1,252,0,11,224,7,240,3,240,1,252,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,5,85,85,87,253,85,85,84,0,0,0,0,3,248,0,0,0,0,106,170,170,171,254,170,170,170,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,0,7,240,0,0,0,0,0,0,0,11,224,0,0,0,0,6,160,63,255,255,255,255,224,0,7,240,63,255,255,255,255,224,0,7,240,63,64,0,0,11,224,0,7,240,63,255,255,255,255,224,0,7,240,63,255,255,255,255,224,0,7,240,63,64,0,0,11,224,0,7,240,63,64,0,0,11,224,0,7,240,63,255,255,255,255,224,0,7,240,63,255,255,255,255,224,0,7,240,63,64,0,0,11,224,0,7,240,63,64,0,0,11,224,0,7,240,63,255,255,255,255,224,0,7,240,47,255,255,255,255,224,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,255,255,255,255,255,255,255,208,7,255,255,255,255,255,255,255,208,7,250,170,170,170,170,170,170,128,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7f72  署
  114,127,34,34,50,37,1,253,1,85,85,85,85,85,85,85,0,2,255,255,255,255,255,255,255,0,2,255,255,255,255,255,255,255,0,2,244,1,248,0,252,0,127,0,2,244,1,248,0,252,0,127,0,2,244,1,248,0,252,0,127,0,2,255,255,255,255,255,255,255,0,2,255,255,255,255,255,255,255,0,1,85,85,91,245,85,85,85,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,56,0,0,63,255,255,255,255,240,255,0,0,63,255,255,255,255,247,253,0,0,42,170,175,250,170,255,244,0,0,0,0,7,240,1,255,192,0,0,0,0,7,240,15,254,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,224,0,0,0,47,255,192,0,0,0,0,0,7,255,253,0,0,0,0,0,1,191,255,255,255,255,248,0,1,191,255,255,255,255,255,248,0,127,255,255,170,170,170,171,248,0,63,255,191,0,0,0,2,248,0,31,144,63,0,0,0,3,248,0,0,0,63,255,255,255,255,248,0,0,0,63,255,255,255,255,248,0,0,0,63,0,0,0,2,248,0,0,0,63,0,0,0,2,248,0,0,0,63,255,255,255,255,248,0,0,0,63,255,255,255,255,248,0,0,0,63,170,170,170,171,248,0,0,0,42,0,0,0,1,164,0,
  // 0x8070  聰
  112,128,35,36,68,37,1,252,0,0,0,0,0,7,224,0,0,0,0,0,0,0,11,240,0,0,63,255,255,253,0,15,224,0,0,63,255,255,254,170,175,234,170,128,63,255,255,255,255,255,255,255,192,3,240,15,209,255,255,255,255,192,3,240,15,209,244,3,192,11,192,3,240,15,209,244,7,192,11,192,3,240,15,209,244,15,255,203,192,3,255,255,209,245,255,175,203,192,3,255,255,209,245,254,15,75,192,3,255,255,209,246,255,175,11,192,3,240,15,209,246,199,252,11,192,3,240,15,209,244,1,253,11,192,3,240,15,209,244,7,255,75,192,3,240,15,209,244,63,135,11,192,3,240,15,209,244,189,0,11,192,3,255,255,209,250,186,170,175,192,3,255,255,209,255,255,255,255,192,3,255,255,209,255,255,255,255,192,3,240,15,208,0,47,128,0,0,3,240,15,208,0,63,240,0,0,3,240,15,208,0,11,253,0,0,3,240,15,208,0,165,255,0,0,3,240,15,208,81,248,61,29,0,3,246,255,208,253,248,4,127,0,111,255,255,208,248,248,0,63,64,127,255,255,209,244,248,0,31,192,127,254,95,210,240,248,0,15,208,57,64,15,211,240,248,2,231,240,0,0,15,219,224,248,2,243,240,0,0,15,239,192,248,3,242,248,0,0,15,239,128,255,255,225,248,0,0,15,210,0,255,255,192,128,0,0,15,208,0,26,170,64,0,0,0,0,0,0,0,0,0,0,
  // 0x81ea  自
  234,129,26,36,252,37,6,252,0,0,11,224,0,0,0,0,0,15,240,0,0,0,0,0,15,224,0,0,0,0,0,31,208,0,0,0,0,0,47,192,0,0,0,255,255,255,255,255,255,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,254,85,85,85,85,95,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,0,0,0,0,0,0,0,
  // 0x85cd  藍
  205,133,33,34,50,37,2,254,0,0,127,0,0,63,64,0,0,0,0,127,0,0,63,64,0,0,191,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,127,0,0,63,64,0,0,0,0,127,0,0,63,64,0,0,0,0,21,0,0,36,0,0,0,15,255,255,255,192,191,0,0,0,15,255,255,255,192,253,0,0,0,15,128,188,0,1,252,0,0,0,15,128,188,0,3,255,255,255,64,15,255,255,255,11,255,255,255,64,15,255,255,255,15,255,255,255,64,15,128,0,47,63,192,0,0,0,15,128,0,47,191,64,0,0,0,15,255,255,255,29,0,0,0,0,15,255,255,255,0,0,0,0,0,15,128,188,0,1,255,255,254,0,15,128,189,0,1,255,255,254,0,15,255,255,255,209,255,255,253,0,15,255,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,144,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,252,1,244,3,224,15,224,0,0,252,1,244,3,224,15,224,0,0,252,1,244,3,224,15,224,0,0,252,1,244,3,224,15,224,0,0,252,1,244,3,224,15,224,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x884c  行
  76,136,34,36,68,37,1,252,0,0,180,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,7,252,2,255,255,255,255,192,0,31,240,2,255,255,255,255,192,0,127,208,2,255,255,255,255,192,2,255,64,0,85,85,85,85,64,11,253,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,127,208,14,0,0,0,0,0,0,47,0,63,192,0,0,0,0,0,8,0,127,128,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,3,253,5,85,85,85,85,80,0,11,248,31,255,255,255,255,240,0,47,240,31,255,255,255,255,240,0,127,208,31,255,255,255,255,240,1,255,208,0,0,0,47,192,0,11,255,208,0,0,0,47,192,0,47,255,208,0,0,0,47,192,0,255,239,208,0,0,0,47,192,0,127,143,208,0,0,0,47,192,0,30,15,208,0,0,0,47,192,0,4,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,1,85,127,192,0,0,15,208,0,2,255,255,128,0,0,15,208,0,1,255,255,64,0,0,15,208,0,0,255,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8868  表
  104,136,35,35,59,37,1,253,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,7,255,255,255,255,255,255,255,64,7,255,255,255,255,255,255,255,64,7,255,255,255,255,255,255,255,64,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,127,255,255,255,255,255,252,0,0,191,255,255,255,255,255,252,0,0,191,255,255,255,255,255,252,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,0,0,0,127,239,192,0,0,0,0,0,2,255,143,224,0,28,0,0,0,31,253,7,240,0,191,0,0,0,255,240,3,244,2,255,64,0,27,255,192,2,252,31,253,0,1,255,255,128,1,253,191,224,0,111,255,255,128,0,255,255,64,0,127,254,63,128,0,127,248,0,0,47,208,63,128,0,47,224,0,0,9,0,63,128,0,15,244,0,0,0,0,63,128,0,71,253,0,0,0,0,63,128,111,210,255,128,0,0,0,63,239,255,208,191,244,0,0,0,127,255,255,208,47,254,64,0,127,255,255,249,0,7,255,244,0,191,255,249,0,0,0,255,240,0,127,249,0,0,0,0,31,208,0,57,0,0,0,0,0,1,128,
  // 0x88ab  被
  171,136,35,35,59,37,1,253,0,31,128,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,47,192,3,255,255,255,255,244,63,255,255,195,255,255,255,255,240,63,255,255,211,255,255,255,255,240,63,255,255,195,244,3,244,11,224,0,0,47,131,244,3,244,15,208,0,0,127,3,244,3,244,15,192,0,0,254,3,244,3,244,31,192,0,1,252,3,244,3,244,27,64,0,3,248,147,244,3,244,0,0,0,15,240,251,255,255,255,255,128,0,47,227,243,255,255,255,255,192,0,191,251,211,255,255,255,255,128,1,255,255,131,255,224,0,63,64,7,255,255,3,251,240,0,191,0,47,255,239,195,243,244,0,254,0,255,239,207,227,241,252,1,252,0,127,95,195,231,240,253,3,252,0,60,31,194,135,240,191,11,244,0,16,31,192,11,224,63,223,224,0,0,31,192,15,208,31,255,192,0,0,31,192,15,192,15,255,64,0,0,31,192,31,192,3,255,0,0,0,31,192,47,128,15,255,128,0,0,31,192,63,64,127,255,240,0,0,31,192,191,2,255,239,254,0,0,31,192,254,47,254,7,255,224,0,31,194,252,191,244,0,255,244,0,31,193,244,63,128,0,31,224,0,31,192,32,8,0,0,1,192,
  // 0x88c5  装
  197,136,35,36,68,37,1,252,0,0,42,0,0,10,144,0,0,0,0,127,0,0,15,208,0,0,2,0,127,0,0,15,208,0,0,15,208,127,0,0,15,208,0,0,15,248,127,0,0,15,208,0,0,3,254,127,31,255,255,255,255,240,0,189,127,31,255,255,255,255,240,0,36,127,31,255,255,255,255,240,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,0,7,127,0,0,15,208,0,0,1,191,191,0,0,15,208,0,0,31,255,191,0,0,15,208,0,0,127,248,127,7,255,255,255,255,192,63,64,127,7,255,255,255,255,192,20,0,127,7,255,255,255,255,192,0,0,127,0,0,0,0,0,0,0,0,42,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,42,170,170,255,255,234,170,170,160,0,0,2,255,95,192,0,56,0,0,0,47,248,11,224,1,255,0,0,7,255,208,3,248,31,253,0,6,255,255,64,1,253,191,224,0,127,255,255,64,0,191,254,0,0,31,244,63,64,0,47,244,0,0,9,0,63,64,1,11,254,0,0,0,0,63,171,255,2,255,208,0,0,26,255,255,255,64,127,255,128,0,63,255,255,250,0,11,255,244,0,63,255,148,0,0,0,191,224,0,21,0,0,0,0,0,6,192,0,0,0,0,0,0,0,0,0,
  // 0x88dd  裝
  221,136,35,36,68,37,1,252,1,80,11,208,0,11,224,0,0,3,240,15,208,0,11,240,0,0,3,240,15,208,0,11,240,0,0,3,240,15,208,0,11,240,0,0,3,240,15,208,0,11,240,0,0,3,255,255,211,255,255,255,255,224,3,255,255,211,255,255,255,255,224,3,250,175,211,255,255,255,255,224,1,80,15,208,0,11,240,0,0,0,0,15,208,0,11,240,0,0,63,255,255,208,0,11,240,0,0,63,255,255,208,0,11,240,0,0,43,254,175,208,0,11,240,0,0,2,248,15,208,0,11,240,0,0,3,244,15,209,255,255,255,255,192,7,240,15,209,255,255,255,255,192,15,224,15,209,255,255,255,255,192,127,192,15,208,0,0,0,0,0,63,0,15,208,253,0,0,0,0,4,0,0,0,253,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,42,170,170,255,255,234,170,170,160,0,0,7,255,31,192,0,56,0,0,0,127,248,11,224,1,255,0,0,27,255,192,3,248,31,253,0,27,255,255,64,1,254,191,224,0,63,255,191,64,0,191,254,0,0,31,224,63,64,0,47,244,0,0,4,0,63,64,22,75,254,0,0,0,0,63,175,255,130,255,224,0,0,107,255,255,255,128,127,255,128,0,127,255,255,233,0,11,255,244,0,127,250,80,0,0,0,191,224,0,16,0,0,0,0,0,6,192,0,0,0,0,0,0,0,0,0,
  // 0x8907  複
  7,137,35,36,68,37,1,252,0,26,64,0,26,64,0,0,0,0,47,64,0,47,192,0,0,0,0,47,64,0,63,64,0,0,0,0,47,64,0,191,0,0,0,0,0,47,64,0,255,255,255,255,240,0,47,64,2,255,255,255,255,240,0,47,64,3,255,255,255,255,240,0,47,64,15,224,0,0,0,0,63,255,255,47,208,0,0,0,0,63,255,255,255,255,255,255,255,0,63,255,255,46,255,255,255,255,0,0,0,125,4,252,0,0,63,0,0,0,252,0,252,0,0,63,0,0,2,244,0,255,255,255,255,0,0,3,240,192,255,255,255,255,0,0,15,210,240,253,0,0,127,0,0,47,215,208,252,0,0,63,0,0,127,255,128,255,255,255,255,0,0,255,255,0,255,255,255,255,0,3,255,254,0,1,254,0,0,0,11,255,191,0,3,252,0,0,0,47,255,95,192,11,248,0,0,0,127,239,79,192,31,255,255,253,0,191,47,71,64,191,255,255,255,0,61,47,65,2,255,170,171,252,0,20,47,64,31,255,192,7,248,0,0,47,64,191,239,240,31,240,0,0,47,64,47,3,253,191,192,0,0,47,64,4,0,255,255,0,0,0,47,64,0,0,191,252,0,0,0,47,64,0,27,255,255,208,0,0,47,64,26,255,254,255,255,144,0,47,64,255,255,224,31,255,248,0,47,64,127,249,0,1,255,240,0,47,64,46,0,0,0,6,192,0,0,0,0,0,0,0,0,0,
  // 0x89d2  角
  210,137,32,36,32,37,1,252,0,0,7,228,0,0,0,0,0,0,15,244,0,0,0,0,0,0,31,255,255,253,0,0,0,0,63,255,255,255,128,0,0,0,255,255,255,255,64,0,0,1,254,0,0,255,0,0,0,7,252,0,2,253,0,0,0,15,244,0,3,248,0,0,0,63,224,0,15,240,0,0,1,255,255,255,255,255,255,253,7,255,255,255,255,255,255,253,47,255,255,255,255,255,255,253,15,239,208,0,63,0,0,253,3,79,208,0,63,0,0,253,0,15,208,0,63,0,0,253,0,15,208,0,63,0,0,253,0,15,255,255,255,255,255,253,0,15,255,255,255,255,255,253,0,15,255,255,255,255,255,253,0,15,208,0,63,0,0,253,0,15,208,0,63,0,0,253,0,15,192,0,63,0,0,253,0,15,192,0,63,0,0,253,0,31,192,0,127,0,0,253,0,47,255,255,255,255,255,253,0,63,255,255,255,255,255,253,0,63,255,255,255,255,255,253,0,127,0,0,0,0,0,253,0,254,0,0,0,0,0,253,2,253,0,0,0,0,0,253,7,248,0,0,0,0,0,253,31,240,0,0,0,20,2,253,127,208,0,0,0,127,255,252,63,128,0,0,0,63,255,248,13,0,0,0,0,47,255,144,0,0,0,0,0,0,0,0,
  // 0x8a08  計
  8,138,35,35,59,37,1,253,0,0,0,0,0,1,248,0,0,6,170,170,160,0,2,252,0,0,11,255,255,240,0,2,252,0,0,11,255,255,240,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,106,170,170,168,0,2,252,0,0,191,255,255,252,0,2,252,0,0,191,255,255,252,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,10,170,170,160,0,2,252,0,0,15,255,255,240,0,2,252,0,0,15,255,255,243,255,255,255,255,252,0,0,0,3,255,255,255,255,252,0,0,0,3,255,255,255,255,252,10,170,170,161,85,87,253,85,84,15,255,255,240,0,2,252,0,0,15,255,255,240,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,15,255,255,224,0,2,252,0,0,15,255,255,224,0,2,252,0,0,15,255,255,224,0,2,252,0,0,15,192,7,224,0,2,252,0,0,15,192,7,224,0,2,252,0,0,15,192,7,224,0,2,252,0,0,15,192,7,224,0,2,252,0,0,15,192,7,224,0,2,252,0,0,15,255,255,224,0,2,252,0,0,15,255,255,224,0,2,252,0,0,15,255,255,224,0,2,252,0,0,15,192,0,0,0,2,252,0,0,5,64,0,0,0,2,252,0,0,
  // 0x8a0a  訊
  10,138,36,35,59,37,1,252,6,170,170,129,85,85,85,80,0,11,255,255,199,255,255,255,252,0,11,255,255,199,255,255,255,252,0,0,0,0,7,255,255,255,252,0,0,0,0,0,3,240,2,252,0,106,170,170,160,3,240,2,252,0,191,255,255,244,3,240,2,248,0,191,255,255,244,3,240,2,248,0,0,0,0,0,3,240,2,248,0,0,0,0,0,3,240,2,248,0,10,170,170,128,3,240,2,248,0,15,255,255,192,3,240,2,248,0,15,255,255,192,3,240,2,248,0,0,0,0,0,7,244,2,248,0,0,0,0,11,255,255,246,248,0,10,170,170,139,255,255,246,248,0,15,255,255,203,255,255,246,248,0,15,255,255,192,7,240,2,252,0,0,0,0,0,11,240,2,252,0,0,0,0,0,11,224,2,252,0,0,0,0,0,15,224,1,252,0,15,255,255,192,15,208,1,252,0,15,255,255,192,31,192,1,252,0,15,255,255,192,47,192,1,252,0,15,192,15,192,63,128,0,252,0,15,192,15,192,127,64,0,253,32,15,192,15,192,255,0,0,253,40,15,192,15,192,254,0,0,254,61,15,192,15,195,252,0,0,191,61,15,255,255,203,248,0,0,127,124,15,255,255,223,240,0,0,63,252,15,255,255,255,208,0,0,47,248,15,192,0,15,64,0,0,15,240,5,64,0,2,0,0,0,2,208,0,0,0,0,0,0,0,0,0,
  // 0x8a18  記
  24,138,35,34,50,37,1,253,6,170,170,160,0,0,0,0,0,11,255,255,240,63,255,255,255,128,11,255,255,240,63,255,255,255,128,0,0,0,0,63,255,255,255,128,0,0,0,0,21,85,85,127,128,106,170,170,168,0,0,0,63,128,191,255,255,252,0,0,0,63,128,191,255,255,252,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,10,170,170,160,0,0,0,63,128,15,255,255,240,0,0,0,63,128,15,255,255,240,0,0,0,63,128,0,0,0,0,63,255,255,255,128,0,0,0,0,63,255,255,255,128,10,170,170,160,63,255,255,255,128,15,255,255,240,63,149,85,127,128,15,255,255,240,63,128,0,63,128,0,0,0,0,63,128,0,5,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,15,255,255,224,63,128,0,0,0,15,255,255,224,63,128,0,0,0,15,255,255,224,63,128,0,0,0,15,192,7,224,63,128,0,1,64,15,192,7,224,63,128,0,2,244,15,192,7,224,63,128,0,3,248,15,192,7,224,63,128,0,3,244,15,192,7,224,63,128,0,3,244,15,255,255,224,63,192,0,11,240,15,255,255,224,47,255,255,255,240,15,255,255,224,15,255,255,255,208,15,192,0,0,7,255,255,255,64,5,64,0,0,0,5,85,64,0,
  // 0x8a2d  設
  45,138,35,34,50,37,1,253,6,170,170,128,63,255,255,192,0,11,255,255,192,63,255,255,192,0,11,255,255,192,63,255,255,192,0,0,0,0,0,63,64,31,192,0,0,0,0,0,63,64,15,192,0,106,170,170,164,63,64,15,192,0,191,255,255,248,63,64,15,192,128,191,255,255,248,63,0,15,192,248,0,0,0,0,127,0,15,192,248,0,0,0,0,255,0,15,193,244,10,170,170,130,253,0,15,255,244,15,255,255,219,252,0,15,255,240,15,255,255,255,244,0,3,255,192,0,0,0,15,224,0,0,0,0,0,0,0,3,128,0,0,0,0,10,170,170,131,255,255,255,254,0,15,255,255,211,255,255,255,255,64,15,255,255,211,255,255,255,255,0,0,0,0,0,7,0,0,255,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,128,2,252,0,15,255,255,208,31,208,3,248,0,15,255,255,208,15,240,15,240,0,15,255,255,208,7,248,47,224,0,15,192,11,208,2,254,127,192,0,15,192,11,208,0,255,255,0,0,15,192,11,208,0,63,253,0,0,15,192,11,208,0,127,253,0,0,15,192,11,208,2,255,255,128,0,15,255,255,208,111,255,191,249,0,15,255,255,235,255,244,31,255,224,15,255,255,223,255,128,2,255,240,15,192,0,11,248,0,0,47,208,5,64,0,2,64,0,0,1,128,
  // 0x8a66  試
  102,138,35,36,68,37,1,252,0,0,0,0,0,0,63,133,0,10,170,170,64,0,0,63,191,0,11,255,255,128,0,0,47,175,192,11,255,255,128,0,0,47,139,224,0,0,0,0,0,0,47,131,244,0,0,0,0,0,0,47,129,224,106,170,170,144,0,0,47,128,0,191,255,255,234,170,170,191,234,160,191,255,255,239,255,255,255,255,240,0,0,0,15,255,255,255,255,240,0,0,0,15,255,255,255,255,240,10,170,170,64,0,0,47,128,0,15,255,255,128,0,0,47,128,0,15,255,255,128,0,0,47,128,0,0,0,0,0,0,0,47,128,0,0,0,0,11,255,255,95,128,0,10,170,170,139,255,255,95,128,0,15,255,255,139,255,255,95,192,0,15,255,255,128,15,192,31,192,0,0,0,0,0,15,192,15,192,0,0,0,0,0,15,192,15,192,0,0,0,0,0,15,192,15,192,0,15,255,255,128,15,192,15,192,0,15,255,255,128,15,192,15,208,0,15,255,255,128,15,192,15,208,0,15,192,15,128,15,192,11,224,0,15,192,15,128,15,192,7,224,64,15,192,15,128,15,218,215,240,116,15,192,15,128,111,255,211,240,188,15,192,15,159,255,255,211,244,252,15,255,255,143,255,249,2,253,248,15,255,255,143,249,0,0,255,244,15,255,255,132,0,0,0,255,240,15,192,0,0,0,0,0,63,224,5,64,0,0,0,0,0,11,128,0,0,0,0,0,0,0,0,0,
  // 0x8a8d  認
  141,138,35,34,50,37,1,253,10,170,170,64,0,0,0,0,0,11,255,255,130,255,255,255,255,208,11,255,255,130,255,255,255,255,192,0,0,0,2,255,255,255,255,192,0,0,0,0,0,63,64,15,192,106,170,170,160,228,63,0,15,192,191,255,255,225,255,254,0,15,192,191,255,255,225,255,253,0,15,192,0,0,0,0,31,255,128,31,192,0,0,0,0,3,255,240,31,192,10,170,170,64,3,255,252,31,192,15,255,255,128,11,247,248,47,128,15,255,255,128,31,208,176,63,128,0,0,0,0,127,192,16,63,64,0,0,0,2,255,0,191,255,0,10,170,170,79,252,0,63,254,0,15,255,255,135,240,40,63,248,0,15,255,255,130,64,191,64,0,0,0,0,0,0,0,191,224,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,2,255,0,0,15,255,255,128,3,240,126,0,0,15,255,255,129,67,240,24,125,0,15,255,255,130,243,240,0,191,0,15,192,15,131,243,240,0,63,64,15,192,15,131,243,240,0,47,192,15,192,15,135,227,240,0,15,224,15,192,15,139,211,240,3,71,240,15,192,15,143,195,240,3,243,244,15,255,255,175,131,240,3,242,248,15,255,255,175,3,244,7,241,252,15,255,255,133,3,255,255,224,224,15,192,0,0,1,255,255,192,0,5,64,0,0,0,191,255,64,0,
  // 0x8aa4  誤
  164,138,35,34,50,37,1,253,6,170,170,0,0,127,255,255,128,11,255,255,0,0,127,255,255,192,11,255,255,0,0,127,255,255,192,0,0,0,3,240,126,0,31,192,0,0,0,3,240,126,0,31,192,106,170,170,131,240,126,0,31,192,191,255,255,195,240,126,0,31,192,191,255,255,195,240,126,0,31,192,0,0,0,3,240,127,255,255,192,0,0,0,3,240,127,255,255,192,10,170,170,3,240,127,255,255,192,15,255,255,3,240,0,0,0,0,15,255,255,3,240,0,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,3,255,255,255,254,0,10,170,170,3,255,255,255,254,0,15,255,255,3,255,255,255,254,0,15,255,255,3,240,0,0,190,0,0,0,0,3,240,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,15,255,255,31,255,255,255,255,248,15,255,255,31,255,255,255,255,248,15,255,255,31,255,255,255,255,248,15,192,47,0,0,0,0,0,0,15,192,47,0,3,128,1,192,0,15,192,47,0,15,240,15,240,0,15,192,47,0,47,224,7,252,0,15,192,47,0,191,192,1,255,0,15,255,255,2,255,0,0,191,192,15,255,255,15,252,0,0,47,224,15,234,170,63,240,0,0,15,244,15,192,0,31,192,0,0,3,244,5,64,0,6,0,0,0,1,64,
  // 0x8abf  調
  191,138,34,35,59,37,1,252,10,170,169,0,0,0,0,0,0,15,255,253,15,255,255,255,255,208,15,255,253,15,255,255,255,255,208,0,0,0,15,255,255,255,255,208,0,0,0,15,192,11,192,15,208,106,170,170,79,192,15,192,15,208,191,255,255,79,192,15,192,15,208,191,255,255,79,195,255,255,79,208,0,0,0,15,195,255,255,79,208,0,0,0,15,194,175,234,79,208,10,170,169,15,192,15,192,15,208,15,255,253,15,192,15,192,15,208,15,255,253,15,192,15,192,15,208,0,0,0,15,199,255,255,207,208,0,0,0,15,199,255,255,207,208,10,170,169,15,198,170,170,143,208,15,255,253,15,192,0,0,15,208,15,255,253,15,192,0,0,15,208,0,0,0,15,195,255,255,79,208,0,0,0,15,195,255,255,79,208,0,0,0,15,195,250,175,79,208,15,255,253,15,195,224,15,79,208,15,255,253,15,195,224,15,79,208,15,255,253,31,195,224,15,79,208,15,128,125,47,131,224,15,79,208,15,128,125,47,67,250,175,79,208,15,128,125,63,67,255,255,79,208,15,128,125,63,3,255,255,79,208,15,128,125,127,3,224,0,15,208,15,255,253,254,1,64,0,15,208,15,255,254,253,0,0,5,95,208,15,234,171,252,0,0,31,255,192,15,128,1,248,0,0,15,255,192,5,64,0,48,0,0,15,254,0,0,0,0,0,0,0,0,0,0,
  // 0x8acb  請
  203,138,35,35,59,37,1,253,0,0,0,0,0,7,240,0,0,6,170,170,128,0,7,240,0,0,11,255,255,193,170,171,250,170,144,11,255,255,195,255,255,255,255,224,0,0,0,3,255,255,255,255,224,0,0,0,0,0,7,240,0,0,106,170,170,160,0,7,240,0,0,191,255,255,244,255,255,255,255,192,191,255,255,244,255,255,255,255,192,0,0,0,0,85,91,245,85,64,0,0,0,0,0,7,240,0,0,10,170,170,134,170,171,250,170,160,15,255,255,207,255,255,255,255,244,15,255,255,207,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,170,170,128,63,255,255,255,0,15,255,255,192,63,255,255,255,0,15,255,255,192,63,170,170,191,0,0,0,0,0,63,0,0,63,0,0,0,0,0,63,85,85,127,0,0,0,0,0,63,255,255,255,0,15,255,255,192,63,255,255,255,0,15,255,255,192,63,0,0,63,0,15,255,255,192,63,0,0,63,0,15,192,15,192,63,85,85,127,0,15,192,15,192,63,255,255,255,0,15,192,15,192,63,255,255,255,0,15,192,15,192,63,0,0,63,0,15,192,15,192,63,0,0,63,0,15,255,255,192,63,0,0,63,0,15,255,255,192,63,0,0,63,0,15,255,255,192,63,0,63,255,0,15,192,0,0,63,0,31,254,0,5,64,0,0,63,0,10,164,0,
  // 0x8b70  議
  112,139,35,35,59,37,1,253,0,0,0,0,44,0,1,224,0,10,170,169,0,127,0,3,248,0,15,255,253,0,47,64,7,240,0,15,255,253,5,111,213,95,229,64,0,0,0,31,255,255,255,255,208,0,0,0,31,255,255,255,255,208,106,170,170,64,0,31,192,0,0,191,255,255,64,0,31,192,0,0,191,255,255,67,255,255,255,255,64,0,0,0,3,255,255,255,255,64,0,0,0,0,0,47,192,0,0,10,170,169,0,0,31,192,0,0,15,255,253,106,170,175,234,170,160,15,255,253,191,255,255,255,255,240,0,0,0,191,255,255,255,255,240,0,0,0,0,0,16,0,0,0,10,170,169,0,91,248,252,40,0,15,255,253,63,255,253,252,191,0,15,255,253,47,255,144,252,47,192,0,0,0,0,47,64,188,11,224,0,0,0,0,47,64,188,2,128,0,0,0,106,191,170,254,170,160,15,255,253,191,255,255,255,255,240,15,255,253,191,255,255,255,255,240,15,255,253,0,47,64,62,0,0,15,128,125,0,47,65,63,31,0,15,128,125,1,127,255,63,63,64,15,128,125,255,255,255,47,254,0,15,128,125,191,255,228,31,248,0,15,128,125,105,127,64,31,224,80,15,255,253,0,47,64,127,208,184,15,255,253,0,47,71,255,240,244,15,234,169,5,127,47,243,255,240,15,128,0,15,255,15,64,255,240,5,64,0,15,248,0,0,47,128,
  // 0x8b80  讀
  128,139,35,35,59,37,1,253,0,0,0,0,0,15,192,0,0,10,170,169,0,0,15,192,0,0,15,255,253,31,255,255,255,255,240,15,255,253,31,255,255,255,255,240,0,0,0,5,85,95,213,85,64,0,0,0,0,0,31,192,0,0,106,170,170,67,255,255,255,255,192,191,255,255,67,255,255,255,255,192,191,255,255,64,0,0,0,0,0,0,0,0,31,255,255,255,255,224,0,0,0,31,255,255,255,255,224,10,170,169,31,64,240,124,7,224,15,255,253,31,71,240,125,91,224,15,255,253,31,191,128,63,255,224,0,0,0,31,84,0,0,7,224,0,0,0,31,255,255,255,255,224,10,170,169,31,255,255,255,255,224,15,255,253,0,0,0,0,0,0,15,255,253,3,255,255,255,255,128,0,0,0,3,255,255,255,255,128,0,0,0,3,240,0,0,47,128,0,0,0,3,245,85,85,127,128,15,255,253,3,255,255,255,255,128,15,255,253,3,240,0,0,47,128,15,255,253,3,245,85,85,127,128,15,128,125,3,255,255,255,255,128,15,128,125,3,240,0,0,47,128,15,128,125,3,255,255,255,255,128,15,128,125,3,255,255,255,255,128,15,128,125,0,11,64,11,128,0,15,255,253,0,127,224,47,248,0,15,255,253,11,255,128,7,255,64,15,234,169,255,252,0,0,191,244,15,128,0,127,208,0,0,15,240,5,64,0,24,0,0,0,1,64,
  // 0x8b8a  變
  138,139,35,36,68,37,1,252,0,41,0,0,0,0,10,64,0,0,63,0,47,255,208,15,128,0,0,188,0,47,255,208,63,0,0,5,244,160,0,0,1,188,46,0,31,225,252,255,255,255,244,127,0,15,211,240,255,255,255,244,252,0,7,255,192,0,0,1,255,240,0,1,255,64,0,0,0,127,197,0,0,189,120,63,255,208,47,47,0,0,244,61,47,255,208,125,15,192,23,255,255,0,0,5,255,255,224,63,255,255,191,255,239,255,255,240,63,255,71,111,255,223,255,208,240,0,31,0,0,0,0,11,192,0,6,95,108,47,255,210,155,203,64,15,223,61,63,255,227,235,207,192,15,95,47,61,3,231,203,195,208,47,31,15,125,3,235,203,194,240,63,31,9,63,255,239,75,193,244,61,31,3,255,255,235,11,192,224,4,31,15,240,0,0,11,192,0,0,26,47,208,0,0,6,128,0,0,0,191,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,31,255,255,255,255,255,255,192,1,255,254,0,0,11,248,0,0,31,255,191,208,0,63,224,0,0,15,244,31,253,2,255,128,0,0,3,128,2,255,239,253,0,0,0,0,0,0,127,255,240,0,0,0,0,0,6,255,255,254,144,0,0,1,107,255,255,239,255,255,169,64,127,255,255,248,0,191,255,255,244,47,255,249,0,0,1,191,255,224,15,164,0,0,0,0,0,91,192,0,0,0,0,0,0,0,0,0,
  // 0x8cc7  資
  199,140,33,36,68,37,2,252,0,0,0,1,248,0,0,0,0,11,224,0,3,244,0,0,0,0,31,255,128,11,245,85,85,89,0,6,255,244,31,255,255,255,255,64,0,31,240,127,255,255,255,254,0,0,1,225,254,2,252,0,252,0,0,0,3,252,3,254,3,248,0,0,0,0,240,11,255,7,240,0,0,6,240,0,47,255,192,128,0,1,191,244,0,191,143,244,0,0,191,255,244,27,255,3,255,128,0,255,254,67,255,248,0,255,254,128,127,144,2,255,128,0,47,255,192,36,0,1,249,0,0,6,255,0,0,127,255,255,255,255,255,197,0,0,127,255,255,255,255,255,192,0,0,127,0,0,0,0,47,192,0,0,127,0,0,0,0,47,192,0,0,127,255,255,255,255,255,192,0,0,127,255,255,255,255,255,192,0,0,127,0,0,0,0,47,192,0,0,127,0,0,0,0,47,192,0,0,127,255,255,255,255,255,192,0,0,127,255,255,255,255,255,192,0,0,127,0,0,0,0,47,192,0,0,127,0,0,0,0,47,192,0,0,127,0,0,0,0,47,192,0,0,127,255,255,255,255,255,192,0,0,127,255,255,255,255,255,192,0,0,0,30,0,0,41,0,0,0,0,2,255,208,1,255,224,0,0,1,191,255,0,0,127,255,64,0,127,255,224,0,0,2,255,248,0,63,253,0,0,0,0,31,255,64,15,64,0,0,0,0,1,244,0,0,0,0,0,0,0,0,0,0,
  // 0x8ddd  距
  221,141,35,33,41,37,1,253,11,255,255,248,63,255,255,255,240,11,255,255,248,63,255,255,255,240,11,255,255,248,63,255,255,255,240,11,208,1,248,63,64,0,0,0,11,208,1,248,63,64,0,0,0,11,208,1,248,63,64,0,0,0,11,208,1,248,63,64,0,0,0,11,208,1,248,63,64,0,0,0,11,255,255,248,63,128,0,0,0,11,255,255,248,63,255,255,255,128,11,255,255,248,63,255,255,255,128,0,2,244,0,63,255,255,255,128,0,2,244,0,63,64,0,63,128,0,2,244,0,63,64,0,63,128,0,2,244,0,63,64,0,63,128,15,194,244,0,63,64,0,63,128,15,194,244,0,63,64,0,63,128,15,194,255,253,63,64,0,63,128,15,194,255,253,63,128,0,63,128,15,194,255,253,63,255,255,255,128,15,194,244,0,63,255,255,255,128,15,194,244,0,63,255,255,255,128,15,194,244,0,63,64,0,0,0,15,194,244,0,63,64,0,0,0,15,194,244,5,63,64,0,0,0,15,194,250,254,63,64,0,0,0,15,215,255,255,63,64,0,0,0,31,255,255,254,63,128,0,0,0,191,255,254,64,63,255,255,255,248,127,254,64,0,63,255,255,255,248,121,64,0,0,63,255,255,255,248,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,
  // 0x8eca  車
  202,142,33,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,0,0,0,7,244,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,252,0,7,240,0,15,208,0,0,252,0,7,240,0,15,208,0,0,252,0,7,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,254,170,175,250,170,175,208,0,0,252,0,7,240,0,15,208,0,0,252,0,7,240,0,15,208,0,0,252,0,7,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,192,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8edf  軟
  223,142,35,36,68,37,1,252,0,1,244,0,0,249,0,0,0,0,2,248,0,0,253,0,0,0,0,2,248,0,0,252,0,0,0,0,2,248,0,1,252,0,0,0,63,255,255,255,194,252,0,0,0,63,255,255,255,194,248,0,0,0,63,255,255,255,195,244,0,0,0,0,2,248,0,3,255,255,255,224,0,2,248,0,7,255,255,255,240,5,87,253,85,15,255,255,255,240,31,255,255,255,79,210,248,11,224,31,255,255,255,95,194,248,15,208,31,65,240,31,127,130,248,15,192,31,65,240,31,191,66,248,15,192,31,65,240,31,255,2,248,31,128,31,255,255,255,253,2,248,47,64,31,255,255,255,188,2,248,63,0,31,150,245,111,64,2,252,6,0,31,65,240,31,64,3,252,0,0,31,65,240,31,64,3,252,0,0,31,170,250,191,64,3,252,0,0,31,255,255,255,64,7,253,0,0,31,255,255,255,64,15,255,0,0,0,2,248,0,0,15,175,0,0,0,2,248,0,0,47,95,128,0,0,2,248,0,0,63,15,192,0,127,255,255,255,208,190,15,224,0,127,255,255,255,209,252,7,240,0,127,255,255,255,211,252,3,252,0,0,2,248,0,15,240,1,254,0,0,2,248,0,63,208,0,191,128,0,2,248,1,255,128,0,63,240,0,2,248,7,254,0,0,15,248,0,2,248,3,248,0,0,3,240,0,2,248,0,208,0,0,0,144,0,0,0,0,0,0,0,0,0,
  // 0x8ef8  軸
  248,142,34,36,68,37,1,252,0,3,240,0,0,1,248,0,0,0,3,240,0,0,1,248,0,0,0,3,240,0,0,1,248,0,0,0,3,240,0,0,1,248,0,0,63,255,255,255,0,1,248,0,0,63,255,255,255,0,1,248,0,0,63,255,255,255,0,1,248,0,0,0,3,240,0,0,1,248,0,0,0,3,240,0,63,255,255,255,208,5,87,249,84,63,255,255,255,208,15,255,255,253,63,255,255,255,208,15,255,255,253,63,65,248,11,208,15,66,224,61,63,1,248,11,208,15,66,224,61,63,1,248,11,208,15,66,224,61,63,1,248,11,208,15,255,255,253,63,1,248,11,208,15,255,255,253,63,1,248,11,208,15,151,245,189,63,1,248,11,208,15,66,224,61,63,1,248,11,208,15,66,224,61,63,255,255,255,208,15,171,250,189,63,255,255,255,208,15,255,255,253,63,255,255,255,208,15,255,255,253,63,1,248,11,208,0,3,240,0,63,1,248,11,208,0,3,240,0,63,1,248,11,208,0,3,240,0,63,1,248,11,208,191,255,255,255,191,1,248,11,208,191,255,255,255,191,1,248,11,208,191,255,255,255,191,1,248,11,208,0,3,240,0,63,1,248,11,208,0,3,240,0,63,255,255,255,208,0,3,240,0,63,255,255,255,208,0,3,240,0,63,255,255,255,208,0,3,240,0,63,0,0,11,208,0,3,240,0,63,0,0,7,208,0,0,0,0,0,0,0,0,0,
  // 0x8f09  載
  9,143,34,36,68,37,2,252,0,0,253,0,1,252,1,0,0,0,0,253,0,1,252,15,64,0,0,0,253,0,1,252,63,208,0,31,255,255,255,225,252,15,244,0,31,255,255,255,225,252,3,253,0,10,170,255,170,145,252,0,255,0,0,0,253,0,1,252,0,60,0,0,0,253,0,1,252,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,252,0,0,253,0,0,0,0,0,252,0,0,253,0,0,0,21,85,254,85,80,253,0,164,0,63,255,255,255,244,253,0,254,0,63,255,255,255,244,254,1,252,0,0,0,252,0,0,190,2,252,0,0,0,252,0,0,191,3,244,0,15,255,255,255,224,127,7,240,0,15,255,255,255,224,127,15,224,0,15,64,188,3,224,63,31,192,0,15,255,255,255,224,63,191,128,0,15,255,255,255,224,63,255,0,0,15,64,188,3,224,47,254,0,0,15,64,188,3,224,31,252,0,0,15,255,255,255,224,15,244,0,0,15,255,255,255,224,31,240,7,64,0,0,252,0,0,63,240,7,224,0,0,252,0,0,255,244,7,208,127,255,255,255,247,255,252,11,208,127,255,255,255,255,250,253,15,192,106,170,254,170,255,224,255,159,192,0,0,252,2,255,128,127,255,128,0,0,252,0,253,0,31,255,0,0,0,252,0,48,0,2,248,0,0,0,0,0,0,0,0,0,0,
  // 0x8f2f  輯
  47,143,35,36,68,37,1,252,0,3,240,0,0,0,0,0,0,0,3,240,0,11,255,255,255,128,0,3,240,0,11,255,255,255,128,0,3,240,0,11,250,170,191,128,63,255,255,255,11,224,0,63,128,63,255,255,255,11,224,0,63,128,63,255,255,255,11,224,0,63,128,0,3,240,0,11,255,255,255,128,0,3,240,0,11,255,255,255,128,5,87,249,84,6,170,170,170,64,15,255,255,253,0,0,0,0,0,15,255,255,253,170,170,170,170,164,15,66,224,61,191,255,255,255,248,15,66,224,61,191,255,255,255,248,15,66,224,61,7,224,0,47,64,15,255,255,253,7,224,0,47,64,15,255,255,253,7,224,0,47,64,15,151,245,189,7,255,255,255,64,15,66,224,61,7,255,255,255,64,15,66,224,61,7,245,85,127,64,15,171,250,189,7,224,0,47,64,15,255,255,253,7,224,0,47,64,15,255,255,253,7,250,170,191,64,0,3,240,0,7,255,255,255,64,0,3,240,0,7,255,255,255,64,0,3,240,0,7,224,0,47,64,191,255,255,255,135,224,0,47,64,191,255,255,255,135,224,0,47,248,191,255,255,255,139,246,175,255,248,0,3,240,2,255,255,255,255,248,0,3,240,1,255,255,255,255,128,0,3,240,0,254,165,64,47,64,0,3,240,0,0,0,0,47,64,0,3,240,0,0,0,0,47,64,0,3,240,0,0,0,0,47,64,0,0,0,0,0,0,0,0,0,
  // 0x8f38  輸
  56,143,35,35,59,37,1,253,0,11,208,0,0,7,240,0,0,0,11,208,0,0,15,252,0,0,0,11,208,0,0,31,254,0,0,0,11,208,0,0,63,191,64,0,63,255,255,252,0,255,47,208,0,63,255,255,252,2,252,15,244,0,63,255,255,252,11,244,3,253,0,0,11,208,0,47,208,0,255,128,0,11,208,0,191,128,0,63,240,26,175,234,167,255,255,255,239,252,47,255,255,251,254,255,255,227,244,47,255,255,247,226,255,255,224,176,47,7,193,245,128,0,0,0,0,47,7,193,244,0,0,0,0,0,47,7,193,244,0,0,0,2,144,47,255,255,244,255,255,0,3,224,47,255,255,244,255,255,15,67,224,47,91,214,244,250,175,15,67,224,47,7,193,244,244,15,15,67,224,47,7,193,244,244,15,15,67,224,47,91,214,244,255,255,15,67,224,47,255,255,244,255,255,15,67,224,47,255,255,244,249,111,15,67,224,0,11,208,0,244,15,15,67,224,0,11,208,0,244,15,15,67,224,0,11,208,0,255,255,15,67,224,191,255,255,252,255,255,15,67,224,191,255,255,252,249,111,15,67,224,191,255,255,252,244,15,15,67,224,0,11,208,0,244,15,5,3,224,0,11,208,0,244,15,0,3,224,0,11,208,0,244,15,0,3,224,0,11,208,0,244,111,1,171,208,0,11,208,0,244,255,2,255,192,0,11,208,0,244,189,1,254,64,
  // 0x8f49  轉
  73,143,35,36,68,37,1,252,0,3,224,0,0,2,244,0,0,0,7,240,0,0,2,244,0,0,0,7,240,0,0,2,244,0,0,0,7,240,0,255,255,255,255,240,63,255,255,253,255,255,255,255,240,63,255,255,253,170,171,250,170,160,63,255,255,253,0,2,244,0,0,0,7,240,0,63,255,255,255,192,0,7,240,0,63,255,255,255,192,5,91,245,84,62,2,244,11,192,31,255,255,252,62,2,244,11,192,31,255,255,252,63,255,255,255,192,31,3,208,188,63,255,255,255,192,31,3,208,188,62,2,244,11,192,31,3,208,188,62,2,244,11,192,31,255,255,252,63,255,255,255,192,31,255,255,252,63,255,255,255,192,31,151,229,252,0,2,244,126,0,31,3,208,188,0,2,244,63,128,31,3,208,189,255,255,255,255,208,31,171,234,253,255,255,255,255,240,31,255,255,252,254,169,85,86,244,31,255,255,252,0,0,3,240,128,0,7,240,0,0,0,3,240,0,0,7,240,1,255,255,255,255,244,0,7,240,1,255,255,255,255,244,191,255,255,255,171,170,171,250,164,191,255,255,254,11,192,3,240,0,191,255,255,254,15,240,3,240,0,0,7,240,0,3,248,3,240,0,0,7,240,0,1,252,3,240,0,0,7,240,0,0,180,3,240,0,0,7,240,0,0,7,175,240,0,0,7,240,0,0,3,255,240,0,0,7,240,0,0,3,255,128,0,0,0,0,0,0,0,0,0,0,
  // 0x8fd1  近
  209,143,35,35,59,37,1,253,0,0,0,0,0,0,0,96,0,3,64,0,0,0,0,111,252,0,15,224,0,4,1,175,255,255,0,31,252,0,15,255,255,255,244,0,7,255,0,15,255,255,233,0,0,0,255,192,15,255,148,0,0,0,0,63,224,15,224,0,0,0,0,0,15,208,15,224,0,0,0,0,0,3,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,255,255,255,255,240,0,0,0,15,255,255,255,255,240,0,0,0,15,255,255,255,255,240,0,0,0,15,224,0,254,0,0,63,255,192,15,208,0,254,0,0,63,255,192,15,192,0,254,0,0,63,255,192,31,192,0,254,0,0,0,31,192,47,192,0,254,0,0,0,31,192,63,128,0,254,0,0,0,31,192,63,64,0,254,0,0,0,31,192,191,0,0,254,0,0,0,31,192,254,0,0,254,0,0,0,31,194,253,0,0,254,0,0,0,31,195,252,0,0,254,0,0,0,31,207,244,0,0,254,0,0,0,31,199,224,0,0,254,0,0,0,63,225,192,0,0,254,0,0,1,255,248,0,0,0,254,0,0,11,255,255,64,0,0,0,0,0,127,248,191,254,85,85,85,85,100,127,208,47,255,255,255,255,255,244,63,64,2,255,255,255,255,255,240,28,0,0,27,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x8fd4  返
  212,143,35,34,50,37,1,253,3,64,0,0,0,0,0,0,0,31,208,0,63,255,255,255,255,192,31,248,0,63,255,255,255,255,192,7,254,0,63,255,255,255,255,192,1,255,128,63,64,0,0,0,0,0,127,208,63,64,0,0,0,0,0,31,192,63,64,0,0,0,0,0,11,0,63,64,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,255,255,255,254,0,0,0,0,63,255,255,255,255,0,0,0,0,63,255,255,255,254,0,0,0,0,63,127,64,1,252,0,0,0,0,63,111,192,3,252,0,63,255,128,63,79,208,7,244,0,63,255,128,63,11,240,15,240,0,63,255,128,127,7,244,31,208,0,0,47,128,127,2,252,63,192,0,0,47,128,190,0,255,255,64,0,0,47,128,253,0,127,254,0,0,0,47,129,252,0,47,252,0,0,0,47,130,252,0,63,252,0,0,0,47,131,248,1,255,255,64,0,0,47,135,240,11,255,255,240,0,0,47,143,224,191,248,47,255,64,0,47,159,195,255,208,7,255,240,0,127,211,129,254,0,0,191,224,2,255,244,0,224,0,0,11,192,11,255,255,64,0,0,0,0,0,127,244,255,250,84,0,5,85,84,127,208,63,255,255,255,255,255,240,63,0,7,255,255,255,255,255,240,28,0,0,27,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x9000  退
  0,144,35,33,41,37,1,253,7,208,0,31,255,255,255,252,0,31,244,0,31,255,255,255,252,0,11,254,0,31,255,255,255,252,0,1,255,192,31,192,0,1,252,0,0,63,240,31,192,0,1,252,0,0,15,224,31,234,170,171,252,0,0,3,64,31,255,255,255,252,0,0,0,0,31,255,255,255,252,0,0,0,0,31,192,0,1,252,0,0,0,0,31,192,0,1,252,0,0,0,0,31,192,0,1,252,0,0,0,0,31,255,255,255,252,0,0,0,0,31,255,255,255,252,0,63,255,192,31,255,255,255,252,0,63,255,192,31,192,63,64,15,64,63,255,192,31,192,47,192,127,208,0,31,192,31,192,15,210,255,64,0,31,192,31,192,11,255,252,0,0,31,192,31,192,7,255,208,0,0,31,192,31,192,2,255,0,0,0,31,192,31,192,0,255,64,0,0,31,192,31,193,174,127,208,0,0,31,192,31,255,255,31,248,0,0,31,193,255,255,255,7,255,144,0,31,194,255,255,144,1,255,240,0,63,225,255,144,0,0,47,192,1,255,248,144,0,0,0,3,64,11,255,255,64,0,0,0,0,0,127,248,191,254,85,85,85,85,100,127,208,47,255,255,255,255,255,244,63,64,2,255,255,255,255,255,240,28,0,0,27,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x901f  速
  31,144,35,35,59,37,1,253,0,0,0,0,0,190,0,0,0,2,64,0,0,0,190,0,0,0,15,208,0,0,0,190,0,0,0,47,248,0,0,0,190,0,0,0,7,254,3,255,255,255,255,255,240,1,255,131,255,255,255,255,255,240,0,63,227,255,255,255,255,255,224,0,15,208,0,0,190,0,0,0,0,3,0,0,0,190,0,0,0,0,0,0,106,170,255,170,170,0,0,0,0,191,255,255,255,255,64,0,0,0,191,255,255,255,255,64,0,0,0,189,0,190,0,63,64,0,0,0,189,0,190,0,63,64,0,0,0,189,0,190,0,63,64,63,255,192,189,0,190,0,63,64,63,255,192,191,170,255,170,191,64,63,255,192,191,255,255,255,255,64,0,31,192,191,255,255,255,255,64,0,31,192,0,11,255,224,0,0,0,31,192,0,47,255,248,0,0,0,31,192,0,127,255,254,0,0,0,31,192,2,253,190,127,128,0,0,31,192,11,248,190,31,244,0,0,31,192,127,224,190,7,254,0,0,31,199,255,128,190,1,255,224,0,31,199,253,0,190,0,63,208,0,63,226,240,0,190,0,11,128,1,255,248,64,0,190,0,1,0,11,255,255,64,0,85,0,0,0,127,248,191,254,85,85,85,85,100,127,208,47,255,255,255,255,255,244,63,64,2,255,255,255,255,255,240,28,0,0,27,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x9023  連
  35,144,34,35,59,37,1,253,0,0,0,0,0,253,0,0,0,3,0,0,0,0,253,0,0,0,31,208,0,0,0,253,0,0,0,31,244,11,255,255,255,255,255,208,7,253,11,255,255,255,255,255,208,1,255,75,255,255,255,255,255,208,0,127,192,0,0,253,0,0,0,0,31,128,0,0,253,0,0,0,0,9,0,255,255,255,255,254,0,0,0,0,255,255,255,255,254,0,0,0,0,254,85,254,85,254,0,0,0,0,252,0,253,0,190,0,0,0,0,252,0,253,0,190,0,0,0,0,255,255,255,255,254,0,0,0,0,255,255,255,255,254,0,63,255,64,253,85,254,85,254,0,63,255,64,252,0,253,0,190,0,63,255,64,252,0,253,0,190,0,0,63,64,255,255,255,255,254,0,0,63,64,255,255,255,255,254,0,0,63,64,85,85,254,85,85,0,0,63,64,0,0,253,0,0,0,0,63,64,0,0,253,0,0,0,0,63,79,255,255,255,255,255,240,0,63,79,255,255,255,255,255,240,0,63,79,255,255,255,255,255,224,0,63,128,0,0,253,0,0,0,0,127,192,0,0,253,0,0,0,1,255,240,0,0,253,0,0,0,11,255,254,0,0,168,0,0,0,63,244,255,249,64,0,0,5,80,127,192,63,255,255,255,255,255,240,63,0,7,255,255,255,255,255,240,28,0,0,107,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x9032  進
  50,144,34,35,59,37,1,253,0,0,0,0,144,0,64,0,0,2,0,0,2,253,0,254,0,0,15,192,0,3,252,1,253,0,0,47,244,0,7,244,2,252,0,0,11,253,0,15,240,3,248,0,0,2,255,0,47,224,7,240,0,0,0,191,192,63,255,255,255,255,192,0,47,192,255,255,255,255,255,192,0,15,3,255,255,255,255,255,192,0,0,11,255,64,15,208,0,0,0,0,47,255,64,15,208,0,0,0,0,191,255,64,15,208,0,0,0,0,255,127,255,255,255,255,0,0,0,61,63,255,255,255,255,0,0,0,4,63,255,255,255,255,0,63,255,64,63,64,15,208,0,0,63,255,64,63,64,15,208,0,0,63,255,64,63,64,15,208,0,0,0,63,64,63,255,255,255,255,0,0,63,64,63,255,255,255,255,0,0,63,64,63,255,255,255,255,0,0,63,64,63,64,15,208,0,0,0,63,64,63,64,15,208,0,0,0,63,64,63,64,15,208,0,0,0,63,64,63,64,15,208,0,0,0,63,64,63,255,255,255,255,224,0,63,128,63,255,255,255,255,224,0,127,192,63,255,255,255,255,224,1,255,240,0,0,0,0,0,0,11,255,254,0,0,0,0,0,0,63,244,255,249,64,0,0,5,80,127,192,63,255,255,255,255,255,240,63,0,7,255,255,255,255,255,240,28,0,0,107,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x904b  運
  75,144,34,34,50,37,1,253,2,0,2,170,170,170,170,170,128,31,208,7,255,255,255,255,255,208,47,244,7,255,255,255,255,255,208,11,253,7,224,0,84,0,11,208,2,255,7,224,0,254,0,11,208,0,191,193,80,0,254,0,5,64,0,47,194,255,255,255,255,255,64,0,15,2,255,255,255,255,255,64,0,0,1,85,85,255,85,85,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,191,255,255,255,254,0,0,0,0,191,255,255,255,254,0,0,0,0,189,0,254,0,190,0,63,255,64,189,0,254,0,190,0,63,255,64,191,255,255,255,254,0,63,255,64,191,255,255,255,254,0,0,63,64,189,0,254,0,190,0,0,63,64,189,0,254,0,190,0,0,63,64,191,255,255,255,254,0,0,63,64,191,255,255,255,254,0,0,63,64,0,0,254,0,0,0,0,63,64,0,0,254,0,0,0,0,63,74,170,170,255,170,170,160,0,63,79,255,255,255,255,255,240,0,63,143,255,255,255,255,255,240,0,127,192,0,0,254,0,0,0,1,255,240,0,0,254,0,0,0,11,255,254,0,0,254,0,0,0,63,244,255,249,64,0,0,5,80,127,192,63,255,255,255,255,255,240,63,0,7,255,255,255,255,255,240,28,0,0,107,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x9054  達
  84,144,34,35,59,37,1,253,0,0,0,0,0,254,0,0,0,3,64,0,0,0,254,0,0,0,31,208,0,21,85,255,85,85,0,31,248,0,191,255,255,255,254,0,7,254,0,191,255,255,255,254,0,0,255,64,0,0,254,0,0,0,0,127,192,0,0,254,0,0,0,0,31,138,170,170,255,170,170,160,0,10,15,255,255,255,255,255,240,0,0,15,255,255,255,255,255,240,0,0,0,3,240,0,31,192,0,0,0,0,3,244,0,47,192,0,0,0,0,2,252,0,63,64,0,0,0,0,0,252,0,127,0,0,0,0,7,255,255,255,255,255,224,63,255,71,255,255,255,255,255,224,63,255,66,170,170,255,170,170,144,63,255,64,0,0,254,0,0,0,0,63,64,85,85,255,85,85,0,0,63,64,255,255,255,255,255,0,0,63,64,255,255,255,255,255,0,0,63,64,0,0,254,0,0,0,0,63,64,0,0,254,0,0,0,0,63,70,170,170,255,170,170,144,0,63,75,255,255,255,255,255,224,0,63,75,255,255,255,255,255,224,0,63,128,0,0,254,0,0,0,0,127,192,0,0,254,0,0,0,1,255,240,0,0,254,0,0,0,11,255,254,0,0,0,0,0,0,63,244,255,249,64,0,0,5,80,127,192,63,255,255,255,255,255,240,63,0,7,255,255,255,255,255,240,28,0,0,107,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x9078  選
  120,144,35,34,50,37,1,253,11,0,1,85,85,5,85,85,0,63,192,15,255,255,143,255,255,128,47,240,15,255,255,143,255,255,128,11,252,0,0,31,128,0,31,128,2,255,1,85,111,129,85,111,128,0,191,135,255,255,131,255,255,128,0,63,71,255,255,131,255,255,128,0,24,7,224,0,3,224,0,0,0,0,7,224,2,147,224,1,224,0,0,3,245,87,227,245,86,240,0,0,3,255,255,211,255,255,240,0,0,1,255,255,128,191,255,192,0,0,0,0,168,0,105,0,0,0,0,0,0,252,0,190,0,0,127,255,0,0,252,0,190,0,0,127,255,7,255,255,255,255,255,192,127,255,7,255,255,255,255,255,192,0,63,2,170,254,170,255,170,128,0,63,0,0,252,0,190,0,0,0,63,0,0,252,0,190,0,0,0,63,26,170,254,170,255,170,160,0,63,31,255,255,255,255,255,240,0,63,31,255,255,255,255,255,240,0,63,0,0,100,0,24,0,0,0,63,0,2,254,0,191,128,0,0,63,0,47,248,0,47,248,0,0,127,130,255,208,0,7,255,0,2,255,227,254,0,0,0,191,208,11,255,252,160,0,0,0,30,0,63,241,255,228,0,0,0,0,0,191,192,127,255,255,255,255,255,244,63,0,11,255,255,255,255,255,240,44,0,0,111,255,255,255,255,240,0,0,0,0,0,0,0,0,0,
  // 0x9084  還
  132,144,34,34,50,37,1,253,7,64,2,255,255,255,255,255,0,31,224,2,255,255,255,255,255,0,31,248,2,244,47,3,240,63,0,3,254,2,244,47,3,240,63,0,0,255,130,244,47,3,240,63,0,0,63,210,255,255,255,255,255,0,0,31,66,255,255,255,255,255,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,240,0,0,47,255,255,255,255,255,240,0,0,5,85,85,85,85,85,80,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,252,0,63,255,64,127,255,255,255,252,0,63,255,64,126,0,0,1,252,0,63,255,64,126,0,0,1,252,0,0,63,64,126,0,0,1,252,0,0,63,64,127,255,255,255,252,0,0,63,64,127,255,255,255,254,0,0,63,64,0,15,253,0,63,192,0,63,64,0,127,255,65,255,0,0,63,64,2,255,255,235,248,0,0,63,64,47,253,255,255,208,0,0,63,71,255,209,252,255,224,0,0,63,139,254,1,252,47,255,144,0,127,195,224,1,252,2,255,208,1,255,240,0,1,252,0,47,128,11,255,254,0,1,252,0,0,0,63,244,255,249,64,0,0,5,80,127,192,63,255,255,255,255,255,240,63,0,7,255,255,255,255,255,240,28,0,0,107,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x908a  邊
  138,144,35,35,59,37,1,253,0,64,0,0,0,185,0,0,0,2,224,0,0,0,253,0,0,0,11,253,0,63,255,255,255,252,0,2,255,128,63,170,170,171,252,0,0,127,224,63,64,0,1,252,0,0,15,224,63,255,255,255,252,0,0,3,128,63,170,170,170,252,0,0,0,0,63,64,0,1,252,0,1,0,0,63,255,255,255,252,0,15,192,0,63,170,170,170,252,0,63,248,0,63,64,0,1,252,0,11,255,0,63,255,255,255,252,0,1,255,192,42,170,254,170,168,0,0,63,0,0,0,253,0,0,0,0,8,11,255,255,255,255,255,224,0,0,11,255,255,255,255,255,224,0,0,11,208,62,7,192,107,224,0,0,5,70,252,7,255,255,224,127,255,65,255,224,255,255,244,0,127,255,64,249,0,253,0,0,0,127,255,64,0,0,253,0,0,0,0,63,79,255,255,255,255,255,240,0,63,79,255,255,255,255,255,240,0,63,64,0,63,0,0,0,0,0,63,64,0,63,255,255,240,0,0,63,64,0,255,255,255,240,0,0,63,64,7,248,0,7,224,0,0,127,129,191,224,0,11,208,0,1,255,227,255,64,47,255,192,0,11,255,250,228,0,31,255,0,0,63,245,255,229,0,0,0,0,80,191,192,127,255,255,255,255,255,244,63,0,11,255,255,255,255,255,240,28,0,0,111,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x90e8  部
  232,144,35,35,59,37,1,253,0,0,106,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,63,255,255,192,0,0,127,0,0,63,255,255,244,47,255,255,255,252,63,255,255,240,47,255,255,255,252,63,64,31,240,47,255,255,255,252,63,0,31,208,0,0,0,4,0,63,0,47,192,0,252,0,31,192,63,0,63,128,0,252,0,47,128,63,0,127,0,0,189,0,63,64,63,0,254,0,0,126,0,63,0,63,0,253,0,0,63,0,126,0,63,2,252,0,0,63,0,253,0,63,3,244,0,0,36,0,24,0,63,7,240,0,127,255,255,255,254,63,11,240,0,127,255,255,255,254,63,2,252,0,127,255,255,255,254,63,0,255,0,0,0,0,0,0,63,0,63,64,0,0,0,0,0,63,0,47,192,0,0,0,0,0,63,0,15,208,3,255,255,255,224,63,0,11,224,3,255,255,255,224,63,0,7,240,3,255,255,255,224,63,0,7,240,3,240,0,11,224,63,0,7,240,3,240,0,11,224,63,0,11,240,3,240,0,11,224,63,0,31,240,3,240,0,11,224,63,15,255,224,3,240,0,11,224,63,15,255,192,3,240,0,11,224,63,11,255,0,3,255,255,255,224,63,1,80,0,3,255,255,255,224,63,0,0,0,3,255,255,255,224,63,0,0,0,3,240,0,11,224,63,0,0,0,3,240,0,11,224,63,0,0,0,
  // 0x91cb  釋
  203,145,35,36,68,37,1,252,0,0,27,192,0,0,0,0,0,0,107,255,244,85,85,85,85,64,63,255,255,209,255,255,255,255,208,63,255,228,1,255,255,255,255,208,41,75,208,1,244,60,31,11,208,0,7,208,145,244,60,31,11,208,11,7,208,253,244,60,31,11,208,31,71,209,249,249,189,111,95,208,15,135,210,245,255,255,255,255,208,15,199,211,241,255,255,255,255,208,11,199,211,208,0,3,240,0,0,7,215,215,192,0,3,240,0,0,3,135,215,128,63,255,255,255,0,0,7,208,0,63,255,255,255,0,127,255,255,252,21,91,245,85,0,127,255,255,252,0,3,240,0,0,127,255,255,253,85,91,245,85,80,0,47,208,7,255,255,255,255,244,0,63,224,7,255,255,255,255,244,0,127,248,0,11,192,0,248,0,0,191,255,0,7,208,2,244,0,0,255,255,192,3,240,3,224,0,2,251,223,240,2,240,7,192,0,3,231,211,247,255,255,255,255,240,11,215,208,243,255,255,255,255,240,31,199,208,65,85,91,245,85,80,63,71,208,0,0,3,240,0,0,191,7,208,0,0,3,240,0,0,125,7,208,0,255,255,255,255,192,40,7,208,0,255,255,255,255,192,16,7,208,0,85,91,245,85,64,0,7,208,0,0,3,240,0,0,0,7,208,0,0,3,240,0,0,0,7,208,0,0,3,240,0,0,0,7,208,0,0,3,240,0,0,0,0,0,0,0,0,0,0,0,
  // 0x91cd  重
  205,145,33,34,50,37,2,254,0,0,0,0,0,0,90,0,0,0,0,0,5,106,255,255,64,0,2,191,255,255,255,255,255,192,0,2,255,255,255,255,255,233,0,0,1,255,169,91,244,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,170,170,170,175,254,170,170,170,128,0,0,0,7,240,0,0,0,0,0,85,85,91,245,85,85,64,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,253,0,7,240,0,15,208,0,0,253,0,7,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,253,0,11,240,0,31,208,0,0,253,0,7,240,0,15,208,0,0,253,0,7,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,85,85,91,245,85,85,64,0,0,0,0,7,240,0,0,0,0,2,170,170,175,250,170,170,164,0,3,255,255,255,255,255,255,248,0,3,255,255,255,255,255,255,248,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x91cf  量
  207,145,33,33,41,37,2,254,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,0,0,0,0,63,64,0,0,127,0,0,0,0,63,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,0,0,0,0,63,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,170,170,170,170,170,170,170,170,128,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,252,0,3,240,0,15,208,0,0,252,0,3,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,252,0,3,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,0,0,3,240,0,0,0,0,0,0,0,3,240,0,0,0,0,3,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,1,85,85,87,245,85,85,80,0,0,0,0,3,240,0,0,0,0,170,170,170,171,250,170,170,170,128,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x91dd  針
  221,145,35,35,59,37,1,253,0,3,252,0,0,0,169,0,0,0,7,255,0,0,0,253,0,0,0,15,255,208,0,0,253,0,0,0,31,255,244,0,0,253,0,0,0,63,199,253,0,0,253,0,0,0,191,1,255,64,0,253,0,0,1,254,0,127,192,0,253,0,0,3,252,0,47,224,0,253,0,0,15,240,0,11,128,0,253,0,0,63,208,0,2,0,0,253,0,0,255,255,255,252,0,0,253,0,0,63,255,255,252,0,0,253,0,0,5,255,255,252,21,85,254,85,80,0,1,252,0,127,255,255,255,248,0,1,252,0,127,255,255,255,248,0,1,252,0,127,255,255,255,248,47,255,255,255,128,0,253,0,0,47,255,255,255,128,0,253,0,0,47,255,255,255,128,0,253,0,0,0,1,252,0,0,0,253,0,0,0,1,252,20,0,0,253,0,0,11,129,252,47,0,0,253,0,0,11,193,252,63,0,0,253,0,0,7,209,252,62,0,0,253,0,0,3,225,252,125,0,0,253,0,0,3,225,252,188,0,0,253,0,0,2,241,252,248,0,0,253,0,0,2,241,252,32,0,0,253,0,0,0,1,252,26,128,0,253,0,0,0,2,255,255,192,0,253,0,0,26,255,255,255,192,0,253,0,0,63,255,255,250,64,0,253,0,0,63,255,229,0,0,0,253,0,0,46,144,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,
  // 0x9215  鈕
  21,146,35,35,59,37,1,253,0,11,224,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,47,255,0,127,255,255,255,0,0,127,127,192,127,255,255,254,0,0,254,31,224,127,255,255,254,0,2,252,7,248,21,191,85,190,0,7,244,1,253,0,191,0,190,0,31,224,0,191,0,190,0,190,0,127,192,0,60,0,190,0,190,0,191,255,255,244,0,190,0,190,0,47,255,255,224,0,253,0,254,0,7,255,255,224,0,253,0,254,0,0,7,224,0,0,253,0,253,0,0,7,224,0,0,253,0,253,0,0,7,224,0,0,252,0,253,0,0,7,224,0,85,253,85,254,80,63,255,255,249,255,255,255,255,248,63,255,255,249,255,255,255,255,248,63,255,255,249,255,255,255,255,248,0,7,224,0,2,248,0,253,0,1,7,224,144,2,248,0,252,0,15,7,224,248,2,248,0,252,0,15,135,225,240,3,244,0,252,0,11,199,226,240,3,244,1,252,0,7,199,227,224,3,240,1,252,0,7,215,227,208,3,240,1,252,0,3,215,231,192,3,240,1,252,0,3,135,225,64,7,240,1,252,0,0,7,224,20,7,240,2,252,0,0,7,251,253,11,224,2,252,0,5,191,255,254,91,229,87,253,80,63,255,255,255,255,255,255,255,248,63,255,228,15,255,255,255,255,248,46,144,0,15,255,255,255,255,248,0,0,0,0,0,0,0,0,0,
  // 0x932f  錯
  47,147,35,35,59,37,1,253,0,11,240,0,2,244,3,240,0,0,15,252,0,2,244,3,240,0,0,47,255,0,2,244,3,240,0,0,127,191,192,2,244,3,240,0,0,254,31,240,2,244,3,240,0,2,252,7,252,255,255,255,255,224,7,244,2,254,255,255,255,255,224,31,224,0,190,255,255,255,255,224,127,192,0,60,2,244,3,240,0,191,255,255,240,2,244,3,240,0,47,255,255,224,2,244,3,240,0,7,255,255,224,2,244,3,240,0,0,7,224,0,2,244,7,240,0,0,7,224,7,255,255,255,255,248,0,7,224,7,255,255,255,255,248,0,7,224,7,255,255,255,255,248,63,255,255,248,0,0,0,0,0,63,255,255,248,0,0,0,0,0,63,255,255,248,31,255,255,255,64,0,7,224,0,47,255,255,255,64,0,7,224,64,47,255,255,255,64,11,7,224,248,47,128,0,63,64,15,71,225,244,47,128,0,63,64,15,135,226,240,47,128,0,63,64,11,199,227,224,47,234,170,191,64,7,199,227,208,47,255,255,255,64,3,215,231,192,47,255,255,255,64,3,215,225,128,47,128,0,63,64,0,7,224,88,47,128,0,63,64,0,7,255,253,47,128,0,63,64,26,255,255,253,47,255,255,255,64,63,255,255,228,47,255,255,255,64,63,255,144,0,47,255,255,255,64,46,64,0,0,47,128,0,63,64,0,0,0,0,26,64,0,42,64,
  // 0x9375  鍵
  117,147,35,35,59,37,1,253,0,15,128,0,0,0,42,0,0,0,47,240,0,0,0,63,0,0,0,63,248,0,0,0,63,0,0,0,127,253,63,255,26,191,170,128,0,253,191,127,255,31,255,255,192,2,252,63,255,253,31,255,255,192,7,240,15,224,188,0,63,11,192,31,208,3,208,252,0,63,11,192,127,128,2,64,248,255,255,255,248,255,255,255,2,244,255,255,255,248,63,255,255,3,240,170,191,175,248,27,255,255,3,224,0,63,11,192,0,31,128,11,208,0,63,11,192,0,31,128,15,192,26,191,175,192,0,31,128,15,255,223,255,255,192,0,31,128,47,255,159,255,255,192,63,255,255,191,255,128,63,0,0,63,255,255,134,15,128,63,0,0,63,255,255,128,31,111,255,255,192,0,31,128,10,31,63,255,255,208,0,31,133,47,47,63,255,255,208,31,31,143,159,63,0,63,0,0,31,31,143,79,126,0,63,0,0,15,31,143,15,253,0,63,0,0,15,95,159,11,252,255,255,255,240,11,159,174,7,252,255,255,255,240,11,159,173,3,244,191,255,255,240,7,159,128,3,248,0,63,0,0,0,31,128,71,253,0,63,0,0,0,31,255,223,255,128,63,0,0,43,255,255,255,175,249,0,0,0,127,255,255,254,11,255,255,255,248,63,249,7,252,1,255,255,255,244,20,0,2,240,0,27,255,255,240,0,0,0,128,0,0,0,0,0,
  // 0x9577  長
  119,149,33,35,59,37,2,252,0,11,255,255,255,255,255,192,0,0,11,255,255,255,255,255,208,0,0,11,255,255,255,255,255,208,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,255,255,255,255,255,0,0,0,11,255,255,255,255,255,0,0,0,11,250,170,170,170,170,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,250,170,170,170,170,0,0,0,11,255,255,255,255,255,0,0,0,11,255,255,255,255,255,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,11,240,3,248,0,0,208,0,0,11,240,2,252,0,3,248,0,0,11,240,0,254,0,47,248,0,0,11,240,0,127,65,255,208,0,0,11,240,0,63,219,255,0,0,0,11,240,0,15,255,244,0,0,0,11,240,0,7,255,64,0,0,0,11,240,0,2,255,208,0,0,0,11,240,26,252,127,248,0,0,0,11,255,255,252,31,255,144,0,11,255,255,255,252,3,255,255,64,15,255,255,249,64,0,127,255,192,11,255,164,0,0,0,7,255,64,6,64,0,0,0,0,0,26,0,0,0,0,0,0,0,0,0,0,
  // 0x9589  閉
  137,149,31,34,16,37,3,253,106,170,170,160,42,170,170,168,191,255,255,240,63,255,255,252,191,255,255,240,63,255,255,252,190,0,7,240,63,0,2,252,190,0,7,240,63,0,2,252,190,0,7,240,63,0,2,252,191,255,255,240,63,255,255,252,191,255,255,240,63,255,255,252,191,85,91,240,63,149,87,252,190,0,7,240,63,0,2,252,190,0,7,240,63,0,2,252,191,255,255,240,63,170,171,252,191,255,255,240,63,255,255,252,191,170,170,160,63,255,255,252,190,0,0,0,84,0,2,252,190,0,0,0,189,0,2,252,190,0,0,0,189,0,2,252,190,0,0,0,189,0,2,252,190,11,255,255,255,255,130,252,190,11,255,255,255,255,130,252,190,11,255,255,255,255,130,252,190,0,0,11,253,0,2,252,190,0,0,47,253,0,2,252,190,0,0,191,253,0,2,252,190,0,3,253,189,0,2,252,190,0,31,244,189,0,2,252,190,0,191,208,189,0,2,252,190,7,255,0,189,0,2,252,190,31,252,0,189,0,2,252,190,11,208,0,189,0,2,252,190,2,0,127,253,21,87,252,190,0,0,63,252,47,255,248,190,0,0,47,224,15,255,240,190,0,0,0,0,15,255,128,
  // 0x958b  開
  139,149,31,35,24,37,3,252,106,170,170,160,42,170,170,164,191,255,255,240,63,255,255,252,191,255,255,240,63,255,255,252,190,0,3,240,63,0,2,252,190,0,3,240,63,0,2,252,191,85,87,240,63,85,86,252,191,255,255,240,63,255,255,252,191,255,255,240,63,255,255,252,190,0,3,240,63,0,2,252,190,0,3,240,63,0,2,252,190,0,3,240,63,0,2,252,191,255,255,240,63,255,255,252,191,255,255,240,63,255,255,252,191,170,170,160,42,170,171,252,190,0,0,0,0,0,2,252,190,0,0,0,0,0,2,252,190,7,255,255,255,255,66,252,190,7,255,255,255,255,66,252,190,6,175,250,191,234,66,252,190,0,15,192,31,128,2,252,190,0,15,192,31,128,2,252,190,0,15,192,31,128,2,252,190,15,255,255,255,255,194,252,190,15,255,255,255,255,194,252,190,15,255,255,255,255,194,252,190,0,15,192,31,128,2,252,190,0,31,192,31,128,2,252,190,0,47,128,31,128,2,252,190,0,63,0,31,128,2,252,190,0,254,0,31,128,2,252,190,2,252,0,31,129,87,252,190,11,248,0,31,135,255,248,190,3,224,0,31,131,255,244,190,0,128,0,0,2,255,128,0,0,0,0,0,0,0,0,
  // 0x9593  間
  147,149,31,34,16,37,3,253,106,170,170,160,42,170,170,168,191,255,255,240,63,255,255,252,191,255,255,240,63,255,255,252,190,0,7,240,63,0,2,252,190,0,7,240,63,0,2,252,190,0,7,240,63,0,2,252,191,255,255,240,63,255,255,252,191,255,255,240,63,255,255,252,191,85,91,240,63,149,87,252,190,0,7,240,63,0,2,252,190,0,7,240,63,0,2,252,191,255,255,240,63,170,171,252,191,255,255,240,63,255,255,252,191,170,170,160,63,255,255,252,190,0,0,0,0,0,2,252,190,0,0,0,0,0,2,252,190,0,106,170,170,160,2,252,190,0,127,255,255,244,2,252,190,0,127,255,255,244,2,252,190,0,126,0,3,244,2,252,190,0,126,0,3,244,2,252,190,0,126,0,3,244,2,252,190,0,127,255,255,244,2,252,190,0,127,255,255,244,2,252,190,0,127,170,171,244,2,252,190,0,126,0,3,244,2,252,190,0,126,0,3,244,2,252,190,0,126,0,3,244,2,252,190,0,127,255,255,244,2,252,190,0,127,255,255,244,2,252,190,0,127,170,170,169,87,252,190,0,126,0,0,15,255,248,190,0,21,0,0,11,255,240,190,0,0,0,0,7,255,128,
  // 0x95dc  關
  220,149,31,34,16,37,3,253,85,85,85,80,21,85,85,84,191,255,255,240,63,255,255,252,191,255,255,240,63,255,255,252,190,0,3,240,63,0,1,252,190,0,3,240,63,0,1,252,190,0,7,240,63,64,1,252,191,255,255,240,63,255,255,252,191,255,255,240,63,255,255,252,190,0,3,240,63,0,1,252,190,0,3,240,63,0,1,252,191,255,255,240,63,255,255,252,191,255,255,240,63,255,255,252,190,85,111,80,27,213,86,252,190,0,62,0,15,128,1,252,190,1,188,0,111,0,1,252,190,15,240,247,252,61,1,252,190,7,227,226,248,188,1,252,190,1,255,128,191,240,1,252,190,0,190,96,47,218,1,252,190,0,60,180,15,15,1,252,190,0,254,252,62,191,193,252,190,31,255,255,255,255,193,252,190,30,148,31,233,66,209,252,190,1,64,244,188,0,1,252,190,3,192,244,188,15,1,252,190,3,192,244,188,15,1,252,190,3,192,244,188,15,1,252,190,3,255,240,191,255,1,252,190,3,255,240,191,255,1,252,190,0,3,240,188,0,1,252,190,0,15,208,188,0,86,252,190,0,191,128,188,0,255,252,190,0,253,0,188,0,255,244,190,0,16,0,0,0,191,144,
  // 0x964d  降
  77,150,33,35,59,37,3,253,0,0,0,0,11,144,0,0,0,0,0,0,0,15,208,0,0,0,255,255,224,0,63,192,0,0,0,255,255,252,0,191,234,171,128,0,255,255,244,1,255,255,255,240,0,252,3,240,7,255,255,255,208,0,252,7,240,31,248,0,63,192,0,252,11,208,127,253,0,127,0,0,252,15,194,255,191,1,254,0,0,252,31,195,252,63,199,252,0,0,252,47,64,224,15,255,240,0,0,252,63,0,0,3,255,192,0,0,252,126,0,0,3,255,208,0,0,252,126,0,0,47,255,253,0,0,252,63,64,6,255,235,255,228,0,252,15,193,191,255,0,191,255,128,252,11,227,255,244,10,175,255,0,252,3,241,254,64,15,208,125,0,252,3,240,144,0,15,208,0,0,252,2,244,127,255,255,255,252,0,252,2,244,191,255,255,255,252,0,252,2,244,191,255,255,255,252,0,252,3,244,3,240,15,208,0,0,252,255,240,3,240,15,208,0,0,252,191,224,3,240,15,208,0,0,252,191,64,3,240,15,208,0,0,252,0,7,255,255,255,255,255,0,252,0,7,255,255,255,255,255,0,252,0,7,255,255,255,255,255,0,252,0,0,0,0,15,208,0,0,252,0,0,0,0,15,208,0,0,252,0,0,0,0,15,208,0,0,252,0,0,0,0,15,208,0,0,252,0,0,0,0,15,208,0,0,252,0,0,0,0,15,208,0,0,
  // 0x9664  除
  100,150,33,35,59,37,3,253,0,0,0,0,2,164,0,0,0,0,0,0,0,11,253,0,0,0,255,255,224,0,15,255,0,0,0,255,255,252,0,63,255,192,0,0,255,255,244,0,191,31,224,0,0,252,3,240,2,254,11,248,0,0,252,7,240,11,248,2,254,0,0,252,11,208,47,240,0,191,192,0,252,15,192,191,192,0,47,240,0,252,31,135,254,0,0,11,254,0,252,47,95,248,0,0,2,255,128,252,63,15,239,255,255,255,191,0,252,126,11,79,255,255,255,13,0,252,127,0,15,255,255,255,0,0,252,47,128,0,2,248,0,0,0,252,15,192,0,2,248,0,0,0,252,11,224,0,2,248,0,0,0,252,3,240,0,2,248,0,0,0,252,3,241,255,255,255,255,252,0,252,2,245,255,255,255,255,252,0,252,2,245,255,255,255,255,252,0,252,2,244,0,2,248,0,0,0,252,3,244,0,2,248,0,0,0,252,255,240,47,66,248,31,0,0,252,191,224,63,2,248,63,128,0,252,191,64,191,2,248,31,208,0,252,0,0,253,2,248,11,240,0,252,0,2,252,2,248,3,244,0,252,0,7,244,2,248,1,252,0,252,0,15,224,2,248,0,254,0,252,0,63,192,2,248,0,127,0,252,0,31,64,3,248,0,62,0,252,0,1,1,255,248,0,16,0,252,0,0,0,255,240,0,0,0,252,0,0,0,255,128,0,0,0,
  // 0x968e  階
  142,150,33,35,59,37,3,253,0,0,0,84,0,5,64,0,0,0,0,0,252,0,15,192,0,0,255,255,224,252,0,15,192,0,0,255,255,248,252,0,15,192,116,0,255,255,240,252,0,15,194,253,0,252,7,240,255,255,79,239,253,0,252,11,224,255,255,79,255,208,0,252,15,208,255,255,79,253,0,0,252,15,192,252,0,15,192,0,0,252,31,128,252,0,15,192,0,0,252,47,0,252,0,15,192,13,0,252,63,0,252,1,79,192,15,128,252,126,0,254,191,143,192,31,128,252,126,6,255,255,207,255,255,64,252,63,79,255,253,15,255,255,0,252,15,207,254,67,150,255,252,0,252,11,214,64,7,240,0,0,0,252,7,240,0,11,240,0,0,0,252,3,240,0,15,224,0,0,0,252,3,240,127,255,255,255,248,0,252,3,240,127,255,255,255,248,0,252,3,240,127,255,255,255,248,0,252,7,240,127,0,0,2,248,0,252,255,240,127,0,0,2,248,0,252,191,208,127,0,0,2,248,0,252,190,64,127,255,255,255,248,0,252,0,0,127,255,255,255,248,0,252,0,0,127,170,170,171,248,0,252,0,0,127,0,0,2,248,0,252,0,0,127,0,0,2,248,0,252,0,0,127,0,0,2,248,0,252,0,0,127,255,255,255,248,0,252,0,0,127,255,255,255,248,0,252,0,0,127,255,255,255,248,0,252,0,0,127,0,0,2,248,0,
  // 0x96d9  雙
  217,150,34,36,68,37,1,252,0,25,1,0,0,41,0,0,0,0,63,3,240,0,63,11,208,0,0,126,11,208,0,189,15,192,0,0,253,15,192,0,252,31,64,0,1,255,255,255,194,255,255,255,208,3,255,255,255,199,255,255,255,208,11,249,111,149,79,249,111,85,64,31,248,31,64,47,244,47,0,0,127,255,255,255,255,255,255,255,128,63,255,255,255,255,255,255,255,128,29,248,47,64,58,244,47,0,0,1,248,31,64,2,244,47,0,0,1,255,255,255,66,255,255,255,128,1,255,255,255,66,255,255,255,128,1,248,47,128,2,244,47,64,0,1,248,31,64,2,244,47,0,0,1,248,47,128,2,248,47,64,0,1,255,255,255,210,255,255,255,240,1,255,255,255,210,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,208,0,0,0,255,0,0,1,255,128,0,0,0,255,192,0,11,254,0,0,0,0,63,248,0,127,244,0,0,0,0,11,255,135,255,192,0,0,0,0,1,255,255,254,0,0,0,0,0,0,127,255,248,0,0,0,0,0,91,255,255,255,228,0,0,22,191,255,255,239,255,255,254,144,63,255,255,249,1,191,255,255,224,31,255,249,0,0,2,255,255,192,15,148,0,0,0,0,1,111,64,0,0,0,0,0,0,0,0,0,
  // 0x96e2  離
  226,150,35,35,59,37,1,253,0,0,252,0,0,10,64,16,0,0,0,252,0,0,15,208,127,0,0,0,252,0,0,31,192,190,0,127,255,255,255,244,47,128,252,0,127,255,255,255,248,63,65,252,0,127,255,255,255,248,127,2,244,0,0,0,0,0,0,190,3,240,0,6,64,11,203,128,255,255,255,240,11,202,15,139,194,255,255,255,240,11,207,255,11,195,255,255,255,240,11,195,254,11,199,253,3,240,0,11,192,255,75,207,252,3,240,0,11,195,255,219,239,252,3,240,0,11,207,211,219,255,252,3,240,0,11,223,64,75,255,252,3,240,0,11,218,85,95,221,255,255,255,240,11,255,255,255,192,255,255,255,240,11,255,255,255,192,255,255,255,224,0,0,252,0,0,252,3,240,0,0,0,248,0,0,252,3,240,0,47,255,255,255,240,252,3,240,0,47,255,255,255,240,252,3,240,0,47,171,250,171,240,255,255,255,224,47,3,224,3,240,255,255,255,240,47,3,227,131,240,255,255,255,240,47,3,211,195,240,252,3,240,0,47,7,194,227,240,252,3,240,0,47,127,255,243,240,252,3,240,0,47,63,255,247,240,252,3,240,0,47,21,80,187,240,253,3,240,0,47,0,0,87,240,255,255,255,248,47,0,0,3,240,255,255,255,248,47,0,2,171,224,255,255,255,248,47,0,2,255,208,252,0,0,0,47,0,1,255,64,252,0,0,0,
  // 0x96fb  電
  251,150,34,34,50,37,2,253,2,170,170,170,170,170,170,160,0,3,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,85,85,91,245,85,85,127,64,127,0,0,7,240,0,0,63,64,127,31,255,199,240,255,253,63,64,127,31,255,199,240,255,253,63,64,127,0,0,7,240,0,0,63,64,0,0,0,7,240,0,0,0,0,0,63,255,199,240,255,255,64,0,0,63,255,199,240,255,255,64,0,0,0,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,254,85,91,245,85,111,192,0,0,253,0,7,240,0,31,192,0,0,253,0,11,240,0,31,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,253,0,7,240,0,31,192,0,0,253,0,7,240,0,31,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,199,128,0,254,85,91,245,85,85,71,224,0,253,0,7,240,0,0,11,208,0,84,0,7,244,0,0,31,192,0,0,0,3,255,255,255,255,192,0,0,0,1,255,255,255,255,0,0,0,0,0,26,170,170,164,0,
  // 0x9752  青
  82,151,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,6,170,170,175,250,170,170,164,0,7,255,255,255,255,255,255,248,0,7,255,255,255,255,255,255,248,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,170,170,171,250,170,170,128,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,106,170,170,175,250,170,170,170,64,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,234,170,170,170,255,0,0,0,47,128,0,0,0,191,0,0,0,47,128,0,0,0,191,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,213,85,85,85,191,0,0,0,47,128,0,0,0,191,0,0,0,47,213,85,85,85,191,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,128,0,0,0,191,0,0,0,47,128,0,0,0,191,0,0,0,47,128,0,0,0,191,0,0,0,47,128,0,3,255,255,0,0,0,47,128,0,2,255,253,0,0,0,47,128,0,0,170,144,0,0,
  // 0x975e  非
  94,151,35,36,68,37,1,252,0,0,2,164,0,169,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,254,0,0,0,15,255,255,248,0,255,255,255,224,15,255,255,248,0,255,255,255,224,15,255,255,248,0,255,255,255,224,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,11,255,255,248,0,255,255,255,192,11,255,255,248,0,255,255,255,192,11,255,255,248,0,255,255,255,192,0,0,3,248,0,254,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,244,0,253,0,0,0,0,0,3,244,0,253,0,0,0,0,0,7,255,208,253,0,0,0,0,22,255,255,208,254,0,0,0,127,255,255,255,208,255,255,255,244,127,255,255,245,0,255,255,255,244,63,254,191,192,0,255,255,255,244,41,0,63,192,0,253,0,0,0,0,0,255,64,0,253,0,0,0,0,2,254,0,0,253,0,0,0,0,11,252,0,0,253,0,0,0,0,47,244,0,0,253,0,0,0,1,255,208,0,0,253,0,0,0,11,255,64,0,0,253,0,0,0,11,252,0,0,0,253,0,0,0,2,208,0,0,0,253,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9762  面
  98,151,33,32,32,37,2,253,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,15,240,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,47,192,0,0,0,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,208,31,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,255,255,252,1,252,0,15,192,15,255,255,252,1,252,0,15,192,15,234,171,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,234,171,252,1,252,0,15,192,15,255,255,252,1,252,0,15,192,15,255,255,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,208,31,192,1,252,1,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,192,0,0,0,0,1,252,0,15,192,0,0,0,0,1,252,0,
  // 0x9805  項
  5,152,35,33,41,37,1,253,0,0,0,15,255,255,255,255,248,0,0,0,15,255,255,255,255,248,21,85,85,95,255,255,255,255,248,63,255,255,224,0,15,240,0,0,63,255,255,224,0,15,208,0,0,0,47,192,0,0,31,192,0,0,0,31,192,1,255,255,255,255,192,0,31,192,1,255,255,255,255,192,0,31,192,1,254,170,170,175,192,0,31,192,1,248,0,0,15,192,0,31,192,1,248,0,0,15,192,0,31,192,1,248,0,0,15,192,0,31,192,1,255,255,255,255,192,0,31,192,1,255,255,255,255,192,0,31,192,1,253,85,85,111,192,0,31,192,1,248,0,0,15,192,0,31,192,1,248,0,0,15,192,0,31,192,1,253,85,85,111,192,0,31,192,113,255,255,255,255,192,0,31,223,241,255,255,255,255,192,0,47,255,245,248,0,0,15,192,6,255,255,209,248,0,0,15,192,191,255,248,1,248,0,0,15,192,127,254,64,1,255,255,255,255,192,63,208,0,1,255,255,255,255,192,20,0,0,1,170,170,170,170,128,0,0,0,0,7,64,2,128,0,0,0,0,0,47,224,15,244,0,0,0,0,2,255,208,15,255,0,0,0,0,47,255,0,1,255,208,0,0,3,255,244,0,0,47,248,0,0,1,255,64,0,0,7,244,0,0,0,100,0,0,0,0,192,
  // 0x9810  預
  16,152,35,34,50,37,1,252,63,255,255,250,255,255,255,255,240,63,255,255,254,255,255,255,255,240,63,255,255,245,255,255,255,255,240,0,0,15,240,0,3,248,0,0,0,0,47,192,0,7,244,0,0,2,192,127,64,0,11,240,0,0,7,249,254,0,63,255,255,255,192,7,255,248,0,63,255,255,255,192,0,191,240,0,63,170,170,175,192,0,15,253,0,63,0,0,31,192,0,2,255,0,63,0,0,31,192,0,0,127,0,63,85,85,111,192,191,255,255,255,127,255,255,255,192,191,255,255,255,63,255,255,255,192,191,255,255,255,63,0,0,31,192,0,15,208,189,63,0,0,31,192,0,15,208,252,63,0,0,31,192,0,15,208,252,63,85,85,111,192,0,15,209,248,63,255,255,255,192,0,15,211,240,63,255,255,255,192,0,15,209,160,63,0,0,31,192,0,15,208,0,63,0,0,31,192,0,15,208,0,63,0,0,31,192,0,15,208,0,63,255,255,255,192,0,15,208,0,63,255,255,255,192,0,15,208,0,42,170,170,170,128,0,15,208,0,0,128,0,64,0,0,15,208,0,3,244,3,244,0,0,15,208,0,31,252,11,254,0,0,31,208,1,255,224,1,255,192,15,255,208,31,255,64,0,63,240,15,255,192,47,248,0,0,11,248,11,254,0,11,128,0,0,1,208,0,0,0,0,0,0,0,0,0,
  // 0x984d  額
  77,152,35,36,68,37,1,252,0,2,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,63,255,255,255,240,47,255,255,255,191,255,255,255,240,63,255,255,255,191,255,255,255,240,63,255,255,255,128,2,252,0,0,63,0,0,31,128,3,248,0,0,63,11,144,31,128,3,244,0,0,63,15,192,31,143,255,255,255,192,0,47,213,80,15,255,255,255,192,0,127,255,252,15,234,170,175,192,0,255,255,252,15,192,0,15,192,3,248,3,244,15,192,0,15,192,15,248,7,240,15,229,85,111,192,127,255,79,208,15,255,255,255,192,127,127,255,128,15,255,255,255,192,8,15,255,0,15,192,0,15,192,0,3,255,64,15,192,0,15,192,0,15,255,224,15,192,0,15,192,0,127,223,252,15,229,85,111,192,7,255,2,255,79,255,255,255,192,127,252,0,191,143,255,255,255,192,191,250,170,191,15,192,0,15,192,63,255,255,248,15,192,0,15,192,3,255,255,244,15,192,0,15,192,3,240,2,244,15,255,255,255,192,3,240,2,244,15,255,255,255,192,3,240,2,244,10,170,170,170,128,3,240,2,244,0,32,0,64,0,3,240,2,244,1,253,2,244,0,3,255,255,244,11,254,3,254,0,3,255,255,244,191,244,0,191,192,3,250,170,171,255,192,0,31,244,3,240,0,3,253,0,0,7,248,1,80,0,0,208,0,0,0,208,0,0,0,0,0,0,0,0,0,
  // 0x985e  類
  94,152,35,35,59,37,1,253,0,1,80,0,0,0,0,0,0,6,2,240,41,0,0,0,0,0,15,130,240,63,127,255,255,255,240,11,194,240,125,63,255,255,255,240,7,226,240,252,63,255,255,255,240,3,226,240,244,0,2,252,0,0,0,2,240,16,0,3,248,0,0,63,255,255,255,64,3,240,0,0,63,255,255,255,79,255,255,255,192,42,175,254,170,79,255,255,255,192,0,31,253,0,15,234,170,175,192,0,127,255,128,15,192,0,15,192,1,255,255,248,15,192,0,15,192,7,246,246,255,79,213,85,111,192,47,210,240,127,79,255,255,255,192,127,130,240,14,15,255,255,255,192,29,2,240,0,15,192,0,15,192,0,0,0,0,15,192,0,15,192,0,3,240,0,15,192,0,15,192,0,3,240,0,15,255,255,255,192,0,3,240,0,15,255,255,255,192,63,255,255,255,143,213,85,111,192,63,255,255,255,143,192,0,15,192,63,255,255,255,143,192,0,15,192,0,3,240,0,15,192,0,15,192,0,7,244,0,15,255,255,255,192,0,15,254,0,15,255,255,255,192,0,31,255,208,10,170,170,170,128,0,63,239,244,0,112,0,144,0,0,255,71,254,1,254,3,248,0,7,253,0,255,11,253,3,255,0,127,248,0,60,191,240,0,191,208,63,208,0,11,255,128,0,31,248,30,0,0,3,253,0,0,3,244,0,0,0,0,208,0,0,0,128,
  // 0x98a8  風
  168,152,35,34,50,37,1,252,0,127,255,255,255,255,255,244,0,0,127,255,255,255,255,255,244,0,0,127,255,255,255,255,255,244,0,0,127,0,0,0,0,7,244,0,0,127,0,0,0,5,3,244,0,0,127,0,1,107,255,67,244,0,0,127,43,255,255,255,211,244,0,0,127,63,255,255,249,3,244,0,0,127,46,81,248,0,3,244,0,0,127,0,1,248,0,3,244,0,0,127,0,1,248,0,3,244,0,0,127,26,171,254,170,131,244,0,0,191,31,255,255,255,195,244,0,0,191,31,255,255,255,195,244,0,0,190,31,1,248,15,195,244,0,0,190,31,1,248,15,195,244,0,0,190,31,1,248,15,195,244,0,0,190,31,1,248,15,195,244,0,0,254,31,1,248,15,195,244,0,0,253,31,171,254,175,195,244,0,0,253,31,255,255,255,194,244,0,0,252,31,255,255,255,194,248,0,1,252,0,1,248,1,2,248,0,2,252,0,1,248,63,1,248,0,3,248,0,1,248,47,129,252,16,3,244,0,1,248,15,192,252,48,7,240,5,90,254,175,240,252,60,11,241,255,255,255,255,244,252,124,15,209,255,255,255,255,248,190,120,47,192,255,234,149,0,252,127,248,127,128,0,0,0,0,189,63,244,63,0,0,0,0,0,80,31,240,9,0,0,0,0,0,0,11,192,0,0,0,0,0,0,0,0,0,
  // 0x98fd  飽
  253,152,35,35,59,37,1,253,0,3,248,0,1,228,0,0,0,0,11,254,0,2,252,0,0,0,0,15,255,192,3,244,0,0,0,0,47,239,240,7,240,0,0,0,0,127,75,248,11,240,0,0,0,0,254,2,254,15,255,255,255,224,3,252,0,191,95,255,255,255,208,11,244,252,62,63,255,255,255,208,63,208,252,8,127,0,0,11,208,255,128,252,0,254,0,0,11,208,127,255,255,255,252,0,0,15,208,27,255,255,255,255,255,252,15,208,3,250,170,253,239,255,252,15,208,3,240,0,252,79,255,252,15,208,3,240,0,252,0,0,252,15,208,3,255,255,252,0,0,252,15,208,3,255,255,252,0,0,252,15,192,3,245,85,252,0,0,252,15,192,3,240,0,252,0,0,252,15,192,3,240,0,252,31,255,252,15,192,3,255,255,252,31,255,252,31,192,3,255,255,252,31,255,252,47,192,3,250,170,168,31,128,15,255,128,3,240,0,0,31,128,15,255,64,3,240,11,128,31,128,11,253,0,3,240,31,192,31,128,0,0,0,3,240,11,240,31,128,0,0,0,3,240,3,244,31,128,0,0,128,3,240,111,252,31,128,0,1,248,3,255,255,253,31,128,0,1,248,47,255,255,255,31,128,0,2,248,63,255,228,127,31,192,0,3,244,63,249,0,63,95,255,255,255,240,41,0,0,24,15,255,255,255,224,0,0,0,0,1,255,255,255,64,
  // 0x9918  餘
  24,153,35,35,59,37,1,253,0,11,244,0,0,7,240,0,0,0,15,253,0,0,15,252,0,0,0,47,255,64,0,31,253,0,0,0,127,47,208,0,63,255,0,0,0,254,15,240,0,191,63,192,0,2,252,3,252,1,253,15,224,0,7,244,1,254,3,248,11,244,0,31,255,255,188,15,240,3,253,0,127,175,255,96,63,192,0,255,64,254,21,85,0,255,64,0,63,224,40,0,0,3,253,0,0,31,248,7,255,255,251,255,255,255,255,244,7,255,255,246,235,255,255,253,240,7,245,87,244,139,255,255,252,64,7,224,2,244,0,3,240,0,0,7,224,2,244,0,3,240,0,0,7,255,255,244,0,3,240,0,0,7,255,255,244,0,3,240,0,0,7,224,2,245,255,255,255,255,240,7,224,2,245,255,255,255,255,240,7,255,255,245,255,255,255,255,240,7,255,255,244,0,3,240,0,0,7,245,85,80,0,3,240,4,0,7,224,0,0,31,131,240,189,0,7,250,170,160,63,67,240,127,0,7,255,255,244,63,3,240,63,64,7,255,255,244,191,3,240,31,192,7,224,0,0,253,3,240,15,208,7,224,0,2,252,3,240,11,240,7,250,170,171,248,3,240,3,240,7,255,255,255,240,3,240,3,244,7,255,255,253,208,3,240,2,144,7,224,0,0,2,255,240,0,0,7,224,0,0,0,255,224,0,0,7,224,0,0,0,255,128,0,0,
  // 0x99ac  馬
  172,153,34,34,50,37,1,252,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,234,170,255,170,170,160,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,234,170,255,170,170,160,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,255,255,255,255,255,255,224,0,63,255,255,255,255,255,255,208,0,63,255,255,255,255,255,255,208,0,0,0,0,0,0,0,15,208,0,80,0,0,0,2,128,15,208,0,253,5,64,104,15,208,15,192,0,252,31,192,252,7,240,31,192,1,252,15,192,126,2,244,31,192,3,248,15,192,63,0,252,47,192,3,244,11,208,47,64,184,47,192,15,240,11,224,31,128,0,63,128,31,208,7,224,15,192,0,191,64,127,192,7,240,8,1,255,255,0,47,0,1,64,0,0,255,254,0,5,0,0,0,0,0,255,244,0,0,0,0,0,0,0,0,0,0,
  // 0x9a45  驅
  69,154,35,35,59,37,1,252,10,170,170,164,170,170,170,170,160,15,255,255,248,255,255,255,255,240,15,255,255,248,255,255,255,255,240,15,193,244,0,252,0,0,0,0,15,193,244,0,252,0,0,0,0,15,193,244,0,252,15,255,254,0,15,235,250,160,252,15,255,254,0,15,255,255,240,252,15,192,62,0,15,255,255,240,252,15,192,62,0,15,193,244,0,252,15,192,62,0,15,193,244,0,252,15,192,62,0,15,193,244,0,252,15,192,62,0,15,255,255,240,252,15,255,254,0,15,255,255,240,252,15,255,254,0,15,235,254,160,252,0,0,0,0,15,193,244,0,252,0,0,0,0,15,193,244,0,252,0,0,0,0,15,193,244,0,252,191,241,255,224,15,255,255,252,252,191,241,255,224,15,255,255,252,252,176,241,209,224,10,170,170,252,252,176,241,209,224,0,0,0,252,252,176,241,209,224,9,0,36,252,252,176,241,209,224,30,183,124,248,252,176,241,209,224,30,179,157,248,252,176,241,209,224,30,115,207,248,252,191,241,255,224,45,118,203,248,252,191,241,255,224,45,117,193,248,252,0,0,0,0,60,117,209,244,252,0,0,0,0,124,116,1,244,254,170,170,170,164,180,0,2,240,255,255,255,255,248,16,0,171,240,255,255,255,255,248,0,0,255,224,252,0,0,0,0,0,0,255,128,184,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9ad4  體
  212,154,34,36,68,37,2,252,0,0,0,0,0,124,46,0,0,6,170,170,128,0,124,47,0,0,11,255,255,192,0,124,47,0,0,11,255,255,192,21,189,127,85,0,11,192,7,192,191,255,255,255,0,11,192,7,192,191,255,255,255,0,11,199,255,192,188,60,45,31,0,11,199,255,192,188,60,45,31,0,11,199,139,192,191,255,255,255,0,11,199,71,192,191,255,255,255,0,11,199,71,192,188,61,61,47,0,11,199,71,192,188,60,45,31,0,255,255,255,253,189,125,125,111,0,255,255,255,253,191,255,255,255,0,253,85,85,189,191,255,255,255,0,252,0,0,125,0,0,0,0,0,255,255,255,254,85,85,85,85,64,11,255,255,194,255,255,255,255,192,11,255,255,194,255,255,255,255,192,11,208,15,192,0,0,0,0,0,11,208,15,192,63,255,255,254,0,11,255,255,192,63,255,255,254,0,11,255,255,192,63,0,0,126,0,11,229,95,192,63,0,0,126,0,11,208,15,192,63,0,0,126,0,11,208,15,192,63,255,255,254,0,11,255,255,192,63,255,255,254,0,11,255,255,192,1,208,3,144,0,11,229,95,192,7,224,3,240,0,11,208,15,192,3,240,11,208,0,11,208,15,192,1,244,15,192,0,11,208,15,192,0,248,31,64,0,11,209,175,199,255,255,255,255,224,11,209,255,199,255,255,255,255,224,11,208,254,2,170,170,170,170,144,0,0,0,0,0,0,0,0,0,
  // 0x9ad8  高
  216,154,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,85,85,85,85,80,0,0,0,7,255,255,255,255,244,0,0,0,7,255,255,255,255,244,0,0,0,7,240,0,0,3,244,0,0,0,7,240,0,0,3,244,0,0,0,7,240,0,0,3,244,0,0,0,7,255,255,255,255,244,0,0,0,7,255,255,255,255,244,0,0,0,1,85,85,85,85,80,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,208,0,0,0,0,0,252,0,15,208,0,0,0,0,0,252,0,15,208,5,85,85,84,0,252,0,15,208,31,255,255,253,0,252,0,15,208,31,255,255,253,0,252,0,15,208,31,64,0,189,0,252,0,15,208,31,64,0,189,0,252,0,15,208,31,64,0,189,0,252,0,15,208,31,255,255,253,0,252,0,15,208,31,255,255,253,0,252,0,15,208,31,149,85,90,2,252,0,15,208,31,64,0,7,255,252,0,15,208,5,0,0,3,255,248,0,15,208,0,0,0,2,255,144,0,
  // 0x9ec3  黃
  195,158,33,36,68,37,2,252,0,0,126,0,0,47,128,0,0,0,0,191,0,0,47,192,0,0,0,0,191,0,0,47,192,0,0,15,255,255,255,255,255,255,253,0,15,255,255,255,255,255,255,253,0,10,170,255,170,170,191,234,169,0,0,0,191,0,0,47,192,0,0,0,0,191,85,85,127,192,0,0,0,0,191,255,255,255,192,0,0,0,0,191,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,7,240,0,0,0,0,0,85,85,91,245,85,85,64,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,253,0,7,240,0,31,192,0,0,253,0,7,240,0,31,192,0,0,254,85,91,245,85,95,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,253,0,7,240,0,31,192,0,0,253,0,7,240,0,31,192,0,0,254,85,91,245,85,111,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,0,126,0,0,63,128,0,0,0,11,255,192,0,255,254,0,0,2,255,254,0,0,27,255,244,0,191,255,208,0,0,0,127,255,128,191,248,0,0,0,0,2,255,64,46,64,0,0,0,0,0,44,0,0,0,0,0,0,0,0,0,0,
  // 0x9ede  點
  222,158,35,35,59,37,1,253,0,0,0,0,0,1,252,0,0,5,85,85,85,64,1,252,0,0,15,255,255,255,128,1,252,0,0,15,255,255,255,128,1,252,0,0,15,64,244,15,128,1,252,0,0,15,148,244,143,128,1,252,0,0,15,184,244,255,128,1,252,0,0,15,124,245,223,128,1,252,0,0,15,108,246,207,128,1,255,255,248,15,93,247,143,128,1,255,255,248,15,93,251,79,128,1,255,255,248,15,64,245,15,128,1,252,0,0,15,149,249,95,128,1,252,0,0,15,255,255,255,128,1,252,0,0,15,255,255,255,128,1,252,0,0,0,1,248,0,0,1,252,0,0,0,1,248,0,0,1,252,0,0,10,171,254,170,128,1,252,0,0,31,255,255,255,199,255,255,255,192,31,255,255,255,199,255,255,255,192,0,1,248,0,7,255,255,255,192,0,1,248,0,7,224,0,15,192,0,1,254,191,215,224,0,15,192,63,255,255,255,215,224,0,15,192,63,255,255,255,215,224,0,15,192,63,165,80,0,7,224,0,15,192,0,0,5,62,7,224,0,15,192,6,79,31,31,7,224,0,15,192,11,207,79,15,199,224,0,15,192,15,143,139,135,215,224,0,15,192,15,75,135,195,231,255,255,255,192,31,75,195,193,235,255,255,255,192,63,7,195,128,7,255,255,255,192,189,1,64,0,7,224,0,31,192,24,0,0,0,7,224,0,10,128,
  // 0x9f4a  齊
  74,159,34,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,170,170,170,175,254,170,170,170,64,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,96,3,144,0,0,0,0,0,0,248,11,208,2,244,0,63,255,255,189,15,149,191,253,0,63,255,255,63,47,47,255,208,0,22,249,127,29,89,47,159,192,0,2,240,63,7,240,47,7,208,0,3,240,63,7,240,47,3,240,0,7,224,62,7,240,47,1,248,0,15,208,62,7,240,47,5,253,0,47,213,189,7,241,191,255,127,128,255,31,252,7,241,255,255,47,208,252,15,244,7,240,250,80,11,128,96,0,0,0,0,0,0,1,0,0,47,192,0,0,0,63,64,0,0,47,192,0,0,0,63,64,0,0,47,255,255,255,255,255,64,0,0,47,255,255,255,255,255,64,0,0,47,234,170,170,170,191,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,234,170,170,170,191,64,0,0,127,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,1,254,0,0,0,0,63,64,0,3,252,0,0,0,0,63,64,0,31,248,0,0,0,0,63,64,0,127,240,0,0,0,0,63,64,0,47,192,0,0,0,0,63,64,0,14,0,0,0,0,0,63,64,0,0,0,0,0,0,0,0,0,0,
  // 0xff1a  ：
  26,255,7,24,48,37,15,2,31,208,63,240,191,248,127,244,63,240,31,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,208,63,240,191,248,191,244,63,240,31,208,
};

#endif // HAS_GRAPHICAL_TFT
