/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Simplified Chinese 37pt, capital 'A' height: 27px, width: 100%, range: 0x201c-0xff1a, glyphs: 373
extern const uint8_t NotoSans_Medium_Simplified_Chinese_27[24699] = {
  162,27,28,32,26,255,35,247, // unifont_t
  // 0x201c  “
  28,32,14,10,40,14,0,17,0,80,1,80,3,240,7,224,3,240,15,208,11,240,31,192,15,224,47,192,31,208,63,128,47,192,127,64,63,192,255,64,127,192,255,0,106,64,170,0,
  // 0x201d  ”
  29,32,14,10,40,14,0,17,5,80,5,80,15,244,47,224,15,240,47,208,15,224,63,192,31,208,63,128,47,192,127,64,63,128,191,0,63,0,254,0,127,0,252,0,105,0,164,0,
  // 0x22bf  ⊿
  191,34,29,30,240,37,3,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,2,192,0,0,0,0,0,0,11,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,191,192,0,0,0,0,0,2,255,192,0,0,0,0,0,11,255,192,0,0,0,0,0,47,239,192,0,0,0,0,0,191,143,192,0,0,0,0,2,254,15,192,0,0,0,0,11,248,15,192,0,0,0,0,47,224,15,192,0,0,0,0,191,128,15,192,0,0,0,2,254,0,15,192,0,0,0,11,248,0,15,192,0,0,0,31,224,0,15,192,0,0,0,127,128,0,15,192,0,0,1,255,0,0,15,192,0,0,7,252,0,0,15,192,0,0,31,240,0,0,15,192,0,0,127,192,0,0,15,192,0,1,255,0,0,0,15,192,0,7,252,0,0,0,15,192,0,31,240,0,0,0,15,192,0,127,192,0,0,0,15,192,1,255,0,0,0,0,15,192,7,255,255,255,255,255,255,192,31,255,255,255,255,255,255,192,127,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,
  // 0x4e00  一
  0,78,35,4,36,37,1,13,63,255,255,255,255,255,255,255,244,127,255,255,255,255,255,255,255,244,127,255,255,255,255,255,255,255,244,127,255,255,255,255,255,255,255,244,
  // 0x4e09  三
  9,78,33,30,14,37,2,255,1,85,85,85,85,85,85,80,0,7,255,255,255,255,255,255,244,0,7,255,255,255,255,255,255,244,0,7,255,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,254,0,0,0,63,255,255,255,255,254,0,0,0,63,255,255,255,255,254,0,0,0,26,170,170,170,170,169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,21,85,85,85,85,85,85,85,0,
  // 0x4e0a  上
  10,78,33,33,41,37,2,255,0,0,0,5,64,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,255,255,255,248,0,0,0,0,47,255,255,255,248,0,0,0,0,47,255,255,255,248,0,0,0,0,47,229,85,85,80,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,85,85,85,127,229,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x4e0b  下
  11,78,33,32,32,37,2,253,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,106,170,170,175,250,170,170,170,64,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,232,0,0,0,0,0,0,0,15,255,128,0,0,0,0,0,0,15,255,248,0,0,0,0,0,0,15,255,255,64,0,0,0,0,0,15,231,255,240,0,0,0,0,0,15,224,191,254,0,0,0,0,0,15,224,15,255,192,0,0,0,0,15,224,1,255,248,0,0,0,0,15,224,0,63,248,0,0,0,0,15,224,0,11,240,0,0,0,0,15,224,0,1,192,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,208,0,0,0,0,
  // 0x4e0d  不
  13,78,33,33,41,37,2,253,21,85,85,85,85,85,85,85,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,0,0,255,64,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,191,244,0,0,0,0,0,0,2,255,244,176,0,0,0,0,0,7,255,246,253,0,0,0,0,0,31,255,251,255,128,0,0,0,0,127,247,244,191,240,0,0,0,2,255,199,244,31,253,0,0,0,11,255,7,244,7,255,128,0,0,63,252,7,244,0,255,224,0,1,255,240,7,244,0,47,252,0,15,255,128,7,244,0,11,255,0,191,253,0,7,244,0,2,255,192,255,240,0,7,244,0,0,127,192,63,128,0,7,244,0,0,47,0,28,0,0,7,244,0,0,4,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,
  // 0x4e13  专
  19,78,33,36,68,37,2,252,0,0,0,63,64,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,191,0,0,0,0,0,3,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,1,85,87,253,85,85,85,64,0,0,0,3,248,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,11,240,0,0,0,0,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,85,85,127,213,85,85,85,85,0,0,0,63,64,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,1,0,0,0,1,255,255,255,255,255,192,0,0,2,255,255,255,255,255,224,0,0,3,255,255,255,255,255,192,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,63,240,0,0,0,0,0,0,0,255,192,0,0,0,0,126,64,3,255,0,0,0,0,0,255,253,15,252,0,0,0,0,0,191,255,255,240,0,0,0,0,0,2,255,255,192,0,0,0,0,0,0,27,255,253,0,0,0,0,0,0,0,127,255,208,0,0,0,0,0,0,6,255,240,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,2,192,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4e1d  丝
  29,78,33,33,41,37,2,255,0,0,80,0,0,0,128,0,0,0,0,253,0,0,2,252,0,0,0,1,253,0,0,3,248,0,0,0,3,252,0,0,7,240,0,0,0,3,244,0,0,15,224,0,0,0,11,240,0,0,31,192,0,0,0,15,208,0,0,63,128,0,0,0,47,192,45,0,127,0,36,0,0,63,64,63,128,254,0,127,0,0,190,0,191,1,252,0,255,0,1,252,1,254,3,244,2,253,0,3,248,3,252,11,240,3,248,0,11,240,7,244,47,192,15,240,0,47,255,255,224,191,255,255,208,0,47,255,255,192,127,255,255,128,0,31,255,255,64,63,255,255,0,0,9,65,254,0,20,2,252,0,0,0,3,252,0,0,11,244,0,0,0,11,240,0,0,31,208,0,0,0,47,208,0,0,63,128,0,0,0,127,64,0,0,254,0,0,0,1,253,0,0,3,252,0,0,0,7,254,175,254,31,250,175,255,0,31,255,255,254,127,255,255,255,0,15,255,255,253,63,255,255,255,0,11,250,149,0,47,234,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x4e2a  个
  42,78,35,34,50,37,1,253,0,0,0,3,253,0,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,31,255,192,0,0,0,0,0,0,63,255,224,0,0,0,0,0,0,255,143,248,0,0,0,0,0,3,255,3,254,0,0,0,0,0,15,252,1,255,128,0,0,0,0,47,244,0,127,224,0,0,0,0,255,208,0,31,248,0,0,0,3,255,64,0,7,255,0,0,0,31,253,0,0,1,255,208,0,0,127,240,0,0,0,63,248,0,3,255,192,1,252,0,11,255,128,31,254,0,1,252,0,2,255,244,255,244,0,1,252,0,0,127,252,127,192,0,1,252,0,0,11,244,45,0,0,1,252,0,0,1,224,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,
  // 0x4e2d  中
  45,78,31,35,24,37,3,253,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,21,85,85,111,213,85,85,80,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,127,85,85,111,213,85,87,244,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,244,127,0,0,31,192,0,3,244,127,0,0,31,192,0,3,244,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,
  // 0x4e3a  为
  58,78,32,35,24,37,2,253,0,0,0,63,64,0,0,0,0,24,0,63,64,0,0,0,0,255,0,63,64,0,0,0,0,127,128,63,64,0,0,0,0,63,208,63,64,0,0,0,0,15,240,63,64,0,0,0,0,7,244,63,64,0,0,0,0,3,128,63,0,0,0,0,0,0,0,127,0,0,0,0,63,255,255,255,255,255,255,253,63,255,255,255,255,255,255,253,63,255,255,255,255,255,255,253,21,85,85,255,85,85,86,253,0,0,0,254,0,0,1,252,0,0,0,254,0,0,1,252,0,0,1,253,0,0,1,252,0,0,2,252,0,0,2,252,0,0,3,252,46,0,2,252,0,0,3,248,191,64,2,252,0,0,11,240,63,192,2,252,0,0,15,240,15,240,2,252,0,0,47,208,7,248,3,252,0,0,63,192,3,252,3,252,0,0,191,128,0,254,3,248,0,1,255,0,0,184,3,248,0,3,253,0,0,0,3,248,0,15,252,0,0,0,3,244,0,63,240,0,0,0,7,244,0,255,192,0,0,0,11,240,3,255,64,0,0,0,15,240,31,253,0,0,0,0,47,240,191,244,0,0,3,255,255,208,63,192,0,0,2,255,255,192,14,0,0,0,1,255,255,0,0,0,0,0,0,85,80,0,
  // 0x4e3b  主
  59,78,33,34,50,37,2,254,0,0,0,24,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,208,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,15,253,0,0,0,0,0,0,0,2,255,64,0,0,0,0,0,0,0,191,192,0,0,0,5,85,85,85,127,85,85,84,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,85,85,91,249,85,85,64,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,85,85,85,85,85,85,64,
  // 0x4e49  义
  73,78,34,35,59,37,1,253,0,0,0,2,192,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,3,248,0,1,228,0,0,0,0,2,252,0,2,253,0,0,111,0,0,253,0,3,252,0,0,127,64,0,191,0,7,248,0,0,63,128,0,127,64,11,240,0,0,47,192,0,63,128,15,224,0,0,15,224,0,41,0,47,208,0,0,11,240,0,0,0,63,192,0,0,3,248,0,0,0,191,64,0,0,2,252,0,0,0,255,0,0,0,0,255,0,0,2,253,0,0,0,0,191,64,0,7,252,0,0,0,0,63,192,0,15,240,0,0,0,0,31,240,0,47,224,0,0,0,0,11,248,0,127,192,0,0,0,0,3,254,1,255,0,0,0,0,0,1,255,67,253,0,0,0,0,0,0,127,223,248,0,0,0,0,0,0,47,255,224,0,0,0,0,0,0,11,255,192,0,0,0,0,0,0,7,255,128,0,0,0,0,0,0,31,255,224,0,0,0,0,0,0,191,255,253,0,0,0,0,0,7,255,139,255,128,0,0,0,0,63,253,1,255,244,0,0,0,7,255,224,0,63,255,64,0,0,127,255,64,0,7,255,248,0,27,255,248,0,0,0,191,255,208,127,255,128,0,0,0,11,255,240,47,244,0,0,0,0,0,191,208,14,64,0,0,0,0,0,7,128,0,0,0,0,0,0,0,0,0,
  // 0x4e4b  之
  75,78,35,35,59,37,1,253,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,1,85,85,86,253,85,85,84,0,7,255,255,255,255,255,255,254,0,7,255,255,255,255,255,255,255,64,7,255,255,255,255,255,255,254,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,31,244,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,255,128,0,0,0,2,0,0,3,254,0,0,0,0,11,240,0,31,248,0,0,0,0,15,240,0,127,224,0,0,0,0,31,224,1,255,128,0,0,0,0,63,224,11,254,0,0,0,0,0,127,240,63,248,0,0,0,0,0,255,253,255,208,0,0,0,0,1,255,255,255,0,0,0,0,0,3,252,191,252,0,0,0,0,0,7,248,63,249,0,0,0,0,0,15,240,11,255,233,64,0,0,0,63,224,1,255,255,255,255,255,244,191,192,0,47,255,255,255,255,240,47,64,0,1,111,255,255,255,224,6,0,0,0,0,5,85,85,64,
  // 0x4e86  了
  134,78,29,32,0,37,4,253,255,255,255,255,255,255,253,0,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,64,85,85,85,85,85,95,254,0,0,0,0,0,0,47,248,0,0,0,0,0,0,191,224,0,0,0,0,0,2,255,128,0,0,0,0,0,15,254,0,0,0,0,0,0,63,244,0,0,0,0,0,1,255,208,0,0,0,0,0,63,255,0,0,0,0,0,0,63,248,0,0,0,0,0,0,63,208,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,21,85,191,64,0,0,0,0,31,255,255,0,0,0,0,0,15,255,254,0,0,0,0,0,11,255,228,0,0,0,0,
  // 0x4e8c  二
  140,78,33,26,234,37,2,1,1,170,170,170,170,170,170,160,0,2,255,255,255,255,255,255,224,0,2,255,255,255,255,255,255,224,0,2,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,
  // 0x4e8e  于
  142,78,33,33,41,37,2,253,1,85,85,85,85,85,85,80,0,7,255,255,255,255,255,255,244,0,7,255,255,255,255,255,255,244,0,7,255,255,255,255,255,255,244,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,85,87,253,85,85,85,64,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,1,255,255,248,0,0,0,0,0,0,255,255,240,0,0,0,0,0,0,191,255,208,0,0,0,0,0,0,42,148,0,0,0,0,0,
  // 0x4ea4  交
  164,78,33,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,85,85,85,91,249,85,85,85,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,61,0,0,15,128,0,0,0,0,255,128,0,63,240,0,0,0,3,255,0,0,31,253,0,0,0,15,252,0,0,7,255,128,0,0,63,240,0,0,0,255,224,0,1,255,192,0,0,0,47,248,0,11,255,1,0,0,20,11,255,0,127,252,63,0,0,63,130,255,128,127,224,63,128,0,191,64,191,64,15,64,47,192,0,255,0,44,0,4,0,15,224,2,253,0,0,0,0,0,11,244,7,252,0,0,0,0,0,3,252,15,244,0,0,0,0,0,1,255,63,224,0,0,0,0,0,0,191,255,192,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,31,253,0,0,0,0,0,0,0,127,255,64,0,0,0,0,0,2,255,255,240,0,0,0,0,0,47,255,127,254,0,0,0,0,6,255,248,11,255,228,0,0,1,191,255,208,1,255,255,144,0,191,255,253,0,0,47,255,255,128,255,255,208,0,0,2,255,255,192,63,248,0,0,0,0,27,255,0,46,0,0,0,0,0,0,26,0,0,0,0,0,0,0,0,0,0,
  // 0x4eae  亮
  174,78,33,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,213,85,85,85,255,0,0,0,47,128,0,0,0,191,0,0,0,47,128,0,0,0,191,0,0,0,47,213,85,85,85,255,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,170,170,170,170,170,170,191,64,126,0,0,0,0,0,0,63,64,126,0,31,192,7,244,0,63,64,126,0,31,192,7,244,0,63,64,126,0,47,192,7,244,0,63,64,0,0,63,192,7,244,0,0,0,0,0,63,128,7,244,0,0,0,0,0,191,64,7,244,0,0,0,0,0,255,0,7,244,0,13,0,0,3,253,0,7,244,0,15,192,0,47,252,0,7,244,0,31,192,6,255,240,0,3,248,0,47,192,255,255,128,0,3,255,255,255,64,191,248,0,0,2,255,255,255,0,62,64,0,0,0,191,255,248,0,0,0,0,0,0,0,0,0,0,
  // 0x4ece  从
  206,78,35,33,41,37,1,253,0,0,191,0,0,15,208,0,0,0,0,255,0,0,31,208,0,0,0,0,255,0,0,31,208,0,0,0,0,255,0,0,31,208,0,0,0,0,255,0,0,31,208,0,0,0,0,255,0,0,31,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,208,0,0,0,0,254,0,0,47,208,0,0,0,1,253,0,0,63,224,0,0,0,1,253,0,0,63,240,0,0,0,2,252,0,0,63,240,0,0,0,2,252,0,0,127,240,0,0,0,3,253,0,0,127,244,0,0,0,3,255,0,0,191,248,0,0,0,3,255,192,0,255,252,0,0,0,7,255,224,0,255,252,0,0,0,11,255,248,1,254,253,0,0,0,15,247,253,2,252,254,0,0,0,15,242,255,3,252,191,0,0,0,31,224,255,135,248,127,64,0,0,47,208,63,207,240,63,192,0,0,63,192,47,159,240,47,208,0,0,127,128,14,63,208,15,240,0,0,255,64,4,191,192,15,244,0,1,255,0,0,255,64,7,252,0,3,254,0,3,255,0,3,255,0,7,252,0,15,252,0,0,255,192,15,248,0,63,248,0,0,191,240,63,240,0,255,224,0,0,63,244,127,208,0,127,192,0,0,15,224,11,128,0,15,0,0,0,3,192,1,0,0,0,0,0,0,0,0,
  // 0x4ee4  令
  228,78,35,35,59,37,1,253,0,0,0,3,253,0,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,31,255,192,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,255,143,248,0,0,0,0,0,3,254,3,255,0,0,0,0,0,15,252,0,255,192,0,0,0,0,63,240,0,63,240,0,0,0,1,255,192,0,15,253,0,0,0,11,255,0,0,3,255,128,0,0,47,248,0,0,0,191,240,0,1,255,255,255,255,255,239,253,0,11,255,79,255,255,255,199,255,208,127,253,15,255,255,255,193,255,248,63,240,0,0,0,0,0,63,240,31,128,0,0,0,0,0,11,208,9,0,0,0,0,0,0,1,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,11,240,0,0,0,0,63,128,47,255,240,0,0,0,0,63,128,15,255,224,0,0,0,0,63,128,15,255,128,0,0,0,0,63,128,1,64,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,
  // 0x4ee5  以
  229,78,35,32,32,37,1,253,0,127,64,0,0,0,3,248,0,0,127,64,0,0,0,3,252,0,0,127,64,1,0,0,3,248,0,0,63,64,47,64,0,7,244,0,0,63,64,127,192,0,7,244,0,0,63,64,31,240,0,11,240,0,0,63,64,11,248,0,11,240,0,0,63,64,3,252,0,15,240,0,0,63,128,1,255,0,15,224,0,0,63,128,0,255,64,31,208,0,0,63,128,0,127,192,47,192,0,0,63,128,0,63,128,63,192,0,0,63,128,0,24,0,63,128,0,0,63,128,0,0,0,127,64,0,0,63,128,0,0,0,255,0,0,0,63,128,0,0,0,255,0,0,0,63,128,0,0,2,253,0,0,0,63,192,0,0,3,252,0,0,0,63,192,9,0,11,248,0,0,0,47,192,190,0,31,248,0,0,0,47,223,255,0,63,253,0,0,0,47,255,255,0,191,255,64,0,0,127,255,224,2,255,255,208,0,11,255,254,0,11,254,63,240,0,127,255,208,0,47,248,15,252,0,63,249,0,0,255,240,3,255,0,63,128,0,7,255,192,0,255,192,20,0,0,127,254,0,0,127,224,0,0,7,255,244,0,0,47,244,0,0,15,255,192,0,0,11,244,0,0,3,253,0,0,0,3,208,0,0,0,208,0,0,0,1,64,
  // 0x4ef6  件
  246,78,35,35,59,37,1,253,0,0,80,0,0,21,0,0,0,0,0,254,0,0,63,64,0,0,0,1,253,7,144,63,64,0,0,0,2,252,11,240,63,64,0,0,0,3,248,15,224,63,64,0,0,0,11,240,15,208,63,64,0,0,0,15,224,15,192,63,64,0,0,0,47,192,47,213,127,149,85,0,0,63,128,63,255,255,255,255,128,0,255,0,63,255,255,255,255,128,2,255,0,191,255,255,255,255,128,3,255,0,254,0,63,64,0,0,15,255,1,252,0,63,64,0,0,47,255,3,252,0,63,64,0,0,191,255,7,244,0,63,64,0,0,127,127,1,240,0,63,64,0,0,62,63,0,0,0,63,64,0,0,28,63,0,0,0,63,64,0,0,0,63,1,85,85,127,149,85,80,0,63,3,255,255,255,255,255,244,0,63,3,255,255,255,255,255,244,0,63,3,255,255,255,255,255,244,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,0,63,0,0,0,63,64,0,0,
  // 0x4efd  份
  253,78,35,35,59,37,1,253,0,0,160,0,0,0,0,0,0,0,0,253,0,31,255,255,0,0,0,2,252,0,31,255,255,0,0,0,3,248,0,31,255,255,64,0,0,7,244,2,64,0,47,192,0,0,15,240,7,240,0,31,192,0,0,31,208,11,240,0,15,224,0,0,63,192,15,208,0,15,240,0,0,191,64,47,192,0,7,244,0,1,255,0,63,128,0,3,252,0,3,255,0,191,0,0,1,254,0,11,255,1,253,0,0,0,255,64,31,255,3,252,0,0,0,127,192,127,255,11,240,0,0,0,47,244,255,255,31,224,0,0,0,15,248,255,127,63,255,255,255,255,251,240,124,63,15,47,255,255,255,244,192,32,63,0,47,255,255,255,244,0,0,63,0,0,31,208,3,244,0,0,63,0,0,31,192,3,244,0,0,63,0,0,31,192,3,244,0,0,63,0,0,47,128,3,240,0,0,63,0,0,63,128,7,240,0,0,63,0,0,63,64,7,240,0,0,63,0,0,127,0,7,240,0,0,63,0,0,254,0,7,240,0,0,63,0,1,252,0,7,240,0,0,63,0,3,252,0,11,240,0,0,63,0,11,244,0,11,240,0,0,63,0,31,240,0,15,224,0,0,63,0,191,192,0,31,224,0,0,63,3,255,0,47,255,208,0,0,63,3,252,0,15,255,192,0,0,63,1,240,0,15,255,0,0,0,42,0,64,0,1,64,0,0,
  // 0x4f11  休
  17,79,35,35,59,37,1,253,0,0,20,0,0,21,0,0,0,0,0,63,128,0,127,0,0,0,0,0,127,64,0,127,0,0,0,0,0,255,0,0,127,0,0,0,0,1,254,0,0,127,0,0,0,0,3,252,0,0,127,0,0,0,0,7,248,0,0,127,0,0,0,0,15,240,0,0,127,0,0,0,0,47,224,0,0,127,0,0,0,0,127,193,85,85,191,85,85,80,0,255,199,255,255,255,255,255,240,2,255,199,255,255,255,255,255,240,11,255,199,255,255,255,255,255,240,47,255,192,0,7,255,240,0,0,127,255,192,0,11,255,244,0,0,255,223,192,0,15,255,252,0,0,127,31,192,0,47,255,253,0,0,60,31,192,0,63,255,191,0,0,16,31,192,0,191,191,63,64,0,0,31,192,0,253,127,47,192,0,0,31,192,3,252,127,15,208,0,0,31,192,7,244,127,11,240,0,0,31,192,15,240,127,3,252,0,0,31,192,63,208,127,2,254,0,0,31,192,191,128,127,0,255,64,0,31,194,255,0,127,0,127,208,0,31,203,252,0,127,0,47,240,0,31,239,244,0,127,0,15,252,0,31,207,224,0,127,0,3,240,0,31,195,128,0,127,0,0,192,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,
  // 0x4f20  传
  32,79,34,36,68,37,1,252,0,0,164,0,0,164,0,0,0,0,0,254,0,1,252,0,0,0,0,1,252,0,3,248,0,0,0,0,3,248,0,3,244,0,0,0,0,7,244,255,255,255,255,255,64,0,15,240,255,255,255,255,255,64,0,31,208,255,255,255,255,255,64,0,63,192,0,15,224,0,0,0,0,191,64,0,31,192,0,0,0,1,255,0,0,47,192,0,0,0,3,255,0,0,63,128,0,0,0,11,255,15,255,255,255,255,255,240,47,255,15,255,255,255,255,255,240,127,255,15,255,255,255,255,255,240,255,255,0,0,254,0,0,0,0,191,127,0,0,253,0,0,0,0,60,127,0,2,252,0,0,0,0,52,127,0,3,252,0,0,0,0,0,127,0,3,248,0,0,0,0,0,127,0,7,255,255,255,254,0,0,127,0,11,255,255,255,255,64,0,127,0,15,255,255,255,253,0,0,127,0,0,0,0,11,248,0,0,127,0,0,0,0,47,224,0,0,127,0,0,0,0,191,192,0,0,127,0,0,8,1,255,0,0,0,127,0,0,63,135,252,0,0,0,127,0,0,191,255,240,0,0,0,127,0,0,31,255,192,0,0,0,127,0,0,2,255,192,0,0,0,127,0,0,0,127,240,0,0,0,127,0,0,0,15,253,0,0,0,127,0,0,0,3,255,0,0,0,127,0,0,0,0,189,0,0,0,63,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4f4d  位
  77,79,35,35,59,37,1,253,0,0,36,0,0,42,0,0,0,0,0,191,0,0,127,0,0,0,0,0,254,0,0,127,0,0,0,0,2,252,0,0,127,0,0,0,0,3,248,0,0,127,0,0,0,0,11,240,0,0,127,0,0,0,0,15,224,0,0,127,0,0,0,0,63,194,255,255,255,255,255,240,0,127,130,255,255,255,255,255,240,0,255,130,255,255,255,255,255,240,3,255,128,85,85,85,85,85,64,11,255,128,0,0,0,0,0,0,31,255,128,0,64,0,2,144,0,127,255,128,11,224,0,3,252,0,255,175,128,7,240,0,3,248,0,191,47,128,3,240,0,7,244,0,60,47,128,3,244,0,11,240,0,32,47,128,3,248,0,15,240,0,0,47,128,2,252,0,15,224,0,0,47,128,1,252,0,15,208,0,0,47,128,0,252,0,31,192,0,0,47,128,0,253,0,47,192,0,0,47,128,0,253,0,63,128,0,0,47,128,0,254,0,63,64,0,0,47,128,0,191,0,127,0,0,0,47,128,0,127,0,191,0,0,0,47,128,0,127,0,254,0,0,0,47,128,0,127,0,252,0,0,0,47,128,0,16,1,252,0,0,0,47,128,0,0,3,248,0,0,0,47,135,255,255,255,255,255,248,0,47,135,255,255,255,255,255,248,0,47,135,255,255,255,255,255,248,0,47,129,85,85,85,85,85,80,0,47,64,0,0,0,0,0,0,
  // 0x4f4e  低
  78,79,35,35,59,37,1,253,0,0,80,0,0,0,0,0,0,0,0,253,0,0,0,0,36,0,0,1,252,0,0,0,27,253,0,0,3,248,0,1,111,255,255,64,0,7,244,122,255,255,255,249,0,0,15,240,127,255,255,249,0,0,0,31,208,127,254,155,240,0,0,0,63,192,127,0,7,240,0,0,0,191,64,127,0,7,240,0,0,0,255,0,127,0,7,240,0,0,3,255,0,127,0,7,240,0,0,11,255,0,127,0,7,240,0,0,31,255,0,127,0,3,240,0,0,63,255,0,127,255,255,255,255,244,255,255,0,127,255,255,255,255,244,255,127,0,127,255,255,255,255,244,124,63,0,127,0,3,248,0,0,52,63,0,127,0,2,252,0,0,0,63,0,127,0,2,252,0,0,0,63,0,127,0,1,252,0,0,0,63,0,127,0,0,252,0,0,0,63,0,127,0,0,253,0,0,0,63,0,127,0,0,254,0,0,0,63,0,127,0,4,191,0,0,0,63,0,127,91,254,127,0,0,0,63,5,255,255,254,63,64,64,0,63,15,255,255,254,63,192,184,0,63,11,255,250,64,31,192,188,0,63,7,229,0,0,15,224,252,0,63,0,0,0,0,11,244,252,0,63,0,0,0,0,3,255,248,0,63,3,255,255,255,245,255,244,0,63,3,255,255,255,244,127,224,0,63,3,255,255,255,244,6,64,0,63,0,0,0,0,0,0,0,
  // 0x4f53  体
  83,79,35,35,59,37,1,253,0,0,144,0,0,189,0,0,0,0,2,252,0,0,254,0,0,0,0,3,248,0,0,254,0,0,0,0,7,240,0,0,254,0,0,0,0,15,240,0,0,254,0,0,0,0,31,208,0,0,254,0,0,0,0,63,192,0,0,254,0,0,0,0,63,75,255,255,255,255,255,240,0,255,11,255,255,255,255,255,240,1,255,11,255,255,255,255,255,240,3,255,1,85,95,255,245,85,80,11,255,0,0,15,255,240,0,0,31,255,0,0,31,255,244,0,0,63,255,0,0,63,255,252,0,0,255,255,0,0,126,254,252,0,0,127,127,0,0,189,254,126,0,0,61,127,0,1,252,254,63,0,0,24,127,0,3,248,254,47,128,0,0,127,0,7,240,254,15,192,0,0,127,0,15,224,254,11,240,0,0,127,0,47,192,254,3,244,0,0,127,0,63,128,254,2,252,0,0,127,0,255,0,254,0,255,0,0,127,2,253,0,254,0,191,128,0,127,7,248,0,254,0,63,208,0,127,31,247,255,255,255,223,244,0,127,63,215,255,255,255,203,248,0,127,15,71,255,255,255,194,224,0,127,6,0,0,254,0,0,128,0,127,0,0,0,254,0,0,0,0,127,0,0,0,254,0,0,0,0,127,0,0,0,254,0,0,0,0,127,0,0,0,254,0,0,0,0,127,0,0,0,254,0,0,0,0,63,0,0,0,169,0,0,0,
  // 0x4f59  余
  89,79,35,36,68,37,1,252,0,0,0,2,252,0,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,31,255,192,0,0,0,0,0,0,127,255,240,0,0,0,0,0,1,255,143,252,0,0,0,0,0,7,255,3,255,0,0,0,0,0,47,252,0,255,208,0,0,0,0,191,240,0,63,248,0,0,0,7,255,128,0,15,255,0,0,0,47,254,0,0,2,255,224,0,1,255,244,0,0,0,191,253,0,31,255,208,0,0,0,31,255,208,127,253,255,255,255,255,253,255,244,47,208,255,255,255,255,252,47,240,14,0,255,255,255,255,252,7,192,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,3,255,255,255,255,255,255,255,128,3,255,255,255,255,255,255,255,128,3,255,255,255,255,255,255,255,128,1,85,85,86,253,85,85,85,0,0,0,0,1,252,0,0,0,0,0,0,144,1,252,0,112,0,0,0,2,253,1,252,2,253,0,0,0,7,252,1,252,2,255,128,0,0,31,240,1,252,0,127,224,0,0,191,192,1,252,0,31,248,0,2,255,0,1,252,0,3,255,0,31,252,0,1,252,0,0,255,128,63,240,1,6,252,0,0,63,224,15,128,11,255,252,0,0,31,128,1,0,3,255,248,0,0,5,0,0,0,3,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4f5c  作
  92,79,35,35,59,37,1,253,0,0,36,0,5,0,0,0,0,0,0,127,0,15,208,0,0,0,0,0,255,0,31,192,0,0,0,0,1,253,0,63,128,0,0,0,0,3,252,0,127,64,0,0,0,0,7,248,0,255,0,0,0,0,0,15,240,0,255,255,255,255,248,0,31,208,2,255,255,255,255,248,0,63,192,3,255,255,255,255,248,0,191,192,15,245,254,85,85,80,0,255,192,31,208,254,0,0,0,3,255,192,63,192,254,0,0,0,11,255,192,191,64,254,0,0,0,31,255,193,255,0,254,0,0,0,63,255,195,252,0,254,0,0,0,127,255,199,248,0,255,255,255,224,63,47,192,240,0,255,255,255,224,29,47,192,0,0,255,255,255,224,4,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,255,255,255,240,0,47,192,0,0,255,255,255,240,0,47,192,0,0,255,255,255,240,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,47,128,0,0,254,0,0,0,
  // 0x4f7f  使
  127,79,35,36,68,37,1,252,0,0,56,0,0,42,0,0,0,0,0,191,0,0,63,64,0,0,0,0,254,0,0,63,64,0,0,0,2,252,0,0,63,64,0,0,0,3,251,255,255,255,255,255,244,0,11,243,255,255,255,255,255,244,0,15,227,255,255,255,255,255,244,0,63,192,0,0,127,64,0,0,0,127,128,0,0,63,64,0,0,0,255,128,0,0,63,64,0,0,3,255,128,255,255,255,255,255,208,11,255,128,255,255,255,255,255,208,47,255,128,255,255,255,255,255,208,191,255,128,252,0,63,64,15,208,255,111,128,252,0,63,64,15,208,127,47,128,252,0,63,64,15,208,60,47,128,252,0,63,64,15,208,16,47,128,252,0,63,64,15,208,0,47,128,255,255,255,255,255,208,0,47,128,255,255,255,255,255,208,0,47,128,255,255,255,255,255,208,0,47,128,0,0,127,0,0,0,0,47,128,189,0,190,0,0,0,0,47,128,127,0,254,0,0,0,0,47,128,47,193,253,0,0,0,0,47,128,15,242,252,0,0,0,0,47,128,3,255,248,0,0,0,0,47,128,0,255,240,0,0,0,0,47,128,0,127,248,0,0,0,0,47,128,1,255,255,144,0,0,0,47,128,31,255,255,254,64,0,0,47,130,255,248,31,255,255,148,0,47,143,255,208,1,255,255,244,0,47,131,254,0,0,11,255,224,0,47,130,144,0,0,0,26,192,0,0,0,0,0,0,0,0,0,
  // 0x4f9b  供
  155,79,35,35,59,37,1,253,0,0,96,0,168,0,10,128,0,0,0,254,0,253,0,31,192,0,0,1,253,0,253,0,31,192,0,0,2,252,0,253,0,31,192,0,0,3,248,0,253,0,31,192,0,0,11,240,0,253,0,31,192,0,0,15,224,0,253,0,31,192,0,0,47,192,0,253,0,31,192,0,0,127,129,255,255,255,255,255,240,0,255,1,255,255,255,255,255,240,2,255,1,255,255,255,255,255,240,7,255,0,85,254,85,111,213,80,15,255,0,0,253,0,31,192,0,63,255,0,0,253,0,31,192,0,255,255,0,0,253,0,31,192,0,191,127,0,0,253,0,31,192,0,61,63,0,0,253,0,31,192,0,36,63,0,0,253,0,31,192,0,0,63,0,0,253,0,31,192,0,0,63,1,85,254,85,111,213,80,0,63,7,255,255,255,255,255,244,0,63,7,255,255,255,255,255,244,0,63,7,255,255,255,255,255,244,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,185,0,7,64,0,0,63,0,0,254,0,47,192,0,0,63,0,3,252,0,15,240,0,0,63,0,11,244,0,7,252,0,0,63,0,47,224,0,2,254,0,0,63,0,191,192,0,0,191,64,0,63,2,255,0,0,0,63,192,0,63,11,253,0,0,0,15,240,0,63,2,244,0,0,0,11,208,0,63,0,80,0,0,0,2,0,
  // 0x4fb5  侵
  181,79,35,36,68,37,1,252,0,0,164,0,0,0,0,0,0,0,0,253,42,170,170,170,169,0,0,2,252,63,255,255,255,254,0,0,3,248,63,255,255,255,254,0,0,7,244,0,0,0,0,190,0,0,15,240,0,0,0,0,190,0,0,31,208,10,170,170,170,254,0,0,63,192,15,255,255,255,254,0,0,191,64,15,255,255,255,254,0,0,255,0,0,0,0,0,190,0,3,255,0,0,0,0,0,190,0,11,255,0,106,170,170,170,254,0,31,255,0,127,255,255,255,254,0,63,255,0,127,255,255,255,254,0,255,255,0,0,0,0,0,0,0,255,127,0,0,0,0,0,0,0,125,63,6,170,170,170,170,170,160,52,63,7,255,255,255,255,255,240,0,63,7,255,255,255,255,255,240,0,63,7,224,0,0,0,3,240,0,63,7,224,0,0,0,3,240,0,63,7,250,170,170,170,171,240,0,63,1,111,255,255,255,253,80,0,63,0,47,255,255,255,248,0,0,63,0,1,184,0,11,240,0,0,63,0,2,253,0,47,208,0,0,63,0,0,255,64,191,128,0,0,63,0,0,63,227,254,0,0,0,63,0,0,15,255,248,0,0,0,63,0,0,3,255,240,0,0,0,63,0,0,111,255,255,64,0,0,63,0,111,255,251,255,254,80,0,63,11,255,255,64,127,255,248,0,63,3,255,228,0,6,255,240,0,63,1,228,0,0,0,6,192,0,0,0,0,0,0,0,0,0,
  // 0x4fdd  保
  221,79,35,35,59,37,1,253,0,0,32,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,254,63,255,255,255,255,64,0,1,253,63,255,255,255,255,64,0,3,252,63,255,255,255,255,64,0,7,244,63,64,0,0,63,64,0,15,240,63,64,0,0,63,64,0,47,208,63,64,0,0,63,64,0,63,192,63,64,0,0,63,64,0,255,128,63,64,0,0,63,64,2,255,128,63,64,0,0,63,64,7,255,128,63,255,255,255,255,64,15,255,128,63,255,255,255,255,64,63,255,128,63,255,255,255,255,64,255,239,128,0,0,63,64,0,0,127,47,128,0,0,63,64,0,0,61,47,128,0,0,63,64,0,0,20,47,128,0,0,63,64,0,0,0,47,135,255,255,255,255,255,240,0,47,135,255,255,255,255,255,240,0,47,135,255,255,255,255,255,240,0,47,128,0,7,255,244,0,0,0,47,128,0,15,255,252,0,0,0,47,128,0,47,255,254,0,0,0,47,128,0,191,191,127,128,0,0,47,128,1,254,63,111,208,0,0,47,128,7,252,63,79,244,0,0,47,128,47,240,63,67,253,0,0,47,128,191,208,63,65,255,64,0,47,135,255,64,63,64,127,224,0,47,159,253,0,63,64,31,252,0,47,139,244,0,63,64,7,244,0,47,131,192,0,63,64,1,208,0,47,128,0,0,63,64,0,0,0,47,64,0,0,63,0,0,0,
  // 0x4fe1  信
  225,79,35,35,59,37,1,253,0,0,32,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,254,11,255,255,255,252,0,0,1,253,11,255,255,255,252,0,0,3,252,11,255,255,255,252,0,0,7,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,47,211,255,255,255,255,255,248,0,63,131,255,255,255,255,255,248,0,255,131,255,255,255,255,255,244,2,255,128,0,0,0,0,0,0,7,255,128,0,0,0,0,0,0,31,255,128,15,255,255,255,254,0,63,255,128,15,255,255,255,255,0,255,239,128,15,255,255,255,255,0,191,47,128,0,0,0,0,0,0,61,47,128,0,0,0,0,0,0,56,47,128,0,0,0,0,0,0,0,47,128,15,255,255,255,254,0,0,47,128,15,255,255,255,254,0,0,47,128,10,170,170,170,170,0,0,47,128,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,47,128,47,255,255,255,255,0,0,47,128,47,255,255,255,255,0,0,47,128,47,234,170,170,255,0,0,47,128,47,128,0,0,63,0,0,47,128,47,128,0,0,63,0,0,47,128,47,128,0,0,63,0,0,47,128,47,128,0,0,63,0,0,47,128,47,255,255,255,255,0,0,47,128,47,255,255,255,255,0,0,47,128,47,255,255,255,255,0,0,47,128,47,128,0,0,63,0,0,26,64,47,128,0,0,42,0,
  // 0x503c  值
  60,80,35,35,59,37,1,253,0,0,80,0,0,58,64,0,0,0,0,253,0,0,63,64,0,0,0,1,252,0,0,127,0,0,0,0,3,248,0,0,127,0,0,0,0,3,246,255,255,255,255,255,208,0,11,242,255,255,255,255,255,208,0,15,210,255,255,255,255,255,208,0,47,192,0,0,252,0,0,0,0,127,64,0,1,252,0,0,0,0,255,0,0,1,248,0,0,0,2,255,0,63,255,255,255,253,0,3,255,0,63,255,255,255,253,0,15,255,0,63,170,170,170,253,0,47,255,0,63,0,0,0,253,0,127,255,0,63,0,0,0,253,0,191,191,0,63,149,85,85,253,0,62,127,0,63,255,255,255,253,0,28,127,0,63,255,255,255,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,149,85,85,253,0,0,127,0,63,255,255,255,253,0,0,127,0,63,255,255,255,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,255,255,255,253,0,0,127,0,63,255,255,255,253,0,0,127,0,63,149,85,85,253,0,0,127,0,63,0,0,0,253,0,0,127,0,63,0,0,0,253,0,0,127,31,255,255,255,255,255,244,0,127,31,255,255,255,255,255,244,0,127,31,255,255,255,255,255,244,0,127,0,0,0,0,0,0,0,
  // 0x503e  倾
  62,80,35,36,68,37,1,252,0,6,64,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,192,0,47,255,255,255,244,0,31,192,0,47,255,255,255,244,0,63,139,208,47,255,255,255,244,0,63,11,208,0,0,254,0,0,0,191,11,208,0,0,253,0,0,0,254,11,208,0,1,252,0,0,1,253,11,208,0,2,248,0,0,3,252,11,208,3,255,255,255,192,7,252,11,208,3,255,255,255,192,15,252,11,255,227,255,255,255,192,47,252,11,255,227,240,0,31,192,63,252,11,255,227,240,84,31,192,255,252,11,208,3,240,188,31,192,254,252,11,208,3,240,188,31,192,188,252,11,208,3,240,188,31,192,52,252,11,208,3,240,188,31,192,16,252,11,208,3,240,188,31,192,0,252,11,208,3,240,188,31,192,0,252,11,208,3,240,188,31,192,0,252,11,208,3,240,188,31,192,0,252,11,208,147,240,252,31,192,0,252,11,219,211,240,252,31,192,0,252,15,255,211,240,252,31,192,0,252,31,255,67,241,248,31,192,0,252,47,248,2,146,244,5,64,0,252,15,128,0,3,242,64,0,0,252,9,0,0,15,231,224,0,0,252,0,0,0,47,203,252,0,0,252,0,0,0,191,65,255,64,0,252,0,0,3,254,0,127,208,0,252,0,0,47,244,0,15,244,0,252,0,0,127,192,0,3,224,0,252,0,0,29,0,0,0,128,0,0,0,0,0,0,0,0,0,
  // 0x504f  偏
  79,80,35,35,59,37,1,253,0,1,64,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,243,255,255,255,255,255,244,0,11,227,255,255,255,255,255,244,0,15,211,255,255,255,255,255,244,0,47,192,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,127,0,106,170,170,170,170,128,0,255,0,191,255,255,255,255,192,1,254,0,191,255,255,255,255,192,3,254,0,189,0,0,0,31,192,11,254,0,189,0,0,0,31,192,31,254,0,189,0,0,0,31,192,63,254,0,191,170,170,170,191,192,191,254,0,191,255,255,255,255,192,255,190,0,191,255,255,255,255,192,188,190,0,253,0,0,0,0,0,52,190,0,253,0,0,0,0,0,16,190,0,255,170,170,170,170,144,0,190,0,255,255,255,255,255,224,0,190,0,255,255,255,255,255,224,0,190,0,255,208,244,46,7,224,0,190,1,255,208,244,46,7,224,0,190,2,255,208,244,46,7,224,0,190,3,255,208,244,46,7,224,0,190,3,251,255,255,255,255,224,0,190,7,251,255,255,255,255,224,0,190,11,235,250,254,191,175,224,0,190,15,219,208,244,46,7,224,0,190,47,203,208,244,46,7,224,0,190,127,75,208,244,46,7,224,0,190,191,11,208,244,46,7,224,0,190,45,11,208,244,46,191,224,0,190,4,11,208,244,46,127,208,0,126,0,11,192,164,41,62,64,
  // 0x505c  停
  92,80,35,35,59,37,1,253,0,0,80,0,0,42,0,0,0,0,0,253,0,0,127,0,0,0,0,1,252,0,0,127,0,0,0,0,3,252,0,0,127,0,0,0,0,7,247,255,255,255,255,255,244,0,15,243,255,255,255,255,255,244,0,31,211,255,255,255,255,255,244,0,63,192,0,0,0,0,0,0,0,127,64,5,85,85,85,84,0,0,255,0,31,255,255,255,254,0,3,255,0,31,255,255,255,254,0,7,255,0,31,128,0,0,254,0,31,255,0,31,128,0,0,254,0,63,255,0,31,213,85,85,254,0,255,255,0,31,255,255,255,254,0,255,127,0,31,255,255,255,254,0,124,63,0,0,0,0,0,0,0,52,63,0,0,0,0,0,0,0,0,63,15,255,255,255,255,255,248,0,63,15,255,255,255,255,255,248,0,63,15,250,170,170,170,171,248,0,63,15,192,0,0,0,1,248,0,63,15,192,0,0,0,1,248,0,63,15,195,255,255,255,245,248,0,63,15,195,255,255,255,245,248,0,63,0,3,255,255,255,240,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,1,255,255,0,0,0,0,63,0,0,255,254,0,0,0,0,63,0,0,191,244,0,0,0,
  // 0x50a8  储
  168,80,35,35,59,37,1,253,0,11,64,0,0,15,192,0,0,0,15,208,0,0,15,192,3,144,0,15,193,0,0,15,192,11,240,0,31,143,192,0,15,192,15,208,0,63,79,240,31,255,255,223,192,0,63,3,252,47,255,255,255,128,0,190,0,254,47,255,255,255,0,0,252,0,127,0,15,192,253,0,1,252,0,40,0,15,194,252,0,3,252,0,0,0,15,199,244,0,7,252,0,0,0,15,207,224,0,15,252,0,0,191,255,255,255,244,47,252,255,248,191,255,255,255,244,127,252,255,248,191,255,255,255,244,255,252,255,248,0,11,248,0,0,189,252,22,248,0,47,240,0,0,56,252,1,248,0,191,192,0,0,32,252,1,248,2,255,64,0,0,0,252,1,248,15,255,255,255,128,0,252,1,248,191,255,255,255,192,0,252,1,249,255,255,255,255,192,0,252,1,248,191,248,0,15,192,0,252,1,248,56,248,0,15,192,0,252,1,248,0,248,0,15,192,0,252,1,248,0,254,170,175,192,0,252,1,248,0,255,255,255,192,0,252,1,248,16,255,255,255,192,0,252,1,249,240,248,0,15,192,0,252,1,255,244,248,0,15,192,0,252,3,255,224,248,0,15,192,0,252,11,255,0,255,255,255,192,0,252,7,244,0,255,255,255,192,0,252,3,192,0,255,255,255,192,0,252,0,0,0,248,0,15,192,0,248,0,0,0,248,0,10,128,
  // 0x50cf  像
  207,80,35,35,59,37,1,253,0,2,64,0,228,0,0,0,0,0,3,244,2,252,0,0,0,0,0,7,240,3,254,170,160,0,0,0,15,224,15,255,255,253,0,0,0,15,208,47,255,255,253,0,0,0,47,192,127,64,3,248,0,0,0,63,129,254,0,15,240,0,0,0,127,7,253,85,111,229,85,64,0,255,47,255,255,255,255,255,192,2,254,63,255,255,255,255,255,192,3,254,11,248,0,190,0,15,192,11,254,2,248,0,190,0,15,192,31,254,2,248,0,190,0,15,192,63,254,2,249,85,190,85,95,192,255,254,2,255,255,255,255,255,192,255,190,2,255,255,255,255,255,192,188,190,0,0,127,227,240,0,0,52,190,0,3,255,66,244,2,64,16,190,0,127,255,192,252,11,224,0,190,11,255,159,240,252,47,240,0,190,15,253,7,248,190,255,128,0,190,3,128,47,252,127,253,0,0,190,0,1,255,190,63,240,0,0,190,0,31,248,63,47,192,0,0,190,2,255,208,63,79,208,0,0,190,15,253,1,255,139,240,0,0,190,7,208,11,255,195,248,0,0,190,1,0,127,239,194,253,0,0,190,0,2,255,79,192,255,64,0,190,0,47,248,15,192,127,208,0,190,6,255,208,47,192,47,244,0,190,47,254,0,127,64,11,240,0,190,15,224,255,255,0,1,192,0,190,5,0,127,252,0,0,0,0,126,0,0,127,160,0,0,0,
  // 0x5145  充
  69,81,34,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,244,0,0,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,11,244,0,4,0,0,0,0,0,15,240,0,63,0,0,0,0,0,47,192,0,191,192,0,0,0,0,63,128,0,47,244,0,0,0,0,191,0,0,11,253,0,0,0,0,254,0,0,1,255,64,0,10,171,255,175,255,255,255,208,0,31,255,255,255,255,255,255,244,0,15,255,255,255,255,255,255,252,0,15,255,254,170,149,80,2,255,0,0,0,0,0,0,0,0,253,0,0,0,15,208,2,252,0,48,0,0,0,31,208,2,252,0,0,0,0,0,31,208,2,252,0,0,0,0,0,47,192,2,252,0,0,0,0,0,47,192,2,252,0,0,0,0,0,63,192,2,252,0,0,0,0,0,127,64,2,252,0,4,0,0,0,255,0,2,252,0,11,128,0,1,255,0,2,252,0,11,208,0,3,253,0,2,252,0,15,208,0,31,248,0,2,252,0,15,208,0,191,240,0,2,252,0,15,192,27,255,192,0,1,253,64,111,192,255,254,0,0,1,255,255,255,128,127,224,0,0,0,255,255,255,0,62,0,0,0,0,47,255,249,0,0,0,0,0,0,0,0,0,0,
  // 0x5148  先
  72,81,33,36,68,37,2,252,0,0,0,3,240,0,0,0,0,0,7,224,3,244,0,0,0,0,0,11,240,3,244,0,0,0,0,0,15,224,3,244,0,0,0,0,0,15,208,3,244,0,0,0,0,0,47,213,87,245,85,85,80,0,0,63,255,255,255,255,255,240,0,0,127,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,1,253,0,3,244,0,0,0,0,3,252,0,3,244,0,0,0,0,7,248,0,3,244,0,0,0,0,15,240,0,3,244,0,0,0,0,7,208,0,3,244,0,0,0,0,0,64,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,21,85,111,213,87,253,85,85,64,0,0,47,192,2,252,0,0,0,0,0,63,192,2,252,0,0,0,0,0,63,128,2,252,0,0,0,0,0,63,64,2,252,0,0,0,0,0,191,0,2,252,0,0,0,0,0,255,0,2,252,0,0,0,0,2,253,0,2,252,0,14,64,0,3,252,0,2,252,0,15,192,0,15,244,0,2,252,0,15,192,0,127,240,0,2,252,0,31,192,2,255,192,0,2,252,0,47,128,111,255,0,0,1,255,255,255,128,255,248,0,0,0,255,255,255,0,63,208,0,0,0,127,255,253,0,29,0,0,0,0,0,85,64,0,0,0,0,0,0,0,0,0,0,
  // 0x5149  光
  73,81,35,36,68,37,1,252,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,64,0,0,109,0,1,252,0,2,248,0,0,191,0,1,252,0,3,252,0,0,63,128,1,252,0,7,248,0,0,47,192,1,252,0,15,240,0,0,15,224,1,252,0,15,224,0,0,11,240,1,252,0,47,192,0,0,3,248,1,252,0,63,128,0,0,3,252,1,252,0,255,0,0,0,1,253,1,252,1,253,0,0,0,0,228,1,252,0,104,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,21,85,91,245,85,255,85,85,80,0,0,11,240,0,191,0,0,0,0,0,11,240,0,191,0,0,0,0,0,15,240,0,191,0,0,0,0,0,15,224,0,191,0,0,0,0,0,15,208,0,191,0,0,0,0,0,31,208,0,191,0,0,0,0,0,63,192,0,191,0,0,0,0,0,63,128,0,191,0,1,0,0,0,255,64,0,191,0,2,208,0,1,255,0,0,191,0,3,244,0,7,253,0,0,191,0,3,244,0,31,248,0,0,191,0,3,244,0,255,240,0,0,191,0,3,240,27,255,192,0,0,191,64,11,240,127,254,0,0,0,127,255,255,224,47,240,0,0,0,63,255,255,192,14,0,0,0,0,11,255,254,64,0,0,0,0,0,0,0,0,0,
  // 0x5165  入
  101,81,34,33,41,37,2,253,0,1,85,85,84,0,0,0,0,0,7,255,255,252,0,0,0,0,0,7,255,255,252,0,0,0,0,0,7,255,255,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,10,253,0,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,47,255,0,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,63,255,64,0,0,0,0,0,0,191,191,128,0,0,0,0,0,0,255,47,192,0,0,0,0,0,0,255,31,208,0,0,0,0,0,2,253,15,240,0,0,0,0,0,3,252,11,244,0,0,0,0,0,11,248,7,248,0,0,0,0,0,15,240,3,253,0,0,0,0,0,47,224,1,255,0,0,0,0,0,127,192,0,255,128,0,0,0,0,255,64,0,127,208,0,0,0,2,255,0,0,47,240,0,0,0,11,253,0,0,15,252,0,0,0,47,248,0,0,3,255,0,0,0,191,224,0,0,1,255,192,0,2,255,192,0,0,0,127,244,0,31,255,0,0,0,0,47,254,0,191,252,0,0,0,0,7,255,208,255,224,0,0,0,0,1,255,192,63,64,0,0,0,0,0,63,0,8,0,0,0,0,0,0,8,0,
  // 0x5168  全
  104,81,35,34,50,37,1,254,0,0,0,3,253,0,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,31,255,192,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,255,143,248,0,0,0,0,0,3,255,3,254,0,0,0,0,0,15,252,1,255,128,0,0,0,0,63,240,0,127,240,0,0,0,0,255,208,0,31,252,0,0,0,7,255,64,0,7,255,64,0,0,31,253,0,0,0,255,224,0,0,191,240,0,0,0,63,253,0,7,255,192,0,0,0,11,255,192,63,254,0,0,0,0,2,255,244,127,247,255,255,255,255,255,175,240,31,71,255,255,255,255,255,71,208,8,7,255,255,255,255,255,64,64,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,253,0,0,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,
  // 0x5171  共
  113,81,33,35,59,37,2,253,0,0,169,0,0,26,128,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,5,85,255,85,85,127,213,85,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,0,0,254,0,0,47,192,0,0,85,85,255,85,85,127,213,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,45,0,0,45,0,0,0,0,0,191,192,0,255,128,0,0,0,2,255,64,0,127,240,0,0,0,15,253,0,0,15,253,0,0,0,63,244,0,0,3,255,128,0,1,255,208,0,0,0,191,240,0,15,255,0,0,0,0,31,252,0,127,248,0,0,0,0,7,255,0,47,208,0,0,0,0,0,254,0,6,0,0,0,0,0,0,48,0,
  // 0x5173  关
  115,81,26,36,252,37,5,252,0,4,0,0,1,144,0,0,125,0,0,3,252,0,0,255,0,0,3,252,0,0,63,192,0,11,244,0,0,47,208,0,15,224,0,0,15,240,0,47,192,0,0,7,244,0,63,64,0,0,3,224,0,47,0,0,1,86,85,85,85,85,0,7,255,255,255,255,255,64,7,255,255,255,255,255,64,7,255,255,255,255,255,64,0,0,1,252,0,0,0,0,0,1,252,0,0,0,0,0,1,252,0,0,0,0,0,1,252,0,0,0,0,0,1,252,0,0,0,0,0,2,253,0,0,0,47,255,255,255,255,255,224,47,255,255,255,255,255,224,47,255,255,255,255,255,224,0,0,3,255,0,0,0,0,0,7,255,128,0,0,0,0,11,255,192,0,0,0,0,15,255,224,0,0,0,0,47,219,240,0,0,0,0,127,195,252,0,0,0,0,255,66,255,0,0,0,7,254,0,255,192,0,0,31,248,0,63,244,0,1,255,224,0,15,254,0,27,255,128,0,3,255,224,191,253,0,0,0,255,240,63,224,0,0,0,31,208,14,0,0,0,0,1,128,0,0,0,0,0,0,0,
  // 0x5177  具
  119,81,33,34,50,37,2,253,0,26,170,170,170,170,170,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,192,0,0,0,191,0,0,0,47,192,0,0,0,191,0,0,0,47,192,0,0,0,191,0,0,0,47,234,170,170,170,255,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,192,0,0,0,191,0,0,0,47,192,0,0,0,191,0,0,0,47,192,0,0,0,191,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,234,170,170,170,255,0,0,0,47,192,0,0,0,191,0,0,0,47,192,0,0,0,191,0,0,0,47,234,170,170,170,255,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,47,64,0,62,0,0,0,0,2,255,224,1,255,228,0,0,0,111,255,128,0,191,255,128,0,11,255,248,0,0,7,255,248,0,191,255,128,0,0,0,111,255,128,63,244,0,0,0,0,2,255,0,14,0,0,0,0,0,0,56,0,
  // 0x5197  冗
  151,81,34,33,41,37,2,253,21,85,85,85,85,85,85,85,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,128,0,0,0,0,0,191,0,63,128,0,0,0,0,0,191,0,63,128,0,0,0,0,0,191,0,63,128,0,0,0,0,0,191,0,63,128,0,0,0,0,0,191,0,63,128,0,0,0,0,0,191,0,42,64,191,255,255,255,128,106,0,0,0,191,255,255,255,128,0,0,0,0,191,255,255,255,128,0,0,0,0,191,0,0,127,128,0,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,255,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,1,253,0,0,63,128,4,0,0,3,252,0,0,63,128,15,64,0,7,248,0,0,63,128,15,224,0,15,240,0,0,63,128,15,208,0,63,224,0,0,63,128,15,208,1,255,192,0,0,63,128,15,192,11,255,0,0,0,63,192,31,192,191,252,0,0,0,63,255,255,192,255,240,0,0,0,47,255,255,64,63,64,0,0,0,15,255,254,0,36,0,0,0,0,0,85,80,0,
  // 0x51b7  冷
  183,81,35,35,59,37,1,253,0,0,0,0,2,248,0,0,0,0,0,0,0,7,254,0,0,0,7,0,0,0,15,255,64,0,0,15,208,0,0,47,255,208,0,0,63,248,0,0,191,143,240,0,0,11,255,0,1,255,7,252,0,0,2,255,192,3,252,2,255,0,0,0,127,208,15,244,0,191,208,0,0,31,128,127,208,0,47,244,0,0,6,1,255,128,0,11,254,0,0,0,7,254,0,0,2,255,208,0,0,47,251,255,255,254,127,248,0,1,255,227,255,255,254,31,244,0,0,255,67,255,255,254,3,224,0,0,124,0,0,0,0,0,128,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,66,255,255,255,255,255,0,0,7,210,255,255,255,255,255,0,0,15,242,255,255,255,255,255,0,0,47,208,0,31,208,0,191,0,0,63,192,0,31,192,0,191,0,0,255,64,0,31,192,0,191,0,1,254,0,0,31,192,0,191,0,3,252,0,0,31,192,0,191,0,11,248,0,0,31,192,0,191,0,31,240,0,0,31,192,0,191,0,63,208,0,0,31,192,255,254,0,127,192,0,0,31,192,191,253,0,31,64,0,0,31,192,127,248,0,6,0,0,0,31,192,20,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,
  // 0x51c6  准
  198,81,35,35,59,37,1,253,0,0,0,0,164,0,25,0,0,0,0,0,0,254,0,63,192,0,2,0,0,1,252,0,63,64,0,11,224,0,3,248,0,127,0,0,31,252,0,7,244,0,254,0,0,7,255,64,15,240,0,252,0,0,0,255,208,31,208,2,252,0,0,0,47,240,63,255,255,255,255,224,0,11,192,127,255,255,255,255,224,0,2,64,255,255,255,255,255,224,0,0,2,255,192,7,240,0,0,0,0,7,255,128,7,240,0,0,0,0,15,255,128,7,240,0,0,0,0,63,255,128,7,240,0,0,0,0,191,239,192,7,240,0,0,0,0,63,111,255,255,255,255,192,0,0,14,47,255,255,255,255,192,0,0,0,47,255,255,255,255,192,0,0,0,47,128,7,240,0,0,0,3,0,47,128,7,240,0,0,0,11,192,47,128,7,240,0,0,0,31,224,47,128,7,240,0,0,0,63,192,47,255,255,255,255,192,0,191,64,47,255,255,255,255,192,0,255,0,47,255,255,255,255,192,3,253,0,47,192,7,240,0,0,7,248,0,47,128,7,240,0,0,15,240,0,47,128,7,240,0,0,63,208,0,47,128,7,240,0,0,127,192,0,47,128,7,240,0,0,47,64,0,47,255,255,255,255,244,10,0,0,47,255,255,255,255,244,0,0,0,47,255,255,255,255,244,0,0,0,47,192,0,0,0,0,0,0,0,31,128,0,0,0,0,
  // 0x51fa  出
  250,81,29,35,24,37,4,253,0,0,0,106,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,127,0,0,0,0,5,64,0,127,0,0,84,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,192,0,127,0,0,254,0,31,213,85,191,85,85,254,0,31,255,255,255,255,255,254,0,31,255,255,255,255,255,254,0,31,255,255,255,255,255,254,0,0,0,0,127,0,0,0,0,0,0,0,127,0,0,0,0,189,0,0,127,0,0,31,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,254,0,0,127,0,0,47,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,192,255,85,85,85,85,85,111,192,254,0,0,0,0,0,47,192,190,0,0,0,0,0,31,192,
  // 0x51fb  击
  251,81,33,35,59,37,2,253,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,1,85,85,87,249,85,85,80,0,3,255,255,255,255,255,255,244,0,3,255,255,255,255,255,255,244,0,3,255,255,255,255,255,255,244,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,85,85,85,87,249,85,85,85,64,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,84,0,3,244,0,5,64,0,2,252,0,3,244,0,15,224,0,2,252,0,3,244,0,15,224,0,2,252,0,3,244,0,15,224,0,2,252,0,3,244,0,15,224,0,2,252,0,3,244,0,15,224,0,2,252,0,3,244,0,15,224,0,2,252,0,3,244,0,15,224,0,2,252,0,3,244,0,15,224,0,2,253,85,87,249,85,95,224,0,2,255,255,255,255,255,255,224,0,2,255,255,255,255,255,255,224,0,2,255,255,255,255,255,255,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,
  // 0x5206  分
  6,82,35,35,59,37,1,252,0,0,11,208,0,27,128,0,0,0,0,15,240,0,63,192,0,0,0,0,47,224,0,31,224,0,0,0,0,63,192,0,15,244,0,0,0,0,191,128,0,7,252,0,0,0,1,255,0,0,2,255,0,0,0,3,254,0,0,0,255,128,0,0,11,252,0,0,0,127,208,0,0,31,240,0,0,0,47,244,0,0,127,224,0,0,0,15,252,0,1,255,128,0,0,0,3,255,0,7,255,0,0,0,0,1,255,208,47,252,0,0,0,0,0,127,244,191,255,255,255,255,255,255,239,248,127,207,255,255,255,255,255,203,224,31,15,255,255,255,255,255,194,128,4,5,85,127,213,85,127,192,0,0,0,0,63,128,0,47,192,0,0,0,0,127,64,0,47,192,0,0,0,0,191,0,0,63,192,0,0,0,0,191,0,0,63,128,0,0,0,0,255,0,0,63,128,0,0,0,1,254,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,7,252,0,0,63,64,0,0,0,15,244,0,0,63,64,0,0,0,47,240,0,0,127,64,0,0,0,191,192,0,0,127,0,0,0,3,255,64,0,0,191,0,0,0,31,254,0,0,0,255,0,0,1,255,248,0,37,87,254,0,0,15,255,208,0,47,255,253,0,0,3,254,0,0,31,255,248,0,0,1,224,0,0,15,255,144,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5207  切
  7,82,34,34,50,37,1,253,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,15,255,255,255,255,240,0,191,0,15,255,255,255,255,224,0,191,0,15,255,255,255,255,224,0,191,0,5,85,254,85,95,224,0,191,0,0,0,253,0,15,224,0,191,0,5,0,252,0,15,224,0,191,22,255,0,252,0,15,224,0,191,255,255,1,252,0,15,224,111,255,255,255,1,252,0,15,224,191,255,254,64,1,252,0,15,224,191,255,64,0,1,252,0,15,224,121,191,0,0,1,252,0,15,208,0,191,0,0,2,252,0,15,208,0,191,0,0,2,248,0,15,208,0,191,0,0,3,248,0,15,208,0,191,0,0,3,244,0,15,208,0,191,0,96,3,244,0,31,208,0,191,0,125,7,240,0,31,192,0,191,0,190,11,240,0,31,192,0,191,0,189,15,224,0,31,192,0,127,0,253,31,208,0,31,192,0,127,255,252,63,192,0,47,192,0,63,255,248,127,128,0,47,192,0,31,255,240,255,0,0,63,192,0,0,85,2,254,0,0,63,128,0,0,0,7,252,0,0,63,128,0,0,0,15,244,0,0,127,64,0,0,0,127,224,0,0,255,0,0,0,2,255,192,11,255,255,0,0,0,3,255,0,3,255,253,0,0,0,0,248,0,3,255,248,0,0,0,0,96,0,1,85,64,0,
  // 0x521b  创
  27,82,33,35,59,37,1,253,0,0,10,0,0,0,0,5,64,0,0,31,208,0,0,0,47,192,0,0,63,192,0,0,0,47,192,0,0,127,208,0,0,0,47,192,0,0,255,244,0,6,144,47,192,0,2,255,253,0,11,224,47,192,0,3,252,255,0,11,224,47,192,0,15,240,63,192,11,224,47,192,0,47,208,31,240,11,224,47,192,0,191,128,11,248,11,224,47,192,2,255,0,2,253,11,224,47,192,11,252,0,0,255,11,224,47,192,47,244,0,0,127,203,224,47,192,191,208,0,0,47,11,224,47,192,63,255,255,255,248,11,224,47,192,12,191,255,255,240,11,224,47,192,0,191,255,255,240,11,224,47,192,0,190,0,7,240,11,224,47,192,0,190,0,7,240,11,224,47,192,0,190,0,11,224,11,224,47,192,0,190,0,11,224,11,224,47,192,0,190,0,15,224,11,224,47,192,0,190,0,15,208,11,224,47,192,0,190,15,191,192,11,224,47,192,0,190,15,255,128,11,224,47,192,0,190,11,254,0,1,64,47,192,0,190,0,0,20,0,0,47,192,0,190,0,0,47,64,0,47,192,0,190,0,0,47,64,0,47,192,0,190,0,0,63,64,0,47,192,0,191,0,0,127,0,0,47,192,0,127,255,255,255,1,80,127,192,0,63,255,255,253,3,255,255,128,0,11,255,255,228,1,255,255,0,0,0,0,0,0,0,255,232,0,
  // 0x521d  初
  29,82,34,35,59,37,1,253,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,11,255,255,255,255,224,0,15,208,11,255,255,255,255,224,0,15,208,11,255,255,255,255,224,0,15,224,1,85,255,85,95,224,63,255,255,224,0,254,0,15,224,63,255,255,244,0,254,0,15,224,63,255,255,240,0,254,0,15,224,0,0,15,208,0,253,0,15,224,0,0,47,192,0,253,0,15,224,0,0,63,64,0,253,0,15,224,0,0,255,0,0,253,0,15,224,0,1,252,40,1,252,0,15,208,0,3,248,126,1,252,0,15,208,0,15,240,253,1,252,0,15,208,0,47,250,244,2,252,0,15,208,0,191,255,208,3,248,0,15,208,2,255,255,192,3,248,0,15,208,11,255,255,224,3,244,0,15,208,47,255,219,248,7,240,0,31,192,191,223,210,252,15,240,0,31,192,127,79,208,244,15,224,0,31,192,45,15,208,32,47,192,0,31,192,0,15,208,0,63,192,0,47,192,0,15,208,0,191,64,0,47,192,0,15,208,0,255,0,0,63,192,0,15,208,3,253,0,0,63,128,0,15,208,11,252,0,0,63,64,0,15,208,47,240,0,0,255,64,0,15,208,255,208,11,255,255,0,0,15,208,255,128,3,255,253,0,0,15,208,62,0,3,255,248,0,0,15,208,4,0,1,85,64,0,
  // 0x522b  别
  43,82,33,35,59,37,1,252,0,0,0,0,0,0,0,47,192,11,255,255,255,208,0,0,47,192,11,255,255,255,208,0,0,47,192,11,255,255,255,208,0,0,47,192,11,224,0,15,208,31,192,47,192,11,224,0,15,208,31,192,47,192,11,224,0,15,208,31,192,47,192,11,224,0,15,208,31,192,47,192,11,224,0,15,208,31,192,47,192,11,224,0,15,208,31,192,47,192,11,255,255,255,208,31,192,47,192,11,255,255,255,208,31,192,47,192,11,255,255,255,208,31,192,47,192,0,0,0,0,0,31,192,47,192,0,2,248,0,0,31,192,47,192,0,2,244,0,0,31,192,47,192,0,3,244,0,0,31,192,47,192,63,255,255,255,240,31,192,47,192,63,255,255,255,240,31,192,47,192,63,255,255,255,240,31,192,47,192,0,7,240,11,240,31,192,47,192,0,7,240,11,240,31,192,47,192,0,11,224,11,240,31,192,47,192,0,15,224,11,224,31,192,47,192,0,15,208,11,224,5,64,47,192,0,31,192,15,224,0,0,47,192,0,63,128,15,224,0,0,47,192,0,127,0,15,208,0,0,47,192,0,255,0,15,208,0,0,47,192,3,252,0,47,192,0,0,47,192,15,244,63,255,192,0,85,127,128,127,224,31,255,64,0,255,255,128,63,128,15,253,0,0,255,255,0,13,0,0,0,0,0,191,248,0,0,0,0,0,0,0,0,0,0,
  // 0x5230  到
  48,82,33,34,50,37,1,253,0,0,0,0,0,0,0,26,128,0,0,0,0,0,0,0,31,192,63,255,255,255,254,0,0,31,192,63,255,255,255,254,0,0,31,192,63,255,255,255,254,63,64,31,192,0,15,240,0,0,63,64,31,192,0,15,224,4,0,63,64,31,192,0,31,192,127,0,63,64,31,192,0,47,192,63,128,63,64,31,192,0,63,64,31,208,63,64,31,192,0,127,0,11,240,63,64,31,192,21,255,255,255,252,63,64,31,192,63,255,255,255,253,63,64,31,192,63,255,255,255,255,63,64,31,192,63,169,84,0,63,63,64,31,192,0,0,127,0,24,63,64,31,192,0,0,127,0,0,63,64,31,192,0,0,127,0,0,63,64,31,192,0,0,127,0,0,63,64,31,192,15,255,255,255,248,63,64,31,192,15,255,255,255,248,63,64,31,192,15,255,255,255,248,63,64,31,192,0,0,127,0,0,63,64,31,192,0,0,127,0,0,63,64,31,192,0,0,127,0,0,21,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,22,190,0,0,31,192,0,5,191,255,255,0,0,31,192,111,255,255,255,255,0,0,31,192,127,255,255,255,233,0,149,127,192,63,255,250,80,0,0,255,255,192,62,148,0,0,0,0,255,255,64,0,0,0,0,0,0,191,248,0,
  // 0x5236  制
  54,82,34,35,59,37,1,253,0,0,31,128,0,0,0,5,64,0,248,47,128,0,0,0,15,208,2,252,47,128,0,0,0,15,208,3,248,47,128,0,1,248,15,208,3,244,47,128,0,2,248,15,208,7,255,255,255,254,2,248,15,208,11,255,255,255,254,2,248,15,208,15,255,255,255,254,2,248,15,208,47,192,47,128,0,2,248,15,208,63,128,47,128,0,2,248,15,208,127,0,47,128,0,2,248,15,208,10,0,47,128,0,2,248,15,208,127,255,255,255,255,194,248,15,208,127,255,255,255,255,194,248,15,208,127,255,255,255,255,194,248,15,208,0,0,47,128,0,2,248,15,208,0,0,47,128,0,2,248,15,208,0,0,47,128,0,2,248,15,208,0,0,47,128,0,2,248,15,208,11,255,255,255,255,2,248,15,208,11,255,255,255,255,2,248,15,208,11,255,255,255,255,2,248,15,208,11,208,47,128,63,2,248,15,208,11,208,47,128,63,2,248,15,208,11,208,47,128,63,1,164,15,208,11,208,47,128,63,0,0,15,208,11,208,47,128,63,0,0,15,208,11,208,47,128,63,0,0,15,208,11,208,47,128,63,0,0,15,208,11,208,47,143,255,0,0,15,208,11,208,47,143,254,0,0,15,208,11,208,47,139,248,0,21,111,192,0,0,47,128,0,0,63,255,192,0,0,47,128,0,0,63,255,128,0,0,31,128,0,0,47,249,0,
  // 0x5237  刷
  55,82,33,35,59,37,1,253,0,0,0,0,0,0,0,5,64,0,0,0,0,0,0,0,15,192,3,255,255,255,255,0,0,15,192,3,255,255,255,255,1,64,15,192,3,255,255,255,255,7,224,15,192,3,240,0,0,63,7,224,15,192,3,240,0,0,63,7,224,15,192,3,240,0,0,63,7,224,15,192,3,240,0,0,63,7,224,15,192,3,255,255,255,255,7,224,15,192,3,255,255,255,255,7,224,15,192,3,255,255,255,255,7,224,15,192,3,240,1,248,0,7,224,15,192,3,240,1,248,0,7,224,15,192,3,240,1,248,0,7,224,15,192,3,240,1,248,0,7,224,15,192,3,251,255,255,255,71,224,15,192,3,255,255,255,255,71,224,15,192,7,255,255,255,255,71,224,15,192,7,239,193,248,31,71,224,15,192,7,239,193,248,31,71,224,15,192,7,239,193,248,31,71,224,15,192,11,239,193,248,31,71,224,15,192,11,223,193,248,31,71,224,15,192,15,223,193,248,31,71,224,15,192,15,207,193,248,31,65,80,15,192,15,207,193,248,31,64,0,15,192,31,207,193,248,31,64,0,15,192,31,143,193,251,255,64,0,15,192,63,79,193,249,255,0,0,15,192,63,15,193,248,164,0,0,15,192,190,0,1,248,0,0,85,111,192,189,0,1,248,0,0,127,255,192,28,0,1,248,0,0,63,255,64,0,0,1,248,0,0,47,249,0,
  // 0x5272  割
  114,82,32,35,24,37,2,253,0,0,252,0,0,0,0,21,0,0,252,0,0,0,0,63,0,0,252,0,0,0,0,63,170,170,255,170,168,0,0,63,255,255,255,255,253,47,128,63,255,255,255,255,253,47,128,63,252,0,0,0,253,47,128,63,252,0,252,0,253,47,128,63,252,0,252,0,253,47,128,63,254,170,254,170,253,47,128,63,15,255,255,255,208,47,128,63,15,255,255,255,208,47,128,63,0,0,252,0,0,47,128,63,0,0,252,0,0,47,128,63,15,255,255,255,192,47,128,63,15,255,255,255,192,47,128,63,5,85,254,85,64,47,128,63,0,0,252,0,0,47,128,63,0,0,252,0,0,47,128,63,255,255,255,255,252,47,128,63,255,255,255,255,252,47,128,63,170,170,170,170,168,47,128,63,0,0,0,0,0,47,128,63,6,170,170,170,128,47,128,63,15,255,255,255,208,47,128,63,15,255,255,255,208,0,0,63,15,192,0,15,208,0,0,63,15,192,0,15,208,0,0,63,15,192,0,15,208,0,0,63,15,192,0,15,208,0,0,63,15,234,170,175,208,0,0,63,15,255,255,255,208,2,170,255,15,255,255,255,208,2,255,255,15,192,0,15,208,1,255,253,11,192,0,5,64,0,255,228,
  // 0x529b  力
  155,82,32,35,24,37,2,253,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,0,0,0,63,64,0,0,0,63,255,255,255,255,255,255,254,63,255,255,255,255,255,255,253,63,255,255,255,255,255,255,253,26,170,170,191,170,170,170,253,0,0,0,191,0,0,0,253,0,0,0,191,0,0,1,253,0,0,0,255,0,0,1,252,0,0,0,254,0,0,1,252,0,0,0,254,0,0,1,252,0,0,1,253,0,0,2,252,0,0,3,252,0,0,2,252,0,0,3,252,0,0,2,252,0,0,11,248,0,0,3,252,0,0,15,240,0,0,3,248,0,0,31,224,0,0,3,248,0,0,63,208,0,0,3,248,0,0,191,192,0,0,3,244,0,1,255,0,0,0,7,244,0,7,254,0,0,0,11,240,0,15,252,0,0,0,11,240,0,63,240,0,0,0,15,240,1,255,208,0,0,0,31,224,11,255,64,0,0,0,63,208,63,253,0,0,15,255,255,192,191,240,0,0,7,255,255,64,47,128,0,0,3,255,253,0,9,0,0,0,1,85,64,0,
  // 0x529f  功
  159,82,34,34,50,37,1,253,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,63,255,255,244,0,127,0,0,0,63,255,255,244,0,127,0,0,0,63,255,255,244,0,127,0,0,0,0,15,208,1,85,191,85,85,64,0,15,208,3,255,255,255,255,224,0,15,208,3,255,255,255,255,224,0,15,208,3,255,255,255,255,224,0,15,208,0,0,191,0,15,224,0,15,208,0,0,254,0,15,208,0,15,208,0,0,254,0,15,208,0,15,208,0,0,253,0,15,208,0,15,208,0,0,253,0,15,208,0,15,208,0,0,252,0,15,208,0,15,208,0,1,252,0,15,208,0,15,208,0,2,252,0,15,192,0,15,208,0,3,248,0,15,192,0,15,209,188,3,244,0,31,192,0,15,255,252,7,240,0,31,192,0,111,255,253,15,240,0,31,192,111,255,255,228,31,224,0,47,192,127,255,244,0,63,192,0,47,192,63,249,0,0,191,128,0,47,192,61,0,0,1,255,0,0,63,128,0,0,0,3,254,0,0,63,128,0,0,0,15,252,0,0,127,64,0,0,0,127,240,0,0,255,0,0,0,3,255,192,15,255,255,0,0,0,3,255,0,7,255,253,0,0,0,0,248,0,3,255,240,0,0,0,0,80,0,0,20,0,0,
  // 0x52a0  加
  160,82,33,36,68,37,1,252,0,5,64,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,85,85,85,64,0,15,208,0,0,255,255,255,192,0,15,208,0,0,255,255,255,192,63,255,255,255,208,255,255,255,192,63,255,255,255,208,252,0,47,192,63,255,255,255,208,252,0,47,192,21,111,213,95,208,252,0,47,192,0,31,192,15,208,252,0,47,192,0,31,192,15,192,252,0,47,192,0,31,192,15,192,252,0,47,192,0,31,192,15,192,252,0,47,192,0,31,192,15,192,252,0,47,192,0,47,192,15,192,252,0,47,192,0,47,128,15,192,252,0,47,192,0,63,128,15,192,252,0,47,192,0,63,64,31,192,252,0,47,192,0,63,64,31,192,252,0,47,192,0,63,0,31,192,252,0,47,192,0,127,0,31,192,252,0,47,192,0,191,0,31,192,252,0,47,192,0,254,0,31,192,252,0,47,192,1,253,0,47,192,252,0,47,192,2,252,0,47,192,252,0,47,192,3,252,0,47,128,252,0,47,192,7,244,0,63,128,255,255,255,192,15,240,0,63,64,255,255,255,192,31,224,0,191,64,255,255,255,192,63,192,255,255,0,253,85,127,192,191,128,191,254,0,252,0,47,192,47,0,191,248,0,252,0,47,128,8,0,21,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x52a8  动
  168,82,33,35,59,37,2,253,0,0,0,0,0,5,64,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,47,255,255,254,0,31,192,0,0,47,255,255,254,0,31,192,0,0,47,255,255,254,0,31,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,21,111,213,85,0,0,0,0,0,127,255,255,255,192,0,0,0,0,127,255,255,255,192,0,0,0,0,127,255,255,255,192,255,255,255,255,0,47,128,47,192,255,255,255,255,0,63,128,47,128,255,255,255,255,0,63,64,47,128,0,127,64,0,0,63,64,47,128,0,127,0,0,0,63,64,47,128,0,191,0,0,0,63,0,63,128,0,253,1,160,0,127,0,63,128,0,252,3,240,0,191,0,63,128,1,252,2,244,0,190,0,63,64,3,248,1,252,0,254,0,63,64,3,240,0,253,0,253,0,63,64,7,240,0,190,1,252,0,63,64,15,208,6,255,2,252,0,63,0,31,219,255,255,67,248,0,63,0,63,255,255,255,139,244,0,127,0,127,255,254,95,207,240,0,127,0,63,254,64,15,95,208,0,191,0,62,64,0,0,63,192,0,254,0,0,0,0,0,255,128,1,254,0,0,0,0,2,255,15,255,252,0,0,0,0,3,253,7,255,248,0,0,0,0,0,180,3,255,224,0,0,0,0,0,16,0,20,0,0,
  // 0x5316  化
  22,83,35,34,50,37,1,253,0,0,15,128,63,64,0,0,0,0,0,47,192,63,64,0,0,0,0,0,63,192,63,64,0,0,0,0,0,191,64,63,64,0,0,0,0,0,255,0,63,64,0,0,0,0,3,253,0,63,64,0,0,0,0,7,248,0,63,64,0,8,0,0,15,240,0,63,64,0,62,0,0,63,224,0,63,64,0,255,64,0,191,224,0,63,64,7,255,128,1,255,224,0,63,64,63,253,0,3,255,224,0,63,65,255,240,0,15,255,224,0,63,79,255,64,0,63,255,224,0,63,255,248,0,0,255,223,224,0,63,255,192,0,0,191,79,224,0,63,253,0,0,0,62,15,224,0,63,208,0,0,0,40,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,0,0,0,15,224,0,63,64,0,1,0,0,15,224,0,63,64,0,2,228,0,15,224,0,63,64,0,2,248,0,15,224,0,63,64,0,2,248,0,15,224,0,63,64,0,3,244,0,15,224,0,63,64,0,3,244,0,15,224,0,63,192,0,11,240,0,15,224,0,63,255,255,255,224,0,15,224,0,31,255,255,255,192,0,15,224,0,7,255,255,255,64,0,10,144,0,0,0,0,0,0,
  // 0x5347  升
  71,83,33,35,59,37,2,253,0,0,0,0,0,5,64,0,0,0,0,0,11,192,15,208,0,0,0,0,1,191,240,15,208,0,0,0,0,47,255,240,15,208,0,0,0,27,255,255,64,15,208,0,0,6,255,255,224,0,15,208,0,0,191,255,254,0,0,15,208,0,0,63,254,253,0,0,15,208,0,0,62,64,253,0,0,15,208,0,0,0,0,253,0,0,15,208,0,0,0,0,253,0,0,15,208,0,0,0,0,253,0,0,15,208,0,0,0,0,253,0,0,15,208,0,0,0,0,253,0,0,15,208,0,0,0,0,253,0,0,15,208,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,254,85,85,95,229,85,64,0,0,253,0,0,15,208,0,0,0,1,252,0,0,15,208,0,0,0,1,252,0,0,15,208,0,0,0,2,252,0,0,15,208,0,0,0,3,248,0,0,15,208,0,0,0,7,244,0,0,15,208,0,0,0,15,240,0,0,15,208,0,0,0,31,224,0,0,15,208,0,0,0,63,208,0,0,15,208,0,0,0,255,128,0,0,15,208,0,0,2,255,0,0,0,15,208,0,0,15,253,0,0,0,15,208,0,0,127,244,0,0,0,15,208,0,0,255,208,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,24,0,0,0,0,15,208,0,0,
  // 0x534a  半
  74,83,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,104,0,7,240,0,15,64,0,1,253,0,7,240,0,31,224,0,0,255,0,7,240,0,63,192,0,0,127,128,7,240,0,127,128,0,0,63,192,7,240,0,255,0,0,0,31,224,7,240,1,254,0,0,0,15,240,7,240,3,252,0,0,0,7,244,7,240,7,244,0,0,0,3,224,7,240,7,240,0,0,0,1,0,7,240,0,64,0,0,0,0,0,7,240,0,0,0,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,5,85,85,91,249,85,85,84,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,85,91,249,85,85,85,64,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,
  // 0x534f  协
  79,83,34,35,59,37,2,253,1,252,0,0,10,128,0,0,0,1,252,0,0,15,192,0,0,0,1,252,0,0,15,192,0,0,0,1,252,0,0,15,192,0,0,0,1,252,0,0,15,192,0,0,0,1,252,0,0,15,192,0,0,0,1,252,0,0,15,192,0,0,0,1,252,0,255,255,255,255,192,0,1,252,0,255,255,255,255,192,0,255,255,252,255,255,255,255,192,0,255,255,252,85,95,213,111,192,0,255,255,252,0,15,192,47,128,0,1,252,0,0,31,192,47,128,0,1,252,0,0,31,192,47,128,0,1,252,1,248,47,192,47,238,0,1,252,2,248,47,128,47,255,0,1,252,3,244,63,128,47,191,0,1,252,3,240,63,64,47,175,64,1,252,7,240,63,0,47,159,128,1,252,11,224,127,0,63,143,192,1,252,15,208,254,0,63,79,192,1,252,47,192,253,0,63,75,208,1,252,63,65,252,0,63,75,224,1,252,47,3,252,0,63,71,224,1,252,5,7,244,0,63,67,224,1,252,0,15,240,0,63,0,0,1,252,0,47,208,0,63,0,0,1,252,0,63,192,0,127,0,0,1,252,0,255,64,0,127,0,0,1,252,3,254,0,0,191,0,0,1,252,11,252,0,1,254,0,0,1,252,63,240,11,255,253,0,0,1,252,127,208,7,255,252,0,0,1,252,15,64,3,255,224,0,0,0,168,1,0,0,0,0,0,0,
  // 0x5355  单
  85,83,33,35,59,37,2,253,0,0,16,0,0,0,64,0,0,0,2,244,0,0,3,248,0,0,0,3,252,0,0,3,252,0,0,0,1,255,0,0,11,244,0,0,0,0,191,64,0,31,240,0,0,0,0,63,192,0,63,192,0,0,0,0,31,128,0,127,64,0,0,2,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,2,252,0,7,240,0,11,240,0,2,252,0,7,240,0,11,240,0,2,252,0,7,240,0,11,240,0,2,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,2,254,170,175,254,170,175,240,0,2,252,0,7,240,0,11,240,0,2,252,0,7,240,0,11,240,0,2,252,0,7,240,0,11,240,0,2,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,1,255,255,255,255,255,255,240,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,7,244,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,
  // 0x5361  卡
  97,83,33,35,59,37,2,253,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,255,255,255,192,0,0,0,0,15,255,255,255,192,0,0,0,0,15,255,255,255,192,0,0,0,0,15,229,85,85,64,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,85,85,85,95,229,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,255,144,0,0,0,0,0,0,15,255,254,64,0,0,0,0,0,15,255,255,248,0,0,0,0,0,15,226,255,255,208,0,0,0,0,15,224,27,255,244,0,0,0,0,15,224,0,127,240,0,0,0,0,15,224,0,6,208,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,208,0,0,0,0,
  // 0x5370  印
  112,83,30,35,24,37,4,253,0,0,9,0,0,0,0,0,0,1,191,64,0,0,0,0,0,31,255,209,85,85,85,80,134,255,255,131,255,255,255,240,255,255,244,3,255,255,255,240,255,254,0,3,255,255,255,240,255,128,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,255,255,255,195,248,0,7,240,255,255,255,195,248,0,7,240,255,255,255,195,248,0,7,240,254,85,85,67,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,253,0,0,3,248,0,7,240,255,255,255,195,248,26,175,240,255,255,255,195,248,15,255,240,255,255,255,195,248,11,255,208,253,85,85,67,248,7,254,64,253,0,0,3,248,0,0,0,253,0,0,3,248,0,0,0,84,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,2,164,0,0,0,
  // 0x5371  危
  113,83,35,36,68,37,1,252,0,0,15,224,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,63,255,255,253,0,0,0,0,0,191,255,255,255,128,0,0,0,1,255,255,255,255,64,0,0,0,3,252,0,1,255,0,0,0,0,15,244,0,3,253,0,0,0,0,47,240,0,7,252,0,0,0,0,191,192,0,11,240,0,0,0,1,255,255,255,255,255,255,255,224,11,255,255,255,255,255,255,255,224,63,255,255,255,255,255,255,255,224,127,255,128,0,0,0,0,0,0,31,127,128,0,0,0,0,0,0,4,63,128,0,0,0,0,0,0,0,63,128,255,255,255,255,192,0,0,63,128,255,255,255,255,192,0,0,63,128,255,255,255,255,192,0,0,63,64,253,0,0,47,192,0,0,63,64,253,0,0,47,192,0,0,63,64,253,0,0,47,128,0,0,63,0,253,0,0,63,128,0,0,127,0,253,0,0,63,64,0,0,127,0,253,0,0,127,64,0,0,191,0,253,0,255,255,0,0,0,254,0,253,0,191,254,0,0,0,253,0,253,0,127,228,3,128,2,252,0,253,0,0,0,3,244,3,252,0,253,0,0,0,3,244,7,244,0,253,0,0,0,3,240,15,240,0,253,0,0,0,7,240,47,208,0,255,64,0,0,31,240,127,192,0,191,255,255,255,255,208,127,64,0,63,255,255,255,255,128,14,0,0,11,255,255,255,253,0,0,0,0,0,0,0,0,0,0,
  // 0x5374  却
  116,83,33,35,59,37,1,253,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,255,255,255,192,0,0,253,0,0,255,255,255,192,0,0,253,0,0,255,255,255,192,0,0,254,0,0,253,85,111,192,15,255,255,255,208,253,0,31,192,15,255,255,255,208,253,0,31,192,15,255,255,255,208,253,0,31,192,0,0,253,0,0,253,0,31,192,0,0,253,0,0,253,0,31,192,0,0,253,0,0,253,0,31,192,0,0,253,0,0,253,0,31,192,0,0,253,0,0,253,0,31,192,0,0,254,0,0,253,0,31,192,127,255,255,255,248,253,0,31,192,127,255,255,255,248,253,0,31,192,127,255,255,255,248,253,0,31,192,0,15,240,0,0,253,0,31,192,0,31,224,0,0,253,0,31,192,0,47,192,0,0,253,0,31,192,0,63,192,36,0,253,0,31,192,0,63,65,252,0,253,0,31,192,0,127,0,254,0,253,0,31,192,0,254,0,127,0,253,0,47,192,0,253,0,63,128,253,47,255,192,2,252,0,111,208,253,15,255,128,7,255,255,255,224,253,15,254,0,127,255,255,255,240,253,6,80,0,127,255,255,251,248,253,0,0,0,63,250,80,2,252,253,0,0,0,16,0,0,0,248,253,0,0,0,0,0,0,0,64,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,252,0,0,0,
  // 0x5378  卸
  120,83,33,35,59,37,1,253,0,46,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,127,0,0,0,255,255,255,192,0,190,0,0,0,255,255,255,192,0,255,255,255,240,255,255,255,192,2,255,255,255,240,254,0,31,192,3,255,255,255,240,253,0,15,192,11,240,127,0,0,253,0,15,192,31,208,63,0,0,253,0,15,192,63,192,63,0,0,253,0,15,192,15,0,63,0,0,253,0,15,192,0,0,63,0,0,253,0,15,192,63,255,255,255,252,253,0,15,192,63,255,255,255,252,253,0,15,192,63,255,255,255,252,253,0,15,192,0,0,127,0,0,253,0,15,192,0,0,63,0,0,253,0,15,192,1,80,63,0,0,253,0,15,192,3,240,63,0,0,253,0,15,192,3,240,63,255,224,253,0,15,192,3,240,63,255,224,253,0,15,192,3,240,63,255,224,253,0,15,192,3,240,63,0,0,253,0,15,192,3,240,63,0,0,253,0,15,192,3,240,63,0,0,253,0,15,192,3,240,63,0,0,253,10,175,192,3,240,63,0,20,253,15,255,192,3,240,63,111,252,253,11,255,128,3,246,255,255,252,253,7,249,0,111,255,255,255,252,253,0,0,0,191,255,255,249,0,253,0,0,0,127,255,148,0,0,253,0,0,0,122,64,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,
  // 0x538b  压
  139,83,35,33,41,37,1,253,2,255,255,255,255,255,255,255,244,2,255,255,255,255,255,255,255,244,2,255,255,255,255,255,255,255,244,2,249,85,85,85,85,85,85,80,2,244,0,0,0,0,0,0,0,2,244,0,0,11,240,0,0,0,2,244,0,0,11,240,0,0,0,2,244,0,0,11,240,0,0,0,2,244,0,0,11,240,0,0,0,2,244,0,0,11,240,0,0,0,2,244,0,0,11,240,0,0,0,2,244,0,0,11,240,0,0,0,3,244,0,0,11,240,0,0,0,3,244,127,255,255,255,255,255,64,3,244,127,255,255,255,255,255,64,3,244,127,255,255,255,255,255,64,3,244,0,0,11,240,0,0,0,3,244,0,0,11,240,0,0,0,3,244,0,0,11,240,8,0,0,3,240,0,0,11,240,127,0,0,3,240,0,0,11,240,63,192,0,3,240,0,0,11,240,15,240,0,7,240,0,0,11,240,3,252,0,11,224,0,0,11,240,1,254,0,11,224,0,0,11,240,0,120,0,15,208,0,0,11,240,0,16,0,15,192,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,63,139,255,255,255,255,255,255,240,127,75,255,255,255,255,255,255,240,191,11,255,255,255,255,255,255,240,46,1,85,85,85,85,85,85,80,4,0,0,0,0,0,0,0,0,
  // 0x539f  原
  159,83,34,33,41,37,1,253,1,255,255,255,255,255,255,255,240,1,255,255,255,255,255,255,255,240,1,255,255,255,255,255,255,255,240,1,252,0,0,15,244,0,0,0,1,252,0,0,15,240,0,0,0,1,252,0,0,31,224,0,0,0,1,252,10,170,191,250,170,168,0,1,252,15,255,255,255,255,252,0,1,252,15,255,255,255,255,252,0,1,252,15,208,0,0,2,252,0,1,252,15,208,0,0,2,252,0,1,252,15,208,0,0,2,252,0,1,252,15,255,255,255,255,252,0,1,252,15,255,255,255,255,252,0,1,252,15,234,170,170,171,252,0,1,252,15,208,0,0,2,252,0,1,252,15,208,0,0,2,252,0,2,252,15,250,170,170,171,252,0,2,248,15,255,255,255,255,252,0,2,248,15,255,255,255,255,252,0,3,248,0,0,7,240,0,0,0,3,244,0,0,7,240,0,0,0,3,244,0,249,7,240,31,64,0,7,240,2,253,7,240,63,208,0,11,240,7,248,7,240,15,244,0,11,224,15,240,7,240,3,253,0,15,224,63,208,7,240,0,255,64,31,208,255,128,7,240,0,63,192,47,199,254,0,7,240,0,31,240,63,143,248,0,7,240,0,11,240,127,66,224,15,255,240,0,3,128,127,0,0,11,255,224,0,0,0,5,0,0,7,255,64,0,0,0,
  // 0x53cc  双
  204,83,34,33,41,37,1,252,47,255,255,253,63,255,255,255,128,47,255,255,254,63,255,255,255,192,47,255,255,254,63,255,255,255,192,5,85,85,254,31,213,85,127,128,0,0,0,253,15,208,0,63,64,0,0,0,253,15,224,0,63,64,0,0,1,252,11,224,0,127,0,3,128,2,252,7,240,0,191,0,15,208,2,248,7,240,0,254,0,15,244,3,248,3,244,0,253,0,3,252,3,244,3,244,1,252,0,1,255,11,240,2,252,2,252,0,0,191,143,240,1,252,3,248,0,0,63,239,224,0,253,7,244,0,0,15,255,208,0,254,11,240,0,0,7,255,192,0,127,15,224,0,0,2,255,128,0,63,111,192,0,0,0,255,64,0,63,255,192,0,0,0,255,192,0,31,255,64,0,0,1,255,224,0,15,255,0,0,0,3,255,244,0,11,253,0,0,0,7,255,252,0,11,252,0,0,0,15,242,253,0,31,254,0,0,0,47,224,255,0,127,255,0,0,0,127,192,191,65,255,255,192,0,0,255,64,61,7,254,47,240,0,3,254,0,20,47,252,15,252,0,15,252,0,0,255,240,3,255,64,63,240,0,11,255,192,1,255,224,127,208,0,11,254,0,0,127,240,31,64,0,3,244,0,0,15,192,9,0,0,0,128,0,0,2,64,0,0,0,0,0,0,0,0,0,
  // 0x53cd  反
  205,83,33,33,41,37,2,253,0,85,85,85,85,85,85,84,0,0,255,255,255,255,255,255,253,0,0,255,255,255,255,255,255,253,0,0,255,255,255,255,255,255,253,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,192,0,0,254,111,229,85,85,127,192,0,0,254,15,240,0,0,191,64,0,0,253,11,244,0,0,255,0,0,0,253,3,252,0,2,254,0,0,0,253,2,253,0,3,252,0,0,0,252,0,255,0,11,248,0,0,1,252,0,191,128,31,240,0,0,1,252,0,63,208,63,208,0,0,2,252,0,31,240,255,128,0,0,3,248,0,11,255,255,0,0,0,3,244,0,3,255,252,0,0,0,7,240,0,0,255,244,0,0,0,11,240,0,2,255,248,0,0,0,15,224,0,31,255,255,64,0,0,31,208,0,191,254,255,244,0,0,63,192,47,255,208,127,255,144,0,127,71,255,254,0,11,255,255,64,255,7,255,240,0,1,255,255,64,61,2,254,0,0,0,11,254,0,8,0,208,0,0,0,0,108,0,
  // 0x53d6  取
  214,83,35,33,41,37,1,253,63,255,255,255,252,0,0,0,0,63,255,255,255,252,0,0,0,0,63,255,255,255,252,0,0,0,0,2,252,0,63,143,255,255,255,208,1,252,0,63,143,255,255,255,208,1,252,0,63,143,255,255,255,208,1,252,0,63,133,165,85,111,192,1,252,0,63,135,240,0,31,192,1,255,255,255,135,240,0,47,192,1,255,255,255,131,244,0,63,128,1,255,255,255,131,248,0,63,64,1,252,0,63,130,252,0,127,0,1,252,0,63,129,252,0,191,0,1,252,0,63,128,253,0,254,0,1,252,0,63,128,191,0,253,0,1,252,0,63,128,127,2,252,0,1,255,255,255,128,63,67,252,0,1,255,255,255,128,47,199,244,0,1,255,255,255,128,31,223,240,0,1,252,0,63,128,15,255,224,0,1,252,0,63,128,7,255,192,0,1,252,0,63,128,3,255,128,0,1,252,0,63,128,2,255,0,0,1,252,26,255,128,2,255,64,0,6,255,255,255,128,11,255,192,0,255,255,255,255,128,31,255,240,0,191,255,254,127,128,127,239,252,0,127,233,0,63,129,255,131,255,0,16,0,0,63,139,254,0,255,208,0,0,0,63,255,248,0,127,248,0,0,0,63,191,208,0,15,244,0,0,0,63,143,0,0,2,208,0,0,0,47,64,0,0,0,64,
  // 0x53d8  变
  216,83,33,36,68,37,2,252,0,0,0,11,208,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,3,252,0,0,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,11,240,3,244,0,0,0,0,8,11,240,3,244,16,0,0,0,63,139,240,3,244,188,0,0,0,127,75,240,3,245,255,0,0,0,255,11,240,3,244,127,192,0,2,252,11,240,3,244,31,240,0,7,248,11,240,3,244,7,252,0,31,240,11,240,3,244,2,254,0,31,192,11,240,3,244,0,190,0,3,0,11,240,3,244,0,52,0,0,0,11,240,3,244,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,253,0,0,3,255,255,255,255,255,255,128,0,3,255,255,255,255,255,255,0,0,0,15,240,0,0,3,253,0,0,0,3,252,0,0,15,248,0,0,0,0,255,0,0,63,224,0,0,0,0,127,224,1,255,128,0,0,0,0,15,253,15,253,0,0,0,0,0,2,255,255,244,0,0,0,0,0,0,191,255,128,0,0,0,0,0,6,255,255,228,0,0,0,0,1,255,255,255,255,144,0,0,26,255,255,249,31,255,255,233,0,255,255,254,64,0,191,255,255,192,63,255,144,0,0,1,191,255,0,46,64,0,0,0,0,0,110,0,0,0,0,0,0,0,0,0,0,
  // 0x53f0  台
  240,83,33,35,59,37,2,253,0,0,1,228,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,31,240,0,6,0,0,0,0,0,63,208,0,47,192,0,0,0,0,127,128,0,63,244,0,0,0,0,255,0,0,11,253,0,0,0,2,253,0,0,2,255,64,0,0,3,252,0,0,0,191,208,0,0,11,249,106,171,255,255,240,0,127,255,255,255,255,255,255,252,0,127,255,255,255,255,255,255,255,0,127,255,255,255,250,169,85,255,128,37,84,0,0,0,0,0,127,192,0,0,0,0,0,0,0,47,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,21,85,85,85,85,85,0,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,0,0,0,0,127,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,85,85,85,85,191,64,0,0,127,0,0,0,0,127,64,0,
  // 0x5403  吃
  3,84,33,35,59,37,3,253,0,0,0,0,164,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,253,0,0,0,0,85,85,80,2,252,0,0,0,0,255,255,240,3,248,0,0,0,0,255,255,240,11,244,0,0,0,0,255,255,240,15,255,255,255,255,0,252,3,240,31,255,255,255,255,0,252,3,240,63,255,255,255,255,0,252,3,240,191,64,0,0,0,0,252,3,241,255,0,0,0,0,0,252,3,243,253,0,0,0,0,0,252,3,255,248,0,0,0,0,0,252,3,243,240,0,0,0,0,0,252,3,240,139,255,255,255,208,0,252,3,240,11,255,255,255,240,0,252,3,240,11,255,255,255,128,0,252,3,240,0,0,11,253,0,0,252,3,240,0,0,63,244,0,0,252,3,240,0,0,255,192,0,0,252,3,240,0,3,254,0,0,0,252,3,240,0,31,248,0,0,0,255,255,240,0,127,208,0,0,0,255,255,240,1,255,64,0,0,0,255,255,240,7,253,0,0,0,0,253,85,80,15,240,0,0,20,0,252,0,0,63,192,0,0,31,128,252,0,0,127,64,0,0,47,128,168,0,0,255,0,0,0,47,128,0,0,0,254,0,0,0,63,64,0,0,0,255,64,0,0,127,0,0,0,0,255,255,255,255,255,0,0,0,0,63,255,255,255,253,0,0,0,0,11,255,255,255,248,0,0,0,0,0,21,85,85,0,0,
  // 0x5408  合
  8,84,35,35,59,37,1,253,0,0,0,2,253,0,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,31,255,192,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,255,143,248,0,0,0,0,0,3,255,3,255,0,0,0,0,0,15,252,0,255,192,0,0,0,0,63,240,0,63,240,0,0,0,1,255,192,0,15,253,0,0,0,7,255,0,0,3,255,128,0,0,47,252,0,0,0,191,244,0,1,255,224,0,0,0,31,254,0,15,255,255,255,255,255,255,255,224,127,254,191,255,255,255,248,191,248,63,244,191,255,255,255,248,31,240,31,64,0,0,0,0,0,3,208,4,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,192,0,0,15,255,255,255,255,255,192,0,0,15,255,255,255,255,255,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,224,0,0,0,47,192,0,0,15,255,255,255,255,255,192,0,0,15,255,255,255,255,255,192,0,0,15,255,255,255,255,255,192,0,0,15,224,0,0,0,47,192,0,0,11,208,0,0,0,31,192,0,
  // 0x540d  名
  13,84,32,35,24,37,1,253,0,0,0,185,0,0,0,0,0,0,1,255,0,0,0,0,0,0,3,253,0,0,0,0,0,0,11,252,0,0,0,0,0,0,31,255,255,255,244,0,0,0,127,255,255,255,252,0,0,0,255,255,255,255,244,0,0,7,254,0,0,15,240,0,0,31,248,0,0,47,208,0,0,191,240,0,0,63,192,0,3,255,252,0,0,255,64,0,31,255,255,64,1,254,0,0,127,244,255,224,7,252,0,0,31,192,47,248,15,244,0,0,10,0,11,254,63,224,0,0,0,0,2,255,255,192,0,0,0,0,0,191,255,0,0,0,0,0,0,63,252,0,0,0,0,0,0,191,244,0,0,0,0,0,3,255,255,255,255,255,0,0,47,255,255,255,255,255,0,1,255,255,255,255,255,255,0,31,255,244,0,0,0,191,6,255,255,244,0,0,0,191,127,255,211,244,0,0,0,191,63,253,3,244,0,0,0,191,31,128,3,244,0,0,0,191,4,0,3,244,0,0,0,191,0,0,3,244,0,0,0,191,0,0,3,244,0,0,0,191,0,0,3,255,255,255,255,255,0,0,3,255,255,255,255,255,0,0,3,255,255,255,255,255,0,0,3,244,0,0,0,191,0,0,2,160,0,0,0,190,
  // 0x540e  后
  14,84,35,35,59,37,1,253,0,0,0,0,0,0,1,128,0,0,0,0,0,0,6,191,240,0,0,0,0,1,107,255,255,252,0,0,186,175,255,255,255,255,228,0,0,191,255,255,255,255,164,0,0,0,191,255,255,233,64,0,0,0,0,191,165,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,85,85,85,85,85,85,80,0,191,255,255,255,255,255,255,248,0,191,255,255,255,255,255,255,248,0,191,255,255,255,255,255,255,248,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,254,7,255,255,255,255,253,0,0,254,7,255,255,255,255,253,0,0,253,7,255,255,255,255,253,0,0,253,7,240,0,0,0,253,0,1,252,7,240,0,0,0,253,0,2,252,7,240,0,0,0,253,0,3,252,7,240,0,0,0,253,0,3,248,7,240,0,0,0,253,0,7,244,7,240,0,0,0,253,0,11,240,7,240,0,0,0,253,0,15,224,7,240,0,0,0,253,0,47,208,7,255,255,255,255,253,0,63,192,7,255,255,255,255,253,0,191,64,7,255,255,255,255,253,0,31,0,7,240,0,0,0,253,0,8,0,7,240,0,0,0,253,0,
  // 0x5411  向
  17,84,31,35,24,37,3,253,0,0,0,122,64,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,0,0,0,0,0,0,2,254,0,0,0,0,0,0,3,252,0,0,0,0,21,85,87,253,85,85,85,80,127,255,255,255,255,255,255,248,127,255,255,255,255,255,255,248,127,255,255,255,255,255,255,248,127,0,0,0,0,0,3,248,127,0,0,0,0,0,3,248,127,0,0,0,0,0,3,248,127,0,0,0,0,0,3,248,127,0,191,255,255,248,3,248,127,0,191,255,255,248,3,248,127,0,191,255,255,248,3,248,127,0,189,0,2,248,3,248,127,0,189,0,2,248,3,248,127,0,189,0,2,248,3,248,127,0,189,0,2,248,3,248,127,0,189,0,2,248,3,248,127,0,189,0,2,248,3,248,127,0,189,0,2,248,3,248,127,0,191,255,255,248,3,248,127,0,191,255,255,248,3,248,127,0,191,255,255,248,3,248,127,0,189,0,0,0,3,248,127,0,189,0,0,0,3,248,127,0,189,0,0,0,3,248,127,0,0,0,0,0,3,248,127,0,0,0,0,21,91,244,127,0,0,0,0,63,255,244,127,0,0,0,0,63,255,240,127,0,0,0,0,31,254,64,
  // 0x5426  否
  38,84,34,33,41,37,1,253,31,255,255,255,255,255,255,255,208,31,255,255,255,255,255,255,255,208,31,255,255,255,255,255,255,255,208,0,0,0,0,191,224,0,0,0,0,0,0,1,255,128,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,255,252,15,128,0,0,0,0,7,255,252,63,248,0,0,0,0,127,254,252,47,255,64,0,0,2,255,241,252,2,255,240,0,0,47,255,65,252,0,127,254,0,7,255,252,1,252,0,7,255,192,127,255,208,1,252,0,0,191,240,63,254,0,1,252,0,0,31,224,15,224,0,1,252,0,0,3,192,5,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,240,0,0,47,255,255,255,255,255,240,0,0,47,255,255,255,255,255,240,0,0,47,192,0,0,0,15,240,0,0,47,192,0,0,0,15,240,0,0,47,192,0,0,0,15,240,0,0,47,192,0,0,0,15,240,0,0,47,192,0,0,0,15,240,0,0,47,192,0,0,0,15,240,0,0,47,255,255,255,255,255,240,0,0,47,255,255,255,255,255,240,0,0,47,255,255,255,255,255,240,0,0,47,192,0,0,0,15,240,0,0,31,192,0,0,0,10,160,0,
  // 0x542f  启
  47,84,31,35,24,37,2,253,0,0,0,0,0,0,88,0,0,0,0,0,1,175,255,0,0,0,5,107,255,255,255,192,2,175,255,255,255,255,228,0,3,255,255,255,254,144,0,0,3,255,250,148,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,255,255,255,255,255,255,244,3,255,255,255,255,255,255,244,3,255,255,255,255,255,255,244,3,248,0,0,0,0,3,244,3,248,0,0,0,0,3,244,3,248,0,0,0,0,3,244,3,248,0,0,0,0,3,244,3,255,255,255,255,255,255,244,3,255,255,255,255,255,255,244,3,255,255,255,255,255,255,244,3,248,0,0,0,0,0,0,3,244,0,0,0,0,0,0,3,244,0,0,0,0,0,0,3,244,0,0,0,0,0,0,7,240,255,255,255,255,255,248,7,240,255,255,255,255,255,248,11,240,255,255,255,255,255,248,15,224,253,0,0,0,2,248,15,208,253,0,0,0,2,248,31,192,253,0,0,0,2,248,63,192,253,0,0,0,2,248,63,128,253,0,0,0,2,248,191,0,255,255,255,255,255,248,255,0,255,255,255,255,255,248,189,0,255,255,255,255,255,248,40,0,253,0,0,0,2,248,0,0,168,0,0,0,1,164,
  // 0x544a  告
  74,84,33,36,68,37,2,252,0,2,64,1,252,0,0,0,0,0,11,240,1,252,0,0,0,0,0,15,224,1,252,0,0,0,0,0,31,208,1,252,0,0,0,0,0,63,192,1,252,0,0,0,0,0,127,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,7,252,0,2,253,0,0,0,0,15,240,0,1,252,0,0,0,0,63,224,0,1,252,0,0,0,0,63,192,0,1,252,0,0,0,0,7,0,0,1,252,0,0,0,0,1,0,0,2,253,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,128,0,0,63,255,255,255,255,255,128,0,0,63,255,255,255,255,255,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,63,255,255,255,255,255,128,0,0,63,255,255,255,255,255,128,0,0,63,255,255,255,255,255,128,0,0,63,64,0,0,0,63,128,0,0,63,64,0,0,0,63,128,0,0,0,0,0,0,0,0,0,0,
  // 0x5468  周
  104,84,32,34,16,37,1,252,0,191,255,255,255,255,255,254,0,191,255,255,255,255,255,254,0,191,255,255,255,255,255,254,0,191,0,0,85,0,0,254,0,190,0,0,253,0,0,190,0,190,0,0,253,0,0,190,0,190,0,0,253,0,0,190,0,190,15,255,255,255,224,190,0,190,15,255,255,255,224,190,0,190,10,170,255,170,144,190,0,190,0,0,253,0,0,190,0,190,0,0,253,0,0,190,0,190,0,0,253,0,0,190,0,190,63,255,255,255,248,190,0,254,63,255,255,255,248,190,0,254,47,255,255,255,244,190,0,254,0,0,0,0,0,190,0,254,0,0,0,0,0,190,0,253,2,170,170,170,128,190,0,253,7,255,255,255,192,190,0,252,7,255,255,255,192,190,1,252,7,240,0,31,192,190,2,252,7,240,0,31,192,190,3,248,7,240,0,31,192,190,3,244,7,240,0,31,192,190,7,240,7,250,170,191,192,190,11,240,7,255,255,255,192,190,15,224,7,255,255,255,192,190,31,208,7,240,0,0,0,190,63,192,7,240,0,0,0,254,127,128,2,144,0,7,255,254,63,0,0,0,0,3,255,252,13,0,0,0,0,2,255,224,0,0,0,0,0,0,0,0,
  // 0x547d  命
  125,84,35,36,68,37,1,252,0,0,0,3,253,0,0,0,0,0,0,0,11,255,64,0,0,0,0,0,0,47,255,208,0,0,0,0,0,0,191,239,244,0,0,0,0,0,2,255,75,254,0,0,0,0,0,11,254,2,255,128,0,0,0,0,47,248,0,191,240,0,0,0,0,255,208,0,47,253,0,0,0,11,255,64,0,7,255,192,0,0,63,253,0,0,1,255,248,0,2,255,223,255,255,255,223,255,128,47,255,15,255,255,255,194,255,248,255,248,15,255,255,255,192,127,252,127,192,0,0,0,0,0,11,240,45,0,0,0,0,0,0,0,208,0,0,0,0,0,0,0,0,0,0,255,255,254,11,255,255,253,0,0,255,255,254,11,255,255,253,0,0,255,255,254,11,255,255,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,252,0,126,11,224,0,253,0,0,255,255,254,11,224,0,253,0,0,255,255,254,11,224,0,253,0,0,255,255,254,11,224,255,253,0,0,252,0,0,11,224,255,252,0,0,252,0,0,11,224,191,224,0,0,252,0,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x548c  和
  140,84,33,35,59,37,1,253,0,0,0,4,0,0,0,0,0,0,0,1,190,0,0,0,0,0,0,1,191,255,128,0,0,0,0,22,255,255,255,129,85,85,85,0,47,255,255,144,11,255,255,255,64,15,255,253,0,11,255,255,255,64,4,0,253,0,11,255,255,255,64,0,0,253,0,11,224,0,63,64,0,0,253,0,11,224,0,63,64,0,0,253,0,11,224,0,63,64,0,0,253,0,11,224,0,63,64,63,255,255,255,203,224,0,63,64,63,255,255,255,203,224,0,63,64,63,255,255,255,203,224,0,63,64,0,7,253,0,11,224,0,63,64,0,11,254,0,11,224,0,63,64,0,15,255,128,11,224,0,63,64,0,31,255,208,11,224,0,63,64,0,63,255,244,11,224,0,63,64,0,127,255,252,11,224,0,63,64,0,253,253,255,11,224,0,63,64,1,252,253,63,139,224,0,63,64,3,244,253,31,203,224,0,63,64,11,240,253,15,75,224,0,63,64,31,208,253,2,11,224,0,63,64,63,192,253,0,11,224,0,63,64,191,64,253,0,11,245,85,127,64,126,0,253,0,11,255,255,255,64,60,0,253,0,11,255,255,255,64,0,0,253,0,11,255,255,255,64,0,0,253,0,11,224,0,63,64,0,0,253,0,11,224,0,63,64,0,0,253,0,11,224,0,63,64,0,0,253,0,0,0,0,0,0,0,0,252,0,0,0,0,0,0,
  // 0x54cd  响
  205,84,32,36,32,37,3,252,0,0,0,0,2,232,0,0,0,0,0,0,3,253,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,244,0,0,255,255,208,0,11,240,0,0,255,255,208,0,15,224,0,0,255,255,209,255,255,255,255,254,252,11,209,255,255,255,255,254,252,11,209,255,255,255,255,254,252,11,209,252,0,0,0,254,252,11,209,252,0,0,0,254,252,11,209,252,0,0,0,254,252,11,209,252,0,0,0,254,252,11,209,252,31,255,224,254,252,11,209,252,31,255,224,254,252,11,209,252,31,87,224,254,252,11,209,252,31,2,224,254,252,11,209,252,31,2,224,254,252,11,209,252,31,2,224,254,252,11,209,252,31,2,224,254,252,11,209,252,31,2,224,254,252,11,209,252,31,2,224,254,255,255,209,252,31,2,224,254,255,255,209,252,31,87,224,254,255,255,209,252,31,255,224,254,252,0,1,252,31,255,224,254,252,0,1,252,31,0,0,254,252,0,1,252,31,0,0,254,164,0,1,252,0,0,0,254,0,0,1,252,0,0,0,254,0,0,1,252,0,0,0,254,0,0,1,252,0,0,0,254,0,0,1,252,0,0,191,253,0,0,1,252,0,0,63,252,0,0,1,252,0,0,63,224,0,0,0,0,0,0,0,0,
  // 0x55b7  喷
  183,85,34,35,59,37,2,253,0,0,0,0,0,169,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,191,255,255,255,254,0,127,255,208,255,255,255,255,254,0,127,255,208,255,255,255,255,254,0,127,255,208,0,0,253,0,0,0,125,7,208,0,0,253,0,0,0,125,7,208,7,240,189,15,192,0,125,7,208,7,240,0,15,192,0,125,7,215,255,255,255,255,255,192,125,7,215,255,255,255,255,255,192,125,7,215,255,255,255,255,255,192,125,7,208,7,240,0,15,192,0,125,7,208,7,240,0,15,192,0,125,7,208,0,0,0,0,0,0,125,7,208,63,255,255,255,248,0,125,7,208,63,255,255,255,248,0,125,7,208,63,255,255,255,248,0,125,7,208,63,0,0,1,248,0,125,7,208,63,0,0,1,248,0,125,7,208,63,0,189,1,248,0,127,255,208,63,0,253,1,248,0,127,255,208,63,0,253,1,248,0,127,255,208,63,0,253,1,248,0,125,0,0,63,0,253,1,248,0,125,0,0,63,0,252,1,248,0,125,0,0,63,1,252,1,248,0,40,0,0,21,7,248,164,0,0,0,0,0,0,47,242,255,64,0,0,0,0,2,255,192,191,244,0,0,0,1,191,254,0,11,255,64,0,0,47,255,224,0,0,191,224,0,0,15,253,0,0,0,31,192,0,0,2,64,0,0,0,1,128,
  // 0x5634  嘴
  52,86,34,36,68,37,2,252,0,0,0,1,244,3,224,0,0,0,0,0,1,244,3,224,0,0,0,0,1,145,244,3,224,24,0,127,255,210,241,244,3,225,255,0,127,255,210,241,255,243,255,253,0,127,255,210,241,255,243,255,208,0,125,7,210,241,249,83,253,0,0,125,7,210,241,244,3,224,0,0,125,7,210,241,244,3,224,3,64,125,7,210,241,245,103,224,3,208,125,7,210,251,255,247,240,7,208,125,7,239,255,255,243,255,255,192,125,7,239,255,254,2,255,255,128,125,7,223,149,252,0,90,165,0,125,7,208,3,255,255,224,0,0,125,7,208,11,255,255,244,0,0,125,7,208,47,213,95,224,0,0,125,7,208,191,64,47,192,0,0,125,7,211,255,255,255,255,253,0,125,7,255,255,255,255,255,253,0,125,7,255,255,85,190,85,253,0,127,255,219,127,0,125,0,189,0,127,255,208,63,0,125,0,189,0,127,255,208,63,255,255,255,253,0,125,0,0,63,255,255,255,253,0,125,0,0,63,0,125,0,189,0,125,0,0,127,0,125,0,189,0,0,0,0,191,255,255,255,253,0,0,0,0,255,255,255,255,253,0,0,0,1,253,85,85,85,253,0,0,0,3,248,0,0,0,189,0,0,0,15,240,0,0,0,189,0,0,0,63,224,0,0,150,253,0,0,0,127,128,0,0,255,252,0,0,0,14,0,0,0,191,228,0,0,0,0,0,0,0,0,0,0,
  // 0x5668  器
  104,86,35,34,50,37,1,252,2,255,255,254,2,255,255,254,0,2,255,255,254,2,255,255,254,0,2,255,255,254,2,255,255,254,0,2,248,0,190,2,248,0,190,0,2,248,0,190,2,248,0,190,0,2,248,0,190,2,248,0,190,0,2,248,0,190,2,248,0,190,0,2,254,170,254,2,254,170,254,0,2,255,255,254,2,255,255,254,0,2,255,255,255,226,255,255,254,0,0,0,0,7,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,47,224,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,0,0,47,244,0,127,192,0,0,0,1,255,224,0,47,244,0,0,0,11,255,128,0,11,255,0,0,0,191,253,0,0,1,255,224,0,11,255,240,0,0,0,127,255,64,191,255,255,255,3,255,255,255,248,63,255,255,255,3,255,255,255,244,30,255,255,255,3,255,255,255,224,0,252,0,127,3,240,0,252,0,0,252,0,127,3,240,0,252,0,0,252,0,127,3,240,0,252,0,0,252,0,127,3,240,0,252,0,0,252,0,127,3,240,0,252,0,0,255,255,255,3,255,255,252,0,0,255,255,255,3,255,255,252,0,0,255,255,255,3,255,255,252,0,0,252,0,127,3,240,0,252,0,0,0,0,0,0,0,0,0,0,
  // 0x5674  噴
  116,86,33,36,68,37,3,252,0,0,0,0,1,248,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,2,248,0,0,0,0,0,2,255,255,255,255,252,0,255,255,194,255,255,255,255,252,0,255,255,193,85,86,253,85,84,0,255,255,192,10,130,248,42,0,0,248,15,192,15,194,248,63,0,0,248,11,192,15,192,0,63,0,0,248,11,223,255,255,255,255,255,128,248,11,223,255,255,255,255,255,128,248,11,213,95,213,85,127,85,0,248,11,192,15,192,0,63,0,0,248,11,192,5,64,0,21,0,0,248,11,192,255,255,255,255,240,0,248,11,192,255,255,255,255,240,0,248,11,192,252,0,0,3,240,0,248,11,192,252,0,0,3,240,0,248,11,192,255,255,255,255,240,0,248,11,192,255,255,255,255,240,0,248,11,192,252,0,0,3,240,0,255,255,192,252,0,0,3,240,0,255,255,192,252,0,0,3,240,0,255,255,192,255,255,255,255,240,0,248,0,0,255,255,255,255,240,0,248,0,0,252,0,0,3,240,0,248,0,0,252,0,0,3,240,0,0,0,0,255,255,255,255,240,0,0,0,0,255,255,255,255,240,0,0,0,0,3,224,1,244,0,0,0,0,0,47,248,3,255,64,0,0,0,11,255,208,0,191,244,0,0,1,255,253,0,0,11,254,0,0,0,191,208,0,0,1,255,64,0,0,45,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,
  // 0x56de  回
  222,86,31,34,16,37,3,253,85,85,85,85,85,85,85,84,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,255,255,255,248,2,252,254,0,255,255,255,248,2,252,254,0,255,255,255,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,253,0,3,248,2,252,254,0,255,255,255,248,2,252,254,0,255,255,255,248,2,252,254,0,255,255,255,248,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,3,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,
  // 0x56e0  因
  224,86,31,34,16,37,3,253,85,85,85,85,85,85,85,84,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,253,0,0,0,0,0,2,252,253,0,0,10,128,0,2,252,253,0,0,31,192,0,2,252,253,0,0,31,192,0,2,252,253,0,0,31,192,0,2,252,253,0,0,31,192,0,2,252,253,0,0,31,128,0,2,252,253,47,255,255,255,255,226,252,253,47,255,255,255,255,226,252,253,47,255,255,255,255,226,252,253,0,0,63,224,0,2,252,253,0,0,63,240,0,2,252,253,0,0,191,244,0,2,252,253,0,0,255,248,0,2,252,253,0,1,253,252,0,2,252,253,0,3,252,191,0,2,252,253,0,7,244,63,128,2,252,253,0,31,240,47,208,2,252,253,0,127,192,15,248,2,252,253,2,255,64,7,255,66,252,253,47,253,0,1,255,242,252,253,47,244,0,0,127,210,252,253,15,128,0,0,11,130,252,253,0,0,0,0,0,2,252,253,0,0,0,0,0,2,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,254,85,85,85,85,85,86,252,253,0,0,0,0,0,2,252,
  // 0x56fa  固
  250,86,31,33,8,37,3,253,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,254,0,0,0,0,0,2,252,254,0,0,10,128,0,2,252,254,0,0,15,192,0,2,252,254,0,0,15,192,0,2,252,254,0,0,15,192,0,2,252,254,15,255,255,255,255,210,252,254,31,255,255,255,255,226,252,254,31,255,255,255,255,226,252,254,0,0,15,192,0,2,252,254,0,0,15,192,0,2,252,254,0,0,15,192,0,2,252,254,0,0,15,192,0,2,252,254,0,255,255,255,253,2,252,254,0,255,255,255,253,2,252,254,0,254,170,170,253,2,252,254,0,252,0,0,189,2,252,254,0,252,0,0,189,2,252,254,0,252,0,0,189,2,252,254,0,252,0,0,189,2,252,254,0,254,170,170,253,2,252,254,0,255,255,255,253,2,252,254,0,255,255,255,253,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,254,0,0,0,0,0,2,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,254,0,0,0,0,0,3,252,254,0,0,0,0,0,2,252,
  // 0x56fe  图
  254,86,31,33,8,37,3,253,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,253,0,0,64,0,0,2,252,253,0,2,248,0,0,2,252,253,0,7,244,0,0,2,252,253,0,31,250,170,169,2,252,253,0,127,255,255,255,130,252,253,1,255,255,255,255,2,252,253,11,255,0,1,253,2,252,253,63,255,192,11,244,2,252,253,63,75,248,127,208,2,252,253,13,1,255,255,0,2,252,253,0,0,191,252,0,2,252,253,0,11,255,255,144,2,252,253,6,255,253,191,254,66,252,254,255,255,208,11,255,254,252,253,191,249,144,0,111,242,252,253,62,66,255,64,0,146,252,253,0,2,255,253,0,2,252,253,0,0,6,255,128,2,252,253,0,0,0,31,0,2,252,253,0,255,164,0,0,2,252,253,2,255,255,228,0,2,252,253,0,91,255,255,228,2,252,253,0,0,6,255,252,2,252,253,0,0,0,6,248,2,252,253,0,0,0,0,0,2,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,253,0,0,0,0,0,2,252,169,0,0,0,0,0,1,168,
  // 0x5728  在
  40,87,34,35,59,37,1,253,0,0,0,57,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,5,85,86,253,85,85,85,85,64,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,0,0,31,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,64,0,63,64,0,0,0,0,255,0,0,63,64,0,0,0,2,253,0,0,63,64,0,0,0,7,252,0,0,63,64,0,0,0,15,240,0,0,63,64,0,0,0,63,224,0,0,63,64,0,0,0,255,208,0,0,127,64,0,0,3,255,208,63,255,255,255,255,0,15,255,208,63,255,255,255,255,0,127,255,208,63,255,255,255,255,0,127,223,208,0,0,63,64,0,0,47,15,208,0,0,63,64,0,0,8,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,208,0,0,127,64,0,0,0,15,209,255,255,255,255,255,224,0,15,209,255,255,255,255,255,224,0,15,209,255,255,255,255,255,224,0,15,208,0,0,0,0,0,0,
  // 0x574f  坏
  79,87,35,34,50,37,1,253,0,47,64,0,0,0,0,0,0,0,47,64,0,0,0,0,0,0,0,47,64,255,255,255,255,255,244,0,47,64,255,255,255,255,255,244,0,47,64,255,255,255,255,255,244,0,47,64,0,0,7,248,0,0,0,47,64,0,0,15,240,0,0,0,47,64,0,0,47,208,0,0,63,255,255,0,0,127,192,0,0,63,255,255,0,0,255,64,0,0,63,255,255,0,3,255,72,0,0,21,127,149,0,15,255,191,0,0,0,47,64,0,63,255,255,208,0,0,47,64,0,255,255,111,244,0,0,47,64,3,255,63,71,254,0,0,47,64,47,252,63,65,255,128,0,47,65,255,240,63,64,63,224,0,47,67,255,192,63,64,15,248,0,47,66,253,0,63,64,3,244,0,47,64,176,0,63,64,0,208,0,47,64,64,0,63,64,0,0,0,47,159,128,0,63,64,0,0,0,47,255,192,0,63,64,0,0,1,191,255,192,0,63,64,0,0,111,255,253,0,0,63,64,0,0,127,255,128,0,0,63,64,0,0,63,244,0,0,0,63,64,0,0,62,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,
  // 0x5757  块
  87,87,34,35,59,37,1,253,0,21,0,0,0,168,0,0,0,0,63,64,0,0,253,0,0,0,0,63,64,0,0,253,0,0,0,0,63,64,0,0,253,0,0,0,0,63,64,0,0,253,0,0,0,0,63,64,0,0,253,0,0,0,0,63,64,15,255,255,255,254,0,0,63,64,15,255,255,255,254,0,0,63,64,15,255,255,255,254,0,63,255,255,64,0,253,0,254,0,63,255,255,64,0,253,0,190,0,63,255,255,64,0,253,0,190,0,21,127,149,0,0,253,0,190,0,0,63,64,0,0,253,0,190,0,0,63,64,0,0,253,0,190,0,0,63,64,0,0,253,0,190,0,0,63,64,0,0,252,0,190,0,0,63,64,63,255,255,255,255,240,0,63,64,63,255,255,255,255,240,0,63,64,63,255,255,255,255,240,0,63,66,85,87,255,213,85,80,0,63,191,64,3,255,224,0,0,0,63,255,192,7,251,240,0,0,0,191,255,64,11,243,244,0,0,31,255,244,0,15,226,252,0,0,127,255,64,0,63,208,254,0,0,63,244,0,0,127,128,191,64,0,47,64,0,0,255,0,63,192,0,4,0,0,3,254,0,31,240,0,0,0,0,31,252,0,15,252,0,0,0,0,191,240,0,3,255,64,0,0,7,255,192,0,0,255,240,0,0,15,254,0,0,0,127,240,0,0,7,244,0,0,0,15,192,0,0,2,128,0,0,0,1,128,
  // 0x578b  型
  139,87,33,34,50,37,2,254,0,0,0,0,0,0,0,84,0,0,0,0,0,0,0,0,252,0,31,255,255,255,244,63,0,252,0,31,255,255,255,244,63,0,252,0,31,255,255,255,244,63,0,252,0,0,63,0,253,0,63,0,252,0,0,63,0,253,0,63,0,252,0,0,63,0,253,0,63,0,252,0,0,63,0,253,0,63,0,252,0,191,255,255,255,252,63,0,252,0,191,255,255,255,252,63,0,252,0,191,255,255,255,252,63,0,252,0,0,191,0,253,0,63,0,252,0,0,254,0,253,0,63,0,252,0,0,253,0,253,0,63,0,252,0,3,252,0,253,0,0,0,252,0,11,244,0,253,0,0,0,252,0,47,240,0,253,0,0,1,252,0,191,192,0,253,0,3,255,252,0,63,0,0,254,160,1,255,248,0,8,0,0,3,244,0,255,144,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,0,0,0,7,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,244,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x57ab  垫
  171,87,34,34,50,37,2,254,0,31,128,0,3,240,0,0,0,0,31,192,0,3,240,0,0,0,0,31,192,0,3,240,0,0,0,0,31,192,0,3,240,0,0,0,191,255,255,207,255,255,255,208,0,191,255,255,207,255,255,255,208,0,191,255,255,207,255,255,255,208,0,0,31,192,0,7,240,11,208,0,0,31,192,0,11,224,11,208,0,0,31,192,67,139,208,11,208,0,0,31,255,219,255,208,11,208,0,6,255,255,219,255,192,11,208,0,255,255,255,208,255,224,11,208,0,255,255,229,0,63,253,11,208,0,191,255,192,0,127,255,139,208,0,84,31,192,0,255,127,215,226,208,0,31,192,2,252,15,199,226,240,0,31,192,15,248,2,3,243,240,0,31,192,127,224,0,3,255,224,31,255,128,63,128,0,0,255,192,15,255,64,31,80,0,0,127,64,15,249,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,1,255,255,255,255,255,255,224,0,1,255,255,255,255,255,255,224,0,1,255,255,255,255,255,255,208,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x586b  填
  107,88,35,35,59,37,1,253,0,21,0,0,0,63,64,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,255,255,255,255,255,240,0,63,0,255,255,255,255,255,240,0,63,0,255,255,255,255,255,240,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,7,255,255,255,253,0,63,255,255,7,255,255,255,253,0,63,255,255,7,240,0,0,253,0,63,255,255,7,240,0,0,253,0,21,127,84,7,255,255,255,253,0,0,63,0,7,255,255,255,253,0,0,63,0,7,240,0,0,253,0,0,63,0,7,240,0,0,253,0,0,63,0,7,240,0,0,253,0,0,63,0,7,255,255,255,253,0,0,63,0,7,255,255,255,253,0,0,63,0,7,240,0,0,253,0,0,63,0,7,240,0,0,253,0,0,63,75,71,255,255,255,253,0,0,63,255,135,255,255,255,253,0,0,127,255,128,0,0,0,0,0,7,255,253,0,0,0,0,0,0,127,255,211,255,255,255,255,255,248,127,253,3,255,255,255,255,255,248,63,128,3,255,255,255,255,255,244,40,0,0,0,41,0,10,0,0,0,0,0,0,255,128,63,208,0,0,0,0,11,254,0,31,252,0,0,0,1,191,244,0,2,255,64,0,0,15,255,128,0,0,127,224,0,0,3,253,0,0,0,15,244,0,0,0,208,0,0,0,2,64,
  // 0x58f3  壳
  243,88,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,106,170,170,175,250,170,170,170,64,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,2,255,255,255,255,255,255,224,0,2,255,255,255,255,255,255,224,0,1,170,170,170,170,170,170,144,0,0,0,0,0,0,0,0,0,0,42,170,170,170,170,170,170,170,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,0,0,0,0,0,0,127,0,63,0,0,0,0,0,0,127,0,63,15,255,255,255,255,252,127,0,63,15,255,255,255,255,252,127,0,0,5,85,85,85,85,84,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,255,255,64,0,0,0,2,255,255,255,255,128,0,0,0,2,255,255,255,255,128,0,0,0,2,252,0,0,63,128,0,0,0,2,248,0,0,63,128,0,0,0,3,248,0,0,63,128,0,0,0,3,244,0,0,63,128,8,0,0,15,240,0,0,63,128,31,128,0,63,224,0,0,63,128,31,128,2,255,192,0,0,63,128,47,128,111,255,0,0,0,47,255,255,64,127,248,0,0,0,31,255,255,0,47,208,0,0,0,11,255,252,0,8,0,0,0,0,0,0,0,0,
  // 0x5907  备
  7,89,35,36,68,37,1,252,0,0,0,250,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,31,255,255,255,255,0,0,0,0,127,255,255,255,255,192,0,0,2,255,255,255,255,255,0,0,0,15,254,0,0,3,253,0,0,0,191,255,192,0,31,248,0,0,7,255,191,244,0,191,224,0,0,11,253,11,254,7,255,64,0,0,2,224,1,255,255,252,0,0,0,0,64,0,63,255,224,0,0,0,0,0,1,191,255,249,0,0,0,0,0,111,255,255,255,249,0,0,1,111,255,255,71,255,255,254,144,191,255,255,224,0,47,255,255,248,63,255,249,0,0,0,111,255,240,63,249,0,0,0,0,0,107,192,21,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,128,1,252,0,15,224,0,0,63,128,1,252,0,15,224,0,0,63,128,1,252,0,15,224,0,0,63,234,171,254,170,175,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,128,1,252,0,15,224,0,0,63,128,1,252,0,15,224,0,0,63,128,1,252,0,15,224,0,0,63,128,1,252,0,15,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,255,255,255,255,255,224,0,0,63,128,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,
  // 0x590d  复
  13,89,24,36,216,37,6,252,0,6,64,0,0,0,0,15,240,0,0,0,0,31,208,0,0,0,0,63,192,0,0,0,0,191,255,255,255,248,0,255,255,255,255,248,3,255,255,255,255,248,15,248,0,0,0,0,63,245,85,85,85,0,255,255,255,255,255,192,127,191,255,255,255,192,28,126,0,0,31,192,0,126,0,0,31,192,0,127,255,255,255,192,0,127,255,255,255,192,0,126,0,0,47,192,0,126,0,0,31,192,0,127,0,0,47,192,0,127,255,255,255,192,0,127,255,255,255,192,0,0,255,0,0,0,0,2,253,0,0,0,0,11,255,255,255,64,0,47,255,255,255,192,0,255,213,85,255,64,11,255,224,1,254,0,127,251,248,7,252,0,63,193,255,47,240,0,14,0,127,255,192,0,0,0,31,255,0,0,0,1,255,255,244,0,1,191,255,191,255,228,63,255,244,7,255,255,47,254,64,0,47,253,14,64,0,0,0,120,0,0,0,0,0,0,
  // 0x5916  外
  22,89,35,35,59,37,1,253,0,0,121,0,0,1,252,0,0,0,0,191,0,0,1,252,0,0,0,0,254,0,0,1,252,0,0,0,1,253,0,0,1,252,0,0,0,2,252,0,0,1,252,0,0,0,3,252,0,80,1,252,0,0,0,7,255,255,253,1,252,0,0,0,15,255,255,253,1,252,0,0,0,31,255,255,253,1,252,0,0,0,47,192,1,254,129,252,0,0,0,127,128,2,255,209,252,0,0,0,255,0,3,255,241,252,0,0,1,254,0,3,251,249,252,0,0,3,252,0,7,241,255,252,0,0,15,254,0,11,240,191,252,0,0,63,255,208,15,224,63,252,0,0,191,255,248,31,192,31,252,0,0,127,75,255,47,192,7,253,0,0,13,1,255,255,128,2,255,64,0,0,0,63,255,0,1,255,224,0,0,0,11,254,0,1,255,248,0,0,0,3,252,0,1,255,255,64,0,0,3,248,0,1,254,255,244,0,0,15,240,0,1,252,127,252,0,0,47,224,0,1,252,15,240,0,0,127,192,0,1,252,1,208,0,0,255,64,0,1,252,0,0,0,3,254,0,0,1,252,0,0,0,15,252,0,0,1,252,0,0,0,127,240,0,0,1,252,0,0,2,255,192,0,0,1,252,0,0,31,255,0,0,0,1,252,0,0,47,248,0,0,0,1,252,0,0,7,208,0,0,0,1,252,0,0,1,0,0,0,0,1,252,0,0,
  // 0x591a  多
  26,89,33,35,59,37,2,253,0,0,0,15,144,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,7,255,255,255,240,0,0,0,0,47,255,255,255,252,0,0,0,1,255,255,255,255,248,0,0,0,31,254,0,0,15,240,0,0,1,255,253,0,0,63,208,0,0,47,255,255,128,0,255,64,0,0,31,248,127,248,7,253,0,0,0,11,64,11,255,47,244,0,0,0,0,0,0,255,255,192,0,0,0,0,0,0,63,255,64,0,0,0,0,0,1,255,246,254,0,0,0,0,0,47,255,139,252,0,0,0,0,7,255,248,47,240,0,0,0,26,255,255,128,255,255,255,253,0,127,255,244,7,255,255,255,255,64,47,254,0,127,255,255,255,255,0,14,64,2,255,208,0,2,253,0,0,0,111,255,0,0,7,252,0,0,11,255,255,64,0,15,244,0,0,63,255,255,240,0,63,208,0,0,47,244,31,253,0,255,128,0,0,14,0,2,255,135,255,0,0,0,0,0,0,127,255,252,0,0,0,0,0,0,31,255,224,0,0,0,0,0,0,15,255,128,0,0,0,0,0,1,255,252,0,0,0,0,0,0,111,255,224,0,0,0,0,0,91,255,254,0,0,0,0,1,175,255,255,224,0,0,0,0,1,255,255,249,0,0,0,0,0,0,255,254,64,0,0,0,0,0,0,121,64,0,0,0,0,0,0,
  // 0x5927  大
  39,89,33,35,59,37,2,253,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,15,240,0,0,0,0,106,170,170,175,250,170,170,170,64,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,47,253,0,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,191,191,128,0,0,0,0,0,0,255,63,192,0,0,0,0,0,0,254,31,208,0,0,0,0,0,2,253,15,240,0,0,0,0,0,3,252,11,248,0,0,0,0,0,11,248,3,253,0,0,0,0,0,31,240,2,255,0,0,0,0,0,63,224,0,255,128,0,0,0,0,255,192,0,127,208,0,0,0,2,255,64,0,47,244,0,0,0,11,254,0,0,15,253,0,0,0,63,248,0,0,3,255,64,0,1,255,224,0,0,0,255,224,0,11,255,128,0,0,0,63,253,0,191,254,0,0,0,0,31,255,192,191,244,0,0,0,0,3,255,128,47,128,0,0,0,0,0,190,0,8,0,0,0,0,0,0,8,0,
  // 0x5929  天
  41,89,34,33,41,37,2,252,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,106,170,170,175,250,170,170,170,64,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,21,85,85,95,245,85,85,85,0,47,255,255,255,255,255,255,254,0,47,255,255,255,255,255,255,254,0,47,255,255,255,255,255,255,254,0,0,0,0,15,252,0,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,63,255,0,0,0,0,0,0,0,63,255,128,0,0,0,0,0,0,191,127,192,0,0,0,0,0,1,255,31,224,0,0,0,0,0,3,254,15,248,0,0,0,0,0,15,252,7,253,0,0,0,0,0,63,244,2,255,0,0,0,0,0,255,224,0,255,208,0,0,0,7,255,128,0,63,248,0,0,0,127,254,0,0,15,255,64,0,6,255,244,0,0,3,255,244,0,191,255,192,0,0,0,191,255,208,255,253,0,0,0,0,31,255,192,127,208,0,0,0,0,2,255,64,41,0,0,0,0,0,0,26,0,0,0,0,0,0,0,0,0,0,
  // 0x592a  太
  42,89,34,35,59,37,2,253,0,0,0,11,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,106,170,170,191,255,170,170,170,64,0,0,0,63,255,0,0,0,0,0,0,0,63,255,64,0,0,0,0,0,0,127,191,128,0,0,0,0,0,0,191,47,192,0,0,0,0,0,0,255,31,208,0,0,0,0,0,1,254,15,240,0,0,0,0,0,3,252,7,244,0,0,0,0,0,7,252,3,252,0,0,0,0,0,15,244,2,254,0,0,0,0,0,31,240,0,255,64,0,0,0,0,63,208,0,127,192,0,0,0,0,255,159,0,63,224,0,0,0,3,255,191,192,15,248,0,0,0,15,253,127,240,11,254,0,0,0,63,244,15,252,2,255,128,0,1,255,224,3,255,0,255,240,0,11,255,128,0,255,192,63,253,0,191,253,0,0,127,240,15,255,208,255,240,0,0,31,192,2,255,192,63,64,0,0,11,0,0,127,64,24,0,0,0,0,0,0,10,0,
  // 0x5931  失
  49,89,34,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,15,224,7,240,0,0,0,0,0,15,224,7,240,0,0,0,0,0,47,208,7,240,0,0,0,0,0,63,192,7,240,0,0,0,0,0,127,128,7,240,0,0,0,0,0,191,149,91,249,85,85,80,0,0,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,11,244,0,7,240,0,0,0,0,31,240,0,7,240,0,0,0,0,63,208,0,11,240,0,0,0,0,191,192,0,11,240,0,0,0,0,31,0,0,11,240,0,0,0,0,1,0,0,11,240,0,0,0,0,0,0,0,15,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,85,127,255,85,85,85,64,0,0,0,63,255,0,0,0,0,0,0,0,191,255,128,0,0,0,0,0,0,255,47,192,0,0,0,0,0,3,254,15,240,0,0,0,0,0,11,252,11,252,0,0,0,0,0,47,244,3,255,0,0,0,0,0,255,224,0,255,192,0,0,0,7,255,128,0,127,244,0,0,0,47,254,0,0,31,255,0,0,2,255,244,0,0,7,255,228,0,127,255,192,0,0,0,191,255,208,255,253,0,0,0,0,31,255,208,63,208,0,0,0,0,1,255,128,40,0,0,0,0,0,0,27,0,
  // 0x5934  头
  52,89,33,35,59,37,2,253,0,0,0,0,26,128,0,0,0,0,0,0,0,47,192,0,0,0,0,15,208,0,47,192,0,0,0,0,47,253,0,47,192,0,0,0,0,27,255,208,47,192,0,0,0,0,0,191,248,47,192,0,0,0,0,0,11,252,63,192,0,0,0,0,0,1,240,63,192,0,0,0,1,0,0,16,63,128,0,0,0,7,224,0,0,63,128,0,0,0,15,255,64,0,63,128,0,0,0,7,255,224,0,63,128,0,0,0,0,127,253,0,63,128,0,0,0,0,7,254,0,63,64,0,0,0,0,0,188,0,63,64,0,0,0,0,0,16,0,127,0,0,0,0,0,0,0,0,191,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,31,241,0,0,0,0,0,0,0,63,211,224,0,0,0,0,0,0,255,143,254,0,0,0,0,0,3,255,7,255,208,0,0,0,0,15,252,0,127,253,0,0,0,0,191,244,0,7,255,128,0,0,7,255,192,0,0,191,244,0,0,191,254,0,0,0,31,254,0,111,255,244,0,0,0,3,255,128,127,255,64,0,0,0,0,191,64,47,228,0,0,0,0,0,29,0,9,0,0,0,0,0,0,0,0,
  // 0x597d  好
  125,89,35,36,68,37,1,252,0,14,128,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,1,255,255,255,255,64,0,47,128,1,255,255,255,255,224,0,63,64,1,255,255,255,255,192,0,63,64,0,0,0,0,255,64,0,63,0,0,0,0,2,254,0,0,127,0,0,0,0,7,248,0,127,255,255,248,0,0,31,240,0,127,255,255,248,0,0,127,192,0,127,255,255,244,0,2,255,0,0,0,252,3,244,0,7,252,0,0,1,252,3,244,0,7,240,0,0,2,248,3,240,0,7,240,0,0,3,244,7,240,0,7,240,0,0,3,240,7,251,255,255,255,255,248,7,240,11,235,255,255,255,255,248,11,224,15,235,255,255,255,255,248,15,208,15,209,85,91,245,85,80,15,192,31,192,0,7,240,0,0,31,240,47,192,0,7,240,0,0,47,253,63,64,0,7,240,0,0,63,255,255,0,0,7,240,0,0,31,191,255,0,0,7,240,0,0,2,15,254,0,0,7,240,0,0,0,3,255,64,0,7,240,0,0,0,7,255,208,0,7,240,0,0,0,15,255,244,0,7,240,0,0,0,47,215,253,0,7,240,0,0,0,127,193,252,0,7,240,0,0,1,255,0,180,0,7,240,0,0,11,253,0,16,21,91,240,0,0,63,244,0,0,47,255,240,0,0,15,208,0,0,15,255,208,0,0,7,0,0,0,15,254,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x59cb  始
  203,89,35,35,59,37,1,253,0,15,128,0,0,42,64,0,0,0,31,192,0,0,63,192,0,0,0,31,192,0,0,63,128,0,0,0,47,128,0,0,127,64,0,0,0,63,64,0,0,191,0,0,0,0,63,0,0,0,254,0,0,0,0,63,0,0,0,253,0,160,0,0,191,0,0,2,252,3,244,0,127,255,255,248,3,248,2,252,0,127,255,255,248,3,240,0,254,0,127,255,255,244,11,240,0,127,64,1,252,3,244,15,208,0,63,192,1,248,3,240,31,214,171,255,208,2,248,3,247,255,255,255,255,240,3,244,7,243,255,255,255,255,244,3,240,7,243,255,255,170,87,252,7,240,11,225,64,0,0,1,248,11,224,15,208,0,0,0,0,128,15,208,15,208,0,0,0,0,0,15,192,31,192,0,0,0,0,0,31,208,47,192,63,255,255,255,192,47,248,63,128,63,255,255,255,192,63,255,191,0,63,255,255,255,192,63,255,255,0,63,64,0,31,192,6,31,254,0,63,64,0,31,192,0,3,255,64,63,64,0,31,192,0,7,255,208,63,64,0,31,192,0,15,255,248,63,64,0,31,192,0,63,215,253,63,64,0,31,192,0,191,128,252,63,64,0,31,192,3,255,0,112,63,255,255,255,192,31,252,0,0,63,255,255,255,192,47,240,0,0,63,255,255,255,192,15,128,0,0,63,64,0,31,192,6,0,0,0,63,64,0,26,128,
  // 0x5b50  子
  80,91,33,34,50,37,2,252,0,85,85,85,85,85,85,0,0,1,255,255,255,255,255,255,192,0,1,255,255,255,255,255,255,240,0,1,255,255,255,255,255,255,192,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,255,224,0,0,0,0,0,0,11,255,64,0,0,0,0,0,1,127,252,0,0,0,0,0,0,3,255,208,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,85,85,85,91,249,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,1,149,95,244,0,0,0,0,0,0,255,255,240,0,0,0,0,0,0,191,255,224,0,0,0,0,0,0,127,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5b58  存
  88,91,35,35,59,37,1,253,0,0,0,57,0,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,253,0,0,0,0,0,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,5,85,95,245,85,85,85,85,64,0,0,47,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,1,255,7,255,255,255,248,0,0,3,253,7,255,255,255,255,0,0,11,248,7,255,255,255,252,0,0,31,240,0,0,0,31,244,0,0,63,208,0,0,0,127,208,0,0,255,208,0,0,1,255,64,0,3,255,208,0,0,27,252,0,0,15,255,208,0,0,31,240,0,0,127,255,208,0,0,31,192,0,0,127,223,208,0,0,47,192,0,0,63,15,209,255,255,255,255,255,244,28,15,209,255,255,255,255,255,244,0,15,209,255,255,255,255,255,244,0,15,208,0,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,208,0,64,47,192,0,0,0,15,208,0,255,255,192,0,0,0,15,208,0,191,255,64,0,0,0,15,208,0,127,249,0,0,0,
  // 0x5b89  安
  137,91,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,244,0,0,0,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,128,0,0,0,0,0,191,0,63,128,0,36,0,0,0,191,0,63,128,0,127,128,0,0,191,0,63,128,0,255,0,0,0,191,0,63,128,1,254,0,0,0,191,0,0,0,3,252,0,0,0,0,0,0,0,7,248,0,0,0,0,0,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,21,85,191,149,85,95,245,85,0,0,0,255,0,0,15,240,0,0,0,1,254,0,0,31,224,0,0,0,3,252,0,0,47,208,0,0,0,7,248,0,0,63,192,0,0,0,15,240,0,0,255,64,0,0,0,47,254,64,2,255,0,0,0,0,63,255,249,7,252,0,0,0,0,191,255,255,239,244,0,0,0,0,27,6,255,255,224,0,0,0,0,0,0,31,255,248,0,0,0,0,0,0,47,255,255,128,0,0,0,0,6,255,251,255,248,0,0,0,1,191,255,128,127,255,128,0,26,255,255,248,0,7,255,244,0,31,255,255,128,0,0,127,248,0,11,255,224,0,0,0,11,240,0,3,148,0,0,0,0,1,128,0,
  // 0x5b8c  完
  140,91,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,149,85,85,85,85,85,255,0,63,64,0,0,0,0,0,191,0,63,64,0,0,0,0,0,191,0,63,64,0,0,0,0,0,191,0,63,71,255,255,255,255,240,191,0,21,7,255,255,255,255,240,85,0,0,7,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,85,85,85,85,85,85,85,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,47,192,3,244,0,0,0,0,0,63,192,3,244,0,0,0,0,0,63,128,3,244,0,0,0,0,0,127,64,3,244,0,0,0,0,0,191,0,3,244,0,0,0,0,0,255,0,3,244,0,4,0,0,3,253,0,3,244,0,15,128,0,11,252,0,3,244,0,15,192,0,63,240,0,3,244,0,15,192,2,255,208,0,3,248,0,47,192,191,255,64,0,3,255,255,255,128,255,252,0,0,2,255,255,255,0,127,208,0,0,0,191,255,253,0,56,0,0,0,0,0,0,0,0,
  // 0x5b9a  定
  154,91,34,36,68,37,1,252,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,229,85,85,85,85,85,111,192,15,208,0,0,0,0,0,47,192,15,208,0,0,0,0,0,47,192,15,208,0,0,0,0,0,47,192,15,208,85,85,85,85,85,47,192,15,211,255,255,255,255,255,47,192,0,3,255,255,255,255,255,0,0,0,3,255,255,255,255,255,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,3,244,1,252,0,0,0,0,0,7,244,1,252,0,0,0,0,0,7,240,1,253,0,0,0,0,0,11,240,1,255,255,255,240,0,0,15,240,1,255,255,255,240,0,0,15,240,1,255,255,255,240,0,0,31,244,1,252,0,0,0,0,0,63,252,1,252,0,0,0,0,0,63,254,1,252,0,0,0,0,0,191,255,65,252,0,0,0,0,0,254,63,225,252,0,0,0,0,3,252,15,254,252,0,0,0,0,11,248,3,255,253,0,0,0,0,47,240,0,255,255,255,255,255,240,127,208,0,31,255,255,255,255,224,47,128,0,0,111,255,255,255,208,10,0,0,0,0,21,85,85,64,0,0,0,0,0,0,0,0,0,
  // 0x5ba2  客
  162,91,35,36,68,37,1,252,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,208,0,20,0,0,0,31,192,15,208,0,255,64,0,0,31,192,15,208,2,254,0,0,0,31,192,15,208,11,254,170,170,160,31,192,15,208,47,255,255,255,253,31,192,0,0,191,255,255,255,252,0,0,0,7,255,128,0,15,244,0,0,0,47,255,240,0,63,224,0,0,2,255,235,252,1,255,128,0,0,3,255,66,255,75,254,0,0,0,0,248,0,127,255,244,0,0,0,0,0,0,31,255,208,0,0,0,0,0,0,111,255,248,0,0,0,0,0,7,255,255,255,224,0,0,0,1,191,255,139,255,255,164,0,1,191,255,248,0,191,255,255,244,127,255,255,64,0,6,255,255,224,63,255,255,255,255,255,255,255,192,31,231,255,255,255,255,255,6,64,4,2,255,255,255,255,255,0,0,0,2,248,0,0,0,191,0,0,0,2,248,0,0,0,191,0,0,0,2,248,0,0,0,191,0,0,0,2,248,0,0,0,191,0,0,0,2,248,0,0,0,191,0,0,0,2,255,255,255,255,255,0,0,0,2,255,255,255,255,255,0,0,0,2,255,255,255,255,255,0,0,0,2,248,0,0,0,191,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5bab  宫
  171,91,31,36,32,37,3,252,0,0,0,47,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,63,192,0,0,0,0,0,0,31,224,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,254,85,85,85,85,85,86,252,253,0,0,0,0,0,2,252,253,0,0,0,0,0,2,252,253,63,255,255,255,255,242,252,253,63,255,255,255,255,242,252,0,63,255,255,255,255,240,0,0,63,0,0,0,7,240,0,0,63,0,0,0,7,240,0,0,63,0,0,0,7,240,0,0,63,0,0,0,7,240,0,0,63,255,255,255,255,240,0,0,63,255,255,255,255,240,0,0,63,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,255,128,3,255,255,255,255,255,255,128,3,255,255,255,255,255,255,128,3,240,0,0,0,0,63,128,3,240,0,0,0,0,63,128,3,240,0,0,0,0,63,128,3,240,0,0,0,0,63,128,3,240,0,0,0,0,63,128,3,255,255,255,255,255,255,128,3,255,255,255,255,255,255,128,3,255,255,255,255,255,255,128,3,240,0,0,0,0,63,128,0,0,0,0,0,0,0,0,
  // 0x5bf9  对
  249,91,34,35,59,37,2,253,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,127,255,255,248,0,0,15,192,0,127,255,255,252,0,0,15,192,0,127,255,255,252,0,0,15,192,0,21,85,86,252,0,0,15,192,0,0,0,3,248,255,255,255,255,208,0,0,3,248,255,255,255,255,208,0,0,3,244,255,255,255,255,208,0,0,7,240,85,85,95,213,64,7,64,11,240,0,0,15,192,0,31,208,15,240,0,0,15,192,0,31,244,15,224,0,0,15,192,0,7,253,31,208,29,0,15,192,0,1,255,111,192,191,0,15,192,0,0,127,255,128,63,128,15,192,0,0,31,255,64,47,192,15,192,0,0,7,255,0,15,224,15,192,0,0,2,255,0,7,240,15,192,0,0,2,255,192,3,248,15,192,0,0,3,255,224,2,252,15,192,0,0,11,255,248,1,244,15,192,0,0,31,247,252,0,64,15,192,0,0,63,210,255,0,0,15,192,0,0,191,128,255,64,0,15,192,0,1,255,0,63,0,0,15,192,0,7,253,0,40,0,0,15,192,0,31,248,0,0,0,0,15,192,0,191,224,0,0,0,170,191,192,0,255,192,0,0,0,127,255,192,0,62,0,0,0,0,63,255,64,0,24,0,0,0,0,63,248,0,0,
  // 0x5c06  将
  6,92,35,35,59,37,1,253,0,3,244,0,0,0,0,180,0,0,3,244,0,0,1,191,253,0,0,3,244,0,90,255,255,255,0,0,3,244,191,255,255,255,228,0,0,3,244,255,255,255,144,0,0,30,3,244,191,165,0,0,0,0,127,3,244,0,0,108,0,15,128,63,131,244,5,0,252,0,31,224,31,211,244,63,0,254,0,63,192,15,243,244,63,64,127,0,191,64,7,243,244,31,192,63,1,254,0,3,251,244,15,208,63,67,252,0,2,255,244,11,224,63,75,240,0,0,211,244,7,240,16,31,208,0,0,3,244,3,144,0,63,128,0,0,3,244,0,0,0,31,208,0,0,3,244,0,0,0,15,224,0,0,3,244,0,0,0,15,224,0,0,3,244,255,255,255,255,255,244,0,3,244,255,255,255,255,255,244,0,7,244,255,255,255,255,255,244,0,63,244,0,0,0,15,224,0,2,255,244,0,80,0,15,224,0,31,255,244,3,244,0,15,224,0,191,251,244,3,252,0,15,224,0,191,211,244,1,255,0,15,224,0,63,3,244,0,127,128,15,224,0,40,3,244,0,63,192,15,224,0,0,3,244,0,15,240,15,224,0,0,3,244,0,11,128,15,224,0,0,3,244,0,1,0,15,224,0,0,3,244,0,0,21,95,224,0,0,3,244,0,0,63,255,208,0,0,3,244,0,0,47,255,192,0,0,3,244,0,0,31,254,0,0,
  // 0x5c0f  小
  15,92,35,36,68,37,1,252,0,0,0,0,84,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,9,0,0,253,0,7,0,0,0,15,240,0,253,0,63,128,0,0,31,224,0,253,0,63,208,0,0,31,208,0,253,0,31,240,0,0,47,192,0,253,0,15,244,0,0,63,192,0,253,0,7,252,0,0,127,128,0,253,0,3,253,0,0,191,64,0,253,0,1,254,0,0,255,0,0,253,0,0,255,0,1,254,0,0,253,0,0,191,128,3,253,0,0,253,0,0,63,192,3,252,0,0,253,0,0,63,208,11,244,0,0,253,0,0,31,224,15,240,0,0,253,0,0,15,240,63,224,0,0,253,0,0,11,244,127,192,0,0,253,0,0,7,248,47,64,0,0,253,0,0,3,252,2,0,0,0,253,0,0,3,224,0,0,0,0,253,0,0,1,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,42,91,253,0,0,0,0,0,0,63,255,252,0,0,0,0,0,0,31,255,248,0,0,0,0,0,0,15,255,144,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5c31  就
  49,92,35,35,59,37,1,253,0,0,254,0,0,3,244,0,0,0,0,254,0,0,3,244,36,0,0,0,254,0,0,3,245,252,0,0,0,254,0,0,3,244,255,0,0,0,254,0,0,3,244,63,128,63,255,255,255,248,3,244,31,192,63,255,255,255,248,3,244,15,240,63,255,255,255,248,3,244,3,224,0,0,0,0,0,3,244,1,0,0,0,0,0,0,3,248,0,0,3,255,255,255,203,255,255,255,244,3,255,255,255,203,255,255,255,244,3,255,255,255,203,255,255,255,244,3,240,0,31,192,3,244,0,0,3,240,0,31,192,3,244,0,0,3,240,0,31,192,3,255,128,0,3,240,0,31,192,7,255,128,0,3,240,0,31,192,7,255,128,0,3,255,255,255,192,11,255,128,0,3,255,255,255,192,15,255,128,0,3,255,255,255,192,15,255,128,0,0,0,190,0,0,31,239,128,0,0,0,190,6,0,47,239,128,0,3,244,190,63,64,63,175,128,0,3,240,190,31,128,127,111,128,0,7,240,190,15,192,191,47,128,0,15,208,190,11,224,253,47,128,224,15,192,190,7,243,252,47,128,252,47,192,190,3,247,248,47,128,248,63,64,190,2,79,240,47,128,248,191,0,190,0,47,208,47,129,248,29,0,254,0,191,192,47,255,248,0,127,253,2,255,0,31,255,240,0,63,252,0,253,0,11,255,208,0,47,224,0,36,0,0,84,0,
  // 0x5c4f  屏
  79,92,34,34,50,37,1,252,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,254,0,0,0,0,0,191,0,0,254,0,0,0,0,0,191,0,0,254,0,0,0,0,0,191,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,0,0,254,0,109,0,0,31,128,0,0,254,0,191,0,0,63,192,0,0,254,0,63,128,0,127,64,0,0,254,0,47,192,0,254,0,0,0,254,0,15,192,0,252,0,0,0,254,127,255,255,255,255,255,192,0,253,127,255,255,255,255,255,192,0,253,63,255,255,255,255,255,192,0,253,0,15,208,1,252,0,0,0,252,0,15,208,1,252,0,0,1,252,0,15,208,1,252,0,0,1,252,0,15,208,1,252,0,0,2,253,255,255,255,255,255,255,240,3,249,255,255,255,255,255,255,240,3,249,255,255,255,255,255,255,240,3,244,0,47,192,1,252,0,0,7,240,0,63,128,1,252,0,0,11,240,0,255,0,1,252,0,0,15,224,2,254,0,1,252,0,0,31,208,11,252,0,1,252,0,0,63,192,127,244,0,1,252,0,0,127,65,255,208,0,1,252,0,0,47,0,127,64,0,1,252,0,0,5,0,40,0,0,1,252,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5de5  工
  229,93,33,28,252,37,2,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,10,170,170,175,250,170,170,168,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,11,244,0,0,0,0,85,85,85,91,249,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x5dee  差
  238,93,34,35,59,37,1,253,0,0,24,0,0,0,228,0,0,0,0,254,0,0,2,253,0,0,0,0,191,0,0,3,252,0,0,0,0,63,192,0,11,240,0,0,0,0,31,192,0,15,208,0,0,3,255,255,255,255,255,255,255,64,3,255,255,255,255,255,255,255,64,3,255,255,255,255,255,255,255,64,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,127,255,255,255,255,255,248,0,0,127,255,255,255,255,255,248,0,0,127,255,255,255,255,255,244,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,2,253,255,255,255,255,248,0,0,3,249,255,255,255,255,248,0,0,11,245,255,255,255,255,248,0,0,15,240,0,3,240,0,0,0,0,31,208,0,3,240,0,0,0,0,63,192,0,3,240,0,0,0,0,255,128,0,3,240,0,0,0,2,255,0,0,3,240,0,0,0,7,252,0,0,3,240,0,0,0,47,248,191,255,255,255,255,255,192,127,224,191,255,255,255,255,255,192,31,128,191,255,255,255,255,255,192,2,0,0,0,0,0,0,0,0,
  // 0x5df2  已
  242,93,32,32,0,37,3,254,21,85,85,85,85,85,84,0,127,255,255,255,255,255,254,0,127,255,255,255,255,255,254,0,127,255,255,255,255,255,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,6,160,0,0,0,0,254,0,11,240,0,0,0,0,254,0,11,240,0,0,0,0,254,0,11,240,0,0,0,0,254,0,11,240,0,0,0,0,254,0,11,240,0,0,0,0,254,0,11,255,255,255,255,255,254,0,11,255,255,255,255,255,254,0,11,255,255,255,255,255,254,0,11,245,85,85,85,85,254,0,11,240,0,0,0,0,254,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,121,11,240,0,0,0,0,0,127,11,240,0,0,0,0,0,191,11,240,0,0,0,0,0,255,11,240,0,0,0,0,0,254,11,244,0,0,0,0,2,253,7,254,85,85,85,85,111,252,3,255,255,255,255,255,255,248,0,255,255,255,255,255,255,224,0,27,255,255,255,255,254,0,
  // 0x5e73  平
  115,94,33,33,41,37,2,253,5,85,85,85,85,85,85,84,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,20,0,0,0,127,0,7,240,0,63,128,0,0,63,64,7,240,0,127,128,0,0,63,192,7,240,0,191,0,0,0,31,208,7,240,0,254,0,0,0,15,224,7,240,2,252,0,0,0,11,240,7,240,3,248,0,0,0,7,244,7,240,7,240,0,0,0,3,248,7,240,15,224,0,0,0,2,128,7,240,6,192,0,0,0,0,0,7,240,0,0,0,0,85,85,85,91,249,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,
  // 0x5e76  并
  118,94,33,36,68,37,2,252,0,1,208,0,0,1,228,0,0,0,15,240,0,0,3,253,0,0,0,7,248,0,0,7,252,0,0,0,2,253,0,0,15,240,0,0,0,0,255,0,0,47,208,0,0,0,0,191,64,0,63,192,0,0,0,0,63,128,0,191,0,0,0,0,0,45,0,0,30,0,0,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,85,85,255,85,85,127,213,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,253,0,0,63,128,0,0,0,1,253,0,0,63,128,0,0,0,2,252,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,11,244,0,0,63,128,0,0,0,15,240,0,0,63,128,0,0,0,63,224,0,0,63,128,0,0,0,191,192,0,0,63,128,0,0,2,255,64,0,0,63,128,0,0,31,253,0,0,0,63,128,0,0,191,244,0,0,0,63,128,0,0,63,192,0,0,0,63,128,0,0,14,0,0,0,0,47,128,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5e8a  床
  138,94,35,35,59,37,1,253,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,85,85,85,127,149,85,85,80,2,255,255,255,255,255,255,255,240,2,255,255,255,255,255,255,255,240,2,255,255,255,255,255,255,255,240,2,252,0,0,0,0,0,0,0,2,252,0,0,3,244,0,0,0,2,252,0,0,3,244,0,0,0,2,252,0,0,3,244,0,0,0,2,252,0,0,3,244,0,0,0,2,252,0,0,3,244,0,0,0,2,252,0,0,7,248,0,0,0,2,252,127,255,255,255,255,255,240,2,252,127,255,255,255,255,255,240,2,252,127,255,255,255,255,255,240,2,252,0,0,47,255,0,0,0,2,252,0,0,127,255,128,0,0,2,248,0,0,255,255,208,0,0,3,248,0,2,255,255,240,0,0,3,244,0,7,251,251,252,0,0,3,244,0,31,243,245,255,0,0,3,244,0,63,195,244,191,192,0,7,240,0,255,67,244,47,240,0,11,240,3,254,3,244,15,252,0,15,224,31,252,3,244,3,255,64,15,208,191,240,3,244,0,255,224,31,195,255,192,3,244,0,63,244,63,193,254,0,3,244,0,11,224,63,128,116,0,3,244,0,1,192,191,0,0,0,3,244,0,0,0,46,0,0,0,3,244,0,0,0,5,0,0,0,3,244,0,0,0,
  // 0x5e94  应
  148,94,35,36,68,37,1,252,0,0,0,0,111,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,224,0,0,0,2,255,255,255,255,255,255,255,240,2,255,255,255,255,255,255,255,240,2,255,255,255,255,255,255,255,240,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,5,0,0,100,0,2,252,0,0,127,0,0,191,0,2,252,6,0,63,0,0,255,0,2,252,63,0,63,64,0,255,0,2,252,63,128,47,128,1,253,0,2,252,31,192,31,192,2,252,0,2,252,15,208,15,208,3,252,0,2,252,15,224,15,224,7,244,0,2,252,7,240,11,240,11,240,0,2,252,3,244,7,240,15,224,0,2,248,3,248,3,240,31,208,0,3,248,2,252,3,244,47,192,0,3,248,1,253,3,248,63,64,0,3,244,0,254,2,224,191,0,0,3,244,0,191,0,0,254,0,0,7,240,0,184,0,1,252,0,0,7,240,0,0,0,3,248,0,0,11,240,0,0,0,11,240,0,0,15,224,0,0,0,15,208,0,0,15,208,0,0,0,47,192,0,0,47,195,255,255,255,255,255,255,244,63,195,255,255,255,255,255,255,244,127,67,255,255,255,255,255,255,244,63,1,85,85,85,85,85,85,80,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5e9f  废
  159,94,34,36,68,37,1,252,0,0,0,0,111,0,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,47,224,0,0,0,3,255,255,255,255,255,255,255,240,3,255,255,255,255,255,255,255,240,3,255,255,255,255,255,255,255,240,3,248,0,0,0,0,0,0,0,3,248,2,164,11,240,9,0,0,3,248,3,248,15,224,63,0,0,3,248,7,244,15,208,63,192,0,3,248,11,240,31,192,15,240,0,3,248,15,224,47,192,3,248,0,3,248,47,192,63,128,1,224,0,3,248,127,255,255,255,255,255,192,3,248,63,255,255,255,255,255,192,3,248,63,255,255,255,255,255,192,3,248,20,0,253,0,0,0,0,3,248,0,2,252,0,0,0,0,3,248,0,3,248,0,0,0,0,3,244,0,11,255,255,255,224,0,3,244,0,15,255,255,255,248,0,3,244,0,63,255,255,255,240,0,7,240,0,191,224,0,47,208,0,7,240,1,255,248,0,127,192,0,11,240,7,254,254,1,255,0,0,15,240,31,244,191,199,252,0,0,15,224,127,208,47,255,244,0,0,15,210,255,128,11,255,208,0,0,31,223,254,0,27,255,244,0,0,63,199,244,1,255,255,255,128,0,63,130,192,111,255,215,255,254,64,127,64,3,255,253,0,127,255,224,47,0,1,255,208,0,6,255,192,6,0,0,184,0,0,0,27,64,0,0,0,0,0,0,0,0,0,
  // 0x5ea6  度
  166,94,34,35,59,37,1,253,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,127,64,0,0,0,2,255,255,255,255,255,255,255,240,2,255,255,255,255,255,255,255,240,2,255,255,255,255,255,255,255,240,2,252,0,0,0,0,0,0,0,2,252,0,47,128,0,127,0,0,2,252,0,47,128,0,127,0,0,2,252,0,47,128,0,127,0,0,2,252,255,255,255,255,255,255,224,2,252,255,255,255,255,255,255,224,2,252,255,255,255,255,255,255,208,2,252,0,47,128,0,127,0,0,2,248,0,47,128,0,127,0,0,2,248,0,47,128,0,127,0,0,2,248,0,47,255,255,255,0,0,2,248,0,47,255,255,255,0,0,2,248,0,26,170,170,170,0,0,3,248,0,0,0,0,0,0,0,3,244,191,255,255,255,255,224,0,3,244,191,255,255,255,255,252,0,3,240,191,255,255,255,255,248,0,3,240,0,127,0,0,15,240,0,7,240,0,63,192,0,63,208,0,11,224,0,15,244,1,255,64,0,15,208,0,7,254,15,253,0,0,15,208,0,0,255,255,240,0,0,31,192,0,0,63,255,192,0,0,63,192,0,27,255,255,249,0,0,63,64,107,255,255,255,255,254,80,191,3,255,255,244,6,255,255,240,46,1,255,253,0,0,31,255,208,4,0,233,0,0,0,0,27,128,
  // 0x5f00  开
  0,95,33,33,41,37,2,252,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,0,0,127,0,0,31,192,0,0,0,0,127,0,0,31,192,0,0,0,0,127,0,0,31,192,0,0,0,0,127,0,0,31,192,0,0,0,0,127,0,0,31,192,0,0,0,0,127,0,0,31,192,0,0,0,0,127,0,0,31,192,0,0,0,0,127,0,0,31,192,0,0,0,0,127,0,0,31,192,0,0,0,0,127,0,0,31,192,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,255,85,85,111,213,85,64,0,0,254,0,0,31,192,0,0,0,0,253,0,0,31,192,0,0,0,1,253,0,0,31,192,0,0,0,2,252,0,0,31,192,0,0,0,3,252,0,0,31,192,0,0,0,11,248,0,0,31,192,0,0,0,15,240,0,0,31,192,0,0,0,47,224,0,0,31,192,0,0,0,127,192,0,0,31,192,0,0,1,255,128,0,0,31,192,0,0,7,255,0,0,0,31,192,0,0,47,252,0,0,0,31,192,0,0,191,240,0,0,0,31,192,0,0,47,192,0,0,0,31,192,0,0,14,0,0,0,0,31,192,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5f03  弃
  3,95,34,36,68,37,1,252,0,0,0,0,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,63,255,255,255,255,255,255,255,224,63,255,255,255,255,255,255,255,224,63,255,255,255,255,255,255,255,224,0,0,1,254,0,0,0,0,0,0,0,3,252,0,3,192,0,0,0,0,7,244,0,15,248,0,0,0,0,15,224,0,7,255,0,0,0,0,47,192,0,0,191,208,0,1,85,127,235,255,255,255,248,0,15,255,255,255,255,255,255,254,0,15,255,255,255,255,255,255,255,128,11,254,170,149,84,0,0,63,208,0,0,0,0,0,5,64,15,64,0,0,47,128,0,15,224,0,0,0,0,47,128,0,15,224,0,0,0,0,47,128,0,15,224,0,0,0,0,47,128,0,15,224,0,0,0,0,63,128,0,15,224,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,0,0,127,0,0,15,224,0,0,0,0,255,0,0,15,224,0,0,0,1,254,0,0,15,224,0,0,0,3,252,0,0,15,224,0,0,0,15,248,0,0,15,224,0,0,0,191,240,0,0,15,224,0,0,7,255,192,0,0,15,224,0,0,127,254,0,0,0,15,224,0,0,47,240,0,0,0,15,224,0,0,14,64,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5f0f  式
  15,95,34,35,59,37,2,253,0,0,0,0,6,160,4,0,0,0,0,0,0,7,240,63,0,0,0,0,0,0,7,244,127,208,0,0,0,0,0,7,244,31,244,0,0,0,0,0,7,244,3,253,0,0,0,0,0,7,244,0,252,0,0,0,0,0,7,244,0,32,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,85,85,87,249,85,85,64,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,2,252,0,0,0,5,85,85,85,66,252,0,0,0,47,255,255,255,226,252,0,0,0,47,255,255,255,225,253,0,0,0,47,255,255,255,224,253,0,0,0,0,1,252,0,0,254,0,0,0,0,1,252,0,0,255,0,0,0,0,1,252,0,0,191,0,0,0,0,1,252,0,0,191,0,0,0,0,1,252,0,0,127,64,0,0,0,1,252,0,0,63,128,0,0,0,1,252,0,0,63,192,7,0,0,1,252,0,0,31,208,7,224,0,1,252,6,248,15,224,11,224,0,1,255,255,248,15,240,11,224,0,107,255,255,248,7,248,15,208,127,255,255,254,144,3,254,15,192,127,255,254,64,0,1,255,255,192,63,250,64,0,0,0,191,255,128,41,0,0,0,0,0,47,255,0,0,0,0,0,0,0,6,248,0,
  // 0x5f15  引
  21,95,29,36,32,37,3,252,0,0,0,0,0,0,21,0,0,0,0,0,0,0,63,64,127,255,255,254,0,0,63,64,127,255,255,254,0,0,63,64,127,255,255,254,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,31,255,255,254,0,0,63,64,31,255,255,254,0,0,63,64,47,255,255,254,0,0,63,64,47,192,0,0,0,0,63,64,63,128,0,0,0,0,63,64,63,64,0,0,0,0,63,64,63,0,0,0,0,0,63,64,127,0,0,0,0,0,63,64,191,255,255,255,0,0,63,64,255,255,255,255,0,0,63,64,255,255,255,254,0,0,63,64,253,0,0,254,0,0,63,64,188,0,0,254,0,0,63,64,0,0,0,253,0,0,63,64,0,0,0,253,0,0,63,64,0,0,0,253,0,0,63,64,0,0,1,252,0,0,63,64,0,0,2,252,0,0,63,64,0,0,2,252,0,0,63,64,0,0,3,248,0,0,63,64,0,0,7,248,0,0,63,64,2,165,111,244,0,0,63,64,1,255,255,240,0,0,63,64,0,255,255,208,0,0,63,64,0,255,254,0,0,0,63,64,0,0,0,0,0,0,0,0,
  // 0x5f39  弹
  57,95,34,36,68,37,2,252,0,0,0,0,16,0,2,64,0,0,0,0,2,240,0,7,244,0,191,255,252,3,252,0,11,240,0,191,255,252,0,253,0,15,224,0,191,255,252,0,191,0,47,192,0,0,1,252,0,63,128,63,64,0,0,1,252,0,31,64,191,0,0,0,1,252,0,8,0,253,0,0,0,1,252,42,170,171,254,170,0,0,1,252,63,255,255,255,255,0,63,255,252,63,255,255,255,255,0,63,255,252,63,64,127,64,127,0,63,255,252,63,64,127,64,127,0,62,0,0,63,64,127,64,127,0,62,0,0,63,255,255,255,255,0,126,0,0,63,255,255,255,255,0,126,0,0,63,170,191,170,191,0,126,0,0,63,64,127,64,127,0,126,0,0,63,64,127,64,127,0,127,255,252,63,234,255,234,255,0,191,255,248,63,255,255,255,255,0,191,255,248,63,255,255,255,255,0,0,2,248,0,0,127,64,0,0,0,2,248,0,0,127,64,0,0,0,2,244,0,0,127,64,0,0,0,2,247,255,255,255,255,255,208,0,3,247,255,255,255,255,255,208,0,3,247,255,255,255,255,255,208,0,3,240,0,0,127,64,0,0,0,3,240,0,0,127,64,0,0,0,7,240,0,0,127,64,0,0,16,31,224,0,0,127,64,0,0,63,255,208,0,0,127,64,0,0,31,255,192,0,0,127,64,0,0,15,254,0,0,0,127,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5f52  归
  82,95,31,36,32,37,3,252,0,1,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,31,255,255,255,252,105,2,252,31,255,255,255,252,254,2,252,31,255,255,255,252,254,2,252,5,85,85,87,252,254,2,252,0,0,0,2,252,254,2,252,0,0,0,2,252,254,2,252,0,0,0,2,252,254,2,252,0,0,0,2,252,254,2,252,0,0,0,2,252,254,2,252,0,0,0,2,252,254,2,252,0,0,0,2,252,254,2,252,0,0,0,2,252,254,2,252,1,85,85,87,252,254,2,252,7,255,255,255,252,254,2,252,7,255,255,255,252,254,2,248,7,255,255,255,252,254,2,248,0,0,0,2,252,254,3,248,0,0,0,2,252,254,3,248,0,0,0,2,252,254,3,244,0,0,0,2,252,85,7,244,0,0,0,2,252,0,11,240,0,0,0,2,252,0,15,240,0,0,0,2,252,0,15,224,0,0,0,2,252,0,47,192,0,0,0,2,252,0,63,192,21,85,85,87,252,0,255,64,127,255,255,255,252,2,255,0,127,255,255,255,252,11,252,0,127,255,255,255,252,47,244,0,0,0,0,2,252,15,224,0,0,0,0,2,252,3,64,0,0,0,0,1,164,0,0,0,0,0,0,0,0,
  // 0x5f84  径
  132,95,35,35,59,37,1,253,0,0,144,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,11,252,63,255,255,255,254,0,0,31,240,63,255,255,255,255,64,0,127,192,63,255,255,255,255,0,2,255,64,0,184,0,1,254,0,11,253,0,0,253,0,3,252,0,63,244,0,0,191,0,11,244,0,127,208,61,0,63,192,31,224,0,47,0,191,64,31,240,127,192,0,8,1,254,0,11,253,255,0,0,0,3,252,0,2,255,252,0,0,0,15,244,0,0,255,244,0,0,0,47,224,0,2,255,253,0,0,0,191,192,0,47,255,255,208,0,2,255,192,6,255,244,255,254,64,11,255,193,191,255,64,31,255,248,63,255,194,255,248,0,2,255,244,255,239,192,254,64,26,128,27,224,127,95,192,80,0,47,192,0,64,61,31,192,0,0,47,192,0,0,20,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,192,31,255,255,255,255,64,0,31,192,31,255,255,255,255,64,0,31,192,31,255,255,255,255,64,0,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,192,0,0,47,192,0,0,0,31,195,255,255,255,255,255,244,0,31,195,255,255,255,255,255,244,0,31,195,255,255,255,255,255,244,0,31,192,0,0,0,0,0,0,
  // 0x5f85  待
  133,95,35,35,59,37,1,253,0,0,144,0,0,42,64,0,0,0,2,252,0,0,63,128,0,0,0,7,252,0,0,63,128,0,0,0,31,240,0,0,63,128,0,0,0,127,208,0,0,63,128,0,0,1,255,64,47,255,255,255,255,128,11,253,0,47,255,255,255,255,128,63,244,0,47,255,255,255,255,128,63,192,16,0,0,63,128,0,0,31,0,189,0,0,63,128,0,0,4,1,253,0,0,63,128,0,0,0,3,252,0,0,63,128,0,0,0,15,243,255,255,255,255,255,248,0,47,211,255,255,255,255,255,248,0,191,195,255,255,255,255,255,248,2,255,192,0,0,0,15,224,0,11,255,192,0,0,0,15,224,0,47,255,192,0,0,0,15,224,0,191,255,192,0,0,0,15,224,0,127,159,193,255,255,255,255,255,240,61,31,193,255,255,255,255,255,240,20,31,193,255,255,255,255,255,240,0,31,192,0,0,0,15,224,0,0,31,192,1,208,0,15,224,0,0,31,192,11,240,0,15,224,0,0,31,192,3,252,0,15,224,0,0,31,192,2,254,0,15,224,0,0,31,192,0,255,0,15,224,0,0,31,192,0,63,192,15,224,0,0,31,192,0,47,192,15,224,0,0,31,192,0,14,0,15,224,0,0,31,192,0,0,16,31,224,0,0,31,192,0,0,63,255,208,0,0,31,192,0,0,47,255,192,0,0,31,192,0,0,15,254,0,0,
  // 0x5faa  循
  170,95,35,35,59,37,1,253,0,1,128,0,0,0,0,0,0,0,3,248,0,0,0,6,253,0,0,15,240,0,0,91,255,255,64,0,63,208,126,255,255,255,249,0,0,191,64,127,255,255,253,0,0,2,254,0,127,250,82,248,0,0,11,248,0,127,0,2,248,0,0,63,224,0,126,0,2,248,0,0,127,128,144,126,0,2,248,0,0,45,1,253,127,255,255,255,255,244,4,3,252,127,255,255,255,255,244,0,11,240,127,255,255,255,255,244,0,31,224,126,0,3,244,0,0,0,63,192,126,0,3,240,0,0,0,255,128,126,0,3,240,0,0,3,255,128,126,31,255,255,255,128,31,255,128,126,31,255,255,255,192,127,255,128,126,31,255,255,255,192,255,175,128,190,31,128,0,31,192,62,47,128,190,31,128,0,31,192,40,47,128,189,31,149,85,111,192,0,47,128,253,31,255,255,255,192,0,47,128,253,31,255,255,255,192,0,47,128,252,31,128,0,31,192,0,47,128,252,31,128,0,31,192,0,47,129,252,31,128,0,31,192,0,47,130,248,31,255,255,255,192,0,47,130,248,31,255,255,255,192,0,47,131,244,31,149,85,111,192,0,47,135,240,31,128,0,31,192,0,47,139,240,31,128,0,31,192,0,47,143,208,31,255,255,255,192,0,47,159,192,31,255,255,255,192,0,47,131,128,31,149,85,111,192,0,47,128,0,31,128,0,10,128,
  // 0x5fae  微
  174,95,35,35,59,37,1,253,0,14,0,11,192,0,58,0,0,0,47,192,11,192,0,63,0,0,0,127,64,11,192,0,127,0,0,0,255,15,11,194,224,190,0,0,3,252,15,11,194,240,253,0,0,15,244,15,11,194,240,252,0,0,63,208,15,11,194,240,252,0,0,191,64,15,11,194,241,255,255,244,61,7,223,11,194,243,255,255,244,20,15,239,11,194,243,255,255,244,0,47,207,255,255,247,240,15,192,0,63,79,255,255,255,240,15,128,0,191,15,255,255,255,240,31,128,1,254,0,0,0,47,244,31,64,3,253,0,0,0,63,248,47,64,11,253,0,0,0,191,248,47,0,31,253,0,0,0,60,188,63,0,127,253,47,255,255,244,124,63,0,255,253,47,255,255,240,61,62,0,189,189,47,255,255,240,62,125,0,56,189,1,244,63,0,63,188,0,16,189,1,244,63,0,47,252,0,0,189,1,244,63,0,15,248,0,0,189,1,244,63,0,15,240,0,0,189,2,244,63,0,11,240,0,0,189,2,240,63,0,15,240,0,0,189,3,240,63,188,47,244,0,0,189,7,240,63,253,127,252,0,0,189,11,208,255,248,255,254,0,0,189,15,192,255,66,252,127,64,0,189,63,128,96,11,244,63,208,0,189,191,0,0,63,224,15,244,0,189,61,0,0,191,128,7,248,0,189,8,0,0,62,0,1,240,0,189,0,0,0,4,0,0,64,
  // 0x5fc3  心
  195,95,35,35,59,37,1,253,0,0,0,80,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,3,255,244,0,0,0,0,0,0,1,255,255,0,0,0,0,0,0,0,11,255,224,0,0,0,0,0,0,0,191,254,0,0,0,0,0,0,0,15,255,192,0,0,0,0,0,0,1,255,64,0,0,0,0,0,0,0,46,0,0,0,0,0,0,0,0,4,0,0,0,0,0,5,80,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,2,64,0,0,64,15,240,0,0,31,192,0,0,252,15,240,0,0,31,240,0,1,252,15,240,0,0,11,248,0,1,252,15,240,0,0,3,252,0,2,252,15,240,0,0,1,254,0,3,248,15,240,0,0,0,255,0,3,244,15,240,0,0,0,127,128,7,240,15,240,0,0,0,63,192,11,240,15,240,0,0,0,31,224,15,240,15,240,0,0,0,15,240,31,208,15,240,0,0,0,11,244,63,192,15,240,0,0,116,7,248,127,192,15,240,0,0,127,3,252,255,64,15,240,0,0,127,2,224,47,0,15,240,0,0,190,0,0,4,0,15,240,0,0,190,0,0,0,0,11,240,0,0,253,0,0,0,0,11,244,0,2,252,0,0,0,0,7,255,255,255,252,0,0,0,0,3,255,255,255,244,0,0,0,0,0,191,255,255,208,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5ffd  忽
  253,95,34,35,59,37,2,253,0,0,57,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,11,255,255,255,255,255,244,0,0,31,255,255,255,255,255,244,0,0,127,255,255,255,255,255,244,0,1,255,64,255,1,253,7,240,0,7,253,2,252,2,252,3,240,0,47,244,7,248,3,244,7,240,0,191,208,15,240,15,240,7,240,0,127,64,63,192,31,208,7,240,0,13,0,255,64,63,192,11,240,0,0,3,253,0,255,0,11,240,0,0,31,248,2,253,0,15,224,0,0,191,208,11,248,0,15,208,0,7,255,64,47,240,0,31,208,0,15,252,0,191,192,0,63,192,0,3,224,3,255,0,255,255,192,0,0,64,47,252,0,127,255,64,0,0,0,31,224,0,63,248,0,0,0,0,7,139,128,0,0,0,0,0,0,0,47,244,0,0,0,0,0,64,5,11,254,0,13,0,0,0,253,63,129,255,192,191,64,0,0,252,63,128,63,128,63,208,0,2,252,63,128,10,0,15,240,0,3,248,63,128,0,2,7,252,0,15,240,63,128,0,7,225,254,0,47,224,63,128,0,7,224,191,64,127,192,47,192,0,15,224,63,192,255,64,47,255,255,255,208,31,208,61,0,15,255,255,255,192,14,0,0,0,6,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6027  性
  39,96,34,35,59,37,1,253,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,2,248,15,192,0,0,0,63,128,2,248,15,192,0,0,0,63,128,3,248,15,192,0,0,0,63,128,3,244,15,192,0,0,0,63,136,3,240,15,192,0,0,9,63,253,7,240,15,192,0,0,15,127,191,15,255,255,255,255,192,31,63,175,79,255,255,255,255,192,31,63,159,159,255,255,255,255,192,47,63,143,239,213,95,213,85,64,63,63,139,255,64,15,192,0,0,62,63,129,191,0,15,192,0,0,62,63,128,255,0,15,192,0,0,125,63,128,253,0,15,192,0,0,188,63,128,44,0,15,192,0,0,188,63,128,0,0,15,192,0,0,0,63,128,0,0,31,208,0,0,0,63,128,15,255,255,255,255,64,0,63,128,15,255,255,255,255,64,0,63,128,15,255,255,255,255,64,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,128,0,0,15,192,0,0,0,63,130,255,255,255,255,255,240,0,63,130,255,255,255,255,255,240,0,63,130,255,255,255,255,255,240,0,63,128,85,85,85,85,85,80,0,42,64,0,0,0,0,0,0,
  // 0x603b  总
  59,96,34,35,59,37,2,253,0,0,20,0,0,6,0,0,0,0,1,252,0,0,15,224,0,0,0,0,255,0,0,15,240,0,0,0,0,191,64,0,47,208,0,0,0,0,63,192,0,63,192,0,0,0,0,31,224,0,191,0,0,0,0,0,15,240,0,254,0,0,0,0,0,11,144,2,253,0,0,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,64,0,0,0,127,64,0,0,127,64,0,0,0,127,64,0,0,127,64,0,0,0,127,64,0,0,127,64,0,0,0,127,64,0,0,127,64,0,0,0,127,64,0,0,127,128,0,0,0,127,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,0,0,2,64,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,106,15,252,0,2,192,0,7,144,191,2,255,64,15,224,0,11,240,191,0,127,208,11,244,0,15,224,191,0,31,240,3,252,0,15,208,191,0,7,192,0,254,0,47,192,191,0,1,0,64,127,64,63,192,191,0,0,0,248,63,192,127,64,191,0,0,0,252,31,208,255,0,191,64,0,2,252,15,192,125,0,127,255,255,255,248,5,0,4,0,63,255,255,255,240,0,0,0,0,11,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6062  恢
  98,96,35,35,59,37,1,253,0,63,64,15,192,0,0,0,0,0,63,64,15,192,0,0,0,0,0,63,64,15,192,0,0,0,0,0,63,64,15,192,0,0,0,0,0,63,67,255,255,255,255,255,244,0,63,67,255,255,255,255,255,244,0,63,167,255,255,255,255,255,244,9,63,252,31,192,0,0,0,0,15,63,188,15,192,0,252,0,0,31,63,126,15,192,0,252,0,0,31,63,95,15,192,0,252,0,0,31,63,79,79,192,0,252,0,0,47,63,79,79,192,0,252,2,144,62,63,75,79,199,192,252,3,240,61,63,64,15,199,192,252,7,224,124,63,64,15,203,192,252,11,208,188,63,64,15,203,192,252,15,192,116,63,64,31,207,128,252,31,128,0,63,64,31,143,65,252,47,0,0,63,64,31,159,1,252,63,0,0,63,64,47,127,2,252,125,0,0,63,64,47,93,3,253,4,0,0,63,64,63,0,3,254,0,0,0,63,64,63,0,7,255,0,0,0,63,64,127,0,15,239,64,0,0,63,64,190,0,31,143,192,0,0,63,64,253,0,63,79,208,0,0,63,64,252,0,191,7,240,0,0,63,66,252,1,253,3,252,0,0,63,67,248,7,248,1,254,0,0,63,71,240,31,240,0,191,128,0,63,79,224,191,192,0,63,244,0,63,95,194,255,64,0,15,248,0,63,75,128,252,0,0,3,240,0,63,65,0,96,0,0,0,144,
  // 0x606f  息
  111,96,35,35,59,37,1,253,0,0,0,1,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,11,255,255,255,255,255,192,0,0,11,255,255,255,255,255,192,0,0,11,250,170,170,170,191,192,0,0,11,224,0,0,0,15,192,0,0,11,224,0,0,0,15,192,0,0,11,250,170,170,170,175,192,0,0,11,255,255,255,255,255,192,0,0,11,255,255,255,255,255,192,0,0,11,224,0,0,0,15,192,0,0,11,224,0,0,0,15,192,0,0,11,250,170,170,170,175,192,0,0,11,255,255,255,255,255,192,0,0,11,255,255,255,255,255,192,0,0,11,224,0,0,0,15,192,0,0,11,224,0,0,0,15,192,0,0,11,224,0,0,0,15,192,0,0,11,255,255,255,255,255,192,0,0,11,255,255,255,255,255,192,0,0,6,170,170,170,170,170,128,0,0,0,0,2,208,0,0,0,0,0,0,0,15,244,0,0,0,0,0,80,0,3,253,0,2,192,0,0,190,15,208,255,64,15,240,0,0,253,15,208,63,208,15,252,0,1,252,15,208,15,208,3,254,0,3,248,15,208,7,0,0,255,64,11,240,15,208,0,2,224,63,208,31,240,15,208,0,3,244,31,240,127,192,15,224,0,7,244,11,244,63,64,15,255,255,255,240,3,244,6,0,7,255,255,255,224,1,128,0,0,1,191,255,255,64,0,0,
  // 0x611f  感
  31,97,35,35,59,37,1,253,0,0,0,0,3,240,61,0,0,0,0,0,0,3,244,191,208,0,0,0,0,0,3,244,47,248,0,0,0,0,0,3,244,2,244,0,1,255,255,255,255,255,255,255,224,1,255,255,255,255,255,255,255,224,1,255,255,255,255,255,255,255,208,1,252,0,0,0,252,0,0,0,1,252,85,85,84,253,1,144,0,1,252,255,255,252,190,3,248,0,1,252,255,255,252,190,7,240,0,1,248,0,0,0,127,11,240,0,1,248,0,0,0,63,79,208,0,2,248,21,85,80,47,175,192,0,2,244,191,255,248,31,255,64,0,3,244,191,255,248,15,255,0,0,3,240,188,1,248,11,252,0,64,7,240,188,1,248,11,248,0,240,11,224,188,1,248,63,252,0,248,15,208,191,255,249,255,255,1,244,31,192,191,255,255,254,63,211,240,63,128,21,86,87,248,31,255,240,191,0,0,11,128,208,7,255,208,46,0,0,47,244,0,0,191,64,8,0,5,75,254,0,1,128,0,0,61,15,208,255,192,15,224,0,0,127,15,208,47,128,15,248,0,0,254,15,208,10,1,3,254,0,1,253,15,208,0,2,224,255,64,3,252,15,208,0,3,244,63,192,15,240,15,224,0,3,240,31,240,63,224,15,255,255,255,240,11,244,47,128,7,255,255,255,208,3,208,2,0,1,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x620f  戏
  15,98,35,36,68,37,1,252,0,0,0,0,3,244,2,0,0,0,0,0,0,3,248,31,192,0,0,0,0,0,3,248,47,240,0,0,0,0,0,3,248,7,252,0,63,255,255,248,3,248,1,255,0,63,255,255,252,3,252,0,191,0,63,255,255,248,2,252,0,40,0,0,0,3,244,2,252,0,0,0,0,0,3,244,2,252,0,22,144,2,0,7,240,2,254,191,255,224,15,128,7,242,255,255,255,255,240,47,208,11,227,255,255,255,254,144,15,240,15,227,255,255,148,0,0,3,248,31,194,149,253,0,0,0,2,253,47,192,0,253,0,62,0,0,255,63,128,0,254,0,63,64,0,63,255,64,0,254,0,191,0,0,31,255,0,0,191,0,254,0,0,15,254,0,0,191,2,252,0,0,3,253,0,0,127,7,248,0,0,3,254,0,0,127,79,240,0,0,11,255,64,0,63,175,208,0,0,15,255,192,0,63,255,128,0,0,47,255,224,0,47,255,0,0,0,127,207,240,0,31,253,0,0,0,255,71,252,0,15,248,2,64,3,254,2,253,0,63,240,2,240,15,252,0,248,0,255,248,3,244,63,240,0,160,3,255,252,3,240,191,208,0,0,31,255,255,3,240,47,64,0,0,255,240,255,219,224,13,0,0,3,255,192,191,255,208,0,0,0,0,253,0,47,255,192,0,0,0,0,32,0,11,255,128,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,0,0,
  // 0x6210  成
  16,98,35,36,68,37,1,252,0,0,0,0,7,240,40,0,0,0,0,0,0,7,244,191,64,0,0,0,0,0,7,244,191,240,0,0,0,0,0,7,244,15,253,0,0,0,0,0,7,244,2,254,0,0,0,0,0,3,244,0,60,0,1,255,255,255,255,255,255,255,240,1,255,255,255,255,255,255,255,240,1,255,255,255,255,255,255,255,240,1,253,85,85,87,249,85,85,80,1,252,0,0,3,248,0,0,0,1,252,0,0,3,252,0,0,0,1,252,0,0,2,252,0,185,0,1,252,0,0,2,252,0,255,0,1,255,255,255,65,252,1,253,0,1,255,255,255,65,252,3,252,0,1,255,255,255,64,253,3,248,0,1,253,0,63,64,254,11,240,0,1,252,0,63,64,255,15,224,0,1,252,0,63,64,191,47,208,0,2,252,0,63,64,127,127,128,0,2,252,0,63,64,127,255,0,0,2,252,0,63,0,63,253,0,0,3,252,0,63,0,47,252,0,0,3,248,0,127,0,31,240,1,64,3,248,0,191,0,63,224,2,224,7,244,255,255,0,255,240,2,244,11,240,191,253,3,255,244,3,244,15,240,191,244,15,255,252,3,240,15,224,0,0,127,241,254,3,240,47,208,0,2,255,208,255,139,240,63,192,0,15,255,64,127,255,208,127,128,0,11,252,0,31,255,192,47,0,0,3,224,0,7,255,64,6,0,0,0,64,0,0,84,0,0,0,0,0,0,0,0,0,0,
  // 0x6237  户
  55,98,31,36,32,37,1,252,0,0,0,1,184,0,0,0,0,0,0,2,252,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,127,64,0,0,0,63,255,255,255,255,255,244,0,63,255,255,255,255,255,244,0,63,255,255,255,255,255,244,0,63,128,0,0,0,3,244,0,63,128,0,0,0,3,244,0,63,128,0,0,0,3,244,0,63,128,0,0,0,3,244,0,63,128,0,0,0,3,244,0,63,128,0,0,0,3,244,0,63,128,0,0,0,3,244,0,63,255,255,255,255,255,244,0,63,255,255,255,255,255,244,0,63,255,255,255,255,255,244,0,63,64,0,0,0,7,244,0,127,0,0,0,0,3,244,0,127,0,0,0,0,1,80,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,253,0,0,0,0,0,0,1,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,248,0,0,0,0,0,0,11,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,47,208,0,0,0,0,0,0,127,192,0,0,0,0,0,0,63,64,0,0,0,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6240  所
  64,98,35,34,50,37,1,253,0,0,0,0,0,0,0,111,64,47,255,255,255,208,0,7,255,208,47,255,255,255,209,2,255,255,208,47,255,255,255,215,255,255,248,0,0,0,0,0,7,255,254,64,0,0,0,0,0,7,255,64,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,7,255,255,255,71,240,0,0,0,7,255,255,255,71,240,0,0,0,7,255,255,255,71,240,0,0,0,7,240,0,63,71,240,0,0,0,7,240,0,63,71,255,255,255,248,7,240,0,63,71,255,255,255,248,7,240,0,63,71,255,255,255,248,7,240,0,63,71,245,86,253,80,7,240,0,63,71,240,2,252,0,7,255,255,255,71,240,2,252,0,7,255,255,255,75,240,2,252,0,7,255,255,255,79,224,2,252,0,7,240,0,0,15,224,2,252,0,11,224,0,0,15,208,2,252,0,11,224,0,0,15,192,2,252,0,11,224,0,0,47,192,2,252,0,15,208,0,0,63,128,2,252,0,15,208,0,0,63,64,2,252,0,15,192,0,0,191,0,2,252,0,31,192,0,0,254,0,2,252,0,47,128,0,2,252,0,2,252,0,63,64,0,7,248,0,2,252,0,191,0,0,15,240,0,2,252,0,254,0,0,47,224,0,2,252,0,125,0,0,11,128,0,2,252,0,8,0,0,2,0,0,1,252,0,
  // 0x6247  扇
  71,98,33,33,41,37,1,253,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,252,0,0,191,255,255,255,255,255,252,0,0,191,170,170,170,170,170,252,0,0,190,0,0,0,0,0,252,0,0,190,0,0,0,0,0,252,0,0,191,170,170,170,170,170,252,0,0,191,255,255,255,255,255,252,0,0,191,255,255,255,255,255,252,0,0,190,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,170,170,164,170,170,169,0,0,253,255,255,248,255,255,254,0,0,253,255,255,248,255,255,254,0,0,253,4,2,248,4,0,126,0,0,252,46,2,248,47,0,126,0,1,252,63,130,248,47,192,126,0,1,252,15,210,248,11,240,126,0,2,252,7,242,248,3,240,126,0,3,248,2,130,248,0,128,126,0,7,244,0,22,248,0,26,126,0,11,240,2,250,248,2,254,126,0,15,224,127,254,248,111,254,126,0,31,211,255,210,249,255,224,126,0,63,195,253,2,248,253,0,126,0,127,130,208,2,248,144,0,190,0,255,0,0,171,244,0,59,254,0,45,0,0,255,240,0,63,253,0,4,0,0,191,144,0,31,228,0,
  // 0x624b  手
  75,98,33,36,68,37,2,252,0,0,0,0,0,0,110,0,0,0,0,0,0,6,191,255,128,0,0,5,106,255,255,255,255,208,0,11,255,255,255,255,255,233,0,0,7,255,255,255,254,148,0,0,0,3,255,170,87,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,1,85,85,87,249,85,85,84,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,85,85,85,91,249,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,1,85,91,244,0,0,0,0,0,2,255,255,240,0,0,0,0,0,0,255,255,224,0,0,0,0,0,0,255,254,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6253  打
  83,98,34,35,59,37,2,253,0,63,64,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,31,255,255,255,255,224,0,63,128,31,255,255,255,255,224,0,63,128,31,255,255,255,255,224,0,63,128,5,85,86,254,85,64,0,63,128,0,0,1,252,0,0,255,255,255,192,0,1,252,0,0,255,255,255,192,0,1,252,0,0,255,255,255,192,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,135,208,0,1,252,0,0,0,63,255,208,0,1,252,0,0,1,191,255,224,0,1,252,0,0,191,255,255,144,0,1,252,0,0,255,255,208,0,0,1,252,0,0,255,255,128,0,0,1,252,0,0,180,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,1,252,0,0,0,63,128,0,0,2,252,0,0,63,255,64,0,63,255,252,0,0,47,255,0,0,63,255,252,0,0,31,248,0,0,31,255,240,0,0,0,0,0,0,10,169,0,0,0,
  // 0x6267  执
  103,98,35,36,68,37,1,252,0,47,64,0,15,208,0,0,0,0,63,64,0,15,208,0,0,0,0,63,64,0,15,208,0,0,0,0,63,64,0,15,208,0,0,0,0,63,64,0,15,208,0,0,0,0,63,64,0,15,208,0,0,0,0,63,64,0,15,208,0,0,0,0,63,128,0,15,224,0,0,0,63,255,255,63,255,255,255,224,0,63,255,255,63,255,255,255,224,0,63,255,255,63,255,255,255,224,0,0,63,64,0,15,208,15,224,0,0,63,64,0,15,192,15,208,0,0,63,64,0,15,192,15,208,0,0,63,64,0,15,192,15,208,0,0,63,64,4,31,192,15,208,0,0,63,70,31,95,192,15,208,0,0,63,255,127,255,192,15,208,0,0,127,255,111,255,128,15,208,0,27,255,255,67,255,208,15,208,0,191,255,224,0,127,248,15,208,0,127,255,64,0,127,255,79,208,0,62,63,64,0,191,255,239,208,0,0,63,64,0,254,47,239,208,0,0,63,64,1,252,7,207,208,0,0,63,64,3,252,1,79,208,0,0,63,64,7,248,0,15,208,0,0,63,64,15,240,0,11,208,192,0,63,64,47,224,0,11,224,244,0,63,64,127,192,0,7,225,248,0,63,65,255,64,0,3,241,244,5,127,75,254,0,0,3,251,240,31,255,95,252,0,0,2,255,240,15,255,11,224,0,0,0,255,208,15,244,3,128,0,0,0,63,64,0,0,0,0,0,0,0,0,0,
  // 0x6279  批
  121,98,35,35,59,37,1,253,0,63,0,5,64,1,164,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,127,255,255,47,192,2,248,0,0,127,255,255,47,192,2,248,2,0,127,255,255,47,192,2,248,11,192,0,63,0,47,192,2,248,63,240,0,63,0,47,255,242,249,255,192,0,63,0,47,255,242,255,254,0,0,63,0,47,255,242,255,244,0,0,63,0,47,213,82,255,128,0,0,63,94,47,192,2,252,0,0,0,63,254,47,192,2,248,0,0,6,255,255,47,192,2,248,0,0,191,255,249,47,192,2,248,0,0,191,255,64,47,192,2,248,0,0,127,127,0,47,192,2,248,0,0,16,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,0,0,0,63,0,47,192,2,248,1,208,0,63,0,47,192,2,248,1,248,0,63,0,47,192,98,248,2,248,0,63,0,47,219,242,248,2,244,0,63,10,255,255,246,252,3,240,0,127,15,255,255,225,255,255,240,47,255,11,255,144,0,255,255,224,31,254,3,144,0,0,127,255,128,15,228,0,0,0,0,0,0,0,
  // 0x6296  抖
  150,98,35,36,68,37,1,252,0,31,192,0,0,0,15,208,0,0,31,192,0,0,0,15,224,0,0,31,192,0,0,0,15,224,0,0,31,192,0,45,0,15,224,0,0,31,192,0,127,192,15,224,0,0,31,192,0,127,244,15,224,0,0,31,192,0,11,254,15,224,0,0,31,192,0,1,255,79,224,0,63,255,255,208,0,63,15,224,0,63,255,255,208,0,12,15,224,0,63,255,255,208,0,0,15,224,0,0,31,192,0,0,0,15,224,0,0,31,192,0,128,0,15,224,0,0,31,192,2,248,0,15,224,0,0,31,192,7,255,128,15,224,0,0,31,192,1,255,240,15,224,0,0,31,192,64,31,252,15,224,0,0,31,223,208,3,244,15,224,0,0,47,255,224,0,176,15,224,0,27,255,255,224,0,0,15,224,0,127,255,249,0,0,0,15,224,0,63,255,192,0,0,0,15,251,244,63,111,192,0,0,6,191,255,244,0,31,192,0,107,255,255,255,248,0,31,192,47,255,255,255,250,64,0,31,192,31,255,255,175,224,0,0,31,192,31,250,64,15,224,0,0,31,192,5,0,0,15,224,0,0,31,192,0,0,0,15,224,0,0,31,192,0,0,0,15,224,0,0,31,192,0,0,0,15,224,0,0,47,192,0,0,0,15,224,0,31,255,192,0,0,0,15,224,0,15,255,64,0,0,0,15,224,0,15,249,0,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,
  // 0x62a5  报
  165,98,34,36,68,37,1,252,0,10,128,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,7,255,255,255,255,64,0,31,192,7,255,255,255,255,64,0,31,192,7,255,255,255,255,0,0,31,192,7,240,0,0,127,0,0,31,192,7,240,0,0,127,0,21,111,213,71,240,0,0,191,0,63,255,255,199,240,0,0,255,0,63,255,255,199,240,46,170,254,0,63,255,255,199,240,15,255,252,0,0,31,192,7,240,15,255,240,0,0,31,192,7,240,0,0,0,0,0,31,192,7,240,0,0,0,0,0,31,192,7,255,255,255,255,128,0,31,192,7,255,255,255,255,192,0,31,214,199,255,255,255,255,192,0,31,255,199,247,240,0,63,128,6,255,255,215,243,248,0,63,64,191,255,255,135,241,252,0,127,0,127,255,224,7,240,253,0,255,0,63,255,192,7,240,191,0,253,0,57,31,192,7,240,63,130,252,0,0,31,192,7,240,47,195,248,0,0,31,192,7,240,15,255,240,0,0,31,192,7,240,7,255,224,0,0,31,192,7,240,3,255,192,0,0,31,192,7,240,1,255,128,0,0,31,192,7,240,3,255,208,0,0,31,192,7,240,15,255,248,0,0,31,192,7,240,63,255,254,0,16,47,192,7,242,255,194,255,224,63,255,192,7,255,255,0,191,240,47,255,128,7,247,248,0,31,208,31,249,0,7,242,192,0,2,128,0,0,0,0,0,0,0,0,0,
  // 0x62ac  抬
  172,98,35,36,68,37,1,252,0,31,192,0,0,228,0,0,0,0,31,192,0,1,254,0,0,0,0,31,192,0,3,252,0,0,0,0,31,192,0,3,252,0,0,0,0,31,192,0,7,244,0,0,0,0,31,192,0,11,240,0,0,0,0,31,192,0,15,224,1,64,0,0,31,192,0,31,208,15,208,0,127,255,255,192,47,192,15,240,0,127,255,255,192,63,64,7,248,0,127,255,255,192,127,0,1,253,0,0,31,192,0,254,0,0,191,0,0,31,192,1,254,106,191,255,192,0,31,192,127,255,255,255,255,208,0,31,192,127,255,255,255,255,240,0,31,192,63,255,250,149,71,248,0,31,193,165,0,0,0,3,248,0,31,239,208,0,0,0,1,192,0,47,255,208,0,0,0,0,0,27,255,255,208,0,0,0,0,0,191,255,249,3,255,255,255,255,0,127,255,192,3,255,255,255,255,0,62,95,192,3,255,255,255,255,0,0,31,192,3,240,0,0,191,0,0,31,192,3,240,0,0,191,0,0,31,192,3,240,0,0,191,0,0,31,192,3,240,0,0,191,0,0,31,192,3,240,0,0,191,0,0,31,192,3,240,0,0,191,0,0,31,192,3,240,0,0,191,0,0,31,192,3,255,255,255,255,0,0,31,192,3,255,255,255,255,0,31,255,192,3,255,255,255,255,0,15,255,128,3,240,0,0,191,0,11,253,0,3,240,0,0,106,0,0,0,0,0,0,0,0,0,0,
  // 0x62bd  抽
  189,98,34,36,68,37,1,252,0,31,128,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,127,255,255,133,85,95,213,85,64,127,255,255,159,255,255,255,255,240,127,255,255,159,255,255,255,255,240,0,47,192,31,255,255,255,255,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,95,192,15,192,11,240,0,47,239,159,192,15,192,11,240,0,47,255,223,192,15,208,11,240,27,255,255,223,255,255,255,255,240,191,255,248,31,255,255,255,255,240,127,255,192,31,255,255,255,255,240,62,111,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,192,15,192,11,240,0,47,192,31,213,95,213,95,240,0,47,192,31,255,255,255,255,240,0,47,192,31,255,255,255,255,240,0,47,128,31,255,255,255,255,240,47,255,128,31,192,0,0,11,240,15,255,64,31,192,0,0,11,240,15,249,0,15,192,0,0,6,144,0,0,0,0,0,0,0,0,0,
  // 0x62d4  拔
  212,98,35,36,68,37,1,252,0,31,128,0,11,208,4,0,0,0,47,192,0,15,224,47,64,0,0,47,192,0,15,208,63,224,0,0,47,192,0,15,208,15,253,0,0,47,192,0,15,208,2,255,128,0,47,192,0,15,208,0,127,128,0,47,192,0,15,208,0,15,0,0,47,192,0,15,208,0,0,0,127,255,255,191,255,255,255,255,240,127,255,255,191,255,255,255,255,240,106,191,234,127,255,255,255,255,240,0,47,192,0,15,208,0,0,0,0,47,192,0,15,208,0,0,0,0,47,192,0,31,224,0,0,0,0,47,192,0,31,240,0,253,0,0,47,192,0,47,240,0,253,0,0,47,193,64,47,244,1,252,0,0,47,255,128,63,248,2,252,0,0,127,255,192,63,252,2,248,0,111,255,255,128,127,253,3,244,0,191,255,228,0,191,127,7,240,0,127,255,192,0,254,63,75,240,0,62,47,192,0,253,47,207,208,0,0,47,192,1,252,15,239,192,0,0,47,192,2,252,11,255,128,0,0,47,192,3,244,3,255,0,0,0,47,192,11,240,2,254,0,0,0,47,192,15,224,3,255,64,0,0,47,192,47,192,11,255,208,0,0,47,192,127,128,47,255,244,0,0,47,192,255,0,191,199,254,0,0,47,131,253,3,255,1,255,208,47,255,143,248,31,252,0,127,248,15,255,71,240,15,240,0,11,240,15,249,1,192,3,128,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x62e9  择
  233,98,35,36,68,37,1,252,0,47,128,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,47,128,15,255,255,255,254,0,0,47,128,15,255,255,255,255,64,0,47,128,15,255,255,255,255,0,0,47,128,0,190,0,1,253,0,0,47,128,0,63,64,7,248,0,0,47,128,0,31,192,15,240,0,63,255,255,192,15,240,63,192,0,63,255,255,192,3,253,255,64,0,63,255,255,192,0,255,253,0,0,0,47,128,0,0,191,244,0,0,0,47,128,0,7,255,255,64,0,0,47,128,0,191,253,255,244,0,0,47,128,111,255,208,31,255,228,0,47,128,191,253,0,2,255,244,0,47,155,127,64,31,192,27,224,0,47,255,128,0,31,192,0,64,6,255,255,128,0,31,192,0,0,191,255,249,11,255,255,255,255,0,127,255,128,11,255,255,255,255,0,63,127,128,11,255,255,255,255,0,16,47,128,0,0,31,192,0,0,0,47,128,0,0,31,192,0,0,0,47,128,0,0,31,192,0,0,0,47,128,0,0,31,192,0,0,0,47,128,127,255,255,255,255,244,0,47,128,127,255,255,255,255,244,0,47,128,127,255,255,255,255,244,0,47,128,0,0,31,192,0,0,0,47,128,0,0,31,192,0,0,0,63,128,0,0,31,192,0,0,31,255,128,0,0,31,192,0,0,15,255,0,0,0,31,192,0,0,11,248,0,0,0,31,192,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6309  按
  9,99,35,36,68,37,1,252,0,31,128,0,0,31,192,0,0,0,47,192,0,0,31,192,0,0,0,47,192,0,0,31,192,0,0,0,47,192,0,0,31,192,0,0,0,47,192,0,0,31,192,0,0,0,47,192,63,255,255,255,255,240,0,47,192,63,255,255,255,255,240,0,47,192,63,255,255,255,255,240,127,255,255,191,128,0,0,7,240,127,255,255,191,64,0,0,7,240,127,255,255,191,64,254,0,7,240,0,47,192,63,64,253,0,7,240,0,47,192,21,2,252,0,1,80,0,47,192,0,3,248,0,0,0,0,47,192,0,3,244,0,0,0,0,47,192,63,255,255,255,255,248,0,47,193,191,255,255,255,255,248,0,47,255,255,255,255,255,255,248,1,191,255,192,47,192,2,252,0,127,255,255,128,63,128,3,248,0,191,255,208,0,127,0,3,248,0,127,255,192,0,191,0,7,240,0,57,47,192,0,254,0,15,240,0,0,47,192,1,254,0,31,224,0,0,47,192,2,255,244,63,192,0,0,47,192,3,255,255,191,128,0,0,47,192,2,247,255,255,0,0,0,47,192,0,0,127,255,64,0,0,47,192,0,0,31,255,224,0,0,47,192,0,0,191,255,253,0,0,47,192,0,27,255,75,255,128,0,47,128,22,255,252,1,255,224,47,255,128,255,255,208,0,47,240,15,255,64,127,249,0,0,7,208,15,249,0,62,64,0,0,1,128,0,0,0,0,0,0,0,0,0,
  // 0x6321  挡
  33,99,33,36,68,37,1,252,0,47,128,0,0,10,128,0,0,0,47,128,0,0,15,192,0,0,0,47,128,0,0,15,192,0,0,0,47,128,11,192,15,192,15,128,0,47,128,15,208,15,192,31,192,0,47,128,11,224,15,192,47,192,0,47,128,7,240,15,192,63,64,0,63,192,3,244,15,192,127,0,63,255,255,194,248,15,192,190,0,63,255,255,193,252,15,192,253,0,63,255,255,192,253,15,193,252,0,0,47,128,0,184,15,195,244,0,0,47,128,0,0,15,192,96,0,0,47,128,0,0,15,192,0,0,0,47,128,31,255,255,255,255,192,0,47,128,31,255,255,255,255,192,0,47,130,95,255,255,255,255,192,0,47,255,133,85,85,85,111,192,0,127,255,192,0,0,0,47,192,47,255,255,192,0,0,0,47,192,191,255,248,0,0,0,0,47,192,127,255,128,0,0,0,0,47,192,127,127,128,15,255,255,255,255,192,16,47,128,15,255,255,255,255,192,0,47,128,15,255,255,255,255,192,0,47,128,0,0,0,0,47,192,0,47,128,0,0,0,0,47,192,0,47,128,0,0,0,0,47,192,0,47,128,0,0,0,0,47,192,0,47,128,127,255,255,255,255,192,0,47,128,127,255,255,255,255,192,0,63,128,127,255,255,255,255,192,47,255,128,21,85,85,85,111,192,15,255,0,0,0,0,0,47,192,15,248,0,0,0,0,0,5,64,0,0,0,0,0,0,0,0,0,
  // 0x6324  挤
  36,99,35,35,59,37,1,253,0,127,0,0,0,108,0,0,0,0,127,0,0,0,254,0,0,0,0,127,0,0,0,191,0,0,0,0,127,0,0,0,63,128,0,0,0,127,0,255,255,255,255,255,240,0,127,0,255,255,255,255,255,240,0,127,0,255,255,255,255,255,240,0,127,0,1,252,0,7,244,0,63,255,253,0,253,0,15,240,0,63,255,253,0,127,0,31,208,0,63,255,253,0,63,192,63,192,0,0,127,0,0,15,240,255,0,0,0,127,0,0,7,255,253,0,0,0,127,0,0,1,255,244,0,0,0,127,0,0,2,255,249,0,0,0,127,0,0,191,255,255,228,0,0,127,108,191,255,246,255,255,244,0,127,252,255,254,64,47,255,240,0,191,252,191,224,0,1,191,224,47,255,248,36,85,0,5,64,64,127,255,64,0,254,0,15,208,0,63,255,0,0,254,0,15,208,0,57,127,0,0,254,0,15,208,0,0,127,0,0,254,0,15,208,0,0,127,0,0,254,0,15,208,0,0,127,0,0,253,0,15,208,0,0,127,0,0,253,0,15,208,0,0,127,0,2,252,0,15,208,0,0,127,0,3,248,0,15,208,0,0,127,0,15,244,0,15,208,0,0,127,0,63,224,0,15,208,0,63,255,2,255,192,0,15,208,0,31,254,7,254,0,0,15,208,0,15,248,0,244,0,0,15,208,0,5,0,0,0,0,0,5,64,0,
  // 0x635f  损
  95,99,35,36,68,37,1,252,0,63,64,0,0,0,0,0,0,0,63,64,2,170,170,170,168,0,0,63,64,3,255,255,255,252,0,0,63,64,3,255,255,255,252,0,0,63,64,3,244,0,1,252,0,0,63,64,3,244,0,1,252,0,0,63,64,3,244,0,1,252,0,0,63,64,3,244,0,1,252,0,127,255,255,67,250,170,171,252,0,127,255,255,67,255,255,255,252,0,127,255,255,67,255,255,255,252,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,10,170,170,170,170,0,0,63,64,15,255,255,255,255,0,0,63,64,15,255,255,255,255,0,0,63,64,15,192,0,0,63,0,0,63,175,79,192,0,0,63,0,0,63,255,143,192,21,64,63,0,6,255,255,143,192,47,128,63,0,191,255,248,15,192,47,128,63,0,191,255,128,15,192,47,128,63,0,127,191,64,15,192,47,128,63,0,32,63,64,15,192,63,128,63,0,0,63,64,15,192,63,128,63,0,0,63,64,15,192,63,64,63,0,0,63,64,15,192,191,0,63,0,0,63,64,5,65,254,8,0,0,0,63,64,0,11,252,47,64,0,0,63,64,0,63,244,127,224,0,0,63,64,2,255,208,31,253,0,21,127,64,127,255,0,2,255,128,47,255,3,255,248,0,0,127,244,31,254,1,255,128,0,0,15,240,15,228,0,164,0,0,0,2,208,0,0,0,0,0,0,0,0,0,
  // 0x6362  换
  98,99,35,36,68,37,1,252,0,63,0,0,11,160,0,0,0,0,63,0,0,15,224,0,0,0,0,63,0,0,47,192,0,0,0,0,63,0,0,63,255,255,224,0,0,63,0,0,255,255,255,248,0,0,63,0,2,255,255,255,244,0,0,63,0,7,248,0,31,224,0,0,127,64,15,240,0,63,192,0,63,255,253,63,192,0,191,0,0,63,255,254,255,234,171,255,170,0,63,255,254,255,255,255,255,255,0,0,63,0,63,255,255,255,255,0,0,63,0,31,192,47,128,191,0,0,63,0,15,192,47,128,191,0,0,63,0,15,192,47,128,191,0,0,63,0,15,192,47,128,191,0,0,63,0,15,192,47,128,191,0,0,63,174,15,192,47,128,191,0,0,127,255,15,192,47,128,191,0,27,255,255,15,192,63,64,191,0,191,255,228,15,192,63,64,191,0,127,255,2,255,255,255,255,255,240,62,127,2,255,255,255,255,255,240,0,63,2,255,255,255,255,255,240,0,63,0,0,1,255,192,0,0,0,63,0,0,3,255,240,0,0,0,63,0,0,11,247,248,0,0,0,63,0,0,47,225,253,0,0,0,63,0,0,191,192,191,64,0,0,63,0,3,255,0,63,224,0,0,63,0,31,252,0,15,253,0,5,191,0,191,224,0,3,255,144,31,255,11,255,64,0,0,191,248,15,254,11,248,0,0,0,31,240,15,228,3,208,0,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x6389  掉
  137,99,35,36,68,37,1,252,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,255,255,240,0,63,64,0,0,63,255,255,240,0,63,64,0,0,63,255,255,240,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,127,255,255,0,0,63,64,0,0,127,255,255,63,255,255,255,255,0,127,255,255,63,255,255,255,255,0,0,63,64,63,234,170,170,255,0,0,63,64,63,64,0,0,63,0,0,63,64,63,64,0,0,63,0,0,63,64,63,170,170,170,191,0,0,63,64,63,255,255,255,255,0,0,63,91,63,255,255,255,255,0,0,63,255,63,64,0,0,63,0,1,191,255,63,64,0,0,63,0,111,255,255,63,64,0,0,63,0,127,255,208,63,234,170,170,191,0,63,255,64,63,255,255,255,255,0,57,63,64,63,255,255,255,255,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,67,255,255,255,255,255,244,0,63,67,255,255,255,255,255,244,0,63,67,255,255,255,255,255,244,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,127,64,0,0,63,64,0,0,63,255,0,0,0,63,64,0,0,63,255,0,0,0,63,64,0,0,47,248,0,0,0,63,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x63a2  探
  162,99,35,35,59,37,1,253,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,63,255,255,255,255,224,0,63,0,63,255,255,255,255,240,0,63,0,63,255,255,255,255,240,0,63,0,62,0,0,0,7,240,0,63,0,62,11,224,189,7,240,0,63,0,62,11,208,189,7,240,127,255,255,62,15,208,189,3,224,127,255,255,0,15,192,189,0,0,127,255,255,0,31,192,189,0,128,0,63,0,0,63,128,189,1,244,0,63,0,0,255,0,190,1,244,0,63,0,7,254,0,191,171,240,0,63,0,191,248,0,127,255,240,0,63,0,63,208,21,95,255,192,0,63,26,41,0,47,128,0,0,0,63,254,0,0,47,128,0,0,1,191,255,0,0,47,128,0,0,111,255,254,0,0,47,128,0,0,191,255,144,191,255,255,255,255,240,127,255,0,191,255,255,255,255,240,56,63,0,191,255,255,255,255,240,0,63,0,0,3,255,252,0,0,0,63,0,0,15,255,255,0,0,0,63,0,0,47,255,255,128,0,0,63,0,0,191,111,159,224,0,0,63,0,2,254,47,135,248,0,0,63,0,11,252,47,130,254,0,0,63,0,127,240,47,128,255,208,0,63,2,255,192,47,128,63,248,0,127,7,254,0,47,128,15,244,47,255,1,244,0,47,128,2,208,31,254,0,64,0,47,128,0,0,15,228,0,0,0,47,128,0,0,
  // 0x63a5  接
  165,99,35,36,68,37,1,252,0,31,128,0,0,47,192,0,0,0,47,192,0,0,47,192,0,0,0,47,192,0,0,47,192,0,0,0,47,192,0,0,47,192,0,0,0,47,192,63,255,255,255,255,208,0,47,192,63,255,255,255,255,208,0,47,192,63,255,255,255,255,208,0,47,192,0,190,0,7,240,0,63,255,255,0,127,0,11,224,0,63,255,255,0,63,0,15,208,0,63,255,255,0,63,64,15,192,0,0,47,192,0,47,128,47,128,0,0,47,192,0,47,128,63,64,0,0,47,193,255,255,255,255,255,244,0,47,193,255,255,255,255,255,244,0,47,193,255,255,255,255,255,244,0,47,192,0,2,252,0,0,0,0,47,239,0,3,244,0,0,0,0,127,255,0,11,240,0,0,0,111,255,255,255,255,255,255,255,244,191,255,229,255,255,255,255,255,244,191,255,192,255,255,255,255,255,244,125,47,192,0,127,0,11,240,0,0,47,192,0,254,0,15,224,0,0,47,192,1,252,0,31,192,0,0,47,192,3,252,0,63,192,0,0,47,192,7,255,208,127,64,0,0,47,192,15,255,255,255,0,0,0,47,192,1,203,255,253,0,0,0,47,192,0,0,127,255,128,0,0,47,192,0,6,255,255,248,0,5,127,128,5,191,254,47,255,64,31,255,131,255,255,228,2,255,208,15,255,2,255,253,0,0,47,192,15,248,0,249,64,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x63a7  控
  167,99,35,35,59,37,1,253,0,63,0,0,0,47,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,255,255,255,255,255,240,0,63,0,255,255,255,255,255,240,0,63,0,255,255,255,255,255,240,0,63,0,252,11,208,189,3,240,127,255,254,252,15,208,189,3,240,127,255,254,252,15,192,189,3,240,127,255,254,252,15,192,189,0,0,0,63,0,0,47,192,189,1,0,0,63,0,0,63,128,189,2,240,0,63,0,0,191,0,190,2,240,0,63,0,7,253,0,191,255,240,0,63,25,191,248,0,127,255,224,0,63,254,127,208,0,31,255,128,0,191,255,61,0,0,0,0,0,31,255,253,0,0,0,0,0,0,191,255,128,0,0,0,0,0,0,191,255,0,31,255,255,255,255,128,125,63,0,31,255,255,255,255,128,0,63,0,31,255,255,255,255,128,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,127,3,255,255,255,255,255,244,47,255,3,255,255,255,255,255,244,31,254,3,255,255,255,255,255,244,15,228,0,0,0,0,0,0,0,
  // 0x63d0  提
  208,99,35,35,59,37,1,253,0,42,0,0,0,0,0,0,0,0,63,0,6,170,170,170,169,0,0,63,0,15,255,255,255,255,0,0,63,0,15,255,255,255,255,0,0,63,0,15,208,0,0,127,0,0,63,0,15,208,0,0,127,0,0,63,0,15,229,85,85,191,0,127,255,255,15,255,255,255,255,0,127,255,255,15,255,255,255,255,0,127,255,255,15,208,0,0,127,0,0,127,0,15,208,0,0,127,0,0,63,0,15,234,170,170,191,0,0,63,0,15,255,255,255,255,0,0,63,0,15,255,255,255,255,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,5,127,255,255,255,255,224,0,63,254,191,255,255,255,255,240,1,191,255,191,255,255,255,255,240,127,255,254,0,0,47,128,0,0,191,255,144,1,64,47,128,0,0,127,255,0,7,224,47,128,0,0,56,63,0,11,224,47,128,0,0,0,63,0,15,208,47,255,255,0,0,63,0,15,192,47,255,255,0,0,63,0,31,208,47,234,170,0,0,63,0,47,240,47,128,0,0,0,63,0,63,248,47,128,0,0,0,63,0,191,189,47,128,0,0,0,63,0,253,63,191,128,0,0,0,63,2,252,31,255,128,0,0,63,255,11,244,7,255,255,255,248,47,254,31,224,0,255,255,255,244,31,244,7,192,0,6,255,255,240,0,0,0,0,0,0,0,0,0,
  // 0x63d2  插
  210,99,34,35,59,37,1,253,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,5,190,0,0,63,0,0,86,175,255,255,64,0,63,0,63,255,255,255,255,128,0,63,0,63,255,255,250,80,0,0,63,0,26,165,111,128,0,0,0,63,0,0,0,47,128,0,0,0,63,0,0,0,47,128,0,0,127,255,255,0,0,47,128,0,0,127,255,255,255,255,255,255,255,240,127,255,255,255,255,255,255,255,240,0,63,0,255,255,255,255,255,240,0,63,0,0,0,47,128,0,0,0,63,0,0,0,47,128,0,0,0,63,0,0,31,47,128,0,0,0,63,0,57,255,255,143,255,208,0,63,110,63,255,191,143,255,208,0,63,254,63,244,47,143,255,208,11,255,255,63,0,47,128,15,208,191,255,248,63,0,47,128,15,208,191,255,64,63,0,47,128,15,208,127,191,0,63,0,47,128,15,208,16,63,0,63,255,47,143,255,208,0,63,0,63,255,47,143,255,208,0,63,0,63,255,47,143,255,208,0,63,0,63,0,47,128,15,208,0,63,0,63,0,47,128,15,208,0,63,0,63,0,47,128,15,208,0,63,0,63,0,47,128,15,208,0,63,0,63,0,47,128,15,208,0,63,0,63,255,255,255,255,208,0,127,0,63,255,255,255,255,208,47,255,0,63,255,255,255,255,208,31,254,0,63,0,0,0,15,208,15,228,0,63,0,0,0,11,192,
  // 0x6536  收
  54,101,35,36,68,37,1,252,0,0,10,144,1,228,0,0,0,0,0,15,208,2,252,0,0,0,0,0,15,208,3,252,0,0,0,0,0,15,208,3,248,0,0,0,1,80,15,208,7,240,0,0,0,7,240,15,208,11,240,0,0,0,7,240,15,208,15,224,0,0,0,7,240,15,208,31,255,255,255,248,7,240,15,208,63,255,255,255,248,7,240,15,208,63,255,255,255,248,7,240,15,208,191,213,85,127,144,7,240,15,208,255,192,0,127,0,7,240,15,210,255,192,0,191,0,7,240,15,215,255,208,0,254,0,7,240,15,239,255,240,0,253,0,7,240,15,255,231,240,1,252,0,7,240,15,239,195,244,3,252,0,7,240,15,215,66,252,3,244,0,7,240,15,208,1,252,11,240,0,7,240,15,208,0,254,15,224,0,7,240,15,208,0,191,47,208,0,7,240,15,208,0,63,191,192,0,7,246,255,208,0,47,255,64,0,11,255,255,208,0,15,254,0,0,191,255,255,208,0,11,252,0,0,127,255,79,208,0,15,252,0,0,63,144,15,208,0,63,255,0,0,20,0,15,208,0,191,255,128,0,0,0,15,208,3,255,127,224,0,0,0,15,208,31,252,15,252,0,0,0,15,208,191,240,7,255,64,0,0,15,235,255,192,1,255,244,0,0,15,223,254,0,0,127,248,0,0,15,215,240,0,0,11,224,0,0,15,210,64,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x653e  放
  62,101,35,36,68,37,1,252,0,3,244,0,0,58,0,0,0,0,3,244,0,0,63,64,0,0,0,3,244,0,0,127,0,0,0,0,3,244,0,0,191,0,0,0,0,3,244,0,0,255,0,0,0,0,3,244,0,0,254,0,0,0,127,255,255,255,193,253,0,0,0,127,255,255,255,194,255,255,255,248,127,255,255,255,195,255,255,255,248,0,127,0,0,3,255,255,255,248,0,63,0,0,11,244,0,191,0,0,63,0,0,15,244,0,254,0,0,63,0,0,31,248,0,253,0,0,63,0,0,63,252,0,252,0,0,63,255,254,127,252,1,252,0,0,63,255,254,255,253,2,252,0,0,63,255,255,254,190,3,248,0,0,127,0,254,252,127,7,244,0,0,127,0,253,40,63,75,240,0,0,127,0,253,0,63,143,224,0,0,127,0,253,0,31,223,208,0,0,127,0,253,0,15,255,192,0,0,190,0,253,0,11,255,64,0,0,254,0,253,0,7,255,0,0,0,253,0,252,0,3,254,0,0,0,252,0,252,0,3,254,0,0,2,252,0,252,0,15,255,64,0,3,248,0,252,0,47,255,192,0,7,244,0,252,0,191,239,240,0,15,240,1,252,2,255,15,252,0,31,224,2,252,31,252,3,255,64,63,192,3,248,191,240,0,255,224,255,67,255,251,255,192,0,127,244,126,1,255,241,254,0,0,15,224,12,1,255,128,240,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x6570  数
  112,101,35,36,68,37,1,252,0,0,253,0,0,14,128,0,0,2,128,253,7,128,31,208,0,0,15,208,253,15,224,31,192,0,0,7,240,253,31,192,47,192,0,0,3,244,253,63,64,63,128,0,0,1,248,253,126,0,63,64,0,0,0,208,253,24,0,127,64,0,0,63,255,255,255,248,191,255,255,244,63,255,255,255,248,255,255,255,244,63,255,255,255,244,255,255,255,244,0,7,255,128,2,253,85,127,80,0,31,255,244,3,253,0,127,0,0,191,254,255,7,254,0,191,0,2,253,253,63,223,255,0,254,0,31,244,253,15,223,255,0,254,0,127,208,253,2,127,255,64,253,0,47,0,253,0,191,175,129,252,0,4,3,248,0,127,31,195,252,0,0,7,240,0,29,15,195,248,0,0,15,224,0,4,15,231,244,0,191,255,255,255,248,11,255,240,0,191,255,255,255,248,3,255,224,0,127,255,255,255,248,3,255,192,0,0,254,0,253,0,1,255,128,0,1,252,0,252,0,0,255,0,0,3,252,2,252,0,2,255,64,0,11,255,131,244,0,7,255,192,0,15,255,255,240,0,31,255,224,0,2,139,255,224,0,127,239,248,0,0,1,255,248,1,255,131,254,0,0,11,255,255,11,254,1,255,128,6,255,249,255,255,252,0,191,244,63,255,208,63,255,224,0,47,244,47,249,0,10,63,64,0,7,208,14,64,0,0,40,0,0,0,128,0,0,0,0,0,0,0,0,0,
  // 0x6572  敲
  114,101,35,36,68,37,1,252,0,0,252,0,0,3,244,0,0,0,0,252,0,0,3,244,0,0,0,0,252,0,0,3,244,0,0,0,0,252,0,0,3,244,0,0,63,255,255,255,244,3,244,0,0,127,255,255,255,244,3,255,255,240,127,255,255,255,244,3,255,255,240,0,0,0,0,0,3,255,255,240,0,85,85,84,0,3,244,0,0,1,255,255,253,0,3,244,0,0,1,255,255,253,0,3,244,0,0,1,248,0,189,0,3,244,0,0,1,248,0,189,0,3,244,0,0,1,248,0,189,31,255,255,255,192,1,255,255,253,31,255,255,255,192,1,255,255,253,31,255,255,255,192,0,85,85,84,0,96,0,63,128,0,0,0,0,2,248,0,63,64,10,170,170,170,129,252,0,127,0,31,255,255,255,208,253,0,255,0,31,255,255,255,208,190,0,253,0,31,64,0,7,208,63,2,252,0,31,64,0,7,208,63,131,248,0,31,79,255,199,208,31,203,240,0,31,79,255,199,208,15,255,224,0,31,79,3,199,208,7,255,192,0,31,79,3,199,208,2,255,64,0,31,79,3,199,208,2,255,64,0,31,79,255,199,208,15,255,208,0,31,79,255,199,208,63,255,248,0,31,79,0,7,209,255,203,255,0,31,79,0,7,239,255,66,255,224,31,64,1,91,255,252,0,191,248,31,64,1,255,223,224,0,31,240,31,64,0,255,71,64,0,2,192,0,0,0,0,0,0,0,0,0,
  // 0x6574  整
  116,101,34,34,50,37,2,254,0,2,240,0,0,41,0,0,0,0,3,240,0,0,63,64,0,0,85,87,245,85,64,127,0,0,0,255,255,255,255,192,254,0,0,0,255,255,255,255,193,255,170,170,128,0,3,240,0,3,255,255,255,192,63,255,255,255,75,255,255,255,192,63,255,255,255,111,240,3,244,0,63,3,244,47,255,252,3,240,0,63,3,240,31,255,189,11,224,0,63,3,240,31,108,63,31,192,0,63,255,255,255,68,31,255,128,0,63,255,255,255,64,15,255,0,0,0,47,254,0,0,7,253,0,0,0,191,255,208,0,31,255,64,0,2,255,255,253,0,191,255,224,0,31,243,241,255,75,255,95,254,0,255,195,240,46,191,252,3,255,208,190,3,240,4,127,208,0,191,192,52,3,240,0,45,0,0,11,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,10,170,170,175,254,170,170,168,0,0,0,0,3,240,0,0,0,0,0,31,192,3,240,0,0,0,0,0,31,192,3,255,255,255,64,0,0,31,192,3,255,255,255,64,0,0,31,192,3,250,170,170,0,0,0,31,192,3,240,0,0,0,0,0,31,192,3,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x6599  料
  153,101,35,35,59,37,1,253,0,6,160,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,4,7,224,16,0,0,3,240,0,62,7,224,126,3,192,3,240,0,47,7,224,189,15,244,3,240,0,31,7,224,252,7,254,3,240,0,15,135,224,248,0,255,131,240,0,15,199,225,244,0,47,195,240,0,11,199,226,240,0,11,131,240,0,11,199,227,224,0,2,3,240,0,7,215,227,208,0,0,3,240,0,2,71,226,192,0,0,3,240,0,0,11,240,0,20,0,3,240,0,63,255,255,253,62,0,3,240,0,63,255,255,253,191,208,3,240,0,63,255,255,253,47,248,3,240,0,0,47,240,0,7,254,3,240,0,0,63,248,0,0,188,3,240,0,0,127,253,0,0,40,3,240,0,0,255,255,0,0,0,3,240,0,1,255,255,192,0,0,3,240,80,2,251,235,224,0,0,7,255,244,3,231,227,248,0,22,255,255,248,11,215,225,252,107,255,255,255,244,31,199,224,246,255,255,255,244,0,63,135,224,97,255,254,151,240,0,191,7,224,0,249,64,3,240,0,190,7,224,0,0,0,3,240,0,60,7,224,0,0,0,3,240,0,36,7,224,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,0,7,224,0,0,0,3,240,0,
  // 0x659c  斜
  156,101,35,35,59,37,1,253,0,1,254,0,0,0,0,252,0,0,3,255,128,0,0,0,252,0,0,7,255,224,0,0,0,252,0,0,15,255,252,0,60,0,252,0,0,31,211,255,0,255,0,252,0,0,63,192,255,192,127,192,252,0,0,255,0,63,224,31,240,252,0,2,253,0,31,244,7,253,252,0,11,248,0,7,224,1,253,252,0,47,240,0,2,128,0,160,252,0,191,255,255,255,0,0,0,252,0,255,255,255,255,0,0,0,252,0,61,255,255,255,0,208,0,252,0,0,0,190,0,3,248,0,252,0,0,0,190,0,3,255,0,252,0,0,0,190,0,0,255,192,252,0,0,0,190,0,0,47,240,252,0,63,255,255,255,240,11,244,252,0,63,255,255,255,240,2,208,252,0,63,255,255,255,240,0,0,252,0,0,0,190,0,0,0,0,252,16,0,0,190,0,0,0,1,255,244,2,224,190,47,0,1,111,255,248,3,240,190,47,65,191,255,255,248,7,240,190,31,207,255,255,253,0,11,224,190,15,219,255,229,252,0,15,192,190,7,247,228,0,252,0,31,192,190,3,240,0,0,252,0,63,64,190,2,244,0,0,252,0,191,0,190,1,244,0,0,252,0,61,0,190,0,0,0,0,252,0,4,0,190,0,0,0,0,252,0,0,127,253,0,0,0,0,252,0,0,63,252,0,0,0,0,252,0,0,47,224,0,0,0,0,252,0,
  // 0x65ad  断
  173,101,33,36,68,37,3,252,0,0,41,0,0,0,0,0,0,168,0,126,0,0,0,1,244,0,252,0,126,0,0,0,111,253,0,252,180,126,31,72,31,255,254,0,252,184,126,47,15,255,255,144,0,252,124,126,63,15,255,228,0,0,252,61,126,61,15,228,0,0,0,252,62,126,124,15,192,0,0,0,252,62,126,184,15,192,0,0,0,252,45,126,176,15,192,0,0,0,252,0,126,0,15,192,0,0,0,252,255,255,255,79,192,0,0,0,253,255,255,255,79,192,0,0,0,253,255,255,255,79,255,255,255,128,252,0,254,0,15,255,255,255,128,252,1,255,0,15,255,255,255,128,252,3,255,192,15,192,31,192,0,252,7,255,240,31,192,31,192,0,252,15,255,252,31,192,31,192,0,252,47,254,191,31,192,31,192,0,252,127,126,63,31,192,31,192,0,252,253,126,12,31,192,31,192,0,255,248,126,0,47,128,31,192,0,253,240,126,0,63,64,31,192,0,252,192,126,0,63,64,31,192,0,252,0,126,0,63,0,31,192,0,252,0,126,0,127,0,31,192,0,252,0,0,0,254,0,31,192,0,255,255,255,255,253,0,31,192,0,255,255,255,255,252,0,31,192,0,255,255,255,255,248,0,31,192,0,252,0,0,15,240,0,31,192,0,252,0,0,47,208,0,31,192,0,168,0,0,15,192,0,31,192,0,0,0,0,3,0,0,31,192,0,0,0,0,0,0,0,0,0,0,
  // 0x65b0  新
  176,101,35,36,68,37,1,252,0,0,168,0,0,0,0,1,0,0,0,252,0,0,0,0,111,64,0,0,252,0,0,0,27,255,208,0,0,252,0,2,70,255,255,208,47,255,255,255,227,255,255,244,0,47,255,255,255,227,255,249,0,0,47,255,255,255,227,249,0,0,0,1,244,0,189,3,244,0,0,0,1,248,0,253,3,244,0,0,0,0,252,1,252,3,244,0,0,0,0,189,2,244,3,244,0,0,0,0,125,2,240,3,244,0,0,0,63,255,255,255,243,248,0,0,0,63,255,255,255,243,255,255,255,244,63,255,255,255,243,255,255,255,244,0,0,252,0,3,255,255,255,244,0,0,252,0,3,244,2,248,0,0,0,252,0,3,244,2,248,0,0,0,252,0,3,244,2,248,0,63,255,255,255,227,244,2,248,0,63,255,255,255,227,244,2,248,0,63,255,255,255,227,240,2,248,0,0,3,252,0,3,240,2,248,0,0,15,255,64,7,240,2,248,0,0,47,255,224,11,224,2,248,0,0,127,255,248,15,224,2,248,0,0,254,253,255,15,208,2,248,0,3,248,252,127,95,192,2,248,0,31,240,252,30,63,128,2,248,0,127,192,252,4,127,64,2,248,0,127,64,252,0,255,0,2,248,0,29,0,252,2,253,0,2,248,0,0,0,252,7,248,0,2,248,0,0,0,252,2,240,0,2,248,0,0,0,252,0,128,0,2,164,0,0,0,0,0,0,0,0,0,0,
  // 0x65b9  方
  185,101,33,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,85,85,85,91,245,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,11,255,255,255,255,128,0,0,0,15,255,255,255,255,128,0,0,0,15,255,255,255,255,128,0,0,0,15,224,0,0,63,64,0,0,0,31,208,0,0,63,64,0,0,0,63,192,0,0,63,64,0,0,0,63,192,0,0,127,0,0,0,0,191,64,0,0,127,0,0,0,0,255,0,0,0,127,0,0,0,2,254,0,0,0,191,0,0,0,7,252,0,0,0,191,0,0,0,15,248,0,0,0,254,0,0,0,63,240,0,0,0,254,0,0,0,255,208,0,0,1,253,0,0,3,255,64,0,0,2,252,0,0,47,253,0,1,64,7,252,0,0,255,244,0,2,255,255,244,0,0,127,192,0,1,255,255,240,0,0,45,0,0,0,255,255,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x65e0  无
  224,101,34,32,32,37,2,253,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,31,208,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,47,192,0,0,0,0,0,0,0,63,149,0,0,0,0,0,0,0,63,191,64,0,0,0,0,0,0,191,127,64,0,0,0,0,0,0,255,63,64,0,0,0,0,0,1,254,63,64,0,0,0,0,0,3,252,63,64,0,0,0,0,0,7,248,63,64,0,0,0,0,0,15,240,63,64,0,4,0,0,0,63,208,63,64,0,11,128,0,0,255,192,63,64,0,15,224,0,7,255,0,63,64,0,15,208,0,63,252,0,63,64,0,15,208,2,255,240,0,63,128,0,47,192,127,255,128,0,63,255,255,255,192,255,252,0,0,47,255,255,255,64,63,208,0,0,11,255,255,254,0,40,0,0,0,0,85,85,80,0,
  // 0x65f6  时
  246,101,33,35,59,37,3,253,0,0,0,0,0,0,42,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,255,255,255,0,0,0,63,64,0,255,255,255,0,0,0,63,64,0,255,255,255,0,0,0,63,64,0,253,0,127,0,0,0,63,64,0,252,0,127,5,85,85,127,149,0,252,0,127,47,255,255,255,255,128,252,0,127,47,255,255,255,255,128,252,0,127,47,255,255,255,255,128,252,0,127,0,0,0,63,64,0,252,0,127,0,0,0,63,64,0,252,0,127,0,0,0,63,64,0,255,255,255,1,224,0,63,64,0,255,255,255,7,244,0,63,64,0,255,255,255,3,252,0,63,64,0,252,0,127,1,254,0,63,64,0,252,0,127,0,191,64,63,64,0,252,0,127,0,63,192,63,64,0,252,0,127,0,31,224,63,64,0,252,0,127,0,15,240,63,64,0,252,0,127,0,3,244,63,64,0,252,0,127,0,2,192,63,64,0,252,0,127,0,0,0,63,64,0,255,255,255,0,0,0,63,64,0,255,255,255,0,0,0,63,64,0,255,255,255,0,0,0,63,64,0,252,0,0,0,0,0,63,64,0,252,0,0,0,0,0,63,64,0,252,0,0,0,0,0,127,64,0,0,0,0,0,15,255,255,0,0,0,0,0,0,11,255,255,0,0,0,0,0,0,7,255,248,0,0,0,0,0,0,1,85,0,0,0,
  // 0x660e  明
  14,102,32,34,16,37,3,252,255,255,255,66,255,255,255,253,255,255,255,66,255,255,255,253,255,255,255,66,255,255,255,253,253,0,63,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,66,252,0,0,253,252,0,63,66,255,255,255,253,255,255,255,66,255,255,255,253,255,255,255,66,255,255,255,253,255,255,255,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,66,248,0,0,253,252,0,63,67,248,0,0,253,252,0,63,67,248,0,0,253,252,0,63,67,248,0,0,253,252,0,63,67,255,255,255,253,253,0,63,67,255,255,255,253,255,255,255,71,255,255,255,253,255,255,255,75,240,0,0,253,255,255,255,79,224,0,0,253,252,0,0,15,208,0,0,253,252,0,0,47,192,0,0,253,252,0,0,63,128,0,0,253,84,0,0,191,64,0,0,253,0,0,0,255,0,0,0,253,0,0,3,253,0,0,0,253,0,0,15,248,0,5,86,253,0,0,63,240,0,11,255,252,0,0,47,192,0,7,255,248,0,0,11,0,0,3,255,144,0,0,0,0,0,0,0,0,
  // 0x662f  是
  47,102,35,34,50,37,1,253,0,42,170,170,170,170,170,144,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,64,0,0,0,11,240,0,0,63,64,0,0,0,11,240,0,0,63,149,85,85,85,95,240,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,64,0,0,0,11,240,0,0,63,64,0,0,0,11,240,0,0,63,170,170,170,170,175,240,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,0,0,0,0,254,0,0,0,0,0,2,148,0,254,0,0,0,0,0,3,248,0,254,0,0,0,0,0,7,244,0,254,0,0,0,0,0,11,240,0,255,255,255,253,0,0,15,240,0,255,255,255,253,0,0,31,244,0,255,255,255,253,0,0,47,252,0,254,0,0,0,0,0,63,255,0,254,0,0,0,0,0,255,191,128,254,0,0,0,0,2,254,47,244,254,0,0,0,0,7,252,15,255,254,0,0,0,0,31,244,2,255,255,255,255,255,244,127,224,0,127,255,255,255,255,240,47,64,0,1,191,255,255,255,224,9,0,0,0,0,0,0,0,0,
  // 0x6682  暂
  130,102,33,35,59,37,2,253,0,10,64,0,0,0,0,4,0,0,31,224,0,0,0,26,253,0,170,191,234,170,130,191,255,255,0,255,255,255,255,195,255,255,249,0,255,255,255,255,195,254,148,0,0,2,252,0,0,3,240,0,0,0,3,240,41,0,3,240,0,0,0,15,224,127,0,3,240,0,0,0,47,192,127,0,3,250,170,170,128,191,255,255,255,211,255,255,255,192,63,255,255,255,215,255,255,255,192,63,170,255,170,135,224,15,192,0,0,0,127,0,11,224,15,192,0,0,0,127,0,75,208,15,192,0,0,21,191,255,207,192,15,192,0,255,255,255,255,223,192,15,192,0,255,255,255,165,47,128,15,192,0,186,148,127,0,127,64,15,192,0,0,0,127,0,191,0,15,192,0,0,0,127,0,29,0,15,192,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,128,0,0,191,255,255,255,255,255,128,0,0,191,170,170,170,170,191,128,0,0,190,0,0,0,0,47,128,0,0,190,0,0,0,0,47,128,0,0,191,255,255,255,255,255,128,0,0,191,255,255,255,255,255,128,0,0,191,85,85,85,85,127,128,0,0,190,0,0,0,0,47,128,0,0,190,0,0,0,0,47,128,0,0,191,255,255,255,255,255,128,0,0,191,255,255,255,255,255,128,0,0,191,170,170,170,170,191,128,0,0,190,0,0,0,0,47,128,0,
  // 0x66ab  暫
  171,102,33,35,59,37,2,253,0,3,240,0,0,0,0,96,0,0,3,240,0,0,0,27,252,0,191,255,255,255,203,175,255,254,0,191,255,255,255,203,255,255,144,0,0,3,244,0,11,254,144,0,0,0,3,240,0,11,208,0,0,0,47,255,255,255,11,208,0,0,0,47,171,250,191,11,208,0,0,0,47,3,240,47,15,250,170,170,128,47,255,255,255,15,255,255,255,192,47,171,250,191,15,255,255,255,192,47,3,240,47,15,192,31,192,0,47,171,250,191,15,192,31,192,0,47,255,255,255,47,128,31,192,0,0,3,240,0,63,64,31,192,0,255,255,255,255,255,0,31,192,0,255,255,255,255,253,0,31,192,0,0,3,240,3,252,0,31,192,0,0,3,240,1,240,0,31,192,0,0,1,80,0,64,0,6,64,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,234,170,170,170,255,0,0,0,63,64,0,0,0,191,0,0,0,63,64,0,0,0,191,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,149,85,85,85,191,0,0,0,63,64,0,0,0,191,0,0,0,63,64,0,0,0,191,0,0,0,63,255,255,255,255,255,0,0,0,63,255,255,255,255,255,0,0,0,63,234,170,170,170,255,0,0,0,63,64,0,0,0,127,0,0,
  // 0x66f4  更
  244,102,34,33,41,37,2,253,127,255,255,255,255,255,255,255,128,127,255,255,255,255,255,255,255,128,127,255,255,255,255,255,255,255,128,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,252,0,3,248,0,3,240,0,0,252,0,3,248,0,3,240,0,0,252,0,3,248,0,3,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,254,170,171,254,170,171,240,0,0,252,0,3,248,0,3,240,0,0,252,0,3,248,0,3,240,0,0,252,0,3,248,0,3,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,11,0,15,240,0,0,0,0,0,63,192,31,208,0,0,0,0,0,31,240,63,192,0,0,0,0,0,11,253,191,128,0,0,0,0,0,2,255,255,0,0,0,0,0,0,0,191,253,0,0,0,0,0,0,1,255,255,228,0,0,0,0,0,111,255,255,255,249,84,0,0,175,255,253,31,255,255,255,255,224,191,255,144,0,191,255,255,255,192,63,244,0,0,0,107,255,255,128,9,0,0,0,0,0,0,21,0,
  // 0x6700  最
  0,103,33,34,50,37,2,253,0,127,255,255,255,255,255,128,0,0,127,255,255,255,255,255,128,0,0,127,85,85,85,85,127,128,0,0,127,0,0,0,0,63,128,0,0,127,0,0,0,0,63,128,0,0,127,255,255,255,255,255,128,0,0,127,255,255,255,255,255,128,0,0,127,0,0,0,0,63,128,0,0,127,0,0,0,0,63,128,0,0,127,255,255,255,255,255,128,0,0,127,255,255,255,255,255,128,0,0,21,85,85,85,85,85,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,2,244,0,190,0,0,0,0,0,2,244,0,190,0,0,0,0,0,2,249,85,254,42,170,170,164,0,2,255,255,254,127,255,255,253,0,2,255,255,254,127,255,255,252,0,2,244,0,190,7,192,3,248,0,2,244,0,190,11,224,7,240,0,2,255,255,254,3,244,15,224,0,2,255,255,254,2,252,63,192,0,2,249,85,254,0,255,191,64,0,2,244,0,190,0,63,254,0,0,2,244,0,254,0,47,252,0,0,3,255,255,254,0,63,253,0,0,255,255,255,254,2,255,255,192,0,255,255,255,254,111,253,127,253,0,254,148,0,191,255,224,11,255,192,0,0,0,190,127,64,1,191,64,0,0,0,189,32,0,0,6,0,
  // 0x6709  有
  9,103,33,36,68,37,2,252,0,0,0,228,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,63,128,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,7,255,255,255,255,255,64,0,0,15,255,255,255,255,255,64,0,0,63,255,255,255,255,255,64,0,0,255,248,0,0,0,63,64,0,2,255,248,0,0,0,63,64,0,11,255,248,0,0,0,63,64,0,63,243,255,255,255,255,255,64,0,255,211,255,255,255,255,255,64,0,255,67,255,255,255,255,255,64,0,60,3,248,0,0,0,63,64,0,16,3,248,0,0,0,63,64,0,0,3,248,0,0,0,63,64,0,0,3,248,0,0,0,63,64,0,0,3,255,255,255,255,255,64,0,0,3,255,255,255,255,255,64,0,0,3,255,255,255,255,255,64,0,0,3,248,0,0,0,63,64,0,0,3,248,0,0,0,63,64,0,0,3,248,0,0,0,63,64,0,0,3,248,0,0,80,127,64,0,0,3,248,0,1,255,255,64,0,0,3,248,0,0,255,255,0,0,0,3,248,0,0,255,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x671f  期
  31,103,34,35,59,37,1,252,0,252,0,63,0,0,0,0,0,0,252,0,63,0,255,255,255,208,0,252,0,63,0,255,255,255,208,0,252,0,63,0,255,255,255,208,63,255,255,255,248,253,0,15,208,63,255,255,255,248,253,0,15,208,63,255,255,255,248,253,0,15,208,0,252,0,63,0,253,0,15,208,0,252,0,63,0,253,0,15,208,0,252,0,63,0,255,255,255,208,0,255,255,255,0,255,255,255,208,0,255,255,255,0,255,255,255,208,0,254,170,255,0,253,0,15,208,0,252,0,63,0,253,0,15,208,0,252,0,63,0,253,0,15,208,0,252,0,63,0,253,0,15,208,0,255,255,255,0,253,0,15,208,0,255,255,255,0,253,0,15,208,0,254,170,255,0,255,255,255,208,0,252,0,63,0,255,255,255,208,0,252,0,63,0,255,255,255,208,0,252,0,63,0,252,0,15,208,127,255,255,255,248,252,0,15,208,127,255,255,255,249,252,0,15,208,127,255,255,255,250,252,0,15,208,0,0,0,0,3,248,0,15,208,0,63,65,240,3,244,0,15,208,0,191,3,252,3,240,0,15,208,1,253,0,254,11,240,0,15,208,7,252,0,127,79,224,0,15,208,15,240,0,47,223,208,0,31,208,63,208,0,15,127,192,47,255,192,47,128,0,4,31,128,15,255,128,6,0,0,0,3,0,15,253,0,0,0,0,0,0,0,0,0,0,
  // 0x673a  机
  58,103,35,35,59,37,1,253,0,3,240,0,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,3,240,0,63,255,255,240,0,0,3,240,0,63,255,255,240,0,0,3,240,0,63,255,255,240,0,0,3,240,0,63,149,91,240,0,0,3,240,0,63,128,7,240,0,0,3,240,0,63,128,7,240,0,63,255,255,252,63,128,7,240,0,63,255,255,252,63,128,7,240,0,63,255,255,252,63,128,7,240,0,21,95,245,84,63,128,7,240,0,0,15,240,0,63,128,7,240,0,0,31,240,0,63,128,7,240,0,0,47,244,0,63,128,7,240,0,0,63,253,0,63,128,7,240,0,0,127,255,64,63,128,7,240,0,0,255,255,192,63,64,7,240,0,0,251,251,240,63,64,7,240,0,2,247,243,252,63,64,7,240,0,7,227,240,253,63,0,7,240,0,15,211,240,184,127,0,7,240,0,31,195,240,48,127,0,7,240,0,63,67,240,0,190,0,7,240,0,191,3,240,0,254,0,7,240,0,125,3,240,0,253,0,7,240,120,60,3,240,2,252,0,7,240,124,16,3,240,3,248,0,7,240,124,0,3,240,7,244,0,7,240,124,0,3,240,15,240,0,7,240,188,0,3,240,47,208,0,7,240,252,0,3,240,127,192,0,7,255,252,0,3,240,191,0,0,3,255,244,0,3,240,45,0,0,1,255,224,0,2,160,4,0,0,0,0,0,
  // 0x6740  杀
  64,103,33,35,59,37,2,253,0,0,0,0,0,0,56,0,0,0,52,0,0,0,1,255,0,0,0,255,128,0,0,11,255,0,0,1,255,253,0,0,63,248,0,0,0,31,255,208,2,255,208,0,0,0,1,191,254,31,254,0,0,0,0,0,11,255,255,244,0,0,0,0,0,0,191,255,192,0,0,0,0,0,1,255,255,244,0,0,0,0,0,47,255,255,255,64,0,0,0,6,255,253,7,255,244,0,0,1,191,255,144,0,127,255,0,0,47,255,248,0,0,11,255,224,0,63,255,128,0,0,0,191,224,0,31,228,0,3,244,0,15,192,0,5,0,0,3,244,0,1,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,7,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,3,208,3,244,1,208,0,0,0,11,244,3,244,11,248,0,0,0,47,224,3,244,3,254,0,0,0,127,192,3,244,0,255,128,0,1,255,0,3,244,0,63,224,0,11,253,0,3,244,0,15,248,0,47,244,0,3,244,0,3,254,0,255,208,0,3,244,0,0,255,64,191,64,5,91,244,0,0,127,64,45,0,11,255,244,0,0,40,0,0,0,7,255,240,0,0,0,0,0,0,3,254,64,0,0,0,0,
  // 0x675f  束
  95,103,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,244,0,0,0,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,244,0,0,0,0,2,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,2,248,0,7,240,0,11,240,0,2,248,0,7,240,0,11,240,0,2,248,0,7,240,0,11,240,0,2,248,0,7,240,0,11,240,0,2,248,0,7,240,0,11,240,0,2,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,0,0,0,191,255,128,0,0,0,0,0,2,255,255,224,0,0,0,0,0,11,255,255,248,0,0,0,0,0,63,247,247,255,0,0,0,0,1,255,199,240,255,208,0,0,0,11,255,7,240,47,248,0,0,0,191,248,7,240,11,255,128,0,7,255,208,7,240,1,255,248,0,191,254,0,7,240,0,63,255,128,255,244,0,7,240,0,7,255,192,63,128,0,7,240,0,0,191,0,24,0,0,7,240,0,0,9,0,0,0,0,7,240,0,0,0,0,
  // 0x6761  条
  97,103,34,35,59,37,2,253,0,0,2,248,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,63,255,255,255,224,0,0,0,0,255,255,255,255,252,0,0,0,7,255,255,255,255,244,0,0,0,31,254,0,0,47,224,0,0,0,191,255,64,0,191,192,0,0,11,255,191,208,1,255,0,0,0,63,253,15,248,11,253,0,0,0,31,224,3,255,127,240,0,0,0,7,64,0,255,255,192,0,0,0,0,0,0,63,255,64,0,0,0,0,0,1,255,255,248,0,0,0,0,0,111,255,255,255,208,0,0,0,27,255,253,11,255,255,228,0,111,255,255,208,0,127,255,255,192,127,255,248,2,160,2,255,255,64,63,254,64,7,240,0,6,255,0,30,64,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,0,0,2,255,255,224,0,0,0,0,0,11,255,255,248,0,0,0,0,0,63,231,242,255,0,0,0,0,1,255,135,240,191,224,0,0,0,15,254,7,240,47,253,0,0,0,191,244,7,240,7,255,208,0,27,255,192,7,240,0,255,254,0,255,253,0,7,240,0,31,255,208,191,224,0,7,240,0,2,255,64,62,0,0,7,240,0,0,31,0,0,0,0,7,240,0,0,0,0,
  // 0x6765  来
  101,103,35,35,59,37,1,253,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,1,85,85,86,254,85,85,85,0,3,255,255,255,255,255,255,255,64,3,255,255,255,255,255,255,255,64,3,255,255,255,255,255,255,255,64,0,0,64,1,253,0,5,0,0,0,11,208,1,253,0,15,224,0,0,15,240,1,253,0,31,224,0,0,7,244,1,253,0,63,192,0,0,3,252,1,253,0,127,64,0,0,1,253,1,253,0,255,0,0,0,0,255,1,253,1,253,0,0,0,0,189,1,253,2,248,0,0,21,85,101,86,254,85,117,85,80,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,0,0,0,63,255,240,0,0,0,0,0,0,255,255,252,0,0,0,0,0,2,254,254,254,0,0,0,0,0,11,249,253,191,128,0,0,0,0,47,225,253,47,224,0,0,0,0,255,193,253,15,252,0,0,0,3,255,1,253,3,255,0,0,0,47,252,1,253,0,255,208,0,0,255,240,1,253,0,63,252,0,11,255,128,1,253,0,11,255,128,127,253,0,1,253,0,1,255,244,63,240,0,1,253,0,0,63,240,15,64,0,1,253,0,0,7,192,0,0,0,1,253,0,0,0,64,0,0,0,1,253,0,0,0,0,
  // 0x677f  板
  127,103,35,36,68,37,1,252,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,1,255,255,255,255,240,0,15,208,1,255,255,255,255,240,0,15,208,1,255,255,255,255,240,0,15,208,1,252,0,0,0,0,0,15,208,1,252,0,0,0,0,0,15,208,1,252,0,0,0,0,63,255,255,241,252,0,0,0,0,63,255,255,241,252,0,0,0,0,63,255,255,241,252,0,0,0,0,0,31,224,1,252,0,0,0,0,0,47,208,1,255,255,255,255,208,0,63,208,1,255,255,255,255,208,0,63,240,1,255,255,255,255,192,0,127,248,1,255,240,0,47,192,0,255,253,1,255,240,0,63,128,0,255,255,1,254,248,0,63,64,1,255,255,194,253,252,0,127,0,3,255,223,226,248,253,0,254,0,7,223,211,242,248,191,0,253,0,15,207,210,227,248,63,66,252,0,31,143,208,195,244,63,199,244,0,63,79,208,3,240,15,223,240,0,191,15,208,7,240,11,255,208,0,189,15,208,11,240,3,255,192,0,60,15,208,15,224,2,255,64,0,16,15,208,15,208,2,255,64,0,0,15,208,47,192,15,255,208,0,0,15,208,63,128,63,255,248,0,0,15,208,191,65,255,199,255,0,0,15,208,255,15,255,1,255,224,0,15,210,252,47,248,0,127,244,0,15,208,184,15,208,0,11,224,0,11,208,32,2,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x6797  林
  151,103,35,35,59,37,1,253,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,63,255,255,254,63,255,255,255,224,63,255,255,254,63,255,255,255,224,63,255,255,254,63,255,255,255,224,5,91,253,84,5,87,255,85,64,0,11,252,0,0,11,255,0,0,0,15,255,0,0,15,255,128,0,0,31,255,192,0,31,255,192,0,0,47,255,240,0,47,255,192,0,0,63,255,248,0,63,255,224,0,0,127,249,254,0,191,255,240,0,0,254,248,255,64,254,254,244,0,1,250,248,63,2,249,253,252,0,3,242,248,29,3,245,252,253,0,11,242,248,4,15,241,252,127,0,15,210,248,0,31,209,252,63,128,63,194,248,0,63,193,252,47,192,191,66,248,0,255,1,252,15,240,127,2,248,3,254,1,252,11,248,60,2,248,7,252,1,252,3,244,20,2,248,2,240,1,252,2,192,0,2,248,0,208,1,252,0,64,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,0,2,248,0,0,1,252,0,0,
  // 0x67f1  柱
  241,103,35,36,68,37,1,252,0,7,240,0,0,52,0,0,0,0,7,240,0,0,254,0,0,0,0,7,240,0,1,255,192,0,0,0,7,240,0,0,127,244,0,0,0,7,240,0,0,15,253,0,0,0,7,240,0,0,2,255,0,0,0,7,240,0,0,0,191,0,0,0,7,240,0,0,0,125,0,0,63,255,255,253,255,255,255,255,240,63,255,255,253,255,255,255,255,240,63,255,255,253,255,255,255,255,240,21,95,245,80,0,3,248,0,0,0,15,240,0,0,3,248,0,0,0,31,240,0,0,3,248,0,0,0,47,240,0,0,3,248,0,0,0,63,252,0,0,3,248,0,0,0,127,254,0,0,3,248,0,0,0,191,255,64,0,3,248,0,0,0,255,255,208,0,3,248,0,0,2,251,251,240,191,255,255,255,224,3,247,243,252,191,255,255,255,224,11,215,240,252,191,255,255,255,224,15,199,240,176,0,3,248,0,0,47,135,240,16,0,3,248,0,0,127,7,240,0,0,3,248,0,0,190,7,240,0,0,3,248,0,0,60,7,240,0,0,3,248,0,0,40,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,31,255,255,255,255,248,0,7,240,31,255,255,255,255,248,0,7,240,31,255,255,255,255,248,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6821  校
  33,104,35,36,68,37,1,252,0,15,208,0,0,15,224,0,0,0,15,208,0,0,15,224,0,0,0,15,208,0,0,15,224,0,0,0,15,208,0,0,15,224,0,0,0,15,208,0,0,15,224,0,0,0,15,208,0,0,15,224,0,0,0,15,208,15,255,255,255,255,240,0,15,208,15,255,255,255,255,240,63,255,255,234,170,170,170,170,160,63,255,255,224,0,0,0,64,0,63,255,255,224,15,128,7,224,0,0,31,208,0,47,192,7,248,0,0,47,208,0,63,128,2,253,0,0,63,208,0,255,0,0,255,64,0,63,240,2,253,0,0,63,192,0,127,248,7,248,0,0,31,224,0,255,253,31,241,0,6,91,240,0,255,255,47,239,192,11,243,244,2,255,239,139,15,192,15,225,128,3,239,223,192,11,224,31,208,0,7,223,215,240,7,240,47,192,0,15,207,211,208,3,252,127,128,0,31,143,209,128,1,253,255,0,0,63,79,208,0,0,255,253,0,0,191,15,208,0,0,63,252,0,0,125,15,208,0,0,47,244,0,0,60,15,208,0,0,47,248,0,0,16,15,208,0,0,191,254,0,0,0,15,208,0,3,255,255,192,0,0,15,208,0,31,252,127,244,0,0,15,208,0,255,240,31,254,0,0,15,208,27,255,128,3,255,224,0,15,208,127,253,0,0,255,244,0,15,208,63,208,0,0,31,208,0,15,208,13,0,0,0,2,128,0,0,0,0,0,0,0,0,0,
  // 0x683c  格
  60,104,35,35,59,37,1,253,0,15,208,0,0,228,0,0,0,0,15,208,0,1,253,0,0,0,0,15,208,0,2,252,0,0,0,0,15,208,0,7,244,0,0,0,0,15,208,0,15,255,255,253,0,0,15,208,0,31,255,255,255,0,0,15,208,0,63,255,255,253,0,0,15,208,0,255,64,2,252,0,63,255,255,242,255,192,3,248,0,63,255,255,251,255,208,11,240,0,63,255,255,255,251,240,31,208,0,0,31,224,127,195,252,63,128,0,0,31,224,31,1,254,255,0,0,0,63,244,5,0,127,253,0,0,0,63,252,0,0,47,248,0,0,0,127,255,0,0,127,252,0,0,0,191,255,128,2,255,255,128,0,0,255,223,208,15,254,191,244,0,1,255,215,240,191,244,31,255,64,3,255,211,219,255,192,3,255,248,7,223,209,255,254,0,0,127,244,15,207,208,191,255,255,255,255,224,31,143,208,62,255,255,255,255,64,63,79,208,0,255,255,255,254,0,191,15,208,0,252,0,0,190,0,125,15,208,0,252,0,0,190,0,56,15,208,0,252,0,0,190,0,16,15,208,0,252,0,0,190,0,0,15,208,0,252,0,0,190,0,0,15,208,0,252,0,0,190,0,0,15,208,0,255,255,255,254,0,0,15,208,0,255,255,255,254,0,0,15,208,0,255,255,255,254,0,0,15,208,0,252,0,0,190,0,0,10,144,0,168,0,0,105,0,
  // 0x68af  梯
  175,104,34,35,59,37,1,253,0,15,208,0,25,0,0,228,0,0,15,208,0,127,0,1,254,0,0,15,208,0,63,64,2,252,0,0,15,208,0,47,192,3,244,0,0,15,208,0,15,192,11,240,0,0,15,208,0,15,128,7,208,0,0,15,208,11,255,255,255,255,192,0,15,208,11,255,255,255,255,192,63,255,255,219,255,255,255,255,192,63,255,255,208,0,15,192,15,192,63,255,255,208,0,15,192,15,192,0,31,208,0,0,15,192,15,192,0,47,208,0,0,15,192,15,192,0,63,224,3,255,255,255,255,192,0,63,240,3,255,255,255,255,192,0,127,252,3,255,255,255,255,192,0,255,254,7,240,15,192,0,0,0,255,255,11,224,15,192,0,0,2,255,223,203,208,15,192,0,0,3,239,219,223,208,15,192,0,0,7,223,211,223,255,255,255,255,240,15,207,210,159,255,255,255,255,240,31,143,208,47,255,255,255,255,240,63,15,208,47,128,191,192,7,240,191,15,208,0,1,255,192,7,240,125,15,208,0,7,255,192,11,224,60,15,208,0,31,255,192,11,224,16,15,208,0,127,207,192,15,224,0,15,208,2,255,15,192,15,208,0,15,208,31,252,15,203,255,192,0,15,208,191,240,15,195,255,192,0,15,208,255,128,15,195,254,0,0,15,208,61,0,15,192,0,0,0,15,208,0,0,15,192,0,0,0,15,208,0,0,15,192,0,0,
  // 0x68c0  检
  192,104,35,35,59,37,1,253,0,47,64,0,0,46,0,0,0,0,47,128,0,0,63,64,0,0,0,47,128,0,0,255,64,0,0,0,47,128,0,1,255,192,0,0,0,47,128,0,3,255,240,0,0,0,47,128,0,15,247,252,0,0,0,47,128,0,63,193,255,0,0,63,255,255,0,191,64,127,192,0,63,255,255,3,254,0,31,244,0,63,255,255,15,252,0,7,254,0,0,63,128,63,240,0,2,255,192,0,63,129,255,192,0,0,191,244,0,127,199,254,191,255,255,223,244,0,191,227,248,191,255,255,195,240,0,255,244,208,191,255,255,192,144,1,255,252,0,0,0,0,0,0,2,255,254,0,0,0,0,0,0,3,255,191,0,0,45,0,30,0,7,255,159,79,128,62,0,63,64,11,239,142,15,192,63,0,63,0,15,175,132,15,192,47,0,126,0,47,111,128,7,208,47,64,252,0,63,47,128,3,240,31,64,252,0,190,47,128,3,240,15,130,244,0,60,47,128,2,240,15,195,240,0,40,47,128,1,244,15,199,208,0,0,47,128,1,244,4,15,192,0,0,47,128,0,64,0,31,128,0,0,47,128,0,0,0,63,0,0,0,47,128,0,0,0,126,0,0,0,47,128,255,255,255,255,255,224,0,47,128,255,255,255,255,255,224,0,47,128,255,255,255,255,255,224,0,47,128,0,0,0,0,0,0,0,31,64,0,0,0,0,0,0,
  // 0x69fd  槽
  253,105,35,36,68,37,1,252,0,31,192,0,3,240,63,0,0,0,31,192,0,3,240,63,0,0,0,31,192,0,3,240,63,0,0,0,31,192,191,255,255,255,255,248,0,31,192,191,255,255,255,255,248,0,31,192,106,171,250,255,170,164,0,31,192,0,3,240,63,0,0,0,31,192,0,3,240,63,0,0,63,255,255,159,255,255,255,255,208,63,255,255,159,255,255,255,255,208,63,255,255,159,150,245,126,91,208,0,63,192,31,66,240,61,7,208,0,63,192,31,130,240,126,11,208,0,63,192,31,255,255,255,255,208,0,127,208,31,255,255,255,255,208,0,255,240,31,66,240,61,7,208,0,255,248,31,66,240,61,7,208,1,255,252,31,150,245,126,91,208,3,255,255,31,255,255,255,255,208,3,255,223,95,255,255,255,255,208,11,223,207,192,0,0,0,0,0,15,159,199,2,170,170,170,170,0,31,95,193,3,255,255,255,255,0,63,31,192,3,255,255,255,255,0,190,31,192,3,244,0,0,127,0,188,31,192,3,244,0,0,127,0,60,31,192,3,249,85,85,191,0,32,31,192,3,255,255,255,255,0,0,31,192,3,255,255,255,255,0,0,31,192,3,244,0,0,127,0,0,31,192,3,244,0,0,127,0,0,31,192,3,250,170,170,191,0,0,31,192,3,255,255,255,255,0,0,31,192,3,255,255,255,255,0,0,31,192,3,244,0,0,127,0,0,0,0,0,0,0,0,0,0,
  // 0x6a21  模
  33,106,35,35,59,37,1,253,0,47,64,0,31,128,15,192,0,0,47,64,0,31,128,15,192,0,0,47,64,0,31,128,15,192,0,0,47,64,127,255,255,255,255,240,0,47,64,127,255,255,255,255,240,0,47,64,127,255,255,255,255,224,0,47,64,0,31,128,15,192,0,63,255,255,0,31,128,15,192,0,63,255,255,0,5,64,5,64,0,63,255,255,15,255,255,255,255,0,0,63,149,15,255,255,255,255,0,0,63,128,15,234,170,170,191,0,0,63,192,15,192,0,0,127,0,0,127,208,15,192,0,0,127,0,0,191,240,15,255,255,255,255,0,0,255,248,15,255,255,255,255,0,1,255,253,15,213,85,85,191,0,2,255,191,15,192,0,0,127,0,3,255,111,143,229,85,85,191,0,7,255,79,143,255,255,255,255,0,15,255,74,15,255,255,255,255,0,31,175,64,0,0,63,64,0,0,63,47,64,0,0,63,64,0,0,127,47,64,0,0,63,0,0,0,190,47,64,255,255,255,255,255,240,60,47,64,255,255,255,255,255,240,40,47,64,255,255,255,255,255,240,0,47,64,0,3,255,252,0,0,0,47,64,0,11,248,254,0,0,0,47,64,0,47,240,127,192,0,0,47,64,1,255,192,47,248,0,0,47,64,111,255,0,11,255,144,0,47,67,255,248,0,1,255,244,0,47,65,255,128,0,0,47,224,0,47,64,164,0,0,0,2,192,
  // 0x6a59  橙
  89,106,35,35,59,37,1,253,0,15,192,0,0,0,20,0,0,0,15,192,10,170,208,252,20,0,0,15,192,31,255,244,252,125,0,0,15,192,31,255,240,191,254,0,0,15,192,0,7,240,63,244,0,0,15,192,4,11,224,63,192,128,0,15,192,47,79,192,31,194,240,0,15,192,63,255,128,15,219,244,63,255,255,203,255,64,11,255,192,63,255,255,194,255,0,3,253,0,63,255,255,193,255,255,255,253,0,0,47,208,7,255,255,255,255,64,0,47,192,15,246,170,170,63,224,0,63,192,127,192,0,0,15,252,0,127,225,255,64,0,0,3,240,0,191,244,254,170,170,170,169,144,0,255,252,34,255,255,255,253,0,0,255,255,2,255,255,255,253,0,2,255,239,130,248,0,0,253,0,3,255,207,210,248,0,0,253,0,7,223,199,194,248,0,0,253,0,15,207,195,66,248,0,0,253,0,31,143,192,2,255,255,255,253,0,63,15,192,2,255,255,255,253,0,191,15,192,1,170,170,171,169,0,189,15,192,0,26,0,7,224,0,60,15,192,0,63,0,11,240,0,16,15,192,0,47,128,15,208,0,0,15,192,0,31,192,31,192,0,0,15,192,0,15,192,47,64,0,0,15,192,0,15,64,47,0,0,0,15,192,255,255,255,255,255,248,0,15,192,255,255,255,255,255,248,0,15,192,255,255,255,255,255,244,0,15,192,0,0,0,0,0,0,
  // 0x6b62  止
  98,107,33,33,41,37,2,255,0,0,0,0,190,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,42,0,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,255,85,85,84,0,0,63,64,0,255,255,255,253,0,0,63,64,0,255,255,255,253,0,0,63,64,0,255,255,255,253,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,0,63,64,0,254,0,0,0,0,85,191,149,85,255,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x6b63  正
  99,107,33,32,32,37,2,254,21,85,85,85,85,85,85,85,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,21,0,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,254,85,85,80,0,0,63,64,1,255,255,255,244,0,0,63,64,1,255,255,255,244,0,0,63,64,1,255,255,255,244,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,0,63,64,1,253,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,85,85,85,85,85,85,85,85,64,
  // 0x6b65  步
  101,107,33,35,59,37,2,253,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,5,0,3,244,0,0,0,0,0,47,192,3,244,0,0,0,0,0,47,192,3,255,255,255,192,0,0,47,192,3,255,255,255,192,0,0,47,192,3,255,255,255,192,0,0,47,192,3,249,85,85,64,0,0,47,192,3,244,0,0,0,0,0,47,192,3,244,0,0,0,0,0,47,192,3,244,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,21,85,85,87,245,85,85,85,0,0,2,64,3,244,0,0,0,0,0,7,248,3,244,0,4,0,0,0,15,240,3,244,0,47,128,0,0,63,224,3,244,0,63,192,0,0,255,128,3,244,0,127,128,0,3,255,0,3,244,0,255,0,0,31,252,0,3,244,2,254,0,0,191,240,0,3,244,7,252,0,0,63,192,15,255,240,15,244,0,0,14,0,7,255,240,63,240,0,0,0,0,3,255,128,255,192,0,0,0,0,0,0,7,255,0,0,0,0,0,0,0,127,252,0,0,0,0,0,0,2,255,240,0,0,0,0,0,0,191,255,128,0,0,0,0,0,111,255,248,0,0,0,0,2,191,255,255,144,0,0,0,0,2,255,255,248,0,0,0,0,0,0,255,249,0,0,0,0,0,0,0,185,0,0,0,0,0,0,0,
  // 0x6bd4  比
  212,107,34,35,59,37,2,253,0,106,0,0,6,144,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,124,0,0,191,0,0,15,224,3,255,0,0,191,85,85,15,224,47,255,64,0,191,255,254,15,226,255,248,0,0,191,255,254,15,255,255,128,0,0,191,255,254,15,255,248,0,0,0,191,0,0,15,255,128,0,0,0,191,0,0,15,244,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,0,0,0,191,0,0,15,224,0,7,128,0,191,0,0,15,224,0,11,240,0,191,0,27,143,224,0,11,224,0,191,27,255,143,224,0,11,224,0,255,255,255,207,240,0,15,208,175,255,255,254,75,240,0,31,192,255,255,254,64,7,255,255,255,192,255,254,64,0,3,255,255,255,64,190,64,0,0,1,255,255,254,0,0,0,0,0,0,5,85,64,0,
  // 0x6ca1  没
  161,108,34,34,50,37,2,253,7,208,0,0,0,0,0,0,0,15,252,0,15,255,255,252,0,0,15,255,128,15,255,255,252,0,0,1,255,240,15,255,255,252,0,0,0,31,224,31,192,0,252,0,0,0,3,192,31,192,0,252,0,0,0,0,0,31,192,0,252,0,0,0,0,0,47,192,0,252,3,64,0,0,0,63,128,0,252,7,224,0,0,0,127,64,0,252,7,224,121,0,0,255,0,0,253,11,208,255,208,3,254,0,0,255,255,208,255,248,31,252,0,0,191,255,192,31,255,31,240,0,0,47,254,0,1,253,7,192,0,0,0,0,0,0,60,2,0,0,0,0,64,0,0,0,3,255,255,255,255,244,0,0,0,3,255,255,255,255,244,0,0,0,3,255,255,255,255,240,0,0,1,0,11,192,0,31,224,0,0,7,128,31,208,0,63,192,0,0,15,224,11,240,0,191,128,0,0,31,208,3,252,1,255,0,0,0,63,192,2,255,7,253,0,0,0,127,64,0,191,159,248,0,0,0,255,0,0,63,255,224,0,0,2,253,0,0,15,255,128,0,0,3,252,0,0,47,255,128,0,0,11,244,0,2,255,255,248,0,0,31,240,0,111,255,175,255,144,0,63,208,111,255,253,2,255,255,144,63,128,191,255,208,0,127,255,208,11,0,63,248,0,0,6,255,128,0,0,41,0,0,0,0,27,0,
  // 0x6ce2  波
  226,108,34,36,68,37,1,252,0,64,0,0,0,63,0,0,0,2,248,0,0,0,63,0,0,0,7,255,64,0,0,63,0,0,0,1,255,240,0,0,63,0,0,0,0,47,248,0,0,63,0,0,0,0,3,240,255,255,255,255,255,224,0,0,128,255,255,255,255,255,240,0,0,0,255,255,255,255,255,224,0,0,0,254,0,127,64,31,208,0,0,0,253,0,63,0,31,192,4,0,0,253,0,63,0,63,128,31,64,0,253,0,63,0,63,64,63,240,0,253,0,63,0,127,0,127,254,0,253,0,63,0,9,0,11,255,128,253,0,63,0,0,0,0,191,64,255,255,255,255,253,0,0,30,0,255,255,255,255,254,0,0,0,0,255,255,255,255,253,0,0,0,0,253,252,0,1,252,0,0,0,0,252,190,0,3,252,0,0,0,0,252,63,0,7,244,0,0,3,129,252,47,192,15,240,0,0,11,225,252,15,208,31,208,0,0,15,209,252,11,240,63,192,0,0,47,194,248,3,252,255,64,0,0,63,131,244,1,255,254,0,0,0,191,3,244,0,191,252,0,0,0,254,7,240,0,63,244,0,0,2,253,11,224,0,255,253,0,0,3,252,15,208,7,255,255,192,0,11,244,47,192,127,252,191,248,0,15,240,63,139,255,224,31,255,208,31,208,191,47,255,64,2,255,240,7,192,190,15,244,0,0,47,208,0,0,8,3,64,0,0,2,128,0,0,0,0,0,0,0,0,0,
  // 0x6ce8  注
  232,108,35,35,59,37,1,253,0,80,0,0,13,0,0,0,0,1,253,0,0,63,208,0,0,0,3,255,208,0,191,248,0,0,0,0,191,248,0,31,255,64,0,0,0,15,253,0,2,255,224,0,0,0,1,248,0,0,63,248,0,0,0,0,32,0,0,11,244,0,0,0,0,0,0,0,2,208,0,0,0,0,0,255,255,255,255,255,224,0,0,0,255,255,255,255,255,224,9,0,0,255,255,255,255,255,224,47,208,0,85,85,127,149,85,64,127,253,0,0,0,63,64,0,0,31,255,192,0,0,63,64,0,0,1,255,192,0,0,63,64,0,0,0,47,64,0,0,63,64,0,0,0,6,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,63,255,255,255,255,64,0,0,64,63,255,255,255,255,64,0,0,244,63,255,255,255,255,64,0,1,252,5,85,127,149,85,0,0,3,252,0,0,63,64,0,0,0,7,244,0,0,63,64,0,0,0,15,240,0,0,63,64,0,0,0,47,208,0,0,63,64,0,0,0,63,192,0,0,63,64,0,0,0,191,64,0,0,63,64,0,0,1,255,0,0,0,63,64,0,0,3,252,1,85,85,127,149,85,80,11,248,7,255,255,255,255,255,248,15,240,7,255,255,255,255,255,248,2,208,7,255,255,255,255,255,248,0,64,0,0,0,0,0,0,0,
  // 0x6d17  洗
  23,109,34,35,59,37,2,253,1,0,0,4,0,253,0,0,0,11,192,0,31,192,253,0,0,0,31,248,0,31,192,253,0,0,0,11,255,0,47,192,253,0,0,0,1,255,192,63,128,253,0,0,0,0,47,192,127,64,253,0,0,0,0,11,0,191,255,255,255,255,0,0,0,0,255,255,255,255,255,0,0,0,1,255,255,255,255,255,0,0,0,2,253,1,254,0,0,0,16,0,3,248,0,253,0,0,0,125,0,11,240,0,253,0,0,0,255,192,31,240,0,253,0,0,0,191,248,11,192,0,253,0,0,0,31,254,1,128,0,253,0,0,0,2,253,5,85,85,254,85,85,64,0,120,31,255,255,255,255,255,208,0,0,31,255,255,255,255,255,208,0,0,31,255,255,255,255,255,208,0,0,0,1,252,3,244,0,0,0,4,0,2,252,3,244,0,0,0,15,0,2,252,3,244,0,0,0,47,192,2,248,3,244,0,0,0,63,64,3,248,3,244,0,0,0,191,0,3,244,3,244,0,0,0,254,0,11,240,3,244,0,0,2,252,0,15,240,3,244,3,128,3,248,0,31,208,3,244,3,240,11,240,0,63,192,3,244,3,240,15,224,1,255,64,3,244,3,240,47,192,11,254,0,3,248,7,224,127,128,191,248,0,2,255,255,208,47,64,191,224,0,1,255,255,192,6,0,63,64,0,0,191,255,0,0,0,4,0,0,0,0,0,0,
  // 0x6d3b  活
  59,109,34,35,59,37,2,253,0,0,0,0,0,0,1,144,0,7,208,0,0,0,1,111,248,0,15,252,0,0,6,191,255,253,0,11,255,128,175,255,255,255,228,0,1,255,240,255,255,255,228,0,0,0,47,208,191,254,254,0,0,0,0,3,128,20,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,56,0,15,255,255,255,255,255,208,191,128,15,255,255,255,255,255,208,255,248,15,255,255,255,255,255,208,31,255,5,85,85,254,85,85,64,2,254,0,0,0,190,0,0,0,0,60,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,2,0,127,255,255,255,252,0,0,11,192,127,255,255,255,252,0,0,15,224,127,255,255,255,252,0,0,47,192,126,0,0,0,252,0,0,63,128,126,0,0,0,252,0,0,191,0,126,0,0,0,252,0,0,254,0,126,0,0,0,252,0,3,252,0,126,0,0,0,252,0,7,248,0,126,0,0,0,252,0,15,240,0,126,0,0,0,252,0,47,208,0,127,255,255,255,252,0,127,192,0,127,255,255,255,252,0,63,64,0,127,255,255,255,252,0,10,0,0,126,0,0,0,252,0,0,0,0,126,0,0,0,168,0,
  // 0x6d41  流
  65,109,34,35,59,37,2,253,1,0,0,0,2,252,0,0,0,11,224,0,0,2,252,0,0,0,15,253,0,0,2,252,0,0,0,11,255,192,0,2,252,0,0,0,0,191,240,0,2,252,0,0,0,0,31,207,255,255,255,255,255,192,0,2,79,255,255,255,255,255,192,0,0,15,255,255,255,255,255,192,0,0,0,0,127,128,0,0,0,0,0,0,0,191,0,30,0,0,16,0,0,0,254,0,127,64,0,125,0,0,1,252,0,47,208,0,255,208,0,3,244,0,11,244,0,191,252,1,91,255,255,255,253,0,31,255,11,255,255,255,255,255,0,1,252,11,255,255,255,255,255,128,0,40,7,250,165,80,0,47,208,0,0,0,0,0,0,0,15,64,0,0,0,63,2,244,31,192,0,0,0,0,63,2,244,31,192,0,0,2,0,63,2,244,31,192,0,0,11,128,63,2,244,31,192,0,0,15,208,63,2,244,31,192,0,0,47,192,63,2,244,31,192,0,0,63,128,63,2,244,31,192,0,0,191,0,127,2,244,31,192,0,0,254,0,190,2,244,31,192,0,3,252,0,253,2,244,31,194,208,7,248,1,252,2,244,31,194,224,15,240,3,252,2,244,31,194,224,31,224,11,244,2,244,31,195,224,63,192,47,240,2,244,31,255,224,63,128,127,192,2,244,15,255,192,11,0,47,0,0,0,7,255,64,0,0,8,0,0,0,0,0,0,
  // 0x6d4b  测
  75,109,34,35,59,37,1,253,0,64,0,0,0,0,0,2,128,3,244,0,0,0,0,0,7,208,15,254,7,255,255,252,0,7,208,3,255,219,255,255,252,26,7,208,0,127,235,234,170,252,31,71,208,0,11,199,192,0,188,31,71,208,0,2,7,192,0,188,31,71,208,0,0,7,194,240,188,31,71,208,0,0,7,194,240,188,31,71,208,0,0,7,194,240,188,31,71,208,4,0,7,194,240,188,31,71,208,47,64,7,194,240,188,31,71,208,127,244,7,194,240,188,31,71,208,47,254,7,194,240,188,31,71,208,3,255,7,194,240,188,31,71,208,0,125,7,194,240,188,31,71,208,0,8,7,194,240,188,31,71,208,0,0,7,194,240,188,31,71,208,0,0,7,194,240,188,31,71,208,0,0,7,194,240,188,31,71,208,0,0,7,194,240,188,31,71,208,0,30,7,194,240,188,31,71,208,0,63,135,194,240,188,31,71,208,0,63,71,195,240,188,31,71,208,0,191,7,195,224,188,31,71,208,0,254,7,195,224,188,31,71,208,1,253,0,7,208,0,5,7,208,2,252,0,15,197,0,0,7,208,3,248,0,31,175,0,0,7,208,7,240,0,63,31,192,0,7,208,15,240,0,254,7,240,0,7,208,31,208,7,248,2,248,0,11,208,47,192,47,240,0,189,15,255,192,7,128,47,128,0,61,11,255,128,0,0,8,0,0,16,7,233,0,
  // 0x6d88  消
  136,109,33,36,68,37,2,252,1,0,0,0,0,253,0,0,0,11,128,0,32,0,253,0,40,0,31,248,2,248,0,253,0,63,64,15,255,2,252,0,253,0,191,0,1,255,208,255,0,253,0,254,0,0,63,192,127,64,253,2,252,0,0,11,64,63,192,253,3,248,0,0,1,0,31,208,253,11,240,0,0,0,0,15,128,253,11,208,0,0,0,0,4,0,253,0,64,0,16,0,0,0,0,254,0,0,0,125,0,0,255,255,255,255,252,0,255,192,0,255,255,255,255,252,0,191,244,0,255,255,255,255,252,0,15,254,0,253,0,0,0,252,0,2,254,0,253,0,0,0,252,0,0,188,0,253,0,0,0,252,0,0,20,0,253,0,0,0,252,0,0,0,0,255,255,255,255,252,0,0,0,0,255,255,255,255,252,0,0,0,0,255,255,255,255,252,0,0,11,0,253,0,0,0,252,0,0,15,192,253,0,0,0,252,0,0,47,192,253,0,0,0,252,0,0,63,64,255,255,255,255,252,0,0,191,0,255,255,255,255,252,0,0,254,0,255,255,255,255,252,0,2,252,0,253,0,0,0,252,0,3,248,0,253,0,0,0,252,0,11,240,0,253,0,0,0,252,0,31,224,0,253,0,0,0,252,0,63,208,0,253,0,0,1,252,0,127,192,0,253,0,3,255,252,0,31,64,0,253,0,2,255,248,0,2,0,0,253,0,1,255,208,0,0,0,0,0,0,0,0,0,0,
  // 0x6de1  淡
  225,109,35,34,50,37,1,253,0,0,0,0,0,127,0,0,0,1,224,0,0,0,127,0,0,0,7,254,0,6,64,127,0,36,0,3,255,208,15,192,127,0,63,128,0,127,248,31,192,191,0,191,0,0,11,244,63,128,190,1,253,0,0,1,208,127,0,254,3,252,0,0,0,0,254,0,253,7,240,0,0,0,1,252,1,254,15,208,0,0,0,0,36,3,255,209,64,0,4,0,0,0,7,255,252,0,0,31,64,0,0,31,251,255,128,0,127,244,0,0,191,208,191,244,0,47,254,0,7,255,128,31,255,0,2,255,193,255,253,0,2,255,192,0,127,2,255,224,106,0,63,192,0,13,0,254,0,127,0,11,0,0,0,0,0,0,191,0,0,0,0,0,0,9,0,191,0,25,0,0,1,0,31,192,190,0,63,192,0,3,128,47,128,254,0,127,128,0,11,240,63,64,255,0,255,0,0,15,224,191,0,255,66,253,0,0,47,192,254,1,255,131,248,0,0,63,195,252,3,255,207,240,0,0,191,66,244,3,255,246,192,0,0,255,0,16,15,247,248,0,0,2,253,0,0,47,226,254,0,0,7,252,0,0,255,192,255,128,0,15,244,0,27,255,0,63,244,0,31,240,6,255,252,0,15,255,144,15,208,31,255,224,0,2,255,244,2,128,11,254,0,0,0,127,224,0,0,3,144,0,0,0,1,128,
  // 0x6df7  混
  247,109,34,35,59,37,2,253,1,0,0,0,0,0,0,0,0,7,192,0,0,0,0,0,0,0,15,248,3,255,255,255,255,252,0,31,255,67,255,255,255,255,252,0,1,255,211,255,255,255,255,252,0,0,47,195,244,0,0,2,252,0,0,7,3,244,0,0,2,252,0,0,0,3,254,170,170,171,252,0,0,0,3,255,255,255,255,252,0,0,0,3,255,255,255,255,252,0,16,0,3,244,0,0,2,252,0,126,0,3,244,0,0,2,252,0,255,208,3,244,0,0,2,252,0,191,252,3,255,255,255,255,252,0,11,253,3,255,255,255,255,252,0,1,248,2,255,255,255,255,248,0,0,32,0,0,0,0,0,0,0,0,0,1,84,0,5,64,0,0,0,0,2,248,0,15,192,0,0,0,0,2,248,0,15,192,0,0,0,4,2,248,0,15,192,28,0,0,15,2,248,0,15,192,191,0,0,47,194,255,255,143,199,255,128,0,63,130,255,255,143,255,253,0,0,191,2,255,255,143,255,208,0,0,254,2,248,0,15,249,0,0,2,252,2,248,0,15,192,0,0,3,252,2,248,0,15,192,6,0,11,244,2,248,0,15,192,7,224,15,240,2,249,175,143,192,7,224,47,208,91,255,255,207,192,11,208,63,192,255,255,255,143,255,255,192,127,64,191,254,144,15,255,255,192,15,0,121,64,0,2,255,254,0,0,0,0,0,0,0,0,0,0,
  // 0x6e05  清
  5,110,34,36,68,37,2,252,2,0,0,0,1,252,0,0,0,15,224,0,0,1,252,0,0,0,31,254,1,85,86,253,85,85,0,7,255,195,255,255,255,255,255,64,0,191,211,255,255,255,255,255,64,0,31,192,0,1,252,0,0,0,0,3,64,0,1,252,0,0,0,0,0,1,255,255,255,255,253,0,0,0,1,255,255,255,255,253,0,0,0,0,85,86,253,85,84,0,16,0,0,0,1,252,0,0,0,125,0,10,170,170,254,170,170,144,255,224,31,255,255,255,255,255,224,191,253,31,255,255,255,255,255,224,11,255,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,0,40,0,63,255,255,255,248,0,0,0,0,63,255,255,255,248,0,0,0,0,63,170,170,171,248,0,0,0,0,63,0,0,2,248,0,0,1,0,63,0,0,2,248,0,0,11,128,63,255,255,255,248,0,0,15,208,63,255,255,255,248,0,0,47,192,63,85,85,86,248,0,0,63,128,63,0,0,2,248,0,0,191,0,63,85,85,86,248,0,0,254,0,63,255,255,255,248,0,2,252,0,63,255,255,255,248,0,7,248,0,63,0,0,2,248,0,15,240,0,63,0,0,2,248,0,31,224,0,63,0,0,2,248,0,63,192,0,63,0,0,2,248,0,63,128,0,63,0,3,255,248,0,15,0,0,63,0,2,255,244,0,1,0,0,63,0,1,255,144,0,0,0,0,0,0,0,0,0,0,
  // 0x6e29  温
  41,110,34,34,50,37,2,253,3,208,0,0,0,0,0,0,0,11,252,0,255,255,255,255,240,0,15,255,128,255,255,255,255,240,0,1,255,240,255,255,255,255,240,0,0,31,224,252,0,0,7,240,0,0,3,192,252,0,0,7,240,0,0,0,0,252,0,0,7,240,0,0,0,0,255,255,255,255,240,0,0,0,0,255,255,255,255,240,0,0,0,0,255,170,170,175,240,0,56,0,0,252,0,0,7,240,0,255,208,0,252,0,0,7,240,0,191,252,0,255,255,255,255,240,0,11,255,0,255,255,255,255,240,0,0,253,0,255,255,255,255,240,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,252,0,0,9,3,255,255,255,255,252,0,0,15,131,255,255,255,255,252,0,0,47,195,240,61,11,192,252,0,0,63,131,240,61,11,192,252,0,0,191,3,240,61,11,192,252,0,0,254,3,240,61,11,192,252,0,2,252,3,240,61,11,192,252,0,3,248,3,240,61,11,192,252,0,11,240,3,240,61,11,192,252,0,15,224,3,240,61,11,192,252,0,63,192,3,240,61,11,192,252,0,127,128,255,255,255,255,255,255,224,63,0,255,255,255,255,255,255,224,10,0,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x6e38  游
  56,110,35,36,68,37,1,252,0,0,0,31,192,0,164,0,0,3,224,0,31,192,1,252,0,0,11,253,0,31,192,2,252,0,0,7,255,128,31,192,3,248,0,0,0,191,208,31,192,3,244,0,0,0,31,128,31,192,7,255,255,248,0,2,127,255,255,235,255,255,248,0,0,127,255,255,239,255,255,248,0,0,127,255,255,255,213,85,80,0,0,21,253,85,127,192,0,0,0,0,1,252,0,127,64,0,0,30,0,1,252,0,255,0,0,0,63,240,1,252,0,47,255,255,208,127,254,1,248,0,3,255,255,240,7,255,1,255,255,195,255,255,224,0,189,2,255,255,128,0,63,192,0,24,2,255,255,128,0,191,0,0,0,2,248,31,128,6,253,0,0,0,3,244,31,128,11,244,0,0,0,3,244,31,128,11,224,0,0,0,3,240,31,128,11,224,0,0,56,3,240,47,175,255,255,248,0,63,7,240,47,175,255,255,248,0,127,7,224,47,111,255,255,248,0,254,11,208,47,64,11,224,0,0,253,15,192,47,64,11,224,0,2,252,15,192,63,64,11,224,0,3,248,47,128,63,64,11,224,0,7,244,63,64,63,0,11,224,0,11,240,127,0,63,0,11,224,0,15,224,254,0,63,0,11,224,0,47,194,252,0,191,0,11,224,0,63,199,244,127,254,15,255,224,0,11,66,240,63,252,7,255,192,0,0,0,128,63,224,3,254,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6e90  源
  144,110,34,35,59,37,2,253,1,0,0,0,0,0,0,0,0,11,208,0,0,0,0,0,0,0,31,252,11,255,255,255,255,255,192,11,255,75,255,255,255,255,255,192,1,255,203,255,255,255,255,255,192,0,47,75,240,0,31,224,0,0,0,10,11,240,0,31,208,0,0,0,0,11,240,0,47,192,0,0,0,0,11,240,0,47,128,0,0,0,0,11,241,255,255,255,255,0,16,0,11,241,255,255,255,255,0,125,0,11,241,254,170,170,191,0,255,208,11,241,248,0,0,127,0,191,252,11,241,248,0,0,127,0,11,252,11,225,255,255,255,255,0,0,244,11,225,255,255,255,255,0,0,16,11,225,253,85,85,191,0,0,0,11,225,248,0,0,127,0,0,0,15,225,248,0,0,127,0,0,0,15,209,254,170,170,191,0,0,16,15,209,255,255,255,255,0,0,61,15,193,255,255,255,255,0,0,127,15,192,0,15,192,0,0,0,254,31,192,0,15,192,16,0,1,253,47,192,184,15,193,248,0,2,252,63,128,253,15,194,252,0,3,248,63,66,252,15,192,254,0,11,240,127,3,244,15,192,191,64,15,240,255,11,240,15,192,63,192,31,208,253,31,208,15,192,31,208,63,194,252,63,128,15,192,15,224,127,67,248,63,0,15,192,11,144,191,11,240,5,15,255,192,0,0,30,7,224,0,15,255,128,0,0,0,0,128,0,7,249,0,0,0,
  // 0x6ea2  溢
  162,110,34,35,59,37,2,253,1,0,0,0,0,0,0,0,0,15,208,0,0,31,255,248,0,0,47,252,0,9,31,255,252,0,0,11,255,64,47,223,255,254,0,0,0,255,192,63,128,0,191,64,0,0,47,0,255,0,0,63,192,0,0,9,2,253,0,0,31,240,0,0,0,7,252,0,0,15,253,0,0,0,31,255,255,255,254,255,192,0,0,127,219,255,255,252,191,64,0,0,31,70,170,170,168,29,0,125,0,5,0,0,0,0,0,0,255,208,0,0,0,0,0,0,0,191,248,0,0,31,255,252,0,0,11,252,0,9,31,255,254,0,0,1,244,0,63,223,255,255,0,0,0,16,0,127,64,0,63,128,0,0,0,0,255,0,0,31,208,0,0,0,3,253,0,0,15,240,0,0,0,11,244,0,0,3,252,0,0,0,47,224,0,0,0,255,128,0,52,255,255,255,255,255,255,224,0,191,191,255,255,255,255,255,128,0,254,46,255,255,255,255,246,0,1,253,2,244,61,15,131,240,0,2,252,2,244,61,15,131,240,0,3,248,2,244,61,15,131,240,0,7,240,2,244,61,15,131,240,0,15,240,2,244,61,15,131,240,0,31,208,2,244,61,15,131,240,0,63,192,2,244,61,15,131,240,0,127,128,255,255,255,255,255,255,224,191,0,255,255,255,255,255,255,224,46,0,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x6ed1  滑
  209,110,34,35,59,37,1,253,0,128,0,0,0,0,0,0,0,2,248,0,10,170,170,170,164,0,7,255,128,15,255,255,255,248,0,1,255,244,15,255,255,255,248,0,0,47,248,15,192,0,2,248,0,0,7,240,15,192,0,2,248,0,0,0,224,15,192,0,3,248,0,0,0,0,15,192,191,255,248,0,0,0,0,15,192,191,255,248,0,0,0,0,15,192,188,2,248,0,4,0,0,15,192,188,2,248,0,47,128,6,175,234,254,171,254,160,127,248,11,255,255,255,255,255,240,31,255,139,255,255,255,255,255,240,1,255,139,224,0,0,0,3,240,0,47,11,224,0,0,0,3,240,0,5,11,234,170,170,170,167,240,0,0,11,239,255,255,255,251,240,0,0,0,15,255,255,255,248,0,0,0,0,15,192,0,2,248,0,0,1,128,15,192,0,2,248,0,0,3,240,15,234,170,171,248,0,0,7,244,15,255,255,255,248,0,0,11,240,15,255,255,255,248,0,0,15,224,15,192,0,2,248,0,0,47,192,15,192,0,2,248,0,0,63,128,15,234,170,171,248,0,0,255,0,15,255,255,255,248,0,1,254,0,15,255,255,255,248,0,3,252,0,15,192,0,2,248,0,7,248,0,15,192,0,2,248,0,15,240,0,15,192,0,2,248,0,15,224,0,15,192,2,171,244,0,3,192,0,15,192,3,255,240,0,0,0,0,15,192,1,255,144,0,
  // 0x6f0f  漏
  15,111,34,35,59,37,1,253,1,64,0,0,0,0,0,0,0,3,240,3,255,255,255,255,255,128,15,254,3,255,255,255,255,255,192,2,255,211,255,255,255,255,255,192,0,127,211,240,0,0,0,31,192,0,15,131,240,0,0,0,31,192,0,2,3,240,0,0,0,31,192,0,0,3,255,255,255,255,255,192,0,0,3,255,255,255,255,255,192,0,0,3,255,255,255,255,255,192,4,0,3,240,0,0,0,0,0,31,64,3,240,0,0,0,0,0,63,224,3,240,0,0,0,0,0,127,253,3,255,255,255,255,255,240,11,255,131,255,255,255,255,255,240,0,255,3,250,170,175,234,170,160,0,29,3,240,0,15,192,0,0,0,0,7,240,0,15,192,0,0,0,0,7,255,255,255,255,255,208,0,0,7,255,255,255,255,255,208,0,0,11,255,234,175,234,175,208,0,45,11,239,128,15,192,7,208,0,63,75,223,141,15,206,7,208,0,127,15,223,175,143,223,199,208,0,191,15,207,139,239,199,247,208,0,253,31,207,129,207,192,199,208,1,252,47,143,128,15,192,7,208,3,252,63,79,140,15,205,7,208,7,244,63,15,191,79,239,135,208,11,240,127,15,143,223,203,231,208,15,224,254,15,131,223,193,199,208,47,193,252,15,128,79,192,7,208,63,195,248,15,128,15,193,91,208,15,65,244,15,128,15,193,255,192,1,0,32,15,128,11,192,255,64,
  // 0x6fc0  激
  192,111,34,36,68,37,2,252,0,0,0,46,64,2,228,0,0,15,128,0,63,192,2,248,0,0,47,244,0,63,64,3,244,0,0,31,254,0,127,0,3,240,0,0,3,255,127,255,255,131,240,0,0,0,127,63,255,255,135,240,0,0,0,28,63,85,111,139,224,0,0,0,0,63,0,31,143,255,255,224,0,0,63,85,111,143,255,255,224,0,0,63,255,255,159,255,255,224,0,0,63,255,255,175,192,127,0,125,0,63,0,31,191,192,126,0,255,128,63,0,31,255,192,190,0,255,244,63,85,111,255,192,189,0,31,252,63,255,255,255,208,253,0,2,244,63,255,255,255,208,252,0,0,96,0,63,64,247,224,252,0,0,0,0,63,64,114,241,252,0,0,0,0,63,64,1,242,248,0,0,1,255,255,255,241,247,244,0,0,1,255,255,255,240,251,240,0,0,53,255,255,255,224,255,240,0,0,190,2,244,0,0,127,224,0,0,254,2,244,0,0,63,208,0,1,252,2,255,255,64,63,192,0,3,252,3,255,255,64,63,128,0,3,244,3,255,255,64,127,192,0,11,240,7,240,63,64,255,240,0,15,224,11,224,63,2,255,244,0,31,208,15,192,63,7,246,252,0,63,192,63,128,63,31,240,255,0,127,64,191,0,127,127,192,127,192,191,2,253,47,255,255,64,47,224,46,7,248,31,253,253,0,11,192,0,1,208,10,144,48,0,2,0,0,0,0,0,0,0,0,0,0,
  // 0x706f  灯
  111,112,34,35,59,37,2,253,0,10,128,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,7,255,255,255,255,224,0,15,192,7,255,255,255,255,224,0,15,192,7,255,255,255,255,224,0,15,192,1,85,86,254,85,64,0,15,192,144,0,0,253,0,0,47,15,193,248,0,0,253,0,0,47,15,195,240,0,0,253,0,0,63,15,195,240,0,0,253,0,0,63,15,199,208,0,0,253,0,0,62,15,203,192,0,0,253,0,0,62,15,207,128,0,0,253,0,0,125,15,239,0,0,0,253,0,0,188,15,198,0,0,0,253,0,0,252,31,192,0,0,0,253,0,0,120,31,192,0,0,0,253,0,0,0,31,192,0,0,0,253,0,0,0,47,192,0,0,0,253,0,0,0,63,128,0,0,0,253,0,0,0,63,192,0,0,0,253,0,0,0,63,240,0,0,0,253,0,0,0,127,252,0,0,0,253,0,0,0,191,255,0,0,0,253,0,0,0,254,63,192,0,0,253,0,0,1,253,31,240,0,0,253,0,0,3,252,11,248,0,0,253,0,0,7,244,2,240,0,0,253,0,0,15,240,0,192,0,0,253,0,0,63,208,0,0,0,1,253,0,0,191,192,0,0,63,255,253,0,0,255,0,0,0,47,255,252,0,0,61,0,0,0,15,255,240,0,0,4,0,0,0,10,169,0,0,0,
  // 0x70b9  点
  185,112,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,255,255,255,254,0,0,0,0,7,255,255,255,254,0,0,0,0,7,255,255,255,254,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,253,0,0,0,0,47,192,0,0,253,0,0,0,0,47,192,0,0,253,0,0,0,0,47,192,0,0,253,0,0,0,0,47,192,0,0,253,0,0,0,0,47,192,0,0,253,0,0,0,0,47,192,0,0,253,0,0,0,0,47,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,0,0,1,64,11,192,0,1,253,11,224,15,208,15,224,0,3,252,7,240,11,240,11,244,0,11,244,7,240,3,244,3,252,0,15,240,3,240,3,248,0,254,0,63,208,3,244,1,252,0,191,64,191,128,3,244,0,253,0,63,192,255,0,3,248,0,254,0,47,128,24,0,2,80,0,64,0,4,0,
  // 0x70ed  热
  237,112,34,36,68,37,2,252,0,31,192,0,7,240,0,0,0,0,31,192,0,7,224,0,0,0,0,31,192,0,11,224,0,0,0,0,31,192,0,11,224,0,0,0,0,31,192,0,11,224,0,0,0,191,255,255,207,255,255,255,192,0,191,255,255,207,255,255,255,192,0,191,255,255,207,255,255,255,192,0,0,31,192,0,11,224,15,192,0,0,31,192,0,15,208,15,192,0,0,31,192,0,15,208,15,192,0,0,31,193,128,15,192,15,192,0,0,31,255,193,15,192,15,192,0,0,127,255,207,239,192,15,192,0,111,255,255,175,255,192,15,192,0,255,255,228,7,255,128,15,192,0,255,255,192,0,191,224,15,192,0,185,31,192,0,127,253,15,192,0,0,31,192,0,255,255,143,192,0,0,31,192,2,252,191,207,194,64,0,31,192,7,248,31,79,195,240,0,31,192,31,240,2,11,211,240,31,255,192,191,208,0,7,231,224,15,255,64,255,64,0,3,255,208,11,249,0,61,0,0,2,255,192,0,0,0,16,0,0,0,190,0,0,228,0,0,0,0,2,192,0,1,252,7,240,15,224,15,224,0,3,248,7,240,11,240,11,244,0,11,240,3,240,3,244,3,252,0,15,224,3,244,3,248,1,254,0,63,192,3,244,2,252,0,191,64,191,128,3,244,1,252,0,63,192,255,0,3,248,0,253,0,47,192,29,0,1,80,0,80,0,13,0,0,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,32,36,32,37,1,252,0,0,0,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,234,170,171,254,170,170,0,31,255,255,255,255,255,255,0,31,255,255,255,255,255,255,0,31,255,255,255,255,255,255,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,234,170,170,171,252,0,0,127,64,0,0,2,252,0,0,191,0,0,0,2,252,0,0,255,0,0,0,2,252,0,0,254,0,0,0,2,252,0,2,253,0,0,0,2,252,0,3,252,0,0,0,2,252,0,11,248,0,0,0,2,252,0,31,240,0,0,0,2,252,0,63,224,0,0,0,2,252,0,127,192,0,0,0,2,252,0,31,64,0,0,0,2,252,0,6,0,0,0,0,2,252,0,0,0,0,0,0,0,0,0,
  // 0x7269  物
  105,114,34,35,59,37,1,253,0,3,244,0,11,128,0,0,0,0,3,244,0,15,208,0,0,0,6,67,244,0,15,192,0,0,0,11,211,244,0,31,192,0,0,0,15,195,244,0,47,64,0,0,0,15,195,244,0,63,0,0,0,0,15,195,244,0,127,255,255,255,240,15,195,244,0,255,255,255,255,240,31,255,255,225,255,255,255,255,240,31,255,255,227,248,47,71,247,240,47,255,255,231,240,63,11,211,240,63,3,244,15,224,126,15,199,240,63,3,244,47,192,189,15,199,240,190,3,244,127,128,252,31,135,240,188,3,244,127,2,248,47,135,240,44,3,244,13,3,240,63,71,240,0,3,244,0,7,240,63,11,224,0,3,250,244,15,208,190,11,224,0,3,255,244,47,192,253,11,224,0,111,255,248,63,65,252,15,208,27,255,255,144,255,3,248,15,208,127,255,244,2,252,3,240,15,208,63,251,244,7,248,11,240,15,208,61,3,244,31,240,15,208,15,192,0,3,244,47,192,47,192,15,192,0,3,244,3,0,127,64,31,192,0,3,244,0,0,255,0,47,192,0,3,244,0,2,253,0,47,128,0,3,244,0,7,248,0,63,128,0,3,244,0,31,240,0,127,64,0,3,244,0,127,192,0,255,0,0,3,244,1,255,65,255,255,0,0,3,244,0,189,0,255,252,0,0,3,244,0,36,0,255,244,0,0,3,244,0,0,0,20,0,0,
  // 0x7279  特
  121,114,35,35,59,37,1,253,0,3,244,0,0,11,224,0,0,0,3,244,0,0,15,224,0,0,10,131,244,0,0,15,224,0,0,15,195,244,0,0,15,224,0,0,15,195,244,2,255,255,255,255,192,15,195,244,2,255,255,255,255,192,15,195,244,2,255,255,255,255,192,31,215,249,80,0,15,224,0,0,31,255,255,224,0,15,224,0,0,47,255,255,224,0,15,224,0,0,63,255,255,224,0,15,224,0,0,63,3,244,63,255,255,255,255,244,126,3,244,63,255,255,255,255,244,189,3,244,63,255,255,255,255,244,124,3,244,0,0,0,7,244,0,8,3,244,0,0,0,7,240,0,0,3,244,16,0,0,7,240,0,0,3,250,244,0,0,7,240,0,0,3,255,248,0,0,7,244,0,0,191,255,255,255,255,255,255,240,111,255,254,95,255,255,255,255,240,127,255,244,15,255,255,255,255,240,63,231,244,0,0,0,7,240,0,41,3,244,0,124,0,7,240,0,0,3,244,0,254,0,7,240,0,0,3,244,0,127,128,7,240,0,0,3,244,0,47,208,7,240,0,0,3,244,0,15,240,7,240,0,0,3,244,0,3,244,7,240,0,0,3,244,0,2,192,7,240,0,0,3,244,0,0,0,7,240,0,0,3,244,0,0,21,91,240,0,0,3,244,0,0,31,255,240,0,0,3,244,0,0,15,255,224,0,0,3,244,0,0,15,254,64,0,
  // 0x7387  率
  135,115,33,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,47,255,255,255,255,255,255,255,0,0,0,0,47,192,0,0,0,0,1,0,0,63,64,0,0,224,0,15,192,0,254,2,64,3,253,0,47,248,10,252,7,240,15,248,0,7,255,47,240,15,208,63,208,0,0,255,239,240,63,129,255,64,0,0,47,7,253,190,0,188,0,0,0,4,0,255,252,0,0,0,0,0,0,0,63,242,208,0,0,0,0,1,128,31,199,240,244,0,0,0,31,208,63,2,255,255,64,0,2,255,224,253,85,254,255,224,0,127,255,191,255,255,255,31,253,0,191,228,127,255,255,255,130,255,128,62,0,63,170,164,15,192,127,64,16,0,0,7,240,10,0,28,0,0,0,0,7,240,0,0,0,0,0,0,0,7,244,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x73af  环
  175,115,34,32,32,37,1,253,127,255,255,47,255,255,255,255,240,127,255,255,47,255,255,255,255,240,127,255,255,47,255,255,255,255,240,0,127,0,0,0,15,240,0,0,0,127,0,0,0,31,224,0,0,0,127,0,0,0,47,192,0,0,0,127,0,0,0,63,128,0,0,0,127,0,0,0,191,64,0,0,0,127,0,0,1,255,64,0,0,0,127,0,0,3,255,173,0,0,63,255,252,0,7,255,255,64,0,63,255,252,0,15,255,191,192,0,63,255,252,0,63,255,95,240,0,0,127,0,0,191,255,75,248,0,0,127,0,1,255,63,67,253,0,0,127,0,3,253,63,64,255,0,0,127,0,15,248,63,64,127,192,0,127,0,127,240,63,64,47,224,0,127,0,191,192,63,64,15,240,0,127,0,47,0,63,64,7,128,0,127,0,13,0,63,64,1,0,0,127,110,0,0,63,64,0,0,0,127,255,0,0,63,64,0,0,6,255,255,0,0,63,64,0,0,127,255,228,0,0,63,64,0,0,127,253,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,36,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,
  // 0x7528  用
  40,117,32,34,16,37,1,252,0,21,85,85,85,85,85,85,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,254,0,0,191,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,127,0,0,253,0,0,191,0,191,255,255,255,255,255,255,0,191,255,255,255,255,255,255,0,255,255,255,255,255,255,255,0,254,85,85,254,85,85,191,0,253,0,0,253,0,0,191,1,252,0,0,253,0,0,191,2,252,0,0,253,0,0,191,3,248,0,0,253,0,0,191,3,244,0,0,253,0,0,191,11,240,0,0,253,0,0,191,15,240,0,0,253,0,0,191,47,208,0,0,253,5,65,255,127,192,0,0,253,11,255,254,127,64,0,0,253,7,255,252,14,0,0,0,189,3,255,224,0,0,0,0,0,0,0,0,
  // 0x7535  电
  53,117,32,35,24,37,4,253,0,0,0,106,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,21,85,85,191,85,85,85,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,0,0,191,0,0,127,0,127,0,0,191,0,0,127,0,127,0,0,191,0,0,127,0,127,0,0,191,0,0,127,0,127,0,0,191,0,0,191,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,0,0,191,0,0,127,0,127,0,0,191,0,0,127,0,127,0,0,191,0,0,127,0,127,0,0,191,0,0,127,0,127,85,85,191,85,85,191,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,0,127,0,0,191,0,0,0,128,127,0,0,191,0,0,0,253,21,0,0,191,0,0,0,253,0,0,0,191,0,0,0,253,0,0,0,191,0,0,1,252,0,0,0,127,128,0,3,252,0,0,0,127,255,255,255,248,0,0,0,63,255,255,255,240,0,0,0,11,255,255,255,208,0,0,0,0,85,85,85,0,
  // 0x7565  略
  101,117,33,36,68,37,3,252,0,0,0,0,3,144,0,0,0,0,0,0,0,11,240,0,0,0,255,255,255,64,15,224,0,0,0,255,255,255,64,47,192,0,0,0,255,255,255,64,63,255,255,244,0,244,60,31,64,255,255,255,252,0,244,60,31,66,255,255,255,244,0,244,60,31,71,252,0,15,240,0,244,60,31,95,254,0,31,208,0,244,60,31,191,255,64,63,192,0,244,60,31,255,175,192,255,0,0,244,60,31,254,15,242,253,0,0,244,60,31,120,7,255,248,0,0,255,255,255,64,2,255,240,0,0,255,255,255,64,0,255,192,0,0,255,255,255,64,2,255,244,0,0,244,60,31,64,15,255,254,0,0,244,60,31,64,191,242,255,208,0,244,60,31,71,255,128,127,253,0,244,60,31,191,253,0,15,255,192,244,60,31,255,224,0,1,255,64,244,60,31,255,255,255,255,254,0,244,60,31,103,255,255,255,244,0,244,60,31,71,255,255,255,244,0,255,255,255,71,240,0,3,244,0,255,255,255,71,240,0,3,244,0,255,255,255,71,240,0,3,244,0,244,0,0,7,240,0,3,244,0,244,0,0,7,240,0,3,244,0,244,0,0,7,240,0,3,244,0,244,0,0,7,240,0,3,244,0,0,0,0,7,255,255,255,244,0,0,0,0,7,255,255,255,244,0,0,0,0,7,255,255,255,244,0,0,0,0,7,240,0,3,244,0,0,0,0,0,0,0,0,0,0,
  // 0x767d  白
  125,118,27,36,252,37,5,252,0,0,3,228,0,0,0,0,0,7,252,0,0,0,0,0,11,248,0,0,0,0,0,15,240,0,0,0,0,0,31,240,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,85,85,85,85,87,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,254,85,85,85,85,87,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,85,85,85,85,87,252,254,0,0,0,0,2,252,254,0,0,0,0,2,252,0,0,0,0,0,0,0,
  // 0x7684  的
  132,118,32,35,24,37,3,253,0,30,128,0,7,144,0,0,0,47,192,0,11,240,0,0,0,63,128,0,15,224,0,0,0,63,64,0,15,208,0,0,0,127,0,0,31,192,0,0,0,190,0,0,63,192,0,0,255,255,255,208,63,255,255,253,255,255,255,208,191,255,255,253,255,255,255,208,255,255,255,253,253,0,15,209,253,0,0,253,253,0,15,211,248,0,0,253,253,0,15,219,240,0,0,252,253,0,15,239,224,0,0,252,253,0,15,239,192,0,0,252,253,0,15,210,66,0,0,252,253,0,15,208,31,128,0,252,255,255,255,208,31,208,0,252,255,255,255,208,11,240,0,252,255,255,255,208,3,252,0,252,253,0,15,208,1,254,1,252,253,0,15,208,0,191,1,252,253,0,15,208,0,63,193,252,253,0,15,208,0,47,194,248,253,0,15,208,0,15,66,248,253,0,15,208,0,4,2,248,253,0,15,208,0,0,3,248,253,0,15,208,0,0,3,244,253,0,15,208,0,0,3,244,255,255,255,208,0,0,7,240,255,255,255,208,0,0,11,240,255,255,255,208,0,0,31,224,253,0,0,0,2,255,255,208,253,0,0,0,0,255,255,192,253,0,0,0,0,255,254,0,0,0,0,0,0,0,0,0,
  // 0x76d1  监
  209,118,33,34,50,37,2,254,0,0,31,192,0,164,0,0,0,6,160,31,192,0,254,0,0,0,11,240,31,192,1,252,0,0,0,11,240,31,192,2,252,0,0,0,11,240,31,192,3,248,0,0,0,11,240,31,192,7,255,255,255,192,11,240,31,192,11,255,255,255,192,11,240,31,192,15,255,255,255,192,11,240,31,192,47,192,0,0,0,11,240,31,192,63,128,0,0,0,11,240,31,192,191,2,128,0,0,11,240,31,193,254,15,224,0,0,11,240,31,195,252,15,252,0,0,11,240,31,207,244,3,255,64,0,11,240,31,195,224,0,191,208,0,11,240,31,192,128,0,47,244,0,11,224,31,192,0,0,11,248,0,0,0,31,192,0,0,2,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,224,0,0,255,255,255,255,255,255,224,0,0,252,2,244,7,240,15,224,0,0,252,2,244,7,240,15,224,0,0,252,2,244,7,240,15,224,0,0,252,2,244,7,240,15,224,0,0,252,2,244,7,240,15,224,0,0,252,2,244,7,240,15,224,0,0,252,2,244,7,240,15,224,0,0,252,2,244,7,240,15,224,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x76f4  直
  244,118,33,35,59,37,2,253,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,7,244,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,26,175,250,170,170,64,0,5,80,63,255,255,255,255,128,0,15,224,63,255,255,255,255,128,0,15,224,63,64,0,0,47,128,0,15,224,63,64,0,0,47,128,0,15,224,63,149,85,85,127,128,0,15,224,63,255,255,255,255,128,0,15,224,63,255,255,255,255,128,0,15,224,63,64,0,0,47,128,0,15,224,63,64,0,0,47,128,0,15,224,63,149,85,85,127,128,0,15,224,63,255,255,255,255,128,0,15,224,63,255,255,255,255,128,0,15,224,63,64,0,0,47,128,0,15,224,63,64,0,0,47,128,0,15,224,63,170,170,170,191,128,0,15,224,63,255,255,255,255,128,0,15,224,63,255,255,255,255,128,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,
  // 0x7701  省
  1,119,34,35,59,37,1,253,0,0,0,0,252,0,0,0,0,0,0,0,0,252,0,0,0,0,0,0,184,0,252,0,61,0,0,0,1,254,0,252,0,255,128,0,0,7,252,0,252,0,63,240,0,0,31,240,0,252,0,15,252,0,0,127,208,0,252,0,2,255,64,2,255,64,0,252,0,224,191,208,31,253,0,1,252,3,253,47,240,47,244,7,255,252,31,248,11,208,7,192,3,255,252,191,224,1,0,1,0,2,255,171,255,64,0,0,0,0,0,1,191,248,0,0,0,0,0,0,111,255,208,0,0,0,0,0,111,255,249,0,0,0,0,5,175,255,255,250,170,170,144,0,127,255,255,255,255,255,255,224,0,47,255,255,255,255,255,255,224,0,15,229,252,0,0,0,15,224,0,0,0,252,0,0,0,15,224,0,0,0,252,0,0,0,15,224,0,0,0,255,255,255,255,255,224,0,0,0,255,255,255,255,255,224,0,0,0,254,85,85,85,95,224,0,0,0,252,0,0,0,15,224,0,0,0,252,0,0,0,15,224,0,0,0,255,255,255,255,255,224,0,0,0,255,255,255,255,255,224,0,0,0,254,85,85,85,95,224,0,0,0,252,0,0,0,15,224,0,0,0,252,0,0,0,15,224,0,0,0,255,255,255,255,255,224,0,0,0,255,255,255,255,255,224,0,0,0,254,170,170,170,175,224,0,0,0,252,0,0,0,11,224,0,
  // 0x7720  眠
  32,119,34,33,41,37,2,253,127,255,253,11,255,255,255,255,64,127,255,253,11,255,255,255,255,64,127,255,253,11,255,255,255,255,64,127,0,189,11,224,0,0,63,64,127,0,189,11,224,0,0,63,64,127,0,189,11,224,0,0,63,64,127,0,189,11,224,0,0,63,64,127,0,189,11,240,0,0,63,64,127,255,253,11,255,255,255,255,64,127,255,253,11,255,255,255,255,64,127,255,253,11,255,255,255,255,64,127,0,189,11,224,7,240,0,0,127,0,189,11,224,3,240,0,0,127,0,189,11,224,3,240,0,0,127,0,189,11,224,3,240,0,0,127,0,189,11,240,7,244,0,0,127,255,253,11,255,255,255,255,208,127,255,253,11,255,255,255,255,208,127,255,253,11,255,255,255,255,208,127,0,189,11,224,2,248,0,0,127,0,189,11,224,1,252,0,0,127,0,189,11,224,1,252,0,0,127,0,189,11,224,0,252,0,0,127,0,189,11,224,0,253,0,0,127,255,253,11,224,0,190,0,0,127,255,253,11,224,0,127,1,208,127,255,253,11,224,0,63,2,240,127,0,0,11,224,107,127,130,240,127,0,0,11,255,255,95,195,240,63,0,2,255,255,255,79,247,240,0,0,2,255,255,249,7,255,208,0,0,1,255,228,0,2,255,192,0,0,0,144,0,0,0,127,0,
  // 0x786e  确
  110,120,33,36,68,37,1,252,0,0,0,0,1,228,0,0,0,0,0,0,0,2,252,0,0,0,63,255,255,248,3,244,0,0,0,63,255,255,248,11,255,255,64,0,63,255,255,248,15,255,255,224,0,0,63,128,0,31,255,255,208,0,0,63,64,0,63,128,63,192,0,0,63,0,0,191,0,63,64,0,0,127,0,1,254,0,191,0,0,0,190,0,3,252,1,252,0,0,0,253,0,15,255,255,255,255,192,0,252,0,31,255,255,255,255,192,1,252,0,11,255,255,255,255,192,2,255,255,225,252,3,240,15,192,3,255,255,224,252,3,240,15,192,3,255,255,224,252,3,240,15,192,11,248,7,224,255,171,250,175,192,15,248,7,224,255,255,255,255,192,31,248,7,224,255,255,255,255,192,63,248,7,224,252,3,240,15,192,127,248,7,224,252,3,240,15,192,255,248,7,224,252,3,240,15,192,127,248,7,224,252,3,240,15,192,45,248,7,224,255,255,255,255,192,5,248,7,225,255,255,255,255,192,1,248,7,225,255,255,255,255,192,1,248,7,226,248,0,0,15,192,1,255,255,227,244,0,0,15,192,1,255,255,231,240,0,0,15,192,1,255,255,235,240,0,0,15,192,1,248,0,15,224,0,0,15,192,1,248,0,47,192,0,0,31,192,1,248,0,127,128,0,31,255,192,0,0,0,63,0,0,15,255,192,0,0,0,8,0,0,15,254,0,0,0,0,0,0,0,0,0,0,
  // 0x79bb  离
  187,121,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,191,255,255,255,255,255,255,255,128,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,0,0,64,0,0,0,0,106,1,128,3,240,42,64,0,0,127,3,249,31,208,63,128,0,0,127,7,255,255,64,63,128,0,0,127,0,47,254,0,63,128,0,0,127,0,127,255,208,63,128,0,0,127,11,255,111,244,63,128,0,0,127,47,244,3,240,63,128,0,0,127,11,64,0,144,63,128,0,0,127,170,170,170,170,191,128,0,0,127,255,255,255,255,255,128,0,0,127,255,255,255,255,255,128,0,0,0,0,47,208,0,0,0,0,0,0,0,63,192,0,0,0,0,11,255,255,255,255,255,255,248,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,11,240,0,254,0,176,3,252,0,11,240,0,253,2,248,3,252,0,11,240,1,252,0,253,3,252,0,11,240,2,248,21,191,3,252,0,11,243,255,255,255,255,131,252,0,11,243,255,255,255,255,211,252,0,11,243,255,234,148,7,227,252,0,11,240,0,0,0,3,67,252,0,11,240,0,0,0,0,3,252,0,11,240,0,0,0,7,255,248,0,11,240,0,0,0,3,255,244,0,11,240,0,0,0,1,255,144,0,
  // 0x79fb  移
  251,121,34,35,59,37,1,253,0,0,1,0,0,15,144,0,0,0,0,111,192,0,47,192,0,0,0,111,255,240,0,127,128,0,0,63,255,255,208,1,255,255,254,0,63,255,244,0,7,255,255,255,128,47,155,240,0,47,255,255,255,0,0,7,240,0,191,192,0,254,0,0,7,240,7,255,192,2,252,0,0,7,240,47,255,240,7,248,0,0,7,240,15,231,253,31,240,0,0,11,240,3,0,255,191,192,0,63,255,255,240,0,63,255,64,0,63,255,255,240,0,15,253,0,0,63,255,255,240,0,191,240,0,0,0,15,240,0,7,255,208,0,0,0,31,240,1,255,255,253,0,0,0,63,248,15,255,227,252,0,0,0,127,254,3,254,11,240,0,0,0,255,255,130,144,47,255,255,224,1,255,255,208,0,191,255,255,240,3,251,247,244,2,255,255,255,240,7,231,242,244,15,248,0,31,208,15,199,240,224,191,240,0,63,192,47,135,240,71,255,253,0,191,64,127,71,240,7,254,255,129,255,0,190,7,240,2,208,127,231,252,0,60,7,240,0,0,15,255,244,0,36,7,240,0,0,2,255,208,0,0,7,240,0,0,7,255,64,0,0,7,240,0,0,127,252,0,0,0,7,240,0,7,255,224,0,0,0,7,240,6,255,255,64,0,0,0,7,240,47,255,244,0,0,0,0,7,240,15,254,0,0,0,0,0,7,240,7,144,0,0,0,0,
  // 0x7a7a  空
  122,122,33,34,50,37,2,254,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,64,11,240,3,240,0,127,0,63,64,11,240,3,240,0,127,0,63,64,15,224,3,240,0,127,0,63,64,15,208,3,240,0,127,0,63,64,47,192,3,240,0,0,0,0,0,63,192,3,240,0,32,0,0,0,255,64,3,240,0,63,0,0,7,254,0,3,244,0,127,0,0,191,248,0,3,255,255,254,0,47,255,224,0,2,255,255,252,0,63,255,64,0,0,191,255,244,0,15,228,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,208,0,0,191,255,255,255,255,255,208,0,0,191,255,255,255,255,255,208,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,
  // 0x7aef  端
  239,122,35,35,59,37,1,253,0,5,0,0,0,15,192,0,0,0,47,64,0,0,15,192,0,0,0,47,64,11,224,15,192,15,192,0,47,64,11,224,15,192,15,192,0,47,64,11,224,15,192,15,192,0,47,64,11,224,15,192,15,192,0,47,64,11,224,15,192,15,192,0,47,64,11,224,15,192,15,192,63,255,255,139,255,255,255,255,192,63,255,255,139,255,255,255,255,192,63,255,255,139,255,255,255,255,192,0,0,0,0,0,0,0,0,0,6,0,57,0,0,0,0,0,0,31,64,127,0,0,0,0,0,0,15,128,126,63,255,255,255,255,244,15,128,189,63,255,255,255,255,244,15,192,189,63,255,255,255,255,244,11,192,252,0,0,47,192,0,0,11,192,252,0,0,63,192,0,0,7,208,252,0,0,63,64,0,0,7,209,248,15,255,255,255,255,224,3,225,244,15,255,255,255,255,224,3,226,240,15,255,255,255,255,224,3,211,240,15,193,244,63,7,224,0,3,246,223,193,244,63,7,224,0,7,255,223,193,244,63,7,224,27,255,255,239,193,244,63,7,224,191,255,254,79,193,244,63,7,224,127,254,64,15,193,244,63,7,224,62,64,0,15,193,244,63,7,224,0,0,0,15,193,244,63,7,224,0,0,0,15,193,244,63,7,224,0,0,0,15,193,244,63,111,224,0,0,0,15,193,244,63,127,208,0,0,0,10,128,80,0,63,64,
  // 0x7b2c  第
  44,123,34,35,59,37,1,253,0,46,64,0,0,248,0,0,0,0,63,128,0,1,253,0,0,0,0,127,64,0,3,252,0,0,0,0,255,170,170,135,254,170,170,160,2,255,255,255,207,255,255,255,240,3,255,255,255,239,255,255,255,240,15,241,252,0,191,130,252,0,0,63,208,254,2,255,0,255,0,0,127,128,127,2,252,0,63,64,0,30,0,56,0,112,0,41,0,0,0,255,255,255,255,255,255,248,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,0,0,0,252,0,2,252,0,0,0,0,0,252,0,2,252,0,0,0,0,0,252,0,2,252,0,0,31,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,255,255,255,255,255,252,0,0,63,0,0,252,0,0,0,0,0,127,0,0,252,0,0,0,0,0,191,0,0,252,0,0,0,0,0,255,255,255,255,255,255,255,192,0,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,192,2,252,0,191,252,0,0,63,128,0,0,3,255,252,0,0,63,128,0,0,47,249,252,0,0,63,64,0,1,255,208,252,0,0,127,64,0,31,255,0,252,0,0,191,0,1,255,248,0,252,3,255,255,0,47,255,128,0,252,1,255,253,0,15,252,0,0,252,0,255,244,0,7,128,0,0,252,0,0,0,0,0,0,0,0,252,0,0,0,0,
  // 0x7b49  等
  73,123,34,35,59,37,1,253,0,30,64,0,0,249,0,0,0,0,63,192,0,1,253,0,0,0,0,127,64,0,2,252,0,0,0,0,255,255,255,199,255,255,255,240,1,255,255,255,207,255,255,255,240,3,255,255,255,239,255,255,255,240,15,240,252,0,191,130,252,0,0,63,208,254,1,255,0,255,0,0,191,128,127,0,253,0,127,64,0,31,0,56,1,252,0,61,0,0,0,0,0,1,252,0,0,0,0,0,127,255,255,255,255,255,248,0,0,127,255,255,255,255,255,252,0,0,127,255,255,255,255,255,252,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,0,0,124,0,0,3,248,0,0,0,1,255,64,0,3,248,0,0,0,0,191,208,0,3,248,0,0,0,0,31,244,0,3,248,0,0,0,0,7,253,0,3,248,0,0,0,0,1,253,0,7,248,0,0,0,0,0,176,31,255,244,0,0,0,0,0,0,15,255,240,0,0,0,0,0,0,11,255,128,0,0,
  // 0x7bb1  箱
  177,123,34,35,59,37,1,253,0,30,0,0,0,228,0,0,0,0,47,192,0,0,254,0,0,0,0,63,128,0,1,252,0,0,0,0,127,64,0,3,252,0,0,0,0,255,255,255,199,255,255,255,240,1,255,255,255,207,255,255,255,240,3,255,255,255,239,255,255,255,240,11,244,253,0,127,194,252,0,0,31,224,191,0,255,0,255,0,0,127,192,63,2,253,0,63,64,0,47,64,62,0,116,0,46,64,0,5,1,252,0,0,0,0,0,0,0,1,252,0,47,255,255,255,192,0,1,252,0,47,255,255,255,192,0,2,252,0,47,255,255,255,192,47,255,255,255,111,128,0,47,192,47,255,255,255,111,128,0,47,192,47,255,255,255,111,128,0,47,192,0,7,252,0,47,234,170,191,192,0,15,253,0,47,255,255,255,192,0,31,255,64,47,255,255,255,192,0,63,255,208,47,128,0,47,192,0,127,255,244,47,128,0,47,192,0,255,254,254,47,128,0,47,192,2,253,252,255,111,234,170,191,192,7,245,252,63,47,255,255,255,192,31,225,252,28,47,255,255,255,192,63,193,252,0,47,128,0,47,192,127,65,252,0,47,128,0,47,192,46,1,252,0,47,128,0,47,192,8,1,252,0,47,255,255,255,192,0,1,252,0,47,255,255,255,192,0,1,252,0,47,255,255,255,192,0,1,252,0,47,128,0,47,192,0,1,252,0,26,64,0,21,64,
  // 0x7c7b  类
  123,124,34,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,11,0,7,240,0,126,0,0,0,63,192,7,240,0,255,64,0,0,31,240,7,240,2,253,0,0,0,11,248,7,240,7,248,0,0,0,3,252,7,240,15,240,0,0,0,0,248,7,240,31,192,0,0,63,255,255,255,255,255,255,255,128,63,255,255,255,255,255,255,255,128,63,255,255,255,255,255,255,255,128,0,0,2,255,255,224,0,0,0,0,0,11,255,255,248,0,0,0,0,0,127,247,243,255,64,0,0,0,2,255,135,240,191,240,0,0,0,111,254,7,240,31,255,64,0,7,255,244,7,240,3,255,254,64,255,255,128,7,240,0,127,255,128,63,248,0,1,80,0,7,255,0,31,128,0,2,160,63,64,29,0,0,0,0,7,240,127,244,0,0,0,0,0,11,240,7,255,0,0,0,0,0,11,240,0,188,0,0,127,255,255,255,255,255,255,255,128,127,255,255,255,255,255,255,255,128,127,255,255,255,255,255,255,255,128,0,0,0,127,255,0,0,0,0,0,0,0,255,191,192,0,0,0,0,0,3,254,47,224,0,0,0,0,0,31,252,15,253,0,0,0,0,1,255,244,3,255,208,0,0,0,111,255,208,0,255,254,64,0,175,255,254,0,0,47,255,255,144,255,255,224,0,0,2,255,255,192,63,253,0,0,0,0,31,255,0,42,64,0,0,0,0,0,90,0,
  // 0x7d22  索
  34,125,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,63,255,255,255,255,255,255,255,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,64,63,0,0,255,64,0,0,63,64,63,0,3,254,0,16,0,63,64,63,0,15,248,0,188,0,63,64,63,9,63,224,2,255,0,63,64,63,63,255,64,15,252,0,63,64,0,63,253,0,127,224,0,0,0,0,7,255,1,255,129,0,0,0,0,0,191,219,253,11,192,0,0,0,0,31,255,224,31,244,0,0,0,0,7,255,64,7,254,0,0,0,0,31,252,0,0,255,192,0,127,255,255,255,255,255,255,244,0,127,255,255,255,255,255,255,254,0,127,255,255,255,255,250,170,255,64,0,0,64,7,240,0,0,61,0,0,2,248,7,240,11,192,0,0,0,15,252,7,240,47,248,0,0,0,127,240,7,240,7,255,128,0,7,255,128,7,240,0,191,240,0,127,253,0,7,240,0,15,253,0,255,224,0,7,240,0,2,255,64,47,64,0,7,240,0,0,125,0,4,0,0,7,240,0,0,0,0,
  // 0x7d2b  紫
  43,125,34,35,59,37,1,253,0,0,63,0,3,244,0,0,0,0,0,63,0,3,244,0,0,0,0,0,63,0,3,244,0,24,0,3,240,63,0,3,244,1,254,0,3,240,63,255,211,244,111,255,128,3,240,63,255,211,255,255,253,0,3,240,63,255,211,255,254,64,0,3,240,63,0,3,254,64,0,0,3,240,63,0,3,244,0,2,0,3,240,63,0,83,244,0,3,240,3,240,127,255,227,248,0,7,240,27,255,255,255,227,255,255,255,240,127,255,255,255,65,255,255,255,208,127,255,164,31,144,127,255,255,64,41,64,0,127,192,0,0,0,0,0,0,1,255,0,30,0,0,0,0,7,75,252,0,191,208,0,0,0,31,255,224,2,255,64,0,0,0,47,255,128,15,252,0,0,0,0,2,255,224,127,224,40,0,0,0,0,47,254,255,65,255,0,0,0,0,7,255,252,0,191,192,0,0,0,0,255,208,0,31,244,0,63,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,208,21,64,0,1,253,0,0,15,240,0,0,16,1,252,0,16,7,128,0,1,254,1,252,2,253,0,0,0,11,254,1,252,7,255,128,0,0,127,244,1,252,0,127,244,0,7,255,192,1,252,0,11,255,0,47,254,0,1,252,0,1,255,208,11,240,0,1,252,0,0,47,128,2,64,0,1,252,0,0,5,0,
  // 0x7ea2  红
  162,126,35,34,50,37,1,254,0,1,128,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,15,240,1,85,85,85,85,64,0,31,224,7,255,255,255,255,224,0,63,192,7,255,255,255,255,224,0,127,128,7,255,255,255,255,224,0,255,0,0,0,11,240,0,0,1,253,3,128,0,11,240,0,0,3,248,7,244,0,11,240,0,0,11,240,15,240,0,11,240,0,0,31,208,47,224,0,11,240,0,0,191,255,255,192,0,11,240,0,0,127,255,255,0,0,11,240,0,0,63,255,253,0,0,11,240,0,0,41,71,248,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,63,192,0,0,11,240,0,0,0,255,64,0,0,11,240,0,0,3,253,0,80,0,11,240,0,0,11,254,191,240,0,11,240,0,0,63,255,255,240,0,11,240,0,0,63,255,255,224,0,11,240,0,0,63,254,144,0,0,11,240,0,0,41,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,27,208,0,11,240,0,0,0,107,255,224,0,11,240,0,0,127,255,255,239,255,255,255,255,244,127,255,254,79,255,255,255,255,244,63,254,64,15,255,255,255,255,244,57,64,0,5,85,85,85,85,80,0,0,0,0,0,0,0,0,0,
  // 0x7ea7  级
  167,126,35,36,68,37,1,252,0,2,64,0,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,15,224,15,255,255,255,240,0,0,31,192,15,255,255,255,240,0,0,63,128,15,255,255,255,224,0,0,127,0,0,31,192,15,208,0,0,254,0,0,31,192,31,192,0,1,252,2,0,31,192,47,192,0,3,248,11,192,31,192,63,128,0,7,240,15,224,31,192,63,64,0,15,208,63,192,47,192,127,0,0,63,213,191,64,47,128,190,0,0,191,255,254,0,47,128,255,255,128,127,255,252,0,63,128,255,255,192,63,235,244,0,63,193,255,255,192,16,15,224,0,63,224,0,47,128,0,47,192,0,63,240,0,63,64,0,127,0,0,127,244,0,127,0,0,253,27,192,191,252,0,191,0,3,254,255,192,191,253,0,253,0,15,255,255,192,253,191,2,252,0,127,255,244,0,253,63,131,248,0,127,249,0,1,252,47,203,240,0,62,64,0,2,252,15,255,224,0,16,0,1,211,248,7,255,192,0,0,0,111,231,240,2,255,64,0,0,11,255,255,240,2,255,64,0,1,255,255,159,224,11,255,208,0,47,255,228,47,192,63,255,248,0,63,254,0,127,129,255,199,255,0,63,208,0,255,11,255,1,255,224,40,0,2,254,63,252,0,63,244,0,0,1,252,15,208,0,11,208,0,0,0,36,7,0,0,1,128,0,0,0,0,0,0,0,0,0,
  // 0x7ebf  线
  191,126,34,35,59,37,2,253,0,5,0,0,2,252,0,0,0,0,15,208,0,2,252,61,0,0,0,15,224,0,2,252,191,192,0,0,47,192,0,2,252,47,244,0,0,63,128,0,2,252,3,244,0,0,127,0,0,2,252,0,160,0,0,254,0,0,1,252,0,24,0,1,252,0,0,1,253,191,254,0,3,248,13,0,107,255,255,254,0,7,240,31,143,255,255,255,249,0,15,208,63,203,255,255,164,0,0,63,128,191,11,250,252,0,0,0,191,239,254,0,0,253,0,0,0,255,255,252,0,0,253,0,1,0,191,255,244,0,0,253,6,191,64,122,95,224,0,0,255,255,255,128,0,47,192,0,111,255,255,255,128,0,127,0,47,255,255,254,80,0,0,253,0,47,255,255,64,0,0,3,248,1,31,229,127,0,30,0,15,246,191,64,0,63,64,63,192,63,255,255,64,0,63,64,191,0,255,255,255,0,0,63,130,253,0,127,254,64,0,0,47,203,248,0,62,64,0,0,0,31,255,240,0,0,0,0,0,0,15,255,128,0,0,0,6,64,0,15,254,0,0,0,1,191,128,0,47,248,0,0,1,191,255,192,2,255,248,3,0,111,255,254,0,47,255,252,3,208,255,255,128,6,255,245,254,7,208,191,224,0,127,255,128,191,223,192,116,0,0,63,248,0,63,255,192,0,0,0,31,64,0,15,255,64,0,0,0,4,0,0,2,253,0,
  // 0x7ec6  细
  198,126,34,35,59,37,1,253,0,0,208,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,252,3,255,255,255,255,208,0,11,244,3,255,255,255,255,208,0,15,240,3,255,255,255,255,208,0,47,192,3,249,95,245,95,208,0,63,128,3,240,11,224,15,208,0,191,0,3,240,11,224,15,208,0,253,0,3,240,11,224,15,208,3,252,2,211,240,11,224,15,208,7,240,3,251,240,11,224,15,208,31,224,15,243,240,11,224,15,208,127,239,255,211,240,11,224,15,208,127,255,255,131,240,11,224,15,208,63,255,255,3,240,11,224,15,208,62,151,252,3,240,11,224,15,208,0,11,244,3,255,255,255,255,208,0,31,208,3,255,255,255,255,208,0,127,128,3,255,255,255,255,208,1,254,0,3,240,11,224,15,208,7,253,175,243,240,11,224,15,208,47,255,255,243,240,11,224,15,208,127,255,255,227,240,11,224,15,208,63,255,148,3,240,11,224,15,208,46,64,0,3,240,11,224,15,208,0,0,0,3,240,11,224,15,208,0,0,0,3,240,11,224,15,208,0,0,1,163,240,11,224,15,208,0,22,255,243,244,11,224,15,208,47,255,255,243,255,255,255,255,208,127,255,255,147,255,255,255,255,208,63,254,64,3,255,255,255,255,208,57,0,0,3,240,0,0,15,208,0,0,0,3,240,0,0,15,208,0,0,0,1,80,0,0,0,0,
  // 0x7ec8  终
  200,126,35,35,59,37,1,253,0,3,64,0,0,165,0,0,0,0,7,240,0,1,253,0,0,0,0,15,240,0,3,252,0,0,0,0,15,224,0,7,248,0,0,0,0,47,192,0,15,255,255,253,0,0,63,128,0,47,255,255,255,64,0,191,0,0,127,255,255,255,0,0,254,0,1,255,128,1,253,0,2,252,6,3,255,208,3,248,0,3,244,15,223,255,240,11,240,0,15,240,31,255,227,252,47,208,0,31,192,63,159,128,255,191,128,0,127,235,255,6,0,127,255,0,0,191,255,253,0,0,47,252,0,0,63,255,248,0,0,63,253,0,0,41,75,240,0,2,255,255,128,0,0,31,208,0,15,254,191,244,0,0,63,128,1,191,244,31,255,64,0,255,0,31,255,192,3,255,244,2,252,0,47,254,0,0,191,248,11,250,191,203,224,57,0,11,224,47,255,255,194,0,191,208,0,128,127,255,255,192,0,191,253,0,0,63,254,144,0,0,11,255,128,0,41,0,0,0,0,0,191,192,0,0,0,0,0,0,0,15,64,0,0,0,0,0,20,0,0,0,0,0,0,6,224,63,144,0,0,0,0,91,255,240,255,254,64,0,0,111,255,255,240,31,255,244,0,0,191,255,254,64,0,191,255,128,0,127,249,0,0,0,6,255,248,0,41,0,0,0,0,0,47,254,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,0,32,0,
  // 0x7ed3  结
  211,126,34,35,59,37,1,253,0,2,0,0,0,11,240,0,0,0,7,224,0,0,11,240,0,0,0,15,240,0,0,11,240,0,0,0,15,224,0,0,11,240,0,0,0,47,192,0,0,11,240,0,0,0,63,128,15,255,255,255,255,240,0,191,0,15,255,255,255,255,240,0,254,0,15,255,255,255,255,240,2,252,3,69,85,95,245,85,80,3,248,11,240,0,11,240,0,0,15,240,15,240,0,11,240,0,0,47,208,63,192,0,11,240,0,0,191,255,255,128,0,11,240,0,0,191,255,255,0,0,15,240,0,0,63,255,253,3,255,255,255,255,192,62,91,248,3,255,255,255,255,192,0,15,240,3,255,255,255,255,192,0,63,192,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,3,253,5,160,0,0,0,0,0,15,255,255,240,255,255,255,255,64,127,255,255,240,255,255,255,255,64,63,255,254,64,255,255,255,255,64,63,249,0,0,253,0,0,63,64,25,0,0,0,253,0,0,63,64,0,0,0,0,253,0,0,63,64,0,0,0,0,253,0,0,63,64,0,0,27,240,253,0,0,63,64,0,111,255,240,253,0,0,63,64,127,255,255,244,253,0,0,63,64,127,255,254,64,255,255,255,255,64,127,250,64,0,255,255,255,255,64,57,0,0,0,255,255,255,255,64,0,0,0,0,253,0,0,63,64,0,0,0,0,253,0,0,42,64,
  // 0x7ed9  给
  217,126,34,36,68,37,1,252,0,3,64,0,0,14,64,0,0,0,7,240,0,0,47,192,0,0,0,15,240,0,0,63,192,0,0,0,15,208,0,0,127,224,0,0,0,47,192,0,0,255,244,0,0,0,63,128,0,1,255,252,0,0,0,191,0,0,3,252,254,0,0,0,253,0,0,11,244,127,64,0,2,252,11,128,31,224,47,208,0,7,244,15,224,63,192,15,244,0,15,224,63,192,255,0,3,253,0,47,213,191,67,253,0,1,255,128,191,255,255,31,255,255,255,255,240,127,255,252,127,255,255,255,239,224,63,255,248,63,239,255,255,199,192,20,15,240,14,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,3,252,22,193,255,255,255,252,0,15,255,255,193,255,255,255,252,0,63,255,255,193,255,255,255,252,0,63,255,249,1,252,0,2,252,0,63,228,0,1,252,0,2,252,0,24,0,0,1,252,0,2,252,0,0,0,0,1,252,0,2,252,0,0,0,0,1,252,0,2,252,0,0,0,27,209,252,0,2,252,0,0,111,255,209,252,0,2,252,0,47,255,255,209,252,0,2,252,0,63,255,249,1,255,255,255,252,0,63,249,0,1,255,255,255,252,0,57,0,0,1,255,255,255,252,0,0,0,0,1,252,0,2,252,0,0,0,0,1,252,0,2,252,0,0,0,0,0,0,0,0,0,0,
  // 0x7edf  统
  223,126,35,35,59,37,1,253,0,3,128,0,0,27,0,0,0,0,7,244,0,0,63,128,0,0,0,15,240,0,0,31,192,0,0,0,31,224,0,0,15,224,0,0,0,47,192,0,0,11,208,0,0,0,63,128,15,255,255,255,255,240,0,191,0,15,255,255,255,255,240,1,254,0,15,255,255,255,255,240,3,252,15,128,1,255,0,0,0,7,244,31,224,3,253,0,64,0,15,224,63,192,11,248,7,224,0,63,213,191,64,31,240,7,244,0,191,255,255,0,63,192,2,252,0,127,255,252,0,255,64,0,254,0,63,255,248,3,255,90,191,255,64,20,15,240,47,255,255,255,255,192,0,47,192,31,255,255,255,255,208,0,127,64,15,255,169,64,11,240,0,254,0,9,26,128,105,3,192,3,253,111,128,31,192,191,0,0,15,255,255,128,31,192,191,0,0,63,255,255,192,47,192,191,0,0,63,255,228,0,47,128,191,0,0,63,228,0,0,63,128,191,0,0,24,0,0,0,63,64,191,0,0,0,0,0,64,127,0,191,0,0,0,0,31,192,191,0,191,1,208,0,7,255,192,254,0,191,2,244,2,255,255,194,253,0,191,2,244,63,255,248,7,252,0,191,2,244,63,254,64,47,244,0,127,3,240,63,208,1,255,224,0,127,255,240,36,0,2,255,128,0,63,255,224,0,0,0,253,0,0,31,255,128,0,0,0,32,0,0,0,0,0,
  // 0x7ee7  继
  231,126,35,33,41,37,1,255,0,6,0,0,0,0,104,0,0,0,11,224,5,64,0,189,0,0,0,15,224,15,192,0,189,0,0,0,31,192,15,194,192,189,7,128,0,63,128,15,195,208,189,11,192,0,63,0,15,195,224,189,15,128,0,191,0,15,193,240,189,31,64,0,253,0,15,192,244,189,47,0,2,252,10,15,192,248,189,61,0,3,240,15,207,192,188,189,124,0,11,224,47,207,192,80,189,20,0,31,192,63,79,192,0,189,0,0,127,234,255,15,207,255,255,255,240,127,255,252,15,207,255,255,255,240,63,255,248,15,207,255,255,255,240,41,75,240,15,192,3,255,0,0,0,31,192,15,192,7,255,192,0,0,63,64,15,192,15,255,224,0,0,254,0,15,192,31,254,248,0,2,252,1,79,192,63,189,189,0,7,250,191,143,192,189,189,63,0,47,255,255,143,193,252,189,31,192,127,255,254,79,195,244,189,15,224,63,249,64,15,203,224,189,3,208,41,0,0,15,199,192,189,2,64,0,0,0,15,194,0,189,0,0,0,0,0,79,192,0,189,0,0,0,0,111,207,192,0,189,0,0,1,175,255,207,192,0,125,0,0,127,255,255,143,192,0,0,0,0,63,255,144,15,255,255,255,255,244,63,144,0,15,255,255,255,255,244,16,0,0,15,255,255,255,255,244,
  // 0x7eea  绪
  234,126,35,35,59,37,1,253,0,3,64,0,0,190,0,0,0,0,7,240,0,0,190,0,0,0,0,15,224,0,0,190,0,11,144,0,15,192,0,0,190,0,31,208,0,47,128,3,255,255,255,127,192,0,63,64,3,255,255,255,255,64,0,191,0,3,255,255,255,255,0,0,253,0,0,0,190,2,253,0,1,252,7,0,0,190,7,248,0,3,244,15,208,0,190,15,240,0,11,224,31,192,0,190,47,208,0,15,192,63,128,0,191,127,192,0,47,214,191,63,255,255,255,255,244,191,255,253,63,255,255,255,255,244,63,255,252,63,255,255,255,255,244,62,155,240,0,0,127,208,0,0,0,15,208,0,2,255,64,0,0,0,63,128,0,31,252,0,0,0,0,191,0,0,191,255,255,255,64,1,252,1,11,255,255,255,255,64,7,250,255,191,255,255,255,255,64,31,255,255,191,255,64,0,63,64,63,255,254,47,127,64,0,63,64,63,249,64,4,63,64,0,63,64,41,0,0,0,63,234,170,191,64,0,0,0,0,63,255,255,255,64,0,0,0,64,63,255,255,255,64,0,0,111,208,63,64,0,63,64,1,111,255,224,63,64,0,63,64,63,255,255,144,63,64,0,63,64,63,255,144,0,63,255,255,255,64,63,144,0,0,63,255,255,255,64,20,0,0,0,63,255,255,255,64,0,0,0,0,63,64,0,63,64,0,0,0,0,26,64,0,21,0,
  // 0x7eed  续
  237,126,34,36,68,37,1,252,0,2,64,0,0,31,192,0,0,0,7,240,0,0,31,192,0,0,0,11,240,0,0,31,192,0,0,0,15,208,2,255,255,255,254,0,0,31,192,3,255,255,255,254,0,0,63,64,3,255,255,255,254,0,0,127,0,0,0,31,192,0,0,0,253,0,0,0,31,192,0,0,1,252,14,0,0,31,192,0,0,3,240,31,207,255,255,255,255,208,11,224,63,79,255,255,255,255,208,15,192,127,15,255,255,255,255,192,127,255,253,0,0,0,0,15,192,127,255,248,0,40,6,144,47,128,63,255,240,0,127,71,240,63,0,41,15,224,0,47,231,240,63,0,0,31,192,1,3,251,240,45,0,0,63,0,11,192,215,240,0,0,0,189,0,11,244,7,224,0,0,1,252,111,1,254,7,224,0,0,7,255,255,0,61,11,224,0,0,31,255,255,0,4,15,208,0,0,63,255,144,63,255,255,255,255,224,63,228,0,63,255,255,255,255,224,24,0,0,63,255,255,255,255,224,0,0,6,0,0,63,64,0,0,0,0,191,64,0,255,8,0,0,0,31,255,64,2,253,63,64,0,6,255,253,0,11,248,63,224,0,127,255,144,0,47,240,11,252,0,63,244,0,1,255,192,2,255,0,62,64,0,15,255,0,0,127,192,16,0,0,127,248,0,0,31,240,0,0,0,47,208,0,0,7,224,0,0,0,13,0,0,0,1,128,0,0,0,0,0,0,0,0,0,
  // 0x7eff  绿
  255,126,35,35,59,37,1,253,0,10,64,0,0,0,0,0,0,0,15,224,2,255,255,255,255,0,0,31,208,2,255,255,255,255,0,0,47,192,2,255,255,255,255,0,0,63,128,0,0,0,0,127,0,0,127,0,0,0,0,0,127,0,0,254,0,0,0,0,0,127,0,1,253,0,0,170,170,170,255,0,2,252,8,0,255,255,255,255,0,3,240,47,64,255,255,255,254,0,11,224,63,128,0,0,0,190,0,31,192,191,0,0,0,0,190,0,127,255,253,0,0,0,0,190,0,127,255,252,15,255,255,255,255,244,63,255,244,15,255,255,255,255,244,41,15,224,15,255,255,255,255,244,0,47,192,0,0,11,224,0,0,0,127,64,0,64,11,224,1,0,0,254,0,3,224,11,224,11,192,2,252,1,7,252,11,224,47,240,11,250,191,1,255,11,224,191,128,47,255,255,0,127,139,242,254,0,127,255,254,0,31,75,255,244,0,63,254,64,0,8,47,255,192,0,45,0,0,0,1,255,255,0,0,0,0,0,0,11,255,255,192,0,0,0,6,0,127,235,235,244,0,0,1,191,2,255,75,227,253,0,0,127,255,95,252,11,224,255,208,47,255,254,63,224,11,224,63,248,63,255,128,31,64,11,224,11,240,63,228,0,4,0,11,224,1,208,41,0,0,0,3,255,208,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,2,254,0,0,0,
  // 0x7f16  编
  22,127,34,35,59,37,1,253,0,10,64,0,0,27,128,0,0,0,15,224,0,0,47,192,0,0,0,15,208,0,0,15,224,0,0,0,47,192,0,0,15,240,0,0,0,63,64,15,255,255,255,255,192,0,127,0,15,255,255,255,255,192,0,254,0,15,255,255,255,255,192,0,252,0,15,208,0,0,15,192,2,244,29,15,208,0,0,15,192,3,240,63,79,208,0,0,15,192,15,208,127,15,255,255,255,255,192,31,192,253,15,255,255,255,255,192,127,255,252,15,255,255,255,255,192,127,255,244,15,208,0,0,0,0,63,255,240,15,208,0,0,0,0,57,79,208,15,192,0,0,0,0,0,47,128,15,255,255,255,255,208,0,63,0,15,255,255,255,255,208,0,253,0,15,255,255,255,255,208,2,252,4,15,254,15,75,131,208,7,250,253,31,254,15,75,131,208,31,255,254,31,254,15,75,131,208,63,255,249,31,190,15,75,131,208,63,249,0,47,190,15,75,131,208,46,0,0,63,127,255,255,255,208,0,0,4,63,63,255,255,255,208,0,0,189,127,63,175,239,239,208,0,27,254,190,62,15,75,131,208,2,255,249,253,62,15,75,131,208,127,255,128,252,62,15,75,131,208,127,244,2,252,62,15,75,131,208,63,64,3,244,62,15,75,135,208,32,0,7,240,62,15,75,191,208,0,0,0,208,62,10,6,111,192,0,0,0,0,41,0,0,5,0,
  // 0x7f3a  缺
  58,127,35,35,59,37,1,253,2,144,0,0,0,15,208,0,0,3,248,0,0,0,15,208,0,0,3,244,0,0,0,15,208,0,0,7,240,0,0,0,15,208,0,0,11,240,0,0,0,15,208,0,0,11,255,255,254,0,15,208,0,0,15,255,255,254,63,255,255,255,0,31,255,255,254,63,255,255,255,0,47,195,240,0,63,255,255,255,0,63,131,240,0,0,15,208,127,0,127,3,240,0,0,15,208,63,0,126,3,240,0,0,15,208,63,0,9,3,240,0,0,15,208,63,0,127,255,255,255,0,15,208,63,0,127,255,255,255,0,15,208,63,0,127,255,255,255,0,15,208,63,0,0,3,240,0,0,15,208,127,0,0,3,240,0,127,255,255,255,248,10,3,240,41,127,255,255,255,248,31,67,240,126,127,255,255,255,248,31,67,240,126,0,47,252,0,0,31,67,240,126,0,63,252,0,0,31,67,240,126,0,63,254,0,0,31,67,240,126,0,127,255,0,0,31,67,240,126,0,191,63,64,0,31,67,240,126,0,254,63,192,0,31,67,240,126,2,253,31,208,0,31,255,255,254,3,252,15,240,0,31,255,255,254,15,244,7,252,0,31,255,255,254,63,224,3,254,0,31,64,0,126,255,192,0,255,128,31,64,0,27,255,0,0,127,244,26,64,0,15,253,0,0,31,244,0,0,0,7,240,0,0,7,224,0,0,0,1,128,0,0,0,128,
  // 0x7f51  网
  81,127,31,33,8,37,3,253,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,190,85,95,213,86,253,86,252,190,0,15,192,1,248,1,252,190,0,15,192,1,248,1,252,190,0,15,192,1,248,1,252,190,0,15,192,2,248,1,252,190,0,15,192,2,244,1,252,190,24,31,195,194,244,1,252,190,63,31,139,246,244,1,252,190,127,239,131,255,240,1,252,190,15,255,64,255,240,1,252,190,3,255,64,63,240,1,252,190,1,255,64,15,240,1,252,190,0,127,128,7,252,1,252,190,0,63,208,7,254,1,252,190,0,127,244,11,255,129,252,190,0,191,252,15,255,209,252,190,0,253,254,15,207,241,252,190,0,252,125,31,131,241,252,190,1,252,40,63,129,193,252,190,3,248,0,63,0,65,252,190,3,240,0,191,0,1,252,190,11,240,0,253,0,1,252,190,31,208,2,252,0,1,252,190,63,192,7,248,0,1,252,190,127,64,15,240,0,1,252,190,30,0,3,208,0,1,252,190,4,0,0,128,5,86,252,190,0,0,0,0,15,255,248,190,0,0,0,0,7,255,244,190,0,0,0,0,3,255,144,
  // 0x7f6e  置
  110,127,34,35,59,37,2,252,5,85,85,85,85,85,85,84,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,11,224,7,240,3,240,1,252,0,11,224,7,240,3,240,1,252,0,11,224,7,240,3,240,1,252,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,5,85,85,87,253,85,85,84,0,0,0,0,3,248,0,0,0,0,106,170,170,171,254,170,170,170,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,0,7,240,0,0,0,0,0,0,0,11,224,0,0,0,0,6,160,63,255,255,255,255,224,0,7,240,63,255,255,255,255,224,0,7,240,63,64,0,0,11,224,0,7,240,63,255,255,255,255,224,0,7,240,63,255,255,255,255,224,0,7,240,63,64,0,0,11,224,0,7,240,63,64,0,0,11,224,0,7,240,63,255,255,255,255,224,0,7,240,63,255,255,255,255,224,0,7,240,63,64,0,0,11,224,0,7,240,63,64,0,0,11,224,0,7,240,63,255,255,255,255,224,0,7,240,47,255,255,255,255,224,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,255,255,255,255,255,255,255,208,7,255,255,255,255,255,255,255,208,7,250,170,170,170,170,170,170,128,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7f72  署
  114,127,34,34,50,37,1,253,1,85,85,85,85,85,85,85,0,2,255,255,255,255,255,255,255,0,2,255,255,255,255,255,255,255,0,2,244,1,248,0,252,0,127,0,2,244,1,248,0,252,0,127,0,2,244,1,248,0,252,0,127,0,2,255,255,255,255,255,255,255,0,2,255,255,255,255,255,255,255,0,1,85,85,91,245,85,85,85,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,56,0,0,63,255,255,255,255,240,255,0,0,63,255,255,255,255,247,253,0,0,42,170,175,250,170,255,244,0,0,0,0,7,240,1,255,192,0,0,0,0,7,240,15,254,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,224,0,0,0,47,255,192,0,0,0,0,0,7,255,253,0,0,0,0,0,1,191,255,255,255,255,248,0,1,191,255,255,255,255,255,248,0,127,255,255,170,170,170,171,248,0,63,255,191,0,0,0,2,248,0,31,144,63,0,0,0,3,248,0,0,0,63,255,255,255,255,248,0,0,0,63,255,255,255,255,248,0,0,0,63,0,0,0,2,248,0,0,0,63,0,0,0,2,248,0,0,0,63,255,255,255,255,248,0,0,0,63,255,255,255,255,248,0,0,0,63,170,170,170,171,248,0,0,0,42,0,0,0,1,164,0,
  // 0x8005  者
  5,128,34,36,68,37,1,252,0,0,0,47,128,0,0,0,0,0,0,0,47,128,0,0,16,0,0,0,0,47,128,0,0,125,0,0,0,0,47,128,0,0,255,0,0,0,0,47,128,0,2,253,0,0,191,255,255,255,255,219,248,0,0,191,255,255,255,255,255,224,0,0,191,255,255,255,255,255,192,0,0,0,0,47,128,2,255,0,0,0,0,0,47,128,15,252,0,0,0,0,0,47,128,63,224,0,0,0,0,0,47,193,255,128,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,0,0,0,15,254,0,0,0,0,0,0,0,191,244,0,0,0,0,0,0,7,255,192,0,0,0,0,0,0,63,254,0,0,0,0,0,0,2,255,255,255,255,255,208,0,0,127,255,255,255,255,255,208,0,11,255,255,255,255,255,255,208,0,127,255,255,0,0,0,15,208,0,63,244,127,0,0,0,15,208,0,14,64,127,0,0,0,15,208,0,0,0,127,255,255,255,255,208,0,0,0,127,255,255,255,255,208,0,0,0,127,170,170,170,175,208,0,0,0,127,0,0,0,15,208,0,0,0,127,0,0,0,15,208,0,0,0,127,0,0,0,15,208,0,0,0,127,255,255,255,255,208,0,0,0,127,255,255,255,255,208,0,0,0,127,255,255,255,255,208,0,0,0,127,0,0,0,15,208,0,0,0,0,0,0,0,0,0,0,
  // 0x806a  聪
  106,128,35,35,59,37,1,253,0,0,0,0,2,0,0,144,0,0,0,0,0,47,128,0,252,0,63,255,255,248,31,192,2,252,0,63,255,255,248,15,224,3,248,0,63,255,255,248,7,240,7,240,0,7,224,31,128,3,248,11,224,0,7,224,31,128,1,252,15,192,0,7,224,31,128,0,208,47,128,0,7,224,31,128,255,255,255,255,128,7,250,191,128,255,255,255,255,128,7,255,255,128,255,255,255,255,128,7,255,255,128,252,0,0,47,128,7,224,31,128,252,0,0,47,128,7,224,31,128,252,0,0,47,128,7,224,31,128,252,0,0,47,128,7,224,31,128,252,0,0,47,128,7,224,31,128,255,255,255,255,128,7,250,191,128,255,255,255,255,128,7,255,255,128,255,255,255,255,128,7,255,255,128,0,1,0,0,0,7,224,31,128,0,15,128,0,0,7,224,31,128,0,15,208,0,0,7,224,31,128,3,243,244,5,0,7,224,31,225,227,241,252,47,0,7,225,127,246,243,240,190,31,64,7,255,255,251,243,240,62,15,192,127,255,255,211,227,240,20,11,208,127,255,175,131,227,240,0,67,224,63,144,31,135,211,240,0,247,240,16,0,31,143,195,240,0,245,244,0,0,31,143,195,240,1,244,248,0,0,31,159,67,254,171,240,144,0,0,31,129,2,255,255,224,0,0,0,31,128,0,191,255,128,0,0,0,31,128,0,0,0,0,0,
  // 0x80fd  能
  253,128,35,36,68,37,1,252,0,15,144,0,2,248,0,0,0,0,15,224,0,2,248,0,0,0,0,47,192,16,2,248,0,0,0,0,63,129,248,2,248,0,44,0,0,127,1,253,2,248,6,255,0,0,190,0,191,2,248,127,255,64,0,253,0,63,130,255,255,244,0,22,254,255,255,194,255,254,0,0,127,255,255,255,226,255,128,0,0,127,255,255,255,242,252,0,0,0,63,169,84,3,246,248,0,2,144,0,0,0,2,210,248,0,3,244,0,0,0,0,2,252,0,3,240,7,255,255,255,2,252,0,7,240,7,255,255,255,1,255,255,255,240,7,255,255,255,0,255,255,255,208,7,240,0,127,0,47,255,255,64,7,240,0,127,0,84,0,0,0,7,240,0,127,2,248,0,0,0,7,250,170,191,2,248,0,0,0,7,255,255,255,2,248,0,46,0,7,255,255,255,2,248,2,255,64,7,240,0,127,2,248,111,255,64,7,240,0,127,2,255,255,248,0,7,240,0,127,2,255,255,64,0,7,255,255,255,2,255,224,0,0,7,255,255,255,2,252,0,0,0,7,250,170,191,2,248,0,1,128,7,240,0,127,2,248,0,1,248,7,240,0,127,2,248,0,1,248,7,240,0,127,2,248,0,2,248,7,240,0,127,2,252,0,3,244,7,240,63,255,1,255,255,255,240,7,240,63,254,0,255,255,255,224,7,240,31,228,0,47,255,255,64,0,0,0,0,0,0,0,0,0,
  // 0x81ea  自
  234,129,26,36,252,37,6,252,0,0,11,224,0,0,0,0,0,15,240,0,0,0,0,0,15,224,0,0,0,0,0,31,208,0,0,0,0,0,47,192,0,0,0,255,255,255,255,255,255,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,254,85,85,85,85,95,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,253,0,0,0,0,15,224,253,0,0,0,0,15,224,0,0,0,0,0,0,0,
  // 0x81f3  至
  243,129,33,32,32,37,2,254,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,64,63,255,255,255,255,255,255,255,64,0,0,11,252,0,0,0,0,0,0,0,15,244,0,29,0,0,0,0,0,31,240,0,191,64,0,0,0,0,63,208,0,191,224,0,0,0,0,127,192,0,47,248,0,0,0,0,255,64,0,11,255,0,0,0,1,255,0,0,1,255,192,0,31,255,255,175,255,255,255,240,0,31,255,255,255,255,255,255,252,0,31,255,255,255,255,255,255,254,0,26,170,170,169,85,80,1,255,64,0,0,0,1,80,0,0,124,0,0,0,0,7,240,0,0,16,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,240,0,0,0,0,2,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,2,255,255,255,255,255,255,240,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,
  // 0x83dc  菜
  220,131,34,35,59,37,1,253,0,0,31,192,0,15,208,0,0,0,0,31,192,0,15,208,0,0,0,0,31,192,0,15,208,0,0,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,0,0,31,192,0,15,208,0,0,0,0,31,192,0,15,208,0,0,0,0,10,128,0,6,191,224,0,0,0,85,106,191,255,255,248,0,11,255,255,255,255,255,255,248,0,3,255,255,255,255,254,148,0,0,3,255,250,165,80,0,0,144,0,0,0,0,2,208,0,1,253,0,0,125,0,11,240,0,3,252,0,0,191,0,3,244,0,7,248,0,0,63,192,2,252,0,15,240,0,0,31,208,1,252,0,31,208,0,0,15,240,0,228,0,63,128,0,0,7,208,1,252,0,127,0,0,0,1,0,1,252,0,4,0,0,0,0,0,1,253,0,0,0,0,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,47,255,255,255,255,255,255,255,240,0,0,0,255,255,248,0,0,0,0,0,7,255,254,255,0,0,0,0,0,63,245,252,127,224,0,0,0,2,255,193,252,31,254,0,0,0,111,254,1,252,3,255,224,0,11,255,244,1,252,0,127,255,144,127,255,128,1,252,0,11,255,240,47,248,0,1,252,0,0,191,208,15,64,0,1,252,0,0,7,128,0,0,0,1,252,0,0,0,0,
  // 0x84dd  蓝
  221,132,33,34,50,37,2,254,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,192,191,255,255,255,255,255,255,255,192,0,0,191,0,0,63,128,0,0,0,0,191,0,0,63,128,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,3,244,0,0,0,0,0,31,192,7,240,0,0,0,3,240,31,192,11,240,0,0,0,3,240,31,192,15,255,255,253,0,3,240,31,192,31,255,255,253,0,3,240,31,192,47,255,255,253,0,3,240,31,192,63,64,128,0,0,3,240,31,192,191,11,224,0,0,3,240,31,193,253,7,244,0,0,3,240,31,195,252,2,252,0,0,3,240,31,194,244,0,254,0,0,3,240,31,192,96,0,127,0,0,2,160,31,192,0,0,63,64,0,0,0,5,64,0,0,24,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,254,171,254,175,250,175,208,0,0,252,2,244,3,224,15,208,0,0,252,2,244,3,224,15,208,0,0,252,2,244,3,224,15,208,0,0,252,2,244,3,224,15,208,0,0,252,2,244,3,224,15,208,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x86c7  蛇
  199,134,34,35,59,37,1,253,0,1,64,0,0,3,240,0,0,0,7,208,0,0,3,240,0,0,0,7,208,0,0,3,240,0,0,0,7,208,0,0,3,240,0,0,0,7,208,0,0,3,240,0,0,0,7,208,1,255,255,255,255,240,0,7,208,1,255,255,255,255,240,31,255,255,245,255,255,255,255,240,31,255,255,245,248,0,0,3,240,31,255,255,245,248,0,0,3,240,31,3,193,245,248,0,0,3,240,31,3,193,245,248,0,0,3,240,31,3,193,245,255,208,0,3,240,31,3,193,244,11,208,0,0,0,31,3,193,244,11,208,0,4,0,31,3,193,244,11,208,0,61,0,31,3,193,244,11,208,2,255,0,31,3,193,244,11,208,47,255,64,31,255,255,244,11,210,255,248,0,31,255,255,244,11,255,255,64,0,31,255,255,244,11,255,228,0,0,31,11,208,0,11,254,0,0,0,10,11,208,0,11,224,0,0,0,0,11,209,240,11,208,0,0,0,0,11,210,244,11,208,0,0,0,0,11,208,248,11,208,0,0,0,0,11,208,252,11,208,0,2,128,0,11,209,252,11,208,0,3,240,0,31,255,254,11,208,0,3,240,127,255,255,255,11,224,0,3,240,127,255,255,191,11,240,0,11,240,127,250,64,47,7,255,255,255,224,36,0,0,46,3,255,255,255,192,0,0,0,0,0,191,255,254,0,0,0,0,0,0,0,0,0,0,
  // 0x884c  行
  76,136,34,36,68,37,1,252,0,0,180,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,7,252,2,255,255,255,255,192,0,31,240,2,255,255,255,255,192,0,127,208,2,255,255,255,255,192,2,255,64,0,85,85,85,85,64,11,253,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,127,208,14,0,0,0,0,0,0,47,0,63,192,0,0,0,0,0,8,0,127,128,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,3,253,5,85,85,85,85,80,0,11,248,31,255,255,255,255,240,0,47,240,31,255,255,255,255,240,0,127,208,31,255,255,255,255,240,1,255,208,0,0,0,47,192,0,11,255,208,0,0,0,47,192,0,47,255,208,0,0,0,47,192,0,255,239,208,0,0,0,47,192,0,127,143,208,0,0,0,47,192,0,30,15,208,0,0,0,47,192,0,4,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,47,192,0,0,15,208,0,1,85,127,192,0,0,15,208,0,2,255,255,128,0,0,15,208,0,1,255,255,64,0,0,15,208,0,0,255,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x88ab  被
  171,136,35,35,59,37,1,253,0,31,128,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,47,192,3,255,255,255,255,244,63,255,255,195,255,255,255,255,240,63,255,255,211,255,255,255,255,240,63,255,255,195,244,3,244,11,224,0,0,47,131,244,3,244,15,208,0,0,127,3,244,3,244,15,192,0,0,254,3,244,3,244,31,192,0,1,252,3,244,3,244,27,64,0,3,248,147,244,3,244,0,0,0,15,240,251,255,255,255,255,128,0,47,227,243,255,255,255,255,192,0,191,251,211,255,255,255,255,128,1,255,255,131,255,224,0,63,64,7,255,255,3,251,240,0,191,0,47,255,239,195,243,244,0,254,0,255,239,207,227,241,252,1,252,0,127,95,195,231,240,253,3,252,0,60,31,194,135,240,191,11,244,0,16,31,192,11,224,63,223,224,0,0,31,192,15,208,31,255,192,0,0,31,192,15,192,15,255,64,0,0,31,192,31,192,3,255,0,0,0,31,192,47,128,15,255,128,0,0,31,192,63,64,127,255,240,0,0,31,192,191,2,255,239,254,0,0,31,192,254,47,254,7,255,224,0,31,194,252,191,244,0,255,244,0,31,193,244,63,128,0,31,224,0,31,192,32,8,0,0,1,192,
  // 0x88c5  装
  197,136,35,36,68,37,1,252,0,0,42,0,0,10,144,0,0,0,0,127,0,0,15,208,0,0,2,0,127,0,0,15,208,0,0,15,208,127,0,0,15,208,0,0,15,248,127,0,0,15,208,0,0,3,254,127,31,255,255,255,255,240,0,189,127,31,255,255,255,255,240,0,36,127,31,255,255,255,255,240,0,0,127,0,0,15,208,0,0,0,0,127,0,0,15,208,0,0,0,7,127,0,0,15,208,0,0,1,191,191,0,0,15,208,0,0,31,255,191,0,0,15,208,0,0,127,248,127,7,255,255,255,255,192,63,64,127,7,255,255,255,255,192,20,0,127,7,255,255,255,255,192,0,0,127,0,0,0,0,0,0,0,0,42,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,63,255,255,255,255,255,255,255,240,63,255,255,255,255,255,255,255,240,42,170,170,255,255,234,170,170,160,0,0,2,255,95,192,0,56,0,0,0,47,248,11,224,1,255,0,0,7,255,208,3,248,31,253,0,6,255,255,64,1,253,191,224,0,127,255,255,64,0,191,254,0,0,31,244,63,64,0,47,244,0,0,9,0,63,64,1,11,254,0,0,0,0,63,171,255,2,255,208,0,0,26,255,255,255,64,127,255,128,0,63,255,255,250,0,11,255,244,0,63,255,148,0,0,0,191,224,0,21,0,0,0,0,0,6,192,0,0,0,0,0,0,0,0,0,
  // 0x8981  要
  129,137,33,34,50,37,2,252,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,11,224,3,240,0,0,0,0,0,11,224,3,240,0,0,0,7,255,255,255,255,255,255,248,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,11,224,11,224,3,240,1,252,0,11,224,11,224,3,240,1,252,0,11,224,11,224,3,240,1,252,0,11,224,11,224,3,240,1,252,0,11,224,11,224,3,240,1,252,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,252,0,11,255,255,255,255,255,255,248,0,0,0,2,252,0,0,0,0,0,0,0,11,244,0,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,1,254,0,0,15,240,0,0,0,3,252,0,0,63,192,0,0,0,11,244,0,0,191,128,0,0,0,31,255,144,2,255,0,0,0,0,63,255,255,155,252,0,0,0,0,47,191,255,255,244,0,0,0,0,1,1,191,255,254,64,0,0,0,0,1,255,255,255,249,0,0,0,90,255,255,230,255,255,228,0,127,255,255,254,0,7,255,254,0,63,255,254,64,0,0,31,252,0,31,169,0,0,0,0,0,180,0,0,0,0,0,0,0,0,0,0,
  // 0x89d2  角
  210,137,32,36,32,37,1,252,0,0,7,228,0,0,0,0,0,0,15,244,0,0,0,0,0,0,31,255,255,253,0,0,0,0,63,255,255,255,128,0,0,0,255,255,255,255,64,0,0,1,254,0,0,255,0,0,0,7,252,0,2,253,0,0,0,15,244,0,3,248,0,0,0,63,224,0,15,240,0,0,1,255,255,255,255,255,255,253,7,255,255,255,255,255,255,253,47,255,255,255,255,255,255,253,15,239,208,0,63,0,0,253,3,79,208,0,63,0,0,253,0,15,208,0,63,0,0,253,0,15,208,0,63,0,0,253,0,15,255,255,255,255,255,253,0,15,255,255,255,255,255,253,0,15,255,255,255,255,255,253,0,15,208,0,63,0,0,253,0,15,208,0,63,0,0,253,0,15,192,0,63,0,0,253,0,15,192,0,63,0,0,253,0,31,192,0,127,0,0,253,0,47,255,255,255,255,255,253,0,63,255,255,255,255,255,253,0,63,255,255,255,255,255,253,0,127,0,0,0,0,0,253,0,254,0,0,0,0,0,253,2,253,0,0,0,0,0,253,7,248,0,0,0,0,0,253,31,240,0,0,0,20,2,253,127,208,0,0,0,127,255,252,63,128,0,0,0,63,255,248,13,0,0,0,0,47,255,144,0,0,0,0,0,0,0,0,
  // 0x8ba1  计
  161,139,34,35,59,37,2,253,0,0,0,0,0,63,64,0,0,0,176,0,0,0,63,64,0,0,2,253,0,0,0,63,64,0,0,2,255,64,0,0,63,64,0,0,0,127,208,0,0,63,64,0,0,0,31,244,0,0,63,64,0,0,0,7,252,0,0,63,64,0,0,0,1,240,0,0,63,64,0,0,0,0,128,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,255,255,192,170,170,191,234,170,128,255,255,193,255,255,255,255,255,208,255,255,193,255,255,255,255,255,208,85,127,193,255,255,255,255,255,208,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,0,0,63,64,0,0,0,47,192,64,0,63,64,0,0,0,47,194,208,0,63,64,0,0,0,47,207,224,0,63,64,0,0,0,47,255,240,0,63,64,0,0,0,47,255,128,0,63,64,0,0,0,63,253,0,0,63,64,0,0,0,191,240,0,0,63,64,0,0,1,255,128,0,0,63,64,0,0,0,189,0,0,0,63,64,0,0,0,52,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,
  // 0x8bae  议
  174,139,34,35,59,37,2,252,1,192,0,0,7,192,0,0,0,11,240,0,0,15,224,0,80,0,7,248,0,252,7,240,0,254,0,2,253,0,252,3,248,0,253,0,0,255,0,253,1,252,1,252,0,0,63,192,253,0,254,2,252,0,0,31,0,190,0,191,2,252,0,0,8,0,127,0,127,3,248,0,0,0,0,63,0,52,3,244,0,0,0,0,63,64,0,7,240,0,85,85,0,47,192,0,11,240,0,255,255,0,31,192,0,15,224,0,255,255,0,15,208,0,31,208,0,255,255,0,11,240,0,47,192,0,0,127,0,7,240,0,63,128,0,0,127,0,3,248,0,127,64,0,0,127,0,2,252,0,255,0,0,0,127,0,0,254,1,253,0,0,0,127,0,0,255,3,252,0,0,0,127,0,0,127,135,248,0,0,0,127,0,0,63,223,240,0,0,0,127,0,0,15,255,208,0,0,0,127,0,0,11,255,192,0,0,0,127,0,0,3,255,0,0,0,0,127,7,64,3,255,64,0,0,0,127,47,192,15,255,208,0,0,0,127,255,192,63,255,244,0,0,0,191,254,0,255,223,254,0,0,0,255,244,7,255,2,255,208,0,1,255,192,63,252,0,191,248,0,3,254,2,255,224,0,47,255,144,1,248,15,255,64,0,7,255,224,0,144,11,252,0,0,0,191,128,0,0,3,208,0,0,0,11,0,0,0,0,0,0,0,0,0,0,
  // 0x8bbe  设
  190,139,34,35,59,37,1,252,0,48,0,0,0,0,0,0,0,0,252,0,0,63,255,255,192,0,1,255,64,0,63,255,255,192,0,0,127,208,0,63,255,255,192,0,0,15,244,0,63,0,15,192,0,0,3,252,0,63,0,15,192,0,0,0,244,0,127,0,15,192,0,0,0,80,0,190,0,15,192,0,0,0,0,0,253,0,15,192,0,0,0,0,3,252,0,15,192,0,21,85,0,15,248,0,15,255,240,127,255,192,191,240,0,11,255,240,127,255,192,255,192,0,2,255,240,127,255,192,126,0,0,0,0,0,0,31,192,36,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,63,255,255,255,255,0,0,31,192,63,255,255,255,255,0,0,31,192,63,255,255,255,254,0,0,31,192,7,240,0,1,253,0,0,31,192,3,248,0,3,252,0,0,31,192,1,252,0,11,244,0,0,31,192,0,255,0,15,224,0,0,31,192,64,63,192,63,192,0,0,31,195,192,31,240,255,64,0,0,31,223,208,11,255,254,0,0,0,47,255,208,2,255,248,0,0,0,47,255,64,1,255,240,0,0,0,63,252,0,11,255,254,0,0,0,191,224,1,191,255,255,224,0,0,255,128,111,255,208,191,255,144,0,189,1,255,253,0,31,255,240,0,52,0,255,144,0,1,191,208,0,0,0,100,0,0,0,6,192,0,0,0,0,0,0,0,0,0,
  // 0x8bd5  试
  213,139,34,35,59,37,2,253,0,0,0,0,0,6,160,0,0,1,208,0,0,0,7,241,240,0,7,244,0,0,0,7,243,248,0,3,254,0,0,0,7,240,254,0,0,255,128,0,0,7,240,127,0,0,63,208,0,0,7,240,47,128,0,15,240,0,0,7,240,14,0,0,3,193,85,85,87,245,85,64,0,1,3,255,255,255,255,255,208,0,0,3,255,255,255,255,255,208,0,0,3,255,255,255,255,255,208,85,85,0,0,0,3,244,0,0,255,255,0,0,0,3,244,0,0,255,255,0,0,0,3,244,0,0,255,255,0,0,0,3,244,0,0,0,63,0,0,0,3,248,0,0,0,63,0,255,255,243,248,0,0,0,63,0,255,255,242,248,0,0,0,63,0,255,255,242,252,0,0,0,63,0,2,252,2,252,0,0,0,63,0,1,248,1,252,0,0,0,63,0,1,248,1,252,0,0,0,63,0,1,248,0,253,0,0,0,63,0,1,248,0,253,0,0,0,63,0,1,248,0,254,0,0,0,63,1,1,248,0,191,3,64,0,63,31,1,248,104,127,3,224,0,63,191,65,255,252,127,67,224,0,127,255,91,255,252,63,135,208,0,191,250,255,255,228,47,219,192,2,255,208,255,249,0,31,255,192,2,255,0,254,0,0,15,255,128,0,248,0,64,0,0,7,255,0,0,144,0,0,0,0,1,254,0,0,0,0,0,0,0,0,20,0,
  // 0x8bef  误
  239,139,35,35,59,37,1,252,0,80,0,0,0,0,0,0,0,1,248,0,7,255,255,255,255,0,3,254,0,7,255,255,255,255,0,0,255,192,7,255,255,255,255,0,0,63,240,7,224,0,0,63,0,0,15,248,7,224,0,0,63,0,0,3,224,7,224,0,0,63,0,0,0,128,7,224,0,0,63,0,0,0,0,7,255,255,255,255,0,0,0,0,7,255,255,255,255,0,21,85,64,7,255,255,255,255,0,127,255,192,0,0,0,0,0,0,127,255,192,0,0,0,0,0,0,127,255,192,0,0,0,0,0,0,0,31,192,31,255,255,255,255,192,0,31,192,31,255,255,255,255,192,0,31,192,31,255,255,255,255,192,0,31,192,0,0,31,192,0,0,0,31,192,0,0,47,128,0,0,0,31,192,0,0,47,128,0,0,0,31,192,0,0,47,128,0,0,0,31,192,127,255,255,255,255,248,0,31,192,127,255,255,255,255,248,0,31,192,127,255,255,255,255,248,0,31,192,64,0,255,240,0,0,0,31,199,192,1,255,244,0,0,0,31,239,192,3,254,252,0,0,0,31,255,192,15,244,255,64,0,0,63,254,0,63,240,127,208,0,0,191,244,1,255,192,31,252,0,0,127,192,111,255,0,7,255,208,0,62,0,255,248,0,1,255,244,0,20,0,127,192,0,0,47,224,0,0,0,56,0,0,0,2,192,0,0,0,0,0,0,0,0,0,
  // 0x8bf7  请
  247,139,35,35,59,37,1,253,0,0,0,0,0,47,128,0,0,0,160,0,0,0,47,192,0,0,2,248,0,0,0,47,192,0,0,3,254,0,63,255,255,255,255,208,0,255,192,63,255,255,255,255,208,0,47,224,26,170,191,234,170,128,0,15,244,0,0,47,192,0,0,0,3,224,5,85,127,213,85,0,0,0,128,15,255,255,255,255,0,0,0,0,15,255,255,255,255,0,0,0,0,0,0,47,192,0,0,21,85,64,0,0,47,192,0,0,127,255,192,255,255,255,255,255,244,127,255,192,255,255,255,255,255,244,127,255,192,170,170,170,170,170,160,0,31,192,0,0,0,0,0,0,0,31,192,6,170,170,170,169,0,0,31,192,7,255,255,255,254,0,0,31,192,7,255,255,255,254,0,0,31,192,7,224,0,0,190,0,0,31,192,7,224,0,0,190,0,0,31,192,7,245,85,85,190,0,0,31,192,7,255,255,255,254,0,0,31,192,7,255,255,255,254,0,0,31,192,7,224,0,0,190,0,0,31,194,199,224,0,0,190,0,0,31,207,199,224,0,0,190,0,0,31,255,215,255,255,255,254,0,0,31,255,135,255,255,255,254,0,0,47,253,7,245,85,85,254,0,0,63,240,7,224,0,0,190,0,0,255,192,7,224,0,0,190,0,0,126,0,7,224,0,255,253,0,0,56,0,7,224,0,191,252,0,0,0,0,7,224,0,127,224,0,
  // 0x8bfb  读
  251,139,34,36,68,37,1,252,0,0,0,0,0,47,128,0,0,0,224,0,0,0,63,128,0,0,3,252,0,0,0,63,128,0,0,2,255,64,15,255,255,255,255,0,0,191,208,15,255,255,255,255,0,0,31,244,15,255,255,255,255,0,0,7,244,0,0,63,128,0,0,0,2,208,0,0,63,128,0,0,0,0,64,0,0,63,128,0,0,0,0,0,127,255,255,255,255,208,0,0,0,127,255,255,255,255,208,21,85,0,127,255,255,255,255,192,127,255,128,0,0,0,0,15,192,127,255,128,0,144,6,144,47,128,127,255,128,2,253,15,208,63,0,0,31,128,0,191,143,208,63,0,0,31,128,4,31,239,208,45,0,0,31,128,62,3,223,208,0,0,0,31,128,63,208,79,208,0,0,0,31,128,11,248,15,208,0,0,0,31,128,1,253,15,208,0,0,0,31,128,0,56,15,192,0,0,0,31,129,255,255,255,255,255,240,0,31,129,255,255,255,255,255,240,0,31,129,255,255,255,255,255,240,0,31,139,0,0,255,0,0,0,0,31,239,64,1,254,28,0,0,0,31,255,128,7,252,127,64,0,0,31,254,0,31,244,127,224,0,0,47,248,0,191,208,15,252,0,0,63,224,3,255,128,2,255,0,0,191,64,127,253,0,0,127,208,0,189,2,255,240,0,0,31,240,0,52,0,255,64,0,0,7,240,0,0,0,120,0,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x8c03  调
  3,140,33,35,59,37,1,252,0,144,0,0,0,0,0,0,0,2,244,0,63,255,255,255,255,192,3,254,0,63,255,255,255,255,192,0,255,128,63,255,255,255,255,192,0,63,224,63,0,0,0,15,192,0,15,244,63,0,31,64,15,192,0,3,224,63,0,31,64,15,192,0,0,128,63,6,175,170,15,192,0,0,0,63,15,255,255,15,192,0,0,0,63,15,255,255,15,192,21,85,0,63,0,31,64,15,192,127,255,192,63,0,31,64,15,192,127,255,192,63,0,31,64,15,192,127,255,192,63,26,175,170,143,192,0,47,192,63,47,255,255,207,192,0,47,192,63,47,255,255,207,192,0,47,192,63,0,0,0,15,192,0,47,192,63,0,0,0,15,192,0,47,192,63,0,0,0,15,192,0,47,192,63,15,255,255,15,192,0,47,192,63,15,255,255,15,192,0,47,192,62,15,234,191,15,192,0,47,192,126,15,128,63,15,192,0,47,192,126,15,128,63,15,192,0,47,197,189,15,128,63,15,192,0,47,239,252,15,234,191,15,192,0,47,255,252,15,255,255,15,192,0,47,255,248,15,255,255,15,192,0,63,250,244,15,128,0,15,192,0,127,211,240,10,64,0,15,192,1,255,71,240,0,0,0,15,192,0,252,15,208,0,0,31,255,192,0,48,15,192,0,0,15,255,128,0,0,2,64,0,0,11,253,0,0,0,0,0,0,0,0,0,0,
  // 0x8d25  败
  37,141,34,35,59,37,2,253,0,0,0,0,0,16,0,0,0,0,0,0,0,0,127,0,0,0,47,255,255,252,0,190,0,0,0,47,255,255,252,0,253,0,0,0,47,255,255,252,0,252,0,0,0,47,0,0,252,1,252,0,0,0,47,0,0,252,3,248,0,0,0,47,1,64,252,3,255,255,255,192,47,7,224,252,7,255,255,255,192,47,7,224,252,15,255,255,255,192,47,7,224,252,15,192,1,248,0,47,7,224,252,47,192,2,244,0,47,7,224,252,63,64,2,240,0,47,7,224,252,191,64,3,240,0,47,7,224,252,255,128,3,240,0,47,7,224,254,255,192,3,224,0,47,7,224,253,255,208,7,224,0,47,7,224,252,183,224,11,208,0,47,7,208,252,3,240,15,192,0,47,11,208,252,2,248,15,192,0,47,11,208,252,0,252,47,64,0,47,11,208,252,0,254,63,0,0,47,15,192,252,0,127,127,0,0,47,15,192,252,0,63,253,0,0,47,15,192,248,0,15,252,0,0,0,47,128,0,0,11,244,0,0,0,63,14,0,0,11,248,0,0,0,127,63,64,0,31,254,0,0,0,253,31,192,0,63,255,128,0,2,252,11,240,0,255,63,224,0,11,240,3,248,7,252,15,248,0,47,208,1,252,47,240,3,255,64,255,128,0,253,255,192,0,255,208,189,0,0,48,62,0,0,47,128,36,0,0,0,20,0,0,2,0,
  // 0x8d2a  贪
  42,141,34,36,68,37,2,252,0,0,0,0,244,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,47,254,0,0,0,0,0,0,2,255,255,224,0,0,0,0,0,47,254,31,254,64,0,0,0,7,255,241,2,255,248,0,0,1,191,255,75,192,47,255,224,0,111,255,244,15,244,2,255,255,208,255,255,64,3,253,0,31,255,192,127,224,0,0,252,0,1,191,64,41,63,255,255,255,255,244,1,0,0,63,255,255,255,255,254,0,0,0,63,255,255,255,255,252,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,255,128,0,0,0,0,0,0,0,254,0,0,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,0,0,0,0,63,64,0,0,127,0,7,240,0,63,64,0,0,127,0,7,240,0,63,64,0,0,127,0,7,240,0,63,64,0,0,127,0,7,240,0,63,64,0,0,127,0,11,240,0,63,64,0,0,127,0,15,240,0,63,64,0,0,127,0,63,210,0,63,64,0,0,0,0,255,143,248,0,0,0,0,0,11,255,31,255,224,0,0,0,1,191,248,2,255,254,64,0,0,127,255,208,0,11,255,244,0,47,255,253,0,0,0,127,254,0,15,255,128,0,0,0,2,252,0,3,228,0,0,0,0,0,36,0,0,0,0,0,0,0,0,0,0,
  // 0x8d77  起
  119,141,35,36,68,37,1,252,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,3,255,255,255,64,0,1,252,0,3,255,255,255,64,15,255,255,255,131,255,255,255,64,15,255,255,255,128,0,0,63,64,15,255,255,255,128,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,63,255,255,255,224,0,0,63,64,63,255,255,255,227,255,255,255,64,63,255,255,255,227,255,255,255,64,42,170,255,170,147,255,255,255,64,0,0,190,0,3,244,0,63,64,0,0,190,0,3,244,0,0,0,1,64,190,0,3,244,0,0,0,11,224,190,0,3,244,0,0,0,11,224,190,0,3,244,0,0,0,11,224,191,255,195,244,0,0,0,11,224,191,255,195,244,0,2,208,11,208,191,255,195,244,0,2,244,15,240,190,0,3,244,0,3,244,15,244,190,0,3,248,0,7,240,15,252,190,0,2,255,255,255,240,15,254,190,0,1,255,255,255,208,15,255,254,0,0,127,255,255,64,31,239,254,0,0,0,0,0,0,47,143,255,0,0,0,0,0,0,63,67,255,250,85,85,85,85,84,63,0,255,255,255,255,255,255,244,191,0,31,255,255,255,255,255,240,254,0,0,111,255,255,255,255,224,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8d85  超
  133,141,35,35,59,37,1,253,0,2,248,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,2,248,0,47,255,255,255,208,0,2,248,0,47,255,255,255,208,31,255,255,255,47,255,255,255,208,31,255,255,255,0,31,192,15,192,31,255,255,255,0,47,128,15,192,0,2,248,0,0,63,64,15,192,0,2,248,0,0,127,0,31,192,0,2,248,0,0,254,0,31,192,0,2,248,0,1,252,0,63,128,0,2,248,0,3,248,63,255,64,63,255,255,255,223,240,63,255,0,63,255,255,255,255,192,47,248,0,63,255,255,255,239,0,0,0,0,0,0,252,0,4,0,0,0,0,0,0,252,0,11,255,255,255,64,11,144,252,0,11,255,255,255,128,11,208,252,0,11,255,255,255,128,11,208,252,0,11,224,0,63,128,11,208,255,255,75,224,0,63,128,11,208,255,255,75,224,0,63,128,15,208,255,255,75,224,0,63,128,15,224,252,0,11,224,0,63,128,15,240,252,0,11,224,0,63,128,15,248,252,0,11,255,255,255,128,15,253,252,0,11,255,255,255,128,31,255,252,0,11,255,255,255,64,31,191,252,0,0,0,0,0,0,47,95,253,0,0,0,0,0,0,63,7,255,250,85,85,85,85,84,127,1,255,255,255,255,255,255,244,190,0,47,255,255,255,255,255,240,189,0,0,111,255,255,255,255,224,8,0,0,0,0,0,0,0,0,
  // 0x8ddd  距
  221,141,35,33,41,37,1,253,11,255,255,248,63,255,255,255,240,11,255,255,248,63,255,255,255,240,11,255,255,248,63,255,255,255,240,11,208,1,248,63,64,0,0,0,11,208,1,248,63,64,0,0,0,11,208,1,248,63,64,0,0,0,11,208,1,248,63,64,0,0,0,11,208,1,248,63,64,0,0,0,11,255,255,248,63,128,0,0,0,11,255,255,248,63,255,255,255,128,11,255,255,248,63,255,255,255,128,0,2,244,0,63,255,255,255,128,0,2,244,0,63,64,0,63,128,0,2,244,0,63,64,0,63,128,0,2,244,0,63,64,0,63,128,15,194,244,0,63,64,0,63,128,15,194,244,0,63,64,0,63,128,15,194,255,253,63,64,0,63,128,15,194,255,253,63,128,0,63,128,15,194,255,253,63,255,255,255,128,15,194,244,0,63,255,255,255,128,15,194,244,0,63,255,255,255,128,15,194,244,0,63,64,0,0,0,15,194,244,0,63,64,0,0,0,15,194,244,5,63,64,0,0,0,15,194,250,254,63,64,0,0,0,15,215,255,255,63,64,0,0,0,31,255,255,254,63,128,0,0,0,191,255,254,64,63,255,255,255,248,127,254,64,0,63,255,255,255,248,121,64,0,0,63,255,255,255,248,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,
  // 0x8f6c  转
  108,143,35,36,68,37,1,252,0,11,144,0,0,2,248,0,0,0,15,208,0,0,3,248,0,0,0,15,192,0,0,3,244,0,0,0,31,192,0,0,7,240,0,0,127,255,255,248,255,255,255,255,192,127,255,255,248,255,255,255,255,192,127,255,255,248,255,255,255,255,192,0,127,0,0,0,31,192,0,0,0,189,0,0,0,47,192,0,0,0,252,0,0,0,63,128,0,0,0,248,252,0,0,63,64,0,0,2,244,252,3,255,255,255,255,244,3,240,252,3,255,255,255,255,244,7,224,252,3,255,255,255,255,244,11,208,252,0,1,253,0,0,0,15,192,252,0,2,252,0,0,0,47,255,255,244,3,252,0,0,0,47,255,255,244,3,248,0,0,0,31,255,255,244,7,244,0,4,0,4,1,252,0,11,255,255,255,128,0,0,252,0,15,255,255,255,192,0,0,252,0,31,255,255,255,0,0,0,252,0,0,0,2,253,0,0,0,253,110,0,0,7,248,0,0,107,255,254,0,0,15,240,0,127,255,255,254,0,208,63,192,0,127,255,254,80,3,248,191,64,0,63,250,252,0,7,255,254,0,0,20,0,252,0,0,255,252,0,0,0,0,252,0,0,31,253,0,0,0,0,252,0,0,3,255,128,0,0,0,252,0,0,0,191,240,0,0,0,252,0,0,0,31,248,0,0,0,252,0,0,0,3,240,0,0,0,252,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,
  // 0x8f6f  软
  111,143,35,35,59,37,1,253,0,1,144,0,0,169,0,0,0,0,2,252,0,0,190,0,0,0,0,3,248,0,0,253,0,0,0,0,3,244,0,0,253,0,0,0,0,11,244,0,0,252,0,0,0,63,255,255,255,129,252,0,0,0,63,255,255,255,130,255,255,255,244,63,255,255,255,131,255,255,255,240,0,47,192,0,3,255,255,255,240,0,63,64,0,11,240,0,7,240,0,127,21,0,15,224,0,11,224,0,190,63,0,31,192,0,15,208,0,253,63,0,63,193,80,15,192,1,252,63,0,127,67,244,15,192,3,244,63,0,255,3,244,31,128,7,240,63,0,125,3,244,47,64,31,255,255,255,72,3,244,1,0,31,255,255,255,64,3,244,0,0,15,255,255,255,64,3,248,0,0,5,0,63,64,0,3,252,0,0,0,0,63,0,0,7,252,0,0,0,0,63,0,0,11,253,0,0,0,0,63,0,0,15,254,0,0,0,0,63,175,192,15,255,0,0,1,107,255,255,192,47,255,64,0,127,255,255,255,192,63,159,192,0,127,255,255,229,0,191,15,208,0,63,254,191,0,0,255,11,240,0,41,0,63,0,3,252,3,252,0,0,0,63,0,11,248,2,254,0,0,0,63,0,47,240,0,255,128,0,0,63,0,191,192,0,63,240,0,0,63,2,255,64,0,31,244,0,0,63,0,189,0,0,7,208,0,0,47,0,36,0,0,0,128,
  // 0x8f74  轴
  116,143,34,36,68,37,1,252,0,14,128,0,0,3,244,0,0,0,15,208,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,0,31,192,0,0,3,244,0,0,63,255,255,244,0,3,244,0,0,63,255,255,244,0,3,244,0,0,63,255,255,244,0,3,244,0,0,0,191,0,0,0,3,244,0,0,0,189,0,0,255,255,255,255,208,0,252,0,0,255,255,255,255,208,0,252,188,0,255,255,255,255,208,1,248,252,0,252,3,244,15,208,3,244,252,0,252,3,244,15,208,3,240,252,0,252,3,244,15,208,7,224,252,0,252,3,244,15,208,15,192,252,0,252,3,244,15,208,47,255,255,244,252,3,244,15,208,47,255,255,244,252,3,244,15,208,15,255,255,244,252,3,244,15,208,4,0,253,0,255,255,255,255,208,0,0,252,0,255,255,255,255,208,0,0,252,0,255,255,255,255,208,0,0,252,0,252,3,244,15,208,0,0,253,104,252,3,244,15,208,0,91,255,248,252,3,244,15,208,127,255,255,252,252,3,244,15,208,63,255,255,144,252,3,244,15,208,63,254,252,0,252,3,244,15,208,41,64,252,0,252,3,244,15,208,0,0,252,0,252,3,244,15,208,0,0,252,0,255,255,255,255,208,0,0,252,0,255,255,255,255,208,0,0,252,0,255,255,255,255,208,0,0,252,0,252,0,0,15,208,0,0,188,0,252,0,0,11,208,0,0,0,0,0,0,0,0,0,
  // 0x8f7d  载
  125,143,34,35,59,37,2,253,0,0,126,0,0,254,0,0,0,0,0,127,0,0,190,11,64,0,0,0,127,0,0,190,47,208,0,15,255,255,255,240,190,15,244,0,15,255,255,255,240,190,3,252,0,10,170,255,170,160,190,0,255,0,0,0,127,0,0,190,0,56,0,0,0,127,0,0,190,0,0,0,170,170,255,170,170,255,170,170,128,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,7,144,0,0,127,0,0,0,0,11,240,0,0,127,0,0,0,0,15,224,0,0,127,0,96,0,0,15,208,0,0,63,0,253,0,127,255,255,255,253,63,0,252,0,127,255,255,255,253,63,1,252,0,106,255,170,170,169,63,67,244,0,0,253,5,64,0,63,67,240,0,2,248,15,192,0,47,139,240,0,7,240,15,192,0,47,207,208,0,31,255,255,255,248,31,239,192,0,31,255,255,255,248,31,255,64,0,15,255,255,255,248,15,255,0,0,4,0,15,192,0,15,253,0,0,0,0,15,192,0,11,252,0,0,0,0,15,192,4,7,244,3,64,0,0,15,255,253,15,244,3,208,107,255,255,255,253,63,252,7,208,127,255,255,255,233,255,253,11,208,127,255,255,192,3,254,255,79,192,21,0,15,192,31,248,63,255,192,0,0,15,192,63,224,31,255,64,0,0,15,192,15,128,7,254,0,0,0,15,192,5,0,0,0,0,
  // 0x8f91  辑
  145,143,35,35,59,37,1,253,0,10,64,0,0,0,0,0,0,0,15,208,0,42,170,170,169,0,0,31,192,0,127,255,255,255,0,0,31,192,0,127,255,255,255,0,0,47,192,0,126,0,0,127,0,63,255,255,244,126,0,0,127,0,63,255,255,244,126,0,0,127,0,63,255,255,244,127,255,255,255,0,0,190,0,0,127,255,255,255,0,0,252,0,0,42,170,170,170,0,0,252,168,0,0,0,0,0,0,2,248,252,7,255,255,255,255,240,3,240,252,7,255,255,255,255,240,7,240,252,7,255,255,255,255,240,11,224,252,0,63,0,0,190,0,15,192,252,0,63,0,0,190,0,47,255,255,240,63,0,0,190,0,47,255,255,240,63,255,255,254,0,31,255,255,240,63,255,255,254,0,4,0,252,0,63,170,170,254,0,0,0,252,0,63,0,0,190,0,0,0,252,0,63,0,0,190,0,0,0,252,0,63,85,85,190,0,0,0,254,184,63,255,255,254,0,0,107,255,248,63,255,255,254,0,127,255,255,248,63,0,0,190,0,127,255,255,144,63,0,0,190,0,63,255,252,0,63,0,0,191,244,62,64,252,0,127,90,191,255,244,0,0,252,15,255,255,255,255,244,0,0,252,15,255,255,255,254,0,0,0,252,15,250,149,0,190,0,0,0,252,0,0,0,0,190,0,0,0,252,0,0,0,0,190,0,0,0,252,0,0,0,0,190,0,
  // 0x8f93  输
  147,143,35,35,59,37,1,253,0,37,0,0,0,3,128,0,0,0,63,0,0,0,15,240,0,0,0,127,0,0,0,63,224,0,0,0,126,0,0,0,255,244,0,0,0,190,0,0,3,255,254,0,0,127,255,255,128,31,248,191,192,0,127,255,255,128,191,224,47,248,0,127,255,255,135,255,128,7,255,128,1,248,0,127,253,0,1,255,244,2,244,0,255,255,255,255,255,244,3,240,0,63,255,255,255,250,224,3,243,240,4,191,255,255,244,64,7,211,240,0,0,0,0,0,0,11,195,240,0,0,0,0,1,64,15,195,240,10,170,170,0,7,192,31,67,240,15,255,255,15,71,192,63,255,255,143,255,255,15,135,192,63,255,255,143,192,47,15,135,192,47,255,255,143,192,47,15,135,192,20,3,240,15,234,191,15,135,192,0,3,240,15,255,255,15,135,192,0,3,240,15,255,255,15,135,192,0,3,240,15,192,47,15,135,192,0,3,255,143,192,47,15,135,192,6,255,255,143,234,191,15,135,192,127,255,255,79,255,255,15,135,192,63,255,240,15,255,255,15,135,192,63,147,240,15,192,47,15,135,192,0,3,240,15,192,47,15,71,192,0,3,240,15,192,47,0,7,192,0,3,240,15,192,47,0,7,192,0,3,240,15,192,47,0,11,192,0,3,240,15,195,255,7,255,192,0,3,240,15,195,254,3,255,192,0,3,240,11,193,164,2,169,0,
  // 0x8fb9  边
  185,143,35,36,68,37,1,252,0,64,0,0,1,84,0,0,0,2,224,0,0,3,248,0,0,0,11,248,0,0,3,248,0,0,0,3,254,0,0,3,248,0,0,0,0,255,128,0,3,248,0,0,0,0,63,208,0,3,248,0,0,0,0,31,240,85,87,249,85,85,64,0,11,209,255,255,255,255,255,192,0,2,1,255,255,255,255,255,192,0,0,1,255,255,255,255,255,192,0,0,0,0,7,240,0,47,192,0,0,0,0,11,240,0,47,192,21,85,0,0,11,240,0,47,192,127,255,128,0,15,224,0,47,192,127,255,128,0,15,224,0,47,192,127,255,128,0,31,208,0,47,192,0,63,128,0,47,192,0,63,128,0,63,128,0,63,192,0,63,128,0,63,128,0,127,64,0,63,128,0,63,128,0,191,0,0,63,128,0,63,128,0,255,0,0,63,64,0,63,128,3,252,0,0,127,64,0,63,128,11,248,0,0,127,0,0,63,128,31,240,0,0,191,0,0,63,128,191,208,0,1,255,0,0,63,130,255,64,31,255,254,0,0,63,131,254,0,15,255,252,0,0,191,192,244,0,11,255,240,0,3,255,244,0,0,1,85,0,0,15,255,254,0,0,0,0,0,0,63,241,255,249,0,0,0,85,168,255,192,47,255,255,255,255,255,244,127,0,7,255,255,255,255,255,240,45,0,0,111,255,255,255,255,240,8,0,0,0,21,85,85,64,0,0,0,0,0,0,0,0,0,0,
  // 0x8fc1  迁
  193,143,35,35,59,37,1,253,0,0,0,0,0,0,0,16,0,1,244,0,0,0,0,27,248,0,3,255,0,0,1,111,255,254,0,1,255,208,90,255,255,255,249,0,0,47,244,255,255,255,249,0,0,0,11,244,255,255,255,0,0,0,0,1,208,101,0,191,0,0,0,0,0,0,0,0,191,0,0,0,3,64,0,0,0,191,0,0,0,15,224,0,0,0,191,0,0,0,31,253,0,0,0,191,0,0,0,3,255,128,0,0,191,0,0,0,0,127,224,0,0,191,0,0,0,0,15,199,255,255,255,255,255,240,0,2,7,255,255,255,255,255,240,0,0,7,255,255,255,255,255,240,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,63,255,192,0,0,191,0,0,0,63,255,192,0,0,191,0,0,0,63,255,192,0,0,191,0,0,0,0,15,192,0,0,191,0,0,0,0,15,192,0,0,191,0,0,0,0,15,192,0,0,191,0,0,0,0,15,192,0,0,191,0,0,0,0,15,192,0,0,191,0,0,0,0,15,192,0,0,191,0,0,0,0,47,224,0,0,191,0,0,0,0,255,248,0,0,191,0,0,0,11,255,255,64,0,21,0,0,0,63,248,191,250,80,0,0,21,84,127,224,47,255,255,255,255,255,244,63,64,2,255,255,255,255,255,240,28,0,0,27,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x8fd0  运
  208,143,35,35,59,37,1,253,0,64,0,0,0,0,0,0,0,1,244,0,0,0,0,0,0,0,7,255,0,47,255,255,255,255,0,1,255,208,47,255,255,255,255,0,0,47,244,47,255,255,255,255,0,0,11,240,0,0,0,0,0,0,0,1,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,64,0,0,0,0,0,0,0,47,244,0,0,0,0,0,0,0,31,254,0,0,0,0,0,0,0,2,255,195,255,255,255,255,255,248,0,127,195,255,255,255,255,255,248,0,15,67,255,255,255,255,255,248,0,1,0,0,31,224,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,63,192,7,0,0,0,0,0,0,63,128,63,128,0,63,255,128,0,191,0,31,208,0,63,255,128,0,254,0,11,240,0,63,255,128,1,253,0,3,252,0,0,47,128,2,252,0,1,254,0,0,47,128,3,244,0,85,255,0,0,47,129,175,255,255,255,255,192,0,47,130,255,255,255,255,255,208,0,47,130,255,255,255,234,95,240,0,47,193,254,149,0,0,7,240,0,127,208,0,0,0,0,3,128,2,255,244,0,0,0,0,0,0,11,255,255,0,0,0,0,0,0,127,244,255,249,64,0,0,5,80,127,208,63,255,255,255,255,255,244,63,0,7,255,255,255,255,255,240,28,0,0,43,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x8fd1  近
  209,143,35,35,59,37,1,253,0,0,0,0,0,0,0,96,0,3,64,0,0,0,0,111,252,0,15,224,0,4,1,175,255,255,0,31,252,0,15,255,255,255,244,0,7,255,0,15,255,255,233,0,0,0,255,192,15,255,148,0,0,0,0,63,224,15,224,0,0,0,0,0,15,208,15,224,0,0,0,0,0,3,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,255,255,255,255,240,0,0,0,15,255,255,255,255,240,0,0,0,15,255,255,255,255,240,0,0,0,15,224,0,254,0,0,63,255,192,15,208,0,254,0,0,63,255,192,15,192,0,254,0,0,63,255,192,31,192,0,254,0,0,0,31,192,47,192,0,254,0,0,0,31,192,63,128,0,254,0,0,0,31,192,63,64,0,254,0,0,0,31,192,191,0,0,254,0,0,0,31,192,254,0,0,254,0,0,0,31,194,253,0,0,254,0,0,0,31,195,252,0,0,254,0,0,0,31,207,244,0,0,254,0,0,0,31,199,224,0,0,254,0,0,0,63,225,192,0,0,254,0,0,1,255,248,0,0,0,254,0,0,11,255,255,64,0,0,0,0,0,127,248,191,254,85,85,85,85,100,127,208,47,255,255,255,255,255,244,63,64,2,255,255,255,255,255,240,28,0,0,27,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x8fd4  返
  212,143,35,34,50,37,1,253,3,64,0,0,0,0,0,0,0,31,208,0,63,255,255,255,255,192,31,248,0,63,255,255,255,255,192,7,254,0,63,255,255,255,255,192,1,255,128,63,64,0,0,0,0,0,127,208,63,64,0,0,0,0,0,31,192,63,64,0,0,0,0,0,11,0,63,64,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,255,255,255,254,0,0,0,0,63,255,255,255,255,0,0,0,0,63,255,255,255,254,0,0,0,0,63,127,64,1,252,0,0,0,0,63,111,192,3,252,0,63,255,128,63,79,208,7,244,0,63,255,128,63,11,240,15,240,0,63,255,128,127,7,244,31,208,0,0,47,128,127,2,252,63,192,0,0,47,128,190,0,255,255,64,0,0,47,128,253,0,127,254,0,0,0,47,129,252,0,47,252,0,0,0,47,130,252,0,63,252,0,0,0,47,131,248,1,255,255,64,0,0,47,135,240,11,255,255,240,0,0,47,143,224,191,248,47,255,64,0,47,159,195,255,208,7,255,240,0,127,211,129,254,0,0,191,224,2,255,244,0,224,0,0,11,192,11,255,255,64,0,0,0,0,0,127,244,255,250,84,0,5,85,84,127,208,63,255,255,255,255,255,240,63,0,7,255,255,255,255,255,240,28,0,0,27,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x8fd8  还
  216,143,35,36,68,37,1,252,0,64,0,0,0,0,0,0,0,2,224,0,0,0,0,0,0,0,11,248,1,85,85,85,85,85,64,3,254,3,255,255,255,255,255,208,0,255,131,255,255,255,255,255,208,0,63,211,255,255,255,255,255,208,0,31,240,0,0,47,192,0,0,0,11,208,0,0,127,128,0,0,0,2,0,0,0,255,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,15,253,0,0,0,21,85,0,0,63,253,28,0,0,127,255,128,0,191,253,191,0,0,127,255,128,2,255,253,191,192,0,127,255,128,11,253,253,47,240,0,0,63,128,47,244,253,11,252,0,0,63,128,191,208,253,3,255,0,0,63,135,255,128,253,0,255,192,0,63,159,253,0,253,0,63,224,0,63,143,244,0,253,0,15,224,0,63,131,192,0,253,0,7,64,0,63,128,0,0,253,0,0,0,0,63,128,0,0,253,0,0,0,0,63,128,0,0,253,0,0,0,0,63,128,0,0,253,0,0,0,0,63,128,0,0,253,0,0,0,0,191,192,0,0,253,0,0,0,3,255,244,0,0,253,0,0,0,15,255,254,0,0,0,0,0,0,63,241,255,249,0,0,0,85,168,255,192,47,255,255,255,255,255,248,127,0,7,255,255,255,255,255,240,45,0,0,111,255,255,255,255,240,8,0,0,0,21,85,85,64,0,0,0,0,0,0,0,0,0,0,
  // 0x8fdb  进
  219,143,35,34,50,37,1,253,2,192,0,0,127,0,63,128,0,11,240,0,0,127,0,63,128,0,7,252,0,0,127,0,63,128,0,1,255,0,0,127,0,63,128,0,0,127,192,0,127,0,63,128,0,0,47,224,85,191,85,127,149,64,0,11,209,255,255,255,255,255,192,0,3,1,255,255,255,255,255,192,0,0,1,255,255,255,255,255,192,0,0,0,0,127,0,63,128,0,0,0,0,0,127,0,63,128,0,0,0,0,0,127,0,63,128,0,0,0,0,0,127,0,63,128,0,63,255,192,0,127,0,63,128,0,63,255,192,0,127,0,63,128,0,63,255,194,255,255,255,255,255,240,0,31,194,255,255,255,255,255,240,0,31,194,255,255,255,255,255,240,0,31,192,85,254,85,127,149,80,0,31,192,1,252,0,63,128,0,0,31,192,2,252,0,63,128,0,0,31,192,3,248,0,63,128,0,0,31,192,11,244,0,63,128,0,0,31,192,31,240,0,63,128,0,0,31,192,63,208,0,63,128,0,0,31,192,255,128,0,63,128,0,0,63,208,63,0,0,63,128,0,2,255,248,12,0,0,42,64,0,11,255,255,64,0,0,0,0,0,47,240,127,254,84,0,85,106,244,127,192,15,255,255,255,255,255,240,63,0,1,255,255,255,255,255,240,13,0,0,6,191,255,255,254,144,0,0,0,0,0,0,0,0,0,
  // 0x8fde  连
  222,143,35,36,68,37,1,252,0,64,0,0,14,0,0,0,0,2,224,0,0,31,208,0,0,0,11,244,0,0,47,192,0,0,0,3,253,0,0,63,192,0,0,0,0,255,3,255,255,255,255,255,192,0,127,195,255,255,255,255,255,192,0,47,211,255,255,255,255,255,192,0,15,208,2,252,0,0,0,0,0,7,0,3,248,5,64,0,0,0,0,0,7,244,15,208,0,0,0,0,0,15,240,15,208,0,0,0,0,0,31,208,15,208,0,0,0,0,0,63,192,15,208,0,0,127,255,128,255,255,255,255,255,0,127,255,128,255,255,255,255,255,0,127,255,128,127,255,255,255,255,0,0,47,128,36,0,31,208,0,0,0,47,128,0,0,15,208,0,0,0,47,128,0,0,15,208,0,0,0,47,128,0,0,15,208,0,0,0,47,128,0,0,31,224,0,0,0,47,131,255,255,255,255,255,224,0,47,131,255,255,255,255,255,224,0,47,131,255,255,255,255,255,224,0,47,128,0,0,15,208,0,0,0,47,128,0,0,15,208,0,0,0,47,128,0,0,15,208,0,0,0,127,128,0,0,15,208,0,0,2,255,240,0,0,15,208,0,0,15,255,254,0,0,15,208,0,0,63,245,255,249,0,0,0,21,168,191,192,47,255,255,255,255,255,248,127,0,7,255,255,255,255,255,240,46,0,0,111,255,255,255,255,240,8,0,0,0,21,85,85,64,0,0,0,0,0,0,0,0,0,0,
  // 0x8ff7  迷
  247,143,35,35,59,37,1,253,0,0,0,0,0,84,0,0,0,3,64,0,0,0,254,0,0,0,15,224,0,108,0,254,0,62,64,31,252,0,254,0,254,0,63,128,7,255,0,191,0,254,0,191,0,0,255,192,63,128,254,0,254,0,0,63,224,47,192,254,2,252,0,0,15,192,15,208,254,3,244,0,0,3,0,11,240,254,11,240,0,0,0,0,7,144,254,7,208,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,7,255,255,255,255,255,224,0,0,7,255,255,255,255,255,224,0,0,7,255,255,255,255,255,224,63,255,192,0,15,255,240,0,0,63,255,192,0,31,255,244,0,0,63,255,192,0,63,255,252,0,0,0,31,192,0,255,254,191,0,0,0,31,192,2,252,254,63,128,0,0,31,192,7,248,254,31,224,0,0,31,192,31,240,254,11,248,0,0,31,192,127,192,254,3,254,0,0,31,194,255,64,254,0,255,192,0,31,207,253,0,254,0,63,240,0,31,199,244,0,254,0,15,208,0,31,193,208,0,254,0,3,64,0,63,224,0,0,254,0,0,0,1,255,248,0,0,254,0,0,0,11,255,255,64,0,0,0,0,0,127,248,191,254,85,85,85,85,100,127,208,47,255,255,255,255,255,244,63,64,2,255,255,255,255,255,240,28,0,0,27,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x9000  退
  0,144,35,33,41,37,1,253,7,208,0,31,255,255,255,252,0,31,244,0,31,255,255,255,252,0,11,254,0,31,255,255,255,252,0,1,255,192,31,192,0,1,252,0,0,63,240,31,192,0,1,252,0,0,15,224,31,234,170,171,252,0,0,3,64,31,255,255,255,252,0,0,0,0,31,255,255,255,252,0,0,0,0,31,192,0,1,252,0,0,0,0,31,192,0,1,252,0,0,0,0,31,192,0,1,252,0,0,0,0,31,255,255,255,252,0,0,0,0,31,255,255,255,252,0,63,255,192,31,255,255,255,252,0,63,255,192,31,192,63,64,15,64,63,255,192,31,192,47,192,127,208,0,31,192,31,192,15,210,255,64,0,31,192,31,192,11,255,252,0,0,31,192,31,192,7,255,208,0,0,31,192,31,192,2,255,0,0,0,31,192,31,192,0,255,64,0,0,31,192,31,193,174,127,208,0,0,31,192,31,255,255,31,248,0,0,31,193,255,255,255,7,255,144,0,31,194,255,255,144,1,255,240,0,63,225,255,144,0,0,47,192,1,255,248,144,0,0,0,3,64,11,255,255,64,0,0,0,0,0,127,248,191,254,85,85,85,85,100,127,208,47,255,255,255,255,255,244,63,64,2,255,255,255,255,255,240,28,0,0,27,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x9009  选
  9,144,34,35,59,37,2,253,0,0,0,0,0,169,0,0,0,4,0,0,9,0,253,0,0,0,63,0,0,31,192,253,0,0,0,191,208,0,47,192,253,0,0,0,47,244,0,63,128,253,0,0,0,11,252,0,127,255,255,255,254,0,2,255,0,255,255,255,255,254,0,0,191,65,255,255,255,255,254,0,0,60,3,252,0,253,0,0,0,0,0,15,240,0,253,0,0,0,0,0,7,224,0,253,0,0,0,0,0,0,128,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,15,255,255,255,255,255,192,0,0,15,255,255,255,255,255,192,255,254,15,255,255,255,255,255,192,255,254,0,0,254,3,244,0,0,255,254,0,0,253,3,244,0,0,0,190,0,1,252,3,244,0,0,0,190,0,2,252,3,244,0,0,0,190,0,3,248,3,244,0,0,0,190,0,11,244,3,244,10,0,0,190,0,15,240,3,244,11,208,0,190,0,63,208,3,244,11,208,0,190,2,255,128,3,244,15,192,0,190,31,254,0,3,255,255,192,0,190,31,248,0,2,255,255,128,0,191,139,192,0,0,255,255,0,2,255,245,0,0,0,0,0,0,15,255,254,0,0,0,0,0,0,63,244,191,229,0,0,0,86,144,255,192,31,255,255,255,255,255,192,255,0,3,255,255,255,255,255,192,60,0,0,27,255,255,255,255,128,20,0,0,0,0,0,0,0,0,
  // 0x901f  速
  31,144,35,35,59,37,1,253,0,0,0,0,0,190,0,0,0,2,64,0,0,0,190,0,0,0,15,208,0,0,0,190,0,0,0,47,248,0,0,0,190,0,0,0,7,254,3,255,255,255,255,255,240,1,255,131,255,255,255,255,255,240,0,63,227,255,255,255,255,255,224,0,15,208,0,0,190,0,0,0,0,3,0,0,0,190,0,0,0,0,0,0,106,170,255,170,170,0,0,0,0,191,255,255,255,255,64,0,0,0,191,255,255,255,255,64,0,0,0,189,0,190,0,63,64,0,0,0,189,0,190,0,63,64,0,0,0,189,0,190,0,63,64,63,255,192,189,0,190,0,63,64,63,255,192,191,170,255,170,191,64,63,255,192,191,255,255,255,255,64,0,31,192,191,255,255,255,255,64,0,31,192,0,11,255,224,0,0,0,31,192,0,47,255,248,0,0,0,31,192,0,127,255,254,0,0,0,31,192,2,253,190,127,128,0,0,31,192,11,248,190,31,244,0,0,31,192,127,224,190,7,254,0,0,31,199,255,128,190,1,255,224,0,31,199,253,0,190,0,63,208,0,63,226,240,0,190,0,11,128,1,255,248,64,0,190,0,1,0,11,255,255,64,0,85,0,0,0,127,248,191,254,85,85,85,85,100,127,208,47,255,255,255,255,255,244,63,64,2,255,255,255,255,255,240,28,0,0,27,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x90e8  部
  232,144,35,35,59,37,1,253,0,0,106,0,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,63,255,255,192,0,0,127,0,0,63,255,255,244,47,255,255,255,252,63,255,255,240,47,255,255,255,252,63,64,31,240,47,255,255,255,252,63,0,31,208,0,0,0,4,0,63,0,47,192,0,252,0,31,192,63,0,63,128,0,252,0,47,128,63,0,127,0,0,189,0,63,64,63,0,254,0,0,126,0,63,0,63,0,253,0,0,63,0,126,0,63,2,252,0,0,63,0,253,0,63,3,244,0,0,36,0,24,0,63,7,240,0,127,255,255,255,254,63,11,240,0,127,255,255,255,254,63,2,252,0,127,255,255,255,254,63,0,255,0,0,0,0,0,0,63,0,63,64,0,0,0,0,0,63,0,47,192,0,0,0,0,0,63,0,15,208,3,255,255,255,224,63,0,11,224,3,255,255,255,224,63,0,7,240,3,255,255,255,224,63,0,7,240,3,240,0,11,224,63,0,7,240,3,240,0,11,224,63,0,11,240,3,240,0,11,224,63,0,31,240,3,240,0,11,224,63,15,255,224,3,240,0,11,224,63,15,255,192,3,240,0,11,224,63,11,255,0,3,255,255,255,224,63,1,80,0,3,255,255,255,224,63,0,0,0,3,255,255,255,224,63,0,0,0,3,240,0,11,224,63,0,0,0,3,240,0,11,224,63,0,0,0,
  // 0x914d  配
  77,145,34,33,41,37,2,253,255,255,255,255,143,255,255,255,64,255,255,255,255,143,255,255,255,64,255,255,255,255,143,255,255,255,64,0,62,47,0,1,85,85,127,64,0,62,47,0,0,0,0,63,64,0,62,47,0,0,0,0,63,64,63,255,255,254,0,0,0,63,64,63,255,255,255,0,0,0,63,64,63,255,255,255,0,0,0,63,64,62,29,60,63,0,0,0,63,64,62,29,60,63,0,0,0,63,64,62,29,60,63,0,0,0,63,64,62,29,60,63,11,255,255,255,64,62,29,60,63,11,255,255,255,64,62,29,60,63,11,255,255,255,64,62,44,60,63,11,224,0,63,64,62,60,60,63,11,224,0,63,64,62,180,47,255,11,224,0,21,0,63,240,31,255,11,224,0,0,0,62,64,0,63,11,224,0,0,0,62,0,0,63,11,224,0,0,0,63,85,85,127,11,224,0,0,0,63,255,255,255,11,224,0,0,0,63,255,255,255,11,224,0,6,0,62,0,0,63,11,224,0,7,224,62,0,0,63,11,224,0,11,224,62,0,0,63,11,224,0,11,224,63,170,170,191,11,224,0,15,208,63,255,255,255,11,240,0,31,192,63,255,255,255,7,255,255,255,192,62,0,0,63,3,255,255,255,64,62,0,0,63,1,255,255,254,0,41,0,0,0,0,0,0,0,0,
  // 0x91ca  释
  202,145,35,35,59,37,1,253,0,0,0,80,0,0,0,0,0,0,1,175,240,0,0,0,0,0,47,255,255,252,255,255,255,255,208,63,255,255,228,255,255,255,255,224,47,175,240,0,255,255,255,255,192,0,7,224,0,15,192,0,63,128,5,7,224,120,7,224,0,255,0,63,7,224,252,3,244,3,252,0,31,135,224,248,1,253,15,240,0,15,199,226,240,0,127,127,192,0,7,215,227,224,0,47,255,0,0,3,231,231,192,0,15,254,0,0,1,7,224,0,0,191,255,208,0,0,7,224,0,7,255,111,254,64,63,255,255,245,191,244,7,255,248,63,255,255,251,255,128,0,191,244,63,255,255,246,248,1,80,11,240,0,15,240,0,64,3,240,0,144,0,47,252,0,0,3,240,0,0,0,63,255,0,0,3,240,0,0,0,191,255,192,191,255,255,255,64,0,255,255,240,191,255,255,255,64,3,251,227,252,191,255,255,255,64,11,231,224,244,0,3,240,0,0,31,199,224,80,0,3,240,0,0,127,135,224,0,0,3,240,0,0,191,7,224,3,255,255,255,255,240,61,7,224,3,255,255,255,255,240,40,7,224,3,255,255,255,255,240,0,7,224,0,0,7,244,0,0,0,7,224,0,0,3,240,0,0,0,7,224,0,0,3,240,0,0,0,7,224,0,0,3,240,0,0,0,7,224,0,0,3,240,0,0,0,7,224,0,0,3,240,0,0,
  // 0x91cd  重
  205,145,33,34,50,37,2,254,0,0,0,0,0,0,90,0,0,0,0,0,5,106,255,255,64,0,2,191,255,255,255,255,255,192,0,2,255,255,255,255,255,233,0,0,1,255,169,91,244,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,170,170,170,175,254,170,170,170,128,0,0,0,7,240,0,0,0,0,0,85,85,91,245,85,85,64,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,253,0,7,240,0,15,208,0,0,253,0,7,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,253,0,11,240,0,31,208,0,0,253,0,7,240,0,15,208,0,0,253,0,7,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,85,85,91,245,85,85,64,0,0,0,0,7,240,0,0,0,0,2,170,170,175,250,170,170,164,0,3,255,255,255,255,255,255,248,0,3,255,255,255,255,255,255,248,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x91cf  量
  207,145,33,33,41,37,2,254,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,0,0,0,0,63,64,0,0,127,0,0,0,0,63,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,127,0,0,0,0,63,64,0,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,170,170,170,170,170,170,170,170,128,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,252,0,3,240,0,15,208,0,0,252,0,3,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,252,0,3,240,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,0,0,3,240,0,0,0,0,0,0,0,3,240,0,0,0,0,3,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,1,85,85,87,245,85,85,80,0,0,0,0,3,240,0,0,0,0,170,170,170,171,250,170,170,170,128,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,
  // 0x9488  针
  136,148,34,35,59,37,1,253,0,25,0,0,0,2,164,0,0,0,63,128,0,0,3,248,0,0,0,127,0,0,0,3,248,0,0,0,254,0,0,0,3,248,0,0,1,255,255,248,0,3,248,0,0,3,255,255,248,0,3,248,0,0,15,255,255,248,0,3,248,0,0,47,224,0,0,0,3,248,0,0,127,192,0,0,0,3,248,0,0,191,0,0,0,0,3,248,0,0,61,0,0,0,0,3,248,0,0,43,255,255,224,0,3,248,0,0,3,255,255,226,170,171,254,170,160,3,255,255,231,255,255,255,255,240,0,7,240,7,255,255,255,255,240,0,7,240,7,255,255,255,255,240,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,47,255,255,244,0,3,248,0,0,47,255,255,244,0,3,248,0,0,47,255,255,244,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,0,0,3,248,0,0,0,7,240,44,0,3,248,0,0,0,7,242,252,0,3,248,0,0,0,11,255,253,0,3,248,0,0,0,15,255,244,0,3,248,0,0,0,63,255,64,0,3,248,0,0,0,63,244,0,0,3,248,0,0,0,31,128,0,0,3,248,0,0,0,8,0,0,0,3,244,0,0,
  // 0x94ae  钮
  174,148,35,35,59,37,1,253,0,100,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,252,0,3,255,255,255,255,192,1,252,0,3,255,255,255,255,192,3,255,255,243,255,255,255,255,192,7,255,255,240,0,63,64,47,128,15,255,255,240,0,63,0,47,128,47,213,85,80,0,127,0,47,128,63,128,0,0,0,127,0,63,128,255,0,0,0,0,127,0,63,64,189,0,0,0,0,191,0,63,64,63,255,255,192,0,190,0,63,64,39,255,255,192,0,190,0,63,64,3,255,255,192,0,253,0,63,0,0,15,192,0,0,253,0,63,0,0,15,192,3,255,255,255,255,0,0,15,192,3,255,255,255,255,0,0,15,192,3,255,255,255,255,0,0,15,192,0,86,253,85,191,0,63,255,255,240,2,252,0,190,0,63,255,255,240,2,248,0,190,0,63,255,255,240,3,248,0,190,0,0,15,192,0,3,244,0,254,0,0,15,192,0,3,244,0,253,0,0,15,192,0,3,240,0,253,0,0,15,192,0,7,240,0,252,0,0,15,192,0,7,240,0,252,0,0,15,194,224,11,240,1,252,0,0,15,239,240,11,224,1,252,0,0,15,255,224,15,224,2,252,0,0,31,255,85,95,229,87,253,80,0,63,248,191,255,255,255,255,244,0,191,192,191,255,255,255,255,244,0,61,0,191,255,255,255,255,244,0,16,0,0,0,0,0,0,0,
  // 0x9519  错
  25,149,35,35,59,37,1,253,0,20,0,0,3,224,11,208,0,0,63,0,0,3,240,11,208,0,0,127,0,0,3,240,11,208,0,0,254,0,0,3,240,11,208,0,1,253,0,0,3,240,11,208,0,3,255,255,242,255,255,255,255,224,11,255,255,242,255,255,255,255,224,31,255,255,242,255,255,255,255,224,127,192,0,0,3,240,11,208,0,127,0,0,0,3,240,11,208,0,61,0,0,0,3,240,11,208,0,27,255,255,208,3,240,11,208,0,3,255,255,219,255,255,255,255,244,3,255,255,219,255,255,255,255,244,0,15,208,11,255,255,255,255,244,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,127,255,255,255,0,47,255,255,240,127,255,255,255,0,47,255,255,240,127,255,255,255,0,47,255,255,240,127,0,0,63,0,0,15,208,0,127,0,0,63,0,0,15,208,0,127,0,0,63,0,0,15,208,0,127,170,170,255,0,0,15,208,0,127,255,255,255,0,0,15,208,0,127,255,255,255,0,0,15,208,144,127,0,0,63,0,0,15,235,224,127,0,0,63,0,0,15,255,240,127,0,0,63,0,0,31,255,128,127,255,255,255,0,0,127,253,0,127,255,255,255,0,0,63,208,0,127,255,255,255,0,0,46,0,0,127,0,0,63,0,0,0,0,0,42,0,0,21,0,
  // 0x955c  镜
  92,149,35,36,68,37,1,252,0,40,0,0,0,11,208,0,0,0,63,0,0,0,7,240,0,0,0,191,0,1,255,255,255,255,192,0,253,0,1,255,255,255,255,208,2,255,255,209,255,255,255,255,208,3,255,255,208,2,128,1,144,0,15,255,255,208,11,224,3,244,0,31,208,0,0,3,240,3,240,0,127,192,0,0,3,240,7,224,0,127,0,0,11,255,255,255,255,240,62,0,0,11,255,255,255,255,240,31,255,255,203,255,255,255,255,240,3,255,255,192,0,0,0,0,0,3,255,255,192,0,0,0,0,0,0,15,192,0,255,255,255,255,128,0,15,192,0,255,255,255,255,128,0,15,192,0,253,0,0,47,128,0,15,192,0,252,0,0,47,128,0,15,192,0,255,255,255,255,128,63,255,255,240,255,255,255,255,128,63,255,255,240,252,0,0,47,128,63,255,255,240,252,0,0,47,128,0,15,192,0,253,0,0,47,128,0,15,192,0,255,255,255,255,128,0,15,192,0,255,255,255,255,128,0,15,192,0,2,248,47,128,0,0,15,192,80,3,244,47,128,0,0,15,199,224,3,240,47,128,0,0,15,255,240,11,240,47,128,64,0,31,255,208,15,224,47,128,244,0,63,254,0,63,192,47,128,248,0,255,244,2,255,128,47,129,248,0,191,128,127,254,0,31,255,244,0,61,0,63,244,0,15,255,240,0,16,0,30,64,0,1,170,64,0,0,0,0,0,0,0,0,0,
  // 0x957f  长
  127,149,34,35,59,37,2,253,0,2,164,0,0,0,0,0,0,0,3,244,0,0,0,46,0,0,0,3,244,0,0,0,191,192,0,0,3,244,0,0,2,255,64,0,0,3,244,0,0,15,253,0,0,0,3,244,0,0,127,244,0,0,0,3,244,0,2,255,208,0,0,0,3,244,0,31,255,0,0,0,0,3,244,1,255,248,0,0,0,0,3,244,31,255,208,0,0,0,0,3,244,47,254,0,0,0,0,0,3,244,11,224,0,0,0,0,0,3,244,2,0,0,0,0,0,0,3,244,0,0,0,0,0,0,85,87,249,85,85,85,85,85,64,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,3,244,0,254,0,0,0,0,0,3,244,0,191,0,0,0,0,0,3,244,0,63,128,0,0,0,0,3,244,0,47,208,0,0,0,0,3,244,0,15,240,0,0,0,0,3,244,0,11,252,0,0,0,0,3,244,0,3,254,0,0,0,0,3,244,0,0,255,128,0,0,0,3,244,0,0,127,240,0,0,0,3,244,0,4,47,253,0,0,0,3,244,6,252,11,255,128,0,0,3,254,255,252,1,255,253,0,0,11,255,255,252,0,127,255,208,0,31,255,255,144,0,11,255,192,0,15,255,144,0,0,0,191,0,0,15,224,0,0,0,0,5,0,0,4,0,0,0,0,0,0,0,
  // 0x95ed  闭
  237,149,31,36,32,37,3,252,1,0,0,0,0,0,0,0,31,64,0,0,0,0,0,0,63,208,15,255,255,255,255,252,15,244,15,255,255,255,255,252,3,252,15,255,255,255,255,252,1,255,0,0,0,0,2,252,0,189,0,0,0,0,1,252,0,32,0,0,26,128,1,252,0,0,0,0,47,192,1,252,254,0,0,0,47,192,1,252,254,0,0,0,47,192,1,252,254,0,0,0,47,192,1,252,254,0,0,0,47,192,1,252,254,15,255,255,255,255,225,252,254,15,255,255,255,255,225,252,254,15,255,255,255,255,225,252,254,0,0,3,255,192,1,252,254,0,0,11,255,192,1,252,254,0,0,31,255,192,1,252,254,0,0,127,239,192,1,252,254,0,1,255,47,192,1,252,254,0,7,253,47,192,1,252,254,0,47,244,47,192,1,252,254,0,255,208,47,192,1,252,254,11,255,64,47,192,1,252,254,63,252,0,47,192,1,252,254,63,224,0,47,192,1,252,254,15,64,0,47,192,1,252,254,0,0,85,127,192,1,252,254,0,0,191,255,192,1,252,254,0,0,127,255,64,1,252,254,0,0,63,249,0,2,252,254,0,0,0,0,2,255,252,254,0,0,0,0,1,255,244,254,0,0,0,0,0,255,144,0,0,0,0,0,0,0,0,
  // 0x95f2  闲
  242,149,31,35,24,37,3,253,1,0,0,0,0,0,0,0,11,192,0,0,0,0,0,0,31,224,11,255,255,255,255,252,11,248,11,255,255,255,255,252,2,253,11,255,255,255,255,252,0,255,64,0,0,0,1,252,0,63,192,0,0,0,1,252,0,31,192,0,0,0,1,252,84,10,0,10,128,0,1,252,252,0,0,15,192,0,1,252,252,0,0,15,192,0,1,252,252,0,0,15,192,0,1,252,252,0,0,15,192,0,1,252,252,15,255,255,255,255,225,252,252,15,255,255,255,255,225,252,252,15,255,255,255,255,225,252,252,0,0,191,248,0,1,252,252,0,0,255,253,0,1,252,252,0,3,255,255,64,1,252,252,0,11,255,239,208,1,252,252,0,31,207,207,244,1,252,252,0,63,79,195,252,1,252,252,0,255,15,192,255,1,252,252,3,252,15,192,127,129,252,252,31,244,15,192,47,209,252,252,63,208,15,192,15,129,252,252,15,64,15,192,1,1,252,252,0,0,15,192,0,1,252,252,0,0,15,192,0,1,252,252,0,0,15,192,0,1,252,252,0,0,15,192,0,2,252,252,0,0,5,64,47,255,252,252,0,0,0,0,31,255,244,252,0,0,0,0,15,255,208,252,0,0,0,0,5,80,0,
  // 0x95f4  间
  244,149,31,36,32,37,3,252,1,0,0,0,0,0,0,0,31,64,0,0,0,0,0,0,63,208,15,255,255,255,255,252,15,244,15,255,255,255,255,252,3,252,15,255,255,255,255,252,1,255,0,0,0,0,2,252,0,188,0,0,0,0,2,252,0,32,0,0,0,0,2,252,0,0,0,0,0,0,2,252,255,0,0,0,0,0,2,252,255,0,0,0,0,0,2,252,255,0,191,255,255,248,2,252,255,0,191,255,255,248,2,252,255,0,191,255,255,248,2,252,255,0,189,0,1,248,2,252,255,0,189,0,1,248,2,252,255,0,189,0,1,248,2,252,255,0,189,0,1,248,2,252,255,0,191,255,255,248,2,252,255,0,191,255,255,248,2,252,255,0,191,255,255,248,2,252,255,0,189,0,1,248,2,252,255,0,189,0,1,248,2,252,255,0,189,0,1,248,2,252,255,0,189,0,1,248,2,252,255,0,191,255,255,248,2,252,255,0,191,255,255,248,2,252,255,0,191,255,255,248,2,252,255,0,0,0,0,0,2,252,255,0,0,0,0,0,2,252,255,0,0,0,0,0,2,252,255,0,0,0,0,0,2,252,255,0,0,0,0,0,255,252,255,0,0,0,0,0,255,244,255,0,0,0,0,0,191,144,0,0,0,0,0,0,0,0,
  // 0x9608  阈
  8,150,31,36,32,37,3,252,2,192,0,0,0,0,0,0,15,240,11,255,255,255,255,248,7,252,11,255,255,255,255,248,2,254,11,255,255,255,255,248,0,191,64,0,0,0,2,248,0,63,192,0,0,0,2,248,0,31,208,0,184,16,2,248,0,11,64,0,252,248,2,248,254,0,0,0,252,190,2,248,254,0,0,0,252,47,2,248,254,0,0,0,252,8,2,248,254,47,255,255,255,255,226,248,254,47,255,255,255,255,226,248,254,26,170,170,254,170,146,248,254,0,0,0,188,0,2,248,254,0,0,0,125,10,66,248,254,11,255,248,125,15,66,248,254,11,255,248,125,31,2,248,254,11,128,184,62,63,2,248,254,11,128,184,62,62,2,248,254,11,128,184,63,188,2,248,254,11,255,248,47,252,2,248,254,11,255,248,31,244,2,248,254,0,0,0,31,240,2,248,254,0,0,0,15,208,162,248,254,0,26,254,31,192,246,248,254,47,255,254,63,224,242,248,254,63,255,233,255,250,242,248,254,47,148,3,249,255,226,248,254,0,0,31,224,191,194,248,254,0,0,15,128,31,66,248,254,0,0,1,0,0,3,248,254,0,0,0,0,31,255,248,254,0,0,0,0,15,255,240,254,0,0,0,0,11,255,128,0,0,0,0,0,0,0,0,
  // 0x964d  降
  77,150,33,35,59,37,3,253,0,0,0,0,11,144,0,0,0,0,0,0,0,15,208,0,0,0,255,255,224,0,63,192,0,0,0,255,255,252,0,191,234,171,128,0,255,255,244,1,255,255,255,240,0,252,3,240,7,255,255,255,208,0,252,7,240,31,248,0,63,192,0,252,11,208,127,253,0,127,0,0,252,15,194,255,191,1,254,0,0,252,31,195,252,63,199,252,0,0,252,47,64,224,15,255,240,0,0,252,63,0,0,3,255,192,0,0,252,126,0,0,3,255,208,0,0,252,126,0,0,47,255,253,0,0,252,63,64,6,255,235,255,228,0,252,15,193,191,255,0,191,255,128,252,11,227,255,244,10,175,255,0,252,3,241,254,64,15,208,125,0,252,3,240,144,0,15,208,0,0,252,2,244,127,255,255,255,252,0,252,2,244,191,255,255,255,252,0,252,2,244,191,255,255,255,252,0,252,3,244,3,240,15,208,0,0,252,255,240,3,240,15,208,0,0,252,191,224,3,240,15,208,0,0,252,191,64,3,240,15,208,0,0,252,0,7,255,255,255,255,255,0,252,0,7,255,255,255,255,255,0,252,0,7,255,255,255,255,255,0,252,0,0,0,0,15,208,0,0,252,0,0,0,0,15,208,0,0,252,0,0,0,0,15,208,0,0,252,0,0,0,0,15,208,0,0,252,0,0,0,0,15,208,0,0,252,0,0,0,0,15,208,0,0,
  // 0x9650  限
  80,150,32,33,8,37,3,253,255,255,248,47,255,255,255,240,255,255,254,47,255,255,255,240,255,255,253,47,255,255,255,240,253,1,252,47,128,0,3,240,253,2,248,47,128,0,3,240,253,3,244,47,128,0,3,240,253,7,240,47,128,0,3,240,253,11,224,47,255,255,255,240,253,15,192,47,255,255,255,240,253,31,192,47,255,255,255,240,253,47,64,47,128,0,3,240,253,63,0,47,128,0,3,240,253,31,192,47,128,0,3,240,253,11,224,47,128,0,3,240,253,3,240,47,255,255,255,240,253,2,248,47,255,255,255,240,253,0,252,47,255,255,255,240,253,0,252,47,128,189,0,0,253,0,253,47,128,126,0,180,253,0,252,47,128,63,2,253,253,1,252,47,128,63,75,248,253,191,252,47,128,47,255,224,253,127,244,47,128,15,255,64,253,63,144,47,128,11,252,0,253,0,0,47,128,3,248,0,253,0,0,47,128,2,253,0,253,0,0,47,128,20,255,0,253,0,0,47,219,252,127,192,253,0,1,191,255,252,47,244,253,0,31,255,255,248,15,254,253,0,15,255,249,0,3,255,253,0,15,233,0,0,0,189,253,0,0,0,0,0,0,20,
  // 0x9664  除
  100,150,33,35,59,37,3,253,0,0,0,0,2,164,0,0,0,0,0,0,0,11,253,0,0,0,255,255,224,0,15,255,0,0,0,255,255,252,0,63,255,192,0,0,255,255,244,0,191,31,224,0,0,252,3,240,2,254,11,248,0,0,252,7,240,11,248,2,254,0,0,252,11,208,47,240,0,191,192,0,252,15,192,191,192,0,47,240,0,252,31,135,254,0,0,11,254,0,252,47,95,248,0,0,2,255,128,252,63,15,239,255,255,255,191,0,252,126,11,79,255,255,255,13,0,252,127,0,15,255,255,255,0,0,252,47,128,0,2,248,0,0,0,252,15,192,0,2,248,0,0,0,252,11,224,0,2,248,0,0,0,252,3,240,0,2,248,0,0,0,252,3,241,255,255,255,255,252,0,252,2,245,255,255,255,255,252,0,252,2,245,255,255,255,255,252,0,252,2,244,0,2,248,0,0,0,252,3,244,0,2,248,0,0,0,252,255,240,47,66,248,31,0,0,252,191,224,63,2,248,63,128,0,252,191,64,191,2,248,31,208,0,252,0,0,253,2,248,11,240,0,252,0,2,252,2,248,3,244,0,252,0,7,244,2,248,1,252,0,252,0,15,224,2,248,0,254,0,252,0,63,192,2,248,0,127,0,252,0,31,64,3,248,0,62,0,252,0,1,1,255,248,0,16,0,252,0,0,0,255,240,0,0,0,252,0,0,0,255,128,0,0,0,
  // 0x9669  险
  105,150,33,35,59,37,3,253,0,0,0,0,0,224,0,0,0,0,0,0,0,2,252,0,0,0,255,255,240,0,3,252,0,0,0,255,255,252,0,15,254,0,0,0,255,255,244,0,31,255,64,0,0,252,3,240,0,127,175,208,0,0,252,7,240,0,255,15,244,0,0,252,11,208,3,252,3,253,0,0,252,15,192,15,244,0,255,128,0,252,31,128,63,224,0,63,224,0,252,47,64,255,128,0,15,252,0,252,63,7,255,0,0,3,255,128,252,62,31,255,255,255,253,255,192,252,127,15,231,255,255,253,47,0,252,47,135,71,255,255,252,6,0,252,15,192,0,0,0,0,0,0,252,7,224,0,0,0,0,0,0,252,3,240,0,0,160,0,144,0,252,3,244,45,1,244,1,252,0,252,2,244,126,0,248,2,248,0,252,2,248,63,0,252,3,240,0,252,2,244,47,64,252,7,224,0,252,3,244,31,128,188,11,208,0,252,255,240,15,192,125,15,192,0,252,191,224,15,192,125,47,64,0,252,127,64,11,208,62,63,0,0,252,0,0,7,208,16,126,0,0,252,0,0,1,0,0,252,0,0,252,0,0,0,0,1,248,0,0,252,0,0,0,0,3,240,0,0,252,0,3,255,255,255,255,255,0,252,0,3,255,255,255,255,255,0,252,0,3,255,255,255,255,255,0,252,0,0,0,0,0,0,0,0,168,0,0,0,0,0,0,0,0,
  // 0x96f6  零
  246,150,34,34,50,37,2,253,2,170,170,170,170,170,170,160,0,3,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,0,0,0,7,240,0,0,0,0,21,85,85,87,245,85,85,85,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,0,0,7,240,0,0,63,64,127,0,0,7,240,0,0,63,64,127,47,255,199,241,255,254,63,64,127,47,255,199,241,255,254,63,64,42,0,0,7,240,0,0,42,0,0,0,0,7,240,0,0,0,0,0,127,255,192,1,255,255,64,0,0,127,255,239,249,255,255,64,0,0,0,0,191,255,64,0,0,0,0,0,11,255,127,244,0,0,0,0,0,191,248,15,255,64,0,0,0,27,255,208,1,255,249,0,0,2,255,255,85,85,127,255,228,0,191,255,159,255,255,253,191,255,208,255,248,15,255,255,252,7,255,192,190,64,0,0,0,0,0,31,64,16,0,0,0,0,0,0,0,0,1,255,255,255,255,255,255,0,0,1,255,255,255,255,255,255,0,0,0,85,85,255,85,85,191,0,0,0,0,0,190,0,0,63,0,0,0,0,0,190,0,0,127,0,0,0,0,0,190,0,106,255,0,0,0,0,0,190,0,63,255,0,0,0,0,0,190,0,63,248,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,
  // 0x9700  需
  0,151,33,34,50,37,2,253,2,170,170,170,170,170,170,160,0,3,255,255,255,255,255,255,240,0,3,255,255,255,255,255,255,240,0,0,0,0,3,240,0,0,0,0,0,0,0,3,240,0,0,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,85,85,91,245,85,85,127,64,127,0,0,3,240,0,0,63,64,127,47,255,195,241,255,254,63,64,127,47,255,195,241,255,254,63,64,127,0,0,3,240,0,0,63,64,0,0,0,3,240,0,0,0,0,0,127,255,195,241,255,255,64,0,0,127,255,195,241,255,255,64,0,0,0,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,170,170,170,170,64,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,11,240,0,0,0,0,0,0,0,15,208,0,0,0,0,2,170,170,191,250,170,170,164,0,3,255,255,255,255,255,255,248,0,3,255,255,255,255,255,255,248,0,3,244,3,244,3,244,2,248,0,3,244,3,244,3,244,2,248,0,3,244,3,244,3,244,2,248,0,3,244,3,244,3,244,2,248,0,3,244,3,244,3,244,2,248,0,3,244,3,244,3,244,2,248,0,3,244,3,244,3,244,255,244,0,3,244,3,244,3,244,127,240,0,2,164,1,160,1,160,62,128,0,
  // 0x9752  青
  82,151,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,6,170,170,175,250,170,170,164,0,7,255,255,255,255,255,255,248,0,7,255,255,255,255,255,255,248,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,0,170,170,171,250,170,170,128,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,106,170,170,175,250,170,170,170,64,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,234,170,170,170,255,0,0,0,47,128,0,0,0,191,0,0,0,47,128,0,0,0,191,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,213,85,85,85,191,0,0,0,47,128,0,0,0,191,0,0,0,47,213,85,85,85,191,0,0,0,47,255,255,255,255,255,0,0,0,47,255,255,255,255,255,0,0,0,47,128,0,0,0,191,0,0,0,47,128,0,0,0,191,0,0,0,47,128,0,0,0,191,0,0,0,47,128,0,3,255,255,0,0,0,47,128,0,2,255,253,0,0,0,47,128,0,0,170,144,0,0,
  // 0x975e  非
  94,151,35,36,68,37,1,252,0,0,2,164,0,169,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,254,0,0,0,15,255,255,248,0,255,255,255,224,15,255,255,248,0,255,255,255,224,15,255,255,248,0,255,255,255,224,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,248,0,253,0,0,0,11,255,255,248,0,255,255,255,192,11,255,255,248,0,255,255,255,192,11,255,255,248,0,255,255,255,192,0,0,3,248,0,254,0,0,0,0,0,3,248,0,253,0,0,0,0,0,3,244,0,253,0,0,0,0,0,3,244,0,253,0,0,0,0,0,7,255,208,253,0,0,0,0,22,255,255,208,254,0,0,0,127,255,255,255,208,255,255,255,244,127,255,255,245,0,255,255,255,244,63,254,191,192,0,255,255,255,244,41,0,63,192,0,253,0,0,0,0,0,255,64,0,253,0,0,0,0,2,254,0,0,253,0,0,0,0,11,252,0,0,253,0,0,0,0,47,244,0,0,253,0,0,0,1,255,208,0,0,253,0,0,0,11,255,64,0,0,253,0,0,0,11,252,0,0,0,253,0,0,0,2,208,0,0,0,253,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9760  靠
  96,151,34,36,68,37,2,252,0,5,0,3,240,0,0,0,0,0,31,192,3,240,0,0,0,0,0,63,192,7,244,0,0,0,0,0,127,255,255,255,255,255,240,0,1,255,255,255,255,255,255,240,0,7,252,0,3,240,0,0,0,0,23,249,85,91,245,85,85,85,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,0,3,240,0,0,0,0,0,0,0,5,84,0,0,0,0,0,191,255,255,255,255,255,208,0,0,191,255,255,255,255,255,208,0,0,190,0,0,0,0,15,208,0,0,190,0,0,0,0,15,208,0,0,190,0,0,0,0,15,208,0,0,191,255,255,255,255,255,208,0,0,191,255,255,255,255,255,208,0,0,0,7,240,3,244,0,0,0,0,0,11,240,3,248,0,0,0,63,255,255,240,3,255,255,255,64,63,255,255,240,3,255,255,255,64,0,0,7,240,3,244,0,0,0,0,0,11,240,3,248,0,0,0,31,255,255,240,3,255,255,254,0,31,255,255,240,3,255,255,254,0,0,0,11,224,3,244,0,0,0,0,0,11,224,3,249,85,85,64,191,255,255,208,3,255,255,255,208,255,255,255,192,3,255,255,255,208,165,64,127,128,3,244,0,0,0,0,6,255,0,3,244,0,0,0,1,191,248,0,3,244,0,0,0,3,255,208,0,3,244,0,0,0,0,249,0,0,3,244,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9762  面
  98,151,33,32,32,37,2,253,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,15,240,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,47,192,0,0,0,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,208,31,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,255,255,252,1,252,0,15,192,15,255,255,252,1,252,0,15,192,15,234,171,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,234,171,252,1,252,0,15,192,15,255,255,252,1,252,0,15,192,15,255,255,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,192,15,192,1,252,1,252,0,15,208,31,192,1,252,1,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,192,0,0,0,0,1,252,0,15,192,0,0,0,0,1,252,0,
  // 0x9875  页
  117,152,33,34,50,37,2,252,63,255,255,255,255,255,255,255,128,63,255,255,255,255,255,255,255,128,63,255,255,255,255,255,255,255,128,0,0,0,31,240,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,127,64,0,0,0,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,254,0,0,0,0,31,208,0,0,254,0,0,0,0,31,208,0,0,254,0,3,244,0,31,208,0,0,254,0,3,244,0,31,208,0,0,254,0,3,244,0,31,208,0,0,254,0,3,244,0,31,208,0,0,254,0,3,244,0,31,208,0,0,254,0,3,244,0,31,208,0,0,254,0,3,244,0,31,208,0,0,254,0,3,244,0,31,208,0,0,254,0,7,240,0,31,208,0,0,254,0,11,240,0,31,208,0,0,254,0,15,240,0,31,208,0,0,254,0,63,210,224,31,208,0,0,0,0,255,203,254,0,0,0,0,0,7,255,7,255,224,0,0,0,0,127,252,0,127,254,0,0,0,11,255,224,0,7,255,224,0,6,255,255,64,0,0,127,253,0,191,255,244,0,0,0,11,255,64,63,253,0,0,0,0,0,190,0,30,64,0,0,0,0,0,28,0,0,0,0,0,0,0,0,0,0,
  // 0x9879  项
  121,152,35,33,41,37,1,253,0,0,0,63,255,255,255,255,244,0,0,0,63,255,255,255,255,244,21,85,85,127,255,255,255,255,244,127,255,255,128,0,63,192,0,0,127,255,255,128,0,127,64,0,0,21,127,149,0,0,255,0,0,0,0,63,128,11,255,255,255,255,0,0,63,128,11,255,255,255,255,0,0,63,128,11,255,255,255,255,0,0,63,128,11,224,0,0,127,0,0,63,128,11,224,0,0,127,0,0,63,128,11,224,31,192,127,0,0,63,128,11,224,31,192,127,0,0,63,128,11,224,31,192,127,0,0,63,128,11,224,31,192,127,0,0,63,128,11,224,31,192,127,0,0,63,128,11,224,31,192,127,0,0,63,128,11,224,31,192,127,0,0,63,128,11,224,31,192,127,0,0,63,155,203,224,47,192,127,0,0,63,255,203,224,47,192,127,0,6,255,255,203,224,47,192,127,0,191,255,249,11,224,63,128,127,0,191,254,64,11,224,127,64,42,0,127,208,0,0,0,255,4,0,0,56,0,0,0,2,253,47,64,0,0,0,0,0,11,248,127,224,0,0,0,0,0,127,240,31,252,0,0,0,0,7,255,192,3,255,64,0,0,0,191,254,0,0,191,224,0,0,3,255,244,0,0,31,244,0,0,1,255,64,0,0,3,224,0,0,0,96,0,0,0,0,128,
  // 0x9884  预
  132,152,35,34,50,37,1,252,63,255,255,248,255,255,255,255,244,63,255,255,252,255,255,255,255,244,63,255,255,244,255,255,255,255,244,0,0,15,224,0,2,252,0,0,0,0,47,192,0,3,248,0,0,1,128,191,0,0,3,244,0,0,7,246,253,0,47,255,255,255,192,7,255,244,0,47,255,255,255,192,0,255,224,0,47,255,255,255,192,0,47,248,0,47,128,0,31,192,0,7,255,0,47,64,0,31,192,0,0,255,0,47,65,164,31,192,191,255,255,255,47,66,248,31,192,191,255,255,255,47,66,248,31,192,191,255,255,255,47,66,248,31,192,0,15,224,189,47,66,248,31,192,0,15,208,252,47,66,248,31,192,0,15,208,252,47,66,248,31,192,0,15,209,244,47,66,248,31,192,0,15,211,240,47,66,248,31,192,0,15,209,160,47,66,248,31,192,0,15,208,0,47,67,244,31,192,0,15,208,0,47,67,244,31,192,0,15,208,0,47,71,240,31,192,0,15,208,0,0,15,224,0,0,0,15,208,0,0,47,210,128,0,0,15,208,0,0,127,203,240,0,0,15,208,0,1,255,11,252,0,0,15,208,0,11,253,2,255,64,0,31,208,0,191,240,0,127,208,15,255,208,11,255,128,0,31,244,15,255,192,3,253,0,0,7,240,11,254,0,0,144,0,0,1,128,0,0,0,0,0,0,0,0,0,
  // 0x9891  频
  145,152,35,36,68,37,1,252,0,0,126,0,0,0,0,0,0,0,0,126,0,0,0,0,0,0,0,0,126,0,15,255,255,255,240,3,224,126,0,15,255,255,255,240,3,240,127,255,143,255,255,255,240,3,240,127,255,128,0,127,0,0,3,240,127,255,128,0,190,0,0,3,240,126,0,0,0,252,0,0,3,240,126,0,0,1,252,0,0,3,240,126,0,3,255,255,255,192,3,240,126,0,3,255,255,255,192,3,240,126,0,3,250,170,175,192,191,255,255,255,227,240,0,15,192,191,255,255,255,227,240,20,15,192,191,255,255,255,227,240,125,15,192,0,0,252,0,3,240,125,15,192,0,0,252,0,3,240,125,15,192,1,224,252,6,3,240,125,15,192,3,240,252,15,211,240,125,15,192,3,240,252,15,195,240,189,15,192,11,208,252,47,195,240,189,15,192,15,192,252,63,67,240,188,15,192,47,128,252,127,3,240,188,15,192,63,0,252,254,3,240,252,15,192,62,0,254,252,3,240,252,15,192,4,0,255,248,3,241,248,15,192,0,0,15,240,2,162,244,6,128,0,0,63,208,0,3,243,64,0,0,0,255,128,0,11,255,224,0,0,7,254,0,0,31,199,252,0,0,47,248,0,0,191,129,255,64,6,255,208,0,7,254,0,63,208,63,254,0,0,191,248,0,15,244,31,244,0,0,191,208,0,3,240,14,0,0,0,57,0,0,0,128,0,0,0,0,0,0,0,0,0,
  // 0x989d  额
  157,152,35,36,68,37,1,252,0,0,96,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,2,252,0,15,255,255,255,240,0,0,253,0,15,255,255,255,240,63,255,255,255,223,255,255,255,240,63,255,255,255,208,0,189,0,0,63,255,255,255,208,0,252,0,0,63,1,0,11,208,1,248,0,0,63,15,208,11,208,2,244,0,0,47,31,192,11,215,255,255,255,192,0,63,255,253,7,255,255,255,192,0,255,255,255,7,250,170,175,192,3,254,170,254,7,208,0,15,192,15,240,2,252,7,208,104,15,192,127,196,11,244,7,208,189,15,192,63,47,175,224,7,208,188,15,192,8,127,255,192,7,208,188,15,192,0,11,255,128,7,208,252,15,192,0,47,255,248,7,208,252,15,192,2,255,239,255,71,208,252,15,192,47,255,65,255,231,208,252,15,192,63,248,0,47,199,208,252,15,192,47,128,0,6,7,208,252,15,192,26,255,255,253,7,209,248,15,192,1,255,255,253,7,210,248,15,192,1,254,170,253,7,211,244,15,192,1,248,0,189,6,131,240,5,64,1,248,0,189,0,11,226,192,0,1,248,0,189,0,15,215,244,0,1,248,0,189,0,63,199,253,0,1,248,0,189,0,255,0,255,128,1,255,255,253,7,253,0,63,224,1,255,255,254,127,244,0,15,248,1,254,170,254,255,192,0,2,244,1,168,0,189,61,0,0,0,160,0,0,0,0,0,0,0,0,0,
  // 0x98ce  风
  206,152,35,35,59,37,1,252,0,21,85,85,85,85,85,80,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,64,0,0,0,11,240,0,0,63,64,0,0,0,11,240,0,0,63,64,0,0,16,11,240,0,0,63,64,0,0,63,11,240,0,0,63,66,128,0,190,11,240,0,0,63,95,224,0,253,11,240,0,0,63,75,244,1,252,11,240,0,0,63,67,252,3,248,11,240,0,0,63,64,255,3,244,11,240,0,0,63,64,127,139,240,7,240,0,0,127,64,47,239,208,7,240,0,0,127,0,15,255,192,7,240,0,0,127,0,3,255,64,7,240,0,0,127,0,1,255,0,7,240,0,0,191,0,1,255,64,7,240,0,0,191,0,3,255,192,7,240,0,0,191,0,15,255,224,7,240,0,0,254,0,47,235,244,7,240,0,0,254,0,127,195,252,3,240,0,1,253,0,255,1,254,3,240,0,2,252,3,253,0,255,67,240,0,3,252,15,248,0,63,195,244,96,3,248,127,240,0,47,227,244,116,7,244,191,192,0,15,210,248,124,15,240,47,0,0,10,1,252,188,15,224,8,0,0,0,0,253,184,63,208,0,0,0,0,0,255,244,127,192,0,0,0,0,0,127,240,47,64,0,0,0,0,0,47,224,6,0,0,0,0,0,0,6,64,0,0,0,0,0,0,0,0,0,
  // 0x9971  饱
  113,153,35,35,59,37,1,253,0,100,0,0,10,64,0,0,0,0,253,0,0,15,192,0,0,0,0,253,0,0,31,192,0,0,0,0,252,0,0,63,64,0,0,0,1,252,0,0,127,255,255,255,128,2,248,0,0,191,255,255,255,128,3,255,255,224,255,255,255,255,128,3,255,255,227,248,0,0,47,128,7,255,255,215,240,0,0,47,128,11,224,15,207,224,0,0,47,64,15,208,31,191,192,0,0,47,64,31,192,63,191,255,255,244,47,64,63,128,127,63,255,255,244,47,64,127,21,109,45,255,255,244,47,64,190,63,64,5,252,2,244,63,64,44,63,64,1,252,2,244,63,64,4,63,64,1,252,2,244,63,64,0,63,64,1,252,2,244,63,64,0,63,64,1,252,2,244,63,64,0,63,64,1,252,2,244,63,64,0,63,64,1,255,255,244,63,64,0,63,64,1,255,255,244,63,0,0,63,64,1,255,255,244,127,0,0,63,64,1,252,0,191,255,0,0,63,64,1,252,0,63,253,0,0,63,66,65,252,0,63,228,0,0,63,79,129,252,0,0,0,0,0,63,191,193,252,0,0,2,144,0,63,255,65,252,0,0,2,244,0,63,252,1,252,0,0,3,244,0,63,240,0,253,0,0,7,240,0,255,128,0,255,255,255,255,224,0,254,0,0,127,255,255,255,192,0,116,0,0,27,255,255,254,0,0,16,0,0,0,0,0,0,0,
  // 0x9a6c  马
  108,154,32,34,16,37,2,252,3,255,255,255,255,255,252,0,3,255,255,255,255,255,252,0,3,255,255,255,255,255,252,0,1,85,85,85,85,87,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,3,248,0,0,15,224,0,0,3,248,0,0,15,224,0,0,3,244,0,0,15,208,0,0,3,244,0,0,15,208,0,0,3,244,0,0,15,208,0,0,7,240,0,0,15,192,0,0,7,240,0,0,31,192,0,0,7,240,0,0,31,192,0,0,11,240,0,0,47,192,0,0,15,240,0,0,47,255,255,255,255,255,255,0,63,255,255,255,255,255,255,0,63,255,255,255,255,255,255,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,253,255,255,255,255,255,255,64,253,255,255,255,255,255,255,65,252,255,255,255,255,255,255,65,252,21,85,85,85,85,85,2,252,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,11,244,0,0,0,0,1,0,31,240,0,0,0,0,3,255,255,224,0,0,0,0,1,255,255,192,0,0,0,0,1,255,254,0,0,0,0,0,0,0,0,0,
  // 0x9a71  驱
  113,154,35,33,41,37,1,253,47,255,255,192,255,255,255,255,240,47,255,255,192,255,255,255,255,240,47,255,255,128,255,255,255,255,240,0,0,31,128,252,0,0,0,0,0,0,31,128,252,0,0,0,0,7,144,31,64,252,0,0,41,0,7,224,47,64,252,24,0,63,64,7,208,47,64,252,189,0,127,0,11,208,47,64,252,191,0,190,0,11,208,47,0,252,63,128,253,0,11,208,63,0,252,31,209,252,0,11,192,63,0,252,11,243,248,0,15,192,63,0,252,3,255,244,0,15,192,63,0,252,1,255,240,0,15,192,62,0,252,0,191,208,0,15,192,127,160,252,0,63,192,0,15,255,255,240,252,0,63,208,0,31,255,255,240,252,0,191,240,0,26,170,171,240,252,0,255,248,0,0,0,3,240,252,3,254,252,0,0,0,3,240,252,7,244,255,0,0,0,3,240,252,15,224,127,64,0,27,227,240,252,63,192,63,192,27,255,227,224,252,191,64,15,208,255,255,151,224,253,254,0,11,192,191,144,7,224,252,124,0,2,0,16,0,11,208,252,0,0,0,0,0,0,15,208,252,0,0,0,0,0,0,15,192,255,255,255,255,244,0,0,47,192,255,255,255,255,244,0,127,255,128,255,255,255,255,244,0,63,255,0,0,0,0,0,0,0,42,164,0,0,0,0,0,0,
  // 0x9ad8  高
  216,154,33,35,59,37,2,253,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,85,85,85,85,80,0,0,0,7,255,255,255,255,244,0,0,0,7,255,255,255,255,244,0,0,0,7,240,0,0,3,244,0,0,0,7,240,0,0,3,244,0,0,0,7,240,0,0,3,244,0,0,0,7,255,255,255,255,244,0,0,0,7,255,255,255,255,244,0,0,0,1,85,85,85,85,80,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,15,208,0,0,0,0,0,252,0,15,208,0,0,0,0,0,252,0,15,208,5,85,85,84,0,252,0,15,208,31,255,255,253,0,252,0,15,208,31,255,255,253,0,252,0,15,208,31,64,0,189,0,252,0,15,208,31,64,0,189,0,252,0,15,208,31,64,0,189,0,252,0,15,208,31,255,255,253,0,252,0,15,208,31,255,255,253,0,252,0,15,208,31,149,85,90,2,252,0,15,208,31,64,0,7,255,252,0,15,208,5,0,0,3,255,248,0,15,208,0,0,0,2,255,144,0,
  // 0x9ec4  黄
  196,158,33,36,68,37,2,252,0,0,63,128,0,127,0,0,0,0,0,63,128,0,127,0,0,0,0,0,63,128,0,127,0,0,0,3,255,255,255,255,255,255,248,0,3,255,255,255,255,255,255,248,0,3,255,255,255,255,255,255,248,0,0,0,63,128,0,127,0,0,0,0,0,63,128,0,127,0,0,0,0,0,63,128,0,127,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,254,85,91,249,85,111,208,0,0,253,0,7,244,0,15,208,0,0,253,0,7,244,0,15,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,254,85,91,249,85,95,208,0,0,253,0,7,244,0,15,208,0,0,253,0,7,244,0,15,208,0,0,254,85,91,249,85,111,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,0,9,0,0,36,0,0,0,0,0,127,128,0,191,144,0,0,0,11,255,208,0,255,254,0,0,1,255,254,0,0,11,255,244,0,127,255,224,0,0,0,127,255,64,63,253,0,0,0,0,2,254,0,15,64,0,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,
  // 0x9ede  點
  222,158,35,35,59,37,1,253,0,0,0,0,0,1,252,0,0,5,85,85,85,64,1,252,0,0,15,255,255,255,128,1,252,0,0,15,255,255,255,128,1,252,0,0,15,64,244,15,128,1,252,0,0,15,148,244,143,128,1,252,0,0,15,184,244,255,128,1,252,0,0,15,124,245,223,128,1,252,0,0,15,108,246,207,128,1,255,255,248,15,93,247,143,128,1,255,255,248,15,93,251,79,128,1,255,255,248,15,64,245,15,128,1,252,0,0,15,149,249,95,128,1,252,0,0,15,255,255,255,128,1,252,0,0,15,255,255,255,128,1,252,0,0,0,1,248,0,0,1,252,0,0,0,1,248,0,0,1,252,0,0,10,171,254,170,128,1,252,0,0,31,255,255,255,199,255,255,255,192,31,255,255,255,199,255,255,255,192,0,1,248,0,7,255,255,255,192,0,1,248,0,7,224,0,15,192,0,1,254,191,215,224,0,15,192,63,255,255,255,215,224,0,15,192,63,255,255,255,215,224,0,15,192,63,165,80,0,7,224,0,15,192,0,0,5,62,7,224,0,15,192,6,79,31,31,7,224,0,15,192,11,207,79,15,199,224,0,15,192,15,143,139,135,215,224,0,15,192,15,75,135,195,231,255,255,255,192,31,75,195,193,235,255,255,255,192,63,7,195,128,7,255,255,255,192,189,1,64,0,7,224,0,31,192,24,0,0,0,7,224,0,10,128,
  // 0x9f50  齐
  80,159,34,36,68,37,2,252,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,191,255,255,255,255,255,255,255,128,0,3,248,0,0,15,244,0,0,0,1,254,0,0,47,224,0,0,0,0,127,128,0,191,192,0,0,0,0,47,240,2,255,0,0,0,0,0,11,253,15,252,0,0,0,0,0,1,255,255,240,0,0,0,0,0,0,63,255,128,0,0,0,0,0,0,191,255,224,0,0,0,0,0,47,255,255,255,144,0,0,0,107,255,254,27,255,255,164,0,191,255,255,208,0,191,255,255,208,255,255,244,0,0,2,255,255,192,63,251,232,0,0,6,182,191,0,20,2,252,0,0,7,240,0,0,0,2,252,0,0,7,240,0,0,0,2,252,0,0,7,240,0,0,0,2,252,0,0,7,240,0,0,0,2,252,0,0,7,240,0,0,0,3,252,0,0,7,240,0,0,0,3,248,0,0,7,240,0,0,0,7,244,0,0,7,240,0,0,0,15,240,0,0,7,240,0,0,0,47,240,0,0,7,240,0,0,0,127,208,0,0,7,240,0,0,2,255,128,0,0,7,240,0,0,31,255,0,0,0,7,240,0,0,11,248,0,0,0,7,240,0,0,2,208,0,0,0,7,240,0,0,0,0,0,0,0,0,0,0,0,
  // 0xff1a  ：
  26,255,7,24,48,37,15,2,31,208,63,240,191,248,127,244,63,240,31,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,208,63,240,191,248,191,244,63,240,31,208,
};

#endif // HAS_GRAPHICAL_TFT
