/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Katakana 37pt, capital 'A' height: 27px, width: 100%, range: 0x30a0-0x8868, glyphs: 103
extern const uint8_t NotoSans_Medium_Katakana_27[13151] = {
  162,27,160,48,104,136,35,247, // unifont_t
  // 0x30a0  ゠
  160,48,17,8,40,37,10,10,191,255,255,255,128,21,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,128,21,85,85,85,0,
  // 0x30a1  ァ
  161,48,26,25,175,37,6,252,191,255,255,255,255,255,192,191,255,255,255,255,255,240,191,255,255,255,255,255,240,101,85,85,85,85,191,192,0,0,0,0,0,191,64,0,0,5,80,1,255,0,0,0,15,240,7,252,0,0,0,15,240,31,244,0,0,0,15,224,127,208,0,0,0,15,225,255,128,0,0,0,15,224,254,0,0,0,0,15,224,40,0,0,0,0,31,208,0,0,0,0,0,47,192,0,0,0,0,0,63,192,0,0,0,0,0,63,128,0,0,0,0,0,255,64,0,0,0,0,1,255,0,0,0,0,0,7,253,0,0,0,0,0,31,248,0,0,0,0,0,191,240,0,0,0,0,11,255,192,0,0,0,0,3,254,0,0,0,0,0,0,180,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30a2  ア
  162,48,31,30,240,37,4,254,186,170,170,170,170,170,170,128,191,255,255,255,255,255,255,240,191,255,255,255,255,255,255,248,191,255,255,255,255,255,255,240,0,0,0,0,0,0,127,208,0,0,0,0,0,0,255,128,0,0,0,0,0,2,255,0,0,0,0,170,0,7,252,0,0,0,0,255,0,31,244,0,0,0,0,255,0,127,224,0,0,0,0,255,2,255,128,0,0,0,0,255,15,255,0,0,0,0,0,254,11,248,0,0,0,0,0,254,2,224,0,0,0,0,1,254,0,0,0,0,0,0,1,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,11,248,0,0,0,0,0,0,15,244,0,0,0,0,0,0,47,240,0,0,0,0,0,0,127,208,0,0,0,0,0,1,255,128,0,0,0,0,0,11,255,0,0,0,0,0,0,127,252,0,0,0,0,0,6,255,240,0,0,0,0,0,3,255,192,0,0,0,0,0,0,189,0,0,0,0,0,0,0,16,0,0,0,0,0,0,
  // 0x30a3  ィ
  163,48,25,26,182,37,4,253,0,0,0,0,0,13,0,0,0,0,0,0,63,64,0,0,0,0,0,255,192,0,0,0,0,3,255,128,0,0,0,0,31,254,0,0,0,0,0,191,244,0,0,0,0,3,255,192,0,0,0,0,31,254,0,0,0,0,1,255,244,0,0,0,0,31,255,208,0,0,0,1,255,255,192,0,0,0,111,255,255,192,0,0,27,255,254,63,192,0,0,127,255,224,63,192,0,0,63,253,0,63,192,0,0,31,128,0,63,192,0,0,4,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,
  // 0x30a4  イ
  164,48,29,31,248,37,3,255,0,0,0,0,0,0,4,0,0,0,0,0,0,0,62,0,0,0,0,0,0,0,255,128,0,0,0,0,0,3,255,192,0,0,0,0,0,15,255,0,0,0,0,0,0,127,248,0,0,0,0,0,1,255,224,0,0,0,0,0,11,255,128,0,0,0,0,0,127,253,0,0,0,0,0,2,255,224,0,0,0,0,0,47,255,64,0,0,0,0,2,255,253,0,0,0,0,0,47,255,253,0,0,0,0,7,255,255,253,0,0,0,1,191,255,226,253,0,0,0,111,255,254,2,253,0,0,0,255,255,224,2,253,0,0,0,127,249,0,2,253,0,0,0,63,64,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,3,253,0,0,0,0,0,0,3,253,0,0,0,0,0,0,3,253,0,0,0,0,0,0,3,254,0,0,0,
  // 0x30a5  ゥ
  165,48,25,28,196,37,6,252,0,0,11,244,0,0,0,0,0,11,240,0,0,0,0,0,11,240,0,0,0,0,0,7,240,0,0,0,0,0,7,240,0,0,0,127,255,255,255,255,254,0,127,255,255,255,255,255,192,63,255,255,255,255,255,192,63,149,85,85,85,191,128,63,64,0,0,0,191,64,63,64,0,0,0,255,0,63,64,0,0,0,255,0,63,64,0,0,1,254,0,127,64,0,0,2,253,0,127,64,0,0,3,252,0,21,0,0,0,11,248,0,0,0,0,0,15,244,0,0,0,0,0,63,240,0,0,0,0,0,191,192,0,0,0,0,2,255,64,0,0,0,0,15,255,0,0,0,0,0,191,248,0,0,0,0,27,255,224,0,0,0,6,255,255,64,0,0,0,7,255,248,0,0,0,0,2,255,144,0,0,0,0,0,180,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30a6  ウ
  166,48,29,33,8,37,4,254,0,0,0,191,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,0,0,0,191,64,0,0,0,41,85,85,255,149,85,104,0,127,255,255,255,255,255,255,128,127,255,255,255,255,255,255,192,63,255,255,255,255,255,255,128,63,64,0,0,0,0,255,64,63,64,0,0,0,0,255,0,63,64,0,0,0,0,255,0,63,64,0,0,0,1,255,0,63,64,0,0,0,2,254,0,63,64,0,0,0,3,253,0,127,128,0,0,0,7,252,0,127,128,0,0,0,11,248,0,127,64,0,0,0,15,244,0,0,0,0,0,0,47,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,255,192,0,0,0,0,0,2,255,0,0,0,0,0,0,11,254,0,0,0,0,0,0,63,252,0,0,0,0,0,1,255,240,0,0,0,0,0,11,255,192,0,0,0,0,0,191,255,0,0,0,0,0,111,255,248,0,0,0,0,2,255,255,192,0,0,0,0,0,191,253,0,0,0,0,0,0,63,144,0,0,0,0,0,0,8,0,0,0,0,0,
  // 0x30a7  ェ
  167,48,27,21,147,37,5,255,11,255,255,255,255,255,192,11,255,255,255,255,255,192,11,255,255,255,255,255,192,5,85,86,254,85,85,64,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,127,255,255,255,255,255,244,127,255,255,255,255,255,244,127,255,255,255,255,255,244,106,170,170,170,170,170,164,
  // 0x30a8  エ
  168,48,31,25,200,37,3,1,11,170,170,170,170,170,171,192,11,255,255,255,255,255,255,192,11,255,255,255,255,255,255,192,11,255,255,255,255,255,255,192,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,
  // 0x30a9  ォ
  169,48,26,27,189,37,6,253,0,0,0,2,160,0,0,0,0,0,7,244,0,0,0,0,0,3,244,0,0,0,0,0,3,244,0,0,0,0,0,3,244,0,0,0,0,0,3,244,0,0,47,255,255,255,255,255,240,47,255,255,255,255,255,240,47,255,255,255,255,255,240,21,85,85,127,249,85,80,0,0,0,191,244,0,0,0,0,1,255,244,0,0,0,0,7,255,244,0,0,0,0,31,247,244,0,0,0,0,127,211,248,0,0,0,2,255,131,248,0,0,0,15,254,3,248,0,0,0,127,244,3,248,0,0,2,255,208,3,248,0,0,47,255,0,3,248,0,0,191,248,0,3,248,0,0,63,208,0,3,248,0,0,14,0,4,3,248,0,0,0,0,15,255,248,0,0,0,0,15,255,244,0,0,0,0,15,255,224,0,0,0,0,0,0,0,0,0,
  // 0x30aa  オ
  170,48,31,31,248,37,3,255,0,0,0,0,31,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,26,170,170,170,175,250,170,164,47,255,255,255,255,255,255,244,47,255,255,255,255,255,255,244,47,255,255,255,255,255,255,244,0,0,0,0,255,224,0,0,0,0,0,2,255,224,0,0,0,0,0,7,255,240,0,0,0,0,0,31,255,240,0,0,0,0,0,127,223,240,0,0,0,0,1,255,143,240,0,0,0,0,7,254,15,240,0,0,0,0,31,252,15,240,0,0,0,0,191,224,15,240,0,0,0,3,255,128,15,240,0,0,0,31,254,0,15,240,0,0,0,191,248,0,15,240,0,0,11,255,208,0,11,240,0,0,127,255,0,0,11,240,0,0,255,248,0,0,11,240,0,0,63,208,0,0,11,240,0,0,14,0,0,0,15,240,0,0,0,0,0,250,191,240,0,0,0,0,0,255,255,240,0,0,0,0,0,255,255,208,0,0,0,0,0,191,255,64,0,0,
  // 0x30ab  カ
  171,48,28,32,224,37,4,254,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,127,255,255,255,255,255,248,127,255,255,255,255,255,255,127,255,255,255,255,255,254,106,149,91,249,85,86,254,0,0,11,240,0,0,254,0,0,15,240,0,0,254,0,0,15,240,0,0,254,0,0,15,224,0,0,253,0,0,31,208,0,1,253,0,0,63,192,0,1,253,0,0,63,192,0,1,252,0,0,191,128,0,2,252,0,0,255,0,0,2,252,0,2,255,0,0,3,252,0,3,253,0,0,3,252,0,11,252,0,0,3,248,0,47,244,0,0,3,248,0,127,224,0,0,7,244,1,255,192,0,0,15,240,11,255,0,1,0,47,240,47,253,0,3,255,255,224,255,244,0,3,255,255,208,63,208,0,3,255,255,128,15,0,0,1,170,168,0,0,0,0,0,0,0,0,
  // 0x30ac  ガ
  172,48,32,34,16,37,3,254,0,0,0,0,0,0,0,80,0,0,0,0,0,0,3,240,0,0,2,253,0,1,225,248,0,0,3,253,0,3,240,189,0,0,2,253,0,1,252,63,0,0,2,252,0,0,189,47,0,0,2,252,0,0,63,0,0,0,2,252,0,0,40,0,0,0,3,252,0,0,0,0,63,255,255,255,255,255,253,0,63,255,255,255,255,255,255,0,63,255,255,255,255,255,255,0,42,149,91,253,85,85,255,0,0,0,7,248,0,0,255,0,0,0,7,244,0,0,255,0,0,0,11,240,0,0,255,0,0,0,15,240,0,0,254,0,0,0,15,224,0,0,254,0,0,0,31,208,0,0,254,0,0,0,63,192,0,0,253,0,0,0,63,192,0,0,253,0,0,0,191,128,0,1,253,0,0,0,255,0,0,1,252,0,0,2,254,0,0,2,252,0,0,7,252,0,0,2,252,0,0,15,248,0,0,3,252,0,0,63,240,0,0,3,248,0,0,255,208,0,0,7,248,0,3,255,128,0,0,15,244,0,31,255,0,3,254,191,240,0,191,248,0,3,255,255,224,0,127,224,0,3,255,255,192,0,15,128,0,2,255,254,0,0,1,0,0,0,0,0,0,0,
  // 0x30ad  キ
  173,48,30,32,0,37,4,254,0,0,10,208,0,0,0,0,0,0,31,224,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,11,240,0,0,80,0,0,0,11,244,1,175,240,0,0,0,7,254,255,255,240,0,0,5,191,255,255,255,240,0,175,255,255,255,255,254,80,0,255,255,255,255,165,0,0,0,255,255,251,253,0,0,0,0,191,164,1,254,0,0,0,0,16,0,0,254,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,191,0,0,1,64,0,0,0,191,64,5,191,192,0,0,0,127,155,255,255,192,0,0,5,191,255,255,255,208,0,107,255,255,255,255,250,64,255,255,255,255,255,164,0,0,255,255,255,255,208,0,0,0,255,255,148,31,208,0,0,0,186,64,0,15,224,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,11,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,248,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,253,0,0,0,0,0,0,1,64,0,0,0,
  // 0x30ae  ギ
  174,48,32,34,16,37,3,254,0,0,0,0,0,0,2,224,0,0,0,0,0,0,130,244,0,0,0,80,0,3,240,252,0,0,15,240,0,2,244,126,0,0,15,240,0,0,252,63,0,0,11,244,0,0,126,20,0,0,7,244,0,0,61,0,0,0,3,248,0,6,240,0,0,0,3,252,107,255,240,0,0,0,23,255,255,255,244,0,21,175,255,255,255,255,244,0,191,255,255,255,255,148,0,0,191,255,255,255,64,0,0,0,127,254,144,255,0,0,0,0,57,0,0,255,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,127,128,0,26,192,0,0,0,63,193,111,255,208,0,0,0,63,255,255,255,224,0,1,111,255,255,255,255,224,107,255,255,255,255,254,144,0,191,255,255,255,249,0,0,0,191,255,254,159,240,0,0,0,127,233,0,15,240,0,0,0,20,0,0,11,240,0,0,0,0,0,0,11,244,0,0,0,0,0,0,7,248,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,2,254,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,229,0,0,0,
  // 0x30af  ク
  175,48,30,33,8,37,3,254,0,0,0,57,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,255,192,0,0,0,0,0,1,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,7,253,85,85,88,0,0,0,15,255,255,255,255,128,0,0,63,255,255,255,255,224,0,0,191,255,255,255,255,192,0,1,255,64,0,0,255,128,0,7,254,0,0,0,255,64,0,31,252,0,0,1,255,0,0,127,240,0,0,3,254,0,2,255,192,0,0,3,252,0,11,255,0,0,0,11,252,0,127,252,0,0,0,15,244,0,63,240,0,0,0,47,240,0,11,128,0,0,0,127,208,0,0,0,0,0,0,255,192,0,0,0,0,0,2,255,0,0,0,0,0,0,7,253,0,0,0,0,0,0,31,252,0,0,0,0,0,0,127,240,0,0,0,0,0,1,255,192,0,0,0,0,0,11,255,64,0,0,0,0,0,63,253,0,0,0,0,0,2,255,244,0,0,0,0,0,31,255,192,0,0,0,0,2,255,254,0,0,0,0,0,127,255,244,0,0,0,0,0,127,255,128,0,0,0,0,0,31,248,0,0,0,0,0,0,3,64,0,0,0,0,0,
  // 0x30b0  グ
  176,48,34,35,59,37,2,253,0,0,0,0,0,0,0,125,0,0,0,0,0,0,0,20,63,0,0,0,0,120,0,0,189,47,128,0,0,0,191,192,0,63,15,192,0,0,0,255,64,0,47,71,224,0,0,2,255,0,0,15,194,64,0,0,3,253,0,0,7,192,0,0,0,15,253,85,85,105,0,0,0,0,31,255,255,255,255,64,0,0,0,63,255,255,255,255,192,0,0,0,255,255,255,255,255,192,0,0,2,255,0,0,0,255,64,0,0,11,253,0,0,1,255,0,0,0,47,248,0,0,2,254,0,0,0,191,224,0,0,3,253,0,0,3,255,128,0,0,11,252,0,0,31,254,0,0,0,15,244,0,0,191,248,0,0,0,31,240,0,0,127,208,0,0,0,63,224,0,0,15,0,0,0,0,191,192,0,0,0,0,0,0,1,255,64,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,0,191,224,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,127,252,0,0,0,0,0,0,7,255,224,0,0,0,0,0,0,47,255,128,0,0,0,0,0,7,255,253,0,0,0,0,0,0,191,255,224,0,0,0,0,0,0,191,255,64,0,0,0,0,0,0,47,244,0,0,0,0,0,0,0,6,0,0,0,0,0,0,0,
  // 0x30b1  ケ
  177,48,32,33,8,37,2,254,0,0,20,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,63,208,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,3,255,170,170,170,170,171,0,7,255,255,255,255,255,255,0,15,255,255,255,255,255,255,0,31,255,255,255,255,255,255,0,63,224,0,7,248,0,0,0,255,192,0,11,244,0,0,2,255,64,0,11,244,0,0,7,254,0,0,15,240,0,0,31,252,0,0,15,240,0,0,127,240,0,0,31,240,0,0,63,208,0,0,47,224,0,0,7,64,0,0,63,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,64,0,0,0,0,0,2,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,15,252,0,0,0,0,0,0,63,244,0,0,0,0,0,0,255,240,0,0,0,0,0,3,255,192,0,0,0,0,0,15,255,0,0,0,0,0,0,191,252,0,0,0,0,0,0,191,240,0,0,0,0,0,0,31,128,0,0,0,0,0,0,1,0,0,0,0,0,
  // 0x30b2  ゲ
  178,48,33,35,59,37,2,253,0,0,0,0,0,0,0,40,0,0,0,0,0,0,0,0,189,0,0,0,36,0,0,0,188,63,0,0,0,127,192,0,0,189,31,128,0,0,191,192,0,0,63,15,192,0,0,191,128,0,0,31,131,128,0,0,255,0,0,0,15,192,0,0,1,255,0,0,0,6,0,0,0,3,253,0,0,0,0,0,0,0,7,254,170,170,170,170,173,0,0,15,255,255,255,255,255,254,0,0,31,255,255,255,255,255,254,0,0,63,255,255,255,255,255,254,0,0,191,192,0,15,240,0,0,0,1,255,64,0,15,240,0,0,0,3,255,0,0,15,240,0,0,0,15,252,0,0,31,224,0,0,0,63,244,0,0,47,224,0,0,0,255,224,0,0,47,208,0,0,0,127,192,0,0,63,192,0,0,0,11,0,0,0,127,192,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,47,244,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,7,255,64,0,0,0,0,0,0,47,254,0,0,0,0,0,0,1,255,248,0,0,0,0,0,0,0,255,208,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30b3  コ
  179,48,27,27,189,37,5,255,63,255,255,255,255,255,248,63,255,255,255,255,255,248,63,255,255,255,255,255,248,63,250,170,170,170,175,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,0,0,0,0,0,7,248,127,255,255,255,255,255,248,127,255,255,255,255,255,248,127,255,255,255,255,255,248,127,255,255,255,255,255,248,0,0,0,0,0,7,248,0,0,0,0,0,7,252,0,0,0,0,0,0,0,
  // 0x30b4  ゴ
  180,48,30,35,24,37,5,254,0,0,0,0,0,0,5,0,0,0,0,0,0,4,63,0,0,0,0,0,0,188,47,128,0,0,0,0,0,126,15,192,0,0,0,0,0,63,7,224,0,0,0,0,0,31,131,224,0,0,0,0,0,15,192,0,0,0,0,0,0,5,0,0,191,255,255,255,255,255,240,0,191,255,255,255,255,255,240,0,191,255,255,255,255,255,240,0,191,234,170,170,170,191,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,255,255,255,255,255,255,240,0,255,255,255,255,255,255,240,0,255,255,255,255,255,255,240,0,255,255,255,255,255,255,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,
  // 0x30b5  サ
  181,48,32,33,8,37,2,253,0,0,169,0,0,47,192,0,0,1,254,0,0,63,192,0,0,1,254,0,0,47,192,0,0,0,254,0,0,47,192,0,0,0,254,0,0,47,192,0,0,0,254,0,0,47,192,0,0,0,254,0,0,47,192,0,0,0,254,0,0,47,192,0,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,106,170,255,170,170,191,234,170,0,0,254,0,0,47,192,0,0,0,254,0,0,47,192,0,0,0,254,0,0,63,192,0,0,0,254,0,0,63,192,0,0,0,254,0,0,63,192,0,0,0,254,0,0,63,192,0,0,0,254,0,0,63,128,0,0,1,254,0,0,127,128,0,0,1,254,0,0,191,64,0,0,0,0,0,0,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,3,253,0,0,0,0,0,0,15,252,0,0,0,0,0,0,47,244,0,0,0,0,0,0,255,224,0,0,0,0,0,11,255,192,0,0,0,0,0,191,255,0,0,0,0,0,1,255,248,0,0,0,0,0,0,127,208,0,0,0,0,0,0,29,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30b6  ザ
  182,48,35,33,41,37,1,253,0,0,0,0,0,0,0,7,192,0,0,170,0,0,47,226,195,208,0,0,255,0,0,31,227,210,240,0,0,255,0,0,31,209,241,240,0,0,255,0,0,31,208,244,244,0,0,255,0,0,31,208,184,80,0,0,255,0,0,31,208,80,0,0,0,255,0,0,31,208,0,0,122,170,255,170,170,175,250,170,64,127,255,255,255,255,255,255,255,128,127,255,255,255,255,255,255,255,128,127,255,255,255,255,255,255,255,128,0,0,255,0,0,31,208,0,0,0,0,255,0,0,31,208,0,0,0,0,255,0,0,31,208,0,0,0,0,255,0,0,31,208,0,0,0,0,255,0,0,31,208,0,0,0,0,255,0,0,47,208,0,0,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,0,0,255,0,0,63,192,0,0,0,0,85,0,0,127,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,63,244,0,0,0,0,0,0,1,255,224,0,0,0,0,0,0,31,255,128,0,0,0,0,0,0,255,254,0,0,0,0,0,0,0,191,244,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,4,0,0,0,0,0,
  // 0x30b7  シ
  183,48,30,30,240,37,4,255,0,3,64,0,0,0,0,0,0,15,240,0,0,0,0,0,0,47,254,0,0,0,0,0,0,15,255,192,0,0,0,0,0,1,255,248,0,0,0,0,0,0,47,252,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,176,0,0,0,0,20,0,0,0,0,0,1,0,62,0,0,0,0,0,3,128,255,224,0,0,0,0,11,192,255,253,0,0,0,0,31,224,47,255,128,0,0,0,63,240,3,255,224,0,0,0,255,192,0,127,192,0,0,3,255,64,0,11,64,0,0,15,254,0,0,1,0,0,0,63,248,0,0,0,0,0,0,255,224,0,0,0,0,0,7,255,128,0,0,0,0,0,47,254,0,0,0,0,0,0,255,244,0,0,0,0,0,11,255,208,0,0,0,0,0,127,255,0,0,0,0,0,11,255,248,0,0,0,0,1,191,255,192,0,0,0,1,191,255,253,0,0,0,0,47,255,255,224,0,0,0,0,15,255,253,0,0,0,0,0,11,255,128,0,0,0,0,0,3,144,0,0,0,0,0,0,
  // 0x30b8  ジ
  184,48,32,31,248,37,3,255,0,0,0,0,0,0,7,208,0,2,192,0,0,1,7,240,0,7,248,0,0,31,66,248,0,15,255,64,0,15,192,252,0,11,255,224,0,11,224,126,0,0,255,253,0,3,240,62,0,0,31,254,0,1,248,0,0,0,2,252,0,0,244,0,0,0,0,116,0,0,0,0,8,0,0,0,0,0,0,64,47,64,0,0,0,0,2,192,127,240,0,0,0,0,3,224,191,254,0,0,0,0,15,240,15,255,208,0,0,0,47,244,1,255,240,0,0,0,191,224,0,47,224,0,0,1,255,192,0,7,192,0,0,7,255,0,0,0,0,0,0,31,252,0,0,0,0,0,0,191,240,0,0,0,0,0,2,255,208,0,0,0,0,0,15,255,64,0,0,0,0,0,191,252,0,0,0,0,0,3,255,224,0,0,0,0,0,47,255,128,0,0,0,0,6,255,252,0,0,0,0,0,191,255,224,0,0,0,0,111,255,255,0,0,0,0,15,255,255,244,0,0,0,0,11,255,254,0,0,0,0,0,3,255,144,0,0,0,0,0,1,228,0,0,0,0,0,0,
  // 0x30b9  ス
  185,48,30,30,240,37,4,254,0,0,0,0,0,1,0,0,3,255,255,255,255,255,192,0,3,255,255,255,255,255,240,0,3,255,255,255,255,255,224,0,3,250,170,170,170,255,192,0,0,0,0,0,0,255,128,0,0,0,0,0,1,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,7,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,31,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,191,128,0,0,0,0,0,2,255,0,0,0,0,0,0,7,253,0,0,0,0,0,0,31,253,0,0,0,0,0,0,63,255,64,0,0,0,0,0,255,255,208,0,0,0,0,7,255,127,248,0,0,0,0,31,253,15,253,0,0,0,0,191,244,7,255,64,0,0,3,255,208,1,255,208,0,0,31,255,0,0,127,244,0,0,255,252,0,0,31,252,0,11,255,224,0,0,7,255,0,191,255,64,0,0,2,255,192,255,248,0,0,0,0,255,208,127,208,0,0,0,0,63,64,29,0,0,0,0,0,28,0,0,0,0,0,0,0,0,0,
  // 0x30ba  ズ
  186,48,33,36,68,37,3,253,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,1,244,0,0,0,0,0,0,1,224,252,0,0,0,0,0,0,3,240,189,0,0,0,0,0,0,1,248,63,0,0,0,0,0,0,0,189,47,64,0,0,0,0,0,1,127,13,0,3,255,255,255,255,255,254,0,0,3,255,255,255,255,255,240,0,0,3,255,255,255,255,255,240,0,0,3,255,170,170,170,255,208,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,1,255,64,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,63,255,128,0,0,0,0,0,0,255,255,240,0,0,0,0,0,3,255,127,252,0,0,0,0,0,31,253,15,255,0,0,0,0,0,127,244,3,255,192,0,0,0,3,255,208,0,255,224,0,0,0,31,255,0,0,63,248,0,0,0,255,252,0,0,15,254,0,0,11,255,224,0,0,3,255,64,0,255,255,64,0,0,1,255,208,0,191,248,0,0,0,0,127,208,0,47,208,0,0,0,0,47,64,0,9,0,0,0,0,0,13,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30bb  セ
  187,48,31,31,248,37,2,255,0,0,42,128,0,0,0,0,0,0,127,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,6,192,0,0,63,128,0,22,255,244,0,0,63,128,27,255,255,252,0,0,63,239,255,255,255,244,0,5,191,255,255,255,255,240,91,255,255,255,255,144,63,208,255,255,255,254,80,0,191,128,191,255,255,192,0,0,255,0,127,249,63,128,0,3,253,0,100,0,63,128,0,11,252,0,0,0,63,128,0,31,240,0,0,0,63,128,0,63,208,0,0,0,63,128,0,255,128,0,0,0,63,128,0,255,0,0,0,0,63,128,0,28,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,224,0,0,5,144,0,0,63,255,170,255,255,208,0,0,31,255,255,255,255,208,0,0,7,255,255,255,255,208,0,0,0,111,255,255,169,64,
  // 0x30bc  ゼ
  188,48,35,34,50,37,1,254,0,0,0,0,0,0,0,31,0,0,0,0,0,0,0,5,31,128,0,0,0,0,0,0,47,11,208,0,0,63,208,0,0,31,131,240,0,0,63,208,0,0,11,194,244,0,0,47,208,0,0,3,240,208,0,0,47,208,0,0,2,240,0,0,0,47,192,0,0,0,64,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,27,240,0,0,0,47,192,0,91,255,253,0,0,0,47,193,111,255,255,253,0,0,0,47,255,255,255,255,248,0,0,26,255,255,255,255,159,240,0,47,255,255,255,254,64,47,224,0,127,255,255,249,0,0,63,192,0,63,255,255,192,0,0,255,64,0,63,164,47,192,0,2,254,0,0,16,0,47,192,0,7,252,0,0,0,0,47,192,0,15,244,0,0,0,0,47,192,0,63,224,0,0,0,0,47,192,0,255,192,0,0,0,0,47,192,0,47,0,0,0,0,0,47,192,0,4,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,249,0,1,91,240,0,0,0,15,255,255,255,255,240,0,0,0,11,255,255,255,255,240,0,0,0,1,255,255,255,255,224,0,0,0,0,6,170,165,80,0,0,
  // 0x30bd  ソ
  189,48,28,29,203,37,4,255,0,0,0,0,0,1,80,11,64,0,0,0,3,254,191,192,0,0,0,3,253,127,224,0,0,0,3,252,47,240,0,0,0,7,252,15,252,0,0,0,7,252,7,253,0,0,0,11,248,3,255,0,0,0,15,244,1,255,128,0,0,31,240,0,191,192,0,0,47,224,0,63,224,0,0,63,208,0,47,224,0,0,127,192,0,15,0,0,0,255,128,0,0,0,0,1,255,0,0,0,0,0,3,254,0,0,0,0,0,11,252,0,0,0,0,0,31,248,0,0,0,0,0,63,240,0,0,0,0,0,255,208,0,0,0,0,3,255,128,0,0,0,0,15,255,0,0,0,0,0,63,252,0,0,0,0,1,255,240,0,0,0,0,11,255,192,0,0,0,0,191,254,0,0,0,0,11,255,248,0,0,0,0,15,255,208,0,0,0,0,3,254,0,0,0,0,0,0,160,0,0,0,0,
  // 0x30be  ゾ
  190,48,31,34,16,37,4,254,0,0,0,0,0,0,2,128,0,0,0,0,0,6,15,208,0,0,0,0,0,47,67,240,0,0,0,0,0,15,193,248,0,0,0,0,0,7,224,252,0,0,0,0,0,3,240,100,31,0,0,0,0,1,224,0,255,64,0,0,0,10,144,0,255,192,0,0,0,15,248,0,63,224,0,0,0,15,244,0,47,240,0,0,0,15,240,0,15,252,0,0,0,31,240,0,7,253,0,0,0,47,224,0,3,255,0,0,0,63,208,0,1,255,128,0,0,63,192,0,0,255,192,0,0,191,128,0,0,127,192,0,0,255,64,0,0,61,0,0,1,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,11,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,63,240,0,0,0,0,0,0,191,208,0,0,0,0,0,1,255,128,0,0,0,0,0,7,255,0,0,0,0,0,0,31,252,0,0,0,0,0,0,191,244,0,0,0,0,0,3,255,208,0,0,0,0,0,31,255,64,0,0,0,0,1,255,253,0,0,0,0,0,31,255,240,0,0,0,0,0,47,255,128,0,0,0,0,0,7,248,0,0,0,0,0,0,1,208,0,0,0,0,0,
  // 0x30bf  タ
  191,48,30,34,16,37,3,254,0,0,0,16,0,0,0,0,0,0,0,62,64,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,64,0,0,0,0,0,2,255,0,0,0,0,0,0,3,253,0,0,4,0,0,0,15,255,255,255,255,64,0,0,47,255,255,255,255,208,0,0,127,255,255,255,255,192,0,0,255,149,85,85,255,192,0,3,255,0,0,0,255,64,0,15,252,0,0,0,255,0,0,47,244,0,0,2,254,0,0,191,208,0,0,3,253,0,3,255,128,128,0,11,252,0,31,254,2,248,0,15,244,0,191,248,11,255,64,47,240,0,127,208,3,255,224,127,208,0,15,0,0,191,253,255,192,0,0,0,0,31,255,255,0,0,0,0,0,2,255,254,0,0,0,0,0,0,127,253,0,0,0,0,0,0,63,255,128,0,0,0,0,0,255,255,240,0,0,0,0,3,255,191,252,0,0,0,0,31,254,31,244,0,0,0,0,191,248,3,224,0,0,0,7,255,208,0,128,0,0,0,63,255,64,0,0,0,0,6,255,252,0,0,0,0,0,191,255,208,0,0,0,0,0,255,254,0,0,0,0,0,0,63,228,0,0,0,0,0,0,10,0,0,0,0,0,0,
  // 0x30c0  ダ
  192,48,34,36,68,37,2,253,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,125,0,0,0,0,16,0,0,40,63,0,0,0,0,126,64,0,189,31,128,0,0,0,191,192,0,63,15,192,0,0,0,255,64,0,31,135,224,0,0,2,255,0,0,15,193,0,0,0,7,253,0,0,11,128,0,0,0,15,255,255,255,255,0,0,0,0,47,255,255,255,255,208,0,0,0,127,255,255,255,255,192,0,0,0,255,149,85,85,255,128,0,0,3,255,0,0,0,255,64,0,0,15,252,0,0,1,255,0,0,0,63,244,0,0,2,254,0,0,0,255,208,0,0,3,252,0,0,3,255,128,128,0,11,252,0,0,31,253,2,248,0,15,244,0,0,191,244,11,255,64,47,240,0,0,127,208,3,255,224,127,208,0,0,15,0,0,191,253,255,128,0,0,0,0,0,31,255,255,0,0,0,0,0,0,2,255,253,0,0,0,0,0,0,0,127,253,0,0,0,0,0,0,0,63,255,128,0,0,0,0,0,0,255,255,240,0,0,0,0,0,7,255,191,252,0,0,0,0,0,31,253,31,244,0,0,0,0,0,191,244,3,224,0,0,0,0,7,255,208,0,128,0,0,0,0,127,255,0,0,0,0,0,0,7,255,248,0,0,0,0,0,0,191,255,208,0,0,0,0,0,0,255,254,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,
  // 0x30c1  チ
  193,48,31,32,0,37,3,254,0,0,0,0,0,0,128,0,0,0,0,0,0,111,240,0,0,0,0,22,191,255,248,0,3,255,255,255,255,255,252,0,2,255,255,255,255,249,0,0,1,255,255,255,245,0,0,0,0,149,84,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,170,85,85,95,249,85,85,168,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,15,240,0,0,0,0,0,0,15,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,47,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,255,128,0,0,0,0,0,1,255,0,0,0,0,0,0,3,254,0,0,0,0,0,0,15,252,0,0,0,0,0,0,63,244,0,0,0,0,0,1,255,224,0,0,0,0,0,11,255,128,0,0,0,0,0,47,254,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,128,0,0,0,0,0,
  // 0x30c2  ヂ
  194,48,33,32,32,37,2,253,0,0,0,0,0,6,208,0,0,0,0,0,0,26,255,240,0,0,1,85,106,191,255,255,252,0,0,3,255,255,255,255,255,228,24,0,2,255,255,255,255,144,0,125,0,0,255,250,175,240,0,124,63,0,0,0,0,11,240,0,126,31,128,0,0,0,11,240,0,47,11,192,0,0,0,11,240,0,15,131,64,0,0,0,11,240,0,11,192,0,0,0,0,11,240,0,1,0,0,0,0,0,11,240,0,0,0,0,255,255,255,255,255,255,255,252,0,255,255,255,255,255,255,255,252,0,255,255,255,255,255,255,255,252,0,169,85,85,95,245,85,85,168,0,0,0,0,15,240,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,11,253,0,0,0,0,0,0,0,47,252,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,47,255,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,2,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30c3  ッ
  195,48,26,25,175,37,6,253,0,0,7,64,0,0,0,0,0,63,192,0,25,0,27,0,47,192,0,47,208,191,64,31,224,0,63,208,63,128,15,240,0,63,192,63,192,11,244,0,63,192,31,224,3,248,0,191,64,15,240,3,252,0,255,0,11,244,2,228,1,255,0,3,248,0,0,2,253,0,3,248,0,0,3,252,0,1,64,0,0,15,244,0,0,0,0,0,31,240,0,0,0,0,0,63,208,0,0,0,0,0,255,128,0,0,0,0,3,255,0,0,0,0,0,15,252,0,0,0,0,0,127,244,0,0,0,0,2,255,208,0,0,0,0,47,255,64,0,0,0,2,255,252,0,0,0,0,63,255,224,0,0,0,0,31,255,0,0,0,0,0,7,244,0,0,0,0,0,1,64,0,0,0,0,
  // 0x30c4  ツ
  196,48,31,30,240,37,3,255,0,0,0,16,0,0,0,0,0,0,3,248,0,0,0,0,1,0,3,252,0,0,11,144,47,64,2,253,0,0,15,248,191,128,0,255,0,0,15,244,63,192,0,255,64,0,31,240,47,224,0,127,128,0,47,224,31,240,0,63,192,0,63,208,15,244,0,47,208,0,63,192,7,252,0,31,224,0,127,128,3,252,0,15,128,0,255,64,2,254,0,0,0,1,255,0,1,255,0,0,0,2,254,0,0,228,0,0,0,3,252,0,0,0,0,0,0,15,248,0,0,0,0,0,0,31,240,0,0,0,0,0,0,63,224,0,0,0,0,0,0,255,192,0,0,0,0,0,2,255,64,0,0,0,0,0,11,254,0,0,0,0,0,0,47,248,0,0,0,0,0,0,255,240,0,0,0,0,0,7,255,192,0,0,0,0,0,47,255,0,0,0,0,0,2,255,248,0,0,0,0,0,47,255,208,0,0,0,0,7,255,255,0,0,0,0,0,3,255,244,0,0,0,0,0,0,255,128,0,0,0,0,0,0,116,0,0,0,0,0,
  // 0x30c5  ヅ
  197,48,33,34,50,37,3,254,0,0,0,0,0,0,1,240,0,0,0,0,0,0,2,209,252,0,0,0,0,0,0,3,240,189,0,0,0,0,0,0,2,248,63,0,0,0,0,80,0,0,252,31,64,0,0,11,240,0,0,126,8,0,0,0,11,244,0,0,36,0,0,126,0,3,252,0,0,0,0,0,255,0,3,252,0,0,63,128,0,191,64,1,254,0,0,63,208,0,127,192,0,255,0,0,63,192,0,63,208,0,191,64,0,127,192,0,31,224,0,127,128,0,255,128,0,15,240,0,63,192,0,255,0,0,11,248,0,46,64,1,255,0,0,7,252,0,0,0,3,253,0,0,3,252,0,0,0,7,252,0,0,2,208,0,0,0,15,248,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,1,255,64,0,0,0,0,0,0,7,254,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,2,255,192,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,127,253,0,0,0,0,0,0,7,255,240,0,0,0,0,0,0,127,255,128,0,0,0,0,0,11,255,253,0,0,0,0,0,0,15,255,224,0,0,0,0,0,0,3,254,64,0,0,0,0,0,0,0,224,0,0,0,0,0,0,
  // 0x30c6  テ
  198,48,31,32,0,37,3,253,0,41,85,85,85,85,168,0,0,127,255,255,255,255,252,0,0,127,255,255,255,255,252,0,0,127,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,85,85,85,85,85,85,168,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,0,0,0,11,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,224,0,0,0,0,0,0,47,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,191,128,0,0,0,0,0,1,255,64,0,0,0,0,0,3,255,0,0,0,0,0,0,15,252,0,0,0,0,0,0,127,244,0,0,0,0,0,2,255,224,0,0,0,0,0,31,255,64,0,0,0,0,0,7,253,0,0,0,0,0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30c7  デ
  199,48,33,36,68,37,3,253,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0,0,252,0,0,0,0,0,0,0,116,126,0,0,0,0,0,0,0,252,47,64,0,0,0,0,0,0,126,15,192,0,191,255,255,255,255,47,75,192,0,191,255,255,255,255,15,192,0,0,191,255,255,255,255,10,64,0,0,101,85,85,85,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,170,164,0,255,255,255,255,255,255,255,248,0,255,255,255,255,255,255,255,248,0,255,255,255,255,255,255,255,248,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,31,224,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,7,253,0,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,2,255,208,0,0,0,0,0,0,31,255,64,0,0,0,0,0,0,31,252,0,0,0,0,0,0,0,3,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30c8  ト
  200,48,20,31,155,37,12,255,85,0,0,0,0,255,64,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,248,0,0,0,255,255,224,0,0,255,255,255,64,0,255,255,255,249,0,255,27,255,255,208,255,0,127,255,253,255,0,2,255,253,255,0,0,31,252,255,0,0,1,244,255,0,0,0,16,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,64,0,0,0,
  // 0x30c9  ド
  201,48,23,31,186,37,10,254,21,64,0,0,10,0,127,192,0,0,63,64,63,192,0,44,15,192,63,192,0,126,11,224,63,192,0,63,67,240,63,192,0,15,193,244,63,192,0,11,208,128,63,192,0,3,224,0,63,192,0,1,0,0,63,192,0,0,0,0,63,208,0,0,0,0,63,254,64,0,0,0,63,255,249,0,0,0,63,255,255,224,0,0,63,255,255,255,64,0,63,194,255,255,248,0,63,192,27,255,255,64,63,192,0,127,255,0,63,192,0,6,254,0,63,192,0,0,44,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,
  // 0x30ca  ナ
  202,48,31,32,0,37,3,254,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,191,255,255,255,255,255,255,252,122,170,170,175,254,170,170,172,0,0,0,11,244,0,0,0,0,0,0,11,244,0,0,0,0,0,0,11,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,47,224,0,0,0,0,0,0,63,208,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,128,0,0,0,0,0,3,255,0,0,0,0,0,0,11,253,0,0,0,0,0,0,47,252,0,0,0,0,0,0,191,240,0,0,0,0,0,3,255,208,0,0,0,0,0,47,255,64,0,0,0,0,0,47,252,0,0,0,0,0,0,7,224,0,0,0,0,0,0,0,64,0,0,0,0,0,
  // 0x30cb  ニ
  203,48,30,24,192,37,3,1,2,255,255,255,255,255,252,0,2,255,255,255,255,255,252,0,2,255,255,255,255,255,252,0,2,255,255,255,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,191,255,255,255,255,255,255,240,191,255,255,255,255,255,255,240,191,255,255,255,255,255,255,240,191,255,255,255,255,255,255,240,0,0,0,0,0,0,0,0,
  // 0x30cc  ヌ
  204,48,26,31,217,37,5,253,0,0,0,0,0,4,0,31,255,255,255,255,255,64,31,255,255,255,255,255,208,31,255,255,255,255,255,208,26,170,170,170,170,255,192,0,0,0,0,0,255,128,0,0,0,0,0,255,0,0,0,0,0,1,255,0,0,0,0,0,3,253,0,0,40,0,0,7,252,0,0,127,64,0,11,248,0,1,255,240,0,15,240,0,0,191,253,0,47,224,0,0,31,255,192,127,192,0,0,1,255,244,255,128,0,0,0,63,255,255,0,0,0,0,11,255,253,0,0,0,0,1,255,252,0,0,0,0,0,127,255,0,0,0,0,1,255,255,208,0,0,0,7,255,255,244,0,0,0,47,253,63,254,0,0,0,255,244,11,255,128,0,11,255,208,1,255,224,0,191,255,0,0,127,192,11,255,248,0,0,31,64,255,255,208,0,0,1,0,255,254,0,0,0,0,0,63,224,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30cd  ネ
  205,48,32,33,8,37,3,254,0,0,0,26,160,0,0,0,0,0,0,31,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,11,255,255,255,255,255,244,0,11,255,255,255,255,255,254,0,11,255,255,255,255,255,254,0,6,165,85,85,85,127,248,0,0,0,0,0,0,127,240,0,0,0,0,0,0,255,192,0,0,0,0,0,7,255,0,0,0,0,0,0,31,252,0,0,0,0,0,0,191,240,0,0,0,0,0,3,255,192,0,0,0,0,0,31,254,0,0,0,0,0,1,255,248,0,0,0,0,0,31,255,224,15,128,0,0,1,255,255,224,63,244,0,0,47,255,255,224,63,255,0,27,255,255,95,224,11,255,224,255,255,244,15,224,0,255,252,191,255,64,15,224,0,31,253,63,208,0,15,224,0,3,248,24,0,0,15,224,0,0,176,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,0,0,0,31,224,0,0,0,
  // 0x30ce  ノ
  206,48,25,29,203,37,5,255,0,0,0,0,0,121,0,0,0,0,0,0,191,192,0,0,0,0,0,255,128,0,0,0,0,0,255,64,0,0,0,0,2,255,0,0,0,0,0,3,254,0,0,0,0,0,3,252,0,0,0,0,0,11,252,0,0,0,0,0,15,244,0,0,0,0,0,31,240,0,0,0,0,0,63,208,0,0,0,0,0,127,192,0,0,0,0,0,255,128,0,0,0,0,2,255,0,0,0,0,0,7,253,0,0,0,0,0,15,252,0,0,0,0,0,63,240,0,0,0,0,0,255,208,0,0,0,0,3,255,192,0,0,0,0,15,255,0,0,0,0,0,127,252,0,0,0,0,1,255,240,0,0,0,0,31,255,192,0,0,0,0,191,254,0,0,0,0,11,255,248,0,0,0,0,255,255,192,0,0,0,0,127,254,0,0,0,0,0,31,224,0,0,0,0,0,10,0,0,0,0,0,0,
  // 0x30cf  ハ
  207,48,33,27,243,37,2,0,0,0,4,0,0,44,0,0,0,0,0,31,224,3,254,0,0,0,0,0,47,224,1,255,0,0,0,0,0,63,208,0,255,128,0,0,0,0,63,192,0,127,192,0,0,0,0,63,192,0,63,208,0,0,0,0,127,128,0,31,240,0,0,0,0,191,64,0,15,244,0,0,0,0,255,0,0,11,252,0,0,0,1,255,0,0,3,252,0,0,0,2,254,0,0,2,254,0,0,0,3,253,0,0,1,255,0,0,0,3,252,0,0,0,255,64,0,0,11,248,0,0,0,191,192,0,0,15,244,0,0,0,63,192,0,0,31,240,0,0,0,63,224,0,0,63,224,0,0,0,47,240,0,0,127,192,0,0,0,15,244,0,0,255,128,0,0,0,15,248,0,1,255,0,0,0,0,7,252,0,3,254,0,0,0,0,3,253,0,11,252,0,0,0,0,3,254,0,31,248,0,0,0,0,2,255,0,63,240,0,0,0,0,1,255,64,127,208,0,0,0,0,0,255,64,7,192,0,0,0,0,0,228,0,0,0,0,0,0,0,0,0,0,
  // 0x30d0  バ
  208,48,34,31,23,37,2,0,0,0,0,0,0,0,0,44,0,0,0,0,0,0,0,4,63,0,0,0,0,0,0,0,189,31,64,0,0,0,0,0,0,63,15,192,0,0,0,0,0,0,31,71,224,0,0,36,0,0,184,15,194,64,0,0,63,208,3,252,7,192,0,0,0,63,192,2,254,1,0,0,0,0,127,192,0,255,0,0,0,0,0,127,128,0,191,128,0,0,0,0,191,64,0,127,192,0,0,0,0,255,0,0,63,224,0,0,0,0,255,0,0,31,240,0,0,0,1,254,0,0,15,244,0,0,0,2,253,0,0,11,252,0,0,0,3,252,0,0,3,253,0,0,0,7,252,0,0,2,254,0,0,0,11,244,0,0,1,255,0,0,0,15,240,0,0,0,255,64,0,0,31,240,0,0,0,191,192,0,0,63,208,0,0,0,127,192,0,0,127,192,0,0,0,63,224,0,0,255,128,0,0,0,47,240,0,1,255,0,0,0,0,15,240,0,3,254,0,0,0,0,15,248,0,11,252,0,0,0,0,11,252,0,31,248,0,0,0,0,7,252,0,63,240,0,0,0,0,3,254,0,191,224,0,0,0,0,3,255,0,191,192,0,0,0,0,1,254,0,7,64,0,0,0,0,0,144,0,
  // 0x30d1  パ
  209,48,34,32,32,37,2,255,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,11,255,128,0,0,0,0,0,0,31,67,208,0,0,0,0,0,0,45,1,224,0,0,0,0,0,0,45,0,224,0,0,62,128,2,252,31,3,208,0,0,63,192,3,253,11,255,192,0,0,63,192,1,255,1,253,0,0,0,127,128,0,255,64,0,0,0,0,191,64,0,191,192,0,0,0,0,255,64,0,63,208,0,0,0,0,255,0,0,47,224,0,0,0,0,255,0,0,15,240,0,0,0,2,254,0,0,15,248,0,0,0,3,253,0,0,7,252,0,0,0,3,252,0,0,3,253,0,0,0,7,248,0,0,2,255,0,0,0,15,244,0,0,1,255,0,0,0,15,240,0,0,0,255,64,0,0,47,240,0,0,0,191,192,0,0,63,208,0,0,0,127,192,0,0,127,192,0,0,0,63,224,0,0,255,128,0,0,0,47,240,0,1,255,0,0,0,0,31,240,0,3,254,0,0,0,0,15,248,0,7,253,0,0,0,0,11,252,0,15,252,0,0,0,0,7,252,0,47,244,0,0,0,0,3,253,0,127,224,0,0,0,0,3,254,0,255,192,0,0,0,0,2,255,0,31,128,0,0,0,0,1,244,0,1,0,0,0,0,0,0,0,0,
  // 0x30d2  ヒ
  210,48,24,30,180,37,8,0,170,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,16,255,0,0,0,2,240,255,0,0,0,111,244,255,0,0,11,255,248,255,0,1,255,255,244,255,0,191,255,254,0,255,111,255,255,208,0,255,255,255,244,0,0,255,255,249,0,0,0,255,254,64,0,0,0,255,64,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,191,208,0,0,1,111,127,255,255,255,255,255,63,255,255,255,255,255,15,255,255,255,255,255,0,111,255,255,250,165,
  // 0x30d3  ビ
  211,48,28,33,231,37,6,255,0,0,0,0,0,0,144,0,0,0,0,0,3,240,0,0,0,0,2,224,252,127,128,0,0,3,240,189,127,128,0,0,0,252,63,127,128,0,0,0,189,46,127,128,0,0,0,63,0,127,128,0,0,0,40,0,127,128,0,0,0,16,0,127,128,0,0,2,240,0,127,128,0,0,47,248,0,127,128,0,7,255,252,0,127,128,1,255,255,244,0,127,129,191,255,254,64,0,127,239,255,255,208,0,0,127,255,255,248,0,0,0,127,255,254,0,0,0,0,127,254,64,0,0,0,0,127,208,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,128,0,0,0,0,0,127,192,0,0,0,0,0,63,224,0,0,0,91,64,63,255,255,255,255,255,64,31,255,255,255,255,255,64,7,255,255,255,255,255,64,0,111,255,255,254,165,0,
  // 0x30d4  ピ
  212,48,29,32,0,37,6,255,0,0,0,0,0,7,244,0,0,0,0,0,0,47,254,0,106,128,0,0,0,61,15,64,127,128,0,0,0,120,7,128,127,128,0,0,0,180,3,192,127,128,0,0,0,120,7,128,127,128,0,0,0,61,31,64,127,128,0,0,0,47,254,0,127,128,0,0,1,247,244,0,127,128,0,0,27,244,0,0,127,128,0,2,255,252,0,0,127,128,0,127,255,252,0,0,127,128,111,255,255,128,0,0,127,155,255,255,228,0,0,0,127,255,255,253,0,0,0,0,127,255,254,64,0,0,0,0,127,255,144,0,0,0,0,0,127,208,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,128,0,0,0,0,0,0,127,192,0,0,0,0,0,0,63,224,0,0,0,91,64,0,63,255,255,255,255,255,64,0,31,255,255,255,255,255,64,0,7,255,255,255,255,255,64,0,0,111,255,255,254,165,0,0,
  // 0x30d5  フ
  213,48,27,29,203,37,5,254,255,255,255,255,255,255,224,255,255,255,255,255,255,252,255,255,255,255,255,255,252,186,170,170,170,170,175,248,0,0,0,0,0,15,244,0,0,0,0,0,15,240,0,0,0,0,0,31,240,0,0,0,0,0,47,224,0,0,0,0,0,63,208,0,0,0,0,0,63,192,0,0,0,0,0,191,128,0,0,0,0,0,255,64,0,0,0,0,2,255,0,0,0,0,0,3,254,0,0,0,0,0,11,252,0,0,0,0,0,31,244,0,0,0,0,0,127,240,0,0,0,0,0,255,208,0,0,0,0,3,255,64,0,0,0,0,31,254,0,0,0,0,0,191,248,0,0,0,0,7,255,224,0,0,0,0,127,255,128,0,0,0,11,255,253,0,0,0,1,255,255,224,0,0,0,0,255,255,64,0,0,0,0,63,244,0,0,0,0,0,14,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30d6  ブ
  214,48,32,35,24,37,4,254,0,0,0,0,0,0,0,128,0,0,0,0,0,6,7,240,0,0,0,0,0,15,194,244,0,0,0,0,0,11,224,252,0,0,0,0,0,3,240,126,0,0,0,0,0,1,248,56,191,170,170,170,170,171,240,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,253,0,191,255,255,255,255,255,252,0,0,0,0,0,0,11,252,0,0,0,0,0,0,11,248,0,0,0,0,0,0,15,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,47,224,0,0,0,0,0,0,63,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,191,128,0,0,0,0,0,0,255,64,0,0,0,0,0,2,255,0,0,0,0,0,0,7,253,0,0,0,0,0,0,15,252,0,0,0,0,0,0,47,244,0,0,0,0,0,0,191,224,0,0,0,0,0,1,255,192,0,0,0,0,0,11,255,0,0,0,0,0,0,63,253,0,0,0,0,0,1,255,244,0,0,0,0,0,31,255,208,0,0,0,0,1,255,255,0,0,0,0,0,111,255,248,0,0,0,0,0,255,255,208,0,0,0,0,0,63,254,0,0,0,0,0,0,31,208,0,0,0,0,0,0,4,0,0,0,0,0,0,
  // 0x30d7  プ
  215,48,33,34,50,37,4,254,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,63,252,0,0,0,0,0,0,0,184,47,0,0,0,0,0,0,0,240,15,0,0,0,0,0,0,0,240,11,64,191,170,170,170,170,171,240,15,0,191,255,255,255,255,255,248,47,0,191,255,255,255,255,255,255,252,0,191,255,255,255,255,255,255,224,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,15,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,63,224,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,47,244,0,0,0,0,0,0,0,191,240,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,11,255,64,0,0,0,0,0,0,63,253,0,0,0,0,0,0,1,255,244,0,0,0,0,0,0,31,255,208,0,0,0,0,0,1,255,255,0,0,0,0,0,0,111,255,248,0,0,0,0,0,0,255,255,208,0,0,0,0,0,0,63,254,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,
  // 0x30d8  ヘ
  216,48,33,24,216,37,2,1,0,0,0,100,0,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,255,192,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,191,255,252,0,0,0,0,0,1,255,135,255,0,0,0,0,0,7,254,1,255,192,0,0,0,0,15,252,0,127,240,0,0,0,0,63,240,0,47,252,0,0,0,0,191,208,0,11,254,0,0,0,2,255,128,0,2,255,128,0,0,11,255,0,0,0,255,224,0,0,47,252,0,0,0,63,248,0,0,191,244,0,0,0,15,253,0,0,127,224,0,0,0,7,255,64,0,31,192,0,0,0,1,255,192,0,11,0,0,0,0,0,191,240,0,0,0,0,0,0,0,63,252,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,44,0,0,0,0,0,0,0,0,0,0,
  // 0x30d9  ベ
  217,48,33,28,252,37,2,0,0,0,0,0,0,0,2,192,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,3,244,0,0,0,0,0,0,31,193,252,0,0,0,1,248,0,15,208,190,0,0,0,11,255,0,3,240,63,0,0,0,47,255,192,2,248,40,0,0,0,127,255,240,0,252,0,0,0,1,255,239,252,0,160,0,0,0,3,255,7,255,0,0,0,0,0,15,252,1,255,192,0,0,0,0,47,240,0,127,240,0,0,0,0,191,208,0,31,252,0,0,0,1,255,128,0,11,255,0,0,0,7,255,0,0,2,255,128,0,0,31,253,0,0,0,255,224,0,0,127,244,0,0,0,63,248,0,0,255,224,0,0,0,15,253,0,0,127,192,0,0,0,7,255,64,0,31,64,0,0,0,1,255,208,0,6,0,0,0,0,0,191,240,0,0,0,0,0,0,0,63,252,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,1,255,64,0,0,0,0,0,0,0,189,0,0,0,0,0,0,0,0,52,0,0,0,0,0,0,0,0,0,0,
  // 0x30da  ペ
  218,48,33,28,252,37,2,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,1,255,240,0,0,0,0,0,0,3,225,252,0,0,0,0,0,0,7,192,61,0,0,0,2,248,0,11,64,45,0,0,0,11,255,0,11,64,45,0,0,0,47,255,192,7,128,61,0,0,0,127,255,240,3,224,188,0,0,1,255,239,252,1,255,244,0,0,3,255,7,255,0,47,128,0,0,15,252,1,255,192,0,0,0,0,47,240,0,127,240,0,0,0,0,191,208,0,31,252,0,0,0,1,255,128,0,11,255,0,0,0,7,255,0,0,2,255,128,0,0,15,253,0,0,0,255,224,0,0,63,248,0,0,0,63,248,0,0,255,240,0,0,0,15,253,0,0,191,192,0,0,0,7,255,64,0,47,128,0,0,0,1,255,208,0,11,0,0,0,0,0,191,240,0,0,0,0,0,0,0,63,252,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,3,255,192,0,0,0,0,0,0,1,255,64,0,0,0,0,0,0,0,189,0,0,0,0,0,0,0,0,52,0,0,0,0,0,0,0,0,0,0,
  // 0x30db  ホ
  219,48,32,32,0,37,3,254,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,42,170,170,175,250,170,170,164,63,255,255,255,255,255,255,248,63,255,255,255,255,255,255,248,63,255,255,255,255,255,255,248,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,9,0,15,240,0,96,0,0,15,208,15,240,3,248,0,0,47,208,15,240,7,252,0,0,127,192,15,240,2,255,0,0,255,64,15,240,0,255,128,2,254,0,15,240,0,127,192,7,252,0,15,240,0,47,224,15,244,0,15,240,0,15,244,63,224,0,15,240,0,11,252,255,192,0,15,240,0,3,253,255,64,0,15,240,0,1,253,45,0,0,15,240,0,0,224,0,0,0,15,240,0,0,0,0,0,16,31,240,0,0,0,0,0,127,255,240,0,0,0,0,0,127,255,224,0,0,0,0,0,63,255,192,0,0,0,0,0,21,169,0,0,0,0,
  // 0x30dc  ボ
  220,48,34,34,50,37,2,254,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,124,0,0,0,0,6,164,0,184,63,0,0,0,0,11,244,0,252,47,64,0,0,0,11,244,0,126,15,192,0,0,0,7,244,0,47,71,208,0,0,0,7,244,0,15,130,0,0,0,0,7,244,0,9,0,0,0,0,0,7,244,0,0,0,0,47,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,252,0,26,170,170,175,250,170,170,168,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,16,0,0,0,11,128,7,244,0,248,0,0,0,15,240,7,244,3,253,0,0,0,63,208,7,244,1,255,0,0,0,127,192,7,244,0,191,128,0,0,255,0,7,244,0,63,208,0,3,254,0,7,244,0,31,240,0,11,252,0,7,244,0,15,248,0,31,240,0,7,244,0,3,252,0,127,208,0,7,244,0,2,255,0,191,128,0,7,244,0,0,254,0,31,0,0,7,244,0,0,180,0,0,0,0,7,244,0,0,0,0,0,0,16,15,244,0,0,0,0,0,0,63,255,244,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,63,255,224,0,0,0,0,0,0,5,89,0,0,0,0,0,
  // 0x30dd  ポ
  221,48,33,35,59,37,2,254,0,0,0,0,0,0,6,228,0,0,0,0,0,0,0,47,253,0,0,0,0,0,0,0,61,31,0,0,0,0,11,248,0,180,11,64,0,0,0,11,244,0,180,7,128,0,0,0,11,244,0,180,11,64,0,0,0,7,244,0,61,31,0,0,0,0,7,244,0,47,253,0,0,0,0,7,244,0,6,228,0,0,0,0,7,244,0,0,0,0,47,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,252,0,26,170,170,175,250,170,170,168,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,16,0,0,0,11,128,7,244,0,248,0,0,0,15,240,7,244,3,253,0,0,0,63,208,7,244,1,255,0,0,0,127,192,7,244,0,191,128,0,0,255,0,7,244,0,63,208,0,3,254,0,7,244,0,31,240,0,11,252,0,7,244,0,15,248,0,31,240,0,7,244,0,3,252,0,127,208,0,7,244,0,2,255,0,191,128,0,7,244,0,0,254,0,31,0,0,7,244,0,0,180,0,0,0,0,7,244,0,0,0,0,0,0,16,15,244,0,0,0,0,0,0,63,255,244,0,0,0,0,0,0,63,255,240,0,0,0,0,0,0,63,255,224,0,0,0,0,0,0,5,89,0,0,0,0,0,
  // 0x30de  マ
  222,48,32,30,240,37,3,253,0,0,0,0,0,0,0,64,127,255,255,255,255,255,255,240,127,255,255,255,255,255,255,252,127,255,255,255,255,255,255,253,122,170,170,170,170,170,191,248,0,0,0,0,0,0,63,240,0,0,0,0,0,0,255,208,0,0,0,0,0,1,255,128,0,0,0,0,0,3,255,0,0,0,0,0,0,15,252,0,0,0,0,0,0,63,244,0,0,1,128,0,0,191,224,0,0,7,224,0,2,255,128,0,0,47,252,0,11,255,0,0,0,15,255,0,47,252,0,0,0,2,255,208,191,240,0,0,0,0,191,251,255,192,0,0,0,0,31,255,255,0,0,0,0,0,7,255,248,0,0,0,0,0,0,255,240,0,0,0,0,0,0,63,248,0,0,0,0,0,0,15,253,0,0,0,0,0,0,7,255,64,0,0,0,0,0,1,255,208,0,0,0,0,0,0,127,240,0,0,0,0,0,0,47,252,0,0,0,0,0,0,11,253,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,
  // 0x30df  ミ
  223,48,24,30,180,37,6,255,0,186,64,0,0,0,0,255,255,144,0,0,1,255,255,255,144,0,1,191,255,255,255,144,0,0,111,255,255,255,0,0,0,27,255,255,0,0,0,0,27,253,0,0,0,0,0,108,0,0,0,0,0,0,0,0,0,0,0,0,7,229,0,0,0,0,11,255,249,0,0,0,15,255,255,249,0,0,10,255,255,255,249,0,0,6,191,255,255,224,0,0,1,191,255,208,0,0,0,1,191,192,0,0,0,0,6,128,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,127,228,0,0,0,0,255,255,229,0,0,0,255,255,255,249,0,0,107,255,255,255,228,0,0,26,255,255,255,224,0,0,6,255,255,252,0,0,0,6,255,248,0,0,0,0,27,240,0,0,0,0,0,96,
  // 0x30e0  ム
  224,48,33,32,32,37,2,254,0,0,0,20,0,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,63,208,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,191,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,2,254,0,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,7,252,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,31,240,0,0,0,0,0,0,0,47,208,0,2,192,0,0,0,0,63,192,0,47,224,0,0,0,0,127,192,0,15,244,0,0,0,0,191,64,0,11,252,0,0,0,0,255,0,0,3,253,0,0,0,1,255,0,0,1,255,0,0,0,2,253,0,0,0,255,128,0,0,3,252,0,0,0,127,192,0,0,7,252,0,0,0,63,224,0,0,11,244,0,21,175,255,240,0,0,15,250,255,255,255,255,248,0,127,255,255,255,255,255,255,252,0,63,255,255,255,255,255,167,254,0,63,255,255,254,149,0,2,255,0,63,250,80,0,0,0,0,255,128,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,0,116,0,0,0,0,0,0,0,0,0,0,
  // 0x30e1  メ
  225,48,29,31,248,37,4,254,0,0,0,0,0,14,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,240,0,0,0,0,0,0,63,224,0,0,0,0,0,0,63,192,0,0,0,0,0,0,191,128,0,0,31,0,0,0,255,64,0,0,63,224,0,1,255,0,0,0,191,252,0,3,253,0,0,0,31,255,64,7,252,0,0,0,2,255,240,15,244,0,0,0,0,127,253,47,240,0,0,0,0,15,255,191,208,0,0,0,0,2,255,255,128,0,0,0,0,0,127,255,0,0,0,0,0,0,15,255,64,0,0,0,0,0,31,255,224,0,0,0,0,0,63,255,248,0,0,0,0,0,255,239,254,0,0,0,0,3,255,71,255,192,0,0,0,31,253,1,255,240,0,0,0,127,244,0,63,252,0,0,2,255,208,0,15,255,0,0,15,255,64,0,3,255,128,0,127,253,0,0,0,255,0,7,255,240,0,0,0,60,0,63,255,128,0,0,0,16,0,191,253,0,0,0,0,0,0,31,224,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30e2  モ
  226,48,30,29,232,37,4,255,6,85,85,85,85,85,84,0,7,255,255,255,255,255,252,0,7,255,255,255,255,255,252,0,7,255,255,255,255,255,252,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,170,170,175,254,170,170,170,144,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,224,255,255,255,255,255,255,255,224,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,248,0,0,0,0,0,0,7,252,0,0,0,0,0,0,7,255,64,0,21,64,0,0,3,255,255,255,255,128,0,0,2,255,255,255,255,64,0,0,0,191,255,255,255,64,0,0,0,6,175,170,170,0,
  // 0x30e3  ャ
  227,48,27,27,189,37,5,253,0,0,80,0,0,0,0,0,15,224,0,0,0,0,0,15,240,0,0,0,0,0,11,240,0,0,0,0,0,7,244,0,0,1,144,0,3,248,0,6,255,248,0,2,252,27,255,255,252,0,2,255,255,255,255,244,22,191,255,255,254,95,224,191,255,255,249,0,63,192,127,255,255,0,0,191,64,63,148,127,64,1,254,0,16,0,63,128,3,252,0,0,0,63,192,15,244,0,0,0,47,192,63,208,0,0,0,31,208,127,128,0,0,0,15,240,10,0,0,0,0,15,240,0,0,0,0,0,11,244,0,0,0,0,0,3,248,0,0,0,0,0,3,252,0,0,0,0,0,2,252,0,0,0,0,0,1,253,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,191,64,0,0,0,0,0,121,0,0,0,
  // 0x30e4  ヤ
  228,48,32,32,0,37,2,254,0,0,108,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,253,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,255,0,0,0,0,16,0,0,255,0,0,0,107,252,0,0,191,64,1,175,255,255,0,0,127,134,255,255,255,254,0,0,127,255,255,255,255,252,5,175,255,255,255,249,15,244,255,255,255,255,228,0,31,240,191,255,255,240,0,0,63,192,127,254,79,240,0,0,255,64,57,64,11,244,0,2,255,0,0,0,7,248,0,11,252,0,0,0,3,252,0,47,244,0,0,0,3,252,0,191,208,0,0,0,2,254,1,255,128,0,0,0,1,255,0,126,0,0,0,0,0,255,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,191,128,0,0,0,0,0,0,127,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,208,0,0,0,0,0,0,47,224,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,244,0,0,0,0,0,0,11,248,0,0,0,0,0,0,7,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,2,64,0,0,0,
  // 0x30e5  ュ
  229,48,27,20,140,37,5,255,0,255,255,255,255,208,0,0,255,255,255,255,244,0,0,255,255,255,255,244,0,0,170,170,170,175,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,224,0,0,0,0,0,31,224,0,0,0,0,0,31,208,0,0,0,0,0,47,208,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,192,0,0,0,0,0,63,128,0,0,0,0,0,127,128,0,106,170,170,170,255,234,168,191,255,255,255,255,255,252,191,255,255,255,255,255,252,191,255,255,255,255,255,252,0,0,0,0,0,0,0,
  // 0x30e6  ユ
  230,48,32,25,200,37,3,1,0,254,170,170,170,191,128,0,0,255,255,255,255,255,240,0,0,255,255,255,255,255,240,0,0,255,255,255,255,255,240,0,0,0,0,0,0,47,240,0,0,0,0,0,0,47,224,0,0,0,0,0,0,47,224,0,0,0,0,0,0,63,208,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,127,192,0,0,0,0,0,0,191,128,0,0,0,0,0,0,191,64,0,0,0,0,0,0,255,64,0,0,0,0,0,0,255,0,0,0,0,0,0,0,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,1,254,0,0,0,0,0,0,2,254,0,0,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,253,0,0,0,0,0,0,0,0,
  // 0x30e7  ョ
  231,48,22,24,144,37,7,253,63,255,255,255,255,240,63,255,255,255,255,240,63,255,255,255,255,240,21,85,85,85,95,240,0,0,0,0,11,240,0,0,0,0,11,240,0,0,0,0,11,240,0,0,0,0,11,240,0,0,0,0,11,240,15,255,255,255,255,240,15,255,255,255,255,240,15,255,255,255,255,240,5,85,85,85,95,240,0,0,0,0,11,240,0,0,0,0,11,240,0,0,0,0,11,240,0,0,0,0,11,240,0,0,0,0,11,240,21,85,85,85,95,240,127,255,255,255,255,240,127,255,255,255,255,240,127,255,255,255,255,240,0,0,0,0,11,240,0,0,0,0,5,80,
  // 0x30e8  ヨ
  232,48,26,28,196,37,5,255,63,255,255,255,255,255,240,63,255,255,255,255,255,240,63,255,255,255,255,255,240,42,170,170,170,170,175,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,15,255,255,255,255,255,240,15,255,255,255,255,255,240,15,255,255,255,255,255,240,10,170,170,170,170,175,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,106,170,170,170,170,175,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,
  // 0x30e9  ラ
  233,48,28,31,217,37,5,254,1,169,85,85,85,106,128,2,255,255,255,255,255,192,2,255,255,255,255,255,192,2,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,165,85,85,85,85,85,160,255,255,255,255,255,255,253,255,255,255,255,255,255,254,255,255,255,255,255,255,252,0,0,0,0,0,7,252,0,0,0,0,0,11,248,0,0,0,0,0,15,240,0,0,0,0,0,47,224,0,0,0,0,0,63,208,0,0,0,0,0,191,192,0,0,0,0,1,255,0,0,0,0,0,7,254,0,0,0,0,0,31,252,0,0,0,0,0,127,240,0,0,0,0,2,255,192,0,0,0,0,31,255,0,0,0,0,2,255,252,0,0,0,0,111,255,224,0,0,0,15,255,255,64,0,0,0,7,255,244,0,0,0,0,1,255,64,0,0,0,0,0,160,0,0,0,0,
  // 0x30ea  リ
  234,48,21,31,186,37,8,254,170,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,63,192,255,0,0,0,127,128,255,0,0,0,127,128,255,0,0,0,191,64,85,0,0,0,255,0,0,0,0,1,255,0,0,0,0,3,254,0,0,0,0,11,252,0,0,0,0,47,248,0,0,0,0,191,240,0,0,0,7,255,192,0,0,0,111,255,0,0,0,11,255,252,0,0,0,31,255,224,0,0,0,7,254,0,0,0,0,2,224,0,0,0,0,0,0,0,0,0,
  // 0x30eb  ル
  235,48,33,29,5,37,2,255,0,2,253,0,63,208,0,0,0,0,2,253,0,63,192,0,0,0,0,2,253,0,47,192,0,0,0,0,2,253,0,47,192,0,0,0,0,2,253,0,47,192,0,0,0,0,2,253,0,47,192,0,0,0,0,2,252,0,47,192,0,0,0,0,2,252,0,47,192,0,0,0,0,2,252,0,47,192,0,0,0,0,2,252,0,47,192,0,0,0,0,2,252,0,47,192,0,0,0,0,2,252,0,47,192,0,0,0,0,3,252,0,47,192,0,0,0,0,3,252,0,47,192,0,0,0,0,3,252,0,47,192,0,0,0,0,3,248,0,47,192,0,7,0,0,7,248,0,47,192,0,15,128,0,11,244,0,47,192,0,63,192,0,15,240,0,47,192,0,255,192,0,31,240,0,47,192,3,255,0,0,63,208,0,47,192,31,252,0,0,127,192,0,47,192,191,240,0,0,255,128,0,47,203,255,192,0,2,255,0,0,47,255,255,0,0,11,253,0,0,47,255,248,0,0,47,248,0,0,63,255,208,0,0,191,240,0,0,63,254,0,0,0,47,192,0,0,31,224,0,0,0,7,0,0,0,3,64,0,0,0,
  // 0x30ec  レ
  236,48,26,29,203,37,8,255,255,64,0,0,0,0,0,255,64,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,3,64,255,0,0,0,0,15,192,255,0,0,0,0,63,224,255,0,0,0,0,255,192,255,0,0,0,7,255,0,255,0,0,0,47,253,0,255,0,0,1,255,244,0,255,0,0,11,255,192,0,255,0,0,191,254,0,0,255,0,11,255,244,0,0,255,0,191,255,128,0,0,255,95,255,252,0,0,0,255,255,255,208,0,0,0,255,255,253,0,0,0,0,255,255,128,0,0,0,0,63,228,0,0,0,0,0,9,0,0,0,0,0,0,
  // 0x30ed  ロ
  237,48,27,28,196,37,5,255,170,170,170,170,170,170,168,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,255,170,170,170,170,171,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,255,255,255,255,255,252,255,0,0,0,0,3,252,255,0,0,0,0,3,252,0,0,0,0,0,0,0,
  // 0x30ee  ヮ
  238,48,25,25,175,37,6,252,21,85,85,85,85,104,0,127,255,255,255,255,255,64,63,255,255,255,255,255,192,63,255,255,255,255,255,128,63,128,0,0,0,191,64,63,128,0,0,0,255,0,63,128,0,0,0,255,0,63,128,0,0,0,255,0,63,128,0,0,1,254,0,63,128,0,0,2,253,0,127,128,0,0,3,252,0,42,64,0,0,11,248,0,0,0,0,0,15,240,0,0,0,0,0,47,240,0,0,0,0,0,127,208,0,0,0,0,1,255,128,0,0,0,0,7,255,0,0,0,0,0,31,252,0,0,0,0,0,191,244,0,0,0,0,11,255,192,0,0,0,1,191,255,0,0,0,0,11,255,248,0,0,0,0,3,255,192,0,0,0,0,0,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30ef  ワ
  239,48,29,29,232,37,4,254,127,255,255,255,255,255,253,0,127,255,255,255,255,255,255,128,127,255,255,255,255,255,255,128,127,234,170,170,170,170,255,64,127,128,0,0,0,0,255,0,127,128,0,0,0,1,255,0,127,128,0,0,0,1,255,0,127,128,0,0,0,2,254,0,127,128,0,0,0,3,253,0,127,128,0,0,0,3,252,0,127,128,0,0,0,7,252,0,127,128,0,0,0,11,248,0,127,128,0,0,0,15,244,0,21,64,0,0,0,31,240,0,0,0,0,0,0,63,224,0,0,0,0,0,0,127,192,0,0,0,0,0,0,255,128,0,0,0,0,0,3,255,0,0,0,0,0,0,11,254,0,0,0,0,0,0,47,248,0,0,0,0,0,0,255,240,0,0,0,0,0,7,255,192,0,0,0,0,0,47,255,0,0,0,0,0,2,255,252,0,0,0,0,0,111,255,224,0,0,0,0,3,255,255,64,0,0,0,0,0,255,248,0,0,0,0,0,0,63,128,0,0,0,0,0,0,4,0,0,0,0,0,
  // 0x30f0  ヰ
  240,48,31,32,0,37,3,254,0,0,0,0,1,168,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,31,255,255,255,255,255,255,240,31,255,255,255,255,255,255,240,31,255,255,255,255,255,255,240,26,86,254,85,86,254,85,96,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,0,1,253,0,2,253,0,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,170,170,170,170,171,254,170,168,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,2,253,0,0,0,0,0,0,1,168,0,0,
  // 0x30f1  ヱ
  241,48,32,27,216,37,3,0,14,170,170,170,170,170,171,192,15,255,255,255,255,255,255,244,15,255,255,255,255,255,255,244,15,255,255,255,255,255,255,240,0,0,0,0,0,0,63,192,0,0,0,0,0,0,191,128,0,0,0,0,0,1,255,0,0,0,0,63,192,7,253,0,0,0,0,63,192,31,248,0,0,0,0,63,192,127,224,0,0,0,0,63,193,255,192,0,0,0,0,63,193,255,0,0,0,0,0,63,192,44,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,253,0,0,0,0,0,0,0,0,
  // 0x30f2  ヲ
  242,48,28,30,210,37,5,254,58,170,170,170,170,170,224,127,255,255,255,255,255,253,127,255,255,255,255,255,255,127,255,255,255,255,255,253,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,7,248,0,0,0,0,0,11,248,0,0,0,0,0,11,244,0,0,0,0,0,15,240,10,85,85,85,85,95,240,31,255,255,255,255,255,224,31,255,255,255,255,255,192,31,255,255,255,255,255,192,0,0,0,0,0,191,128,0,0,0,0,0,255,0,0,0,0,0,2,254,0,0,0,0,0,7,252,0,0,0,0,0,31,248,0,0,0,0,0,63,240,0,0,0,0,1,255,192,0,0,0,0,7,255,64,0,0,0,0,47,253,0,0,0,0,1,255,244,0,0,0,0,31,255,192,0,0,0,2,255,254,0,0,0,0,127,255,244,0,0,0,0,47,255,128,0,0,0,0,15,248,0,0,0,0,0,2,64,0,0,0,0,
  // 0x30f3  ン
  243,48,30,29,232,37,5,255,2,64,0,0,0,0,0,0,15,224,0,0,0,0,0,0,47,252,0,0,0,0,0,0,31,255,64,0,0,0,0,0,3,255,208,0,0,0,0,0,0,191,248,0,0,0,0,0,0,31,254,0,0,0,6,0,0,7,255,192,0,0,15,0,0,1,255,64,0,0,31,192,0,0,61,0,0,0,63,208,0,0,4,0,0,0,255,192,0,0,0,0,0,2,255,64,0,0,0,0,0,7,254,0,0,0,0,0,0,31,252,0,0,0,0,0,0,127,240,0,0,0,0,0,1,255,208,0,0,0,0,0,7,255,64,0,0,0,0,0,47,253,0,0,0,0,0,1,255,244,0,0,0,0,0,11,255,208,0,0,0,0,0,127,255,0,0,0,0,0,7,255,248,0,0,0,0,0,191,255,208,0,0,0,0,47,255,254,0,0,0,0,111,255,255,224,0,0,0,0,191,255,254,0,0,0,0,0,63,255,224,0,0,0,0,0,31,248,0,0,0,0,0,0,5,0,0,0,0,0,0,0,
  // 0x30f4  ヴ
  244,48,31,35,24,37,4,253,0,0,0,0,0,0,15,192,0,0,1,84,0,11,71,224,0,0,2,254,0,15,195,240,0,0,2,254,0,11,224,252,0,0,2,253,0,3,240,188,0,0,2,253,0,1,248,16,0,0,2,253,0,0,144,0,0,0,2,253,0,0,16,0,255,255,255,255,255,255,252,0,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,0,255,85,85,85,85,87,254,0,254,0,0,0,0,3,253,0,254,0,0,0,0,3,253,0,254,0,0,0,0,3,252,0,254,0,0,0,0,7,252,0,254,0,0,0,0,11,248,0,254,0,0,0,0,15,244,0,254,0,0,0,0,31,240,0,255,0,0,0,0,47,224,0,84,0,0,0,0,63,192,0,0,0,0,0,0,255,192,0,0,0,0,0,1,255,64,0,0,0,0,0,3,254,0,0,0,0,0,0,15,252,0,0,0,0,0,0,63,244,0,0,0,0,0,1,255,224,0,0,0,0,0,11,255,128,0,0,0,0,0,191,254,0,0,0,0,0,27,255,244,0,0,0,0,7,255,255,192,0,0,0,0,3,255,253,0,0,0,0,0,0,255,224,0,0,0,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30f5  ヵ
  245,48,24,27,162,37,6,253,0,0,42,128,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,47,192,0,0,0,0,63,128,0,0,0,0,63,128,0,0,191,255,255,255,255,248,191,255,255,255,255,254,191,255,255,255,255,254,85,85,127,149,85,254,0,0,127,0,0,254,0,0,191,0,0,254,0,0,191,0,0,253,0,0,254,0,0,253,0,1,253,0,0,253,0,2,252,0,0,252,0,3,248,0,1,252,0,11,240,0,1,252,0,31,224,0,2,252,0,63,208,0,2,248,0,255,128,0,3,248,3,255,0,0,7,244,15,252,0,105,95,240,191,244,0,127,255,240,191,208,0,127,255,192,31,0,0,63,255,64,0,0,0,0,0,0,
  // 0x30f6  ヶ
  246,48,28,27,189,37,4,252,0,0,254,0,0,0,0,0,0,255,0,0,0,0,0,1,254,0,0,0,0,0,2,253,0,0,0,0,0,3,252,0,0,0,0,0,7,249,85,85,85,85,0,15,255,255,255,255,254,0,47,255,255,255,255,254,0,63,255,255,255,255,254,0,255,64,0,254,0,0,2,254,0,0,253,0,0,11,252,0,1,253,0,0,47,244,0,2,252,0,0,127,208,0,3,252,0,0,31,128,0,3,252,0,0,1,0,0,11,244,0,0,0,0,0,15,240,0,0,0,0,0,47,224,0,0,0,0,0,63,192,0,0,0,0,0,255,192,0,0,0,0,2,255,0,0,0,0,0,15,253,0,0,0,0,0,63,248,0,0,0,0,2,255,224,0,0,0,0,2,255,128,0,0,0,0,0,61,0,0,0,0,0,0,0,0,0,0,0,
  // 0x30f7  ヷ
  247,48,31,36,32,37,4,253,0,0,0,0,0,0,2,128,0,0,0,0,0,26,15,192,0,0,0,0,0,63,7,240,0,0,0,0,0,31,131,244,0,0,0,0,0,15,193,248,0,0,0,0,0,7,224,64,0,0,0,0,0,1,0,0,255,255,255,255,255,255,244,0,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,0,255,170,170,170,170,171,254,0,255,0,0,0,0,3,253,0,255,0,0,0,0,3,252,0,255,0,0,0,0,3,252,0,255,0,0,0,0,7,252,0,255,0,0,0,0,11,248,0,255,0,0,0,0,15,244,0,255,0,0,0,0,15,240,0,255,0,0,0,0,31,240,0,255,0,0,0,0,63,224,0,85,0,0,0,0,63,192,0,0,0,0,0,0,191,192,0,0,0,0,0,0,255,64,0,0,0,0,0,3,255,0,0,0,0,0,0,11,253,0,0,0,0,0,0,31,248,0,0,0,0,0,0,127,240,0,0,0,0,0,2,255,192,0,0,0,0,0,15,255,64,0,0,0,0,0,191,253,0,0,0,0,0,7,255,244,0,0,0,0,0,191,255,192,0,0,0,0,11,255,254,0,0,0,0,0,3,255,240,0,0,0,0,0,0,254,0,0,0,0,0,0,0,32,0,0,0,0,0,
  // 0x30f8  ヸ
  248,48,33,34,50,37,3,254,0,0,0,0,0,0,0,36,0,0,0,0,0,0,0,4,124,0,0,0,0,0,1,84,60,61,0,0,0,0,0,3,252,62,47,0,0,0,0,0,3,252,31,15,64,0,0,0,0,3,252,15,79,64,0,0,0,0,3,252,11,64,0,0,0,0,0,3,252,0,0,0,42,85,85,85,87,253,86,160,0,63,255,255,255,255,255,255,240,0,63,255,255,255,255,255,255,240,0,63,255,255,255,255,255,255,240,0,0,2,252,0,3,252,0,0,0,0,2,252,0,3,252,0,0,0,0,2,252,0,3,252,0,0,0,0,2,252,0,3,252,0,0,0,0,2,252,0,3,252,0,0,0,0,2,252,0,3,252,0,0,0,0,2,252,0,3,252,0,0,0,0,2,252,0,3,252,0,0,0,0,2,252,0,3,252,0,0,0,0,2,252,0,3,252,0,0,0,255,255,255,255,255,255,255,248,0,255,255,255,255,255,255,255,248,0,255,255,255,255,255,255,255,248,0,170,170,170,170,171,254,170,164,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,2,168,0,0,0,
  // 0x30f9  ヹ
  249,48,33,34,50,37,2,255,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,252,0,0,0,0,0,0,2,240,190,0,0,0,0,0,0,1,248,63,0,0,0,0,0,0,0,252,31,128,0,0,0,0,0,0,126,9,0,0,0,0,0,0,0,40,0,0,7,170,170,170,170,170,171,224,0,7,255,255,255,255,255,255,252,0,7,255,255,255,255,255,255,252,0,7,255,255,255,255,255,255,244,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,255,128,0,0,0,0,47,224,2,255,0,0,0,0,0,47,224,11,252,0,0,0,0,0,47,208,47,244,0,0,0,0,0,47,208,255,224,0,0,0,0,0,47,208,191,128,0,0,0,0,0,47,208,30,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,0,0,0,47,208,0,0,0,0,191,255,255,255,255,255,255,255,0,191,255,255,255,255,255,255,255,0,191,255,255,255,255,255,255,255,0,191,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,
  // 0x30fa  ヺ
  250,48,31,36,32,37,4,253,0,0,0,0,0,0,6,128,0,0,0,0,0,26,15,208,0,0,0,0,0,63,71,240,0,0,0,0,0,31,195,244,0,0,0,0,0,15,209,248,0,0,0,0,0,7,208,64,170,170,170,170,170,171,208,0,191,255,255,255,255,255,248,0,191,255,255,255,255,255,253,0,191,255,255,255,255,255,252,0,0,0,0,0,0,7,252,0,0,0,0,0,0,11,248,0,0,0,0,0,0,11,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,224,0,25,85,85,85,85,111,208,0,47,255,255,255,255,255,192,0,47,255,255,255,255,255,192,0,47,255,255,255,255,255,128,0,0,0,0,0,0,255,0,0,0,0,0,0,1,255,0,0,0,0,0,0,3,253,0,0,0,0,0,0,15,252,0,0,0,0,0,0,47,240,0,0,0,0,0,0,127,208,0,0,0,0,0,1,255,128,0,0,0,0,0,11,255,0,0,0,0,0,0,63,252,0,0,0,0,0,2,255,240,0,0,0,0,0,31,255,192,0,0,0,0,2,255,254,0,0,0,0,0,127,255,240,0,0,0,0,0,63,255,64,0,0,0,0,0,31,244,0,0,0,0,0,0,6,64,0,0,0,0,0,
  // 0x30fb  ・
  251,48,9,9,27,37,14,10,1,144,0,31,253,0,63,255,0,191,255,128,191,255,128,191,255,128,127,255,64,47,254,0,7,244,0,
  // 0x30fc  ー
  252,48,31,5,40,37,3,12,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,244,20,0,0,0,0,0,0,80,
  // 0x30fd  ヽ
  253,48,18,18,90,37,10,4,11,128,0,0,0,47,224,0,0,0,127,248,0,0,0,31,254,0,0,0,3,255,128,0,0,0,255,224,0,0,0,63,248,0,0,0,15,254,0,0,0,3,255,64,0,0,1,255,208,0,0,0,127,244,0,0,0,47,252,0,0,0,11,255,0,0,0,3,255,128,0,0,0,255,224,0,0,0,127,224,0,0,0,47,64,0,0,0,9,0,
  // 0x30fe  ヾ
  254,48,21,24,144,37,9,4,0,0,0,0,32,0,0,0,0,2,244,0,0,0,2,192,252,0,0,0,7,240,126,0,0,0,3,244,63,64,0,0,0,252,31,192,7,128,0,190,10,0,47,224,0,62,0,0,127,252,0,16,0,0,15,255,0,0,0,0,3,255,192,0,0,0,0,255,224,0,0,0,0,63,248,0,0,0,0,15,254,0,0,0,0,3,255,128,0,0,0,0,255,208,0,0,0,0,127,244,0,0,0,0,31,253,0,0,0,0,11,255,0,0,0,0,2,255,192,0,0,0,0,255,224,0,0,0,0,63,224,0,0,0,0,31,128,0,0,0,0,9,0,0,
  // 0x30ff  ヿ
  255,48,23,32,192,37,7,254,85,85,85,85,85,80,255,255,255,255,255,244,255,255,255,255,255,244,255,255,255,255,255,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,0,0,0,0,7,244,
  // 0x4eee  仮
  238,78,35,36,68,37,1,252,0,0,36,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,254,15,255,255,255,255,240,0,1,252,15,255,255,255,255,240,0,3,252,15,255,255,255,255,240,0,11,244,15,213,85,85,85,64,0,15,240,15,192,0,0,0,0,0,47,208,15,192,0,0,0,0,0,127,128,15,192,0,0,0,0,0,255,128,15,192,0,0,0,0,2,255,128,15,192,0,0,0,0,7,255,128,15,192,0,0,0,0,31,255,128,15,255,255,255,255,128,63,255,128,15,255,255,255,255,192,255,239,128,15,255,255,255,255,192,191,47,128,15,255,64,0,63,128,60,47,128,15,255,128,0,63,64,36,47,128,31,223,192,0,127,0,0,47,128,31,207,224,0,254,0,0,47,128,31,199,240,0,253,0,0,47,128,47,195,244,2,252,0,0,47,128,47,194,252,3,248,0,0,47,128,47,128,254,15,240,0,0,47,128,63,64,191,95,224,0,0,47,128,63,64,63,255,192,0,0,47,128,127,0,31,255,64,0,0,47,128,191,0,11,254,0,0,0,47,128,254,0,11,255,0,0,0,47,128,253,0,63,255,192,0,0,47,130,252,0,255,255,244,0,0,47,131,248,11,255,15,255,64,0,47,139,244,127,252,3,255,244,0,47,143,241,255,224,0,191,248,0,47,135,192,191,64,0,15,224,0,47,65,128,36,0,0,1,192,0,0,0,0,0,0,0,0,0,
  // 0x540d  名
  13,84,32,35,24,37,1,253,0,0,0,185,0,0,0,0,0,0,1,255,0,0,0,0,0,0,3,253,0,0,0,0,0,0,11,252,0,0,0,0,0,0,31,255,255,255,244,0,0,0,127,255,255,255,252,0,0,0,255,255,255,255,244,0,0,7,254,0,0,15,240,0,0,31,248,0,0,47,208,0,0,191,240,0,0,63,192,0,3,255,252,0,0,255,64,0,31,255,255,64,1,254,0,0,127,244,255,224,7,252,0,0,31,192,47,248,15,244,0,0,10,0,11,254,63,224,0,0,0,0,2,255,255,192,0,0,0,0,0,191,255,0,0,0,0,0,0,63,252,0,0,0,0,0,0,191,244,0,0,0,0,0,3,255,255,255,255,255,0,0,47,255,255,255,255,255,0,1,255,255,255,255,255,255,0,31,255,244,0,0,0,191,6,255,255,244,0,0,0,191,127,255,211,244,0,0,0,191,63,253,3,244,0,0,0,191,31,128,3,244,0,0,0,191,4,0,3,244,0,0,0,191,0,0,3,244,0,0,0,191,0,0,3,244,0,0,0,191,0,0,3,255,255,255,255,255,0,0,3,255,255,255,255,255,0,0,3,255,255,255,255,255,0,0,3,244,0,0,0,191,0,0,2,160,0,0,0,190,
  // 0x5b9a  定
  154,91,34,36,68,37,1,252,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,255,255,255,255,255,255,255,192,15,229,85,85,85,85,85,111,192,15,208,0,0,0,0,0,47,192,15,208,0,0,0,0,0,47,192,15,208,0,0,0,0,0,47,192,15,208,85,85,85,85,85,47,192,15,211,255,255,255,255,255,47,192,0,3,255,255,255,255,255,0,0,0,3,255,255,255,255,255,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,3,244,1,252,0,0,0,0,0,7,244,1,252,0,0,0,0,0,7,240,1,253,0,0,0,0,0,11,240,1,255,255,255,240,0,0,15,240,1,255,255,255,240,0,0,15,240,1,255,255,255,240,0,0,31,244,1,252,0,0,0,0,0,63,252,1,252,0,0,0,0,0,63,254,1,252,0,0,0,0,0,191,255,65,252,0,0,0,0,0,254,63,225,252,0,0,0,0,3,252,15,254,252,0,0,0,0,11,248,3,255,253,0,0,0,0,47,240,0,255,255,255,255,255,240,127,208,0,31,255,255,255,255,224,47,128,0,0,111,255,255,255,208,10,0,0,0,0,21,85,85,64,0,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,32,36,32,37,1,252,0,0,0,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,192,0,3,248,0,0,0,31,234,170,171,254,170,170,0,31,255,255,255,255,255,255,0,31,255,255,255,255,255,255,0,31,255,255,255,255,255,255,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,234,170,170,171,252,0,0,127,64,0,0,2,252,0,0,191,0,0,0,2,252,0,0,255,0,0,0,2,252,0,0,254,0,0,0,2,252,0,2,253,0,0,0,2,252,0,3,252,0,0,0,2,252,0,11,248,0,0,0,2,252,0,31,240,0,0,0,2,252,0,63,224,0,0,0,2,252,0,127,192,0,0,0,2,252,0,31,64,0,0,0,2,252,0,6,0,0,0,0,2,252,0,0,0,0,0,0,0,0,0,
  // 0x793a  示
  58,121,34,33,41,37,1,253,0,21,85,85,85,85,85,80,0,0,127,255,255,255,255,255,244,0,0,127,255,255,255,255,255,244,0,0,127,255,255,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,21,85,85,86,254,85,85,85,80,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,1,253,0,0,0,0,0,3,228,1,253,0,47,0,0,0,11,244,1,253,0,191,64,0,0,15,240,1,253,0,63,192,0,0,47,224,1,253,0,31,240,0,0,63,192,1,253,0,15,244,0,0,191,128,1,253,0,3,252,0,1,255,0,1,253,0,2,253,0,3,253,0,1,253,0,0,255,0,15,248,0,1,253,0,0,191,128,47,240,0,1,253,0,0,63,192,127,208,0,1,253,0,0,47,208,31,64,0,1,253,0,0,31,128,1,0,26,171,253,0,0,8,0,0,0,15,255,252,0,0,0,0,0,0,15,255,248,0,0,0,0,0,0,11,255,144,0,0,0,0,
  // 0x7fa9  義
  169,127,34,35,59,37,2,253,0,0,100,0,0,11,144,0,0,0,2,252,0,0,15,240,0,0,0,0,255,0,0,47,192,0,0,0,0,127,64,0,63,128,0,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,252,0,10,170,170,171,250,170,170,168,0,0,0,0,7,240,0,0,0,0,0,85,85,91,249,85,85,64,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,170,170,170,174,170,170,170,170,128,0,0,90,252,10,128,180,0,0,47,255,255,255,15,193,255,64,0,63,255,255,228,15,208,191,240,0,26,86,252,0,15,208,11,252,0,0,1,252,0,15,224,1,240,0,170,170,254,170,175,250,170,170,128,255,255,255,255,255,255,255,255,192,255,255,255,255,255,255,255,255,192,0,1,252,0,3,248,2,64,0,0,1,252,0,2,252,15,240,0,86,175,254,175,192,254,63,208,0,255,255,255,255,192,255,255,128,0,255,255,255,250,64,127,253,0,0,80,1,252,0,0,127,244,3,64,0,1,252,0,11,255,244,7,208,0,1,252,1,255,255,254,75,208,2,171,252,47,255,209,255,255,192,3,255,248,15,249,0,127,255,128,2,255,224,7,64,0,6,253,0,
  // 0x8868  表
  104,136,35,35,59,37,1,253,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,7,255,255,255,255,255,255,255,64,7,255,255,255,255,255,255,255,64,7,255,255,255,255,255,255,255,64,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,127,255,255,255,255,255,252,0,0,191,255,255,255,255,255,252,0,0,191,255,255,255,255,255,252,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,47,255,255,255,255,255,255,255,224,0,0,0,127,239,192,0,0,0,0,0,2,255,143,224,0,28,0,0,0,31,253,7,240,0,191,0,0,0,255,240,3,244,2,255,64,0,27,255,192,2,252,31,253,0,1,255,255,128,1,253,191,224,0,111,255,255,128,0,255,255,64,0,127,254,63,128,0,127,248,0,0,47,208,63,128,0,47,224,0,0,9,0,63,128,0,15,244,0,0,0,0,63,128,0,71,253,0,0,0,0,63,128,111,210,255,128,0,0,0,63,239,255,208,191,244,0,0,0,127,255,255,208,47,254,64,0,127,255,255,249,0,7,255,244,0,191,255,249,0,0,0,255,240,0,127,249,0,0,0,0,31,208,0,57,0,0,0,0,0,1,128,
};

#endif // HAS_GRAPHICAL_TFT
