/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Greek 37pt, capital 'A' height: 27px, width: 100%, range: 0x0386-0x03ce, glyphs: 63
extern const uint8_t NotoSans_Medium_Greek_27[10040] = {
  130,27,134,3,206,3,35,247, // unifont_t
  // 0x0386  Ά
  27,27,189,27,0,0,10,164,0,42,128,0,0,15,240,0,127,224,0,0,47,224,0,191,240,0,0,63,192,0,255,244,0,0,63,64,1,255,248,0,0,126,0,3,250,252,0,0,104,0,7,244,253,0,0,0,0,11,240,255,0,0,0,0,15,240,191,0,0,0,0,31,208,63,128,0,0,0,63,192,63,192,0,0,0,63,128,47,208,0,0,0,191,64,15,224,0,0,0,255,0,15,240,0,0,1,254,0,7,244,0,0,2,253,0,3,252,0,0,3,255,255,255,252,0,0,7,255,255,255,254,0,0,15,255,255,255,255,0,0,15,245,85,85,255,64,0,47,224,0,0,127,128,0,63,192,0,0,63,192,0,127,192,0,0,47,208,0,191,64,0,0,31,240,0,255,0,0,0,15,240,1,254,0,0,0,11,248,3,253,0,0,0,3,252,
  // 0x0387  ·
  255,
  // 0x0388  Έ
  25,27,189,27,0,0,10,164,5,85,85,85,64,15,240,15,255,255,255,192,47,224,15,255,255,255,192,63,192,15,255,255,255,192,63,64,15,244,0,0,0,126,0,15,244,0,0,0,104,0,15,244,0,0,0,0,0,15,244,0,0,0,0,0,15,244,0,0,0,0,0,15,244,0,0,0,0,0,15,244,0,0,0,0,0,15,249,85,85,0,0,0,15,255,255,255,64,0,0,15,255,255,255,64,0,0,15,255,255,255,64,0,0,15,244,0,0,0,0,0,15,244,0,0,0,0,0,15,244,0,0,0,0,0,15,244,0,0,0,0,0,15,244,0,0,0,0,0,15,244,0,0,0,0,0,15,244,0,0,0,0,0,15,244,0,0,0,0,0,15,249,85,85,64,0,0,15,255,255,255,192,0,0,15,255,255,255,192,0,0,15,255,255,255,192,
  // 0x0389  Ή
  31,27,216,34,0,0,10,164,5,80,0,0,1,84,15,240,15,244,0,0,3,252,47,224,15,244,0,0,3,252,63,192,15,244,0,0,3,252,63,64,15,244,0,0,3,252,126,0,15,244,0,0,3,252,104,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,249,85,85,91,252,0,0,15,255,255,255,255,252,0,0,15,255,255,255,255,252,0,0,15,255,255,255,255,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,0,0,15,244,0,0,3,252,
  // 0x038a  Ί
  19,27,135,21,0,0,10,164,21,85,84,15,240,63,255,252,47,224,63,255,252,63,192,6,255,144,63,64,0,255,0,126,0,0,255,0,104,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,31,255,244,0,0,63,255,252,0,0,63,255,252,
  // 0x038b  ΋
  255,
  // 0x038c  Ό
  32,28,224,34,0,255,10,164,0,1,175,233,0,0,15,240,0,47,255,255,224,0,47,224,1,255,255,255,252,0,63,192,7,255,250,191,255,64,63,64,31,253,0,2,255,192,126,0,63,240,0,0,63,240,104,0,127,192,0,0,31,244,0,0,255,128,0,0,11,248,0,0,255,0,0,0,7,252,0,1,255,0,0,0,3,253,0,2,254,0,0,0,3,253,0,3,253,0,0,0,2,254,0,3,253,0,0,0,2,254,0,3,253,0,0,0,2,254,0,3,253,0,0,0,2,254,0,3,253,0,0,0,2,254,0,2,254,0,0,0,2,254,0,2,254,0,0,0,3,253,0,1,255,0,0,0,3,252,0,0,255,64,0,0,11,252,0,0,191,192,0,0,15,248,0,0,127,224,0,0,47,240,0,0,47,248,0,0,191,208,0,0,15,255,64,11,255,128,0,0,3,255,255,255,254,0,0,0,0,191,255,255,244,0,0,0,0,11,255,255,128,0,0,0,0,0,21,64,0,0,
  // 0x038d  ΍
  255,
  // 0x038e  Ύ
  30,27,216,30,0,0,10,164,21,64,0,0,5,80,15,240,63,208,0,0,47,224,47,224,31,240,0,0,63,192,63,192,15,244,0,0,191,128,63,64,7,252,0,0,255,0,126,0,3,253,0,2,253,0,104,0,0,255,0,3,252,0,0,0,0,191,128,15,244,0,0,0,0,63,192,31,240,0,0,0,0,47,224,63,208,0,0,0,0,15,240,127,128,0,0,0,0,11,248,255,0,0,0,0,0,3,254,254,0,0,0,0,0,1,255,252,0,0,0,0,0,0,255,248,0,0,0,0,0,0,127,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,0,0,0,0,47,208,0,0,
  // 0x038f  Ώ
  31,27,216,32,0,0,10,164,0,1,191,164,0,0,15,240,0,127,255,255,128,0,47,224,3,255,255,255,244,0,63,192,15,255,234,255,254,0,63,64,63,248,0,7,255,64,126,0,191,208,0,0,255,192,104,0,255,128,0,0,63,224,0,2,255,0,0,0,31,240,0,3,253,0,0,0,15,244,0,3,252,0,0,0,11,248,0,7,252,0,0,0,7,252,0,7,252,0,0,0,7,252,0,7,248,0,0,0,3,252,0,7,248,0,0,0,3,252,0,7,252,0,0,0,3,252,0,3,252,0,0,0,7,248,0,3,252,0,0,0,11,244,0,2,253,0,0,0,15,240,0,0,255,0,0,0,31,224,0,0,191,64,0,0,63,192,0,0,63,192,0,0,127,128,0,0,15,240,0,1,254,0,0,0,7,252,0,7,248,0,0,5,86,255,0,47,245,84,0,11,255,255,64,63,255,252,0,11,255,255,64,63,255,252,0,11,255,255,64,63,255,252,
  // 0x0390  ΐ
  255,
  // 0x0391  Α
  24,27,162,24,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x0392  Β
  20,27,135,24,3,0,21,85,84,0,0,127,255,255,248,0,127,255,255,255,64,127,255,255,255,208,127,128,1,191,240,127,128,0,31,244,127,128,0,15,244,127,128,0,11,244,127,128,0,11,244,127,128,0,15,240,127,128,0,47,224,127,149,86,255,128,127,255,255,253,0,127,255,255,249,0,127,255,255,255,192,127,128,0,127,240,127,128,0,15,248,127,128,0,3,252,127,128,0,3,252,127,128,0,3,253,127,128,0,3,252,127,128,0,11,252,127,128,0,31,248,127,149,86,255,240,127,255,255,255,208,127,255,255,255,0,127,255,255,228,0,
  // 0x0393  Γ
  15,27,108,19,3,0,21,85,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,
  // 0x0394  Δ
  24,27,162,24,0,0,0,0,10,160,0,0,0,0,31,244,0,0,0,0,63,252,0,0,0,0,127,252,0,0,0,0,191,254,0,0,0,0,254,191,0,0,0,1,252,127,64,0,0,3,252,63,192,0,0,3,248,47,192,0,0,11,240,15,224,0,0,15,240,15,240,0,0,31,208,7,244,0,0,63,192,3,252,0,0,63,128,2,252,0,0,191,64,1,254,0,0,255,0,0,255,0,1,254,0,0,191,64,3,252,0,0,63,128,3,252,0,0,63,192,11,244,0,0,31,224,15,240,0,0,15,240,31,224,0,0,15,244,47,208,0,0,7,248,63,234,170,170,171,252,127,255,255,255,255,253,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x0395  Ε
  16,27,108,21,3,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x0396  Ζ
  19,27,135,21,1,0,21,85,85,85,84,127,255,255,255,248,127,255,255,255,248,127,255,255,255,248,0,0,0,47,240,0,0,0,63,192,0,0,0,255,128,0,0,2,255,0,0,0,3,252,0,0,0,15,248,0,0,0,47,240,0,0,0,63,192,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,192,0,0,0,255,64,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,229,85,85,84,191,255,255,255,252,191,255,255,255,252,191,255,255,255,252,
  // 0x0397  Η
  21,27,162,28,3,0,21,0,0,0,21,64,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,149,85,85,127,192,127,255,255,255,255,192,127,255,255,255,255,192,127,255,255,255,255,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,
  // 0x0398  Θ
  25,28,196,29,2,255,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,131,255,255,240,127,192,255,67,255,255,240,127,192,255,67,255,255,240,127,192,191,128,85,85,64,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x0399  Ι
  11,27,81,13,1,0,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,
  // 0x039a  Κ
  20,27,135,23,3,0,21,0,0,1,85,127,128,0,7,253,127,128,0,15,244,127,128,0,63,224,127,128,0,255,128,127,128,2,255,0,127,128,11,252,0,127,128,31,240,0,127,128,127,192,0,127,128,255,64,0,127,131,253,0,0,127,143,248,0,0,127,175,244,0,0,127,255,252,0,0,127,255,254,0,0,127,245,255,64,0,127,192,191,192,0,127,128,63,224,0,127,128,31,244,0,127,128,11,252,0,127,128,3,255,0,127,128,0,255,128,127,128,0,127,192,127,128,0,47,240,127,128,0,15,248,127,128,0,7,253,127,128,0,2,255,
  // 0x039b  Λ
  23,27,162,23,0,0,0,0,26,144,0,0,0,0,63,240,0,0,0,0,63,244,0,0,0,0,191,248,0,0,0,0,255,252,0,0,0,1,253,253,0,0,0,2,252,255,0,0,0,3,248,127,0,0,0,7,244,63,128,0,0,11,240,63,192,0,0,15,224,31,192,0,0,31,208,15,224,0,0,63,192,15,240,0,0,63,128,7,244,0,0,191,64,3,248,0,0,255,0,3,252,0,0,254,0,1,253,0,2,253,0,0,255,0,3,252,0,0,255,0,7,248,0,0,127,64,11,244,0,0,63,192,15,240,0,0,63,192,31,224,0,0,47,224,47,208,0,0,15,240,63,192,0,0,15,244,127,128,0,0,11,248,255,64,0,0,3,252,
  // 0x039c  Μ
  28,27,189,34,3,0,21,80,0,0,0,5,84,127,248,0,0,0,47,253,127,252,0,0,0,63,253,127,253,0,0,0,127,253,127,254,0,0,0,191,253,127,191,0,0,0,254,253,127,127,64,0,1,253,253,127,63,128,0,3,249,253,127,47,192,0,3,241,253,127,15,208,0,11,241,253,127,15,240,0,15,225,253,127,7,240,0,31,193,253,127,3,244,0,47,193,253,127,3,252,0,63,65,253,127,1,252,0,127,1,253,127,0,254,0,190,1,253,127,0,191,0,253,1,253,127,0,127,65,252,1,253,127,0,63,131,248,1,253,127,0,47,195,240,1,253,127,0,31,219,240,1,253,127,0,15,239,208,1,253,127,0,11,255,192,1,253,127,0,3,255,128,1,253,127,0,3,255,64,1,253,127,0,2,255,0,1,253,127,0,0,254,0,1,253,
  // 0x039d  Ν
  22,27,162,29,3,0,21,64,0,0,1,80,127,240,0,0,11,240,127,248,0,0,11,240,127,252,0,0,11,240,127,255,0,0,11,240,127,255,64,0,11,240,127,127,192,0,11,240,127,63,224,0,11,240,127,15,244,0,11,240,127,11,252,0,11,240,127,3,254,0,11,240,127,1,255,0,11,240,127,0,191,192,11,240,127,0,63,208,11,240,127,0,31,240,7,240,127,0,15,248,7,240,127,0,3,253,7,240,127,0,2,255,7,240,127,0,0,255,135,240,127,0,0,127,199,240,127,0,0,47,247,240,127,0,0,15,251,240,127,0,0,7,255,240,127,0,0,3,255,240,127,0,0,0,255,240,127,0,0,0,191,240,127,0,0,0,63,240,
  // 0x039e  Ξ
  19,27,135,23,2,0,21,85,85,85,80,63,255,255,255,240,63,255,255,255,240,63,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,170,170,170,64,11,255,255,255,128,11,255,255,255,128,11,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,84,255,255,255,255,252,255,255,255,255,252,255,255,255,255,252,
  // 0x039f  Ο
  25,28,196,29,2,255,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x03a0  Π
  21,27,162,27,3,0,21,85,85,85,85,64,127,255,255,255,255,192,127,255,255,255,255,192,127,255,255,255,255,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,
  // 0x03a1  Ρ
  18,27,135,23,3,0,21,85,80,0,0,127,255,255,208,0,127,255,255,253,0,127,255,255,255,0,127,128,6,255,192,127,128,0,127,208,127,128,0,47,224,127,128,0,31,224,127,128,0,31,240,127,128,0,31,224,127,128,0,47,224,127,128,0,63,208,127,128,1,255,192,127,149,111,255,64,127,255,255,253,0,127,255,255,240,0,127,255,250,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,
  // 0x03a2  ΢
  255,
  // 0x03a3  Σ
  19,27,135,21,1,0,21,85,85,85,80,127,255,255,255,248,127,255,255,255,248,127,255,255,255,248,47,240,0,0,0,15,252,0,0,0,3,254,0,0,0,0,255,128,0,0,0,127,208,0,0,0,31,244,0,0,0,11,252,0,0,0,2,255,0,0,0,0,255,192,0,0,0,127,192,0,0,0,255,0,0,0,3,253,0,0,0,15,244,0,0,0,47,224,0,0,0,127,192,0,0,1,255,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,213,85,85,84,191,255,255,255,252,191,255,255,255,252,191,255,255,255,252,
  // 0x03a4  Τ
  21,27,162,21,0,0,21,85,85,85,85,0,191,255,255,255,255,64,191,255,255,255,255,64,191,255,255,255,255,64,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,
  // 0x03a5  Υ
  21,27,162,22,0,0,85,0,0,0,21,64,191,192,0,0,63,192,63,208,0,0,191,128,31,240,0,1,255,0,15,244,0,3,253,0,7,252,0,7,252,0,3,253,0,15,244,0,1,255,0,31,240,0,0,191,64,63,208,0,0,63,192,127,128,0,0,47,224,255,0,0,0,15,241,254,0,0,0,11,251,252,0,0,0,3,255,248,0,0,0,1,255,240,0,0,0,0,255,208,0,0,0,0,127,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x03a6  Φ
  28,28,196,32,2,255,0,0,0,169,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,1,175,255,250,64,0,0,47,255,255,255,248,0,2,255,255,255,255,255,64,11,255,229,255,91,255,224,31,248,0,255,0,63,244,63,208,0,255,0,11,252,191,128,0,255,0,3,253,255,64,0,255,0,1,254,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,191,64,0,255,0,2,254,127,192,0,255,0,3,252,63,240,0,255,0,15,248,15,253,0,255,0,127,240,7,255,250,255,175,255,208,1,255,255,255,255,255,0,0,31,255,255,255,244,0,0,0,90,255,165,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,0,0,
  // 0x03a7  Χ
  22,27,162,23,0,0,21,64,0,0,5,80,47,224,0,0,63,192,15,244,0,0,191,128,7,252,0,0,255,0,3,254,0,3,253,0,0,255,0,7,248,0,0,191,128,15,240,0,0,63,208,47,208,0,0,15,240,127,128,0,0,11,248,255,0,0,0,3,254,253,0,0,0,1,255,252,0,0,0,0,191,240,0,0,0,0,127,240,0,0,0,0,255,244,0,0,0,2,255,252,0,0,0,3,254,254,0,0,0,15,240,255,64,0,0,31,224,127,192,0,0,63,192,47,224,0,0,191,64,15,244,0,1,255,0,7,252,0,3,252,0,3,254,0,11,248,0,0,255,0,31,240,0,0,191,192,63,208,0,0,63,208,191,128,0,0,31,240,
  // 0x03a8  Ψ
  25,27,189,31,3,0,85,0,1,80,0,21,64,191,0,7,244,0,127,128,191,0,7,244,0,127,128,191,0,7,244,0,127,128,191,0,7,244,0,127,128,191,0,7,244,0,127,128,191,0,7,244,0,127,128,191,0,7,244,0,127,128,191,0,7,244,0,127,128,191,0,7,244,0,127,128,191,64,7,244,0,127,128,191,64,7,244,0,127,128,127,128,7,244,0,191,64,63,192,7,244,0,255,0,63,224,7,244,2,255,0,31,244,7,244,7,253,0,11,255,91,249,191,248,0,2,255,255,255,255,224,0,0,127,255,255,255,64,0,0,6,255,255,228,0,0,0,0,7,244,0,0,0,0,0,7,244,0,0,0,0,0,7,244,0,0,0,0,0,7,244,0,0,0,0,0,7,244,0,0,0,0,0,7,244,0,0,0,0,0,7,244,0,0,0,
  // 0x03a9  Ω
  25,27,189,27,1,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,191,240,0,15,253,0,0,31,252,0,31,244,0,0,7,253,0,63,224,0,0,2,255,0,63,192,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,64,0,0,0,127,128,191,64,0,0,0,127,128,191,128,0,0,0,127,128,127,128,0,0,0,191,64,63,192,0,0,0,255,0,63,192,0,0,0,255,0,31,224,0,0,2,253,0,15,240,0,0,3,252,0,7,248,0,0,11,244,0,1,254,0,0,47,208,0,0,127,128,0,191,64,0,85,111,240,3,254,85,64,255,255,240,3,255,255,192,255,255,240,3,255,255,192,255,255,240,3,255,255,192,
  // 0x03aa  Ϊ
  255,
  // 0x03ab  Ϋ
  255,
  // 0x03ac  ά
  21,30,180,23,2,255,0,0,26,160,0,0,0,0,47,224,0,0,0,0,63,192,0,0,0,0,127,64,0,0,0,0,191,0,0,0,0,0,252,0,0,0,0,0,164,0,0,0,0,0,0,0,0,0,0,1,64,0,0,0,0,191,253,7,240,0,3,255,255,203,240,0,15,255,255,255,240,0,47,248,1,255,240,0,63,208,0,127,240,0,127,192,0,47,240,0,191,64,0,31,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,191,64,0,31,240,0,191,128,0,47,240,0,63,208,0,63,240,0,47,244,1,255,244,0,15,255,255,251,255,64,3,255,255,195,255,128,0,191,254,1,255,64,0,1,64,0,20,0,
  // 0x03ad  έ
  16,30,120,18,1,255,0,0,26,160,0,0,63,224,0,0,63,192,0,0,127,64,0,0,191,0,0,0,252,0,0,0,164,0,0,0,0,0,0,0,80,0,0,191,255,228,3,255,255,253,15,255,255,252,31,240,0,120,47,208,0,0,47,192,0,0,31,208,0,0,15,244,0,0,3,255,254,0,0,191,255,0,3,255,255,0,31,249,0,0,63,192,0,0,127,128,0,0,127,128,0,0,127,192,0,0,63,224,0,28,47,255,255,252,11,255,255,252,1,191,255,244,0,1,84,0,
  // 0x03ae  ή
  17,38,190,23,3,247,0,2,170,0,0,0,3,253,0,0,0,7,248,0,0,0,11,240,0,0,0,15,208,0,0,0,31,192,0,0,0,26,0,0,0,0,0,0,0,0,0,0,20,0,0,253,11,255,224,0,253,63,255,252,0,255,255,255,255,0,255,248,2,255,64,255,208,0,191,128,255,192,0,63,192,255,64,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,
  // 0x03af  ί
  9,30,90,13,3,255,2,169,0,7,252,0,11,244,0,15,224,0,31,192,0,47,64,0,26,0,0,0,0,0,0,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,191,128,0,127,255,192,47,255,192,11,255,192,0,21,0,
  // 0x03b0  ΰ
  255,
  // 0x03b1  α
  21,22,132,23,2,255,0,1,64,0,0,0,0,191,253,7,240,0,3,255,255,203,240,0,15,255,255,255,240,0,47,248,1,255,240,0,63,208,0,127,240,0,127,192,0,47,240,0,191,64,0,31,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,255,0,0,15,240,0,191,64,0,31,240,0,191,128,0,47,240,0,63,208,0,63,240,0,47,244,1,255,244,0,15,255,255,251,255,64,3,255,255,195,255,128,0,191,254,1,255,64,0,1,64,0,20,0,
  // 0x03b2  β
  18,38,190,23,3,247,0,0,80,0,0,0,127,255,128,0,3,255,255,248,0,15,255,255,253,0,63,244,7,255,0,127,192,0,255,64,191,128,0,191,128,255,0,0,127,128,255,0,0,127,128,255,0,0,127,128,255,0,0,255,0,255,0,1,254,0,255,1,91,248,0,255,11,255,144,0,255,11,255,144,0,255,11,255,253,0,255,0,1,255,64,255,0,0,63,192,255,0,0,47,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,255,0,0,63,208,255,224,1,255,192,255,255,255,255,0,255,255,255,253,0,255,111,255,224,0,255,1,84,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,
  // 0x03b3  γ
  19,28,140,20,0,248,255,0,0,7,244,127,128,0,7,244,63,192,0,7,244,63,192,0,11,244,31,224,0,11,240,15,240,0,15,240,11,240,0,15,240,7,244,0,15,240,3,252,0,31,208,2,252,0,47,192,1,253,0,63,192,0,255,0,63,128,0,191,0,191,0,0,63,64,254,0,0,63,195,252,0,0,47,199,248,0,0,15,239,240,0,0,15,255,192,0,0,7,255,64,0,0,3,253,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,2,252,0,0,
  // 0x03b4  δ
  19,30,150,22,1,255,0,0,5,0,0,0,2,255,253,0,0,31,255,255,208,0,127,255,255,240,0,255,64,11,224,1,254,0,0,192,1,254,0,0,0,1,255,0,0,0,0,255,128,0,0,0,127,240,0,0,0,31,254,0,0,0,7,255,224,0,0,47,255,252,0,0,255,231,255,0,3,254,0,255,192,15,244,0,47,240,47,224,0,15,244,63,192,0,7,248,63,192,0,3,252,127,128,0,3,252,127,128,0,3,252,127,128,0,3,252,127,192,0,3,252,63,208,0,11,248,47,240,0,15,244,15,253,0,127,224,7,255,255,255,192,1,255,255,255,0,0,47,255,228,0,0,0,84,0,0,
  // 0x03b5  ε
  16,22,88,18,1,255,0,0,80,0,0,191,255,228,3,255,255,253,15,255,255,252,31,240,0,120,47,208,0,0,47,192,0,0,31,208,0,0,15,244,0,0,3,255,254,0,0,191,255,0,3,255,255,0,31,249,0,0,63,192,0,0,127,128,0,0,127,128,0,0,127,192,0,0,63,224,0,28,47,255,255,252,11,255,255,252,1,191,255,244,0,1,84,0,
  // 0x03b6  ζ
  15,36,144,17,2,248,63,255,255,252,63,255,255,252,63,255,255,252,0,0,15,244,0,0,47,224,0,0,127,128,0,0,255,0,0,3,252,0,0,11,244,0,0,47,224,0,0,127,192,0,0,255,0,0,3,253,0,0,7,252,0,0,15,240,0,0,47,208,0,0,63,192,0,0,127,128,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,128,0,0,191,224,0,0,63,254,0,0,31,255,249,0,3,255,255,208,0,111,255,244,0,1,191,252,0,0,7,252,0,0,3,252,0,0,3,252,0,0,3,248,0,0,7,244,0,0,15,240,0,0,5,64,
  // 0x03b7  η
  17,30,150,23,3,247,0,0,20,0,0,253,11,255,224,0,253,63,255,252,0,255,255,255,255,0,255,248,2,255,64,255,208,0,191,128,255,192,0,63,192,255,64,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,
  // 0x03b8  θ
  18,30,150,22,2,255,0,0,80,0,0,0,47,255,128,0,1,255,255,244,0,7,255,255,252,0,15,248,2,255,0,31,224,0,191,64,63,192,0,63,192,63,128,0,47,192,127,64,0,31,224,191,64,0,15,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,255,255,255,240,255,255,255,255,240,255,255,255,255,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,191,0,0,15,240,127,64,0,31,224,63,128,0,47,208,63,192,0,63,192,31,224,0,127,128,15,248,1,255,0,3,255,255,253,0,1,255,255,248,0,0,47,255,144,0,0,0,84,0,0,
  // 0x03b9  ι
  9,21,63,13,3,255,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,191,128,0,127,255,192,47,255,192,11,255,192,0,21,0,
  // 0x03ba  κ
  17,20,100,21,3,0,255,0,0,255,64,255,0,3,254,0,255,0,11,252,0,255,0,47,240,0,255,0,127,192,0,255,1,255,64,0,255,3,253,0,0,255,15,248,0,0,255,47,224,0,0,255,191,224,0,0,255,255,244,0,0,255,251,252,0,0,255,210,255,0,0,255,0,255,128,0,255,0,63,208,0,255,0,31,240,0,255,0,11,252,0,255,0,3,254,0,255,0,0,255,64,255,0,0,127,192,
  // 0x03bb  λ
  20,30,150,20,0,255,5,0,0,0,0,255,248,0,0,0,255,255,0,0,0,255,255,192,0,0,0,127,224,0,0,0,15,240,0,0,0,11,244,0,0,0,3,252,0,0,0,2,252,0,0,0,2,254,0,0,0,3,255,0,0,0,7,255,64,0,0,11,255,128,0,0,15,239,192,0,0,31,207,208,0,0,63,143,240,0,0,63,75,240,0,0,191,7,248,0,0,255,3,252,0,1,253,2,253,0,2,252,0,254,0,3,252,0,255,0,7,248,0,191,64,15,240,0,63,192,15,240,0,63,208,47,224,0,31,224,63,208,0,15,255,63,192,0,11,255,191,128,0,3,255,0,0,0,0,84,
  // 0x03bc  μ
  20,29,145,24,3,247,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,64,0,127,192,255,128,0,255,208,255,224,7,255,224,255,255,255,239,255,255,255,255,79,255,255,63,253,3,255,255,1,64,0,20,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,
  // 0x03bd  ν
  19,20,100,20,0,0,255,0,0,7,244,127,128,0,7,244,63,192,0,7,244,63,192,0,11,244,31,224,0,11,240,15,240,0,15,240,11,240,0,15,240,7,244,0,15,240,3,252,0,31,224,2,252,0,47,192,1,253,0,63,192,0,255,0,63,128,0,191,0,191,0,0,63,64,254,0,0,63,195,252,0,0,47,199,248,0,0,15,239,240,0,0,15,255,192,0,0,7,255,64,0,0,3,253,0,0,
  // 0x03be  ξ
  16,36,144,19,2,248,63,255,255,253,63,255,255,253,63,255,255,168,0,191,64,0,7,244,0,0,15,224,0,0,47,192,0,0,63,192,0,0,63,192,0,0,47,208,0,0,31,240,0,0,11,254,80,0,1,255,255,248,0,127,255,248,3,255,255,248,15,248,0,0,63,208,0,0,127,128,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,128,0,0,191,208,0,0,63,254,0,0,15,255,249,0,2,255,255,224,0,47,255,248,0,0,127,252,0,0,3,252,0,0,3,252,0,0,3,252,0,0,3,252,0,0,7,244,0,0,15,240,0,0,5,80,
  // 0x03bf  ο
  19,22,110,23,2,255,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x03c0  π
  25,21,147,25,0,255,127,255,255,255,255,255,0,127,255,255,255,255,255,64,127,255,255,255,255,255,64,0,127,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,64,0,0,63,128,0,191,128,0,0,63,128,0,127,255,0,0,63,128,0,63,255,0,0,63,128,0,15,254,0,0,0,0,0,0,80,0,
  // 0x03c1  ρ
  19,30,150,22,2,247,0,0,80,0,0,0,47,255,208,0,1,255,255,252,0,7,255,255,255,0,15,248,1,255,192,47,240,0,63,208,63,192,0,31,224,63,192,0,15,240,127,128,0,15,240,127,128,0,11,244,127,64,0,11,244,127,64,0,11,244,127,64,0,11,244,127,64,0,15,244,127,64,0,15,240,127,64,0,31,240,127,128,0,63,208,127,244,1,255,192,127,255,255,255,0,127,255,255,252,0,127,95,255,208,0,127,64,84,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,
  // 0x03c2  ς
  15,29,116,18,2,248,0,0,20,0,0,47,255,228,1,255,255,248,11,255,255,244,31,249,1,176,63,224,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,128,0,0,127,192,0,0,63,240,0,0,31,254,0,0,11,255,249,0,1,255,255,208,0,47,255,244,0,0,127,252,0,0,7,252,0,0,3,252,0,0,3,252,0,0,3,248,0,0,7,244,0,0,15,240,0,0,5,64,
  // 0x03c3  σ
  20,21,105,23,2,255,0,6,255,255,255,0,191,255,255,255,7,255,255,255,255,15,254,64,254,0,63,240,0,63,128,127,192,0,47,192,191,128,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,11,240,255,0,0,15,240,255,0,0,15,240,191,64,0,15,240,127,128,0,47,224,63,208,0,127,192,47,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,127,255,208,0,0,1,84,0,0,
  // 0x03c4  τ
  18,21,105,19,0,255,127,255,255,255,208,127,255,255,255,208,127,255,255,255,208,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,252,0,0,0,7,255,255,64,0,2,255,255,64,0,0,191,255,0,0,0,1,80,0,
  // 0x03c5  υ
  17,21,105,23,3,255,255,0,0,255,0,255,0,0,255,0,255,0,0,191,64,255,0,0,127,128,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,128,255,0,0,255,64,191,128,1,255,0,127,208,11,253,0,63,255,255,248,0,15,255,255,224,0,2,255,255,64,0,0,5,64,0,0,
  // 0x03c6  φ
  24,37,222,28,2,247,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,7,255,255,144,0,0,191,255,255,253,0,3,255,255,255,255,128,15,254,15,241,191,224,47,240,15,240,31,244,63,192,15,240,7,252,191,128,15,240,3,253,255,64,15,240,1,254,255,0,15,240,1,255,255,0,15,240,0,255,255,0,15,240,0,255,255,0,15,240,0,255,255,64,15,240,1,254,191,128,15,240,3,253,63,192,15,240,7,252,47,240,15,240,15,244,15,253,15,240,191,240,3,255,255,255,255,192,0,191,255,255,254,0,0,11,255,255,208,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,224,0,0,
  // 0x03c7  χ
  21,29,174,22,1,247,255,64,0,0,63,192,255,224,0,0,191,64,255,240,0,1,254,0,11,252,0,3,252,0,3,253,0,7,248,0,1,255,0,15,240,0,0,255,64,31,208,0,0,127,192,63,192,0,0,63,192,191,0,0,0,31,224,254,0,0,0,15,242,252,0,0,0,7,255,244,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,255,128,0,0,0,0,255,128,0,0,0,2,255,192,0,0,0,7,255,224,0,0,0,15,255,240,0,0,0,47,215,248,0,0,0,63,131,252,0,0,0,255,1,254,0,0,1,253,0,255,0,0,3,252,0,191,128,0,11,244,0,63,208,0,31,224,0,47,249,64,63,192,0,15,255,192,191,64,0,3,255,192,255,0,0,0,191,128,
  // 0x03c8  ψ
  23,37,222,29,3,247,0,0,47,192,0,0,0,0,47,192,0,0,0,0,47,192,0,0,0,0,47,192,0,0,0,0,47,192,0,0,0,0,47,192,0,0,0,0,47,192,0,0,0,0,47,192,0,0,254,0,47,192,11,240,254,0,47,192,11,240,254,0,47,192,7,244,254,0,47,192,3,248,254,0,47,192,3,252,254,0,47,192,3,252,254,0,47,192,3,252,254,0,47,192,2,252,254,0,47,192,2,252,254,0,47,192,2,252,254,0,47,192,2,252,254,0,47,192,2,252,255,0,47,192,3,252,255,0,47,192,3,248,191,64,47,192,11,244,63,192,47,192,47,240,47,244,47,193,255,208,15,255,255,255,255,64,3,255,255,255,253,0,0,111,255,255,144,0,0,0,47,208,0,0,0,0,47,192,0,0,0,0,47,192,0,0,0,0,47,192,0,0,0,0,47,192,0,0,0,0,47,192,0,0,0,0,47,192,0,0,0,0,47,192,0,0,0,0,31,192,0,0,
  // 0x03c9  ω
  26,21,147,30,2,255,2,252,0,0,2,252,0,7,244,0,0,0,254,0,15,240,0,0,0,191,64,31,208,0,0,0,63,128,63,192,0,0,0,47,192,63,128,0,0,0,31,208,127,64,0,84,0,15,224,191,64,2,252,0,15,240,191,0,2,252,0,15,240,191,0,2,252,0,15,240,191,0,2,252,0,15,240,191,0,2,252,0,15,240,191,64,2,252,0,15,240,127,64,3,252,0,15,224,63,128,3,252,0,31,208,63,192,7,254,0,63,192,31,240,15,239,64,191,128,15,255,255,159,255,255,0,3,255,255,11,255,253,0,0,191,248,2,255,240,0,0,5,64,0,5,0,0,
  // 0x03ca  ϊ
  255,
  // 0x03cb  ϋ
  255,
  // 0x03cc  ό
  19,30,150,23,2,255,0,0,10,164,0,0,0,31,240,0,0,0,47,208,0,0,0,63,192,0,0,0,63,0,0,0,0,190,0,0,0,0,104,0,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x03cd  ύ
  17,30,150,23,3,255,0,0,106,128,0,0,0,255,128,0,0,0,255,0,0,0,1,253,0,0,0,2,248,0,0,0,3,240,0,0,0,2,144,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,255,0,255,0,0,255,0,255,0,0,191,64,255,0,0,127,128,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,128,255,0,0,255,64,191,128,1,255,0,127,208,11,253,0,63,255,255,248,0,15,255,255,224,0,2,255,255,64,0,0,5,64,0,0,
  // 0x03ce  ώ
  26,30,210,30,2,255,0,0,0,10,164,0,0,0,0,0,31,240,0,0,0,0,0,47,208,0,0,0,0,0,63,128,0,0,0,0,0,127,0,0,0,0,0,0,189,0,0,0,0,0,0,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,252,0,0,2,252,0,7,244,0,0,0,254,0,15,240,0,0,0,191,64,31,208,0,0,0,63,128,63,192,0,0,0,47,192,63,128,0,0,0,31,208,127,64,0,84,0,15,224,191,64,2,252,0,15,240,191,0,2,252,0,15,240,191,0,2,252,0,15,240,191,0,2,252,0,15,240,191,0,2,252,0,15,240,191,64,2,252,0,15,240,127,64,3,252,0,15,224,63,128,3,252,0,31,208,63,192,7,254,0,63,192,31,240,15,239,64,191,128,15,255,255,159,255,255,0,3,255,255,11,255,253,0,0,191,248,2,255,240,0,0,5,64,0,5,0,0,
};

#endif // HAS_GRAPHICAL_TFT
