/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Cyrillic 37pt, capital 'A' height: 27px, width: 100%, range: 0x0401-0x0491, glyphs: 74
extern const uint8_t NotoSans_Medium_Cyrillic_27[10855] = {
  130,27,1,4,145,4,35,247, // unifont_t
  // 0x0401  Ё
  16,33,132,21,3,0,3,244,15,208,3,248,15,224,3,248,15,224,1,160,6,128,0,0,0,0,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x0402  Ђ
  255,
  // 0x0403  Ѓ
  255,
  // 0x0404  Є
  21,28,168,24,2,255,0,0,26,254,144,0,0,7,255,255,254,64,0,47,255,255,255,128,0,255,255,175,255,64,3,255,208,0,47,0,11,253,0,0,0,0,15,244,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,128,0,0,0,0,191,149,85,85,64,0,191,255,255,255,192,0,255,255,255,255,192,0,255,255,255,255,192,0,191,128,0,0,0,0,191,128,0,0,0,0,127,192,0,0,0,0,63,192,0,0,0,0,63,208,0,0,0,0,47,240,0,0,0,0,15,248,0,0,0,0,11,255,0,0,0,0,3,255,228,0,111,0,0,255,255,255,255,0,0,47,255,255,255,0,0,2,255,255,249,0,0,0,1,84,0,0,
  // 0x0405  Ѕ
  255,
  // 0x0406  І
  11,27,81,13,1,0,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,
  // 0x0407  Ї
  11,33,99,13,1,0,190,1,248,255,3,252,255,2,252,40,0,160,0,0,0,0,0,0,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,
  // 0x0408  Ј
  255,
  // 0x0409  Љ
  255,
  // 0x040a  Њ
  255,
  // 0x040b  Ћ
  255,
  // 0x040c  Ќ
  255,
  // 0x040d  Ѝ
  255,
  // 0x040e  Ў
  255,
  // 0x040f  Џ
  255,
  // 0x0410  А
  24,27,162,24,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x0411  Б
  18,27,135,23,3,0,21,85,85,85,0,127,255,255,255,128,127,255,255,255,128,127,255,255,255,128,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,234,149,0,0,127,255,255,244,0,127,255,255,254,0,127,255,255,255,192,127,128,1,255,208,127,128,0,47,240,127,128,0,15,240,127,128,0,15,240,127,128,0,15,240,127,128,0,15,240,127,128,0,31,240,127,128,0,127,224,127,149,91,255,192,127,255,255,255,64,127,255,255,252,0,127,255,254,128,0,
  // 0x0412  В
  20,27,135,24,3,0,21,85,84,0,0,127,255,255,248,0,127,255,255,255,64,127,255,255,255,208,127,128,1,191,240,127,128,0,31,244,127,128,0,15,244,127,128,0,11,244,127,128,0,11,244,127,128,0,15,240,127,128,0,47,224,127,149,86,255,128,127,255,255,253,0,127,255,255,249,0,127,255,255,255,192,127,128,0,127,240,127,128,0,15,248,127,128,0,3,252,127,128,0,3,252,127,128,0,3,253,127,128,0,3,252,127,128,0,11,252,127,128,0,31,248,127,149,86,255,240,127,255,255,255,208,127,255,255,255,0,127,255,255,228,0,
  // 0x0413  Г
  16,27,108,20,3,0,21,85,85,85,127,255,255,255,127,255,255,255,127,255,255,255,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,
  // 0x0414  Д
  26,35,245,26,0,248,0,0,21,85,85,80,0,0,0,63,255,255,240,0,0,0,63,255,255,240,0,0,0,127,255,255,240,0,0,0,127,64,15,240,0,0,0,191,0,15,240,0,0,0,255,0,15,240,0,0,0,255,0,15,240,0,0,0,254,0,15,240,0,0,1,253,0,15,240,0,0,2,253,0,15,240,0,0,3,252,0,15,240,0,0,3,248,0,15,240,0,0,11,244,0,15,240,0,0,15,240,0,15,240,0,0,15,240,0,15,240,0,0,47,208,0,15,240,0,0,63,192,0,15,240,0,0,127,128,0,15,240,0,0,255,64,0,15,240,0,0,255,0,0,15,240,0,2,253,0,0,15,240,0,3,252,0,0,15,240,0,95,253,85,85,95,249,80,255,255,255,255,255,255,224,255,255,255,255,255,255,224,255,255,255,255,255,255,224,255,0,0,0,0,31,224,255,0,0,0,0,31,224,255,0,0,0,0,31,224,255,0,0,0,0,31,224,255,0,0,0,0,31,224,255,0,0,0,0,31,224,255,0,0,0,0,31,224,0,0,0,0,0,0,0,
  // 0x0415  Е
  16,27,108,21,3,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x0416  Ж
  32,27,216,33,0,0,21,64,0,5,80,0,0,85,63,208,0,11,240,0,3,253,15,240,0,11,240,0,11,248,7,252,0,11,240,0,31,240,2,254,0,11,240,0,63,192,0,255,64,11,240,0,255,64,0,63,192,11,240,2,254,0,0,31,240,11,240,7,252,0,0,7,248,11,240,15,240,0,0,2,253,11,240,63,208,0,0,0,255,11,240,191,64,0,0,0,63,203,241,254,0,0,0,0,31,235,247,252,0,0,0,0,15,255,255,244,0,0,0,0,47,235,247,252,0,0,0,0,127,203,241,255,0,0,0,0,255,75,240,191,128,0,0,3,254,11,240,63,208,0,0,11,252,11,240,15,240,0,0,31,240,11,240,7,252,0,0,63,208,11,240,2,254,0,0,255,128,11,240,0,255,64,2,255,0,11,240,0,127,192,7,252,0,11,240,0,47,240,15,244,0,11,240,0,15,248,63,224,0,11,240,0,3,253,191,192,0,11,240,0,1,255,
  // 0x0417  З
  20,28,140,22,1,255,0,6,170,144,0,2,255,255,254,0,47,255,255,255,192,63,254,154,255,240,31,128,0,47,244,4,0,0,11,252,0,0,0,3,252,0,0,0,3,252,0,0,0,7,248,0,0,0,15,244,0,0,0,127,224,0,85,91,255,128,0,255,255,248,0,0,255,255,228,0,0,255,255,255,128,0,0,1,191,240,0,0,0,15,248,0,0,0,3,252,0,0,0,2,253,0,0,0,2,254,0,0,0,2,253,0,0,0,3,252,0,0,0,15,252,126,64,0,127,244,127,255,255,255,224,127,255,255,255,64,27,255,255,244,0,0,5,84,0,0,
  // 0x0418  И
  23,27,162,29,3,0,21,0,0,0,5,80,127,0,0,0,47,248,127,0,0,0,127,248,127,0,0,0,255,248,127,0,0,2,255,248,127,0,0,7,255,248,127,0,0,15,247,248,127,0,0,47,227,248,127,0,0,63,195,248,127,0,0,255,67,248,127,0,1,255,3,248,127,0,3,252,3,248,127,0,15,248,3,248,127,0,31,240,3,248,127,0,63,192,3,248,127,0,191,128,3,248,127,1,255,0,3,248,127,3,253,0,3,248,127,11,248,0,3,248,127,31,240,0,3,248,127,63,208,0,3,248,127,191,128,0,3,248,127,255,0,0,3,248,127,253,0,0,3,248,127,252,0,0,3,248,127,240,0,0,3,248,127,208,0,0,3,248,
  // 0x0419  Й
  23,35,210,29,3,0,0,127,0,0,253,0,0,63,64,1,253,0,0,63,192,3,252,0,0,31,249,111,244,0,0,11,255,255,224,0,0,1,191,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,5,80,127,0,0,0,47,248,127,0,0,0,127,248,127,0,0,0,255,248,127,0,0,2,255,248,127,0,0,7,255,248,127,0,0,15,247,248,127,0,0,47,227,248,127,0,0,63,195,248,127,0,0,255,67,248,127,0,1,255,3,248,127,0,3,252,3,248,127,0,15,248,3,248,127,0,31,240,3,248,127,0,63,192,3,248,127,0,191,128,3,248,127,1,255,0,3,248,127,3,253,0,3,248,127,11,248,0,3,248,127,31,240,0,3,248,127,63,208,0,3,248,127,191,128,0,3,248,127,255,0,0,3,248,127,253,0,0,3,248,127,252,0,0,3,248,127,240,0,0,3,248,127,208,0,0,3,248,
  // 0x041a  К
  20,27,135,23,3,0,21,0,0,1,85,127,128,0,7,252,127,128,0,15,244,127,128,0,63,208,127,128,0,255,128,127,128,2,254,0,127,128,11,252,0,127,128,31,240,0,127,128,127,192,0,127,128,255,64,0,127,131,253,0,0,127,143,248,0,0,127,175,240,0,0,127,255,208,0,0,127,175,240,0,0,127,143,252,0,0,127,131,254,0,0,127,128,255,64,0,127,128,127,208,0,127,128,47,240,0,127,128,11,252,0,127,128,3,255,0,127,128,0,255,128,127,128,0,63,224,127,128,0,31,244,127,128,0,7,252,127,128,0,2,255,
  // 0x041b  Л
  23,28,168,27,0,255,0,0,85,85,85,84,0,0,255,255,255,252,0,1,255,255,255,252,0,1,255,255,255,252,0,2,252,0,3,252,0,2,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,248,0,3,252,0,3,248,0,3,252,0,7,244,0,3,252,0,11,244,0,3,252,0,11,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,0,15,224,0,3,252,0,31,224,0,3,252,0,31,208,0,3,252,0,47,192,0,3,252,0,63,192,0,3,252,0,63,192,0,3,252,0,127,128,0,3,252,0,255,64,0,3,252,2,255,0,0,3,252,255,253,0,0,3,252,255,252,0,0,3,252,255,224,0,0,3,252,21,0,0,0,0,0,
  // 0x041c  М
  28,27,189,34,3,0,21,80,0,0,0,5,84,127,248,0,0,0,47,253,127,252,0,0,0,63,253,127,253,0,0,0,127,253,127,254,0,0,0,191,253,127,191,0,0,0,254,253,127,127,64,0,1,253,253,127,63,128,0,3,249,253,127,47,192,0,3,241,253,127,15,208,0,11,241,253,127,15,240,0,15,225,253,127,7,240,0,31,193,253,127,3,244,0,47,193,253,127,3,252,0,63,65,253,127,1,252,0,127,1,253,127,0,254,0,190,1,253,127,0,191,0,253,1,253,127,0,127,65,252,1,253,127,0,63,131,248,1,253,127,0,47,195,240,1,253,127,0,31,219,240,1,253,127,0,15,239,208,1,253,127,0,11,255,192,1,253,127,0,3,255,128,1,253,127,0,3,255,64,1,253,127,0,2,255,0,1,253,127,0,0,254,0,1,253,
  // 0x041d  Н
  21,27,162,28,3,0,21,0,0,0,21,64,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,149,85,85,127,192,127,255,255,255,255,192,127,255,255,255,255,192,127,255,255,255,255,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,
  // 0x041e  О
  25,28,196,29,2,255,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x041f  П
  21,27,162,27,3,0,21,85,85,85,85,64,127,255,255,255,255,128,127,255,255,255,255,128,127,255,255,255,255,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,
  // 0x0420  Р
  18,27,135,23,3,0,21,85,80,0,0,127,255,255,208,0,127,255,255,253,0,127,255,255,255,0,127,128,6,255,192,127,128,0,127,208,127,128,0,47,224,127,128,0,31,224,127,128,0,31,240,127,128,0,31,224,127,128,0,47,224,127,128,0,63,208,127,128,1,255,192,127,149,111,255,64,127,255,255,253,0,127,255,255,240,0,127,255,250,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,
  // 0x0421  С
  20,28,140,23,2,255,0,0,26,234,64,0,7,255,255,253,0,47,255,255,255,0,255,255,175,253,3,255,208,0,108,11,254,0,0,0,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,127,192,0,0,0,127,192,0,0,0,191,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,128,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,208,0,0,0,47,240,0,0,0,15,248,0,0,0,11,254,0,0,0,3,255,228,1,188,0,255,255,255,252,0,47,255,255,252,0,2,255,255,244,0,0,5,84,0,
  // 0x0422  Т
  21,27,162,21,0,0,21,85,85,85,85,0,191,255,255,255,255,64,191,255,255,255,255,64,191,255,255,255,255,64,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,
  // 0x0423  У
  22,28,168,24,1,255,85,0,0,0,5,80,255,0,0,0,15,240,191,128,0,0,31,224,63,192,0,0,63,192,47,224,0,0,127,192,15,240,0,0,255,64,11,248,0,0,255,0,3,252,0,2,253,0,2,254,0,3,252,0,0,255,0,7,248,0,0,191,128,15,240,0,0,63,192,31,224,0,0,47,224,63,192,0,0,15,240,63,192,0,0,11,248,191,64,0,0,3,252,255,0,0,0,2,255,253,0,0,0,0,255,252,0,0,0,0,191,248,0,0,0,0,63,240,0,0,0,0,63,224,0,0,0,0,191,192,0,0,0,1,255,128,0,0,101,91,255,0,0,0,127,255,252,0,0,0,127,255,244,0,0,0,127,255,128,0,0,0,1,80,0,0,0,0,
  // 0x0424  Ф
  27,28,196,30,2,255,0,0,2,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,87,254,80,0,0,0,47,255,255,255,128,0,1,255,255,255,255,248,0,11,255,255,255,255,255,0,31,253,3,252,6,255,192,63,224,3,252,0,127,208,191,192,3,252,0,31,240,255,64,3,252,0,15,240,255,0,3,252,0,11,244,255,0,3,252,0,7,244,255,0,3,252,0,7,248,255,0,3,252,0,7,244,255,0,3,252,0,11,244,191,64,3,252,0,15,240,127,192,3,252,0,47,224,63,240,3,252,0,191,192,15,254,67,252,7,255,64,7,255,255,255,255,254,0,0,191,255,255,255,244,0,0,11,255,255,254,64,0,0,0,7,253,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,3,252,0,0,0,0,0,1,84,0,0,0,
  // 0x0425  Х
  22,27,162,23,0,0,21,64,0,0,5,80,47,224,0,0,63,192,15,244,0,0,191,128,7,252,0,0,255,0,3,254,0,3,253,0,0,255,0,7,248,0,0,191,128,15,240,0,0,63,208,47,208,0,0,15,240,127,128,0,0,11,248,255,0,0,0,3,254,253,0,0,0,1,255,252,0,0,0,0,191,240,0,0,0,0,127,240,0,0,0,0,255,244,0,0,0,2,255,252,0,0,0,3,254,254,0,0,0,15,240,255,64,0,0,31,224,127,192,0,0,63,192,47,224,0,0,191,64,15,244,0,1,255,0,7,252,0,3,252,0,3,254,0,11,248,0,0,255,0,31,240,0,0,191,192,63,208,0,0,63,208,191,128,0,0,31,240,
  // 0x0426  Ц
  24,35,210,28,3,248,21,0,0,0,21,64,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,213,85,85,191,213,127,255,255,255,255,255,127,255,255,255,255,255,127,255,255,255,255,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,255,0,0,0,0,0,0,
  // 0x0427  Ч
  21,27,162,26,2,0,21,64,0,0,21,64,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,128,0,0,127,128,127,192,0,0,127,128,63,192,0,0,127,128,63,224,0,2,255,128,47,254,90,255,255,128,15,255,255,255,255,128,3,255,255,254,191,128,0,111,255,144,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,0,0,0,0,127,128,
  // 0x0428  Ш
  33,27,243,39,3,0,21,0,0,5,80,0,0,85,0,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,128,0,11,244,0,0,191,64,127,213,85,95,249,85,85,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,127,255,255,255,255,255,255,255,64,
  // 0x0429  Щ
  36,35,59,39,3,248,21,0,0,5,80,0,0,85,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,128,0,15,240,0,0,255,0,127,213,85,95,249,85,86,255,84,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,127,255,255,255,255,255,255,255,253,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,0,0,
  // 0x042a  Ъ
  24,27,162,26,0,0,85,85,80,0,0,0,255,255,244,0,0,0,255,255,244,0,0,0,255,255,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,244,0,0,0,0,11,254,169,80,0,0,11,255,255,254,0,0,11,255,255,255,224,0,11,255,255,255,248,0,11,244,0,31,253,0,11,244,0,2,254,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,0,255,0,11,244,0,2,255,0,11,244,0,7,253,0,11,249,85,191,252,0,11,255,255,255,240,0,11,255,255,255,128,0,11,255,255,232,0,
  // 0x042b  Ы
  26,27,189,32,3,0,21,0,0,0,0,5,80,127,128,0,0,0,31,240,127,128,0,0,0,31,240,127,128,0,0,0,31,240,127,128,0,0,0,31,240,127,128,0,0,0,31,240,127,128,0,0,0,31,240,127,128,0,0,0,31,240,127,128,0,0,0,31,240,127,128,0,0,0,31,240,127,128,0,0,0,31,240,127,234,148,0,0,31,240,127,255,255,224,0,31,240,127,255,255,253,0,31,240,127,255,255,255,64,31,240,127,128,1,255,192,31,240,127,128,0,63,208,31,240,127,128,0,31,224,31,240,127,128,0,15,240,31,240,127,128,0,15,240,31,240,127,128,0,31,240,31,240,127,128,0,63,224,31,240,127,128,0,191,208,31,240,127,149,91,255,128,31,240,127,255,255,255,0,31,240,127,255,255,248,0,31,240,127,255,254,64,0,31,240,
  // 0x042c  Ь
  19,27,135,24,3,0,21,0,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,234,165,0,0,127,255,255,248,0,127,255,255,255,64,127,255,255,255,208,127,128,0,191,240,127,128,0,15,244,127,128,0,7,248,127,128,0,7,252,127,128,0,3,252,127,128,0,7,252,127,128,0,15,248,127,128,0,47,240,127,149,90,255,224,127,255,255,255,192,127,255,255,254,0,127,255,255,144,0,
  // 0x042d  Э
  21,28,168,24,1,255,1,107,233,0,0,0,111,255,255,244,0,0,191,255,255,254,0,0,63,254,191,255,192,0,45,0,1,255,240,0,0,0,0,47,248,0,0,0,0,11,252,0,0,0,0,3,253,0,0,0,0,1,255,0,0,0,0,0,255,0,0,0,0,0,255,64,0,85,85,85,255,64,0,255,255,255,255,64,0,255,255,255,255,64,0,255,255,255,255,64,0,0,0,0,255,64,0,0,0,0,255,64,0,0,0,0,255,0,0,0,0,1,255,0,0,0,0,2,254,0,0,0,0,7,252,0,0,0,0,15,252,0,0,0,0,127,240,0,185,64,27,255,208,0,191,255,255,255,64,0,191,255,255,252,0,0,47,255,255,144,0,0,0,21,80,0,0,0,
  // 0x042e  Ю
  34,28,252,39,3,255,21,0,0,0,6,190,144,0,0,127,128,0,0,191,255,254,0,0,127,128,0,7,255,255,255,208,0,127,128,0,31,255,234,255,248,0,127,128,0,63,244,0,31,253,0,127,128,0,191,192,0,3,255,0,127,128,0,255,64,0,0,255,64,127,128,2,254,0,0,0,127,192,127,128,3,253,0,0,0,63,192,127,128,3,252,0,0,0,63,208,127,128,7,252,0,0,0,47,224,127,149,91,248,0,0,0,31,224,127,255,255,248,0,0,0,31,240,127,255,255,248,0,0,0,31,240,127,255,255,248,0,0,0,31,240,127,128,11,248,0,0,0,31,240,127,128,7,248,0,0,0,31,224,127,128,7,252,0,0,0,47,224,127,128,3,252,0,0,0,63,208,127,128,3,253,0,0,0,63,192,127,128,1,255,0,0,0,191,128,127,128,0,255,128,0,1,255,64,127,128,0,127,224,0,7,254,0,127,128,0,63,253,0,111,252,0,127,128,0,15,255,255,255,240,0,127,128,0,2,255,255,255,192,0,127,128,0,0,47,255,249,0,0,0,0,0,0,0,85,0,0,0,
  // 0x042f  Я
  20,27,135,24,1,0,0,0,21,85,84,0,11,255,255,253,0,191,255,255,253,2,255,255,255,253,7,255,64,2,253,15,252,0,2,253,15,240,0,2,253,15,240,0,2,253,15,240,0,2,253,15,240,0,2,253,15,244,0,2,253,11,252,0,2,253,3,255,144,2,253,1,255,255,255,253,0,63,255,255,253,0,7,255,255,253,0,11,249,86,253,0,31,240,2,253,0,63,208,2,253,0,191,128,2,253,1,255,0,2,253,3,254,0,2,253,11,252,0,2,253,15,244,0,2,253,63,224,0,2,253,191,192,0,2,253,255,64,0,2,253,
  // 0x0430  а
  18,22,110,21,1,255,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x0431  б
  19,29,145,22,2,255,0,0,1,111,240,0,1,191,255,240,0,31,255,255,240,0,255,255,250,80,3,255,228,0,0,11,253,0,0,0,15,240,0,0,0,47,208,0,0,0,63,192,0,0,0,127,128,90,64,0,191,71,255,248,0,191,47,255,255,0,255,191,171,255,192,255,248,0,127,224,255,208,0,31,240,255,128,0,15,240,255,0,0,15,244,255,0,0,11,244,255,0,0,11,244,255,64,0,11,244,191,64,0,11,244,127,192,0,15,240,63,192,0,15,240,47,240,0,63,224,15,253,0,255,192,7,255,255,255,64,1,255,255,253,0,0,47,255,224,0,0,0,84,0,0,
  // 0x0432  в
  17,20,100,22,3,0,255,255,254,128,0,255,255,255,248,0,255,255,255,255,0,255,0,6,255,64,255,0,0,191,128,255,0,0,127,128,255,0,0,191,64,255,0,2,255,0,255,255,255,248,0,255,255,255,208,0,255,255,255,253,0,255,0,6,255,64,255,0,0,127,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,1,255,128,255,255,255,255,0,255,255,255,252,0,255,255,255,144,0,
  // 0x0433  г
  13,20,80,17,3,0,255,255,255,128,255,255,255,128,255,255,255,128,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,
  // 0x0434  д
  22,27,162,22,0,249,0,2,255,255,248,0,0,3,255,255,252,0,0,3,255,255,252,0,0,3,248,3,252,0,0,3,244,3,252,0,0,7,244,3,252,0,0,11,240,3,252,0,0,11,240,3,252,0,0,15,240,3,252,0,0,31,208,3,252,0,0,47,192,3,252,0,0,63,192,3,252,0,0,127,128,3,252,0,0,255,0,3,252,0,1,254,0,3,252,0,3,252,0,3,252,0,11,248,0,3,252,0,127,255,255,255,255,224,127,255,255,255,255,224,127,255,255,255,255,224,127,64,0,0,15,224,127,64,0,0,15,224,127,64,0,0,15,224,127,64,0,0,15,224,127,64,0,0,15,224,127,64,0,0,15,224,127,64,0,0,15,224,
  // 0x0435  е
  18,22,110,21,2,255,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x0436  ж
  29,20,160,29,0,0,63,208,0,127,64,0,255,0,15,240,0,127,64,3,252,0,7,252,0,127,64,15,244,0,1,254,0,127,64,47,208,0,0,191,64,127,64,127,128,0,0,63,208,127,64,255,0,0,0,15,240,127,67,252,0,0,0,3,252,127,79,240,0,0,0,1,254,127,111,208,0,0,0,0,191,255,255,128,0,0,0,0,255,191,191,192,0,0,0,3,253,127,95,240,0,0,0,11,248,127,75,248,0,0,0,31,224,127,66,254,0,0,0,127,192,127,64,255,64,0,0,255,0,127,64,63,192,0,3,253,0,127,64,15,240,0,15,244,0,127,64,7,252,0,47,224,0,127,64,2,254,0,191,192,0,127,64,0,191,128,
  // 0x0437  з
  16,22,88,19,1,255,0,1,64,0,27,255,255,64,127,255,255,240,63,255,255,252,30,0,7,253,0,0,0,254,0,0,0,254,0,0,1,253,0,0,11,252,0,191,255,224,0,255,255,64,0,255,255,240,0,0,27,253,0,0,1,255,0,0,0,191,0,0,0,191,0,0,0,255,180,0,7,254,191,255,255,252,191,255,255,244,47,255,255,128,0,21,64,0,
  // 0x0438  и
  19,20,100,25,3,0,255,0,0,47,244,255,0,0,63,248,255,0,0,255,248,255,0,1,255,248,255,0,3,255,248,255,0,11,243,248,255,0,31,227,248,255,0,63,195,248,255,0,191,67,248,255,1,254,3,248,255,3,252,3,248,255,11,244,3,248,255,31,224,3,248,254,63,192,3,248,254,191,64,3,248,255,255,0,3,248,255,252,0,3,248,255,244,0,3,248,255,240,0,3,248,255,192,0,3,248,
  // 0x0439  й
  19,29,145,25,3,0,1,64,0,5,64,11,240,0,47,192,7,240,0,63,128,3,253,1,255,64,2,255,255,254,0,0,127,255,244,0,0,5,169,64,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,244,255,0,0,63,248,255,0,0,255,248,255,0,1,255,248,255,0,3,255,248,255,0,11,243,248,255,0,31,227,248,255,0,63,195,248,255,0,191,67,248,255,1,254,3,248,255,3,252,3,248,255,11,244,3,248,255,31,224,3,248,254,63,192,3,248,254,191,64,3,248,255,255,0,3,248,255,252,0,3,248,255,244,0,3,248,255,240,0,3,248,255,192,0,3,248,
  // 0x043a  к
  17,20,100,21,3,0,255,0,0,255,0,255,0,3,253,0,255,0,15,244,0,255,0,47,224,0,255,0,191,128,0,255,1,255,0,0,255,7,252,0,0,255,15,240,0,0,255,63,192,0,0,255,255,64,0,0,255,127,192,0,0,255,47,240,0,0,255,11,248,0,0,255,3,254,0,0,255,0,255,64,0,255,0,63,208,0,255,0,31,240,0,255,0,7,252,0,255,0,2,255,0,255,0,0,191,192,
  // 0x043b  л
  19,21,105,22,0,255,0,15,255,255,252,0,15,255,255,252,0,15,255,255,252,0,15,224,3,252,0,31,208,3,252,0,31,208,3,252,0,31,192,3,252,0,47,192,3,252,0,47,192,3,252,0,63,192,3,252,0,63,128,3,252,0,63,64,3,252,0,127,64,3,252,0,255,0,3,252,0,255,0,3,252,2,253,0,3,252,7,252,0,3,252,255,248,0,3,252,255,240,0,3,252,255,128,0,3,252,4,0,0,0,0,
  // 0x043c  м
  23,20,120,29,3,0,255,224,0,0,63,248,255,240,0,0,127,248,255,244,0,0,191,248,255,252,0,0,255,248,255,252,0,1,255,248,254,254,0,3,251,248,254,127,0,3,243,248,254,63,64,11,243,248,254,47,128,15,211,248,254,31,192,31,195,248,254,15,208,63,131,248,254,11,240,63,3,248,254,3,240,191,3,248,254,3,248,253,3,248,254,1,253,252,3,248,254,0,255,248,3,248,254,0,191,244,3,248,254,0,63,240,3,248,254,0,63,208,3,248,254,0,31,192,3,248,
  // 0x043d  н
  18,20,100,24,3,0,255,0,0,15,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,255,255,255,240,255,255,255,255,240,255,255,255,255,240,255,85,85,95,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,
  // 0x043e  о
  19,22,110,23,2,255,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x043f  п
  18,20,100,23,3,0,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,
  // 0x0440  р
  18,30,150,23,3,247,0,0,20,0,0,253,11,255,224,0,254,63,255,252,0,255,255,255,255,0,255,244,2,255,128,255,192,0,127,192,255,128,0,63,208,255,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,240,255,64,0,47,224,255,128,0,63,208,255,208,0,127,192,255,244,2,255,128,255,255,255,255,0,255,63,255,252,0,255,11,255,224,0,255,0,20,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,
  // 0x0441  с
  15,22,88,18,2,255,0,0,84,0,0,47,255,228,2,255,255,248,11,255,255,244,31,253,1,176,63,224,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,192,0,0,63,208,0,0,47,248,0,120,15,255,255,248,2,255,255,248,0,127,255,224,0,1,84,0,
  // 0x0442  т
  17,20,100,18,1,0,255,255,255,255,128,255,255,255,255,128,255,255,255,255,128,0,15,244,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,
  // 0x0443  у
  20,29,145,20,0,247,191,64,0,3,253,127,192,0,3,252,63,192,0,11,248,47,224,0,15,240,15,240,0,31,240,15,240,0,47,208,7,248,0,63,192,3,252,0,127,128,2,253,0,191,64,0,254,0,255,0,0,255,1,254,0,0,127,66,252,0,0,63,195,252,0,0,47,199,244,0,0,15,219,240,0,0,15,239,224,0,0,7,255,208,0,0,3,255,192,0,0,2,255,128,0,0,0,255,0,0,0,0,255,0,0,0,2,253,0,0,0,3,252,0,0,0,7,248,0,0,0,31,240,0,0,21,191,224,0,0,127,255,128,0,0,127,254,0,0,0,47,224,0,0,0,
  // 0x0444  ф
  24,37,222,28,2,247,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,7,255,255,144,0,0,191,255,255,253,0,3,255,255,255,255,128,15,254,79,241,255,224,47,240,15,240,31,244,63,192,15,240,7,252,191,128,15,240,3,253,255,64,15,240,2,254,255,0,15,240,1,254,255,0,15,240,0,255,255,0,15,240,0,255,255,0,15,240,1,254,255,64,15,240,1,254,191,128,15,240,3,253,63,192,15,240,7,252,47,240,15,240,31,244,15,254,15,240,191,224,3,255,255,255,255,128,0,191,255,255,254,0,0,11,255,255,208,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,224,0,0,
  // 0x0445  х
  18,20,100,20,1,0,255,128,0,31,240,63,208,0,63,192,31,240,0,255,128,15,248,1,255,0,3,253,3,252,0,1,255,15,244,0,0,191,159,240,0,0,63,255,192,0,0,31,255,64,0,0,11,254,0,0,0,15,255,0,0,0,47,255,128,0,0,127,255,208,0,0,255,79,240,0,2,254,11,248,0,7,252,3,253,0,15,244,0,255,0,47,224,0,191,192,127,192,0,63,224,255,64,0,15,240,
  // 0x0446  ц
  21,27,162,24,3,249,255,0,0,31,208,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,0,0,31,224,0,255,255,255,255,255,64,255,255,255,255,255,64,255,255,255,255,255,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,
  // 0x0447  ч
  18,20,100,23,2,0,127,64,0,15,240,127,128,0,15,240,127,128,0,15,240,127,128,0,15,240,127,128,0,15,240,127,128,0,15,240,127,128,0,15,240,127,128,0,15,240,127,128,0,15,240,63,208,0,191,240,47,250,175,255,240,15,255,255,255,240,3,255,254,79,240,0,26,80,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,
  // 0x0448  ш
  28,20,140,34,3,0,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,0,0,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0449  щ
  31,27,216,34,3,249,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,0,0,255,0,0,255,0,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,255,255,255,255,255,255,255,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,248,
  // 0x044a  ъ
  24,20,120,26,0,0,127,255,248,0,0,0,191,255,252,0,0,0,191,255,252,0,0,0,0,7,252,0,0,0,0,3,252,0,0,0,0,3,252,0,0,0,0,3,252,0,0,0,0,3,252,0,0,0,0,3,255,255,250,0,0,3,255,255,255,240,0,3,255,255,255,252,0,3,252,0,27,254,0,3,252,0,0,255,0,3,252,0,0,255,0,3,252,0,0,255,0,3,252,0,0,255,0,3,252,0,7,254,0,3,255,255,255,252,0,3,255,255,255,240,0,3,255,255,254,64,
  // 0x044b  ы
  24,20,120,30,3,0,255,0,0,0,1,253,255,0,0,0,1,253,255,0,0,0,1,253,255,0,0,0,1,253,255,0,0,0,1,253,255,0,0,0,1,253,255,0,0,0,1,253,255,0,0,0,1,253,255,255,254,64,1,253,255,255,255,244,1,253,255,255,255,253,1,253,255,0,7,255,1,253,255,0,0,255,1,253,255,0,0,191,65,253,255,0,0,191,65,253,255,0,0,255,1,253,255,0,7,255,1,253,255,255,255,252,1,253,255,255,255,244,1,253,255,255,254,64,1,253,
  // 0x044c  ь
  18,20,100,22,3,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,255,255,144,0,255,255,255,253,0,255,255,255,255,64,255,0,5,255,192,255,0,0,63,208,255,0,0,47,208,255,0,0,47,208,255,0,0,63,192,255,0,1,255,192,255,255,255,255,0,255,255,255,253,0,255,255,255,144,0,
  // 0x044d  э
  16,22,88,18,1,255,0,20,0,0,47,255,244,0,127,255,255,64,63,255,255,208,41,0,127,240,0,0,15,248,0,0,3,252,0,0,3,252,0,0,2,253,6,170,171,253,11,255,255,254,11,255,255,254,1,85,86,253,0,0,2,253,0,0,3,252,0,0,7,252,0,0,15,244,160,0,127,240,255,255,255,192,255,255,255,0,127,255,244,0,0,84,0,0,
  // 0x044e  ю
  27,22,154,31,3,255,0,0,0,0,20,0,0,255,0,0,31,255,208,0,255,0,0,255,255,252,0,255,0,3,255,255,255,0,255,0,15,253,1,255,192,255,0,31,240,0,63,208,255,0,63,208,0,31,240,255,0,63,192,0,15,240,255,0,63,192,0,15,240,255,255,255,128,0,11,244,255,255,255,128,0,11,244,255,255,255,128,0,11,244,255,85,191,128,0,11,244,255,0,63,192,0,15,244,255,0,63,192,0,15,240,255,0,63,208,0,31,240,255,0,31,240,0,63,208,255,0,15,252,0,255,192,255,0,3,255,255,255,0,255,0,0,255,255,252,0,255,0,0,47,255,224,0,0,0,0,0,84,0,0,
  // 0x044f  я
  18,20,100,21,0,0,0,27,255,255,240,1,255,255,255,240,7,255,255,255,240,15,253,0,15,240,15,240,0,15,240,31,224,0,15,240,31,208,0,15,240,15,240,0,15,240,15,248,0,15,240,7,255,255,255,240,1,255,255,255,240,0,47,255,255,240,0,31,224,15,240,0,63,192,15,240,0,255,64,15,240,2,254,0,15,240,3,252,0,15,240,15,244,0,15,240,47,240,0,15,240,127,192,0,15,240,
  // 0x0450  ѐ
  255,
  // 0x0451  ё
  18,28,140,21,2,255,1,248,7,224,0,3,252,11,240,0,2,252,11,240,0,0,160,2,144,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x0452  ђ
  255,
  // 0x0453  ѓ
  255,
  // 0x0454  є
  15,22,88,19,2,255,0,0,84,0,0,47,255,244,2,255,255,252,11,255,255,252,31,248,0,100,63,208,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,170,170,128,255,255,255,192,255,255,255,192,255,85,85,64,255,0,0,0,191,64,0,0,127,128,0,0,63,208,0,0,47,248,0,44,15,255,255,252,2,255,255,252,0,111,255,244,0,0,84,0,
  // 0x0455  ѕ
  255,
  // 0x0456  і
  4,28,28,10,3,0,20,255,255,255,125,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0457  ї
  12,27,81,10,255,0,63,0,252,127,65,253,127,64,253,25,0,104,0,0,0,0,0,0,0,0,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,
  // 0x0458  ј
  255,
  // 0x0459  љ
  255,
  // 0x045a  њ
  255,
  // 0x045b  ћ
  255,
  // 0x045c  ќ
  255,
  // 0x045d  ѝ
  255,
  // 0x045e  ў
  255,
  // 0x045f  џ
  255,
  // 0x0460  Ѡ
  255,
  // 0x0461  ѡ
  255,
  // 0x0462  Ѣ
  255,
  // 0x0463  ѣ
  255,
  // 0x0464  Ѥ
  255,
  // 0x0465  ѥ
  255,
  // 0x0466  Ѧ
  255,
  // 0x0467  ѧ
  255,
  // 0x0468  Ѩ
  255,
  // 0x0469  ѩ
  255,
  // 0x046a  Ѫ
  255,
  // 0x046b  ѫ
  255,
  // 0x046c  Ѭ
  255,
  // 0x046d  ѭ
  255,
  // 0x046e  Ѯ
  255,
  // 0x046f  ѯ
  255,
  // 0x0470  Ѱ
  255,
  // 0x0471  ѱ
  255,
  // 0x0472  Ѳ
  255,
  // 0x0473  ѳ
  255,
  // 0x0474  Ѵ
  255,
  // 0x0475  ѵ
  255,
  // 0x0476  Ѷ
  255,
  // 0x0477  ѷ
  255,
  // 0x0478  Ѹ
  255,
  // 0x0479  ѹ
  255,
  // 0x047a  Ѻ
  255,
  // 0x047b  ѻ
  255,
  // 0x047c  Ѽ
  255,
  // 0x047d  ѽ
  255,
  // 0x047e  Ѿ
  255,
  // 0x047f  ѿ
  255,
  // 0x0480  Ҁ
  255,
  // 0x0481  ҁ
  255,
  // 0x0482  ҂
  255,
  // 0x0483  ҃
  255,
  // 0x0484  ҄
  255,
  // 0x0485  ҅
  255,
  // 0x0486  ҆
  255,
  // 0x0487  ҇
  255,
  // 0x0488  ҈
  255,
  // 0x0489  ҉
  255,
  // 0x048a  Ҋ
  255,
  // 0x048b  ҋ
  255,
  // 0x048c  Ҍ
  255,
  // 0x048d  ҍ
  255,
  // 0x048e  Ҏ
  255,
  // 0x048f  ҏ
  255,
  // 0x0490  Ґ
  17,32,160,20,3,0,0,0,0,63,64,0,0,0,63,64,0,0,0,63,64,0,0,0,63,64,0,0,0,63,64,21,85,85,191,64,127,255,255,255,64,127,255,255,255,64,127,255,255,255,64,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,
  // 0x0491  ґ
  13,26,104,17,3,0,0,0,26,128,0,0,47,192,0,0,47,192,0,0,47,192,0,0,47,192,0,0,47,192,255,255,255,192,255,255,255,192,255,255,255,192,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
