/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium 37pt, capital 'A' height: 27px, width: 100%, range: 0x0020-0x00ff
extern const uint8_t NotoSans_Medium_27[25343] = {
  130,27,32,0,255,0,35,247, // unifont_t
  // 0x0020 " "
  0,0,0,10,0,0,
  // 0x0021  !
  6,28,56,10,2,255,21,64,63,208,63,208,63,208,63,192,63,192,63,192,63,192,63,192,63,192,47,192,47,192,47,192,47,192,47,128,31,128,31,128,31,128,31,128,0,0,0,0,0,0,26,64,63,208,127,224,127,208,63,192,5,0,
  // 0x0022  "
  12,11,33,16,2,16,21,0,84,191,65,253,127,1,252,127,1,252,127,1,252,63,0,252,63,0,252,63,0,252,62,0,252,62,0,248,0,0,0,
  // 0x0023  #
  22,27,162,24,1,0,0,0,84,0,84,0,0,0,252,1,248,0,0,1,248,1,248,0,0,2,248,2,244,0,0,2,244,3,240,0,0,3,240,3,240,0,0,3,240,3,224,0,0,7,240,7,224,0,42,175,250,175,250,160,63,255,255,255,255,240,63,255,255,255,255,240,0,15,192,31,192,0,0,15,192,31,128,0,0,31,128,47,64,0,0,47,64,63,0,0,0,63,0,63,0,0,85,127,85,191,85,64,255,255,255,255,255,128,255,255,255,255,255,128,85,254,85,253,85,64,0,252,0,252,0,0,0,252,0,252,0,0,0,252,1,248,0,0,1,248,2,244,0,0,1,244,3,244,0,0,2,244,3,240,0,0,3,240,3,240,0,0,
  // 0x0024  $
  17,31,155,21,2,253,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,111,255,164,0,7,255,255,255,64,47,255,255,255,0,127,251,246,191,0,191,130,240,5,0,255,2,240,0,0,255,2,240,0,0,255,66,240,0,0,127,210,240,0,0,63,255,240,0,0,15,255,249,0,0,2,255,255,208,0,0,31,255,252,0,0,2,255,255,0,0,2,242,255,192,0,2,240,63,192,0,2,240,47,192,0,2,240,47,192,64,2,240,63,192,254,66,246,255,128,255,255,255,255,0,255,255,255,248,0,27,255,255,128,0,0,6,240,0,0,0,2,240,0,0,0,2,240,0,0,0,2,240,0,0,0,0,0,0,0,
  // 0x0025  %
  29,28,224,32,1,255,0,170,64,0,0,85,0,0,7,255,224,0,0,252,0,0,15,255,248,0,2,248,0,0,47,193,252,0,3,240,0,0,63,64,254,0,15,224,0,0,63,0,126,0,31,192,0,0,127,0,127,0,63,64,0,0,127,0,63,0,127,0,0,0,127,0,63,0,253,0,0,0,127,0,63,2,252,0,0,0,127,0,127,3,240,0,0,0,63,0,127,11,224,191,224,0,63,64,254,15,195,255,252,0,31,193,252,47,135,250,254,0,15,255,248,127,15,224,127,0,3,255,240,253,15,192,63,64,0,110,65,252,31,192,47,128,0,0,3,244,31,192,31,192,0,0,11,240,47,128,31,192,0,0,15,192,47,128,31,192,0,0,47,128,31,192,31,192,0,0,63,0,31,192,47,128,0,0,190,0,15,192,63,128,0,1,252,0,15,208,63,0,0,3,244,0,7,249,255,0,0,7,240,0,3,255,252,0,0,15,208,0,0,191,244,0,0,0,0,0,0,5,0,0,
  // 0x0026  &
  25,28,196,27,2,255,0,6,250,64,0,0,0,0,127,255,240,0,0,0,2,255,255,252,0,0,0,3,254,91,254,0,0,0,11,248,1,255,0,0,0,11,240,0,255,0,0,0,11,240,0,255,0,0,0,11,240,0,255,0,0,0,7,248,2,253,0,0,0,3,253,11,252,0,0,0,0,255,191,240,0,0,0,0,127,255,128,0,0,0,0,63,253,0,0,0,0,2,255,253,0,0,169,0,11,255,255,64,2,253,0,47,248,191,208,3,252,0,127,208,47,244,3,252,0,255,128,11,253,11,244,0,255,0,2,255,79,240,0,255,0,0,191,255,208,0,255,0,0,47,255,128,0,255,64,0,11,255,0,0,255,192,0,31,255,128,0,127,244,1,255,255,224,0,47,255,255,255,175,248,0,11,255,255,253,7,254,0,1,191,255,208,1,255,128,0,1,80,0,0,0,0,
  // 0x0027  '
  5,11,22,9,2,16,21,0,191,64,127,0,127,0,127,0,63,0,63,0,63,0,62,0,62,0,0,0,
  // 0x0028  (
  9,33,99,12,1,250,0,5,64,0,63,192,0,127,0,0,254,0,2,252,0,3,248,0,11,240,0,15,240,0,31,208,0,47,192,0,63,192,0,63,128,0,63,128,0,127,64,0,127,64,0,127,64,0,191,0,0,127,0,0,127,64,0,127,64,0,127,64,0,63,128,0,63,192,0,47,192,0,31,208,0,15,224,0,15,240,0,7,244,0,3,252,0,1,253,0,0,255,0,0,63,64,0,31,192,
  // 0x0029  )
  9,33,99,12,1,250,85,0,0,127,64,0,47,192,0,15,224,0,11,240,0,3,248,0,2,252,0,1,253,0,0,255,0,0,191,0,0,127,64,0,63,128,0,63,128,0,63,192,0,63,192,0,63,192,0,47,192,0,47,192,0,63,192,0,63,192,0,63,192,0,63,128,0,127,64,0,191,64,0,255,0,0,254,0,1,253,0,3,252,0,7,244,0,15,240,0,31,208,0,63,128,0,127,0,0,
  // 0x002a  *
  18,17,85,20,1,11,0,3,252,0,0,0,2,252,0,0,0,2,252,0,0,0,1,248,0,0,0,1,248,0,0,57,1,244,6,208,127,249,249,255,224,127,255,255,255,224,111,255,255,255,160,0,7,254,0,0,0,15,255,64,0,0,63,159,192,0,0,191,15,224,0,1,254,7,248,0,3,253,3,252,0,1,252,2,244,0,0,20,0,64,0,
  // 0x002b  +
  18,18,90,21,2,4,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,170,171,250,170,128,255,255,255,255,208,255,255,255,255,208,85,87,245,85,64,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,
  // 0x002c  ,
  7,10,20,10,1,251,1,80,15,244,15,240,15,224,31,208,47,192,63,128,63,0,127,0,125,0,
  // 0x002d  -
  10,4,12,12,1,8,106,170,144,191,255,224,191,255,224,127,255,208,
  // 0x002e  .
  6,6,12,10,2,255,26,64,63,208,127,224,127,208,63,192,5,0,
  // 0x002f  /
  14,27,108,14,0,0,0,0,5,80,0,0,15,224,0,0,47,192,0,0,63,192,0,0,127,64,0,0,191,0,0,0,254,0,0,1,253,0,0,3,252,0,0,3,248,0,0,11,240,0,0,15,240,0,0,31,208,0,0,47,192,0,0,63,128,0,0,127,64,0,0,255,0,0,0,254,0,0,2,252,0,0,3,252,0,0,7,244,0,0,11,240,0,0,15,224,0,0,31,208,0,0,47,192,0,0,63,128,0,0,127,0,0,0,
  // 0x0030  0
  19,28,140,21,1,255,0,6,250,64,0,0,127,255,240,0,1,255,255,253,0,3,255,171,255,0,11,252,0,191,128,15,240,0,63,192,31,224,0,31,208,47,192,0,15,240,63,192,0,15,240,63,192,0,11,240,63,128,0,11,244,127,128,0,11,244,127,128,0,7,244,127,128,0,7,244,127,128,0,7,244,127,128,0,11,244,63,128,0,11,244,63,192,0,11,244,63,192,0,15,240,63,192,0,15,240,31,208,0,31,224,15,224,0,47,208,15,244,0,63,192,7,253,1,255,128,2,255,255,255,0,0,191,255,252,0,0,31,255,224,0,0,0,84,0,0,
  // 0x0031  1
  11,27,81,21,3,0,0,1,84,0,11,252,0,63,252,1,255,252,7,255,252,47,247,252,255,195,252,127,3,252,24,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,0,3,252,
  // 0x0032  2
  19,27,135,21,1,0,0,6,186,64,0,0,255,255,244,0,11,255,255,254,0,63,255,171,255,64,31,208,0,255,192,11,0,0,63,192,0,0,0,47,208,0,0,0,47,208,0,0,0,47,208,0,0,0,63,192,0,0,0,63,192,0,0,0,191,64,0,0,1,255,0,0,0,3,252,0,0,0,15,244,0,0,0,63,224,0,0,0,255,128,0,0,3,254,0,0,0,15,248,0,0,0,63,224,0,0,0,255,128,0,0,3,254,0,0,0,15,244,0,0,0,63,245,85,85,80,127,255,255,255,244,127,255,255,255,244,127,255,255,255,244,
  // 0x0033  3
  18,28,140,21,1,255,0,26,186,64,0,2,255,255,248,0,47,255,255,254,0,63,254,171,255,128,15,128,0,191,192,4,0,0,63,208,0,0,0,47,208,0,0,0,47,208,0,0,0,47,192,0,0,0,63,192,0,0,0,255,64,0,21,91,253,0,0,127,255,224,0,0,127,255,144,0,0,127,255,254,0,0,0,6,255,192,0,0,0,63,224,0,0,0,31,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,31,240,0,0,0,63,224,126,64,1,255,192,127,255,255,255,64,127,255,255,253,0,27,255,255,208,0,0,5,80,0,0,
  // 0x0034  4
  21,27,162,21,0,0,0,0,0,42,64,0,0,0,0,255,192,0,0,0,2,255,192,0,0,0,3,255,192,0,0,0,15,255,192,0,0,0,47,191,192,0,0,0,127,63,192,0,0,0,254,63,192,0,0,2,252,63,192,0,0,7,240,63,192,0,0,15,208,63,192,0,0,47,192,63,192,0,0,127,0,63,192,0,0,253,0,63,192,0,3,248,0,63,192,0,11,240,0,63,192,0,15,208,0,63,192,0,63,192,0,63,192,0,127,255,255,255,255,64,127,255,255,255,255,64,127,255,255,255,255,64,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,
  // 0x0035  5
  17,28,140,21,2,255,5,85,85,84,0,31,255,255,253,0,31,255,255,253,0,31,255,255,253,0,47,192,0,0,0,47,192,0,0,0,47,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,128,0,0,0,63,133,80,0,0,63,255,255,128,0,63,255,255,248,0,63,255,255,254,0,4,0,7,255,0,0,0,0,255,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,127,128,64,0,0,255,64,249,0,11,255,0,255,255,255,252,0,255,255,255,224,0,31,255,254,64,0,0,21,64,0,0,
  // 0x0036  6
  18,28,140,21,2,255,0,0,106,169,0,0,11,255,254,0,0,127,255,254,0,2,255,249,89,0,7,254,0,0,0,15,244,0,0,0,47,224,0,0,0,63,192,0,0,0,127,128,0,0,0,191,0,0,0,0,191,1,170,64,0,255,31,255,244,0,254,127,255,254,0,255,254,91,255,64,255,224,0,191,192,255,128,0,63,192,255,0,0,47,208,255,0,0,31,224,255,0,0,31,224,255,0,0,31,208,191,64,0,47,208,127,128,0,63,192,63,208,0,127,192,31,248,2,255,64,11,255,255,254,0,2,255,255,248,0,0,47,255,208,0,0,0,84,0,0,
  // 0x0037  7
  19,27,135,21,1,0,21,85,85,85,80,191,255,255,255,248,191,255,255,255,248,191,255,255,255,244,0,0,0,15,240,0,0,0,31,224,0,0,0,63,192,0,0,0,127,128,0,0,0,191,64,0,0,0,255,0,0,0,2,253,0,0,0,3,252,0,0,0,11,244,0,0,0,15,240,0,0,0,31,224,0,0,0,63,192,0,0,0,127,128,0,0,0,255,64,0,0,1,255,0,0,0,3,253,0,0,0,3,252,0,0,0,11,244,0,0,0,15,240,0,0,0,47,224,0,0,0,63,192,0,0,0,191,128,0,0,0,255,64,0,0,
  // 0x0038  8
  19,28,140,21,1,255,0,6,186,64,0,0,191,255,248,0,3,255,255,255,0,11,254,86,255,192,15,240,0,63,208,31,224,0,31,224,31,208,0,15,224,31,208,0,31,224,15,224,0,47,208,15,244,0,127,192,3,254,2,255,0,1,255,239,252,0,0,63,255,224,0,0,47,255,208,0,1,255,255,252,0,7,254,7,255,64,15,244,0,191,208,47,208,0,31,240,63,192,0,11,240,63,128,0,7,244,127,64,0,7,244,63,128,0,11,244,63,192,0,15,240,47,244,0,127,224,15,255,171,255,192,3,255,255,254,0,0,127,255,228,0,0,0,84,0,0,
  // 0x0039  9
  19,28,140,21,1,255,0,6,169,0,0,0,191,255,224,0,2,255,255,252,0,11,255,171,255,0,31,244,0,255,128,47,208,0,63,208,63,192,0,31,224,63,128,0,15,240,127,128,0,11,240,127,128,0,11,244,63,128,0,11,244,63,192,0,15,244,63,208,0,47,244,31,244,0,255,244,15,255,255,251,244,3,255,255,219,240,0,127,254,11,240,0,1,64,15,240,0,0,0,15,224,0,0,0,31,208,0,0,0,63,192,0,0,0,191,128,0,0,2,255,0,0,0,31,253,0,7,255,255,244,0,7,255,255,192,0,7,255,249,0,0,0,85,0,0,0,
  // 0x003a  :
  6,22,44,10,2,255,5,0,63,192,127,208,127,224,63,208,31,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,64,63,208,127,224,127,208,63,192,5,0,
  // 0x003b  ;
  7,26,52,10,1,251,1,64,15,240,31,244,47,244,31,244,7,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,80,15,240,31,240,31,224,47,192,63,192,63,64,127,0,190,0,188,0,
  // 0x003c  <
  18,19,95,21,2,4,0,0,0,0,64,0,0,0,7,208,0,0,0,127,208,0,0,7,255,192,0,0,127,253,0,0,7,255,208,0,0,127,253,0,0,7,255,208,0,0,127,249,0,0,0,255,128,0,0,0,255,208,0,0,0,127,254,0,0,0,7,255,228,0,0,0,47,255,64,0,0,2,255,248,0,0,0,31,255,192,0,0,1,255,208,0,0,0,11,208,0,0,0,0,144,
  // 0x003d  =
  17,11,55,21,2,7,255,255,255,255,192,255,255,255,255,192,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,192,255,255,255,255,192,255,255,255,255,192,0,0,0,0,0,
  // 0x003e  >
  18,19,95,21,2,4,64,0,0,0,0,244,0,0,0,0,255,64,0,0,0,255,244,0,0,0,31,255,64,0,0,1,255,244,0,0,0,31,255,64,0,0,1,191,244,0,0,0,11,255,64,0,0,0,191,208,0,0,1,191,208,0,0,31,255,128,0,2,255,244,0,0,127,254,64,0,11,255,224,0,0,191,253,0,0,0,255,208,0,0,0,249,0,0,0,0,128,0,0,0,0,
  // 0x003f  ?
  16,28,112,17,0,255,0,106,164,0,31,255,255,128,127,255,255,240,63,250,191,252,45,0,7,252,0,0,1,253,0,0,0,254,0,0,0,254,0,0,1,253,0,0,3,252,0,0,15,244,0,0,63,224,0,1,255,128,0,7,253,0,0,15,244,0,0,31,208,0,0,47,128,0,0,63,64,0,0,63,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,64,0,0,127,192,0,0,191,208,0,0,191,208,0,0,63,192,0,0,5,0,0,
  // 0x0040  @
  29,31,248,33,2,252,0,0,0,21,80,0,0,0,0,0,27,255,255,144,0,0,0,1,255,255,255,253,0,0,0,11,255,149,91,255,128,0,0,63,224,0,0,127,224,0,0,255,64,0,0,7,248,0,3,252,0,0,0,1,253,0,11,240,0,5,64,0,191,0,15,208,1,255,255,128,63,64,47,128,15,255,255,208,47,128,63,0,63,229,111,192,15,192,63,0,191,64,15,192,15,192,126,0,253,0,15,192,15,192,189,1,252,0,15,192,15,192,252,2,248,0,15,192,15,192,252,2,248,0,31,192,15,192,252,2,248,0,31,192,15,192,252,2,248,0,47,192,31,128,253,1,252,0,63,192,47,64,189,0,254,0,191,208,127,0,190,0,191,235,247,250,253,0,63,0,47,255,209,255,244,0,63,64,6,254,0,127,128,0,31,192,0,0,0,0,0,0,15,240,0,0,0,0,0,0,3,252,0,0,0,0,0,0,1,255,128,0,1,180,0,0,0,127,254,170,191,244,0,0,0,11,255,255,255,240,0,0,0,0,111,255,254,64,0,0,0,0,0,0,0,0,0,0,
  // 0x0041  A
  24,27,162,24,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x0042  B
  20,27,135,24,3,0,21,85,84,0,0,127,255,255,248,0,127,255,255,255,64,127,255,255,255,208,127,128,1,191,240,127,128,0,31,244,127,128,0,15,244,127,128,0,11,244,127,128,0,11,244,127,128,0,15,240,127,128,0,47,224,127,149,86,255,128,127,255,255,253,0,127,255,255,249,0,127,255,255,255,192,127,128,0,127,240,127,128,0,15,248,127,128,0,3,252,127,128,0,3,252,127,128,0,3,253,127,128,0,3,252,127,128,0,11,252,127,128,0,31,248,127,149,86,255,240,127,255,255,255,208,127,255,255,255,0,127,255,255,228,0,
  // 0x0043  C
  20,28,140,23,2,255,0,0,26,234,64,0,7,255,255,253,0,47,255,255,255,0,255,255,175,253,3,255,208,0,108,11,254,0,0,0,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,127,192,0,0,0,127,192,0,0,0,191,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,128,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,208,0,0,0,47,240,0,0,0,15,248,0,0,0,11,254,0,0,0,3,255,228,1,188,0,255,255,255,252,0,47,255,255,252,0,2,255,255,244,0,0,5,84,0,
  // 0x0044  D
  22,27,162,27,3,0,21,85,84,0,0,0,127,255,255,244,0,0,127,255,255,255,64,0,127,255,255,255,224,0,127,128,1,191,252,0,127,128,0,11,254,0,127,128,0,2,255,64,127,128,0,0,255,192,127,128,0,0,127,192,127,128,0,0,63,208,127,128,0,0,47,224,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,31,240,127,128,0,0,47,224,127,128,0,0,63,208,127,128,0,0,63,192,127,128,0,0,191,192,127,128,0,1,255,64,127,128,0,7,255,0,127,128,0,47,252,0,127,149,91,255,244,0,127,255,255,255,192,0,127,255,255,253,0,0,127,255,254,64,0,0,
  // 0x0045  E
  16,27,108,21,3,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x0046  F
  16,27,108,20,3,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,127,64,0,0,
  // 0x0047  G
  22,28,168,27,2,255,0,0,6,190,148,0,0,2,255,255,255,144,0,31,255,255,255,224,0,191,255,235,255,192,2,255,224,0,7,128,7,255,0,0,0,0,15,252,0,0,0,0,47,240,0,0,0,0,63,208,0,0,0,0,127,192,0,0,0,0,127,192,0,0,0,0,191,128,0,0,0,0,191,64,0,0,0,0,255,64,0,127,255,240,191,64,0,127,255,240,191,64,0,127,255,240,191,128,0,0,15,240,127,192,0,0,15,240,63,192,0,0,15,240,63,208,0,0,15,240,47,240,0,0,15,240,15,252,0,0,15,240,7,255,0,0,15,240,2,255,228,0,95,240,0,191,255,255,255,240,0,31,255,255,255,240,0,1,255,255,254,64,0,0,1,85,0,0,
  // 0x0048  H
  21,27,162,28,3,0,21,0,0,0,21,64,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,149,85,85,127,192,127,255,255,255,255,192,127,255,255,255,255,192,127,255,255,255,255,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,127,128,0,0,63,192,
  // 0x0049  I
  11,27,81,13,1,0,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,
  // 0x004a  J
  11,35,105,11,253,248,0,5,80,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,11,244,0,15,240,0,31,240,81,191,224,255,255,192,255,255,0,191,248,0,0,0,0,
  // 0x004b  K
  20,27,135,23,3,0,21,0,0,1,85,127,128,0,7,253,127,128,0,15,244,127,128,0,63,224,127,128,0,255,128,127,128,2,255,0,127,128,11,252,0,127,128,31,240,0,127,128,127,192,0,127,128,255,64,0,127,131,253,0,0,127,143,248,0,0,127,175,244,0,0,127,255,252,0,0,127,255,254,0,0,127,245,255,64,0,127,192,191,192,0,127,128,63,224,0,127,128,31,244,0,127,128,11,252,0,127,128,3,255,0,127,128,0,255,128,127,128,0,127,192,127,128,0,47,240,127,128,0,15,248,127,128,0,7,253,127,128,0,2,255,
  // 0x004c  L
  16,27,108,20,3,0,21,0,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,85,127,255,255,255,127,255,255,255,127,255,255,255,
  // 0x004d  M
  28,27,189,34,3,0,21,80,0,0,0,5,84,127,248,0,0,0,47,253,127,252,0,0,0,63,253,127,253,0,0,0,127,253,127,254,0,0,0,191,253,127,191,0,0,0,254,253,127,127,64,0,1,253,253,127,63,128,0,3,249,253,127,47,192,0,3,241,253,127,15,208,0,11,241,253,127,15,240,0,15,225,253,127,7,240,0,31,193,253,127,3,244,0,47,193,253,127,3,252,0,63,65,253,127,1,252,0,127,1,253,127,0,254,0,190,1,253,127,0,191,0,253,1,253,127,0,127,65,252,1,253,127,0,63,131,248,1,253,127,0,47,195,240,1,253,127,0,31,219,240,1,253,127,0,15,239,208,1,253,127,0,11,255,192,1,253,127,0,3,255,128,1,253,127,0,3,255,64,1,253,127,0,2,255,0,1,253,127,0,0,254,0,1,253,
  // 0x004e  N
  22,27,162,29,3,0,21,64,0,0,1,80,127,240,0,0,11,240,127,248,0,0,11,240,127,252,0,0,11,240,127,255,0,0,11,240,127,255,64,0,11,240,127,127,192,0,11,240,127,63,224,0,11,240,127,15,244,0,11,240,127,11,252,0,11,240,127,3,254,0,11,240,127,1,255,0,11,240,127,0,191,192,11,240,127,0,63,208,11,240,127,0,31,240,7,240,127,0,15,248,7,240,127,0,3,253,7,240,127,0,2,255,7,240,127,0,0,255,135,240,127,0,0,127,199,240,127,0,0,47,247,240,127,0,0,15,251,240,127,0,0,7,255,240,127,0,0,3,255,240,127,0,0,0,255,240,127,0,0,0,191,240,127,0,0,0,63,240,
  // 0x004f  O
  25,28,196,29,2,255,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x0050  P
  18,27,135,23,3,0,21,85,80,0,0,127,255,255,208,0,127,255,255,253,0,127,255,255,255,0,127,128,6,255,192,127,128,0,127,208,127,128,0,47,224,127,128,0,31,224,127,128,0,31,240,127,128,0,31,224,127,128,0,47,224,127,128,0,63,208,127,128,1,255,192,127,149,111,255,64,127,255,255,253,0,127,255,255,240,0,127,255,250,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,
  // 0x0051  Q
  25,34,238,29,2,249,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,240,0,0,0,0,5,111,244,0,0,0,0,0,11,253,0,0,0,0,0,3,255,64,0,0,0,0,0,255,192,0,0,0,0,0,63,240,0,0,0,0,0,31,252,0,0,0,0,0,1,84,0,
  // 0x0052  R
  20,27,135,23,3,0,21,85,84,0,0,127,255,255,224,0,127,255,255,253,0,127,255,255,255,64,127,128,6,255,192,127,128,0,127,208,127,128,0,47,224,127,128,0,31,240,127,128,0,31,240,127,128,0,31,224,127,128,0,47,208,127,128,0,127,192,127,128,6,255,64,127,255,255,254,0,127,255,255,244,0,127,255,255,192,0,127,149,127,208,0,127,128,15,240,0,127,128,11,248,0,127,128,3,253,0,127,128,1,255,0,127,128,0,255,128,127,128,0,63,192,127,128,0,47,240,127,128,0,15,244,127,128,0,7,252,127,128,0,3,254,
  // 0x0053  S
  17,28,140,20,2,255,0,26,234,64,0,2,255,255,253,0,15,255,255,255,0,63,254,175,254,0,127,208,0,108,0,191,128,0,0,0,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,191,192,0,0,0,63,244,0,0,0,31,255,64,0,0,11,255,244,0,0,1,255,255,128,0,0,31,255,240,0,0,1,191,252,0,0,0,15,255,0,0,0,2,255,64,0,0,0,191,128,0,0,0,127,128,0,0,0,127,128,0,0,0,191,128,128,0,0,255,0,254,64,27,254,0,255,255,255,252,0,255,255,255,240,0,111,255,254,64,0,0,21,64,0,0,
  // 0x0054  T
  21,27,162,21,0,0,21,85,85,85,85,0,191,255,255,255,255,64,191,255,255,255,255,64,191,255,255,255,255,64,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,0,0,191,64,0,0,
  // 0x0055  U
  21,28,168,27,3,255,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x0056  V
  23,27,162,23,0,0,85,0,0,0,1,84,191,64,0,0,11,244,127,192,0,0,15,240,63,192,0,0,31,224,47,208,0,0,47,208,31,240,0,0,63,192,15,240,0,0,127,128,11,244,0,0,255,64,3,252,0,0,255,0,3,252,0,1,254,0,2,253,0,3,253,0,0,255,0,3,252,0,0,255,0,7,248,0,0,127,128,15,240,0,0,63,192,15,240,0,0,63,192,31,208,0,0,31,224,63,192,0,0,15,240,63,192,0,0,11,240,127,64,0,0,7,248,255,0,0,0,3,252,254,0,0,0,2,253,253,0,0,0,1,255,252,0,0,0,0,255,248,0,0,0,0,191,244,0,0,0,0,63,240,0,0,0,0,63,224,0,0,
  // 0x0057  W
  34,27,243,35,0,0,85,0,0,1,84,0,0,5,80,127,128,0,3,254,0,0,15,240,63,192,0,3,255,0,0,15,240,63,192,0,11,255,0,0,31,224,47,208,0,15,255,64,0,47,208,31,224,0,15,255,128,0,63,192,15,240,0,31,239,192,0,63,192,15,240,0,47,207,208,0,127,128,11,244,0,63,143,224,0,191,64,7,248,0,63,75,240,0,255,0,3,252,0,127,7,240,0,255,0,3,252,0,255,3,244,1,254,0,2,253,0,254,3,252,2,253,0,1,254,1,253,2,252,3,252,0,0,255,2,252,1,253,3,252,0,0,255,3,248,0,254,7,248,0,0,191,67,244,0,191,11,244,0,0,127,135,240,0,127,15,240,0,0,63,203,240,0,63,79,240,0,0,47,207,224,0,63,143,224,0,0,31,223,208,0,47,223,192,0,0,15,239,192,0,31,239,192,0,0,15,255,128,0,15,255,128,0,0,11,255,64,0,11,255,64,0,0,7,255,0,0,7,255,0,0,0,3,255,0,0,3,255,0,0,0,3,254,0,0,3,254,0,0,
  // 0x0058  X
  22,27,162,23,0,0,21,64,0,0,5,80,47,224,0,0,63,192,15,244,0,0,191,128,7,252,0,0,255,0,3,254,0,3,253,0,0,255,0,7,248,0,0,191,128,15,240,0,0,63,208,47,208,0,0,15,240,127,128,0,0,11,248,255,0,0,0,3,254,253,0,0,0,1,255,252,0,0,0,0,191,240,0,0,0,0,127,240,0,0,0,0,255,244,0,0,0,2,255,252,0,0,0,3,254,254,0,0,0,15,240,255,64,0,0,31,224,127,192,0,0,63,192,47,224,0,0,191,64,15,244,0,1,255,0,7,252,0,3,252,0,3,254,0,11,248,0,0,255,0,31,240,0,0,191,192,63,208,0,0,63,208,191,128,0,0,31,240,
  // 0x0059  Y
  21,27,162,22,0,0,85,0,0,0,21,64,191,192,0,0,63,192,63,208,0,0,191,128,31,240,0,1,255,0,15,244,0,3,253,0,7,252,0,7,252,0,3,253,0,15,244,0,1,255,0,31,240,0,0,191,64,63,208,0,0,63,192,127,128,0,0,47,224,255,0,0,0,15,241,254,0,0,0,11,251,252,0,0,0,3,255,248,0,0,0,1,255,240,0,0,0,0,255,208,0,0,0,0,127,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x005a  Z
  19,27,135,21,1,0,21,85,85,85,84,127,255,255,255,248,127,255,255,255,248,127,255,255,255,248,0,0,0,47,240,0,0,0,63,192,0,0,0,255,128,0,0,2,255,0,0,0,3,252,0,0,0,15,248,0,0,0,47,240,0,0,0,63,192,0,0,0,255,128,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,192,0,0,0,255,64,0,0,2,255,0,0,0,7,252,0,0,0,15,244,0,0,0,47,240,0,0,0,127,229,85,85,84,191,255,255,255,252,191,255,255,255,252,191,255,255,255,252,
  // 0x005b  [
  9,33,99,12,3,250,85,85,0,255,255,64,255,255,64,255,170,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,253,0,0,254,0,0,255,255,64,255,255,64,255,255,0,
  // 0x005c "\"
  14,27,108,14,0,0,85,0,0,0,127,64,0,0,63,128,0,0,47,192,0,0,15,208,0,0,15,240,0,0,7,240,0,0,3,248,0,0,2,252,0,0,1,253,0,0,0,254,0,0,0,191,0,0,0,63,64,0,0,63,192,0,0,31,192,0,0,15,224,0,0,11,240,0,0,7,244,0,0,3,248,0,0,2,252,0,0,1,253,0,0,0,255,0,0,0,191,0,0,0,63,128,0,0,63,192,0,0,31,208,0,0,15,224,
  // 0x005d  ]
  9,33,99,12,1,250,85,85,0,255,255,64,255,255,64,170,191,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,0,127,64,255,255,64,255,255,64,255,255,64,
  // 0x005e  ^
  19,18,90,21,1,9,0,0,160,0,0,0,1,248,0,0,0,3,253,0,0,0,7,255,0,0,0,15,255,64,0,0,31,223,192,0,0,47,79,208,0,0,63,7,240,0,0,189,3,244,0,0,252,1,252,0,2,248,0,253,0,3,240,0,127,0,11,224,0,63,64,15,192,0,31,192,31,128,0,15,208,63,64,0,7,240,127,0,0,3,248,20,0,0,0,80,
  // 0x005f  _
  16,3,12,16,0,250,170,170,170,170,255,255,255,255,170,170,170,170,
  // 0x0060  `
  8,7,14,11,2,22,85,0,255,128,127,192,31,240,7,248,0,253,0,41,
  // 0x0061  a
  18,22,110,21,1,255,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x0062  b
  18,29,145,23,3,255,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,7,255,208,0,255,63,255,252,0,255,255,255,255,0,255,244,2,255,128,255,192,0,127,192,255,128,0,63,208,255,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,64,0,31,224,255,128,0,63,208,255,192,0,127,192,255,244,1,255,128,255,255,255,255,0,253,63,255,252,0,252,11,255,224,0,0,0,20,0,0,
  // 0x0063  c
  15,22,88,18,2,255,0,0,84,0,0,47,255,228,2,255,255,248,11,255,255,244,31,253,1,176,63,224,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,192,0,0,63,208,0,0,47,248,0,120,15,255,255,248,2,255,255,248,0,127,255,224,0,1,84,0,
  // 0x0064  d
  18,29,145,23,2,255,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,1,64,15,240,0,191,254,15,240,3,255,255,207,240,15,255,255,255,240,47,248,1,255,240,63,208,0,127,240,127,192,0,47,240,191,64,0,31,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,191,64,0,15,240,191,128,0,47,240,63,208,0,63,240,47,244,1,255,240,15,255,255,255,240,3,255,255,203,240,0,191,254,7,240,0,1,64,0,0,
  // 0x0065  e
  18,22,110,21,2,255,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x0066  f
  15,29,116,13,0,0,0,0,4,0,0,7,255,248,0,31,255,244,0,63,255,240,0,191,192,16,0,255,64,0,0,255,0,0,0,255,0,0,0,255,0,0,7,255,255,128,127,255,255,192,127,255,255,192,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,
  // 0x0067  g
  18,30,150,23,2,247,0,1,64,0,0,0,191,253,7,240,3,255,255,203,240,15,255,255,255,240,47,248,2,255,240,63,208,0,127,240,127,192,0,47,240,191,64,0,31,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,191,64,0,15,240,127,128,0,31,240,63,208,0,63,240,47,244,1,255,240,15,255,255,255,240,3,255,255,207,240,0,191,254,15,240,0,1,64,15,240,0,0,0,15,240,0,0,0,31,224,0,0,0,47,208,20,0,0,191,192,47,165,87,255,128,47,255,255,254,0,31,255,255,244,0,1,175,254,64,0,
  // 0x0068  h
  18,28,140,23,3,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,4,0,0,255,7,255,224,0,255,63,255,253,0,255,191,255,255,64,255,248,1,255,192,255,208,0,127,192,255,192,0,63,192,255,64,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,
  // 0x0069  i
  4,28,28,10,3,0,20,255,255,255,125,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x006a  j
  9,37,111,10,254,247,0,5,0,0,63,192,0,63,192,0,63,192,0,31,64,0,0,0,0,0,0,0,0,0,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,127,192,150,255,128,255,255,0,255,253,0,191,144,0,
  // 0x006b  k
  17,28,140,21,3,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,255,64,255,0,3,254,0,255,0,15,248,0,255,0,63,224,0,255,0,191,128,0,255,2,255,0,0,255,11,252,0,0,255,31,240,0,0,255,127,192,0,0,255,255,224,0,0,255,255,244,0,0,255,231,252,0,0,255,130,255,0,0,255,0,255,128,0,255,0,63,208,0,255,0,31,240,0,255,0,11,252,0,255,0,3,254,0,255,0,1,255,64,255,0,0,191,192,
  // 0x006c  l
  4,28,28,10,3,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x006d  m
  29,21,168,35,3,0,0,0,16,0,0,4,0,0,253,11,255,224,7,255,244,0,253,63,255,252,47,255,253,0,255,255,255,254,191,255,255,0,255,244,3,255,253,1,255,128,255,192,0,255,240,0,127,192,255,128,0,191,192,0,63,192,255,64,0,127,192,0,63,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,255,0,0,127,128,0,47,192,
  // 0x006e  n
  18,21,105,23,3,0,0,0,4,0,0,253,7,255,244,0,253,63,255,254,0,255,255,255,255,64,255,248,1,255,192,255,208,0,127,192,255,192,0,63,192,255,64,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,
  // 0x006f  o
  19,22,110,23,2,255,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x0070  p
  18,30,150,23,3,247,0,0,20,0,0,253,11,255,224,0,254,63,255,252,0,255,255,255,255,0,255,244,2,255,128,255,192,0,127,192,255,128,0,63,208,255,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,240,255,64,0,47,224,255,128,0,63,208,255,208,0,127,192,255,244,2,255,128,255,255,255,255,0,255,63,255,252,0,255,11,255,224,0,255,0,20,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,
  // 0x0071  q
  18,30,150,23,2,247,0,1,64,0,0,0,191,253,7,240,3,255,255,203,240,15,255,255,255,240,47,248,1,255,240,63,208,0,127,240,127,192,0,47,240,191,64,0,31,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,191,64,0,15,240,191,128,0,47,240,63,208,0,63,240,47,244,1,255,240,15,255,255,255,240,3,255,255,207,240,0,191,254,15,240,0,1,64,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,0,0,0,15,240,
  // 0x0072  r
  12,21,63,16,3,0,0,0,20,252,7,255,253,31,255,254,127,255,255,255,85,255,244,0,255,208,0,255,128,0,255,64,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
  // 0x0073  s
  15,22,88,18,2,255,0,5,64,0,2,255,255,64,47,255,255,240,127,255,255,208,255,64,6,192,254,0,0,0,255,0,0,0,255,128,0,0,191,244,0,0,63,255,128,0,11,255,252,0,0,191,255,128,0,7,255,208,0,0,127,240,0,0,15,240,0,0,11,244,0,0,11,240,228,0,31,240,255,234,255,208,255,255,255,128,111,255,248,0,0,85,0,0,
  // 0x0074  t
  14,26,104,14,0,255,0,20,0,0,0,125,0,0,0,189,0,0,0,253,0,0,1,253,0,0,11,255,255,192,127,255,255,192,127,255,255,192,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,2,253,0,0,1,254,0,0,1,255,64,0,0,255,255,208,0,127,255,208,0,31,255,192,0,0,84,0,
  // 0x0075  u
  17,21,105,23,3,255,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x0076  v
  20,20,100,19,0,0,255,64,0,3,253,127,128,0,3,252,63,192,0,11,248,47,208,0,15,240,31,224,0,31,240,15,240,0,47,208,11,244,0,63,192,3,252,0,127,128,3,252,0,191,64,1,253,0,255,0,0,255,1,253,0,0,191,3,252,0,0,127,131,248,0,0,63,199,244,0,0,47,203,240,0,0,15,223,224,0,0,15,255,192,0,0,7,255,192,0,0,3,255,64,0,0,2,255,0,0,
  // 0x0077  w
  30,20,160,30,0,0,127,128,0,127,192,0,47,208,63,192,0,191,224,0,63,192,63,192,0,255,240,0,63,192,47,208,0,255,240,0,127,64,31,224,2,251,244,0,191,0,15,240,3,246,248,0,255,0,15,240,3,241,252,0,254,0,11,244,7,240,253,1,253,0,7,248,11,224,254,2,252,0,3,252,15,208,191,3,252,0,2,252,31,192,127,7,248,0,1,253,47,192,63,75,240,0,0,254,63,128,63,139,240,0,0,255,63,0,31,207,224,0,0,191,127,0,15,223,208,0,0,127,190,0,15,239,192,0,0,63,253,0,11,255,192,0,0,63,252,0,7,255,128,0,0,31,248,0,3,255,64,0,0,15,244,0,2,255,0,0,
  // 0x0078  x
  18,20,100,20,1,0,255,128,0,31,240,63,208,0,63,192,31,240,0,255,128,15,248,1,255,0,3,253,3,252,0,1,255,15,244,0,0,191,159,240,0,0,63,255,192,0,0,31,255,64,0,0,11,254,0,0,0,15,255,0,0,0,47,255,128,0,0,127,255,208,0,0,255,79,240,0,2,254,11,248,0,7,252,3,253,0,15,244,0,255,0,47,224,0,191,192,127,192,0,63,224,255,64,0,15,240,
  // 0x0079  y
  20,29,145,20,0,247,191,64,0,3,253,127,192,0,3,252,63,192,0,11,248,47,224,0,15,240,15,240,0,31,240,15,240,0,47,208,7,248,0,63,192,3,252,0,127,128,2,253,0,191,64,0,254,0,255,0,0,255,1,254,0,0,127,66,252,0,0,63,195,252,0,0,47,199,244,0,0,15,219,240,0,0,15,239,224,0,0,7,255,208,0,0,3,255,192,0,0,2,255,128,0,0,0,255,0,0,0,0,255,0,0,0,2,253,0,0,0,3,252,0,0,0,7,248,0,0,0,31,240,0,0,21,191,224,0,0,127,255,128,0,0,127,254,0,0,0,47,224,0,0,0,
  // 0x007a  z
  16,20,80,18,1,0,63,255,255,252,63,255,255,252,63,255,255,252,0,0,15,244,0,0,31,240,0,0,63,192,0,0,255,64,0,2,254,0,0,7,252,0,0,15,240,0,0,47,208,0,0,127,192,0,0,255,0,0,3,253,0,0,11,248,0,0,31,240,0,0,63,208,0,0,191,255,255,253,191,255,255,253,191,255,255,253,
  // 0x007b  {
  12,33,99,14,1,250,0,0,5,0,2,255,0,31,255,0,63,254,0,127,208,0,191,64,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,255,0,7,254,0,255,248,0,255,128,0,255,244,0,91,253,0,1,255,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,127,128,0,63,245,0,47,255,0,11,255,0,0,111,
  // 0x007c  |
  4,37,37,20,8,247,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,126,
  // 0x007d  }
  13,33,132,14,1,250,80,0,0,0,191,144,0,0,191,244,0,0,191,252,0,0,3,254,0,0,0,254,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,0,0,0,127,208,0,0,31,255,64,0,1,255,64,0,11,255,64,0,63,245,0,0,191,128,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,254,0,0,1,254,0,0,27,253,0,0,191,252,0,0,191,224,0,0,185,0,0,0,
  // 0x007e  ~
  18,6,30,21,2,10,6,164,0,0,0,127,255,144,0,208,255,255,254,175,208,249,111,255,255,192,192,0,191,255,64,0,0,5,164,0,
  // 0x007f - 0x009a  Control Characters
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00a0 "�"
  0,0,0,10,0,0,
  // 0x00a1  ¡
  6,27,54,10,2,249,47,128,127,208,127,224,127,208,47,128,0,0,0,0,0,0,31,64,31,128,31,128,47,128,47,128,47,128,47,192,47,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,208,42,128,
  // 0x00a2  ¢
  15,28,112,21,3,255,0,1,240,0,0,2,240,0,0,2,240,0,0,7,254,144,0,191,255,252,7,255,255,248,15,255,150,244,47,244,0,16,63,208,0,0,127,192,0,0,191,64,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,64,0,0,191,64,0,0,127,192,0,0,63,208,0,0,47,244,0,20,15,255,170,252,7,255,255,252,0,255,255,248,0,7,254,64,0,2,240,0,0,2,240,0,0,2,240,0,0,0,80,0,
  // 0x00a3  £
  19,27,135,21,1,0,0,0,106,164,0,0,7,255,255,224,0,31,255,255,240,0,63,250,175,208,0,191,128,1,128,0,255,0,0,0,0,255,0,0,0,0,254,0,0,0,0,254,0,0,0,0,254,0,0,0,0,254,0,0,0,0,254,0,0,0,107,255,170,168,0,191,255,255,252,0,191,255,255,252,0,1,255,0,0,0,0,254,0,0,0,0,254,0,0,0,0,254,0,0,0,0,254,0,0,0,1,254,0,0,0,3,252,0,0,0,11,244,0,0,0,127,229,85,85,84,191,255,255,255,252,191,255,255,255,252,191,255,255,255,252,
  // 0x00a4  ¤
  17,17,85,21,2,4,44,0,64,15,0,191,111,254,127,128,63,255,255,255,0,15,254,175,252,0,11,240,2,252,0,15,192,0,253,0,31,64,0,126,0,47,64,0,63,0,47,64,0,63,0,31,128,0,126,0,15,192,0,253,0,11,240,3,252,0,15,255,191,252,0,63,255,255,255,0,191,31,253,63,128,44,0,0,14,0,0,0,0,0,0,
  // 0x00a5  ¥
  19,27,135,21,1,0,85,0,0,0,84,255,0,0,3,252,191,64,0,7,248,63,192,0,15,240,47,208,0,31,224,15,240,0,63,192,11,244,0,127,128,3,252,0,255,0,1,253,1,253,0,0,255,3,252,0,0,127,71,244,0,0,63,207,240,0,0,31,239,208,0,0,15,255,192,0,6,175,255,234,64,11,255,255,255,128,11,255,255,255,128,0,1,253,0,0,0,1,253,0,0,0,1,254,0,0,11,255,255,255,128,11,255,255,255,128,5,86,254,85,64,0,1,253,0,0,0,1,253,0,0,0,1,253,0,0,0,1,253,0,0,
  // 0x00a6  ¦
  4,37,37,20,8,247,126,126,126,126,126,126,126,126,126,126,126,126,126,126,0,0,0,0,0,0,0,0,41,126,126,126,126,126,126,126,126,126,126,126,126,126,126,
  // 0x00a7  §
  15,30,120,19,2,255,0,1,64,0,2,255,255,128,15,255,255,240,63,233,175,224,127,64,0,128,127,0,0,0,127,64,0,0,63,208,0,0,31,254,0,0,7,255,224,0,11,255,254,0,47,214,255,192,63,0,47,240,126,0,7,240,190,0,3,244,127,0,3,244,63,192,3,240,47,248,11,240,11,255,255,192,0,191,255,0,0,11,255,192,0,0,127,240,0,0,11,240,0,0,3,244,0,0,3,244,224,0,15,240,255,170,191,224,255,255,255,128,47,255,248,0,0,0,0,0,
  // 0x00a8  ¨
  12,4,12,22,5,23,127,0,252,191,66,253,127,1,252,41,0,164,
  // 0x00a9  ©
  27,28,196,31,2,255,0,0,22,186,64,0,0,0,2,255,255,253,0,0,0,31,249,85,191,192,0,0,191,64,0,7,244,0,2,244,0,0,0,253,0,7,208,0,89,0,47,0,15,64,11,255,244,15,192,46,0,63,255,240,3,208,60,0,255,0,96,2,240,188,2,252,0,0,0,244,244,3,240,0,0,0,248,240,3,240,0,0,0,188,240,7,224,0,0,0,124,240,7,224,0,0,0,124,240,7,224,0,0,0,124,240,7,224,0,0,0,124,244,3,240,0,0,0,184,184,3,244,0,0,0,244,124,1,252,0,0,0,240,61,0,255,149,176,2,240,47,0,63,255,240,7,208,15,192,7,255,208,15,192,3,240,0,0,0,63,0,1,253,0,0,1,252,0,0,127,144,0,31,240,0,0,11,255,239,255,128,0,0,0,191,255,244,0,0,0,0,0,84,0,0,0,
  // 0x00aa  ª
  11,14,42,14,1,13,1,170,0,63,255,224,47,155,244,0,1,248,0,0,248,1,171,248,47,255,248,127,64,248,252,0,248,252,1,248,253,11,248,127,255,184,31,244,56,0,0,0,
  // 0x00ab  «
  17,17,85,20,1,1,0,5,0,5,0,0,15,192,31,192,0,63,192,63,192,0,255,64,255,0,2,253,3,253,0,11,248,11,248,0,31,240,31,224,0,63,192,127,192,0,127,192,191,128,0,47,224,47,224,0,11,244,15,244,0,3,253,3,252,0,0,255,0,255,0,0,127,192,127,128,0,31,208,47,192,0,10,0,10,0,0,0,0,0,0,
  // 0x00ac  ¬
  18,11,55,21,2,4,170,170,170,170,128,255,255,255,255,208,255,255,255,255,208,85,85,85,95,208,0,0,0,11,208,0,0,0,11,208,0,0,0,11,208,0,0,0,11,208,0,0,0,11,208,0,0,0,11,208,0,0,0,1,64,
  // 0x00ad  ­
  10,4,12,12,1,8,106,170,144,191,255,224,191,255,224,127,255,208,
  // 0x00ae  ®
  27,28,196,31,2,255,0,0,22,186,64,0,0,0,2,255,255,253,0,0,0,31,249,85,191,192,0,0,191,64,0,7,244,0,2,244,0,0,0,253,0,7,208,21,80,0,47,0,15,64,191,255,128,15,192,46,0,191,255,240,3,208,60,0,188,7,248,2,240,188,0,188,0,252,0,244,244,0,188,0,252,0,248,240,0,188,0,252,0,188,240,0,188,3,244,0,124,240,0,191,255,224,0,124,240,0,191,255,64,0,124,240,0,190,175,64,0,124,244,0,188,15,192,0,184,184,0,188,7,224,0,244,124,0,188,3,244,0,240,61,0,188,1,252,2,240,47,0,188,0,189,7,208,15,192,188,0,63,15,192,3,240,0,0,0,63,0,1,253,0,0,1,252,0,0,127,144,0,31,240,0,0,11,255,239,255,128,0,0,0,191,255,244,0,0,0,0,0,84,0,0,0,
  // 0x00af  ¯
  19,3,15,19,0,28,255,255,255,255,248,255,255,255,255,248,255,255,255,255,248,
  // 0x00b0  °
  12,12,36,16,2,15,1,170,64,15,255,224,63,255,252,190,0,253,252,0,63,248,0,63,248,0,63,252,0,63,190,0,189,63,235,252,31,255,240,1,254,64,
  // 0x00b1  ±
  18,23,115,21,2,0,0,1,80,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,1,80,0,0,0,0,0,0,0,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,
  // 0x00b2  ²
  11,17,51,13,1,15,1,101,0,31,255,192,191,255,240,125,7,244,16,2,248,0,2,248,0,3,244,0,7,240,0,15,192,0,63,64,0,253,0,7,244,0,31,208,0,127,64,0,255,255,248,255,255,248,170,170,164,
  // 0x00b3  ³
  11,17,51,13,1,15,1,101,0,47,255,192,255,255,240,120,3,244,0,2,248,0,2,244,0,3,240,10,191,192,15,255,64,6,175,240,0,2,248,0,0,252,0,0,252,128,2,252,254,175,244,255,255,224,27,254,0,
  // 0x00b4  ´
  9,7,21,11,1,22,0,85,64,1,255,64,3,253,0,11,248,0,31,208,0,63,64,0,104,0,0,
  // 0x00b5  µ
  18,29,145,23,3,247,255,0,0,31,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,63,208,255,64,0,127,208,255,128,0,255,208,255,224,7,255,208,255,255,255,239,208,255,255,255,143,208,255,63,253,15,208,255,1,64,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,
  // 0x00b6  ¶
  19,33,165,24,2,251,0,127,255,255,248,7,255,255,255,248,31,255,255,213,248,63,255,255,128,248,127,255,255,128,248,191,255,255,128,248,255,255,255,128,248,255,255,255,128,248,255,255,255,128,248,255,255,255,128,248,255,255,255,128,248,255,255,255,128,248,191,255,255,128,248,127,255,255,128,248,63,255,255,128,248,31,255,255,128,248,11,255,255,128,248,1,191,255,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,15,128,248,0,0,10,64,164,
  // 0x00b7  ·
  6,6,12,10,2,10,26,64,63,208,127,224,127,208,63,192,5,0,
  // 0x00b8  ¸
  8,9,18,8,0,247,7,192,15,192,31,244,6,253,0,190,0,126,86,253,255,248,191,144,
  // 0x00b9  ¹
  9,16,48,13,1,15,0,191,64,3,255,64,31,255,64,127,111,64,44,47,64,0,47,64,0,63,64,0,63,64,0,63,64,0,63,64,0,63,64,0,63,64,0,63,64,0,63,64,0,63,64,0,26,0,
  // 0x00ba  º
  12,14,42,14,1,13,0,170,0,11,255,224,47,235,248,126,0,189,188,0,62,252,0,63,252,0,63,252,0,63,188,0,62,125,0,125,63,150,252,15,255,240,2,255,128,0,0,0,
  // 0x00bb  »
  18,17,85,20,1,1,5,0,5,0,0,63,64,63,0,0,63,192,63,192,0,15,240,31,240,0,7,252,7,248,0,2,254,2,253,0,0,191,64,255,64,0,63,208,63,192,0,47,208,63,208,0,191,128,191,128,1,255,1,254,0,3,252,7,252,0,15,240,15,240,0,63,208,63,192,0,127,128,127,64,0,10,0,10,0,0,0,0,0,0,0,
  // 0x00bc  ¼
  27,27,189,28,1,0,0,21,0,0,0,84,0,1,255,0,0,3,244,0,11,255,0,0,7,240,0,63,255,0,0,15,192,0,191,63,0,0,47,128,0,56,63,0,0,63,0,0,0,63,0,0,253,0,0,0,63,0,1,252,0,0,0,63,0,3,240,0,0,0,63,0,11,224,0,0,0,63,0,15,192,0,0,0,63,0,63,64,47,192,0,63,0,127,0,127,192,0,63,0,252,0,255,192,0,63,2,248,2,255,192,0,63,3,240,7,223,192,0,21,15,208,15,159,192,0,0,31,192,47,31,192,0,0,63,64,124,31,192,0,0,190,0,248,31,192,0,0,252,2,240,31,192,0,2,244,7,255,255,252,0,7,240,7,255,255,252,0,15,208,6,170,191,232,0,47,128,0,0,31,192,0,63,0,0,0,31,192,0,190,0,0,0,31,192,
  // 0x00bd  ½
  27,27,189,30,1,0,0,21,0,0,1,80,0,1,254,0,0,11,224,0,11,254,0,0,15,192,0,127,254,0,0,63,64,0,254,126,0,0,127,0,0,116,126,0,0,252,0,0,0,126,0,2,248,0,0,0,126,0,3,240,0,0,0,126,0,15,208,0,0,0,126,0,31,192,0,0,0,126,0,63,0,0,0,0,126,0,190,7,255,128,0,126,0,252,63,255,240,0,126,3,244,63,155,248,0,126,7,240,24,1,252,0,126,15,208,0,0,252,0,21,47,128,0,1,252,0,0,63,0,0,2,244,0,0,189,0,0,7,240,0,1,252,0,0,31,192,0,3,244,0,0,127,0,0,11,224,0,1,252,0,0,15,192,0,7,240,0,0,47,128,0,31,192,0,0,127,0,0,127,234,168,0,253,0,0,191,255,252,1,248,0,0,191,255,252,
  // 0x00be  ¾
  29,27,216,30,1,0,6,169,0,0,0,21,0,0,127,255,208,0,0,127,0,0,255,175,240,0,0,253,0,0,52,3,248,0,2,248,0,0,0,1,248,0,3,240,0,0,0,2,244,0,11,224,0,0,0,7,240,0,31,192,0,0,11,255,192,0,63,64,0,0,11,255,128,0,190,0,0,0,5,91,244,0,252,0,0,0,0,1,252,2,248,0,0,0,0,0,252,7,240,7,240,0,0,0,252,15,208,15,240,0,208,2,252,31,192,63,240,0,255,191,244,63,0,191,240,0,255,255,208,190,0,247,240,0,22,169,1,252,3,227,240,0,0,0,3,244,11,195,240,0,0,0,7,240,31,67,240,0,0,0,15,192,62,3,240,0,0,0,47,128,188,3,240,0,0,0,63,0,255,255,255,0,0,0,253,1,255,255,255,64,0,1,252,0,170,171,250,0,0,3,244,0,0,3,240,0,0,11,224,0,0,3,240,0,0,15,192,0,0,3,240,0,
  // 0x00bf  ¿
  15,28,112,17,1,248,0,3,244,0,0,15,252,0,0,15,252,0,0,15,252,0,0,3,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,244,0,0,3,244,0,0,3,244,0,0,11,240,0,0,31,224,0,0,191,192,0,2,255,0,0,15,252,0,0,47,240,0,0,127,192,0,0,255,0,0,0,255,0,0,0,254,0,0,0,255,0,0,0,255,64,0,96,127,229,91,244,63,255,255,252,11,255,255,244,1,191,254,64,0,0,0,0,
  // 0x00c0  À
  24,35,210,24,0,0,0,1,84,0,0,0,0,3,255,0,0,0,0,0,255,64,0,0,0,0,63,192,0,0,0,0,15,240,0,0,0,0,3,248,0,0,0,0,0,168,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x00c1  Á
  24,35,210,24,0,0,0,0,0,5,80,0,0,0,0,63,240,0,0,0,0,127,192,0,0,0,0,255,0,0,0,0,3,252,0,0,0,0,11,224,0,0,0,0,10,64,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x00c2  Â
  24,35,210,24,0,0,0,0,5,80,0,0,0,0,47,248,0,0,0,0,127,253,0,0,0,1,254,191,64,0,0,3,248,47,192,0,0,15,208,7,240,0,0,26,0,0,164,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x00c3  Ã
  24,34,204,24,0,0,0,0,80,0,20,0,0,3,255,64,124,0,0,15,255,245,248,0,0,31,175,255,240,0,0,46,1,255,208,0,0,40,0,25,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x00c4  Ä
  24,33,198,24,0,0,0,3,240,15,192,0,0,7,244,31,224,0,0,7,244,15,208,0,0,1,160,6,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,160,0,0,0,0,31,248,0,0,0,0,47,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x00c5  Å
  24,33,198,24,0,0,0,0,1,64,0,0,0,0,47,248,0,0,0,0,190,190,0,0,0,0,244,31,0,0,0,0,240,15,0,0,0,0,244,31,0,0,0,0,191,255,0,0,0,0,63,252,0,0,0,0,63,252,0,0,0,0,63,253,0,0,0,0,127,254,0,0,0,0,254,191,0,0,0,1,253,63,64,0,0,2,252,63,192,0,0,3,252,47,192,0,0,7,244,15,224,0,0,15,240,15,240,0,0,15,224,11,244,0,0,47,208,3,248,0,0,63,192,3,252,0,0,127,128,1,253,0,0,191,64,0,255,0,0,255,255,255,255,0,1,255,255,255,255,128,3,255,255,255,255,192,3,253,85,85,127,208,11,248,0,0,31,224,15,240,0,0,15,240,31,240,0,0,11,244,47,208,0,0,7,252,63,192,0,0,3,252,127,128,0,0,2,254,255,64,0,0,0,255,
  // 0x00c6  Æ
  31,27,216,33,0,0,0,0,0,85,85,85,85,84,0,0,0,255,255,255,255,252,0,0,2,255,255,255,255,252,0,0,3,255,255,255,255,252,0,0,11,244,127,192,0,0,0,0,15,240,63,192,0,0,0,0,31,208,63,192,0,0,0,0,63,192,63,192,0,0,0,0,127,128,63,192,0,0,0,0,255,0,63,192,0,0,0,1,254,0,63,192,0,0,0,3,252,0,63,213,85,80,0,7,248,0,63,255,255,244,0,11,244,0,63,255,255,244,0,15,240,0,63,255,255,244,0,47,208,0,127,192,0,0,0,63,255,255,255,192,0,0,0,191,255,255,255,192,0,0,0,255,255,255,255,192,0,0,2,254,85,85,191,192,0,0,3,252,0,0,63,192,0,0,7,248,0,0,63,192,0,0,15,240,0,0,63,192,0,0,31,224,0,0,63,213,85,84,63,192,0,0,63,255,255,252,127,192,0,0,63,255,255,252,255,64,0,0,63,255,255,252,
  // 0x00c7  Ç
  20,36,180,23,2,247,0,0,26,234,64,0,7,255,255,253,0,47,255,255,255,0,255,255,175,253,3,255,208,0,108,11,254,0,0,0,15,248,0,0,0,47,240,0,0,0,63,208,0,0,0,127,192,0,0,0,127,192,0,0,0,191,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,128,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,208,0,0,0,47,240,0,0,0,15,248,0,0,0,11,254,0,0,0,3,255,228,1,188,0,255,255,255,252,0,47,255,255,252,0,2,255,255,244,0,0,11,212,0,0,0,15,128,0,0,0,31,244,0,0,0,6,252,0,0,0,0,190,0,0,0,0,190,0,0,0,150,253,0,0,0,255,248,0,0,0,191,144,0,
  // 0x00c8  È
  16,35,140,21,3,0,1,84,0,0,2,255,0,0,0,255,128,0,0,63,208,0,0,15,240,0,0,2,248,0,0,0,104,0,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x00c9  É
  16,35,140,21,3,0,0,0,5,80,0,0,47,240,0,0,127,192,0,0,255,0,0,2,252,0,0,7,240,0,0,10,128,0,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x00ca  Ê
  16,35,140,21,3,0,0,5,80,0,0,31,252,0,0,127,254,0,0,255,191,128,3,252,31,208,15,224,7,244,26,64,0,168,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x00cb  Ë
  16,33,132,21,3,0,3,244,15,208,3,248,15,224,3,248,15,224,1,160,6,128,0,0,0,0,0,0,0,0,21,85,85,84,127,255,255,253,127,255,255,253,127,255,255,253,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,248,127,255,255,248,127,255,255,248,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,149,85,84,127,255,255,253,127,255,255,253,127,255,255,253,
  // 0x00cc  Ì
  11,35,105,13,1,0,85,64,0,127,192,0,47,240,0,11,248,0,2,253,0,0,127,0,0,26,64,0,0,0,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,
  // 0x00cd  Í
  12,35,105,13,1,0,0,1,85,0,7,253,0,15,244,0,47,208,0,127,64,0,253,0,1,160,0,0,0,0,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,
  // 0x00ce  Î
  13,35,140,13,0,0,0,21,64,0,0,255,192,0,3,255,240,0,11,251,252,0,47,192,254,0,191,0,63,128,164,0,6,128,0,0,0,0,21,85,85,0,47,255,254,0,47,255,254,0,2,255,224,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,127,128,0,0,191,128,0,11,255,249,0,47,255,254,0,47,255,254,0,
  // 0x00cf  Ï
  11,33,99,13,1,0,190,1,248,255,3,252,255,2,252,40,0,160,0,0,0,0,0,0,85,85,84,191,255,248,191,255,248,11,255,128,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,1,254,0,2,254,0,47,255,228,191,255,248,191,255,248,
  // 0x00d0  Ð
  24,27,162,27,1,0,1,85,85,64,0,0,7,255,255,255,64,0,7,255,255,255,244,0,7,255,255,255,254,0,7,248,0,27,255,192,7,248,0,0,191,224,7,248,0,0,47,244,7,248,0,0,15,252,7,248,0,0,7,252,7,248,0,0,3,253,7,248,0,0,2,254,7,248,0,0,1,255,191,255,255,64,1,255,255,255,255,128,1,255,255,255,255,128,1,255,171,254,170,64,1,255,7,248,0,0,2,254,7,248,0,0,3,253,7,248,0,0,3,252,7,248,0,0,11,252,7,248,0,0,31,244,7,248,0,0,127,240,7,248,0,2,255,192,7,253,85,191,255,64,7,255,255,255,252,0,7,255,255,255,208,0,7,255,255,228,0,0,
  // 0x00d1  Ñ
  22,34,204,29,3,0,0,0,80,0,80,0,0,11,253,0,240,0,0,47,255,215,240,0,0,63,175,255,208,0,0,124,2,255,128,0,0,100,0,25,0,0,0,0,0,0,0,0,21,64,0,0,1,80,127,240,0,0,11,240,127,248,0,0,11,240,127,252,0,0,11,240,127,255,0,0,11,240,127,255,64,0,11,240,127,127,192,0,11,240,127,63,224,0,11,240,127,15,244,0,11,240,127,11,252,0,11,240,127,3,254,0,11,240,127,1,255,0,11,240,127,0,191,192,11,240,127,0,63,208,11,240,127,0,31,240,7,240,127,0,15,248,7,240,127,0,3,253,7,240,127,0,2,255,7,240,127,0,0,255,135,240,127,0,0,127,199,240,127,0,0,47,247,240,127,0,0,15,251,240,127,0,0,7,255,240,127,0,0,3,255,240,127,0,0,0,255,240,127,0,0,0,191,240,127,0,0,0,63,240,
  // 0x00d2  Ò
  25,36,252,29,2,255,0,1,85,0,0,0,0,0,1,255,0,0,0,0,0,0,191,192,0,0,0,0,0,47,224,0,0,0,0,0,11,244,0,0,0,0,0,1,252,0,0,0,0,0,0,105,0,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x00d3  Ó
  25,36,252,29,2,255,0,0,0,5,84,0,0,0,0,0,31,244,0,0,0,0,0,63,208,0,0,0,0,0,191,64,0,0,0,0,1,253,0,0,0,0,0,3,244,0,0,0,0,0,6,128,0,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x00d4  Ô
  25,36,252,29,2,255,0,0,5,80,0,0,0,0,0,15,252,0,0,0,0,0,63,255,0,0,0,0,0,255,191,192,0,0,0,2,252,31,224,0,0,0,11,240,3,248,0,0,0,10,64,0,104,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x00d5  Õ
  25,35,245,29,2,255,0,0,20,0,20,0,0,0,2,255,128,61,0,0,0,7,255,249,188,0,0,0,15,235,255,248,0,0,0,31,0,191,240,0,0,0,9,0,6,64,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x00d6  Ö
  25,34,238,29,2,255,0,2,248,7,224,0,0,0,3,252,15,240,0,0,0,3,252,11,240,0,0,0,0,160,2,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,107,250,64,0,0,0,11,255,255,248,0,0,0,127,255,255,255,64,0,1,255,254,175,255,208,0,3,255,128,0,127,240,0,15,252,0,0,15,252,0,31,244,0,0,3,253,0,63,224,0,0,2,255,0,63,208,0,0,0,255,0,127,192,0,0,0,255,64,191,128,0,0,0,191,128,191,128,0,0,0,191,128,191,128,0,0,0,127,192,255,64,0,0,0,127,192,255,64,0,0,0,127,192,191,128,0,0,0,127,128,191,128,0,0,0,191,128,127,192,0,0,0,255,64,63,192,0,0,0,255,64,63,208,0,0,1,255,0,47,240,0,0,3,254,0,15,248,0,0,11,252,0,11,254,0,0,47,248,0,3,255,224,2,255,240,0,0,255,255,255,255,192,0,0,47,255,255,254,0,0,0,2,255,255,224,0,0,0,0,5,84,0,0,0,
  // 0x00d7  ×
  16,17,68,21,3,4,116,0,0,52,253,0,0,253,255,64,3,252,63,208,15,240,15,244,63,192,3,253,255,0,0,255,252,0,0,63,240,0,0,63,244,0,0,255,253,0,3,253,255,64,15,240,63,208,63,192,15,240,255,0,3,252,252,0,0,252,48,0,0,48,0,0,0,0,
  // 0x00d8  Ø
  25,30,210,29,2,254,0,0,0,0,0,64,0,0,0,107,250,64,244,0,0,11,255,255,251,252,0,0,127,255,255,255,240,0,1,255,254,175,255,224,0,3,255,128,0,191,240,0,15,252,0,0,191,252,0,31,244,0,0,255,253,0,63,224,0,3,250,255,0,63,208,0,11,240,255,0,127,192,0,31,192,255,64,191,128,0,63,128,191,128,191,128,0,191,0,191,128,191,128,1,252,0,127,128,255,64,3,244,0,127,192,191,64,15,224,0,127,192,191,128,47,192,0,127,128,191,128,63,64,0,191,128,127,192,254,0,0,255,64,63,194,252,0,0,255,64,63,215,244,0,1,255,0,47,255,224,0,3,254,0,15,255,192,0,11,252,0,11,255,64,0,47,248,0,3,255,228,2,255,240,0,2,255,255,255,255,192,0,7,255,255,255,254,0,0,15,210,255,255,224,0,0,3,128,1,84,0,0,0,0,0,0,0,0,0,0,
  // 0x00d9  Ù
  21,36,216,27,3,255,0,5,80,0,0,0,0,31,244,0,0,0,0,7,252,0,0,0,0,1,254,0,0,0,0,0,127,64,0,0,0,0,31,192,0,0,0,0,2,144,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x00da  Ú
  21,36,216,27,3,255,0,0,0,85,64,0,0,0,1,255,64,0,0,0,3,254,0,0,0,0,11,248,0,0,0,0,31,224,0,0,0,0,63,64,0,0,0,0,105,0,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x00db  Û
  21,36,216,27,3,255,0,0,21,64,0,0,0,0,255,208,0,0,0,3,255,240,0,0,0,11,251,252,0,0,0,47,208,255,0,0,0,127,0,47,128,0,0,168,0,6,128,0,0,0,0,0,0,0,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x00dc  Ü
  21,34,204,27,3,255,0,31,128,126,0,0,0,63,192,191,0,0,0,47,192,191,0,0,0,10,64,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,128,0,0,63,192,127,192,0,0,127,128,63,208,0,0,255,64,47,240,0,2,255,0,15,254,64,31,253,0,7,255,255,255,244,0,0,255,255,255,208,0,0,31,255,254,0,0,0,0,21,64,0,0,
  // 0x00dd  Ý
  21,35,210,22,0,0,0,0,0,85,64,0,0,0,0,255,128,0,0,0,3,254,0,0,0,0,7,248,0,0,0,0,15,224,0,0,0,0,63,128,0,0,0,0,41,0,0,0,0,0,0,0,0,0,85,0,0,0,21,64,191,192,0,0,63,192,63,208,0,0,191,128,31,240,0,1,255,0,15,244,0,3,253,0,7,252,0,7,252,0,3,253,0,15,244,0,1,255,0,31,240,0,0,191,64,63,208,0,0,63,192,127,128,0,0,47,224,255,0,0,0,15,241,254,0,0,0,11,251,252,0,0,0,3,255,248,0,0,0,1,255,240,0,0,0,0,255,208,0,0,0,0,127,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,
  // 0x00de  Þ
  18,27,135,23,3,0,21,0,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,255,254,64,0,127,255,255,248,0,127,255,255,255,0,127,149,111,255,128,127,128,0,255,192,127,128,0,63,208,127,128,0,47,224,127,128,0,31,240,127,128,0,31,240,127,128,0,31,224,127,128,0,63,208,127,128,0,127,192,127,128,7,255,128,127,255,255,255,0,127,255,255,248,0,127,255,255,144,0,127,149,80,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,
  // 0x00df  ß
  20,30,150,24,3,255,0,0,80,0,0,0,191,255,224,0,11,255,255,253,0,47,255,255,255,64,127,224,1,255,192,191,128,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,128,255,0,1,255,0,255,0,11,252,0,255,0,47,240,0,255,0,127,192,0,255,0,191,0,0,255,0,191,64,0,255,0,191,208,0,255,0,63,248,0,255,0,15,255,0,255,0,2,255,208,255,0,0,127,244,255,0,0,15,252,255,0,0,3,253,255,0,0,1,254,255,0,0,1,254,255,0,0,1,254,255,3,64,3,253,255,3,254,191,252,255,3,255,255,240,255,1,255,255,128,0,0,5,80,0,
  // 0x00e0  à
  18,30,150,21,1,255,0,85,64,0,0,0,127,208,0,0,0,31,240,0,0,0,7,248,0,0,0,1,253,0,0,0,0,127,0,0,0,0,10,64,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x00e1  á
  18,30,150,21,1,255,0,0,1,85,0,0,0,7,253,0,0,0,15,244,0,0,0,47,224,0,0,0,127,64,0,0,0,253,0,0,0,1,160,0,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x00e2  â
  18,30,150,21,1,255,0,0,85,0,0,0,3,255,64,0,0,15,255,192,0,0,47,239,240,0,0,191,67,252,0,1,252,0,254,0,2,160,0,26,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x00e3  ã
  18,29,145,21,1,255,0,5,0,1,64,0,127,224,15,128,1,255,254,111,0,3,250,255,255,0,3,192,47,252,0,2,128,1,144,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x00e4  ä
  18,28,140,21,1,255,0,126,1,248,0,0,255,2,252,0,0,191,2,252,0,0,40,0,164,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x00e5  å
  18,32,160,21,1,255,0,0,84,0,0,0,7,255,64,0,0,15,239,208,0,0,31,3,224,0,0,46,1,240,0,0,31,2,224,0,0,15,155,208,0,0,7,255,128,0,0,0,100,0,0,0,0,0,0,0,0,0,20,0,0,0,111,255,228,0,3,255,255,254,0,3,255,255,255,64,1,228,0,255,192,0,0,0,63,192,0,0,0,47,192,0,0,0,47,208,0,0,0,47,208,0,27,255,255,208,2,255,255,255,208,15,255,169,127,208,47,244,0,47,208,63,192,0,47,208,63,192,0,63,208,127,128,0,63,208,63,192,0,191,208,63,224,2,255,208,47,254,191,239,208,15,255,255,79,208,2,255,252,11,208,0,5,64,0,0,
  // 0x00e6  æ
  30,22,176,33,1,255,0,0,16,0,0,20,0,0,0,127,255,208,11,255,208,0,7,255,255,248,127,255,248,0,3,255,255,254,255,239,255,0,2,208,1,255,252,0,255,64,0,0,0,127,240,0,63,192,0,0,0,63,224,0,47,208,0,0,0,63,192,0,31,224,0,0,0,63,192,0,31,224,0,27,255,255,255,255,255,224,2,255,255,255,255,255,255,240,15,255,165,127,255,255,255,224,47,244,0,63,192,0,0,0,63,192,0,63,192,0,0,0,127,192,0,63,208,0,0,0,127,128,0,191,224,0,0,0,63,192,0,255,244,0,0,0,63,224,7,251,254,0,6,192,47,254,191,225,255,255,255,192,15,255,255,128,127,255,255,192,2,255,253,0,11,255,254,0,0,5,64,0,0,21,0,0,
  // 0x00e7  ç
  15,30,120,18,2,247,0,0,84,0,0,47,255,228,2,255,255,248,11,255,255,244,31,253,1,176,63,224,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,192,0,0,63,208,0,0,47,248,0,120,15,255,255,248,2,255,255,248,0,127,255,224,0,3,244,0,0,3,224,0,0,11,252,0,0,1,255,0,0,0,63,64,0,0,63,64,0,37,191,0,0,63,253,0,0,63,224,0,
  // 0x00e8  è
  18,30,150,21,2,255,0,85,0,0,0,1,255,64,0,0,0,127,192,0,0,0,31,224,0,0,0,7,244,0,0,0,1,252,0,0,0,0,41,0,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x00e9  é
  18,30,150,21,2,255,0,0,5,84,0,0,0,31,244,0,0,0,63,224,0,0,0,191,128,0,0,1,254,0,0,0,3,244,0,0,0,6,144,0,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x00ea  ê
  18,30,150,21,2,255,0,1,84,0,0,0,15,253,0,0,0,63,255,0,0,0,191,191,192,0,2,253,15,240,0,7,240,2,248,0,10,128,0,104,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x00eb  ë
  18,28,140,21,2,255,1,248,7,224,0,3,252,11,240,0,2,252,11,240,0,0,164,2,144,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,47,255,128,0,2,255,255,244,0,11,255,255,253,0,31,244,1,255,0,63,192,0,191,128,127,128,0,63,192,191,64,0,47,192,255,0,0,47,208,255,255,255,255,208,255,255,255,255,208,255,255,255,255,208,255,0,0,0,0,255,0,0,0,0,191,64,0,0,0,127,192,0,0,0,63,224,0,0,0,31,248,0,11,64,11,255,255,255,64,2,255,255,255,64,0,47,255,249,0,0,0,85,0,0,
  // 0x00ec  ì
  8,29,58,10,0,0,85,0,255,128,63,208,15,240,3,248,0,253,0,42,0,0,0,0,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,
  // 0x00ed  í
  8,29,58,10,3,0,0,85,3,255,11,252,15,240,63,192,190,0,164,0,0,0,0,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,
  // 0x00ee  î
  14,29,116,10,254,0,0,21,64,0,0,191,224,0,1,255,244,0,7,250,253,0,15,224,191,0,63,64,31,192,104,0,2,144,0,0,0,0,0,0,0,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,
  // 0x00ef  ï
  12,27,81,10,255,0,63,0,252,127,65,253,127,64,253,25,0,104,0,0,0,0,0,0,0,0,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,
  // 0x00f0  ð
  19,29,145,23,2,255,0,30,0,29,0,0,63,208,191,0,0,47,255,254,0,0,7,255,240,0,0,3,255,208,0,0,47,255,240,0,0,255,199,252,0,0,125,1,254,0,0,16,0,191,64,0,0,0,63,192,0,6,165,31,208,0,255,255,223,224,7,255,255,255,240,31,254,91,255,240,63,224,0,127,244,127,192,0,31,248,191,64,0,15,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,244,255,0,0,11,240,191,128,0,15,240,63,192,0,47,224,47,244,0,191,192,15,255,239,255,64,2,255,255,252,0,0,111,255,224,0,0,0,84,0,0,
  // 0x00f1  ñ
  18,28,140,23,3,0,0,20,0,5,0,1,255,128,62,0,7,255,249,188,0,15,235,255,252,0,15,0,191,240,0,10,0,6,64,0,0,0,0,0,0,0,0,4,0,0,253,7,255,244,0,253,63,255,254,0,255,255,255,255,64,255,248,1,255,192,255,208,0,127,192,255,192,0,63,192,255,64,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,255,0,0,47,208,
  // 0x00f2  ò
  19,30,150,23,2,255,0,85,0,0,0,0,191,192,0,0,0,63,224,0,0,0,15,244,0,0,0,2,252,0,0,0,0,190,0,0,0,0,26,0,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x00f3  ó
  19,30,150,23,2,255,0,0,1,84,0,0,0,11,252,0,0,0,31,240,0,0,0,63,192,0,0,0,191,0,0,0,1,252,0,0,0,1,160,0,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x00f4  ô
  19,30,150,23,2,255,0,1,84,0,0,0,7,255,0,0,0,15,255,128,0,0,63,239,224,0,0,255,7,244,0,3,248,1,253,0,2,144,0,42,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x00f5  õ
  19,29,145,23,2,255,0,5,0,5,0,0,255,208,15,0,2,255,253,127,0,3,251,255,253,0,11,192,63,248,0,6,64,1,64,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x00f6  ö
  19,28,140,23,2,255,0,253,2,244,0,0,254,3,248,0,0,254,3,248,0,0,104,1,160,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,47,255,208,0,2,255,255,252,0,11,255,255,255,0,31,248,1,255,192,63,208,0,63,208,127,192,0,31,240,191,64,0,15,240,255,0,0,11,244,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,7,248,255,0,0,11,244,191,64,0,15,240,127,192,0,31,240,63,208,0,63,224,31,248,1,255,192,11,255,255,255,0,1,255,255,252,0,0,47,255,208,0,0,0,84,0,0,
  // 0x00f7  ÷
  18,18,90,21,2,4,0,1,144,0,0,0,7,244,0,0,0,11,248,0,0,0,11,248,0,0,0,3,240,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,128,255,255,255,255,208,255,255,255,255,208,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,3,240,0,0,0,11,248,0,0,0,11,248,0,0,0,7,244,0,0,0,1,144,0,0,
  // 0x00f8  ø
  19,23,115,23,2,254,0,0,16,3,0,0,47,255,219,208,2,255,255,255,192,11,255,255,255,64,31,248,1,255,192,63,208,1,255,208,127,192,3,255,240,191,64,15,239,240,255,0,47,203,244,255,0,127,11,248,255,0,253,7,248,255,2,252,7,248,255,7,240,7,248,255,15,208,11,244,191,127,128,15,240,127,255,0,31,240,63,253,0,63,224,31,252,1,255,192,15,255,255,255,0,31,255,255,252,0,63,175,255,208,0,14,0,84,0,0,0,0,0,0,0,
  // 0x00f9  ù
  17,30,150,23,3,255,0,85,0,0,0,1,255,64,0,0,0,127,192,0,0,0,31,224,0,0,0,7,244,0,0,0,1,252,0,0,0,0,41,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x00fa  ú
  17,30,150,23,3,255,0,0,5,84,0,0,0,31,244,0,0,0,63,224,0,0,0,191,128,0,0,1,254,0,0,0,3,244,0,0,0,6,144,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x00fb  û
  17,30,150,23,3,255,0,1,84,0,0,0,15,253,0,0,0,63,255,0,0,0,191,191,192,0,2,253,15,240,0,7,240,3,248,0,10,128,0,104,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x00fc  ü
  17,28,140,23,3,255,1,248,7,224,0,3,252,11,240,0,2,252,11,240,0,0,160,2,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,47,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,128,0,255,192,191,208,7,255,192,63,255,255,239,192,31,255,255,79,192,2,255,248,15,192,0,21,0,0,0,
  // 0x00fd  ý
  20,38,190,20,0,247,0,0,1,85,0,0,0,3,254,0,0,0,15,248,0,0,0,31,224,0,0,0,63,128,0,0,0,254,0,0,0,0,164,0,0,0,0,0,0,0,0,0,0,0,0,191,64,0,3,253,127,192,0,3,252,63,192,0,11,248,47,224,0,15,240,15,240,0,31,240,15,240,0,47,208,7,248,0,63,192,3,252,0,127,128,2,253,0,191,64,0,254,0,255,0,0,255,1,254,0,0,127,66,252,0,0,63,195,252,0,0,47,199,244,0,0,15,219,240,0,0,15,239,224,0,0,7,255,208,0,0,3,255,192,0,0,2,255,128,0,0,0,255,0,0,0,0,255,0,0,0,2,253,0,0,0,3,252,0,0,0,7,248,0,0,0,31,240,0,0,21,191,224,0,0,127,255,128,0,0,127,254,0,0,0,47,224,0,0,0,
  // 0x00fe  þ
  18,37,185,23,3,247,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,20,0,0,255,7,255,224,0,255,63,255,252,0,255,255,255,255,0,255,244,2,255,128,255,192,0,127,192,255,128,0,63,208,255,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,64,0,31,224,255,128,0,63,208,255,208,0,127,192,255,244,1,255,128,255,255,255,255,0,255,63,255,252,0,255,11,255,224,0,255,0,20,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,
  // 0x00ff  ÿ
  20,36,180,20,0,247,0,127,1,252,0,0,191,2,252,0,0,191,2,252,0,0,41,0,164,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,64,0,3,253,127,192,0,3,252,63,192,0,11,248,47,224,0,15,240,15,240,0,31,240,15,240,0,47,208,7,248,0,63,192,3,252,0,127,128,2,253,0,191,64,0,254,0,255,0,0,255,1,254,0,0,127,66,252,0,0,63,195,252,0,0,47,199,244,0,0,15,219,240,0,0,15,239,224,0,0,7,255,208,0,0,3,255,192,0,0,2,255,128,0,0,0,255,0,0,0,0,255,0,0,0,2,253,0,0,0,3,252,0,0,0,7,248,0,0,0,31,240,0,0,21,191,224,0,0,127,255,128,0,0,127,254,0,0,0,47,224,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
