/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Traditional Chinese 36pt, capital 'A' height: 26px, width: 100%, range: 0x22bf-0xff1a, glyphs: 307
extern const uint8_t NotoSans_Medium_Traditional_Chinese_26[17084] = {
  162,26,191,34,26,255,34,247, // unifont_t
  // 0x22bf  ⊿
  191,34,28,29,203,36,3,0,0,0,0,0,0,0,2,0,0,0,0,0,0,11,0,0,0,0,0,0,31,0,0,0,0,0,0,127,0,0,0,0,0,1,255,0,0,0,0,0,7,255,0,0,0,0,0,31,255,0,0,0,0,0,127,255,0,0,0,0,1,255,63,0,0,0,0,3,252,63,0,0,0,0,15,240,63,0,0,0,0,63,192,63,0,0,0,0,255,0,63,0,0,0,3,252,0,63,0,0,0,15,240,0,63,0,0,0,63,192,0,63,0,0,0,255,64,0,63,0,0,3,253,0,0,63,0,0,15,244,0,0,63,0,0,63,208,0,0,63,0,0,255,64,0,0,63,0,2,253,0,0,0,63,0,11,244,0,0,0,63,0,47,224,0,0,0,63,0,191,128,0,0,0,63,2,254,0,0,0,0,63,11,255,255,255,255,255,255,47,255,255,255,255,255,255,191,255,255,255,255,255,255,
  // 0x4e00  一
  0,78,34,4,36,36,1,12,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,42,170,170,170,170,170,170,170,144,
  // 0x4e09  三
  9,78,32,29,232,36,2,255,1,85,85,85,85,85,85,64,7,255,255,255,255,255,255,224,7,255,255,255,255,255,255,224,7,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,85,85,85,85,84,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,21,85,85,85,85,85,85,84,
  // 0x4e0a  上
  10,78,32,32,0,36,2,255,0,0,0,21,64,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,213,85,85,64,0,0,0,63,255,255,255,224,0,0,0,63,255,255,255,224,0,0,0,63,255,255,255,224,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,85,85,85,127,213,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x4e0b  下
  11,78,32,32,0,36,2,253,85,85,85,85,85,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,253,0,0,0,0,0,0,47,255,208,0,0,0,0,0,47,255,252,0,0,0,0,0,47,223,255,128,0,0,0,0,47,194,255,244,0,0,0,0,47,192,127,255,0,0,0,0,47,192,11,255,208,0,0,0,47,192,0,255,240,0,0,0,47,192,0,47,192,0,0,0,47,192,0,7,64,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,31,192,0,0,0,
  // 0x4e0d  不
  13,78,33,32,32,36,2,253,21,85,85,85,85,85,85,84,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,0,0,0,2,255,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,3,255,242,224,0,0,0,0,0,15,255,251,252,0,0,0,0,0,63,255,247,255,64,0,0,0,0,255,207,240,255,224,0,0,0,7,255,79,240,47,252,0,0,0,31,253,15,240,7,255,64,0,0,191,240,15,240,1,255,208,0,7,255,192,15,240,0,63,248,0,47,254,0,15,240,0,15,254,0,255,248,0,15,240,0,2,255,64,191,208,0,15,240,0,0,253,0,62,0,0,15,240,0,0,52,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,
  // 0x4e26  並
  38,78,32,33,8,36,2,254,0,1,128,0,0,3,144,0,0,15,208,0,0,7,252,0,0,11,240,0,0,11,244,0,0,3,248,0,0,15,224,0,0,2,253,0,0,47,192,0,0,0,254,0,0,127,64,0,0,0,189,0,0,255,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,21,85,91,245,95,229,85,84,0,0,11,240,15,208,0,0,0,0,11,240,15,208,0,0,0,0,11,240,15,208,9,64,7,240,11,240,15,208,15,240,3,240,11,240,15,208,15,208,2,248,11,240,15,208,31,192,1,252,11,240,15,208,63,192,0,253,11,240,15,208,63,64,0,190,11,240,15,208,127,0,0,127,11,240,15,208,191,0,0,63,11,240,15,208,253,0,0,63,75,240,15,209,252,0,0,47,139,240,15,210,248,0,0,47,203,240,15,211,244,0,0,25,11,240,15,209,160,0,0,0,11,240,15,208,0,0,0,0,11,240,15,208,0,0,0,0,11,240,15,208,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,85,85,85,85,
  // 0x4e2d  中
  45,78,30,34,16,36,3,253,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,21,85,85,127,149,85,85,64,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,85,85,127,149,85,95,208,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,
  // 0x4e3b  主
  59,78,32,33,8,36,2,254,0,0,0,36,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,63,244,0,0,0,0,0,0,11,253,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,189,0,0,0,31,255,255,255,255,255,255,240,31,255,255,255,255,255,255,240,31,255,255,255,255,255,255,240,5,85,85,95,245,85,85,80,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,2,255,255,255,255,255,255,128,2,255,255,255,255,255,255,128,2,255,255,255,255,255,255,128,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,21,85,85,95,245,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x4e4b  之
  75,78,34,34,50,36,1,253,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,7,255,255,255,255,255,255,244,0,7,255,255,255,255,255,255,253,0,7,255,255,255,255,255,255,252,0,1,85,85,85,85,85,95,244,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,2,255,0,0,0,0,1,0,0,11,252,0,0,0,0,11,224,0,47,240,0,0,0,0,15,224,0,191,192,0,0,0,0,31,208,2,255,0,0,0,0,0,63,192,15,252,0,0,0,0,0,127,240,127,240,0,0,0,0,0,255,249,255,192,0,0,0,0,1,255,255,254,0,0,0,0,0,3,252,255,244,0,0,0,0,0,11,244,63,248,0,0,0,0,0,15,240,15,255,229,0,0,0,0,63,208,2,255,255,255,255,255,208,191,192,0,47,255,255,255,255,192,47,64,0,1,175,255,255,255,128,6,0,0,0,0,1,85,85,0,
  // 0x4ea4  交
  164,78,32,35,24,36,2,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,21,85,85,95,229,85,85,84,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,0,0,0,0,0,4,0,0,0,0,121,0,0,47,0,0,0,1,255,64,0,255,208,0,0,7,253,0,0,63,248,0,0,31,248,0,0,11,255,0,0,191,224,0,0,1,255,192,3,255,128,0,0,0,127,240,31,254,5,0,0,100,15,252,191,244,191,0,0,255,3,255,63,192,63,64,1,254,0,252,14,0,47,192,3,252,0,32,0,0,15,224,7,248,0,0,0,0,11,244,15,240,0,0,0,0,3,252,63,208,0,0,0,0,1,255,191,128,0,0,0,0,0,191,255,0,0,0,0,0,0,63,252,0,0,0,0,0,0,127,253,0,0,0,0,0,2,255,255,128,0,0,0,0,47,255,255,248,0,0,0,2,255,248,47,255,128,0,0,191,255,192,7,255,254,0,111,255,253,0,0,191,255,254,255,255,208,0,0,11,255,255,127,248,0,0,0,0,111,253,62,64,0,0,0,0,1,184,0,0,0,0,0,0,0,0,
  // 0x4eae  亮
  174,78,32,35,24,36,2,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,5,85,85,85,85,84,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,64,0,0,1,252,0,0,63,64,0,0,1,252,0,0,63,64,0,0,1,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,21,85,85,85,85,84,0,0,0,0,0,0,0,0,0,106,170,170,170,170,170,170,169,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,125,0,0,0,0,0,0,189,125,0,47,192,11,224,0,189,125,0,63,128,15,224,0,189,125,0,63,128,15,224,0,189,0,0,63,64,15,224,0,0,0,0,127,0,15,224,0,0,0,0,255,0,15,224,0,0,0,1,254,0,15,224,0,52,0,7,252,0,15,224,0,63,0,47,244,0,15,240,0,63,6,255,224,0,15,240,0,191,255,255,64,0,11,255,255,254,191,248,0,0,7,255,255,252,62,64,0,0,1,191,255,224,0,0,0,0,0,0,0,0,
  // 0x4ee4  令
  228,78,34,34,50,36,1,253,0,0,0,7,248,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,47,255,64,0,0,0,0,0,0,191,255,192,0,0,0,0,0,1,255,31,240,0,0,0,0,0,7,253,11,252,0,0,0,0,0,31,244,2,255,64,0,0,0,0,127,224,0,191,208,0,0,0,2,255,64,0,47,248,0,0,0,11,253,0,0,11,255,0,0,0,63,244,0,0,1,255,208,0,1,255,255,255,255,255,255,248,0,15,255,31,255,255,255,143,255,128,127,248,31,255,255,255,130,255,224,63,208,0,0,0,0,0,127,192,14,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,31,208,0,0,0,0,63,0,63,255,192,0,0,0,0,63,0,63,255,192,0,0,0,0,63,0,47,254,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,
  // 0x4ef6  件
  246,78,34,34,50,36,1,253,0,0,144,0,0,21,0,0,0,0,0,253,0,0,191,0,0,0,0,2,252,10,64,191,0,0,0,0,3,248,15,208,191,0,0,0,0,7,240,15,192,191,0,0,0,0,15,240,31,192,191,0,0,0,0,31,208,47,128,191,0,0,0,0,63,192,63,149,191,85,84,0,0,127,64,63,255,255,255,254,0,0,255,0,191,255,255,255,254,0,2,255,0,255,255,255,255,254,0,7,255,1,252,0,191,0,0,0,15,255,3,248,0,191,0,0,0,63,255,7,244,0,191,0,0,0,191,255,11,240,0,191,0,0,0,127,127,0,128,0,191,0,0,0,44,63,0,0,0,191,0,0,0,4,63,0,0,0,191,0,0,0,0,63,11,255,255,255,255,255,208,0,63,11,255,255,255,255,255,208,0,63,11,255,255,255,255,255,208,0,63,1,85,85,191,85,85,64,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,190,0,0,0,
  // 0x4efd  份
  253,78,34,35,59,36,1,252,0,0,144,0,0,0,0,0,0,0,1,252,0,63,255,252,0,0,0,3,252,0,63,255,253,0,0,0,3,244,0,63,255,254,0,0,0,11,240,6,64,0,127,0,0,0,15,208,15,224,0,63,64,0,0,47,192,15,208,0,63,128,0,0,63,128,47,192,0,47,192,0,0,255,0,63,64,0,15,224,0,1,255,0,127,0,0,11,240,0,3,255,0,254,0,0,7,252,0,11,255,2,252,0,0,2,253,0,47,255,3,244,0,0,0,255,64,127,255,15,240,0,0,0,191,208,255,255,63,192,0,0,0,63,224,254,127,63,191,255,255,255,239,192,124,127,14,63,255,255,255,226,0,32,127,0,63,255,255,255,208,0,0,127,0,0,47,128,15,208,0,0,127,0,0,63,64,15,208,0,0,127,0,0,63,0,15,208,0,0,127,0,0,63,0,15,208,0,0,127,0,0,127,0,15,208,0,0,127,0,0,190,0,15,208,0,0,127,0,0,253,0,15,192,0,0,127,0,1,252,0,15,192,0,0,127,0,3,248,0,15,192,0,0,127,0,7,244,0,31,192,0,0,127,0,15,224,0,31,192,0,0,127,0,63,192,0,47,192,0,0,127,0,255,64,0,127,128,0,0,127,7,254,0,63,255,64,0,0,127,7,244,0,63,255,0,0,0,127,1,208,0,47,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4f11  休
  17,79,34,34,50,36,1,253,0,0,36,0,0,84,0,0,0,0,0,127,64,0,252,0,0,0,0,0,255,0,0,252,0,0,0,0,0,254,0,0,252,0,0,0,0,2,252,0,0,252,0,0,0,0,7,248,0,0,252,0,0,0,0,15,240,0,0,252,0,0,0,0,31,224,0,0,252,0,0,0,0,63,192,0,0,252,0,0,0,0,255,139,255,255,255,255,255,192,2,255,139,255,255,255,255,255,192,7,255,139,255,255,255,255,255,192,31,255,129,85,95,255,213,85,64,127,255,128,0,15,255,224,0,0,255,239,128,0,47,255,240,0,0,191,47,128,0,63,255,244,0,0,61,47,128,0,127,254,252,0,0,20,47,128,0,254,253,253,0,0,0,47,128,2,252,252,127,0,0,0,47,128,3,248,252,63,128,0,0,47,128,11,240,252,47,192,0,0,47,128,31,208,252,15,240,0,0,47,128,63,192,252,7,248,0,0,47,128,255,64,252,3,253,0,0,47,130,254,0,252,0,255,0,0,47,139,252,0,252,0,191,192,0,47,255,240,0,252,0,63,240,0,47,159,208,0,252,0,15,192,0,47,139,64,0,252,0,3,64,0,47,129,0,0,252,0,0,0,0,47,128,0,0,252,0,0,0,0,47,128,0,0,252,0,0,0,0,47,128,0,0,252,0,0,0,0,31,128,0,0,252,0,0,0,
  // 0x4f4d  位
  77,79,34,34,50,36,1,253,0,0,100,0,0,168,0,0,0,0,0,254,0,0,253,0,0,0,0,1,253,0,0,253,0,0,0,0,3,252,0,0,253,0,0,0,0,7,244,0,0,253,0,0,0,0,15,240,0,0,253,0,0,0,0,31,208,0,0,253,0,0,0,0,63,195,255,255,255,255,255,192,0,191,67,255,255,255,255,255,192,1,255,67,255,255,255,255,255,192,3,255,64,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,47,255,64,5,128,0,11,144,0,191,255,64,15,192,0,15,240,0,255,127,64,15,208,0,15,224,0,125,63,64,11,224,0,15,208,0,56,63,64,7,240,0,31,192,0,0,63,64,3,240,0,47,192,0,0,63,64,3,244,0,63,128,0,0,63,64,3,248,0,63,64,0,0,63,64,2,248,0,127,0,0,0,63,64,1,252,0,127,0,0,0,63,64,1,252,0,254,0,0,0,63,64,0,252,0,253,0,0,0,63,64,0,253,1,252,0,0,0,63,64,0,253,2,252,0,0,0,63,64,0,254,3,244,0,0,0,63,64,0,80,3,240,0,0,0,63,64,0,0,7,240,0,0,0,63,75,255,255,255,255,255,224,0,63,75,255,255,255,255,255,224,0,63,75,255,255,255,255,255,224,0,63,64,0,0,0,0,0,0,0,42,0,0,0,0,0,0,0,
  // 0x4f4e  低
  78,79,34,34,50,36,1,253,0,0,144,0,0,0,0,0,0,0,1,252,0,0,0,0,96,0,0,2,252,0,0,0,111,248,0,0,3,244,0,5,191,255,254,0,0,11,240,251,255,255,255,228,0,0,15,224,255,255,255,228,0,0,0,47,192,255,254,95,192,0,0,0,63,128,254,0,15,192,0,0,0,191,0,253,0,15,208,0,0,1,255,0,253,0,15,208,0,0,3,255,0,253,0,15,208,0,0,11,255,0,253,0,15,208,0,0,31,255,0,253,0,15,208,0,0,127,255,0,255,255,255,255,255,208,255,255,0,255,255,255,255,255,208,254,127,0,255,255,255,255,255,208,124,127,0,253,0,7,240,0,0,32,127,0,253,0,7,240,0,0,0,127,0,253,0,3,240,0,0,0,127,0,253,0,3,244,0,0,0,127,0,253,0,3,248,0,0,0,127,0,253,0,2,252,0,0,0,127,0,253,0,1,252,0,0,0,127,0,253,1,172,253,0,0,0,127,0,255,255,252,254,0,0,0,127,15,255,255,252,191,2,208,0,127,15,255,254,144,63,66,240,0,127,11,249,0,0,63,194,240,0,127,0,0,0,0,31,227,240,0,127,0,0,0,0,15,255,224,0,127,3,255,255,255,227,255,208,0,127,3,255,255,255,225,255,128,0,127,3,255,255,255,224,21,0,0,106,0,0,0,0,0,0,0,
  // 0x4f5c  作
  92,79,34,34,50,36,1,253,0,0,100,0,4,0,0,0,0,0,0,191,0,47,128,0,0,0,0,0,253,0,63,64,0,0,0,0,2,252,0,127,0,0,0,0,0,3,248,0,254,0,0,0,0,0,11,240,1,253,0,0,0,0,0,15,224,3,255,255,255,255,224,0,47,192,7,255,255,255,255,224,0,127,128,15,255,255,255,255,224,0,255,64,31,210,252,0,0,0,2,255,64,63,193,252,0,0,0,7,255,64,191,1,252,0,0,0,15,255,65,254,1,252,0,0,0,63,255,71,252,1,252,0,0,0,191,255,75,244,1,255,255,255,128,63,63,66,208,1,255,255,255,128,29,63,64,64,1,255,255,255,128,4,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,255,255,255,192,0,63,64,0,1,255,255,255,192,0,63,64,0,1,255,255,255,192,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,
  // 0x4f9b  供
  155,79,34,34,50,36,1,253,0,0,144,1,164,0,42,0,0,0,0,253,1,252,0,63,0,0,0,2,252,1,252,0,63,0,0,0,3,248,1,252,0,63,0,0,0,7,240,1,252,0,63,0,0,0,15,224,1,252,0,63,0,0,0,31,192,1,252,0,63,0,0,0,63,128,2,252,0,63,64,0,0,191,3,255,255,255,255,255,192,1,255,3,255,255,255,255,255,192,3,255,3,255,255,255,255,255,192,11,255,0,1,252,0,63,0,0,47,255,0,1,252,0,63,0,0,127,255,0,1,252,0,63,0,0,255,191,0,1,252,0,63,0,0,126,127,0,1,252,0,63,0,0,56,127,0,1,252,0,63,0,0,16,127,0,1,252,0,63,0,0,0,127,0,1,252,0,63,0,0,0,127,11,255,255,255,255,255,224,0,127,11,255,255,255,255,255,224,0,127,11,255,255,255,255,255,224,0,127,1,85,85,85,85,85,64,0,127,0,0,0,0,0,0,0,0,127,0,0,160,0,9,0,0,0,127,0,2,253,0,127,0,0,0,127,0,3,248,0,63,192,0,0,127,0,15,240,0,31,240,0,0,127,0,63,208,0,7,248,0,0,127,0,191,128,0,2,253,0,0,127,2,255,0,0,0,255,0,0,127,15,252,0,0,0,63,192,0,127,3,240,0,0,0,31,128,0,127,0,128,0,0,0,8,0,
  // 0x4fdd  保
  221,79,34,35,59,36,1,252,0,0,80,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,253,63,255,255,255,253,0,0,2,252,63,255,255,255,253,0,0,3,244,63,255,255,255,253,0,0,11,240,63,0,0,0,253,0,0,15,208,63,0,0,0,253,0,0,47,192,63,0,0,0,253,0,0,127,128,63,0,0,0,253,0,0,255,64,63,0,0,0,253,0,2,255,64,63,0,0,0,253,0,7,255,64,63,255,255,255,253,0,31,255,64,63,255,255,255,253,0,63,255,64,63,255,255,255,253,0,255,191,64,0,0,254,0,0,0,127,63,64,0,0,254,0,0,0,60,63,64,0,0,254,0,0,0,16,63,64,0,0,254,0,0,0,0,63,75,255,255,255,255,255,208,0,63,75,255,255,255,255,255,208,0,63,75,255,255,255,255,255,208,0,63,64,0,15,255,224,0,0,0,63,64,0,47,255,244,0,0,0,63,64,0,127,255,252,0,0,0,63,64,1,254,254,191,0,0,0,63,64,7,252,254,63,192,0,0,63,64,31,240,254,15,240,0,0,63,64,127,192,254,7,252,0,0,63,66,255,64,254,2,255,64,0,63,95,253,0,254,0,191,224,0,63,79,240,0,254,0,47,224,0,63,71,128,0,254,0,7,128,0,63,64,0,0,254,0,0,0,0,63,64,0,0,254,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4fe1  信
  225,79,34,34,50,36,1,253,0,0,184,0,0,0,0,0,0,0,0,254,10,170,170,170,160,0,0,1,252,15,255,255,255,244,0,0,3,248,15,255,255,255,244,0,0,7,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,63,199,255,255,255,255,255,224,0,191,71,255,255,255,255,255,224,1,255,71,255,255,255,255,255,208,3,255,64,0,0,0,0,0,0,11,255,64,0,0,0,0,0,0,47,255,64,47,255,255,255,252,0,191,255,64,47,255,255,255,252,0,255,127,64,26,170,170,170,168,0,125,63,64,0,0,0,0,0,0,56,63,64,0,0,0,0,0,0,0,63,64,47,255,255,255,252,0,0,63,64,47,255,255,255,252,0,0,63,64,26,170,170,170,168,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,42,170,170,170,168,0,0,63,64,63,255,255,255,253,0,0,63,64,63,255,255,255,253,0,0,63,64,63,0,0,0,253,0,0,63,64,63,0,0,0,253,0,0,63,64,63,0,0,0,253,0,0,63,64,63,0,0,0,253,0,0,63,64,63,170,170,170,253,0,0,63,64,63,255,255,255,253,0,0,63,64,63,255,255,255,253,0,0,63,64,63,0,0,0,253,0,0,42,0,63,0,0,0,168,0,
  // 0x500b  個
  11,80,33,35,59,36,1,252,0,2,64,0,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,11,242,255,255,255,255,255,64,0,15,210,255,255,255,255,255,64,0,31,194,255,255,255,255,255,64,0,63,130,244,0,0,0,63,64,0,127,2,244,0,188,0,63,64,0,191,2,244,0,188,0,63,64,1,254,2,244,0,188,0,63,64,3,254,2,244,0,188,0,63,64,7,254,2,245,255,255,255,63,64,15,254,2,245,255,255,255,63,64,63,254,2,244,85,254,85,63,64,191,254,2,244,0,188,0,63,64,255,254,2,244,0,188,0,63,64,253,190,2,244,0,188,0,63,64,124,190,2,244,21,189,84,63,64,48,190,2,244,63,255,252,63,64,0,190,2,244,63,255,252,63,64,0,190,2,244,61,0,188,63,64,0,190,2,244,61,0,188,63,64,0,190,2,244,61,0,188,63,64,0,190,2,244,61,0,188,63,64,0,190,2,244,62,85,252,63,64,0,190,2,244,63,255,252,63,64,0,190,2,244,63,255,252,63,64,0,190,2,244,0,0,0,63,64,0,190,2,244,0,0,0,63,64,0,190,2,244,0,0,0,63,64,0,190,2,255,255,255,255,255,64,0,190,2,255,255,255,255,255,64,0,190,2,255,255,255,255,255,64,0,190,2,244,0,0,0,63,64,0,190,2,244,0,0,0,42,64,0,0,0,0,0,0,0,0,0,
  // 0x503c  值
  60,80,34,34,50,36,1,253,0,0,144,0,0,170,0,0,0,0,1,252,0,0,254,0,0,0,0,2,252,0,0,253,0,0,0,0,3,244,0,0,253,0,0,0,0,7,243,255,255,255,255,255,64,0,15,227,255,255,255,255,255,64,0,47,195,255,255,255,255,255,64,0,63,128,0,2,244,0,0,0,0,191,0,0,3,240,0,0,0,1,254,0,42,171,250,170,160,0,3,254,0,63,255,255,255,244,0,11,254,0,63,255,255,255,244,0,31,254,0,62,0,0,2,244,0,63,254,0,62,0,0,2,244,0,191,254,0,62,0,0,2,244,0,127,126,0,63,255,255,255,244,0,44,126,0,63,255,255,255,244,0,20,126,0,63,85,85,87,244,0,0,126,0,62,0,0,2,244,0,0,126,0,62,0,0,2,244,0,0,126,0,63,255,255,255,244,0,0,126,0,63,255,255,255,244,0,0,126,0,63,85,85,87,244,0,0,126,0,62,0,0,2,244,0,0,126,0,62,0,0,2,244,0,0,126,0,63,255,255,255,244,0,0,126,0,63,255,255,255,244,0,0,126,0,63,85,85,87,244,0,0,126,0,62,0,0,2,244,0,0,126,0,62,0,0,2,244,0,0,126,31,255,255,255,255,255,208,0,126,47,255,255,255,255,255,208,0,126,47,255,255,255,255,255,208,0,126,0,0,0,0,0,0,0,
  // 0x504f  偏
  79,80,34,34,50,36,1,253,0,2,64,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,231,255,255,255,255,255,208,0,15,215,255,255,255,255,255,208,0,31,199,255,255,255,255,255,208,0,63,128,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,191,0,255,255,255,255,255,0,0,253,0,255,255,255,255,255,0,3,253,0,254,170,170,170,191,0,7,253,0,252,0,0,0,127,0,15,253,0,252,0,0,0,127,0,47,253,0,252,0,0,0,127,0,127,253,0,255,255,255,255,255,0,255,253,0,255,255,255,255,255,0,254,189,0,254,170,170,170,170,0,124,189,0,252,0,0,0,0,0,48,189,0,252,0,0,0,0,0,0,189,1,255,255,255,255,255,128,0,189,1,255,255,255,255,255,128,0,189,2,255,235,250,254,175,128,0,189,2,255,194,240,124,31,128,0,189,3,255,194,240,124,31,128,0,189,3,255,194,240,124,31,128,0,189,7,255,235,250,254,175,128,0,189,11,239,255,255,255,255,128,0,189,15,223,255,255,255,255,128,0,189,31,207,194,240,124,31,128,0,189,63,143,194,240,124,31,128,0,189,127,15,194,240,124,31,128,0,189,254,15,194,240,124,31,128,0,189,60,15,194,240,125,255,128,0,189,4,15,194,240,124,255,64,0,189,0,15,129,160,104,253,0,
  // 0x505c  停
  92,80,34,34,50,36,1,253,0,0,144,0,0,253,0,0,0,0,1,252,0,0,253,0,0,0,0,3,252,0,0,253,0,0,0,0,3,251,255,255,255,255,255,208,0,11,247,255,255,255,255,255,208,0,15,215,255,255,255,255,255,208,0,63,192,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,255,0,63,255,255,255,248,0,2,255,0,63,255,255,255,248,0,7,255,0,63,85,85,86,248,0,15,255,0,63,64,0,2,248,0,63,255,0,63,64,0,2,248,0,255,255,0,63,255,255,255,248,0,255,127,0,63,255,255,255,248,0,188,127,0,21,85,85,85,80,0,52,127,0,0,0,0,0,0,0,16,127,10,170,170,170,170,170,144,0,127,15,255,255,255,255,255,224,0,127,15,255,255,255,255,255,224,0,127,15,192,0,0,0,7,224,0,127,15,192,0,0,0,7,224,0,127,15,198,170,170,170,151,224,0,127,15,203,255,255,255,215,224,0,127,0,11,255,255,255,208,0,0,127,0,0,0,253,0,0,0,0,127,0,0,0,253,0,0,0,0,127,0,0,0,253,0,0,0,0,127,0,0,0,253,0,0,0,0,127,0,0,0,253,0,0,0,0,127,0,0,0,253,0,0,0,0,127,0,3,255,253,0,0,0,0,127,0,1,255,252,0,0,0,0,126,0,0,255,224,0,0,0,
  // 0x5075  偵
  117,80,33,35,59,36,1,252,0,0,100,0,0,252,0,0,0,0,0,254,0,0,252,0,0,0,0,1,253,0,0,252,0,0,0,0,3,252,0,0,255,255,255,192,0,7,244,0,0,255,255,255,192,0,15,240,0,0,255,255,255,128,0,31,208,0,0,252,0,0,0,0,63,192,0,0,252,0,0,0,0,191,64,106,170,254,170,168,0,1,255,64,127,255,255,255,252,0,3,255,64,127,255,255,255,252,0,11,255,64,127,0,0,0,252,0,47,255,64,127,0,0,0,252,0,127,255,64,127,0,0,0,252,0,255,127,64,127,255,255,255,252,0,190,63,64,127,255,255,255,252,0,60,63,64,127,85,85,86,252,0,16,63,64,127,0,0,0,252,0,0,63,64,127,0,0,0,252,0,0,63,64,127,255,255,255,252,0,0,63,64,127,255,255,255,252,0,0,63,64,127,85,85,86,252,0,0,63,64,127,0,0,0,252,0,0,63,64,127,0,0,0,252,0,0,63,64,127,255,255,255,252,0,0,63,64,127,255,255,255,252,0,0,63,64,42,170,170,170,168,0,0,63,64,0,96,0,9,0,0,0,63,64,2,255,0,191,128,0,0,63,64,15,253,0,127,244,0,0,63,64,191,240,0,15,254,0,0,63,75,255,128,0,2,255,192,0,63,71,253,0,0,0,127,192,0,47,65,224,0,0,0,13,0,0,0,0,0,0,0,0,0,0,
  // 0x5099  備
  153,80,34,35,59,36,1,252,0,2,128,0,248,0,63,0,0,0,7,240,0,252,0,63,0,0,0,11,224,0,252,0,63,0,0,0,15,219,255,255,255,255,255,208,0,31,203,255,255,255,255,255,208,0,63,75,255,255,255,255,255,208,0,127,0,0,252,0,63,0,0,0,254,0,0,252,0,63,0,0,1,253,0,0,248,0,63,0,0,3,253,0,0,0,0,0,0,0,7,253,3,255,255,255,255,255,224,15,253,7,255,255,255,255,255,224,47,253,7,255,255,255,255,255,224,127,253,7,240,0,0,0,0,0,255,253,7,240,0,0,0,0,0,253,189,7,240,170,170,170,170,64,120,189,7,241,255,255,255,255,128,48,189,7,241,255,255,255,255,128,0,189,7,241,244,7,208,15,128,0,189,7,225,244,7,208,15,128,0,189,7,225,248,7,208,31,128,0,189,7,225,255,255,255,255,128,0,189,7,225,255,255,255,255,128,0,189,11,209,244,7,208,15,128,0,189,11,209,244,7,208,15,128,0,189,15,193,248,7,208,31,128,0,189,15,193,255,255,255,255,128,0,189,31,193,255,255,255,255,128,0,189,47,129,244,7,208,15,128,0,189,63,65,244,7,208,15,128,0,189,127,1,244,7,208,15,128,0,189,254,1,244,7,210,175,128,0,189,124,1,244,7,211,255,64,0,189,24,1,244,7,211,253,0,0,0,0,0,0,0,0,0,0,
  // 0x50b3  傳
  179,80,34,34,50,36,1,253,0,0,224,0,0,189,0,0,0,0,1,252,0,0,253,0,0,0,0,3,254,170,170,254,170,170,128,0,3,255,255,255,255,255,255,192,0,11,247,255,255,255,255,255,192,0,15,208,0,0,253,0,0,0,0,63,192,0,0,253,0,0,0,0,127,64,255,255,255,255,255,0,0,255,0,255,255,255,255,255,0,2,255,0,252,0,253,0,127,0,3,255,0,252,0,253,0,127,0,15,255,0,255,255,255,255,255,0,47,255,0,255,255,255,255,255,0,191,255,0,252,0,253,0,127,0,255,191,0,252,0,253,0,127,0,189,127,0,255,255,255,255,255,0,56,127,0,255,255,255,255,255,0,16,127,0,0,0,253,7,244,0,0,127,0,0,0,253,2,253,0,0,127,11,255,255,255,255,255,64,0,127,7,255,255,255,255,255,208,0,127,2,170,85,85,47,135,192,0,127,0,0,0,0,47,129,0,0,127,10,170,170,170,191,234,144,0,127,31,255,255,255,255,255,224,0,127,31,255,255,255,255,255,224,0,127,0,11,128,0,47,128,0,0,127,0,31,224,0,47,128,0,0,127,0,11,248,0,47,128,0,0,127,0,2,253,0,47,128,0,0,127,0,0,191,0,47,128,0,0,127,0,0,56,127,255,128,0,0,127,0,0,0,63,255,64,0,0,126,0,0,0,47,249,0,0,
  // 0x50be  傾
  190,80,34,35,59,36,1,252,0,5,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,192,0,191,255,255,255,208,0,47,128,0,191,255,255,255,208,0,63,95,128,191,255,255,255,208,0,127,31,128,0,3,248,0,0,0,190,31,128,0,3,240,0,0,0,253,31,128,10,171,250,170,0,2,252,31,128,15,255,255,255,64,3,252,31,130,79,255,255,255,64,11,252,31,139,239,192,0,47,64,15,252,31,175,223,192,0,47,64,63,252,31,255,79,192,0,47,64,127,252,31,253,15,255,255,255,64,255,252,31,240,15,255,255,255,64,252,252,31,192,15,213,85,127,64,116,252,31,128,15,192,0,47,64,48,252,31,128,15,192,0,47,64,0,252,31,128,15,213,85,127,64,0,252,31,128,15,255,255,255,64,0,252,31,129,79,255,255,255,64,0,252,31,130,255,192,0,47,64,0,252,31,130,255,192,0,47,64,0,252,31,130,255,192,0,47,64,0,252,31,131,255,255,255,255,64,0,252,31,255,239,255,255,255,64,0,252,15,255,218,170,170,170,0,0,252,7,255,64,96,0,128,0,0,252,0,0,2,253,7,240,0,0,252,0,0,15,252,7,253,0,0,252,0,0,191,240,0,255,64,0,252,0,7,255,128,0,63,224,0,252,0,7,252,0,0,15,208,0,252,0,1,208,0,0,3,64,0,0,0,0,0,0,0,0,0,
  // 0x5132  儲
  50,81,34,34,50,36,1,253,0,10,64,0,0,7,224,0,0,0,15,218,170,160,7,224,15,128,0,15,207,255,240,7,224,15,192,0,47,143,255,240,7,224,47,128,0,63,0,0,0,175,250,127,0,0,127,0,0,0,255,255,191,0,0,253,42,170,169,255,255,253,0,1,252,63,255,253,7,224,252,0,3,252,63,255,253,7,226,244,0,7,252,0,0,0,7,227,240,0,15,252,0,0,0,7,239,208,0,47,252,10,170,163,255,255,255,224,63,252,15,255,247,255,255,255,224,255,252,15,255,246,170,255,186,144,253,252,0,0,0,2,252,176,0,120,252,0,0,0,11,241,252,0,48,252,10,170,160,31,208,63,0,0,252,15,255,244,191,128,28,0,0,252,15,255,246,255,255,255,64,0,252,0,0,15,255,255,255,64,0,252,0,0,7,255,255,255,64,0,252,10,170,170,143,192,47,64,0,252,31,255,252,15,192,47,64,0,252,31,255,252,15,192,47,64,0,252,31,64,252,15,255,255,64,0,252,31,64,252,15,255,255,64,0,252,31,64,252,15,213,127,64,0,252,31,64,252,15,192,47,64,0,252,31,64,252,15,192,47,64,0,252,31,255,252,15,192,47,64,0,252,31,255,252,15,255,255,64,0,252,31,234,168,15,255,255,64,0,252,31,64,0,15,234,191,64,0,252,10,0,0,15,192,47,0,
  // 0x5145  充
  69,81,33,35,59,36,2,252,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,0,0,15,240,0,20,0,0,0,0,0,31,208,0,124,0,0,0,0,0,63,192,1,255,64,0,0,0,0,63,64,0,127,208,0,0,0,0,191,0,0,31,244,0,0,0,0,253,0,0,7,253,0,0,0,2,254,170,255,255,255,64,0,31,255,255,255,255,255,255,208,0,31,255,255,255,255,255,255,240,0,31,255,255,234,149,80,7,252,0,9,80,0,0,0,0,2,248,0,0,0,31,192,3,240,0,208,0,0,0,47,192,3,240,0,0,0,0,0,63,192,3,240,0,0,0,0,0,63,128,3,240,0,0,0,0,0,63,128,3,240,0,0,0,0,0,127,64,3,240,0,0,0,0,0,191,0,3,240,0,16,0,0,0,255,0,3,240,0,46,0,0,2,253,0,3,240,0,47,64,0,7,252,0,3,240,0,47,64,0,31,244,0,3,240,0,47,64,0,191,224,0,3,240,0,63,0,27,255,128,0,3,248,0,127,0,255,253,0,0,3,255,255,255,0,191,224,0,0,1,255,255,253,0,62,0,0,0,0,127,255,244,0,0,0,0,0,0,0,0,0,0,
  // 0x5148  先
  72,81,32,35,24,36,2,252,0,0,0,11,224,0,0,0,0,11,144,11,224,0,0,0,0,15,224,11,224,0,0,0,0,15,208,11,224,0,0,0,0,31,192,11,224,0,0,0,0,63,192,11,240,0,0,0,0,63,255,255,255,255,255,192,0,191,255,255,255,255,255,192,0,255,255,255,255,255,255,192,1,252,0,11,224,0,0,0,3,248,0,11,224,0,0,0,11,240,0,11,224,0,0,0,15,224,0,11,224,0,0,0,3,192,0,11,224,0,0,0,0,0,0,11,224,0,0,0,0,0,0,11,240,0,0,0,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,0,0,63,128,3,240,0,0,0,0,63,64,3,240,0,0,0,0,63,64,3,240,0,0,0,0,127,0,3,240,0,0,0,0,191,0,3,240,0,0,0,0,254,0,3,240,0,0,0,2,252,0,3,240,0,52,0,7,252,0,3,240,0,63,0,15,240,0,3,240,0,63,0,127,224,0,3,240,0,63,2,255,192,0,3,244,0,191,111,254,0,0,3,255,255,254,255,248,0,0,2,255,255,252,63,192,0,0,0,191,255,244,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5149  光
  73,81,34,35,59,36,1,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,1,0,0,0,109,0,3,248,0,7,224,0,0,255,0,3,248,0,15,240,0,0,127,64,3,248,0,15,224,0,0,63,192,3,248,0,47,192,0,0,31,208,3,248,0,63,128,0,0,15,240,3,248,0,127,0,0,0,7,244,3,248,0,254,0,0,0,3,248,3,248,2,252,0,0,0,2,252,3,248,3,248,0,0,0,1,208,3,248,0,96,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,15,240,0,252,0,0,0,0,0,15,224,0,252,0,0,0,0,0,15,208,0,252,0,0,0,0,0,15,208,0,252,0,0,0,0,0,31,192,0,252,0,0,0,0,0,47,192,0,252,0,0,0,0,0,63,192,0,252,0,0,0,0,0,127,64,0,252,0,0,0,0,0,255,0,0,252,0,10,0,0,2,254,0,0,252,0,11,208,0,7,252,0,0,252,0,11,208,0,31,244,0,0,252,0,15,208,0,191,224,0,0,252,0,15,192,27,255,128,0,0,253,0,31,192,127,254,0,0,0,255,255,255,128,47,240,0,0,0,191,255,255,64,14,0,0,0,0,31,255,253,0,0,0,0,0,0,0,0,0,0,
  // 0x5165  入
  101,81,34,32,32,36,1,253,0,2,255,255,252,0,0,0,0,0,2,255,255,252,0,0,0,0,0,2,255,255,252,0,0,0,0,0,1,85,85,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,5,255,0,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,47,255,128,0,0,0,0,0,0,63,255,192,0,0,0,0,0,0,63,223,192,0,0,0,0,0,0,127,79,224,0,0,0,0,0,0,255,11,240,0,0,0,0,0,1,254,7,248,0,0,0,0,0,3,253,3,252,0,0,0,0,0,7,252,2,254,0,0,0,0,0,15,244,0,255,0,0,0,0,0,31,240,0,191,192,0,0,0,0,63,192,0,63,224,0,0,0,0,255,128,0,31,244,0,0,0,2,255,0,0,11,252,0,0,0,11,253,0,0,3,255,0,0,0,47,244,0,0,0,255,208,0,0,191,224,0,0,0,127,244,0,3,255,128,0,0,0,31,254,0,47,254,0,0,0,0,7,255,208,127,248,0,0,0,0,0,255,192,15,208,0,0,0,0,0,47,0,2,0,0,0,0,0,0,5,0,
  // 0x5168  全
  104,81,34,33,41,36,1,254,0,0,0,7,252,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,47,255,64,0,0,0,0,0,0,127,191,192,0,0,0,0,0,1,255,15,240,0,0,0,0,0,7,252,7,252,0,0,0,0,0,15,240,1,255,0,0,0,0,0,63,208,0,127,192,0,0,0,1,255,64,0,31,244,0,0,0,7,252,0,0,3,254,0,0,0,47,240,0,0,0,255,192,0,0,255,192,0,0,0,47,244,0,11,254,0,0,0,0,7,255,0,63,255,255,255,255,255,255,255,208,127,235,255,255,255,255,254,191,192,31,71,255,255,255,255,254,31,64,8,0,0,3,248,0,0,1,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,15,255,255,255,255,255,255,255,64,15,255,255,255,255,255,255,255,64,15,255,255,255,255,255,255,255,64,
  // 0x5171  共
  113,81,32,34,16,36,2,253,0,0,168,0,0,42,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,1,253,0,0,191,64,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,85,85,254,85,85,191,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,0,0,120,0,0,0,0,255,128,3,255,0,0,0,3,255,0,0,255,208,0,0,15,252,0,0,47,248,0,0,127,240,0,0,11,255,0,2,255,192,0,0,1,255,192,31,254,0,0,0,0,127,240,127,244,0,0,0,0,15,253,47,208,0,0,0,0,3,248,10,0,0,0,0,0,0,144,
  // 0x5177  具
  119,81,32,33,8,36,2,253,0,26,170,170,170,170,168,0,0,47,255,255,255,255,252,0,0,47,255,255,255,255,252,0,0,47,128,0,0,1,252,0,0,47,128,0,0,1,252,0,0,47,128,0,0,1,252,0,0,47,255,255,255,255,252,0,0,47,255,255,255,255,252,0,0,47,149,85,85,86,252,0,0,47,128,0,0,1,252,0,0,47,128,0,0,1,252,0,0,47,149,85,85,86,252,0,0,47,255,255,255,255,252,0,0,47,255,255,255,255,252,0,0,47,128,0,0,1,252,0,0,47,128,0,0,1,252,0,0,47,128,0,0,1,252,0,0,47,255,255,255,255,252,0,0,47,255,255,255,255,252,0,0,26,170,170,170,170,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,4,0,0,0,0,0,0,0,63,0,0,184,0,0,0,2,255,192,3,255,208,0,0,127,255,64,1,255,254,0,11,255,248,0,0,31,255,228,255,255,64,0,0,0,191,254,63,228,0,0,0,0,11,252,13,0,0,0,0,0,0,160,
  // 0x5197  冗
  151,81,33,32,32,36,2,253,21,85,85,85,85,85,85,84,0,63,255,255,255,255,255,255,252,0,63,255,255,255,255,255,255,252,0,63,255,255,255,255,255,255,252,0,63,64,0,0,0,0,1,252,0,63,64,0,0,0,0,1,252,0,63,64,0,0,0,0,1,252,0,63,64,0,0,0,0,1,252,0,63,64,0,0,0,0,1,252,0,63,64,0,0,0,0,1,252,0,0,0,255,255,255,255,0,0,0,0,0,255,255,255,255,0,0,0,0,0,255,255,255,255,0,0,0,0,0,254,0,0,191,0,0,0,0,0,254,0,0,191,0,0,0,0,0,254,0,0,191,0,0,0,0,0,254,0,0,191,0,0,0,0,0,254,0,0,191,0,0,0,0,0,253,0,0,191,0,0,0,0,0,253,0,0,191,0,0,0,0,1,252,0,0,191,0,0,0,0,2,252,0,0,191,0,0,0,0,3,252,0,0,191,0,40,0,0,11,244,0,0,191,0,47,64,0,15,240,0,0,191,0,47,64,0,63,208,0,0,191,0,63,64,1,255,192,0,0,191,0,63,64,11,255,0,0,0,191,0,127,0,191,252,0,0,0,191,255,255,0,255,224,0,0,0,63,255,254,0,127,64,0,0,0,31,255,248,0,36,0,0,0,0,0,85,64,0,
  // 0x51b7  冷
  183,81,34,34,50,36,1,253,0,0,0,0,7,244,0,0,0,0,0,0,0,15,252,0,0,0,7,0,0,0,47,255,0,0,0,31,208,0,0,63,255,128,0,0,63,244,0,0,255,47,208,0,0,15,254,0,3,253,15,244,0,0,2,255,128,11,248,3,253,0,0,0,191,192,47,240,1,255,64,0,0,47,64,191,192,0,127,224,0,0,9,2,255,0,0,31,248,0,0,0,11,252,0,0,7,255,64,0,0,63,255,255,255,253,255,224,0,1,255,203,255,255,252,63,208,0,1,255,11,255,255,252,11,128,0,0,184,0,0,0,0,1,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,255,255,255,255,252,0,0,15,211,255,255,255,255,252,0,0,31,227,255,255,255,255,252,0,0,63,192,0,63,128,1,252,0,0,191,64,0,63,128,1,252,0,0,255,0,0,63,128,1,252,0,3,252,0,0,63,128,1,252,0,11,248,0,0,63,128,1,252,0,31,240,0,0,63,128,1,252,0,63,208,0,0,63,130,255,252,0,127,128,0,0,63,129,255,248,0,31,0,0,0,63,128,255,224,0,5,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,47,64,0,0,0,
  // 0x51c6  准
  198,81,34,34,50,36,1,253,0,0,0,0,228,0,100,0,0,0,0,0,2,252,0,191,0,0,2,0,0,3,248,0,254,0,0,15,208,0,7,240,0,252,0,0,31,248,0,15,224,1,252,0,0,7,255,0,31,208,3,244,0,0,0,255,192,63,192,3,240,0,0,0,47,224,127,255,255,255,255,128,0,11,192,255,255,255,255,255,128,0,2,2,255,255,255,255,255,128,0,0,7,255,64,15,208,0,0,0,0,15,255,64,15,192,0,0,0,0,63,255,64,15,192,0,0,0,0,255,255,64,15,192,0,0,0,0,127,63,255,255,255,255,0,0,0,28,63,255,255,255,255,0,0,0,0,63,255,255,255,255,0,0,0,0,63,64,15,192,0,0,0,1,0,63,64,15,192,0,0,0,11,64,63,64,15,192,0,0,0,15,192,63,64,15,192,0,0,0,47,192,63,64,15,192,0,0,0,127,128,63,255,255,255,255,0,0,255,0,63,255,255,255,255,0,2,253,0,63,255,255,255,255,0,3,252,0,63,64,15,192,0,0,15,240,0,63,64,15,192,0,0,47,224,0,63,64,15,192,0,0,127,192,0,63,64,15,192,0,0,63,0,0,63,255,255,255,255,224,10,0,0,63,255,255,255,255,224,0,0,0,63,255,255,255,255,224,0,0,0,63,64,0,0,0,0,0,0,0,63,0,0,0,0,0,
  // 0x51fa  出
  250,81,28,35,245,36,4,252,0,0,0,169,0,0,0,0,0,0,253,0,0,0,0,0,0,253,0,0,0,26,64,0,253,0,1,164,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,255,255,255,255,255,248,47,255,255,255,255,255,248,47,255,255,255,255,255,248,0,0,0,254,0,0,0,0,0,0,253,0,0,0,84,0,0,253,0,0,21,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,254,85,85,254,85,85,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,0,0,0,0,0,127,253,0,0,0,0,0,127,0,0,0,0,0,0,0,
  // 0x5206  分
  6,82,34,34,50,36,1,252,0,0,15,144,0,47,0,0,0,0,0,31,224,0,191,64,0,0,0,0,63,192,0,63,192,0,0,0,0,127,192,0,31,224,0,0,0,0,255,64,0,15,244,0,0,0,2,254,0,0,7,252,0,0,0,7,252,0,0,2,255,0,0,0,15,244,0,0,0,255,128,0,0,63,240,0,0,0,63,224,0,0,255,192,0,0,0,47,244,0,3,255,64,0,0,0,11,253,0,15,253,0,0,0,0,3,255,128,127,253,85,85,85,85,85,255,224,255,223,255,255,255,255,255,127,208,63,79,255,255,255,255,255,15,64,13,15,255,255,255,255,255,1,0,0,0,0,127,0,0,127,0,0,0,0,0,191,0,0,127,0,0,0,0,0,255,0,0,127,0,0,0,0,0,254,0,0,191,0,0,0,0,0,253,0,0,191,0,0,0,0,2,252,0,0,191,0,0,0,0,3,252,0,0,191,0,0,0,0,7,248,0,0,254,0,0,0,0,15,240,0,0,254,0,0,0,0,63,224,0,0,254,0,0,0,0,191,192,0,0,253,0,0,0,3,255,64,0,1,253,0,0,0,31,253,0,0,2,252,0,0,1,255,244,0,21,23,252,0,0,15,255,208,0,63,255,248,0,0,7,254,0,0,63,255,240,0,0,2,224,0,0,47,255,128,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5217  列
  23,82,32,34,16,36,1,252,0,0,0,0,0,0,0,127,47,255,255,255,252,0,0,127,47,255,255,255,252,0,0,127,47,255,255,255,252,169,0,127,0,3,244,0,0,253,0,127,0,7,240,0,0,253,0,127,0,11,240,0,0,253,0,127,0,15,224,0,0,253,0,127,0,15,208,0,0,253,0,127,0,47,255,255,224,253,0,127,0,63,255,255,240,253,0,127,0,127,255,255,224,253,0,127,0,254,0,15,208,253,0,127,1,252,0,15,192,253,0,127,3,248,0,31,192,253,0,127,11,248,0,47,128,253,0,127,31,255,64,63,64,253,0,127,63,255,224,127,0,253,0,127,255,31,253,190,0,253,0,127,61,3,255,253,0,253,0,127,4,0,191,252,0,253,0,127,0,0,31,248,0,253,0,127,0,0,11,240,0,253,0,127,0,0,31,224,0,84,0,127,0,0,63,192,0,0,0,127,0,0,255,64,0,0,0,127,0,2,254,0,0,0,0,127,0,11,252,0,0,0,0,127,0,63,240,0,0,0,0,127,1,255,192,0,0,1,85,191,11,255,0,0,0,3,255,255,3,252,0,0,0,2,255,253,0,208,0,0,0,1,255,224,0,0,0,0,0,0,0,0,
  // 0x521d  初
  29,82,33,34,50,36,1,253,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,15,255,255,255,255,192,0,15,192,15,255,255,255,255,192,0,15,192,15,255,255,255,255,192,0,15,208,0,2,252,0,47,192,63,255,255,208,1,252,0,47,128,63,255,255,240,2,252,0,47,128,63,255,255,208,2,252,0,47,128,0,0,31,192,2,252,0,63,128,0,0,63,64,2,248,0,63,128,0,0,191,0,2,248,0,63,128,0,0,253,16,3,248,0,63,128,0,3,248,120,3,248,0,63,128,0,11,240,253,3,244,0,63,128,0,31,242,244,3,244,0,63,64,0,63,255,224,7,240,0,63,64,0,255,255,128,7,240,0,63,64,3,255,255,128,11,224,0,63,64,15,255,239,224,15,224,0,63,64,127,239,199,248,15,208,0,63,64,191,143,194,244,47,192,0,63,0,62,15,192,224,63,128,0,127,0,40,15,192,0,127,64,0,127,0,0,15,192,0,255,0,0,127,0,0,15,192,1,253,0,0,191,0,0,15,192,7,252,0,0,254,0,0,15,192,15,244,0,0,254,0,0,15,192,63,224,0,2,253,0,0,15,193,255,192,15,255,252,0,0,15,193,255,0,15,255,248,0,0,15,192,124,0,11,255,224,0,0,15,192,16,0,1,84,0,0,
  // 0x5230  到
  48,82,32,33,8,36,1,253,0,0,0,0,0,0,0,63,63,255,255,255,252,0,0,63,63,255,255,255,252,0,0,63,63,255,255,255,252,126,0,63,0,15,240,0,0,126,0,63,0,15,208,0,0,126,0,63,0,47,192,60,0,126,0,63,0,63,192,254,0,126,0,63,0,63,64,63,64,126,0,63,0,127,0,47,192,126,0,63,0,254,0,15,240,126,0,63,63,255,255,255,244,126,0,63,63,255,255,255,252,126,0,63,63,255,255,255,253,126,0,63,5,85,0,0,126,126,0,63,0,0,190,0,32,126,0,63,0,0,190,0,0,126,0,63,0,0,190,0,0,126,0,63,0,0,190,0,0,126,0,63,15,255,255,255,240,126,0,63,15,255,255,255,240,126,0,63,15,255,255,255,240,126,0,63,0,0,190,0,0,126,0,63,0,0,190,0,0,126,0,63,0,0,190,0,0,0,0,63,0,0,190,0,0,0,0,63,0,0,190,0,88,0,0,63,0,0,191,255,252,0,0,63,26,255,255,255,252,0,0,63,127,255,255,255,248,1,85,191,127,255,250,80,0,3,255,255,62,148,0,0,0,1,255,253,0,0,0,0,0,0,255,228,
  // 0x5236  制
  54,82,33,34,50,36,1,253,0,0,47,0,0,0,0,21,0,1,248,63,64,0,0,0,63,64,2,248,63,64,0,0,0,63,64,3,244,63,64,0,3,224,63,64,3,240,63,64,0,3,240,63,64,7,255,255,255,252,3,240,63,64,15,255,255,255,252,3,240,63,64,31,255,255,255,252,3,240,63,64,47,192,63,64,0,3,240,63,64,63,64,63,64,0,3,240,63,64,127,0,63,64,0,3,240,63,64,10,0,63,64,0,3,240,63,64,127,255,255,255,255,131,240,63,64,127,255,255,255,255,131,240,63,64,127,255,255,255,255,131,240,63,64,0,0,63,64,0,3,240,63,64,0,0,63,64,0,3,240,63,64,0,0,63,64,0,3,240,63,64,15,255,255,255,254,3,240,63,64,15,255,255,255,254,3,240,63,64,15,255,255,255,254,3,240,63,64,15,192,63,64,190,3,240,63,64,15,192,63,64,190,3,240,63,64,15,192,63,64,190,2,160,63,64,15,192,63,64,190,0,0,63,64,15,192,63,64,190,0,0,63,64,15,192,63,64,190,0,0,63,64,15,192,63,64,190,0,0,63,64,15,192,63,95,253,0,0,63,64,15,192,63,79,252,0,0,63,64,15,192,63,79,228,0,85,127,64,0,0,63,64,0,0,255,255,0,0,0,63,64,0,0,191,254,0,0,0,63,64,0,0,63,228,0,
  // 0x5237  刷
  55,82,32,34,16,36,1,253,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,63,7,255,255,255,254,0,0,63,7,255,255,255,254,5,64,63,7,255,255,255,254,15,192,63,7,224,0,0,190,15,192,63,7,224,0,0,190,15,192,63,7,224,0,0,190,15,192,63,7,224,0,0,190,15,192,63,7,255,255,255,254,15,192,63,7,255,255,255,254,15,192,63,7,255,255,255,254,15,192,63,7,224,3,240,0,15,192,63,7,224,3,240,0,15,192,63,7,224,3,240,0,15,192,63,7,224,3,240,0,15,192,63,7,239,255,255,255,15,192,63,7,239,255,255,255,15,192,63,7,239,255,255,255,15,192,63,7,239,67,240,63,15,192,63,11,223,67,240,63,15,192,63,11,223,67,240,63,15,192,63,11,223,67,240,63,15,192,63,15,207,67,240,63,15,192,63,15,207,67,240,63,10,128,63,15,207,67,240,63,0,0,63,31,143,67,240,63,0,0,63,31,143,67,247,254,0,0,63,63,79,67,243,253,0,0,63,63,15,67,241,160,0,0,63,190,0,3,240,0,0,85,191,189,0,3,240,0,0,255,255,28,0,3,240,0,0,191,254,0,0,3,240,0,0,127,228,
  // 0x5275  創
  117,82,32,35,24,36,1,252,0,0,26,64,0,0,0,0,0,0,127,224,0,0,0,63,0,0,255,252,0,0,0,63,0,3,254,255,64,0,0,63,0,11,244,127,208,42,0,63,0,47,224,31,244,63,0,63,0,191,128,3,253,63,0,63,3,255,255,255,255,63,0,63,31,250,255,255,60,63,0,63,191,209,85,85,16,63,0,63,63,64,0,0,0,63,0,63,8,255,255,255,244,63,0,63,0,255,255,255,244,63,0,63,0,253,85,87,244,63,0,63,0,252,0,2,244,63,0,63,0,252,0,2,244,63,0,63,0,255,255,255,244,63,0,63,0,255,255,255,244,63,0,63,0,252,0,2,244,63,0,63,0,253,85,87,244,63,0,63,0,255,255,255,244,63,0,63,1,255,255,255,244,63,0,63,2,244,0,0,0,63,0,63,2,244,0,0,0,63,0,63,3,255,255,255,252,63,0,63,3,255,255,255,252,0,0,63,7,255,213,85,252,0,0,63,11,239,128,0,252,0,0,63,15,223,128,0,252,0,0,63,47,143,128,0,252,0,0,63,127,15,255,255,252,1,85,191,125,15,255,255,252,3,255,255,12,15,234,170,252,1,255,253,0,15,128,0,168,0,255,228,0,0,0,0,0,0,0,0,
  // 0x529b  力
  155,82,31,35,24,36,2,252,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,63,255,255,255,255,255,255,248,63,255,255,255,255,255,255,248,63,255,255,255,255,255,255,248,21,85,85,255,85,85,87,244,0,0,0,254,0,0,3,244,0,0,0,254,0,0,3,244,0,0,0,253,0,0,3,244,0,0,1,252,0,0,3,240,0,0,2,252,0,0,7,240,0,0,3,252,0,0,7,240,0,0,3,248,0,0,7,240,0,0,11,244,0,0,11,240,0,0,15,240,0,0,11,240,0,0,31,224,0,0,11,240,0,0,63,192,0,0,15,224,0,0,191,192,0,0,15,224,0,0,255,0,0,0,15,208,0,3,254,0,0,0,15,208,0,11,252,0,0,0,31,192,0,47,244,0,0,0,47,192,0,191,208,0,0,0,63,192,3,255,128,0,0,0,63,128,31,254,0,0,21,85,255,64,191,244,0,0,15,255,255,0,127,208,0,0,15,255,253,0,30,0,0,0,11,255,224,0,0,0,0,0,0,0,0,0,
  // 0x52a0  加
  160,82,32,34,16,36,1,253,0,5,64,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,2,255,255,255,21,95,213,85,2,255,255,255,63,255,255,255,194,255,255,255,63,255,255,255,194,248,0,191,63,255,255,255,194,248,0,191,0,31,192,31,194,248,0,191,0,31,192,31,130,248,0,191,0,47,128,31,130,248,0,191,0,47,128,47,130,248,0,191,0,47,128,47,130,248,0,191,0,47,128,47,130,248,0,191,0,63,64,47,130,248,0,191,0,63,64,47,130,248,0,191,0,63,0,47,130,248,0,191,0,63,0,47,130,248,0,191,0,127,0,47,130,248,0,191,0,190,0,63,66,248,0,191,0,190,0,63,66,248,0,191,0,253,0,63,66,248,0,191,1,252,0,63,66,248,0,191,2,252,0,63,66,248,0,191,3,244,0,63,2,248,0,191,7,240,0,63,2,248,0,191,15,240,0,127,2,255,255,255,31,208,0,255,2,255,255,255,63,193,255,254,2,255,255,255,191,64,255,252,2,248,0,191,46,0,255,244,2,248,0,191,8,0,20,0,1,84,0,0,
  // 0x52d5  動
  213,82,33,35,59,36,1,252,0,0,0,6,64,5,64,0,0,0,86,175,255,192,15,208,0,0,63,255,255,255,224,15,208,0,0,47,255,254,148,0,15,208,0,0,5,64,252,0,0,15,208,0,0,0,0,252,0,0,15,208,0,0,21,85,254,85,80,15,208,0,0,127,255,255,255,244,15,208,0,0,127,255,255,255,249,95,208,0,0,0,0,252,0,15,255,255,255,128,0,0,252,0,15,255,255,255,128,31,255,255,255,251,255,255,255,128,31,255,255,255,240,15,192,47,128,31,64,252,3,240,15,192,47,128,31,64,252,3,240,15,192,47,128,31,255,255,255,240,31,192,47,128,31,255,255,255,240,31,192,47,128,31,64,252,3,240,31,128,47,128,31,64,252,3,240,47,128,47,64,31,64,253,3,240,63,64,63,64,31,255,255,255,240,63,0,63,64,31,255,255,255,240,63,0,63,64,0,0,252,0,0,191,0,63,64,0,0,252,0,0,254,0,63,64,47,255,255,255,240,253,0,63,0,47,255,255,255,242,252,0,63,0,5,85,254,85,83,248,0,63,0,0,0,252,0,11,240,0,127,0,0,0,252,22,175,224,0,127,0,0,86,255,255,255,192,0,190,0,127,255,255,255,255,128,0,254,0,127,255,254,171,254,3,255,253,0,58,148,0,2,252,1,255,252,0,0,0,0,0,160,0,255,224,0,0,0,0,0,0,0,0,0,0,
  // 0x5316  化
  22,83,34,33,41,36,1,253,0,0,47,128,190,0,0,0,0,0,0,63,192,190,0,0,0,0,0,0,191,64,190,0,0,0,0,0,0,255,0,190,0,0,0,0,0,2,253,0,190,0,0,0,0,0,3,252,0,190,0,0,0,0,0,15,240,0,190,0,0,48,0,0,31,224,0,190,0,0,252,0,0,63,208,0,190,0,7,255,0,0,255,208,0,190,0,47,253,0,3,255,208,0,190,1,255,240,0,11,255,208,0,190,11,255,64,0,47,255,208,0,190,127,248,0,0,191,239,208,0,191,255,208,0,0,255,143,208,0,191,253,0,0,0,127,15,208,0,191,224,0,0,0,60,15,208,0,191,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,7,128,0,15,208,0,190,0,0,11,224,0,15,208,0,190,0,0,11,224,0,15,208,0,190,0,0,11,208,0,15,208,0,191,0,0,15,208,0,15,208,0,127,64,0,47,192,0,15,208,0,63,255,255,255,192,0,15,208,0,63,255,255,255,64,0,15,208,0,11,255,255,253,0,0,10,128,0,0,0,0,0,0,
  // 0x534a  半
  74,83,32,34,16,36,2,253,0,0,0,15,224,0,0,0,0,120,0,15,224,0,62,0,2,252,0,15,224,0,127,192,0,254,0,15,224,0,191,0,0,191,64,15,224,0,254,0,0,63,192,15,224,2,252,0,0,47,208,15,224,3,248,0,0,15,240,15,224,11,240,0,0,11,240,15,224,31,208,0,0,7,144,15,224,7,192,0,0,0,0,15,224,0,0,0,1,85,85,95,229,85,85,80,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,85,85,85,95,245,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,
  // 0x5354  協
  84,83,33,35,59,36,1,252,0,127,0,0,0,189,0,0,0,0,127,0,0,0,253,0,0,0,0,127,0,0,0,252,0,0,0,0,127,0,0,0,252,0,0,0,0,127,0,47,255,255,255,254,0,0,127,0,47,255,255,255,254,0,0,127,0,26,171,254,170,254,0,0,127,0,0,3,240,0,189,0,0,127,0,0,11,224,0,189,0,0,127,0,0,31,192,0,252,0,191,255,255,0,63,128,0,252,0,191,255,255,1,255,0,2,252,0,191,255,255,27,252,3,255,248,0,0,127,0,255,224,1,255,240,0,0,127,0,127,64,0,170,64,0,0,127,0,36,0,0,0,0,0,0,127,0,47,0,0,63,0,0,0,127,0,47,0,0,63,0,0,0,127,0,47,0,0,63,0,0,0,127,10,191,170,138,191,170,128,0,127,15,255,255,207,255,255,192,0,127,15,255,255,207,255,255,192,0,127,0,63,15,192,126,15,192,0,127,0,62,15,192,189,15,192,0,127,0,125,15,192,188,15,192,0,127,0,189,15,192,252,15,192,0,127,0,252,15,128,248,15,192,0,127,0,248,15,130,244,15,128,0,127,2,244,15,131,240,15,128,0,127,3,240,31,139,224,15,128,0,127,11,208,31,95,192,31,64,0,127,47,198,191,127,134,191,64,0,127,47,3,255,62,7,255,0,0,127,9,3,248,8,3,252,0,0,0,0,0,0,0,0,0,0,
  // 0x5361  卡
  97,83,32,34,16,36,2,253,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,255,255,255,0,0,0,0,47,255,255,255,0,0,0,0,47,255,255,255,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,111,213,85,85,85,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,238,0,0,0,0,0,0,47,255,248,0,0,0,0,0,47,255,255,208,0,0,0,0,47,203,255,254,0,0,0,0,47,192,111,255,208,0,0,0,47,192,1,255,192,0,0,0,47,192,0,31,64,0,0,0,47,192,0,1,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,31,192,0,0,0,
  // 0x5370  印
  112,83,30,34,16,36,3,253,0,0,6,0,0,0,0,0,0,0,127,192,0,0,0,0,0,7,255,224,85,85,85,80,17,191,255,145,255,255,255,240,127,255,248,1,255,255,255,240,127,254,64,1,255,255,255,240,127,144,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,64,0,1,252,0,3,240,127,255,255,209,252,0,3,240,127,255,255,209,252,0,3,240,127,255,255,209,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,255,255,225,252,0,7,240,127,255,255,225,252,15,255,240,127,255,255,225,252,11,255,240,127,64,0,1,252,7,255,192,127,0,0,1,252,2,148,0,127,0,0,1,252,0,0,0,21,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,
  // 0x5378  卸
  120,83,32,34,16,36,1,253,0,62,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,127,0,0,2,255,255,255,0,254,0,0,2,255,255,255,0,255,255,255,226,255,255,255,2,255,255,255,226,252,0,63,7,255,255,255,226,248,0,63,15,224,126,0,2,248,0,63,47,192,126,0,2,248,0,63,63,128,126,0,2,248,0,63,15,0,126,0,2,248,0,63,0,0,126,0,2,248,0,63,63,255,255,255,242,248,0,63,63,255,255,255,242,248,0,63,63,255,255,255,242,248,0,63,0,0,126,0,2,248,0,63,0,0,126,0,2,248,0,63,1,80,126,0,2,248,0,63,3,224,126,0,2,248,0,63,3,224,127,255,194,248,0,63,3,224,127,255,194,248,0,63,3,224,127,255,194,248,0,63,3,224,126,0,2,248,0,63,3,224,126,0,2,248,0,63,3,224,126,0,2,248,0,63,3,224,126,0,2,248,63,255,3,224,126,6,178,248,47,255,3,224,191,255,246,248,31,253,27,255,255,255,246,248,5,64,191,255,255,254,82,248,0,0,191,255,233,0,2,248,0,0,126,144,0,0,2,248,0,0,0,0,0,0,2,248,0,0,0,0,0,0,2,248,0,0,
  // 0x537b  卻
  123,83,32,34,16,36,1,253,0,0,21,0,0,0,0,0,0,0,255,128,0,0,0,0,0,2,255,240,1,255,255,255,0,7,255,252,1,255,255,255,0,31,242,255,1,255,255,255,0,127,192,191,209,252,0,63,1,255,0,31,241,252,0,63,11,252,0,11,245,252,0,63,63,240,0,2,225,252,0,63,15,128,106,0,129,252,0,63,5,0,255,192,1,252,0,63,0,2,255,240,1,252,0,63,0,7,255,252,1,252,0,63,0,15,242,255,1,252,0,63,0,63,192,191,193,252,0,63,0,255,64,47,241,252,0,63,3,253,0,11,249,252,0,63,15,244,0,3,245,252,0,63,127,208,0,0,225,252,0,63,191,255,255,255,129,252,0,63,45,255,255,255,65,252,0,63,0,255,255,255,65,252,0,63,0,252,0,47,65,252,0,63,0,252,0,47,65,252,0,63,0,252,0,47,65,252,63,255,0,252,0,47,65,252,47,255,0,252,0,47,65,252,31,252,0,252,0,47,65,252,5,64,0,255,255,255,65,252,0,0,0,255,255,255,65,252,0,0,0,255,255,255,65,252,0,0,0,252,0,47,65,252,0,0,0,252,0,47,65,252,0,0,0,84,0,0,1,248,0,0,
  // 0x539f  原
  159,83,33,32,32,36,1,253,1,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,192,1,252,0,0,31,208,0,0,0,1,252,0,0,47,192,0,0,0,1,252,0,0,63,192,0,0,0,1,252,31,255,255,255,255,240,0,1,252,31,255,255,255,255,240,0,1,252,31,234,170,170,171,240,0,1,252,31,192,0,0,7,240,0,1,252,31,192,0,0,7,240,0,1,252,31,213,85,85,91,240,0,1,252,31,255,255,255,255,240,0,1,252,31,255,255,255,255,240,0,2,252,31,192,0,0,7,240,0,2,248,31,192,0,0,7,240,0,2,248,31,192,0,0,7,240,0,2,248,31,255,255,255,255,240,0,3,244,31,255,255,255,255,240,0,3,244,10,170,175,234,170,160,0,3,244,0,0,15,208,0,0,0,3,240,0,144,15,208,28,0,0,7,240,2,252,15,208,191,0,0,11,240,7,248,15,208,63,208,0,15,224,15,240,15,208,15,244,0,15,208,63,192,15,208,3,252,0,31,192,255,64,15,208,0,255,0,47,199,253,0,15,208,0,127,192,63,79,244,0,15,208,0,31,192,191,2,208,31,255,208,0,10,0,126,0,0,15,255,192,0,0,0,5,0,0,11,254,0,0,0,0,
  // 0x53cd  反
  205,83,32,33,8,36,2,252,0,255,255,255,255,255,255,248,0,255,255,255,255,255,255,248,0,255,255,255,255,255,255,248,0,254,85,85,85,85,85,80,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,254,0,0,0,0,4,0,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,0,0,253,47,192,0,0,255,0,0,252,15,224,0,1,253,0,0,252,11,240,0,3,252,0,0,252,7,248,0,7,248,0,1,252,3,252,0,15,240,0,1,252,1,254,0,47,224,0,2,252,0,191,128,127,192,0,2,248,0,63,209,255,64,0,3,244,0,31,247,254,0,0,3,244,0,11,255,248,0,0,7,240,0,2,255,240,0,0,11,240,0,2,255,224,0,0,15,208,0,31,255,253,0,0,31,192,0,255,255,255,208,0,63,192,31,255,193,255,254,64,127,70,255,253,0,47,255,249,255,11,255,224,0,7,255,253,125,3,254,0,0,0,47,248,8,1,144,0,0,0,1,176,0,0,0,0,0,0,0,0,
  // 0x53d6  取
  214,83,34,32,32,36,1,253,63,255,255,255,244,0,0,0,0,63,255,255,255,244,0,0,0,0,63,255,255,255,244,0,0,0,0,2,248,0,127,47,255,255,255,64,2,248,0,63,31,255,255,255,64,2,248,0,63,31,255,255,255,64,2,248,0,63,5,149,85,127,0,2,248,0,63,15,208,0,127,0,2,255,255,255,15,224,0,127,0,2,255,255,255,11,240,0,190,0,2,255,255,255,7,240,0,253,0,2,248,0,63,3,244,0,252,0,2,248,0,63,3,248,1,252,0,2,248,0,63,1,252,3,248,0,2,248,0,63,0,253,3,244,0,2,255,255,255,0,255,11,240,0,2,255,255,255,0,127,15,224,0,2,255,255,255,0,63,175,208,0,2,248,0,63,0,31,255,192,0,2,248,0,63,0,15,255,64,0,2,248,0,63,0,11,255,0,0,2,248,0,63,0,3,253,0,0,2,248,26,255,0,7,253,0,0,7,255,255,255,0,15,255,64,0,255,255,255,255,0,63,255,192,0,191,255,254,191,0,255,175,240,0,127,229,0,63,3,255,15,252,0,16,0,0,63,31,252,3,255,64,0,0,0,63,191,240,0,255,224,0,0,0,63,127,128,0,63,208,0,0,0,63,45,0,0,11,128,0,0,0,63,0,0,0,1,0,
  // 0x53f0  台
  240,83,32,34,16,36,2,253,0,0,3,208,0,0,0,0,0,0,3,252,0,0,0,0,0,0,11,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,47,208,0,9,0,0,0,0,63,192,0,63,64,0,0,0,191,64,0,191,208,0,0,0,254,0,0,31,244,0,0,3,252,0,0,7,254,0,0,7,244,0,0,1,255,64,0,15,245,170,175,255,255,208,191,255,255,255,255,255,255,244,191,255,255,255,255,255,255,252,127,255,255,250,170,85,66,255,21,64,0,0,0,0,0,255,0,0,0,0,0,0,0,120,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,191,0,0,0,1,254,0,0,127,0,0,0,0,253,0,
  // 0x5408  合
  8,84,34,35,59,36,1,252,0,0,0,3,248,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,47,255,64,0,0,0,0,0,0,127,255,192,0,0,0,0,0,1,255,31,240,0,0,0,0,0,7,253,11,252,0,0,0,0,0,31,248,2,255,64,0,0,0,0,127,224,0,191,208,0,0,0,1,255,128,0,47,248,0,0,0,11,254,0,0,7,255,0,0,0,63,248,0,0,1,255,208,0,1,255,208,0,0,0,127,253,0,15,255,255,255,255,255,255,255,128,127,248,255,255,255,255,241,255,224,63,192,255,255,255,255,240,47,192,13,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,0,0,0,15,255,255,255,255,255,0,0,0,15,255,255,255,255,255,0,0,0,15,208,0,0,0,127,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,255,255,255,255,255,0,0,0,15,255,255,255,255,255,0,0,0,15,255,255,255,255,255,0,0,0,15,208,0,0,0,63,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5426  否
  38,84,33,32,32,36,1,253,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,0,0,0,0,255,192,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,127,248,4,0,0,0,0,0,2,255,248,63,128,0,0,0,0,31,255,248,255,248,0,0,0,1,255,247,248,47,255,64,0,0,31,255,131,248,2,255,240,0,1,255,253,3,248,0,47,254,0,111,255,224,3,248,0,7,255,192,63,254,0,3,248,0,0,191,192,31,224,0,3,248,0,0,31,0,10,0,0,3,248,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,47,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,26,128,0,
  // 0x544a  告
  74,84,32,35,24,36,2,252,0,6,64,3,248,0,0,0,0,15,240,3,248,0,0,0,0,15,208,3,248,0,0,0,0,47,192,3,248,0,0,0,0,63,128,3,248,0,0,0,0,191,255,255,255,255,255,208,1,255,255,255,255,255,255,208,3,255,255,255,255,255,255,208,11,244,0,3,248,0,0,0,31,240,0,3,248,0,0,0,63,192,0,3,248,0,0,0,31,64,0,3,248,0,0,0,1,0,0,3,248,0,0,0,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,0,0,0,0,0,0,0,
  // 0x547d  命
  125,84,34,35,59,36,1,252,0,0,0,11,252,0,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,127,255,128,0,0,0,0,0,1,255,111,224,0,0,0,0,0,7,253,11,252,0,0,0,0,0,47,248,2,255,0,0,0,0,0,255,208,0,191,208,0,0,0,7,255,64,0,31,248,0,0,0,47,252,0,0,3,255,64,0,2,255,255,255,255,255,255,240,0,31,255,223,255,255,255,111,255,64,255,253,15,255,255,255,71,255,240,127,224,0,0,0,0,0,191,208,46,0,0,0,0,0,0,11,128,0,0,0,0,0,0,0,0,0,0,255,255,252,15,255,255,248,0,0,255,255,252,15,255,255,248,0,0,255,255,252,15,255,255,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,255,255,252,15,192,2,248,0,0,255,255,252,15,192,2,248,0,0,255,255,252,15,195,255,244,0,0,252,0,0,15,194,255,240,0,0,252,0,0,15,193,255,144,0,0,252,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x548c  和
  140,84,32,34,16,36,1,253,0,0,0,4,0,0,0,0,0,0,1,252,0,0,0,0,0,1,191,255,0,0,0,0,6,255,255,255,64,0,0,0,47,255,255,144,15,255,255,254,15,255,252,0,15,255,255,254,4,1,252,0,15,255,255,254,0,1,252,0,15,192,0,254,0,1,252,0,15,192,0,254,0,1,252,0,15,192,0,254,0,1,252,0,15,192,0,254,63,255,255,255,143,192,0,254,63,255,255,255,143,192,0,254,63,255,255,255,143,192,0,254,0,7,252,0,15,192,0,254,0,15,254,0,15,192,0,254,0,15,255,64,15,192,0,254,0,47,255,208,15,192,0,254,0,63,255,240,15,192,0,254,0,191,254,252,15,192,0,254,0,253,252,255,15,192,0,254,3,245,252,63,143,192,0,254,7,241,252,47,15,192,0,254,15,209,252,13,15,192,0,254,63,193,252,0,15,192,0,254,191,65,252,0,15,192,0,254,190,1,252,0,15,255,255,254,60,1,252,0,15,255,255,254,16,1,252,0,15,255,255,254,0,1,252,0,15,208,0,254,0,1,252,0,15,192,0,254,0,1,252,0,15,192,0,254,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,
  // 0x555f  啟
  95,85,34,35,59,36,1,252,0,0,100,0,0,3,160,0,0,0,1,252,0,0,7,240,0,0,0,0,252,0,0,11,224,0,0,0,0,190,0,0,11,208,0,0,0,0,127,0,0,15,192,0,0,3,255,255,255,192,15,192,0,0,3,255,255,255,192,31,192,0,0,3,255,255,255,192,47,255,255,208,3,240,0,15,192,63,255,255,208,3,240,0,15,192,127,255,255,208,3,240,0,15,192,191,0,190,0,3,240,0,15,192,255,0,189,0,3,240,0,15,194,255,0,253,0,3,255,255,255,195,255,64,252,0,3,255,255,255,203,255,64,252,0,3,255,255,255,223,239,129,252,0,3,240,0,0,7,207,194,248,0,3,240,0,0,1,75,211,244,0,7,240,0,0,0,7,227,240,0,7,250,170,170,144,3,247,240,0,7,239,255,255,224,3,255,208,0,7,239,255,255,224,1,255,192,0,11,223,192,7,224,0,255,192,0,15,223,192,7,224,0,191,64,0,15,207,192,7,224,0,191,0,0,15,207,192,7,224,1,255,128,0,31,143,192,7,224,3,255,208,0,47,143,192,7,224,11,255,240,0,63,79,234,175,224,31,231,248,0,127,15,255,255,224,127,194,254,0,190,15,255,255,226,255,0,255,128,44,15,192,7,235,253,0,63,224,4,15,192,7,227,240,0,15,192,0,5,64,0,1,192,0,2,0,0,0,0,0,0,0,0,0,0,
  // 0x55ae  單
  174,85,32,32,0,36,2,253,7,255,255,252,47,255,255,224,7,255,255,252,47,255,255,224,7,224,1,252,47,64,11,224,7,224,1,252,47,64,11,224,7,224,1,252,47,64,11,224,7,255,255,252,47,255,255,224,7,255,255,252,47,255,255,224,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,64,1,255,255,255,255,255,255,128,1,255,255,255,255,255,255,128,1,252,0,15,224,0,63,128,1,252,0,15,224,0,63,128,1,253,85,95,245,85,127,128,1,255,255,255,255,255,255,128,1,255,255,255,255,255,255,128,1,252,0,15,224,0,63,128,1,252,0,15,224,0,63,128,1,252,0,15,224,0,63,128,1,255,255,255,255,255,255,128,1,255,255,255,255,255,255,128,0,170,170,175,250,170,170,64,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,191,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,10,144,0,0,0,
  // 0x5634  嘴
  52,86,33,35,59,36,2,252,0,0,0,2,240,15,192,0,0,0,0,0,3,240,15,192,0,0,0,0,1,131,240,15,192,112,0,127,255,195,211,240,15,194,252,0,127,255,195,211,255,223,239,244,0,127,255,195,211,255,223,255,64,0,124,11,195,211,245,79,244,0,0,124,11,195,211,240,15,192,0,0,124,11,195,211,240,15,192,15,64,124,11,195,211,246,159,192,15,64,124,11,195,255,255,223,229,111,64,124,11,239,255,255,219,255,255,0,124,11,239,255,252,2,255,252,0,124,11,218,67,248,1,0,0,0,124,11,192,11,255,255,192,0,0,124,11,192,31,255,255,208,0,0,124,11,192,127,64,47,128,0,0,124,11,193,255,0,127,64,0,0,124,11,203,255,255,255,255,248,0,124,11,255,255,255,255,255,248,0,127,255,207,190,0,248,2,248,0,127,255,192,126,0,248,2,248,0,127,255,192,127,255,255,255,248,0,124,0,0,127,255,255,255,248,0,124,0,0,190,0,248,2,248,0,124,0,0,189,0,248,2,248,0,40,0,0,254,1,252,2,248,0,0,0,0,255,255,255,255,248,0,0,0,2,255,255,255,255,248,0,0,0,3,248,0,0,2,248,0,0,0,15,240,0,0,2,248,0,0,0,63,208,0,1,87,244,0,0,0,191,64,0,3,255,240,0,0,0,29,0,0,1,255,144,0,0,0,0,0,0,0,0,0,0,
  // 0x5668  器
  104,86,34,34,50,36,1,252,1,170,170,168,2,170,170,168,0,2,255,255,252,3,255,255,248,0,2,255,255,252,3,255,255,248,0,2,244,0,252,3,240,1,248,0,2,244,0,252,3,240,1,248,0,2,244,0,252,3,240,1,248,0,2,244,0,252,3,240,1,248,0,2,244,0,252,3,240,1,248,0,2,254,170,252,3,250,171,248,0,2,255,255,252,3,255,255,248,0,2,255,255,255,147,255,255,248,0,0,0,0,15,240,0,0,0,0,0,0,0,63,192,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,63,240,0,255,64,0,0,0,1,255,192,0,63,224,0,0,0,11,255,0,0,31,253,0,0,0,191,252,0,0,3,255,208,0,27,255,224,0,0,0,255,253,0,255,255,255,253,11,255,255,255,224,127,255,255,253,11,255,255,255,208,47,255,255,253,11,255,255,255,128,0,252,0,189,11,208,3,240,0,0,252,0,189,11,208,3,240,0,0,252,0,189,11,208,3,240,0,0,252,0,189,11,208,3,240,0,0,252,0,189,11,208,3,240,0,0,255,255,253,11,255,255,240,0,0,255,255,253,11,255,255,240,0,0,255,255,253,11,255,255,240,0,0,252,0,189,11,208,3,240,0,0,0,0,0,0,0,0,0,0,
  // 0x5674  噴
  116,86,33,35,59,36,2,252,0,0,0,0,0,252,0,0,0,0,0,0,0,0,252,0,0,0,0,0,0,85,85,253,85,84,0,0,0,0,255,255,255,255,252,0,127,255,240,255,255,255,255,252,0,127,255,240,0,0,252,0,0,0,127,255,240,7,208,252,47,0,0,125,3,240,7,208,168,47,0,0,125,3,241,91,229,85,127,85,0,125,3,251,255,255,255,255,255,128,125,3,251,255,255,255,255,255,128,125,3,240,7,208,0,47,0,0,125,3,240,7,208,0,47,0,0,125,3,240,0,0,0,0,0,0,125,3,240,127,255,255,255,240,0,125,3,240,127,255,255,255,240,0,125,3,240,126,0,0,3,240,0,125,3,240,126,0,0,3,240,0,125,3,240,127,255,255,255,240,0,125,3,240,127,255,255,255,240,0,125,3,240,126,0,0,3,240,0,127,255,240,126,0,0,3,240,0,127,255,240,127,255,255,255,240,0,127,255,240,127,255,255,255,240,0,125,0,0,126,0,0,3,240,0,125,0,0,126,0,0,3,240,0,61,0,0,127,255,255,255,240,0,0,0,0,127,255,255,255,240,0,0,0,0,2,228,0,248,0,0,0,0,0,31,252,2,255,64,0,0,0,6,255,224,0,127,244,0,0,0,127,255,0,0,11,254,0,0,0,63,228,0,0,0,255,64,0,0,14,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,
  // 0x56de  回
  222,86,30,33,8,36,3,253,85,85,85,85,85,85,85,80,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,255,255,255,240,11,240,253,0,255,255,255,240,11,240,253,0,255,255,255,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,255,255,255,240,11,240,253,0,255,255,255,240,11,240,253,0,255,255,255,240,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,254,0,0,0,0,0,11,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,
  // 0x56e0  因
  224,86,30,32,0,36,3,253,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,253,0,0,0,0,0,7,240,253,0,0,26,64,0,7,240,253,0,0,47,64,0,7,240,253,0,0,63,64,0,7,240,253,0,0,63,64,0,7,240,253,0,0,63,0,0,7,240,253,0,0,63,0,0,7,240,253,63,255,255,255,255,199,240,253,63,255,255,255,255,199,240,253,63,255,255,255,255,199,240,253,0,0,127,192,0,7,240,253,0,0,191,208,0,7,240,253,0,0,255,240,0,7,240,253,0,1,255,240,0,7,240,253,0,3,249,252,0,7,240,253,0,7,240,253,0,7,240,253,0,31,240,191,64,7,240,253,0,127,192,63,208,7,240,253,1,255,64,15,248,7,240,253,31,253,0,7,255,135,240,253,63,240,0,0,255,135,240,253,31,128,0,0,47,7,240,253,4,0,0,0,0,7,240,253,0,0,0,0,0,7,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,7,240,
  // 0x56fa  固
  250,86,30,32,0,36,3,253,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,253,0,0,0,0,0,11,240,253,0,0,21,64,0,11,240,253,0,0,47,128,0,11,240,253,0,0,47,128,0,11,240,253,0,0,47,128,0,11,240,253,26,170,191,234,170,139,240,253,47,255,255,255,255,139,240,253,47,255,255,255,255,139,240,253,0,0,47,128,0,11,240,253,0,0,47,128,0,11,240,253,0,0,47,128,0,11,240,253,1,170,191,234,164,11,240,253,2,255,255,255,252,11,240,253,2,255,255,255,252,11,240,253,2,244,0,1,252,11,240,253,2,244,0,1,252,11,240,253,2,244,0,1,252,11,240,253,2,244,0,1,252,11,240,253,2,254,170,170,252,11,240,253,2,255,255,255,252,11,240,253,2,255,255,255,252,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,254,0,0,0,0,0,11,240,253,0,0,0,0,0,7,240,
  // 0x5716  圖
  22,87,30,34,16,36,3,252,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,252,0,0,0,0,0,3,240,252,0,0,0,0,0,3,240,252,0,255,255,255,240,3,240,252,0,255,255,255,240,3,240,252,0,248,0,3,240,3,240,252,0,248,0,3,240,3,240,252,0,255,255,255,240,3,240,252,0,255,255,255,240,3,240,252,0,0,47,64,0,3,240,252,127,255,255,255,255,211,240,252,127,255,255,255,255,211,240,252,0,0,0,0,0,3,240,252,7,255,255,255,252,3,240,252,7,255,255,255,253,3,240,252,7,208,0,0,125,3,240,252,7,209,170,164,125,3,240,252,7,211,255,248,125,3,240,252,7,211,192,120,125,3,240,252,7,211,192,120,125,3,240,252,7,211,255,248,125,3,240,252,7,209,170,164,125,3,240,252,7,208,0,0,125,3,240,252,7,255,255,255,253,3,240,252,7,255,255,255,253,3,240,252,0,0,0,0,0,3,240,252,0,0,0,0,0,3,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,252,0,0,0,0,0,3,240,0,0,0,0,0,0,0,0,
  // 0x5728  在
  40,87,33,34,50,36,1,253,0,0,0,100,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,0,0,47,192,0,0,0,0,0,0,0,127,128,0,20,0,0,0,0,0,255,0,0,190,0,0,0,0,2,253,0,0,190,0,0,0,0,7,252,0,0,190,0,0,0,0,15,240,0,0,190,0,0,0,0,63,208,0,0,190,0,0,0,0,191,192,0,0,190,0,0,0,2,255,192,127,255,255,255,253,0,15,255,192,127,255,255,255,253,0,63,255,192,127,255,255,255,253,0,127,223,192,0,0,254,0,0,0,63,31,192,0,0,190,0,0,0,24,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,254,0,0,0,0,31,195,255,255,255,255,255,128,0,31,195,255,255,255,255,255,128,0,31,195,255,255,255,255,255,128,0,31,192,0,0,0,0,0,0,
  // 0x578b  型
  139,87,32,33,8,36,2,254,0,0,0,0,0,0,3,240,31,255,255,255,224,0,3,240,31,255,255,255,224,190,3,240,31,255,255,255,224,190,3,240,0,63,1,252,0,190,3,240,0,63,1,252,0,190,3,240,0,63,1,252,0,190,3,240,0,63,1,252,0,190,3,240,0,63,1,252,0,190,3,240,191,255,255,255,248,190,3,240,191,255,255,255,248,190,3,240,191,255,255,255,248,190,3,240,0,190,1,252,0,190,3,240,0,253,1,252,0,190,3,240,1,252,1,252,0,20,3,240,3,248,1,252,0,0,3,240,15,240,1,252,0,0,3,240,127,208,1,252,0,11,255,240,191,128,1,252,0,3,255,240,62,0,0,175,240,3,255,128,4,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,1,255,255,255,255,255,255,64,1,255,255,255,255,255,255,64,1,255,255,255,255,255,255,64,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x57f7  執
  247,87,34,35,59,36,1,252,0,3,240,0,0,126,0,0,0,0,3,240,0,0,126,0,0,0,0,3,240,0,0,126,0,0,0,0,3,240,0,0,126,0,0,0,15,255,255,252,0,126,0,0,0,15,255,255,252,0,126,0,0,0,15,255,255,252,0,126,0,0,0,0,3,240,0,0,127,0,0,0,0,3,240,0,255,255,255,244,0,127,255,255,255,255,255,255,244,0,127,255,255,255,128,127,255,244,0,127,255,255,255,128,126,3,244,0,2,224,1,244,0,126,3,244,0,3,240,2,244,0,126,3,244,0,2,244,3,240,0,190,3,244,0,0,248,3,240,32,190,3,244,0,0,252,7,208,189,190,3,244,0,0,252,7,192,255,253,3,244,0,63,255,255,255,127,253,3,244,0,63,255,255,255,11,253,3,244,0,63,255,255,255,2,255,131,244,0,0,3,240,0,2,255,226,244,0,0,3,240,0,3,255,250,244,0,0,3,240,0,3,246,254,244,0,47,255,255,254,11,240,182,244,0,47,255,255,254,15,224,18,244,128,31,255,255,253,47,192,1,248,240,0,3,240,0,127,128,1,248,240,0,3,240,0,255,0,0,252,240,0,3,240,3,253,0,0,252,240,0,3,240,15,248,0,0,191,240,0,3,240,63,240,0,0,127,224,0,3,240,31,192,0,0,63,192,0,3,240,6,0,0,0,11,128,0,0,0,0,0,0,0,0,0,
  // 0x584a  塊
  74,88,34,35,59,36,1,252,0,42,0,0,0,250,0,0,0,0,63,0,0,0,254,0,0,0,0,63,0,0,1,252,0,0,0,0,63,0,0,3,252,0,0,0,0,63,0,127,255,255,255,255,0,0,63,0,127,255,255,255,255,0,0,63,0,127,255,255,255,255,0,0,63,0,126,0,190,0,127,0,63,255,254,126,0,190,0,127,0,63,255,254,126,0,190,0,127,0,63,255,254,127,255,255,255,255,0,0,63,0,127,255,255,255,255,0,0,63,0,127,170,255,170,191,0,0,63,0,126,0,190,0,127,0,0,63,0,126,0,190,0,127,0,0,63,0,126,0,190,0,127,0,0,63,0,127,255,255,255,255,0,0,63,0,127,255,255,255,255,0,0,63,0,127,255,255,255,255,0,0,63,1,0,252,63,65,0,0,0,63,111,1,252,63,75,192,0,0,63,255,65,252,63,75,128,0,1,255,255,2,252,63,79,95,0,111,255,228,2,248,63,79,15,0,191,254,0,3,244,63,95,31,128,63,208,0,3,240,63,191,255,192,57,0,0,11,240,63,191,255,208,0,0,0,15,224,63,105,2,64,0,0,0,63,192,63,64,2,0,0,0,0,255,128,63,64,3,208,0,0,7,255,0,47,64,7,224,0,0,191,252,0,47,255,255,208,0,0,127,224,0,31,255,255,192,0,0,47,64,0,6,255,254,0,0,0,0,0,0,0,0,0,0,
  // 0x586b  填
  107,88,34,35,59,36,1,252,0,21,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,1,255,255,255,255,255,192,0,63,1,255,255,255,255,255,192,0,63,1,255,255,255,255,255,192,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,11,255,255,255,244,0,63,255,254,11,255,255,255,244,0,63,255,254,11,208,0,3,244,0,63,255,254,11,208,0,3,244,0,0,63,0,11,255,255,255,244,0,0,63,0,11,255,255,255,244,0,0,63,0,11,208,0,3,244,0,0,63,0,11,208,0,3,244,0,0,63,0,11,255,255,255,244,0,0,63,0,11,255,255,255,244,0,0,63,0,11,208,0,3,244,0,0,63,0,11,208,0,3,244,0,0,63,11,11,255,255,255,244,0,0,63,255,11,255,255,255,244,0,0,63,255,64,0,0,0,0,0,2,255,254,0,0,0,0,0,0,111,255,235,255,255,255,255,255,208,191,254,11,255,255,255,255,255,224,63,208,11,255,255,255,255,255,224,61,0,0,0,16,0,8,0,0,0,0,0,1,255,0,127,64,0,0,0,0,11,253,0,127,224,0,0,0,1,191,240,0,11,253,0,0,0,15,255,128,0,1,255,128,0,0,11,248,0,0,0,63,208,0,0,2,144,0,0,0,10,0,0,0,0,0,0,0,0,0,0,
  // 0x588a  墊
  138,88,34,33,41,36,1,254,0,2,244,0,0,47,0,0,0,0,3,244,0,0,63,0,0,0,5,87,245,84,0,63,0,0,0,15,255,255,253,0,63,0,0,0,15,255,255,253,47,255,255,240,0,0,3,244,0,63,255,255,240,0,21,87,244,0,63,255,255,240,0,127,255,255,255,213,127,3,240,0,127,255,255,255,192,63,3,240,0,2,240,2,240,0,63,3,240,0,1,244,3,224,45,62,3,240,0,0,248,7,192,127,254,3,240,0,63,255,255,255,223,253,3,240,0,63,255,255,255,194,255,67,240,0,21,87,249,85,65,255,227,240,0,0,3,244,0,3,255,250,240,64,5,87,249,84,7,242,242,240,208,15,255,255,254,15,208,146,244,240,15,255,255,254,63,192,1,244,240,0,3,244,0,255,0,0,253,224,0,3,244,2,253,0,0,255,208,0,3,244,1,244,0,0,127,192,0,0,0,2,248,0,0,31,64,0,0,0,2,248,0,0,0,0,0,191,255,255,255,255,255,224,0,0,191,255,255,255,255,255,224,0,0,191,255,255,255,255,255,208,0,0,0,0,2,248,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,2,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,
  // 0x5916  外
  22,89,34,34,50,36,1,253,0,0,164,0,0,3,244,0,0,0,0,254,0,0,3,244,0,0,0,0,253,0,0,3,244,0,0,0,2,252,0,0,3,244,0,0,0,3,248,0,0,3,244,0,0,0,3,248,0,0,3,244,0,0,0,11,255,255,248,3,244,0,0,0,15,255,255,252,3,244,0,0,0,31,255,255,252,3,244,0,0,0,63,192,3,255,3,244,0,0,0,127,64,3,255,195,244,0,0,0,255,0,7,255,211,244,0,0,2,252,0,11,251,243,244,0,0,7,252,0,15,227,255,244,0,0,15,254,0,15,208,255,244,0,0,63,255,208,31,192,127,244,0,0,255,175,248,63,128,47,244,0,0,47,7,255,127,64,15,248,0,0,8,0,255,255,0,3,255,0,0,0,0,47,254,0,3,255,208,0,0,0,11,252,0,3,255,248,0,0,0,3,248,0,3,255,255,64,0,0,15,240,0,3,246,255,240,0,0,47,208,0,3,244,127,224,0,0,63,192,0,3,244,11,128,0,0,255,64,0,3,244,1,0,0,3,254,0,0,3,244,0,0,0,15,248,0,0,3,244,0,0,0,63,240,0,0,3,244,0,0,1,255,192,0,0,3,244,0,0,15,255,0,0,0,3,244,0,0,47,248,0,0,0,3,244,0,0,11,208,0,0,0,3,244,0,0,2,0,0,0,0,3,244,0,0,
  // 0x591a  多
  26,89,32,35,24,36,2,252,0,0,0,46,64,0,0,0,0,0,0,191,192,0,0,0,0,0,2,255,0,0,0,0,0,0,11,255,255,255,224,0,0,0,127,255,255,255,244,0,0,2,255,255,255,255,224,0,0,47,253,0,0,63,192,0,6,255,252,0,0,255,64,0,63,255,255,128,3,253,0,0,31,244,127,244,15,248,0,0,11,64,11,254,127,224,0,0,0,0,1,255,255,64,0,0,0,0,0,127,253,64,0,0,0,0,2,255,231,252,0,0,0,0,127,255,79,244,0,0,0,27,255,244,127,224,0,0,26,255,255,66,255,255,255,248,127,255,224,15,255,255,255,253,47,249,0,191,255,255,255,252,25,0,11,255,128,0,11,244,0,0,191,253,0,0,31,240,0,31,255,255,64,0,63,192,0,127,253,191,240,0,255,64,0,31,144,31,253,3,254,0,0,8,0,2,255,159,248,0,0,0,0,0,127,255,224,0,0,0,0,0,31,255,64,0,0,0,0,0,191,252,0,0,0,0,0,27,255,224,0,0,0,0,22,255,254,0,0,0,0,91,255,255,224,0,0,0,2,255,255,249,0,0,0,0,0,255,254,64,0,0,0,0,0,186,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5920  夠
  32,89,33,34,50,36,1,253,0,3,224,0,0,164,0,0,0,0,7,240,0,0,252,0,0,0,0,15,192,0,1,248,0,0,0,0,63,234,168,3,244,0,0,0,0,191,255,254,7,240,0,0,0,2,255,255,252,11,255,255,255,128,7,244,1,252,15,255,255,255,128,47,208,3,244,47,255,255,255,128,127,132,11,240,127,0,0,31,128,30,62,31,208,254,0,0,47,64,4,127,255,130,252,0,0,47,64,0,31,255,7,248,0,0,47,64,0,7,252,11,251,255,252,47,64,0,47,240,1,219,255,252,47,64,1,255,255,0,11,234,252,47,64,31,254,254,0,11,192,124,47,64,47,245,252,0,11,192,124,47,64,15,131,255,255,75,192,124,47,64,4,15,255,255,203,192,124,47,64,0,63,255,255,139,192,124,63,64,1,255,0,63,11,192,124,63,0,11,248,0,191,11,192,124,63,0,63,225,0,253,11,234,252,63,0,47,79,195,252,11,255,252,63,0,8,15,251,240,11,255,252,63,0,0,2,255,208,11,192,0,63,0,0,0,255,128,11,192,0,63,0,0,3,254,0,6,128,0,127,0,0,31,248,0,0,0,0,190,0,1,255,224,0,0,0,0,253,0,47,255,64,0,0,3,255,252,0,63,248,0,0,0,1,255,248,0,47,128,0,0,0,0,255,224,0,8,0,0,0,0,0,0,0,0,
  // 0x5927  大
  39,89,32,34,16,36,2,253,0,0,0,15,224,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,85,85,85,111,229,85,85,85,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,0,0,0,63,252,0,0,0,0,0,0,127,253,0,0,0,0,0,0,191,254,0,0,0,0,0,0,255,191,0,0,0,0,0,1,254,127,64,0,0,0,0,2,252,63,192,0,0,0,0,3,252,31,224,0,0,0,0,11,244,15,240,0,0,0,0,31,240,11,252,0,0,0,0,63,208,3,253,0,0,0,0,191,192,0,255,64,0,0,2,255,0,0,191,208,0,0,11,253,0,0,63,244,0,0,47,248,0,0,15,253,0,0,255,224,0,0,3,255,128,7,255,128,0,0,0,255,240,127,254,0,0,0,0,63,254,255,244,0,0,0,0,15,254,63,128,0,0,0,0,1,252,8,0,0,0,0,0,0,32,
  // 0x5929  天
  41,89,33,33,41,36,2,252,85,85,85,85,85,85,85,85,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,47,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,252,0,21,85,85,127,249,85,85,84,0,0,0,0,63,252,0,0,0,0,0,0,0,63,253,0,0,0,0,0,0,0,127,255,0,0,0,0,0,0,0,255,191,0,0,0,0,0,0,1,254,63,192,0,0,0,0,0,3,252,47,224,0,0,0,0,0,15,248,15,244,0,0,0,0,0,63,240,7,252,0,0,0,0,0,255,208,2,255,64,0,0,0,7,255,64,0,255,208,0,0,0,47,253,0,0,63,253,0,0,2,255,244,0,0,15,255,208,0,127,255,128,0,0,2,255,254,64,255,253,0,0,0,0,127,255,0,127,208,0,0,0,0,7,253,0,57,0,0,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,
  // 0x5931  失
  49,89,33,35,59,36,2,252,0,4,0,15,224,0,0,0,0,0,15,208,15,224,0,0,0,0,0,47,192,15,224,0,0,0,0,0,63,192,15,224,0,0,0,0,0,63,128,15,224,0,0,0,0,0,191,0,15,224,0,0,0,0,0,255,255,255,255,255,255,192,0,1,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,11,249,85,95,229,85,85,64,0,15,240,0,15,224,0,0,0,0,47,208,0,15,224,0,0,0,0,127,192,0,15,224,0,0,0,0,127,64,0,15,208,0,0,0,0,10,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,85,85,85,111,229,85,85,85,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,0,0,127,252,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,1,254,127,64,0,0,0,0,0,3,252,63,192,0,0,0,0,0,11,248,31,240,0,0,0,0,0,47,240,15,252,0,0,0,0,0,191,208,3,254,0,0,0,0,3,255,128,0,255,208,0,0,0,47,254,0,0,63,248,0,0,2,255,244,0,0,31,255,144,0,111,255,192,0,0,2,255,254,64,255,253,0,0,0,0,127,255,64,127,208,0,0,0,0,7,254,0,41,0,0,0,0,0,0,44,0,0,0,0,0,0,0,0,0,0,
  // 0x59cb  始
  203,89,34,34,50,36,1,253,0,30,128,0,0,57,0,0,0,0,31,192,0,0,127,64,0,0,0,47,128,0,0,191,0,0,0,0,63,64,0,0,254,0,0,0,0,63,0,0,0,253,0,0,0,0,63,0,0,2,252,0,0,0,0,127,0,0,3,248,1,128,0,0,190,0,0,3,244,15,208,0,127,255,255,240,7,240,11,240,0,127,255,255,240,11,224,3,248,0,127,255,255,240,15,192,1,253,0,1,248,3,240,31,192,0,191,0,2,244,7,241,127,235,255,255,128,3,240,7,235,255,255,255,255,192,3,240,11,235,255,255,255,255,224,7,240,15,215,250,165,64,11,240,11,224,15,192,0,0,0,3,128,15,208,31,192,0,0,0,0,0,15,192,47,128,0,0,0,0,0,31,192,63,64,127,255,255,255,0,47,244,63,0,127,255,255,255,0,63,255,191,0,127,255,255,255,0,63,255,254,0,127,0,0,127,0,6,47,252,0,127,0,0,127,0,0,7,255,0,127,0,0,127,0,0,11,255,192,127,0,0,127,0,0,15,255,240,127,0,0,127,0,0,63,203,252,127,0,0,127,0,0,255,66,244,127,0,0,127,0,3,254,0,160,127,255,255,255,0,31,252,0,0,127,255,255,255,0,47,224,0,0,127,255,255,255,0,15,128,0,0,127,0,0,127,0,5,0,0,0,126,0,0,42,0,
  // 0x5a92  媒
  146,90,34,34,50,36,1,253,0,62,0,0,252,0,7,240,0,0,63,0,0,252,0,7,240,0,0,127,0,0,252,0,7,240,0,0,126,0,0,252,0,7,240,0,0,190,0,127,255,255,255,255,208,0,253,0,127,255,255,255,255,208,0,252,0,127,255,255,255,255,192,0,252,0,0,252,0,7,240,0,191,255,255,192,252,0,7,240,0,191,255,255,192,254,85,91,240,0,191,255,255,192,255,255,255,240,0,3,244,31,128,255,255,255,240,0,3,240,31,128,252,0,7,240,0,7,240,47,64,252,0,7,240,0,7,224,63,64,252,0,7,240,0,11,208,63,0,255,255,255,240,0,15,192,63,0,255,255,255,240,0,15,192,127,0,170,191,234,160,0,31,192,190,0,0,47,128,0,0,31,128,253,0,0,47,128,0,0,47,224,253,0,0,47,128,0,0,63,253,252,127,255,255,255,255,208,63,255,248,127,255,255,255,255,208,10,127,244,127,255,255,255,255,208,0,31,244,0,3,255,248,0,0,0,15,253,0,15,255,254,0,0,0,47,255,0,63,255,191,128,0,0,63,255,192,255,47,143,224,0,0,255,31,135,252,47,135,252,0,3,253,7,47,244,47,130,255,64,15,248,2,255,208,47,128,191,224,63,224,0,255,0,47,128,31,192,31,64,0,56,0,47,128,7,0,9,0,0,0,0,47,128,0,0,
  // 0x5b50  子
  80,91,33,33,41,36,2,252,0,85,85,85,85,85,84,0,0,2,255,255,255,255,255,255,64,0,2,255,255,255,255,255,255,192,0,2,255,255,255,255,255,255,64,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,2,255,128,0,0,0,0,0,0,31,253,0,0,0,0,0,0,6,255,240,0,0,0,0,0,0,11,255,64,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,85,85,85,95,245,85,85,85,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,1,85,95,224,0,0,0,0,0,1,255,255,224,0,0,0,0,0,0,255,255,192,0,0,0,0,0,0,191,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5b58  存
  88,91,34,34,50,36,1,253,0,0,0,185,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,3,253,0,0,0,0,0,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,0,0,47,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,2,253,11,255,255,255,240,0,0,7,252,11,255,255,255,252,0,0,15,240,11,255,255,255,240,0,0,47,224,0,0,0,63,192,0,0,191,192,0,0,1,255,0,0,2,255,192,0,0,7,252,0,0,11,255,192,0,0,63,224,0,0,63,255,192,0,0,63,128,0,0,191,255,192,0,0,63,64,0,0,63,95,194,255,255,255,255,255,208,44,31,194,255,255,255,255,255,208,0,31,194,255,255,255,255,255,208,0,31,192,0,0,63,64,0,0,0,31,192,0,0,63,64,0,0,0,31,192,0,0,63,64,0,0,0,31,192,0,0,63,64,0,0,0,31,192,0,0,63,64,0,0,0,31,192,0,0,63,64,0,0,0,31,192,0,0,127,64,0,0,0,31,192,1,255,255,0,0,0,0,31,192,0,255,255,0,0,0,0,31,192,0,255,248,0,0,0,
  // 0x5b89  安
  137,91,32,35,24,36,2,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,64,0,0,0,0,1,252,63,64,0,16,0,0,1,252,63,64,0,191,0,0,1,252,63,64,0,254,0,0,1,252,63,64,2,252,0,0,1,252,0,0,3,248,0,0,0,0,0,0,11,240,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,64,0,31,224,0,0,0,254,0,0,47,192,0,0,3,252,0,0,63,192,0,0,7,248,0,0,127,64,0,0,15,240,0,0,255,0,0,0,31,244,0,2,253,0,0,0,63,255,144,7,252,0,0,0,127,255,254,95,240,0,0,0,191,47,255,255,208,0,0,0,5,1,191,255,208,0,0,0,0,0,31,255,253,0,0,0,0,1,255,255,255,208,0,0,0,127,255,130,255,253,0,5,191,255,248,0,47,255,208,47,255,255,128,0,2,255,240,15,255,228,0,0,0,47,192,7,164,0,0,0,0,7,0,0,0,0,0,0,0,0,0,
  // 0x5b8c  完
  140,91,32,34,16,36,2,253,0,0,0,11,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,64,0,0,0,0,1,252,63,64,0,0,0,0,1,252,63,64,0,0,0,0,1,252,63,64,0,0,0,0,1,252,63,75,255,255,255,255,209,252,0,11,255,255,255,255,208,0,0,11,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,63,128,15,224,0,0,0,0,63,64,11,224,0,0,0,0,127,0,11,224,0,0,0,0,191,0,11,224,0,0,0,0,255,0,11,224,0,0,0,1,253,0,11,224,0,16,0,3,252,0,11,224,0,62,0,15,248,0,11,224,0,63,0,127,240,0,11,224,0,63,6,255,192,0,11,240,0,127,191,255,0,0,11,255,255,254,255,248,0,0,3,255,255,253,127,128,0,0,1,255,255,244,36,0,0,0,0,0,0,0,
  // 0x5b9a  定
  154,91,33,35,59,36,1,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,208,0,0,0,0,0,127,0,15,192,0,0,0,0,0,127,0,15,192,0,0,0,0,0,127,0,15,192,0,0,0,0,0,127,0,15,195,255,255,255,255,252,127,0,5,67,255,255,255,255,252,21,0,0,3,255,255,255,255,252,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,7,224,3,248,0,0,0,0,0,7,240,3,248,0,0,0,0,0,11,240,3,248,0,0,0,0,0,15,224,3,255,255,255,192,0,0,15,208,3,255,255,255,192,0,0,31,224,3,255,255,255,192,0,0,47,240,3,248,0,0,0,0,0,63,244,3,248,0,0,0,0,0,127,252,3,248,0,0,0,0,0,255,255,3,248,0,0,0,0,1,253,63,211,248,0,0,0,0,3,252,31,251,248,0,0,0,0,11,244,7,255,253,0,0,0,0,47,240,1,255,255,255,255,255,192,127,192,0,47,255,255,255,255,128,47,64,0,1,191,255,255,255,64,9,0,0,0,0,5,85,85,0,0,0,0,0,0,0,0,0,0,
  // 0x5ba2  客
  162,91,34,34,50,36,1,253,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,192,0,80,0,0,0,127,0,15,192,0,255,0,0,0,127,0,15,192,3,253,0,0,0,127,0,15,192,15,254,170,170,128,127,0,0,0,63,255,255,255,244,0,0,0,0,255,255,255,255,240,0,0,0,7,255,64,0,47,208,0,0,0,127,255,208,0,191,128,0,0,3,255,223,248,2,255,0,0,0,3,254,3,255,31,248,0,0,0,0,244,0,191,255,224,0,0,0,0,0,0,47,255,128,0,0,0,0,0,0,191,255,244,0,0,0,0,0,27,255,255,255,208,0,0,0,2,255,254,11,255,255,164,0,1,191,255,224,0,191,255,255,208,127,255,253,0,0,6,255,255,128,63,255,255,255,255,255,255,255,0,31,147,255,255,255,255,252,5,0,0,3,255,255,255,255,252,0,0,0,3,244,0,0,1,252,0,0,0,3,244,0,0,1,252,0,0,0,3,244,0,0,1,252,0,0,0,3,244,0,0,1,252,0,0,0,3,255,255,255,255,252,0,0,0,3,255,255,255,255,252,0,0,0,3,255,255,255,255,252,0,0,0,3,244,0,0,1,252,0,0,
  // 0x5bb9  容
  185,91,33,35,59,36,2,252,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,63,255,255,255,255,255,255,252,0,63,255,255,255,255,255,255,252,0,63,255,255,255,255,255,255,252,0,63,64,0,0,0,0,1,252,0,63,0,20,0,0,80,1,252,0,63,0,63,128,1,248,1,252,0,63,0,255,0,3,255,65,252,0,0,7,253,0,0,191,224,0,0,0,31,244,5,80,31,252,0,0,0,191,208,31,244,3,255,64,0,7,255,64,63,252,0,191,208,0,15,253,0,255,255,0,47,240,0,7,240,3,254,191,192,11,192,0,2,128,15,252,63,240,2,0,0,0,0,63,240,15,253,0,0,0,0,0,255,192,3,255,64,0,0,0,7,255,0,0,191,240,0,0,0,47,252,0,0,47,253,0,0,1,255,240,0,0,7,255,208,0,11,255,255,255,255,255,255,253,0,191,255,255,255,255,255,255,255,64,191,239,255,255,255,255,242,255,0,62,15,208,0,0,7,240,44,0,16,15,208,0,0,7,240,0,0,0,15,208,0,0,7,240,0,0,0,15,208,0,0,7,240,0,0,0,15,208,0,0,7,240,0,0,0,15,255,255,255,255,240,0,0,0,15,255,255,255,255,240,0,0,0,15,255,255,255,255,240,0,0,0,15,208,0,0,7,240,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5c0d  對
  13,92,34,35,59,36,1,252,0,10,66,144,0,0,2,160,0,9,15,131,224,164,0,7,240,0,63,15,131,224,252,0,7,240,0,47,79,131,226,248,0,7,240,0,15,207,131,227,240,0,7,240,0,11,223,131,231,224,0,7,240,0,7,223,131,239,192,0,7,240,0,2,15,131,226,64,0,7,240,0,127,255,255,255,252,0,7,240,0,127,255,255,255,252,0,7,240,0,127,255,255,255,255,255,255,255,224,0,244,0,62,7,255,255,255,224,0,252,0,63,7,255,255,255,224,0,253,0,190,0,0,7,240,0,0,126,0,252,0,0,7,240,0,0,61,0,248,0,0,7,240,0,15,255,255,255,224,252,7,240,0,15,255,255,255,224,253,7,240,0,15,255,255,255,224,190,7,240,0,0,0,189,0,0,63,7,240,0,0,0,189,0,0,47,135,240,0,0,0,189,0,0,31,199,240,0,7,255,255,255,192,15,199,240,0,7,255,255,255,192,15,215,240,0,2,170,255,170,128,5,7,240,0,0,0,189,0,0,0,7,240,0,0,0,189,0,0,0,7,240,0,0,0,189,5,164,0,7,240,0,0,5,255,255,248,0,7,240,0,47,255,255,255,248,0,7,240,0,63,255,255,254,144,0,11,240,0,63,254,148,0,0,31,255,224,0,20,0,0,0,0,15,255,208,0,0,0,0,0,0,11,254,64,0,0,0,0,0,0,0,0,0,0,
  // 0x5c0f  小
  15,92,34,35,59,36,1,252,0,0,0,1,84,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,14,64,2,252,0,46,0,0,0,31,224,2,252,0,255,0,0,0,47,208,2,252,0,127,128,0,0,63,192,2,252,0,63,192,0,0,63,192,2,252,0,31,224,0,0,127,128,2,252,0,15,240,0,0,191,0,2,252,0,7,248,0,0,255,0,2,252,0,3,252,0,1,254,0,2,252,0,2,254,0,2,253,0,2,252,0,0,255,0,3,252,0,2,252,0,0,255,64,11,244,0,2,252,0,0,127,128,15,240,0,2,252,0,0,63,192,47,224,0,2,252,0,0,47,208,127,192,0,2,252,0,0,31,224,127,64,0,2,252,0,0,15,240,6,0,0,2,252,0,0,15,208,0,0,0,2,252,0,0,4,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,21,87,252,0,0,0,0,0,0,63,255,248,0,0,0,0,0,0,47,255,240,0,0,0,0,0,0,31,254,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5c31  就
  49,92,34,35,59,36,1,252,0,0,252,0,0,7,224,0,0,0,0,252,0,0,7,224,80,0,0,0,252,0,0,7,227,240,0,0,0,252,0,0,7,226,252,0,0,0,252,0,0,7,224,254,0,63,255,255,255,240,7,224,127,64,63,255,255,255,240,7,224,47,192,63,255,255,255,240,7,224,15,128,0,0,0,0,0,7,224,4,0,0,0,0,0,0,11,240,0,0,3,255,255,255,79,255,255,255,208,7,255,255,255,79,255,255,255,208,7,255,255,255,79,255,255,255,208,7,240,0,47,64,11,224,0,0,7,240,0,47,64,15,228,0,0,7,240,0,47,64,15,254,0,0,7,240,0,47,64,15,254,0,0,7,255,255,255,64,15,254,0,0,7,255,255,255,64,31,254,0,0,7,255,255,255,64,47,254,0,0,0,0,253,0,0,63,254,0,0,0,0,253,4,0,63,190,0,0,3,240,253,63,0,127,126,0,0,7,240,253,63,0,191,126,0,0,11,224,253,47,128,254,126,0,0,15,208,253,15,194,252,126,1,0,15,192,253,15,211,248,126,2,208,47,128,253,7,235,244,126,2,240,63,64,253,2,95,240,126,2,240,191,0,253,0,63,192,126,3,224,44,0,252,0,255,128,127,71,224,0,127,252,3,255,0,63,255,208,0,63,252,2,252,0,63,255,192,0,63,224,0,112,0,15,255,64,0,0,0,0,0,0,0,0,0,
  // 0x5de5  工
  229,93,32,28,224,36,2,255,15,255,255,255,255,255,255,244,15,255,255,255,255,255,255,244,15,255,255,255,255,255,255,244,5,85,85,95,245,85,85,80,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,85,85,85,85,
  // 0x5dee  差
  238,93,33,34,50,36,1,253,0,0,20,0,0,3,144,0,0,0,1,252,0,0,7,248,0,0,0,0,255,0,0,15,240,0,0,0,0,127,64,0,31,208,0,0,0,0,63,192,0,63,192,0,0,7,255,255,255,255,255,255,253,0,7,255,255,255,255,255,255,253,0,7,255,255,255,255,255,255,253,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,127,255,255,255,255,255,224,0,0,127,255,255,255,255,255,224,0,0,127,255,255,255,255,255,224,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,253,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,3,254,255,255,255,255,224,0,0,3,250,255,255,255,255,240,0,0,11,242,255,255,255,255,240,0,0,15,240,0,15,224,0,0,0,0,47,208,0,15,224,0,0,0,0,63,192,0,15,224,0,0,0,0,255,64,0,15,224,0,0,0,2,254,0,0,15,224,0,0,0,7,252,0,0,15,224,0,0,0,47,244,255,255,255,255,255,255,0,127,224,255,255,255,255,255,255,0,31,128,255,255,255,255,255,255,0,6,0,0,0,0,0,0,0,0,
  // 0x5df2  已
  242,93,31,31,248,36,3,254,191,255,255,255,255,255,248,0,191,255,255,255,255,255,248,0,191,255,255,255,255,255,248,0,21,85,85,85,85,87,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,229,85,85,85,87,248,0,15,255,255,255,255,255,248,0,15,255,255,255,255,255,248,0,15,255,255,255,255,255,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,2,248,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,208,15,224,0,0,0,0,1,252,15,224,0,0,0,0,1,252,15,224,0,0,0,0,2,252,15,224,0,0,0,0,3,252,15,240,0,0,0,0,7,248,11,254,85,85,85,85,111,240,3,255,255,255,255,255,255,224,1,255,255,255,255,255,255,192,0,43,255,255,255,255,249,0,
  // 0x5e73  平
  115,94,32,32,0,36,2,253,5,85,85,85,85,85,85,80,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,0,0,0,15,224,0,0,0,0,4,0,15,224,0,80,0,0,126,0,15,224,0,255,0,0,127,0,15,224,0,254,0,0,63,128,15,224,2,252,0,0,47,192,15,224,3,248,0,0,15,208,15,224,7,244,0,0,11,240,15,224,15,224,0,0,7,240,15,224,31,192,0,0,3,224,15,224,47,128,0,0,1,0,15,224,1,0,0,0,0,0,15,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,95,245,85,85,85,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,
  // 0x5e8a  床
  138,94,34,34,50,36,1,253,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,248,0,0,0,0,0,0,0,2,248,0,0,11,240,0,0,0,2,248,0,0,11,240,0,0,0,2,248,0,0,11,240,0,0,0,2,248,0,0,11,240,0,0,0,2,248,0,0,11,240,0,0,0,2,248,191,255,255,255,255,255,192,2,248,191,255,255,255,255,255,192,2,248,191,255,255,255,255,255,192,2,248,0,0,127,253,0,0,0,3,248,0,0,191,255,0,0,0,3,244,0,1,255,255,128,0,0,3,244,0,3,255,255,208,0,0,3,244,0,11,251,251,240,0,0,3,240,0,47,219,243,252,0,0,7,240,0,127,203,241,255,0,0,7,240,1,255,11,240,191,192,0,11,224,7,253,11,240,47,240,0,15,208,31,244,11,240,15,253,0,15,208,191,224,11,240,3,255,128,31,195,255,128,11,240,0,255,224,63,194,253,0,11,240,0,47,128,63,64,180,0,11,240,0,7,0,191,0,0,0,11,240,0,0,0,62,0,0,0,11,240,0,0,0,8,0,0,0,11,224,0,0,0,
  // 0x5ea6  度
  166,94,33,35,59,36,1,252,0,0,0,0,190,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,248,0,0,0,0,0,0,0,2,248,0,63,0,0,252,0,0,2,248,0,63,0,0,252,0,0,2,249,170,255,234,171,255,170,64,2,249,255,255,255,255,255,255,128,2,249,255,255,255,255,255,255,128,2,248,0,63,0,0,252,0,0,2,248,0,63,0,0,252,0,0,2,248,0,63,0,0,252,0,0,2,244,0,63,170,170,252,0,0,2,244,0,63,255,255,252,0,0,3,244,0,63,255,255,252,0,0,3,244,0,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,3,240,255,255,255,255,255,224,0,3,240,255,255,255,255,255,240,0,3,240,170,191,170,170,191,224,0,7,240,0,255,0,0,127,192,0,11,224,0,63,192,1,255,0,0,15,208,0,31,244,11,252,0,0,15,192,0,7,255,127,240,0,0,31,192,0,0,255,255,128,0,0,63,128,0,6,255,255,144,0,0,63,64,22,255,255,255,255,148,0,191,3,255,255,248,31,255,255,192,126,2,255,254,0,0,191,255,128,8,1,249,0,0,0,1,111,0,0,0,0,0,0,0,0,0,0,
  // 0x5ee2  廢
  226,94,34,35,59,36,1,252,0,0,0,0,190,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,192,3,240,0,0,0,84,0,0,0,3,240,191,255,244,189,15,128,0,3,240,191,255,244,63,127,64,0,3,240,21,91,240,31,252,0,0,3,240,48,15,208,15,224,46,0,3,240,254,63,128,7,244,255,0,3,240,127,255,0,1,255,248,0,3,240,15,252,0,0,127,208,0,3,240,31,244,0,85,127,248,0,3,241,255,255,194,255,255,255,208,3,255,255,255,194,255,254,191,192,3,247,224,7,194,240,62,11,64,3,241,0,7,194,240,62,13,0,7,240,21,91,195,224,62,30,0,7,224,127,255,223,208,63,254,0,7,224,191,255,239,192,31,252,0,7,224,248,0,11,0,0,0,0,11,208,244,0,5,0,0,64,0,15,209,255,255,207,255,255,240,0,15,195,255,255,207,255,255,240,0,15,194,229,95,193,240,11,208,0,31,128,0,15,193,248,31,192,0,47,64,0,15,128,190,127,0,0,63,64,0,31,64,47,252,0,0,127,0,0,47,64,47,254,0,0,190,0,21,127,7,255,255,249,64,125,0,63,254,63,248,31,255,64,12,0,63,248,30,64,0,191,0,0,0,0,0,0,0,0,0,0,
  // 0x5efa  建
  250,94,34,35,59,36,1,252,0,0,0,0,0,168,0,0,0,0,0,0,0,0,252,0,0,0,127,255,224,0,0,252,0,0,0,127,255,240,63,255,255,255,252,0,127,255,208,63,255,255,255,252,0,0,31,192,42,170,254,171,252,0,0,63,128,0,0,252,1,252,0,0,63,6,170,170,254,171,254,144,0,191,11,255,255,255,255,255,208,0,253,11,255,255,255,255,255,208,1,252,0,0,0,252,1,252,0,3,248,0,0,0,252,1,252,0,7,240,0,42,170,254,171,252,0,15,255,253,127,255,255,255,252,0,31,255,252,127,255,255,255,252,0,63,255,252,0,0,252,0,0,0,47,0,252,0,0,252,0,0,0,0,1,252,106,170,254,170,168,0,1,2,248,191,255,255,255,252,0,31,66,244,191,255,255,255,252,0,15,195,240,0,0,252,0,0,0,11,215,240,0,0,252,0,0,0,7,251,226,170,170,254,170,170,64,3,255,211,255,255,255,255,255,128,1,255,195,255,255,255,255,255,128,0,191,128,0,0,252,0,0,0,0,127,208,0,0,252,0,0,0,0,255,248,0,0,252,0,0,0,2,255,255,144,0,168,0,0,0,7,252,255,255,149,0,0,0,0,31,240,47,255,255,255,255,255,208,127,208,1,255,255,255,255,255,192,47,64,0,5,191,255,255,255,128,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5f15  引
  21,95,29,35,24,36,2,252,0,0,0,0,0,0,5,0,0,0,0,0,0,0,63,128,31,255,255,255,0,0,63,128,31,255,255,255,0,0,63,128,31,255,255,255,0,0,63,128,0,0,0,63,0,0,63,128,0,0,0,63,0,0,63,128,0,0,0,63,0,0,63,128,0,0,0,63,0,0,63,128,0,0,0,63,0,0,63,128,7,255,255,255,0,0,63,128,11,255,255,255,0,0,63,128,11,255,255,255,0,0,63,128,15,208,0,0,0,0,63,128,15,208,0,0,0,0,63,128,15,192,0,0,0,0,63,128,31,192,0,0,0,0,63,128,47,192,0,0,0,0,63,128,47,255,255,255,64,0,63,128,63,255,255,255,64,0,63,128,63,255,255,255,0,0,63,128,127,0,0,127,0,0,63,128,26,0,0,127,0,0,63,128,0,0,0,127,0,0,63,128,0,0,0,191,0,0,63,128,0,0,0,190,0,0,63,128,0,0,0,254,0,0,63,128,0,0,0,253,0,0,63,128,0,0,1,253,0,0,63,128,0,0,2,252,0,0,63,128,0,149,91,252,0,0,63,128,0,191,255,244,0,0,63,128,0,127,255,240,0,0,63,128,0,63,254,64,0,0,63,128,0,0,0,0,0,0,0,0,
  // 0x5f85  待
  133,95,34,34,50,36,1,253,0,1,128,0,0,106,0,0,0,0,3,248,0,0,127,0,0,0,0,11,244,0,0,127,0,0,0,0,47,224,0,0,127,0,0,0,0,127,192,0,0,191,0,0,0,2,255,0,63,255,255,255,255,0,11,252,0,63,255,255,255,255,0,63,240,0,63,255,255,255,255,0,63,192,0,0,0,127,0,0,0,30,0,252,0,0,127,0,0,0,4,2,252,0,0,127,0,0,0,0,7,244,0,0,191,0,0,0,0,15,243,255,255,255,255,255,224,0,63,195,255,255,255,255,255,224,0,255,131,255,255,255,255,255,224,3,255,128,0,0,0,47,192,0,31,255,128,0,0,0,47,192,0,191,255,128,0,0,0,47,192,0,127,95,131,255,255,255,255,255,208,61,31,131,255,255,255,255,255,208,16,31,131,255,255,255,255,255,208,0,31,128,0,0,0,47,192,0,0,31,128,2,192,0,47,192,0,0,31,128,15,224,0,47,192,0,0,31,128,11,244,0,47,192,0,0,31,128,3,252,0,47,192,0,0,31,128,1,254,0,47,192,0,0,31,128,0,191,0,47,192,0,0,31,128,0,63,64,47,192,0,0,31,128,0,44,0,47,192,0,0,31,128,0,0,0,47,128,0,0,31,128,0,0,127,255,128,0,0,31,128,0,0,63,255,64,0,0,31,128,0,0,63,248,0,0,
  // 0x5f8c  後
  140,95,34,35,59,36,1,252,0,2,128,0,3,64,0,0,0,0,11,244,0,15,240,0,0,0,0,31,224,0,47,208,0,0,0,0,127,192,0,127,128,45,0,0,1,255,0,96,254,0,127,192,0,7,252,1,255,248,1,255,0,0,31,240,2,255,240,3,252,0,0,191,192,0,127,224,15,240,0,0,63,0,248,31,252,63,192,0,0,24,3,252,3,255,255,2,128,0,0,7,240,0,255,252,15,208,0,0,31,224,0,63,240,11,244,0,0,63,192,0,63,128,2,252,0,0,255,64,0,255,170,170,255,0,3,255,79,255,255,255,255,255,128,15,255,79,255,255,255,255,255,192,63,255,79,255,255,228,0,15,224,255,255,64,0,47,192,0,7,192,127,63,64,0,127,64,0,1,0,60,63,64,1,255,255,255,224,0,0,63,64,7,255,255,255,240,0,0,63,64,47,250,170,175,224,0,0,63,64,255,244,0,63,192,0,0,63,75,255,252,0,191,64,0,0,63,79,244,191,2,254,0,0,0,63,67,192,63,219,248,0,0,0,63,64,0,15,255,224,0,0,0,63,64,0,3,255,192,0,0,0,63,64,0,47,255,244,0,0,0,63,64,2,255,255,255,64,0,0,63,65,191,255,66,255,254,64,0,63,79,255,244,0,63,255,224,0,63,75,254,64,0,6,255,192,0,63,67,144,0,0,0,27,64,0,0,0,0,0,0,0,0,0,
  // 0x5f91  徑
  145,95,34,34,50,36,1,253,0,2,128,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,31,224,255,255,255,255,255,192,0,63,192,255,255,255,255,255,192,0,255,0,255,255,255,255,255,192,3,252,0,0,0,0,0,0,0,31,240,0,3,144,25,0,164,0,127,192,0,11,224,63,64,252,0,63,0,244,15,192,127,2,248,0,24,3,252,47,128,252,7,240,0,0,7,240,63,2,248,15,208,0,0,15,224,253,7,240,47,128,0,0,63,193,252,15,208,127,0,0,0,255,64,252,11,224,63,64,0,2,255,64,127,3,244,15,192,0,11,255,64,63,64,252,7,240,0,63,255,64,15,192,191,2,252,0,255,255,64,11,224,63,64,254,0,191,63,64,3,244,31,192,127,0,60,63,64,2,144,10,64,41,0,16,63,64,0,0,0,0,0,0,0,63,64,191,255,255,255,254,0,0,63,64,255,255,255,255,255,0,0,63,64,255,255,255,255,255,0,0,63,64,0,0,190,0,0,0,0,63,64,0,0,190,0,0,0,0,63,64,0,0,190,0,0,0,0,63,64,0,0,190,0,0,0,0,63,64,0,0,190,0,0,0,0,63,64,0,0,190,0,0,0,0,63,79,255,255,255,255,255,224,0,63,79,255,255,255,255,255,224,0,63,79,255,255,255,255,255,224,0,47,64,0,0,0,0,0,0,
  // 0x5f9e  從
  158,95,34,35,59,36,1,252,0,3,128,0,185,0,15,128,0,0,11,244,0,253,0,31,192,0,0,31,224,0,252,0,31,128,0,0,127,192,1,252,0,47,128,0,1,255,0,2,248,0,63,64,0,7,252,0,3,244,0,127,0,0,47,240,0,7,248,0,191,0,0,191,192,0,15,255,0,255,192,0,62,1,248,31,255,194,255,240,0,24,3,248,63,143,227,251,252,0,0,11,240,191,3,207,241,255,0,0,31,209,254,0,111,208,127,192,0,63,199,252,0,191,128,31,224,0,255,71,240,0,127,0,11,192,3,255,65,208,0,62,0,2,0,15,255,64,0,0,63,0,0,0,63,255,64,0,0,63,0,0,0,255,191,64,15,192,63,0,0,0,127,63,64,15,192,63,0,0,0,56,63,64,31,192,63,0,0,0,0,63,64,31,192,63,255,254,0,0,63,64,31,128,63,255,254,0,0,63,64,47,128,63,255,254,0,0,63,64,63,192,63,0,0,0,0,63,64,63,208,63,0,0,0,0,63,64,127,224,63,0,0,0,0,63,64,191,240,63,0,0,0,0,63,64,255,252,63,0,0,0,0,63,66,252,254,63,0,0,0,0,63,67,248,127,255,0,0,0,0,63,79,240,47,255,64,0,0,0,63,111,224,11,255,255,255,208,0,63,111,192,1,255,255,255,192,0,63,71,0,0,6,255,255,128,0,21,0,0,0,0,0,0,0,
  // 0x5fa9  復
  169,95,34,35,59,36,1,252,0,3,144,2,228,0,0,0,0,0,11,240,3,248,0,0,0,0,0,47,208,7,244,0,0,0,0,0,127,128,15,250,170,170,170,128,1,255,0,31,255,255,255,255,192,11,252,0,63,255,255,255,255,192,47,240,0,191,64,0,0,0,0,191,192,0,255,0,0,0,0,0,63,0,247,254,0,0,0,0,0,28,3,255,255,255,255,255,252,0,0,7,251,251,255,255,255,252,0,0,15,224,139,208,0,1,252,0,0,63,192,11,208,0,1,252,0,0,255,64,11,255,255,255,252,0,3,255,64,11,255,255,255,252,0,15,255,64,11,208,0,1,252,0,63,255,64,11,208,0,1,252,0,255,191,64,11,255,255,255,252,0,126,63,64,11,255,255,255,252,0,56,63,64,0,31,208,0,0,0,0,63,64,0,63,128,0,0,0,0,63,64,0,255,85,85,64,0,0,63,64,2,255,255,255,248,0,0,63,64,15,255,255,255,244,0,0,63,64,63,252,0,15,224,0,0,63,66,255,255,0,63,192,0,0,63,71,252,47,209,255,0,0,0,63,64,224,15,251,252,0,0,0,63,64,0,3,255,240,0,0,0,63,64,0,47,255,249,0,0,0,63,64,91,255,255,255,249,0,0,63,75,255,255,129,191,255,224,0,63,67,255,228,0,11,255,192,0,63,66,228,0,0,0,27,0,0,0,0,0,0,0,0,0,0,
  // 0x5fae  微
  174,95,34,34,50,36,1,253,0,29,0,15,64,0,184,0,0,0,63,192,15,64,0,252,0,0,0,191,0,15,64,0,252,0,0,1,254,31,15,67,193,252,0,0,7,248,31,15,67,193,248,0,0,15,240,31,15,67,194,244,0,0,63,192,31,15,67,195,244,0,0,191,0,31,15,67,195,255,255,208,61,15,239,15,67,199,255,255,224,16,31,239,15,67,203,255,255,224,0,63,159,255,255,223,208,63,0,0,127,31,255,255,239,208,63,0,0,254,31,255,255,255,224,62,0,3,253,0,0,0,127,224,126,0,11,253,0,0,0,255,240,125,0,31,253,0,0,0,253,240,188,0,63,253,63,255,255,244,240,252,0,255,253,63,255,255,224,244,252,0,189,253,63,255,255,208,249,248,0,56,253,2,240,125,0,190,244,0,16,253,2,240,125,0,127,240,0,0,253,3,240,125,0,63,240,0,0,253,3,240,125,0,63,224,0,0,253,3,240,125,0,47,192,0,0,253,3,224,125,0,31,192,0,0,253,7,224,126,184,63,208,0,0,253,11,208,191,248,191,240,0,0,253,15,194,255,245,255,244,0,0,253,31,129,254,3,249,252,0,0,253,63,64,144,15,240,255,0,0,253,255,0,0,127,192,63,208,0,253,60,0,0,255,0,31,240,0,253,20,0,0,188,0,7,192,0,189,0,0,0,32,0,1,64,
  // 0x5fc3  心
  195,95,34,34,50,36,1,253,0,0,0,144,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,11,255,224,0,0,0,0,0,0,1,255,254,0,0,0,0,0,0,0,11,255,224,0,0,0,0,0,0,0,191,253,0,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,31,0,0,1,228,15,208,0,0,127,128,0,1,252,15,208,0,0,47,208,0,2,252,15,208,0,0,15,240,0,2,248,15,208,0,0,7,248,0,3,248,15,208,0,0,3,252,0,3,244,15,208,0,0,1,254,0,7,240,15,208,0,0,0,255,0,11,240,15,208,0,0,0,127,128,15,224,15,208,0,0,0,63,192,31,208,15,208,0,0,0,47,208,47,192,15,208,0,0,208,15,224,127,128,15,208,0,0,252,15,240,255,0,15,208,0,0,252,11,208,126,0,15,208,0,1,252,1,0,4,0,15,208,0,1,252,0,0,0,0,15,208,0,2,248,0,0,0,0,15,240,0,7,244,0,0,0,0,15,255,255,255,240,0,0,0,0,7,255,255,255,224,0,0,0,0,1,191,255,255,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6027  性
  39,96,33,35,59,36,1,252,0,63,64,0,0,47,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,3,244,63,64,0,0,0,63,64,3,240,63,64,0,0,0,63,64,7,240,63,64,0,0,0,63,64,11,240,63,64,0,0,0,63,88,11,224,63,64,0,0,10,63,252,15,224,63,128,0,0,31,63,190,31,255,255,255,255,0,47,63,127,47,255,255,255,255,0,47,63,95,127,255,255,255,255,0,63,63,79,255,64,63,64,0,0,62,63,79,255,0,63,64,0,0,61,63,64,254,0,63,64,0,0,125,63,66,252,0,63,64,0,0,188,63,64,120,0,63,64,0,0,188,63,64,0,0,63,64,0,0,0,63,64,0,0,63,128,0,0,0,63,64,15,255,255,255,253,0,0,63,64,15,255,255,255,253,0,0,63,64,15,255,255,255,253,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,128,0,0,0,63,67,255,255,255,255,255,192,0,63,67,255,255,255,255,255,192,0,63,67,255,255,255,255,255,192,0,63,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6062  恢
  98,96,34,35,59,36,1,252,0,63,0,31,64,0,0,0,0,0,63,0,31,64,0,0,0,0,0,63,0,31,64,0,0,0,0,0,63,0,47,64,0,0,0,0,0,63,3,255,255,255,255,255,208,0,63,3,255,255,255,255,255,208,0,63,103,255,255,255,255,255,208,10,63,248,31,64,0,0,0,0,31,63,188,31,64,3,240,0,0,31,63,61,31,64,3,240,0,0,31,63,46,31,64,3,240,0,0,46,63,31,47,64,3,240,0,0,46,63,15,47,73,3,240,11,128,61,63,14,47,79,131,240,15,192,60,63,0,47,79,67,240,31,128,188,63,0,47,79,3,240,47,0,248,63,0,47,95,3,240,63,0,16,63,0,47,47,3,240,125,0,0,63,0,63,62,3,240,188,0,0,63,0,63,61,3,244,248,0,0,63,0,63,124,7,244,96,0,0,63,0,63,4,11,248,0,0,0,63,0,126,0,15,252,0,0,0,63,0,190,0,31,189,0,0,0,63,0,253,0,63,63,0,0,0,63,0,252,0,127,47,64,0,0,63,1,252,0,253,15,192,0,0,63,2,248,2,252,15,224,0,0,63,3,240,11,240,7,248,0,0,63,11,240,47,224,2,254,0,0,63,15,209,255,128,0,255,192,0,63,47,195,254,0,0,63,224,0,63,15,66,248,0,0,15,192,0,63,2,0,208,0,0,2,64,0,0,0,0,0,0,0,0,0,
  // 0x606f  息
  111,96,33,34,50,36,2,253,0,0,0,15,240,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,31,192,0,0,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,63,170,170,170,170,253,0,0,0,63,64,0,0,0,253,0,0,0,63,64,0,0,0,253,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,63,149,85,85,85,253,0,0,0,63,64,0,0,0,253,0,0,0,63,64,0,0,0,253,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,63,149,85,85,85,253,0,0,0,63,64,0,0,0,253,0,0,0,63,64,0,0,0,253,0,0,0,63,170,170,170,170,253,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,0,0,9,0,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,224,0,8,0,0,3,224,127,11,248,0,190,0,0,3,240,127,2,254,0,191,128,0,11,240,127,0,255,0,63,224,0,15,208,127,0,56,0,15,244,0,47,192,127,0,0,30,3,252,0,127,128,127,0,0,31,128,255,0,255,0,127,0,0,63,128,191,64,253,0,63,255,255,255,64,63,64,36,0,47,255,255,255,0,24,0,0,0,11,255,255,248,0,0,0,
  // 0x61b6  憶
  182,97,34,34,50,36,1,253,0,63,0,0,0,63,0,0,0,0,63,0,0,0,63,0,0,0,0,63,0,21,85,191,149,85,0,0,63,0,127,255,255,255,255,0,0,63,0,127,255,255,255,255,0,0,63,0,0,252,0,15,192,0,0,63,96,0,189,0,31,128,0,10,63,248,0,126,0,47,64,0,31,63,188,0,63,0,63,0,0,31,63,62,255,255,255,255,255,208,31,63,47,255,255,255,255,255,208,46,63,31,170,170,170,170,170,144,46,63,15,0,0,0,0,0,0,61,63,9,15,255,255,255,253,0,60,63,0,15,255,255,255,253,0,124,63,0,15,192,0,0,189,0,248,63,0,15,192,0,0,189,0,16,63,0,15,255,255,255,253,0,0,63,0,15,255,255,255,253,0,0,63,0,15,192,0,0,189,0,0,63,0,15,192,0,0,189,0,0,63,0,15,255,255,255,253,0,0,63,0,15,255,255,255,253,0,0,63,0,0,1,248,0,0,0,0,63,0,0,1,255,0,0,0,0,63,0,36,42,127,193,224,0,0,63,0,126,63,11,211,244,0,0,63,0,189,63,2,65,253,0,0,63,0,252,63,0,4,191,0,0,63,1,252,63,0,11,191,128,0,63,3,244,47,64,15,207,192,0,63,15,240,47,255,255,139,224,0,63,7,192,31,255,255,3,64,0,63,0,0,2,170,168,0,0,
  // 0x61c9  應
  201,97,34,35,59,36,1,252,0,0,0,0,190,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,192,3,240,2,224,15,128,184,0,0,3,240,3,240,47,128,252,0,0,3,240,11,224,63,2,248,0,0,3,240,31,192,255,255,255,255,0,3,240,63,65,255,255,255,255,0,3,240,255,67,252,3,240,0,0,3,243,255,79,252,3,240,0,0,3,255,255,127,255,255,255,252,0,3,255,255,111,255,255,255,252,0,3,251,95,68,188,3,240,0,0,3,241,31,64,191,255,255,252,0,3,240,31,64,191,255,255,252,0,3,240,31,64,188,3,240,0,0,7,240,31,64,188,3,240,0,0,7,224,31,64,191,255,255,255,128,7,224,31,64,191,255,255,255,128,7,224,31,64,56,0,0,0,0,11,208,0,0,255,64,0,0,0,15,208,0,0,127,240,0,0,0,15,192,36,10,135,253,7,192,0,15,192,63,15,192,252,15,240,0,31,128,190,15,192,32,3,248,0,47,128,252,15,192,0,81,253,0,63,66,252,15,192,0,188,191,0,127,7,244,15,192,0,252,63,192,190,15,224,15,255,255,252,15,208,124,3,128,11,255,255,244,11,64,8,0,0,1,170,170,128,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6210  成
  16,98,34,35,59,36,1,252,0,0,0,0,15,224,96,0,0,0,0,0,0,15,225,254,0,0,0,0,0,0,15,225,255,192,0,0,0,0,0,15,224,47,244,0,0,0,0,0,15,224,7,252,0,0,0,0,0,15,224,0,240,0,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,253,85,85,91,245,85,85,64,2,252,0,0,7,240,0,0,0,2,252,0,0,7,240,0,0,0,2,252,0,0,3,240,1,228,0,2,252,0,0,3,244,3,252,0,2,255,255,255,3,244,3,244,0,2,255,255,255,3,248,11,240,0,2,255,255,255,2,248,15,224,0,2,252,0,127,2,252,31,192,0,2,252,0,127,1,252,63,192,0,2,252,0,127,0,253,127,64,0,2,252,0,127,0,254,255,0,0,2,252,0,127,0,255,253,0,0,3,248,0,190,0,191,248,0,0,3,248,0,190,0,127,240,0,0,3,244,0,190,0,63,208,5,0,7,244,0,253,0,191,192,11,128,11,241,255,253,1,255,208,11,208,11,240,255,252,11,255,240,11,208,15,224,191,224,63,255,248,15,192,47,208,0,2,255,211,254,31,192,63,192,0,31,255,1,255,255,128,127,64,0,15,248,0,127,255,0,47,0,0,3,208,0,15,253,0,9,0,0,1,0,0,0,80,0,0,0,0,0,0,0,0,0,0,
  // 0x6236  戶
  54,98,30,34,16,36,1,253,0,0,0,0,0,0,176,0,0,0,0,0,0,111,252,0,0,0,0,1,175,255,255,0,0,20,22,255,255,255,228,0,0,47,255,255,255,228,0,0,0,47,255,254,144,0,0,0,0,47,233,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,255,255,255,255,255,208,0,47,255,255,255,255,255,208,0,47,255,255,255,255,255,208,0,47,192,0,0,0,15,208,0,47,192,0,0,0,15,208,0,47,128,0,0,0,15,208,0,47,128,0,0,0,15,208,0,47,128,0,0,0,15,208,0,63,128,0,0,0,15,208,0,63,255,255,255,255,255,208,0,63,255,255,255,255,255,208,0,63,255,255,255,255,255,208,0,127,0,0,0,0,15,208,0,191,0,0,0,0,15,208,0,254,0,0,0,0,0,0,0,253,0,0,0,0,0,0,2,252,0,0,0,0,0,0,3,248,0,0,0,0,0,0,7,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,63,208,0,0,0,0,0,0,127,192,0,0,0,0,0,0,31,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,
  // 0x6240  所
  64,98,34,34,50,36,1,253,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,189,0,47,255,255,255,192,0,31,255,128,47,255,255,255,196,7,255,255,64,47,255,255,255,207,255,255,224,0,0,0,0,0,15,255,249,0,0,0,0,0,0,15,253,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,11,255,255,255,15,208,0,0,0,11,255,255,255,15,208,0,0,0,11,255,255,255,15,208,0,0,0,11,224,0,127,15,224,0,0,0,11,224,0,127,15,255,255,255,224,11,224,0,127,15,255,255,255,224,11,224,0,127,15,255,255,255,224,11,224,0,127,15,208,7,240,0,11,255,255,255,15,208,7,240,0,11,255,255,255,15,192,7,240,0,11,255,255,255,15,192,7,240,0,11,224,0,0,31,192,7,240,0,11,224,0,0,47,192,7,240,0,11,208,0,0,47,128,7,240,0,15,208,0,0,63,64,7,240,0,15,208,0,0,127,0,7,240,0,15,192,0,0,191,0,7,240,0,31,192,0,0,253,0,7,240,0,31,192,0,2,252,0,7,240,0,47,128,0,3,248,0,7,240,0,63,64,0,11,240,0,7,240,0,191,0,0,47,224,0,7,240,0,254,0,0,63,192,0,7,240,0,124,0,0,15,64,0,7,240,0,8,0,0,1,0,0,7,240,0,
  // 0x6247  扇
  71,98,32,32,0,36,1,253,31,255,255,255,255,255,255,255,31,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,240,0,255,255,255,255,255,255,240,0,255,170,170,170,170,171,240,0,253,0,0,0,0,3,240,0,253,0,0,0,0,3,240,0,255,170,170,170,170,171,240,0,255,255,255,255,255,255,240,0,255,255,255,255,255,255,240,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,253,255,255,241,255,255,252,0,253,255,255,241,255,255,252,0,252,170,171,240,170,170,252,1,252,24,3,240,44,1,252,1,252,127,3,240,191,1,252,2,252,47,131,240,47,193,252,2,248,15,211,240,15,209,252,3,244,7,131,240,3,65,252,7,240,0,3,240,0,21,252,11,240,1,243,240,2,253,252,15,224,111,247,240,111,253,252,31,215,255,211,243,255,209,252,47,195,253,3,242,253,1,252,127,67,144,3,241,128,1,252,255,0,1,171,240,0,171,248,45,0,0,255,224,0,191,244,4,0,0,255,128,0,63,208,
  // 0x624b  手
  75,98,32,35,24,36,2,252,0,0,0,0,0,0,104,0,0,0,0,0,22,191,254,0,0,5,90,191,255,255,255,64,11,255,255,255,255,255,228,0,7,255,255,255,254,80,0,0,3,255,169,95,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,15,240,0,0,0,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,240,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,95,245,85,85,85,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,1,64,31,224,0,0,0,0,3,255,255,224,0,0,0,0,2,255,255,192,0,0,0,0,0,255,249,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6253  打
  83,98,34,34,50,36,1,253,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,15,255,255,255,255,224,0,15,192,15,255,255,255,255,224,0,15,192,15,255,255,255,255,224,0,15,192,5,85,85,254,85,64,63,255,255,240,0,0,253,0,0,63,255,255,240,0,0,253,0,0,63,255,255,240,0,0,253,0,0,0,31,208,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,214,240,0,0,253,0,0,0,31,255,240,0,0,253,0,0,6,255,255,240,0,0,253,0,0,127,255,254,64,0,0,253,0,0,63,255,208,0,0,0,253,0,0,63,175,192,0,0,0,253,0,0,20,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,1,253,0,0,0,31,192,0,47,255,253,0,0,15,255,192,0,31,255,252,0,0,15,255,128,0,15,255,240,0,0,7,249,0,0,6,165,0,0,0,
  // 0x6279  批
  121,98,34,34,50,36,1,253,0,63,0,42,0,2,160,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,127,255,253,63,64,7,240,0,0,127,255,253,63,64,7,240,4,0,127,255,253,63,64,7,240,31,0,0,127,0,63,64,7,240,127,128,0,63,0,63,64,7,241,255,128,0,63,0,63,255,215,247,254,0,0,63,0,63,255,215,255,244,0,0,63,0,63,255,215,255,192,0,0,63,0,63,64,7,253,0,0,0,63,188,63,64,7,240,0,0,0,127,253,63,64,7,240,0,0,27,255,253,63,64,7,240,0,0,255,255,208,63,64,7,240,0,0,191,255,0,63,64,7,240,0,0,126,127,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,7,128,0,63,0,63,64,7,240,7,224,0,63,0,63,86,151,240,7,224,0,63,0,63,255,231,240,11,208,0,127,11,255,255,227,240,15,208,63,254,15,255,255,147,255,255,192,31,253,15,254,144,3,255,255,128,15,228,6,64,0,0,191,254,0,
  // 0x6296  抖
  150,98,34,35,59,36,1,252,0,47,128,0,0,0,47,128,0,0,47,128,0,0,0,47,128,0,0,47,128,0,16,0,47,128,0,0,47,128,0,126,0,47,128,0,0,47,128,0,255,208,47,128,0,0,47,128,0,47,248,47,128,0,0,47,128,0,7,254,47,128,0,63,255,255,192,0,253,47,128,0,63,255,255,192,0,36,47,128,0,63,255,255,192,0,0,47,128,0,0,47,128,0,0,0,47,128,0,0,47,128,1,64,0,47,128,0,0,47,128,3,244,0,47,128,0,0,47,128,11,254,0,47,128,0,0,47,128,2,255,208,47,128,0,0,47,128,64,127,244,47,128,0,0,47,223,192,11,240,47,128,0,0,47,255,192,1,192,47,128,0,27,255,255,192,0,0,47,128,0,191,255,249,0,0,0,47,128,0,127,255,192,0,0,0,47,239,208,63,175,128,0,0,6,191,255,208,16,47,128,0,107,255,255,255,224,0,47,128,63,255,255,255,249,64,0,47,128,63,255,255,191,128,0,0,47,128,47,250,64,47,128,0,0,47,128,21,0,0,47,128,0,0,47,128,0,0,0,47,128,0,0,47,128,0,0,0,47,128,0,0,47,128,0,0,0,47,128,0,0,47,128,0,0,0,47,128,0,47,255,128,0,0,0,47,128,0,15,255,0,0,0,0,47,128,0,15,248,0,0,0,0,47,128,0,0,0,0,0,0,0,0,0,0,
  // 0x62bd  抽
  189,98,33,35,59,36,1,252,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,127,255,255,0,0,47,64,0,0,127,255,255,47,255,255,255,255,192,127,255,255,47,255,255,255,255,192,0,47,128,47,255,255,255,255,192,0,47,64,47,128,63,128,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,159,111,64,47,64,47,192,0,63,255,111,64,47,64,47,192,27,255,255,175,255,255,255,255,192,255,255,248,47,255,255,255,255,192,191,255,128,47,255,255,255,255,192,126,127,64,47,128,47,128,47,192,16,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,255,255,255,255,192,0,47,64,47,255,255,255,255,192,0,63,64,47,255,255,255,255,192,47,255,64,47,128,0,0,47,192,31,255,0,47,64,0,0,47,192,15,248,0,47,64,0,0,26,128,0,0,0,0,0,0,0,0,0,
  // 0x62d4  拔
  212,98,34,35,59,36,1,252,0,47,64,0,31,192,16,0,0,0,47,64,0,31,192,125,0,0,0,47,64,0,31,192,255,192,0,0,47,64,0,31,192,47,244,0,0,47,64,0,31,192,7,254,0,0,47,64,0,31,192,0,254,0,0,47,64,0,31,192,0,44,0,127,255,255,0,31,192,0,0,0,127,255,255,127,255,255,255,255,192,127,255,255,127,255,255,255,255,192,106,191,234,127,255,255,255,255,192,0,47,64,0,47,128,0,0,0,0,47,64,0,47,128,0,0,0,0,47,64,0,63,192,0,64,0,0,47,64,0,63,208,2,248,0,0,47,64,0,63,224,3,244,0,0,47,135,64,63,240,3,240,0,0,47,255,64,127,240,7,240,0,6,255,255,128,191,248,11,224,0,191,255,253,0,254,252,15,208,0,191,255,128,0,252,189,31,192,0,127,191,64,1,252,127,47,192,0,32,47,64,2,248,63,127,64,0,0,47,64,3,244,31,255,0,0,0,47,64,7,240,15,254,0,0,0,47,64,15,224,7,252,0,0,0,47,64,31,208,7,252,0,0,0,47,64,63,192,15,255,64,0,0,47,64,191,64,63,255,208,0,0,47,65,254,0,255,95,244,0,0,63,67,252,7,254,7,255,64,47,255,79,244,47,248,1,255,224,31,255,11,208,47,208,0,47,192,15,248,2,128,7,0,0,3,64,0,0,0,0,0,0,0,0,0,
  // 0x6309  按
  9,99,34,35,59,36,1,252,0,47,64,0,0,63,0,0,0,0,47,64,0,0,63,64,0,0,0,47,64,0,0,63,64,0,0,0,47,64,0,0,63,64,0,0,0,47,64,0,0,63,64,0,0,0,47,64,63,255,255,255,255,192,0,47,64,63,255,255,255,255,192,127,255,255,127,255,255,255,255,192,127,255,255,127,0,0,0,15,192,127,255,255,127,1,252,0,15,192,0,47,128,63,2,252,0,15,192,0,47,64,63,3,248,0,15,192,0,47,64,0,3,240,0,0,0,0,47,64,0,7,240,0,0,0,0,47,64,0,15,224,0,0,0,0,47,64,127,255,255,255,255,224,0,47,70,191,255,255,255,255,224,0,47,255,255,255,255,255,255,224,1,191,255,128,63,64,7,240,0,191,255,254,0,127,0,15,240,0,191,255,128,0,254,0,15,224,0,127,191,64,0,252,0,31,208,0,36,47,64,2,252,0,47,192,0,0,47,64,3,255,64,63,64,0,0,47,64,7,255,248,255,0,0,0,47,64,11,255,255,253,0,0,0,47,64,0,65,255,252,0,0,0,47,64,0,0,63,255,64,0,0,47,64,0,1,255,255,240,0,0,47,64,0,31,255,47,253,0,0,63,64,6,255,248,7,255,128,47,255,65,255,255,128,0,191,208,31,255,0,255,244,0,0,31,128,15,248,0,121,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
  // 0x6389  掉
  137,99,34,35,59,36,1,252,0,63,0,0,0,190,0,0,0,0,63,0,0,0,190,0,0,0,0,63,0,0,0,190,0,0,0,0,63,0,0,0,191,255,255,192,0,63,0,0,0,191,255,255,192,0,63,0,0,0,191,255,255,192,0,63,0,0,0,190,0,0,0,127,255,255,0,0,190,0,0,0,127,255,255,0,0,190,0,0,0,127,255,255,63,255,255,255,253,0,0,127,0,63,255,255,255,253,0,0,63,0,63,170,170,170,253,0,0,63,0,63,0,0,0,253,0,0,63,0,63,0,0,0,253,0,0,63,0,63,255,255,255,253,0,0,63,1,63,255,255,255,253,0,0,63,190,63,85,85,85,253,0,0,127,255,63,0,0,0,253,0,47,255,255,63,0,0,0,253,0,127,255,208,63,170,170,170,253,0,63,255,0,63,255,255,255,253,0,57,127,0,63,255,255,255,253,0,0,63,0,0,0,190,0,0,0,0,63,0,0,0,190,0,0,0,0,63,0,0,0,190,0,0,0,0,63,3,255,255,255,255,255,208,0,63,3,255,255,255,255,255,208,0,63,3,255,255,255,255,255,208,0,63,0,0,0,190,0,0,0,0,63,0,0,0,190,0,0,0,0,127,0,0,0,190,0,0,0,63,255,0,0,0,190,0,0,0,63,254,0,0,0,190,0,0,0,47,228,0,0,0,190,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x63a2  探
  162,99,34,34,50,36,1,253,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,191,255,255,255,255,192,0,63,0,191,255,255,255,255,192,0,63,0,191,255,255,255,255,192,0,63,0,189,0,0,0,15,192,0,63,0,189,15,193,248,15,192,127,255,253,189,15,193,248,15,192,127,255,253,189,31,129,248,10,128,127,255,253,0,47,129,248,0,0,0,127,0,0,63,65,248,3,64,0,63,0,0,191,1,248,3,224,0,63,0,2,253,1,252,7,208,0,63,0,31,248,1,255,255,192,0,63,0,255,224,0,255,255,128,0,63,0,127,64,127,26,169,0,0,63,188,16,0,127,0,0,0,0,191,253,0,0,127,0,0,0,111,255,253,0,0,127,0,0,0,191,255,144,255,255,255,255,255,192,127,255,0,255,255,255,255,255,192,120,63,0,255,255,255,255,255,192,0,63,0,0,11,255,244,0,0,0,63,0,0,31,255,252,0,0,0,63,0,0,63,255,255,0,0,0,63,0,0,255,127,63,128,0,0,63,0,3,252,127,31,224,0,0,63,0,15,244,127,7,248,0,0,63,0,127,208,127,2,255,0,0,63,7,255,64,127,0,191,224,0,127,11,253,0,127,0,47,208,63,254,3,224,0,127,0,7,128,31,253,0,64,0,127,0,0,0,15,228,0,0,0,127,0,0,0,
  // 0x63a5  接
  165,99,34,35,59,36,1,252,0,47,64,0,0,127,0,0,0,0,47,64,0,0,127,0,0,0,0,47,64,0,0,127,0,0,0,0,47,64,0,0,127,0,0,0,0,47,64,191,255,255,255,255,64,0,47,64,191,255,255,255,255,64,0,47,64,127,255,255,255,255,64,0,47,128,0,252,0,15,192,0,127,255,254,0,253,0,31,192,0,127,255,254,0,126,0,63,64,0,127,255,254,0,127,0,63,0,0,0,47,64,0,63,0,126,0,0,0,47,66,255,255,255,255,255,208,0,47,67,255,255,255,255,255,208,0,47,67,255,255,255,255,255,208,0,47,64,0,7,244,0,0,0,0,47,174,0,11,240,0,0,0,0,63,255,0,15,208,0,0,0,27,255,255,255,255,255,255,255,208,255,255,230,255,255,255,255,255,208,191,255,66,255,255,255,255,255,208,126,47,64,0,253,0,31,192,0,0,47,64,1,252,0,47,192,0,0,47,64,3,248,0,63,64,0,0,47,64,7,244,0,127,0,0,0,47,64,15,255,128,254,0,0,0,47,64,31,255,255,252,0,0,0,47,64,6,159,255,248,0,0,0,47,64,0,0,255,254,0,0,0,47,64,0,7,255,255,224,0,0,63,64,5,191,253,191,253,0,47,255,71,255,255,224,11,255,64,15,255,3,255,249,0,0,191,0,15,248,2,249,0,0,0,28,0,0,0,0,0,0,0,0,0,0,
  // 0x63a7  控
  167,99,34,34,50,36,1,253,0,62,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,255,255,255,255,255,192,0,63,0,255,255,255,255,255,192,0,63,0,255,255,255,255,255,192,0,127,1,248,31,193,248,15,192,127,255,253,248,31,129,248,15,192,127,255,253,248,31,129,248,15,192,127,255,253,248,47,65,248,0,0,0,63,0,0,63,1,248,1,0,0,63,0,0,127,1,248,7,192,0,63,0,1,253,1,248,11,192,0,63,0,11,252,1,255,175,192,0,63,25,191,240,0,255,255,128,0,63,253,191,128,0,127,254,0,0,191,254,56,0,0,0,0,0,47,255,248,0,0,0,0,0,0,255,255,128,0,0,0,0,0,0,191,255,0,63,255,255,255,254,0,125,127,0,63,255,255,255,254,0,0,63,0,63,255,255,255,254,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,127,3,255,255,255,255,255,224,63,254,3,255,255,255,255,255,224,31,253,3,255,255,255,255,255,224,15,228,0,0,0,0,0,0,0,
  // 0x63d0  提
  208,99,34,35,59,36,1,252,0,126,0,0,0,0,0,0,0,0,126,0,15,255,255,255,252,0,0,126,0,15,255,255,255,252,0,0,126,0,15,213,85,86,252,0,0,126,0,15,192,0,0,252,0,0,126,0,15,192,0,0,252,0,0,126,0,15,255,255,255,252,0,127,255,254,15,255,255,255,252,0,127,255,254,15,213,85,85,252,0,127,255,254,15,192,0,0,252,0,0,127,0,15,192,0,0,252,0,0,126,0,15,255,255,255,252,0,0,126,0,15,255,255,255,252,0,0,126,0,5,85,85,85,84,0,0,126,0,0,0,0,0,0,0,0,126,0,0,0,0,0,0,0,0,126,24,255,255,255,255,255,192,0,127,253,255,255,255,255,255,192,6,255,254,170,170,255,170,170,128,191,255,248,0,0,127,0,0,0,191,255,0,11,128,127,0,0,0,126,190,0,15,192,127,0,0,0,0,126,0,15,192,127,170,168,0,0,126,0,31,192,127,255,252,0,0,126,0,47,192,127,255,252,0,0,126,0,63,192,127,0,0,0,0,126,0,63,224,127,0,0,0,0,126,0,191,244,127,0,0,0,0,126,0,253,252,127,0,0,0,0,126,2,252,63,191,0,0,0,0,126,7,244,31,255,255,255,224,63,254,15,240,2,255,255,255,208,47,252,47,192,0,27,255,255,192,31,228,7,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x63d2  插
  210,99,33,34,50,36,1,253,0,62,0,0,0,0,0,0,0,0,63,0,0,0,0,22,248,0,0,63,0,1,90,191,255,253,0,0,63,0,127,255,255,255,254,0,0,63,0,63,255,255,233,64,0,0,63,0,42,85,127,0,0,0,0,63,0,0,0,63,0,0,0,127,255,253,0,0,63,0,0,0,127,255,254,255,255,255,255,255,192,127,255,254,255,255,255,255,255,192,0,127,1,255,255,255,255,255,192,0,63,0,0,0,63,0,0,0,0,63,0,0,0,63,0,0,0,0,63,0,0,4,63,0,0,0,0,63,0,0,62,63,0,0,0,0,63,0,182,255,255,63,255,64,0,63,124,191,254,191,63,255,64,0,127,253,191,208,63,47,255,64,111,255,253,190,0,63,0,47,64,191,255,144,189,0,63,0,47,64,127,191,0,189,0,63,0,47,64,32,63,0,191,253,63,47,255,64,0,63,0,191,253,63,47,255,64,0,63,0,191,253,63,47,255,64,0,63,0,189,0,63,0,47,64,0,63,0,189,0,63,0,47,64,0,63,0,189,0,63,0,47,64,0,63,0,189,0,63,0,47,64,0,63,0,189,0,63,0,47,64,0,63,0,191,255,255,255,255,64,0,127,0,191,255,255,255,255,64,63,254,0,191,255,255,255,255,64,31,253,0,189,0,0,0,47,64,15,228,0,125,0,0,0,47,64,
  // 0x63db  換
  219,99,34,35,59,36,1,252,0,62,0,0,58,0,0,0,0,0,63,0,0,127,0,0,0,0,0,63,0,0,254,0,0,0,0,0,63,0,1,255,255,244,0,0,0,63,0,3,255,255,252,0,0,0,63,0,15,250,171,248,0,0,0,63,0,47,208,3,240,0,0,127,255,254,255,128,11,224,0,0,127,255,255,255,0,15,192,0,0,127,255,255,255,255,255,255,255,0,0,127,0,191,255,255,255,255,0,0,63,0,63,175,235,250,191,0,0,63,0,63,7,195,224,63,0,0,63,0,63,11,195,224,63,0,0,63,0,63,15,67,224,63,0,0,63,4,63,63,3,255,255,0,0,63,189,63,253,1,255,255,0,1,191,253,63,176,0,0,63,0,111,255,253,63,0,0,0,63,0,191,255,144,63,0,126,0,63,0,127,255,0,42,0,189,0,42,0,120,63,0,0,0,189,0,0,0,0,63,3,255,255,255,255,255,192,0,63,3,255,255,255,255,255,192,0,63,2,255,255,255,255,255,192,0,63,0,0,3,255,192,0,0,0,63,0,0,7,255,224,0,0,0,63,0,0,15,231,244,0,0,0,63,0,0,63,194,254,0,0,0,63,0,2,255,64,255,208,0,0,127,0,47,252,0,63,253,0,63,254,11,255,224,0,11,255,208,31,253,11,255,0,0,1,255,128,15,228,3,208,0,0,0,11,0,0,0,0,0,0,0,0,0,0,
  // 0x64c7  擇
  199,100,34,35,59,36,1,252,0,63,0,0,0,0,0,0,0,0,63,0,21,85,85,85,85,0,0,63,0,63,255,255,255,255,64,0,63,0,63,255,255,255,255,64,0,63,0,62,11,192,248,31,64,0,63,0,62,11,192,248,31,64,0,63,0,62,11,192,248,31,64,127,255,253,63,255,255,255,255,64,127,255,253,63,255,255,255,255,64,127,255,253,21,85,127,85,85,0,0,127,0,0,0,63,0,0,0,0,63,0,21,85,191,85,85,0,0,63,0,47,255,255,255,255,0,0,63,0,47,255,255,255,255,0,0,63,0,0,0,63,0,0,0,0,63,4,0,0,63,0,0,0,0,63,254,255,255,255,255,255,224,1,191,255,255,255,255,255,255,224,127,255,254,170,254,170,175,250,144,191,255,128,0,252,0,15,192,0,127,255,0,0,190,0,47,128,0,121,63,0,0,63,0,63,0,0,0,63,0,255,255,255,255,255,192,0,63,0,255,255,255,255,255,192,0,63,0,170,170,191,170,170,128,0,63,0,0,0,63,0,0,0,0,63,0,0,0,63,0,0,0,0,63,0,63,255,255,255,255,0,0,63,0,63,255,255,255,255,0,0,63,0,42,170,191,170,170,0,0,127,0,0,0,63,0,0,0,63,254,0,0,0,63,0,0,0,31,253,0,0,0,63,0,0,0,15,228,0,0,0,63,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x64ca  擊
  202,100,32,34,16,36,2,253,0,7,192,0,0,0,0,0,0,7,208,0,11,255,255,0,191,255,255,255,11,255,255,0,191,255,255,254,11,213,127,4,5,91,229,84,15,192,63,15,47,255,255,252,31,128,63,95,46,7,208,188,127,64,63,255,47,255,255,252,254,0,15,252,47,91,213,188,56,0,0,0,47,91,229,188,127,255,255,240,47,255,255,252,127,255,255,224,0,7,208,0,11,208,15,192,255,255,255,255,7,240,47,128,255,255,255,254,2,253,254,0,31,7,208,244,0,191,248,0,31,7,208,248,27,255,249,0,31,255,255,248,255,255,255,233,31,255,255,248,127,64,47,255,0,0,0,0,21,107,209,189,1,255,255,255,255,255,244,0,0,255,255,255,254,149,0,0,0,0,0,11,224,0,0,0,0,0,0,11,224,0,0,0,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,240,0,0,0,11,224,0,0,0,21,85,85,95,229,85,85,84,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,11,224,0,0,0,0,0,0,11,224,0,0,0,0,0,21,95,224,0,0,0,0,0,47,255,208,0,0,0,0,0,15,254,64,0,0,0,
  // 0x64cb  擋
  203,100,33,34,50,36,1,253,0,63,0,1,0,127,0,80,0,0,63,0,31,128,127,0,253,0,0,63,0,15,208,127,1,252,0,0,63,0,7,240,127,3,244,0,0,63,0,3,240,127,7,224,0,0,63,0,2,224,127,7,192,0,0,63,0,255,255,255,255,255,192,127,255,253,255,255,255,255,255,192,127,255,253,254,170,170,170,175,192,127,255,253,252,0,0,0,15,192,0,127,0,253,85,85,85,95,192,0,63,0,254,255,255,255,255,192,0,63,0,2,255,255,255,240,0,0,63,0,2,249,85,91,240,0,0,63,0,2,244,0,7,240,0,0,63,4,2,244,0,7,240,0,0,63,253,2,255,255,255,240,0,1,255,253,2,255,255,255,240,0,191,255,253,0,85,85,85,80,0,191,255,64,0,0,0,0,0,0,127,255,0,63,255,255,255,255,0,36,63,0,63,255,255,255,255,0,0,63,0,63,149,191,85,191,0,0,63,0,63,0,62,0,127,0,0,63,0,63,0,62,0,127,0,0,63,0,63,255,255,255,255,0,0,63,0,63,255,255,255,255,0,0,63,0,63,149,191,85,191,0,0,63,0,63,0,62,0,127,0,0,63,0,63,0,62,0,127,0,0,127,0,63,255,255,255,255,0,63,254,0,63,255,255,255,255,0,31,253,0,63,170,170,170,191,0,15,228,0,47,0,0,0,127,0,
  // 0x64e0  擠
  224,100,34,35,59,36,1,252,0,126,0,0,0,127,0,0,0,0,126,0,0,0,127,0,0,0,0,126,0,0,0,127,0,0,0,0,126,3,255,255,255,255,255,192,0,126,3,255,255,255,255,255,192,0,126,2,170,175,170,254,170,128,0,126,0,0,15,0,248,0,0,127,255,252,0,11,128,240,9,0,127,255,252,0,7,194,240,191,64,127,255,254,255,255,227,255,255,64,0,126,2,255,254,190,111,252,0,0,126,0,61,61,61,46,45,0,0,126,0,60,61,61,45,31,0,0,126,0,188,61,61,45,15,0,0,126,0,248,60,61,46,171,192,0,126,107,243,252,61,191,243,224,0,127,255,195,244,61,126,65,192,6,255,253,5,64,40,0,84,0,191,255,224,15,192,0,1,252,0,191,255,0,15,192,0,1,252,0,127,190,0,15,255,255,255,252,0,32,126,0,15,255,255,255,252,0,0,126,0,15,234,170,170,252,0,0,126,0,15,192,0,1,252,0,0,126,0,31,192,0,1,252,0,0,126,0,31,234,170,171,252,0,0,126,0,47,255,255,255,252,0,0,126,0,63,255,255,255,252,0,0,126,0,63,0,0,1,252,0,0,126,0,191,0,0,1,252,0,0,126,1,253,0,0,1,252,0,63,254,3,252,0,0,1,252,0,47,252,11,240,0,0,1,252,0,31,228,1,208,0,0,1,252,0,0,0,0,0,0,0,0,0,0,
  // 0x6536  收
  54,101,34,35,59,36,1,252,0,0,15,192,3,144,0,0,0,0,0,31,192,3,244,0,0,0,0,0,31,192,7,240,0,0,0,0,0,31,192,11,240,0,0,0,2,144,31,192,15,224,0,0,0,7,240,31,192,31,208,0,0,0,7,240,31,192,47,192,0,0,0,7,240,31,192,63,255,255,255,224,7,240,31,192,127,255,255,255,224,7,240,31,192,255,255,255,255,224,7,240,31,193,255,0,0,253,0,7,240,31,195,255,64,1,252,0,7,240,31,199,255,128,2,252,0,7,240,31,207,255,192,3,248,0,7,240,31,239,239,192,3,244,0,7,240,31,255,203,224,7,240,0,7,240,31,223,7,240,11,240,0,7,240,31,198,3,244,15,208,0,7,240,31,192,2,252,47,192,0,7,240,31,192,1,252,63,128,0,7,240,31,192,0,254,191,0,0,7,241,191,192,0,127,254,0,0,7,255,255,192,0,63,252,0,0,127,255,255,192,0,47,248,0,0,127,255,175,192,0,31,240,0,0,63,228,31,192,0,127,252,0,0,41,0,31,192,1,255,254,0,0,0,0,31,192,7,254,255,128,0,0,0,31,192,47,248,63,240,0,0,0,31,193,255,224,15,253,0,0,0,31,203,255,128,7,255,128,0,0,31,239,253,0,0,255,224,0,0,31,207,224,0,0,47,192,0,0,31,199,0,0,0,3,0,0,0,0,0,0,0,0,0,0,
  // 0x653e  放
  62,101,34,35,59,36,1,252,0,3,240,0,0,185,0,0,0,0,3,240,0,0,254,0,0,0,0,3,240,0,0,254,0,0,0,0,3,240,0,0,253,0,0,0,0,3,240,0,1,252,0,0,0,0,7,244,0,2,252,0,0,0,127,255,255,255,67,248,0,0,0,127,255,255,255,67,255,255,255,224,127,255,255,255,71,255,255,255,224,0,126,0,0,15,255,255,255,224,0,126,0,0,31,224,2,252,0,0,126,0,0,47,240,2,248,0,0,126,0,0,63,240,3,244,0,0,127,255,252,191,244,3,240,0,0,127,255,253,255,248,7,240,0,0,127,255,255,254,252,11,224,0,0,126,0,253,248,252,15,208,0,0,126,0,252,112,190,31,192,0,0,126,0,252,0,127,47,192,0,0,190,0,252,0,63,127,64,0,0,190,1,252,0,63,255,0,0,0,253,1,252,0,31,254,0,0,0,253,1,252,0,15,253,0,0,0,252,1,252,0,11,252,0,0,1,252,1,252,0,11,252,0,0,2,252,1,248,0,31,253,0,0,3,248,2,248,0,127,255,64,0,7,240,2,248,1,255,191,192,0,15,240,2,248,7,253,47,240,0,31,208,3,244,47,244,15,253,0,63,192,7,245,255,208,3,255,128,255,67,255,251,255,64,0,255,208,126,2,255,227,252,0,0,47,128,8,1,255,64,208,0,0,6,0,0,0,0,0,0,0,0,0,0,
  // 0x6557  敗
  87,101,34,35,59,36,1,252,0,0,0,0,0,249,0,0,0,10,170,170,168,0,253,0,0,0,11,255,255,252,1,252,0,0,0,11,255,255,252,2,252,0,0,0,11,208,0,252,3,248,0,0,0,11,208,0,252,3,244,0,0,0,11,208,0,252,7,244,0,0,0,11,208,0,252,11,255,255,255,224,11,250,170,252,15,255,255,255,224,11,255,255,252,31,255,255,255,224,11,255,255,252,63,192,2,248,0,11,208,0,252,127,208,3,248,0,11,208,0,252,255,224,3,244,0,11,208,0,254,255,240,7,240,0,11,208,0,255,255,240,11,240,0,11,255,255,255,247,244,15,224,0,11,255,255,255,242,252,15,208,0,11,250,170,253,193,252,31,192,0,11,208,0,252,0,254,63,192,0,11,208,0,252,0,191,63,128,0,11,208,0,252,0,127,191,0,0,11,208,0,252,0,63,255,0,0,11,255,255,252,0,31,253,0,0,11,255,255,252,0,15,252,0,0,6,170,170,168,0,15,248,0,0,0,100,1,64,0,47,252,0,0,0,254,15,208,0,127,255,0,0,1,252,11,240,1,255,255,192,0,3,248,3,248,11,253,63,240,0,11,240,1,253,63,244,15,253,0,31,224,0,191,255,208,3,255,208,63,192,0,59,255,64,0,255,224,127,0,0,1,248,0,0,47,128,13,0,0,0,208,0,0,3,0,0,0,0,0,0,0,0,0,0,
  // 0x6574  整
  116,101,33,33,41,36,2,254,0,3,240,0,0,120,0,0,0,0,3,240,0,0,254,0,0,0,255,255,255,255,128,252,0,0,0,255,255,255,255,130,252,0,0,0,85,87,245,85,3,255,255,255,0,0,3,240,0,11,255,255,255,0,63,255,255,255,31,250,175,250,0,63,255,255,255,63,224,11,208,0,63,3,240,63,255,240,15,192,0,62,3,240,63,253,252,47,128,0,63,3,240,63,56,190,63,0,0,63,255,255,255,0,63,254,0,0,63,255,255,255,0,31,252,0,0,0,63,254,0,0,15,248,0,0,0,255,255,208,0,127,254,0,0,7,251,251,253,2,255,255,208,0,63,211,240,254,127,252,47,254,0,255,67,240,45,255,224,7,255,64,120,3,240,0,126,0,0,190,0,0,1,80,0,16,0,0,8,0,10,170,170,170,170,170,170,160,0,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,0,0,0,11,224,0,0,0,0,0,26,64,11,224,0,0,0,0,0,47,128,11,250,170,168,0,0,0,47,128,11,255,255,253,0,0,0,47,128,11,255,255,253,0,0,0,47,128,11,224,0,0,0,0,0,47,128,11,224,0,0,0,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,
  // 0x6578  數
  120,101,34,35,59,36,1,252,0,0,125,0,0,11,144,0,0,0,0,125,0,0,15,224,0,0,3,255,255,255,224,15,208,0,0,3,255,255,255,224,15,192,0,0,3,224,190,11,224,15,192,0,0,3,224,125,7,224,31,192,0,0,191,255,255,255,255,47,128,0,0,191,255,255,255,255,63,255,255,224,27,224,190,7,229,63,255,255,224,3,224,125,7,224,127,255,255,224,3,255,255,255,224,190,0,189,0,3,255,255,255,224,255,0,253,0,0,0,190,0,1,255,0,252,0,0,0,190,0,3,255,64,252,0,15,255,255,255,251,255,65,252,0,15,255,255,255,255,255,130,248,0,15,192,125,2,255,223,195,244,0,15,192,125,2,251,207,195,240,0,15,255,255,255,245,75,215,240,0,15,255,255,255,244,7,251,224,0,0,3,244,0,0,3,255,208,0,0,7,224,0,0,2,255,192,0,106,175,255,255,255,1,255,128,0,127,255,255,255,255,0,255,0,0,127,255,170,191,149,0,255,0,0,0,189,0,63,0,2,255,64,0,0,254,64,190,0,7,255,192,0,2,255,245,252,0,15,255,224,0,3,255,255,244,0,63,219,244,0,0,0,255,248,0,255,131,253,0,0,11,255,255,71,254,1,255,64,27,255,253,191,239,248,0,127,208,15,255,144,15,139,208,0,31,128,11,164,0,1,3,64,0,3,0,0,0,0,0,0,0,0,0,0,
  // 0x6599  料
  153,101,34,34,50,36,1,253,0,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,24,11,208,164,1,0,15,208,0,62,11,208,252,15,128,15,208,0,47,11,208,252,31,244,15,208,0,31,11,209,244,7,253,15,208,0,15,75,210,240,0,255,79,208,0,15,139,211,240,0,47,15,208,0,11,203,211,208,0,9,15,208,0,11,203,215,192,0,0,15,208,0,7,139,219,128,0,0,15,208,0,0,11,208,0,0,0,15,208,0,127,255,255,252,120,0,15,208,0,127,255,255,252,255,64,15,208,0,127,255,255,252,191,224,15,208,0,0,63,224,0,31,252,15,208,0,0,63,240,0,2,248,15,208,0,0,191,252,0,0,176,15,208,0,0,255,255,0,0,0,15,208,0,1,255,255,128,0,0,15,208,64,3,251,239,208,0,0,15,255,208,3,235,215,240,0,22,255,255,224,15,203,211,248,107,255,255,255,224,31,203,209,243,255,255,255,228,0,63,75,208,131,255,254,95,208,0,191,11,208,2,249,0,15,208,0,189,11,208,0,0,0,15,208,0,60,11,208,0,0,0,15,208,0,36,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,
  // 0x659c  斜
  156,101,34,34,50,36,1,253,0,2,253,0,0,0,3,240,0,0,3,255,64,0,0,3,240,0,0,7,255,208,0,0,3,240,0,0,15,255,244,0,180,3,240,0,0,47,203,253,2,253,3,240,0,0,127,130,255,64,255,67,240,0,0,255,0,191,192,63,211,240,0,3,252,0,47,240,15,247,240,0,11,244,0,15,192,3,247,240,0,47,224,0,3,64,0,195,240,0,191,255,255,254,0,0,3,240,0,255,255,255,254,0,0,3,240,0,61,255,255,254,2,192,3,240,0,0,0,253,0,15,244,3,240,0,0,0,253,0,3,254,3,240,0,0,0,253,0,0,191,195,240,0,63,255,255,255,224,47,227,240,0,63,255,255,255,224,11,131,240,0,63,255,255,255,224,1,3,240,0,0,0,253,0,0,0,3,240,64,0,0,253,0,0,0,3,255,208,3,224,253,46,0,1,191,255,224,3,240,253,63,5,191,255,255,224,7,224,253,47,95,255,255,248,0,11,208,253,31,207,255,231,240,0,15,192,253,15,207,164,3,240,0,47,128,253,11,224,0,3,240,0,63,64,253,3,240,0,3,240,0,191,0,253,3,224,0,3,240,0,125,0,253,1,0,0,3,240,0,8,0,253,0,0,0,3,240,0,0,191,252,0,0,0,3,240,0,0,63,252,0,0,0,3,240,0,0,63,224,0,0,0,3,240,0,
  // 0x65b0  新
  176,101,34,35,59,36,1,252,0,1,168,0,0,0,0,4,0,0,1,252,0,0,0,0,189,0,0,1,252,0,0,0,31,255,128,0,1,252,0,6,91,255,255,64,47,255,255,255,199,255,255,224,0,47,255,255,255,199,255,228,0,0,47,255,255,255,199,244,0,0,0,1,240,0,252,7,240,0,0,0,1,244,1,252,7,240,0,0,0,0,252,2,244,7,240,0,0,0,0,252,3,240,7,240,0,0,0,0,184,2,224,7,240,0,0,0,63,255,255,255,215,255,255,255,224,63,255,255,255,215,255,255,255,224,63,255,255,255,215,255,255,255,224,0,1,252,0,7,240,11,240,0,0,1,252,0,7,240,7,224,0,0,1,252,0,7,240,7,224,0,63,255,255,255,199,224,7,224,0,63,255,255,255,203,224,7,224,0,63,255,255,255,203,224,7,224,0,0,7,252,0,15,208,7,224,0,0,15,255,0,15,208,7,224,0,0,47,255,192,15,192,7,224,0,0,127,255,244,31,192,7,224,0,1,254,254,254,47,128,7,224,0,7,249,252,191,63,64,7,224,0,31,241,252,60,127,0,7,224,0,127,193,252,4,254,0,7,224,0,127,1,252,1,253,0,7,224,0,44,1,252,3,252,0,7,224,0,0,1,252,15,240,0,7,224,0,0,1,252,3,224,0,7,224,0,0,1,248,0,128,0,6,160,0,0,0,0,0,0,0,0,0,0,
  // 0x65b7  斷
  183,101,32,34,16,36,3,253,0,20,0,80,0,0,1,64,164,60,0,240,0,0,31,224,248,120,2,208,0,2,255,248,249,241,11,202,9,191,255,208,251,227,223,95,15,255,248,0,250,235,75,188,15,253,0,0,248,255,3,248,15,192,0,0,248,61,1,241,15,192,0,0,248,122,129,219,15,192,0,0,248,242,195,219,143,192,0,0,255,255,255,255,207,192,0,0,251,234,254,81,207,192,0,0,248,0,64,0,15,255,255,254,255,255,255,255,143,255,255,254,255,255,255,255,143,255,255,254,253,126,85,249,79,192,63,64,248,60,1,240,15,192,63,0,248,180,2,208,15,192,63,0,251,242,79,142,15,192,63,0,251,215,223,31,15,192,63,0,249,255,7,189,15,192,63,0,248,190,3,248,15,192,63,0,248,60,0,240,31,128,63,0,248,122,194,235,31,128,63,0,248,242,211,199,111,64,63,0,255,255,255,255,239,64,63,0,251,233,254,150,255,0,63,0,248,0,0,0,127,0,63,0,255,255,255,255,254,0,63,0,255,255,255,255,252,0,63,0,254,170,170,171,252,0,63,0,248,0,0,3,244,0,63,0,248,0,0,1,240,0,63,0,80,0,0,0,80,0,63,0,
  // 0x65bc  於
  188,101,34,35,59,36,1,252,0,7,240,0,0,15,240,0,0,0,7,240,0,0,31,240,0,0,0,7,240,0,0,47,248,0,0,0,7,240,0,0,63,252,0,0,0,7,240,0,0,127,253,0,0,0,7,240,0,0,253,127,0,0,127,255,255,255,1,252,63,128,0,127,255,255,255,3,248,47,192,0,127,255,255,255,11,240,15,224,0,0,190,0,0,31,224,7,244,0,0,190,0,0,63,192,3,252,0,0,190,0,0,255,64,0,255,0,0,190,0,2,254,0,0,191,208,0,190,0,7,252,0,0,63,224,0,255,255,251,240,4,0,15,192,0,255,255,245,192,62,0,3,128,0,255,255,244,0,191,208,0,0,0,253,2,244,0,47,244,0,0,0,252,3,244,0,7,254,0,0,0,252,3,244,0,0,255,64,0,0,252,3,244,0,0,63,0,0,1,252,3,244,0,0,12,0,0,1,252,3,244,0,0,0,0,0,2,248,3,240,0,0,0,0,0,3,244,3,240,11,128,0,0,0,3,240,3,240,31,248,0,0,0,7,240,3,240,31,255,128,0,0,11,224,3,240,2,255,244,0,0,15,208,3,240,0,47,254,0,0,47,192,7,240,0,7,255,208,0,63,128,15,224,0,0,191,248,0,191,11,255,224,0,0,15,252,0,62,7,255,192,0,0,2,240,0,12,3,254,0,0,0,0,144,0,0,0,0,0,0,0,0,0,0,
  // 0x6607  昇
  7,102,32,33,8,36,2,253,1,170,170,170,170,170,170,64,1,255,255,255,255,255,255,64,1,255,255,255,255,255,255,64,1,252,0,0,0,0,63,64,1,252,0,0,0,0,63,64,1,252,0,0,0,0,63,64,1,255,255,255,255,255,255,64,1,255,255,255,255,255,255,64,1,254,170,170,170,170,191,64,1,252,0,0,0,0,63,64,1,252,0,0,0,0,63,64,1,255,255,255,255,255,255,64,1,255,255,255,255,255,255,64,1,170,170,170,170,170,170,64,0,0,0,27,64,5,64,0,0,0,91,255,208,47,192,0,6,255,255,255,224,47,192,0,15,255,255,228,0,47,192,0,11,250,127,64,0,47,192,0,0,0,63,64,0,47,192,0,0,0,63,64,0,47,192,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,191,0,0,47,192,0,0,0,254,0,0,47,192,0,0,3,253,0,0,47,192,0,0,11,248,0,0,47,192,0,0,127,240,0,0,47,192,0,7,255,208,0,0,47,192,0,47,255,0,0,0,47,192,0,15,244,0,0,0,47,192,0,3,64,0,0,0,47,192,0,
  // 0x660e  明
  14,102,31,33,8,36,3,252,255,255,255,3,255,255,255,244,255,255,255,3,255,255,255,244,255,255,255,3,255,255,255,244,252,0,127,3,240,0,3,244,252,0,63,3,240,0,3,244,252,0,63,3,240,0,3,244,252,0,63,3,240,0,3,244,252,0,63,3,240,0,3,244,252,0,63,3,255,255,255,244,252,0,63,3,255,255,255,244,255,255,255,3,255,255,255,244,255,255,255,3,240,0,3,244,255,255,255,3,240,0,3,244,252,0,63,3,240,0,3,244,252,0,63,7,240,0,3,244,252,0,63,7,240,0,3,244,252,0,63,7,240,0,3,244,252,0,63,7,255,255,255,244,252,0,63,11,255,255,255,244,255,255,255,15,255,255,255,244,255,255,255,15,208,0,3,244,255,255,255,15,192,0,3,244,252,0,0,47,192,0,3,244,252,0,0,63,128,0,3,244,252,0,0,127,0,0,3,244,84,0,0,255,0,0,3,244,0,0,2,253,0,0,3,244,0,0,7,252,0,0,3,244,0,0,15,240,0,0,7,244,0,0,127,224,0,31,255,240,0,0,127,128,0,15,255,240,0,0,14,0,0,11,254,64,0,0,0,0,0,0,0,0,
  // 0x662f  是
  47,102,34,33,41,36,1,253,0,21,85,85,85,85,85,64,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,85,85,85,85,111,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,149,85,85,85,111,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,0,0,0,1,252,0,0,0,0,0,3,144,1,252,0,0,0,0,0,7,244,1,252,0,0,0,0,0,11,240,1,252,0,0,0,0,0,15,240,1,255,255,255,244,0,0,15,224,1,255,255,255,244,0,0,47,240,1,255,255,255,244,0,0,63,252,1,252,0,0,0,0,0,191,255,1,252,0,0,0,0,1,254,127,209,252,0,0,0,0,7,252,31,255,252,0,0,0,0,31,240,7,255,255,255,255,255,208,127,208,0,127,255,255,255,255,192,47,64,0,1,191,255,255,255,128,9,0,0,0,0,0,0,0,0,
  // 0x6642  時
  66,102,33,34,50,36,2,253,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,127,255,253,0,0,191,0,0,0,127,255,253,0,0,191,0,0,0,127,255,253,47,255,255,255,252,0,127,0,253,47,255,255,255,252,0,127,0,253,47,255,255,255,252,0,127,0,253,0,0,191,0,0,0,127,0,253,0,0,191,0,0,0,127,0,253,0,0,191,0,0,0,127,0,253,0,0,191,0,0,0,127,0,253,255,255,255,255,255,128,127,0,253,255,255,255,255,255,128,127,255,253,255,255,255,255,255,128,127,255,253,0,0,0,63,64,0,127,255,253,0,0,0,63,64,0,127,0,253,0,0,0,63,64,0,127,0,253,0,0,0,63,64,0,127,0,253,255,255,255,255,255,0,127,0,253,255,255,255,255,255,64,127,0,253,255,255,255,255,255,64,127,0,253,0,0,0,63,64,0,127,0,253,0,192,0,63,64,0,127,0,253,11,240,0,63,64,0,127,255,253,11,248,0,63,64,0,127,255,253,2,253,0,63,64,0,127,255,253,0,255,0,63,64,0,127,0,0,0,63,128,63,64,0,127,0,0,0,47,128,63,64,0,127,0,0,0,13,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,255,255,64,0,0,0,0,0,0,191,255,0,0,0,0,0,0,0,63,248,0,0,
  // 0x66ab  暫
  171,102,32,34,16,36,2,253,0,3,240,0,0,0,1,128,0,3,240,0,0,1,111,240,191,255,255,255,95,191,255,248,191,255,255,255,95,255,254,64,0,3,240,0,31,249,0,0,26,171,250,169,31,128,0,0,63,255,255,254,31,128,0,0,62,3,240,62,31,128,0,0,62,3,240,62,31,255,255,255,63,255,255,254,31,255,255,255,63,171,250,190,31,234,191,170,62,3,240,62,47,64,63,0,63,255,255,254,63,0,63,0,26,171,250,169,63,0,63,0,0,3,240,0,190,0,63,0,255,255,255,255,253,0,63,0,255,255,255,255,248,0,63,0,0,3,240,11,240,0,63,0,0,3,240,2,208,0,63,0,0,1,64,0,64,0,0,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,170,170,170,170,252,0,0,63,0,0,0,0,252,0,0,63,0,0,0,0,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,85,85,85,85,252,0,0,63,0,0,0,0,252,0,0,63,0,0,0,0,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,170,170,170,170,252,0,0,63,0,0,0,0,252,0,
  // 0x66f4  更
  244,102,33,33,41,36,2,252,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,1,254,170,175,250,170,175,208,0,1,252,0,7,240,0,15,208,0,1,252,0,7,240,0,15,208,0,1,254,170,175,250,170,175,208,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,1,252,0,7,240,0,15,208,0,1,252,0,7,240,0,15,208,0,1,252,0,11,240,0,15,208,0,1,254,170,175,250,170,175,208,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,0,6,0,15,208,0,0,0,0,0,127,64,47,192,0,0,0,0,0,63,208,63,128,0,0,0,0,0,15,244,255,64,0,0,0,0,0,7,255,255,0,0,0,0,0,0,1,255,252,0,0,0,0,0,0,0,191,253,0,0,0,0,0,0,11,255,255,249,0,0,0,0,6,255,255,255,255,255,169,85,0,255,255,244,27,255,255,255,255,64,127,254,0,0,107,255,255,255,0,47,144,0,0,0,21,175,254,0,0,0,0,0,0,0,0,0,0,
  // 0x6700  最
  0,103,32,33,8,36,2,253,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,190,85,85,85,85,254,0,0,190,0,0,0,0,190,0,0,190,0,0,0,0,190,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,190,0,0,0,0,190,0,0,190,0,0,0,0,190,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,254,171,254,171,255,170,170,170,170,3,240,0,252,0,0,0,0,3,240,0,252,0,0,0,0,3,255,255,252,255,255,255,244,3,255,255,252,255,255,255,244,3,249,85,252,107,234,175,240,3,240,0,252,31,192,15,208,3,249,85,252,15,208,47,192,3,255,255,252,7,240,127,128,3,255,255,252,2,252,255,0,3,240,0,252,0,255,252,0,3,240,0,252,0,127,244,0,3,250,191,252,0,127,240,0,255,255,255,252,7,255,254,0,255,255,255,252,127,253,255,228,254,148,0,255,255,224,47,255,0,0,0,252,254,0,7,254,0,0,0,252,96,0,0,44,
  // 0x6709  有
  9,103,33,35,59,36,1,252,0,0,0,100,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,2,252,0,0,0,0,0,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,0,0,31,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,2,255,255,255,255,255,128,0,0,7,255,255,255,255,255,128,0,0,15,255,255,255,255,255,128,0,0,63,253,0,0,0,47,128,0,0,255,253,0,0,0,47,128,0,3,255,253,0,0,0,47,128,0,31,252,255,255,255,255,255,128,0,127,240,255,255,255,255,255,128,0,63,128,255,255,255,255,255,128,0,14,0,253,0,0,0,47,128,0,0,0,253,0,0,0,47,128,0,0,0,253,0,0,0,47,128,0,0,0,255,255,255,255,255,128,0,0,0,255,255,255,255,255,128,0,0,0,255,255,255,255,255,128,0,0,0,253,0,0,0,47,128,0,0,0,253,0,0,0,47,128,0,0,0,253,0,0,0,47,128,0,0,0,253,0,0,0,63,128,0,0,0,253,0,0,255,255,64,0,0,0,253,0,0,191,255,0,0,0,0,253,0,0,127,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x677f  板
  127,103,34,35,59,36,1,252,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,2,255,255,255,255,192,0,15,192,2,255,255,255,255,192,0,15,192,2,255,255,255,255,192,0,15,192,2,248,0,0,0,0,0,15,192,2,244,0,0,0,0,0,15,192,2,244,0,0,0,0,63,255,255,226,244,0,0,0,0,63,255,255,226,244,0,0,0,0,63,255,255,226,244,0,0,0,0,0,31,192,2,248,0,0,0,0,0,47,192,2,255,255,255,255,64,0,63,192,3,255,255,255,255,64,0,127,224,3,255,255,255,255,0,0,191,244,3,255,208,0,127,0,0,255,252,3,255,224,0,190,0,1,255,255,3,247,240,0,253,0,2,255,239,131,242,244,1,252,0,3,223,207,211,241,252,2,248,0,11,207,199,243,240,253,3,244,0,15,143,194,199,240,191,11,240,0,63,79,192,71,224,63,95,208,0,127,15,192,11,224,47,255,192,0,253,15,192,15,208,15,255,64,0,60,15,192,31,192,7,254,0,0,36,15,192,47,192,3,253,0,0,0,15,192,63,128,15,255,64,0,0,15,192,127,0,127,255,208,0,0,15,192,191,1,255,159,248,0,0,15,193,253,31,253,7,255,128,0,15,195,252,63,244,1,255,224,0,15,193,244,31,128,0,63,128,0,15,192,32,9,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x67f1  柱
  241,103,34,35,59,36,1,252,0,11,224,0,0,176,0,0,0,0,11,224,0,3,253,0,0,0,0,11,224,0,2,255,128,0,0,0,11,224,0,0,127,240,0,0,0,11,224,0,0,15,252,0,0,0,11,224,0,0,2,253,0,0,0,11,224,0,0,0,244,0,0,0,11,224,3,255,255,255,255,192,63,255,255,247,255,255,255,255,192,63,255,255,247,255,255,255,255,192,63,255,255,244,0,11,240,0,0,0,15,224,0,0,11,240,0,0,0,31,224,0,0,11,240,0,0,0,47,224,0,0,11,240,0,0,0,63,244,0,0,11,240,0,0,0,127,252,0,0,11,240,0,0,0,255,255,0,0,11,240,0,0,0,255,255,192,0,11,240,0,0,2,251,239,224,255,255,255,255,128,3,235,227,244,255,255,255,255,128,11,219,226,244,255,255,255,255,128,15,203,224,224,0,11,240,0,0,47,139,224,64,0,11,240,0,0,127,11,224,0,0,11,240,0,0,190,11,224,0,0,11,240,0,0,60,11,224,0,0,11,240,0,0,36,11,224,0,0,11,240,0,0,0,11,224,0,0,11,240,0,0,0,11,224,0,0,11,240,0,0,0,11,224,0,0,11,240,0,0,0,11,224,63,255,255,255,255,224,0,11,224,63,255,255,255,255,224,0,11,224,63,255,255,255,255,224,0,11,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6821  校
  33,104,34,35,59,36,1,252,0,15,192,0,0,31,192,0,0,0,15,192,0,0,31,192,0,0,0,15,192,0,0,31,192,0,0,0,15,192,0,0,31,192,0,0,0,15,192,0,0,31,192,0,0,0,15,192,31,255,255,255,255,192,0,15,192,31,255,255,255,255,192,0,15,192,31,255,255,255,255,192,63,255,255,218,170,170,170,170,128,63,255,255,192,4,0,1,0,0,63,255,255,192,47,64,15,192,0,0,47,192,0,63,128,15,240,0,0,63,192,0,191,0,7,248,0,0,63,192,1,253,0,1,253,0,0,127,240,3,248,0,0,191,0,0,191,244,15,240,0,0,63,192,0,255,252,63,235,0,15,159,208,1,255,255,47,127,64,31,203,192,3,255,223,73,31,192,63,129,0,7,239,207,192,15,192,63,64,0,11,207,199,208,11,240,191,0,0,15,143,195,128,3,244,253,0,0,63,79,193,0,2,255,252,0,0,127,15,192,0,0,255,244,0,0,189,15,192,0,0,127,224,0,0,60,15,192,0,0,63,224,0,0,36,15,192,0,0,255,248,0,0,0,15,192,0,7,255,255,0,0,0,15,192,0,31,245,255,192,0,0,15,192,1,255,208,63,248,0,0,15,192,27,255,0,15,255,128,0,15,192,191,248,0,3,255,208,0,15,192,63,208,0,0,127,128,0,15,192,45,0,0,0,11,0,0,0,0,0,0,0,0,0,0,
  // 0x683c  格
  60,104,34,35,59,36,1,252,0,15,192,0,1,224,0,0,0,0,15,192,0,3,248,0,0,0,0,15,192,0,7,244,0,0,0,0,15,192,0,15,240,0,0,0,0,15,192,0,31,255,255,244,0,0,15,192,0,63,255,255,252,0,0,15,192,0,191,255,255,244,0,0,15,192,1,255,0,7,240,0,63,255,255,231,255,64,15,224,0,63,255,255,239,255,192,47,192,0,63,255,255,255,223,224,127,64,0,0,31,192,191,71,248,254,0,0,0,47,208,29,2,255,252,0,0,0,63,244,0,0,191,240,0,0,0,127,252,0,0,127,240,0,0,0,191,255,0,2,255,253,0,0,0,255,239,192,15,255,255,128,0,1,255,207,208,191,240,127,248,0,3,239,195,203,255,128,31,255,208,7,223,194,255,253,0,2,255,224,15,207,192,255,255,255,255,255,128,31,143,192,126,255,255,255,253,0,63,15,192,17,255,255,255,252,0,191,15,192,1,248,0,1,252,0,189,15,192,1,248,0,1,252,0,60,15,192,1,248,0,1,252,0,36,15,192,1,248,0,1,252,0,0,15,192,1,248,0,1,252,0,0,15,192,1,248,0,1,252,0,0,15,192,1,248,0,1,252,0,0,15,192,1,255,255,255,252,0,0,15,192,1,255,255,255,252,0,0,15,192,1,255,255,255,252,0,0,15,192,1,248,0,1,252,0,0,0,0,0,0,0,0,0,0,
  // 0x689d  條
  157,104,34,35,59,36,1,252,0,2,64,0,2,144,0,0,0,0,7,240,0,3,240,0,0,0,0,11,224,0,11,240,0,0,0,0,15,208,0,15,208,0,0,0,0,31,197,64,63,255,255,255,192,0,63,143,192,191,255,255,255,192,0,127,15,193,255,170,171,254,128,0,191,15,195,255,0,11,240,0,0,253,15,207,255,128,15,208,0,3,253,15,255,223,224,63,192,0,7,253,15,207,71,248,255,0,0,15,253,15,193,1,255,252,0,0,47,253,15,192,0,127,244,0,0,127,253,15,192,1,255,253,0,0,255,253,15,192,31,255,255,208,0,254,189,15,203,255,244,127,255,144,124,189,15,223,255,64,7,255,208,48,189,15,203,228,15,192,111,128,0,189,15,193,0,15,192,1,0,0,189,15,192,0,15,192,0,0,0,189,15,207,255,255,255,255,192,0,189,15,207,255,255,255,255,192,0,189,15,207,255,255,255,255,192,0,189,15,192,0,191,248,0,0,0,189,15,192,1,255,253,0,0,0,189,15,192,7,255,255,0,0,0,189,15,192,31,239,239,192,0,0,189,15,128,127,143,203,240,0,0,189,0,2,255,15,195,253,0,0,189,0,31,252,15,192,255,128,0,189,0,191,224,15,192,63,240,0,189,0,63,64,15,192,15,192,0,189,0,8,0,15,192,2,0,0,189,0,0,0,15,192,0,0,0,0,0,0,0,0,0,0,0,
  // 0x68c4  棄
  196,104,32,34,16,36,2,253,0,0,0,11,224,0,0,0,0,0,0,11,224,0,0,0,0,0,0,11,224,0,0,0,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,106,170,191,234,170,255,170,170,0,0,127,64,0,255,128,0,0,0,254,0,0,31,248,0,31,255,255,255,255,255,255,128,31,255,255,255,255,255,255,244,31,255,255,170,170,85,87,244,0,0,0,6,144,0,0,144,0,47,128,11,208,2,248,0,0,47,128,11,208,2,248,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,106,191,234,175,250,171,254,169,0,47,128,11,208,2,248,0,0,47,128,11,208,2,248,0,0,47,255,255,255,255,248,0,0,47,255,255,255,255,248,0,0,5,85,95,245,85,84,0,0,0,0,15,224,0,0,0,170,170,170,175,250,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,11,255,255,224,0,0,0,0,127,223,231,253,0,0,0,7,255,15,225,255,208,0,0,191,248,15,224,47,254,64,111,255,128,15,224,2,255,249,255,248,0,15,224,0,47,255,127,128,0,15,224,0,2,253,20,0,0,11,224,0,0,4,
  // 0x69fd  槽
  253,105,34,35,59,36,1,252,0,47,64,0,11,208,252,0,0,0,47,64,0,11,208,252,0,0,0,47,64,0,11,208,252,0,0,0,47,64,255,255,255,255,255,224,0,47,64,255,255,255,255,255,224,0,47,64,170,175,250,254,170,144,0,47,64,0,11,208,252,0,0,0,47,128,5,91,229,253,85,0,63,255,255,47,255,255,255,255,64,63,255,255,47,255,255,255,255,64,63,255,255,47,3,208,248,31,64,0,63,64,47,3,208,248,31,64,0,63,64,47,255,255,255,255,64,0,127,128,47,255,255,255,255,64,0,191,192,47,7,208,248,31,64,0,255,240,47,3,208,248,31,64,1,255,244,47,3,208,248,31,64,2,255,252,47,255,255,255,255,64,3,255,190,47,255,255,255,255,64,7,239,111,69,85,85,85,85,0,15,239,79,0,0,0,0,0,0,31,111,73,7,255,255,255,252,0,63,47,64,7,255,255,255,252,0,126,47,64,7,250,170,170,252,0,188,47,64,7,240,0,0,252,0,56,47,64,7,245,85,85,252,0,32,47,64,7,255,255,255,252,0,0,47,64,7,255,255,255,252,0,0,47,64,7,240,0,0,252,0,0,47,64,7,240,0,0,252,0,0,47,64,7,250,170,170,252,0,0,47,64,7,255,255,255,252,0,0,47,64,7,255,255,255,252,0,0,47,64,7,240,0,0,252,0,0,0,0,0,0,0,0,0,0,
  // 0x6a59  橙
  89,106,34,34,50,36,1,253,0,31,192,0,0,0,80,0,0,0,31,192,26,170,130,240,32,0,0,31,192,47,255,241,244,244,0,0,31,192,47,255,224,255,252,0,0,31,192,0,15,192,255,224,0,0,31,192,4,15,192,191,66,0,0,31,192,62,47,128,63,11,192,0,31,192,127,255,0,47,175,192,63,255,255,159,254,0,31,254,0,63,255,255,131,253,0,15,244,0,63,255,255,131,255,255,255,252,0,0,47,192,15,239,255,254,255,0,0,63,192,47,202,170,168,191,208,0,63,192,255,0,0,0,47,240,0,191,226,253,0,0,0,11,192,0,255,244,179,255,255,255,249,64,0,255,252,3,255,255,255,248,0,2,255,255,3,245,85,87,248,0,3,255,223,131,240,0,2,248,0,7,239,207,195,240,0,2,248,0,15,223,199,67,240,0,2,248,0,15,159,194,3,250,170,171,248,0,63,31,192,3,255,255,255,248,0,127,31,192,3,255,255,255,248,0,189,31,192,0,8,0,14,64,0,60,31,192,0,189,0,31,192,0,36,31,192,0,127,0,47,128,0,0,31,192,0,63,0,63,0,0,0,31,192,0,47,64,126,0,0,0,31,192,0,30,0,124,0,0,0,31,192,255,255,255,255,255,224,0,31,192,255,255,255,255,255,224,0,31,192,255,255,255,255,255,208,0,31,192,0,0,0,0,0,0,
  // 0x6a5f  機
  95,106,34,34,50,36,1,253,0,63,0,1,0,189,1,0,0,0,63,0,7,208,189,3,224,0,0,63,0,15,192,189,11,192,0,0,63,0,15,128,189,15,128,0,0,63,0,47,8,189,31,8,0,0,63,0,253,47,189,254,31,64,0,63,3,252,62,127,252,63,0,0,63,0,253,188,126,254,188,0,63,255,254,63,244,125,63,248,0,63,255,254,15,240,126,15,240,0,63,255,254,11,208,126,7,210,0,0,127,0,15,173,62,15,143,64,0,127,0,47,31,62,63,11,192,0,191,128,125,31,63,255,255,208,0,255,210,255,255,127,255,255,224,1,255,242,255,255,191,87,65,224,2,255,249,149,7,127,11,208,64,3,255,188,0,0,47,7,244,0,3,255,62,0,0,47,64,252,0,11,255,47,255,255,255,255,255,208,15,191,14,255,255,255,255,255,208,31,63,1,175,234,175,234,170,128,63,63,0,15,192,15,192,228,0,125,63,0,31,192,11,193,252,0,188,63,0,31,244,7,211,244,0,56,63,0,47,254,3,251,240,0,32,63,0,63,191,195,255,192,0,0,63,0,127,31,194,255,0,0,0,63,0,254,3,2,253,1,208,0,63,1,252,0,31,254,2,240,0,63,7,248,1,191,255,131,224,0,63,15,240,31,254,31,255,208,0,63,11,192,15,240,11,255,192,0,63,2,0,6,0,1,190,0,
  // 0x6aa2  檢
  162,106,34,35,59,36,1,252,0,31,128,0,0,63,64,0,0,0,31,128,0,0,255,192,0,0,0,31,128,0,2,255,240,0,0,0,31,128,0,7,251,252,0,0,0,31,128,0,31,241,255,0,0,0,31,128,0,127,192,191,192,0,0,31,128,1,255,64,47,240,0,0,31,192,7,253,0,11,253,0,63,255,255,175,244,0,2,255,128,63,255,255,255,255,255,255,255,240,63,255,255,255,63,255,255,95,192,0,63,128,56,42,170,170,67,128,0,63,128,16,0,0,0,0,0,0,127,192,5,85,80,85,85,0,0,191,224,31,255,241,255,255,64,0,255,244,31,255,241,255,255,64,0,255,252,31,2,241,240,31,64,2,255,254,31,2,241,240,31,64,3,255,175,95,2,241,240,31,64,7,239,143,223,2,241,240,31,64,11,223,139,95,255,241,255,255,64,15,159,130,31,255,241,255,255,64,47,31,128,5,85,80,85,85,0,127,31,128,0,121,0,15,128,0,189,31,128,0,253,0,15,192,0,60,31,128,0,252,0,31,128,0,32,31,128,2,252,0,63,64,0,0,31,128,3,254,0,63,192,0,0,31,128,11,255,128,255,244,0,0,31,128,31,239,226,255,254,0,0,31,128,127,135,235,244,255,128,0,31,130,255,1,191,224,47,224,0,31,129,252,0,31,128,11,208,0,31,128,160,0,9,0,2,64,0,0,0,0,0,0,0,0,0,
  // 0x6b62  止
  98,107,32,32,0,36,2,255,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,255,255,255,244,0,127,0,1,255,255,255,244,0,127,0,1,255,255,255,244,0,127,0,1,253,85,85,80,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,85,191,85,86,253,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x6b63  正
  99,107,32,31,248,36,2,254,5,85,85,85,85,85,85,84,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,106,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,255,255,255,208,0,127,0,3,255,255,255,208,0,127,0,3,255,255,255,208,0,127,0,3,252,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
  // 0x6b65  步
  101,107,32,34,16,36,2,253,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,21,0,11,240,0,0,0,0,63,128,11,240,0,0,0,0,63,128,11,255,255,255,64,0,63,128,11,255,255,255,64,0,63,128,11,255,255,255,64,0,63,128,11,240,0,0,0,0,63,128,11,240,0,0,0,0,63,128,11,240,0,0,0,0,63,128,11,240,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,11,224,0,0,0,0,7,144,11,224,0,0,0,0,15,244,11,224,0,57,0,0,63,224,11,224,0,191,64,0,255,128,11,224,0,255,0,3,255,0,11,224,2,253,0,31,252,0,11,224,3,252,0,191,224,0,11,224,15,244,0,127,128,15,255,224,47,240,0,13,0,11,255,208,191,192,0,0,0,7,254,66,255,64,0,0,0,0,0,15,253,0,0,0,0,0,0,191,244,0,0,0,0,0,7,255,208,0,0,0,0,1,191,255,0,0,0,0,1,111,255,244,0,0,0,2,191,255,255,64,0,0,0,3,255,255,228,0,0,0,0,1,255,249,0,0,0,0,0,0,233,0,0,0,0,0,0,
  // 0x6b78  歸
  120,107,34,34,50,36,1,253,0,15,128,0,0,0,0,0,0,0,31,192,0,63,255,255,248,0,0,47,64,0,63,255,255,248,0,15,255,255,240,21,85,86,248,0,15,255,255,240,0,0,1,248,0,15,213,87,241,85,85,86,249,64,15,192,3,247,255,255,255,255,224,15,192,3,247,255,255,255,255,224,15,255,255,240,0,0,1,248,0,15,255,255,240,0,0,1,248,0,15,213,85,80,63,255,255,248,0,15,192,0,0,63,255,255,248,0,15,255,255,240,21,85,85,80,0,15,255,255,241,170,170,170,170,64,15,213,87,242,255,255,255,255,192,15,192,3,242,255,255,255,255,192,15,192,3,242,240,11,208,15,192,15,255,255,242,240,11,208,15,192,15,255,255,242,240,11,208,15,192,5,91,229,80,0,11,208,0,0,0,3,224,0,191,255,255,254,0,15,67,224,0,191,255,255,254,0,15,131,250,160,191,175,250,254,0,15,131,255,240,189,11,208,126,0,15,131,255,240,189,11,208,126,0,15,131,224,0,189,11,208,126,0,15,131,224,0,189,11,208,126,0,15,131,224,4,189,11,208,126,0,15,135,255,252,189,11,213,190,0,31,255,255,252,189,11,215,253,0,191,255,255,228,189,11,211,248,0,127,254,144,0,0,11,208,0,0,41,0,0,0,0,11,208,0,0,0,0,0,0,0,11,208,0,0,
  // 0x6bbc  殼
  188,107,33,35,59,36,2,252,0,11,208,0,0,0,0,0,0,0,11,224,0,7,255,255,128,0,0,11,224,0,11,255,255,128,0,255,255,255,255,11,255,255,128,0,255,255,255,255,11,208,31,128,0,85,95,245,85,11,208,31,128,0,0,11,224,0,11,208,31,128,0,21,95,229,84,11,208,31,128,0,63,255,255,252,11,208,31,135,64,63,255,255,252,15,192,31,135,192,0,0,0,0,31,192,31,135,192,0,0,0,0,63,128,31,239,192,255,255,255,254,191,0,15,255,128,255,255,255,255,254,0,7,254,0,253,85,85,126,188,0,0,0,0,248,0,0,62,16,0,0,0,0,251,255,255,190,63,255,255,248,0,3,255,255,128,63,255,255,252,0,1,85,85,64,63,255,255,248,0,0,0,0,0,6,192,3,240,0,2,170,170,128,15,208,11,240,0,3,255,255,192,7,240,15,208,0,3,255,255,192,3,244,47,192,0,3,240,15,192,1,252,127,64,0,7,240,15,192,0,254,255,0,0,7,224,15,192,0,127,252,0,0,7,224,15,193,0,47,244,0,0,11,208,15,255,64,127,248,0,0,15,192,111,255,66,255,255,0,0,47,192,191,249,31,254,255,208,0,127,64,63,130,255,240,63,254,0,255,0,16,15,255,128,11,255,64,60,0,0,7,248,0,1,254,0,0,0,0,3,128,0,0,28,0,0,0,0,0,0,0,0,0,0,
  // 0x6bd4  比
  212,107,34,34,50,36,1,253,0,42,64,0,6,160,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,40,0,0,63,128,0,7,240,1,254,0,0,63,128,0,7,240,11,255,64,0,63,255,255,7,240,191,253,0,0,63,255,255,7,251,255,224,0,0,63,255,255,7,255,254,0,0,0,63,149,85,7,255,208,0,0,0,63,128,0,7,253,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,7,128,0,63,128,0,7,240,0,7,240,0,63,128,6,199,240,0,7,224,0,63,150,255,199,240,0,11,224,0,63,255,255,215,240,0,15,208,43,255,255,255,135,244,0,31,208,127,255,255,144,3,255,255,255,192,63,255,144,0,2,255,255,255,128,46,64,0,0,0,191,255,254,0,0,0,0,0,0,0,0,0,0,
  // 0x6c92  沒
  146,108,33,34,50,36,1,253,0,144,0,0,190,0,0,0,0,3,253,0,0,254,0,0,0,0,7,255,128,0,253,0,0,0,0,0,191,244,0,255,255,255,253,0,0,15,244,1,255,255,255,253,0,0,2,224,2,255,255,255,253,0,0,0,64,3,248,0,0,252,0,0,0,0,7,240,0,0,252,0,0,0,0,11,240,0,1,252,0,0,0,0,15,224,0,1,252,0,8,0,0,47,192,0,2,252,0,47,128,0,63,128,0,3,248,0,127,244,0,255,0,0,7,244,0,47,255,3,254,0,31,255,240,0,2,255,139,252,0,15,255,224,0,0,47,2,240,0,11,255,128,0,0,4,0,64,0,0,0,0,0,0,0,0,255,255,255,255,248,0,0,0,0,255,255,255,255,252,0,0,0,0,255,255,255,255,252,0,0,2,208,2,240,0,7,244,0,0,3,244,3,248,0,15,240,0,0,11,240,1,253,0,63,208,0,0,15,224,0,255,64,191,128,0,0,47,192,0,63,210,255,0,0,0,63,128,0,31,255,252,0,0,0,191,0,0,7,255,240,0,0,0,254,0,0,3,255,224,0,0,3,252,0,0,111,255,253,0,0,7,248,0,7,255,255,255,208,0,15,240,6,255,255,129,255,255,128,15,224,15,255,248,0,47,255,192,2,192,7,254,64,0,1,255,64,0,0,2,144,0,0,0,10,0,
  // 0x6d88  消
  136,109,32,35,24,36,2,252,1,0,0,0,2,252,0,0,15,208,0,96,2,252,0,164,47,248,3,244,2,252,0,254,11,255,66,252,2,252,2,252,0,255,192,254,2,252,3,248,0,47,64,191,2,252,11,240,0,6,0,63,130,252,15,208,0,0,0,47,194,252,47,192,0,0,0,13,2,252,6,0,0,0,0,0,2,252,0,0,120,0,1,255,255,255,255,244,255,128,1,255,255,255,255,244,255,240,1,255,255,255,255,244,31,253,1,252,0,0,3,244,3,253,1,252,0,0,3,244,0,184,1,252,0,0,3,244,0,32,1,252,0,0,3,244,0,0,1,255,255,255,255,244,0,0,1,255,255,255,255,244,0,0,1,255,255,255,255,244,0,14,1,252,0,0,3,244,0,31,193,252,0,0,3,244,0,63,129,252,0,0,3,244,0,127,1,255,255,255,255,244,0,255,1,255,255,255,255,244,1,253,1,255,255,255,255,244,3,252,1,252,0,0,3,244,7,244,1,252,0,0,3,244,15,240,1,252,0,0,3,244,31,224,1,252,0,0,3,244,63,192,1,252,0,0,3,244,127,128,1,252,0,11,255,240,31,0,1,252,0,7,255,240,1,0,1,252,0,3,255,128,0,0,0,0,0,0,0,0,
  // 0x6de1  淡
  225,109,34,34,50,36,1,253,0,0,0,0,0,253,0,0,0,2,224,0,0,0,253,0,0,0,7,254,0,9,64,253,0,160,0,2,255,208,31,128,253,0,254,0,0,127,244,63,64,252,2,252,0,0,11,240,63,0,252,3,244,0,0,1,192,254,1,252,11,240,0,0,0,1,252,2,248,31,192,0,0,0,2,248,3,253,47,64,0,0,0,0,16,7,255,129,0,0,8,0,0,0,15,255,248,0,0,47,128,0,0,63,219,255,64,0,127,244,0,2,255,64,255,240,0,31,255,0,111,254,0,31,254,0,1,255,67,255,244,0,2,255,64,0,46,2,255,128,253,0,126,0,0,4,0,228,0,252,0,8,0,0,0,0,0,0,252,0,0,0,0,0,0,47,64,252,0,190,0,0,3,0,63,65,252,0,255,0,0,11,192,127,1,252,2,253,0,0,15,224,190,2,254,3,248,0,0,47,192,252,3,255,11,240,0,0,63,131,252,3,255,95,208,0,0,191,7,240,11,255,223,128,0,0,254,0,96,15,239,224,0,0,2,253,0,0,63,199,248,0,0,7,252,0,1,255,131,254,0,0,15,240,0,27,254,0,255,208,0,31,224,2,255,248,0,63,254,64,31,192,47,255,208,0,11,255,208,3,128,15,253,0,0,1,255,128,0,0,7,144,0,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x6e05  清
  5,110,34,34,50,36,1,253,0,64,0,0,0,253,0,0,0,3,248,0,0,0,253,0,0,0,11,255,66,255,255,255,255,255,64,1,255,226,255,255,255,255,255,64,0,47,241,85,85,254,85,85,0,0,7,208,0,0,253,0,0,0,0,0,128,21,85,254,85,84,0,0,0,0,191,255,255,255,253,0,0,0,0,191,255,255,255,253,0,0,0,0,0,0,253,0,0,0,13,0,0,0,0,253,0,0,0,63,208,11,255,255,255,255,255,224,127,253,11,255,255,255,255,255,224,11,255,133,85,85,85,85,85,64,1,255,0,0,0,0,0,0,0,0,46,0,26,170,170,170,164,0,0,4,0,47,255,255,255,252,0,0,0,0,47,255,255,255,252,0,0,0,0,47,128,0,1,252,0,0,1,0,47,128,0,1,252,0,0,3,208,47,255,255,255,252,0,0,7,240,47,255,255,255,252,0,0,15,240,47,128,0,1,252,0,0,31,208,47,128,0,1,252,0,0,63,192,47,128,0,1,252,0,0,127,64,47,255,255,255,252,0,0,255,0,47,255,255,255,252,0,1,254,0,47,149,85,86,252,0,3,252,0,47,128,0,1,252,0,7,244,0,47,128,0,1,252,0,15,240,0,47,128,0,1,252,0,31,208,0,47,128,2,255,248,0,3,192,0,47,128,1,255,244,0,0,0,0,47,128,0,255,144,0,
  // 0x6e2c  測
  44,110,32,35,24,36,1,252,0,0,0,0,0,0,0,47,3,224,0,0,0,0,0,63,15,253,15,255,255,192,0,63,7,255,143,255,255,192,0,63,0,127,207,255,255,194,240,63,0,15,79,192,15,195,240,63,0,1,15,192,15,195,240,63,0,0,15,192,15,195,240,63,0,0,15,255,255,195,240,63,0,0,15,255,255,195,240,63,8,0,15,255,255,195,240,63,47,128,15,192,15,195,240,63,127,248,15,192,15,195,240,63,31,255,15,192,15,195,240,63,1,253,15,192,15,195,240,63,0,56,15,234,175,195,240,63,0,0,15,255,255,195,240,63,0,0,15,255,255,195,240,63,0,0,15,192,15,195,240,63,0,0,15,192,15,195,240,63,0,24,15,192,15,195,240,63,0,47,15,192,15,195,240,63,0,63,79,255,255,195,240,63,0,127,15,255,255,195,240,63,0,254,15,255,255,194,240,63,0,253,0,0,4,0,0,63,2,252,3,244,63,0,0,63,3,248,7,240,63,128,0,63,7,240,15,208,31,192,0,63,15,224,47,192,15,240,0,63,31,208,127,64,3,248,0,63,63,193,254,0,1,244,255,255,11,66,252,0,0,128,127,254,0,0,112,0,0,0,63,228,0,0,0,0,0,0,0,0,
  // 0x6e90  源
  144,110,34,34,50,36,1,253,0,64,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,11,255,3,255,255,255,255,255,192,2,255,211,255,255,255,255,255,192,0,63,227,255,255,255,255,255,192,0,11,195,244,0,15,240,0,0,0,1,3,244,0,15,224,0,0,0,0,3,244,0,15,192,0,0,0,0,3,244,85,111,213,85,0,0,0,3,244,255,255,255,255,0,13,0,3,244,255,255,255,255,0,63,208,3,244,252,0,0,63,0,127,248,3,244,252,0,0,63,0,11,255,3,244,253,85,85,127,0,1,254,3,244,255,255,255,255,0,0,44,3,240,255,255,255,255,0,0,0,3,240,252,0,0,63,0,0,0,3,240,252,0,0,63,0,0,0,3,240,252,0,0,63,0,0,0,7,240,255,255,255,255,0,0,13,7,240,255,255,255,255,0,0,31,139,224,85,95,229,85,0,0,63,139,224,0,15,208,0,0,0,127,15,208,36,15,208,116,0,0,191,15,192,191,15,210,252,0,0,253,31,192,253,15,208,254,0,2,252,47,129,252,15,208,127,64,3,248,63,67,244,15,208,63,192,7,240,127,11,240,15,208,31,208,15,240,254,31,208,15,208,15,224,31,209,253,47,128,15,208,7,208,63,195,252,2,11,255,192,0,0,11,65,244,0,7,255,192,0,0,0,0,16,0,3,249,0,0,0,
  // 0x6e96  準
  150,110,33,34,50,36,1,253,0,96,0,7,144,11,144,0,0,0,254,0,15,240,15,224,0,0,2,255,224,31,208,31,192,0,0,0,47,240,63,192,63,128,0,0,0,3,208,255,255,255,255,254,0,0,0,66,255,255,255,255,254,0,9,0,7,255,170,255,170,169,0,63,208,31,254,0,127,0,0,0,127,253,127,254,0,127,0,0,0,7,253,255,255,255,255,255,244,0,0,120,62,191,255,255,255,244,0,0,0,4,191,85,191,85,80,0,0,0,128,190,0,127,0,0,0,0,2,224,190,85,191,85,80,0,0,11,240,191,255,255,255,248,0,0,47,208,191,255,255,255,248,0,0,127,128,190,0,127,0,0,0,1,254,0,190,0,127,0,0,0,11,252,0,191,170,255,170,170,64,31,240,0,191,255,255,255,255,128,11,192,0,191,255,255,255,255,128,3,64,0,2,244,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x6eab  溫
  171,110,34,34,50,36,1,253,0,128,0,0,0,0,0,0,0,3,248,0,42,170,170,170,160,0,7,255,128,127,255,255,255,240,0,1,255,240,127,255,255,255,240,0,0,31,224,126,0,80,7,240,0,0,3,192,126,0,244,7,240,0,0,0,0,126,0,240,7,240,0,0,0,0,126,2,240,7,240,0,0,0,0,126,3,252,7,240,0,0,0,0,126,15,255,71,240,0,14,0,0,126,63,11,215,240,0,63,224,0,126,189,3,247,240,0,127,253,0,126,32,0,135,240,0,11,255,0,127,170,170,171,240,0,0,254,0,127,255,255,255,240,0,0,28,0,127,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,252,0,0,6,2,255,255,255,255,252,0,0,15,194,255,255,255,255,252,0,0,31,210,244,62,7,192,252,0,0,47,194,244,62,7,192,252,0,0,63,66,244,62,7,192,252,0,0,191,2,244,62,7,192,252,0,0,254,2,244,62,7,192,252,0,2,252,2,244,62,7,192,252,0,3,248,2,244,62,7,192,252,0,11,240,2,244,62,7,192,252,0,31,224,191,255,255,255,255,255,224,47,192,191,255,255,255,255,255,224,7,128,191,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x6fc0  激
  192,111,34,35,59,36,1,252,1,0,0,15,144,1,228,0,0,3,224,0,31,192,1,252,0,0,15,253,0,47,192,2,248,0,0,3,255,133,127,149,66,244,0,0,0,127,223,255,255,195,244,0,0,0,15,15,255,255,195,240,0,0,0,1,15,64,15,195,240,0,0,0,0,15,64,15,199,255,255,224,0,0,15,149,95,203,255,255,224,0,0,15,255,255,207,255,255,224,13,0,15,255,255,223,192,63,0,63,208,15,64,15,239,192,126,0,127,248,15,64,15,255,208,126,0,15,254,15,149,95,255,208,189,0,1,253,15,255,255,255,224,189,0,0,56,15,255,255,255,240,252,0,0,0,0,31,192,186,240,252,0,0,0,0,31,192,33,244,252,0,0,0,106,191,234,160,249,248,0,0,0,191,255,255,240,254,244,0,0,24,191,255,255,240,191,240,0,0,47,0,252,0,0,127,240,0,0,63,64,252,0,0,63,208,0,0,127,0,254,170,128,47,192,0,0,254,0,255,255,128,47,192,0,0,252,1,255,255,128,63,192,0,2,252,2,244,31,128,191,240,0,3,248,3,240,31,129,255,244,0,7,240,7,240,31,131,253,252,0,15,240,15,208,47,79,240,255,0,31,208,63,192,63,127,208,63,192,63,192,255,15,255,255,128,31,224,11,130,253,15,254,189,0,7,192,0,0,112,6,148,36,0,1,0,0,0,0,0,0,0,0,0,0,
  // 0x7121  無
  33,113,33,34,50,36,2,253,0,7,144,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,255,255,255,255,255,255,248,0,2,255,255,255,255,255,255,248,0,11,255,255,255,255,255,255,248,0,31,255,2,240,31,64,252,0,0,191,255,2,240,31,64,252,0,0,255,127,2,240,31,64,252,0,0,61,63,2,240,31,64,252,0,0,4,63,2,240,31,64,252,0,0,0,63,2,240,31,64,252,0,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,63,2,240,31,64,252,0,0,0,63,2,240,31,64,252,0,0,0,63,2,240,31,64,252,0,0,0,63,2,240,31,64,252,0,0,0,63,2,240,31,64,252,0,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,144,0,0,0,0,6,0,0,2,252,6,208,27,192,63,128,0,3,248,11,224,15,192,47,208,0,7,240,7,240,15,224,15,240,0,15,240,7,240,11,240,7,252,0,47,208,3,240,3,240,2,253,0,127,128,3,240,3,244,0,255,0,255,0,3,240,2,248,0,191,64,29,0,1,64,1,64,0,52,0,
  // 0x71b1  熱
  177,113,33,34,50,36,2,253,0,6,144,0,0,252,0,0,0,0,7,224,0,0,252,0,0,0,5,91,229,80,0,252,0,0,0,31,255,255,248,0,252,0,0,0,31,255,255,248,0,252,0,0,0,0,7,224,0,127,255,255,192,0,0,7,224,0,127,255,255,192,0,191,255,255,255,127,255,255,192,0,191,255,255,255,0,252,15,192,0,85,253,127,85,0,252,15,192,0,0,244,62,4,0,252,15,192,0,3,240,62,15,57,248,15,192,0,31,224,47,255,191,248,15,192,0,255,128,31,253,191,244,15,192,0,125,7,224,0,31,253,15,192,0,0,7,224,0,3,255,79,192,0,21,91,245,84,3,255,239,192,0,63,255,255,252,11,239,223,195,128,63,255,255,252,15,211,207,195,192,0,7,224,0,31,192,15,195,192,0,7,224,0,63,64,15,195,192,0,7,250,190,191,0,15,199,192,175,255,255,255,253,0,15,255,128,255,255,255,251,248,0,11,255,64,255,233,80,0,240,0,1,169,0,0,0,0,0,64,0,0,0,0,0,144,0,0,1,0,11,0,0,2,252,11,208,31,192,63,192,0,3,248,11,224,15,208,31,224,0,11,240,11,240,15,224,11,244,0,31,224,7,240,7,240,3,252,0,63,192,7,240,3,244,1,254,0,255,0,7,240,3,244,0,191,0,29,0,1,0,0,0,0,32,0,
  // 0x71c8  燈
  200,113,34,34,50,36,1,253,0,10,64,0,0,11,128,64,0,0,31,128,26,170,79,193,224,0,0,31,128,47,255,231,215,244,0,0,31,128,47,255,211,255,192,0,0,31,128,0,15,194,255,0,0,0,31,129,8,15,192,252,15,64,0,31,139,255,111,64,190,63,192,9,31,143,239,255,0,63,254,0,15,31,159,75,253,0,31,244,0,15,31,191,3,248,0,15,240,0,31,31,253,11,255,255,255,252,0,31,31,252,47,255,255,254,255,64,31,31,144,191,90,170,168,127,240,47,31,135,253,0,0,0,31,224,62,31,135,244,0,0,0,2,192,124,47,130,135,255,255,255,244,0,120,47,64,7,255,255,255,244,0,0,47,64,7,250,170,171,244,0,0,47,64,7,224,0,3,244,0,0,63,64,7,224,0,3,244,0,0,63,0,7,224,0,3,244,0,0,63,128,7,250,170,171,244,0,0,63,208,7,255,255,255,244,0,0,127,240,7,255,255,255,244,0,0,255,252,0,20,0,25,0,0,0,252,254,0,252,0,47,192,0,2,252,127,64,126,0,63,64,0,3,244,47,192,63,0,127,0,0,11,240,15,64,47,64,189,0,0,15,224,5,0,30,0,188,0,0,63,192,1,255,255,255,255,255,192,127,64,2,255,255,255,255,255,192,46,0,2,255,255,255,255,255,192,8,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,32,35,24,36,1,252,0,0,0,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,213,85,95,245,85,84,0,47,255,255,255,255,255,253,0,47,255,255,255,255,255,253,0,47,255,255,255,255,255,253,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,213,85,85,85,80,0,0,63,255,255,255,255,244,0,0,63,255,255,255,255,244,0,0,127,255,255,255,255,244,0,0,127,0,0,0,7,244,0,0,191,0,0,0,7,244,0,0,255,0,0,0,7,244,0,0,254,0,0,0,7,244,0,2,252,0,0,0,7,244,0,3,252,0,0,0,7,244,0,11,248,0,0,0,7,244,0,15,240,0,0,0,7,244,0,63,224,0,0,0,7,244,0,127,192,0,0,0,7,244,0,31,0,0,0,0,7,244,0,9,0,0,0,0,7,244,0,0,0,0,0,0,0,0,0,
  // 0x7269  物
  105,114,34,34,50,36,1,253,0,3,240,0,14,64,0,0,0,0,3,240,0,31,128,0,0,0,11,131,240,0,47,64,0,0,0,15,195,240,0,63,0,0,0,0,15,195,240,0,63,0,0,0,0,15,195,240,0,190,0,0,0,0,15,131,240,0,255,255,255,255,208,31,255,255,209,255,255,255,255,192,31,255,255,211,255,255,255,255,192,47,255,255,215,240,126,15,207,192,63,7,240,15,224,188,31,143,192,62,3,240,31,192,252,47,79,192,125,3,240,63,129,248,63,15,192,252,3,240,255,2,244,63,15,192,44,3,240,125,3,240,126,31,192,0,3,240,4,11,208,189,31,192,0,3,240,96,15,192,252,31,128,0,3,255,240,47,129,248,31,128,0,47,255,240,127,3,244,47,128,27,255,255,144,253,3,240,47,128,127,255,244,2,252,11,224,47,64,63,251,240,11,244,15,192,63,64,62,3,240,47,224,47,192,63,64,0,3,240,63,192,63,64,63,0,0,3,240,15,0,191,0,63,0,0,3,240,0,1,253,0,127,0,0,3,240,0,3,248,0,127,0,0,3,240,0,15,240,0,190,0,0,3,240,0,47,208,0,253,0,0,3,240,0,191,128,2,252,0,0,3,240,3,255,3,255,252,0,0,3,240,1,252,2,255,244,0,0,3,240,0,32,1,255,208,0,0,3,240,0,0,0,0,0,0,
  // 0x7387  率
  135,115,32,35,24,36,2,252,0,0,0,11,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,0,0,0,63,64,0,0,0,2,0,0,190,0,0,3,208,31,208,1,252,7,64,15,244,31,248,31,240,15,208,63,208,2,255,127,208,63,65,255,0,0,127,95,240,190,3,248,0,0,28,3,254,248,0,80,0,0,0,0,191,241,64,0,0,0,0,64,47,207,193,128,0,0,27,192,127,7,247,248,0,1,255,209,252,3,255,255,64,111,255,255,255,255,252,191,240,255,228,191,255,255,254,15,253,126,0,127,255,165,127,2,254,32,0,0,15,224,30,0,116,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7528  用
  40,117,31,32,0,36,1,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,0,1,252,0,1,252,0,191,0,1,252,0,1,252,0,191,0,1,252,0,1,252,0,191,0,1,252,0,1,252,0,191,0,1,252,0,1,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,0,1,252,0,1,252,0,191,0,1,252,0,1,252,0,190,0,1,252,0,1,252,0,190,0,1,252,0,1,252,0,190,0,1,252,0,1,252,0,190,0,1,252,0,1,252,0,191,255,255,255,255,255,252,0,255,255,255,255,255,255,252,0,255,255,255,255,255,255,252,0,252,0,1,252,0,1,252,1,252,0,1,252,0,1,252,2,252,0,1,252,0,1,252,3,248,0,1,252,0,1,252,3,244,0,1,252,0,1,252,11,240,0,1,252,0,1,252,15,224,0,1,252,0,1,252,47,192,0,1,252,0,2,252,127,192,0,1,252,31,255,252,127,0,0,1,252,15,255,244,13,0,0,1,248,11,255,144,0,0,0,0,0,0,0,0,
  // 0x754c  界
  76,117,32,34,16,36,2,252,1,170,170,170,170,170,170,64,1,255,255,255,255,255,255,128,1,255,255,255,255,255,255,128,1,252,0,11,224,0,63,128,1,252,0,11,224,0,63,128,1,252,0,11,224,0,63,128,1,254,170,175,250,170,191,128,1,255,255,255,255,255,255,128,1,255,255,255,255,255,255,128,1,252,0,11,224,0,63,128,1,252,0,11,224,0,63,128,1,252,0,11,224,0,63,128,1,254,170,175,250,170,191,128,1,255,255,255,255,255,255,128,1,255,255,255,255,255,255,128,0,0,31,240,11,248,0,0,0,0,191,192,2,254,0,0,0,2,255,0,0,255,192,0,0,31,252,0,0,63,248,0,1,255,240,0,0,11,255,128,31,255,191,64,0,255,255,249,255,253,63,64,0,254,47,255,127,208,63,64,0,254,7,253,45,0,63,64,0,254,0,40,0,0,127,0,0,254,0,0,0,0,191,0,0,254,0,0,0,0,255,0,0,254,0,0,0,3,253,0,0,254,0,0,0,15,252,0,0,254,0,0,0,191,240,0,0,254,0,0,7,255,192,0,0,254,0,0,2,254,0,0,0,254,0,0,0,244,0,0,0,254,0,0,0,0,0,0,0,0,0,0,
  // 0x767d  白
  125,118,26,34,238,36,5,253,0,0,11,228,0,0,0,0,0,15,244,0,0,0,0,0,15,240,0,0,0,0,0,31,224,0,0,0,0,0,63,192,0,0,0,85,85,127,213,85,85,80,255,255,255,255,255,255,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,254,85,85,85,85,91,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,254,85,85,85,85,91,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,
  // 0x7684  的
  132,118,31,34,16,36,3,253,0,46,64,0,14,64,0,0,0,63,128,0,15,208,0,0,0,63,64,0,31,192,0,0,0,127,0,0,47,128,0,0,0,190,0,0,63,64,0,0,0,253,0,0,127,0,0,0,255,255,255,192,191,255,255,244,255,255,255,192,255,255,255,244,255,255,255,194,255,255,255,244,252,0,15,195,248,0,2,244,252,0,15,203,240,0,3,244,252,0,15,207,224,0,3,244,252,0,15,255,192,0,3,244,252,0,15,239,128,0,3,240,252,0,15,199,5,0,3,240,252,0,15,192,63,0,3,240,255,255,255,192,63,192,3,240,255,255,255,192,15,224,3,240,255,255,255,192,11,244,3,240,252,0,15,192,3,252,3,240,252,0,15,192,0,254,3,240,252,0,15,192,0,191,7,240,252,0,15,192,0,63,71,240,252,0,15,192,0,24,7,224,252,0,15,192,0,0,11,224,252,0,15,192,0,0,11,224,252,0,15,192,0,0,15,208,255,255,255,192,0,0,15,208,255,255,255,192,0,0,31,192,255,255,255,192,0,0,63,192,252,0,0,0,7,255,255,128,252,0,0,0,3,255,255,0,252,0,0,0,2,255,248,0,0,0,0,0,0,0,0,0,
  // 0x76e3  監
  227,118,33,33,41,36,2,254,0,0,0,0,0,164,0,0,0,42,170,170,170,0,252,0,0,0,63,255,255,255,1,252,0,0,0,63,255,255,255,2,244,0,0,0,63,1,244,0,3,240,0,0,0,63,1,244,0,7,255,255,254,0,63,255,255,253,11,255,255,255,0,63,255,255,253,15,255,255,255,0,63,0,0,189,47,64,0,0,0,63,0,0,125,127,0,0,0,0,63,0,0,125,254,0,0,0,0,63,0,0,126,252,0,0,0,0,63,255,255,253,56,0,0,0,0,63,255,255,253,0,0,0,0,0,63,1,244,0,0,0,0,0,0,63,1,244,0,3,255,255,252,0,63,171,254,170,67,255,255,252,0,63,255,255,255,67,255,255,252,0,63,255,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,64,0,1,255,255,255,255,255,255,64,0,1,255,255,255,255,255,255,64,0,1,252,3,240,15,192,63,64,0,1,252,3,240,15,192,63,64,0,1,252,3,240,15,192,63,64,0,1,252,3,240,15,192,63,64,0,1,252,3,240,15,192,63,64,0,1,252,3,240,15,192,63,64,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,
  // 0x76f4  直
  244,118,32,34,16,36,2,253,0,0,0,3,248,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,0,0,0,15,240,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,208,0,0,0,0,0,63,255,255,255,255,0,15,208,63,255,255,255,255,0,15,208,63,85,85,85,191,0,15,208,63,0,0,0,127,0,15,208,63,0,0,0,127,0,15,208,63,255,255,255,255,0,15,208,63,255,255,255,255,0,15,208,63,85,85,85,191,0,15,208,63,0,0,0,127,0,15,208,63,0,0,0,127,0,15,208,63,255,255,255,255,0,15,208,63,255,255,255,255,0,15,208,63,85,85,85,191,0,15,208,63,0,0,0,127,0,15,208,63,0,0,0,127,0,15,208,63,255,255,255,255,0,15,208,63,255,255,255,255,0,15,208,21,85,85,85,85,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,
  // 0x7720  眠
  32,119,33,32,32,36,2,253,127,255,252,15,255,255,255,253,0,127,255,252,15,255,255,255,253,0,127,255,252,15,255,255,255,253,0,126,0,252,15,192,0,0,253,0,126,0,252,15,192,0,0,253,0,126,0,252,15,192,0,0,253,0,126,0,252,15,192,0,0,253,0,127,255,252,15,255,255,255,253,0,127,255,252,15,255,255,255,253,0,127,255,252,15,255,255,255,253,0,126,0,252,15,192,15,192,0,0,126,0,252,15,192,15,192,0,0,126,0,252,15,192,15,208,0,0,126,0,252,15,192,15,208,0,0,126,0,252,15,192,11,208,0,0,127,255,252,15,255,255,255,255,64,127,255,252,15,255,255,255,255,64,127,255,252,15,255,255,255,255,64,126,0,252,15,208,7,240,0,0,126,0,252,15,192,3,240,0,0,126,0,252,15,192,3,240,0,0,126,0,252,15,192,3,244,0,0,127,0,252,15,192,2,248,0,0,127,255,252,15,192,1,252,0,0,127,255,252,15,192,0,252,7,64,127,255,252,15,192,0,253,7,192,126,0,0,15,192,105,190,11,192,126,0,0,15,255,254,63,11,192,126,0,2,255,255,254,47,223,192,0,0,3,255,255,228,15,255,128,0,0,3,255,164,0,7,255,0,0,0,1,144,0,0,1,252,0,
  // 0x780d  砍
  13,120,34,35,59,36,1,252,0,0,0,0,31,128,0,0,0,0,0,0,0,47,192,0,0,0,63,255,255,252,63,128,0,0,0,63,255,255,252,63,128,0,0,0,63,255,255,252,63,64,0,0,0,0,63,0,0,127,0,0,0,0,0,127,0,0,191,0,0,0,0,0,126,0,0,255,255,255,255,208,0,189,0,0,255,255,255,255,208,0,253,0,1,255,255,255,255,192,0,252,0,2,252,47,128,47,192,0,252,0,3,248,47,128,63,128,1,248,0,7,240,47,128,63,64,3,255,255,223,240,47,128,63,0,3,255,255,255,208,47,128,190,0,7,255,255,255,192,47,128,253,0,15,244,11,215,64,47,128,252,0,15,244,11,208,0,63,128,4,0,47,244,11,208,0,63,192,0,0,63,244,11,208,0,63,192,0,0,255,244,11,208,0,127,208,0,0,191,244,11,208,0,255,224,0,0,62,244,11,208,0,251,240,0,0,22,244,11,208,2,246,248,0,0,2,244,11,208,3,240,252,0,0,2,244,11,208,11,224,190,0,0,2,255,255,208,31,192,63,64,0,2,255,255,208,63,128,47,192,0,2,255,255,209,255,0,15,240,0,2,244,0,7,253,0,7,253,0,2,244,0,47,244,0,2,255,128,2,244,0,255,208,0,0,191,224,0,0,0,63,64,0,0,31,192,0,0,0,24,0,0,0,3,64,0,0,0,0,0,0,0,0,0,
  // 0x78ba  確
  186,120,34,35,59,36,1,252,0,0,0,0,0,14,64,0,0,0,0,0,0,0,31,192,0,0,63,255,255,224,0,47,128,0,0,63,255,255,224,0,63,64,0,0,63,255,255,255,255,255,255,255,208,0,127,0,31,255,255,255,255,208,0,126,0,31,255,255,255,255,208,0,190,0,31,66,252,0,11,208,0,253,0,31,71,244,30,75,208,0,252,0,31,79,240,47,75,208,0,252,0,5,47,208,63,1,64,1,252,0,0,63,192,190,0,0,2,248,0,0,255,255,255,255,64,3,255,255,195,255,255,255,255,64,3,255,255,207,255,255,255,255,64,7,255,255,255,253,1,248,0,0,15,240,15,255,253,1,248,0,0,15,240,15,206,253,1,248,0,0,47,240,15,192,255,255,255,255,0,63,240,15,192,255,255,255,255,0,191,240,15,192,254,170,254,169,0,255,240,15,192,253,1,248,0,0,190,240,15,192,253,1,248,0,0,58,240,15,192,254,170,254,169,0,18,240,15,192,255,255,255,255,0,2,240,15,192,255,255,255,255,0,2,240,15,192,253,1,248,0,0,2,255,255,192,253,1,248,0,0,2,255,255,192,253,1,248,0,0,2,255,255,192,253,1,248,0,0,2,240,0,0,255,255,255,255,224,2,240,0,0,255,255,255,255,224,1,160,0,0,255,255,255,255,208,0,0,0,0,253,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x79fb  移
  251,121,34,34,50,36,1,253,0,0,1,0,0,46,64,0,0,0,0,111,128,0,63,64,0,0,0,111,255,208,0,255,0,0,0,47,255,255,144,3,255,255,248,0,63,255,244,0,15,255,255,254,0,46,159,224,0,63,255,255,252,0,0,11,224,1,255,64,3,248,0,0,11,224,31,255,128,11,240,0,0,11,224,63,255,240,47,208,0,0,11,224,15,67,253,191,128,0,63,255,255,240,0,255,254,0,0,63,255,255,240,0,63,252,0,0,63,255,255,240,0,191,224,0,0,0,31,224,0,11,255,128,0,0,0,47,224,1,191,255,248,0,0,0,63,240,15,255,219,240,0,0,0,127,252,11,254,31,224,0,0,0,255,255,3,144,63,255,255,64,1,255,255,192,0,255,255,255,208,3,251,235,240,7,255,255,255,192,7,235,227,240,31,240,0,63,128,15,203,225,208,255,208,0,191,0,47,139,224,75,255,244,1,254,0,127,11,224,15,251,254,3,252,0,190,11,224,3,192,255,207,244,0,60,11,224,0,0,47,255,208,0,36,11,224,0,0,7,255,128,0,0,11,224,0,0,11,254,0,0,0,11,224,0,0,191,244,0,0,0,11,224,0,27,255,192,0,0,0,11,224,6,255,254,0,0,0,0,11,224,63,255,224,0,0,0,0,11,224,31,253,0,0,0,0,0,11,224,14,64,0,0,0,0,
  // 0x7a4d  積
  77,122,34,35,59,36,1,252,0,0,0,0,0,47,128,0,0,0,0,111,64,0,47,192,0,0,1,111,255,207,255,255,255,255,128,63,255,255,143,255,255,255,255,128,63,255,224,0,0,47,192,0,0,26,95,208,0,0,47,192,0,0,0,15,208,3,255,255,255,254,0,0,15,208,3,255,255,255,254,0,0,15,208,0,0,47,192,0,0,0,15,208,0,0,47,192,0,0,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,63,255,255,192,0,0,0,0,0,0,31,208,2,255,255,255,253,0,0,47,208,2,255,255,255,253,0,0,63,240,2,244,0,0,189,0,0,127,252,2,244,0,0,189,0,0,255,254,2,244,0,0,189,0,1,255,255,66,255,255,255,253,0,2,255,239,210,255,255,255,253,0,7,239,219,226,244,0,0,189,0,15,207,211,194,244,0,0,189,0,31,143,209,66,255,255,255,253,0,63,15,208,2,255,255,255,253,0,254,15,208,2,244,0,0,189,0,188,15,208,2,244,0,0,189,0,56,15,208,2,255,255,255,253,0,16,15,208,2,255,255,255,253,0,0,15,208,0,11,64,10,0,0,0,15,208,0,127,224,63,208,0,0,15,208,7,255,128,15,252,0,0,15,208,191,253,0,2,255,128,0,15,208,255,208,0,0,127,208,0,15,208,57,0,0,0,10,0,0,0,0,0,0,0,0,0,0,
  // 0x7aef  端
  239,122,34,34,50,36,1,253,0,26,0,0,0,47,64,0,0,0,63,0,0,0,47,128,0,0,0,63,0,15,192,47,128,63,0,0,63,0,15,192,47,128,63,0,0,63,0,15,192,47,128,63,0,0,63,0,15,192,47,128,63,0,0,63,0,15,192,47,128,63,0,63,255,255,15,192,47,128,63,0,63,255,255,15,255,255,255,255,0,63,255,255,15,255,255,255,255,0,0,0,0,15,255,255,255,255,0,6,0,120,0,0,0,0,0,0,31,0,190,0,0,0,0,0,0,15,64,189,127,255,255,255,255,208,15,128,252,127,255,255,255,255,208,15,128,252,127,255,255,255,255,208,11,192,252,0,0,63,64,0,0,11,192,248,0,0,127,0,0,0,11,193,244,0,0,191,0,0,0,7,209,244,31,255,255,255,255,128,7,210,240,31,255,255,255,255,128,7,211,240,31,255,255,255,255,128,7,211,224,31,131,224,188,31,128,0,3,230,159,131,224,188,31,128,0,7,255,223,131,224,188,31,128,27,255,255,239,131,224,188,31,128,191,255,254,95,131,224,188,31,128,127,254,64,31,131,224,188,31,128,62,64,0,31,131,224,188,31,128,0,0,0,31,131,224,188,31,128,0,0,0,31,131,224,188,31,128,0,0,0,31,131,224,189,191,128,0,0,0,31,131,224,188,255,64,0,0,0,26,64,0,0,254,0,
  // 0x7b49  等
  73,123,34,34,50,36,1,253,0,46,64,0,1,228,0,0,0,0,63,128,0,3,248,0,0,0,0,191,0,0,7,244,0,0,0,0,255,255,255,143,255,255,255,192,2,255,255,255,175,255,255,255,192,7,255,255,255,255,255,255,255,192,15,241,252,0,255,3,248,0,0,63,192,253,3,253,1,252,0,0,127,64,190,2,248,0,254,0,0,30,0,100,3,248,0,116,0,0,0,0,0,3,248,0,0,0,0,0,191,255,255,255,255,255,240,0,0,191,255,255,255,255,255,240,0,0,127,255,255,255,255,255,224,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,0,0,184,0,0,11,240,0,0,0,2,254,0,0,11,240,0,0,0,0,255,192,0,11,240,0,0,0,0,63,240,0,11,240,0,0,0,0,11,252,0,11,240,0,0,0,0,2,252,0,11,240,0,0,0,0,0,224,63,255,224,0,0,0,0,0,0,47,255,208,0,0,0,0,0,0,15,254,0,0,0,
  // 0x7ba1  管
  161,123,34,35,59,36,1,252,0,46,0,0,2,228,0,0,0,0,63,64,0,3,248,0,0,0,0,191,0,0,7,240,0,0,0,0,255,255,255,79,255,255,255,208,3,255,255,255,191,255,255,255,208,11,255,254,171,255,239,254,170,144,47,225,252,3,254,2,252,0,0,127,192,253,3,248,0,254,0,0,31,0,125,2,244,0,126,0,0,0,0,0,2,244,0,0,0,0,10,170,170,171,254,170,170,170,0,15,255,255,255,255,255,255,255,64,15,255,255,255,255,255,255,255,64,15,192,0,0,0,0,0,63,64,15,192,0,0,0,0,0,63,64,15,194,255,255,255,255,252,63,64,15,194,255,255,255,255,252,63,64,5,66,249,85,85,86,252,21,0,0,2,244,0,0,1,252,0,0,0,2,244,0,0,1,252,0,0,0,2,255,255,255,255,252,0,0,0,2,255,255,255,255,252,0,0,0,2,249,85,85,85,84,0,0,0,2,244,0,0,0,0,0,0,0,2,244,0,0,0,0,0,0,0,2,255,255,255,255,255,208,0,0,2,255,255,255,255,255,208,0,0,2,250,170,170,170,175,208,0,0,2,244,0,0,0,15,208,0,0,2,244,0,0,0,15,208,0,0,2,250,170,170,170,175,208,0,0,2,255,255,255,255,255,208,0,0,2,255,255,255,255,255,208,0,0,2,244,0,0,0,15,208,0,0,0,0,0,0,0,0,0,0,
  // 0x7bb1  箱
  177,123,33,35,59,36,1,252,0,47,64,0,1,248,0,0,0,0,63,128,0,3,248,0,0,0,0,127,0,0,7,244,0,0,0,0,255,255,255,75,255,255,255,192,1,255,255,255,159,255,255,255,192,3,255,255,255,191,255,255,255,192,11,241,252,0,191,71,240,0,0,15,224,253,1,255,2,252,0,0,63,192,190,3,252,0,253,0,0,127,64,127,2,248,0,191,0,0,31,0,124,0,112,0,56,0,0,0,2,248,0,0,0,0,0,0,0,2,248,0,63,255,255,255,0,0,2,248,0,63,255,255,255,0,0,2,248,0,63,255,255,255,0,47,255,255,255,63,0,0,127,0,47,255,255,255,63,0,0,127,0,47,255,255,255,63,0,0,127,0,0,11,248,0,63,255,255,255,0,0,15,252,0,63,255,255,255,0,0,47,255,0,63,170,170,255,0,0,63,255,208,63,0,0,127,0,0,191,255,244,63,0,0,127,0,1,255,250,253,63,0,0,127,0,3,246,248,255,63,255,255,255,0,15,242,248,60,63,255,255,255,0,47,194,248,20,63,170,170,255,0,191,130,248,0,63,0,0,127,0,63,2,248,0,63,0,0,127,0,12,2,248,0,63,234,170,255,0,0,2,248,0,63,255,255,255,0,0,2,248,0,63,255,255,255,0,0,2,248,0,63,0,0,127,0,0,2,248,0,42,0,0,21,0,0,0,0,0,0,0,0,0,0,
  // 0x7cfb  系
  251,124,33,34,50,36,2,253,0,0,0,0,0,0,4,0,0,0,0,0,0,0,90,255,0,0,0,5,90,171,255,255,255,192,0,47,255,255,255,255,255,255,208,0,31,255,255,255,255,250,80,0,0,15,255,235,254,64,0,0,0,0,0,0,11,252,0,16,0,0,0,0,0,31,240,0,126,0,0,0,0,0,127,192,1,255,64,0,0,0,160,255,0,7,254,0,0,0,2,255,253,0,31,248,0,0,0,2,255,244,0,127,224,0,0,0,0,127,244,1,255,64,0,0,0,0,11,253,7,253,0,0,0,0,0,1,255,159,244,2,64,0,0,0,0,63,255,192,31,224,0,0,0,0,15,255,0,15,248,0,0,0,0,31,248,0,3,254,0,0,0,0,191,224,0,0,255,192,0,255,255,255,255,255,255,255,224,0,255,255,255,255,255,255,255,248,0,191,255,255,255,255,255,255,254,0,85,84,0,15,245,0,0,255,64,0,0,0,15,224,0,0,125,0,0,2,64,15,224,7,0,16,0,0,11,244,15,224,47,208,0,0,0,47,240,15,224,47,248,0,0,0,191,192,15,224,7,255,0,0,3,255,0,15,224,0,255,208,0,31,252,0,15,224,0,47,244,0,191,240,0,15,224,0,11,254,0,255,192,0,15,224,0,2,254,0,46,0,0,15,224,0,0,180,0,0,0,0,15,224,0,0,0,0,
  // 0x7d05  紅
  5,125,34,35,59,36,1,252,0,6,64,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,127,1,1,255,255,255,255,192,0,253,7,225,255,255,255,255,192,46,248,15,241,255,255,255,255,192,127,240,31,208,0,11,240,0,0,63,224,63,128,0,11,240,0,0,15,244,255,0,0,11,240,0,0,2,254,252,0,0,11,240,0,0,0,255,244,0,0,11,240,0,0,0,63,225,240,0,11,240,0,0,0,47,194,248,0,11,240,0,0,0,191,0,252,0,11,240,0,0,1,253,0,191,0,11,240,0,0,191,255,255,255,64,11,240,0,0,191,255,255,255,192,11,240,0,0,127,255,255,239,208,11,240,0,0,0,3,244,7,208,11,240,0,0,0,3,244,2,0,11,240,0,0,1,3,244,20,0,11,240,0,0,11,227,245,252,0,11,240,0,0,15,211,244,253,0,11,240,0,0,15,195,244,190,0,11,240,0,0,15,195,244,63,0,11,240,0,0,31,131,244,63,64,11,240,0,0,63,67,244,31,128,11,240,0,0,63,3,244,15,192,11,240,0,0,191,3,244,14,0,11,240,0,0,109,3,244,11,255,255,255,255,224,4,3,244,11,255,255,255,255,224,0,3,244,11,255,255,255,255,224,0,3,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7d22  索
  34,125,32,34,16,36,2,253,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,0,1,254,0,0,0,253,127,0,7,252,0,64,0,253,127,0,31,240,1,248,0,253,127,30,127,192,11,253,0,253,0,127,254,0,63,240,0,0,0,47,252,1,255,128,0,0,0,3,255,71,253,9,0,0,0,0,127,255,240,63,192,0,0,0,15,255,128,47,244,0,0,0,31,252,0,7,254,0,106,170,255,250,170,170,255,192,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,253,21,80,64,15,224,0,0,248,0,2,228,15,224,10,0,16,0,15,252,15,224,63,224,0,0,127,224,15,224,31,253,0,7,255,128,15,224,2,255,192,127,253,0,15,224,0,63,244,255,224,0,15,224,0,7,254,63,64,0,15,224,0,0,248,4,0,0,15,224,0,0,0,
  // 0x7d2b  紫
  43,125,33,35,59,36,1,252,0,0,126,0,11,224,0,0,0,0,0,126,0,11,224,0,0,0,1,80,126,0,11,224,1,180,0,3,240,127,170,139,224,111,254,0,3,240,127,255,203,251,255,249,0,3,240,127,255,203,255,255,64,0,3,240,126,0,11,255,144,0,0,3,240,126,0,11,240,0,0,0,3,240,126,0,11,224,0,10,64,3,240,126,1,75,224,0,15,192,3,240,191,255,203,240,0,31,192,27,255,255,255,199,255,255,255,192,127,255,255,254,67,255,255,255,64,127,254,148,47,128,191,255,253,0,37,0,0,191,128,0,0,0,0,0,0,2,253,0,126,0,0,0,0,11,79,244,1,255,64,0,0,0,47,255,192,11,252,0,0,0,0,47,255,64,127,224,16,0,0,0,2,255,246,255,66,248,0,0,0,0,47,255,248,2,255,0,0,0,0,7,255,208,0,127,208,0,0,0,2,255,170,171,255,244,0,63,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,255,64,63,255,255,255,248,0,0,63,192,0,0,80,3,248,0,64,14,0,0,1,253,3,248,7,244,0,0,0,11,252,3,248,11,255,0,0,0,127,240,3,248,1,255,224,0,7,255,128,3,248,0,47,252,0,63,253,0,3,248,0,3,255,64,15,224,0,3,248,0,0,191,0,2,0,0,3,248,0,0,20,0,0,0,0,0,0,0,0,0,0,
  // 0x7d30  細
  48,125,33,34,50,36,1,253,0,13,0,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,126,0,2,255,255,255,255,64,0,252,8,2,255,255,255,255,64,1,248,31,130,255,255,255,255,64,43,240,63,130,244,15,192,47,64,63,208,127,2,244,15,192,47,64,127,192,253,2,244,15,192,47,64,31,226,248,2,244,15,192,47,64,7,251,240,2,244,15,192,47,64,2,255,192,2,244,15,192,47,64,0,255,79,66,244,15,192,47,64,0,126,15,194,244,15,192,47,64,0,252,11,210,244,15,192,47,64,2,249,175,242,244,15,192,47,64,191,255,255,246,255,255,255,255,64,191,255,255,254,255,255,255,255,64,127,239,208,255,255,255,255,255,64,0,15,192,123,244,15,192,47,64,0,15,192,2,244,15,192,47,64,9,15,193,130,244,15,192,47,64,15,207,207,194,244,15,192,47,64,15,143,199,210,244,15,192,47,64,31,79,195,242,244,15,192,47,64,47,79,194,242,244,15,192,47,64,63,15,193,250,244,15,192,47,64,63,15,192,250,244,15,192,47,64,189,15,192,146,255,255,255,255,64,188,15,192,2,255,255,255,255,64,4,15,192,2,255,255,255,255,64,0,15,192,2,244,0,0,47,64,0,15,192,2,244,0,0,47,64,0,11,192,0,80,0,0,0,0,
  // 0x7d42  終
  66,125,34,35,59,36,1,252,0,8,0,0,1,164,0,0,0,0,47,128,0,3,248,0,0,0,0,63,64,0,7,244,0,0,0,0,127,0,0,15,240,0,0,0,0,253,0,0,31,255,255,248,0,1,248,46,0,63,255,255,253,0,23,240,63,64,191,255,255,248,0,63,224,190,2,255,0,3,240,0,127,192,252,7,255,128,15,224,0,31,210,244,31,255,208,47,192,0,7,251,224,191,199,240,127,128,0,2,255,192,63,2,253,254,0,0,0,255,89,8,0,255,252,0,0,0,126,63,0,0,63,240,0,0,0,252,31,64,0,191,244,0,0,2,244,15,192,3,255,254,0,0,107,255,255,192,31,253,255,192,0,191,255,255,225,255,224,63,248,0,191,255,255,255,255,64,11,255,144,16,15,193,255,248,16,1,255,224,0,15,192,71,128,189,0,31,128,9,79,203,64,1,255,208,2,0,15,207,207,128,0,127,248,0,0,31,143,203,192,0,7,255,0,0,31,79,199,208,0,0,190,0,0,47,15,195,224,0,0,8,0,0,63,15,194,240,57,0,0,0,0,63,15,193,240,255,224,0,0,0,125,15,192,65,255,255,64,0,0,252,15,192,0,7,255,248,0,0,44,15,192,0,0,47,255,128,0,0,15,192,0,0,1,255,248,0,0,15,192,0,0,0,31,244,0,0,15,192,0,0,0,1,224,0,0,0,0,0,0,0,0,0,0,
  // 0x7d71  統
  113,125,34,35,59,36,1,252,0,8,0,0,0,47,128,0,0,0,47,128,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,127,0,0,0,63,128,0,0,0,253,0,0,0,63,128,0,0,1,252,46,47,255,255,255,255,192,7,240,63,111,255,255,255,255,192,63,224,190,47,255,255,255,255,192,127,192,252,0,7,244,0,0,0,47,210,244,0,11,240,7,64,0,11,251,240,0,15,224,31,192,0,2,255,192,0,31,192,11,240,0,0,255,72,0,63,128,3,248,0,0,126,63,0,63,85,171,253,0,0,252,31,95,255,255,255,255,0,2,244,15,223,255,255,255,255,128,107,255,255,223,255,234,84,31,192,191,255,255,224,0,0,0,15,192,191,255,255,240,10,128,105,5,0,16,15,193,240,15,192,190,0,0,0,15,192,64,31,192,190,0,0,9,79,199,0,31,192,190,0,0,15,207,207,128,31,192,190,0,0,31,143,207,192,47,128,190,0,0,31,79,199,208,63,64,190,0,0,47,15,195,224,63,64,190,0,0,63,15,195,240,127,0,190,1,0,63,15,194,240,190,0,190,3,208,125,15,192,65,253,0,190,3,240,252,15,192,3,252,0,190,3,240,44,15,192,31,240,0,126,3,224,0,15,192,191,208,0,127,255,208,0,15,192,255,64,0,63,255,192,0,15,192,56,0,0,31,255,64,0,0,0,0,0,0,0,0,0,
  // 0x7d72  絲
  114,125,34,34,50,36,1,253,0,10,64,0,0,7,64,0,0,0,15,224,0,0,15,224,0,0,0,31,192,0,0,31,192,0,0,0,63,64,0,0,63,128,0,0,0,191,2,0,0,127,1,64,0,0,252,11,224,0,253,3,244,0,46,248,15,224,42,248,15,240,0,63,240,63,192,127,240,31,208,0,127,208,127,0,127,208,63,128,0,31,240,253,0,15,240,191,0,0,3,254,252,0,3,253,253,0,0,0,255,240,0,0,255,248,0,0,0,127,209,192,0,63,241,240,0,0,63,135,240,0,63,195,248,0,0,190,3,244,0,191,1,252,0,1,252,1,252,1,253,0,191,0,191,255,255,253,127,255,255,255,64,191,255,255,255,127,255,255,255,192,127,255,255,255,127,255,255,255,208,0,3,240,47,80,3,240,11,208,0,3,240,8,0,3,240,3,0,6,147,240,96,0,3,240,16,0,11,227,242,244,11,211,242,244,0,15,211,241,252,15,211,242,252,0,15,195,240,252,31,195,240,253,0,15,195,240,126,47,131,240,191,0,31,131,240,63,63,67,240,63,64,63,67,240,62,127,3,240,47,192,63,3,240,0,254,3,240,15,192,190,3,240,2,252,3,240,15,224,28,3,240,0,184,3,240,7,128,0,3,240,0,0,3,240,0,0,0,3,240,0,0,3,240,0,0,0,3,240,0,0,3,240,0,0,
  // 0x7da0  綠
  160,125,34,34,50,36,1,253,0,25,0,0,14,128,0,0,0,0,47,128,0,31,192,0,0,0,0,63,0,0,47,128,0,0,0,0,126,0,0,63,255,255,244,0,0,252,4,0,63,255,255,244,0,1,248,47,64,127,170,171,240,0,27,240,63,0,190,0,3,240,0,63,224,190,0,253,0,7,240,0,127,193,252,0,255,255,255,224,0,31,211,244,1,255,255,255,208,0,11,251,224,2,254,170,175,192,0,2,255,192,1,96,0,15,192,0,0,255,92,0,0,0,31,192,0,0,190,62,31,255,255,255,255,192,1,252,47,95,255,255,255,255,192,3,240,31,223,255,255,255,255,192,255,255,255,192,0,15,192,0,0,191,255,255,224,0,15,208,4,0,191,255,235,241,208,15,224,31,64,0,15,130,251,244,15,240,127,192,0,15,129,66,253,15,241,254,0,10,79,134,0,191,15,255,248,0,15,143,159,64,63,79,255,224,0,31,79,143,192,12,15,255,64,0,47,15,139,192,1,79,255,64,0,47,15,135,208,11,207,223,192,0,63,15,131,224,127,223,207,240,0,62,15,131,226,255,79,195,252,0,189,15,129,31,252,15,193,255,64,252,15,128,127,224,15,192,191,224,40,15,128,63,64,15,192,47,192,0,15,128,28,11,255,192,7,64,0,15,128,0,7,255,64,0,0,0,15,128,0,3,249,0,0,0,
  // 0x7db2  網
  178,125,33,35,59,36,1,252,0,8,0,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,63,64,15,255,255,255,255,128,0,127,0,15,255,255,255,255,128,0,252,0,15,255,255,255,255,128,1,248,46,15,192,0,0,31,128,27,240,63,15,198,64,46,31,128,63,224,190,15,203,192,63,31,128,127,193,252,15,195,208,61,31,128,47,211,240,15,195,224,188,31,128,11,251,224,15,194,240,244,31,128,3,255,192,15,202,234,186,31,128,0,255,109,15,207,255,255,95,128,0,190,63,15,207,255,255,95,128,1,252,47,79,192,31,64,31,128,3,240,31,207,192,31,64,31,128,255,255,255,239,192,31,64,31,128,191,255,255,255,202,175,234,95,128,191,255,235,255,207,255,255,95,128,0,15,130,255,207,255,255,95,128,0,15,129,159,195,240,0,31,128,10,79,135,15,195,240,0,31,128,15,143,143,79,195,240,0,31,128,31,79,143,207,195,240,0,31,128,47,79,139,223,195,240,0,31,128,47,15,135,239,195,240,0,31,128,63,15,131,255,194,255,255,31,128,62,15,131,255,193,255,255,31,128,125,15,129,95,192,106,170,31,128,252,15,128,15,192,0,0,31,128,40,15,128,15,192,0,0,31,128,0,15,128,15,192,0,47,255,64,0,15,128,15,192,0,15,255,0,0,15,128,15,192,0,15,248,0,0,0,0,0,0,0,0,0,0,
  // 0x7dd2  緒
  210,125,34,34,50,36,1,253,0,29,0,0,1,248,0,0,0,0,47,128,0,1,248,0,14,64,0,63,0,0,1,248,0,47,128,0,126,0,0,1,248,0,63,0,0,252,24,11,255,255,253,190,0,1,248,63,79,255,255,254,253,0,47,240,127,15,255,255,255,252,0,127,208,253,0,1,248,7,240,0,127,193,252,0,1,248,15,224,0,31,211,240,0,1,248,47,192,0,11,251,224,0,1,248,127,64,0,3,255,192,63,255,255,255,255,208,0,255,93,63,255,255,255,255,208,0,190,63,63,255,255,255,255,208,1,252,47,64,0,127,192,0,0,3,240,31,192,1,255,0,0,0,255,255,255,208,11,252,0,0,0,191,255,255,224,63,255,255,253,0,191,255,235,242,255,255,255,253,0,0,15,130,255,255,255,255,253,0,0,15,128,255,254,0,0,253,0,10,79,135,63,190,0,0,253,0,15,143,143,68,126,0,0,253,0,31,79,143,192,127,170,170,253,0,47,15,139,192,127,255,255,253,0,47,15,135,208,127,255,255,253,0,63,15,131,224,126,0,0,253,0,62,15,131,208,126,0,0,253,0,189,15,128,0,126,0,0,253,0,188,15,128,0,127,255,255,253,0,4,15,128,0,127,255,255,253,0,0,15,128,0,127,255,255,253,0,0,15,128,0,126,0,0,253,0,0,15,128,0,41,0,0,168,0,
  // 0x7dda  線
  218,125,34,34,50,36,1,253,0,25,0,0,0,14,64,0,0,0,47,128,0,0,47,208,0,0,0,63,0,0,0,63,192,0,0,0,126,0,0,0,63,64,0,0,0,252,4,3,255,255,255,255,0,1,248,47,67,255,255,255,255,0,27,240,63,3,250,170,170,191,0,63,224,190,3,240,0,0,63,0,127,193,252,3,240,0,0,63,0,31,211,244,3,255,255,255,255,0,11,251,224,3,255,255,255,255,0,2,255,192,3,245,85,85,191,0,0,255,92,3,240,0,0,63,0,0,190,62,3,240,0,0,63,0,1,252,47,67,250,170,170,191,0,3,240,31,195,255,255,255,255,0,255,255,255,195,255,255,255,255,0,191,255,255,224,0,15,192,0,0,191,255,235,240,0,15,208,4,0,0,15,130,240,0,15,224,31,64,0,15,129,95,255,159,240,127,192,9,15,134,31,255,223,245,255,0,15,143,143,95,255,207,255,252,0,31,79,143,192,31,143,255,224,0,47,15,139,192,63,79,255,128,0,47,15,135,208,127,15,239,192,0,63,15,131,224,253,15,207,240,0,62,15,131,227,252,15,199,248,0,189,15,128,15,240,15,194,255,64,252,15,128,127,208,15,192,191,224,40,15,128,191,64,15,192,47,208,0,15,128,61,11,255,192,7,128,0,15,128,0,7,255,128,0,0,0,15,128,0,3,249,0,0,0,
  // 0x7de8  編
  232,125,33,34,50,36,1,253,0,25,0,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,63,0,63,255,255,255,255,192,0,126,0,63,255,255,255,255,192,0,252,20,63,255,255,255,255,192,1,248,63,0,0,0,0,0,0,27,240,127,0,0,0,0,0,0,63,224,253,6,170,170,170,170,0,127,193,248,11,255,255,255,255,0,31,211,240,11,255,255,255,255,0,7,251,224,11,208,0,0,63,0,2,255,192,11,208,0,0,63,0,0,255,92,11,208,0,0,63,0,0,190,125,11,250,170,170,191,0,0,252,63,11,255,255,255,255,0,3,240,31,75,255,255,255,255,0,255,255,255,203,208,0,0,0,0,191,255,255,203,208,0,0,0,0,191,191,239,219,255,255,255,255,192,0,31,67,239,255,255,255,255,192,0,31,66,79,254,190,191,175,192,14,95,90,15,252,61,30,15,192,31,95,111,15,252,61,30,15,192,31,95,95,79,252,61,30,15,192,47,31,79,159,253,126,111,95,192,47,31,75,239,191,255,255,255,192,63,31,75,255,127,255,255,255,192,62,31,71,255,124,61,30,15,192,188,31,64,190,124,61,30,15,192,252,31,64,252,124,61,30,15,192,20,31,66,248,124,61,30,15,192,0,31,67,240,124,61,30,175,128,0,31,64,160,124,61,30,127,128,0,31,64,0,104,20,4,62,0,
  // 0x7e2e  縮
  46,126,33,35,59,36,1,252,0,30,0,0,0,63,128,0,0,0,47,64,0,0,63,128,0,0,0,63,0,0,0,63,128,0,0,0,189,0,47,255,255,255,255,128,0,252,45,63,255,255,255,255,192,1,244,63,63,255,255,255,255,192,47,240,126,63,0,0,0,15,192,127,208,252,63,0,0,0,15,192,127,193,248,63,0,0,0,15,192,31,211,240,63,126,0,0,5,64,11,251,208,0,127,170,170,170,128,2,255,192,0,190,255,255,255,192,0,255,109,0,253,255,255,255,192,0,190,62,1,248,0,127,0,0,0,252,47,3,240,0,190,0,0,3,240,15,135,240,0,252,0,0,255,255,255,203,240,106,254,170,64,191,255,255,223,240,191,255,255,64,191,191,251,255,240,191,255,255,64,0,31,67,255,240,188,0,31,64,0,31,64,255,240,188,0,31,64,9,31,73,59,240,188,0,31,64,15,159,111,19,240,188,0,31,64,31,95,95,3,240,191,255,255,64,47,31,79,131,240,191,255,255,64,47,31,79,131,240,190,170,191,64,63,31,75,195,240,188,0,31,64,62,31,71,195,240,188,0,31,64,125,31,65,3,240,188,0,31,64,252,31,64,3,240,188,0,31,64,40,31,64,3,240,191,255,255,64,0,31,64,3,240,191,255,255,64,0,31,64,3,240,190,170,191,64,0,31,64,3,240,188,0,31,64,0,0,0,0,0,0,0,0,0,
  // 0x7e3d  總
  61,126,34,34,50,36,1,253,0,25,0,0,0,15,144,0,0,0,47,128,0,0,47,192,0,0,0,63,0,0,0,63,128,0,0,0,126,0,6,170,191,170,170,0,0,252,20,15,255,255,255,255,0,1,248,63,15,255,255,255,255,0,27,240,127,15,192,14,0,47,0,63,224,253,15,192,31,0,47,0,127,193,248,15,192,63,255,111,0,31,211,240,15,207,191,255,47,0,7,251,224,15,207,248,47,47,0,2,255,192,15,199,255,125,47,0,0,255,92,15,223,159,248,47,0,0,190,125,15,206,7,252,47,0,0,252,63,15,192,31,255,111,0,3,240,31,79,192,191,15,47,0,255,255,255,207,195,248,0,47,0,191,255,255,207,234,234,170,191,0,191,191,239,223,255,255,255,255,0,0,31,67,239,255,255,255,255,0,0,31,66,64,0,248,0,0,0,9,31,69,0,2,255,64,0,0,15,159,111,0,0,127,208,0,0,31,95,95,0,0,11,244,0,0,47,31,79,65,11,210,240,180,0,47,31,79,135,219,208,64,252,0,63,31,75,203,203,208,0,190,0,62,31,71,207,203,208,0,63,64,125,31,65,15,139,208,4,31,192,252,31,64,47,75,208,15,143,208,40,31,64,127,11,208,15,135,224,0,31,64,189,7,255,255,67,224,0,31,64,24,3,255,255,1,0,0,31,64,0,0,170,168,0,0,
  // 0x7e7c  繼
  124,126,34,34,50,36,1,253,0,52,0,188,1,0,1,0,0,0,190,0,252,7,192,3,192,0,0,252,0,252,15,64,11,128,0,0,248,0,252,31,40,15,13,0,2,244,80,252,252,61,253,47,0,3,240,252,252,252,184,188,124,0,63,209,248,252,63,240,47,244,0,127,195,240,252,15,208,11,228,0,63,135,224,252,11,124,11,173,0,15,223,192,252,30,45,31,15,0,7,255,64,253,255,255,255,255,128,2,255,0,253,255,255,255,255,192,0,254,240,253,229,7,249,65,192,0,249,244,252,0,1,0,0,0,3,240,248,255,255,255,255,255,192,7,208,188,255,255,255,255,255,192,255,255,254,254,171,170,171,170,128,255,255,255,252,7,192,3,208,0,191,191,191,252,11,128,7,192,0,0,63,31,252,15,8,15,73,0,0,63,4,252,189,62,191,31,0,29,63,40,252,252,124,252,61,0,47,63,124,252,125,244,62,184,0,47,63,61,252,31,224,15,240,0,63,63,62,252,11,212,7,236,0,62,63,47,252,15,124,11,174,0,62,63,31,252,46,30,31,15,64,125,63,15,253,255,255,255,255,192,188,63,4,253,233,67,249,65,208,252,63,0,252,0,1,0,0,64,56,63,0,255,255,255,255,255,208,0,63,0,255,255,255,255,255,208,0,63,0,254,170,170,170,170,128,0,62,0,188,0,0,0,0,0,
  // 0x7e8c  續
  140,126,34,35,59,36,1,252,0,25,0,0,0,63,128,0,0,0,63,128,0,0,63,128,0,0,0,63,0,63,255,255,255,255,192,0,189,0,63,255,255,255,255,192,0,252,20,0,0,63,128,0,0,1,244,63,0,0,63,128,0,0,27,240,190,7,255,255,255,255,0,63,208,252,7,255,255,255,255,0,127,194,248,0,0,0,0,0,0,31,211,240,15,255,255,255,255,64,11,255,208,15,255,255,255,255,64,3,255,128,15,66,240,244,31,64,0,255,124,15,175,192,255,255,64,0,189,125,15,125,0,21,111,64,0,248,63,15,64,0,0,31,64,2,240,47,79,255,255,255,255,64,107,255,255,143,255,255,255,255,64,191,255,255,192,0,0,0,0,0,127,255,235,211,255,255,255,253,0,16,31,67,131,255,255,255,253,0,0,31,64,3,240,0,0,189,0,5,31,90,3,255,255,255,253,0,15,159,111,3,250,170,170,253,0,31,95,95,67,240,0,0,189,0,47,31,79,131,255,255,255,253,0,47,31,75,195,250,170,170,253,0,63,31,75,195,240,0,0,189,0,62,31,70,3,250,170,170,253,0,125,31,64,3,255,255,255,253,0,252,31,64,0,31,64,47,64,0,40,31,64,2,255,192,127,244,0,0,31,64,191,254,0,11,255,64,0,31,65,255,208,0,0,191,208,0,31,64,56,0,0,0,14,0,0,0,0,0,0,0,0,0,0,
  // 0x7ea2  红
  162,126,34,33,41,36,1,254,0,2,64,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,15,240,5,85,85,85,85,0,0,31,208,15,255,255,255,255,128,0,63,192,15,255,255,255,255,128,0,127,64,15,255,255,255,255,128,0,255,0,0,0,31,208,0,0,2,252,3,64,0,31,208,0,0,3,248,11,224,0,31,208,0,0,11,240,31,240,0,31,208,0,0,31,208,63,192,0,31,208,0,0,191,255,255,64,0,31,208,0,0,191,255,254,0,0,31,208,0,0,63,255,252,0,0,31,208,0,0,41,11,244,0,0,31,208,0,0,0,31,208,0,0,31,208,0,0,0,127,128,0,0,31,208,0,0,1,254,0,0,0,31,208,0,0,7,252,22,144,0,31,208,0,0,31,255,255,208,0,31,208,0,0,127,255,255,224,0,31,208,0,0,63,255,233,0,0,31,208,0,0,46,144,0,0,0,31,208,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,31,208,0,0,0,0,27,192,0,31,208,0,0,0,107,255,192,0,31,208,0,0,127,255,255,239,255,255,255,255,208,127,255,249,95,255,255,255,255,208,127,249,0,31,255,255,255,255,208,57,0,0,5,85,85,85,85,64,0,0,0,0,0,0,0,0,0,
  // 0x7f6e  置
  110,127,33,34,50,36,2,252,5,85,85,85,85,85,85,80,0,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,15,208,11,208,11,224,7,240,0,15,208,11,208,11,224,7,240,0,15,229,95,229,91,229,91,240,0,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,106,170,170,175,234,170,170,169,0,0,0,0,15,192,0,0,0,0,0,0,63,255,255,255,255,128,0,11,240,63,255,255,255,255,128,0,11,240,63,0,0,0,31,128,0,11,240,63,0,0,0,31,128,0,11,240,63,255,255,255,255,128,0,11,240,63,255,255,255,255,128,0,11,240,63,0,0,0,31,128,0,11,240,63,255,255,255,255,128,0,11,240,63,255,255,255,255,128,0,11,240,63,0,0,0,31,128,0,11,240,63,0,0,0,31,128,0,11,240,63,255,255,255,255,128,0,11,240,63,255,255,255,255,128,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,255,255,255,255,255,255,255,64,11,255,255,255,255,255,255,255,64,11,250,170,170,170,170,170,170,0,11,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7f72  署
  114,127,33,34,50,36,1,252,1,85,85,85,85,85,85,84,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,3,244,2,244,2,248,0,252,0,3,244,2,244,2,248,0,252,0,3,244,2,244,2,248,0,252,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,1,85,85,95,229,85,85,84,0,0,0,0,11,224,0,0,80,0,0,42,170,175,250,170,130,248,0,0,63,255,255,255,255,219,252,0,0,63,255,255,255,255,255,224,0,0,0,0,11,224,1,255,128,0,0,0,0,11,224,15,253,0,0,42,170,170,175,250,191,254,170,128,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,0,31,255,192,0,0,0,0,0,6,255,253,0,0,0,0,0,0,191,255,249,85,85,80,0,0,111,255,255,255,255,255,240,0,47,255,255,255,255,255,255,240,0,127,255,254,0,0,0,7,240,0,47,228,126,0,0,0,11,240,0,9,0,127,255,255,255,255,240,0,0,0,127,255,255,255,255,240,0,0,0,126,0,0,0,7,240,0,0,0,126,0,0,0,7,240,0,0,0,127,85,85,85,91,240,0,0,0,127,255,255,255,255,240,0,0,0,127,255,255,255,255,240,0,0,0,126,0,0,0,7,224,0,0,0,0,0,0,0,0,0,0,
  // 0x8070  聰
  112,128,34,35,59,36,1,252,0,0,0,0,0,15,144,0,0,0,0,0,0,0,15,208,0,0,63,255,255,252,0,47,192,0,0,63,255,255,253,170,191,234,170,0,63,255,255,255,255,255,255,255,0,3,240,15,195,255,255,255,255,0,3,240,15,195,240,11,64,47,0,3,240,15,195,240,15,0,47,0,3,240,15,195,240,47,255,47,0,3,255,255,195,243,254,175,47,0,3,255,255,195,243,252,46,47,0,3,255,255,195,247,255,188,47,0,3,240,15,195,243,75,244,47,0,3,240,15,195,240,3,252,47,0,3,240,15,195,240,31,191,47,0,3,240,15,195,240,253,8,47,0,3,240,15,195,240,240,0,47,0,3,255,255,195,255,255,255,255,0,3,255,255,195,255,255,255,255,0,3,255,255,193,170,191,170,170,0,3,240,15,192,0,191,128,0,0,3,240,15,192,0,63,240,0,0,3,240,15,192,0,7,252,0,0,3,240,15,192,3,240,252,16,0,3,240,111,192,247,240,48,252,0,27,255,255,194,247,240,0,253,0,191,255,255,195,243,240,0,127,0,127,255,175,195,243,240,0,63,64,62,64,15,199,227,240,7,95,192,0,0,15,207,195,240,7,207,192,0,0,15,239,131,240,11,203,224,0,0,15,239,2,255,255,199,224,0,0,15,193,1,255,255,66,0,0,0,15,192,0,42,169,0,0,0,0,0,0,0,0,0,0,0,
  // 0x81ea  自
  234,129,26,35,245,36,5,252,0,0,3,232,0,0,0,0,0,7,248,0,0,0,0,0,11,240,0,0,0,0,0,15,240,0,0,0,0,0,15,208,0,0,0,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,64,0,0,0,15,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,0,0,0,0,11,240,127,0,0,0,0,11,224,0,0,0,0,0,0,0,
  // 0x85cd  藍
  205,133,32,33,8,36,2,254,0,0,190,0,0,190,0,0,0,0,190,0,0,254,0,0,191,255,255,255,255,255,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,190,0,0,254,0,0,0,0,190,0,0,189,0,0,0,0,0,0,0,248,0,0,15,255,255,255,129,252,0,0,15,255,255,255,131,248,0,0,15,64,252,0,7,254,170,169,15,255,255,254,15,255,255,253,15,255,255,254,47,255,255,253,15,64,0,62,127,64,0,0,15,64,0,63,255,0,0,0,15,255,255,254,124,0,0,0,15,255,255,254,4,0,0,0,15,64,252,0,2,170,170,164,15,64,252,0,3,255,255,248,15,255,255,255,195,255,255,248,15,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,170,170,64,0,255,255,255,255,255,255,128,0,255,255,255,255,255,255,128,0,252,3,240,11,192,47,128,0,252,3,240,11,192,47,128,0,252,3,240,11,192,47,128,0,252,3,240,11,192,47,128,0,252,3,240,11,192,47,128,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x884c  行
  76,136,34,35,59,36,1,252,0,0,228,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,11,248,3,255,255,255,255,64,0,47,240,3,255,255,255,255,64,0,191,192,3,255,255,255,255,64,3,255,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,63,128,46,64,0,0,0,0,0,29,0,127,128,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,11,248,47,255,255,255,255,208,0,31,240,47,255,255,255,255,208,0,127,192,47,255,255,255,255,208,1,255,192,0,0,0,127,64,0,7,255,192,0,0,0,127,0,0,47,255,192,0,0,0,127,0,0,191,255,192,0,0,0,127,0,0,127,143,192,0,0,0,127,0,0,46,15,192,0,0,0,127,0,0,8,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,1,85,191,0,0,0,15,192,0,3,255,255,0,0,0,15,192,0,3,255,254,0,0,0,15,192,0,2,255,228,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8868  表
  104,136,34,34,50,36,1,253,0,0,0,2,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,7,255,255,255,255,255,255,253,0,7,255,255,255,255,255,255,253,0,7,255,255,255,255,255,255,253,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,170,170,171,254,170,170,160,0,0,191,255,255,255,255,255,240,0,0,191,255,255,255,255,255,240,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,0,0,0,191,239,128,0,0,0,0,0,7,255,15,192,0,116,0,0,0,47,248,15,208,2,254,0,0,2,255,208,7,240,15,253,0,0,47,255,64,3,244,127,240,0,7,255,255,0,2,254,255,64,0,191,255,191,0,0,255,248,0,0,63,244,63,0,0,191,208,0,0,30,64,63,0,0,63,208,0,0,0,0,63,0,0,31,240,0,0,0,0,63,0,27,139,253,0,0,0,0,63,91,255,194,255,128,0,0,0,127,255,255,192,191,248,0,0,111,255,255,249,0,31,255,128,0,255,255,249,0,0,7,255,208,0,191,249,0,0,0,0,127,64,0,57,0,0,0,0,0,6,0,
  // 0x88ab  被
  171,136,34,34,50,36,1,253,0,47,64,0,0,11,208,0,0,0,47,128,0,0,11,224,0,0,0,47,128,0,0,11,224,0,0,0,47,128,0,0,11,224,0,0,0,47,128,0,0,11,224,0,0,0,47,128,0,0,11,224,0,0,0,47,128,3,255,255,255,255,208,63,255,255,67,255,255,255,255,192,63,255,255,195,255,255,255,255,192,63,255,255,131,240,11,224,47,128,0,0,63,3,240,11,224,63,64,0,0,190,3,240,11,224,63,0,0,1,252,3,240,11,224,126,0,0,3,244,131,240,11,224,0,0,0,15,225,247,255,255,255,254,0,0,47,211,231,255,255,255,255,0,0,191,255,199,255,255,255,254,0,2,255,255,7,255,192,0,253,0,11,255,254,7,239,208,1,252,0,47,255,191,75,231,240,3,248,0,255,239,143,203,227,244,3,244,0,127,47,139,203,210,252,15,240,0,60,47,131,79,208,253,31,208,0,16,47,128,15,192,191,63,192,0,0,47,128,31,192,63,255,64,0,0,47,128,47,128,31,254,0,0,0,47,128,63,64,15,252,0,0,0,47,128,63,0,47,254,0,0,0,47,128,191,0,255,255,208,0,0,47,128,254,7,255,127,248,0,0,47,129,252,127,252,15,255,128,0,47,131,248,255,224,2,255,208,0,47,130,240,127,64,0,127,128,0,47,128,80,36,0,0,7,0,
  // 0x88c5  装
  197,136,34,35,59,36,1,252,0,0,190,0,0,47,128,0,0,0,0,190,0,0,47,128,0,0,7,64,190,0,0,47,128,0,0,31,224,190,0,0,47,128,0,0,11,248,190,0,0,47,128,0,0,1,253,190,63,255,255,255,255,192,0,120,190,63,255,255,255,255,192,0,16,190,63,255,255,255,255,192,0,0,190,0,0,47,128,0,0,0,0,190,0,0,47,128,0,0,0,31,190,0,0,47,128,0,0,1,255,190,0,0,47,128,0,0,47,255,190,0,0,47,128,0,0,127,244,190,15,255,255,255,255,0,63,64,190,15,255,255,255,255,0,20,0,190,11,255,255,255,255,0,0,0,190,0,0,0,0,0,0,0,0,20,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,42,170,170,171,254,170,170,170,128,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,2,255,63,64,0,80,0,0,0,47,248,31,192,2,248,0,0,6,255,208,11,224,31,248,0,1,191,255,0,3,249,255,192,0,127,255,255,0,1,255,253,0,0,47,248,127,0,0,191,224,0,0,9,0,63,0,0,47,244,0,0,0,0,63,90,254,11,255,64,0,0,26,255,255,254,1,255,249,0,0,127,255,255,253,0,47,255,208,0,63,255,148,0,0,2,255,128,0,41,0,0,0,0,0,27,0,0,0,0,0,0,0,0,0,0,
  // 0x88dd  裝
  221,136,34,35,59,36,1,252,2,144,15,192,0,15,192,0,0,7,224,15,192,0,15,192,0,0,7,224,15,192,0,15,192,0,0,7,224,15,192,0,15,192,0,0,7,250,175,192,0,15,192,0,0,7,255,255,203,255,255,255,255,128,7,255,255,203,255,255,255,255,128,3,208,15,203,255,255,255,255,128,0,0,15,192,0,15,192,0,0,42,170,175,192,0,15,192,0,0,63,255,255,192,0,15,192,0,0,63,255,255,192,0,15,192,0,0,2,244,15,192,0,15,192,0,0,3,244,15,194,255,255,255,255,0,7,240,15,195,255,255,255,255,0,15,224,15,195,255,255,255,255,0,127,192,15,192,0,0,0,0,0,63,0,15,194,252,0,0,0,0,24,0,0,2,252,0,0,0,0,42,170,170,171,254,170,170,170,128,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,2,255,63,64,0,80,0,0,0,111,248,31,192,2,248,0,0,27,255,192,11,224,31,248,0,6,255,255,0,3,249,255,208,0,127,255,255,0,1,255,253,0,0,47,228,127,0,0,191,224,0,0,4,0,127,0,5,47,248,0,0,0,0,127,111,255,11,255,64,0,0,107,255,255,255,1,255,249,0,0,191,255,255,233,0,47,255,208,0,127,250,80,0,0,2,255,128,0,20,0,0,0,0,0,27,0,0,0,0,0,0,0,0,0,0,
  // 0x8907  複
  7,137,34,34,50,36,1,253,0,63,0,0,62,0,0,0,0,0,63,0,0,127,0,0,0,0,0,63,0,0,254,0,0,0,0,0,63,0,1,255,255,255,255,192,0,63,0,3,255,255,255,255,192,0,63,0,11,255,255,255,255,192,0,63,0,15,208,0,0,0,0,63,255,254,63,192,0,0,0,0,63,255,255,255,128,0,0,0,0,63,255,254,126,255,255,255,252,0,0,0,188,21,255,255,255,252,0,0,0,252,1,248,0,0,252,0,0,2,248,1,248,0,0,252,0,0,3,240,1,255,255,255,252,0,0,11,226,129,255,255,255,252,0,0,31,195,225,248,0,0,252,0,0,63,203,193,248,0,0,252,0,0,191,255,1,255,255,255,252,0,2,255,253,1,255,255,255,252,0,7,255,254,0,3,252,0,0,0,31,255,127,64,11,240,0,0,0,127,255,31,128,47,255,255,244,0,191,63,11,0,255,255,255,252,0,60,63,0,7,255,170,175,244,0,16,63,0,47,255,64,15,224,0,0,63,0,255,239,208,63,192,0,0,63,0,62,11,249,255,0,0,0,63,0,0,2,255,252,0,0,0,63,0,0,1,255,244,0,0,0,63,0,0,47,255,255,64,0,0,63,0,27,255,255,255,254,64,0,63,0,255,255,128,127,255,224,0,63,0,191,248,0,6,255,192,0,63,0,57,0,0,0,27,0,
  // 0x89d2  角
  210,137,31,35,24,36,1,252,0,0,11,160,0,0,0,0,0,0,15,240,0,0,0,0,0,0,47,255,255,248,0,0,0,0,127,255,255,255,0,0,0,0,255,255,255,254,0,0,0,3,253,0,2,252,0,0,0,15,244,0,7,244,0,0,0,63,224,0,15,224,0,0,0,255,255,255,255,255,255,244,7,255,255,255,255,255,255,244,47,255,255,255,255,255,255,244,15,239,192,0,189,0,3,244,3,79,192,0,189,0,3,244,0,15,192,0,189,0,3,244,0,15,192,0,189,0,3,244,0,15,192,0,189,0,3,244,0,15,255,255,255,255,255,244,0,15,255,255,255,255,255,244,0,15,255,255,255,255,255,244,0,15,192,0,189,0,3,244,0,31,192,0,189,0,3,244,0,31,192,0,189,0,3,244,0,47,192,0,189,0,3,244,0,47,255,255,255,255,255,244,0,63,255,255,255,255,255,244,0,63,255,255,255,255,255,244,0,191,0,0,0,0,3,244,0,253,0,0,0,0,3,244,2,252,0,0,0,0,3,244,7,248,0,0,0,0,3,244,31,240,0,0,0,0,7,244,127,192,0,0,0,255,255,244,63,64,0,0,0,127,255,240,13,0,0,0,0,63,254,64,0,0,0,0,0,0,0,0,
  // 0x8a08  計
  8,138,34,34,50,36,1,253,0,0,0,0,0,3,240,0,0,6,170,170,144,0,7,240,0,0,11,255,255,208,0,7,240,0,0,11,255,255,208,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,191,255,255,252,0,7,240,0,0,191,255,255,252,0,7,240,0,0,106,170,170,168,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,15,255,255,208,0,7,240,0,0,15,255,255,209,85,87,245,85,80,10,170,170,151,255,255,255,255,240,0,0,0,7,255,255,255,255,240,0,0,0,7,255,255,255,255,240,15,255,255,208,0,7,240,0,0,15,255,255,208,0,7,240,0,0,10,170,170,144,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,15,255,255,208,0,7,240,0,0,15,255,255,208,0,7,240,0,0,15,234,175,208,0,7,240,0,0,15,192,11,208,0,7,240,0,0,15,192,11,208,0,7,240,0,0,15,192,11,208,0,7,240,0,0,15,192,11,208,0,7,240,0,0,15,192,11,208,0,7,240,0,0,15,234,175,208,0,7,240,0,0,15,255,255,208,0,7,240,0,0,15,255,255,208,0,7,240,0,0,15,192,0,0,0,7,240,0,0,10,128,0,0,0,7,240,0,0,
  // 0x8a0a  訊
  10,138,35,34,50,36,1,252,6,170,170,64,0,0,0,0,0,15,255,255,139,255,255,255,240,0,15,255,255,139,255,255,255,240,0,0,0,0,11,255,255,255,240,0,0,0,0,0,11,208,7,240,0,191,255,255,240,11,208,7,240,0,191,255,255,240,11,208,7,240,0,106,170,170,160,11,208,7,240,0,0,0,0,0,11,208,7,240,0,0,0,0,0,11,208,7,240,0,15,255,255,128,11,208,7,240,0,15,255,255,128,11,208,7,240,0,10,170,170,64,11,208,7,240,0,0,0,0,15,255,255,231,240,0,0,0,0,15,255,255,231,240,0,15,255,255,143,255,255,231,240,0,15,255,255,128,15,208,7,240,0,10,170,170,64,15,192,7,240,0,0,0,0,0,15,192,7,240,0,0,0,0,0,31,192,7,240,0,15,255,255,128,31,192,3,240,0,15,255,255,128,47,128,3,240,0,15,234,191,128,63,64,3,240,0,15,192,15,128,127,0,3,240,0,15,192,15,128,191,0,3,244,64,15,192,15,128,254,0,2,244,160,15,192,15,130,252,0,2,248,180,15,192,15,131,248,0,1,252,244,15,234,191,143,240,0,0,252,240,15,255,255,175,224,0,0,255,240,15,255,255,255,192,0,0,127,224,15,192,0,47,0,0,0,63,208,10,128,0,9,0,0,0,11,128,0,0,0,0,0,0,0,0,0,
  // 0x8a18  記
  24,138,34,33,41,36,1,253,6,170,170,144,0,0,0,0,0,11,255,255,224,191,255,255,254,0,11,255,255,224,191,255,255,254,0,0,0,0,0,191,255,255,254,0,0,0,0,0,0,0,0,190,0,191,255,255,252,0,0,0,190,0,191,255,255,252,0,0,0,190,0,106,170,170,168,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,15,255,255,208,0,0,0,190,0,15,255,255,208,0,0,0,190,0,10,170,170,144,0,0,0,190,0,0,0,0,0,127,255,255,254,0,0,0,0,0,127,255,255,254,0,15,255,255,208,127,255,255,254,0,15,255,255,208,127,0,0,190,0,10,170,170,144,127,0,0,190,0,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,15,255,255,208,127,0,0,0,0,15,255,255,208,127,0,0,0,0,15,234,175,208,127,0,0,0,0,15,192,11,208,127,0,0,4,0,15,192,11,208,127,0,0,11,144,15,192,11,208,127,0,0,11,224,15,192,11,208,127,0,0,11,208,15,192,11,208,127,0,0,15,208,15,234,175,208,127,64,0,47,192,15,255,255,208,63,255,255,255,192,15,255,255,208,47,255,255,255,64,15,192,0,0,11,255,255,253,0,10,128,0,0,0,0,0,0,0,
  // 0x8a2d  設
  45,138,34,33,41,36,1,253,6,170,170,128,127,255,255,0,0,11,255,255,192,127,255,255,0,0,11,255,255,192,127,255,255,0,0,0,0,0,0,127,0,63,0,0,0,0,0,0,127,0,63,0,0,191,255,255,240,127,0,63,0,0,191,255,255,240,126,0,63,3,0,106,170,170,160,190,0,63,3,224,0,0,0,0,253,0,63,67,224,0,0,0,2,252,0,63,71,224,15,255,255,199,248,0,63,255,208,15,255,255,223,240,0,31,255,192,10,170,170,175,208,0,7,254,0,0,0,0,7,64,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,199,255,255,255,253,0,15,255,255,199,255,255,255,253,0,10,170,170,135,255,255,255,252,0,0,0,0,0,25,0,3,252,0,0,0,0,0,127,0,7,244,0,15,255,255,192,63,128,15,240,0,15,255,255,192,31,192,31,208,0,15,234,175,192,15,240,127,192,0,15,192,15,192,3,252,255,0,0,15,192,15,192,1,255,253,0,0,15,192,15,192,0,191,248,0,0,15,192,15,192,0,191,244,0,0,15,192,15,192,7,255,254,0,0,15,234,175,192,47,255,255,208,0,15,255,255,203,255,244,127,254,64,15,255,255,239,255,64,11,255,208,15,192,0,15,248,0,1,191,128,10,128,0,10,64,0,0,11,0,
  // 0x8a66  試
  102,138,34,35,59,36,1,252,0,0,0,0,0,0,126,20,0,10,170,170,0,0,0,126,189,0,15,255,255,0,0,0,126,127,0,15,255,255,0,0,0,126,47,192,0,0,0,0,0,0,126,15,208,0,0,0,0,0,0,126,3,128,191,255,255,192,0,0,126,0,0,191,255,255,218,170,170,255,170,128,191,255,255,223,255,255,255,255,192,0,0,0,15,255,255,255,255,192,0,0,0,0,0,0,127,0,0,15,255,255,64,0,0,127,0,0,15,255,255,64,0,0,127,0,0,10,170,170,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,15,255,254,63,0,0,15,255,255,79,255,254,63,0,0,15,255,255,79,255,254,63,0,0,10,170,170,0,47,64,63,0,0,0,0,0,0,47,64,63,0,0,0,0,0,0,47,64,63,0,0,15,255,255,64,47,64,47,64,0,15,255,255,64,47,64,47,64,0,15,234,191,64,47,64,47,128,0,15,192,47,64,47,64,31,128,0,15,192,47,64,47,64,15,192,0,15,192,47,64,47,65,79,193,208,15,192,47,64,47,255,143,209,240,15,192,47,91,255,255,139,226,240,15,234,191,111,255,250,7,247,224,15,255,255,95,249,0,3,255,208,15,255,255,73,0,0,2,255,192,15,192,0,0,0,0,0,255,128,10,64,0,0,0,0,0,46,0,0,0,0,0,0,0,0,0,0,
  // 0x8a8d  認
  141,138,34,33,41,36,1,253,10,170,170,3,255,255,255,255,64,15,255,255,3,255,255,255,255,64,15,255,255,3,255,255,255,255,64,0,0,0,0,0,126,0,63,0,0,0,0,0,0,189,0,63,0,191,255,255,209,224,253,0,63,0,191,255,255,211,255,252,0,63,0,106,170,170,130,255,252,0,63,0,0,0,0,0,31,255,64,63,0,0,0,0,0,7,255,224,127,0,15,255,255,64,15,255,240,127,0,15,255,255,64,47,194,224,190,0,10,170,170,0,191,64,64,254,0,0,0,0,3,254,0,255,253,0,0,0,0,31,248,0,255,252,0,15,255,255,75,208,96,191,224,0,15,255,255,66,0,253,0,0,0,10,170,170,0,0,255,192,0,0,0,0,0,0,0,47,244,0,0,0,0,0,0,0,7,253,0,0,15,255,255,64,6,144,252,0,0,15,255,255,66,71,224,48,116,0,15,234,191,67,231,224,1,252,0,15,192,47,71,215,224,0,253,0,15,192,47,75,215,224,0,127,0,15,192,47,79,199,224,0,63,128,15,192,47,79,199,224,9,31,192,15,192,47,95,135,224,11,207,208,15,234,191,127,71,224,11,203,224,15,255,255,191,7,224,15,199,240,15,255,255,76,7,255,255,131,128,15,192,0,0,3,255,255,64,0,10,64,0,0,0,191,253,0,0,
  // 0x8aa4  誤
  164,138,34,34,50,36,1,252,6,170,169,0,0,255,255,255,0,15,255,254,0,0,255,255,255,0,15,255,254,0,0,255,255,255,0,0,0,0,7,224,252,0,127,0,0,0,0,7,224,252,0,127,0,191,255,255,199,224,252,0,127,0,191,255,255,199,224,252,0,127,0,106,170,170,135,224,252,0,127,0,0,0,0,7,224,255,255,255,0,0,0,0,7,224,255,255,255,0,15,255,254,7,224,255,255,255,0,15,255,254,7,224,0,0,0,0,10,170,169,7,224,0,0,0,0,0,0,0,7,224,0,0,0,0,0,0,0,7,255,255,255,252,0,15,255,254,7,255,255,255,252,0,15,255,254,7,255,255,255,252,0,10,170,169,7,224,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,15,255,255,0,0,0,1,252,0,15,255,255,63,255,255,255,255,224,15,234,191,63,255,255,255,255,224,15,128,63,63,255,255,255,255,224,15,128,63,0,10,0,2,0,0,15,128,63,0,15,208,47,192,0,15,128,63,0,63,208,31,240,0,15,128,63,0,255,128,7,252,0,15,234,191,3,254,0,2,254,0,15,255,255,15,248,0,0,191,128,15,255,255,127,224,0,0,63,208,15,128,0,63,128,0,0,15,208,10,64,0,13,0,0,0,6,0,0,0,0,0,0,0,0,0,0,
  // 0x8abf  調
  191,138,33,34,50,36,1,252,10,170,168,15,255,255,255,255,64,15,255,252,31,255,255,255,255,64,15,255,252,31,255,255,255,255,64,0,0,0,31,128,0,0,47,64,0,0,0,31,128,31,0,47,64,191,255,255,31,128,31,64,47,64,191,255,255,31,128,31,64,47,64,106,170,170,31,139,255,254,47,64,0,0,0,31,139,255,254,47,64,0,0,0,31,134,175,169,47,64,15,255,252,31,128,31,64,47,64,15,255,252,31,128,31,64,47,64,10,170,168,31,134,175,170,47,64,0,0,0,31,143,255,255,47,64,0,0,0,31,143,255,255,47,64,15,255,252,31,128,0,0,47,64,15,255,252,31,128,0,0,47,64,10,170,168,31,129,85,84,47,64,0,0,0,31,139,255,253,47,64,0,0,0,31,139,255,253,47,64,15,255,252,47,75,192,61,47,64,15,255,252,47,75,192,61,47,64,15,234,252,47,75,192,61,47,64,15,64,188,63,11,192,61,47,64,15,64,188,63,11,213,125,47,64,15,64,188,63,11,255,253,47,64,15,64,188,126,11,255,253,47,64,15,64,188,189,11,192,0,47,64,15,234,252,252,1,64,0,47,64,15,255,254,252,0,0,16,127,64,15,255,255,248,0,0,63,255,64,15,64,3,244,0,0,63,255,0,10,64,0,112,0,0,47,248,0,0,0,0,0,0,0,0,0,0,
  // 0x8acb  請
  203,138,34,34,50,36,1,253,0,0,0,0,0,15,192,0,0,6,170,170,64,0,15,192,0,0,15,255,255,129,85,95,229,85,64,15,255,255,135,255,255,255,255,128,0,0,0,7,255,255,255,255,128,0,0,0,0,0,15,192,0,0,191,255,255,240,85,95,213,85,0,191,255,255,241,255,255,255,255,0,106,170,170,161,255,255,255,255,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,15,255,255,143,255,255,255,255,208,15,255,255,143,255,255,255,255,208,10,170,170,69,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,84,0,15,255,255,128,191,255,255,253,0,15,255,255,128,191,255,255,253,0,10,170,170,64,189,0,0,253,0,0,0,0,0,189,0,0,253,0,0,0,0,0,191,255,255,253,0,15,255,255,128,191,255,255,253,0,15,255,255,128,190,85,85,253,0,15,234,191,128,189,0,0,253,0,15,192,15,128,190,85,85,253,0,15,192,15,128,191,255,255,253,0,15,192,15,128,191,255,255,253,0,15,192,15,128,189,0,0,253,0,15,192,15,128,189,0,0,253,0,15,234,191,128,189,0,0,253,0,15,255,255,128,189,0,0,253,0,15,255,255,128,189,0,191,253,0,15,192,0,0,189,0,63,248,0,10,128,0,0,105,0,42,144,0,
  // 0x8b70  議
  112,139,34,34,50,36,1,253,0,0,0,0,100,0,3,144,0,10,170,168,0,252,0,11,224,0,15,255,252,0,127,0,15,192,0,15,255,252,21,127,85,111,149,0,0,0,0,47,255,255,255,255,64,0,0,0,47,255,255,255,255,64,191,255,255,0,0,63,0,0,0,191,255,255,0,0,63,0,0,0,106,170,170,11,255,255,255,253,0,0,0,0,11,255,255,255,253,0,0,0,0,0,0,63,64,0,0,15,255,252,0,0,63,0,0,0,15,255,252,255,255,255,255,255,192,10,170,168,255,255,255,255,255,192,0,0,0,170,170,170,170,170,128,0,0,0,0,0,81,160,0,0,15,255,252,5,175,250,245,244,0,15,255,252,127,255,209,245,254,0,10,170,168,63,254,1,244,63,64,0,0,0,0,62,1,244,15,64,0,0,0,0,62,1,244,0,0,15,255,252,255,255,255,255,255,192,15,255,252,255,255,255,255,255,192,15,234,252,85,191,85,253,85,64,15,64,188,0,62,0,252,36,0,15,64,188,0,127,188,188,190,0,15,64,188,191,255,252,190,252,0,15,64,188,255,255,232,127,240,0,15,64,188,250,190,0,63,192,0,15,234,252,0,62,0,191,129,208,15,255,252,0,62,7,255,194,224,15,255,252,21,190,127,219,251,208,15,64,0,47,253,61,3,255,192,10,64,0,15,244,0,0,191,0,
  // 0x8b80  讀
  128,139,34,35,59,36,1,252,0,0,0,0,0,63,64,0,0,10,170,168,0,0,63,64,0,0,15,255,252,63,255,255,255,255,192,15,255,252,63,255,255,255,255,192,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,191,255,255,11,255,255,255,255,0,191,255,255,6,170,170,170,170,0,106,170,170,0,0,0,0,0,0,0,0,0,47,255,255,255,255,128,0,0,0,47,255,255,255,255,128,15,255,252,47,1,224,240,15,128,15,255,252,47,11,192,255,255,128,10,170,168,47,121,0,21,95,128,0,0,0,47,0,0,0,15,128,0,0,0,47,255,255,255,255,128,15,255,252,47,255,255,255,255,128,15,255,252,0,0,0,0,0,0,10,170,168,11,255,255,255,254,0,0,0,0,11,255,255,255,254,0,0,0,0,11,208,0,0,126,0,15,255,252,11,255,255,255,254,0,15,255,252,11,229,85,85,190,0,15,234,252,11,208,0,0,126,0,15,64,188,11,255,255,255,254,0,15,64,188,11,229,85,85,190,0,15,64,188,11,208,0,0,126,0,15,64,188,11,255,255,255,254,0,15,64,188,11,255,255,255,254,0,15,234,252,0,47,64,47,64,0,15,255,252,2,255,192,127,244,0,15,255,252,127,253,0,7,255,64,15,64,0,255,208,0,0,127,208,10,64,0,56,0,0,0,11,0,0,0,0,0,0,0,0,0,0,
  // 0x8b8a  變
  138,139,34,35,59,36,1,252,0,40,0,0,0,0,29,0,0,0,62,0,63,255,128,63,0,0,0,252,0,63,255,128,188,0,0,10,240,144,0,0,5,244,120,0,31,210,245,255,255,255,224,252,0,15,215,226,255,255,255,227,240,0,3,255,192,0,0,3,255,208,0,0,255,16,42,170,128,255,84,0,0,252,180,63,255,192,189,124,0,2,240,124,0,0,1,244,47,0,63,255,255,0,0,63,255,255,128,63,255,255,191,255,255,255,255,208,21,111,10,63,255,169,111,66,192,0,47,0,0,0,0,31,64,0,11,175,120,127,255,199,159,109,0,15,175,60,126,175,203,159,111,0,31,47,46,124,11,207,95,79,128,47,47,31,124,11,223,31,71,192,62,47,5,127,255,254,31,67,208,44,47,11,250,170,156,31,65,0,0,26,31,208,0,0,10,0,0,0,0,127,192,0,0,0,0,0,0,1,255,255,255,255,255,255,0,0,11,255,255,255,255,255,255,0,0,63,254,170,170,175,254,170,0,2,255,255,0,0,47,224,0,0,31,253,127,224,1,255,128,0,0,11,208,15,254,31,253,0,0,0,1,0,1,255,255,240,0,0,0,0,0,1,191,255,228,0,0,0,0,22,191,255,255,255,249,64,0,127,255,255,249,6,255,255,255,208,63,255,249,0,0,7,255,255,192,31,229,0,0,0,0,5,175,0,0,0,0,0,0,0,0,0,0,
  // 0x8cc7  資
  199,140,32,35,24,36,2,252,0,0,0,3,224,0,0,0,11,144,0,7,240,0,0,0,31,255,64,15,229,85,85,80,7,255,240,47,255,255,255,253,0,31,224,191,255,255,255,252,0,1,194,252,7,248,3,240,0,0,7,240,11,252,15,224,0,0,16,192,31,254,15,192,0,27,240,0,127,191,128,0,27,255,240,7,254,31,248,0,255,255,145,191,248,7,255,228,191,228,3,255,128,0,191,255,121,0,2,244,0,0,11,253,0,127,255,255,255,255,255,104,0,127,255,255,255,255,255,0,0,127,0,0,0,0,127,0,0,126,0,0,0,0,127,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,127,0,0,0,0,127,0,0,126,0,0,0,0,127,0,0,127,0,0,0,0,127,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,126,0,0,0,0,127,0,0,127,0,0,0,0,127,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,0,29,0,0,100,0,0,0,2,255,192,2,255,144,0,1,191,254,0,1,191,254,0,191,255,224,0,0,7,255,228,63,249,0,0,0,0,111,254,14,64,0,0,0,0,2,224,0,0,0,0,0,0,0,0,
  // 0x8ddd  距
  221,141,34,33,41,36,1,253,11,255,255,244,0,0,0,0,0,15,255,255,244,127,255,255,255,192,15,255,255,244,127,255,255,255,192,15,192,3,244,127,255,255,255,192,15,192,3,244,127,0,0,0,0,15,192,3,244,127,0,0,0,0,15,192,3,244,127,0,0,0,0,15,192,3,244,127,0,0,0,0,15,192,3,244,127,0,0,0,0,15,255,255,244,127,255,255,254,0,15,255,255,244,127,255,255,254,0,15,255,255,244,127,255,255,254,0,0,3,240,0,127,0,0,190,0,0,3,240,0,127,0,0,190,0,0,3,240,0,127,0,0,190,0,15,195,240,0,127,0,0,190,0,15,195,240,0,127,0,0,190,0,15,195,255,252,127,0,0,190,0,15,195,255,252,127,0,0,190,0,15,195,255,252,127,255,255,254,0,15,195,240,0,127,255,255,254,0,15,195,240,0,127,255,255,254,0,15,195,240,0,127,0,0,0,0,15,195,240,0,127,0,0,0,0,15,195,240,4,127,0,0,0,0,15,195,246,253,127,0,0,0,0,15,199,255,253,127,0,0,0,0,31,255,255,253,127,0,0,0,0,191,255,254,64,127,255,255,255,224,191,254,64,0,127,255,255,255,224,126,64,0,0,127,255,255,255,224,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,
  // 0x8eca  車
  202,142,32,35,24,36,2,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,1,255,255,255,255,255,255,64,1,255,255,255,255,255,255,64,1,255,255,255,255,255,255,64,1,252,0,15,224,0,63,64,1,252,0,15,224,0,63,64,1,254,170,175,250,170,191,64,1,255,255,255,255,255,255,64,1,255,255,255,255,255,255,64,1,252,0,15,224,0,63,64,1,252,0,15,224,0,63,64,1,252,0,15,224,0,63,64,1,254,170,175,250,170,191,64,1,255,255,255,255,255,255,64,1,255,255,255,255,255,255,64,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8edf  軟
  223,142,34,35,59,36,1,252,0,3,244,0,1,228,0,0,0,0,3,244,0,2,248,0,0,0,0,3,244,0,2,248,0,0,0,0,3,244,0,3,244,0,0,0,63,255,255,255,67,240,0,0,0,63,255,255,255,71,240,0,0,0,63,255,255,255,75,240,0,0,0,0,3,244,0,11,255,255,255,192,0,3,244,0,15,255,255,255,192,31,255,255,255,31,255,255,255,192,31,255,255,255,47,135,240,31,128,31,151,245,127,63,71,240,47,64,31,66,240,63,191,7,240,63,0,31,66,240,63,254,7,240,63,0,31,86,245,127,252,7,240,62,0,31,255,255,255,248,7,240,125,0,31,255,255,255,48,7,240,188,0,31,66,240,63,0,7,240,4,0,31,66,240,63,0,11,240,0,0,31,151,245,127,0,15,244,0,0,31,255,255,255,0,15,248,0,0,31,255,255,255,0,31,252,0,0,0,3,244,0,0,47,189,0,0,0,3,244,0,0,63,62,0,0,0,3,244,0,0,189,63,0,0,127,255,255,255,192,252,47,128,0,127,255,255,255,195,248,15,208,0,127,255,255,255,203,240,11,240,0,0,3,244,0,47,224,3,252,0,0,3,244,0,191,192,1,255,0,0,3,244,3,255,0,0,255,208,0,3,244,15,252,0,0,63,224,0,3,244,3,240,0,0,15,192,0,3,244,2,128,0,0,2,64,0,0,0,0,0,0,0,0,0,
  // 0x8ef8  軸
  248,142,33,35,59,36,1,252,0,3,224,0,0,3,240,0,0,0,3,224,0,0,3,240,0,0,0,3,224,0,0,3,240,0,0,0,3,224,0,0,3,240,0,0,63,255,255,254,0,3,240,0,0,63,255,255,254,0,3,240,0,0,63,255,255,254,0,3,240,0,0,0,3,224,0,0,3,240,0,0,0,3,224,0,127,255,255,255,64,31,255,255,252,127,255,255,255,64,31,255,255,252,127,255,255,255,64,31,151,229,188,126,3,240,31,64,31,3,208,188,126,3,240,31,64,31,3,208,188,126,3,240,31,64,31,87,229,188,126,3,240,31,64,31,255,255,252,126,3,240,31,64,31,255,255,252,126,3,240,31,64,31,3,208,188,126,3,240,31,64,31,3,208,188,127,255,255,255,64,31,151,229,188,127,255,255,255,64,31,255,255,252,127,255,255,255,64,31,255,255,252,126,3,240,31,64,0,3,224,0,126,3,240,31,64,0,3,224,0,126,3,240,31,64,0,3,224,0,126,3,240,31,64,191,255,255,255,126,3,240,31,64,191,255,255,255,126,3,240,31,64,191,255,255,255,126,3,240,31,64,0,3,224,0,126,3,240,31,64,0,3,224,0,127,255,255,255,64,0,3,224,0,127,255,255,255,64,0,3,224,0,127,255,255,255,64,0,3,224,0,126,0,0,31,64,0,3,224,0,126,0,0,31,64,0,0,0,0,0,0,0,0,0,
  // 0x8f09  載
  9,143,33,35,59,36,2,252,0,0,252,0,3,240,4,0,0,0,0,252,0,3,244,46,0,0,0,0,252,0,3,244,191,128,0,31,255,255,255,195,244,47,224,0,31,255,255,255,195,244,11,248,0,26,170,254,170,131,244,2,252,0,0,0,252,0,3,244,0,240,0,0,0,252,0,3,244,0,0,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,0,252,0,2,248,0,0,0,0,0,252,0,2,248,0,0,0,63,255,255,255,226,252,2,244,0,63,255,255,255,225,252,3,244,0,21,86,253,85,81,252,7,240,0,0,0,252,0,1,252,11,224,0,10,171,254,170,128,252,15,208,0,31,255,255,255,192,253,31,192,0,31,0,248,7,192,253,63,128,0,31,0,248,7,192,190,127,0,0,31,255,255,255,192,191,254,0,0,31,234,254,175,192,127,252,0,0,31,0,248,7,192,63,244,0,0,31,255,255,255,192,63,240,0,0,31,255,255,255,192,63,192,12,0,0,0,252,0,0,191,192,15,64,0,0,252,0,2,255,208,31,128,191,255,255,255,251,255,240,31,64,191,255,255,255,255,247,248,47,0,85,86,253,86,255,194,254,127,0,0,0,252,3,255,0,255,254,0,0,0,252,1,248,0,63,252,0,0,0,252,0,160,0,11,244,0,0,0,0,0,0,0,0,0,0,
  // 0x8f2f  輯
  47,143,34,35,59,36,1,252,0,3,224,0,0,0,0,0,0,0,3,224,0,15,255,255,254,0,0,3,224,0,15,255,255,254,0,0,3,224,0,15,213,85,254,0,63,255,255,254,15,192,0,190,0,63,255,255,254,15,192,0,190,0,63,255,255,254,15,213,85,254,0,0,3,224,0,15,255,255,254,0,0,3,224,0,15,255,255,254,0,31,255,255,252,0,0,0,0,0,31,255,255,252,0,0,0,0,0,31,151,229,188,255,255,255,255,224,31,3,208,188,255,255,255,255,224,31,3,208,188,175,234,170,255,144,31,87,229,188,15,192,0,190,0,31,255,255,252,15,192,0,190,0,31,255,255,252,15,213,85,190,0,31,3,208,188,15,255,255,254,0,31,3,208,188,15,255,255,254,0,31,151,229,188,15,192,0,190,0,31,255,255,252,15,192,0,190,0,31,255,255,252,15,213,85,254,0,0,3,224,0,15,255,255,254,0,0,3,224,0,15,255,255,254,0,0,3,224,0,15,192,0,190,0,191,255,255,255,15,192,0,190,0,191,255,255,255,15,192,0,191,208,191,255,255,255,15,234,191,255,224,0,3,224,3,255,255,255,255,224,0,3,224,3,255,255,255,254,0,0,3,224,2,250,148,0,190,0,0,3,224,0,0,0,0,190,0,0,3,224,0,0,0,0,190,0,0,3,224,0,0,0,0,190,0,0,0,0,0,0,0,0,0,0,
  // 0x8f38  輸
  56,143,34,34,50,36,1,253,0,15,192,0,0,15,208,0,0,0,15,192,0,0,31,240,0,0,0,15,192,0,0,63,252,0,0,0,15,192,0,0,191,254,0,0,63,255,255,248,1,252,127,64,0,63,255,255,248,7,244,47,208,0,63,255,255,248,31,240,15,244,0,0,15,192,0,127,192,3,254,0,0,15,192,2,255,0,0,255,192,47,255,255,255,255,170,170,191,240,47,255,255,251,227,255,255,207,224,47,91,215,243,67,255,255,194,192,46,7,130,240,0,0,0,0,0,46,7,130,240,0,0,0,0,0,47,91,150,241,85,84,0,15,128,47,255,255,242,255,253,25,15,128,47,255,255,242,255,253,62,15,128,46,7,130,242,224,61,62,15,128,46,7,130,242,224,61,62,15,128,47,91,215,242,245,125,62,15,128,47,255,255,242,255,253,62,15,128,47,255,255,242,255,253,62,15,128,0,15,192,2,224,61,62,15,128,0,15,192,2,224,61,62,15,128,0,15,192,2,245,125,62,15,128,191,255,255,246,255,253,62,15,128,191,255,255,246,255,253,62,15,128,191,255,255,246,224,61,62,15,128,0,15,192,2,224,61,21,15,128,0,15,192,2,224,61,0,15,128,0,15,192,2,224,61,0,15,128,0,15,192,2,224,125,5,111,128,0,15,192,2,225,253,7,255,64,0,15,192,2,224,248,3,253,0,
  // 0x8f49  轉
  73,143,34,35,59,36,1,252,0,11,208,0,0,7,224,0,0,0,11,208,0,0,7,224,0,0,0,11,208,0,170,171,250,170,128,0,11,229,85,255,255,255,255,192,63,255,255,253,255,255,255,255,192,63,255,255,252,0,7,224,0,0,63,255,255,252,0,7,224,0,0,0,11,208,0,191,255,255,255,64,0,11,208,0,191,255,255,255,64,31,255,255,244,188,7,224,47,64,31,255,255,244,188,7,224,47,64,31,91,213,244,191,255,255,255,64,31,3,192,244,191,255,255,255,64,31,3,192,244,188,7,224,47,64,31,87,213,244,188,7,224,47,64,31,255,255,244,191,255,255,255,64,31,255,255,244,191,255,255,255,64,31,3,192,244,0,7,224,248,0,31,3,192,244,0,7,224,190,0,31,91,213,247,255,255,255,255,128,31,255,255,246,255,255,255,255,208,31,255,255,245,165,84,5,67,192,0,11,208,0,0,0,15,208,0,0,11,208,1,170,170,175,234,144,0,11,208,3,255,255,255,255,224,191,255,255,255,255,255,255,255,224,191,255,255,253,11,0,15,208,0,191,255,255,253,47,192,15,208,0,0,11,208,0,15,224,15,208,0,0,11,208,0,3,244,15,208,0,0,11,208,0,1,240,15,208,0,0,11,208,0,0,74,175,192,0,0,11,208,0,0,15,255,192,0,0,11,208,0,0,7,254,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8fd1  近
  209,143,34,34,50,36,1,253,0,0,0,0,0,0,1,128,0,3,64,0,0,0,1,191,240,0,31,208,0,4,5,191,255,252,0,31,248,0,15,255,255,255,208,0,7,254,0,15,255,255,164,0,0,0,255,128,15,254,80,0,0,0,0,63,208,15,192,0,0,0,0,0,15,192,15,192,0,0,0,0,0,6,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,255,255,255,255,192,0,0,0,31,255,255,255,255,192,0,0,0,31,255,255,255,255,192,0,0,0,31,192,1,252,0,0,63,255,128,31,192,1,252,0,0,63,255,128,47,128,1,252,0,0,63,255,128,63,128,1,252,0,0,0,47,128,63,64,1,252,0,0,0,47,128,127,0,1,252,0,0,0,47,128,191,0,1,252,0,0,0,47,128,253,0,1,252,0,0,0,47,130,252,0,1,252,0,0,0,47,131,248,0,1,252,0,0,0,47,143,240,0,1,252,0,0,0,47,143,208,0,1,252,0,0,0,63,195,128,0,1,252,0,0,1,255,240,0,0,1,252,0,0,11,255,254,0,0,0,0,0,0,127,248,255,249,64,0,0,85,80,127,208,63,255,255,255,255,255,208,63,64,7,255,255,255,255,255,192,28,0,0,43,255,255,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x8fd4  返
  212,143,34,33,41,36,1,253,2,0,0,0,0,0,0,0,0,31,208,0,63,255,255,255,255,0,31,244,0,63,255,255,255,255,0,7,253,0,63,255,255,255,255,0,0,255,64,63,0,0,0,0,0,0,63,192,63,0,0,0,0,0,0,15,64,63,0,0,0,0,0,0,4,0,63,0,0,0,0,0,0,0,0,127,255,255,255,248,0,0,0,0,127,255,255,255,252,0,0,0,0,127,255,255,255,248,0,0,0,0,127,127,0,3,244,0,0,0,0,127,63,0,11,240,0,63,255,64,127,47,128,15,224,0,63,255,64,190,15,192,31,192,0,63,255,64,190,15,240,63,128,0,0,63,64,253,7,244,255,0,0,0,63,64,252,2,254,254,0,0,0,63,65,252,0,255,252,0,0,0,63,66,252,0,127,240,0,0,0,63,67,244,0,127,240,0,0,0,63,71,240,2,255,254,0,0,0,63,79,240,15,255,255,192,0,0,63,95,209,255,244,191,253,0,0,63,111,203,255,192,31,255,192,0,127,199,67,254,0,2,255,128,2,255,240,1,224,0,0,47,0,11,255,253,0,0,0,0,0,0,127,245,255,229,64,0,0,21,80,191,192,127,255,255,255,255,255,208,63,0,11,255,255,255,255,255,192,44,0,0,111,255,255,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x9000  退
  0,144,34,33,41,36,1,253,3,128,0,47,255,255,255,240,0,31,240,0,47,255,255,255,240,0,11,253,0,47,255,255,255,240,0,2,255,64,47,128,0,3,240,0,0,191,192,47,128,0,3,240,0,0,47,224,47,128,0,3,240,0,0,11,128,47,255,255,255,240,0,0,1,0,47,255,255,255,240,0,0,0,0,47,234,170,171,240,0,0,0,0,47,128,0,3,240,0,0,0,0,47,128,0,3,240,0,0,0,0,47,128,0,3,240,0,0,0,0,47,255,255,255,240,0,63,255,128,47,255,255,255,240,0,63,255,128,47,255,255,255,244,0,63,255,128,47,128,126,0,62,0,0,47,128,47,128,63,1,255,64,0,47,128,47,128,47,139,253,0,0,47,128,47,128,15,255,224,0,0,47,128,47,128,11,255,0,0,0,47,128,47,128,3,252,0,0,0,47,128,47,128,25,255,0,0,0,47,128,47,155,252,191,208,0,0,47,128,127,255,252,47,253,0,0,47,195,255,255,228,7,255,192,0,63,211,255,228,0,1,255,64,1,255,246,228,0,0,0,30,0,11,255,254,0,0,0,0,0,0,127,244,255,249,64,0,0,85,80,127,208,63,255,255,255,255,255,208,63,0,7,255,255,255,255,255,192,28,0,0,43,255,255,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x901f  速
  31,144,34,34,50,36,1,253,0,0,0,0,0,252,0,0,0,2,0,0,0,0,252,0,0,0,15,208,0,0,0,252,0,0,0,47,244,0,0,0,252,0,0,0,7,254,7,255,255,255,255,255,192,1,255,135,255,255,255,255,255,192,0,63,215,255,255,255,255,255,128,0,15,128,0,0,252,0,0,0,0,1,0,0,0,252,0,0,0,0,0,0,255,255,255,255,253,0,0,0,0,255,255,255,255,253,0,0,0,0,254,170,254,170,253,0,0,0,0,252,0,252,0,253,0,0,0,0,252,0,252,0,253,0,63,255,128,252,0,252,0,253,0,63,255,128,252,0,252,0,253,0,63,255,128,255,255,255,255,253,0,0,47,128,255,255,255,255,253,0,0,47,128,170,175,255,234,169,0,0,47,128,0,47,255,192,0,0,0,47,128,0,127,255,244,0,0,0,47,128,2,253,254,253,0,0,0,47,128,11,244,252,191,128,0,0,47,128,127,208,252,47,244,0,0,47,130,255,64,252,11,255,64,0,47,207,253,0,252,1,255,128,0,63,211,240,0,252,0,63,0,1,255,245,64,0,252,0,4,0,11,255,254,0,0,168,0,0,0,127,244,255,249,64,0,0,85,80,127,208,63,255,255,255,255,255,208,63,0,7,255,255,255,255,255,192,28,0,0,43,255,255,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x9023  連
  35,144,34,34,50,36,1,253,0,0,0,0,2,248,0,0,0,7,0,0,0,2,248,0,0,0,47,208,0,0,2,248,0,0,0,31,244,15,255,255,255,255,255,64,7,253,15,255,255,255,255,255,64,1,255,75,255,255,255,255,255,64,0,127,192,0,2,248,0,0,0,0,47,64,0,2,248,0,0,0,0,9,1,255,255,255,255,248,0,0,0,1,255,255,255,255,248,0,0,0,1,253,86,253,86,248,0,0,0,1,248,2,248,1,248,0,0,0,1,248,2,248,1,248,0,0,0,1,255,255,255,255,248,0,127,255,1,255,255,255,255,248,0,127,255,1,253,86,253,86,248,0,127,255,1,248,2,248,1,248,0,0,63,1,253,86,253,86,248,0,0,63,1,255,255,255,255,248,0,0,63,1,255,255,255,255,248,0,0,63,0,0,2,248,0,0,0,0,63,0,0,2,248,0,0,0,0,63,26,170,171,254,170,170,128,0,63,31,255,255,255,255,255,192,0,63,31,255,255,255,255,255,192,0,63,0,0,2,248,0,0,0,0,63,128,0,2,248,0,0,0,0,255,208,0,2,248,0,0,0,7,255,244,0,2,248,0,0,0,47,251,255,128,0,0,0,0,0,127,208,255,255,234,170,170,255,208,63,64,47,255,255,255,255,255,192,45,0,1,255,255,255,255,255,128,4,0,0,1,85,85,85,85,0,
  // 0x9032  進
  50,144,34,34,50,36,1,253,0,0,0,2,144,1,144,0,0,7,64,0,3,248,3,252,0,0,47,208,0,11,240,3,244,0,0,15,248,0,15,224,11,240,0,0,3,254,0,47,192,15,208,0,0,0,255,64,127,255,255,255,255,0,0,63,192,255,255,255,255,255,0,0,31,2,255,255,255,255,255,0,0,4,7,255,0,47,128,0,0,0,0,31,255,0,47,128,0,0,0,0,63,255,0,47,128,0,0,0,0,255,255,0,47,128,0,0,0,0,255,191,255,255,255,252,0,0,0,60,127,255,255,255,252,0,127,255,0,127,255,255,255,252,0,127,255,0,127,0,47,128,0,0,127,255,0,127,0,47,128,0,0,0,63,0,127,0,47,128,0,0,0,63,0,127,255,255,255,252,0,0,63,0,127,255,255,255,252,0,0,63,0,127,255,255,255,252,0,0,63,0,127,0,47,128,0,0,0,63,0,127,0,47,128,0,0,0,63,0,127,0,47,128,0,0,0,63,0,127,255,255,255,255,128,0,63,0,127,255,255,255,255,128,0,63,128,127,255,255,255,255,128,0,255,208,0,0,0,0,0,0,7,255,244,0,0,0,0,0,0,47,251,255,128,0,0,0,0,0,127,208,255,255,234,170,170,255,208,63,64,47,255,255,255,255,255,192,45,0,1,255,255,255,255,255,128,4,0,0,1,85,85,85,85,0,
  // 0x904b  運
  75,144,34,33,41,36,1,253,7,0,5,85,85,85,85,85,0,47,208,11,255,255,255,255,255,64,31,244,11,255,255,255,255,255,64,7,253,11,192,0,84,0,47,64,1,255,75,192,1,252,0,47,64,0,127,193,64,1,252,0,5,0,0,31,67,255,255,255,255,254,0,0,8,3,255,255,255,255,254,0,0,0,1,85,86,253,85,84,0,0,0,0,0,1,252,0,0,0,0,0,0,255,255,255,255,248,0,0,0,0,255,255,255,255,248,0,0,0,0,252,1,252,1,248,0,127,255,0,252,1,252,1,248,0,127,255,0,255,255,255,255,248,0,127,255,0,255,255,255,255,248,0,0,63,0,252,1,252,1,248,0,0,63,0,252,1,252,1,248,0,0,63,0,252,1,252,1,248,0,0,63,0,255,255,255,255,248,0,0,63,0,255,255,255,255,248,0,0,63,0,0,1,252,0,0,0,0,63,10,170,170,254,170,170,128,0,63,15,255,255,255,255,255,192,0,63,15,255,255,255,255,255,192,0,63,128,0,1,252,0,0,0,0,255,208,0,1,252,0,0,0,7,255,244,0,1,252,0,0,0,47,251,255,128,0,0,0,0,0,127,208,255,255,234,170,170,255,208,63,64,47,255,255,255,255,255,192,45,0,1,255,255,255,255,255,128,4,0,0,1,85,85,85,85,0,
  // 0x9054  達
  84,144,34,34,50,36,1,253,0,0,0,0,1,252,0,0,0,3,0,0,0,1,252,0,0,0,31,208,0,85,86,253,85,84,0,31,244,0,255,255,255,255,248,0,7,253,0,255,255,255,255,248,0,1,255,0,0,1,252,0,0,0,0,127,192,0,1,252,0,0,0,0,47,133,85,86,253,85,85,64,0,13,31,255,255,255,255,255,192,0,0,31,255,255,255,255,255,192,0,0,0,11,208,0,63,64,0,0,0,0,7,240,0,191,0,0,0,0,0,3,244,0,253,0,0,0,0,5,87,249,85,253,85,64,127,255,11,255,255,255,255,255,128,127,255,11,255,255,255,255,255,128,127,255,0,0,1,252,0,0,0,0,63,0,0,1,252,0,0,0,0,63,0,255,255,255,255,252,0,0,63,0,255,255,255,255,252,0,0,63,0,85,86,253,85,84,0,0,63,0,0,1,252,0,0,0,0,63,0,0,1,252,0,0,0,0,63,15,255,255,255,255,255,128,0,63,15,255,255,255,255,255,128,0,63,6,170,170,254,170,170,64,0,63,64,0,1,252,0,0,0,0,255,208,0,1,252,0,0,0,7,255,244,0,0,168,0,0,0,31,251,255,64,0,0,0,0,0,127,208,255,255,234,170,170,255,208,63,64,47,255,255,255,255,255,192,45,0,1,255,255,255,255,255,128,4,0,0,1,85,85,85,85,0,
  // 0x9078  選
  120,144,34,33,41,36,1,253,11,0,15,255,255,47,255,254,0,63,192,15,255,255,47,255,254,0,47,240,0,0,63,0,0,126,0,11,252,0,0,63,0,0,126,0,2,254,1,85,127,1,85,126,0,0,255,75,255,255,15,255,254,0,0,63,11,255,255,15,255,254,0,0,36,11,192,0,15,192,1,0,0,0,11,208,7,207,192,7,192,0,0,7,255,255,203,255,255,192,0,0,3,255,255,67,255,255,64,0,0,0,21,84,0,21,84,0,0,0,0,2,248,1,252,0,0,127,255,0,2,248,1,252,0,0,127,255,5,87,253,86,253,85,0,127,255,11,255,255,255,255,255,0,0,127,11,255,255,255,255,255,0,0,63,0,2,248,1,252,0,0,0,63,0,2,248,1,252,0,0,0,63,0,2,248,1,252,0,0,0,63,47,255,255,255,255,255,192,0,63,47,255,255,255,255,255,192,0,63,26,170,170,170,170,170,128,0,63,0,1,248,0,188,0,0,0,63,0,31,248,1,255,128,0,0,127,1,255,208,0,47,248,0,1,255,203,254,0,0,3,255,0,7,255,245,240,0,0,0,190,0,47,247,254,128,0,0,0,16,0,191,192,255,255,170,170,170,255,224,63,0,47,255,255,255,255,255,192,44,0,1,191,255,255,255,255,192,0,0,0,0,85,85,85,84,0,
  // 0x9084  還
  132,144,34,33,41,36,1,253,7,64,3,255,255,255,255,252,0,47,208,3,255,255,255,255,252,0,31,244,3,240,61,7,192,252,0,3,253,3,240,61,7,192,188,0,0,255,67,240,61,7,192,188,0,0,63,195,255,255,255,255,252,0,0,31,67,255,255,255,255,252,0,0,8,0,0,0,0,0,0,0,0,0,21,85,85,85,85,85,64,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,0,255,255,255,255,240,0,127,255,0,255,255,255,255,240,0,127,255,0,252,0,0,3,240,0,0,63,0,252,0,0,3,240,0,0,63,0,255,255,255,255,240,0,0,63,0,255,255,255,255,248,0,0,63,0,0,31,248,0,255,0,0,63,0,0,191,254,3,252,0,0,63,0,7,255,255,223,224,0,0,63,0,127,247,255,255,64,0,0,63,7,255,195,246,255,144,0,0,63,15,253,3,240,63,254,64,0,63,131,224,3,240,11,255,64,0,255,209,0,3,240,0,126,0,7,255,244,0,3,240,0,0,0,47,251,255,128,0,0,0,0,0,127,208,255,255,234,170,170,255,208,63,64,47,255,255,255,255,255,192,45,0,1,255,255,255,255,255,128,4,0,0,1,85,85,85,85,0,
  // 0x908a  邊
  138,144,34,34,50,36,1,253,0,64,0,0,1,232,0,0,0,2,224,0,0,2,248,0,0,0,11,253,0,127,255,255,255,240,0,2,255,128,127,170,170,171,240,0,0,127,224,127,85,85,91,240,0,0,15,192,127,255,255,255,240,0,0,2,0,127,0,0,3,240,0,0,0,0,127,85,85,91,240,0,11,64,0,127,255,255,255,240,0,47,224,0,127,0,0,3,240,0,31,252,0,127,85,85,91,240,0,2,255,64,127,255,255,255,240,0,0,127,64,0,1,248,0,0,0,0,29,10,170,171,254,170,170,128,0,0,15,255,255,255,255,255,128,0,0,15,192,124,15,64,31,128,0,0,15,192,248,15,65,255,128,127,255,0,27,240,15,255,224,0,127,255,2,255,129,255,255,128,0,127,255,0,248,1,248,0,0,0,0,63,15,255,255,255,255,255,192,0,63,15,255,255,255,255,255,192,0,63,0,0,126,0,0,0,0,0,63,0,0,191,255,255,192,0,0,63,0,2,255,255,255,192,0,0,63,0,11,240,0,15,192,0,0,127,65,191,208,0,31,128,0,1,255,215,255,0,62,255,0,0,7,255,251,244,0,63,253,0,0,47,247,255,128,0,0,0,0,0,191,208,255,255,234,170,170,191,208,63,64,47,255,255,255,255,255,192,45,0,1,191,255,255,255,255,192,0,0,0,1,85,85,85,85,0,
  // 0x90e8  部
  232,144,34,34,50,36,1,253,0,0,169,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,191,255,255,64,0,0,190,0,0,191,255,255,208,47,255,255,255,244,191,255,255,192,47,255,255,255,244,190,0,63,192,47,255,255,255,244,190,0,63,64,0,16,0,20,0,190,0,191,0,1,248,0,63,64,190,0,254,0,0,252,0,63,0,190,1,252,0,0,189,0,126,0,190,2,248,0,0,126,0,189,0,190,3,244,0,0,127,0,252,0,190,7,240,0,0,36,0,100,0,190,15,208,0,127,255,255,255,252,190,31,192,0,127,255,255,255,252,190,15,240,0,127,255,255,255,252,190,3,248,0,0,0,0,0,0,190,0,253,0,0,0,0,0,0,190,0,191,0,0,0,0,0,0,190,0,63,64,3,255,255,255,192,190,0,47,128,3,255,255,255,192,190,0,31,192,3,255,255,255,192,190,0,31,192,3,240,0,15,192,190,0,31,192,3,240,0,15,192,190,0,31,192,3,240,0,15,192,190,0,127,192,3,240,0,15,192,190,63,255,128,3,240,0,15,192,190,31,255,0,3,240,0,15,192,190,31,248,0,3,255,255,255,192,190,5,64,0,3,255,255,255,192,190,0,0,0,3,255,255,255,192,190,0,0,0,3,240,0,15,192,190,0,0,0,3,240,0,15,192,190,0,0,0,
  // 0x91cb  釋
  203,145,34,35,59,36,1,252,0,0,27,128,0,0,0,0,0,1,107,255,241,85,85,85,85,0,127,255,255,147,255,255,255,255,64,63,255,208,3,255,255,255,255,64,21,11,192,3,240,244,60,31,64,0,11,192,147,240,244,60,31,64,31,11,193,247,240,244,60,31,64,31,11,194,243,245,249,125,111,64,15,139,195,227,255,255,255,255,64,15,203,195,211,255,255,255,255,64,11,203,203,192,0,15,192,0,0,7,203,207,128,21,95,213,84,0,1,11,194,0,191,255,255,252,0,106,175,250,164,191,255,255,252,0,127,255,255,244,0,15,192,0,0,127,255,255,244,0,15,192,0,0,0,47,192,15,255,255,255,255,208,0,63,208,15,255,255,255,255,208,0,127,244,5,95,85,87,229,64,0,255,253,0,15,128,7,224,0,0,255,255,64,15,192,11,192,0,2,255,223,208,7,208,15,128,0,3,235,199,241,87,229,111,85,64,11,203,194,231,255,255,255,255,192,31,139,192,135,255,255,255,255,192,63,75,192,0,0,15,192,0,0,191,11,192,0,0,15,192,0,0,125,11,192,1,255,255,255,255,0,56,11,192,1,255,255,255,255,0,16,11,192,0,85,95,229,85,0,0,11,192,0,0,15,192,0,0,0,11,192,0,0,15,192,0,0,0,11,192,0,0,15,192,0,0,0,11,192,0,0,15,192,0,0,0,0,0,0,0,0,0,0,0,
  // 0x91cd  重
  205,145,32,33,8,36,2,254,0,0,0,0,0,5,172,0,0,0,5,90,191,255,254,0,3,255,255,255,255,255,255,0,2,255,255,255,255,169,64,0,1,170,85,95,208,0,0,0,0,0,0,15,208,0,0,0,170,170,170,175,250,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,253,85,95,229,85,127,64,0,252,0,15,208,0,63,64,0,252,0,15,224,0,63,64,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,252,0,15,208,0,63,64,0,252,0,15,208,0,63,64,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,85,85,95,229,85,85,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,7,255,255,255,255,255,255,240,7,255,255,255,255,255,255,240,2,170,170,175,250,170,170,160,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,170,170,170,170,
  // 0x91cf  量
  207,145,33,32,32,36,2,254,0,127,255,255,255,255,253,0,0,0,191,255,255,255,255,254,0,0,0,190,0,0,0,0,254,0,0,0,190,0,0,0,0,254,0,0,0,191,255,255,255,255,254,0,0,0,191,255,255,255,255,254,0,0,0,190,0,0,0,0,254,0,0,0,191,255,255,255,255,254,0,0,0,191,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,252,0,11,224,0,63,64,0,0,252,0,11,224,0,63,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,252,0,11,224,0,63,64,0,0,252,0,11,224,0,63,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,0,0,11,224,0,0,0,0,1,85,85,95,229,85,85,64,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,0,0,0,11,224,0,0,0,0,170,170,170,175,250,170,170,170,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,
  // 0x91dd  針
  221,145,34,34,50,36,1,253,0,3,248,0,0,2,164,0,0,0,11,254,0,0,3,248,0,0,0,15,255,192,0,3,248,0,0,0,63,239,240,0,3,248,0,0,0,127,75,252,0,3,248,0,0,0,254,2,255,0,3,248,0,0,3,252,0,191,128,3,248,0,0,15,240,0,63,192,3,248,0,0,63,208,0,15,64,3,248,0,0,255,255,255,253,0,3,248,0,0,63,255,255,244,0,3,248,0,0,22,255,255,244,0,3,248,0,0,0,2,244,0,255,255,255,255,224,0,2,244,0,255,255,255,255,224,0,2,244,0,255,255,255,255,224,0,2,244,0,85,87,253,85,64,47,255,255,255,64,3,248,0,0,47,255,255,255,64,3,248,0,0,47,255,255,255,64,3,248,0,0,0,2,244,0,0,3,248,0,0,0,2,244,36,0,3,248,0,0,15,130,244,62,0,3,248,0,0,11,194,244,125,0,3,248,0,0,7,194,244,188,0,3,248,0,0,3,210,244,248,0,3,248,0,0,3,226,245,244,0,3,248,0,0,3,242,245,240,0,3,248,0,0,1,66,244,1,0,3,248,0,0,0,2,250,255,64,3,248,0,0,1,175,255,255,64,3,248,0,0,63,255,255,255,64,3,248,0,0,63,255,249,64,0,3,248,0,0,47,148,0,0,0,3,248,0,0,0,0,0,0,0,2,248,0,0,
  // 0x9215  鈕
  21,146,34,34,50,36,1,253,0,15,224,0,0,0,0,0,0,0,31,248,0,0,0,0,0,0,0,63,254,0,255,255,255,252,0,0,127,127,128,255,255,255,252,0,0,253,47,224,255,255,255,252,0,2,252,11,248,1,253,2,252,0,7,240,3,253,0,252,1,252,0,31,208,0,252,0,252,1,252,0,127,192,0,112,1,252,2,248,0,255,255,255,208,1,252,2,248,0,63,255,255,192,1,252,2,248,0,7,255,255,192,1,248,2,248,0,0,11,208,0,2,248,2,248,0,0,11,208,0,2,248,2,248,0,0,11,208,0,2,244,2,248,0,63,255,255,247,255,255,255,255,224,63,255,255,247,255,255,255,255,224,63,255,255,247,255,255,255,255,224,0,11,208,0,7,244,3,248,0,0,11,208,64,3,240,3,244,0,15,11,210,240,7,240,3,244,0,15,75,210,240,7,240,3,244,0,15,139,211,224,7,224,3,240,0,11,203,211,208,11,224,3,240,0,7,203,215,192,11,224,3,240,0,7,203,219,128,11,208,3,240,0,3,139,210,64,15,208,7,240,0,0,11,208,20,15,192,7,240,0,0,11,235,252,15,192,7,240,0,1,191,255,252,31,192,11,240,0,63,255,255,255,255,255,255,255,224,63,255,228,31,255,255,255,255,224,46,144,0,31,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x932f  錯
  47,147,34,34,50,36,1,253,0,15,224,0,3,240,15,192,0,0,31,248,0,3,240,15,192,0,0,63,254,0,3,240,15,192,0,0,127,191,128,3,240,15,192,0,0,254,47,209,255,255,255,255,128,2,252,15,245,255,255,255,255,128,7,244,3,254,255,255,255,255,128,31,224,0,252,3,240,15,192,0,127,192,0,112,3,240,15,192,0,255,255,255,208,3,240,15,192,0,63,255,255,192,3,240,15,192,0,7,255,255,192,3,240,15,192,0,0,11,208,11,255,255,255,255,224,0,11,208,11,255,255,255,255,224,0,11,208,11,255,255,255,255,224,63,255,255,244,0,0,0,0,0,63,255,255,244,0,0,0,0,0,63,255,255,244,0,0,0,0,0,0,11,208,0,63,255,255,253,0,0,11,208,64,63,255,255,253,0,11,11,209,240,63,170,170,253,0,15,75,210,240,63,0,0,189,0,15,139,211,224,63,0,0,189,0,11,203,211,208,63,0,0,189,0,7,203,215,192,63,255,255,253,0,7,203,219,128,63,255,255,253,0,3,203,210,64,63,170,170,253,0,0,11,208,104,63,0,0,189,0,0,11,255,252,63,0,0,189,0,26,255,255,252,63,255,255,253,0,63,255,255,164,63,255,255,253,0,63,255,144,0,63,255,255,253,0,46,64,0,0,63,0,0,189,0,0,0,0,0,42,0,0,105,0,
  // 0x9375  鍵
  117,147,34,34,50,36,1,253,0,31,128,0,0,0,188,0,0,0,47,224,0,0,0,188,0,0,0,63,244,0,0,0,188,0,0,0,191,252,63,253,63,255,255,0,0,253,255,127,252,63,255,255,0,3,248,63,255,252,42,254,175,0,11,240,31,208,248,0,188,31,0,31,208,11,193,244,0,188,31,0,127,64,3,3,242,255,255,255,240,255,170,170,3,226,255,255,255,240,127,255,255,7,209,170,254,175,224,27,255,255,15,192,0,188,31,0,0,31,64,15,128,0,188,31,0,0,31,64,31,233,63,255,255,0,0,31,64,63,255,63,255,255,0,63,255,255,127,255,42,254,170,0,63,255,255,93,47,0,188,0,0,63,255,255,64,63,0,188,0,0,0,31,64,8,62,191,255,255,64,0,31,68,61,62,191,255,255,64,9,31,79,62,125,106,254,170,64,30,31,79,47,188,0,188,0,0,15,31,94,31,252,0,188,0,0,15,31,110,15,249,255,255,255,208,15,95,125,15,245,255,255,255,208,11,95,124,7,241,255,255,255,192,11,159,68,7,240,0,188,0,0,0,31,64,79,252,0,188,0,0,0,47,255,223,255,0,188,0,0,27,255,255,255,127,228,0,0,0,127,255,255,253,15,255,255,255,224,63,249,11,248,2,255,255,255,208,36,0,3,224,0,27,255,255,192,0,0,0,64,0,0,0,0,0,
  // 0x9577  長
  119,149,32,34,16,36,2,252,0,11,255,255,255,255,255,64,0,15,255,255,255,255,255,64,0,15,255,255,255,255,255,64,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,255,255,255,255,253,0,0,15,255,255,255,255,253,0,0,15,250,170,170,170,168,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,255,255,255,255,253,0,0,15,255,255,255,255,253,0,0,15,250,170,170,170,168,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,15,224,11,240,0,2,128,0,15,224,3,248,0,15,240,0,15,224,2,252,0,127,224,0,15,224,0,255,3,255,64,0,15,224,0,127,159,252,0,0,15,224,0,47,255,208,0,0,15,224,0,15,254,0,0,0,15,224,0,3,255,64,0,0,15,224,91,244,255,244,0,0,15,255,255,244,63,255,64,11,255,255,255,244,11,255,254,15,255,255,233,0,0,255,255,15,255,148,0,0,0,11,253,5,64,0,0,0,0,0,108,0,0,0,0,0,0,0,0,
  // 0x9589  閉
  137,149,30,33,8,36,3,253,106,170,170,144,106,170,170,144,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,254,0,11,224,190,0,7,240,254,0,11,224,190,0,7,240,254,85,95,224,190,85,91,240,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,254,0,11,224,190,0,7,240,254,0,11,224,190,0,7,240,254,0,11,224,190,0,7,240,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,255,85,85,64,85,85,91,240,254,0,0,0,168,0,7,240,254,0,0,0,252,0,7,240,254,0,0,0,252,0,7,240,254,10,170,171,254,170,7,240,254,15,255,255,255,255,7,240,254,15,255,255,255,255,7,240,254,0,0,15,252,0,7,240,254,0,0,63,252,0,7,240,254,0,0,255,252,0,7,240,254,0,3,253,252,0,7,240,254,0,31,240,252,0,7,240,254,0,191,192,252,0,7,240,254,7,255,0,252,0,7,240,254,47,248,0,252,0,7,240,254,15,208,0,252,0,7,240,254,2,0,191,248,21,95,240,254,0,0,191,244,63,255,240,254,0,0,63,144,63,255,208,190,0,0,0,0,47,254,0,
  // 0x958b  開
  139,149,30,34,16,36,3,252,85,85,85,80,85,85,85,80,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,253,0,11,224,190,0,7,240,253,0,11,224,190,0,7,240,254,85,91,224,190,85,91,240,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,253,0,11,224,190,0,7,240,253,0,11,224,190,0,7,240,254,85,95,224,190,85,91,240,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,253,0,0,0,0,0,7,240,253,0,0,0,0,0,7,240,253,6,170,170,170,169,7,240,253,11,255,255,255,254,7,240,253,11,255,255,255,254,7,240,253,0,15,128,63,0,7,240,253,0,15,128,63,0,7,240,253,0,15,128,63,0,7,240,253,31,255,255,255,255,71,240,253,31,255,255,255,255,71,240,253,31,255,255,255,255,71,240,253,0,31,128,63,0,7,240,253,0,47,64,63,0,7,240,253,0,63,0,63,0,7,240,253,0,126,0,63,0,7,240,253,0,253,0,63,0,7,240,253,3,252,0,63,5,91,240,253,15,240,0,63,15,255,240,253,7,208,0,63,11,255,208,253,1,64,0,0,7,254,64,0,0,0,0,0,0,0,0,
  // 0x9593  間
  147,149,30,33,8,36,3,253,106,170,170,144,106,170,170,144,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,254,0,11,224,190,0,7,240,254,0,11,224,190,0,7,240,254,85,95,224,190,85,91,240,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,254,0,11,224,190,0,7,240,254,0,11,224,190,0,7,240,254,0,11,224,190,0,7,240,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,255,85,85,64,85,85,91,240,254,0,0,0,0,0,7,240,254,0,0,0,0,0,7,240,254,0,255,255,255,224,7,240,254,0,255,255,255,224,7,240,254,0,254,170,171,224,7,240,254,0,252,0,7,224,7,240,254,0,252,0,7,224,7,240,254,0,254,85,91,224,7,240,254,0,255,255,255,224,7,240,254,0,255,255,255,224,7,240,254,0,252,0,7,224,7,240,254,0,252,0,7,224,7,240,254,0,252,0,7,224,7,240,254,0,255,255,255,224,7,240,254,0,255,255,255,224,7,240,254,0,254,170,170,181,95,240,254,0,252,0,0,47,255,240,254,0,84,0,0,31,255,208,254,0,0,0,0,15,254,64,
  // 0x95dc  關
  220,149,30,34,16,36,3,252,85,85,85,64,21,85,85,80,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,253,0,11,224,190,0,3,240,253,0,11,224,190,0,3,240,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,253,0,11,224,190,0,7,240,253,0,11,224,190,0,3,240,254,85,91,224,190,85,87,240,255,255,255,224,191,255,255,240,255,255,255,224,191,255,255,240,253,0,61,0,15,64,3,240,253,0,124,0,62,0,3,240,253,10,240,131,184,100,3,240,253,15,210,231,240,244,3,240,253,3,231,193,251,208,3,240,253,0,255,0,127,88,3,240,253,0,125,208,45,45,3,240,253,1,240,240,190,191,3,240,253,47,255,255,255,255,67,240,253,47,255,191,229,7,67,240,253,0,1,176,160,0,3,240,253,7,129,240,244,61,3,240,253,7,129,240,244,61,3,240,253,7,129,240,244,61,3,240,253,7,255,240,255,253,3,240,253,7,255,224,255,253,3,240,253,0,7,208,244,0,3,240,253,0,31,192,244,1,7,240,253,1,255,0,244,3,255,240,253,0,252,0,244,2,255,224,253,0,80,0,0,1,254,64,0,0,0,0,0,0,0,0,
  // 0x964d  降
  77,150,32,35,24,36,3,252,0,0,0,0,14,64,0,0,0,0,0,0,63,128,0,0,255,255,208,0,127,0,0,0,255,255,244,0,255,170,170,0,255,255,240,3,255,255,255,192,252,7,240,11,255,255,255,64,252,11,208,47,240,0,191,0,252,15,192,191,248,0,253,0,252,15,195,254,253,3,252,0,252,47,71,244,127,79,240,0,252,63,1,208,47,255,192,0,252,62,0,0,11,255,64,0,252,125,0,0,11,255,64,0,252,190,0,0,191,255,244,0,252,63,0,11,255,159,255,144,252,15,194,255,253,1,255,254,252,15,215,255,208,47,175,252,252,7,226,249,0,47,129,180,252,3,240,64,0,47,128,0,252,3,240,255,255,255,255,240,252,3,240,255,255,255,255,240,252,3,240,255,255,255,255,240,252,11,240,11,192,47,128,0,252,255,224,11,192,47,128,0,252,255,192,11,192,47,128,0,252,190,0,11,192,47,128,0,252,0,15,255,255,255,255,252,252,0,15,255,255,255,255,252,252,0,11,255,255,255,255,252,252,0,0,0,0,47,128,0,252,0,0,0,0,47,128,0,252,0,0,0,0,47,128,0,252,0,0,0,0,47,128,0,252,0,0,0,0,47,128,0,0,0,0,0,0,0,0,0,
  // 0x9664  除
  100,150,32,34,16,36,3,253,0,0,0,0,6,160,0,0,0,0,0,0,15,248,0,0,255,255,208,0,47,252,0,0,255,255,244,0,127,255,0,0,255,255,240,0,254,63,192,0,252,7,240,3,252,31,240,0,252,11,208,15,240,7,252,0,252,15,192,63,208,2,255,0,252,15,192,255,64,0,127,208,252,47,75,253,0,0,31,248,252,63,63,244,0,0,7,254,252,62,31,239,255,255,254,252,252,189,14,31,255,255,253,40,252,190,0,31,255,255,253,0,252,63,0,0,3,240,0,0,252,15,192,0,3,240,0,0,252,11,208,0,3,240,0,0,252,7,224,0,3,240,0,0,252,3,242,255,255,255,255,240,252,3,242,255,255,255,255,240,252,3,242,255,255,255,255,240,252,3,240,0,3,240,0,0,252,11,240,0,3,240,0,0,252,255,224,62,3,240,124,0,252,255,192,190,3,240,191,0,252,190,0,252,3,240,63,128,252,0,2,248,3,240,31,192,252,0,7,240,3,240,11,240,252,0,15,224,3,240,3,244,252,0,63,192,3,240,1,252,252,0,47,0,7,240,0,252,252,0,9,3,255,240,0,80,252,0,0,2,255,224,0,0,252,0,0,1,254,64,0,0,
  // 0x968e  階
  142,150,32,35,24,36,3,252,0,0,0,80,0,21,0,0,0,0,1,248,0,63,0,0,255,255,209,248,0,63,0,0,255,255,241,248,0,63,1,224,255,255,241,248,0,63,11,248,252,11,225,255,254,63,191,244,252,15,193,255,254,63,255,64,252,15,193,254,170,63,244,0,252,31,129,248,0,63,64,0,252,47,65,248,0,63,0,0,252,63,1,248,0,63,0,56,252,62,1,248,6,63,0,62,252,188,1,254,255,63,64,126,252,189,31,255,255,63,255,253,252,63,31,255,144,31,255,252,252,31,143,144,15,150,255,160,252,15,192,0,15,208,0,0,252,11,208,0,31,192,0,0,252,7,224,191,255,255,255,224,252,3,240,255,255,255,255,240,252,3,240,255,255,255,255,240,252,3,240,253,0,0,7,240,252,11,224,253,0,0,7,240,252,255,208,253,0,0,7,240,252,255,192,255,255,255,255,240,252,189,0,255,255,255,255,240,252,0,0,254,170,170,175,240,252,0,0,253,0,0,7,240,252,0,0,253,0,0,7,240,252,0,0,253,0,0,7,240,252,0,0,255,255,255,255,240,252,0,0,255,255,255,255,240,252,0,0,255,255,255,255,240,252,0,0,189,0,0,7,224,0,0,0,0,0,0,0,0,
  // 0x96d9  雙
  217,150,33,35,59,36,1,252,0,41,1,0,0,100,4,0,0,0,63,7,208,0,252,31,128,0,0,125,15,192,1,252,63,0,0,0,252,31,64,3,244,62,0,0,1,255,255,255,131,255,255,255,64,3,255,255,255,143,255,255,255,64,15,248,63,0,31,240,125,0,0,47,244,47,0,63,224,125,0,0,127,255,255,255,255,255,255,254,0,63,255,255,255,255,255,255,254,0,25,244,63,0,115,240,125,0,0,1,244,47,0,3,224,125,0,0,1,255,255,255,3,255,255,254,0,1,255,255,255,3,255,255,254,0,1,248,63,0,3,240,125,0,0,1,244,47,0,3,224,125,0,0,1,255,255,255,195,255,255,255,192,1,255,255,255,195,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,170,170,170,170,170,174,0,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,128,0,0,1,253,0,0,2,255,0,0,0,1,255,128,0,15,252,0,0,0,0,127,240,0,127,240,0,0,0,0,31,254,7,255,128,0,0,0,0,2,255,255,252,0,0,0,0,0,0,191,255,240,0,0,0,0,0,27,255,255,255,144,0,0,5,175,255,255,255,255,255,233,64,63,255,255,228,2,255,255,255,128,31,255,249,0,0,7,255,255,0,15,148,0,0,0,0,5,189,0,0,0,0,0,0,0,0,0,0,
  // 0x96e2  離
  226,150,34,35,59,36,1,252,0,1,252,0,0,30,0,64,0,0,1,252,0,0,47,128,252,0,0,1,252,0,0,63,2,248,0,127,255,255,255,240,63,3,244,0,127,255,255,255,240,190,3,240,0,106,170,170,170,160,253,7,224,0,0,0,5,0,1,252,15,208,0,11,128,15,79,66,255,255,255,192,15,143,111,15,67,255,255,255,192,15,143,253,15,75,255,255,255,192,15,130,253,15,79,248,15,192,0,15,131,255,143,111,248,15,192,0,15,143,219,223,191,248,15,192,0,15,175,66,79,255,248,15,192,0,15,136,0,15,190,255,255,255,128,15,255,255,255,85,255,255,255,192,15,255,255,255,65,255,255,255,192,5,86,249,85,1,248,15,192,0,0,1,244,0,1,248,15,192,0,26,171,250,170,129,248,15,192,0,47,255,255,255,209,248,15,192,0,47,255,255,255,209,248,15,192,0,47,3,208,11,209,255,255,255,192,47,3,210,75,209,255,255,255,192,47,7,199,139,209,255,255,255,128,47,7,195,203,209,248,15,192,0,47,31,255,219,209,248,15,192,0,47,127,255,251,209,248,15,192,0,47,58,80,251,209,248,15,192,0,47,0,0,155,209,255,255,255,224,47,0,0,11,209,255,255,255,224,47,0,1,95,193,255,255,255,224,47,0,3,255,193,248,0,0,0,47,0,2,254,1,248,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x96fb  電
  251,150,33,33,41,36,2,253,2,170,170,170,170,170,170,128,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,0,0,0,11,208,0,0,0,0,0,0,0,11,208,0,0,0,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,127,85,85,95,229,85,85,253,0,126,0,0,11,208,0,0,189,0,126,47,255,139,211,255,244,189,0,126,47,255,139,211,255,248,189,0,126,0,0,11,208,0,0,189,0,0,0,0,11,208,0,0,0,0,0,127,255,139,211,255,253,0,0,0,127,255,139,211,255,253,0,0,0,0,0,6,144,0,0,0,0,0,85,85,85,85,85,85,0,0,0,255,255,255,255,255,255,0,0,0,255,255,255,255,255,255,0,0,0,252,0,15,208,0,63,0,0,0,252,0,15,208,0,63,0,0,0,255,255,255,255,255,255,0,0,0,255,255,255,255,255,255,0,0,0,252,0,15,208,0,63,0,0,0,252,0,15,208,0,63,0,0,0,253,85,95,229,85,127,0,0,0,255,255,255,255,255,255,4,0,0,255,255,255,255,255,255,31,64,0,252,0,15,208,0,0,47,64,0,168,0,15,224,0,0,63,64,0,0,0,11,255,255,255,255,0,0,0,0,3,255,255,255,253,0,0,0,0,0,26,170,170,144,0,
  // 0x9752  青
  82,151,32,35,24,36,2,252,0,0,0,11,224,0,0,0,0,0,0,15,224,0,0,0,6,170,170,175,250,170,170,144,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,240,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,85,85,95,245,85,85,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,106,170,170,170,170,170,170,169,0,0,0,0,0,0,0,0,0,26,170,170,170,170,168,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,64,0,0,0,252,0,0,63,64,0,0,0,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,149,85,85,85,252,0,0,63,64,0,0,0,252,0,0,63,149,85,85,85,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,64,0,0,0,252,0,0,63,64,0,0,0,252,0,0,63,64,0,0,1,252,0,0,63,64,0,6,171,252,0,0,63,64,0,7,255,252,0,0,63,64,0,3,255,224,0,0,0,0,0,0,0,0,0,
  // 0x975e  非
  94,151,34,35,59,36,1,252,0,0,3,240,1,248,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,15,255,255,240,2,255,255,255,192,15,255,255,240,2,255,255,255,192,15,255,255,240,2,255,255,255,192,0,0,7,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,15,255,255,240,2,255,255,255,0,15,255,255,240,2,255,255,255,0,15,255,255,240,2,255,255,255,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,7,240,2,252,0,0,0,0,0,7,246,130,252,0,0,0,0,5,175,255,194,252,0,0,0,107,255,255,255,194,255,255,255,208,127,255,255,249,2,255,255,255,208,63,255,191,192,2,255,255,255,208,57,64,127,64,2,252,0,0,0,0,0,255,0,2,252,0,0,0,0,2,253,0,2,252,0,0,0,0,11,252,0,2,252,0,0,0,0,47,240,0,2,252,0,0,0,1,255,192,0,2,252,0,0,0,11,255,0,0,2,252,0,0,0,11,252,0,0,2,252,0,0,0,2,208,0,0,2,248,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9762  面
  98,151,32,33,8,36,2,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,47,208,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,64,0,0,0,31,255,255,255,255,255,255,244,31,255,255,255,255,255,255,244,31,255,255,255,255,255,255,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,234,171,240,3,244,31,192,47,255,255,240,3,244,31,192,47,255,255,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,234,171,240,3,244,31,192,47,255,255,240,3,244,31,192,47,255,255,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,255,255,255,255,255,255,244,31,255,255,255,255,255,255,244,31,255,255,255,255,255,255,244,31,192,0,0,0,0,3,244,31,192,0,0,0,0,3,244,0,0,0,0,0,0,0,0,
  // 0x9805  項
  5,152,34,33,41,36,1,252,0,0,0,47,255,255,255,255,224,0,0,0,47,255,255,255,255,224,63,255,255,213,85,127,255,255,208,63,255,255,192,0,47,192,0,0,63,255,255,192,0,63,128,0,0,0,47,128,0,0,63,64,0,0,0,47,128,3,255,255,255,255,0,0,47,128,3,255,255,255,255,0,0,47,128,3,250,170,170,191,0,0,47,128,3,240,0,0,63,0,0,47,128,3,240,0,0,63,0,0,47,128,3,245,85,85,127,0,0,47,128,3,255,255,255,255,0,0,47,128,3,255,255,255,255,0,0,47,128,3,240,0,0,63,0,0,47,128,3,240,0,0,63,0,0,47,128,3,240,0,0,63,0,0,47,128,3,255,255,255,255,0,0,47,134,227,255,255,255,255,0,0,47,255,243,245,85,85,127,0,1,191,255,227,240,0,0,63,0,111,255,253,3,240,0,0,63,0,191,255,128,3,250,170,170,191,0,63,228,0,3,255,255,255,255,0,57,0,0,3,255,255,255,255,0,0,0,0,0,9,0,5,0,0,0,0,0,0,63,128,47,192,0,0,0,0,2,255,192,63,248,0,0,0,0,111,254,0,7,255,64,0,0,3,255,240,0,0,191,224,0,0,2,255,64,0,0,31,208,0,0,0,224,0,0,0,3,64,0,0,0,0,0,0,0,0,0,
  // 0x9810  預
  16,152,34,33,41,36,1,252,63,255,255,247,255,255,255,255,192,63,255,255,251,255,255,255,255,192,63,255,255,243,255,255,255,255,192,0,0,31,208,0,15,240,0,0,0,0,63,128,0,15,208,0,0,3,208,254,0,85,111,229,85,0,11,255,252,0,191,255,255,255,0,2,255,240,0,191,255,255,255,0,0,47,248,0,190,0,0,63,0,0,7,254,0,190,0,0,63,0,0,0,190,0,190,0,0,63,0,191,255,255,254,191,255,255,255,0,191,255,255,254,191,255,255,255,0,191,255,255,253,190,85,85,127,0,0,15,192,252,190,0,0,63,0,0,15,192,248,190,0,0,63,0,0,15,193,244,190,85,85,127,0,0,15,194,240,191,255,255,255,0,0,15,195,240,191,255,255,255,0,0,15,194,208,190,0,0,63,0,0,15,192,0,190,0,0,63,0,0,15,192,0,190,0,0,63,0,0,15,192,0,191,170,170,191,0,0,15,192,0,191,255,255,255,0,0,15,192,0,191,255,255,255,0,0,15,192,0,1,64,1,0,0,0,15,192,0,7,224,11,208,0,0,15,192,0,47,244,31,248,0,0,31,192,1,255,208,7,255,0,15,255,192,31,254,0,0,191,192,15,255,192,63,244,0,0,47,224,11,250,0,15,64,0,0,7,64,0,0,0,0,0,0,0,0,0,
  // 0x984d  額
  77,152,34,34,50,36,1,253,0,3,240,0,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,3,240,0,191,255,255,255,192,42,171,250,170,191,255,255,255,192,63,255,255,255,191,255,255,255,192,63,255,255,255,0,7,240,0,0,62,0,0,63,0,11,224,0,0,62,11,128,63,10,175,250,170,0,62,15,192,63,31,255,255,255,0,0,63,149,64,31,255,255,255,0,0,127,255,248,31,128,0,63,0,1,255,255,244,31,128,0,63,0,3,244,3,240,31,128,0,63,0,31,248,15,208,31,255,255,255,0,127,255,31,192,31,255,255,255,0,126,127,255,0,31,213,85,127,0,8,15,254,0,31,128,0,63,0,0,7,255,64,31,128,0,63,0,0,31,255,208,31,149,85,127,0,0,191,143,248,31,255,255,255,0,11,254,2,255,31,255,255,255,0,191,244,0,127,31,128,0,63,0,127,255,255,252,31,128,0,63,0,47,255,255,240,31,128,0,63,0,3,250,171,240,31,234,170,191,0,3,240,3,240,31,255,255,255,0,3,240,3,240,31,255,255,255,0,3,240,3,240,0,64,0,0,0,3,240,3,240,2,244,7,208,0,3,255,255,240,31,252,11,248,0,3,255,255,241,255,224,2,255,64,3,250,170,175,255,64,0,127,208,3,240,0,7,248,0,0,15,224,1,64,0,1,128,0,0,3,64,
  // 0x985e  類
  94,152,34,34,50,36,1,253,0,2,160,0,0,0,0,0,0,6,3,240,56,0,0,0,0,0,31,67,240,126,191,255,255,255,208,15,195,240,252,191,255,255,255,208,7,211,241,244,191,255,255,255,192,3,147,241,240,0,7,240,0,0,42,171,250,170,0,11,224,0,0,63,255,255,255,26,175,234,170,0,63,255,255,255,47,255,255,255,0,0,31,244,0,47,255,255,255,0,0,63,255,0,47,64,0,63,0,0,255,255,224,47,64,0,63,0,3,247,247,252,47,64,0,63,0,31,227,240,255,47,255,255,255,0,127,131,240,61,47,255,255,255,0,46,3,240,4,47,149,85,127,0,4,2,160,0,47,64,0,63,0,0,2,160,0,47,64,0,63,0,0,3,240,0,47,149,85,127,0,0,3,240,0,47,255,255,255,0,63,255,255,255,47,255,255,255,0,63,255,255,255,47,64,0,63,0,63,255,255,255,47,64,0,63,0,0,7,240,0,47,64,0,63,0,0,11,240,0,47,255,255,255,0,0,15,253,0,47,255,255,255,0,0,47,255,128,26,170,170,170,0,0,127,175,240,0,208,1,64,0,1,255,11,252,3,252,11,240,0,11,253,1,254,31,248,11,253,0,127,244,0,120,255,224,1,255,64,63,192,0,15,255,64,0,63,224,46,0,0,7,248,0,0,15,208,0,0,0,1,128,0,0,2,0,
  // 0x98a8  風
  168,152,34,33,41,36,1,252,0,191,255,255,255,255,255,208,0,0,191,255,255,255,255,255,208,0,0,191,255,255,255,255,255,208,0,0,190,0,0,0,0,15,208,0,0,190,0,0,1,108,15,208,0,0,190,1,90,255,255,15,208,0,0,190,127,255,255,255,79,208,0,0,190,63,255,250,64,15,208,0,0,190,21,67,240,0,15,208,0,0,190,0,3,240,0,15,208,0,0,190,0,3,240,0,15,208,0,0,190,47,255,255,255,15,208,0,0,190,47,255,255,255,15,208,0,0,190,47,171,250,191,15,208,0,0,189,47,3,240,47,11,208,0,0,189,47,3,240,47,11,208,0,0,253,47,3,240,47,11,224,0,0,253,47,3,240,47,11,224,0,0,252,47,171,250,191,11,224,0,0,252,47,255,255,255,11,224,0,0,252,47,255,255,255,7,224,0,1,252,0,3,240,4,7,224,0,2,248,0,3,240,125,7,240,0,3,244,0,3,240,63,3,240,64,3,240,0,3,240,47,131,240,192,7,240,0,3,250,191,195,240,240,15,225,171,255,255,255,226,244,240,15,210,255,255,255,255,241,249,224,63,194,255,250,149,2,244,255,224,127,64,80,0,0,1,248,255,208,63,0,0,0,0,0,128,127,192,9,0,0,0,0,0,0,31,64,0,0,0,0,0,0,0,0,0,
  // 0x98fd  飽
  253,152,34,34,50,36,1,253,0,7,244,0,3,144,0,0,0,0,15,253,0,3,240,0,0,0,0,31,255,64,11,240,0,0,0,0,63,175,208,15,224,0,0,0,0,191,15,244,15,192,0,0,0,1,253,3,252,47,255,255,255,128,3,252,0,255,63,255,255,255,128,15,241,248,61,127,255,255,255,128,63,193,248,20,254,0,0,47,128,255,65,248,2,252,0,0,47,64,63,255,255,255,244,0,0,47,64,7,255,255,255,255,255,240,47,64,3,245,86,250,239,255,240,47,64,3,240,1,248,31,255,240,47,64,3,240,2,248,0,2,240,47,64,3,255,255,248,0,2,240,63,64,3,255,255,248,0,2,240,63,64,3,240,1,248,0,2,240,63,0,3,240,1,248,63,255,240,63,0,3,245,86,248,63,255,240,63,0,3,255,255,248,63,255,240,127,0,3,255,255,248,63,0,63,255,0,3,240,0,0,63,0,47,253,0,3,240,11,0,63,0,31,244,0,3,240,47,128,63,0,0,0,0,3,240,15,192,63,0,0,0,0,3,240,11,240,63,0,0,2,0,3,240,31,244,63,0,0,3,224,3,251,255,252,63,0,0,7,224,27,255,255,253,63,0,0,7,224,127,255,228,190,63,64,0,15,208,63,249,0,127,63,255,255,255,192,41,0,0,36,31,255,255,255,128,0,0,0,0,6,255,255,253,0,
  // 0x9918  餘
  24,153,34,34,50,36,1,253,0,15,240,0,0,15,224,0,0,0,31,252,0,0,47,240,0,0,0,63,255,0,0,63,248,0,0,0,191,63,192,0,255,253,0,0,0,252,15,240,1,252,191,0,0,3,248,3,248,3,248,63,192,0,15,245,86,252,15,240,15,240,0,63,255,255,184,63,208,11,248,0,255,63,255,32,191,64,2,254,0,124,0,0,3,254,0,0,255,192,21,85,85,95,252,0,0,63,240,7,255,255,251,255,255,255,255,208,7,255,255,243,143,255,255,243,128,7,208,3,240,15,255,255,240,0,7,208,3,240,0,11,208,0,0,7,255,255,240,0,11,208,0,0,7,255,255,240,0,11,208,0,0,7,224,3,242,255,255,255,255,192,7,208,3,243,255,255,255,255,192,7,229,87,243,255,255,255,255,192,7,255,255,240,0,11,208,0,0,7,255,255,240,0,11,208,16,0,7,208,0,0,42,11,209,248,0,7,208,0,0,63,11,208,252,0,7,255,255,240,126,11,208,190,0,7,255,255,240,252,11,208,127,0,7,250,170,161,252,11,208,63,64,7,208,0,3,248,11,208,31,192,7,250,170,171,240,11,208,15,192,7,255,255,255,224,11,208,15,208,7,255,255,250,192,11,208,7,64,7,208,0,0,3,255,208,0,0,7,208,0,0,2,255,192,0,0,7,208,0,0,1,254,0,0,0,
  // 0x99ac  馬
  172,153,33,32,32,36,1,253,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,0,0,252,0,0,0,0,0,63,0,0,252,0,0,0,0,0,63,0,0,252,0,0,0,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,170,170,254,170,170,128,0,0,63,0,0,252,0,0,0,0,0,63,0,0,252,0,0,0,0,0,63,170,170,254,170,170,128,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,0,0,252,0,0,0,0,0,63,0,0,252,0,0,0,0,0,63,0,0,252,0,0,0,0,0,63,255,255,255,255,255,255,128,0,63,255,255,255,255,255,255,128,0,63,255,255,255,255,255,255,64,0,0,0,0,0,0,0,63,64,0,80,0,0,0,6,0,63,64,0,252,6,0,176,47,128,63,64,1,252,47,64,248,15,192,63,0,2,248,31,128,252,7,224,127,0,3,244,15,192,189,3,240,127,0,7,240,15,192,62,1,244,191,0,15,224,15,192,63,0,64,254,0,31,208,11,208,47,0,1,254,0,127,192,11,208,20,3,255,252,0,47,0,5,0,0,2,255,248,0,4,0,0,0,0,1,255,208,0,
  // 0x9a45  驅
  69,154,34,34,50,36,1,252,10,170,170,160,170,170,170,170,64,15,255,255,241,255,255,255,255,192,15,255,255,241,255,255,255,255,192,15,130,240,1,244,0,0,0,0,15,130,240,1,244,0,0,0,0,15,130,240,1,244,31,255,248,0,15,255,255,209,244,31,255,248,0,15,255,255,209,244,31,0,248,0,15,235,250,145,244,31,0,248,0,15,130,240,1,244,31,0,248,0,15,130,240,1,244,31,0,248,0,15,235,250,145,244,31,0,248,0,15,255,255,225,244,31,255,248,0,15,255,255,225,244,31,255,248,0,15,130,240,1,244,0,0,0,0,15,130,240,1,244,0,0,0,0,15,130,240,1,245,255,211,255,128,15,255,255,245,245,255,211,255,128,15,255,255,245,245,225,211,135,128,10,170,170,245,245,209,211,131,128,0,0,1,245,245,209,211,131,128,4,0,33,245,245,209,211,131,128,30,171,57,245,245,209,211,131,128,30,179,109,245,245,209,211,131,128,45,179,143,241,245,255,211,255,128,45,179,207,241,245,255,211,255,128,60,114,194,241,244,0,0,0,0,60,113,194,241,244,0,0,0,0,124,112,3,241,250,170,170,170,144,180,0,3,241,255,255,255,255,224,16,1,91,225,255,255,255,255,224,0,0,255,193,244,0,0,0,0,0,0,255,65,244,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9ad4  體
  212,154,33,35,59,36,2,252,0,0,0,0,0,244,124,0,0,5,85,85,64,0,244,124,0,0,15,255,255,192,0,244,124,0,0,15,255,255,192,255,255,255,253,0,15,128,15,192,255,255,255,253,0,15,128,15,192,248,184,184,125,0,15,139,255,192,244,180,116,125,0,15,139,255,192,244,180,120,125,0,15,139,15,192,255,255,255,253,0,15,139,15,192,255,255,255,253,0,15,139,15,192,244,180,116,125,0,95,223,95,212,244,180,116,125,0,255,255,255,252,255,255,255,253,0,255,255,255,252,255,255,255,253,0,248,0,0,188,0,0,0,0,0,248,0,0,188,0,0,0,0,0,255,255,255,255,255,255,255,255,64,11,255,255,131,255,255,255,255,64,11,213,111,129,85,85,85,85,0,11,192,15,128,0,0,0,0,0,11,213,95,128,127,255,255,248,0,11,255,255,128,127,255,255,248,0,11,255,255,128,124,0,0,248,0,11,192,15,128,124,0,0,248,0,11,192,15,128,125,0,0,248,0,11,255,255,128,127,255,255,248,0,11,255,255,128,127,255,255,248,0,11,213,95,128,7,128,15,128,0,11,192,15,128,11,192,15,128,0,11,192,15,128,7,224,47,0,0,11,192,15,128,3,240,62,0,0,11,193,175,139,255,255,255,255,128,11,194,255,75,255,255,255,255,128,11,193,254,5,85,85,85,85,64,0,0,0,0,0,0,0,0,0,
  // 0x9ad8  高
  216,154,32,35,24,36,2,252,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,255,255,255,255,224,0,0,11,255,255,255,255,224,0,0,11,229,85,85,95,224,0,0,11,224,0,0,11,224,0,0,11,224,0,0,11,224,0,0,11,229,85,85,95,224,0,0,11,255,255,255,255,224,0,0,11,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,255,244,15,255,255,255,255,255,255,244,15,255,255,255,255,255,255,244,15,192,0,0,0,0,3,244,15,192,21,85,85,84,3,244,15,192,63,255,255,252,3,244,15,192,63,255,255,252,3,244,15,192,63,0,0,252,3,244,15,192,63,0,0,252,3,244,15,192,63,0,0,252,3,244,15,192,63,85,85,252,3,244,15,192,63,255,255,252,3,244,15,192,63,255,255,252,7,244,15,192,63,0,0,15,255,240,15,192,42,0,0,11,255,240,15,192,0,0,0,7,255,128,0,0,0,0,0,0,0,0,
  // 0x9ec3  黃
  195,158,32,35,24,36,2,252,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,10,170,255,170,170,191,170,164,31,255,255,255,255,255,255,248,31,255,255,255,255,255,255,248,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,254,85,85,191,0,0,0,0,255,255,255,255,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,254,85,95,229,85,127,64,0,252,0,15,224,0,63,64,0,253,0,15,224,0,127,64,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,252,0,15,224,0,63,64,0,252,0,15,224,0,63,64,0,254,85,95,229,85,127,64,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,0,189,0,0,190,64,0,0,11,255,64,1,255,249,0,2,255,253,0,0,111,255,224,191,255,144,0,0,1,191,254,191,248,0,0,0,0,11,254,46,0,0,0,0,0,0,116,0,0,0,0,0,0,0,0,
  // 0x9ede  點
  222,158,34,34,50,36,1,253,0,0,0,0,0,3,240,0,0,15,255,255,255,64,3,240,0,0,15,255,255,255,64,3,240,0,0,15,149,245,111,64,3,240,0,0,15,64,240,31,64,3,240,0,0,15,180,241,255,64,3,240,0,0,15,120,242,239,64,3,240,0,0,15,124,243,223,64,3,244,0,0,15,108,243,95,64,3,255,255,224,15,93,247,31,64,3,255,255,224,15,68,246,31,64,3,255,255,224,15,64,240,31,64,3,240,0,0,15,255,255,255,64,3,240,0,0,15,255,255,255,64,3,240,0,0,5,86,249,85,0,3,240,0,0,0,2,244,0,0,3,240,0,0,10,171,250,170,0,3,240,0,0,31,255,255,255,79,255,255,255,0,31,255,255,255,79,255,255,255,0,0,2,244,0,15,255,255,255,0,0,2,244,0,15,192,0,63,0,0,2,249,90,143,192,0,63,0,63,255,255,255,207,192,0,63,0,63,255,255,255,207,192,0,63,0,63,234,149,84,15,192,0,63,0,0,0,4,60,15,192,0,63,0,6,31,46,62,15,192,0,63,0,11,207,31,31,79,192,0,63,0,15,143,79,11,207,192,0,63,0,15,79,75,71,223,255,255,255,0,47,11,139,131,143,255,255,255,0,63,11,134,64,15,255,255,255,0,189,5,0,0,15,192,0,63,0,40,0,0,0,15,192,0,42,0,
  // 0x9f4a  齊
  74,159,34,35,59,36,1,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,128,63,255,255,255,255,255,255,255,128,42,170,170,170,171,234,170,170,64,0,0,0,36,3,224,0,16,0,0,0,0,188,7,224,6,248,0,31,255,255,255,15,218,255,253,0,31,255,255,159,95,95,255,208,0,5,189,95,142,81,31,155,192,0,0,252,15,131,240,31,67,224,0,0,248,15,67,240,31,66,240,0,2,244,31,67,240,31,64,252,0,7,240,47,3,240,31,150,254,0,47,203,255,3,240,255,255,127,192,127,71,253,3,240,255,255,31,208,44,1,80,2,160,165,0,3,128,0,10,144,0,0,0,42,64,0,0,15,208,0,0,0,63,64,0,0,15,250,170,170,170,191,64,0,0,15,255,255,255,255,255,64,0,0,15,255,255,255,255,255,64,0,0,15,208,0,0,0,63,64,0,0,15,208,0,0,0,63,64,0,0,31,234,170,170,170,191,64,0,0,47,255,255,255,255,255,64,0,0,63,255,255,255,255,255,64,0,0,191,64,0,0,0,63,64,0,1,255,0,0,0,0,63,64,0,7,253,0,0,0,0,63,64,0,31,248,0,0,0,0,63,64,0,15,240,0,0,0,0,63,64,0,3,128,0,0,0,0,63,64,0,0,0,0,0,0,0,0,0,0,
  // 0xff1a  ：
  26,255,6,24,48,36,15,2,47,128,191,224,255,240,255,240,191,224,47,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,128,191,224,255,240,255,240,191,224,47,128,
};

#endif // HAS_GRAPHICAL_TFT
