/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Simplified Chinese 36pt, capital 'A' height: 26px, width: 100%, range: 0x201c-0xff1a, glyphs: 373
extern const uint8_t NotoSans_Medium_Simplified_Chinese_26[20454] = {
  162,26,28,32,26,255,34,247, // unifont_t
  // 0x201c  “
  28,32,13,10,40,14,0,16,1,160,6,128,3,240,15,192,7,240,31,192,15,224,47,128,15,208,63,64,47,192,191,0,63,192,255,0,63,192,255,0,127,129,254,0,0,0,0,0,
  // 0x201d  ”
  29,32,13,10,40,14,0,16,10,160,42,128,15,240,63,192,15,240,63,192,31,208,127,128,47,192,127,0,63,128,191,0,63,64,253,0,63,0,252,0,125,1,248,0,0,0,0,0,
  // 0x22bf  ⊿
  191,34,28,29,203,36,3,0,0,0,0,0,0,0,2,0,0,0,0,0,0,11,0,0,0,0,0,0,31,0,0,0,0,0,0,127,0,0,0,0,0,1,255,0,0,0,0,0,7,255,0,0,0,0,0,31,255,0,0,0,0,0,127,255,0,0,0,0,1,255,63,0,0,0,0,3,252,63,0,0,0,0,15,240,63,0,0,0,0,63,192,63,0,0,0,0,255,0,63,0,0,0,3,252,0,63,0,0,0,15,240,0,63,0,0,0,63,192,0,63,0,0,0,255,64,0,63,0,0,3,253,0,0,63,0,0,15,244,0,0,63,0,0,63,208,0,0,63,0,0,255,64,0,0,63,0,2,253,0,0,0,63,0,11,244,0,0,0,63,0,47,224,0,0,0,63,0,191,128,0,0,0,63,2,254,0,0,0,0,63,11,255,255,255,255,255,255,47,255,255,255,255,255,255,191,255,255,255,255,255,255,
  // 0x4e00  一
  0,78,34,4,36,36,1,12,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,127,255,255,255,255,255,255,255,208,42,170,170,170,170,170,170,170,144,
  // 0x4e09  三
  9,78,32,29,232,36,2,255,1,85,85,85,85,85,85,64,7,255,255,255,255,255,255,224,7,255,255,255,255,255,255,224,7,255,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,85,85,85,85,84,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,63,255,255,255,255,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,21,85,85,85,85,85,85,84,
  // 0x4e0a  上
  10,78,32,32,0,36,2,255,0,0,0,21,64,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,213,85,85,64,0,0,0,63,255,255,255,224,0,0,0,63,255,255,255,224,0,0,0,63,255,255,255,224,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,85,85,85,127,213,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x4e0b  下
  11,78,32,32,0,36,2,253,85,85,85,85,85,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,253,0,0,0,0,0,0,47,255,208,0,0,0,0,0,47,255,252,0,0,0,0,0,47,223,255,128,0,0,0,0,47,194,255,244,0,0,0,0,47,192,127,255,0,0,0,0,47,192,11,255,208,0,0,0,47,192,0,255,240,0,0,0,47,192,0,47,192,0,0,0,47,192,0,7,64,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,31,192,0,0,0,
  // 0x4e0d  不
  13,78,33,32,32,36,2,253,21,85,85,85,85,85,85,84,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,0,0,0,2,255,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,0,255,240,0,0,0,0,0,0,3,255,242,224,0,0,0,0,0,15,255,251,252,0,0,0,0,0,63,255,247,255,64,0,0,0,0,255,207,240,255,224,0,0,0,7,255,79,240,47,252,0,0,0,31,253,15,240,7,255,64,0,0,191,240,15,240,1,255,208,0,7,255,192,15,240,0,63,248,0,47,254,0,15,240,0,15,254,0,255,248,0,15,240,0,2,255,64,191,208,0,15,240,0,0,253,0,62,0,0,15,240,0,0,52,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,15,240,0,0,0,0,
  // 0x4e13  专
  19,78,32,35,24,36,2,252,0,0,0,127,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,254,0,0,0,0,3,255,255,255,255,255,255,192,3,255,255,255,255,255,255,192,3,255,255,255,255,255,255,192,0,0,3,244,0,0,0,0,0,0,7,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,15,208,0,0,0,0,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,253,255,255,255,255,255,255,255,253,0,0,127,64,0,0,0,0,0,0,191,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,253,0,0,0,0,0,0,2,255,255,255,255,255,0,0,3,255,255,255,255,255,192,0,3,255,255,255,255,255,0,0,0,0,0,0,11,252,0,0,0,0,0,0,47,240,0,0,0,0,0,0,191,192,0,0,0,0,0,2,255,0,0,0,0,190,64,11,252,0,0,0,1,255,249,47,240,0,0,0,1,191,255,255,208,0,0,0,0,6,255,255,128,0,0,0,0,0,31,255,244,0,0,0,0,0,0,191,255,64,0,0,0,0,0,11,255,208,0,0,0,0,0,0,127,192,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x4e1d  丝
  29,78,32,32,0,36,2,255,0,0,144,0,0,2,64,0,0,1,252,0,0,7,240,0,0,2,252,0,0,15,240,0,0,3,244,0,0,15,208,0,0,7,240,0,0,47,192,0,0,15,224,0,0,63,0,0,0,31,192,0,0,190,0,0,0,63,128,56,1,252,0,244,0,127,0,191,3,248,2,253,0,253,0,254,7,240,3,248,1,252,2,252,15,208,15,240,3,244,7,244,63,128,31,208,15,224,15,240,255,255,255,128,63,255,255,192,255,255,255,0,63,255,255,64,191,255,253,0,31,255,255,0,101,7,248,0,4,2,252,0,0,15,240,0,0,7,244,0,0,47,192,0,0,15,224,0,0,127,64,0,0,63,192,0,0,254,0,0,0,255,0,0,3,248,0,0,2,252,0,0,15,240,0,0,15,255,255,252,127,255,255,252,31,255,255,252,191,255,255,252,15,255,255,252,127,255,255,248,10,149,0,0,58,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x4e2a  个
  42,78,34,33,41,36,1,253,0,0,0,7,252,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,63,255,64,0,0,0,0,0,0,191,255,192,0,0,0,0,0,1,255,31,240,0,0,0,0,0,7,253,11,252,0,0,0,0,0,31,248,2,255,0,0,0,0,0,127,224,0,191,192,0,0,0,1,255,128,0,47,244,0,0,0,11,254,0,0,11,254,0,0,0,47,248,0,0,2,255,192,0,0,255,208,0,0,0,127,244,0,11,255,64,3,248,0,15,255,64,127,252,0,3,248,0,3,255,224,255,224,0,3,248,0,0,127,240,63,0,0,3,248,0,0,11,192,24,0,0,3,248,0,0,1,64,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,
  // 0x4e2d  中
  45,78,30,34,16,36,3,253,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,21,85,85,127,149,85,85,64,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,191,85,85,127,149,85,95,208,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,191,255,255,255,255,255,255,208,191,0,0,63,128,0,15,208,191,0,0,63,128,0,15,208,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,
  // 0x4e3a  为
  58,78,31,34,16,36,2,253,0,0,0,190,0,0,0,0,0,44,0,191,0,0,0,0,0,254,0,191,0,0,0,0,0,191,64,191,0,0,0,0,0,63,192,191,0,0,0,0,0,15,224,191,0,0,0,0,0,11,224,191,0,0,0,0,0,2,0,190,0,0,0,0,21,85,85,255,85,85,85,80,63,255,255,255,255,255,255,244,63,255,255,255,255,255,255,244,63,255,255,255,255,255,255,244,0,0,0,253,0,0,3,244,0,0,1,252,0,0,3,244,0,0,2,252,0,0,3,244,0,0,3,248,0,0,7,240,0,0,3,244,24,0,7,240,0,0,7,240,254,0,7,240,0,0,15,240,191,64,7,240,0,0,15,224,63,192,7,240,0,0,47,192,15,224,11,240,0,0,63,128,7,244,11,240,0,0,255,64,3,252,11,240,0,1,254,0,1,244,15,224,0,3,252,0,0,64,15,224,0,15,248,0,0,0,15,224,0,63,224,0,0,0,15,208,0,255,192,0,0,0,31,208,3,255,0,0,0,0,47,192,31,252,0,0,0,0,127,192,191,240,0,0,15,255,255,128,63,192,0,0,7,255,255,0,14,0,0,0,3,255,252,0,0,0,0,0,1,85,64,0,
  // 0x4e3b  主
  59,78,32,33,8,36,2,254,0,0,0,36,0,0,0,0,0,0,1,254,0,0,0,0,0,0,1,255,192,0,0,0,0,0,0,63,244,0,0,0,0,0,0,11,253,0,0,0,0,0,0,2,255,0,0,0,0,0,0,0,189,0,0,0,31,255,255,255,255,255,255,240,31,255,255,255,255,255,255,240,31,255,255,255,255,255,255,240,5,85,85,95,245,85,85,80,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,2,255,255,255,255,255,255,128,2,255,255,255,255,255,255,128,2,255,255,255,255,255,255,128,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,240,0,0,0,21,85,85,95,245,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x4e49  义
  73,78,34,34,50,36,1,253,0,0,0,6,128,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,7,240,0,3,224,0,0,4,0,3,248,0,7,244,0,0,190,0,2,252,0,15,240,0,0,127,0,0,253,0,15,224,0,0,63,128,0,190,0,47,192,0,0,47,192,0,127,0,63,192,0,0,15,208,0,32,0,127,64,0,0,11,240,0,0,0,255,0,0,0,3,248,0,0,1,253,0,0,0,2,252,0,0,3,252,0,0,0,0,254,0,0,11,244,0,0,0,0,191,64,0,31,240,0,0,0,0,63,192,0,63,192,0,0,0,0,31,240,0,191,64,0,0,0,0,11,248,1,255,0,0,0,0,0,3,254,7,252,0,0,0,0,0,0,255,79,244,0,0,0,0,0,0,127,255,208,0,0,0,0,0,0,31,255,128,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,31,255,128,0,0,0,0,0,0,191,255,240,0,0,0,0,0,7,255,111,254,0,0,0,0,0,47,252,7,255,208,0,0,0,2,255,224,0,255,253,0,0,0,47,255,64,0,31,255,208,0,7,255,248,0,0,2,255,254,64,127,255,128,0,0,0,47,255,208,63,248,0,0,0,0,2,255,64,14,64,0,0,0,0,0,31,0,0,0,0,0,0,0,0,0,0,
  // 0x4e4b  之
  75,78,34,34,50,36,1,253,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,7,255,255,255,255,255,255,244,0,7,255,255,255,255,255,255,253,0,7,255,255,255,255,255,255,252,0,1,85,85,85,85,85,95,244,0,0,0,0,0,0,0,47,224,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,0,255,64,0,0,0,0,0,0,3,253,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,191,192,0,0,0,0,0,0,2,255,0,0,0,0,1,0,0,11,252,0,0,0,0,11,224,0,47,240,0,0,0,0,15,224,0,191,192,0,0,0,0,31,208,2,255,0,0,0,0,0,63,192,15,252,0,0,0,0,0,127,240,127,240,0,0,0,0,0,255,249,255,192,0,0,0,0,1,255,255,254,0,0,0,0,0,3,252,255,244,0,0,0,0,0,11,244,63,248,0,0,0,0,0,15,240,15,255,229,0,0,0,0,63,208,2,255,255,255,255,255,208,191,192,0,47,255,255,255,255,192,47,64,0,1,175,255,255,255,128,6,0,0,0,0,1,85,85,0,
  // 0x4e86  了
  134,78,29,32,0,36,3,253,21,85,85,85,85,85,84,0,127,255,255,255,255,255,255,0,127,255,255,255,255,255,255,192,127,255,255,255,255,255,255,0,0,0,0,0,0,11,253,0,0,0,0,0,0,47,244,0,0,0,0,0,0,191,208,0,0,0,0,0,3,255,64,0,0,0,0,0,15,253,0,0,0,0,0,0,127,240,0,0,0,0,0,26,255,192,0,0,0,0,0,47,254,0,0,0,0,0,0,47,244,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,5,85,127,192,0,0,0,0,11,255,255,128,0,0,0,0,7,255,255,0,0,0,0,0,3,255,232,0,0,0,0,
  // 0x4e8c  二
  140,78,32,26,208,36,2,0,2,170,170,170,170,170,170,128,3,255,255,255,255,255,255,192,3,255,255,255,255,255,255,192,3,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,191,255,255,255,255,255,255,254,
  // 0x4e8e  于
  142,78,32,32,0,36,2,253,1,85,85,85,85,85,85,64,7,255,255,255,255,255,255,208,7,255,255,255,255,255,255,208,7,255,255,255,255,255,255,208,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,85,85,85,91,245,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,0,0,1,85,111,240,0,0,0,0,1,255,255,240,0,0,0,0,0,255,255,208,0,0,0,0,0,191,250,0,0,0,0,
  // 0x4ea4  交
  164,78,32,35,24,36,2,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,21,85,85,95,229,85,85,84,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,0,0,0,0,0,4,0,0,0,0,121,0,0,47,0,0,0,1,255,64,0,255,208,0,0,7,253,0,0,63,248,0,0,31,248,0,0,11,255,0,0,191,224,0,0,1,255,192,3,255,128,0,0,0,127,240,31,254,5,0,0,100,15,252,191,244,191,0,0,255,3,255,63,192,63,64,1,254,0,252,14,0,47,192,3,252,0,32,0,0,15,224,7,248,0,0,0,0,11,244,15,240,0,0,0,0,3,252,63,208,0,0,0,0,1,255,191,128,0,0,0,0,0,191,255,0,0,0,0,0,0,63,252,0,0,0,0,0,0,127,253,0,0,0,0,0,2,255,255,128,0,0,0,0,47,255,255,248,0,0,0,2,255,248,47,255,128,0,0,191,255,192,7,255,254,0,111,255,253,0,0,191,255,254,255,255,208,0,0,11,255,255,127,248,0,0,0,0,111,253,62,64,0,0,0,0,1,184,0,0,0,0,0,0,0,0,
  // 0x4eae  亮
  174,78,32,35,24,36,2,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,5,85,85,85,85,84,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,64,0,0,1,252,0,0,63,64,0,0,1,252,0,0,63,64,0,0,1,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,21,85,85,85,85,84,0,0,0,0,0,0,0,0,0,106,170,170,170,170,170,170,169,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,125,0,0,0,0,0,0,189,125,0,47,192,11,224,0,189,125,0,63,128,15,224,0,189,125,0,63,128,15,224,0,189,0,0,63,64,15,224,0,0,0,0,127,0,15,224,0,0,0,0,255,0,15,224,0,0,0,1,254,0,15,224,0,52,0,7,252,0,15,224,0,63,0,47,244,0,15,240,0,63,6,255,224,0,15,240,0,191,255,255,64,0,11,255,255,254,191,248,0,0,7,255,255,252,62,64,0,0,1,191,255,224,0,0,0,0,0,0,0,0,
  // 0x4ece  从
  206,78,34,32,32,36,1,253,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,0,254,0,0,63,128,0,0,0,0,253,0,0,63,128,0,0,0,0,253,0,0,63,64,0,0,0,1,253,0,0,63,64,0,0,0,1,253,0,0,63,128,0,0,0,1,252,0,0,127,192,0,0,0,2,252,0,0,127,192,0,0,0,2,252,0,0,191,192,0,0,0,3,252,0,0,191,192,0,0,0,3,248,0,0,255,208,0,0,0,3,253,0,0,255,224,0,0,0,7,255,0,1,255,240,0,0,0,7,255,192,2,255,240,0,0,0,11,255,224,3,255,248,0,0,0,15,255,244,3,250,252,0,0,0,15,231,252,7,245,252,0,0,0,31,210,255,15,240,253,0,0,0,47,192,255,95,240,255,0,0,0,63,192,63,111,208,127,64,0,0,127,128,46,63,192,63,192,0,0,255,0,8,255,64,47,208,0,1,255,0,1,255,0,15,240,0,3,253,0,3,253,0,11,252,0,7,252,0,15,252,0,3,254,0,15,244,0,63,240,0,1,255,128,63,240,0,255,208,0,0,255,224,127,208,0,255,128,0,0,63,192,31,128,0,46,0,0,0,15,0,2,0,0,4,0,0,0,1,0,
  // 0x4ee4  令
  228,78,34,34,50,36,1,253,0,0,0,7,248,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,47,255,64,0,0,0,0,0,0,191,255,192,0,0,0,0,0,1,255,31,240,0,0,0,0,0,7,253,11,252,0,0,0,0,0,31,244,2,255,64,0,0,0,0,127,224,0,191,208,0,0,0,2,255,64,0,47,248,0,0,0,11,253,0,0,11,255,0,0,0,63,244,0,0,1,255,208,0,1,255,255,255,255,255,255,248,0,15,255,31,255,255,255,143,255,128,127,248,31,255,255,255,130,255,224,63,208,0,0,0,0,0,127,192,14,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,255,255,255,255,255,255,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,15,208,0,0,0,0,63,0,0,31,208,0,0,0,0,63,0,63,255,192,0,0,0,0,63,0,63,255,192,0,0,0,0,63,0,47,254,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,
  // 0x4ee5  以
  229,78,34,31,23,36,1,253,0,127,0,0,0,0,11,240,0,0,127,0,0,0,0,15,240,0,0,127,0,8,0,0,15,224,0,0,127,0,191,0,0,15,224,0,0,127,0,127,128,0,15,208,0,0,127,0,47,208,0,31,208,0,0,127,0,15,244,0,47,192,0,0,127,0,7,252,0,47,192,0,0,63,0,2,253,0,63,128,0,0,63,64,0,255,0,63,128,0,0,63,64,0,191,64,127,64,0,0,63,64,0,61,0,191,0,0,0,63,64,0,16,0,254,0,0,0,63,64,0,0,1,253,0,0,0,63,64,0,0,2,252,0,0,0,63,64,0,0,3,252,0,0,0,63,64,0,0,11,244,0,0,0,63,128,4,0,15,240,0,0,0,63,128,124,0,47,224,0,0,0,63,139,253,0,127,244,0,0,0,63,255,254,0,255,253,0,0,0,63,255,228,3,255,255,0,0,7,255,254,0,15,252,191,192,0,127,255,224,0,63,240,63,240,0,127,253,0,1,255,208,15,252,0,63,128,0,11,255,64,3,255,0,40,0,0,127,253,0,1,255,128,0,0,11,255,240,0,0,127,208,0,0,31,255,128,0,0,47,224,0,0,7,248,0,0,0,15,64,0,0,1,128,0,0,0,1,0,
  // 0x4ef6  件
  246,78,34,34,50,36,1,253,0,0,144,0,0,21,0,0,0,0,0,253,0,0,191,0,0,0,0,2,252,10,64,191,0,0,0,0,3,248,15,208,191,0,0,0,0,7,240,15,192,191,0,0,0,0,15,240,31,192,191,0,0,0,0,31,208,47,128,191,0,0,0,0,63,192,63,149,191,85,84,0,0,127,64,63,255,255,255,254,0,0,255,0,191,255,255,255,254,0,2,255,0,255,255,255,255,254,0,7,255,1,252,0,191,0,0,0,15,255,3,248,0,191,0,0,0,63,255,7,244,0,191,0,0,0,191,255,11,240,0,191,0,0,0,127,127,0,128,0,191,0,0,0,44,63,0,0,0,191,0,0,0,4,63,0,0,0,191,0,0,0,0,63,11,255,255,255,255,255,208,0,63,11,255,255,255,255,255,208,0,63,11,255,255,255,255,255,208,0,63,1,85,85,191,85,85,64,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,191,0,0,0,0,63,0,0,0,190,0,0,0,
  // 0x4efd  份
  253,78,34,35,59,36,1,252,0,0,144,0,0,0,0,0,0,0,1,252,0,63,255,252,0,0,0,3,252,0,63,255,253,0,0,0,3,244,0,63,255,254,0,0,0,11,240,6,64,0,127,0,0,0,15,208,15,224,0,63,64,0,0,47,192,15,208,0,63,128,0,0,63,128,47,192,0,47,192,0,0,255,0,63,64,0,15,224,0,1,255,0,127,0,0,11,240,0,3,255,0,254,0,0,7,252,0,11,255,2,252,0,0,2,253,0,47,255,3,244,0,0,0,255,64,127,255,15,240,0,0,0,191,208,255,255,63,192,0,0,0,63,224,254,127,63,191,255,255,255,239,192,124,127,14,63,255,255,255,226,0,32,127,0,63,255,255,255,208,0,0,127,0,0,47,128,15,208,0,0,127,0,0,63,64,15,208,0,0,127,0,0,63,0,15,208,0,0,127,0,0,63,0,15,208,0,0,127,0,0,127,0,15,208,0,0,127,0,0,190,0,15,208,0,0,127,0,0,253,0,15,192,0,0,127,0,1,252,0,15,192,0,0,127,0,3,248,0,15,192,0,0,127,0,7,244,0,31,192,0,0,127,0,15,224,0,31,192,0,0,127,0,63,192,0,47,192,0,0,127,0,255,64,0,127,128,0,0,127,7,254,0,63,255,64,0,0,127,7,244,0,63,255,0,0,0,127,1,208,0,47,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4f11  休
  17,79,34,34,50,36,1,253,0,0,36,0,0,84,0,0,0,0,0,127,64,0,252,0,0,0,0,0,255,0,0,252,0,0,0,0,0,254,0,0,252,0,0,0,0,2,252,0,0,252,0,0,0,0,7,248,0,0,252,0,0,0,0,15,240,0,0,252,0,0,0,0,31,224,0,0,252,0,0,0,0,63,192,0,0,252,0,0,0,0,255,139,255,255,255,255,255,192,2,255,139,255,255,255,255,255,192,7,255,139,255,255,255,255,255,192,31,255,129,85,95,255,213,85,64,127,255,128,0,15,255,224,0,0,255,239,128,0,47,255,240,0,0,191,47,128,0,63,255,244,0,0,61,47,128,0,127,254,252,0,0,20,47,128,0,254,253,253,0,0,0,47,128,2,252,252,127,0,0,0,47,128,3,248,252,63,128,0,0,47,128,11,240,252,47,192,0,0,47,128,31,208,252,15,240,0,0,47,128,63,192,252,7,248,0,0,47,128,255,64,252,3,253,0,0,47,130,254,0,252,0,255,0,0,47,139,252,0,252,0,191,192,0,47,255,240,0,252,0,63,240,0,47,159,208,0,252,0,15,192,0,47,139,64,0,252,0,3,64,0,47,129,0,0,252,0,0,0,0,47,128,0,0,252,0,0,0,0,47,128,0,0,252,0,0,0,0,47,128,0,0,252,0,0,0,0,31,128,0,0,252,0,0,0,
  // 0x4f20  传
  32,79,34,35,59,36,1,252,0,0,144,0,2,144,0,0,0,0,1,252,0,3,244,0,0,0,0,2,252,0,7,240,0,0,0,0,3,244,0,11,240,0,0,0,0,11,241,255,255,255,255,254,0,0,15,225,255,255,255,255,254,0,0,47,193,255,255,255,255,254,0,0,63,128,0,47,192,0,0,0,0,255,0,0,63,128,0,0,0,1,255,0,0,63,64,0,0,0,3,255,0,0,127,0,0,0,0,15,255,31,255,255,255,255,255,208,47,255,31,255,255,255,255,255,208,191,255,31,255,255,255,255,255,208,255,191,0,2,252,0,0,0,0,189,127,0,3,248,0,0,0,0,56,127,0,3,244,0,0,0,0,16,127,0,7,240,0,0,0,0,0,127,0,11,255,255,255,244,0,0,127,0,15,255,255,255,253,0,0,127,0,31,255,255,255,248,0,0,127,0,0,0,0,47,240,0,0,127,0,0,0,0,127,192,0,0,127,0,0,0,0,255,0,0,0,127,0,0,20,3,252,0,0,0,127,0,0,126,15,244,0,0,0,127,0,0,255,255,208,0,0,0,127,0,0,47,255,64,0,0,0,127,0,0,7,255,0,0,0,0,127,0,0,0,255,208,0,0,0,127,0,0,0,47,248,0,0,0,127,0,0,0,11,253,0,0,0,127,0,0,0,1,248,0,0,0,127,0,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4f4d  位
  77,79,34,34,50,36,1,253,0,0,100,0,0,168,0,0,0,0,0,254,0,0,253,0,0,0,0,1,253,0,0,253,0,0,0,0,3,252,0,0,253,0,0,0,0,7,244,0,0,253,0,0,0,0,15,240,0,0,253,0,0,0,0,31,208,0,0,253,0,0,0,0,63,195,255,255,255,255,255,192,0,191,67,255,255,255,255,255,192,1,255,67,255,255,255,255,255,192,3,255,64,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,47,255,64,5,128,0,11,144,0,191,255,64,15,192,0,15,240,0,255,127,64,15,208,0,15,224,0,125,63,64,11,224,0,15,208,0,56,63,64,7,240,0,31,192,0,0,63,64,3,240,0,47,192,0,0,63,64,3,244,0,63,128,0,0,63,64,3,248,0,63,64,0,0,63,64,2,248,0,127,0,0,0,63,64,1,252,0,127,0,0,0,63,64,1,252,0,254,0,0,0,63,64,0,252,0,253,0,0,0,63,64,0,253,1,252,0,0,0,63,64,0,253,2,252,0,0,0,63,64,0,254,3,244,0,0,0,63,64,0,80,3,240,0,0,0,63,64,0,0,7,240,0,0,0,63,75,255,255,255,255,255,224,0,63,75,255,255,255,255,255,224,0,63,75,255,255,255,255,255,224,0,63,64,0,0,0,0,0,0,0,42,0,0,0,0,0,0,0,
  // 0x4f4e  低
  78,79,34,34,50,36,1,253,0,0,144,0,0,0,0,0,0,0,1,252,0,0,0,0,96,0,0,2,252,0,0,0,111,248,0,0,3,244,0,5,191,255,254,0,0,11,240,251,255,255,255,228,0,0,15,224,255,255,255,228,0,0,0,47,192,255,254,95,192,0,0,0,63,128,254,0,15,192,0,0,0,191,0,253,0,15,208,0,0,1,255,0,253,0,15,208,0,0,3,255,0,253,0,15,208,0,0,11,255,0,253,0,15,208,0,0,31,255,0,253,0,15,208,0,0,127,255,0,255,255,255,255,255,208,255,255,0,255,255,255,255,255,208,254,127,0,255,255,255,255,255,208,124,127,0,253,0,7,240,0,0,32,127,0,253,0,7,240,0,0,0,127,0,253,0,3,240,0,0,0,127,0,253,0,3,244,0,0,0,127,0,253,0,3,248,0,0,0,127,0,253,0,2,252,0,0,0,127,0,253,0,1,252,0,0,0,127,0,253,1,172,253,0,0,0,127,0,255,255,252,254,0,0,0,127,15,255,255,252,191,2,208,0,127,15,255,254,144,63,66,240,0,127,11,249,0,0,63,194,240,0,127,0,0,0,0,31,227,240,0,127,0,0,0,0,15,255,224,0,127,3,255,255,255,227,255,208,0,127,3,255,255,255,225,255,128,0,127,3,255,255,255,224,21,0,0,106,0,0,0,0,0,0,0,
  // 0x4f53  体
  83,79,34,34,50,36,1,253,0,1,144,0,1,248,0,0,0,0,3,248,0,1,252,0,0,0,0,3,244,0,1,252,0,0,0,0,11,240,0,1,252,0,0,0,0,15,224,0,1,252,0,0,0,0,31,192,0,1,252,0,0,0,0,63,128,0,1,252,0,0,0,0,127,15,255,255,255,255,255,192,0,255,15,255,255,255,255,255,192,2,255,15,255,255,255,255,255,192,3,255,0,0,31,255,192,0,0,15,255,0,0,47,255,208,0,0,47,255,0,0,63,255,240,0,0,127,255,0,0,127,255,240,0,0,255,191,0,0,253,253,248,0,0,62,127,0,1,249,252,252,0,0,44,127,0,3,241,252,190,0,0,0,127,0,11,241,252,63,0,0,0,127,0,15,209,252,47,128,0,0,127,0,47,129,252,15,208,0,0,127,0,127,1,252,11,240,0,0,127,0,254,1,252,3,252,0,0,127,3,252,1,252,1,254,0,0,127,15,244,1,252,0,255,128,0,127,47,235,255,255,255,127,208,0,127,127,203,255,255,255,31,224,0,127,31,11,255,255,255,11,128,0,127,8,0,1,252,0,2,0,0,127,0,0,1,252,0,0,0,0,127,0,0,1,252,0,0,0,0,127,0,0,1,252,0,0,0,0,127,0,0,1,252,0,0,0,0,127,0,0,1,252,0,0,0,0,126,0,0,0,168,0,0,0,
  // 0x4f59  余
  89,79,34,35,59,36,1,252,0,0,0,7,248,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,63,255,128,0,0,0,0,0,0,255,191,208,0,0,0,0,0,3,255,15,248,0,0,0,0,0,15,252,3,254,0,0,0,0,0,63,240,0,255,192,0,0,0,1,255,192,0,63,244,0,0,0,11,254,0,0,11,255,0,0,0,127,244,0,0,1,255,208,0,3,255,208,0,0,0,63,254,0,47,255,255,255,255,255,251,255,208,127,245,255,255,255,255,241,255,192,31,65,255,255,255,255,240,31,64,4,0,0,3,248,0,0,1,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,7,255,255,255,255,255,255,254,0,7,255,255,255,255,255,255,254,0,7,255,255,255,255,255,255,254,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,144,3,248,0,208,0,0,0,3,252,3,248,7,248,0,0,0,11,244,3,248,7,254,0,0,0,47,224,3,248,0,255,192,0,0,191,192,3,248,0,63,240,0,2,255,0,3,248,0,15,252,0,31,252,0,3,248,0,3,255,0,63,240,0,3,248,0,0,255,128,31,128,15,255,244,0,0,62,0,5,0,7,255,240,0,0,20,0,0,0,3,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4f5c  作
  92,79,34,34,50,36,1,253,0,0,100,0,4,0,0,0,0,0,0,191,0,47,128,0,0,0,0,0,253,0,63,64,0,0,0,0,2,252,0,127,0,0,0,0,0,3,248,0,254,0,0,0,0,0,11,240,1,253,0,0,0,0,0,15,224,3,255,255,255,255,224,0,47,192,7,255,255,255,255,224,0,127,128,15,255,255,255,255,224,0,255,64,31,210,252,0,0,0,2,255,64,63,193,252,0,0,0,7,255,64,191,1,252,0,0,0,15,255,65,254,1,252,0,0,0,63,255,71,252,1,252,0,0,0,191,255,75,244,1,255,255,255,128,63,63,66,208,1,255,255,255,128,29,63,64,64,1,255,255,255,128,4,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,255,255,255,192,0,63,64,0,1,255,255,255,192,0,63,64,0,1,255,255,255,192,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,0,1,252,0,0,0,
  // 0x4f7f  使
  127,79,34,35,59,36,1,252,0,0,116,0,0,189,0,0,0,0,0,254,0,0,190,0,0,0,0,1,252,0,0,190,0,0,0,0,3,252,0,0,190,0,0,0,0,7,251,255,255,255,255,255,224,0,15,243,255,255,255,255,255,224,0,31,211,255,255,255,255,255,224,0,63,192,0,0,190,0,0,0,0,191,64,0,0,190,0,0,0,1,255,64,0,0,190,0,0,0,3,255,64,255,255,255,255,255,64,15,255,65,255,255,255,255,255,64,47,255,65,255,255,255,255,255,64,191,255,65,252,0,190,0,47,64,255,127,65,252,0,190,0,47,64,126,63,65,252,0,190,0,47,64,60,63,65,252,0,190,0,47,64,16,63,65,252,0,190,0,47,64,0,63,65,255,255,255,255,255,64,0,63,65,255,255,255,255,255,64,0,63,64,255,255,255,255,255,64,0,63,64,20,0,252,0,0,0,0,63,64,253,1,252,0,0,0,0,63,64,127,2,252,0,0,0,0,63,64,63,195,248,0,0,0,0,63,64,15,251,240,0,0,0,0,63,64,3,255,224,0,0,0,0,63,64,0,255,224,0,0,0,0,63,64,1,255,253,0,0,0,0,63,64,11,255,255,244,0,0,0,63,65,255,244,191,255,233,0,0,63,95,255,208,11,255,255,224,0,63,75,253,0,0,111,255,192,0,63,67,144,0,0,0,111,64,0,0,0,0,0,0,0,0,0,
  // 0x4f9b  供
  155,79,34,34,50,36,1,253,0,0,144,1,164,0,42,0,0,0,0,253,1,252,0,63,0,0,0,2,252,1,252,0,63,0,0,0,3,248,1,252,0,63,0,0,0,7,240,1,252,0,63,0,0,0,15,224,1,252,0,63,0,0,0,31,192,1,252,0,63,0,0,0,63,128,2,252,0,63,64,0,0,191,3,255,255,255,255,255,192,1,255,3,255,255,255,255,255,192,3,255,3,255,255,255,255,255,192,11,255,0,1,252,0,63,0,0,47,255,0,1,252,0,63,0,0,127,255,0,1,252,0,63,0,0,255,191,0,1,252,0,63,0,0,126,127,0,1,252,0,63,0,0,56,127,0,1,252,0,63,0,0,16,127,0,1,252,0,63,0,0,0,127,0,1,252,0,63,0,0,0,127,11,255,255,255,255,255,224,0,127,11,255,255,255,255,255,224,0,127,11,255,255,255,255,255,224,0,127,1,85,85,85,85,85,64,0,127,0,0,0,0,0,0,0,0,127,0,0,160,0,9,0,0,0,127,0,2,253,0,127,0,0,0,127,0,3,248,0,63,192,0,0,127,0,15,240,0,31,240,0,0,127,0,63,208,0,7,248,0,0,127,0,191,128,0,2,253,0,0,127,2,255,0,0,0,255,0,0,127,15,252,0,0,0,63,192,0,127,3,240,0,0,0,31,128,0,127,0,128,0,0,0,8,0,
  // 0x4fb5  侵
  181,79,34,35,59,36,1,252,0,0,144,0,0,0,0,0,0,0,1,252,42,170,170,170,164,0,0,3,252,127,255,255,255,252,0,0,3,244,127,255,255,255,252,0,0,11,240,0,0,0,1,252,0,0,15,224,0,0,0,1,252,0,0,47,192,21,85,85,86,252,0,0,63,128,47,255,255,255,252,0,0,255,0,47,255,255,255,252,0,2,255,0,0,0,0,1,252,0,3,255,0,0,0,0,1,252,0,15,255,0,255,255,255,255,252,0,63,255,0,255,255,255,255,252,0,191,255,0,106,170,170,170,168,0,255,191,0,0,0,0,0,0,0,189,127,6,170,170,170,170,170,128,52,127,11,255,255,255,255,255,192,0,127,11,255,255,255,255,255,192,0,127,11,208,0,0,0,15,192,0,127,11,208,0,0,0,15,192,0,127,11,234,170,170,170,159,192,0,127,11,255,255,255,255,255,192,0,127,0,63,255,255,255,240,0,0,127,0,2,240,0,31,208,0,0,127,0,3,252,0,127,192,0,0,127,0,1,254,1,255,0,0,0,127,0,0,127,203,253,0,0,0,127,0,0,31,255,240,0,0,0,127,0,0,11,255,208,0,0,0,127,0,0,191,255,253,0,0,0,127,1,111,255,255,255,249,64,0,127,15,255,254,1,255,255,224,0,127,3,255,208,0,11,255,192,0,126,3,228,0,0,0,27,0,0,0,0,0,0,0,0,0,0,
  // 0x4fdd  保
  221,79,34,35,59,36,1,252,0,0,80,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,253,63,255,255,255,253,0,0,2,252,63,255,255,255,253,0,0,3,244,63,255,255,255,253,0,0,11,240,63,0,0,0,253,0,0,15,208,63,0,0,0,253,0,0,47,192,63,0,0,0,253,0,0,127,128,63,0,0,0,253,0,0,255,64,63,0,0,0,253,0,2,255,64,63,0,0,0,253,0,7,255,64,63,255,255,255,253,0,31,255,64,63,255,255,255,253,0,63,255,64,63,255,255,255,253,0,255,191,64,0,0,254,0,0,0,127,63,64,0,0,254,0,0,0,60,63,64,0,0,254,0,0,0,16,63,64,0,0,254,0,0,0,0,63,75,255,255,255,255,255,208,0,63,75,255,255,255,255,255,208,0,63,75,255,255,255,255,255,208,0,63,64,0,15,255,224,0,0,0,63,64,0,47,255,244,0,0,0,63,64,0,127,255,252,0,0,0,63,64,1,254,254,191,0,0,0,63,64,7,252,254,63,192,0,0,63,64,31,240,254,15,240,0,0,63,64,127,192,254,7,252,0,0,63,66,255,64,254,2,255,64,0,63,95,253,0,254,0,191,224,0,63,79,240,0,254,0,47,224,0,63,71,128,0,254,0,7,128,0,63,64,0,0,254,0,0,0,0,63,64,0,0,254,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x4fe1  信
  225,79,34,34,50,36,1,253,0,0,184,0,0,0,0,0,0,0,0,254,10,170,170,170,160,0,0,1,252,15,255,255,255,244,0,0,3,248,15,255,255,255,244,0,0,7,244,0,0,0,0,0,0,0,15,240,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,63,199,255,255,255,255,255,224,0,191,71,255,255,255,255,255,224,1,255,71,255,255,255,255,255,208,3,255,64,0,0,0,0,0,0,11,255,64,0,0,0,0,0,0,47,255,64,47,255,255,255,252,0,191,255,64,47,255,255,255,252,0,255,127,64,26,170,170,170,168,0,125,63,64,0,0,0,0,0,0,56,63,64,0,0,0,0,0,0,0,63,64,47,255,255,255,252,0,0,63,64,47,255,255,255,252,0,0,63,64,26,170,170,170,168,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,42,170,170,170,168,0,0,63,64,63,255,255,255,253,0,0,63,64,63,255,255,255,253,0,0,63,64,63,0,0,0,253,0,0,63,64,63,0,0,0,253,0,0,63,64,63,0,0,0,253,0,0,63,64,63,0,0,0,253,0,0,63,64,63,170,170,170,253,0,0,63,64,63,255,255,255,253,0,0,63,64,63,255,255,255,253,0,0,63,64,63,0,0,0,253,0,0,42,0,63,0,0,0,168,0,
  // 0x503c  值
  60,80,34,34,50,36,1,253,0,0,144,0,0,170,0,0,0,0,1,252,0,0,254,0,0,0,0,2,252,0,0,253,0,0,0,0,3,244,0,0,253,0,0,0,0,7,243,255,255,255,255,255,64,0,15,227,255,255,255,255,255,64,0,47,195,255,255,255,255,255,64,0,63,128,0,2,244,0,0,0,0,191,0,0,3,240,0,0,0,1,254,0,42,171,250,170,160,0,3,254,0,63,255,255,255,244,0,11,254,0,63,255,255,255,244,0,31,254,0,62,0,0,2,244,0,63,254,0,62,0,0,2,244,0,191,254,0,62,0,0,2,244,0,127,126,0,63,255,255,255,244,0,44,126,0,63,255,255,255,244,0,20,126,0,63,85,85,87,244,0,0,126,0,62,0,0,2,244,0,0,126,0,62,0,0,2,244,0,0,126,0,63,255,255,255,244,0,0,126,0,63,255,255,255,244,0,0,126,0,63,85,85,87,244,0,0,126,0,62,0,0,2,244,0,0,126,0,62,0,0,2,244,0,0,126,0,63,255,255,255,244,0,0,126,0,63,255,255,255,244,0,0,126,0,63,85,85,87,244,0,0,126,0,62,0,0,2,244,0,0,126,0,62,0,0,2,244,0,0,126,31,255,255,255,255,255,208,0,126,47,255,255,255,255,255,208,0,126,47,255,255,255,255,255,208,0,126,0,0,0,0,0,0,0,
  // 0x503e  倾
  62,80,34,35,59,36,1,252,0,10,64,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,31,192,0,63,255,255,255,208,0,47,128,0,63,255,255,255,208,0,63,15,192,63,255,255,255,208,0,127,15,192,0,2,252,0,0,0,253,15,192,0,3,244,0,0,1,252,15,192,0,3,240,0,0,3,252,15,192,11,255,255,255,0,7,252,15,192,11,255,255,255,0,15,252,15,192,11,255,255,255,0,47,252,15,255,203,208,0,63,0,63,252,15,255,203,208,80,63,0,255,252,15,255,203,209,244,63,0,253,252,15,192,11,209,244,63,0,188,252,15,192,11,209,244,63,0,48,252,15,192,11,209,244,63,0,16,252,15,192,11,209,244,63,0,0,252,15,192,11,209,244,63,0,0,252,15,192,11,209,244,63,0,0,252,15,192,11,209,244,63,0,0,252,15,193,139,209,240,63,0,0,252,15,223,203,210,240,63,0,0,252,15,255,203,210,240,63,0,0,252,31,255,11,211,240,63,0,0,252,63,244,6,135,224,21,0,0,252,31,128,0,15,213,0,0,0,252,12,0,0,31,207,128,0,0,252,0,0,0,127,95,240,0,0,252,0,0,1,254,7,253,0,0,252,0,0,11,252,0,255,128,0,252,0,0,127,224,0,47,208,0,252,0,0,191,64,0,11,192,0,252,0,0,56,0,0,2,0,0,0,0,0,0,0,0,0,0,
  // 0x504f  偏
  79,80,34,34,50,36,1,253,0,2,64,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,11,231,255,255,255,255,255,208,0,15,215,255,255,255,255,255,208,0,31,199,255,255,255,255,255,208,0,63,128,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,191,0,255,255,255,255,255,0,0,253,0,255,255,255,255,255,0,3,253,0,254,170,170,170,191,0,7,253,0,252,0,0,0,127,0,15,253,0,252,0,0,0,127,0,47,253,0,252,0,0,0,127,0,127,253,0,255,255,255,255,255,0,255,253,0,255,255,255,255,255,0,254,189,0,254,170,170,170,170,0,124,189,0,252,0,0,0,0,0,48,189,0,252,0,0,0,0,0,0,189,1,255,255,255,255,255,128,0,189,1,255,255,255,255,255,128,0,189,2,255,235,250,254,175,128,0,189,2,255,194,240,124,31,128,0,189,3,255,194,240,124,31,128,0,189,3,255,194,240,124,31,128,0,189,7,255,235,250,254,175,128,0,189,11,239,255,255,255,255,128,0,189,15,223,255,255,255,255,128,0,189,31,207,194,240,124,31,128,0,189,63,143,194,240,124,31,128,0,189,127,15,194,240,124,31,128,0,189,254,15,194,240,124,31,128,0,189,60,15,194,240,125,255,128,0,189,4,15,194,240,124,255,64,0,189,0,15,129,160,104,253,0,
  // 0x505c  停
  92,80,34,34,50,36,1,253,0,0,144,0,0,253,0,0,0,0,1,252,0,0,253,0,0,0,0,3,252,0,0,253,0,0,0,0,3,251,255,255,255,255,255,208,0,11,247,255,255,255,255,255,208,0,15,215,255,255,255,255,255,208,0,63,192,0,0,0,0,0,0,0,127,64,0,0,0,0,0,0,0,255,0,63,255,255,255,248,0,2,255,0,63,255,255,255,248,0,7,255,0,63,85,85,86,248,0,15,255,0,63,64,0,2,248,0,63,255,0,63,64,0,2,248,0,255,255,0,63,255,255,255,248,0,255,127,0,63,255,255,255,248,0,188,127,0,21,85,85,85,80,0,52,127,0,0,0,0,0,0,0,16,127,10,170,170,170,170,170,144,0,127,15,255,255,255,255,255,224,0,127,15,255,255,255,255,255,224,0,127,15,192,0,0,0,7,224,0,127,15,192,0,0,0,7,224,0,127,15,198,170,170,170,151,224,0,127,15,203,255,255,255,215,224,0,127,0,11,255,255,255,208,0,0,127,0,0,0,253,0,0,0,0,127,0,0,0,253,0,0,0,0,127,0,0,0,253,0,0,0,0,127,0,0,0,253,0,0,0,0,127,0,0,0,253,0,0,0,0,127,0,0,0,253,0,0,0,0,127,0,3,255,253,0,0,0,0,127,0,1,255,252,0,0,0,0,126,0,0,255,224,0,0,0,
  // 0x50a8  储
  168,80,34,34,50,36,1,253,0,15,64,0,0,47,64,0,0,0,15,192,0,0,63,64,14,64,0,31,130,0,0,63,64,31,192,0,47,95,192,0,63,64,63,64,0,63,15,224,63,255,255,127,0,0,126,3,248,63,255,255,254,0,0,253,1,253,63,255,255,252,0,0,252,0,189,0,63,67,248,0,2,248,0,48,0,63,75,240,0,3,248,0,0,0,63,79,208,0,11,248,0,0,0,63,127,192,0,15,248,0,0,255,255,255,255,208,47,248,255,240,255,255,255,255,208,127,248,255,240,255,255,255,255,208,255,248,255,240,0,31,240,0,0,189,248,2,240,0,127,192,0,0,56,248,2,240,1,255,64,0,0,32,248,2,240,11,253,0,0,0,0,248,2,240,63,255,255,255,0,0,248,2,241,255,255,255,255,0,0,248,2,242,255,250,170,191,0,0,248,2,240,255,240,0,63,0,0,248,2,240,19,240,0,63,0,0,248,2,240,3,249,85,127,0,0,248,2,240,3,255,255,255,0,0,248,2,240,3,255,255,255,0,0,248,2,242,227,240,0,63,0,0,248,3,255,243,240,0,63,0,0,248,3,255,211,240,0,63,0,0,248,15,254,3,250,170,191,0,0,248,11,244,3,255,255,255,0,0,248,3,128,3,255,255,255,0,0,248,0,0,3,240,0,63,0,0,248,0,0,2,240,0,42,0,
  // 0x50cf  像
  207,80,34,34,50,36,1,253,0,2,64,1,164,0,0,0,0,0,7,240,3,248,0,0,0,0,0,11,240,11,249,85,144,0,0,0,15,208,31,255,255,248,0,0,0,31,192,63,255,255,244,0,0,0,63,128,255,0,11,240,0,0,0,63,66,253,0,31,208,0,0,0,191,11,253,85,127,213,85,0,0,254,63,255,255,255,255,255,0,3,253,127,255,255,255,255,255,0,7,253,11,240,0,252,0,63,0,15,253,3,240,0,252,0,63,0,47,253,3,240,0,252,0,63,0,191,253,3,255,255,255,255,255,0,255,253,3,255,255,255,255,255,0,188,189,1,85,191,219,229,85,0,120,189,0,2,255,7,224,1,0,32,189,0,111,255,3,240,15,64,0,189,11,255,239,194,244,127,192,0,189,47,253,15,225,249,255,0,0,189,11,144,47,244,255,252,0,0,189,0,1,255,252,255,224,0,0,189,0,31,248,253,127,64,0,0,189,1,255,192,190,63,64,0,0,189,31,253,2,255,47,192,0,0,189,15,224,11,255,15,224,0,0,189,1,0,127,255,75,240,0,0,189,0,2,255,63,67,252,0,0,189,0,47,248,63,64,255,0,0,189,2,255,208,63,0,191,208,0,189,63,253,0,191,0,47,192,0,189,47,225,255,253,0,11,64,0,189,10,0,255,248,0,1,0,0,189,0,0,255,208,0,0,0,
  // 0x5145  充
  69,81,33,35,59,36,2,252,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,0,0,15,240,0,20,0,0,0,0,0,31,208,0,124,0,0,0,0,0,63,192,1,255,64,0,0,0,0,63,64,0,127,208,0,0,0,0,191,0,0,31,244,0,0,0,0,253,0,0,7,253,0,0,0,2,254,170,255,255,255,64,0,31,255,255,255,255,255,255,208,0,31,255,255,255,255,255,255,240,0,31,255,255,234,149,80,7,252,0,9,80,0,0,0,0,2,248,0,0,0,31,192,3,240,0,208,0,0,0,47,192,3,240,0,0,0,0,0,63,192,3,240,0,0,0,0,0,63,128,3,240,0,0,0,0,0,63,128,3,240,0,0,0,0,0,127,64,3,240,0,0,0,0,0,191,0,3,240,0,16,0,0,0,255,0,3,240,0,46,0,0,2,253,0,3,240,0,47,64,0,7,252,0,3,240,0,47,64,0,31,244,0,3,240,0,47,64,0,191,224,0,3,240,0,63,0,27,255,128,0,3,248,0,127,0,255,253,0,0,3,255,255,255,0,191,224,0,0,1,255,255,253,0,62,0,0,0,0,127,255,244,0,0,0,0,0,0,0,0,0,0,
  // 0x5148  先
  72,81,32,35,24,36,2,252,0,0,0,11,224,0,0,0,0,11,144,11,224,0,0,0,0,15,224,11,224,0,0,0,0,15,208,11,224,0,0,0,0,31,192,11,224,0,0,0,0,63,192,11,240,0,0,0,0,63,255,255,255,255,255,192,0,191,255,255,255,255,255,192,0,255,255,255,255,255,255,192,1,252,0,11,224,0,0,0,3,248,0,11,224,0,0,0,11,240,0,11,224,0,0,0,15,224,0,11,224,0,0,0,3,192,0,11,224,0,0,0,0,0,0,11,224,0,0,0,0,0,0,11,240,0,0,0,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,0,0,63,128,3,240,0,0,0,0,63,64,3,240,0,0,0,0,63,64,3,240,0,0,0,0,127,0,3,240,0,0,0,0,191,0,3,240,0,0,0,0,254,0,3,240,0,0,0,2,252,0,3,240,0,52,0,7,252,0,3,240,0,63,0,15,240,0,3,240,0,63,0,127,224,0,3,240,0,63,2,255,192,0,3,244,0,191,111,254,0,0,3,255,255,254,255,248,0,0,2,255,255,252,63,192,0,0,0,191,255,244,25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5149  光
  73,81,34,35,59,36,1,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,1,0,0,0,109,0,3,248,0,7,224,0,0,255,0,3,248,0,15,240,0,0,127,64,3,248,0,15,224,0,0,63,192,3,248,0,47,192,0,0,31,208,3,248,0,63,128,0,0,15,240,3,248,0,127,0,0,0,7,244,3,248,0,254,0,0,0,3,248,3,248,2,252,0,0,0,2,252,3,248,3,248,0,0,0,1,208,3,248,0,96,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,15,240,0,252,0,0,0,0,0,15,224,0,252,0,0,0,0,0,15,208,0,252,0,0,0,0,0,15,208,0,252,0,0,0,0,0,31,192,0,252,0,0,0,0,0,47,192,0,252,0,0,0,0,0,63,192,0,252,0,0,0,0,0,127,64,0,252,0,0,0,0,0,255,0,0,252,0,10,0,0,2,254,0,0,252,0,11,208,0,7,252,0,0,252,0,11,208,0,31,244,0,0,252,0,15,208,0,191,224,0,0,252,0,15,192,27,255,128,0,0,253,0,31,192,127,254,0,0,0,255,255,255,128,47,240,0,0,0,191,255,255,64,14,0,0,0,0,31,255,253,0,0,0,0,0,0,0,0,0,0,
  // 0x5165  入
  101,81,34,32,32,36,1,253,0,2,255,255,252,0,0,0,0,0,2,255,255,252,0,0,0,0,0,2,255,255,252,0,0,0,0,0,1,85,85,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,5,255,0,0,0,0,0,0,0,11,255,0,0,0,0,0,0,0,15,255,0,0,0,0,0,0,0,15,255,64,0,0,0,0,0,0,47,255,128,0,0,0,0,0,0,63,255,192,0,0,0,0,0,0,63,223,192,0,0,0,0,0,0,127,79,224,0,0,0,0,0,0,255,11,240,0,0,0,0,0,1,254,7,248,0,0,0,0,0,3,253,3,252,0,0,0,0,0,7,252,2,254,0,0,0,0,0,15,244,0,255,0,0,0,0,0,31,240,0,191,192,0,0,0,0,63,192,0,63,224,0,0,0,0,255,128,0,31,244,0,0,0,2,255,0,0,11,252,0,0,0,11,253,0,0,3,255,0,0,0,47,244,0,0,0,255,208,0,0,191,224,0,0,0,127,244,0,3,255,128,0,0,0,31,254,0,47,254,0,0,0,0,7,255,208,127,248,0,0,0,0,0,255,192,15,208,0,0,0,0,0,47,0,2,0,0,0,0,0,0,5,0,
  // 0x5168  全
  104,81,34,33,41,36,1,254,0,0,0,7,252,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,47,255,64,0,0,0,0,0,0,127,191,192,0,0,0,0,0,1,255,15,240,0,0,0,0,0,7,252,7,252,0,0,0,0,0,15,240,1,255,0,0,0,0,0,63,208,0,127,192,0,0,0,1,255,64,0,31,244,0,0,0,7,252,0,0,3,254,0,0,0,47,240,0,0,0,255,192,0,0,255,192,0,0,0,47,244,0,11,254,0,0,0,0,7,255,0,63,255,255,255,255,255,255,255,208,127,235,255,255,255,255,254,191,192,31,71,255,255,255,255,254,31,64,8,0,0,3,248,0,0,1,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,15,255,255,255,255,255,255,255,64,15,255,255,255,255,255,255,255,64,15,255,255,255,255,255,255,255,64,
  // 0x5171  共
  113,81,32,34,16,36,2,253,0,0,168,0,0,42,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,1,253,0,0,191,64,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,85,85,254,85,85,191,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,0,0,120,0,0,0,0,255,128,3,255,0,0,0,3,255,0,0,255,208,0,0,15,252,0,0,47,248,0,0,127,240,0,0,11,255,0,2,255,192,0,0,1,255,192,31,254,0,0,0,0,127,240,127,244,0,0,0,0,15,253,47,208,0,0,0,0,3,248,10,0,0,0,0,0,0,144,
  // 0x5173  关
  115,81,26,35,245,36,5,252,0,4,0,0,3,128,0,0,188,0,0,11,244,0,0,255,0,0,15,240,0,0,63,128,0,31,208,0,0,47,192,0,63,128,0,0,15,240,0,191,0,0,0,7,240,0,253,0,0,0,3,64,0,24,0,0,11,255,255,255,255,254,0,11,255,255,255,255,254,0,11,255,255,255,255,254,0,0,0,3,248,0,0,0,0,0,3,244,0,0,0,0,0,3,244,0,0,0,0,0,3,244,0,0,0,0,0,3,244,0,0,0,0,0,3,244,0,0,0,63,255,255,255,255,255,192,63,255,255,255,255,255,192,63,255,255,255,255,255,192,0,0,7,254,0,0,0,0,0,11,255,0,0,0,0,0,15,255,64,0,0,0,0,31,255,192,0,0,0,0,63,207,208,0,0,0,0,191,75,244,0,0,0,1,255,3,252,0,0,0,7,252,1,255,0,0,0,47,244,0,191,208,0,1,255,208,0,63,248,0,31,255,64,0,15,255,208,191,252,0,0,2,255,208,63,208,0,0,0,127,128,13,0,0,0,0,6,0,0,0,0,0,0,0,0,
  // 0x5177  具
  119,81,32,33,8,36,2,253,0,26,170,170,170,170,168,0,0,47,255,255,255,255,252,0,0,47,255,255,255,255,252,0,0,47,128,0,0,1,252,0,0,47,128,0,0,1,252,0,0,47,128,0,0,1,252,0,0,47,255,255,255,255,252,0,0,47,255,255,255,255,252,0,0,47,149,85,85,86,252,0,0,47,128,0,0,1,252,0,0,47,128,0,0,1,252,0,0,47,149,85,85,86,252,0,0,47,255,255,255,255,252,0,0,47,255,255,255,255,252,0,0,47,128,0,0,1,252,0,0,47,128,0,0,1,252,0,0,47,128,0,0,1,252,0,0,47,255,255,255,255,252,0,0,47,255,255,255,255,252,0,0,26,170,170,170,170,168,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,4,0,0,0,0,0,0,0,63,0,0,184,0,0,0,2,255,192,3,255,208,0,0,127,255,64,1,255,254,0,11,255,248,0,0,31,255,228,255,255,64,0,0,0,191,254,63,228,0,0,0,0,11,252,13,0,0,0,0,0,0,160,
  // 0x5197  冗
  151,81,33,32,32,36,2,253,21,85,85,85,85,85,85,84,0,63,255,255,255,255,255,255,252,0,63,255,255,255,255,255,255,252,0,63,255,255,255,255,255,255,252,0,63,64,0,0,0,0,1,252,0,63,64,0,0,0,0,1,252,0,63,64,0,0,0,0,1,252,0,63,64,0,0,0,0,1,252,0,63,64,0,0,0,0,1,252,0,63,64,0,0,0,0,1,252,0,0,0,255,255,255,255,0,0,0,0,0,255,255,255,255,0,0,0,0,0,255,255,255,255,0,0,0,0,0,254,0,0,191,0,0,0,0,0,254,0,0,191,0,0,0,0,0,254,0,0,191,0,0,0,0,0,254,0,0,191,0,0,0,0,0,254,0,0,191,0,0,0,0,0,253,0,0,191,0,0,0,0,0,253,0,0,191,0,0,0,0,1,252,0,0,191,0,0,0,0,2,252,0,0,191,0,0,0,0,3,252,0,0,191,0,40,0,0,11,244,0,0,191,0,47,64,0,15,240,0,0,191,0,47,64,0,63,208,0,0,191,0,63,64,1,255,192,0,0,191,0,63,64,11,255,0,0,0,191,0,127,0,191,252,0,0,0,191,255,255,0,255,224,0,0,0,63,255,254,0,127,64,0,0,0,31,255,248,0,36,0,0,0,0,0,85,64,0,
  // 0x51b7  冷
  183,81,34,34,50,36,1,253,0,0,0,0,7,244,0,0,0,0,0,0,0,15,252,0,0,0,7,0,0,0,47,255,0,0,0,31,208,0,0,63,255,128,0,0,63,244,0,0,255,47,208,0,0,15,254,0,3,253,15,244,0,0,2,255,128,11,248,3,253,0,0,0,191,192,47,240,1,255,64,0,0,47,64,191,192,0,127,224,0,0,9,2,255,0,0,31,248,0,0,0,11,252,0,0,7,255,64,0,0,63,255,255,255,253,255,224,0,1,255,203,255,255,252,63,208,0,1,255,11,255,255,252,11,128,0,0,184,0,0,0,0,1,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,255,255,255,255,252,0,0,15,211,255,255,255,255,252,0,0,31,227,255,255,255,255,252,0,0,63,192,0,63,128,1,252,0,0,191,64,0,63,128,1,252,0,0,255,0,0,63,128,1,252,0,3,252,0,0,63,128,1,252,0,11,248,0,0,63,128,1,252,0,31,240,0,0,63,128,1,252,0,63,208,0,0,63,130,255,252,0,127,128,0,0,63,129,255,248,0,31,0,0,0,63,128,255,224,0,5,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,47,64,0,0,0,
  // 0x51c6  准
  198,81,34,34,50,36,1,253,0,0,0,0,228,0,100,0,0,0,0,0,2,252,0,191,0,0,2,0,0,3,248,0,254,0,0,15,208,0,7,240,0,252,0,0,31,248,0,15,224,1,252,0,0,7,255,0,31,208,3,244,0,0,0,255,192,63,192,3,240,0,0,0,47,224,127,255,255,255,255,128,0,11,192,255,255,255,255,255,128,0,2,2,255,255,255,255,255,128,0,0,7,255,64,15,208,0,0,0,0,15,255,64,15,192,0,0,0,0,63,255,64,15,192,0,0,0,0,255,255,64,15,192,0,0,0,0,127,63,255,255,255,255,0,0,0,28,63,255,255,255,255,0,0,0,0,63,255,255,255,255,0,0,0,0,63,64,15,192,0,0,0,1,0,63,64,15,192,0,0,0,11,64,63,64,15,192,0,0,0,15,192,63,64,15,192,0,0,0,47,192,63,64,15,192,0,0,0,127,128,63,255,255,255,255,0,0,255,0,63,255,255,255,255,0,2,253,0,63,255,255,255,255,0,3,252,0,63,64,15,192,0,0,15,240,0,63,64,15,192,0,0,47,224,0,63,64,15,192,0,0,127,192,0,63,64,15,192,0,0,63,0,0,63,255,255,255,255,224,10,0,0,63,255,255,255,255,224,0,0,0,63,255,255,255,255,224,0,0,0,63,64,0,0,0,0,0,0,0,63,0,0,0,0,0,
  // 0x51fa  出
  250,81,28,35,245,36,4,252,0,0,0,169,0,0,0,0,0,0,253,0,0,0,0,0,0,253,0,0,0,26,64,0,253,0,1,164,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,128,0,253,0,3,248,47,255,255,255,255,255,248,47,255,255,255,255,255,248,47,255,255,255,255,255,248,0,0,0,254,0,0,0,0,0,0,253,0,0,0,84,0,0,253,0,0,21,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,253,0,0,253,0,0,127,254,85,85,254,85,85,127,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,253,0,0,0,0,0,127,253,0,0,0,0,0,127,0,0,0,0,0,0,0,
  // 0x51fb  击
  251,81,32,34,16,36,2,253,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,1,85,85,91,245,85,85,64,3,255,255,255,255,255,255,208,3,255,255,255,255,255,255,208,3,255,255,255,255,255,255,208,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,21,85,85,91,245,85,85,84,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,3,252,0,11,240,0,47,192,3,252,0,11,240,0,47,192,3,252,0,11,240,0,47,192,3,252,0,11,240,0,47,192,3,252,0,11,240,0,47,192,3,252,0,11,240,0,47,192,3,252,0,11,240,0,47,192,3,252,0,11,240,0,47,192,3,253,85,91,245,85,127,192,3,255,255,255,255,255,255,192,3,255,255,255,255,255,255,192,3,255,255,255,255,255,255,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,
  // 0x5206  分
  6,82,34,34,50,36,1,252,0,0,15,144,0,47,0,0,0,0,0,31,224,0,191,64,0,0,0,0,63,192,0,63,192,0,0,0,0,127,192,0,31,224,0,0,0,0,255,64,0,15,244,0,0,0,2,254,0,0,7,252,0,0,0,7,252,0,0,2,255,0,0,0,15,244,0,0,0,255,128,0,0,63,240,0,0,0,63,224,0,0,255,192,0,0,0,47,244,0,3,255,64,0,0,0,11,253,0,15,253,0,0,0,0,3,255,128,127,253,85,85,85,85,85,255,224,255,223,255,255,255,255,255,127,208,63,79,255,255,255,255,255,15,64,13,15,255,255,255,255,255,1,0,0,0,0,127,0,0,127,0,0,0,0,0,191,0,0,127,0,0,0,0,0,255,0,0,127,0,0,0,0,0,254,0,0,191,0,0,0,0,0,253,0,0,191,0,0,0,0,2,252,0,0,191,0,0,0,0,3,252,0,0,191,0,0,0,0,7,248,0,0,254,0,0,0,0,15,240,0,0,254,0,0,0,0,63,224,0,0,254,0,0,0,0,191,192,0,0,253,0,0,0,3,255,64,0,1,253,0,0,0,31,253,0,0,2,252,0,0,1,255,244,0,21,23,252,0,0,15,255,208,0,63,255,248,0,0,7,254,0,0,63,255,240,0,0,2,224,0,0,47,255,128,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5207  切
  7,82,33,33,41,36,1,253,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,47,255,255,255,255,192,0,190,0,47,255,255,255,255,192,0,190,0,47,255,255,255,255,192,0,190,0,0,3,248,0,47,192,0,190,0,0,2,248,0,47,128,0,190,0,24,3,248,0,47,128,0,190,27,253,3,248,0,47,128,0,255,255,254,3,244,0,63,128,127,255,255,253,3,244,0,63,128,191,255,249,0,3,244,0,63,128,191,254,0,0,3,244,0,63,128,100,190,0,0,3,244,0,63,128,0,190,0,0,3,240,0,63,64,0,190,0,0,7,240,0,63,64,0,190,0,0,7,240,0,63,64,0,190,0,0,11,240,0,63,64,0,190,0,224,15,224,0,63,64,0,190,0,252,15,208,0,63,64,0,190,0,252,31,192,0,63,0,0,190,0,252,47,192,0,127,0,0,191,65,252,63,128,0,127,0,0,191,255,248,191,0,0,127,0,0,63,255,240,255,0,0,191,0,0,31,255,210,253,0,0,191,0,0,0,0,7,248,0,0,254,0,0,0,0,31,240,0,0,254,0,0,0,0,127,208,0,2,253,0,0,0,3,255,128,31,255,252,0,0,0,7,254,0,15,255,244,0,0,0,1,244,0,11,255,224,0,0,0,0,128,0,1,84,0,0,
  // 0x521b  创
  27,82,32,34,16,36,1,253,0,0,14,0,0,0,0,21,0,0,47,192,0,0,0,127,0,0,63,128,0,0,0,127,0,0,191,208,0,0,0,127,0,1,255,244,0,10,128,127,0,3,255,252,0,31,192,127,0,11,240,255,0,31,192,127,0,31,208,63,192,31,192,127,0,127,128,31,240,31,192,127,0,255,0,7,248,31,192,127,3,252,0,2,253,31,192,127,31,240,0,0,255,31,192,127,127,208,0,0,63,31,192,127,127,255,255,255,252,31,192,127,30,255,255,255,228,31,192,127,0,255,255,255,208,31,192,127,0,253,0,15,208,31,192,127,0,253,0,15,208,31,192,127,0,253,0,15,208,31,192,127,0,253,0,15,192,31,192,127,0,253,0,15,192,31,192,127,0,253,0,31,192,31,192,127,0,253,0,47,192,31,192,127,0,253,31,255,128,31,192,127,0,253,15,255,0,31,192,127,0,253,10,164,0,0,0,127,0,253,0,0,57,0,0,127,0,253,0,0,63,0,0,127,0,253,0,0,63,0,0,127,0,254,0,0,190,0,0,127,0,191,255,255,253,0,0,191,0,63,255,255,252,7,255,254,0,27,255,255,224,3,255,253,0,0,0,0,0,3,255,224,
  // 0x521d  初
  29,82,33,34,50,36,1,253,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,15,255,255,255,255,192,0,15,192,15,255,255,255,255,192,0,15,192,15,255,255,255,255,192,0,15,208,0,2,252,0,47,192,63,255,255,208,1,252,0,47,128,63,255,255,240,2,252,0,47,128,63,255,255,208,2,252,0,47,128,0,0,31,192,2,252,0,63,128,0,0,63,64,2,248,0,63,128,0,0,191,0,2,248,0,63,128,0,0,253,16,3,248,0,63,128,0,3,248,120,3,248,0,63,128,0,11,240,253,3,244,0,63,128,0,31,242,244,3,244,0,63,64,0,63,255,224,7,240,0,63,64,0,255,255,128,7,240,0,63,64,3,255,255,128,11,224,0,63,64,15,255,239,224,15,224,0,63,64,127,239,199,248,15,208,0,63,64,191,143,194,244,47,192,0,63,0,62,15,192,224,63,128,0,127,0,40,15,192,0,127,64,0,127,0,0,15,192,0,255,0,0,127,0,0,15,192,1,253,0,0,191,0,0,15,192,7,252,0,0,254,0,0,15,192,15,244,0,0,254,0,0,15,192,63,224,0,2,253,0,0,15,193,255,192,15,255,252,0,0,15,193,255,0,15,255,248,0,0,15,192,124,0,11,255,224,0,0,15,192,16,0,1,84,0,0,
  // 0x522b  别
  43,82,32,34,16,36,1,252,0,0,0,0,0,0,0,127,11,255,255,255,192,0,0,127,11,255,255,255,192,0,0,127,11,255,255,255,192,0,0,127,11,208,0,31,192,63,64,127,11,208,0,31,192,63,64,127,11,208,0,31,192,63,64,127,11,208,0,31,192,63,64,127,11,208,0,31,192,63,64,127,11,208,0,31,192,63,64,127,11,255,255,255,192,63,64,127,11,255,255,255,192,63,64,127,11,255,255,255,192,63,64,127,0,0,0,0,0,63,64,127,0,3,240,0,0,63,64,127,0,3,240,0,0,63,64,127,0,3,240,0,0,63,64,127,63,255,255,255,224,63,64,127,63,255,255,255,208,63,64,127,63,255,255,255,208,63,64,127,0,7,224,15,208,63,64,127,0,11,224,15,208,63,64,127,0,15,208,15,208,63,64,127,0,15,192,15,192,63,64,127,0,31,192,15,192,0,0,127,0,63,128,15,192,0,0,127,0,127,0,31,192,0,0,127,0,254,0,31,192,0,0,127,3,252,0,47,192,0,0,127,15,244,0,63,128,1,85,255,127,224,63,255,64,3,255,254,63,128,47,255,0,2,255,253,13,0,47,248,0,1,255,224,0,0,0,0,0,0,0,0,
  // 0x5230  到
  48,82,32,33,8,36,1,253,0,0,0,0,0,0,0,63,63,255,255,255,252,0,0,63,63,255,255,255,252,0,0,63,63,255,255,255,252,126,0,63,0,15,240,0,0,126,0,63,0,15,208,0,0,126,0,63,0,47,192,60,0,126,0,63,0,63,192,254,0,126,0,63,0,63,64,63,64,126,0,63,0,127,0,47,192,126,0,63,0,254,0,15,240,126,0,63,63,255,255,255,244,126,0,63,63,255,255,255,252,126,0,63,63,255,255,255,253,126,0,63,5,85,0,0,126,126,0,63,0,0,190,0,32,126,0,63,0,0,190,0,0,126,0,63,0,0,190,0,0,126,0,63,0,0,190,0,0,126,0,63,15,255,255,255,240,126,0,63,15,255,255,255,240,126,0,63,15,255,255,255,240,126,0,63,0,0,190,0,0,126,0,63,0,0,190,0,0,126,0,63,0,0,190,0,0,0,0,63,0,0,190,0,0,0,0,63,0,0,190,0,88,0,0,63,0,0,191,255,252,0,0,63,26,255,255,255,252,0,0,63,127,255,255,255,248,1,85,191,127,255,250,80,0,3,255,255,62,148,0,0,0,1,255,253,0,0,0,0,0,0,255,228,
  // 0x5236  制
  54,82,33,34,50,36,1,253,0,0,47,0,0,0,0,21,0,1,248,63,64,0,0,0,63,64,2,248,63,64,0,0,0,63,64,3,244,63,64,0,3,224,63,64,3,240,63,64,0,3,240,63,64,7,255,255,255,252,3,240,63,64,15,255,255,255,252,3,240,63,64,31,255,255,255,252,3,240,63,64,47,192,63,64,0,3,240,63,64,63,64,63,64,0,3,240,63,64,127,0,63,64,0,3,240,63,64,10,0,63,64,0,3,240,63,64,127,255,255,255,255,131,240,63,64,127,255,255,255,255,131,240,63,64,127,255,255,255,255,131,240,63,64,0,0,63,64,0,3,240,63,64,0,0,63,64,0,3,240,63,64,0,0,63,64,0,3,240,63,64,15,255,255,255,254,3,240,63,64,15,255,255,255,254,3,240,63,64,15,255,255,255,254,3,240,63,64,15,192,63,64,190,3,240,63,64,15,192,63,64,190,3,240,63,64,15,192,63,64,190,2,160,63,64,15,192,63,64,190,0,0,63,64,15,192,63,64,190,0,0,63,64,15,192,63,64,190,0,0,63,64,15,192,63,64,190,0,0,63,64,15,192,63,95,253,0,0,63,64,15,192,63,79,252,0,0,63,64,15,192,63,79,228,0,85,127,64,0,0,63,64,0,0,255,255,0,0,0,63,64,0,0,191,254,0,0,0,63,64,0,0,63,228,0,
  // 0x5237  刷
  55,82,32,34,16,36,1,253,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,63,7,255,255,255,254,0,0,63,7,255,255,255,254,5,64,63,7,255,255,255,254,15,192,63,7,224,0,0,190,15,192,63,7,224,0,0,190,15,192,63,7,224,0,0,190,15,192,63,7,224,0,0,190,15,192,63,7,255,255,255,254,15,192,63,7,255,255,255,254,15,192,63,7,255,255,255,254,15,192,63,7,224,3,240,0,15,192,63,7,224,3,240,0,15,192,63,7,224,3,240,0,15,192,63,7,224,3,240,0,15,192,63,7,239,255,255,255,15,192,63,7,239,255,255,255,15,192,63,7,239,255,255,255,15,192,63,7,239,67,240,63,15,192,63,11,223,67,240,63,15,192,63,11,223,67,240,63,15,192,63,11,223,67,240,63,15,192,63,15,207,67,240,63,15,192,63,15,207,67,240,63,10,128,63,15,207,67,240,63,0,0,63,31,143,67,240,63,0,0,63,31,143,67,247,254,0,0,63,63,79,67,243,253,0,0,63,63,15,67,241,160,0,0,63,190,0,3,240,0,0,85,191,189,0,3,240,0,0,255,255,28,0,3,240,0,0,191,254,0,0,3,240,0,0,127,228,
  // 0x5272  割
  114,82,31,34,16,36,2,253,0,1,248,0,0,0,0,84,0,1,252,0,0,0,0,252,0,1,252,0,0,0,0,252,170,171,254,170,164,0,0,252,255,255,255,255,248,127,0,252,255,255,255,255,248,127,0,252,252,0,0,1,248,127,0,252,252,1,252,1,248,127,0,252,252,1,252,1,248,127,0,252,15,255,255,255,192,127,0,252,15,255,255,255,192,127,0,252,5,86,253,85,64,127,0,252,0,1,252,0,0,127,0,252,5,86,253,85,0,127,0,252,15,255,255,255,64,127,0,252,15,255,255,255,64,127,0,252,0,1,252,0,0,127,0,252,0,1,252,0,0,127,0,252,170,170,254,170,160,127,0,252,255,255,255,255,244,127,0,252,255,255,255,255,244,127,0,252,0,0,0,0,0,127,0,252,6,170,170,170,64,127,0,252,15,255,255,255,192,127,0,252,15,255,255,255,192,0,0,252,15,192,0,31,192,0,0,252,15,192,0,31,192,0,0,252,15,192,0,31,192,0,0,252,15,192,0,31,192,0,0,252,15,234,170,175,192,0,0,252,15,255,255,255,192,5,86,252,15,255,255,255,192,7,255,252,15,192,0,31,192,3,255,248,15,192,0,5,64,3,255,144,
  // 0x529b  力
  155,82,31,35,24,36,2,252,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,191,0,0,0,0,63,255,255,255,255,255,255,248,63,255,255,255,255,255,255,248,63,255,255,255,255,255,255,248,21,85,85,255,85,85,87,244,0,0,0,254,0,0,3,244,0,0,0,254,0,0,3,244,0,0,0,253,0,0,3,244,0,0,1,252,0,0,3,240,0,0,2,252,0,0,7,240,0,0,3,252,0,0,7,240,0,0,3,248,0,0,7,240,0,0,11,244,0,0,11,240,0,0,15,240,0,0,11,240,0,0,31,224,0,0,11,240,0,0,63,192,0,0,15,224,0,0,191,192,0,0,15,224,0,0,255,0,0,0,15,208,0,3,254,0,0,0,15,208,0,11,252,0,0,0,31,192,0,47,244,0,0,0,47,192,0,191,208,0,0,0,63,192,3,255,128,0,0,0,63,128,31,254,0,0,21,85,255,64,191,244,0,0,15,255,255,0,127,208,0,0,15,255,253,0,30,0,0,0,11,255,224,0,0,0,0,0,0,0,0,0,
  // 0x529f  功
  159,82,33,34,50,36,1,253,0,0,0,0,0,84,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,0,253,0,0,0,63,255,255,240,0,253,0,0,0,63,255,255,240,0,253,0,0,0,63,255,255,240,0,253,0,0,0,0,31,208,0,0,253,0,0,0,0,15,192,11,255,255,255,255,128,0,15,192,11,255,255,255,255,128,0,15,192,11,255,255,255,255,128,0,15,192,0,1,253,0,47,128,0,15,192,0,1,252,0,47,128,0,15,192,0,1,252,0,47,128,0,15,192,0,2,252,0,63,64,0,15,192,0,2,248,0,63,64,0,15,192,0,3,248,0,63,64,0,15,192,0,3,244,0,63,64,0,15,192,0,3,244,0,63,64,0,15,192,0,7,240,0,63,64,0,15,193,184,11,240,0,63,0,0,15,255,252,15,224,0,63,0,0,111,255,252,31,208,0,63,0,111,255,255,224,63,192,0,127,0,127,255,228,0,127,128,0,127,0,63,249,0,0,255,0,0,191,0,57,0,0,2,254,0,0,190,0,0,0,0,11,252,0,0,254,0,0,0,0,47,240,0,0,253,0,0,0,0,191,208,0,2,252,0,0,0,7,255,128,31,255,252,0,0,0,7,254,0,15,255,244,0,0,0,1,244,0,15,255,208,0,0,0,0,64,0,0,0,0,0,
  // 0x52a0  加
  160,82,32,34,16,36,1,253,0,5,64,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,0,0,0,0,0,31,192,0,2,255,255,255,21,95,213,85,2,255,255,255,63,255,255,255,194,255,255,255,63,255,255,255,194,248,0,191,63,255,255,255,194,248,0,191,0,31,192,31,194,248,0,191,0,31,192,31,130,248,0,191,0,47,128,31,130,248,0,191,0,47,128,47,130,248,0,191,0,47,128,47,130,248,0,191,0,47,128,47,130,248,0,191,0,63,64,47,130,248,0,191,0,63,64,47,130,248,0,191,0,63,0,47,130,248,0,191,0,63,0,47,130,248,0,191,0,127,0,47,130,248,0,191,0,190,0,63,66,248,0,191,0,190,0,63,66,248,0,191,0,253,0,63,66,248,0,191,1,252,0,63,66,248,0,191,2,252,0,63,66,248,0,191,3,244,0,63,2,248,0,191,7,240,0,63,2,248,0,191,15,240,0,127,2,255,255,255,31,208,0,255,2,255,255,255,63,193,255,254,2,255,255,255,191,64,255,252,2,248,0,191,46,0,255,244,2,248,0,191,8,0,20,0,1,84,0,0,
  // 0x52a8  动
  168,82,32,34,16,36,2,253,0,0,0,0,0,21,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,63,0,0,63,255,255,252,0,63,0,0,63,255,255,252,0,63,0,0,47,255,255,252,0,63,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,63,0,0,0,0,0,0,255,255,255,255,0,0,0,0,255,255,255,255,0,0,0,0,255,255,255,255,0,0,0,0,0,127,0,191,255,255,255,254,0,127,0,127,255,255,255,254,0,190,0,127,255,255,255,254,0,190,0,190,0,127,0,0,0,190,0,190,0,190,0,0,0,253,0,190,0,253,0,0,0,253,0,190,0,252,7,208,0,252,0,190,1,252,3,240,1,252,0,190,2,248,3,240,2,252,0,253,3,240,1,248,2,248,0,253,7,240,0,252,3,244,0,253,15,208,1,253,7,240,0,253,15,197,191,254,11,240,0,253,63,255,255,255,15,224,0,252,191,255,254,127,95,208,1,252,127,254,64,46,127,192,1,252,62,64,0,0,191,64,2,252,0,0,0,1,255,0,3,248,0,0,0,3,253,47,255,244,0,0,0,7,248,15,255,240,0,0,0,0,240,15,255,128,0,0,0,0,64,0,0,0,
  // 0x5316  化
  22,83,34,33,41,36,1,253,0,0,47,128,190,0,0,0,0,0,0,63,192,190,0,0,0,0,0,0,191,64,190,0,0,0,0,0,0,255,0,190,0,0,0,0,0,2,253,0,190,0,0,0,0,0,3,252,0,190,0,0,0,0,0,15,240,0,190,0,0,48,0,0,31,224,0,190,0,0,252,0,0,63,208,0,190,0,7,255,0,0,255,208,0,190,0,47,253,0,3,255,208,0,190,1,255,240,0,11,255,208,0,190,11,255,64,0,47,255,208,0,190,127,248,0,0,191,239,208,0,191,255,208,0,0,255,143,208,0,191,253,0,0,0,127,15,208,0,191,224,0,0,0,60,15,208,0,191,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,0,0,0,15,208,0,190,0,0,7,128,0,15,208,0,190,0,0,11,224,0,15,208,0,190,0,0,11,224,0,15,208,0,190,0,0,11,208,0,15,208,0,191,0,0,15,208,0,15,208,0,127,64,0,47,192,0,15,208,0,63,255,255,255,192,0,15,208,0,63,255,255,255,64,0,15,208,0,11,255,255,253,0,0,10,128,0,0,0,0,0,0,
  // 0x5347  升
  71,83,32,35,24,36,2,252,0,0,0,1,0,5,0,0,0,0,0,31,64,47,128,0,0,0,2,255,208,47,128,0,0,0,111,255,208,47,128,0,0,31,255,253,0,47,128,0,27,255,255,144,0,47,128,0,191,255,252,0,0,47,128,0,63,250,252,0,0,47,128,0,41,0,252,0,0,47,128,0,0,0,252,0,0,47,128,0,0,0,252,0,0,47,128,0,0,0,252,0,0,47,128,0,0,0,252,0,0,47,128,0,0,0,252,0,0,47,128,0,0,1,253,0,0,63,128,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,252,0,0,47,128,0,0,2,252,0,0,47,128,0,0,2,248,0,0,47,128,0,0,3,248,0,0,47,128,0,0,3,244,0,0,47,128,0,0,7,240,0,0,47,128,0,0,15,240,0,0,47,128,0,0,31,224,0,0,47,128,0,0,63,192,0,0,47,128,0,0,191,128,0,0,47,128,0,2,255,0,0,0,47,128,0,11,253,0,0,0,47,128,0,63,244,0,0,0,47,128,0,255,208,0,0,0,47,128,0,127,64,0,0,0,47,128,0,24,0,0,0,0,47,128,0,0,0,0,0,0,0,0,0,
  // 0x534a  半
  74,83,32,34,16,36,2,253,0,0,0,15,224,0,0,0,0,120,0,15,224,0,62,0,2,252,0,15,224,0,127,192,0,254,0,15,224,0,191,0,0,191,64,15,224,0,254,0,0,63,192,15,224,2,252,0,0,47,208,15,224,3,248,0,0,15,240,15,224,11,240,0,0,11,240,15,224,31,208,0,0,7,144,15,224,7,192,0,0,0,0,15,224,0,0,0,1,85,85,95,229,85,85,80,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,85,85,85,95,245,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,
  // 0x534f  协
  79,83,33,34,50,36,2,253,1,248,0,0,26,64,0,0,0,1,248,0,0,47,128,0,0,0,1,248,0,0,47,128,0,0,0,1,248,0,0,47,128,0,0,0,1,248,0,0,47,128,0,0,0,1,248,0,0,47,128,0,0,0,1,248,0,0,47,128,0,0,0,1,248,2,255,255,255,255,0,0,2,252,2,255,255,255,255,0,0,255,255,246,255,255,255,255,0,0,255,255,244,0,63,128,127,0,0,255,255,244,0,63,64,127,0,0,1,248,0,0,63,64,127,0,0,1,248,0,0,63,0,127,0,0,1,248,2,244,63,0,127,248,0,1,248,3,240,63,0,127,252,0,1,248,3,240,127,0,127,189,0,1,248,7,224,190,0,126,126,0,1,248,15,208,254,0,126,63,0,1,248,15,192,253,0,190,63,0,1,248,47,129,252,0,190,47,64,1,248,63,3,248,0,190,47,128,1,248,126,3,244,0,190,31,128,1,248,12,11,240,0,189,15,192,1,248,0,31,224,0,253,4,0,1,248,0,63,192,0,253,0,0,1,248,0,127,128,0,252,0,0,1,248,1,255,0,0,252,0,0,1,248,3,253,0,1,252,0,0,1,248,15,248,0,3,252,0,0,1,248,63,240,31,255,244,0,0,1,248,127,192,15,255,240,0,0,1,248,31,0,11,255,128,0,0,1,164,4,0,0,0,0,0,0,
  // 0x5355  单
  85,83,32,34,16,36,2,253,0,0,144,0,0,2,64,0,0,7,240,0,0,11,244,0,0,3,252,0,0,15,240,0,0,1,254,0,0,47,208,0,0,0,191,64,0,63,128,0,0,0,63,128,0,255,0,0,2,170,191,170,171,255,170,128,2,255,255,255,255,255,255,192,2,255,255,255,255,255,255,192,2,248,0,15,224,0,31,192,2,248,0,15,224,0,31,192,2,248,0,15,224,0,31,192,2,254,170,175,250,170,191,192,2,255,255,255,255,255,255,192,2,255,255,255,255,255,255,192,2,248,0,15,224,0,31,192,2,248,0,15,224,0,31,192,2,248,0,15,224,0,31,192,2,255,255,255,255,255,255,192,2,255,255,255,255,255,255,192,2,255,255,255,255,255,255,192,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,11,224,0,0,0,
  // 0x5361  卡
  97,83,32,34,16,36,2,253,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,255,255,255,0,0,0,0,47,255,255,255,0,0,0,0,47,255,255,255,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,111,213,85,85,85,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,238,0,0,0,0,0,0,47,255,248,0,0,0,0,0,47,255,255,208,0,0,0,0,47,203,255,254,0,0,0,0,47,192,111,255,208,0,0,0,47,192,1,255,192,0,0,0,47,192,0,31,64,0,0,0,47,192,0,1,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,31,192,0,0,0,
  // 0x5370  印
  112,83,30,34,16,36,3,253,0,0,6,0,0,0,0,0,0,0,127,192,0,0,0,0,0,7,255,224,85,85,85,80,17,191,255,145,255,255,255,240,127,255,248,1,255,255,255,240,127,254,64,1,255,255,255,240,127,144,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,64,0,1,252,0,3,240,127,255,255,209,252,0,3,240,127,255,255,209,252,0,3,240,127,255,255,209,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,0,0,1,252,0,3,240,127,255,255,225,252,0,7,240,127,255,255,225,252,15,255,240,127,255,255,225,252,11,255,240,127,64,0,1,252,7,255,192,127,0,0,1,252,2,148,0,127,0,0,1,252,0,0,0,21,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,
  // 0x5371  危
  113,83,34,35,59,36,1,252,0,0,31,144,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,127,255,255,244,0,0,0,0,0,255,255,255,255,0,0,0,0,2,255,255,255,254,0,0,0,0,7,252,0,3,252,0,0,0,0,15,240,0,7,248,0,0,0,0,63,224,0,15,240,0,0,0,0,191,192,0,31,224,0,0,0,2,255,255,255,255,255,255,255,128,11,255,255,255,255,255,255,255,128,63,255,255,255,255,255,255,255,128,127,255,64,0,0,0,0,0,0,31,63,64,0,0,0,0,0,0,4,63,64,0,0,0,0,0,0,0,63,65,255,255,255,255,0,0,0,63,65,255,255,255,255,0,0,0,63,65,255,255,255,255,0,0,0,63,1,252,0,0,63,0,0,0,63,1,252,0,0,127,0,0,0,63,1,252,0,0,127,0,0,0,127,1,252,0,0,190,0,0,0,191,1,252,0,0,254,0,0,0,190,1,252,2,255,253,0,0,0,253,1,252,1,255,252,0,0,0,252,1,252,0,255,224,9,0,2,252,1,252,0,0,0,11,208,3,248,1,252,0,0,0,15,208,7,244,1,252,0,0,0,15,208,15,240,1,252,0,0,0,15,192,47,208,1,254,0,0,0,127,192,127,192,0,255,255,255,255,255,64,127,0,0,127,255,255,255,255,0,13,0,0,27,255,255,255,248,0,0,0,0,0,0,0,0,0,0,
  // 0x5374  却
  116,83,32,34,16,36,1,253,0,0,252,0,0,0,0,0,0,0,252,0,0,0,0,0,0,0,252,0,2,255,255,255,0,0,252,0,2,255,255,255,0,0,252,0,2,255,255,255,0,0,252,0,2,248,0,127,15,255,255,255,194,248,0,127,15,255,255,255,194,248,0,127,15,255,255,255,194,248,0,127,0,0,252,0,2,248,0,127,0,0,252,0,2,248,0,127,0,0,252,0,2,248,0,127,0,0,252,0,2,248,0,127,0,0,252,0,2,248,0,127,191,255,255,255,242,248,0,127,191,255,255,255,242,248,0,127,191,255,255,255,242,248,0,127,0,15,224,0,2,248,0,127,0,31,208,0,2,248,0,127,0,47,192,0,2,248,0,127,0,63,128,16,2,248,0,127,0,63,65,244,2,248,0,127,0,127,1,252,2,248,0,127,0,254,0,253,2,248,0,127,0,252,0,127,2,248,21,191,1,252,0,63,130,248,63,255,3,249,90,255,194,248,47,253,111,255,255,255,210,248,31,228,127,255,255,255,242,248,0,0,127,255,233,67,242,248,0,0,37,64,0,3,246,248,0,0,0,0,0,1,66,248,0,0,0,0,0,0,2,248,0,0,0,0,0,0,2,248,0,0,
  // 0x5378  卸
  120,83,32,34,16,36,1,253,0,62,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,127,0,0,2,255,255,255,0,254,0,0,2,255,255,255,0,255,255,255,226,255,255,255,2,255,255,255,226,252,0,63,7,255,255,255,226,248,0,63,15,224,126,0,2,248,0,63,47,192,126,0,2,248,0,63,63,128,126,0,2,248,0,63,15,0,126,0,2,248,0,63,0,0,126,0,2,248,0,63,63,255,255,255,242,248,0,63,63,255,255,255,242,248,0,63,63,255,255,255,242,248,0,63,0,0,126,0,2,248,0,63,0,0,126,0,2,248,0,63,1,80,126,0,2,248,0,63,3,224,126,0,2,248,0,63,3,224,127,255,194,248,0,63,3,224,127,255,194,248,0,63,3,224,127,255,194,248,0,63,3,224,126,0,2,248,0,63,3,224,126,0,2,248,0,63,3,224,126,0,2,248,0,63,3,224,126,0,2,248,63,255,3,224,126,6,178,248,47,255,3,224,191,255,246,248,31,253,27,255,255,255,246,248,5,64,191,255,255,254,82,248,0,0,191,255,233,0,2,248,0,0,126,144,0,0,2,248,0,0,0,0,0,0,2,248,0,0,0,0,0,0,2,248,0,0,
  // 0x538b  压
  139,83,34,32,32,36,1,253,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,255,255,255,255,255,255,255,208,3,244,0,0,0,0,0,0,0,3,244,0,0,5,64,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,0,0,15,192,0,0,0,3,244,191,255,255,255,255,254,0,3,240,191,255,255,255,255,254,0,3,240,191,255,255,255,255,254,0,3,240,0,0,31,208,0,0,0,3,240,0,0,15,192,0,0,0,3,240,0,0,15,192,32,0,0,3,240,0,0,15,192,252,0,0,3,240,0,0,15,192,255,64,0,7,240,0,0,15,192,63,208,0,7,224,0,0,15,192,15,240,0,11,224,0,0,15,192,3,248,0,15,208,0,0,15,192,1,240,0,15,192,0,0,15,192,0,64,0,15,192,0,0,15,192,0,0,0,47,192,0,0,15,192,0,0,0,63,143,255,255,255,255,255,255,192,127,15,255,255,255,255,255,255,192,191,15,255,255,255,255,255,255,192,45,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,
  // 0x539f  原
  159,83,33,32,32,36,1,253,1,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,192,1,255,255,255,255,255,255,255,192,1,252,0,0,31,208,0,0,0,1,252,0,0,47,192,0,0,0,1,252,0,0,63,192,0,0,0,1,252,31,255,255,255,255,240,0,1,252,31,255,255,255,255,240,0,1,252,31,234,170,170,171,240,0,1,252,31,192,0,0,7,240,0,1,252,31,192,0,0,7,240,0,1,252,31,213,85,85,91,240,0,1,252,31,255,255,255,255,240,0,1,252,31,255,255,255,255,240,0,2,252,31,192,0,0,7,240,0,2,248,31,192,0,0,7,240,0,2,248,31,192,0,0,7,240,0,2,248,31,255,255,255,255,240,0,3,244,31,255,255,255,255,240,0,3,244,10,170,175,234,170,160,0,3,244,0,0,15,208,0,0,0,3,240,0,144,15,208,28,0,0,7,240,2,252,15,208,191,0,0,11,240,7,248,15,208,63,208,0,15,224,15,240,15,208,15,244,0,15,208,63,192,15,208,3,252,0,31,192,255,64,15,208,0,255,0,47,199,253,0,15,208,0,127,192,63,79,244,0,15,208,0,31,192,191,2,208,31,255,208,0,10,0,126,0,0,15,255,192,0,0,0,5,0,0,11,254,0,0,0,0,
  // 0x53cc  双
  204,83,33,32,32,36,1,252,47,255,255,252,127,255,255,255,0,47,255,255,253,127,255,255,255,0,47,255,255,252,127,255,255,255,0,0,0,1,252,47,128,0,190,0,0,0,1,252,31,192,0,254,0,0,0,2,252,31,192,0,253,0,1,0,3,248,15,192,0,252,0,7,192,3,244,15,208,1,252,0,31,224,3,240,11,224,2,248,0,11,244,7,240,7,240,3,244,0,3,253,11,240,7,240,3,240,0,0,255,15,224,3,240,11,240,0,0,127,207,208,3,248,15,224,0,0,47,255,192,1,252,31,208,0,0,15,255,128,0,252,47,192,0,0,3,255,64,0,254,63,128,0,0,1,255,0,0,191,191,0,0,0,0,255,64,0,63,254,0,0,0,1,255,192,0,63,252,0,0,0,3,255,224,0,31,248,0,0,0,7,255,244,0,15,240,0,0,0,15,243,252,0,63,248,0,0,0,47,210,253,0,191,253,0,0,0,127,192,255,2,255,255,0,0,0,255,0,188,11,253,191,192,0,3,254,0,48,47,244,63,240,0,15,252,0,1,255,208,15,252,0,63,240,0,11,255,64,3,255,128,127,192,0,15,253,0,0,255,192,31,64,0,7,224,0,0,63,0,8,0,0,2,64,0,0,9,0,0,0,0,0,0,0,0,0,0,
  // 0x53cd  反
  205,83,32,33,8,36,2,252,0,255,255,255,255,255,255,248,0,255,255,255,255,255,255,248,0,255,255,255,255,255,255,248,0,254,85,85,85,85,85,80,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,254,0,0,0,0,4,0,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,0,0,253,47,192,0,0,255,0,0,252,15,224,0,1,253,0,0,252,11,240,0,3,252,0,0,252,7,248,0,7,248,0,1,252,3,252,0,15,240,0,1,252,1,254,0,47,224,0,2,252,0,191,128,127,192,0,2,248,0,63,209,255,64,0,3,244,0,31,247,254,0,0,3,244,0,11,255,248,0,0,7,240,0,2,255,240,0,0,11,240,0,2,255,224,0,0,15,208,0,31,255,253,0,0,31,192,0,255,255,255,208,0,63,192,31,255,193,255,254,64,127,70,255,253,0,47,255,249,255,11,255,224,0,7,255,253,125,3,254,0,0,0,47,248,8,1,144,0,0,0,1,176,0,0,0,0,0,0,0,0,
  // 0x53d6  取
  214,83,34,32,32,36,1,253,63,255,255,255,244,0,0,0,0,63,255,255,255,244,0,0,0,0,63,255,255,255,244,0,0,0,0,2,248,0,127,47,255,255,255,64,2,248,0,63,31,255,255,255,64,2,248,0,63,31,255,255,255,64,2,248,0,63,5,149,85,127,0,2,248,0,63,15,208,0,127,0,2,255,255,255,15,224,0,127,0,2,255,255,255,11,240,0,190,0,2,255,255,255,7,240,0,253,0,2,248,0,63,3,244,0,252,0,2,248,0,63,3,248,1,252,0,2,248,0,63,1,252,3,248,0,2,248,0,63,0,253,3,244,0,2,255,255,255,0,255,11,240,0,2,255,255,255,0,127,15,224,0,2,255,255,255,0,63,175,208,0,2,248,0,63,0,31,255,192,0,2,248,0,63,0,15,255,64,0,2,248,0,63,0,11,255,0,0,2,248,0,63,0,3,253,0,0,2,248,26,255,0,7,253,0,0,7,255,255,255,0,15,255,64,0,255,255,255,255,0,63,255,192,0,191,255,254,191,0,255,175,240,0,127,229,0,63,3,255,15,252,0,16,0,0,63,31,252,3,255,64,0,0,0,63,191,240,0,255,224,0,0,0,63,127,128,0,63,208,0,0,0,63,45,0,0,11,128,0,0,0,63,0,0,0,1,0,
  // 0x53d8  变
  216,83,32,35,24,36,2,252,0,0,0,27,192,0,0,0,0,0,0,31,208,0,0,0,0,0,0,15,240,0,0,0,0,0,0,7,244,0,0,0,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,0,0,15,208,11,240,0,0,0,41,15,208,11,240,80,0,0,63,79,208,11,243,244,0,0,255,15,208,11,242,253,0,1,253,15,208,11,240,191,128,7,248,15,208,11,240,47,208,15,240,15,208,11,240,11,244,63,192,15,208,11,240,3,252,11,0,15,208,11,240,0,224,0,0,15,208,11,240,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,255,248,0,3,255,255,255,255,255,254,0,3,255,255,255,255,255,252,0,0,15,224,0,0,11,248,0,0,3,248,0,0,47,224,0,0,1,254,0,0,191,192,0,0,0,191,192,3,255,0,0,0,0,31,248,47,248,0,0,0,0,7,255,255,224,0,0,0,0,0,255,255,0,0,0,0,0,7,255,255,144,0,0,0,6,255,255,255,255,64,0,26,255,255,244,47,255,255,164,255,255,254,64,1,191,255,255,63,254,128,0,0,6,255,252,62,64,0,0,0,0,1,184,0,0,0,0,0,0,0,0,
  // 0x53f0  台
  240,83,32,34,16,36,2,253,0,0,3,208,0,0,0,0,0,0,3,252,0,0,0,0,0,0,11,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,47,208,0,9,0,0,0,0,63,192,0,63,64,0,0,0,191,64,0,191,208,0,0,0,254,0,0,31,244,0,0,3,252,0,0,7,254,0,0,7,244,0,0,1,255,64,0,15,245,170,175,255,255,208,191,255,255,255,255,255,255,244,191,255,255,255,255,255,255,252,127,255,255,250,170,85,66,255,21,64,0,0,0,0,0,255,0,0,0,0,0,0,0,120,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,0,0,0,0,254,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,191,0,0,0,1,254,0,0,127,0,0,0,0,253,0,
  // 0x5403  吃
  3,84,32,34,16,36,3,253,0,0,0,0,144,0,0,0,0,0,0,2,252,0,0,0,0,0,0,3,252,0,0,0,255,255,224,3,244,0,0,0,255,255,224,11,240,0,0,0,255,255,224,15,240,0,0,0,252,11,224,31,255,255,255,252,252,7,224,63,255,255,255,252,252,7,224,191,255,255,255,252,252,7,224,254,0,0,0,0,252,7,227,252,0,0,0,0,252,7,239,244,0,0,0,0,252,7,235,224,0,0,0,0,252,7,225,207,255,255,255,64,252,7,224,15,255,255,255,192,252,7,224,15,255,255,255,0,252,7,224,0,0,31,252,0,252,7,224,0,0,127,224,0,252,7,224,0,1,255,128,0,252,7,224,0,7,253,0,0,252,7,224,0,31,244,0,0,252,11,224,0,127,192,0,0,255,255,224,1,255,0,0,0,255,255,224,7,252,0,0,0,255,255,224,15,240,0,0,0,252,0,0,63,192,0,0,116,252,0,0,191,0,0,0,126,248,0,0,253,0,0,0,126,0,0,1,252,0,0,0,189,0,0,1,253,0,0,0,253,0,0,0,255,255,255,255,252,0,0,0,191,255,255,255,248,0,0,0,31,255,255,255,224,0,0,0,0,21,85,84,0,
  // 0x5408  合
  8,84,34,35,59,36,1,252,0,0,0,3,248,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,47,255,64,0,0,0,0,0,0,127,255,192,0,0,0,0,0,1,255,31,240,0,0,0,0,0,7,253,11,252,0,0,0,0,0,31,248,2,255,64,0,0,0,0,127,224,0,191,208,0,0,0,1,255,128,0,47,248,0,0,0,11,254,0,0,7,255,0,0,0,63,248,0,0,1,255,208,0,1,255,208,0,0,0,127,253,0,15,255,255,255,255,255,255,255,128,127,248,255,255,255,255,241,255,224,63,192,255,255,255,255,240,47,192,13,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,0,0,0,15,255,255,255,255,255,0,0,0,15,255,255,255,255,255,0,0,0,15,208,0,0,0,127,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,208,0,0,0,63,0,0,0,15,255,255,255,255,255,0,0,0,15,255,255,255,255,255,0,0,0,15,255,255,255,255,255,0,0,0,15,208,0,0,0,63,0,0,0,0,0,0,0,0,0,0,0,
  // 0x540d  名
  13,84,31,34,16,36,1,253,0,0,0,249,0,0,0,0,0,0,2,254,0,0,0,0,0,0,3,252,0,0,0,0,0,0,15,244,0,0,0,0,0,0,47,255,255,255,208,0,0,0,191,255,255,255,240,0,0,1,255,255,255,255,224,0,0,11,253,0,0,47,192,0,0,47,244,0,0,127,128,0,0,255,240,0,0,255,0,0,11,255,252,0,2,253,0,0,63,255,255,64,7,252,0,0,63,224,191,224,15,240,0,0,15,64,31,248,63,208,0,0,4,0,7,254,255,128,0,0,0,0,1,255,254,0,0,0,0,0,0,127,248,0,0,0,0,0,0,191,224,0,0,0,0,0,3,255,255,255,255,252,0,0,47,255,255,255,255,252,0,1,255,255,255,255,255,252,0,31,255,240,0,0,2,252,6,255,255,240,0,0,1,252,127,255,215,240,0,0,1,252,63,253,7,240,0,0,1,252,31,128,7,240,0,0,1,252,4,0,7,240,0,0,1,252,0,0,7,240,0,0,1,252,0,0,7,240,0,0,1,252,0,0,7,255,255,255,255,252,0,0,7,255,255,255,255,252,0,0,7,255,255,255,255,252,0,0,7,240,0,0,2,252,0,0,6,160,0,0,1,252,
  // 0x540e  后
  14,84,34,34,50,36,1,253,0,0,0,0,0,0,6,64,0,0,0,0,0,0,91,255,208,0,0,0,0,22,191,255,255,244,0,0,191,255,255,255,255,254,64,0,0,191,255,255,255,233,64,0,0,0,191,255,169,64,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,224,0,191,255,255,255,255,255,255,224,0,191,255,255,255,255,255,255,224,0,190,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,253,11,255,255,255,255,248,0,0,253,11,255,255,255,255,248,0,0,252,11,255,255,255,255,248,0,1,252,11,224,0,0,3,248,0,1,252,11,224,0,0,3,248,0,2,252,11,224,0,0,3,248,0,3,248,11,224,0,0,3,248,0,3,244,11,224,0,0,3,248,0,7,240,11,224,0,0,3,248,0,11,240,11,224,0,0,3,248,0,15,224,11,224,0,0,3,248,0,47,192,11,255,255,255,255,248,0,63,128,11,255,255,255,255,248,0,191,64,11,255,255,255,255,248,0,46,0,11,224,0,0,3,248,0,8,0,11,224,0,0,2,244,0,
  // 0x5411  向
  17,84,30,34,16,36,3,253,0,0,0,190,64,0,0,0,0,0,0,255,0,0,0,0,0,0,1,254,0,0,0,0,0,0,2,253,0,0,0,0,0,0,3,252,0,0,0,0,0,0,7,244,0,0,0,0,127,255,255,255,255,255,255,224,127,255,255,255,255,255,255,224,127,255,255,255,255,255,255,224,127,85,85,85,85,85,95,224,127,0,0,0,0,0,11,224,127,0,0,0,0,0,11,224,127,0,0,0,0,0,11,224,127,0,0,0,0,0,11,224,127,0,255,255,255,240,11,224,127,0,255,255,255,240,11,224,127,0,255,255,255,240,11,224,127,0,252,0,3,240,11,224,127,0,252,0,3,240,11,224,127,0,252,0,3,240,11,224,127,0,252,0,3,240,11,224,127,0,252,0,3,240,11,224,127,0,252,0,3,240,11,224,127,0,255,255,255,240,11,224,127,0,255,255,255,240,11,224,127,0,255,255,255,240,11,224,127,0,252,0,0,0,11,224,127,0,252,0,0,0,11,224,127,0,252,0,0,0,11,224,127,0,0,0,0,0,11,224,127,0,0,0,0,85,95,224,127,0,0,0,0,255,255,208,127,0,0,0,0,127,255,192,127,0,0,0,0,63,250,0,
  // 0x5426  否
  38,84,33,32,32,36,1,253,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,0,0,0,0,255,192,0,0,0,0,0,0,3,255,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,127,248,4,0,0,0,0,0,2,255,248,63,128,0,0,0,0,31,255,248,255,248,0,0,0,1,255,247,248,47,255,64,0,0,31,255,131,248,2,255,240,0,1,255,253,3,248,0,47,254,0,111,255,224,3,248,0,7,255,192,63,254,0,3,248,0,0,191,192,31,224,0,3,248,0,0,31,0,10,0,0,3,248,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,47,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,255,255,255,255,255,192,0,0,47,128,0,0,0,47,192,0,0,47,128,0,0,0,26,128,0,
  // 0x542f  启
  47,84,31,35,24,36,1,252,0,0,0,0,0,0,25,0,0,0,0,0,1,111,255,64,0,0,1,106,255,255,255,192,0,235,255,255,255,255,233,0,0,255,255,255,255,148,0,0,0,255,254,149,0,0,0,0,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,255,255,255,255,255,255,244,0,255,255,255,255,255,255,244,0,255,255,255,255,255,255,244,0,253,0,0,0,0,3,244,0,253,0,0,0,0,3,244,0,253,0,0,0,0,3,244,0,253,0,0,0,0,3,244,0,255,255,255,255,255,255,244,0,255,255,255,255,255,255,244,0,255,255,255,255,255,255,244,0,253,0,0,0,0,0,0,0,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,127,255,255,255,255,248,1,252,127,255,255,255,255,252,2,248,127,255,255,255,255,252,3,248,127,0,0,0,2,252,3,244,127,0,0,0,2,252,7,240,127,0,0,0,2,252,11,240,127,0,0,0,2,252,15,224,127,0,0,0,2,252,31,208,127,0,0,0,2,252,63,192,127,255,255,255,255,252,127,64,127,255,255,255,255,252,47,0,127,255,255,255,255,252,5,0,127,0,0,0,2,252,0,0,0,0,0,0,0,0,
  // 0x544a  告
  74,84,32,35,24,36,2,252,0,6,64,3,248,0,0,0,0,15,240,3,248,0,0,0,0,15,208,3,248,0,0,0,0,47,192,3,248,0,0,0,0,63,128,3,248,0,0,0,0,191,255,255,255,255,255,208,1,255,255,255,255,255,255,208,3,255,255,255,255,255,255,208,11,244,0,3,248,0,0,0,31,240,0,3,248,0,0,0,63,192,0,3,248,0,0,0,31,64,0,3,248,0,0,0,1,0,0,3,248,0,0,0,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,127,255,255,255,255,255,0,0,127,0,0,0,0,191,0,0,127,0,0,0,0,191,0,0,0,0,0,0,0,0,0,
  // 0x5468  周
  104,84,31,33,8,36,1,252,0,255,255,255,255,255,255,252,0,255,255,255,255,255,255,252,0,255,255,255,255,255,255,252,0,253,0,0,84,0,1,252,0,253,0,1,248,0,1,252,0,253,0,1,248,0,1,252,0,253,10,171,254,170,129,252,0,253,31,255,255,255,193,252,0,253,31,255,255,255,193,252,0,253,0,1,248,0,1,252,0,253,0,1,248,0,1,252,0,253,0,1,248,0,1,252,0,253,42,171,254,170,161,252,0,253,63,255,255,255,241,252,0,253,63,255,255,255,241,252,0,253,0,0,0,0,1,252,0,253,0,0,0,0,1,252,0,252,6,170,170,170,1,252,0,252,11,255,255,255,1,252,1,252,11,255,255,255,1,252,1,252,11,208,0,63,1,252,2,248,11,208,0,63,1,252,3,248,11,208,0,63,1,252,3,244,11,208,0,63,1,252,7,240,11,208,0,63,1,252,11,240,11,255,255,255,1,252,15,224,11,255,255,255,1,252,31,208,11,250,170,170,1,252,63,192,11,208,0,0,2,252,127,64,6,128,0,15,255,248,127,0,0,0,0,11,255,244,13,0,0,0,0,7,255,128,0,0,0,0,0,0,0,0,
  // 0x547d  命
  125,84,34,35,59,36,1,252,0,0,0,11,252,0,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,127,255,128,0,0,0,0,0,1,255,111,224,0,0,0,0,0,7,253,11,252,0,0,0,0,0,47,248,2,255,0,0,0,0,0,255,208,0,191,208,0,0,0,7,255,64,0,31,248,0,0,0,47,252,0,0,3,255,64,0,2,255,255,255,255,255,255,240,0,31,255,223,255,255,255,111,255,64,255,253,15,255,255,255,71,255,240,127,224,0,0,0,0,0,191,208,46,0,0,0,0,0,0,11,128,0,0,0,0,0,0,0,0,0,0,255,255,252,15,255,255,248,0,0,255,255,252,15,255,255,248,0,0,255,255,252,15,255,255,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,252,0,252,15,192,2,248,0,0,255,255,252,15,192,2,248,0,0,255,255,252,15,192,2,248,0,0,255,255,252,15,195,255,244,0,0,252,0,0,15,194,255,240,0,0,252,0,0,15,193,255,144,0,0,252,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x548c  和
  140,84,32,34,16,36,1,253,0,0,0,4,0,0,0,0,0,0,1,252,0,0,0,0,0,1,191,255,0,0,0,0,6,255,255,255,64,0,0,0,47,255,255,144,15,255,255,254,15,255,252,0,15,255,255,254,4,1,252,0,15,255,255,254,0,1,252,0,15,192,0,254,0,1,252,0,15,192,0,254,0,1,252,0,15,192,0,254,0,1,252,0,15,192,0,254,63,255,255,255,143,192,0,254,63,255,255,255,143,192,0,254,63,255,255,255,143,192,0,254,0,7,252,0,15,192,0,254,0,15,254,0,15,192,0,254,0,15,255,64,15,192,0,254,0,47,255,208,15,192,0,254,0,63,255,240,15,192,0,254,0,191,254,252,15,192,0,254,0,253,252,255,15,192,0,254,3,245,252,63,143,192,0,254,7,241,252,47,15,192,0,254,15,209,252,13,15,192,0,254,63,193,252,0,15,192,0,254,191,65,252,0,15,192,0,254,190,1,252,0,15,255,255,254,60,1,252,0,15,255,255,254,16,1,252,0,15,255,255,254,0,1,252,0,15,208,0,254,0,1,252,0,15,192,0,254,0,1,252,0,15,192,0,254,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,
  // 0x54cd  响
  205,84,32,34,16,36,2,253,0,0,0,0,0,233,0,0,0,0,0,0,1,254,0,0,0,0,0,0,2,252,0,0,127,255,240,0,3,252,0,0,127,255,240,0,7,244,0,0,127,255,240,0,11,240,0,0,126,3,240,191,255,255,255,254,126,3,240,191,255,255,255,254,126,3,240,191,255,255,255,254,126,3,240,189,0,0,0,190,126,3,240,189,0,0,0,190,126,3,240,189,0,0,0,190,126,3,240,189,5,85,80,190,126,3,240,189,15,255,240,190,126,3,240,189,15,255,240,190,126,3,240,189,15,65,240,190,126,3,240,189,15,65,240,190,126,3,240,189,15,65,240,190,126,3,240,189,15,65,240,190,126,3,240,189,15,65,240,190,126,3,240,189,15,65,240,190,127,255,240,189,15,65,240,190,127,255,240,189,15,150,240,190,127,255,240,189,15,255,240,190,126,0,0,189,15,255,240,190,126,0,0,189,15,64,0,190,126,0,0,189,15,64,0,190,41,0,0,189,0,0,0,190,0,0,0,189,0,0,0,190,0,0,0,189,0,0,0,190,0,0,0,189,0,0,0,190,0,0,0,189,0,0,127,254,0,0,0,189,0,0,63,252,0,0,0,189,0,0,47,224,
  // 0x55b7  喷
  183,85,33,34,50,36,2,253,0,0,0,0,1,164,0,0,0,0,0,0,0,1,248,0,0,0,0,0,0,0,1,248,0,0,0,127,255,192,170,171,254,170,168,0,127,255,193,255,255,255,255,252,0,127,255,193,255,255,255,255,252,0,125,11,192,0,1,248,0,0,0,124,11,192,11,193,248,47,0,0,124,11,192,15,208,0,63,0,0,124,11,198,175,250,170,191,170,0,124,11,203,255,255,255,255,255,0,124,11,203,255,255,255,255,255,0,124,11,192,15,208,0,63,0,0,124,11,192,15,208,0,63,0,0,124,11,192,0,0,0,0,0,0,124,11,192,42,170,170,170,160,0,124,11,192,127,255,255,255,240,0,124,11,192,127,255,255,255,240,0,124,11,192,126,0,0,3,240,0,124,11,192,126,0,0,3,240,0,124,11,192,126,1,164,3,240,0,127,255,192,126,1,248,3,240,0,127,255,192,126,1,248,3,240,0,127,255,192,126,1,248,3,240,0,125,0,0,126,1,248,3,240,0,124,0,0,126,2,248,3,240,0,124,0,0,126,3,244,3,240,0,40,0,0,21,11,241,145,80,0,0,0,0,0,63,211,253,0,0,0,0,0,2,255,65,255,208,0,0,0,1,191,252,0,47,253,0,0,0,63,255,208,0,2,255,192,0,0,15,249,0,0,0,63,64,0,0,5,0,0,0,0,6,0,
  // 0x5634  嘴
  52,86,33,35,59,36,2,252,0,0,0,2,240,15,192,0,0,0,0,0,3,240,15,192,0,0,0,0,1,131,240,15,192,112,0,127,255,195,211,240,15,194,252,0,127,255,195,211,255,223,239,244,0,127,255,195,211,255,223,255,64,0,124,11,195,211,245,79,244,0,0,124,11,195,211,240,15,192,0,0,124,11,195,211,240,15,192,15,64,124,11,195,211,246,159,192,15,64,124,11,195,255,255,223,229,111,64,124,11,239,255,255,219,255,255,0,124,11,239,255,252,2,255,252,0,124,11,218,67,248,1,0,0,0,124,11,192,11,255,255,192,0,0,124,11,192,31,255,255,208,0,0,124,11,192,127,64,47,128,0,0,124,11,193,255,0,127,64,0,0,124,11,203,255,255,255,255,248,0,124,11,255,255,255,255,255,248,0,127,255,207,190,0,248,2,248,0,127,255,192,126,0,248,2,248,0,127,255,192,127,255,255,255,248,0,124,0,0,127,255,255,255,248,0,124,0,0,190,0,248,2,248,0,124,0,0,189,0,248,2,248,0,40,0,0,254,1,252,2,248,0,0,0,0,255,255,255,255,248,0,0,0,2,255,255,255,255,248,0,0,0,3,248,0,0,2,248,0,0,0,15,240,0,0,2,248,0,0,0,63,208,0,1,87,244,0,0,0,191,64,0,3,255,240,0,0,0,29,0,0,1,255,144,0,0,0,0,0,0,0,0,0,0,
  // 0x5668  器
  104,86,34,34,50,36,1,252,1,170,170,168,2,170,170,168,0,2,255,255,252,3,255,255,248,0,2,255,255,252,3,255,255,248,0,2,244,0,252,3,240,1,248,0,2,244,0,252,3,240,1,248,0,2,244,0,252,3,240,1,248,0,2,244,0,252,3,240,1,248,0,2,244,0,252,3,240,1,248,0,2,254,170,252,3,250,171,248,0,2,255,255,252,3,255,255,248,0,2,255,255,255,147,255,255,248,0,0,0,0,15,240,0,0,0,0,0,0,0,63,192,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,63,240,0,255,64,0,0,0,1,255,192,0,63,224,0,0,0,11,255,0,0,31,253,0,0,0,191,252,0,0,3,255,208,0,27,255,224,0,0,0,255,253,0,255,255,255,253,11,255,255,255,224,127,255,255,253,11,255,255,255,208,47,255,255,253,11,255,255,255,128,0,252,0,189,11,208,3,240,0,0,252,0,189,11,208,3,240,0,0,252,0,189,11,208,3,240,0,0,252,0,189,11,208,3,240,0,0,252,0,189,11,208,3,240,0,0,255,255,253,11,255,255,240,0,0,255,255,253,11,255,255,240,0,0,255,255,253,11,255,255,240,0,0,252,0,189,11,208,3,240,0,0,0,0,0,0,0,0,0,0,
  // 0x5674  噴
  116,86,33,35,59,36,2,252,0,0,0,0,0,252,0,0,0,0,0,0,0,0,252,0,0,0,0,0,0,85,85,253,85,84,0,0,0,0,255,255,255,255,252,0,127,255,240,255,255,255,255,252,0,127,255,240,0,0,252,0,0,0,127,255,240,7,208,252,47,0,0,125,3,240,7,208,168,47,0,0,125,3,241,91,229,85,127,85,0,125,3,251,255,255,255,255,255,128,125,3,251,255,255,255,255,255,128,125,3,240,7,208,0,47,0,0,125,3,240,7,208,0,47,0,0,125,3,240,0,0,0,0,0,0,125,3,240,127,255,255,255,240,0,125,3,240,127,255,255,255,240,0,125,3,240,126,0,0,3,240,0,125,3,240,126,0,0,3,240,0,125,3,240,127,255,255,255,240,0,125,3,240,127,255,255,255,240,0,125,3,240,126,0,0,3,240,0,127,255,240,126,0,0,3,240,0,127,255,240,127,255,255,255,240,0,127,255,240,127,255,255,255,240,0,125,0,0,126,0,0,3,240,0,125,0,0,126,0,0,3,240,0,61,0,0,127,255,255,255,240,0,0,0,0,127,255,255,255,240,0,0,0,0,2,228,0,248,0,0,0,0,0,31,252,2,255,64,0,0,0,6,255,224,0,127,244,0,0,0,127,255,0,0,11,254,0,0,0,63,228,0,0,0,255,64,0,0,14,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,
  // 0x56de  回
  222,86,30,33,8,36,3,253,85,85,85,85,85,85,85,80,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,255,255,255,240,11,240,253,0,255,255,255,240,11,240,253,0,255,255,255,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,252,0,7,240,11,240,253,0,255,255,255,240,11,240,253,0,255,255,255,240,11,240,253,0,255,255,255,240,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,254,0,0,0,0,0,11,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,
  // 0x56e0  因
  224,86,30,32,0,36,3,253,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,253,0,0,0,0,0,7,240,253,0,0,26,64,0,7,240,253,0,0,47,64,0,7,240,253,0,0,63,64,0,7,240,253,0,0,63,64,0,7,240,253,0,0,63,0,0,7,240,253,0,0,63,0,0,7,240,253,63,255,255,255,255,199,240,253,63,255,255,255,255,199,240,253,63,255,255,255,255,199,240,253,0,0,127,192,0,7,240,253,0,0,191,208,0,7,240,253,0,0,255,240,0,7,240,253,0,1,255,240,0,7,240,253,0,3,249,252,0,7,240,253,0,7,240,253,0,7,240,253,0,31,240,191,64,7,240,253,0,127,192,63,208,7,240,253,1,255,64,15,248,7,240,253,31,253,0,7,255,135,240,253,63,240,0,0,255,135,240,253,31,128,0,0,47,7,240,253,4,0,0,0,0,7,240,253,0,0,0,0,0,7,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,7,240,
  // 0x56fa  固
  250,86,30,32,0,36,3,253,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,253,0,0,0,0,0,11,240,253,0,0,21,64,0,11,240,253,0,0,47,128,0,11,240,253,0,0,47,128,0,11,240,253,0,0,47,128,0,11,240,253,26,170,191,234,170,139,240,253,47,255,255,255,255,139,240,253,47,255,255,255,255,139,240,253,0,0,47,128,0,11,240,253,0,0,47,128,0,11,240,253,0,0,47,128,0,11,240,253,1,170,191,234,164,11,240,253,2,255,255,255,252,11,240,253,2,255,255,255,252,11,240,253,2,244,0,1,252,11,240,253,2,244,0,1,252,11,240,253,2,244,0,1,252,11,240,253,2,244,0,1,252,11,240,253,2,254,170,170,252,11,240,253,2,255,255,255,252,11,240,253,2,255,255,255,252,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,253,0,0,0,0,0,11,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,254,0,0,0,0,0,11,240,253,0,0,0,0,0,7,240,
  // 0x56fe  图
  254,86,30,33,8,36,3,252,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,252,0,1,64,0,0,7,240,252,0,3,244,0,0,7,240,252,0,15,224,0,0,7,240,252,0,63,255,255,253,7,240,252,0,255,255,255,255,7,240,252,3,254,170,171,252,7,240,252,31,255,0,11,240,7,240,252,191,239,208,47,208,7,240,252,62,11,249,255,0,7,240,252,4,1,255,252,0,7,240,252,0,1,255,248,0,7,240,252,0,47,255,255,208,7,240,252,27,255,244,191,255,151,240,254,255,255,64,11,255,247,240,252,191,226,144,0,111,199,240,252,121,7,255,128,0,71,240,252,0,2,255,253,0,7,240,252,0,0,7,255,0,7,240,252,0,0,0,45,0,7,240,252,0,255,228,0,0,7,240,252,3,255,255,228,0,7,240,252,0,27,255,255,228,7,240,252,0,0,6,255,244,7,240,252,0,0,0,7,240,7,240,252,0,0,0,0,0,7,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,252,0,0,0,0,0,7,240,0,0,0,0,0,0,0,0,
  // 0x5728  在
  40,87,33,34,50,36,1,253,0,0,0,100,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,3,252,0,0,0,0,0,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,0,0,47,192,0,0,0,0,0,0,0,127,128,0,20,0,0,0,0,0,255,0,0,190,0,0,0,0,2,253,0,0,190,0,0,0,0,7,252,0,0,190,0,0,0,0,15,240,0,0,190,0,0,0,0,63,208,0,0,190,0,0,0,0,191,192,0,0,190,0,0,0,2,255,192,127,255,255,255,253,0,15,255,192,127,255,255,255,253,0,63,255,192,127,255,255,255,253,0,127,223,192,0,0,254,0,0,0,63,31,192,0,0,190,0,0,0,24,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,190,0,0,0,0,31,192,0,0,254,0,0,0,0,31,195,255,255,255,255,255,128,0,31,195,255,255,255,255,255,128,0,31,195,255,255,255,255,255,128,0,31,192,0,0,0,0,0,0,
  // 0x574f  坏
  79,87,34,34,50,36,1,253,0,42,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,1,255,255,255,255,255,208,0,63,1,255,255,255,255,255,208,0,63,1,255,255,255,255,255,208,0,63,0,0,0,15,240,0,0,0,63,0,0,0,31,224,0,0,0,63,0,0,0,63,192,0,0,0,63,0,0,0,191,128,0,0,63,255,255,0,0,255,0,0,0,63,255,255,0,3,254,0,0,0,63,255,255,0,15,254,32,0,0,0,63,64,0,47,254,253,0,0,0,63,0,0,191,255,255,128,0,0,63,0,2,255,254,63,224,0,0,63,0,15,253,190,15,252,0,0,63,0,127,240,190,2,255,0,0,63,3,255,192,190,0,191,192,0,63,7,255,0,190,0,47,240,0,63,2,248,0,190,0,11,192,0,63,0,144,0,190,0,2,0,0,63,7,64,0,190,0,0,0,0,63,255,64,0,190,0,0,0,0,127,255,128,0,190,0,0,0,27,255,254,0,0,190,0,0,0,191,255,208,0,0,190,0,0,0,127,248,0,0,0,190,0,0,0,63,64,0,0,0,190,0,0,0,16,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,
  // 0x5757  块
  87,87,33,35,59,36,1,252,0,21,0,0,1,164,0,0,0,0,63,0,0,2,248,0,0,0,0,63,0,0,2,248,0,0,0,0,63,0,0,2,248,0,0,0,0,63,0,0,2,248,0,0,0,0,63,0,0,2,248,0,0,0,0,63,0,31,255,255,255,248,0,0,63,0,31,255,255,255,248,0,0,63,64,31,255,255,255,248,0,63,255,255,0,2,248,2,248,0,63,255,255,0,2,248,1,248,0,63,255,255,0,2,248,1,248,0,0,63,0,0,2,248,1,248,0,0,63,0,0,2,248,1,248,0,0,63,0,0,2,248,1,248,0,0,63,0,0,2,248,1,248,0,0,63,0,0,2,248,2,248,0,0,63,0,191,255,255,255,255,192,0,63,0,191,255,255,255,255,192,0,63,0,191,255,255,255,255,192,0,63,11,0,7,255,128,0,0,0,63,255,0,11,255,192,0,0,0,63,255,64,15,239,208,0,0,6,255,253,0,31,199,240,0,0,127,255,208,0,63,195,248,0,0,127,249,0,0,191,66,252,0,0,63,128,0,1,255,0,255,0,0,40,0,0,3,252,0,127,192,0,0,0,0,31,248,0,63,240,0,0,0,0,191,224,0,15,253,0,0,0,7,255,128,0,3,255,128,0,0,31,254,0,0,0,255,192,0,0,11,240,0,0,0,63,64,0,0,3,64,0,0,0,6,0,0,0,0,0,0,0,0,0,0,
  // 0x578b  型
  139,87,32,33,8,36,2,254,0,0,0,0,0,0,3,240,31,255,255,255,224,0,3,240,31,255,255,255,224,190,3,240,31,255,255,255,224,190,3,240,0,63,1,252,0,190,3,240,0,63,1,252,0,190,3,240,0,63,1,252,0,190,3,240,0,63,1,252,0,190,3,240,0,63,1,252,0,190,3,240,191,255,255,255,248,190,3,240,191,255,255,255,248,190,3,240,191,255,255,255,248,190,3,240,0,190,1,252,0,190,3,240,0,253,1,252,0,190,3,240,1,252,1,252,0,20,3,240,3,248,1,252,0,0,3,240,15,240,1,252,0,0,3,240,127,208,1,252,0,11,255,240,191,128,1,252,0,3,255,240,62,0,0,175,240,3,255,128,4,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,1,255,255,255,255,255,255,64,1,255,255,255,255,255,255,64,1,255,255,255,255,255,255,64,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x57ab  垫
  171,87,33,33,41,36,2,254,0,47,64,0,11,208,0,0,0,0,47,64,0,11,208,0,0,0,0,47,64,0,11,208,0,0,0,0,47,128,0,11,208,0,0,0,255,255,255,143,255,255,255,128,0,255,255,255,143,255,255,255,128,0,255,255,255,143,255,255,255,128,0,0,47,64,0,15,192,31,128,0,0,47,64,0,15,192,31,128,0,0,47,65,71,159,192,31,128,0,0,47,255,207,255,128,31,128,0,91,255,255,203,255,128,31,128,0,255,255,254,64,255,208,31,128,0,255,255,128,0,127,248,31,128,0,185,47,64,0,255,255,95,128,0,0,47,64,2,252,191,79,139,64,0,47,64,11,244,31,15,203,192,0,47,64,63,224,0,15,207,192,47,255,64,255,128,0,11,255,128,15,255,0,62,0,0,3,255,0,15,248,0,31,224,0,0,189,0,0,0,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,2,255,255,255,255,255,255,128,0,2,255,255,255,255,255,255,128,0,1,255,255,255,255,255,255,128,0,0,0,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,0,0,0,11,224,0,0,0,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,
  // 0x586b  填
  107,88,34,35,59,36,1,252,0,21,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,1,255,255,255,255,255,192,0,63,1,255,255,255,255,255,192,0,63,1,255,255,255,255,255,192,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,11,255,255,255,244,0,63,255,254,11,255,255,255,244,0,63,255,254,11,208,0,3,244,0,63,255,254,11,208,0,3,244,0,0,63,0,11,255,255,255,244,0,0,63,0,11,255,255,255,244,0,0,63,0,11,208,0,3,244,0,0,63,0,11,208,0,3,244,0,0,63,0,11,255,255,255,244,0,0,63,0,11,255,255,255,244,0,0,63,0,11,208,0,3,244,0,0,63,0,11,208,0,3,244,0,0,63,11,11,255,255,255,244,0,0,63,255,11,255,255,255,244,0,0,63,255,64,0,0,0,0,0,2,255,254,0,0,0,0,0,0,111,255,235,255,255,255,255,255,208,191,254,11,255,255,255,255,255,224,63,208,11,255,255,255,255,255,224,61,0,0,0,16,0,8,0,0,0,0,0,1,255,0,127,64,0,0,0,0,11,253,0,127,224,0,0,0,1,191,240,0,11,253,0,0,0,15,255,128,0,1,255,128,0,0,11,248,0,0,0,63,208,0,0,2,144,0,0,0,10,0,0,0,0,0,0,0,0,0,0,
  // 0x58f3  壳
  243,88,32,34,16,36,2,253,0,0,0,11,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,106,170,170,175,250,170,170,169,0,0,0,15,224,0,0,0,1,85,85,95,245,85,85,64,2,255,255,255,255,255,255,192,2,255,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,170,170,170,170,170,170,252,63,0,0,0,0,0,0,252,63,5,85,85,85,85,80,252,63,15,255,255,255,255,240,252,0,15,255,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,0,0,0,3,255,255,255,255,0,0,0,3,255,255,255,255,0,0,0,3,244,0,0,191,0,0,0,3,244,0,0,191,0,0,0,7,240,0,0,191,0,16,0,15,240,0,0,191,0,61,0,63,208,0,0,191,0,63,2,255,128,0,0,127,0,126,111,254,0,0,0,127,255,253,127,248,0,0,0,63,255,252,63,128,0,0,0,31,255,240,8,0,0,0,0,0,0,0,
  // 0x5907  备
  7,89,34,35,59,36,1,252,0,0,0,249,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,47,255,255,255,253,0,0,0,0,191,255,255,255,255,0,0,0,3,255,255,255,255,253,0,0,0,31,253,0,0,11,248,0,0,0,191,255,128,0,63,240,0,0,11,255,191,224,1,255,192,0,0,11,253,15,253,11,254,0,0,0,3,224,2,255,255,244,0,0,0,0,0,0,127,255,192,0,0,0,0,0,1,255,255,249,0,0,0,0,0,127,255,255,255,228,0,0,1,175,255,254,11,255,255,250,64,191,255,255,208,0,111,255,255,224,127,255,244,0,0,1,191,255,192,63,249,0,0,0,0,1,175,0,20,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,64,3,248,0,63,192,0,0,63,64,3,248,0,63,192,0,0,63,64,3,248,0,63,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,234,171,254,170,191,192,0,0,63,64,3,248,0,63,192,0,0,63,64,3,248,0,63,192,0,0,63,64,3,248,0,63,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,64,0,0,0,63,128,0,0,0,0,0,0,0,0,0,0,
  // 0x590d  复
  13,89,24,35,210,36,6,252,0,15,128,0,0,0,0,31,192,0,0,0,0,63,128,0,0,0,0,191,255,255,255,224,0,255,255,255,255,240,3,255,255,255,255,240,11,244,0,0,0,0,31,240,0,0,0,0,127,224,0,0,0,0,255,255,255,255,255,0,190,255,255,255,255,0,24,189,0,0,63,0,0,189,0,0,63,0,0,191,255,255,255,0,0,191,255,255,255,0,0,189,0,0,63,0,0,189,0,0,63,0,0,191,255,255,255,0,0,191,255,255,255,0,0,1,254,0,0,0,0,3,252,0,0,0,0,15,255,255,254,0,0,63,255,255,255,0,1,255,149,86,254,0,11,255,192,3,252,0,191,251,244,15,244,0,127,130,254,127,208,0,28,0,191,255,64,0,0,0,63,254,0,0,0,6,255,255,224,0,1,191,255,191,255,148,127,255,228,11,255,253,63,254,0,0,191,248,30,64,0,0,1,176,0,0,0,0,0,0,
  // 0x5916  外
  22,89,34,34,50,36,1,253,0,0,164,0,0,3,244,0,0,0,0,254,0,0,3,244,0,0,0,0,253,0,0,3,244,0,0,0,2,252,0,0,3,244,0,0,0,3,248,0,0,3,244,0,0,0,3,248,0,0,3,244,0,0,0,11,255,255,248,3,244,0,0,0,15,255,255,252,3,244,0,0,0,31,255,255,252,3,244,0,0,0,63,192,3,255,3,244,0,0,0,127,64,3,255,195,244,0,0,0,255,0,7,255,211,244,0,0,2,252,0,11,251,243,244,0,0,7,252,0,15,227,255,244,0,0,15,254,0,15,208,255,244,0,0,63,255,208,31,192,127,244,0,0,255,175,248,63,128,47,244,0,0,47,7,255,127,64,15,248,0,0,8,0,255,255,0,3,255,0,0,0,0,47,254,0,3,255,208,0,0,0,11,252,0,3,255,248,0,0,0,3,248,0,3,255,255,64,0,0,15,240,0,3,246,255,240,0,0,47,208,0,3,244,127,224,0,0,63,192,0,3,244,11,128,0,0,255,64,0,3,244,1,0,0,3,254,0,0,3,244,0,0,0,15,248,0,0,3,244,0,0,0,63,240,0,0,3,244,0,0,1,255,192,0,0,3,244,0,0,15,255,0,0,0,3,244,0,0,47,248,0,0,0,3,244,0,0,11,208,0,0,0,3,244,0,0,2,0,0,0,0,3,244,0,0,
  // 0x591a  多
  26,89,32,35,24,36,2,252,0,0,0,46,64,0,0,0,0,0,0,191,192,0,0,0,0,0,2,255,0,0,0,0,0,0,11,255,255,255,224,0,0,0,127,255,255,255,244,0,0,2,255,255,255,255,224,0,0,47,253,0,0,63,192,0,6,255,252,0,0,255,64,0,63,255,255,128,3,253,0,0,31,244,127,244,15,248,0,0,11,64,11,254,127,224,0,0,0,0,1,255,255,64,0,0,0,0,0,127,253,64,0,0,0,0,2,255,231,252,0,0,0,0,127,255,79,244,0,0,0,27,255,244,127,224,0,0,26,255,255,66,255,255,255,248,127,255,224,15,255,255,255,253,47,249,0,191,255,255,255,252,25,0,11,255,128,0,11,244,0,0,191,253,0,0,31,240,0,31,255,255,64,0,63,192,0,127,253,191,240,0,255,64,0,31,144,31,253,3,254,0,0,8,0,2,255,159,248,0,0,0,0,0,127,255,224,0,0,0,0,0,31,255,64,0,0,0,0,0,191,252,0,0,0,0,0,27,255,224,0,0,0,0,22,255,254,0,0,0,0,91,255,255,224,0,0,0,2,255,255,249,0,0,0,0,0,255,254,64,0,0,0,0,0,186,64,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5927  大
  39,89,32,34,16,36,2,253,0,0,0,15,224,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,85,85,85,111,229,85,85,85,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,0,0,0,63,252,0,0,0,0,0,0,127,253,0,0,0,0,0,0,191,254,0,0,0,0,0,0,255,191,0,0,0,0,0,1,254,127,64,0,0,0,0,2,252,63,192,0,0,0,0,3,252,31,224,0,0,0,0,11,244,15,240,0,0,0,0,31,240,11,252,0,0,0,0,63,208,3,253,0,0,0,0,191,192,0,255,64,0,0,2,255,0,0,191,208,0,0,11,253,0,0,63,244,0,0,47,248,0,0,15,253,0,0,255,224,0,0,3,255,128,7,255,128,0,0,0,255,240,127,254,0,0,0,0,63,254,255,244,0,0,0,0,15,254,63,128,0,0,0,0,1,252,8,0,0,0,0,0,0,32,
  // 0x5929  天
  41,89,33,33,41,36,2,252,85,85,85,85,85,85,85,85,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,47,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,252,0,47,255,255,255,255,255,255,252,0,21,85,85,127,249,85,85,84,0,0,0,0,63,252,0,0,0,0,0,0,0,63,253,0,0,0,0,0,0,0,127,255,0,0,0,0,0,0,0,255,191,0,0,0,0,0,0,1,254,63,192,0,0,0,0,0,3,252,47,224,0,0,0,0,0,15,248,15,244,0,0,0,0,0,63,240,7,252,0,0,0,0,0,255,208,2,255,64,0,0,0,7,255,64,0,255,208,0,0,0,47,253,0,0,63,253,0,0,2,255,244,0,0,15,255,208,0,127,255,128,0,0,2,255,254,64,255,253,0,0,0,0,127,255,0,127,208,0,0,0,0,7,253,0,57,0,0,0,0,0,0,40,0,0,0,0,0,0,0,0,0,0,
  // 0x592a  太
  42,89,34,35,59,36,1,252,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,244,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,21,85,85,91,245,85,85,85,64,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,0,0,0,15,255,0,0,0,0,0,0,0,31,255,128,0,0,0,0,0,0,47,255,192,0,0,0,0,0,0,63,159,208,0,0,0,0,0,0,63,79,224,0,0,0,0,0,0,191,11,240,0,0,0,0,0,0,255,3,248,0,0,0,0,0,1,253,3,252,0,0,0,0,0,3,252,1,255,0,0,0,0,0,11,248,0,191,64,0,0,0,0,31,240,0,63,192,0,0,0,0,63,215,0,47,240,0,0,0,0,255,239,208,15,248,0,0,0,3,255,63,244,7,254,0,0,0,15,253,11,253,2,255,128,0,0,127,244,2,255,64,191,240,0,2,255,208,0,191,208,47,253,0,47,255,64,0,63,240,11,255,208,127,252,0,0,15,224,2,255,208,31,208,0,0,3,64,0,127,64,10,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,
  // 0x5931  失
  49,89,33,35,59,36,2,252,0,4,0,15,224,0,0,0,0,0,15,208,15,224,0,0,0,0,0,47,192,15,224,0,0,0,0,0,63,192,15,224,0,0,0,0,0,63,128,15,224,0,0,0,0,0,191,0,15,224,0,0,0,0,0,255,255,255,255,255,255,192,0,1,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,11,249,85,95,229,85,85,64,0,15,240,0,15,224,0,0,0,0,47,208,0,15,224,0,0,0,0,127,192,0,15,224,0,0,0,0,127,64,0,15,208,0,0,0,0,10,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,85,85,85,111,229,85,85,85,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,0,0,127,252,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,1,254,127,64,0,0,0,0,0,3,252,63,192,0,0,0,0,0,11,248,31,240,0,0,0,0,0,47,240,15,252,0,0,0,0,0,191,208,3,254,0,0,0,0,3,255,128,0,255,208,0,0,0,47,254,0,0,63,248,0,0,2,255,244,0,0,31,255,144,0,111,255,192,0,0,2,255,254,64,255,253,0,0,0,0,127,255,64,127,208,0,0,0,0,7,254,0,41,0,0,0,0,0,0,44,0,0,0,0,0,0,0,0,0,0,
  // 0x5934  头
  52,89,32,34,16,36,2,253,0,0,0,0,42,0,0,0,0,4,0,0,63,0,0,0,0,31,128,0,63,0,0,0,0,63,253,0,63,0,0,0,0,31,255,128,63,0,0,0,0,1,255,244,127,0,0,0,0,0,31,244,127,0,0,0,0,0,2,224,127,0,0,0,1,0,0,64,127,0,0,0,7,224,0,0,127,0,0,0,15,254,0,0,127,0,0,0,7,255,224,0,127,0,0,0,0,127,252,0,191,0,0,0,0,7,253,0,191,0,0,0,0,0,248,0,254,0,0,0,0,0,16,0,254,0,0,0,0,0,0,0,253,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,7,244,0,0,0,0,0,0,15,240,0,0,0,0,0,0,31,224,0,0,0,0,0,0,63,194,0,0,0,0,0,0,191,143,224,0,0,0,0,2,255,31,254,0,0,0,0,11,252,2,255,224,0,0,0,127,240,0,63,253,0,0,3,255,192,0,7,255,128,0,127,255,0,0,0,191,244,27,255,244,0,0,0,15,254,191,255,128,0,0,0,2,254,63,244,0,0,0,0,0,120,25,0,0,0,0,0,0,0,
  // 0x597d  好
  125,89,34,35,59,36,1,252,0,30,128,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,47,128,3,255,255,255,254,0,0,63,64,3,255,255,255,255,128,0,63,0,3,255,255,255,255,0,0,63,0,0,0,0,3,253,0,0,127,0,0,0,0,7,248,0,0,190,0,0,0,0,15,240,0,127,255,255,240,0,0,63,192,0,127,255,255,240,0,0,255,0,0,127,255,255,240,0,11,252,0,0,1,252,3,240,0,15,240,0,0,2,248,7,240,0,15,208,0,0,3,244,7,224,0,15,208,0,0,3,240,11,224,0,15,208,0,0,3,240,15,223,255,255,255,255,224,7,224,15,223,255,255,255,255,224,11,208,15,207,255,255,255,255,224,15,192,47,192,0,15,208,0,0,15,192,63,128,0,15,208,0,0,31,244,63,64,0,15,208,0,0,47,254,191,0,0,15,208,0,0,63,255,254,0,0,15,208,0,0,11,63,253,0,0,15,208,0,0,0,11,254,0,0,15,208,0,0,0,7,255,128,0,15,208,0,0,0,15,255,224,0,15,208,0,0,0,47,223,248,0,15,208,0,0,0,127,131,248,0,15,208,0,0,1,255,0,240,0,15,208,0,0,11,252,0,0,0,31,208,0,0,63,244,0,0,63,255,192,0,0,31,208,0,0,47,255,192,0,0,10,0,0,0,31,253,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x59cb  始
  203,89,34,34,50,36,1,253,0,30,128,0,0,57,0,0,0,0,31,192,0,0,127,64,0,0,0,47,128,0,0,191,0,0,0,0,63,64,0,0,254,0,0,0,0,63,0,0,0,253,0,0,0,0,63,0,0,2,252,0,0,0,0,127,0,0,3,248,1,128,0,0,190,0,0,3,244,15,208,0,127,255,255,240,7,240,11,240,0,127,255,255,240,11,224,3,248,0,127,255,255,240,15,192,1,253,0,1,248,3,240,31,192,0,191,0,2,244,7,241,127,235,255,255,128,3,240,7,235,255,255,255,255,192,3,240,11,235,255,255,255,255,224,7,240,15,215,250,165,64,11,240,11,224,15,192,0,0,0,3,128,15,208,31,192,0,0,0,0,0,15,192,47,128,0,0,0,0,0,31,192,63,64,127,255,255,255,0,47,244,63,0,127,255,255,255,0,63,255,191,0,127,255,255,255,0,63,255,254,0,127,0,0,127,0,6,47,252,0,127,0,0,127,0,0,7,255,0,127,0,0,127,0,0,11,255,192,127,0,0,127,0,0,15,255,240,127,0,0,127,0,0,63,203,252,127,0,0,127,0,0,255,66,244,127,0,0,127,0,3,254,0,160,127,255,255,255,0,31,252,0,0,127,255,255,255,0,47,224,0,0,127,255,255,255,0,15,128,0,0,127,0,0,127,0,5,0,0,0,126,0,0,42,0,
  // 0x5b50  子
  80,91,33,33,41,36,2,252,0,85,85,85,85,85,84,0,0,2,255,255,255,255,255,255,64,0,2,255,255,255,255,255,255,192,0,2,255,255,255,255,255,255,64,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,127,240,0,0,0,0,0,0,2,255,128,0,0,0,0,0,0,31,253,0,0,0,0,0,0,6,255,240,0,0,0,0,0,0,11,255,64,0,0,0,0,0,0,11,248,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,85,85,85,95,245,85,85,85,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,1,85,95,224,0,0,0,0,0,1,255,255,224,0,0,0,0,0,0,255,255,192,0,0,0,0,0,0,191,249,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5b58  存
  88,91,34,34,50,36,1,253,0,0,0,185,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,3,253,0,0,0,0,0,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,0,0,47,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,2,253,11,255,255,255,240,0,0,7,252,11,255,255,255,252,0,0,15,240,11,255,255,255,240,0,0,47,224,0,0,0,63,192,0,0,191,192,0,0,1,255,0,0,2,255,192,0,0,7,252,0,0,11,255,192,0,0,63,224,0,0,63,255,192,0,0,63,128,0,0,191,255,192,0,0,63,64,0,0,63,95,194,255,255,255,255,255,208,44,31,194,255,255,255,255,255,208,0,31,194,255,255,255,255,255,208,0,31,192,0,0,63,64,0,0,0,31,192,0,0,63,64,0,0,0,31,192,0,0,63,64,0,0,0,31,192,0,0,63,64,0,0,0,31,192,0,0,63,64,0,0,0,31,192,0,0,63,64,0,0,0,31,192,0,0,127,64,0,0,0,31,192,1,255,255,0,0,0,0,31,192,0,255,255,0,0,0,0,31,192,0,255,248,0,0,0,
  // 0x5b89  安
  137,91,32,35,24,36,2,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,64,0,0,0,0,1,252,63,64,0,16,0,0,1,252,63,64,0,191,0,0,1,252,63,64,0,254,0,0,1,252,63,64,2,252,0,0,1,252,0,0,3,248,0,0,0,0,0,0,11,240,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,64,0,31,224,0,0,0,254,0,0,47,192,0,0,3,252,0,0,63,192,0,0,7,248,0,0,127,64,0,0,15,240,0,0,255,0,0,0,31,244,0,2,253,0,0,0,63,255,144,7,252,0,0,0,127,255,254,95,240,0,0,0,191,47,255,255,208,0,0,0,5,1,191,255,208,0,0,0,0,0,31,255,253,0,0,0,0,1,255,255,255,208,0,0,0,127,255,130,255,253,0,5,191,255,248,0,47,255,208,47,255,255,128,0,2,255,240,15,255,228,0,0,0,47,192,7,164,0,0,0,0,7,0,0,0,0,0,0,0,0,0,
  // 0x5b8c  完
  140,91,32,34,16,36,2,253,0,0,0,11,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,64,0,0,0,0,1,252,63,64,0,0,0,0,1,252,63,64,0,0,0,0,1,252,63,64,0,0,0,0,1,252,63,75,255,255,255,255,209,252,0,11,255,255,255,255,208,0,0,11,255,255,255,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,63,128,15,224,0,0,0,0,63,64,11,224,0,0,0,0,127,0,11,224,0,0,0,0,191,0,11,224,0,0,0,0,255,0,11,224,0,0,0,1,253,0,11,224,0,16,0,3,252,0,11,224,0,62,0,15,248,0,11,224,0,63,0,127,240,0,11,224,0,63,6,255,192,0,11,240,0,127,191,255,0,0,11,255,255,254,255,248,0,0,3,255,255,253,127,128,0,0,1,255,255,244,36,0,0,0,0,0,0,0,
  // 0x5b9a  定
  154,91,33,35,59,36,1,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,208,0,0,0,0,0,127,0,15,192,0,0,0,0,0,127,0,15,192,0,0,0,0,0,127,0,15,192,0,0,0,0,0,127,0,15,195,255,255,255,255,252,127,0,5,67,255,255,255,255,252,21,0,0,3,255,255,255,255,252,0,0,0,0,0,3,252,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,7,224,3,248,0,0,0,0,0,7,240,3,248,0,0,0,0,0,11,240,3,248,0,0,0,0,0,15,224,3,255,255,255,192,0,0,15,208,3,255,255,255,192,0,0,31,224,3,255,255,255,192,0,0,47,240,3,248,0,0,0,0,0,63,244,3,248,0,0,0,0,0,127,252,3,248,0,0,0,0,0,255,255,3,248,0,0,0,0,1,253,63,211,248,0,0,0,0,3,252,31,251,248,0,0,0,0,11,244,7,255,253,0,0,0,0,47,240,1,255,255,255,255,255,192,127,192,0,47,255,255,255,255,128,47,64,0,1,191,255,255,255,64,9,0,0,0,0,5,85,85,0,0,0,0,0,0,0,0,0,0,
  // 0x5ba2  客
  162,91,34,34,50,36,1,253,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,192,0,80,0,0,0,127,0,15,192,0,255,0,0,0,127,0,15,192,3,253,0,0,0,127,0,15,192,15,254,170,170,128,127,0,0,0,63,255,255,255,244,0,0,0,0,255,255,255,255,240,0,0,0,7,255,64,0,47,208,0,0,0,127,255,208,0,191,128,0,0,3,255,223,248,2,255,0,0,0,3,254,3,255,31,248,0,0,0,0,244,0,191,255,224,0,0,0,0,0,0,47,255,128,0,0,0,0,0,0,191,255,244,0,0,0,0,0,27,255,255,255,208,0,0,0,2,255,254,11,255,255,164,0,1,191,255,224,0,191,255,255,208,127,255,253,0,0,6,255,255,128,63,255,255,255,255,255,255,255,0,31,147,255,255,255,255,252,5,0,0,3,255,255,255,255,252,0,0,0,3,244,0,0,1,252,0,0,0,3,244,0,0,1,252,0,0,0,3,244,0,0,1,252,0,0,0,3,244,0,0,1,252,0,0,0,3,255,255,255,255,252,0,0,0,3,255,255,255,255,252,0,0,0,3,255,255,255,255,252,0,0,0,3,244,0,0,1,252,0,0,
  // 0x5bab  宫
  171,91,30,35,24,36,3,252,0,0,0,110,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,127,128,0,0,0,0,0,0,63,192,0,0,0,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,254,85,85,85,85,85,91,240,253,0,0,0,0,0,7,240,253,0,0,0,0,0,7,240,253,42,170,170,170,170,135,240,253,63,255,255,255,255,199,240,0,63,255,255,255,255,192,0,0,63,0,0,0,15,192,0,0,63,0,0,0,15,192,0,0,63,0,0,0,15,192,0,0,63,170,170,170,175,192,0,0,63,255,255,255,255,192,0,0,63,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,255,255,255,255,255,254,0,7,255,255,255,255,255,254,0,7,255,255,255,255,255,254,0,7,240,0,0,0,0,190,0,7,240,0,0,0,0,190,0,7,240,0,0,0,0,190,0,7,240,0,0,0,0,190,0,7,240,0,0,0,0,190,0,7,255,255,255,255,255,254,0,7,255,255,255,255,255,254,0,7,255,255,255,255,255,254,0,7,240,0,0,0,0,190,0,0,0,0,0,0,0,0,0,
  // 0x5bf9  对
  249,91,33,34,50,36,2,253,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,127,255,255,248,0,0,63,64,0,127,255,255,248,0,0,63,64,0,127,255,255,244,0,0,63,64,0,0,0,3,244,0,0,63,128,0,0,0,3,242,255,255,255,255,64,0,0,7,242,255,255,255,255,64,0,0,11,242,255,255,255,255,64,1,0,11,224,0,0,63,64,0,15,128,15,208,0,0,63,64,0,47,224,31,192,0,0,63,64,0,15,248,47,192,4,0,63,64,0,3,254,63,128,188,0,63,64,0,0,255,191,64,254,0,63,64,0,0,63,255,0,127,64,63,64,0,0,15,255,0,63,192,63,64,0,0,3,254,0,15,208,63,64,0,0,2,255,64,15,224,63,64,0,0,3,255,192,7,240,63,64,0,0,15,255,240,3,240,63,64,0,0,31,239,248,2,64,63,64,0,0,63,195,252,0,0,63,64,0,0,191,129,255,0,0,63,64,0,1,255,0,190,0,0,63,64,0,7,252,0,52,0,0,63,64,0,31,244,0,0,0,0,63,64,0,127,224,0,0,0,165,191,64,0,255,128,0,0,0,255,255,0,0,62,0,0,0,0,255,254,0,0,20,0,0,0,0,191,228,0,0,
  // 0x5c06  将
  6,92,34,34,50,36,1,253,0,3,240,0,0,0,6,224,0,0,3,240,0,0,22,255,248,0,0,3,240,5,175,255,255,252,0,0,3,242,255,255,255,254,64,0,4,3,241,255,255,233,0,0,0,126,3,240,233,64,16,0,20,0,63,67,240,0,2,244,0,63,64,47,195,240,109,2,248,0,191,64,15,211,240,127,0,252,0,254,0,11,243,240,63,64,253,3,252,0,3,247,240,47,128,190,7,244,0,3,255,240,15,192,126,15,224,0,1,231,240,15,208,100,63,192,0,0,3,240,11,128,0,191,0,0,0,3,240,0,0,0,127,64,0,0,3,240,0,0,0,47,128,0,0,3,240,0,0,0,47,128,0,0,3,242,255,255,255,255,255,224,0,3,242,255,255,255,255,255,224,0,11,242,255,255,255,255,255,224,0,127,240,0,0,0,47,128,0,2,255,240,0,128,0,47,128,0,31,255,240,11,240,0,47,128,0,191,251,240,7,248,0,47,128,0,191,195,240,2,253,0,47,128,0,63,3,240,0,255,0,47,128,0,40,3,240,0,127,128,47,128,0,0,3,240,0,47,192,47,128,0,0,3,240,0,15,64,47,128,0,0,3,240,0,4,0,47,128,0,0,3,240,0,0,0,63,128,0,0,3,240,0,0,191,255,128,0,0,3,240,0,0,127,255,0,0,0,3,240,0,0,63,248,0,0,
  // 0x5c0f  小
  15,92,34,35,59,36,1,252,0,0,0,1,84,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,14,64,2,252,0,46,0,0,0,31,224,2,252,0,255,0,0,0,47,208,2,252,0,127,128,0,0,63,192,2,252,0,63,192,0,0,63,192,2,252,0,31,224,0,0,127,128,2,252,0,15,240,0,0,191,0,2,252,0,7,248,0,0,255,0,2,252,0,3,252,0,1,254,0,2,252,0,2,254,0,2,253,0,2,252,0,0,255,0,3,252,0,2,252,0,0,255,64,11,244,0,2,252,0,0,127,128,15,240,0,2,252,0,0,63,192,47,224,0,2,252,0,0,47,208,127,192,0,2,252,0,0,31,224,127,64,0,2,252,0,0,15,240,6,0,0,2,252,0,0,15,208,0,0,0,2,252,0,0,4,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,0,21,87,252,0,0,0,0,0,0,63,255,248,0,0,0,0,0,0,47,255,240,0,0,0,0,0,0,31,254,128,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5c31  就
  49,92,34,35,59,36,1,252,0,0,252,0,0,7,224,0,0,0,0,252,0,0,7,224,80,0,0,0,252,0,0,7,227,240,0,0,0,252,0,0,7,226,252,0,0,0,252,0,0,7,224,254,0,63,255,255,255,240,7,224,127,64,63,255,255,255,240,7,224,47,192,63,255,255,255,240,7,224,15,128,0,0,0,0,0,7,224,4,0,0,0,0,0,0,11,240,0,0,3,255,255,255,79,255,255,255,208,7,255,255,255,79,255,255,255,208,7,255,255,255,79,255,255,255,208,7,240,0,47,64,11,224,0,0,7,240,0,47,64,15,228,0,0,7,240,0,47,64,15,254,0,0,7,240,0,47,64,15,254,0,0,7,255,255,255,64,15,254,0,0,7,255,255,255,64,31,254,0,0,7,255,255,255,64,47,254,0,0,0,0,253,0,0,63,254,0,0,0,0,253,4,0,63,190,0,0,3,240,253,63,0,127,126,0,0,7,240,253,63,0,191,126,0,0,11,224,253,47,128,254,126,0,0,15,208,253,15,194,252,126,1,0,15,192,253,15,211,248,126,2,208,47,128,253,7,235,244,126,2,240,63,64,253,2,95,240,126,2,240,191,0,253,0,63,192,126,3,224,44,0,252,0,255,128,127,71,224,0,127,252,3,255,0,63,255,208,0,63,252,2,252,0,63,255,192,0,63,224,0,112,0,15,255,64,0,0,0,0,0,0,0,0,0,
  // 0x5c4f  屏
  79,92,33,33,41,36,1,252,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,253,0,0,0,0,1,252,0,0,253,0,0,0,0,1,252,0,0,253,0,0,0,0,1,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,255,255,255,255,255,255,252,0,0,253,0,188,0,0,127,64,0,0,253,0,254,0,0,255,0,0,0,253,0,63,64,1,252,0,0,0,253,0,47,128,3,248,0,0,0,253,127,255,255,255,255,255,0,0,253,191,255,255,255,255,255,0,0,252,191,255,255,255,255,255,0,0,252,0,31,192,3,240,0,0,1,252,0,31,192,3,240,0,0,1,252,0,31,192,3,240,0,0,1,252,0,31,192,3,240,0,0,2,248,0,31,192,3,240,0,0,3,250,255,255,255,255,255,255,192,3,246,255,255,255,255,255,255,192,3,242,255,255,255,255,255,255,192,7,240,0,63,64,3,240,0,0,11,224,0,191,0,3,240,0,0,15,224,1,254,0,3,240,0,0,31,192,7,252,0,3,240,0,0,63,192,47,244,0,3,240,0,0,127,65,255,208,0,3,240,0,0,127,0,255,64,0,3,240,0,0,9,0,56,0,0,3,240,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5de5  工
  229,93,32,28,224,36,2,255,15,255,255,255,255,255,255,244,15,255,255,255,255,255,255,244,15,255,255,255,255,255,255,244,5,85,85,95,245,85,85,80,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,85,85,85,85,85,
  // 0x5dee  差
  238,93,33,34,50,36,1,253,0,0,20,0,0,3,144,0,0,0,1,252,0,0,7,248,0,0,0,0,255,0,0,15,240,0,0,0,0,127,64,0,31,208,0,0,0,0,63,192,0,63,192,0,0,7,255,255,255,255,255,255,253,0,7,255,255,255,255,255,255,253,0,7,255,255,255,255,255,255,253,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,127,255,255,255,255,255,224,0,0,127,255,255,255,255,255,224,0,0,127,255,255,255,255,255,224,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,253,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,3,254,255,255,255,255,224,0,0,3,250,255,255,255,255,240,0,0,11,242,255,255,255,255,240,0,0,15,240,0,15,224,0,0,0,0,47,208,0,15,224,0,0,0,0,63,192,0,15,224,0,0,0,0,255,64,0,15,224,0,0,0,2,254,0,0,15,224,0,0,0,7,252,0,0,15,224,0,0,0,47,244,255,255,255,255,255,255,0,127,224,255,255,255,255,255,255,0,31,128,255,255,255,255,255,255,0,6,0,0,0,0,0,0,0,0,
  // 0x5df2  已
  242,93,31,31,248,36,3,254,191,255,255,255,255,255,248,0,191,255,255,255,255,255,248,0,191,255,255,255,255,255,248,0,21,85,85,85,85,87,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,3,248,0,15,229,85,85,85,87,248,0,15,255,255,255,255,255,248,0,15,255,255,255,255,255,248,0,15,255,255,255,255,255,248,0,15,224,0,0,0,3,248,0,15,224,0,0,0,2,248,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,208,15,224,0,0,0,0,1,252,15,224,0,0,0,0,1,252,15,224,0,0,0,0,2,252,15,224,0,0,0,0,3,252,15,240,0,0,0,0,7,248,11,254,85,85,85,85,111,240,3,255,255,255,255,255,255,224,1,255,255,255,255,255,255,192,0,43,255,255,255,255,249,0,
  // 0x5e73  平
  115,94,32,32,0,36,2,253,5,85,85,85,85,85,85,80,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,0,0,0,15,224,0,0,0,0,4,0,15,224,0,80,0,0,126,0,15,224,0,255,0,0,127,0,15,224,0,254,0,0,63,128,15,224,2,252,0,0,47,192,15,224,3,248,0,0,15,208,15,224,7,244,0,0,11,240,15,224,15,224,0,0,7,240,15,224,31,192,0,0,3,224,15,224,47,128,0,0,1,0,15,224,1,0,0,0,0,0,15,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,95,245,85,85,85,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,
  // 0x5e76  并
  118,94,32,35,24,36,2,252,0,1,192,0,0,3,144,0,0,15,224,0,0,11,248,0,0,11,244,0,0,15,240,0,0,3,252,0,0,47,208,0,0,1,253,0,0,63,192,0,0,0,255,0,0,191,0,0,0,0,127,0,0,253,0,0,0,0,56,0,0,44,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,0,0,253,0,0,127,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,253,0,0,191,0,0,0,2,252,0,0,127,0,0,0,3,248,0,0,127,0,0,0,3,248,0,0,127,0,0,0,11,240,0,0,127,0,0,0,15,224,0,0,127,0,0,0,63,208,0,0,127,0,0,0,191,128,0,0,127,0,0,3,255,0,0,0,127,0,0,31,252,0,0,0,127,0,0,191,244,0,0,0,127,0,0,63,192,0,0,0,127,0,0,30,0,0,0,0,127,0,0,0,0,0,0,0,0,0,0,
  // 0x5e8a  床
  138,94,34,34,50,36,1,253,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,255,0,0,0,0,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,248,0,0,0,0,0,0,0,2,248,0,0,11,240,0,0,0,2,248,0,0,11,240,0,0,0,2,248,0,0,11,240,0,0,0,2,248,0,0,11,240,0,0,0,2,248,0,0,11,240,0,0,0,2,248,191,255,255,255,255,255,192,2,248,191,255,255,255,255,255,192,2,248,191,255,255,255,255,255,192,2,248,0,0,127,253,0,0,0,3,248,0,0,191,255,0,0,0,3,244,0,1,255,255,128,0,0,3,244,0,3,255,255,208,0,0,3,244,0,11,251,251,240,0,0,3,240,0,47,219,243,252,0,0,7,240,0,127,203,241,255,0,0,7,240,1,255,11,240,191,192,0,11,224,7,253,11,240,47,240,0,15,208,31,244,11,240,15,253,0,15,208,191,224,11,240,3,255,128,31,195,255,128,11,240,0,255,224,63,194,253,0,11,240,0,47,128,63,64,180,0,11,240,0,7,0,191,0,0,0,11,240,0,0,0,62,0,0,0,11,240,0,0,0,8,0,0,0,11,224,0,0,0,
  // 0x5e94  应
  148,94,34,35,59,36,1,252,0,0,0,0,189,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,63,192,0,0,0,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,248,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,2,248,0,0,24,0,0,208,0,2,248,0,0,253,0,1,253,0,2,248,26,0,190,0,2,252,0,2,248,127,0,127,0,3,252,0,2,248,63,64,63,0,3,244,0,2,248,47,128,63,128,7,240,0,2,248,31,192,47,192,15,240,0,2,248,15,208,31,192,15,208,0,3,248,11,240,15,208,47,192,0,3,248,7,240,15,224,63,128,0,3,244,3,244,11,224,127,0,0,3,244,2,248,7,240,191,0,0,3,244,1,252,7,224,253,0,0,3,240,0,253,0,2,252,0,0,7,240,0,248,0,3,244,0,0,11,240,0,64,0,11,240,0,0,15,224,0,0,0,15,208,0,0,15,208,0,0,0,47,192,0,0,15,208,0,0,0,63,64,0,0,47,199,255,255,255,255,255,255,208,63,135,255,255,255,255,255,255,208,127,71,255,255,255,255,255,255,208,63,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5e9f  废
  159,94,33,35,59,36,1,252,0,0,0,0,109,0,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,127,192,0,0,0,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,192,3,255,255,255,255,255,255,255,192,3,248,0,0,4,0,0,0,0,3,248,3,160,15,192,20,0,0,3,248,7,240,31,192,253,0,0,3,248,11,240,47,192,191,64,0,3,248,15,224,63,128,47,192,0,3,248,31,192,63,64,15,240,0,3,248,63,192,127,0,3,128,0,3,248,191,255,255,255,255,255,64,3,244,127,255,255,255,255,255,64,3,244,63,255,255,255,255,255,64,3,244,16,2,252,0,0,0,0,3,244,0,3,244,0,0,0,0,3,244,0,11,240,0,0,0,0,3,244,0,15,255,255,255,128,0,3,240,0,47,255,255,255,224,0,7,240,0,127,255,255,255,192,0,7,240,0,255,208,0,127,64,0,11,240,3,255,244,1,255,0,0,11,224,15,251,253,7,252,0,0,15,208,63,224,191,159,240,0,0,15,209,255,128,47,255,192,0,0,31,203,255,0,15,255,128,0,0,47,207,248,0,191,255,248,0,0,63,131,208,27,255,239,255,228,0,127,1,3,255,253,2,255,255,192,127,0,3,255,208,0,31,255,0,9,0,0,248,0,0,0,109,0,0,0,0,0,0,0,0,0,0,
  // 0x5ea6  度
  166,94,33,35,59,36,1,252,0,0,0,0,190,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,191,0,0,0,0,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,248,0,0,0,0,0,0,0,2,248,0,63,0,0,252,0,0,2,248,0,63,0,0,252,0,0,2,249,170,255,234,171,255,170,64,2,249,255,255,255,255,255,255,128,2,249,255,255,255,255,255,255,128,2,248,0,63,0,0,252,0,0,2,248,0,63,0,0,252,0,0,2,248,0,63,0,0,252,0,0,2,244,0,63,170,170,252,0,0,2,244,0,63,255,255,252,0,0,3,244,0,63,255,255,252,0,0,3,244,0,0,0,0,0,0,0,3,240,0,0,0,0,0,0,0,3,240,255,255,255,255,255,224,0,3,240,255,255,255,255,255,240,0,3,240,170,191,170,170,191,224,0,7,240,0,255,0,0,127,192,0,11,224,0,63,192,1,255,0,0,15,208,0,31,244,11,252,0,0,15,192,0,7,255,127,240,0,0,31,192,0,0,255,255,128,0,0,63,128,0,6,255,255,144,0,0,63,64,22,255,255,255,255,148,0,191,3,255,255,248,31,255,255,192,126,2,255,254,0,0,191,255,128,8,1,249,0,0,0,1,111,0,0,0,0,0,0,0,0,0,0,
  // 0x5f00  开
  0,95,32,33,8,36,2,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,0,0,255,0,0,63,128,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,190,0,0,63,64,0,0,0,255,0,0,127,128,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,253,0,0,63,64,0,0,1,252,0,0,63,64,0,0,1,252,0,0,63,64,0,0,2,252,0,0,63,64,0,0,3,248,0,0,63,64,0,0,11,244,0,0,63,64,0,0,15,240,0,0,63,64,0,0,47,224,0,0,63,64,0,0,127,192,0,0,63,64,0,0,255,64,0,0,63,64,0,7,254,0,0,0,63,64,0,31,252,0,0,0,63,64,0,191,240,0,0,0,63,64,0,63,192,0,0,0,63,64,0,14,0,0,0,0,63,64,0,0,0,0,0,0,0,0,0,
  // 0x5f03  弃
  3,95,33,35,59,36,1,252,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,3,252,0,0,0,0,0,0,0,7,248,0,11,64,0,0,0,0,15,240,0,63,240,0,0,0,0,47,208,0,11,253,0,0,0,0,63,128,0,1,255,128,0,15,255,255,239,255,255,255,224,0,15,255,255,255,255,255,255,252,0,15,255,255,255,255,255,255,255,0,1,85,85,64,0,0,0,191,64,0,0,63,64,0,31,192,44,0,0,0,63,64,0,31,192,0,0,0,0,63,64,0,31,192,0,0,0,0,63,64,0,31,192,0,0,0,0,63,64,0,31,192,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,191,0,0,31,192,0,0,0,0,254,0,0,31,192,0,0,0,2,253,0,0,31,192,0,0,0,7,252,0,0,31,192,0,0,0,31,244,0,0,31,192,0,0,0,191,208,0,0,31,192,0,0,7,255,128,0,0,31,192,0,0,127,253,0,0,0,31,192,0,0,47,224,0,0,0,31,192,0,0,14,0,0,0,0,31,192,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5f0f  式
  15,95,33,34,50,36,2,253,0,0,0,0,15,208,32,0,0,0,0,0,0,15,224,189,0,0,0,0,0,0,15,224,255,128,0,0,0,0,0,15,224,63,224,0,0,0,0,0,15,224,11,244,0,0,0,0,0,15,224,2,224,0,21,85,85,85,95,229,85,149,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,244,0,0,0,47,255,255,255,195,244,0,0,0,47,255,255,255,195,248,0,0,0,47,255,255,255,195,248,0,0,0,0,2,252,0,2,252,0,0,0,0,2,248,0,2,252,0,0,0,0,2,248,0,1,252,0,0,0,0,2,248,0,0,253,0,0,0,0,2,248,0,0,254,0,0,0,0,2,248,0,0,255,0,0,0,0,2,248,0,0,127,0,8,0,0,2,248,0,0,63,128,31,64,0,2,248,5,176,63,192,31,128,0,2,254,255,240,31,208,47,128,0,91,255,255,240,15,240,47,64,111,255,255,254,80,11,248,63,0,191,255,254,64,0,3,255,191,0,63,254,64,0,0,1,255,254,0,57,0,0,0,0,0,127,252,0,0,0,0,0,0,0,11,224,0,
  // 0x5f15  引
  21,95,29,35,24,36,2,252,0,0,0,0,0,0,5,0,0,0,0,0,0,0,63,128,31,255,255,255,0,0,63,128,31,255,255,255,0,0,63,128,31,255,255,255,0,0,63,128,0,0,0,63,0,0,63,128,0,0,0,63,0,0,63,128,0,0,0,63,0,0,63,128,0,0,0,63,0,0,63,128,0,0,0,63,0,0,63,128,7,255,255,255,0,0,63,128,11,255,255,255,0,0,63,128,11,255,255,255,0,0,63,128,15,208,0,0,0,0,63,128,15,208,0,0,0,0,63,128,15,192,0,0,0,0,63,128,31,192,0,0,0,0,63,128,47,192,0,0,0,0,63,128,47,255,255,255,64,0,63,128,63,255,255,255,64,0,63,128,63,255,255,255,0,0,63,128,127,0,0,127,0,0,63,128,26,0,0,127,0,0,63,128,0,0,0,127,0,0,63,128,0,0,0,191,0,0,63,128,0,0,0,190,0,0,63,128,0,0,0,254,0,0,63,128,0,0,0,253,0,0,63,128,0,0,1,253,0,0,63,128,0,0,2,252,0,0,63,128,0,149,91,252,0,0,63,128,0,191,255,244,0,0,63,128,0,127,255,240,0,0,63,128,0,63,254,64,0,0,63,128,0,0,0,0,0,0,0,0,
  // 0x5f39  弹
  57,95,33,35,59,36,2,252,0,0,0,0,64,0,10,64,0,0,0,0,7,224,0,15,224,0,255,255,244,7,244,0,47,192,0,255,255,244,2,252,0,63,128,0,255,255,244,0,253,0,127,0,0,0,2,244,0,191,0,253,0,0,0,2,244,0,61,1,252,0,0,0,2,244,0,0,3,244,0,0,0,2,244,63,255,255,255,252,0,0,3,244,63,255,255,255,252,0,63,255,244,63,170,255,170,252,0,127,255,244,63,0,254,0,252,0,127,255,244,63,0,254,0,252,0,126,0,0,63,170,255,170,252,0,126,0,0,63,255,255,255,252,0,125,0,0,63,255,255,255,252,0,125,0,0,63,0,254,0,252,0,125,0,0,63,0,254,0,252,0,127,255,244,63,0,254,0,252,0,191,255,244,63,255,255,255,252,0,191,255,244,63,255,255,255,252,0,0,3,244,42,170,255,170,168,0,0,3,240,0,0,254,0,0,0,0,3,240,0,0,254,0,0,0,0,3,247,255,255,255,255,255,64,0,3,243,255,255,255,255,255,64,0,3,243,255,255,255,255,255,64,0,7,240,0,0,254,0,0,0,0,7,224,0,0,254,0,0,0,0,11,224,0,0,254,0,0,0,0,31,208,0,0,254,0,0,0,63,255,192,0,0,254,0,0,0,47,255,128,0,0,254,0,0,0,31,254,0,0,0,253,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5f52  归
  82,95,30,35,24,36,3,252,0,2,244,0,0,0,0,0,0,3,244,0,0,0,0,0,0,3,244,0,0,0,0,0,0,3,244,63,255,255,255,240,168,3,244,63,255,255,255,240,253,3,244,63,255,255,255,240,253,3,244,0,0,0,11,240,253,3,244,0,0,0,11,240,253,3,244,0,0,0,11,240,253,3,244,0,0,0,11,240,253,3,244,0,0,0,11,240,253,3,244,0,0,0,11,240,253,3,244,0,0,0,11,240,253,3,244,0,0,0,11,240,253,3,244,0,0,0,11,240,253,3,244,15,255,255,255,240,253,3,244,15,255,255,255,240,253,3,244,15,255,255,255,240,253,3,244,5,85,85,91,240,253,3,244,0,0,0,11,240,253,3,240,0,0,0,11,240,253,7,240,0,0,0,11,240,169,11,240,0,0,0,11,240,0,15,240,0,0,0,11,240,0,15,224,0,0,0,11,240,0,31,208,0,0,0,11,240,0,63,192,0,0,0,11,240,0,127,128,21,85,85,91,240,0,255,0,191,255,255,255,240,3,254,0,191,255,255,255,240,11,252,0,191,255,255,255,240,47,240,0,0,0,0,11,240,31,208,0,0,0,0,11,240,3,64,0,0,0,0,6,160,0,0,0,0,0,0,0,0,
  // 0x5f84  径
  132,95,34,34,50,36,1,253,0,0,144,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,11,244,63,255,255,255,253,0,0,47,224,63,255,255,255,253,0,0,191,192,63,255,255,255,252,0,3,255,0,2,244,0,3,248,0,15,252,0,2,252,0,15,240,0,127,240,16,0,254,0,47,208,0,63,128,126,0,127,128,127,128,0,45,0,255,0,47,225,255,0,0,0,2,252,0,11,251,252,0,0,0,11,244,0,3,255,240,0,0,0,31,224,0,1,255,224,0,0,0,127,192,0,31,255,254,0,0,1,255,192,1,255,251,255,224,0,7,255,192,111,255,64,191,255,144,47,255,195,255,248,0,11,255,224,255,255,193,255,64,21,0,191,192,191,95,192,160,0,63,0,2,0,61,31,192,0,0,63,0,0,0,20,31,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,63,255,255,255,254,0,0,31,192,63,255,255,255,254,0,0,31,192,63,255,255,255,254,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,195,255,255,255,255,255,208,0,31,195,255,255,255,255,255,208,0,31,195,255,255,255,255,255,208,0,31,192,0,0,0,0,0,0,
  // 0x5f85  待
  133,95,34,34,50,36,1,253,0,1,128,0,0,106,0,0,0,0,3,248,0,0,127,0,0,0,0,11,244,0,0,127,0,0,0,0,47,224,0,0,127,0,0,0,0,127,192,0,0,191,0,0,0,2,255,0,63,255,255,255,255,0,11,252,0,63,255,255,255,255,0,63,240,0,63,255,255,255,255,0,63,192,0,0,0,127,0,0,0,30,0,252,0,0,127,0,0,0,4,2,252,0,0,127,0,0,0,0,7,244,0,0,191,0,0,0,0,15,243,255,255,255,255,255,224,0,63,195,255,255,255,255,255,224,0,255,131,255,255,255,255,255,224,3,255,128,0,0,0,47,192,0,31,255,128,0,0,0,47,192,0,191,255,128,0,0,0,47,192,0,127,95,131,255,255,255,255,255,208,61,31,131,255,255,255,255,255,208,16,31,131,255,255,255,255,255,208,0,31,128,0,0,0,47,192,0,0,31,128,2,192,0,47,192,0,0,31,128,15,224,0,47,192,0,0,31,128,11,244,0,47,192,0,0,31,128,3,252,0,47,192,0,0,31,128,1,254,0,47,192,0,0,31,128,0,191,0,47,192,0,0,31,128,0,63,64,47,192,0,0,31,128,0,44,0,47,192,0,0,31,128,0,0,0,47,128,0,0,31,128,0,0,127,255,128,0,0,31,128,0,0,63,255,64,0,0,31,128,0,0,63,248,0,0,
  // 0x5faa  循
  170,95,34,34,50,36,1,253,0,3,144,0,0,0,0,80,0,0,11,240,0,0,0,111,248,0,0,31,208,80,22,255,255,254,0,0,127,128,255,255,255,255,144,0,1,255,0,255,255,255,240,0,0,7,252,0,254,64,7,240,0,0,47,240,0,253,0,7,240,0,0,191,128,64,253,0,7,240,0,0,62,1,252,255,255,255,255,255,208,4,3,248,255,255,255,255,255,208,0,11,240,255,255,255,255,255,208,0,31,208,253,0,7,224,0,0,0,63,192,253,0,11,224,0,0,0,255,64,253,0,11,208,0,0,2,255,64,253,0,11,208,0,0,11,255,64,253,63,255,255,255,0,47,255,64,252,63,255,255,255,0,255,255,64,252,63,170,170,255,0,191,63,64,252,63,0,0,63,0,60,63,64,252,63,0,0,63,0,0,63,64,252,63,255,255,255,0,0,63,64,252,63,255,255,255,0,0,63,65,252,63,85,85,127,0,0,63,65,248,63,0,0,63,0,0,63,66,248,63,0,0,63,0,0,63,67,244,63,255,255,255,0,0,63,67,240,63,255,255,255,0,0,63,71,240,63,85,85,127,0,0,63,75,224,63,0,0,63,0,0,63,79,208,63,0,0,63,0,0,63,95,192,63,255,255,255,0,0,63,111,128,63,255,255,255,0,0,63,71,0,63,85,85,127,0,0,47,65,0,63,0,0,42,0,
  // 0x5fae  微
  174,95,34,34,50,36,1,253,0,29,0,15,64,0,184,0,0,0,63,192,15,64,0,252,0,0,0,191,0,15,64,0,252,0,0,1,254,31,15,67,193,252,0,0,7,248,31,15,67,193,248,0,0,15,240,31,15,67,194,244,0,0,63,192,31,15,67,195,244,0,0,191,0,31,15,67,195,255,255,208,61,15,239,15,67,199,255,255,224,16,31,239,15,67,203,255,255,224,0,63,159,255,255,223,208,63,0,0,127,31,255,255,239,208,63,0,0,254,31,255,255,255,224,62,0,3,253,0,0,0,127,224,126,0,11,253,0,0,0,255,240,125,0,31,253,0,0,0,253,240,188,0,63,253,63,255,255,244,240,252,0,255,253,63,255,255,224,244,252,0,189,253,63,255,255,208,249,248,0,56,253,2,240,125,0,190,244,0,16,253,2,240,125,0,127,240,0,0,253,3,240,125,0,63,240,0,0,253,3,240,125,0,63,224,0,0,253,3,240,125,0,47,192,0,0,253,3,224,125,0,31,192,0,0,253,7,224,126,184,63,208,0,0,253,11,208,191,248,191,240,0,0,253,15,194,255,245,255,244,0,0,253,31,129,254,3,249,252,0,0,253,63,64,144,15,240,255,0,0,253,255,0,0,127,192,63,208,0,253,60,0,0,255,0,31,240,0,253,20,0,0,188,0,7,192,0,189,0,0,0,32,0,1,64,
  // 0x5fc3  心
  195,95,34,34,50,36,1,253,0,0,0,144,0,0,0,0,0,0,0,3,254,0,0,0,0,0,0,0,11,255,224,0,0,0,0,0,0,1,255,254,0,0,0,0,0,0,0,11,255,224,0,0,0,0,0,0,0,191,253,0,0,0,0,0,0,0,31,255,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,31,0,0,1,228,15,208,0,0,127,128,0,1,252,15,208,0,0,47,208,0,2,252,15,208,0,0,15,240,0,2,248,15,208,0,0,7,248,0,3,248,15,208,0,0,3,252,0,3,244,15,208,0,0,1,254,0,7,240,15,208,0,0,0,255,0,11,240,15,208,0,0,0,127,128,15,224,15,208,0,0,0,63,192,31,208,15,208,0,0,0,47,208,47,192,15,208,0,0,208,15,224,127,128,15,208,0,0,252,15,240,255,0,15,208,0,0,252,11,208,126,0,15,208,0,1,252,1,0,4,0,15,208,0,1,252,0,0,0,0,15,208,0,2,248,0,0,0,0,15,240,0,7,244,0,0,0,0,15,255,255,255,240,0,0,0,0,7,255,255,255,224,0,0,0,0,1,191,255,255,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x5ffd  忽
  253,95,34,34,50,36,1,253,0,0,45,0,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,3,255,255,255,255,255,248,0,0,11,255,255,255,255,255,244,0,0,47,255,255,255,255,255,244,0,0,191,192,127,64,254,3,244,0,2,255,0,254,1,252,3,244,0,11,252,2,252,3,248,3,240,0,63,240,7,244,7,240,3,240,0,31,192,31,224,15,224,7,240,0,3,0,127,192,47,192,7,240,0,0,1,255,0,127,64,7,240,0,0,11,252,0,255,0,11,240,0,0,63,240,3,252,0,15,224,0,2,255,192,15,244,0,15,208,0,3,254,0,63,208,0,47,192,0,0,244,2,255,64,127,255,192,0,0,0,15,253,0,63,255,64,0,0,0,11,244,0,47,249,0,0,0,0,2,199,208,0,0,0,0,0,0,0,15,252,0,0,0,0,0,16,5,71,255,64,14,0,0,0,63,15,192,191,208,127,128,0,0,127,15,192,31,192,63,224,0,0,254,15,192,7,0,15,244,0,1,252,15,192,0,3,67,252,0,3,252,15,192,0,3,241,255,0,11,244,15,192,0,3,240,191,128,47,224,15,208,0,11,240,63,192,127,192,15,255,255,255,224,31,208,15,0,7,255,255,255,192,14,0,0,0,1,255,255,254,0,0,0,
  // 0x6027  性
  39,96,33,35,59,36,1,252,0,63,64,0,0,47,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,3,244,63,64,0,0,0,63,64,3,240,63,64,0,0,0,63,64,7,240,63,64,0,0,0,63,64,11,240,63,64,0,0,0,63,88,11,224,63,64,0,0,10,63,252,15,224,63,128,0,0,31,63,190,31,255,255,255,255,0,47,63,127,47,255,255,255,255,0,47,63,95,127,255,255,255,255,0,63,63,79,255,64,63,64,0,0,62,63,79,255,0,63,64,0,0,61,63,64,254,0,63,64,0,0,125,63,66,252,0,63,64,0,0,188,63,64,120,0,63,64,0,0,188,63,64,0,0,63,64,0,0,0,63,64,0,0,63,128,0,0,0,63,64,15,255,255,255,253,0,0,63,64,15,255,255,255,253,0,0,63,64,15,255,255,255,253,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,128,0,0,0,63,67,255,255,255,255,255,192,0,63,67,255,255,255,255,255,192,0,63,67,255,255,255,255,255,192,0,63,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x603b  总
  59,96,33,34,50,36,2,253,0,0,96,0,0,13,0,0,0,0,2,252,0,0,47,208,0,0,0,0,254,0,0,63,192,0,0,0,0,191,64,0,191,64,0,0,0,0,63,192,0,254,0,0,0,0,0,31,208,2,252,0,0,0,0,0,15,128,3,248,0,0,0,0,127,255,255,255,255,254,0,0,0,127,255,255,255,255,254,0,0,0,127,255,255,255,255,254,0,0,0,127,0,0,0,0,254,0,0,0,127,0,0,0,0,254,0,0,0,127,0,0,0,0,254,0,0,0,127,0,0,0,0,254,0,0,0,127,0,0,0,0,254,0,0,0,127,0,0,0,0,254,0,0,0,127,255,255,255,255,254,0,0,0,127,255,255,255,255,254,0,0,0,127,255,255,255,255,254,0,0,0,0,0,7,0,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,47,240,0,0,0,0,1,0,169,11,252,0,7,0,0,11,240,254,1,255,0,47,128,0,15,224,254,0,127,192,31,208,0,15,208,254,0,47,192,11,240,0,31,192,254,0,11,0,3,252,0,47,192,254,0,0,1,1,253,0,63,64,254,0,0,3,224,191,0,191,0,254,0,0,3,244,63,64,254,0,255,0,0,7,240,47,0,124,0,255,255,255,255,240,20,0,4,0,127,255,255,255,208,0,0,0,0,27,255,255,255,64,0,0,
  // 0x6062  恢
  98,96,34,35,59,36,1,252,0,63,0,31,64,0,0,0,0,0,63,0,31,64,0,0,0,0,0,63,0,31,64,0,0,0,0,0,63,0,47,64,0,0,0,0,0,63,3,255,255,255,255,255,208,0,63,3,255,255,255,255,255,208,0,63,103,255,255,255,255,255,208,10,63,248,31,64,0,0,0,0,31,63,188,31,64,3,240,0,0,31,63,61,31,64,3,240,0,0,31,63,46,31,64,3,240,0,0,46,63,31,47,64,3,240,0,0,46,63,15,47,73,3,240,11,128,61,63,14,47,79,131,240,15,192,60,63,0,47,79,67,240,31,128,188,63,0,47,79,3,240,47,0,248,63,0,47,95,3,240,63,0,16,63,0,47,47,3,240,125,0,0,63,0,63,62,3,240,188,0,0,63,0,63,61,3,244,248,0,0,63,0,63,124,7,244,96,0,0,63,0,63,4,11,248,0,0,0,63,0,126,0,15,252,0,0,0,63,0,190,0,31,189,0,0,0,63,0,253,0,63,63,0,0,0,63,0,252,0,127,47,64,0,0,63,1,252,0,253,15,192,0,0,63,2,248,2,252,15,224,0,0,63,3,240,11,240,7,248,0,0,63,11,240,47,224,2,254,0,0,63,15,209,255,128,0,255,192,0,63,47,195,254,0,0,63,224,0,63,15,66,248,0,0,15,192,0,63,2,0,208,0,0,2,64,0,0,0,0,0,0,0,0,0,
  // 0x606f  息
  111,96,33,34,50,36,2,253,0,0,0,15,240,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,31,192,0,0,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,63,170,170,170,170,253,0,0,0,63,64,0,0,0,253,0,0,0,63,64,0,0,0,253,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,63,149,85,85,85,253,0,0,0,63,64,0,0,0,253,0,0,0,63,64,0,0,0,253,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,63,149,85,85,85,253,0,0,0,63,64,0,0,0,253,0,0,0,63,64,0,0,0,253,0,0,0,63,170,170,170,170,253,0,0,0,63,255,255,255,255,253,0,0,0,63,255,255,255,255,253,0,0,0,0,0,9,0,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,224,0,8,0,0,3,224,127,11,248,0,190,0,0,3,240,127,2,254,0,191,128,0,11,240,127,0,255,0,63,224,0,15,208,127,0,56,0,15,244,0,47,192,127,0,0,30,3,252,0,127,128,127,0,0,31,128,255,0,255,0,127,0,0,63,128,191,64,253,0,63,255,255,255,64,63,64,36,0,47,255,255,255,0,24,0,0,0,11,255,255,248,0,0,0,
  // 0x611f  感
  31,97,34,33,41,36,1,254,0,0,0,0,11,224,189,0,0,0,0,0,0,7,225,255,208,0,0,0,0,0,7,240,31,224,0,1,170,170,170,175,250,171,234,64,1,255,255,255,255,255,255,255,128,1,255,255,255,255,255,255,255,128,1,248,0,0,3,244,0,0,0,1,248,0,0,2,248,1,0,0,1,248,0,0,1,252,11,224,0,1,249,255,255,244,252,15,208,0,2,249,255,255,244,253,31,192,0,2,244,0,0,0,190,63,128,0,2,244,0,0,0,127,127,0,0,3,244,255,255,240,63,254,0,0,3,240,255,255,240,47,252,0,0,3,240,253,87,240,15,244,1,0,7,240,252,3,240,15,240,3,128,11,224,252,3,240,63,244,3,224,15,192,253,87,240,255,252,7,208,31,192,255,255,247,254,255,75,192,63,128,255,255,255,248,127,255,192,191,0,0,5,7,224,31,255,64,61,0,0,47,129,64,2,253,0,8,0,5,111,244,0,1,0,0,0,36,31,199,254,0,47,128,0,0,127,31,192,255,64,47,224,0,0,254,31,192,46,0,11,248,0,1,252,31,192,4,7,147,253,0,3,248,31,192,0,7,224,255,0,15,240,31,192,0,15,224,63,192,63,208,15,255,255,255,192,31,208,47,128,11,255,255,255,192,15,64,5,0,1,255,255,254,0,0,0,
  // 0x620f  戏
  15,98,34,35,59,36,1,252,0,0,0,0,7,224,8,0,0,0,0,0,0,11,240,63,0,0,0,0,0,0,11,240,127,192,0,0,0,0,0,7,240,31,240,0,63,255,255,224,7,240,7,252,0,63,255,255,244,7,240,1,252,0,63,255,255,240,7,240,0,96,0,0,0,3,240,3,240,0,0,0,0,0,7,240,3,244,1,107,128,6,0,11,224,7,255,255,255,192,31,128,15,215,255,255,255,255,192,47,208,15,215,255,255,255,233,64,15,240,31,199,255,253,64,0,0,3,248,47,193,67,248,0,96,0,1,253,63,64,2,252,0,189,0,0,191,127,0,2,252,0,253,0,0,63,255,0,1,252,2,252,0,0,31,254,0,1,253,3,244,0,0,11,252,0,0,253,11,240,0,0,3,252,0,0,254,31,208,0,0,7,254,0,0,255,63,192,0,0,15,255,0,0,191,191,0,0,0,47,255,192,0,127,253,0,0,0,127,223,224,0,63,248,0,0,0,255,15,240,0,63,240,5,0,3,254,7,248,0,63,208,11,128,11,252,2,248,1,255,224,11,208,47,240,0,224,7,255,240,15,192,191,208,0,64,47,255,252,15,192,63,64,0,1,255,227,255,111,192,13,0,0,11,255,65,255,255,128,0,0,0,2,252,0,127,255,0,0,0,0,0,160,0,31,254,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,0,0,0,
  // 0x6210  成
  16,98,34,35,59,36,1,252,0,0,0,0,15,224,96,0,0,0,0,0,0,15,225,254,0,0,0,0,0,0,15,225,255,192,0,0,0,0,0,15,224,47,244,0,0,0,0,0,15,224,7,252,0,0,0,0,0,15,224,0,240,0,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,255,255,255,255,255,255,255,192,2,253,85,85,91,245,85,85,64,2,252,0,0,7,240,0,0,0,2,252,0,0,7,240,0,0,0,2,252,0,0,3,240,1,228,0,2,252,0,0,3,244,3,252,0,2,255,255,255,3,244,3,244,0,2,255,255,255,3,248,11,240,0,2,255,255,255,2,248,15,224,0,2,252,0,127,2,252,31,192,0,2,252,0,127,1,252,63,192,0,2,252,0,127,0,253,127,64,0,2,252,0,127,0,254,255,0,0,2,252,0,127,0,255,253,0,0,3,248,0,190,0,191,248,0,0,3,248,0,190,0,127,240,0,0,3,244,0,190,0,63,208,5,0,7,244,0,253,0,191,192,11,128,11,241,255,253,1,255,208,11,208,11,240,255,252,11,255,240,11,208,15,224,191,224,63,255,248,15,192,47,208,0,2,255,211,254,31,192,63,192,0,31,255,1,255,255,128,127,64,0,15,248,0,127,255,0,47,0,0,3,208,0,15,253,0,9,0,0,1,0,0,0,80,0,0,0,0,0,0,0,0,0,0,
  // 0x6237  户
  55,98,30,35,24,36,1,252,0,0,0,1,240,0,0,0,0,0,0,3,248,0,0,0,0,0,0,2,252,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,63,255,255,255,255,255,224,0,63,255,255,255,255,255,224,0,63,255,255,255,255,255,224,0,63,64,0,0,0,15,224,0,63,64,0,0,0,15,224,0,63,64,0,0,0,15,224,0,63,64,0,0,0,15,224,0,63,64,0,0,0,15,224,0,63,64,0,0,0,15,224,0,63,64,0,0,0,15,224,0,63,255,255,255,255,255,224,0,63,255,255,255,255,255,224,0,127,255,255,255,255,255,224,0,127,0,0,0,0,15,224,0,191,0,0,0,0,15,224,0,191,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,0,0,0,0,0,1,253,0,0,0,0,0,0,2,252,0,0,0,0,0,0,3,252,0,0,0,0,0,0,3,248,0,0,0,0,0,0,11,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,47,208,0,0,0,0,0,0,127,192,0,0,0,0,0,0,127,64,0,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6240  所
  64,98,34,34,50,36,1,253,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,189,0,47,255,255,255,192,0,31,255,128,47,255,255,255,196,7,255,255,64,47,255,255,255,207,255,255,224,0,0,0,0,0,15,255,249,0,0,0,0,0,0,15,253,0,0,0,0,0,0,0,15,208,0,0,0,0,0,0,0,15,208,0,0,0,11,255,255,255,15,208,0,0,0,11,255,255,255,15,208,0,0,0,11,255,255,255,15,208,0,0,0,11,224,0,127,15,224,0,0,0,11,224,0,127,15,255,255,255,224,11,224,0,127,15,255,255,255,224,11,224,0,127,15,255,255,255,224,11,224,0,127,15,208,7,240,0,11,255,255,255,15,208,7,240,0,11,255,255,255,15,192,7,240,0,11,255,255,255,15,192,7,240,0,11,224,0,0,31,192,7,240,0,11,224,0,0,47,192,7,240,0,11,208,0,0,47,128,7,240,0,15,208,0,0,63,64,7,240,0,15,208,0,0,127,0,7,240,0,15,192,0,0,191,0,7,240,0,31,192,0,0,253,0,7,240,0,31,192,0,2,252,0,7,240,0,47,128,0,3,248,0,7,240,0,63,64,0,11,240,0,7,240,0,191,0,0,47,224,0,7,240,0,254,0,0,63,192,0,7,240,0,124,0,0,15,64,0,7,240,0,8,0,0,1,0,0,7,240,0,
  // 0x6247  扇
  71,98,32,32,0,36,1,253,31,255,255,255,255,255,255,255,31,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,240,0,255,255,255,255,255,255,240,0,255,170,170,170,170,171,240,0,253,0,0,0,0,3,240,0,253,0,0,0,0,3,240,0,255,170,170,170,170,171,240,0,255,255,255,255,255,255,240,0,255,255,255,255,255,255,240,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,253,255,255,241,255,255,252,0,253,255,255,241,255,255,252,0,252,170,171,240,170,170,252,1,252,24,3,240,44,1,252,1,252,127,3,240,191,1,252,2,252,47,131,240,47,193,252,2,248,15,211,240,15,209,252,3,244,7,131,240,3,65,252,7,240,0,3,240,0,21,252,11,240,1,243,240,2,253,252,15,224,111,247,240,111,253,252,31,215,255,211,243,255,209,252,47,195,253,3,242,253,1,252,127,67,144,3,241,128,1,252,255,0,1,171,240,0,171,248,45,0,0,255,224,0,191,244,4,0,0,255,128,0,63,208,
  // 0x624b  手
  75,98,32,35,24,36,2,252,0,0,0,0,0,0,104,0,0,0,0,0,22,191,254,0,0,5,90,191,255,255,255,64,11,255,255,255,255,255,228,0,7,255,255,255,254,80,0,0,3,255,169,95,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,15,240,0,0,0,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,240,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,85,85,85,95,245,85,85,85,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,1,64,31,224,0,0,0,0,3,255,255,224,0,0,0,0,2,255,255,192,0,0,0,0,0,255,249,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6253  打
  83,98,34,34,50,36,1,253,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,15,255,255,255,255,224,0,15,192,15,255,255,255,255,224,0,15,192,15,255,255,255,255,224,0,15,192,5,85,85,254,85,64,63,255,255,240,0,0,253,0,0,63,255,255,240,0,0,253,0,0,63,255,255,240,0,0,253,0,0,0,31,208,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,214,240,0,0,253,0,0,0,31,255,240,0,0,253,0,0,6,255,255,240,0,0,253,0,0,127,255,254,64,0,0,253,0,0,63,255,208,0,0,0,253,0,0,63,175,192,0,0,0,253,0,0,20,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,0,253,0,0,0,15,192,0,0,1,253,0,0,0,31,192,0,47,255,253,0,0,15,255,192,0,31,255,252,0,0,15,255,128,0,15,255,240,0,0,7,249,0,0,6,165,0,0,0,
  // 0x6267  执
  103,98,34,35,59,36,1,252,0,63,0,0,31,192,0,0,0,0,63,0,0,31,192,0,0,0,0,63,0,0,31,192,0,0,0,0,63,0,0,31,192,0,0,0,0,63,0,0,31,192,0,0,0,0,63,0,0,31,192,0,0,0,0,63,0,0,31,192,0,0,0,0,63,0,0,31,192,0,0,0,63,255,254,191,255,255,255,192,0,63,255,254,191,255,255,255,128,0,63,255,254,191,255,255,255,128,0,0,63,0,0,47,128,47,128,0,0,63,0,0,47,128,47,128,0,0,63,0,0,47,128,47,128,0,0,63,0,0,63,64,47,128,0,0,63,0,4,63,64,47,128,0,0,63,91,63,127,64,47,128,0,0,63,255,191,255,0,47,128,0,1,191,255,31,255,0,47,128,0,127,255,249,2,255,208,47,128,0,127,255,64,0,191,248,47,64,0,63,191,0,0,255,255,111,64,0,36,63,0,0,253,255,255,64,0,0,63,0,2,252,47,175,128,0,0,63,0,3,244,7,47,128,0,0,63,0,11,240,0,47,128,0,0,63,0,15,224,0,31,130,0,0,63,0,63,192,0,31,131,208,0,63,0,191,128,0,15,195,224,0,63,2,255,0,0,15,199,208,0,127,11,252,0,0,15,235,208,47,255,47,244,0,0,7,255,192,15,254,15,208,0,0,3,255,128,15,228,3,64,0,0,0,190,0,0,0,0,0,0,0,0,0,0,
  // 0x6279  批
  121,98,34,34,50,36,1,253,0,63,0,42,0,2,160,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,127,255,253,63,64,7,240,0,0,127,255,253,63,64,7,240,4,0,127,255,253,63,64,7,240,31,0,0,127,0,63,64,7,240,127,128,0,63,0,63,64,7,241,255,128,0,63,0,63,255,215,247,254,0,0,63,0,63,255,215,255,244,0,0,63,0,63,255,215,255,192,0,0,63,0,63,64,7,253,0,0,0,63,188,63,64,7,240,0,0,0,127,253,63,64,7,240,0,0,27,255,253,63,64,7,240,0,0,255,255,208,63,64,7,240,0,0,191,255,0,63,64,7,240,0,0,126,127,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,0,0,0,63,0,63,64,7,240,7,128,0,63,0,63,64,7,240,7,224,0,63,0,63,86,151,240,7,224,0,63,0,63,255,231,240,11,208,0,127,11,255,255,227,240,15,208,63,254,15,255,255,147,255,255,192,31,253,15,254,144,3,255,255,128,15,228,6,64,0,0,191,254,0,
  // 0x6296  抖
  150,98,34,35,59,36,1,252,0,47,128,0,0,0,47,128,0,0,47,128,0,0,0,47,128,0,0,47,128,0,16,0,47,128,0,0,47,128,0,126,0,47,128,0,0,47,128,0,255,208,47,128,0,0,47,128,0,47,248,47,128,0,0,47,128,0,7,254,47,128,0,63,255,255,192,0,253,47,128,0,63,255,255,192,0,36,47,128,0,63,255,255,192,0,0,47,128,0,0,47,128,0,0,0,47,128,0,0,47,128,1,64,0,47,128,0,0,47,128,3,244,0,47,128,0,0,47,128,11,254,0,47,128,0,0,47,128,2,255,208,47,128,0,0,47,128,64,127,244,47,128,0,0,47,223,192,11,240,47,128,0,0,47,255,192,1,192,47,128,0,27,255,255,192,0,0,47,128,0,191,255,249,0,0,0,47,128,0,127,255,192,0,0,0,47,239,208,63,175,128,0,0,6,191,255,208,16,47,128,0,107,255,255,255,224,0,47,128,63,255,255,255,249,64,0,47,128,63,255,255,191,128,0,0,47,128,47,250,64,47,128,0,0,47,128,21,0,0,47,128,0,0,47,128,0,0,0,47,128,0,0,47,128,0,0,0,47,128,0,0,47,128,0,0,0,47,128,0,0,47,128,0,0,0,47,128,0,47,255,128,0,0,0,47,128,0,15,255,0,0,0,0,47,128,0,15,248,0,0,0,0,47,128,0,0,0,0,0,0,0,0,0,0,
  // 0x62a5  报
  165,98,34,35,59,36,1,252,0,31,192,0,0,0,0,0,0,0,31,192,15,255,255,255,253,0,0,31,192,15,255,255,255,253,0,0,31,192,15,255,255,255,253,0,0,31,192,15,208,0,0,253,0,0,31,192,15,208,0,0,252,0,0,31,192,15,208,0,0,252,0,63,255,255,143,208,0,1,252,0,63,255,255,143,208,0,2,252,0,63,255,255,143,208,42,171,248,0,0,47,192,15,208,63,255,244,0,0,31,192,15,208,47,255,208,0,0,31,192,15,208,0,0,0,0,0,31,192,15,208,0,0,0,0,0,31,192,15,255,255,255,254,0,0,31,192,15,255,255,255,255,0,0,31,219,143,255,255,255,255,0,0,47,255,207,219,224,0,191,0,27,255,255,207,215,240,0,253,0,191,255,254,79,211,244,1,252,0,127,255,192,15,209,252,2,252,0,63,175,192,15,208,253,3,244,0,16,31,192,15,208,191,11,240,0,0,31,192,15,208,63,207,224,0,0,31,192,15,208,31,255,192,0,0,31,192,15,208,11,255,64,0,0,31,192,15,208,3,255,0,0,0,31,192,15,208,7,255,64,0,0,31,192,15,208,31,255,208,0,0,31,192,15,208,127,255,248,0,0,47,192,15,211,255,75,255,128,63,255,192,15,255,253,2,255,208,63,255,64,15,223,240,0,127,64,47,249,0,15,211,128,0,10,0,0,0,0,0,0,0,0,0,0,
  // 0x62ac  抬
  172,98,34,35,59,36,1,252,0,31,192,0,3,228,0,0,0,0,31,192,0,3,252,0,0,0,0,31,192,0,7,244,0,0,0,0,31,192,0,11,240,0,0,0,0,31,192,0,15,224,0,0,0,0,31,192,0,31,208,1,0,0,0,31,192,0,47,192,31,0,0,127,255,255,128,63,64,63,192,0,127,255,255,128,127,0,15,224,0,127,255,255,128,254,0,11,244,0,0,47,192,0,253,0,3,252,0,0,31,192,2,252,0,1,254,0,0,31,192,87,253,170,255,255,0,0,31,192,191,255,255,255,255,128,0,31,192,191,255,255,255,255,192,0,31,192,191,250,165,80,15,224,0,31,219,192,0,0,0,11,192,0,47,255,192,0,0,0,1,0,6,255,255,192,0,0,0,0,0,255,255,249,11,255,255,255,252,0,191,255,192,11,255,255,255,252,0,126,111,192,11,255,255,255,252,0,0,31,192,11,224,0,1,252,0,0,31,192,11,224,0,1,252,0,0,31,192,11,224,0,1,252,0,0,31,192,11,224,0,1,252,0,0,31,192,11,224,0,1,252,0,0,31,192,11,224,0,1,252,0,0,31,192,11,224,0,1,252,0,0,31,192,11,255,255,255,252,0,0,47,192,11,255,255,255,252,0,31,255,128,11,255,255,255,252,0,15,255,64,11,224,0,1,252,0,15,249,0,11,224,0,0,168,0,0,0,0,0,0,0,0,0,0,
  // 0x62bd  抽
  189,98,33,35,59,36,1,252,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,0,47,64,0,0,47,64,0,0,127,255,255,0,0,47,64,0,0,127,255,255,47,255,255,255,255,192,127,255,255,47,255,255,255,255,192,0,47,128,47,255,255,255,255,192,0,47,64,47,128,63,128,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,159,111,64,47,64,47,192,0,63,255,111,64,47,64,47,192,27,255,255,175,255,255,255,255,192,255,255,248,47,255,255,255,255,192,191,255,128,47,255,255,255,255,192,126,127,64,47,128,47,128,47,192,16,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,64,47,64,47,192,0,47,64,47,255,255,255,255,192,0,47,64,47,255,255,255,255,192,0,63,64,47,255,255,255,255,192,47,255,64,47,128,0,0,47,192,31,255,0,47,64,0,0,47,192,15,248,0,47,64,0,0,26,128,0,0,0,0,0,0,0,0,0,
  // 0x62d4  拔
  212,98,34,35,59,36,1,252,0,47,64,0,31,192,16,0,0,0,47,64,0,31,192,125,0,0,0,47,64,0,31,192,255,192,0,0,47,64,0,31,192,47,244,0,0,47,64,0,31,192,7,254,0,0,47,64,0,31,192,0,254,0,0,47,64,0,31,192,0,44,0,127,255,255,0,31,192,0,0,0,127,255,255,127,255,255,255,255,192,127,255,255,127,255,255,255,255,192,106,191,234,127,255,255,255,255,192,0,47,64,0,47,128,0,0,0,0,47,64,0,47,128,0,0,0,0,47,64,0,63,192,0,64,0,0,47,64,0,63,208,2,248,0,0,47,64,0,63,224,3,244,0,0,47,135,64,63,240,3,240,0,0,47,255,64,127,240,7,240,0,6,255,255,128,191,248,11,224,0,191,255,253,0,254,252,15,208,0,191,255,128,0,252,189,31,192,0,127,191,64,1,252,127,47,192,0,32,47,64,2,248,63,127,64,0,0,47,64,3,244,31,255,0,0,0,47,64,7,240,15,254,0,0,0,47,64,15,224,7,252,0,0,0,47,64,31,208,7,252,0,0,0,47,64,63,192,15,255,64,0,0,47,64,191,64,63,255,208,0,0,47,65,254,0,255,95,244,0,0,63,67,252,7,254,7,255,64,47,255,79,244,47,248,1,255,224,31,255,11,208,47,208,0,47,192,15,248,2,128,7,0,0,3,64,0,0,0,0,0,0,0,0,0,
  // 0x62e9  择
  233,98,34,35,59,36,1,252,0,47,64,0,0,0,0,0,0,0,63,64,0,0,0,0,0,0,0,63,64,47,255,255,255,248,0,0,63,64,47,255,255,255,253,0,0,63,64,47,255,255,255,252,0,0,63,64,0,253,0,7,244,0,0,63,64,0,127,0,31,208,0,127,255,255,64,47,192,127,128,0,127,255,255,64,11,246,254,0,0,127,255,255,64,3,255,248,0,0,0,63,64,0,0,255,224,0,0,0,63,64,0,7,255,248,0,0,0,63,64,0,127,255,255,128,0,0,63,64,11,255,208,255,254,0,0,63,64,255,254,0,31,255,224,0,63,65,191,224,0,2,255,192,0,63,175,61,0,63,64,27,64,0,63,255,0,0,63,64,0,0,11,255,255,64,0,63,64,0,0,191,255,228,15,255,255,255,252,0,127,255,64,15,255,255,255,252,0,62,127,64,15,255,255,255,252,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,255,255,255,255,255,208,0,63,64,255,255,255,255,255,208,0,63,64,255,255,255,255,255,208,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,31,255,64,0,0,63,64,0,0,15,255,0,0,0,63,64,0,0,15,248,0,0,0,63,64,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6309  按
  9,99,34,35,59,36,1,252,0,47,64,0,0,63,0,0,0,0,47,64,0,0,63,64,0,0,0,47,64,0,0,63,64,0,0,0,47,64,0,0,63,64,0,0,0,47,64,0,0,63,64,0,0,0,47,64,63,255,255,255,255,192,0,47,64,63,255,255,255,255,192,127,255,255,127,255,255,255,255,192,127,255,255,127,0,0,0,15,192,127,255,255,127,1,252,0,15,192,0,47,128,63,2,252,0,15,192,0,47,64,63,3,248,0,15,192,0,47,64,0,3,240,0,0,0,0,47,64,0,7,240,0,0,0,0,47,64,0,15,224,0,0,0,0,47,64,127,255,255,255,255,224,0,47,70,191,255,255,255,255,224,0,47,255,255,255,255,255,255,224,1,191,255,128,63,64,7,240,0,191,255,254,0,127,0,15,240,0,191,255,128,0,254,0,15,224,0,127,191,64,0,252,0,31,208,0,36,47,64,2,252,0,47,192,0,0,47,64,3,255,64,63,64,0,0,47,64,7,255,248,255,0,0,0,47,64,11,255,255,253,0,0,0,47,64,0,65,255,252,0,0,0,47,64,0,0,63,255,64,0,0,47,64,0,1,255,255,240,0,0,47,64,0,31,255,47,253,0,0,63,64,6,255,248,7,255,128,47,255,65,255,255,128,0,191,208,31,255,0,255,244,0,0,31,128,15,248,0,121,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
  // 0x6321  挡
  33,99,33,35,59,36,1,252,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,64,0,0,0,63,64,1,0,63,64,20,0,0,63,64,47,128,63,64,63,64,0,63,64,31,192,63,64,127,0,0,63,64,15,208,63,64,190,0,0,63,64,11,224,63,64,253,0,127,255,255,67,240,63,65,252,0,127,255,255,67,244,63,66,248,0,127,255,255,66,248,63,67,240,0,0,63,128,1,248,63,71,224,0,0,63,64,0,128,63,66,208,0,0,63,64,0,0,63,64,0,0,0,63,64,0,0,63,128,0,0,0,63,64,63,255,255,255,255,0,0,63,64,63,255,255,255,255,0,0,63,91,63,255,255,255,255,0,0,63,255,64,0,0,0,127,0,6,255,255,64,0,0,0,127,0,191,255,249,0,0,0,0,127,0,191,255,128,0,0,0,0,127,0,127,127,64,31,255,255,255,255,0,16,63,64,31,255,255,255,255,0,0,63,64,31,255,255,255,255,0,0,63,64,0,0,0,0,127,0,0,63,64,0,0,0,0,127,0,0,63,64,0,0,0,0,127,0,0,63,64,0,0,0,0,127,0,0,63,64,191,255,255,255,255,0,0,63,64,191,255,255,255,255,0,0,63,64,191,255,255,255,255,0,47,255,64,0,0,0,0,127,0,31,255,0,0,0,0,0,127,0,15,248,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,
  // 0x6324  挤
  36,99,34,34,50,36,1,253,0,126,0,0,1,180,0,0,0,0,126,0,0,2,252,0,0,0,0,126,0,0,0,253,0,0,0,0,126,0,0,0,191,0,0,0,0,126,2,255,255,255,255,255,192,0,126,2,255,255,255,255,255,192,0,126,2,255,255,255,255,255,192,127,255,252,3,244,0,15,224,0,127,255,252,1,252,0,47,192,0,127,255,252,0,254,0,63,128,0,0,191,0,0,127,64,255,0,0,0,126,0,0,47,211,253,0,0,0,126,0,0,11,255,244,0,0,0,126,0,0,3,255,224,0,0,0,126,0,0,11,255,244,0,0,0,126,0,1,255,255,255,212,0,0,127,186,255,255,215,255,255,224,0,191,253,255,253,0,111,255,192,11,255,252,255,144,0,1,191,128,191,255,144,80,252,0,63,65,0,127,254,0,0,252,0,63,64,0,62,190,0,0,252,0,63,64,0,16,126,0,0,252,0,63,64,0,0,126,0,0,252,0,63,64,0,0,126,0,1,252,0,63,64,0,0,126,0,1,252,0,63,64,0,0,126,0,3,248,0,63,64,0,0,126,0,3,244,0,63,64,0,0,126,0,11,240,0,63,64,0,0,126,0,47,224,0,63,64,0,0,190,0,191,192,0,63,64,0,63,254,7,255,0,0,63,64,0,31,252,7,248,0,0,63,64,0,15,224,0,144,0,0,63,64,0,
  // 0x635f  损
  95,99,34,35,59,36,1,252,0,63,0,0,0,0,0,0,0,0,63,0,6,170,170,170,160,0,0,63,0,7,255,255,255,240,0,0,63,0,7,255,255,255,240,0,0,63,0,7,240,0,3,240,0,0,63,0,7,240,0,3,240,0,0,63,0,7,240,0,3,240,0,127,255,255,7,240,0,3,240,0,127,255,255,7,255,255,255,240,0,127,255,255,7,255,255,255,240,0,0,127,0,6,170,170,170,160,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,31,255,255,255,253,0,0,63,0,31,255,255,255,253,0,0,63,0,31,234,170,170,253,0,0,63,6,31,128,0,0,253,0,0,63,255,31,128,0,0,253,0,0,191,255,95,128,63,0,253,0,111,255,254,31,128,127,0,253,0,191,255,144,31,128,127,0,253,0,191,255,0,31,128,127,0,253,0,120,63,0,31,128,127,0,253,0,0,63,0,31,128,127,0,253,0,0,63,0,31,128,190,0,253,0,0,63,0,31,128,253,0,253,0,0,63,0,26,67,252,16,84,0,0,63,0,0,15,244,125,0,0,0,63,0,0,127,240,255,128,0,0,63,0,6,255,192,127,244,0,21,191,0,127,254,0,11,254,0,63,255,7,255,244,0,1,255,208,31,254,2,255,64,0,0,47,208,15,228,0,224,0,0,0,7,64,0,0,0,0,0,0,0,0,0,
  // 0x6362  换
  98,99,34,35,59,36,1,252,0,127,0,0,14,128,0,0,0,0,127,0,0,47,192,0,0,0,0,127,0,0,63,128,0,0,0,0,127,0,0,191,255,255,128,0,0,127,0,1,255,255,255,240,0,0,127,0,3,255,255,255,208,0,0,127,0,15,240,0,63,192,0,127,255,252,63,208,0,191,0,0,127,255,252,255,128,1,253,0,0,127,255,254,255,170,171,254,168,0,0,127,0,191,255,255,255,252,0,0,127,0,63,255,255,255,252,0,0,127,0,31,128,127,1,252,0,0,127,0,31,128,127,1,252,0,0,127,0,31,128,127,1,252,0,0,127,0,31,128,127,1,252,0,0,127,109,31,128,127,1,252,0,0,127,253,31,128,127,1,252,0,27,255,254,31,128,127,1,252,0,191,255,244,31,128,190,1,252,0,127,255,3,255,255,255,255,255,192,62,191,3,255,255,255,255,255,192,0,127,3,255,255,255,255,255,192,0,127,0,0,3,255,64,0,0,0,127,0,0,11,255,192,0,0,0,127,0,0,15,235,224,0,0,0,127,0,0,63,195,248,0,0,0,127,0,0,255,65,254,0,0,0,127,0,7,253,0,191,128,0,0,127,0,47,244,0,47,244,0,0,191,1,255,208,0,11,254,64,47,255,31,255,0,0,1,255,224,15,253,15,248,0,0,0,127,192,15,228,3,128,0,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x6389  掉
  137,99,34,35,59,36,1,252,0,63,0,0,0,190,0,0,0,0,63,0,0,0,190,0,0,0,0,63,0,0,0,190,0,0,0,0,63,0,0,0,191,255,255,192,0,63,0,0,0,191,255,255,192,0,63,0,0,0,191,255,255,192,0,63,0,0,0,190,0,0,0,127,255,255,0,0,190,0,0,0,127,255,255,0,0,190,0,0,0,127,255,255,63,255,255,255,253,0,0,127,0,63,255,255,255,253,0,0,63,0,63,170,170,170,253,0,0,63,0,63,0,0,0,253,0,0,63,0,63,0,0,0,253,0,0,63,0,63,255,255,255,253,0,0,63,1,63,255,255,255,253,0,0,63,190,63,85,85,85,253,0,0,127,255,63,0,0,0,253,0,47,255,255,63,0,0,0,253,0,127,255,208,63,170,170,170,253,0,63,255,0,63,255,255,255,253,0,57,127,0,63,255,255,255,253,0,0,63,0,0,0,190,0,0,0,0,63,0,0,0,190,0,0,0,0,63,0,0,0,190,0,0,0,0,63,3,255,255,255,255,255,208,0,63,3,255,255,255,255,255,208,0,63,3,255,255,255,255,255,208,0,63,0,0,0,190,0,0,0,0,63,0,0,0,190,0,0,0,0,127,0,0,0,190,0,0,0,63,255,0,0,0,190,0,0,0,63,254,0,0,0,190,0,0,0,47,228,0,0,0,190,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x63a2  探
  162,99,34,34,50,36,1,253,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,191,255,255,255,255,192,0,63,0,191,255,255,255,255,192,0,63,0,191,255,255,255,255,192,0,63,0,189,0,0,0,15,192,0,63,0,189,15,193,248,15,192,127,255,253,189,15,193,248,15,192,127,255,253,189,31,129,248,10,128,127,255,253,0,47,129,248,0,0,0,127,0,0,63,65,248,3,64,0,63,0,0,191,1,248,3,224,0,63,0,2,253,1,252,7,208,0,63,0,31,248,1,255,255,192,0,63,0,255,224,0,255,255,128,0,63,0,127,64,127,26,169,0,0,63,188,16,0,127,0,0,0,0,191,253,0,0,127,0,0,0,111,255,253,0,0,127,0,0,0,191,255,144,255,255,255,255,255,192,127,255,0,255,255,255,255,255,192,120,63,0,255,255,255,255,255,192,0,63,0,0,11,255,244,0,0,0,63,0,0,31,255,252,0,0,0,63,0,0,63,255,255,0,0,0,63,0,0,255,127,63,128,0,0,63,0,3,252,127,31,224,0,0,63,0,15,244,127,7,248,0,0,63,0,127,208,127,2,255,0,0,63,7,255,64,127,0,191,224,0,127,11,253,0,127,0,47,208,63,254,3,224,0,127,0,7,128,31,253,0,64,0,127,0,0,0,15,228,0,0,0,127,0,0,0,
  // 0x63a5  接
  165,99,34,35,59,36,1,252,0,47,64,0,0,127,0,0,0,0,47,64,0,0,127,0,0,0,0,47,64,0,0,127,0,0,0,0,47,64,0,0,127,0,0,0,0,47,64,191,255,255,255,255,64,0,47,64,191,255,255,255,255,64,0,47,64,127,255,255,255,255,64,0,47,128,0,252,0,15,192,0,127,255,254,0,253,0,31,192,0,127,255,254,0,126,0,63,64,0,127,255,254,0,127,0,63,0,0,0,47,64,0,63,0,126,0,0,0,47,66,255,255,255,255,255,208,0,47,67,255,255,255,255,255,208,0,47,67,255,255,255,255,255,208,0,47,64,0,7,244,0,0,0,0,47,174,0,11,240,0,0,0,0,63,255,0,15,208,0,0,0,27,255,255,255,255,255,255,255,208,255,255,230,255,255,255,255,255,208,191,255,66,255,255,255,255,255,208,126,47,64,0,253,0,31,192,0,0,47,64,1,252,0,47,192,0,0,47,64,3,248,0,63,64,0,0,47,64,7,244,0,127,0,0,0,47,64,15,255,128,254,0,0,0,47,64,31,255,255,252,0,0,0,47,64,6,159,255,248,0,0,0,47,64,0,0,255,254,0,0,0,47,64,0,7,255,255,224,0,0,63,64,5,191,253,191,253,0,47,255,71,255,255,224,11,255,64,15,255,3,255,249,0,0,191,0,15,248,2,249,0,0,0,28,0,0,0,0,0,0,0,0,0,0,
  // 0x63a7  控
  167,99,34,34,50,36,1,253,0,62,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,255,255,255,255,255,192,0,63,0,255,255,255,255,255,192,0,63,0,255,255,255,255,255,192,0,127,1,248,31,193,248,15,192,127,255,253,248,31,129,248,15,192,127,255,253,248,31,129,248,15,192,127,255,253,248,47,65,248,0,0,0,63,0,0,63,1,248,1,0,0,63,0,0,127,1,248,7,192,0,63,0,1,253,1,248,11,192,0,63,0,11,252,1,255,175,192,0,63,25,191,240,0,255,255,128,0,63,253,191,128,0,127,254,0,0,191,254,56,0,0,0,0,0,47,255,248,0,0,0,0,0,0,255,255,128,0,0,0,0,0,0,191,255,0,63,255,255,255,254,0,125,127,0,63,255,255,255,254,0,0,63,0,63,255,255,255,254,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,63,0,0,0,127,0,0,0,0,127,3,255,255,255,255,255,224,63,254,3,255,255,255,255,255,224,31,253,3,255,255,255,255,255,224,15,228,0,0,0,0,0,0,0,
  // 0x63d0  提
  208,99,34,35,59,36,1,252,0,126,0,0,0,0,0,0,0,0,126,0,15,255,255,255,252,0,0,126,0,15,255,255,255,252,0,0,126,0,15,213,85,86,252,0,0,126,0,15,192,0,0,252,0,0,126,0,15,192,0,0,252,0,0,126,0,15,255,255,255,252,0,127,255,254,15,255,255,255,252,0,127,255,254,15,213,85,85,252,0,127,255,254,15,192,0,0,252,0,0,127,0,15,192,0,0,252,0,0,126,0,15,255,255,255,252,0,0,126,0,15,255,255,255,252,0,0,126,0,5,85,85,85,84,0,0,126,0,0,0,0,0,0,0,0,126,0,0,0,0,0,0,0,0,126,24,255,255,255,255,255,192,0,127,253,255,255,255,255,255,192,6,255,254,170,170,255,170,170,128,191,255,248,0,0,127,0,0,0,191,255,0,11,128,127,0,0,0,126,190,0,15,192,127,0,0,0,0,126,0,15,192,127,170,168,0,0,126,0,31,192,127,255,252,0,0,126,0,47,192,127,255,252,0,0,126,0,63,192,127,0,0,0,0,126,0,63,224,127,0,0,0,0,126,0,191,244,127,0,0,0,0,126,0,253,252,127,0,0,0,0,126,2,252,63,191,0,0,0,0,126,7,244,31,255,255,255,224,63,254,15,240,2,255,255,255,208,47,252,47,192,0,27,255,255,192,31,228,7,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x63d2  插
  210,99,33,34,50,36,1,253,0,62,0,0,0,0,0,0,0,0,63,0,0,0,0,22,248,0,0,63,0,1,90,191,255,253,0,0,63,0,127,255,255,255,254,0,0,63,0,63,255,255,233,64,0,0,63,0,42,85,127,0,0,0,0,63,0,0,0,63,0,0,0,127,255,253,0,0,63,0,0,0,127,255,254,255,255,255,255,255,192,127,255,254,255,255,255,255,255,192,0,127,1,255,255,255,255,255,192,0,63,0,0,0,63,0,0,0,0,63,0,0,0,63,0,0,0,0,63,0,0,4,63,0,0,0,0,63,0,0,62,63,0,0,0,0,63,0,182,255,255,63,255,64,0,63,124,191,254,191,63,255,64,0,127,253,191,208,63,47,255,64,111,255,253,190,0,63,0,47,64,191,255,144,189,0,63,0,47,64,127,191,0,189,0,63,0,47,64,32,63,0,191,253,63,47,255,64,0,63,0,191,253,63,47,255,64,0,63,0,191,253,63,47,255,64,0,63,0,189,0,63,0,47,64,0,63,0,189,0,63,0,47,64,0,63,0,189,0,63,0,47,64,0,63,0,189,0,63,0,47,64,0,63,0,189,0,63,0,47,64,0,63,0,191,255,255,255,255,64,0,127,0,191,255,255,255,255,64,63,254,0,191,255,255,255,255,64,31,253,0,189,0,0,0,47,64,15,228,0,125,0,0,0,47,64,
  // 0x6536  收
  54,101,34,35,59,36,1,252,0,0,15,192,3,144,0,0,0,0,0,31,192,3,244,0,0,0,0,0,31,192,7,240,0,0,0,0,0,31,192,11,240,0,0,0,2,144,31,192,15,224,0,0,0,7,240,31,192,31,208,0,0,0,7,240,31,192,47,192,0,0,0,7,240,31,192,63,255,255,255,224,7,240,31,192,127,255,255,255,224,7,240,31,192,255,255,255,255,224,7,240,31,193,255,0,0,253,0,7,240,31,195,255,64,1,252,0,7,240,31,199,255,128,2,252,0,7,240,31,207,255,192,3,248,0,7,240,31,239,239,192,3,244,0,7,240,31,255,203,224,7,240,0,7,240,31,223,7,240,11,240,0,7,240,31,198,3,244,15,208,0,7,240,31,192,2,252,47,192,0,7,240,31,192,1,252,63,128,0,7,240,31,192,0,254,191,0,0,7,241,191,192,0,127,254,0,0,7,255,255,192,0,63,252,0,0,127,255,255,192,0,47,248,0,0,127,255,175,192,0,31,240,0,0,63,228,31,192,0,127,252,0,0,41,0,31,192,1,255,254,0,0,0,0,31,192,7,254,255,128,0,0,0,31,192,47,248,63,240,0,0,0,31,193,255,224,15,253,0,0,0,31,203,255,128,7,255,128,0,0,31,239,253,0,0,255,224,0,0,31,207,224,0,0,47,192,0,0,31,199,0,0,0,3,0,0,0,0,0,0,0,0,0,0,
  // 0x653e  放
  62,101,34,35,59,36,1,252,0,3,240,0,0,185,0,0,0,0,3,240,0,0,254,0,0,0,0,3,240,0,0,254,0,0,0,0,3,240,0,0,253,0,0,0,0,3,240,0,1,252,0,0,0,0,7,244,0,2,252,0,0,0,127,255,255,255,67,248,0,0,0,127,255,255,255,67,255,255,255,224,127,255,255,255,71,255,255,255,224,0,126,0,0,15,255,255,255,224,0,126,0,0,31,224,2,252,0,0,126,0,0,47,240,2,248,0,0,126,0,0,63,240,3,244,0,0,127,255,252,191,244,3,240,0,0,127,255,253,255,248,7,240,0,0,127,255,255,254,252,11,224,0,0,126,0,253,248,252,15,208,0,0,126,0,252,112,190,31,192,0,0,126,0,252,0,127,47,192,0,0,190,0,252,0,63,127,64,0,0,190,1,252,0,63,255,0,0,0,253,1,252,0,31,254,0,0,0,253,1,252,0,15,253,0,0,0,252,1,252,0,11,252,0,0,1,252,1,252,0,11,252,0,0,2,252,1,248,0,31,253,0,0,3,248,2,248,0,127,255,64,0,7,240,2,248,1,255,191,192,0,15,240,2,248,7,253,47,240,0,31,208,3,244,47,244,15,253,0,63,192,7,245,255,208,3,255,128,255,67,255,251,255,64,0,255,208,126,2,255,227,252,0,0,47,128,8,1,255,64,208,0,0,6,0,0,0,0,0,0,0,0,0,0,
  // 0x6570  数
  112,101,34,35,59,36,1,252,0,0,252,0,0,46,64,0,0,7,192,252,15,128,63,128,0,0,11,208,252,31,192,63,64,0,0,3,240,252,63,0,127,0,0,0,2,244,252,189,0,127,0,0,0,1,240,252,120,0,190,0,0,0,42,234,254,170,160,254,0,0,0,127,255,255,255,241,255,255,255,224,127,255,255,255,242,255,255,255,224,0,7,255,0,3,255,255,255,224,0,31,255,224,3,248,0,253,0,0,127,255,252,11,252,1,252,0,2,254,253,255,79,252,2,252,0,31,244,252,63,239,253,2,252,0,127,208,252,11,127,254,3,248,0,63,0,252,0,255,191,3,244,0,24,2,252,0,254,63,7,240,0,0,11,240,0,124,63,79,240,0,0,15,208,0,4,47,207,224,0,127,255,255,255,240,31,239,192,0,191,255,255,255,240,15,255,192,0,191,255,255,255,240,11,255,64,0,0,253,0,252,0,3,255,0,0,2,252,2,252,0,3,254,0,0,3,248,3,244,0,3,253,0,0,11,255,71,240,0,15,255,0,0,15,255,255,224,0,63,255,192,0,6,159,255,192,0,191,255,224,0,0,2,255,240,3,255,15,248,0,0,31,255,254,31,252,3,254,0,6,255,247,255,255,240,1,255,208,63,255,128,127,255,192,0,127,208,47,248,0,13,190,0,0,31,64,14,64,0,0,52,0,0,2,0,0,0,0,0,0,0,0,0,0,
  // 0x6572  敲
  114,101,34,35,59,36,1,252,0,1,252,0,0,11,224,0,0,0,1,252,0,0,11,224,0,0,0,1,252,0,0,11,224,0,0,0,1,252,0,0,11,224,0,0,42,171,254,170,160,11,224,0,0,127,255,255,255,240,11,255,255,192,127,255,255,255,240,11,255,255,192,0,0,0,0,0,11,255,255,192,0,85,85,84,0,11,224,0,0,1,255,255,252,0,11,224,0,0,1,255,255,252,0,11,224,0,0,1,248,0,252,0,11,224,0,0,1,248,0,252,0,11,224,0,0,1,249,85,252,63,255,255,254,0,1,255,255,252,63,255,255,255,0,1,255,255,252,63,255,255,255,0,0,0,0,0,2,160,0,190,0,5,85,85,85,67,240,0,253,0,31,255,255,255,194,244,1,252,0,31,255,255,255,193,252,3,248,0,31,64,0,15,192,253,7,244,0,31,64,0,15,192,191,15,240,0,31,79,255,79,192,63,95,208,0,31,79,255,79,192,47,255,192,0,31,79,7,79,192,15,255,64,0,31,79,7,79,192,7,254,0,0,31,79,7,79,192,7,254,0,0,31,79,255,79,192,31,255,128,0,31,79,255,79,192,191,255,224,0,31,79,0,15,195,255,95,253,0,31,79,0,15,223,254,7,255,128,31,68,1,95,255,248,1,255,224,31,64,3,255,159,208,0,63,192,31,64,1,254,14,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x6574  整
  116,101,33,33,41,36,2,254,0,3,240,0,0,120,0,0,0,0,3,240,0,0,254,0,0,0,255,255,255,255,128,252,0,0,0,255,255,255,255,130,252,0,0,0,85,87,245,85,3,255,255,255,0,0,3,240,0,11,255,255,255,0,63,255,255,255,31,250,175,250,0,63,255,255,255,63,224,11,208,0,63,3,240,63,255,240,15,192,0,62,3,240,63,253,252,47,128,0,63,3,240,63,56,190,63,0,0,63,255,255,255,0,63,254,0,0,63,255,255,255,0,31,252,0,0,0,63,254,0,0,15,248,0,0,0,255,255,208,0,127,254,0,0,7,251,251,253,2,255,255,208,0,63,211,240,254,127,252,47,254,0,255,67,240,45,255,224,7,255,64,120,3,240,0,126,0,0,190,0,0,1,80,0,16,0,0,8,0,10,170,170,170,170,170,170,160,0,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,0,0,0,11,224,0,0,0,0,0,26,64,11,224,0,0,0,0,0,47,128,11,250,170,168,0,0,0,47,128,11,255,255,253,0,0,0,47,128,11,255,255,253,0,0,0,47,128,11,224,0,0,0,0,0,47,128,11,224,0,0,0,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,
  // 0x6599  料
  153,101,34,34,50,36,1,253,0,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,24,11,208,164,1,0,15,208,0,62,11,208,252,15,128,15,208,0,47,11,208,252,31,244,15,208,0,31,11,209,244,7,253,15,208,0,15,75,210,240,0,255,79,208,0,15,139,211,240,0,47,15,208,0,11,203,211,208,0,9,15,208,0,11,203,215,192,0,0,15,208,0,7,139,219,128,0,0,15,208,0,0,11,208,0,0,0,15,208,0,127,255,255,252,120,0,15,208,0,127,255,255,252,255,64,15,208,0,127,255,255,252,191,224,15,208,0,0,63,224,0,31,252,15,208,0,0,63,240,0,2,248,15,208,0,0,191,252,0,0,176,15,208,0,0,255,255,0,0,0,15,208,0,1,255,255,128,0,0,15,208,64,3,251,239,208,0,0,15,255,208,3,235,215,240,0,22,255,255,224,15,203,211,248,107,255,255,255,224,31,203,209,243,255,255,255,228,0,63,75,208,131,255,254,95,208,0,191,11,208,2,249,0,15,208,0,189,11,208,0,0,0,15,208,0,60,11,208,0,0,0,15,208,0,36,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,0,11,208,0,0,0,15,208,0,
  // 0x659c  斜
  156,101,34,34,50,36,1,253,0,2,253,0,0,0,3,240,0,0,3,255,64,0,0,3,240,0,0,7,255,208,0,0,3,240,0,0,15,255,244,0,180,3,240,0,0,47,203,253,2,253,3,240,0,0,127,130,255,64,255,67,240,0,0,255,0,191,192,63,211,240,0,3,252,0,47,240,15,247,240,0,11,244,0,15,192,3,247,240,0,47,224,0,3,64,0,195,240,0,191,255,255,254,0,0,3,240,0,255,255,255,254,0,0,3,240,0,61,255,255,254,2,192,3,240,0,0,0,253,0,15,244,3,240,0,0,0,253,0,3,254,3,240,0,0,0,253,0,0,191,195,240,0,63,255,255,255,224,47,227,240,0,63,255,255,255,224,11,131,240,0,63,255,255,255,224,1,3,240,0,0,0,253,0,0,0,3,240,64,0,0,253,0,0,0,3,255,208,3,224,253,46,0,1,191,255,224,3,240,253,63,5,191,255,255,224,7,224,253,47,95,255,255,248,0,11,208,253,31,207,255,231,240,0,15,192,253,15,207,164,3,240,0,47,128,253,11,224,0,3,240,0,63,64,253,3,240,0,3,240,0,191,0,253,3,224,0,3,240,0,125,0,253,1,0,0,3,240,0,8,0,253,0,0,0,3,240,0,0,191,252,0,0,0,3,240,0,0,63,252,0,0,0,3,240,0,0,63,224,0,0,0,3,240,0,
  // 0x65ad  断
  173,101,32,35,24,36,3,252,0,0,104,0,0,0,0,64,168,0,188,0,0,0,11,224,248,16,188,0,0,2,255,248,248,244,188,63,41,191,255,228,248,248,188,62,63,255,249,0,248,124,188,124,63,249,0,0,248,60,188,188,63,64,0,0,248,61,188,244,63,64,0,0,248,61,189,240,63,64,0,0,248,16,188,16,63,64,0,0,248,0,188,0,63,64,0,0,249,255,255,255,63,64,0,0,249,255,255,255,63,255,255,254,249,255,255,254,63,255,255,254,248,1,252,0,63,255,255,254,248,3,255,0,63,64,63,0,248,7,255,192,63,64,63,0,248,15,255,240,63,64,63,0,248,31,254,252,63,64,63,0,248,62,188,190,63,0,63,0,248,252,188,60,63,0,63,0,255,248,188,0,63,0,63,0,255,240,188,0,127,0,63,0,249,192,188,0,126,0,63,0,248,0,188,0,190,0,63,0,248,0,188,0,253,0,63,0,248,0,20,1,252,0,63,0,255,255,255,255,252,0,63,0,255,255,255,255,244,0,63,0,255,255,255,255,240,0,63,0,248,0,0,31,208,0,63,0,248,0,0,63,192,0,63,0,248,0,0,31,64,0,63,0,0,0,0,10,0,0,63,0,0,0,0,0,0,0,0,0,
  // 0x65b0  新
  176,101,34,35,59,36,1,252,0,1,168,0,0,0,0,4,0,0,1,252,0,0,0,0,189,0,0,1,252,0,0,0,31,255,128,0,1,252,0,6,91,255,255,64,47,255,255,255,199,255,255,224,0,47,255,255,255,199,255,228,0,0,47,255,255,255,199,244,0,0,0,1,240,0,252,7,240,0,0,0,1,244,1,252,7,240,0,0,0,0,252,2,244,7,240,0,0,0,0,252,3,240,7,240,0,0,0,0,184,2,224,7,240,0,0,0,63,255,255,255,215,255,255,255,224,63,255,255,255,215,255,255,255,224,63,255,255,255,215,255,255,255,224,0,1,252,0,7,240,11,240,0,0,1,252,0,7,240,7,224,0,0,1,252,0,7,240,7,224,0,63,255,255,255,199,224,7,224,0,63,255,255,255,203,224,7,224,0,63,255,255,255,203,224,7,224,0,0,7,252,0,15,208,7,224,0,0,15,255,0,15,208,7,224,0,0,47,255,192,15,192,7,224,0,0,127,255,244,31,192,7,224,0,1,254,254,254,47,128,7,224,0,7,249,252,191,63,64,7,224,0,31,241,252,60,127,0,7,224,0,127,193,252,4,254,0,7,224,0,127,1,252,1,253,0,7,224,0,44,1,252,3,252,0,7,224,0,0,1,252,15,240,0,7,224,0,0,1,252,3,224,0,7,224,0,0,1,248,0,128,0,6,160,0,0,0,0,0,0,0,0,0,0,
  // 0x65b9  方
  185,101,32,35,24,36,2,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,11,244,0,0,0,0,0,0,7,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,15,240,0,0,0,0,0,0,15,255,255,255,255,0,0,0,15,255,255,255,255,0,0,0,31,255,255,255,254,0,0,0,31,208,0,0,254,0,0,0,47,192,0,0,254,0,0,0,63,128,0,0,254,0,0,0,127,64,0,0,253,0,0,0,255,0,0,0,253,0,0,0,255,0,0,0,253,0,0,2,253,0,0,1,252,0,0,7,252,0,0,1,252,0,0,15,244,0,0,2,252,0,0,63,224,0,0,3,248,0,0,255,192,0,0,3,248,0,3,255,0,0,0,7,244,0,47,253,0,0,0,15,240,0,255,244,0,3,255,255,224,0,191,192,0,3,255,255,192,0,45,0,0,2,255,254,0,0,0,0,0,0,0,0,0,0,
  // 0x65e0  无
  224,101,33,31,23,36,2,253,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,0,0,0,47,192,0,0,0,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,0,0,127,64,0,0,0,0,0,0,0,127,85,0,0,0,0,0,0,0,191,191,0,0,0,0,0,0,0,254,191,0,0,0,0,0,0,0,253,191,0,0,0,0,0,0,2,252,191,0,0,0,0,0,0,3,248,191,0,0,0,0,0,0,11,240,191,0,0,0,0,0,0,31,224,191,0,0,16,0,0,0,127,192,191,0,0,46,0,0,1,255,64,191,0,0,47,128,0,11,254,0,191,0,0,63,128,0,127,248,0,191,0,0,63,64,7,255,224,0,191,0,0,127,0,191,255,64,0,127,255,255,255,0,255,248,0,0,63,255,255,253,0,63,128,0,0,31,255,255,248,0,36,0,0,0,0,85,85,0,0,
  // 0x65f6  时
  246,101,32,34,16,36,3,253,0,0,0,0,0,0,169,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,254,0,255,255,253,0,0,0,254,0,255,255,253,0,0,0,254,0,255,255,253,0,0,0,254,0,252,0,189,0,0,0,254,0,252,0,189,63,255,255,255,254,252,0,189,63,255,255,255,254,252,0,189,63,255,255,255,254,252,0,189,21,85,85,254,84,252,0,189,0,0,0,254,0,252,0,189,0,0,0,254,0,255,255,253,2,192,0,254,0,255,255,253,15,224,0,254,0,255,255,253,7,244,0,254,0,252,0,189,3,252,0,254,0,252,0,189,0,254,0,254,0,252,0,189,0,191,64,254,0,252,0,189,0,63,192,254,0,252,0,189,0,31,224,254,0,252,0,189,0,15,240,254,0,252,0,189,0,7,64,254,0,252,0,189,0,0,0,254,0,255,255,253,0,0,0,254,0,255,255,253,0,0,0,254,0,255,255,253,0,0,0,254,0,252,0,0,0,0,0,254,0,252,0,0,0,0,0,254,0,252,0,0,0,0,0,254,0,0,0,0,0,47,255,253,0,0,0,0,0,31,255,252,0,0,0,0,0,15,255,224,0,0,0,0,0,5,80,0,0,
  // 0x660e  明
  14,102,31,33,8,36,3,252,255,255,255,3,255,255,255,244,255,255,255,3,255,255,255,244,255,255,255,3,255,255,255,244,252,0,127,3,240,0,3,244,252,0,63,3,240,0,3,244,252,0,63,3,240,0,3,244,252,0,63,3,240,0,3,244,252,0,63,3,240,0,3,244,252,0,63,3,255,255,255,244,252,0,63,3,255,255,255,244,255,255,255,3,255,255,255,244,255,255,255,3,240,0,3,244,255,255,255,3,240,0,3,244,252,0,63,3,240,0,3,244,252,0,63,7,240,0,3,244,252,0,63,7,240,0,3,244,252,0,63,7,240,0,3,244,252,0,63,7,255,255,255,244,252,0,63,11,255,255,255,244,255,255,255,15,255,255,255,244,255,255,255,15,208,0,3,244,255,255,255,15,192,0,3,244,252,0,0,47,192,0,3,244,252,0,0,63,128,0,3,244,252,0,0,127,0,0,3,244,84,0,0,255,0,0,3,244,0,0,2,253,0,0,3,244,0,0,7,252,0,0,3,244,0,0,15,240,0,0,7,244,0,0,127,224,0,31,255,240,0,0,127,128,0,15,255,240,0,0,14,0,0,11,254,64,0,0,0,0,0,0,0,0,
  // 0x662f  是
  47,102,34,33,41,36,1,253,0,21,85,85,85,85,85,64,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,85,85,85,85,111,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,63,0,0,0,0,31,192,0,0,63,0,0,0,0,31,192,0,0,63,149,85,85,85,111,192,0,0,63,255,255,255,255,255,192,0,0,63,255,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,0,0,0,1,252,0,0,0,0,0,3,144,1,252,0,0,0,0,0,7,244,1,252,0,0,0,0,0,11,240,1,252,0,0,0,0,0,15,240,1,255,255,255,244,0,0,15,224,1,255,255,255,244,0,0,47,240,1,255,255,255,244,0,0,63,252,1,252,0,0,0,0,0,191,255,1,252,0,0,0,0,1,254,127,209,252,0,0,0,0,7,252,31,255,252,0,0,0,0,31,240,7,255,255,255,255,255,208,127,208,0,127,255,255,255,255,192,47,64,0,1,191,255,255,255,128,9,0,0,0,0,0,0,0,0,
  // 0x6682  暂
  130,102,32,34,16,36,2,253,0,14,64,0,0,0,0,16,0,31,208,0,0,0,91,244,170,191,234,170,70,191,255,252,255,255,255,255,139,255,255,228,255,255,255,255,139,250,80,0,3,248,0,0,11,192,0,0,7,240,189,0,11,192,0,0,31,192,189,0,11,192,0,0,127,234,255,170,79,234,170,170,127,255,255,255,207,255,255,255,63,255,255,255,207,255,255,255,16,0,189,0,15,192,63,0,0,0,189,0,15,192,63,0,0,5,255,255,95,128,63,0,191,255,255,255,111,64,63,0,255,255,255,169,63,0,63,0,190,149,189,0,191,0,63,0,0,0,189,0,253,0,63,0,0,0,189,0,60,0,63,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,255,170,170,170,170,255,0,0,253,0,0,0,0,127,0,0,253,0,0,0,0,127,0,0,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,254,85,85,85,85,191,0,0,253,0,0,0,0,127,0,0,253,0,0,0,0,127,0,0,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,255,170,170,170,170,255,0,0,189,0,0,0,0,127,0,
  // 0x66ab  暫
  171,102,32,34,16,36,2,253,0,3,240,0,0,0,1,128,0,3,240,0,0,1,111,240,191,255,255,255,95,191,255,248,191,255,255,255,95,255,254,64,0,3,240,0,31,249,0,0,26,171,250,169,31,128,0,0,63,255,255,254,31,128,0,0,62,3,240,62,31,128,0,0,62,3,240,62,31,255,255,255,63,255,255,254,31,255,255,255,63,171,250,190,31,234,191,170,62,3,240,62,47,64,63,0,63,255,255,254,63,0,63,0,26,171,250,169,63,0,63,0,0,3,240,0,190,0,63,0,255,255,255,255,253,0,63,0,255,255,255,255,248,0,63,0,0,3,240,11,240,0,63,0,0,3,240,2,208,0,63,0,0,1,64,0,64,0,0,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,170,170,170,170,252,0,0,63,0,0,0,0,252,0,0,63,0,0,0,0,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,85,85,85,85,252,0,0,63,0,0,0,0,252,0,0,63,0,0,0,0,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,170,170,170,170,252,0,0,63,0,0,0,0,252,0,
  // 0x66f4  更
  244,102,33,33,41,36,2,252,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,1,254,170,175,250,170,175,208,0,1,252,0,7,240,0,15,208,0,1,252,0,7,240,0,15,208,0,1,254,170,175,250,170,175,208,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,1,252,0,7,240,0,15,208,0,1,252,0,7,240,0,15,208,0,1,252,0,11,240,0,15,208,0,1,254,170,175,250,170,175,208,0,1,255,255,255,255,255,255,208,0,1,255,255,255,255,255,255,208,0,0,6,0,15,208,0,0,0,0,0,127,64,47,192,0,0,0,0,0,63,208,63,128,0,0,0,0,0,15,244,255,64,0,0,0,0,0,7,255,255,0,0,0,0,0,0,1,255,252,0,0,0,0,0,0,0,191,253,0,0,0,0,0,0,11,255,255,249,0,0,0,0,6,255,255,255,255,255,169,85,0,255,255,244,27,255,255,255,255,64,127,254,0,0,107,255,255,255,0,47,144,0,0,0,21,175,254,0,0,0,0,0,0,0,0,0,0,
  // 0x6700  最
  0,103,32,33,8,36,2,253,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,190,85,85,85,85,254,0,0,190,0,0,0,0,190,0,0,190,0,0,0,0,190,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,190,0,0,0,0,190,0,0,190,0,0,0,0,190,0,0,191,255,255,255,255,254,0,0,191,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,254,171,254,171,255,170,170,170,170,3,240,0,252,0,0,0,0,3,240,0,252,0,0,0,0,3,255,255,252,255,255,255,244,3,255,255,252,255,255,255,244,3,249,85,252,107,234,175,240,3,240,0,252,31,192,15,208,3,249,85,252,15,208,47,192,3,255,255,252,7,240,127,128,3,255,255,252,2,252,255,0,3,240,0,252,0,255,252,0,3,240,0,252,0,127,244,0,3,250,191,252,0,127,240,0,255,255,255,252,7,255,254,0,255,255,255,252,127,253,255,228,254,148,0,255,255,224,47,255,0,0,0,252,254,0,7,254,0,0,0,252,96,0,0,44,
  // 0x6709  有
  9,103,33,35,59,36,1,252,0,0,0,100,0,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,2,252,0,0,0,0,0,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,47,255,255,255,255,255,255,255,128,0,0,31,208,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,2,255,255,255,255,255,128,0,0,7,255,255,255,255,255,128,0,0,15,255,255,255,255,255,128,0,0,63,253,0,0,0,47,128,0,0,255,253,0,0,0,47,128,0,3,255,253,0,0,0,47,128,0,31,252,255,255,255,255,255,128,0,127,240,255,255,255,255,255,128,0,63,128,255,255,255,255,255,128,0,14,0,253,0,0,0,47,128,0,0,0,253,0,0,0,47,128,0,0,0,253,0,0,0,47,128,0,0,0,255,255,255,255,255,128,0,0,0,255,255,255,255,255,128,0,0,0,255,255,255,255,255,128,0,0,0,253,0,0,0,47,128,0,0,0,253,0,0,0,47,128,0,0,0,253,0,0,0,47,128,0,0,0,253,0,0,0,63,128,0,0,0,253,0,0,255,255,64,0,0,0,253,0,0,191,255,0,0,0,0,253,0,0,127,248,0,0,0,0,0,0,0,0,0,0,0,
  // 0x671f  期
  31,103,33,34,50,36,1,252,0,252,0,190,0,0,0,0,0,0,252,0,190,1,255,255,255,64,0,252,0,190,1,255,255,255,64,0,252,0,190,1,255,255,255,64,63,255,255,255,241,252,0,63,64,63,255,255,255,241,252,0,63,64,63,255,255,255,241,252,0,63,64,0,252,0,190,1,252,0,63,64,0,252,0,190,1,252,0,63,64,0,254,170,254,1,255,255,255,64,0,255,255,254,1,255,255,255,64,0,255,255,254,1,255,255,255,64,0,252,0,190,1,252,0,63,64,0,252,0,190,1,252,0,63,64,0,252,0,190,1,252,0,63,64,0,254,170,254,1,252,0,63,64,0,255,255,254,1,248,0,63,64,0,255,255,254,1,248,0,63,64,0,252,0,190,1,255,255,255,64,0,252,0,190,2,255,255,255,64,0,252,0,190,2,255,255,255,64,127,255,255,255,242,244,0,63,64,191,255,255,255,243,244,0,63,64,191,255,255,255,243,240,0,63,64,0,16,0,64,3,240,0,63,64,0,126,2,224,7,240,0,63,64,0,255,7,244,11,224,0,63,64,2,252,2,253,15,208,0,63,64,7,248,0,255,31,192,0,63,64,31,240,0,63,175,192,0,63,64,63,208,0,47,127,128,127,255,0,47,64,0,4,63,0,63,255,0,10,0,0,0,10,0,47,248,0,0,0,0,0,0,0,0,0,0,
  // 0x673a  机
  58,103,34,35,59,36,1,252,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,127,255,255,192,0,0,7,240,0,127,255,255,192,0,0,7,240,0,127,255,255,192,0,0,7,240,0,127,0,31,192,0,0,7,240,0,127,0,15,192,0,0,7,240,0,127,0,15,192,0,63,255,255,252,127,0,15,192,0,63,255,255,252,127,0,15,192,0,63,255,255,252,127,0,15,192,0,0,15,240,0,127,0,15,192,0,0,31,240,0,127,0,15,192,0,0,47,240,0,127,0,15,192,0,0,63,244,0,127,0,15,192,0,0,63,252,0,127,0,15,192,0,0,191,255,0,127,0,15,192,0,0,255,255,192,127,0,15,192,0,1,251,255,224,127,0,15,192,0,3,247,243,248,190,0,15,192,0,7,215,241,252,190,0,15,192,0,15,199,240,240,253,0,15,192,0,47,135,240,32,253,0,15,192,0,63,71,240,0,252,0,15,192,0,254,7,240,1,252,0,15,192,64,124,7,240,2,248,0,15,193,224,56,7,240,3,244,0,15,193,240,16,7,240,7,240,0,15,193,240,0,7,240,15,224,0,15,193,240,0,7,240,31,208,0,15,193,240,0,7,240,63,192,0,15,210,240,0,7,240,255,0,0,15,255,240,0,7,240,254,0,0,15,255,208,0,7,240,40,0,0,2,255,128,0,1,64,0,0,0,0,0,0,
  // 0x6740  杀
  64,103,32,34,16,36,2,253,0,0,0,0,0,0,160,0,0,100,0,0,0,3,253,0,1,255,64,0,0,31,252,0,2,255,248,0,0,191,240,0,0,31,255,144,7,255,128,0,0,1,255,253,63,253,0,0,0,0,31,255,255,224,0,0,0,0,0,255,255,64,0,0,0,0,2,255,255,224,0,0,0,0,111,255,255,253,0,0,0,7,255,248,15,255,208,0,1,191,255,128,1,255,253,0,111,255,248,0,0,31,255,128,127,255,64,0,0,1,255,192,31,224,0,11,240,0,47,0,5,0,0,11,240,0,4,0,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,254,255,255,255,255,255,255,255,254,0,0,0,11,240,0,0,0,0,1,0,11,240,0,0,0,0,7,224,11,240,11,192,0,0,31,240,11,240,31,240,0,0,63,192,11,240,7,253,0,0,255,0,11,240,1,255,64,7,253,0,11,240,0,63,208,31,244,0,11,240,0,15,244,191,208,0,11,240,0,3,253,255,64,0,15,240,0,1,254,61,0,15,255,224,0,0,116,0,0,11,255,208,0,0,0,0,0,7,254,64,0,0,0,
  // 0x675f  束
  95,103,33,34,50,36,2,253,0,0,0,11,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,63,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,253,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,3,244,0,15,224,0,31,192,0,3,244,0,15,224,0,31,192,0,3,244,0,15,224,0,31,192,0,3,244,0,15,224,0,31,192,0,3,244,0,15,224,0,31,192,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,0,0,0,255,255,0,0,0,0,0,0,3,255,255,192,0,0,0,0,0,15,255,255,240,0,0,0,0,0,127,223,231,253,0,0,0,0,2,255,79,225,255,128,0,0,0,31,253,15,224,127,244,0,0,0,191,244,15,224,31,255,0,0,11,255,192,15,224,3,255,224,0,191,254,0,15,224,0,191,255,64,255,240,0,15,224,0,15,255,0,63,64,0,15,224,0,1,252,0,20,0,0,15,224,0,0,40,0,0,0,0,11,224,0,0,0,0,
  // 0x6761  条
  97,103,34,34,50,36,1,253,0,0,0,249,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,7,248,0,0,0,0,0,0,0,31,255,255,255,224,0,0,0,0,127,255,255,255,252,0,0,0,2,255,255,255,255,248,0,0,0,11,255,0,0,31,240,0,0,0,127,255,192,0,127,192,0,0,3,255,223,244,1,255,64,0,0,15,254,3,254,11,253,0,0,0,3,244,0,255,255,244,0,0,0,0,64,0,47,255,192,0,0,0,0,0,0,47,255,208,0,0,0,0,0,7,255,255,255,64,0,0,0,1,191,255,91,255,254,64,0,1,191,255,244,0,191,255,255,128,47,255,254,65,84,6,255,255,128,15,255,144,3,248,0,6,255,0,11,164,0,3,248,0,0,5,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,0,255,255,240,0,0,0,0,0,3,255,255,252,0,0,0,0,0,31,243,249,255,64,0,0,0,0,191,195,248,127,224,0,0,0,7,255,3,248,15,253,0,0,0,127,252,3,248,3,255,208,0,7,255,224,3,248,0,191,254,0,127,255,0,3,248,0,15,255,208,47,244,0,3,248,0,1,255,128,15,64,0,3,248,0,0,31,0,0,0,0,2,248,0,0,0,0,
  // 0x6765  来
  101,103,34,34,50,36,1,253,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,3,255,255,255,255,255,255,253,0,3,255,255,255,255,255,255,253,0,3,255,255,255,255,255,255,253,0,0,0,64,3,252,0,20,0,0,0,11,192,3,248,0,47,128,0,0,15,208,3,248,0,63,192,0,0,11,240,3,248,0,127,64,0,0,3,248,3,248,0,255,0,0,0,2,252,3,248,1,253,0,0,0,1,253,3,248,3,248,0,0,0,0,253,3,248,7,240,0,0,0,0,80,3,248,1,160,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,0,127,255,208,0,0,0,0,0,0,255,255,240,0,0,0,0,0,3,255,255,252,0,0,0,0,0,11,247,249,254,0,0,0,0,0,63,211,248,127,192,0,0,0,0,255,131,248,47,240,0,0,0,3,254,3,248,11,252,0,0,0,47,248,3,248,2,255,64,0,0,255,224,3,248,0,191,240,0,11,255,64,3,248,0,47,254,0,127,253,0,3,248,0,7,255,208,63,224,0,3,248,0,0,255,192,15,64,0,3,248,0,0,31,0,0,0,0,3,248,0,0,1,0,0,0,0,3,248,0,0,0,0,
  // 0x677f  板
  127,103,34,35,59,36,1,252,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,2,255,255,255,255,192,0,15,192,2,255,255,255,255,192,0,15,192,2,255,255,255,255,192,0,15,192,2,248,0,0,0,0,0,15,192,2,244,0,0,0,0,0,15,192,2,244,0,0,0,0,63,255,255,226,244,0,0,0,0,63,255,255,226,244,0,0,0,0,63,255,255,226,244,0,0,0,0,0,31,192,2,248,0,0,0,0,0,47,192,2,255,255,255,255,64,0,63,192,3,255,255,255,255,64,0,127,224,3,255,255,255,255,0,0,191,244,3,255,208,0,127,0,0,255,252,3,255,224,0,190,0,1,255,255,3,247,240,0,253,0,2,255,239,131,242,244,1,252,0,3,223,207,211,241,252,2,248,0,11,207,199,243,240,253,3,244,0,15,143,194,199,240,191,11,240,0,63,79,192,71,224,63,95,208,0,127,15,192,11,224,47,255,192,0,253,15,192,15,208,15,255,64,0,60,15,192,31,192,7,254,0,0,36,15,192,47,192,3,253,0,0,0,15,192,63,128,15,255,64,0,0,15,192,127,0,127,255,208,0,0,15,192,191,1,255,159,248,0,0,15,193,253,31,253,7,255,128,0,15,195,252,63,244,1,255,224,0,15,193,244,31,128,0,63,128,0,15,192,32,9,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x6797  林
  151,103,34,34,50,36,1,253,0,3,244,0,0,3,240,0,0,0,3,244,0,0,3,240,0,0,0,3,244,0,0,3,240,0,0,0,3,244,0,0,3,240,0,0,0,3,244,0,0,3,240,0,0,0,3,244,0,0,3,240,0,0,0,3,244,0,0,3,240,0,0,0,3,244,0,0,7,244,0,0,63,255,255,253,127,255,255,255,192,63,255,255,253,127,255,255,255,192,63,255,255,253,127,255,255,255,192,0,11,244,0,0,15,252,0,0,0,15,252,0,0,31,253,0,0,0,15,255,0,0,47,255,0,0,0,47,255,192,0,63,255,0,0,0,63,255,224,0,127,255,128,0,0,127,251,248,0,255,255,192,0,0,255,246,253,1,255,255,208,0,1,251,244,255,3,247,247,240,0,3,243,244,60,7,243,243,244,0,7,243,244,36,15,211,241,252,0,15,211,244,0,47,195,240,253,0,47,195,244,0,127,67,240,191,0,127,67,244,0,255,3,240,63,128,191,3,244,3,252,3,240,47,208,61,3,244,11,248,3,240,15,224,40,3,244,7,240,3,240,11,128,0,3,244,2,192,3,240,2,0,0,3,244,0,0,3,240,0,0,0,3,244,0,0,3,240,0,0,0,3,244,0,0,3,240,0,0,0,3,244,0,0,3,240,0,0,0,3,244,0,0,3,240,0,0,0,3,244,0,0,3,240,0,0,
  // 0x67f1  柱
  241,103,34,35,59,36,1,252,0,11,224,0,0,176,0,0,0,0,11,224,0,3,253,0,0,0,0,11,224,0,2,255,128,0,0,0,11,224,0,0,127,240,0,0,0,11,224,0,0,15,252,0,0,0,11,224,0,0,2,253,0,0,0,11,224,0,0,0,244,0,0,0,11,224,3,255,255,255,255,192,63,255,255,247,255,255,255,255,192,63,255,255,247,255,255,255,255,192,63,255,255,244,0,11,240,0,0,0,15,224,0,0,11,240,0,0,0,31,224,0,0,11,240,0,0,0,47,224,0,0,11,240,0,0,0,63,244,0,0,11,240,0,0,0,127,252,0,0,11,240,0,0,0,255,255,0,0,11,240,0,0,0,255,255,192,0,11,240,0,0,2,251,239,224,255,255,255,255,128,3,235,227,244,255,255,255,255,128,11,219,226,244,255,255,255,255,128,15,203,224,224,0,11,240,0,0,47,139,224,64,0,11,240,0,0,127,11,224,0,0,11,240,0,0,190,11,224,0,0,11,240,0,0,60,11,224,0,0,11,240,0,0,36,11,224,0,0,11,240,0,0,0,11,224,0,0,11,240,0,0,0,11,224,0,0,11,240,0,0,0,11,224,0,0,11,240,0,0,0,11,224,63,255,255,255,255,224,0,11,224,63,255,255,255,255,224,0,11,224,63,255,255,255,255,224,0,11,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6821  校
  33,104,34,35,59,36,1,252,0,15,192,0,0,31,192,0,0,0,15,192,0,0,31,192,0,0,0,15,192,0,0,31,192,0,0,0,15,192,0,0,31,192,0,0,0,15,192,0,0,31,192,0,0,0,15,192,31,255,255,255,255,192,0,15,192,31,255,255,255,255,192,0,15,192,31,255,255,255,255,192,63,255,255,218,170,170,170,170,128,63,255,255,192,4,0,1,0,0,63,255,255,192,47,64,15,192,0,0,47,192,0,63,128,15,240,0,0,63,192,0,191,0,7,248,0,0,63,192,1,253,0,1,253,0,0,127,240,3,248,0,0,191,0,0,191,244,15,240,0,0,63,192,0,255,252,63,235,0,15,159,208,1,255,255,47,127,64,31,203,192,3,255,223,73,31,192,63,129,0,7,239,207,192,15,192,63,64,0,11,207,199,208,11,240,191,0,0,15,143,195,128,3,244,253,0,0,63,79,193,0,2,255,252,0,0,127,15,192,0,0,255,244,0,0,189,15,192,0,0,127,224,0,0,60,15,192,0,0,63,224,0,0,36,15,192,0,0,255,248,0,0,0,15,192,0,7,255,255,0,0,0,15,192,0,31,245,255,192,0,0,15,192,1,255,208,63,248,0,0,15,192,27,255,0,15,255,128,0,15,192,191,248,0,3,255,208,0,15,192,63,208,0,0,127,128,0,15,192,45,0,0,0,11,0,0,0,0,0,0,0,0,0,0,
  // 0x683c  格
  60,104,34,35,59,36,1,252,0,15,192,0,1,224,0,0,0,0,15,192,0,3,248,0,0,0,0,15,192,0,7,244,0,0,0,0,15,192,0,15,240,0,0,0,0,15,192,0,31,255,255,244,0,0,15,192,0,63,255,255,252,0,0,15,192,0,191,255,255,244,0,0,15,192,1,255,0,7,240,0,63,255,255,231,255,64,15,224,0,63,255,255,239,255,192,47,192,0,63,255,255,255,223,224,127,64,0,0,31,192,191,71,248,254,0,0,0,47,208,29,2,255,252,0,0,0,63,244,0,0,191,240,0,0,0,127,252,0,0,127,240,0,0,0,191,255,0,2,255,253,0,0,0,255,239,192,15,255,255,128,0,1,255,207,208,191,240,127,248,0,3,239,195,203,255,128,31,255,208,7,223,194,255,253,0,2,255,224,15,207,192,255,255,255,255,255,128,31,143,192,126,255,255,255,253,0,63,15,192,17,255,255,255,252,0,191,15,192,1,248,0,1,252,0,189,15,192,1,248,0,1,252,0,60,15,192,1,248,0,1,252,0,36,15,192,1,248,0,1,252,0,0,15,192,1,248,0,1,252,0,0,15,192,1,248,0,1,252,0,0,15,192,1,248,0,1,252,0,0,15,192,1,255,255,255,252,0,0,15,192,1,255,255,255,252,0,0,15,192,1,255,255,255,252,0,0,15,192,1,248,0,1,252,0,0,0,0,0,0,0,0,0,0,
  // 0x68af  梯
  175,104,33,34,50,36,1,253,0,15,192,0,24,0,2,144,0,0,15,192,0,252,0,3,248,0,0,15,192,0,190,0,7,240,0,0,15,192,0,63,0,15,224,0,0,15,192,0,63,128,31,192,0,0,15,192,0,31,64,31,64,0,0,15,192,15,255,255,255,255,0,0,15,192,15,255,255,255,255,0,63,255,255,207,255,255,255,255,0,63,255,255,192,0,47,64,63,0,63,255,255,192,0,47,64,63,0,0,47,192,0,0,47,64,63,0,0,63,192,0,0,47,64,63,0,0,63,208,7,255,255,255,255,0,0,127,240,11,255,255,255,255,0,0,255,248,11,255,255,255,255,0,0,255,253,15,192,47,64,0,0,2,255,239,15,192,47,64,0,0,3,255,207,223,192,47,64,0,0,7,223,203,239,255,255,255,255,192,15,207,195,111,255,255,255,255,192,31,143,192,63,255,255,255,255,192,63,15,192,63,0,255,64,15,192,190,15,192,0,3,255,64,31,192,124,15,192,0,11,255,64,31,192,56,15,192,0,47,255,64,31,128,16,15,192,0,255,111,64,47,128,0,15,192,3,253,47,64,63,64,0,15,192,31,244,47,95,255,0,0,15,193,255,224,47,79,255,0,0,15,193,255,64,47,79,248,0,0,15,192,124,0,47,64,0,0,0,15,192,16,0,47,64,0,0,0,15,192,0,0,47,64,0,0,
  // 0x68c0  检
  192,104,34,34,50,36,1,253,0,47,64,0,0,61,0,0,0,0,63,64,0,0,255,0,0,0,0,63,64,0,1,254,0,0,0,0,63,64,0,3,255,128,0,0,0,63,64,0,11,255,208,0,0,0,63,64,0,47,219,244,0,0,0,63,64,0,127,66,254,0,0,63,255,254,1,254,0,255,128,0,63,255,254,7,252,0,63,240,0,63,255,254,31,240,0,11,253,0,0,63,64,127,192,0,2,255,192,0,127,66,255,255,255,255,191,224,0,191,203,253,255,255,255,15,192,0,255,227,240,255,255,255,2,64,0,255,245,128,0,0,0,0,0,2,255,252,0,0,0,0,0,0,3,255,190,0,0,0,0,16,0,3,255,127,6,0,188,0,126,0,11,255,94,47,0,188,0,253,0,15,191,72,31,128,125,0,252,0,47,127,64,15,192,125,1,244,0,63,63,64,11,192,62,3,240,0,190,63,64,7,208,63,3,224,0,60,63,64,3,224,63,11,192,0,40,63,64,3,240,47,15,192,0,16,63,64,3,240,26,47,64,0,0,63,64,1,64,0,63,0,0,0,63,64,0,0,0,125,0,0,0,63,64,0,0,0,252,0,0,0,63,66,255,255,255,255,255,128,0,63,66,255,255,255,255,255,128,0,63,66,255,255,255,255,255,128,0,63,64,0,0,0,0,0,0,0,47,0,0,0,0,0,0,0,
  // 0x69fd  槽
  253,105,34,35,59,36,1,252,0,47,64,0,11,208,252,0,0,0,47,64,0,11,208,252,0,0,0,47,64,0,11,208,252,0,0,0,47,64,255,255,255,255,255,224,0,47,64,255,255,255,255,255,224,0,47,64,170,175,250,254,170,144,0,47,64,0,11,208,252,0,0,0,47,128,5,91,229,253,85,0,63,255,255,47,255,255,255,255,64,63,255,255,47,255,255,255,255,64,63,255,255,47,3,208,248,31,64,0,63,64,47,3,208,248,31,64,0,63,64,47,255,255,255,255,64,0,127,128,47,255,255,255,255,64,0,191,192,47,7,208,248,31,64,0,255,240,47,3,208,248,31,64,1,255,244,47,3,208,248,31,64,2,255,252,47,255,255,255,255,64,3,255,190,47,255,255,255,255,64,7,239,111,69,85,85,85,85,0,15,239,79,0,0,0,0,0,0,31,111,73,7,255,255,255,252,0,63,47,64,7,255,255,255,252,0,126,47,64,7,250,170,170,252,0,188,47,64,7,240,0,0,252,0,56,47,64,7,245,85,85,252,0,32,47,64,7,255,255,255,252,0,0,47,64,7,255,255,255,252,0,0,47,64,7,240,0,0,252,0,0,47,64,7,240,0,0,252,0,0,47,64,7,250,170,170,252,0,0,47,64,7,255,255,255,252,0,0,47,64,7,255,255,255,252,0,0,47,64,7,240,0,0,252,0,0,0,0,0,0,0,0,0,0,
  // 0x6a21  模
  33,106,34,35,59,36,1,252,0,63,0,0,63,0,63,64,0,0,63,0,0,63,0,63,64,0,0,63,0,0,63,0,63,64,0,0,63,0,255,255,255,255,255,192,0,63,0,255,255,255,255,255,192,0,63,0,191,255,255,255,255,128,0,63,0,0,63,0,63,64,0,63,255,254,0,63,0,63,64,0,63,255,254,0,21,0,21,0,0,63,255,254,47,255,255,255,252,0,0,63,84,47,255,255,255,252,0,0,63,64,47,213,85,86,252,0,0,127,128,47,128,0,0,252,0,0,191,208,47,149,85,85,252,0,0,255,240,47,255,255,255,252,0,1,255,248,47,255,255,255,252,0,2,255,253,47,128,0,0,252,0,3,255,127,47,128,0,0,252,0,7,255,47,111,255,255,255,252,0,15,255,14,47,255,255,255,252,0,15,191,8,5,85,191,85,84,0,47,63,0,0,0,190,0,0,0,127,63,0,0,0,254,0,0,0,189,63,1,255,255,255,255,255,128,124,63,1,255,255,255,255,255,192,56,63,1,255,255,255,255,255,192,16,63,0,0,7,255,240,0,0,0,63,0,0,15,243,252,0,0,0,63,0,0,63,208,255,0,0,0,63,0,2,255,128,127,224,0,0,63,0,111,254,0,31,254,64,0,63,7,255,244,0,7,255,208,0,63,2,255,64,0,0,191,128,0,63,0,228,0,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x6a59  橙
  89,106,34,34,50,36,1,253,0,31,192,0,0,0,80,0,0,0,31,192,26,170,130,240,32,0,0,31,192,47,255,241,244,244,0,0,31,192,47,255,224,255,252,0,0,31,192,0,15,192,255,224,0,0,31,192,4,15,192,191,66,0,0,31,192,62,47,128,63,11,192,0,31,192,127,255,0,47,175,192,63,255,255,159,254,0,31,254,0,63,255,255,131,253,0,15,244,0,63,255,255,131,255,255,255,252,0,0,47,192,15,239,255,254,255,0,0,63,192,47,202,170,168,191,208,0,63,192,255,0,0,0,47,240,0,191,226,253,0,0,0,11,192,0,255,244,179,255,255,255,249,64,0,255,252,3,255,255,255,248,0,2,255,255,3,245,85,87,248,0,3,255,223,131,240,0,2,248,0,7,239,207,195,240,0,2,248,0,15,223,199,67,240,0,2,248,0,15,159,194,3,250,170,171,248,0,63,31,192,3,255,255,255,248,0,127,31,192,3,255,255,255,248,0,189,31,192,0,8,0,14,64,0,60,31,192,0,189,0,31,192,0,36,31,192,0,127,0,47,128,0,0,31,192,0,63,0,63,0,0,0,31,192,0,47,64,126,0,0,0,31,192,0,30,0,124,0,0,0,31,192,255,255,255,255,255,224,0,31,192,255,255,255,255,255,224,0,31,192,255,255,255,255,255,208,0,31,192,0,0,0,0,0,0,
  // 0x6b62  止
  98,107,32,32,0,36,2,255,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,0,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,255,255,255,244,0,127,0,1,255,255,255,244,0,127,0,1,255,255,255,244,0,127,0,1,253,85,85,80,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,0,127,0,1,252,0,0,0,85,191,85,86,253,85,85,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x6b63  正
  99,107,32,31,248,36,2,254,5,85,85,85,85,85,85,84,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,248,0,0,0,0,106,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,255,255,255,208,0,127,0,3,255,255,255,208,0,127,0,3,255,255,255,208,0,127,0,3,252,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,0,127,0,3,248,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
  // 0x6b65  步
  101,107,32,34,16,36,2,253,0,0,0,11,240,0,0,0,0,0,0,11,240,0,0,0,0,21,0,11,240,0,0,0,0,63,128,11,240,0,0,0,0,63,128,11,255,255,255,64,0,63,128,11,255,255,255,64,0,63,128,11,255,255,255,64,0,63,128,11,240,0,0,0,0,63,128,11,240,0,0,0,0,63,128,11,240,0,0,0,0,63,128,11,240,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,11,224,0,0,0,0,7,144,11,224,0,0,0,0,15,244,11,224,0,57,0,0,63,224,11,224,0,191,64,0,255,128,11,224,0,255,0,3,255,0,11,224,2,253,0,31,252,0,11,224,3,252,0,191,224,0,11,224,15,244,0,127,128,15,255,224,47,240,0,13,0,11,255,208,191,192,0,0,0,7,254,66,255,64,0,0,0,0,0,15,253,0,0,0,0,0,0,191,244,0,0,0,0,0,7,255,208,0,0,0,0,1,191,255,0,0,0,0,1,111,255,244,0,0,0,2,191,255,255,64,0,0,0,3,255,255,228,0,0,0,0,1,255,249,0,0,0,0,0,0,233,0,0,0,0,0,0,
  // 0x6bd4  比
  212,107,34,34,50,36,1,253,0,42,64,0,6,160,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,40,0,0,63,128,0,7,240,1,254,0,0,63,128,0,7,240,11,255,64,0,63,255,255,7,240,191,253,0,0,63,255,255,7,251,255,224,0,0,63,255,255,7,255,254,0,0,0,63,149,85,7,255,208,0,0,0,63,128,0,7,253,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,0,0,0,63,128,0,7,240,0,7,128,0,63,128,0,7,240,0,7,240,0,63,128,6,199,240,0,7,224,0,63,150,255,199,240,0,11,224,0,63,255,255,215,240,0,15,208,43,255,255,255,135,244,0,31,208,127,255,255,144,3,255,255,255,192,63,255,144,0,2,255,255,255,128,46,64,0,0,0,191,255,254,0,0,0,0,0,0,0,0,0,0,
  // 0x6ca1  没
  161,108,34,35,59,36,1,252,0,144,0,0,0,0,0,0,0,3,253,0,11,255,255,253,0,0,7,255,192,11,255,255,253,0,0,0,191,244,11,255,255,253,0,0,0,15,244,11,224,0,253,0,0,0,2,224,11,224,0,253,0,0,0,0,64,15,208,0,253,0,0,0,0,0,15,208,0,253,3,64,0,0,0,15,192,0,253,3,224,0,0,0,47,192,0,253,3,224,30,0,0,127,128,0,253,7,208,63,224,0,255,0,0,255,255,208,127,253,7,254,0,0,127,255,192,11,255,143,248,0,0,47,254,0,0,191,67,224,0,0,0,0,0,0,30,0,64,0,0,0,0,0,0,0,2,255,255,255,255,244,0,0,0,2,255,255,255,255,248,0,0,0,2,255,255,255,255,244,0,0,0,0,6,208,0,15,240,0,0,2,208,15,240,0,47,208,0,0,3,244,3,244,0,63,192,0,0,11,240,2,252,0,255,0,0,0,15,224,0,255,3,254,0,0,0,47,192,0,127,207,252,0,0,0,63,128,0,31,255,240,0,0,0,191,0,0,11,255,192,0,0,0,254,0,0,31,255,208,0,0,3,252,0,1,255,255,252,0,0,7,248,0,31,255,239,255,208,0,15,240,27,255,254,2,255,255,128,15,224,63,255,224,0,47,255,208,2,192,31,249,0,0,2,255,128,0,0,14,64,0,0,0,27,0,0,0,0,0,0,0,0,0,0,
  // 0x6ce2  波
  226,108,34,35,59,36,1,252,0,64,0,0,0,253,0,0,0,2,244,0,0,0,253,0,0,0,7,255,64,0,0,253,0,0,0,1,255,224,0,0,253,0,0,0,0,47,240,0,0,253,0,0,0,0,7,209,255,255,255,255,255,128,0,0,129,255,255,255,255,255,192,0,0,1,255,255,255,255,255,128,0,0,1,252,0,254,0,63,64,0,0,1,252,0,253,0,127,0,13,0,1,252,0,253,0,190,0,63,208,1,252,0,253,0,252,0,127,252,1,252,0,253,0,120,0,11,255,65,252,0,253,0,0,0,1,255,1,255,255,255,255,244,0,0,45,1,255,255,255,255,252,0,0,0,1,255,255,255,255,248,0,0,0,1,254,248,0,3,244,0,0,0,1,252,252,0,11,240,0,0,0,1,248,190,0,15,208,0,0,7,66,248,63,0,47,192,0,0,15,210,248,47,192,63,128,0,0,31,195,244,15,224,255,0,0,0,63,195,240,11,246,253,0,0,0,63,67,240,3,255,252,0,0,0,191,11,240,0,255,240,0,0,0,253,15,224,0,191,224,0,0,2,252,15,208,2,255,248,0,0,3,248,31,192,15,255,255,64,0,11,240,63,128,191,245,255,228,0,31,224,127,91,255,192,63,255,64,47,192,254,63,254,0,11,255,208,7,128,188,31,224,0,0,191,64,0,0,24,10,0,0,0,10,0,0,0,0,0,0,0,0,0,0,
  // 0x6ce8  注
  232,108,34,34,50,36,1,253,0,128,0,0,40,0,0,0,0,1,253,0,0,127,128,0,0,0,3,255,192,0,255,244,0,0,0,1,255,244,0,47,254,0,0,0,0,31,252,0,7,255,192,0,0,0,2,244,0,0,191,240,0,0,0,0,80,0,0,31,224,0,0,0,0,0,0,0,7,128,0,0,0,0,1,255,255,255,255,255,192,0,0,1,255,255,255,255,255,192,9,0,1,255,255,255,255,255,192,63,224,0,0,0,254,0,0,0,127,254,0,0,0,254,0,0,0,11,255,192,0,0,254,0,0,0,0,191,64,0,0,254,0,0,0,0,10,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,0,0,254,0,0,0,0,0,0,63,255,255,255,253,0,0,0,64,63,255,255,255,253,0,0,0,240,63,255,255,255,253,0,0,2,252,0,0,255,0,0,0,0,3,244,0,0,254,0,0,0,0,11,240,0,0,254,0,0,0,0,15,224,0,0,254,0,0,0,0,47,192,0,0,254,0,0,0,0,63,128,0,0,254,0,0,0,0,255,0,0,0,254,0,0,0,1,254,0,0,0,254,0,0,0,3,252,0,0,0,255,0,0,0,11,244,11,255,255,255,255,255,224,15,240,11,255,255,255,255,255,224,2,208,11,255,255,255,255,255,224,0,64,0,0,0,0,0,0,0,
  // 0x6d17  洗
  23,109,34,35,59,36,1,252,0,64,0,0,0,190,0,0,0,3,224,0,11,224,190,0,0,0,11,254,0,15,224,190,0,0,0,2,255,192,15,208,190,0,0,0,0,127,240,31,192,190,0,0,0,0,15,224,47,192,191,0,0,0,0,2,128,63,255,255,255,255,0,0,0,0,127,255,255,255,255,0,0,0,0,255,255,255,255,255,0,0,0,0,253,0,190,0,0,0,13,0,2,252,0,190,0,0,0,63,128,7,248,0,190,0,0,0,127,248,11,240,0,190,0,0,0,15,255,1,224,0,190,0,0,0,1,255,64,0,0,190,0,0,0,0,46,11,255,255,255,255,255,208,0,4,11,255,255,255,255,255,208,0,0,11,255,255,255,255,255,208,0,0,0,0,254,2,252,0,0,0,0,0,0,253,2,248,0,0,0,7,64,0,253,2,248,0,0,0,11,208,0,252,2,248,0,0,0,15,208,1,252,2,248,0,0,0,47,192,2,252,2,248,0,0,0,63,64,3,248,2,248,0,0,0,127,0,3,244,2,248,1,0,0,254,0,7,240,2,248,3,208,1,253,0,15,224,2,248,3,240,3,252,0,47,208,2,248,3,240,7,244,0,191,128,2,248,3,240,15,240,3,255,0,1,252,7,224,31,224,47,252,0,1,255,255,208,11,192,63,224,0,0,255,255,192,1,128,15,64,0,0,127,254,0,0,0,0,0,0,0,0,0,0,
  // 0x6d3b  活
  59,109,33,34,50,36,2,253,1,0,0,0,0,0,2,128,0,11,128,0,0,0,5,191,224,0,31,248,0,0,26,255,255,248,0,11,255,129,191,255,255,255,144,0,1,255,225,255,255,255,144,0,0,0,47,192,255,250,252,0,0,0,0,3,64,80,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,125,0,31,255,255,255,255,255,64,255,208,31,255,255,255,255,255,64,191,248,31,255,255,255,255,255,64,15,255,0,0,1,252,0,0,0,1,253,0,0,1,252,0,0,0,0,56,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,0,0,0,1,252,0,0,0,0,2,0,255,255,255,255,244,0,0,15,128,255,255,255,255,244,0,0,31,208,255,255,255,255,244,0,0,63,192,252,0,0,3,244,0,0,191,0,252,0,0,3,244,0,0,254,0,252,0,0,3,244,0,3,252,0,252,0,0,3,244,0,7,248,0,252,0,0,3,244,0,15,240,0,252,0,0,3,244,0,47,208,0,255,255,255,255,244,0,127,192,0,255,255,255,255,244,0,63,0,0,255,255,255,255,244,0,10,0,0,252,0,0,3,244,0,0,0,0,188,0,0,2,160,0,
  // 0x6d41  流
  65,109,34,34,50,36,1,253,0,64,0,0,1,252,0,0,0,2,244,0,0,1,252,0,0,0,7,255,0,0,1,252,0,0,0,2,255,224,0,1,252,0,0,0,0,63,244,0,1,252,0,0,0,0,7,247,255,255,255,255,255,192,0,0,199,255,255,255,255,255,192,0,0,7,255,255,255,255,255,192,0,0,0,0,63,192,0,0,0,0,0,0,0,127,64,47,0,0,9,0,0,0,190,0,63,192,0,63,224,0,0,252,0,15,240,0,127,253,0,2,254,170,175,252,0,11,255,131,255,255,255,255,255,0,0,191,3,255,255,255,255,255,128,0,13,3,255,234,149,64,31,208,0,0,0,0,0,0,0,15,64,0,0,0,31,128,0,5,64,0,0,0,0,31,129,248,15,192,0,0,1,0,31,129,248,15,192,0,0,3,208,31,129,248,15,192,0,0,7,240,31,129,248,15,192,0,0,15,240,31,129,248,15,192,0,0,31,208,47,65,248,15,192,0,0,63,192,47,65,248,15,192,0,0,127,64,63,1,248,15,192,0,0,255,0,127,1,248,15,193,0,1,253,0,255,1,248,15,193,224,3,252,1,253,1,248,15,194,240,11,244,3,252,1,248,15,194,224,15,240,15,244,1,248,15,195,224,15,208,63,224,1,248,15,255,208,3,192,15,128,0,164,11,255,192,0,0,2,0,0,0,1,170,0,
  // 0x6d4b  测
  75,109,33,34,50,36,1,253,0,64,0,0,0,0,0,10,0,3,224,0,0,0,0,0,31,64,15,254,15,255,255,244,0,31,64,3,255,207,255,255,244,61,31,64,0,127,223,213,86,244,61,31,64,0,15,143,192,0,244,61,31,64,0,2,15,192,0,244,61,31,64,0,0,15,195,208,244,61,31,64,0,0,15,195,208,244,61,31,64,0,0,15,195,208,244,61,31,64,8,0,15,195,208,244,61,31,64,47,128,15,195,208,244,61,31,64,127,244,15,195,208,244,61,31,64,31,255,15,195,208,244,61,31,64,2,254,15,195,208,244,61,31,64,0,60,15,195,208,244,61,31,64,0,0,15,195,208,244,61,31,64,0,0,15,195,208,244,61,31,64,0,0,15,195,208,244,61,31,64,0,0,15,195,208,244,61,31,64,0,24,15,195,208,244,61,31,64,0,63,15,195,208,244,61,31,64,0,63,15,195,208,244,61,31,64,0,191,15,199,192,244,61,31,64,0,254,15,203,192,244,61,31,64,1,252,5,79,192,80,20,31,64,2,252,0,15,132,0,0,31,64,3,244,0,47,125,0,0,31,64,7,240,0,126,63,64,0,31,64,15,224,1,252,15,208,0,31,64,31,208,7,244,3,240,0,31,64,63,192,63,208,1,252,63,255,64,11,64,63,64,0,184,31,254,0,0,0,8,0,0,16,10,164,0,
  // 0x6d88  消
  136,109,32,35,24,36,2,252,1,0,0,0,2,252,0,0,15,208,0,96,2,252,0,164,47,248,3,244,2,252,0,254,11,255,66,252,2,252,2,252,0,255,192,254,2,252,3,248,0,47,64,191,2,252,11,240,0,6,0,63,130,252,15,208,0,0,0,47,194,252,47,192,0,0,0,13,2,252,6,0,0,0,0,0,2,252,0,0,120,0,1,255,255,255,255,244,255,128,1,255,255,255,255,244,255,240,1,255,255,255,255,244,31,253,1,252,0,0,3,244,3,253,1,252,0,0,3,244,0,184,1,252,0,0,3,244,0,32,1,252,0,0,3,244,0,0,1,255,255,255,255,244,0,0,1,255,255,255,255,244,0,0,1,255,255,255,255,244,0,14,1,252,0,0,3,244,0,31,193,252,0,0,3,244,0,63,129,252,0,0,3,244,0,127,1,255,255,255,255,244,0,255,1,255,255,255,255,244,1,253,1,255,255,255,255,244,3,252,1,252,0,0,3,244,7,244,1,252,0,0,3,244,15,240,1,252,0,0,3,244,31,224,1,252,0,0,3,244,63,192,1,252,0,0,3,244,127,128,1,252,0,11,255,240,31,0,1,252,0,7,255,240,1,0,1,252,0,3,255,128,0,0,0,0,0,0,0,0,
  // 0x6de1  淡
  225,109,34,34,50,36,1,253,0,0,0,0,0,253,0,0,0,2,224,0,0,0,253,0,0,0,7,254,0,9,64,253,0,160,0,2,255,208,31,128,253,0,254,0,0,127,244,63,64,252,2,252,0,0,11,240,63,0,252,3,244,0,0,1,192,254,1,252,11,240,0,0,0,1,252,2,248,31,192,0,0,0,2,248,3,253,47,64,0,0,0,0,16,7,255,129,0,0,8,0,0,0,15,255,248,0,0,47,128,0,0,63,219,255,64,0,127,244,0,2,255,64,255,240,0,31,255,0,111,254,0,31,254,0,1,255,67,255,244,0,2,255,64,0,46,2,255,128,253,0,126,0,0,4,0,228,0,252,0,8,0,0,0,0,0,0,252,0,0,0,0,0,0,47,64,252,0,190,0,0,3,0,63,65,252,0,255,0,0,11,192,127,1,252,2,253,0,0,15,224,190,2,254,3,248,0,0,47,192,252,3,255,11,240,0,0,63,131,252,3,255,95,208,0,0,191,7,240,11,255,223,128,0,0,254,0,96,15,239,224,0,0,2,253,0,0,63,199,248,0,0,7,252,0,1,255,131,254,0,0,15,240,0,27,254,0,255,208,0,31,224,2,255,248,0,63,254,64,31,192,47,255,208,0,11,255,208,3,128,15,253,0,0,1,255,128,0,0,7,144,0,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x6df7  混
  247,109,34,34,50,36,1,253,0,128,0,0,0,0,0,0,0,3,248,0,170,170,170,170,168,0,7,255,129,255,255,255,255,252,0,1,255,241,255,255,255,255,252,0,0,31,225,252,0,0,1,252,0,0,3,193,252,0,0,1,252,0,0,0,65,252,0,0,1,252,0,0,0,1,255,255,255,255,252,0,0,0,1,255,255,255,255,252,0,0,0,1,254,170,170,170,252,0,13,0,1,252,0,0,1,252,0,63,224,1,252,0,0,1,252,0,127,253,1,254,170,170,171,252,0,7,255,1,255,255,255,255,252,0,0,190,1,255,255,255,255,252,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,252,0,15,208,0,0,0,0,0,252,0,15,208,0,0,0,1,0,252,0,15,208,8,0,0,7,128,252,0,15,208,127,0,0,15,224,255,255,207,215,255,128,0,31,208,255,255,207,255,253,0,0,47,192,255,255,207,255,208,0,0,63,64,252,0,15,253,0,0,0,191,0,252,0,15,208,0,0,0,254,0,252,0,15,208,2,0,2,252,0,252,0,15,208,3,224,3,248,0,253,111,207,208,7,224,11,240,22,255,255,207,208,11,208,15,240,63,255,255,207,255,255,192,31,208,63,255,148,7,255,255,192,3,192,42,64,0,1,255,254,0,0,0,0,0,0,0,0,0,0,
  // 0x6e05  清
  5,110,34,34,50,36,1,253,0,64,0,0,0,253,0,0,0,3,248,0,0,0,253,0,0,0,11,255,66,255,255,255,255,255,64,1,255,226,255,255,255,255,255,64,0,47,241,85,85,254,85,85,0,0,7,208,0,0,253,0,0,0,0,0,128,21,85,254,85,84,0,0,0,0,191,255,255,255,253,0,0,0,0,191,255,255,255,253,0,0,0,0,0,0,253,0,0,0,13,0,0,0,0,253,0,0,0,63,208,11,255,255,255,255,255,224,127,253,11,255,255,255,255,255,224,11,255,133,85,85,85,85,85,64,1,255,0,0,0,0,0,0,0,0,46,0,26,170,170,170,164,0,0,4,0,47,255,255,255,252,0,0,0,0,47,255,255,255,252,0,0,0,0,47,128,0,1,252,0,0,1,0,47,128,0,1,252,0,0,3,208,47,255,255,255,252,0,0,7,240,47,255,255,255,252,0,0,15,240,47,128,0,1,252,0,0,31,208,47,128,0,1,252,0,0,63,192,47,128,0,1,252,0,0,127,64,47,255,255,255,252,0,0,255,0,47,255,255,255,252,0,1,254,0,47,149,85,86,252,0,3,252,0,47,128,0,1,252,0,7,244,0,47,128,0,1,252,0,15,240,0,47,128,0,1,252,0,31,208,0,47,128,2,255,248,0,3,192,0,47,128,1,255,244,0,0,0,0,47,128,0,255,144,0,
  // 0x6e29  温
  41,110,34,33,41,36,1,253,0,224,0,0,0,0,0,0,0,3,254,0,127,255,255,255,240,0,3,255,224,127,255,255,255,240,0,0,127,248,127,255,255,255,240,0,0,7,240,127,0,0,3,240,0,0,0,144,127,0,0,3,240,0,0,0,0,127,170,170,171,240,0,0,0,0,127,255,255,255,240,0,0,0,0,127,255,255,255,240,0,4,0,0,127,0,0,3,240,0,47,128,0,127,0,0,3,240,0,127,248,0,127,0,0,3,240,0,31,255,64,127,255,255,255,240,0,1,255,128,127,255,255,255,240,0,0,47,0,127,255,255,255,240,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,255,255,255,255,253,0,0,3,66,255,255,255,255,253,0,0,7,226,255,255,255,255,253,0,0,15,226,244,47,7,208,253,0,0,31,194,244,47,7,208,253,0,0,63,130,244,47,7,208,253,0,0,127,2,244,47,7,208,253,0,0,254,2,244,47,7,208,253,0,2,252,2,244,47,7,208,253,0,3,248,2,244,47,7,208,253,0,11,240,2,244,47,7,208,253,0,31,224,127,255,255,255,255,255,224,31,192,127,255,255,255,255,255,224,3,128,127,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x6e38  游
  56,110,34,34,50,36,1,253,1,0,0,47,64,2,160,0,0,3,224,0,47,64,3,244,0,0,15,253,0,47,64,7,240,0,0,7,255,128,47,64,7,240,0,0,0,191,192,47,64,11,224,0,0,0,31,64,63,128,15,255,255,224,0,6,191,255,255,223,255,255,224,0,0,191,255,255,239,255,255,224,0,0,191,255,255,255,64,0,0,0,0,2,244,0,191,0,0,0,13,0,2,244,1,253,0,0,0,63,224,2,244,0,127,255,255,64,127,253,3,244,0,15,255,255,208,11,255,3,244,0,11,255,255,128,0,188,3,255,255,0,0,191,0,0,20,3,255,255,0,1,253,0,0,0,3,255,255,0,11,248,0,0,0,3,240,63,0,31,224,0,0,0,3,240,63,0,31,192,0,0,0,7,240,63,0,31,192,0,0,52,7,224,63,63,255,255,224,0,62,11,224,63,63,255,255,224,0,190,11,208,63,63,255,255,224,0,253,15,192,63,0,31,192,0,1,252,15,192,63,0,31,192,0,2,252,31,128,127,0,31,192,0,3,244,63,64,126,0,31,192,0,7,240,63,0,126,0,31,192,0,11,240,190,0,190,0,31,192,0,15,208,252,0,189,0,31,192,0,47,195,252,0,253,0,31,192,0,63,135,240,191,252,31,255,128,0,11,66,208,127,248,15,255,64,0,0,0,128,63,208,15,249,0,0,
  // 0x6e90  源
  144,110,34,34,50,36,1,253,0,64,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,11,255,3,255,255,255,255,255,192,2,255,211,255,255,255,255,255,192,0,63,227,255,255,255,255,255,192,0,11,195,244,0,15,240,0,0,0,1,3,244,0,15,224,0,0,0,0,3,244,0,15,192,0,0,0,0,3,244,85,111,213,85,0,0,0,3,244,255,255,255,255,0,13,0,3,244,255,255,255,255,0,63,208,3,244,252,0,0,63,0,127,248,3,244,252,0,0,63,0,11,255,3,244,253,85,85,127,0,1,254,3,244,255,255,255,255,0,0,44,3,240,255,255,255,255,0,0,0,3,240,252,0,0,63,0,0,0,3,240,252,0,0,63,0,0,0,3,240,252,0,0,63,0,0,0,7,240,255,255,255,255,0,0,13,7,240,255,255,255,255,0,0,31,139,224,85,95,229,85,0,0,63,139,224,0,15,208,0,0,0,127,15,208,36,15,208,116,0,0,191,15,192,191,15,210,252,0,0,253,31,192,253,15,208,254,0,2,252,47,129,252,15,208,127,64,3,248,63,67,244,15,208,63,192,7,240,127,11,240,15,208,31,208,15,240,254,31,208,15,208,15,224,31,209,253,47,128,15,208,7,208,63,195,252,2,11,255,192,0,0,11,65,244,0,7,255,192,0,0,0,0,16,0,3,249,0,0,0,
  // 0x6ea2  溢
  162,110,34,34,50,36,1,253,0,64,0,0,0,0,0,0,0,3,244,0,0,15,255,252,0,0,11,255,0,6,79,255,253,0,0,2,255,208,15,223,255,255,0,0,0,47,208,47,192,0,63,64,0,0,7,128,127,64,0,47,192,0,0,0,1,254,0,0,15,244,0,0,0,7,254,170,170,175,253,0,0,0,31,243,255,255,253,255,192,0,0,15,195,255,255,252,127,64,14,0,3,0,0,0,0,13,0,63,208,0,0,0,0,0,0,0,127,252,0,0,0,0,0,0,0,11,255,0,0,15,255,253,0,0,1,254,0,10,79,255,255,0,0,0,44,0,15,223,255,255,64,0,0,0,0,63,192,0,47,192,0,0,0,0,191,64,0,15,224,0,0,0,1,254,0,0,11,248,0,0,0,3,252,0,0,2,254,0,0,0,31,240,0,0,0,255,208,0,29,127,255,255,255,255,255,208,0,63,175,255,255,255,255,251,64,0,63,73,255,255,255,255,244,0,0,191,0,252,47,11,194,244,0,0,254,0,252,47,11,194,244,0,1,252,0,252,47,11,194,244,0,3,248,0,252,47,11,194,244,0,7,244,0,252,47,11,194,244,0,15,240,0,252,47,11,194,244,0,31,208,127,255,255,255,255,255,224,47,192,127,255,255,255,255,255,224,11,128,127,255,255,255,255,255,224,0,0,0,0,0,0,0,0,0,
  // 0x6ed1  滑
  209,110,33,34,50,36,1,253,0,64,0,0,0,0,0,0,0,2,248,0,26,170,170,170,144,0,7,255,64,31,255,255,255,224,0,1,255,240,31,255,255,255,224,0,0,31,244,31,128,0,7,224,0,0,2,224,31,128,0,7,224,0,0,0,64,31,128,255,255,224,0,0,0,0,31,128,255,255,224,0,0,0,0,31,128,244,11,224,0,0,0,0,31,128,244,7,224,0,8,0,0,31,128,244,7,224,0,47,128,10,191,234,250,175,250,128,127,248,15,255,255,255,255,255,192,31,255,79,255,255,255,255,255,192,1,255,79,192,0,0,0,15,192,0,46,15,192,0,0,0,15,192,0,0,15,239,255,255,255,239,192,0,0,6,175,255,255,255,234,128,0,0,0,31,234,170,175,224,0,0,0,0,31,128,0,7,224,0,0,3,192,31,128,0,7,224,0,0,7,240,31,255,255,255,224,0,0,15,240,31,255,255,255,224,0,0,31,208,31,213,85,91,224,0,0,63,192,31,128,0,7,224,0,0,127,64,31,213,85,91,224,0,0,255,0,31,255,255,255,224,0,1,254,0,31,255,255,255,224,0,3,252,0,31,128,0,7,224,0,7,244,0,31,128,0,7,224,0,15,240,0,31,128,0,7,224,0,31,208,0,31,128,6,175,224,0,3,192,0,31,128,7,255,208,0,0,0,0,31,128,3,254,64,0,
  // 0x6f0f  漏
  15,111,33,34,50,36,1,253,1,0,0,0,0,0,0,0,0,3,224,6,170,170,170,170,170,0,15,253,7,255,255,255,255,255,0,3,255,199,255,255,255,255,255,0,0,191,199,224,0,0,0,127,0,0,31,71,224,0,0,0,127,0,0,2,7,224,0,0,0,127,0,0,0,7,250,170,170,170,255,0,0,0,7,255,255,255,255,255,0,0,0,7,255,255,255,255,255,0,4,0,7,224,0,0,0,0,0,47,128,7,224,0,0,0,0,0,127,244,7,250,170,170,170,170,128,31,255,7,255,255,255,255,255,192,2,255,11,255,255,255,255,255,192,0,61,11,224,0,31,64,0,0,0,4,11,208,0,31,64,0,0,0,0,11,234,170,191,170,170,64,0,0,11,255,255,255,255,255,64,0,0,15,255,255,255,255,255,64,0,40,15,239,0,31,64,31,64,0,63,15,239,20,31,84,31,64,0,127,15,239,126,31,126,31,64,0,254,31,175,47,239,95,223,64,0,253,47,175,7,159,67,159,64,2,252,63,111,0,31,64,31,64,3,248,63,47,20,31,100,31,64,7,244,127,47,125,31,190,31,64,11,240,190,47,47,159,95,159,64,15,208,253,47,11,239,71,95,64,47,194,252,47,1,31,64,31,64,63,131,244,47,0,31,65,111,64,31,1,240,47,0,31,71,255,64,1,0,16,47,0,31,3,253,0,
  // 0x6fc0  激
  192,111,34,35,59,36,1,252,1,0,0,15,144,1,228,0,0,3,224,0,31,192,1,252,0,0,15,253,0,47,192,2,248,0,0,3,255,133,127,149,66,244,0,0,0,127,223,255,255,195,244,0,0,0,15,15,255,255,195,240,0,0,0,1,15,64,15,195,240,0,0,0,0,15,64,15,199,255,255,224,0,0,15,149,95,203,255,255,224,0,0,15,255,255,207,255,255,224,13,0,15,255,255,223,192,63,0,63,208,15,64,15,239,192,126,0,127,248,15,64,15,255,208,126,0,15,254,15,149,95,255,208,189,0,1,253,15,255,255,255,224,189,0,0,56,15,255,255,255,240,252,0,0,0,0,31,192,186,240,252,0,0,0,0,31,192,33,244,252,0,0,0,106,191,234,160,249,248,0,0,0,191,255,255,240,254,244,0,0,24,191,255,255,240,191,240,0,0,47,0,252,0,0,127,240,0,0,63,64,252,0,0,63,208,0,0,127,0,254,170,128,47,192,0,0,254,0,255,255,128,47,192,0,0,252,1,255,255,128,63,192,0,2,252,2,244,31,128,191,240,0,3,248,3,240,31,129,255,244,0,7,240,7,240,31,131,253,252,0,15,240,15,208,47,79,240,255,0,31,208,63,192,63,127,208,63,192,63,192,255,15,255,255,128,31,224,11,130,253,15,254,189,0,7,192,0,0,112,6,148,36,0,1,0,0,0,0,0,0,0,0,0,0,
  // 0x706f  灯
  111,112,33,34,50,36,2,253,0,10,128,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,0,0,0,0,0,0,0,31,192,15,255,255,255,255,128,0,31,192,15,255,255,255,255,128,0,31,192,15,255,255,255,255,128,0,31,192,5,85,87,249,85,0,0,31,194,144,0,3,248,0,0,47,31,195,240,0,3,248,0,0,62,31,195,224,0,3,248,0,0,62,31,203,208,0,3,248,0,0,62,31,207,192,0,3,248,0,0,61,31,207,64,0,3,248,0,0,125,31,239,0,0,3,248,0,0,188,31,238,0,0,3,248,0,0,252,31,192,0,0,3,248,0,0,248,47,128,0,0,3,248,0,0,20,47,128,0,0,3,248,0,0,0,47,128,0,0,3,248,0,0,0,63,64,0,0,3,248,0,0,0,63,128,0,0,3,248,0,0,0,63,208,0,0,3,248,0,0,0,127,244,0,0,3,248,0,0,0,191,253,0,0,3,248,0,0,0,253,191,64,0,3,248,0,0,2,252,63,208,0,3,248,0,0,3,252,15,240,0,3,248,0,0,11,244,3,208,0,3,248,0,0,15,240,1,128,0,3,248,0,0,63,208,0,0,0,3,248,0,0,255,128,0,0,191,255,244,0,0,255,0,0,0,63,255,240,0,0,60,0,0,0,47,255,208,0,0,16,0,0,0,26,84,0,0,0,
  // 0x70b9  点
  185,112,32,34,16,36,2,253,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,255,255,255,248,0,0,0,15,255,255,255,248,0,0,0,15,255,255,255,248,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,252,0,0,0,0,127,0,0,252,0,0,0,0,127,0,0,252,0,0,0,0,127,0,0,252,0,0,0,0,127,0,0,252,0,0,0,0,127,0,0,252,0,0,0,0,127,0,0,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,228,0,0,1,0,31,0,2,252,15,208,31,192,63,192,3,248,15,208,15,192,31,208,11,240,11,224,15,224,11,240,15,224,11,240,7,240,3,252,63,192,7,240,3,244,1,253,191,64,7,240,2,248,0,255,254,0,7,240,1,252,0,126,24,0,2,80,0,64,0,32,
  // 0x70ed  热
  237,112,33,35,59,36,2,252,0,31,128,0,15,192,0,0,0,0,47,128,0,15,192,0,0,0,0,47,128,0,15,192,0,0,0,0,47,128,0,15,192,0,0,0,0,47,128,0,15,192,0,0,0,191,255,255,175,255,255,255,0,0,191,255,255,175,255,255,255,0,0,191,255,255,175,255,255,255,0,0,0,47,128,0,15,192,63,0,0,0,47,128,0,31,192,63,0,0,0,47,128,0,31,128,63,0,0,0,47,129,64,47,128,63,0,0,0,47,255,137,47,64,63,0,0,1,191,255,223,191,64,63,0,0,191,255,255,191,255,0,63,0,0,255,255,208,7,255,0,63,0,0,255,255,128,0,255,224,63,0,0,180,47,128,0,255,252,63,0,0,0,47,128,2,255,255,47,8,0,0,47,128,7,244,191,47,75,128,0,47,128,31,240,29,31,79,192,0,47,128,127,192,0,15,207,128,31,255,66,255,64,0,15,255,64,15,255,0,253,0,0,7,255,0,15,248,0,48,0,0,1,248,0,0,0,0,0,0,0,2,0,0,0,248,0,0,1,64,47,128,0,3,252,15,208,31,192,47,208,0,7,244,11,224,15,208,15,240,0,15,240,7,240,11,240,7,248,0,47,192,7,240,7,240,2,252,0,127,128,7,240,3,244,0,255,0,255,0,3,240,3,248,0,191,0,44,0,2,144,1,144,0,56,0,0,0,0,0,0,0,0,0,0,
  // 0x7247  片
  71,114,32,35,24,36,1,252,0,0,0,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,192,0,11,240,0,0,0,47,213,85,95,245,85,84,0,47,255,255,255,255,255,253,0,47,255,255,255,255,255,253,0,47,255,255,255,255,255,253,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,213,85,85,85,80,0,0,63,255,255,255,255,244,0,0,63,255,255,255,255,244,0,0,127,255,255,255,255,244,0,0,127,0,0,0,7,244,0,0,191,0,0,0,7,244,0,0,255,0,0,0,7,244,0,0,254,0,0,0,7,244,0,2,252,0,0,0,7,244,0,3,252,0,0,0,7,244,0,11,248,0,0,0,7,244,0,15,240,0,0,0,7,244,0,63,224,0,0,0,7,244,0,127,192,0,0,0,7,244,0,31,0,0,0,0,7,244,0,9,0,0,0,0,7,244,0,0,0,0,0,0,0,0,0,
  // 0x7269  物
  105,114,34,34,50,36,1,253,0,3,240,0,14,64,0,0,0,0,3,240,0,31,128,0,0,0,11,131,240,0,47,64,0,0,0,15,195,240,0,63,0,0,0,0,15,195,240,0,63,0,0,0,0,15,195,240,0,190,0,0,0,0,15,131,240,0,255,255,255,255,208,31,255,255,209,255,255,255,255,192,31,255,255,211,255,255,255,255,192,47,255,255,215,240,126,15,207,192,63,7,240,15,224,188,31,143,192,62,3,240,31,192,252,47,79,192,125,3,240,63,129,248,63,15,192,252,3,240,255,2,244,63,15,192,44,3,240,125,3,240,126,31,192,0,3,240,4,11,208,189,31,192,0,3,240,96,15,192,252,31,128,0,3,255,240,47,129,248,31,128,0,47,255,240,127,3,244,47,128,27,255,255,144,253,3,240,47,128,127,255,244,2,252,11,224,47,64,63,251,240,11,244,15,192,63,64,62,3,240,47,224,47,192,63,64,0,3,240,63,192,63,64,63,0,0,3,240,15,0,191,0,63,0,0,3,240,0,1,253,0,127,0,0,3,240,0,3,248,0,127,0,0,3,240,0,15,240,0,190,0,0,3,240,0,47,208,0,253,0,0,3,240,0,191,128,2,252,0,0,3,240,3,255,3,255,252,0,0,3,240,1,252,2,255,244,0,0,3,240,0,32,1,255,208,0,0,3,240,0,0,0,0,0,0,
  // 0x7279  特
  121,114,34,34,50,36,1,253,0,3,240,0,0,31,192,0,0,0,3,240,0,0,31,192,0,0,10,67,240,0,0,31,192,0,0,15,195,240,0,0,31,192,0,0,15,195,240,3,255,255,255,255,0,15,195,240,3,255,255,255,255,0,15,131,240,3,255,255,255,255,0,31,239,250,128,0,31,192,0,0,31,255,255,208,0,31,192,0,0,47,255,255,208,0,31,192,0,0,63,91,245,64,0,31,192,0,0,62,3,240,63,255,255,255,255,208,125,3,240,63,255,255,255,255,208,252,3,240,63,255,255,255,255,208,124,3,240,0,0,0,15,208,0,4,3,240,0,0,0,15,208,0,0,3,241,176,0,0,15,208,0,0,3,255,240,0,0,15,208,0,0,111,255,255,255,255,255,255,192,47,255,255,111,255,255,255,255,192,127,255,240,47,255,255,255,255,192,63,251,240,0,0,0,15,208,0,57,3,240,0,180,0,15,208,0,0,3,240,2,252,0,15,208,0,0,3,240,0,255,0,15,208,0,0,3,240,0,63,128,15,208,0,0,3,240,0,31,208,15,208,0,0,3,240,0,11,240,15,208,0,0,3,240,0,3,128,15,208,0,0,3,240,0,0,0,15,208,0,0,3,240,0,0,21,95,192,0,0,3,240,0,0,63,255,192,0,0,3,240,0,0,47,255,128,0,0,3,240,0,0,31,249,0,0,
  // 0x7387  率
  135,115,32,35,24,36,2,252,0,0,0,11,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,0,0,0,63,64,0,0,0,2,0,0,190,0,0,3,208,31,208,1,252,7,64,15,244,31,248,31,240,15,208,63,208,2,255,127,208,63,65,255,0,0,127,95,240,190,3,248,0,0,28,3,254,248,0,80,0,0,0,0,191,241,64,0,0,0,0,64,47,207,193,128,0,0,27,192,127,7,247,248,0,1,255,209,252,3,255,255,64,111,255,255,255,255,252,191,240,255,228,191,255,255,254,15,253,126,0,127,255,165,127,2,254,32,0,0,15,224,30,0,116,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,0,0,0,0,
  // 0x73af  环
  175,115,33,32,32,36,1,253,127,255,253,63,255,255,255,255,192,127,255,253,63,255,255,255,255,192,127,255,253,63,255,255,255,255,192,0,126,0,0,0,31,208,0,0,0,126,0,0,0,63,192,0,0,0,126,0,0,0,63,128,0,0,0,126,0,0,0,191,0,0,0,0,126,0,0,0,255,0,0,0,0,126,0,0,2,254,0,0,0,0,126,0,0,3,254,16,0,0,0,126,0,0,11,255,188,0,0,63,255,248,0,15,255,254,0,0,63,255,248,0,63,254,191,64,0,63,255,248,0,191,254,63,192,0,0,126,0,1,255,190,15,240,0,0,126,0,3,253,190,7,248,0,0,126,0,15,248,190,2,253,0,0,126,0,63,240,190,0,255,0,0,126,0,255,192,190,0,127,192,0,126,0,191,64,190,0,47,64,0,126,0,45,0,190,0,12,0,0,126,24,4,0,190,0,0,0,0,127,253,0,0,190,0,0,0,1,191,253,0,0,190,0,0,0,111,255,248,0,0,190,0,0,0,191,254,64,0,0,190,0,0,0,127,208,0,0,0,190,0,0,0,52,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,0,
  // 0x7528  用
  40,117,31,32,0,36,1,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,0,1,252,0,1,252,0,191,0,1,252,0,1,252,0,191,0,1,252,0,1,252,0,191,0,1,252,0,1,252,0,191,0,1,252,0,1,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,0,1,252,0,1,252,0,191,0,1,252,0,1,252,0,190,0,1,252,0,1,252,0,190,0,1,252,0,1,252,0,190,0,1,252,0,1,252,0,190,0,1,252,0,1,252,0,191,255,255,255,255,255,252,0,255,255,255,255,255,255,252,0,255,255,255,255,255,255,252,0,252,0,1,252,0,1,252,1,252,0,1,252,0,1,252,2,252,0,1,252,0,1,252,3,248,0,1,252,0,1,252,3,244,0,1,252,0,1,252,11,240,0,1,252,0,1,252,15,224,0,1,252,0,1,252,47,192,0,1,252,0,2,252,127,192,0,1,252,31,255,252,127,0,0,1,252,15,255,244,13,0,0,1,248,11,255,144,0,0,0,0,0,0,0,0,
  // 0x7535  电
  53,117,31,34,16,36,4,253,0,0,0,169,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,253,0,0,0,0,21,85,85,254,85,85,84,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,0,0,253,0,0,252,0,191,0,0,253,0,0,252,0,191,0,0,253,0,0,252,0,191,0,0,253,0,0,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,0,0,254,0,1,252,0,191,0,0,253,0,0,252,0,191,0,0,253,0,0,252,0,191,0,0,253,0,0,252,0,191,0,0,253,0,0,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,255,255,255,255,255,252,0,191,85,85,254,85,85,85,0,191,0,0,253,0,0,3,224,85,0,0,253,0,0,3,248,0,0,0,254,0,0,3,244,0,0,0,254,0,0,7,244,0,0,0,255,0,0,15,240,0,0,0,191,255,255,255,224,0,0,0,127,255,255,255,192,0,0,0,31,255,255,255,0,0,0,0,0,85,85,80,0,
  // 0x7565  略
  101,117,32,35,24,36,3,252,0,0,0,0,10,64,0,0,0,0,0,0,15,208,0,0,255,255,255,0,47,192,0,0,255,255,255,0,63,128,0,0,255,255,255,0,191,255,255,208,244,124,63,1,255,255,255,240,244,124,63,3,255,255,255,208,244,124,63,15,248,0,47,192,244,124,63,63,252,0,127,0,244,124,63,255,191,0,254,0,244,124,63,253,63,130,252,0,244,124,63,180,15,219,240,0,255,255,255,16,7,255,208,0,255,255,255,0,2,255,128,0,255,255,255,0,7,255,192,0,244,124,63,0,47,255,244,0,244,124,63,0,255,215,254,0,244,124,63,11,255,1,255,228,244,124,63,191,248,0,63,255,244,124,63,255,208,0,7,254,244,124,63,255,255,255,255,252,244,124,63,255,255,255,255,224,244,124,63,31,255,255,255,208,244,124,63,15,208,0,15,208,255,255,255,15,208,0,15,208,255,255,255,15,208,0,15,208,255,255,255,15,208,0,15,208,244,0,0,15,208,0,15,208,244,0,0,15,208,0,15,208,244,0,0,15,208,0,15,208,0,0,0,15,255,255,255,208,0,0,0,15,255,255,255,208,0,0,0,15,255,255,255,208,0,0,0,15,208,0,15,208,0,0,0,0,0,0,0,0,
  // 0x767d  白
  125,118,26,34,238,36,5,253,0,0,11,228,0,0,0,0,0,15,244,0,0,0,0,0,15,240,0,0,0,0,0,31,224,0,0,0,0,0,63,192,0,0,0,85,85,127,213,85,85,80,255,255,255,255,255,255,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,254,85,85,85,85,91,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,255,255,255,255,255,255,240,254,85,85,85,85,91,240,253,0,0,0,0,7,240,253,0,0,0,0,7,240,
  // 0x7684  的
  132,118,31,34,16,36,3,253,0,46,64,0,14,64,0,0,0,63,128,0,15,208,0,0,0,63,64,0,31,192,0,0,0,127,0,0,47,128,0,0,0,190,0,0,63,64,0,0,0,253,0,0,127,0,0,0,255,255,255,192,191,255,255,244,255,255,255,192,255,255,255,244,255,255,255,194,255,255,255,244,252,0,15,195,248,0,2,244,252,0,15,203,240,0,3,244,252,0,15,207,224,0,3,244,252,0,15,255,192,0,3,244,252,0,15,239,128,0,3,240,252,0,15,199,5,0,3,240,252,0,15,192,63,0,3,240,255,255,255,192,63,192,3,240,255,255,255,192,15,224,3,240,255,255,255,192,11,244,3,240,252,0,15,192,3,252,3,240,252,0,15,192,0,254,3,240,252,0,15,192,0,191,7,240,252,0,15,192,0,63,71,240,252,0,15,192,0,24,7,224,252,0,15,192,0,0,11,224,252,0,15,192,0,0,11,224,252,0,15,192,0,0,15,208,255,255,255,192,0,0,15,208,255,255,255,192,0,0,31,192,255,255,255,192,0,0,63,192,252,0,0,0,7,255,255,128,252,0,0,0,3,255,255,0,252,0,0,0,2,255,248,0,0,0,0,0,0,0,0,0,
  // 0x76d1  监
  209,118,33,34,50,36,2,253,0,0,47,128,1,228,0,0,0,6,144,47,128,2,252,0,0,0,11,224,47,128,3,248,0,0,0,11,224,47,128,3,240,0,0,0,11,224,47,128,7,240,0,0,0,11,224,47,128,15,255,255,255,0,11,224,47,128,31,255,255,255,0,11,224,47,128,47,255,255,255,0,11,224,47,128,63,64,0,0,0,11,224,47,128,191,0,0,0,0,11,224,47,129,253,7,0,0,0,11,224,47,131,252,47,192,0,0,11,224,47,139,244,47,244,0,0,11,224,47,159,224,7,253,0,0,11,224,47,135,192,1,255,128,0,11,224,47,129,64,0,63,208,0,11,208,47,128,0,0,15,224,0,0,0,47,128,0,0,7,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,255,255,255,255,255,255,128,0,1,255,255,255,255,255,255,128,0,1,255,255,255,255,255,255,128,0,1,252,3,240,15,192,47,128,0,1,252,3,240,15,192,47,128,0,1,252,3,240,15,192,47,128,0,1,252,3,240,15,192,47,128,0,1,252,3,240,15,192,47,128,0,1,252,3,240,15,192,47,128,0,1,252,3,240,15,192,47,128,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,0,0,0,0,0,0,0,0,0,
  // 0x76f4  直
  244,118,32,34,16,36,2,253,0,0,0,3,248,0,0,0,0,0,0,7,244,0,0,0,0,0,0,7,244,0,0,0,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,191,255,255,255,255,255,255,255,0,0,0,15,240,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,208,0,0,0,0,0,63,255,255,255,255,0,15,208,63,255,255,255,255,0,15,208,63,85,85,85,191,0,15,208,63,0,0,0,127,0,15,208,63,0,0,0,127,0,15,208,63,255,255,255,255,0,15,208,63,255,255,255,255,0,15,208,63,85,85,85,191,0,15,208,63,0,0,0,127,0,15,208,63,0,0,0,127,0,15,208,63,255,255,255,255,0,15,208,63,255,255,255,255,0,15,208,63,85,85,85,191,0,15,208,63,0,0,0,127,0,15,208,63,0,0,0,127,0,15,208,63,255,255,255,255,0,15,208,63,255,255,255,255,0,15,208,21,85,85,85,85,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,15,255,255,255,255,255,255,255,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,
  // 0x7701  省
  1,119,32,34,16,36,2,253,0,0,0,11,224,0,0,0,0,0,0,11,224,0,0,0,0,3,208,11,224,2,224,0,0,11,244,11,224,15,252,0,0,47,224,11,224,2,255,0,0,191,192,11,224,0,191,208,2,255,0,11,224,0,31,244,11,252,0,11,224,10,7,253,127,240,0,15,224,47,225,255,191,192,63,255,224,255,192,125,30,0,31,255,219,255,0,16,0,0,15,250,191,244,0,0,0,0,0,27,255,128,0,0,0,0,6,255,253,0,0,0,0,22,255,255,128,0,0,0,111,255,255,255,255,255,255,0,255,255,255,255,255,255,255,0,127,255,250,170,170,170,255,0,21,7,240,0,0,0,191,0,0,7,240,0,0,0,191,0,0,7,255,255,255,255,255,0,0,7,255,255,255,255,255,0,0,7,245,85,85,85,191,0,0,7,240,0,0,0,191,0,0,7,240,0,0,0,191,0,0,7,255,255,255,255,255,0,0,7,255,255,255,255,255,0,0,7,245,85,85,85,191,0,0,7,240,0,0,0,191,0,0,7,240,0,0,0,191,0,0,7,255,255,255,255,255,0,0,7,255,255,255,255,255,0,0,7,250,170,170,170,255,0,0,7,240,0,0,0,106,0,
  // 0x7720  眠
  32,119,33,32,32,36,2,253,127,255,252,15,255,255,255,253,0,127,255,252,15,255,255,255,253,0,127,255,252,15,255,255,255,253,0,126,0,252,15,192,0,0,253,0,126,0,252,15,192,0,0,253,0,126,0,252,15,192,0,0,253,0,126,0,252,15,192,0,0,253,0,127,255,252,15,255,255,255,253,0,127,255,252,15,255,255,255,253,0,127,255,252,15,255,255,255,253,0,126,0,252,15,192,15,192,0,0,126,0,252,15,192,15,192,0,0,126,0,252,15,192,15,208,0,0,126,0,252,15,192,15,208,0,0,126,0,252,15,192,11,208,0,0,127,255,252,15,255,255,255,255,64,127,255,252,15,255,255,255,255,64,127,255,252,15,255,255,255,255,64,126,0,252,15,208,7,240,0,0,126,0,252,15,192,3,240,0,0,126,0,252,15,192,3,240,0,0,126,0,252,15,192,3,244,0,0,127,0,252,15,192,2,248,0,0,127,255,252,15,192,1,252,0,0,127,255,252,15,192,0,252,7,64,127,255,252,15,192,0,253,7,192,126,0,0,15,192,105,190,11,192,126,0,0,15,255,254,63,11,192,126,0,2,255,255,254,47,223,192,0,0,3,255,255,228,15,255,128,0,0,3,255,164,0,7,255,0,0,0,1,144,0,0,1,252,0,
  // 0x786e  确
  110,120,33,35,59,36,1,252,0,0,0,0,3,144,0,0,0,0,0,0,0,7,240,0,0,0,63,255,255,244,11,224,0,0,0,63,255,255,244,15,255,254,0,0,63,255,255,244,47,255,255,192,0,0,63,64,0,63,255,255,64,0,0,63,0,0,255,0,191,0,0,0,127,0,1,252,0,252,0,0,0,190,0,3,248,3,248,0,0,0,189,0,15,255,255,255,255,64,0,252,0,63,255,255,255,255,64,0,252,0,15,255,255,255,255,64,1,252,0,3,248,11,208,63,64,2,255,255,193,248,11,208,63,64,3,255,255,193,248,11,208,63,64,7,255,255,193,248,11,208,63,64,15,244,15,193,255,255,255,255,64,15,244,15,193,255,255,255,255,64,47,244,15,193,254,175,234,191,64,63,244,15,193,248,11,208,63,64,255,244,15,193,248,11,208,63,64,127,244,15,193,248,11,208,63,64,62,244,15,194,255,255,255,255,64,2,244,15,194,255,255,255,255,64,2,244,15,195,255,255,255,255,64,2,244,15,195,240,0,0,63,64,2,255,255,199,240,0,0,63,64,2,255,255,203,224,0,0,63,64,2,255,255,223,208,0,0,63,64,2,244,0,31,192,0,0,63,64,2,244,0,63,128,0,0,63,64,2,244,0,255,0,0,63,255,0,0,0,0,125,0,0,63,255,0,0,0,0,24,0,0,47,248,0,0,0,0,0,0,0,0,0,0,
  // 0x79bb  离
  187,121,32,34,16,36,2,253,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,191,255,255,255,255,255,255,254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,1,0,0,0,0,105,2,64,15,208,106,0,0,190,11,248,63,128,191,0,0,190,7,255,254,0,191,0,0,190,0,63,252,0,191,0,0,190,1,191,255,128,191,0,0,190,47,253,47,240,191,0,0,190,47,208,7,208,191,0,0,190,9,0,0,64,191,0,0,191,255,255,255,255,255,0,0,191,255,255,255,255,255,0,0,106,170,191,234,170,170,0,0,0,0,63,128,0,0,0,0,0,0,127,64,0,0,0,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,15,255,255,255,255,255,255,240,15,224,1,252,2,224,11,240,15,224,2,252,3,244,11,240,15,224,3,244,0,252,11,240,15,231,255,250,255,254,11,240,15,227,255,255,255,255,75,240,15,227,255,255,234,175,203,240,15,224,0,0,0,15,75,240,15,224,0,0,0,0,11,240,15,224,0,0,0,15,255,240,15,224,0,0,0,11,255,208,15,224,0,0,0,3,254,64,
  // 0x79fb  移
  251,121,34,34,50,36,1,253,0,0,1,0,0,46,64,0,0,0,0,111,128,0,63,64,0,0,0,111,255,208,0,255,0,0,0,47,255,255,144,3,255,255,248,0,63,255,244,0,15,255,255,254,0,46,159,224,0,63,255,255,252,0,0,11,224,1,255,64,3,248,0,0,11,224,31,255,128,11,240,0,0,11,224,63,255,240,47,208,0,0,11,224,15,67,253,191,128,0,63,255,255,240,0,255,254,0,0,63,255,255,240,0,63,252,0,0,63,255,255,240,0,191,224,0,0,0,31,224,0,11,255,128,0,0,0,47,224,1,191,255,248,0,0,0,63,240,15,255,219,240,0,0,0,127,252,11,254,31,224,0,0,0,255,255,3,144,63,255,255,64,1,255,255,192,0,255,255,255,208,3,251,235,240,7,255,255,255,192,7,235,227,240,31,240,0,63,128,15,203,225,208,255,208,0,191,0,47,139,224,75,255,244,1,254,0,127,11,224,15,251,254,3,252,0,190,11,224,3,192,255,207,244,0,60,11,224,0,0,47,255,208,0,36,11,224,0,0,7,255,128,0,0,11,224,0,0,11,254,0,0,0,11,224,0,0,191,244,0,0,0,11,224,0,27,255,192,0,0,0,11,224,6,255,254,0,0,0,0,11,224,63,255,224,0,0,0,0,11,224,31,253,0,0,0,0,0,11,224,14,64,0,0,0,0,
  // 0x7a7a  空
  122,122,32,33,8,36,2,254,0,0,0,11,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,0,15,224,15,208,0,252,63,0,15,208,15,208,0,252,63,0,31,192,15,208,0,252,63,0,47,192,15,208,0,252,0,0,63,128,15,208,0,0,0,0,255,0,15,208,0,248,0,7,254,0,15,224,0,252,0,127,248,0,11,255,255,248,47,255,224,0,7,255,255,244,63,255,0,0,1,255,255,208,31,228,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,128,0,255,255,255,255,255,255,128,0,255,255,255,255,255,255,128,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,
  // 0x7aef  端
  239,122,34,34,50,36,1,253,0,26,0,0,0,47,64,0,0,0,63,0,0,0,47,128,0,0,0,63,0,15,192,47,128,63,0,0,63,0,15,192,47,128,63,0,0,63,0,15,192,47,128,63,0,0,63,0,15,192,47,128,63,0,0,63,0,15,192,47,128,63,0,63,255,255,15,192,47,128,63,0,63,255,255,15,255,255,255,255,0,63,255,255,15,255,255,255,255,0,0,0,0,15,255,255,255,255,0,6,0,120,0,0,0,0,0,0,31,0,190,0,0,0,0,0,0,15,64,189,127,255,255,255,255,208,15,128,252,127,255,255,255,255,208,15,128,252,127,255,255,255,255,208,11,192,252,0,0,63,64,0,0,11,192,248,0,0,127,0,0,0,11,193,244,0,0,191,0,0,0,7,209,244,31,255,255,255,255,128,7,210,240,31,255,255,255,255,128,7,211,240,31,255,255,255,255,128,7,211,224,31,131,224,188,31,128,0,3,230,159,131,224,188,31,128,0,7,255,223,131,224,188,31,128,27,255,255,239,131,224,188,31,128,191,255,254,95,131,224,188,31,128,127,254,64,31,131,224,188,31,128,62,64,0,31,131,224,188,31,128,0,0,0,31,131,224,188,31,128,0,0,0,31,131,224,188,31,128,0,0,0,31,131,224,189,191,128,0,0,0,31,131,224,188,255,64,0,0,0,26,64,0,0,254,0,
  // 0x7b2c  第
  44,123,33,34,50,36,1,253,0,46,64,0,1,244,0,0,0,0,63,64,0,3,248,0,0,0,0,191,0,0,7,240,0,0,0,0,255,255,255,79,255,255,255,192,3,255,255,255,111,255,255,255,192,11,251,254,170,255,239,250,170,128,31,225,252,1,255,3,248,0,0,63,192,253,7,252,1,252,0,0,127,64,190,3,240,0,254,0,0,13,0,96,0,144,0,100,0,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,2,248,0,7,240,0,0,0,0,2,248,0,7,240,0,0,0,0,2,248,0,7,240,0,0,47,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,63,255,255,255,255,255,240,0,0,127,0,2,248,0,0,0,0,0,191,0,2,248,0,0,0,0,0,254,0,2,248,0,0,0,0,0,255,255,255,255,255,255,255,0,1,255,255,255,255,255,255,255,0,2,255,255,255,255,255,255,255,0,1,164,1,255,248,0,0,190,0,0,0,15,251,248,0,0,254,0,0,0,191,210,248,0,0,253,0,0,11,255,2,248,0,1,252,0,1,255,244,2,248,11,255,252,0,63,255,128,2,248,3,255,244,0,31,248,0,2,248,3,255,208,0,11,128,0,2,248,0,0,0,0,0,0,0,2,244,0,0,0,0,
  // 0x7b49  等
  73,123,34,34,50,36,1,253,0,46,64,0,1,228,0,0,0,0,63,128,0,3,248,0,0,0,0,191,0,0,7,244,0,0,0,0,255,255,255,143,255,255,255,192,2,255,255,255,175,255,255,255,192,7,255,255,255,255,255,255,255,192,15,241,252,0,255,3,248,0,0,63,192,253,3,253,1,252,0,0,127,64,190,2,248,0,254,0,0,30,0,100,3,248,0,116,0,0,0,0,0,3,248,0,0,0,0,0,191,255,255,255,255,255,240,0,0,191,255,255,255,255,255,240,0,0,127,255,255,255,255,255,224,0,0,0,0,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,208,63,255,255,255,255,255,255,255,208,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,240,0,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,15,255,255,255,255,255,255,255,0,0,0,184,0,0,11,240,0,0,0,2,254,0,0,11,240,0,0,0,0,255,192,0,11,240,0,0,0,0,63,240,0,11,240,0,0,0,0,11,252,0,11,240,0,0,0,0,2,252,0,11,240,0,0,0,0,0,224,63,255,224,0,0,0,0,0,0,47,255,208,0,0,0,0,0,0,15,254,0,0,0,
  // 0x7bb1  箱
  177,123,33,35,59,36,1,252,0,47,64,0,1,248,0,0,0,0,63,128,0,3,248,0,0,0,0,127,0,0,7,244,0,0,0,0,255,255,255,75,255,255,255,192,1,255,255,255,159,255,255,255,192,3,255,255,255,191,255,255,255,192,11,241,252,0,191,71,240,0,0,15,224,253,1,255,2,252,0,0,63,192,190,3,252,0,253,0,0,127,64,127,2,248,0,191,0,0,31,0,124,0,112,0,56,0,0,0,2,248,0,0,0,0,0,0,0,2,248,0,63,255,255,255,0,0,2,248,0,63,255,255,255,0,0,2,248,0,63,255,255,255,0,47,255,255,255,63,0,0,127,0,47,255,255,255,63,0,0,127,0,47,255,255,255,63,0,0,127,0,0,11,248,0,63,255,255,255,0,0,15,252,0,63,255,255,255,0,0,47,255,0,63,170,170,255,0,0,63,255,208,63,0,0,127,0,0,191,255,244,63,0,0,127,0,1,255,250,253,63,0,0,127,0,3,246,248,255,63,255,255,255,0,15,242,248,60,63,255,255,255,0,47,194,248,20,63,170,170,255,0,191,130,248,0,63,0,0,127,0,63,2,248,0,63,0,0,127,0,12,2,248,0,63,234,170,255,0,0,2,248,0,63,255,255,255,0,0,2,248,0,63,255,255,255,0,0,2,248,0,63,0,0,127,0,0,2,248,0,42,0,0,21,0,0,0,0,0,0,0,0,0,0,
  // 0x7c7b  类
  123,124,32,35,24,36,2,252,0,0,0,11,224,0,0,0,0,31,0,11,224,0,249,0,0,127,128,11,224,2,253,0,0,47,224,11,224,7,248,0,0,11,244,11,224,15,240,0,0,3,252,11,224,63,192,0,0,2,244,15,224,47,64,0,127,255,255,255,255,255,255,254,127,255,255,255,255,255,255,254,127,255,255,255,255,255,255,254,0,0,3,255,255,192,0,0,0,0,31,255,255,244,0,0,0,0,191,219,231,254,0,0,0,7,255,75,225,255,208,0,0,127,252,11,224,63,254,64,27,255,224,11,224,7,255,249,255,255,64,11,224,0,191,254,63,244,0,5,64,16,11,252,30,64,0,11,224,254,0,100,0,0,0,15,224,191,224,0,0,0,0,15,224,11,252,0,0,0,0,15,208,1,244,0,127,255,255,255,255,255,255,255,127,255,255,255,255,255,255,255,127,255,255,255,255,255,255,255,0,0,0,255,253,0,0,0,0,0,2,254,191,64,0,0,0,0,11,252,63,224,0,0,0,0,127,244,15,253,0,0,0,27,255,208,3,255,228,0,27,255,255,0,0,191,255,233,255,255,244,0,0,31,255,255,127,254,0,0,0,0,191,253,62,64,0,0,0,0,1,188,0,0,0,0,0,0,0,0,
  // 0x7d22  索
  34,125,32,34,16,36,2,253,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,63,255,255,255,255,255,255,252,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,0,1,254,0,0,0,253,127,0,7,252,0,64,0,253,127,0,31,240,1,248,0,253,127,30,127,192,11,253,0,253,0,127,254,0,63,240,0,0,0,47,252,1,255,128,0,0,0,3,255,71,253,9,0,0,0,0,127,255,240,63,192,0,0,0,15,255,128,47,244,0,0,0,31,252,0,7,254,0,106,170,255,250,170,170,255,192,127,255,255,255,255,255,255,244,127,255,255,255,255,255,255,253,21,80,64,15,224,0,0,248,0,2,228,15,224,10,0,16,0,15,252,15,224,63,224,0,0,127,224,15,224,31,253,0,7,255,128,15,224,2,255,192,127,253,0,15,224,0,63,244,255,224,0,15,224,0,7,254,63,64,0,15,224,0,0,248,4,0,0,15,224,0,0,0,
  // 0x7d2b  紫
  43,125,33,35,59,36,1,252,0,0,126,0,11,224,0,0,0,0,0,126,0,11,224,0,0,0,1,80,126,0,11,224,1,180,0,3,240,127,170,139,224,111,254,0,3,240,127,255,203,251,255,249,0,3,240,127,255,203,255,255,64,0,3,240,126,0,11,255,144,0,0,3,240,126,0,11,240,0,0,0,3,240,126,0,11,224,0,10,64,3,240,126,1,75,224,0,15,192,3,240,191,255,203,240,0,31,192,27,255,255,255,199,255,255,255,192,127,255,255,254,67,255,255,255,64,127,254,148,47,128,191,255,253,0,37,0,0,191,128,0,0,0,0,0,0,2,253,0,126,0,0,0,0,11,79,244,1,255,64,0,0,0,47,255,192,11,252,0,0,0,0,47,255,64,127,224,16,0,0,0,2,255,246,255,66,248,0,0,0,0,47,255,248,2,255,0,0,0,0,7,255,208,0,127,208,0,0,0,2,255,170,171,255,244,0,63,255,255,255,255,255,255,253,0,63,255,255,255,255,255,255,255,64,63,255,255,255,248,0,0,63,192,0,0,80,3,248,0,64,14,0,0,1,253,3,248,7,244,0,0,0,11,252,3,248,11,255,0,0,0,127,240,3,248,1,255,224,0,7,255,128,3,248,0,47,252,0,63,253,0,3,248,0,3,255,64,15,224,0,3,248,0,0,191,0,2,0,0,3,248,0,0,20,0,0,0,0,0,0,0,0,0,0,
  // 0x7ea2  红
  162,126,34,33,41,36,1,254,0,2,64,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,15,240,5,85,85,85,85,0,0,31,208,15,255,255,255,255,128,0,63,192,15,255,255,255,255,128,0,127,64,15,255,255,255,255,128,0,255,0,0,0,31,208,0,0,2,252,3,64,0,31,208,0,0,3,248,11,224,0,31,208,0,0,11,240,31,240,0,31,208,0,0,31,208,63,192,0,31,208,0,0,191,255,255,64,0,31,208,0,0,191,255,254,0,0,31,208,0,0,63,255,252,0,0,31,208,0,0,41,11,244,0,0,31,208,0,0,0,31,208,0,0,31,208,0,0,0,127,128,0,0,31,208,0,0,1,254,0,0,0,31,208,0,0,7,252,22,144,0,31,208,0,0,31,255,255,208,0,31,208,0,0,127,255,255,224,0,31,208,0,0,63,255,233,0,0,31,208,0,0,46,144,0,0,0,31,208,0,0,0,0,0,0,0,31,208,0,0,0,0,0,0,0,31,208,0,0,0,0,27,192,0,31,208,0,0,0,107,255,192,0,31,208,0,0,127,255,255,239,255,255,255,255,208,127,255,249,95,255,255,255,255,208,127,249,0,31,255,255,255,255,208,57,0,0,5,85,85,85,85,64,0,0,0,0,0,0,0,0,0,
  // 0x7ea7  级
  167,126,34,35,59,36,1,252,0,3,128,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,15,224,47,255,255,255,208,0,0,31,192,47,255,255,255,192,0,0,63,128,47,255,255,255,192,0,0,127,0,0,63,128,63,128,0,0,254,0,0,63,64,63,64,0,1,252,4,0,63,64,127,0,0,3,244,15,128,63,64,191,0,0,7,240,31,192,63,64,254,0,0,15,208,63,128,63,0,252,0,0,47,133,191,0,63,1,252,0,0,191,255,253,0,127,2,255,254,0,127,255,252,0,127,3,255,255,64,63,239,240,0,127,131,255,255,0,16,15,208,0,191,192,0,127,0,0,63,128,0,191,208,0,254,0,0,191,0,0,255,224,0,252,0,1,253,27,192,255,240,1,252,0,3,255,255,192,255,248,3,248,0,15,255,255,129,252,253,7,240,0,127,255,228,2,248,191,15,224,0,127,249,0,3,248,63,95,192,0,62,64,0,3,244,47,255,128,0,16,0,1,199,240,15,255,0,0,0,0,111,207,224,7,254,0,0,0,11,255,239,208,7,254,0,0,1,255,255,111,192,31,255,128,0,47,255,224,63,128,127,255,224,0,63,253,0,191,2,255,79,253,0,63,144,1,254,31,253,3,255,128,40,0,3,252,127,244,0,255,208,0,0,2,248,47,128,0,47,128,0,0,0,48,13,0,0,2,0,0,0,0,0,0,0,0,0,0,
  // 0x7ebf  线
  191,126,33,34,50,36,2,253,0,9,0,0,3,240,0,0,0,0,15,192,0,3,240,184,0,0,0,31,192,0,3,241,255,64,0,0,63,128,0,3,240,63,224,0,0,127,0,0,3,240,11,208,0,0,191,0,0,3,240,1,64,0,0,253,0,0,3,240,5,164,0,2,248,0,0,3,251,255,248,0,3,240,29,6,191,255,255,252,0,15,224,63,159,255,255,254,144,0,31,192,127,15,255,249,0,0,0,63,65,254,10,83,248,0,0,0,255,255,252,0,2,248,0,0,0,255,255,244,0,2,248,0,89,0,191,255,224,0,1,253,175,254,0,16,47,192,0,6,255,255,255,0,0,127,64,27,255,255,255,228,0,0,254,0,63,255,255,144,0,0,3,252,0,63,254,253,0,32,0,11,240,107,25,0,254,0,190,0,47,255,255,0,0,190,1,253,0,255,255,255,0,0,127,3,248,0,191,255,144,0,0,127,15,240,0,127,144,0,0,0,63,191,192,0,16,0,0,0,0,63,255,0,0,0,0,2,0,0,47,252,0,0,0,1,191,0,0,127,240,0,0,0,111,255,64,3,255,224,8,0,111,255,254,0,47,255,240,15,64,255,255,128,7,255,247,252,15,64,191,224,0,191,255,65,255,111,64,116,0,0,191,244,0,255,255,0,0,0,0,62,64,0,63,254,0,0,0,0,0,0,0,7,248,0,
  // 0x7ec6  细
  198,126,33,34,50,36,1,253,0,1,208,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,7,244,11,255,255,255,255,64,0,15,240,11,255,255,255,255,64,0,31,208,11,255,255,255,255,64,0,63,192,11,229,95,213,127,64,0,127,64,11,224,15,192,63,64,0,254,0,11,224,15,192,63,64,2,252,1,11,224,15,192,63,64,3,244,3,219,224,15,192,63,64,15,224,15,251,224,15,192,63,64,63,213,175,219,224,15,192,63,64,191,255,255,139,224,15,192,63,64,127,255,255,11,224,15,192,63,64,63,167,252,11,224,15,192,63,64,0,11,244,11,255,255,255,255,64,0,31,208,11,255,255,255,255,64,0,127,64,11,255,255,255,255,64,1,254,0,11,224,15,192,63,64,7,253,111,219,224,15,192,63,64,31,255,255,235,224,15,192,63,64,127,255,255,219,224,15,192,63,64,63,255,164,11,224,15,192,63,64,46,80,0,11,224,15,192,63,64,0,0,0,11,224,15,192,63,64,0,0,0,11,224,15,192,63,64,0,0,0,91,224,15,192,63,64,0,5,191,235,224,15,192,63,64,26,255,255,235,255,255,255,255,64,127,255,255,219,255,255,255,255,64,127,254,144,11,255,255,255,255,64,58,64,0,11,224,0,0,63,64,0,0,0,11,224,0,0,63,64,0,0,0,1,64,0,0,0,0,
  // 0x7ec8  终
  200,126,34,34,50,36,1,253,0,6,64,0,1,164,0,0,0,0,11,240,0,3,252,0,0,0,0,15,224,0,7,244,0,0,0,0,31,192,0,15,240,0,0,0,0,63,128,0,47,255,255,248,0,0,127,64,0,63,255,255,253,0,0,191,0,0,255,255,255,252,0,0,253,0,2,255,0,3,244,0,3,248,9,11,255,192,15,240,0,7,240,31,239,255,224,47,192,0,15,224,63,255,199,244,127,64,0,47,192,127,47,1,254,254,0,0,191,255,254,4,0,191,252,0,0,127,255,252,0,0,63,240,0,0,63,255,240,0,0,255,252,0,0,16,15,224,0,11,255,255,64,0,0,63,192,0,127,248,191,244,0,0,191,0,7,255,208,31,255,64,1,252,0,63,254,0,3,255,240,7,244,22,111,244,16,0,127,192,31,255,255,143,64,253,0,7,64,127,255,255,128,2,255,224,0,0,63,255,233,0,0,111,253,0,0,63,144,0,0,0,2,255,64,0,0,0,0,0,0,0,127,0,0,0,0,0,0,0,0,8,0,0,0,0,1,128,126,64,0,0,0,0,6,255,209,255,248,0,0,0,107,255,255,208,191,255,208,0,0,191,255,254,64,2,255,254,0,0,127,254,64,0,0,27,255,224,0,57,0,0,0,0,0,191,252,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,0,0,144,0,
  // 0x7ed3  结
  211,126,33,34,50,36,1,253,0,6,0,0,0,31,192,0,0,0,11,224,0,0,31,192,0,0,0,15,240,0,0,31,192,0,0,0,31,208,0,0,31,192,0,0,0,63,192,0,0,31,208,0,0,0,127,64,15,255,255,255,255,192,0,255,0,15,255,255,255,255,192,1,253,0,15,255,255,255,255,192,3,248,11,128,0,31,192,0,0,11,240,31,224,0,31,192,0,0,31,208,63,192,0,31,192,0,0,127,218,191,128,0,31,192,0,0,191,255,255,0,0,31,192,0,0,127,255,252,7,255,255,255,255,0,63,175,248,7,255,255,255,255,0,0,15,240,7,255,255,255,255,0,0,63,192,0,0,0,0,0,0,0,191,64,0,0,0,0,0,0,1,254,0,0,0,0,0,0,0,7,252,26,208,0,0,0,0,0,31,255,255,225,255,255,255,253,0,127,255,255,225,255,255,255,253,0,63,255,233,1,255,255,255,253,0,63,148,0,1,252,0,0,253,0,0,0,0,1,252,0,0,253,0,0,0,0,1,252,0,0,253,0,0,0,5,161,252,0,0,253,0,0,27,255,241,252,0,0,253,0,111,255,255,241,252,0,0,253,0,191,255,254,65,255,255,255,253,0,127,249,0,1,255,255,255,253,0,37,0,0,1,255,255,255,253,0,0,0,0,1,252,0,0,253,0,0,0,0,1,248,0,0,169,0,
  // 0x7ed9  给
  217,126,33,34,50,36,1,253,0,6,0,0,0,41,0,0,0,0,11,224,0,0,63,64,0,0,0,15,224,0,0,191,64,0,0,0,31,192,0,0,255,192,0,0,0,63,128,0,1,255,224,0,0,0,127,64,0,3,255,240,0,0,0,255,0,0,11,242,252,0,0,1,253,0,0,31,224,254,0,0,3,248,15,64,63,192,127,128,0,7,240,47,192,255,64,47,224,0,15,208,63,131,254,0,15,248,0,47,197,191,15,252,0,3,255,0,191,255,253,63,255,255,255,255,192,127,255,252,255,255,255,255,191,128,63,239,240,63,63,255,255,79,0,16,15,224,8,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,191,0,0,0,0,0,0,0,1,253,0,0,0,0,0,0,0,3,248,26,131,255,255,255,240,0,15,255,255,131,255,255,255,240,0,127,255,255,131,255,255,255,240,0,63,255,164,3,244,0,7,240,0,63,144,0,3,244,0,7,240,0,0,0,0,3,244,0,7,240,0,0,0,0,3,244,0,7,240,0,0,0,6,195,244,0,7,240,0,0,27,255,195,244,0,7,240,0,43,255,255,195,244,0,7,240,0,127,255,249,3,255,255,255,240,0,63,249,0,3,255,255,255,240,0,57,0,0,3,255,255,255,240,0,0,0,0,3,244,0,7,240,0,0,0,0,3,244,0,7,240,0,
  // 0x7edf  统
  223,126,34,34,50,36,1,253,0,7,64,0,0,110,0,0,0,0,11,240,0,0,191,0,0,0,0,15,240,0,0,63,128,0,0,0,31,208,0,0,47,192,0,0,0,63,192,0,0,31,128,0,0,0,127,64,31,255,255,255,255,192,0,255,0,31,255,255,255,255,192,1,253,4,31,255,255,255,255,192,3,248,15,64,3,252,0,0,0,11,240,47,192,11,244,2,0,0,31,208,127,128,15,240,31,192,0,127,218,255,0,63,192,15,224,0,191,255,253,0,191,64,7,244,0,127,255,248,2,254,0,7,252,0,63,175,240,31,254,191,255,254,0,0,31,208,63,255,255,255,255,0,0,63,128,47,255,255,234,127,192,0,255,0,31,165,0,0,31,192,2,252,6,64,63,64,252,9,0,11,254,255,64,63,64,252,0,0,47,255,255,64,63,0,252,0,0,127,255,254,0,63,0,252,0,0,63,249,0,0,63,0,252,0,0,45,0,0,0,127,0,252,0,0,0,0,0,0,190,0,252,0,0,0,0,27,64,254,0,252,6,0,0,6,255,129,252,0,252,7,208,1,191,255,131,252,0,252,7,208,63,255,248,11,244,0,252,7,208,63,254,64,63,240,0,252,11,192,63,208,2,255,192,0,255,255,192,36,0,3,255,0,0,255,255,128,0,0,0,252,0,0,47,254,0,0,0,0,80,0,0,0,0,0,
  // 0x7ee7  继
  231,126,34,32,32,36,1,255,0,10,0,0,0,0,164,0,0,0,15,208,10,64,0,248,0,0,0,31,192,31,128,0,248,4,0,0,47,192,31,143,128,248,31,64,0,63,64,31,139,192,248,47,0,0,127,0,31,131,208,248,62,0,0,253,0,31,131,224,248,124,0,1,252,0,31,130,240,248,248,0,3,244,14,31,129,240,248,240,0,7,240,47,223,128,144,248,160,0,15,208,63,95,128,0,248,0,0,47,192,191,31,159,255,255,255,192,191,255,252,31,159,255,255,255,192,127,255,248,31,159,255,255,255,192,63,239,240,31,128,7,253,0,0,16,15,208,31,128,15,255,0,0,0,63,128,31,128,31,255,192,0,0,191,0,31,128,63,255,224,0,1,252,0,31,128,125,250,244,0,3,244,107,95,128,248,248,252,0,15,255,255,31,131,240,248,127,0,127,255,255,31,139,224,248,47,128,63,254,144,31,159,192,248,15,64,46,64,0,31,143,64,248,6,0,0,0,0,31,134,0,248,0,0,0,0,0,31,128,0,248,0,0,0,0,111,159,128,0,248,0,0,1,111,255,159,128,0,244,0,0,127,255,255,95,128,0,0,0,0,127,255,144,31,255,255,255,255,208,63,144,0,31,255,255,255,255,208,16,0,0,31,255,255,255,255,208,
  // 0x7eea  绪
  234,126,34,35,59,36,1,252,0,6,0,0,0,252,0,0,0,0,11,224,0,0,252,0,0,0,0,15,208,0,0,252,0,46,0,0,31,192,0,0,252,0,63,64,0,63,64,11,255,255,254,191,0,0,127,0,11,255,255,255,253,0,0,253,0,11,255,255,255,252,0,1,252,0,0,0,252,11,240,0,3,244,15,64,0,252,31,224,0,7,224,31,192,0,252,63,192,0,15,192,63,128,0,252,255,0,0,47,149,191,127,255,255,255,255,224,191,255,253,127,255,255,255,255,224,63,255,248,127,255,255,255,255,224,63,155,240,0,0,255,128,0,0,16,15,224,0,3,255,0,0,0,0,47,192,0,15,252,0,0,0,0,63,0,0,127,240,0,0,0,0,253,0,2,255,255,255,254,0,2,248,5,31,255,255,255,254,0,11,255,255,255,255,255,255,254,0,47,255,254,191,255,0,0,190,0,63,255,233,61,127,0,0,190,0,63,228,0,0,127,0,0,190,0,20,0,0,0,127,255,255,254,0,0,0,0,0,127,255,255,254,0,0,0,1,128,127,170,170,254,0,0,5,191,192,127,0,0,190,0,6,255,255,192,127,0,0,190,0,127,255,254,64,127,0,0,190,0,63,254,64,0,127,255,255,254,0,63,128,0,0,127,255,255,254,0,0,0,0,0,127,255,255,254,0,0,0,0,0,127,0,0,189,0,0,0,0,0,0,0,0,0,0,
  // 0x7eed  续
  237,126,33,35,59,36,1,252,0,2,0,0,0,63,64,0,0,0,7,224,0,0,63,64,0,0,0,15,208,0,0,63,64,0,0,0,15,192,3,255,255,255,248,0,0,47,128,3,255,255,255,252,0,0,63,0,3,255,255,255,252,0,0,190,0,0,0,63,64,0,0,0,252,0,0,0,63,64,0,0,2,248,29,0,0,63,64,0,0,3,240,63,111,255,255,255,255,64,11,208,127,47,255,255,255,255,64,31,192,253,31,255,255,255,255,0,127,255,252,0,0,0,0,63,0,127,255,240,0,52,15,192,126,0,63,239,224,0,255,15,192,188,0,16,31,192,0,47,223,192,252,0,0,63,64,9,7,223,192,16,0,0,190,0,31,192,79,192,0,0,1,252,26,11,244,15,192,0,0,7,251,254,1,252,15,192,0,0,15,255,254,0,52,31,192,0,0,63,255,144,127,255,255,255,255,128,63,228,0,127,255,255,255,255,128,40,0,0,127,255,255,255,255,128,0,0,6,0,0,254,0,0,0,0,1,191,0,1,252,36,0,0,0,47,255,0,7,252,254,0,0,7,255,249,0,15,240,191,128,0,127,255,128,0,127,208,47,240,0,63,244,0,2,255,64,7,252,0,62,0,0,31,253,0,0,255,0,16,0,0,255,240,0,0,63,192,0,0,0,63,128,0,0,15,128,0,0,0,24,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
  // 0x7eff  绿
  255,126,34,34,50,36,1,253,0,14,0,0,0,0,0,0,0,0,15,208,3,255,255,255,252,0,0,31,192,3,255,255,255,252,0,0,63,128,3,255,255,255,252,0,0,127,64,0,0,0,0,252,0,0,191,0,0,0,0,0,252,0,0,253,0,0,0,0,0,252,0,2,252,0,1,255,255,255,252,0,3,244,29,1,255,255,255,252,0,7,240,63,65,170,170,170,252,0,15,208,127,0,0,0,1,248,0,47,192,254,0,0,0,1,248,0,191,255,252,0,0,0,2,248,0,127,255,244,15,255,255,255,255,208,63,255,240,15,255,255,255,255,208,20,31,208,15,255,255,255,255,208,0,63,128,0,0,31,192,0,0,0,191,0,1,64,31,192,8,0,1,252,0,11,224,31,192,63,128,3,244,26,7,248,31,192,255,128,15,255,254,1,254,31,195,253,0,63,255,254,0,127,31,239,240,0,63,255,148,0,44,47,255,128,0,47,144,0,0,1,255,254,0,0,0,0,0,0,11,255,255,0,0,0,0,1,0,127,239,239,192,0,0,1,190,2,255,95,207,244,0,0,111,255,31,248,31,195,254,0,31,255,253,127,208,31,192,255,224,127,255,128,47,0,31,192,47,192,63,228,0,8,0,31,192,7,64,57,0,0,0,11,255,128,0,0,0,0,0,0,7,255,64,0,0,0,0,0,0,3,249,0,0,0,
  // 0x7f16  编
  22,127,33,34,50,36,1,253,0,10,0,0,0,47,0,0,0,0,15,208,0,0,63,64,0,0,0,31,192,0,0,63,192,0,0,0,47,128,0,0,31,208,0,0,0,63,0,15,255,255,255,255,0,0,126,0,15,255,255,255,255,0,0,253,0,15,255,255,255,255,0,1,252,0,15,192,0,0,63,0,3,244,45,15,192,0,0,63,0,7,240,63,15,192,0,0,63,0,15,192,190,15,234,170,170,255,0,31,129,252,31,255,255,255,255,0,127,255,248,31,255,255,255,255,0,127,255,240,31,192,0,0,0,0,63,255,224,31,192,0,0,0,0,41,31,192,31,128,0,0,0,0,0,63,64,31,255,255,255,255,64,0,190,0,31,255,255,255,255,64,0,252,0,47,254,191,191,175,64,3,244,104,47,252,46,31,15,64,15,255,252,47,252,46,31,15,64,63,255,252,63,252,46,31,15,64,63,255,144,63,188,46,31,15,64,63,144,0,63,190,191,191,175,64,16,0,0,126,191,255,255,255,64,0,0,108,189,191,255,255,255,64,0,11,253,253,188,46,31,15,64,1,191,253,252,188,46,31,15,64,47,255,145,248,188,46,31,15,64,127,248,3,244,188,46,31,15,64,63,64,7,240,188,46,31,15,64,36,0,11,224,188,46,31,191,64,0,0,1,192,188,25,9,127,0,0,0,0,0,84,0,0,20,0,
  // 0x7f3a  缺
  58,127,34,34,50,36,1,253,2,144,0,0,0,47,128,0,0,3,244,0,0,0,47,128,0,0,3,240,0,0,0,47,128,0,0,7,240,0,0,0,47,128,0,0,11,240,0,0,0,47,128,0,0,15,255,255,252,0,47,128,0,0,15,255,255,252,191,255,255,252,0,31,255,255,252,191,255,255,252,0,47,135,240,0,191,255,255,252,0,63,71,240,0,0,47,128,252,0,191,7,240,0,0,47,128,252,0,126,7,240,0,0,47,128,252,0,8,7,240,0,0,47,128,252,0,127,255,255,254,0,47,128,252,0,127,255,255,254,0,47,128,252,0,127,255,255,254,0,47,128,252,0,0,7,240,0,0,47,128,252,0,0,7,240,0,255,255,255,255,224,26,7,240,188,255,255,255,255,224,31,7,240,188,255,255,255,255,224,31,7,240,188,0,63,240,0,0,31,7,240,188,0,127,248,0,0,31,7,240,188,0,191,252,0,0,31,7,240,188,0,254,253,0,0,31,7,240,188,1,252,191,0,0,31,7,240,188,3,252,63,64,0,31,255,255,252,11,244,63,192,0,31,255,255,252,31,224,15,240,0,31,255,255,252,127,192,11,248,0,31,0,0,189,255,64,3,254,0,31,0,0,31,254,0,0,255,208,26,0,0,47,248,0,0,127,208,0,0,0,11,208,0,0,31,128,0,0,0,2,64,0,0,2,0,
  // 0x7f51  网
  81,127,30,32,0,36,3,253,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,255,255,255,255,255,255,255,240,254,0,31,128,3,240,7,240,253,0,31,128,3,240,3,240,253,0,31,128,3,240,3,240,253,0,31,128,3,240,3,240,253,0,31,64,3,240,3,240,253,0,47,66,3,240,3,240,253,60,47,75,199,224,3,240,253,191,47,15,247,224,3,240,253,63,255,3,255,208,3,240,253,15,255,0,255,208,3,240,253,3,255,0,63,208,3,240,253,0,255,0,31,224,3,240,253,0,127,128,15,248,3,240,253,0,191,208,15,253,3,240,253,0,255,240,31,255,3,240,253,0,255,252,47,127,195,240,253,1,252,252,63,15,211,240,253,2,244,116,63,7,131,240,253,3,240,16,190,2,3,240,253,7,240,0,253,0,3,240,253,15,224,1,252,0,3,240,253,31,192,3,248,0,3,240,253,63,128,11,240,0,3,240,253,191,0,31,224,0,3,240,253,46,0,11,192,0,3,240,253,4,0,1,0,0,11,240,253,0,0,0,0,31,255,240,253,0,0,0,0,15,255,208,253,0,0,0,0,15,254,64,
  // 0x7f6e  置
  110,127,33,34,50,36,2,252,5,85,85,85,85,85,85,80,0,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,15,208,11,208,11,224,7,240,0,15,208,11,208,11,224,7,240,0,15,229,95,229,91,229,91,240,0,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,106,170,170,175,234,170,170,169,0,0,0,0,15,192,0,0,0,0,0,0,63,255,255,255,255,128,0,11,240,63,255,255,255,255,128,0,11,240,63,0,0,0,31,128,0,11,240,63,0,0,0,31,128,0,11,240,63,255,255,255,255,128,0,11,240,63,255,255,255,255,128,0,11,240,63,0,0,0,31,128,0,11,240,63,255,255,255,255,128,0,11,240,63,255,255,255,255,128,0,11,240,63,0,0,0,31,128,0,11,240,63,0,0,0,31,128,0,11,240,63,255,255,255,255,128,0,11,240,63,255,255,255,255,128,0,11,240,0,0,0,0,0,0,0,11,240,0,0,0,0,0,0,0,11,255,255,255,255,255,255,255,64,11,255,255,255,255,255,255,255,64,11,250,170,170,170,170,170,170,0,11,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7f72  署
  114,127,33,34,50,36,1,252,1,85,85,85,85,85,85,84,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,3,244,2,244,2,248,0,252,0,3,244,2,244,2,248,0,252,0,3,244,2,244,2,248,0,252,0,3,255,255,255,255,255,255,252,0,3,255,255,255,255,255,255,252,0,1,85,85,95,229,85,85,84,0,0,0,0,11,224,0,0,80,0,0,42,170,175,250,170,130,248,0,0,63,255,255,255,255,219,252,0,0,63,255,255,255,255,255,224,0,0,0,0,11,224,1,255,128,0,0,0,0,11,224,15,253,0,0,42,170,170,175,250,191,254,170,128,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,0,31,255,192,0,0,0,0,0,6,255,253,0,0,0,0,0,0,191,255,249,85,85,80,0,0,111,255,255,255,255,255,240,0,47,255,255,255,255,255,255,240,0,127,255,254,0,0,0,7,240,0,47,228,126,0,0,0,11,240,0,9,0,127,255,255,255,255,240,0,0,0,127,255,255,255,255,240,0,0,0,126,0,0,0,7,240,0,0,0,126,0,0,0,7,240,0,0,0,127,85,85,85,91,240,0,0,0,127,255,255,255,255,240,0,0,0,127,255,255,255,255,240,0,0,0,126,0,0,0,7,224,0,0,0,0,0,0,0,0,0,0,
  // 0x8005  者
  5,128,33,34,50,36,1,253,0,0,0,63,64,0,0,0,0,0,0,0,63,64,0,0,144,0,0,0,0,63,64,0,2,252,0,0,0,0,63,64,0,7,248,0,0,255,255,255,255,255,159,240,0,0,255,255,255,255,255,255,192,0,0,255,255,255,255,255,255,64,0,0,0,0,63,64,3,254,0,0,0,0,0,63,64,15,248,0,0,0,0,0,63,64,63,224,0,0,0,0,0,63,64,255,192,0,0,0,0,0,63,67,255,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,0,47,248,0,0,0,0,0,0,2,255,208,0,0,0,0,0,0,47,254,0,0,0,0,0,0,2,255,255,255,255,255,128,0,0,127,255,255,255,255,255,128,0,11,255,255,255,255,255,255,128,0,191,255,254,0,0,0,63,128,0,63,244,190,0,0,0,63,128,0,30,0,190,0,0,0,63,128,0,0,0,191,255,255,255,255,128,0,0,0,191,255,255,255,255,128,0,0,0,191,170,170,170,191,128,0,0,0,190,0,0,0,63,128,0,0,0,190,0,0,0,63,128,0,0,0,190,0,0,0,63,128,0,0,0,191,255,255,255,255,128,0,0,0,191,255,255,255,255,128,0,0,0,191,255,255,255,255,128,0,0,0,190,0,0,0,47,128,0,
  // 0x806a  聪
  106,128,34,35,59,36,1,252,0,0,0,0,9,0,2,128,0,0,0,0,0,63,0,3,244,0,63,255,255,240,47,128,7,240,0,63,255,255,240,15,192,15,208,0,63,255,255,240,11,224,31,192,0,7,208,47,0,3,240,47,64,0,7,208,47,0,3,208,63,0,0,7,208,47,1,255,255,255,254,0,7,208,47,2,255,255,255,255,0,7,250,191,2,255,255,255,255,0,7,255,255,2,244,0,0,127,0,7,255,255,2,244,0,0,127,0,7,208,47,2,244,0,0,127,0,7,208,47,2,244,0,0,127,0,7,208,47,2,244,0,0,127,0,7,208,47,2,244,0,0,127,0,7,208,47,2,255,255,255,255,0,7,255,255,2,255,255,255,255,0,7,255,255,1,255,255,255,254,0,7,250,191,0,0,5,0,0,0,7,208,47,0,0,63,0,0,0,7,208,47,0,1,95,192,0,0,7,208,47,1,11,199,240,40,0,7,208,47,243,235,194,244,188,0,7,235,255,243,219,192,252,62,0,31,255,255,247,219,192,180,47,0,127,255,255,7,203,192,0,15,128,127,249,47,15,203,192,3,143,192,36,0,47,15,139,192,3,231,208,0,0,47,31,75,208,3,211,224,0,0,47,47,7,250,175,194,128,0,0,47,5,3,255,255,192,0,0,0,47,0,1,255,255,0,0,0,0,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x80fd  能
  253,128,34,35,59,36,1,252,0,15,128,0,3,240,0,0,0,0,31,208,0,3,240,0,0,0,0,47,192,16,3,240,0,16,0,0,63,66,240,3,240,1,244,0,0,127,2,252,3,240,47,253,0,0,254,0,253,3,247,255,248,0,1,252,0,191,3,255,254,64,0,7,254,191,255,131,255,208,0,0,127,255,255,255,195,244,0,0,0,127,255,255,255,227,240,0,9,0,127,169,84,7,247,240,0,11,208,0,0,0,3,131,240,0,15,208,0,0,0,0,3,244,0,15,192,7,255,255,254,3,255,255,255,192,7,255,255,254,2,255,255,255,64,7,255,255,254,0,191,255,253,0,7,224,0,190,0,0,0,0,0,7,224,0,190,2,160,0,0,0,7,250,170,254,3,240,0,0,0,7,255,255,254,3,240,0,36,0,7,255,255,254,3,240,2,252,0,7,224,0,190,3,240,47,255,0,7,224,0,190,3,246,255,248,0,7,224,0,190,3,255,255,64,0,7,255,255,254,3,255,224,0,0,7,255,255,254,3,249,0,0,0,7,250,170,254,3,240,0,1,0,7,224,0,190,3,240,0,3,208,7,224,0,190,3,240,0,7,224,7,224,0,190,3,240,0,7,224,7,224,0,190,3,244,0,15,208,7,224,127,254,3,255,255,255,192,7,224,63,252,2,255,255,255,128,7,224,63,224,0,111,255,253,0,0,0,0,0,0,0,0,0,0,
  // 0x81ea  自
  234,129,26,35,245,36,5,252,0,0,3,232,0,0,0,0,0,7,248,0,0,0,0,0,11,240,0,0,0,0,0,15,240,0,0,0,0,0,15,208,0,0,0,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,64,0,0,0,15,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,0,0,0,0,11,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,255,255,255,255,255,240,127,0,0,0,0,11,240,127,0,0,0,0,11,224,0,0,0,0,0,0,0,
  // 0x81f3  至
  243,129,32,31,248,36,2,254,63,255,255,255,255,255,255,253,63,255,255,255,255,255,255,253,63,255,255,255,255,255,255,253,0,0,15,244,0,0,0,0,0,0,31,224,0,124,0,0,0,0,63,192,2,255,64,0,0,0,63,128,0,191,208,0,0,0,191,0,0,47,248,0,0,0,254,0,0,7,254,0,0,2,254,170,191,255,255,192,47,255,255,255,255,255,255,240,47,255,255,255,255,255,255,252,47,255,255,170,85,64,3,253,21,0,0,0,0,0,1,244,0,0,0,15,224,0,0,64,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,3,255,255,255,255,255,255,192,3,255,255,255,255,255,255,192,3,255,255,255,255,255,255,192,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,
  // 0x83dc  菜
  220,131,33,34,50,36,1,253,0,0,47,128,0,47,128,0,0,0,0,47,128,0,47,128,0,0,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,47,255,255,255,255,255,255,255,192,0,0,47,128,0,47,128,0,0,0,0,47,128,0,47,128,0,0,0,0,26,128,0,22,175,128,0,0,0,5,86,175,255,255,224,0,11,255,255,255,255,255,255,244,0,7,255,255,255,255,254,148,0,0,3,255,254,169,84,0,1,64,0,0,0,0,6,192,0,3,248,0,0,124,0,15,208,0,11,244,0,0,255,0,11,240,0,15,224,0,0,63,128,3,244,0,47,192,0,0,47,192,3,248,0,63,128,0,0,15,224,2,224,0,191,0,0,0,11,208,2,248,0,252,0,0,0,1,0,3,248,0,20,0,0,0,0,0,3,248,0,0,0,0,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,1,255,255,240,0,0,0,0,0,11,255,255,253,0,0,0,0,0,127,243,248,255,128,0,0,0,7,255,131,248,63,248,0,0,0,127,253,3,248,11,255,144,0,11,255,240,3,248,0,255,254,64,127,255,64,3,248,0,31,255,192,47,248,0,3,248,0,2,255,64,15,64,0,3,248,0,0,26,0,0,0,0,3,248,0,0,0,0,
  // 0x84dd  蓝
  221,132,33,33,41,36,2,254,0,0,253,0,0,127,0,0,0,0,0,253,0,0,127,0,0,0,191,255,255,255,255,255,255,254,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,0,253,0,0,127,0,0,0,0,0,253,0,0,127,0,0,0,0,0,0,0,1,0,0,0,0,0,0,21,0,11,224,0,0,0,1,64,47,64,15,208,0,0,0,7,240,47,64,15,192,0,0,0,7,240,47,64,47,255,255,248,0,7,240,47,64,63,255,255,248,0,7,240,47,64,127,255,255,244,0,7,240,47,64,254,2,64,0,0,7,240,47,65,252,31,192,0,0,7,240,47,67,248,15,240,0,0,7,240,47,75,240,3,248,0,0,7,240,47,66,208,1,252,0,0,7,240,47,64,64,0,254,0,0,0,0,47,64,0,0,125,0,0,0,0,0,0,0,0,16,0,0,1,255,255,255,255,255,255,128,0,1,255,255,255,255,255,255,128,0,1,254,171,250,175,234,191,128,0,1,252,3,240,15,192,47,128,0,1,252,3,240,15,192,47,128,0,1,252,3,240,15,192,47,128,0,1,252,3,240,15,192,47,128,0,1,252,3,240,15,192,47,128,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,
  // 0x86c7  蛇
  199,134,34,33,41,36,1,254,0,5,64,0,0,11,208,0,0,0,11,192,0,0,15,208,0,0,0,11,192,0,0,15,208,0,0,0,11,192,0,0,15,208,0,0,0,11,192,0,0,15,208,0,0,0,11,192,3,255,255,255,255,192,0,11,192,3,255,255,255,255,192,31,255,255,243,255,255,255,255,192,31,255,255,243,240,0,0,15,192,31,239,235,243,240,0,0,15,192,31,7,194,243,240,0,0,15,192,31,7,194,243,240,0,0,15,192,31,7,194,243,255,192,0,0,0,31,7,194,240,15,192,0,0,0,31,7,194,240,15,192,0,32,0,31,7,194,240,15,192,1,252,0,31,7,194,240,15,192,47,254,0,31,239,235,240,15,194,255,244,0,31,255,255,240,15,255,255,64,0,31,255,255,240,15,255,228,0,0,31,11,192,0,15,253,0,0,0,31,11,192,0,15,208,0,0,0,0,11,194,208,15,192,0,0,0,0,11,195,240,15,192,0,0,0,0,11,194,240,15,192,0,0,0,0,11,193,244,15,192,0,10,0,0,11,193,252,15,192,0,11,208,0,31,255,252,15,192,0,11,192,127,255,255,253,15,192,0,15,192,127,255,255,190,15,192,0,31,192,127,250,64,62,15,255,255,255,128,36,0,0,61,11,255,255,255,0,0,0,0,0,1,255,255,248,0,
  // 0x884c  行
  76,136,34,35,59,36,1,252,0,0,228,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,11,248,3,255,255,255,255,64,0,47,240,3,255,255,255,255,64,0,191,192,3,255,255,255,255,64,3,255,0,0,0,0,0,0,0,15,252,0,0,0,0,0,0,0,127,224,0,0,0,0,0,0,0,63,128,46,64,0,0,0,0,0,29,0,127,128,0,0,0,0,0,0,0,255,0,0,0,0,0,0,0,2,253,0,0,0,0,0,0,0,11,248,47,255,255,255,255,208,0,31,240,47,255,255,255,255,208,0,127,192,47,255,255,255,255,208,1,255,192,0,0,0,127,64,0,7,255,192,0,0,0,127,0,0,47,255,192,0,0,0,127,0,0,191,255,192,0,0,0,127,0,0,127,143,192,0,0,0,127,0,0,46,15,192,0,0,0,127,0,0,8,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,0,0,127,0,0,0,15,192,0,1,85,191,0,0,0,15,192,0,3,255,255,0,0,0,15,192,0,3,255,254,0,0,0,15,192,0,2,255,228,0,0,0,0,0,0,0,0,0,0,0,
  // 0x88ab  被
  171,136,34,34,50,36,1,253,0,47,64,0,0,11,208,0,0,0,47,128,0,0,11,224,0,0,0,47,128,0,0,11,224,0,0,0,47,128,0,0,11,224,0,0,0,47,128,0,0,11,224,0,0,0,47,128,0,0,11,224,0,0,0,47,128,3,255,255,255,255,208,63,255,255,67,255,255,255,255,192,63,255,255,195,255,255,255,255,192,63,255,255,131,240,11,224,47,128,0,0,63,3,240,11,224,63,64,0,0,190,3,240,11,224,63,0,0,1,252,3,240,11,224,126,0,0,3,244,131,240,11,224,0,0,0,15,225,247,255,255,255,254,0,0,47,211,231,255,255,255,255,0,0,191,255,199,255,255,255,254,0,2,255,255,7,255,192,0,253,0,11,255,254,7,239,208,1,252,0,47,255,191,75,231,240,3,248,0,255,239,143,203,227,244,3,244,0,127,47,139,203,210,252,15,240,0,60,47,131,79,208,253,31,208,0,16,47,128,15,192,191,63,192,0,0,47,128,31,192,63,255,64,0,0,47,128,47,128,31,254,0,0,0,47,128,63,64,15,252,0,0,0,47,128,63,0,47,254,0,0,0,47,128,191,0,255,255,208,0,0,47,128,254,7,255,127,248,0,0,47,129,252,127,252,15,255,128,0,47,131,248,255,224,2,255,208,0,47,130,240,127,64,0,127,128,0,47,128,80,36,0,0,7,0,
  // 0x88c5  装
  197,136,34,35,59,36,1,252,0,0,190,0,0,47,128,0,0,0,0,190,0,0,47,128,0,0,7,64,190,0,0,47,128,0,0,31,224,190,0,0,47,128,0,0,11,248,190,0,0,47,128,0,0,1,253,190,63,255,255,255,255,192,0,120,190,63,255,255,255,255,192,0,16,190,63,255,255,255,255,192,0,0,190,0,0,47,128,0,0,0,0,190,0,0,47,128,0,0,0,31,190,0,0,47,128,0,0,1,255,190,0,0,47,128,0,0,47,255,190,0,0,47,128,0,0,127,244,190,15,255,255,255,255,0,63,64,190,15,255,255,255,255,0,20,0,190,11,255,255,255,255,0,0,0,190,0,0,0,0,0,0,0,0,20,3,248,0,0,0,0,0,0,0,3,248,0,0,0,0,42,170,170,171,254,170,170,170,128,63,255,255,255,255,255,255,255,192,63,255,255,255,255,255,255,255,192,0,0,2,255,63,64,0,80,0,0,0,47,248,31,192,2,248,0,0,6,255,208,11,224,31,248,0,1,191,255,0,3,249,255,192,0,127,255,255,0,1,255,253,0,0,47,248,127,0,0,191,224,0,0,9,0,63,0,0,47,244,0,0,0,0,63,90,254,11,255,64,0,0,26,255,255,254,1,255,249,0,0,127,255,255,253,0,47,255,208,0,63,255,148,0,0,2,255,128,0,41,0,0,0,0,0,27,0,0,0,0,0,0,0,0,0,0,
  // 0x8981  要
  129,137,33,34,50,36,2,252,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,127,255,255,255,255,255,255,253,0,0,0,15,208,11,208,0,0,0,0,0,15,208,11,208,0,0,0,0,0,15,208,11,208,0,0,0,10,170,175,250,175,250,170,160,0,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,15,208,15,208,11,208,7,240,0,15,208,15,208,11,208,7,240,0,15,208,15,208,11,208,7,240,0,15,208,15,208,11,208,7,240,0,15,250,175,250,175,250,175,240,0,15,255,255,255,255,255,255,240,0,15,255,255,255,255,255,255,240,0,0,0,3,252,0,0,0,0,0,0,0,11,244,0,0,0,0,0,0,0,15,224,0,0,0,0,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,170,171,255,170,170,191,250,170,0,0,3,252,0,0,63,192,0,0,0,11,244,0,0,191,64,0,0,0,15,244,0,2,254,0,0,0,0,63,255,249,11,252,0,0,0,0,127,255,255,255,240,0,0,0,0,5,6,255,255,244,0,0,0,0,0,1,191,255,255,228,0,0,0,90,255,255,231,255,255,144,0,127,255,255,249,0,27,255,252,0,63,255,254,64,0,0,111,244,0,46,165,0,0,0,0,1,224,0,0,0,0,0,0,0,0,0,0,
  // 0x89d2  角
  210,137,31,35,24,36,1,252,0,0,11,160,0,0,0,0,0,0,15,240,0,0,0,0,0,0,47,255,255,248,0,0,0,0,127,255,255,255,0,0,0,0,255,255,255,254,0,0,0,3,253,0,2,252,0,0,0,15,244,0,7,244,0,0,0,63,224,0,15,224,0,0,0,255,255,255,255,255,255,244,7,255,255,255,255,255,255,244,47,255,255,255,255,255,255,244,15,239,192,0,189,0,3,244,3,79,192,0,189,0,3,244,0,15,192,0,189,0,3,244,0,15,192,0,189,0,3,244,0,15,192,0,189,0,3,244,0,15,255,255,255,255,255,244,0,15,255,255,255,255,255,244,0,15,255,255,255,255,255,244,0,15,192,0,189,0,3,244,0,31,192,0,189,0,3,244,0,31,192,0,189,0,3,244,0,47,192,0,189,0,3,244,0,47,255,255,255,255,255,244,0,63,255,255,255,255,255,244,0,63,255,255,255,255,255,244,0,191,0,0,0,0,3,244,0,253,0,0,0,0,3,244,2,252,0,0,0,0,3,244,7,248,0,0,0,0,3,244,31,240,0,0,0,0,7,244,127,192,0,0,0,255,255,244,63,64,0,0,0,127,255,240,13,0,0,0,0,63,254,64,0,0,0,0,0,0,0,0,
  // 0x8ba1  计
  161,139,34,34,50,36,1,253,0,0,0,0,0,47,128,0,0,0,60,0,0,0,63,192,0,0,0,255,0,0,0,63,192,0,0,0,127,208,0,0,63,192,0,0,0,31,244,0,0,63,192,0,0,0,7,253,0,0,63,192,0,0,0,1,253,0,0,63,192,0,0,0,0,116,0,0,63,192,0,0,0,0,16,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,21,85,64,0,0,63,192,0,0,127,255,224,191,255,255,255,255,208,127,255,224,191,255,255,255,255,208,127,255,224,191,255,255,255,255,208,0,15,224,85,85,127,213,85,64,0,15,224,0,0,63,192,0,0,0,15,224,0,0,63,192,0,0,0,15,224,0,0,63,192,0,0,0,15,224,0,0,63,192,0,0,0,15,224,0,0,63,192,0,0,0,15,224,0,0,63,192,0,0,0,15,224,0,0,63,192,0,0,0,15,224,0,0,63,192,0,0,0,15,224,176,0,63,192,0,0,0,15,227,240,0,63,192,0,0,0,15,255,248,0,63,192,0,0,0,15,255,224,0,63,192,0,0,0,15,255,64,0,63,192,0,0,0,63,252,0,0,63,192,0,0,0,127,224,0,0,63,192,0,0,0,63,64,0,0,63,192,0,0,0,28,0,0,0,63,192,0,0,0,0,0,0,0,63,192,0,0,
  // 0x8bae  议
  174,139,33,34,50,36,2,252,1,128,0,0,11,128,0,0,0,11,224,0,0,31,192,1,64,0,11,244,1,244,15,224,3,248,0,3,252,2,248,11,240,3,248,0,0,255,1,252,3,244,3,244,0,0,127,64,252,2,252,7,240,0,0,47,0,252,1,252,7,240,0,0,8,0,253,0,253,11,240,0,0,0,0,190,0,160,15,224,0,0,0,0,127,0,0,15,208,0,0,0,0,63,64,0,31,192,0,255,254,0,47,128,0,63,128,0,255,254,0,31,192,0,63,64,0,255,254,0,15,208,0,127,0,0,0,190,0,15,224,0,255,0,0,0,190,0,7,240,0,253,0,0,0,190,0,3,248,2,252,0,0,0,190,0,2,252,3,248,0,0,0,190,0,0,254,11,240,0,0,0,190,0,0,191,15,224,0,0,0,190,0,0,63,255,192,0,0,0,190,0,0,47,255,64,0,0,0,190,0,0,15,255,0,0,0,0,190,3,0,7,253,0,0,0,0,190,31,0,15,255,0,0,0,0,191,255,128,63,255,192,0,0,0,191,255,0,255,255,244,0,0,0,255,248,7,254,15,254,0,0,0,255,208,47,248,2,255,208,0,3,254,2,255,224,0,191,254,0,2,248,31,255,64,0,31,255,128,0,208,15,248,0,0,2,255,0,0,0,7,128,0,0,0,44,0,0,0,0,0,0,0,0,0,0,
  // 0x8bbe  设
  190,139,33,35,59,36,1,252,0,16,0,0,0,0,0,0,0,0,248,0,0,191,255,255,64,0,2,254,0,0,191,255,255,64,0,0,191,192,0,191,255,255,64,0,0,47,240,0,189,0,63,64,0,0,11,248,0,189,0,63,64,0,0,2,244,0,253,0,63,64,0,0,0,208,0,252,0,63,64,0,0,0,0,1,252,0,63,64,0,0,0,0,3,248,0,63,64,0,0,0,0,11,244,0,63,64,0,0,0,0,47,240,0,47,255,192,127,255,129,255,192,0,31,255,192,127,255,129,255,0,0,6,255,128,127,255,128,120,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,47,128,63,255,255,255,248,0,0,47,128,63,255,255,255,252,0,0,47,128,63,255,255,255,252,0,0,47,128,11,208,0,3,244,0,0,47,128,7,240,0,11,240,0,0,47,128,3,248,0,15,208,0,0,47,128,1,253,0,63,192,0,0,47,128,0,191,0,191,64,0,0,47,131,64,63,194,254,0,0,0,47,159,192,15,251,252,0,0,0,47,255,192,7,255,240,0,0,0,63,255,0,3,255,192,0,0,0,63,248,0,31,255,248,0,0,0,191,224,1,255,255,255,128,0,1,255,64,191,255,130,255,254,64,0,189,3,255,248,0,47,255,192,0,48,0,255,128,0,6,255,64,0,0,0,164,0,0,0,27,0,0,0,0,0,0,0,0,0,0,
  // 0x8bd5  试
  213,139,33,34,50,36,2,253,0,0,0,0,0,10,128,0,0,1,192,0,0,0,15,215,192,0,7,240,0,0,0,15,219,240,0,7,253,0,0,0,15,211,248,0,1,255,0,0,0,15,208,253,0,0,127,192,0,0,15,208,127,0,0,31,224,0,0,15,208,60,0,0,11,128,0,0,15,224,16,0,0,1,7,255,255,255,255,255,64,0,0,7,255,255,255,255,255,64,0,0,7,255,255,255,255,255,64,0,0,0,0,0,15,224,0,0,255,255,0,0,0,11,224,0,0,255,255,0,0,0,11,224,0,0,255,255,0,0,0,11,224,0,0,0,127,0,0,0,11,240,0,0,0,127,1,255,255,199,240,0,0,0,127,1,255,255,199,240,0,0,0,127,1,255,255,199,240,0,0,0,127,0,3,240,3,240,0,0,0,127,0,3,240,3,244,0,0,0,127,0,3,240,3,244,0,0,0,127,0,3,240,3,248,0,0,0,127,0,3,240,2,248,0,0,0,127,0,3,240,2,252,4,0,0,127,10,3,240,17,252,14,0,0,127,127,3,250,240,253,15,128,0,127,255,7,255,244,254,15,128,0,191,254,255,255,244,191,31,64,1,255,226,255,249,0,127,255,0,3,255,1,254,64,0,63,255,0,1,248,0,128,0,0,31,254,0,0,208,0,0,0,0,11,252,0,0,0,0,0,0,0,2,240,0,
  // 0x8bef  误
  239,139,34,34,50,36,1,252,0,144,0,0,0,0,0,0,0,2,244,0,15,255,255,255,252,0,3,254,0,15,255,255,255,252,0,0,255,128,15,255,255,255,252,0,0,63,224,15,192,0,0,252,0,0,15,240,15,192,0,0,252,0,0,3,208,15,192,0,0,252,0,0,1,64,15,192,0,0,252,0,0,0,0,15,255,255,255,252,0,0,0,0,15,255,255,255,252,0,127,255,128,15,255,255,255,252,0,127,255,128,0,0,0,0,0,0,127,255,128,0,0,0,0,0,0,0,47,128,0,0,0,0,0,0,0,47,128,47,255,255,255,255,0,0,47,128,47,255,255,255,255,0,0,47,128,47,255,255,255,255,0,0,47,128,0,0,63,0,0,0,0,47,128,0,0,63,0,0,0,0,47,128,0,0,127,0,0,0,0,47,128,255,255,255,255,255,224,0,47,128,255,255,255,255,255,224,0,47,128,255,255,255,255,255,224,0,47,129,0,1,255,192,0,0,0,47,139,64,3,255,240,0,0,0,47,255,128,7,251,244,0,0,0,47,255,128,31,242,253,0,0,0,63,253,0,127,192,255,128,0,0,191,240,3,255,64,63,244,0,0,191,128,127,253,0,31,255,64,0,61,1,255,240,0,3,255,208,0,36,0,191,128,0,0,191,128,0,0,0,52,0,0,0,11,0,0,0,0,0,0,0,0,0,0,
  // 0x8bf7  请
  247,139,34,34,50,36,1,253,0,0,0,0,0,63,0,0,0,0,208,0,0,0,63,0,0,0,3,248,0,0,0,63,0,0,0,3,254,0,63,255,255,255,255,64,0,191,128,63,255,255,255,255,64,0,47,224,21,85,191,149,85,0,0,11,240,0,0,63,0,0,0,0,2,192,31,255,255,255,253,0,0,0,0,31,255,255,255,253,0,0,0,0,5,85,127,85,84,0,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,127,255,129,255,255,255,255,255,208,127,255,129,255,255,255,255,255,208,127,255,128,85,85,85,85,85,64,0,31,128,0,0,0,0,0,0,0,31,128,15,255,255,255,252,0,0,31,128,15,255,255,255,252,0,0,31,128,15,234,170,170,252,0,0,31,128,15,192,0,1,252,0,0,31,128,15,192,0,1,252,0,0,31,128,15,255,255,255,252,0,0,31,128,15,255,255,255,252,0,0,31,128,15,213,85,86,252,0,0,31,130,79,192,0,1,252,0,0,31,143,143,192,0,1,252,0,0,31,255,207,255,255,255,252,0,0,47,255,79,255,255,255,252,0,0,63,252,15,213,85,86,252,0,0,127,240,15,192,0,1,252,0,0,255,128,15,192,0,1,252,0,0,189,0,15,192,2,255,248,0,0,52,0,15,192,1,255,244,0,0,0,0,15,192,0,254,64,0,
  // 0x8bfb  读
  251,139,33,35,59,36,1,252,0,0,0,0,0,127,0,0,0,0,224,0,0,0,127,0,0,0,3,248,0,0,0,127,0,0,0,3,255,0,31,255,255,255,252,0,0,191,192,47,255,255,255,252,0,0,47,240,47,255,255,255,252,0,0,11,240,0,0,127,0,0,0,0,2,192,0,0,127,0,0,0,0,0,64,0,0,127,0,0,0,0,0,0,255,255,255,255,255,64,0,0,0,255,255,255,255,255,64,0,0,0,191,255,255,255,255,0,127,255,64,0,0,0,0,63,0,127,255,64,1,208,10,64,125,0,127,255,64,3,253,31,192,252,0,0,47,64,0,191,159,192,252,0,0,47,64,20,15,239,192,16,0,0,47,64,190,2,95,128,0,0,0,47,64,47,224,31,128,0,0,0,47,64,3,248,47,128,0,0,0,47,64,0,176,63,64,0,0,0,47,66,255,255,255,255,255,192,0,47,66,255,255,255,255,255,192,0,47,66,255,255,255,255,255,192,0,47,78,0,1,253,0,0,0,0,47,191,0,3,252,48,0,0,0,47,255,64,15,244,253,0,0,0,47,253,0,63,224,255,128,0,0,63,244,0,255,192,47,240,0,0,63,208,11,255,0,7,253,0,0,255,0,127,252,0,1,255,64,0,252,3,255,224,0,0,63,192,0,48,1,255,0,0,0,15,192,0,0,0,180,0,0,0,3,0,0,0,0,0,0,0,0,0,0,
  // 0x8c03  调
  3,140,32,34,16,36,1,252,0,144,0,0,0,0,0,0,2,244,0,127,255,255,255,255,3,253,0,127,255,255,255,255,0,255,64,127,255,255,255,255,0,63,208,126,0,0,0,63,0,15,240,126,0,62,0,63,0,3,208,126,0,62,0,63,0,1,64,126,5,127,84,63,0,0,0,126,31,255,253,63,0,0,0,126,31,255,253,63,0,0,0,126,0,62,0,63,127,255,128,126,0,62,0,63,127,255,128,126,0,62,0,63,127,255,128,126,63,255,255,63,0,47,128,126,63,255,255,63,0,47,128,126,21,85,85,63,0,47,128,126,0,0,0,63,0,47,128,126,0,0,0,63,0,47,128,126,47,255,252,63,0,47,128,125,47,255,252,63,0,47,128,189,47,85,188,63,0,47,128,252,47,0,124,63,0,47,128,252,47,0,124,63,0,47,136,252,47,0,124,63,0,47,190,252,47,85,188,63,0,47,255,248,47,255,252,63,0,63,255,244,47,255,252,63,0,63,247,240,47,0,0,63,0,191,215,240,26,0,0,63,1,255,15,208,0,0,0,63,1,252,31,192,0,0,63,255,0,112,31,128,0,0,47,254,0,0,3,0,0,0,31,244,0,0,0,0,0,0,0,0,
  // 0x8d25  败
  37,141,33,35,59,36,2,252,0,0,0,0,0,64,0,0,0,0,0,0,0,0,252,0,0,0,63,255,255,244,1,252,0,0,0,63,255,255,244,2,248,0,0,0,63,255,255,244,2,244,0,0,0,63,0,1,244,3,240,0,0,0,63,0,1,244,7,240,0,0,0,63,5,65,244,11,255,255,255,0,63,11,193,244,15,255,255,255,0,63,11,193,244,31,255,255,255,0,63,11,193,244,63,128,3,224,0,63,11,193,244,63,0,7,208,0,63,11,193,244,191,0,7,208,0,63,11,193,244,255,0,11,192,0,63,11,193,247,255,0,15,192,0,63,11,193,251,255,128,15,192,0,63,11,193,246,255,192,31,128,0,63,11,193,244,207,192,47,64,0,63,11,193,244,7,224,63,0,0,63,15,193,244,3,240,63,0,0,63,15,193,244,2,248,125,0,0,63,15,193,244,0,252,252,0,0,63,15,193,244,0,191,252,0,0,63,31,129,244,0,63,244,0,0,21,47,64,0,0,47,240,0,0,0,63,8,0,0,15,224,0,0,0,126,62,0,0,47,248,0,0,0,253,63,64,0,191,254,0,0,2,252,15,192,2,253,255,64,0,11,240,11,240,11,248,63,224,0,47,208,3,248,127,224,15,252,0,255,128,0,253,255,128,3,255,64,189,0,0,160,253,0,0,190,0,52,0,0,0,32,0,0,8,0,0,0,0,0,0,0,0,0,0,
  // 0x8d2a  贪
  42,141,33,35,59,36,2,252,0,0,0,2,224,0,0,0,0,0,0,0,15,248,0,0,0,0,0,0,0,127,253,0,0,0,0,0,0,7,255,255,208,0,0,0,0,0,127,252,47,254,0,0,0,0,11,255,210,3,255,228,0,0,1,255,254,31,128,127,255,144,0,191,255,224,31,240,7,255,255,64,255,253,0,3,252,0,47,255,0,127,144,0,1,244,0,1,188,0,20,127,255,255,255,255,240,0,0,0,127,255,255,255,255,252,0,0,0,42,170,170,170,191,240,0,0,0,0,0,0,0,127,192,0,0,0,0,0,0,1,255,0,0,0,0,0,0,0,2,252,0,0,0,0,191,255,255,255,255,253,0,0,0,191,255,255,255,255,253,0,0,0,191,255,255,255,255,253,0,0,0,190,0,0,0,0,253,0,0,0,190,0,11,224,0,253,0,0,0,190,0,15,224,0,253,0,0,0,190,0,15,224,0,253,0,0,0,190,0,15,224,0,253,0,0,0,190,0,15,208,0,253,0,0,0,190,0,47,192,0,253,0,0,0,190,0,127,197,0,253,0,0,0,0,1,255,31,228,0,0,0,0,0,31,253,63,255,128,0,0,0,1,255,244,6,255,253,0,0,1,191,255,128,0,31,255,224,0,47,255,248,0,0,1,191,252,0,15,255,64,0,0,0,11,240,0,7,208,0,0,0,0,0,160,0,0,0,0,0,0,0,0,0,0,
  // 0x8d77  起
  119,141,34,35,59,36,1,252,0,1,164,0,0,0,0,0,0,0,2,248,0,0,0,0,0,0,0,2,248,0,11,255,255,254,0,0,2,248,0,11,255,255,254,0,15,255,255,255,11,255,255,254,0,15,255,255,255,0,0,0,190,0,15,255,255,255,0,0,0,190,0,0,2,248,0,0,0,0,190,0,0,2,248,0,0,0,0,190,0,0,2,248,0,0,0,0,190,0,0,2,248,0,0,0,0,190,0,63,255,255,255,194,170,170,254,0,63,255,255,255,199,255,255,254,0,63,255,255,255,199,255,255,254,0,0,0,253,0,7,240,0,190,0,0,0,253,0,7,240,0,0,0,0,0,253,0,7,240,0,0,0,11,208,253,0,7,240,0,0,0,11,208,253,0,7,240,0,0,0,11,208,255,255,135,240,0,0,0,11,208,255,255,135,240,0,7,64,15,208,255,255,135,240,0,7,224,15,224,253,0,7,240,0,11,208,15,240,253,0,7,240,0,11,208,15,240,253,0,7,240,0,31,192,15,252,253,0,3,255,255,255,192,31,253,253,0,2,255,255,255,64,31,255,253,0,0,191,255,253,0,47,175,253,0,0,0,0,0,0,63,79,255,229,80,0,0,0,64,63,2,255,255,255,255,255,255,208,191,0,47,255,255,255,255,255,192,253,0,0,111,255,255,255,255,128,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x8d85  超
  133,141,34,34,50,36,1,253,0,3,244,0,0,0,0,0,0,0,3,244,0,63,255,255,255,64,0,3,244,0,63,255,255,255,64,0,3,244,0,63,255,255,255,64,31,255,255,254,0,63,64,63,64,31,255,255,254,0,63,0,63,0,31,255,255,254,0,127,0,63,0,0,3,244,0,0,190,0,63,0,0,3,244,0,0,252,0,63,0,0,3,244,0,2,248,0,127,0,0,3,244,0,11,244,0,254,0,63,255,255,255,111,224,255,253,0,63,255,255,255,255,128,127,252,0,63,255,255,255,254,0,42,144,0,0,1,248,0,20,0,0,0,0,0,1,248,0,10,170,170,169,0,10,129,248,0,15,255,255,254,0,11,209,248,0,15,255,255,254,0,15,193,248,0,15,192,0,190,0,15,193,255,255,15,192,0,190,0,15,193,255,255,15,192,0,190,0,15,193,255,255,15,192,0,190,0,15,209,248,0,15,192,0,190,0,15,241,248,0,15,192,0,190,0,15,241,248,0,15,234,170,254,0,15,253,248,0,15,255,255,254,0,31,255,248,0,15,255,255,254,0,47,255,248,0,0,0,0,0,0,47,111,252,0,0,0,0,0,0,63,15,255,229,80,0,0,1,64,127,2,255,255,255,255,255,255,208,190,0,47,255,255,255,255,255,192,188,0,0,111,255,255,255,255,128,8,0,0,0,0,0,0,0,0,
  // 0x8ddd  距
  221,141,34,33,41,36,1,253,11,255,255,244,0,0,0,0,0,15,255,255,244,127,255,255,255,192,15,255,255,244,127,255,255,255,192,15,192,3,244,127,255,255,255,192,15,192,3,244,127,0,0,0,0,15,192,3,244,127,0,0,0,0,15,192,3,244,127,0,0,0,0,15,192,3,244,127,0,0,0,0,15,192,3,244,127,0,0,0,0,15,255,255,244,127,255,255,254,0,15,255,255,244,127,255,255,254,0,15,255,255,244,127,255,255,254,0,0,3,240,0,127,0,0,190,0,0,3,240,0,127,0,0,190,0,0,3,240,0,127,0,0,190,0,15,195,240,0,127,0,0,190,0,15,195,240,0,127,0,0,190,0,15,195,255,252,127,0,0,190,0,15,195,255,252,127,0,0,190,0,15,195,255,252,127,255,255,254,0,15,195,240,0,127,255,255,254,0,15,195,240,0,127,255,255,254,0,15,195,240,0,127,0,0,0,0,15,195,240,0,127,0,0,0,0,15,195,240,4,127,0,0,0,0,15,195,246,253,127,0,0,0,0,15,199,255,253,127,0,0,0,0,31,255,255,253,127,0,0,0,0,191,255,254,64,127,255,255,255,224,191,254,64,0,127,255,255,255,224,126,64,0,0,127,255,255,255,224,0,0,0,0,127,0,0,0,0,0,0,0,0,127,0,0,0,0,
  // 0x8f6c  转
  108,143,34,35,59,36,1,252,0,15,128,0,0,7,224,0,0,0,15,192,0,0,11,240,0,0,0,31,192,0,0,11,224,0,0,0,47,128,0,0,15,208,0,0,127,255,255,241,255,255,255,255,0,127,255,255,241,255,255,255,255,0,127,255,255,241,255,255,255,255,0,0,190,0,0,0,63,64,0,0,0,252,0,0,0,127,0,0,0,0,252,0,0,0,191,0,0,0,1,249,248,0,0,254,0,0,0,2,241,252,11,255,255,255,255,208,3,241,252,11,255,255,255,255,208,7,209,252,11,255,255,255,255,208,11,193,252,0,3,248,0,0,0,15,193,252,0,3,244,0,0,0,63,255,255,240,11,240,0,0,0,47,255,255,240,15,240,0,0,0,31,255,255,240,15,255,255,254,0,4,1,252,0,31,255,255,255,0,0,1,252,0,63,255,255,252,0,0,1,252,0,0,0,7,248,0,0,1,253,108,0,0,15,240,0,0,2,255,252,0,0,63,192,0,26,255,255,252,2,128,127,64,0,127,255,255,232,11,244,254,0,0,63,255,252,0,15,255,252,0,0,62,65,252,0,1,255,240,0,0,0,1,252,0,0,63,248,0,0,0,1,252,0,0,11,255,0,0,0,1,252,0,0,1,255,192,0,0,1,252,0,0,0,63,240,0,0,1,252,0,0,0,15,192,0,0,1,248,0,0,0,3,64,0,0,0,0,0,0,0,0,0,0,
  // 0x8f6f  软
  111,143,34,35,59,36,1,252,0,2,160,0,0,228,0,0,0,0,3,244,0,1,252,0,0,0,0,7,240,0,1,252,0,0,0,0,11,240,0,2,248,0,0,0,63,255,255,255,3,244,0,0,0,63,255,255,255,3,244,0,0,0,63,255,255,255,3,255,255,255,208,0,47,128,0,7,255,255,255,208,0,63,0,0,11,255,255,255,192,0,127,0,0,15,208,0,31,192,0,190,21,0,31,192,0,31,128,0,253,63,0,63,128,0,47,64,1,252,63,0,127,71,224,63,0,2,248,63,0,255,7,224,63,0,3,240,63,1,253,7,224,126,0,11,240,63,0,188,11,224,125,0,31,255,255,255,20,11,224,4,0,31,255,255,255,0,11,224,0,0,15,255,255,255,0,11,240,0,0,4,0,63,0,0,15,240,0,0,0,0,63,0,0,15,244,0,0,0,0,63,0,0,31,248,0,0,0,0,63,1,0,47,252,0,0,0,0,127,255,64,63,253,0,0,26,255,255,255,64,127,191,0,0,127,255,255,254,0,255,63,64,0,63,255,255,64,1,253,47,192,0,62,148,63,0,3,252,15,224,0,0,0,63,0,15,240,11,244,0,0,0,63,0,47,224,3,253,0,0,0,63,0,255,128,1,255,128,0,0,63,3,255,0,0,127,208,0,0,63,1,252,0,0,31,128,0,0,63,0,96,0,0,3,0,0,0,0,0,0,0,0,0,0,
  // 0x8f74  轴
  116,143,33,35,59,36,1,252,0,14,128,0,0,11,224,0,0,0,31,192,0,0,11,224,0,0,0,31,192,0,0,11,224,0,0,0,47,128,0,0,11,224,0,0,63,255,255,240,0,11,224,0,0,63,255,255,240,0,11,224,0,0,63,255,255,240,0,11,224,0,0,0,190,0,0,0,11,224,0,0,0,252,0,1,255,255,255,255,64,0,252,0,1,255,255,255,255,64,1,248,252,1,255,255,255,255,64,2,244,252,1,248,11,224,47,64,3,240,252,1,248,11,224,47,64,3,224,252,1,248,11,224,47,64,11,208,252,1,248,11,224,47,64,15,192,252,1,248,11,224,47,64,47,255,255,241,248,11,224,47,64,47,255,255,241,248,11,224,47,64,31,255,255,241,255,255,255,255,64,4,0,252,1,255,255,255,255,64,0,0,252,1,255,255,255,255,64,0,0,252,1,248,11,224,47,64,0,0,253,161,248,11,224,47,64,0,1,255,245,248,11,224,47,64,26,255,255,245,248,11,224,47,64,127,255,255,225,248,11,224,47,64,63,255,252,1,248,11,224,47,64,62,64,252,1,248,11,224,47,64,0,0,252,1,248,11,224,47,64,0,0,252,1,255,255,255,255,64,0,0,252,1,255,255,255,255,64,0,0,252,1,255,255,255,255,64,0,0,252,1,248,0,0,47,64,0,0,252,1,248,0,0,47,64,0,0,0,0,0,0,0,0,0,
  // 0x8f7d  载
  125,143,33,35,59,36,2,252,0,0,189,0,1,252,0,0,0,0,0,253,0,1,252,30,0,0,0,0,253,0,1,252,127,128,0,15,255,255,255,225,252,47,224,0,15,255,255,255,225,252,11,244,0,10,170,255,170,145,252,3,252,0,0,0,253,0,1,252,0,224,0,0,0,253,0,1,252,0,0,0,170,170,255,170,170,254,170,170,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,11,144,0,0,252,0,0,0,0,15,224,0,0,252,0,0,0,0,31,192,0,0,253,1,228,0,106,191,234,170,168,253,3,244,0,191,255,255,255,252,189,3,240,0,191,255,255,255,252,190,7,224,0,0,252,0,0,0,190,15,208,0,3,248,31,192,0,127,31,192,0,7,240,31,192,0,63,63,128,0,31,255,255,255,240,63,127,0,0,31,255,255,255,240,63,254,0,0,15,255,255,255,240,47,252,0,0,4,0,31,192,0,31,248,0,0,0,0,31,192,0,31,240,0,0,0,0,31,192,0,15,224,12,0,0,0,31,255,252,47,224,15,64,26,175,255,255,252,127,240,15,128,191,255,255,255,165,255,244,31,64,127,255,255,192,3,254,252,47,0,37,64,31,192,15,244,255,127,0,0,0,31,192,63,224,191,254,0,0,0,31,192,127,128,63,253,0,0,0,31,192,29,0,7,244,0,0,0,0,0,0,0,0,0,0,
  // 0x8f91  辑
  145,143,34,34,50,36,1,253,0,14,128,0,0,0,0,0,0,0,31,192,0,255,255,255,252,0,0,47,128,0,255,255,255,252,0,0,63,64,0,254,85,86,252,0,127,255,255,240,252,0,0,252,0,127,255,255,240,252,0,0,252,0,127,255,255,240,254,85,86,252,0,0,254,0,0,255,255,255,252,0,0,252,0,0,255,255,255,252,0,0,252,0,0,0,0,0,0,0,1,249,248,0,0,0,0,0,0,2,245,248,10,170,170,170,170,128,3,241,248,15,255,255,255,255,192,7,225,248,15,255,255,255,255,192,11,209,248,0,189,0,1,252,0,15,193,248,0,189,0,1,252,0,63,255,255,224,190,85,86,252,0,47,255,255,224,191,255,255,252,0,31,255,255,224,191,255,255,252,0,4,1,248,0,189,0,1,252,0,0,1,248,0,189,0,1,252,0,0,1,248,0,189,0,1,252,0,0,1,248,16,191,255,255,252,0,0,6,255,240,191,255,255,252,0,43,255,255,244,190,85,86,252,0,127,255,255,224,189,0,1,252,0,63,255,252,0,189,0,1,254,208,62,65,248,0,190,106,255,255,208,0,1,248,47,255,255,255,255,208,0,1,248,31,255,255,255,252,0,0,1,248,31,234,84,1,252,0,0,1,248,0,0,0,1,252,0,0,1,248,0,0,0,1,252,0,0,1,248,0,0,0,1,252,0,
  // 0x8f93  输
  147,143,34,34,50,36,1,253,0,121,0,0,0,14,0,0,0,0,126,0,0,0,47,192,0,0,0,189,0,0,0,127,192,0,0,0,189,0,0,1,255,224,0,0,127,255,255,64,11,255,252,0,0,127,255,255,64,47,240,255,64,0,127,255,255,64,255,192,63,224,0,1,244,0,11,254,0,15,254,0,2,240,0,127,244,0,2,255,224,3,240,1,255,255,255,255,255,208,3,227,224,126,255,255,255,231,128,7,211,224,16,170,170,170,144,0,11,195,224,0,0,0,0,0,0,15,195,224,0,0,0,0,10,0,15,131,224,15,255,253,21,31,64,31,67,224,15,255,253,62,31,64,63,255,255,15,234,189,62,31,64,63,255,255,15,64,61,62,31,64,47,255,255,15,64,61,62,31,64,0,3,224,15,255,253,62,31,64,0,3,224,15,255,253,62,31,64,0,3,224,15,149,189,62,31,64,0,3,251,15,64,61,62,31,64,0,27,255,79,64,61,62,31,64,47,255,255,79,255,253,62,31,64,63,255,244,15,255,253,62,31,64,63,235,224,15,149,189,62,31,64,36,3,224,15,64,61,62,31,64,0,3,224,15,64,61,0,31,64,0,3,224,15,64,61,0,31,64,0,3,224,15,64,125,0,31,64,0,3,224,15,75,253,15,255,0,0,3,224,15,71,252,15,255,0,0,3,224,10,66,144,6,164,0,
  // 0x8fb9  边
  185,143,34,34,50,36,1,253,0,64,0,0,1,80,0,0,0,2,208,0,0,7,240,0,0,0,15,244,0,0,7,240,0,0,0,3,253,0,0,11,240,0,0,0,1,255,0,0,11,240,0,0,0,0,127,192,0,11,240,0,0,0,0,47,240,0,11,240,0,0,0,0,15,210,255,255,255,255,255,0,0,2,2,255,255,255,255,255,0,0,0,2,255,255,255,255,255,0,0,0,0,0,15,224,0,127,0,0,0,0,0,15,208,0,127,0,21,85,0,0,15,208,0,127,0,127,255,64,0,31,192,0,127,0,127,255,64,0,47,192,0,191,0,127,255,64,0,63,192,0,191,0,0,63,64,0,63,64,0,191,0,0,63,64,0,127,0,0,190,0,0,63,64,0,255,0,0,254,0,0,63,64,0,253,0,0,254,0,0,63,64,3,252,0,0,253,0,0,63,64,7,248,0,0,253,0,0,63,64,15,240,0,1,253,0,0,63,64,63,208,0,2,252,0,0,63,64,255,128,21,7,252,0,0,63,71,254,0,63,255,248,0,0,63,67,248,0,31,255,240,0,1,255,192,208,0,15,255,128,0,11,255,248,0,0,0,0,0,0,63,246,255,228,0,0,0,21,160,255,192,127,255,255,255,255,255,224,127,0,11,255,255,255,255,255,208,61,0,0,111,255,255,255,255,192,8,0,0,0,5,85,64,0,0,
  // 0x8fc1  迁
  193,143,34,34,50,36,1,253,0,64,0,0,0,0,0,64,0,1,244,0,0,0,0,111,240,0,7,254,0,0,1,175,255,248,0,1,255,192,107,255,255,255,228,0,0,63,242,255,255,255,228,0,0,0,11,240,255,255,252,0,0,0,0,2,192,148,0,252,0,0,0,0,0,0,0,0,252,0,0,0,7,0,0,0,0,252,0,0,0,31,224,0,0,0,252,0,0,0,31,253,0,0,0,252,0,0,0,3,255,64,0,0,252,0,0,0,0,127,192,0,0,252,0,0,0,0,31,139,255,255,255,255,255,192,0,2,11,255,255,255,255,255,192,0,0,11,255,255,255,255,255,192,0,0,0,0,0,252,0,0,0,63,255,192,0,0,252,0,0,0,63,255,192,0,0,252,0,0,0,63,255,192,0,0,252,0,0,0,0,31,192,0,0,252,0,0,0,0,31,192,0,0,252,0,0,0,0,31,192,0,0,252,0,0,0,0,31,192,0,0,252,0,0,0,0,31,192,0,0,252,0,0,0,0,31,192,0,0,252,0,0,0,0,47,192,0,0,252,0,0,0,0,191,240,0,0,252,0,0,0,3,255,253,0,0,252,0,0,0,31,253,255,144,0,0,0,0,0,191,240,127,255,234,170,170,255,208,63,128,15,255,255,255,255,255,192,45,0,1,191,255,255,255,255,192,4,0,0,0,85,85,85,85,0,
  // 0x8fd0  运
  208,143,34,34,50,36,1,253,0,64,0,0,0,0,0,0,0,2,244,0,0,0,0,0,0,0,7,254,0,63,255,255,255,252,0,1,255,192,63,255,255,255,252,0,0,47,240,63,255,255,255,252,0,0,7,224,0,0,0,0,0,0,0,1,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,64,0,0,0,0,0,0,0,47,240,0,0,0,0,0,0,0,31,253,7,255,255,255,255,255,224,2,255,135,255,255,255,255,255,224,0,127,135,255,255,255,255,255,224,0,14,0,0,63,192,0,0,0,0,0,0,0,63,128,0,0,0,0,0,0,0,127,64,8,0,0,0,0,0,0,191,0,191,0,0,63,255,64,0,254,0,127,64,0,63,255,64,1,252,0,47,192,0,63,255,64,2,252,0,15,240,0,0,63,64,3,244,0,7,248,0,0,63,64,7,240,0,2,252,0,0,63,64,15,230,175,255,254,0,0,63,67,255,255,255,255,255,0,0,63,67,255,255,255,255,255,128,0,63,67,255,254,165,0,31,192,0,63,193,80,0,0,0,15,128,0,255,224,0,0,0,0,4,0,7,255,248,0,0,0,0,0,0,47,250,255,144,0,0,0,0,0,191,224,191,255,234,170,170,255,208,63,64,31,255,255,255,255,255,192,45,0,1,191,255,255,255,255,192,0,0,0,1,86,170,165,85,0,
  // 0x8fd1  近
  209,143,34,34,50,36,1,253,0,0,0,0,0,0,1,128,0,3,64,0,0,0,1,191,240,0,31,208,0,4,5,191,255,252,0,31,248,0,15,255,255,255,208,0,7,254,0,15,255,255,164,0,0,0,255,128,15,254,80,0,0,0,0,63,208,15,192,0,0,0,0,0,15,192,15,192,0,0,0,0,0,6,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,255,255,255,255,192,0,0,0,31,255,255,255,255,192,0,0,0,31,255,255,255,255,192,0,0,0,31,192,1,252,0,0,63,255,128,31,192,1,252,0,0,63,255,128,47,128,1,252,0,0,63,255,128,63,128,1,252,0,0,0,47,128,63,64,1,252,0,0,0,47,128,127,0,1,252,0,0,0,47,128,191,0,1,252,0,0,0,47,128,253,0,1,252,0,0,0,47,130,252,0,1,252,0,0,0,47,131,248,0,1,252,0,0,0,47,143,240,0,1,252,0,0,0,47,143,208,0,1,252,0,0,0,63,195,128,0,1,252,0,0,1,255,240,0,0,1,252,0,0,11,255,254,0,0,0,0,0,0,127,248,255,249,64,0,0,85,80,127,208,63,255,255,255,255,255,208,63,64,7,255,255,255,255,255,192,28,0,0,43,255,255,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x8fd4  返
  212,143,34,33,41,36,1,253,2,0,0,0,0,0,0,0,0,31,208,0,63,255,255,255,255,0,31,244,0,63,255,255,255,255,0,7,253,0,63,255,255,255,255,0,0,255,64,63,0,0,0,0,0,0,63,192,63,0,0,0,0,0,0,15,64,63,0,0,0,0,0,0,4,0,63,0,0,0,0,0,0,0,0,127,255,255,255,248,0,0,0,0,127,255,255,255,252,0,0,0,0,127,255,255,255,248,0,0,0,0,127,127,0,3,244,0,0,0,0,127,63,0,11,240,0,63,255,64,127,47,128,15,224,0,63,255,64,190,15,192,31,192,0,63,255,64,190,15,240,63,128,0,0,63,64,253,7,244,255,0,0,0,63,64,252,2,254,254,0,0,0,63,65,252,0,255,252,0,0,0,63,66,252,0,127,240,0,0,0,63,67,244,0,127,240,0,0,0,63,71,240,2,255,254,0,0,0,63,79,240,15,255,255,192,0,0,63,95,209,255,244,191,253,0,0,63,111,203,255,192,31,255,192,0,127,199,67,254,0,2,255,128,2,255,240,1,224,0,0,47,0,11,255,253,0,0,0,0,0,0,127,245,255,229,64,0,0,21,80,191,192,127,255,255,255,255,255,208,63,0,11,255,255,255,255,255,192,44,0,0,111,255,255,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x8fd8  还
  216,143,34,33,41,36,1,253,2,208,0,0,0,0,0,0,0,15,244,1,85,85,85,85,85,0,7,253,3,255,255,255,255,255,64,1,255,67,255,255,255,255,255,64,0,127,195,255,255,255,255,255,64,0,47,240,0,0,127,128,0,0,0,15,192,0,0,255,0,0,0,0,2,0,0,1,254,0,0,0,0,0,0,0,3,252,0,0,0,0,0,0,0,11,252,0,0,0,0,0,0,0,47,252,0,0,0,21,85,0,0,127,252,48,0,0,127,255,64,0,255,253,252,0,0,127,255,64,3,255,253,255,0,0,127,255,64,15,250,252,127,192,0,0,63,64,63,226,252,31,240,0,0,63,65,255,194,252,7,252,0,0,63,75,255,2,252,1,255,0,0,63,111,248,2,252,0,191,192,0,63,79,224,2,252,0,47,64,0,63,67,64,2,252,0,8,0,0,63,64,0,2,252,0,0,0,0,63,64,0,2,252,0,0,0,0,63,64,0,2,252,0,0,0,0,63,64,0,2,252,0,0,0,0,127,64,0,2,252,0,0,0,3,255,224,0,2,252,0,0,0,15,255,253,0,0,0,0,0,0,63,230,255,229,0,0,0,86,160,255,128,63,255,255,255,255,255,224,127,0,11,255,255,255,255,255,208,61,0,0,111,255,255,255,255,192,8,0,0,0,5,85,64,0,0,
  // 0x8fdb  进
  219,143,34,33,41,36,1,253,2,192,0,0,253,0,127,0,0,15,240,0,0,253,0,127,0,0,11,252,0,0,253,0,127,0,0,2,254,0,0,253,0,127,0,0,0,191,128,0,253,0,127,0,0,0,63,208,0,254,0,191,0,0,0,15,194,255,255,255,255,255,0,0,3,2,255,255,255,255,255,0,0,0,2,255,255,255,255,255,0,0,0,0,0,253,0,127,0,0,0,0,0,0,253,0,127,0,0,0,0,0,0,253,0,127,0,0,63,255,128,0,253,0,127,0,0,63,255,128,0,253,0,127,0,0,63,255,128,0,253,0,191,0,0,0,47,131,255,255,255,255,255,192,0,47,131,255,255,255,255,255,192,0,47,131,255,255,255,255,255,192,0,47,128,2,252,0,127,0,0,0,47,128,3,248,0,127,0,0,0,47,128,3,244,0,127,0,0,0,47,128,11,240,0,127,0,0,0,47,128,31,224,0,127,0,0,0,47,128,63,192,0,127,0,0,0,47,128,255,64,0,127,0,0,0,63,192,191,0,0,127,0,0,1,255,240,44,0,0,127,0,0,11,255,254,0,0,0,0,0,0,47,245,255,229,0,0,0,86,144,127,192,47,255,255,255,255,255,192,63,0,2,255,255,255,255,255,192,13,0,0,27,255,255,255,255,128,4,0,0,0,0,0,0,0,0,
  // 0x8fde  连
  222,143,34,34,50,36,1,253,0,64,0,0,41,0,0,0,0,3,208,0,0,63,192,0,0,0,15,240,0,0,63,128,0,0,0,3,252,0,0,127,0,0,0,0,1,255,3,255,255,255,255,255,0,0,127,131,255,255,255,255,255,0,0,63,195,255,255,255,255,255,0,0,15,192,3,248,0,0,0,0,0,6,0,7,240,21,0,0,0,0,0,0,15,224,63,128,0,0,0,0,0,31,192,63,128,0,0,0,0,0,63,128,63,128,0,0,127,255,64,191,64,63,128,0,0,127,255,65,255,255,255,255,252,0,127,255,64,255,255,255,255,252,0,0,63,64,191,255,255,255,252,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,75,255,255,255,255,255,128,0,63,75,255,255,255,255,255,128,0,63,75,255,255,255,255,255,128,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,63,64,0,0,63,128,0,0,0,127,64,0,0,63,128,0,0,3,255,224,0,0,63,128,0,0,15,255,253,0,0,63,128,0,0,63,226,255,229,0,0,0,86,160,255,192,63,255,255,255,255,255,224,127,0,11,255,255,255,255,255,208,45,0,0,111,255,255,255,255,192,8,0,0,0,5,85,64,0,0,
  // 0x8ff7  迷
  247,143,34,34,50,36,1,253,0,0,0,0,0,84,0,0,0,3,64,0,0,1,252,0,0,0,31,208,0,120,1,252,0,185,0,31,248,1,252,1,252,0,254,0,7,254,0,254,1,252,1,252,0,1,255,128,127,1,252,3,248,0,0,63,208,63,129,252,7,240,0,0,15,192,47,193,252,11,224,0,0,7,0,15,193,252,31,192,0,0,0,0,15,129,252,31,64,0,0,0,0,4,1,252,1,0,0,0,0,0,0,1,252,0,0,0,0,0,15,255,255,255,255,255,192,0,0,15,255,255,255,255,255,192,63,255,143,255,255,255,255,255,192,63,255,128,0,31,255,192,0,0,63,255,128,0,63,255,224,0,0,0,47,128,0,191,255,244,0,0,0,47,128,1,253,253,253,0,0,0,47,128,7,245,252,191,0,0,0,47,128,15,241,252,63,192,0,0,47,128,127,193,252,15,244,0,0,47,129,255,65,252,7,253,0,0,47,139,253,1,252,1,255,192,0,47,143,244,1,252,0,127,128,0,47,195,208,1,252,0,15,0,0,63,208,0,1,252,0,0,0,1,255,244,0,1,252,0,0,0,11,255,254,0,0,84,0,0,0,127,244,255,249,64,0,0,85,80,127,208,63,255,255,255,255,255,208,63,0,7,255,255,255,255,255,192,28,0,0,43,255,255,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x9000  退
  0,144,34,33,41,36,1,253,3,128,0,47,255,255,255,240,0,31,240,0,47,255,255,255,240,0,11,253,0,47,255,255,255,240,0,2,255,64,47,128,0,3,240,0,0,191,192,47,128,0,3,240,0,0,47,224,47,128,0,3,240,0,0,11,128,47,255,255,255,240,0,0,1,0,47,255,255,255,240,0,0,0,0,47,234,170,171,240,0,0,0,0,47,128,0,3,240,0,0,0,0,47,128,0,3,240,0,0,0,0,47,128,0,3,240,0,0,0,0,47,255,255,255,240,0,63,255,128,47,255,255,255,240,0,63,255,128,47,255,255,255,244,0,63,255,128,47,128,126,0,62,0,0,47,128,47,128,63,1,255,64,0,47,128,47,128,47,139,253,0,0,47,128,47,128,15,255,224,0,0,47,128,47,128,11,255,0,0,0,47,128,47,128,3,252,0,0,0,47,128,47,128,25,255,0,0,0,47,128,47,155,252,191,208,0,0,47,128,127,255,252,47,253,0,0,47,195,255,255,228,7,255,192,0,63,211,255,228,0,1,255,64,1,255,246,228,0,0,0,30,0,11,255,254,0,0,0,0,0,0,127,244,255,249,64,0,0,85,80,127,208,63,255,255,255,255,255,208,63,0,7,255,255,255,255,255,192,28,0,0,43,255,255,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x9009  选
  9,144,33,35,59,36,2,252,0,0,0,0,1,248,0,0,0,8,0,0,25,2,252,0,0,0,63,0,0,47,130,252,0,0,0,191,192,0,63,66,252,0,0,0,47,240,0,127,2,252,0,0,0,11,252,0,255,255,255,255,248,0,2,255,1,255,255,255,255,248,0,0,191,3,255,255,255,255,248,0,0,56,11,240,2,252,0,0,0,0,0,31,224,2,252,0,0,0,0,0,7,192,2,252,0,0,0,0,0,0,64,2,252,0,0,0,0,0,0,0,2,252,0,0,0,0,0,31,255,255,255,255,255,0,255,253,31,255,255,255,255,255,0,255,253,31,255,255,255,255,255,0,255,253,0,1,252,15,208,0,0,0,253,0,2,252,15,208,0,0,0,253,0,3,248,15,208,0,0,0,253,0,3,244,15,208,0,0,0,253,0,11,240,15,208,0,0,0,253,0,15,224,15,208,29,0,0,253,0,47,208,15,208,31,64,0,253,0,191,192,15,224,47,64,0,253,3,255,0,11,224,63,64,0,253,63,252,0,11,255,255,0,0,253,47,240,0,7,255,254,0,0,255,79,64,0,1,255,248,0,2,255,240,0,0,0,0,0,0,31,255,253,0,0,0,0,0,0,127,224,255,229,0,0,21,106,64,255,128,47,255,255,255,255,255,0,190,0,6,255,255,255,255,255,0,56,0,0,26,255,255,255,234,0,0,0,0,0,0,0,0,0,0,
  // 0x901f  速
  31,144,34,34,50,36,1,253,0,0,0,0,0,252,0,0,0,2,0,0,0,0,252,0,0,0,15,208,0,0,0,252,0,0,0,47,244,0,0,0,252,0,0,0,7,254,7,255,255,255,255,255,192,1,255,135,255,255,255,255,255,192,0,63,215,255,255,255,255,255,128,0,15,128,0,0,252,0,0,0,0,1,0,0,0,252,0,0,0,0,0,0,255,255,255,255,253,0,0,0,0,255,255,255,255,253,0,0,0,0,254,170,254,170,253,0,0,0,0,252,0,252,0,253,0,0,0,0,252,0,252,0,253,0,63,255,128,252,0,252,0,253,0,63,255,128,252,0,252,0,253,0,63,255,128,255,255,255,255,253,0,0,47,128,255,255,255,255,253,0,0,47,128,170,175,255,234,169,0,0,47,128,0,47,255,192,0,0,0,47,128,0,127,255,244,0,0,0,47,128,2,253,254,253,0,0,0,47,128,11,244,252,191,128,0,0,47,128,127,208,252,47,244,0,0,47,130,255,64,252,11,255,64,0,47,207,253,0,252,1,255,128,0,63,211,240,0,252,0,63,0,1,255,245,64,0,252,0,4,0,11,255,254,0,0,168,0,0,0,127,244,255,249,64,0,0,85,80,127,208,63,255,255,255,255,255,208,63,0,7,255,255,255,255,255,192,28,0,0,43,255,255,255,255,128,0,0,0,0,0,0,0,0,0,
  // 0x90e8  部
  232,144,34,34,50,36,1,253,0,0,169,0,0,0,0,0,0,0,0,190,0,0,0,0,0,0,0,0,190,0,0,191,255,255,64,0,0,190,0,0,191,255,255,208,47,255,255,255,244,191,255,255,192,47,255,255,255,244,190,0,63,192,47,255,255,255,244,190,0,63,64,0,16,0,20,0,190,0,191,0,1,248,0,63,64,190,0,254,0,0,252,0,63,0,190,1,252,0,0,189,0,126,0,190,2,248,0,0,126,0,189,0,190,3,244,0,0,127,0,252,0,190,7,240,0,0,36,0,100,0,190,15,208,0,127,255,255,255,252,190,31,192,0,127,255,255,255,252,190,15,240,0,127,255,255,255,252,190,3,248,0,0,0,0,0,0,190,0,253,0,0,0,0,0,0,190,0,191,0,0,0,0,0,0,190,0,63,64,3,255,255,255,192,190,0,47,128,3,255,255,255,192,190,0,31,192,3,255,255,255,192,190,0,31,192,3,240,0,15,192,190,0,31,192,3,240,0,15,192,190,0,31,192,3,240,0,15,192,190,0,127,192,3,240,0,15,192,190,63,255,128,3,240,0,15,192,190,31,255,0,3,240,0,15,192,190,31,248,0,3,255,255,255,192,190,5,64,0,3,255,255,255,192,190,0,0,0,3,255,255,255,192,190,0,0,0,3,240,0,15,192,190,0,0,0,3,240,0,15,192,190,0,0,0,
  // 0x914d  配
  77,145,33,33,41,36,2,253,255,255,255,255,0,0,0,0,0,255,255,255,255,31,255,255,253,0,255,255,255,255,31,255,255,253,0,0,61,61,0,31,255,255,253,0,0,61,61,0,0,0,0,253,0,0,61,61,0,0,0,0,253,0,0,61,61,0,0,0,0,253,0,63,255,255,253,0,0,0,253,0,63,255,255,253,0,0,0,253,0,63,255,255,253,0,0,0,253,0,61,44,56,125,0,0,0,253,0,61,44,56,125,0,0,0,253,0,61,44,56,125,15,255,255,253,0,61,44,56,125,15,255,255,253,0,61,44,56,125,15,255,255,253,0,61,60,56,125,15,192,0,253,0,61,56,56,125,15,192,0,253,0,61,180,63,253,15,192,0,104,0,63,240,31,253,15,192,0,0,0,61,128,0,125,15,192,0,0,0,61,0,0,125,15,192,0,0,0,61,0,0,125,15,192,0,0,0,63,255,255,253,15,192,0,0,0,63,255,255,253,15,192,0,24,0,62,85,85,189,15,192,0,31,64,61,0,0,125,15,192,0,31,128,61,0,0,125,15,192,0,47,128,61,0,0,125,15,192,0,47,64,63,255,255,253,15,208,0,127,0,63,255,255,253,15,255,255,255,0,63,170,170,253,11,255,255,253,0,61,0,0,125,2,255,255,248,0,61,0,0,20,0,0,0,0,0,
  // 0x91ca  释
  202,145,34,34,50,36,1,253,0,0,0,64,0,0,0,0,0,0,1,175,240,0,0,0,0,0,43,255,255,245,255,255,255,255,64,63,255,254,145,255,255,255,255,192,63,175,208,1,255,255,255,255,0,0,11,208,0,31,64,0,254,0,25,11,208,248,15,192,3,252,0,47,11,208,248,3,240,15,240,0,15,139,210,240,1,252,63,208,0,11,203,211,224,0,191,255,64,0,7,219,219,192,0,63,253,0,0,3,75,209,64,0,191,252,0,0,0,11,208,0,11,255,255,128,0,63,255,255,241,191,253,191,249,0,63,255,255,255,255,224,15,255,224,63,255,255,251,254,0,1,255,208,0,31,224,3,208,15,208,11,192,0,63,248,0,0,15,208,0,0,0,63,254,0,0,15,208,0,0,0,255,255,128,255,255,255,254,0,1,255,239,224,255,255,255,254,0,3,251,215,244,255,255,255,254,0,11,235,210,240,0,15,208,0,0,31,203,208,128,0,15,208,0,0,127,75,208,0,0,15,208,0,0,191,11,208,7,255,255,255,255,192,61,11,208,7,255,255,255,255,192,40,11,208,7,255,255,255,255,192,0,11,208,0,0,15,208,0,0,0,11,208,0,0,15,208,0,0,0,11,208,0,0,15,208,0,0,0,11,208,0,0,15,208,0,0,0,11,208,0,0,15,208,0,0,0,11,208,0,0,15,208,0,0,
  // 0x91cd  重
  205,145,32,33,8,36,2,254,0,0,0,0,0,5,172,0,0,0,5,90,191,255,254,0,3,255,255,255,255,255,255,0,2,255,255,255,255,169,64,0,1,170,85,95,208,0,0,0,0,0,0,15,208,0,0,0,170,170,170,175,250,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,253,85,95,229,85,127,64,0,252,0,15,208,0,63,64,0,252,0,15,224,0,63,64,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,252,0,15,208,0,63,64,0,252,0,15,208,0,63,64,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,85,85,95,229,85,85,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,7,255,255,255,255,255,255,240,7,255,255,255,255,255,255,240,2,170,170,175,250,170,170,160,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,170,170,170,170,170,170,170,170,
  // 0x91cf  量
  207,145,33,32,32,36,2,254,0,127,255,255,255,255,253,0,0,0,191,255,255,255,255,254,0,0,0,190,0,0,0,0,254,0,0,0,190,0,0,0,0,254,0,0,0,191,255,255,255,255,254,0,0,0,191,255,255,255,255,254,0,0,0,190,0,0,0,0,254,0,0,0,191,255,255,255,255,254,0,0,0,191,255,255,255,255,254,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,85,85,85,85,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,252,0,11,224,0,63,64,0,0,252,0,11,224,0,63,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,252,0,11,224,0,63,64,0,0,252,0,11,224,0,63,64,0,0,255,255,255,255,255,255,64,0,0,255,255,255,255,255,255,64,0,0,0,0,11,224,0,0,0,0,1,85,85,95,229,85,85,64,0,3,255,255,255,255,255,255,192,0,3,255,255,255,255,255,255,192,0,0,0,0,11,224,0,0,0,0,170,170,170,175,250,170,170,170,0,255,255,255,255,255,255,255,255,64,255,255,255,255,255,255,255,255,64,
  // 0x9488  针
  136,148,33,34,50,36,1,253,0,41,0,0,0,6,160,0,0,0,63,64,0,0,11,240,0,0,0,127,0,0,0,11,240,0,0,0,253,0,0,0,11,240,0,0,2,255,255,240,0,11,240,0,0,7,255,255,240,0,11,240,0,0,15,255,255,240,0,11,240,0,0,63,208,0,0,0,11,240,0,0,191,128,0,0,0,11,240,0,0,127,0,0,0,0,11,240,0,0,61,0,0,0,0,11,240,0,0,19,255,255,208,0,11,240,0,0,3,255,255,219,255,255,255,255,192,2,175,250,139,255,255,255,255,192,0,11,224,11,255,255,255,255,192,0,11,224,1,85,91,245,85,64,0,11,224,0,0,11,240,0,0,0,11,224,0,0,11,240,0,0,47,255,255,240,0,11,240,0,0,47,255,255,240,0,11,240,0,0,47,255,255,240,0,11,240,0,0,0,11,224,0,0,11,240,0,0,0,11,224,0,0,11,240,0,0,0,11,224,0,0,11,240,0,0,0,11,224,0,0,11,240,0,0,0,11,224,0,0,11,240,0,0,0,11,224,40,0,11,240,0,0,0,11,226,248,0,11,240,0,0,0,15,255,252,0,11,240,0,0,0,15,255,224,0,11,240,0,0,0,63,254,0,0,11,240,0,0,0,63,244,0,0,11,240,0,0,0,31,64,0,0,11,240,0,0,0,8,0,0,0,11,224,0,0,
  // 0x94ae  钮
  174,148,34,34,50,36,1,253,0,164,0,0,0,0,0,0,0,0,253,0,0,0,0,0,0,0,1,252,0,7,255,255,255,255,0,3,248,0,7,255,255,255,255,0,3,255,255,231,255,255,255,255,0,11,255,255,224,0,190,0,127,0,15,255,255,224,0,254,0,127,0,47,192,0,0,0,253,0,190,0,127,64,0,0,0,253,0,190,0,255,0,0,0,0,252,0,190,0,125,0,0,0,0,252,0,189,0,59,255,255,192,0,252,0,253,0,3,255,255,192,1,252,0,253,0,3,255,255,192,1,252,0,253,0,0,15,192,2,171,254,170,252,0,0,15,192,3,255,255,255,252,0,0,15,192,3,255,255,255,252,0,0,15,192,2,171,254,171,252,0,63,255,255,224,3,240,1,252,0,63,255,255,224,3,240,1,252,0,63,255,255,224,7,240,2,248,0,0,15,192,0,7,240,2,248,0,0,15,192,0,11,224,2,248,0,0,15,192,0,11,224,3,244,0,0,15,192,0,15,208,3,244,0,0,15,192,64,15,208,3,244,0,0,15,195,192,15,192,3,240,0,0,15,239,208,15,192,3,240,0,0,15,255,208,31,192,7,240,0,0,31,254,85,111,213,91,245,64,0,63,244,255,255,255,255,255,224,0,255,128,255,255,255,255,255,224,0,125,0,255,255,255,255,255,224,0,32,0,0,0,0,0,0,0,
  // 0x9519  错
  25,149,34,35,59,36,1,252,0,57,0,0,11,192,31,128,0,0,63,0,0,15,192,31,128,0,0,190,0,0,15,192,31,128,0,0,252,0,0,15,192,31,128,0,2,255,255,208,15,192,31,128,0,3,255,255,211,255,255,255,255,128,15,255,255,211,255,255,255,255,128,47,192,0,3,255,255,255,255,128,127,64,0,0,15,192,31,128,0,127,0,0,0,15,192,31,128,0,61,0,0,0,15,192,31,128,0,23,255,255,192,15,192,31,128,0,3,255,255,207,255,255,255,255,208,3,255,255,207,255,255,255,255,208,0,15,192,15,255,255,255,255,208,0,15,192,0,0,0,0,0,0,0,15,192,0,0,0,0,0,0,0,15,192,0,191,255,255,252,0,47,255,255,224,255,255,255,252,0,47,255,255,224,255,255,255,252,0,47,255,255,224,252,0,0,252,0,0,15,192,0,252,0,0,252,0,0,15,192,0,252,0,0,252,0,0,15,192,0,252,0,0,252,0,0,15,192,0,255,255,255,252,0,0,15,192,0,255,255,255,252,0,0,15,193,192,254,170,170,252,0,0,15,223,192,252,0,0,252,0,0,15,255,208,252,0,0,252,0,0,47,255,128,252,0,0,252,0,0,127,248,0,255,255,255,252,0,0,127,192,0,255,255,255,252,0,0,45,0,0,255,170,170,252,0,0,0,0,0,252,0,0,252,0,0,0,0,0,0,0,0,0,0,
  // 0x955c  镜
  92,149,34,35,59,36,1,252,0,36,0,0,0,31,128,0,0,0,127,0,0,0,15,192,0,0,0,190,0,2,170,175,250,170,0,0,253,0,3,255,255,255,255,64,2,255,255,195,255,255,255,255,64,7,255,255,192,6,128,2,64,0,15,255,255,192,15,192,11,224,0,47,192,0,0,11,208,15,192,0,127,128,0,0,7,208,31,128,0,127,0,0,15,255,255,255,255,192,62,0,0,15,255,255,255,255,192,27,255,255,79,255,255,255,255,192,3,255,255,64,0,0,0,0,0,3,255,255,64,0,0,0,0,0,0,31,192,1,255,255,255,254,0,0,31,192,1,255,255,255,254,0,0,31,192,1,248,0,0,126,0,0,31,192,1,248,0,0,126,0,63,255,255,209,255,255,255,254,0,63,255,255,209,255,255,255,254,0,63,255,255,209,248,0,0,126,0,0,31,192,1,248,0,0,126,0,0,31,192,1,255,255,255,254,0,0,31,192,1,255,255,255,254,0,0,31,192,0,7,240,127,0,0,0,31,192,128,7,224,126,0,0,0,31,199,208,11,224,126,0,0,0,31,255,224,15,208,126,1,0,0,47,255,192,47,192,126,3,208,0,63,254,0,127,64,126,3,224,0,255,240,7,255,0,127,3,224,0,191,64,191,252,0,63,255,208,0,60,0,127,224,0,63,255,192,0,16,0,46,0,0,5,85,0,0,0,0,0,0,0,0,0,0,
  // 0x957f  长
  127,149,33,34,50,36,2,253,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,120,0,0,0,7,240,0,0,1,255,64,0,0,7,240,0,0,11,253,0,0,0,7,240,0,0,63,244,0,0,0,7,240,0,1,255,208,0,0,0,7,240,0,11,255,0,0,0,0,7,240,0,191,248,0,0,0,0,7,240,11,255,208,0,0,0,0,7,240,127,254,0,0,0,0,0,7,240,47,244,0,0,0,0,0,7,240,11,64,0,0,0,0,0,7,240,0,0,0,0,0,0,0,7,240,0,0,0,0,0,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,0,85,91,245,86,253,85,85,85,0,0,7,240,0,253,0,0,0,0,0,7,240,0,191,0,0,0,0,0,7,240,0,63,64,0,0,0,0,7,240,0,63,192,0,0,0,0,7,240,0,31,240,0,0,0,0,7,240,0,11,252,0,0,0,0,7,240,0,3,254,0,0,0,0,7,240,0,0,255,192,0,0,0,7,240,0,0,127,244,0,0,0,7,240,6,244,31,254,0,0,0,7,250,255,244,7,255,228,0,0,11,255,255,248,0,255,255,64,0,47,255,255,144,0,47,255,0,0,31,255,144,0,0,2,252,0,0,15,208,0,0,0,0,24,0,0,4,0,0,0,0,0,0,0,
  // 0x95ed  闭
  237,149,30,35,24,36,3,252,1,0,0,0,0,0,0,0,47,64,0,0,0,0,0,0,63,208,31,255,255,255,255,240,15,240,31,255,255,255,255,240,7,252,31,255,255,255,255,240,1,254,0,0,0,0,7,240,0,184,0,0,0,0,3,240,0,16,0,0,63,64,3,240,84,0,0,0,63,64,3,240,253,0,0,0,63,64,3,240,253,0,0,0,63,64,3,240,253,0,0,0,63,64,3,240,253,15,255,255,255,255,195,240,253,15,255,255,255,255,195,240,253,15,255,255,255,255,195,240,253,0,0,7,255,64,3,240,253,0,0,15,255,64,3,240,253,0,0,63,255,64,3,240,253,0,0,191,191,64,3,240,253,0,2,254,63,64,3,240,253,0,11,252,63,64,3,240,253,0,63,240,63,64,3,240,253,0,255,192,63,64,3,240,253,11,255,0,63,64,3,240,253,127,248,0,63,64,3,240,253,127,224,0,63,64,3,240,253,31,0,0,63,64,3,240,253,4,0,0,127,64,3,240,253,0,0,255,255,0,3,240,253,0,0,255,255,0,3,240,253,0,0,127,228,0,7,240,253,0,0,0,0,7,255,240,253,0,0,0,0,3,255,208,253,0,0,0,0,3,255,64,0,0,0,0,0,0,0,0,
  // 0x95f2  闲
  242,149,30,34,16,36,3,253,1,0,0,0,0,0,0,0,11,128,0,0,0,0,0,0,47,208,15,255,255,255,255,240,11,244,15,255,255,255,255,240,3,252,15,255,255,255,255,240,0,255,0,0,0,0,3,240,0,127,128,0,0,0,3,240,0,47,128,0,0,0,3,240,84,13,0,26,64,0,3,240,252,0,0,47,64,0,3,240,252,0,0,47,64,0,3,240,252,0,0,47,64,0,3,240,252,0,0,47,64,0,3,240,252,31,255,255,255,255,195,240,252,31,255,255,255,255,195,240,252,31,255,255,255,255,131,240,252,0,0,255,240,0,3,240,252,0,3,255,252,0,3,240,252,0,7,255,255,0,3,240,252,0,15,239,191,192,3,240,252,0,63,111,79,240,3,240,252,0,254,47,67,252,3,240,252,3,252,47,65,254,3,240,252,31,244,47,64,127,67,240,252,63,208,47,64,47,3,240,252,31,64,47,64,8,3,240,252,8,0,47,64,0,3,240,252,0,0,47,64,0,3,240,252,0,0,47,64,0,3,240,252,0,0,47,64,0,7,240,252,0,0,5,0,127,255,240,252,0,0,0,0,63,255,224,252,0,0,0,0,47,255,64,168,0,0,0,0,0,0,0,
  // 0x95f4  间
  244,149,30,35,24,36,3,252,1,0,0,0,0,0,0,0,31,64,0,0,0,0,0,0,63,208,31,255,255,255,255,240,15,240,31,255,255,255,255,240,3,252,31,255,255,255,255,240,1,253,0,0,0,0,11,240,0,180,0,0,0,0,7,240,0,0,0,0,0,0,7,240,169,0,0,0,0,0,7,240,254,0,0,0,0,0,7,240,254,0,170,170,170,160,7,240,254,0,255,255,255,240,7,240,254,0,255,255,255,240,7,240,254,0,252,0,3,240,7,240,254,0,252,0,3,240,7,240,254,0,252,0,3,240,7,240,254,0,252,0,3,240,7,240,254,0,254,170,171,240,7,240,254,0,255,255,255,240,7,240,254,0,255,255,255,240,7,240,254,0,252,0,3,240,7,240,254,0,252,0,3,240,7,240,254,0,252,0,3,240,7,240,254,0,252,0,3,240,7,240,254,0,252,0,3,240,7,240,254,0,255,255,255,240,7,240,254,0,255,255,255,240,7,240,254,0,170,170,170,160,7,240,254,0,0,0,0,0,7,240,254,0,0,0,0,0,7,240,254,0,0,0,0,0,11,240,254,0,0,0,0,3,255,240,254,0,0,0,0,2,255,224,254,0,0,0,0,1,254,64,0,0,0,0,0,0,0,0,
  // 0x9608  阈
  8,150,30,35,24,36,3,252,3,192,0,0,0,0,0,0,15,224,15,255,255,255,255,240,7,248,15,255,255,255,255,240,2,253,15,255,255,255,255,240,0,255,64,0,0,0,11,240,0,63,192,0,0,0,7,240,0,31,128,1,240,144,7,240,84,9,0,1,242,244,7,240,253,0,0,1,244,189,7,240,253,0,0,1,244,56,7,240,253,26,170,170,254,170,71,240,253,63,255,255,255,255,199,240,253,63,255,255,255,255,199,240,253,0,0,0,248,0,7,240,253,0,0,0,248,21,7,240,253,15,255,244,248,63,7,240,253,15,255,244,252,62,7,240,253,15,64,244,188,124,7,240,253,15,64,244,188,188,7,240,253,15,64,244,124,248,7,240,253,15,64,244,126,240,7,240,253,15,255,244,63,224,7,240,253,15,255,244,63,192,7,240,253,0,0,0,47,129,135,240,253,0,0,20,63,66,231,240,253,1,175,252,191,195,215,240,253,63,255,254,255,231,199,240,253,63,254,75,243,255,199,240,253,41,0,47,193,255,71,240,253,0,0,31,0,126,7,240,253,0,0,4,0,0,11,240,253,0,0,0,0,63,255,224,253,0,0,0,0,47,255,192,253,0,0,0,0,31,254,0,0,0,0,0,0,0,0,0,
  // 0x964d  降
  77,150,32,35,24,36,3,252,0,0,0,0,14,64,0,0,0,0,0,0,63,128,0,0,255,255,208,0,127,0,0,0,255,255,244,0,255,170,170,0,255,255,240,3,255,255,255,192,252,7,240,11,255,255,255,64,252,11,208,47,240,0,191,0,252,15,192,191,248,0,253,0,252,15,195,254,253,3,252,0,252,47,71,244,127,79,240,0,252,63,1,208,47,255,192,0,252,62,0,0,11,255,64,0,252,125,0,0,11,255,64,0,252,190,0,0,191,255,244,0,252,63,0,11,255,159,255,144,252,15,194,255,253,1,255,254,252,15,215,255,208,47,175,252,252,7,226,249,0,47,129,180,252,3,240,64,0,47,128,0,252,3,240,255,255,255,255,240,252,3,240,255,255,255,255,240,252,3,240,255,255,255,255,240,252,11,240,11,192,47,128,0,252,255,224,11,192,47,128,0,252,255,192,11,192,47,128,0,252,190,0,11,192,47,128,0,252,0,15,255,255,255,255,252,252,0,15,255,255,255,255,252,252,0,11,255,255,255,255,252,252,0,0,0,0,47,128,0,252,0,0,0,0,47,128,0,252,0,0,0,0,47,128,0,252,0,0,0,0,47,128,0,252,0,0,0,0,47,128,0,0,0,0,0,0,0,0,0,
  // 0x9650  限
  80,150,31,33,8,36,3,252,255,255,244,63,255,255,255,192,255,255,252,63,255,255,255,192,255,255,252,63,255,255,255,192,252,2,244,63,0,0,15,192,252,3,240,63,0,0,15,192,252,7,224,63,0,0,15,192,252,11,208,63,255,255,255,192,252,15,192,63,255,255,255,192,252,31,128,63,255,255,255,192,252,63,0,63,0,0,15,192,252,63,0,63,0,0,15,192,252,63,64,63,0,0,15,192,252,15,192,63,0,0,15,192,252,7,224,63,255,255,255,192,252,3,240,63,255,255,255,192,252,2,248,63,255,255,255,192,252,1,252,63,1,248,0,0,252,0,252,63,0,252,2,208,252,0,252,63,0,253,7,248,252,1,252,63,0,126,47,224,252,3,252,63,0,63,191,128,252,255,248,63,0,63,254,0,252,191,240,63,0,31,244,0,252,127,128,63,0,15,224,0,252,0,0,63,0,7,244,0,252,0,0,63,0,19,253,0,252,0,0,63,111,244,255,0,252,0,1,191,255,244,127,208,252,0,63,255,255,244,47,248,252,0,47,255,228,0,11,252,252,0,15,228,0,0,2,244,252,0,4,0,0,0,0,32,0,0,0,0,0,0,0,0,
  // 0x9664  除
  100,150,32,34,16,36,3,253,0,0,0,0,6,160,0,0,0,0,0,0,15,248,0,0,255,255,208,0,47,252,0,0,255,255,244,0,127,255,0,0,255,255,240,0,254,63,192,0,252,7,240,3,252,31,240,0,252,11,208,15,240,7,252,0,252,15,192,63,208,2,255,0,252,15,192,255,64,0,127,208,252,47,75,253,0,0,31,248,252,63,63,244,0,0,7,254,252,62,31,239,255,255,254,252,252,189,14,31,255,255,253,40,252,190,0,31,255,255,253,0,252,63,0,0,3,240,0,0,252,15,192,0,3,240,0,0,252,11,208,0,3,240,0,0,252,7,224,0,3,240,0,0,252,3,242,255,255,255,255,240,252,3,242,255,255,255,255,240,252,3,242,255,255,255,255,240,252,3,240,0,3,240,0,0,252,11,240,0,3,240,0,0,252,255,224,62,3,240,124,0,252,255,192,190,3,240,191,0,252,190,0,252,3,240,63,128,252,0,2,248,3,240,31,192,252,0,7,240,3,240,11,240,252,0,15,224,3,240,3,244,252,0,63,192,3,240,1,252,252,0,47,0,7,240,0,252,252,0,9,3,255,240,0,80,252,0,0,2,255,224,0,0,252,0,0,1,254,64,0,0,
  // 0x9669  险
  105,150,32,34,16,36,3,253,0,0,0,0,2,144,0,0,0,0,0,0,3,244,0,0,255,255,208,0,15,240,0,0,255,255,244,0,31,252,0,0,255,255,240,0,63,254,0,0,252,7,224,0,255,127,128,0,252,11,208,2,252,31,224,0,252,15,192,11,244,7,252,0,252,31,128,47,208,1,255,64,252,47,64,191,128,0,127,224,252,63,3,254,0,0,31,253,252,126,47,255,255,255,251,255,252,189,47,223,255,255,244,189,252,63,15,79,255,255,244,28,252,31,192,0,0,0,0,0,252,15,192,0,0,0,0,0,252,7,224,0,1,80,1,0,252,3,240,24,3,224,3,240,252,3,240,188,3,240,7,224,252,3,240,125,2,240,11,208,252,3,240,62,1,244,15,192,252,7,240,63,1,244,31,64,252,255,240,47,64,248,63,0,252,255,208,31,128,252,126,0,252,190,64,15,128,252,188,0,252,0,0,15,192,64,248,0,252,0,0,4,0,2,240,0,252,0,0,0,0,3,224,0,252,0,0,0,0,11,192,0,252,0,11,255,255,255,255,252,252,0,11,255,255,255,255,252,252,0,11,255,255,255,255,252,252,0,0,0,0,0,0,0,168,0,0,0,0,0,0,0,
  // 0x96f6  零
  246,150,34,33,41,36,1,253,0,85,85,85,85,85,85,80,0,0,255,255,255,255,255,255,240,0,0,255,255,255,255,255,255,240,0,0,0,0,2,244,0,0,0,0,0,0,0,3,248,0,0,0,0,31,255,255,255,255,255,255,255,64,31,255,255,255,255,255,255,255,64,31,128,0,2,244,0,0,47,64,31,134,170,146,244,170,169,47,64,31,143,255,226,244,255,254,47,64,31,143,255,226,244,255,254,47,64,0,0,0,2,244,0,0,0,0,0,47,255,240,80,255,255,128,0,0,47,255,247,248,255,255,128,0,0,0,0,47,255,64,0,0,0,0,0,0,191,255,224,0,0,0,0,0,11,254,15,253,0,0,0,0,0,127,244,2,255,208,0,0,0,11,255,128,0,47,254,64,0,1,255,255,255,255,255,255,249,0,127,255,151,255,255,254,47,255,208,63,248,1,85,85,84,1,255,192,30,64,0,0,0,0,0,6,64,0,127,255,255,255,255,255,64,0,0,127,255,255,255,255,255,64,0,0,21,85,127,85,85,127,64,0,0,0,0,63,0,0,63,64,0,0,0,0,63,0,0,63,64,0,0,0,0,63,0,42,191,0,0,0,0,0,63,0,63,255,0,0,0,0,0,63,0,31,248,0,0,0,0,0,63,0,0,0,0,0,0,0,0,63,0,0,0,0,0,
  // 0x9700  需
  0,151,32,33,8,36,2,253,2,170,170,170,170,170,170,128,3,255,255,255,255,255,255,192,3,255,255,255,255,255,255,192,0,0,0,11,208,0,0,0,0,0,0,11,208,0,0,0,127,255,255,255,255,255,255,253,127,255,255,255,255,255,255,253,127,85,85,95,229,85,85,253,126,0,0,11,208,0,0,189,126,63,255,139,211,255,248,189,126,63,255,139,211,255,248,189,126,0,0,11,208,0,0,189,0,0,0,11,208,0,0,0,0,191,255,139,211,255,254,0,0,191,255,139,211,255,254,0,0,0,0,11,208,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,106,170,170,175,250,170,170,169,0,0,0,15,192,0,0,0,0,0,0,31,192,0,0,0,3,255,255,255,255,255,255,224,3,255,255,255,255,255,255,224,3,254,171,250,175,250,175,224,3,244,3,240,7,224,7,224,3,244,3,240,7,224,7,224,3,244,3,240,7,224,7,224,3,244,3,240,7,224,7,224,3,244,3,240,7,224,7,224,3,244,3,240,7,225,175,224,3,244,3,240,7,225,255,208,3,240,2,160,6,144,255,64,
  // 0x9752  青
  82,151,32,35,24,36,2,252,0,0,0,11,224,0,0,0,0,0,0,15,224,0,0,0,6,170,170,175,250,170,170,144,11,255,255,255,255,255,255,240,11,255,255,255,255,255,255,240,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,85,85,95,245,85,85,0,0,0,0,15,224,0,0,0,0,0,0,15,224,0,0,0,191,255,255,255,255,255,255,254,191,255,255,255,255,255,255,254,106,170,170,170,170,170,170,169,0,0,0,0,0,0,0,0,0,26,170,170,170,170,168,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,64,0,0,0,252,0,0,63,64,0,0,0,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,149,85,85,85,252,0,0,63,64,0,0,0,252,0,0,63,149,85,85,85,252,0,0,63,255,255,255,255,252,0,0,63,255,255,255,255,252,0,0,63,64,0,0,0,252,0,0,63,64,0,0,0,252,0,0,63,64,0,0,1,252,0,0,63,64,0,6,171,252,0,0,63,64,0,7,255,252,0,0,63,64,0,3,255,224,0,0,0,0,0,0,0,0,0,
  // 0x975e  非
  94,151,34,35,59,36,1,252,0,0,3,240,1,248,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,15,255,255,240,2,255,255,255,192,15,255,255,240,2,255,255,255,192,15,255,255,240,2,255,255,255,192,0,0,7,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,15,255,255,240,2,255,255,255,0,15,255,255,240,2,255,255,255,0,15,255,255,240,2,255,255,255,0,0,0,3,240,2,252,0,0,0,0,0,3,240,2,252,0,0,0,0,0,7,240,2,252,0,0,0,0,0,7,246,130,252,0,0,0,0,5,175,255,194,252,0,0,0,107,255,255,255,194,255,255,255,208,127,255,255,249,2,255,255,255,208,63,255,191,192,2,255,255,255,208,57,64,127,64,2,252,0,0,0,0,0,255,0,2,252,0,0,0,0,2,253,0,2,252,0,0,0,0,11,252,0,2,252,0,0,0,0,47,240,0,2,252,0,0,0,1,255,192,0,2,252,0,0,0,11,255,0,0,2,252,0,0,0,11,252,0,0,2,252,0,0,0,2,208,0,0,2,248,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9760  靠
  96,151,33,35,59,36,2,252,0,14,128,11,224,0,0,0,0,0,63,128,11,224,0,0,0,0,0,127,255,255,255,255,255,192,0,0,255,255,255,255,255,255,192,0,3,252,0,15,224,0,0,0,0,11,244,0,11,224,0,0,0,0,23,245,85,95,229,85,85,84,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,254,0,0,0,0,11,224,0,0,0,0,0,0,0,5,80,0,0,0,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,253,0,0,0,0,63,128,0,0,253,0,0,0,0,63,128,0,0,255,255,255,255,255,255,128,0,0,255,255,255,255,255,255,128,0,0,0,15,208,11,240,0,0,0,0,0,15,208,7,240,0,0,0,127,255,255,208,7,255,255,253,0,127,255,255,208,7,255,255,253,0,0,0,15,208,7,240,0,0,0,0,0,15,208,7,240,0,0,0,31,255,255,208,7,255,255,248,0,31,255,255,208,7,255,255,248,0,0,0,15,208,7,240,0,0,0,0,0,15,192,7,240,0,0,0,175,255,255,192,7,255,255,255,64,255,255,255,128,7,255,255,255,64,165,64,191,0,7,245,85,85,0,0,7,253,0,7,240,0,0,0,1,191,244,0,7,240,0,0,0,3,255,128,0,7,240,0,0,0,1,248,0,0,7,240,0,0,0,0,0,0,0,0,0,0,0,0,
  // 0x9762  面
  98,151,32,33,8,36,2,252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,47,208,0,0,0,0,0,0,47,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,128,0,0,0,0,0,0,63,64,0,0,0,31,255,255,255,255,255,255,244,31,255,255,255,255,255,255,244,31,255,255,255,255,255,255,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,234,171,240,3,244,31,192,47,255,255,240,3,244,31,192,47,255,255,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,234,171,240,3,244,31,192,47,255,255,240,3,244,31,192,47,255,255,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,192,47,64,3,240,3,244,31,255,255,255,255,255,255,244,31,255,255,255,255,255,255,244,31,255,255,255,255,255,255,244,31,192,0,0,0,0,3,244,31,192,0,0,0,0,3,244,0,0,0,0,0,0,0,0,
  // 0x9875  页
  117,152,32,33,8,36,2,252,127,255,255,255,255,255,255,254,127,255,255,255,255,255,255,254,127,255,255,255,255,255,255,254,0,0,0,47,192,0,0,0,0,0,0,63,128,0,0,0,0,0,0,127,64,0,0,0,0,0,0,191,0,0,0,0,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,255,255,255,255,255,255,64,0,253,0,0,0,0,63,64,0,253,0,0,0,0,63,64,0,253,0,11,240,0,63,64,0,253,0,11,240,0,63,64,0,253,0,11,240,0,63,64,0,253,0,11,240,0,63,64,0,253,0,11,240,0,63,64,0,253,0,11,240,0,63,64,0,253,0,11,240,0,63,64,0,253,0,11,240,0,63,64,0,253,0,15,224,0,63,64,0,253,0,15,224,0,63,64,0,253,0,47,192,0,63,64,0,253,0,127,199,144,63,64,0,0,1,255,79,253,0,0,0,0,11,254,11,255,208,0,0,0,127,248,0,191,252,0,0,27,255,208,0,11,255,128,6,255,254,0,0,0,255,244,255,255,224,0,0,0,31,253,63,253,0,0,0,0,2,252,30,64,0,0,0,0,0,112,0,0,0,0,0,0,0,0,
  // 0x9879  项
  121,152,34,32,32,36,1,253,0,0,0,63,255,255,255,255,208,0,0,0,63,255,255,255,255,208,127,255,255,85,85,255,255,255,208,127,255,255,0,0,255,0,0,0,127,255,255,0,0,254,0,0,0,0,63,64,0,1,252,0,0,0,0,63,64,15,255,255,255,252,0,0,63,64,15,255,255,255,252,0,0,63,64,15,255,255,255,252,0,0,63,64,15,192,0,0,252,0,0,63,64,15,192,0,0,252,0,0,63,64,15,192,63,64,252,0,0,63,64,15,192,63,64,252,0,0,63,64,15,192,63,64,252,0,0,63,64,15,192,63,64,252,0,0,63,64,15,192,63,64,252,0,0,63,64,15,192,63,64,252,0,0,63,64,15,192,63,64,252,0,0,63,66,79,192,63,64,252,0,0,63,255,143,192,63,0,252,0,0,127,255,207,192,127,0,252,0,111,255,254,15,192,127,0,252,0,191,255,144,15,192,254,0,252,0,191,244,0,0,1,253,0,0,0,125,0,0,0,3,252,56,0,0,0,0,0,0,15,244,255,64,0,0,0,0,0,127,224,127,224,0,0,0,0,2,255,128,15,253,0,0,0,0,127,253,0,2,255,64,0,0,7,255,224,0,0,127,208,0,0,2,254,64,0,0,15,128,0,0,0,224,0,0,0,2,0,
  // 0x9884  预
  132,152,34,33,41,36,1,252,63,255,255,245,255,255,255,255,208,63,255,255,249,255,255,255,255,208,63,255,255,241,255,255,255,255,208,0,0,31,208,0,3,244,0,0,0,0,63,128,0,7,240,0,0,2,64,255,0,0,11,224,0,0,7,247,252,0,63,255,255,255,0,11,255,240,0,63,255,255,255,0,0,255,208,0,63,255,255,255,0,0,47,248,0,63,0,0,63,0,0,7,254,0,63,0,0,63,0,0,1,254,0,63,2,160,63,0,191,255,255,254,63,3,240,63,0,191,255,255,254,63,3,240,63,0,191,255,255,253,63,3,240,63,0,0,15,192,252,63,3,240,63,0,0,15,192,248,63,3,240,63,0,0,15,193,244,63,3,240,63,0,0,15,195,240,63,3,240,63,0,0,15,195,224,63,7,240,63,0,0,15,192,64,63,7,224,63,0,0,15,192,0,63,11,224,63,0,0,15,192,0,63,15,208,63,0,0,15,192,0,42,31,192,42,0,0,15,192,0,0,63,129,0,0,0,15,192,0,0,191,95,128,0,0,15,192,0,2,254,47,240,0,0,15,192,0,15,248,11,252,0,0,31,192,0,191,224,1,255,64,15,255,192,15,255,64,0,127,208,15,255,192,7,248,0,0,31,192,11,249,0,2,128,0,0,7,0,0,0,0,0,0,0,0,0,0,
  // 0x9891  频
  145,152,34,35,59,36,1,252,0,0,189,0,0,0,0,0,0,0,0,189,0,0,0,0,0,0,0,0,189,0,31,255,255,255,192,3,208,189,0,31,255,255,255,192,3,224,191,255,31,255,255,255,192,3,224,191,255,64,0,252,0,0,3,224,191,255,64,1,252,0,0,3,224,189,0,0,2,244,0,0,3,224,189,0,0,3,240,0,0,3,224,189,0,11,255,255,255,0,3,224,189,0,11,255,255,255,0,191,255,255,255,203,234,170,191,0,191,255,255,255,203,192,0,47,0,191,255,255,255,203,192,248,47,0,0,1,248,0,11,192,248,47,0,0,1,248,0,11,192,248,47,0,1,145,248,0,11,192,248,47,0,3,241,248,15,139,192,248,47,0,3,225,248,31,139,192,248,47,0,11,209,248,47,75,192,244,47,0,15,193,248,63,11,193,244,47,0,31,129,248,126,11,193,244,47,0,63,65,248,253,11,193,244,47,0,127,1,249,252,11,194,240,47,0,44,1,255,244,11,195,240,47,0,0,0,175,240,11,195,240,47,0,0,0,47,192,0,7,208,0,0,0,0,191,64,0,15,223,64,0,0,3,254,0,0,47,175,224,0,0,31,248,0,0,191,11,252,0,1,255,208,0,7,253,1,255,0,47,255,0,1,191,244,0,63,192,47,244,0,1,255,128,0,15,208,14,64,0,0,184,0,0,3,64,0,0,0,0,0,0,0,0,0,
  // 0x989d  额
  157,152,34,35,59,36,1,252,0,1,160,0,0,0,0,0,0,0,3,244,0,0,0,0,0,0,0,2,252,0,31,255,255,255,192,42,171,255,170,159,255,255,255,208,63,255,255,255,223,255,255,255,208,63,255,255,255,192,1,248,0,0,63,0,0,15,192,2,244,0,0,63,5,0,15,192,3,240,0,0,63,15,192,15,192,7,224,0,0,47,47,128,15,143,255,255,255,0,0,127,255,252,15,255,255,255,0,0,255,255,254,15,234,170,191,0,3,250,171,252,15,192,0,63,0,31,224,3,248,15,193,244,63,0,127,137,15,240,15,193,244,63,0,46,63,255,192,15,193,244,63,0,4,63,255,0,15,193,244,63,0,0,15,255,192,15,193,244,63,0,0,191,255,248,15,194,244,63,0,11,255,135,255,143,194,244,63,0,127,253,0,191,207,194,240,63,0,63,208,0,31,15,195,240,63,0,47,170,170,168,15,195,240,63,0,1,255,255,252,15,195,240,63,0,1,255,255,252,15,199,224,63,0,1,244,0,252,15,139,208,42,0,1,244,0,252,0,15,194,0,0,1,244,0,252,0,47,143,192,0,1,244,0,252,0,127,15,244,0,1,244,0,252,1,254,3,253,0,1,255,255,252,11,252,0,255,128,1,255,255,252,191,240,0,47,224,1,254,170,253,255,128,0,11,208,1,164,0,252,184,0,0,2,128,0,0,0,0,0,0,0,0,0,
  // 0x98ce  风
  206,152,34,33,41,36,1,252,0,127,255,255,255,255,255,192,0,0,127,255,255,255,255,255,192,0,0,127,255,255,255,255,255,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,0,31,192,0,0,127,0,0,0,80,31,192,0,0,127,0,0,0,253,31,192,0,0,127,7,128,1,252,31,192,0,0,127,47,208,2,248,31,192,0,0,127,15,240,3,240,31,192,0,0,127,3,252,7,240,31,192,0,0,127,0,254,15,208,31,192,0,0,127,0,127,159,192,15,192,0,0,127,0,47,255,128,15,192,0,0,127,0,15,255,0,15,192,0,0,191,0,7,254,0,15,192,0,0,191,0,2,254,0,15,192,0,0,190,0,7,255,0,15,192,0,0,254,0,15,255,192,15,192,0,0,253,0,47,239,224,15,192,0,0,253,0,127,143,244,15,192,0,1,252,1,255,3,252,15,208,0,2,252,7,252,2,254,15,208,0,3,248,31,244,0,255,11,208,128,3,244,127,224,0,127,203,224,208,7,240,255,128,0,63,135,225,240,15,240,62,0,0,13,3,241,240,31,224,8,0,0,0,3,246,224,63,192,0,0,0,0,2,255,224,127,128,0,0,0,0,0,255,192,31,0,0,0,0,0,0,127,128,6,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,
  // 0x9971  饱
  113,153,34,34,50,36,1,253,0,168,0,0,9,0,0,0,0,0,252,0,0,47,128,0,0,0,0,252,0,0,63,64,0,0,0,1,248,0,0,127,0,0,0,0,2,248,0,0,191,255,255,254,0,3,255,255,128,255,255,255,254,0,3,255,255,210,255,255,255,254,0,3,255,255,195,240,0,0,190,0,11,224,31,207,224,0,0,190,0,15,192,47,95,192,0,0,190,0,15,192,63,127,128,0,0,190,0,47,128,63,255,255,255,224,190,0,63,64,189,191,255,255,224,190,0,191,42,108,59,254,175,224,190,0,189,63,0,19,244,3,224,190,0,44,63,0,3,244,3,224,190,0,0,63,0,3,244,3,224,190,0,0,63,0,3,244,3,224,189,0,0,63,0,3,244,3,224,189,0,0,63,0,3,254,175,224,189,0,0,63,0,3,255,255,224,253,0,0,63,0,3,255,255,224,252,0,0,63,0,3,244,1,255,252,0,0,63,0,3,244,0,255,248,0,0,63,2,3,244,0,255,224,0,0,63,15,67,244,0,0,0,0,0,63,191,131,244,0,0,6,0,0,63,255,3,244,0,0,11,208,0,63,252,3,244,0,0,11,208,0,127,224,2,248,0,0,31,192,0,255,64,1,255,255,255,255,192,0,253,0,0,255,255,255,255,64,0,116,0,0,47,255,255,248,0,0,0,0,0,0,0,0,0,0,
  // 0x9a6c  马
  108,154,31,33,8,36,2,252,3,255,255,255,255,255,244,0,3,255,255,255,255,255,240,0,3,255,255,255,255,255,240,0,0,0,0,0,0,7,240,0,0,0,0,0,0,7,240,0,0,5,64,0,0,7,240,0,0,15,208,0,0,11,240,0,0,15,192,0,0,11,224,0,0,15,192,0,0,15,224,0,0,31,192,0,0,15,208,0,0,31,192,0,0,15,208,0,0,47,192,0,0,15,192,0,0,47,128,0,0,15,192,0,0,47,128,0,0,31,192,0,0,63,255,255,255,255,255,252,0,63,255,255,255,255,255,252,0,63,255,255,255,255,255,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,252,0,0,0,0,0,0,2,248,0,0,0,0,0,0,3,248,0,0,0,0,0,0,3,244,255,255,255,255,255,254,3,244,255,255,255,255,255,254,3,240,255,255,255,255,255,254,7,240,0,0,0,0,0,0,11,240,0,0,0,0,0,0,15,224,0,0,0,0,0,0,15,208,0,0,0,0,0,0,63,192,0,0,0,0,11,255,255,192,0,0,0,0,3,255,255,0,0,0,0,0,3,255,248,0,0,0,0,0,0,0,0,0,
  // 0x9a71  驱
  113,154,34,32,32,36,1,253,47,255,255,66,255,255,255,255,192,47,255,255,66,255,255,255,255,192,47,255,255,66,255,255,255,255,192,0,0,47,66,248,0,0,0,0,0,0,47,2,244,0,0,0,0,7,208,63,2,244,0,0,184,0,11,208,63,2,244,112,0,253,0,11,208,63,2,245,252,1,252,0,11,192,63,2,244,254,2,248,0,11,192,63,2,244,63,67,244,0,15,192,62,2,244,31,199,240,0,15,192,126,2,244,15,255,224,0,15,192,126,2,244,3,255,192,0,15,192,125,2,244,1,255,128,0,15,128,189,2,244,0,255,0,0,31,255,255,242,244,0,191,64,0,31,255,255,242,244,1,255,192,0,26,170,171,226,244,3,255,224,0,0,0,7,226,244,7,247,244,0,0,0,7,226,244,15,226,252,0,0,0,7,226,244,63,192,253,0,0,27,215,210,244,191,64,191,0,27,255,219,210,245,254,0,63,128,255,255,75,210,247,252,0,47,0,191,144,15,194,244,180,0,8,0,16,0,15,194,244,16,0,0,0,0,0,15,194,244,0,0,0,0,0,0,31,130,255,255,255,255,224,0,0,63,130,255,255,255,255,224,0,191,255,2,255,255,255,255,224,0,127,253,0,0,0,0,0,0,0,42,160,0,0,0,0,0,0,
  // 0x9ad8  高
  216,154,32,35,24,36,2,252,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,0,0,0,15,208,0,0,0,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,191,255,255,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,255,255,255,255,224,0,0,11,255,255,255,255,224,0,0,11,229,85,85,95,224,0,0,11,224,0,0,11,224,0,0,11,224,0,0,11,224,0,0,11,229,85,85,95,224,0,0,11,255,255,255,255,224,0,0,11,255,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,255,255,255,255,255,255,244,15,255,255,255,255,255,255,244,15,255,255,255,255,255,255,244,15,192,0,0,0,0,3,244,15,192,21,85,85,84,3,244,15,192,63,255,255,252,3,244,15,192,63,255,255,252,3,244,15,192,63,0,0,252,3,244,15,192,63,0,0,252,3,244,15,192,63,0,0,252,3,244,15,192,63,85,85,252,3,244,15,192,63,255,255,252,3,244,15,192,63,255,255,252,7,244,15,192,63,0,0,15,255,240,15,192,42,0,0,11,255,240,15,192,0,0,0,7,255,128,0,0,0,0,0,0,0,0,
  // 0x9ec4  黄
  196,158,32,35,24,36,2,252,0,0,127,0,0,253,0,0,0,0,127,0,0,253,0,0,0,0,127,0,0,253,0,0,7,255,255,255,255,255,255,224,7,255,255,255,255,255,255,224,7,255,255,255,255,255,255,224,0,0,127,0,0,253,0,0,0,0,127,0,0,253,0,0,0,0,127,0,0,253,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,0,11,224,0,0,0,0,0,0,11,224,0,0,0,0,85,85,95,245,85,85,0,0,255,255,255,255,255,255,128,0,255,255,255,255,255,255,128,0,252,0,11,224,0,63,128,0,252,0,11,224,0,63,128,0,253,85,95,245,85,127,128,0,255,255,255,255,255,255,128,0,255,255,255,255,255,255,128,0,252,0,11,224,0,63,128,0,252,0,11,224,0,63,128,0,252,0,11,224,0,63,128,0,255,255,255,255,255,255,128,0,255,255,255,255,255,255,128,0,85,89,85,85,165,85,0,0,0,62,0,0,253,0,0,0,7,255,192,2,255,228,0,1,191,254,0,0,111,255,128,111,255,224,0,0,1,255,253,63,253,0,0,0,0,27,252,15,128,0,0,0,0,0,176,0,0,0,0,0,0,0,0,
  // 0x9ede  點
  222,158,34,34,50,36,1,253,0,0,0,0,0,3,240,0,0,15,255,255,255,64,3,240,0,0,15,255,255,255,64,3,240,0,0,15,149,245,111,64,3,240,0,0,15,64,240,31,64,3,240,0,0,15,180,241,255,64,3,240,0,0,15,120,242,239,64,3,240,0,0,15,124,243,223,64,3,244,0,0,15,108,243,95,64,3,255,255,224,15,93,247,31,64,3,255,255,224,15,68,246,31,64,3,255,255,224,15,64,240,31,64,3,240,0,0,15,255,255,255,64,3,240,0,0,15,255,255,255,64,3,240,0,0,5,86,249,85,0,3,240,0,0,0,2,244,0,0,3,240,0,0,10,171,250,170,0,3,240,0,0,31,255,255,255,79,255,255,255,0,31,255,255,255,79,255,255,255,0,0,2,244,0,15,255,255,255,0,0,2,244,0,15,192,0,63,0,0,2,249,90,143,192,0,63,0,63,255,255,255,207,192,0,63,0,63,255,255,255,207,192,0,63,0,63,234,149,84,15,192,0,63,0,0,0,4,60,15,192,0,63,0,6,31,46,62,15,192,0,63,0,11,207,31,31,79,192,0,63,0,15,143,79,11,207,192,0,63,0,15,79,75,71,223,255,255,255,0,47,11,139,131,143,255,255,255,0,63,11,134,64,15,255,255,255,0,189,5,0,0,15,192,0,63,0,40,0,0,0,15,192,0,42,0,
  // 0x9f50  齐
  80,159,33,35,59,36,2,252,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,0,0,0,15,224,0,0,0,0,191,255,255,255,255,255,255,254,0,191,255,255,255,255,255,255,255,0,191,255,255,255,255,255,255,255,0,0,7,244,0,0,31,224,0,0,0,2,252,0,0,127,192,0,0,0,0,255,0,0,255,0,0,0,0,0,63,208,7,253,0,0,0,0,0,15,252,31,244,0,0,0,0,0,2,255,255,208,0,0,0,0,0,0,191,255,0,0,0,0,0,0,1,191,255,144,0,0,0,0,0,111,255,255,254,64,0,0,0,107,255,253,47,255,254,144,0,191,255,255,144,1,255,255,255,64,255,255,228,0,0,7,255,255,0,127,251,164,0,0,10,235,253,0,36,3,248,0,0,15,208,4,0,0,3,248,0,0,15,208,0,0,0,3,248,0,0,15,208,0,0,0,3,248,0,0,15,208,0,0,0,3,244,0,0,15,208,0,0,0,3,244,0,0,15,208,0,0,0,7,244,0,0,15,208,0,0,0,11,240,0,0,15,208,0,0,0,15,240,0,0,15,208,0,0,0,47,224,0,0,15,208,0,0,0,191,192,0,0,15,208,0,0,2,255,64,0,0,15,208,0,0,31,254,0,0,0,15,208,0,0,15,248,0,0,0,15,208,0,0,2,208,0,0,0,15,208,0,0,0,0,0,0,0,0,0,0,0,
  // 0xff1a  ：
  26,255,6,24,48,36,15,2,47,128,191,224,255,240,255,240,191,224,47,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,128,191,224,255,240,255,240,191,224,47,128,
};

#endif // HAS_GRAPHICAL_TFT
