/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Latin Extended-A 36pt, capital 'A' height: 26px, width: 100%, range: 0x0100-0x017f
extern const uint8_t NotoSans_Medium_Latin_Extended_A_26[19795] = {
  130,26,0,1,127,1,34,247, // unifont_t
  // 0x0100  Ā
  24,31,186,24,0,0,0,10,170,170,128,0,0,15,255,255,192,0,0,15,255,255,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x0101  ā
  17,26,130,21,1,255,0,170,170,168,0,0,255,255,252,0,0,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x0102  Ă
  24,33,198,24,0,0,0,15,0,2,224,0,0,15,128,7,208,0,0,11,255,255,192,0,0,3,255,255,0,0,0,0,191,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x0103  ă
  17,28,140,21,1,255,2,224,0,60,0,1,244,0,188,0,0,255,255,248,0,0,127,255,224,0,0,11,255,64,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x0104  Ą
  24,35,210,24,0,247,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,3,253,0,0,0,0,2,240,0,0,0,0,11,192,0,0,0,0,31,64,0,0,0,0,63,0,0,0,0,0,63,0,0,0,0,0,63,148,0,0,0,0,31,253,0,0,0,0,7,253,0,0,0,0,0,0,
  // 0x0105  ą
  18,29,145,21,1,247,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,47,0,0,0,0,125,0,0,0,0,248,0,0,0,2,244,0,0,0,2,244,0,0,0,2,253,80,0,0,0,255,224,0,0,0,127,208,0,0,0,0,0,
  // 0x0106  Ć
  20,35,175,23,2,255,0,0,0,42,144,0,0,0,127,192,0,0,0,255,0,0,0,3,252,0,0,0,11,240,0,0,0,15,192,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,144,0,15,255,255,253,0,127,255,255,252,2,255,245,91,252,7,255,0,0,36,15,252,0,0,0,47,240,0,0,0,63,208,0,0,0,63,192,0,0,0,127,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,224,0,0,0,31,244,0,0,0,15,253,0,0,0,3,255,208,1,184,0,255,255,255,248,0,63,255,255,248,0,6,255,255,224,0,0,5,80,0,
  // 0x0107  ć
  15,29,116,18,2,255,0,0,10,160,0,0,63,224,0,0,127,128,0,0,254,0,0,3,248,0,0,11,224,0,0,0,0,0,0,0,0,0,0,6,170,64,0,255,255,244,7,255,255,240,15,254,171,224,63,240,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,128,0,0,63,192,0,0,63,244,0,176,15,255,255,240,3,255,255,240,0,127,255,208,0,1,84,0,
  // 0x0108  Ĉ
  20,35,175,23,2,255,0,0,26,144,0,0,0,63,244,0,0,0,255,252,0,0,3,252,255,0,0,11,240,47,192,0,47,128,7,240,0,0,0,0,0,0,0,0,0,0,0,0,191,255,144,0,15,255,255,253,0,127,255,255,252,2,255,245,91,252,7,255,0,0,36,15,252,0,0,0,47,240,0,0,0,63,208,0,0,0,63,192,0,0,0,127,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,224,0,0,0,31,244,0,0,0,15,253,0,0,0,3,255,208,1,184,0,255,255,255,248,0,63,255,255,248,0,6,255,255,224,0,0,5,80,0,
  // 0x0109  ĉ
  15,29,116,18,2,255,0,10,164,0,0,47,252,0,0,127,255,0,0,254,127,128,3,248,15,224,15,208,2,248,0,0,0,0,0,0,0,0,0,6,170,64,0,255,255,244,7,255,255,240,15,254,171,224,63,240,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,128,0,0,63,192,0,0,63,244,0,176,15,255,255,240,3,255,255,240,0,127,255,208,0,1,84,0,
  // 0x010a  Ċ
  20,34,170,23,2,255,0,0,6,128,0,0,0,31,224,0,0,0,31,240,0,0,0,31,224,0,0,0,6,64,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,144,0,15,255,255,253,0,127,255,255,252,2,255,245,91,252,7,255,0,0,36,15,252,0,0,0,47,240,0,0,0,63,208,0,0,0,63,192,0,0,0,127,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,224,0,0,0,31,244,0,0,0,15,253,0,0,0,3,255,208,1,184,0,255,255,255,248,0,63,255,255,248,0,6,255,255,224,0,0,5,80,0,
  // 0x010b  ċ
  15,28,112,18,2,255,0,2,144,0,0,11,240,0,0,15,244,0,0,11,240,0,0,1,128,0,0,0,0,0,0,0,0,0,0,6,170,64,0,255,255,244,7,255,255,240,15,254,171,224,63,240,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,128,0,0,63,192,0,0,63,244,0,176,15,255,255,240,3,255,255,240,0,127,255,208,0,1,84,0,
  // 0x010c  Č
  20,35,175,23,2,255,0,42,0,1,160,0,31,208,15,224,0,7,244,63,128,0,2,254,254,0,0,0,191,252,0,0,0,63,240,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,144,0,15,255,255,253,0,127,255,255,252,2,255,245,91,252,7,255,0,0,36,15,252,0,0,0,47,240,0,0,0,63,208,0,0,0,63,192,0,0,0,127,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,224,0,0,0,31,244,0,0,0,15,253,0,0,0,3,255,208,1,184,0,255,255,255,248,0,63,255,255,248,0,6,255,255,224,0,0,5,80,0,
  // 0x010d  č
  15,29,116,18,2,255,10,64,0,164,11,224,7,240,3,252,47,208,0,255,191,64,0,63,253,0,0,31,248,0,0,0,0,0,0,0,0,0,0,6,170,64,0,255,255,244,7,255,255,240,15,254,171,224,63,240,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,128,0,0,63,192,0,0,63,244,0,176,15,255,255,240,3,255,255,240,0,127,255,208,0,1,84,0,
  // 0x010e  Ď
  21,34,204,26,3,0,1,164,0,10,64,0,0,254,0,127,0,0,0,63,130,252,0,0,0,15,251,240,0,0,0,3,255,208,0,0,0,1,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,170,169,0,0,0,191,255,255,248,0,0,191,255,255,255,64,0,191,170,175,255,224,0,191,64,0,127,248,0,191,64,0,11,253,0,191,64,0,2,255,0,191,64,0,0,255,64,191,64,0,0,191,128,191,64,0,0,127,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,127,192,191,64,0,0,191,128,191,64,0,0,255,64,191,64,0,2,255,0,191,64,0,11,253,0,191,64,0,127,248,0,191,149,91,255,240,0,191,255,255,255,128,0,191,255,255,248,0,0,191,255,254,64,0,0,
  // 0x010f  ď
  24,29,174,22,2,255,0,0,0,5,64,84,0,0,0,31,209,253,0,0,0,31,209,252,0,0,0,31,210,244,0,0,0,31,211,240,0,0,0,31,211,208,0,0,0,31,209,64,0,0,0,31,208,0,0,26,164,31,208,0,1,255,255,31,208,0,11,255,255,223,208,0,31,254,91,255,208,0,63,224,0,255,208,0,127,192,0,127,208,0,191,64,0,63,208,0,255,0,0,47,208,0,255,0,0,31,208,0,255,0,0,31,208,0,255,0,0,31,208,0,255,0,0,31,208,0,255,0,0,31,208,0,255,0,0,47,208,0,191,64,0,63,208,0,127,192,0,127,208,0,63,240,1,255,208,0,15,255,255,239,208,0,7,255,255,143,208,0,0,191,253,15,208,0,0,5,64,0,0,0,
  // 0x0110  Đ
  23,26,156,26,1,0,6,170,170,144,0,0,7,255,255,255,128,0,7,255,255,255,244,0,7,254,170,255,254,0,7,244,0,7,255,128,7,244,0,0,191,208,7,244,0,0,47,240,7,244,0,0,15,244,7,244,0,0,11,248,7,244,0,0,7,252,7,244,0,0,3,252,91,249,85,0,3,252,255,255,255,64,3,252,255,255,255,64,3,252,255,255,255,0,3,252,7,244,0,0,3,252,7,244,0,0,7,252,7,244,0,0,11,248,7,244,0,0,15,244,7,244,0,0,47,240,7,244,0,0,191,208,7,244,0,7,255,128,7,249,85,191,254,0,7,255,255,255,248,0,7,255,255,255,128,0,7,255,255,228,0,0,
  // 0x0111  đ
  20,29,145,23,2,255,0,0,0,5,64,0,0,0,31,208,0,0,0,31,208,0,1,85,111,229,0,11,255,255,255,0,11,255,255,255,0,1,85,111,229,0,0,0,31,208,0,5,64,31,208,0,191,253,31,208,7,255,255,159,208,31,255,255,255,208,63,240,2,255,208,127,192,0,127,208,191,128,0,63,208,255,0,0,47,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,47,208,191,64,0,63,208,127,192,0,127,208,63,240,1,255,208,31,255,255,239,208,7,255,255,143,208,0,191,253,15,208,0,5,64,0,0,
  // 0x0112  Ē
  15,31,124,20,3,0,6,170,170,144,11,255,255,208,11,255,255,208,0,0,0,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x0113  ē
  17,26,130,21,2,255,2,170,170,160,0,3,255,255,240,0,3,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x0114  Ĕ
  15,33,132,20,3,0,15,64,2,240,15,192,7,224,7,255,255,192,2,255,255,64,0,127,248,0,0,0,0,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x0115  ĕ
  17,28,140,21,2,255,11,128,0,244,0,7,208,2,240,0,3,255,255,224,0,1,255,255,192,0,0,47,253,0,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x0116  Ė
  15,33,132,20,3,0,0,6,128,0,0,15,240,0,0,15,240,0,0,15,240,0,0,2,128,0,0,0,0,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x0117  ė
  17,28,140,21,2,255,0,2,144,0,0,0,11,244,0,0,0,15,244,0,0,0,11,244,0,0,0,1,144,0,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x0118  Ę
  15,35,140,20,3,247,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,0,0,7,208,0,0,31,128,0,0,63,0,0,0,126,0,0,0,125,0,0,0,127,84,0,0,63,252,0,0,15,248,0,0,0,0,
  // 0x0119  ę
  17,29,145,21,2,247,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,253,0,0,0,86,244,0,0,0,7,208,0,0,0,15,128,0,0,0,31,64,0,0,0,47,64,0,0,0,47,213,0,0,0,15,254,0,0,0,7,254,0,0,0,0,0,0,
  // 0x011a  Ě
  15,34,136,20,3,0,26,0,1,164,15,208,11,240,3,248,63,192,0,254,255,0,0,127,252,0,0,47,244,0,0,0,0,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x011b  ě
  17,29,145,21,2,255,10,64,0,168,0,11,240,7,244,0,2,252,31,208,0,0,191,191,64,0,0,63,254,0,0,0,15,252,0,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x011c  Ĝ
  22,35,210,26,2,255,0,0,6,164,0,0,0,0,31,253,0,0,0,0,63,255,0,0,0,0,255,63,192,0,0,3,248,15,240,0,0,11,224,2,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,255,228,0,0,11,255,255,255,192,0,63,255,255,255,128,1,255,249,85,191,64,3,255,128,0,2,0,15,252,0,0,0,0,31,240,0,0,0,0,63,224,0,0,0,0,63,192,0,0,0,0,127,128,0,0,0,0,191,64,0,0,0,0,255,64,0,0,0,0,255,0,0,191,255,208,255,0,0,255,255,208,255,64,0,255,255,208,191,64,0,106,175,208,191,128,0,0,31,208,127,192,0,0,31,208,63,192,0,0,31,208,47,224,0,0,31,208,31,244,0,0,31,208,11,254,0,0,31,208,3,255,208,0,111,208,0,255,255,255,255,208,0,47,255,255,255,208,0,2,255,255,254,64,0,0,1,84,0,0,
  // 0x011d  ĝ
  18,37,185,22,2,247,0,2,168,0,0,0,15,254,0,0,0,47,255,64,0,0,191,111,208,0,2,252,11,240,0,7,224,1,252,0,0,0,0,0,0,0,0,0,0,0,0,26,160,5,64,2,255,255,15,208,11,255,255,207,208,31,254,91,255,208,63,224,0,255,208,127,192,0,127,208,191,64,0,63,208,255,0,0,47,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,47,208,191,64,0,63,208,127,192,0,127,208,63,240,1,255,208,15,255,191,255,208,7,255,255,159,208,0,191,253,31,208,0,5,64,31,208,0,0,0,47,192,0,0,0,63,192,0,0,0,63,192,36,0,0,255,64,47,233,91,255,0,47,255,255,252,0,31,255,255,224,0,0,90,165,0,0,
  // 0x011e  Ğ
  22,34,204,26,2,255,0,7,192,0,244,0,0,3,208,2,240,0,0,3,255,255,224,0,0,0,255,255,192,0,0,0,47,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,255,228,0,0,11,255,255,255,192,0,63,255,255,255,128,1,255,249,85,191,64,3,255,128,0,2,0,15,252,0,0,0,0,31,240,0,0,0,0,63,224,0,0,0,0,63,192,0,0,0,0,127,128,0,0,0,0,191,64,0,0,0,0,255,64,0,0,0,0,255,0,0,191,255,208,255,0,0,255,255,208,255,64,0,255,255,208,191,64,0,106,175,208,191,128,0,0,31,208,127,192,0,0,31,208,63,192,0,0,31,208,47,224,0,0,31,208,31,244,0,0,31,208,11,254,0,0,31,208,3,255,208,0,111,208,0,255,255,255,255,208,0,47,255,255,255,208,0,2,255,255,254,64,0,0,1,84,0,0,
  // 0x011f  ğ
  18,36,180,22,2,247,3,192,0,184,0,3,224,1,248,0,1,255,255,240,0,0,191,255,208,0,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,26,160,5,64,2,255,255,15,208,11,255,255,207,208,31,254,91,255,208,63,224,0,255,208,127,192,0,127,208,191,64,0,63,208,255,0,0,47,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,47,208,191,64,0,63,208,127,192,0,127,208,63,240,1,255,208,15,255,191,255,208,7,255,255,159,208,0,191,253,31,208,0,5,64,31,208,0,0,0,47,192,0,0,0,63,192,0,0,0,63,192,36,0,0,255,64,47,233,91,255,0,47,255,255,252,0,31,255,255,224,0,0,90,165,0,0,
  // 0x0120  Ġ
  22,34,204,26,2,255,0,0,2,160,0,0,0,0,7,248,0,0,0,0,11,248,0,0,0,0,7,244,0,0,0,0,1,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,255,228,0,0,11,255,255,255,192,0,63,255,255,255,128,1,255,249,85,191,64,3,255,128,0,2,0,15,252,0,0,0,0,31,240,0,0,0,0,63,224,0,0,0,0,63,192,0,0,0,0,127,128,0,0,0,0,191,64,0,0,0,0,255,64,0,0,0,0,255,0,0,191,255,208,255,0,0,255,255,208,255,64,0,255,255,208,191,64,0,106,175,208,191,128,0,0,31,208,127,192,0,0,31,208,63,192,0,0,31,208,47,224,0,0,31,208,31,244,0,0,31,208,11,254,0,0,31,208,3,255,208,0,111,208,0,255,255,255,255,208,0,47,255,255,255,208,0,2,255,255,254,64,0,0,1,84,0,0,
  // 0x0121  ġ
  18,36,180,22,2,247,0,1,160,0,0,0,3,252,0,0,0,7,252,0,0,0,3,252,0,0,0,0,144,0,0,0,0,0,0,0,0,0,0,0,0,0,26,160,5,64,2,255,255,15,208,11,255,255,207,208,31,254,91,255,208,63,224,0,255,208,127,192,0,127,208,191,64,0,63,208,255,0,0,47,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,47,208,191,64,0,63,208,127,192,0,127,208,63,240,1,255,208,15,255,191,255,208,7,255,255,159,208,0,191,253,31,208,0,5,64,31,208,0,0,0,47,192,0,0,0,63,192,0,0,0,63,192,36,0,0,255,64,47,233,91,255,0,47,255,255,252,0,31,255,255,224,0,0,90,165,0,0,
  // 0x0122  Ģ
  22,34,204,26,2,248,0,0,111,255,228,0,0,11,255,255,255,192,0,63,255,255,255,128,1,255,249,85,191,64,3,255,128,0,2,0,15,252,0,0,0,0,31,240,0,0,0,0,63,224,0,0,0,0,63,192,0,0,0,0,127,128,0,0,0,0,191,64,0,0,0,0,255,64,0,0,0,0,255,0,0,191,255,208,255,0,0,255,255,208,255,64,0,255,255,208,191,64,0,106,175,208,191,128,0,0,31,208,127,192,0,0,31,208,63,192,0,0,31,208,47,224,0,0,31,208,31,244,0,0,31,208,11,254,0,0,31,208,3,255,208,0,111,208,0,255,255,255,255,208,0,47,255,255,255,208,0,2,255,255,254,64,0,0,1,84,0,0,0,0,0,0,0,0,0,0,2,248,0,0,0,0,3,244,0,0,0,0,7,240,0,0,0,0,11,224,0,0,0,0,15,192,0,0,0,0,15,64,0,0,
  // 0x0123  ģ
  18,37,185,22,2,247,0,0,40,0,0,0,0,188,0,0,0,0,252,0,0,0,2,248,0,0,0,3,244,0,0,0,11,240,0,0,0,0,0,0,0,0,0,0,0,0,0,26,160,5,64,2,255,255,15,208,11,255,255,207,208,31,254,91,255,208,63,224,0,255,208,127,192,0,127,208,191,64,0,63,208,255,0,0,47,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,47,208,191,64,0,63,208,127,192,0,127,208,63,240,1,255,208,15,255,191,255,208,7,255,255,159,208,0,191,253,31,208,0,5,64,31,208,0,0,0,47,192,0,0,0,63,192,0,0,0,63,192,36,0,0,255,64,47,233,91,255,0,47,255,255,252,0,31,255,255,224,0,0,90,165,0,0,
  // 0x0124  Ĥ
  21,34,204,27,3,0,0,0,106,64,0,0,0,1,255,208,0,0,0,3,255,240,0,0,0,15,243,252,0,0,0,63,128,255,0,0,0,253,0,47,128,0,0,0,0,0,0,0,0,0,0,0,0,0,106,0,0,0,106,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,255,255,255,255,64,191,255,255,255,255,64,191,255,255,255,255,64,191,85,85,85,191,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,
  // 0x0125  ĥ
  22,36,216,23,254,0,0,42,128,0,0,0,0,255,224,0,0,0,2,255,244,0,0,0,11,246,253,0,0,0,31,208,127,64,0,0,127,0,15,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,64,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,0,0,0,0,63,192,106,144,0,0,63,135,255,253,0,0,63,175,255,255,64,0,63,255,150,255,192,0,63,248,0,63,208,0,63,224,0,31,224,0,63,208,0,15,224,0,63,192,0,15,240,0,63,192,0,15,240,0,63,192,0,15,240,0,63,192,0,15,240,0,63,192,0,15,240,0,63,192,0,15,240,0,63,192,0,15,240,0,63,192,0,15,240,0,63,192,0,15,240,0,63,192,0,15,240,0,63,192,0,15,240,0,63,192,0,15,240,0,63,192,0,15,240,
  // 0x0126  Ħ
  27,26,182,27,0,0,1,168,0,0,1,169,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,171,255,170,170,171,255,168,255,255,255,255,255,255,252,255,255,255,255,255,255,252,2,253,0,0,2,254,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,255,255,255,255,253,0,2,255,255,255,255,253,0,2,255,255,255,255,253,0,2,253,85,85,86,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,2,253,0,0,1,253,0,
  // 0x0127  ħ
  20,28,140,23,0,0,1,84,0,0,0,3,252,0,0,0,3,252,0,0,0,3,252,0,0,0,255,255,255,240,0,255,255,255,240,0,87,253,85,80,0,3,252,0,0,0,3,252,0,0,0,3,252,11,254,0,3,248,191,255,224,3,250,255,255,248,3,255,228,31,252,3,255,64,3,253,3,254,0,1,254,3,253,0,0,255,3,252,0,0,255,3,252,0,0,255,3,252,0,0,255,3,252,0,0,255,3,252,0,0,255,3,252,0,0,255,3,252,0,0,255,3,252,0,0,255,3,252,0,0,255,3,252,0,0,255,3,252,0,0,255,3,252,0,0,255,
  // 0x0128  Ĩ
  14,33,132,13,255,0,1,160,0,160,15,254,1,240,47,255,251,224,62,31,255,192,124,1,255,0,0,0,0,0,0,0,0,0,6,170,170,0,11,255,255,64,7,255,255,0,0,47,224,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,0,47,208,0,2,255,253,0,11,255,255,64,11,255,255,64,
  // 0x0129  ĩ
  14,27,108,10,254,0,2,144,1,144,31,253,3,208,63,255,239,192,189,47,255,128,244,2,254,0,0,0,0,0,0,0,0,0,0,21,64,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,
  // 0x012a  Ī
  11,31,93,13,1,0,170,170,168,255,255,252,255,255,252,0,0,0,0,0,0,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,
  // 0x012b  ī
  12,25,75,10,255,0,106,170,169,191,255,253,191,255,253,0,0,0,0,0,0,0,85,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,
  // 0x012c  Ĭ
  13,33,132,13,0,0,184,0,15,64,125,0,47,0,63,255,254,0,31,255,252,0,2,255,208,0,0,0,0,0,0,0,0,0,26,170,168,0,47,255,253,0,31,255,252,0,0,191,128,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,11,255,244,0,47,255,253,0,47,255,253,0,
  // 0x012d  ĭ
  12,27,81,10,255,0,240,0,46,248,0,126,127,255,252,47,255,244,7,255,128,0,0,0,0,0,0,0,85,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,
  // 0x012e  Į
  11,35,105,13,1,247,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,0,15,192,0,63,0,0,125,0,0,252,0,0,252,0,0,254,80,0,127,244,0,47,240,0,0,0,
  // 0x012f  į
  7,36,72,10,1,247,6,128,15,240,15,240,15,240,2,128,0,0,0,0,5,80,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,11,192,47,0,126,0,188,0,252,0,190,80,127,244,31,244,0,0,
  // 0x0130  İ
  11,33,99,13,1,0,0,168,0,2,253,0,2,254,0,1,253,0,0,100,0,0,0,0,0,0,0,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,
  // 0x0131  ı
  4,20,20,10,3,0,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x0132  Ĳ
  19,34,170,23,1,248,106,170,160,2,168,191,255,244,3,252,127,255,240,3,252,2,254,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,2,253,0,3,252,47,255,208,3,252,191,255,244,3,252,191,255,244,3,252,0,0,0,3,252,0,0,0,7,248,0,0,0,15,244,0,0,37,127,240,0,0,63,255,208,0,0,63,255,128,0,0,47,248,0,0,0,0,0,0,
  // 0x0133  ĳ
  14,36,144,20,3,247,104,0,6,128,255,0,31,224,255,0,31,240,255,0,15,224,40,0,6,64,0,0,0,0,0,0,0,0,85,0,5,64,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,255,0,15,224,0,0,15,224,0,0,15,224,0,0,15,224,0,0,31,224,0,0,47,208,0,42,255,192,0,127,255,128,0,127,254,0,0,26,144,0,
  // 0x0134  Ĵ
  15,42,168,10,253,248,0,10,164,0,0,47,252,0,0,127,255,0,0,254,127,128,3,248,15,224,15,208,2,248,0,0,0,0,0,0,0,0,0,10,160,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,11,240,0,0,15,240,0,0,15,240,0,0,47,224,0,85,191,208,0,255,255,128,0,255,254,0,0,191,228,0,0,0,0,0,0,
  // 0x0135  ĵ
  13,37,148,10,254,247,0,42,128,0,0,255,224,0,2,255,244,0,11,246,253,0,31,192,127,0,127,0,31,192,0,0,0,0,0,0,0,0,0,21,64,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,128,0,0,191,128,0,170,255,64,0,255,254,0,0,255,248,0,0,106,64,0,0,
  // 0x0136  Ķ
  20,34,170,23,3,248,106,0,0,2,168,191,64,0,15,244,191,64,0,63,224,191,64,0,191,128,191,64,2,255,0,191,64,7,252,0,191,64,31,240,0,191,64,63,192,0,191,64,255,64,0,191,67,253,0,0,191,79,248,0,0,191,111,240,0,0,191,255,244,0,0,191,255,252,0,0,191,247,254,0,0,191,208,255,64,0,191,64,191,192,0,191,64,63,240,0,191,64,15,248,0,191,64,7,252,0,191,64,2,255,0,191,64,0,255,128,191,64,0,63,208,191,64,0,47,240,191,64,0,15,248,191,64,0,3,253,0,0,0,0,0,0,0,0,0,0,0,0,253,0,0,0,1,252,0,0,0,2,252,0,0,0,3,244,0,0,0,3,224,0,0,0,7,192,0,0,
  // 0x0137  ķ
  17,36,180,20,3,248,85,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,85,0,255,0,3,254,0,255,0,15,248,0,255,0,47,224,0,255,0,191,128,0,255,2,255,0,0,255,11,252,0,0,254,31,240,0,0,254,127,192,0,0,254,255,192,0,0,255,255,240,0,0,255,239,248,0,0,255,131,253,0,0,255,1,255,0,0,255,0,191,192,0,255,0,63,224,0,255,0,15,244,0,255,0,7,252,0,255,0,2,255,0,255,0,0,255,128,0,0,0,0,0,0,0,0,0,0,0,15,208,0,0,0,31,192,0,0,0,47,192,0,0,0,63,64,0,0,0,62,0,0,0,0,124,0,0,0,
  // 0x0138  ĸ
  17,20,100,20,3,0,85,0,0,85,0,255,0,3,254,0,255,0,11,248,0,255,0,31,240,0,255,0,127,192,0,255,0,255,0,0,255,3,253,0,0,255,15,244,0,0,255,47,224,0,0,255,191,192,0,0,255,255,240,0,0,255,255,248,0,0,255,211,253,0,0,255,1,255,0,0,255,0,191,192,0,255,0,63,224,0,255,0,15,244,0,255,0,7,252,0,255,0,2,255,0,255,0,0,255,128,
  // 0x0139  Ĺ
  16,34,136,19,3,0,0,170,0,0,3,254,0,0,7,248,0,0,15,224,0,0,63,128,0,0,190,0,0,0,0,0,0,0,0,0,0,0,106,0,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,253,191,255,255,253,191,255,255,253,
  // 0x013a  ĺ
  8,36,72,10,3,0,1,170,3,253,15,244,47,208,127,64,253,0,0,0,0,0,85,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,
  // 0x013b  Ļ
  16,34,136,19,3,248,106,0,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,253,191,255,255,253,191,255,255,253,0,0,0,0,0,0,0,0,0,7,244,0,0,11,240,0,0,11,224,0,0,15,192,0,0,31,64,0,0,47,0,0,
  // 0x013c  ļ
  6,36,72,10,2,248,21,64,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,0,0,0,0,31,208,31,192,47,128,63,0,126,0,188,0,
  // 0x013d  Ľ
  16,26,104,19,3,0,106,0,0,169,191,64,1,253,191,64,1,252,191,64,2,244,191,64,3,240,191,64,3,192,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,253,191,255,255,253,191,255,255,253,
  // 0x013e  ľ
  10,28,84,10,3,0,85,1,80,255,15,240,255,15,208,255,15,192,255,31,64,255,47,0,255,20,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
  // 0x013f  Ŀ
  16,26,104,19,3,0,106,0,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,10,64,191,64,47,208,191,64,63,208,191,64,47,208,191,64,6,64,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,253,191,255,255,253,191,255,255,253,
  // 0x0140  ŀ
  10,28,84,11,3,0,85,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,10,64,255,63,192,255,63,208,255,47,192,255,6,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
  // 0x0141  Ł
  19,26,130,19,0,0,1,168,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,7,0,0,2,253,127,64,0,2,255,255,128,0,2,255,253,0,0,2,255,224,0,0,11,255,0,0,0,127,253,0,0,0,63,253,0,0,0,42,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,253,0,0,0,2,254,85,85,80,2,255,255,255,244,2,255,255,255,244,2,255,255,255,244,
  // 0x0142  ł
  10,28,84,10,0,0,1,80,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,128,3,255,224,3,255,240,3,255,128,31,253,0,191,248,0,255,248,0,123,248,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,0,3,248,0,
  // 0x0143  Ń
  22,34,204,28,3,0,0,0,0,106,128,0,0,0,0,255,64,0,0,0,3,253,0,0,0,0,7,244,0,0,0,0,15,208,0,0,0,0,63,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,128,0,0,10,144,191,240,0,0,15,224,191,244,0,0,15,224,191,252,0,0,15,224,191,254,0,0,15,224,191,255,64,0,15,224,190,127,192,0,15,224,191,63,224,0,15,224,191,15,240,0,15,224,191,11,252,0,15,224,191,3,253,0,15,224,191,1,255,0,15,224,191,0,191,128,15,224,191,0,63,208,15,224,191,0,31,240,15,224,191,0,15,248,15,224,191,0,3,253,15,224,191,0,2,255,15,224,191,0,0,255,143,224,191,0,0,127,207,224,191,0,0,47,255,224,191,0,0,15,255,224,191,0,0,7,255,224,191,0,0,3,255,224,191,0,0,0,255,224,191,0,0,0,191,224,
  // 0x0144  ń
  17,28,140,23,3,0,0,0,10,160,0,0,0,63,224,0,0,0,127,192,0,0,0,255,0,0,0,3,248,0,0,0,11,224,0,0,0,0,0,0,0,0,0,0,0,0,84,1,170,64,0,252,47,255,244,0,253,191,255,253,0,255,254,91,255,0,255,224,0,255,64,255,128,0,127,128,255,64,0,63,128,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,
  // 0x0145  Ņ
  22,34,204,28,3,248,106,128,0,0,10,144,191,240,0,0,15,224,191,244,0,0,15,224,191,252,0,0,15,224,191,254,0,0,15,224,191,255,64,0,15,224,190,127,192,0,15,224,191,63,224,0,15,224,191,15,240,0,15,224,191,11,252,0,15,224,191,3,253,0,15,224,191,1,255,0,15,224,191,0,191,128,15,224,191,0,63,208,15,224,191,0,31,240,15,224,191,0,15,248,15,224,191,0,3,253,15,224,191,0,2,255,15,224,191,0,0,255,143,224,191,0,0,127,207,224,191,0,0,47,255,224,191,0,0,15,255,224,191,0,0,7,255,224,191,0,0,3,255,224,191,0,0,0,255,224,191,0,0,0,191,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,208,0,0,0,0,31,192,0,0,0,0,47,128,0,0,0,0,63,0,0,0,0,0,62,0,0,0,0,0,124,0,0,0,
  // 0x0146  ņ
  17,28,140,23,3,248,84,1,170,64,0,252,47,255,244,0,253,191,255,253,0,255,254,91,255,0,255,224,0,255,64,255,128,0,127,128,255,64,0,63,128,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,0,0,0,0,0,0,0,0,0,0,0,2,248,0,0,0,3,244,0,0,0,7,240,0,0,0,11,224,0,0,0,15,192,0,0,0,15,64,0,0,
  // 0x0147  Ň
  22,34,204,28,3,0,0,104,0,6,144,0,0,63,64,47,192,0,0,15,224,255,0,0,0,3,251,252,0,0,0,1,255,240,0,0,0,0,191,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,128,0,0,10,144,191,240,0,0,15,224,191,244,0,0,15,224,191,252,0,0,15,224,191,254,0,0,15,224,191,255,64,0,15,224,190,127,192,0,15,224,191,63,224,0,15,224,191,15,240,0,15,224,191,11,252,0,15,224,191,3,253,0,15,224,191,1,255,0,15,224,191,0,191,128,15,224,191,0,63,208,15,224,191,0,31,240,15,224,191,0,15,248,15,224,191,0,3,253,15,224,191,0,2,255,15,224,191,0,0,255,143,224,191,0,0,127,207,224,191,0,0,47,255,224,191,0,0,15,255,224,191,0,0,7,255,224,191,0,0,3,255,224,191,0,0,0,255,224,191,0,0,0,191,224,
  // 0x0148  ň
  17,28,140,23,3,0,10,64,0,164,0,11,224,7,244,0,2,252,31,208,0,0,255,191,64,0,0,63,254,0,0,0,15,252,0,0,0,0,0,0,0,0,0,0,0,0,84,1,170,64,0,252,47,255,244,0,253,191,255,253,0,255,254,91,255,0,255,224,0,255,64,255,128,0,127,128,255,64,0,63,128,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,
  // 0x0149  ŉ
  23,26,156,26,0,0,10,160,0,0,0,0,31,224,0,0,0,0,47,208,0,0,0,0,47,192,0,0,0,0,63,128,0,0,0,0,63,64,0,0,0,0,127,5,64,26,164,0,190,15,194,255,255,64,252,15,219,255,255,208,0,15,255,229,191,240,0,15,253,0,15,244,0,15,248,0,7,248,0,15,244,0,3,248,0,15,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,0,15,240,0,3,252,
  // 0x014a  Ŋ
  22,34,204,28,3,248,106,128,0,0,10,144,191,240,0,0,15,224,191,248,0,0,15,224,191,253,0,0,15,224,191,255,0,0,15,224,191,255,128,0,15,224,190,127,208,0,15,224,191,47,240,0,15,224,191,15,248,0,15,224,191,7,253,0,15,224,191,2,255,0,15,224,191,0,255,128,15,224,191,0,63,208,15,224,191,0,47,240,15,224,191,0,15,248,15,224,191,0,3,253,15,224,191,0,1,255,15,224,191,0,0,255,143,224,191,0,0,63,223,224,191,0,0,31,255,224,191,0,0,15,255,224,191,0,0,3,255,224,191,0,0,1,255,224,191,0,0,0,191,224,191,0,0,0,63,224,191,0,0,0,31,224,0,0,0,0,15,208,0,0,0,0,31,208,0,0,0,0,47,192,0,0,1,85,255,192,0,0,2,255,255,0,0,0,2,255,253,0,0,0,1,255,224,0,0,0,0,0,0,0,
  // 0x014b  ŋ
  17,29,145,23,3,247,84,1,170,64,0,252,47,255,244,0,253,191,255,253,0,255,254,91,255,0,255,224,0,255,64,255,192,0,127,128,255,64,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,127,128,0,0,106,255,64,0,0,127,255,0,0,0,127,252,0,0,0,26,144,0,
  // 0x014c  Ō
  24,32,192,28,2,255,0,6,170,170,144,0,0,7,255,255,224,0,0,7,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x014d  ō
  18,26,130,22,2,255,1,170,170,164,0,2,255,255,244,0,2,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x014e  Ŏ
  24,34,204,28,2,255,0,15,64,1,240,0,0,11,192,3,240,0,0,3,255,255,208,0,0,1,255,255,128,0,0,0,127,253,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x014f  ŏ
  18,28,140,22,2,255,3,208,0,124,0,3,240,1,248,0,1,255,255,240,0,0,191,255,208,0,0,31,254,0,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x0150  Ő
  24,35,210,28,2,255,0,0,106,66,168,0,0,0,255,11,244,0,0,2,252,15,224,0,0,7,240,47,128,0,0,15,208,126,0,0,0,47,64,248,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x0151  ő
  18,29,145,22,2,255,0,26,128,169,0,0,127,194,253,0,0,255,7,244,0,1,252,15,224,0,3,240,47,128,0,11,192,62,0,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x0152  Œ
  30,27,216,34,2,255,0,1,191,254,170,170,170,160,0,47,255,255,255,255,255,240,0,255,255,255,255,255,255,240,3,255,229,91,255,170,170,144,11,254,0,1,254,0,0,0,15,244,0,1,254,0,0,0,47,224,0,1,254,0,0,0,63,192,0,1,254,0,0,0,127,192,0,1,254,0,0,0,191,128,0,1,254,0,0,0,191,64,0,1,254,0,0,0,255,64,0,1,255,255,255,192,255,0,0,1,255,255,255,192,255,0,0,1,255,255,255,192,255,64,0,1,254,0,0,0,191,64,0,1,254,0,0,0,191,128,0,1,254,0,0,0,127,192,0,1,254,0,0,0,63,192,0,1,254,0,0,0,63,224,0,1,254,0,0,0,31,240,0,1,254,0,0,0,15,252,0,1,254,0,0,0,3,255,144,6,254,85,85,80,0,255,255,255,255,255,255,240,0,63,255,255,255,255,255,240,0,6,255,255,255,255,255,240,0,0,5,80,0,0,0,0,
  // 0x0153  œ
  31,21,168,34,2,255,0,6,169,0,0,170,128,0,0,255,255,208,11,255,252,0,7,255,255,248,63,255,255,64,15,254,91,254,255,145,191,192,63,224,0,255,253,0,31,224,127,192,0,63,248,0,15,240,191,64,0,47,240,0,7,244,255,0,0,31,240,0,7,244,255,0,0,31,250,170,175,248,255,0,0,15,255,255,255,248,255,0,0,15,255,255,255,248,255,0,0,15,240,0,0,0,255,0,0,31,240,0,0,0,255,0,0,47,240,0,0,0,191,64,0,63,244,0,0,0,63,192,0,127,252,0,0,0,47,244,1,255,255,64,1,160,15,255,255,253,127,254,255,224,2,255,255,244,31,255,255,224,0,127,255,128,2,255,255,128,0,1,80,0,0,5,64,0,
  // 0x0154  Ŕ
  19,34,170,23,3,0,0,0,10,164,0,0,0,47,240,0,0,0,127,192,0,0,0,255,0,0,0,2,252,0,0,0,7,224,0,0,0,0,0,0,0,0,0,0,0,0,106,170,165,0,0,191,255,255,224,0,191,255,255,253,0,191,170,191,255,0,191,64,1,255,128,191,64,0,127,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,127,128,191,64,2,255,0,191,234,191,253,0,191,255,255,244,0,191,255,255,128,0,191,170,191,192,0,191,64,47,208,0,191,64,15,240,0,191,64,11,248,0,191,64,3,253,0,191,64,1,255,0,191,64,0,191,128,191,64,0,63,192,191,64,0,47,240,191,64,0,15,244,191,64,0,7,252,
  // 0x0155  ŕ
  12,28,84,15,3,0,0,1,169,0,7,252,0,15,244,0,47,208,0,127,64,0,252,0,0,0,0,0,0,0,84,1,169,252,15,254,253,63,253,254,255,253,255,248,0,255,208,0,255,128,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
  // 0x0156  Ŗ
  19,34,170,23,3,248,106,170,165,0,0,191,255,255,224,0,191,255,255,253,0,191,170,191,255,0,191,64,1,255,128,191,64,0,127,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,127,128,191,64,2,255,0,191,234,191,253,0,191,255,255,244,0,191,255,255,128,0,191,170,191,192,0,191,64,47,208,0,191,64,15,240,0,191,64,11,248,0,191,64,3,253,0,191,64,1,255,0,191,64,0,191,128,191,64,0,63,192,191,64,0,47,240,191,64,0,15,244,191,64,0,7,252,0,0,0,0,0,0,0,0,0,0,0,0,253,0,0,0,1,253,0,0,0,1,252,0,0,0,3,244,0,0,0,3,224,0,0,0,7,192,0,0,
  // 0x0157  ŗ
  13,28,112,15,2,248,21,0,106,64,63,3,255,128,63,79,255,64,63,191,255,64,63,254,0,0,63,244,0,0,63,224,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,0,0,0,0,0,0,0,0,31,208,0,0,47,192,0,0,63,128,0,0,63,0,0,0,125,0,0,0,188,0,0,0,
  // 0x0158  Ř
  19,34,170,23,3,0,10,64,0,168,0,11,240,3,244,0,2,252,31,208,0,0,191,191,128,0,0,63,254,0,0,0,15,252,0,0,0,0,0,0,0,0,0,0,0,0,106,170,165,0,0,191,255,255,224,0,191,255,255,253,0,191,170,191,255,0,191,64,1,255,128,191,64,0,127,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,127,128,191,64,2,255,0,191,234,191,253,0,191,255,255,244,0,191,255,255,128,0,191,170,191,192,0,191,64,47,208,0,191,64,15,240,0,191,64,11,248,0,191,64,3,253,0,191,64,1,255,0,191,64,0,191,128,191,64,0,63,192,191,64,0,47,240,191,64,0,15,244,191,64,0,7,252,
  // 0x0159  ř
  13,28,112,15,2,0,104,0,6,128,63,64,47,128,31,208,254,0,7,251,252,0,2,255,240,0,0,255,208,0,0,0,0,0,0,0,0,0,21,0,106,64,63,3,255,128,63,79,255,64,63,191,255,64,63,254,0,0,63,244,0,0,63,224,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,
  // 0x015a  Ś
  16,35,140,20,2,255,0,0,10,160,0,0,63,224,0,0,191,128,0,0,254,0,0,3,248,0,0,11,224,0,0,0,0,0,0,0,0,0,0,111,255,144,7,255,255,253,31,255,255,253,63,249,86,252,191,192,0,20,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,208,0,0,63,253,0,0,15,255,208,0,3,255,253,0,0,127,255,208,0,6,255,244,0,0,47,252,0,0,7,254,0,0,0,255,0,0,0,255,0,0,0,191,0,0,0,255,64,0,1,255,249,0,11,253,255,255,255,248,255,255,255,224,111,255,254,0,0,21,64,0,
  // 0x015b  ś
  14,29,116,17,2,255,0,0,170,64,0,1,255,0,0,3,252,0,0,11,240,0,0,31,192,0,0,63,0,0,0,0,0,0,0,0,0,0,0,106,164,0,15,255,255,192,63,255,255,192,255,149,111,128,254,0,0,0,254,0,0,0,255,0,0,0,255,208,0,0,63,254,0,0,15,255,244,0,1,255,254,0,0,27,255,192,0,0,191,208,0,0,31,240,0,0,15,240,0,0,15,240,208,0,47,224,255,170,255,192,255,255,255,64,127,255,248,0,0,85,0,0,
  // 0x015c  Ŝ
  16,35,140,20,2,255,0,10,164,0,0,47,252,0,0,127,255,0,0,254,127,128,3,248,15,224,15,208,2,248,0,0,0,0,0,0,0,0,0,111,255,144,7,255,255,253,31,255,255,253,63,249,86,252,191,192,0,20,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,208,0,0,63,253,0,0,15,255,208,0,3,255,253,0,0,127,255,208,0,6,255,244,0,0,47,252,0,0,7,254,0,0,0,255,0,0,0,255,0,0,0,191,0,0,0,255,64,0,1,255,249,0,11,253,255,255,255,248,255,255,255,224,111,255,254,0,0,21,64,0,
  // 0x015d  ŝ
  14,29,116,17,2,255,0,106,128,0,0,255,208,0,3,255,244,0,11,242,252,0,47,192,191,0,190,0,31,192,0,0,0,0,0,0,0,0,0,106,164,0,15,255,255,192,63,255,255,192,255,149,111,128,254,0,0,0,254,0,0,0,255,0,0,0,255,208,0,0,63,254,0,0,15,255,244,0,1,255,254,0,0,27,255,192,0,0,191,208,0,0,31,240,0,0,15,240,0,0,15,240,208,0,47,224,255,170,255,192,255,255,255,64,127,255,248,0,0,85,0,0,
  // 0x015e  Ş
  16,35,140,20,2,247,0,111,255,144,7,255,255,253,31,255,255,253,63,249,86,252,191,192,0,20,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,208,0,0,63,253,0,0,15,255,208,0,3,255,253,0,0,127,255,208,0,6,255,244,0,0,47,252,0,0,7,254,0,0,0,255,0,0,0,255,0,0,0,191,0,0,0,255,64,0,1,255,249,0,11,253,255,255,255,248,255,255,255,224,111,255,254,0,0,31,192,0,0,31,64,0,0,63,224,0,0,7,248,0,0,0,252,0,0,0,252,0,0,171,248,0,1,255,240,0,0,169,64,0,
  // 0x015f  ş
  14,29,116,17,2,247,0,106,164,0,15,255,255,192,63,255,255,192,255,149,111,128,254,0,0,0,254,0,0,0,255,0,0,0,255,208,0,0,63,254,0,0,15,255,244,0,1,255,254,0,0,27,255,192,0,0,191,208,0,0,31,240,0,0,15,240,0,0,15,240,208,0,47,224,255,170,255,192,255,255,255,64,127,255,248,0,0,127,0,0,0,62,0,0,0,191,208,0,0,27,240,0,0,2,244,0,0,3,244,0,2,175,240,0,3,255,208,0,1,169,0,0,
  // 0x0160  Š
  16,35,140,20,2,255,10,64,0,164,11,224,7,240,3,252,47,208,0,255,191,64,0,63,253,0,0,31,248,0,0,0,0,0,0,0,0,0,0,111,255,144,7,255,255,253,31,255,255,253,63,249,86,252,191,192,0,20,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,208,0,0,63,253,0,0,15,255,208,0,3,255,253,0,0,127,255,208,0,6,255,244,0,0,47,252,0,0,7,254,0,0,0,255,0,0,0,255,0,0,0,191,0,0,0,255,64,0,1,255,249,0,11,253,255,255,255,248,255,255,255,224,111,255,254,0,0,21,64,0,
  // 0x0161  š
  14,29,116,17,2,255,104,0,6,128,127,64,47,128,31,208,254,0,7,251,252,0,2,255,240,0,0,255,192,0,0,0,0,0,0,0,0,0,0,106,164,0,15,255,255,192,63,255,255,192,255,149,111,128,254,0,0,0,254,0,0,0,255,0,0,0,255,208,0,0,63,254,0,0,15,255,244,0,1,255,254,0,0,27,255,192,0,0,191,208,0,0,31,240,0,0,15,240,0,0,15,240,208,0,47,224,255,170,255,192,255,255,255,64,127,255,248,0,0,85,0,0,
  // 0x0162  Ţ
  20,35,175,20,0,247,106,170,170,170,170,191,255,255,255,255,191,255,255,255,255,106,170,255,170,169,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,61,0,0,0,0,188,0,0,0,0,255,128,0,0,0,31,224,0,0,0,7,240,0,0,0,7,240,0,0,6,175,224,0,0,7,255,128,0,0,2,164,0,0,
  // 0x0163  ţ
  13,33,132,14,0,247,0,60,0,0,0,188,0,0,0,252,0,0,0,252,0,0,3,253,85,64,47,255,255,128,127,255,255,128,43,254,170,64,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,253,0,0,1,255,0,0,0,255,255,192,0,127,255,192,0,31,255,128,0,3,224,0,0,11,192,0,0,15,248,0,0,1,253,0,0,0,126,0,0,0,126,0,0,106,253,0,0,191,248,0,0,106,64,0,
  // 0x0164  Ť
  20,34,170,20,0,0,0,164,0,10,64,0,254,0,127,0,0,63,194,252,0,0,15,251,244,0,0,3,255,208,0,0,1,255,128,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,170,191,255,255,255,255,191,255,255,255,255,106,170,255,170,169,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,
  // 0x0165  ť
  18,29,145,14,0,255,0,0,0,5,80,0,0,0,15,240,0,0,0,15,208,0,0,0,15,192,0,60,0,31,64,0,188,0,47,0,0,252,0,20,0,0,252,0,0,0,3,253,85,64,0,47,255,255,128,0,127,255,255,128,0,43,254,170,64,0,2,252,0,0,0,2,252,0,0,0,2,252,0,0,0,2,252,0,0,0,2,252,0,0,0,2,252,0,0,0,2,252,0,0,0,2,252,0,0,0,2,252,0,0,0,2,252,0,0,0,2,252,0,0,0,2,253,0,0,0,1,255,0,0,0,0,255,255,192,0,0,127,255,192,0,0,31,255,128,0,0,0,80,0,0,
  // 0x0166  Ŧ
  20,26,130,20,0,0,106,170,170,170,170,191,255,255,255,255,191,255,255,255,255,106,170,255,170,170,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,1,170,255,170,128,3,255,255,255,192,3,255,255,255,192,2,170,255,170,128,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,
  // 0x0167  ŧ
  13,25,100,14,0,255,0,60,0,0,0,188,0,0,0,252,0,0,0,252,0,0,3,253,85,64,47,255,255,128,127,255,255,128,43,254,170,64,2,252,0,0,2,252,0,0,2,252,0,0,23,253,85,0,63,255,255,64,63,255,255,64,23,253,85,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,253,0,0,1,255,0,0,0,255,255,192,0,127,255,192,0,31,255,128,0,0,80,0,
  // 0x0168  Ũ
  21,34,204,27,3,255,0,6,128,2,128,0,0,63,248,7,192,0,0,191,255,239,128,0,0,248,127,255,0,0,1,240,7,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x0169  ũ
  17,28,140,23,3,255,0,104,0,40,0,3,255,128,124,0,11,255,254,248,0,15,135,255,240,0,31,0,127,192,0,0,0,0,0,0,0,0,0,0,0,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x016a  Ū
  21,32,192,27,3,255,0,42,170,170,0,0,0,63,255,255,0,0,0,63,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x016b  ū
  17,26,130,23,3,255,2,170,170,160,0,3,255,255,240,0,3,255,255,240,0,0,0,0,0,0,0,0,0,0,0,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x016c  Ŭ
  21,34,204,27,3,255,0,184,0,15,0,0,0,125,0,47,0,0,0,63,255,254,0,0,0,31,255,248,0,0,0,2,255,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x016d  ŭ
  17,28,140,23,3,255,11,128,0,240,0,7,208,2,240,0,3,255,255,224,0,1,255,255,128,0,0,47,253,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x016e  Ů
  21,37,222,27,3,255,0,0,105,0,0,0,0,2,255,208,0,0,0,7,231,240,0,0,0,11,128,244,0,0,0,15,64,244,0,0,0,11,129,240,0,0,0,3,255,224,0,0,0,1,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x016f  ů
  17,31,155,23,3,255,0,6,144,0,0,0,47,253,0,0,0,126,127,0,0,0,184,15,64,0,0,180,15,64,0,0,188,31,0,0,0,63,254,0,0,0,31,248,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x0170  Ű
  21,35,210,27,3,255,0,6,164,42,128,0,0,15,240,127,128,0,0,47,208,255,0,0,0,63,66,252,0,0,0,189,3,240,0,0,1,244,15,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x0171  ű
  17,29,145,23,3,255,0,106,66,168,0,0,255,7,248,0,1,253,15,240,0,3,244,47,192,0,11,208,63,0,0,31,64,252,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x0172  Ų
  21,35,210,27,3,247,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,254,0,63,224,0,3,253,0,15,253,0,47,252,0,7,255,255,255,240,0,1,255,255,255,192,0,0,47,255,255,0,0,0,0,20,125,0,0,0,0,0,248,0,0,0,0,2,240,0,0,0,0,3,240,0,0,0,0,3,240,0,0,0,0,3,249,64,0,0,0,1,255,208,0,0,0,0,127,208,0,0,0,0,0,0,0,
  // 0x0173  ų
  17,29,145,23,3,247,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,47,128,0,21,0,125,0,0,0,1,248,0,0,0,3,240,0,0,0,7,224,0,0,0,7,208,0,0,0,7,245,64,0,0,3,255,192,0,0,0,255,128,0,0,0,0,0,
  // 0x0174  Ŵ
  34,34,50,34,0,0,0,0,0,2,168,0,0,0,0,0,0,0,15,254,0,0,0,0,0,0,0,47,255,64,0,0,0,0,0,0,191,111,208,0,0,0,0,0,1,253,7,244,0,0,0,0,0,7,240,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,64,0,2,168,0,0,26,144,127,128,0,7,252,0,0,47,192,63,192,0,11,253,0,0,63,192,63,192,0,15,254,0,0,63,128,47,208,0,31,255,0,0,127,64,31,224,0,47,255,64,0,191,0,15,240,0,63,191,128,0,255,0,15,240,0,63,111,192,0,254,0,11,244,0,127,31,192,1,253,0,7,248,0,191,15,208,2,252,0,3,252,0,254,15,240,3,252,0,3,252,1,253,11,240,3,248,0,2,253,2,252,3,244,7,244,0,1,254,3,248,3,248,11,240,0,0,255,3,244,2,252,15,240,0,0,191,7,240,1,252,15,224,0,0,127,75,240,0,253,31,208,0,0,63,143,224,0,254,47,192,0,0,63,143,208,0,191,63,192,0,0,47,223,192,0,63,63,64,0,0,31,239,128,0,63,191,0,0,0,15,255,64,0,47,255,0,0,0,15,255,0,0,31,254,0,0,0,11,255,0,0,15,253,0,0,0,7,254,0,0,15,252,0,0,0,3,253,0,0,11,252,0,0,
  // 0x0175  ŵ
  29,28,224,29,0,0,0,0,0,106,64,0,0,0,0,0,1,255,208,0,0,0,0,0,3,255,240,0,0,0,0,0,15,243,252,0,0,0,0,0,63,128,255,0,0,0,0,0,190,0,47,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,85,64,0,21,64,127,128,0,255,192,0,127,64,63,192,0,255,192,0,191,0,63,192,1,255,208,0,255,0,47,208,2,251,240,0,254,0,15,224,3,243,240,2,253,0,15,240,7,243,244,3,252,0,11,240,11,226,248,3,248,0,7,244,15,209,252,7,244,0,3,248,15,192,252,11,240,0,3,252,31,192,254,15,240,0,2,252,63,128,191,15,224,0,1,253,63,0,127,31,208,0,0,254,127,0,63,111,192,0,0,254,126,0,47,175,192,0,0,127,189,0,31,191,64,0,0,63,252,0,15,255,0,0,0,63,252,0,15,255,0,0,0,47,244,0,11,254,0,0,0,31,240,0,7,253,0,0,
  // 0x0176  Ŷ
  21,34,204,21,0,0,0,0,106,64,0,0,0,1,255,208,0,0,0,3,255,240,0,0,0,15,243,252,0,0,0,63,128,255,0,0,0,253,0,47,128,0,0,0,0,0,0,0,0,0,0,0,0,0,170,64,0,0,106,128,127,192,0,0,255,64,63,208,0,1,255,0,31,240,0,3,252,0,11,244,0,7,248,0,3,252,0,15,240,0,2,253,0,31,224,0,0,255,0,63,192,0,0,191,128,127,128,0,0,63,192,255,0,0,0,47,226,253,0,0,0,15,243,252,0,0,0,7,255,244,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,255,128,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,
  // 0x0177  ŷ
  19,37,185,19,0,247,0,1,169,0,0,0,7,255,64,0,0,15,255,192,0,0,63,207,240,0,0,254,3,252,0,3,244,0,190,0,0,0,0,0,0,0,0,0,0,0,85,0,0,1,84,191,64,0,7,248,63,192,0,15,240,63,192,0,15,240,31,224,0,31,208,15,240,0,63,192,11,244,0,63,128,3,248,0,191,64,3,252,0,255,0,1,253,0,254,0,0,255,2,252,0,0,191,3,252,0,0,63,71,244,0,0,63,203,240,0,0,31,207,224,0,0,15,223,208,0,0,11,255,192,0,0,3,255,128,0,0,3,255,0,0,0,1,255,0,0,0,1,253,0,0,0,3,252,0,0,0,3,248,0,0,0,11,244,0,0,0,47,240,0,0,38,255,192,0,0,127,255,64,0,0,127,253,0,0,0,42,144,0,0,0,
  // 0x0178  Ÿ
  21,33,198,21,0,0,0,5,0,20,0,0,0,47,192,254,0,0,0,63,192,255,0,0,0,47,128,190,0,0,0,5,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,64,0,0,106,128,127,192,0,0,255,64,63,208,0,1,255,0,31,240,0,3,252,0,11,244,0,7,248,0,3,252,0,15,240,0,2,253,0,31,224,0,0,255,0,63,192,0,0,191,128,127,128,0,0,63,192,255,0,0,0,47,226,253,0,0,0,15,243,252,0,0,0,7,255,244,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,255,128,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,
  // 0x0179  Ź
  19,34,170,21,1,0,0,0,2,169,0,0,0,11,252,0,0,0,31,240,0,0,0,63,192,0,0,0,191,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,160,127,255,255,255,240,127,255,255,255,240,42,170,170,191,240,0,0,0,63,192,0,0,0,255,64,0,0,2,255,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,63,192,0,0,0,255,64,0,0,2,254,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,192,0,0,0,255,64,0,0,2,254,0,0,0,7,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,213,85,85,80,255,255,255,255,244,255,255,255,255,244,255,255,255,255,244,
  // 0x017a  ź
  15,28,112,17,1,0,0,0,42,144,0,0,191,192,0,0,255,0,0,3,252,0,0,11,240,0,0,31,128,0,0,0,0,0,0,0,0,0,21,85,85,80,63,255,255,248,63,255,255,248,42,170,175,244,0,0,31,224,0,0,63,192,0,0,255,0,0,2,254,0,0,7,252,0,0,15,240,0,0,47,208,0,0,127,128,0,0,255,0,0,3,253,0,0,11,248,0,0,31,240,0,0,63,192,0,0,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x017b  Ż
  19,33,165,21,1,0,0,0,168,0,0,0,1,253,0,0,0,2,254,0,0,0,1,253,0,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,160,127,255,255,255,240,127,255,255,255,240,42,170,170,191,240,0,0,0,63,192,0,0,0,255,64,0,0,2,255,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,63,192,0,0,0,255,64,0,0,2,254,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,192,0,0,0,255,64,0,0,2,254,0,0,0,7,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,213,85,85,80,255,255,255,255,244,255,255,255,255,244,255,255,255,255,244,
  // 0x017c  ż
  15,27,108,17,1,0,0,10,128,0,0,31,224,0,0,47,224,0,0,31,208,0,0,6,64,0,0,0,0,0,0,0,0,0,21,85,85,80,63,255,255,248,63,255,255,248,42,170,175,244,0,0,31,224,0,0,63,192,0,0,255,0,0,2,254,0,0,7,252,0,0,15,240,0,0,47,208,0,0,127,128,0,0,255,0,0,3,253,0,0,11,248,0,0,31,240,0,0,63,192,0,0,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x017d  Ž
  19,34,170,21,1,0,2,160,0,42,0,1,252,0,253,0,0,191,7,244,0,0,47,239,224,0,0,15,255,128,0,0,3,255,0,0,0,0,0,0,0,0,0,0,0,0,106,170,170,170,160,127,255,255,255,240,127,255,255,255,240,42,170,170,191,240,0,0,0,63,192,0,0,0,255,64,0,0,2,255,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,63,192,0,0,0,255,64,0,0,2,254,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,192,0,0,0,255,64,0,0,2,254,0,0,0,7,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,213,85,85,80,255,255,255,255,244,255,255,255,255,244,255,255,255,255,244,
  // 0x017e  ž
  15,28,112,17,1,0,42,0,2,160,31,192,15,224,7,244,127,128,2,254,254,0,0,191,252,0,0,63,240,0,0,0,0,0,0,0,0,0,21,85,85,80,63,255,255,248,63,255,255,248,42,170,175,244,0,0,31,224,0,0,63,192,0,0,255,0,0,2,254,0,0,7,252,0,0,15,240,0,0,47,208,0,0,127,128,0,0,255,0,0,3,253,0,0,11,248,0,0,31,240,0,0,63,192,0,0,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x017f  ſ
  11,28,84,12,3,0,0,89,64,11,255,244,47,255,240,127,250,224,191,128,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
};

#endif // HAS_GRAPHICAL_TFT
