/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium Greek 36pt, capital 'A' height: 26px, width: 100%, range: 0x0386-0x03ce, glyphs: 63
extern const uint8_t NotoSans_Medium_Greek_26[9565] = {
  130,26,134,3,206,3,34,247, // unifont_t
  // 0x0386  Ά
  26,26,182,26,0,0,15,244,0,127,128,0,0,31,240,0,255,192,0,0,47,192,0,255,224,0,0,63,128,2,255,240,0,0,127,0,3,251,244,0,0,189,0,7,243,248,0,0,0,0,11,242,252,0,0,0,0,15,224,253,0,0,0,0,31,192,255,0,0,0,0,63,192,191,0,0,0,0,63,128,63,128,0,0,0,191,0,63,192,0,0,0,255,0,31,208,0,0,1,253,0,15,224,0,0,2,252,0,11,240,0,0,3,255,255,255,244,0,0,7,255,255,255,252,0,0,15,255,255,255,252,0,0,15,250,170,170,254,0,0,47,208,0,0,255,0,0,63,192,0,0,191,64,0,127,128,0,0,127,128,0,255,0,0,0,63,192,0,255,0,0,0,47,208,2,254,0,0,0,15,240,3,252,0,0,0,15,240,
  // 0x0387  ·
  255,
  // 0x0388  Έ
  25,26,182,27,0,0,15,244,10,170,170,170,64,31,240,15,255,255,255,64,47,192,15,255,255,255,64,63,128,15,250,170,170,64,127,0,15,240,0,0,0,189,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,255,255,255,0,0,0,15,255,255,255,0,0,0,15,255,255,255,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,240,0,0,0,0,0,15,245,85,85,0,0,0,15,255,255,255,64,0,0,15,255,255,255,64,0,0,15,255,255,255,64,
  // 0x0389  Ή
  30,26,208,33,0,0,15,244,10,160,0,0,10,160,31,240,15,240,0,0,15,240,47,192,15,240,0,0,15,240,63,128,15,240,0,0,15,240,127,0,15,240,0,0,15,240,189,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,255,255,255,255,240,0,0,15,255,255,255,255,240,0,0,15,255,255,255,255,240,0,0,15,245,85,85,95,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,
  // 0x038a  Ί
  19,26,130,20,0,0,15,244,106,170,164,31,240,127,255,248,47,192,63,255,244,63,128,2,254,0,127,0,1,254,0,189,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,31,255,224,0,0,127,255,248,0,0,127,255,248,
  // 0x038b  ΋
  255,
  // 0x038c  Ό
  31,27,216,33,0,255,15,244,0,6,255,249,0,0,31,240,0,191,255,255,208,0,47,192,3,255,255,255,248,0,63,128,15,255,149,111,255,0,127,0,63,244,0,2,255,128,189,0,127,208,0,0,127,192,0,0,255,128,0,0,63,224,0,1,255,0,0,0,15,240,0,2,254,0,0,0,15,244,0,3,253,0,0,0,11,248,0,3,252,0,0,0,7,248,0,3,252,0,0,0,7,252,0,3,252,0,0,0,7,252,0,3,252,0,0,0,7,252,0,3,252,0,0,0,7,252,0,3,252,0,0,0,7,248,0,3,253,0,0,0,11,248,0,2,254,0,0,0,15,244,0,1,255,0,0,0,15,240,0,0,255,64,0,0,47,224,0,0,191,192,0,0,127,208,0,0,63,240,0,1,255,128,0,0,31,254,64,27,255,0,0,0,7,255,255,255,252,0,0,0,0,255,255,255,224,0,0,0,0,27,255,254,0,0,0,0,0,0,21,64,0,0,
  // 0x038d  ΍
  255,
  // 0x038e  Ύ
  29,26,208,29,0,0,15,244,106,128,0,0,42,128,31,240,63,192,0,0,127,128,47,192,31,224,0,0,255,0,63,128,15,244,0,2,254,0,127,0,7,252,0,3,252,0,189,0,3,253,0,11,248,0,0,0,1,255,0,15,240,0,0,0,0,255,64,47,208,0,0,0,0,63,192,63,192,0,0,0,0,47,208,191,64,0,0,0,0,15,240,255,0,0,0,0,0,11,246,252,0,0,0,0,0,3,255,248,0,0,0,0,0,2,255,240,0,0,0,0,0,0,255,224,0,0,0,0,0,0,127,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,0,0,0,0,63,192,0,0,
  // 0x038f  Ώ
  31,26,208,31,0,0,15,244,0,27,255,228,0,0,31,240,1,255,255,255,128,0,47,192,11,255,255,255,240,0,63,128,47,254,85,191,252,0,127,0,127,224,0,7,255,0,189,0,255,128,0,0,255,128,0,2,255,0,0,0,127,192,0,3,253,0,0,0,63,208,0,7,252,0,0,0,31,240,0,7,248,0,0,0,15,240,0,11,248,0,0,0,15,240,0,11,244,0,0,0,15,240,0,11,244,0,0,0,15,240,0,11,244,0,0,0,15,240,0,7,248,0,0,0,15,240,0,3,252,0,0,0,15,224,0,3,252,0,0,0,31,208,0,2,253,0,0,0,63,192,0,0,255,0,0,0,127,128,0,0,127,128,0,0,255,0,0,0,47,208,0,3,252,0,0,0,11,244,0,15,240,0,0,5,87,254,0,127,213,80,0,15,255,255,0,191,255,244,0,15,255,255,0,191,255,244,0,15,255,255,0,191,255,244,
  // 0x0390  ΐ
  255,
  // 0x0391  Α
  24,26,156,24,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x0392  Β
  19,26,130,24,3,0,106,170,169,64,0,191,255,255,248,0,191,255,255,255,64,191,170,175,255,192,191,64,0,127,224,191,64,0,47,240,191,64,0,15,240,191,64,0,15,240,191,64,0,31,224,191,64,0,63,208,191,64,1,255,128,191,255,255,254,0,191,255,255,224,0,191,255,255,255,0,191,64,5,255,208,191,64,0,47,240,191,64,0,15,244,191,64,0,7,248,191,64,0,7,248,191,64,0,11,248,191,64,0,15,244,191,64,0,47,240,191,64,22,255,224,191,255,255,255,192,191,255,255,254,0,191,255,255,144,0,
  // 0x0393  Γ
  14,26,104,18,3,0,106,170,170,160,191,255,255,240,191,255,255,240,191,170,170,160,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,
  // 0x0394  Δ
  23,26,156,23,0,0,0,0,31,224,0,0,0,0,63,240,0,0,0,0,127,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,252,255,0,0,0,3,252,127,0,0,0,3,244,63,128,0,0,11,240,47,192,0,0,15,224,31,208,0,0,31,208,15,224,0,0,63,192,11,240,0,0,63,128,7,248,0,0,191,0,3,252,0,0,255,0,2,253,0,1,253,0,0,254,0,3,252,0,0,255,0,3,248,0,0,127,64,11,244,0,0,63,192,15,240,0,0,47,192,31,224,0,0,31,224,47,192,0,0,15,240,63,213,85,85,95,244,127,255,255,255,255,252,191,255,255,255,255,252,191,255,255,255,255,252,
  // 0x0395  Ε
  15,26,104,20,3,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x0396  Ζ
  19,26,130,21,1,0,106,170,170,170,160,127,255,255,255,240,127,255,255,255,240,42,170,170,191,240,0,0,0,63,192,0,0,0,255,64,0,0,2,255,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,63,192,0,0,0,255,64,0,0,2,254,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,192,0,0,0,255,64,0,0,2,254,0,0,0,7,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,213,85,85,80,255,255,255,255,244,255,255,255,255,244,255,255,255,255,244,
  // 0x0397  Η
  21,26,156,27,3,0,106,0,0,0,106,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,255,255,255,255,64,191,255,255,255,255,64,191,255,255,255,255,64,191,85,85,85,191,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,
  // 0x0398  Θ
  24,27,162,28,2,255,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,66,170,170,128,255,255,67,255,255,208,255,255,67,255,255,208,255,255,66,170,170,128,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x0399  Ι
  11,26,78,13,1,0,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,
  // 0x039a  Κ
  20,26,130,23,3,0,106,0,0,2,168,191,64,0,15,244,191,64,0,63,224,191,64,0,191,128,191,64,2,255,0,191,64,7,252,0,191,64,31,240,0,191,64,63,192,0,191,64,255,64,0,191,67,253,0,0,191,79,248,0,0,191,111,240,0,0,191,255,244,0,0,191,255,252,0,0,191,247,254,0,0,191,208,255,64,0,191,64,191,192,0,191,64,63,240,0,191,64,15,248,0,191,64,7,252,0,191,64,2,255,0,191,64,0,255,128,191,64,0,63,208,191,64,0,47,240,191,64,0,15,248,191,64,0,3,253,
  // 0x039b  Λ
  23,26,156,23,0,0,0,0,47,208,0,0,0,0,63,240,0,0,0,0,191,240,0,0,0,0,255,244,0,0,0,1,254,252,0,0,0,2,253,252,0,0,0,3,248,254,0,0,0,7,240,191,0,0,0,11,240,127,64,0,0,15,224,63,128,0,0,31,192,47,192,0,0,63,192,31,208,0,0,63,128,15,224,0,0,191,0,11,240,0,0,255,0,7,244,0,0,254,0,3,252,0,2,252,0,2,252,0,3,252,0,1,253,0,7,248,0,0,255,0,11,240,0,0,191,0,15,240,0,0,127,128,31,224,0,0,63,192,47,192,0,0,47,208,63,192,0,0,31,224,127,128,0,0,15,240,255,0,0,0,11,244,
  // 0x039c  Μ
  27,26,182,33,3,0,106,160,0,0,0,42,164,191,244,0,0,0,127,248,191,252,0,0,0,191,248,191,252,0,0,0,255,248,191,253,0,0,1,255,248,191,191,0,0,3,247,248,191,127,0,0,3,243,248,191,63,128,0,11,227,248,191,47,192,0,15,211,248,191,31,208,0,31,195,248,191,15,224,0,47,131,248,191,11,240,0,63,67,248,191,3,244,0,127,3,248,191,3,248,0,254,3,248,191,1,252,0,252,3,248,191,0,253,2,252,3,248,191,0,255,3,244,3,248,191,0,127,7,240,3,248,191,0,63,75,224,3,248,191,0,47,207,208,3,248,191,0,31,239,192,3,248,191,0,15,255,128,3,248,191,0,11,255,0,3,248,191,0,7,255,0,3,248,191,0,3,254,0,3,248,191,0,2,252,0,3,248,
  // 0x039d  Ν
  22,26,156,28,3,0,106,128,0,0,10,144,191,240,0,0,15,224,191,244,0,0,15,224,191,252,0,0,15,224,191,254,0,0,15,224,191,255,64,0,15,224,190,127,192,0,15,224,191,63,224,0,15,224,191,15,240,0,15,224,191,11,252,0,15,224,191,3,253,0,15,224,191,1,255,0,15,224,191,0,191,128,15,224,191,0,63,208,15,224,191,0,31,240,15,224,191,0,15,248,15,224,191,0,3,253,15,224,191,0,2,255,15,224,191,0,0,255,143,224,191,0,0,127,207,224,191,0,0,47,255,224,191,0,0,15,255,224,191,0,0,7,255,224,191,0,0,3,255,224,191,0,0,0,255,224,191,0,0,0,191,224,
  // 0x039e  Ξ
  19,26,130,23,2,0,42,170,170,170,144,63,255,255,255,224,63,255,255,255,224,42,170,170,170,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,255,255,255,0,11,255,255,255,0,11,255,255,255,0,1,85,85,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,85,85,85,85,80,255,255,255,255,244,255,255,255,255,244,255,255,255,255,244,
  // 0x039f  Ο
  24,27,162,28,2,255,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x03a0  Π
  20,26,130,27,3,0,106,170,170,170,170,191,255,255,255,255,191,255,255,255,255,191,234,170,170,255,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,191,64,0,0,191,
  // 0x03a1  Ρ
  17,26,130,22,3,0,106,170,165,0,0,191,255,255,224,0,191,255,255,252,0,191,170,191,255,0,191,64,2,255,128,191,64,0,127,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,127,192,191,64,0,255,128,191,64,27,255,0,191,255,255,253,0,191,255,255,240,0,191,255,254,64,0,191,84,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,
  // 0x03a2  ΢
  255,
  // 0x03a3  Σ
  19,26,130,21,1,0,106,170,170,170,160,127,255,255,255,240,127,255,255,255,240,127,250,170,170,160,31,240,0,0,0,11,252,0,0,0,2,255,0,0,0,0,255,128,0,0,0,63,224,0,0,0,15,244,0,0,0,7,253,0,0,0,1,255,0,0,0,0,191,64,0,0,0,255,0,0,0,3,252,0,0,0,11,244,0,0,0,47,224,0,0,0,127,192,0,0,0,255,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,213,85,85,80,255,255,255,255,244,255,255,255,255,244,255,255,255,255,244,
  // 0x03a4  Τ
  20,26,130,20,0,0,106,170,170,170,170,191,255,255,255,255,191,255,255,255,255,106,170,255,170,169,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,
  // 0x03a5  Υ
  21,26,156,21,0,0,170,64,0,0,106,128,127,192,0,0,255,64,63,208,0,1,255,0,31,240,0,3,252,0,11,244,0,7,248,0,3,252,0,15,240,0,2,253,0,31,224,0,0,255,0,63,192,0,0,191,128,127,128,0,0,63,192,255,0,0,0,47,226,253,0,0,0,15,243,252,0,0,0,7,255,244,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,255,128,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,
  // 0x03a6  Φ
  27,27,189,31,2,255,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,2,254,0,0,0,0,11,255,255,255,128,0,0,191,255,255,255,248,0,7,255,255,255,255,255,64,15,254,65,253,6,255,208,63,240,1,253,0,47,240,127,192,1,253,0,15,244,191,64,1,253,0,7,252,255,0,1,253,0,3,252,254,0,1,253,0,2,252,254,0,1,253,0,2,252,254,0,1,253,0,2,252,255,0,1,253,0,3,252,255,0,1,253,0,3,252,191,128,1,253,0,11,244,63,208,1,253,0,31,240,31,248,1,253,0,191,208,11,255,230,254,111,255,128,1,255,255,255,255,253,0,0,47,255,255,255,224,0,0,1,107,255,165,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,1,253,0,0,0,0,0,0,0,0,0,0,
  // 0x03a7  Χ
  22,26,156,22,0,0,42,128,0,0,42,128,47,224,0,0,191,64,15,244,0,1,255,0,7,252,0,3,252,0,2,254,0,11,248,0,0,255,0,15,240,0,0,127,192,47,192,0,0,47,208,127,128,0,0,15,240,255,0,0,0,7,250,253,0,0,0,2,255,248,0,0,0,0,255,240,0,0,0,0,191,208,0,0,0,0,255,240,0,0,0,2,255,244,0,0,0,3,255,252,0,0,0,15,241,254,0,0,0,31,208,255,64,0,0,63,192,63,192,0,0,191,64,47,224,0,1,254,0,15,244,0,3,252,0,7,252,0,11,244,0,2,254,0,31,240,0,0,255,0,63,192,0,0,127,192,191,128,0,0,63,224,
  // 0x03a8  Ψ
  24,26,156,30,3,0,170,0,10,160,0,170,255,0,15,240,0,255,255,0,15,240,0,255,255,0,15,240,0,255,255,0,15,240,0,255,255,0,15,240,0,255,255,0,15,240,0,255,255,0,15,240,0,255,255,0,15,240,0,255,191,0,15,240,0,255,191,0,15,240,0,255,191,64,15,240,0,254,127,128,15,240,1,253,63,192,15,240,3,252,47,224,15,240,11,248,15,253,15,240,127,240,3,255,255,255,255,208,0,255,255,255,255,0,0,27,255,255,228,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,0,0,15,240,0,0,
  // 0x03a9  Ω
  25,26,182,26,1,0,0,1,191,254,64,0,0,0,31,255,255,248,0,0,0,191,255,255,255,0,0,3,255,229,91,255,192,0,11,254,0,0,127,240,0,15,248,0,0,31,244,0,47,240,0,0,11,252,0,63,192,0,0,3,253,0,127,192,0,0,2,254,0,191,128,0,0,1,255,0,191,64,0,0,0,255,0,255,64,0,0,0,255,0,191,64,0,0,0,255,0,191,64,0,0,0,255,0,191,64,0,0,0,255,0,127,128,0,0,1,254,0,63,192,0,0,2,253,0,47,208,0,0,3,252,0,15,240,0,0,7,244,0,7,244,0,0,15,224,0,2,253,0,0,63,192,0,0,191,64,0,255,0,0,85,127,224,7,253,85,0,255,255,240,11,255,255,64,255,255,240,11,255,255,64,255,255,240,11,255,255,64,
  // 0x03aa  Ϊ
  255,
  // 0x03ab  Ϋ
  255,
  // 0x03ac  ά
  20,29,145,23,2,255,0,0,47,224,0,0,0,63,192,0,0,0,127,128,0,0,0,191,0,0,0,0,253,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,0,26,160,5,64,2,255,254,15,208,11,255,255,207,208,31,254,91,255,208,63,224,0,255,208,127,192,0,127,208,191,64,0,63,208,255,0,0,47,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,47,208,191,64,0,63,208,127,192,0,127,208,63,240,1,255,224,15,255,255,239,255,7,255,255,139,255,0,191,253,3,255,0,5,64,0,20,
  // 0x03ad  έ
  15,29,116,17,1,255,0,0,63,224,0,0,63,192,0,0,127,64,0,0,191,0,0,0,252,0,0,1,248,0,0,0,0,0,0,0,0,0,0,26,233,64,2,255,255,248,11,255,255,252,31,249,86,244,47,208,0,16,47,192,0,0,47,192,0,0,31,224,0,0,11,254,149,0,1,255,254,0,2,255,254,0,31,249,84,0,63,192,0,0,127,128,0,0,127,64,0,0,127,128,0,0,63,224,0,24,47,255,255,248,11,255,255,248,1,255,255,224,0,1,84,0,
  // 0x03ae  ή
  17,37,185,22,3,247,0,3,253,0,0,0,7,248,0,0,0,15,240,0,0,0,15,208,0,0,0,31,192,0,0,0,47,0,0,0,0,0,0,0,0,0,0,0,0,0,84,1,170,64,0,252,47,255,240,0,253,191,255,252,0,255,254,91,254,0,255,224,1,255,0,255,128,0,255,64,255,64,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,42,64,
  // 0x03af  ί
  9,29,87,13,3,255,7,252,0,11,248,0,15,240,0,31,208,0,47,128,0,63,0,0,0,0,0,0,0,0,85,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,255,0,0,255,0,0,255,64,0,127,255,192,63,255,192,11,255,192,0,84,0,
  // 0x03b0  ΰ
  255,
  // 0x03b1  α
  20,21,105,23,2,255,0,26,160,5,64,2,255,254,15,208,11,255,255,207,208,31,254,91,255,208,63,224,0,255,208,127,192,0,127,208,191,64,0,63,208,255,0,0,47,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,47,208,191,64,0,63,208,127,192,0,127,208,63,240,1,255,224,15,255,255,239,255,7,255,255,139,255,0,191,253,3,255,0,5,64,0,20,
  // 0x03b2  β
  18,37,185,22,3,247,0,5,148,0,0,1,255,255,192,0,11,255,255,244,0,47,254,175,252,0,63,208,3,254,0,191,128,0,255,0,255,0,0,255,0,255,0,0,191,0,255,0,0,255,0,255,0,0,255,0,255,0,1,253,0,255,0,7,248,0,255,11,255,208,0,255,15,254,0,0,255,15,255,244,0,255,0,7,253,0,255,0,0,255,64,255,0,0,63,192,255,0,0,47,192,255,0,0,47,208,255,0,0,31,208,255,0,0,47,208,255,0,0,63,192,255,0,0,127,192,255,208,2,255,64,255,255,255,254,0,255,255,255,248,0,255,127,255,144,0,255,1,80,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,170,0,0,0,0,
  // 0x03b3  γ
  18,28,140,19,0,248,85,0,0,5,80,191,0,0,15,240,127,128,0,15,240,63,192,0,15,240,47,192,0,15,240,31,224,0,15,224,15,240,0,15,224,11,240,0,31,208,3,248,0,47,192,3,252,0,63,192,1,252,0,63,128,0,254,0,127,0,0,255,0,254,0,0,127,1,253,0,0,63,131,252,0,0,47,203,240,0,0,31,239,224,0,0,15,255,192,0,0,11,255,0,0,0,7,252,0,0,0,3,248,0,0,0,3,248,0,0,0,3,248,0,0,0,3,248,0,0,0,3,248,0,0,0,3,248,0,0,0,3,248,0,0,0,2,164,0,0,
  // 0x03b4  δ
  19,29,145,21,1,255,0,0,89,64,0,0,11,255,254,0,0,63,255,255,208,0,255,230,191,208,0,255,0,11,192,1,253,0,0,0,1,253,0,0,0,1,255,0,0,0,0,255,192,0,0,0,63,248,0,0,0,15,255,64,0,0,11,255,240,0,0,191,255,253,0,3,255,66,255,64,15,248,0,191,192,31,224,0,47,224,63,192,0,15,240,63,128,0,11,244,127,64,0,7,244,127,64,0,7,248,127,64,0,7,244,127,128,0,11,244,63,192,0,15,240,63,224,0,31,240,15,248,0,191,208,7,255,255,255,64,1,255,255,253,0,0,47,255,224,0,0,0,84,0,0,
  // 0x03b5  ε
  15,21,84,17,1,255,0,26,233,64,2,255,255,248,11,255,255,252,31,249,86,244,47,208,0,16,47,192,0,0,47,192,0,0,31,224,0,0,11,254,149,0,1,255,254,0,2,255,254,0,31,249,84,0,63,192,0,0,127,128,0,0,127,64,0,0,127,128,0,0,63,224,0,24,47,255,255,248,11,255,255,248,1,255,255,224,0,1,84,0,
  // 0x03b6  ζ
  15,36,144,17,2,248,21,85,85,84,63,255,255,248,63,255,255,248,42,169,95,244,0,0,31,224,0,0,127,192,0,0,255,0,0,3,253,0,0,11,248,0,0,31,224,0,0,63,192,0,0,255,64,0,2,254,0,0,7,252,0,0,15,240,0,0,47,208,0,0,63,192,0,0,127,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,64,0,0,191,208,0,0,63,249,0,0,31,255,248,0,7,255,255,192,0,111,255,240,0,1,191,244,0,0,11,248,0,0,3,248,0,0,3,244,0,0,7,240,0,0,15,240,0,0,31,208,0,0,5,64,
  // 0x03b7  η
  17,29,145,22,3,247,84,1,170,64,0,252,47,255,240,0,253,191,255,252,0,255,254,91,254,0,255,224,1,255,0,255,128,0,255,64,255,64,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,255,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,42,64,
  // 0x03b8  θ
  18,29,145,22,2,255,0,5,148,0,0,0,127,255,128,0,2,255,255,240,0,11,254,175,252,0,31,240,2,254,0,47,192,0,191,0,63,128,0,63,128,127,64,0,63,192,191,0,0,47,192,255,0,0,31,208,255,0,0,31,208,255,0,0,31,224,255,85,85,95,224,255,255,255,255,224,255,255,255,255,224,255,170,170,175,224,255,0,0,15,224,255,0,0,31,224,255,0,0,31,208,191,0,0,31,208,191,0,0,47,192,63,64,0,63,192,63,192,0,127,128,47,208,0,255,0,15,244,2,254,0,7,255,175,252,0,1,255,255,240,0,0,47,255,128,0,0,0,80,0,0,
  // 0x03b9  ι
  9,21,63,13,3,255,85,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,255,0,0,255,0,0,255,64,0,127,255,192,63,255,192,11,255,192,0,84,0,
  // 0x03ba  κ
  17,20,100,20,3,0,85,0,0,85,0,255,0,3,254,0,255,0,11,248,0,255,0,31,240,0,255,0,127,192,0,255,0,255,0,0,255,3,253,0,0,255,15,244,0,0,255,47,224,0,0,255,191,192,0,0,255,255,240,0,0,255,255,248,0,0,255,211,253,0,0,255,1,255,0,0,255,0,191,192,0,255,0,63,224,0,255,0,15,244,0,255,0,7,252,0,255,0,2,255,0,255,0,0,255,128,
  // 0x03bb  λ
  20,29,145,19,0,255,89,64,0,0,0,255,248,0,0,0,255,255,0,0,0,170,255,192,0,0,0,63,208,0,0,0,15,240,0,0,0,11,244,0,0,0,3,248,0,0,0,3,252,0,0,0,3,253,0,0,0,7,255,0,0,0,15,255,0,0,0,15,255,128,0,0,31,175,192,0,0,63,95,208,0,0,63,15,224,0,0,191,11,240,0,0,254,7,244,0,1,253,3,252,0,2,252,2,252,0,3,248,1,254,0,7,244,0,255,0,15,240,0,191,64,15,240,0,63,128,47,208,0,63,192,63,192,0,47,253,63,192,0,15,253,191,128,0,7,253,0,0,0,0,80,
  // 0x03bc  μ
  19,29,145,23,3,247,85,0,0,21,64,255,0,0,63,128,255,0,0,63,128,255,0,0,63,128,255,0,0,63,128,255,0,0,63,128,255,0,0,63,128,255,0,0,63,128,255,0,0,63,128,255,0,0,63,128,255,0,0,63,128,255,0,0,63,128,255,0,0,127,128,255,0,0,191,128,255,0,0,255,128,255,64,1,255,128,255,208,7,255,192,255,255,255,255,252,255,255,255,31,252,254,127,248,11,252,254,1,64,0,80,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,170,0,0,0,0,
  // 0x03bd  ν
  18,20,100,19,0,0,85,0,0,5,80,191,0,0,15,240,127,128,0,15,240,63,192,0,15,240,47,192,0,15,240,31,224,0,15,224,15,240,0,15,224,11,240,0,31,208,3,248,0,47,192,3,252,0,63,192,1,252,0,63,128,0,254,0,127,0,0,255,0,255,0,0,127,1,253,0,0,63,131,252,0,0,47,203,240,0,0,31,239,224,0,0,15,255,192,0,0,11,255,0,0,0,7,252,0,0,
  // 0x03be  ξ
  15,36,144,18,2,248,21,85,85,84,63,255,255,252,63,255,255,252,41,191,233,84,1,253,0,0,15,224,0,0,31,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,47,208,0,0,15,248,0,0,7,255,255,240,0,127,255,244,1,255,255,244,15,253,0,0,63,208,0,0,127,128,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,64,0,0,191,192,0,0,63,249,0,0,31,255,248,0,3,255,255,192,0,111,255,240,0,1,191,248,0,0,11,248,0,0,3,248,0,0,3,248,0,0,7,244,0,0,15,240,0,0,15,208,0,0,5,64,
  // 0x03bf  ο
  18,21,105,22,2,255,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x03c0  π
  24,21,126,25,0,255,21,85,85,85,85,84,127,255,255,255,255,254,127,255,255,255,255,254,42,191,170,170,255,169,0,127,64,0,254,0,0,127,64,0,254,0,0,127,64,0,254,0,0,127,64,0,254,0,0,127,64,0,254,0,0,127,64,0,254,0,0,127,64,0,254,0,0,127,64,0,254,0,0,127,64,0,254,0,0,127,64,0,254,0,0,127,64,0,254,0,0,127,64,0,255,0,0,127,64,0,255,0,0,127,64,0,255,236,0,127,64,0,127,252,0,127,64,0,31,252,0,0,0,0,1,64,
  // 0x03c1  ρ
  18,29,145,22,2,247,0,6,169,0,0,0,191,255,224,0,3,255,255,252,0,15,254,91,255,0,31,240,0,255,128,63,192,0,63,192,63,192,0,47,208,127,128,0,31,224,127,64,0,15,240,191,64,0,15,240,191,64,0,15,240,191,64,0,15,240,191,64,0,15,240,191,64,0,31,224,191,64,0,47,208,191,64,0,127,192,191,224,1,255,64,191,255,255,254,0,191,255,255,248,0,191,31,255,144,0,191,0,84,0,0,191,0,0,0,0,191,0,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,106,0,0,0,0,
  // 0x03c2  ς
  15,28,112,18,2,248,0,6,170,64,0,191,255,244,7,255,255,240,15,254,155,224,63,224,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,64,0,0,191,192,0,0,63,224,0,0,47,253,0,0,11,255,248,0,2,255,255,128,0,47,255,240,0,1,191,244,0,0,11,248,0,0,3,248,0,0,3,244,0,0,7,240,0,0,15,240,0,0,31,208,0,0,5,64,
  // 0x03c3  σ
  20,21,105,23,2,255,0,0,85,85,84,0,111,255,255,253,2,255,255,255,253,15,255,170,254,168,47,244,0,254,0,63,192,0,127,64,191,128,0,63,192,255,0,0,47,192,255,0,0,31,208,255,0,0,15,224,255,0,0,15,224,255,0,0,15,224,255,0,0,31,224,255,0,0,47,208,191,64,0,63,192,63,192,0,191,128,47,240,2,255,0,15,255,255,253,0,3,255,255,244,0,0,127,255,128,0,0,1,80,0,0,
  // 0x03c4  τ
  17,21,105,18,0,255,21,85,85,85,64,127,255,255,255,192,127,255,255,255,192,42,175,250,170,64,0,15,224,0,0,0,15,224,0,0,0,15,224,0,0,0,15,224,0,0,0,15,224,0,0,0,15,224,0,0,0,15,224,0,0,0,15,224,0,0,0,15,224,0,0,0,15,224,0,0,0,15,224,0,0,0,15,240,0,0,0,15,244,0,0,0,11,255,175,0,0,3,255,255,0,0,0,191,255,0,0,0,5,80,0,
  // 0x03c5  υ
  17,21,105,22,3,255,85,0,0,84,0,254,0,1,254,0,254,0,0,255,0,254,0,0,255,0,254,0,0,191,0,254,0,0,191,64,254,0,0,127,64,254,0,0,127,64,254,0,0,127,128,254,0,0,127,128,254,0,0,127,64,254,0,0,127,64,254,0,0,191,64,254,0,0,255,0,255,0,0,255,0,255,64,2,253,0,127,192,11,252,0,63,255,255,244,0,31,255,255,208,0,2,255,254,0,0,0,5,64,0,0,
  // 0x03c6  φ
  23,37,222,27,2,247,0,0,5,64,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,1,111,229,0,0,0,47,255,255,224,0,2,255,255,255,253,0,11,255,175,235,255,128,47,244,31,208,127,208,63,192,31,208,31,240,191,128,31,208,11,248,255,0,31,208,3,252,255,0,31,208,3,252,255,0,31,208,3,252,255,0,31,208,2,252,255,0,31,208,3,252,255,0,31,208,3,252,191,64,31,208,7,248,127,192,31,208,11,244,63,224,31,208,47,240,15,248,31,208,191,192,3,255,255,255,255,64,0,191,255,255,252,0,0,11,255,255,144,0,0,0,31,224,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,31,208,0,0,0,0,10,128,0,0,
  // 0x03c7  χ
  21,29,174,22,1,247,101,0,0,0,21,0,255,192,0,0,255,0,255,224,0,1,253,0,175,244,0,3,252,0,3,252,0,11,244,0,2,253,0,15,224,0,0,255,0,47,192,0,0,191,64,63,128,0,0,63,192,191,0,0,0,47,209,253,0,0,0,15,243,252,0,0,0,11,251,240,0,0,0,3,255,224,0,0,0,2,255,192,0,0,0,0,255,64,0,0,0,0,255,0,0,0,0,3,255,128,0,0,0,7,255,192,0,0,0,15,255,224,0,0,0,47,207,240,0,0,0,127,71,248,0,0,0,255,3,252,0,0,2,252,1,254,0,0,3,248,0,255,0,0,15,240,0,127,192,0,31,208,0,63,250,64,63,192,0,15,255,128,191,0,0,7,255,128,169,0,0,0,105,0,
  // 0x03c8  ψ
  23,37,222,28,3,247,0,0,21,64,0,0,0,0,63,128,0,0,0,0,63,128,0,0,0,0,63,128,0,0,0,0,63,128,0,0,0,0,63,128,0,0,0,0,63,128,0,0,0,0,63,128,0,0,84,0,63,128,5,64,253,0,63,128,31,208,253,0,63,128,15,224,253,0,63,128,15,240,253,0,63,128,11,240,253,0,63,128,11,240,253,0,63,128,7,240,253,0,63,128,7,244,253,0,63,128,7,244,253,0,63,128,3,244,253,0,63,128,7,244,254,0,63,128,7,244,254,0,63,128,7,240,255,0,63,128,15,240,191,0,63,128,15,224,127,128,63,128,63,208,63,244,63,130,255,128,15,255,255,255,255,0,3,255,255,255,248,0,0,111,255,255,128,0,0,0,127,192,0,0,0,0,63,128,0,0,0,0,63,128,0,0,0,0,63,128,0,0,0,0,63,128,0,0,0,0,63,128,0,0,0,0,63,128,0,0,0,0,63,128,0,0,0,0,42,64,0,0,
  // 0x03c9  ω
  26,21,147,29,2,255,1,84,0,0,1,80,0,3,248,0,0,3,248,0,15,240,0,0,1,253,0,31,208,0,0,0,255,0,47,192,0,0,0,127,64,63,128,0,0,0,63,128,127,64,0,0,0,63,192,191,0,3,248,0,47,192,191,0,3,248,0,47,192,191,0,3,248,0,47,192,191,0,3,248,0,31,208,191,0,3,248,0,31,192,191,0,3,248,0,47,192,191,0,3,248,0,47,192,127,64,7,252,0,63,192,63,192,11,252,0,127,64,47,224,31,190,1,255,0,15,255,255,47,255,253,0,3,255,254,15,255,248,0,0,191,248,3,255,208,0,0,5,0,0,20,0,0,
  // 0x03ca  ϊ
  255,
  // 0x03cb  ϋ
  255,
  // 0x03cc  ό
  18,29,145,22,2,255,0,0,31,240,0,0,0,47,224,0,0,0,63,192,0,0,0,127,64,0,0,0,190,0,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x03cd  ύ
  17,29,145,22,3,255,0,0,255,128,0,0,0,255,0,0,0,2,253,0,0,0,3,248,0,0,0,3,240,0,0,0,7,208,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,84,0,254,0,1,254,0,254,0,0,255,0,254,0,0,255,0,254,0,0,191,0,254,0,0,191,64,254,0,0,127,64,254,0,0,127,64,254,0,0,127,128,254,0,0,127,128,254,0,0,127,64,254,0,0,127,64,254,0,0,191,64,254,0,0,255,0,255,0,0,255,0,255,64,2,253,0,127,192,11,252,0,63,255,255,244,0,31,255,255,208,0,2,255,254,0,0,0,5,64,0,0,
  // 0x03ce  ώ
  26,29,203,29,2,255,0,0,0,47,240,0,0,0,0,0,63,208,0,0,0,0,0,63,128,0,0,0,0,0,191,0,0,0,0,0,0,253,0,0,0,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,84,0,0,1,80,0,3,248,0,0,3,248,0,15,240,0,0,1,253,0,31,208,0,0,0,255,0,47,192,0,0,0,127,64,63,128,0,0,0,63,128,127,64,0,0,0,63,192,191,0,3,248,0,47,192,191,0,3,248,0,47,192,191,0,3,248,0,47,192,191,0,3,248,0,31,208,191,0,3,248,0,31,192,191,0,3,248,0,47,192,191,0,3,248,0,47,192,127,64,7,252,0,63,192,63,192,11,252,0,127,64,47,224,31,190,1,255,0,15,255,255,47,255,253,0,3,255,254,15,255,248,0,0,191,248,3,255,208,0,0,5,0,0,20,0,0,
};

#endif // HAS_GRAPHICAL_TFT
