/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == UNIFONT

// NotoSans_Medium 36pt, capital 'A' height: 26px, width: 100%, range: 0x0020-0x00ff
extern const uint8_t NotoSans_Medium_26[24099] = {
  130,26,32,0,255,0,34,247, // unifont_t
  // 0x0020 " "
  0,0,0,9,0,0,
  // 0x0021  !
  6,27,54,10,2,255,42,128,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,192,63,128,63,128,47,128,47,128,47,128,47,64,47,64,47,64,31,64,5,0,0,0,0,0,26,0,63,192,127,208,127,208,63,192,5,0,
  // 0x0022  "
  11,10,30,15,2,16,106,2,168,191,2,252,127,2,252,127,2,252,127,1,248,127,1,248,62,1,248,62,1,244,62,0,244,41,0,160,
  // 0x0023  #
  22,26,156,23,1,0,0,0,164,1,160,0,0,1,248,3,240,0,0,2,244,3,240,0,0,3,240,3,224,0,0,3,240,7,224,0,0,3,240,11,208,0,0,7,224,11,192,0,0,11,224,15,192,0,63,255,255,255,255,208,63,255,255,255,255,208,26,175,234,191,170,128,0,31,128,63,0,0,0,47,64,63,0,0,0,47,0,63,0,0,0,63,0,126,0,0,0,127,0,190,0,0,255,255,255,255,255,0,255,255,255,255,255,0,170,254,170,254,170,0,0,252,1,248,0,0,0,252,2,244,0,0,0,248,2,240,0,0,1,244,3,240,0,0,2,244,3,240,0,0,3,240,7,224,0,0,3,240,7,208,0,0,
  // 0x0024  $
  17,31,155,21,2,253,0,1,64,0,0,0,3,208,0,0,0,3,208,0,0,0,3,228,0,0,1,255,255,228,0,15,255,255,255,0,63,255,255,254,0,191,211,208,108,0,255,3,208,0,0,255,3,208,0,0,255,3,208,0,0,191,131,208,0,0,127,251,208,0,0,47,255,224,0,0,7,255,255,64,0,0,127,255,244,0,0,3,255,253,0,0,3,235,255,0,0,3,208,191,128,0,3,208,63,128,0,3,208,63,128,64,3,208,127,128,249,3,210,255,0,255,255,255,254,0,255,255,255,244,0,47,255,255,128,0,0,23,224,0,0,0,3,208,0,0,0,3,208,0,0,0,3,208,0,0,0,0,0,0,0,
  // 0x0025  %
  28,27,189,31,1,255,1,255,64,0,0,168,0,11,255,224,0,3,244,0,31,235,244,0,7,240,0,63,129,252,0,15,208,0,63,0,253,0,31,128,0,63,0,189,0,63,0,0,127,0,190,0,190,0,0,126,0,126,0,252,0,0,126,0,126,2,244,0,0,127,0,190,7,240,0,0,63,0,189,15,208,106,64,63,0,253,31,195,255,240,47,129,252,63,79,255,248,15,235,248,126,31,209,252,11,255,240,252,47,128,190,1,255,130,248,63,64,127,0,0,3,240,63,0,63,0,0,11,224,63,0,63,0,0,15,192,63,0,63,0,0,63,64,63,0,63,0,0,127,0,63,64,63,0,0,253,0,47,64,127,0,1,248,0,31,192,253,0,3,240,0,15,230,252,0,11,224,0,7,255,244,0,15,192,0,1,255,208,0,0,0,0,0,21,0,
  // 0x0026  &
  24,27,162,27,2,255,0,31,255,64,0,0,0,255,255,240,0,0,3,255,255,248,0,0,7,252,7,252,0,0,15,240,1,253,0,0,15,240,0,254,0,0,15,240,1,253,0,0,11,240,2,252,0,0,3,252,11,248,0,0,2,254,47,240,0,0,0,255,255,192,0,0,0,63,254,0,0,0,1,255,248,0,0,0,7,255,254,0,3,252,47,249,255,128,7,248,127,208,127,224,11,240,255,128,15,248,15,240,255,0,3,254,47,208,255,0,0,255,255,192,255,0,0,63,255,64,255,0,0,15,254,0,255,128,0,31,255,0,127,228,1,255,255,192,63,255,255,255,191,240,15,255,255,252,15,252,1,255,255,144,3,255,0,1,80,0,0,0,
  // 0x0027  '
  4,10,10,9,2,16,106,191,127,127,127,127,62,62,62,41,
  // 0x0028  (
  9,32,96,11,1,250,0,26,128,0,63,64,0,254,0,1,252,0,3,248,0,7,240,0,15,240,0,15,208,0,47,192,0,63,192,0,63,128,0,63,64,0,127,64,0,127,0,0,191,0,0,191,0,0,191,0,0,191,0,0,127,0,0,127,64,0,63,64,0,63,128,0,63,192,0,47,192,0,31,208,0,15,240,0,11,240,0,3,248,0,2,252,0,0,254,0,0,63,64,0,26,128,
  // 0x0029  )
  9,32,96,11,1,250,106,0,0,63,64,0,31,192,0,15,224,0,7,240,0,3,248,0,2,252,0,1,253,0,0,254,0,0,191,0,0,127,0,0,127,64,0,63,128,0,63,128,0,63,128,0,63,192,0,63,192,0,63,128,0,63,128,0,63,128,0,63,64,0,127,64,0,191,0,0,255,0,0,253,0,2,252,0,3,248,0,7,240,0,15,224,0,31,192,0,63,64,0,106,0,0,
  // 0x002a  *
  18,18,90,20,1,10,0,1,84,0,0,0,3,248,0,0,0,3,248,0,0,0,3,244,0,0,0,2,244,0,0,16,2,240,0,64,63,65,240,111,192,127,255,251,255,192,191,255,255,255,208,5,111,254,149,0,0,15,254,0,0,0,47,191,64,0,0,127,31,192,0,0,254,15,240,0,3,252,11,248,0,2,252,3,248,0,0,36,1,128,0,0,0,0,0,0,
  // 0x002b  +
  18,18,90,21,1,4,0,0,84,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,1,252,0,0,127,255,255,255,240,127,255,255,255,240,63,255,255,255,224,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,
  // 0x002c  ,
  6,9,18,10,1,251,15,240,15,240,31,224,47,192,47,192,63,64,63,0,126,0,104,0,
  // 0x002d  -
  10,4,12,12,1,8,21,85,64,191,255,208,191,255,208,191,255,208,
  // 0x002e  .
  6,6,12,10,2,255,26,0,63,192,127,208,127,208,63,192,5,0,
  // 0x002f  /
  14,26,104,14,0,0,0,0,10,144,0,0,47,192,0,0,63,128,0,0,127,64,0,0,191,0,0,0,254,0,0,1,252,0,0,3,252,0,0,3,244,0,0,11,240,0,0,15,224,0,0,31,208,0,0,47,192,0,0,63,128,0,0,127,0,0,0,255,0,0,0,253,0,0,2,252,0,0,3,248,0,0,7,244,0,0,11,240,0,0,15,224,0,0,31,208,0,0,47,192,0,0,63,128,0,0,127,0,0,0,
  // 0x0030  0
  18,27,135,21,1,255,0,27,255,64,0,0,191,255,240,0,3,255,255,252,0,7,254,7,255,0,15,240,0,191,64,31,224,0,63,192,47,192,0,47,192,63,192,0,31,208,63,192,0,15,224,63,128,0,15,224,127,128,0,15,240,127,64,0,15,240,127,64,0,15,240,127,64,0,15,240,127,64,0,15,240,127,128,0,15,240,63,128,0,15,240,63,128,0,15,224,63,192,0,31,208,47,192,0,47,208,31,208,0,63,192,15,240,0,191,128,7,252,2,255,0,3,255,255,253,0,0,255,255,248,0,0,31,255,208,0,0,0,84,0,0,
  // 0x0031  1
  11,26,78,21,3,0,0,2,164,0,31,244,0,191,244,3,255,244,15,255,244,127,215,244,255,71,244,60,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,0,7,244,
  // 0x0032  2
  18,26,130,21,1,0,0,31,255,128,0,2,255,255,244,0,31,255,255,253,0,63,249,7,255,0,15,128,0,255,128,5,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,127,128,0,0,0,255,0,0,0,1,254,0,0,0,3,252,0,0,0,15,244,0,0,0,63,208,0,0,0,255,64,0,0,3,254,0,0,0,15,248,0,0,0,63,224,0,0,0,255,64,0,0,3,253,0,0,0,15,244,0,0,0,63,245,85,85,80,127,255,255,255,240,127,255,255,255,240,127,255,255,255,240,
  // 0x0033  3
  18,27,135,21,1,255,0,111,255,128,0,11,255,255,248,0,63,255,255,254,0,47,228,7,255,64,14,0,0,191,128,0,0,0,63,192,0,0,0,63,192,0,0,0,63,192,0,0,0,127,128,0,0,0,255,0,0,0,7,253,0,0,127,255,240,0,0,191,255,64,0,0,191,255,248,0,0,21,107,255,0,0,0,0,191,192,0,0,0,63,208,0,0,0,31,224,0,0,0,31,224,0,0,0,31,224,0,0,0,47,224,0,0,0,127,192,121,0,2,255,128,127,255,255,255,0,127,255,255,248,0,27,255,255,144,0,0,21,80,0,0,
  // 0x0034  4
  20,26,130,21,0,0,0,0,0,191,64,0,0,1,255,64,0,0,3,255,64,0,0,11,255,64,0,0,31,255,64,0,0,63,127,64,0,0,254,127,64,0,2,252,127,64,0,3,240,127,64,0,15,224,127,64,0,47,192,127,64,0,127,0,127,64,0,253,0,127,64,2,252,0,127,64,7,240,0,127,64,15,208,0,127,64,47,128,0,127,64,127,255,255,255,255,127,255,255,255,255,127,255,255,255,255,21,85,85,191,149,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,0,0,0,127,64,
  // 0x0035  5
  17,27,135,21,2,255,26,170,170,168,0,31,255,255,252,0,47,255,255,252,0,47,234,170,168,0,47,192,0,0,0,47,192,0,0,0,63,128,0,0,0,63,128,0,0,0,63,128,0,0,0,63,64,0,0,0,63,255,249,0,0,63,255,255,224,0,63,255,255,248,0,10,81,111,254,0,0,0,2,255,0,0,0,0,255,64,0,0,0,127,128,0,0,0,127,128,0,0,0,127,128,0,0,0,127,64,0,0,0,255,0,64,0,1,255,0,249,0,27,253,0,255,255,255,248,0,255,255,255,208,0,47,255,254,0,0,0,21,64,0,0,
  // 0x0036  6
  17,27,135,21,2,255,0,1,191,252,0,0,47,255,252,0,0,255,255,252,0,3,255,144,4,0,11,248,0,0,0,31,224,0,0,0,63,192,0,0,0,63,128,0,0,0,127,0,0,0,0,191,0,0,0,0,254,11,255,208,0,254,127,255,248,0,254,255,255,254,0,255,240,2,255,0,255,128,0,191,128,255,0,0,63,192,254,0,0,63,192,254,0,0,47,192,255,0,0,63,192,191,0,0,63,192,127,64,0,63,128,63,192,0,191,64,31,244,2,255,0,11,255,255,252,0,2,255,255,244,0,0,127,255,128,0,0,1,80,0,0,
  // 0x0037  7
  18,26,130,21,1,0,106,170,170,170,160,191,255,255,255,240,191,255,255,255,240,106,170,170,175,240,0,0,0,31,208,0,0,0,63,192,0,0,0,127,64,0,0,0,255,0,0,0,1,254,0,0,0,3,252,0,0,0,3,248,0,0,0,11,240,0,0,0,15,240,0,0,0,47,208,0,0,0,63,192,0,0,0,191,64,0,0,0,255,0,0,0,1,254,0,0,0,3,252,0,0,0,7,248,0,0,0,15,240,0,0,0,31,240,0,0,0,63,208,0,0,0,63,192,0,0,0,191,64,0,0,0,255,0,0,0,
  // 0x0038  8
  18,27,135,21,1,255,0,27,255,128,0,1,255,255,248,0,7,255,255,255,0,15,248,1,255,128,31,224,0,63,192,47,192,0,47,192,47,192,0,47,192,31,208,0,63,192,15,240,0,63,128,11,252,1,255,0,2,255,155,252,0,0,191,255,224,0,0,47,255,128,0,0,191,255,244,0,3,255,95,254,0,15,244,1,255,128,47,208,0,63,192,63,128,0,15,224,127,64,0,15,240,127,64,0,15,240,127,64,0,15,240,63,192,0,31,224,47,240,0,127,192,15,255,171,255,64,3,255,255,253,0,0,127,255,224,0,0,0,84,0,0,
  // 0x0039  9
  18,27,135,21,1,255,0,27,254,64,0,0,255,255,240,0,7,255,255,252,0,15,253,7,255,0,47,224,0,191,64,63,192,0,63,192,63,128,0,31,208,127,64,0,15,224,127,64,0,15,224,127,64,0,15,240,63,128,0,15,240,63,192,0,63,240,47,224,0,191,240,15,254,91,255,240,7,255,255,207,224,1,255,255,15,224,0,6,144,15,208,0,0,0,31,192,0,0,0,47,192,0,0,0,63,128,0,0,0,255,0,0,0,2,254,0,0,0,31,252,0,11,255,255,240,0,11,255,255,128,0,11,255,248,0,0,0,84,0,0,0,
  // 0x003a  :
  6,21,42,10,2,255,31,64,127,192,191,208,127,208,63,128,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,0,63,192,127,208,127,208,63,192,5,0,
  // 0x003b  ;
  7,25,50,10,1,251,11,208,31,240,47,244,47,240,15,224,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,15,240,31,224,47,208,47,192,63,128,63,0,127,0,189,0,168,0,
  // 0x003c  <
  18,18,90,21,1,4,0,0,0,0,96,0,0,0,7,240,0,0,0,127,240,0,0,7,255,208,0,0,127,248,0,0,7,255,128,0,0,127,248,0,0,7,255,128,0,0,63,244,0,0,0,127,208,0,0,0,63,254,0,0,0,6,255,228,0,0,0,47,255,64,0,0,1,255,248,0,0,0,31,255,208,0,0,0,191,240,0,0,0,11,240,0,0,0,0,96,
  // 0x003d  =
  17,11,55,21,2,7,170,170,170,170,64,255,255,255,255,128,255,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,170,64,255,255,255,255,128,255,255,255,255,128,85,85,85,85,0,
  // 0x003e  >
  18,18,90,21,1,4,96,0,0,0,0,126,0,0,0,0,127,224,0,0,0,47,254,0,0,0,1,255,224,0,0,0,31,254,0,0,0,1,255,224,0,0,0,31,254,0,0,0,0,191,224,0,0,0,47,240,0,0,6,255,224,0,0,127,254,0,0,11,255,208,0,1,255,249,0,0,47,255,128,0,0,127,244,0,0,0,127,64,0,0,0,96,0,0,0,0,
  // 0x003f  ?
  15,27,108,16,0,255,1,191,249,0,47,255,255,192,127,255,255,240,63,144,111,248,20,0,3,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,3,252,0,0,15,244,0,0,63,224,0,0,255,128,0,3,254,0,0,15,244,0,0,31,208,0,0,63,128,0,0,63,64,0,0,63,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,26,0,0,0,127,192,0,0,191,192,0,0,191,192,0,0,127,128,0,0,5,0,0,
  // 0x0040  @
  29,30,240,32,2,252,0,0,1,106,164,0,0,0,0,0,111,255,255,208,0,0,0,3,255,255,255,252,0,0,0,31,249,0,6,255,64,0,0,191,128,0,0,63,208,0,1,253,0,0,0,11,240,0,7,244,0,0,0,2,252,0,15,208,0,111,164,0,252,0,31,192,11,255,255,128,126,0,63,0,63,255,255,128,63,0,63,0,191,64,47,128,63,0,126,0,253,0,47,128,47,0,189,2,252,0,47,64,47,64,252,3,244,0,47,64,47,64,252,3,244,0,63,64,47,64,252,3,240,0,63,64,63,0,252,3,244,0,63,64,63,0,252,2,248,0,127,64,126,0,252,1,252,0,255,128,252,0,189,0,255,155,251,231,248,0,126,0,63,255,195,255,224,0,63,0,11,254,0,255,64,0,47,128,0,0,0,0,0,0,15,224,0,0,0,0,0,0,7,248,0,0,0,0,0,0,2,255,64,0,1,160,0,0,0,127,254,170,191,224,0,0,0,11,255,255,255,208,0,0,0,0,111,255,249,0,0,0,0,0,0,0,0,0,0,0,
  // 0x0041  A
  24,26,156,24,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x0042  B
  19,26,130,24,3,0,106,170,169,64,0,191,255,255,248,0,191,255,255,255,64,191,170,175,255,192,191,64,0,127,224,191,64,0,47,240,191,64,0,15,240,191,64,0,15,240,191,64,0,31,224,191,64,0,63,208,191,64,1,255,128,191,255,255,254,0,191,255,255,224,0,191,255,255,255,0,191,64,5,255,208,191,64,0,47,240,191,64,0,15,244,191,64,0,7,248,191,64,0,7,248,191,64,0,11,248,191,64,0,15,244,191,64,0,47,240,191,64,22,255,224,191,255,255,255,192,191,255,255,254,0,191,255,255,144,0,
  // 0x0043  C
  20,27,135,23,2,255,0,0,191,255,144,0,15,255,255,253,0,127,255,255,252,2,255,245,91,252,7,255,0,0,36,15,252,0,0,0,47,240,0,0,0,63,208,0,0,0,63,192,0,0,0,127,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,224,0,0,0,31,244,0,0,0,15,253,0,0,0,3,255,208,1,184,0,255,255,255,248,0,63,255,255,248,0,6,255,255,224,0,0,5,80,0,
  // 0x0044  D
  21,26,156,26,3,0,106,170,169,0,0,0,191,255,255,248,0,0,191,255,255,255,64,0,191,170,175,255,224,0,191,64,0,127,248,0,191,64,0,11,253,0,191,64,0,2,255,0,191,64,0,0,255,64,191,64,0,0,191,128,191,64,0,0,127,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,63,192,191,64,0,0,127,192,191,64,0,0,191,128,191,64,0,0,255,64,191,64,0,2,255,0,191,64,0,11,253,0,191,64,0,127,248,0,191,149,91,255,240,0,191,255,255,255,128,0,191,255,255,248,0,0,191,255,254,64,0,0,
  // 0x0045  E
  15,26,104,20,3,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x0046  F
  15,26,104,19,3,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,240,191,255,255,240,191,255,255,240,191,85,85,80,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,
  // 0x0047  G
  22,27,162,26,2,255,0,0,111,255,228,0,0,11,255,255,255,192,0,63,255,255,255,128,1,255,249,85,191,64,3,255,128,0,2,0,15,252,0,0,0,0,31,240,0,0,0,0,63,224,0,0,0,0,63,192,0,0,0,0,127,128,0,0,0,0,191,64,0,0,0,0,255,64,0,0,0,0,255,0,0,191,255,208,255,0,0,255,255,208,255,64,0,255,255,208,191,64,0,106,175,208,191,128,0,0,31,208,127,192,0,0,31,208,63,192,0,0,31,208,47,224,0,0,31,208,31,244,0,0,31,208,11,254,0,0,31,208,3,255,208,0,111,208,0,255,255,255,255,208,0,47,255,255,255,208,0,2,255,255,254,64,0,0,1,84,0,0,
  // 0x0048  H
  21,26,156,27,3,0,106,0,0,0,106,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,255,255,255,255,64,191,255,255,255,255,64,191,255,255,255,255,64,191,85,85,85,191,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,191,64,0,0,127,64,
  // 0x0049  I
  11,26,78,13,1,0,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,
  // 0x004a  J
  10,34,102,10,253,248,0,10,160,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,11,240,0,15,240,0,15,240,0,47,224,85,191,208,255,255,128,255,254,0,191,228,0,0,0,0,
  // 0x004b  K
  20,26,130,23,3,0,106,0,0,2,168,191,64,0,15,244,191,64,0,63,224,191,64,0,191,128,191,64,2,255,0,191,64,7,252,0,191,64,31,240,0,191,64,63,192,0,191,64,255,64,0,191,67,253,0,0,191,79,248,0,0,191,111,240,0,0,191,255,244,0,0,191,255,252,0,0,191,247,254,0,0,191,208,255,64,0,191,64,191,192,0,191,64,63,240,0,191,64,15,248,0,191,64,7,252,0,191,64,2,255,0,191,64,0,255,128,191,64,0,63,208,191,64,0,47,240,191,64,0,15,248,191,64,0,3,253,
  // 0x004c  L
  16,26,104,19,3,0,106,0,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,253,191,255,255,253,191,255,255,253,
  // 0x004d  M
  27,26,182,33,3,0,106,160,0,0,0,42,164,191,244,0,0,0,127,248,191,252,0,0,0,191,248,191,252,0,0,0,255,248,191,253,0,0,1,255,248,191,191,0,0,3,247,248,191,127,0,0,3,243,248,191,63,128,0,11,227,248,191,47,192,0,15,211,248,191,31,208,0,31,195,248,191,15,224,0,47,131,248,191,11,240,0,63,67,248,191,3,244,0,127,3,248,191,3,248,0,254,3,248,191,1,252,0,252,3,248,191,0,253,2,252,3,248,191,0,255,3,244,3,248,191,0,127,7,240,3,248,191,0,63,75,224,3,248,191,0,47,207,208,3,248,191,0,31,239,192,3,248,191,0,15,255,128,3,248,191,0,11,255,0,3,248,191,0,7,255,0,3,248,191,0,3,254,0,3,248,191,0,2,252,0,3,248,
  // 0x004e  N
  22,26,156,28,3,0,106,128,0,0,10,144,191,240,0,0,15,224,191,244,0,0,15,224,191,252,0,0,15,224,191,254,0,0,15,224,191,255,64,0,15,224,190,127,192,0,15,224,191,63,224,0,15,224,191,15,240,0,15,224,191,11,252,0,15,224,191,3,253,0,15,224,191,1,255,0,15,224,191,0,191,128,15,224,191,0,63,208,15,224,191,0,31,240,15,224,191,0,15,248,15,224,191,0,3,253,15,224,191,0,2,255,15,224,191,0,0,255,143,224,191,0,0,127,207,224,191,0,0,47,255,224,191,0,0,15,255,224,191,0,0,7,255,224,191,0,0,3,255,224,191,0,0,0,255,224,191,0,0,0,191,224,
  // 0x004f  O
  24,27,162,28,2,255,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x0050  P
  17,26,130,22,3,0,106,170,165,0,0,191,255,255,224,0,191,255,255,252,0,191,170,191,255,0,191,64,2,255,128,191,64,0,127,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,127,192,191,64,0,255,128,191,64,27,255,0,191,255,255,253,0,191,255,255,240,0,191,255,254,64,0,191,84,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,
  // 0x0051  Q
  24,33,198,28,2,249,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,208,0,0,0,5,127,240,0,0,0,0,15,252,0,0,0,0,7,254,0,0,0,0,1,255,128,0,0,0,0,191,224,0,0,0,0,47,248,0,0,0,0,0,0,
  // 0x0052  R
  19,26,130,23,3,0,106,170,165,0,0,191,255,255,224,0,191,255,255,253,0,191,170,191,255,0,191,64,1,255,128,191,64,0,127,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,127,128,191,64,2,255,0,191,234,191,253,0,191,255,255,244,0,191,255,255,128,0,191,170,191,192,0,191,64,47,208,0,191,64,15,240,0,191,64,11,248,0,191,64,3,253,0,191,64,1,255,0,191,64,0,191,128,191,64,0,63,192,191,64,0,47,240,191,64,0,15,244,191,64,0,7,252,
  // 0x0053  S
  16,27,108,20,2,255,0,111,255,144,7,255,255,253,31,255,255,253,63,249,86,252,191,192,0,20,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,208,0,0,63,253,0,0,15,255,208,0,3,255,253,0,0,127,255,208,0,6,255,244,0,0,47,252,0,0,7,254,0,0,0,255,0,0,0,255,0,0,0,191,0,0,0,255,64,0,1,255,249,0,11,253,255,255,255,248,255,255,255,224,111,255,254,0,0,21,64,0,
  // 0x0054  T
  20,26,130,20,0,0,106,170,170,170,170,191,255,255,255,255,191,255,255,255,255,106,170,255,170,169,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,
  // 0x0055  U
  21,27,162,27,3,255,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x0056  V
  22,26,156,22,0,0,170,0,0,0,10,160,191,64,0,0,31,224,63,192,0,0,47,208,63,192,0,0,63,192,47,208,0,0,127,128,15,240,0,0,191,64,15,240,0,0,255,0,7,244,0,1,254,0,3,252,0,2,252,0,3,252,0,3,252,0,1,253,0,7,248,0,0,255,0,11,240,0,0,191,0,15,240,0,0,127,128,31,208,0,0,63,192,63,192,0,0,47,192,63,192,0,0,31,224,127,64,0,0,15,240,255,0,0,0,11,240,254,0,0,0,7,245,253,0,0,0,3,250,252,0,0,0,2,255,248,0,0,0,0,255,244,0,0,0,0,255,240,0,0,0,0,127,224,0,0,0,0,63,192,0,0,
  // 0x0057  W
  34,26,234,34,0,0,106,64,0,2,168,0,0,26,144,127,128,0,7,252,0,0,47,192,63,192,0,11,253,0,0,63,192,63,192,0,15,254,0,0,63,128,47,208,0,31,255,0,0,127,64,31,224,0,47,255,64,0,191,0,15,240,0,63,191,128,0,255,0,15,240,0,63,111,192,0,254,0,11,244,0,127,31,192,1,253,0,7,248,0,191,15,208,2,252,0,3,252,0,254,15,240,3,252,0,3,252,1,253,11,240,3,248,0,2,253,2,252,3,244,7,244,0,1,254,3,248,3,248,11,240,0,0,255,3,244,2,252,15,240,0,0,191,7,240,1,252,15,224,0,0,127,75,240,0,253,31,208,0,0,63,143,224,0,254,47,192,0,0,63,143,208,0,191,63,192,0,0,47,223,192,0,63,63,64,0,0,31,239,128,0,63,191,0,0,0,15,255,64,0,47,255,0,0,0,15,255,0,0,31,254,0,0,0,11,255,0,0,15,253,0,0,0,7,254,0,0,15,252,0,0,0,3,253,0,0,11,252,0,0,
  // 0x0058  X
  22,26,156,22,0,0,42,128,0,0,42,128,47,224,0,0,191,64,15,244,0,1,255,0,7,252,0,3,252,0,2,254,0,11,248,0,0,255,0,15,240,0,0,127,192,47,192,0,0,47,208,127,128,0,0,15,240,255,0,0,0,7,250,253,0,0,0,2,255,248,0,0,0,0,255,240,0,0,0,0,191,208,0,0,0,0,255,240,0,0,0,2,255,244,0,0,0,3,255,252,0,0,0,15,241,254,0,0,0,31,208,255,64,0,0,63,192,63,192,0,0,191,64,47,224,0,1,254,0,15,244,0,3,252,0,7,252,0,11,244,0,2,254,0,31,240,0,0,255,0,63,192,0,0,127,192,191,128,0,0,63,224,
  // 0x0059  Y
  21,26,156,21,0,0,170,64,0,0,106,128,127,192,0,0,255,64,63,208,0,1,255,0,31,240,0,3,252,0,11,244,0,7,248,0,3,252,0,15,240,0,2,253,0,31,224,0,0,255,0,63,192,0,0,191,128,127,128,0,0,63,192,255,0,0,0,47,226,253,0,0,0,15,243,252,0,0,0,7,255,244,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,255,128,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,
  // 0x005a  Z
  19,26,130,21,1,0,106,170,170,170,160,127,255,255,255,240,127,255,255,255,240,42,170,170,191,240,0,0,0,63,192,0,0,0,255,64,0,0,2,255,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,63,192,0,0,0,255,64,0,0,2,254,0,0,0,3,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,192,0,0,0,255,64,0,0,2,254,0,0,0,7,252,0,0,0,15,244,0,0,0,47,224,0,0,0,127,213,85,85,80,255,255,255,255,244,255,255,255,255,244,255,255,255,255,244,
  // 0x005b  [
  8,32,64,12,3,250,170,170,255,255,255,255,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,253,0,255,255,255,255,170,170,
  // 0x005c "\"
  14,26,104,14,0,0,106,0,0,0,63,64,0,0,63,128,0,0,31,192,0,0,15,208,0,0,11,240,0,0,7,240,0,0,3,248,0,0,2,252,0,0,0,253,0,0,0,254,0,0,0,127,0,0,0,63,64,0,0,63,192,0,0,31,192,0,0,15,224,0,0,11,240,0,0,7,244,0,0,3,248,0,0,2,252,0,0,0,253,0,0,0,255,0,0,0,127,0,0,0,63,128,0,0,47,192,0,0,31,208,
  // 0x005d  ]
  8,32,64,12,1,250,170,170,255,255,255,255,0,191,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,127,0,191,255,255,255,255,170,170,
  // 0x005e  ^
  18,17,85,21,1,9,0,1,240,0,0,0,3,248,0,0,0,7,252,0,0,0,11,254,0,0,0,15,255,0,0,0,47,95,128,0,0,63,15,192,0,0,189,7,224,0,0,252,3,240,0,2,248,1,248,0,3,240,0,253,0,7,224,0,127,0,15,192,0,63,64,31,128,0,31,192,63,64,0,15,208,127,0,0,7,240,105,0,0,2,160,
  // 0x005f  _
  16,3,12,16,0,250,255,255,255,254,255,255,255,254,170,170,170,169,
  // 0x0060  `
  9,7,21,11,1,21,106,128,0,63,224,0,15,240,0,3,252,0,0,254,0,0,63,64,0,0,0,
  // 0x0061  a
  17,21,105,21,1,255,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x0062  b
  18,29,145,22,3,255,85,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,1,170,0,0,254,47,255,224,0,254,191,255,252,0,255,254,91,255,0,255,208,1,255,64,255,128,0,127,128,255,0,0,63,192,255,0,0,47,192,255,0,0,47,208,255,0,0,47,208,255,0,0,31,208,255,0,0,47,208,255,0,0,47,208,255,0,0,63,192,255,64,0,63,192,255,192,0,191,128,255,240,2,255,0,255,255,255,253,0,252,127,255,248,0,252,11,255,208,0,0,0,20,0,0,
  // 0x0063  c
  15,21,84,18,2,255,0,6,170,64,0,255,255,244,7,255,255,240,15,254,171,224,63,240,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,128,0,0,63,192,0,0,63,244,0,176,15,255,255,240,3,255,255,240,0,127,255,208,0,1,84,0,
  // 0x0064  d
  18,29,145,22,2,255,0,0,0,5,64,0,0,0,31,208,0,0,0,31,208,0,0,0,31,208,0,0,0,31,208,0,0,0,31,208,0,0,0,31,208,0,0,0,31,208,0,26,164,31,208,1,255,255,31,208,11,255,255,223,208,31,254,91,255,208,63,224,0,255,208,127,192,0,127,208,191,64,0,63,208,255,0,0,47,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,47,208,191,64,0,63,208,127,192,0,127,208,63,240,1,255,208,15,255,255,239,208,7,255,255,143,208,0,191,253,15,208,0,5,64,0,0,
  // 0x0065  e
  17,21,105,21,2,255,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x0066  f
  14,28,112,13,0,0,0,0,89,64,0,11,255,240,0,63,255,240,0,127,250,224,0,255,64,0,0,255,0,0,0,255,0,0,0,254,0,0,1,255,85,0,47,255,255,64,127,255,255,64,42,255,170,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,254,0,0,
  // 0x0067  g
  18,29,145,22,2,247,0,26,160,5,64,2,255,255,15,208,11,255,255,207,208,31,254,91,255,208,63,224,0,255,208,127,192,0,127,208,191,64,0,63,208,255,0,0,47,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,47,208,191,64,0,63,208,127,192,0,127,208,63,240,1,255,208,15,255,191,255,208,7,255,255,159,208,0,191,253,31,208,0,5,64,31,208,0,0,0,47,192,0,0,0,63,192,0,0,0,63,192,36,0,0,255,64,47,233,91,255,0,47,255,255,252,0,31,255,255,224,0,0,90,165,0,0,
  // 0x0068  h
  17,28,140,23,3,0,85,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,1,170,64,0,254,31,255,244,0,254,191,255,253,0,255,254,91,255,0,255,224,0,255,64,255,128,0,127,128,255,64,0,63,128,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,
  // 0x0069  i
  4,27,27,10,3,0,104,255,255,255,40,0,0,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x006a  j
  9,36,108,10,254,247,0,26,0,0,63,192,0,63,192,0,63,192,0,10,0,0,0,0,0,0,0,0,21,64,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,192,0,63,128,0,191,128,170,255,64,255,254,0,255,248,0,106,64,0,
  // 0x006b  k
  17,28,140,20,3,0,85,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,85,0,255,0,3,254,0,255,0,15,248,0,255,0,47,224,0,255,0,191,128,0,255,2,255,0,0,255,11,252,0,0,254,31,240,0,0,254,127,192,0,0,254,255,192,0,0,255,255,240,0,0,255,239,248,0,0,255,131,253,0,0,255,1,255,0,0,255,0,191,192,0,255,0,63,224,0,255,0,15,244,0,255,0,7,252,0,255,0,2,255,0,255,0,0,255,128,
  // 0x006c  l
  4,28,28,10,3,0,85,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x006d  m
  29,20,160,34,3,0,84,1,170,0,1,170,64,0,252,47,255,224,47,255,240,0,253,191,255,252,191,255,252,0,255,253,95,255,254,91,254,0,255,208,2,255,224,1,255,0,255,128,0,255,192,0,255,0,255,64,0,255,64,0,191,64,255,0,0,255,0,0,191,64,255,0,0,191,0,0,191,64,255,0,0,191,0,0,191,64,255,0,0,191,0,0,191,64,255,0,0,191,0,0,191,64,255,0,0,191,0,0,191,64,255,0,0,191,0,0,191,64,255,0,0,191,0,0,191,64,255,0,0,191,0,0,191,64,255,0,0,191,0,0,191,64,255,0,0,191,0,0,191,64,255,0,0,191,0,0,191,64,255,0,0,191,0,0,191,64,
  // 0x006e  n
  17,20,100,23,3,0,84,1,170,64,0,252,47,255,244,0,253,191,255,253,0,255,254,91,255,0,255,224,0,255,64,255,128,0,127,128,255,64,0,63,128,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,
  // 0x006f  o
  18,21,105,22,2,255,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x0070  p
  18,29,145,22,3,247,84,1,170,0,0,253,31,255,224,0,253,191,255,252,0,255,254,91,255,0,255,208,1,255,64,255,128,0,127,192,255,0,0,63,192,255,0,0,63,192,255,0,0,47,208,255,0,0,47,208,255,0,0,31,208,255,0,0,47,208,255,0,0,47,208,255,0,0,63,192,255,64,0,63,192,255,192,0,255,128,255,240,2,255,0,255,255,255,253,0,254,127,255,248,0,254,11,255,208,0,255,0,20,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,170,0,0,0,0,
  // 0x0071  q
  18,29,145,22,2,247,0,26,160,5,64,1,255,255,15,208,11,255,255,207,208,31,254,91,255,208,63,224,0,255,208,127,192,0,127,208,191,64,0,63,208,255,0,0,47,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,31,208,255,0,0,47,208,191,64,0,63,208,127,192,0,127,208,63,240,1,255,208,15,255,255,239,208,7,255,255,159,208,0,191,253,31,208,0,5,64,31,208,0,0,0,31,208,0,0,0,31,208,0,0,0,31,208,0,0,0,31,208,0,0,0,31,208,0,0,0,31,208,0,0,0,31,208,0,0,0,26,128,
  // 0x0072  r
  12,20,60,15,3,0,84,1,169,252,15,254,253,63,253,254,255,253,255,248,0,255,208,0,255,128,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,
  // 0x0073  s
  14,21,84,17,2,255,0,106,164,0,15,255,255,192,63,255,255,192,255,149,111,128,254,0,0,0,254,0,0,0,255,0,0,0,255,208,0,0,63,254,0,0,15,255,244,0,1,255,254,0,0,27,255,192,0,0,191,208,0,0,31,240,0,0,15,240,0,0,15,240,208,0,47,224,255,170,255,192,255,255,255,64,127,255,248,0,0,85,0,0,
  // 0x0074  t
  13,25,100,14,0,255,0,60,0,0,0,188,0,0,0,252,0,0,0,252,0,0,3,253,85,64,47,255,255,128,127,255,255,128,43,254,170,64,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,252,0,0,2,253,0,0,1,255,0,0,0,255,255,192,0,127,255,192,0,31,255,128,0,0,80,0,
  // 0x0075  u
  17,21,105,23,3,255,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x0076  v
  19,20,100,19,0,0,85,0,0,1,84,191,64,0,7,248,127,128,0,15,240,63,192,0,15,240,47,208,0,31,208,15,240,0,63,192,15,240,0,63,128,7,244,0,191,64,3,252,0,255,0,2,252,1,254,0,1,254,2,252,0,0,255,3,252,0,0,127,7,244,0,0,63,139,240,0,0,47,207,224,0,0,31,223,208,0,0,15,255,192,0,0,11,255,128,0,0,3,255,0,0,0,3,255,0,0,
  // 0x0077  w
  29,20,160,29,0,0,21,0,0,85,64,0,21,64,127,128,0,255,192,0,127,64,63,192,0,255,192,0,191,0,63,192,1,255,208,0,255,0,47,208,2,251,240,0,254,0,15,224,3,243,240,2,253,0,15,240,7,243,244,3,252,0,11,240,11,226,248,3,248,0,7,244,15,209,252,7,244,0,3,248,15,192,252,11,240,0,3,252,31,192,254,15,240,0,2,252,63,128,191,15,224,0,1,253,63,0,127,31,208,0,0,254,127,0,63,111,192,0,0,254,126,0,47,175,192,0,0,127,189,0,31,191,64,0,0,63,252,0,15,255,0,0,0,63,252,0,15,255,0,0,0,47,244,0,11,254,0,0,0,31,240,0,7,253,0,0,
  // 0x0078  x
  18,20,100,20,1,0,85,0,0,21,64,191,192,0,63,192,63,208,0,255,64,15,240,2,254,0,7,252,3,252,0,3,253,15,244,0,0,255,31,224,0,0,127,255,192,0,0,47,255,0,0,0,15,254,0,0,0,15,253,0,0,0,47,255,0,0,0,127,255,192,0,0,255,47,224,0,2,254,15,240,0,7,252,7,252,0,15,240,2,254,0,47,224,0,255,64,127,192,0,127,192,255,0,0,47,224,
  // 0x0079  y
  19,29,145,19,0,247,85,0,0,1,84,191,64,0,7,248,63,192,0,15,240,63,192,0,15,240,31,224,0,31,208,15,240,0,63,192,11,244,0,63,128,3,248,0,191,64,3,252,0,255,0,1,253,0,254,0,0,255,2,252,0,0,191,3,252,0,0,63,71,244,0,0,63,203,240,0,0,31,207,224,0,0,15,223,208,0,0,11,255,192,0,0,3,255,128,0,0,3,255,0,0,0,1,255,0,0,0,1,253,0,0,0,3,252,0,0,0,3,248,0,0,0,11,244,0,0,0,47,240,0,0,38,255,192,0,0,127,255,64,0,0,127,253,0,0,0,42,144,0,0,0,
  // 0x007a  z
  15,20,80,17,1,0,21,85,85,80,63,255,255,248,63,255,255,248,42,170,175,244,0,0,31,224,0,0,63,192,0,0,255,0,0,2,254,0,0,7,252,0,0,15,240,0,0,47,208,0,0,127,128,0,0,255,0,0,3,253,0,0,11,248,0,0,31,240,0,0,63,192,0,0,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x007b  {
  12,32,96,14,1,250,0,0,105,0,11,254,0,47,254,0,127,228,0,191,64,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,254,0,2,253,0,175,248,0,255,144,0,255,208,0,175,252,0,2,253,0,0,254,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,0,0,191,64,0,127,228,0,47,254,0,11,254,0,0,105,
  // 0x007c  |
  4,37,37,20,8,247,20,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,189,104,
  // 0x007d  }
  12,32,96,14,1,250,169,0,0,255,208,0,255,248,0,95,252,0,2,253,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,255,0,0,191,64,0,63,250,0,7,255,0,7,255,0,63,250,0,191,64,0,255,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,0,254,0,2,253,0,95,252,0,255,248,0,255,208,0,169,0,0,
  // 0x007e  ~
  18,5,25,21,1,10,11,255,128,0,32,63,255,253,66,240,127,255,255,255,240,120,1,191,255,192,16,0,6,249,0,
  // 0x007f - 0x009a  Control Characters
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00a0 "�"
  0,0,0,9,0,0,
  // 0x00a1  ¡
  6,27,54,10,2,249,10,0,63,192,127,208,127,208,63,192,5,0,0,0,0,0,10,0,47,64,47,64,47,64,47,64,47,128,63,128,63,128,63,128,63,128,63,192,63,192,63,192,63,192,63,192,63,192,127,192,127,192,42,128,
  // 0x00a2  ¢
  15,27,108,21,3,255,0,3,240,0,0,3,240,0,0,3,240,0,0,47,255,224,2,255,255,244,11,255,255,240,31,248,1,160,63,208,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,64,0,0,127,192,0,0,63,224,0,0,31,254,86,244,11,255,255,244,1,255,255,240,0,27,254,64,0,3,240,0,0,3,240,0,0,3,240,0,0,1,80,0,
  // 0x00a3  £
  19,26,130,21,1,0,0,1,191,249,0,0,15,255,255,208,0,63,255,255,192,0,191,208,27,128,0,255,0,0,0,0,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,1,254,0,0,0,22,254,85,80,0,191,255,255,248,0,191,255,255,248,0,106,255,170,164,0,1,254,0,0,0,1,254,0,0,0,1,253,0,0,0,1,253,0,0,0,1,253,0,0,0,3,252,0,0,0,11,244,0,0,0,127,229,85,85,80,255,255,255,255,244,255,255,255,255,244,255,255,255,255,244,
  // 0x00a4  ¤
  16,17,68,21,2,4,20,0,0,8,125,6,164,63,191,191,255,255,47,255,255,252,15,244,11,244,15,192,1,248,31,64,0,252,47,0,0,188,47,0,0,125,47,0,0,188,31,128,0,252,15,224,3,248,15,254,111,244,63,255,255,253,191,111,253,191,60,0,64,45,0,0,0,0,
  // 0x00a5  ¥
  20,26,130,21,0,0,106,64,0,0,170,63,192,0,1,253,31,208,0,3,252,15,240,0,7,244,7,244,0,15,240,3,252,0,31,208,1,253,0,63,192,0,255,0,127,64,0,127,64,255,0,0,63,193,252,0,0,31,211,248,0,0,15,247,240,0,0,3,255,224,0,0,87,255,213,64,2,255,255,255,192,2,255,255,255,192,0,85,191,85,64,0,0,191,0,0,0,0,191,0,0,2,255,255,255,192,2,255,255,255,192,1,170,255,170,128,0,0,191,0,0,0,0,191,0,0,0,0,191,0,0,0,0,191,0,0,
  // 0x00a6  ¦
  4,37,37,20,8,247,20,189,189,189,189,189,189,189,189,189,189,189,189,189,104,0,0,0,0,0,0,0,20,189,189,189,189,189,189,189,189,189,189,189,189,189,104,
  // 0x00a7  §
  14,29,116,18,2,255,0,22,80,0,7,255,255,144,47,255,255,208,63,208,27,192,191,0,0,64,191,0,0,0,127,64,0,0,63,228,0,0,15,255,64,0,7,255,248,0,31,239,255,0,63,64,191,192,126,0,31,224,189,0,7,240,190,0,3,240,127,64,7,240,63,224,11,224,15,255,111,192,2,255,255,0,0,31,255,64,0,1,255,192,0,0,31,224,0,0,11,240,0,0,11,240,208,0,15,224,255,166,191,192,255,255,255,64,47,255,248,0,0,0,0,0,
  // 0x00a8  ¨
  11,5,15,21,5,22,20,0,80,191,2,248,191,3,252,127,2,248,20,0,80,
  // 0x00a9  ©
  26,27,189,30,2,255,0,0,111,255,144,0,0,0,7,255,255,253,0,0,0,63,208,0,191,192,0,1,253,0,0,7,240,0,3,224,0,0,0,252,0,15,128,6,255,128,63,0,47,0,47,255,240,15,64,61,0,255,155,208,7,192,124,1,252,0,0,3,208,180,3,240,0,0,2,224,240,7,224,0,0,1,240,240,7,208,0,0,0,240,240,11,208,0,0,0,240,240,11,208,0,0,0,240,240,11,208,0,0,0,240,240,7,208,0,0,1,240,244,3,240,0,0,2,240,184,3,244,0,0,3,208,60,0,254,65,144,7,192,47,0,127,255,208,15,128,15,128,11,255,128,47,0,7,208,0,0,0,189,0,2,248,0,0,3,248,0,0,127,128,0,111,208,0,0,15,255,175,255,0,0,0,1,191,255,228,0,0,0,0,0,80,0,0,0,
  // 0x00aa  ª
  11,13,39,13,1,13,6,254,64,63,255,224,45,7,240,0,1,244,0,1,244,11,255,244,63,234,244,189,0,244,252,1,244,252,3,244,191,191,244,47,248,180,1,64,0,
  // 0x00ab  «
  17,16,80,19,1,1,0,15,0,30,0,0,63,192,63,128,0,191,64,255,0,2,254,3,252,0,7,248,11,244,0,15,240,47,224,0,63,192,127,128,0,127,128,255,0,0,63,208,63,192,0,15,240,31,224,0,3,252,11,248,0,1,254,2,253,0,0,191,128,255,0,0,47,192,63,128,0,14,0,13,0,0,0,0,0,0,
  // 0x00ac  ¬
  18,10,50,21,1,4,127,255,255,255,240,127,255,255,255,240,63,255,255,255,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,3,240,0,0,0,1,80,
  // 0x00ad  ­
  10,4,12,12,1,8,21,85,64,191,255,208,191,255,208,191,255,208,
  // 0x00ae  ®
  26,27,189,30,2,255,0,0,111,255,144,0,0,0,7,255,255,253,0,0,0,63,208,0,191,192,0,1,253,0,0,7,240,0,3,224,0,0,0,252,0,15,128,170,169,0,63,0,47,0,255,255,192,15,64,61,0,254,175,240,7,192,124,0,252,3,240,3,208,180,0,252,2,244,2,224,240,0,252,2,244,1,240,240,0,252,3,240,0,240,240,0,253,111,224,0,240,240,0,255,255,64,0,240,240,0,255,255,0,0,240,240,0,252,47,64,1,240,244,0,252,15,192,2,240,184,0,252,7,224,3,208,60,0,252,3,240,7,192,47,0,252,1,252,15,128,15,128,252,0,189,47,0,7,208,0,0,0,189,0,2,248,0,0,3,248,0,0,127,128,0,111,208,0,0,15,255,175,255,0,0,0,1,191,255,228,0,0,0,0,0,80,0,0,0,
  // 0x00af  ¯
  18,3,15,18,0,27,255,255,255,255,240,255,255,255,255,240,170,170,170,170,160,
  // 0x00b0  °
  12,12,36,15,2,14,6,255,64,47,255,240,127,155,248,252,0,252,248,0,125,248,0,62,248,0,61,252,0,189,127,70,252,47,255,240,11,255,128,0,16,0,
  // 0x00b1  ±
  18,22,110,21,1,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,42,170,254,170,144,127,255,255,255,240,127,255,255,255,240,21,86,253,85,80,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,248,0,0,0,0,164,0,0,0,0,0,0,0,127,255,255,255,240,127,255,255,255,240,127,255,255,255,240,
  // 0x00b2  ²
  11,17,51,13,1,14,1,169,0,47,255,192,255,255,240,56,3,240,0,3,244,0,3,240,0,3,240,0,15,208,0,47,128,0,190,0,2,248,0,11,224,0,47,128,0,191,170,160,255,255,244,255,255,244,0,0,0,
  // 0x00b3  ³
  12,17,51,13,0,14,1,170,64,31,255,240,63,235,252,13,0,252,0,0,188,0,0,252,0,2,244,3,255,208,3,255,224,0,6,252,0,0,190,0,0,126,0,0,126,121,1,253,127,255,248,47,255,208,0,20,0,
  // 0x00b4  ´
  9,7,21,11,1,21,0,170,64,2,255,0,3,252,0,15,240,0,47,192,0,126,0,0,0,0,0,
  // 0x00b5  µ
  17,29,145,23,3,247,85,0,0,21,64,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,127,192,255,0,0,191,192,255,64,0,255,192,255,208,7,255,192,255,255,255,255,192,255,255,255,31,192,254,127,252,31,192,254,1,64,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,170,0,0,0,0,
  // 0x00b6  ¶
  18,33,165,24,2,251,0,1,85,85,80,1,255,255,255,240,11,255,255,255,240,47,255,255,65,240,63,255,255,1,240,127,255,255,1,240,191,255,255,1,240,255,255,255,1,240,255,255,255,1,240,255,255,255,1,240,255,255,255,1,240,255,255,255,1,240,255,255,255,1,240,191,255,255,1,240,127,255,255,1,240,63,255,255,1,240,15,255,255,1,240,2,255,255,1,240,0,21,95,1,240,0,0,15,1,240,0,0,15,1,240,0,0,15,1,240,0,0,15,1,240,0,0,15,1,240,0,0,15,1,240,0,0,15,1,240,0,0,15,1,240,0,0,15,1,240,0,0,15,1,240,0,0,15,1,240,0,0,15,1,240,0,0,15,1,240,0,0,10,0,160,
  // 0x00b7  ·
  6,6,12,10,2,10,26,0,63,192,127,208,127,208,63,192,5,0,
  // 0x00b8  ¸
  8,9,18,8,0,247,7,192,15,128,31,244,2,252,0,189,0,189,171,252,255,244,106,64,
  // 0x00b9  ¹
  8,17,34,13,1,14,0,21,0,255,7,255,47,255,127,63,40,63,0,63,0,63,0,63,0,63,0,63,0,63,0,63,0,63,0,63,0,63,0,0,
  // 0x00ba  º
  12,13,39,14,1,13,2,255,64,15,255,240,63,86,248,125,0,188,188,0,125,252,0,62,252,0,62,252,0,61,188,0,124,63,1,252,47,255,240,7,255,192,0,20,0,
  // 0x00bb  »
  17,16,80,19,1,1,31,0,45,0,0,127,128,191,64,0,47,208,63,192,0,11,244,15,240,0,3,252,7,248,0,0,255,1,254,0,0,127,128,191,64,0,63,208,63,192,0,127,128,255,64,1,255,2,253,0,3,252,7,248,0,15,240,31,240,0,47,208,63,192,0,127,64,191,0,0,10,0,29,0,0,0,0,0,0,0,
  // 0x00bc  ¼
  27,26,182,28,1,0,0,106,0,0,2,160,0,2,255,0,0,11,224,0,15,255,0,0,15,192,0,127,191,0,0,63,64,0,125,63,0,0,127,0,0,16,63,0,0,252,0,0,0,63,0,2,248,0,0,0,63,0,3,240,0,0,0,63,0,11,208,0,0,0,63,0,31,192,0,0,0,63,0,63,0,42,0,0,63,0,190,0,191,0,0,63,0,252,1,255,0,0,63,2,244,3,255,0,0,63,7,240,11,191,0,0,42,15,192,31,63,0,0,0,47,128,62,63,0,0,0,63,0,188,63,0,0,0,189,1,240,63,0,0,1,252,3,208,63,0,0,3,244,11,234,191,160,0,7,224,15,255,255,244,0,15,192,11,255,255,244,0,47,64,0,0,63,0,0,127,0,0,0,63,0,0,253,0,0,0,63,0,
  // 0x00bd  ½
  27,26,182,29,1,0,0,169,0,0,10,128,0,3,254,0,0,31,192,0,31,254,0,0,63,0,0,191,190,0,0,190,0,0,188,126,0,0,252,0,0,32,190,0,2,244,0,0,0,190,0,7,240,0,0,0,190,0,15,192,0,0,0,190,0,47,128,0,0,0,190,0,63,0,0,0,0,190,0,189,2,169,0,0,190,1,252,63,255,192,0,190,3,244,255,255,240,0,190,7,224,56,7,240,0,190,15,192,0,3,240,0,105,47,64,0,3,240,0,0,127,0,0,3,240,0,0,253,0,0,15,208,0,1,248,0,0,63,128,0,3,240,0,0,254,0,0,11,224,0,3,248,0,0,15,192,0,15,224,0,0,63,64,0,63,128,0,0,126,0,0,255,170,160,0,252,0,0,255,255,244,2,248,0,0,255,255,244,
  // 0x00be  ¾
  28,26,182,29,1,0,11,254,64,0,0,105,0,191,255,208,0,0,252,0,190,91,240,0,2,244,0,16,3,244,0,7,240,0,0,2,244,0,15,208,0,0,3,240,0,31,128,0,5,95,208,0,63,0,0,15,255,0,0,189,0,0,11,255,208,1,252,0,0,0,7,244,3,244,0,0,0,1,248,7,224,6,128,0,0,252,15,192,47,208,64,2,248,47,128,63,208,249,91,244,63,0,255,208,255,255,208,253,2,255,208,47,254,1,248,7,207,208,0,0,3,240,15,143,208,0,0,11,224,47,15,208,0,0,15,192,124,15,208,0,0,63,64,248,15,208,0,0,127,2,250,175,233,0,0,252,3,255,255,253,0,2,248,2,255,255,253,0,3,240,0,0,15,208,0,15,208,0,0,15,208,0,31,192,0,0,15,208,
  // 0x00bf  ¿
  15,27,108,16,1,249,0,1,144,0,0,11,244,0,0,15,252,0,0,15,252,0,0,11,244,0,0,1,80,0,0,0,0,0,0,0,0,0,0,2,160,0,0,3,240,0,0,7,240,0,0,11,240,0,0,31,208,0,0,127,192,0,2,255,0,0,11,252,0,0,47,224,0,0,127,128,0,0,255,0,0,0,254,0,0,0,254,0,0,0,254,0,0,0,255,64,0,144,127,229,111,240,63,255,255,244,11,255,255,224,0,191,233,0,
  // 0x00c0  À
  24,34,204,24,0,0,0,6,168,0,0,0,0,3,254,0,0,0,0,0,255,0,0,0,0,0,63,192,0,0,0,0,15,224,0,0,0,0,2,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x00c1  Á
  24,34,204,24,0,0,0,0,0,42,144,0,0,0,0,127,192,0,0,0,0,255,0,0,0,0,2,252,0,0,0,0,7,240,0,0,0,0,15,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x00c2  Â
  24,34,204,24,0,0,0,0,26,160,0,0,0,0,63,244,0,0,0,0,255,253,0,0,0,2,252,191,0,0,0,11,240,47,192,0,0,47,128,7,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x00c3  Ã
  24,33,198,24,0,0,0,1,164,0,100,0,0,11,255,64,244,0,0,31,255,251,240,0,0,47,91,255,208,0,0,60,0,191,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x00c4  Ä
  24,33,198,24,0,0,0,1,64,5,0,0,0,7,240,31,192,0,0,11,240,47,192,0,0,7,240,31,192,0,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,224,0,0,0,0,47,244,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x00c5  Å
  24,32,192,24,0,0,0,0,6,144,0,0,0,0,127,248,0,0,0,0,253,189,0,0,0,1,240,46,0,0,0,1,240,31,0,0,0,0,240,62,0,0,0,0,255,252,0,0,0,0,63,248,0,0,0,0,63,248,0,0,0,0,191,252,0,0,0,0,254,253,0,0,0,1,253,255,0,0,0,2,252,127,0,0,0,3,248,63,128,0,0,7,244,63,192,0,0,15,240,31,208,0,0,15,224,15,224,0,0,47,192,11,240,0,0,63,192,7,244,0,0,127,128,3,252,0,0,191,0,2,252,0,0,255,255,255,254,0,1,255,255,255,255,0,3,255,255,255,255,64,3,254,170,170,191,128,11,244,0,0,63,192,15,240,0,0,47,208,31,224,0,0,15,240,47,208,0,0,15,240,63,192,0,0,7,248,127,128,0,0,3,252,255,0,0,0,2,253,
  // 0x00c6  Æ
  31,26,208,32,0,0,0,0,0,170,170,170,170,160,0,0,2,255,255,255,255,244,0,0,3,255,255,255,255,244,0,0,11,250,255,170,170,160,0,0,15,240,191,0,0,0,0,0,31,208,191,0,0,0,0,0,63,192,191,0,0,0,0,0,127,64,191,0,0,0,0,0,255,0,191,0,0,0,0,1,254,0,191,0,0,0,0,3,252,0,191,64,0,0,0,7,248,0,191,255,255,224,0,11,240,0,191,255,255,224,0,15,224,0,191,255,255,224,0,47,192,0,191,64,0,0,0,63,255,255,255,0,0,0,0,191,255,255,255,0,0,0,0,255,255,255,255,0,0,0,2,254,170,170,255,0,0,0,3,252,0,0,191,0,0,0,7,248,0,0,191,0,0,0,15,240,0,0,191,0,0,0,31,224,0,0,191,85,85,80,63,192,0,0,191,255,255,244,127,128,0,0,191,255,255,244,255,0,0,0,191,255,255,244,
  // 0x00c7  Ç
  20,35,175,23,2,247,0,0,191,255,144,0,15,255,255,253,0,127,255,255,252,2,255,245,91,252,7,255,0,0,36,15,252,0,0,0,47,240,0,0,0,63,208,0,0,0,63,192,0,0,0,127,128,0,0,0,191,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,255,64,0,0,0,191,64,0,0,0,191,128,0,0,0,127,192,0,0,0,63,192,0,0,0,63,224,0,0,0,31,244,0,0,0,15,253,0,0,0,3,255,208,1,184,0,255,255,255,248,0,63,255,255,248,0,6,255,255,224,0,0,15,208,0,0,0,31,64,0,0,0,63,224,0,0,0,7,252,0,0,0,0,252,0,0,0,0,252,0,0,0,171,252,0,0,0,255,240,0,0,0,170,64,0,
  // 0x00c8  È
  15,34,136,20,3,0,2,168,0,0,2,255,0,0,0,191,64,0,0,47,192,0,0,11,240,0,0,2,248,0,0,0,0,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x00c9  É
  15,34,136,20,3,0,0,0,26,160,0,0,63,208,0,0,255,64,0,1,253,0,0,3,244,0,0,15,208,0,0,0,0,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x00ca  Ê
  15,34,136,20,3,0,0,10,160,0,0,63,248,0,0,191,253,0,2,253,191,64,7,244,31,208,31,192,3,240,0,0,0,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x00cb  Ë
  15,33,132,20,3,0,0,64,5,0,3,240,31,192,7,244,47,192,3,240,15,192,0,64,1,0,0,0,0,0,0,0,0,0,106,170,170,168,191,255,255,252,191,255,255,252,191,170,170,168,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,255,255,244,191,255,255,244,191,255,255,244,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,149,85,84,191,255,255,252,191,255,255,252,191,255,255,252,
  // 0x00cc  Ì
  11,34,102,13,1,0,106,64,0,127,192,0,31,240,0,7,248,0,1,253,0,0,63,0,0,0,0,0,0,0,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,
  // 0x00cd  Í
  11,34,102,13,1,0,0,2,168,0,11,248,0,31,240,0,63,192,0,254,0,2,248,0,0,0,0,0,0,0,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,
  // 0x00ce  Î
  13,34,136,13,0,0,0,106,64,0,1,255,192,0,3,255,240,0,15,227,252,0,63,128,254,0,253,0,47,128,0,0,0,0,0,0,0,0,26,170,168,0,47,255,253,0,31,255,252,0,0,191,128,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,0,191,64,0,11,255,244,0,47,255,253,0,47,255,253,0,
  // 0x00cf  Ï
  11,33,99,13,1,0,20,0,80,190,3,244,255,3,248,190,3,244,20,0,64,0,0,0,0,0,0,106,170,160,191,255,244,127,255,240,2,254,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,2,253,0,47,255,208,191,255,244,191,255,244,
  // 0x00d0  Ð
  23,26,156,26,1,0,6,170,170,144,0,0,7,255,255,255,128,0,7,255,255,255,244,0,7,254,170,255,254,0,7,244,0,7,255,128,7,244,0,0,191,208,7,244,0,0,47,240,7,244,0,0,15,244,7,244,0,0,11,248,7,244,0,0,7,252,7,244,0,0,3,252,91,249,85,0,3,252,255,255,255,64,3,252,255,255,255,64,3,252,255,255,255,0,3,252,7,244,0,0,3,252,7,244,0,0,7,252,7,244,0,0,11,248,7,244,0,0,15,244,7,244,0,0,47,240,7,244,0,0,191,208,7,244,0,7,255,128,7,249,85,191,254,0,7,255,255,255,248,0,7,255,255,255,128,0,7,255,255,228,0,0,
  // 0x00d1  Ñ
  22,33,198,28,3,0,0,2,144,1,144,0,0,31,254,3,224,0,0,63,255,239,192,0,0,189,47,255,128,0,0,180,2,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,128,0,0,10,144,191,240,0,0,15,224,191,244,0,0,15,224,191,252,0,0,15,224,191,254,0,0,15,224,191,255,64,0,15,224,190,127,192,0,15,224,191,63,224,0,15,224,191,15,240,0,15,224,191,11,252,0,15,224,191,3,253,0,15,224,191,1,255,0,15,224,191,0,191,128,15,224,191,0,63,208,15,224,191,0,31,240,15,224,191,0,15,248,15,224,191,0,3,253,15,224,191,0,2,255,15,224,191,0,0,255,143,224,191,0,0,127,207,224,191,0,0,47,255,224,191,0,0,15,255,224,191,0,0,7,255,224,191,0,0,3,255,224,191,0,0,0,255,224,191,0,0,0,191,224,
  // 0x00d2  Ò
  24,35,210,28,2,255,0,2,169,0,0,0,0,1,255,0,0,0,0,0,191,128,0,0,0,0,47,208,0,0,0,0,11,240,0,0,0,0,1,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x00d3  Ó
  24,35,210,28,2,255,0,0,0,26,160,0,0,0,0,63,224,0,0,0,0,191,128,0,0,0,1,254,0,0,0,0,3,248,0,0,0,0,11,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x00d4  Ô
  24,35,210,28,2,255,0,0,10,160,0,0,0,0,47,252,0,0,0,0,127,254,0,0,0,1,254,127,128,0,0,7,244,31,208,0,0,15,192,3,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x00d5  Õ
  24,34,204,28,2,255,0,0,100,0,40,0,0,3,255,128,184,0,0,15,255,251,244,0,0,31,71,255,240,0,0,46,0,127,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x00d6  Ö
  24,34,204,28,2,255,0,0,80,1,64,0,0,3,244,15,208,0,0,3,248,31,208,0,0,3,244,15,192,0,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,191,254,64,0,0,31,255,255,248,0,0,191,255,255,255,0,3,255,229,91,255,192,11,254,0,0,127,240,15,248,0,0,15,244,47,240,0,0,11,252,63,208,0,0,3,253,127,192,0,0,2,254,191,128,0,0,1,255,191,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,255,64,0,0,0,255,191,64,0,0,0,255,191,128,0,0,1,255,127,192,0,0,2,254,63,192,0,0,3,253,63,224,0,0,7,252,31,244,0,0,15,248,15,253,0,0,63,240,3,255,144,6,255,208,0,255,255,255,255,64,0,47,255,255,252,0,0,6,255,255,144,0,0,0,5,80,0,0,
  // 0x00d7  ×
  16,17,68,21,2,4,4,0,0,4,46,0,0,61,127,128,0,255,47,224,3,252,11,248,15,240,2,254,63,192,0,191,255,0,0,47,252,0,0,15,248,0,0,63,254,0,0,255,191,128,3,252,47,224,15,240,11,248,63,192,2,253,127,0,0,191,28,0,0,44,0,0,0,0,
  // 0x00d8  Ø
  24,29,174,28,2,254,0,0,0,0,0,128,0,1,191,254,67,240,0,31,255,255,255,240,0,191,255,255,255,192,3,255,229,91,255,192,11,254,0,0,255,224,15,248,0,1,255,244,47,240,0,3,255,252,63,208,0,11,227,253,127,192,0,31,194,254,191,128,0,63,65,254,191,64,0,254,0,255,255,64,2,252,0,255,255,64,3,244,0,255,255,64,15,224,0,255,255,64,47,192,0,255,191,64,127,0,0,255,191,128,253,0,1,255,127,194,252,0,2,254,63,199,240,0,3,253,47,239,208,0,7,252,31,255,128,0,15,248,11,255,0,0,63,240,3,255,144,6,255,208,3,255,255,255,255,64,11,255,255,255,252,0,15,194,255,255,144,0,7,128,5,80,0,0,0,0,0,0,0,0,
  // 0x00d9  Ù
  21,35,210,27,3,255,0,42,144,0,0,0,0,31,240,0,0,0,0,7,252,0,0,0,0,1,253,0,0,0,0,0,127,0,0,0,0,0,31,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x00da  Ú
  21,35,210,27,3,255,0,0,0,170,0,0,0,0,3,254,0,0,0,0,7,248,0,0,0,0,15,224,0,0,0,0,63,128,0,0,0,0,190,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x00db  Û
  21,35,210,27,3,255,0,0,170,64,0,0,0,2,255,192,0,0,0,7,255,240,0,0,0,15,231,248,0,0,0,63,128,254,0,0,0,253,0,47,128,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x00dc  Ü
  21,34,204,27,3,255,0,5,0,20,0,0,0,63,128,253,0,0,0,63,192,254,0,0,0,47,64,253,0,0,0,5,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,0,0,0,106,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,127,64,255,0,0,0,191,64,191,64,0,0,191,0,127,128,0,0,255,0,63,192,0,1,255,0,63,224,0,3,253,0,15,253,0,47,248,0,7,255,255,255,240,0,1,255,255,255,128,0,0,47,255,249,0,0,0,0,21,0,0,0,
  // 0x00dd  Ý
  21,34,204,21,0,0,0,0,0,170,64,0,0,0,2,255,0,0,0,0,7,252,0,0,0,0,15,240,0,0,0,0,47,192,0,0,0,0,126,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,170,64,0,0,106,128,127,192,0,0,255,64,63,208,0,1,255,0,31,240,0,3,252,0,11,244,0,7,248,0,3,252,0,15,240,0,2,253,0,31,224,0,0,255,0,63,192,0,0,191,128,127,128,0,0,63,192,255,0,0,0,47,226,253,0,0,0,15,243,252,0,0,0,7,255,244,0,0,0,3,255,240,0,0,0,1,255,208,0,0,0,0,255,128,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,0,0,127,64,0,0,
  // 0x00de  Þ
  17,26,130,22,3,0,106,0,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,149,80,0,0,191,255,255,144,0,191,255,255,248,0,191,255,255,254,0,191,64,7,255,64,191,64,0,191,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,63,192,191,64,0,191,128,191,64,2,255,0,191,234,255,254,0,191,255,255,248,0,191,255,255,128,0,191,170,148,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,191,64,0,0,0,
  // 0x00df  ß
  19,29,145,24,3,255,0,5,148,0,0,2,255,255,224,0,15,255,255,253,0,63,254,175,255,0,191,192,0,255,128,255,0,0,127,128,255,0,0,63,128,255,0,0,127,64,255,0,0,255,0,255,0,7,252,0,255,0,31,240,0,255,0,127,192,0,255,0,255,0,0,255,0,255,0,0,255,0,255,64,0,255,0,191,224,0,255,0,63,252,0,255,0,11,255,64,255,0,1,255,224,255,0,0,47,244,255,0,0,11,252,255,0,0,3,252,255,0,0,3,252,255,0,0,3,252,255,6,0,11,248,255,7,250,191,244,255,7,255,255,224,255,2,255,255,64,0,0,5,80,0,
  // 0x00e0  à
  17,29,145,21,1,255,0,106,64,0,0,0,127,192,0,0,0,31,240,0,0,0,7,248,0,0,0,1,253,0,0,0,0,127,0,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x00e1  á
  17,29,145,21,1,255,0,0,2,168,0,0,0,15,248,0,0,0,31,240,0,0,0,63,128,0,0,0,254,0,0,0,2,248,0,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x00e2  â
  17,29,145,21,1,255,0,2,169,0,0,0,7,255,0,0,0,31,255,192,0,0,63,143,224,0,0,254,3,248,0,3,244,0,190,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x00e3  ã
  17,28,140,21,1,255,0,26,0,10,0,0,255,224,31,0,2,255,255,190,0,3,225,255,252,0,7,192,31,240,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x00e4  ä
  17,28,140,21,1,255,0,20,0,80,0,0,254,3,244,0,0,255,3,248,0,0,190,3,244,0,0,20,0,64,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x00e5  å
  17,31,155,21,1,255,0,1,164,0,0,0,11,255,64,0,0,31,159,192,0,0,46,3,208,0,0,61,3,208,0,0,46,7,192,0,0,15,255,128,0,0,7,254,0,0,0,0,0,0,0,0,0,0,0,0,0,6,170,64,0,1,255,255,244,0,3,255,255,254,0,2,249,87,255,0,0,64,0,191,64,0,0,0,63,128,0,0,0,63,192,0,0,0,63,192,0,6,171,255,192,1,255,255,255,192,11,255,254,191,192,47,244,0,63,192,63,192,0,63,192,127,128,0,63,192,127,128,0,127,192,127,128,0,255,192,63,208,3,255,192,47,254,191,239,192,15,255,255,31,192,2,255,248,15,192,0,21,0,0,0,
  // 0x00e6  æ
  29,21,168,32,1,255,0,22,169,0,6,169,0,0,2,255,255,224,127,255,208,0,7,255,255,249,255,255,248,0,3,249,27,255,253,7,253,0,1,64,0,255,240,0,255,0,0,0,0,191,192,0,191,64,0,0,0,127,192,0,63,128,0,0,0,127,128,0,63,192,0,6,171,255,234,170,191,192,1,255,255,255,255,255,255,192,11,255,250,255,255,255,255,192,47,244,0,127,128,0,0,0,63,192,0,127,128,0,0,0,127,128,0,191,192,0,0,0,127,128,0,255,192,0,0,0,127,128,1,255,224,0,0,0,63,208,7,255,248,0,11,0,47,254,191,211,255,255,255,0,15,255,255,64,255,255,255,0,2,255,248,0,31,255,249,0,0,5,0,0,0,21,0,0,
  // 0x00e7  ç
  15,29,116,18,2,247,0,6,170,64,0,255,255,244,7,255,255,240,15,254,171,224,63,240,0,0,127,192,0,0,191,64,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,255,0,0,0,191,128,0,0,63,192,0,0,63,244,0,176,15,255,255,240,3,255,255,240,0,127,255,208,0,3,244,0,0,7,192,0,0,15,248,0,0,1,254,0,0,0,63,0,0,0,63,0,0,106,254,0,0,127,252,0,0,42,80,0,
  // 0x00e8  è
  17,29,145,21,2,255,1,169,0,0,0,1,255,0,0,0,0,127,192,0,0,0,31,224,0,0,0,7,244,0,0,0,0,252,0,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x00e9  é
  17,29,145,21,2,255,0,0,10,160,0,0,0,47,224,0,0,0,127,192,0,0,0,255,0,0,0,3,248,0,0,0,11,224,0,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x00ea  ê
  17,29,145,21,2,255,0,10,164,0,0,0,31,252,0,0,0,63,255,0,0,0,254,63,192,0,3,248,15,224,0,15,208,2,248,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x00eb  ë
  17,28,140,21,2,255,0,80,1,64,0,2,248,15,208,0,3,252,15,224,0,2,248,15,208,0,0,80,1,0,0,0,0,0,0,0,0,0,0,0,0,0,10,169,0,0,0,255,255,208,0,7,255,255,244,0,15,249,27,253,0,63,208,0,255,0,127,128,0,191,64,191,0,0,63,128,255,0,0,63,128,255,170,170,191,192,255,255,255,255,192,255,255,255,255,192,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,191,128,0,0,0,63,208,0,0,0,47,244,0,27,0,15,255,255,255,0,2,255,255,255,0,0,111,255,248,0,0,0,85,0,0,
  // 0x00ec  ì
  8,28,56,10,0,0,170,0,191,128,63,208,15,240,2,252,0,190,0,0,0,0,1,84,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,3,252,
  // 0x00ed  í
  8,28,56,10,3,0,1,170,3,253,15,244,47,208,127,64,253,0,0,0,0,0,85,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,255,0,
  // 0x00ee  î
  13,28,112,10,254,0,0,42,128,0,0,255,224,0,2,255,244,0,11,246,253,0,31,192,127,0,127,0,31,192,0,0,0,0,0,0,0,0,0,21,64,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,0,63,192,0,
  // 0x00ef  ï
  11,27,81,10,255,0,4,0,80,63,1,252,127,66,252,63,1,252,4,0,16,0,0,0,0,0,0,0,85,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,0,255,0,
  // 0x00f0  ð
  18,28,140,22,2,255,0,62,0,60,0,0,127,226,254,0,0,47,255,248,0,0,3,255,192,0,0,11,255,208,0,0,191,239,240,0,0,255,7,252,0,0,52,1,253,0,0,0,0,191,0,0,0,0,63,128,0,127,254,47,192,3,255,255,239,208,15,255,255,255,224,63,244,1,255,240,127,192,0,63,240,191,64,0,31,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,224,191,64,0,31,208,127,192,0,63,192,63,224,0,255,128,15,255,175,255,0,3,255,255,248,0,0,127,255,208,0,0,1,80,0,0,
  // 0x00f1  ñ
  17,27,135,23,3,0,0,104,0,40,0,3,255,128,124,0,11,255,254,248,0,15,135,255,240,0,31,0,127,192,0,0,0,0,0,0,0,0,0,0,0,84,1,170,64,0,252,47,255,244,0,253,191,255,253,0,255,254,91,255,0,255,224,0,255,64,255,128,0,127,128,255,64,0,63,128,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,255,0,0,63,192,
  // 0x00f2  ò
  18,29,145,22,2,255,0,170,0,0,0,0,191,192,0,0,0,47,208,0,0,0,11,240,0,0,0,2,252,0,0,0,0,190,0,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x00f3  ó
  18,29,145,22,2,255,0,0,6,168,0,0,0,15,244,0,0,0,63,208,0,0,0,127,64,0,0,0,253,0,0,0,3,244,0,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x00f4  ô
  18,29,145,22,2,255,0,2,168,0,0,0,15,254,0,0,0,47,255,128,0,0,191,111,208,0,1,253,7,244,0,7,240,0,253,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x00f5  õ
  18,28,140,22,2,255,0,41,0,25,0,1,255,224,62,0,3,255,254,253,0,7,210,255,248,0,11,64,47,224,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x00f6  ö
  18,28,140,22,2,255,0,20,1,64,0,0,253,3,240,0,1,253,7,244,0,0,252,3,240,0,0,16,0,64,0,0,0,0,0,0,0,0,0,0,0,0,6,169,0,0,0,191,255,224,0,7,255,255,252,0,15,254,91,255,0,63,224,0,191,128,127,192,0,63,192,191,64,0,31,224,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,15,240,255,0,0,31,224,127,128,0,47,208,63,192,0,63,192,31,244,1,255,128,11,255,255,255,0,2,255,255,248,0,0,111,255,144,0,0,1,80,0,0,
  // 0x00f7  ÷
  18,17,85,21,1,4,0,1,248,0,0,0,3,253,0,0,0,3,253,0,0,0,2,252,0,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,240,127,255,255,255,240,63,255,255,255,224,0,0,0,0,0,0,0,0,0,0,0,0,180,0,0,0,2,252,0,0,0,3,253,0,0,0,2,252,0,0,0,0,164,0,0,
  // 0x00f8  ø
  18,22,110,22,2,254,0,6,169,11,64,0,191,255,255,192,7,255,255,255,0,15,254,91,255,0,63,224,2,255,128,127,192,7,255,192,191,64,15,255,224,255,0,47,143,240,255,0,127,15,240,255,0,253,15,240,255,2,248,15,240,255,7,240,15,240,255,15,192,15,240,191,127,64,31,224,127,255,0,47,208,63,252,0,63,192,31,248,1,255,128,15,255,255,255,0,31,255,255,248,0,63,127,255,144,0,14,1,80,0,0,0,0,0,0,0,
  // 0x00f9  ù
  17,29,145,23,3,255,1,169,0,0,0,1,255,0,0,0,0,127,192,0,0,0,31,224,0,0,0,7,244,0,0,0,1,252,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x00fa  ú
  17,29,145,23,3,255,0,0,10,160,0,0,0,63,224,0,0,0,127,192,0,0,0,255,0,0,0,3,248,0,0,0,11,224,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x00fb  û
  17,29,145,23,3,255,0,10,164,0,0,0,47,252,0,0,0,127,255,0,0,0,254,127,128,0,3,248,15,224,0,15,208,2,248,0,0,0,0,0,0,0,0,0,0,0,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x00fc  ü
  17,28,140,23,3,255,0,80,1,64,0,3,248,15,208,0,3,252,15,224,0,2,248,15,208,0,0,80,1,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,21,64,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,63,128,254,0,0,127,128,254,0,0,127,128,255,0,0,255,128,255,64,1,255,128,191,192,7,255,128,127,255,255,255,128,47,255,255,47,128,7,255,248,31,128,0,21,0,0,0,
  // 0x00fd  ý
  19,37,185,19,0,247,0,0,2,169,0,0,0,11,252,0,0,0,31,240,0,0,0,63,192,0,0,0,191,0,0,0,1,248,0,0,0,0,0,0,0,0,0,0,0,0,85,0,0,1,84,191,64,0,7,248,63,192,0,15,240,63,192,0,15,240,31,224,0,31,208,15,240,0,63,192,11,244,0,63,128,3,248,0,191,64,3,252,0,255,0,1,253,0,254,0,0,255,2,252,0,0,191,3,252,0,0,63,71,244,0,0,63,203,240,0,0,31,207,224,0,0,15,223,208,0,0,11,255,192,0,0,3,255,128,0,0,3,255,0,0,0,1,255,0,0,0,1,253,0,0,0,3,252,0,0,0,3,248,0,0,0,11,244,0,0,0,47,240,0,0,38,255,192,0,0,127,255,64,0,0,127,253,0,0,0,42,144,0,0,0,
  // 0x00fe  þ
  18,37,185,22,3,247,85,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,1,170,0,0,255,31,255,224,0,254,191,255,252,0,255,254,91,255,0,255,208,0,255,64,255,128,0,127,128,255,0,0,63,192,255,0,0,47,192,255,0,0,47,208,255,0,0,47,208,255,0,0,31,208,255,0,0,47,208,255,0,0,47,208,255,0,0,63,192,255,64,0,63,192,255,192,0,191,128,255,240,2,255,0,255,255,255,253,0,254,127,255,248,0,254,11,255,208,0,255,0,20,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,255,0,0,0,0,170,0,0,0,0,
  // 0x00ff  ÿ
  19,36,180,19,0,247,0,20,0,80,0,0,191,3,248,0,0,255,3,252,0,0,190,2,248,0,0,20,0,80,0,0,0,0,0,0,0,0,0,0,0,85,0,0,1,84,191,64,0,7,248,63,192,0,15,240,63,192,0,15,240,31,224,0,31,208,15,240,0,63,192,11,244,0,63,128,3,248,0,191,64,3,252,0,255,0,1,253,0,254,0,0,255,2,252,0,0,191,3,252,0,0,63,71,244,0,0,63,203,240,0,0,31,207,224,0,0,15,223,208,0,0,11,255,192,0,0,3,255,128,0,0,3,255,0,0,0,1,255,0,0,0,1,253,0,0,0,3,252,0,0,0,3,248,0,0,0,11,244,0,0,0,47,240,0,0,38,255,192,0,0,127,255,64,0,0,127,253,0,0,0,42,144,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
