/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Traditional Chinese 26pt, capital 'A' height: 19px, width: 100%, range: 0x22bf-0xff1a, glyphs: 307
extern const uint8_t NotoSans_Medium_Traditional_Chinese_19[48872] = {
  162,19,191,34,26,255,25,249, // unifont_t
  // 0x22bf  ⊿
  191,34,21,21,126,26,2,0,0,0,0,0,0,64,0,0,0,0,3,128,0,0,0,0,15,128,0,0,0,0,63,128,0,0,0,0,255,128,0,0,0,3,255,128,0,0,0,15,203,128,0,0,0,63,11,128,0,0,0,189,11,128,0,0,2,244,11,128,0,0,11,208,11,128,0,0,47,64,11,128,0,0,189,0,11,128,0,2,244,0,11,128,0,11,208,0,11,128,0,47,128,0,11,128,0,126,0,0,11,128,1,248,0,0,11,128,7,224,0,0,11,128,31,255,255,255,255,128,127,255,255,255,255,128,
  // 0x4e00  一
  0,78,24,3,18,26,1,9,170,170,170,170,170,170,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x4e09  三
  9,78,22,21,126,26,2,255,47,255,255,255,255,192,47,255,255,255,255,192,21,85,85,85,85,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,248,0,3,255,255,255,248,0,1,85,85,85,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,240,255,255,255,255,255,240,85,85,85,85,85,80,
  // 0x4e0a  上
  10,78,24,23,138,26,1,255,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,255,255,240,0,0,15,255,255,240,0,0,15,149,85,80,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,0,0,15,64,0,0,85,85,111,149,85,85,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x4e0b  下
  11,78,24,24,144,26,1,253,21,85,85,85,85,84,127,255,255,255,255,253,127,255,255,255,255,253,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,224,0,0,0,0,15,254,0,0,0,0,15,255,224,0,0,0,15,143,253,0,0,0,15,129,255,128,0,0,15,128,47,240,0,0,15,128,7,224,0,0,15,128,0,128,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,5,64,0,0,
  // 0x4e0d  不
  13,78,24,24,144,26,1,253,21,85,85,85,85,84,63,255,255,255,255,252,63,255,255,255,255,252,0,0,1,248,0,0,0,0,3,240,0,0,0,0,15,208,0,0,0,0,47,208,0,0,0,0,127,214,0,0,0,1,255,239,192,0,0,7,251,219,244,0,0,31,215,209,254,0,0,191,71,208,63,192,3,253,7,208,15,240,47,244,7,208,2,252,191,192,7,208,0,190,61,0,7,208,0,40,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,1,64,0,0,
  // 0x4e26  並
  38,78,24,25,150,26,1,254,0,0,0,0,16,0,0,60,0,0,62,0,0,63,0,0,189,0,0,31,64,0,252,0,0,15,192,2,240,0,21,91,149,87,245,84,63,255,255,255,255,252,63,255,255,255,255,252,0,0,244,31,0,0,0,0,244,31,0,0,1,64,244,31,1,144,11,192,244,31,3,240,7,192,244,31,3,224,3,208,244,31,7,192,2,240,244,31,11,192,1,240,244,31,15,128,0,244,244,31,31,0,0,248,244,31,47,0,0,188,244,31,61,0,0,80,244,31,8,0,0,0,244,31,0,0,0,0,244,31,0,0,191,255,255,255,255,254,191,255,255,255,255,254,85,85,85,85,85,85,
  // 0x4e2d  中
  45,78,22,26,156,26,2,253,0,0,5,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,21,85,111,85,85,64,127,255,255,255,255,208,127,255,255,255,255,208,124,0,31,0,3,208,124,0,31,0,3,208,124,0,31,0,3,208,124,0,31,0,3,208,124,0,31,0,3,208,124,0,31,0,3,208,125,85,111,85,87,208,127,255,255,255,255,208,127,255,255,255,255,208,124,0,31,0,3,208,104,0,31,0,1,64,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,0,5,0,0,0,
  // 0x4e3b  主
  59,78,24,24,144,26,1,254,0,0,45,0,0,0,0,0,63,128,0,0,0,0,15,224,0,0,0,0,3,248,0,0,0,0,0,248,0,0,31,255,255,255,255,244,31,255,255,255,255,244,5,85,91,229,85,80,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,1,85,91,229,85,64,3,255,255,255,255,192,3,255,255,255,255,192,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,127,255,255,255,255,254,127,255,255,255,255,254,21,85,85,85,85,84,
  // 0x4e4b  之
  75,78,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,5,85,91,213,85,64,31,255,255,255,255,244,31,255,255,255,255,240,0,0,0,0,11,208,0,0,0,0,31,128,0,0,0,0,63,0,0,0,0,0,253,0,0,0,0,3,244,0,0,0,0,11,224,0,0,0,0,47,192,0,0,180,0,191,0,0,0,248,2,252,0,0,1,244,11,240,0,0,3,252,63,192,0,0,7,254,254,0,0,0,15,239,244,0,0,0,47,79,244,0,0,0,63,2,255,234,85,85,253,0,63,255,255,254,120,0,1,191,255,253,0,0,0,0,0,0,
  // 0x4ea4  交
  164,78,24,26,156,26,1,253,0,0,2,128,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,85,85,85,85,84,0,7,128,1,224,0,0,31,192,3,252,0,0,127,64,0,191,64,1,253,0,0,31,224,11,244,0,1,7,248,127,199,192,3,225,253,47,3,224,7,208,120,4,2,240,15,192,0,0,0,252,47,64,0,0,0,190,126,0,0,0,0,63,252,0,0,0,0,15,240,0,0,0,0,47,248,0,0,0,1,255,255,64,0,0,47,248,63,248,0,27,255,208,7,255,228,191,253,0,0,191,254,63,64,0,0,6,252,0,0,0,0,0,0,
  // 0x4eae  亮
  174,78,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,0,0,0,0,0,170,170,170,170,0,0,255,255,255,255,0,0,248,0,0,47,0,0,248,0,0,47,0,0,254,170,170,191,0,0,255,255,255,255,0,0,0,0,0,0,0,63,255,255,255,255,252,63,255,255,255,255,252,60,0,0,0,0,60,60,3,224,31,0,60,60,3,208,31,0,60,0,3,208,31,0,0,0,11,192,31,0,0,0,15,192,31,0,36,0,63,64,31,0,46,6,253,0,31,64,61,191,244,0,31,255,252,63,64,0,11,255,244,0,0,0,0,0,0,
  // 0x4ee4  令
  228,78,24,26,156,26,1,253,0,0,1,64,0,0,0,0,15,224,0,0,0,0,63,244,0,0,0,0,190,253,0,0,0,1,252,63,64,0,0,7,240,15,208,0,0,31,208,7,244,0,0,191,64,1,254,0,2,253,0,0,127,192,31,251,255,255,239,248,191,71,255,255,210,255,124,0,0,0,0,125,16,0,0,0,0,4,0,0,0,0,0,0,11,255,255,255,255,192,11,255,255,255,255,192,0,0,61,0,11,192,0,0,61,0,11,192,0,0,61,0,11,192,0,0,61,0,11,192,0,0,61,0,11,192,0,0,61,7,255,128,0,0,61,3,255,0,0,0,61,0,80,0,0,0,61,0,0,0,0,0,20,0,0,0,
  // 0x4ef6  件
  246,78,24,25,150,26,1,253,0,46,0,11,192,0,0,62,14,11,192,0,0,124,31,11,192,0,0,252,47,11,192,0,1,244,62,11,192,0,3,240,63,255,255,248,11,208,127,255,255,248,15,208,253,91,213,80,63,208,244,11,192,0,191,211,240,11,192,0,251,208,208,11,192,0,115,208,0,11,192,0,3,209,85,91,213,85,3,210,255,255,255,255,3,210,255,255,255,255,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,3,208,0,11,192,0,1,64,0,1,64,0,
  // 0x4efd  份
  253,78,25,26,182,26,0,253,0,1,0,0,0,0,0,0,15,128,63,255,64,0,0,15,64,63,255,128,0,0,47,2,80,11,192,0,0,61,3,208,3,192,0,0,188,7,192,3,224,0,1,244,15,128,1,240,0,3,244,31,0,0,248,0,11,244,62,0,0,188,0,31,244,188,0,0,63,0,127,246,244,0,0,31,192,61,247,239,255,255,255,128,36,244,143,255,255,242,0,0,244,0,62,2,240,0,0,244,0,61,1,240,0,0,244,0,61,1,240,0,0,244,0,60,2,240,0,0,244,0,188,2,240,0,0,244,0,248,2,240,0,0,244,1,240,2,240,0,0,244,3,224,3,224,0,0,244,11,192,3,224,0,0,244,47,64,87,208,0,0,244,190,0,255,192,0,0,244,56,0,255,64,0,0,0,0,0,0,0,0,
  // 0x4f11  休
  17,79,24,25,150,26,1,253,0,15,64,15,64,0,0,31,64,15,128,0,0,47,0,15,128,0,0,62,0,15,128,0,0,252,0,15,128,0,1,248,0,15,128,0,3,241,85,95,149,84,11,243,255,255,255,254,31,243,255,255,255,254,127,240,0,63,240,0,254,240,0,191,244,0,245,240,0,255,252,0,97,240,2,255,189,0,1,240,3,223,159,0,1,240,15,207,143,128,1,240,31,79,135,192,1,240,62,15,131,240,1,240,252,15,129,248,1,243,244,15,128,190,1,251,224,15,128,63,1,242,128,15,128,12,1,240,0,15,128,0,1,240,0,15,128,0,1,240,0,15,128,0,0,80,0,5,0,0,
  // 0x4f4d  位
  77,79,24,25,150,26,1,253,0,31,0,15,128,0,0,63,0,15,128,0,0,61,0,15,128,0,0,252,0,15,128,0,1,244,85,95,149,84,3,240,255,255,255,253,11,224,255,255,255,253,31,224,0,0,0,0,63,224,1,0,2,64,255,224,15,0,7,208,250,224,15,64,11,192,162,224,15,128,11,192,2,224,11,192,15,128,2,224,7,192,15,64,2,224,3,192,31,0,2,224,3,208,47,0,2,224,3,224,62,0,2,224,2,224,61,0,2,224,2,240,124,0,2,224,1,144,184,0,2,224,85,85,249,85,2,227,255,255,255,255,2,227,255,255,255,255,2,224,0,0,0,0,0,80,0,0,0,0,
  // 0x4f4e  低
  78,79,26,24,168,26,0,254,0,11,128,0,0,16,0,0,15,64,0,27,252,0,0,47,21,175,255,249,0,0,62,47,255,253,64,0,0,188,47,148,188,0,0,0,248,47,0,124,0,0,2,244,47,0,124,0,0,7,244,47,0,124,0,0,15,244,47,0,125,0,0,63,244,47,255,255,255,192,125,244,47,255,255,255,192,40,244,47,0,61,0,0,0,244,47,0,62,0,0,0,244,47,0,47,0,0,0,244,47,0,31,0,0,0,244,47,0,31,0,0,0,244,47,1,79,64,0,0,244,47,191,223,129,64,0,244,255,255,215,194,208,0,244,255,164,3,210,192,0,244,80,0,2,243,192,0,244,0,0,0,255,128,0,244,127,255,253,47,0,0,244,127,255,253,0,0,
  // 0x4f5c  作
  92,79,24,25,150,26,1,253,0,15,0,180,0,0,0,47,0,248,0,0,0,61,1,240,0,0,0,188,3,224,0,0,0,248,7,255,255,255,2,240,15,255,255,255,7,240,31,95,149,85,15,240,62,15,64,0,47,240,188,15,64,0,127,241,248,15,64,0,255,242,240,15,255,253,118,240,128,15,255,253,18,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,255,254,2,240,0,15,255,254,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,2,240,0,15,64,0,0,80,0,5,0,0,
  // 0x4f9b  供
  155,79,24,25,150,26,1,253,0,46,3,208,15,0,0,62,3,208,15,0,0,124,3,208,15,0,0,248,3,208,15,0,1,240,3,208,15,0,3,224,255,255,255,254,11,208,255,255,255,254,31,208,87,229,95,84,63,208,3,208,15,0,255,208,3,208,15,0,251,208,3,208,15,0,179,208,3,208,15,0,3,208,3,208,15,0,3,209,87,229,111,85,3,211,255,255,255,255,3,211,255,255,255,255,3,208,0,0,0,0,3,208,1,64,1,0,3,208,7,224,31,0,3,208,15,192,15,192,3,208,63,0,3,240,3,208,253,0,0,248,3,211,248,0,0,189,3,208,224,0,0,60,1,64,0,0,0,0,
  // 0x4fdd  保
  221,79,24,25,150,26,1,253,0,31,0,0,0,0,0,47,63,255,255,244,0,61,63,255,255,244,0,188,60,0,0,244,0,244,60,0,0,244,2,240,60,0,0,244,7,224,60,0,0,244,15,224,61,0,0,244,47,224,63,255,255,244,191,224,63,255,255,244,254,224,0,11,128,0,178,224,0,11,128,0,18,224,0,11,192,0,2,227,255,255,255,255,2,227,255,255,255,255,2,224,0,127,244,0,2,224,0,255,252,0,2,224,3,251,239,0,2,224,15,203,143,192,2,224,63,11,131,240,2,225,253,11,129,253,2,231,244,11,128,127,2,226,208,11,128,29,2,224,0,11,128,0,0,80,0,5,64,0,
  // 0x4fe1  信
  225,79,24,25,150,26,1,253,0,30,0,0,0,0,0,47,15,255,255,224,0,61,15,255,255,224,0,188,0,0,0,0,0,248,0,0,0,0,3,242,255,255,255,255,11,226,255,255,255,255,31,224,0,0,0,0,127,224,47,255,255,240,254,224,47,255,255,240,246,224,0,0,0,0,162,224,0,0,0,0,2,224,47,255,255,240,2,224,47,255,255,240,2,224,0,0,0,0,2,224,0,0,0,0,2,224,63,255,255,244,2,224,63,255,255,244,2,224,61,0,0,244,2,224,61,0,0,244,2,224,61,0,0,244,2,224,63,255,255,244,2,224,63,255,255,244,2,224,61,0,0,244,0,0,4,0,0,0,
  // 0x500b  個
  11,80,23,25,150,26,1,253,0,124,0,0,0,0,0,188,255,255,255,252,0,244,255,255,255,252,1,240,240,0,0,124,3,224,240,7,64,60,7,192,240,7,64,60,15,192,240,7,64,60,47,192,243,255,255,60,127,192,243,255,255,60,255,192,240,7,64,60,247,192,240,7,64,60,147,192,240,175,232,60,3,192,240,255,252,60,3,192,240,224,44,60,3,192,240,224,44,60,3,192,240,224,44,60,3,192,240,224,44,60,3,192,240,255,252,60,3,192,240,170,168,60,3,192,240,0,0,60,3,192,240,0,0,124,3,192,255,255,255,252,3,192,255,255,255,252,3,192,240,0,0,60,2,128,80,0,0,0,
  // 0x503c  值
  60,80,24,26,156,26,1,253,0,0,0,5,64,0,0,46,0,11,192,0,0,61,0,15,128,0,0,189,255,255,255,252,0,249,255,255,255,252,1,240,0,31,0,0,3,224,0,31,0,0,11,208,0,46,0,0,15,192,63,255,255,224,63,192,63,255,255,224,191,192,60,0,2,224,251,192,63,170,171,224,115,192,63,255,255,224,3,192,60,0,2,224,3,192,60,0,2,224,3,192,62,170,171,224,3,192,63,255,255,224,3,192,60,0,2,224,3,192,60,0,2,224,3,192,63,255,255,224,3,192,62,170,171,224,3,192,60,0,2,224,3,192,60,0,2,224,3,199,255,255,255,255,3,199,255,255,255,255,2,128,0,0,0,0,
  // 0x504f  偏
  79,80,25,25,175,26,0,253,0,31,0,0,0,0,0,0,46,191,255,255,255,192,0,61,191,255,255,255,192,0,124,0,0,0,0,0,0,248,0,0,0,0,0,1,244,47,255,255,255,0,3,240,47,255,255,255,0,7,240,46,0,0,47,0,15,240,46,0,0,47,0,63,240,47,255,255,255,0,126,240,47,255,255,255,0,60,240,46,0,0,0,0,36,240,45,0,0,0,0,0,240,63,255,255,255,64,0,240,63,255,255,255,64,0,240,63,195,75,15,64,0,240,127,195,75,15,64,0,240,191,255,255,255,64,0,240,251,255,255,255,64,0,241,243,195,75,15,64,0,243,227,195,75,15,64,0,247,195,195,75,15,64,0,243,131,195,75,191,64,0,240,3,195,75,62,0,0,0,0,0,0,0,0,
  // 0x505c  停
  92,80,25,26,182,26,0,253,0,0,0,1,64,0,0,0,11,128,3,224,0,0,0,15,64,3,224,0,0,0,47,191,255,255,255,192,0,61,191,255,255,255,192,0,188,0,0,0,0,0,0,248,10,170,170,168,0,3,244,15,255,255,252,0,7,244,15,64,0,124,0,15,244,15,64,0,124,0,63,244,15,234,170,252,0,126,244,15,255,255,252,0,60,244,0,0,0,0,0,0,244,255,255,255,255,192,0,244,255,255,255,255,192,0,244,240,0,0,3,192,0,244,240,0,0,3,192,0,244,243,255,255,243,192,0,244,83,255,255,240,0,0,244,0,3,224,0,0,0,244,0,3,224,0,0,0,244,0,3,224,0,0,0,244,0,3,224,0,0,0,244,1,255,208,0,0,0,244,0,255,192,0,0,0,0,0,0,0,0,0,
  // 0x5075  偵
  117,80,25,26,182,26,0,253,0,0,0,1,64,0,0,0,7,128,3,208,0,0,0,11,192,3,224,0,0,0,15,64,3,255,255,64,0,47,0,3,255,255,64,0,61,0,3,208,0,0,0,252,0,3,208,0,0,1,248,15,255,255,253,0,3,248,15,255,255,253,0,15,248,15,0,0,61,0,47,248,15,0,0,61,0,127,184,15,255,255,253,0,44,184,15,255,255,253,0,0,184,15,0,0,61,0,0,184,15,234,170,253,0,0,184,15,255,255,253,0,0,184,15,0,0,61,0,0,184,15,0,0,61,0,0,184,15,255,255,253,0,0,184,15,255,255,253,0,0,184,0,16,1,0,0,0,184,1,252,11,224,0,0,184,11,244,3,252,0,0,184,191,192,0,191,64,0,184,125,0,0,31,64,0,16,0,0,0,0,0,
  // 0x5099  備
  153,80,25,25,175,26,0,253,0,31,0,244,7,192,0,0,46,0,244,7,192,0,0,61,255,255,255,255,192,0,124,255,255,255,255,192,0,248,0,244,7,192,0,1,240,0,244,7,192,0,3,240,0,0,0,0,0,7,240,191,255,255,255,192,15,240,191,255,255,255,192,63,240,184,0,0,0,0,126,240,184,0,0,0,0,60,240,184,255,255,255,64,16,240,184,255,255,255,64,0,240,184,240,60,11,64,0,240,184,240,60,11,64,0,240,184,255,255,255,64,0,240,180,250,190,175,64,0,240,244,240,60,11,64,0,240,240,250,190,175,64,0,241,240,255,255,255,64,0,242,224,240,60,11,64,0,243,208,240,60,15,64,0,247,192,240,60,255,0,0,241,64,240,60,190,0,0,80,0,0,0,0,0,
  // 0x50b3  傳
  179,80,25,25,175,26,0,253,0,11,64,2,224,0,0,0,15,128,2,224,0,0,0,31,255,255,255,255,128,0,62,191,255,255,255,128,0,124,5,87,245,85,0,0,248,47,255,255,255,0,2,244,46,2,224,47,0,7,244,47,87,245,111,0,15,244,47,255,255,255,0,63,244,46,2,224,47,0,126,244,47,87,245,111,0,60,244,47,255,255,255,0,0,244,0,2,224,248,0,0,244,106,171,250,254,0,0,244,191,255,255,255,128,0,244,21,64,3,211,64,0,244,0,0,3,208,0,0,245,255,255,255,255,192,0,244,255,255,255,255,192,0,244,7,192,3,208,0,0,244,2,244,3,208,0,0,244,0,188,3,208,0,0,244,0,33,255,208,0,0,244,0,0,255,128,0,0,80,0,0,0,0,0,
  // 0x50be  傾
  190,80,25,25,175,26,0,253,0,61,0,0,0,0,0,0,60,0,191,255,255,192,0,188,144,191,255,255,192,0,245,240,0,47,0,0,1,241,240,0,46,0,0,2,241,240,31,255,255,0,3,241,241,159,255,255,0,11,241,243,255,0,15,0,31,241,255,159,0,15,0,63,241,254,31,255,255,0,126,241,248,31,170,191,0,57,241,240,31,0,15,0,17,241,240,31,0,15,0,1,241,240,31,170,191,0,1,241,240,95,255,255,0,1,241,240,255,0,15,0,1,241,240,255,0,15,0,1,241,241,255,255,255,0,1,241,255,239,255,255,0,1,240,191,129,0,16,0,1,240,0,7,208,248,0,1,240,0,47,192,190,0,1,240,2,254,0,31,192,1,240,1,244,0,7,128,0,80,0,64,0,0,0,
  // 0x5132  儲
  50,81,24,26,156,26,1,253,0,0,0,0,80,0,0,228,0,0,240,24,0,247,255,192,240,46,2,243,255,192,240,60,3,224,0,15,255,188,7,198,170,159,255,244,11,207,255,224,241,240,15,192,0,0,243,224,63,192,0,0,247,192,127,195,255,223,255,255,255,195,255,223,255,255,251,192,0,0,125,208,151,195,255,193,244,244,7,195,255,203,224,52,7,192,0,63,255,252,7,192,0,46,255,252,7,199,255,209,224,60,7,199,255,209,224,60,7,199,130,209,255,252,7,199,130,209,255,252,7,199,130,209,224,60,7,199,130,209,224,60,7,199,255,209,255,252,7,199,255,209,255,252,7,199,128,1,224,60,1,64,0,0,0,0,
  // 0x5145  充
  69,81,24,25,150,26,1,253,0,0,7,192,0,0,0,0,7,192,0,0,21,85,91,213,85,84,63,255,255,255,255,252,63,255,255,255,255,252,0,1,244,0,64,0,0,3,240,7,208,0,0,7,208,3,244,0,0,11,192,0,253,0,0,15,128,0,127,64,31,255,255,255,255,208,31,255,255,255,255,240,10,170,85,80,1,252,0,1,160,10,64,160,0,3,224,15,64,0,0,3,224,15,64,0,0,3,208,15,64,0,0,7,208,15,64,0,0,15,192,15,64,29,0,47,64,15,64,31,0,191,0,15,64,31,7,252,0,15,128,46,191,240,0,15,255,253,63,64,0,7,255,248,16,0,0,0,21,64,
  // 0x5148  先
  72,81,24,26,156,26,1,253,0,0,1,64,0,0,0,40,3,192,0,0,0,61,3,192,0,0,0,188,3,192,0,0,0,253,87,213,85,64,0,255,255,255,255,208,2,255,255,255,255,208,3,224,3,192,0,0,11,192,3,192,0,0,15,128,3,192,0,0,7,0,3,192,0,0,0,0,3,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,87,229,95,149,84,0,3,208,15,64,0,0,7,208,15,64,0,0,11,192,15,64,0,0,15,192,15,64,0,0,31,64,15,64,40,0,63,0,15,64,46,0,253,0,15,64,46,11,248,0,15,213,125,127,224,0,11,255,252,63,0,0,2,255,244,4,0,0,0,0,0,
  // 0x5149  光
  73,81,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,2,192,7,192,3,208,3,224,7,192,7,208,2,240,7,192,15,192,0,248,7,192,31,64,0,188,7,192,63,0,0,61,7,192,125,0,0,61,7,192,120,0,0,0,7,192,0,0,21,85,91,213,85,84,191,255,255,255,255,254,191,255,255,255,255,254,0,3,224,15,64,0,0,3,208,15,64,0,0,3,208,15,64,0,0,7,192,15,64,0,0,15,192,15,64,0,0,15,128,15,64,0,0,47,0,15,64,29,0,127,0,15,64,31,2,252,0,15,64,47,31,244,0,15,128,62,255,192,0,15,255,253,61,0,0,7,255,248,0,0,0,0,21,64,
  // 0x5165  入
  101,81,24,24,144,26,1,253,0,63,255,224,0,0,0,63,255,224,0,0,0,21,87,224,0,0,0,0,2,224,0,0,0,0,2,240,0,0,0,0,6,240,0,0,0,0,15,240,0,0,0,0,31,244,0,0,0,0,47,248,0,0,0,0,63,188,0,0,0,0,62,125,0,0,0,0,188,62,0,0,0,0,252,47,0,0,0,2,244,15,128,0,0,3,240,11,208,0,0,15,208,3,240,0,0,47,192,2,252,0,0,127,0,0,254,0,1,253,0,0,63,128,11,248,0,0,31,240,63,224,0,0,7,253,191,128,0,0,1,254,45,0,0,0,0,56,0,0,0,0,0,0,
  // 0x5168  全
  104,81,24,25,150,26,1,254,0,0,5,64,0,0,0,0,15,240,0,0,0,0,63,248,0,0,0,0,189,190,0,0,0,2,248,63,128,0,0,11,224,15,224,0,0,63,128,3,248,0,0,254,0,0,191,64,7,244,0,0,31,224,63,208,0,0,7,253,255,191,255,255,255,254,56,191,255,255,254,28,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,3,255,255,255,255,128,3,255,255,255,255,128,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,208,0,0,63,255,255,255,255,252,63,255,255,255,255,252,
  // 0x5171  共
  113,81,24,25,150,26,1,253,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,47,255,255,255,255,252,47,255,255,255,255,252,5,95,213,87,245,84,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,0,15,128,2,240,0,21,95,213,87,245,85,191,255,255,255,255,254,191,255,255,255,255,254,0,0,0,0,0,0,0,2,0,1,128,0,0,11,224,11,240,0,0,63,128,2,253,0,0,254,0,0,127,64,11,248,0,0,31,224,63,208,0,0,3,252,47,0,0,0,0,248,0,0,0,0,0,0,
  // 0x5177  具
  119,81,24,24,144,26,1,253,0,191,255,255,255,0,0,191,255,255,255,0,0,184,0,0,47,0,0,184,0,0,47,0,0,191,255,255,255,0,0,191,255,255,255,0,0,184,0,0,47,0,0,184,0,0,47,0,0,191,255,255,255,0,0,191,255,255,255,0,0,184,0,0,47,0,0,184,0,0,47,0,0,191,255,255,255,0,0,191,255,255,255,0,0,0,0,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,85,85,85,85,84,0,7,192,3,208,0,0,127,240,15,254,0,11,255,64,1,255,224,127,244,0,0,27,253,46,64,0,0,1,244,0,0,0,0,0,0,
  // 0x5197  冗
  151,81,24,24,144,26,1,253,21,85,85,85,85,84,63,255,255,255,255,252,63,255,255,255,255,252,62,0,0,0,0,188,62,0,0,0,0,188,62,0,0,0,0,188,62,0,0,0,0,188,0,15,255,255,224,0,0,15,255,255,224,0,0,15,213,87,224,0,0,15,192,3,224,0,0,15,192,3,224,0,0,15,192,3,224,0,0,15,128,3,224,0,0,15,128,3,224,0,0,15,64,3,224,0,0,47,0,3,224,24,0,63,0,3,224,31,0,253,0,3,224,31,3,248,0,3,224,47,47,240,0,3,245,126,191,128,0,2,255,253,61,0,0,0,191,244,0,0,0,0,0,0,
  // 0x51b7  冷
  183,81,24,25,150,26,1,253,0,0,0,63,0,0,24,0,0,191,192,0,126,0,1,251,224,0,63,192,3,242,248,0,11,240,15,192,190,0,2,240,63,64,63,128,0,128,253,0,15,224,0,3,252,0,7,253,0,31,239,255,252,191,0,63,79,255,252,29,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,181,255,255,255,240,0,249,255,255,255,240,3,240,0,248,1,240,7,208,0,248,1,240,15,192,0,248,1,240,47,64,0,248,1,240,127,0,0,248,22,240,252,0,0,248,127,240,56,0,0,248,63,128,0,0,0,248,0,0,0,0,0,248,0,0,0,0,0,80,0,0,
  // 0x51c6  准
  198,81,24,25,150,26,1,253,0,0,3,208,46,0,8,0,7,192,62,0,63,0,15,128,61,0,47,208,31,64,188,0,7,244,63,0,248,0,0,244,127,255,255,253,0,32,255,255,255,253,0,2,253,1,240,0,0,7,253,1,240,0,0,31,253,1,240,0,0,15,63,255,255,248,0,1,63,255,255,248,0,0,62,1,240,0,0,80,61,1,240,0,0,240,61,1,240,0,2,244,62,1,240,0,3,224,63,255,255,248,11,192,63,255,255,248,31,128,61,1,240,0,63,0,61,1,240,0,253,0,61,1,240,0,120,0,63,255,255,255,0,0,63,255,255,255,0,0,62,0,0,0,0,0,20,0,0,0,
  // 0x51fa  出
  250,81,20,25,125,26,3,253,0,0,124,0,0,0,0,124,0,0,61,0,124,0,124,61,0,124,0,124,61,0,124,0,124,61,0,124,0,124,61,0,124,0,124,61,0,124,0,124,61,0,124,0,124,63,255,255,255,252,63,255,255,255,252,21,85,189,85,84,0,0,124,0,0,244,0,124,0,31,244,0,124,0,31,244,0,124,0,31,244,0,124,0,31,244,0,124,0,31,244,0,124,0,31,244,0,124,0,31,249,85,189,85,111,255,255,255,255,255,255,255,255,255,255,244,0,0,0,31,80,0,0,0,5,
  // 0x5206  分
  6,82,24,25,150,26,1,253,0,2,128,2,128,0,0,7,224,7,208,0,0,15,192,3,240,0,0,31,128,1,248,0,0,63,0,0,189,0,0,189,0,0,63,0,2,248,0,0,31,192,7,240,0,0,11,240,31,208,0,0,3,252,191,213,85,85,85,255,254,255,255,255,255,126,52,255,255,255,255,8,0,0,61,0,31,0,0,0,124,0,47,0,0,0,188,0,47,0,0,0,252,0,47,0,0,1,248,0,47,0,0,3,240,0,62,0,0,7,224,0,62,0,0,15,192,0,62,0,0,127,64,0,61,0,2,254,0,0,188,0,47,244,0,255,252,0,15,128,0,255,240,0,4,0,0,21,0,0,
  // 0x5217  列
  23,82,23,25,150,26,1,253,0,0,0,0,0,188,127,255,255,208,0,188,127,255,255,214,64,188,0,125,0,11,128,188,0,188,0,11,128,188,0,248,0,11,128,188,0,248,0,11,128,188,2,255,255,139,128,188,3,255,255,75,128,188,7,192,15,75,128,188,15,128,31,11,128,188,47,128,47,11,128,188,127,240,62,11,128,188,254,253,124,11,128,188,176,127,252,11,128,188,0,15,244,11,128,188,0,3,240,11,128,188,0,7,208,5,0,188,0,15,192,0,0,188,0,63,0,0,0,188,0,253,0,0,0,188,3,248,0,0,0,188,31,224,0,0,255,248,15,64,0,0,127,240,0,0,0,0,21,0,
  // 0x521d  初
  29,82,24,26,156,26,1,253,0,80,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,15,255,255,253,0,244,15,255,255,253,0,248,5,95,149,125,191,255,224,15,64,61,191,255,208,15,0,61,0,7,192,31,0,61,0,15,128,31,0,61,0,47,0,31,0,60,0,125,56,47,0,124,0,252,244,47,0,124,3,255,208,62,0,124,11,255,192,61,0,124,47,251,208,61,0,124,254,246,240,124,0,124,248,244,224,252,0,188,32,244,0,244,0,188,0,244,2,240,0,188,0,244,7,224,0,248,0,244,15,192,0,248,0,244,127,65,86,244,0,244,254,1,255,240,0,244,56,0,255,128,0,80,0,0,0,0,
  // 0x5230  到
  48,82,23,25,150,26,1,253,0,0,0,0,0,104,191,255,255,224,0,124,191,255,255,224,0,124,0,252,0,7,192,124,0,244,0,7,192,124,1,240,124,7,192,124,3,224,62,7,192,124,3,208,15,71,192,124,27,255,255,199,192,124,191,255,255,231,192,124,186,149,1,247,192,124,0,15,0,71,192,124,0,15,0,7,192,124,0,15,0,7,192,124,63,255,255,135,192,124,63,255,255,135,192,124,0,31,64,7,192,124,0,15,0,6,128,124,0,15,0,0,0,124,0,15,0,80,0,124,0,111,255,224,0,124,191,255,255,224,0,188,255,255,164,0,191,252,101,0,0,0,127,240,0,0,0,0,21,64,
  // 0x5236  制
  54,82,23,26,156,26,1,253,0,1,0,0,0,0,10,75,128,0,0,60,15,75,128,0,16,60,15,11,128,0,244,60,31,255,255,224,244,60,63,255,255,224,244,60,125,11,128,0,244,60,252,11,128,0,244,60,36,11,128,0,244,60,255,255,255,248,244,60,255,255,255,248,244,60,0,11,128,0,244,60,0,11,128,0,244,60,0,11,128,0,244,60,47,255,255,240,244,60,47,255,255,240,244,60,45,11,129,240,244,60,45,11,129,240,180,60,45,11,129,240,0,60,45,11,129,240,0,60,45,11,129,240,0,60,45,11,175,224,0,60,45,11,143,192,0,124,0,11,128,0,63,252,0,11,128,0,47,244,0,0,0,0,5,64,
  // 0x5237  刷
  55,82,23,25,150,26,1,253,0,0,0,0,0,124,31,255,255,240,0,124,31,255,255,241,224,124,31,0,1,241,240,124,31,0,1,241,240,124,31,0,1,241,240,124,31,255,255,241,240,124,31,255,255,241,240,124,31,1,240,1,240,124,31,0,240,1,240,124,31,0,240,1,240,124,31,255,255,241,240,124,31,255,255,241,240,124,30,240,240,241,240,124,30,240,240,241,240,124,46,240,240,241,240,124,45,240,240,241,240,124,61,240,240,240,80,124,60,240,240,240,0,124,60,240,251,240,0,124,124,240,247,208,0,124,248,80,240,0,0,124,240,0,240,0,63,252,32,0,240,0,47,244,0,0,80,0,5,64,
  // 0x5275  創
  117,82,23,25,150,26,1,253,0,15,208,0,0,124,0,31,248,0,0,124,0,126,190,0,0,124,0,252,47,195,192,124,3,240,11,243,192,124,31,255,254,227,192,124,191,42,168,67,192,124,184,0,0,3,192,124,23,255,255,195,192,124,7,234,175,195,192,124,7,128,3,195,192,124,7,255,255,195,192,124,7,234,171,195,192,124,11,128,3,195,192,124,11,255,255,195,192,124,11,234,170,131,192,124,15,64,0,3,192,124,15,255,255,210,128,124,31,255,255,208,0,124,46,240,3,208,0,124,61,240,3,208,0,124,184,255,255,208,0,188,176,255,255,208,191,252,0,240,2,208,127,240,0,0,0,0,21,0,
  // 0x529b  力
  155,82,23,26,156,26,1,253,0,0,5,0,0,0,0,0,47,0,0,0,0,0,47,0,0,0,0,0,47,0,0,0,0,0,47,0,0,0,0,0,47,0,0,0,21,85,127,85,85,84,63,255,255,255,255,248,63,255,255,255,255,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,61,0,0,244,0,0,125,0,1,240,0,0,188,0,1,240,0,0,252,0,1,240,0,1,248,0,1,240,0,3,240,0,2,240,0,7,224,0,2,240,0,15,192,0,3,224,0,63,128,0,3,224,0,255,0,0,3,208,3,252,0,0,11,192,31,240,0,21,111,192,127,192,0,47,255,64,30,0,0,31,253,0,0,0,0,0,0,0,
  // 0x52a0  加
  160,82,23,25,150,26,1,253,0,240,0,0,0,0,0,240,0,0,0,0,0,240,0,0,0,0,0,240,0,31,255,248,21,249,85,31,255,248,191,255,255,31,85,248,191,255,255,31,0,184,0,240,31,31,0,184,1,240,47,31,0,184,1,240,47,31,0,184,1,240,47,31,0,184,1,240,46,31,0,184,2,240,46,31,0,184,2,224,46,31,0,184,3,208,46,31,0,184,3,208,46,31,0,184,7,192,62,31,0,184,11,192,62,31,0,184,15,128,61,31,0,184,15,64,61,31,85,248,63,0,61,31,255,248,126,21,188,31,255,248,252,47,252,31,0,184,112,31,224,31,0,168,0,0,0,0,0,0,
  // 0x52d5  動
  213,82,24,25,150,26,1,253,0,5,175,1,240,0,127,255,255,65,240,0,127,255,80,1,240,0,0,30,0,1,240,0,191,255,255,193,240,0,255,255,255,213,240,0,0,30,0,63,255,253,42,191,170,127,255,253,63,255,255,129,240,61,60,30,7,129,240,61,60,30,7,130,224,61,63,255,255,130,224,60,61,111,91,131,224,60,60,30,7,131,208,60,63,255,255,131,192,60,42,191,170,71,192,124,0,30,0,11,128,124,63,255,255,143,64,124,63,255,255,95,0,124,0,30,0,62,0,188,0,111,107,252,0,184,255,255,255,248,0,248,191,165,11,240,127,240,0,0,2,192,63,224,0,0,0,0,0,0,
  // 0x5316  化
  22,83,24,25,150,26,1,253,0,6,65,160,0,0,0,15,193,240,0,0,0,31,65,240,0,0,0,63,1,240,0,0,0,125,1,240,0,0,0,252,1,240,0,176,2,244,1,240,3,248,11,244,1,240,31,244,31,244,1,240,191,128,127,244,1,247,253,0,254,244,1,255,224,0,248,244,1,254,0,0,96,244,1,240,0,0,0,244,1,240,0,0,0,244,1,240,0,0,0,244,1,240,0,0,0,244,1,240,0,0,0,244,1,240,0,8,0,244,1,240,0,31,0,244,1,240,0,31,0,244,1,240,0,47,0,244,1,249,0,126,0,244,0,255,255,252,0,244,0,63,255,244,0,80,0,0,0,0,
  // 0x534a  半
  74,83,24,26,156,26,1,253,0,0,1,64,0,0,0,128,7,192,6,64,3,224,7,192,11,192,2,244,7,192,15,128,0,252,7,192,47,0,0,125,7,192,62,0,0,62,7,192,188,0,0,40,7,192,100,0,0,0,7,192,0,0,15,255,255,255,255,240,15,255,255,255,255,240,5,85,91,229,85,80,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,21,85,91,229,85,84,191,255,255,255,255,254,191,255,255,255,255,254,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,1,64,0,0,
  // 0x5354  協
  84,83,24,26,156,26,1,253,1,64,0,0,0,0,3,208,0,11,128,0,3,208,0,15,64,0,3,208,47,255,255,248,3,208,47,255,255,248,3,208,0,46,0,180,3,208,0,61,0,244,3,224,0,188,0,240,255,255,66,244,1,240,255,255,75,224,191,224,3,208,127,64,63,192,3,208,56,0,0,0,3,208,45,0,15,0,3,208,45,0,15,0,3,208,45,0,15,0,3,211,255,254,255,254,3,211,255,253,255,254,3,208,60,60,46,30,3,208,60,56,45,45,3,208,120,120,60,45,3,208,180,120,124,45,3,208,240,120,244,45,3,211,208,182,240,60,3,219,203,247,195,252,3,211,7,225,67,244,0,0,0,0,0,0,
  // 0x5361  卡
  97,83,24,26,156,26,1,253,0,0,5,64,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,255,255,192,0,0,15,255,255,192,0,0,15,213,85,64,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,21,85,95,213,85,85,191,255,255,255,255,254,191,255,255,255,255,254,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,253,0,0,0,0,15,255,244,0,0,0,15,155,255,128,0,0,15,128,127,224,0,0,15,128,2,192,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,15,128,0,0,0,0,5,64,0,0,
  // 0x5370  印
  112,83,22,25,150,26,2,253,0,7,192,0,0,0,0,127,240,85,85,80,107,255,210,255,255,240,127,248,2,255,255,240,126,64,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,127,255,242,240,1,240,127,255,242,240,1,240,125,85,82,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,124,0,2,240,1,240,127,255,242,240,2,240,127,255,242,240,255,240,125,85,82,240,191,208,124,0,2,240,41,0,40,0,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,0,80,0,0,
  // 0x5378  卸
  120,83,23,25,150,26,1,253,2,224,0,0,0,0,3,208,0,15,255,252,7,208,0,15,255,252,11,255,255,79,85,188,31,255,255,79,0,124,62,15,0,15,0,124,124,15,0,15,0,124,16,15,0,15,0,124,191,255,255,207,0,124,191,255,255,207,0,124,0,31,64,15,0,124,0,15,0,15,0,124,31,15,0,15,0,124,31,15,255,15,0,124,31,15,255,15,0,124,31,15,0,15,0,124,31,15,0,15,0,124,31,15,0,15,0,124,31,15,0,15,15,252,31,15,175,207,15,244,111,255,255,207,5,64,255,255,229,15,0,0,254,80,0,15,0,0,0,0,0,15,0,0,0,0,0,5,0,0,
  // 0x537b  卻
  123,83,23,25,150,26,1,253,0,31,128,0,0,0,0,63,240,15,255,252,0,254,252,15,255,252,3,244,127,15,85,188,15,208,31,207,0,124,127,64,7,143,0,124,61,5,1,15,0,124,0,47,192,15,0,124,0,127,240,15,0,124,0,253,252,15,0,124,3,240,127,15,0,124,15,208,31,207,0,124,127,128,11,223,0,124,254,0,3,79,0,124,59,255,254,15,0,124,7,255,254,15,0,124,7,128,46,15,0,124,7,128,46,15,15,252,7,128,46,15,15,244,7,128,46,15,5,64,7,255,254,15,0,0,7,255,254,15,0,0,7,192,46,15,0,0,7,128,21,15,0,0,0,0,0,0,0,0,
  // 0x539f  原
  159,83,24,24,144,26,1,253,11,255,255,255,255,253,11,255,255,255,255,253,11,192,0,189,0,0,11,128,0,252,0,0,11,131,255,255,255,208,11,135,255,255,255,208,11,135,192,0,3,208,11,135,192,0,3,208,11,135,255,255,255,208,11,135,255,255,255,208,15,135,192,0,3,208,15,135,192,0,3,208,15,71,255,255,255,208,15,71,255,255,255,208,15,64,0,60,0,0,15,0,160,60,9,0,31,1,244,60,47,64,47,3,224,60,11,208,62,15,192,60,2,244,61,63,64,60,0,252,188,253,0,60,0,62,248,52,31,252,0,20,32,0,15,244,0,0,0,0,0,0,0,0,
  // 0x53cd  反
  205,83,23,24,144,26,1,253,2,255,255,255,255,248,2,255,255,255,255,248,2,245,85,85,85,80,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,255,255,255,255,128,2,255,255,255,255,192,2,247,245,85,95,128,2,225,240,0,47,64,3,224,248,0,63,0,3,224,124,0,189,0,3,208,63,0,252,0,3,208,31,131,240,0,7,192,11,223,224,0,11,192,3,255,128,0,15,128,1,255,0,0,15,64,11,255,208,0,47,0,127,239,253,0,63,11,255,2,255,228,189,63,248,0,63,252,44,31,64,0,2,244,0,0,0,0,0,16,
  // 0x53d6  取
  214,83,24,24,144,26,1,253,191,255,255,192,0,0,191,255,255,192,0,0,15,128,125,191,255,252,15,128,61,191,255,252,15,128,61,25,85,188,15,128,61,60,0,188,15,255,253,61,0,248,15,255,253,46,0,244,15,128,61,31,0,240,15,128,61,15,2,240,15,128,61,15,131,224,15,255,253,11,199,208,15,255,253,3,223,192,15,128,61,2,255,128,15,128,61,1,255,0,15,128,61,0,254,0,15,150,189,0,254,0,175,255,253,3,255,64,255,255,189,11,255,208,250,64,61,47,199,244,0,0,62,255,1,254,0,0,62,248,0,127,0,0,61,160,0,12,0,0,20,0,0,0,
  // 0x53f0  台
  240,83,23,26,156,26,2,253,0,0,64,0,0,0,0,2,240,0,0,0,0,3,240,0,0,0,0,11,208,0,0,0,0,15,192,7,128,0,0,47,64,11,240,0,0,126,0,2,252,0,0,252,0,0,191,0,90,254,171,255,255,192,255,255,255,255,255,224,255,255,170,165,87,244,0,0,0,0,0,244,0,0,0,0,0,64,1,85,85,85,84,0,7,255,255,255,253,0,7,255,255,255,253,0,7,192,0,0,61,0,7,192,0,0,61,0,7,192,0,0,61,0,7,192,0,0,61,0,7,192,0,0,61,0,7,192,0,0,61,0,7,255,255,255,253,0,7,255,255,255,253,0,7,213,85,85,125,0,1,64,0,0,20,0,
  // 0x5408  合
  8,84,24,26,156,26,1,253,0,0,1,64,0,0,0,0,15,224,0,0,0,0,63,248,0,0,0,0,190,189,0,0,0,2,252,63,128,0,0,11,240,15,224,0,0,47,192,3,248,0,0,254,0,0,191,64,7,248,0,0,47,224,127,255,255,255,251,254,255,31,255,255,244,191,56,0,0,0,0,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,255,255,255,255,0,0,255,255,255,255,0,0,248,0,0,31,0,0,80,0,0,5,0,
  // 0x5426  否
  38,84,24,24,144,26,1,253,63,255,255,255,255,252,63,255,255,255,255,252,21,85,87,253,85,84,0,0,11,240,0,0,0,0,63,192,0,0,0,1,255,195,224,0,0,11,251,199,253,0,0,191,199,192,191,208,31,254,7,192,11,248,255,224,7,192,1,254,62,0,7,192,0,44,16,0,7,192,0,0,0,0,0,0,0,0,1,255,255,255,255,128,1,255,255,255,255,128,1,240,0,0,15,128,1,240,0,0,15,128,1,240,0,0,15,128,1,240,0,0,15,128,1,240,0,0,15,128,1,255,255,255,255,128,1,255,255,255,255,128,1,240,0,0,15,128,0,80,0,0,5,0,
  // 0x544a  告
  74,84,24,26,156,26,1,253,0,0,1,80,0,0,0,61,2,240,0,0,0,188,2,240,0,0,0,248,2,240,0,0,1,255,255,255,255,224,3,255,255,255,255,224,11,208,2,240,0,0,31,128,2,240,0,0,63,0,2,240,0,0,13,0,2,240,0,0,5,0,2,240,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,128,0,255,255,255,255,128,0,244,0,0,15,128,0,240,0,0,15,128,0,240,0,0,15,128,0,240,0,0,15,128,0,244,0,0,15,128,0,255,255,255,255,128,0,255,255,255,255,128,0,240,0,0,15,128,0,160,0,0,5,64,
  // 0x547d  命
  125,84,24,26,156,26,1,253,0,0,5,64,0,0,0,0,15,240,0,0,0,0,63,248,0,0,0,0,254,190,0,0,0,3,248,63,192,0,0,15,224,15,240,0,0,127,128,2,254,0,2,254,0,0,191,208,31,247,255,255,223,253,255,131,255,255,209,255,184,0,0,0,0,46,0,0,0,0,0,0,11,255,248,127,255,240,11,255,248,127,255,240,11,128,120,124,1,240,11,128,120,124,1,240,11,128,120,124,1,240,11,128,120,124,1,240,11,128,120,124,1,240,11,255,248,124,1,240,11,255,248,124,2,240,11,128,0,124,127,224,11,128,0,124,63,128,1,64,0,124,0,0,0,0,0,124,0,0,0,0,0,20,0,0,
  // 0x548c  和
  140,84,23,25,150,26,1,253,0,1,184,0,0,0,5,191,253,0,0,0,127,255,144,127,255,248,58,126,0,127,255,248,0,62,0,125,85,248,0,62,0,124,0,248,0,62,0,124,0,248,0,62,0,124,0,248,191,255,255,124,0,248,191,255,255,124,0,248,0,190,0,124,0,248,0,255,64,124,0,248,2,255,208,124,0,248,3,255,240,124,0,248,7,254,188,124,0,248,15,126,62,124,0,248,47,62,28,124,0,248,125,62,0,124,0,248,248,62,0,125,85,248,176,62,0,127,255,248,16,62,0,127,255,248,0,62,0,124,0,248,0,62,0,124,0,248,0,62,0,0,0,0,0,20,0,0,0,0,
  // 0x555f  啟
  95,85,24,25,150,26,1,253,0,61,0,0,244,0,0,31,0,0,240,0,0,15,64,0,240,0,15,255,255,1,240,0,15,255,255,2,224,0,15,0,15,3,255,255,15,0,15,7,255,255,15,0,15,11,192,184,15,0,15,15,192,244,15,255,255,47,192,244,15,255,255,127,208,240,15,0,0,62,225,240,31,0,0,4,242,224,31,0,0,0,243,208,31,255,255,128,191,192,30,255,255,128,127,128,46,244,11,128,63,64,61,244,11,128,47,0,60,244,11,128,63,64,60,244,11,128,255,192,188,255,255,130,251,224,244,255,255,139,225,248,112,244,11,175,192,190,0,176,11,174,0,46,0,0,0,4,0,4,
  // 0x55ae  單
  174,85,24,24,144,26,1,254,6,170,168,42,170,144,11,255,252,63,255,240,11,64,60,60,1,240,11,64,60,60,1,240,11,234,188,62,170,240,11,255,252,63,255,240,0,0,0,0,0,0,3,255,255,255,255,192,3,255,255,255,255,192,3,208,7,192,7,192,3,208,7,192,7,192,3,255,255,255,255,192,3,255,255,255,255,192,3,208,7,192,7,192,3,208,7,192,7,192,3,255,255,255,255,192,3,255,255,255,255,192,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,
  // 0x5634  嘴
  52,86,23,26,156,26,2,253,0,0,1,0,64,0,0,0,11,66,208,0,0,1,203,66,208,128,255,242,203,234,235,224,255,242,203,254,255,64,224,242,203,66,244,0,224,242,203,66,208,36,224,242,203,174,208,60,224,251,255,253,255,248,224,251,255,192,255,240,224,241,15,234,128,0,224,240,47,255,240,0,224,240,188,3,192,0,224,242,254,175,234,144,224,255,255,255,255,208,255,247,184,15,2,208,255,240,125,111,87,208,240,0,191,255,255,208,224,0,184,15,2,208,224,0,184,15,2,208,0,0,255,255,255,208,0,1,250,170,171,208,0,7,224,0,2,208,0,31,192,0,175,208,0,10,0,0,191,128,0,0,0,0,0,0,
  // 0x5668  器
  104,86,24,24,144,26,1,253,15,255,248,47,255,240,15,255,248,47,255,240,15,64,184,46,1,240,15,64,184,46,1,240,15,64,184,46,1,240,15,255,248,47,255,240,15,255,254,47,255,240,0,0,15,128,0,0,0,0,63,0,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,15,240,15,224,0,0,127,192,3,248,0,2,255,0,0,255,128,111,252,0,0,63,253,255,255,252,63,255,255,43,255,252,63,255,232,7,128,124,60,3,208,7,128,124,60,3,208,7,128,124,60,3,208,7,255,252,63,255,208,7,255,252,63,255,208,7,128,124,60,3,208,0,0,0,0,0,0,
  // 0x5674  噴
  116,86,23,26,156,26,2,253,0,0,0,5,0,0,0,0,0,15,0,0,0,0,170,191,170,160,255,248,255,255,255,240,255,248,0,15,0,0,255,248,15,15,31,0,240,120,15,0,31,0,240,123,255,255,255,252,240,122,175,170,191,168,240,120,15,0,31,0,240,120,26,85,90,64,240,120,127,255,255,192,240,120,120,0,3,192,240,120,125,85,87,192,240,120,127,255,255,192,240,184,120,0,3,192,255,248,125,85,87,192,255,248,127,255,255,192,240,0,120,0,3,192,240,0,125,85,87,192,0,0,127,255,255,192,0,0,11,128,120,0,0,0,191,128,127,128,0,31,253,0,11,244,0,15,208,0,0,244,0,0,0,0,0,0,
  // 0x56de  回
  222,86,22,25,150,26,2,253,85,85,85,85,85,80,255,255,255,255,255,240,255,255,255,255,255,240,248,0,0,0,2,240,248,0,0,0,2,240,248,0,0,0,2,240,248,0,0,0,2,240,248,15,255,255,2,240,248,15,255,255,2,240,248,15,0,31,2,240,248,15,0,31,2,240,248,15,0,31,2,240,248,15,0,31,2,240,248,15,0,31,2,240,248,15,0,31,2,240,248,15,255,255,2,240,248,15,255,255,2,240,248,0,0,0,2,240,248,0,0,0,2,240,248,0,0,0,2,240,248,0,0,0,3,240,255,255,255,255,255,240,255,255,255,255,255,240,248,0,0,0,2,240,84,0,0,0,1,80,
  // 0x56e0  因
  224,86,22,24,144,26,2,253,255,255,255,255,255,240,255,255,255,255,255,240,249,85,85,85,86,240,248,0,15,0,2,240,248,0,31,0,2,240,248,0,31,0,2,240,248,0,31,0,2,240,248,255,255,255,242,240,248,255,255,255,242,240,248,0,63,128,2,240,248,0,63,192,2,240,248,0,127,192,2,240,248,0,190,224,2,240,248,1,244,244,2,240,248,3,240,188,2,240,248,15,208,63,66,240,248,191,64,31,242,240,248,253,0,7,242,240,248,96,0,0,130,240,248,0,0,0,2,240,255,255,255,255,255,240,255,255,255,255,255,240,249,85,85,85,86,240,80,0,0,0,1,80,
  // 0x56fa  固
  250,86,22,24,144,26,2,253,191,255,255,255,255,240,191,255,255,255,255,240,188,0,0,0,3,240,184,0,10,0,2,240,184,0,15,0,2,240,184,0,15,0,2,240,184,255,255,255,242,240,184,255,255,255,242,240,184,0,15,0,2,240,184,0,15,0,2,240,184,0,15,0,2,240,184,31,255,255,130,240,184,31,255,255,130,240,184,30,0,11,130,240,184,30,0,11,130,240,184,30,0,11,130,240,184,31,255,255,130,240,184,31,255,255,130,240,184,0,0,0,2,240,184,0,0,0,2,240,191,255,255,255,255,240,191,255,255,255,255,240,189,85,85,85,87,240,84,0,0,0,1,80,
  // 0x5716  圖
  22,87,22,24,144,26,2,253,255,255,255,255,255,240,255,255,255,255,255,240,244,5,85,85,1,240,244,15,255,255,1,240,244,15,0,15,1,240,244,15,85,95,1,240,244,15,255,255,1,240,244,0,15,0,1,240,246,255,255,255,249,240,244,85,85,85,81,240,244,21,85,85,65,240,244,63,255,255,193,240,244,60,0,3,193,240,244,60,255,227,193,240,244,60,224,227,193,240,244,60,255,227,193,240,244,60,0,3,193,240,244,61,85,87,193,240,244,63,255,255,193,240,244,0,0,0,1,240,255,255,255,255,255,240,255,255,255,255,255,240,244,0,0,0,1,240,0,0,0,0,0,0,
  // 0x5728  在
  40,87,24,24,144,26,1,254,0,0,125,0,0,0,0,0,188,0,0,0,0,0,248,0,0,0,21,85,249,85,85,84,127,255,255,255,255,253,127,255,255,255,255,253,0,11,192,0,0,0,0,31,128,6,128,0,0,63,0,11,192,0,0,189,0,11,192,0,1,252,0,11,192,0,3,244,0,11,192,0,15,244,63,255,255,244,127,244,63,255,255,244,254,244,0,11,192,0,116,244,0,11,192,0,16,244,0,11,192,0,0,244,0,11,192,0,0,244,0,11,192,0,0,244,0,11,192,0,0,244,0,11,192,0,0,244,0,11,192,0,0,244,255,255,255,253,0,244,255,255,255,253,
  // 0x578b  型
  139,87,24,24,144,26,1,254,0,0,0,0,0,244,31,255,255,210,144,244,31,255,255,211,208,244,0,240,60,3,208,244,0,240,60,3,208,244,0,240,60,3,208,244,127,255,255,243,208,244,127,255,255,243,208,244,2,240,125,3,208,244,2,224,60,3,208,244,3,208,60,0,0,244,15,192,60,0,0,240,63,64,60,0,127,240,61,0,62,64,63,208,4,0,3,208,0,0,0,0,3,208,0,0,3,255,255,255,255,192,3,255,255,255,255,192,0,0,7,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,0,0,0,0,
  // 0x57f7  執
  247,87,25,26,182,26,1,253,0,20,0,1,64,0,0,0,60,0,7,192,0,0,0,60,0,7,192,0,0,63,255,248,7,192,0,0,63,255,248,7,192,0,0,0,60,0,11,192,0,0,0,60,2,255,255,224,0,0,62,171,255,255,224,0,255,255,254,7,194,224,0,255,255,254,7,194,224,0,15,0,240,7,194,224,0,15,0,240,11,194,224,0,11,129,225,219,130,224,0,7,130,211,255,130,224,0,127,255,253,255,130,224,0,127,255,253,31,210,224,0,0,60,0,15,246,224,0,0,60,0,47,191,224,0,63,255,252,61,41,224,0,63,255,252,124,1,243,0,0,60,0,248,1,243,64,0,60,3,240,0,243,64,0,60,11,208,0,251,0,0,60,47,128,0,191,0,0,60,30,0,0,62,0,0,20,0,0,0,4,0,
  // 0x584a  塊
  74,88,24,26,156,26,1,253,0,0,0,5,64,0,2,224,0,15,192,0,2,224,0,31,64,0,2,224,63,255,255,252,2,224,63,255,255,252,2,224,60,11,192,188,23,229,124,7,128,188,191,255,124,7,128,188,191,255,127,255,255,252,2,224,63,255,255,252,2,224,60,7,128,188,2,224,60,7,128,188,2,224,63,255,255,252,2,224,63,255,255,252,2,225,3,211,210,64,2,255,67,211,211,128,2,255,131,195,215,104,47,254,3,195,219,44,255,224,11,195,223,189,189,0,15,131,239,255,0,0,31,67,212,4,0,0,63,3,208,13,0,2,253,3,208,31,0,31,244,3,255,254,0,11,192,0,255,252,0,0,0,0,0,0,
  // 0x586b  填
  107,88,24,26,156,26,1,253,0,0,0,1,0,0,2,208,0,7,192,0,2,208,0,7,192,0,2,208,255,255,255,254,2,208,255,255,255,254,2,208,0,7,192,0,2,208,10,171,234,144,191,255,15,255,255,224,191,255,15,0,2,224,23,229,15,149,87,224,2,208,15,255,255,224,2,208,15,0,2,224,2,208,15,149,87,224,2,208,15,255,255,224,2,208,15,0,2,224,2,209,15,170,171,224,2,255,79,255,255,224,7,255,64,0,0,0,191,251,255,255,255,255,255,66,255,255,255,255,116,0,0,64,4,0,0,0,3,240,47,64,0,0,47,208,15,224,0,3,254,0,1,253,0,2,244,0,0,62,0,0,0,0,0,0,
  // 0x588a  墊
  138,88,24,25,150,26,1,254,0,20,0,0,0,0,0,60,0,3,192,0,26,190,168,3,192,0,63,255,252,3,192,0,0,60,0,255,255,208,170,189,85,255,255,208,255,255,255,3,195,208,15,0,240,3,194,208,11,66,208,251,194,208,111,235,234,191,130,208,191,255,255,31,226,208,0,60,0,31,250,208,42,190,168,62,118,227,63,255,252,252,1,231,0,60,3,240,0,251,0,60,3,208,0,255,0,60,3,192,0,61,0,0,3,192,0,0,3,255,255,255,255,192,3,255,255,255,255,192,0,0,7,192,0,0,0,0,3,192,0,0,0,0,7,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x5916  外
  22,89,24,26,156,26,1,253,0,0,0,0,20,0,0,31,0,0,188,0,0,47,0,0,188,0,0,62,0,0,188,0,0,125,85,0,188,0,0,255,255,208,188,0,0,255,255,208,188,0,2,240,7,244,188,0,3,208,11,252,188,0,15,192,15,190,188,0,47,128,15,95,252,0,127,240,31,11,252,0,254,253,63,3,252,0,52,127,189,0,253,0,0,15,252,0,191,128,0,2,248,0,191,224,0,2,240,0,191,254,0,7,224,0,188,191,0,15,192,0,188,29,0,63,64,0,188,0,0,253,0,0,188,0,3,248,0,0,188,0,31,224,0,0,188,0,127,128,0,0,188,0,29,0,0,0,188,0,0,0,0,0,20,0,
  // 0x591a  多
  26,89,22,25,150,26,2,253,0,0,127,0,0,0,0,1,252,0,0,0,0,7,255,255,240,0,0,63,255,255,240,0,2,254,0,7,224,0,127,255,0,31,128,0,126,95,224,190,0,0,16,2,255,248,0,0,0,0,127,208,0,0,0,6,254,127,0,0,0,191,229,252,0,0,191,254,11,255,255,224,255,144,127,255,255,240,100,2,253,0,7,208,0,127,248,0,15,192,3,255,255,0,63,0,2,228,47,208,253,0,0,0,7,251,244,0,0,0,0,255,208,0,0,0,6,255,0,0,0,0,127,248,0,0,1,111,255,128,0,0,15,255,244,0,0,0,11,249,0,0,0,0,0,0,0,0,0,0,
  // 0x5920  夠
  32,89,23,26,156,26,1,253,0,16,0,0,0,0,0,124,0,15,64,0,0,244,0,15,0,0,2,255,248,31,0,0,11,255,248,62,0,0,47,0,240,127,255,252,189,2,224,255,255,252,55,215,194,240,0,60,1,255,71,208,0,60,0,190,11,191,253,60,7,253,2,63,253,60,47,239,0,60,45,60,127,126,0,60,45,60,56,191,254,60,45,60,1,255,255,60,45,60,11,208,61,60,45,60,63,64,124,60,45,60,189,160,248,63,253,124,32,254,240,63,253,124,0,63,192,60,0,124,0,47,64,60,0,120,0,254,0,0,0,184,11,244,0,0,1,244,191,192,0,0,127,240,125,0,0,0,63,208,0,0,0,0,0,0,
  // 0x5927  大
  39,89,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,85,111,249,85,84,0,0,31,244,0,0,0,0,47,248,0,0,0,0,63,188,0,0,0,0,125,62,0,0,0,0,252,63,0,0,0,1,248,31,128,0,0,3,240,15,208,0,0,11,208,3,240,0,0,47,192,2,252,0,0,191,0,0,255,0,3,252,0,0,63,208,47,240,0,0,15,253,127,192,0,0,2,253,45,0,0,0,0,120,0,0,0,0,0,0,
  // 0x5929  天
  41,89,24,24,144,26,1,253,21,85,85,85,85,84,127,255,255,255,255,253,127,255,255,255,255,253,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,11,192,0,0,47,255,255,255,255,248,47,255,255,255,255,248,21,85,95,245,85,84,0,0,15,240,0,0,0,0,31,248,0,0,0,0,63,188,0,0,0,0,126,63,0,0,0,0,252,47,128,0,0,3,244,15,208,0,0,31,224,3,248,0,0,255,128,1,255,64,27,253,0,0,127,248,191,224,0,0,11,254,62,0,0,0,1,188,0,0,0,0,0,0,
  // 0x5931  失
  49,89,24,26,156,26,1,253,0,0,1,64,0,0,0,120,7,192,0,0,0,188,7,192,0,0,0,248,7,192,0,0,1,244,7,192,0,0,3,255,255,255,255,208,3,255,255,255,255,208,15,213,91,229,85,64,31,128,7,192,0,0,63,0,7,192,0,0,45,0,7,192,0,0,4,0,11,192,0,0,21,85,95,213,85,84,191,255,255,255,255,254,191,255,255,255,255,254,0,0,31,244,0,0,0,0,63,252,0,0,0,0,189,126,0,0,0,1,252,47,64,0,0,7,244,15,208,0,0,31,208,7,248,0,1,255,128,1,255,64,31,253,0,0,127,248,191,224,0,0,11,255,62,0,0,0,0,188,0,0,0,0,0,0,
  // 0x59cb  始
  203,89,24,26,156,26,1,253,0,64,0,1,0,0,1,240,0,7,208,0,1,240,0,11,192,0,2,224,0,15,128,0,3,208,0,15,64,0,3,208,0,47,7,192,255,255,240,62,3,208,255,255,240,60,2,240,15,130,240,188,0,248,15,66,229,254,255,253,15,3,239,255,255,255,31,3,223,250,149,95,46,3,208,0,0,13,46,7,192,0,0,0,61,11,192,0,0,0,62,15,129,255,255,252,127,223,65,255,255,252,123,255,1,240,0,188,0,191,1,240,0,188,0,191,193,240,0,188,1,251,241,240,0,188,3,240,241,240,0,188,31,192,17,255,255,252,127,0,1,255,255,252,60,0,1,240,0,188,0,0,0,80,0,0,
  // 0x5a92  媒
  146,90,24,25,150,26,1,253,2,224,2,224,3,208,3,208,2,224,3,208,3,208,2,224,3,208,3,192,63,255,255,254,7,192,63,255,255,254,11,193,2,224,3,208,255,255,194,224,3,208,255,255,194,255,255,208,15,7,194,255,255,208,31,7,130,224,3,208,46,11,130,255,255,208,61,15,66,255,255,208,60,15,64,3,208,0,60,31,0,3,208,0,127,47,0,3,208,0,191,254,63,255,255,255,59,253,63,255,255,255,0,252,0,47,252,0,0,255,0,127,255,0,3,255,194,247,223,192,7,211,203,211,211,244,47,129,191,131,208,254,191,0,189,3,208,62,56,0,32,3,208,4,0,0,0,1,64,0,
  // 0x5b50  子
  80,91,24,24,144,26,1,253,1,85,85,85,85,0,3,255,255,255,255,208,3,255,255,255,255,192,0,0,0,0,255,0,0,0,0,3,248,0,0,0,0,47,224,0,0,0,2,255,0,0,0,0,3,248,0,0,0,0,3,208,0,0,0,0,3,208,0,0,85,85,91,229,85,85,191,255,255,255,255,255,191,255,255,255,255,255,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,7,208,0,0,0,15,255,192,0,0,0,11,255,128,0,0,0,1,84,0,0,0,
  // 0x5b58  存
  88,91,24,26,156,26,1,253,0,0,16,0,0,0,0,0,124,0,0,0,0,0,252,0,0,0,0,0,248,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,91,229,85,85,84,0,15,192,0,0,0,0,31,64,0,0,0,0,63,15,255,255,224,0,189,15,255,255,240,1,248,0,0,31,192,3,240,0,0,127,0,15,240,0,2,252,0,63,240,0,3,224,0,255,240,0,3,208,0,185,240,255,255,255,255,16,240,255,255,255,255,0,240,85,87,213,84,0,240,0,3,208,0,0,240,0,3,208,0,0,240,0,3,208,0,0,240,0,3,208,0,0,240,3,255,192,0,0,240,3,255,128,0,0,0,0,64,0,0,
  // 0x5b89  安
  137,91,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,63,0,0,0,0,252,62,0,4,0,0,188,62,0,63,0,0,188,62,0,125,0,0,188,0,0,188,0,0,0,21,85,253,85,85,84,127,255,255,255,255,253,127,255,255,255,255,253,0,11,192,0,248,0,0,15,128,1,244,0,0,63,0,3,240,0,0,126,0,7,224,0,0,255,208,15,192,0,1,255,254,127,64,0,0,160,191,254,0,0,0,0,15,255,128,0,0,0,191,239,253,0,0,111,254,2,255,192,47,255,224,0,47,240,15,249,0,0,3,208,0,0,0,0,0,0,
  // 0x5b8c  完
  140,91,24,25,150,26,1,253,0,0,7,192,0,0,0,0,7,192,0,0,21,85,91,213,85,84,63,255,255,255,255,252,63,255,255,255,255,252,62,0,0,0,0,188,62,0,0,0,0,188,62,63,255,255,252,188,0,63,255,255,252,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,87,229,111,85,84,0,3,208,31,0,0,0,7,192,31,0,0,0,15,192,31,0,0,0,15,128,31,0,20,0,63,0,31,0,30,0,254,0,31,0,46,11,252,0,31,64,125,191,224,0,15,255,252,62,0,0,7,255,244,16,0,0,0,0,0,
  // 0x5b9a  定
  154,91,24,25,150,26,1,253,0,0,7,192,0,0,0,0,7,192,0,0,5,85,91,213,85,80,63,255,255,255,255,252,63,255,255,255,255,252,62,0,0,0,0,188,62,0,0,0,0,188,62,21,85,85,84,188,61,127,255,255,253,188,0,127,255,255,253,0,0,0,7,192,0,0,0,0,7,192,0,0,0,124,7,192,0,0,0,188,7,192,0,0,0,248,7,255,255,128,0,248,7,255,255,128,1,252,7,213,85,0,2,253,7,192,0,0,3,255,7,192,0,0,11,223,199,192,0,0,15,135,251,192,0,0,63,65,255,233,85,85,254,0,47,255,255,253,120,0,1,191,255,252,0,0,0,0,0,0,
  // 0x5ba2  客
  162,91,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,62,0,100,0,0,188,61,0,252,0,0,188,61,3,255,255,244,188,0,31,255,255,252,0,0,191,192,3,240,0,11,255,240,15,208,0,15,209,253,127,64,0,6,0,127,252,0,0,0,0,47,253,0,0,0,7,255,255,228,0,1,191,244,31,255,233,191,255,64,0,191,253,127,255,255,255,254,252,36,63,255,255,253,0,0,60,0,0,61,0,0,60,0,0,61,0,0,60,0,0,61,0,0,63,255,255,253,0,0,63,255,255,253,0,0,60,0,0,61,0,0,0,0,0,0,0,
  // 0x5bb9  容
  185,91,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,62,0,0,0,0,188,62,2,128,2,64,188,62,11,208,11,224,188,0,63,64,2,253,0,1,253,11,208,127,128,15,244,31,244,15,224,15,192,127,253,2,224,2,1,252,63,128,64,0,11,240,15,240,0,0,63,192,2,253,0,1,254,0,0,127,208,31,255,255,255,255,253,127,255,255,255,254,254,61,61,0,0,124,44,0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,0,60,0,0,63,255,255,252,0,0,63,255,255,252,0,0,61,0,0,124,0,0,0,0,0,0,0,
  // 0x5c0d  對
  13,92,24,26,156,26,1,253,0,80,64,0,0,0,32,241,225,128,3,208,120,241,227,208,3,208,60,241,231,192,3,208,30,241,239,64,3,208,8,241,234,0,3,208,255,255,255,208,3,208,255,255,255,250,171,208,7,64,61,63,255,255,7,192,60,63,255,255,3,192,184,0,3,208,3,192,180,0,3,208,63,255,255,79,3,208,63,255,255,75,131,208,0,31,0,7,195,208,0,31,0,3,211,208,0,31,0,2,227,208,31,255,255,1,243,208,31,255,255,0,211,208,0,31,0,0,3,208,0,31,0,64,3,208,1,111,255,192,3,208,191,255,255,128,3,208,191,165,0,2,255,192,0,0,0,1,255,128,0,0,0,0,80,0,
  // 0x5c0f  小
  15,92,24,25,150,26,1,253,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,144,3,208,10,0,0,248,3,208,63,0,1,244,3,208,31,128,2,240,3,208,15,192,3,224,3,208,7,224,7,208,3,208,3,240,11,192,3,208,1,244,15,192,3,208,0,252,31,64,3,208,0,188,63,0,3,208,0,126,190,0,3,208,0,63,188,0,3,208,0,47,20,0,3,208,0,29,0,0,3,208,0,0,0,0,3,208,0,0,0,0,7,208,0,0,0,15,255,208,0,0,0,11,255,128,0,0,0,2,148,0,0,0,
  // 0x5c31  就
  49,92,24,26,156,26,1,253,0,5,0,0,80,0,0,47,0,0,244,64,0,47,0,0,247,224,0,47,0,0,244,244,191,255,255,128,244,124,191,255,255,128,244,61,0,0,0,0,244,20,0,0,0,21,249,84,31,255,254,127,255,255,31,255,254,127,255,255,31,0,46,0,240,0,31,0,46,1,254,0,31,0,46,1,254,0,31,255,254,2,254,0,31,255,254,3,254,0,0,31,0,3,254,0,9,31,28,7,238,0,31,31,61,11,222,0,47,31,31,15,158,0,61,31,15,47,30,10,124,31,15,127,30,11,248,31,0,188,30,11,176,31,1,248,31,95,3,254,7,240,31,255,2,252,3,192,11,252,0,0,0,0,0,0,
  // 0x5de5  工
  229,93,24,21,126,26,1,255,5,85,85,85,85,80,15,255,255,255,255,244,15,255,255,255,255,244,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,0,0,7,208,0,0,191,255,255,255,255,254,191,255,255,255,255,254,85,85,85,85,85,85,
  // 0x5dee  差
  238,93,24,25,150,26,1,253,0,47,0,0,252,0,0,31,64,1,244,0,0,11,192,3,224,0,31,255,255,255,255,244,31,255,255,255,255,244,0,0,7,208,0,0,0,0,7,192,0,0,3,255,255,255,255,192,3,255,255,255,255,192,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,47,0,0,0,0,0,62,0,0,0,0,0,62,255,255,255,192,0,188,255,255,255,192,0,252,0,61,0,0,1,244,0,61,0,0,3,240,0,61,0,0,11,208,0,61,0,0,47,128,0,61,0,0,191,31,255,255,255,252,124,31,255,255,255,252,0,0,0,0,0,0,
  // 0x5df2  已
  242,93,23,23,138,26,2,254,127,255,255,255,253,0,127,255,255,255,253,0,21,85,85,85,125,0,0,0,0,0,61,0,0,0,0,0,61,0,31,0,0,0,61,0,31,0,0,0,61,0,31,0,0,0,61,0,31,0,0,0,61,0,31,255,255,255,253,0,31,255,255,255,253,0,31,149,85,85,125,0,31,0,0,0,41,0,31,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,0,144,31,0,0,0,0,248,31,0,0,0,0,248,15,64,0,0,1,244,15,128,0,0,7,240,15,255,255,255,255,224,2,255,255,255,255,128,0,21,85,85,84,0,
  // 0x5e73  平
  115,94,24,24,144,26,1,253,5,85,85,85,85,80,15,255,255,255,255,240,15,255,255,255,255,240,0,0,7,192,0,0,0,160,7,192,14,64,0,244,7,192,31,64,0,252,7,192,47,0,0,124,7,192,61,0,0,62,7,192,188,0,0,46,7,192,244,0,0,0,7,192,16,0,85,85,91,229,85,85,191,255,255,255,255,254,191,255,255,255,255,254,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,1,64,0,0,
  // 0x5e8a  床
  138,94,24,26,156,26,1,253,0,0,0,80,0,0,0,0,1,240,0,0,0,0,1,240,0,0,0,0,1,240,0,0,15,255,255,255,255,254,15,255,255,255,255,254,15,149,85,85,85,84,15,128,0,61,0,0,15,128,0,61,0,0,15,128,0,61,0,0,15,133,85,126,85,84,15,159,255,255,255,254,15,159,255,255,255,254,15,64,1,255,128,0,15,64,3,255,208,0,15,64,7,255,240,0,15,0,15,190,252,0,31,0,63,61,62,0,31,0,252,61,31,128,47,3,244,61,11,240,62,31,224,61,2,253,61,63,128,61,0,191,188,45,0,61,0,44,248,0,0,61,0,0,112,0,0,61,0,0,0,0,0,20,0,0,
  // 0x5ea6  度
  166,94,24,26,156,26,1,253,0,0,0,80,0,0,0,0,1,240,0,0,0,0,1,240,0,0,15,255,255,255,255,253,15,255,255,255,255,253,15,128,20,0,20,0,15,64,61,0,61,0,15,64,61,0,61,0,15,127,255,255,255,253,15,127,255,255,255,253,15,64,61,0,61,0,15,64,61,0,61,0,15,64,63,255,253,0,15,64,63,255,253,0,15,64,0,0,0,0,15,0,0,0,0,0,15,31,255,255,255,208,31,31,255,255,255,192,31,0,124,0,31,128,46,0,47,64,127,0,61,0,11,231,248,0,61,0,2,255,208,0,188,0,111,255,249,0,248,127,255,230,255,254,112,63,228,0,27,252,0,4,0,0,0,20,
  // 0x5ee2  廢
  226,94,24,25,150,26,1,253,0,0,1,240,0,0,0,0,2,240,0,0,15,255,255,255,255,254,15,255,255,255,255,254,15,0,0,1,0,0,15,15,255,199,139,64,15,10,175,131,254,0,15,8,15,1,244,56,15,31,190,0,190,244,15,3,248,0,47,192,15,31,250,10,175,249,15,255,255,15,255,191,15,180,15,30,14,24,31,0,15,29,14,56,31,15,255,124,15,244,30,31,170,180,6,144,46,45,0,42,170,128,45,62,170,127,255,208,61,63,255,14,7,192,60,16,15,15,79,64,124,0,30,3,253,0,248,0,46,7,254,0,244,10,189,191,239,252,48,15,248,184,1,188,0,0,0,0,0,0,
  // 0x5efa  建
  250,94,24,25,150,26,1,253,0,0,0,15,64,0,255,252,0,15,64,0,255,248,63,255,255,240,1,240,63,255,255,240,2,240,0,15,65,240,3,210,255,255,255,255,7,195,255,255,255,255,15,128,0,15,65,240,31,64,0,15,65,240,63,255,63,255,255,240,127,254,63,255,255,240,104,46,0,15,64,0,0,61,127,255,255,240,60,61,127,255,255,240,60,124,0,15,64,0,46,188,0,15,64,0,15,249,255,255,255,253,11,245,255,255,255,253,3,240,0,15,64,0,3,252,0,15,64,0,11,255,128,10,64,0,31,159,254,85,85,85,127,2,255,255,255,254,188,0,26,255,255,253,16,0,0,0,0,0,
  // 0x5f15  引
  21,95,20,25,125,26,2,253,0,0,0,0,31,127,255,252,0,31,127,255,252,0,31,0,0,60,0,31,0,0,60,0,31,0,0,60,0,31,0,0,124,0,31,63,255,252,0,31,63,255,252,0,31,61,0,0,0,31,60,0,0,0,31,124,0,0,0,31,188,0,0,0,31,191,255,252,0,31,255,255,252,0,31,244,0,124,0,31,0,0,124,0,31,0,0,188,0,31,0,0,188,0,31,0,0,248,0,31,0,0,244,0,31,0,2,240,0,31,11,255,240,0,31,3,255,208,0,31,1,85,0,0,5,
  // 0x5f85  待
  133,95,24,25,150,26,1,253,0,61,0,7,192,0,0,252,0,7,192,0,2,244,0,7,192,0,15,208,63,255,255,248,63,128,63,255,255,248,189,4,0,11,192,0,48,47,0,7,192,0,0,125,0,7,192,0,0,249,255,255,255,255,3,241,255,255,255,255,15,240,0,0,15,128,63,240,0,0,15,64,255,240,0,0,15,64,249,240,255,255,255,255,97,240,255,255,255,255,1,240,1,0,15,128,1,240,11,0,15,64,1,240,15,192,15,64,1,240,7,224,15,64,1,240,2,240,15,64,1,240,0,244,15,64,1,240,0,64,15,64,1,240,0,11,255,64,1,240,0,3,254,0,0,80,0,1,80,0,
  // 0x5f8c  後
  140,95,24,26,156,26,1,253,0,16,0,0,0,0,0,124,0,61,0,0,1,244,0,188,4,0,7,224,18,240,31,64,31,192,255,208,63,0,191,0,255,64,252,0,184,41,47,195,240,0,16,61,11,255,194,128,0,252,2,255,7,208,2,240,0,248,2,240,11,240,2,255,255,252,47,227,255,255,255,254,191,227,255,253,0,47,250,224,0,184,0,8,162,224,3,255,255,192,2,224,15,255,255,192,2,224,127,192,15,128,2,227,255,224,47,0,2,226,225,248,189,0,2,224,64,127,248,0,2,224,0,47,224,0,2,224,1,255,253,0,2,224,111,249,255,228,2,227,255,192,31,255,2,226,248,0,1,189,0,80,0,0,0,4,
  // 0x5f91  徑
  145,95,24,24,144,26,1,254,0,124,0,0,0,0,0,248,191,255,255,254,3,224,191,255,255,254,31,192,0,0,0,0,127,0,11,67,144,224,252,24,15,7,193,240,32,61,46,15,67,208,0,188,60,47,11,128,1,240,248,60,31,0,7,240,184,61,15,64,31,224,61,31,7,192,127,224,31,11,194,240,254,224,15,131,208,248,178,224,7,129,224,120,2,224,0,0,0,0,2,224,127,255,255,248,2,224,127,255,255,248,2,224,0,11,192,0,2,224,0,11,192,0,2,224,0,11,192,0,2,224,0,11,192,0,2,224,0,11,192,0,2,227,255,255,255,255,2,227,255,255,255,255,
  // 0x5f9e  從
  158,95,24,25,150,26,1,253,0,124,2,240,11,128,0,248,3,224,15,64,3,240,3,208,15,64,15,192,7,192,31,0,127,0,11,208,47,0,252,20,15,244,63,128,112,62,47,189,191,224,0,188,125,45,249,248,1,244,252,7,240,126,3,242,240,11,208,47,15,224,208,3,128,8,63,224,0,3,192,0,255,224,5,3,192,0,250,224,31,3,192,0,98,224,31,3,192,0,2,224,31,3,255,248,2,224,47,3,255,248,2,224,63,3,192,0,2,224,63,131,192,0,2,224,191,195,192,0,2,224,246,247,192,0,2,227,240,255,208,0,2,235,208,47,255,254,2,227,128,2,255,253,0,80,0,0,0,0,
  // 0x5fa9  復
  169,95,24,26,156,26,1,253,0,16,1,0,0,0,0,188,7,208,0,0,1,244,15,192,0,0,7,224,15,255,255,254,31,192,63,255,255,254,127,0,125,0,0,0,252,20,252,0,0,0,48,63,255,255,255,240,0,189,239,170,170,240,2,244,15,64,1,240,7,240,15,255,255,240,31,224,15,170,170,240,127,224,15,64,1,240,254,224,15,255,255,240,178,224,6,254,170,160,2,224,0,248,0,0,2,224,3,250,170,144,2,224,15,255,255,224,2,224,127,224,11,192,2,225,253,248,47,64,2,224,224,127,253,0,2,224,0,47,248,0,2,224,6,255,255,144,2,226,255,248,111,255,2,225,254,64,2,253,0,80,64,0,0,0,
  // 0x5fae  微
  174,95,24,26,156,26,1,253,0,0,4,0,0,0,1,240,14,0,61,0,3,224,14,0,60,0,15,199,78,44,60,0,63,7,78,44,124,0,253,7,78,44,184,0,244,151,78,44,255,255,16,251,78,44,255,255,3,247,255,254,240,124,7,215,255,255,240,120,15,192,0,7,244,184,63,192,0,11,244,180,255,203,255,255,120,240,251,203,255,253,60,240,163,192,241,240,62,240,3,192,241,224,47,208,3,192,241,224,31,192,3,193,225,224,15,192,3,193,225,225,15,128,3,194,209,255,31,192,3,195,195,254,63,224,3,203,195,208,253,244,3,207,64,3,240,189,3,206,0,15,208,63,3,192,0,7,0,13,1,64,0,0,0,0,
  // 0x5fc3  心
  195,95,24,24,144,26,1,254,0,0,248,0,0,0,0,2,255,128,0,0,0,0,127,248,0,0,0,0,7,255,64,0,0,0,0,127,192,0,0,0,0,11,64,0,0,0,0,0,0,0,0,3,208,0,0,0,0,3,208,0,2,0,6,67,208,0,31,64,15,131,208,0,15,192,15,131,208,0,7,224,15,67,208,0,3,240,31,3,208,0,0,248,31,3,208,0,0,188,63,3,208,0,0,126,61,3,208,0,16,63,188,3,208,0,60,47,252,3,208,0,60,30,112,3,208,0,60,0,0,3,208,0,124,0,0,3,224,1,252,0,0,2,255,255,244,0,0,0,191,255,208,0,
  // 0x6027  性
  39,96,24,26,156,26,1,253,1,80,0,1,64,0,2,224,0,3,208,0,2,224,7,195,208,0,2,224,11,195,208,0,2,224,15,131,208,0,18,254,15,67,208,0,58,255,31,255,255,252,58,235,111,255,255,252,122,227,254,87,229,84,182,227,252,3,208,0,178,224,252,3,208,0,242,224,180,3,208,0,242,224,16,3,208,0,2,224,0,7,224,0,2,224,31,255,255,244,2,224,31,255,255,244,2,224,0,3,208,0,2,224,0,3,208,0,2,224,0,3,208,0,2,224,0,3,208,0,2,224,0,3,208,0,2,224,0,3,208,0,2,224,255,255,255,254,2,224,255,255,255,254,2,224,85,85,85,84,0,64,0,0,0,0,
  // 0x6062  恢
  98,96,24,25,150,26,1,253,2,224,46,0,0,0,2,224,46,0,0,0,2,224,46,0,0,0,2,225,255,255,255,255,2,234,255,255,255,255,54,253,46,0,16,0,58,239,46,0,184,0,54,235,46,0,184,0,118,231,110,0,184,4,114,227,110,52,184,46,178,224,46,116,184,60,226,224,45,116,184,60,66,224,45,176,184,180,2,224,61,240,184,240,2,224,61,224,252,160,2,224,60,0,252,0,2,224,60,2,253,0,2,224,184,3,223,0,2,224,244,7,207,64,2,224,240,15,71,192,2,226,240,62,3,240,2,227,225,252,0,252,2,235,199,240,0,127,2,227,131,128,0,30,1,64,0,0,0,0,
  // 0x606f  息
  111,96,24,26,156,26,1,253,0,0,1,64,0,0,0,0,11,208,0,0,0,0,15,192,0,0,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,15,0,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,15,0,0,244,0,0,15,0,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,15,0,0,244,0,0,15,0,0,255,255,255,255,0,0,255,255,255,255,0,0,0,11,0,0,0,0,0,15,192,1,0,7,199,195,240,15,128,11,199,192,252,11,224,15,71,192,112,2,244,63,7,192,0,240,252,189,7,192,0,240,63,120,3,255,255,240,30,0,1,255,255,208,0,0,0,0,0,0,0,
  // 0x61b6  憶
  182,97,24,26,156,26,1,253,0,0,0,1,64,0,2,224,0,3,192,0,2,224,63,255,255,252,2,224,63,255,255,252,2,224,2,208,11,128,2,232,1,240,15,64,58,254,0,240,15,0,54,239,255,255,255,255,54,231,255,255,255,255,118,227,128,0,0,0,178,225,15,255,255,244,242,224,15,170,170,244,226,224,15,0,0,244,2,224,15,255,255,244,2,224,15,85,85,244,2,224,15,0,0,244,2,224,15,255,255,244,2,224,10,175,170,164,2,224,0,15,192,0,2,224,56,246,242,208,2,224,124,244,145,244,2,224,184,244,1,188,2,224,244,244,7,190,2,227,224,191,255,95,2,225,192,63,254,4,0,64,0,0,0,0,
  // 0x61c9  應
  201,97,24,25,150,26,1,253,0,0,1,240,0,0,0,0,2,240,0,0,15,255,255,255,255,254,15,255,255,255,255,254,15,0,224,120,41,0,15,2,224,244,60,0,15,3,194,255,255,252,15,15,135,250,250,164,15,63,143,224,180,0,15,255,191,255,255,240,15,251,158,229,249,80,15,87,129,229,249,80,15,7,129,255,255,240,31,7,129,224,180,0,31,7,129,255,255,253,31,7,129,234,170,168,46,1,66,244,0,0,46,0,0,191,0,0,61,15,31,31,135,192,60,15,31,1,3,240,124,46,31,0,41,248,184,188,31,0,60,125,244,248,15,255,252,46,112,16,7,255,244,4,0,0,0,0,0,0,
  // 0x6210  成
  16,98,24,26,156,26,1,253,0,0,0,20,0,0,0,0,0,61,61,0,0,0,0,61,63,128,0,0,0,61,11,240,0,0,0,61,1,208,15,255,255,255,255,254,15,255,255,255,255,254,15,213,85,126,85,85,15,128,0,62,0,0,15,128,0,47,1,144,15,192,0,47,2,240,15,255,253,47,3,224,15,255,252,31,7,192,15,128,60,15,79,128,15,128,60,15,159,64,15,128,60,15,254,0,15,128,60,11,252,0,15,64,124,7,244,0,15,64,188,7,240,13,31,47,248,31,240,31,47,31,240,127,248,30,62,0,2,253,188,46,125,0,15,244,63,189,252,0,31,208,31,252,52,0,6,0,7,240,0,0,0,0,0,0,
  // 0x6236  戶
  54,98,21,25,150,26,1,253,0,0,0,6,252,0,0,0,6,255,254,0,1,171,255,255,144,0,1,255,254,80,0,0,1,249,0,0,0,0,1,240,0,0,0,0,1,244,0,0,0,0,1,255,255,255,255,192,1,255,255,255,255,192,1,240,0,0,11,192,1,240,0,0,11,192,1,240,0,0,11,192,1,240,0,0,11,192,2,240,0,0,11,192,2,255,255,255,255,192,3,255,255,255,255,192,3,224,0,0,11,192,7,208,0,0,1,64,11,192,0,0,0,0,15,128,0,0,0,0,31,64,0,0,0,0,63,0,0,0,0,0,189,0,0,0,0,0,56,0,0,0,0,0,0,0,0,0,0,0,
  // 0x6240  所
  64,98,24,25,150,26,1,253,0,0,0,0,0,180,127,255,255,0,27,253,127,255,255,58,255,224,0,0,0,63,249,0,0,0,0,62,64,0,0,0,0,60,0,0,31,255,253,60,0,0,31,255,253,60,0,0,31,0,61,61,85,85,31,0,61,63,255,255,31,0,61,63,255,255,31,0,61,60,3,208,31,255,253,124,3,208,47,255,253,124,3,208,47,0,0,188,3,208,46,0,0,184,3,208,46,0,0,244,3,208,61,0,1,240,3,208,61,0,2,240,3,208,60,0,3,208,3,208,124,0,11,192,3,208,248,0,31,128,3,208,244,0,63,0,3,208,176,0,13,0,3,208,0,0,0,0,1,64,
  // 0x6247  扇
  71,98,23,23,138,26,1,254,63,255,255,255,255,252,63,255,255,255,255,252,0,0,0,0,0,0,3,255,255,255,255,208,7,255,255,255,255,224,7,192,0,0,3,224,7,192,0,0,3,224,7,255,255,255,255,224,7,255,255,255,255,224,7,192,0,0,0,0,7,192,0,0,0,0,7,239,255,143,255,240,7,223,255,143,255,240,11,198,7,130,65,240,11,143,135,135,209,240,15,67,215,129,241,240,15,65,135,128,129,240,31,0,103,128,45,240,62,27,251,139,253,240,125,127,71,159,145,240,252,52,11,136,1,240,244,0,255,128,47,240,16,0,190,0,31,208,
  // 0x624b  手
  75,98,24,25,150,26,1,253,0,0,0,5,191,0,0,86,175,255,255,192,15,255,255,255,164,0,11,254,171,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,15,255,255,255,255,240,15,255,255,255,255,240,5,85,87,229,85,80,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,21,85,91,229,85,85,191,255,255,255,255,254,191,255,255,255,255,254,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,3,208,0,0,0,0,7,208,0,0,0,31,255,192,0,0,0,15,255,64,0,0,0,5,80,0,0,0,
  // 0x6253  打
  83,98,24,25,150,26,1,254,0,80,0,0,0,0,0,244,0,0,0,0,0,244,0,0,0,0,0,244,15,255,255,255,0,244,15,255,255,255,0,244,5,85,126,85,191,255,224,0,62,0,191,255,224,0,62,0,21,249,64,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,0,249,160,0,62,0,1,255,240,0,62,0,191,255,144,0,62,0,191,248,0,0,62,0,116,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,0,244,0,0,62,0,17,244,0,170,189,0,63,240,0,127,252,0,47,208,0,63,224,0,
  // 0x6279  批
  121,98,24,26,156,26,1,253,1,64,0,0,0,0,3,208,61,0,244,0,3,208,61,0,244,0,3,208,61,0,244,0,3,208,61,0,244,0,3,208,61,0,244,0,255,255,61,0,244,0,255,255,61,0,244,40,3,224,61,0,244,189,3,208,63,252,251,248,3,208,63,252,255,208,3,208,62,84,254,0,3,239,61,0,248,0,27,255,61,0,244,0,255,249,61,0,244,0,255,208,61,0,244,0,83,208,61,0,244,0,3,208,61,0,244,0,3,208,61,0,244,0,3,208,61,0,244,13,3,208,61,0,244,15,3,208,63,188,244,15,3,210,255,253,248,46,127,211,255,164,191,253,63,130,144,0,63,248,0,0,0,0,0,0,
  // 0x6296  抖
  150,98,24,26,156,26,1,253,0,80,0,0,5,0,1,240,0,0,15,64,1,240,0,64,15,64,1,240,1,244,15,64,1,240,1,254,15,64,1,240,0,63,143,64,191,255,192,11,79,64,191,255,192,1,15,64,2,244,0,0,15,64,1,240,3,0,15,64,1,240,15,224,15,64,1,240,3,253,15,64,1,241,192,126,15,64,2,255,192,12,15,64,191,255,128,0,15,64,255,244,0,0,15,170,165,240,0,6,191,255,1,240,43,255,255,250,1,240,63,255,175,64,1,240,42,64,15,64,1,240,0,0,15,64,1,240,0,0,15,64,1,240,0,0,15,64,127,240,0,0,15,64,63,208,0,0,15,64,0,0,0,0,5,0,
  // 0x62bd  抽
  189,98,24,26,156,26,1,253,0,80,0,1,64,0,1,240,0,3,208,0,1,240,0,3,208,0,1,240,0,3,208,0,1,240,0,3,208,0,1,240,0,3,208,0,255,255,133,87,229,84,255,255,175,255,255,253,2,240,47,255,255,253,1,240,46,3,208,61,1,240,46,3,208,61,1,240,46,3,208,61,1,242,110,3,208,61,2,255,174,3,224,61,191,255,111,255,255,253,255,240,47,255,255,253,166,240,46,3,208,61,1,240,46,3,208,61,1,240,46,3,208,61,1,240,46,3,208,61,1,240,46,3,208,61,1,240,47,255,255,253,2,240,47,255,255,253,127,224,46,85,85,125,63,192,46,0,0,61,0,0,4,0,0,0,
  // 0x62d4  拔
  212,98,24,26,156,26,1,253,0,80,0,20,0,0,1,240,0,188,29,0,1,240,0,188,47,192,1,240,0,188,7,244,1,240,0,184,0,248,1,240,0,184,0,16,255,255,191,255,255,254,255,255,191,255,255,254,1,240,0,248,0,0,1,240,0,252,0,0,1,240,0,252,1,160,1,240,0,253,2,224,1,246,128,254,3,208,6,255,129,255,3,192,191,254,66,255,71,192,255,240,3,235,207,128,165,240,3,211,223,64,1,240,7,194,255,0,1,240,15,128,253,0,1,240,31,64,253,0,1,240,63,2,255,0,1,240,189,7,255,208,2,241,248,47,195,248,127,227,240,255,0,255,63,193,192,120,0,29,0,0,0,0,0,0,
  // 0x6309  按
  9,99,24,26,156,26,1,253,0,80,0,0,0,0,1,240,0,3,208,0,1,240,0,3,208,0,1,240,0,3,208,0,1,240,63,255,255,254,1,240,63,255,255,254,255,255,189,0,0,62,255,255,189,9,0,46,2,240,61,31,0,46,1,240,0,47,0,0,1,240,0,61,0,0,1,240,63,255,255,255,1,251,255,255,255,255,7,255,193,244,7,224,255,254,1,240,7,192,255,240,2,224,11,192,81,240,3,208,15,128,1,240,7,248,31,0,1,240,15,255,190,0,1,240,2,95,253,0,1,240,0,3,255,64,1,240,0,47,239,240,2,240,6,255,67,253,127,224,255,244,0,190,63,192,126,64,0,28,0,0,0,0,0,0,
  // 0x6389  掉
  137,99,24,26,156,26,1,253,0,64,0,1,0,0,3,224,0,11,192,0,3,224,0,11,192,0,3,224,0,11,255,254,3,224,0,11,255,254,3,224,0,11,192,0,255,255,0,11,192,0,255,255,127,255,255,244,3,224,63,255,255,244,3,224,60,0,0,244,3,224,60,0,0,244,3,224,63,255,255,244,3,230,63,255,255,244,3,255,124,0,0,244,191,255,60,0,0,244,255,224,63,255,255,244,103,224,63,255,255,244,3,224,0,11,192,0,3,224,0,11,192,0,3,225,255,255,255,255,3,225,255,255,255,255,3,224,0,11,192,0,3,224,0,11,192,0,191,208,0,11,192,0,127,128,0,11,192,0,0,0,0,1,64,0,
  // 0x63a2  探
  162,99,24,26,156,26,1,253,1,64,0,0,0,0,3,208,0,0,0,0,3,208,127,255,255,253,3,208,127,255,255,253,3,208,124,0,0,45,3,208,120,124,60,45,255,255,120,184,60,45,255,255,0,248,60,0,3,224,0,240,60,14,3,208,3,240,60,15,3,208,111,192,63,254,3,208,127,1,95,252,3,235,32,7,192,0,3,255,0,7,192,0,191,255,0,7,192,0,255,224,191,255,255,254,167,208,191,255,255,254,3,208,0,63,252,0,3,208,0,255,254,0,3,208,3,247,207,128,3,208,15,199,199,224,3,208,127,7,193,252,3,211,252,7,192,127,127,208,224,7,192,28,63,128,0,7,192,0,0,0,0,0,0,0,
  // 0x63a5  接
  165,99,24,26,156,26,1,253,0,80,0,0,0,0,1,240,0,7,192,0,1,240,0,7,192,0,1,240,63,255,255,252,1,240,63,255,255,252,1,240,1,208,11,192,255,255,2,224,15,128,255,255,1,240,15,0,2,240,0,240,31,0,1,240,0,244,46,0,1,240,255,255,255,255,1,240,255,255,255,255,1,241,0,62,0,0,2,255,0,124,0,0,191,255,255,255,255,255,255,240,255,255,255,255,230,240,2,240,15,128,1,240,3,208,15,64,1,240,11,192,47,0,1,240,15,253,126,0,1,240,11,191,252,0,1,240,0,15,254,0,2,240,1,191,255,224,127,225,255,253,7,252,63,192,254,64,0,120,4,0,64,0,0,0,
  // 0x63a7  控
  167,99,24,26,156,26,1,253,1,64,0,1,64,0,3,208,0,7,192,0,3,208,0,7,192,0,3,208,255,255,255,254,3,208,255,255,255,254,3,208,244,120,60,46,255,255,244,184,60,30,255,255,244,184,60,26,3,224,0,244,60,0,3,208,1,240,60,13,3,208,3,224,60,30,3,208,47,192,63,253,3,255,191,0,47,248,11,255,36,0,0,0,255,244,0,0,0,0,255,208,63,255,255,248,83,208,63,255,255,248,3,208,0,11,192,0,3,208,0,7,192,0,3,208,0,7,192,0,3,208,0,7,192,0,3,208,0,7,192,0,3,209,255,255,255,255,127,209,255,255,255,255,63,128,0,0,0,0,0,0,0,0,0,0,
  // 0x63d0  提
  208,99,24,26,156,26,1,253,1,64,0,0,0,0,3,208,31,255,255,240,3,208,31,255,255,240,3,208,31,0,0,240,3,208,31,0,0,240,3,208,31,255,255,240,255,255,31,170,170,240,255,255,31,0,0,240,3,208,31,0,0,240,3,208,31,255,255,240,3,208,31,255,255,240,3,208,0,0,0,0,3,214,191,255,255,253,7,255,191,255,255,253,191,254,0,7,192,0,255,208,14,7,192,0,167,208,15,7,192,0,3,208,31,7,255,240,3,208,47,7,255,240,3,208,63,71,192,0,3,208,63,199,192,0,3,208,250,247,192,0,3,209,240,255,192,0,127,199,224,47,255,255,63,131,192,6,255,254,0,0,0,0,0,0,
  // 0x63d2  插
  210,99,24,25,150,26,1,253,3,208,0,0,1,160,3,208,1,90,255,244,3,208,63,255,255,228,3,208,63,171,208,0,3,208,0,3,192,0,255,255,0,7,192,0,255,255,255,255,255,254,3,208,255,255,255,254,3,208,0,3,192,0,3,208,0,87,192,0,3,209,123,255,207,252,3,255,127,215,207,252,111,255,124,3,192,60,255,244,124,3,192,60,251,208,124,3,192,60,3,208,127,243,207,252,3,208,127,243,207,252,3,208,124,3,192,60,3,208,124,3,192,60,3,208,124,3,192,60,3,208,124,7,192,60,3,208,127,255,255,252,127,208,127,255,255,252,63,128,124,0,0,60,0,0,20,0,0,20,
  // 0x63db  換
  219,99,24,25,150,26,1,253,3,208,0,244,0,0,3,208,2,240,0,0,3,208,3,255,248,0,3,208,11,255,252,0,3,208,47,0,248,0,255,255,189,1,240,0,255,255,255,255,255,248,3,224,127,255,255,248,3,208,60,60,176,120,3,208,60,56,176,120,3,208,60,180,186,248,3,255,63,224,63,248,27,255,61,128,0,120,255,253,60,6,64,120,255,208,60,11,128,120,163,208,0,11,128,0,3,209,255,255,255,254,3,209,255,255,255,254,3,208,0,31,240,0,3,208,0,62,248,0,3,208,1,252,126,0,3,208,31,240,47,224,127,210,255,128,7,254,63,130,248,0,0,124,0,0,0,0,0,0,
  // 0x64c7  擇
  199,100,24,26,156,26,1,253,1,64,0,0,0,0,3,208,0,0,0,0,3,208,63,255,255,252,3,208,62,190,190,188,3,208,60,60,60,60,3,208,60,60,60,60,255,255,63,255,255,252,255,255,42,171,234,168,3,224,0,3,192,0,3,208,47,255,255,248,3,208,31,255,255,248,3,208,0,3,192,0,3,255,255,255,255,255,27,255,255,255,255,255,255,248,2,224,7,192,255,208,1,240,15,64,167,208,0,240,15,0,3,208,191,255,255,254,3,208,191,255,255,254,3,208,0,3,192,0,3,208,63,255,255,252,3,208,63,255,255,252,3,208,0,3,192,0,127,208,0,3,192,0,63,128,0,3,192,0,0,0,0,2,128,0,
  // 0x64ca  擊
  202,100,24,25,150,26,1,254,0,20,0,0,0,0,0,60,0,10,170,64,127,255,255,31,255,128,21,125,85,30,11,136,47,255,252,61,11,142,44,60,44,252,7,254,47,255,252,116,1,168,44,60,44,191,255,240,47,255,252,111,171,224,21,125,85,15,71,192,191,255,255,7,239,0,29,60,40,7,254,0,30,125,124,255,175,233,31,255,252,100,2,253,1,85,85,171,252,4,3,255,255,254,148,0,0,0,3,192,0,0,11,255,255,255,255,240,6,170,171,234,170,160,0,0,3,192,0,0,127,255,255,255,255,253,106,170,171,234,170,169,0,0,3,192,0,0,0,2,255,192,0,0,0,2,255,64,0,0,
  // 0x64cb  擋
  203,100,24,26,156,26,1,253,1,64,0,1,64,0,3,208,10,7,192,224,3,208,15,71,193,240,3,208,11,135,195,208,3,208,3,135,195,192,3,208,191,255,255,254,255,255,191,255,255,254,255,255,184,0,0,46,3,224,191,255,255,254,3,208,3,255,255,192,3,208,3,192,3,192,3,208,3,192,3,192,3,235,3,234,171,192,27,255,3,255,255,192,255,249,0,0,0,0,255,208,47,255,255,248,67,208,47,255,255,248,3,208,45,3,192,184,3,208,45,3,192,184,3,208,47,255,255,248,3,208,47,175,234,248,3,208,45,3,192,184,3,208,47,255,255,248,127,208,47,255,255,248,63,128,45,0,0,184,0,0,0,0,0,0,
  // 0x64e0  擠
  224,100,24,26,156,26,1,253,1,64,0,1,64,0,3,208,0,7,192,0,3,208,0,7,192,0,3,209,255,255,255,254,3,209,255,255,255,254,3,208,0,52,60,0,255,253,0,60,116,40,255,254,255,252,191,248,3,208,190,247,143,176,3,208,56,227,142,56,3,208,52,227,142,44,3,208,240,227,142,173,3,239,235,211,175,223,7,254,134,67,84,0,255,228,31,0,1,240,251,208,31,255,255,240,3,208,31,255,255,240,3,208,31,0,1,240,3,208,31,0,1,240,3,208,47,255,255,240,3,208,63,255,255,240,3,208,61,0,1,240,3,208,188,0,1,240,127,194,244,0,1,240,63,129,208,0,1,240,0,0,0,0,0,0,
  // 0x6536  收
  54,101,24,25,150,26,1,253,0,7,192,47,0,0,0,7,192,62,0,0,0,7,192,61,0,0,31,7,192,124,0,0,31,7,192,253,85,85,31,7,192,255,255,255,31,7,194,255,255,255,31,7,195,244,0,244,31,7,203,248,1,240,31,7,223,252,2,240,31,7,255,124,3,224,31,7,238,61,3,208,31,7,200,47,11,192,31,7,192,15,79,128,31,7,192,15,175,0,31,111,192,7,254,0,111,255,192,3,252,0,255,251,192,2,248,0,185,7,192,11,253,0,0,7,192,47,255,64,0,7,192,191,31,208,0,7,203,252,7,252,0,7,239,224,1,255,0,7,207,64,0,45,0,1,64,0,0,0,
  // 0x653e  放
  62,101,24,26,156,26,1,253,0,20,0,0,0,0,0,124,0,11,192,0,0,124,0,15,128,0,0,124,0,15,64,0,0,189,0,15,64,0,255,255,254,47,64,0,255,255,254,63,255,255,3,208,0,63,255,255,3,208,0,189,1,240,3,208,0,254,2,224,3,255,250,255,3,208,3,255,255,255,3,192,3,208,251,207,71,192,3,208,184,75,207,128,3,192,244,7,223,64,3,192,244,3,255,0,7,192,244,2,254,0,7,192,244,0,252,0,11,128,244,1,253,0,15,64,244,3,255,0,31,0,244,15,239,192,62,0,240,127,75,240,189,1,243,253,3,253,248,127,251,244,0,190,112,63,195,128,0,28,0,0,0,0,0,0,
  // 0x6557  敗
  87,101,24,25,150,26,1,253,0,0,0,15,128,0,47,255,248,15,128,0,47,255,248,31,64,0,46,0,184,47,0,0,46,0,184,63,85,85,46,0,184,63,255,255,47,255,248,191,255,255,47,255,248,252,2,240,46,0,186,253,3,224,46,0,191,254,3,208,47,255,255,239,7,192,47,255,255,79,75,192,46,0,184,15,143,128,46,0,184,11,223,64,46,0,184,3,255,0,47,255,248,2,253,0,47,255,248,1,252,0,1,0,64,2,253,0,7,195,208,11,255,0,15,130,240,31,239,192,31,64,248,191,11,244,63,0,127,253,3,254,252,0,43,244,0,255,120,0,3,128,0,44,0,0,0,0,0,0,
  // 0x6574  整
  116,101,24,25,150,26,1,254,0,4,0,1,64,0,0,46,0,3,208,0,106,191,170,71,192,0,127,255,255,75,255,254,0,46,0,31,255,254,63,255,255,63,2,240,62,127,111,255,67,208,60,46,15,251,199,192,62,191,175,34,239,128,63,255,255,0,255,0,0,255,208,0,255,0,7,255,253,7,255,208,127,110,47,191,195,253,124,46,4,253,0,189,16,4,0,16,0,4,15,255,255,255,255,240,15,255,255,255,255,240,0,0,3,192,0,0,0,0,3,192,0,0,0,184,3,255,255,0,0,184,3,255,255,64,0,184,3,192,0,0,0,184,3,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x6578  數
  120,101,24,26,156,26,1,253,0,5,0,0,64,0,0,15,0,0,240,0,15,255,255,65,240,0,15,175,175,66,240,0,15,15,11,67,224,0,255,255,255,243,224,0,191,175,175,243,255,255,15,15,11,71,255,255,15,255,255,75,192,244,10,175,170,15,192,244,0,15,0,31,192,240,63,255,255,255,209,240,62,175,171,255,226,224,60,15,3,253,243,224,63,255,255,196,247,192,26,190,170,128,255,192,0,188,0,0,191,128,255,255,255,240,63,0,191,255,255,240,63,0,3,192,61,0,127,64,15,244,188,0,255,192,11,191,240,3,247,224,0,47,248,31,193,252,43,254,191,127,64,191,63,224,10,60,0,44,4,0,0,0,0,0,
  // 0x6599  料
  153,101,24,26,156,26,1,253,0,0,0,0,1,64,0,184,0,0,7,192,16,184,100,16,7,192,180,184,184,124,7,192,56,184,240,127,71,192,60,184,240,15,215,192,60,185,224,2,199,192,45,186,208,0,71,192,29,186,192,0,7,192,0,248,64,128,7,192,255,255,250,244,7,192,255,255,249,254,7,192,2,248,0,47,71,192,3,254,0,10,7,192,7,255,64,0,7,192,15,255,192,0,7,218,30,186,240,1,175,255,61,184,246,255,255,250,124,184,151,255,235,192,248,184,3,144,7,192,240,184,0,0,7,192,80,184,0,0,7,192,0,184,0,0,7,192,0,184,0,0,7,192,0,184,0,0,7,192,0,80,0,0,1,64,
  // 0x659c  斜
  156,101,25,26,182,26,0,253,0,5,0,0,0,80,0,0,15,208,0,0,248,0,0,47,244,0,0,248,0,0,62,253,3,208,248,0,0,252,63,67,244,248,0,2,244,15,208,252,248,0,7,224,7,208,62,248,0,31,192,2,64,8,248,0,127,255,255,0,0,248,0,46,255,255,6,0,248,0,0,7,192,15,192,248,0,0,7,192,3,244,248,0,47,255,255,208,188,248,0,47,255,255,208,32,248,0,0,11,192,0,0,248,64,1,7,193,0,1,255,192,3,199,207,1,191,255,192,7,199,203,175,255,253,0,11,135,199,223,228,248,0,15,7,195,212,0,248,0,47,7,194,224,0,248,0,61,7,193,128,0,248,0,8,7,192,0,0,248,0,0,255,192,0,0,248,0,0,255,0,0,0,248,0,0,0,0,0,0,0,0,
  // 0x65b0  新
  176,101,24,26,156,26,1,253,0,20,0,0,0,0,0,62,0,0,1,184,0,62,0,17,191,253,127,255,255,63,255,144,127,255,255,63,144,0,11,0,180,61,0,0,11,64,244,61,0,0,7,128,240,61,0,0,3,129,224,61,0,0,191,255,255,126,0,0,191,255,255,127,255,255,0,62,0,63,255,255,0,62,0,61,3,192,0,62,0,61,3,192,191,255,255,61,3,192,191,255,255,61,3,192,0,190,0,60,3,192,1,255,128,124,3,192,3,255,240,188,3,192,15,254,252,248,3,192,47,62,61,240,3,192,253,62,2,240,3,192,180,62,7,224,3,192,16,62,15,192,3,192,0,62,7,64,3,192,0,20,0,0,0,0,
  // 0x65b7  斷
  183,101,23,25,150,26,2,253,80,192,52,0,2,208,242,192,176,0,111,240,251,102,218,43,255,128,251,118,221,63,228,0,243,224,252,62,0,0,241,208,117,61,0,0,243,168,231,61,0,0,255,255,255,125,0,0,245,9,1,126,0,0,255,255,255,63,255,252,255,255,255,63,255,252,241,192,112,61,11,128,242,128,224,61,11,128,255,55,201,61,11,128,247,177,221,61,11,128,242,224,184,60,11,128,241,212,117,60,11,128,243,172,231,124,11,128,255,255,255,252,11,128,245,5,65,248,11,128,255,255,255,244,11,128,255,255,255,240,11,128,240,0,3,208,11,128,240,0,1,192,11,128,0,0,0,0,1,0,
  // 0x65bc  於
  188,101,24,26,156,26,1,253,0,20,0,0,80,0,0,124,0,2,248,0,0,124,0,3,252,0,0,124,0,3,253,0,0,124,0,11,175,0,255,255,253,15,79,64,255,255,253,47,11,192,7,208,0,125,3,224,3,192,0,252,2,244,3,192,3,240,0,253,3,208,11,208,0,63,3,255,247,130,64,30,7,255,241,11,224,4,7,192,240,2,252,0,7,192,240,0,127,0,11,192,240,0,31,0,11,128,240,0,4,0,15,129,240,0,0,0,15,65,240,56,0,0,31,1,240,191,128,0,47,1,240,31,248,0,62,2,240,1,255,64,188,3,224,0,47,224,248,191,208,0,7,240,48,127,128,0,0,192,0,0,0,0,0,0,
  // 0x6607  昇
  7,102,24,24,144,26,1,253,3,255,255,255,255,192,3,255,255,255,255,192,3,208,0,0,7,192,3,255,255,255,255,192,3,255,255,255,255,192,3,208,0,0,7,192,3,208,0,0,7,192,3,255,255,255,255,192,3,255,255,255,255,192,0,0,6,0,80,0,0,22,255,192,244,0,15,255,255,64,244,0,15,255,208,0,244,0,4,3,208,0,244,0,0,3,208,0,244,0,191,255,255,255,255,254,191,255,255,255,255,254,0,11,192,0,244,0,0,15,128,0,244,0,0,63,0,0,244,0,2,253,0,0,244,0,31,244,0,0,244,0,15,128,0,0,244,0,0,0,0,0,80,0,
  // 0x660e  明
  14,102,22,24,144,26,2,253,255,255,131,255,255,240,255,255,131,255,255,240,244,11,131,192,0,240,244,7,131,192,0,240,244,7,131,192,0,240,244,7,131,192,0,240,244,7,131,255,255,240,255,255,131,255,255,240,255,255,131,208,1,240,244,11,131,192,0,240,244,7,131,192,0,240,244,7,131,192,0,240,244,7,135,208,1,240,244,7,135,255,255,240,255,255,139,255,255,240,255,255,143,128,0,240,244,0,15,64,0,240,244,0,31,0,0,240,160,0,62,0,0,240,0,0,189,0,0,240,0,1,248,0,1,240,0,7,240,1,255,240,0,3,192,0,255,208,0,0,0,0,20,0,
  // 0x662f  是
  47,102,24,24,144,26,1,253,3,255,255,255,255,128,3,255,255,255,255,128,3,224,0,0,11,128,3,250,170,170,175,128,3,255,255,255,255,128,3,224,0,0,11,128,3,224,0,0,11,128,3,255,255,255,255,128,2,255,255,255,255,128,0,0,0,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,3,224,0,0,0,124,3,208,0,0,0,188,3,208,0,0,0,248,3,255,255,224,0,252,3,255,255,224,2,253,3,224,0,0,3,255,67,208,0,0,15,207,227,208,0,0,47,67,255,229,0,21,191,0,191,255,255,254,124,0,6,255,255,253,0,0,0,0,0,0,
  // 0x6642  時
  66,102,23,25,150,26,2,253,0,0,0,11,128,0,255,254,0,11,128,0,255,254,0,15,128,0,244,46,63,255,255,240,240,46,63,255,255,240,240,46,0,11,128,0,240,46,0,11,128,0,240,46,0,15,128,0,240,46,255,255,255,252,255,254,255,255,255,252,255,254,0,0,31,0,244,46,0,0,31,0,240,46,0,0,31,0,240,46,255,255,255,248,240,46,255,255,255,248,240,46,0,0,31,0,240,46,11,0,31,0,255,254,15,192,31,0,255,254,3,224,31,0,244,0,1,244,31,0,240,0,0,240,31,0,80,0,0,0,31,0,0,0,0,15,255,0,0,0,0,11,252,0,0,0,0,0,0,0,
  // 0x66ab  暫
  171,102,24,26,156,26,1,253,0,20,0,0,0,0,0,46,0,0,2,240,127,255,255,106,191,248,42,191,170,63,254,64,0,46,0,62,64,0,47,255,254,61,0,0,44,46,14,61,0,0,47,255,254,63,255,254,44,46,14,63,255,254,47,255,254,60,11,128,0,46,0,124,11,128,85,126,85,248,11,128,191,255,255,240,11,128,0,46,3,208,11,128,0,25,0,128,6,128,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,31,0,0,244,0,0,31,0,0,255,255,255,255,0,0,254,170,170,191,0,0,244,0,0,31,0,0,244,0,0,31,0,0,255,255,255,255,0,0,255,255,255,255,0,0,160,0,0,5,0,
  // 0x66f4  更
  244,102,24,24,144,26,1,253,63,255,255,255,255,252,63,255,255,255,255,252,0,0,7,224,0,0,0,0,3,208,0,0,3,255,255,255,255,224,3,255,255,255,255,224,3,208,3,208,3,224,3,208,3,208,3,224,3,255,255,255,255,224,3,255,255,255,255,224,3,208,3,208,3,224,3,208,3,208,3,224,3,208,3,208,3,224,3,255,255,255,255,224,3,255,255,255,255,224,0,112,11,192,0,0,0,252,15,128,0,0,0,63,127,0,0,0,0,15,253,0,0,0,0,31,255,144,0,0,6,255,255,255,234,85,127,253,2,255,255,254,47,64,0,1,171,253,0,0,0,0,0,0,
  // 0x6700  最
  0,103,24,25,150,26,1,253,0,170,170,170,170,64,1,255,255,255,255,64,1,240,0,0,15,64,1,250,170,170,175,64,1,255,255,255,255,64,1,240,0,0,15,64,1,240,0,0,15,64,1,255,255,255,255,64,0,170,170,170,170,64,0,0,0,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,7,192,61,0,0,0,7,234,189,191,255,244,7,255,253,255,255,240,7,192,61,45,2,240,7,192,61,31,3,208,7,255,253,15,143,192,7,234,189,7,255,0,7,192,61,2,253,0,7,255,253,2,254,0,191,255,253,47,239,224,190,149,62,254,3,254,0,0,61,160,0,108,0,0,0,0,0,0,
  // 0x6709  有
  9,103,24,25,150,26,1,253,0,0,124,0,0,0,0,0,188,0,0,0,0,0,248,0,0,0,127,255,255,255,255,253,127,255,255,255,255,253,21,91,213,85,85,84,0,15,192,0,0,0,0,47,64,0,0,0,0,63,255,255,255,64,0,191,255,255,255,64,1,255,0,0,15,64,7,255,0,0,15,64,15,255,0,0,15,64,127,111,255,255,255,64,189,47,255,255,255,64,32,47,0,0,15,64,0,47,0,0,15,64,0,47,255,255,255,64,0,47,255,255,255,64,0,47,0,0,15,64,0,47,0,0,15,64,0,47,0,0,15,64,0,47,0,15,255,0,0,47,0,11,254,0,0,5,0,1,64,0,
  // 0x677f  板
  127,103,24,26,156,26,1,253,0,80,0,0,0,0,0,244,0,0,0,0,0,244,3,255,255,254,0,244,3,255,255,254,0,244,3,208,0,0,0,244,3,192,0,0,191,255,211,192,0,0,191,255,211,192,0,0,1,244,3,192,0,0,2,244,7,255,255,252,3,244,7,255,255,252,3,252,7,253,0,188,7,255,7,253,0,248,15,255,135,223,0,244,14,247,219,207,2,240,45,245,235,143,131,224,60,244,139,135,203,192,248,244,15,67,255,128,240,244,15,1,255,0,160,244,31,0,254,0,0,244,62,1,255,0,0,244,125,11,255,208,0,244,252,63,199,248,0,245,244,255,1,255,0,244,176,116,0,44,0,80,0,0,0,0,
  // 0x67f1  柱
  241,103,24,26,156,26,1,253,0,84,0,0,0,0,0,184,0,15,64,0,0,184,0,31,224,0,0,184,0,3,248,0,0,184,0,0,253,0,0,184,0,0,60,0,191,255,247,255,255,254,191,255,247,255,255,254,21,253,81,85,249,84,1,248,0,0,244,0,2,252,0,0,244,0,3,254,0,0,244,0,7,255,64,0,244,0,11,255,192,1,248,0,15,186,243,255,255,253,46,184,243,255,255,253,60,184,80,0,244,0,248,184,0,0,244,0,240,184,0,0,244,0,96,184,0,0,244,0,0,184,0,0,244,0,0,184,0,0,244,0,0,184,63,255,255,255,0,184,63,255,255,255,0,184,5,85,85,85,0,0,0,0,0,0,
  // 0x6821  校
  33,104,24,25,150,26,1,253,0,240,0,2,224,0,0,240,0,2,224,0,0,240,0,2,224,0,0,240,0,3,240,0,0,240,47,255,255,254,191,249,111,255,255,254,191,255,192,0,1,0,2,244,0,248,11,192,2,240,1,244,3,224,3,248,3,224,1,244,3,252,15,192,0,188,11,255,63,240,11,191,15,255,109,248,15,157,30,247,192,124,31,0,45,242,208,62,63,0,60,240,128,31,189,0,248,240,0,15,252,0,240,240,0,7,240,0,96,240,0,11,248,0,0,240,0,47,254,0,0,240,0,254,63,192,0,240,11,248,15,248,0,240,127,208,2,255,0,240,61,0,0,124,0,80,0,0,0,0,
  // 0x683c  格
  60,104,24,26,156,26,1,253,0,16,0,0,0,0,0,244,0,31,0,0,0,244,0,63,0,0,0,244,0,126,0,0,0,244,0,255,255,240,0,244,1,255,255,240,0,244,3,240,3,208,191,255,239,248,11,192,191,255,255,189,31,64,1,244,125,47,126,0,2,252,8,15,252,0,3,254,0,7,244,0,3,255,64,31,253,0,11,251,192,191,127,192,15,246,219,248,15,253,30,244,255,224,1,255,60,244,127,255,255,252,184,244,19,255,255,240,240,244,3,192,1,240,160,244,3,192,1,240,0,244,3,192,1,240,0,244,3,192,1,240,0,244,3,255,255,240,0,244,3,255,255,240,0,244,3,208,1,240,0,0,1,64,0,0,
  // 0x689d  條
  157,104,24,26,156,26,1,253,0,0,0,4,0,0,0,124,0,62,0,0,0,248,0,124,0,0,0,242,128,255,255,254,2,243,194,255,255,254,3,211,203,240,3,208,11,195,239,248,11,192,15,195,238,62,47,64,47,195,196,15,253,0,127,195,192,7,248,0,255,195,192,47,255,64,247,195,203,254,31,253,227,195,223,228,82,254,3,195,197,1,240,24,3,195,192,1,240,0,3,195,207,255,255,254,3,195,207,255,255,254,3,195,192,11,252,0,3,195,192,31,254,0,3,195,192,127,255,128,3,194,129,249,247,224,3,192,11,225,241,248,3,192,127,129,240,191,3,192,61,1,240,30,3,192,0,1,240,0,1,64,0,0,80,0,
  // 0x68c4  棄
  196,104,24,25,150,26,1,253,0,0,3,208,0,0,0,0,3,208,0,0,127,255,255,255,255,254,127,255,255,255,255,253,0,7,208,3,248,0,0,15,218,170,255,128,31,255,255,255,255,244,31,234,149,80,0,240,0,116,3,192,46,0,0,184,3,192,46,0,127,255,255,255,255,253,127,255,255,255,255,253,0,184,3,192,46,0,0,191,255,255,254,0,0,191,255,255,254,0,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,1,255,255,64,0,0,31,215,199,244,0,6,254,7,192,191,208,191,228,7,192,11,254,62,0,7,192,0,188,0,0,1,64,0,0,
  // 0x69fd  槽
  253,105,24,26,156,26,1,253,0,0,0,20,4,0,1,240,0,60,61,0,1,240,0,60,61,0,1,240,191,255,255,255,1,240,191,255,255,255,1,240,0,60,61,0,191,255,154,190,190,168,191,255,175,255,255,252,2,240,45,44,60,60,3,240,46,190,190,188,3,240,47,255,255,252,7,248,45,44,60,60,11,252,45,44,60,60,15,255,47,255,255,252,31,251,90,170,170,168,46,243,128,0,0,0,61,242,11,255,255,240,181,240,11,255,255,240,241,240,11,128,0,240,161,240,11,234,170,240,1,240,11,255,255,240,1,240,11,128,0,240,1,240,11,128,0,240,1,240,11,255,255,240,1,240,11,255,255,240,0,80,6,64,0,160,
  // 0x6a59  橙
  89,106,24,25,150,26,1,253,0,240,0,0,36,0,0,240,47,253,120,144,0,240,47,253,62,240,0,240,0,60,47,64,0,240,40,184,31,45,191,255,255,240,15,254,191,255,203,224,7,240,2,244,7,255,255,240,2,240,31,191,254,253,3,244,126,0,0,63,7,253,255,255,255,233,11,255,107,255,255,240,15,251,135,128,1,240,30,243,199,128,1,240,45,242,135,128,1,240,60,240,7,255,255,240,184,240,7,255,255,240,240,240,0,80,6,64,160,240,1,240,15,128,0,240,0,240,15,0,0,240,0,244,31,0,0,240,0,180,29,0,0,240,191,255,255,255,0,240,191,255,255,255,0,160,0,0,0,0,
  // 0x6a5f  機
  95,106,24,26,156,26,1,253,0,80,0,1,0,0,2,224,11,11,131,192,2,224,15,11,135,128,2,224,45,7,139,16,2,224,252,251,190,60,2,224,249,231,253,180,191,255,127,199,143,240,191,255,15,71,131,192,3,224,15,167,199,172,3,224,44,183,207,29,7,240,62,251,255,255,11,248,255,251,255,175,15,253,164,39,195,192,15,239,0,3,194,240,47,235,255,255,255,254,62,226,255,255,255,255,122,224,15,1,240,144,242,224,31,0,242,240,242,224,47,224,247,208,82,224,63,248,191,128,2,224,60,120,127,4,2,224,184,1,254,11,2,226,240,11,255,79,2,227,224,127,75,254,2,225,128,56,1,252,0,0,0,0,0,0,
  // 0x6aa2  檢
  162,106,24,26,156,26,1,253,0,80,0,1,64,0,0,240,0,11,240,0,0,240,0,31,248,0,0,240,0,126,126,0,0,240,1,252,47,128,0,240,7,240,11,224,191,255,239,208,2,253,191,255,255,255,255,255,2,244,120,255,255,93,3,240,16,0,0,0,3,248,26,169,42,168,7,252,31,254,63,252,11,255,29,30,56,60,15,251,93,30,56,60,30,243,237,30,56,60,45,242,159,254,63,252,60,240,26,169,42,168,244,240,1,144,6,64,240,240,2,224,11,128,96,240,3,208,15,64,0,240,7,224,31,128,0,240,15,252,63,240,0,240,63,62,189,252,0,240,252,11,244,63,0,240,176,2,208,13,0,80,0,0,0,0,
  // 0x6b62  止
  98,107,24,24,144,26,1,255,0,0,0,80,0,0,0,0,1,244,0,0,0,0,1,244,0,0,0,0,1,244,0,0,0,0,1,244,0,0,0,0,1,244,0,0,0,80,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,249,85,80,0,240,1,255,255,244,0,240,1,255,255,244,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,0,240,1,244,0,0,86,249,86,249,85,85,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x6b63  正
  99,107,24,23,138,26,1,254,5,85,85,85,85,84,47,255,255,255,255,252,47,255,255,255,255,252,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,80,2,240,0,0,0,240,2,240,0,0,0,240,2,245,85,64,0,240,2,255,255,224,0,240,2,255,255,224,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,0,240,2,240,0,0,191,255,255,255,255,254,191,255,255,255,255,254,21,85,85,85,85,84,
  // 0x6b65  步
  101,107,24,26,156,26,1,253,0,0,1,64,0,0,0,0,3,208,0,0,0,16,3,208,0,0,0,248,3,213,85,64,0,248,3,255,255,192,0,248,3,255,255,192,0,248,3,208,0,0,0,248,3,208,0,0,21,249,87,213,85,84,191,255,255,255,255,254,191,255,255,255,255,254,0,0,3,192,0,0,0,62,3,192,4,0,0,189,3,192,15,192,2,248,3,192,31,64,15,224,3,192,63,0,127,128,3,192,126,0,46,1,255,193,252,0,4,0,255,71,240,0,0,0,0,47,208,0,0,0,1,255,64,0,0,0,47,252,0,0,0,91,255,208,0,0,7,255,249,0,0,0,3,254,64,0,0,0,0,0,0,0,0,0,
  // 0x6b78  歸
  120,107,24,26,156,26,1,253,0,64,0,0,0,0,0,244,0,170,170,160,1,240,0,255,255,240,47,255,224,0,1,240,47,171,224,0,1,240,45,1,235,255,255,255,47,171,230,170,171,250,47,255,224,0,1,240,45,0,0,255,255,240,47,255,224,170,170,160,47,255,240,0,0,0,45,0,243,255,255,253,47,171,243,255,255,253,47,255,243,128,240,45,0,120,2,64,240,25,0,120,1,255,255,248,40,120,1,255,255,248,60,127,241,224,240,184,60,127,241,224,240,184,60,120,1,224,240,184,60,120,17,224,240,184,61,191,245,224,247,244,255,255,245,224,243,240,255,164,0,0,240,0,64,0,0,0,240,0,0,0,0,0,0,0,
  // 0x6bbc  殼
  188,107,24,25,150,26,1,253,0,61,0,0,0,0,0,61,0,15,255,192,191,255,255,15,255,192,127,255,254,15,3,192,0,61,0,15,3,192,63,255,252,31,3,192,42,170,168,46,3,199,0,0,0,61,3,203,106,170,170,188,3,255,191,255,255,244,1,189,180,0,15,16,0,0,187,255,239,127,255,248,7,255,224,127,255,248,0,0,0,10,0,244,0,0,0,31,1,240,11,255,240,15,3,224,11,255,240,11,135,208,11,129,240,3,223,128,11,129,240,2,255,0,15,65,246,0,253,0,15,2,255,71,255,64,47,7,249,127,223,244,189,2,71,254,3,255,56,0,3,224,0,124,0,0,0,0,0,0,
  // 0x6bd4  比
  212,107,24,24,144,26,1,254,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,16,2,240,0,62,0,244,2,245,84,62,11,252,2,255,253,62,191,208,2,255,253,63,254,0,2,240,0,63,208,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,0,2,240,0,62,0,13,2,240,0,62,0,15,2,240,111,62,0,31,2,255,255,62,0,31,191,255,249,47,85,126,191,249,0,31,255,253,121,0,0,11,255,244,
  // 0x6c92  沒
  146,108,24,26,156,26,1,253,0,0,0,64,0,0,11,64,2,240,0,0,31,240,2,240,0,0,2,253,3,255,255,244,0,124,3,255,255,244,0,0,11,208,1,240,0,0,15,192,1,240,0,0,31,64,1,240,52,0,63,0,2,240,191,64,189,0,3,224,47,225,252,2,255,208,3,225,240,0,255,128,0,64,0,0,0,0,0,0,127,255,255,240,0,0,127,255,255,240,0,52,7,192,7,224,0,124,7,208,11,192,0,252,2,240,31,128,1,244,0,252,126,0,3,240,0,63,252,0,7,208,0,47,240,0,15,192,1,255,254,0,47,64,111,253,191,228,62,3,255,208,15,254,8,1,249,0,1,188,0,0,0,0,0,0,
  // 0x6d88  消
  136,109,23,26,156,26,1,253,0,0,0,1,64,0,14,0,16,11,192,32,31,208,188,11,192,124,7,248,61,11,192,248,0,184,47,11,193,240,0,32,15,75,195,224,0,0,11,75,194,192,0,0,0,11,192,0,56,0,63,255,255,244,191,64,63,255,255,244,31,224,61,85,85,244,3,224,60,0,0,244,0,128,60,0,0,244,0,0,63,255,255,244,0,0,63,255,255,244,0,48,61,0,0,244,0,188,60,0,0,244,0,248,61,0,0,244,1,240,63,255,255,244,3,224,63,255,255,244,7,192,60,0,0,244,15,192,60,0,0,244,47,64,60,0,0,244,63,0,60,0,127,240,13,0,60,0,63,224,0,0,20,0,20,0,
  // 0x6de1  淡
  225,109,24,24,144,26,1,254,0,0,0,11,128,0,15,64,0,15,128,0,31,240,31,15,128,244,2,252,61,15,66,240,0,120,124,15,67,208,0,0,248,31,15,128,0,0,176,47,135,0,16,0,0,127,248,0,125,0,1,253,255,64,191,192,11,244,31,240,11,241,255,192,2,252,1,192,253,15,128,116,0,0,0,15,64,0,0,0,45,15,64,184,0,96,61,15,64,248,0,248,124,15,130,240,1,244,248,31,199,208,3,241,240,63,239,128,7,208,80,127,245,0,15,192,1,252,252,0,47,64,11,240,63,128,63,1,191,192,15,249,45,7,254,0,2,254,0,2,144,0,0,44,
  // 0x6e05  清
  5,110,24,26,156,26,1,253,0,0,0,5,0,0,15,64,0,15,128,0,31,244,170,175,234,168,2,252,255,255,255,252,0,120,0,15,128,0,0,0,42,175,234,164,0,0,127,255,255,244,0,0,0,15,128,0,36,0,0,15,128,0,191,3,255,255,255,255,127,226,255,255,255,254,7,224,0,0,0,0,0,128,47,255,255,240,0,0,47,255,255,240,0,0,46,0,1,240,0,52,47,170,170,240,0,124,47,255,255,240,0,248,46,0,1,240,1,240,46,0,1,240,3,224,47,255,255,240,11,192,47,170,171,240,15,128,46,0,1,240,47,0,46,0,1,240,62,0,46,0,127,240,8,0,46,0,63,208,0,0,0,0,0,0,
  // 0x6e2c  測
  44,110,23,26,156,26,1,253,0,0,0,0,0,20,9,0,0,0,0,60,47,195,255,248,0,60,15,243,255,248,100,60,1,243,192,120,184,60,0,3,192,120,184,60,0,3,192,120,184,60,0,3,255,248,184,60,36,3,255,248,184,60,191,3,192,120,184,60,127,211,192,120,184,60,7,195,192,120,184,60,0,3,255,248,184,60,0,3,255,248,184,60,0,3,192,120,184,60,0,67,192,120,184,60,2,227,208,120,184,60,3,227,255,248,184,60,7,195,255,248,180,60,11,192,64,16,0,60,15,130,240,244,0,60,31,3,208,188,0,60,62,15,192,63,0,124,125,47,0,14,63,252,28,45,0,0,31,244,0,0,0,0,5,0,
  // 0x6e90  源
  144,110,24,25,150,26,1,253,14,0,0,0,0,0,47,225,255,255,255,254,7,249,255,255,255,254,0,245,244,1,244,0,0,17,240,1,240,0,0,1,240,2,240,0,0,1,242,255,255,252,36,1,242,255,255,252,190,1,242,208,0,124,127,209,242,208,0,124,11,209,242,255,255,252,1,129,242,250,170,252,0,1,242,208,0,124,0,2,242,255,255,252,0,210,226,255,255,252,1,243,224,1,240,0,3,227,208,145,240,160,7,211,193,241,241,244,11,203,195,225,240,252,15,143,135,193,240,61,47,31,79,129,240,63,62,63,47,1,240,30,125,61,8,63,240,0,24,24,0,47,208,0,0,0,0,0,0,0,
  // 0x6e96  準
  150,110,24,26,156,26,1,253,1,0,5,0,64,0,11,208,15,129,244,0,7,252,47,3,224,0,0,120,127,255,255,248,0,0,255,255,255,248,61,3,252,7,192,0,191,143,252,7,192,0,47,239,255,255,255,224,2,71,127,255,255,224,0,0,124,7,192,0,0,60,127,255,255,224,0,248,127,255,255,240,3,240,124,7,192,0,15,192,124,7,192,0,63,64,127,255,255,252,45,0,127,255,255,252,4,0,7,192,0,0,0,0,7,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,1,64,0,0,
  // 0x6eab  溫
  171,110,24,25,150,26,1,253,10,0,0,0,0,0,31,224,63,255,255,208,7,252,63,255,255,208,0,248,60,6,3,208,0,32,60,15,3,208,0,0,60,30,3,208,0,0,60,63,131,208,32,0,60,182,227,208,126,0,61,224,183,208,191,208,60,64,19,208,11,208,63,255,255,208,1,128,63,255,255,208,0,0,0,0,0,0,0,0,255,255,255,244,0,160,255,255,255,244,0,244,240,240,240,244,1,240,240,240,240,244,3,224,240,240,240,244,7,208,240,240,240,244,15,192,240,240,240,244,15,128,240,240,240,244,47,0,240,240,240,244,62,31,255,255,255,255,44,31,255,255,255,255,0,0,0,0,0,0,
  // 0x6fc0  激
  192,111,24,26,156,26,1,253,0,0,4,0,16,0,14,0,31,0,60,0,47,208,47,0,124,0,7,246,191,168,188,0,0,227,255,252,184,0,0,3,128,60,248,0,0,3,128,60,255,255,0,3,255,253,255,255,56,3,234,190,240,120,191,67,128,63,240,184,47,195,234,255,240,180,7,195,255,255,240,244,0,0,31,7,116,240,0,0,31,1,56,240,0,15,255,255,61,224,0,79,255,255,47,208,1,224,180,0,31,192,3,224,180,0,15,192,3,208,191,248,15,128,11,192,255,248,31,128,15,128,240,184,63,208,31,2,240,184,190,240,63,7,208,181,244,189,125,47,143,255,224,63,44,46,15,231,64,13,0,4,0,0,0,0,
  // 0x7121  無
  33,113,24,25,150,26,1,253,0,62,0,0,0,0,0,125,0,0,0,0,0,252,0,0,0,0,3,255,255,255,255,248,11,255,255,255,255,248,47,240,120,60,15,0,190,240,120,60,15,0,40,240,120,60,15,0,0,244,120,61,31,0,191,255,255,255,255,254,191,255,255,255,255,254,0,240,120,60,15,0,0,240,120,60,15,0,0,240,120,60,15,0,0,240,120,60,15,0,63,255,255,255,255,252,63,255,255,255,255,252,0,0,0,0,0,0,2,128,16,4,6,192,7,208,240,62,7,224,11,192,244,31,2,240,31,64,248,15,64,252,63,0,184,15,128,125,124,0,184,11,128,62,0,0,0,0,0,0,
  // 0x71b1  熱
  177,113,24,26,156,26,1,253,0,4,0,1,64,0,0,61,0,3,192,0,26,191,168,3,192,0,31,255,252,3,192,0,0,61,0,191,255,208,0,61,0,191,255,208,127,255,255,107,195,208,107,251,234,3,195,208,3,195,197,3,195,208,11,195,239,187,195,208,127,2,254,191,131,208,56,61,0,31,211,208,47,255,252,15,247,208,63,255,252,31,191,215,0,61,0,62,39,215,0,61,21,124,3,215,106,255,255,252,3,215,191,255,251,240,3,255,105,64,0,128,0,253,0,0,0,0,0,0,3,208,80,25,7,192,11,192,240,46,3,240,15,128,244,31,1,248,63,0,248,15,64,188,125,0,248,15,64,61,0,0,0,0,0,16,
  // 0x71c8  燈
  200,113,24,25,150,26,1,253,0,240,0,1,224,128,0,240,47,253,243,224,0,240,47,252,191,128,0,240,0,124,125,8,0,243,237,244,46,125,40,243,223,240,15,244,60,251,71,208,7,208,56,255,15,255,255,244,56,249,63,191,253,254,117,242,252,0,0,47,181,241,224,0,0,4,241,240,11,255,255,224,17,224,11,255,255,224,1,224,11,64,2,224,2,224,11,64,2,224,3,240,11,255,255,224,3,252,11,255,255,224,7,254,0,64,10,0,11,159,66,224,15,64,15,75,192,240,31,0,47,3,64,244,46,0,62,0,0,160,44,0,252,0,255,255,255,254,48,0,255,255,255,254,0,0,0,0,0,0,
  // 0x7247  片
  71,114,23,26,156,26,1,253,0,0,0,20,0,0,1,160,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,240,0,62,0,0,1,249,85,127,85,80,1,255,255,255,255,244,1,255,255,255,255,244,1,240,0,0,0,0,1,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,0,0,2,255,255,255,248,0,3,255,255,255,248,0,3,250,170,170,248,0,3,224,0,0,248,0,7,208,0,0,248,0,15,192,0,0,248,0,15,128,0,0,248,0,47,64,0,0,248,0,127,0,0,0,248,0,253,0,0,0,248,0,56,0,0,0,248,0,0,0,0,0,84,0,
  // 0x7269  物
  105,114,24,26,156,26,1,253,0,20,0,0,0,0,0,124,0,184,0,0,40,124,0,244,0,0,61,124,0,240,0,0,60,124,2,240,0,0,60,124,3,255,255,254,63,255,211,255,255,254,127,255,219,203,203,174,185,189,95,75,79,110,244,124,63,15,15,46,240,124,125,31,31,61,96,124,40,61,46,61,0,124,16,124,61,61,0,127,240,248,124,61,6,255,241,240,184,60,255,253,3,208,244,60,191,188,15,193,240,60,80,124,63,3,208,124,0,124,29,11,192,124,0,124,0,15,64,188,0,124,0,63,0,248,0,124,0,188,0,244,0,124,2,244,86,240,0,124,7,224,191,240,0,124,0,128,127,128,0,20,0,0,0,0,
  // 0x7387  率
  135,115,24,25,150,26,1,253,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,208,0,0,47,255,255,255,255,252,47,255,255,255,255,252,0,0,31,0,0,64,14,0,61,4,1,244,31,210,248,46,11,224,3,251,240,124,47,64,0,176,189,240,24,0,0,0,47,212,0,0,0,28,15,95,40,0,6,252,61,15,255,128,127,235,255,255,219,244,62,7,255,251,241,253,16,0,7,192,208,36,0,0,7,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,1,64,0,0,
  // 0x7528  用
  40,117,22,24,144,26,1,253,1,85,85,85,85,80,3,255,255,255,255,240,3,255,255,255,255,240,3,208,3,208,1,240,3,208,3,208,1,240,3,208,3,208,1,240,3,224,7,224,1,240,3,255,255,255,255,240,3,255,255,255,255,240,3,208,3,208,1,240,3,208,3,208,1,240,3,208,3,208,1,240,3,208,3,208,1,240,3,255,255,255,255,240,7,255,255,255,255,240,7,213,87,229,86,240,11,128,3,208,1,240,15,64,3,208,1,240,15,0,3,208,1,240,47,0,3,208,1,240,62,0,3,208,1,240,252,0,3,210,255,240,120,0,3,209,255,208,16,0,0,0,84,0,
  // 0x754c  界
  76,117,24,24,144,26,1,253,3,255,255,255,255,192,3,255,255,255,255,192,3,208,3,192,7,192,3,208,3,192,7,192,3,255,255,255,255,192,3,255,255,255,255,192,3,208,3,192,7,192,3,208,3,192,7,192,3,255,255,255,255,192,3,255,255,255,255,192,0,2,244,15,192,0,0,11,224,7,240,0,0,63,128,2,253,0,2,254,0,0,191,128,47,251,208,3,255,253,127,195,208,3,210,253,40,3,208,3,208,40,0,7,208,3,208,0,0,15,192,3,208,0,0,47,128,3,208,0,0,191,0,3,208,0,11,252,0,3,208,0,3,224,0,3,208,0,1,0,0,1,64,0,
  // 0x767d  白
  125,118,20,26,130,26,3,253,0,0,80,0,0,0,0,252,0,0,0,1,248,0,0,0,2,240,0,0,21,87,245,85,84,127,255,255,255,253,127,255,255,255,253,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,127,255,255,255,253,127,255,255,255,253,125,85,85,85,125,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,124,0,0,0,61,127,255,255,255,253,127,255,255,255,253,125,85,85,85,125,124,0,0,0,61,20,0,0,0,20,
  // 0x7684  的
  132,118,22,26,156,26,2,253,0,64,0,16,0,0,0,248,0,62,0,0,1,240,0,61,0,0,2,240,0,188,0,0,3,224,0,252,0,0,255,255,208,255,255,240,255,255,210,255,255,240,244,2,211,224,0,240,244,2,219,192,0,240,244,2,255,128,0,240,244,2,235,0,0,240,244,2,208,120,1,240,255,255,208,125,1,240,255,255,208,47,1,240,244,2,208,15,129,240,244,2,208,7,209,240,244,2,208,3,242,224,244,2,208,1,194,224,244,2,208,0,2,224,244,2,208,0,3,208,248,3,208,0,3,208,255,255,208,0,7,192,255,255,208,5,95,192,244,0,0,15,255,128,180,0,0,15,253,0,0,0,0,0,0,0,
  // 0x76e3  監
  227,118,24,24,144,26,1,254,0,0,0,3,128,0,63,255,255,7,192,0,63,255,255,11,128,0,60,15,0,15,64,0,62,175,169,31,255,253,63,255,254,63,255,253,60,0,30,124,0,0,60,0,30,244,0,0,63,255,254,112,0,0,62,175,169,0,0,0,60,15,0,15,255,252,63,255,255,79,255,252,63,255,255,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,255,192,3,255,255,255,255,192,3,208,180,46,7,192,3,208,180,46,7,192,3,208,180,46,7,192,3,208,180,46,7,192,3,208,248,46,7,192,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x76f4  直
  244,118,24,26,156,26,1,253,0,0,1,80,0,0,0,0,3,240,0,0,0,0,3,224,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,7,208,0,0,0,0,7,192,0,0,0,3,255,255,255,64,15,67,255,255,255,128,15,67,192,0,15,128,15,67,192,0,15,128,15,67,255,255,255,128,15,67,234,170,175,128,15,67,192,0,15,128,15,67,234,170,175,128,15,67,255,255,255,128,15,67,192,0,15,128,15,67,192,0,15,128,15,67,255,255,255,128,15,67,255,255,255,64,15,64,0,0,0,0,15,64,0,0,0,0,15,255,255,255,255,254,15,255,255,255,255,254,15,64,0,0,0,0,5,0,0,0,0,0,
  // 0x7720  眠
  32,119,24,24,144,26,2,253,255,253,31,255,255,240,255,253,31,255,255,240,244,61,31,0,0,240,240,61,31,0,0,240,240,61,31,0,0,240,240,61,31,0,1,240,255,253,31,255,255,240,255,253,31,255,255,240,240,61,31,2,224,0,240,61,31,2,224,0,240,61,31,1,240,0,255,253,31,255,255,252,255,253,31,255,255,252,240,61,31,85,245,80,240,61,31,0,244,0,240,61,31,0,244,0,244,61,31,0,184,0,255,253,31,0,124,20,255,253,31,0,60,29,240,0,31,91,126,45,240,1,191,255,159,60,0,2,255,249,15,252,0,1,229,0,3,244,0,0,0,0,0,0,
  // 0x780d  砍
  13,120,24,26,156,26,1,253,0,0,0,80,0,0,0,0,0,188,0,0,191,255,244,248,0,0,191,255,244,244,0,0,3,224,1,240,0,0,3,208,2,255,255,254,3,192,2,255,255,254,7,192,3,231,229,125,11,192,7,195,208,61,11,128,15,195,208,124,15,255,239,131,208,188,31,255,255,3,208,244,47,67,234,3,224,240,63,66,208,3,224,0,191,66,208,7,240,0,255,66,208,11,240,0,191,66,208,15,184,0,15,66,208,31,124,0,15,66,208,61,62,0,15,255,208,188,31,0,15,255,209,244,15,192,15,64,7,224,3,240,15,64,47,192,1,254,10,0,127,0,0,127,0,0,40,0,0,28,0,0,0,0,0,0,
  // 0x78ba  確
  186,120,24,26,156,26,1,253,0,0,0,0,64,0,0,0,0,2,224,0,191,255,224,3,208,0,191,255,255,255,255,255,3,224,47,255,255,255,3,208,30,31,64,31,3,192,30,63,15,95,7,192,25,125,15,26,11,128,0,252,46,0,15,128,3,255,255,252,15,255,207,255,255,252,31,255,255,224,124,0,47,67,255,224,124,0,63,3,202,255,255,248,191,3,194,255,255,248,255,3,194,224,124,0,255,3,194,224,124,0,175,3,194,224,124,0,15,3,194,255,255,248,15,3,194,255,255,248,15,255,194,224,124,0,15,255,194,224,124,0,15,64,2,255,255,255,15,0,2,255,255,255,0,0,2,224,0,0,0,0,0,64,0,0,
  // 0x79fb  移
  251,121,24,25,150,26,1,253,0,6,128,3,224,0,6,255,208,15,192,0,191,254,64,47,255,244,126,248,0,255,255,244,0,184,7,244,3,240,0,184,47,253,11,192,0,184,14,47,95,64,191,255,224,11,253,0,191,255,224,7,244,0,21,249,64,127,224,0,2,252,11,254,252,0,3,254,15,226,240,0,7,255,133,7,255,254,15,251,224,31,255,254,30,185,240,190,0,124,60,184,135,253,0,248,188,184,15,255,130,240,244,184,6,11,251,224,160,184,0,1,255,128,0,184,0,1,254,0,0,184,0,15,248,0,0,184,2,255,192,0,0,184,63,253,0,0,0,184,31,144,0,0,0,16,0,0,0,0,
  // 0x7a4d  積
  77,122,24,26,156,26,1,253,0,0,0,1,64,0,0,7,64,3,224,0,26,255,223,255,255,252,191,254,10,171,250,168,121,244,0,3,224,0,0,244,11,255,255,248,0,244,6,171,250,164,0,244,42,171,250,169,191,255,255,255,255,255,191,255,192,0,0,0,21,249,66,170,170,164,2,244,3,255,255,244,3,253,3,192,0,244,7,255,3,213,85,244,15,255,195,255,255,244,30,246,227,192,0,244,61,244,195,213,85,244,188,244,3,255,255,244,244,244,3,192,0,244,160,244,3,234,170,244,0,244,3,255,255,244,0,244,0,120,7,0,0,244,2,252,15,224,0,244,127,224,2,252,0,244,190,0,0,126,0,80,16,0,0,0,
  // 0x7aef  端
  239,122,24,26,156,26,1,253,0,0,0,1,64,0,2,224,0,3,208,0,2,224,15,3,208,124,2,224,15,3,208,124,2,224,15,3,208,124,2,224,15,3,208,124,191,255,143,255,255,252,191,255,143,255,255,252,0,0,0,0,0,0,56,15,0,0,0,0,60,31,63,255,255,255,60,30,63,255,255,255,44,46,0,7,208,0,45,45,0,7,192,0,29,60,0,11,192,0,30,60,31,255,255,253,30,60,31,255,255,253,25,120,30,29,44,61,0,127,238,29,44,61,107,255,238,29,44,61,255,249,46,29,44,61,185,0,30,29,44,61,0,0,30,29,44,61,0,0,30,29,46,253,0,0,30,29,45,248,0,0,4,0,0,0,
  // 0x7b49  等
  73,123,24,26,156,26,1,253,0,0,0,4,0,0,2,240,0,31,0,0,3,224,0,63,0,0,11,255,254,127,255,254,15,255,255,255,255,254,63,62,3,240,188,0,253,31,7,224,61,0,120,14,3,192,45,0,0,0,7,192,0,0,3,255,255,255,255,208,3,255,255,255,255,208,0,0,7,192,0,0,0,0,7,208,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,0,0,244,0,0,0,0,0,244,0,63,255,255,255,255,252,63,255,255,255,255,252,0,30,0,0,244,0,0,47,192,0,244,0,0,11,240,0,244,0,0,1,248,0,244,0,0,0,160,255,240,0,0,0,0,191,224,0,0,0,0,0,0,0,
  // 0x7ba1  管
  161,123,24,26,156,26,1,253,0,0,0,4,0,0,2,240,0,31,0,0,3,224,0,63,0,0,11,255,254,191,255,255,31,255,255,255,255,255,126,62,7,240,124,0,124,31,7,192,62,0,0,4,3,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,61,0,0,0,0,124,61,63,255,255,252,124,61,63,255,255,252,124,0,61,0,0,60,0,0,61,0,0,60,0,0,63,255,255,252,0,0,63,255,255,252,0,0,61,0,0,0,0,0,61,0,0,0,0,0,63,255,255,255,192,0,63,255,255,255,192,0,61,0,0,7,192,0,61,0,0,7,192,0,63,255,255,255,192,0,63,255,255,255,192,0,40,0,0,2,128,
  // 0x7bb1  箱
  177,123,24,26,156,26,1,253,0,64,0,4,0,0,2,240,0,31,0,0,3,224,0,63,0,0,7,255,254,127,255,254,15,255,254,255,255,254,47,62,2,244,252,0,126,31,7,224,61,0,188,15,67,192,46,0,16,61,0,0,0,0,0,61,0,255,255,248,0,61,0,255,255,248,127,255,253,244,0,184,127,255,253,240,0,184,0,189,0,240,0,184,0,255,0,255,255,248,2,255,192,255,255,248,3,255,240,240,0,184,11,253,252,240,0,184,31,61,124,255,255,248,126,61,20,255,255,248,252,61,0,240,0,184,112,61,0,240,0,184,0,61,0,255,255,248,0,61,0,255,255,248,0,61,0,240,0,184,0,20,0,0,0,0,
  // 0x7cfb  系
  251,124,24,25,150,26,1,253,0,0,0,0,26,64,0,5,90,191,255,192,47,255,255,255,255,144,31,255,255,165,0,0,0,0,252,0,64,0,0,3,244,3,240,0,1,79,208,15,208,0,7,255,64,63,64,0,2,254,0,253,0,0,0,127,199,240,0,0,0,15,255,192,184,0,0,2,254,0,191,0,0,1,244,0,31,192,0,11,255,255,255,240,127,255,255,255,255,252,127,255,255,229,80,190,16,0,7,192,0,40,0,45,7,192,180,0,0,190,7,192,254,0,2,252,7,192,63,192,15,240,7,192,15,240,127,192,7,192,2,252,127,0,7,192,0,189,24,0,7,192,0,32,0,0,1,64,0,0,
  // 0x7d05  紅
  5,125,24,25,150,26,1,253,0,180,0,0,0,0,0,244,0,0,0,0,2,240,1,85,85,84,3,209,211,255,255,254,127,131,243,255,255,254,191,11,192,0,244,0,47,95,64,0,244,0,11,254,0,0,244,0,2,252,96,0,244,0,2,240,244,0,244,0,11,192,124,0,244,0,255,255,254,0,244,0,255,255,255,0,244,0,0,61,11,64,244,0,0,60,0,0,244,0,30,60,180,0,244,0,46,60,188,0,244,0,61,60,60,0,244,0,60,60,62,0,244,0,188,60,31,0,244,0,248,60,13,0,244,0,176,60,15,255,255,255,0,60,15,255,255,255,0,60,5,85,85,85,0,20,0,0,0,0,
  // 0x7d22  索
  34,125,23,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,61,0,127,0,0,124,60,0,252,2,0,60,60,23,240,15,208,60,0,255,192,63,64,0,0,127,129,252,0,0,0,11,251,240,240,0,0,2,255,128,253,0,0,2,252,0,63,128,63,255,255,255,255,240,63,255,255,255,255,252,0,4,7,192,0,52,0,47,71,193,248,0,1,253,7,192,191,64,31,240,7,192,31,224,127,128,7,192,2,252,45,0,7,192,0,116,0,0,1,64,0,0,
  // 0x7d2b  紫
  43,125,24,26,156,26,1,253,0,5,0,20,0,0,0,15,0,61,0,0,9,15,0,61,1,224,15,15,255,61,111,248,15,15,255,63,255,128,15,15,0,63,224,0,15,15,0,61,0,0,15,15,0,61,0,30,15,31,255,62,0,62,191,255,255,63,255,253,255,250,109,11,255,248,80,0,190,1,0,0,0,82,244,11,208,0,2,255,192,63,128,0,0,127,193,253,20,0,0,7,255,224,190,0,0,0,255,0,31,192,191,255,255,255,255,240,191,255,255,255,255,252,0,0,7,208,0,126,0,29,7,192,116,16,0,190,7,193,254,0,11,248,7,192,47,208,127,208,7,192,3,252,46,0,7,192,0,184,0,0,1,64,0,0,
  // 0x7d30  細
  48,125,23,25,150,26,1,253,1,240,0,0,0,0,2,224,0,0,0,0,3,192,3,255,255,252,11,131,131,255,255,252,127,11,131,192,240,60,253,31,3,192,240,60,62,61,3,192,240,60,15,252,3,192,240,60,7,241,67,192,240,60,3,211,195,192,240,60,11,130,227,192,240,60,255,255,247,255,255,252,255,255,251,255,255,252,0,244,127,193,240,124,0,244,19,192,240,60,60,246,195,192,240,60,60,246,211,192,240,60,60,245,243,192,240,60,120,244,247,192,240,60,180,244,187,192,240,60,240,244,3,255,255,252,96,244,3,255,255,252,0,244,3,192,0,124,0,244,3,192,0,40,0,80,0,0,0,0,
  // 0x7d42  終
  66,125,24,26,156,26,1,253,0,64,0,4,0,0,1,240,0,31,0,0,3,208,0,62,0,0,7,193,0,191,255,240,15,75,129,255,255,240,191,15,3,244,3,224,189,46,15,252,11,192,63,124,63,125,15,128,15,244,61,31,127,0,3,231,4,11,252,0,3,203,64,3,248,0,15,67,192,31,254,0,255,255,208,191,127,192,255,255,251,248,11,248,0,240,255,208,1,255,0,240,74,15,128,44,60,247,192,11,248,0,60,243,192,0,191,0,60,242,208,0,30,0,120,240,224,64,0,0,180,240,242,253,0,0,240,240,1,255,224,0,176,240,0,11,255,64,0,240,0,0,127,224,0,240,0,0,7,208,0,80,0,0,0,64,
  // 0x7d71  統
  113,125,24,26,156,26,1,253,0,0,0,1,64,0,1,224,0,3,208,0,2,224,0,3,208,0,3,192,0,3,208,0,11,135,111,255,255,254,127,15,111,255,255,254,253,46,0,63,0,0,63,60,0,61,7,64,15,244,0,188,7,192,7,230,0,248,2,240,3,203,70,250,255,248,15,67,223,255,255,253,255,255,239,169,84,63,255,255,224,0,4,24,0,240,240,124,46,0,0,240,64,188,46,0,60,247,128,184,46,0,60,243,192,184,46,0,60,242,208,244,46,0,120,240,224,240,46,0,180,240,242,240,46,14,240,240,7,224,46,15,176,240,31,192,46,15,0,240,191,0,31,255,0,240,124,0,15,253,0,80,0,0,0,0,
  // 0x7d72  絲
  114,125,24,26,156,26,1,253,0,0,0,0,64,0,0,248,0,1,240,0,1,240,0,3,240,0,3,224,0,7,192,0,7,195,224,15,131,208,127,7,208,255,7,208,254,15,129,252,15,128,47,47,0,126,63,0,11,252,0,15,252,0,3,244,144,3,245,208,3,225,240,7,226,240,11,192,244,15,192,248,255,255,253,255,255,252,255,255,253,255,255,254,0,124,46,64,249,31,0,60,0,0,248,4,30,60,176,56,248,144,46,60,244,124,249,240,61,60,124,188,248,244,60,60,60,244,248,124,124,60,61,240,248,61,248,60,3,224,248,46,176,60,3,192,248,30,0,60,0,0,248,0,0,60,0,0,248,0,0,20,0,0,80,0,
  // 0x7da0  綠
  160,125,24,25,150,26,1,253,1,240,0,124,0,0,2,224,0,184,0,0,3,192,0,255,255,224,11,139,64,255,255,224,127,15,65,240,3,208,253,46,2,224,3,192,62,60,3,255,255,192,15,244,3,255,255,192,7,230,0,64,11,128,7,207,95,255,255,254,15,71,239,255,255,254,255,255,208,2,240,0,255,255,225,2,240,36,0,240,251,194,244,125,0,240,67,242,249,244,60,243,128,246,255,208,60,243,192,162,255,0,120,242,192,22,239,64,120,241,208,190,231,208,244,241,231,246,226,244,240,240,47,210,224,254,96,240,63,2,224,62,0,240,24,63,224,8,0,240,0,63,128,0,0,80,0,0,0,0,
  // 0x7db2  網
  178,125,23,25,150,26,1,253,1,224,0,0,0,0,2,224,31,255,255,252,3,192,31,255,255,252,11,139,95,0,0,60,127,15,95,56,15,60,253,46,31,44,30,60,62,60,31,29,44,60,31,244,31,13,44,60,11,226,31,127,255,60,3,207,95,127,255,60,15,71,223,2,208,60,255,255,239,2,208,60,255,255,255,127,255,60,0,240,255,127,255,124,0,240,95,30,0,60,60,243,159,30,0,60,60,243,223,30,0,60,120,242,239,30,0,60,120,241,255,31,255,60,244,240,239,11,255,60,240,240,31,0,0,60,96,240,31,0,0,60,0,240,31,0,15,252,0,240,31,0,11,244,0,0,0,0,0,0,
  // 0x7dd2  緒
  210,125,24,26,156,26,1,253,0,0,0,5,0,0,1,224,0,15,0,20,2,224,0,15,0,61,3,192,0,15,0,188,7,134,15,255,254,244,31,15,143,255,255,240,254,31,0,15,3,208,189,61,0,15,15,192,47,184,0,15,31,64,15,240,63,255,255,255,3,207,63,255,255,255,15,71,128,11,224,0,255,255,192,63,128,0,255,255,226,255,255,244,0,240,255,255,255,244,0,240,191,240,0,244,40,242,105,240,0,244,60,243,192,240,0,244,60,243,192,255,255,244,120,242,208,255,255,244,180,241,224,240,0,244,240,240,0,240,0,244,160,240,0,255,255,244,0,240,0,255,255,244,0,240,0,240,0,244,0,80,0,0,0,0,
  // 0x7dda  線
  218,125,24,26,156,26,1,253,0,0,0,0,64,0,1,240,0,3,240,0,2,224,0,3,208,0,3,192,11,255,255,248,11,139,75,255,255,252,127,15,75,128,0,124,253,46,11,128,0,124,62,60,11,255,255,252,15,244,11,255,255,252,7,230,11,128,0,124,7,207,75,128,0,124,15,71,203,255,255,252,255,255,219,255,255,252,255,255,224,1,240,0,0,240,240,1,240,40,0,240,95,254,248,190,60,243,159,253,254,248,60,243,192,185,255,208,120,242,192,245,255,64,120,241,210,241,235,192,244,241,215,209,227,240,240,240,31,129,224,253,160,240,127,1,224,127,0,240,56,63,224,12,0,240,0,63,192,0,0,80,0,0,0,0,
  // 0x7de8  編
  232,125,24,25,150,26,1,253,1,240,0,0,0,0,2,224,63,255,255,253,3,192,63,255,255,253,11,75,64,0,0,0,127,15,0,0,0,0,253,46,15,255,255,252,62,60,15,255,255,252,15,244,15,64,0,124,7,230,15,64,0,124,3,207,15,255,255,252,15,71,143,255,255,252,255,255,207,64,0,0,255,255,223,0,0,0,1,241,239,255,255,253,0,240,79,255,255,253,41,251,15,211,142,45,60,247,95,211,142,45,56,243,175,255,255,253,120,243,254,255,255,253,180,242,253,211,142,45,240,240,125,211,142,45,224,240,245,211,142,45,0,241,241,211,142,253,0,240,81,211,142,184,0,80,0,64,0,0,
  // 0x7e2e  縮
  46,126,24,26,156,26,1,253,0,0,0,1,64,0,1,240,0,3,208,0,3,208,0,3,208,0,3,192,63,255,255,254,11,75,127,255,255,254,127,15,61,0,0,46,253,46,61,0,0,46,62,60,45,224,0,21,31,244,1,255,255,254,7,230,2,223,255,254,3,203,67,192,46,0,15,71,139,128,61,0,255,255,207,135,255,252,255,255,255,139,255,252,1,241,255,139,64,60,0,240,127,139,64,60,41,247,39,139,64,60,60,247,135,139,255,252,56,243,199,139,255,252,120,243,199,139,64,60,180,242,199,139,64,60,240,240,7,139,64,60,224,240,7,139,255,252,0,240,7,139,255,252,0,240,7,139,64,60,0,80,1,0,0,0,
  // 0x7e3d  總
  61,126,24,26,156,26,1,253,0,0,0,0,64,0,1,240,0,2,240,0,2,224,0,3,224,0,3,192,15,255,255,252,11,75,79,255,255,252,127,15,15,1,192,60,253,46,15,19,255,60,62,60,15,127,95,60,15,244,15,47,221,60,7,230,15,185,252,60,3,207,15,16,254,60,15,71,143,7,219,60,255,255,207,30,0,60,255,255,223,255,255,252,1,241,239,255,255,252,0,240,64,15,64,0,61,247,0,11,224,0,60,247,64,1,248,0,56,243,197,60,52,160,120,243,207,60,0,244,180,242,207,60,0,124,240,240,30,60,6,61,160,240,61,60,11,95,0,240,124,63,255,78,0,240,0,31,254,0,0,80,0,0,0,0,
  // 0x7e7c  繼
  124,126,24,26,156,26,1,253,0,0,16,0,0,0,3,192,120,56,2,128,7,192,120,52,3,64,11,64,121,243,159,56,15,29,122,219,61,176,189,61,120,253,15,208,188,124,120,58,3,180,62,240,120,179,143,44,15,224,123,255,255,253,7,232,122,229,254,154,11,108,120,0,0,0,31,30,127,255,255,254,255,255,127,255,255,254,255,255,184,56,2,128,2,215,248,52,3,64,2,209,121,243,175,60,54,218,122,219,45,112,122,223,120,189,11,224,118,219,184,58,3,244,182,215,248,178,139,44,178,211,251,255,255,254,242,209,185,149,169,90,162,208,127,255,255,254,2,208,127,255,255,255,2,208,120,0,0,0,0,0,0,0,0,0,
  // 0x7e8c  續
  140,126,24,26,156,26,1,253,0,0,0,1,64,0,1,224,0,3,208,0,3,208,63,255,255,254,7,192,42,171,234,169,11,79,64,3,208,0,127,31,15,255,255,248,253,61,5,85,85,84,62,124,31,255,255,252,15,240,30,94,125,124,7,234,30,29,60,60,3,207,30,248,47,252,15,75,95,255,255,252,255,255,197,85,85,84,255,255,193,85,85,80,0,241,219,255,255,244,0,240,11,128,0,244,60,247,11,255,255,244,60,247,75,128,0,244,120,243,203,255,255,244,116,243,203,128,0,244,244,242,203,128,0,244,240,240,11,255,255,244,160,240,0,184,15,64,0,240,31,244,11,248,0,240,190,64,0,190,0,80,16,0,0,0,
  // 0x7ea2  红
  162,126,24,24,144,26,1,254,0,124,0,0,0,0,0,188,0,0,0,0,0,248,15,255,255,252,2,240,15,255,255,252,3,224,5,87,245,84,15,193,128,2,240,0,31,67,240,2,240,0,62,11,208,2,240,0,255,255,128,2,240,0,255,255,0,2,240,0,101,253,0,2,240,0,1,244,0,2,240,0,7,224,0,2,240,0,15,193,64,2,240,0,127,255,208,2,240,0,255,255,208,2,240,0,126,80,0,2,240,0,0,0,0,2,240,0,0,0,0,2,240,0,0,111,192,2,240,0,175,255,239,255,255,255,255,249,31,255,255,255,185,0,5,85,85,85,0,0,0,0,0,0,
  // 0x7f6e  置
  110,127,23,24,144,26,2,253,63,255,255,255,255,192,63,171,234,254,175,192,61,3,192,60,7,192,63,171,234,254,175,192,63,255,255,255,255,192,0,0,15,64,0,0,255,255,255,255,255,240,255,255,255,255,255,240,0,0,31,0,0,0,0,5,111,85,85,0,62,15,255,255,255,0,62,15,0,0,15,0,62,15,85,85,95,0,62,15,255,255,255,0,62,15,0,0,15,0,62,15,255,255,255,0,62,15,85,85,95,0,62,15,85,85,95,0,62,15,255,255,255,0,62,0,0,0,0,0,63,255,255,255,255,248,63,255,255,255,255,252,62,0,0,0,0,0,0,0,0,0,0,0,
  // 0x7f72  署
  114,127,24,25,150,26,1,253,10,170,170,170,170,160,15,255,255,255,255,240,15,64,240,15,0,240,15,64,240,15,0,240,15,234,250,191,171,240,15,255,255,255,255,240,0,0,15,64,0,0,0,0,15,64,0,208,3,255,255,255,243,240,2,255,255,255,255,208,0,0,15,64,127,64,0,0,15,66,252,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,111,244,0,0,0,11,255,255,255,192,6,255,255,255,255,192,255,255,0,0,3,192,126,95,170,170,171,192,16,15,255,255,255,192,0,15,0,0,3,192,0,15,0,0,3,192,0,15,255,255,255,192,0,15,255,255,255,192,0,5,0,0,1,64,
  // 0x8070  聰
  112,128,24,26,156,26,1,253,0,0,0,0,64,0,0,0,0,2,240,0,191,255,248,3,224,0,191,255,255,255,255,252,15,3,199,255,255,252,15,3,199,129,192,60,15,3,199,135,255,60,15,255,199,175,79,60,15,255,199,175,221,60,15,3,199,164,252,60,15,3,199,128,253,60,15,3,199,135,202,60,15,3,199,142,0,60,15,255,199,255,255,252,15,255,199,255,255,252,15,3,192,11,208,0,15,3,192,2,248,0,15,3,193,30,124,80,31,191,195,222,4,240,255,255,195,222,0,184,255,231,203,158,0,60,80,3,207,94,3,173,0,3,239,30,3,159,0,3,237,31,255,79,0,3,192,11,255,0,0,1,64,0,0,0,
  // 0x81ea  自
  234,129,18,26,130,26,4,253,0,0,64,0,0,0,2,240,0,0,0,3,240,0,0,0,3,208,0,0,255,255,255,255,240,255,255,255,255,240,249,85,85,86,240,248,0,0,1,240,248,0,0,1,240,248,0,0,1,240,255,255,255,255,240,255,255,255,255,240,248,0,0,1,240,248,0,0,1,240,248,0,0,1,240,248,0,0,1,240,255,255,255,255,240,255,255,255,255,240,248,0,0,1,240,248,0,0,1,240,248,0,0,1,240,248,0,0,1,240,255,255,255,255,240,255,255,255,255,240,248,0,0,1,240,80,0,0,0,80,
  // 0x85cd  藍
  205,133,24,25,150,26,1,254,0,1,64,1,64,0,0,11,192,3,208,0,127,255,255,255,255,254,127,255,255,255,255,254,0,11,192,3,208,0,0,6,64,3,128,0,31,255,255,71,192,0,31,175,170,15,128,0,30,11,64,15,255,252,31,255,254,63,255,252,31,85,94,188,0,0,30,0,15,180,0,0,31,255,254,16,0,0,31,95,149,15,255,248,31,175,170,79,255,248,31,255,255,128,0,0,0,0,0,0,0,0,2,255,255,255,255,192,3,255,255,255,255,192,3,208,184,30,3,192,3,208,184,30,3,192,3,208,184,30,3,192,3,208,184,30,3,192,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x884c  行
  76,136,24,25,150,26,1,253,0,63,0,0,0,0,0,253,11,255,255,252,3,244,11,255,255,252,15,224,1,85,85,84,63,128,0,0,0,0,254,5,0,0,0,0,52,15,192,0,0,0,0,47,64,0,0,0,0,126,5,85,85,84,0,252,47,255,255,255,3,244,47,255,255,255,15,244,0,0,31,0,63,244,0,0,31,0,254,244,0,0,31,0,184,244,0,0,31,0,16,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,0,47,0,0,244,0,63,255,0,0,244,0,31,253,0,0,160,0,5,80,0,
  // 0x8868  表
  104,136,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,31,255,255,255,255,244,31,255,255,255,255,244,0,0,7,192,0,0,0,0,7,192,0,0,3,255,255,255,255,208,3,255,255,255,255,208,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,191,248,0,0,0,3,248,124,0,240,0,47,208,62,7,244,6,255,128,47,47,192,191,255,128,15,254,0,191,79,128,7,240,0,36,15,128,3,244,0,0,15,128,20,253,0,0,15,171,252,127,128,0,111,255,248,15,248,7,255,249,0,3,255,3,249,0,0,0,124,0,0,0,0,0,0,
  // 0x88ab  被
  171,136,24,26,156,26,1,253,0,0,0,0,80,0,1,240,0,0,240,0,1,240,0,0,240,0,1,240,0,0,240,0,1,240,0,1,244,0,2,240,11,255,255,255,191,255,203,255,255,254,191,255,203,128,240,61,0,15,75,128,240,60,0,47,11,128,240,184,0,61,75,128,240,0,0,248,251,255,255,248,3,250,219,255,255,248,11,255,75,252,1,244,63,255,79,189,1,240,255,247,207,110,3,224,249,242,207,79,71,208,81,240,79,15,207,128,1,240,31,3,255,0,1,240,47,2,253,0,1,240,61,2,254,0,1,240,124,15,255,192,1,240,252,127,143,248,1,241,246,254,2,255,1,240,176,240,0,124,0,80,0,0,0,0,
  // 0x88c5  装
  197,136,24,26,156,26,1,253,0,5,0,1,64,0,0,15,0,3,224,0,44,15,0,3,224,0,63,79,0,3,224,0,11,223,63,255,255,254,2,79,63,255,255,254,0,15,0,3,224,0,0,31,0,3,224,0,2,239,0,3,224,0,111,239,0,3,224,0,254,15,15,255,255,252,96,15,15,255,255,252,0,15,1,64,0,0,0,5,7,192,0,0,0,0,7,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,2,252,248,0,208,0,47,224,61,11,240,27,255,64,47,127,128,191,223,64,15,248,0,36,15,64,19,248,0,0,15,239,240,191,144,3,255,255,240,31,254,2,254,144,0,1,188,0,0,0,0,0,4,
  // 0x88dd  裝
  221,136,24,26,156,26,1,253,0,1,64,0,80,0,30,3,192,2,240,0,30,3,192,2,240,0,30,3,192,2,240,0,31,255,207,255,255,253,31,255,207,255,255,253,4,3,192,2,240,0,127,255,192,2,240,0,191,255,192,2,240,0,15,67,192,2,240,0,15,3,199,255,255,252,47,3,199,255,255,252,189,3,192,0,0,0,184,3,195,208,0,0,16,0,3,208,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,2,252,248,0,208,0,111,208,61,11,240,111,255,64,47,127,128,127,159,64,15,248,0,16,15,64,83,248,0,0,31,255,240,191,144,3,255,255,224,31,254,3,249,64,0,1,188,0,0,0,0,0,4,
  // 0x8907  複
  7,137,24,26,156,26,1,253,0,64,0,64,0,0,2,224,0,244,0,0,2,224,2,240,0,0,2,224,3,255,255,254,2,224,15,255,255,254,2,224,31,0,0,0,191,255,190,0,0,0,191,255,255,255,255,240,0,31,23,234,170,240,0,61,3,192,0,240,0,124,3,255,255,240,0,244,211,229,86,240,2,243,195,192,0,240,7,255,67,255,255,240,15,255,2,175,170,160,63,239,64,63,0,0,254,227,192,255,255,224,178,225,7,255,255,240,18,224,47,244,11,192,2,224,126,125,47,128,2,224,20,47,254,0,2,224,0,31,252,0,2,224,6,255,255,208,2,224,191,249,31,255,2,224,127,128,1,189,0,80,16,0,0,4,
  // 0x89d2  角
  210,137,22,26,156,26,1,253,0,1,64,0,0,0,0,3,240,0,0,0,0,11,255,255,64,0,0,31,255,255,192,0,0,63,0,31,64,0,0,252,0,63,0,0,3,248,0,189,0,0,15,255,255,255,255,224,63,255,255,255,255,224,46,244,2,240,2,224,4,244,2,240,2,224,0,244,2,240,2,224,0,255,255,255,255,224,0,255,255,255,255,224,0,244,2,240,2,224,0,240,2,240,2,224,1,240,2,240,2,224,1,255,255,255,255,224,2,255,255,255,255,224,3,208,0,0,2,224,11,192,0,0,2,224,15,128,0,0,2,224,63,0,0,0,3,224,253,0,0,15,255,224,56,0,0,7,255,128,0,0,0,1,80,0,
  // 0x8a08  計
  8,138,24,26,156,26,1,253,0,0,0,0,80,0,47,255,208,0,248,0,47,255,208,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,255,255,244,0,248,0,255,255,244,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,47,255,213,85,249,85,47,255,219,255,255,255,0,0,11,255,255,255,47,255,208,0,248,0,47,255,208,0,248,0,0,0,0,0,248,0,0,0,0,0,248,0,63,255,208,0,248,0,63,255,208,0,248,0,61,3,208,0,248,0,61,3,208,0,248,0,61,3,208,0,248,0,61,3,208,0,248,0,63,255,208,0,248,0,63,255,208,0,248,0,61,0,0,0,248,0,0,0,0,0,80,0,
  // 0x8a0a  訊
  10,138,25,26,182,26,1,252,47,255,128,0,0,0,0,47,255,207,255,255,208,0,0,0,15,255,255,208,0,0,0,5,125,87,208,0,255,255,224,60,3,208,0,255,255,224,60,3,208,0,0,0,0,60,3,208,0,0,0,0,60,3,208,0,63,255,192,60,3,208,0,47,255,128,60,3,208,0,0,0,31,255,243,208,0,47,255,223,255,243,208,0,63,255,192,61,83,208,0,0,0,0,124,3,208,0,0,0,0,124,3,208,0,63,255,192,188,3,208,0,63,255,192,248,3,208,0,61,3,192,244,3,224,0,61,3,194,240,2,225,0,61,3,195,224,2,243,0,61,3,203,192,1,243,128,63,255,223,128,0,247,64,63,255,255,0,0,255,0,61,0,28,0,0,127,0,0,0,0,0,0,24,0,0,0,0,0,0,0,0,
  // 0x8a18  記
  24,138,24,25,150,26,1,253,47,255,208,0,0,0,47,255,209,255,255,248,0,0,1,255,255,248,0,0,0,85,85,248,255,255,244,0,0,248,255,255,244,0,0,248,0,0,0,0,0,248,0,0,0,0,0,248,47,255,208,0,0,248,47,255,208,85,85,248,0,0,1,255,255,248,47,255,209,255,255,248,47,255,209,240,0,248,0,0,1,240,0,84,0,0,1,240,0,0,63,255,209,240,0,0,63,255,209,240,0,0,61,3,209,240,0,0,61,3,209,240,0,30,61,3,209,240,0,31,61,3,209,240,0,47,63,255,208,249,85,126,63,255,208,255,255,252,61,0,0,47,255,244,0,0,0,0,0,0,
  // 0x8a2d  設
  45,138,24,25,150,26,1,253,47,255,192,0,0,0,47,255,192,255,255,0,0,0,0,255,255,0,0,0,0,240,15,0,255,255,241,240,15,0,255,255,241,240,15,8,0,0,2,240,15,15,0,0,3,224,15,15,47,255,207,192,15,254,47,255,239,64,7,252,0,0,13,0,0,0,47,255,203,255,255,244,47,255,203,255,255,244,0,0,0,160,2,240,0,0,1,240,3,224,63,255,192,248,11,192,63,255,192,125,15,128,61,3,192,47,127,0,61,3,192,15,252,0,61,3,192,7,248,0,61,3,192,47,254,0,63,255,198,255,127,228,63,255,239,248,11,255,61,0,15,128,0,188,0,0,0,0,0,0,
  // 0x8a66  試
  102,138,25,25,175,26,1,253,47,255,64,0,46,96,0,47,255,128,0,46,184,0,0,0,0,0,46,61,0,0,0,0,0,46,30,0,255,255,208,0,47,4,0,255,255,239,255,255,254,0,0,0,31,255,255,254,0,0,0,0,0,31,0,0,63,255,128,0,31,0,0,47,255,128,0,31,0,0,0,0,0,0,31,0,0,47,255,143,255,223,0,0,63,255,143,255,207,0,0,0,0,0,180,15,0,0,0,0,0,180,15,0,0,63,255,128,180,15,0,0,63,255,128,180,15,64,0,60,7,128,180,15,64,0,60,7,128,180,11,134,0,60,7,128,186,215,203,64,60,7,155,255,227,223,0,63,255,175,254,67,255,0,63,255,137,0,1,253,0,60,0,0,0,0,120,0,0,0,0,0,0,0,0,
  // 0x8a8d  認
  141,138,24,25,150,26,1,253,47,255,64,0,0,0,47,255,135,255,255,252,0,0,7,255,255,252,0,0,0,7,128,124,255,255,211,155,64,124,255,255,215,255,0,124,0,0,0,191,208,124,0,0,0,63,248,184,63,255,128,189,244,184,47,255,130,244,32,244,0,0,15,224,63,240,47,255,143,129,47,208,63,255,132,15,128,0,0,0,0,7,244,0,0,0,0,0,253,0,63,255,128,61,44,16,63,255,135,125,1,240,60,7,139,125,0,248,60,7,143,61,0,124,60,7,143,61,2,62,60,7,174,61,7,159,63,255,189,61,7,143,63,255,152,63,255,73,60,0,0,31,255,0,0,0,0,0,0,0,
  // 0x8aa4  誤
  164,138,24,25,150,26,1,253,47,255,0,15,255,248,47,255,0,15,255,248,0,0,5,15,64,184,0,0,15,79,64,184,255,255,207,79,64,184,255,255,207,79,64,184,0,0,15,79,255,248,0,0,15,79,255,248,63,255,15,64,0,0,47,255,15,64,0,0,0,0,15,255,255,240,63,255,15,255,255,240,63,255,15,64,1,240,0,0,15,64,1,240,0,0,0,0,1,240,63,255,63,255,255,255,63,255,63,255,255,255,60,15,0,0,0,0,60,15,0,56,7,64,60,15,0,252,15,208,60,15,2,244,3,240,63,255,11,224,0,252,63,255,127,128,0,126,60,0,45,0,0,46,0,0,0,0,0,0,
  // 0x8abf  調
  191,138,23,25,150,26,1,253,47,254,0,0,0,0,47,254,31,255,255,252,0,0,31,255,255,252,0,0,31,2,192,60,255,255,95,2,192,60,255,255,95,63,254,60,0,0,31,63,254,60,0,0,31,2,192,60,63,255,31,2,192,60,63,254,31,63,255,60,0,0,31,63,255,60,63,254,31,0,0,60,63,255,31,0,0,60,0,0,30,47,253,60,0,0,46,63,254,60,63,254,46,60,14,60,63,254,46,60,14,60,60,14,61,60,14,60,60,14,60,63,254,60,60,14,60,63,254,60,60,14,124,60,0,60,63,254,248,0,0,60,63,255,240,0,31,252,60,0,240,0,15,248,0,0,0,0,5,64,
  // 0x8acb  請
  203,138,24,26,156,26,1,253,0,0,0,0,80,0,47,255,128,1,240,0,47,255,203,255,255,253,0,0,11,255,255,253,0,0,0,1,240,0,255,255,226,171,250,168,255,255,227,255,255,252,0,0,0,1,240,0,0,0,0,1,240,0,63,255,223,255,255,255,47,255,159,255,255,254,0,0,0,0,0,0,47,255,193,255,255,244,63,255,193,255,255,244,0,0,1,240,0,244,0,0,1,250,170,244,63,255,193,255,255,244,63,255,193,240,0,244,61,3,193,240,0,244,61,3,193,255,255,244,61,3,193,250,170,244,61,3,193,240,0,244,63,255,193,240,0,244,63,255,193,240,47,240,61,0,1,240,31,224,0,0,0,0,0,0,
  // 0x8b70  議
  112,139,24,25,150,26,1,253,47,254,2,208,3,192,47,254,0,240,11,128,0,0,42,254,175,232,0,0,47,255,255,252,255,255,64,3,192,0,255,255,70,171,234,160,0,0,15,255,255,244,0,0,0,3,192,0,63,255,127,255,255,254,63,254,191,255,255,254,0,0,0,0,0,0,63,254,5,190,120,208,63,255,63,249,124,248,0,0,21,240,124,60,0,0,0,240,60,0,63,254,191,255,255,254,63,254,127,255,255,254,60,14,0,240,60,16,60,14,22,255,109,244,60,14,191,254,31,240,60,14,85,240,31,192,63,254,0,240,63,71,63,254,43,241,255,203,60,0,31,215,211,254,0,0,0,0,0,184,
  // 0x8b80  讀
  128,139,24,26,156,26,1,253,0,0,0,1,64,0,47,254,0,3,208,0,47,254,63,255,255,253,0,0,26,171,234,169,0,0,0,3,208,0,255,255,79,255,255,252,255,255,64,0,0,0,0,0,5,85,85,84,0,0,47,255,255,253,63,255,45,28,56,45,63,254,46,228,47,253,0,0,45,85,85,125,63,254,47,255,255,253,63,255,5,85,85,80,0,0,15,255,255,248,0,0,15,64,0,184,63,254,15,255,255,248,63,254,15,64,0,184,60,14,15,255,255,248,60,14,15,64,0,184,60,14,15,255,255,248,60,14,5,181,95,80,63,254,2,248,31,208,63,254,127,224,2,253,60,0,126,0,0,125,0,0,0,0,0,0,
  // 0x8b8a  變
  138,139,24,25,150,26,1,253,2,192,63,248,15,0,7,128,21,80,45,0,47,44,85,85,248,240,61,124,255,255,242,224,15,240,0,0,255,128,7,216,63,248,47,112,11,78,21,80,60,120,191,255,127,251,255,253,123,251,149,83,239,175,1,208,0,0,11,0,46,238,63,252,235,120,61,219,56,61,219,44,117,215,120,63,203,14,177,210,191,255,139,13,1,219,208,0,11,0,0,47,255,255,255,252,1,255,255,255,255,252,15,255,64,2,244,0,63,139,224,15,208,0,29,1,254,191,64,0,0,0,127,253,0,0,0,111,255,255,249,64,191,255,228,27,255,254,63,233,0,0,107,252,16,0,0,0,0,4,
  // 0x8cc7  資
  199,140,24,26,156,26,1,253,0,0,1,64,0,0,14,64,3,208,0,0,31,249,11,234,170,184,1,190,47,255,255,252,0,8,189,15,192,240,0,0,180,47,211,224,0,110,0,126,244,64,111,254,7,248,190,64,127,228,191,208,47,249,57,0,121,0,6,252,1,255,255,255,255,148,1,250,170,170,175,128,1,240,0,0,15,128,1,245,85,85,95,128,1,255,255,255,255,128,1,240,0,0,15,128,1,245,85,85,95,128,1,255,255,255,255,128,1,240,0,0,15,128,1,250,170,170,175,128,1,255,255,255,255,128,0,2,128,2,144,0,0,127,208,11,254,0,47,254,0,0,127,224,47,144,0,0,7,248,4,0,0,0,0,64,
  // 0x8ddd  距
  221,141,24,24,144,26,1,253,47,255,241,255,255,254,47,255,241,255,255,254,45,0,241,240,0,0,45,0,241,240,0,0,45,0,241,240,0,0,45,0,241,240,0,0,47,255,241,255,255,248,47,255,241,255,255,248,0,124,1,245,85,248,0,60,1,240,0,248,20,60,1,240,0,248,60,60,1,240,0,248,60,63,245,240,0,248,60,63,245,244,0,248,60,60,1,255,255,248,60,60,1,255,255,248,60,60,1,240,0,0,60,60,5,240,0,0,61,127,253,240,0,0,127,255,249,244,0,0,255,249,1,255,255,255,249,0,1,255,255,255,0,0,1,240,0,0,0,0,0,80,0,0,
  // 0x8eca  車
  202,142,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,63,255,255,255,255,252,63,255,255,255,255,252,0,0,7,208,0,0,0,0,7,192,0,0,3,255,255,255,255,192,3,255,255,255,255,192,3,208,7,192,7,192,3,208,7,192,7,192,3,255,255,255,255,192,3,255,255,255,255,192,3,208,7,192,7,192,3,208,7,192,7,192,3,255,255,255,255,192,3,255,255,255,255,192,0,0,7,192,0,0,0,0,7,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,7,208,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,7,192,0,0,0,0,1,64,0,0,
  // 0x8edf  軟
  223,142,24,26,156,26,1,253,0,0,0,4,0,0,0,60,0,31,0,0,0,60,0,31,0,0,191,255,254,47,0,0,191,255,254,62,0,0,0,60,0,62,0,0,0,60,0,63,255,254,42,255,168,191,255,253,63,255,252,248,244,60,60,60,61,240,244,60,60,60,63,240,244,124,62,190,191,208,244,184,63,255,253,192,244,180,60,60,60,0,248,0,60,60,60,0,248,0,63,255,252,1,252,0,63,255,252,2,253,0,0,60,0,3,222,0,0,60,0,11,143,0,255,255,255,15,79,128,255,255,255,63,7,192,0,60,0,188,3,240,0,60,3,244,0,253,0,60,15,224,0,127,0,60,7,64,0,29,0,20,0,0,0,0,
  // 0x8ef8  軸
  248,142,23,26,156,26,1,253,0,0,0,0,80,0,0,124,0,0,180,0,0,124,0,0,180,0,191,255,252,0,180,0,191,255,252,0,180,0,0,124,0,0,180,0,0,124,0,255,255,252,42,254,164,255,255,252,63,255,248,240,184,60,56,56,120,240,180,60,56,56,120,240,180,60,62,190,248,240,180,60,63,255,248,240,180,60,56,56,120,240,184,60,56,56,120,255,255,252,63,255,248,255,255,252,63,255,244,240,180,60,0,124,0,240,180,60,0,124,0,240,180,60,255,255,253,240,180,60,255,255,253,240,180,60,0,124,0,240,184,60,0,124,0,255,255,252,0,124,0,255,255,252,0,124,0,240,0,60,0,20,0,80,0,20,
  // 0x8f09  載
  9,143,24,25,150,26,1,253,0,15,64,15,130,0,0,15,64,15,143,192,31,255,255,207,131,240,31,255,255,143,128,252,0,15,64,15,128,32,191,255,255,255,255,254,191,255,255,255,255,254,0,15,64,11,192,0,0,15,64,11,192,64,63,255,255,199,192,244,42,175,234,135,192,244,0,15,64,7,194,240,31,255,255,195,195,224,30,95,87,195,215,192,30,15,71,195,239,128,31,255,255,194,255,0,29,11,3,194,254,0,30,95,87,193,252,0,31,255,255,194,248,13,0,15,0,11,252,15,63,255,255,239,253,15,63,255,255,255,63,46,0,15,2,252,31,253,0,15,0,224,7,248,0,5,0,0,0,64,
  // 0x8f2f  輯
  47,143,24,25,150,26,1,253,0,124,0,127,255,244,0,124,0,127,255,248,191,255,252,124,0,248,191,255,252,124,0,248,0,124,0,127,255,248,0,124,0,127,255,248,42,254,164,0,0,0,63,255,248,0,0,0,56,56,123,255,255,255,56,56,123,255,255,255,62,190,248,124,0,184,63,255,248,124,0,184,56,56,120,127,255,248,56,56,120,126,170,248,63,255,248,124,0,184,63,255,244,127,255,248,0,124,0,127,255,248,0,124,0,124,0,184,255,255,253,124,0,184,255,255,253,126,191,255,0,124,7,255,255,255,0,124,3,233,80,184,0,124,0,0,0,184,0,124,0,0,0,184,0,20,0,0,0,0,
  // 0x8f38  輸
  56,143,24,26,156,26,1,253,0,80,0,0,80,0,0,240,0,2,248,0,0,240,0,7,253,0,191,255,240,15,175,0,191,255,240,63,15,192,0,244,0,252,3,240,0,240,3,240,0,254,63,255,239,255,255,191,127,255,251,47,255,74,116,176,224,0,0,0,116,176,224,0,0,20,126,250,227,255,128,44,127,255,227,255,142,44,116,176,227,131,142,44,116,176,227,131,142,44,127,255,227,255,142,44,42,254,163,235,142,44,0,240,3,131,142,44,0,244,3,235,142,44,255,255,247,255,142,44,255,255,247,131,142,44,0,240,3,131,128,44,0,240,3,131,128,44,0,240,3,139,131,252,0,240,3,143,67,248,0,80,0,0,0,0,
  // 0x8f49  轉
  73,143,24,26,156,26,1,253,0,0,0,0,80,0,0,184,0,0,240,0,0,184,3,255,255,253,191,255,247,255,255,254,191,255,244,0,240,0,0,184,0,85,249,84,0,184,2,255,255,252,42,254,162,208,240,60,63,255,242,229,245,124,56,116,178,255,255,252,56,116,178,208,240,60,62,254,242,229,249,124,63,255,242,255,255,252,56,116,176,0,240,240,56,116,181,106,250,252,63,255,247,255,255,254,63,255,240,0,7,205,0,184,7,255,255,255,0,184,7,255,255,255,255,255,252,116,7,192,255,255,252,124,7,192,0,184,0,47,7,192,0,184,0,14,7,192,0,184,0,1,255,192,0,184,0,0,254,0,0,80,0,0,0,0,
  // 0x8fd1  近
  209,143,24,25,150,26,1,253,8,0,0,0,27,208,63,0,9,175,255,240,31,192,31,255,249,0,7,240,31,148,0,0,0,244,31,0,0,0,0,64,31,0,0,0,0,0,31,0,0,0,0,0,31,255,255,254,0,0,31,255,255,254,0,0,31,85,125,84,191,240,47,0,124,0,191,240,46,0,124,0,1,240,62,0,124,0,1,240,61,0,124,0,1,240,124,0,124,0,1,240,248,0,124,0,1,241,244,0,124,0,1,243,240,0,124,0,1,242,208,0,124,0,3,248,64,0,124,0,31,254,0,0,20,0,191,111,249,85,85,85,189,7,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x8fd4  返
  212,143,24,25,150,26,1,253,8,0,0,0,0,0,63,0,63,255,255,252,47,192,63,255,255,252,7,240,61,0,0,0,1,240,61,0,0,0,0,64,61,0,0,0,0,0,63,255,255,240,0,0,63,255,255,240,0,0,62,240,3,224,0,0,60,244,3,208,191,240,124,188,11,192,191,240,124,125,15,128,2,240,124,63,63,0,2,240,184,15,253,0,2,240,244,11,252,0,2,241,240,7,248,0,2,242,240,47,255,0,2,243,225,255,127,224,2,247,207,252,11,254,7,245,67,208,1,252,31,254,1,0,0,20,191,111,229,85,85,85,252,11,255,255,255,254,112,0,111,255,255,253,0,0,0,0,0,0,
  // 0x9000  退
  0,144,24,24,144,26,1,253,46,0,47,255,255,208,63,192,47,255,255,208,11,240,46,0,3,208,2,248,46,0,3,208,0,176,47,255,255,208,0,0,47,255,255,208,0,0,46,0,3,208,0,0,46,0,3,208,0,0,47,255,255,208,191,240,47,255,255,208,191,240,46,7,192,116,1,240,46,3,210,252,1,240,46,2,255,224,1,240,46,0,255,64,1,240,46,0,189,0,1,240,46,27,127,64,1,240,127,255,79,228,1,241,255,249,3,253,3,248,249,0,0,188,31,254,64,0,0,0,191,111,249,85,85,85,189,7,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x901f  速
  31,144,24,26,156,26,1,253,0,0,0,5,0,0,8,0,0,15,64,0,63,0,0,15,64,0,31,210,255,255,255,253,7,246,255,255,255,253,1,244,0,15,64,0,0,80,0,15,64,0,0,0,191,255,255,244,0,0,191,255,255,244,0,0,184,15,64,244,0,0,184,15,64,244,191,240,184,15,64,244,191,240,191,255,255,244,1,240,191,255,255,244,1,240,0,191,224,0,1,240,1,255,248,0,1,240,7,223,191,0,1,240,47,143,79,208,1,241,254,15,67,248,1,243,248,15,64,253,3,248,208,15,64,36,31,254,0,15,64,0,191,111,249,85,85,85,189,7,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x9023  連
  35,144,24,26,156,26,1,253,0,0,0,5,0,0,4,0,0,15,0,0,61,0,0,15,0,0,63,131,255,255,255,252,11,211,255,255,255,252,3,240,0,15,0,0,0,208,170,191,170,160,0,0,255,255,255,240,0,0,244,15,1,240,0,0,244,15,1,240,0,0,255,255,255,240,255,224,254,175,171,240,255,224,244,15,1,240,2,224,254,191,235,240,2,224,255,255,255,240,2,224,0,15,0,0,2,224,0,15,0,0,2,231,255,255,255,254,2,231,255,255,255,254,2,224,0,15,0,0,7,240,0,15,0,0,31,253,0,10,0,0,191,63,229,0,0,85,188,11,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x9032  進
  50,144,24,25,150,26,1,253,4,0,7,192,120,0,61,0,15,192,188,0,63,64,31,128,244,0,15,208,63,1,240,0,3,240,191,255,255,252,0,225,255,255,255,252,0,3,252,3,208,0,0,31,252,3,208,0,0,31,191,255,255,244,0,5,63,255,255,244,255,224,60,3,208,0,255,224,60,3,208,0,2,224,60,3,208,0,2,224,63,255,255,240,2,224,63,255,255,240,2,224,60,3,208,0,2,224,60,3,208,0,2,224,63,255,255,253,2,224,63,255,255,253,7,240,0,0,0,0,31,253,0,0,0,0,191,63,229,0,0,85,188,11,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x904b  運
  75,144,24,25,150,26,1,253,4,2,255,255,255,252,61,3,255,255,255,252,63,131,208,5,0,60,15,210,128,15,0,40,3,240,170,191,234,164,0,224,255,255,255,244,0,0,0,15,0,0,0,0,0,15,0,0,0,0,191,255,255,240,0,0,190,175,170,240,255,224,184,15,1,240,255,224,191,255,255,240,2,224,189,111,150,240,2,224,184,15,1,240,2,224,191,255,255,240,2,224,106,175,170,144,2,224,0,15,0,0,2,227,255,255,255,254,2,227,255,255,255,253,7,240,0,15,0,0,31,253,0,15,0,0,191,63,229,0,0,85,188,11,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x9054  達
  84,144,24,26,156,26,1,253,0,0,0,5,0,0,24,0,0,15,0,0,126,0,106,191,234,160,47,192,191,255,255,240,11,224,0,15,0,0,2,240,0,15,0,0,0,215,255,255,255,254,0,3,255,255,255,253,0,0,15,128,31,0,0,0,7,192,61,0,0,2,255,255,255,252,255,227,255,255,255,252,255,224,0,15,0,0,2,224,0,15,0,0,2,224,191,255,255,244,2,224,170,191,234,160,2,224,0,15,0,0,2,227,255,255,255,253,2,227,255,255,255,253,2,224,0,15,0,0,7,244,0,15,0,0,31,253,0,5,0,0,191,63,229,0,0,85,188,11,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x9078  選
  120,144,24,25,150,26,1,253,4,2,170,161,170,164,124,3,255,243,255,248,63,0,0,240,0,184,15,192,0,240,0,184,7,227,255,241,255,248,2,195,234,161,250,164,0,3,208,41,240,13,0,2,255,252,255,254,0,0,170,160,106,168,0,0,2,128,40,0,255,208,3,192,60,0,255,211,255,255,255,252,3,210,255,255,255,248,3,208,3,192,60,0,3,208,3,192,60,0,3,219,255,255,255,254,3,219,255,255,255,254,3,208,3,208,45,0,3,208,47,128,47,192,7,242,254,0,7,248,31,253,224,0,0,180,191,63,148,0,0,1,252,11,255,255,255,255,112,1,191,255,255,253,0,0,0,0,0,0,
  // 0x9084  還
  132,144,24,25,150,26,1,253,4,0,85,85,85,80,61,1,255,255,255,244,63,129,224,240,240,244,11,225,224,240,240,244,2,241,255,255,255,244,0,192,85,85,85,80,0,0,0,0,0,0,0,11,255,255,255,254,0,6,170,170,170,169,0,0,21,85,85,64,255,224,191,255,255,224,255,224,184,0,3,224,2,224,184,0,3,224,2,224,191,255,255,224,2,224,21,191,149,244,2,224,2,255,194,240,2,224,31,255,255,128,2,225,255,95,191,64,2,227,248,31,15,252,7,240,128,31,1,188,31,253,0,30,0,0,191,63,229,0,0,85,188,11,255,255,255,254,48,0,111,255,255,253,0,0,0,0,0,0,
  // 0x908a  邊
  138,144,24,26,156,26,1,253,0,0,0,5,0,0,14,0,0,31,0,0,31,208,63,255,255,208,7,244,60,0,3,208,0,244,63,255,255,208,0,16,60,0,3,208,20,0,63,255,255,208,127,0,60,0,3,208,31,208,63,255,255,208,3,224,0,31,0,0,0,67,255,255,255,253,0,3,213,230,229,125,0,3,194,209,209,253,255,224,95,129,255,192,255,224,254,15,21,0,3,227,255,255,255,254,2,225,85,245,85,84,2,224,2,245,85,64,2,224,7,255,255,192,2,224,111,128,11,128,7,246,254,1,95,0,31,255,228,3,254,0,191,63,229,0,0,21,252,11,255,255,255,254,112,0,191,255,255,253,0,0,0,0,0,0,
  // 0x90e8  部
  232,144,24,25,150,26,1,253,0,31,0,0,0,0,0,31,0,11,255,253,0,31,0,11,255,255,127,255,255,203,213,125,127,255,255,203,128,188,1,0,24,11,128,248,7,128,61,11,129,240,3,192,60,11,130,240,3,208,184,11,131,208,2,144,116,11,135,192,255,255,255,219,139,192,255,255,255,219,131,224,0,0,0,11,128,244,0,0,0,11,128,124,15,255,255,11,128,61,15,255,255,11,128,61,15,0,31,11,128,62,15,0,15,11,128,61,15,0,15,11,133,189,15,0,15,11,143,252,15,0,31,11,139,224,15,255,255,11,128,0,15,255,255,11,128,0,15,0,15,11,128,0,5,0,5,5,64,0,
  // 0x91cb  釋
  203,145,24,26,156,26,1,253,0,0,64,0,0,0,1,175,226,170,170,168,191,254,71,255,255,252,105,244,7,139,29,60,0,180,151,139,29,60,56,180,247,139,29,60,60,180,231,255,255,252,44,182,210,171,250,168,29,183,192,1,240,0,24,181,66,255,255,244,255,255,241,171,250,160,255,255,240,1,240,0,1,244,10,171,250,170,3,248,15,255,255,255,7,254,0,116,3,192,11,255,192,60,7,192,15,183,224,44,11,0,45,180,235,255,255,253,60,180,70,171,250,169,248,180,0,1,240,0,240,180,2,171,250,168,96,180,3,255,255,252,0,180,0,1,240,0,0,180,0,1,240,0,0,180,0,1,240,0,0,80,0,0,80,0,
  // 0x91cd  重
  205,145,24,24,144,26,1,254,0,0,5,106,255,64,7,255,255,255,255,128,3,255,175,229,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,7,192,0,0,0,0,7,192,0,0,3,255,255,255,255,192,3,250,175,234,175,192,3,224,7,192,7,192,3,255,255,255,255,192,3,250,171,234,175,192,3,224,7,192,7,192,3,250,175,234,175,192,3,255,255,255,255,192,0,0,7,192,0,0,0,0,7,192,0,0,11,255,255,255,255,240,11,255,255,255,255,240,0,0,7,192,0,0,0,0,7,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x91cf  量
  207,145,24,24,144,26,1,254,0,85,85,85,85,0,1,255,255,255,255,64,1,240,0,0,15,64,1,255,255,255,255,64,1,245,85,85,95,64,1,245,85,85,95,64,1,255,255,255,255,64,0,0,0,0,0,0,191,255,255,255,255,254,127,255,255,255,255,254,0,0,0,0,0,0,3,255,255,255,255,192,3,229,91,213,91,192,3,229,87,213,91,192,3,255,255,255,255,192,3,208,3,192,7,192,3,255,255,255,255,192,1,85,91,213,85,64,0,0,3,192,0,0,7,255,255,255,255,224,6,170,171,234,170,144,0,0,3,192,0,0,191,255,255,255,255,254,191,255,255,255,255,254,
  // 0x91dd  針
  221,145,24,26,156,26,1,253,0,20,0,0,0,0,0,191,0,0,188,0,0,255,192,0,188,0,3,243,240,0,188,0,11,192,252,0,188,0,31,64,127,0,188,0,190,0,47,0,188,0,255,255,252,0,188,0,47,255,240,0,188,0,0,61,1,85,189,85,0,61,2,255,255,255,0,61,2,255,255,255,127,255,253,0,188,0,127,255,253,0,188,0,0,61,0,0,188,0,4,61,40,0,188,0,44,61,60,0,188,0,29,61,120,0,188,0,14,61,180,0,188,0,15,61,240,0,188,0,9,61,4,0,188,0,0,63,254,0,188,0,127,255,254,0,188,0,127,254,64,0,188,0,37,0,0,0,188,0,0,0,0,0,20,0,
  // 0x9215  鈕
  21,146,24,25,150,26,1,254,0,80,0,0,0,0,0,253,0,0,0,0,2,255,66,255,255,240,7,219,210,255,255,240,15,130,244,95,150,240,47,0,248,15,65,240,188,0,48,15,65,240,255,255,208,15,1,240,47,255,208,15,1,240,0,180,0,15,1,240,0,180,0,31,2,240,0,180,1,111,86,245,127,255,247,255,255,255,127,255,247,255,255,255,0,180,0,46,2,224,36,180,224,62,2,224,60,180,224,61,3,224,44,181,208,61,3,224,29,182,192,61,3,208,30,182,192,60,3,208,4,180,84,124,3,208,1,255,248,124,3,208,191,255,255,255,255,255,127,148,31,255,255,255,16,0,5,85,85,85,
  // 0x932f  錯
  47,147,24,26,156,26,1,253,0,80,0,20,1,64,0,252,0,45,7,128,2,255,0,45,7,128,7,219,192,46,11,128,15,131,243,255,255,253,47,0,255,255,255,253,188,0,48,45,7,128,255,255,208,45,7,128,47,255,208,45,7,128,0,180,0,62,11,128,0,180,15,255,255,255,0,180,15,255,255,255,127,255,240,0,0,0,127,255,240,0,0,0,0,180,0,255,255,244,4,180,144,255,255,244,60,180,240,240,0,244,44,181,208,240,0,244,29,182,192,255,255,244,29,183,192,255,255,244,4,180,0,240,0,244,0,191,244,240,0,244,127,255,244,255,255,244,191,249,0,255,255,244,36,0,0,240,0,244,0,0,0,80,0,0,
  // 0x9375  鍵
  117,147,24,25,150,26,1,253,1,244,0,0,45,0,3,252,0,0,45,0,7,255,63,227,255,252,15,143,255,211,255,252,47,3,211,192,45,60,188,1,131,223,255,255,255,255,71,95,255,255,63,255,75,0,45,60,1,224,15,0,45,60,1,224,31,247,255,252,1,224,47,247,255,248,191,255,184,176,45,0,191,255,128,240,45,0,1,224,60,251,255,252,33,227,108,231,255,252,53,227,110,224,45,0,57,231,31,223,255,254,45,235,15,207,255,254,45,234,11,128,45,0,21,224,15,192,45,0,1,251,239,224,45,0,111,255,253,254,64,0,191,250,248,63,255,255,100,2,224,6,255,254,0,0,0,0,0,0,
  // 0x9577  長
  119,149,24,24,144,26,1,253,0,63,255,255,255,192,0,63,255,255,255,192,0,61,0,0,0,0,0,61,0,0,0,0,0,63,255,255,255,0,0,63,255,255,255,0,0,61,0,0,0,0,0,63,255,255,255,0,0,63,255,255,255,0,0,61,0,0,0,0,0,61,0,0,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,125,3,224,1,208,0,61,2,240,3,240,0,61,0,252,47,208,0,61,0,190,254,0,0,61,0,47,244,0,0,61,0,15,224,0,0,61,91,227,254,0,6,191,255,224,191,228,15,255,250,64,31,254,15,228,0,0,1,188,0,0,0,0,0,0,
  // 0x9589  閉
  137,149,22,24,144,26,2,253,191,255,240,255,255,240,191,255,240,255,255,240,184,1,240,244,2,240,190,171,240,254,171,240,191,255,240,255,255,240,184,1,240,244,2,240,184,1,240,244,2,240,191,255,240,255,255,240,191,255,240,255,255,240,184,0,0,80,2,240,184,0,1,240,2,240,184,0,1,240,2,240,184,127,255,255,210,240,184,127,255,255,210,240,184,0,15,240,2,240,184,0,47,240,2,240,184,0,190,240,2,240,184,3,241,240,2,240,184,31,193,240,2,240,184,255,1,240,2,240,184,120,1,240,2,240,184,0,63,227,255,224,184,0,47,130,255,192,100,0,0,0,84,0,
  // 0x958b  開
  139,149,22,24,144,26,2,253,191,255,240,255,255,240,191,255,240,255,255,240,184,1,240,244,2,240,190,171,240,250,171,240,191,255,240,255,255,240,184,1,240,244,2,240,184,1,240,244,2,240,191,255,240,255,255,240,191,255,224,255,255,240,184,0,0,0,2,240,184,127,255,255,210,240,184,127,255,255,210,240,184,2,208,184,2,240,184,2,208,184,2,240,184,2,208,184,2,240,184,255,255,255,242,240,184,255,255,255,242,240,184,3,192,184,2,240,184,3,192,184,2,240,184,11,128,184,2,240,184,31,0,184,2,240,184,126,0,184,255,224,184,56,0,184,191,192,84,0,0,0,20,0,
  // 0x9593  間
  147,149,22,24,144,26,2,253,191,255,240,255,255,240,191,255,240,255,255,240,184,1,240,244,2,240,190,171,240,254,171,240,191,255,240,255,255,240,184,1,240,244,2,240,184,1,240,244,2,240,191,255,240,255,255,240,191,255,240,255,255,240,184,0,0,0,2,240,184,0,0,0,2,240,184,15,255,255,2,240,184,15,255,255,2,240,184,15,64,31,2,240,184,15,64,31,2,240,184,15,255,255,2,240,184,15,255,255,2,240,184,15,64,31,2,240,184,15,64,31,2,240,184,15,255,255,2,240,184,15,255,255,2,240,184,15,64,1,255,224,184,0,0,0,255,192,84,0,0,0,84,0,
  // 0x95dc  關
  220,149,22,24,144,26,2,253,191,255,240,255,255,240,190,171,240,254,171,240,184,1,240,244,1,240,191,255,240,255,255,240,190,170,240,250,171,240,184,1,240,244,1,240,190,171,240,254,171,240,191,255,240,255,255,240,184,7,64,60,1,240,184,30,1,176,1,240,184,188,183,215,65,240,184,46,209,238,1,240,184,15,160,185,129,240,184,14,116,241,209,240,184,255,255,255,241,240,184,84,25,80,97,240,184,52,177,209,193,240,184,52,177,210,193,240,184,57,177,230,193,240,184,63,241,255,193,240,184,1,225,208,2,240,184,11,193,208,63,224,184,14,1,208,63,208,80,0,0,0,4,0,
  // 0x964d  降
  77,150,23,26,156,26,2,253,0,0,0,16,0,0,0,0,0,124,0,0,255,253,0,248,0,0,255,254,2,255,255,128,240,60,7,255,255,128,240,124,31,208,31,0,240,180,191,240,62,0,240,240,244,189,252,0,241,240,16,63,240,0,242,208,0,47,240,0,241,240,2,255,254,64,240,184,127,244,63,248,240,60,255,65,246,244,240,61,96,1,240,0,240,45,63,255,255,240,240,45,63,255,255,240,244,61,11,129,240,0,247,252,7,129,240,0,243,244,7,129,240,0,240,1,255,255,255,248,240,1,255,255,255,248,240,0,0,1,240,0,240,0,0,1,240,0,240,0,0,1,240,0,240,0,0,1,240,0,80,0,0,0,80,0,
  // 0x9664  除
  100,150,23,26,156,26,2,253,0,0,0,5,0,0,0,0,0,63,64,0,255,253,0,191,192,0,255,253,1,246,240,0,240,60,7,224,252,0,240,124,31,192,63,64,240,180,190,0,15,224,240,243,248,0,3,252,241,227,239,255,255,184,242,208,15,255,255,16,240,240,0,31,0,0,240,184,0,31,0,0,240,60,0,31,0,0,240,61,191,255,255,240,240,45,191,255,255,240,240,45,0,31,0,0,244,61,0,31,0,0,247,252,46,31,15,0,243,244,60,31,15,128,240,0,188,31,7,192,240,1,244,31,2,240,240,3,224,31,0,244,240,7,192,31,0,184,240,1,3,255,0,0,240,0,2,253,0,0,0,0,0,0,0,0,
  // 0x968e  階
  142,150,23,25,150,26,2,253,0,0,120,2,224,0,255,253,120,2,224,0,255,253,120,2,225,240,244,60,127,246,255,240,244,120,127,246,255,64,244,244,120,2,244,0,244,240,120,2,224,0,245,224,120,2,224,60,246,208,126,250,224,60,245,227,255,245,255,248,244,246,249,21,191,240,244,124,0,62,0,0,244,60,0,61,0,0,244,60,63,255,255,224,244,61,63,255,255,224,244,60,60,0,2,224,247,252,60,0,2,224,247,240,63,255,255,224,244,0,63,255,255,224,244,0,60,0,2,224,244,0,60,0,2,224,244,0,63,255,255,224,244,0,63,255,255,224,244,0,61,0,2,224,80,0,0,0,0,0,
  // 0x96d9  雙
  217,150,24,25,150,26,1,253,2,210,208,11,75,0,3,195,192,15,15,0,11,235,233,47,191,168,15,255,254,63,255,252,63,75,64,253,29,0,191,159,150,254,110,84,255,255,255,255,255,248,27,75,65,173,29,0,11,175,168,46,191,164,11,255,252,47,255,248,11,75,64,45,29,0,11,175,170,47,191,169,11,255,255,47,255,254,0,0,0,0,0,0,31,255,255,255,255,64,31,255,255,255,255,64,0,47,0,0,190,0,0,31,208,3,252,0,0,7,248,31,224,0,0,0,255,255,64,0,0,1,191,254,64,0,5,191,255,255,254,148,127,255,228,27,255,253,63,228,0,0,111,248,0,0,0,0,0,16,
  // 0x96e2  離
  226,150,24,26,156,26,1,253,0,20,0,0,0,0,0,62,0,3,208,224,0,62,0,3,193,240,255,255,255,135,194,224,255,255,255,143,131,192,4,1,0,15,71,192,44,131,142,31,255,254,44,255,14,63,255,254,44,63,14,127,7,128,44,187,222,255,7,128,45,224,159,255,7,128,46,234,190,159,255,253,47,255,254,15,255,253,0,45,0,15,7,128,0,60,0,15,7,128,127,255,255,15,7,128,127,255,255,15,255,253,120,116,15,15,255,253,120,118,207,15,7,128,120,182,223,15,7,128,123,255,239,15,7,128,121,148,191,15,11,128,120,0,15,15,255,255,120,1,255,15,255,255,120,0,253,15,0,0,20,0,0,5,0,0,
  // 0x96fb  電
  251,150,23,23,138,26,2,254,31,255,255,255,255,64,31,255,255,255,255,64,0,0,15,0,0,0,255,255,255,255,255,240,250,170,191,170,170,240,240,0,15,0,0,240,242,255,143,47,248,240,241,85,15,21,80,240,81,85,15,21,84,80,3,255,143,47,253,0,0,0,15,0,0,0,10,170,170,170,170,0,15,255,255,255,255,0,15,128,31,0,47,0,15,128,31,0,47,0,15,255,255,255,255,0,15,234,175,170,191,0,15,128,31,0,47,0,15,255,255,255,255,16,15,234,191,170,170,60,11,64,31,0,0,124,0,0,15,255,255,244,0,0,7,255,255,224,
  // 0x9752  青
  82,151,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,11,255,255,255,255,240,15,255,255,255,255,240,0,0,7,192,0,0,0,0,7,192,0,0,3,255,255,255,255,192,2,255,255,255,255,128,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,255,255,255,255,0,0,244,0,0,31,0,0,255,255,255,255,0,0,254,170,170,191,0,0,244,0,0,31,0,0,254,170,170,191,0,0,255,255,255,255,0,0,244,0,0,31,0,0,244,0,0,31,0,0,244,0,15,255,0,0,244,0,15,248,0,0,0,0,0,0,0,
  // 0x975e  非
  94,151,24,25,150,26,1,253,0,1,240,15,0,0,0,1,240,15,0,0,0,1,240,15,0,0,0,2,240,15,64,0,63,255,240,15,255,253,63,255,240,15,255,253,0,1,240,15,0,0,0,1,240,15,0,0,0,1,240,15,0,0,0,2,240,15,64,0,47,255,240,15,255,252,47,255,240,15,255,252,0,1,240,15,0,0,0,2,240,15,0,0,0,2,245,15,0,0,1,111,255,15,64,0,255,255,254,15,255,255,191,239,192,15,255,255,80,15,128,15,0,0,0,63,0,15,0,0,0,189,0,15,0,0,3,248,0,15,0,0,47,224,0,15,0,0,31,64,0,15,0,0,4,0,0,5,0,0,
  // 0x9762  面
  98,151,24,24,144,26,1,253,127,255,255,255,255,254,127,255,255,255,255,254,21,85,95,213,85,84,0,0,15,192,0,0,0,0,15,64,0,0,0,0,31,64,0,0,31,255,255,255,255,244,31,255,255,255,255,244,31,2,208,11,64,244,31,2,208,11,64,244,31,2,255,255,64,244,31,2,255,255,64,244,31,2,208,11,64,244,31,2,208,11,64,244,31,2,208,11,64,244,31,2,255,255,64,244,31,2,255,255,64,244,31,2,208,11,64,244,31,2,208,11,64,244,31,3,224,15,129,244,31,255,255,255,255,244,31,255,255,255,255,244,31,0,0,0,0,244,5,0,0,0,0,80,
  // 0x9805  項
  5,152,24,24,144,26,1,253,0,0,47,255,255,255,21,85,111,255,255,255,191,255,192,3,240,0,191,255,192,3,208,0,1,240,7,255,255,252,1,240,7,255,255,252,1,240,7,192,0,124,1,240,7,192,0,124,1,240,7,234,170,252,1,240,7,255,255,252,1,240,7,192,0,124,1,240,7,192,0,124,1,240,7,234,170,252,1,246,231,255,255,252,1,255,247,192,0,124,31,255,135,192,0,124,255,228,7,255,255,252,189,0,7,255,255,252,0,0,0,16,0,0,0,0,1,248,15,128,0,0,27,248,11,244,0,1,255,128,1,255,0,0,248,0,0,46,0,0,0,0,0,0,
  // 0x9810  預
  16,152,24,24,144,26,1,253,127,255,251,255,255,254,127,255,251,255,255,254,0,7,208,1,244,0,8,15,128,1,240,0,47,191,1,255,255,248,11,252,1,255,255,252,0,254,1,240,0,124,0,47,1,240,0,124,255,255,254,250,170,252,255,255,253,255,255,252,0,244,185,240,0,124,0,244,245,240,0,124,0,244,241,250,170,252,0,245,225,255,255,252,0,244,65,240,0,124,0,244,1,240,0,124,0,244,1,255,255,252,0,244,1,255,255,252,0,244,0,4,0,0,0,244,0,62,7,192,0,244,2,253,7,244,63,240,47,240,0,254,47,224,47,64,0,46,4,0,4,0,0,0,
  // 0x984d  額
  77,152,24,26,156,26,1,253,0,20,0,0,0,0,0,124,0,0,0,0,0,124,1,255,255,254,191,255,255,255,255,254,191,255,253,0,248,0,180,80,45,0,244,0,180,240,45,191,255,252,2,250,160,191,255,252,7,255,240,184,0,124,31,66,224,184,0,124,191,131,208,190,170,252,251,255,128,191,255,252,16,191,0,184,0,124,0,255,192,184,0,124,3,255,244,190,170,252,47,225,253,191,255,252,255,64,124,184,0,124,127,255,240,184,0,124,15,255,240,191,255,252,15,1,240,191,255,252,15,1,240,0,0,0,15,1,240,30,3,192,15,255,240,191,7,244,15,255,251,248,0,253,15,0,11,208,0,47,0,0,0,0,0,4,
  // 0x985e  類
  94,152,24,25,150,26,1,253,20,60,36,0,0,0,60,60,126,255,255,254,30,60,181,255,255,254,13,60,160,0,248,0,191,255,253,0,240,0,191,255,253,191,255,252,1,253,0,191,255,252,3,255,128,180,0,124,15,255,240,180,0,124,63,60,253,190,170,252,252,60,44,191,255,252,32,60,0,180,0,124,0,124,0,180,0,124,0,124,0,190,170,252,191,255,253,191,255,252,191,255,253,180,0,124,0,188,0,180,0,124,0,189,0,191,255,252,0,255,128,191,255,252,3,251,224,9,1,64,15,209,252,63,71,224,127,128,121,254,2,252,189,0,31,244,0,127,32,0,7,128,0,30,0,0,0,0,0,0,
  // 0x98a8  風
  168,152,24,24,144,26,1,253,3,255,255,255,255,192,3,255,255,255,255,192,3,208,0,1,75,192,3,192,1,107,135,192,3,223,255,255,215,192,3,207,255,208,7,192,3,192,7,192,7,192,3,192,7,192,7,192,3,203,255,255,199,192,3,203,255,255,199,192,3,203,71,195,199,192,3,203,71,195,199,192,7,203,71,195,195,192,7,203,71,195,195,192,7,203,255,255,195,192,11,139,255,255,195,192,15,128,7,193,67,192,15,64,7,199,195,208,31,0,7,195,210,211,47,43,255,255,242,231,61,63,255,255,245,251,188,21,84,0,124,255,180,0,0,0,32,190,0,0,0,0,0,20,
  // 0x98fd  飽
  253,152,24,26,156,26,1,253,0,20,0,0,0,0,0,255,0,46,0,0,1,255,192,61,0,0,3,227,240,124,0,0,11,192,252,191,255,252,31,88,125,255,255,252,126,45,38,240,0,60,252,45,3,192,0,60,191,255,255,255,248,60,31,255,251,191,248,60,15,0,240,0,120,60,15,170,240,0,120,60,15,255,240,0,120,60,15,0,240,0,120,124,15,0,240,255,248,124,15,255,240,255,248,188,15,255,240,240,15,248,15,1,0,240,15,240,15,7,192,240,0,0,15,3,208,240,0,0,15,7,240,240,0,14,31,255,248,244,0,15,191,254,188,244,0,31,190,64,60,255,255,254,0,0,0,63,255,248,0,0,0,0,0,0,
  // 0x9918  餘
  24,153,24,26,156,26,1,253,0,0,0,0,80,0,0,252,0,3,244,0,2,255,64,7,252,0,3,219,208,15,255,0,15,130,244,47,31,128,63,170,244,126,11,208,254,255,81,252,3,244,176,0,7,240,0,254,26,170,175,208,0,127,31,255,235,191,255,237,30,1,224,127,255,208,31,170,224,0,240,0,31,255,224,0,240,0,30,1,231,255,255,253,30,1,231,255,255,253,31,255,224,0,240,0,31,170,144,0,240,160,30,0,0,240,240,240,31,255,241,224,240,248,31,255,227,208,240,124,30,0,7,192,240,61,31,255,255,64,240,47,31,255,246,0,240,29,30,0,0,47,240,0,30,0,0,31,208,0,0,0,0,0,0,0,
  // 0x99ac  馬
  172,153,24,24,144,26,1,253,2,255,255,255,255,224,2,255,255,255,255,224,2,224,3,208,0,0,2,224,3,208,0,0,2,255,255,255,255,128,2,255,255,255,255,128,2,224,3,208,0,0,2,224,3,208,0,0,2,255,255,255,255,128,2,255,255,255,255,128,2,224,3,208,0,0,2,224,3,208,0,0,2,224,3,224,0,0,2,255,255,255,255,253,2,255,255,255,255,252,0,0,0,0,0,124,7,129,1,130,208,124,11,135,131,209,240,124,15,67,193,224,184,188,31,3,192,240,52,248,62,3,208,244,1,244,252,3,208,64,191,240,36,0,0,0,127,208,0,0,0,0,0,0,
  // 0x9a45  驅
  69,154,24,24,144,26,1,253,63,255,243,255,255,253,63,255,243,255,255,253,60,60,3,192,0,0,60,60,3,194,255,240,63,255,211,194,229,240,63,255,211,194,192,240,60,60,3,194,192,240,60,60,3,194,192,240,63,255,227,194,255,240,63,255,211,193,170,144,60,60,3,192,0,0,60,60,3,207,243,253,63,255,243,206,179,173,63,255,243,204,115,77,0,0,243,204,115,77,53,76,243,204,115,77,55,106,243,204,115,77,55,115,243,207,243,253,115,51,243,202,161,168,179,52,243,192,0,0,225,0,243,255,255,255,64,1,227,255,255,255,0,63,211,192,0,0,0,30,65,64,0,0,
  // 0x9ad4  體
  212,154,24,26,156,26,1,253,0,0,0,1,5,0,15,255,224,3,143,0,15,255,224,3,143,0,15,0,224,255,255,252,15,0,224,251,239,188,15,63,224,243,142,60,15,58,224,255,255,252,15,52,224,251,239,188,15,52,224,243,142,60,127,255,253,251,239,188,126,170,189,255,255,252,116,0,44,0,0,0,126,170,190,170,170,170,15,255,226,255,255,255,15,1,224,0,0,0,15,171,224,191,255,248,15,255,224,186,170,184,15,1,224,180,0,120,15,1,224,185,85,184,15,255,224,191,255,248,15,171,224,13,2,192,15,1,224,15,3,192,15,1,224,15,7,128,15,31,227,255,255,255,15,15,131,255,255,255,0,0,0,0,0,0,
  // 0x9ad8  高
  216,154,22,26,156,26,2,253,0,0,5,0,0,0,0,0,31,0,0,0,0,0,31,0,0,0,255,255,255,255,255,240,255,255,255,255,255,240,0,0,0,0,0,0,0,170,170,170,160,0,0,255,255,255,240,0,0,244,0,1,240,0,0,244,0,1,240,0,0,254,170,171,240,0,0,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,63,255,255,255,255,208,63,255,255,255,255,208,60,0,0,0,3,208,60,10,170,170,3,208,60,15,255,255,3,208,60,15,0,15,3,208,60,15,0,15,3,208,60,15,170,191,3,208,60,15,255,255,3,208,60,15,0,2,255,192,60,5,0,1,255,128,20,0,0,0,64,0,
  // 0x9ec3  黃
  195,158,24,26,156,26,1,253,0,6,64,1,144,0,0,11,128,2,240,0,31,255,255,255,255,244,31,255,255,255,255,244,0,11,128,2,240,0,0,11,128,2,240,0,0,11,255,255,240,0,0,6,170,170,160,0,0,0,0,0,0,0,191,255,255,255,255,254,191,255,255,255,255,254,0,0,7,192,0,0,1,170,175,234,170,128,2,255,255,255,255,192,2,224,7,192,11,192,2,224,7,192,11,192,2,255,255,255,255,192,2,250,171,234,175,192,2,224,7,192,11,192,2,250,175,234,175,192,2,255,255,255,255,192,0,11,128,3,228,0,1,191,208,6,255,144,111,253,0,0,31,253,63,64,0,0,1,188,0,0,0,0,0,0,
  // 0x9ede  點
  222,158,24,26,156,26,1,253,0,0,0,0,84,0,42,170,169,0,184,0,63,255,253,0,184,0,60,44,29,0,184,0,63,108,237,0,184,0,62,172,237,0,184,0,61,237,221,0,191,255,61,238,93,0,191,255,60,44,29,0,184,0,62,190,189,0,184,0,63,255,253,0,184,0,0,60,0,0,184,0,0,60,0,0,184,0,63,255,254,127,255,252,63,255,253,127,255,252,0,60,0,124,0,124,0,63,191,124,0,124,191,255,255,124,0,124,186,149,0,124,0,124,0,70,56,124,0,124,44,215,45,124,0,124,60,227,143,124,0,124,60,243,203,191,255,252,184,178,193,127,255,252,240,80,0,124,0,124,0,0,0,20,0,20,
  // 0x9f4a  齊
  74,159,24,26,156,26,1,253,0,0,1,64,0,0,0,0,7,192,0,0,0,0,7,192,0,0,127,255,255,255,255,253,127,255,255,255,255,253,0,0,120,29,0,0,42,170,188,60,7,240,63,255,221,118,255,224,3,195,199,194,231,192,7,131,135,194,210,208,11,67,135,194,209,224,31,11,135,194,213,244,125,191,71,207,255,126,116,189,7,203,174,29,0,248,0,0,15,64,0,255,255,255,255,64,0,255,255,255,255,64,0,248,0,0,15,64,0,244,0,0,15,64,1,255,255,255,255,64,2,255,255,255,255,64,3,224,0,0,15,64,15,192,0,0,15,64,63,128,0,0,15,64,46,0,0,0,15,64,4,0,0,0,5,0,
  // 0xff1a  ：
  26,255,4,17,17,26,11,1,190,255,255,125,0,0,0,0,0,0,0,0,0,190,255,255,125,
};

#endif // HAS_GRAPHICAL_TFT
