/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Traditional Chinese 22pt, capital 'A' height: 16px, width: 100%, range: 0x22bf-0xff1a, glyphs: 307
extern const uint8_t NotoSans_Medium_Traditional_Chinese_16[36120] = {
  162,16,191,34,26,255,21,250, // unifont_t
  // 0x22bf  ⊿
  191,34,17,18,90,22,2,255,0,0,0,0,192,0,0,0,3,192,0,0,0,11,192,0,0,0,47,192,0,0,0,191,192,0,0,2,243,192,0,0,7,195,192,0,0,31,3,192,0,0,124,3,192,0,1,244,3,192,0,7,208,3,192,0,15,64,3,192,0,61,0,3,192,0,248,0,3,192,3,224,0,3,192,15,128,0,3,192,63,255,255,255,192,191,255,255,255,192,
  // 0x4e00  一
  0,78,20,2,10,22,1,7,255,255,255,255,255,255,255,255,255,255,
  // 0x4e09  三
  9,78,20,17,85,22,1,255,15,255,255,255,244,15,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,128,3,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,253,127,255,255,255,253,
  // 0x4e0a  上
  10,78,20,20,100,22,1,254,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,255,255,244,0,0,255,255,244,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,
  // 0x4e0b  下
  11,78,20,20,100,22,1,253,191,255,255,255,254,191,255,255,255,254,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,191,128,0,0,0,191,244,0,0,0,185,255,0,0,0,184,47,224,0,0,184,7,244,0,0,184,0,160,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,100,0,0,
  // 0x4e0d  不
  13,78,20,20,100,22,1,253,127,255,255,255,253,127,255,255,255,253,0,0,31,64,0,0,0,62,0,0,0,0,188,0,0,0,2,252,0,0,0,7,253,240,0,0,31,253,253,0,0,126,60,63,128,2,248,60,11,224,31,224,60,2,252,191,64,60,0,127,124,0,60,0,29,16,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,40,0,0,
  // 0x4e26  並
  38,78,20,21,105,22,1,254,0,0,0,4,0,0,240,0,15,128,0,184,0,31,0,0,60,0,61,0,0,45,0,124,0,63,255,255,255,252,63,255,255,255,252,0,7,130,208,0,0,7,130,208,0,10,7,130,208,244,15,7,130,208,240,11,71,130,209,240,7,199,130,210,224,3,199,130,211,192,3,215,130,211,192,2,215,130,219,64,1,151,130,215,0,0,7,130,208,0,0,7,131,208,0,191,255,255,255,255,191,255,255,255,255,
  // 0x4e2d  中
  45,78,18,22,110,22,2,253,0,0,80,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,255,255,255,255,240,255,255,255,255,240,240,0,240,1,240,240,0,240,1,240,240,0,240,1,240,240,0,240,1,240,240,0,240,1,240,255,255,255,255,240,255,255,255,255,240,240,0,240,1,240,80,0,240,0,64,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,160,0,0,
  // 0x4e3b  主
  59,78,20,21,105,22,1,254,0,0,64,0,0,0,2,240,0,0,0,0,252,0,0,0,0,63,0,0,0,0,15,64,0,47,255,255,255,248,47,255,255,255,248,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,11,255,255,255,224,11,255,255,255,224,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,191,255,255,255,255,191,255,255,255,255,
  // 0x4e4b  之
  75,78,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,63,255,255,255,244,63,255,255,255,248,0,0,0,3,240,0,0,0,11,192,0,0,0,31,64,0,0,0,62,0,0,0,0,248,0,0,0,3,240,0,2,224,15,192,0,3,208,63,0,0,11,225,252,0,0,15,251,224,0,0,47,127,64,0,0,61,31,228,0,0,252,7,255,255,255,176,0,107,255,254,0,0,0,0,0,
  // 0x4ea4  交
  164,78,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,0,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,4,0,20,0,0,62,0,125,0,0,252,0,47,128,3,240,0,7,240,31,192,0,17,252,191,46,0,188,126,40,15,0,244,24,0,11,130,240,0,0,3,215,208,0,0,2,255,128,0,0,0,255,0,0,0,2,255,128,0,0,31,239,244,0,6,255,66,255,128,191,248,0,47,254,127,64,0,2,253,16,0,0,0,4,
  // 0x4eae  亮
  174,78,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,106,170,190,170,169,191,255,255,255,254,0,0,0,0,0,1,85,85,85,64,2,255,255,255,192,2,208,0,7,192,2,229,85,91,192,2,255,255,255,192,0,0,0,0,0,106,170,170,170,169,127,255,255,255,253,116,10,1,64,29,116,15,2,224,29,0,31,2,224,0,0,46,2,224,0,0,60,2,224,4,0,252,2,224,14,11,240,2,224,30,255,128,1,255,253,120,0,0,191,248,
  // 0x4ee4  令
  228,78,20,22,110,22,1,253,0,0,104,0,0,0,0,254,0,0,0,2,255,128,0,0,11,199,224,0,0,47,65,248,0,0,189,0,126,0,3,244,0,31,192,31,239,255,251,248,191,47,255,248,255,184,0,0,0,47,16,0,0,0,4,0,0,0,0,0,15,255,255,255,208,15,255,255,255,208,0,2,224,2,208,0,2,224,2,208,0,2,224,2,208,0,2,224,2,208,0,2,224,191,208,0,2,224,127,128,0,2,224,0,0,0,1,144,0,0,
  // 0x4ef6  件
  246,78,20,22,110,22,1,253,0,0,0,16,0,0,180,0,240,0,0,240,240,240,0,2,224,240,240,0,3,193,240,240,0,11,130,255,255,252,15,67,255,255,252,63,71,192,240,0,191,79,64,240,0,255,79,0,240,0,247,65,0,240,0,71,64,0,240,0,7,79,255,255,255,7,79,255,255,255,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,6,64,0,160,0,
  // 0x4efd  份
  253,78,21,21,126,22,0,253,0,61,3,255,192,0,0,60,3,255,208,0,0,184,24,1,240,0,0,240,60,0,240,0,2,224,124,0,184,0,3,208,180,0,124,0,15,209,240,0,62,0,47,211,208,0,15,128,127,219,192,0,11,192,58,223,191,255,250,64,18,208,127,255,248,0,2,208,3,192,120,0,2,208,3,192,120,0,2,208,7,192,184,0,2,208,11,64,180,0,2,208,15,0,180,0,2,208,46,0,244,0,2,208,188,0,240,0,2,211,240,47,240,0,2,210,192,31,208,0,0,0,0,0,0,0,
  // 0x4f11  休
  17,79,21,22,132,22,0,253,0,4,0,0,0,0,0,15,0,60,0,0,0,46,0,60,0,0,0,60,0,60,0,0,0,184,0,60,0,0,1,240,0,60,0,0,3,243,255,255,255,192,11,243,255,255,255,192,47,240,1,255,0,0,126,240,3,255,128,0,56,240,3,255,192,0,0,240,11,190,224,0,0,240,31,60,240,0,0,240,61,60,184,0,0,240,188,60,61,0,0,241,240,60,31,0,0,247,224,60,15,192,0,251,128,60,3,192,0,242,0,60,0,0,0,240,0,60,0,0,0,240,0,60,0,0,0,80,0,36,0,0,
  // 0x4f4d  位
  77,79,21,21,126,22,0,254,0,4,0,0,0,0,0,30,0,60,0,0,0,61,0,60,0,0,0,124,0,60,0,0,0,244,0,60,0,0,1,242,255,255,255,128,3,226,255,255,255,128,15,224,0,0,0,0,63,224,24,0,104,0,125,224,44,0,124,0,52,224,45,0,184,0,0,224,30,0,244,0,0,224,15,0,240,0,0,224,15,1,240,0,0,224,11,65,224,0,0,224,11,66,208,0,0,224,11,67,192,0,0,224,0,7,192,0,0,224,0,11,64,0,0,227,255,255,255,192,0,227,255,255,255,192,
  // 0x4f4e  低
  78,79,22,21,126,22,0,253,0,61,0,0,40,0,0,124,1,111,254,0,0,244,255,255,144,0,1,240,250,95,0,0,3,224,240,15,0,0,7,208,240,15,0,0,15,208,240,15,0,0,63,208,255,255,255,192,126,208,255,255,255,192,50,208,240,11,64,0,2,208,240,7,128,0,2,208,240,3,192,0,2,208,240,3,192,0,2,208,240,3,192,0,2,208,251,250,208,0,2,215,255,245,224,208,2,211,228,0,240,208,2,208,0,0,121,192,2,210,255,255,127,192,2,210,255,255,69,0,0,64,0,0,0,0,
  // 0x4f5c  作
  92,79,20,22,110,22,1,253,0,16,0,0,0,0,124,15,0,0,0,244,31,0,0,1,240,62,0,0,3,208,63,255,255,7,192,191,255,255,15,193,241,224,0,47,195,209,224,0,191,203,193,224,0,255,207,65,255,254,167,193,1,255,254,7,192,1,224,0,7,192,1,224,0,7,192,1,224,0,7,192,1,255,255,7,192,1,255,255,7,192,1,224,0,7,192,1,224,0,7,192,1,224,0,7,192,1,224,0,7,192,1,224,0,1,64,0,144,0,
  // 0x4f9b  供
  155,79,20,22,110,22,1,253,0,16,20,1,64,0,180,60,3,192,0,240,60,3,192,2,224,60,3,192,3,192,60,3,192,11,139,255,255,255,31,75,255,255,255,63,64,60,3,192,255,64,60,3,192,251,64,60,3,192,139,64,60,3,192,11,64,60,3,192,11,79,255,255,255,11,79,255,255,255,11,64,0,0,0,11,64,40,1,64,11,64,124,7,192,11,64,244,2,240,11,67,240,0,184,11,79,192,0,61,11,75,0,0,30,5,0,0,0,0,
  // 0x4fdd  保
  221,79,20,22,110,22,1,253,0,16,0,0,0,0,185,255,255,248,0,242,255,255,252,1,226,208,0,60,3,194,208,0,60,11,194,208,0,60,15,130,208,0,60,63,130,255,255,252,191,130,255,255,252,251,128,0,240,0,147,128,0,240,0,3,143,255,255,255,3,143,255,255,255,3,128,11,253,0,3,128,31,255,0,3,128,61,247,192,3,128,248,242,240,3,131,240,240,252,3,159,192,240,63,3,143,0,240,15,3,132,0,240,0,1,64,0,160,0,
  // 0x4fe1  信
  225,79,21,22,132,22,0,253,0,4,0,0,0,0,0,30,42,170,168,0,0,61,63,255,252,0,0,124,0,0,0,0,0,244,0,0,0,0,1,243,255,255,255,192,3,226,170,170,170,128,15,224,0,0,0,0,47,224,63,255,254,0,126,224,42,170,169,0,52,224,0,0,0,0,0,224,63,255,253,0,0,224,42,170,169,0,0,224,0,0,0,0,0,224,106,170,169,0,0,224,127,255,255,0,0,224,116,0,31,0,0,224,116,0,31,0,0,224,116,0,31,0,0,224,127,255,255,0,0,224,126,170,175,0,0,144,100,0,9,0,
  // 0x500b  個
  11,80,21,21,126,22,0,253,0,120,0,0,0,0,0,181,255,255,255,64,0,241,255,255,255,64,2,225,208,40,11,64,3,209,208,56,11,64,11,193,214,190,155,64,31,193,223,255,251,64,63,193,208,56,11,64,127,193,208,56,11,64,54,193,209,125,75,64,2,193,211,255,203,64,2,193,211,65,203,64,2,193,211,65,203,64,2,193,211,65,203,64,2,193,211,255,203,64,2,193,209,85,75,64,2,193,208,0,11,64,2,193,255,255,255,64,2,193,255,255,255,64,2,193,208,0,11,64,1,128,64,0,0,0,
  // 0x503c  值
  60,80,20,22,110,22,1,253,0,0,0,80,0,0,244,0,240,0,0,240,0,240,0,2,235,255,255,253,3,203,255,255,253,11,128,2,208,0,15,65,171,234,160,63,66,255,255,240,191,66,192,0,176,255,66,229,85,240,155,66,255,255,240,11,66,192,0,176,11,66,192,0,176,11,66,255,255,240,11,66,229,85,240,11,66,192,0,176,11,66,255,255,240,11,66,229,85,240,11,66,192,0,176,11,91,250,170,254,11,111,255,255,255,6,0,0,0,0,
  // 0x504f  偏
  79,80,21,21,126,22,0,253,0,120,0,0,0,0,0,183,255,255,255,192,0,242,170,170,170,128,2,224,0,0,0,0,3,208,255,255,255,0,7,192,250,170,175,0,15,192,240,0,15,0,63,192,250,170,175,0,127,192,255,255,255,0,55,192,224,0,0,0,19,192,250,170,170,64,3,193,255,255,255,128,3,193,252,177,195,128,3,194,252,177,195,128,3,195,254,250,235,128,3,195,255,255,255,128,3,203,188,177,195,128,3,223,60,177,195,128,3,222,60,177,195,128,3,196,60,177,239,128,2,128,40,96,138,0,
  // 0x505c  停
  92,80,21,22,132,22,0,253,0,0,0,40,0,0,0,61,0,60,0,0,0,126,170,254,170,128,0,187,255,255,255,192,0,240,0,0,0,0,2,224,21,85,84,0,7,208,127,255,253,0,15,208,120,0,45,0,63,208,121,85,125,0,126,208,127,255,253,0,54,208,0,0,0,0,2,210,170,170,170,128,2,215,255,255,255,192,2,215,64,0,2,192,2,215,90,170,166,192,2,208,47,255,248,0,2,208,0,60,0,0,2,208,0,60,0,0,2,208,0,60,0,0,2,208,0,60,0,0,2,208,15,252,0,0,1,208,11,224,0,0,
  // 0x5075  偵
  117,80,21,22,132,22,0,253,0,4,0,36,0,0,0,30,0,124,0,0,0,60,0,126,170,128,0,124,0,127,255,128,0,244,0,124,0,0,2,240,0,124,0,0,3,224,191,255,254,0,15,224,186,170,190,0,63,224,176,0,30,0,125,224,191,255,254,0,52,224,185,85,110,0,0,224,176,0,30,0,0,224,191,255,254,0,0,224,185,85,110,0,0,224,176,0,30,0,0,224,186,170,174,0,0,224,191,255,254,0,0,224,1,0,64,0,0,224,31,130,248,0,0,225,254,0,127,0,0,227,244,0,15,192,0,80,64,0,1,0,
  // 0x5099  備
  153,80,21,22,132,22,0,253,0,16,5,0,80,0,0,120,11,0,240,0,0,247,255,255,255,192,0,243,255,255,255,192,2,208,11,0,240,0,3,192,10,0,160,0,11,192,0,0,0,0,15,195,255,255,255,192,63,195,255,255,255,192,127,195,192,0,0,0,55,195,207,255,255,128,19,195,207,175,171,128,3,195,207,11,3,128,3,195,207,91,87,128,3,195,207,255,255,128,3,195,207,11,3,128,3,195,143,91,87,128,3,199,79,255,255,128,3,203,15,11,3,128,3,223,15,11,3,128,3,221,15,11,63,64,1,128,5,1,25,0,
  // 0x50b3  傳
  179,80,21,22,132,22,0,253,0,0,0,20,0,0,0,61,0,60,0,0,0,127,255,255,255,192,0,245,170,190,170,64,0,240,0,60,0,0,2,224,255,255,255,0,7,208,240,60,15,0,15,208,255,255,255,0,63,208,240,60,15,0,127,208,240,60,15,0,54,208,255,255,255,0,2,208,0,60,61,0,2,211,255,255,255,64,2,210,170,149,247,192,2,208,0,0,240,0,2,215,255,255,255,192,2,214,190,170,250,128,2,208,61,0,240,0,2,208,31,0,240,0,2,208,11,128,240,0,2,208,1,47,240,0,1,64,0,26,128,0,
  // 0x50be  傾
  190,80,21,22,132,22,0,253,0,80,0,0,0,0,0,240,6,170,170,128,0,240,7,255,255,192,2,235,64,3,192,0,3,203,64,7,128,0,7,203,65,255,255,64,11,203,94,234,175,64,31,203,127,208,7,64,63,203,245,229,91,64,127,203,209,255,255,64,55,203,65,208,7,64,19,203,65,208,7,64,3,203,65,255,255,64,3,203,74,229,91,64,3,203,79,208,7,64,3,203,79,234,175,64,3,199,255,255,255,64,3,195,252,16,0,0,3,192,0,188,61,0,3,192,7,240,31,64,3,192,31,128,7,192,2,128,4,0,1,0,
  // 0x5132  儲
  50,81,21,22,132,22,0,253,0,0,0,1,0,0,0,182,169,7,3,128,0,247,254,7,7,128,1,224,0,47,171,0,3,213,85,127,255,0,3,207,255,71,29,0,15,192,0,7,124,0,31,194,169,111,254,128,63,199,255,191,255,192,127,192,0,3,220,0,51,194,169,15,11,0,3,199,255,63,171,0,3,192,0,255,255,64,3,198,170,158,7,64,3,199,255,14,7,64,3,199,11,15,175,64,3,199,11,15,255,64,3,199,11,14,7,64,3,199,175,14,7,64,3,199,255,15,255,64,3,199,0,15,175,64,1,65,0,5,1,0,
  // 0x5145  充
  69,81,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,127,255,255,255,253,127,255,255,255,253,0,15,128,16,0,0,31,0,188,0,0,46,0,63,0,0,60,0,15,192,47,255,255,255,240,63,255,255,255,248,0,0,0,0,124,0,15,0,240,16,0,15,0,240,0,0,31,0,240,0,0,46,0,240,0,0,60,0,240,15,0,248,0,240,15,11,240,0,240,15,191,192,0,255,254,121,0,0,127,252,0,0,0,0,0,
  // 0x5148  先
  72,81,20,22,110,22,1,253,0,0,20,0,0,0,240,60,0,0,1,240,60,0,0,2,224,60,0,0,3,255,255,255,240,7,255,255,255,240,11,64,60,0,0,31,0,60,0,0,29,0,60,0,0,0,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,15,1,240,0,0,30,1,240,0,0,46,1,240,0,0,61,1,240,0,0,124,1,240,13,1,244,1,240,15,7,224,1,240,30,127,192,0,255,253,125,0,0,191,248,16,0,0,0,0,
  // 0x5149  光
  73,81,20,22,110,22,1,253,0,0,40,0,0,1,0,60,0,128,15,64,60,1,240,7,192,60,2,224,3,208,60,3,192,1,240,60,11,128,0,240,60,15,0,0,144,60,9,0,0,0,60,0,0,191,255,255,255,254,191,255,255,255,255,0,15,1,224,0,0,31,1,224,0,0,30,1,224,0,0,61,1,224,0,0,60,1,224,0,0,248,1,224,15,2,240,1,224,15,31,208,1,240,15,255,64,0,255,254,116,0,0,191,248,0,0,0,0,0,
  // 0x5165  入
  101,81,20,20,100,22,1,253,0,255,253,0,0,0,255,253,0,0,0,0,45,0,0,0,0,46,0,0,0,0,110,0,0,0,0,255,0,0,0,0,255,0,0,0,1,255,64,0,0,2,235,128,0,0,3,211,192,0,0,11,195,224,0,0,15,129,240,0,0,47,0,252,0,0,125,0,125,0,0,252,0,47,64,3,240,0,15,208,31,192,0,3,248,191,64,0,0,255,124,0,0,0,45,16,0,0,0,0,
  // 0x5168  全
  104,81,20,21,105,22,1,254,0,0,104,0,0,0,0,254,0,0,0,2,255,128,0,0,11,199,208,0,0,31,66,244,0,0,190,0,190,0,2,248,0,47,128,15,208,0,7,244,127,64,0,1,254,250,255,255,255,174,17,255,255,255,68,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,7,255,255,255,208,7,255,255,255,208,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,63,255,255,255,253,63,255,255,255,253,
  // 0x5171  共
  113,81,20,22,110,22,1,253,0,20,0,20,0,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,63,255,255,255,252,63,255,255,255,252,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,24,0,96,0,0,62,0,253,0,0,252,0,47,128,7,240,0,11,224,63,128,0,1,252,61,0,0,0,124,0,0,0,0,16,
  // 0x5177  具
  119,81,20,21,105,22,1,253,1,170,170,170,64,2,255,255,255,128,2,208,0,7,128,2,208,0,7,128,2,255,255,255,128,2,229,85,91,128,2,208,0,7,128,2,255,255,255,128,2,229,85,91,128,2,208,0,7,128,2,250,170,171,128,2,255,255,255,128,0,0,0,0,0,0,0,0,0,0,191,255,255,255,254,191,255,255,255,254,0,8,0,16,0,0,191,0,254,64,31,248,0,47,244,127,128,0,1,253,16,0,0,0,16,
  // 0x5197  冗
  151,81,20,20,100,22,1,253,63,255,255,255,253,63,255,255,255,253,60,0,0,0,61,60,0,0,0,61,60,0,0,0,61,60,0,0,0,61,0,63,255,252,0,0,63,255,252,0,0,61,0,124,0,0,61,0,124,0,0,61,0,124,0,0,60,0,124,0,0,60,0,124,0,0,124,0,124,4,0,244,0,124,15,3,240,0,124,15,31,208,0,124,15,191,64,0,63,254,120,0,0,47,252,0,0,0,0,0,
  // 0x51b7  冷
  183,81,20,22,110,22,1,253,0,0,1,64,0,0,0,11,240,0,120,0,15,248,0,127,0,62,61,0,31,192,252,31,64,3,131,240,7,224,0,15,192,1,248,0,127,191,255,127,0,184,191,255,14,0,32,0,0,0,0,0,0,0,0,0,11,255,255,244,2,203,255,255,248,3,208,15,0,184,15,128,15,0,184,31,0,15,0,184,61,0,15,0,184,252,0,15,15,244,176,0,15,15,224,0,0,15,0,0,0,0,15,0,0,0,0,5,0,0,
  // 0x51c6  准
  198,81,20,22,110,22,1,253,0,0,16,0,0,0,0,60,11,128,56,0,124,15,64,127,0,244,15,0,31,193,240,30,0,3,211,255,255,254,0,71,255,255,254,0,15,224,60,0,0,63,224,60,0,0,61,255,255,252,0,1,255,255,252,0,1,224,60,0,1,129,224,60,0,3,209,224,60,0,11,193,255,255,252,15,65,255,255,252,46,1,224,60,0,124,1,224,60,0,248,1,224,60,0,112,1,255,255,255,0,1,255,255,255,0,1,144,0,0,
  // 0x51fa  出
  250,81,18,22,110,22,2,253,0,0,80,0,0,0,0,240,0,0,0,0,240,1,0,45,0,240,7,192,45,0,240,7,192,45,0,240,7,192,45,0,240,7,192,45,0,240,7,192,45,0,240,7,192,47,255,255,255,192,47,255,255,255,192,0,0,240,0,0,100,0,240,1,144,184,0,240,1,224,184,0,240,1,224,184,0,240,1,224,184,0,240,1,224,184,0,240,1,224,191,255,255,255,224,191,255,255,255,224,184,0,0,1,224,84,0,0,0,80,
  // 0x5206  分
  6,82,20,21,105,22,1,253,0,30,0,180,0,0,46,0,188,0,0,60,0,61,0,0,248,0,31,0,2,240,0,15,192,7,208,0,3,240,31,128,0,1,248,127,0,0,0,190,255,255,255,255,239,114,255,255,255,200,0,2,208,7,192,0,3,208,7,128,0,3,192,7,128,0,11,192,11,128,0,15,64,11,128,0,47,0,11,64,0,189,0,15,64,7,244,0,31,0,63,208,15,255,0,30,0,15,248,0,0,0,0,0,0,
  // 0x5217  列
  23,82,19,21,105,22,1,253,0,0,0,0,60,191,255,252,0,60,191,255,253,240,60,0,240,0,240,60,2,224,0,240,60,3,208,0,240,60,3,255,244,240,60,11,255,244,240,60,15,0,240,240,60,46,0,240,240,60,127,130,224,240,60,247,247,192,240,60,144,191,192,240,60,0,31,64,240,60,0,47,0,80,60,0,124,0,0,60,1,244,0,0,60,11,224,0,0,60,63,128,0,31,252,13,0,0,15,244,0,0,0,0,0,
  // 0x521d  初
  29,82,20,22,110,22,1,253,1,64,0,0,0,3,192,0,0,0,3,192,255,255,254,3,192,255,255,254,3,192,1,224,30,255,255,1,224,30,191,255,2,224,46,0,45,2,208,46,0,124,2,208,46,0,243,195,208,45,2,231,67,192,45,7,254,3,192,45,31,253,3,192,45,127,239,71,128,61,247,199,15,64,61,147,193,15,0,60,3,192,46,0,60,3,192,124,0,60,3,193,248,0,188,3,199,240,63,248,3,194,192,47,224,1,128,0,0,0,
  // 0x5230  到
  48,82,19,21,105,22,1,253,0,0,0,0,44,255,255,253,0,60,191,255,252,160,60,3,208,0,240,60,3,194,192,240,60,7,130,224,240,60,15,64,244,240,60,255,255,252,240,60,255,255,253,240,60,0,20,12,240,60,0,120,0,240,60,0,120,0,240,60,63,255,248,240,60,63,255,248,240,60,0,120,0,240,60,0,120,0,0,60,0,125,105,0,60,175,255,253,0,60,255,249,64,31,252,80,0,0,15,244,0,0,0,0,0,
  // 0x5236  制
  54,82,20,22,110,22,1,253,0,4,0,0,0,13,60,0,0,45,30,60,0,4,45,45,60,0,29,45,63,255,253,29,45,127,255,253,29,45,244,60,0,29,45,176,60,0,29,45,255,255,255,29,45,255,255,255,29,45,0,60,0,29,45,0,60,0,29,45,63,255,254,29,45,63,255,254,29,45,60,60,30,29,45,60,60,30,4,45,60,60,30,0,45,60,60,30,0,45,60,61,253,0,45,40,60,168,11,252,0,60,0,7,248,0,20,0,0,0,
  // 0x5237  刷
  55,82,20,21,105,22,1,253,0,0,0,0,45,47,255,254,0,45,47,255,254,60,45,44,0,30,60,45,44,0,30,60,45,47,255,254,60,45,47,255,254,60,45,44,11,0,60,45,44,11,0,60,45,62,175,233,60,45,63,255,254,60,45,62,203,14,60,45,62,203,14,60,45,62,203,14,60,45,58,203,14,40,45,118,203,14,0,45,182,203,190,0,45,242,139,100,0,45,224,11,0,15,252,0,11,0,7,244,0,0,0,0,0,
  // 0x5275  創
  117,82,19,22,110,22,1,253,0,4,0,0,0,0,63,0,0,60,0,255,208,0,60,2,242,244,116,60,11,192,126,180,60,47,255,237,180,60,252,85,64,180,60,101,85,84,180,60,15,255,252,180,60,15,0,60,180,60,15,255,252,180,60,15,85,124,180,60,15,85,124,180,60,15,255,252,180,60,30,0,0,180,60,30,85,84,180,60,47,255,252,0,60,63,192,44,0,60,187,192,44,0,60,243,255,252,15,252,83,234,188,15,244,1,64,4,0,0,
  // 0x529b  力
  155,82,19,22,110,22,1,253,0,0,160,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,63,255,255,255,252,63,255,255,255,252,0,1,240,0,124,0,2,224,0,124,0,2,224,0,120,0,3,208,0,120,0,7,192,0,184,0,11,128,0,180,0,15,64,0,180,0,47,0,0,244,0,62,0,0,240,0,252,0,0,240,3,240,0,1,240,15,208,0,3,224,127,64,3,255,208,60,0,2,255,64,0,0,0,0,0,
  // 0x52a0  加
  160,82,19,21,105,22,1,253,3,192,0,0,0,3,192,0,0,0,3,192,2,255,252,3,192,2,255,252,191,255,242,208,60,191,255,242,208,60,3,192,242,208,60,3,192,242,208,60,3,192,242,208,60,3,192,242,208,60,7,128,242,208,60,7,128,226,208,60,11,65,226,208,60,15,65,226,208,60,15,1,226,208,60,30,1,226,208,60,61,2,210,255,252,124,3,210,255,252,244,191,194,208,60,176,127,66,208,40,0,0,0,0,0,
  // 0x52d5  動
  213,82,20,21,105,22,1,253,1,107,240,60,0,191,255,224,60,0,21,180,0,60,0,170,250,164,60,0,255,255,252,60,0,0,116,7,255,254,127,255,250,191,254,121,185,180,60,30,112,116,116,60,30,127,255,244,60,29,117,185,116,120,29,117,185,180,120,45,127,255,244,180,45,0,116,0,240,45,21,185,80,240,45,127,255,250,224,60,0,116,3,192,60,1,186,191,128,60,255,255,255,15,248,169,64,60,15,240,0,0,0,0,0,
  // 0x5316  化
  22,83,20,21,105,22,1,253,0,45,30,0,0,0,60,30,0,0,0,184,30,0,0,1,240,30,0,0,3,224,30,0,52,11,208,30,1,252,31,208,30,11,240,127,208,30,127,128,255,208,31,248,0,243,208,31,208,0,131,208,30,0,0,3,208,30,0,0,3,208,30,0,0,3,208,30,0,0,3,208,30,0,9,3,208,30,0,15,3,208,30,0,15,3,208,31,0,15,3,208,15,255,254,3,208,7,255,248,1,64,0,0,0,
  // 0x534a  半
  74,83,20,22,110,22,1,253,0,0,40,0,0,6,64,60,1,208,11,192,60,3,224,3,208,60,7,192,2,240,60,15,128,0,240,60,31,0,0,160,60,29,0,0,0,60,0,0,31,255,255,255,248,31,255,255,255,248,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,20,0,0,
  // 0x5354  協
  84,83,20,22,110,22,1,253,5,0,0,0,0,11,64,0,240,0,11,64,0,240,0,11,64,255,255,252,11,64,171,234,188,11,64,3,192,60,255,248,15,64,56,255,252,125,0,180,11,67,244,15,240,11,65,128,11,144,11,64,224,3,128,11,65,208,3,128,11,74,250,107,233,11,95,255,127,255,11,66,199,71,78,11,66,199,75,14,11,67,199,79,14,11,67,135,15,14,11,75,75,45,14,11,79,11,124,29,11,108,127,176,252,6,68,40,0,164,
  // 0x5361  卡
  97,83,20,22,110,22,1,253,0,0,20,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,191,255,208,0,0,191,255,208,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,255,255,255,255,255,255,255,255,255,255,0,0,184,0,0,0,0,185,0,0,0,0,191,228,0,0,0,190,255,128,0,0,184,31,240,0,0,184,1,160,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,100,0,0,
  // 0x5370  印
  112,83,18,22,110,22,2,253,0,4,0,0,0,0,127,0,0,0,91,254,47,255,240,191,208,47,255,240,184,0,46,0,240,180,0,45,0,240,180,0,45,0,240,180,0,45,0,240,191,255,45,0,240,191,255,45,0,240,180,0,45,0,240,180,0,45,0,240,180,0,45,0,240,180,0,45,0,240,180,0,45,0,240,191,255,45,0,240,191,255,45,47,240,180,0,45,31,224,180,0,45,0,0,0,0,45,0,0,0,0,45,0,0,0,0,20,0,0,
  // 0x5378  卸
  120,83,20,22,110,22,1,253,1,0,0,0,0,7,128,0,0,0,15,0,1,255,253,15,255,245,255,253,63,255,245,208,45,124,56,1,208,45,180,56,1,208,45,16,56,1,208,45,255,255,253,208,45,191,255,249,208,45,0,56,1,208,45,44,56,1,208,45,44,63,241,208,45,44,62,161,208,45,44,56,1,208,45,44,56,1,208,61,44,56,21,211,252,45,191,253,210,244,255,255,229,208,0,255,148,1,208,0,64,0,1,208,0,0,0,1,144,0,
  // 0x537b  卻
  123,83,20,21,105,22,1,253,0,125,0,0,0,0,255,65,255,253,3,231,209,255,253,15,129,245,224,45,126,0,121,224,45,116,40,17,224,45,0,191,1,224,45,1,255,193,224,45,3,195,241,224,45,15,64,253,224,45,125,0,57,224,45,254,170,161,224,45,95,255,225,224,45,15,0,225,224,45,15,0,225,227,252,15,0,225,227,248,15,0,225,224,0,15,171,225,224,0,15,255,225,224,0,15,0,225,224,0,4,0,0,144,0,
  // 0x539f  原
  159,83,20,20,100,22,1,253,15,255,255,255,254,15,255,255,255,254,15,0,11,128,0,15,26,175,170,160,15,31,255,255,240,15,30,0,0,240,15,30,0,0,240,15,31,255,255,240,31,31,85,86,240,30,30,0,0,240,30,31,170,170,240,30,31,255,255,240,45,0,7,128,0,45,7,135,131,64,60,15,71,135,208,60,46,7,129,244,120,188,7,128,125,246,240,7,128,31,240,128,255,128,4,16,0,186,0,0,
  // 0x53cd  反
  205,83,20,20,100,22,1,253,7,255,255,255,252,7,255,255,255,252,7,128,0,0,0,7,128,0,0,0,7,128,0,0,0,7,128,0,0,0,7,255,255,255,224,7,255,255,255,208,7,143,64,3,192,7,135,192,11,192,11,131,208,15,64,11,65,240,63,0,15,64,248,188,0,15,0,63,244,0,31,0,31,224,0,46,0,127,244,0,61,7,253,255,64,188,191,224,47,249,180,190,0,2,252,0,16,0,0,20,
  // 0x53d6  取
  214,83,20,20,100,22,1,253,255,255,252,0,0,255,255,253,85,84,30,2,219,255,253,30,2,210,128,60,31,255,211,192,60,31,255,211,192,60,30,2,210,208,120,30,2,210,224,180,30,2,209,240,240,31,255,208,241,240,31,255,208,186,224,30,2,208,63,192,30,2,208,47,128,30,7,208,31,64,111,255,208,63,192,255,251,208,255,240,164,2,215,240,252,0,2,255,192,127,0,2,222,0,14,0,1,64,0,0,
  // 0x53f0  台
  240,83,20,22,110,22,1,253,0,1,0,0,0,0,7,208,0,0,0,15,192,0,0,0,31,64,36,0,0,63,0,62,0,0,125,0,31,128,0,248,0,7,224,127,254,191,255,244,127,255,255,255,252,1,85,0,0,63,0,0,0,0,12,0,0,0,0,0,3,255,255,255,192,3,255,255,255,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,255,255,255,192,3,255,255,255,192,2,128,0,2,128,
  // 0x5408  合
  8,84,20,22,110,22,1,253,0,0,20,0,0,0,0,254,0,0,0,2,255,128,0,0,7,215,208,0,0,31,66,248,0,0,126,0,190,0,2,248,0,47,192,15,224,0,7,248,191,191,255,254,191,248,127,255,253,30,0,0,0,0,0,0,0,0,0,0,2,255,255,255,128,2,255,255,255,192,2,208,0,3,192,2,208,0,3,192,2,208,0,3,192,2,208,0,3,192,2,208,0,3,192,2,255,255,255,192,2,255,255,255,192,1,128,0,2,128,
  // 0x5426  否
  38,84,20,20,100,22,1,253,127,255,255,255,253,127,255,255,255,253,0,0,63,0,0,0,0,252,0,0,0,7,252,116,0,0,127,188,191,64,7,253,60,15,240,127,224,60,1,254,190,0,60,0,46,32,0,60,0,0,0,0,20,0,0,3,255,255,255,208,3,255,255,255,208,3,192,0,3,208,3,192,0,3,208,3,192,0,3,208,3,192,0,3,208,3,255,255,255,208,3,255,255,255,208,2,128,0,2,128,
  // 0x544a  告
  74,84,20,22,110,22,1,253,0,0,5,0,0,0,240,46,0,0,1,240,46,0,0,3,224,46,0,0,7,255,255,255,240,15,255,255,255,240,47,0,46,0,0,61,0,46,0,0,4,0,46,0,0,191,255,255,255,254,191,255,255,255,254,0,0,0,0,0,0,0,0,0,0,3,255,255,255,192,3,255,255,255,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,255,255,255,192,3,255,255,255,192,3,192,0,3,192,1,128,0,1,64,
  // 0x547d  命
  125,84,21,22,132,22,1,253,0,0,104,0,0,0,0,0,255,0,0,0,0,3,255,192,0,0,0,15,195,240,0,0,0,127,0,253,0,0,2,248,0,47,192,0,31,239,255,251,248,0,255,31,255,244,255,64,248,0,0,0,31,0,0,0,0,0,0,0,15,255,199,255,244,0,15,255,199,255,244,0,15,3,199,128,180,0,15,3,199,128,180,0,15,3,199,128,180,0,15,3,199,128,180,0,15,255,199,128,180,0,15,255,199,143,240,0,15,0,7,143,224,0,14,0,7,128,0,0,0,0,7,128,0,0,0,0,6,64,0,0,
  // 0x548c  和
  140,84,19,21,105,22,1,253,0,7,192,0,0,6,255,208,0,0,191,249,7,255,252,37,244,7,255,252,0,180,7,128,60,0,180,7,128,60,255,255,247,128,60,255,255,247,128,60,1,244,7,128,60,3,252,7,128,60,7,255,7,128,60,11,255,135,128,60,14,183,215,128,60,45,181,231,128,60,124,180,135,128,60,244,180,7,128,60,224,180,7,255,252,64,180,7,255,252,0,180,7,128,60,0,180,6,64,36,0,96,0,0,0,
  // 0x555f  啟
  95,85,20,22,110,22,1,253,0,16,0,4,0,0,180,0,45,0,0,60,0,44,0,31,255,240,60,0,47,255,240,60,0,45,0,176,127,255,45,0,176,255,255,45,0,176,240,60,47,255,242,244,56,47,255,247,248,120,44,0,3,188,180,44,0,0,44,240,61,170,164,30,240,62,255,244,15,208,62,192,116,11,192,62,192,116,11,192,122,192,116,15,208,182,192,116,47,240,242,234,244,188,248,242,255,246,244,62,82,192,119,208,15,0,64,0,0,0,
  // 0x55ae  單
  174,85,20,21,105,22,1,253,5,85,65,85,80,15,255,211,255,244,14,2,211,128,180,14,87,211,213,180,15,255,211,255,244,0,0,0,0,0,11,255,255,255,224,11,234,190,171,224,11,64,60,1,224,11,255,255,255,224,11,234,190,170,224,11,64,60,1,224,11,234,190,171,224,11,255,255,255,224,0,0,60,0,0,0,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,0,60,0,0,0,0,60,0,0,0,0,40,0,0,
  // 0x5634  嘴
  52,86,20,22,110,22,1,253,0,0,4,9,0,0,0,28,29,0,127,227,92,29,124,127,243,95,223,224,112,243,94,94,0,112,243,92,29,5,112,243,110,158,11,112,255,255,223,255,112,255,174,1,84,112,240,63,254,0,112,240,249,125,0,112,243,245,125,84,112,255,255,255,252,127,245,224,176,60,127,224,255,255,252,112,0,240,180,60,112,1,224,176,60,0,2,255,255,252,0,3,213,85,124,0,11,128,0,60,0,47,0,11,248,0,4,0,2,80,
  // 0x5668  器
  104,86,20,21,105,22,1,253,10,170,130,170,164,31,255,195,255,244,29,3,195,192,180,29,3,195,192,180,29,3,195,192,180,31,255,195,255,244,10,170,246,170,164,0,0,244,0,0,191,255,255,255,254,255,255,255,255,255,0,63,0,248,0,2,252,0,63,64,31,224,0,15,244,255,255,195,255,255,191,171,195,234,254,15,3,195,128,240,15,3,195,128,240,15,3,195,128,240,15,255,195,255,240,15,171,195,234,240,9,1,65,64,80,
  // 0x5674  噴
  116,86,20,22,110,22,1,253,0,0,0,96,0,0,0,0,176,0,0,2,255,255,252,127,240,85,249,84,127,240,60,177,208,116,117,125,86,229,116,123,255,255,255,116,112,60,1,208,116,112,20,1,80,116,112,255,255,248,116,112,224,0,120,116,112,240,0,120,116,112,255,255,248,127,240,224,0,120,127,240,255,255,248,116,0,240,0,120,116,0,240,0,120,0,0,255,255,248,0,0,46,7,128,0,6,248,2,248,0,31,208,0,63,0,5,0,0,4,
  // 0x56de  回
  222,86,18,21,105,22,2,253,255,255,255,255,240,255,255,255,255,240,240,0,0,0,240,240,0,0,0,240,240,0,0,0,240,240,0,0,0,240,240,127,255,208,240,240,127,255,208,240,240,120,3,208,240,240,120,3,208,240,240,120,3,208,240,240,120,3,208,240,240,127,255,208,240,240,127,255,208,240,240,0,0,0,240,240,0,0,0,240,240,0,0,0,240,255,255,255,255,240,255,255,255,255,240,240,0,0,0,240,80,0,0,0,80,
  // 0x56e0  因
  224,86,18,21,105,22,2,253,255,255,255,255,240,255,255,255,255,240,240,0,0,0,240,240,0,240,0,240,240,0,240,0,240,240,0,240,0,240,240,0,224,0,240,243,255,255,252,240,243,255,255,252,240,240,2,244,0,240,240,3,248,0,240,240,3,252,0,240,240,15,159,0,240,240,47,15,128,240,240,189,3,224,240,243,244,1,252,240,242,128,0,36,240,240,0,0,0,240,255,255,255,255,240,255,255,255,255,240,160,0,0,0,160,
  // 0x56fa  固
  250,86,18,21,105,22,2,253,255,255,255,255,240,255,255,255,255,240,240,0,0,0,240,240,0,240,0,240,240,0,240,0,240,240,0,240,0,240,243,255,255,252,240,242,170,250,168,240,240,0,240,0,240,240,0,240,0,240,240,191,255,224,240,240,186,170,224,240,240,176,0,224,240,240,176,0,224,240,240,191,255,224,240,240,106,170,144,240,240,0,0,0,240,240,0,0,0,240,255,255,255,255,240,255,255,255,255,240,224,0,0,0,240,
  // 0x5716  圖
  22,87,18,21,105,22,2,253,170,170,170,170,160,255,255,255,255,240,224,0,0,0,176,224,127,255,208,176,224,116,1,208,176,224,116,1,208,176,224,127,255,208,176,224,0,240,0,176,231,255,255,253,176,224,0,0,0,176,224,255,255,240,176,224,208,0,176,176,224,215,252,176,176,224,215,12,176,176,224,215,252,176,176,224,224,0,176,176,224,255,255,240,176,224,0,0,0,176,255,255,255,255,240,250,170,170,170,240,144,0,0,0,96,
  // 0x5728  在
  40,87,20,22,110,22,1,253,0,1,0,0,0,0,3,208,0,0,0,3,192,0,0,0,11,192,0,0,191,255,255,255,254,191,255,255,255,254,0,61,0,0,0,0,124,0,240,0,0,244,0,240,0,2,224,0,240,0,11,192,0,240,0,47,194,255,255,248,191,194,255,255,248,247,192,0,240,0,83,192,0,240,0,3,192,0,240,0,3,192,0,240,0,3,192,0,240,0,3,192,0,240,0,3,199,255,255,254,3,203,255,255,254,1,64,0,0,0,
  // 0x578b  型
  139,87,20,21,105,22,1,254,0,0,0,0,20,47,255,252,16,56,63,255,252,120,56,3,194,208,120,56,3,194,208,120,56,3,194,208,120,56,191,255,254,120,56,127,255,253,120,56,7,130,208,120,56,15,66,208,16,56,47,2,208,0,120,188,2,208,15,248,32,1,124,11,160,0,0,60,0,0,11,255,255,255,208,11,255,255,255,224,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,
  // 0x57f7  執
  247,87,21,22,132,22,1,253,0,80,0,80,0,0,0,240,0,240,0,0,0,240,0,240,0,0,63,255,192,240,0,0,42,250,128,240,0,0,0,240,47,255,240,0,171,245,127,255,240,0,255,255,240,240,240,0,28,7,64,240,240,0,30,11,0,240,240,0,15,15,30,240,240,0,175,191,175,240,240,0,191,255,210,244,176,0,0,240,1,253,176,0,0,240,3,255,240,0,107,250,131,202,176,0,127,255,203,128,182,0,0,240,31,0,119,64,0,240,61,0,59,64,0,241,248,0,63,0,0,240,160,0,31,0,0,0,0,0,0,0,
  // 0x584a  塊
  74,88,20,22,110,22,1,253,1,64,0,80,0,7,128,1,240,0,7,128,2,224,0,7,130,255,255,252,7,130,250,250,188,191,250,192,240,60,255,250,234,250,188,7,130,255,255,252,7,130,192,240,60,7,130,192,240,60,7,130,234,250,188,7,130,255,255,252,7,136,60,116,128,7,252,60,117,196,111,248,60,118,204,255,64,124,123,238,244,0,184,123,255,0,1,240,116,4,0,7,224,116,11,0,63,192,127,255,0,62,0,47,253,0,0,0,0,0,
  // 0x586b  填
  107,88,20,22,110,22,1,253,0,0,0,96,0,7,64,0,240,0,7,66,170,250,170,7,71,255,255,255,7,64,0,240,0,7,64,21,245,80,255,248,191,255,240,255,248,176,0,176,7,64,191,255,240,7,64,181,85,240,7,64,180,0,240,7,64,191,255,240,7,64,176,0,176,7,172,191,255,240,11,252,21,85,80,127,238,170,170,170,254,15,255,255,255,160,0,4,1,0,0,0,126,7,208,0,7,244,1,252,0,15,128,0,63,0,1,0,0,4,
  // 0x588a  墊
  138,88,21,21,126,22,1,254,0,144,0,16,0,0,0,240,0,116,0,0,63,255,192,116,0,0,21,245,74,254,160,0,85,240,15,255,240,0,255,255,240,176,240,0,29,11,0,176,240,0,14,14,15,240,240,0,255,255,247,240,240,0,85,245,81,253,240,0,21,245,67,222,178,0,63,255,223,128,179,64,0,240,62,0,119,0,0,240,44,0,63,0,0,160,60,0,25,0,10,170,190,170,144,0,15,255,255,255,224,0,0,0,60,0,0,0,0,0,60,0,0,0,170,170,254,170,170,0,191,255,255,255,255,0,
  // 0x5916  外
  22,89,21,22,132,22,1,253,0,16,0,5,0,0,0,184,0,31,0,0,0,244,0,31,0,0,0,240,0,31,0,0,2,255,252,31,0,0,3,255,252,31,0,0,7,192,63,31,0,0,15,64,127,223,0,0,47,0,183,255,0,0,127,128,240,255,0,0,255,241,224,127,0,0,96,255,208,47,64,0,0,47,192,31,208,0,0,15,128,31,248,0,0,31,0,31,191,64,0,61,0,31,30,0,0,188,0,31,0,0,2,240,0,31,0,0,15,208,0,31,0,0,127,64,0,31,0,0,60,0,0,31,0,0,0,0,0,5,0,0,
  // 0x591a  多
  26,89,19,22,110,22,2,253,0,1,64,0,0,0,7,224,0,0,0,31,234,168,0,0,191,255,252,0,11,240,0,248,0,191,248,3,224,0,180,127,79,128,0,0,11,254,0,0,0,7,247,128,0,0,191,159,192,0,111,248,127,234,224,254,66,255,255,244,80,47,208,2,224,6,255,192,7,192,11,231,244,31,64,1,0,190,126,0,0,0,31,248,0,0,0,111,208,0,0,27,254,0,0,27,255,208,0,0,31,249,0,0,0,4,0,0,0,0,
  // 0x5920  夠
  32,89,20,22,110,22,1,253,0,144,0,64,0,2,208,1,224,0,3,234,130,208,0,15,255,195,192,0,61,7,135,255,254,244,15,15,255,253,107,110,30,0,29,3,252,60,0,29,2,240,123,255,29,31,248,3,239,29,190,180,3,71,29,53,255,227,71,29,7,235,227,71,45,47,2,211,71,45,253,71,195,239,45,99,239,67,255,44,0,190,3,64,44,0,252,2,64,60,7,224,0,0,60,191,128,0,15,248,184,0,0,15,240,0,0,0,0,0,
  // 0x5927  大
  39,89,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,124,0,0,0,0,124,0,0,191,255,255,255,254,191,255,255,255,254,0,0,255,0,0,0,0,255,0,0,0,2,251,128,0,0,3,215,192,0,0,7,195,224,0,0,15,129,244,0,0,47,0,252,0,0,189,0,63,0,2,248,0,31,192,11,224,0,7,244,191,128,0,1,254,125,0,0,0,60,16,0,0,0,4,
  // 0x5929  天
  41,89,20,20,100,22,1,253,191,255,255,255,254,191,255,255,255,254,0,0,124,0,0,0,0,124,0,0,0,0,124,0,0,0,0,124,0,0,0,0,124,0,0,63,255,255,255,252,63,255,255,255,252,0,0,190,0,0,0,0,255,0,0,0,1,255,128,0,0,3,231,192,0,0,11,195,240,0,0,47,64,248,0,0,190,0,127,0,7,248,0,47,224,191,208,0,7,255,190,0,0,0,189,16,0,0,0,4,
  // 0x5931  失
  49,89,20,22,110,22,1,253,0,0,40,0,0,1,240,60,0,0,2,224,60,0,0,3,208,60,0,0,7,255,255,255,240,15,255,255,255,240,31,0,60,0,0,62,0,60,0,0,188,0,60,0,0,20,0,124,0,0,0,0,124,0,0,255,255,255,255,255,255,255,255,255,255,0,0,255,0,0,0,2,251,128,0,0,7,211,208,0,0,31,130,244,0,0,191,0,189,0,7,252,0,47,208,127,208,0,7,254,190,0,0,0,190,16,0,0,0,4,
  // 0x59cb  始
  203,89,21,22,132,22,1,253,1,64,0,80,0,0,3,192,0,244,0,0,3,128,0,240,0,0,7,128,1,224,0,0,11,64,2,208,144,0,255,255,3,192,240,0,255,255,7,128,184,0,14,15,15,69,125,0,29,15,191,255,255,0,44,15,191,170,95,64,60,30,0,0,5,0,56,45,0,0,0,0,120,60,15,255,252,0,191,124,15,255,252,0,187,248,14,0,60,0,2,248,14,0,60,0,1,254,14,0,60,0,3,239,78,0,60,0,15,135,78,0,60,0,63,1,15,255,252,0,188,0,15,255,252,0,32,0,9,0,40,0,
  // 0x5a92  媒
  146,90,20,22,110,22,1,253,1,0,0,0,0,7,128,45,0,240,11,64,45,0,240,11,2,255,255,255,15,2,191,171,250,15,0,45,0,240,255,253,46,170,240,255,253,47,255,240,45,45,45,0,240,60,44,45,0,240,60,60,47,255,240,56,60,26,254,160,120,120,0,120,0,190,181,170,254,170,127,242,255,255,255,3,240,3,255,0,3,252,15,255,192,11,253,46,121,240,31,13,252,120,189,189,7,240,120,47,116,2,128,120,8,16,0,0,36,0,
  // 0x5b50  子
  80,91,20,21,105,22,1,252,11,255,255,255,208,11,255,255,255,224,0,0,0,47,128,0,0,0,254,0,0,0,7,244,0,0,0,63,192,0,0,0,62,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,63,252,0,0,0,63,224,0,0,0,0,0,0,0,
  // 0x5b58  存
  88,91,20,22,110,22,1,253,0,1,64,0,0,0,3,192,0,0,0,7,192,0,0,191,255,255,255,254,191,255,255,255,254,0,46,0,0,0,0,61,0,0,0,0,188,0,0,0,0,244,191,255,244,3,240,191,255,240,11,192,0,11,192,47,192,0,126,0,255,192,0,184,0,243,199,255,255,255,3,199,255,255,255,3,192,0,180,0,3,192,0,180,0,3,192,0,180,0,3,192,0,180,0,3,192,0,180,0,3,192,63,244,0,3,192,47,224,0,
  // 0x5b89  安
  137,91,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,60,0,0,0,60,60,1,240,0,60,60,3,224,0,60,0,7,192,0,0,191,255,255,255,254,191,255,255,255,254,0,61,0,46,0,0,124,0,61,0,0,244,0,124,0,1,248,0,244,0,3,255,227,224,0,2,135,255,192,0,0,0,191,244,0,0,27,249,255,64,43,255,208,31,244,47,248,0,2,240,5,0,0,0,0,
  // 0x5b8c  完
  140,91,20,21,105,22,1,253,0,0,60,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,60,0,0,0,60,60,0,0,0,60,56,255,255,255,60,0,191,255,254,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,254,191,255,255,255,254,0,31,2,208,0,0,46,2,208,0,0,61,2,208,0,0,124,2,208,8,0,248,2,208,15,7,240,2,224,15,191,192,1,255,254,189,0,0,191,248,16,0,0,0,0,
  // 0x5b9a  定
  154,91,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,60,0,0,0,60,60,0,0,0,60,60,255,255,255,60,0,255,255,255,0,0,0,60,0,0,0,0,60,0,0,1,224,60,0,0,2,224,60,0,0,2,224,63,255,208,3,208,63,255,208,3,240,60,0,0,11,248,60,0,0,15,126,60,0,0,62,15,252,0,0,188,2,255,255,255,180,0,43,255,253,16,0,0,0,0,
  // 0x5ba2  客
  162,91,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,63,255,255,255,252,127,255,255,255,252,120,2,64,0,60,120,7,192,0,60,120,31,234,168,60,0,127,255,254,0,2,253,0,188,0,47,223,130,240,0,13,3,255,192,0,0,1,255,128,0,0,47,235,254,64,27,254,0,127,254,255,254,170,175,253,100,255,255,255,0,0,240,0,15,0,0,240,0,15,0,0,240,0,15,0,0,255,255,255,0,0,250,170,175,0,0,80,0,5,0,
  // 0x5bb9  容
  185,91,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,60,0,0,0,60,60,4,0,16,60,60,62,0,248,60,0,252,0,63,64,7,240,189,11,224,47,129,255,65,244,13,7,231,208,96,0,31,130,248,0,0,190,0,127,0,3,248,0,31,224,47,255,255,255,254,190,255,255,255,126,32,240,0,15,4,0,240,0,15,0,0,240,0,15,0,0,255,255,255,0,0,255,255,255,0,0,160,0,5,0,
  // 0x5c0d  對
  13,92,20,22,110,22,1,253,1,69,0,0,80,99,203,40,0,240,183,203,60,0,240,59,203,116,0,240,43,203,176,0,240,171,239,168,0,240,255,255,254,170,255,14,1,211,255,255,15,3,192,0,240,11,67,128,0,240,47,171,228,224,240,63,255,244,240,240,0,120,0,180,240,0,120,0,56,240,47,255,240,60,240,42,254,160,20,240,0,120,0,0,240,0,120,24,0,240,22,255,252,0,240,255,255,248,0,240,186,80,0,63,224,0,0,0,63,128,
  // 0x5c0f  小
  15,92,21,21,126,22,1,253,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,3,208,60,7,128,0,3,208,60,7,192,0,7,192,60,3,224,0,11,128,60,1,240,0,15,64,60,0,248,0,31,0,60,0,124,0,46,0,60,0,61,0,61,0,60,0,47,0,252,0,60,0,31,0,176,0,60,0,15,64,0,0,60,0,4,0,0,0,60,0,0,0,0,0,60,0,0,0,0,63,252,0,0,0,0,47,244,0,0,0,0,0,0,0,0,0,
  // 0x5c31  就
  49,92,21,22,132,22,1,253,0,80,0,24,0,0,0,180,0,45,176,0,0,180,0,45,184,0,191,255,248,45,61,0,255,255,248,45,30,0,0,0,0,45,4,0,0,0,7,255,255,0,47,255,235,255,255,0,47,171,224,60,0,0,44,1,224,63,128,0,44,1,224,63,128,0,46,171,224,63,128,0,47,255,224,127,128,0,0,116,0,191,128,0,24,117,192,251,128,0,60,117,225,247,128,0,60,116,243,215,131,0,184,116,187,199,135,64,240,116,31,71,135,0,80,180,63,3,255,0,11,244,60,2,253,0,3,224,4,0,0,0,
  // 0x5de5  工
  229,93,20,17,85,22,1,255,47,255,255,255,248,47,255,255,255,248,0,0,124,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,
  // 0x5dee  差
  238,93,20,22,110,22,1,253,0,16,0,4,0,0,184,0,46,0,0,61,0,60,0,47,255,255,255,248,47,255,255,255,252,0,0,60,0,0,0,0,60,0,0,11,255,255,255,224,6,170,190,170,160,0,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,184,0,0,0,0,244,0,0,0,0,247,255,255,240,2,231,255,255,224,3,192,7,192,0,11,192,7,192,0,31,0,7,192,0,190,127,255,255,252,184,127,255,255,253,16,0,0,0,0,
  // 0x5df2  已
  242,93,19,19,95,22,2,254,255,255,255,255,0,255,255,255,255,0,0,0,0,15,0,0,0,0,15,0,60,0,0,15,0,60,0,0,15,0,60,0,0,15,0,63,255,255,255,0,63,255,255,255,0,61,0,0,15,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,16,60,0,0,0,60,60,0,0,0,124,61,0,0,0,184,46,0,0,1,244,31,255,255,255,240,6,255,255,255,128,
  // 0x5e73  平
  115,94,20,20,100,22,1,253,47,255,255,255,248,47,255,255,255,248,0,0,60,0,0,2,192,60,3,128,3,208,60,7,192,1,224,60,11,128,0,240,60,15,0,0,244,60,30,0,0,96,60,28,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,40,0,0,
  // 0x5e8a  床
  138,94,20,22,110,22,1,253,0,0,25,0,0,0,0,30,0,0,0,0,30,0,0,31,255,255,255,255,31,255,255,255,255,30,0,1,64,0,30,0,3,192,0,30,0,3,192,0,30,0,3,192,0,30,127,255,255,254,30,127,255,255,255,30,0,31,240,0,30,0,63,248,0,45,0,191,253,0,45,1,247,207,64,60,3,211,199,208,60,15,131,194,244,60,127,3,192,190,184,252,3,192,47,240,32,3,192,4,240,0,3,192,0,0,0,2,64,0,
  // 0x5ea6  度
  166,94,20,22,110,22,1,253,0,0,5,0,0,0,0,30,0,0,0,0,30,0,0,31,255,255,255,254,31,255,255,255,254,30,1,144,10,0,30,1,208,15,0,30,191,255,255,254,30,171,250,175,233,30,1,208,15,0,30,1,250,175,0,30,1,255,255,0,29,0,0,0,0,45,106,170,170,144,45,127,255,255,240,60,3,208,7,192,60,0,244,31,64,60,0,127,253,0,184,0,47,248,0,240,107,255,255,233,240,255,208,11,254,0,80,0,0,24,
  // 0x5ee2  廢
  226,94,20,22,110,22,1,253,0,0,5,0,0,0,0,30,0,0,26,170,191,170,170,47,255,255,255,255,45,0,0,80,0,45,63,252,242,192,45,21,184,63,0,45,116,240,46,60,45,47,192,11,240,45,47,144,87,248,46,255,242,255,255,45,144,114,195,73,44,21,179,195,156,60,127,251,67,252,60,112,2,0,80,60,181,87,255,240,56,255,242,214,224,116,64,240,227,192,180,0,224,127,64,240,1,225,191,144,224,63,223,210,253,0,21,4,0,20,
  // 0x5efa  建
  250,94,20,22,110,22,1,253,0,0,0,80,0,0,0,1,224,0,255,226,255,255,244,255,209,170,250,244,3,192,1,224,180,11,79,255,255,255,15,10,170,250,254,46,0,1,224,180,63,246,255,255,244,127,245,170,250,164,112,180,1,224,0,0,241,170,250,164,52,243,255,255,248,56,240,1,224,0,46,230,170,250,169,15,207,255,255,254,11,192,1,224,0,15,244,1,224,0,47,255,144,64,0,189,31,255,255,255,244,1,175,255,254,16,0,0,0,0,
  // 0x5f15  引
  21,95,18,22,110,22,1,253,0,0,0,0,80,47,255,240,1,224,63,255,240,1,224,0,0,240,1,224,0,0,240,1,224,0,0,240,1,224,0,0,240,1,224,31,255,240,1,224,31,255,240,1,224,45,0,0,1,224,61,0,0,1,224,63,255,240,1,224,63,255,240,1,224,120,0,240,1,224,0,0,240,1,224,0,0,240,1,224,0,1,224,1,224,0,2,224,1,224,0,3,208,1,224,3,255,192,1,224,3,255,64,1,224,0,0,0,0,0,
  // 0x5f85  待
  133,95,20,22,110,22,1,253,0,64,0,80,0,1,240,0,240,0,3,208,0,240,0,31,129,255,255,252,190,1,255,255,252,184,16,0,240,0,96,244,0,240,0,1,240,0,240,0,3,223,255,255,255,15,203,255,255,255,63,192,0,3,192,255,192,0,3,192,243,203,255,255,255,67,199,255,255,255,3,192,16,3,192,3,192,244,3,192,3,192,124,3,192,3,192,46,3,192,3,192,15,3,192,3,192,4,3,192,3,192,0,255,192,3,192,0,191,64,
  // 0x5f8c  後
  140,95,21,22,132,22,0,253,0,16,0,64,0,0,0,124,1,240,0,0,1,240,3,208,128,0,7,208,159,65,240,0,31,65,254,7,208,0,61,20,126,31,64,0,20,60,15,253,32,0,0,248,3,244,124,0,1,240,7,208,46,0,7,227,255,255,255,64,31,227,255,255,171,192,127,224,3,208,2,128,56,224,15,234,164,0,0,224,47,255,252,0,0,225,255,0,244,0,0,231,235,130,224,0,0,226,131,239,192,0,0,224,0,255,0,0,0,224,7,255,208,0,0,225,191,135,254,64,0,227,248,0,127,192,0,145,64,0,1,0,
  // 0x5f91  徑
  145,95,20,21,105,22,1,253,1,224,0,0,0,3,211,255,255,255,15,67,255,255,254,126,0,16,16,16,244,80,180,180,184,80,241,224,224,240,3,211,195,195,192,11,195,135,131,192,47,130,210,210,224,191,128,240,240,180,247,128,120,124,60,131,128,16,16,20,3,130,255,255,252,3,131,255,255,252,3,128,0,240,0,3,128,0,240,0,3,128,0,240,0,3,128,0,240,0,3,143,255,255,255,3,143,255,255,255,1,64,0,0,0,
  // 0x5f9e  從
  158,95,21,22,132,22,0,253,0,16,1,0,80,0,0,188,11,64,180,0,1,240,15,0,240,0,7,192,15,0,240,0,31,64,31,1,224,0,61,20,63,195,248,0,16,60,125,247,254,0,0,248,240,111,79,64,2,243,224,62,3,192,7,225,192,44,1,64,31,224,0,45,0,0,127,224,40,45,0,0,56,224,60,45,0,0,0,224,60,47,170,0,0,224,60,47,255,0,0,224,124,45,0,0,0,224,254,45,0,0,0,224,255,109,0,0,0,227,211,253,0,0,0,235,193,255,255,192,0,231,0,27,255,128,0,80,0,0,0,0,
  // 0x5fa9  復
  169,95,21,22,132,22,0,253,0,16,4,0,0,0,0,120,15,0,0,0,0,240,47,0,0,0,3,208,63,255,255,192,31,64,190,170,170,128,60,26,245,85,84,0,0,63,255,255,253,0,0,248,173,0,29,0,2,240,45,85,109,0,7,224,47,255,253,0,47,224,45,0,29,0,126,224,47,255,253,0,36,224,7,229,84,0,0,224,7,192,0,0,0,224,15,255,253,0,0,224,127,149,188,0,0,226,251,193,244,0,0,225,193,251,208,0,0,224,1,255,128,0,0,225,111,251,254,64,0,227,254,64,191,192,0,144,64,0,1,0,
  // 0x5fae  微
  174,95,21,22,132,22,0,253,0,64,20,1,64,0,1,240,56,2,192,0,3,209,56,83,192,0,15,139,56,227,192,0,47,11,56,227,128,0,60,91,56,235,255,192,16,255,56,239,239,192,2,235,255,255,11,0,3,198,170,191,79,0,15,192,0,63,143,0,63,202,170,183,142,0,127,207,255,242,221,0,35,193,199,66,252,0,3,194,199,65,252,0,3,194,199,64,248,0,3,194,199,64,244,0,3,195,199,244,248,0,3,199,143,227,252,0,3,207,10,11,159,0,3,222,0,63,11,192,3,200,0,60,3,192,1,128,0,0,0,0,
  // 0x5fc3  心
  195,95,21,21,126,22,1,254,0,1,0,0,0,0,0,11,208,0,0,0,0,7,253,0,0,0,0,0,127,208,0,0,0,0,7,244,0,0,0,0,0,160,0,0,0,0,0,0,0,0,0,31,0,0,0,0,4,31,0,3,192,0,15,31,0,3,208,0,30,31,0,1,240,0,45,31,0,0,248,0,61,31,0,0,124,0,60,31,0,0,62,0,124,31,0,0,31,0,248,31,0,14,15,64,240,31,0,15,9,0,16,31,0,15,0,0,0,31,0,31,0,0,0,15,255,253,0,0,0,7,255,248,0,0,
  // 0x6027  性
  39,96,20,22,110,22,1,253,2,64,0,20,0,7,128,16,120,0,7,128,120,120,0,7,128,184,120,0,7,224,180,120,0,123,248,255,255,253,183,173,255,255,253,183,159,208,120,0,247,135,192,120,0,231,135,192,120,0,215,129,64,120,0,71,128,0,120,0,7,128,255,255,252,7,128,255,255,252,7,128,0,120,0,7,128,0,120,0,7,128,0,120,0,7,128,0,120,0,7,128,0,120,0,7,139,255,255,255,7,139,255,255,255,2,64,0,0,0,
  // 0x6062  恢
  98,96,20,21,105,22,1,253,7,128,224,0,0,7,128,224,0,0,7,143,255,255,255,7,155,255,255,255,119,240,224,9,0,119,184,224,30,0,183,172,224,30,0,183,156,226,30,14,231,128,231,30,14,215,128,235,30,44,71,129,239,30,60,7,129,238,30,116,7,130,216,47,16,7,130,192,63,0,7,131,192,123,128,7,131,128,243,192,7,139,66,225,240,7,143,11,192,248,7,158,47,0,63,7,172,60,0,15,2,64,16,0,0,
  // 0x606f  息
  111,96,20,21,105,22,1,254,0,0,36,0,0,0,0,124,0,0,1,170,254,170,128,2,255,255,255,192,2,208,0,3,192,2,229,85,91,192,2,255,255,255,192,2,208,0,3,192,2,229,85,91,192,2,255,255,255,192,2,208,0,3,192,2,208,0,3,192,2,255,255,255,192,1,170,170,170,128,0,0,244,0,64,10,29,62,3,208,15,29,15,65,244,61,29,1,20,124,188,30,0,45,47,176,31,255,252,15,0,11,255,244,0,
  // 0x61b6  憶
  182,97,20,22,110,22,1,253,0,0,0,96,0,7,128,0,180,0,7,130,255,255,253,7,129,190,170,232,7,144,29,2,192,119,240,14,3,192,119,191,255,255,255,183,174,170,170,170,183,156,85,85,84,231,128,255,255,252,215,128,240,0,60,7,128,255,255,252,7,128,240,0,124,7,128,245,85,124,7,128,255,255,252,7,128,1,240,0,7,130,207,124,176,7,131,207,4,120,7,135,143,0,125,7,143,79,2,223,7,142,11,255,203,2,64,2,170,64,
  // 0x61c9  應
  201,97,20,22,110,22,1,253,0,0,5,0,0,0,0,30,0,0,26,170,191,170,170,47,255,255,255,255,45,7,11,6,0,45,15,15,15,0,45,45,47,255,252,45,124,190,110,84,46,254,255,255,248,47,252,237,29,0,45,108,29,29,0,44,44,31,255,248,44,44,29,29,0,60,44,31,255,254,60,24,14,85,84,60,0,31,128,0,56,36,83,240,144,116,60,240,144,240,180,180,240,5,124,241,240,240,11,45,226,192,255,255,15,0,0,42,168,0,
  // 0x6210  成
  16,98,20,22,110,22,1,253,0,0,2,65,0,0,0,7,207,128,0,0,7,195,244,0,0,3,192,176,31,255,255,255,255,31,255,255,255,255,31,0,3,192,0,31,0,3,192,0,31,0,3,192,180,31,255,210,208,240,31,255,210,225,224,31,2,209,227,208,31,2,208,247,192,30,2,208,255,64,46,3,192,254,0,46,3,192,188,8,61,191,194,252,15,60,127,75,254,15,124,0,63,159,78,248,0,253,11,253,176,0,112,2,248,0,0,0,0,0,
  // 0x6236  戶
  54,98,18,22,110,22,1,253,0,0,0,5,0,0,0,6,255,64,2,91,255,249,0,3,255,229,0,0,3,208,0,0,0,3,192,0,0,0,3,255,255,255,208,3,255,255,255,208,3,192,0,2,208,3,192,0,2,208,3,192,0,2,208,3,192,0,2,208,7,255,255,255,208,7,255,255,255,208,11,64,0,2,208,15,0,0,0,64,15,0,0,0,0,46,0,0,0,0,61,0,0,0,0,252,0,0,0,0,112,0,0,0,0,0,0,0,0,0,
  // 0x6240  所
  64,98,20,21,105,22,1,253,0,0,0,0,56,191,255,240,7,253,191,255,247,255,224,0,0,7,244,0,47,255,215,128,0,63,255,215,128,0,60,2,215,128,0,60,2,215,255,255,60,2,215,255,255,60,2,215,128,240,63,255,215,128,240,63,255,219,64,240,60,0,11,64,240,60,0,15,0,240,60,0,15,0,240,56,0,46,0,240,120,0,60,0,240,180,0,188,0,240,240,1,244,0,240,224,0,224,0,240,0,0,0,0,160,
  // 0x6247  扇
  71,98,19,21,105,22,1,253,42,170,170,170,168,127,255,255,255,252,0,0,0,0,0,6,170,170,170,160,15,255,255,255,240,15,0,0,0,240,15,0,0,0,240,15,255,255,255,240,15,170,170,170,160,15,0,0,0,0,15,191,249,255,244,15,106,184,170,244,15,56,120,176,116,30,45,120,124,116,46,14,120,40,116,61,1,120,6,116,60,47,184,127,180,185,253,122,244,116,244,144,121,64,180,224,7,244,11,244,0,2,144,2,144,
  // 0x624b  手
  75,98,20,22,110,22,1,253,0,0,0,1,64,0,0,90,255,208,31,255,255,254,64,15,250,189,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,31,255,255,255,248,31,255,255,255,248,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,191,252,0,0,0,63,224,0,0,0,0,0,0,0,
  // 0x6253  打
  83,98,20,22,110,22,1,253,2,128,0,0,0,3,208,0,0,0,3,208,191,255,255,3,208,191,255,255,3,208,0,15,64,255,255,0,15,64,255,255,0,15,64,3,208,0,15,64,3,208,0,15,64,3,208,0,15,64,3,239,0,15,64,11,255,0,15,64,255,248,0,15,64,187,208,0,15,64,3,208,0,15,64,3,208,0,15,64,3,208,0,15,64,3,208,0,15,64,3,208,0,15,64,63,192,15,255,0,63,64,7,253,0,0,0,0,0,0,
  // 0x6279  批
  121,98,20,22,110,22,1,253,2,0,64,4,0,7,65,224,45,0,7,65,224,45,0,7,65,224,45,0,7,65,224,45,0,255,249,224,45,0,255,249,224,45,12,7,65,224,45,62,7,65,255,174,248,7,65,255,175,208,7,149,224,47,0,11,249,224,45,0,255,229,224,45,0,255,65,224,45,0,7,65,224,45,0,7,65,224,45,0,7,65,224,45,9,7,65,224,45,11,7,66,235,238,15,11,95,254,95,255,191,78,64,11,252,125,0,0,0,0,
  // 0x6296  抖
  150,98,20,22,110,22,1,253,2,128,0,1,128,3,192,0,3,192,3,192,13,3,192,3,192,31,131,192,3,192,7,243,192,255,254,0,227,192,255,253,0,3,192,3,192,16,3,192,3,192,124,3,192,3,192,63,131,192,3,217,7,195,192,27,254,0,67,192,255,228,0,3,193,251,192,0,27,255,3,192,175,255,254,3,193,255,231,192,3,192,80,3,192,3,192,0,3,192,3,192,0,3,192,127,192,0,3,192,63,64,0,3,192,0,0,0,0,0,
  // 0x62bd  抽
  189,98,20,22,110,22,1,253,2,64,0,20,0,3,192,0,120,0,3,192,0,120,0,3,192,0,120,0,3,192,0,120,0,255,252,0,120,0,255,253,255,255,254,3,192,255,255,254,3,192,224,120,30,3,192,224,120,30,3,193,224,120,30,7,253,224,120,30,191,249,255,255,254,255,192,255,255,254,67,192,224,120,30,3,192,224,120,30,3,192,224,120,30,3,192,224,120,30,3,192,255,255,254,3,192,255,255,254,191,128,224,0,30,62,0,144,0,5,
  // 0x62d4  拔
  212,98,20,22,110,22,1,253,2,64,6,0,0,3,192,11,71,128,3,192,11,71,240,3,192,11,64,188,3,192,11,64,36,255,253,175,170,169,255,254,255,255,255,3,192,15,0,0,3,192,15,64,0,3,192,15,128,176,3,196,15,192,240,7,252,31,192,240,191,248,46,225,224,255,192,61,242,208,147,192,60,123,192,3,192,120,63,128,3,192,244,47,0,3,193,240,63,128,3,195,208,191,224,3,203,194,240,252,191,159,15,192,63,62,9,2,0,5,
  // 0x6309  按
  9,99,20,22,110,22,1,253,2,64,0,100,0,3,192,0,180,0,3,192,0,180,0,3,193,255,255,254,3,194,255,255,255,255,254,208,0,15,255,254,209,208,15,3,194,211,208,15,3,192,3,192,0,3,194,255,255,255,3,239,255,255,255,111,252,15,0,240,255,208,30,1,224,251,192,45,2,208,3,192,61,3,192,3,192,127,219,128,3,192,123,255,0,3,192,0,191,128,3,192,2,255,244,3,192,111,225,253,191,131,254,0,47,62,2,144,0,8,
  // 0x6389  掉
  137,99,20,22,110,22,1,253,2,64,0,96,0,7,128,0,240,0,7,128,0,254,170,7,128,0,255,255,7,128,0,240,0,255,252,0,240,0,255,250,255,255,248,7,130,234,170,184,7,130,208,0,120,7,130,234,170,184,7,134,255,255,248,11,254,208,0,120,255,210,234,170,184,235,130,255,255,248,7,128,0,240,0,7,128,0,240,0,7,143,255,255,255,7,139,255,255,255,7,128,0,240,0,255,64,0,240,0,190,0,0,240,0,0,0,0,0,0,
  // 0x63a2  探
  162,99,20,22,110,22,1,253,6,64,0,0,0,7,66,170,170,170,7,67,255,255,254,7,67,192,0,14,7,67,199,79,14,255,251,203,79,14,255,248,15,15,0,7,64,30,15,11,7,64,188,15,175,7,67,240,11,253,7,164,64,180,0,31,248,0,180,0,255,211,255,255,254,235,67,255,255,255,7,64,7,255,0,7,64,15,255,128,7,64,62,183,208,7,64,188,181,244,7,67,240,180,189,11,79,192,180,47,191,70,0,180,9,125,0,0,176,0,
  // 0x63a5  接
  165,99,20,22,110,22,1,253,1,64,0,0,0,3,192,0,180,0,3,192,0,180,0,3,194,255,255,253,3,194,191,171,249,255,248,45,2,208,255,248,30,3,192,3,192,15,7,128,3,203,255,255,255,3,199,255,255,255,3,212,3,192,0,7,252,7,128,0,191,255,255,255,255,255,198,191,171,250,131,192,61,3,192,3,192,60,3,192,3,192,190,75,128,3,192,255,255,0,3,192,1,255,64,3,192,27,255,244,191,139,255,129,253,62,7,160,0,24,
  // 0x63a7  控
  167,99,20,22,110,22,1,253,1,0,0,80,0,7,64,0,240,0,7,64,0,240,0,7,67,255,255,255,7,67,239,239,175,255,251,139,79,15,255,250,75,15,14,7,64,15,15,0,7,64,46,15,11,7,64,188,15,175,7,187,240,7,253,31,249,64,0,0,255,208,0,0,0,255,65,255,255,252,71,65,255,255,252,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,11,75,255,255,255,191,75,255,255,255,125,0,0,0,0,
  // 0x63d0  提
  208,99,20,22,110,22,1,253,6,0,0,0,0,11,64,255,255,248,11,64,250,170,184,11,64,240,0,120,11,64,255,255,248,255,248,245,85,184,255,248,240,0,120,11,64,250,170,184,11,64,255,255,248,11,64,0,0,0,11,86,170,170,169,11,251,255,255,254,255,228,0,176,0,255,64,176,176,0,11,64,240,186,164,11,64,240,191,248,11,65,244,176,0,11,67,252,176,0,11,75,143,240,0,191,31,7,255,255,126,13,0,191,255,0,0,0,0,0,
  // 0x63d2  插
  210,99,20,22,110,22,1,253,1,0,0,0,0,7,64,0,6,180,7,66,191,255,252,7,66,255,249,0,7,64,0,176,0,255,248,0,176,0,255,255,255,255,255,7,67,255,255,254,7,64,0,176,0,7,64,9,176,0,7,82,191,243,253,11,251,244,178,189,255,231,192,176,29,255,67,192,176,29,7,67,254,179,253,7,67,249,178,189,7,67,192,176,29,7,67,192,176,29,7,67,250,254,189,11,67,255,255,253,191,67,192,0,29,125,1,64,0,4,
  // 0x63db  換
  219,99,20,22,110,22,1,253,6,0,9,0,0,7,64,30,0,0,7,64,63,255,0,7,64,190,175,0,7,65,240,46,0,255,255,208,60,0,255,255,255,255,252,7,66,235,239,188,7,65,195,77,44,7,65,219,14,124,7,181,253,15,252,47,249,212,0,44,255,209,192,176,44,255,64,64,240,20,7,70,170,250,170,7,75,255,255,255,7,64,2,252,0,7,64,7,238,0,7,64,31,79,128,11,64,190,7,244,191,79,244,1,255,125,10,64,0,24,
  // 0x64c7  擇
  199,100,20,22,110,22,1,253,2,0,0,0,0,7,64,85,85,84,7,65,255,255,253,7,65,195,75,13,7,65,195,75,13,255,249,255,255,253,255,248,85,249,84,7,64,85,249,84,7,64,255,255,252,7,64,0,180,0,7,170,170,250,170,31,255,255,255,255,255,208,29,2,208,235,64,14,3,192,7,67,255,255,255,7,66,170,250,169,7,64,0,180,0,7,66,255,255,253,7,65,170,250,168,11,64,0,180,0,191,64,0,180,0,125,0,0,96,0,
  // 0x64ca  擊
  202,100,20,22,110,22,1,253,0,80,0,0,0,0,240,2,255,192,191,255,242,214,192,63,255,195,194,215,52,176,219,129,254,63,255,219,0,84,52,176,203,255,244,63,255,210,213,240,255,255,240,247,208,20,177,128,127,64,56,241,207,255,228,63,255,219,154,190,11,255,255,250,0,1,0,60,0,0,5,85,125,85,80,15,255,255,255,244,0,0,60,0,0,191,255,255,255,254,85,85,125,85,85,0,0,60,0,0,0,15,252,0,0,0,6,144,0,0,
  // 0x64cb  擋
  203,100,20,22,110,22,1,253,2,0,0,96,0,7,64,240,176,120,7,64,180,176,240,7,64,56,176,224,7,67,255,255,255,255,251,234,170,175,255,251,192,0,15,7,67,255,255,255,7,64,61,86,240,7,64,60,0,240,7,164,61,85,240,31,248,63,255,240,255,208,0,0,0,235,65,255,255,252,7,65,250,250,188,7,65,224,176,60,7,65,255,255,252,7,65,229,249,124,7,65,224,176,60,11,65,255,255,252,191,65,250,170,188,125,0,64,0,20,
  // 0x64e0  擠
  224,100,21,22,132,22,0,253,1,128,0,24,0,0,2,208,0,60,0,0,2,210,170,190,170,128,2,211,255,255,255,192,2,208,0,194,192,0,63,253,85,211,71,64,63,254,255,231,254,0,2,208,115,108,215,0,2,208,163,108,211,0,2,208,211,108,231,128,2,239,223,45,249,192,11,253,24,20,4,0,127,224,60,0,29,0,58,208,63,255,253,0,2,208,62,170,189,0,2,208,60,0,29,0,2,208,62,170,189,0,2,208,127,255,253,0,2,208,180,0,29,0,2,208,240,0,29,0,47,195,224,0,29,0,31,65,128,0,29,0,
  // 0x6536  收
  54,101,20,22,110,22,1,253,0,4,1,0,0,0,30,3,208,0,0,30,3,192,0,24,30,7,192,0,60,30,11,128,0,60,30,15,255,255,60,30,31,255,255,60,30,63,0,120,60,30,127,64,180,60,30,255,128,240,60,31,243,192,240,60,30,67,194,224,60,30,1,227,192,60,46,0,251,128,63,254,0,191,0,255,254,0,62,0,249,30,0,255,0,0,30,3,255,192,0,30,31,195,244,0,30,255,0,255,0,30,248,0,47,0,25,0,0,4,
  // 0x653e  放
  62,101,20,22,110,22,1,253,0,144,0,80,0,0,240,0,240,0,0,240,0,240,0,0,240,1,224,0,255,255,226,224,0,255,255,227,255,255,11,64,3,255,255,11,64,11,192,180,11,64,15,192,240,11,255,239,208,240,11,255,254,225,224,11,67,220,242,208,11,67,128,247,192,11,3,128,127,128,15,3,128,63,64,15,7,128,47,0,31,7,128,63,64,45,7,128,255,192,60,7,67,243,240,248,15,111,192,254,240,255,190,0,63,80,185,36,0,8,
  // 0x6557  敗
  87,101,20,22,110,22,1,253,0,0,0,80,0,42,170,129,240,0,63,255,194,224,0,60,3,195,208,0,60,3,195,208,0,62,171,199,255,255,63,255,203,255,255,60,3,207,128,244,60,3,239,192,240,60,3,255,192,240,63,255,250,209,224,62,171,209,243,208,60,3,192,247,192,60,3,192,191,128,63,255,192,63,0,42,170,128,63,0,14,10,0,191,128,31,15,65,255,208,61,7,203,226,248,188,3,255,128,191,240,0,61,0,46,16,0,16,0,0,
  // 0x6574  整
  116,101,20,21,105,22,1,254,0,80,0,16,0,0,176,0,120,0,191,255,244,240,0,85,249,81,255,255,63,255,243,234,250,57,181,255,224,240,56,176,250,118,224,63,255,240,63,192,23,254,80,31,128,11,255,128,127,224,126,182,247,245,254,180,176,79,128,62,0,16,0,0,4,31,255,255,255,248,26,170,190,170,164,0,0,60,0,0,1,208,63,255,192,1,208,62,170,128,1,208,60,0,0,171,250,190,170,170,255,255,255,255,255,
  // 0x6578  數
  120,101,20,22,110,22,1,253,0,36,0,20,0,5,121,80,60,0,47,255,244,60,0,44,56,116,60,0,255,255,255,120,0,125,121,185,191,255,45,121,180,255,255,47,255,244,240,60,0,56,2,244,120,63,255,255,248,180,57,121,127,252,176,57,121,127,124,240,63,255,252,46,224,0,224,0,31,208,171,255,255,15,192,255,234,249,11,128,15,67,208,31,192,31,251,192,63,224,9,191,64,252,248,6,255,231,240,126,127,209,247,192,30,36,0,1,0,4,
  // 0x6599  料
  153,101,20,22,110,22,1,253,0,64,0,0,144,2,208,0,1,208,178,211,195,1,208,178,211,135,209,208,118,215,1,245,208,58,219,0,49,208,58,222,0,1,208,18,208,0,1,208,255,255,174,1,208,255,255,223,193,208,7,224,2,225,208,11,244,0,129,208,15,252,0,1,208,46,239,0,6,255,62,219,90,255,255,182,211,63,255,224,242,208,41,1,208,210,208,0,1,208,66,208,0,1,208,2,208,0,1,208,2,208,0,1,208,1,128,0,0,144,
  // 0x659c  斜
  156,101,21,22,132,22,0,253,0,25,0,0,40,0,0,63,64,0,60,0,0,191,208,52,60,0,0,241,244,125,60,0,3,192,125,15,124,0,11,64,44,7,124,0,31,255,240,0,60,0,127,255,240,64,60,0,36,30,0,244,60,0,0,30,0,125,60,0,47,255,253,15,60,0,63,255,253,5,60,0,0,30,0,0,61,128,6,30,32,1,191,192,11,30,117,191,255,128,15,30,62,255,188,0,30,30,45,144,60,0,45,30,29,0,60,0,60,30,13,0,60,0,20,30,0,0,60,0,2,253,0,0,60,0,1,248,0,0,44,0,
  // 0x65b0  新
  176,101,20,22,110,22,1,253,0,80,0,0,0,0,240,0,0,124,0,240,1,27,253,191,255,243,255,144,111,171,227,208,0,29,3,195,192,0,15,11,67,192,0,11,11,3,192,0,255,255,247,255,255,170,254,163,255,255,0,240,3,192,240,0,240,3,192,240,255,255,243,192,240,171,254,167,192,240,2,248,7,128,240,7,255,11,64,240,15,251,207,0,240,61,241,223,0,240,244,240,46,0,240,144,240,124,0,240,0,240,180,0,240,0,96,16,0,80,
  // 0x65b7  斷
  183,101,20,22,110,22,1,253,0,64,0,0,0,52,192,208,0,188,123,98,148,95,248,123,179,180,255,64,118,210,224,240,0,116,160,216,224,0,118,249,253,224,0,126,11,68,224,0,121,85,84,255,255,127,255,252,255,255,116,192,208,224,240,118,130,192,224,240,127,119,116,224,240,119,226,240,224,240,116,208,209,224,240,118,165,217,208,240,127,255,255,192,240,116,0,7,192,240,127,255,255,128,240,126,170,175,64,240,116,0,11,0,240,0,0,0,0,96,
  // 0x65bc  於
  188,101,20,22,110,22,1,253,0,144,0,40,0,1,224,0,62,0,1,224,0,191,0,1,224,0,251,128,255,255,209,227,192,255,255,211,194,224,11,64,11,128,244,11,0,31,0,125,15,0,125,0,47,15,255,184,16,15,15,255,80,252,0,15,11,64,63,0,15,11,64,11,192,15,11,64,3,64,15,11,64,0,0,30,11,66,0,0,45,11,75,224,0,60,11,3,253,0,124,15,0,127,128,248,15,0,11,240,241,255,0,1,244,80,248,0,0,32,
  // 0x6607  昇
  7,102,20,21,105,22,1,253,6,170,170,170,144,11,255,255,255,224,11,64,0,1,224,11,170,170,171,224,11,255,255,255,224,11,64,0,1,224,11,64,0,1,224,11,255,255,255,224,6,170,170,170,144,0,6,248,45,0,27,255,244,45,0,31,175,0,45,0,0,30,0,45,0,191,255,255,255,254,255,255,255,255,255,0,45,0,45,0,0,124,0,45,0,1,248,0,45,0,31,224,0,45,0,47,64,0,45,0,4,0,0,20,0,
  // 0x660e  明
  14,102,19,21,105,22,2,253,0,0,63,255,244,255,252,63,255,244,255,252,60,0,180,224,60,60,0,180,224,60,60,0,180,224,60,60,0,180,224,60,63,255,244,255,252,63,255,244,255,252,60,0,180,224,60,60,0,180,224,60,60,0,180,224,60,127,255,244,224,60,127,255,244,255,252,180,0,180,255,252,240,0,180,224,2,240,0,180,224,3,208,0,180,0,15,192,0,180,0,47,0,63,244,0,28,0,47,208,0,0,0,0,0,
  // 0x662f  是
  47,102,20,21,105,22,1,253,2,170,170,170,128,7,255,255,255,208,7,128,0,2,208,7,149,85,87,208,7,255,255,255,208,7,128,0,2,208,7,234,170,171,208,7,255,255,255,208,0,0,0,0,0,127,255,255,255,254,191,255,255,255,254,0,64,60,0,0,1,240,60,0,0,2,224,63,255,240,3,224,63,255,240,7,244,60,0,0,15,189,60,0,0,47,47,252,0,0,189,7,255,255,255,180,0,111,255,254,0,0,0,0,0,
  // 0x6642  時
  66,102,20,22,110,22,1,253,0,0,0,16,0,0,0,0,60,0,127,252,0,60,0,127,252,191,255,253,120,60,191,255,253,120,60,0,60,0,120,60,0,60,0,120,62,255,255,255,127,254,255,255,255,127,252,0,1,224,120,60,0,1,224,120,60,0,1,224,120,62,255,255,255,120,61,255,255,255,120,60,20,1,224,127,252,61,1,224,127,252,15,65,224,120,0,11,193,224,120,0,3,65,224,16,0,0,1,224,0,0,0,127,208,0,0,0,63,128,
  // 0x66ab  暫
  171,102,20,22,110,22,1,253,0,96,0,0,16,21,181,81,22,248,191,255,247,255,208,0,176,3,208,0,63,255,227,192,0,56,176,227,234,170,63,255,227,255,255,56,176,227,130,208,63,255,231,130,208,0,180,15,2,208,255,255,255,2,208,0,176,44,2,208,0,80,4,0,64,3,255,255,255,192,3,234,170,171,192,3,192,0,3,192,3,255,255,255,192,3,229,85,91,192,3,192,0,3,192,3,255,255,255,192,3,234,170,171,192,1,64,0,1,64,
  // 0x66f4  更
  244,102,20,20,100,22,1,253,191,255,255,255,254,127,255,255,255,253,0,0,60,0,0,6,170,190,170,160,11,255,255,255,240,11,64,60,0,240,11,64,60,0,240,11,255,255,255,240,11,170,190,170,240,11,64,60,0,240,11,234,190,170,240,11,255,255,255,240,1,192,124,0,0,2,240,244,0,0,0,191,240,0,0,0,63,208,0,0,1,255,254,148,0,191,244,127,255,255,62,64,0,107,254,0,0,0,0,0,
  // 0x6700  最
  0,103,20,21,105,22,1,253,3,255,255,255,192,3,213,85,87,192,3,192,0,3,192,3,255,255,255,192,3,213,85,87,192,3,213,85,87,192,3,255,255,255,192,0,0,0,0,0,191,255,255,255,254,111,171,250,170,169,15,2,208,0,0,15,255,223,255,248,15,86,219,234,248,15,2,211,192,240,15,255,209,227,224,15,151,208,191,192,15,2,208,63,64,191,255,209,255,128,190,150,255,247,249,0,2,239,128,190,0,1,64,0,4,
  // 0x6709  有
  9,103,20,22,110,22,1,253,0,1,64,0,0,0,3,192,0,0,0,7,192,0,0,191,255,255,255,254,191,255,255,255,254,0,46,0,0,0,0,61,0,0,0,0,188,0,0,0,1,255,255,255,192,3,255,255,255,192,15,244,0,3,192,63,190,170,171,192,252,191,255,255,192,32,180,0,3,192,0,180,0,3,192,0,190,170,171,192,0,191,255,255,192,0,180,0,3,192,0,180,0,3,192,0,180,0,3,192,0,180,0,255,192,0,180,0,254,64,
  // 0x677f  板
  127,103,20,22,110,22,1,253,1,64,0,0,0,2,192,0,0,0,2,192,63,255,254,2,192,63,255,254,2,192,60,0,0,191,255,60,0,0,255,255,60,0,0,3,192,60,0,0,7,192,63,255,253,11,208,63,255,252,15,244,63,192,60,15,252,63,192,120,47,222,121,208,180,58,203,120,240,240,182,192,180,186,208,242,192,244,63,192,194,192,240,47,64,2,193,224,63,192,2,195,208,255,240,2,199,203,240,254,2,199,79,128,46,1,128,0,0,4,
  // 0x67f1  柱
  241,103,20,22,110,22,1,253,1,144,0,64,0,1,208,2,240,0,1,208,0,253,0,1,208,0,63,0,1,208,0,15,0,191,255,127,255,255,255,255,191,255,255,3,208,0,45,0,3,224,0,45,0,7,240,0,45,0,15,248,0,45,0,15,253,0,45,0,46,239,111,255,254,61,215,111,255,254,181,209,0,45,0,241,208,0,45,0,209,208,0,45,0,1,208,0,45,0,1,208,0,45,0,1,209,255,255,255,1,209,255,255,255,1,144,0,0,0,
  // 0x6821  校
  33,104,20,21,105,22,1,253,3,192,0,60,0,3,192,0,60,0,3,192,0,60,0,3,192,255,255,255,191,254,85,85,85,255,254,10,1,208,3,192,31,1,240,7,192,61,0,188,11,240,188,0,62,15,245,250,2,159,31,252,143,3,196,63,222,7,135,192,55,201,3,207,64,243,192,1,255,0,227,192,0,253,0,131,192,0,254,0,3,192,3,255,128,3,192,31,199,244,3,193,254,1,254,3,194,244,0,62,1,128,64,0,4,
  // 0x683c  格
  60,104,20,22,110,22,1,253,1,128,0,64,0,2,192,3,208,0,2,192,7,192,0,2,192,11,255,244,2,192,31,255,240,2,192,63,1,240,255,255,191,67,208,191,255,251,203,192,3,209,210,255,0,7,240,0,253,0,15,252,1,255,64,15,238,15,199,224,47,202,254,0,255,58,195,254,170,254,178,193,127,255,244,242,192,60,0,180,194,192,60,0,180,2,192,60,0,180,2,192,60,0,180,2,192,63,255,244,2,192,63,255,244,1,128,40,0,96,
  // 0x689d  條
  157,104,21,22,132,22,0,253,0,0,0,64,0,0,0,120,0,240,0,0,0,244,2,224,0,0,0,242,67,255,255,192,2,231,79,234,190,128,3,199,175,192,120,0,7,199,253,240,240,0,15,199,80,127,208,0,47,199,64,63,192,0,127,199,66,255,248,0,55,199,191,208,191,192,19,199,93,15,6,64,3,199,64,15,0,0,3,199,127,255,255,192,3,199,106,191,234,128,3,199,64,127,208,0,3,199,65,255,240,0,3,194,71,223,124,0,3,192,47,79,47,64,3,192,253,15,11,192,3,192,32,15,1,64,1,128,0,10,0,0,
  // 0x68c4  棄
  196,104,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,191,255,255,255,255,106,175,170,190,169,0,46,0,126,0,42,253,85,111,208,47,255,255,255,248,0,80,36,0,36,1,208,60,11,64,191,255,255,255,254,107,250,190,175,233,1,208,60,11,64,1,255,255,255,64,0,170,190,170,0,0,0,60,0,0,191,255,255,255,254,106,171,255,234,169,0,47,190,244,0,1,253,60,127,128,127,224,60,11,254,190,0,60,0,126,0,0,40,0,0,
  // 0x69fd  槽
  253,105,20,22,110,22,1,253,1,64,2,70,0,3,192,3,139,0,3,194,171,239,170,3,195,255,255,255,3,192,3,139,0,191,253,255,255,253,255,253,231,223,109,7,193,211,139,29,11,193,255,255,253,15,209,231,219,109,15,241,211,139,29,31,249,255,255,253,63,236,85,85,84,55,204,42,170,164,179,192,127,255,248,227,192,116,0,120,195,192,121,85,184,3,192,127,255,248,3,192,116,0,120,3,192,126,170,184,3,192,127,255,248,2,64,100,0,36,
  // 0x6a59  橙
  89,106,20,22,110,22,1,253,1,64,0,0,0,3,192,170,78,16,3,192,255,207,180,3,192,7,139,208,3,193,223,3,207,191,253,254,2,252,255,253,62,170,244,3,192,251,255,189,11,194,224,0,47,15,215,192,0,15,15,242,127,255,244,31,252,125,85,244,63,221,120,0,180,119,196,126,170,244,243,192,127,255,244,227,192,9,1,128,131,192,30,3,192,3,192,15,3,192,3,192,11,7,64,3,195,255,255,255,3,195,255,255,255,1,64,0,0,0,
  // 0x6a5f  機
  95,106,20,22,110,22,1,253,2,64,0,144,0,3,128,176,240,224,3,128,224,242,192,3,130,202,247,156,3,135,205,255,60,191,249,252,243,244,255,252,180,240,240,11,128,238,178,205,15,130,219,187,223,15,215,255,255,255,31,241,66,180,210,47,184,0,116,180,63,175,255,255,255,119,134,250,190,170,247,128,240,60,116,211,128,248,45,240,131,129,255,31,224,3,130,219,79,192,3,131,193,47,67,3,139,65,255,199,3,158,11,209,255,2,68,2,0,104,
  // 0x6aa2  檢
  162,106,20,22,110,22,1,253,2,128,0,100,0,3,192,0,252,0,3,192,3,255,0,3,192,15,139,192,3,192,127,3,240,191,254,252,0,253,255,255,255,255,239,3,194,138,170,134,11,192,0,0,0,15,224,255,207,253,15,244,230,207,109,31,252,210,206,29,47,221,210,206,29,59,204,255,207,253,179,192,89,70,84,227,192,29,2,208,195,192,44,3,192,3,192,61,3,208,3,192,255,143,244,3,194,227,238,62,3,199,192,124,15,2,129,0,16,0,
  // 0x6b62  止
  98,107,20,21,105,22,1,254,0,0,5,0,0,0,0,15,0,0,0,0,15,0,0,0,0,15,0,0,0,0,15,0,0,2,128,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,255,252,3,192,15,255,252,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,
  // 0x6b63  正
  99,107,20,19,95,22,1,254,63,255,255,255,252,63,255,255,255,252,0,0,30,0,0,0,0,30,0,0,0,0,30,0,0,0,0,30,0,0,3,192,30,0,0,3,192,30,0,0,3,192,31,255,240,3,192,31,255,240,3,192,30,0,0,3,192,30,0,0,3,192,30,0,0,3,192,30,0,0,3,192,30,0,0,3,192,30,0,0,3,192,30,0,0,255,255,255,255,255,255,255,255,255,255,
  // 0x6b65  步
  101,107,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,2,208,60,0,0,2,208,63,255,224,2,208,63,255,224,2,208,60,0,0,2,208,60,0,0,191,255,255,255,254,255,255,255,255,255,0,0,60,0,0,0,244,60,1,64,3,240,60,3,208,15,192,60,7,192,127,0,60,15,128,124,11,252,63,0,0,7,244,188,0,0,0,3,244,0,0,0,47,208,0,0,7,254,0,0,11,255,228,0,0,11,253,0,0,0,1,0,0,0,0,
  // 0x6b78  歸
  120,107,20,22,110,22,1,253,1,64,0,0,0,3,192,15,255,244,27,213,5,85,244,63,255,0,0,180,56,11,127,255,255,61,95,21,85,249,63,255,5,85,244,56,0,15,255,244,63,255,0,0,0,61,95,63,255,254,56,11,62,190,174,63,255,56,44,14,22,229,20,44,9,16,208,31,255,252,52,250,31,190,188,52,255,29,44,60,52,208,29,44,60,52,209,93,44,60,127,255,157,45,252,255,249,9,44,144,148,0,0,44,0,0,0,0,20,0,
  // 0x6bbc  殼
  188,107,21,22,132,22,1,253,0,160,0,0,0,0,0,240,1,255,224,0,255,255,241,255,224,0,106,250,145,208,224,0,0,240,2,208,224,0,63,255,194,192,226,0,21,85,67,192,227,64,0,0,3,192,251,0,255,255,255,64,190,0,245,85,250,0,0,0,250,170,247,255,248,0,15,255,7,255,252,0,0,0,1,192,120,0,10,170,2,208,180,0,15,255,0,240,240,0,14,11,0,183,208,0,14,11,0,63,128,0,30,11,176,63,64,0,45,47,241,255,224,0,124,30,111,225,254,0,180,0,63,64,126,0,0,0,16,0,4,0,
  // 0x6bd4  比
  212,107,20,21,105,22,1,254,1,64,1,64,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,20,3,192,3,192,253,3,255,227,219,244,3,255,227,255,128,3,192,3,244,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,10,3,192,19,192,11,3,219,243,192,15,111,255,243,192,15,255,249,2,255,254,165,0,0,255,248,
  // 0x6c92  沒
  146,108,20,22,110,22,1,253,4,0,25,0,0,47,64,46,0,0,11,240,47,255,248,0,224,63,255,248,0,0,124,0,120,0,0,180,0,120,0,0,240,0,180,184,2,224,0,244,191,75,192,63,240,11,143,64,63,208,1,1,0,0,0,0,3,255,255,244,0,3,255,255,244,0,208,56,1,240,1,240,61,3,208,3,208,31,79,192,7,192,7,255,0,15,64,3,253,0,47,0,47,255,128,61,11,255,75,254,40,15,228,0,190,0,5,0,0,4,
  // 0x6d88  消
  136,109,20,22,110,22,1,253,0,0,0,96,0,45,1,64,240,24,47,195,192,240,61,7,225,240,240,124,0,192,240,240,244,0,0,180,240,224,0,0,0,240,0,116,2,255,255,252,190,2,255,255,252,31,130,208,0,60,2,2,208,0,60,0,2,255,255,252,0,2,250,170,252,0,210,208,0,60,2,210,208,0,60,3,194,255,255,252,11,130,250,170,252,15,2,208,0,60,62,2,208,0,60,124,2,208,15,248,20,2,208,15,224,0,0,0,0,0,
  // 0x6de1  淡
  225,109,20,21,105,22,1,253,4,0,0,240,0,47,64,144,240,32,11,224,224,240,188,1,226,209,224,240,0,7,194,226,208,0,2,3,245,128,16,0,11,255,64,253,0,47,15,224,47,134,253,1,252,7,71,224,224,44,0,1,0,240,0,0,1,225,224,60,1,194,209,224,184,3,211,194,240,240,7,203,131,251,208,15,66,7,253,64,47,0,31,95,64,61,1,190,11,224,124,31,244,2,255,20,15,64,0,45,0,0,0,0,0,
  // 0x6e05  清
  5,110,20,22,110,22,1,253,0,0,0,80,0,46,0,0,240,0,47,215,255,255,253,2,225,86,245,84,0,65,86,245,84,0,3,255,255,252,0,0,0,240,0,180,5,86,245,85,255,79,255,255,255,31,128,0,0,0,1,0,255,255,244,0,0,250,170,244,0,0,224,0,116,0,224,255,255,244,2,224,245,85,180,3,192,224,0,116,11,128,255,255,244,15,64,245,85,180,47,0,224,0,116,61,0,224,0,180,60,0,224,15,244,0,0,224,10,144,
  // 0x6e2c  測
  44,110,20,22,110,22,1,253,0,0,0,0,24,45,15,255,64,45,63,143,255,68,45,7,206,7,94,45,0,78,7,94,45,0,14,7,94,45,0,15,255,94,45,180,15,175,94,45,191,14,7,94,45,31,14,7,94,45,1,15,255,94,45,0,15,175,94,45,0,14,7,94,45,3,14,7,94,45,7,143,255,94,45,15,79,255,77,45,15,5,5,0,45,46,15,79,0,45,60,31,11,128,45,124,61,3,192,45,116,248,1,203,252,0,112,0,7,244,
  // 0x6e90  源
  144,110,20,21,105,22,1,253,46,0,0,0,0,47,203,255,255,255,3,219,255,255,255,0,139,64,61,0,0,11,64,60,0,0,11,111,255,252,116,11,110,170,188,191,11,109,0,60,31,75,111,255,252,1,11,110,85,124,0,11,109,0,60,0,15,46,85,124,2,79,47,255,252,3,207,0,60,0,11,159,13,60,116,15,45,45,60,124,30,60,60,60,61,61,60,244,60,31,124,184,224,60,15,116,240,3,252,0,0,16,2,160,0,
  // 0x6e96  準
  150,110,20,22,110,22,1,253,0,0,80,20,0,15,128,244,61,0,11,242,240,120,0,0,131,255,255,252,16,15,234,250,168,254,63,192,240,0,31,127,255,255,240,0,3,229,249,80,0,131,192,240,0,1,227,255,255,244,7,195,229,249,80,31,3,192,240,0,125,3,255,255,253,36,2,190,170,169,0,0,60,0,0,191,255,255,255,254,255,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,36,0,0,
  // 0x6eab  溫
  171,110,20,21,105,22,1,253,46,1,170,170,160,31,210,255,255,240,2,210,192,128,240,0,66,193,192,240,0,2,194,208,240,0,2,203,180,240,184,2,238,29,240,191,2,196,4,240,31,66,255,255,240,1,1,170,170,160,0,0,0,0,0,0,7,255,255,248,2,199,239,190,248,3,199,78,44,56,7,135,78,44,56,15,71,78,44,56,31,7,78,44,56,61,7,78,44,56,124,127,255,255,255,52,127,255,255,255,0,0,0,0,0,
  // 0x6fc0  激
  192,111,20,22,110,22,1,253,0,0,144,5,0,45,0,240,15,0,47,134,245,15,0,7,223,255,94,0,0,28,7,93,0,0,30,91,111,255,0,31,255,127,255,116,28,7,188,60,254,30,91,252,60,31,31,255,252,56,1,0,240,221,56,0,0,240,14,116,0,127,255,203,176,2,107,234,135,240,7,131,128,3,224,11,67,255,67,208,15,7,239,3,224,46,11,75,15,240,60,31,11,46,124,124,125,175,188,47,116,180,253,240,10,0,16,0,0,0,
  // 0x7121  無
  33,113,20,22,110,22,1,253,0,64,0,0,0,0,244,0,0,0,3,224,0,0,0,7,255,255,255,252,31,255,255,255,252,127,195,195,131,192,187,195,195,131,192,3,195,195,131,192,191,255,255,255,254,191,255,255,255,255,3,195,195,131,192,3,195,195,131,192,3,195,195,131,192,3,195,195,131,192,127,255,255,255,253,127,255,255,255,253,0,0,0,0,64,15,71,67,193,240,15,7,130,208,248,62,3,193,224,61,188,3,192,240,47,16,1,0,64,4,
  // 0x71b1  熱
  177,113,21,22,132,22,1,253,0,80,0,16,0,0,0,176,0,116,0,0,63,255,192,116,0,0,21,245,64,116,0,0,0,176,11,255,240,0,191,255,246,255,240,0,91,174,80,176,240,0,11,13,102,176,240,0,110,15,255,240,240,0,180,177,66,244,240,0,21,249,65,253,240,0,63,255,210,238,243,0,0,176,3,196,243,64,0,246,171,128,243,64,191,255,255,0,251,0,186,148,12,0,126,0,0,0,0,0,0,0,11,70,67,193,240,0,15,7,131,208,248,0,62,7,129,224,61,0,188,3,192,224,46,0,16,0,0,0,0,0,
  // 0x71c8  燈
  200,113,20,22,110,22,1,253,0,0,0,20,0,3,192,170,124,160,3,192,255,159,224,3,192,7,79,68,3,206,223,7,173,51,222,253,3,240,115,252,62,171,244,115,244,255,255,190,179,211,224,0,31,243,207,128,0,1,211,133,127,255,240,3,128,122,170,240,3,128,116,0,240,7,128,122,170,240,7,208,127,255,240,15,240,8,2,128,15,120,30,3,192,30,61,15,7,128,60,12,11,11,0,248,6,174,171,170,240,7,255,255,255,0,0,0,0,0,
  // 0x7247  片
  71,114,19,22,110,22,1,253,0,0,2,128,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,255,255,255,248,3,255,255,255,248,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,7,255,255,254,0,7,255,255,254,0,11,128,0,46,0,15,64,0,46,0,31,0,0,46,0,47,0,0,46,0,125,0,0,46,0,252,0,0,46,0,180,0,0,46,0,16,0,0,25,0,
  // 0x7269  物
  105,114,20,22,110,22,1,253,0,144,5,0,0,0,224,11,0,0,56,224,15,0,0,56,224,30,0,0,116,224,47,255,255,127,254,63,255,255,191,254,184,242,223,240,224,240,227,207,224,227,226,211,142,208,225,195,199,78,0,225,7,75,30,0,255,15,15,30,31,254,46,29,29,255,240,124,60,45,164,225,244,120,45,0,224,208,240,44,0,224,2,224,60,0,224,7,192,60,0,224,31,64,120,0,224,62,31,244,0,224,8,15,224,0,144,0,0,0,
  // 0x7387  率
  135,115,20,21,105,22,1,253,0,0,60,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,0,0,240,0,16,45,2,194,128,248,31,223,71,195,224,3,219,223,11,64,0,1,253,64,0,0,80,242,219,64,7,242,229,251,224,191,191,255,248,253,116,26,104,44,44,0,0,60,0,0,191,255,255,255,254,191,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,40,0,0,
  // 0x7528  用
  40,117,19,20,100,22,1,253,11,255,255,255,248,11,255,255,255,248,11,64,60,0,120,11,64,60,0,120,11,64,60,0,120,11,255,255,255,248,11,255,255,255,248,11,64,60,0,120,11,64,60,0,120,11,64,60,0,120,11,64,60,0,120,15,255,255,255,248,15,255,255,255,248,15,0,60,0,120,30,0,60,0,120,61,0,60,0,120,124,0,60,0,184,248,0,60,63,244,176,0,60,63,224,0,0,0,0,0,
  // 0x754c  界
  76,117,20,21,105,22,1,253,6,170,170,170,144,11,255,255,255,224,11,64,60,1,224,11,64,60,1,224,11,255,255,255,224,11,234,190,171,224,11,64,60,1,224,11,64,60,1,224,11,255,255,255,224,6,175,235,250,144,0,47,64,248,0,0,253,0,63,0,7,248,0,31,244,191,159,0,122,255,125,31,0,120,44,0,30,0,120,0,0,61,0,120,0,0,188,0,120,0,7,244,0,120,0,15,208,0,120,0,1,0,0,36,0,
  // 0x767d  白
  125,118,16,22,88,22,3,253,0,5,64,0,0,15,192,0,0,15,64,0,0,31,0,0,255,255,255,255,255,255,255,255,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,255,255,255,255,255,255,255,255,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,255,255,255,255,255,255,255,255,240,0,0,15,160,0,0,5,
  // 0x7684  的
  132,118,19,22,110,22,2,253,1,64,1,0,0,3,192,7,192,0,7,192,11,128,0,11,64,15,0,0,255,254,31,255,244,255,254,47,255,244,224,14,60,0,180,224,14,184,0,180,224,15,240,0,180,224,14,22,0,180,255,254,11,128,176,255,254,3,208,176,224,14,1,240,240,224,14,0,244,240,224,14,0,116,240,224,14,0,0,240,224,14,0,0,240,255,254,0,1,224,255,254,0,2,224,224,0,2,255,192,224,0,1,255,64,0,0,0,0,0,
  // 0x76e3  監
  227,118,20,20,100,22,1,254,42,170,160,180,0,127,255,240,240,0,120,56,0,224,0,121,121,66,255,254,127,255,227,234,169,120,0,235,64,0,121,85,239,0,0,127,255,224,0,0,120,56,0,170,168,126,190,161,255,252,127,255,244,0,0,0,0,0,0,0,6,170,170,170,144,11,255,255,255,224,11,67,131,193,224,11,67,131,193,224,11,67,131,193,224,11,67,131,193,224,255,255,255,255,255,191,255,255,255,255,
  // 0x76f4  直
  244,118,20,22,110,22,1,253,0,0,41,0,0,0,0,61,0,0,191,255,255,255,254,191,255,255,255,254,0,0,60,0,0,0,0,60,0,0,4,31,255,255,208,29,31,85,87,208,29,30,0,2,208,29,31,255,255,208,29,31,85,87,208,29,30,0,2,208,29,31,255,255,208,29,31,85,87,208,29,30,0,2,208,29,31,255,255,208,29,5,85,85,64,29,0,0,0,0,31,255,255,255,255,31,255,255,255,255,29,0,0,0,0,4,0,0,0,0,
  // 0x7720  眠
  32,119,21,20,120,22,1,254,0,0,63,255,253,0,127,252,63,255,253,0,127,252,56,0,45,0,120,60,56,0,45,0,120,60,56,0,45,0,126,188,63,255,253,0,127,252,63,255,253,0,120,60,56,30,0,0,120,60,56,14,0,0,120,60,56,14,0,0,127,252,63,255,255,0,126,188,63,255,255,0,120,60,56,15,0,0,120,60,56,11,64,0,120,60,56,7,64,0,127,252,56,3,130,0,127,252,56,23,195,64,120,1,191,250,231,64,100,3,255,228,255,0,0,2,144,0,61,0,
  // 0x780d  砍
  13,120,20,22,110,22,1,253,0,0,5,0,0,0,0,15,64,0,255,255,143,0,0,255,255,143,0,0,7,64,31,0,0,11,0,47,255,255,15,0,63,255,255,15,0,60,120,30,31,254,184,120,60,47,255,240,120,60,61,15,96,120,40,189,15,0,188,0,253,15,0,252,0,253,15,0,253,0,93,15,1,222,0,29,15,3,203,0,31,255,11,135,192,31,255,31,3,224,29,0,189,0,248,29,3,244,0,127,0,1,208,0,14,0,0,0,0,0,
  // 0x78ba  確
  186,120,21,22,132,22,0,253,0,0,0,4,0,0,0,0,0,15,0,0,63,255,192,30,0,0,47,255,255,255,255,192,2,208,62,254,171,192,3,192,56,244,83,192,3,192,58,240,243,192,3,128,7,209,224,0,7,255,95,255,255,64,11,255,255,235,234,64,15,67,255,67,192,0,31,67,107,171,234,0,63,67,75,255,255,0,127,67,75,67,192,0,59,67,75,67,192,0,23,67,75,255,255,0,7,67,75,171,234,0,7,255,75,67,192,0,7,255,75,67,192,0,7,64,11,255,255,192,2,0,11,234,170,128,0,0,6,0,0,0,
  // 0x79fb  移
  251,121,20,22,110,22,1,253,0,0,0,20,0,1,189,0,244,0,191,253,2,250,164,187,208,11,255,252,2,208,127,0,244,2,209,255,130,240,2,208,147,231,192,255,255,0,191,64,255,255,1,253,0,3,208,31,253,0,7,240,255,125,0,15,252,100,190,169,31,239,2,255,255,62,219,15,192,61,182,209,191,208,124,242,208,181,249,244,210,208,0,63,208,2,208,0,47,64,2,208,2,253,0,2,208,191,224,0,2,208,254,0,0,1,128,64,0,0,
  // 0x7a4d  積
  77,122,20,22,110,22,1,253,0,4,0,36,0,6,254,21,189,84,255,248,255,255,254,187,208,0,120,0,2,208,127,255,252,2,208,21,125,84,2,208,85,189,85,255,255,255,255,255,255,249,21,85,84,3,208,63,255,252,7,240,60,0,60,15,248,60,0,124,31,254,63,255,252,62,223,60,0,60,118,212,63,255,252,242,208,61,85,124,210,208,61,85,124,66,208,63,255,252,2,208,7,66,192,2,208,127,66,248,2,211,248,0,63,1,129,64,0,4,
  // 0x7aef  端
  239,122,20,22,110,22,1,253,0,0,0,36,0,3,128,80,120,4,3,128,240,120,45,3,128,240,120,45,3,128,240,120,45,255,252,255,255,253,191,252,255,255,253,0,16,0,0,0,112,120,0,0,0,52,118,255,255,255,56,118,255,255,255,56,176,0,244,0,60,240,170,254,169,60,224,255,255,254,40,208,226,199,14,1,254,226,199,14,191,254,226,199,14,255,144,226,199,14,144,0,226,199,14,0,0,226,199,14,0,0,226,199,190,0,0,144,65,36,
  // 0x7b49  等
  73,123,20,22,110,22,1,253,2,64,1,64,0,11,192,3,208,0,15,234,167,234,170,47,255,255,255,255,124,180,47,31,0,244,120,60,15,64,32,16,60,5,0,6,170,190,170,160,11,255,255,255,240,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,170,170,170,191,170,0,0,0,45,0,42,170,170,191,168,63,255,255,255,253,0,116,0,45,0,0,189,0,45,0,0,47,0,45,0,0,11,128,45,0,0,2,15,252,0,0,0,11,228,0,
  // 0x7ba1  管
  161,123,20,22,110,22,1,253,2,64,1,128,0,11,128,3,208,0,15,255,235,255,255,63,250,191,191,170,188,180,125,15,0,176,56,60,7,128,0,0,60,0,0,63,255,255,255,253,62,170,170,170,189,56,106,170,170,45,56,255,255,255,45,0,240,0,15,0,0,240,0,15,0,0,255,255,255,0,0,250,170,170,0,0,240,0,0,0,0,255,255,255,224,0,250,170,170,224,0,240,0,1,224,0,250,170,170,224,0,255,255,255,224,0,160,0,1,144,
  // 0x7bb1  箱
  177,123,20,22,110,22,1,253,2,64,1,128,0,7,128,3,208,0,15,234,167,234,170,31,255,239,255,255,61,180,31,30,0,248,124,61,15,0,112,116,60,7,64,0,240,0,0,0,0,240,15,255,252,191,255,223,255,252,191,255,223,0,60,2,240,15,170,188,3,252,15,255,252,11,255,15,0,60,15,251,207,0,60,61,243,223,170,188,188,240,79,255,252,240,240,15,0,60,80,240,15,0,60,0,240,15,255,252,0,240,15,170,188,0,160,10,0,20,
  // 0x7cfb  系
  251,124,20,21,105,22,1,253,0,0,1,107,208,43,255,255,255,240,63,255,250,148,0,0,7,208,16,0,0,31,64,188,0,2,126,1,244,0,15,248,7,208,0,1,248,47,64,0,0,63,189,9,0,0,11,240,31,64,0,31,192,7,208,191,255,170,255,244,191,255,255,255,253,0,0,60,0,47,0,80,60,8,4,1,248,60,63,64,7,224,60,15,208,47,128,60,2,248,254,0,60,0,190,52,0,60,0,44,0,0,40,0,0,
  // 0x7d05  紅
  5,125,20,22,110,22,1,253,0,64,0,0,0,2,208,0,0,0,3,192,0,0,0,11,73,63,255,254,190,15,63,255,254,252,61,0,45,0,46,184,0,45,0,15,240,0,45,0,3,199,64,45,0,15,67,192,45,0,255,191,224,45,0,255,255,240,45,0,0,240,112,45,0,0,240,0,45,0,60,243,128,45,0,60,243,192,45,0,120,241,208,45,0,180,240,240,45,0,240,240,224,45,0,160,240,191,255,255,0,240,191,255,255,0,160,0,0,0,
  // 0x7d22  索
  34,125,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,0,0,60,0,0,0,0,60,0,0,127,255,255,255,253,126,171,250,170,189,120,3,224,0,45,120,15,128,244,45,18,253,3,240,4,1,252,31,128,0,0,47,189,45,0,0,11,240,31,128,106,191,234,171,240,127,255,255,255,252,0,32,60,0,24,0,248,60,62,0,7,224,60,15,208,127,128,60,1,252,124,0,60,0,60,0,0,40,0,0,
  // 0x7d2b  紫
  43,125,20,22,110,22,1,253,0,36,2,128,0,0,60,3,192,16,44,62,163,198,252,44,63,243,255,208,44,60,3,228,0,44,60,3,192,9,44,61,163,192,15,127,255,243,255,254,255,234,209,255,252,80,3,224,0,0,1,159,65,244,0,3,253,11,208,0,0,127,127,11,0,0,11,248,11,192,170,175,250,171,244,255,255,255,255,253,0,0,60,0,46,0,180,60,46,0,7,240,60,31,208,47,128,60,2,248,125,0,60,0,125,0,0,40,0,0,
  // 0x7d30  細
  48,125,20,22,110,22,1,253,1,0,0,0,0,3,192,0,0,0,11,64,63,255,253,15,24,63,255,253,109,61,60,60,29,252,120,60,60,29,61,240,60,60,29,15,208,60,60,29,11,157,60,60,29,15,15,60,60,29,255,255,127,255,253,255,235,255,255,253,2,194,188,60,29,18,192,60,60,29,58,222,60,60,29,118,207,60,60,29,178,199,124,60,29,242,195,188,60,29,226,193,63,255,253,82,192,63,255,253,2,192,60,0,29,1,128,0,0,0,
  // 0x7d42  終
  66,125,21,22,132,22,0,253,0,64,0,16,0,0,0,240,0,180,0,0,2,208,0,240,0,0,3,197,3,255,253,0,27,79,7,255,253,0,63,29,31,192,124,0,31,60,126,240,244,0,7,240,180,187,224,0,2,218,0,63,192,0,3,203,0,63,128,0,47,171,129,251,244,0,63,255,223,208,191,64,0,177,254,16,31,192,4,177,4,126,2,64,30,183,64,31,208,0,29,179,192,2,224,0,44,178,193,0,0,0,60,177,203,228,0,0,120,176,2,255,64,0,16,176,0,27,248,0,0,176,0,0,188,0,0,96,0,0,4,0,
  // 0x7d71  統
  113,125,22,22,132,22,0,253,0,64,0,9,0,0,0,240,0,30,0,0,2,208,0,30,0,0,3,197,63,255,255,128,27,79,127,255,255,192,62,45,0,240,0,0,31,124,1,240,180,0,7,240,2,208,60,0,2,222,3,213,126,0,3,199,127,255,255,64,47,171,191,234,91,192,63,255,192,0,2,64,0,177,194,209,208,0,4,178,2,209,208,0,30,183,66,193,208,0,29,179,195,193,208,0,44,178,195,193,208,0,60,177,139,129,209,208,120,176,47,1,209,192,16,176,253,1,255,192,0,176,240,0,255,128,0,96,0,0,0,0,
  // 0x7d72  絲
  114,125,20,22,110,22,1,253,1,64,0,20,0,3,208,0,60,0,7,192,0,120,0,15,14,0,240,144,174,47,14,209,240,252,60,31,131,208,61,180,3,219,128,15,224,0,255,16,7,207,0,124,240,15,7,64,240,124,255,191,223,251,253,255,255,239,255,255,0,240,208,30,11,20,241,0,30,0,60,247,71,158,180,56,243,203,94,124,120,242,223,30,61,240,241,175,30,30,240,240,61,30,15,80,240,24,30,9,0,240,0,30,0,0,144,0,9,0,
  // 0x7da0  綠
  160,125,20,22,110,22,1,253,1,0,1,0,0,3,192,11,64,0,11,64,15,170,160,15,20,15,255,240,109,60,30,0,240,248,180,47,170,224,124,240,63,255,224,31,192,20,2,208,15,104,170,171,250,14,45,255,255,255,190,190,0,60,0,255,255,16,60,8,3,199,188,62,61,19,196,46,63,244,119,220,15,63,208,115,206,1,63,192,179,207,11,189,224,243,203,127,124,244,227,194,248,60,126,131,193,208,60,31,3,192,3,248,4,1,128,2,160,0,
  // 0x7db2  網
  178,125,20,22,110,22,1,253,2,64,0,0,0,7,128,255,255,253,11,0,255,255,254,14,44,240,0,30,188,60,243,67,158,248,176,243,131,94,61,224,242,203,30,31,192,243,235,158,15,120,247,255,222,14,44,240,56,30,190,190,240,56,30,255,255,246,190,158,3,199,251,255,222,3,196,242,192,30,119,220,242,192,30,115,206,242,192,30,179,207,242,234,94,243,202,240,255,158,227,192,240,0,30,131,192,240,0,29,3,192,240,3,253,2,128,160,1,164,
  // 0x7dd2  緒
  210,125,20,22,110,22,1,253,1,0,0,144,0,3,192,1,208,29,11,64,1,208,61,15,24,191,255,188,109,60,171,250,244,248,180,1,209,240,125,224,1,211,192,31,193,171,255,234,15,121,255,255,255,14,44,0,252,0,190,190,3,240,0,255,255,31,255,248,3,199,255,170,248,19,198,254,0,56,119,221,78,0,56,115,206,15,255,248,179,207,15,170,184,243,203,14,0,56,227,192,14,0,56,131,192,15,255,248,3,192,15,170,248,1,128,9,0,36,
  // 0x7dda  線
  218,125,20,22,110,22,1,253,1,0,0,16,0,3,192,0,124,0,11,64,0,184,0,15,20,127,255,252,109,60,126,170,188,248,180,120,0,60,124,240,127,255,252,31,192,126,170,188,15,104,120,0,60,14,44,126,170,188,190,190,127,255,252,255,255,0,60,0,3,199,0,61,13,3,192,255,190,62,119,220,175,127,248,119,206,15,63,208,179,207,30,62,208,243,203,60,60,240,227,193,244,60,125,195,195,224,60,47,3,192,67,248,5,1,128,2,160,0,
  // 0x7de8  編
  232,125,20,22,110,22,1,253,1,0,0,0,0,3,192,0,0,0,11,65,255,255,254,15,37,255,255,254,109,60,0,0,0,252,180,191,255,252,125,224,186,170,188,31,192,176,0,60,11,116,176,0,60,14,44,191,255,252,190,189,186,170,168,255,254,176,0,0,3,203,191,255,254,3,196,190,251,238,119,236,252,115,142,115,220,254,187,238,179,206,239,255,254,243,207,220,115,142,211,195,220,115,142,131,199,140,115,142,3,199,12,115,190,2,64,8,17,20,
  // 0x7e2e  縮
  46,126,20,22,110,22,1,253,1,0,0,100,0,3,192,0,120,0,7,64,170,254,170,15,21,255,255,255,109,61,208,0,15,252,181,208,0,15,124,225,157,0,5,47,192,31,255,255,15,120,45,175,234,15,44,56,7,64,190,189,184,175,169,255,255,248,255,253,3,199,248,240,29,3,194,184,240,29,119,236,56,250,173,115,220,56,255,253,179,205,56,240,29,243,205,56,240,29,211,192,56,240,29,67,192,56,255,253,3,192,56,250,189,2,64,20,80,4,
  // 0x7e3d  總
  61,126,20,22,110,22,1,253,1,0,0,36,0,3,192,0,124,0,11,64,106,254,168,15,36,191,255,253,109,60,176,52,29,252,180,177,191,221,125,224,183,227,157,31,192,179,251,29,11,116,183,47,29,14,44,176,127,221,190,189,178,224,93,255,254,186,234,173,3,203,191,255,253,3,196,1,224,0,119,236,0,188,0,115,220,35,158,52,179,205,183,132,60,243,206,243,128,45,211,192,227,129,142,67,194,211,130,207,3,194,195,255,198,2,64,1,170,0,
  // 0x7e7c  繼
  124,126,20,22,110,22,1,253,0,1,64,0,0,11,3,195,64,208,15,3,203,17,196,29,99,236,171,108,188,243,207,195,240,244,227,199,144,232,62,195,202,114,141,31,67,239,255,255,15,179,192,20,1,45,179,255,255,255,254,187,235,170,234,255,255,195,64,208,7,95,202,33,200,7,83,236,171,108,119,183,207,195,176,183,123,195,144,232,183,111,202,114,140,231,95,255,255,255,215,67,196,21,1,71,67,255,255,255,7,67,234,170,170,1,1,64,0,0,
  // 0x7e8c  續
  140,126,20,22,110,22,1,253,1,0,0,36,0,3,128,85,185,85,11,2,255,255,255,14,36,0,120,0,124,124,191,255,252,248,240,21,85,84,125,224,255,255,253,31,192,226,207,29,11,116,239,7,253,14,60,224,0,29,190,189,255,255,253,255,254,0,0,0,3,202,127,255,252,3,196,121,85,188,119,236,121,85,188,115,221,127,255,252,179,206,116,0,60,243,192,127,255,252,211,192,31,67,208,131,193,190,2,248,3,195,244,0,63,1,64,0,0,4,
  // 0x7ea2  红
  162,126,20,20,100,22,1,254,0,240,0,0,0,2,224,0,0,0,3,208,191,255,254,11,192,191,255,254,15,0,0,60,0,46,15,0,60,0,124,47,0,60,0,255,252,0,60,0,255,244,0,60,0,3,224,0,60,0,11,192,0,60,0,47,5,0,60,0,191,255,0,60,0,255,229,0,60,0,80,0,0,60,0,0,0,0,60,0,1,190,0,60,0,255,254,255,255,255,254,64,255,255,255,64,0,0,0,0,
  // 0x7f6e  置
  110,127,20,21,105,22,1,253,5,85,85,85,84,31,255,255,255,248,29,7,65,208,120,30,91,150,229,184,31,255,255,255,248,0,0,60,0,0,106,170,190,170,169,127,255,255,255,253,0,0,60,0,0,10,31,255,255,240,31,30,0,1,240,31,31,255,255,240,31,30,0,1,240,31,30,0,1,240,31,31,255,255,240,31,30,0,1,240,31,31,255,255,240,31,0,0,0,0,31,255,255,255,255,31,170,170,170,170,9,0,0,0,0,
  // 0x7f72  署
  114,127,20,21,105,22,1,253,5,85,85,85,84,31,255,255,255,248,29,7,65,208,120,30,91,150,229,184,31,255,255,255,248,0,0,180,0,0,6,170,250,168,180,7,255,255,255,240,0,0,180,15,192,0,0,180,127,0,191,255,255,255,254,106,170,255,234,169,0,11,254,85,80,1,255,255,255,240,191,248,0,0,240,189,125,85,85,240,0,63,255,255,240,0,56,0,0,240,0,61,85,86,240,0,63,255,255,240,0,36,0,0,144,
  // 0x8070  聰
  112,128,20,22,110,22,1,253,0,0,0,20,0,255,255,128,60,0,255,255,234,190,168,44,29,63,255,253,44,29,56,52,29,44,29,57,191,221,46,189,59,227,93,47,253,59,191,29,44,29,56,31,29,44,29,56,119,93,44,29,57,208,29,47,253,63,255,253,46,189,42,250,168,44,29,0,253,0,44,29,0,31,0,44,29,18,193,32,127,253,62,192,60,255,173,118,192,45,64,30,242,192,223,0,30,226,234,219,0,29,0,255,128,0,4,0,0,0,
  // 0x81ea  自
  234,129,16,22,88,22,3,253,0,1,0,0,0,7,192,0,0,11,128,0,0,15,64,0,191,255,255,255,191,255,255,255,184,0,0,31,184,0,0,31,191,255,255,255,191,255,255,255,184,0,0,31,184,0,0,31,184,0,0,31,191,255,255,255,191,255,255,255,184,0,0,31,184,0,0,31,184,0,0,31,191,255,255,255,191,255,255,255,184,0,0,31,16,0,0,5,
  // 0x85cd  藍
  205,133,20,21,105,22,1,254,0,20,0,20,0,0,45,0,120,0,191,255,255,255,254,106,191,170,254,170,0,45,0,120,0,47,255,244,176,0,45,125,80,240,0,44,60,2,255,253,47,255,247,234,169,44,0,255,64,0,47,255,246,0,0,44,60,0,170,168,45,125,80,255,252,47,255,244,0,0,6,170,170,170,144,7,255,255,255,240,7,67,130,192,240,7,67,130,192,240,7,67,130,192,240,255,255,255,255,255,170,170,170,170,170,
  // 0x884c  行
  76,136,20,21,105,22,1,253,0,244,0,0,0,2,240,127,255,253,11,192,127,255,253,63,0,0,0,0,252,16,0,0,0,96,61,0,0,0,0,248,0,0,0,2,240,255,255,255,11,208,255,255,255,47,192,0,7,192,191,192,0,7,192,247,192,0,7,192,83,192,0,7,192,3,192,0,7,192,3,192,0,7,192,3,192,0,7,192,3,192,0,7,192,3,192,0,7,192,3,192,3,255,128,3,192,2,254,0,0,0,0,0,0,
  // 0x8868  表
  104,136,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,42,170,254,170,168,63,255,255,255,252,0,0,60,0,0,10,170,190,170,160,15,255,255,255,240,0,0,60,0,0,0,0,60,0,0,191,255,255,255,254,127,255,255,255,253,0,7,235,64,16,0,63,71,192,188,6,253,3,211,240,191,252,1,255,128,254,60,0,253,0,16,60,0,125,0,0,60,6,47,128,0,63,255,75,244,11,255,249,2,255,11,249,0,0,46,1,0,0,0,0,
  // 0x88ab  被
  171,136,20,22,110,22,1,253,1,64,0,20,0,3,192,0,44,0,3,192,0,44,0,3,192,0,44,0,3,192,127,255,255,255,253,127,255,255,255,253,120,44,30,0,60,120,44,44,0,240,120,44,24,2,231,191,255,248,7,238,127,255,252,31,252,127,128,120,191,252,183,192,244,247,206,182,208,240,147,200,241,243,208,3,192,240,191,192,3,192,240,63,64,3,194,224,127,128,3,195,194,255,240,3,199,223,225,254,3,203,95,64,62,2,64,4,0,4,
  // 0x88c5  装
  197,136,20,22,110,22,1,253,0,36,0,36,0,0,56,0,120,0,124,56,0,120,0,47,121,255,255,254,10,121,255,255,255,0,56,0,120,0,1,120,0,120,0,47,248,0,120,0,253,120,191,255,252,144,56,191,255,252,0,56,20,0,0,0,0,60,0,0,106,170,190,170,169,255,255,255,255,255,0,11,223,0,96,1,190,7,194,244,111,252,2,255,128,189,60,0,253,0,0,60,89,63,128,6,255,254,11,249,7,254,144,0,190,1,0,0,0,4,
  // 0x88dd  裝
  221,136,20,22,110,22,1,253,0,9,0,40,0,44,30,0,60,0,44,30,0,60,0,46,174,106,254,169,47,254,191,255,254,20,30,0,60,0,106,174,0,60,0,255,254,0,60,0,30,30,0,60,0,45,30,63,255,252,124,30,42,170,168,176,25,60,0,0,170,170,190,170,169,255,255,255,255,255,0,31,207,0,96,1,254,7,194,244,191,252,2,255,128,185,60,0,253,0,0,61,106,63,128,6,255,255,11,249,11,250,64,0,190,0,0,0,0,4,
  // 0x8907  複
  7,137,20,22,110,22,1,253,1,0,4,0,0,3,128,15,0,0,3,128,46,0,0,3,128,63,255,255,3,128,254,170,170,255,254,245,85,80,191,249,191,255,248,0,176,60,0,120,0,224,63,255,248,2,219,61,85,120,7,205,60,0,120,15,252,63,255,248,63,248,23,229,80,191,173,11,234,144,247,136,47,255,244,67,129,255,2,240,3,131,235,203,192,3,128,66,255,0,3,128,6,255,64,3,129,191,239,254,3,131,253,1,255,2,65,64,0,4,
  // 0x89d2  角
  210,137,18,22,110,22,1,253,0,4,0,0,0,0,31,0,0,0,0,63,255,240,0,0,190,171,240,0,1,240,3,208,0,7,224,7,192,0,31,255,255,255,240,127,255,255,255,240,59,192,30,0,240,3,192,30,0,240,3,250,191,170,240,3,255,255,255,240,3,192,30,0,240,3,192,30,0,240,3,192,30,0,240,3,255,255,255,240,7,255,255,255,240,15,0,0,0,240,31,0,0,0,240,125,0,0,0,240,248,0,0,255,240,96,0,0,191,128,
  // 0x8a08  計
  8,138,21,22,132,22,1,253,0,0,0,5,0,0,42,170,0,30,0,0,63,255,0,30,0,0,0,0,0,30,0,0,170,170,64,30,0,0,255,255,128,30,0,0,0,0,0,30,0,0,42,169,0,30,0,0,63,255,127,255,255,64,0,0,127,255,255,64,42,169,0,46,0,0,63,255,0,30,0,0,0,0,0,30,0,0,42,169,0,30,0,0,63,254,0,30,0,0,56,14,0,30,0,0,56,14,0,30,0,0,56,14,0,30,0,0,62,174,0,30,0,0,63,254,0,30,0,0,56,0,0,30,0,0,0,0,0,25,0,0,
  // 0x8a0a  訊
  10,138,21,21,126,22,1,253,42,168,0,0,0,0,63,253,191,255,240,0,0,0,191,255,240,0,170,170,3,128,240,0,255,255,3,128,240,0,0,0,3,128,240,0,42,168,3,128,240,0,63,253,3,128,240,0,0,0,255,253,240,0,42,168,255,253,240,0,63,253,7,128,240,0,0,0,7,64,240,0,42,168,11,64,240,0,63,253,15,0,240,0,56,29,15,0,240,0,56,29,46,0,242,0,56,29,60,0,182,128,62,189,248,0,123,64,63,255,240,0,63,64,56,0,208,0,47,0,0,0,0,0,0,0,
  // 0x8a18  記
  24,138,20,21,105,22,1,253,42,170,0,0,0,63,255,31,255,252,0,0,31,255,252,170,170,64,0,60,255,255,128,0,60,0,0,0,0,60,42,169,0,0,60,63,255,0,0,60,0,0,15,255,252,42,169,15,255,252,63,255,15,0,60,0,0,15,0,0,42,169,15,0,0,63,254,15,0,0,56,14,15,0,0,56,14,15,0,15,56,14,15,0,15,62,174,15,0,15,63,254,15,255,254,56,0,7,255,248,0,0,0,0,0,
  // 0x8a2d  設
  45,138,20,21,105,22,1,253,42,169,15,255,128,63,253,15,255,192,0,0,14,3,192,170,170,14,3,192,255,255,94,3,199,0,0,45,3,203,42,169,124,3,239,63,255,248,2,253,0,0,240,0,0,42,169,127,255,248,63,253,127,255,248,0,0,10,0,244,42,169,15,1,240,63,253,7,195,208,56,29,3,239,128,56,29,0,255,0,56,29,1,255,0,62,173,27,255,224,63,254,255,130,255,56,0,248,0,125,0,0,0,0,0,
  // 0x8a66  試
  102,138,21,22,132,22,1,253,0,0,0,7,148,0,42,168,0,7,188,0,63,252,0,7,143,0,0,0,0,7,138,0,170,169,0,7,128,0,255,254,255,255,255,0,0,0,255,255,255,0,42,168,0,7,128,0,63,252,0,7,128,0,0,0,0,3,128,0,42,168,255,247,128,0,63,252,191,243,128,0,0,0,15,3,192,0,42,168,15,3,192,0,63,252,15,3,192,0,56,44,15,3,192,0,56,44,15,2,209,0,56,44,15,185,211,64,62,189,255,248,247,0,63,252,249,0,255,0,56,0,0,0,126,0,0,0,0,0,20,0,
  // 0x8a8d  認
  141,138,20,21,105,22,1,253,42,168,42,170,169,63,252,127,255,253,0,0,0,240,45,170,169,57,240,44,255,254,63,224,44,0,0,7,248,60,42,168,7,254,60,63,252,15,8,60,0,0,125,11,248,42,168,244,75,240,63,252,1,244,0,0,0,0,126,0,42,168,2,143,0,63,252,39,193,116,56,44,119,192,60,56,44,179,192,45,56,44,243,193,223,62,190,227,193,223,63,253,195,255,198,56,0,1,255,128,0,0,0,0,0,
  // 0x8aa4  誤
  164,138,20,21,105,22,1,253,42,164,0,255,252,63,248,0,250,188,0,0,116,224,60,170,169,116,224,60,255,253,116,224,60,0,0,116,250,188,42,164,116,255,252,63,252,116,0,0,0,0,126,170,164,42,164,127,255,244,63,252,116,0,180,0,0,0,0,180,42,168,0,0,180,63,253,255,255,255,52,61,255,255,255,52,60,7,66,208,52,60,15,65,240,62,188,126,0,188,63,253,248,0,62,52,1,224,0,15,0,0,0,0,0,
  // 0x8abf  調
  191,138,20,21,105,22,1,253,42,160,170,170,169,63,244,255,255,253,0,0,240,16,29,170,168,240,52,29,255,252,242,186,93,0,0,243,255,157,42,160,240,52,29,63,244,240,52,29,0,0,247,255,221,42,164,242,170,93,63,244,240,0,29,0,0,243,255,93,42,164,227,155,93,127,245,227,67,93,116,53,211,67,93,116,54,211,171,93,116,55,195,255,93,122,187,195,64,29,127,255,128,3,253,116,7,0,3,248,0,1,0,0,0,
  // 0x8acb  請
  203,138,20,22,110,22,1,253,0,0,0,20,0,42,168,0,60,0,63,253,127,255,254,0,0,21,125,85,170,170,21,125,84,255,255,63,255,252,0,0,0,60,0,42,168,85,125,85,63,253,255,255,255,0,0,0,0,0,42,168,31,255,252,63,253,31,85,188,0,0,30,0,60,42,168,31,255,252,63,253,30,85,124,56,29,30,0,60,56,29,31,255,252,56,29,30,85,188,62,189,30,0,60,63,253,30,0,60,56,0,30,7,248,0,0,25,2,144,
  // 0x8b70  議
  112,139,20,22,110,22,1,253,0,0,4,0,64,42,160,29,1,224,63,244,95,87,212,0,1,255,255,253,170,168,0,180,0,255,252,21,185,84,0,0,191,255,252,42,160,0,180,0,63,247,255,255,255,0,2,170,170,169,42,164,22,222,32,63,246,255,78,124,0,0,14,15,13,42,166,175,175,169,127,247,255,255,255,116,52,14,11,16,116,53,111,231,124,116,55,255,151,240,122,181,14,7,194,127,244,14,47,231,116,0,253,180,255,0,0,84,0,24,
  // 0x8b80  讀
  128,139,20,22,110,22,1,253,0,0,0,36,0,42,160,85,185,84,63,245,255,255,254,0,0,0,116,0,255,252,191,255,252,255,252,0,0,0,0,1,255,255,254,42,161,210,206,14,63,245,218,7,254,0,1,208,0,14,42,165,255,255,254,63,244,191,255,252,0,0,180,0,60,42,164,191,255,252,127,244,176,0,60,116,52,191,255,252,116,52,176,0,60,116,52,191,255,252,122,180,15,3,208,127,244,191,2,248,116,3,244,0,63,0,0,64,0,4,
  // 0x8b8a  變
  138,139,20,22,110,22,1,253,1,0,0,1,0,11,1,255,67,128,29,80,0,11,36,124,247,255,252,180,47,192,0,31,208,15,98,255,71,164,110,120,0,31,109,255,254,255,191,255,3,68,0,2,193,59,178,255,106,220,119,122,195,122,205,179,94,195,182,203,227,75,255,242,193,1,46,0,0,64,0,191,255,255,252,7,254,170,191,168,127,189,0,188,0,56,15,219,224,0,0,3,255,192,0,22,255,255,255,165,191,249,0,111,255,36,0,0,0,24,
  // 0x8cc7  資
  199,140,20,22,110,22,1,253,0,0,20,0,0,30,64,60,0,0,31,244,191,255,253,0,178,246,245,188,0,7,194,244,244,0,96,7,252,80,111,244,111,31,128,191,67,252,7,254,33,87,229,85,253,3,255,255,255,208,3,192,0,2,208,3,255,255,255,208,3,192,0,3,208,3,192,0,3,208,3,255,255,255,208,3,192,0,2,208,3,213,85,87,208,3,255,255,255,208,0,30,0,116,0,6,253,0,127,144,127,144,0,6,253,20,0,0,0,32,
  // 0x8ddd  距
  221,141,20,21,105,22,1,253,63,255,79,255,254,63,255,95,255,255,56,11,94,0,0,56,11,94,0,0,56,11,94,0,0,56,11,94,0,0,63,255,95,255,252,63,255,95,255,252,0,224,30,0,60,16,224,30,0,60,56,224,30,0,60,56,255,158,0,60,56,255,159,255,252,56,224,31,255,252,56,224,30,0,0,56,241,158,0,0,62,255,222,0,0,255,249,31,255,255,249,0,31,255,255,0,0,30,0,0,0,0,4,0,0,
  // 0x8eca  車
  202,142,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,0,0,60,0,0,0,0,60,0,0,11,255,255,255,224,11,234,190,171,224,11,64,60,1,224,11,170,190,171,224,11,255,255,255,224,11,64,60,1,224,11,64,60,1,224,11,255,255,255,224,6,170,190,170,144,0,0,60,0,0,191,255,255,255,255,255,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,40,0,0,
  // 0x8edf  軟
  223,142,20,22,110,22,1,253,0,0,0,64,0,0,240,2,208,0,0,240,3,208,0,255,255,227,192,0,191,255,211,192,0,0,240,7,255,254,127,255,219,255,254,121,246,223,29,29,112,225,238,29,44,121,246,253,29,60,127,255,232,45,56,112,225,208,46,0,121,246,208,63,0,127,255,208,63,0,0,240,0,123,64,0,240,0,243,192,255,255,241,226,208,255,255,227,193,240,0,240,15,64,188,0,240,126,0,63,0,240,120,0,15,0,144,16,0,0,
  // 0x8ef8  軸
  248,142,20,22,110,22,1,253,0,0,0,9,0,0,224,0,29,0,0,224,0,29,0,255,255,192,29,0,191,255,192,29,0,0,224,15,255,253,127,255,207,255,253,122,231,206,29,29,112,211,206,29,29,121,231,206,29,29,127,255,206,29,29,112,211,206,29,29,122,231,207,255,253,127,255,207,255,253,0,224,14,29,29,0,224,14,29,29,255,255,238,29,29,255,255,238,29,29,0,224,15,255,253,0,224,15,255,253,0,224,14,0,29,0,144,5,0,4,
  // 0x8f09  載
  9,143,20,22,110,22,1,253,0,40,0,144,0,0,60,0,242,208,63,255,248,240,244,26,190,164,240,60,0,60,0,240,20,170,190,170,250,170,255,255,255,255,255,0,60,0,240,0,21,125,84,240,36,63,255,252,240,120,0,60,0,180,180,47,255,248,180,240,44,56,56,122,224,47,255,248,127,192,44,56,56,63,64,44,56,56,63,4,47,255,248,62,11,0,60,0,255,11,191,255,255,255,143,106,190,175,195,254,0,60,30,1,248,0,40,4,0,0,
  // 0x8f2f  輯
  47,143,20,21,105,22,1,253,0,224,7,255,252,0,224,7,149,188,255,255,199,64,60,191,255,199,149,188,0,224,7,255,252,127,255,192,0,0,122,231,218,170,170,112,211,239,255,255,121,231,199,64,60,127,255,199,149,124,112,211,199,255,252,122,231,199,64,60,127,255,199,64,60,0,224,7,255,252,0,224,7,149,188,255,255,215,64,60,255,255,235,154,191,0,224,63,255,254,0,224,58,80,60,0,224,0,0,60,0,144,0,0,0,
  // 0x8f38  輸
  56,143,21,22,132,22,1,253,1,64,0,20,0,0,2,192,0,126,0,0,2,192,0,255,64,0,255,255,130,227,192,0,191,255,75,193,240,0,2,192,47,0,189,0,191,255,254,170,175,64,182,219,99,255,199,0,177,199,0,0,0,0,182,219,21,80,13,0,191,255,63,243,78,0,177,199,52,115,78,0,182,219,57,179,78,0,191,255,63,243,78,0,2,192,52,115,78,0,2,192,57,179,78,0,255,255,127,243,78,0,255,255,116,115,78,0,2,192,52,112,14,0,2,192,52,112,14,0,2,192,53,240,253,0,1,128,16,64,84,0,
  // 0x8f49  轉
  73,143,20,22,110,22,1,253,0,0,0,24,0,1,208,0,28,0,1,208,63,255,255,255,255,154,190,169,191,255,128,45,0,1,208,31,255,253,127,255,92,28,29,122,235,95,255,253,112,195,93,45,29,118,231,93,45,29,127,255,95,255,253,112,195,64,28,56,122,235,191,255,254,127,255,126,165,91,1,208,0,1,224,1,208,63,255,255,255,255,235,170,250,255,255,203,65,224,1,208,3,193,224,1,208,1,193,224,1,208,0,63,208,1,128,0,26,64,
  // 0x8fd1  近
  209,143,20,21,105,22,1,253,36,0,0,27,240,126,0,239,255,228,31,128,255,164,0,7,208,240,0,0,1,64,240,0,0,0,0,240,0,0,0,0,255,255,255,0,0,255,255,255,0,0,240,15,0,255,192,240,15,0,255,193,224,15,0,3,194,208,15,0,3,195,192,15,0,3,199,192,15,0,3,207,64,15,0,3,206,0,15,0,11,224,0,15,0,127,249,0,0,0,252,63,255,255,255,160,6,255,255,254,0,0,0,0,0,
  // 0x8fd4  返
  212,143,20,21,105,22,1,253,120,2,255,255,253,63,2,255,255,253,15,194,208,0,0,3,194,208,0,0,1,2,208,0,0,0,2,255,255,244,0,2,255,255,244,0,2,239,0,240,255,130,223,66,224,255,131,199,195,192,3,131,195,219,128,3,131,192,255,0,3,139,128,190,0,3,143,2,255,128,3,159,31,219,244,7,237,127,65,255,31,228,56,0,44,127,253,0,0,0,248,63,255,255,255,160,6,255,255,254,0,0,0,0,0,
  // 0x9000  退
  0,144,20,21,105,22,1,253,40,0,170,170,160,126,0,255,255,240,31,192,224,0,240,3,208,224,0,240,1,128,255,255,240,0,0,250,170,240,0,0,224,0,240,0,0,250,170,240,255,192,255,255,240,255,192,224,240,44,3,192,224,120,252,3,192,224,63,224,3,192,224,31,64,3,192,224,95,192,3,193,255,243,244,3,203,255,64,254,15,231,144,0,44,127,253,0,0,0,252,63,255,255,255,160,6,255,255,254,0,0,0,0,0,
  // 0x901f  速
  31,144,20,22,110,22,1,253,0,0,0,80,0,36,0,1,224,0,125,0,1,224,0,47,79,255,255,254,7,218,171,250,170,1,64,1,224,0,0,3,255,255,252,0,3,234,250,188,0,3,193,224,60,255,195,193,224,60,255,195,234,250,188,3,195,255,255,252,3,192,11,252,0,3,192,47,255,0,3,192,189,231,208,3,199,241,225,248,3,207,129,224,126,15,229,1,224,8,127,253,0,80,0,252,63,255,255,255,160,6,255,255,254,0,0,0,0,0,
  // 0x9023  連
  35,144,20,22,110,22,1,253,0,0,1,144,0,36,0,2,208,0,125,10,171,250,169,47,79,255,255,253,11,192,2,208,0,3,65,86,229,80,0,7,255,255,244,0,7,130,208,180,0,7,214,229,180,255,135,255,255,244,255,135,130,208,180,7,135,214,229,244,7,135,255,255,244,7,128,2,208,0,7,154,171,250,170,7,175,255,255,255,7,128,2,208,0,15,208,2,208,0,127,248,0,0,0,248,127,255,255,255,160,7,255,255,254,0,0,0,0,0,
  // 0x9032  進
  50,144,20,22,110,22,1,253,0,0,16,0,0,36,0,124,31,0,125,0,184,46,0,47,65,240,60,0,11,195,255,255,252,3,75,250,254,168,0,31,208,120,0,0,127,208,120,0,0,123,255,255,248,255,146,250,254,164,255,130,208,120,0,7,130,250,254,164,7,130,255,255,248,7,130,208,120,0,7,130,208,120,0,7,130,250,254,169,7,130,255,255,254,15,208,0,0,0,127,248,0,0,0,248,127,255,255,255,160,7,255,255,254,0,0,0,0,0,
  // 0x904b  運
  75,144,20,21,105,22,1,253,32,15,255,255,253,189,15,170,170,173,47,14,1,224,29,11,197,86,245,84,3,139,255,255,252,0,0,1,224,0,0,1,86,229,80,0,3,255,255,244,255,131,193,224,116,255,131,255,255,244,7,131,194,224,180,7,131,214,229,180,7,131,255,255,244,7,128,1,224,0,7,159,255,255,255,7,138,170,250,169,15,208,1,224,0,127,248,0,80,0,248,127,255,255,255,160,7,255,255,254,0,0,0,0,0,
  // 0x9054  達
  84,144,20,22,110,22,1,253,0,0,0,144,0,36,0,1,224,0,125,3,255,255,244,31,65,86,245,80,11,192,1,224,0,2,95,255,255,255,0,10,250,171,233,0,0,120,7,128,0,0,60,11,0,255,143,255,255,254,255,133,86,245,85,7,129,86,245,84,7,131,255,255,248,7,128,1,224,0,7,138,170,250,169,7,143,255,255,254,7,128,1,224,0,15,208,1,224,0,127,248,0,0,0,248,63,255,255,255,160,7,255,255,254,0,0,0,0,0,
  // 0x9078  選
  120,144,20,21,105,22,1,253,48,31,255,127,252,188,5,95,21,124,47,0,15,0,60,15,143,255,63,252,2,15,85,61,88,0,15,87,125,95,0,11,255,31,253,0,0,20,5,0,255,64,60,15,0,255,79,255,255,252,7,74,190,175,168,7,64,60,15,0,7,90,190,175,169,7,111,255,255,255,7,64,40,6,0,7,65,248,7,224,15,207,208,0,252,126,250,0,0,36,248,127,255,255,255,160,7,255,255,254,0,0,0,0,0,
  // 0x9084  還
  132,144,20,21,105,22,1,253,52,11,255,255,248,126,11,94,44,120,31,139,14,44,56,7,203,255,255,248,1,0,0,0,0,0,21,85,85,85,0,63,255,255,255,0,0,0,0,0,255,131,255,255,240,255,131,192,0,240,7,131,192,0,240,7,131,255,255,240,7,128,15,224,124,7,128,127,254,224,7,135,246,239,192,7,143,130,195,253,15,212,2,192,108,127,248,1,128,0,248,127,255,255,255,160,7,255,255,254,0,0,0,0,0,
  // 0x908a  邊
  138,144,20,22,110,22,1,253,4,0,1,144,0,63,2,255,255,240,15,194,208,0,240,3,210,255,255,240,0,66,208,0,240,32,2,255,255,240,189,2,208,0,240,47,130,255,255,240,7,64,2,208,0,1,15,255,255,254,0,14,28,56,110,255,134,244,191,224,255,130,65,208,0,7,159,255,255,255,7,128,30,0,0,7,128,47,255,208,7,129,248,2,208,15,223,224,3,192,127,254,0,191,64,248,127,255,255,255,160,7,255,255,254,0,0,0,0,0,
  // 0x90e8  部
  232,144,20,22,110,22,1,253,0,20,0,0,0,0,120,0,0,0,0,120,0,255,254,191,255,252,255,255,127,255,248,240,45,10,1,208,240,60,15,2,208,240,120,11,3,192,240,244,7,67,128,240,240,255,255,252,242,208,255,255,252,241,240,0,0,0,240,184,0,0,0,240,60,47,255,240,240,30,47,255,240,240,14,44,0,240,240,15,44,0,240,240,46,44,0,240,243,253,47,255,240,242,244,47,255,240,240,0,44,0,240,240,0,20,0,80,160,0,
  // 0x91cb  釋
  203,145,20,21,105,22,1,253,5,191,21,85,84,255,248,63,255,253,86,193,56,211,29,114,199,184,211,29,118,203,63,255,253,58,206,21,125,84,58,221,5,125,84,2,192,31,255,248,255,255,64,60,0,171,250,149,125,85,7,208,255,255,255,11,244,7,0,224,15,253,3,65,208,46,223,87,215,213,58,194,127,255,254,242,192,0,60,0,226,192,63,255,252,130,192,21,125,84,2,192,0,60,0,2,192,0,60,0,1,128,0,24,0,
  // 0x91cd  重
  205,145,20,20,100,22,1,254,0,5,90,191,192,15,255,255,255,144,5,64,60,0,0,106,170,190,170,169,191,255,255,255,254,0,0,60,0,0,1,85,125,85,80,7,255,255,255,224,7,128,60,1,224,7,255,255,255,224,7,149,125,86,224,7,128,60,1,224,7,255,255,255,224,1,85,189,85,80,0,0,60,0,0,15,255,255,255,244,10,170,190,170,164,0,0,60,0,0,170,170,190,170,170,255,255,255,255,255,
  // 0x91cf  量
  207,145,20,20,100,22,1,254,3,255,255,255,192,3,192,0,3,192,3,255,255,255,192,3,192,0,3,192,3,192,0,3,192,3,255,255,255,192,85,85,85,85,85,255,255,255,255,255,0,0,0,0,0,7,255,255,255,224,7,128,60,1,224,7,255,255,255,224,7,128,60,1,224,7,128,60,1,224,7,255,255,255,224,0,0,60,0,0,15,255,255,255,240,5,85,125,85,80,106,170,190,170,170,255,255,255,255,255,
  // 0x91dd  針
  221,145,20,22,110,22,1,253,0,160,0,5,0,2,252,0,15,0,3,255,0,15,0,11,139,192,15,0,47,2,240,15,0,188,0,208,15,0,254,170,64,15,0,111,255,64,15,0,0,240,47,255,255,0,240,47,255,255,127,255,208,15,0,191,255,224,15,0,0,240,0,15,0,36,242,192,15,0,56,243,192,15,0,44,243,128,15,0,28,247,64,15,0,4,241,80,15,0,5,255,224,15,0,255,255,144,15,0,185,64,0,15,0,0,0,0,9,0,
  // 0x9215  鈕
  21,146,20,22,110,22,1,253,1,144,0,0,0,3,244,0,0,0,11,253,47,255,244,15,47,47,255,244,61,11,192,240,180,248,3,65,224,180,255,254,1,224,180,43,250,1,224,180,1,208,2,208,180,1,208,2,208,180,191,255,191,255,255,191,255,127,255,255,1,208,3,192,240,49,215,3,192,240,53,219,3,192,240,57,222,3,192,240,45,221,3,128,240,1,208,7,128,240,2,255,135,64,240,255,254,255,255,255,185,64,255,255,255,0,0,0,0,0,
  // 0x932f  錯
  47,147,20,22,110,22,1,253,1,144,2,129,128,3,244,3,193,208,11,253,3,193,208,15,31,107,235,249,61,11,255,255,254,248,3,67,193,208,255,254,3,193,208,43,250,3,193,208,1,208,191,255,255,1,208,191,255,255,191,255,64,0,0,191,255,74,170,168,1,208,15,255,252,49,215,15,0,60,53,219,15,0,60,57,222,15,170,188,45,221,15,255,252,1,209,79,0,60,23,255,143,0,60,255,250,79,255,252,185,0,15,170,188,0,0,9,0,36,
  // 0x9375  鍵
  117,147,20,22,110,22,1,253,2,128,0,1,0,7,224,0,7,0,15,250,253,111,168,30,63,252,191,252,124,30,60,7,28,248,8,57,175,175,250,168,118,255,255,63,252,176,7,28,3,128,240,111,172,3,129,255,191,252,255,254,239,7,0,171,232,14,175,169,3,129,206,255,253,99,157,221,7,0,115,172,252,7,0,55,168,253,255,255,55,164,121,175,234,19,128,188,7,0,23,254,255,70,0,255,239,199,254,171,164,15,0,191,255,0,0,0,0,0,
  // 0x9577  長
  119,149,20,21,105,22,1,253,0,170,170,170,144,0,255,255,255,224,0,240,0,0,0,0,240,0,0,0,0,255,255,255,192,0,250,170,170,128,0,240,0,0,0,0,255,255,255,192,0,250,170,170,128,0,240,0,0,0,191,255,255,255,254,255,255,255,255,255,0,240,61,0,112,0,240,31,2,244,0,240,15,159,192,0,240,3,254,0,0,240,1,252,0,0,246,253,127,128,31,255,253,11,254,47,233,0,1,190,0,0,0,0,4,
  // 0x9589  閉
  137,149,18,21,105,22,2,253,170,170,10,170,160,255,255,15,255,240,240,15,15,0,240,245,95,15,85,240,255,255,15,255,240,240,15,15,0,240,240,15,15,0,240,255,255,15,255,240,250,170,10,170,240,240,0,29,0,240,240,0,29,0,240,241,255,255,244,240,241,170,255,164,240,240,0,253,0,240,240,3,237,0,240,240,31,29,0,240,240,189,29,0,240,242,224,29,0,240,240,65,189,191,240,240,1,248,63,208,160,0,0,0,0,
  // 0x958b  開
  139,149,18,21,105,22,2,253,170,170,10,170,160,255,255,15,255,240,240,15,15,0,240,245,95,15,85,240,255,255,15,255,240,240,15,15,0,240,245,95,15,85,240,255,255,15,255,240,240,0,0,0,240,240,170,170,160,240,241,255,255,244,240,240,14,15,0,240,240,14,15,0,240,242,175,175,168,240,242,255,255,252,240,240,29,15,0,240,240,44,15,0,240,240,60,15,0,240,240,244,15,47,240,241,224,15,31,208,160,0,0,0,0,
  // 0x9593  間
  147,149,18,21,105,22,2,253,170,170,10,170,160,255,255,15,255,240,240,15,15,0,240,245,95,15,85,240,255,255,15,255,240,240,15,15,0,240,240,15,15,0,240,255,255,15,255,240,250,170,10,170,240,240,0,0,0,240,240,63,255,192,240,240,62,171,192,240,240,56,3,192,240,240,61,87,192,240,240,63,255,192,240,240,56,3,192,240,240,56,3,192,240,240,63,255,192,240,240,62,170,191,240,240,36,0,63,208,160,0,0,0,0,
  // 0x95dc  關
  220,149,18,21,105,22,2,253,85,85,5,85,80,255,255,15,255,240,240,15,15,0,240,255,255,15,255,240,245,95,15,85,240,240,15,15,0,240,255,255,15,255,240,245,125,11,149,240,240,116,10,0,240,242,231,124,208,240,240,253,47,128,240,240,55,74,48,240,240,127,223,248,240,243,144,249,24,240,240,195,92,32,240,240,195,92,48,240,240,255,95,240,240,240,15,28,0,240,240,46,28,15,240,240,120,28,15,208,144,0,0,0,0,
  // 0x964d  降
  77,150,19,22,110,22,2,253,0,0,1,0,0,255,224,15,64,0,255,240,31,170,128,224,240,127,255,208,225,209,252,7,192,226,199,239,31,64,227,199,75,189,0,231,64,3,248,0,231,64,11,254,0,227,193,191,95,248,225,235,244,42,252,224,242,64,60,0,224,243,255,255,240,224,242,254,190,160,235,240,116,60,0,235,192,116,60,0,224,10,254,254,168,224,15,255,255,252,224,0,0,60,0,224,0,0,60,0,224,0,0,60,0,144,0,0,20,0,
  // 0x9664  除
  100,150,19,22,110,22,2,253,0,0,2,128,0,255,224,11,240,0,255,240,31,188,0,224,240,61,46,0,225,208,248,15,128,226,195,224,3,240,227,223,128,0,252,231,94,255,255,188,231,64,171,250,64,227,192,2,192,0,225,224,2,192,0,224,242,171,250,160,224,247,255,255,240,224,240,2,192,0,235,241,210,194,64,235,194,194,195,192,224,3,194,194,224,224,15,66,192,240,224,31,2,192,184,224,45,2,192,56,224,4,63,192,16,224,0,47,64,0,
  // 0x968e  階
  142,150,19,21,105,22,2,253,255,227,192,120,0,255,243,192,120,96,225,227,234,122,244,226,211,255,127,128,227,195,192,124,0,227,131,192,120,20,231,67,219,120,44,231,75,255,126,188,227,223,229,47,244,225,212,3,192,0,224,224,7,128,0,224,242,255,255,240,224,242,250,170,240,235,226,192,0,240,235,130,234,170,240,224,2,255,255,240,224,2,192,0,240,224,2,192,0,240,224,2,255,255,240,224,2,250,170,240,144,1,64,0,80,
  // 0x96d9  雙
  217,150,20,22,110,22,1,253,1,0,0,64,0,7,78,0,226,192,15,29,2,211,128,31,255,243,255,253,62,125,91,219,148,190,60,31,199,64,255,255,255,255,252,30,44,7,199,64,15,255,211,255,252,14,125,67,219,148,14,125,83,219,148,15,255,243,255,254,0,0,0,0,0,47,255,255,255,192,26,254,170,175,192,0,188,0,47,0,0,47,129,252,0,0,11,255,224,0,0,23,255,228,0,107,255,235,255,249,191,248,0,111,253,20,0,0,0,20,
  // 0x96e2  離
  226,150,20,22,110,22,1,253,0,96,0,16,0,0,176,0,120,116,170,250,164,180,240,255,255,248,240,240,0,4,1,225,224,54,108,226,255,255,54,248,227,255,254,52,252,235,209,208,59,201,255,209,208,59,149,238,251,249,63,255,225,255,254,0,176,1,209,208,106,250,161,209,208,191,255,241,209,208,176,208,177,255,254,177,205,177,251,250,177,202,177,209,208,187,255,177,209,208,177,3,177,255,255,176,0,177,255,255,176,11,241,208,0,96,2,64,64,0,
  // 0x96fb  電
  251,150,20,21,105,22,1,253,10,170,170,170,160,15,255,255,255,240,0,0,60,0,0,127,255,255,255,253,121,85,125,85,109,116,0,60,0,29,118,255,60,255,93,116,0,60,0,29,3,255,60,255,192,0,0,40,0,0,1,85,85,85,64,7,255,255,255,208,7,128,60,2,208,7,255,255,255,208,7,149,125,86,208,7,128,60,2,208,7,255,255,255,212,7,149,189,85,75,6,64,60,0,15,0,0,63,255,254,0,0,6,170,164,
  // 0x9752  青
  82,151,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,31,255,255,255,244,10,170,190,170,164,0,0,60,0,0,7,255,255,255,224,1,85,189,85,80,0,0,60,0,0,191,255,255,255,254,106,170,170,170,169,1,170,170,170,64,2,255,255,255,192,2,208,0,3,192,2,229,85,91,192,2,255,255,255,192,2,208,0,3,192,2,229,85,91,192,2,255,255,255,192,2,208,0,3,192,2,208,0,7,192,2,208,1,255,128,1,128,0,169,0,
  // 0x975e  非
  94,151,20,22,110,22,1,253,0,5,0,64,0,0,15,66,224,0,0,15,66,224,0,0,15,66,224,0,127,255,66,255,254,127,255,66,255,254,0,15,66,224,0,0,15,66,224,0,0,15,66,224,0,63,255,66,255,252,63,255,66,255,252,0,15,66,224,0,0,15,2,224,0,0,31,242,224,0,191,255,242,255,255,255,190,2,255,255,80,60,2,224,0,0,248,2,224,0,3,240,2,224,0,31,192,2,224,0,63,0,2,224,0,4,0,1,144,0,
  // 0x9762  面
  98,151,20,20,100,22,1,253,191,255,255,255,255,191,255,255,255,254,0,0,184,0,0,0,0,244,0,0,47,255,255,255,248,47,255,255,255,248,44,15,0,224,120,44,15,0,224,120,44,15,170,224,120,44,15,255,224,120,44,15,0,224,120,44,15,0,224,120,44,15,170,224,120,44,15,255,224,120,44,15,0,224,120,44,15,0,224,120,47,255,255,255,248,47,255,255,255,248,44,0,0,0,120,20,0,0,0,20,
  // 0x9805  項
  5,152,20,21,105,22,1,253,0,0,170,170,170,0,0,255,255,255,255,254,0,188,0,255,254,0,120,0,3,192,42,254,168,3,192,63,255,253,3,192,56,0,45,3,192,61,85,125,3,192,63,255,253,3,192,56,0,45,3,192,56,0,45,3,192,63,255,253,3,239,61,85,125,27,254,120,0,45,255,208,62,170,189,248,0,63,255,253,0,0,1,0,64,0,0,47,67,224,0,2,253,0,253,0,11,224,0,47,0,1,0,0,4,
  // 0x9810  預
  16,152,20,21,105,22,1,253,191,255,106,170,170,191,255,191,255,255,0,31,0,61,0,20,60,0,60,0,62,244,31,255,252,31,224,31,170,188,2,244,30,0,44,0,188,30,85,124,255,255,239,255,252,255,255,222,0,44,2,195,158,0,44,2,199,95,255,252,2,203,30,85,124,2,192,30,0,44,2,192,31,170,188,2,192,31,255,252,2,192,2,64,128,3,192,31,194,248,127,193,254,0,126,63,64,224,0,14,0,0,0,0,0,
  // 0x984d  額
  77,152,20,22,110,22,1,253,0,144,0,0,0,0,240,26,170,170,170,250,175,255,255,255,255,208,46,0,241,65,208,45,0,243,193,214,190,168,11,255,75,255,252,31,95,75,0,44,190,15,11,149,124,255,252,11,255,252,2,252,11,0,44,2,254,11,0,44,15,159,139,255,252,190,3,219,149,124,255,255,139,0,44,46,175,11,170,188,44,11,11,255,252,44,11,0,64,64,46,175,7,225,244,47,255,111,128,125,44,0,189,0,31,0,0,16,0,0,
  // 0x985e  類
  94,152,20,22,110,22,1,253,0,64,0,0,0,116,226,218,170,170,60,227,159,255,255,40,231,0,46,0,106,250,144,60,0,255,255,219,255,253,3,244,11,170,189,15,254,11,0,45,61,235,203,85,125,244,225,203,255,253,80,160,11,0,45,0,160,11,0,45,0,224,11,255,253,255,255,235,149,125,191,255,219,0,45,1,224,11,170,189,3,248,11,255,253,7,255,0,128,64,47,75,199,225,244,253,2,175,128,125,176,0,189,0,31,0,0,16,0,0,
  // 0x98a8  風
  168,152,20,20,100,22,1,253,11,255,255,255,224,11,255,255,255,224,11,0,0,81,224,11,106,255,245,224,11,127,253,65,224,11,0,56,1,224,11,26,190,165,224,11,47,255,245,224,15,44,56,117,224,15,44,56,117,224,15,44,56,117,224,15,46,190,180,224,15,47,255,244,240,30,0,56,96,240,45,0,56,180,242,60,0,62,188,243,124,255,255,253,183,244,250,84,14,127,240,0,0,9,46,0,0,0,0,0,
  // 0x98fd  飽
  253,152,20,21,105,22,1,254,0,160,1,64,0,3,252,3,192,0,7,239,7,128,0,15,11,203,234,169,62,99,223,255,253,252,176,110,0,29,249,249,124,0,29,47,255,254,169,29,44,7,175,254,29,45,91,64,14,45,47,255,64,14,45,44,7,64,14,45,46,171,79,254,44,47,255,79,169,60,44,4,15,3,252,44,45,15,2,244,44,15,15,0,0,45,191,143,0,11,191,251,207,0,15,254,66,207,255,255,0,0,7,255,252,
  // 0x9918  餘
  24,153,20,22,110,22,1,253,1,144,0,40,0,3,244,0,127,0,11,125,0,255,64,31,15,2,231,192,126,91,203,194,240,251,254,95,64,252,208,0,190,0,63,63,255,190,170,191,61,95,23,255,240,60,11,0,44,0,63,255,0,44,0,61,95,42,191,170,61,95,63,255,254,63,255,0,44,0,60,0,10,44,116,62,170,14,44,120,63,255,45,44,60,60,0,60,44,30,62,170,244,44,15,63,255,160,60,10,60,0,3,252,0,24,0,1,164,0,
  // 0x99ac  馬
  172,153,20,21,105,22,1,253,7,255,255,255,240,7,255,255,255,240,7,128,45,0,0,7,128,45,0,0,7,234,190,170,128,7,255,255,255,208,7,128,45,0,0,7,128,45,0,0,7,255,255,255,208,7,234,190,170,128,7,128,45,0,0,7,255,255,255,253,7,255,255,255,253,0,0,0,0,45,14,4,20,56,45,14,44,44,60,61,29,29,29,30,60,60,14,14,13,60,124,14,15,0,124,244,14,0,31,248,16,0,0,15,224,
  // 0x9a45  驅
  69,154,20,21,105,22,1,253,42,170,26,170,169,63,255,63,255,254,52,224,60,0,0,52,224,60,63,244,63,255,60,57,116,62,249,60,52,52,52,224,60,52,52,62,249,60,57,116,63,255,60,63,244,52,224,60,0,0,52,224,61,252,254,63,255,125,220,218,42,171,125,140,202,0,23,125,140,202,122,183,125,140,202,105,223,125,252,254,169,203,60,84,84,217,75,60,0,0,192,15,63,255,255,0,190,62,170,170,0,100,20,0,0,
  // 0x9ad4  體
  212,154,20,22,110,22,1,253,0,0,0,81,64,31,255,0,179,128,30,175,5,183,212,28,11,15,255,253,28,255,13,115,93,28,219,15,255,253,28,203,14,183,157,109,235,77,115,93,191,255,223,255,253,176,0,213,85,84,186,170,229,85,85,31,255,47,255,255,29,15,1,85,84,31,255,11,255,252,30,95,11,0,60,29,15,11,85,124,31,255,11,255,252,30,95,1,192,224,29,15,1,208,208,29,15,22,246,229,29,127,63,255,255,8,36,0,0,0,
  // 0x9ad8  高
  216,154,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,127,255,255,255,253,191,255,255,255,253,0,0,0,0,0,0,85,85,85,0,0,255,255,255,0,0,240,0,15,0,0,240,0,15,0,0,255,255,255,0,0,85,85,85,0,26,170,170,170,168,47,255,255,255,248,45,0,0,0,120,45,5,85,80,120,45,15,255,240,120,45,14,0,176,120,45,14,0,176,120,45,15,255,240,120,45,15,85,96,120,45,9,0,15,248,24,0,0,15,224,
  // 0x9ec3  黃
  195,158,20,22,110,22,1,253,0,24,0,40,0,0,60,0,60,0,47,255,255,255,252,26,190,170,190,168,0,60,0,60,0,0,63,255,252,0,0,21,85,84,0,170,170,170,170,170,255,255,255,255,255,0,0,60,0,0,1,85,125,85,64,7,255,255,255,224,7,128,60,2,224,7,213,125,86,224,7,255,255,255,224,7,128,60,2,224,7,213,125,86,224,7,255,255,255,224,0,125,0,125,0,27,253,0,111,244,191,128,0,1,254,16,0,0,0,4,
  // 0x9ede  點
  222,158,20,22,110,22,1,253,0,0,0,9,0,127,255,224,30,0,121,245,224,30,0,121,162,224,30,0,122,170,224,30,0,119,173,224,31,255,119,172,224,31,255,112,160,224,30,0,127,255,224,30,0,21,245,64,30,0,0,240,0,30,0,127,255,231,255,252,42,250,151,255,253,0,245,167,64,45,191,255,247,64,45,170,84,7,64,45,0,1,135,64,45,55,105,215,64,45,54,156,247,64,45,178,205,123,255,253,226,200,7,255,253,0,0,6,64,24,
  // 0x9f4a  齊
  74,159,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,106,170,190,170,169,191,255,255,255,254,0,2,130,128,0,21,86,211,134,248,127,253,235,127,224,15,29,60,56,224,14,28,60,52,176,45,44,60,57,188,185,252,60,255,239,161,144,40,149,74,2,208,0,3,192,2,255,255,255,192,2,234,170,171,192,2,208,0,3,192,3,234,170,171,192,7,255,255,255,192,15,128,0,3,192,63,0,0,3,192,125,0,0,3,192,20,0,0,2,128,
  // 0xff1a  ：
  26,255,4,15,15,22,9,0,124,255,190,40,0,0,0,0,0,0,0,125,255,190,40,
};

#endif // HAS_GRAPHICAL_TFT
