/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Simplified Chinese 22pt, capital 'A' height: 16px, width: 100%, range: 0x201c-0xff1a, glyphs: 373
extern const uint8_t NotoSans_Medium_Simplified_Chinese_16[43240] = {
  162,16,28,32,26,255,21,250, // unifont_t
  // 0x201c  “
  28,32,8,6,12,8,0,10,10,6,30,15,45,30,60,61,124,61,104,40,
  // 0x201d  ”
  29,32,8,6,12,8,0,10,42,26,62,47,60,46,124,60,116,60,96,36,
  // 0x22bf  ⊿
  191,34,17,18,90,22,2,255,0,0,0,0,192,0,0,0,3,192,0,0,0,11,192,0,0,0,47,192,0,0,0,191,192,0,0,2,243,192,0,0,7,195,192,0,0,31,3,192,0,0,124,3,192,0,1,244,3,192,0,7,208,3,192,0,15,64,3,192,0,61,0,3,192,0,248,0,3,192,3,224,0,3,192,15,128,0,3,192,63,255,255,255,192,191,255,255,255,192,
  // 0x4e00  一
  0,78,20,2,10,22,1,7,255,255,255,255,255,255,255,255,255,255,
  // 0x4e09  三
  9,78,20,17,85,22,1,255,15,255,255,255,244,15,255,255,255,244,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,255,255,255,128,3,255,255,255,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,255,255,255,253,127,255,255,255,253,
  // 0x4e0a  上
  10,78,20,20,100,22,1,254,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,255,255,244,0,0,255,255,244,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,0,0,244,0,0,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,
  // 0x4e0b  下
  11,78,20,20,100,22,1,253,191,255,255,255,254,191,255,255,255,254,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,191,128,0,0,0,191,244,0,0,0,185,255,0,0,0,184,47,224,0,0,184,7,244,0,0,184,0,160,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,100,0,0,
  // 0x4e0d  不
  13,78,20,20,100,22,1,253,127,255,255,255,253,127,255,255,255,253,0,0,31,64,0,0,0,62,0,0,0,0,188,0,0,0,2,252,0,0,0,7,253,240,0,0,31,253,253,0,0,126,60,63,128,2,248,60,11,224,31,224,60,2,252,191,64,60,0,127,124,0,60,0,29,16,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,40,0,0,
  // 0x4e13  专
  19,78,20,22,110,22,1,253,0,0,144,0,0,0,0,240,0,0,0,1,240,0,0,15,255,255,255,240,15,255,255,255,240,0,3,192,0,0,0,11,128,0,0,191,255,255,255,253,191,255,255,255,253,0,30,0,0,0,0,45,0,0,0,0,60,0,0,0,0,127,255,255,224,0,191,255,255,208,0,0,0,31,64,0,0,0,125,0,0,41,1,244,0,0,63,235,208,0,0,6,255,192,0,0,0,27,253,0,0,0,0,190,0,0,0,0,4,0,
  // 0x4e1d  丝
  29,78,20,20,100,22,1,255,0,16,0,0,0,0,60,0,15,0,0,184,0,31,0,0,240,0,61,0,1,224,64,124,0,3,192,240,244,44,7,130,225,224,124,15,7,195,192,244,63,191,79,235,224,63,254,15,255,192,0,124,5,15,64,0,240,0,61,0,3,208,0,184,0,11,128,2,224,0,47,255,219,255,252,47,255,155,255,248,0,0,0,0,0,0,0,0,0,0,191,255,255,255,254,255,255,255,255,255,
  // 0x4e2a  个
  42,78,21,21,126,22,1,253,0,0,189,0,0,0,0,1,255,0,0,0,0,3,239,192,0,0,0,15,195,240,0,0,0,63,0,252,0,0,0,252,0,63,0,0,7,240,0,15,208,0,47,128,40,2,252,0,254,0,60,0,127,64,240,0,60,0,15,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,0,0,0,0,
  // 0x4e2d  中
  45,78,18,22,110,22,2,253,0,0,80,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,255,255,255,255,240,255,255,255,255,240,240,0,240,1,240,240,0,240,1,240,240,0,240,1,240,240,0,240,1,240,240,0,240,1,240,255,255,255,255,240,255,255,255,255,240,240,0,240,1,240,80,0,240,0,64,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,160,0,0,
  // 0x4e3a  为
  58,78,19,22,110,22,1,253,0,0,80,0,0,2,64,240,0,0,3,192,240,0,0,2,240,240,0,0,0,240,240,0,0,0,1,240,0,0,63,255,255,255,252,63,255,255,255,252,0,2,224,0,120,0,3,208,0,120,0,3,193,0,120,0,7,207,64,184,0,15,71,192,184,0,31,2,224,184,0,62,0,240,180,0,188,0,64,244,1,244,0,0,244,7,224,0,0,240,31,128,0,2,240,126,0,2,255,224,36,0,0,255,128,0,0,0,0,0,
  // 0x4e3b  主
  59,78,20,21,105,22,1,254,0,0,64,0,0,0,2,240,0,0,0,0,252,0,0,0,0,63,0,0,0,0,15,64,0,47,255,255,255,248,47,255,255,255,248,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,11,255,255,255,224,11,255,255,255,224,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,191,255,255,255,255,191,255,255,255,255,
  // 0x4e49  义
  73,78,20,20,100,22,1,254,0,0,240,0,0,0,0,180,0,64,1,0,60,0,240,11,64,61,2,240,3,192,31,3,208,2,208,8,7,192,0,240,0,15,64,0,244,0,31,0,0,124,0,61,0,0,47,0,188,0,0,15,193,240,0,0,7,231,208,0,0,1,255,128,0,0,0,255,0,0,0,2,255,192,0,0,31,215,244,0,1,191,0,255,64,31,244,0,47,248,255,128,0,2,255,116,0,0,0,28,
  // 0x4e4b  之
  75,78,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,63,255,255,255,244,63,255,255,255,248,0,0,0,3,240,0,0,0,11,192,0,0,0,31,64,0,0,0,62,0,0,0,0,248,0,0,0,3,240,0,2,224,15,192,0,3,208,63,0,0,11,225,252,0,0,15,251,224,0,0,47,127,64,0,0,61,31,228,0,0,252,7,255,255,255,176,0,107,255,254,0,0,0,0,0,
  // 0x4e86  了
  134,78,18,20,100,22,2,253,191,255,255,255,192,191,255,255,255,208,0,0,0,47,64,0,0,0,189,0,0,0,3,244,0,0,0,31,208,0,0,0,255,0,0,0,0,248,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,1,255,240,0,0,0,255,208,0,0,0,0,0,0,0,
  // 0x4e8c  二
  140,78,20,16,80,22,1,255,15,255,255,255,240,15,255,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,254,191,255,255,255,254,21,85,85,85,84,
  // 0x4e8e  于
  142,78,20,20,100,22,1,253,15,255,255,255,240,15,255,255,255,240,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,191,255,255,255,254,191,255,255,255,254,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,0,61,0,0,0,63,252,0,0,0,63,244,0,0,0,0,0,0,0,
  // 0x4ea4  交
  164,78,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,0,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,4,0,20,0,0,62,0,125,0,0,252,0,47,128,3,240,0,7,240,31,192,0,17,252,191,46,0,188,126,40,15,0,244,24,0,11,130,240,0,0,3,215,208,0,0,2,255,128,0,0,0,255,0,0,0,2,255,128,0,0,31,239,244,0,6,255,66,255,128,191,248,0,47,254,127,64,0,2,253,16,0,0,0,4,
  // 0x4eae  亮
  174,78,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,106,170,190,170,169,191,255,255,255,254,0,0,0,0,0,1,85,85,85,64,2,255,255,255,192,2,208,0,7,192,2,229,85,91,192,2,255,255,255,192,0,0,0,0,0,106,170,170,170,169,127,255,255,255,253,116,10,1,64,29,116,15,2,224,29,0,31,2,224,0,0,46,2,224,0,0,60,2,224,4,0,252,2,224,14,11,240,2,224,30,255,128,1,255,253,120,0,0,191,248,
  // 0x4ece  从
  206,78,20,20,100,22,1,254,0,20,0,20,0,0,184,0,120,0,0,184,0,184,0,0,184,0,184,0,0,184,0,184,0,0,244,0,248,0,0,244,0,252,0,0,240,0,252,0,0,244,0,252,0,1,252,1,253,0,2,255,2,255,0,2,239,131,223,0,3,215,215,207,64,7,194,235,135,192,11,128,223,67,208,15,64,63,2,240,63,0,189,0,252,125,2,248,0,127,252,3,224,0,46,32,0,128,0,8,
  // 0x4ee4  令
  228,78,20,22,110,22,1,253,0,0,104,0,0,0,0,254,0,0,0,2,255,128,0,0,11,199,224,0,0,47,65,248,0,0,189,0,126,0,3,244,0,31,192,31,239,255,251,248,191,47,255,248,255,184,0,0,0,47,16,0,0,0,4,0,0,0,0,0,15,255,255,255,208,15,255,255,255,208,0,2,224,2,208,0,2,224,2,208,0,2,224,2,208,0,2,224,2,208,0,2,224,191,208,0,2,224,127,128,0,2,224,0,0,0,1,144,0,0,
  // 0x4ee5  以
  229,78,20,20,100,22,1,253,11,128,0,1,240,11,128,64,1,240,11,131,224,2,224,11,129,244,2,224,11,128,188,3,208,7,128,62,3,192,7,128,31,7,192,7,128,8,11,128,7,128,0,15,64,7,192,0,31,0,7,192,0,62,0,7,194,192,125,0,3,255,192,255,0,11,254,3,255,192,255,208,15,195,240,253,0,127,64,252,64,6,253,0,126,0,31,224,0,31,0,11,64,0,8,0,0,0,0,0,
  // 0x4ef6  件
  246,78,20,22,110,22,1,253,0,0,0,16,0,0,180,0,240,0,0,240,240,240,0,2,224,240,240,0,3,193,240,240,0,11,130,255,255,252,15,67,255,255,252,63,71,192,240,0,191,79,64,240,0,255,79,0,240,0,247,65,0,240,0,71,64,0,240,0,7,79,255,255,255,7,79,255,255,255,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,6,64,0,160,0,
  // 0x4efd  份
  253,78,21,21,126,22,0,253,0,61,3,255,192,0,0,60,3,255,208,0,0,184,24,1,240,0,0,240,60,0,240,0,2,224,124,0,184,0,3,208,180,0,124,0,15,209,240,0,62,0,47,211,208,0,15,128,127,219,192,0,11,192,58,223,191,255,250,64,18,208,127,255,248,0,2,208,3,192,120,0,2,208,3,192,120,0,2,208,7,192,184,0,2,208,11,64,180,0,2,208,15,0,180,0,2,208,46,0,244,0,2,208,188,0,240,0,2,211,240,47,240,0,2,210,192,31,208,0,0,0,0,0,0,0,
  // 0x4f11  休
  17,79,21,22,132,22,0,253,0,4,0,0,0,0,0,15,0,60,0,0,0,46,0,60,0,0,0,60,0,60,0,0,0,184,0,60,0,0,1,240,0,60,0,0,3,243,255,255,255,192,11,243,255,255,255,192,47,240,1,255,0,0,126,240,3,255,128,0,56,240,3,255,192,0,0,240,11,190,224,0,0,240,31,60,240,0,0,240,61,60,184,0,0,240,188,60,61,0,0,241,240,60,31,0,0,247,224,60,15,192,0,251,128,60,3,192,0,242,0,60,0,0,0,240,0,60,0,0,0,240,0,60,0,0,0,80,0,36,0,0,
  // 0x4f20  传
  32,79,21,21,126,22,0,253,0,61,0,244,0,0,0,124,0,240,0,0,0,185,255,255,255,0,0,240,255,255,255,0,2,224,3,192,0,0,7,208,3,192,0,0,15,215,255,255,255,192,63,219,255,255,255,192,126,208,15,0,0,0,54,208,15,0,0,0,18,208,30,0,0,0,2,208,47,255,254,0,2,208,63,255,253,0,2,208,0,0,248,0,2,208,0,3,224,0,2,208,7,143,128,0,2,208,7,255,0,0,2,208,0,190,0,0,2,208,0,31,128,0,2,208,0,7,192,0,1,128,0,0,0,0,
  // 0x4f4d  位
  77,79,21,21,126,22,0,254,0,4,0,0,0,0,0,30,0,60,0,0,0,61,0,60,0,0,0,124,0,60,0,0,0,244,0,60,0,0,1,242,255,255,255,128,3,226,255,255,255,128,15,224,0,0,0,0,63,224,24,0,104,0,125,224,44,0,124,0,52,224,45,0,184,0,0,224,30,0,244,0,0,224,15,0,240,0,0,224,15,1,240,0,0,224,11,65,224,0,0,224,11,66,208,0,0,224,11,67,192,0,0,224,0,7,192,0,0,224,0,11,64,0,0,227,255,255,255,192,0,227,255,255,255,192,
  // 0x4f4e  低
  78,79,22,21,126,22,0,253,0,61,0,0,40,0,0,124,1,111,254,0,0,244,255,255,144,0,1,240,250,95,0,0,3,224,240,15,0,0,7,208,240,15,0,0,15,208,240,15,0,0,63,208,255,255,255,192,126,208,255,255,255,192,50,208,240,11,64,0,2,208,240,7,128,0,2,208,240,3,192,0,2,208,240,3,192,0,2,208,240,3,192,0,2,208,251,250,208,0,2,215,255,245,224,208,2,211,228,0,240,208,2,208,0,0,121,192,2,210,255,255,127,192,2,210,255,255,69,0,0,64,0,0,0,0,
  // 0x4f53  体
  83,79,20,22,110,22,1,253,0,0,0,80,0,0,240,1,224,0,1,224,1,224,0,3,208,1,224,0,7,192,1,224,0,11,159,255,255,255,31,95,255,255,255,63,64,11,252,0,191,64,15,253,0,255,64,30,238,0,235,64,61,235,0,75,64,121,231,128,11,64,241,227,192,11,66,225,225,240,11,67,193,224,248,11,79,65,224,61,11,127,191,255,239,11,108,191,255,206,11,64,1,224,0,11,64,1,224,0,11,64,1,224,0,6,0,0,80,0,
  // 0x4f59  余
  89,79,20,22,110,22,1,253,0,0,40,0,0,0,0,255,0,0,0,2,255,128,0,0,11,195,240,0,0,47,0,253,0,0,252,0,63,128,7,224,0,11,244,63,255,255,254,255,253,255,255,254,46,96,0,60,0,4,0,0,60,0,0,0,0,60,0,0,47,255,255,255,252,47,255,255,255,252,0,0,60,0,0,0,144,60,9,0,1,240,60,47,64,7,208,60,11,208,31,64,60,2,244,190,0,60,0,189,116,15,252,0,44,0,15,224,0,0,
  // 0x4f5c  作
  92,79,20,22,110,22,1,253,0,16,0,0,0,0,124,15,0,0,0,244,31,0,0,1,240,62,0,0,3,208,63,255,255,7,192,191,255,255,15,193,241,224,0,47,195,209,224,0,191,203,193,224,0,255,207,65,255,254,167,193,1,255,254,7,192,1,224,0,7,192,1,224,0,7,192,1,224,0,7,192,1,255,255,7,192,1,255,255,7,192,1,224,0,7,192,1,224,0,7,192,1,224,0,7,192,1,224,0,7,192,1,224,0,1,64,0,144,0,
  // 0x4f7f  使
  127,79,21,22,132,22,0,253,0,4,0,20,0,0,0,30,0,60,0,0,0,60,0,60,0,0,0,127,255,255,255,192,0,246,255,255,255,192,2,240,0,60,0,0,3,224,0,60,0,0,15,224,255,255,255,64,47,224,250,190,175,64,125,224,224,60,7,64,52,224,224,60,7,64,0,224,250,190,175,64,0,224,255,255,255,64,0,224,80,60,0,0,0,224,240,120,0,0,0,224,124,244,0,0,0,224,31,240,0,0,0,224,11,244,0,0,0,224,47,255,64,0,0,226,254,31,255,128,0,227,244,1,191,128,0,145,0,0,1,0,
  // 0x4f9b  供
  155,79,20,22,110,22,1,253,0,16,20,1,64,0,180,60,3,192,0,240,60,3,192,2,224,60,3,192,3,192,60,3,192,11,139,255,255,255,31,75,255,255,255,63,64,60,3,192,255,64,60,3,192,251,64,60,3,192,139,64,60,3,192,11,64,60,3,192,11,79,255,255,255,11,79,255,255,255,11,64,0,0,0,11,64,40,1,64,11,64,124,7,192,11,64,244,2,240,11,67,240,0,184,11,79,192,0,61,11,75,0,0,30,5,0,0,0,0,
  // 0x4fb5  侵
  181,79,21,21,126,22,0,253,0,61,106,170,169,0,0,124,191,255,253,0,0,184,0,0,45,0,0,240,21,85,125,0,2,224,63,255,253,0,7,208,0,0,45,0,15,208,170,170,189,0,47,208,255,255,253,0,127,208,0,0,0,0,58,210,170,170,170,64,18,211,255,255,255,192,2,211,128,0,3,192,2,211,234,170,171,192,2,208,127,255,252,0,2,208,14,0,244,0,2,208,15,131,224,0,2,208,3,255,128,0,2,208,1,255,64,0,2,209,191,255,254,64,2,211,254,0,191,192,1,129,64,0,1,0,
  // 0x4fdd  保
  221,79,20,22,110,22,1,253,0,16,0,0,0,0,185,255,255,248,0,242,255,255,252,1,226,208,0,60,3,194,208,0,60,11,194,208,0,60,15,130,208,0,60,63,130,255,255,252,191,130,255,255,252,251,128,0,240,0,147,128,0,240,0,3,143,255,255,255,3,143,255,255,255,3,128,11,253,0,3,128,31,255,0,3,128,61,247,192,3,128,248,242,240,3,131,240,240,252,3,159,192,240,63,3,143,0,240,15,3,132,0,240,0,1,64,0,160,0,
  // 0x4fe1  信
  225,79,21,22,132,22,0,253,0,4,0,0,0,0,0,30,42,170,168,0,0,61,63,255,252,0,0,124,0,0,0,0,0,244,0,0,0,0,1,243,255,255,255,192,3,226,170,170,170,128,15,224,0,0,0,0,47,224,63,255,254,0,126,224,42,170,169,0,52,224,0,0,0,0,0,224,63,255,253,0,0,224,42,170,169,0,0,224,0,0,0,0,0,224,106,170,169,0,0,224,127,255,255,0,0,224,116,0,31,0,0,224,116,0,31,0,0,224,116,0,31,0,0,224,127,255,255,0,0,224,126,170,175,0,0,144,100,0,9,0,
  // 0x503c  值
  60,80,20,22,110,22,1,253,0,0,0,80,0,0,244,0,240,0,0,240,0,240,0,2,235,255,255,253,3,203,255,255,253,11,128,2,208,0,15,65,171,234,160,63,66,255,255,240,191,66,192,0,176,255,66,229,85,240,155,66,255,255,240,11,66,192,0,176,11,66,192,0,176,11,66,255,255,240,11,66,229,85,240,11,66,192,0,176,11,66,255,255,240,11,66,229,85,240,11,66,192,0,176,11,91,250,170,254,11,111,255,255,255,6,0,0,0,0,
  // 0x503e  倾
  62,80,21,21,126,22,0,253,0,240,0,0,0,0,0,240,3,255,255,192,1,227,66,175,250,128,3,211,64,3,192,0,3,195,64,7,64,0,11,195,64,255,255,0,15,195,232,255,255,0,63,195,252,224,15,0,127,195,64,227,143,0,55,195,64,227,143,0,19,195,64,227,143,0,3,195,64,227,143,0,3,195,64,227,143,0,3,195,172,227,143,0,3,199,252,227,79,0,3,203,208,155,5,0,3,198,0,15,112,0,3,192,0,61,189,0,3,192,1,248,31,64,3,192,7,208,3,192,2,128,1,0,0,0,
  // 0x504f  偏
  79,80,21,21,126,22,0,253,0,120,0,0,0,0,0,183,255,255,255,192,0,242,170,170,170,128,2,224,0,0,0,0,3,208,255,255,255,0,7,192,250,170,175,0,15,192,240,0,15,0,63,192,250,170,175,0,127,192,255,255,255,0,55,192,224,0,0,0,19,192,250,170,170,64,3,193,255,255,255,128,3,193,252,177,195,128,3,194,252,177,195,128,3,195,254,250,235,128,3,195,255,255,255,128,3,203,188,177,195,128,3,223,60,177,195,128,3,222,60,177,195,128,3,196,60,177,239,128,2,128,40,96,138,0,
  // 0x505c  停
  92,80,21,22,132,22,0,253,0,0,0,40,0,0,0,61,0,60,0,0,0,126,170,254,170,128,0,187,255,255,255,192,0,240,0,0,0,0,2,224,21,85,84,0,7,208,127,255,253,0,15,208,120,0,45,0,63,208,121,85,125,0,126,208,127,255,253,0,54,208,0,0,0,0,2,210,170,170,170,128,2,215,255,255,255,192,2,215,64,0,2,192,2,215,90,170,166,192,2,208,47,255,248,0,2,208,0,60,0,0,2,208,0,60,0,0,2,208,0,60,0,0,2,208,0,60,0,0,2,208,15,252,0,0,1,208,11,224,0,0,
  // 0x50a8  储
  168,80,21,22,132,22,0,253,0,80,0,8,0,0,0,240,0,29,3,64,0,231,64,29,11,128,2,211,195,255,255,0,3,193,242,191,190,0,3,192,144,29,60,0,11,128,0,29,180,0,15,128,11,255,255,192,63,175,203,255,255,192,127,175,192,31,64,0,51,129,192,125,0,0,3,129,194,254,170,0,3,129,223,255,255,0,3,129,203,240,11,0,3,129,192,176,11,0,3,129,192,191,255,0,3,129,196,186,175,0,3,130,253,176,11,0,3,131,252,176,11,0,3,131,208,191,255,0,3,130,0,186,175,0,2,64,0,96,6,0,
  // 0x50cf  像
  207,80,21,22,132,22,0,253,0,0,4,0,0,0,0,120,31,0,0,0,0,244,63,255,128,0,0,240,186,175,128,0,2,226,240,31,0,0,3,223,255,255,255,64,11,203,229,189,95,64,15,194,208,56,11,64,63,194,229,189,95,64,127,194,255,255,255,64,55,192,11,219,0,0,19,192,191,199,135,64,3,203,225,243,223,64,3,194,7,246,253,0,3,192,47,125,240,0,3,199,244,60,240,0,3,195,129,253,188,0,3,192,11,237,62,0,3,192,190,29,31,128,3,203,244,60,7,192,3,199,79,248,1,0,2,128,6,144,0,0,
  // 0x5145  充
  69,81,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,127,255,255,255,253,127,255,255,255,253,0,15,128,16,0,0,31,0,188,0,0,46,0,63,0,0,60,0,15,192,47,255,255,255,240,63,255,255,255,248,0,0,0,0,124,0,15,0,240,16,0,15,0,240,0,0,31,0,240,0,0,46,0,240,0,0,60,0,240,15,0,248,0,240,15,11,240,0,240,15,191,192,0,255,254,121,0,0,127,252,0,0,0,0,0,
  // 0x5148  先
  72,81,20,22,110,22,1,253,0,0,20,0,0,0,240,60,0,0,1,240,60,0,0,2,224,60,0,0,3,255,255,255,240,7,255,255,255,240,11,64,60,0,0,31,0,60,0,0,29,0,60,0,0,0,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,15,1,240,0,0,30,1,240,0,0,46,1,240,0,0,61,1,240,0,0,124,1,240,13,1,244,1,240,15,7,224,1,240,30,127,192,0,255,253,125,0,0,191,248,16,0,0,0,0,
  // 0x5149  光
  73,81,20,22,110,22,1,253,0,0,40,0,0,1,0,60,0,128,15,64,60,1,240,7,192,60,2,224,3,208,60,3,192,1,240,60,11,128,0,240,60,15,0,0,144,60,9,0,0,0,60,0,0,191,255,255,255,254,191,255,255,255,255,0,15,1,224,0,0,31,1,224,0,0,30,1,224,0,0,61,1,224,0,0,60,1,224,0,0,248,1,224,15,2,240,1,224,15,31,208,1,240,15,255,64,0,255,254,116,0,0,191,248,0,0,0,0,0,
  // 0x5165  入
  101,81,20,20,100,22,1,253,0,255,253,0,0,0,255,253,0,0,0,0,45,0,0,0,0,46,0,0,0,0,110,0,0,0,0,255,0,0,0,0,255,0,0,0,1,255,64,0,0,2,235,128,0,0,3,211,192,0,0,11,195,224,0,0,15,129,240,0,0,47,0,252,0,0,125,0,125,0,0,252,0,47,64,3,240,0,15,208,31,192,0,3,248,191,64,0,0,255,124,0,0,0,45,16,0,0,0,0,
  // 0x5168  全
  104,81,20,21,105,22,1,254,0,0,104,0,0,0,0,254,0,0,0,2,255,128,0,0,11,199,208,0,0,31,66,244,0,0,190,0,190,0,2,248,0,47,128,15,208,0,7,244,127,64,0,1,254,250,255,255,255,174,17,255,255,255,68,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,7,255,255,255,208,7,255,255,255,208,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,63,255,255,255,253,63,255,255,255,253,
  // 0x5171  共
  113,81,20,22,110,22,1,253,0,20,0,20,0,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,63,255,255,255,252,63,255,255,255,252,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,0,24,0,96,0,0,62,0,253,0,0,252,0,47,128,7,240,0,11,224,63,128,0,1,252,61,0,0,0,124,0,0,0,0,16,
  // 0x5173  关
  115,81,16,21,84,22,3,253,7,64,2,224,7,192,3,208,2,224,11,192,0,240,15,0,0,144,5,0,31,255,255,244,31,255,255,244,0,3,192,0,0,3,192,0,0,3,192,0,63,255,255,253,63,255,255,253,0,11,224,0,0,15,240,0,0,31,184,0,0,62,61,0,0,252,31,64,7,240,11,224,111,192,2,253,126,0,0,124,16,0,0,4,
  // 0x5177  具
  119,81,20,21,105,22,1,253,1,170,170,170,64,2,255,255,255,128,2,208,0,7,128,2,208,0,7,128,2,255,255,255,128,2,229,85,91,128,2,208,0,7,128,2,255,255,255,128,2,229,85,91,128,2,208,0,7,128,2,250,170,171,128,2,255,255,255,128,0,0,0,0,0,0,0,0,0,0,191,255,255,255,254,191,255,255,255,254,0,8,0,16,0,0,191,0,254,64,31,248,0,47,244,127,128,0,1,253,16,0,0,0,16,
  // 0x5197  冗
  151,81,20,20,100,22,1,253,63,255,255,255,253,63,255,255,255,253,60,0,0,0,61,60,0,0,0,61,60,0,0,0,61,60,0,0,0,61,0,63,255,252,0,0,63,255,252,0,0,61,0,124,0,0,61,0,124,0,0,61,0,124,0,0,60,0,124,0,0,60,0,124,0,0,124,0,124,4,0,244,0,124,15,3,240,0,124,15,31,208,0,124,15,191,64,0,63,254,120,0,0,47,252,0,0,0,0,0,
  // 0x51b7  冷
  183,81,20,22,110,22,1,253,0,0,1,64,0,0,0,11,240,0,120,0,15,248,0,127,0,62,61,0,31,192,252,31,64,3,131,240,7,224,0,15,192,1,248,0,127,191,255,127,0,184,191,255,14,0,32,0,0,0,0,0,0,0,0,0,11,255,255,244,2,203,255,255,248,3,208,15,0,184,15,128,15,0,184,31,0,15,0,184,61,0,15,0,184,252,0,15,15,244,176,0,15,15,224,0,0,15,0,0,0,0,15,0,0,0,0,5,0,0,
  // 0x51c6  准
  198,81,20,22,110,22,1,253,0,0,16,0,0,0,0,60,11,128,56,0,124,15,64,127,0,244,15,0,31,193,240,30,0,3,211,255,255,254,0,71,255,255,254,0,15,224,60,0,0,63,224,60,0,0,61,255,255,252,0,1,255,255,252,0,1,224,60,0,1,129,224,60,0,3,209,224,60,0,11,193,255,255,252,15,65,255,255,252,46,1,224,60,0,124,1,224,60,0,248,1,224,60,0,112,1,255,255,255,0,1,255,255,255,0,1,144,0,0,
  // 0x51fa  出
  250,81,18,22,110,22,2,253,0,0,80,0,0,0,0,240,0,0,0,0,240,1,0,45,0,240,7,192,45,0,240,7,192,45,0,240,7,192,45,0,240,7,192,45,0,240,7,192,45,0,240,7,192,47,255,255,255,192,47,255,255,255,192,0,0,240,0,0,100,0,240,1,144,184,0,240,1,224,184,0,240,1,224,184,0,240,1,224,184,0,240,1,224,184,0,240,1,224,191,255,255,255,224,191,255,255,255,224,184,0,0,1,224,84,0,0,0,80,
  // 0x51fb  击
  251,81,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,15,255,255,255,240,15,255,255,255,240,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,0,60,0,0,5,0,60,0,80,15,64,60,1,240,15,64,60,1,240,15,64,60,1,240,15,64,60,1,240,15,64,60,1,240,15,255,255,255,240,15,255,255,255,240,0,0,0,1,240,0,0,0,0,80,
  // 0x5206  分
  6,82,20,21,105,22,1,253,0,30,0,180,0,0,46,0,188,0,0,60,0,61,0,0,248,0,31,0,2,240,0,15,192,7,208,0,3,240,31,128,0,1,248,127,0,0,0,190,255,255,255,255,239,114,255,255,255,200,0,2,208,7,192,0,3,208,7,128,0,3,192,7,128,0,11,192,11,128,0,15,64,11,128,0,47,0,11,64,0,189,0,15,64,7,244,0,31,0,63,208,15,255,0,30,0,15,248,0,0,0,0,0,0,
  // 0x5207  切
  7,82,20,21,105,22,1,253,15,0,0,0,0,15,0,255,255,254,15,0,255,255,254,15,0,2,208,30,15,1,130,208,30,15,255,194,208,46,255,254,130,208,46,255,128,3,192,46,79,0,3,192,45,15,0,3,192,45,15,0,3,192,45,15,3,71,128,45,15,3,203,128,61,11,67,143,64,61,11,255,95,0,60,3,254,62,0,60,0,0,188,0,60,0,2,244,0,188,0,15,224,63,244,0,7,64,47,224,0,0,0,0,0,
  // 0x521b  创
  27,82,19,21,105,22,1,254,0,4,0,0,0,0,45,0,0,60,0,62,0,0,60,0,255,64,56,60,2,247,208,60,60,7,209,240,60,60,31,128,188,60,60,127,0,62,60,60,252,0,14,60,60,111,255,248,60,60,15,255,244,60,60,15,0,240,60,60,15,0,240,60,60,15,0,240,60,60,15,27,240,60,60,15,31,192,36,60,15,0,9,0,60,15,0,14,0,60,15,0,30,0,60,11,250,253,47,252,3,255,248,31,224,
  // 0x521d  初
  29,82,20,22,110,22,1,253,1,64,0,0,0,3,192,0,0,0,3,192,255,255,254,3,192,255,255,254,3,192,1,224,30,255,255,1,224,30,191,255,2,224,46,0,45,2,208,46,0,124,2,208,46,0,243,195,208,45,2,231,67,192,45,7,254,3,192,45,31,253,3,192,45,127,239,71,128,61,247,199,15,64,61,147,193,15,0,60,3,192,46,0,60,3,192,124,0,60,3,193,248,0,188,3,199,240,63,248,3,194,192,47,224,1,128,0,0,0,
  // 0x522b  别
  43,82,19,23,115,22,1,252,0,0,0,0,20,63,255,224,0,60,63,255,240,0,60,60,0,240,116,60,60,0,240,116,60,60,0,240,116,60,60,0,240,116,60,63,255,240,116,60,63,255,240,116,60,0,80,0,116,60,0,240,0,116,60,191,255,244,116,60,191,255,244,116,60,1,224,240,116,60,2,208,240,116,60,3,192,240,100,60,3,192,240,0,60,7,128,240,0,60,15,1,240,0,60,62,63,224,0,60,252,47,192,31,252,160,0,0,15,224,0,0,0,0,0,
  // 0x5230  到
  48,82,19,21,105,22,1,253,0,0,0,0,44,255,255,253,0,60,191,255,252,160,60,3,208,0,240,60,3,194,192,240,60,7,130,224,240,60,15,64,244,240,60,255,255,252,240,60,255,255,253,240,60,0,20,12,240,60,0,120,0,240,60,0,120,0,240,60,63,255,248,240,60,63,255,248,240,60,0,120,0,240,60,0,120,0,0,60,0,125,105,0,60,175,255,253,0,60,255,249,64,31,252,80,0,0,15,244,0,0,0,0,0,
  // 0x5236  制
  54,82,20,22,110,22,1,253,0,4,0,0,0,13,60,0,0,45,30,60,0,4,45,45,60,0,29,45,63,255,253,29,45,127,255,253,29,45,244,60,0,29,45,176,60,0,29,45,255,255,255,29,45,255,255,255,29,45,0,60,0,29,45,0,60,0,29,45,63,255,254,29,45,63,255,254,29,45,60,60,30,29,45,60,60,30,4,45,60,60,30,0,45,60,60,30,0,45,60,61,253,0,45,40,60,168,11,252,0,60,0,7,248,0,20,0,0,0,
  // 0x5237  刷
  55,82,20,21,105,22,1,253,0,0,0,0,45,47,255,254,0,45,47,255,254,60,45,44,0,30,60,45,44,0,30,60,45,47,255,254,60,45,47,255,254,60,45,44,11,0,60,45,44,11,0,60,45,62,175,233,60,45,63,255,254,60,45,62,203,14,60,45,62,203,14,60,45,62,203,14,60,45,58,203,14,40,45,118,203,14,0,45,182,203,190,0,45,242,139,100,0,45,224,11,0,15,252,0,11,0,7,244,0,0,0,0,0,
  // 0x5272  割
  114,82,20,22,110,22,1,253,0,20,0,0,0,0,60,0,0,45,106,190,169,0,45,255,255,254,60,45,240,20,14,60,45,240,60,14,60,45,47,255,244,60,45,21,189,80,60,45,0,60,0,60,45,47,255,240,60,45,5,125,80,60,45,0,60,0,60,45,255,255,253,60,45,106,170,169,60,45,26,170,164,60,45,47,255,244,60,45,45,0,116,0,45,45,0,116,0,45,45,0,116,0,45,47,255,244,15,252,46,170,244,11,244,24,0,16,0,0,
  // 0x529b  力
  155,82,19,22,110,22,1,253,0,0,160,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,63,255,255,255,252,63,255,255,255,252,0,1,240,0,124,0,2,224,0,124,0,2,224,0,120,0,3,208,0,120,0,7,192,0,184,0,11,128,0,180,0,15,64,0,180,0,47,0,0,244,0,62,0,0,240,0,252,0,0,240,3,240,0,1,240,15,208,0,3,224,127,64,3,255,208,60,0,2,255,64,0,0,0,0,0,
  // 0x529f  功
  159,82,20,21,105,22,1,253,0,0,0,240,0,0,0,0,240,0,255,255,0,240,0,255,255,0,240,0,3,192,0,240,0,3,192,191,255,254,3,192,191,255,254,3,192,1,224,30,3,192,1,224,45,3,192,2,208,45,3,192,2,208,45,3,192,3,192,45,3,219,135,192,45,27,255,139,128,60,255,248,15,64,60,249,0,47,0,60,0,0,125,0,60,0,1,248,0,188,0,15,224,63,244,0,7,128,63,224,0,0,0,0,0,
  // 0x52a0  加
  160,82,19,21,105,22,1,253,3,192,0,0,0,3,192,0,0,0,3,192,2,255,252,3,192,2,255,252,191,255,242,208,60,191,255,242,208,60,3,192,242,208,60,3,192,242,208,60,3,192,242,208,60,3,192,242,208,60,7,128,242,208,60,7,128,226,208,60,11,65,226,208,60,15,65,226,208,60,15,1,226,208,60,30,1,226,208,60,61,2,210,255,252,124,3,210,255,252,244,191,194,208,60,176,127,66,208,40,0,0,0,0,0,
  // 0x52a8  动
  168,82,20,21,105,22,1,253,0,0,0,60,0,63,255,208,60,0,63,255,208,60,0,0,0,0,60,0,0,0,0,60,0,0,0,15,255,254,0,0,15,255,254,255,255,240,60,30,191,255,224,120,30,3,192,0,120,30,7,129,0,120,30,11,67,128,180,30,15,3,192,240,45,14,1,208,240,45,45,91,241,224,45,63,255,243,208,61,127,144,171,192,60,32,0,15,128,124,0,0,63,47,248,0,0,12,31,224,0,0,0,0,0,
  // 0x5316  化
  22,83,20,21,105,22,1,253,0,45,30,0,0,0,60,30,0,0,0,184,30,0,0,1,240,30,0,0,3,224,30,0,52,11,208,30,1,252,31,208,30,11,240,127,208,30,127,128,255,208,31,248,0,243,208,31,208,0,131,208,30,0,0,3,208,30,0,0,3,208,30,0,0,3,208,30,0,0,3,208,30,0,9,3,208,30,0,15,3,208,30,0,15,3,208,31,0,15,3,208,15,255,254,3,208,7,255,248,1,64,0,0,0,
  // 0x5347  升
  71,83,20,21,105,22,1,253,0,0,180,61,0,0,11,252,61,0,6,255,208,61,0,127,253,0,61,0,126,124,0,61,0,0,60,0,61,0,0,60,0,61,0,0,60,0,61,0,0,60,0,61,0,255,255,255,255,255,255,255,255,255,255,0,60,0,61,0,0,124,0,61,0,0,184,0,61,0,0,244,0,61,0,1,240,0,61,0,3,224,0,61,0,15,192,0,61,0,127,0,0,61,0,188,0,0,61,0,16,0,0,24,0,
  // 0x534a  半
  74,83,20,22,110,22,1,253,0,0,40,0,0,6,64,60,1,208,11,192,60,3,224,3,208,60,7,192,2,240,60,15,128,0,240,60,31,0,0,160,60,29,0,0,0,60,0,0,31,255,255,255,248,31,255,255,255,248,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,20,0,0,
  // 0x534f  协
  79,83,20,22,110,22,1,253,5,0,1,0,0,11,64,3,192,0,11,64,3,192,0,11,64,3,192,0,11,64,3,192,0,11,67,255,255,208,255,251,255,255,208,255,248,3,130,208,11,64,7,130,208,11,67,199,130,252,11,67,203,66,237,11,71,79,3,222,11,79,15,3,207,11,95,30,3,207,11,93,45,3,203,11,64,60,3,198,11,64,248,3,192,11,66,240,3,192,11,71,208,7,128,11,95,131,255,64,11,78,2,254,0,1,0,0,0,0,
  // 0x5355  单
  85,83,20,22,110,22,1,253,0,16,0,4,0,0,184,0,15,64,0,61,0,47,0,0,31,0,124,0,10,175,170,254,160,15,255,255,255,240,15,0,60,0,240,15,0,60,0,240,15,170,190,170,240,15,255,255,255,240,15,0,60,0,240,15,0,60,0,240,15,255,255,255,240,10,170,190,170,160,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,191,255,255,255,254,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,40,0,0,
  // 0x5361  卡
  97,83,20,22,110,22,1,253,0,0,20,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,191,255,208,0,0,191,255,208,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,255,255,255,255,255,255,255,255,255,255,0,0,184,0,0,0,0,185,0,0,0,0,191,228,0,0,0,190,255,128,0,0,184,31,240,0,0,184,1,160,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,0,0,100,0,0,
  // 0x5370  印
  112,83,18,22,110,22,2,253,0,4,0,0,0,0,127,0,0,0,91,254,47,255,240,191,208,47,255,240,184,0,46,0,240,180,0,45,0,240,180,0,45,0,240,180,0,45,0,240,191,255,45,0,240,191,255,45,0,240,180,0,45,0,240,180,0,45,0,240,180,0,45,0,240,180,0,45,0,240,180,0,45,0,240,191,255,45,0,240,191,255,45,47,240,180,0,45,31,224,180,0,45,0,0,0,0,45,0,0,0,0,45,0,0,0,0,20,0,0,
  // 0x5371  危
  113,83,20,22,110,22,1,253,0,4,0,0,0,0,62,0,0,0,0,127,255,224,0,0,254,171,240,0,2,240,3,208,0,11,192,7,192,0,47,255,255,255,254,191,255,255,255,254,191,128,0,0,0,23,128,0,0,0,7,135,255,255,192,7,135,255,255,192,7,135,128,7,128,11,135,128,7,128,11,71,128,11,64,15,7,130,255,0,31,7,128,169,9,46,7,128,0,15,124,7,192,0,31,248,3,255,255,253,112,1,255,255,248,0,0,0,0,0,
  // 0x5374  却
  116,83,19,22,110,22,1,253,0,96,0,0,0,0,180,0,0,0,0,180,2,255,252,0,180,2,255,252,127,255,242,208,60,127,255,242,208,60,0,180,2,208,60,0,180,2,208,60,0,180,2,208,60,255,255,250,208,60,255,255,250,208,60,3,208,2,208,60,3,192,2,208,60,7,194,2,208,60,11,71,194,208,60,15,3,194,208,60,15,1,226,211,252,127,255,242,211,244,255,255,250,208,0,84,0,58,208,0,0,0,2,208,0,0,0,1,144,0,
  // 0x5378  卸
  120,83,20,22,110,22,1,253,1,0,0,0,0,7,128,0,0,0,15,0,1,255,253,15,255,245,255,253,63,255,245,208,45,124,56,1,208,45,180,56,1,208,45,16,56,1,208,45,255,255,253,208,45,191,255,249,208,45,0,56,1,208,45,44,56,1,208,45,44,63,241,208,45,44,62,161,208,45,44,56,1,208,45,44,56,1,208,61,44,56,21,211,252,45,191,253,210,244,255,255,229,208,0,255,148,1,208,0,64,0,1,208,0,0,0,1,144,0,
  // 0x538b  压
  139,83,20,20,100,22,1,253,31,255,255,255,255,31,255,255,255,255,29,0,0,0,0,29,0,7,128,0,29,0,7,128,0,29,0,7,128,0,29,0,7,128,0,29,63,255,255,252,45,63,255,255,252,45,0,7,128,0,45,0,7,129,0,44,0,7,143,64,44,0,7,131,208,60,0,7,129,240,60,0,7,128,176,56,0,7,128,0,184,0,7,128,0,242,255,255,255,255,242,255,255,255,255,16,0,0,0,0,
  // 0x539f  原
  159,83,20,20,100,22,1,253,15,255,255,255,254,15,255,255,255,254,15,0,11,128,0,15,26,175,170,160,15,31,255,255,240,15,30,0,0,240,15,30,0,0,240,15,31,255,255,240,31,31,85,86,240,30,30,0,0,240,30,31,170,170,240,30,31,255,255,240,45,0,7,128,0,45,7,135,131,64,60,15,71,135,208,60,46,7,129,244,120,188,7,128,125,246,240,7,128,31,240,128,255,128,4,16,0,186,0,0,
  // 0x53cc  双
  204,83,20,20,100,22,1,253,191,255,207,255,252,191,255,207,255,252,0,7,139,0,60,0,7,139,64,124,20,11,71,128,184,124,15,67,192,244,47,15,3,192,240,15,159,2,209,240,3,254,1,226,224,1,252,0,243,192,0,252,0,255,192,0,189,0,127,64,0,255,0,63,0,2,239,128,127,0,7,199,193,255,128,15,131,199,251,208,63,0,47,194,244,252,0,255,0,254,176,0,120,0,45,0,0,16,0,4,
  // 0x53cd  反
  205,83,20,20,100,22,1,253,7,255,255,255,252,7,255,255,255,252,7,128,0,0,0,7,128,0,0,0,7,128,0,0,0,7,128,0,0,0,7,255,255,255,224,7,255,255,255,208,7,143,64,3,192,7,135,192,11,192,11,131,208,15,64,11,65,240,63,0,15,64,248,188,0,15,0,63,244,0,31,0,31,224,0,46,0,127,244,0,61,7,253,255,64,188,191,224,47,249,180,190,0,2,252,0,16,0,0,20,
  // 0x53d6  取
  214,83,20,20,100,22,1,253,255,255,252,0,0,255,255,253,85,84,30,2,219,255,253,30,2,210,128,60,31,255,211,192,60,31,255,211,192,60,30,2,210,208,120,30,2,210,224,180,30,2,209,240,240,31,255,208,241,240,31,255,208,186,224,30,2,208,63,192,30,2,208,47,128,30,7,208,31,64,111,255,208,63,192,255,251,208,255,240,164,2,215,240,252,0,2,255,192,127,0,2,222,0,14,0,1,64,0,0,
  // 0x53d8  变
  216,83,20,22,110,22,1,253,0,0,20,0,0,0,0,124,0,0,0,0,61,0,0,127,255,255,255,253,127,255,255,255,253,0,11,66,224,0,3,203,66,235,64,7,139,66,227,208,15,11,66,224,244,61,11,66,224,124,8,11,66,224,20,0,5,0,64,0,15,255,255,255,128,15,255,255,255,128,0,248,0,47,0,0,62,0,188,0,0,15,215,240,0,0,2,255,128,0,0,27,255,228,0,91,255,150,255,229,127,228,0,27,254,36,0,0,0,24,
  // 0x53f0  台
  240,83,20,22,110,22,1,253,0,1,0,0,0,0,7,208,0,0,0,15,192,0,0,0,31,64,36,0,0,63,0,62,0,0,125,0,31,128,0,248,0,7,224,127,254,191,255,244,127,255,255,255,252,1,85,0,0,63,0,0,0,0,12,0,0,0,0,0,3,255,255,255,192,3,255,255,255,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,255,255,255,192,3,255,255,255,192,2,128,0,2,128,
  // 0x5403  吃
  3,84,20,22,110,22,1,253,0,0,1,0,0,0,0,15,64,0,0,0,15,0,0,127,248,47,0,0,127,248,63,255,254,120,56,191,255,254,120,56,240,0,0,120,63,224,0,0,120,57,128,0,0,120,56,47,255,244,120,56,47,255,240,120,56,0,31,128,120,56,0,126,0,120,56,2,244,0,127,248,11,192,0,127,248,47,0,0,120,0,124,0,10,36,0,244,0,11,0,0,244,0,15,0,0,255,255,254,0,0,47,255,248,0,0,0,0,0,
  // 0x5408  合
  8,84,20,22,110,22,1,253,0,0,20,0,0,0,0,254,0,0,0,2,255,128,0,0,7,215,208,0,0,31,66,248,0,0,126,0,190,0,2,248,0,47,192,15,224,0,7,248,191,191,255,254,191,248,127,255,253,30,0,0,0,0,0,0,0,0,0,0,2,255,255,255,128,2,255,255,255,192,2,208,0,3,192,2,208,0,3,192,2,208,0,3,192,2,208,0,3,192,2,208,0,3,192,2,255,255,255,192,2,255,255,255,192,1,128,0,2,128,
  // 0x540d  名
  13,84,19,22,110,22,1,253,0,1,64,0,0,0,7,192,0,0,0,15,128,0,0,0,63,255,253,0,0,191,255,253,0,2,240,0,188,0,15,240,0,244,0,127,252,3,224,0,188,127,11,192,0,16,15,239,0,0,0,3,253,0,0,0,2,244,0,0,0,31,255,255,248,0,191,255,255,248,27,255,0,0,184,255,223,0,0,184,185,15,0,0,184,0,15,0,0,184,0,15,0,0,184,0,15,255,255,248,0,15,255,255,248,0,10,0,0,100,
  // 0x540e  后
  14,84,20,22,110,22,1,253,0,0,0,0,64,0,0,1,111,224,10,107,255,255,224,15,255,255,148,0,15,148,0,0,0,15,64,0,0,0,15,64,0,0,0,15,255,255,255,255,15,255,255,255,255,15,64,0,0,0,15,0,0,0,0,15,0,0,0,0,15,15,255,255,244,15,15,255,255,244,15,15,0,0,244,30,15,0,0,244,45,15,0,0,244,60,15,0,0,244,188,15,255,255,244,244,15,255,255,244,112,15,0,0,244,0,5,0,0,16,
  // 0x5411  向
  17,84,18,22,110,22,2,253,0,1,80,0,0,0,3,224,0,0,0,7,192,0,0,0,11,128,0,0,255,255,255,255,240,255,255,255,255,240,240,0,0,0,240,240,0,0,0,240,240,0,0,0,240,240,63,255,192,240,240,127,255,208,240,240,120,2,208,240,240,120,2,208,240,240,120,2,208,240,240,120,2,208,240,240,127,255,208,240,240,127,255,192,240,240,120,0,0,240,240,0,0,0,240,240,0,0,255,240,240,0,0,191,192,0,0,0,0,0,
  // 0x5426  否
  38,84,20,20,100,22,1,253,127,255,255,255,253,127,255,255,255,253,0,0,63,0,0,0,0,252,0,0,0,7,252,116,0,0,127,188,191,64,7,253,60,15,240,127,224,60,1,254,190,0,60,0,46,32,0,60,0,0,0,0,20,0,0,3,255,255,255,208,3,255,255,255,208,3,192,0,3,208,3,192,0,3,208,3,192,0,3,208,3,192,0,3,208,3,255,255,255,208,3,255,255,255,208,2,128,0,2,128,
  // 0x542f  启
  47,84,19,22,110,22,1,253,0,0,0,1,0,0,0,6,191,192,10,191,255,254,64,15,255,165,0,0,15,0,0,0,0,15,170,170,170,160,15,255,255,255,240,15,0,0,0,240,15,0,0,0,240,15,0,0,0,240,15,255,255,255,240,15,234,170,170,160,15,0,0,0,0,15,42,170,170,164,31,63,255,255,244,30,60,0,0,180,45,60,0,0,180,60,60,0,0,180,124,60,0,0,180,248,63,255,255,244,176,62,170,170,244,0,40,0,0,100,
  // 0x544a  告
  74,84,20,22,110,22,1,253,0,0,5,0,0,0,240,46,0,0,1,240,46,0,0,3,224,46,0,0,7,255,255,255,240,15,255,255,255,240,47,0,46,0,0,61,0,46,0,0,4,0,46,0,0,191,255,255,255,254,191,255,255,255,254,0,0,0,0,0,0,0,0,0,0,3,255,255,255,192,3,255,255,255,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,255,255,255,192,3,255,255,255,192,3,192,0,3,192,1,128,0,1,64,
  // 0x5468  周
  104,84,19,20,100,22,1,253,15,255,255,255,244,15,255,255,255,244,15,0,40,0,180,15,0,60,0,180,15,47,255,252,180,15,26,190,168,180,15,0,60,0,180,15,42,190,168,180,15,63,255,253,180,15,0,0,0,180,15,10,170,160,180,15,15,255,244,180,15,15,0,180,180,30,15,0,180,180,45,15,0,180,180,60,15,255,244,180,124,15,170,160,180,184,15,0,0,180,240,5,0,63,244,96,0,0,47,144,
  // 0x547d  命
  125,84,21,22,132,22,1,253,0,0,104,0,0,0,0,0,255,0,0,0,0,3,255,192,0,0,0,15,195,240,0,0,0,127,0,253,0,0,2,248,0,47,192,0,31,239,255,251,248,0,255,31,255,244,255,64,248,0,0,0,31,0,0,0,0,0,0,0,15,255,199,255,244,0,15,255,199,255,244,0,15,3,199,128,180,0,15,3,199,128,180,0,15,3,199,128,180,0,15,3,199,128,180,0,15,255,199,128,180,0,15,255,199,143,240,0,15,0,7,143,224,0,14,0,7,128,0,0,0,0,7,128,0,0,0,0,6,64,0,0,
  // 0x548c  和
  140,84,19,21,105,22,1,253,0,7,192,0,0,6,255,208,0,0,191,249,7,255,252,37,244,7,255,252,0,180,7,128,60,0,180,7,128,60,255,255,247,128,60,255,255,247,128,60,1,244,7,128,60,3,252,7,128,60,7,255,7,128,60,11,255,135,128,60,14,183,215,128,60,45,181,231,128,60,124,180,135,128,60,244,180,7,128,60,224,180,7,255,252,64,180,7,255,252,0,180,7,128,60,0,180,6,64,36,0,96,0,0,0,
  // 0x54cd  响
  205,84,20,22,110,22,1,253,0,0,0,80,0,0,0,0,248,0,0,0,0,240,0,127,244,1,240,0,127,244,171,250,169,116,117,255,255,254,116,117,224,0,30,116,117,224,0,30,116,117,225,85,30,116,117,227,255,30,116,117,227,135,30,116,117,227,135,30,116,117,227,135,30,116,117,227,135,30,127,245,227,219,30,127,245,227,255,30,116,1,227,128,30,116,1,225,64,30,0,1,224,0,30,0,1,224,0,30,0,1,224,2,253,0,0,144,1,228,
  // 0x55b7  喷
  183,85,20,22,110,22,1,253,0,0,0,80,0,0,0,0,240,0,0,1,170,250,168,127,242,255,255,252,127,240,0,240,0,112,240,60,97,208,112,246,190,171,250,112,247,255,255,255,112,240,60,1,208,112,240,20,0,64,112,240,255,255,244,112,240,250,170,244,112,240,240,0,116,112,240,240,96,116,127,240,240,240,116,127,224,240,240,116,112,0,240,240,116,112,0,225,240,116,0,0,7,207,144,0,1,191,1,253,0,15,228,0,47,0,1,0,0,1,
  // 0x5634  嘴
  52,86,20,22,110,22,1,253,0,0,4,9,0,0,0,28,29,0,127,227,92,29,124,127,243,95,223,224,112,243,94,94,0,112,243,92,29,5,112,243,110,158,11,112,255,255,223,255,112,255,174,1,84,112,240,63,254,0,112,240,249,125,0,112,243,245,125,84,112,255,255,255,252,127,245,224,176,60,127,224,255,255,252,112,0,240,180,60,112,1,224,176,60,0,2,255,255,252,0,3,213,85,124,0,11,128,0,60,0,47,0,11,248,0,4,0,2,80,
  // 0x5668  器
  104,86,20,21,105,22,1,253,10,170,130,170,164,31,255,195,255,244,29,3,195,192,180,29,3,195,192,180,29,3,195,192,180,31,255,195,255,244,10,170,246,170,164,0,0,244,0,0,191,255,255,255,254,255,255,255,255,255,0,63,0,248,0,2,252,0,63,64,31,224,0,15,244,255,255,195,255,255,191,171,195,234,254,15,3,195,128,240,15,3,195,128,240,15,3,195,128,240,15,255,195,255,240,15,171,195,234,240,9,1,65,64,80,
  // 0x5674  噴
  116,86,20,22,110,22,1,253,0,0,0,96,0,0,0,0,176,0,0,2,255,255,252,127,240,85,249,84,127,240,60,177,208,116,117,125,86,229,116,123,255,255,255,116,112,60,1,208,116,112,20,1,80,116,112,255,255,248,116,112,224,0,120,116,112,240,0,120,116,112,255,255,248,127,240,224,0,120,127,240,255,255,248,116,0,240,0,120,116,0,240,0,120,0,0,255,255,248,0,0,46,7,128,0,6,248,2,248,0,31,208,0,63,0,5,0,0,4,
  // 0x56de  回
  222,86,18,21,105,22,2,253,255,255,255,255,240,255,255,255,255,240,240,0,0,0,240,240,0,0,0,240,240,0,0,0,240,240,0,0,0,240,240,127,255,208,240,240,127,255,208,240,240,120,3,208,240,240,120,3,208,240,240,120,3,208,240,240,120,3,208,240,240,127,255,208,240,240,127,255,208,240,240,0,0,0,240,240,0,0,0,240,240,0,0,0,240,255,255,255,255,240,255,255,255,255,240,240,0,0,0,240,80,0,0,0,80,
  // 0x56e0  因
  224,86,18,21,105,22,2,253,255,255,255,255,240,255,255,255,255,240,240,0,0,0,240,240,0,240,0,240,240,0,240,0,240,240,0,240,0,240,240,0,224,0,240,243,255,255,252,240,243,255,255,252,240,240,2,244,0,240,240,3,248,0,240,240,3,252,0,240,240,15,159,0,240,240,47,15,128,240,240,189,3,224,240,243,244,1,252,240,242,128,0,36,240,240,0,0,0,240,255,255,255,255,240,255,255,255,255,240,160,0,0,0,160,
  // 0x56fa  固
  250,86,18,21,105,22,2,253,255,255,255,255,240,255,255,255,255,240,240,0,0,0,240,240,0,240,0,240,240,0,240,0,240,240,0,240,0,240,243,255,255,252,240,242,170,250,168,240,240,0,240,0,240,240,0,240,0,240,240,191,255,224,240,240,186,170,224,240,240,176,0,224,240,240,176,0,224,240,240,191,255,224,240,240,106,170,144,240,240,0,0,0,240,240,0,0,0,240,255,255,255,255,240,255,255,255,255,240,224,0,0,0,240,
  // 0x56fe  图
  254,86,18,21,105,22,2,253,255,255,255,255,240,255,255,255,255,240,240,2,0,0,240,240,15,64,0,240,240,47,170,160,240,240,191,255,244,240,242,252,3,208,240,247,223,95,128,240,241,3,253,0,240,240,27,255,64,240,246,255,75,254,240,251,230,64,125,240,241,11,249,0,240,240,0,111,0,240,240,121,64,0,240,240,191,254,64,240,240,0,111,224,240,240,0,0,64,240,255,255,255,255,240,255,255,255,255,240,160,0,0,0,160,
  // 0x5728  在
  40,87,20,22,110,22,1,253,0,1,0,0,0,0,3,208,0,0,0,3,192,0,0,0,11,192,0,0,191,255,255,255,254,191,255,255,255,254,0,61,0,0,0,0,124,0,240,0,0,244,0,240,0,2,224,0,240,0,11,192,0,240,0,47,194,255,255,248,191,194,255,255,248,247,192,0,240,0,83,192,0,240,0,3,192,0,240,0,3,192,0,240,0,3,192,0,240,0,3,192,0,240,0,3,199,255,255,254,3,203,255,255,254,1,64,0,0,0,
  // 0x574f  坏
  79,87,20,21,105,22,1,253,7,128,0,0,0,7,131,255,255,255,7,131,255,255,255,7,128,0,61,0,7,128,0,184,0,255,252,1,240,0,255,252,3,241,0,7,128,15,255,128,7,128,63,247,240,7,129,252,240,252,7,143,240,240,63,7,135,128,240,15,7,132,0,240,0,7,252,0,240,0,111,252,0,240,0,255,128,0,240,0,244,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,96,0,
  // 0x5757  块
  87,87,20,22,110,22,1,253,0,0,0,64,0,7,128,2,208,0,7,128,2,208,0,7,128,2,208,0,7,128,255,255,244,7,128,255,255,244,255,252,2,208,180,255,252,2,208,180,7,128,2,208,180,7,128,2,208,180,7,128,2,208,180,7,130,255,255,255,7,130,255,255,255,7,172,3,252,0,7,252,7,252,0,191,224,15,94,0,254,0,31,15,64,80,0,125,7,192,0,1,248,3,244,0,15,224,0,254,0,31,64,0,46,0,4,0,0,4,
  // 0x578b  型
  139,87,20,21,105,22,1,254,0,0,0,0,20,47,255,252,16,56,63,255,252,120,56,3,194,208,120,56,3,194,208,120,56,3,194,208,120,56,191,255,254,120,56,127,255,253,120,56,7,130,208,120,56,15,66,208,16,56,47,2,208,0,120,188,2,208,15,248,32,1,124,11,160,0,0,60,0,0,11,255,255,255,208,11,255,255,255,224,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,
  // 0x57ab  垫
  171,87,21,21,126,22,1,254,0,64,1,64,0,0,1,208,2,208,0,0,1,208,2,208,0,0,191,255,127,255,224,0,191,255,127,255,224,0,1,208,3,192,224,0,1,230,59,192,224,0,91,255,127,192,224,0,255,249,15,224,224,0,186,208,15,252,226,0,1,208,62,44,243,64,2,208,248,0,191,0,63,208,244,0,62,0,30,64,60,0,0,0,0,0,60,0,0,0,11,255,255,255,240,0,6,170,190,170,160,0,0,0,60,0,0,0,0,0,60,0,0,0,191,255,255,255,255,0,191,255,255,255,254,0,
  // 0x586b  填
  107,88,20,22,110,22,1,253,0,0,0,96,0,7,64,0,240,0,7,66,170,250,170,7,71,255,255,255,7,64,0,240,0,7,64,21,245,80,255,248,191,255,240,255,248,176,0,176,7,64,191,255,240,7,64,181,85,240,7,64,180,0,240,7,64,191,255,240,7,64,176,0,176,7,172,191,255,240,11,252,21,85,80,127,238,170,170,170,254,15,255,255,255,160,0,4,1,0,0,0,126,7,208,0,7,244,1,252,0,15,128,0,63,0,1,0,0,4,
  // 0x58f3  壳
  243,88,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,106,170,190,170,169,191,255,255,255,254,0,0,60,0,0,15,255,255,255,240,6,170,170,170,144,0,0,0,0,0,63,255,255,255,252,62,170,170,170,188,56,85,85,85,60,56,255,255,255,60,0,0,0,0,0,0,106,170,168,0,0,127,255,252,0,0,120,0,60,0,0,180,0,60,0,0,240,0,60,13,7,224,0,60,14,127,128,0,63,253,61,0,0,47,248,16,0,0,0,0,
  // 0x5907  备
  7,89,20,22,110,22,1,253,0,2,64,0,0,0,15,128,0,0,0,47,255,255,64,0,191,255,255,64,7,248,0,62,0,47,191,1,248,0,45,11,235,224,0,0,2,255,128,0,0,111,255,253,64,175,254,65,191,255,255,144,0,6,254,87,170,170,170,128,7,255,255,255,192,7,128,60,3,192,7,128,60,3,192,7,234,190,171,192,7,255,255,255,192,7,128,60,3,192,7,128,60,3,192,7,255,255,255,192,7,255,255,255,192,2,64,0,1,64,
  // 0x590d  复
  13,89,15,22,88,22,3,253,0,64,0,0,0,244,0,0,1,240,0,0,3,255,255,240,11,234,170,160,47,85,85,64,127,255,255,192,42,192,3,192,2,213,87,192,2,255,255,192,2,192,3,192,2,255,255,192,1,126,85,64,0,126,85,64,1,255,255,192,15,240,15,64,63,124,62,0,24,31,248,0,0,31,248,0,6,254,191,228,63,224,11,248,4,0,0,16,
  // 0x5916  外
  22,89,21,22,132,22,1,253,0,16,0,5,0,0,0,184,0,31,0,0,0,244,0,31,0,0,0,240,0,31,0,0,2,255,252,31,0,0,3,255,252,31,0,0,7,192,63,31,0,0,15,64,127,223,0,0,47,0,183,255,0,0,127,128,240,255,0,0,255,241,224,127,0,0,96,255,208,47,64,0,0,47,192,31,208,0,0,15,128,31,248,0,0,31,0,31,191,64,0,61,0,31,30,0,0,188,0,31,0,0,2,240,0,31,0,0,15,208,0,31,0,0,127,64,0,31,0,0,60,0,0,31,0,0,0,0,0,5,0,0,
  // 0x591a  多
  26,89,19,22,110,22,2,253,0,1,64,0,0,0,7,224,0,0,0,31,234,168,0,0,191,255,252,0,11,240,0,248,0,191,248,3,224,0,180,127,79,128,0,0,11,254,0,0,0,7,247,128,0,0,191,159,192,0,111,248,127,234,224,254,66,255,255,244,80,47,208,2,224,6,255,192,7,192,11,231,244,31,64,1,0,190,126,0,0,0,31,248,0,0,0,111,208,0,0,27,254,0,0,27,255,208,0,0,31,249,0,0,0,4,0,0,0,0,
  // 0x5927  大
  39,89,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,124,0,0,0,0,124,0,0,191,255,255,255,254,191,255,255,255,254,0,0,255,0,0,0,0,255,0,0,0,2,251,128,0,0,3,215,192,0,0,7,195,224,0,0,15,129,244,0,0,47,0,252,0,0,189,0,63,0,2,248,0,31,192,11,224,0,7,244,191,128,0,1,254,125,0,0,0,60,16,0,0,0,4,
  // 0x5929  天
  41,89,20,20,100,22,1,253,191,255,255,255,254,191,255,255,255,254,0,0,124,0,0,0,0,124,0,0,0,0,124,0,0,0,0,124,0,0,0,0,124,0,0,63,255,255,255,252,63,255,255,255,252,0,0,190,0,0,0,0,255,0,0,0,1,255,128,0,0,3,231,192,0,0,11,195,240,0,0,47,64,248,0,0,190,0,127,0,7,248,0,47,224,191,208,0,7,255,190,0,0,0,189,16,0,0,0,4,
  // 0x592a  太
  42,89,20,22,110,22,1,253,0,0,40,0,0,0,0,124,0,0,0,0,124,0,0,0,0,124,0,0,0,0,120,0,0,0,0,184,0,0,191,255,255,255,254,191,255,255,255,254,0,0,255,0,0,0,0,255,64,0,0,1,251,128,0,0,3,211,192,0,0,3,195,224,0,0,11,193,240,0,0,15,64,248,0,0,63,160,125,0,0,254,248,47,64,3,244,190,15,208,31,208,47,67,248,191,64,11,192,255,124,0,3,0,45,16,0,0,0,4,
  // 0x5931  失
  49,89,20,22,110,22,1,253,0,0,40,0,0,1,240,60,0,0,2,224,60,0,0,3,208,60,0,0,7,255,255,255,240,15,255,255,255,240,31,0,60,0,0,62,0,60,0,0,188,0,60,0,0,20,0,124,0,0,0,0,124,0,0,255,255,255,255,255,255,255,255,255,255,0,0,255,0,0,0,2,251,128,0,0,7,211,208,0,0,31,130,244,0,0,191,0,189,0,7,252,0,47,208,127,208,0,7,254,190,0,0,0,190,16,0,0,0,4,
  // 0x5934  头
  52,89,20,22,110,22,1,253,0,0,1,0,0,0,64,11,128,0,2,248,11,128,0,0,191,139,128,0,0,11,203,128,0,0,1,75,128,0,30,64,11,64,0,31,240,11,64,0,1,252,15,64,0,0,40,15,0,0,0,0,15,0,0,191,255,255,255,255,191,255,255,255,254,0,0,61,0,0,0,0,124,0,0,0,0,246,208,0,0,3,226,253,0,0,31,192,63,128,1,254,0,7,244,111,244,0,0,189,63,64,0,0,28,16,0,0,0,0,
  // 0x597d  好
  125,89,20,22,110,22,1,253,1,0,0,0,0,3,192,0,0,0,3,192,63,255,252,7,128,63,255,252,11,64,0,0,244,255,255,0,3,208,255,255,0,31,128,14,15,0,62,0,30,15,0,60,0,45,15,0,60,0,60,15,255,255,255,60,30,255,255,255,56,45,0,60,0,126,60,0,60,0,191,248,0,60,0,2,248,0,60,0,2,255,0,60,0,7,223,128,60,0,47,66,0,60,0,189,0,15,252,0,52,0,11,244,0,0,0,0,0,0,
  // 0x59cb  始
  203,89,21,22,132,22,1,253,1,64,0,80,0,0,3,192,0,244,0,0,3,128,0,240,0,0,7,128,1,224,0,0,11,64,2,208,144,0,255,255,3,192,240,0,255,255,7,128,184,0,14,15,15,69,125,0,29,15,191,255,255,0,44,15,191,170,95,64,60,30,0,0,5,0,56,45,0,0,0,0,120,60,15,255,252,0,191,124,15,255,252,0,187,248,14,0,60,0,2,248,14,0,60,0,1,254,14,0,60,0,3,239,78,0,60,0,15,135,78,0,60,0,63,1,15,255,252,0,188,0,15,255,252,0,32,0,9,0,40,0,
  // 0x5b50  子
  80,91,20,21,105,22,1,252,11,255,255,255,208,11,255,255,255,224,0,0,0,47,128,0,0,0,254,0,0,0,7,244,0,0,0,63,192,0,0,0,62,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,63,252,0,0,0,63,224,0,0,0,0,0,0,0,
  // 0x5b58  存
  88,91,20,22,110,22,1,253,0,1,64,0,0,0,3,192,0,0,0,7,192,0,0,191,255,255,255,254,191,255,255,255,254,0,46,0,0,0,0,61,0,0,0,0,188,0,0,0,0,244,191,255,244,3,240,191,255,240,11,192,0,11,192,47,192,0,126,0,255,192,0,184,0,243,199,255,255,255,3,199,255,255,255,3,192,0,180,0,3,192,0,180,0,3,192,0,180,0,3,192,0,180,0,3,192,0,180,0,3,192,63,244,0,3,192,47,224,0,
  // 0x5b89  安
  137,91,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,60,0,0,0,60,60,1,240,0,60,60,3,224,0,60,0,7,192,0,0,191,255,255,255,254,191,255,255,255,254,0,61,0,46,0,0,124,0,61,0,0,244,0,124,0,1,248,0,244,0,3,255,227,224,0,2,135,255,192,0,0,0,191,244,0,0,27,249,255,64,43,255,208,31,244,47,248,0,2,240,5,0,0,0,0,
  // 0x5b8c  完
  140,91,20,21,105,22,1,253,0,0,60,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,60,0,0,0,60,60,0,0,0,60,56,255,255,255,60,0,191,255,254,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,254,191,255,255,255,254,0,31,2,208,0,0,46,2,208,0,0,61,2,208,0,0,124,2,208,8,0,248,2,208,15,7,240,2,224,15,191,192,1,255,254,189,0,0,191,248,16,0,0,0,0,
  // 0x5b9a  定
  154,91,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,60,0,0,0,60,60,0,0,0,60,60,255,255,255,60,0,255,255,255,0,0,0,60,0,0,0,0,60,0,0,1,224,60,0,0,2,224,60,0,0,2,224,63,255,208,3,208,63,255,208,3,240,60,0,0,11,248,60,0,0,15,126,60,0,0,62,15,252,0,0,188,2,255,255,255,180,0,43,255,253,16,0,0,0,0,
  // 0x5ba2  客
  162,91,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,63,255,255,255,252,127,255,255,255,252,120,2,64,0,60,120,7,192,0,60,120,31,234,168,60,0,127,255,254,0,2,253,0,188,0,47,223,130,240,0,13,3,255,192,0,0,1,255,128,0,0,47,235,254,64,27,254,0,127,254,255,254,170,175,253,100,255,255,255,0,0,240,0,15,0,0,240,0,15,0,0,240,0,15,0,0,255,255,255,0,0,250,170,175,0,0,80,0,5,0,
  // 0x5bab  宫
  171,91,18,22,110,22,2,253,0,0,64,0,0,0,2,224,0,0,0,0,240,0,0,255,255,255,255,240,255,255,255,255,240,240,0,0,0,240,240,0,0,0,240,243,255,255,253,240,3,234,170,189,0,3,128,0,45,0,3,128,0,45,0,3,255,255,253,0,2,170,170,168,0,0,0,0,0,0,31,255,255,255,128,47,255,255,255,128,45,0,0,7,128,45,0,0,7,128,45,0,0,7,128,47,255,255,255,128,47,255,255,255,128,24,0,0,2,64,
  // 0x5bf9  对
  249,91,20,22,110,22,1,253,0,0,0,1,144,0,0,0,1,224,0,0,0,1,224,127,255,192,1,224,127,255,192,1,224,0,3,192,1,224,0,7,223,255,255,0,7,159,255,255,44,11,64,1,224,47,15,0,1,224,15,223,15,1,224,3,254,11,129,224,0,253,3,193,224,0,127,2,209,224,0,255,128,225,224,1,247,192,65,224,3,210,240,1,224,15,128,208,1,224,63,0,0,2,224,252,0,0,191,208,48,0,0,127,128,0,0,0,0,0,
  // 0x5c06  将
  6,92,20,22,110,22,1,253,0,144,0,0,80,0,240,1,111,244,0,246,255,255,144,80,243,250,80,0,240,240,1,208,45,124,242,193,224,60,61,241,224,240,244,47,240,240,242,240,9,240,176,71,192,0,240,0,7,192,0,240,0,3,192,0,247,255,255,255,1,247,255,255,255,15,240,0,3,192,191,240,184,3,192,249,240,61,3,192,144,240,31,3,192,0,240,11,67,192,0,240,0,3,192,0,240,0,255,192,0,240,0,191,64,0,0,0,0,0,
  // 0x5c0f  小
  15,92,21,21,126,22,1,253,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,0,0,60,0,0,0,3,208,60,7,128,0,3,208,60,7,192,0,7,192,60,3,224,0,11,128,60,1,240,0,15,64,60,0,248,0,31,0,60,0,124,0,46,0,60,0,61,0,61,0,60,0,47,0,252,0,60,0,31,0,176,0,60,0,15,64,0,0,60,0,4,0,0,0,60,0,0,0,0,0,60,0,0,0,0,63,252,0,0,0,0,47,244,0,0,0,0,0,0,0,0,0,
  // 0x5c31  就
  49,92,21,22,132,22,1,253,0,80,0,24,0,0,0,180,0,45,176,0,0,180,0,45,184,0,191,255,248,45,61,0,255,255,248,45,30,0,0,0,0,45,4,0,0,0,7,255,255,0,47,255,235,255,255,0,47,171,224,60,0,0,44,1,224,63,128,0,44,1,224,63,128,0,46,171,224,63,128,0,47,255,224,127,128,0,0,116,0,191,128,0,24,117,192,251,128,0,60,117,225,247,128,0,60,116,243,215,131,0,184,116,187,199,135,64,240,116,31,71,135,0,80,180,63,3,255,0,11,244,60,2,253,0,3,224,4,0,0,0,
  // 0x5c4f  屏
  79,92,20,21,105,22,1,253,10,170,170,170,164,15,255,255,255,248,15,0,0,0,184,15,0,0,0,184,15,234,170,170,248,15,255,255,255,248,15,3,192,7,128,15,3,208,15,64,15,1,224,15,0,15,127,255,255,252,15,42,250,191,168,15,0,240,30,0,15,0,240,30,0,30,171,250,191,170,46,255,255,255,255,61,2,224,30,0,60,3,192,30,0,124,15,128,30,0,244,127,0,30,0,240,124,0,30,0,0,16,0,9,0,
  // 0x5de5  工
  229,93,20,17,85,22,1,255,47,255,255,255,248,47,255,255,255,248,0,0,124,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,
  // 0x5dee  差
  238,93,20,22,110,22,1,253,0,16,0,4,0,0,184,0,46,0,0,61,0,60,0,47,255,255,255,248,47,255,255,255,252,0,0,60,0,0,0,0,60,0,0,11,255,255,255,224,6,170,190,170,160,0,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,184,0,0,0,0,244,0,0,0,0,247,255,255,240,2,231,255,255,224,3,192,7,192,0,11,192,7,192,0,31,0,7,192,0,190,127,255,255,252,184,127,255,255,253,16,0,0,0,0,
  // 0x5df2  已
  242,93,19,19,95,22,2,254,255,255,255,255,0,255,255,255,255,0,0,0,0,15,0,0,0,0,15,0,60,0,0,15,0,60,0,0,15,0,60,0,0,15,0,63,255,255,255,0,63,255,255,255,0,61,0,0,15,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,16,60,0,0,0,60,60,0,0,0,124,61,0,0,0,184,46,0,0,1,244,31,255,255,255,240,6,255,255,255,128,
  // 0x5e73  平
  115,94,20,20,100,22,1,253,47,255,255,255,248,47,255,255,255,248,0,0,60,0,0,2,192,60,3,128,3,208,60,7,192,1,224,60,11,128,0,240,60,15,0,0,244,60,30,0,0,96,60,28,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,40,0,0,
  // 0x5e76  并
  118,94,20,22,110,22,1,253,0,16,0,5,0,0,244,0,15,64,0,124,0,46,0,0,61,0,124,0,0,29,0,116,0,63,255,255,255,252,63,255,255,255,252,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,0,60,0,60,0,255,255,255,255,255,255,255,255,255,255,0,60,0,60,0,0,120,0,60,0,0,244,0,60,0,2,240,0,60,0,7,208,0,60,0,47,128,0,60,0,125,0,0,60,0,16,0,0,36,0,
  // 0x5e8a  床
  138,94,20,22,110,22,1,253,0,0,25,0,0,0,0,30,0,0,0,0,30,0,0,31,255,255,255,255,31,255,255,255,255,30,0,1,64,0,30,0,3,192,0,30,0,3,192,0,30,0,3,192,0,30,127,255,255,254,30,127,255,255,255,30,0,31,240,0,30,0,63,248,0,45,0,191,253,0,45,1,247,207,64,60,3,211,199,208,60,15,131,194,244,60,127,3,192,190,184,252,3,192,47,240,32,3,192,4,240,0,3,192,0,0,0,2,64,0,
  // 0x5e94  应
  148,94,20,22,110,22,1,253,0,0,25,0,0,0,0,31,0,0,0,0,15,0,0,31,255,255,255,254,31,255,255,255,254,30,0,0,0,0,30,0,4,0,16,30,0,45,0,184,30,60,30,0,244,30,60,15,0,240,30,46,15,65,240,30,15,11,66,208,30,15,7,131,192,46,11,67,199,192,45,7,131,203,64,45,3,192,15,0,60,1,0,45,0,60,0,0,60,0,124,0,0,184,0,185,255,255,255,255,241,255,255,255,255,32,0,0,0,0,
  // 0x5e9f  废
  159,94,20,22,110,22,1,253,0,0,4,0,0,0,0,47,0,0,0,0,15,0,0,31,255,255,255,255,31,255,255,255,255,30,5,6,64,0,30,15,11,75,64,30,31,15,3,208,30,45,15,0,208,46,127,255,255,253,46,63,255,255,253,46,0,60,0,0,45,0,184,0,0,45,0,255,255,224,45,2,255,255,208,60,7,248,11,192,60,31,126,47,0,60,189,15,252,0,122,244,11,253,0,244,209,191,191,228,240,11,248,6,253,16,2,64,0,20,
  // 0x5ea6  度
  166,94,20,22,110,22,1,253,0,0,5,0,0,0,0,30,0,0,0,0,30,0,0,31,255,255,255,254,31,255,255,255,254,30,1,144,10,0,30,1,208,15,0,30,191,255,255,254,30,171,250,175,233,30,1,208,15,0,30,1,250,175,0,30,1,255,255,0,29,0,0,0,0,45,106,170,170,144,45,127,255,255,240,60,3,208,7,192,60,0,244,31,64,60,0,127,253,0,184,0,47,248,0,240,107,255,255,233,240,255,208,11,254,0,80,0,0,24,
  // 0x5f00  开
  0,95,20,20,100,22,1,253,63,255,255,255,252,63,255,255,255,252,0,45,0,60,0,0,45,0,60,0,0,45,0,60,0,0,45,0,60,0,0,45,0,60,0,0,45,0,60,0,255,255,255,255,255,255,255,255,255,255,0,60,0,60,0,0,60,0,60,0,0,124,0,60,0,0,244,0,60,0,1,240,0,60,0,3,224,0,60,0,15,192,0,60,0,63,64,0,60,0,124,0,0,60,0,16,0,0,40,0,
  // 0x5f03  弃
  3,95,20,21,105,22,1,253,0,0,60,0,0,0,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,15,128,16,0,0,31,0,125,0,0,61,0,31,128,63,255,255,255,240,63,255,255,254,252,0,24,0,40,40,0,60,0,60,0,0,60,0,60,0,191,255,255,255,254,255,255,255,255,255,0,124,0,60,0,0,248,0,60,0,2,240,0,60,0,11,208,0,60,0,127,64,0,60,0,189,0,0,60,0,16,0,0,20,0,
  // 0x5f0f  式
  15,95,20,22,110,22,1,253,0,0,1,64,0,0,0,3,211,192,0,0,3,210,240,0,0,2,208,188,0,0,2,208,32,191,255,255,255,255,191,255,255,255,255,0,0,2,224,0,0,0,1,224,0,0,0,1,240,0,63,255,248,240,0,63,255,248,240,0,0,124,0,244,0,0,124,0,180,0,0,124,0,184,0,0,124,0,124,4,0,124,4,61,11,0,127,253,47,15,111,255,228,15,143,127,164,0,7,254,16,0,0,1,252,0,0,0,0,0,
  // 0x5f15  引
  21,95,18,22,110,22,1,253,0,0,0,0,80,47,255,240,1,224,63,255,240,1,224,0,0,240,1,224,0,0,240,1,224,0,0,240,1,224,0,0,240,1,224,31,255,240,1,224,31,255,240,1,224,45,0,0,1,224,61,0,0,1,224,63,255,240,1,224,63,255,240,1,224,120,0,240,1,224,0,0,240,1,224,0,0,240,1,224,0,1,224,1,224,0,2,224,1,224,0,3,208,1,224,3,255,192,1,224,3,255,64,1,224,0,0,0,0,0,
  // 0x5f39  弹
  57,95,20,22,110,22,1,253,0,0,4,0,64,191,244,61,0,240,191,248,15,1,224,0,120,11,67,192,0,120,6,7,128,0,120,170,175,168,127,248,255,255,252,127,248,240,120,44,116,0,240,120,44,116,0,255,255,252,116,0,250,254,188,116,0,240,120,44,127,248,250,254,188,127,248,255,255,252,0,116,0,120,0,0,116,0,120,0,0,183,255,255,255,0,183,255,255,255,0,240,0,120,0,63,240,0,120,0,63,192,0,120,0,0,0,0,100,0,
  // 0x5f52  归
  82,95,18,22,110,22,2,253,0,96,0,0,0,0,240,0,0,0,0,240,255,255,240,240,240,255,255,240,240,240,0,0,240,240,240,0,0,240,240,240,0,0,240,240,240,0,0,240,240,240,0,0,240,240,240,0,0,240,240,240,191,255,240,240,240,191,255,240,240,240,0,0,240,240,240,0,0,240,224,240,0,0,240,1,224,0,0,240,3,208,0,0,240,3,192,0,0,240,15,130,255,255,240,47,2,255,255,240,125,0,0,0,240,20,0,0,0,80,
  // 0x5f84  径
  132,95,20,21,105,22,1,253,0,240,0,0,0,3,226,255,255,248,11,193,190,170,244,63,0,60,0,240,252,16,30,3,208,160,188,15,143,128,1,240,3,254,0,3,208,2,254,0,15,192,47,239,228,127,199,253,2,255,251,195,144,96,30,227,192,0,180,0,3,192,0,180,0,3,193,255,255,252,3,193,255,255,248,3,192,0,180,0,3,192,0,180,0,3,192,0,180,0,3,203,255,255,255,3,203,255,255,255,1,64,0,0,0,
  // 0x5f85  待
  133,95,20,22,110,22,1,253,0,64,0,80,0,1,240,0,240,0,3,208,0,240,0,31,129,255,255,252,190,1,255,255,252,184,16,0,240,0,96,244,0,240,0,1,240,0,240,0,3,223,255,255,255,15,203,255,255,255,63,192,0,3,192,255,192,0,3,192,243,203,255,255,255,67,199,255,255,255,3,192,16,3,192,3,192,244,3,192,3,192,124,3,192,3,192,46,3,192,3,192,15,3,192,3,192,4,3,192,3,192,0,255,192,3,192,0,191,64,
  // 0x5faa  循
  170,95,20,22,110,22,1,253,0,64,0,0,0,1,240,0,6,244,7,194,171,255,244,15,67,255,190,0,126,3,192,45,0,248,3,192,45,0,80,243,255,255,255,3,227,234,191,170,11,195,192,44,0,47,131,202,190,168,255,131,207,255,252,251,131,207,0,60,211,131,207,0,60,3,131,143,255,252,3,135,143,85,124,3,135,143,0,60,3,139,79,255,252,3,143,15,85,124,3,143,15,0,60,3,173,15,255,252,3,140,15,85,124,1,64,5,0,4,
  // 0x5fae  微
  174,95,21,22,132,22,0,253,0,64,20,1,64,0,1,240,56,2,192,0,3,209,56,83,192,0,15,139,56,227,192,0,47,11,56,227,128,0,60,91,56,235,255,192,16,255,56,239,239,192,2,235,255,255,11,0,3,198,170,191,79,0,15,192,0,63,143,0,63,202,170,183,142,0,127,207,255,242,221,0,35,193,199,66,252,0,3,194,199,65,252,0,3,194,199,64,248,0,3,194,199,64,244,0,3,195,199,244,248,0,3,199,143,227,252,0,3,207,10,11,159,0,3,222,0,63,11,192,3,200,0,60,3,192,1,128,0,0,0,0,
  // 0x5fc3  心
  195,95,21,21,126,22,1,254,0,1,0,0,0,0,0,11,208,0,0,0,0,7,253,0,0,0,0,0,127,208,0,0,0,0,7,244,0,0,0,0,0,160,0,0,0,0,0,0,0,0,0,31,0,0,0,0,4,31,0,3,192,0,15,31,0,3,208,0,30,31,0,1,240,0,45,31,0,0,248,0,61,31,0,0,124,0,60,31,0,0,62,0,124,31,0,0,31,0,248,31,0,14,15,64,240,31,0,15,9,0,16,31,0,15,0,0,0,31,0,31,0,0,0,15,255,253,0,0,0,7,255,248,0,0,
  // 0x5ffd  忽
  253,95,20,21,105,22,1,254,0,16,0,0,0,0,61,0,0,0,0,188,0,0,0,1,255,255,255,244,3,255,255,255,240,15,131,209,240,240,126,11,131,208,240,120,47,7,192,240,0,188,15,0,240,3,240,61,1,240,31,192,248,2,224,14,7,224,191,208,0,15,128,191,128,0,5,180,0,0,0,4,127,1,64,11,158,15,135,208,15,30,2,1,240,31,30,0,29,188,61,30,0,45,62,248,15,255,252,15,16,11,255,244,4,
  // 0x6027  性
  39,96,20,22,110,22,1,253,2,64,0,20,0,7,128,16,120,0,7,128,120,120,0,7,128,184,120,0,7,224,180,120,0,123,248,255,255,253,183,173,255,255,253,183,159,208,120,0,247,135,192,120,0,231,135,192,120,0,215,129,64,120,0,71,128,0,120,0,7,128,255,255,252,7,128,255,255,252,7,128,0,120,0,7,128,0,120,0,7,128,0,120,0,7,128,0,120,0,7,128,0,120,0,7,139,255,255,255,7,139,255,255,255,2,64,0,0,0,
  // 0x603b  总
  59,96,20,20,100,22,1,254,0,60,0,46,0,0,62,0,60,0,0,15,0,184,0,0,11,0,240,0,3,255,255,255,192,3,255,255,255,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,255,255,255,192,3,255,255,255,192,0,0,116,0,0,0,61,126,0,224,30,61,15,128,244,45,61,3,192,60,60,61,0,10,46,184,61,0,15,79,112,47,255,255,4,0,11,255,253,0,
  // 0x6062  恢
  98,96,20,21,105,22,1,253,7,128,224,0,0,7,128,224,0,0,7,143,255,255,255,7,155,255,255,255,119,240,224,9,0,119,184,224,30,0,183,172,224,30,0,183,156,226,30,14,231,128,231,30,14,215,128,235,30,44,71,129,239,30,60,7,129,238,30,116,7,130,216,47,16,7,130,192,63,0,7,131,192,123,128,7,131,128,243,192,7,139,66,225,240,7,143,11,192,248,7,158,47,0,63,7,172,60,0,15,2,64,16,0,0,
  // 0x606f  息
  111,96,20,21,105,22,1,254,0,0,36,0,0,0,0,124,0,0,1,170,254,170,128,2,255,255,255,192,2,208,0,3,192,2,229,85,91,192,2,255,255,255,192,2,208,0,3,192,2,229,85,91,192,2,255,255,255,192,2,208,0,3,192,2,208,0,3,192,2,255,255,255,192,1,170,170,170,128,0,0,244,0,64,10,29,62,3,208,15,29,15,65,244,61,29,1,20,124,188,30,0,45,47,176,31,255,252,15,0,11,255,244,0,
  // 0x611f  感
  31,97,20,21,105,22,1,254,0,0,1,65,0,0,0,3,207,208,0,0,3,194,224,15,255,255,255,254,15,170,171,234,169,14,85,86,208,64,14,191,253,225,224,30,0,0,243,208,30,21,80,251,192,29,127,248,127,64,45,112,56,62,5,60,112,56,191,11,120,127,251,255,143,244,21,151,195,254,176,1,244,0,184,1,25,189,1,128,15,94,31,3,240,15,30,0,24,248,61,30,0,44,61,248,31,255,252,31,32,11,255,244,4,
  // 0x620f  戏
  15,98,20,22,110,22,1,253,0,0,1,64,0,0,0,3,195,192,0,0,3,195,240,255,255,67,192,248,191,255,67,192,32,0,15,3,192,21,32,15,23,255,254,184,30,191,255,233,61,46,107,224,0,15,60,2,224,56,11,252,1,224,184,3,248,1,240,240,1,244,0,242,224,2,252,0,251,192,3,254,0,191,64,15,159,0,126,4,47,11,128,252,14,189,3,3,254,15,244,0,31,239,78,32,0,127,15,253,0,0,36,3,252,0,0,0,0,80,
  // 0x6210  成
  16,98,20,22,110,22,1,253,0,0,2,65,0,0,0,7,207,128,0,0,7,195,244,0,0,3,192,176,31,255,255,255,255,31,255,255,255,255,31,0,3,192,0,31,0,3,192,0,31,0,3,192,180,31,255,210,208,240,31,255,210,225,224,31,2,209,227,208,31,2,208,247,192,30,2,208,255,64,46,3,192,254,0,46,3,192,188,8,61,191,194,252,15,60,127,75,254,15,124,0,63,159,78,248,0,253,11,253,176,0,112,2,248,0,0,0,0,0,
  // 0x6237  户
  55,98,18,22,110,22,1,253,0,0,20,0,0,0,0,124,0,0,0,0,61,0,0,0,0,46,0,0,7,255,255,255,224,7,255,255,255,224,7,128,0,1,224,7,128,0,1,224,7,128,0,1,224,7,128,0,1,224,7,255,255,255,224,11,255,255,255,224,11,128,0,1,224,11,64,0,0,80,15,64,0,0,0,15,0,0,0,0,31,0,0,0,0,46,0,0,0,0,60,0,0,0,0,188,0,0,0,0,244,0,0,0,0,16,0,0,0,0,
  // 0x6240  所
  64,98,20,21,105,22,1,253,0,0,0,0,56,191,255,240,7,253,191,255,247,255,224,0,0,7,244,0,47,255,215,128,0,63,255,215,128,0,60,2,215,128,0,60,2,215,255,255,60,2,215,255,255,60,2,215,128,240,63,255,215,128,240,63,255,219,64,240,60,0,11,64,240,60,0,15,0,240,60,0,15,0,240,56,0,46,0,240,120,0,60,0,240,180,0,188,0,240,240,1,244,0,240,224,0,224,0,240,0,0,0,0,160,
  // 0x6247  扇
  71,98,19,21,105,22,1,253,42,170,170,170,168,127,255,255,255,252,0,0,0,0,0,6,170,170,170,160,15,255,255,255,240,15,0,0,0,240,15,0,0,0,240,15,255,255,255,240,15,170,170,170,160,15,0,0,0,0,15,191,249,255,244,15,106,184,170,244,15,56,120,176,116,30,45,120,124,116,46,14,120,40,116,61,1,120,6,116,60,47,184,127,180,185,253,122,244,116,244,144,121,64,180,224,7,244,11,244,0,2,144,2,144,
  // 0x624b  手
  75,98,20,22,110,22,1,253,0,0,0,1,64,0,0,90,255,208,31,255,255,254,64,15,250,189,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,31,255,255,255,248,31,255,255,255,248,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,255,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,191,252,0,0,0,63,224,0,0,0,0,0,0,0,
  // 0x6253  打
  83,98,20,22,110,22,1,253,2,128,0,0,0,3,208,0,0,0,3,208,191,255,255,3,208,191,255,255,3,208,0,15,64,255,255,0,15,64,255,255,0,15,64,3,208,0,15,64,3,208,0,15,64,3,208,0,15,64,3,239,0,15,64,11,255,0,15,64,255,248,0,15,64,187,208,0,15,64,3,208,0,15,64,3,208,0,15,64,3,208,0,15,64,3,208,0,15,64,3,208,0,15,64,63,192,15,255,0,63,64,7,253,0,0,0,0,0,0,
  // 0x6267  执
  103,98,20,23,115,22,1,252,2,64,6,0,0,7,128,11,64,0,7,128,11,64,0,7,128,11,64,0,7,128,11,64,0,255,250,255,255,192,255,255,255,255,192,7,128,11,3,192,7,128,15,3,192,7,128,15,3,192,7,153,223,3,192,7,254,255,3,192,191,248,127,67,192,255,128,31,243,192,87,128,62,255,192,7,128,60,55,192,7,128,184,3,192,7,128,244,2,197,7,131,240,2,203,7,139,192,1,235,127,111,64,0,254,62,13,0,0,124,0,0,0,0,0,
  // 0x6279  批
  121,98,20,22,110,22,1,253,2,0,64,4,0,7,65,224,45,0,7,65,224,45,0,7,65,224,45,0,7,65,224,45,0,255,249,224,45,0,255,249,224,45,12,7,65,224,45,62,7,65,255,174,248,7,65,255,175,208,7,149,224,47,0,11,249,224,45,0,255,229,224,45,0,255,65,224,45,0,7,65,224,45,0,7,65,224,45,0,7,65,224,45,9,7,65,224,45,11,7,66,235,238,15,11,95,254,95,255,191,78,64,11,252,125,0,0,0,0,
  // 0x6296  抖
  150,98,20,22,110,22,1,253,2,128,0,1,128,3,192,0,3,192,3,192,13,3,192,3,192,31,131,192,3,192,7,243,192,255,254,0,227,192,255,253,0,3,192,3,192,16,3,192,3,192,124,3,192,3,192,63,131,192,3,217,7,195,192,27,254,0,67,192,255,228,0,3,193,251,192,0,27,255,3,192,175,255,254,3,193,255,231,192,3,192,80,3,192,3,192,0,3,192,3,192,0,3,192,127,192,0,3,192,63,64,0,3,192,0,0,0,0,0,
  // 0x62a5  报
  165,98,20,22,110,22,1,253,2,128,0,0,0,3,192,191,255,248,3,192,255,255,252,3,192,240,0,120,3,192,240,0,120,255,253,240,0,184,255,253,240,106,244,3,192,240,127,224,3,192,240,0,0,3,192,255,255,252,3,217,255,255,252,7,253,247,192,60,255,249,242,208,120,255,192,241,240,244,83,192,240,245,240,3,192,240,127,208,3,192,240,63,192,3,192,240,31,192,3,192,240,127,240,3,192,247,244,254,255,192,251,208,62,190,0,81,0,4,
  // 0x62ac  抬
  172,98,20,22,110,22,1,253,2,128,1,64,0,3,192,3,224,0,3,192,3,192,0,3,192,7,192,0,3,192,15,65,128,255,253,15,3,208,255,253,46,0,240,3,192,60,0,188,3,195,254,191,253,3,195,255,255,255,3,237,0,0,15,27,254,0,0,0,255,228,191,255,248,251,192,191,255,248,3,192,180,0,120,3,192,180,0,120,3,192,180,0,120,3,192,180,0,120,3,192,180,0,120,3,192,191,255,248,127,192,191,255,248,62,0,100,0,100,
  // 0x62bd  抽
  189,98,20,22,110,22,1,253,2,64,0,20,0,3,192,0,120,0,3,192,0,120,0,3,192,0,120,0,3,192,0,120,0,255,252,0,120,0,255,253,255,255,254,3,192,255,255,254,3,192,224,120,30,3,192,224,120,30,3,193,224,120,30,7,253,224,120,30,191,249,255,255,254,255,192,255,255,254,67,192,224,120,30,3,192,224,120,30,3,192,224,120,30,3,192,224,120,30,3,192,255,255,254,3,192,255,255,254,191,128,224,0,30,62,0,144,0,5,
  // 0x62d4  拔
  212,98,20,22,110,22,1,253,2,64,6,0,0,3,192,11,71,128,3,192,11,71,240,3,192,11,64,188,3,192,11,64,36,255,253,175,170,169,255,254,255,255,255,3,192,15,0,0,3,192,15,64,0,3,192,15,128,176,3,196,15,192,240,7,252,31,192,240,191,248,46,225,224,255,192,61,242,208,147,192,60,123,192,3,192,120,63,128,3,192,244,47,0,3,193,240,63,128,3,195,208,191,224,3,203,194,240,252,191,159,15,192,63,62,9,2,0,5,
  // 0x62e9  择
  233,98,20,22,110,22,1,253,1,0,0,0,0,3,128,0,0,0,3,128,255,255,248,3,128,255,255,244,3,128,30,2,224,255,252,11,203,192,255,252,2,255,0,3,128,2,254,0,3,128,47,239,224,3,131,254,2,255,3,218,208,100,46,11,252,0,180,0,255,228,191,255,244,251,128,255,255,248,3,128,0,180,0,3,128,0,180,0,3,131,255,255,255,3,131,255,255,255,3,128,0,180,0,7,128,0,180,0,127,128,0,180,0,62,0,0,180,0,
  // 0x6309  按
  9,99,20,22,110,22,1,253,2,64,0,100,0,3,192,0,180,0,3,192,0,180,0,3,193,255,255,254,3,194,255,255,255,255,254,208,0,15,255,254,209,208,15,3,194,211,208,15,3,192,3,192,0,3,194,255,255,255,3,239,255,255,255,111,252,15,0,240,255,208,30,1,224,251,192,45,2,208,3,192,61,3,192,3,192,127,219,128,3,192,123,255,0,3,192,0,191,128,3,192,2,255,244,3,192,111,225,253,191,131,254,0,47,62,2,144,0,8,
  // 0x6321  挡
  33,99,19,22,110,22,1,253,1,64,0,16,0,3,128,0,120,0,3,128,160,120,40,3,128,240,120,60,3,128,180,120,60,255,252,120,120,180,255,252,60,120,240,3,128,36,120,224,3,128,0,120,0,3,129,255,255,252,3,217,255,255,252,27,252,0,0,60,255,228,0,0,60,235,128,255,255,252,3,128,255,255,252,3,128,0,0,60,3,128,0,0,60,3,128,0,0,60,7,131,255,255,252,127,131,255,255,252,126,0,0,0,60,0,0,0,0,20,
  // 0x6324  挤
  36,99,20,21,105,22,1,254,6,0,0,64,0,11,64,1,224,0,11,64,0,240,0,11,71,255,255,254,11,71,255,255,254,255,244,60,2,208,255,244,30,7,192,11,64,11,159,64,11,64,3,253,0,11,64,11,255,64,11,182,255,159,255,31,247,228,1,190,255,144,44,3,192,255,64,44,3,192,11,64,60,3,192,11,64,60,3,192,11,64,60,3,192,11,64,184,3,192,11,65,240,3,192,191,15,208,3,192,126,6,0,3,192,
  // 0x635f  损
  95,99,20,22,110,22,1,253,1,64,0,0,0,7,128,106,170,160,7,128,191,255,240,7,128,180,0,240,7,128,180,0,240,255,252,190,170,240,255,252,191,255,240,7,128,0,0,0,7,128,170,170,164,7,128,255,255,248,7,152,240,0,120,11,252,240,96,120,255,244,240,180,120,255,128,240,180,120,71,128,240,240,120,7,128,240,240,120,7,128,146,225,20,7,128,11,203,128,7,128,191,3,244,191,79,248,0,127,126,7,128,0,14,0,0,0,0,0,
  // 0x6362  换
  98,99,20,22,110,22,1,253,6,64,5,0,0,11,64,15,64,0,11,64,31,170,144,11,64,63,255,240,11,64,248,3,192,255,246,240,15,128,255,251,250,175,164,11,66,255,255,248,11,64,240,180,184,11,64,240,180,184,11,148,240,180,184,11,248,240,240,184,255,244,240,240,184,255,75,255,255,255,11,71,255,255,254,11,64,3,252,0,11,64,15,158,0,11,64,62,11,128,11,65,248,2,244,191,95,208,0,191,62,14,0,0,9,0,0,0,0,0,
  // 0x6389  掉
  137,99,20,22,110,22,1,253,2,64,0,96,0,7,128,0,240,0,7,128,0,254,170,7,128,0,255,255,7,128,0,240,0,255,252,0,240,0,255,250,255,255,248,7,130,234,170,184,7,130,208,0,120,7,130,234,170,184,7,134,255,255,248,11,254,208,0,120,255,210,234,170,184,235,130,255,255,248,7,128,0,240,0,7,128,0,240,0,7,143,255,255,255,7,139,255,255,255,7,128,0,240,0,255,64,0,240,0,190,0,0,240,0,0,0,0,0,0,
  // 0x63a2  探
  162,99,20,22,110,22,1,253,6,64,0,0,0,7,66,170,170,170,7,67,255,255,254,7,67,192,0,14,7,67,199,79,14,255,251,203,79,14,255,248,15,15,0,7,64,30,15,11,7,64,188,15,175,7,67,240,11,253,7,164,64,180,0,31,248,0,180,0,255,211,255,255,254,235,67,255,255,255,7,64,7,255,0,7,64,15,255,128,7,64,62,183,208,7,64,188,181,244,7,67,240,180,189,11,79,192,180,47,191,70,0,180,9,125,0,0,176,0,
  // 0x63a5  接
  165,99,20,22,110,22,1,253,1,64,0,0,0,3,192,0,180,0,3,192,0,180,0,3,194,255,255,253,3,194,191,171,249,255,248,45,2,208,255,248,30,3,192,3,192,15,7,128,3,203,255,255,255,3,199,255,255,255,3,212,3,192,0,7,252,7,128,0,191,255,255,255,255,255,198,191,171,250,131,192,61,3,192,3,192,60,3,192,3,192,190,75,128,3,192,255,255,0,3,192,1,255,64,3,192,27,255,244,191,139,255,129,253,62,7,160,0,24,
  // 0x63a7  控
  167,99,20,22,110,22,1,253,1,0,0,80,0,7,64,0,240,0,7,64,0,240,0,7,67,255,255,255,7,67,239,239,175,255,251,139,79,15,255,250,75,15,14,7,64,15,15,0,7,64,46,15,11,7,64,188,15,175,7,187,240,7,253,31,249,64,0,0,255,208,0,0,0,255,65,255,255,252,71,65,255,255,252,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,11,75,255,255,255,191,75,255,255,255,125,0,0,0,0,
  // 0x63d0  提
  208,99,20,22,110,22,1,253,6,0,0,0,0,11,64,255,255,248,11,64,250,170,184,11,64,240,0,120,11,64,255,255,248,255,248,245,85,184,255,248,240,0,120,11,64,250,170,184,11,64,255,255,248,11,64,0,0,0,11,86,170,170,169,11,251,255,255,254,255,228,0,176,0,255,64,176,176,0,11,64,240,186,164,11,64,240,191,248,11,65,244,176,0,11,67,252,176,0,11,75,143,240,0,191,31,7,255,255,126,13,0,191,255,0,0,0,0,0,
  // 0x63d2  插
  210,99,20,22,110,22,1,253,1,0,0,0,0,7,64,0,6,180,7,66,191,255,252,7,66,255,249,0,7,64,0,176,0,255,248,0,176,0,255,255,255,255,255,7,67,255,255,254,7,64,0,176,0,7,64,9,176,0,7,82,191,243,253,11,251,244,178,189,255,231,192,176,29,255,67,192,176,29,7,67,254,179,253,7,67,249,178,189,7,67,192,176,29,7,67,192,176,29,7,67,250,254,189,11,67,255,255,253,191,67,192,0,29,125,1,64,0,4,
  // 0x6536  收
  54,101,20,22,110,22,1,253,0,4,1,0,0,0,30,3,208,0,0,30,3,192,0,24,30,7,192,0,60,30,11,128,0,60,30,15,255,255,60,30,31,255,255,60,30,63,0,120,60,30,127,64,180,60,30,255,128,240,60,31,243,192,240,60,30,67,194,224,60,30,1,227,192,60,46,0,251,128,63,254,0,191,0,255,254,0,62,0,249,30,0,255,0,0,30,3,255,192,0,30,31,195,244,0,30,255,0,255,0,30,248,0,47,0,25,0,0,4,
  // 0x653e  放
  62,101,20,22,110,22,1,253,0,144,0,80,0,0,240,0,240,0,0,240,0,240,0,0,240,1,224,0,255,255,226,224,0,255,255,227,255,255,11,64,3,255,255,11,64,11,192,180,11,64,15,192,240,11,255,239,208,240,11,255,254,225,224,11,67,220,242,208,11,67,128,247,192,11,3,128,127,128,15,3,128,63,64,15,7,128,47,0,31,7,128,63,64,45,7,128,255,192,60,7,67,243,240,248,15,111,192,254,240,255,190,0,63,80,185,36,0,8,
  // 0x6570  数
  112,101,20,22,110,22,1,253,0,96,0,16,0,56,180,240,184,0,44,181,224,180,0,29,183,192,240,0,174,250,164,240,0,255,255,249,255,255,2,253,2,255,255,11,255,131,224,120,63,187,247,240,180,248,180,175,240,240,80,244,47,180,240,2,224,12,121,240,171,250,164,63,208,255,255,248,47,192,15,3,192,31,128,46,11,64,31,64,63,223,0,63,192,42,254,0,255,240,1,255,135,240,252,111,231,255,192,127,190,0,238,0,30,16,0,4,0,0,
  // 0x6572  敲
  114,101,20,22,110,22,1,253,0,0,0,24,0,0,176,0,44,0,0,176,0,44,0,255,255,248,47,254,170,170,164,47,255,5,85,64,44,0,15,255,192,44,0,14,3,192,44,0,14,3,203,255,252,15,255,207,255,252,5,85,66,128,60,21,85,82,192,120,127,255,241,224,244,116,0,240,241,240,118,252,240,187,224,118,76,240,63,192,118,76,240,47,128,118,76,240,63,128,118,252,240,255,224,118,64,251,241,254,116,11,251,128,46,32,1,64,0,4,
  // 0x6574  整
  116,101,20,21,105,22,1,254,0,80,0,16,0,0,176,0,120,0,191,255,244,240,0,85,249,81,255,255,63,255,243,234,250,57,181,255,224,240,56,176,250,118,224,63,255,240,63,192,23,254,80,31,128,11,255,128,127,224,126,182,247,245,254,180,176,79,128,62,0,16,0,0,4,31,255,255,255,248,26,170,190,170,164,0,0,60,0,0,1,208,63,255,192,1,208,62,170,128,1,208,60,0,0,171,250,190,170,170,255,255,255,255,255,
  // 0x6599  料
  153,101,20,22,110,22,1,253,0,64,0,0,144,2,208,0,1,208,178,211,195,1,208,178,211,135,209,208,118,215,1,245,208,58,219,0,49,208,58,222,0,1,208,18,208,0,1,208,255,255,174,1,208,255,255,223,193,208,7,224,2,225,208,11,244,0,129,208,15,252,0,1,208,46,239,0,6,255,62,219,90,255,255,182,211,63,255,224,242,208,41,1,208,210,208,0,1,208,66,208,0,1,208,2,208,0,1,208,2,208,0,1,208,1,128,0,0,144,
  // 0x659c  斜
  156,101,21,22,132,22,0,253,0,25,0,0,40,0,0,63,64,0,60,0,0,191,208,52,60,0,0,241,244,125,60,0,3,192,125,15,124,0,11,64,44,7,124,0,31,255,240,0,60,0,127,255,240,64,60,0,36,30,0,244,60,0,0,30,0,125,60,0,47,255,253,15,60,0,63,255,253,5,60,0,0,30,0,0,61,128,6,30,32,1,191,192,11,30,117,191,255,128,15,30,62,255,188,0,30,30,45,144,60,0,45,30,29,0,60,0,60,30,13,0,60,0,20,30,0,0,60,0,2,253,0,0,60,0,1,248,0,0,44,0,
  // 0x65ad  断
  173,101,20,22,110,22,1,253,0,4,0,0,0,36,14,0,0,124,121,142,53,95,253,122,206,118,255,144,121,206,178,224,0,120,222,210,208,0,120,78,66,208,0,122,175,166,208,0,123,255,250,255,255,120,46,2,255,255,120,63,130,208,240,120,191,226,192,240,120,238,183,192,240,123,206,35,192,240,123,78,3,192,240,121,14,3,192,240,120,9,7,128,240,126,170,175,0,240,127,255,255,0,240,120,0,61,0,240,52,0,60,0,240,0,0,0,0,96,
  // 0x65b0  新
  176,101,20,22,110,22,1,253,0,80,0,0,0,0,240,0,0,124,0,240,1,27,253,191,255,243,255,144,111,171,227,208,0,29,3,195,192,0,15,11,67,192,0,11,11,3,192,0,255,255,247,255,255,170,254,163,255,255,0,240,3,192,240,0,240,3,192,240,255,255,243,192,240,171,254,167,192,240,2,248,7,128,240,7,255,11,64,240,15,251,207,0,240,61,241,223,0,240,244,240,46,0,240,144,240,124,0,240,0,240,180,0,240,0,96,16,0,80,
  // 0x65b9  方
  185,101,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,254,255,255,255,255,255,0,7,192,0,0,0,7,192,0,0,0,7,192,0,0,0,11,128,0,0,0,11,255,255,192,0,15,255,255,192,0,15,0,3,192,0,31,0,3,192,0,62,0,3,192,0,124,0,7,192,0,248,0,7,128,3,240,0,11,128,31,192,0,15,64,191,0,47,255,0,56,0,31,252,0,0,0,0,0,0,
  // 0x65e0  无
  224,101,20,20,100,22,1,253,31,255,255,255,248,31,255,255,255,248,0,0,120,0,0,0,0,120,0,0,0,0,184,0,0,0,0,184,0,0,0,0,184,0,0,255,255,255,255,255,191,255,255,255,255,0,0,240,0,0,0,1,255,64,0,0,2,239,64,0,0,3,207,64,0,0,15,143,64,0,0,47,15,64,14,0,189,15,64,15,11,244,15,64,15,191,192,11,255,254,125,0,2,255,248,0,0,0,0,0,
  // 0x65f6  时
  246,101,19,22,110,22,2,253,0,0,0,1,0,0,0,0,7,128,255,248,0,7,128,255,252,0,7,128,224,60,0,7,128,224,60,255,255,252,224,60,255,255,252,224,60,0,7,128,224,60,0,7,128,255,252,116,7,128,255,252,60,7,128,224,60,47,7,128,224,60,15,71,128,224,60,7,199,128,224,60,2,71,128,255,252,0,7,128,255,252,0,7,128,224,0,0,7,128,224,0,0,11,128,0,0,11,255,128,0,0,3,254,0,0,0,0,0,0,
  // 0x660e  明
  14,102,19,21,105,22,2,253,0,0,63,255,244,255,252,63,255,244,255,252,60,0,180,224,60,60,0,180,224,60,60,0,180,224,60,60,0,180,224,60,63,255,244,255,252,63,255,244,255,252,60,0,180,224,60,60,0,180,224,60,60,0,180,224,60,127,255,244,224,60,127,255,244,255,252,180,0,180,255,252,240,0,180,224,2,240,0,180,224,3,208,0,180,0,15,192,0,180,0,47,0,63,244,0,28,0,47,208,0,0,0,0,0,
  // 0x662f  是
  47,102,20,21,105,22,1,253,2,170,170,170,128,7,255,255,255,208,7,128,0,2,208,7,149,85,87,208,7,255,255,255,208,7,128,0,2,208,7,234,170,171,208,7,255,255,255,208,0,0,0,0,0,127,255,255,255,254,191,255,255,255,254,0,64,60,0,0,1,240,60,0,0,2,224,63,255,240,3,224,63,255,240,7,244,60,0,0,15,189,60,0,0,47,47,252,0,0,189,7,255,255,255,180,0,111,255,254,0,0,0,0,0,
  // 0x6682  暂
  130,102,20,22,110,22,1,253,0,64,0,0,0,1,240,0,5,188,255,255,246,255,248,111,170,162,228,0,15,24,2,192,0,60,44,2,234,170,127,255,246,255,255,42,190,167,193,208,0,62,163,193,208,191,255,247,129,208,105,124,11,65,208,0,44,15,1,208,0,0,0,0,64,3,255,255,255,208,3,234,170,171,208,3,128,0,2,208,3,255,255,255,208,3,213,85,87,208,3,128,0,2,208,3,255,255,255,208,3,234,170,171,208,1,64,0,1,64,
  // 0x66ab  暫
  171,102,20,22,110,22,1,253,0,96,0,0,16,21,181,81,22,248,191,255,247,255,208,0,176,3,208,0,63,255,227,192,0,56,176,227,234,170,63,255,227,255,255,56,176,227,130,208,63,255,231,130,208,0,180,15,2,208,255,255,255,2,208,0,176,44,2,208,0,80,4,0,64,3,255,255,255,192,3,234,170,171,192,3,192,0,3,192,3,255,255,255,192,3,229,85,91,192,3,192,0,3,192,3,255,255,255,192,3,234,170,171,192,1,64,0,1,64,
  // 0x66f4  更
  244,102,20,20,100,22,1,253,191,255,255,255,254,127,255,255,255,253,0,0,60,0,0,6,170,190,170,160,11,255,255,255,240,11,64,60,0,240,11,64,60,0,240,11,255,255,255,240,11,170,190,170,240,11,64,60,0,240,11,234,190,170,240,11,255,255,255,240,1,192,124,0,0,2,240,244,0,0,0,191,240,0,0,0,63,208,0,0,1,255,254,148,0,191,244,127,255,255,62,64,0,107,254,0,0,0,0,0,
  // 0x6700  最
  0,103,20,21,105,22,1,253,3,255,255,255,192,3,213,85,87,192,3,192,0,3,192,3,255,255,255,192,3,213,85,87,192,3,213,85,87,192,3,255,255,255,192,0,0,0,0,0,191,255,255,255,254,111,171,250,170,169,15,2,208,0,0,15,255,223,255,248,15,86,219,234,248,15,2,211,192,240,15,255,209,227,224,15,151,208,191,192,15,2,208,63,64,191,255,209,255,128,190,150,255,247,249,0,2,239,128,190,0,1,64,0,4,
  // 0x6709  有
  9,103,20,22,110,22,1,253,0,1,64,0,0,0,3,192,0,0,0,7,192,0,0,191,255,255,255,254,191,255,255,255,254,0,46,0,0,0,0,61,0,0,0,0,188,0,0,0,1,255,255,255,192,3,255,255,255,192,15,244,0,3,192,63,190,170,171,192,252,191,255,255,192,32,180,0,3,192,0,180,0,3,192,0,190,170,171,192,0,191,255,255,192,0,180,0,3,192,0,180,0,3,192,0,180,0,3,192,0,180,0,255,192,0,180,0,254,64,
  // 0x671f  期
  31,103,20,22,110,22,1,253,4,0,64,0,0,15,3,192,0,0,15,3,193,255,253,191,255,249,255,253,255,255,249,224,45,15,3,193,224,45,15,3,193,224,45,15,255,193,255,253,15,171,193,255,253,15,3,193,224,45,15,171,193,224,45,15,255,193,224,45,15,3,193,255,253,15,3,194,255,253,255,255,246,208,45,255,255,251,192,45,1,1,3,192,45,15,79,67,192,45,47,3,199,64,45,124,1,239,7,252,244,0,138,3,248,16,0,0,0,0,
  // 0x673a  机
  58,103,21,22,132,22,1,253,0,80,0,0,0,0,1,224,0,0,0,0,1,224,15,255,208,0,1,224,15,255,208,0,1,224,15,2,208,0,191,255,143,2,208,0,255,255,143,2,208,0,3,224,15,2,208,0,3,224,15,2,208,0,7,244,15,2,208,0,15,252,15,2,208,0,15,255,30,2,208,0,45,235,158,2,208,0,57,227,45,2,208,0,245,224,45,2,208,0,225,224,60,2,210,0,129,224,124,2,211,64,1,224,180,2,211,64,1,225,240,2,211,64,1,227,208,2,255,64,1,226,192,0,254,0,0,64,0,0,0,0,
  // 0x6740  杀
  64,103,20,22,110,22,1,253,0,0,0,1,0,3,64,0,15,192,11,248,0,127,0,0,191,211,248,0,0,7,255,208,0,0,2,255,208,0,0,127,231,253,0,27,253,0,127,208,127,208,0,7,240,24,0,60,0,128,0,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,0,60,0,0,0,160,60,8,0,1,240,60,47,0,3,208,60,11,192,15,128,60,2,240,63,0,60,0,252,252,0,60,0,62,48,11,252,0,24,0,7,228,0,0,
  // 0x675f  束
  95,103,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,127,255,255,255,253,127,255,255,255,253,0,0,60,0,0,0,0,60,0,0,15,255,255,255,240,15,255,255,255,240,15,0,60,0,240,15,0,60,0,240,15,0,60,0,240,15,255,255,255,240,11,255,255,255,240,0,3,255,192,0,0,15,255,240,0,0,126,60,189,0,2,248,60,47,128,47,208,60,7,248,255,0,60,0,255,36,0,60,0,28,0,0,40,0,0,
  // 0x6761  条
  97,103,20,22,110,22,1,253,0,2,64,0,0,0,11,192,0,0,0,47,234,173,0,0,191,255,255,0,2,253,0,125,0,31,239,0,248,0,62,7,215,224,0,4,1,255,128,0,0,2,255,208,0,0,127,235,254,80,111,254,0,127,254,127,144,60,1,189,20,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,7,255,208,0,0,31,125,244,0,0,253,60,127,0,11,240,60,15,228,191,128,60,1,255,120,0,60,0,45,0,0,40,0,0,
  // 0x6765  来
  101,103,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,47,255,255,255,252,47,255,255,255,252,0,128,60,2,64,3,208,60,3,208,1,240,60,7,192,0,240,60,15,64,0,184,60,31,0,0,96,60,25,0,191,255,255,255,254,191,255,255,255,254,0,3,255,192,0,0,11,190,224,0,0,46,60,188,0,0,248,60,47,0,7,240,60,15,208,127,128,60,2,253,253,0,60,0,127,32,0,60,0,8,0,0,40,0,0,
  // 0x677f  板
  127,103,20,22,110,22,1,253,1,64,0,0,0,2,192,0,0,0,2,192,63,255,254,2,192,63,255,254,2,192,60,0,0,191,255,60,0,0,255,255,60,0,0,3,192,60,0,0,7,192,63,255,253,11,208,63,255,252,15,244,63,192,60,15,252,63,192,120,47,222,121,208,180,58,203,120,240,240,182,192,180,186,208,242,192,244,63,192,194,192,240,47,64,2,193,224,63,192,2,195,208,255,240,2,199,203,240,254,2,199,79,128,46,1,128,0,0,4,
  // 0x6797  林
  151,103,20,22,110,22,1,253,0,160,0,25,0,0,240,0,30,0,0,240,0,30,0,0,240,0,30,0,0,240,0,30,0,191,255,207,255,254,191,255,207,255,254,2,240,0,63,64,3,252,0,127,128,7,254,0,191,192,11,255,128,255,208,15,243,194,255,224,45,241,195,222,176,60,240,11,94,120,180,240,31,30,61,240,240,61,30,47,144,240,184,30,14,0,240,48,30,4,0,240,0,30,0,0,240,0,30,0,0,240,0,30,0,0,80,0,5,0,
  // 0x67f1  柱
  241,103,20,22,110,22,1,253,1,144,0,64,0,1,208,2,240,0,1,208,0,253,0,1,208,0,63,0,1,208,0,15,0,191,255,127,255,255,255,255,191,255,255,3,208,0,45,0,3,224,0,45,0,7,240,0,45,0,15,248,0,45,0,15,253,0,45,0,46,239,111,255,254,61,215,111,255,254,181,209,0,45,0,241,208,0,45,0,209,208,0,45,0,1,208,0,45,0,1,208,0,45,0,1,209,255,255,255,1,209,255,255,255,1,144,0,0,0,
  // 0x6821  校
  33,104,20,21,105,22,1,253,3,192,0,60,0,3,192,0,60,0,3,192,0,60,0,3,192,255,255,255,191,254,85,85,85,255,254,10,1,208,3,192,31,1,240,7,192,61,0,188,11,240,188,0,62,15,245,250,2,159,31,252,143,3,196,63,222,7,135,192,55,201,3,207,64,243,192,1,255,0,227,192,0,253,0,131,192,0,254,0,3,192,3,255,128,3,192,31,199,244,3,193,254,1,254,3,194,244,0,62,1,128,64,0,4,
  // 0x683c  格
  60,104,20,22,110,22,1,253,1,128,0,64,0,2,192,3,208,0,2,192,7,192,0,2,192,11,255,244,2,192,31,255,240,2,192,63,1,240,255,255,191,67,208,191,255,251,203,192,3,209,210,255,0,7,240,0,253,0,15,252,1,255,64,15,238,15,199,224,47,202,254,0,255,58,195,254,170,254,178,193,127,255,244,242,192,60,0,180,194,192,60,0,180,2,192,60,0,180,2,192,60,0,180,2,192,63,255,244,2,192,63,255,244,1,128,40,0,96,
  // 0x68af  梯
  175,104,20,22,110,22,1,253,1,128,4,0,64,3,192,45,0,244,3,192,15,1,240,3,192,15,3,192,3,192,191,255,252,191,253,255,255,252,255,254,0,120,44,3,192,0,120,44,7,208,127,255,252,15,240,191,255,252,15,248,240,120,0,31,237,240,120,0,63,206,255,255,254,119,197,255,255,255,243,193,145,248,14,227,192,7,248,30,131,192,15,184,30,3,192,125,120,45,3,194,248,122,252,3,195,208,121,228,3,193,0,120,0,1,64,0,20,0,
  // 0x68c0  检
  192,104,20,22,110,22,1,253,2,64,0,160,0,3,128,0,240,0,3,128,2,252,0,3,128,7,111,0,255,248,14,11,192,255,248,60,3,244,7,128,240,0,253,11,199,250,170,191,15,239,175,255,202,15,245,0,0,0,47,184,0,0,16,63,172,208,224,60,59,128,224,240,116,183,128,240,176,176,243,128,176,176,224,211,128,116,117,208,67,128,56,19,192,3,128,0,3,128,3,128,0,11,0,3,135,255,255,254,3,135,255,255,253,2,64,0,0,0,
  // 0x69fd  槽
  253,105,20,22,110,22,1,253,1,64,2,70,0,3,192,3,139,0,3,194,171,239,170,3,195,255,255,255,3,192,3,139,0,191,253,255,255,253,255,253,231,223,109,7,193,211,139,29,11,193,255,255,253,15,209,231,219,109,15,241,211,139,29,31,249,255,255,253,63,236,85,85,84,55,204,42,170,164,179,192,127,255,248,227,192,116,0,120,195,192,121,85,184,3,192,127,255,248,3,192,116,0,120,3,192,126,170,184,3,192,127,255,248,2,64,100,0,36,
  // 0x6a21  模
  33,106,20,22,110,22,1,253,2,64,5,1,64,7,128,15,3,192,7,130,175,171,233,7,131,255,255,254,7,128,15,3,192,255,252,10,2,128,255,248,255,255,248,7,128,245,85,184,11,192,224,0,120,15,224,255,255,248,31,244,245,85,184,47,188,245,85,184,63,152,255,255,248,123,128,0,240,0,247,128,0,240,0,231,135,255,255,254,135,130,171,255,170,7,128,7,223,0,7,128,31,75,208,7,130,253,2,253,7,139,224,0,126,2,65,0,0,4,
  // 0x6a59  橙
  89,106,20,22,110,22,1,253,1,64,0,0,0,3,192,170,78,16,3,192,255,207,180,3,192,7,139,208,3,193,223,3,207,191,253,254,2,252,255,253,62,170,244,3,192,251,255,189,11,194,224,0,47,15,215,192,0,15,15,242,127,255,244,31,252,125,85,244,63,221,120,0,180,119,196,126,170,244,243,192,127,255,244,227,192,9,1,128,131,192,30,3,192,3,192,15,3,192,3,192,11,7,64,3,195,255,255,255,3,195,255,255,255,1,64,0,0,0,
  // 0x6b62  止
  98,107,20,21,105,22,1,254,0,0,5,0,0,0,0,15,0,0,0,0,15,0,0,0,0,15,0,0,0,0,15,0,0,2,128,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,255,252,3,192,15,255,252,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,3,192,15,0,0,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,
  // 0x6b63  正
  99,107,20,19,95,22,1,254,63,255,255,255,252,63,255,255,255,252,0,0,30,0,0,0,0,30,0,0,0,0,30,0,0,0,0,30,0,0,3,192,30,0,0,3,192,30,0,0,3,192,31,255,240,3,192,31,255,240,3,192,30,0,0,3,192,30,0,0,3,192,30,0,0,3,192,30,0,0,3,192,30,0,0,3,192,30,0,0,3,192,30,0,0,255,255,255,255,255,255,255,255,255,255,
  // 0x6b65  步
  101,107,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,2,208,60,0,0,2,208,63,255,224,2,208,63,255,224,2,208,60,0,0,2,208,60,0,0,191,255,255,255,254,255,255,255,255,255,0,0,60,0,0,0,244,60,1,64,3,240,60,3,208,15,192,60,7,192,127,0,60,15,128,124,11,252,63,0,0,7,244,188,0,0,0,3,244,0,0,0,47,208,0,0,7,254,0,0,11,255,228,0,0,11,253,0,0,0,1,0,0,0,0,
  // 0x6bd4  比
  212,107,20,21,105,22,1,254,1,64,1,64,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,20,3,192,3,192,253,3,255,227,219,244,3,255,227,255,128,3,192,3,244,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,10,3,192,19,192,11,3,219,243,192,15,111,255,243,192,15,255,249,2,255,254,165,0,0,255,248,
  // 0x6ca1  没
  161,108,20,22,110,22,1,253,4,0,0,0,0,47,64,191,255,64,15,224,191,255,64,1,240,180,11,64,0,0,180,11,64,0,0,240,11,75,16,1,240,11,75,253,7,208,11,239,127,143,128,3,253,7,134,0,0,0,0,7,255,255,240,0,7,255,255,240,0,64,116,2,224,0,240,124,3,192,2,224,62,15,128,3,192,15,191,0,11,128,7,252,0,15,0,11,253,0,46,0,191,191,208,60,47,253,11,254,40,47,144,0,190,0,4,0,0,4,
  // 0x6ce2  波
  226,108,20,22,110,22,1,253,0,0,0,80,0,29,0,0,240,0,47,192,0,240,0,7,240,0,240,0,0,211,255,255,255,0,3,255,255,254,0,3,128,240,60,116,3,128,240,60,191,67,128,240,16,15,131,255,255,240,1,7,255,255,244,0,7,188,0,240,0,7,158,2,224,2,199,143,3,192,3,203,71,203,128,7,207,3,255,0,15,79,0,253,0,31,30,1,254,0,61,45,15,239,208,124,125,191,67,254,56,120,248,0,126,0,0,64,0,4,
  // 0x6ce8  注
  232,108,20,22,110,22,1,253,4,0,4,0,0,31,64,31,128,0,11,240,11,244,0,0,240,1,253,0,0,0,0,60,0,0,7,255,255,254,16,7,255,255,254,253,0,0,240,0,127,192,0,240,0,11,128,0,240,0,1,0,0,240,0,0,0,0,240,0,0,2,255,255,252,0,162,255,255,252,0,240,0,240,0,2,224,0,240,0,3,192,0,240,0,11,128,0,240,0,31,0,0,240,0,62,15,255,255,255,44,15,255,255,255,0,0,0,0,0,
  // 0x6d17  洗
  23,109,21,22,132,22,1,253,0,0,0,160,0,0,45,0,180,240,0,0,47,192,240,240,0,0,3,224,240,240,0,0,0,129,255,255,252,0,0,3,255,255,252,0,0,3,192,240,0,0,180,15,128,240,0,0,254,15,0,240,0,0,31,129,0,240,0,0,3,15,255,255,255,0,0,15,255,255,255,0,0,0,45,15,0,0,1,192,45,15,0,0,3,192,60,15,0,0,7,192,60,15,0,0,15,64,120,15,6,0,31,0,244,15,7,64,61,3,224,15,11,64,124,47,192,15,255,0,24,30,0,7,253,0,0,0,0,0,0,0,
  // 0x6d3b  活
  59,109,20,22,110,22,1,253,0,0,0,0,16,30,0,0,27,248,47,209,191,255,228,3,242,255,248,0,0,64,64,176,0,0,0,0,176,0,0,0,0,176,0,116,15,255,255,255,191,79,255,255,255,31,192,0,176,0,3,64,0,176,0,0,0,0,176,0,0,0,0,176,0,0,129,255,255,248,1,241,255,255,248,3,209,224,0,56,7,193,224,0,56,15,65,224,0,56,47,1,224,0,56,61,1,255,255,248,56,1,255,255,248,0,0,144,0,36,
  // 0x6d41  流
  65,109,20,22,110,22,1,253,0,0,0,144,0,47,64,1,224,0,31,224,1,224,0,1,239,255,255,255,0,15,255,255,255,0,0,15,64,0,0,0,15,3,192,184,0,45,2,240,255,64,62,170,248,31,139,255,255,253,1,11,165,80,15,0,0,160,145,196,0,0,241,210,208,0,208,241,210,208,2,224,225,210,208,3,192,225,210,208,11,129,209,210,208,15,3,209,210,211,46,7,193,210,211,124,31,65,210,255,40,29,0,64,254,0,0,0,0,0,
  // 0x6d4b  测
  75,109,20,21,105,22,1,253,45,0,0,0,13,63,159,255,208,13,7,222,86,211,77,0,77,1,211,77,0,13,117,211,77,0,13,117,211,77,180,13,117,211,77,190,13,117,211,77,31,77,117,211,77,1,13,117,211,77,0,13,117,211,77,0,13,117,211,77,3,13,117,211,77,7,141,113,211,77,15,77,113,211,77,15,8,176,66,13,46,0,232,0,13,60,3,207,0,13,124,11,67,192,29,116,62,1,227,252,0,20,0,65,164,
  // 0x6d88  消
  136,109,20,22,110,22,1,253,0,0,0,96,0,45,1,64,240,24,47,195,192,240,61,7,225,240,240,124,0,192,240,240,244,0,0,180,240,224,0,0,0,240,0,116,2,255,255,252,190,2,255,255,252,31,130,208,0,60,2,2,208,0,60,0,2,255,255,252,0,2,250,170,252,0,210,208,0,60,2,210,208,0,60,3,194,255,255,252,11,130,250,170,252,15,2,208,0,60,62,2,208,0,60,124,2,208,15,248,20,2,208,15,224,0,0,0,0,0,
  // 0x6de1  淡
  225,109,20,21,105,22,1,253,4,0,0,240,0,47,64,144,240,32,11,224,224,240,188,1,226,209,224,240,0,7,194,226,208,0,2,3,245,128,16,0,11,255,64,253,0,47,15,224,47,134,253,1,252,7,71,224,224,44,0,1,0,240,0,0,1,225,224,60,1,194,209,224,184,3,211,194,240,240,7,203,131,251,208,15,66,7,253,64,47,0,31,95,64,61,1,190,11,224,124,31,244,2,255,20,15,64,0,45,0,0,0,0,0,
  // 0x6df7  混
  247,109,20,21,105,22,1,253,46,2,170,170,164,31,211,255,255,248,2,211,128,0,120,0,131,128,0,120,0,3,255,255,248,0,3,234,170,248,180,3,128,0,120,191,3,234,170,248,31,67,255,255,248,1,1,64,20,0,0,3,192,60,0,0,3,192,60,28,1,195,255,125,253,3,211,255,191,240,7,195,192,62,0,15,67,192,60,0,31,3,192,60,11,62,7,255,188,11,124,63,255,127,255,40,42,64,31,253,0,0,0,0,0,
  // 0x6e05  清
  5,110,20,22,110,22,1,253,0,0,0,80,0,46,0,0,240,0,47,215,255,255,253,2,225,86,245,84,0,65,86,245,84,0,3,255,255,252,0,0,0,240,0,180,5,86,245,85,255,79,255,255,255,31,128,0,0,0,1,0,255,255,244,0,0,250,170,244,0,0,224,0,116,0,224,255,255,244,2,224,245,85,180,3,192,224,0,116,11,128,255,255,244,15,64,245,85,180,47,0,224,0,116,61,0,224,0,180,60,0,224,15,244,0,0,224,10,144,
  // 0x6e29  温
  41,110,20,21,105,22,1,253,31,65,170,170,160,31,226,255,255,240,1,242,192,0,240,0,2,192,0,240,0,2,255,255,240,0,2,234,170,240,180,2,192,0,240,191,66,250,170,240,11,130,255,255,240,1,0,0,0,0,0,0,0,0,0,0,7,255,255,248,1,215,239,191,248,3,215,78,28,56,7,199,78,28,56,15,71,78,28,56,31,7,78,28,56,61,7,78,28,56,124,63,255,255,255,36,63,255,255,255,0,0,0,0,0,
  // 0x6e38  游
  56,110,20,22,110,22,1,253,0,0,144,5,0,62,1,224,30,0,47,193,224,45,0,7,193,224,63,255,0,127,255,191,255,0,127,255,244,0,0,7,64,240,0,252,7,64,255,253,127,75,64,63,254,11,11,255,0,60,0,11,255,0,244,0,11,15,2,224,0,15,15,2,192,6,15,15,191,255,11,79,15,191,255,15,30,14,2,192,30,45,14,2,192,45,60,14,2,192,60,120,30,2,192,120,244,45,2,192,181,227,252,63,192,16,65,228,62,64,
  // 0x6e90  源
  144,110,20,21,105,22,1,253,46,0,0,0,0,47,203,255,255,255,3,219,255,255,255,0,139,64,61,0,0,11,64,60,0,0,11,111,255,252,116,11,110,170,188,191,11,109,0,60,31,75,111,255,252,1,11,110,85,124,0,11,109,0,60,0,15,46,85,124,2,79,47,255,252,3,207,0,60,0,11,159,13,60,116,15,45,45,60,124,30,60,60,60,61,61,60,244,60,31,124,184,224,60,15,116,240,3,252,0,0,16,2,160,0,
  // 0x6ea2  溢
  162,110,20,21,105,22,1,253,46,0,7,255,0,31,192,247,255,128,3,194,224,3,208,0,7,192,1,244,0,31,191,255,190,0,13,42,170,28,184,0,0,0,0,191,64,6,170,64,15,0,251,255,128,0,2,240,3,208,0,7,208,1,240,0,31,128,0,189,2,127,170,170,191,7,203,255,255,244,11,67,138,44,176,15,3,138,44,176,46,3,138,44,176,61,3,138,44,176,124,63,255,255,255,52,63,255,255,255,0,0,0,0,0,
  // 0x6ed1  滑
  209,110,20,21,105,22,1,253,30,0,170,170,144,31,208,255,255,224,1,224,224,0,224,0,0,225,255,224,0,0,225,229,224,0,0,225,208,224,184,10,250,234,250,191,79,255,255,255,11,142,0,0,15,0,15,255,255,239,0,0,255,255,224,0,64,224,0,224,0,208,250,170,224,2,224,255,255,224,3,192,224,0,224,11,128,245,86,224,15,64,255,255,224,46,0,224,0,224,60,0,224,0,224,40,0,224,47,224,0,0,144,10,64,
  // 0x6f0f  漏
  15,111,20,21,105,22,1,253,45,10,170,170,168,47,143,255,255,252,7,207,0,0,60,0,79,0,0,60,0,15,255,255,252,0,15,170,170,168,116,15,0,0,0,191,79,255,255,254,31,79,170,190,169,2,15,0,52,0,0,15,170,186,169,0,15,255,255,253,3,31,224,52,13,11,158,238,123,157,15,45,231,181,221,31,61,224,52,13,61,60,238,59,141,60,184,231,181,221,184,240,224,52,29,112,240,224,52,253,0,0,64,16,80,
  // 0x6fc0  激
  192,111,20,22,110,22,1,253,0,0,144,5,0,45,0,240,15,0,47,134,245,15,0,7,223,255,94,0,0,28,7,93,0,0,30,91,111,255,0,31,255,127,255,116,28,7,188,60,254,30,91,252,60,31,31,255,252,56,1,0,240,221,56,0,0,240,14,116,0,127,255,203,176,2,107,234,135,240,7,131,128,3,224,11,67,255,67,208,15,7,239,3,224,46,11,75,15,240,60,31,11,46,124,124,125,175,188,47,116,180,253,240,10,0,16,0,0,0,
  // 0x706f  灯
  111,112,20,22,110,22,1,253,0,80,0,0,0,1,224,0,0,0,1,224,63,255,255,1,224,63,255,255,1,225,0,11,64,57,227,192,11,64,53,231,64,11,64,53,235,0,11,64,117,238,0,11,64,177,232,0,11,64,177,208,0,11,64,2,208,0,11,64,2,208,0,11,64,3,240,0,11,64,3,252,0,11,64,7,238,0,11,64,15,79,128,11,64,31,3,64,11,64,62,0,0,15,64,252,0,11,255,64,112,0,3,254,0,0,0,0,0,0,
  // 0x70b9  点
  185,112,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,0,0,63,255,252,0,0,63,255,252,0,0,60,0,0,0,0,60,0,0,7,255,255,255,208,7,255,255,255,208,7,128,0,2,208,7,128,0,2,208,7,128,0,2,208,7,128,0,2,208,7,255,255,255,208,7,255,255,255,208,0,0,0,0,0,6,65,1,65,208,15,75,67,192,240,31,7,130,224,188,125,7,128,240,61,248,7,192,240,30,16,1,0,0,0,
  // 0x70ed  热
  237,112,20,22,110,22,1,253,0,64,1,64,0,1,208,3,192,0,1,208,3,192,0,1,208,3,192,0,191,255,191,255,208,127,255,107,251,208,1,208,3,193,208,1,208,3,193,208,1,255,23,129,208,111,255,191,129,208,255,224,47,129,208,81,208,15,245,208,1,208,46,189,231,1,208,188,20,231,63,210,244,0,255,30,64,192,0,41,1,0,0,0,80,15,71,67,193,240,31,7,130,208,184,61,7,129,240,61,248,3,192,240,47,16,1,0,64,4,
  // 0x7247  片
  71,114,19,22,110,22,1,253,0,0,2,128,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,192,3,192,0,3,255,255,255,248,3,255,255,255,248,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,7,255,255,254,0,7,255,255,254,0,11,128,0,46,0,15,64,0,46,0,31,0,0,46,0,47,0,0,46,0,125,0,0,46,0,252,0,0,46,0,180,0,0,46,0,16,0,0,25,0,
  // 0x7269  物
  105,114,20,22,110,22,1,253,0,144,5,0,0,0,224,11,0,0,56,224,15,0,0,56,224,30,0,0,116,224,47,255,255,127,254,63,255,255,191,254,184,242,223,240,224,240,227,207,224,227,226,211,142,208,225,195,199,78,0,225,7,75,30,0,255,15,15,30,31,254,46,29,29,255,240,124,60,45,164,225,244,120,45,0,224,208,240,44,0,224,2,224,60,0,224,7,192,60,0,224,31,64,120,0,224,62,31,244,0,224,8,15,224,0,144,0,0,0,
  // 0x7279  特
  121,114,20,22,110,22,1,253,0,80,0,20,0,0,224,0,60,0,56,224,0,60,0,56,224,127,255,252,116,224,127,255,252,127,254,0,60,0,191,254,0,60,0,240,226,255,255,255,224,226,255,255,255,144,224,0,2,208,0,225,0,2,208,6,255,0,2,208,255,245,255,255,255,250,224,255,255,255,0,224,24,2,208,0,224,62,2,208,0,224,15,66,208,0,224,3,130,208,0,224,0,2,208,0,224,0,191,208,0,224,0,127,128,0,0,0,0,0,
  // 0x7387  率
  135,115,20,21,105,22,1,253,0,0,60,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,0,0,240,0,16,45,2,194,128,248,31,223,71,195,224,3,219,223,11,64,0,1,253,64,0,0,80,242,219,64,7,242,229,251,224,191,191,255,248,253,116,26,104,44,44,0,0,60,0,0,191,255,255,255,254,191,255,255,255,255,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,40,0,0,
  // 0x73af  环
  175,115,20,20,100,22,1,253,255,249,255,255,255,255,249,255,255,254,11,64,0,124,0,11,64,0,244,0,11,64,1,240,0,11,64,3,245,0,191,240,7,255,64,191,240,15,247,208,11,64,62,241,240,11,64,188,240,188,11,66,244,240,61,11,67,224,240,29,11,64,128,240,4,11,248,0,240,0,111,244,0,240,0,255,64,0,240,0,160,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,80,0,
  // 0x7528  用
  40,117,19,20,100,22,1,253,11,255,255,255,248,11,255,255,255,248,11,64,60,0,120,11,64,60,0,120,11,64,60,0,120,11,255,255,255,248,11,255,255,255,248,11,64,60,0,120,11,64,60,0,120,11,64,60,0,120,11,64,60,0,120,15,255,255,255,248,15,255,255,255,248,15,0,60,0,120,30,0,60,0,120,61,0,60,0,120,124,0,60,0,184,248,0,60,63,244,176,0,60,63,224,0,0,0,0,0,
  // 0x7535  电
  53,117,19,22,110,22,2,253,0,0,80,0,0,0,1,240,0,0,0,1,240,0,0,0,1,240,0,0,127,255,255,255,192,127,255,255,255,192,124,1,240,3,192,124,1,240,3,192,124,1,240,3,192,127,255,255,255,192,127,255,255,255,192,124,1,240,3,192,124,1,240,3,192,127,255,255,255,192,127,255,255,255,192,124,1,240,0,32,36,1,240,0,60,0,0,240,0,60,0,0,240,0,188,0,0,255,255,244,0,0,127,255,224,0,0,0,0,0,
  // 0x7565  略
  101,117,21,22,132,22,1,253,0,0,0,64,0,0,0,0,1,240,0,0,127,255,3,208,0,0,127,255,7,255,252,0,113,203,15,234,252,0,113,203,63,64,240,0,113,203,255,194,224,0,113,203,241,247,192,0,127,239,0,191,0,0,127,255,0,127,0,0,113,203,2,255,208,0,113,203,31,194,253,0,113,203,254,0,127,64,113,203,255,255,253,0,113,203,47,255,252,0,127,255,29,0,60,0,127,255,29,0,60,0,112,0,29,0,60,0,112,0,29,0,60,0,0,0,31,255,252,0,0,0,31,255,252,0,0,0,8,0,20,0,
  // 0x767d  白
  125,118,16,22,88,22,3,253,0,5,64,0,0,15,192,0,0,15,64,0,0,31,0,0,255,255,255,255,255,255,255,255,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,255,255,255,255,255,255,255,255,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,240,0,0,15,255,255,255,255,255,255,255,255,240,0,0,15,160,0,0,5,
  // 0x7684  的
  132,118,19,22,110,22,2,253,1,64,1,0,0,3,192,7,192,0,7,192,11,128,0,11,64,15,0,0,255,254,31,255,244,255,254,47,255,244,224,14,60,0,180,224,14,184,0,180,224,15,240,0,180,224,14,22,0,180,255,254,11,128,176,255,254,3,208,176,224,14,1,240,240,224,14,0,244,240,224,14,0,116,240,224,14,0,0,240,224,14,0,0,240,255,254,0,1,224,255,254,0,2,224,224,0,2,255,192,224,0,1,255,64,0,0,0,0,0,
  // 0x76d1  监
  209,118,20,21,105,22,1,254,0,5,0,0,0,9,15,0,240,0,30,15,0,240,0,30,15,1,224,0,30,15,3,255,254,30,15,3,255,254,30,15,11,64,0,30,15,31,28,0,30,15,61,47,64,30,15,60,11,208,30,15,0,1,244,0,14,0,0,96,0,0,0,0,0,11,255,255,255,224,11,235,235,251,224,11,67,194,193,224,11,67,194,193,224,11,67,194,193,224,11,67,194,193,224,255,255,255,255,255,255,255,255,255,255,
  // 0x76f4  直
  244,118,20,22,110,22,1,253,0,0,41,0,0,0,0,61,0,0,191,255,255,255,254,191,255,255,255,254,0,0,60,0,0,0,0,60,0,0,4,31,255,255,208,29,31,85,87,208,29,30,0,2,208,29,31,255,255,208,29,31,85,87,208,29,30,0,2,208,29,31,255,255,208,29,31,85,87,208,29,30,0,2,208,29,31,255,255,208,29,5,85,85,64,29,0,0,0,0,31,255,255,255,255,31,255,255,255,255,29,0,0,0,0,4,0,0,0,0,
  // 0x7701  省
  1,119,20,22,110,22,1,253,0,0,40,0,0,0,0,60,1,0,0,244,60,15,128,3,240,60,7,224,11,192,60,0,252,63,0,60,46,62,124,15,252,188,12,0,11,171,240,0,0,1,191,128,0,0,111,248,0,0,191,255,255,255,192,127,250,170,171,192,0,176,0,3,192,0,191,255,255,192,0,185,85,87,192,0,176,0,3,192,0,191,255,255,192,0,185,85,87,192,0,176,0,3,192,0,191,255,255,192,0,186,170,171,192,0,80,0,1,64,
  // 0x7720  眠
  32,119,21,20,120,22,1,254,0,0,63,255,253,0,127,252,63,255,253,0,127,252,56,0,45,0,120,60,56,0,45,0,120,60,56,0,45,0,126,188,63,255,253,0,127,252,63,255,253,0,120,60,56,30,0,0,120,60,56,14,0,0,120,60,56,14,0,0,127,252,63,255,255,0,126,188,63,255,255,0,120,60,56,15,0,0,120,60,56,11,64,0,120,60,56,7,64,0,127,252,56,3,130,0,127,252,56,23,195,64,120,1,191,250,231,64,100,3,255,228,255,0,0,2,144,0,61,0,
  // 0x786e  确
  110,120,20,22,110,22,1,253,0,0,1,64,0,0,0,3,192,0,255,255,75,234,64,255,255,79,255,192,7,128,30,11,128,11,64,60,15,0,15,0,254,191,169,15,0,255,255,253,31,254,60,44,45,47,254,60,44,45,62,14,62,190,189,126,14,63,255,253,254,14,60,44,45,254,14,60,44,45,174,14,62,191,189,30,14,63,255,253,14,14,120,0,45,15,254,180,0,45,15,254,240,0,45,14,1,240,0,45,9,3,192,3,252,0,0,128,3,244,
  // 0x79bb  离
  187,121,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,170,170,254,170,170,191,255,255,255,254,0,0,1,128,0,3,199,215,131,192,3,193,255,3,192,3,199,255,211,192,3,207,65,195,192,3,234,170,171,192,3,255,255,255,192,0,0,244,0,0,0,0,240,0,0,31,255,255,255,244,31,171,250,250,244,30,2,208,224,180,30,3,213,244,180,30,191,255,252,180,30,106,84,29,180,30,0,0,0,180,30,0,0,31,244,5,0,0,11,144,
  // 0x79fb  移
  251,121,20,22,110,22,1,253,0,0,0,20,0,1,189,0,244,0,191,253,2,250,164,187,208,11,255,252,2,208,127,0,244,2,209,255,130,240,2,208,147,231,192,255,255,0,191,64,255,255,1,253,0,3,208,31,253,0,7,240,255,125,0,15,252,100,190,169,31,239,2,255,255,62,219,15,192,61,182,209,191,208,124,242,208,181,249,244,210,208,0,63,208,2,208,0,47,64,2,208,2,253,0,2,208,191,224,0,2,208,254,0,0,1,128,64,0,0,
  // 0x7a7a  空
  122,122,20,21,105,22,1,254,0,0,20,0,0,0,0,60,0,0,0,0,60,0,0,63,255,255,255,253,63,255,255,255,253,60,11,66,208,61,60,15,66,208,61,36,31,2,208,0,0,125,2,208,44,6,248,2,250,252,63,224,0,255,244,46,0,0,0,0,0,0,0,0,0,7,255,255,255,224,3,255,255,255,224,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,191,255,255,255,254,127,255,255,255,253,
  // 0x7aef  端
  239,122,20,22,110,22,1,253,0,0,0,36,0,3,128,80,120,4,3,128,240,120,45,3,128,240,120,45,3,128,240,120,45,255,252,255,255,253,191,252,255,255,253,0,16,0,0,0,112,120,0,0,0,52,118,255,255,255,56,118,255,255,255,56,176,0,244,0,60,240,170,254,169,60,224,255,255,254,40,208,226,199,14,1,254,226,199,14,191,254,226,199,14,255,144,226,199,14,144,0,226,199,14,0,0,226,199,14,0,0,226,199,190,0,0,144,65,36,
  // 0x7b2c  第
  44,123,20,22,110,22,1,253,2,0,1,64,0,11,128,3,208,0,15,234,151,234,170,47,255,255,255,255,124,240,62,31,0,244,120,124,15,64,112,32,36,6,0,15,255,255,255,240,10,170,190,170,240,0,0,60,0,240,2,170,190,170,240,7,255,255,255,240,11,64,60,0,0,15,64,60,0,0,15,255,255,255,252,31,175,254,170,252,5,11,252,0,60,0,63,60,0,60,2,252,60,0,184,111,208,60,47,244,126,0,60,31,144,0,0,40,0,0,
  // 0x7b49  等
  73,123,20,22,110,22,1,253,2,64,1,64,0,11,192,3,208,0,15,234,167,234,170,47,255,255,255,255,124,180,47,31,0,244,120,60,15,64,32,16,60,5,0,6,170,190,170,160,11,255,255,255,240,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,170,170,170,191,170,0,0,0,45,0,42,170,170,191,168,63,255,255,255,253,0,116,0,45,0,0,189,0,45,0,0,47,0,45,0,0,11,128,45,0,0,2,15,252,0,0,0,11,228,0,
  // 0x7bb1  箱
  177,123,20,22,110,22,1,253,2,64,1,128,0,7,128,3,208,0,15,234,167,234,170,31,255,239,255,255,61,180,31,30,0,248,124,61,15,0,112,116,60,7,64,0,240,0,0,0,0,240,15,255,252,191,255,223,255,252,191,255,223,0,60,2,240,15,170,188,3,252,15,255,252,11,255,15,0,60,15,251,207,0,60,61,243,223,170,188,188,240,79,255,252,240,240,15,0,60,80,240,15,0,60,0,240,15,255,252,0,240,15,170,188,0,160,10,0,20,
  // 0x7c7b  类
  123,124,20,22,110,22,1,253,0,0,20,0,0,1,192,60,3,128,2,240,60,15,128,0,244,60,31,0,0,120,60,60,0,127,255,255,255,254,127,255,255,255,253,0,7,255,208,0,0,47,125,248,0,6,252,60,63,208,127,224,60,7,254,62,0,40,32,124,0,0,60,126,0,0,0,124,11,128,127,255,255,255,254,127,255,255,255,254,0,2,255,64,0,0,11,215,208,0,0,127,129,253,0,111,253,0,127,250,127,208,0,7,253,20,0,0,0,20,
  // 0x7d22  索
  34,125,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,63,255,255,255,252,63,255,255,255,252,0,0,60,0,0,0,0,60,0,0,127,255,255,255,253,126,171,250,170,189,120,3,224,0,45,120,15,128,244,45,18,253,3,240,4,1,252,31,128,0,0,47,189,45,0,0,11,240,31,128,106,191,234,171,240,127,255,255,255,252,0,32,60,0,24,0,248,60,62,0,7,224,60,15,208,127,128,60,1,252,124,0,60,0,60,0,0,40,0,0,
  // 0x7d2b  紫
  43,125,20,22,110,22,1,253,0,36,2,128,0,0,60,3,192,16,44,62,163,198,252,44,63,243,255,208,44,60,3,228,0,44,60,3,192,9,44,61,163,192,15,127,255,243,255,254,255,234,209,255,252,80,3,224,0,0,1,159,65,244,0,3,253,11,208,0,0,127,127,11,0,0,11,248,11,192,170,175,250,171,244,255,255,255,255,253,0,0,60,0,46,0,180,60,46,0,7,240,60,31,208,47,128,60,2,248,125,0,60,0,125,0,0,40,0,0,
  // 0x7ea2  红
  162,126,20,20,100,22,1,254,0,240,0,0,0,2,224,0,0,0,3,208,191,255,254,11,192,191,255,254,15,0,0,60,0,46,15,0,60,0,124,47,0,60,0,255,252,0,60,0,255,244,0,60,0,3,224,0,60,0,11,192,0,60,0,47,5,0,60,0,191,255,0,60,0,255,229,0,60,0,80,0,0,60,0,0,0,0,60,0,1,190,0,60,0,255,254,255,255,255,254,64,255,255,255,64,0,0,0,0,
  // 0x7ea7  级
  167,126,20,22,110,22,1,253,0,64,0,0,0,1,224,0,0,0,3,208,255,255,208,7,192,255,255,192,11,64,15,3,192,31,8,15,7,128,60,46,15,11,64,184,124,15,15,0,255,244,15,15,253,251,224,31,31,252,3,192,31,128,60,15,68,47,192,120,47,189,47,208,244,191,248,60,241,240,254,0,60,187,208,80,5,184,63,192,0,126,244,31,64,27,254,240,63,192,255,131,225,251,244,180,7,219,224,254,0,11,143,128,46,0,1,0,0,0,
  // 0x7ebf  线
  191,126,20,21,105,22,1,254,0,64,0,144,0,1,240,1,243,128,2,224,1,242,244,3,192,0,240,96,11,128,0,241,168,15,8,27,255,252,45,31,127,250,64,125,124,20,240,0,255,248,0,240,21,102,240,0,255,254,3,192,191,255,228,11,64,255,248,4,47,174,0,120,46,191,253,0,60,124,126,64,0,62,240,0,0,0,47,192,0,110,0,127,0,31,254,2,255,7,191,144,127,219,203,96,1,253,3,254,0,0,80,0,188,
  // 0x7ec6  细
  198,126,20,22,110,22,1,253,0,64,0,0,0,0,240,0,0,0,1,240,191,255,253,3,208,191,255,253,7,192,180,60,45,15,0,180,60,45,46,10,180,60,45,124,31,180,60,45,255,252,180,60,45,254,244,180,60,45,2,224,191,255,253,11,192,191,255,253,31,86,180,60,45,191,255,180,60,45,255,229,180,60,45,80,0,180,60,45,0,0,180,60,45,0,107,180,60,45,191,255,191,255,253,255,144,191,255,253,64,0,180,0,45,0,0,0,0,0,
  // 0x7ec8  终
  200,126,20,22,110,22,1,253,0,0,0,64,0,2,224,3,224,0,3,208,7,192,0,7,192,15,255,248,15,64,47,255,248,31,4,191,1,240,61,46,251,195,208,120,62,210,239,128,255,248,0,255,0,255,240,1,255,0,3,192,11,239,224,15,64,191,66,254,46,21,248,0,127,191,253,65,248,4,255,228,0,191,64,80,0,0,11,128,0,0,4,0,0,1,191,47,144,0,255,254,11,254,0,254,64,0,47,224,0,0,0,1,240,0,0,0,0,0,
  // 0x7ed3  结
  211,126,20,22,110,22,1,253,0,64,0,40,0,2,224,0,60,0,3,208,0,60,0,11,192,255,255,254,15,64,255,255,254,46,13,0,60,0,60,47,0,60,0,188,125,0,60,0,255,252,0,60,0,255,240,127,255,253,3,208,127,255,253,11,128,0,0,0,47,90,0,0,0,255,255,63,255,252,255,164,63,255,252,80,0,60,0,60,0,0,60,0,60,0,91,60,0,60,111,255,60,0,60,255,228,63,255,252,144,0,63,255,252,0,0,40,0,40,
  // 0x7ed9  给
  217,126,20,22,110,22,1,253,0,0,0,16,0,2,224,0,184,0,3,208,0,252,0,7,192,2,253,0,15,64,3,223,0,31,8,15,139,192,61,46,47,3,224,188,124,188,0,252,255,250,255,255,255,251,241,223,255,204,3,192,0,0,0,15,64,0,0,0,47,25,63,255,224,191,253,63,255,240,254,144,60,0,240,0,0,60,0,240,0,5,60,0,240,26,254,60,0,240,255,228,63,255,240,164,0,63,255,240,0,0,60,0,240,0,0,20,0,80,
  // 0x7edf  统
  223,126,20,22,110,22,1,253,0,64,0,16,0,2,224,0,244,0,3,224,0,184,0,7,192,0,56,0,11,128,255,255,255,15,4,255,255,254,61,46,3,224,0,124,124,11,194,208,255,248,31,0,240,255,240,126,90,248,3,209,255,255,253,15,128,234,84,30,47,108,15,15,4,191,252,15,15,0,255,144,15,15,0,80,0,30,15,0,0,28,45,15,5,11,253,60,15,11,255,224,248,15,15,248,7,240,15,238,0,7,192,7,252,0,1,0,0,0,
  // 0x7ee7  继
  231,126,20,21,105,22,1,254,1,0,0,5,0,3,208,160,15,0,3,192,243,15,29,7,128,243,143,44,15,0,242,207,56,30,4,241,207,112,60,45,240,79,16,120,60,246,175,170,255,244,251,255,255,255,240,240,47,64,3,192,240,63,192,11,64,240,191,240,30,20,240,239,120,127,252,243,207,45,255,228,247,143,14,100,0,243,15,4,0,0,240,15,0,1,189,240,15,0,191,253,240,0,0,254,64,255,255,255,64,0,255,255,255,
  // 0x7eea  绪
  234,126,20,22,110,22,1,253,0,0,0,144,0,2,208,0,224,0,3,192,0,224,45,7,128,191,255,188,15,0,127,255,244,30,8,0,226,240,60,45,0,231,192,185,190,255,255,255,255,246,255,255,255,166,224,1,248,0,3,192,11,224,0,15,0,47,234,168,46,106,255,255,252,191,255,254,0,60,190,64,78,0,60,0,0,15,255,252,0,5,15,170,188,6,254,14,0,60,191,253,14,0,60,254,64,15,255,252,0,0,15,170,188,0,0,9,0,20,
  // 0x7eed  续
  237,126,20,22,110,22,1,253,0,0,0,100,0,1,208,0,180,0,3,192,106,254,164,7,128,127,255,244,11,64,0,180,0,14,20,0,180,0,44,61,255,255,253,120,120,170,170,189,255,240,4,20,60,255,224,31,60,56,3,192,67,188,36,11,0,244,60,0,31,184,44,60,0,127,248,4,60,0,254,66,255,255,254,80,1,255,255,253,0,108,1,241,0,27,248,3,219,128,255,128,31,130,240,244,0,190,0,124,0,2,244,0,30,0,0,64,0,4,
  // 0x7eff  绿
  255,126,20,22,110,22,1,253,1,0,0,0,0,3,208,42,170,180,3,192,127,255,248,11,128,0,0,120,15,0,0,0,120,30,0,63,255,244,60,60,42,170,244,120,120,0,0,180,255,240,255,255,255,255,224,255,255,255,3,192,0,60,0,15,0,112,60,8,46,20,124,60,61,127,252,31,60,244,255,228,9,191,192,100,0,3,255,128,0,4,31,191,224,1,252,253,60,248,191,246,240,60,63,254,0,128,60,10,80,0,3,248,0,0,0,2,160,0,
  // 0x7f16  编
  22,127,20,22,110,22,1,253,1,0,0,16,0,3,208,0,184,0,3,192,0,124,0,11,128,255,255,252,15,0,250,170,188,30,16,240,0,44,44,60,240,0,44,120,184,255,255,252,255,240,250,170,168,255,208,240,0,0,3,192,250,170,169,15,0,255,255,253,46,100,252,114,141,127,245,252,114,141,255,145,236,114,141,80,2,239,255,253,0,119,222,187,237,27,251,220,114,141,255,75,156,114,141,244,15,28,114,141,0,10,28,114,189,0,0,4,0,20,
  // 0x7f3a  缺
  58,127,20,22,110,22,1,253,20,0,0,36,0,45,0,0,120,0,60,0,0,120,0,63,255,128,120,0,127,255,223,255,248,181,224,31,255,248,241,224,0,120,120,97,224,0,120,120,255,255,192,120,120,255,255,192,120,120,1,224,0,120,120,1,227,239,255,255,113,227,239,255,255,113,227,192,190,0,113,227,192,255,0,113,227,193,231,128,127,255,195,211,208,127,255,207,193,240,112,3,239,0,252,112,1,253,0,63,0,0,180,0,30,0,0,0,0,0,
  // 0x7f51  网
  81,127,18,19,95,22,2,254,255,255,255,255,240,255,255,255,255,240,240,30,2,208,240,240,30,2,192,240,240,29,2,192,240,242,29,51,192,240,247,237,127,192,240,242,252,31,192,240,240,188,7,192,240,240,63,3,240,240,240,63,139,248,240,240,183,207,60,240,240,240,79,8,240,241,240,30,0,240,243,208,60,0,240,247,192,184,0,240,242,0,48,0,240,240,0,0,63,240,240,0,0,47,208,
  // 0x7f6e  置
  110,127,20,21,105,22,1,253,5,85,85,85,84,31,255,255,255,248,29,7,65,208,120,30,91,150,229,184,31,255,255,255,248,0,0,60,0,0,106,170,190,170,169,127,255,255,255,253,0,0,60,0,0,10,31,255,255,240,31,30,0,1,240,31,31,255,255,240,31,30,0,1,240,31,30,0,1,240,31,31,255,255,240,31,30,0,1,240,31,31,255,255,240,31,0,0,0,0,31,255,255,255,255,31,170,170,170,170,9,0,0,0,0,
  // 0x7f72  署
  114,127,20,21,105,22,1,253,5,85,85,85,84,31,255,255,255,248,29,7,65,208,120,30,91,150,229,184,31,255,255,255,248,0,0,180,0,0,6,170,250,168,180,7,255,255,255,240,0,0,180,15,192,0,0,180,127,0,191,255,255,255,254,106,170,255,234,169,0,11,254,85,80,1,255,255,255,240,191,248,0,0,240,189,125,85,85,240,0,63,255,255,240,0,56,0,0,240,0,61,85,86,240,0,63,255,255,240,0,36,0,0,144,
  // 0x8005  者
  5,128,20,22,110,22,1,253,0,0,64,0,0,0,1,224,0,32,0,1,224,0,248,11,255,255,250,240,15,255,255,255,192,0,1,224,47,64,0,1,224,189,0,0,1,226,244,0,191,255,255,255,254,191,255,255,255,254,0,2,248,0,0,0,47,208,0,0,2,255,255,255,192,111,254,170,171,192,254,120,0,3,192,16,126,170,171,192,0,127,255,255,192,0,120,0,3,192,0,120,0,3,192,0,127,255,255,192,0,126,170,171,192,0,20,0,1,64,
  // 0x806a  聪
  106,128,20,22,110,22,1,253,0,0,0,0,64,191,255,15,0,240,255,255,11,129,224,60,44,3,195,192,60,44,2,131,128,60,44,63,255,252,62,188,62,170,188,63,252,60,0,60,60,44,60,0,60,60,44,60,0,60,60,44,62,170,188,63,252,63,255,252,62,188,0,32,0,60,44,0,56,0,60,44,19,157,20,61,127,119,143,60,191,254,183,129,29,254,124,179,128,158,64,44,227,128,235,0,45,211,234,209,0,44,2,255,192,0,24,0,0,0,
  // 0x80fd  能
  253,128,20,22,110,22,1,253,1,64,1,64,0,3,208,3,192,0,7,199,3,192,32,15,71,195,198,248,15,3,211,255,208,255,255,243,248,0,255,255,247,192,4,0,0,99,192,15,42,170,131,208,15,63,255,194,255,254,60,3,192,191,248,60,3,195,192,0,63,255,195,192,36,62,171,195,194,252,60,3,195,255,208,62,171,195,249,0,63,255,195,192,4,60,3,195,192,11,60,3,195,192,15,60,3,195,255,255,60,63,192,255,252,44,46,64,0,0,
  // 0x81ea  自
  234,129,16,22,88,22,3,253,0,1,0,0,0,7,192,0,0,11,128,0,0,15,64,0,191,255,255,255,191,255,255,255,184,0,0,31,184,0,0,31,191,255,255,255,191,255,255,255,184,0,0,31,184,0,0,31,184,0,0,31,191,255,255,255,191,255,255,255,184,0,0,31,184,0,0,31,184,0,0,31,191,255,255,255,191,255,255,255,184,0,0,31,16,0,0,5,
  // 0x81f3  至
  243,129,20,19,95,22,1,254,63,255,255,255,253,63,255,255,255,253,0,15,128,32,0,0,31,0,189,0,0,61,0,31,128,0,126,170,191,224,63,255,255,255,252,63,169,85,0,61,0,0,20,0,16,0,0,60,0,0,0,0,60,0,0,15,255,255,255,240,11,255,255,255,240,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,0,0,255,255,255,255,255,191,255,255,255,255,
  // 0x83dc  菜
  220,131,20,22,110,22,1,253,0,24,0,36,0,0,45,0,120,0,191,255,255,255,254,191,255,255,255,254,0,45,0,120,0,0,20,5,175,208,47,255,255,255,224,47,254,169,80,0,1,0,176,0,244,15,64,180,1,240,7,192,124,3,208,3,208,56,7,128,1,128,60,7,0,0,0,60,0,0,191,255,255,255,254,191,255,255,255,254,0,11,255,224,0,0,127,60,253,0,11,248,60,47,224,255,128,60,2,255,120,0,60,0,44,0,0,40,0,0,
  // 0x84dd  蓝
  221,132,20,21,105,22,1,254,0,24,0,36,0,0,60,0,60,0,191,255,255,255,254,106,191,170,254,170,0,60,0,60,0,0,0,1,144,0,4,15,3,208,0,15,15,3,255,252,15,15,11,234,168,15,15,15,29,0,15,15,62,15,0,15,15,44,7,128,15,15,0,3,192,0,9,0,1,0,11,255,255,255,224,11,171,235,234,224,11,67,130,193,224,11,67,130,193,224,11,67,130,193,224,175,239,235,251,250,255,255,255,255,255,
  // 0x86c7  蛇
  199,134,20,21,105,22,1,254,0,0,0,20,0,2,192,0,60,0,2,192,0,60,0,2,192,0,60,0,2,192,63,255,255,127,255,127,255,255,123,239,120,0,15,113,199,126,0,15,113,199,11,64,0,113,199,11,64,48,113,199,11,66,252,123,239,11,95,224,127,255,11,254,0,114,192,11,208,0,2,198,11,64,0,2,203,11,64,0,2,195,75,64,9,2,239,203,64,15,255,255,203,64,15,254,81,199,255,253,0,0,2,255,248,
  // 0x884c  行
  76,136,20,21,105,22,1,253,0,244,0,0,0,2,240,127,255,253,11,192,127,255,253,63,0,0,0,0,252,16,0,0,0,96,61,0,0,0,0,248,0,0,0,2,240,255,255,255,11,208,255,255,255,47,192,0,7,192,191,192,0,7,192,247,192,0,7,192,83,192,0,7,192,3,192,0,7,192,3,192,0,7,192,3,192,0,7,192,3,192,0,7,192,3,192,0,7,192,3,192,3,255,128,3,192,2,254,0,0,0,0,0,0,
  // 0x88ab  被
  171,136,20,22,110,22,1,253,1,64,0,20,0,3,192,0,44,0,3,192,0,44,0,3,192,0,44,0,3,192,127,255,255,255,253,127,255,255,255,253,120,44,30,0,60,120,44,44,0,240,120,44,24,2,231,191,255,248,7,238,127,255,252,31,252,127,128,120,191,252,183,192,244,247,206,182,208,240,147,200,241,243,208,3,192,240,191,192,3,192,240,63,64,3,194,224,127,128,3,195,194,255,240,3,199,223,225,254,3,203,95,64,62,2,64,4,0,4,
  // 0x88c5  装
  197,136,20,22,110,22,1,253,0,36,0,36,0,0,56,0,120,0,124,56,0,120,0,47,121,255,255,254,10,121,255,255,255,0,56,0,120,0,1,120,0,120,0,47,248,0,120,0,253,120,191,255,252,144,56,191,255,252,0,56,20,0,0,0,0,60,0,0,106,170,190,170,169,255,255,255,255,255,0,11,223,0,96,1,190,7,194,244,111,252,2,255,128,189,60,0,253,0,0,60,89,63,128,6,255,254,11,249,7,254,144,0,190,1,0,0,0,4,
  // 0x8981  要
  129,137,20,21,105,22,1,253,127,255,255,255,253,127,255,255,255,253,0,11,66,208,0,0,11,66,208,0,31,255,255,255,248,31,175,235,250,248,29,11,66,208,120,29,11,66,208,120,31,175,235,250,248,31,255,255,255,248,0,3,192,0,0,0,11,128,0,0,255,255,255,255,255,170,191,170,191,170,0,188,0,60,0,1,249,0,248,0,3,255,251,240,0,0,70,255,244,0,1,111,254,255,208,127,255,144,27,252,42,80,0,0,100,
  // 0x89d2  角
  210,137,18,22,110,22,1,253,0,4,0,0,0,0,31,0,0,0,0,63,255,240,0,0,190,171,240,0,1,240,3,208,0,7,224,7,192,0,31,255,255,255,240,127,255,255,255,240,59,192,30,0,240,3,192,30,0,240,3,250,191,170,240,3,255,255,255,240,3,192,30,0,240,3,192,30,0,240,3,192,30,0,240,3,255,255,255,240,7,255,255,255,240,15,0,0,0,240,31,0,0,0,240,125,0,0,0,240,248,0,0,255,240,96,0,0,191,128,
  // 0x8ba1  计
  161,139,20,22,110,22,1,253,0,0,0,20,0,7,0,0,120,0,11,192,0,120,0,2,240,0,120,0,0,180,0,120,0,0,16,0,120,0,0,0,0,120,0,0,0,0,124,0,255,211,255,255,255,255,211,255,255,255,2,208,0,120,0,2,208,0,120,0,2,208,0,120,0,2,208,0,120,0,2,208,0,120,0,2,209,0,120,0,2,239,64,120,0,2,255,0,120,0,3,248,0,120,0,11,208,0,120,0,3,0,0,120,0,0,0,0,36,0,
  // 0x8bae  议
  174,139,20,21,105,22,1,253,8,0,2,192,0,31,1,131,208,56,11,131,193,224,124,3,210,208,240,120,1,129,224,180,180,0,0,240,96,244,0,0,240,0,240,255,192,180,1,224,255,192,120,2,208,3,192,60,3,192,3,192,46,11,128,3,192,15,15,64,3,192,11,175,0,3,192,3,252,0,3,192,2,248,0,3,206,3,252,0,3,254,15,255,64,7,244,127,15,224,15,199,248,2,254,6,15,208,0,127,0,2,0,0,4,
  // 0x8bbe  设
  190,139,20,21,105,22,1,253,14,0,31,255,192,15,192,31,255,192,3,224,29,3,192,0,240,29,3,192,0,0,45,3,192,0,0,124,3,192,255,193,244,3,234,255,199,224,1,255,3,193,64,0,0,3,194,255,255,244,3,194,255,255,244,3,192,180,0,240,3,192,60,2,224,3,192,46,7,192,3,201,15,143,64,3,254,3,254,0,7,248,3,252,0,11,224,47,255,128,15,71,254,11,254,5,7,228,1,190,0,1,0,0,4,
  // 0x8bd5  试
  213,139,20,21,105,22,1,253,4,0,0,30,96,15,64,0,30,120,7,208,0,30,45,1,240,0,30,8,0,71,255,255,255,0,7,255,255,255,85,64,0,15,0,255,192,0,15,0,107,192,0,15,0,3,194,255,207,0,3,194,255,207,0,3,192,45,15,0,3,192,45,11,64,3,192,45,11,64,3,192,45,7,128,3,205,45,103,199,3,254,127,243,203,7,247,255,131,223,15,194,208,1,254,6,0,0,0,253,0,0,0,0,36,
  // 0x8bef  误
  239,139,20,21,105,22,1,253,29,0,170,170,168,31,128,191,255,248,7,208,176,0,120,1,224,176,0,120,0,128,176,0,120,0,0,191,255,248,255,192,191,255,248,255,192,0,0,0,3,192,0,0,0,3,193,255,255,252,3,192,255,255,252,3,192,0,180,0,3,192,0,176,0,3,195,255,255,255,3,195,255,255,255,3,200,2,252,0,3,253,7,223,0,7,244,31,75,208,11,193,254,2,253,2,3,244,0,126,0,1,64,0,4,
  // 0x8bf7  请
  247,139,20,22,110,22,1,253,0,0,0,96,0,29,0,0,180,0,31,66,255,255,253,7,209,170,250,168,2,224,0,180,0,0,64,255,255,248,0,0,85,249,84,0,0,0,180,0,255,199,255,255,255,255,194,170,170,170,3,192,106,170,160,3,192,191,255,244,3,192,176,0,180,3,192,181,85,180,3,192,191,255,244,3,196,176,0,180,3,237,185,85,180,3,252,191,255,244,7,240,176,0,180,15,192,176,0,180,11,0,176,15,244,0,0,176,10,144,
  // 0x8bfb  读
  251,139,20,22,110,22,1,253,0,0,0,96,0,13,0,0,240,0,31,64,170,254,164,7,208,255,255,248,1,224,0,240,0,0,64,0,240,0,0,3,255,255,253,0,2,170,170,189,255,192,16,0,60,255,192,61,56,56,3,192,15,184,36,3,194,210,120,0,3,192,248,120,0,3,192,44,120,0,3,199,255,255,254,3,203,255,255,254,3,236,2,225,0,3,252,11,207,128,7,240,47,66,240,15,130,253,0,189,10,7,224,0,31,0,2,0,0,4,
  // 0x8c03  调
  3,140,20,21,105,22,1,253,29,2,255,255,252,31,66,255,255,253,7,210,192,16,45,1,226,192,176,45,0,66,197,249,45,0,2,203,255,109,0,2,192,176,45,255,194,192,176,45,255,194,207,255,237,3,194,202,170,109,3,194,192,0,45,3,194,197,85,45,3,195,203,255,45,3,195,203,7,45,3,195,203,7,45,3,239,139,91,45,7,255,75,255,45,11,235,11,0,45,15,143,0,0,45,14,45,0,3,252,0,8,0,2,228,
  // 0x8d25  败
  37,141,20,22,110,22,1,253,0,0,0,80,0,63,255,192,176,0,63,255,192,240,0,56,2,193,224,0,56,82,194,255,254,56,242,195,255,255,56,242,199,128,116,56,242,203,64,176,56,242,223,64,240,56,242,239,128,240,56,242,207,192,224,56,242,193,209,208,56,242,192,243,192,56,226,192,183,192,57,210,192,63,64,18,208,0,47,0,3,221,0,47,64,11,79,0,191,192,15,7,129,242,244,125,3,219,208,190,244,1,143,0,30,0,0,0,0,0,
  // 0x8d2a  贪
  42,141,20,22,110,22,1,253,0,0,4,0,0,0,0,126,0,0,0,2,255,128,0,0,47,211,248,0,6,254,116,127,228,191,224,125,11,255,189,0,30,0,109,19,255,255,255,64,2,170,170,191,0,0,0,0,125,0,0,0,0,244,0,3,255,255,255,192,3,255,255,255,192,3,192,20,3,192,3,192,60,3,192,3,192,60,3,192,3,192,184,3,192,2,129,246,130,128,0,27,211,254,0,6,255,64,111,244,63,228,0,1,252,9,0,0,0,16,
  // 0x8d77  起
  119,141,21,21,126,22,0,253,0,60,0,255,254,0,0,60,0,255,255,0,31,255,244,0,15,0,31,255,244,0,15,0,0,60,0,0,15,0,0,60,0,0,15,0,47,255,252,170,175,0,63,255,252,255,255,0,0,29,0,240,10,0,0,29,0,240,0,0,15,29,0,240,0,0,15,31,248,240,0,0,15,31,252,240,2,192,15,29,0,240,3,192,15,93,0,240,3,192,31,221,0,255,255,128,31,253,0,47,254,0,45,254,64,0,0,0,60,47,255,255,255,192,124,1,191,255,255,128,20,0,0,0,0,0,
  // 0x8d85  超
  133,141,20,22,110,22,1,253,0,144,0,0,0,0,240,10,170,169,0,240,15,255,253,127,255,192,180,45,127,255,192,240,45,0,240,0,240,60,0,240,3,224,60,191,255,235,198,252,255,255,255,71,244,0,176,8,0,0,0,176,6,170,168,60,176,7,255,252,60,176,7,64,60,60,191,215,64,60,60,191,215,64,60,61,176,7,234,188,127,240,7,255,252,123,240,0,0,0,178,249,0,0,0,240,191,255,255,255,224,6,255,255,254,0,0,0,0,0,
  // 0x8ddd  距
  221,141,20,21,105,22,1,253,63,255,79,255,254,63,255,95,255,255,56,11,94,0,0,56,11,94,0,0,56,11,94,0,0,56,11,94,0,0,63,255,95,255,252,63,255,95,255,252,0,224,30,0,60,16,224,30,0,60,56,224,30,0,60,56,255,158,0,60,56,255,159,255,252,56,224,31,255,252,56,224,30,0,0,56,241,158,0,0,62,255,222,0,0,255,249,31,255,255,249,0,31,255,255,0,0,30,0,0,0,0,4,0,0,
  // 0x8f6c  转
  108,143,20,22,110,22,1,253,1,64,0,4,0,3,192,0,45,0,3,192,0,60,0,255,255,47,255,252,255,255,63,255,252,11,0,0,180,0,14,80,0,240,0,29,240,191,255,255,44,240,191,255,255,56,240,3,208,0,191,255,3,192,0,127,255,7,192,0,0,240,11,255,252,0,240,15,255,248,0,244,64,1,240,107,255,192,3,208,255,249,3,207,128,164,240,3,255,0,0,240,0,127,0,0,240,0,15,208,0,240,0,2,224,0,96,0,0,64,
  // 0x8f6f  软
  111,143,20,22,110,22,1,253,0,64,0,64,0,0,240,1,224,0,1,224,2,208,0,255,255,211,208,0,255,255,227,255,255,3,128,3,255,255,11,64,11,128,30,15,60,15,0,29,30,60,31,45,44,45,60,45,45,60,127,255,212,45,4,63,255,208,45,0,0,60,0,62,0,0,60,0,63,0,0,61,144,127,0,107,255,224,251,128,255,254,65,243,192,165,60,3,210,240,0,60,11,192,248,0,60,47,0,127,0,60,61,0,30,0,20,0,0,0,
  // 0x8f74  轴
  116,143,20,22,110,22,1,253,1,64,0,24,0,3,192,0,45,0,3,192,0,45,0,255,255,0,45,0,255,255,0,45,0,15,0,63,255,253,15,16,63,255,253,30,180,60,44,29,44,180,60,44,29,60,180,60,44,29,191,255,60,44,29,127,255,60,44,29,0,180,63,255,253,0,180,63,255,253,0,181,60,44,29,175,255,124,44,29,255,248,60,44,29,80,180,60,44,29,0,180,63,255,253,0,180,63,255,253,0,180,60,0,29,0,16,20,0,4,
  // 0x8f7d  载
  125,143,20,23,115,22,1,252,0,20,0,0,0,0,60,0,241,192,26,190,168,241,240,47,255,252,176,124,0,60,0,180,36,106,190,170,250,170,255,255,255,255,255,0,224,0,180,0,0,240,0,116,36,107,250,169,120,60,127,255,254,120,116,11,133,0,56,240,15,15,0,60,240,63,175,168,62,208,47,255,253,63,192,0,15,0,47,64,0,15,0,31,4,107,255,254,63,11,127,255,144,191,75,0,15,2,247,207,0,15,11,211,254,0,5,7,64,184,0,0,0,0,0,
  // 0x8f91  辑
  145,143,20,22,110,22,1,253,1,64,0,0,0,3,192,47,255,248,3,192,46,85,184,255,255,45,0,120,255,255,46,85,184,15,0,47,255,248,14,80,0,0,0,29,176,170,170,170,44,176,255,255,255,60,176,29,0,116,191,254,29,0,116,127,255,31,255,244,0,176,30,85,180,0,176,29,0,116,0,186,31,255,244,111,255,94,85,180,255,248,29,0,116,80,176,31,191,255,0,176,255,255,254,0,176,229,0,116,0,176,0,0,116,0,80,0,0,16,
  // 0x8f93  输
  147,143,20,22,110,22,1,253,1,0,0,16,0,11,64,0,124,0,11,0,1,253,0,255,252,7,223,64,255,252,47,3,224,29,1,252,0,254,29,3,255,255,255,45,209,90,170,144,56,208,0,0,4,116,208,255,242,77,255,252,250,243,141,191,252,224,179,141,0,208,255,243,141,0,208,250,243,141,0,252,224,179,141,91,252,250,243,141,255,224,255,243,141,81,208,224,178,77,0,208,224,176,13,0,208,224,177,189,0,208,227,241,248,0,144,146,128,0,
  // 0x8fb9  边
  185,143,21,22,132,22,0,253,0,0,0,80,0,0,15,64,0,240,0,0,7,208,0,240,0,0,1,244,0,240,0,0,0,181,255,255,255,64,0,1,255,255,255,0,0,0,1,240,15,0,0,0,2,224,15,0,63,224,2,208,15,0,63,224,3,208,15,0,1,224,3,192,15,0,1,224,7,192,15,0,1,224,15,64,15,0,1,224,31,0,31,0,1,224,61,0,30,0,1,224,252,0,62,0,1,227,240,31,252,0,2,240,192,15,244,0,31,190,64,0,0,64,125,11,255,255,255,192,40,0,127,255,255,128,0,0,0,0,0,0,
  // 0x8fc1  迁
  193,143,20,21,105,22,1,253,30,0,0,27,240,31,193,175,255,224,2,247,255,244,0,0,129,0,224,0,36,0,0,224,0,126,0,0,224,0,31,192,0,224,0,3,207,255,255,254,0,15,255,255,255,0,0,0,224,0,255,192,0,224,0,255,192,0,224,0,3,192,0,224,0,3,192,0,224,0,3,192,0,224,0,3,192,0,224,0,11,224,0,224,0,127,253,0,64,0,252,63,255,255,255,160,6,255,255,254,0,0,0,0,0,
  // 0x8fd0  运
  208,143,20,21,105,22,1,253,29,0,0,0,0,47,129,255,255,248,7,225,255,255,248,0,192,0,0,0,16,0,0,0,0,189,0,0,0,0,47,143,255,255,255,7,143,255,255,255,0,0,15,64,0,0,0,31,3,64,255,192,46,3,192,255,192,60,2,224,3,192,120,0,244,3,192,185,171,252,3,203,255,255,253,3,203,234,84,31,15,208,0,0,4,127,249,0,0,0,252,63,255,255,255,160,6,255,255,254,0,0,0,0,0,
  // 0x8fd1  近
  209,143,20,21,105,22,1,253,36,0,0,27,240,126,0,239,255,228,31,128,255,164,0,7,208,240,0,0,1,64,240,0,0,0,0,240,0,0,0,0,255,255,255,0,0,255,255,255,0,0,240,15,0,255,192,240,15,0,255,193,224,15,0,3,194,208,15,0,3,195,192,15,0,3,199,192,15,0,3,207,64,15,0,3,206,0,15,0,11,224,0,15,0,127,249,0,0,0,252,63,255,255,255,160,6,255,255,254,0,0,0,0,0,
  // 0x8fd4  返
  212,143,20,21,105,22,1,253,120,2,255,255,253,63,2,255,255,253,15,194,208,0,0,3,194,208,0,0,1,2,208,0,0,0,2,255,255,244,0,2,255,255,244,0,2,239,0,240,255,130,223,66,224,255,131,199,195,192,3,131,195,219,128,3,131,192,255,0,3,139,128,190,0,3,143,2,255,128,3,159,31,219,244,7,237,127,65,255,31,228,56,0,44,127,253,0,0,0,248,63,255,255,255,160,6,255,255,254,0,0,0,0,0,
  // 0x8fd8  还
  216,143,21,21,126,22,0,253,11,0,0,0,0,0,11,194,255,255,255,64,2,242,255,255,255,64,0,244,0,61,0,0,0,16,0,124,0,0,0,0,0,248,0,0,0,0,3,248,0,0,63,224,11,251,208,0,63,224,47,250,244,0,1,224,189,184,188,0,1,227,244,184,47,0,1,235,208,184,15,128,1,226,0,184,2,0,1,224,0,184,0,0,1,224,0,184,0,0,1,224,0,184,0,0,11,248,0,116,0,0,47,191,144,0,1,64,125,11,255,255,255,192,40,0,127,255,255,128,0,0,0,0,0,0,
  // 0x8fdb  进
  219,143,20,21,105,22,1,253,24,0,29,7,128,61,0,45,7,128,31,64,45,7,128,7,192,45,7,128,2,199,255,255,253,0,7,255,255,253,0,0,45,7,128,0,0,45,7,128,255,192,45,7,128,255,203,255,255,254,3,203,255,255,254,3,192,60,7,128,3,192,120,7,128,3,192,244,7,128,3,194,240,7,128,3,195,208,7,128,15,225,128,7,64,126,254,0,0,1,248,31,255,255,255,112,1,191,255,254,0,0,0,0,0,
  // 0x8fde  连
  222,143,20,22,110,22,1,253,0,0,4,0,0,44,0,15,64,0,47,0,15,0,0,15,143,255,255,253,3,203,255,255,253,2,64,120,16,0,0,0,240,120,0,0,1,224,120,0,255,131,255,255,248,255,131,255,255,248,7,128,0,120,0,7,128,0,120,0,7,128,0,120,0,7,143,255,255,254,7,143,255,255,254,7,128,0,120,0,7,128,0,120,0,31,208,0,120,0,190,254,64,36,5,244,47,255,255,255,160,1,255,255,254,0,0,0,0,0,
  // 0x8ff7  迷
  247,143,20,21,105,22,1,253,36,0,1,224,16,125,3,129,224,60,47,67,193,224,184,11,209,225,224,240,2,128,241,226,224,0,0,225,226,192,0,0,1,224,0,0,15,255,255,254,255,207,255,255,254,255,192,15,252,0,3,192,47,255,0,3,192,125,235,128,3,192,245,227,224,3,195,225,224,248,3,223,129,224,126,3,202,1,224,12,15,224,1,224,0,127,253,0,64,0,252,63,255,255,255,160,6,255,255,254,0,0,0,0,0,
  // 0x9000  退
  0,144,20,21,105,22,1,253,40,0,170,170,160,126,0,255,255,240,31,192,224,0,240,3,208,224,0,240,1,128,255,255,240,0,0,250,170,240,0,0,224,0,240,0,0,250,170,240,255,192,255,255,240,255,192,224,240,44,3,192,224,120,252,3,192,224,63,224,3,192,224,31,64,3,192,224,95,192,3,193,255,243,244,3,203,255,64,254,15,231,144,0,44,127,253,0,0,0,252,63,255,255,255,160,6,255,255,254,0,0,0,0,0,
  // 0x9009  选
  9,144,20,22,110,22,1,253,0,0,0,80,0,36,0,160,240,0,125,0,240,240,0,31,65,250,254,168,7,195,255,255,252,2,11,192,240,0,0,11,0,240,0,0,0,0,240,0,0,11,255,255,254,191,143,255,255,255,255,128,31,15,0,3,128,30,15,0,3,128,45,15,0,3,128,60,15,4,3,128,248,15,11,3,130,240,15,15,3,143,208,15,254,7,234,0,7,252,47,253,0,0,0,189,31,255,255,255,116,0,191,255,254,0,0,0,0,0,
  // 0x901f  速
  31,144,20,22,110,22,1,253,0,0,0,80,0,36,0,1,224,0,125,0,1,224,0,47,79,255,255,254,7,218,171,250,170,1,64,1,224,0,0,3,255,255,252,0,3,234,250,188,0,3,193,224,60,255,195,193,224,60,255,195,234,250,188,3,195,255,255,252,3,192,11,252,0,3,192,47,255,0,3,192,189,231,208,3,199,241,225,248,3,207,129,224,126,15,229,1,224,8,127,253,0,80,0,252,63,255,255,255,160,6,255,255,254,0,0,0,0,0,
  // 0x90e8  部
  232,144,20,22,110,22,1,253,0,20,0,0,0,0,120,0,0,0,0,120,0,255,254,191,255,252,255,255,127,255,248,240,45,10,1,208,240,60,15,2,208,240,120,11,3,192,240,244,7,67,128,240,240,255,255,252,242,208,255,255,252,241,240,0,0,0,240,184,0,0,0,240,60,47,255,240,240,30,47,255,240,240,14,44,0,240,240,15,44,0,240,240,46,44,0,240,243,253,47,255,240,242,244,47,255,240,240,0,44,0,240,240,0,20,0,80,160,0,
  // 0x914d  配
  77,145,20,21,105,22,1,253,191,255,240,0,0,255,255,243,255,253,2,140,3,255,253,2,140,0,0,45,43,255,144,0,45,127,255,224,0,45,117,152,224,0,45,117,152,224,0,45,117,152,227,255,253,118,88,227,255,253,119,88,227,192,45,123,15,227,192,4,116,0,227,192,0,121,85,227,192,0,127,255,227,192,4,116,0,227,192,11,116,0,227,192,15,122,170,227,192,15,127,255,226,255,254,116,0,224,255,252,16,0,0,0,0,
  // 0x91ca  释
  202,145,20,21,105,22,1,253,5,191,64,0,0,255,245,63,255,253,86,208,47,255,253,97,211,71,64,184,113,215,66,210,240,57,219,0,251,192,45,221,0,191,0,1,208,7,255,208,255,255,191,210,254,171,250,185,20,47,3,240,0,60,0,15,253,47,255,248,31,239,111,255,252,62,215,0,60,0,181,208,0,60,0,241,208,127,255,254,129,208,191,255,255,1,208,0,60,0,1,208,0,60,0,1,208,0,60,0,1,128,0,40,0,
  // 0x91cd  重
  205,145,20,20,100,22,1,254,0,5,90,191,192,15,255,255,255,144,5,64,60,0,0,106,170,190,170,169,191,255,255,255,254,0,0,60,0,0,1,85,125,85,80,7,255,255,255,224,7,128,60,1,224,7,255,255,255,224,7,149,125,86,224,7,128,60,1,224,7,255,255,255,224,1,85,189,85,80,0,0,60,0,0,15,255,255,255,244,10,170,190,170,164,0,0,60,0,0,170,170,190,170,170,255,255,255,255,255,
  // 0x91cf  量
  207,145,20,20,100,22,1,254,3,255,255,255,192,3,192,0,3,192,3,255,255,255,192,3,192,0,3,192,3,192,0,3,192,3,255,255,255,192,85,85,85,85,85,255,255,255,255,255,0,0,0,0,0,7,255,255,255,224,7,128,60,1,224,7,255,255,255,224,7,128,60,1,224,7,128,60,1,224,7,255,255,255,224,0,0,60,0,0,15,255,255,255,240,5,85,125,85,80,106,170,190,170,170,255,255,255,255,255,
  // 0x9488  针
  136,148,20,22,110,22,1,253,1,0,0,20,0,7,128,0,45,0,15,64,0,45,0,31,255,64,45,0,127,255,64,45,0,248,0,0,45,0,240,0,0,45,0,111,254,0,45,0,47,254,191,255,255,2,208,191,255,255,2,208,0,45,0,2,208,0,45,0,191,255,0,45,0,127,255,0,45,0,2,208,0,45,0,2,208,0,45,0,2,208,0,45,0,2,215,128,45,0,2,255,128,45,0,7,248,0,45,0,3,208,0,45,0,1,0,0,24,0,
  // 0x94ae  钮
  174,148,20,22,110,22,1,253,4,0,0,0,0,15,0,127,255,252,30,0,127,255,252,47,255,0,240,60,127,255,0,240,60,244,0,0,240,60,240,0,1,224,60,191,253,1,224,60,47,253,1,224,56,3,192,43,250,184,3,192,127,255,248,3,192,23,229,184,255,255,3,192,180,191,255,3,192,180,3,192,3,192,180,3,192,3,192,240,3,192,7,128,240,3,222,11,64,240,3,253,11,64,240,7,227,255,255,255,11,67,255,255,255,0,0,0,0,0,
  // 0x9519  错
  25,149,20,22,110,22,1,253,1,0,2,65,128,11,64,7,130,192,15,0,7,130,192,47,255,63,255,253,63,255,127,255,254,244,0,7,130,192,240,0,7,130,192,111,254,7,130,192,47,253,255,255,255,2,192,191,255,255,2,192,0,0,0,2,192,26,170,164,191,255,31,255,248,127,255,29,0,56,2,192,29,0,56,2,192,31,255,248,2,192,31,170,184,2,218,29,0,56,3,254,29,0,56,11,244,31,255,248,7,64,31,170,184,0,0,24,0,20,
  // 0x955c  镜
  92,149,20,22,110,22,1,253,0,0,0,20,0,11,64,0,60,0,15,0,63,255,253,47,254,43,170,233,63,253,7,64,224,248,0,3,130,208,240,0,255,255,255,127,252,170,170,170,47,252,0,0,0,3,192,63,255,252,3,192,61,85,124,3,192,60,0,60,191,255,63,255,252,191,254,60,0,60,3,192,63,255,252,3,192,23,219,148,3,197,3,199,128,3,255,7,135,129,3,253,31,7,135,15,225,189,7,239,11,66,244,3,254,0,0,0,0,0,
  // 0x957f  长
  127,149,20,22,110,22,1,253,0,80,0,0,0,0,180,0,3,128,0,180,0,15,192,0,180,0,127,0,0,180,2,248,0,0,180,47,224,0,0,180,255,0,0,0,180,52,0,0,0,180,0,0,0,191,255,255,255,254,191,255,255,255,254,0,180,31,0,0,0,180,15,64,0,0,180,7,192,0,0,180,3,240,0,0,180,0,248,0,0,180,0,127,0,0,180,109,31,208,0,255,254,7,254,1,255,228,0,190,0,244,0,0,8,0,0,0,0,0,
  // 0x95ed  闭
  237,149,18,21,105,22,2,253,52,0,0,0,0,125,15,255,255,240,47,15,255,255,240,11,0,0,0,240,0,0,11,0,240,240,0,15,64,240,240,0,15,64,240,242,255,255,252,240,242,255,255,252,240,240,0,127,64,240,240,1,255,64,240,240,7,223,64,240,240,31,79,64,240,240,253,15,64,240,247,240,15,64,240,243,128,15,64,240,240,0,15,0,240,240,3,255,0,240,240,2,249,31,240,240,0,0,15,208,0,0,0,0,0,
  // 0x95f2  闲
  242,149,18,21,105,22,2,253,60,15,255,255,240,31,15,255,255,240,11,128,0,0,240,3,192,0,0,240,145,0,160,0,240,224,0,240,0,240,224,0,240,0,240,226,170,250,168,240,226,255,255,252,240,224,3,252,0,240,224,11,255,0,240,224,30,251,192,240,224,60,242,224,240,224,244,240,244,240,227,208,240,56,240,226,64,240,0,240,224,0,240,0,240,224,0,240,0,240,224,0,64,191,240,224,0,0,63,208,64,0,0,0,0,
  // 0x95f4  间
  244,149,18,21,105,22,2,253,52,0,0,0,0,125,31,255,255,240,47,31,255,255,240,15,0,0,0,240,0,0,0,0,240,240,0,0,0,240,240,63,255,208,240,240,62,171,208,240,240,56,2,208,240,240,56,2,208,240,240,62,171,208,240,240,63,255,208,240,240,56,2,208,240,240,56,2,208,240,240,56,2,208,240,240,63,255,208,240,240,42,170,128,240,240,0,0,0,240,240,0,0,15,240,240,0,0,15,208,0,0,0,0,0,
  // 0x9608  阈
  8,150,18,22,110,22,2,253,4,0,0,0,0,61,15,255,255,240,31,79,255,255,240,7,192,0,0,240,3,192,44,64,240,240,0,44,224,240,240,0,44,32,240,243,255,255,252,240,242,170,190,168,240,240,0,28,32,240,241,255,157,116,240,241,195,141,240,240,241,195,142,224,240,241,255,143,192,240,240,0,11,128,240,240,6,139,77,240,243,255,223,205,240,243,164,126,252,240,240,0,240,180,240,240,0,0,123,240,240,0,0,63,208,0,0,0,0,0,
  // 0x964d  降
  77,150,19,22,110,22,2,253,0,0,1,0,0,255,224,15,64,0,255,240,31,170,128,224,240,127,255,208,225,209,252,7,192,226,199,239,31,64,227,199,75,189,0,231,64,3,248,0,231,64,11,254,0,227,193,191,95,248,225,235,244,42,252,224,242,64,60,0,224,243,255,255,240,224,242,254,190,160,235,240,116,60,0,235,192,116,60,0,224,10,254,254,168,224,15,255,255,252,224,0,0,60,0,224,0,0,60,0,224,0,0,60,0,144,0,0,20,0,
  // 0x9650  限
  80,150,19,21,105,22,2,253,255,240,170,170,160,255,249,255,255,224,224,245,224,1,224,224,241,224,1,224,225,225,224,1,224,226,209,255,255,224,227,193,250,171,224,227,129,224,1,224,226,209,224,1,224,224,241,255,255,224,224,177,255,255,224,224,117,224,240,96,224,181,224,176,244,235,241,224,123,208,231,209,224,63,64,224,1,224,46,0,224,1,224,31,64,224,1,255,231,208,224,31,255,146,252,224,15,144,0,120,80,0,0,0,0,
  // 0x9664  除
  100,150,19,22,110,22,2,253,0,0,2,128,0,255,224,11,240,0,255,240,31,188,0,224,240,61,46,0,225,208,248,15,128,226,195,224,3,240,227,223,128,0,252,231,94,255,255,188,231,64,171,250,64,227,192,2,192,0,225,224,2,192,0,224,242,171,250,160,224,247,255,255,240,224,240,2,192,0,235,241,210,194,64,235,194,194,195,192,224,3,194,194,224,224,15,66,192,240,224,31,2,192,184,224,45,2,192,56,224,4,63,192,16,224,0,47,64,0,
  // 0x9669  险
  105,150,20,22,110,22,2,253,0,0,1,128,0,255,224,3,208,0,255,240,11,240,0,224,240,31,124,0,225,208,60,47,0,226,192,244,11,192,227,195,224,2,244,231,79,234,170,189,231,159,191,255,28,226,196,0,0,0,224,224,0,0,0,224,241,130,192,176,224,242,193,208,240,224,241,224,209,208,235,240,240,227,192,235,192,240,243,128,224,0,176,11,0,224,0,0,14,0,224,0,0,29,0,224,15,255,255,252,224,11,255,255,248,144,0,0,0,0,
  // 0x96f6  零
  246,150,20,21,105,22,1,253,10,170,170,170,160,15,255,255,255,240,0,0,60,0,0,127,255,255,255,253,121,85,125,85,109,117,170,60,170,93,116,0,60,0,29,0,0,60,0,0,3,255,105,255,192,0,2,255,64,0,0,31,199,244,0,1,254,0,191,64,111,239,255,251,254,254,5,85,80,191,21,85,85,85,64,11,255,255,255,192,0,1,224,3,192,0,1,224,3,192,0,1,224,191,128,0,1,224,41,0,0,1,144,0,0,
  // 0x9700  需
  0,151,20,21,105,22,1,253,10,170,170,170,160,15,255,255,255,240,0,0,60,0,0,127,255,255,255,253,121,85,125,85,109,116,85,60,85,29,118,255,60,255,157,116,0,60,0,29,3,255,60,255,192,1,85,40,85,64,106,170,170,170,169,191,255,255,255,254,0,0,120,0,0,10,170,254,170,164,15,255,255,255,244,15,3,129,208,180,15,3,129,208,180,15,3,129,208,180,15,3,129,208,180,15,3,129,215,244,10,1,64,66,144,
  // 0x9752  青
  82,151,20,22,110,22,1,253,0,0,20,0,0,0,0,60,0,0,31,255,255,255,244,10,170,190,170,164,0,0,60,0,0,7,255,255,255,224,1,85,189,85,80,0,0,60,0,0,191,255,255,255,254,106,170,170,170,169,1,170,170,170,64,2,255,255,255,192,2,208,0,3,192,2,229,85,91,192,2,255,255,255,192,2,208,0,3,192,2,229,85,91,192,2,255,255,255,192,2,208,0,3,192,2,208,0,7,192,2,208,1,255,128,1,128,0,169,0,
  // 0x975e  非
  94,151,20,22,110,22,1,253,0,5,0,64,0,0,15,66,224,0,0,15,66,224,0,0,15,66,224,0,127,255,66,255,254,127,255,66,255,254,0,15,66,224,0,0,15,66,224,0,0,15,66,224,0,63,255,66,255,252,63,255,66,255,252,0,15,66,224,0,0,15,2,224,0,0,31,242,224,0,191,255,242,255,255,255,190,2,255,255,80,60,2,224,0,0,248,2,224,0,3,240,2,224,0,31,192,2,224,0,63,0,2,224,0,4,0,1,144,0,
  // 0x9760  靠
  96,151,20,22,110,22,1,253,0,64,20,0,0,2,224,60,0,0,3,255,255,255,240,15,149,125,85,80,47,85,125,85,84,191,255,255,255,253,0,0,40,0,0,7,255,255,255,224,7,213,85,86,224,7,213,85,86,224,7,255,255,255,224,0,11,65,224,0,127,255,65,255,253,21,91,65,229,84,5,91,65,229,84,63,255,65,255,252,0,11,65,224,0,191,255,1,255,255,169,126,1,229,85,1,252,1,224,0,15,224,1,224,0,5,0,0,80,0,
  // 0x9762  面
  98,151,20,20,100,22,1,253,191,255,255,255,255,191,255,255,255,254,0,0,184,0,0,0,0,244,0,0,47,255,255,255,248,47,255,255,255,248,44,15,0,224,120,44,15,0,224,120,44,15,170,224,120,44,15,255,224,120,44,15,0,224,120,44,15,0,224,120,44,15,170,224,120,44,15,255,224,120,44,15,0,224,120,44,15,0,224,120,47,255,255,255,248,47,255,255,255,248,44,0,0,0,120,20,0,0,0,20,
  // 0x9875  页
  117,152,20,20,100,22,1,253,127,255,255,255,254,127,255,255,255,253,0,0,184,0,0,0,0,240,0,0,7,255,255,255,224,7,255,255,255,224,7,128,0,2,224,7,128,60,2,224,7,128,60,2,224,7,128,60,2,224,7,128,60,2,224,7,128,60,2,224,7,128,60,2,224,7,128,124,2,224,2,64,245,209,144,0,7,226,253,0,0,127,128,47,208,27,253,0,3,252,127,144,0,0,124,20,0,0,0,4,
  // 0x9879  项
  121,152,20,21,105,22,1,253,0,1,255,255,255,0,2,255,255,255,255,253,85,244,0,255,252,1,240,0,7,128,191,255,248,7,128,255,255,248,7,128,240,0,120,7,128,240,180,120,7,128,240,180,120,7,128,240,180,120,7,128,240,180,120,7,128,240,180,120,7,237,240,180,120,31,253,240,244,120,255,208,240,240,120,248,0,2,225,0,0,0,7,203,192,0,0,47,66,244,0,6,253,0,126,0,11,224,0,30,0,1,0,0,0,
  // 0x9884  预
  132,152,20,21,105,22,1,253,191,255,47,255,255,191,255,127,255,255,0,47,0,30,0,0,60,0,45,0,61,244,15,255,252,31,208,15,255,252,3,244,15,0,60,0,252,15,4,60,255,255,223,29,60,255,255,207,29,60,2,195,143,29,60,2,199,79,29,60,2,203,15,45,60,2,192,15,45,60,2,192,15,60,44,2,192,0,184,64,2,192,1,243,224,2,192,11,208,252,127,192,191,0,63,63,64,52,0,13,0,0,0,0,0,
  // 0x9891  频
  145,152,20,22,110,22,1,253,0,36,0,0,0,0,120,0,0,0,24,120,11,255,255,44,127,235,255,254,44,126,144,15,0,44,120,0,14,0,44,120,3,255,253,255,255,243,234,189,255,255,243,138,29,0,176,3,143,29,4,176,3,143,29,44,176,243,143,29,60,177,227,143,29,120,178,195,143,29,240,179,195,142,29,160,187,67,142,29,0,111,3,93,24,0,124,0,62,128,2,244,0,186,240,47,192,7,224,125,190,0,63,128,15,16,0,20,0,0,
  // 0x989d  额
  157,152,20,21,105,22,1,253,0,240,0,0,0,0,244,11,255,255,191,255,251,255,254,186,170,240,14,0,179,192,240,29,0,87,234,215,255,252,31,255,199,170,188,124,11,135,69,44,247,95,7,79,44,7,252,7,79,44,3,255,7,78,44,111,223,231,78,44,253,1,231,78,44,106,170,135,93,44,15,255,199,109,44,14,3,193,60,4,14,3,192,121,208,14,3,193,240,248,15,255,203,208,47,15,171,239,0,11,4,0,4,0,0,
  // 0x98ce  风
  206,152,21,21,126,22,1,253,11,255,255,255,208,0,11,255,255,255,208,0,11,128,0,2,208,0,11,128,0,66,208,0,11,132,0,242,208,0,11,174,2,210,208,0,11,143,67,194,208,0,11,131,215,130,208,0,11,65,255,66,208,0,11,64,191,2,208,0,11,64,62,2,208,0,15,64,191,2,208,0,15,1,255,130,208,0,15,3,227,209,208,0,31,15,193,241,224,0,46,63,0,249,226,0,61,124,0,120,243,64,124,20,0,0,247,0,248,0,0,0,191,0,176,0,0,0,62,0,0,0,0,0,0,0,
  // 0x9971  饱
  113,153,20,22,110,22,1,253,4,0,0,0,0,15,0,15,0,0,15,0,15,0,0,30,0,47,255,252,47,254,63,255,252,62,190,180,0,60,60,46,240,0,60,180,63,255,253,60,241,101,190,189,60,231,128,60,29,60,7,128,60,29,60,7,128,60,29,60,7,128,62,189,60,7,128,63,253,120,7,128,60,15,248,7,132,60,11,240,7,172,60,0,0,7,252,60,0,15,11,240,60,0,15,15,128,63,255,254,10,0,15,255,248,0,0,0,0,0,
  // 0x9a6c  马
  108,154,19,20,100,22,1,253,15,255,255,255,64,15,255,255,255,0,0,0,0,15,0,0,160,0,15,0,0,240,0,15,0,1,224,0,31,0,1,224,0,30,0,2,208,0,46,0,2,255,255,255,252,3,255,255,255,252,0,0,0,0,60,0,0,0,0,60,0,0,0,0,60,191,255,255,248,124,191,255,255,248,120,0,0,0,0,180,0,0,0,0,244,0,0,0,1,240,0,0,1,255,224,0,0,0,255,128,
  // 0x9a71  驱
  113,154,20,21,105,22,1,253,106,188,0,0,0,191,252,63,255,254,0,44,63,255,254,0,44,60,0,0,60,60,60,64,56,60,60,61,224,120,60,60,60,244,240,56,56,60,61,224,56,56,60,31,208,52,56,60,11,192,127,255,60,11,192,106,175,60,15,224,0,15,60,45,244,0,15,60,124,124,27,223,60,244,61,255,158,62,224,29,228,14,60,128,0,0,29,60,0,0,10,188,63,255,255,11,244,63,255,255,0,0,0,0,0,
  // 0x9ad8  高
  216,154,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,127,255,255,255,253,191,255,255,255,253,0,0,0,0,0,0,85,85,85,0,0,255,255,255,0,0,240,0,15,0,0,240,0,15,0,0,255,255,255,0,0,85,85,85,0,26,170,170,170,168,47,255,255,255,248,45,0,0,0,120,45,5,85,80,120,45,15,255,240,120,45,14,0,176,120,45,14,0,176,120,45,15,255,240,120,45,15,85,96,120,45,9,0,15,248,24,0,0,15,224,
  // 0x9ec4  黄
  196,158,20,22,110,22,1,253,0,25,0,100,0,0,30,0,184,0,15,255,255,255,244,15,255,255,255,244,0,30,0,184,0,0,30,0,184,0,191,255,255,255,254,191,255,255,255,255,0,0,60,0,0,1,85,189,85,80,7,255,255,255,224,7,128,60,1,224,7,149,125,86,224,7,255,255,255,224,7,128,60,1,224,7,128,60,1,224,7,255,255,255,224,1,90,85,165,80,0,111,0,253,0,11,253,0,47,228,127,144,0,1,253,20,0,0,0,20,
  // 0x9ede  點
  222,158,20,22,110,22,1,253,0,0,0,9,0,127,255,224,30,0,121,245,224,30,0,121,162,224,30,0,122,170,224,30,0,119,173,224,31,255,119,172,224,31,255,112,160,224,30,0,127,255,224,30,0,21,245,64,30,0,0,240,0,30,0,127,255,231,255,252,42,250,151,255,253,0,245,167,64,45,191,255,247,64,45,170,84,7,64,45,0,1,135,64,45,55,105,215,64,45,54,156,247,64,45,178,205,123,255,253,226,200,7,255,253,0,0,6,64,24,
  // 0x9f50  齐
  80,159,20,22,110,22,1,253,0,0,40,0,0,0,0,60,0,0,106,170,254,170,169,191,255,255,255,254,0,184,0,46,0,0,62,0,188,0,0,15,194,244,0,0,3,255,192,0,0,1,255,128,0,0,111,255,254,64,111,255,65,191,254,191,244,0,11,254,20,120,0,30,4,0,120,0,30,0,0,120,0,30,0,0,184,0,30,0,0,244,0,30,0,0,240,0,30,0,3,240,0,30,0,15,192,0,30,0,47,64,0,30,0,4,0,0,9,0,
  // 0xff1a  ：
  26,255,4,15,15,22,9,0,124,255,190,40,0,0,0,0,0,0,0,125,255,190,40,
};

#endif // HAS_GRAPHICAL_TFT
