/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Latin Extended-A 22pt, capital 'A' height: 16px, width: 100%, range: 0x0100-0x017f
extern const uint8_t NotoSans_Medium_Latin_Extended_A_16[8564] = {
  130,16,0,1,127,1,21,250, // unifont_t
  // 0x0100  Ā
  14,19,76,14,0,0,0,255,248,0,0,170,164,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x0101  ā
  10,16,48,13,1,255,15,255,128,10,170,64,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x0102  Ă
  14,21,84,14,0,0,0,64,20,0,1,208,120,0,0,191,240,0,0,26,64,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x0103  ă
  10,18,54,13,1,255,4,0,64,14,7,128,11,255,0,1,164,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x0104  Ą
  14,21,84,14,0,251,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,0,0,1,208,0,0,3,64,0,0,11,0,0,0,7,224,0,0,2,240,
  // 0x0105  ą
  11,17,51,13,1,251,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,1,208,0,3,128,0,7,64,0,7,224,0,2,244,
  // 0x0106  Ć
  12,22,66,14,1,255,0,0,248,0,2,240,0,7,192,0,10,0,0,0,0,0,111,232,2,255,255,15,228,26,47,64,0,62,0,0,124,0,0,188,0,0,188,0,0,188,0,0,188,0,0,124,0,0,61,0,0,63,0,0,15,208,1,7,255,254,0,191,253,0,0,0,
  // 0x0107  ć
  9,18,54,11,1,255,0,15,128,0,47,0,0,124,0,0,160,0,0,0,0,2,255,128,31,255,128,63,0,0,124,0,0,184,0,0,248,0,0,248,0,0,248,0,0,188,0,0,62,0,64,47,255,192,7,255,128,0,0,0,
  // 0x0108  Ĉ
  12,22,66,14,1,255,0,15,128,0,63,224,0,244,244,1,144,24,0,0,0,0,111,232,2,255,255,15,228,26,47,64,0,62,0,0,124,0,0,188,0,0,188,0,0,188,0,0,188,0,0,124,0,0,61,0,0,63,0,0,15,208,1,7,255,254,0,191,253,0,0,0,
  // 0x0109  ĉ
  9,18,54,11,1,255,1,248,0,3,254,0,15,79,64,24,2,128,0,0,0,2,255,128,31,255,128,63,0,0,124,0,0,184,0,0,248,0,0,248,0,0,248,0,0,188,0,0,62,0,64,47,255,192,7,255,128,0,0,0,
  // 0x010a  Ċ
  12,22,66,14,1,255,0,1,0,0,15,128,0,15,128,0,1,0,0,0,0,0,111,232,2,255,255,15,228,26,47,64,0,62,0,0,124,0,0,188,0,0,188,0,0,188,0,0,188,0,0,124,0,0,61,0,0,63,0,0,15,208,1,7,255,254,0,191,253,0,0,0,
  // 0x010b  ċ
  9,18,54,11,1,255,0,16,0,0,244,0,0,244,0,0,16,0,0,0,0,2,255,128,31,255,128,63,0,0,124,0,0,184,0,0,248,0,0,248,0,0,248,0,0,188,0,0,62,0,64,47,255,192,7,255,128,0,0,0,
  // 0x010c  Č
  12,22,66,14,1,255,1,208,44,0,184,244,0,63,208,0,10,128,0,0,0,0,111,232,2,255,255,15,228,26,47,64,0,62,0,0,124,0,0,188,0,0,188,0,0,188,0,0,188,0,0,124,0,0,61,0,0,63,0,0,15,208,1,7,255,254,0,191,253,0,0,0,
  // 0x010d  č
  9,18,54,11,1,255,29,2,192,11,143,64,3,253,0,0,164,0,0,0,0,2,255,128,31,255,128,63,0,0,124,0,0,184,0,0,248,0,0,248,0,0,248,0,0,188,0,0,62,0,64,47,255,192,7,255,128,0,0,0,
  // 0x010e  Ď
  13,21,84,16,2,0,11,0,224,0,3,215,192,0,0,255,0,0,0,105,0,0,0,0,0,0,170,169,0,0,255,255,224,0,249,87,252,0,244,0,126,0,244,0,47,0,244,0,15,64,244,0,15,128,244,0,11,192,244,0,11,192,244,0,15,128,244,0,15,128,244,0,31,0,244,0,126,0,244,6,252,0,255,255,240,0,255,254,64,0,
  // 0x010f  ď
  15,18,72,14,1,255,0,0,104,164,0,0,188,240,0,0,188,224,0,0,189,192,0,0,188,0,7,253,124,0,47,255,252,0,62,2,252,0,188,0,252,0,184,0,188,0,248,0,124,0,248,0,124,0,248,0,188,0,188,0,252,0,62,1,252,0,47,239,252,0,11,253,60,0,0,0,0,0,
  // 0x0110  Đ
  15,16,64,16,0,0,10,170,144,0,15,255,254,0,15,149,127,192,15,128,7,224,15,128,2,240,15,128,0,244,15,128,0,248,127,255,0,188,127,255,0,188,31,149,0,248,15,128,0,248,15,128,1,240,15,128,7,224,15,128,111,192,15,255,255,0,15,255,228,0,
  // 0x0111  đ
  13,18,72,14,1,255,0,0,104,0,0,0,188,0,0,191,255,64,0,191,255,64,0,0,188,0,2,248,124,0,31,255,188,0,63,66,252,0,124,0,252,0,188,0,188,0,248,0,188,0,248,0,124,0,248,0,188,0,188,0,188,0,126,1,252,0,47,239,252,0,11,253,60,0,0,0,0,0,
  // 0x0112  Ē
  9,19,57,12,2,0,47,255,0,26,170,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x0113  ē
  11,16,48,13,1,255,15,255,128,10,170,64,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x0114  Ĕ
  9,21,63,12,2,0,16,1,0,60,11,0,15,253,0,2,160,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x0115  ĕ
  11,18,54,13,1,255,4,0,64,14,7,128,11,255,0,1,164,0,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x0116  Ė
  9,21,63,12,2,0,0,64,0,2,240,0,2,240,0,0,64,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x0117  ė
  11,18,54,13,1,255,0,16,0,0,248,0,0,248,0,0,16,0,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x0118  Ę
  9,21,63,12,2,251,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,0,15,0,0,44,0,0,60,0,0,62,128,0,15,128,
  // 0x0119  ę
  11,17,51,13,1,251,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,3,128,0,11,0,0,15,0,0,15,144,0,7,224,
  // 0x011a  Ě
  9,21,63,12,2,0,56,7,64,31,46,0,7,248,0,2,160,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x011b  ě
  11,18,54,13,1,255,29,2,192,11,143,64,3,253,0,0,168,0,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x011c  Ĝ
  14,22,88,16,1,255,0,11,208,0,0,31,240,0,0,124,124,0,0,160,9,0,0,0,0,0,0,27,250,0,2,255,255,192,11,244,6,128,31,128,0,0,62,0,0,0,124,0,0,0,188,0,0,0,188,0,85,64,188,1,255,208,188,0,171,208,124,0,3,208,61,0,3,208,63,0,3,208,15,208,3,208,7,255,255,208,0,191,255,128,0,0,0,0,
  // 0x011d  ĝ
  11,23,69,14,1,250,0,252,0,2,255,0,11,139,128,9,1,144,0,0,0,7,253,56,31,255,188,62,2,252,188,0,252,184,0,188,248,0,124,248,0,124,248,0,124,188,0,188,62,1,252,47,239,252,11,253,124,0,0,188,0,0,184,16,1,244,63,171,240,47,255,128,0,16,0,
  // 0x011e  Ğ
  14,22,88,16,1,255,0,80,4,0,0,180,45,0,0,63,248,0,0,6,144,0,0,0,0,0,0,27,250,0,2,255,255,192,11,244,6,128,31,128,0,0,62,0,0,0,124,0,0,0,188,0,0,0,188,0,85,64,188,1,255,208,188,0,171,208,124,0,3,208,61,0,3,208,63,0,3,208,15,208,3,208,7,255,255,208,0,191,255,128,0,0,0,0,
  // 0x011f  ğ
  11,23,69,14,1,250,4,0,64,15,6,192,7,255,64,0,168,0,0,0,0,7,253,56,31,255,188,62,2,252,188,0,252,184,0,188,248,0,124,248,0,124,248,0,124,188,0,188,62,1,252,47,239,252,11,253,124,0,0,188,0,0,184,16,1,244,63,171,240,47,255,128,0,16,0,
  // 0x0120  Ġ
  14,22,88,16,1,255,0,1,0,0,0,7,192,0,0,7,192,0,0,0,0,0,0,0,0,0,0,27,250,0,2,255,255,192,11,244,6,128,31,128,0,0,62,0,0,0,124,0,0,0,188,0,0,0,188,0,85,64,188,1,255,208,188,0,171,208,124,0,3,208,61,0,3,208,63,0,3,208,15,208,3,208,7,255,255,208,0,191,255,128,0,0,0,0,
  // 0x0121  ġ
  11,23,69,14,1,250,0,16,0,0,188,0,0,188,0,0,16,0,0,0,0,7,253,56,31,255,188,62,2,252,188,0,252,184,0,188,248,0,124,248,0,124,248,0,124,188,0,188,62,1,252,47,239,252,11,253,124,0,0,188,0,0,184,16,1,244,63,171,240,47,255,128,0,16,0,
  // 0x0122  Ģ
  14,21,84,16,1,251,0,27,250,0,2,255,255,192,11,244,6,128,31,128,0,0,62,0,0,0,124,0,0,0,188,0,0,0,188,0,85,64,188,1,255,208,188,0,171,208,124,0,3,208,61,0,3,208,63,0,3,208,15,208,3,208,7,255,255,208,0,191,255,128,0,0,0,0,0,2,128,0,0,3,192,0,0,7,64,0,0,10,0,0,
  // 0x0123  ģ
  11,23,69,14,1,250,0,28,0,0,60,0,0,184,0,0,164,0,0,0,0,7,253,56,31,255,188,62,2,252,188,0,252,184,0,188,248,0,124,248,0,124,248,0,124,188,0,188,62,1,252,47,239,252,11,253,124,0,0,188,0,0,184,16,1,244,63,171,240,47,255,128,0,16,0,
  // 0x0124  Ĥ
  13,21,84,16,2,0,0,126,0,0,0,255,64,0,3,211,208,0,6,0,160,0,0,0,0,0,164,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,248,0,15,64,255,255,255,64,255,255,255,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,
  // 0x0125  ĥ
  13,22,88,14,255,0,7,208,0,0,31,244,0,0,60,60,0,0,160,10,0,0,0,0,0,0,2,128,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,199,253,0,3,239,255,64,3,244,15,192,3,224,7,192,3,208,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,
  // 0x0126  Ħ
  17,16,80,16,0,0,10,64,0,160,0,15,64,0,244,0,95,149,85,249,0,255,255,255,255,64,175,170,170,250,0,15,64,0,244,0,15,128,0,244,0,15,255,255,244,0,15,255,255,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,15,64,0,244,0,
  // 0x0127  ħ
  12,17,51,14,0,0,10,0,0,15,0,0,191,255,64,191,255,64,15,0,0,15,6,144,15,127,252,15,245,190,15,192,47,15,64,31,15,64,15,15,0,15,15,0,15,15,0,15,15,0,15,15,0,15,15,0,15,
  // 0x0128  Ĩ
  8,21,42,8,0,0,0,1,127,75,235,253,128,100,0,0,42,168,63,252,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,47,244,63,252,
  // 0x0129  ĩ
  8,17,34,6,255,0,0,1,127,75,247,254,128,100,0,0,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,
  // 0x012a  Ī
  8,19,38,8,0,0,191,253,106,168,0,0,42,168,63,252,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,47,244,63,252,
  // 0x012b  ī
  8,15,30,6,255,0,127,253,106,168,0,0,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,
  // 0x012c  Ĭ
  8,21,42,8,0,0,80,4,180,45,63,248,6,144,0,0,42,168,63,252,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,47,244,63,252,
  // 0x012d  ĭ
  8,17,34,6,255,0,80,5,116,29,63,248,6,144,0,0,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,
  // 0x012e  Į
  6,21,42,8,1,251,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,3,192,11,0,15,0,15,160,3,240,
  // 0x012f  į
  5,22,44,6,0,251,5,0,15,0,15,0,0,0,0,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,14,0,60,0,120,0,62,64,31,64,
  // 0x0130  İ
  6,21,42,8,1,0,4,0,31,0,31,0,0,0,0,0,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,
  // 0x0131  ı
  2,12,12,6,2,0,240,240,240,240,240,240,240,240,240,240,240,240,
  // 0x0132  Ĳ
  11,21,63,14,1,251,170,160,40,255,240,60,31,0,60,31,0,60,31,0,60,31,0,60,31,0,60,31,0,60,31,0,60,31,0,60,31,0,60,31,0,60,31,0,60,31,0,60,191,208,60,255,240,60,0,0,124,0,0,188,0,63,244,0,63,224,0,5,0,
  // 0x0133  ĳ
  8,23,46,12,2,250,80,4,240,15,240,15,0,0,0,0,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,240,15,0,15,0,15,0,31,2,190,7,252,0,64,
  // 0x0134  Ĵ
  9,26,78,6,254,251,1,248,0,3,253,0,15,79,64,24,2,128,0,0,0,0,164,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,2,240,0,191,224,0,191,128,0,20,0,0,
  // 0x0135  ĵ
  9,23,69,6,254,250,2,244,0,7,252,0,15,15,0,40,2,128,0,0,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,1,240,0,43,224,0,127,192,0,4,0,0,
  // 0x0136  Ķ
  12,21,63,14,2,251,164,0,41,244,0,248,244,3,240,244,11,192,244,47,0,244,124,0,245,244,0,251,240,0,255,248,0,252,125,0,244,63,0,244,15,128,244,7,208,244,2,240,244,0,252,244,0,62,0,0,0,0,104,0,0,184,0,0,240,0,0,208,0,
  // 0x0137  ķ
  10,22,66,12,2,251,160,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,3,208,240,15,128,240,62,0,240,248,0,243,224,0,251,208,0,255,240,0,248,252,0,240,62,0,240,31,64,240,11,192,240,3,240,0,0,0,1,144,0,3,208,0,3,192,0,7,0,0,
  // 0x0138  ĸ
  10,12,36,12,2,0,240,3,208,240,15,128,240,63,0,240,188,0,242,240,0,251,208,0,255,240,0,252,252,0,240,62,0,240,31,64,240,11,192,240,3,240,
  // 0x0139  Ĺ
  9,21,63,12,2,0,15,128,0,47,0,0,124,0,0,160,0,0,0,0,0,164,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x013a  ĺ
  5,22,44,6,2,0,31,64,62,0,184,0,144,0,0,0,160,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
  // 0x013b  Ļ
  9,21,63,12,2,251,164,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,0,0,0,0,160,0,1,240,0,2,208,0,2,128,0,
  // 0x013c  ļ
  4,22,22,6,1,251,40,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,0,41,60,56,112,
  // 0x013d  Ľ
  9,16,48,12,2,0,164,2,128,244,3,192,244,7,64,244,6,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x013e  ľ
  6,17,34,6,2,0,160,160,241,224,242,192,242,64,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
  // 0x013f  Ŀ
  9,16,48,12,2,0,164,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,4,0,244,31,0,244,31,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x0140  ŀ
  6,17,34,7,2,0,160,0,240,0,240,0,240,0,240,0,240,0,240,0,240,64,243,208,243,208,240,64,240,0,240,0,240,0,240,0,240,0,240,0,
  // 0x0141  Ł
  11,16,48,12,0,0,10,64,0,15,64,0,15,64,0,15,64,0,15,64,0,15,64,0,15,174,0,15,253,0,15,224,0,127,128,0,127,64,0,15,64,0,15,64,0,15,64,0,15,255,252,15,255,252,
  // 0x0142  ł
  6,17,34,6,0,0,10,0,31,0,31,0,31,0,31,0,31,0,31,0,31,240,31,224,127,64,255,0,95,0,31,0,31,0,31,0,31,0,31,0,
  // 0x0143  Ń
  13,21,84,17,2,0,0,2,240,0,0,7,192,0,0,15,0,0,0,24,0,0,0,0,0,0,168,0,2,128,254,0,3,192,255,64,3,192,255,192,3,192,247,224,3,192,241,240,3,192,240,252,3,192,240,61,3,192,244,47,3,192,244,15,131,192,244,7,211,192,244,2,243,192,244,0,251,192,244,0,127,192,244,0,63,192,244,0,15,192,
  // 0x0144  ń
  10,17,51,14,2,0,0,31,64,0,62,0,0,184,0,0,144,0,0,0,0,225,255,64,251,255,208,253,3,240,248,1,240,244,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,
  // 0x0145  Ņ
  13,21,84,17,2,251,168,0,2,128,254,0,3,192,255,64,3,192,255,192,3,192,247,224,3,192,241,240,3,192,240,252,3,192,240,61,3,192,244,47,3,192,244,15,131,192,244,7,211,192,244,2,243,192,244,0,251,192,244,0,127,192,244,0,63,192,244,0,15,192,0,0,0,0,0,10,0,0,0,30,0,0,0,44,0,0,0,52,0,0,
  // 0x0146  ņ
  10,17,51,14,2,251,225,255,64,251,255,208,253,3,240,248,1,240,244,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,0,0,0,0,164,0,0,240,0,1,224,0,1,192,0,
  // 0x0147  Ň
  13,21,84,17,2,0,7,128,180,0,1,242,224,0,0,191,128,0,0,42,0,0,0,0,0,0,168,0,2,128,254,0,3,192,255,64,3,192,255,192,3,192,247,224,3,192,241,240,3,192,240,252,3,192,240,61,3,192,244,47,3,192,244,15,131,192,244,7,211,192,244,2,243,192,244,0,251,192,244,0,127,192,244,0,63,192,244,0,15,192,
  // 0x0148  ň
  10,17,51,14,2,0,60,7,128,15,95,0,3,252,0,1,164,0,0,0,0,225,255,64,251,255,208,253,3,240,248,1,240,244,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,
  // 0x0149  ŉ
  14,16,64,16,0,0,41,0,0,0,61,0,0,0,124,0,0,0,120,0,0,0,177,226,255,64,161,255,255,192,1,252,3,224,1,244,2,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,
  // 0x014a  Ŋ
  13,21,84,17,2,251,168,0,2,128,255,0,3,192,255,64,3,192,255,192,3,192,247,240,3,192,241,244,3,192,240,188,3,192,240,63,3,192,244,31,67,192,244,11,195,192,244,3,243,192,244,1,251,192,244,0,191,192,244,0,63,192,244,0,15,192,244,0,11,192,0,0,7,192,0,0,11,192,0,3,191,64,0,3,253,0,0,0,64,0,
  // 0x014b  ŋ
  10,18,54,14,2,250,225,255,64,251,255,208,253,3,240,248,1,240,244,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,0,0,240,0,0,240,0,1,240,0,43,224,0,63,192,0,4,0,
  // 0x014c  Ō
  15,20,80,17,1,255,0,255,252,0,0,170,168,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x014d  ō
  11,16,48,13,1,255,11,255,192,6,170,128,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x014e  Ŏ
  15,22,88,17,1,255,0,64,4,0,0,240,108,0,0,127,244,0,0,10,128,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x014f  ŏ
  11,18,54,13,1,255,4,0,64,11,66,192,3,255,64,0,168,0,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x0150  Ő
  15,22,88,17,1,255,0,46,46,0,0,124,124,0,0,240,240,0,1,129,128,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x0151  ő
  11,18,54,13,1,255,2,226,224,7,199,192,15,15,0,24,24,0,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x0152  Œ
  19,17,85,21,1,255,0,111,234,170,164,3,255,255,255,244,15,224,31,85,80,47,0,15,0,0,61,0,15,0,0,124,0,15,0,0,188,0,15,64,0,188,0,15,255,240,188,0,15,255,240,188,0,15,0,0,124,0,15,0,0,61,0,15,0,0,63,0,15,0,0,15,192,31,0,0,7,255,255,255,244,0,191,255,255,244,0,0,0,0,0,
  // 0x0153  œ
  19,13,65,21,1,255,2,254,1,255,64,31,255,219,255,224,62,2,255,1,244,124,0,253,0,184,184,0,125,0,188,248,0,127,255,252,248,0,126,170,168,184,0,124,0,0,124,0,189,0,0,62,1,255,64,0,31,239,235,250,244,7,255,65,255,224,0,0,0,0,0,
  // 0x0154  Ŕ
  12,21,63,14,2,0,0,31,64,0,62,0,0,184,0,0,144,0,0,0,0,170,169,0,255,255,192,249,91,240,244,1,240,244,0,244,244,0,244,244,2,240,249,91,208,255,255,64,254,190,0,244,31,0,244,11,192,244,3,208,244,2,240,244,0,252,244,0,125,
  // 0x0155  ŕ
  7,17,34,9,2,0,0,248,2,240,3,192,10,0,0,0,225,252,247,252,255,64,252,0,244,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
  // 0x0156  Ŗ
  12,21,63,14,2,251,170,169,0,255,255,192,249,91,240,244,1,240,244,0,244,244,0,244,244,2,240,249,91,208,255,255,64,254,190,0,244,31,0,244,11,192,244,3,208,244,2,240,244,0,252,244,0,125,0,0,0,0,40,0,0,184,0,0,240,0,0,208,0,
  // 0x0157  ŗ
  8,17,34,9,1,251,56,127,61,255,63,208,63,0,61,0,60,0,60,0,60,0,60,0,60,0,60,0,60,0,0,0,41,0,60,0,56,0,112,0,
  // 0x0158  Ř
  12,21,63,14,2,0,44,3,128,15,95,0,3,252,0,1,164,0,0,0,0,170,169,0,255,255,192,249,91,240,244,1,240,244,0,244,244,0,244,244,2,240,249,91,208,255,255,64,254,190,0,244,31,0,244,11,192,244,3,208,244,2,240,244,0,252,244,0,125,
  // 0x0159  ř
  8,17,34,9,1,0,116,11,46,61,15,244,2,160,0,0,56,127,61,255,63,208,63,0,61,0,60,0,60,0,60,0,60,0,60,0,60,0,60,0,
  // 0x015a  Ś
  10,22,66,12,1,255,0,15,128,0,47,0,0,124,0,0,160,0,0,0,0,6,254,64,47,255,224,126,5,208,188,0,0,184,0,0,188,0,0,63,64,0,31,248,0,2,255,64,0,31,208,0,3,240,0,1,240,0,1,240,144,3,224,255,255,192,191,254,0,0,0,0,
  // 0x015b  ś
  9,18,54,11,1,255,0,62,0,0,188,0,1,240,0,2,128,0,0,0,0,27,254,0,127,255,0,248,1,0,248,0,0,190,0,0,47,244,0,2,254,0,0,47,64,0,11,128,64,15,128,250,191,0,191,248,0,0,0,0,
  // 0x015c  Ŝ
  10,22,66,12,1,255,1,248,0,3,254,0,15,79,64,24,2,128,0,0,0,6,254,64,47,255,224,126,5,208,188,0,0,184,0,0,188,0,0,63,64,0,31,248,0,2,255,64,0,31,208,0,3,240,0,1,240,0,1,240,144,3,224,255,255,192,191,254,0,0,0,0,
  // 0x015d  ŝ
  9,18,54,11,1,255,3,224,0,15,248,0,61,45,0,100,6,0,0,0,0,27,254,0,127,255,0,248,1,0,248,0,0,190,0,0,47,244,0,2,254,0,0,47,64,0,11,128,64,15,128,250,191,0,191,248,0,0,0,0,
  // 0x015e  Ş
  10,22,66,12,1,250,6,254,64,47,255,224,126,5,208,188,0,0,184,0,0,188,0,0,63,64,0,31,248,0,2,255,64,0,31,208,0,3,240,0,1,240,0,1,240,144,3,224,255,255,192,191,254,0,1,224,0,2,240,0,0,60,0,0,60,0,11,244,0,1,0,0,
  // 0x015f  ş
  9,18,54,11,1,250,27,254,0,127,255,0,248,1,0,248,0,0,190,0,0,47,244,0,2,254,0,0,47,64,0,11,128,64,15,128,250,191,0,191,248,0,2,192,0,3,224,0,0,184,0,0,180,0,15,240,0,1,0,0,
  // 0x0160  Š
  10,22,66,12,1,255,29,2,192,11,143,64,3,253,0,0,164,0,0,0,0,6,254,64,47,255,224,126,5,208,188,0,0,184,0,0,188,0,0,63,64,0,31,248,0,2,255,64,0,31,208,0,3,240,0,1,240,0,1,240,144,3,224,255,255,192,191,254,0,0,0,0,
  // 0x0161  š
  9,18,54,11,1,255,116,11,0,46,61,0,15,244,0,2,160,0,0,0,0,27,254,0,127,255,0,248,1,0,248,0,0,190,0,0,47,244,0,2,254,0,0,47,64,0,11,128,64,15,128,250,191,0,191,248,0,0,0,0,
  // 0x0162  Ţ
  12,22,66,12,0,250,170,170,170,191,255,255,21,126,85,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,44,0,0,62,0,0,11,64,0,11,64,0,254,0,0,0,0,
  // 0x0163  ţ
  8,21,42,8,0,250,2,0,7,64,11,64,47,254,191,254,15,64,15,64,15,64,15,64,15,64,15,64,15,64,15,128,11,250,2,255,0,240,1,244,0,60,0,60,7,248,1,0,
  // 0x0164  Ť
  12,21,63,12,0,0,11,64,176,3,211,192,0,255,64,0,41,0,0,0,0,170,170,170,191,255,255,21,126,85,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,
  // 0x0165  ť
  11,18,54,8,0,255,0,0,40,0,0,120,2,0,176,7,64,144,11,64,0,47,254,0,191,254,0,15,64,0,15,64,0,15,64,0,15,64,0,15,64,0,15,64,0,15,64,0,15,128,0,11,250,0,2,255,0,0,0,0,
  // 0x0166  Ŧ
  12,16,48,12,0,0,170,170,170,191,255,255,85,126,85,0,61,0,0,61,0,0,61,0,0,61,0,15,255,244,15,255,244,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,
  // 0x0167  ŧ
  8,16,32,8,0,255,2,0,7,64,11,64,47,254,191,254,15,64,15,64,47,169,127,254,15,64,15,64,15,64,15,128,11,250,2,255,0,0,
  // 0x0168  Ũ
  13,22,88,16,2,255,0,0,16,0,3,248,112,0,11,127,224,0,8,6,64,0,0,0,0,0,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x0169  ũ
  11,18,54,14,1,255,0,0,16,7,244,176,15,191,208,8,6,64,0,0,0,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x016a  Ū
  13,20,80,16,2,255,7,255,224,0,2,170,144,0,0,0,0,0,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x016b  ū
  11,16,48,14,1,255,7,255,208,6,170,128,0,0,0,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x016c  Ŭ
  13,22,88,16,2,255,1,0,80,0,7,65,224,0,2,255,192,0,0,105,0,0,0,0,0,0,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x016d  ŭ
  11,18,54,14,1,255,5,0,64,11,65,208,3,255,128,0,105,0,0,0,0,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x016e  Ů
  13,23,92,16,2,255,0,190,0,0,0,211,64,0,1,195,128,0,0,235,64,0,0,41,0,0,0,0,0,0,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x016f  ů
  11,19,57,14,1,255,0,190,0,1,199,64,2,195,64,0,235,0,0,104,0,0,0,0,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x0170  Ű
  13,22,88,16,2,255,1,241,240,0,3,211,208,0,7,71,64,0,9,9,0,0,0,0,0,0,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x0171  ű
  11,18,54,14,1,255,1,241,240,3,211,192,11,75,64,9,8,0,0,0,0,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x0172  Ų
  13,21,84,16,2,251,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,126,0,47,255,248,0,7,255,240,0,0,2,192,0,0,3,128,0,0,7,64,0,0,7,228,0,0,2,244,0,
  // 0x0173  ų
  11,17,51,14,1,251,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,176,0,1,208,0,2,192,0,2,232,0,0,188,
  // 0x0174  Ŵ
  21,21,126,21,0,0,0,0,62,0,0,0,0,0,255,128,0,0,0,3,210,208,0,0,0,6,64,96,0,0,0,0,0,0,0,0,164,0,41,0,10,64,188,0,63,0,15,0,124,0,191,0,31,0,61,0,255,64,46,0,46,0,247,128,61,0,31,1,243,192,60,0,15,2,227,208,124,0,15,67,194,224,184,0,11,131,193,240,244,0,7,199,128,240,240,0,3,207,64,181,240,0,3,223,0,122,224,0,2,239,0,63,208,0,1,254,0,63,192,0,0,252,0,47,192,0,0,252,0,31,128,0,
  // 0x0175  ŵ
  18,17,85,18,0,0,0,2,244,0,0,0,7,252,0,0,0,31,31,0,0,0,40,2,64,0,0,0,0,0,0,184,1,240,3,208,124,3,248,3,192,60,3,252,7,192,61,7,188,11,128,46,11,109,15,64,31,15,30,31,0,15,30,15,46,0,11,109,15,125,0,7,188,7,188,0,3,252,3,252,0,3,248,3,248,0,2,244,2,244,0,
  // 0x0176  Ŷ
  13,21,84,13,0,0,0,63,0,0,0,255,128,0,2,226,224,0,6,64,96,0,0,0,0,0,168,0,10,64,124,0,31,0,62,0,62,0,31,64,124,0,11,192,248,0,3,209,240,0,2,243,208,0,0,255,192,0,0,191,64,0,0,63,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,
  // 0x0177  ŷ
  12,23,69,12,0,250,0,189,0,1,255,0,7,199,192,10,0,144,0,0,0,184,0,61,124,0,124,61,0,184,47,0,244,15,1,240,15,67,224,7,195,192,3,199,192,2,239,64,0,255,0,0,254,0,0,125,0,0,124,0,0,248,0,1,240,0,111,208,0,191,64,0,16,0,0,
  // 0x0178  Ÿ
  13,20,80,13,0,0,2,210,224,0,2,210,224,0,0,0,0,0,0,0,0,0,168,0,10,64,124,0,31,0,62,0,62,0,31,64,124,0,11,192,248,0,3,209,240,0,2,243,208,0,0,255,192,0,0,191,64,0,0,63,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,
  // 0x0179  Ź
  12,21,63,13,0,0,0,3,224,0,7,192,0,15,0,0,40,0,0,0,0,42,170,169,63,255,254,21,85,189,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,125,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,63,255,255,127,255,255,
  // 0x017a  ź
  9,17,51,10,1,0,0,62,0,0,188,0,1,240,0,2,128,0,0,0,0,191,255,64,255,255,64,0,47,0,0,61,0,0,248,0,2,240,0,7,192,0,15,64,0,62,0,0,188,0,0,255,255,128,255,255,128,
  // 0x017b  Ż
  12,21,63,13,0,0,0,4,0,0,62,0,0,62,0,0,4,0,0,0,0,42,170,169,63,255,254,21,85,189,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,125,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,63,255,255,127,255,255,
  // 0x017c  ż
  9,17,51,10,1,0,0,64,0,3,208,0,3,208,0,0,64,0,0,0,0,191,255,64,255,255,64,0,47,0,0,61,0,0,248,0,2,240,0,7,192,0,15,64,0,62,0,0,188,0,0,255,255,128,255,255,128,
  // 0x017d  Ž
  12,21,63,13,0,0,7,64,176,2,227,208,0,191,128,0,42,0,0,0,0,42,170,169,63,255,254,21,85,189,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,125,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,63,255,255,127,255,255,
  // 0x017e  ž
  9,17,51,10,1,0,180,11,0,46,60,0,15,244,0,2,144,0,0,0,0,191,255,64,255,255,64,0,47,0,0,61,0,0,248,0,2,240,0,7,192,0,15,64,0,62,0,0,188,0,0,255,255,128,255,255,128,
  // 0x017f  ſ
  6,17,34,8,2,0,11,224,127,240,248,0,244,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
};

#endif // HAS_GRAPHICAL_TFT
