/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Cyrillic 22pt, capital 'A' height: 16px, width: 100%, range: 0x0401-0x0491, glyphs: 74
extern const uint8_t NotoSans_Medium_Cyrillic_16[4473] = {
  130,16,1,4,145,4,21,250, // unifont_t
  // 0x0401  Ё
  9,20,60,12,2,0,30,31,0,30,15,0,0,0,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x0402  Ђ
  255,
  // 0x0403  Ѓ
  255,
  // 0x0404  Є
  13,17,68,14,1,255,0,47,249,0,2,255,255,64,15,228,27,0,47,64,0,0,62,0,0,0,124,0,0,0,188,0,0,0,191,255,244,0,191,255,240,0,188,0,0,0,124,0,0,0,61,0,0,0,63,0,0,0,15,208,1,0,7,255,255,0,0,191,254,0,0,0,0,0,
  // 0x0405  Ѕ
  255,
  // 0x0406  І
  6,16,32,8,1,0,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,
  // 0x0407  Ї
  6,20,40,8,1,0,240,240,240,240,0,0,0,0,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,
  // 0x0408  Ј
  255,
  // 0x0409  Љ
  255,
  // 0x040a  Њ
  255,
  // 0x040b  Ћ
  255,
  // 0x040c  Ќ
  255,
  // 0x040d  Ѝ
  255,
  // 0x040e  Ў
  255,
  // 0x040f  Џ
  255,
  // 0x0410  А
  14,16,64,14,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x0411  Б
  11,16,48,14,2,0,170,170,144,255,255,224,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,64,255,255,224,244,2,244,244,0,248,244,0,248,244,0,244,244,7,240,255,255,208,255,254,0,
  // 0x0412  В
  11,16,48,14,2,0,170,169,0,255,255,224,249,87,244,244,0,248,244,0,184,244,0,248,248,6,240,255,255,128,255,255,224,244,0,252,244,0,124,244,0,124,244,0,188,244,1,252,255,255,240,255,255,128,
  // 0x0413  Г
  10,16,48,12,2,0,170,170,128,255,255,208,249,85,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,
  // 0x0414  Д
  15,21,84,16,0,251,0,26,170,128,0,63,255,192,0,62,87,192,0,60,3,192,0,124,3,192,0,124,3,192,0,184,3,192,0,244,3,192,1,240,3,192,2,224,3,192,3,208,3,192,7,192,3,192,15,128,3,192,31,0,3,192,255,255,255,252,255,255,255,252,244,0,0,60,244,0,0,60,244,0,0,60,244,0,0,60,16,0,0,20,
  // 0x0415  Е
  9,16,48,12,2,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x0416  Ж
  19,16,80,19,0,0,104,0,104,0,168,62,0,124,1,240,15,64,124,3,208,7,192,124,15,128,2,240,124,47,0,0,184,124,124,0,0,61,124,244,0,0,15,191,224,0,0,31,191,224,0,0,61,124,244,0,0,248,124,124,0,2,240,124,47,0,7,208,124,15,128,15,128,124,3,208,63,0,124,1,240,188,0,124,0,188,
  // 0x0417  З
  11,17,51,13,1,255,6,254,64,191,255,224,184,2,248,0,0,252,0,0,188,0,0,248,0,7,224,15,254,64,15,255,208,0,2,248,0,0,124,0,0,124,0,0,124,128,1,248,255,175,240,191,255,128,0,0,0,
  // 0x0418  И
  13,16,64,17,2,0,160,0,10,128,244,0,31,192,244,0,63,192,244,0,191,192,244,1,247,192,244,3,227,192,244,11,195,192,244,15,67,192,244,62,3,192,244,188,3,192,244,244,3,192,243,224,3,192,251,192,3,192,255,64,3,192,255,0,3,192,252,0,3,192,
  // 0x0419  Й
  13,21,84,17,2,0,6,64,40,0,7,192,60,0,3,250,244,0,0,111,144,0,0,0,0,0,160,0,10,128,244,0,31,192,244,0,63,192,244,0,191,192,244,1,247,192,244,3,227,192,244,11,195,192,244,15,67,192,244,62,3,192,244,188,3,192,244,244,3,192,243,224,3,192,251,192,3,192,255,64,3,192,255,0,3,192,252,0,3,192,
  // 0x041a  К
  12,16,48,14,2,0,164,0,40,244,0,248,244,3,224,244,11,192,244,47,0,244,124,0,245,244,0,251,224,0,251,224,0,245,244,0,244,125,0,244,47,0,244,15,192,244,3,240,244,0,248,244,0,126,
  // 0x041b  Л
  14,17,68,16,0,255,0,42,170,160,0,127,255,224,0,189,87,224,0,184,2,224,0,244,2,224,0,244,2,224,0,240,2,224,1,240,2,224,1,240,2,224,2,224,2,224,2,224,2,224,3,208,2,224,3,192,2,224,11,192,2,224,255,64,2,224,254,0,2,224,0,0,0,0,
  // 0x041c  М
  16,16,64,20,2,0,169,0,0,106,255,0,0,191,255,64,0,255,251,128,1,239,247,192,3,223,243,208,3,207,241,224,11,79,240,240,15,15,244,180,30,15,244,124,45,15,244,60,60,15,244,45,120,15,244,31,244,15,244,15,240,15,244,11,224,15,244,3,192,15,
  // 0x041d  Н
  13,16,64,16,2,0,164,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,248,0,15,64,255,255,255,64,255,255,255,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,
  // 0x041e  О
  15,17,68,17,1,255,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x041f  П
  12,16,48,16,2,0,170,170,170,255,255,255,249,85,111,244,0,31,244,0,31,244,0,31,244,0,31,244,0,31,244,0,31,244,0,31,244,0,31,244,0,31,244,0,31,244,0,31,244,0,31,244,0,31,
  // 0x0420  Р
  11,16,48,13,2,0,170,169,0,255,255,192,249,91,224,244,2,240,244,0,244,244,0,244,244,1,240,244,7,224,255,255,192,255,253,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,
  // 0x0421  С
  12,17,51,14,1,255,0,111,232,2,255,255,15,228,26,47,64,0,62,0,0,124,0,0,188,0,0,188,0,0,188,0,0,188,0,0,124,0,0,61,0,0,63,0,0,15,208,1,7,255,254,0,191,253,0,0,0,
  // 0x0422  Т
  12,16,48,12,0,0,170,170,170,191,255,255,21,126,85,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,
  // 0x0423  У
  14,17,68,14,0,255,104,0,1,160,61,0,3,208,47,0,7,192,15,64,15,128,11,192,31,0,3,208,46,0,2,240,60,0,0,244,188,0,0,188,244,0,0,62,240,0,0,47,208,0,0,15,192,0,0,31,128,0,0,63,0,0,63,253,0,0,63,240,0,0,0,0,0,0,
  // 0x0424  Ф
  16,17,68,18,1,255,0,3,192,0,0,3,192,0,1,191,254,64,15,255,255,240,63,67,193,252,124,3,192,62,248,3,192,47,244,3,192,31,244,3,192,31,184,3,192,46,125,3,192,125,47,151,214,252,11,255,255,224,0,111,249,0,0,3,192,0,0,3,192,0,0,0,0,0,
  // 0x0425  Х
  13,16,64,13,0,0,104,0,10,128,63,0,31,0,15,64,62,0,11,192,188,0,3,224,244,0,0,247,224,0,0,191,192,0,0,63,64,0,0,63,128,0,0,255,192,0,1,242,240,0,3,208,244,0,11,128,124,0,31,0,62,0,62,0,31,64,188,0,11,192,
  // 0x0426  Ц
  14,21,84,17,2,251,164,0,10,0,244,0,31,0,244,0,31,0,244,0,31,0,244,0,31,0,244,0,31,0,244,0,31,0,244,0,31,0,244,0,31,0,244,0,31,0,244,0,31,0,244,0,31,0,244,0,31,0,248,0,31,0,255,255,255,240,255,255,255,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,80,
  // 0x0427  Ч
  13,16,64,16,1,0,104,0,10,64,124,0,15,64,124,0,15,64,124,0,15,64,124,0,15,64,124,0,15,64,124,0,15,64,125,0,15,64,63,150,255,64,31,255,255,64,1,169,15,64,0,0,15,64,0,0,15,64,0,0,15,64,0,0,15,64,0,0,15,64,
  // 0x0428  Ш
  19,16,80,23,2,0,164,0,104,0,104,244,0,184,0,124,244,0,184,0,124,244,0,184,0,124,244,0,184,0,124,244,0,184,0,124,244,0,184,0,124,244,0,184,0,124,244,0,184,0,124,244,0,184,0,124,244,0,184,0,124,244,0,184,0,124,244,0,184,0,124,248,0,184,0,124,255,255,255,255,252,255,255,255,255,252,
  // 0x0429  Щ
  21,21,126,23,2,251,164,0,164,0,104,0,244,0,248,0,188,0,244,0,248,0,188,0,244,0,248,0,188,0,244,0,248,0,188,0,244,0,248,0,188,0,244,0,248,0,188,0,244,0,248,0,188,0,244,0,248,0,188,0,244,0,248,0,188,0,244,0,248,0,188,0,244,0,248,0,188,0,244,0,248,0,188,0,248,0,248,0,188,0,255,255,255,255,255,192,255,255,255,255,255,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,11,192,0,0,0,0,1,0,
  // 0x042a  Ъ
  15,16,64,15,0,0,170,160,0,0,255,240,0,0,85,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,244,0,0,0,255,254,0,0,255,255,208,0,240,3,240,0,240,0,244,0,240,0,244,0,240,1,240,0,240,7,240,0,255,255,192,0,255,254,0,
  // 0x042b  Ы
  15,16,64,19,2,0,164,0,0,40,244,0,0,124,244,0,0,124,244,0,0,124,244,0,0,124,244,0,0,124,248,0,0,124,255,255,64,124,255,255,208,124,244,2,240,124,244,0,244,124,244,0,244,124,244,1,244,124,244,7,240,124,255,255,208,124,255,254,0,124,
  // 0x042c  Ь
  11,16,48,14,2,0,164,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,240,244,1,248,244,0,188,244,0,124,244,0,188,244,2,248,255,255,224,255,254,64,
  // 0x042d  Э
  12,17,51,14,1,255,43,249,0,255,255,192,164,27,240,0,0,248,0,0,124,0,0,61,0,0,62,15,255,254,15,255,254,0,0,62,0,0,62,0,0,124,0,0,252,64,7,240,255,255,208,191,254,0,0,0,0,
  // 0x042e  Ю
  20,17,85,23,2,255,164,0,11,254,0,244,0,191,255,208,244,1,253,7,244,244,3,224,0,252,244,7,192,0,61,244,15,128,0,62,248,15,128,0,47,255,255,64,0,47,255,255,64,0,47,244,15,128,0,47,244,15,128,0,62,244,11,192,0,61,244,3,224,0,188,244,2,244,2,244,244,0,191,255,224,244,0,31,255,64,0,0,0,0,0,
  // 0x042f  Я
  12,16,48,14,0,0,0,42,170,3,255,255,15,229,95,15,64,15,31,0,15,31,0,15,15,128,15,11,245,95,1,255,255,0,190,175,0,244,15,3,240,15,7,192,15,15,128,15,47,0,15,125,0,15,
  // 0x0430  а
  10,13,39,13,1,255,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x0431  б
  11,18,54,13,1,255,0,1,104,0,191,252,7,255,148,31,128,0,62,0,0,124,0,0,188,191,128,191,255,240,255,0,248,252,0,188,248,0,124,184,0,124,188,0,124,124,0,188,63,0,244,15,239,240,3,255,128,0,0,0,
  // 0x0432  в
  10,12,36,13,2,0,255,250,0,255,255,192,240,7,224,240,3,224,240,7,192,255,255,0,254,191,192,240,2,240,240,1,240,240,3,240,255,255,208,255,254,64,
  // 0x0433  г
  8,12,24,10,2,0,255,253,255,253,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
  // 0x0434  д
  13,17,68,13,0,251,0,191,252,0,0,255,252,0,0,244,60,0,0,240,60,0,1,240,60,0,2,224,60,0,3,208,60,0,3,192,60,0,11,128,60,0,31,0,60,0,191,255,255,192,191,255,255,192,184,0,7,192,184,0,7,192,184,0,7,192,184,0,7,192,0,0,0,0,
  // 0x0435  е
  11,13,39,13,1,255,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x0436  ж
  17,12,60,17,0,0,60,1,224,15,64,31,1,224,46,0,11,193,224,188,0,3,225,225,240,0,0,245,227,208,0,0,62,255,64,0,0,126,255,128,0,0,245,227,208,0,3,209,224,244,0,15,129,224,124,0,47,1,224,47,0,188,1,224,11,192,
  // 0x0437  з
  10,13,39,11,0,255,27,254,64,63,255,208,0,2,240,0,1,240,0,7,208,3,255,64,2,191,192,0,2,240,0,0,240,16,1,240,127,175,224,47,255,64,0,0,0,
  // 0x0438  и
  11,12,36,15,2,0,240,1,248,240,3,252,240,11,252,240,15,124,240,61,124,240,124,124,240,240,124,243,224,124,247,192,124,255,64,124,254,0,124,252,0,124,
  // 0x0439  й
  11,17,51,15,2,0,45,1,224,46,2,224,15,255,192,1,169,0,0,0,0,240,1,248,240,3,252,240,11,252,240,15,124,240,61,124,240,124,124,240,240,124,243,224,124,247,192,124,255,64,124,254,0,124,252,0,124,
  // 0x043a  к
  10,12,36,12,2,0,240,7,192,240,15,64,240,62,0,240,248,0,242,240,0,251,192,0,251,208,0,242,240,0,240,188,0,240,63,0,240,15,128,240,3,224,
  // 0x043b  л
  12,13,39,13,0,255,1,255,253,1,255,253,2,224,61,2,208,61,3,208,61,3,208,61,3,192,61,7,192,61,11,128,61,15,64,61,191,0,61,252,0,61,0,0,0,
  // 0x043c  м
  13,12,48,17,2,0,252,0,15,192,254,0,31,192,255,0,63,192,251,64,63,192,247,128,183,192,243,192,243,192,242,209,227,192,240,243,195,192,240,247,195,192,240,127,67,192,240,63,3,192,240,46,3,192,
  // 0x043d  н
  11,12,36,14,2,0,240,0,244,240,0,244,240,0,244,240,0,244,240,0,244,255,255,244,255,255,244,240,0,244,240,0,244,240,0,244,240,0,244,240,0,244,
  // 0x043e  о
  11,13,39,13,1,255,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x043f  п
  10,12,36,14,2,0,255,255,240,255,255,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,240,1,240,
  // 0x0440  р
  11,18,54,14,2,250,226,254,0,251,255,192,253,3,240,248,1,240,244,0,244,240,0,244,240,0,244,244,0,244,248,1,240,252,3,240,255,239,208,242,255,64,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,80,0,0,
  // 0x0441  с
  9,13,39,11,1,255,2,255,128,31,255,128,63,0,0,124,0,0,184,0,0,248,0,0,248,0,0,248,0,0,188,0,0,62,0,64,47,255,192,7,255,128,0,0,0,
  // 0x0442  т
  11,12,36,11,0,0,127,255,244,191,255,248,0,184,0,0,184,0,0,184,0,0,184,0,0,184,0,0,184,0,0,184,0,0,184,0,0,184,0,0,184,0,
  // 0x0443  у
  12,18,54,12,0,250,184,0,61,124,0,124,61,0,184,47,0,244,15,1,240,15,67,224,7,195,192,3,199,192,2,239,64,0,255,0,0,254,0,0,125,0,0,124,0,0,248,0,1,240,0,111,208,0,191,64,0,16,0,0,
  // 0x0444  ф
  15,23,92,17,1,250,0,10,64,0,0,15,64,0,0,15,64,0,0,15,64,0,0,15,64,0,1,191,248,0,15,255,255,64,63,79,75,208,125,15,67,240,188,15,65,240,248,15,64,244,248,15,64,244,188,15,64,240,124,15,66,240,63,15,75,208,15,255,255,128,1,255,249,0,0,15,64,0,0,15,64,0,0,15,64,0,0,15,64,0,0,15,64,0,0,1,0,0,
  // 0x0445  х
  12,12,36,12,0,0,61,0,124,47,0,244,15,131,240,3,215,192,1,255,64,0,254,0,0,255,0,2,255,64,7,215,192,15,130,240,47,0,248,125,0,125,
  // 0x0446  ц
  12,17,51,14,2,251,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,255,255,255,255,255,255,0,0,31,0,0,31,0,0,31,0,0,31,0,0,0,
  // 0x0447  ч
  11,12,36,14,1,0,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,1,252,63,175,252,15,253,124,0,0,124,0,0,124,0,0,124,0,0,124,
  // 0x0448  ш
  17,12,60,20,2,0,240,3,192,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,255,255,255,255,64,255,255,255,255,64,
  // 0x0449  щ
  18,17,85,20,2,251,240,3,192,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,240,3,208,15,64,255,255,255,255,240,255,255,255,255,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,0,0,0,
  // 0x044a  ъ
  15,12,48,15,0,0,191,244,0,0,191,244,0,0,0,244,0,0,0,244,0,0,0,244,0,0,0,255,255,128,0,254,191,240,0,244,1,240,0,244,0,244,0,244,1,240,0,255,255,224,0,255,255,64,
  // 0x044b  ы
  14,12,48,18,2,0,240,0,1,224,240,0,2,240,240,0,2,240,240,0,2,240,240,0,2,240,255,254,2,240,254,191,194,240,240,3,210,240,240,3,226,240,240,7,210,240,255,255,194,240,255,254,2,240,
  // 0x044c  ь
  10,12,36,13,2,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,255,255,64,254,191,224,240,2,240,240,0,240,240,2,240,255,255,208,255,254,64,
  // 0x044d  э
  10,13,39,11,0,255,47,248,0,63,255,64,0,11,192,0,3,208,0,2,224,15,255,240,15,255,240,0,2,224,0,3,208,0,11,192,126,255,64,63,248,0,0,0,0,
  // 0x044e  ю
  16,13,52,19,2,255,240,1,255,128,240,11,255,240,240,31,64,248,240,62,0,124,240,61,0,61,255,253,0,61,255,253,0,61,240,61,0,61,240,62,0,124,240,31,64,252,240,15,251,240,240,2,255,128,0,0,0,0,
  // 0x044f  я
  11,12,36,13,0,0,2,255,248,31,255,248,62,0,184,61,0,184,61,0,184,47,149,248,11,255,248,2,245,248,7,192,184,15,64,184,47,0,184,124,0,184,
  // 0x0450  ѐ
  255,
  // 0x0451  ё
  11,17,51,13,1,255,15,75,64,15,75,64,0,0,0,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x0452  ђ
  255,
  // 0x0453  ѓ
  255,
  // 0x0454  є
  9,13,39,11,1,255,2,255,128,31,255,192,62,0,0,124,0,0,184,0,0,255,255,0,255,255,0,184,0,0,188,0,0,62,0,0,31,239,192,7,255,192,0,0,0,
  // 0x0455  ѕ
  255,
  // 0x0456  і
  2,17,17,6,2,0,80,240,240,0,0,240,240,240,240,240,240,240,240,240,240,240,240,
  // 0x0457  ї
  6,16,32,6,0,0,240,240,240,240,0,0,0,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,
  // 0x0458  ј
  255,
  // 0x0459  љ
  255,
  // 0x045a  њ
  255,
  // 0x045b  ћ
  255,
  // 0x045c  ќ
  255,
  // 0x045d  ѝ
  255,
  // 0x045e  ў
  255,
  // 0x045f  џ
  255,
  // 0x0460  Ѡ
  255,
  // 0x0461  ѡ
  255,
  // 0x0462  Ѣ
  255,
  // 0x0463  ѣ
  255,
  // 0x0464  Ѥ
  255,
  // 0x0465  ѥ
  255,
  // 0x0466  Ѧ
  255,
  // 0x0467  ѧ
  255,
  // 0x0468  Ѩ
  255,
  // 0x0469  ѩ
  255,
  // 0x046a  Ѫ
  255,
  // 0x046b  ѫ
  255,
  // 0x046c  Ѭ
  255,
  // 0x046d  ѭ
  255,
  // 0x046e  Ѯ
  255,
  // 0x046f  ѯ
  255,
  // 0x0470  Ѱ
  255,
  // 0x0471  ѱ
  255,
  // 0x0472  Ѳ
  255,
  // 0x0473  ѳ
  255,
  // 0x0474  Ѵ
  255,
  // 0x0475  ѵ
  255,
  // 0x0476  Ѷ
  255,
  // 0x0477  ѷ
  255,
  // 0x0478  Ѹ
  255,
  // 0x0479  ѹ
  255,
  // 0x047a  Ѻ
  255,
  // 0x047b  ѻ
  255,
  // 0x047c  Ѽ
  255,
  // 0x047d  ѽ
  255,
  // 0x047e  Ѿ
  255,
  // 0x047f  ѿ
  255,
  // 0x0480  Ҁ
  255,
  // 0x0481  ҁ
  255,
  // 0x0482  ҂
  255,
  // 0x0483  ҃
  255,
  // 0x0484  ҄
  255,
  // 0x0485  ҅
  255,
  // 0x0486  ҆
  255,
  // 0x0487  ҇
  255,
  // 0x0488  ҈
  255,
  // 0x0489  ҉
  255,
  // 0x048a  Ҋ
  255,
  // 0x048b  ҋ
  255,
  // 0x048c  Ҍ
  255,
  // 0x048d  ҍ
  255,
  // 0x048e  Ҏ
  255,
  // 0x048f  ҏ
  255,
  // 0x0490  Ґ
  10,19,57,12,2,0,0,2,224,0,2,224,0,2,224,170,171,224,255,255,224,249,85,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,
  // 0x0491  ґ
  8,16,32,10,2,0,0,4,0,46,0,46,0,46,255,254,255,253,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
};

#endif // HAS_GRAPHICAL_TFT
