/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium ASCII 22pt, capital 'A' height: 16px, width: 100%, range: 0x0020-0x007e
extern const uint8_t NotoSans_Medium_ASCII_16[4704] = {
  130,16,32,0,126,0,21,250, // unifont_t
  // 0x0020 " "
  0,0,0,6,0,0,
  // 0x0021  !
  4,17,17,6,1,255,41,125,61,60,60,60,60,60,60,60,60,20,0,40,125,125,0,
  // 0x0022  "
  7,6,12,9,1,10,104,104,120,124,120,60,120,56,52,56,52,56,
  // 0x0023  #
  14,16,64,14,0,0,0,24,10,0,0,60,14,0,0,60,29,0,0,56,44,0,0,116,60,0,47,255,255,224,26,250,190,144,0,240,116,0,0,224,176,0,2,224,244,0,127,255,255,192,23,214,245,64,3,193,208,0,3,130,208,0,7,66,192,0,7,67,192,0,
  // 0x0024  $
  11,19,57,13,1,254,0,96,0,0,112,0,6,254,128,63,255,240,189,177,144,184,112,0,188,112,0,127,176,0,31,249,0,2,255,192,0,123,240,0,112,244,0,112,244,144,114,240,255,255,208,111,254,0,0,112,0,0,112,0,0,16,0,
  // 0x0025  %
  17,17,85,19,1,255,31,128,1,144,0,127,240,3,192,0,180,180,7,64,0,240,120,15,0,0,240,56,45,0,0,240,56,60,0,0,240,120,180,164,0,180,181,227,254,0,63,243,203,143,64,31,135,143,7,128,0,15,15,3,128,0,29,15,3,192,0,60,15,3,128,0,180,11,7,64,0,240,7,239,0,2,208,2,253,0,0,0,0,0,0,
  // 0x0026  &
  15,17,68,16,1,255,1,254,0,0,15,255,192,0,31,67,224,0,31,2,224,0,31,3,224,0,15,139,192,0,7,255,0,0,3,252,0,0,31,253,0,240,62,31,66,240,188,7,227,208,248,1,255,192,248,0,127,64,189,0,255,128,63,255,251,224,11,255,129,248,0,0,0,0,
  // 0x0027  '
  3,6,6,5,1,10,104,120,120,120,52,52,
  // 0x0028  (
  5,20,40,7,1,252,2,128,11,64,31,0,61,0,60,0,184,0,180,0,244,0,240,0,240,0,240,0,240,0,244,0,184,0,124,0,60,0,46,0,31,0,11,128,1,64,
  // 0x0029  )
  5,20,40,7,1,252,160,0,184,0,60,0,46,0,15,0,15,64,11,128,7,192,7,192,7,192,7,192,7,192,7,192,11,128,15,64,15,0,46,0,60,0,180,0,80,0,
  // 0x002a  *
  10,11,33,12,1,6,0,160,0,0,240,0,0,240,0,144,240,96,255,255,240,171,254,160,3,252,0,11,174,0,31,15,64,30,11,64,0,0,0,
  // 0x002b  +
  11,11,33,13,1,2,0,176,0,0,176,0,0,176,0,0,176,0,170,250,164,255,255,244,0,180,0,0,176,0,0,176,0,0,176,0,0,96,0,
  // 0x002c  ,
  3,6,6,6,1,253,40,60,124,184,240,224,
  // 0x002d  -
  6,3,6,7,1,4,255,192,255,208,0,0,
  // 0x002e  .
  4,4,4,6,1,255,56,125,125,0,
  // 0x002f  /
  8,16,32,8,0,0,0,10,0,31,0,61,0,60,0,184,0,244,1,240,2,224,3,192,7,192,15,64,15,0,30,0,61,0,60,0,184,0,
  // 0x0030  0
  11,17,51,13,1,255,2,253,0,15,255,128,62,7,208,124,2,240,184,0,240,244,0,244,244,0,248,244,0,248,244,0,248,244,0,248,244,0,244,184,0,240,124,1,240,62,3,224,31,255,192,7,254,0,0,0,0,
  // 0x0031  1
  6,16,32,13,2,0,0,160,7,240,47,240,189,240,176,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,
  // 0x0032  2
  11,16,48,13,1,0,6,253,0,127,255,192,125,7,224,16,2,240,0,1,240,0,2,240,0,3,208,0,11,192,0,31,0,0,125,0,1,244,0,7,208,0,31,64,0,125,0,0,255,255,248,255,255,248,
  // 0x0033  3
  11,17,51,13,1,255,11,254,0,191,255,192,120,7,224,0,2,240,0,1,240,0,3,224,0,27,192,11,253,0,11,255,128,0,7,240,0,0,244,0,0,244,0,0,244,128,3,240,255,191,208,191,254,0,0,0,0,
  // 0x0034  4
  12,16,48,13,0,0,0,1,240,0,3,240,0,15,240,0,46,240,0,125,240,0,241,240,2,209,240,7,129,240,15,1,240,45,1,240,125,86,245,191,255,255,106,170,250,0,1,240,0,1,240,0,1,240,
  // 0x0035  5
  11,17,51,13,1,255,42,170,128,63,255,208,62,85,64,60,0,0,60,0,0,60,0,0,62,169,0,127,255,192,21,27,240,0,1,240,0,0,244,0,0,244,0,1,240,64,3,240,191,255,192,127,254,0,0,0,0,
  // 0x0036  6
  11,17,51,13,1,255,0,111,208,3,255,208,15,208,0,62,0,0,60,0,0,184,0,0,184,190,64,251,255,224,254,2,240,248,0,244,244,0,184,184,0,184,124,0,244,62,2,240,31,255,208,7,255,64,0,0,0,
  // 0x0037  7
  11,16,48,13,1,0,170,170,164,255,255,248,85,85,244,0,1,240,0,3,208,0,7,192,0,15,128,0,31,0,0,46,0,0,61,0,0,188,0,0,244,0,2,240,0,3,208,0,7,192,0,15,128,0,
  // 0x0038  8
  11,17,51,13,1,255,6,254,0,47,255,192,61,3,240,124,1,240,124,1,240,61,3,224,31,159,192,7,254,0,15,255,64,62,7,224,184,1,244,244,0,248,244,0,248,188,1,240,63,175,224,11,255,64,0,0,0,
  // 0x0039  9
  11,17,51,13,1,255,6,249,0,47,255,128,126,7,208,184,1,240,244,0,240,244,0,244,244,0,248,188,2,248,63,175,244,31,252,244,0,0,240,0,1,240,0,3,224,0,11,192,42,255,0,63,248,0,0,0,0,
  // 0x003a  :
  4,13,13,6,1,255,60,125,60,0,0,0,0,0,0,56,125,125,0,
  // 0x003b  ;
  4,15,15,6,1,253,124,189,60,0,0,0,0,0,0,40,124,184,244,240,208,
  // 0x003c  <
  11,11,33,13,1,2,0,0,120,0,7,244,0,127,64,7,244,0,127,64,0,253,0,0,47,208,0,1,254,0,0,31,244,0,0,184,0,0,0,
  // 0x003d  =
  11,7,21,13,1,4,191,255,244,255,255,244,0,0,0,0,0,0,85,85,80,255,255,244,85,85,80,
  // 0x003e  >
  11,11,33,13,1,2,244,0,0,191,64,0,11,244,0,0,191,64,0,11,240,0,2,244,0,111,208,7,249,0,191,128,0,244,0,0,64,0,0,
  // 0x003f  ?
  9,17,51,10,0,255,27,249,0,191,255,64,52,11,192,0,3,192,0,3,192,0,7,192,0,31,64,0,189,0,1,244,0,3,208,0,3,192,0,1,64,0,0,0,0,2,192,0,7,224,0,3,208,0,0,0,0,
  // 0x0040  @
  18,18,90,20,1,254,0,1,169,0,0,0,127,255,240,0,2,244,0,189,0,11,128,0,15,0,30,0,85,7,192,60,11,255,195,192,56,46,7,193,208,180,60,3,129,224,176,120,3,129,208,176,116,7,129,208,176,120,11,130,192,176,60,31,195,128,116,31,249,255,0,60,6,144,100,0,46,0,0,0,0,15,192,0,80,0,2,255,175,208,0,0,27,254,64,0,
  // 0x0041  A
  14,16,64,14,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x0042  B
  11,16,48,14,2,0,170,169,0,255,255,224,249,87,244,244,0,248,244,0,184,244,0,248,248,6,240,255,255,128,255,255,224,244,0,252,244,0,124,244,0,124,244,0,188,244,1,252,255,255,240,255,255,128,
  // 0x0043  C
  12,17,51,14,1,255,0,111,232,2,255,255,15,228,26,47,64,0,62,0,0,124,0,0,188,0,0,188,0,0,188,0,0,188,0,0,124,0,0,61,0,0,63,0,0,15,208,1,7,255,254,0,191,253,0,0,0,
  // 0x0044  D
  13,16,64,16,2,0,170,169,0,0,255,255,224,0,249,87,252,0,244,0,126,0,244,0,47,0,244,0,15,64,244,0,15,128,244,0,11,192,244,0,11,192,244,0,15,128,244,0,15,128,244,0,31,0,244,0,126,0,244,6,252,0,255,255,240,0,255,254,64,0,
  // 0x0045  E
  9,16,48,12,2,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x0046  F
  9,16,48,12,2,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,244,0,0,254,170,64,255,255,128,249,85,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,
  // 0x0047  G
  14,17,68,16,1,255,0,27,250,0,2,255,255,192,11,244,6,128,31,128,0,0,62,0,0,0,124,0,0,0,188,0,0,0,188,0,85,64,188,1,255,208,188,0,171,208,124,0,3,208,61,0,3,208,63,0,3,208,15,208,3,208,7,255,255,208,0,191,255,128,0,0,0,0,
  // 0x0048  H
  13,16,64,16,2,0,164,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,248,0,15,64,255,255,255,64,255,255,255,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,
  // 0x0049  I
  6,16,32,8,1,0,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,
  // 0x004a  J
  7,21,42,6,254,251,0,164,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,2,240,191,224,191,128,20,0,
  // 0x004b  K
  12,16,48,14,2,0,164,0,41,244,0,248,244,3,240,244,11,192,244,47,0,244,124,0,245,244,0,251,240,0,255,248,0,252,125,0,244,63,0,244,15,128,244,7,208,244,2,240,244,0,252,244,0,62,
  // 0x004c  L
  9,16,48,12,2,0,164,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x004d  M
  16,16,64,20,2,0,169,0,0,106,255,0,0,191,255,64,0,255,251,128,1,239,247,192,3,223,243,208,3,207,241,224,11,79,240,240,15,15,244,180,30,15,244,124,45,15,244,60,60,15,244,45,120,15,244,31,244,15,244,15,240,15,244,11,224,15,244,3,192,15,
  // 0x004e  N
  13,16,64,17,2,0,168,0,2,128,254,0,3,192,255,64,3,192,255,192,3,192,247,224,3,192,241,240,3,192,240,252,3,192,240,61,3,192,244,47,3,192,244,15,131,192,244,7,211,192,244,2,243,192,244,0,251,192,244,0,127,192,244,0,63,192,244,0,15,192,
  // 0x004f  O
  15,17,68,17,1,255,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x0050  P
  11,16,48,13,2,0,170,169,0,255,255,192,249,91,224,244,2,240,244,0,244,244,0,244,244,1,240,244,7,224,255,255,192,255,253,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,
  // 0x0051  Q
  15,20,80,17,1,252,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,253,0,0,0,189,0,0,0,63,64,0,0,15,192,0,0,2,160,
  // 0x0052  R
  12,16,48,14,2,0,170,169,0,255,255,192,249,91,240,244,1,240,244,0,244,244,0,244,244,2,240,249,91,208,255,255,64,254,190,0,244,31,0,244,11,192,244,3,208,244,2,240,244,0,252,244,0,125,
  // 0x0053  S
  10,17,51,12,1,255,6,254,64,47,255,224,126,5,208,188,0,0,184,0,0,188,0,0,63,64,0,31,248,0,2,255,64,0,31,208,0,3,240,0,1,240,0,1,240,144,3,224,255,255,192,191,254,0,0,0,0,
  // 0x0054  T
  12,16,48,12,0,0,170,170,170,191,255,255,21,126,85,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,
  // 0x0055  U
  13,17,68,16,2,255,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x0056  V
  14,16,64,14,0,0,164,0,2,144,188,0,7,192,60,0,11,192,62,0,15,64,47,0,31,0,15,0,46,0,15,128,61,0,7,192,124,0,3,192,184,0,3,224,244,0,1,241,240,0,0,242,224,0,0,187,192,0,0,127,192,0,0,63,128,0,0,47,0,0,
  // 0x0057  W
  21,16,96,21,0,0,164,0,41,0,10,64,188,0,63,0,15,0,124,0,191,0,31,0,61,0,255,64,46,0,46,0,247,128,61,0,31,1,243,192,60,0,15,2,227,208,124,0,15,67,194,224,184,0,11,131,193,240,244,0,7,199,128,240,240,0,3,207,64,181,240,0,3,223,0,122,224,0,2,239,0,63,208,0,1,254,0,63,192,0,0,252,0,47,192,0,0,252,0,31,128,0,
  // 0x0058  X
  13,16,64,13,0,0,104,0,10,128,63,0,31,0,15,64,62,0,11,192,188,0,3,224,244,0,0,247,224,0,0,191,192,0,0,63,64,0,0,63,128,0,0,255,192,0,1,242,240,0,3,208,244,0,11,128,124,0,31,0,62,0,62,0,31,64,188,0,11,192,
  // 0x0059  Y
  13,16,64,13,0,0,168,0,10,64,124,0,31,0,62,0,62,0,31,64,124,0,11,192,248,0,3,209,240,0,2,243,208,0,0,255,192,0,0,191,64,0,0,63,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,
  // 0x005a  Z
  12,16,48,13,0,0,42,170,169,63,255,254,21,85,189,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,125,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,63,255,255,127,255,255,
  // 0x005b  [
  6,20,40,7,1,252,42,144,127,224,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,125,64,127,224,21,80,
  // 0x005c "\"
  8,16,32,8,0,0,100,0,124,0,60,0,46,0,15,0,15,64,7,128,3,192,2,208,1,240,0,240,0,184,0,124,0,61,0,46,0,15,
  // 0x005d  ]
  6,20,40,7,0,252,106,144,127,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,22,224,127,224,21,80,
  // 0x005e  ^
  11,11,33,13,1,5,0,160,0,0,244,0,2,252,0,3,157,0,11,15,0,15,7,64,45,3,192,60,1,208,116,0,240,240,0,116,0,0,0,
  // 0x005f  _
  10,2,6,10,0,252,255,255,224,85,85,64,
  // 0x0060  `
  5,4,8,7,1,13,248,0,61,0,15,0,2,64,
  // 0x0061  a
  10,13,39,13,1,255,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x0062  b
  11,18,54,14,2,255,160,0,0,240,0,0,240,0,0,240,0,0,240,0,0,242,254,0,251,255,192,253,3,240,248,1,240,244,0,244,240,0,244,240,0,244,244,0,244,248,1,240,252,3,240,255,239,208,226,255,64,0,0,0,
  // 0x0063  c
  9,13,39,11,1,255,2,255,128,31,255,128,63,0,0,124,0,0,184,0,0,248,0,0,248,0,0,248,0,0,188,0,0,62,0,64,47,255,192,7,255,128,0,0,0,
  // 0x0064  d
  11,18,54,14,1,255,0,0,104,0,0,188,0,0,188,0,0,188,0,0,188,7,253,124,47,255,252,62,2,252,188,0,252,184,0,188,248,0,124,248,0,124,248,0,188,188,0,252,62,1,252,47,239,252,11,253,60,0,0,0,
  // 0x0065  e
  11,13,39,13,1,255,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x0066  f
  9,17,51,8,0,0,0,110,64,3,255,64,7,208,0,11,192,0,11,128,0,47,254,0,191,254,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,
  // 0x0067  g
  11,18,54,14,1,250,7,253,56,31,255,188,62,2,252,188,0,252,184,0,188,248,0,124,248,0,124,248,0,124,188,0,188,62,1,252,47,239,252,11,253,124,0,0,188,0,0,184,16,1,244,63,171,240,47,255,128,0,16,0,
  // 0x0068  h
  10,17,51,14,2,0,160,0,0,240,0,0,240,0,0,240,0,0,240,0,0,241,255,64,251,255,208,253,3,240,248,1,240,244,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,
  // 0x0069  i
  2,17,17,6,2,0,80,240,240,0,0,240,240,240,240,240,240,240,240,240,240,240,240,
  // 0x006a  j
  6,23,46,6,254,250,0,80,0,240,0,240,0,0,0,0,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,1,240,43,224,127,192,4,0,
  // 0x006b  k
  10,17,51,12,2,0,160,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,3,208,240,15,128,240,62,0,240,248,0,243,224,0,251,208,0,255,240,0,248,252,0,240,62,0,240,31,64,240,11,192,240,3,240,
  // 0x006c  l
  2,17,17,6,2,0,160,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
  // 0x006d  m
  17,12,60,21,2,0,226,254,7,253,0,251,255,223,255,64,253,7,248,15,192,248,3,240,7,192,244,2,240,3,192,240,2,224,3,192,240,2,224,3,192,240,2,224,3,192,240,2,224,3,192,240,2,224,3,192,240,2,224,3,192,240,2,224,3,192,
  // 0x006e  n
  10,12,36,14,2,0,225,255,64,251,255,208,253,3,240,248,1,240,244,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,
  // 0x006f  o
  11,13,39,13,1,255,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x0070  p
  11,18,54,14,2,250,226,254,0,251,255,192,253,3,240,248,1,240,244,0,244,240,0,244,240,0,244,244,0,244,248,1,240,252,3,240,255,239,208,242,255,64,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,80,0,0,
  // 0x0071  q
  11,18,54,14,1,250,7,253,56,31,255,188,62,2,252,188,0,252,184,0,188,248,0,124,248,0,124,248,0,188,188,0,252,62,1,252,47,239,252,11,253,124,0,0,188,0,0,188,0,0,188,0,0,188,0,0,188,0,0,16,
  // 0x0072  r
  7,12,24,9,2,0,225,252,247,252,255,64,252,0,244,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
  // 0x0073  s
  9,13,39,11,1,255,27,254,0,127,255,0,248,1,0,248,0,0,190,0,0,47,244,0,2,254,0,0,47,64,0,11,128,64,15,128,250,191,0,191,248,0,0,0,0,
  // 0x0074  t
  8,16,32,8,0,255,2,0,7,64,11,64,47,254,191,254,15,64,15,64,15,64,15,64,15,64,15,64,15,64,15,128,11,250,2,255,0,0,
  // 0x0075  u
  11,13,39,14,1,255,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x0076  v
  12,12,36,12,0,0,184,0,61,124,0,124,61,0,184,46,0,244,31,1,240,15,67,224,11,131,192,3,199,192,3,223,64,1,239,0,0,254,0,0,189,0,
  // 0x0077  w
  18,12,60,18,0,0,184,1,240,3,208,124,3,248,3,192,60,3,252,7,192,61,7,188,11,128,46,11,109,15,64,31,15,30,31,0,15,30,15,46,0,11,109,15,125,0,7,188,7,188,0,3,252,3,252,0,3,248,3,248,0,2,244,2,244,0,
  // 0x0078  x
  12,12,36,12,0,0,61,0,124,47,0,244,15,131,240,3,215,192,1,255,64,0,254,0,0,255,0,2,255,64,7,215,192,15,130,240,47,0,248,125,0,125,
  // 0x0079  y
  12,18,54,12,0,250,184,0,61,124,0,124,61,0,184,47,0,244,15,1,240,15,67,224,7,195,192,3,199,192,2,239,64,0,255,0,0,254,0,0,125,0,0,124,0,0,248,0,1,240,0,111,208,0,191,64,0,16,0,0,
  // 0x007a  z
  9,12,36,10,1,0,191,255,64,255,255,64,0,47,0,0,61,0,0,248,0,2,240,0,7,192,0,15,64,0,62,0,0,188,0,0,255,255,128,255,255,128,
  // 0x007b  {
  8,20,40,8,0,252,0,25,0,254,2,244,2,224,3,208,3,208,3,208,3,208,11,192,126,0,127,64,7,192,3,208,3,208,3,208,3,208,2,224,2,249,0,190,0,5,
  // 0x007c  |
  2,23,23,12,5,250,160,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,0,
  // 0x007d  }
  8,20,40,8,0,252,40,0,127,64,11,192,3,192,3,192,3,192,3,192,3,208,2,244,0,191,0,191,2,224,3,208,3,192,3,192,3,192,3,192,31,192,127,64,20,0,
  // 0x007e  ~
  11,4,12,13,1,6,4,0,0,191,228,36,250,255,244,64,27,144,
};

#endif // HAS_GRAPHICAL_TFT
