/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium 22pt, capital 'A' height: 16px, width: 100%, range: 0x0020-0x00ff
extern const uint8_t NotoSans_Medium_16[10298] = {
  130,16,32,0,255,0,21,250, // unifont_t
  // 0x0020 " "
  0,0,0,6,0,0,
  // 0x0021  !
  4,17,17,6,1,255,41,125,61,60,60,60,60,60,60,60,60,20,0,40,125,125,0,
  // 0x0022  "
  7,6,12,9,1,10,104,104,120,124,120,60,120,56,52,56,52,56,
  // 0x0023  #
  14,16,64,14,0,0,0,24,10,0,0,60,14,0,0,60,29,0,0,56,44,0,0,116,60,0,47,255,255,224,26,250,190,144,0,240,116,0,0,224,176,0,2,224,244,0,127,255,255,192,23,214,245,64,3,193,208,0,3,130,208,0,7,66,192,0,7,67,192,0,
  // 0x0024  $
  11,19,57,13,1,254,0,96,0,0,112,0,6,254,128,63,255,240,189,177,144,184,112,0,188,112,0,127,176,0,31,249,0,2,255,192,0,123,240,0,112,244,0,112,244,144,114,240,255,255,208,111,254,0,0,112,0,0,112,0,0,16,0,
  // 0x0025  %
  17,17,85,19,1,255,31,128,1,144,0,127,240,3,192,0,180,180,7,64,0,240,120,15,0,0,240,56,45,0,0,240,56,60,0,0,240,120,180,164,0,180,181,227,254,0,63,243,203,143,64,31,135,143,7,128,0,15,15,3,128,0,29,15,3,192,0,60,15,3,128,0,180,11,7,64,0,240,7,239,0,2,208,2,253,0,0,0,0,0,0,
  // 0x0026  &
  15,17,68,16,1,255,1,254,0,0,15,255,192,0,31,67,224,0,31,2,224,0,31,3,224,0,15,139,192,0,7,255,0,0,3,252,0,0,31,253,0,240,62,31,66,240,188,7,227,208,248,1,255,192,248,0,127,64,189,0,255,128,63,255,251,224,11,255,129,248,0,0,0,0,
  // 0x0027  '
  3,6,6,5,1,10,104,120,120,120,52,52,
  // 0x0028  (
  5,20,40,7,1,252,2,128,11,64,31,0,61,0,60,0,184,0,180,0,244,0,240,0,240,0,240,0,240,0,244,0,184,0,124,0,60,0,46,0,31,0,11,128,1,64,
  // 0x0029  )
  5,20,40,7,1,252,160,0,184,0,60,0,46,0,15,0,15,64,11,128,7,192,7,192,7,192,7,192,7,192,7,192,11,128,15,64,15,0,46,0,60,0,180,0,80,0,
  // 0x002a  *
  10,11,33,12,1,6,0,160,0,0,240,0,0,240,0,144,240,96,255,255,240,171,254,160,3,252,0,11,174,0,31,15,64,30,11,64,0,0,0,
  // 0x002b  +
  11,11,33,13,1,2,0,176,0,0,176,0,0,176,0,0,176,0,170,250,164,255,255,244,0,180,0,0,176,0,0,176,0,0,176,0,0,96,0,
  // 0x002c  ,
  3,6,6,6,1,253,40,60,124,184,240,224,
  // 0x002d  -
  6,3,6,7,1,4,255,192,255,208,0,0,
  // 0x002e  .
  4,4,4,6,1,255,56,125,125,0,
  // 0x002f  /
  8,16,32,8,0,0,0,10,0,31,0,61,0,60,0,184,0,244,1,240,2,224,3,192,7,192,15,64,15,0,30,0,61,0,60,0,184,0,
  // 0x0030  0
  11,17,51,13,1,255,2,253,0,15,255,128,62,7,208,124,2,240,184,0,240,244,0,244,244,0,248,244,0,248,244,0,248,244,0,248,244,0,244,184,0,240,124,1,240,62,3,224,31,255,192,7,254,0,0,0,0,
  // 0x0031  1
  6,16,32,13,2,0,0,160,7,240,47,240,189,240,176,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,
  // 0x0032  2
  11,16,48,13,1,0,6,253,0,127,255,192,125,7,224,16,2,240,0,1,240,0,2,240,0,3,208,0,11,192,0,31,0,0,125,0,1,244,0,7,208,0,31,64,0,125,0,0,255,255,248,255,255,248,
  // 0x0033  3
  11,17,51,13,1,255,11,254,0,191,255,192,120,7,224,0,2,240,0,1,240,0,3,224,0,27,192,11,253,0,11,255,128,0,7,240,0,0,244,0,0,244,0,0,244,128,3,240,255,191,208,191,254,0,0,0,0,
  // 0x0034  4
  12,16,48,13,0,0,0,1,240,0,3,240,0,15,240,0,46,240,0,125,240,0,241,240,2,209,240,7,129,240,15,1,240,45,1,240,125,86,245,191,255,255,106,170,250,0,1,240,0,1,240,0,1,240,
  // 0x0035  5
  11,17,51,13,1,255,42,170,128,63,255,208,62,85,64,60,0,0,60,0,0,60,0,0,62,169,0,127,255,192,21,27,240,0,1,240,0,0,244,0,0,244,0,1,240,64,3,240,191,255,192,127,254,0,0,0,0,
  // 0x0036  6
  11,17,51,13,1,255,0,111,208,3,255,208,15,208,0,62,0,0,60,0,0,184,0,0,184,190,64,251,255,224,254,2,240,248,0,244,244,0,184,184,0,184,124,0,244,62,2,240,31,255,208,7,255,64,0,0,0,
  // 0x0037  7
  11,16,48,13,1,0,170,170,164,255,255,248,85,85,244,0,1,240,0,3,208,0,7,192,0,15,128,0,31,0,0,46,0,0,61,0,0,188,0,0,244,0,2,240,0,3,208,0,7,192,0,15,128,0,
  // 0x0038  8
  11,17,51,13,1,255,6,254,0,47,255,192,61,3,240,124,1,240,124,1,240,61,3,224,31,159,192,7,254,0,15,255,64,62,7,224,184,1,244,244,0,248,244,0,248,188,1,240,63,175,224,11,255,64,0,0,0,
  // 0x0039  9
  11,17,51,13,1,255,6,249,0,47,255,128,126,7,208,184,1,240,244,0,240,244,0,244,244,0,248,188,2,248,63,175,244,31,252,244,0,0,240,0,1,240,0,3,224,0,11,192,42,255,0,63,248,0,0,0,0,
  // 0x003a  :
  4,13,13,6,1,255,60,125,60,0,0,0,0,0,0,56,125,125,0,
  // 0x003b  ;
  4,15,15,6,1,253,124,189,60,0,0,0,0,0,0,40,124,184,244,240,208,
  // 0x003c  <
  11,11,33,13,1,2,0,0,120,0,7,244,0,127,64,7,244,0,127,64,0,253,0,0,47,208,0,1,254,0,0,31,244,0,0,184,0,0,0,
  // 0x003d  =
  11,7,21,13,1,4,191,255,244,255,255,244,0,0,0,0,0,0,85,85,80,255,255,244,85,85,80,
  // 0x003e  >
  11,11,33,13,1,2,244,0,0,191,64,0,11,244,0,0,191,64,0,11,240,0,2,244,0,111,208,7,249,0,191,128,0,244,0,0,64,0,0,
  // 0x003f  ?
  9,17,51,10,0,255,27,249,0,191,255,64,52,11,192,0,3,192,0,3,192,0,7,192,0,31,64,0,189,0,1,244,0,3,208,0,3,192,0,1,64,0,0,0,0,2,192,0,7,224,0,3,208,0,0,0,0,
  // 0x0040  @
  18,18,90,20,1,254,0,1,169,0,0,0,127,255,240,0,2,244,0,189,0,11,128,0,15,0,30,0,85,7,192,60,11,255,195,192,56,46,7,193,208,180,60,3,129,224,176,120,3,129,208,176,116,7,129,208,176,120,11,130,192,176,60,31,195,128,116,31,249,255,0,60,6,144,100,0,46,0,0,0,0,15,192,0,80,0,2,255,175,208,0,0,27,254,64,0,
  // 0x0041  A
  14,16,64,14,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x0042  B
  11,16,48,14,2,0,170,169,0,255,255,224,249,87,244,244,0,248,244,0,184,244,0,248,248,6,240,255,255,128,255,255,224,244,0,252,244,0,124,244,0,124,244,0,188,244,1,252,255,255,240,255,255,128,
  // 0x0043  C
  12,17,51,14,1,255,0,111,232,2,255,255,15,228,26,47,64,0,62,0,0,124,0,0,188,0,0,188,0,0,188,0,0,188,0,0,124,0,0,61,0,0,63,0,0,15,208,1,7,255,254,0,191,253,0,0,0,
  // 0x0044  D
  13,16,64,16,2,0,170,169,0,0,255,255,224,0,249,87,252,0,244,0,126,0,244,0,47,0,244,0,15,64,244,0,15,128,244,0,11,192,244,0,11,192,244,0,15,128,244,0,15,128,244,0,31,0,244,0,126,0,244,6,252,0,255,255,240,0,255,254,64,0,
  // 0x0045  E
  9,16,48,12,2,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x0046  F
  9,16,48,12,2,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,244,0,0,254,170,64,255,255,128,249,85,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,
  // 0x0047  G
  14,17,68,16,1,255,0,27,250,0,2,255,255,192,11,244,6,128,31,128,0,0,62,0,0,0,124,0,0,0,188,0,0,0,188,0,85,64,188,1,255,208,188,0,171,208,124,0,3,208,61,0,3,208,63,0,3,208,15,208,3,208,7,255,255,208,0,191,255,128,0,0,0,0,
  // 0x0048  H
  13,16,64,16,2,0,164,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,248,0,15,64,255,255,255,64,255,255,255,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,
  // 0x0049  I
  6,16,32,8,1,0,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,
  // 0x004a  J
  7,21,42,6,254,251,0,164,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,0,244,2,240,191,224,191,128,20,0,
  // 0x004b  K
  12,16,48,14,2,0,164,0,41,244,0,248,244,3,240,244,11,192,244,47,0,244,124,0,245,244,0,251,240,0,255,248,0,252,125,0,244,63,0,244,15,128,244,7,208,244,2,240,244,0,252,244,0,62,
  // 0x004c  L
  9,16,48,12,2,0,164,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x004d  M
  16,16,64,20,2,0,169,0,0,106,255,0,0,191,255,64,0,255,251,128,1,239,247,192,3,223,243,208,3,207,241,224,11,79,240,240,15,15,244,180,30,15,244,124,45,15,244,60,60,15,244,45,120,15,244,31,244,15,244,15,240,15,244,11,224,15,244,3,192,15,
  // 0x004e  N
  13,16,64,17,2,0,168,0,2,128,254,0,3,192,255,64,3,192,255,192,3,192,247,224,3,192,241,240,3,192,240,252,3,192,240,61,3,192,244,47,3,192,244,15,131,192,244,7,211,192,244,2,243,192,244,0,251,192,244,0,127,192,244,0,63,192,244,0,15,192,
  // 0x004f  O
  15,17,68,17,1,255,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x0050  P
  11,16,48,13,2,0,170,169,0,255,255,192,249,91,224,244,2,240,244,0,244,244,0,244,244,1,240,244,7,224,255,255,192,255,253,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,
  // 0x0051  Q
  15,20,80,17,1,252,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,253,0,0,0,189,0,0,0,63,64,0,0,15,192,0,0,2,160,
  // 0x0052  R
  12,16,48,14,2,0,170,169,0,255,255,192,249,91,240,244,1,240,244,0,244,244,0,244,244,2,240,249,91,208,255,255,64,254,190,0,244,31,0,244,11,192,244,3,208,244,2,240,244,0,252,244,0,125,
  // 0x0053  S
  10,17,51,12,1,255,6,254,64,47,255,224,126,5,208,188,0,0,184,0,0,188,0,0,63,64,0,31,248,0,2,255,64,0,31,208,0,3,240,0,1,240,0,1,240,144,3,224,255,255,192,191,254,0,0,0,0,
  // 0x0054  T
  12,16,48,12,0,0,170,170,170,191,255,255,21,126,85,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,0,61,0,
  // 0x0055  U
  13,17,68,16,2,255,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x0056  V
  14,16,64,14,0,0,164,0,2,144,188,0,7,192,60,0,11,192,62,0,15,64,47,0,31,0,15,0,46,0,15,128,61,0,7,192,124,0,3,192,184,0,3,224,244,0,1,241,240,0,0,242,224,0,0,187,192,0,0,127,192,0,0,63,128,0,0,47,0,0,
  // 0x0057  W
  21,16,96,21,0,0,164,0,41,0,10,64,188,0,63,0,15,0,124,0,191,0,31,0,61,0,255,64,46,0,46,0,247,128,61,0,31,1,243,192,60,0,15,2,227,208,124,0,15,67,194,224,184,0,11,131,193,240,244,0,7,199,128,240,240,0,3,207,64,181,240,0,3,223,0,122,224,0,2,239,0,63,208,0,1,254,0,63,192,0,0,252,0,47,192,0,0,252,0,31,128,0,
  // 0x0058  X
  13,16,64,13,0,0,104,0,10,128,63,0,31,0,15,64,62,0,11,192,188,0,3,224,244,0,0,247,224,0,0,191,192,0,0,63,64,0,0,63,128,0,0,255,192,0,1,242,240,0,3,208,244,0,11,128,124,0,31,0,62,0,62,0,31,64,188,0,11,192,
  // 0x0059  Y
  13,16,64,13,0,0,168,0,10,64,124,0,31,0,62,0,62,0,31,64,124,0,11,192,248,0,3,209,240,0,2,243,208,0,0,255,192,0,0,191,64,0,0,63,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,
  // 0x005a  Z
  12,16,48,13,0,0,42,170,169,63,255,254,21,85,189,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,125,0,0,248,0,2,240,0,7,208,0,15,128,0,47,0,0,63,255,255,127,255,255,
  // 0x005b  [
  6,20,40,7,1,252,42,144,127,224,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,124,0,125,64,127,224,21,80,
  // 0x005c "\"
  8,16,32,8,0,0,100,0,124,0,60,0,46,0,15,0,15,64,7,128,3,192,2,208,1,240,0,240,0,184,0,124,0,61,0,46,0,15,
  // 0x005d  ]
  6,20,40,7,0,252,106,144,127,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,2,224,22,224,127,224,21,80,
  // 0x005e  ^
  11,11,33,13,1,5,0,160,0,0,244,0,2,252,0,3,157,0,11,15,0,15,7,64,45,3,192,60,1,208,116,0,240,240,0,116,0,0,0,
  // 0x005f  _
  10,2,6,10,0,252,255,255,224,85,85,64,
  // 0x0060  `
  5,4,8,7,1,13,248,0,61,0,15,0,2,64,
  // 0x0061  a
  10,13,39,13,1,255,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x0062  b
  11,18,54,14,2,255,160,0,0,240,0,0,240,0,0,240,0,0,240,0,0,242,254,0,251,255,192,253,3,240,248,1,240,244,0,244,240,0,244,240,0,244,244,0,244,248,1,240,252,3,240,255,239,208,226,255,64,0,0,0,
  // 0x0063  c
  9,13,39,11,1,255,2,255,128,31,255,128,63,0,0,124,0,0,184,0,0,248,0,0,248,0,0,248,0,0,188,0,0,62,0,64,47,255,192,7,255,128,0,0,0,
  // 0x0064  d
  11,18,54,14,1,255,0,0,104,0,0,188,0,0,188,0,0,188,0,0,188,7,253,124,47,255,252,62,2,252,188,0,252,184,0,188,248,0,124,248,0,124,248,0,188,188,0,252,62,1,252,47,239,252,11,253,60,0,0,0,
  // 0x0065  e
  11,13,39,13,1,255,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x0066  f
  9,17,51,8,0,0,0,110,64,3,255,64,7,208,0,11,192,0,11,128,0,47,254,0,191,254,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,11,128,0,
  // 0x0067  g
  11,18,54,14,1,250,7,253,56,31,255,188,62,2,252,188,0,252,184,0,188,248,0,124,248,0,124,248,0,124,188,0,188,62,1,252,47,239,252,11,253,124,0,0,188,0,0,184,16,1,244,63,171,240,47,255,128,0,16,0,
  // 0x0068  h
  10,17,51,14,2,0,160,0,0,240,0,0,240,0,0,240,0,0,240,0,0,241,255,64,251,255,208,253,3,240,248,1,240,244,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,
  // 0x0069  i
  2,17,17,6,2,0,80,240,240,0,0,240,240,240,240,240,240,240,240,240,240,240,240,
  // 0x006a  j
  6,23,46,6,254,250,0,80,0,240,0,240,0,0,0,0,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,1,240,43,224,127,192,4,0,
  // 0x006b  k
  10,17,51,12,2,0,160,0,0,240,0,0,240,0,0,240,0,0,240,0,0,240,3,208,240,15,128,240,62,0,240,248,0,243,224,0,251,208,0,255,240,0,248,252,0,240,62,0,240,31,64,240,11,192,240,3,240,
  // 0x006c  l
  2,17,17,6,2,0,160,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,
  // 0x006d  m
  17,12,60,21,2,0,226,254,7,253,0,251,255,223,255,64,253,7,248,15,192,248,3,240,7,192,244,2,240,3,192,240,2,224,3,192,240,2,224,3,192,240,2,224,3,192,240,2,224,3,192,240,2,224,3,192,240,2,224,3,192,240,2,224,3,192,
  // 0x006e  n
  10,12,36,14,2,0,225,255,64,251,255,208,253,3,240,248,1,240,244,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,
  // 0x006f  o
  11,13,39,13,1,255,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x0070  p
  11,18,54,14,2,250,226,254,0,251,255,192,253,3,240,248,1,240,244,0,244,240,0,244,240,0,244,244,0,244,248,1,240,252,3,240,255,239,208,242,255,64,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,80,0,0,
  // 0x0071  q
  11,18,54,14,1,250,7,253,56,31,255,188,62,2,252,188,0,252,184,0,188,248,0,124,248,0,124,248,0,188,188,0,252,62,1,252,47,239,252,11,253,124,0,0,188,0,0,188,0,0,188,0,0,188,0,0,188,0,0,16,
  // 0x0072  r
  7,12,24,9,2,0,225,252,247,252,255,64,252,0,244,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
  // 0x0073  s
  9,13,39,11,1,255,27,254,0,127,255,0,248,1,0,248,0,0,190,0,0,47,244,0,2,254,0,0,47,64,0,11,128,64,15,128,250,191,0,191,248,0,0,0,0,
  // 0x0074  t
  8,16,32,8,0,255,2,0,7,64,11,64,47,254,191,254,15,64,15,64,15,64,15,64,15,64,15,64,15,64,15,128,11,250,2,255,0,0,
  // 0x0075  u
  11,13,39,14,1,255,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x0076  v
  12,12,36,12,0,0,184,0,61,124,0,124,61,0,184,46,0,244,31,1,240,15,67,224,11,131,192,3,199,192,3,223,64,1,239,0,0,254,0,0,189,0,
  // 0x0077  w
  18,12,60,18,0,0,184,1,240,3,208,124,3,248,3,192,60,3,252,7,192,61,7,188,11,128,46,11,109,15,64,31,15,30,31,0,15,30,15,46,0,11,109,15,125,0,7,188,7,188,0,3,252,3,252,0,3,248,3,248,0,2,244,2,244,0,
  // 0x0078  x
  12,12,36,12,0,0,61,0,124,47,0,244,15,131,240,3,215,192,1,255,64,0,254,0,0,255,0,2,255,64,7,215,192,15,130,240,47,0,248,125,0,125,
  // 0x0079  y
  12,18,54,12,0,250,184,0,61,124,0,124,61,0,184,47,0,244,15,1,240,15,67,224,7,195,192,3,199,192,2,239,64,0,255,0,0,254,0,0,125,0,0,124,0,0,248,0,1,240,0,111,208,0,191,64,0,16,0,0,
  // 0x007a  z
  9,12,36,10,1,0,191,255,64,255,255,64,0,47,0,0,61,0,0,248,0,2,240,0,7,192,0,15,64,0,62,0,0,188,0,0,255,255,128,255,255,128,
  // 0x007b  {
  8,20,40,8,0,252,0,25,0,254,2,244,2,224,3,208,3,208,3,208,3,208,11,192,126,0,127,64,7,192,3,208,3,208,3,208,3,208,2,224,2,249,0,190,0,5,
  // 0x007c  |
  2,23,23,12,5,250,160,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,240,0,
  // 0x007d  }
  8,20,40,8,0,252,40,0,127,64,11,192,3,192,3,192,3,192,3,192,3,208,2,244,0,191,0,191,2,224,3,208,3,192,3,192,3,192,3,192,31,192,127,64,20,0,
  // 0x007e  ~
  11,4,12,13,1,6,4,0,0,191,228,36,250,255,244,64,27,144,
  // 0x007f - 0x009f  Control Characters
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00a0 " "
  0,0,0,6,0,0,
  // 0x00a1  ¡
  4,16,16,6,1,252,60,125,61,0,0,60,60,60,60,60,60,60,60,125,125,125,
  // 0x00a2  ¢
  9,17,51,13,2,255,0,176,0,0,240,0,11,255,64,63,255,64,125,0,0,248,0,0,244,0,0,244,0,0,244,0,0,244,0,0,248,0,0,126,0,64,63,255,128,7,255,64,0,240,0,0,240,0,0,0,0,
  // 0x00a3  £
  12,16,48,13,0,0,0,47,228,0,255,252,3,240,24,3,208,0,3,192,0,3,192,0,3,192,0,63,255,208,63,255,224,3,192,0,3,192,0,3,192,0,7,192,0,31,64,0,63,255,255,127,255,255,
  // 0x00a4  ¤
  10,11,33,13,1,2,16,0,16,122,254,240,47,239,208,45,3,192,60,0,208,56,0,224,60,1,208,31,75,192,63,255,224,52,84,160,0,0,0,
  // 0x00a5  ¥
  12,16,48,13,0,0,104,0,10,61,0,46,47,0,60,15,0,184,11,128,240,3,194,224,2,227,192,0,255,64,10,255,164,15,255,248,0,61,0,5,126,80,15,255,248,5,126,80,0,61,0,0,61,0,
  // 0x00a6  ¦
  2,23,23,12,5,250,160,240,240,240,240,240,240,240,176,0,0,0,0,16,240,240,240,240,240,240,240,240,0,
  // 0x00a7  §
  9,18,54,11,1,255,6,249,0,63,255,64,120,1,0,120,0,0,62,64,0,31,244,0,61,190,0,116,15,64,180,3,128,124,7,128,47,159,0,7,254,0,0,47,64,0,11,128,0,11,128,250,175,64,127,248,0,0,0,0,
  // 0x00a8  ¨
  7,3,6,13,3,13,180,120,180,120,0,0,
  // 0x00a9  ©
  16,17,68,18,1,255,0,27,248,0,2,249,91,128,11,64,0,240,44,6,228,60,52,47,188,13,112,120,0,11,224,176,0,7,208,240,0,3,208,240,0,3,224,240,0,7,176,116,0,11,112,62,88,14,44,11,248,44,15,0,0,180,3,224,7,208,0,127,254,0,0,0,0,0,
  // 0x00aa  ª
  7,8,16,8,0,8,27,224,41,184,0,44,11,252,61,44,116,60,62,252,10,72,
  // 0x00ab  «
  10,10,30,12,1,1,1,0,64,3,194,224,15,71,192,62,15,64,188,61,0,248,61,0,61,31,0,31,11,192,7,194,224,2,64,128,
  // 0x00ac  ¬
  11,7,21,13,1,2,170,170,164,255,255,244,0,0,116,0,0,116,0,0,116,0,0,116,0,0,0,
  // 0x00ad  ­
  6,3,6,7,1,4,255,192,255,208,0,0,
  // 0x00ae  ®
  16,17,68,18,1,255,0,27,248,0,2,249,91,128,11,64,0,240,44,42,144,60,52,63,252,13,112,60,45,11,224,60,29,7,208,60,124,3,208,63,240,3,224,60,176,7,176,60,60,11,112,60,29,14,44,60,15,44,15,0,0,180,3,224,7,208,0,127,254,0,0,0,0,0,
  // 0x00af  ¯
  11,3,9,11,0,16,85,85,84,255,255,252,85,85,84,
  // 0x00b0  °
  8,8,16,9,1,8,11,208,62,184,176,44,240,29,176,44,126,184,31,224,0,0,
  // 0x00b1  ±
  11,14,42,13,1,0,0,16,0,0,176,0,0,176,0,0,176,0,0,176,0,255,255,244,255,255,244,0,176,0,0,176,0,0,176,0,0,176,0,0,16,0,191,255,244,255,255,248,
  // 0x00b2  ²
  7,10,20,8,0,9,10,144,63,244,16,60,0,60,0,180,1,224,7,128,30,0,127,248,127,252,
  // 0x00b3  ³
  7,11,22,8,0,8,10,144,62,248,16,60,0,56,10,240,10,244,0,60,0,44,185,188,47,224,0,0,
  // 0x00b4  ´
  5,4,8,7,1,13,15,128,47,0,120,0,160,0,
  // 0x00b5  µ
  10,18,54,14,2,250,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,1,240,244,2,240,248,3,240,255,191,240,251,248,240,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,80,0,0,
  // 0x00b6  ¶
  11,20,60,14,1,253,2,170,168,31,255,252,63,254,12,191,254,12,191,254,12,255,254,12,191,254,12,191,254,12,127,254,12,63,254,12,11,254,12,0,10,12,0,10,12,0,10,12,0,10,12,0,10,12,0,10,12,0,10,12,0,10,12,0,10,12,
  // 0x00b7  ·
  4,4,4,6,1,5,56,125,125,0,
  // 0x00b8  ¸
  5,6,12,5,0,250,44,0,62,0,11,128,11,128,255,0,16,0,
  // 0x00b9  ¹
  5,10,20,8,1,9,6,64,47,128,251,128,71,128,7,128,7,128,7,128,7,128,7,128,3,64,
  // 0x00ba  º
  8,8,16,8,0,8,7,224,46,188,56,13,116,14,52,14,56,29,31,188,6,144,
  // 0x00bb  »
  10,10,30,12,1,1,16,0,0,244,60,0,61,47,0,31,11,128,11,195,224,7,194,240,15,75,192,61,31,0,248,61,0,96,20,0,
  // 0x00bc  ¼
  16,16,64,17,1,0,10,64,2,128,63,64,7,128,251,64,15,0,71,64,45,0,7,64,56,0,7,64,240,0,7,65,224,80,7,67,192,244,7,75,67,244,6,79,11,180,0,60,13,180,0,120,56,180,0,240,181,185,2,208,255,254,3,192,0,180,11,0,0,180,
  // 0x00bd  ½
  17,16,80,18,0,0,2,128,1,144,0,31,192,3,192,0,126,192,7,64,0,18,192,15,0,0,2,192,45,0,0,2,192,56,0,0,2,192,240,100,0,2,193,215,255,0,2,195,194,7,128,1,139,64,7,128,0,14,0,11,0,0,60,0,46,0,0,120,0,184,0,0,240,2,224,0,2,208,7,234,64,3,128,11,255,128,
  // 0x00be  ¾
  18,16,80,18,0,0,27,224,0,40,0,62,184,0,180,0,0,60,0,240,0,0,56,2,192,0,15,224,7,128,0,10,248,15,0,0,0,44,29,5,0,0,44,60,47,0,122,184,180,63,0,47,225,224,239,0,0,3,194,207,0,0,7,67,79,0,0,15,15,95,64,0,45,15,255,208,0,56,0,15,0,0,240,0,15,0,
  // 0x00bf  ¿
  10,17,51,10,0,251,0,124,0,0,252,0,0,188,0,0,0,0,0,0,0,0,60,0,0,120,0,0,244,0,3,224,0,31,128,0,61,0,0,124,0,0,124,0,0,125,0,128,63,255,208,11,255,128,0,0,0,
  // 0x00c0  À
  14,21,84,14,0,0,0,188,0,0,0,62,0,0,0,15,64,0,0,2,128,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x00c1  Á
  14,21,84,14,0,0,0,0,248,0,0,2,240,0,0,7,128,0,0,10,0,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x00c2  Â
  14,21,84,14,0,0,0,31,128,0,0,63,208,0,0,244,244,0,1,128,40,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x00c3  Ã
  14,21,84,14,0,0,0,0,4,0,0,254,28,0,2,223,248,0,2,65,144,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x00c4  Ä
  14,20,80,14,0,0,0,240,180,0,0,240,180,0,0,0,0,0,0,0,0,0,0,15,64,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x00c5  Å
  14,19,76,14,0,0,0,47,128,0,0,52,208,0,0,112,224,0,0,63,208,0,0,47,192,0,0,63,208,0,0,126,224,0,0,184,240,0,0,240,244,0,1,240,124,0,3,224,60,0,3,192,62,0,11,234,191,0,15,255,255,64,31,85,95,128,47,0,7,192,61,0,3,208,124,0,2,240,248,0,1,240,
  // 0x00c6  Æ
  19,16,80,20,0,0,0,2,170,170,164,0,3,255,255,248,0,11,159,149,80,0,15,15,64,0,0,46,15,64,0,0,60,15,64,0,0,188,15,64,0,0,244,15,255,240,2,240,15,255,240,3,250,175,64,0,7,255,255,64,0,15,149,95,64,0,31,0,15,64,0,62,0,15,64,0,124,0,15,255,248,248,0,15,255,248,
  // 0x00c7  Ç
  12,22,66,14,1,250,0,111,232,2,255,255,15,228,26,47,64,0,62,0,0,124,0,0,188,0,0,188,0,0,188,0,0,188,0,0,124,0,0,61,0,0,63,0,0,15,208,1,7,255,254,0,191,253,0,15,0,0,15,128,0,2,208,0,2,208,0,63,128,0,0,0,
  // 0x00c8  È
  9,21,63,12,2,0,31,64,0,7,192,0,1,224,0,0,96,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x00c9  É
  9,21,63,12,2,0,0,47,0,0,61,0,0,244,0,1,128,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x00ca  Ê
  9,21,63,12,2,0,2,240,0,11,252,0,30,31,0,36,6,64,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x00cb  Ë
  9,20,60,12,2,0,30,31,0,30,15,0,0,0,0,0,0,0,170,170,128,255,255,192,249,85,64,244,0,0,244,0,0,244,0,0,248,0,0,255,255,128,255,255,64,244,0,0,244,0,0,244,0,0,244,0,0,244,0,0,255,255,192,255,255,192,
  // 0x00cc  Ì
  6,21,42,8,1,0,248,0,125,0,31,0,2,64,0,0,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,
  // 0x00cd  Í
  7,21,42,8,1,0,1,244,3,224,11,128,9,0,0,0,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,
  // 0x00ce  Î
  8,21,42,8,0,0,11,208,31,240,124,124,160,10,0,0,42,168,63,252,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,7,192,47,244,63,252,
  // 0x00cf  Ï
  6,20,40,8,1,0,240,240,240,240,0,0,0,0,170,160,255,240,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,31,0,191,208,255,240,
  // 0x00d0  Ð
  15,16,64,16,0,0,10,170,144,0,15,255,254,0,15,149,127,192,15,128,7,224,15,128,2,240,15,128,0,244,15,128,0,248,127,255,0,188,127,255,0,188,31,149,0,248,15,128,0,248,15,128,1,240,15,128,7,224,15,128,111,192,15,255,255,0,15,255,228,0,
  // 0x00d1  Ñ
  13,20,80,17,2,0,2,253,56,0,7,175,240,0,6,2,128,0,0,0,0,0,168,0,2,128,254,0,3,192,255,64,3,192,255,192,3,192,247,224,3,192,241,240,3,192,240,252,3,192,240,61,3,192,244,47,3,192,244,15,131,192,244,7,211,192,244,2,243,192,244,0,251,192,244,0,127,192,244,0,63,192,244,0,15,192,
  // 0x00d2  Ò
  15,22,88,17,1,255,0,125,0,0,0,47,0,0,0,11,128,0,0,1,128,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x00d3  Ó
  15,22,88,17,1,255,0,0,188,0,0,1,244,0,0,3,208,0,0,6,0,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x00d4  Ô
  15,22,88,17,1,255,0,15,192,0,0,47,240,0,0,184,184,0,0,144,25,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x00d5  Õ
  15,21,84,17,1,255,0,191,78,0,0,235,252,0,1,128,96,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x00d6  Ö
  15,21,84,17,1,255,0,120,124,0,0,120,124,0,0,0,0,0,0,0,0,0,0,111,228,0,3,255,255,64,15,224,31,208,47,0,3,240,62,0,1,244,124,0,0,248,188,0,0,188,188,0,0,188,188,0,0,188,188,0,0,188,124,0,0,248,61,0,0,244,63,0,2,240,15,192,11,208,7,255,255,128,0,191,249,0,0,0,0,0,
  // 0x00d7  ×
  10,11,33,13,1,2,16,0,64,124,1,240,47,7,208,11,223,64,2,253,0,1,252,0,7,255,0,31,75,128,61,2,224,52,0,144,0,0,0,
  // 0x00d8  Ø
  15,17,68,17,1,255,0,111,228,224,3,255,255,208,15,224,31,192,47,0,15,240,62,0,61,244,124,0,180,248,188,1,240,188,188,3,192,188,188,11,64,188,188,30,0,188,124,60,0,248,61,244,0,244,63,224,2,240,15,208,11,208,15,255,255,128,46,191,249,0,8,0,0,0,
  // 0x00d9  Ù
  13,22,88,16,2,255,2,224,0,0,0,244,0,0,0,60,0,0,0,10,0,0,0,0,0,0,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x00da  Ú
  13,22,88,16,2,255,0,3,224,0,0,15,128,0,0,30,0,0,0,40,0,0,0,0,0,0,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x00db  Û
  13,22,88,16,2,255,0,126,0,0,0,255,64,0,3,211,208,0,10,0,160,0,0,0,0,0,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x00dc  Ü
  13,21,84,16,2,255,3,195,192,0,3,195,192,0,0,0,0,0,0,0,0,0,160,0,10,0,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,64,244,0,15,0,188,0,47,0,126,0,125,0,47,255,248,0,7,255,208,0,0,0,0,0,
  // 0x00dd  Ý
  13,21,84,13,0,0,0,3,224,0,0,7,192,0,0,15,0,0,0,40,0,0,0,0,0,0,168,0,10,64,124,0,31,0,62,0,62,0,31,64,124,0,11,192,248,0,3,209,240,0,2,243,208,0,0,255,192,0,0,191,64,0,0,63,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,0,62,0,0,
  // 0x00de  Þ
  11,16,48,13,2,0,164,0,0,244,0,0,248,0,0,255,254,0,255,255,208,244,7,240,244,1,244,244,0,244,244,0,244,244,2,240,249,95,224,255,255,128,254,164,0,244,0,0,244,0,0,244,0,0,
  // 0x00df  ß
  12,18,54,14,2,255,6,249,0,63,255,192,253,7,240,244,1,240,240,2,240,240,7,208,240,47,64,240,60,0,240,124,0,240,63,64,240,15,224,240,1,252,240,0,125,240,0,61,240,0,61,240,250,252,240,191,224,0,0,0,
  // 0x00e0  à
  10,18,54,13,1,255,11,192,0,3,224,0,0,244,0,0,40,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x00e1  á
  10,18,54,13,1,255,0,15,128,0,47,0,0,124,0,0,160,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x00e2  â
  10,18,54,13,1,255,0,248,0,3,254,0,15,79,64,25,1,128,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x00e3  ã
  10,17,51,13,1,255,15,224,208,45,191,192,36,10,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x00e4  ä
  10,17,51,13,1,255,15,75,64,15,75,64,0,0,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x00e5  å
  10,19,57,13,1,255,1,252,0,3,78,0,3,10,0,3,237,0,0,164,0,0,0,0,11,255,64,47,255,192,4,3,224,0,2,240,0,2,240,11,255,240,127,150,240,252,1,240,244,2,240,248,7,240,191,190,240,47,244,240,0,0,0,
  // 0x00e6  æ
  18,13,65,19,1,255,27,254,11,248,0,47,255,191,255,0,4,3,248,15,128,0,3,240,7,192,0,3,240,7,192,11,255,255,255,208,127,87,250,170,128,252,3,240,0,0,244,3,240,0,0,248,11,248,0,64,190,190,63,175,128,47,248,11,255,64,0,0,0,0,0,
  // 0x00e7  ç
  9,18,54,11,1,250,2,255,128,31,255,128,63,0,0,124,0,0,184,0,0,248,0,0,248,0,0,248,0,0,188,0,0,62,0,64,47,255,192,7,255,128,0,176,0,0,248,0,0,45,0,0,45,0,3,252,0,0,64,0,
  // 0x00e8  è
  11,18,54,13,1,255,11,192,0,3,224,0,0,244,0,0,40,0,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x00e9  é
  11,18,54,13,1,255,0,15,128,0,47,0,0,124,0,0,160,0,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x00ea  ê
  11,18,54,13,1,255,0,248,0,3,254,0,15,75,64,25,1,128,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x00eb  ë
  11,17,51,13,1,255,15,75,64,15,75,64,0,0,0,0,0,0,2,254,0,31,255,208,62,2,240,124,0,244,184,0,244,255,255,244,254,170,164,184,0,0,124,0,0,62,0,16,31,251,240,3,255,224,0,0,0,
  // 0x00ec  ì
  5,17,34,6,0,0,248,0,61,0,15,0,2,64,0,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,
  // 0x00ed  í
  5,17,34,6,2,0,31,64,62,0,184,0,144,0,0,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
  // 0x00ee  î
  8,17,34,6,255,0,11,208,31,240,60,60,160,10,0,0,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,3,192,
  // 0x00ef  ï
  6,16,32,6,0,0,240,240,240,240,0,0,0,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,15,0,
  // 0x00f0  ð
  11,18,54,13,1,255,1,64,64,3,247,224,0,191,64,1,255,128,3,199,208,0,1,240,0,84,244,15,255,248,63,151,252,124,0,188,184,0,124,248,0,60,248,0,60,188,0,124,61,0,248,47,235,240,7,255,128,0,0,0,
  // 0x00f1  ñ
  10,17,51,14,2,0,0,0,64,31,210,192,62,255,64,32,25,0,0,0,0,225,255,64,251,255,208,253,3,240,248,1,240,244,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,
  // 0x00f2  ò
  11,18,54,13,1,255,7,208,0,1,240,0,0,124,0,0,25,0,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x00f3  ó
  11,18,54,13,1,255,0,11,192,0,15,64,0,61,0,0,96,0,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x00f4  ô
  11,18,54,13,1,255,0,188,0,2,255,0,7,199,192,9,1,144,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x00f5  õ
  11,17,51,13,1,255,11,244,224,14,191,208,24,6,64,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x00f6  ö
  11,17,51,13,1,255,7,131,192,7,131,192,0,0,0,0,0,0,2,255,64,31,255,224,62,1,244,124,0,188,184,0,124,248,0,60,248,0,60,184,0,124,124,0,188,62,0,248,31,239,240,7,255,128,0,0,0,
  // 0x00f7  ÷
  11,11,33,13,1,2,0,176,0,0,248,0,0,176,0,0,0,0,170,170,164,255,255,248,0,0,0,0,16,0,0,244,0,0,244,0,0,16,0,
  // 0x00f8  ø
  11,13,39,13,1,255,2,255,180,31,255,240,62,3,244,124,7,252,184,15,124,248,60,60,248,180,60,185,240,124,127,192,188,63,64,248,47,239,240,63,255,128,20,0,0,
  // 0x00f9  ù
  11,18,54,14,1,255,3,224,0,1,244,0,0,124,0,0,9,0,0,0,0,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x00fa  ú
  11,18,54,14,1,255,0,7,208,0,15,128,0,46,0,0,36,0,0,0,0,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x00fb  û
  11,18,54,14,1,255,0,189,0,1,255,0,7,199,192,10,0,160,0,0,0,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x00fc  ü
  11,17,51,14,1,255,3,195,192,3,195,192,0,0,0,0,0,0,60,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,124,0,124,60,0,188,62,1,252,47,239,252,11,254,60,0,0,0,
  // 0x00fd  ý
  12,23,69,12,0,250,0,7,192,0,15,64,0,61,0,0,100,0,0,0,0,184,0,61,124,0,124,61,0,184,47,0,244,15,1,240,15,67,224,7,195,192,3,199,192,2,239,64,0,255,0,0,254,0,0,125,0,0,124,0,0,248,0,1,240,0,111,208,0,191,64,0,16,0,0,
  // 0x00fe  þ
  11,23,69,14,2,250,160,0,0,240,0,0,240,0,0,240,0,0,240,0,0,241,254,0,251,255,192,253,3,240,248,1,240,244,0,244,240,0,244,240,0,244,244,0,244,248,1,240,252,3,240,255,239,208,242,255,64,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,80,0,0,
  // 0x00ff  ÿ
  12,22,66,12,0,250,7,131,192,7,131,192,0,0,0,0,0,0,184,0,61,124,0,124,61,0,184,47,0,244,15,1,240,15,67,224,7,195,192,3,199,192,2,239,64,0,255,0,0,254,0,0,125,0,0,124,0,0,248,0,1,240,0,111,208,0,191,64,0,16,0,0,
};

#endif // HAS_GRAPHICAL_TFT
