/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Traditional Chinese 19pt, capital 'A' height: 14px, width: 100%, range: 0x22bf-0xff1a, glyphs: 307
extern const uint8_t NotoSans_Medium_Traditional_Chinese_14[30758] = {
  162,14,191,34,26,255,18,251, // unifont_t
  // 0x22bf  ⊿
  191,34,15,15,60,19,2,0,0,0,0,36,0,0,0,180,0,0,2,244,0,0,11,244,0,0,30,52,0,0,124,52,0,1,240,52,0,7,192,52,0,31,0,52,0,60,0,52,0,240,0,52,3,192,0,52,15,0,0,52,63,170,170,180,255,255,255,244,
  // 0x4e00  一
  0,78,17,2,10,19,1,7,255,255,255,255,192,255,255,255,255,192,
  // 0x4e09  三
  9,78,17,15,75,19,1,0,31,255,255,254,0,47,255,255,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,255,255,240,0,7,255,255,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,191,255,255,255,128,191,255,255,255,128,
  // 0x4e0a  上
  10,78,17,18,90,19,1,255,0,1,64,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,255,254,0,0,3,255,254,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,255,255,255,255,192,255,255,255,255,192,
  // 0x4e0b  下
  11,78,17,17,85,19,1,254,255,255,255,255,192,191,255,255,255,128,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,248,0,0,0,3,255,64,0,0,3,203,244,0,0,3,192,254,0,0,3,192,45,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,2,128,0,0,
  // 0x4e0d  不
  13,78,17,17,85,19,1,254,191,255,255,255,128,191,255,255,255,128,0,0,244,0,0,0,3,224,0,0,0,11,208,0,0,0,31,238,0,0,0,127,239,192,0,1,245,210,244,0,11,209,208,126,0,127,65,208,31,128,248,1,208,3,128,16,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,144,0,0,
  // 0x4e26  並
  38,78,17,18,90,19,1,255,0,64,0,80,0,2,208,0,240,0,0,240,2,208,0,0,176,3,192,0,127,255,255,255,64,106,191,191,170,64,0,29,29,0,0,4,29,29,8,0,29,29,29,30,0,14,29,29,45,0,15,29,29,60,0,11,29,29,56,0,7,93,29,180,0,3,157,29,240,0,0,29,29,0,0,0,29,29,0,0,255,255,255,255,192,191,255,255,255,192,
  // 0x4e2d  中
  45,78,15,19,76,19,2,254,0,6,0,0,0,7,64,0,0,7,64,0,0,7,64,0,255,255,255,252,250,175,234,188,224,7,64,44,224,7,64,44,224,7,64,44,224,7,64,44,250,175,234,188,255,255,255,252,224,7,64,44,0,7,64,0,0,7,64,0,0,7,64,0,0,7,64,0,0,7,64,0,0,6,0,0,
  // 0x4e3b  主
  59,78,17,18,90,19,1,255,0,1,0,0,0,0,15,128,0,0,0,3,240,0,0,0,0,248,0,0,42,170,254,170,0,63,255,255,255,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,15,255,255,252,0,10,171,250,168,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,170,171,250,170,128,255,255,255,255,192,
  // 0x4e4b  之
  75,78,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,42,171,250,173,0,63,255,255,255,0,0,0,0,60,0,0,0,0,248,0,0,0,2,224,0,0,0,11,192,0,0,0,31,0,0,7,128,124,0,0,11,66,240,0,0,15,203,192,0,0,47,254,0,0,0,60,189,0,0,0,244,47,255,170,128,240,1,191,255,192,0,0,0,0,0,
  // 0x4ea4  交
  164,78,17,19,95,19,1,254,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,255,255,255,255,192,170,170,170,170,128,0,96,2,128,0,1,240,3,240,0,7,208,0,188,0,47,64,1,47,64,188,116,7,139,128,32,60,15,1,0,0,46,46,0,0,0,15,188,0,0,0,3,240,0,0,0,11,248,0,0,0,191,127,128,0,47,244,7,254,64,255,128,0,191,192,32,0,0,2,0,
  // 0x4eae  亮
  174,78,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,255,255,255,255,192,85,85,85,85,64,0,0,0,0,0,7,255,255,244,0,7,64,0,180,0,7,128,0,180,0,7,255,255,244,0,85,85,85,85,0,191,255,255,255,128,176,0,0,3,128,176,56,29,3,128,96,56,30,2,64,0,180,30,0,0,1,240,30,2,128,11,208,30,3,192,255,64,15,255,128,80,0,6,169,0,
  // 0x4ee4  令
  228,78,17,19,95,19,1,254,0,2,144,0,0,0,7,240,0,0,0,15,188,0,0,0,61,47,0,0,0,248,11,208,0,3,224,2,248,0,31,170,170,191,0,252,127,255,79,192,224,0,0,2,128,0,0,0,0,0,31,255,255,252,0,26,175,170,188,0,0,11,0,60,0,0,11,0,60,0,0,11,0,60,0,0,11,6,188,0,0,11,3,244,0,0,11,0,0,0,0,6,0,0,0,
  // 0x4ef6  件
  246,78,17,19,95,19,1,254,0,64,5,0,0,2,210,75,0,0,3,195,139,0,0,7,71,75,0,0,15,11,239,170,0,46,15,255,255,64,62,29,11,0,0,254,60,11,0,0,238,20,11,0,0,78,0,11,0,0,14,63,255,255,192,14,42,175,234,128,14,0,11,0,0,14,0,11,0,0,14,0,11,0,0,14,0,11,0,0,14,0,11,0,0,14,0,11,0,0,9,0,6,0,0,
  // 0x4efd  份
  253,78,18,19,95,19,0,254,0,16,0,0,0,0,180,47,252,0,0,240,26,188,0,2,208,240,30,0,3,193,208,15,0,11,131,192,11,128,31,135,64,3,208,63,143,0,1,240,123,174,170,170,160,35,134,255,255,0,3,128,29,11,0,3,128,44,11,0,3,128,44,15,0,3,128,56,15,0,3,128,116,15,0,3,128,240,15,0,3,131,208,30,0,3,143,65,253,0,3,69,0,164,0,
  // 0x4f11  休
  17,79,19,19,95,19,0,254,0,16,1,64,0,0,60,3,192,0,0,180,3,192,0,0,240,3,192,0,2,224,3,192,0,7,202,171,234,160,15,207,255,255,240,63,192,15,240,0,126,192,31,244,0,34,192,63,252,0,2,192,119,221,0,2,192,243,207,0,2,194,211,199,128,2,199,195,195,208,2,239,3,192,244,2,221,3,192,112,2,192,3,192,0,2,192,3,192,0,1,128,2,128,0,
  // 0x4f4d  位
  77,79,19,19,95,19,0,254,0,16,1,64,0,0,116,3,192,0,0,240,3,192,0,1,224,3,192,0,3,203,255,255,240,11,198,170,170,160,31,192,0,0,0,127,192,224,11,64,55,192,240,15,0,19,192,176,15,0,3,192,112,30,0,3,192,116,29,0,3,192,56,44,0,3,192,56,60,0,3,192,60,56,0,3,192,0,112,0,3,207,255,255,244,3,202,170,170,160,1,64,0,0,0,
  // 0x4f4e  低
  78,79,19,19,95,19,0,254,0,16,0,0,0,0,176,0,27,128,0,242,111,255,128,2,211,254,240,0,3,195,128,240,0,11,131,128,240,0,31,131,128,240,0,127,131,255,255,240,119,131,234,250,160,19,131,128,116,0,3,131,128,116,0,3,131,128,56,0,3,131,129,124,0,3,135,255,172,16,3,143,249,29,52,3,132,0,15,52,3,134,170,171,240,3,139,255,242,224,3,128,0,0,0,
  // 0x4f5c  作
  92,79,17,19,95,19,1,254,0,128,16,0,0,1,224,180,0,0,3,192,240,0,0,7,129,250,170,128,15,3,255,255,192,31,7,78,0,0,63,15,14,0,0,255,45,14,0,0,255,60,15,255,192,143,0,15,170,64,15,0,14,0,0,15,0,14,0,0,15,0,15,170,128,15,0,15,255,192,15,0,14,0,0,15,0,14,0,0,15,0,14,0,0,15,0,14,0,0,10,0,9,0,0,
  // 0x4f9b  供
  155,79,18,19,95,19,0,254,0,16,16,8,0,0,180,116,29,0,0,240,116,29,0,2,208,116,29,0,3,198,254,191,160,11,139,255,255,240,31,128,116,29,0,63,128,116,29,0,123,128,116,29,0,35,128,116,29,0,3,128,116,29,0,3,143,255,255,240,3,138,170,170,160,3,128,0,0,0,3,128,120,29,0,3,128,240,15,64,3,131,192,3,192,3,143,64,1,240,2,65,0,0,64,
  // 0x4fdd  保
  221,79,18,19,95,19,1,254,0,64,0,0,0,1,230,170,170,0,3,203,255,255,0,7,139,0,11,0,15,11,0,11,0,47,11,0,11,0,127,11,255,255,0,255,6,175,170,0,239,0,15,0,0,143,0,15,0,0,15,63,255,255,192,15,42,191,234,128,15,0,127,224,0,15,1,255,180,0,15,3,207,61,0,15,31,79,15,64,15,125,15,3,208,15,32,15,0,128,6,0,10,0,0,
  // 0x4fe1  信
  225,79,18,19,95,19,0,254,0,36,0,0,0,0,116,255,255,128,0,240,85,85,0,1,224,0,0,0,3,207,255,255,240,11,197,85,85,80,15,192,0,0,0,63,193,255,255,192,123,192,85,85,64,35,192,85,85,64,3,193,255,255,192,3,192,0,0,0,3,192,85,85,64,3,194,255,255,192,3,194,192,2,192,3,194,192,2,192,3,194,213,87,192,3,194,255,255,192,2,129,192,2,128,
  // 0x500b  個
  11,80,18,19,95,19,0,254,0,64,0,0,0,0,246,170,170,144,1,219,255,255,224,3,203,1,64,224,7,139,2,128,224,15,139,23,212,224,47,139,127,253,224,127,139,2,128,224,119,139,2,128,224,19,139,47,248,224,3,139,45,104,224,3,139,40,40,224,3,139,40,40,224,3,139,47,248,224,3,139,5,80,224,3,139,0,0,224,3,139,255,255,224,3,139,170,170,224,2,70,0,0,144,
  // 0x503c  值
  60,80,17,19,95,19,1,254,0,64,6,0,0,2,208,15,0,0,3,218,175,170,64,7,111,255,255,128,15,0,29,0,0,30,1,109,84,0,62,11,255,254,0,190,11,0,14,0,254,11,85,94,0,142,11,255,254,0,14,11,0,14,0,14,11,255,254,0,14,11,0,30,0,14,11,0,14,0,14,11,255,254,0,14,11,85,94,0,14,31,85,111,64,14,127,255,255,192,9,0,0,0,0,
  // 0x504f  偏
  79,80,18,19,95,19,0,254,0,64,0,0,0,0,229,85,85,80,1,223,255,255,240,3,192,0,0,0,7,131,255,255,208,11,67,149,86,208,31,67,64,1,208,63,67,149,86,208,127,67,255,255,208,55,67,64,0,0,3,71,255,255,240,3,71,235,109,240,3,75,211,40,240,3,79,231,109,240,3,78,255,255,240,3,109,211,40,240,3,188,211,40,240,3,100,211,43,224,1,0,129,5,64,
  // 0x505c  停
  92,80,19,19,95,19,0,254,0,16,2,128,0,0,180,3,192,0,0,255,255,255,240,2,214,170,170,160,3,192,0,0,0,11,130,255,255,128,15,130,192,3,128,63,130,208,3,128,123,130,255,255,128,51,133,85,85,80,3,159,255,255,244,3,157,0,0,116,3,157,85,85,116,3,128,255,255,0,3,128,3,192,0,3,128,3,192,0,3,128,3,192,0,3,128,127,128,0,2,64,41,0,0,
  // 0x5075  偵
  117,80,18,19,95,19,0,254,0,16,2,64,0,0,120,3,192,0,0,240,3,255,240,1,224,3,234,144,3,192,3,192,0,11,195,255,255,192,31,195,213,87,192,63,195,213,87,192,119,195,255,255,192,35,195,192,3,192,3,195,213,87,192,3,195,255,255,192,3,195,192,3,192,3,195,213,87,192,3,195,255,255,192,3,192,36,8,0,3,193,248,31,64,3,207,208,3,224,2,134,0,0,144,
  // 0x5099  備
  153,80,18,19,95,19,0,254,0,80,36,8,0,0,224,52,29,0,2,223,255,255,240,3,202,190,174,160,7,128,52,29,0,15,64,0,0,0,31,79,255,255,240,63,79,170,170,160,123,79,21,85,80,35,79,63,255,240,3,79,48,176,176,3,78,52,176,240,3,78,63,255,240,3,78,48,176,176,3,77,63,255,240,3,92,52,176,240,3,124,48,176,240,3,180,48,183,224,2,64,16,1,64,
  // 0x50b3  傳
  179,80,18,19,95,19,0,254,0,16,1,64,0,0,185,87,213,80,0,255,255,255,240,2,208,3,192,0,3,195,255,255,208,15,131,131,193,208,47,131,255,255,208,127,131,131,193,208,55,131,255,255,208,19,128,3,199,128,3,128,3,199,192,3,143,255,255,240,3,128,0,14,32,3,159,255,255,240,3,133,229,95,80,3,128,240,14,0,3,128,60,14,0,3,128,2,254,0,2,64,0,84,0,
  // 0x50be  傾
  190,80,18,19,95,19,0,254,0,128,0,0,0,2,192,63,255,240,3,196,26,190,160,3,156,0,116,0,11,92,15,255,224,15,28,238,85,224,47,31,238,0,224,127,31,143,255,224,119,30,14,85,224,23,28,14,0,224,7,28,15,255,224,7,28,94,85,224,7,28,126,0,224,7,28,126,85,224,7,31,239,255,224,7,5,67,66,0,7,0,31,67,208,7,0,189,0,240,6,0,16,0,16,
  // 0x5132  儲
  50,81,18,19,95,19,0,254,0,128,0,96,0,1,223,240,112,176,3,197,81,181,224,3,149,87,255,192,11,127,248,115,192,15,0,0,119,64,47,5,81,191,80,127,15,251,255,240,55,0,0,122,128,23,15,241,224,192,7,5,91,255,224,7,0,6,245,224,7,31,244,224,224,7,29,116,255,224,7,28,52,229,224,7,28,52,224,224,7,31,244,245,224,7,29,80,255,224,2,4,0,144,144,
  // 0x5145  充
  69,81,17,19,95,19,1,254,0,1,208,0,0,0,1,208,0,0,106,171,250,170,64,191,255,255,255,128,0,61,2,0,0,0,60,7,192,0,0,180,2,240,0,0,245,90,252,0,63,255,255,255,0,62,165,80,15,64,0,60,15,1,0,0,60,15,0,0,0,56,15,0,0,0,180,15,0,0,0,240,15,1,192,3,224,15,1,192,31,192,15,2,192,254,0,15,255,128,96,0,2,170,0,
  // 0x5148  先
  72,81,17,19,95,19,1,254,0,1,144,0,0,2,193,208,0,0,3,193,208,0,0,7,235,250,169,0,11,255,255,253,0,15,1,208,0,0,61,1,208,0,0,44,1,208,0,0,0,1,208,0,0,255,255,255,255,192,170,190,175,170,128,0,56,15,0,0,0,116,15,0,0,0,240,15,0,0,1,224,15,2,192,7,192,15,2,192,127,64,15,171,128,188,0,7,255,0,16,0,0,0,0,
  // 0x5149  光
  73,81,17,19,95,19,1,254,0,1,128,0,0,4,1,208,24,0,15,1,208,45,0,11,65,208,60,0,3,129,208,180,0,3,193,208,240,0,1,129,208,144,0,0,1,208,0,0,255,255,255,255,192,170,190,175,170,128,0,56,14,0,0,0,120,14,0,0,0,180,14,0,0,0,240,14,0,0,1,224,14,1,192,7,192,14,2,192,47,64,15,2,192,253,0,15,255,128,80,0,2,170,0,
  // 0x5165  入
  101,81,17,18,90,19,1,254,1,255,224,0,0,2,255,224,0,0,0,0,224,0,0,0,0,240,0,0,0,2,240,0,0,0,3,240,0,0,0,7,244,0,0,0,11,184,0,0,0,15,60,0,0,0,46,46,0,0,0,61,15,0,0,0,184,11,128,0,1,240,3,208,0,3,224,1,244,0,31,128,0,189,0,191,0,0,47,128,248,0,0,7,192,16,0,0,1,0,
  // 0x5168  全
  104,81,17,18,90,19,1,255,0,2,144,0,0,0,7,240,0,0,0,15,124,0,0,0,61,31,0,0,0,244,11,192,0,3,208,1,240,0,31,64,0,125,0,190,170,170,175,192,247,255,255,247,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,15,255,255,252,0,10,171,234,164,0,0,1,208,0,0,0,1,208,0,0,106,171,234,170,64,127,255,255,255,128,
  // 0x5171  共
  113,81,17,19,95,19,1,254,0,96,2,64,0,0,240,3,192,0,0,240,3,192,0,0,240,3,192,0,42,250,171,234,64,127,255,255,255,64,0,240,3,192,0,0,240,3,192,0,0,240,3,192,0,0,240,3,192,0,170,250,171,234,128,255,255,255,255,192,0,0,0,0,0,0,116,7,64,0,1,244,7,208,0,7,208,1,248,0,47,64,0,62,0,188,0,0,15,64,16,0,0,1,0,
  // 0x5177  具
  119,81,17,18,90,19,1,254,3,255,255,244,0,3,149,85,180,0,3,128,0,116,0,3,255,255,244,0,3,149,85,180,0,3,128,0,116,0,3,255,255,244,0,3,149,85,180,0,3,128,0,116,0,3,255,255,244,0,1,85,85,80,0,170,170,170,170,128,255,255,255,255,192,0,16,1,0,0,1,252,15,224,0,47,224,2,254,0,190,0,0,47,128,16,0,0,1,0,
  // 0x5197  冗
  151,81,17,17,85,19,1,254,127,255,255,255,128,126,170,170,175,128,116,0,0,7,128,116,0,0,7,128,116,0,0,7,128,0,191,255,128,0,0,186,171,128,0,0,176,3,128,0,0,176,3,128,0,0,240,3,128,0,0,240,3,128,0,0,240,3,128,0,2,208,3,129,192,7,192,3,130,192,47,64,3,130,192,253,0,3,255,192,96,0,1,170,0,
  // 0x51b7  冷
  183,81,17,19,95,19,1,254,0,0,24,0,0,16,0,127,0,0,184,0,251,128,0,62,2,226,224,0,15,11,192,248,0,1,47,0,62,0,0,250,170,175,192,1,227,255,226,192,0,64,0,0,0,0,0,0,0,0,3,47,255,255,0,11,90,254,175,0,15,0,116,15,0,61,0,116,15,0,124,0,116,15,0,240,0,116,254,0,96,0,116,168,0,0,0,116,0,0,0,0,96,0,0,
  // 0x51c6  准
  198,81,17,19,95,19,1,254,0,0,128,80,0,16,2,208,240,0,184,3,192,240,0,47,7,129,208,0,11,79,255,255,192,1,47,171,234,64,0,63,3,192,0,0,255,3,192,0,0,171,255,255,64,0,11,171,234,0,2,11,3,192,0,11,75,3,192,0,15,11,255,255,64,45,11,171,234,0,124,11,3,192,0,240,11,3,192,0,160,11,255,255,192,0,11,170,170,128,0,6,0,0,0,
  // 0x51fa  出
  250,81,15,19,76,19,2,254,0,6,0,0,0,11,64,0,56,11,64,176,56,11,64,176,56,11,64,176,56,11,64,176,56,11,64,176,62,175,234,240,63,255,255,240,0,11,64,0,160,11,64,40,240,11,64,60,240,11,64,60,240,11,64,60,240,11,64,60,240,11,64,60,255,255,255,252,250,170,170,188,160,0,0,40,
  // 0x5206  分
  6,82,17,18,90,19,1,254,0,120,11,64,0,0,244,7,192,0,1,240,2,208,0,3,208,0,240,0,15,128,0,124,0,47,0,0,47,0,189,0,0,15,192,251,255,255,251,192,2,175,234,244,0,0,15,0,180,0,0,15,0,180,0,0,30,0,176,0,0,60,0,176,0,0,188,0,240,0,1,240,0,240,0,11,208,1,240,0,63,64,191,208,0,36,0,42,64,0,
  // 0x5217  列
  23,82,18,19,95,19,0,254,0,0,0,0,64,42,170,164,1,208,63,255,249,65,208,0,240,3,193,208,1,224,3,193,208,2,250,147,193,208,3,255,243,193,208,7,64,227,193,208,15,1,211,193,208,47,130,195,193,208,126,247,195,193,208,32,127,67,193,208,0,31,3,193,208,0,30,1,65,208,0,60,0,1,208,0,244,0,1,208,3,224,0,1,208,15,128,0,127,192,5,0,0,42,64,
  // 0x521d  初
  29,82,17,19,95,19,1,254,2,64,0,0,0,7,64,0,0,0,7,67,255,255,192,7,66,175,171,192,255,248,14,3,192,170,248,14,3,192,0,176,30,3,128,1,224,29,3,128,3,205,29,3,128,11,236,44,3,128,47,240,44,3,128,191,188,60,3,128,247,92,120,7,128,71,64,180,7,64,7,64,240,7,64,7,66,208,11,64,7,71,192,15,0,7,95,3,255,0,2,72,1,232,0,
  // 0x5230  到
  48,82,17,18,90,19,1,254,170,170,144,7,64,255,255,229,7,64,7,128,11,7,64,11,14,11,7,64,15,11,75,7,64,14,87,203,7,64,255,255,235,7,64,165,144,171,7,64,0,224,11,7,64,0,224,11,7,64,127,255,203,7,64,106,250,139,7,64,0,224,6,7,64,0,224,0,7,64,0,246,160,7,64,191,255,224,7,64,255,164,1,255,64,0,0,0,249,0,
  // 0x5236  制
  54,82,17,19,95,19,1,254,0,96,0,1,64,44,176,0,3,128,60,176,1,195,128,63,255,225,195,128,186,250,145,195,128,224,176,1,195,128,186,250,161,195,128,255,255,245,195,128,0,176,1,195,128,0,176,1,195,128,127,255,241,195,128,122,250,241,195,128,116,176,241,195,128,116,176,240,3,128,116,176,240,3,128,116,177,240,3,128,116,179,208,3,128,16,176,0,255,64,0,176,0,121,0,
  // 0x5237  刷
  55,82,17,19,95,19,1,254,0,0,0,1,0,42,170,144,3,64,63,255,242,131,64,56,0,243,131,64,56,0,243,131,64,62,170,243,131,64,63,255,243,131,64,56,44,3,131,64,56,44,3,131,64,63,255,243,131,64,63,125,179,131,64,59,44,115,131,64,59,44,115,131,64,123,44,114,131,64,183,44,112,3,64,183,46,240,3,64,226,44,64,3,64,192,44,0,255,64,0,28,0,121,0,
  // 0x5275  創
  117,82,17,19,95,19,1,254,0,80,0,1,0,0,253,0,7,64,3,223,65,7,64,15,67,231,7,64,127,255,247,7,64,244,0,7,7,64,149,85,71,7,64,31,255,199,7,64,28,1,199,7,64,31,255,199,7,64,29,86,199,7,64,47,255,199,7,64,44,0,7,7,64,63,255,210,7,64,63,85,208,7,64,123,0,208,7,64,247,85,208,7,64,215,255,208,255,64,6,0,144,169,0,
  // 0x529b  力
  155,82,16,19,76,19,1,254,0,2,0,0,0,7,64,0,0,7,64,0,0,7,64,0,0,7,64,0,127,255,255,255,127,255,255,255,0,11,64,11,0,15,0,15,0,15,0,15,0,30,0,15,0,45,0,15,0,60,0,14,0,184,0,14,1,240,0,30,7,208,0,45,31,64,0,60,189,0,47,248,32,0,11,160,
  // 0x52a0  加
  160,82,17,19,95,19,1,254,1,0,0,0,0,7,64,0,0,0,7,64,0,0,0,7,64,15,255,64,255,255,79,175,64,175,239,77,7,64,11,7,77,7,64,11,7,77,7,64,11,7,77,7,64,15,7,77,7,64,15,7,77,7,64,14,7,13,7,64,30,11,13,7,64,45,11,13,7,64,60,11,13,7,64,120,15,15,175,64,241,190,15,255,64,224,252,13,7,64,0,0,4,0,0,
  // 0x52d5  動
  213,82,17,19,95,19,1,254,0,0,1,64,0,90,191,131,192,0,255,249,3,192,0,85,229,67,192,0,255,255,211,192,0,0,208,63,255,192,191,255,215,235,192,177,210,195,131,128,177,210,195,131,128,191,255,195,131,128,176,210,195,67,128,191,255,199,67,128,1,208,11,3,128,191,255,207,3,128,21,229,109,7,64,0,230,188,7,64,175,255,244,11,0,254,150,224,255,0,0,0,128,168,0,
  // 0x5316  化
  22,83,19,18,90,19,0,254,0,45,60,0,0,0,60,60,0,0,0,180,60,0,0,0,240,60,0,64,3,208,60,7,192,11,208,60,47,128,31,208,60,253,0,126,208,63,224,0,53,208,62,0,0,17,208,60,0,0,1,208,60,0,0,1,208,60,0,0,1,208,60,0,0,1,208,60,0,116,1,208,60,0,176,1,208,60,0,240,1,208,47,255,224,1,208,6,170,64,
  // 0x534a  半
  74,83,17,19,95,19,1,254,0,1,128,0,0,14,1,208,60,0,15,1,208,60,0,7,129,208,180,0,3,193,208,240,0,2,193,209,208,0,0,1,208,0,0,63,255,255,255,0,42,171,250,170,0,0,1,208,0,0,0,1,208,0,0,191,255,255,255,128,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,128,0,0,
  // 0x5354  協
  84,83,17,19,95,19,1,254,9,0,5,0,0,14,0,15,0,0,14,1,95,85,0,14,7,255,255,0,14,0,44,7,0,175,144,120,11,0,255,242,240,15,0,14,15,128,254,0,14,6,0,180,0,14,7,0,116,0,14,27,81,185,64,14,63,251,255,192,14,11,56,178,192,14,14,52,226,192,14,13,52,226,192,14,28,53,210,192,14,56,119,195,128,14,178,247,31,64,5,0,64,5,0,
  // 0x5361  卡
  97,83,17,19,95,19,1,254,0,2,128,0,0,0,3,192,0,0,0,3,192,0,0,0,3,255,252,0,0,3,234,168,0,0,3,192,0,0,0,3,192,0,0,170,171,234,170,128,255,255,255,255,192,0,3,192,0,0,0,3,208,0,0,0,3,255,128,0,0,3,219,248,0,0,3,192,125,0,0,3,192,4,0,0,3,192,0,0,0,3,192,0,0,0,3,192,0,0,0,2,128,0,0,
  // 0x5370  印
  112,83,16,19,76,19,2,254,0,16,0,0,1,248,0,0,111,228,255,253,253,0,250,189,224,0,224,29,224,0,224,29,224,0,224,29,250,164,224,29,255,248,224,29,224,0,224,29,224,0,224,29,224,0,224,29,224,0,224,29,250,168,224,29,255,252,227,253,224,0,225,248,160,0,224,0,0,0,224,0,0,0,144,0,
  // 0x5378  卸
  120,83,18,19,95,19,0,254,2,64,0,0,0,3,128,2,170,144,7,234,147,255,224,15,255,243,128,224,45,56,3,128,224,40,56,3,128,224,42,190,167,128,224,63,255,247,128,224,0,56,3,128,224,4,56,3,128,224,13,61,83,128,224,13,63,227,128,224,13,56,3,128,224,13,56,3,128,224,13,56,23,143,208,14,191,247,139,128,127,254,87,128,0,41,0,3,128,0,0,0,2,64,0,
  // 0x537b  卻
  123,83,17,19,95,19,1,254,0,80,0,0,0,2,248,10,170,64,7,239,15,255,128,31,11,206,3,128,188,2,222,3,128,112,160,78,3,128,2,248,14,3,128,7,238,14,3,128,31,15,142,3,128,125,3,222,3,128,248,1,206,3,128,111,255,14,3,128,30,171,14,3,128,28,7,14,63,64,28,7,14,62,0,30,171,14,0,0,31,255,14,0,0,28,7,14,0,0,4,0,9,0,0,
  // 0x539f  原
  159,83,17,18,90,19,1,254,26,170,170,170,128,47,255,255,255,192,44,0,60,0,0,44,21,185,84,0,44,127,255,253,0,44,116,0,29,0,44,121,85,109,0,44,127,255,253,0,44,116,0,29,0,44,121,85,109,0,60,127,255,253,0,60,0,60,0,0,56,45,60,116,0,116,124,60,61,0,181,240,60,15,64,247,192,60,3,192,225,7,248,1,0,0,2,144,0,0,
  // 0x53cd  反
  205,83,17,18,90,19,1,254,10,170,170,170,0,15,255,255,255,0,15,0,0,0,0,15,0,0,0,0,15,0,0,0,0,15,170,170,168,0,15,255,255,252,0,15,60,0,120,0,15,29,0,240,0,15,15,1,240,0,14,11,131,208,0,30,3,223,128,0,45,0,255,0,0,60,0,254,0,0,60,7,255,208,0,180,191,131,254,0,241,248,0,127,128,16,64,0,2,0,
  // 0x53d6  取
  214,83,18,18,90,19,0,254,42,170,160,0,0,63,255,244,0,0,11,2,207,255,224,11,2,207,171,224,11,171,207,1,208,11,255,203,2,192,11,2,199,67,192,11,2,195,131,128,11,171,195,203,64,11,255,193,223,0,11,2,192,254,0,11,2,192,188,0,11,91,192,188,0,127,255,193,255,0,62,146,199,223,128,0,2,239,67,240,0,2,237,0,240,0,1,128,0,0,
  // 0x53f0  台
  240,83,17,19,95,19,1,254,0,8,0,0,0,0,31,0,0,0,0,61,0,0,0,0,120,3,192,0,0,240,2,240,0,2,224,0,188,0,191,251,255,255,0,191,255,255,175,128,0,0,0,3,128,0,0,0,0,0,11,255,255,248,0,11,234,170,248,0,11,0,0,120,0,11,0,0,120,0,11,0,0,120,0,11,0,0,120,0,11,255,255,248,0,11,234,170,248,0,6,0,0,36,0,
  // 0x5408  合
  8,84,17,19,95,19,1,254,0,1,144,0,0,0,7,240,0,0,0,15,188,0,0,0,61,47,0,0,0,248,11,192,0,3,224,2,244,0,31,128,0,190,0,189,255,255,223,192,224,170,170,129,128,0,0,0,0,0,2,170,170,160,0,7,255,255,244,0,7,64,0,116,0,7,64,0,116,0,7,64,0,116,0,7,64,0,116,0,7,170,170,180,0,7,255,255,244,0,2,64,0,100,0,
  // 0x5426  否
  38,84,17,18,90,19,1,254,106,170,170,170,64,191,255,255,255,128,0,1,244,0,0,0,7,208,0,0,0,47,219,128,0,2,254,215,248,0,47,209,208,127,64,254,1,208,11,192,96,1,208,1,0,0,0,64,0,0,11,255,255,252,0,11,170,170,188,0,11,0,0,60,0,11,0,0,60,0,11,0,0,60,0,11,255,255,252,0,11,170,170,188,0,6,0,0,36,0,
  // 0x544a  告
  74,84,17,19,95,19,1,254,1,64,160,0,0,3,192,240,0,0,7,128,240,0,0,15,255,255,253,0,47,170,250,169,0,124,0,240,0,0,52,0,240,0,0,106,170,250,170,128,255,255,255,255,192,0,0,0,0,0,0,0,0,0,0,11,255,255,252,0,11,170,170,188,0,11,64,0,60,0,11,64,0,60,0,11,64,0,60,0,11,255,255,252,0,11,170,170,188,0,7,0,0,40,0,
  // 0x547d  命
  125,84,17,19,95,19,1,254,0,2,144,0,0,0,11,244,0,0,0,47,124,0,0,0,188,31,64,0,3,240,3,224,0,31,234,170,253,0,254,127,255,111,192,224,0,0,2,192,26,169,42,169,0,31,254,63,254,0,28,14,56,14,0,28,14,56,14,0,28,14,56,14,0,28,14,56,14,0,31,254,56,14,0,30,169,56,254,0,28,0,56,164,0,0,0,56,0,0,0,0,36,0,0,
  // 0x548c  和
  140,84,17,18,90,19,0,254,0,111,192,0,0,47,254,74,170,128,25,180,15,255,192,0,116,14,2,192,0,116,14,2,192,42,250,158,2,192,63,255,222,2,192,0,244,14,2,192,2,253,14,2,192,3,255,14,2,192,11,183,206,2,192,14,117,206,2,192,60,116,14,2,192,120,116,15,171,192,32,116,15,255,192,0,116,14,2,192,0,116,9,1,128,0,96,0,0,0,
  // 0x555f  啟
  95,85,17,19,95,19,1,254,0,128,1,128,0,1,208,2,192,0,0,224,3,192,0,63,255,131,128,0,62,171,135,255,192,56,3,139,175,128,56,3,143,11,0,62,171,159,75,0,63,255,191,79,0,56,0,27,142,0,56,0,2,221,0,59,255,193,252,0,59,151,192,248,0,119,66,192,180,0,183,66,192,252,0,243,151,195,238,0,227,255,207,79,128,131,66,238,3,192,1,0,4,0,64,
  // 0x55ae  單
  174,85,17,18,90,19,1,254,47,255,63,254,0,44,15,60,14,0,44,15,60,14,0,47,255,63,254,0,0,0,0,0,0,15,255,255,252,0,15,86,229,124,0,15,86,229,108,0,15,255,255,252,0,14,1,208,44,0,15,86,229,124,0,15,255,255,252,0,0,1,208,0,0,106,171,234,170,64,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,
  // 0x5634  嘴
  52,86,17,19,95,19,1,254,0,0,144,128,0,0,0,209,193,0,191,204,229,223,64,187,204,254,248,0,162,204,209,192,64,162,204,229,192,192,162,239,253,255,192,162,234,240,85,0,162,194,255,208,0,162,203,131,192,0,162,255,255,255,0,191,219,71,7,0,186,71,255,255,0,160,7,71,7,0,96,11,75,11,0,0,15,255,255,0,0,45,0,11,0,0,120,0,191,0,0,0,0,16,0,
  // 0x5668  器
  104,86,18,18,90,19,1,254,47,254,47,254,0,45,110,45,94,0,44,14,44,14,0,44,14,44,14,0,47,254,47,254,0,21,87,197,85,0,0,7,128,0,0,255,255,255,255,192,170,254,175,170,128,2,240,7,208,0,31,192,0,253,0,255,254,47,255,208,254,94,45,111,192,28,14,44,13,0,28,14,44,13,0,30,94,45,109,0,31,254,47,253,0,24,14,44,9,0,
  // 0x5674  噴
  116,86,17,19,95,19,1,254,0,0,6,0,0,0,0,11,64,0,106,139,255,255,64,191,208,7,0,0,177,209,199,44,0,177,239,255,255,192,177,209,208,44,0,177,208,64,4,0,177,215,255,255,0,177,215,64,11,0,177,215,255,255,0,186,215,64,11,0,191,215,255,255,0,176,7,64,11,0,96,7,255,255,0,0,1,224,116,0,0,27,208,63,0,0,126,0,7,192,0,16,0,1,0,
  // 0x56de  回
  222,86,17,18,90,19,1,254,127,255,255,255,64,127,255,255,255,64,116,0,0,7,64,116,0,0,7,64,116,0,0,7,64,116,127,255,7,64,116,122,175,7,64,116,116,11,7,64,116,116,11,7,64,116,116,11,7,64,116,122,175,7,64,116,127,255,7,64,116,0,0,7,64,116,0,0,7,64,116,0,0,7,64,127,255,255,255,64,126,170,170,175,64,100,0,0,6,64,
  // 0x56e0  因
  224,86,17,18,90,19,1,254,106,170,170,170,64,127,255,255,255,64,116,0,64,7,64,116,1,192,7,64,116,1,192,7,64,117,171,234,151,64,119,255,255,231,64,116,3,224,7,64,116,3,240,7,64,116,11,180,7,64,116,15,60,7,64,116,61,15,7,64,118,244,7,231,64,118,208,1,215,64,116,0,0,7,64,127,255,255,255,64,126,170,170,175,64,96,0,0,2,64,
  // 0x56fa  固
  250,86,17,18,90,19,1,254,42,170,170,170,0,127,255,255,255,64,116,0,64,7,64,116,1,208,7,64,116,1,208,7,64,118,255,255,231,64,116,86,229,87,64,116,1,208,7,64,116,22,229,7,64,116,127,255,135,64,116,112,3,135,64,116,112,3,135,64,116,127,255,135,64,116,21,85,7,64,116,0,0,7,64,127,255,255,255,64,126,170,170,175,64,36,0,0,6,64,
  // 0x5716  圖
  22,87,17,18,90,19,1,254,127,255,255,255,64,121,85,85,91,64,112,127,255,3,64,112,112,7,3,64,112,112,7,3,64,112,127,255,3,64,112,1,192,3,64,115,255,255,247,64,112,255,255,195,64,112,208,2,195,64,112,219,246,195,64,112,217,38,195,64,112,215,246,195,64,112,208,2,195,64,112,255,255,195,64,121,85,85,91,64,127,255,255,255,64,96,0,0,2,64,
  // 0x5728  在
  40,87,17,19,95,19,1,254,0,5,0,0,0,0,15,0,0,0,0,30,0,0,0,170,191,170,170,128,255,255,255,255,192,0,180,0,0,0,1,224,15,0,0,3,192,15,0,0,11,128,15,0,0,63,74,175,170,0,255,79,255,255,0,251,64,15,0,0,71,64,15,0,0,7,64,15,0,0,7,64,15,0,0,7,64,15,0,0,7,90,175,170,128,7,111,255,255,192,7,64,0,0,0,
  // 0x578b  型
  139,87,17,18,90,19,1,255,0,0,0,6,0,63,255,208,11,0,47,175,131,75,0,7,15,3,75,0,7,15,3,75,0,111,175,147,75,0,191,255,243,75,0,15,15,3,75,0,14,15,0,11,0,60,15,0,175,0,180,15,64,253,0,0,1,208,0,0,10,170,250,168,0,15,255,255,252,0,0,1,208,0,0,0,1,208,0,0,170,171,250,170,128,255,255,255,255,192,
  // 0x57f7  執
  247,87,18,20,100,19,1,253,1,128,6,0,0,2,192,11,0,0,23,213,11,0,0,127,254,11,0,0,2,192,175,169,0,87,213,255,254,0,255,255,75,14,0,56,28,11,14,0,44,44,11,14,0,28,52,255,14,0,255,255,127,14,0,107,234,15,142,0,2,192,31,238,0,87,213,44,238,0,191,254,56,14,64,2,192,240,14,144,2,194,224,11,144,2,199,192,7,192,2,130,0,2,128,0,0,0,0,0,
  // 0x584a  塊
  74,88,17,19,95,19,1,254,9,0,10,0,0,15,0,15,0,0,15,5,111,85,0,15,15,255,255,64,175,159,11,7,64,255,239,95,91,64,15,15,255,255,64,15,15,11,7,64,15,15,11,7,64,15,15,255,255,64,15,6,251,169,0,15,240,215,104,0,127,225,215,118,64,253,2,199,122,192,144,3,199,191,192,0,11,135,64,64,0,47,7,65,192,0,252,3,255,192,0,96,1,170,0,
  // 0x586b  填
  107,88,17,19,95,19,1,254,5,0,6,0,0,14,0,11,0,0,14,31,255,255,192,14,5,95,149,64,14,0,11,0,0,255,227,255,254,0,175,147,128,14,0,14,3,255,254,0,14,3,128,14,0,14,3,255,254,0,14,3,128,14,0,15,179,255,254,0,15,240,0,0,0,191,165,85,85,64,248,63,255,255,192,64,0,160,116,0,0,11,208,62,0,0,63,0,11,192,0,20,0,1,64,
  // 0x588a  墊
  138,88,18,18,90,19,1,255,1,128,2,0,0,2,192,7,0,0,127,254,27,148,0,2,192,127,253,0,255,255,75,13,0,44,45,7,13,0,45,56,191,13,0,255,255,95,77,0,2,192,31,221,64,127,255,60,77,144,2,193,244,14,208,2,192,208,7,192,0,1,208,1,64,5,86,229,84,0,15,255,255,252,0,0,1,208,0,0,106,170,234,170,128,255,255,255,255,192,
  // 0x5916  外
  22,89,18,19,95,19,1,254,0,144,0,144,0,1,224,1,208,0,2,192,1,208,0,3,234,145,208,0,7,255,209,208,0,15,2,245,208,0,30,2,253,208,0,60,3,223,208,0,255,71,75,208,0,231,235,3,224,0,0,255,1,248,0,0,61,1,255,0,0,60,1,235,208,0,244,1,209,192,2,224,1,208,0,11,192,1,208,0,63,0,1,208,0,184,0,1,208,0,16,0,0,144,0,
  // 0x591a  多
  26,89,17,19,95,19,1,254,0,2,64,0,0,0,11,128,0,0,0,63,255,224,0,1,249,87,224,0,47,240,7,192,0,61,126,47,0,0,0,15,248,0,0,0,11,234,0,0,1,190,126,0,0,127,225,255,255,64,57,11,234,175,64,1,191,64,30,0,7,235,224,124,0,1,0,249,240,0,0,0,63,192,0,0,1,254,0,0,1,175,224,0,0,15,253,0,0,0,5,64,0,0,0,
  // 0x5920  夠
  32,89,17,19,95,19,1,254,2,64,4,0,0,7,64,14,0,0,15,254,29,0,0,61,109,62,170,64,240,60,127,255,128,158,120,240,3,128,11,242,224,3,128,7,194,255,243,128,47,224,61,179,128,186,229,56,179,128,7,255,120,179,128,46,11,56,179,128,248,14,61,179,64,151,188,63,243,64,2,244,56,3,64,2,224,20,7,64,31,128,0,11,0,253,0,0,255,0,144,0,0,168,0,
  // 0x5927  大
  39,89,17,19,95,19,1,254,0,1,144,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,192,0,0,255,255,255,255,192,191,255,255,255,128,0,3,240,0,0,0,11,248,0,0,0,15,60,0,0,0,31,46,0,0,0,61,15,0,0,0,188,11,192,0,2,240,3,240,0,11,208,0,252,0,127,64,0,63,64,252,0,0,15,128,16,0,0,1,0,
  // 0x5929  天
  41,89,17,17,85,19,1,254,255,255,255,255,192,191,255,255,255,128,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,63,255,255,255,64,63,255,255,255,0,0,3,240,0,0,0,7,248,0,0,0,15,124,0,0,0,47,47,0,0,0,188,15,128,0,3,244,3,240,0,47,192,0,254,64,254,0,0,47,192,80,0,0,1,0,
  // 0x5931  失
  49,89,17,19,95,19,1,254,0,1,128,0,0,3,194,208,0,0,7,130,208,0,0,11,66,208,0,0,15,255,255,253,0,47,255,255,253,0,60,2,208,0,0,184,2,208,0,0,16,2,192,0,0,191,255,255,255,128,255,255,255,255,192,0,7,244,0,0,0,15,124,0,0,0,47,46,0,0,0,188,15,128,0,3,244,3,240,0,111,192,0,254,64,254,0,0,47,192,16,0,0,1,64,
  // 0x59cb  始
  203,89,18,19,95,19,1,254,6,0,5,0,0,11,0,15,0,0,15,0,15,0,0,14,0,30,4,0,175,168,44,45,0,255,252,60,15,0,44,60,120,91,128,60,59,255,255,192,56,58,169,81,208,116,116,0,0,0,176,176,106,170,64,253,240,191,255,64,175,224,176,7,64,3,240,176,7,64,7,252,176,7,64,15,44,176,7,64,125,4,191,255,64,180,0,186,171,64,16,0,96,1,0,
  // 0x5a92  媒
  146,90,17,19,95,19,1,254,9,0,80,4,0,14,0,224,29,0,14,5,245,110,64,13,15,255,255,192,29,0,224,29,0,255,244,229,109,0,190,240,255,253,0,56,112,224,29,0,52,176,245,109,0,112,240,255,253,0,176,224,3,64,0,249,213,91,149,64,191,207,255,255,192,7,192,47,240,0,11,240,191,184,0,31,118,231,94,0,124,47,195,75,192,244,14,3,66,128,0,0,2,64,0,
  // 0x5b50  子
  80,91,17,17,85,19,1,254,15,255,255,252,0,10,170,171,252,0,0,0,3,224,0,0,0,31,128,0,0,1,252,0,0,0,1,224,0,0,0,1,208,0,0,255,255,255,255,192,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,255,192,0,0,0,126,64,0,0,
  // 0x5b58  存
  88,91,17,19,95,19,1,254,0,9,0,0,0,0,15,0,0,0,0,30,0,0,0,255,255,255,255,192,170,254,170,170,128,0,240,0,0,0,1,226,170,168,0,3,195,255,254,0,11,128,0,124,0,47,64,1,240,0,127,64,7,192,0,255,64,7,64,0,219,111,255,255,192,11,90,175,234,128,11,64,7,64,0,11,64,7,64,0,11,64,7,64,0,11,64,255,0,0,6,0,169,0,0,
  // 0x5b89  安
  137,91,17,19,95,19,1,254,0,1,144,0,0,0,1,208,0,0,42,171,250,170,64,127,255,255,255,64,116,2,0,7,64,116,11,64,7,64,0,15,0,0,0,0,30,0,0,0,255,255,255,255,192,170,254,171,250,128,0,240,3,192,0,1,224,3,192,0,3,224,11,64,0,11,254,110,0,0,6,27,253,0,0,0,7,255,128,0,5,191,71,248,0,63,244,0,126,0,25,0,0,8,0,
  // 0x5b8c  完
  140,91,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,106,171,250,170,64,127,255,255,255,64,116,0,0,7,64,116,0,0,7,64,98,255,255,214,64,1,170,170,144,0,0,0,0,0,0,170,170,170,170,128,255,255,255,255,192,0,120,29,0,0,0,116,29,0,0,0,240,29,0,0,1,240,29,2,128,7,208,29,2,192,127,64,15,171,192,252,0,11,255,64,0,0,0,0,0,
  // 0x5b9a  定
  154,91,17,19,95,19,1,254,0,1,144,0,0,0,1,208,0,0,106,171,250,170,64,127,255,255,255,64,116,0,0,7,64,116,0,0,7,64,118,170,170,167,64,3,255,255,240,0,0,1,208,0,0,1,65,208,0,0,3,193,208,0,0,3,129,255,252,0,11,129,250,168,0,15,193,208,0,0,31,241,208,0,0,60,127,208,0,0,184,31,255,170,128,240,1,191,255,128,0,0,0,0,0,
  // 0x5ba2  客
  162,91,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,127,255,255,255,64,122,170,170,171,64,112,30,0,7,64,112,62,85,71,64,0,255,255,208,0,7,244,7,128,0,63,126,47,0,0,20,11,248,0,0,0,47,254,64,0,6,253,27,254,64,255,229,86,255,128,103,255,255,240,0,2,192,0,240,0,2,192,0,240,0,2,213,85,240,0,2,255,255,240,0,1,128,0,160,0,
  // 0x5bb9  容
  185,91,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,127,255,255,255,64,122,170,170,175,64,116,36,1,7,64,96,244,11,198,64,3,209,66,244,0,47,131,240,125,0,45,15,188,14,0,0,62,31,64,0,1,248,7,208,0,11,224,1,252,0,127,255,255,255,128,187,234,170,247,128,2,192,0,240,0,2,192,0,240,0,2,234,170,240,0,2,255,255,240,0,1,128,0,144,0,
  // 0x5c0d  對
  13,92,17,19,95,19,1,254,2,20,0,8,0,231,40,224,29,0,183,41,192,29,0,59,43,128,29,0,107,126,128,29,0,255,255,245,111,128,28,11,47,255,192,29,14,0,29,0,13,13,0,29,0,127,255,206,29,0,22,245,75,29,0,0,224,3,157,0,63,255,67,221,0,22,229,0,29,0,0,224,0,29,0,1,251,208,29,0,255,255,208,29,0,233,64,3,252,0,0,0,1,164,0,
  // 0x5c0f  小
  15,92,18,19,95,19,1,254,0,0,64,0,0,0,1,224,0,0,0,1,224,0,0,0,1,224,0,0,0,1,224,0,0,6,1,224,96,0,11,65,224,184,0,15,1,224,60,0,15,1,224,45,0,30,1,224,15,0,61,1,224,15,64,60,1,224,7,128,184,1,224,3,192,240,1,224,3,208,0,1,224,1,128,0,1,224,0,0,0,1,208,0,0,0,255,208,0,0,0,126,64,0,0,
  // 0x5c31  就
  49,92,18,19,95,19,1,254,1,208,1,128,0,1,208,2,221,0,1,208,2,207,0,255,255,194,195,128,170,170,130,194,128,0,0,43,234,128,63,255,127,255,192,61,91,2,192,0,56,7,3,240,0,61,91,3,240,0,63,255,3,240,0,0,208,7,240,0,56,219,11,176,0,52,215,79,112,0,176,211,174,112,128,240,210,188,112,208,209,208,248,112,208,15,209,240,127,192,6,64,64,26,64,
  // 0x5de5  工
  229,93,17,15,75,19,1,0,63,255,255,255,0,63,255,255,255,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,0,2,208,0,0,255,255,255,255,192,255,255,255,255,192,
  // 0x5dee  差
  238,93,17,19,95,19,1,254,0,64,0,64,0,1,224,2,208,0,0,176,3,128,0,63,255,255,255,0,42,170,234,170,0,0,1,208,0,0,15,255,255,252,0,5,86,229,84,0,0,1,208,0,0,255,255,255,255,192,106,250,170,170,64,2,208,0,0,0,3,239,255,252,0,7,154,190,168,0,15,64,60,0,0,46,0,60,0,0,125,170,190,170,64,245,255,255,255,64,0,0,0,0,0,
  // 0x5df2  已
  242,93,16,17,68,19,2,255,170,170,170,144,255,255,255,224,0,0,0,224,0,0,0,224,120,0,0,224,120,0,0,224,120,0,0,224,126,170,171,224,127,255,255,224,120,0,0,224,120,0,0,0,120,0,0,0,120,0,0,15,120,0,0,15,56,0,0,30,63,234,170,253,11,255,255,244,
  // 0x5e73  平
  115,94,17,17,85,19,1,254,63,255,255,255,0,42,171,250,170,0,1,1,208,16,0,11,65,208,120,0,3,193,208,176,0,2,193,208,224,0,1,209,210,192,0,0,1,208,0,0,255,255,255,255,192,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,144,0,0,
  // 0x5e8a  床
  138,94,17,19,95,19,1,254,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,47,255,255,255,192,46,170,170,170,128,44,0,40,0,0,44,0,44,0,0,44,0,44,0,0,44,255,255,255,192,44,170,255,170,128,60,0,255,0,0,60,2,255,192,0,60,7,189,224,0,56,31,44,184,0,116,125,44,62,0,178,244,44,15,192,241,208,44,2,128,224,0,44,0,0,0,0,40,0,0,
  // 0x5ea6  度
  166,94,17,19,95,19,1,254,0,0,160,0,0,0,0,240,0,0,26,170,250,170,128,47,255,255,255,192,44,6,0,80,0,44,11,0,240,0,45,255,255,255,128,44,95,85,245,64,44,11,0,240,0,44,11,255,240,0,60,1,85,80,0,60,85,85,84,0,57,255,255,253,0,56,15,0,120,0,116,7,210,240,0,176,0,255,128,0,240,23,255,228,0,227,255,146,255,192,65,144,0,6,64,
  // 0x5ee2  廢
  226,94,17,19,95,19,1,254,0,0,160,0,0,0,0,240,0,0,63,255,255,255,192,61,85,90,101,64,56,255,203,120,0,56,87,195,209,0,56,235,1,239,64,56,125,0,125,0,62,255,143,255,192,59,131,157,114,128,56,3,156,115,0,52,255,184,63,0,52,208,32,0,0,117,192,63,253,0,178,255,93,44,0,240,3,75,176,0,224,7,11,249,0,208,255,125,47,128,0,16,0,1,0,
  // 0x5efa  建
  250,94,17,19,95,19,1,254,0,0,9,0,0,170,69,95,85,0,255,139,255,255,0,11,0,14,15,0,15,21,95,95,64,45,63,255,255,192,60,0,14,15,0,127,223,255,255,0,250,213,95,85,0,1,197,95,85,0,98,207,255,255,0,115,192,14,0,0,59,149,95,85,64,47,111,255,255,192,15,64,14,0,0,47,228,10,0,0,124,191,250,170,128,240,6,255,255,192,0,0,0,0,0,
  // 0x5f15  引
  21,95,15,19,76,19,1,254,0,0,0,24,63,255,128,44,42,171,128,44,0,3,128,44,0,3,128,44,0,3,128,44,47,255,128,44,62,170,64,44,60,0,0,44,56,0,0,44,127,255,128,44,186,171,128,44,32,7,64,44,0,7,64,44,0,11,64,44,0,11,0,44,0,15,0,44,11,254,0,44,6,232,0,44,
  // 0x5f85  待
  133,95,17,19,95,19,1,254,0,0,6,0,0,3,192,11,0,0,15,64,11,0,0,62,11,255,255,64,248,6,175,170,0,81,208,11,0,0,3,218,175,170,128,15,47,255,255,192,63,0,0,56,0,255,0,0,56,0,251,26,170,190,128,139,47,255,255,192,11,0,0,56,0,11,3,192,56,0,11,1,224,56,0,11,0,240,56,0,11,0,16,56,0,11,0,11,248,0,6,0,6,144,0,
  // 0x5f8c  後
  140,95,17,19,95,19,1,254,1,64,20,0,0,7,128,60,0,0,31,4,240,116,0,124,31,208,240,0,240,75,195,192,0,67,193,255,68,0,7,128,124,45,0,15,22,249,95,0,127,63,255,255,192,255,0,124,2,192,219,0,249,84,0,11,3,255,253,0,11,31,208,60,0,11,61,240,240,0,11,16,63,208,0,11,0,47,192,0,11,6,250,249,0,11,63,128,63,192,10,36,0,1,64,
  // 0x5f91  徑
  145,95,18,19,95,19,0,254,0,64,0,0,0,1,226,170,170,160,3,195,255,255,240,31,0,0,0,0,60,0,241,211,192,32,177,211,135,64,1,227,139,14,0,3,199,79,29,0,15,194,199,75,0,63,192,226,195,192,122,192,176,225,208,18,192,0,0,64,2,195,255,255,208,2,194,171,234,128,2,192,2,192,0,2,192,2,192,0,2,202,171,234,160,2,207,255,255,240,2,192,0,0,0,
  // 0x5f9e  從
  158,95,17,19,95,19,1,254,1,64,144,20,0,7,128,224,56,0,15,1,208,56,0,124,2,192,116,0,240,3,240,252,0,130,203,189,255,0,7,143,11,203,128,15,60,15,2,192,63,4,7,0,0,255,0,7,0,0,235,3,135,0,0,75,7,71,149,0,11,7,71,255,0,11,11,135,0,0,11,15,199,0,0,11,30,247,0,0,11,60,127,64,0,11,184,31,255,192,11,16,1,106,64,
  // 0x5fa9  復
  169,95,17,19,95,19,1,254,2,64,128,0,0,11,130,192,0,0,31,3,255,255,192,124,11,149,85,64,240,95,0,0,0,67,255,255,255,0,11,131,192,15,0,31,3,255,255,0,63,3,192,15,0,255,3,192,15,0,235,3,255,255,0,75,0,116,0,0,11,1,255,254,0,11,11,244,124,0,11,46,120,244,0,11,4,47,208,0,11,1,191,249,0,11,63,228,127,192,10,21,0,1,64,
  // 0x5fae  微
  174,95,18,19,95,19,0,254,1,64,128,20,0,3,192,192,60,0,15,28,202,56,0,61,28,202,52,0,52,172,202,191,240,2,238,238,250,224,3,159,255,240,208,15,64,2,241,192,47,64,3,241,192,127,111,255,54,192,55,95,189,43,128,3,75,44,31,64,3,75,44,15,0,3,75,44,15,0,3,78,63,111,0,3,93,125,127,192,3,124,17,241,240,3,96,3,192,176,2,0,1,0,16,
  // 0x5fc3  心
  195,95,19,19,95,19,0,254,0,1,0,0,0,0,15,208,0,0,0,2,253,0,0,0,0,47,192,0,0,0,7,192,0,0,0,0,0,0,0,14,0,0,0,0,14,0,13,0,11,14,0,15,0,15,14,0,11,128,15,14,0,3,192,14,14,0,1,224,29,14,0,0,240,60,14,0,36,180,124,14,0,60,96,16,14,0,56,0,0,14,0,116,0,0,15,255,240,0,0,2,170,128,0,
  // 0x6027  性
  39,96,18,19,95,19,0,254,2,128,0,144,0,3,192,97,208,0,3,192,177,208,0,3,208,241,208,0,43,248,251,250,144,43,237,255,255,224,59,207,193,208,0,55,199,129,208,0,115,195,65,208,0,35,192,1,208,0,3,192,255,255,192,3,192,171,250,128,3,192,1,208,0,3,192,1,208,0,3,192,1,208,0,3,192,1,208,0,3,198,171,250,160,3,203,255,255,240,2,128,0,0,0,
  // 0x6062  恢
  98,96,17,19,95,19,1,254,5,2,0,0,0,15,7,0,0,0,15,31,170,170,128,15,127,255,255,192,95,199,0,64,0,175,167,1,208,0,159,119,1,208,0,223,39,53,210,192,207,7,49,211,128,143,7,113,215,0,15,11,177,219,0,15,11,82,228,0,15,15,3,240,0,15,14,7,176,0,15,29,15,60,0,15,44,45,30,0,15,56,184,15,128,15,178,224,3,192,10,16,64,0,64,
  // 0x606f  息
  111,96,17,19,95,19,1,254,0,1,144,0,0,0,3,192,0,0,7,255,255,248,0,7,149,85,184,0,7,149,85,120,0,7,255,255,248,0,7,64,0,120,0,7,149,85,120,0,7,255,255,248,0,7,64,0,120,0,7,255,255,248,0,1,86,149,80,0,0,3,192,0,0,29,97,240,56,0,44,116,116,46,0,60,116,17,79,64,240,116,2,195,192,160,63,255,129,128,0,26,169,0,0,
  // 0x61b6  憶
  182,97,17,19,95,19,1,254,10,0,6,0,0,15,1,91,85,0,15,15,255,255,128,15,64,224,60,0,95,192,176,52,0,175,191,255,255,192,159,117,85,85,64,223,19,255,255,0,207,3,128,11,0,207,3,128,11,0,15,3,255,255,0,15,3,128,11,0,15,3,255,255,0,15,0,15,0,0,15,10,119,206,0,15,14,112,11,64,15,44,112,43,192,15,56,63,249,192,10,0,21,80,0,
  // 0x61c9  應
  201,97,18,19,95,19,0,254,0,0,40,0,0,0,0,60,0,0,15,255,255,255,240,15,90,110,105,80,14,15,29,56,0,14,29,63,255,208,14,124,248,112,0,15,254,255,255,192,15,236,120,112,0,14,28,63,255,192,14,28,56,112,0,14,28,63,255,224,13,24,40,0,0,29,0,31,64,0,28,56,211,139,0,44,52,208,19,192,56,240,224,45,224,116,208,255,248,176,16,0,21,80,0,
  // 0x6210  成
  16,98,17,20,100,19,1,253,0,0,40,80,0,0,0,60,248,0,0,0,60,30,0,26,170,190,175,128,47,255,255,255,192,44,0,44,0,0,44,0,44,0,0,44,0,45,14,0,47,255,29,29,0,46,175,30,60,0,44,15,15,120,0,60,15,15,240,0,60,15,11,208,0,60,14,11,193,64,61,254,31,193,192,120,164,127,210,192,180,1,248,243,192,240,7,224,191,128,144,2,64,30,0,0,0,0,0,0,
  // 0x6236  戶
  54,98,15,19,76,19,1,254,0,0,0,144,0,1,111,240,10,255,249,64,11,229,0,0,11,0,0,0,11,170,170,168,11,255,255,252,11,0,0,60,11,0,0,60,11,0,0,60,11,0,0,60,15,255,255,252,15,170,170,188,14,0,0,40,45,0,0,0,60,0,0,0,184,0,0,0,240,0,0,0,16,0,0,0,
  // 0x6240  所
  64,98,19,19,95,19,0,254,0,0,0,0,64,26,170,128,11,224,63,255,218,255,128,0,0,15,228,0,10,170,143,0,0,15,255,207,0,0,13,3,207,0,0,13,3,207,255,244,13,3,207,175,224,15,171,207,7,64,15,255,206,7,64,29,0,14,7,64,29,0,29,7,64,28,0,44,7,64,44,0,60,7,64,60,0,180,7,64,56,0,240,7,64,116,1,208,7,64,16,0,64,2,64,
  // 0x6247  扇
  71,98,17,18,90,19,1,254,85,85,85,85,0,191,255,255,255,64,0,0,0,0,0,31,255,255,253,0,30,85,85,109,0,29,0,0,13,0,31,255,255,253,0,30,85,85,84,0,29,85,69,85,0,30,255,207,255,0,44,82,198,15,0,44,178,199,143,0,60,38,193,79,0,56,30,193,175,0,182,250,223,143,0,242,66,200,15,0,208,31,192,190,0,0,5,0,20,0,
  // 0x624b  手
  75,98,17,19,95,19,1,254,0,0,0,96,0,0,86,191,252,0,47,255,254,144,0,21,82,208,0,0,0,1,208,0,0,0,1,208,0,0,47,255,255,255,0,42,171,250,170,0,0,1,208,0,0,0,1,208,0,0,170,171,250,170,128,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,255,192,0,0,0,170,0,0,0,
  // 0x6253  打
  83,98,17,19,95,19,1,254,2,64,0,0,0,7,64,0,0,0,7,67,255,255,192,7,67,255,255,192,175,232,0,240,0,255,252,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,252,0,240,0,111,248,0,240,0,255,128,0,240,0,87,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,7,64,0,240,0,127,0,127,240,0,41,0,63,128,0,
  // 0x6279  批
  121,98,18,19,95,19,0,254,2,64,64,16,0,3,130,192,112,0,3,130,192,112,0,3,130,192,112,0,43,230,192,112,0,63,250,192,112,128,3,130,192,114,240,3,130,255,127,192,3,130,234,126,0,3,230,192,116,0,31,246,192,112,0,127,194,192,112,0,19,130,192,112,0,3,130,192,112,0,3,130,192,112,32,3,130,193,112,112,3,135,255,116,112,63,143,233,127,240,25,4,0,26,128,
  // 0x6296  抖
  150,98,17,19,95,19,1,254,6,0,0,36,0,11,0,0,56,0,11,0,240,56,0,11,0,125,56,0,175,160,15,56,0,255,244,0,56,0,11,0,0,56,0,11,3,208,56,0,11,1,252,56,0,11,180,44,56,0,191,244,0,56,0,255,64,0,62,192,75,1,111,255,192,11,11,255,188,0,11,6,64,56,0,11,0,0,56,0,11,0,0,56,0,191,0,0,56,0,100,0,0,36,0,
  // 0x62bd  抽
  189,98,17,19,95,19,1,254,6,0,2,64,0,11,0,3,64,0,11,0,3,64,0,11,0,3,64,0,175,160,3,64,0,255,247,255,255,192,11,7,239,235,192,11,7,3,67,192,11,7,3,67,192,11,187,3,67,192,191,251,255,255,192,255,7,171,235,192,75,7,3,67,192,11,7,3,67,192,11,7,3,67,192,11,7,239,235,192,11,7,255,255,192,191,7,0,3,192,100,6,0,1,64,
  // 0x62d4  拔
  212,98,17,19,95,19,1,254,6,0,36,0,0,11,0,56,184,0,11,0,56,47,0,11,0,56,7,0,175,165,121,85,64,255,251,255,255,192,11,0,116,0,0,11,0,120,4,0,11,0,188,14,0,11,176,188,29,0,191,240,254,44,0,255,0,235,60,0,75,1,215,180,0,11,3,195,240,0,11,7,130,240,0,11,15,7,252,0,11,46,31,47,64,191,60,124,7,192,100,16,16,0,64,
  // 0x6309  按
  9,99,17,19,95,19,1,254,6,0,7,64,0,11,0,7,64,0,11,0,7,64,0,11,11,255,255,192,175,171,170,171,192,255,251,9,2,192,11,11,29,2,192,11,0,44,0,0,11,10,190,170,128,11,191,255,255,192,111,240,176,45,0,255,0,240,60,0,75,1,224,60,0,11,2,253,180,0,11,1,95,240,0,11,0,11,253,0,15,1,190,47,64,191,31,224,7,192,100,5,0,0,0,
  // 0x6389  掉
  137,99,17,19,95,19,1,254,9,0,6,0,0,15,0,11,0,0,15,0,11,255,192,15,0,11,170,64,175,144,11,0,0,255,235,255,255,0,15,11,85,95,0,15,11,0,11,0,15,11,255,255,0,15,235,85,95,0,191,235,0,11,0,255,11,255,255,0,79,5,95,85,0,15,0,11,0,0,15,63,255,255,192,15,26,175,170,128,15,0,11,0,0,254,0,11,0,0,100,0,10,0,0,
  // 0x63a2  探
  162,99,18,19,95,19,1,254,9,0,0,0,0,14,5,85,85,64,14,15,255,255,192,14,14,20,82,192,175,158,52,226,192,255,224,116,224,0,14,0,240,225,192,14,11,192,255,192,14,74,0,21,0,15,224,11,0,0,255,154,175,170,128,238,15,255,255,192,14,0,63,224,0,14,0,191,244,0,14,2,235,60,0,14,11,203,15,64,14,63,11,7,208,254,24,11,0,64,100,0,6,0,0,
  // 0x63a5  接
  165,99,17,19,95,19,1,254,6,0,1,0,0,11,0,11,0,0,11,5,95,149,64,11,15,255,255,128,175,144,224,60,0,255,224,240,56,0,11,0,176,176,0,11,47,255,255,192,11,26,190,170,128,15,160,60,0,0,255,229,189,85,64,255,31,255,255,192,11,0,224,60,0,11,2,208,116,0,11,3,249,240,0,11,1,111,224,0,15,0,111,253,0,191,47,244,31,128,104,25,0,2,0,
  // 0x63a7  控
  167,99,17,19,95,19,1,254,9,0,6,0,0,14,0,11,0,0,14,5,95,149,64,14,31,255,255,192,175,173,52,226,192,255,237,52,225,192,14,0,176,224,0,14,0,240,225,192,14,91,192,255,192,15,238,0,21,0,255,128,0,0,0,238,11,255,255,64,14,6,175,170,0,14,0,11,0,0,14,0,11,0,0,14,0,11,0,0,14,26,175,170,128,254,47,255,255,192,100,0,0,0,0,
  // 0x63d0  提
  208,99,17,19,95,19,1,254,9,0,0,0,0,14,3,255,255,0,14,3,149,95,0,14,3,128,15,0,255,227,255,255,0,175,147,64,15,0,14,3,255,255,0,14,1,85,85,0,14,0,0,0,0,15,175,255,255,192,127,229,95,149,64,254,2,75,0,0,78,3,75,85,0,14,7,75,255,0,14,11,203,0,0,14,15,219,0,0,14,45,191,0,0,253,120,31,255,192,100,32,1,106,128,
  // 0x63d2  插
  210,99,17,19,95,19,1,254,9,0,0,0,0,14,0,21,191,0,14,15,255,249,0,14,1,75,0,0,175,144,7,0,0,255,255,255,255,192,14,10,175,170,128,14,0,7,0,0,14,5,187,21,64,15,223,235,127,128,191,222,7,3,128,254,14,7,3,128,14,15,247,63,128,14,15,151,43,128,14,14,7,3,128,14,14,7,3,128,14,15,255,255,128,254,15,170,171,128,100,9,0,2,64,
  // 0x63db  換
  219,99,17,19,95,19,1,254,9,0,80,0,0,14,0,240,0,0,14,1,255,224,0,14,3,214,208,0,175,159,3,192,0,255,255,255,255,64,14,11,126,219,64,14,11,57,195,64,14,11,53,199,64,15,155,224,255,64,191,219,1,3,64,238,5,11,1,0,14,47,255,255,192,14,21,111,213,64,14,0,47,192,0,14,0,184,240,0,14,7,240,125,0,254,63,128,31,192,100,20,0,1,0,
  // 0x64c7  擇
  199,100,17,19,95,19,1,254,9,0,0,0,0,14,11,255,255,128,14,11,56,227,128,14,11,40,227,128,175,155,255,255,128,255,224,11,64,0,14,1,91,85,0,14,7,255,255,64,14,0,7,0,0,15,255,255,255,192,255,149,245,125,64,238,0,240,56,0,14,15,255,255,192,14,5,91,85,64,14,5,91,85,0,14,11,255,255,128,14,0,7,0,0,254,0,7,0,0,100,0,7,0,0,
  // 0x64ca  擊
  202,100,17,19,95,19,1,254,1,128,0,0,0,191,255,95,248,0,1,192,29,56,64,59,239,60,45,192,59,239,116,31,128,49,199,63,255,0,43,234,29,45,0,255,255,75,184,0,49,202,27,244,0,63,254,121,111,192,0,0,21,145,64,15,255,250,144,0,0,1,208,0,0,47,255,255,255,0,0,2,208,0,0,255,255,255,255,192,0,1,208,0,0,0,63,192,0,0,0,5,0,0,0,
  // 0x64cb  擋
  203,100,18,19,95,19,0,254,2,64,1,128,0,3,128,226,195,192,3,128,242,199,64,3,129,182,219,80,43,231,255,255,240,63,251,64,0,176,3,131,234,170,240,3,128,117,91,0,3,128,112,7,0,7,248,127,255,0,127,224,0,0,0,55,129,255,255,208,3,129,214,214,208,3,129,193,193,208,3,129,255,255,208,3,129,214,214,208,3,129,214,214,208,63,129,255,255,208,25,1,128,1,128,
  // 0x64e0  擠
  224,100,17,19,95,19,1,254,9,0,6,0,0,14,0,11,0,0,14,47,255,255,192,14,21,121,229,64,175,128,36,209,64,255,239,249,239,64,14,10,183,51,0,14,13,103,50,64,14,28,167,122,192,15,246,215,100,128,191,131,64,10,0,222,3,255,255,0,14,3,149,95,0,14,7,64,15,0,14,7,255,255,0,14,11,85,95,0,14,14,0,15,0,253,60,0,15,0,100,4,0,5,0,
  // 0x6536  收
  54,101,18,19,95,19,1,254,0,32,20,0,0,0,116,44,0,0,16,116,60,0,0,56,116,120,0,0,56,116,191,255,208,56,116,250,175,128,56,117,244,15,0,56,119,248,14,0,56,127,124,29,0,56,118,44,44,0,56,116,14,56,0,56,180,15,180,0,127,244,7,240,0,255,180,3,208,0,144,116,15,240,0,0,116,62,188,0,0,118,248,47,128,0,123,208,11,192,0,37,0,0,64,
  // 0x653e  放
  62,101,18,19,95,19,0,254,0,160,1,64,0,0,240,3,192,0,0,240,3,192,0,42,250,135,128,0,63,255,203,255,240,3,128,15,171,224,3,128,31,3,128,3,234,127,71,64,3,255,255,139,0,3,131,179,207,0,3,135,65,222,0,3,71,64,252,0,7,71,64,252,0,11,7,64,184,0,15,7,66,253,0,30,7,7,223,64,60,11,127,7,224,120,255,184,1,240,16,100,16,0,0,
  // 0x6557  敗
  87,101,17,19,95,19,1,254,0,0,9,0,0,127,254,15,0,0,121,110,30,0,0,116,14,45,0,0,121,94,63,255,192,127,254,126,175,128,116,14,188,14,0,116,15,252,29,0,121,95,237,44,0,127,255,142,60,0,116,14,15,120,0,116,14,7,240,0,127,254,3,240,0,25,100,3,224,0,29,56,11,244,0,60,44,47,125,0,184,15,252,31,128,240,6,240,7,192,64,0,64,0,64,
  // 0x6574  整
  116,101,17,19,95,19,1,254,0,128,1,0,0,1,208,7,64,0,255,255,207,85,64,1,208,31,255,192,127,255,190,14,0,113,195,251,44,0,127,255,67,248,0,11,248,2,244,0,46,239,31,254,0,245,194,189,11,192,0,64,16,1,64,63,255,255,255,0,21,86,229,85,0,2,65,208,0,0,3,129,255,248,0,3,129,229,80,0,3,129,208,0,0,255,255,255,255,192,85,85,85,85,64,
  // 0x6578  數
  120,101,17,19,95,19,1,254,0,80,1,64,0,0,224,3,192,0,63,255,195,128,0,120,227,211,128,0,255,255,247,255,192,56,227,203,175,128,63,255,207,11,0,0,224,31,79,0,127,255,255,78,0,112,225,251,205,0,127,255,210,236,0,3,192,1,252,0,87,255,240,248,0,254,91,80,244,0,30,14,2,248,0,63,252,7,253,0,2,254,31,79,64,127,219,189,7,192,36,1,16,0,64,
  // 0x6599  料
  153,101,18,19,95,19,0,254,0,144,0,6,0,0,209,0,11,0,52,211,78,11,0,44,215,11,203,0,28,219,1,219,0,13,237,0,11,0,4,228,0,11,0,63,255,188,11,0,43,250,95,75,0,3,240,3,75,0,7,252,0,11,0,15,238,0,15,176,29,219,91,255,240,60,210,127,239,0,116,208,16,11,0,48,208,0,11,0,0,208,0,11,0,0,208,0,11,0,0,144,0,6,0,
  // 0x659c  斜
  156,101,18,19,95,19,0,254,0,100,0,2,64,0,253,0,3,64,2,239,131,131,64,3,195,210,231,64,15,0,224,187,64,47,170,128,19,64,127,255,193,3,64,32,52,15,67,64,0,52,3,211,64,63,255,240,247,64,42,190,144,3,64,4,52,64,11,240,14,54,198,255,240,29,53,223,235,64,44,52,228,3,64,56,52,176,3,64,32,52,0,3,64,3,244,0,3,64,2,144,0,2,64,
  // 0x65b0  新
  176,101,17,19,95,19,1,254,0,64,0,0,0,1,192,0,31,64,86,229,43,254,0,255,255,174,144,0,40,13,44,0,0,28,28,44,0,0,12,40,44,0,0,255,255,175,255,192,171,234,110,190,128,1,192,44,28,0,255,255,172,28,0,171,234,124,28,0,7,240,56,28,0,15,252,56,28,0,62,223,180,28,0,245,193,240,28,0,209,194,224,28,0,1,195,192,28,0,1,128,0,24,0,
  // 0x65b7  斷
  183,101,17,19,95,19,1,254,0,1,0,1,0,179,6,0,47,128,186,93,203,253,0,186,207,79,128,0,179,71,142,0,0,179,151,222,0,0,191,248,30,0,0,181,85,79,255,192,191,255,223,175,128,179,3,14,13,0,186,77,142,13,0,186,206,142,13,0,179,71,14,13,0,179,154,221,13,0,191,191,252,13,0,181,85,124,13,0,191,255,248,13,0,176,0,112,13,0,16,0,16,9,0,
  // 0x65bc  於
  188,101,17,19,95,19,1,254,2,128,2,128,0,3,192,3,224,0,3,192,11,240,0,171,234,15,116,0,255,255,45,60,0,14,0,60,30,0,14,0,244,15,64,14,2,224,3,192,31,254,194,1,192,31,188,11,192,0,29,44,1,240,0,28,44,0,116,0,44,44,0,0,0,60,44,36,0,0,56,44,63,64,0,116,60,11,240,0,240,60,0,253,0,227,248,0,30,0,65,144,0,4,0,
  // 0x6607  昇
  7,102,17,18,90,19,1,254,15,255,255,252,0,15,85,85,124,0,14,0,0,60,0,15,255,255,252,0,15,85,85,124,0,14,0,0,60,0,15,255,255,252,0,5,86,149,148,0,1,111,210,192,0,63,253,2,192,0,20,120,2,192,0,170,190,171,234,128,255,255,255,255,192,0,180,2,192,0,1,240,2,192,0,11,208,2,192,0,63,0,2,192,0,20,0,1,128,0,
  // 0x660e  明
  14,102,17,18,90,19,1,254,106,168,191,255,128,127,252,186,171,128,112,60,176,3,128,112,60,176,3,128,112,60,176,3,128,122,188,191,255,128,127,252,186,171,128,112,60,176,3,128,112,60,176,3,128,112,60,176,3,128,112,60,255,255,128,127,252,250,171,128,122,168,224,3,128,112,2,208,3,128,16,3,192,3,128,0,15,64,3,128,0,62,0,255,64,0,8,0,105,0,
  // 0x662f  是
  47,102,17,18,90,19,1,254,15,255,255,252,0,15,85,85,124,0,15,0,0,60,0,15,255,255,252,0,15,0,0,60,0,15,85,85,124,0,15,255,255,252,0,0,0,0,0,0,255,255,255,255,192,106,170,250,170,64,2,128,224,0,0,3,128,250,169,0,7,128,255,254,0,15,208,224,0,0,46,249,224,0,0,188,47,250,170,128,240,6,255,255,192,0,0,0,0,0,
  // 0x6642  時
  66,102,17,19,95,19,1,254,0,0,2,64,0,106,160,3,128,0,191,241,171,234,64,176,179,255,255,128,176,176,3,128,0,176,176,3,128,0,176,182,171,234,128,186,251,255,255,192,191,240,0,44,0,176,176,0,44,0,176,187,255,255,192,176,182,170,190,128,176,176,128,44,0,191,240,240,44,0,186,160,120,44,0,176,0,60,44,0,80,0,0,44,0,0,0,7,252,0,0,0,2,144,0,
  // 0x66ab  暫
  171,102,17,19,95,19,1,254,1,192,0,5,0,255,255,154,255,0,1,208,47,144,0,127,255,44,0,0,113,195,109,85,64,127,255,111,255,192,113,195,124,60,0,127,255,116,60,0,255,255,240,60,0,1,209,224,60,0,0,64,0,20,0,7,255,255,244,0,7,149,85,180,0,7,64,0,116,0,7,255,255,244,0,7,128,0,180,0,7,149,85,180,0,7,255,255,244,0,6,0,0,100,0,
  // 0x66f4  更
  244,102,17,18,90,19,1,254,106,170,170,170,64,191,255,255,255,128,0,1,224,0,0,5,86,229,84,0,15,255,255,254,0,14,1,224,14,0,15,86,229,110,0,15,255,255,254,0,14,1,224,14,0,14,1,224,14,0,15,255,255,254,0,6,151,229,84,0,7,131,192,0,0,2,235,128,0,0,0,191,0,0,0,6,255,233,0,0,191,209,255,255,192,100,0,1,106,128,
  // 0x6700  最
  0,103,17,18,90,19,1,254,11,255,255,248,0,11,64,0,120,0,11,255,255,248,0,11,0,0,56,0,11,0,0,120,0,11,255,255,248,0,0,0,0,0,0,255,255,255,255,192,110,95,85,85,64,30,15,21,85,0,31,255,127,255,0,29,11,28,30,0,31,255,14,60,0,30,95,7,248,0,29,11,3,240,0,255,255,31,244,0,165,11,254,63,128,0,11,96,6,128,
  // 0x6709  有
  9,103,17,19,95,19,1,254,0,5,0,0,0,0,15,0,0,0,0,30,0,0,0,255,255,255,255,192,170,254,170,170,128,0,240,0,0,0,1,250,170,164,0,3,255,255,248,0,15,208,0,56,0,47,208,0,56,0,253,255,255,248,0,161,229,85,184,0,1,208,0,56,0,1,255,255,248,0,1,229,85,184,0,1,208,0,56,0,1,208,0,56,0,1,208,15,244,0,0,144,6,144,0,
  // 0x677f  板
  127,103,18,19,95,19,0,254,0,144,0,0,0,1,208,106,170,160,1,208,127,255,240,1,208,116,0,0,42,249,116,0,0,63,254,116,0,0,2,208,122,170,144,3,208,127,255,224,7,240,127,1,192,11,252,187,2,192,14,238,179,131,128,29,218,179,203,64,57,208,241,239,0,113,208,224,253,0,17,209,208,188,0,1,211,193,255,0,1,215,203,203,208,1,219,47,2,240,0,129,4,0,16,
  // 0x67f1  柱
  241,103,19,19,95,19,0,254,0,144,1,0,0,0,224,7,208,0,0,224,1,244,0,0,224,0,124,0,42,250,106,190,160,63,255,191,255,240,1,224,0,176,0,3,224,0,176,0,3,244,0,176,0,7,252,0,176,0,14,239,63,255,224,29,231,42,250,144,60,224,0,176,0,116,224,0,176,0,32,224,0,176,0,0,224,0,176,0,0,225,170,250,160,0,226,255,255,244,0,144,0,0,0,
  // 0x6821  校
  33,104,17,19,95,19,1,254,1,0,1,0,0,7,64,3,128,0,7,64,3,128,0,7,66,171,234,128,175,155,255,255,192,255,244,16,4,0,11,64,180,61,0,15,64,240,15,0,31,195,208,7,128,47,235,180,62,192,63,181,60,120,0,119,116,45,240,0,231,64,15,224,0,199,64,11,192,0,135,64,15,224,0,7,64,62,248,0,7,66,244,63,64,7,79,192,11,192,2,5,0,1,64,
  // 0x683c  格
  60,104,18,19,95,19,0,254,0,128,2,0,0,1,208,11,64,0,1,208,15,170,64,1,208,47,255,128,1,208,124,11,64,63,254,254,15,0,43,251,239,125,0,3,225,131,248,0,3,244,2,244,0,7,253,15,190,0,15,221,189,11,224,30,215,249,91,240,61,209,191,255,192,117,208,52,3,192,33,208,52,3,192,1,208,52,3,192,1,208,58,171,192,1,208,63,255,192,0,128,36,2,128,
  // 0x689d  條
  157,104,18,19,95,19,0,254,0,64,1,0,0,0,224,15,0,0,1,208,31,85,80,3,221,63,255,240,3,141,252,11,64,11,79,239,31,0,31,77,67,252,0,63,77,2,248,0,127,77,47,255,128,55,78,253,7,240,3,77,64,240,16,3,77,85,245,80,3,77,255,255,240,3,77,3,252,0,3,77,15,254,0,3,72,61,247,128,3,66,244,242,240,3,66,192,240,112,2,64,0,160,0,
  // 0x68c4  棄
  196,104,17,19,95,19,1,254,0,1,144,0,0,85,86,229,85,64,255,255,255,255,192,0,120,7,192,0,0,240,2,248,0,63,255,255,255,0,22,149,144,85,0,87,150,229,245,64,255,255,255,255,192,3,129,208,176,0,3,150,213,176,0,3,255,255,240,0,0,1,208,0,0,255,255,255,255,192,85,127,254,85,64,0,249,219,208,0,31,209,209,254,0,253,1,208,31,192,16,1,128,0,0,
  // 0x69fd  槽
  253,105,18,19,95,19,0,254,2,192,6,24,0,2,192,11,44,0,2,195,255,255,240,2,193,95,125,80,43,232,15,60,0,63,253,255,255,224,3,193,203,40,224,3,193,255,255,224,7,225,203,56,224,11,241,203,56,224,15,237,255,255,224,30,204,21,85,64,58,192,191,255,192,114,192,176,3,192,18,192,191,255,192,2,192,176,3,192,2,192,181,87,192,2,192,191,255,192,1,128,160,1,128,
  // 0x6a59  橙
  89,106,19,19,95,19,0,254,1,128,0,16,0,1,193,255,54,64,1,192,95,63,64,1,193,77,29,96,43,234,252,15,208,63,252,189,95,128,2,192,239,254,224,3,199,192,0,244,7,242,85,85,96,11,244,191,255,128,15,236,176,3,128,30,204,176,3,128,61,192,191,255,128,117,192,41,94,0,33,192,60,14,0,1,192,29,28,0,1,194,174,174,160,1,195,255,255,240,1,128,0,0,0,
  // 0x6a5f  機
  95,106,19,19,95,19,0,254,2,128,65,129,0,3,192,226,203,0,3,193,198,205,64,3,199,110,252,208,43,235,246,223,192,63,248,242,203,0,3,193,237,201,160,7,195,222,223,240,11,247,254,254,32,15,244,5,215,64,15,237,86,231,208,31,203,255,255,240,59,192,208,226,64,115,193,244,183,128,19,194,253,127,0,3,195,136,124,32,3,203,2,254,52,3,205,15,75,240,1,64,0,1,64,
  // 0x6aa2  檢
  162,106,18,19,95,19,1,254,6,0,6,64,0,7,0,15,208,0,7,0,61,240,0,7,0,244,124,0,175,167,208,31,64,255,255,255,255,208,15,8,21,80,64,15,64,0,0,0,31,199,252,255,128,47,231,12,211,128,63,187,12,211,128,123,39,252,255,128,231,1,148,101,0,199,0,240,60,0,71,1,224,120,0,7,3,244,189,0,7,11,189,239,64,7,30,7,195,192,6,4,1,0,64,
  // 0x6b62  止
  98,107,17,18,90,19,1,255,0,0,96,0,0,0,0,176,0,0,0,0,176,0,0,0,0,176,0,0,1,0,176,0,0,11,64,176,0,0,11,64,176,0,0,11,64,191,255,0,11,64,191,255,0,11,64,176,0,0,11,64,176,0,0,11,64,176,0,0,11,64,176,0,0,11,64,176,0,0,11,64,176,0,0,11,64,176,0,0,255,255,255,255,192,255,255,255,255,192,
  // 0x6b63  正
  99,107,17,16,80,19,1,255,127,255,255,255,64,42,170,250,170,64,0,0,240,0,0,0,0,240,0,0,0,0,240,0,0,11,64,240,0,0,11,64,250,169,0,11,64,255,254,0,11,64,240,0,0,11,64,240,0,0,11,64,240,0,0,11,64,240,0,0,11,64,240,0,0,11,64,240,0,0,255,255,255,255,192,170,170,170,170,128,
  // 0x6b65  步
  101,107,17,19,95,19,1,254,0,1,144,0,0,1,1,208,0,0,3,129,250,168,0,3,129,255,252,0,3,129,208,0,0,3,129,208,0,0,171,235,250,170,128,255,255,255,255,192,0,1,208,0,0,3,209,208,56,0,15,129,208,120,0,62,1,208,244,0,184,27,210,224,0,16,31,139,192,0,0,0,47,0,0,0,6,252,0,0,1,191,208,0,0,31,249,0,0,0,9,64,0,0,0,
  // 0x6b78  歸
  120,107,17,19,95,19,1,254,6,0,0,0,0,11,0,127,254,0,127,252,21,94,0,117,126,255,255,192,116,60,85,94,64,127,252,0,14,0,117,80,127,254,0,127,252,85,85,64,112,45,255,255,192,117,109,194,194,192,127,253,194,194,192,3,128,87,213,0,115,148,255,255,0,115,252,226,199,0,115,128,226,199,0,115,168,226,203,0,255,253,226,223,0,249,0,2,192,0,0,0,1,128,0,
  // 0x6bbc  殼
  188,107,18,19,95,19,1,254,1,128,0,0,0,86,213,15,252,0,255,255,78,172,0,2,192,13,28,0,2,208,29,28,0,127,255,28,28,208,21,85,60,30,208,255,255,248,15,192,208,3,160,0,0,175,254,127,255,64,5,80,46,175,0,5,84,29,15,0,31,252,15,29,0,44,44,11,188,0,44,44,3,240,0,60,47,135,244,0,120,126,111,190,0,240,18,248,15,192,0,0,128,1,64,
  // 0x6bd4  比
  212,107,18,18,90,19,1,255,6,0,24,0,0,15,0,44,0,0,15,0,44,0,0,15,0,44,0,0,15,0,44,0,0,15,0,44,11,0,15,170,44,191,64,15,255,47,244,0,15,0,47,64,0,15,0,44,0,0,15,0,44,0,0,15,0,44,0,0,15,0,44,0,0,15,0,44,1,192,15,6,108,1,208,15,255,172,2,192,255,249,31,171,192,164,0,11,255,64,
  // 0x6c92  沒
  146,108,17,19,95,19,1,254,0,0,160,0,0,62,0,240,0,0,11,192,255,255,0,1,65,234,175,0,0,3,192,15,0,0,7,128,15,0,244,15,0,30,0,127,46,3,253,0,10,24,1,164,0,0,10,170,169,0,0,15,255,255,0,2,130,192,45,0,3,192,240,124,0,11,64,185,240,0,15,0,47,208,0,45,0,127,224,0,124,27,249,254,64,116,63,128,47,192,0,20,0,1,64,
  // 0x6d88  消
  136,109,17,19,95,19,1,254,0,0,6,0,0,61,9,11,3,64,31,143,11,11,64,3,71,139,15,0,0,3,203,29,0,0,0,11,0,0,160,15,255,255,0,189,15,170,175,0,15,15,0,11,0,0,15,85,95,0,0,15,255,255,0,2,79,0,11,0,3,143,0,11,0,11,15,255,255,0,15,15,170,175,0,45,15,0,11,0,60,15,0,11,0,116,15,0,255,0,16,10,0,168,0,
  // 0x6de1  淡
  225,109,17,18,90,19,1,255,0,0,5,0,0,56,0,15,0,0,47,71,79,15,0,3,143,14,30,0,0,29,30,60,0,0,4,47,144,0,160,0,126,244,0,189,6,240,127,0,30,47,137,11,64,0,4,15,1,0,0,7,14,11,64,3,79,15,15,0,11,94,31,45,0,15,44,63,168,0,45,0,122,224,0,124,2,240,248,0,180,127,128,47,192,16,57,0,6,128,
  // 0x6e05  清
  5,110,17,19,95,19,1,254,0,0,9,0,0,60,5,95,85,0,47,95,255,255,128,3,128,15,0,0,0,15,255,255,0,0,0,15,0,0,248,63,255,255,192,127,21,85,85,64,10,1,85,85,0,0,7,255,255,0,0,7,64,15,0,3,135,255,255,0,7,135,64,15,0,11,7,64,15,0,15,7,255,255,0,61,7,64,15,0,124,7,64,15,0,112,7,64,254,0,0,2,0,84,0,
  // 0x6e2c  測
  44,110,17,19,95,19,1,254,16,0,0,2,64,61,63,244,3,128,31,122,180,195,128,1,52,53,211,128,0,52,53,211,128,0,63,245,211,128,244,57,117,211,128,126,52,53,211,128,8,57,117,211,128,0,63,245,211,128,0,52,53,211,128,5,52,53,211,128,15,58,181,211,128,30,63,245,195,128,44,20,32,3,128,60,60,116,3,128,116,180,44,3,128,178,224,12,191,64,0,128,0,105,0,
  // 0x6e90  源
  144,110,17,19,95,19,1,254,20,0,0,0,0,62,26,170,170,128,11,175,255,255,192,2,44,3,192,0,0,44,3,192,0,0,44,255,255,64,240,44,229,91,64,189,44,224,7,64,13,44,255,255,64,0,44,224,7,64,0,60,229,87,64,5,60,255,255,64,11,56,3,192,0,14,116,179,207,0,45,176,227,203,64,60,243,195,195,192,117,231,131,194,192,178,193,47,192,0,0,0,25,0,0,
  // 0x6e96  準
  150,110,17,19,95,19,1,254,4,2,65,64,0,47,71,195,192,0,7,143,155,149,0,0,47,255,255,0,248,190,11,0,0,45,255,255,254,0,0,15,91,84,0,2,143,91,84,0,7,143,255,254,0,15,14,11,0,0,60,15,91,85,64,116,15,255,255,128,16,1,208,0,0,170,171,234,170,128,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,128,0,0,
  // 0x6eab  溫
  171,110,18,19,95,19,1,254,20,0,0,0,0,63,15,255,253,0,11,143,89,109,0,1,15,13,29,0,0,15,29,29,0,0,15,59,93,0,244,15,225,221,0,190,15,85,109,0,13,15,255,253,0,0,0,0,0,0,0,5,85,85,0,2,31,255,255,0,11,92,114,203,0,15,28,114,203,0,30,28,114,203,0,60,28,114,203,0,120,190,187,239,128,112,255,255,255,208,0,0,0,0,0,
  // 0x6fc0  激
  192,111,18,19,95,19,1,254,16,2,64,144,0,61,7,64,224,0,15,191,249,208,0,1,117,121,208,0,0,112,58,255,208,0,127,251,235,192,244,116,63,199,0,125,117,127,199,0,8,127,255,203,0,0,3,69,223,0,0,255,252,238,0,9,110,84,189,0,15,13,0,60,0,30,15,244,60,0,44,30,180,188,0,60,60,52,255,0,116,180,119,199,128,177,227,255,66,192,0,129,64,0,0,
  // 0x7121  無
  33,113,17,19,95,19,1,254,1,64,0,0,0,3,192,0,0,0,11,234,170,170,0,47,255,255,255,0,191,13,44,116,0,251,13,44,116,0,7,13,44,116,0,255,255,255,255,192,171,175,190,190,128,7,13,44,116,0,7,13,44,116,0,7,13,44,116,0,191,255,255,255,128,106,170,170,170,64,9,4,4,24,0,30,28,45,30,0,60,29,14,15,64,180,14,15,3,192,32,4,5,1,64,
  // 0x71b1  熱
  177,113,18,19,95,19,1,254,1,128,2,0,0,2,208,7,64,0,63,255,7,64,0,1,192,63,253,0,255,255,91,173,0,30,117,7,29,0,29,50,107,29,0,248,63,191,29,0,65,192,15,157,0,127,255,15,253,128,22,213,44,93,144,2,214,120,29,208,255,255,240,15,192,169,64,144,1,0,4,0,0,8,0,30,44,44,46,0,60,29,30,15,0,180,29,15,7,192,16,4,0,1,0,
  // 0x71c8  燈
  200,113,18,19,95,19,1,254,5,0,2,64,0,11,7,254,221,0,11,1,120,244,0,11,38,52,179,128,107,123,240,63,64,171,178,229,125,0,171,211,255,255,64,235,95,0,3,208,219,57,85,85,128,139,3,255,254,0,11,3,192,14,0,15,3,213,94,0,15,67,255,254,0,15,192,144,52,0,45,240,176,116,0,60,112,112,176,0,180,21,185,181,64,224,31,255,255,192,64,0,0,0,0,
  // 0x7247  片
  71,114,16,19,76,19,1,254,0,0,40,0,11,0,60,0,11,0,60,0,11,0,60,0,11,0,60,0,11,255,255,255,11,255,255,255,11,0,0,0,11,0,0,0,11,0,0,0,15,255,255,208,15,255,255,208,15,0,1,208,30,0,1,208,45,0,1,208,60,0,1,208,248,0,1,208,240,0,1,208,16,0,1,144,
  // 0x7269  物
  105,114,18,19,95,19,0,254,0,160,9,0,0,4,240,29,0,0,28,240,44,0,0,28,240,62,170,160,46,249,127,255,240,63,254,242,206,176,52,241,211,141,176,112,243,199,92,240,32,241,79,44,240,0,251,13,56,240,6,255,44,116,224,63,240,120,176,224,56,240,240,224,224,0,241,194,192,208,0,240,3,129,208,0,240,15,2,192,0,240,62,3,192,0,240,120,127,128,0,160,16,42,0,
  // 0x7387  率
  135,115,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,42,171,234,170,0,127,255,255,255,64,0,3,128,4,0,60,15,24,31,0,31,124,60,124,0,7,47,240,96,0,0,7,220,64,0,2,199,15,248,0,111,239,255,111,64,184,122,151,135,128,0,1,208,0,0,170,171,250,170,128,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,208,0,0,0,1,144,0,0,
  // 0x7528  用
  40,117,16,17,68,19,1,254,15,255,255,255,15,171,250,175,14,0,224,15,14,0,224,15,15,170,250,175,15,255,255,255,14,0,224,15,14,0,224,15,14,0,224,15,15,255,255,255,31,171,250,175,44,0,224,15,60,0,224,15,56,0,224,15,180,0,224,15,240,0,227,254,64,0,145,164,
  // 0x754c  界
  76,117,17,18,90,19,1,254,15,255,255,252,0,15,86,229,124,0,14,1,208,44,0,15,86,229,124,0,15,255,255,252,0,14,1,208,44,0,15,86,229,124,0,15,255,255,252,0,0,124,15,64,0,1,244,3,224,0,11,208,2,253,0,255,120,7,175,192,116,56,7,66,64,0,116,7,64,0,0,240,7,64,0,7,224,7,64,0,31,128,7,64,0,9,0,2,64,0,
  // 0x767d  白
  125,118,15,19,76,19,2,254,0,10,0,0,0,15,0,0,0,30,0,0,127,255,255,244,127,255,255,244,116,0,0,116,116,0,0,116,116,0,0,116,116,0,0,116,126,170,170,244,127,255,255,244,116,0,0,116,116,0,0,116,116,0,0,116,116,0,0,116,127,255,255,244,127,255,255,244,116,0,0,116,32,0,0,16,
  // 0x7684  的
  132,118,17,19,95,19,1,254,1,128,9,0,0,3,192,14,0,0,3,128,29,0,0,43,168,62,170,64,127,253,63,255,128,112,13,180,3,128,112,14,240,3,128,112,15,208,3,128,112,13,76,3,64,127,253,30,3,64,122,173,11,67,64,112,13,3,199,64,112,13,1,215,64,112,13,0,71,0,112,13,0,11,0,127,253,0,11,0,122,168,0,15,0,112,0,11,253,0,0,0,2,164,0,
  // 0x76e3  監
  227,118,17,18,90,19,1,255,0,0,1,0,0,127,255,139,0,0,117,229,15,0,0,116,224,15,85,64,127,255,47,255,192,112,7,124,0,0,116,7,180,0,0,127,255,16,0,0,112,224,15,255,64,127,255,138,170,0,21,85,64,0,0,5,85,85,84,0,15,255,255,252,0,14,13,28,44,0,14,13,28,44,0,14,13,28,44,0,175,174,190,190,128,255,255,255,255,192,
  // 0x76f4  直
  244,118,17,19,95,19,1,254,0,0,160,0,0,0,0,240,0,0,255,255,255,255,192,106,171,250,170,128,0,2,208,0,0,20,63,255,252,0,60,57,85,124,0,60,56,0,60,0,60,63,255,252,0,60,52,0,60,0,60,56,0,60,0,60,63,255,252,0,60,52,0,60,0,60,63,255,252,0,60,21,85,80,0,60,0,0,0,0,63,255,255,255,192,62,170,170,170,128,40,0,0,0,0,
  // 0x7720  眠
  32,119,18,18,90,19,1,254,106,161,170,170,64,191,242,255,255,128,176,178,192,3,128,176,178,192,3,128,185,242,234,171,128,191,242,255,255,128,176,178,193,208,0,176,178,192,208,0,185,242,234,250,128,191,242,255,255,192,176,178,192,224,0,176,178,192,240,0,176,178,192,176,0,191,242,192,116,128,186,162,193,120,224,176,7,255,172,208,0,15,249,15,192,0,4,0,2,64,
  // 0x780d  砍
  13,120,18,19,95,19,0,254,0,0,9,0,0,42,170,29,0,0,63,255,109,0,0,3,128,60,0,0,3,128,63,255,240,7,64,62,250,240,7,0,180,208,224,11,169,240,209,208,15,255,224,226,192,31,14,65,225,128,63,14,1,224,0,127,14,3,240,0,43,14,3,180,0,11,14,11,60,0,11,254,30,30,0,11,169,124,11,128,11,1,244,3,224,5,3,208,0,240,0,0,0,0,16,
  // 0x78ba  確
  186,120,18,19,95,19,0,254,0,0,0,144,0,42,169,0,224,0,63,255,86,229,80,3,129,255,255,240,7,65,199,68,112,7,65,207,29,112,11,0,46,126,80,15,168,191,255,224,15,255,248,56,0,31,14,184,56,0,63,13,63,255,208,127,13,61,121,64,59,13,56,56,0,11,13,63,255,208,11,173,61,121,64,11,253,56,56,0,11,0,61,125,80,6,0,63,255,240,0,0,40,0,0,
  // 0x79fb  移
  251,121,18,19,95,19,0,254,0,4,0,144,0,1,190,3,192,0,63,244,11,255,192,21,224,62,91,192,0,225,253,11,0,0,224,219,158,0,63,255,1,248,0,43,250,7,224,0,2,224,191,244,0,3,248,165,245,80,11,254,7,255,240,13,235,47,1,208,60,225,255,131,192,116,224,147,239,64,32,224,0,190,0,0,224,1,248,0,0,224,111,208,0,0,225,254,0,0,0,144,128,0,0,
  // 0x7a4d  積
  77,122,18,19,95,19,0,254,0,0,0,208,0,5,189,255,255,224,63,244,1,224,0,21,208,191,255,208,1,208,1,224,0,1,208,1,224,0,63,255,255,255,240,43,253,0,0,0,3,208,127,255,192,3,244,116,2,192,11,253,127,255,192,14,222,112,1,192,45,208,127,255,192,117,208,116,2,192,49,208,127,255,192,1,208,30,9,0,1,208,126,15,128,1,211,240,2,240,0,145,64,0,64,
  // 0x7aef  端
  239,122,17,19,95,19,1,254,5,0,2,64,0,11,2,67,66,64,11,3,131,67,128,11,3,131,67,128,175,163,235,235,128,255,243,255,255,128,0,64,0,0,0,176,230,170,170,128,112,223,255,255,192,113,192,11,64,0,49,192,11,0,0,54,199,255,255,192,54,135,174,251,192,3,235,92,179,192,191,251,92,179,192,249,7,92,179,192,0,7,92,179,192,0,7,92,191,128,0,1,0,1,0,
  // 0x7b49  等
  73,123,17,19,95,19,1,254,5,0,9,0,0,15,0,45,0,0,47,255,127,255,192,126,230,250,229,64,240,225,224,240,0,64,65,208,64,0,15,255,255,253,0,5,86,229,84,0,0,1,208,0,0,255,255,255,255,192,170,170,171,234,128,0,0,2,192,0,42,170,171,234,64,127,255,255,255,128,1,208,2,192,0,0,248,2,192,0,0,61,2,192,0,0,8,127,192,0,0,0,42,0,0,
  // 0x7ba1  管
  161,123,17,19,95,19,1,254,5,0,8,0,0,15,0,45,0,0,47,255,127,255,192,123,230,246,245,64,240,226,208,240,0,0,65,208,0,0,127,255,255,255,128,121,85,85,87,128,112,85,85,67,128,18,255,255,225,0,2,192,0,224,0,2,255,255,224,0,2,213,85,64,0,2,213,85,84,0,2,255,255,252,0,2,192,0,44,0,2,213,85,124,0,2,255,255,252,0,1,128,0,24,0,
  // 0x7bb1  箱
  177,123,17,19,95,19,1,254,6,0,9,0,0,15,0,45,0,0,31,255,127,255,192,62,229,251,229,64,244,225,240,224,0,224,225,208,176,0,2,192,0,0,0,2,192,191,255,64,255,255,186,175,64,107,234,176,7,64,7,208,191,255,64,15,244,181,91,64,31,253,176,7,64,62,207,191,255,64,242,192,181,91,64,226,192,176,7,64,2,192,185,91,64,2,192,191,255,64,1,128,96,6,0,
  // 0x7cfb  系
  251,124,17,18,90,19,1,254,0,21,107,252,0,63,255,255,232,0,42,111,64,0,0,0,61,7,128,0,9,244,15,64,0,15,208,61,0,0,3,241,244,0,0,0,255,193,208,0,0,47,0,248,0,0,126,90,190,0,255,255,255,255,128,190,171,208,3,192,1,129,208,128,0,7,209,210,244,0,31,65,208,125,0,189,1,208,31,64,180,1,208,7,64,0,1,144,0,0,
  // 0x7d05  紅
  5,125,17,19,95,19,1,254,2,64,0,0,0,11,64,0,0,0,14,20,170,170,128,188,61,255,255,192,248,176,2,192,0,62,224,2,192,0,15,192,2,192,0,11,28,2,192,0,30,15,2,192,0,255,255,66,192,0,171,231,194,192,0,2,193,2,192,0,54,205,2,192,0,118,207,2,192,0,178,203,2,192,0,226,195,66,192,0,210,195,171,234,128,2,195,255,255,192,2,128,0,0,0,
  // 0x7d22  索
  34,125,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,127,255,255,255,64,106,171,234,170,0,0,1,208,0,0,191,255,255,255,128,186,175,170,171,128,176,31,1,3,128,178,188,15,67,128,7,240,125,0,0,0,249,241,128,0,0,47,130,240,0,85,127,85,253,0,191,255,255,255,64,0,129,208,66,0,3,225,210,224,0,47,65,208,126,0,248,1,208,11,128,16,1,128,1,0,
  // 0x7d2b  紫
  43,125,17,19,95,19,1,254,0,160,0,0,0,16,224,60,9,0,56,255,125,255,0,56,245,63,224,0,56,224,60,0,0,56,224,60,2,192,126,255,174,171,192,255,171,31,255,64,64,31,1,0,0,7,188,31,64,0,7,244,188,0,0,0,127,224,240,0,85,111,149,189,0,255,255,255,255,64,0,1,208,3,128,2,209,210,224,0,31,129,208,189,0,189,1,208,15,128,16,1,128,1,0,
  // 0x7d30  細
  48,125,18,19,95,19,0,254,1,64,0,0,0,3,192,0,0,0,7,64,127,255,224,27,44,122,250,224,61,56,112,176,224,46,176,112,176,224,11,208,112,176,224,3,157,112,176,224,11,95,112,176,224,127,255,191,255,224,42,211,250,250,224,0,208,112,176,224,28,221,112,176,224,44,219,112,176,224,56,215,176,176,224,52,210,186,250,224,32,208,127,255,224,0,208,112,0,224,0,144,0,0,0,
  // 0x7d42  終
  66,125,18,19,95,19,0,254,1,64,2,0,0,3,192,11,64,0,3,64,15,170,64,11,44,47,255,192,61,56,125,11,64,45,177,255,15,0,11,210,199,188,0,3,168,2,244,0,11,28,3,248,0,127,254,47,111,64,38,235,252,7,240,1,212,147,128,176,29,220,1,248,0,45,222,0,44,0,57,203,20,0,0,53,193,63,128,0,113,192,6,253,0,1,192,0,47,128,0,128,0,2,0,
  // 0x7d71  統
  113,125,19,19,95,19,0,254,1,0,0,144,0,3,192,1,224,0,3,64,1,224,0,11,45,255,255,240,61,56,175,234,160,45,176,15,6,0,11,208,14,11,64,3,168,45,91,192,11,29,255,255,224,127,254,165,64,176,38,235,9,24,0,1,212,14,44,0,29,220,13,44,0,45,222,29,44,0,57,203,44,44,0,53,198,60,44,52,113,192,240,44,52,1,195,208,31,240,0,130,0,6,144,
  // 0x7d72  絲
  114,125,18,19,95,19,0,254,0,128,0,80,0,2,208,0,240,0,3,192,2,208,0,27,14,3,135,64,62,44,47,15,0,30,120,15,45,0,7,240,3,248,0,3,202,1,243,128,7,71,3,194,192,127,255,175,255,224,42,250,234,190,240,0,176,64,116,16,13,183,14,118,64,28,179,142,119,192,44,178,221,117,224,56,177,124,116,240,52,176,52,116,112,0,176,0,116,0,0,96,0,96,0,
  // 0x7da0  綠
  160,125,18,19,95,19,0,254,1,64,9,0,0,3,192,29,0,0,3,64,31,255,128,11,44,45,91,64,61,56,61,91,0,45,176,127,255,0,15,208,32,15,0,3,168,170,175,160,11,29,255,255,240,127,254,0,240,0,38,235,112,240,224,1,196,124,251,192,45,220,28,255,0,45,205,4,254,0,57,206,30,235,64,53,198,248,227,224,49,195,224,224,240,1,192,79,208,16,1,128,5,64,0,
  // 0x7db2  網
  178,125,18,18,90,19,0,254,2,192,170,170,144,3,64,255,255,224,11,45,208,4,224,61,56,218,28,224,45,176,215,44,224,15,192,215,120,224,7,168,223,253,224,11,29,208,208,224,127,255,213,228,224,38,235,223,254,224,1,197,215,0,224,45,221,215,0,224,41,206,215,0,224,57,203,211,253,224,117,193,208,84,224,49,192,208,0,224,1,192,208,15,224,0,64,128,5,64,
  // 0x7dd2  緒
  210,125,18,19,95,19,0,254,1,64,2,64,0,3,192,3,128,224,7,84,91,149,208,46,60,255,255,192,60,116,3,139,64,30,224,3,158,0,11,210,255,255,240,3,109,170,250,160,15,29,3,208,0,127,254,31,213,64,38,235,191,255,192,1,199,252,2,192,45,221,108,2,192,45,205,47,255,192,57,206,45,87,192,53,197,44,2,192,113,192,45,87,192,1,192,47,255,192,1,128,40,1,128,
  // 0x7dda  線
  218,125,19,19,95,19,0,254,1,64,0,144,0,3,192,1,224,0,3,64,22,229,64,11,44,191,255,208,61,56,176,1,208,45,176,191,255,208,15,208,181,85,208,3,168,176,1,208,11,28,191,255,208,127,254,85,245,64,38,235,0,240,144,1,197,254,246,240,45,221,110,255,128,45,205,44,254,0,57,202,56,235,0,53,197,240,227,208,49,195,208,224,244,1,193,79,224,16,1,128,6,64,0,
  // 0x7de8  編
  232,125,18,19,95,19,0,254,1,64,0,0,0,3,193,170,170,144,3,66,255,255,240,11,60,0,0,0,61,116,255,255,208,45,240,245,86,208,11,208,224,1,208,3,180,245,86,208,11,44,255,255,208,127,253,224,0,0,38,222,255,255,240,2,196,250,221,240,46,236,249,204,176,42,205,249,221,176,58,207,255,255,240,50,203,233,204,176,50,199,105,204,176,2,199,41,206,224,1,128,20,0,64,
  // 0x7e2e  縮
  46,126,18,19,95,19,0,254,1,64,0,208,0,3,192,1,224,0,7,66,255,255,240,27,62,213,85,240,61,118,192,0,176,45,241,168,0,80,11,192,59,255,240,3,168,53,110,80,11,28,176,44,0,127,254,242,255,224,38,223,242,213,224,2,195,242,192,224,46,236,114,213,224,42,220,114,255,224,58,205,114,192,224,54,200,114,192,224,114,192,114,213,224,2,192,114,255,224,1,128,98,128,144,
  // 0x7e3d  總
  61,126,18,19,95,19,0,254,1,64,0,160,0,3,192,1,224,0,3,64,255,255,208,11,60,229,213,208,61,116,213,253,208,45,240,239,140,208,11,208,238,248,208,3,180,212,188,208,11,44,210,200,208,127,253,231,85,208,38,222,255,255,208,2,196,3,128,0,46,236,1,240,0,42,204,91,50,128,58,205,235,1,208,54,197,219,4,240,114,194,203,10,112,2,194,75,253,32,1,128,1,84,0,
  // 0x7e7c  繼
  124,126,18,19,95,19,0,254,1,2,64,0,0,7,67,141,7,0,11,3,173,156,144,30,115,187,109,192,60,243,142,11,64,46,211,141,205,144,15,131,191,255,240,7,179,149,85,96,14,55,255,255,240,127,255,137,3,0,39,239,140,74,64,3,131,185,236,208,43,183,175,30,128,59,187,142,71,128,55,175,157,205,160,51,159,191,255,240,51,131,149,85,96,3,131,255,255,240,3,130,64,0,0,
  // 0x7e8c  續
  140,126,17,19,95,19,1,254,5,0,3,64,0,15,11,255,255,192,29,0,7,128,0,44,243,255,255,64,245,208,0,0,0,183,131,255,255,128,47,67,28,211,128,14,211,180,107,128,44,179,255,255,128,255,244,0,0,0,155,118,255,255,0,7,18,213,91,0,183,178,234,175,0,167,114,255,255,0,231,54,192,11,0,215,2,255,255,0,199,0,180,125,0,7,15,208,31,128,6,5,0,1,64,
  // 0x7ea2  红
  162,126,17,18,90,19,1,255,1,0,0,0,0,3,192,0,0,0,11,130,255,255,128,15,3,255,255,128,45,16,3,192,0,60,60,3,192,0,250,244,3,192,0,255,224,3,192,0,71,192,3,192,0,15,0,3,192,0,61,84,3,192,0,255,248,3,192,0,254,64,3,192,0,0,0,3,192,0,0,100,3,192,0,111,248,3,192,0,255,151,255,255,192,144,3,255,255,192,
  // 0x7f6e  置
  110,127,17,18,90,19,1,254,63,255,255,255,0,60,45,30,15,0,60,44,13,15,0,63,255,255,255,0,0,1,224,0,0,191,255,255,255,128,21,86,213,85,0,0,2,192,0,0,44,63,255,252,0,44,57,85,108,0,44,58,170,188,0,44,63,255,252,0,44,52,0,28,0,44,63,255,252,0,44,0,0,0,0,45,85,85,85,64,47,255,255,255,192,24,0,0,0,0,
  // 0x7f72  署
  114,127,17,18,90,19,1,254,63,255,255,255,0,61,109,94,95,0,60,44,13,15,0,63,255,255,255,0,5,87,213,84,0,5,87,213,78,0,15,255,255,253,0,0,3,194,240,0,255,255,255,255,192,85,91,253,85,64,0,127,224,0,0,31,255,255,252,0,255,229,85,108,0,80,255,255,252,0,0,224,0,44,0,0,229,85,108,0,0,255,255,252,0,0,144,0,24,0,
  // 0x8070  聰
  112,128,17,19,95,19,1,254,0,0,2,128,0,255,253,3,128,0,190,186,255,255,128,56,53,214,151,128,56,53,195,67,128,61,181,203,247,128,63,245,223,115,128,56,53,210,227,128,56,53,199,115,128,61,181,221,87,128,63,245,255,255,128,56,52,11,128,0,56,52,2,224,0,56,116,92,85,0,191,245,220,7,0,249,118,220,7,128,0,59,92,46,192,0,58,15,248,128,0,32,1,80,0,
  // 0x81ea  自
  234,129,13,19,76,19,3,254,0,24,0,0,0,60,0,0,0,60,0,0,255,255,255,192,250,170,171,192,240,0,2,192,240,0,2,192,250,170,171,192,255,255,255,192,240,0,2,192,240,0,2,192,250,170,171,192,255,255,255,192,240,0,2,192,240,0,2,192,240,0,2,192,255,255,255,192,250,170,171,192,160,0,1,128,
  // 0x85cd  藍
  205,133,17,18,90,19,1,255,0,96,2,64,0,85,249,91,149,64,255,255,255,255,192,0,176,7,64,0,63,255,199,0,0,56,176,15,0,0,52,176,31,255,128,63,255,125,85,64,52,3,176,0,0,63,255,69,85,0,52,176,15,255,0,63,255,192,0,0,5,85,85,84,0,15,255,255,252,0,14,13,28,44,0,14,13,28,44,0,95,110,110,126,64,255,255,255,255,192,
  // 0x884c  行
  76,136,18,19,95,19,0,254,0,32,0,0,0,0,240,106,170,144,3,208,191,255,224,31,64,0,0,0,61,0,0,0,0,36,60,0,0,0,0,184,0,0,0,1,241,255,255,240,7,209,170,191,160,31,208,0,29,0,127,208,0,29,0,53,208,0,29,0,1,208,0,29,0,1,208,0,29,0,1,208,0,29,0,1,208,0,29,0,1,208,0,29,0,1,208,11,252,0,1,208,2,164,0,
  // 0x8868  表
  104,136,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,63,255,255,255,0,42,170,234,170,0,0,1,208,0,0,15,255,255,253,0,5,86,229,84,0,0,1,208,0,0,255,255,255,255,128,106,175,250,170,64,0,126,56,10,0,2,244,44,47,0,127,240,31,248,0,249,240,11,192,0,0,240,3,208,0,0,241,181,244,0,1,255,244,127,64,31,249,0,15,192,9,0,0,1,64,
  // 0x88ab  被
  171,136,18,19,95,19,0,254,1,128,0,96,0,2,192,0,176,0,2,192,0,176,0,2,192,106,250,160,63,253,191,255,240,42,188,176,176,224,0,56,176,176,208,0,240,176,176,64,2,235,191,255,208,7,252,191,171,192,31,252,255,3,192,127,221,231,71,64,50,200,227,207,0,2,192,209,253,0,2,193,208,252,0,2,195,194,254,0,2,199,159,223,208,2,203,62,3,240,1,129,20,0,80,
  // 0x88c5  装
  197,136,17,19,95,19,1,254,0,224,3,64,0,112,224,3,128,0,124,224,3,128,0,12,235,255,255,192,0,230,171,234,128,1,224,3,128,0,47,224,3,128,0,253,226,171,234,0,144,227,255,255,64,0,224,64,0,0,0,1,208,0,0,255,255,255,255,192,85,127,185,89,64,1,248,60,46,0,191,240,31,244,0,164,240,7,208,0,0,251,241,249,0,15,255,144,47,192,5,0,0,1,64,
  // 0x88dd  裝
  221,136,17,19,95,19,1,254,16,36,2,128,0,52,52,3,192,0,52,52,3,192,0,63,247,255,255,192,37,181,171,234,64,255,244,3,192,0,125,180,3,192,0,60,52,87,213,0,116,53,255,255,64,240,52,128,0,0,64,1,208,0,0,255,255,255,255,192,85,127,185,89,64,2,248,60,46,0,191,240,31,244,0,164,240,7,208,0,1,251,241,249,0,15,254,144,47,192,4,0,0,1,64,
  // 0x8907  複
  7,137,17,19,95,19,1,254,6,0,96,0,0,15,0,240,0,0,15,1,255,255,192,15,3,213,85,64,255,255,64,0,0,170,255,255,255,0,1,209,208,11,0,3,192,255,255,0,7,104,208,11,0,15,116,208,15,0,63,224,255,255,0,191,240,46,84,0,235,32,255,255,0,75,11,244,60,0,11,15,61,244,0,11,0,15,224,0,11,1,191,253,0,11,15,244,47,192,6,5,0,1,64,
  // 0x89d2  角
  210,137,16,19,76,19,1,254,0,36,0,0,0,125,85,0,0,255,255,0,3,208,30,0,11,128,60,0,47,255,255,254,191,170,250,174,39,64,240,14,7,64,240,14,7,255,255,254,7,170,250,174,7,0,240,14,11,0,240,14,11,255,255,254,15,170,170,174,45,0,0,14,124,0,0,14,240,0,15,253,64,0,6,164,
  // 0x8a08  計
  8,138,18,19,95,19,1,254,0,0,1,128,0,63,248,1,208,0,21,80,1,208,0,85,84,1,208,0,255,253,1,208,0,0,0,1,208,0,21,80,1,208,0,127,250,255,255,208,0,2,171,250,144,127,248,1,208,0,21,80,1,208,0,21,80,1,208,0,127,248,1,208,0,112,56,1,208,0,112,56,1,208,0,112,56,1,208,0,127,248,1,208,0,121,80,1,208,0,16,0,1,128,0,
  // 0x8a0a  訊
  10,138,18,19,95,19,1,253,127,242,170,168,0,21,83,255,253,0,85,84,60,29,0,255,252,60,29,0,0,0,60,29,0,21,80,60,29,0,127,240,60,29,0,0,3,255,221,0,127,246,190,157,0,21,80,56,29,0,21,80,56,29,0,127,240,116,29,0,112,112,176,13,0,112,112,240,14,64,112,114,208,14,96,127,251,192,15,160,121,91,0,7,208,16,1,0,2,128,0,0,0,0,0,
  // 0x8a18  記
  24,138,17,18,90,19,1,254,63,248,170,170,0,21,84,255,255,64,85,84,0,7,64,255,253,0,7,64,0,0,0,7,64,21,80,0,7,64,127,248,0,7,64,0,0,191,255,64,127,248,186,175,64,21,80,176,7,0,21,80,176,0,0,127,248,176,0,0,112,56,176,0,0,112,56,176,1,192,112,56,176,1,192,127,248,176,3,192,121,80,127,255,128,16,0,26,170,0,
  // 0x8a2d  設
  45,138,17,18,90,19,1,254,127,244,191,244,0,21,80,186,180,0,85,84,176,52,0,255,252,240,52,128,0,0,224,53,192,21,82,192,63,192,127,247,64,26,0,0,0,0,0,0,127,247,255,255,0,21,81,186,175,0,21,80,176,29,0,127,244,60,60,0,112,52,46,244,0,112,52,15,224,0,112,52,31,240,0,127,245,253,190,64,121,87,224,31,192,16,1,0,1,0,
  // 0x8a66  試
  102,138,18,20,100,19,1,253,0,0,0,117,0,127,240,0,187,64,21,80,0,178,192,85,80,0,176,64,255,251,255,255,192,0,3,255,255,192,127,240,0,112,0,21,80,0,112,0,0,2,170,116,0,127,243,255,116,0,21,80,116,116,0,21,80,116,52,0,127,240,116,52,0,112,112,116,56,0,112,112,116,56,64,112,113,191,172,208,127,247,249,29,208,117,81,0,15,192,16,0,0,7,64,0,0,0,0,0,
  // 0x8a8d  認
  141,138,18,18,90,19,1,254,127,242,255,255,128,21,81,175,171,128,85,80,11,3,64,255,249,238,3,64,0,0,191,7,64,21,80,63,215,64,127,240,180,139,0,0,3,224,255,0,127,243,73,104,0,21,80,11,192,0,21,80,1,240,0,127,241,108,90,0,112,115,172,11,0,112,115,172,3,128,112,119,108,42,192,127,255,44,45,208,117,80,47,248,64,16,0,6,144,0,
  // 0x8aa4  誤
  164,138,18,18,90,19,1,254,127,224,15,255,64,21,81,79,91,64,85,83,206,7,64,255,247,206,7,64,0,3,207,91,64,21,83,207,255,64,127,227,192,0,0,0,3,255,255,0,127,227,234,175,0,21,82,128,15,0,21,80,0,15,0,127,235,255,255,208,112,166,170,170,128,112,160,56,60,0,112,160,244,31,0,127,227,224,11,128,117,95,64,3,192,16,1,0,0,0,
  // 0x8abf  調
  191,138,17,18,90,19,1,254,127,211,255,255,128,21,67,170,171,128,85,83,67,67,128,255,243,87,147,128,0,3,127,243,128,21,67,67,67,128,127,211,87,147,128,0,3,127,247,128,127,215,64,3,128,21,71,111,243,128,21,71,41,115,128,127,215,40,115,128,112,219,40,115,128,112,223,47,243,128,112,222,41,83,128,127,237,0,3,128,117,108,0,127,128,16,4,0,42,0,
  // 0x8acb  請
  203,138,17,19,95,19,1,254,0,0,2,64,0,127,240,87,213,0,21,82,255,255,192,85,84,3,192,0,255,252,255,255,64,0,0,3,192,0,21,87,255,255,192,127,241,85,85,64,0,0,21,85,0,127,240,255,255,0,21,80,240,11,0,21,80,255,255,0,127,240,240,11,0,112,112,240,11,0,112,112,255,255,0,112,112,240,11,0,127,240,240,11,0,121,80,240,191,0,16,0,80,20,0,
  // 0x8b70  議
  112,139,17,19,95,19,1,254,0,0,144,24,0,127,208,176,60,0,21,71,255,255,128,85,81,91,85,0,255,240,7,64,0,0,3,255,255,0,21,64,7,64,0,127,239,255,255,192,0,5,189,85,64,127,223,254,218,0,21,64,176,215,128,21,69,181,230,64,127,239,255,255,192,112,208,176,161,0,112,234,255,127,0,112,218,240,124,0,127,208,176,248,128,117,71,231,238,192,16,1,1,11,128,
  // 0x8b80  讀
  128,139,17,19,95,19,1,254,0,0,7,64,0,127,219,255,255,192,21,64,7,64,0,0,3,255,255,64,255,243,255,255,64,0,7,255,255,128,21,71,28,210,192,127,215,240,107,192,0,7,0,2,192,127,215,255,255,192,21,67,128,7,64,21,67,234,175,64,127,211,128,7,64,112,211,234,175,64,112,211,128,7,64,112,211,255,255,64,127,208,180,120,0,117,91,208,31,128,16,9,0,1,64,
  // 0x8b8a  變
  138,139,17,19,95,19,1,254,4,11,244,16,0,13,0,0,112,0,121,128,0,230,0,123,159,254,206,0,30,75,244,184,0,44,208,0,231,64,255,251,251,255,192,10,16,0,52,64,122,223,250,187,64,170,173,43,118,192,218,47,255,52,192,5,180,0,36,0,2,255,255,255,64,31,245,87,229,0,189,184,31,64,0,16,31,253,0,0,1,191,255,144,0,255,248,27,255,192,101,0,0,22,64,
  // 0x8cc7  資
  199,140,17,19,95,19,1,254,0,0,144,0,0,62,66,229,85,0,11,215,255,255,64,0,94,15,15,0,1,132,63,200,0,191,214,244,249,0,180,15,64,47,192,11,255,255,253,0,11,0,0,60,0,11,0,0,60,0,11,255,255,252,0,11,0,0,60,0,11,255,255,252,0,11,0,0,60,0,11,255,255,252,0,0,116,7,64,0,11,244,11,244,0,191,64,0,127,64,32,0,0,5,0,
  // 0x8ddd  距
  221,141,18,18,90,19,0,254,31,255,47,255,240,30,175,46,170,160,28,11,44,0,0,28,11,44,0,0,28,11,44,0,0,31,255,47,255,192,10,250,46,171,192,0,176,44,1,192,28,176,44,1,192,28,191,108,1,192,28,186,46,171,192,28,176,47,255,192,28,176,44,0,0,28,182,108,0,0,30,255,172,0,0,127,228,47,255,240,36,0,46,170,160,0,0,24,0,0,
  // 0x8eca  車
  202,142,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,127,255,255,255,64,106,171,250,170,64,0,1,208,0,0,15,255,255,252,0,15,86,229,124,0,14,1,208,44,0,15,255,255,252,0,15,86,229,124,0,14,1,208,44,0,15,86,229,124,0,15,255,255,252,0,0,1,208,0,0,170,171,234,170,128,255,255,255,255,192,0,1,208,0,0,0,1,208,0,0,0,1,144,0,0,
  // 0x8edf  軟
  223,142,17,19,95,19,1,254,1,64,9,0,0,2,192,29,0,0,107,234,45,0,0,255,255,44,0,0,2,192,63,255,192,191,255,63,235,192,182,219,177,195,128,178,203,241,195,64,191,255,209,199,0,178,203,2,209,0,178,203,2,208,0,191,255,3,224,0,23,213,7,176,0,171,234,15,56,0,255,255,109,60,0,2,192,124,31,0,2,193,240,11,192,2,195,192,3,192,1,128,0,0,64,
  // 0x8ef8  軸
  248,142,17,19,95,19,1,254,1,64,1,128,0,3,128,1,192,0,171,233,1,192,0,255,255,1,192,0,3,128,107,234,64,191,253,191,255,128,183,157,177,195,128,162,77,177,195,128,191,253,177,195,128,179,141,177,195,128,162,77,191,255,128,191,253,186,235,128,23,212,177,195,128,3,128,177,195,128,255,255,177,195,128,171,234,177,195,128,3,128,191,255,128,3,128,186,171,128,2,64,96,2,64,
  // 0x8f09  載
  9,143,17,19,95,19,1,254,0,160,9,0,0,0,240,15,60,0,63,255,207,31,0,21,245,79,7,64,85,245,95,86,64,255,255,255,255,192,0,240,11,0,0,127,255,219,10,0,21,245,75,79,0,63,255,199,94,0,52,161,199,189,0,63,255,195,252,0,52,161,195,244,0,63,255,195,224,0,0,224,3,208,192,21,245,79,225,192,191,255,254,246,192,0,224,244,127,128,0,160,80,10,0,
  // 0x8f2f  輯
  47,143,17,19,95,19,1,254,1,64,0,0,0,3,128,63,255,64,171,233,57,91,64,255,255,56,7,64,3,128,63,255,64,191,253,21,85,0,183,158,85,85,64,162,78,255,255,192,191,253,56,7,0,179,141,63,255,0,162,77,61,91,0,191,253,56,7,0,23,212,63,255,0,3,128,61,91,0,255,255,56,7,128,171,235,127,255,192,3,129,254,171,0,3,128,0,7,0,2,64,0,6,0,
  // 0x8f38  輸
  56,143,18,19,95,19,1,254,2,0,2,128,0,7,64,7,224,0,171,168,15,180,0,255,252,61,60,0,7,64,248,31,0,191,255,229,91,208,167,109,31,248,192,147,28,0,0,0,191,253,255,2,128,163,109,219,50,128,147,29,199,50,128,191,253,255,50,128,23,81,199,50,128,7,65,219,50,128,255,254,255,50,128,171,169,199,50,128,7,65,199,2,128,7,65,199,31,128,2,0,14,4,0,
  // 0x8f49  轉
  73,143,18,19,95,19,0,254,0,64,0,96,0,0,224,21,181,80,42,250,191,255,240,63,255,64,112,0,0,224,63,255,224,47,255,56,176,224,45,231,63,255,224,40,211,56,112,224,47,255,63,255,224,44,215,0,178,192,40,211,0,178,208,47,255,191,255,240,5,229,0,11,32,0,250,255,255,240,127,255,157,95,80,42,250,79,11,0,0,224,3,75,0,0,224,0,255,0,0,144,0,20,0,
  // 0x8fd1  近
  209,143,17,19,95,19,1,254,0,0,0,4,0,116,0,26,254,0,125,3,255,224,0,15,67,144,0,0,3,3,128,0,0,0,3,128,0,0,0,3,255,255,192,0,7,234,250,128,170,7,64,224,0,255,7,0,224,0,11,11,0,224,0,11,15,0,224,0,11,45,0,224,0,11,124,0,224,0,15,96,0,224,0,63,208,0,80,0,248,255,170,170,192,208,27,255,255,192,0,0,0,0,0,
  // 0x8fd4  返
  212,143,17,18,90,19,1,254,112,6,170,170,64,124,11,255,255,64,31,11,0,0,0,7,11,0,0,0,0,15,170,169,0,0,15,255,254,0,0,15,176,29,0,255,15,56,60,0,175,14,60,120,0,15,14,15,240,0,15,29,11,208,0,15,60,31,240,0,15,121,189,190,64,15,114,240,31,192,127,208,64,1,0,244,255,170,170,192,208,31,255,255,192,0,0,0,0,0,
  // 0x9000  退
  0,144,17,18,90,19,1,254,116,7,255,253,0,62,7,170,173,0,15,71,64,29,0,2,7,255,253,0,0,7,149,109,0,0,7,64,29,0,0,7,255,253,0,255,7,175,170,0,175,7,71,79,64,11,7,67,253,0,11,7,65,240,0,11,7,90,248,0,11,31,254,63,64,15,111,144,11,128,127,224,0,0,0,248,255,170,170,192,208,27,255,255,192,0,0,0,0,0,
  // 0x901f  速
  31,144,17,19,95,19,1,254,0,0,9,0,0,112,0,14,0,0,125,21,95,85,64,31,63,255,255,192,2,0,14,0,0,0,15,255,255,0,0,14,95,91,0,0,13,14,11,0,255,13,14,11,0,175,15,255,255,0,11,5,191,213,0,11,0,255,224,0,11,3,206,120,0,11,47,14,31,128,15,120,14,7,64,127,224,9,0,0,248,255,170,170,192,208,27,255,255,192,0,0,0,0,0,
  // 0x9023  連
  35,144,17,19,95,19,1,254,0,0,9,0,0,112,0,13,0,0,124,63,255,255,128,31,21,110,85,64,11,0,30,0,0,0,31,255,254,0,0,29,13,14,0,0,31,255,254,0,255,29,30,14,0,175,29,13,14,0,15,31,255,254,0,15,5,94,84,0,15,21,110,85,64,15,127,255,255,192,15,0,13,0,0,63,208,13,0,0,244,255,170,170,128,208,31,255,255,192,0,0,0,0,0,
  // 0x9032  進
  50,144,17,19,95,19,1,254,0,0,64,64,0,112,3,209,224,0,124,7,194,192,0,31,15,215,213,0,11,47,255,255,64,0,127,3,64,0,1,255,91,149,0,0,143,255,255,0,255,15,3,64,0,175,15,3,64,0,15,15,255,255,0,15,15,91,149,0,15,15,3,64,0,15,15,91,149,64,15,15,255,255,192,63,208,0,0,0,244,255,170,170,128,208,31,255,255,192,0,0,0,0,0,
  // 0x904b  運
  75,144,17,18,90,19,1,254,180,63,255,255,128,61,57,89,87,128,15,36,14,2,64,6,47,255,255,0,0,5,94,85,0,0,15,255,254,0,0,14,14,14,0,255,13,14,14,0,175,15,255,254,0,15,13,14,14,0,15,15,255,254,0,15,0,14,0,0,15,127,255,255,192,15,21,94,85,64,63,208,14,0,0,244,255,170,170,128,208,31,255,255,192,0,0,0,0,0,
  // 0x9054  達
  84,144,17,19,95,19,1,254,0,0,9,0,0,112,5,94,84,0,124,15,255,254,0,15,0,14,0,0,5,127,255,255,192,0,23,213,185,64,0,2,192,176,0,0,22,213,245,0,255,63,255,255,128,175,0,14,0,0,15,15,255,255,0,15,5,94,85,0,15,21,94,85,64,15,63,255,255,192,15,0,14,0,0,63,208,9,0,0,244,255,170,170,128,208,31,255,255,192,0,0,0,0,0,
  // 0x9078  選
  120,144,17,18,90,19,1,254,176,127,243,255,0,124,0,176,7,0,46,63,243,255,0,13,56,19,129,0,0,56,43,193,192,0,47,245,255,128,0,0,128,144,0,254,22,229,245,0,174,63,255,255,64,14,1,208,224,0,14,22,229,245,64,14,191,255,255,192,14,1,208,160,0,15,31,128,125,0,63,253,0,11,64,245,254,170,170,128,208,47,255,255,192,0,0,0,0,0,
  // 0x9084  還
  132,144,17,18,90,19,1,254,112,47,255,255,0,124,44,178,203,0,31,44,178,203,0,11,47,255,255,0,0,0,0,0,0,0,191,255,255,192,0,0,0,0,0,255,15,255,253,0,175,14,0,29,0,15,15,255,254,0,15,0,191,15,0,15,2,255,252,0,15,47,93,249,0,15,56,29,47,128,63,208,29,1,0,244,255,170,170,128,208,31,255,255,192,0,0,0,0,0,
  // 0x908a  邊
  138,144,17,19,95,19,1,254,0,0,9,0,0,61,11,255,253,0,31,79,0,29,0,3,15,170,189,0,16,15,255,253,0,248,15,0,29,0,63,11,255,253,0,9,21,110,85,64,0,57,247,155,192,169,37,195,255,192,255,30,14,4,0,15,63,255,255,192,15,0,176,0,0,15,1,255,252,0,15,27,128,56,0,63,253,7,240,0,245,255,170,170,128,208,47,255,255,192,0,0,0,0,0,
  // 0x90e8  部
  232,144,17,19,95,19,1,254,0,144,0,0,0,0,224,10,170,64,106,250,143,255,192,191,255,223,3,128,8,6,15,11,64,29,11,15,15,0,14,14,15,29,0,9,13,15,44,0,255,255,239,44,0,170,170,159,15,0,0,0,15,7,64,63,255,143,3,192,62,171,143,3,192,56,3,143,3,192,56,3,143,47,128,56,3,143,62,0,63,255,143,0,0,62,171,143,0,0,36,2,70,0,0,
  // 0x91cb  釋
  203,145,17,19,95,19,1,254,0,16,0,0,0,111,249,255,255,128,235,65,222,183,128,3,90,205,115,128,163,110,255,255,128,115,120,3,192,0,55,112,3,192,0,107,164,255,255,0,255,252,3,192,0,11,67,255,255,192,15,192,116,29,0,47,240,56,44,0,59,124,44,56,0,179,70,255,255,192,227,64,3,192,0,195,64,255,255,64,3,64,87,213,0,3,64,3,192,0,2,0,2,128,0,
  // 0x91cd  重
  205,145,17,18,90,19,1,255,0,0,0,80,0,5,170,255,252,0,15,255,233,64,0,0,1,208,0,0,255,255,255,255,192,85,86,229,85,64,15,255,255,252,0,15,2,208,60,0,15,2,208,44,0,15,255,255,252,0,15,1,208,44,0,15,255,255,252,0,0,2,208,0,0,5,86,229,85,0,47,255,255,255,0,0,1,208,0,0,85,86,229,85,64,255,255,255,255,192,
  // 0x91cf  量
  207,145,17,17,85,19,1,255,11,255,255,248,0,11,0,0,56,0,11,255,255,248,0,11,0,0,56,0,11,255,255,248,0,85,85,85,85,64,255,255,255,255,192,0,0,0,0,0,15,255,255,252,0,14,1,208,44,0,15,255,255,252,0,14,1,208,44,0,15,255,255,252,0,0,2,208,0,0,31,255,255,253,0,85,86,229,85,64,255,255,255,255,192,
  // 0x91dd  針
  221,145,19,19,95,19,0,254,0,160,0,36,0,1,253,0,56,0,3,223,64,56,0,11,131,208,56,0,31,0,192,56,0,126,85,0,56,0,47,255,0,56,0,0,176,63,255,244,0,176,42,254,160,63,255,192,56,0,26,250,128,56,0,4,177,64,56,0,28,179,128,56,0,13,179,64,56,0,14,183,0,56,0,0,182,128,56,0,43,255,192,56,0,63,164,0,56,0,0,0,0,36,0,
  // 0x9215  鈕
  21,146,18,19,95,19,1,254,2,64,0,0,0,15,224,170,170,0,30,184,255,255,0,60,45,14,15,0,240,12,14,14,0,255,248,14,14,0,27,144,14,14,0,3,64,29,14,0,107,169,191,175,128,255,254,255,255,208,3,64,44,14,0,99,92,44,14,0,115,104,44,29,0,55,116,60,29,0,55,96,60,29,0,3,173,56,29,0,191,255,190,191,128,249,71,255,255,208,0,0,0,0,0,
  // 0x932f  錯
  47,147,17,19,95,19,1,254,2,64,24,40,0,15,224,44,60,0,30,180,126,125,64,60,46,255,255,192,240,13,44,60,0,255,248,44,60,0,27,144,44,60,0,3,67,255,255,192,107,170,170,170,128,255,252,0,0,0,3,64,191,255,0,99,92,181,91,0,115,104,176,11,0,51,116,191,255,0,55,96,181,91,0,3,173,176,11,0,191,253,181,91,0,249,64,191,255,0,0,0,112,6,0,
  // 0x9375  鍵
  117,147,19,19,95,19,0,254,1,128,0,20,0,3,241,164,44,0,11,127,249,255,208,30,30,52,109,208,60,12,113,109,224,125,84,183,255,244,31,252,208,44,208,2,193,230,255,208,23,214,252,109,64,63,252,92,44,0,2,193,94,255,224,38,205,233,125,80,26,217,249,125,80,30,228,247,255,240,14,208,176,44,0,2,217,244,44,0,27,255,238,20,0,63,159,75,255,244,0,5,0,90,160,
  // 0x9577  長
  119,149,17,18,90,19,1,254,2,255,255,252,0,2,229,85,84,0,2,192,0,0,0,2,255,255,244,0,2,213,85,80,0,2,192,0,0,0,2,255,255,244,0,2,213,85,80,0,2,192,0,0,0,255,255,255,255,192,171,234,250,174,128,2,192,240,31,0,2,192,120,248,0,2,192,47,208,0,2,192,95,208,0,7,255,226,249,0,63,250,64,127,192,20,0,0,2,64,
  // 0x9589  閉
  137,149,17,18,90,19,1,254,127,254,63,255,64,121,94,61,91,64,116,14,60,7,64,127,254,63,255,64,121,94,61,91,64,121,94,61,91,64,127,254,63,255,64,116,0,36,7,64,116,0,56,7,64,116,255,255,199,64,116,86,249,71,64,116,3,248,7,64,116,15,120,7,64,116,125,56,7,64,117,244,56,7,64,116,129,180,7,64,116,2,241,255,0,36,0,0,233,0,
  // 0x958b  開
  139,149,17,18,90,19,1,254,127,254,63,255,64,121,94,61,91,64,120,14,60,7,64,127,254,63,255,64,116,14,60,7,64,121,94,61,91,64,127,254,63,255,64,116,0,0,7,64,116,255,255,199,64,116,110,109,71,64,116,13,28,7,64,116,110,110,71,64,117,255,255,215,64,116,28,28,7,64,116,60,28,7,64,116,116,28,7,64,116,240,28,255,0,36,64,4,105,0,
  // 0x9593  間
  147,149,17,18,90,19,1,254,127,254,63,255,64,121,94,61,91,64,116,14,60,7,64,127,254,63,255,64,121,94,61,91,64,121,94,61,91,64,127,254,63,255,64,116,0,0,7,64,116,21,85,7,64,116,63,255,7,64,116,56,11,7,64,116,57,91,7,64,116,63,255,7,64,116,56,11,7,64,116,57,91,7,64,116,63,255,7,64,116,52,0,255,0,36,0,0,169,0,
  // 0x95dc  關
  220,149,17,18,90,19,1,254,127,254,63,255,64,121,94,61,87,64,116,14,60,7,64,127,254,63,255,64,116,14,60,7,64,127,254,63,255,64,120,56,29,7,64,116,177,105,7,64,116,237,187,7,64,116,118,45,135,64,116,63,111,215,64,118,145,228,87,64,116,199,48,135,64,116,199,48,199,64,116,255,63,199,64,116,14,52,7,64,116,124,48,63,64,32,16,16,41,0,
  // 0x964d  降
  77,150,17,19,95,19,1,254,0,0,9,0,0,127,240,45,0,0,122,240,127,254,0,112,225,245,125,0,113,199,252,124,0,114,202,30,240,0,115,64,15,208,0,115,192,127,253,0,112,219,244,111,192,112,230,64,225,64,112,179,255,255,64,112,241,246,245,0,118,224,224,224,0,119,192,224,224,0,112,15,255,255,192,112,10,170,250,128,112,0,0,224,0,112,0,0,224,0,96,0,0,144,0,
  // 0x9664  除
  100,150,17,19,95,19,1,254,0,0,10,0,0,127,240,31,192,0,122,240,60,240,0,112,224,240,120,0,113,195,208,47,0,114,223,64,11,192,115,158,255,253,192,115,128,95,148,0,113,192,11,0,0,112,224,11,0,0,112,247,255,255,64,112,182,175,170,0,118,241,75,4,0,119,195,139,29,0,112,11,75,15,0,112,15,11,7,128,112,44,11,3,192,112,0,127,0,0,96,0,40,0,0,
  // 0x968e  階
  142,150,17,19,95,19,1,254,0,1,0,64,0,127,231,65,208,0,122,231,65,215,128,112,215,253,254,0,113,199,149,224,0,114,199,65,208,64,115,71,173,209,192,115,139,253,255,192,113,223,158,85,0,112,224,14,0,0,112,227,255,255,64,112,243,213,91,64,118,227,128,7,64,119,195,213,91,64,112,3,255,255,64,112,3,128,7,64,112,3,213,91,64,112,3,255,255,64,96,2,64,6,0,
  // 0x96d9  雙
  217,150,17,19,95,19,1,254,4,0,4,0,0,14,56,14,56,0,29,116,29,116,0,63,255,127,255,128,188,176,188,176,0,255,255,255,255,0,108,176,108,176,0,47,255,31,255,0,44,176,28,112,0,47,255,95,255,192,0,0,0,0,0,63,255,255,248,0,22,229,86,244,0,1,244,3,224,0,0,127,111,64,0,0,15,253,0,0,22,255,255,233,0,255,228,7,255,128,100,0,0,22,0,
  // 0x96e2  離
  226,150,17,19,95,19,1,254,1,128,2,4,0,1,192,7,79,0,255,255,203,29,0,85,101,78,44,0,33,115,31,255,192,119,227,63,190,128,114,247,189,44,0,123,39,253,44,0,117,7,255,255,192,127,255,14,190,64,1,192,13,44,0,255,255,141,44,0,247,151,143,255,192,227,99,142,190,64,231,39,141,44,0,239,255,141,44,0,224,7,143,255,192,224,47,79,170,128,144,4,9,0,0,
  // 0x96fb  電
  251,150,17,18,90,19,1,254,31,255,255,253,0,5,86,229,84,0,0,2,208,0,0,191,255,255,255,128,176,1,208,3,128,179,249,223,243,128,96,1,208,2,64,11,249,223,248,0,0,0,0,0,0,15,255,255,252,0,15,2,192,60,0,15,255,255,252,0,15,2,208,60,0,15,2,208,60,0,15,255,255,252,128,14,1,208,2,192,0,0,255,255,128,0,0,21,85,0,
  // 0x9752  青
  82,151,17,19,95,19,1,254,0,1,128,0,0,5,86,229,85,0,47,255,255,255,0,0,1,208,0,0,15,255,255,252,0,5,86,229,84,0,85,86,229,85,64,255,255,255,255,192,0,0,0,0,0,7,255,255,244,0,7,149,85,180,0,7,128,0,180,0,7,255,255,244,0,7,64,0,116,0,7,255,255,244,0,7,128,0,180,0,7,64,0,116,0,7,64,15,240,0,1,0,5,64,0,
  // 0x975e  非
  94,151,17,19,95,19,1,254,0,24,9,0,0,0,44,14,0,0,0,44,14,0,0,106,188,15,170,128,191,252,15,255,192,0,44,14,0,0,0,44,14,0,0,0,44,14,0,0,127,252,15,255,64,42,188,15,170,64,0,60,14,0,0,0,61,14,0,0,107,255,79,170,128,255,248,15,255,192,64,240,14,0,0,3,208,14,0,0,15,128,14,0,0,126,0,14,0,0,36,0,9,0,0,
  // 0x9762  面
  98,151,17,18,90,19,1,254,170,170,170,170,128,255,255,255,255,192,0,3,192,0,0,0,3,192,0,0,42,171,234,170,0,63,255,255,255,0,56,56,14,15,0,56,56,14,15,0,56,63,254,15,0,56,61,94,15,0,56,56,14,15,0,56,61,94,15,0,56,63,254,15,0,56,56,14,15,0,56,56,14,15,0,63,255,255,255,0,62,170,170,175,0,36,0,0,10,0,
  // 0x9805  項
  5,152,18,18,90,19,1,254,0,7,255,255,192,0,7,255,234,128,255,244,7,128,0,11,0,91,149,0,11,2,255,255,128,11,2,192,3,128,11,2,208,7,128,11,2,255,255,128,11,2,192,3,128,11,2,208,7,128,11,110,255,255,128,47,250,192,3,128,254,66,213,87,128,144,2,255,255,128,0,0,116,40,0,0,6,244,47,0,0,47,128,7,208,0,4,0,0,64,
  // 0x9810  預
  16,152,18,18,90,19,0,254,26,169,191,255,240,63,255,106,250,160,0,29,0,240,0,14,120,5,245,64,11,240,63,255,208,0,248,60,0,208,42,190,124,1,208,127,255,191,255,208,1,211,124,0,208,1,215,60,1,208,1,219,63,255,208,1,208,60,0,208,1,208,61,85,208,1,208,63,255,208,1,208,6,6,0,1,208,47,11,192,47,210,248,1,240,10,64,128,0,80,
  // 0x984d  額
  77,152,17,19,95,19,1,254,2,128,0,0,0,3,192,255,255,192,255,255,107,234,64,230,91,2,192,0,219,11,23,213,0,15,252,63,255,64,61,124,52,3,64,254,116,56,7,64,219,240,63,255,64,3,240,52,3,64,31,189,56,7,64,188,15,63,255,64,255,253,52,3,64,61,124,57,87,64,56,44,63,255,64,56,44,8,8,0,63,252,189,31,0,61,87,240,3,192,16,0,64,0,64,
  // 0x985e  類
  94,152,17,19,95,19,1,254,1,64,0,0,0,115,206,255,255,192,55,220,107,234,128,19,196,2,192,0,255,255,23,213,0,91,213,127,255,64,15,244,116,3,64,63,254,116,7,64,243,202,127,255,64,66,128,116,3,64,3,192,116,7,64,171,234,127,255,64,255,255,116,3,64,3,192,121,87,64,7,224,127,255,64,15,124,8,24,0,124,30,125,31,0,240,3,240,3,192,0,1,64,0,64,
  // 0x98a8  風
  168,152,18,18,90,19,1,254,10,170,170,168,0,15,255,255,252,0,14,0,1,44,0,14,90,255,108,0,14,255,228,44,0,14,1,192,44,0,14,22,213,44,0,14,191,255,108,0,13,177,195,108,0,13,177,195,108,0,29,182,215,108,0,28,191,255,92,0,44,1,198,28,0,60,1,199,93,64,121,175,255,205,144,242,254,166,222,208,224,0,0,219,192,0,0,0,3,128,
  // 0x98fd  飽
  253,152,19,19,95,19,0,254,0,160,5,0,0,1,252,11,0,0,3,223,15,0,0,15,71,159,255,224,62,114,126,170,224,125,181,180,0,224,15,255,255,244,224,14,7,5,180,224,15,255,0,52,224,14,11,0,52,224,14,7,47,244,208,15,255,46,161,208,14,85,44,15,192,14,28,44,10,64,14,14,44,0,16,14,191,44,0,52,63,251,157,0,176,57,2,159,255,240,0,0,6,170,64,
  // 0x9918  餘
  24,153,17,19,95,19,1,254,1,64,2,128,0,11,208,7,224,0,14,180,15,244,0,60,45,61,60,0,255,248,188,47,0,192,2,240,11,192,63,254,165,91,192,56,44,63,253,0,52,44,2,192,0,63,252,2,192,0,56,45,255,255,192,63,252,171,234,64,52,0,98,197,0,63,252,242,203,0,57,84,226,195,128,57,87,194,195,192,63,255,130,193,128,52,0,31,192,0,32,0,9,0,0,
  // 0x99ac  馬
  172,153,17,18,90,19,1,254,6,170,170,168,0,15,255,255,253,0,15,0,224,0,0,15,85,245,84,0,15,255,255,252,0,15,0,224,0,0,15,85,245,84,0,15,255,255,252,0,15,0,224,0,0,15,0,224,0,0,15,255,255,255,128,6,170,170,171,128,24,0,66,67,128,44,112,210,199,64,60,52,176,215,64,180,52,112,11,0,224,36,1,255,0,0,0,0,164,0,
  // 0x9a45  驅
  69,154,17,19,95,19,1,253,127,252,255,255,192,119,212,229,85,64,114,192,192,0,0,127,248,195,254,0,118,208,195,10,0,114,192,195,10,0,127,248,195,254,0,118,208,192,0,0,114,192,192,0,0,127,253,223,223,192,21,109,220,216,192,0,157,220,216,192,171,173,220,216,192,154,124,223,223,192,222,108,192,0,0,200,44,213,85,64,128,120,255,255,192,1,244,192,0,0,0,0,0,0,0,
  // 0x9ad4  體
  212,154,17,19,95,19,1,254,0,0,6,32,0,63,252,7,52,0,57,108,191,255,128,58,252,183,51,128,58,108,179,51,128,58,108,191,255,128,58,172,183,51,128,255,255,191,255,128,208,7,0,0,0,127,254,255,255,192,45,120,85,85,64,44,56,63,255,64,47,248,52,7,64,40,56,52,7,64,47,248,63,255,64,44,56,12,12,0,40,56,13,44,0,40,249,255,255,192,20,80,85,85,64,
  // 0x9ad8  高
  216,154,17,19,95,19,1,254,0,1,128,0,0,0,2,208,0,0,191,255,255,255,128,106,170,170,170,64,0,0,0,0,0,2,255,255,224,0,2,192,0,224,0,2,208,1,224,0,2,255,255,224,0,0,0,0,0,0,63,255,255,255,0,61,85,85,95,0,60,0,0,11,0,60,63,255,11,0,60,52,7,11,0,60,56,11,11,0,60,63,255,15,0,60,52,1,255,0,40,0,0,168,0,
  // 0x9ec3  黃
  195,158,17,19,95,19,1,254,0,96,2,128,0,21,245,87,213,0,63,255,255,255,0,0,176,3,128,0,0,191,255,128,0,0,0,0,0,0,85,85,85,85,64,255,255,255,255,192,0,1,208,0,0,15,255,255,252,0,15,86,213,124,0,15,2,208,60,0,15,255,255,252,0,15,1,208,60,0,15,255,255,252,0,1,181,87,212,0,11,244,7,253,0,255,64,0,47,192,16,0,0,1,0,
  // 0x9ede  點
  222,158,17,19,95,19,1,254,0,0,0,128,0,191,255,1,208,0,182,215,1,208,0,189,223,1,208,0,186,235,1,250,128,186,247,1,255,192,177,199,1,208,0,191,255,1,208,0,2,208,1,208,0,22,213,1,208,0,191,255,63,255,64,2,192,62,171,64,255,255,120,3,64,170,169,56,3,64,21,90,56,3,64,119,115,120,3,64,163,50,191,255,64,211,16,62,171,64,64,0,36,1,0,
  // 0x9f4a  齊
  74,159,17,19,95,19,1,254,0,1,128,0,0,0,1,208,0,0,255,255,255,255,192,85,90,109,85,64,0,15,44,30,0,191,247,119,253,0,12,49,195,92,0,44,113,195,78,0,56,177,199,171,128,243,209,207,162,192,66,64,0,36,0,3,149,85,184,0,7,255,255,248,0,7,64,0,56,0,11,255,255,248,0,15,85,85,184,0,62,0,0,56,0,188,0,0,56,0,32,0,0,36,0,
  // 0xff1a  ：
  26,255,3,13,13,19,8,1,116,252,184,0,0,0,0,0,0,0,184,252,180,
};

#endif // HAS_GRAPHICAL_TFT
