/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Latin Extended-A 19pt, capital 'A' height: 14px, width: 100%, range: 0x0100-0x017f
extern const uint8_t NotoSans_Medium_Latin_Extended_A_14[6668] = {
  130,14,0,1,127,1,18,251, // unifont_t
  // 0x0100  Ā
  12,16,48,12,0,0,2,255,192,1,85,64,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x0101  ā
  9,14,42,11,1,255,31,253,0,5,84,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x0102  Ă
  12,17,51,12,0,0,3,129,192,1,255,128,0,20,0,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x0103  ă
  9,15,45,11,1,255,44,13,0,15,252,0,1,80,0,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,0,0,
  // 0x0104  Ą
  13,19,76,12,0,251,0,40,0,0,0,126,0,0,0,191,0,0,0,247,64,0,1,227,192,0,3,195,192,0,3,193,224,0,11,64,240,0,15,234,244,0,31,255,248,0,45,0,60,0,60,0,45,0,120,0,31,0,244,0,15,0,0,0,13,0,0,0,56,0,0,0,56,0,0,0,47,64,0,0,1,0,
  // 0x0105  ą
  9,16,48,11,1,251,1,80,0,47,253,0,41,31,0,0,11,64,0,11,64,47,255,64,189,11,64,240,11,64,240,15,64,249,191,64,63,227,64,0,11,0,0,28,0,0,28,0,0,15,192,0,1,0,
  // 0x0106  Ć
  10,19,57,12,1,255,0,2,128,0,11,128,0,30,0,0,20,0,0,106,128,7,255,240,31,128,96,61,0,0,124,0,0,180,0,0,244,0,0,244,0,0,244,0,0,184,0,0,124,0,0,63,0,0,15,234,240,2,255,224,0,0,0,
  // 0x0107  ć
  8,16,32,9,1,255,0,41,0,124,0,224,1,64,1,80,31,254,62,88,184,0,240,0,240,0,240,0,244,0,184,0,63,173,11,253,0,0,
  // 0x0108  Ĉ
  10,19,57,12,1,255,0,41,0,0,191,0,2,211,192,1,0,80,0,106,128,7,255,240,31,128,96,61,0,0,124,0,0,180,0,0,244,0,0,244,0,0,244,0,0,184,0,0,124,0,0,63,0,0,15,234,240,2,255,224,0,0,0,
  // 0x0109  ĉ
  8,16,32,9,1,255,1,144,7,244,30,60,20,5,1,80,31,254,62,88,184,0,240,0,240,0,240,0,244,0,184,0,63,173,11,253,0,0,
  // 0x010a  Ċ
  10,18,54,12,1,255,0,60,0,0,60,0,0,0,0,0,106,128,7,255,240,31,128,96,61,0,0,124,0,0,180,0,0,244,0,0,244,0,0,244,0,0,184,0,0,124,0,0,63,0,0,15,234,240,2,255,224,0,0,0,
  // 0x010b  ċ
  8,15,30,9,1,255,2,208,2,208,0,0,1,80,31,254,62,88,184,0,240,0,240,0,240,0,244,0,184,0,63,173,11,253,0,0,
  // 0x010c  Č
  10,19,57,12,1,255,2,64,144,1,211,192,0,191,0,0,20,0,0,106,128,7,255,240,31,128,96,61,0,0,124,0,0,180,0,0,244,0,0,244,0,0,244,0,0,184,0,0,124,0,0,63,0,0,15,234,240,2,255,224,0,0,0,
  // 0x010d  č
  8,16,32,9,1,255,36,5,30,60,7,240,1,80,1,80,31,254,62,88,184,0,240,0,240,0,240,0,244,0,184,0,63,173,11,253,0,0,
  // 0x010e  Ď
  11,18,54,14,2,0,8,2,0,11,30,0,3,248,0,0,80,0,170,144,0,255,255,0,240,31,192,240,2,240,240,0,244,240,0,184,240,0,120,240,0,120,240,0,120,240,0,244,240,1,240,240,7,224,250,255,128,255,248,0,
  // 0x010f  ď
  12,16,48,12,1,255,0,1,65,0,3,203,0,3,206,0,3,200,1,67,192,31,251,192,62,95,192,184,3,192,240,3,192,240,3,192,240,3,192,244,3,192,184,7,192,63,175,192,15,246,192,0,0,0,
  // 0x0110  Đ
  13,14,56,14,0,0,10,169,0,0,15,255,240,0,15,1,252,0,15,0,47,0,15,0,15,64,15,0,11,128,111,168,7,128,127,252,7,128,15,0,7,128,15,0,15,64,15,0,31,0,15,0,126,0,15,175,248,0,15,255,128,0,
  // 0x0111  đ
  11,16,48,12,1,255,0,1,64,0,3,192,1,255,248,1,171,228,0,3,192,31,247,192,62,111,192,184,7,192,244,3,192,240,3,192,240,3,192,240,3,192,184,7,192,63,175,192,31,246,192,0,0,0,
  // 0x0112  Ē
  8,16,32,11,2,0,63,248,21,84,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,
  // 0x0113  ē
  9,14,42,11,1,255,31,253,0,5,84,0,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,
  // 0x0114  Ĕ
  8,17,34,11,2,0,52,40,47,240,5,64,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,
  // 0x0115  ĕ
  9,15,45,11,1,255,44,13,0,15,252,0,1,80,0,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,
  // 0x0116  Ė
  8,17,34,11,2,0,3,192,3,192,0,0,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,
  // 0x0117  ė
  9,15,45,11,1,255,2,208,0,2,208,0,0,0,0,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,
  // 0x0118  Ę
  8,19,38,11,2,251,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,0,52,0,176,0,224,0,189,0,4,
  // 0x0119  ę
  9,16,48,11,1,251,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,29,0,0,56,0,0,56,0,0,47,64,0,1,0,
  // 0x011a  Ě
  8,18,36,11,2,0,96,24,60,180,15,224,1,64,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,
  // 0x011b  ě
  9,16,48,11,1,255,20,5,0,14,60,0,7,244,0,1,80,0,1,80,0,15,253,0,61,31,64,180,7,128,244,7,192,255,255,192,245,85,64,244,0,0,120,0,0,63,155,64,11,255,64,0,0,0,
  // 0x011c  Ĝ
  12,19,57,14,1,255,0,25,0,0,63,128,0,242,208,1,64,80,0,106,144,7,255,252,31,144,20,62,0,0,124,0,0,180,0,0,244,1,84,244,11,253,244,1,125,184,0,45,124,0,45,63,0,45,15,234,189,2,255,248,0,0,0,
  // 0x011d  ĝ
  9,20,60,12,1,251,1,160,0,3,248,0,15,45,0,20,5,0,1,64,0,31,250,192,62,95,192,184,3,192,240,3,192,240,2,192,240,2,192,244,3,192,184,3,192,62,111,192,15,247,192,0,3,192,0,3,192,36,15,128,127,255,0,5,148,0,
  // 0x011e  Ğ
  12,18,54,14,1,255,1,192,224,0,255,192,0,21,0,0,106,144,7,255,252,31,144,20,62,0,0,124,0,0,180,0,0,244,1,84,244,11,253,244,1,125,184,0,45,124,0,45,63,0,45,15,234,189,2,255,248,0,0,0,
  // 0x011f  ğ
  9,19,57,12,1,251,29,10,0,11,252,0,1,80,0,1,64,0,31,250,192,62,95,192,184,3,192,240,3,192,240,2,192,240,2,192,244,3,192,184,3,192,62,111,192,15,247,192,0,3,192,0,3,192,36,15,128,127,255,0,5,148,0,
  // 0x0120  Ġ
  12,18,54,14,1,255,0,30,0,0,30,0,0,0,0,0,106,144,7,255,252,31,144,20,62,0,0,124,0,0,180,0,0,244,1,84,244,11,253,244,1,125,184,0,45,124,0,45,63,0,45,15,234,189,2,255,248,0,0,0,
  // 0x0121  ġ
  9,19,57,12,1,251,0,224,0,1,240,0,0,0,0,1,64,0,31,250,192,62,95,192,184,3,192,240,3,192,240,2,192,240,2,192,244,3,192,184,3,192,62,111,192,15,247,192,0,3,192,0,3,192,36,15,128,127,255,0,5,148,0,
  // 0x0122  Ģ
  12,19,57,14,1,251,0,106,144,7,255,252,31,144,20,62,0,0,124,0,0,180,0,0,244,1,84,244,11,253,244,1,125,184,0,45,124,0,45,63,0,45,15,234,189,2,255,248,0,0,0,0,14,0,0,29,0,0,44,0,0,0,0,
  // 0x0123  ģ
  9,20,60,12,1,251,0,32,0,0,176,0,1,224,0,1,64,0,1,64,0,31,250,192,62,95,192,184,3,192,240,3,192,240,2,192,240,2,192,244,3,192,184,3,192,62,111,192,15,247,192,0,3,192,0,3,192,36,15,128,127,255,0,5,148,0,
  // 0x0124  Ĥ
  11,18,54,14,2,0,0,160,0,3,252,0,11,79,0,4,1,0,144,0,96,240,0,180,240,0,180,240,0,180,240,0,180,240,0,180,255,255,244,255,255,244,240,0,180,240,0,180,240,0,180,240,0,180,240,0,180,240,0,180,
  // 0x0125  ĥ
  12,19,57,12,255,0,6,64,0,31,208,0,60,180,0,80,20,0,1,64,0,7,128,0,7,128,0,7,128,0,7,129,64,7,175,244,7,245,188,7,192,61,7,128,45,7,128,45,7,128,45,7,128,45,7,128,45,7,128,45,7,128,45,
  // 0x0126  Ħ
  14,14,56,14,0,0,9,0,6,0,15,0,11,64,111,85,95,144,255,255,255,240,15,0,11,64,15,0,11,64,15,255,255,64,15,255,255,64,15,0,11,64,15,0,11,64,15,0,11,64,15,0,11,64,15,0,11,64,15,0,11,64,
  // 0x0127  ħ
  11,15,45,12,0,0,5,0,0,30,0,0,191,252,0,191,168,0,30,0,0,30,127,128,31,251,240,31,64,244,31,0,180,30,0,180,30,0,180,30,0,180,30,0,180,30,0,180,30,0,180,
  // 0x0128  Ĩ
  7,17,34,7,0,0,126,28,235,244,64,80,42,160,63,240,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,31,144,127,240,
  // 0x0129  ĩ
  7,14,28,5,255,0,62,12,235,248,64,80,0,0,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,
  // 0x012a  Ī
  7,16,32,7,0,0,191,244,85,80,42,160,63,240,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,31,144,127,240,
  // 0x012b  ī
  7,13,26,5,255,0,127,244,21,80,0,0,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,
  // 0x012c  Ĭ
  7,17,34,7,0,0,160,116,63,224,5,64,42,160,63,240,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,31,144,127,240,
  // 0x012d  ĭ
  7,14,28,5,255,0,112,56,63,240,5,64,0,0,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,
  // 0x012e  Į
  6,19,38,7,0,251,42,160,63,240,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,31,144,127,240,1,192,3,64,7,64,3,240,0,64,
  // 0x012f  į
  4,19,19,5,0,251,30,30,0,0,30,30,30,30,30,30,30,30,30,30,28,52,116,63,4,
  // 0x0130  İ
  6,17,34,7,0,0,11,64,11,64,0,0,42,160,63,240,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,31,144,127,240,
  // 0x0131  ı
  3,10,10,5,1,0,120,120,120,120,120,120,120,120,120,120,
  // 0x0132  Ĳ
  11,18,54,12,0,252,42,160,100,63,240,184,11,64,184,11,64,184,11,64,184,11,64,184,11,64,184,11,64,184,11,64,184,11,64,184,11,64,184,11,64,184,31,144,184,127,240,180,0,0,180,0,1,240,0,63,224,0,26,64,
  // 0x0133  ĳ
  8,19,38,10,1,251,120,15,120,31,0,0,0,0,120,31,120,31,120,31,120,31,120,31,120,31,120,31,120,31,120,31,120,31,0,31,0,30,0,46,3,252,1,144,
  // 0x0134  Ĵ
  8,22,44,6,254,252,1,160,3,248,15,29,20,1,0,144,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,240,1,224,3,208,127,192,105,0,
  // 0x0135  ĵ
  7,20,40,5,255,251,6,64,31,208,56,180,80,20,0,0,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,7,128,15,64,255,0,100,0,
  // 0x0136  Ķ
  10,19,57,12,2,251,144,1,144,240,7,192,240,31,0,240,60,0,240,244,0,243,208,0,251,192,0,255,208,0,245,240,0,240,188,0,240,62,0,240,15,64,240,7,192,240,2,224,0,0,0,1,208,0,2,192,0,3,128,0,0,0,0,
  // 0x0137  ķ
  9,20,60,11,1,251,20,0,0,120,0,0,120,0,0,120,0,0,120,0,0,120,11,128,120,46,0,120,184,0,122,224,0,127,208,0,126,240,0,120,124,0,120,46,0,120,15,64,120,7,192,0,0,0,1,208,0,2,192,0,3,128,0,0,0,0,
  // 0x0138  ĸ
  9,10,30,11,1,0,120,11,128,120,46,0,120,124,0,121,240,0,123,208,0,127,240,0,124,124,0,120,46,0,120,15,64,120,3,192,
  // 0x0139  Ĺ
  8,18,36,10,2,0,25,0,60,0,176,0,64,0,144,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,255,254,255,254,
  // 0x013a  ĺ
  5,19,38,5,1,0,6,64,31,0,60,0,16,0,20,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,
  // 0x013b  Ļ
  8,19,38,10,2,251,144,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,255,254,255,254,0,0,3,192,3,128,7,0,0,0,
  // 0x013c  ļ
  3,20,20,5,1,251,20,120,120,120,120,120,120,120,120,120,120,120,120,120,120,0,56,116,176,0,
  // 0x013d  Ľ
  8,14,28,10,2,0,144,9,240,29,240,44,240,16,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,255,254,255,254,
  // 0x013e  ľ
  6,15,30,5,1,0,20,80,120,224,121,192,121,64,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,
  // 0x013f  Ŀ
  8,14,28,10,2,0,144,0,240,0,240,0,240,0,240,0,240,0,240,120,240,120,240,0,240,0,240,0,240,0,255,254,255,254,
  // 0x0140  ŀ
  6,15,30,6,1,0,20,0,120,0,120,0,120,0,120,0,120,0,120,0,122,208,122,208,120,0,120,0,120,0,120,0,120,0,120,0,
  // 0x0141  Ł
  10,14,42,10,0,0,9,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,36,0,15,244,0,31,128,0,191,0,0,47,0,0,15,0,0,15,0,0,15,255,224,15,255,224,
  // 0x0142  ł
  5,15,30,5,0,0,4,0,46,0,46,0,46,0,46,0,46,0,46,128,47,192,126,0,254,0,46,0,46,0,46,0,46,0,46,0,
  // 0x0143  Ń
  11,18,54,15,2,0,0,10,0,0,30,0,0,56,0,0,80,0,164,0,40,252,0,60,254,0,60,239,0,60,231,192,60,227,208,60,224,240,60,224,184,60,224,61,60,224,31,60,224,11,188,224,3,252,224,1,252,224,0,252,
  // 0x0144  ń
  10,15,45,12,1,0,0,10,0,0,61,0,0,180,0,0,64,0,0,20,0,119,255,64,127,91,192,124,3,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,
  // 0x0145  Ņ
  11,19,57,15,2,251,164,0,40,252,0,60,254,0,60,239,0,60,231,192,60,227,208,60,224,240,60,224,184,60,224,61,60,224,31,60,224,11,188,224,3,252,224,1,252,224,0,252,0,0,0,0,120,0,0,176,0,0,224,0,0,0,0,
  // 0x0146  ņ
  10,16,48,12,1,251,0,20,0,119,255,64,127,91,192,124,3,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,0,0,0,0,176,0,0,240,0,0,192,0,0,0,0,
  // 0x0147  Ň
  11,18,54,15,2,0,9,1,64,7,143,0,1,252,0,0,84,0,164,0,40,252,0,60,254,0,60,239,0,60,231,192,60,227,208,60,224,240,60,224,184,60,224,61,60,224,31,60,224,11,188,224,3,252,224,1,252,224,0,252,
  // 0x0148  ň
  10,15,45,12,1,0,8,2,0,11,94,0,3,248,0,0,80,0,0,20,0,119,255,64,127,91,192,124,3,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,
  // 0x0149  ŉ
  12,14,42,14,0,0,40,0,0,60,0,0,120,0,0,176,1,80,227,223,252,3,249,126,3,224,15,3,208,15,3,192,15,3,192,15,3,192,15,3,192,15,3,192,15,3,192,15,
  // 0x014a  Ŋ
  11,18,54,15,2,252,164,0,40,252,0,60,254,0,60,239,64,60,231,192,60,226,224,60,224,244,60,224,124,60,224,46,60,224,15,124,224,7,252,224,2,252,224,0,252,224,0,124,0,0,60,0,0,184,0,31,240,0,10,64,
  // 0x014b  ŋ
  10,16,48,12,1,251,0,20,0,119,255,64,127,91,192,124,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,0,2,208,0,2,208,0,3,208,0,63,192,0,25,0,
  // 0x014c  Ō
  13,17,68,15,1,255,1,255,208,0,0,85,64,0,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x014d  ō
  10,14,42,12,1,255,15,254,0,5,85,0,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x014e  Ŏ
  13,18,72,15,1,255,2,192,208,0,0,255,192,0,0,21,0,0,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x014f  ŏ
  10,15,45,12,1,255,13,10,0,11,252,0,1,80,0,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x0150  Ő
  13,19,76,15,1,255,0,100,160,0,0,242,208,0,2,195,64,0,1,5,0,0,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x0151  ő
  10,16,48,12,1,255,2,70,0,11,94,0,29,60,0,20,16,0,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x0152  Œ
  16,15,60,18,1,255,0,170,170,169,11,255,255,255,47,64,244,0,60,0,180,0,120,0,180,0,180,0,180,0,244,0,191,253,244,0,191,253,180,0,180,0,184,0,180,0,124,0,180,0,62,0,180,0,15,234,255,254,2,255,255,255,0,0,0,0,
  // 0x0153  œ
  16,12,48,18,1,255,1,80,1,64,31,253,47,248,62,95,248,126,184,3,240,15,240,3,224,15,240,2,255,255,240,2,229,85,244,3,224,0,184,7,240,0,63,175,190,106,11,253,31,253,0,0,0,0,
  // 0x0154  Ŕ
  10,18,54,12,2,0,0,40,0,0,244,0,1,208,0,1,64,0,170,144,0,255,254,0,240,111,64,240,11,128,240,7,128,240,11,128,240,111,0,255,248,0,250,244,0,240,60,0,240,46,0,240,15,64,240,7,192,240,3,224,
  // 0x0155  ŕ
  7,15,30,8,1,0,0,100,0,240,3,192,1,0,0,20,118,248,127,148,125,0,124,0,120,0,120,0,120,0,120,0,120,0,120,0,
  // 0x0156  Ŗ
  10,19,57,12,2,251,170,144,0,255,254,0,240,111,64,240,11,128,240,7,128,240,11,128,240,111,0,255,248,0,250,244,0,240,60,0,240,46,0,240,15,64,240,7,192,240,3,224,0,0,0,0,224,0,1,192,0,3,128,0,0,0,0,
  // 0x0157  ŗ
  7,16,32,8,1,251,0,20,118,248,127,148,125,0,124,0,120,0,120,0,120,0,120,0,120,0,120,0,0,0,56,0,116,0,176,0,0,0,
  // 0x0158  Ř
  10,18,54,12,2,0,32,8,0,45,120,0,15,240,0,1,64,0,170,144,0,255,254,0,240,111,64,240,11,128,240,7,128,240,11,128,240,111,0,255,248,0,250,244,0,240,60,0,240,46,0,240,15,64,240,7,192,240,3,224,
  // 0x0159  ř
  7,15,30,8,1,0,80,24,60,180,15,208,5,64,0,20,118,248,127,148,125,0,124,0,120,0,120,0,120,0,120,0,120,0,120,0,
  // 0x015a  Ś
  9,19,57,10,1,255,0,40,0,0,120,0,0,224,0,1,64,0,6,168,0,63,255,0,188,6,0,240,0,0,244,0,0,189,0,0,47,208,0,7,252,0,0,127,0,0,15,64,0,7,128,0,15,64,250,191,0,191,248,0,0,0,0,
  // 0x015b  ś
  8,16,32,9,1,255,0,100,0,240,3,192,1,0,5,64,127,252,244,88,240,0,253,0,47,208,2,252,0,61,0,45,229,188,191,240,0,0,
  // 0x015c  Ŝ
  9,19,57,10,1,255,1,144,0,7,244,0,30,60,0,20,5,0,6,168,0,63,255,0,188,6,0,240,0,0,244,0,0,189,0,0,47,208,0,7,252,0,0,127,0,0,15,64,0,7,128,0,15,64,250,191,0,191,248,0,0,0,0,
  // 0x015d  ŝ
  8,16,32,9,1,255,6,64,31,208,60,180,80,20,5,64,127,252,244,88,240,0,253,0,47,208,2,252,0,61,0,45,229,188,191,240,0,0,
  // 0x015e  Ş
  9,19,57,10,1,251,6,168,0,63,255,0,188,6,0,240,0,0,244,0,0,189,0,0,47,208,0,7,252,0,0,127,0,0,15,64,0,7,128,0,15,64,250,191,0,191,248,0,3,128,0,3,208,0,0,240,0,10,224,0,10,64,0,
  // 0x015f  ş
  8,16,32,9,1,251,5,64,127,252,244,88,240,0,253,0,47,208,2,252,0,61,0,45,229,188,191,240,7,0,7,192,0,224,11,208,9,0,
  // 0x0160  Š
  9,19,57,10,1,255,36,5,0,30,60,0,7,240,0,1,80,0,6,168,0,63,255,0,188,6,0,240,0,0,244,0,0,189,0,0,47,208,0,7,252,0,0,127,0,0,15,64,0,7,128,0,15,64,250,191,0,191,248,0,0,0,0,
  // 0x0161  š
  8,16,32,9,1,255,80,24,60,180,15,208,5,64,5,64,127,252,244,88,240,0,253,0,47,208,2,252,0,61,0,45,229,188,191,240,0,0,
  // 0x0162  Ţ
  11,19,57,11,0,251,106,170,160,255,255,244,0,244,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,112,0,0,184,0,0,29,0,1,188,0,1,144,0,
  // 0x0163  ţ
  7,18,36,7,0,251,5,0,15,0,15,0,191,248,31,80,15,0,15,0,15,0,15,0,15,0,15,0,15,148,7,248,2,192,2,224,0,112,6,240,6,64,
  // 0x0164  Ť
  11,18,54,11,0,0,9,1,64,7,143,0,1,252,0,0,84,0,106,170,160,255,255,244,0,244,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,
  // 0x0165  ť
  9,16,48,7,0,255,0,0,64,0,2,192,5,3,128,15,2,0,15,0,0,191,248,0,31,80,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,148,0,7,248,0,0,0,0,
  // 0x0166  Ŧ
  11,14,42,11,0,0,106,170,160,255,255,244,0,244,0,0,180,0,0,180,0,0,180,0,10,254,128,31,255,192,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,
  // 0x0167  ŧ
  7,14,28,7,0,255,5,0,15,0,15,0,191,248,31,80,15,0,111,164,127,244,15,0,15,0,15,0,15,148,7,248,0,0,
  // 0x0168  Ũ
  12,18,54,14,1,255,2,244,144,7,111,192,1,1,0,36,0,24,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,61,60,0,60,62,0,188,15,235,240,2,255,128,0,0,0,
  // 0x0169  ũ
  10,15,45,12,1,255,11,211,64,29,255,0,20,4,0,0,0,0,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,3,208,124,7,208,63,175,208,31,249,208,0,0,0,
  // 0x016a  Ū
  12,17,51,14,1,255,3,255,192,1,85,64,36,0,24,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,61,60,0,60,62,0,188,15,235,240,2,255,128,0,0,0,
  // 0x016b  ū
  10,14,42,12,1,255,15,255,0,5,85,0,0,0,0,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,3,208,124,7,208,63,175,208,31,249,208,0,0,0,
  // 0x016c  Ŭ
  12,18,54,14,1,255,3,65,192,1,255,64,0,20,0,36,0,24,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,61,60,0,60,62,0,188,15,235,240,2,255,128,0,0,0,
  // 0x016d  ŭ
  10,15,45,12,1,255,13,11,0,7,253,0,0,80,0,0,0,0,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,3,208,124,7,208,63,175,208,31,249,208,0,0,0,
  // 0x016e  Ů
  12,20,60,14,1,255,0,40,0,0,235,0,0,195,0,0,235,0,0,20,0,36,0,24,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,61,60,0,60,62,0,188,15,235,240,2,255,128,0,0,0,
  // 0x016f  ů
  10,17,51,12,1,255,0,160,0,3,172,0,3,12,0,3,188,0,0,80,0,0,0,0,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,3,208,124,7,208,63,175,208,31,249,208,0,0,0,
  // 0x0170  Ű
  12,19,57,14,1,255,0,161,144,2,227,192,3,139,0,5,4,0,36,0,24,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,61,60,0,60,62,0,188,15,235,240,2,255,128,0,0,0,
  // 0x0171  ű
  10,16,48,12,1,255,2,134,64,11,79,0,14,44,0,20,16,0,0,0,0,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,3,208,124,7,208,63,175,208,31,249,208,0,0,0,
  // 0x0172  Ų
  12,19,57,14,1,251,36,0,24,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,45,124,0,61,60,0,60,62,0,188,15,235,240,2,255,208,0,3,128,0,7,0,0,11,0,0,3,224,0,0,64,
  // 0x0173  ų
  10,15,45,12,1,251,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,2,208,184,3,208,124,7,208,63,175,208,31,249,208,0,3,128,0,11,0,0,15,0,0,11,208,0,0,64,
  // 0x0174  Ŵ
  18,18,90,18,0,0,0,0,160,0,0,0,3,252,0,0,0,15,30,0,0,0,4,1,0,0,96,0,160,1,144,184,1,240,2,208,124,2,248,3,192,60,3,252,3,192,61,7,172,7,128,46,11,93,11,64,31,15,14,15,0,15,14,15,15,0,11,93,11,30,0,7,108,7,173,0,3,188,3,188,0,3,248,3,252,0,2,244,1,248,0,1,240,0,244,0,
  // 0x0175  ŵ
  15,15,60,15,0,0,0,6,64,0,0,15,224,0,0,60,180,0,0,80,20,0,16,1,0,20,180,11,192,60,120,15,208,120,60,14,224,180,60,44,240,240,29,60,176,240,14,56,117,224,15,116,58,192,11,176,63,192,7,224,31,128,3,208,15,64,
  // 0x0176  Ŷ
  11,18,54,11,0,0,0,100,0,1,253,0,3,139,64,5,1,64,96,0,40,124,0,180,61,0,240,31,2,208,15,71,192,7,207,64,2,239,0,0,252,0,0,184,0,0,120,0,0,120,0,0,120,0,0,120,0,0,120,0,
  // 0x0177  ŷ
  10,20,60,10,0,251,0,160,0,3,252,0,11,94,0,4,1,0,0,0,0,180,1,224,124,3,208,60,3,192,30,7,128,15,15,0,11,79,0,7,157,0,3,252,0,1,248,0,0,244,0,0,240,0,1,224,0,7,192,0,191,64,0,100,0,0,
  // 0x0178  Ÿ
  11,17,51,11,0,0,3,135,0,3,135,0,0,0,0,96,0,40,124,0,180,61,0,240,31,2,208,15,71,192,7,207,64,2,239,0,0,252,0,0,184,0,0,120,0,0,120,0,0,120,0,0,120,0,0,120,0,
  // 0x0179  Ź
  10,18,54,11,0,0,0,6,64,0,31,0,0,60,0,0,16,0,42,170,160,63,255,240,0,2,224,0,7,192,0,15,64,0,46,0,0,124,0,0,244,0,2,224,0,7,192,0,15,64,0,46,0,0,127,255,240,127,255,240,
  // 0x017a  ź
  9,15,45,9,0,0,0,25,0,0,124,0,0,240,0,1,64,0,0,0,0,63,255,0,21,111,0,0,61,0,0,184,0,1,240,0,3,192,0,11,64,0,30,0,0,62,170,0,127,255,64,
  // 0x017b  Ż
  10,17,51,11,0,0,0,120,0,0,120,0,0,0,0,42,170,160,63,255,240,0,2,224,0,7,192,0,15,64,0,46,0,0,124,0,0,244,0,2,224,0,7,192,0,15,64,0,46,0,0,127,255,240,127,255,240,
  // 0x017c  ż
  9,14,42,9,0,0,1,224,0,1,224,0,0,0,0,0,0,0,63,255,0,21,111,0,0,61,0,0,184,0,1,240,0,3,192,0,11,64,0,30,0,0,62,170,0,127,255,64,
  // 0x017d  Ž
  10,18,54,11,0,0,5,1,64,3,139,0,1,253,0,0,84,0,42,170,160,63,255,240,0,2,224,0,7,192,0,15,64,0,46,0,0,124,0,0,244,0,2,224,0,7,192,0,15,64,0,46,0,0,127,255,240,127,255,240,
  // 0x017e  ž
  9,15,45,9,0,0,20,5,0,14,44,0,7,244,0,1,80,0,0,0,0,63,255,0,21,111,0,0,61,0,0,184,0,1,240,0,3,192,0,11,64,0,30,0,0,62,170,0,127,255,64,
  // 0x017f  ſ
  6,15,30,7,1,0,1,80,47,240,61,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,
};

#endif // HAS_GRAPHICAL_TFT
