/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Korean 19pt, capital 'A' height: 14px, width: 100%, range: 0xac70-0xd788, glyphs: 110
extern const uint8_t NotoSans_Medium_Korean_14[8848] = {
  162,14,112,172,136,215,18,251, // unifont_t
  // 0xac70  거
  112,172,14,19,76,17,1,254,0,0,0,80,0,0,0,240,42,170,64,240,127,255,64,240,0,7,64,240,0,11,64,240,0,15,0,240,0,15,0,240,0,46,127,240,0,60,106,240,0,248,0,240,2,240,0,240,15,192,0,240,191,0,0,240,184,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xace0  고
  224,172,16,14,56,17,1,1,26,170,170,144,31,255,255,240,0,0,0,240,0,0,0,240,0,0,0,224,0,0,1,224,0,14,1,224,0,30,1,224,0,30,2,208,0,30,2,208,0,30,0,64,0,30,0,0,170,175,170,169,255,255,255,253,
  // 0xadf8  그
  248,173,16,14,56,17,1,1,10,170,170,144,31,255,255,208,0,0,1,208,0,0,1,208,0,0,2,208,0,0,2,208,0,0,2,208,0,0,2,208,0,0,3,192,0,0,3,192,0,0,3,192,0,0,0,0,170,170,170,169,255,255,255,253,
  // 0xae09  급
  9,174,16,18,72,17,1,254,10,170,170,144,15,255,255,224,0,0,1,224,0,0,1,224,0,0,1,208,0,0,2,208,0,0,2,192,255,255,255,253,170,170,170,169,0,0,0,0,15,0,1,224,15,0,1,224,15,255,255,224,15,170,170,224,15,0,1,224,15,0,1,224,15,255,255,224,10,170,170,144,
  // 0xae30  기
  48,174,14,19,76,17,1,254,0,0,0,80,0,0,0,240,42,170,128,240,63,255,192,240,0,3,192,240,0,7,128,240,0,7,128,240,0,15,64,240,0,31,0,240,0,61,0,240,0,188,0,240,2,240,0,240,15,192,0,240,127,0,0,240,120,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xae45  깅
  69,174,14,19,76,17,1,254,0,0,0,80,0,0,0,240,63,255,192,240,42,171,192,240,0,7,128,240,0,15,0,240,0,46,0,240,0,124,0,240,3,240,0,240,127,128,0,240,185,0,0,240,0,5,148,16,0,255,255,128,3,224,7,224,7,128,0,240,7,128,0,240,3,224,7,224,0,255,255,128,0,5,148,0,
  // 0xb044  끄
  68,176,16,14,56,17,1,1,26,164,170,144,63,252,255,240,0,60,0,240,0,56,0,240,0,120,0,224,0,120,0,224,0,180,1,224,0,180,1,224,0,240,2,208,0,240,3,192,0,80,1,128,0,0,0,0,170,170,170,169,255,255,255,253,
  // 0xb0b4  내
  180,176,15,19,76,17,1,254,0,0,0,16,0,0,56,120,0,0,56,120,120,0,56,120,120,0,56,120,120,0,56,120,120,0,56,120,120,0,56,120,120,0,63,248,120,0,62,184,120,0,56,120,120,0,56,120,126,255,56,120,127,249,56,120,0,0,56,120,0,0,56,120,0,0,56,120,0,0,36,120,0,0,0,36,
  // 0xb178  노
  120,177,16,15,60,17,1,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,170,170,144,15,255,255,240,0,7,128,0,0,7,128,0,0,7,128,0,0,7,128,0,0,7,128,0,255,255,255,253,170,170,170,169,
  // 0xb204  누
  4,178,16,18,72,17,1,254,10,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,170,170,144,15,255,255,240,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,253,0,7,128,0,0,7,128,0,0,7,128,0,0,7,128,0,0,7,128,0,0,7,128,0,0,2,64,0,
  // 0xb274  뉴
  116,178,16,18,72,17,1,254,9,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,170,170,144,15,255,255,224,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,253,0,224,30,0,0,224,30,0,0,224,30,0,0,224,30,0,0,224,30,0,0,224,30,0,0,144,9,0,
  // 0xb2c8  니
  200,178,13,19,76,17,2,254,0,0,1,64,0,0,3,192,160,0,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,0,83,192,250,255,227,192,255,250,67,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,2,128,
  // 0xb2e4  다
  228,178,16,19,76,17,1,254,0,0,1,64,0,0,2,192,42,170,66,192,127,255,130,192,120,0,2,192,120,0,2,192,120,0,2,192,120,0,2,234,120,0,2,255,120,0,2,192,120,0,2,192,120,0,2,192,126,175,242,192,127,254,162,192,0,0,2,192,0,0,2,192,0,0,2,192,0,0,2,192,0,0,1,128,
  // 0xb2f9  당
  249,178,16,19,76,17,1,254,0,0,0,64,0,0,2,208,127,255,66,208,126,170,2,208,120,0,2,208,120,0,2,255,120,0,2,249,120,0,2,208,126,171,242,208,127,255,162,208,0,0,2,208,0,22,80,0,1,255,255,0,7,208,11,192,15,0,2,208,15,0,2,208,7,208,11,192,1,255,255,0,0,22,148,0,
  // 0xb3c4  도
  196,179,16,15,60,17,1,0,15,255,255,224,15,170,170,144,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,255,255,224,10,171,234,144,0,7,128,0,0,7,128,0,0,7,128,0,0,7,128,0,255,255,255,253,170,170,170,169,
  // 0xb3cc  돌
  204,179,16,18,72,17,1,254,10,170,170,144,15,255,255,208,15,0,0,0,15,0,0,0,15,255,255,224,10,171,234,144,0,7,128,0,170,171,234,169,255,255,255,253,0,0,0,0,15,255,255,224,5,85,86,224,0,0,1,224,15,255,255,224,15,85,85,64,15,0,0,0,15,255,255,240,10,170,170,160,
  // 0xb3d9  동
  217,179,16,18,72,17,1,254,10,170,170,144,15,255,255,224,15,0,0,0,15,0,0,0,15,0,0,0,15,255,255,224,10,171,234,144,0,3,128,0,170,171,234,169,255,255,255,253,0,0,0,0,0,191,249,0,7,250,175,128,15,0,2,208,15,0,1,208,15,128,7,192,2,255,255,64,0,22,80,0,
  // 0xb418  되
  24,180,14,19,76,17,1,254,0,0,0,80,0,0,0,240,26,170,160,240,63,255,240,240,60,0,0,240,60,0,0,240,60,0,0,240,60,0,0,240,63,255,240,240,26,190,160,240,0,120,0,240,0,120,0,240,0,120,0,240,170,255,252,240,255,254,164,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xb41c  된
  28,180,15,18,72,17,1,255,0,0,0,16,0,0,0,240,31,255,224,240,31,170,144,240,29,0,0,240,29,0,0,240,31,170,160,240,31,255,240,240,0,120,0,240,0,120,0,240,170,255,252,240,255,254,164,240,0,0,0,240,3,128,0,240,3,128,0,0,3,128,0,0,3,234,170,164,3,255,255,248,
  // 0xb428  됨
  40,180,14,19,76,17,1,254,0,0,0,80,26,170,144,240,31,255,240,240,29,0,0,240,29,0,0,240,29,0,0,240,31,255,240,240,26,190,160,240,0,120,0,240,106,191,252,240,255,254,148,240,0,0,0,160,2,170,170,160,3,255,255,240,3,128,0,240,3,128,0,240,3,128,0,240,3,255,255,240,2,170,170,160,
  // 0xb4a4  뒤
  164,180,14,19,76,17,1,254,0,0,0,80,26,170,144,240,47,255,224,240,45,0,0,240,45,0,0,240,45,0,0,240,46,170,160,240,47,255,240,240,0,0,0,240,0,0,0,240,86,170,252,240,255,255,232,240,0,120,0,240,0,120,0,240,0,120,0,240,0,120,0,240,0,120,0,240,0,120,0,240,0,0,0,160,
  // 0xb4dc  드
  220,180,16,14,56,17,1,1,15,255,255,224,15,170,170,144,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,255,255,224,10,170,170,144,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,254,
  // 0xb514  디
  20,181,13,19,76,17,2,254,0,0,1,64,0,0,3,192,170,170,3,192,255,255,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,0,3,192,250,175,227,192,255,254,147,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,2,128,
  // 0xb77c  라
  124,183,16,19,76,17,1,254,0,0,1,64,0,0,2,208,42,170,66,208,127,255,66,208,0,7,66,208,0,7,66,208,0,7,66,208,42,175,66,234,127,255,66,255,120,0,2,208,120,0,2,208,120,0,2,208,120,1,98,208,127,255,242,208,42,165,2,208,0,0,2,208,0,0,2,208,0,0,2,208,0,0,1,128,
  // 0xb7ec  러
  236,183,14,19,76,17,1,254,0,0,0,80,0,0,0,240,106,170,0,240,127,255,0,240,0,11,0,240,0,11,0,240,0,11,0,240,127,255,26,240,126,170,63,240,116,0,0,240,116,0,0,240,116,0,0,240,116,1,80,240,127,255,224,240,106,165,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xb808  레
  8,184,15,19,76,17,1,254,0,0,0,20,0,0,44,120,106,164,44,120,191,248,44,120,0,120,44,120,0,120,44,120,0,120,44,120,106,186,252,120,127,249,188,120,116,0,44,120,116,0,44,120,116,0,44,120,126,191,44,120,127,250,44,120,0,0,44,120,0,0,44,120,0,0,44,120,0,0,24,120,0,0,0,36,
  // 0xb825  력
  37,184,14,19,76,17,1,254,0,0,0,80,42,170,0,240,127,255,0,240,0,15,26,240,0,15,63,240,21,95,0,240,127,255,0,240,120,0,63,240,120,0,26,240,126,171,192,240,127,255,128,240,0,0,0,96,6,170,170,160,7,255,255,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xb85c  로
  92,184,16,15,60,17,1,0,15,255,255,224,10,170,170,224,0,0,1,224,0,0,1,224,15,255,255,224,15,170,170,144,15,0,0,0,15,0,0,0,15,255,255,240,10,171,234,160,0,7,128,0,0,7,128,0,0,7,128,0,255,255,255,253,170,170,170,169,
  // 0xb8cc  료
  204,184,16,15,60,17,1,0,15,255,255,224,10,170,170,224,0,0,1,224,0,0,1,224,15,255,255,224,15,170,170,144,15,0,0,0,15,0,0,0,15,255,255,240,10,250,191,160,0,240,30,0,0,240,30,0,0,240,30,0,255,255,255,253,170,170,170,169,
  // 0xb974  르
  116,185,16,15,60,17,1,0,15,255,255,224,10,170,170,224,0,0,1,224,0,0,1,224,15,255,255,224,15,170,170,144,15,0,0,0,15,0,0,0,15,255,255,240,10,170,170,160,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,253,170,170,170,169,
  // 0xb9ac  리
  172,185,13,19,76,17,2,254,0,0,1,64,0,0,3,192,170,170,3,192,255,255,3,192,0,15,3,192,0,15,3,192,0,15,3,192,170,175,3,192,255,255,3,192,240,0,3,192,240,0,3,192,240,0,3,192,240,1,83,192,255,255,243,192,170,165,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,2,128,
  // 0xb9b0  린
  176,185,14,18,72,17,2,255,0,0,1,64,0,0,3,192,255,254,3,192,170,174,3,192,0,30,3,192,0,30,3,192,255,254,3,192,245,85,3,192,240,0,3,192,240,1,67,192,255,255,227,192,170,165,3,192,0,0,3,192,14,0,3,192,14,0,0,0,14,0,0,0,15,170,170,144,15,255,255,224,
  // 0xb9bd  립
  189,185,13,19,76,17,2,254,0,0,1,64,170,169,3,192,255,254,3,192,0,30,3,192,0,30,3,192,255,254,3,192,245,85,3,192,240,0,3,192,250,175,211,192,255,254,147,192,0,0,1,64,10,0,2,128,15,0,3,192,15,170,171,192,15,255,255,192,15,0,3,192,15,0,3,192,15,255,255,192,10,170,170,128,
  // 0xb9c1  링
  193,185,13,18,72,17,2,254,0,0,3,192,255,254,3,192,170,174,3,192,0,30,3,192,85,110,3,192,255,254,3,192,240,0,3,192,240,1,67,192,255,255,211,192,170,165,3,192,0,0,2,128,1,191,248,0,11,234,191,64,15,0,3,192,30,0,3,192,15,128,11,192,3,255,254,0,0,22,80,0,
  // 0xba48  멈
  72,186,14,19,76,17,1,254,0,0,0,80,0,0,0,240,127,255,128,240,126,171,128,240,120,3,128,240,120,3,255,240,120,3,234,240,120,3,128,240,126,171,128,240,127,255,128,240,0,0,0,240,0,0,0,0,3,255,255,240,3,234,170,240,3,192,0,176,3,192,0,176,3,192,0,176,3,255,255,240,2,170,170,160,
  // 0xba54  메
  84,186,15,19,76,17,1,254,0,0,0,20,0,0,44,56,106,168,44,56,127,252,44,56,116,44,44,56,116,44,44,56,116,44,44,56,116,46,188,56,116,47,252,56,116,44,44,56,116,44,44,56,116,44,44,56,122,188,44,56,127,252,44,56,0,0,44,56,0,0,44,56,0,0,44,56,0,0,44,56,0,0,0,36,
  // 0xba74  면
  116,186,15,18,72,17,1,255,0,0,0,80,0,0,0,240,127,255,128,240,126,171,234,240,120,3,255,240,120,3,128,240,120,3,128,240,120,3,234,240,120,3,255,240,127,255,128,240,42,170,64,240,0,0,0,240,2,128,0,240,3,192,0,96,3,192,0,0,3,192,0,0,3,234,170,164,3,255,255,248,
  // 0xbaa8  모
  168,186,16,15,60,17,1,0,31,255,255,224,31,170,170,224,30,0,0,224,30,0,0,224,30,0,0,224,30,0,0,224,30,0,0,224,31,255,255,224,10,171,234,144,0,7,128,0,0,7,128,0,0,7,128,0,0,7,128,0,255,255,255,253,170,170,170,169,
  // 0xbabb  못
  187,186,16,18,72,17,1,254,10,170,170,144,15,255,255,208,15,0,1,208,15,0,1,208,15,0,1,208,15,255,255,208,10,171,234,144,0,7,128,0,170,171,234,169,255,255,255,253,0,0,0,0,0,7,128,0,0,11,192,0,0,15,224,0,0,125,248,0,6,244,63,128,47,128,11,240,4,0,0,80,
  // 0xbbf8  미
  248,187,13,19,76,17,2,254,0,0,1,64,0,0,3,192,170,170,3,192,255,255,3,192,240,15,3,192,240,15,3,192,240,15,3,192,240,15,3,192,240,15,3,192,240,15,3,192,240,15,3,192,240,15,3,192,250,175,3,192,255,255,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,2,128,
  // 0xbc00  밀
  0,188,14,19,76,17,2,254,0,0,1,64,170,170,3,192,255,255,3,192,224,15,3,192,224,15,3,192,224,15,3,192,224,15,3,192,250,175,3,192,255,255,3,192,0,0,2,128,10,170,170,128,15,255,255,192,0,0,3,192,5,85,87,192,15,255,255,192,15,0,0,0,15,0,0,0,15,255,255,224,10,170,170,144,
  // 0xbc14  바
  20,188,16,19,76,17,1,254,0,0,1,64,0,0,2,192,116,3,130,192,116,3,130,192,116,3,130,192,116,3,130,192,126,171,130,192,127,255,130,234,116,3,130,255,116,3,130,192,116,3,130,192,116,3,130,192,116,3,130,192,127,255,130,192,106,170,66,192,0,0,2,192,0,0,2,192,0,0,2,192,0,0,2,128,
  // 0xbc84  버
  132,188,14,19,76,17,1,254,0,0,0,80,0,0,0,240,120,7,128,240,120,7,128,240,120,7,128,240,120,7,128,240,126,171,128,240,127,255,255,240,120,7,234,240,120,7,128,240,120,7,128,240,120,7,128,240,126,171,128,240,127,255,128,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,96,
  // 0xbca0  베
  160,188,15,19,76,17,1,254,0,0,0,16,0,0,44,56,100,24,44,56,116,44,44,56,116,44,44,56,116,44,44,56,122,188,44,56,127,254,188,56,116,47,252,56,116,44,44,56,116,44,44,56,116,44,44,56,122,188,44,56,127,252,44,56,0,0,44,56,0,0,44,56,0,0,44,56,0,0,40,56,0,0,0,36,
  // 0xbca8  벨
  168,188,15,19,76,17,1,254,0,0,0,16,16,4,60,116,116,29,60,116,116,29,60,116,127,254,188,116,121,111,252,116,116,29,60,116,126,173,60,116,127,253,60,116,0,0,44,116,0,0,0,0,3,255,255,244,2,170,170,244,0,0,0,116,3,255,255,244,3,213,85,80,3,192,0,0,3,255,255,252,1,170,170,168,
  // 0xbcf8  본
  248,188,16,17,68,17,1,255,5,0,0,64,15,0,1,208,15,170,170,208,15,255,255,208,15,0,1,208,15,0,1,208,15,255,255,208,10,171,234,144,0,7,128,0,170,171,234,169,255,255,255,253,0,0,0,0,14,0,0,0,15,0,0,0,15,0,0,0,15,170,170,144,15,255,255,224,
  // 0xbe44  비
  68,190,13,19,76,17,2,254,0,0,1,64,0,0,3,192,240,15,3,192,240,15,3,192,240,15,3,192,240,15,3,192,250,175,3,192,255,255,3,192,240,15,3,192,240,15,3,192,240,15,3,192,240,15,3,192,240,15,3,192,255,255,3,192,170,170,3,192,0,0,3,192,0,0,3,192,0,0,3,192,0,0,2,128,
  // 0xc0ac  사
  172,192,16,19,76,17,1,254,0,0,1,64,0,0,2,192,0,240,2,192,0,240,2,192,0,240,2,192,0,240,2,192,0,240,2,192,1,244,2,192,2,248,2,255,3,252,2,234,11,94,2,192,15,15,66,192,125,7,210,192,248,1,226,192,80,0,66,192,0,0,2,192,0,0,2,192,0,0,2,192,0,0,1,128,
  // 0xc0bd  삽
  189,192,16,19,76,17,1,254,0,0,1,64,0,160,2,208,0,240,2,208,0,240,2,208,1,244,2,233,2,252,2,255,7,238,2,208,15,79,130,208,190,7,242,208,184,0,210,208,0,0,1,128,6,0,1,128,11,64,2,208,11,170,171,208,11,255,255,208,11,64,2,208,11,64,2,208,11,255,255,208,6,170,170,128,
  // 0xc0c8  새
  200,192,15,19,76,17,1,254,0,0,0,16,0,0,60,56,1,128,60,56,2,192,60,56,2,192,60,56,2,208,60,56,2,208,60,56,3,208,60,56,3,224,63,248,7,240,62,184,11,180,60,56,30,60,60,56,124,31,124,56,248,11,60,56,96,0,60,56,0,0,60,56,0,0,60,56,0,0,56,56,0,0,0,36,
  // 0xc124  설
  36,193,15,19,76,17,1,254,0,0,0,80,0,240,0,240,0,240,0,240,0,240,42,240,1,248,127,240,3,252,0,240,11,159,0,240,47,11,224,240,252,1,224,240,16,0,0,96,2,170,170,160,3,255,255,240,0,0,0,240,1,85,85,240,3,255,255,240,3,192,0,0,3,192,0,0,3,255,255,252,2,170,170,164,
  // 0xc18c  소
  140,193,16,16,64,17,1,0,0,1,0,0,0,7,128,0,0,7,192,0,0,11,192,0,0,15,208,0,0,62,240,0,0,188,188,0,7,240,47,128,127,128,11,248,57,1,0,180,0,7,128,0,0,7,128,0,0,7,128,0,0,7,128,0,255,255,255,253,170,170,170,169,
  // 0xc18d  속
  141,193,16,18,72,17,1,254,0,7,128,0,0,11,192,0,0,15,208,0,0,62,244,0,2,248,126,64,63,208,11,244,41,7,128,160,0,7,128,0,170,171,234,169,255,255,255,253,0,0,0,0,0,0,0,0,31,255,255,224,10,170,170,224,0,0,1,224,0,0,1,224,0,0,1,224,0,0,1,144,
  // 0xc2a4  스
  164,194,16,15,60,17,1,1,0,1,0,0,0,7,128,0,0,7,192,0,0,11,192,0,0,15,208,0,0,61,240,0,0,248,125,0,7,240,47,128,127,128,7,248,40,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,170,170,170,169,255,255,255,253,
  // 0xc2ac  슬
  172,194,16,19,76,17,1,254,0,1,0,0,0,7,192,0,0,11,192,0,0,47,240,0,0,188,189,0,47,224,31,244,62,0,1,176,0,0,0,0,255,255,255,253,170,170,170,169,0,0,0,0,15,255,255,224,5,85,86,224,0,0,1,224,15,255,255,224,15,85,85,64,15,0,0,0,15,255,255,240,10,170,170,160,
  // 0xc2dc  시
  220,194,14,18,72,17,1,254,0,0,0,240,0,96,0,240,0,180,0,240,0,180,0,240,0,180,0,240,0,244,0,240,0,248,0,240,1,252,0,240,2,237,0,240,7,207,0,240,15,75,192,240,126,2,244,240,248,0,176,240,16,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,0,
  // 0xc2dd  식
  221,194,14,19,76,17,1,254,0,0,0,80,0,96,0,240,0,240,0,240,0,244,0,240,0,244,0,240,1,248,0,240,2,253,0,240,11,143,0,240,47,7,224,240,253,1,240,240,96,0,16,240,0,0,0,96,6,170,170,160,7,255,255,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xc5b4  어
  180,197,14,19,76,17,1,254,0,0,0,80,0,0,0,240,6,244,0,240,31,253,0,240,61,15,0,240,120,7,64,240,180,3,128,240,176,3,234,240,176,3,255,240,176,3,192,240,116,3,128,240,56,11,64,240,61,31,0,240,15,253,0,240,1,160,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xc5c6  없
  198,197,16,19,76,17,1,254,0,0,0,80,1,144,0,240,31,254,0,240,124,11,128,240,176,3,234,240,240,3,255,240,180,3,192,240,61,15,64,240,31,254,0,240,1,144,0,240,0,0,0,0,14,15,3,192,14,15,3,192,15,255,3,192,15,95,11,208,14,15,15,240,14,15,60,124,15,255,248,46,10,169,16,4,
  // 0xc5d1  엑
  209,197,15,19,76,17,1,254,0,0,0,16,0,0,44,116,11,224,44,116,63,252,44,116,180,30,44,116,240,15,188,116,240,15,252,116,176,14,44,116,120,61,44,116,47,248,44,116,6,144,44,116,0,0,24,36,2,170,170,164,3,255,255,244,0,0,0,116,0,0,0,116,0,0,0,116,0,0,0,116,0,0,0,100,
  // 0xc5d4  엔
  212,197,15,18,72,17,1,255,0,0,0,16,0,0,44,116,11,224,44,116,63,252,44,116,180,30,44,116,240,15,188,116,240,15,252,116,176,14,44,116,120,61,44,116,47,248,44,116,6,144,44,116,0,0,44,116,2,192,44,116,3,192,4,116,3,192,0,0,3,192,0,0,3,234,170,168,3,255,255,252,
  // 0xc5f4  열
  244,197,15,19,76,17,1,254,0,0,0,80,7,248,0,240,63,191,170,240,120,7,255,240,176,3,192,240,240,3,192,240,180,3,234,240,61,15,255,240,31,253,0,240,1,144,0,160,2,170,170,160,3,255,255,240,0,0,0,240,1,85,85,240,3,255,255,240,3,192,0,0,3,192,0,0,3,255,255,248,2,170,170,164,
  // 0xc608  예
  8,198,15,19,76,17,1,254,0,0,0,16,0,0,44,56,11,208,44,56,47,244,44,56,60,60,44,56,116,47,252,56,176,31,188,56,240,29,44,56,240,29,44,56,240,29,44,56,176,31,188,56,116,47,252,56,60,124,44,56,47,240,44,56,6,144,44,56,0,0,44,56,0,0,44,56,0,0,44,56,0,0,0,36,
  // 0xc624  오
  36,198,16,16,64,17,1,0,0,6,80,0,1,255,254,0,7,208,27,192,15,0,2,224,29,0,0,240,45,0,0,240,30,0,1,224,15,128,3,208,3,250,191,64,0,111,248,0,0,7,128,0,0,7,128,0,0,7,128,0,0,7,128,0,255,255,255,253,170,170,170,169,
  // 0xc628  온
  40,198,16,17,68,17,1,255,0,127,249,0,7,250,191,128,15,64,3,208,30,0,1,224,15,0,1,224,15,144,11,208,2,255,255,64,0,27,208,0,0,7,128,0,255,255,255,253,170,170,170,169,0,0,0,0,15,0,0,0,15,0,0,0,15,0,0,0,15,170,170,144,15,255,255,224,
  // 0xc644  완
  68,198,16,18,72,17,1,255,0,0,0,64,0,84,2,208,15,255,2,208,46,7,194,208,60,2,194,208,60,2,194,208,46,7,194,249,11,255,2,254,0,244,2,208,0,240,2,208,170,255,246,208,255,250,146,208,0,0,2,208,10,0,2,208,11,0,0,64,11,0,0,0,11,170,170,160,11,255,255,240,
  // 0xc6d0  원
  208,198,15,17,68,17,1,255,0,84,0,240,11,255,128,240,46,6,208,240,60,1,224,240,46,2,208,240,11,255,128,240,0,84,0,240,170,175,252,240,255,255,252,240,0,125,0,240,0,120,63,240,0,120,21,240,15,100,0,240,15,0,0,0,15,0,0,0,15,170,170,164,15,255,255,248,
  // 0xc704  위
  4,199,14,19,76,17,1,254,0,0,0,80,0,100,0,240,11,255,128,240,31,2,224,240,44,0,240,240,60,0,240,240,46,1,224,240,15,239,192,240,2,254,0,240,0,0,0,240,170,175,252,240,255,254,148,240,0,120,0,240,0,120,0,240,0,120,0,240,0,120,0,240,0,120,0,240,0,120,0,240,0,0,0,160,
  // 0xc73c  으
  60,199,16,16,64,17,1,0,0,22,80,0,1,255,254,0,7,208,31,192,15,0,2,224,30,0,0,240,45,0,0,240,30,0,0,240,15,0,2,224,7,208,31,192,1,255,254,0,0,22,144,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,253,170,170,170,169,
  // 0xc74c  음
  76,199,16,18,72,17,1,254,0,191,249,0,7,250,175,192,15,0,2,224,30,0,1,240,15,0,2,224,7,250,175,192,0,191,249,0,0,0,0,0,170,170,170,169,255,255,255,253,0,0,0,0,10,170,170,144,15,255,255,224,14,0,1,224,14,0,1,224,14,0,1,224,15,255,255,224,10,170,170,144,
  // 0xc774  이
  116,199,14,19,76,17,1,254,0,0,0,80,0,0,0,240,2,248,0,240,15,255,0,240,46,11,64,240,60,3,192,240,56,2,192,240,116,2,192,240,116,2,208,240,120,2,192,240,56,3,192,240,60,3,192,240,30,15,64,240,11,254,0,240,1,164,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xc77c  일
  124,199,15,19,76,17,1,254,0,0,0,16,1,148,0,240,31,255,0,240,61,11,192,240,180,3,192,240,180,2,192,240,120,3,192,240,63,175,64,240,7,248,0,240,0,0,0,96,2,170,170,160,3,255,255,240,0,0,0,240,1,85,85,240,3,255,255,240,3,192,0,0,3,192,0,0,3,255,255,248,2,170,170,164,
  // 0xc77d  읽
  125,199,14,19,76,17,1,254,0,0,0,80,1,148,0,240,31,255,0,240,61,11,128,240,180,3,192,240,176,2,192,240,180,3,192,240,61,11,128,240,31,255,0,240,1,148,0,240,0,0,0,0,15,255,191,240,5,111,106,240,0,15,0,240,15,255,0,240,15,85,0,240,15,0,64,240,15,255,192,240,5,85,0,160,
  // 0xc785  입
  133,199,14,19,76,17,1,254,0,0,0,80,1,148,0,240,31,255,0,240,61,11,192,240,180,3,192,240,176,2,208,240,180,3,192,240,61,11,192,240,31,255,0,240,1,164,0,240,0,0,0,0,3,192,0,240,3,192,0,240,3,255,255,240,3,234,170,240,3,192,0,240,3,192,0,240,3,255,255,240,2,170,170,160,
  // 0xc790  자
  144,199,16,19,76,17,1,254,0,0,1,64,0,0,2,192,106,170,146,192,191,255,226,192,0,240,2,192,0,240,2,192,0,240,2,192,0,240,2,192,1,244,2,255,3,252,2,234,3,173,2,192,15,79,2,192,46,7,210,192,252,2,242,192,240,0,82,192,0,0,2,192,0,0,2,192,0,0,2,192,0,0,1,128,
  // 0xc791  작
  145,199,16,19,76,17,1,254,0,0,0,64,0,0,2,208,191,255,226,208,106,250,146,208,0,240,2,208,1,244,2,233,2,248,2,255,7,237,2,208,31,15,130,208,253,7,242,208,180,0,146,208,0,0,1,128,10,170,170,128,15,255,255,208,0,0,2,208,0,0,2,208,0,0,2,208,0,0,2,208,0,0,1,128,
  // 0xc798  잘
  152,199,16,19,76,17,1,254,0,0,1,64,106,170,146,208,191,255,226,208,0,240,2,208,1,240,2,233,2,248,2,255,7,238,2,208,31,15,210,208,253,2,226,208,160,0,1,144,5,85,85,64,11,255,255,208,0,0,2,208,5,85,86,208,11,255,255,208,11,0,0,0,11,0,0,0,11,255,255,240,6,170,170,144,
  // 0xc7a5  장
  165,199,16,19,76,17,1,254,0,0,0,64,0,0,2,208,191,255,226,208,106,250,146,208,0,240,2,208,1,244,2,255,2,252,2,249,7,238,2,208,31,79,130,208,190,3,242,208,180,0,82,208,0,0,1,128,0,127,249,0,3,250,175,128,11,64,3,208,15,0,1,208,7,208,7,192,2,255,255,64,0,22,80,0,
  // 0xc7ac  재
  172,199,15,19,76,17,1,254,0,0,0,20,0,0,60,56,106,170,60,56,255,255,60,56,2,192,60,56,2,192,60,56,3,208,60,56,3,208,60,56,3,224,63,248,7,240,62,184,11,180,60,56,30,60,60,56,60,31,60,56,248,11,124,56,160,1,60,56,0,0,60,56,0,0,60,56,0,0,60,56,0,0,0,36,
  // 0xc800  저
  0,200,14,19,76,17,1,254,0,0,0,80,0,0,0,240,106,170,160,240,191,255,240,240,0,240,0,240,0,240,0,240,0,240,0,240,0,244,63,240,1,248,42,240,3,252,0,240,7,158,0,240,15,15,64,240,62,3,224,240,252,1,240,240,160,0,16,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xc804  전
  4,200,15,18,72,17,1,255,0,0,0,80,0,0,0,240,127,255,224,240,106,250,144,240,0,240,0,240,0,244,42,240,1,252,63,240,3,237,0,240,15,79,64,240,126,7,240,240,184,0,224,240,0,0,0,240,1,128,0,240,3,192,0,96,3,192,0,0,3,192,0,0,3,234,170,164,3,255,255,248,
  // 0xc815  정
  21,200,14,19,76,17,1,254,0,0,0,16,0,0,0,240,127,255,224,240,106,250,144,240,0,244,0,240,0,248,63,240,2,252,42,240,7,159,0,240,31,11,192,240,190,3,240,240,180,0,80,240,0,0,0,80,0,47,254,0,1,250,175,208,3,192,0,240,3,128,0,240,3,224,2,240,0,255,255,128,0,5,148,0,
  // 0xc81c  제
  28,200,15,19,76,17,1,254,0,0,0,20,0,0,44,120,106,170,44,120,191,255,44,120,2,192,44,120,2,192,44,120,3,208,44,120,3,211,252,120,3,226,188,120,7,240,44,120,15,180,44,120,30,60,44,120,60,47,44,120,248,15,108,120,160,1,44,120,0,0,44,120,0,0,44,120,0,0,44,120,0,0,0,36,
  // 0xc8fd  죽
  253,200,16,18,72,17,1,254,26,170,170,160,47,255,255,240,0,15,192,0,0,47,240,0,1,188,189,0,47,224,31,244,62,0,1,240,0,0,0,0,255,255,255,253,170,171,234,169,0,7,128,0,0,7,128,0,31,255,255,224,10,170,170,224,0,0,1,224,0,0,1,224,0,0,1,224,0,0,1,144,
  // 0xc900  준
  0,201,16,17,68,17,1,255,26,170,170,160,47,255,255,240,0,15,192,0,0,15,224,0,0,125,248,0,6,244,63,64,63,208,11,244,41,0,0,160,0,0,0,0,255,255,255,253,170,171,234,169,0,3,192,0,15,3,192,0,15,2,64,0,15,0,0,0,15,170,170,144,15,255,255,240,
  // 0xc911  중
  17,201,16,18,72,17,1,254,26,170,170,160,47,255,255,240,0,15,208,0,0,47,240,0,1,252,189,0,47,224,31,244,62,0,1,240,0,0,0,0,255,255,255,253,170,171,234,169,0,7,128,0,0,27,208,0,2,255,255,64,15,128,7,192,15,0,1,224,15,128,7,192,3,255,255,64,0,21,80,0,
  // 0xc990  즐
  144,201,16,18,72,17,1,254,26,170,170,160,47,255,255,240,0,15,192,0,0,47,240,0,6,252,126,64,63,208,11,244,20,0,0,16,255,255,255,253,170,170,170,169,0,0,0,0,15,255,255,224,5,85,86,224,0,0,1,224,15,255,255,224,15,85,85,64,15,0,0,0,15,255,255,240,10,170,170,160,
  // 0xc9c0  지
  192,201,14,19,76,17,1,254,0,0,0,80,0,0,0,240,106,170,160,240,127,255,240,240,0,180,0,240,0,180,0,240,0,244,0,240,0,248,0,240,0,252,0,240,2,252,0,240,3,223,0,240,15,75,128,240,47,3,224,240,252,0,244,240,112,0,16,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xcc98  처
  152,204,14,19,76,17,1,254,0,0,0,80,0,240,0,240,0,240,0,240,106,250,144,240,191,255,224,240,0,240,0,240,0,240,0,240,0,240,0,240,0,244,63,240,1,252,42,240,3,236,0,240,11,79,0,240,31,11,192,240,189,2,240,240,180,0,160,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xcd08  초
  8,205,16,16,64,17,1,0,0,3,128,0,0,3,128,0,26,171,234,160,47,255,255,240,0,7,192,0,0,11,192,0,0,31,240,0,0,124,184,0,7,244,63,144,63,128,7,248,36,3,128,96,0,3,128,0,0,3,128,0,0,3,128,0,255,255,255,253,170,170,170,169,
  // 0xcd95  축
  149,205,16,19,76,17,1,254,0,1,64,0,0,7,128,0,26,171,234,144,47,255,255,240,0,11,192,0,0,31,240,0,6,252,190,64,63,208,11,244,20,0,0,80,170,170,170,169,255,255,255,253,0,7,128,0,0,7,128,0,31,255,255,224,10,170,170,224,0,0,1,224,0,0,1,224,0,0,1,224,0,0,0,144,
  // 0xcd9c  출
  156,205,16,19,76,17,1,254,0,2,64,0,0,7,128,0,31,255,255,240,5,95,213,80,0,15,208,0,0,126,248,0,47,244,63,228,62,64,6,244,85,85,85,84,255,255,255,253,0,7,128,0,5,91,213,64,15,255,255,224,0,0,1,224,15,255,255,224,15,85,85,64,15,0,0,0,15,255,255,240,5,85,85,80,
  // 0xcda4  춤
  164,205,16,19,76,17,1,254,0,1,64,0,0,7,128,0,26,171,234,144,31,255,255,240,0,11,192,0,0,31,240,0,5,252,190,64,63,208,11,244,20,0,0,80,170,170,170,169,255,255,255,253,0,7,128,0,0,7,128,0,15,255,255,224,15,170,170,224,14,0,1,224,14,0,1,224,15,255,255,224,10,170,170,144,
  // 0xcde8  취
  232,205,14,19,76,17,1,254,0,16,0,80,0,120,0,240,26,190,160,240,63,255,240,240,0,120,0,240,0,188,0,240,1,255,0,240,11,203,208,240,63,2,244,240,36,0,16,240,0,1,88,240,255,255,252,240,170,189,0,240,0,120,0,240,0,120,0,240,0,120,0,240,0,120,0,240,0,120,0,240,0,0,0,160,
  // 0xce58  치
  88,206,14,19,76,17,1,254,0,0,0,80,0,180,0,240,0,180,0,240,42,254,160,240,127,255,240,240,0,180,0,240,0,180,0,240,0,184,0,240,0,252,0,240,1,253,0,240,2,223,0,240,7,139,128,240,31,3,224,240,189,0,248,240,52,0,32,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xce68  침
  104,206,14,19,76,17,1,254,0,80,0,80,0,180,0,240,42,250,160,240,127,255,240,240,0,180,0,240,0,248,0,240,1,252,0,240,3,223,0,240,31,135,224,240,190,1,244,240,52,0,16,240,0,0,0,0,3,255,255,240,3,234,170,240,3,192,0,240,3,192,0,240,3,192,0,240,3,255,255,240,2,170,170,160,
  // 0xce74  카
  116,206,16,19,76,17,1,254,0,0,1,64,0,0,2,192,42,170,66,192,63,255,130,192,0,3,130,192,0,7,130,192,0,7,66,192,106,191,2,192,191,255,2,255,0,46,2,234,0,60,2,192,0,244,2,192,7,224,2,192,47,128,2,192,189,0,2,192,32,0,2,192,0,0,2,192,0,0,2,192,0,0,1,128,
  // 0xcf1c  켜
  28,207,14,19,76,17,1,254,0,0,0,80,0,0,0,240,42,170,64,240,63,255,128,240,0,7,64,240,0,11,234,240,0,15,255,240,255,255,0,240,254,190,0,240,0,60,0,240,0,184,170,240,1,240,255,240,11,192,0,240,63,0,0,240,252,0,0,240,16,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xd0d1  탑
  209,208,16,19,76,17,1,254,0,0,1,64,42,170,66,208,127,255,130,208,120,0,2,208,120,0,2,208,127,255,66,255,126,170,2,249,120,0,2,208,126,171,226,208,127,255,146,208,0,0,1,128,6,0,1,128,11,64,2,208,11,170,171,208,11,255,255,208,11,64,2,208,11,64,2,208,11,255,255,208,6,170,170,128,
  // 0xd130  터
  48,209,14,19,76,17,1,254,0,0,0,80,0,0,0,240,127,255,128,240,126,170,64,240,120,0,0,240,120,0,0,240,120,0,0,240,126,170,42,240,127,255,63,240,120,0,0,240,120,0,0,240,120,0,0,240,120,1,80,240,127,255,224,240,42,165,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
  // 0xd14c  테
  76,209,15,19,76,17,1,254,0,0,0,36,0,0,60,120,106,168,60,120,127,252,60,120,116,0,60,120,116,0,60,120,116,0,60,120,122,162,188,120,127,243,252,120,116,0,60,120,116,0,60,120,116,0,60,120,116,5,60,120,127,255,60,120,106,148,60,120,0,0,60,120,0,0,60,120,0,0,44,120,0,0,0,36,
  // 0xd1a0  토
  160,209,16,15,60,17,1,0,15,255,255,224,15,170,170,144,15,0,0,0,15,0,0,0,15,255,255,192,15,170,170,128,15,0,0,0,15,0,0,0,15,255,255,240,10,171,234,144,0,7,128,0,0,7,128,0,0,7,128,0,255,255,255,253,170,170,170,169,
  // 0xd2b8  트
  184,210,16,15,60,17,1,0,15,255,255,224,15,170,170,144,15,0,0,0,15,0,0,0,15,255,255,208,15,170,170,128,15,0,0,0,15,0,0,0,15,255,255,240,10,170,170,144,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,254,170,170,170,169,
  // 0xd39c  펜
  156,211,15,18,72,17,1,255,0,0,0,16,0,0,45,120,106,170,45,120,255,255,45,120,44,56,45,120,44,56,45,120,44,57,253,120,44,57,189,120,44,56,45,120,190,191,109,120,255,250,45,120,0,0,45,120,1,128,45,120,2,192,4,116,2,192,0,0,2,192,0,0,2,234,170,168,2,255,255,252,
  // 0xd504  프
  4,213,16,15,60,17,1,0,26,170,170,160,63,255,255,240,0,224,30,0,0,224,30,0,0,224,30,0,0,224,30,0,0,224,30,0,0,224,30,0,47,255,255,240,26,170,170,160,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,254,170,170,170,169,
  // 0xd558  하
  88,213,16,19,76,17,1,254,0,0,1,64,0,240,2,208,0,240,2,208,170,250,162,208,255,255,242,208,0,0,2,208,1,164,2,208,15,255,2,208,46,11,130,255,60,3,194,234,120,2,194,208,60,3,194,208,62,11,130,208,15,255,2,208,1,164,2,208,0,0,2,208,0,0,2,208,0,0,2,208,0,0,1,128,
  // 0xd569  합
  105,213,16,19,76,17,1,254,0,96,0,0,0,240,2,208,170,250,162,208,255,255,242,208,0,80,2,208,15,255,2,255,62,7,194,249,60,2,194,208,60,3,194,208,47,175,130,208,7,253,2,208,0,0,0,0,11,64,2,208,11,170,171,208,11,255,255,208,11,64,2,208,11,64,2,208,11,255,255,208,6,170,170,128,
  // 0xd648  홈
  72,214,16,19,76,17,1,254,0,2,64,0,0,7,128,0,127,255,255,248,42,170,170,164,0,5,64,0,2,255,255,64,15,128,7,192,15,128,7,192,2,255,255,64,0,7,192,0,170,171,234,168,255,255,255,253,0,0,0,0,15,255,255,224,15,85,86,224,14,0,1,224,14,0,1,224,15,255,255,224,5,85,85,80,
  // 0xd654  화
  84,214,16,19,76,17,1,254,0,80,1,128,0,240,2,208,170,250,162,208,255,255,242,208,0,0,2,208,0,84,2,208,15,255,66,208,46,7,194,208,60,2,194,255,61,3,194,250,31,159,130,208,7,254,2,208,0,240,2,208,0,245,86,208,255,255,250,208,170,149,2,208,0,0,2,208,0,0,2,208,0,0,1,144,
  // 0xd788  히
  136,215,14,19,76,17,1,254,0,0,0,80,0,180,0,240,0,180,0,240,106,254,164,240,191,255,248,240,0,0,0,240,0,100,0,240,7,255,64,240,31,7,192,240,45,1,224,240,60,0,224,240,45,1,224,240,31,7,192,240,11,255,64,240,0,100,0,240,0,0,0,240,0,0,0,240,0,0,0,240,0,0,0,160,
};

#endif // HAS_GRAPHICAL_TFT
