/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == NOTOSANS

// NotoSans Medium Greek 19pt, capital 'A' height: 14px, width: 100%, range: 0x0386-0x03ce, glyphs: 63
extern const uint8_t NotoSans_Medium_Greek_14[3253] = {
  130,14,134,3,206,3,18,251, // unifont_t
  // 0x0386  Ά
  14,14,56,14,0,0,45,6,128,0,124,11,192,0,176,15,224,0,80,29,240,0,0,60,180,0,0,120,56,0,0,180,60,0,0,240,45,0,1,250,191,0,3,255,255,0,3,192,11,128,11,128,3,192,15,0,3,208,31,0,1,224,
  // 0x0387  ·
  255,
  // 0x0388  Έ
  13,14,56,14,0,0,45,26,170,128,124,47,255,192,176,45,0,0,80,45,0,0,0,45,0,0,0,45,0,0,0,47,255,128,0,47,255,64,0,45,0,0,0,45,0,0,0,45,0,0,0,45,0,0,0,47,255,128,0,47,255,192,
  // 0x0389  Ή
  16,14,56,18,0,0,45,24,0,9,124,45,0,15,176,45,0,15,80,45,0,15,0,45,0,15,0,45,0,15,0,47,255,255,0,47,255,255,0,45,0,15,0,45,0,15,0,45,0,15,0,45,0,15,0,45,0,15,0,45,0,15,
  // 0x038a  Ί
  10,14,42,11,0,0,45,42,144,124,127,224,176,15,64,80,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,15,0,0,31,128,0,127,240,
  // 0x038b  ΋
  255,
  // 0x038c  Ό
  17,15,75,17,0,255,45,1,170,64,0,124,15,255,240,0,176,62,0,188,0,80,188,0,62,0,0,244,0,31,0,0,240,0,15,0,1,240,0,15,0,1,240,0,15,64,0,240,0,15,0,0,240,0,15,0,0,248,0,46,0,0,125,0,124,0,0,47,235,244,0,0,7,255,144,0,0,0,0,0,0,
  // 0x038d  ΍
  255,
  // 0x038e  Ύ
  15,14,56,15,0,0,45,36,0,24,124,60,0,124,176,30,0,244,80,15,1,240,0,7,195,208,0,3,215,128,0,1,255,0,0,0,254,0,0,0,124,0,0,0,60,0,0,0,60,0,0,0,60,0,0,0,60,0,0,0,60,0,
  // 0x038f  Ώ
  16,14,56,17,0,0,45,1,186,0,124,31,255,224,176,126,1,248,80,244,0,60,1,240,0,46,2,224,0,31,2,224,0,15,2,224,0,31,1,224,0,30,0,240,0,61,0,184,0,124,0,45,1,240,2,255,67,255,3,255,67,255,
  // 0x0390  ΐ
  255,
  // 0x0391  Α
  12,14,42,12,0,0,0,40,0,0,126,0,0,191,0,0,247,64,1,227,192,3,195,192,3,193,224,11,64,240,15,234,244,31,255,248,45,0,60,60,0,45,120,0,31,244,0,15,
  // 0x0392  Β
  10,14,42,12,2,0,170,144,0,255,255,0,240,31,192,240,3,192,240,3,192,240,11,128,255,253,0,255,255,64,240,7,192,240,3,208,240,3,208,240,7,192,250,191,128,255,253,0,
  // 0x0393  Γ
  7,14,28,10,2,0,170,168,255,252,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,240,0,
  // 0x0394  Δ
  12,14,42,12,0,0,0,40,0,0,126,0,0,191,0,0,247,64,2,211,192,3,194,192,7,129,224,11,64,240,15,0,180,30,0,60,60,0,60,124,0,46,191,255,255,255,255,255,
  // 0x0395  Ε
  8,14,28,11,2,0,170,168,255,253,240,0,240,0,240,0,240,0,255,252,255,252,240,0,240,0,240,0,240,0,255,253,255,253,
  // 0x0396  Ζ
  10,14,42,11,0,0,42,170,160,63,255,240,0,2,224,0,7,192,0,15,64,0,46,0,0,124,0,0,244,0,2,224,0,7,192,0,15,64,0,46,0,0,127,255,240,127,255,240,
  // 0x0397  Η
  11,14,42,14,2,0,144,0,96,240,0,180,240,0,180,240,0,180,240,0,180,240,0,180,255,255,244,255,255,244,240,0,180,240,0,180,240,0,180,240,0,180,240,0,180,240,0,180,
  // 0x0398  Θ
  13,15,60,15,1,255,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,255,199,128,245,255,199,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x0399  Ι
  6,14,28,7,0,0,42,160,63,240,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,11,64,31,144,127,240,
  // 0x039a  Κ
  10,14,42,12,2,0,144,1,144,240,7,192,240,31,0,240,60,0,240,244,0,243,208,0,251,192,0,255,208,0,245,240,0,240,188,0,240,62,0,240,15,64,240,7,192,240,2,224,
  // 0x039b  Λ
  12,14,42,12,0,0,0,40,0,0,189,0,0,255,0,0,235,0,2,215,64,3,195,192,7,130,192,11,65,224,15,0,240,30,0,180,45,0,120,60,0,60,120,0,45,244,0,30,
  // 0x039c  Μ
  14,14,56,17,2,0,164,0,2,144,252,0,11,224,253,0,15,224,239,0,30,224,235,0,61,224,231,128,57,224,227,192,177,224,226,208,241,224,224,225,209,224,224,242,193,224,224,183,193,224,224,63,65,224,224,63,1,224,224,30,1,224,
  // 0x039d  Ν
  11,14,42,15,2,0,164,0,40,252,0,60,254,0,60,239,0,60,231,192,60,227,208,60,224,240,60,224,184,60,224,61,60,224,31,60,224,11,188,224,3,252,224,1,252,224,0,252,
  // 0x039e  Ξ
  10,14,42,12,1,0,106,170,128,127,255,208,0,0,0,0,0,0,0,0,0,0,0,0,47,255,128,47,255,64,0,0,0,0,0,0,0,0,0,0,0,0,191,255,224,255,255,224,
  // 0x039f  Ο
  13,15,60,15,1,255,0,174,64,0,11,255,244,0,47,64,125,0,61,0,31,0,120,0,15,64,180,0,11,128,244,0,7,128,244,0,7,128,180,0,7,128,184,0,11,128,124,0,15,0,62,0,62,0,15,234,252,0,2,255,224,0,0,0,0,0,
  // 0x03a0  Π
  10,14,42,14,2,0,170,170,160,255,255,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,240,0,240,
  // 0x03a1  Ρ
  9,14,42,12,2,0,170,144,0,255,253,0,240,111,0,240,11,128,240,7,128,240,11,128,240,31,0,255,253,0,255,160,0,240,0,0,240,0,0,240,0,0,240,0,0,240,0,0,
  // 0x03a2  ΢
  255,
  // 0x03a3  Σ
  10,14,42,11,0,0,42,170,160,63,255,240,63,0,0,15,128,0,3,208,0,0,244,0,0,124,0,0,124,0,0,240,0,3,192,0,15,64,0,46,0,0,127,255,240,127,255,240,
  // 0x03a4  Τ
  11,14,42,11,0,0,106,170,160,255,255,244,0,244,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,0,180,0,
  // 0x03a5  Υ
  11,14,42,11,0,0,96,0,40,124,0,180,61,0,240,31,2,208,15,71,192,7,207,64,2,239,0,0,252,0,0,184,0,0,120,0,0,120,0,0,120,0,0,120,0,0,120,0,
  // 0x03a6  Φ
  15,15,60,16,1,255,0,6,0,0,0,15,64,0,7,255,254,0,63,159,175,192,124,15,2,240,240,15,0,240,240,15,0,180,240,15,0,180,244,15,0,240,124,15,2,240,47,159,111,192,7,255,254,0,0,15,64,0,0,15,0,0,0,0,0,0,
  // 0x03a7  Χ
  11,14,42,12,0,0,100,0,40,61,0,184,31,1,240,11,131,192,3,199,128,1,255,0,0,189,0,0,253,0,1,239,0,3,203,128,11,67,208,31,1,240,60,0,184,184,0,60,
  // 0x03a8  Ψ
  13,14,56,16,1,0,36,10,1,128,120,15,3,192,120,15,3,192,120,15,3,192,120,15,3,192,124,15,3,192,60,15,3,192,61,15,7,192,31,159,111,0,7,255,253,0,0,95,64,0,0,15,0,0,0,15,0,0,0,15,0,0,
  // 0x03a9  Ω
  14,14,56,14,0,0,0,106,144,0,3,255,252,0,15,128,127,0,46,0,15,128,60,0,7,192,60,0,3,192,124,0,3,192,124,0,3,192,60,0,3,192,61,0,7,128,15,0,15,0,7,128,61,0,127,224,255,208,127,240,255,208,
  // 0x03aa  Ϊ
  255,
  // 0x03ab  Ϋ
  255,
  // 0x03ac  ά
  11,16,48,12,1,255,0,60,0,0,120,0,0,176,0,0,80,0,1,64,0,31,250,192,62,95,192,184,3,192,240,3,192,240,3,192,240,3,192,240,3,192,184,7,192,62,111,228,15,244,248,0,0,0,
  // 0x03ad  έ
  8,16,32,9,1,255,0,120,0,240,0,224,0,64,1,80,63,253,184,24,240,0,120,0,47,224,126,80,240,0,240,0,254,109,47,252,0,0,
  // 0x03ae  ή
  10,20,60,12,1,251,0,180,0,0,240,0,1,208,0,1,64,0,0,20,0,119,255,64,127,91,192,124,3,192,120,3,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,0,2,208,0,2,208,0,2,208,0,2,208,0,1,128,
  // 0x03af  ί
  5,16,32,7,1,255,11,0,31,0,44,0,20,0,0,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,62,128,31,192,0,0,
  // 0x03b0  ΰ
  255,
  // 0x03b1  α
  11,12,36,12,1,255,1,64,0,31,250,192,62,95,192,184,3,192,240,3,192,240,3,192,240,3,192,240,3,192,184,7,192,62,111,228,15,244,248,0,0,0,
  // 0x03b2  β
  10,20,60,12,1,251,1,84,0,15,255,0,62,11,192,60,3,192,120,3,192,120,3,192,120,95,0,120,253,0,120,11,192,120,2,208,120,1,224,120,1,224,120,2,224,127,175,192,127,254,0,120,0,0,120,0,0,120,0,0,120,0,0,36,0,0,
  // 0x03b3  γ
  10,14,42,10,0,252,180,2,208,120,2,208,60,2,208,45,3,192,30,3,192,15,7,128,11,79,0,7,174,0,3,252,0,2,240,0,1,224,0,1,224,0,1,224,0,1,224,0,
  // 0x03b4  δ
  10,16,48,11,1,255,0,100,0,11,255,128,31,7,64,45,0,0,31,0,0,11,224,0,11,252,0,62,31,64,180,7,192,240,3,192,240,2,208,240,3,192,244,7,192,126,111,64,15,253,0,0,0,0,
  // 0x03b5  ε
  8,12,24,9,1,255,1,80,63,253,184,24,240,0,120,0,47,224,126,80,240,0,240,0,254,109,47,252,0,0,
  // 0x03b6  ζ
  8,19,38,9,1,252,21,85,127,255,0,61,0,184,1,224,3,192,15,64,46,0,60,0,180,0,240,0,240,0,248,0,127,144,11,252,0,110,0,30,0,29,0,44,
  // 0x03b7  η
  10,16,48,12,1,251,0,20,0,119,255,64,127,91,192,124,3,192,120,3,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,0,2,208,0,2,208,0,2,208,0,2,208,0,1,128,
  // 0x03b8  θ
  10,16,48,11,1,255,1,80,0,15,253,0,61,31,64,120,7,128,180,3,192,240,3,192,240,2,208,255,255,208,245,87,208,240,2,208,240,3,192,180,3,192,60,7,128,46,111,0,11,252,0,0,0,0,
  // 0x03b9  ι
  5,11,22,7,1,255,120,0,120,0,120,0,120,0,120,0,120,0,120,0,120,0,62,128,31,192,0,0,
  // 0x03ba  κ
  9,10,30,11,1,0,120,11,128,120,46,0,120,124,0,121,240,0,123,208,0,127,240,0,124,124,0,120,46,0,120,15,64,120,3,192,
  // 0x03bb  λ
  10,16,48,10,0,255,100,0,0,255,0,0,7,192,0,2,208,0,1,240,0,1,240,0,3,248,0,3,188,0,11,109,0,15,30,0,14,15,0,45,11,64,60,7,192,124,3,224,180,1,240,0,0,0,
  // 0x03bc  μ
  11,15,45,12,1,251,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,2,208,120,3,208,124,7,208,127,175,244,123,248,248,120,0,0,120,0,0,120,0,0,120,0,0,36,0,0,
  // 0x03bd  ν
  10,10,30,10,0,0,180,2,208,120,2,208,60,2,208,45,3,192,30,3,192,15,7,128,11,79,0,7,174,0,3,252,0,2,240,0,
  // 0x03be  ξ
  8,19,38,10,1,252,21,85,127,255,11,64,60,0,120,0,124,0,47,84,11,254,62,64,180,0,240,0,240,0,248,0,127,144,11,253,0,110,0,14,0,30,0,44,
  // 0x03bf  ο
  10,12,36,12,1,255,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x03c0  π
  13,11,44,13,0,255,191,255,255,64,27,149,185,0,11,64,180,0,11,64,180,0,11,64,180,0,11,64,180,0,11,64,180,0,11,64,180,0,11,64,125,0,11,64,63,0,0,0,0,0,
  // 0x03c1  ρ
  10,16,48,12,1,251,1,80,0,15,254,0,62,95,128,124,3,192,180,2,208,180,2,208,180,2,208,180,3,208,180,3,192,190,175,64,187,253,0,180,0,0,180,0,0,180,0,0,180,0,0,96,0,0,
  // 0x03c2  ς
  8,15,30,9,1,252,1,80,15,254,62,88,184,0,240,0,240,0,240,0,244,0,188,0,63,144,11,252,0,126,0,30,0,29,0,44,
  // 0x03c3  σ
  10,11,33,12,1,255,11,255,240,63,95,80,184,3,192,240,3,192,240,2,208,240,2,208,240,3,192,184,7,192,63,175,64,11,253,0,0,0,0,
  // 0x03c4  τ
  9,11,33,10,0,255,191,255,192,23,213,64,3,192,0,3,192,0,3,192,0,3,192,0,3,192,0,3,192,0,2,245,0,0,255,64,0,0,0,
  // 0x03c5  υ
  10,11,33,12,1,255,184,3,192,184,3,192,184,3,192,184,3,208,184,2,208,184,3,192,120,3,192,124,7,192,62,111,64,15,253,0,0,0,0,
  // 0x03c6  φ
  13,20,80,14,1,251,0,20,0,0,0,60,0,0,0,60,0,0,0,60,0,0,0,125,0,0,11,255,224,0,63,125,188,0,188,60,47,0,244,60,15,0,240,60,15,64,240,60,15,0,244,60,15,0,124,60,46,0,47,190,252,0,7,255,224,0,0,60,0,0,0,60,0,0,0,60,0,0,0,60,0,0,0,24,0,0,
  // 0x03c7  χ
  12,16,48,11,0,251,16,0,0,189,0,60,31,0,180,11,64,240,3,195,192,2,215,128,0,255,0,0,189,0,0,124,0,0,253,0,2,239,0,3,203,64,15,3,192,30,2,224,60,0,253,100,0,40,
  // 0x03c8  ψ
  13,20,80,15,1,251,0,20,0,0,0,45,0,0,0,45,0,0,0,45,0,0,0,45,0,0,180,45,15,0,180,45,15,0,180,45,11,64,180,45,11,64,180,45,11,64,116,45,11,64,120,45,15,0,60,45,31,0,47,190,252,0,7,255,224,0,0,45,0,0,0,45,0,0,0,45,0,0,0,45,0,0,0,24,0,0,
  // 0x03c9  ω
  14,11,44,16,1,255,45,0,15,0,60,0,3,128,116,0,3,192,180,14,2,208,240,14,2,208,240,14,2,208,180,15,2,208,120,31,3,192,62,187,223,128,15,241,254,0,0,0,0,0,
  // 0x03ca  ϊ
  255,
  // 0x03cb  ϋ
  255,
  // 0x03cc  ό
  10,16,48,12,1,255,0,45,0,0,60,0,0,116,0,0,80,0,1,80,0,31,254,0,62,95,128,184,3,192,240,2,208,240,2,224,240,2,224,244,2,208,120,3,192,63,175,128,11,253,0,0,0,0,
  // 0x03cd  ύ
  10,16,48,12,1,255,0,56,0,0,120,0,0,240,0,0,64,0,0,0,0,184,3,192,184,3,192,184,3,192,184,3,208,184,2,208,184,3,192,120,3,192,124,7,192,62,111,64,15,253,0,0,0,0,
  // 0x03ce  ώ
  14,16,64,16,1,255,0,2,208,0,0,3,192,0,0,7,64,0,0,5,0,0,0,0,0,0,45,0,15,0,60,0,3,128,116,0,3,192,180,14,2,208,240,14,2,208,240,14,2,208,180,15,2,208,120,31,3,192,62,187,223,128,15,241,254,0,0,0,0,0,
};

#endif // HAS_GRAPHICAL_TFT
