/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

/**
 * Fontname: -Adobe-Helvetica-Medium-R-Normal--25-180-100-100-P-130-ISO10646-1
 * Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
 * Capital A Height: 19, '1' Height: 18
 * Calculated Max Values w=22 h=24 x= 3 y=16 dx=25 dy= 0 ascent=24 len=69
 * Font Bounding box     w=28 h=37 x=-3 y=-8
 * Calculated Min Values           x=-1 y=-5 dx= 0 dy= 0
 * Pure Font   ascent =19 descent=-5
 * X Font      ascent =19 descent=-5
 * Max Font    ascent =24 descent=-5
 */

#include "../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == HELVETICA

// Helvetica Symbols, capital 'A' height: 19px
extern const uint8_t Helvetica_Symbols_19[45] = {
  129,19,8,0,9,0,24,251, // unifont_t
  // 0x08 - LCD_STR_THERMOMETER a.k.a 0x1f321  🌡
  7,18,18,8,0,1,0,56,68,68,68,68,68,84,84,84,84,84,214,186,186,186,198,124,
  // 0x09 - LCD_STR_DEGREE a.k.a 0x00b0  °
  8,7,7,9,0,11,60,102,195,195,195,102,60,
};

// Helvetica, capital 'A' height: 19px
extern const uint8_t Helvetica_19[7298] = {
  129,19,32,0,255,0,24,251, // unifont_t
  // 0x0020 " "
  0,0,0,6,0,1,
  // 0x0021  !
  2,19,19,6,2,0,192,192,192,192,192,192,192,192,192,192,192,192,128,128,0,0,192,192,192,
  // 0x0022  "
  6,6,6,8,1,13,204,204,204,204,204,68,
  // 0x0023  #
  11,17,34,14,2,0,12,192,12,192,12,192,25,128,255,224,255,224,25,128,25,128,51,0,51,0,255,224,255,224,51,0,51,0,102,0,102,0,102,0,
  // 0x0024  $
  11,22,44,13,1,254,6,0,6,0,31,128,63,192,118,224,102,96,102,96,102,0,118,0,62,0,62,0,15,128,7,192,6,224,6,96,198,96,198,96,230,224,127,192,63,128,6,0,6,0,
  // 0x0025  %
  19,18,54,22,1,0,0,6,0,60,12,0,126,12,0,195,24,0,195,24,0,195,48,0,195,48,0,126,96,0,60,96,0,0,192,0,0,199,128,1,143,192,1,152,96,3,24,96,3,24,96,6,24,96,6,15,192,4,7,128,
  // 0x0026  &
  14,18,36,17,2,0,15,0,31,128,57,192,48,192,48,192,48,192,25,128,15,0,30,0,63,24,115,152,97,216,192,240,192,96,192,240,225,216,127,156,30,0,
  // 0x0027  '
  2,6,6,6,2,13,192,192,192,192,192,64,
  // 0x0028  (
  5,24,24,8,2,251,24,24,48,48,96,96,96,192,192,192,192,192,192,192,192,192,192,96,96,96,48,48,24,24,
  // 0x0029  )
  5,24,24,8,1,251,192,192,96,96,48,48,48,24,24,24,24,24,24,24,24,24,24,48,48,48,96,96,192,192,
  // 0x002a  *
  7,7,7,10,1,12,16,16,214,124,56,108,68,
  // 0x002b  +
  12,12,24,14,1,1,6,0,6,0,6,0,6,0,6,0,255,240,255,240,6,0,6,0,6,0,6,0,6,0,
  // 0x002c  ,
  2,6,6,6,2,253,192,192,192,64,64,128,
  // 0x002d  -
  6,2,2,8,1,6,252,252,
  // 0x002e  .
  2,3,3,6,2,0,192,192,192,
  // 0x002f  /
  7,19,19,7,0,0,6,4,12,12,8,24,24,16,16,48,48,32,96,96,64,192,192,128,128,
  // 0x0030  0
  11,18,36,13,1,0,31,0,63,128,113,192,96,192,96,192,224,224,192,96,192,96,192,96,192,96,192,96,192,96,224,224,96,192,96,192,113,192,63,128,31,0,
  // 0x0031  1
  6,18,18,13,2,0,12,12,28,252,252,12,12,12,12,12,12,12,12,12,12,12,12,12,
  // 0x0032  2
  11,18,36,13,1,0,30,0,127,128,97,192,192,192,192,96,192,96,0,224,0,192,1,192,3,128,15,0,28,0,56,0,112,0,224,0,192,0,255,224,255,224,
  // 0x0033  3
  11,18,36,13,1,0,31,0,127,128,97,128,192,192,192,192,192,192,0,192,1,128,15,0,15,192,0,192,0,96,0,96,192,96,192,192,97,192,127,128,31,0,
  // 0x0034  4
  11,18,36,13,1,0,1,128,3,128,3,128,7,128,15,128,13,128,25,128,57,128,49,128,97,128,225,128,193,128,255,224,255,224,1,128,1,128,1,128,1,128,
  // 0x0035  5
  11,18,36,13,1,0,127,192,127,192,96,0,96,0,96,0,96,0,126,0,127,128,113,192,0,192,0,224,0,96,0,96,192,224,192,192,225,192,127,128,30,0,
  // 0x0036  6
  11,18,36,13,1,0,15,0,63,192,112,192,96,96,224,96,192,0,192,0,207,0,223,128,241,192,224,192,192,96,192,96,192,96,224,224,113,192,127,192,31,0,
  // 0x0037  7
  11,18,36,13,1,0,255,224,255,224,0,224,0,192,1,128,1,128,3,0,3,0,6,0,6,0,12,0,12,0,28,0,24,0,24,0,56,0,48,0,48,0,
  // 0x0038  8
  11,18,36,13,1,0,14,0,63,128,49,128,96,192,96,192,96,192,49,128,31,0,63,128,113,192,96,192,192,96,192,96,192,96,192,96,96,192,127,192,31,0,
  // 0x0039  9
  11,18,36,13,1,0,31,0,127,192,113,192,224,192,192,96,192,96,192,96,192,96,224,224,113,224,127,96,30,96,0,96,0,224,192,192,225,192,127,128,30,0,
  // 0x003a  :
  2,14,14,6,2,0,192,192,192,0,0,0,0,0,0,0,0,192,192,192,
  // 0x003b  ;
  2,17,17,6,2,253,192,192,192,0,0,0,0,0,0,0,0,192,192,192,64,64,128,
  // 0x003c  <
  12,12,24,15,1,1,0,48,0,240,3,192,15,0,60,0,224,0,224,0,60,0,15,0,3,192,0,240,0,48,
  // 0x003d  =
  10,5,10,15,2,5,255,192,255,192,0,0,255,192,255,192,
  // 0x003e  >
  12,12,24,15,1,1,192,0,240,0,60,0,15,0,3,192,0,112,0,112,3,192,15,0,60,0,240,0,192,0,
  // 0x003f  ?
  10,19,38,12,1,0,31,0,127,128,113,192,224,192,192,192,193,192,1,128,3,128,7,0,6,0,12,0,12,0,12,0,12,0,0,0,0,0,12,0,12,0,12,0,
  // 0x0040  @
  22,23,69,25,2,252,0,255,0,3,255,192,15,1,224,28,0,112,56,0,24,48,0,24,96,115,12,96,251,12,193,199,12,195,134,12,195,6,12,198,6,12,198,12,28,198,12,24,198,12,56,231,28,112,99,247,224,113,227,128,56,0,0,28,0,0,15,3,0,7,255,0,0,252,0,
  // 0x0041  A
  15,19,38,17,1,0,3,128,3,128,6,192,6,192,12,64,12,96,12,96,24,48,24,48,24,48,48,24,63,248,63,248,96,12,96,12,96,12,192,6,192,6,192,6,
  // 0x0042  B
  14,19,38,17,2,0,255,192,255,240,192,112,192,24,192,24,192,24,192,24,192,48,255,224,255,240,192,24,192,12,192,12,192,12,192,12,192,28,192,120,255,240,255,192,
  // 0x0043  C
  15,19,38,18,1,0,7,224,31,248,60,60,112,14,96,6,224,6,192,0,192,0,192,0,192,0,192,0,192,0,192,0,224,6,96,6,112,14,60,60,31,248,7,224,
  // 0x0044  D
  15,19,38,18,2,0,255,192,255,240,192,120,192,28,192,12,192,14,192,6,192,6,192,6,192,6,192,6,192,6,192,6,192,14,192,12,192,28,192,120,255,240,255,192,
  // 0x0045  E
  12,19,38,16,2,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,224,255,224,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x0046  F
  11,19,38,14,2,0,255,224,255,224,192,0,192,0,192,0,192,0,192,0,192,0,255,192,255,192,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0047  G
  16,19,38,19,1,0,7,224,31,248,60,60,112,14,96,6,224,6,192,0,192,0,192,0,192,127,192,127,192,3,192,3,224,3,96,7,112,15,60,63,31,251,7,227,
  // 0x0048  H
  14,19,38,18,2,0,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,255,252,255,252,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,
  // 0x0049  I
  2,19,19,8,3,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x004a  J
  10,19,38,13,1,0,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,192,192,192,192,192,192,192,192,97,128,127,128,63,0,
  // 0x004b  K
  13,19,38,18,3,0,192,56,192,112,192,224,193,192,195,128,199,0,206,0,220,0,252,0,254,0,231,0,195,128,193,128,193,192,192,224,192,96,192,112,192,56,192,24,
  // 0x004c  L
  11,19,38,14,2,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,224,255,224,
  // 0x004d  M
  17,19,57,21,2,0,192,1,128,224,3,128,224,3,128,240,7,128,240,7,128,216,13,128,216,13,128,216,13,128,204,25,128,204,25,128,204,25,128,198,49,128,198,49,128,198,49,128,195,97,128,195,97,128,195,97,128,193,193,128,193,193,128,
  // 0x004e  N
  14,19,38,18,2,0,224,12,240,12,240,12,216,12,220,12,204,12,206,12,198,12,199,12,195,12,195,140,193,140,193,204,192,204,192,236,192,108,192,60,192,60,192,28,
  // 0x004f  O
  16,19,38,18,1,0,7,224,31,248,60,60,112,14,96,6,224,7,192,3,192,3,192,3,192,3,192,3,192,3,192,3,224,7,96,6,112,14,60,60,31,248,7,224,
  // 0x0050  P
  13,19,38,16,2,0,255,224,255,240,192,48,192,24,192,24,192,24,192,24,192,48,255,240,255,224,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0051  Q
  16,19,38,18,1,0,7,224,31,248,60,60,112,14,96,6,224,7,192,3,192,3,192,3,192,3,192,3,192,3,192,3,224,7,96,230,112,126,60,28,31,254,7,231,
  // 0x0052  R
  13,19,38,17,2,0,255,224,255,240,192,48,192,24,192,24,192,24,192,24,192,48,255,240,255,224,192,112,192,48,192,24,192,24,192,24,192,24,192,24,192,24,192,24,
  // 0x0053  S
  13,19,38,16,2,0,15,128,63,224,96,96,192,48,192,48,192,0,224,0,124,0,63,128,7,224,0,240,0,56,0,24,0,24,192,24,192,56,240,112,127,224,31,128,
  // 0x0054  T
  14,19,38,16,1,0,255,252,255,252,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x0055  U
  14,19,38,18,2,0,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,96,24,112,56,63,240,15,192,
  // 0x0056  V
  15,19,38,17,1,0,192,6,192,6,224,14,96,12,112,28,48,24,48,24,56,56,24,48,24,48,28,112,12,96,12,96,14,224,6,192,6,192,3,128,3,128,3,128,
  // 0x0057  W
  20,19,57,22,1,0,192,96,48,192,96,48,192,96,48,192,240,48,96,240,96,97,152,96,97,152,96,97,152,96,97,152,96,49,152,192,51,12,192,51,12,192,51,12,192,27,13,128,27,13,128,30,7,128,14,7,0,12,3,0,12,3,0,
  // 0x0058  X
  15,19,38,17,1,0,192,6,224,14,112,28,48,24,24,48,28,112,14,224,7,192,3,128,3,128,7,192,14,224,12,96,28,112,56,56,48,24,96,12,224,14,192,6,
  // 0x0059  Y
  14,19,38,16,1,0,192,12,224,28,96,24,112,56,48,48,56,112,24,96,28,224,12,192,15,192,7,128,7,128,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x005a  Z
  13,19,38,15,1,0,255,248,255,248,0,56,0,112,0,224,1,192,1,192,3,128,7,0,7,0,14,0,28,0,28,0,56,0,112,0,112,0,224,0,255,248,255,248,
  // 0x005b  [
  4,24,24,7,2,251,240,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,240,240,
  // 0x005c "\"
  8,19,19,7,0,0,192,64,64,96,32,32,48,16,16,16,24,8,8,12,4,4,6,2,3,
  // 0x005d  ]
  4,24,24,7,1,251,240,240,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,240,240,
  // 0x005e  ^
  10,9,18,12,1,10,12,0,12,0,30,0,18,0,51,0,97,128,97,128,192,192,192,192,
  // 0x005f  _
  14,2,4,14,0,251,255,252,255,252,
  // 0x0060  `
  5,4,4,7,1,15,192,96,48,24,
  // 0x0061  a
  11,14,28,13,1,0,31,0,63,128,97,192,96,192,0,192,7,192,63,192,120,192,224,192,192,192,193,192,227,192,126,224,60,96,
  // 0x0062  b
  11,19,38,14,2,0,192,0,192,0,192,0,192,0,192,0,207,0,223,128,241,192,224,192,192,224,192,96,192,96,192,96,192,96,192,224,224,192,241,192,223,128,207,0,
  // 0x0063  c
  10,14,28,12,1,0,31,0,63,128,113,192,96,192,224,0,192,0,192,0,192,0,192,0,224,0,96,192,113,192,63,128,31,0,
  // 0x0064  d
  11,19,38,14,1,0,0,96,0,96,0,96,0,96,0,96,30,96,63,96,113,224,96,224,224,96,192,96,192,96,192,96,192,96,224,96,96,224,113,224,63,96,30,96,
  // 0x0065  e
  11,14,28,13,1,0,14,0,63,128,113,192,96,192,192,96,192,96,255,224,255,224,192,0,192,0,96,96,112,224,63,192,15,0,
  // 0x0066  f
  6,19,19,8,1,0,28,60,48,48,48,252,252,48,48,48,48,48,48,48,48,48,48,48,48,
  // 0x0067  g
  11,19,38,14,1,251,30,96,63,96,113,224,96,224,224,96,192,96,192,96,192,96,192,96,224,96,96,224,113,224,63,96,30,96,0,96,192,96,224,192,127,192,31,0,
  // 0x0068  h
  10,19,38,13,2,0,192,0,192,0,192,0,192,0,192,0,206,0,223,128,241,128,224,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x0069  i
  2,19,19,6,2,0,192,192,192,0,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x006a  j
  4,24,24,6,0,251,48,48,48,0,0,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,240,224,
  // 0x006b  k
  10,19,38,12,2,0,192,0,192,0,192,0,192,0,192,0,193,128,195,128,199,0,206,0,220,0,248,0,252,0,206,0,198,0,199,0,195,128,193,128,193,192,192,192,
  // 0x006c  l
  2,19,19,6,2,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x006d  m
  16,14,28,20,2,0,206,60,255,126,227,199,193,131,193,131,193,131,193,131,193,131,193,131,193,131,193,131,193,131,193,131,193,131,
  // 0x006e  n
  10,14,28,14,2,0,206,0,223,128,241,128,224,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x006f  o
  11,14,28,13,1,0,31,0,63,128,113,192,96,192,224,224,192,96,192,96,192,96,192,96,224,224,96,192,113,192,63,128,31,0,
  // 0x0070  p
  11,19,38,14,2,251,207,0,223,128,241,192,224,192,192,224,192,96,192,96,192,96,192,96,192,224,224,192,241,192,223,128,207,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0071  q
  11,19,38,14,1,251,30,96,63,96,113,224,96,224,224,96,192,96,192,96,192,96,192,96,224,96,96,224,113,224,63,96,30,96,0,96,0,96,0,96,0,96,0,96,
  // 0x0072  r
  6,14,14,9,2,0,204,220,248,240,224,192,192,192,192,192,192,192,192,192,
  // 0x0073  s
  10,14,28,12,1,0,63,0,127,128,225,192,192,192,192,0,248,0,127,0,15,128,1,192,192,192,192,192,225,192,127,128,63,0,
  // 0x0074  t
  6,18,18,8,1,0,48,48,48,48,252,252,48,48,48,48,48,48,48,48,48,48,60,28,
  // 0x0075  u
  10,14,28,14,2,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,192,99,192,126,192,28,192,
  // 0x0076  v
  11,14,28,13,1,0,192,96,192,96,192,96,96,192,96,192,113,192,49,128,49,128,27,0,27,0,27,0,14,0,14,0,14,0,
  // 0x0077  w
  18,14,42,18,0,0,192,192,192,192,192,192,97,225,128,97,225,128,97,225,128,49,35,0,51,51,0,51,51,0,27,54,0,26,22,0,30,30,0,14,28,0,12,12,0,12,12,0,
  // 0x0078  x
  10,14,28,12,1,0,192,192,225,192,97,128,51,0,30,0,30,0,12,0,30,0,30,0,51,0,115,128,97,128,192,192,192,192,
  // 0x0079  y
  12,19,38,13,0,251,192,48,192,48,96,48,112,96,48,96,56,224,24,192,24,192,13,128,13,128,7,128,7,0,3,0,3,0,6,0,6,0,12,0,60,0,56,0,
  // 0x007a  z
  10,14,28,12,1,0,255,192,255,192,1,128,3,0,7,0,14,0,12,0,28,0,56,0,48,0,96,0,224,0,255,192,255,192,
  // 0x007b  {
  6,24,24,8,1,251,12,24,48,48,48,48,48,48,48,48,96,192,192,96,48,48,48,48,48,48,48,48,24,12,
  // 0x007c  |
  1,24,24,6,2,251,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,
  // 0x007d  }
  6,24,24,8,1,251,192,96,48,48,48,48,48,48,48,48,24,12,12,24,48,48,48,48,48,48,48,48,96,192,
  // 0x007e  ~
  10,4,8,14,2,5,112,192,252,192,207,192,195,128,
    // 0x007f - 0x009a  Control Characters
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00a0   
  0,0,0,6,0,1,
  // 0x00a1  ¡
  2,19,19,6,2,251,192,192,192,0,0,64,64,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x00a2  ¢
  10,18,36,13,1,254,1,128,1,128,31,0,63,128,115,192,102,192,198,0,204,0,204,0,204,0,216,0,216,0,216,192,113,192,127,128,63,0,96,0,96,0,
  // 0x00a3  £
  12,18,36,14,1,0,31,128,63,224,112,112,96,48,96,0,112,0,48,0,24,0,255,128,255,128,24,0,24,0,24,0,48,0,48,0,103,48,255,240,240,224,
  // 0x00a4  ¤
  11,12,24,13,1,3,192,96,238,224,127,192,49,128,96,192,96,192,96,192,96,192,49,128,127,192,238,224,192,96,
  // 0x00a5  ¥
  14,18,36,14,0,0,224,28,96,24,112,56,48,48,56,112,24,96,28,224,12,192,63,240,63,240,3,0,63,240,63,240,3,0,3,0,3,0,3,0,3,0,
  // 0x00a6  ¦
  2,24,24,6,2,251,192,192,192,192,192,192,192,192,192,192,0,0,0,0,192,192,192,192,192,192,192,192,192,192,
  // 0x00a7  §
  11,24,48,13,1,251,31,0,63,128,113,192,96,192,112,192,56,0,28,0,126,0,231,0,195,128,193,192,192,192,96,96,112,96,56,96,28,192,15,128,7,0,3,128,97,192,96,192,113,192,63,128,31,0,
  // 0x00a8  ¨
  6,2,2,8,1,16,204,204,
  // 0x00a9  ©
  19,19,57,19,1,0,3,248,0,14,14,0,48,1,128,96,0,192,65,240,64,195,24,96,134,12,32,132,0,32,132,0,32,132,0,32,132,0,32,134,12,32,195,24,96,65,240,64,96,0,192,48,1,128,24,3,0,14,14,0,3,248,0,
  // 0x00aa  ª
  7,12,12,9,1,7,120,204,204,28,108,204,204,220,118,0,254,254,
  // 0x00ab  «
  9,8,16,14,2,3,25,128,51,0,102,0,204,0,204,0,102,0,51,0,25,128,
  // 0x00ac  ¬
  13,8,16,15,1,2,255,248,255,248,0,24,0,24,0,24,0,24,0,24,0,24,
  // 0x00ad  ­
  6,2,2,8,1,6,252,252,
  // 0x00ae  ®
  18,19,57,19,1,0,7,248,0,28,14,0,48,3,0,96,1,128,67,240,128,194,24,192,130,8,64,130,8,64,130,8,64,130,16,64,131,240,64,130,32,64,130,16,64,194,16,192,66,8,128,96,1,128,48,3,0,28,14,0,7,248,0,
  // 0x00af  ¯
  6,2,2,8,1,16,252,252,
  // 0x00b0  °
  8,7,7,9,0,11,60,102,195,195,195,102,60,
  // 0x00b1  ±
  12,13,26,14,1,0,6,0,6,0,6,0,6,0,255,240,255,240,6,0,6,0,6,0,6,0,0,0,255,240,255,240,
  // 0x00b2  ²
  7,10,10,7,0,8,60,126,198,6,12,24,48,96,254,254,
  // 0x00b3  ³
  7,10,10,7,0,8,124,254,198,6,60,60,6,198,254,124,
  // 0x00b4  ´
  5,4,4,7,1,15,24,48,96,192,
  // 0x00b5  µ
  10,19,38,14,2,251,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,192,227,192,254,192,220,192,192,0,192,0,192,0,192,0,192,0,
  // 0x00b6  ¶
  10,24,48,12,1,251,31,192,127,192,125,128,253,128,253,128,253,128,253,128,253,128,253,128,125,128,125,128,61,128,13,128,13,128,13,128,13,128,13,128,13,128,13,128,13,128,13,128,13,128,13,128,13,128,
  // 0x00b7  ·
  2,3,3,6,2,6,192,192,192,
  // 0x00b8  ¸
  5,6,6,7,1,251,96,112,24,24,248,112,
  // 0x00b9  ¹
  4,10,10,7,0,8,48,48,240,240,48,48,48,48,48,48,
  // 0x00ba  º
  7,12,12,9,1,7,56,108,198,198,198,198,198,108,56,0,254,254,
  // 0x00bb  »
  9,8,16,14,3,3,204,0,102,0,51,0,25,128,25,128,51,0,102,0,204,0,
  // 0x00bc  ¼
  18,18,54,19,1,0,48,24,0,48,24,0,240,48,0,240,48,0,48,96,0,48,96,0,48,192,0,48,192,0,49,131,0,49,135,0,3,15,0,3,15,0,6,27,0,6,51,0,12,127,192,12,127,192,24,3,0,24,3,0,
  // 0x00bd  ½
  18,18,54,19,1,0,48,24,0,48,24,0,240,48,0,240,48,0,48,96,0,48,96,0,48,192,0,48,192,0,49,135,128,49,143,192,3,24,192,3,0,192,6,1,128,6,3,0,12,6,0,12,12,0,24,31,192,24,31,192,
  // 0x00be  ¾
  19,18,54,19,0,0,124,12,0,254,12,0,198,24,0,6,24,0,60,48,0,60,48,0,6,96,0,198,96,0,254,193,128,124,195,128,1,135,128,1,135,128,3,13,128,3,25,128,6,63,224,6,63,224,12,1,128,12,1,128,
  // 0x00bf  ¿
  10,19,38,12,1,251,12,0,12,0,12,0,0,0,0,0,12,0,12,0,12,0,12,0,24,0,56,0,112,0,96,0,224,192,192,192,193,192,227,128,127,128,62,0,
  // 0x00c0  À
  15,24,48,17,1,0,12,0,6,0,3,0,1,128,0,0,3,128,3,128,6,192,6,192,12,64,12,96,12,96,24,48,24,48,24,48,48,24,63,248,63,248,96,12,96,12,96,12,192,6,192,6,192,6,
  // 0x00c1  Á
  15,24,48,17,1,0,0,96,0,192,1,128,3,0,0,0,3,128,3,128,6,192,6,192,12,64,12,96,12,96,24,48,24,48,24,48,48,24,63,248,63,248,96,12,96,12,96,12,192,6,192,6,192,6,
  // 0x00c2  Â
  15,24,48,17,1,0,1,128,3,192,6,96,12,48,0,0,3,128,3,128,6,192,6,192,12,64,12,96,12,96,24,48,24,48,24,48,48,24,63,248,63,248,96,12,96,12,96,12,192,6,192,6,192,6,
  // 0x00c3  Ã
  15,23,46,17,1,0,7,16,13,176,8,224,0,0,3,128,3,128,6,192,6,192,12,64,12,96,12,96,24,48,24,48,24,48,48,24,63,248,63,248,96,12,96,12,96,12,192,6,192,6,192,6,
  // 0x00c4  Ä
  15,23,46,17,1,0,12,96,12,96,0,0,0,0,3,128,3,128,6,192,6,192,12,64,12,96,12,96,24,48,24,48,24,48,48,24,63,248,63,248,96,12,96,12,96,12,192,6,192,6,192,6,
  // 0x00c5  Å
  15,24,48,17,1,0,3,128,4,64,4,64,3,128,0,0,3,128,3,128,6,192,6,192,12,64,12,96,12,96,24,48,24,48,24,48,48,24,63,248,63,248,96,12,96,12,96,12,192,6,192,6,192,6,
  // 0x00c6  Æ
  21,19,57,23,1,0,3,255,248,3,255,248,6,96,0,6,96,0,12,96,0,12,96,0,12,96,0,24,96,0,24,127,248,24,127,248,48,96,0,63,224,0,63,224,0,96,96,0,96,96,0,96,96,0,192,96,0,192,127,248,192,127,248,
  // 0x00c7  Ç
  15,24,48,18,1,251,7,224,31,248,60,60,112,14,96,6,224,6,192,0,192,0,192,0,192,0,192,0,192,0,192,0,224,6,96,6,112,14,60,60,31,248,7,224,1,128,0,192,0,192,7,192,3,128,
  // 0x00c8  È
  12,24,48,16,2,0,48,0,24,0,12,0,6,0,0,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,224,255,224,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x00c9  É
  12,24,48,16,2,0,1,128,3,0,6,0,12,0,0,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,224,255,224,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x00ca  Ê
  12,24,48,16,2,0,6,0,15,0,25,128,48,192,0,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,224,255,224,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x00cb  Ë
  12,23,46,16,2,0,24,192,24,192,0,0,0,0,255,240,255,240,192,0,192,0,192,0,192,0,192,0,192,0,255,224,255,224,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,240,255,240,
  // 0x00cc  Ì
  5,24,24,8,1,0,192,96,48,24,0,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
  // 0x00cd  Í
  5,24,24,8,2,0,24,48,96,192,0,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
  // 0x00ce  Î
  8,24,24,8,0,0,24,60,102,195,0,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
  // 0x00cf  Ï
  6,23,23,8,1,0,204,204,0,0,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
  // 0x00d0  Ð
  18,19,57,18,255,0,31,248,0,31,254,0,24,15,0,24,3,128,24,1,128,24,1,192,24,0,192,24,0,192,255,128,192,255,128,192,24,0,192,24,0,192,24,0,192,24,1,192,24,1,128,24,3,128,24,15,0,31,254,0,31,248,0,
  // 0x00d1  Ñ
  14,23,46,18,2,0,14,32,27,96,17,192,0,0,224,12,240,12,240,12,216,12,220,12,204,12,206,12,198,12,199,12,195,12,195,140,193,140,193,204,192,204,192,236,192,108,192,60,192,60,192,28,
  // 0x00d2  Ò
  16,24,48,18,1,0,12,0,6,0,3,0,1,128,0,0,7,224,31,248,60,60,112,14,96,6,224,7,192,3,192,3,192,3,192,3,192,3,192,3,192,3,224,7,96,6,112,14,60,60,31,248,7,224,
  // 0x00d3  Ó
  16,24,48,18,1,0,0,48,0,96,0,192,1,128,0,0,7,224,31,248,60,60,112,14,96,6,224,7,192,3,192,3,192,3,192,3,192,3,192,3,192,3,224,7,96,6,112,14,60,60,31,248,7,224,
  // 0x00d4  Ô
  16,24,48,18,1,0,0,192,1,224,3,48,6,24,0,0,7,224,31,248,60,60,112,14,96,6,224,7,192,3,192,3,192,3,192,3,192,3,192,3,192,3,224,7,96,6,112,14,60,60,31,248,7,224,
  // 0x00d5  Õ
  16,23,46,18,1,0,3,136,6,216,4,112,0,0,7,224,31,248,60,60,112,14,96,6,224,7,192,3,192,3,192,3,192,3,192,3,192,3,192,3,224,7,96,6,112,14,60,60,31,248,7,224,
  // 0x00d6  Ö
  16,23,46,18,1,0,6,48,6,48,0,0,0,0,7,224,31,248,60,60,112,14,96,6,224,7,192,3,192,3,192,3,192,3,192,3,192,3,192,3,224,7,96,6,112,14,60,60,31,248,7,224,
  // 0x00d7  ×
  13,12,24,14,0,1,192,24,96,48,48,96,24,192,13,128,7,0,7,0,13,128,24,192,48,96,96,48,192,24,
  // 0x00d8  Ø
  18,19,57,18,0,0,3,240,192,15,253,192,30,31,128,56,7,0,48,15,0,112,29,128,96,57,128,96,113,128,96,225,128,97,193,128,99,129,128,103,1,128,110,1,128,124,3,128,56,3,0,56,7,0,126,30,0,239,252,0,195,240,0,
  // 0x00d9  Ù
  14,24,48,18,2,0,24,0,12,0,6,0,3,0,0,0,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,96,24,112,56,63,240,15,192,
  // 0x00da  Ú
  14,24,48,18,2,0,0,96,0,192,1,128,3,0,0,0,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,96,24,112,56,63,240,15,192,
  // 0x00db  Û
  14,24,48,18,2,0,3,0,7,128,12,192,24,96,0,0,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,96,24,112,56,63,240,15,192,
  // 0x00dc  Ü
  14,23,46,18,2,0,24,192,24,192,0,0,0,0,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,192,12,96,24,112,56,63,240,15,192,
  // 0x00dd  Ý
  14,24,48,16,1,0,0,96,0,192,1,128,3,0,0,0,192,12,224,28,96,24,112,56,48,48,56,112,24,96,28,224,12,192,15,192,7,128,7,128,3,0,3,0,3,0,3,0,3,0,3,0,3,0,
  // 0x00de  Þ
  13,19,38,16,2,0,192,0,192,0,192,0,192,0,255,224,255,240,192,48,192,24,192,24,192,24,192,24,192,48,255,240,255,224,192,0,192,0,192,0,192,0,192,0,
  // 0x00df  ß
  10,19,38,15,3,0,28,0,127,0,227,0,193,128,193,128,193,128,195,0,199,0,206,0,207,0,195,128,193,128,192,192,192,192,192,192,193,128,195,128,207,0,206,0,
  // 0x00e0  à
  11,19,38,13,1,0,24,0,12,0,6,0,3,0,0,0,31,0,63,128,97,192,96,192,0,192,7,192,63,192,120,192,224,192,192,192,193,192,227,192,126,224,60,96,
  // 0x00e1  á
  11,19,38,13,1,0,1,128,3,0,6,0,12,0,0,0,31,0,63,128,97,192,96,192,0,192,7,192,63,192,120,192,224,192,192,192,193,192,227,192,126,224,60,96,
  // 0x00e2  â
  11,19,38,13,1,0,12,0,30,0,51,0,97,128,0,0,31,0,63,128,97,192,96,192,0,192,7,192,63,192,120,192,224,192,192,192,193,192,227,192,126,224,60,96,
  // 0x00e3  ã
  11,18,36,13,1,0,28,64,54,192,35,128,0,0,31,0,63,128,97,192,96,192,0,192,7,192,63,192,120,192,224,192,192,192,193,192,227,192,126,224,60,96,
  // 0x00e4  ä
  11,18,36,13,1,0,51,0,51,0,0,0,0,0,31,0,63,128,97,192,96,192,0,192,7,192,63,192,120,192,224,192,192,192,193,192,227,192,126,224,60,96,
  // 0x00e5  å
  11,19,38,13,1,0,6,0,9,0,9,0,6,0,0,0,31,0,63,128,97,192,96,192,0,192,7,192,63,192,120,192,224,192,192,192,193,192,227,192,126,224,60,96,
  // 0x00e6  æ
  19,14,42,21,1,0,31,14,0,63,191,128,97,241,192,96,224,192,0,192,96,7,192,96,63,255,224,120,255,224,224,192,0,192,192,0,193,224,96,227,240,224,126,63,192,60,15,0,
  // 0x00e7  ç
  10,19,38,12,1,251,31,0,63,128,113,192,96,192,224,0,192,0,192,0,192,0,192,0,224,0,96,192,113,192,63,128,31,0,12,0,6,0,6,0,62,0,28,0,
  // 0x00e8  è
  11,19,38,13,1,0,24,0,12,0,6,0,3,0,0,0,14,0,63,128,113,192,96,192,192,96,192,96,255,224,255,224,192,0,192,0,96,96,112,224,63,192,15,0,
  // 0x00e9  é
  11,19,38,13,1,0,3,0,6,0,12,0,24,0,0,0,14,0,63,128,113,192,96,192,192,96,192,96,255,224,255,224,192,0,192,0,96,96,112,224,63,192,15,0,
  // 0x00ea  ê
  11,19,38,13,1,0,12,0,30,0,51,0,97,128,0,0,14,0,63,128,113,192,96,192,192,96,192,96,255,224,255,224,192,0,192,0,96,96,112,224,63,192,15,0,
  // 0x00eb  ë
  11,18,36,13,1,0,51,0,51,0,0,0,0,0,14,0,63,128,113,192,96,192,192,96,192,96,255,224,255,224,192,0,192,0,96,96,112,224,63,192,15,0,
  // 0x00ec  ì
  5,19,19,6,0,0,192,96,48,24,0,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
  // 0x00ed  í
  5,19,19,6,1,0,24,48,96,192,0,96,96,96,96,96,96,96,96,96,96,96,96,96,96,
  // 0x00ee  î
  8,19,19,6,255,0,24,60,102,195,0,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
  // 0x00ef  ï
  6,18,18,6,0,0,204,204,0,0,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
  // 0x00f0  ð
  11,19,38,13,1,0,96,0,57,128,14,0,30,0,99,0,31,128,63,128,113,192,96,192,224,224,192,96,192,96,192,96,192,96,224,224,96,192,113,192,63,128,31,0,
  // 0x00f1  ñ
  10,18,36,14,2,0,56,128,109,128,71,0,0,0,206,0,223,128,241,128,224,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x00f2  ò
  11,19,38,13,1,0,24,0,12,0,6,0,3,0,0,0,31,0,63,128,113,192,96,192,224,224,192,96,192,96,192,96,192,96,224,224,96,192,113,192,63,128,31,0,
  // 0x00f3  ó
  11,19,38,13,1,0,3,0,6,0,12,0,24,0,0,0,31,0,63,128,113,192,96,192,224,224,192,96,192,96,192,96,192,96,224,224,96,192,113,192,63,128,31,0,
  // 0x00f4  ô
  11,19,38,13,1,0,12,0,30,0,51,0,97,128,0,0,31,0,63,128,113,192,96,192,224,224,192,96,192,96,192,96,192,96,224,224,96,192,113,192,63,128,31,0,
  // 0x00f5  õ
  11,18,36,13,1,0,28,64,54,192,35,128,0,0,31,0,63,128,113,192,96,192,224,224,192,96,192,96,192,96,192,96,224,224,96,192,113,192,63,128,31,0,
  // 0x00f6  ö
  11,18,36,13,1,0,51,0,51,0,0,0,0,0,31,0,63,128,113,192,96,192,224,224,192,96,192,96,192,96,192,96,224,224,96,192,113,192,63,128,31,0,
  // 0x00f7  ÷
  12,12,24,14,1,1,6,0,6,0,6,0,0,0,0,0,255,240,255,240,0,0,0,0,6,0,6,0,6,0,
  // 0x00f8  ø
  13,14,28,13,0,0,15,152,31,248,56,112,48,224,113,240,99,176,99,48,102,48,108,48,124,112,56,96,112,224,255,192,207,128,
  // 0x00f9  ù
  10,19,38,14,2,0,48,0,24,0,12,0,6,0,0,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,192,99,192,126,192,28,192,
  // 0x00fa  ú
  10,19,38,14,2,0,3,0,6,0,12,0,24,0,0,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,192,99,192,126,192,28,192,
  // 0x00fb  û
  10,19,38,14,2,0,12,0,30,0,51,0,97,128,0,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,192,99,192,126,192,28,192,
  // 0x00fc  ü
  10,18,36,14,2,0,51,0,51,0,0,0,0,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,193,192,99,192,126,192,28,192,
  // 0x00fd  ý
  12,24,48,13,0,251,0,192,1,128,3,0,6,0,0,0,192,48,192,48,96,48,112,96,48,96,56,224,24,192,24,192,13,128,13,128,7,128,7,0,3,0,3,0,6,0,6,0,12,0,60,0,56,0,
  // 0x00fe  þ
  11,24,48,14,2,251,192,0,192,0,192,0,192,0,192,0,207,0,223,128,241,192,224,192,192,224,192,96,192,96,192,96,192,96,192,224,224,192,241,192,223,128,207,0,192,0,192,0,192,0,192,0,192,0,
  // 0x00ff  ÿ
  12,23,46,13,0,251,25,128,25,128,0,0,0,0,192,48,192,48,96,48,112,96,48,96,56,224,24,192,24,192,13,128,13,128,7,128,7,0,3,0,3,0,6,0,6,0,12,0,60,0,56,0,
};

#endif // HAS_GRAPHICAL_TFT
