/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2022 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

/**
 * Fontname: Helvetica
 * Copyright: Copyright (c) 1984, 1987 Adobe Systems Incorporated. All Rights Reserved. Copyright (c) 1988, 1991 Digital Equipment Corporation. All Rights Reserved.
 * Capital A Height: 14, '1' Height: 13
 * Calculated Max Values w=16 h=18 x= 2 y=12 dx=18 dy= 0 ascent=16 len=36
 * Font Bounding box     w=18 h=19 x= 0 y=-4
 * Calculated Min Values           x= 0 y=-4 dx= 0 dy= 0
 * Pure Font   ascent =14 descent=-4
 * X Font      ascent =14 descent=-4
 * Max Font    ascent =16 descent=-4
 */

#include "../fontdata.h"

#if HAS_GRAPHICAL_TFT && TFT_FONT == HELVETICA

// Helvetica Symbols, capital 'A' height: 14px
extern const uint8_t Helvetica_Symbols_14[43] = {
  129,14,8,0,9,0,16,252, // unifont_t
  // 0x08 - LCD_STR_THERMOMETER a.k.a 0x1f321  🌡
  7,18,18,8,0,255,0,56,68,68,68,68,68,84,84,84,84,84,214,186,186,186,198,124,
  // 0x09 - LCD_STR_DEGREE a.k.a 0x00b0  °
  5,5,5,7,1,8,112,216,136,216,112,
};

// Helvetica, capital 'A' height: 14px
extern const uint8_t Helvetica_14[4831] = {
  129,14,32,0,255,0,16,252, // unifont_t
  // 0x0020 " "
  0,0,0,5,0,0,
  // 0x0021  !
  2,14,14,6,2,0,192,192,192,192,192,192,192,192,192,192,0,0,192,192,
  // 0x0022  "
  5,5,5,5,0,9,216,216,216,216,216,
  // 0x0023  #
  10,13,26,10,0,0,9,0,9,0,9,0,127,192,127,192,18,0,18,0,18,0,255,128,255,128,36,0,36,0,36,0,
  // 0x0024  $
  9,16,32,10,1,254,8,0,62,0,127,0,203,0,200,0,232,0,120,0,62,0,15,0,9,128,201,128,235,128,127,0,62,0,8,0,8,0,
  // 0x0025  %
  14,13,26,16,1,0,120,96,204,192,204,192,205,128,205,128,123,0,3,0,6,120,6,204,12,204,12,204,24,204,24,120,
  // 0x0026  &
  12,13,26,13,1,0,60,0,126,0,102,0,102,0,60,0,124,0,238,192,198,192,195,192,195,128,231,192,126,224,60,112,
  // 0x0027  '
  2,5,5,4,1,9,192,192,192,192,192,
  // 0x0028  (
  4,18,18,6,0,252,16,48,96,96,192,192,192,192,192,192,192,192,192,192,96,96,48,16,
  // 0x0029  )
  4,18,18,6,1,252,128,192,96,96,48,48,48,48,48,48,48,48,48,48,96,96,192,128,
  // 0x002a  *
  5,7,7,7,1,7,32,168,248,32,248,168,32,
  // 0x002b  +
  8,10,10,10,1,0,24,24,24,24,255,255,24,24,24,24,
  // 0x002c  ,
  2,5,5,5,1,253,192,192,64,64,128,
  // 0x002d  -
  5,2,2,6,0,4,248,248,
  // 0x002e  .
  2,2,2,5,1,0,192,192,
  // 0x002f  /
  5,14,14,5,0,0,24,24,24,24,48,48,48,96,96,96,192,192,192,192,
  // 0x0030  0
  8,13,13,10,1,0,60,126,102,195,195,195,195,195,195,195,102,126,60,
  // 0x0031  1
  5,13,13,10,2,0,24,248,248,24,24,24,24,24,24,24,24,24,24,
  // 0x0032  2
  8,13,13,10,1,0,60,254,195,3,7,14,28,56,112,224,192,255,255,
  // 0x0033  3
  8,13,13,10,1,0,62,127,195,195,6,28,30,7,3,195,199,126,60,
  // 0x0034  4
  9,13,26,10,0,0,3,0,7,0,15,0,27,0,51,0,51,0,99,0,195,0,255,128,255,128,3,0,3,0,3,0,
  // 0x0035  5
  8,13,13,10,1,0,254,254,192,192,252,254,199,3,3,195,199,254,124,
  // 0x0036  6
  8,13,13,10,1,0,60,127,99,192,192,220,254,195,195,195,227,126,60,
  // 0x0037  7
  8,13,13,10,1,0,255,255,3,6,12,12,24,24,48,48,96,96,96,
  // 0x0038  8
  8,13,13,10,1,0,60,126,231,195,195,102,126,231,195,195,231,126,60,
  // 0x0039  9
  8,13,13,10,1,0,60,126,199,195,195,195,127,59,3,3,198,254,124,
  // 0x003a  :
  2,10,10,5,1,0,192,192,0,0,0,0,0,0,192,192,
  // 0x003b  ;
  2,13,13,5,1,253,192,192,0,0,0,0,0,0,192,192,64,64,128,
  // 0x003c  <
  8,9,9,10,1,0,3,15,60,112,192,112,60,15,3,
  // 0x003d  =
  7,5,5,11,2,2,254,254,0,254,254,
  // 0x003e  >
  8,9,9,10,1,0,192,240,60,14,3,14,60,240,192,
  // 0x003f  ?
  7,14,14,10,1,0,124,254,198,198,14,28,56,48,48,48,0,0,48,48,
  // 0x0040  @
  16,17,34,18,1,253,3,240,15,252,28,14,48,6,99,211,103,115,198,51,204,99,204,102,204,102,204,204,207,248,103,112,112,0,56,0,31,240,7,224,
  // 0x0041  A
  12,14,28,13,0,0,6,0,6,0,15,0,15,0,25,128,25,128,48,192,48,192,63,192,127,224,96,96,96,96,192,48,192,48,
  // 0x0042  B
  11,14,28,13,1,0,255,0,255,128,193,192,192,192,192,192,193,128,255,128,255,192,192,224,192,96,192,96,192,224,255,192,255,128,
  // 0x0043  C
  12,14,28,14,1,0,15,128,63,224,112,112,96,48,224,0,192,0,192,0,192,0,192,0,224,0,96,48,112,112,63,224,15,128,
  // 0x0044  D
  12,14,28,14,1,0,255,128,255,192,192,224,192,96,192,48,192,48,192,48,192,48,192,48,192,48,192,96,192,224,255,192,255,128,
  // 0x0045  E
  10,14,28,13,2,0,255,192,255,192,192,0,192,0,192,0,192,0,255,128,255,128,192,0,192,0,192,0,192,0,255,192,255,192,
  // 0x0046  F
  9,14,28,12,2,0,255,128,255,128,192,0,192,0,192,0,192,0,255,0,255,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0047  G
  13,14,28,15,1,0,15,192,63,240,112,56,96,24,224,24,192,0,192,0,192,248,192,248,224,24,96,24,112,56,63,248,15,216,
  // 0x0048  H
  11,14,28,14,1,0,192,96,192,96,192,96,192,96,192,96,192,96,255,224,255,224,192,96,192,96,192,96,192,96,192,96,192,96,
  // 0x0049  I
  2,14,14,6,2,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x004a  J
  8,14,14,10,0,0,3,3,3,3,3,3,3,3,3,195,195,231,126,60,
  // 0x004b  K
  11,14,28,14,2,0,192,224,193,192,195,128,199,0,206,0,220,0,248,0,252,0,206,0,199,0,195,128,193,192,192,224,192,96,
  // 0x004c  L
  9,14,28,11,1,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,192,0,255,128,255,128,
  // 0x004d  M
  14,14,28,16,1,0,192,12,192,12,224,28,224,28,240,60,240,60,216,108,216,108,204,204,204,204,196,140,199,140,195,12,195,12,
  // 0x004e  N
  11,14,28,14,1,0,192,96,224,96,240,96,240,96,216,96,204,96,204,96,198,96,198,96,195,96,193,224,193,224,192,224,192,96,
  // 0x004f  O
  13,14,28,15,1,0,15,128,63,224,112,112,96,48,224,56,192,24,192,24,192,24,192,24,224,56,96,48,112,112,63,224,15,128,
  // 0x0050  P
  10,14,28,13,2,0,255,0,255,128,193,192,192,192,192,192,193,192,255,128,255,0,192,0,192,0,192,0,192,0,192,0,192,0,
  // 0x0051  Q
  13,15,30,15,1,255,15,128,63,224,112,112,96,48,224,56,192,24,192,24,192,24,192,24,225,184,97,176,112,240,63,224,15,176,0,48,
  // 0x0052  R
  11,14,28,14,1,0,255,128,255,192,192,224,192,96,192,96,192,224,255,192,255,128,192,192,192,192,192,96,192,96,192,96,192,96,
  // 0x0053  S
  10,14,28,13,1,0,30,0,127,128,225,192,192,192,224,0,124,0,31,0,3,128,1,192,0,192,192,192,225,192,127,128,63,0,
  // 0x0054  T
  10,14,28,12,1,0,255,192,255,192,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,12,0,
  // 0x0055  U
  11,14,28,14,1,0,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,96,192,127,192,31,0,
  // 0x0056  V
  12,14,28,13,0,0,192,48,192,48,96,96,96,96,96,96,48,192,48,192,48,192,25,128,25,128,25,128,15,0,15,0,6,0,
  // 0x0057  W
  16,14,28,18,1,0,193,131,193,131,193,131,195,195,99,198,98,70,102,102,102,102,54,108,54,108,52,44,28,56,24,24,24,24,
  // 0x0058  X
  11,14,28,13,1,0,192,96,192,96,96,192,113,192,49,128,27,0,14,0,14,0,27,0,49,128,113,192,96,192,192,96,192,96,
  // 0x0059  Y
  12,14,28,13,0,0,192,48,192,48,96,96,96,96,48,192,57,192,25,128,15,0,6,0,6,0,6,0,6,0,6,0,6,0,
  // 0x005a  Z
  10,14,28,12,1,0,255,192,255,192,0,192,1,128,3,0,6,0,12,0,28,0,24,0,48,0,96,0,192,0,255,192,255,192,
  // 0x005b  [
  4,18,18,5,0,252,240,240,192,192,192,192,192,192,192,192,192,192,192,192,192,192,240,240,
  // 0x005c "\"
  5,14,14,5,0,0,192,192,192,96,96,96,48,48,48,48,24,24,24,24,
  // 0x005d  ]
  4,18,18,5,0,252,240,240,48,48,48,48,48,48,48,48,48,48,48,48,48,48,240,240,
  // 0x005e  ^
  7,6,6,9,1,7,16,56,108,108,198,198,
  // 0x005f  _
  11,2,4,11,0,252,255,224,255,224,
  // 0x0060  `
  4,3,3,4,0,11,192,96,48,
  // 0x0061  a
  9,10,20,11,1,0,126,0,231,0,195,0,7,0,127,0,227,0,195,0,195,0,231,128,121,128,
  // 0x0062  b
  9,14,28,11,1,0,192,0,192,0,192,0,192,0,222,0,255,0,227,0,193,128,193,128,193,128,193,128,227,0,255,0,222,0,
  // 0x0063  c
  8,10,10,10,1,0,62,127,99,192,192,192,192,99,127,62,
  // 0x0064  d
  9,14,28,11,1,0,1,128,1,128,1,128,1,128,61,128,127,128,99,128,193,128,193,128,193,128,193,128,99,128,127,128,61,128,
  // 0x0065  e
  8,10,10,10,1,0,60,126,195,195,255,192,192,227,127,60,
  // 0x0066  f
  6,14,14,6,0,0,28,60,48,48,252,252,48,48,48,48,48,48,48,48,
  // 0x0067  g
  9,14,28,11,1,252,61,128,127,128,97,128,193,128,193,128,193,128,193,128,99,128,127,128,61,128,1,128,99,0,127,0,28,0,
  // 0x0068  h
  8,14,14,10,1,0,192,192,192,192,222,255,227,195,195,195,195,195,195,195,
  // 0x0069  i
  2,14,14,4,1,0,192,192,0,0,192,192,192,192,192,192,192,192,192,192,
  // 0x006a  j
  3,18,18,4,0,252,96,96,0,0,96,96,96,96,96,96,96,96,96,96,96,96,224,192,
  // 0x006b  k
  8,14,14,9,1,0,192,192,192,192,198,204,216,240,248,216,204,206,198,199,
  // 0x006c  l
  2,14,14,4,1,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x006d  m
  14,10,20,16,1,0,222,120,255,252,227,140,195,12,195,12,195,12,195,12,195,12,195,12,195,12,
  // 0x006e  n
  8,10,10,10,1,0,222,255,227,195,195,195,195,195,195,195,
  // 0x006f  o
  9,10,20,11,1,0,62,0,127,0,99,0,193,128,193,128,193,128,193,128,99,0,127,0,62,0,
  // 0x0070  p
  9,14,28,11,1,252,222,0,255,0,227,0,193,128,193,128,193,128,193,128,227,0,255,0,222,0,192,0,192,0,192,0,192,0,
  // 0x0071  q
  9,14,28,11,1,252,61,128,127,128,99,128,193,128,193,128,193,128,193,128,99,128,127,128,61,128,1,128,1,128,1,128,1,128,
  // 0x0072  r
  5,10,10,6,1,0,216,216,224,192,192,192,192,192,192,192,
  // 0x0073  s
  7,10,10,9,1,0,60,126,198,192,252,62,6,198,252,120,
  // 0x0074  t
  6,13,13,6,0,0,48,48,48,252,252,48,48,48,48,48,48,60,28,
  // 0x0075  u
  8,10,10,10,1,0,195,195,195,195,195,195,195,199,255,123,
  // 0x0076  v
  8,10,10,10,1,0,195,195,195,102,102,102,36,60,24,24,
  // 0x0077  w
  12,10,20,14,1,0,198,48,198,48,198,48,102,96,102,96,105,96,41,64,57,192,25,128,25,128,
  // 0x0078  x
  8,10,10,10,1,0,195,231,102,60,24,24,60,102,231,195,
  // 0x0079  y
  8,14,14,10,1,252,195,195,195,102,102,102,36,60,24,24,24,24,112,112,
  // 0x007a  z
  7,10,10,9,1,0,254,254,6,12,24,48,96,192,254,254,
  // 0x007b  {
  5,18,18,6,0,252,24,48,96,96,96,96,96,192,128,192,96,96,96,96,96,96,48,24,
  // 0x007c  |
  2,18,18,5,1,252,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x007d  }
  6,18,18,6,0,252,192,96,48,48,48,48,48,24,12,24,48,48,48,48,48,48,96,192,
  // 0x007e  ~
  8,3,3,10,1,4,115,255,206,
  // 0x007f - 0x009a  Control Characters
  255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
  // 0x00a0   
  0,0,0,5,0,0,
  // 0x00a1  ¡
  2,14,14,6,2,252,192,192,0,0,64,64,192,192,192,192,192,192,192,192,
  // 0x00a2  ¢
  8,14,14,10,1,254,4,4,62,127,107,200,200,200,200,107,127,62,16,16,
  // 0x00a3  £
  9,13,26,10,0,0,30,0,63,0,97,128,97,128,96,0,48,0,126,0,24,0,24,0,48,0,96,128,255,128,223,0,
  // 0x00a4  ¤
  8,7,7,10,1,3,195,255,102,102,102,255,195,
  // 0x00a5  ¥
  8,13,13,10,1,0,195,195,102,102,102,60,255,24,255,24,24,24,24,
  // 0x00a6  ¦
  2,18,18,5,1,252,192,192,192,192,192,192,192,0,0,0,0,192,192,192,192,192,192,192,
  // 0x00a7  §
  8,18,18,10,1,252,60,126,195,195,240,124,110,199,195,227,115,62,14,7,195,195,126,60,
  // 0x00a8  ¨
  5,2,2,6,0,12,216,216,
  // 0x00a9  ©
  13,14,28,15,1,0,15,128,48,96,64,16,71,16,136,136,144,136,144,8,144,8,144,8,136,136,71,16,64,16,48,96,15,128,
  // 0x00aa  ª
  5,8,8,7,1,6,112,152,56,72,216,104,0,248,
  // 0x00ab  «
  7,6,6,9,1,2,54,108,216,216,108,54,
  // 0x00ac  ¬
  9,5,10,11,1,3,255,128,255,128,1,128,1,128,1,128,
  // 0x00ad  ­
  5,1,1,6,0,5,248,
  // 0x00ae  ®
  13,14,28,14,0,0,15,128,48,96,64,16,79,144,136,72,136,72,136,72,143,136,137,8,136,136,72,80,64,16,48,96,15,128,
  // 0x00af  ¯
  5,1,1,5,0,12,248,
  // 0x00b0  °
  5,5,5,7,1,8,112,216,136,216,112,
  // 0x00b1  ±
  8,11,11,10,1,0,24,24,24,255,255,24,24,24,0,255,255,
  // 0x00b2  ²
  5,8,8,6,0,5,112,248,152,24,48,96,248,248,
  // 0x00b3  ³
  5,8,8,6,0,5,112,248,152,48,48,152,248,112,
  // 0x00b4  ´
  4,3,3,4,0,11,48,96,192,
  // 0x00b5  µ
  8,14,14,10,1,252,195,195,195,195,195,195,195,231,255,219,192,192,192,192,
  // 0x00b6  ¶
  8,18,18,10,1,252,63,114,242,242,242,242,242,114,50,18,18,18,18,18,18,18,18,18,
  // 0x00b7  ·
  2,2,2,4,1,4,192,192,
  // 0x00b8  ¸
  5,5,5,5,0,252,96,112,24,216,240,
  // 0x00b9  ¹
  4,8,8,6,0,5,48,240,240,48,48,48,48,48,
  // 0x00ba  º
  5,8,8,7,1,6,112,216,136,136,216,112,0,248,
  // 0x00bb  »
  7,6,6,9,1,2,216,108,54,54,108,216,
  // 0x00bc  ¼
  14,13,26,15,0,0,48,48,240,48,240,96,48,192,48,192,49,136,49,24,51,56,6,120,6,216,12,252,24,24,24,24,
  // 0x00bd  ½
  14,13,26,15,0,0,48,48,240,48,240,96,48,192,48,192,49,184,49,124,51,76,6,12,6,24,12,48,24,124,24,124,
  // 0x00be  ¾
  14,13,26,15,0,0,112,48,248,48,152,96,48,192,48,192,153,136,249,24,115,56,6,120,6,216,12,252,24,24,24,24,
  // 0x00bf  ¿
  7,14,14,10,1,252,24,24,0,0,24,24,24,56,112,224,198,198,254,124,
  // 0x00c0  À
  12,16,32,13,0,0,6,0,0,0,6,0,6,0,15,0,15,0,25,128,25,128,48,192,48,192,63,192,127,224,96,96,96,96,192,48,192,48,
  // 0x00c1  Á
  12,16,32,13,0,0,6,0,0,0,6,0,6,0,15,0,15,0,25,128,25,128,48,192,48,192,63,192,127,224,96,96,96,96,192,48,192,48,
  // 0x00c2  Â
  12,16,32,13,0,0,25,128,0,0,6,0,6,0,15,0,15,0,25,128,25,128,48,192,48,192,63,192,127,224,96,96,96,96,192,48,192,48,
  // 0x00c3  Ã
  12,16,32,13,0,0,19,0,0,0,6,0,6,0,15,0,15,0,25,128,25,128,48,192,48,192,63,192,127,224,96,96,96,96,192,48,192,48,
  // 0x00c4  Ä
  12,16,32,13,0,0,25,128,0,0,6,0,6,0,15,0,15,0,25,128,25,128,48,192,48,192,63,192,127,224,96,96,96,96,192,48,192,48,
  // 0x00c5  Å
  12,16,32,13,0,0,9,0,9,0,6,0,6,0,15,0,15,0,25,128,25,128,48,192,48,192,63,192,127,224,96,96,96,96,192,48,192,48,
  // 0x00c6  Æ
  16,14,28,18,1,0,7,255,7,255,13,128,13,128,25,128,25,128,49,254,49,254,63,128,127,128,97,128,97,128,193,255,193,255,
  // 0x00c7  Ç
  12,18,36,14,1,252,15,128,63,224,112,112,96,48,224,0,192,0,192,0,192,0,192,0,224,0,96,48,112,112,63,224,15,128,6,0,3,0,27,0,30,0,
  // 0x00c8  È
  10,16,32,13,2,0,12,0,0,0,255,192,255,192,192,0,192,0,192,0,192,0,255,128,255,128,192,0,192,0,192,0,192,0,255,192,255,192,
  // 0x00c9  É
  10,16,32,13,2,0,12,0,0,0,255,192,255,192,192,0,192,0,192,0,192,0,255,128,255,128,192,0,192,0,192,0,192,0,255,192,255,192,
  // 0x00ca  Ê
  10,16,32,13,2,0,51,0,0,0,255,192,255,192,192,0,192,0,192,0,192,0,255,128,255,128,192,0,192,0,192,0,192,0,255,192,255,192,
  // 0x00cb  Ë
  10,16,32,13,2,0,51,0,0,0,255,192,255,192,192,0,192,0,192,0,192,0,255,128,255,128,192,0,192,0,192,0,192,0,255,192,255,192,
  // 0x00cc  Ì
  2,16,16,6,2,0,192,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x00cd  Í
  2,16,16,6,2,0,192,0,192,192,192,192,192,192,192,192,192,192,192,192,192,192,
  // 0x00ce  Î
  6,16,16,6,0,0,132,0,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
  // 0x00cf  Ï
  6,16,16,6,0,0,204,0,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
  // 0x00d0  Ð
  13,14,28,14,0,0,127,192,127,224,96,112,96,48,96,24,96,24,252,24,252,24,96,24,96,24,96,48,96,112,127,224,127,192,
  // 0x00d1  Ñ
  11,16,32,14,1,0,19,0,0,0,192,96,224,96,240,96,240,96,216,96,204,96,204,96,198,96,198,96,195,96,193,224,193,224,192,224,192,96,
  // 0x00d2  Ò
  13,16,32,15,1,0,6,0,0,0,15,128,63,224,112,112,96,48,224,56,192,24,192,24,192,24,192,24,224,56,96,48,112,112,63,224,15,128,
  // 0x00d3  Ó
  13,16,32,15,1,0,6,0,0,0,15,128,63,224,112,112,96,48,224,56,192,24,192,24,192,24,192,24,224,56,96,48,112,112,63,224,15,128,
  // 0x00d4  Ô
  13,16,32,15,1,0,12,192,0,0,15,128,63,224,112,112,96,48,224,56,192,24,192,24,192,24,192,24,224,56,96,48,112,112,63,224,15,128,
  // 0x00d5  Õ
  13,16,32,15,1,0,9,128,0,0,15,128,63,224,112,112,96,48,224,56,192,24,192,24,192,24,192,24,224,56,96,48,112,112,63,224,15,128,
  // 0x00d6  Ö
  13,16,32,15,1,0,12,192,0,0,15,128,63,224,112,112,96,48,224,56,192,24,192,24,192,24,192,24,224,56,96,48,112,112,63,224,15,128,
  // 0x00d7  ×
  10,9,18,10,0,0,192,192,97,128,51,0,30,0,12,0,30,0,51,0,97,128,192,192,
  // 0x00d8  Ø
  14,14,28,15,0,0,7,204,31,248,56,48,48,120,112,220,97,140,99,12,98,12,102,12,108,28,56,24,56,56,111,240,199,192,
  // 0x00d9  Ù
  11,16,32,14,1,0,6,0,0,0,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,96,192,127,192,31,0,
  // 0x00da  Ú
  11,16,32,14,1,0,12,0,0,0,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,96,192,127,192,31,0,
  // 0x00db  Û
  11,16,32,14,1,0,25,128,0,0,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,96,192,127,192,31,0,
  // 0x00dc  Ü
  11,16,32,14,1,0,49,128,0,0,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,192,96,96,192,127,192,31,0,
  // 0x00dd  Ý
  12,16,32,13,0,0,6,0,0,0,192,48,192,48,96,96,96,96,48,192,57,192,25,128,15,0,6,0,6,0,6,0,6,0,6,0,6,0,
  // 0x00de  Þ
  10,14,28,12,1,0,192,0,192,0,192,0,255,0,255,128,193,192,192,192,192,192,193,192,255,128,255,0,192,0,192,0,192,0,
  // 0x00df  ß
  7,14,14,9,1,0,56,124,198,198,198,198,220,220,198,198,198,198,222,220,
  // 0x00e0  à
  9,14,28,11,1,0,48,0,24,0,12,0,0,0,126,0,231,0,195,0,7,0,127,0,227,0,195,0,195,0,231,128,121,128,
  // 0x00e1  á
  9,14,28,11,1,0,12,0,24,0,48,0,0,0,126,0,231,0,195,0,7,0,127,0,227,0,195,0,195,0,231,128,121,128,
  // 0x00e2  â
  9,14,28,11,1,0,24,0,60,0,102,0,0,0,126,0,231,0,195,0,7,0,127,0,227,0,195,0,195,0,231,128,121,128,
  // 0x00e3  ã
  9,14,28,11,1,0,50,0,90,0,76,0,0,0,126,0,231,0,195,0,7,0,127,0,227,0,195,0,195,0,231,128,121,128,
  // 0x00e4  ä
  9,14,28,11,1,0,102,0,102,0,0,0,0,0,126,0,231,0,195,0,7,0,127,0,227,0,195,0,195,0,231,128,121,128,
  // 0x00e5  å
  9,14,28,11,1,0,24,0,36,0,36,0,24,0,126,0,231,0,195,0,7,0,127,0,227,0,195,0,195,0,231,128,121,128,
  // 0x00e6  æ
  14,10,20,17,2,0,126,240,231,248,195,12,7,12,127,252,227,0,195,0,195,140,231,252,122,240,
  // 0x00e7  ç
  8,14,14,10,1,252,62,127,99,192,192,192,192,99,127,62,24,12,108,120,
  // 0x00e8  è
  8,14,14,10,1,0,48,24,12,0,60,126,195,195,255,192,192,227,127,60,
  // 0x00e9  é
  8,14,14,10,1,0,12,24,48,0,60,126,195,195,255,192,192,227,127,60,
  // 0x00ea  ê
  8,14,14,10,1,0,24,60,102,0,60,126,195,195,255,192,192,227,127,60,
  // 0x00eb  ë
  8,14,14,10,1,0,102,102,0,0,60,126,195,195,255,192,192,227,127,60,
  // 0x00ec  ì
  4,14,14,4,0,0,192,96,48,0,96,96,96,96,96,96,96,96,96,96,
  // 0x00ed  í
  4,14,14,4,0,0,48,96,192,0,96,96,96,96,96,96,96,96,96,96,
  // 0x00ee  î
  5,14,14,5,0,0,96,240,152,0,96,96,96,96,96,96,96,96,96,96,
  // 0x00ef  ï
  5,14,14,5,0,0,216,216,0,0,96,96,96,96,96,96,96,96,96,96,
  // 0x00f0  ð
  9,14,28,11,1,0,96,0,54,0,56,0,76,0,62,0,127,0,99,0,193,128,193,128,193,128,193,128,99,0,127,0,62,0,
  // 0x00f1  ñ
  8,14,14,10,1,0,50,90,76,0,222,255,227,195,195,195,195,195,195,195,
  // 0x00f2  ò
  9,14,28,11,1,0,48,0,24,0,12,0,0,0,62,0,127,0,99,0,193,128,193,128,193,128,193,128,99,0,127,0,62,0,
  // 0x00f3  ó
  9,14,28,11,1,0,6,0,12,0,24,0,0,0,62,0,127,0,99,0,193,128,193,128,193,128,193,128,99,0,127,0,62,0,
  // 0x00f4  ô
  9,14,28,11,1,0,24,0,60,0,102,0,0,0,62,0,127,0,99,0,193,128,193,128,193,128,193,128,99,0,127,0,62,0,
  // 0x00f5  õ
  9,14,28,11,1,0,50,0,90,0,76,0,0,0,62,0,127,0,99,0,193,128,193,128,193,128,193,128,99,0,127,0,62,0,
  // 0x00f6  ö
  9,14,28,11,1,0,51,0,51,0,0,0,0,0,62,0,127,0,99,0,193,128,193,128,193,128,193,128,99,0,127,0,62,0,
  // 0x00f7  ÷
  8,8,8,10,1,1,24,24,0,255,255,0,24,24,
  // 0x00f8  ø
  11,10,20,11,0,0,14,96,63,192,49,128,99,192,102,192,108,192,120,192,49,128,127,128,206,0,
  // 0x00f9  ù
  8,14,14,10,1,0,48,24,12,0,195,195,195,195,195,195,195,199,255,123,
  // 0x00fa  ú
  8,14,14,10,1,0,6,12,24,0,195,195,195,195,195,195,195,199,255,123,
  // 0x00fb  û
  8,14,14,10,1,0,24,60,102,0,195,195,195,195,195,195,195,199,255,123,
  // 0x00fc  ü
  8,14,14,10,1,0,102,102,0,0,195,195,195,195,195,195,195,199,255,123,
  // 0x00fd  ý
  8,18,18,10,1,252,6,12,24,0,195,195,195,102,102,102,36,60,24,24,24,24,112,112,
  // 0x00fe  þ
  9,18,36,11,1,252,192,0,192,0,192,0,192,0,222,0,255,0,227,0,193,128,193,128,193,128,193,128,227,0,255,0,222,0,192,0,192,0,192,0,192,0,
  // 0x00ff  ÿ
  8,18,18,10,1,252,102,102,0,0,195,195,195,102,102,102,36,60,24,24,24,24,112,112,
};

#endif // HAS_GRAPHICAL_TFT
