/***************************
 * max_velocity_screen.cpp *
 ***************************/

/****************************************************************************
 *   Written By Mark Pelletier  2017 - Aleph Objects, Inc.                  *
 *   Written By Marcio Teixeira 2018 - Aleph Objects, Inc.                  *
 *                                                                          *
 *   This program is free software: you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation, either version 3 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 *   This program is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *   GNU General Public License for more details.                           *
 *                                                                          *
 *   To view a copy of the GNU General Public License, go to the following  *
 *   location: <https://www.gnu.org/licenses/>.                             *
 ****************************************************************************/

#include "../config.h"
#include "../screens.h"

#ifdef FTDI_MAX_VELOCITY_SCREEN

using namespace FTDI;
using namespace ExtUI;
using namespace Theme;

void MaxVelocityScreen::onRedraw(draw_mode_t what) {
  using namespace ExtUI;
  widgets_t w(what);
  w.precision(0);
  w.units(GET_TEXT_F(MSG_UNITS_MM_S));
  w.heading(                        GET_TEXT_F(MSG_MAX_SPEED_NO_UNITS));
  w.color(x_axis)    .adjuster(  2, GET_TEXT_F(MSG_VMAX_X), getAxisMaxFeedrate_mm_s(X) );
  w.color(y_axis)    .adjuster(  4, GET_TEXT_F(MSG_VMAX_Y), getAxisMaxFeedrate_mm_s(Y) );
  w.color(z_axis)    .adjuster(  6, GET_TEXT_F(MSG_VMAX_Z), getAxisMaxFeedrate_mm_s(Z) );
  #if EXTRUDERS == 1 || DISABLED(DISTINCT_E_FACTORS)
    w.color(e_axis)  .adjuster(  8, GET_TEXT_F(MSG_VMAX_E), getAxisMaxFeedrate_mm_s(E0) );
  #elif HAS_MULTI_EXTRUDER
    w.heading(GET_TEXT_F(MSG_VMAX_E));
    w.color(e_axis)  .adjuster(  8, F(STR_E0), getAxisMaxFeedrate_mm_s(E0) );
    w.color(e_axis)  .adjuster( 10, F(STR_E1), getAxisMaxFeedrate_mm_s(E1) );
    #if EXTRUDERS > 2
      w.color(e_axis).adjuster( 12, F(STR_E2), getAxisMaxFeedrate_mm_s(E2) );
      #if EXTRUDERS > 3
        w.color(e_axis).adjuster( 14, F(STR_E3), getAxisMaxFeedrate_mm_s(E3) );
      #endif
    #endif
  #endif
  w.increments();
}

bool MaxVelocityScreen::onTouchHeld(uint8_t tag) {
  const float increment = getIncrement();
  switch (tag) {
    case  2: UI_DECREMENT(AxisMaxFeedrate_mm_s, X); break;
    case  3: UI_INCREMENT(AxisMaxFeedrate_mm_s, X); break;
    case  4: UI_DECREMENT(AxisMaxFeedrate_mm_s, Y); break;
    case  5: UI_INCREMENT(AxisMaxFeedrate_mm_s, Y); break;
    case  6: UI_DECREMENT(AxisMaxFeedrate_mm_s, Z); break;
    case  7: UI_INCREMENT(AxisMaxFeedrate_mm_s, Z); break;
    #if DISTINCT_E
      case  8: UI_DECREMENT(AxisMaxFeedrate_mm_s, E0); break;
      case  9: UI_INCREMENT(AxisMaxFeedrate_mm_s, E0); break;
      #if DISTINCT_E > 1
        case 10: UI_DECREMENT(AxisMaxFeedrate_mm_s, E1); break;
        case 11: UI_INCREMENT(AxisMaxFeedrate_mm_s, E1); break;
        #if DISTINCT_E > 2
          case 12: UI_DECREMENT(AxisMaxFeedrate_mm_s, E2); break;
          case 13: UI_INCREMENT(AxisMaxFeedrate_mm_s, E2); break;
          #if DISTINCT_E > 3
            case 14: UI_DECREMENT(AxisMaxFeedrate_mm_s, E3); break;
            case 15: UI_INCREMENT(AxisMaxFeedrate_mm_s, E3); break;
          #endif
        #endif
      #endif
    #endif
    default: return false;
  }
  SaveSettingsDialogBox::settingsChanged();
  return true;
}

#endif // FTDI_MAX_VELOCITY_SCREEN
