/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

#include "../../../../inc/MarlinConfigPre.h"

#if ENABLED(DGUS_LCD_UI_E3S1PRO)

#include "DGUS_VPList.h"

#include "../config/DGUS_Addr.h"
#include "../DGUSScreenHandler.h"
#include "../DGUSReturnKeyCodeHandler.h"
#include "../DGUSRxHandler.h"
#include "../DGUSTxHandler.h"

#include "../../ui_api.h"

const char DGUS_MACHINENAME[] PROGMEM = MACHINE_NAME;
const char DGUS_MARLINVERSION[] PROGMEM = SHORT_BUILD_VERSION;
const char DGUS_BOARD[] PROGMEM = BOARD_INFO_NAME;
const char DGUS_BEDSIZE[] PROGMEM = DGUS_BED_SIZE_STR;
const char DGUS_WEBSITE[] PROGMEM = "http://marlinfw.org";
const uint16_t DGUS_ZERO = 0;

#define VP_HELPER(ADDR, SIZE, FLAGS, EXTRA, RXHANDLER, TXHANDLER) \
  { .addr = ADDR, \
  .size = SIZE, \
  .flags = FLAGS, \
  .extra = EXTRA, \
  .rx_handler = RXHANDLER, \
  .tx_handler = TXHANDLER }

#define VP_HELPER_WORD(ADDR, FLAGS, EXTRA, RXHANDLER, TXHANDLER) \
  VP_HELPER(ADDR, 2, FLAGS, EXTRA, RXHANDLER, TXHANDLER)

#define VP_HELPER_DWORD(ADDR, FLAGS, EXTRA, RXHANDLER, TXHANDLER) \
  VP_HELPER(ADDR, 4, FLAGS, EXTRA, RXHANDLER, TXHANDLER)

#define VP_HELPER_RX(ADDR, RXHANDLER) \
  VP_HELPER_WORD(ADDR, VPFLAG_NONE, nullptr, RXHANDLER, nullptr)

#define VP_HELPER_RX_EXTRA(ADDR, EXTRA, RXHANDLER) \
  VP_HELPER_WORD(ADDR, VPFLAG_NONE, EXTRA, RXHANDLER, nullptr)

#define VP_HELPER_RX_NODATA(ADDR, RXHANDLER) \
  VP_HELPER(ADDR, 0, VPFLAG_NONE, nullptr, RXHANDLER, nullptr)

#define VP_HELPER_TX(ADDR, TXHANDLER) \
  VP_HELPER_WORD(ADDR, VPFLAG_NONE, nullptr, nullptr, TXHANDLER)

#define VP_HELPER_TX_SIZE(ADDR, SIZE, TXHANDLER) \
  VP_HELPER(ADDR, SIZE, VPFLAG_NONE, nullptr, nullptr, TXHANDLER)

#define VP_HELPER_TX_EXTRA(ADDR, EXTRA, TXHANDLER) \
  VP_HELPER_WORD(ADDR, VPFLAG_NONE, EXTRA, nullptr, TXHANDLER)

#define VP_HELPER_TX_AUTO(ADDR, EXTRA, TXHANDLER) \
  VP_HELPER_WORD(ADDR, VPFLAG_AUTOUPLOAD, EXTRA, nullptr, TXHANDLER)

#define VP_HELPER_LANG_ICON(ADDR) \
  VP_HELPER_TX_EXTRA(ADDR, &screen.config.language, (&DGUSTxHandler::extraToInteger<uint16_t>))

#define VP_HELPER_FILENAME(ADDR, filenameIndex) \
  VP_HELPER(ADDR, DGUS_FILENAME_LEN, VPFLAG_TXSTRING_AUTOSCROLL, \
  VP_EXTRA_TO_STR(DGUS_SDCardHandler::filenames[filenameIndex]), \
  nullptr, DGUSTxHandler::extraToString)

const struct DGUS_VP vp_list[] PROGMEM = {
  VP_HELPER_TX_AUTO(  DGUS_Addr::BOOT_Logo,
                        nullptr,
                        &DGUSTxHandler::bootAnimation),
  VP_HELPER_RX(       DGUS_Addr::CMD_MenuSelect,
                        &DGUSReturnKeyCodeHandler::Command_MenuSelect),
  VP_HELPER_RX(       DGUS_Addr::CMD_Adjust,
                        &DGUSReturnKeyCodeHandler::Command_Adjust),
  VP_HELPER_WORD(     DGUS_Addr::MAIN_PrintSpeedPercentage,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        &DGUSRxHandler::printSpeedPercentage,
                        &DGUSTxHandler::printSpeedPercentage),
  VP_HELPER_RX(       DGUS_Addr::CMD_CheckKO,
                        &DGUSReturnKeyCodeHandler::Command_CheckKO),
  VP_HELPER_RX(       DGUS_Addr::CMD_StopPause,
                        &DGUSReturnKeyCodeHandler::Command_StopPause),
  VP_HELPER_RX(       DGUS_Addr::CMD_CheckOK,
                        &DGUSReturnKeyCodeHandler::Command_CheckOK),
  VP_HELPER_TX_AUTO(  DGUS_Addr::MAIN_Icon_Percentage, nullptr,
                        &DGUSTxHandler::printPercentage),
  VP_HELPER_TX_AUTO(  DGUS_Addr::MAIN_ElapsedHours,
                        nullptr,
                        &DGUSTxHandler::elapsedHours),
  VP_HELPER_TX_AUTO(  DGUS_Addr::MAIN_ElapsedMinutes,
                        nullptr,
                        &DGUSTxHandler::elapsedMinutes),
  VP_HELPER_TX_AUTO(  DGUS_Addr::MAIN_PrintPercentage,
                        nullptr,
                        &DGUSTxHandler::printPercentage),
  VP_HELPER_WORD(       DGUS_Addr::MAIN_ZOffset,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        &DGUSRxHandler::zOffset,
                        &DGUSTxHandler::zOffset),
  VP_HELPER_RX(       DGUS_Addr::CMD_PresetControl,
                        &DGUSReturnKeyCodeHandler::Command_PresetControl),
  VP_HELPER_RX(       DGUS_Addr::CMD_TemperatureControl,
                        &DGUSReturnKeyCodeHandler::Control_TemperatureCommand),
  VP_HELPER_WORD(     DGUS_Addr::MAIN_ExtruderTargetTemp,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        &DGUSRxHandler::extruderTargetTemp,
                        &DGUSTxHandler::extruderTargetTemp),
  VP_HELPER_TX_AUTO(  DGUS_Addr::MAIN_ExtruderCurrentTemp,
                        nullptr,
                        &DGUSTxHandler::extruderCurrentTemp),
  VP_HELPER_WORD(     DGUS_Addr::MAIN_BedTargetTemp,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        &DGUSRxHandler::bedTargetTemp,
                        &DGUSTxHandler::bedTargetTemp),
  VP_HELPER_TX_AUTO(  DGUS_Addr::MAIN_BedCurrentTemp,
                        nullptr,
                        &DGUSTxHandler::bedCurrentTemp),
  VP_HELPER_RX(       DGUS_Addr::CMD_SettingsMenu,
                        &DGUSReturnKeyCodeHandler::Command_SettingsMenu),
  VP_HELPER_RX(       DGUS_Addr::CMD_Leveling,
                        &DGUSReturnKeyCodeHandler::Command_Leveling),
  VP_HELPER_RX(       DGUS_Addr::CMD_AxisControl,
                        &DGUSReturnKeyCodeHandler::Command_AxisControl),
  VP_HELPER_WORD(     DGUS_Addr::AXIS_X,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        &DGUSRxHandler::axis_X,
                        &DGUSTxHandler::axis_X),
  VP_HELPER_WORD(     DGUS_Addr::AXIS_Y,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        &DGUSRxHandler::axis_Y,
                        &DGUSTxHandler::axis_Y),
  VP_HELPER_WORD(     DGUS_Addr::AXIS_Z,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        &DGUSRxHandler::axis_Z,
                        &DGUSTxHandler::axis_Z),
  VP_HELPER_RX(       DGUS_Addr::IO_ExtrudeLength,
                        &DGUSRxHandler::extrudeLength),
  VP_HELPER_RX(       DGUS_Addr::IO_RetractLength,
                        &DGUSRxHandler::retractLength),
  VP_HELPER_RX(       DGUS_Addr::CMD_AxisIO,
                        &DGUSReturnKeyCodeHandler::Command_FilamentIO),
  VP_HELPER_RX(       DGUS_Addr::LANGUAGE_SetLanguage,
                        &DGUSRxHandler::setLanguage),
  VP_HELPER_RX(       DGUS_Addr::CMD_PowerLoss,
                        &DGUSReturnKeyCodeHandler::Command_PowerLoss),
  VP_HELPER_TX(       DGUS_Addr::LEVELING_Progress_Icon,
                        &DGUSTxHandler::levelingProgressIcon),
  #if HAS_FILAMENT_SENSOR
    VP_HELPER_TX_AUTO(  DGUS_Addr::FILAMENT_Icon_Inserted,
                          nullptr,
                          &DGUSTxHandler::filamentInsertionStatus),
  #endif
  VP_HELPER_WORD(     DGUS_Addr::TEMP_PLA_ExtruderTemp,
                        VPFLAG_NONE,
                        &screen.config.plaExtruderTemp,
                        &DGUSRxHandler::integerToExtra<uint16_t>,
                        &DGUSTxHandler::extraToInteger<uint16_t>),
  VP_HELPER_WORD(     DGUS_Addr::TEMP_PLA_BedTemp,
                        VPFLAG_NONE,
                        &screen.config.plaBedTemp,
                        &DGUSRxHandler::integerToExtra<uint16_t>,
                        &DGUSTxHandler::extraToInteger<uint16_t>),
  VP_HELPER_WORD(     DGUS_Addr::TEMP_ABS_ExtruderTemp,
                        VPFLAG_NONE,
                        &screen.config.absExtruderTemp,
                        &DGUSRxHandler::integerToExtra<uint16_t>,
                        &DGUSTxHandler::extraToInteger<uint16_t>),
  VP_HELPER_WORD(     DGUS_Addr::TEMP_ABS_BedTemp,
                        VPFLAG_NONE,
                        &screen.config.absBedTemp,
                        &DGUSRxHandler::integerToExtra<uint16_t>,
                        &DGUSTxHandler::extraToInteger<uint16_t>),
  VP_HELPER_RX(       DGUS_Addr::CMD_AdvancedSettings,
                        &DGUSReturnKeyCodeHandler::Command_AdvancedSettings),
  VP_HELPER_TX(       DGUS_Addr::LEVELING_Progress,
                        &DGUSTxHandler::levelingProgress),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_MaxSpeed_X,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxFeedrate<ExtUI::axis_t, ExtUI::X>),
                        (&DGUSTxHandler::maxFeedrate<ExtUI::axis_t, ExtUI::X>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_MaxSpeed_Y,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxFeedrate<ExtUI::axis_t, ExtUI::Y>),
                        (&DGUSTxHandler::maxFeedrate<ExtUI::axis_t, ExtUI::Y>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_MaxSpeed_Z,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxFeedrate<ExtUI::axis_t, ExtUI::Z>),
                        (&DGUSTxHandler::maxFeedrate<ExtUI::axis_t, ExtUI::Z>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_MaxSpeed_E,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxFeedrate<ExtUI::extruder_t, ExtUI::E0>),
                        (&DGUSTxHandler::maxFeedrate<ExtUI::extruder_t, ExtUI::E0>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_Acceleration_X,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxAcceleration<ExtUI::axis_t, ExtUI::X>),
                        (&DGUSTxHandler::maxAcceleration<ExtUI::axis_t, ExtUI::X>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_Acceleration_Y,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxAcceleration<ExtUI::axis_t, ExtUI::Y>),
                        (&DGUSTxHandler::maxAcceleration<ExtUI::axis_t, ExtUI::Y>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_Acceleration_Z,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxAcceleration<ExtUI::axis_t, ExtUI::Z>),
                        (&DGUSTxHandler::maxAcceleration<ExtUI::axis_t, ExtUI::Z>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_Acceleration_E,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxAcceleration<ExtUI::extruder_t, ExtUI::E0>),
                        (&DGUSTxHandler::maxAcceleration<ExtUI::extruder_t, ExtUI::E0>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_MaxJerk_X,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxJerk<ExtUI::axis_t, ExtUI::X>),
                        (&DGUSTxHandler::maxJerk<ExtUI::axis_t, ExtUI::X>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_MaxJerk_Y,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxJerk<ExtUI::axis_t, ExtUI::Y>),
                        (&DGUSTxHandler::maxJerk<ExtUI::axis_t, ExtUI::Y>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_MaxJerk_Z,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxJerk<ExtUI::axis_t, ExtUI::Z>),
                        (&DGUSTxHandler::maxJerk<ExtUI::axis_t, ExtUI::Z>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_MaxJerk_E,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::maxJerk<ExtUI::extruder_t, ExtUI::E0>),
                        (&DGUSTxHandler::maxJerk<ExtUI::extruder_t, ExtUI::E0>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_StepsPerMm_X,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::stepsPerMM<ExtUI::axis_t, ExtUI::X>),
                        (&DGUSTxHandler::stepsPerMM<ExtUI::axis_t, ExtUI::X>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_StepsPerMm_Y,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::stepsPerMM<ExtUI::axis_t, ExtUI::Y>),
                        (&DGUSTxHandler::stepsPerMM<ExtUI::axis_t, ExtUI::Y>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_StepsPerMm_Z,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::stepsPerMM<ExtUI::axis_t, ExtUI::Z>),
                        (&DGUSTxHandler::stepsPerMM<ExtUI::axis_t, ExtUI::Z>)),
  VP_HELPER_WORD(     DGUS_Addr::MOTION_StepsPerMm_E,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        (&DGUSRxHandler::stepsPerMM<ExtUI::extruder_t, ExtUI::E0>),
                        (&DGUSTxHandler::stepsPerMM<ExtUI::extruder_t, ExtUI::E0>)),
  #if ENABLED(PIDTEMP)
    VP_HELPER_WORD(     DGUS_Addr::PID_Extruder_P,
                          VPFLAG_AUTOUPLOAD,
                          nullptr,
                          (&DGUSRxHandler::PID_P<ExtUI::E0>),
                          (&DGUSTxHandler::PID_P<ExtUI::E0>)),
    VP_HELPER_WORD(     DGUS_Addr::PID_Extruder_I,
                          VPFLAG_AUTOUPLOAD,
                          nullptr,
                          (&DGUSRxHandler::PID_I<ExtUI::E0>),
                          (&DGUSTxHandler::PID_I<ExtUI::E0>)),
    VP_HELPER_WORD(     DGUS_Addr::PID_Extruder_D,
                          VPFLAG_AUTOUPLOAD,
                          nullptr,
                          (&DGUSRxHandler::PID_D<ExtUI::E0>),
                          (&DGUSTxHandler::PID_D<ExtUI::E0>)),
  #else
    VP_HELPER_WORD(     DGUS_Addr::PID_Extruder_P,
                          VPFLAG_AUTOUPLOAD,
                          const_cast<uint16_t*>(&DGUS_ZERO),
                          DGUSRxHandler::disabled,
                          (DGUSTxHandler::extraToFixedPoint<uint16_t, 2>)),
    VP_HELPER_WORD(     DGUS_Addr::PID_Extruder_I,
                          VPFLAG_AUTOUPLOAD,
                          const_cast<uint16_t*>(&DGUS_ZERO),
                          DGUSRxHandler::disabled,
                          (DGUSTxHandler::extraToFixedPoint<uint16_t, 2>)),
    VP_HELPER_WORD(     DGUS_Addr::PID_Extruder_D,
                          VPFLAG_AUTOUPLOAD,
                          const_cast<uint16_t*>(&DGUS_ZERO),
                          DGUSRxHandler::disabled,
                          (DGUSTxHandler::extraToFixedPoint<uint16_t, 2>)),
  #endif // PIDTEMP
  #if ENABLED(PIDTEMPBED)
    VP_HELPER_WORD(     DGUS_Addr::PID_Bed_P,
                          VPFLAG_AUTOUPLOAD,
                          nullptr,
                          (&DGUSRxHandler::bed_PID_P),
                          (&DGUSTxHandler::bed_PID_P)),
    VP_HELPER_WORD(     DGUS_Addr::PID_Bed_I,
                          VPFLAG_AUTOUPLOAD,
                          nullptr,
                          (&DGUSRxHandler::bed_PID_I),
                          (&DGUSTxHandler::bed_PID_I)),
    VP_HELPER_WORD(     DGUS_Addr::PID_Bed_D,
                          VPFLAG_AUTOUPLOAD,
                          nullptr,
                          (&DGUSRxHandler::bed_PID_D),
                          (&DGUSTxHandler::bed_PID_D)),
  #else
    VP_HELPER_WORD(     DGUS_Addr::PID_Bed_P,
                          VPFLAG_AUTOUPLOAD,
                          const_cast<uint16_t*>(&DGUS_ZERO),
                          DGUSRxHandler::disabled,
                          (DGUSTxHandler::extraToFixedPoint<uint16_t, 2>)),
    VP_HELPER_WORD(     DGUS_Addr::PID_Bed_I,
                          VPFLAG_AUTOUPLOAD,
                          const_cast<uint16_t*>(&DGUS_ZERO),
                          DGUSRxHandler::disabled,
                          (DGUSTxHandler::extraToFixedPoint<uint16_t, 2>)),
    VP_HELPER_WORD(     DGUS_Addr::PID_Bed_D,
                          VPFLAG_AUTOUPLOAD,
                          const_cast<uint16_t*>(&DGUS_ZERO),
                          DGUSRxHandler::disabled,
                          (DGUSTxHandler::extraToFixedPoint<uint16_t, 2>)),
  #endif // PIDTEMPBED
  VP_HELPER_WORD(     DGUS_Addr::CONTROL_FanSpeed,
                        VPFLAG_AUTOUPLOAD,
                        nullptr,
                        &DGUSRxHandler::fanSpeed,
                        &DGUSTxHandler::fanSpeed),
  VP_HELPER_TX(       DGUS_Addr::SDCard_InsertionStatus,
                      DGUSTxHandler::sdCardInsertionStatus),
  VP_HELPER_LANG_ICON(DGUS_Addr::FINISH_Icon_Finished),
  VP_HELPER_TX_AUTO(  DGUS_Addr::MAIN_RemainingHours,
                        nullptr,
                        &DGUSTxHandler::printRemainingHours),
  VP_HELPER_TX_AUTO(  DGUS_Addr::MAIN_RemainingMinutes,
                        nullptr,
                        &DGUSTxHandler::printRemainingMinutes),
  VP_HELPER_TX_AUTO(  DGUS_Addr::AXIS_StepperStatus,
                        nullptr,
                        &DGUSTxHandler::stepperStatus),
  VP_HELPER_LANG_ICON(DGUS_Addr::MENU_Icon_Home_S),
  VP_HELPER_LANG_ICON(DGUS_Addr::MENU_Icon_Print_S),
  VP_HELPER_LANG_ICON(DGUS_Addr::MENU_Icon_Ready_S),
  VP_HELPER_LANG_ICON(DGUS_Addr::MENU_Icon_Settings_S),
  VP_HELPER_LANG_ICON(DGUS_Addr::MENU_Icon_Home),
  VP_HELPER_LANG_ICON(DGUS_Addr::MENU_Icon_Print),
  VP_HELPER_LANG_ICON(DGUS_Addr::MENU_Icon_Ready),
  VP_HELPER_LANG_ICON(DGUS_Addr::MENU_Icon_Settings),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADJUST_Icon_Adjust),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADJUST_Icon_Feedrate),
  VP_HELPER_LANG_ICON(DGUS_Addr::IO_Icon_ExtruderTemp),
  VP_HELPER_LANG_ICON(DGUS_Addr::CONTROL_Icon_BedTemp),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADJUST_Icon_ZOffset),
  VP_HELPER_LANG_ICON(DGUS_Addr::CONTROL_Icon_FanControl),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADJUST_Icon_FanControl),
  VP_HELPER_LANG_ICON(DGUS_Addr::AXIS_Icon_MoveAxis),
  VP_HELPER_LANG_ICON(DGUS_Addr::AXIS_Icon_IO),
  VP_HELPER_LANG_ICON(DGUS_Addr::AXIS_Icon_Manual),
  VP_HELPER_LANG_ICON(DGUS_Addr::CONTROL_Icon_Cooling),
  VP_HELPER_LANG_ICON(DGUS_Addr::IO_Icon_Extrude),
  VP_HELPER_LANG_ICON(DGUS_Addr::IO_Icon_Retract),
  VP_HELPER_LANG_ICON(DGUS_Addr::SETTINGS_Icon_Language),
  VP_HELPER_LANG_ICON(DGUS_Addr::SETTINGS_Icon_Leveling),
  VP_HELPER_LANG_ICON(DGUS_Addr::SETTINGS_Icon_Device),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_ResetSettings),
  VP_HELPER_LANG_ICON(DGUS_Addr::INFO_Icon_About),
  VP_HELPER_LANG_ICON(DGUS_Addr::INFO_Icon_Device),
  VP_HELPER_LANG_ICON(DGUS_Addr::SETTINGS_Icon_Advanced),
  VP_HELPER_LANG_ICON(DGUS_Addr::SETTINGS_Icon_About),
  VP_HELPER_LANG_ICON(DGUS_Addr::SETTINGS_Icon_PLA),
  VP_HELPER_LANG_ICON(DGUS_Addr::SETTINGS_Icon_ABS),
  VP_HELPER_LANG_ICON(DGUS_Addr::RUNOUT_Icon_Stop),
  VP_HELPER_LANG_ICON(DGUS_Addr::RUNOUT_Icon_Message),
  VP_HELPER_LANG_ICON(DGUS_Addr::RESET_Icon_Yes),
  VP_HELPER_LANG_ICON(DGUS_Addr::RESET_Icon_No),
  VP_HELPER_LANG_ICON(DGUS_Addr::LOAD_Icon_Message),
  VP_HELPER_LANG_ICON(DGUS_Addr::LOAD_Icon_Continue),
  VP_HELPER_LANG_ICON(DGUS_Addr::PAUSE_Icon_Message),
  VP_HELPER_LANG_ICON(DGUS_Addr::RESUME_Icon_Message),
  VP_HELPER_LANG_ICON(DGUS_Addr::POWERLOSS_Icon_Message),
  VP_HELPER_LANG_ICON(DGUS_Addr::AUTOHOME_Icon_WaitMessage),
  VP_HELPER_LANG_ICON(DGUS_Addr::LEVELING_Icon_Leveling),
  VP_HELPER_LANG_ICON(DGUS_Addr::LEVELING_Icon_Start),
  VP_HELPER_LANG_ICON(DGUS_Addr::LEVELING_Icon_AuxLevel),
  VP_HELPER_LANG_ICON(DGUS_Addr::LEVELING_Icon_AutoLevel),
  VP_HELPER_LANG_ICON(DGUS_Addr::LEVELING_Icon_AuxLevel_S),
  VP_HELPER_LANG_ICON(DGUS_Addr::LEVELING_Icon_AutoLevel_S),
  VP_HELPER_LANG_ICON(DGUS_Addr::LANGUAGE_Icon_Language),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_Movement),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_PID),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MotionSettings),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MaxFeedrate),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_Acceleration),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_Jerk),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_StepsPerMm),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MaxSpeed),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MaxSpeed_X),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MaxSpeed_Y),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MaxSpeed_Z),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MaxSpeed_E),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_AccelerationMenu),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_Acceleration_X),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_Acceleration_Y),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_Acceleration_Z),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_Acceleration_E),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MaxJerkMenu),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MaxJerk_X),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MaxJerk_Y),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MaxJerk_Z),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_MaxJerk_E),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_StepsPerMmMenu),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_StepsPerMm_X),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_StepsPerMm_Y),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_StepsPerMm_Z),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_StepsPerMm_E),
  VP_HELPER_LANG_ICON(DGUS_Addr::PID_Icon_PIDMenu),
  VP_HELPER_LANG_ICON(DGUS_Addr::PID_Icon_Extruder_P),
  VP_HELPER_LANG_ICON(DGUS_Addr::PID_Icon_Extruder_I),
  VP_HELPER_LANG_ICON(DGUS_Addr::PID_Icon_Extruder_D),
  VP_HELPER_LANG_ICON(DGUS_Addr::PID_Icon_Bed_P),
  VP_HELPER_LANG_ICON(DGUS_Addr::PID_Icon_Bed_I),
  VP_HELPER_LANG_ICON(DGUS_Addr::PID_Icon_Bed_D),
  VP_HELPER_LANG_ICON(DGUS_Addr::CUTTER_Icon_Message),
  VP_HELPER_LANG_ICON(DGUS_Addr::FDM_Icon_Message),
  VP_HELPER_LANG_ICON(DGUS_Addr::ADV_Icon_SwitchToLaser),
  VP_HELPER_LANG_ICON(DGUS_Addr::PRTMODE_Icon_Message),
  VP_HELPER_LANG_ICON(DGUS_Addr::PRTMODE_Icon_FDM),
  VP_HELPER_LANG_ICON(DGUS_Addr::PRTMODE_Icon_Cutter),
  VP_HELPER_LANG_ICON(DGUS_Addr::INFO_Icon_Model),
  VP_HELPER_LANG_ICON(DGUS_Addr::INFO_Icon_FW_Version),
  VP_HELPER_LANG_ICON(DGUS_Addr::INFO_Icon_Screen_Version),
  VP_HELPER_LANG_ICON(DGUS_Addr::INFO_Icon_HW_Version),
  VP_HELPER_LANG_ICON(DGUS_Addr::INFO_Icon_Website),
  VP_HELPER_LANG_ICON(DGUS_Addr::INFO_Icon_Print_Size),
  VP_HELPER_TX_AUTO(  DGUS_Addr::LANGUAGE_Icon_Chinese,
                        (void*)DGUS_Data::Language::Chinese_Simplified,
                        &DGUSTxHandler::enableIfLanguageMatchesExtra),
  VP_HELPER_TX_AUTO(  DGUS_Addr::LANGUAGE_Icon_English,
                        (void*)DGUS_Data::Language::English,
                        &DGUSTxHandler::enableIfLanguageMatchesExtra),
  VP_HELPER_TX_AUTO(  DGUS_Addr::LANGUAGE_Icon_German,
                        (void*)DGUS_Data::Language::German,
                        &DGUSTxHandler::enableIfLanguageMatchesExtra),
  VP_HELPER_TX_AUTO(  DGUS_Addr::LANGUAGE_Icon_Spanish,
                        (void*)DGUS_Data::Language::Spanish,
                        &DGUSTxHandler::enableIfLanguageMatchesExtra),
  VP_HELPER_TX_AUTO(  DGUS_Addr::LANGUAGE_Icon_French,
                        (void*)DGUS_Data::Language::French,
                        &DGUSTxHandler::enableIfLanguageMatchesExtra),
  VP_HELPER_TX_AUTO(  DGUS_Addr::LANGUAGE_Icon_Italian,
                        (void*)DGUS_Data::Language::Italian,
                        &DGUSTxHandler::enableIfLanguageMatchesExtra),
  VP_HELPER_TX_AUTO(  DGUS_Addr::LANGUAGE_Icon_Portuguese,
                        (void*)DGUS_Data::Language::Portuguese,
                        &DGUSTxHandler::enableIfLanguageMatchesExtra),
  VP_HELPER_TX_AUTO(  DGUS_Addr::LANGUAGE_Icon_Russian,
                        (void*)DGUS_Data::Language::Russian,
                        &DGUSTxHandler::enableIfLanguageMatchesExtra),
  VP_HELPER_TX_AUTO(  DGUS_Addr::LANGUAGE_Icon_Turkish,
                        (void*)DGUS_Data::Language::Turkish,
                        &DGUSTxHandler::enableIfLanguageMatchesExtra),

  VP_HELPER(          DGUS_Addr::INFO_Model,
                        DGUS_INFOSTRING_LEN,
                        VPFLAG_TXSTRING_AUTOSCROLL,
                        VP_EXTRA_TO_STR(DGUS_MACHINENAME),
                        nullptr,
                        DGUSTxHandler::extraToString),
  VP_HELPER(          DGUS_Addr::INFO_FW_Version,
                        DGUS_INFOSTRING_LEN,
                        VPFLAG_TXSTRING_AUTOSCROLL,
                        VP_EXTRA_TO_STR(DGUS_MARLINVERSION),
                        nullptr,
                        DGUSTxHandler::extraToString),
  //already set in the screen memory:
  /*
  VP_HELPER(DGUS_Addr::INFO_Screen_Version,
                        DGUS_INFOSTRING_LEN,
                        VPFLAG_NONE,
                        (void*)"",
                        nullptr,
                        DGUSTxHandler::extraToString),
  */
  VP_HELPER(          DGUS_Addr::INFO_HW_Version,
                        DGUS_INFOSTRING_LEN,
                        VPFLAG_TXSTRING_AUTOSCROLL,
                        VP_EXTRA_TO_STR(DGUS_BOARD),
                        nullptr,
                        DGUSTxHandler::extraToString),
  VP_HELPER(          DGUS_Addr::INFO_Print_Size,
                        DGUS_INFOSTRING_LEN,
                        VPFLAG_TXSTRING_AUTOSCROLL,
                        VP_EXTRA_TO_STR(DGUS_BEDSIZE),
                        nullptr,
                        DGUSTxHandler::extraToString),
  VP_HELPER(          DGUS_Addr::INFO_Website,
                        DGUS_INFOSTRING_LEN,
                        VPFLAG_TXSTRING_AUTOSCROLL,
                        VP_EXTRA_TO_STR(DGUS_WEBSITE),
                        nullptr,
                        DGUSTxHandler::extraToString),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename1,
                        0),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename2,
                        1),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename3,
                        2),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename4,
                        3),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename5,
                        4),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename6,
                        0),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename7,
                        1),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename8,
                        2),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename9,
                        3),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename10,
                        4),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename11,
                        0),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename12,
                        1),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename13,
                        2),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename14,
                        3),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename15,
                        4),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename16,
                        0),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename17,
                        1),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename18,
                        2),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename19,
                        3),
  VP_HELPER_FILENAME( DGUS_Addr::SDCARD_Filename20,
                        4),
  VP_HELPER_RX(       DGUS_Addr::CMD_FilelistControl,
                        &DGUSReturnKeyCodeHandler::Command_FilelistControl),
  VP_HELPER_RX(       DGUS_Addr::SDCARD_FileSelection,
                        &DGUSRxHandler::sdCardFileSection),
  VP_HELPER(          DGUS_Addr::MAIN_StatusMessage,
                        DGUS_INFOSTRING_LEN,
                        VPFLAG_TXSTRING_AUTOSCROLL,
                        VP_EXTRA_TO_STR(screen.homeStatusMessage),
                        nullptr,
                        DGUSTxHandler::extraToString),
  VP_HELPER(          DGUS_Addr::ABNORMAL_StatusMessage,
                        DGUS_INFOSTRING_LEN,
                        VPFLAG_TXSTRING_AUTOSCROLL,
                        VP_EXTRA_TO_STR(screen.homeStatusMessage),
                        nullptr,
                        DGUSTxHandler::extraToString),
  VP_HELPER_RX(       DGUS_Addr::CMD_LaserControl,
                        &DGUSReturnKeyCodeHandler::Command_LaserControl),
  VP_HELPER((DGUS_Addr)0, 0, VPFLAG_NONE, nullptr, nullptr, nullptr)
};

#endif // DGUS_LCD_UI_E3S1PRO
