/**
 * Marlin 3D Printer Firmware
 * Copyright (c) 2023 MarlinFirmware [https://github.com/MarlinFirmware/Marlin]
 *
 * Based on Sprinter and grbl.
 * Copyright (c) 2011 Camiel Gubbels / Erik van der Zalm
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#pragma once

#include <inttypes.h>

enum class DGUS_Control : uint8_t {
  // FILE1
  FILE1_File1     = 4, // RETURN_KEY_CODE
  FILE1_File2     = 3, // RETURN_KEY_CODE
  FILE1_File3     = 2, // RETURN_KEY_CODE
  FILE1_File4     = 1, // RETURN_KEY_CODE
  FILE1_File5     = 0, // RETURN_KEY_CODE
  FILE1_Start     = 8, // RETURN_KEY_CODE
  FILE1_End       = 7, // RETURN_KEY_CODE
  FILE1_Prev      = 5, // RETURN_KEY_CODE
  FILE1_Next      = 6, // RETURN_KEY_CODE
  FILE1_Home      = 9, // RETURN_KEY_CODE
  FILE1_Print     = 12, // RETURN_KEY_CODE
  FILE1_Ready     = 10, // RETURN_KEY_CODE
  FILE1_Settings  = 11, // RETURN_KEY_CODE
};
