#line 2 "scanner.cpp"

#line 4 "scanner.cpp"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

    /* The c++ scanner is a mess. The FlexLexer.h header file relies on the
     * following macro. This is required in order to pass the c++-multiple-scanners
     * test in the regression suite. We get reports that it breaks inheritance.
     * We will address this in a future release of flex, or omit the C++ scanner
     * altogether.
     */
    #define yyFlexLexer yyFlexLexer

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */
#include <iostream> 
#include <errno.h>
#include <cstdlib>
#include <cstring>
/* end standard C++ headers. */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int yyleng;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{

	std::istream* yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

#define yytext_ptr yytext

#include <FlexLexer.h>

int yyFlexLexer::yywrap() { return 1; }

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 68
#define YY_END_OF_BUFFER 69
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[280] =
    {   0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   60,   60,   61,   61,   43,   43,   43,   43,
       33,   33,   23,   23,   28,   28,   38,   38,   69,   67,
       67,   67,   20,   18,   19,   19,   20,    5,   20,   20,
       20,   20,   10,   20,   20,   20,   20,   20,   15,    2,
        3,    3,    7,    8,    8,   67,   12,   13,   13,   52,
       41,   42,   42,   52,   54,   55,   55,   58,   59,   67,
       57,   56,   66,   60,   62,   62,   63,   67,   61,   67,
       64,   43,   44,   44,   48,   53,   47,   53,   46,   45,

       53,   33,   34,   34,   32,   35,   23,   24,   24,   67,
       28,   29,   29,   67,   38,   39,   39,   38,   67,   67,
        0,   18,   19,    0,    0,    0,    0,    0,   17,    0,
        0,    0,    0,    0,    0,    2,    3,    7,    8,   12,
       13,   41,   42,   51,   49,    0,   54,   55,   65,   57,
       60,    0,   62,    0,    0,   61,    0,    0,    0,   43,
        0,   44,    0,    0,   51,    0,    0,   45,   33,   34,
       23,    0,   24,   24,   24,    0,   28,    0,   29,   29,
       29,    0,   38,   38,    0,   39,   39,   39,   40,    0,
        0,    0,    0,    0,   11,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,   49,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,   43,    0,    0,
       50,    0,   25,    0,   30,    0,    0,    0,    0,    0,
        0,    0,   16,   22,    0,    0,    0,    0,    0,    0,
       43,   21,    0,   50,    0,    0,    1,    0,    6,    0,
        0,    0,    0,   37,    0,   36,    0,    0,    0,    0,
        0,    0,    4,    0,    0,    0,    0,    0,    9,    0,
        0,    0,    0,    0,   31,   27,   26,   14,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    1,    1,    8,    9,    1,
        1,    1,    1,    1,   10,   11,   12,   13,   14,   13,
       13,   13,   13,   13,   13,   13,   13,   15,   16,   17,
       18,   19,   20,    1,   21,   22,   23,   24,   25,   22,
       26,   26,   26,   26,   26,   26,   26,   26,   27,   28,
       26,   26,   26,   29,   26,   26,   26,   26,   30,   26,
       31,    1,   32,    1,   33,    1,   34,   22,   35,   36,

       37,   22,   38,   26,   39,   26,   26,   40,   41,   42,
       43,   26,   26,   44,   45,   46,   26,   47,   26,   48,
       49,   26,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[50] =
    {   0,
        1,    1,    2,    2,    3,    4,    5,    1,    6,    7,
        7,    1,    8,    8,    9,   10,   11,    1,   12,    3,
       13,   13,   13,   13,   13,   14,   14,   14,   14,   14,
        1,   15,   16,   13,   13,   13,   13,   14,   14,   14,
       14,   14,   14,   14,   14,   14,   14,   14,   14
    } ;

static yyconst flex_int16_t yy_base[317] =
    {   0,
        0,    1,    4,    7,   10,   17,   20,   28,   53,   97,
      141,  185,   36,   39,   43,   46,   65,   72,   76,   79,
      230,    0,  101,  108,  118,  120,  277,  307,  337,  367,
       91,  129,  148,  150,   12,   57,  136,  159,  749,  846,
      714,  681,  846,  683,  846,  676,  641,  846,  655,  652,
        0,    0,  846,  644,  620,  615,   16,   28,  846,  657,
      846,  655,  655,  846,  651,  632,  648,  846,  642,  846,
      641,  846,  638,   67,  636,  846,  632,  846,  846,  615,
        0,  846,  846,  625,  846,  628,  846,  623,  621,  615,
      846,  609,  846,  610,  846,  603,  846,  152,  846,  575,

      846,    0,  846,  603,  846,  846,  595,  846,  600,  163,
      570,  846,  598,  165,   33,  846,  591,  100,  173,  846,
      539,  583,  846,  538,  568,  567,  571,  563,  846,  534,
      534,  524,  528,  521,  526,  560,  846,  559,  846,  396,
      846,  395,  846,  171,    0,  348,  393,  846,  846,    0,
      386,  386,  846,  117,  376,  383,  383,  161,  373,  380,
      380,  846,  169,  369,  139,    0,  335,  350,    0,  846,
      371,  370,  846,  846,  376,  359,  345,  342,  846,  846,
      369,  181,  179,  187,  207,  846,  846,  365,  846,  284,
      326,  321,  201,  205,  846,  359,  355,  320,  320,  355,

      315,  350,  313,  347,  328,  330,    0,  311,  207,    0,
      335,  276,    0,  334,  284,    0,  333,  340,  337,  321,
        0,  301,  846,   65,  846,  298,  298,  298,  293,  215,
      300,  299,  846,  846,  311,  309,  292,  315,  313,  312,
      319,  846,  301,    0,  283,  193,  846,  279,  846,  275,
      278,  279,  284,  846,  274,  846,  251,  249,  244,  252,
      193,  187,  846,  170,  161,  162,  159,  150,  846,   96,
       88,   71,   57,   27,  846,  846,  846,  846,  846,  399,
      415,  431,  447,  463,  479,  495,  511,  527,  543,  305,
      307,  557,  567,  583,  595,  611,  623,  639,  651,  667,

      683,  699,  715,  731,  744,  755,  765,  775,  785,  795,
      803,   78,  128,  188,  819,  829
    } ;

static yyconst flex_int16_t yy_def[317] =
    {   0,
      280,  280,  281,  281,  281,  281,  281,  281,  281,  281,
      281,  281,  280,  280,  280,  280,  280,  280,  282,  282,
      279,   21,  283,  283,  284,  284,  285,  285,  285,  285,
      286,  286,  287,  287,  288,  288,  289,  289,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      290,  291,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  292,  279,  279,  279,  279,  279,  279,
      293,  279,  279,  294,  279,  279,  279,  295,  296,  297,
      279,  298,  279,  279,  279,  299,  279,  292,  279,  279,

      279,  300,  279,  279,  279,  279,  301,  279,  279,  301,
      302,  279,  279,  302,  303,  279,  279,  303,  304,  279,
      279,  279,  279,  279,  279,  279,  305,  306,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  307,  279,  279,  279,  279,  293,
      294,  295,  279,  279,  308,  296,  297,  279,  309,  298,
      299,  279,  279,  310,  279,  311,  279,  279,  300,  279,
      301,  301,  279,  279,  279,  279,  302,  302,  279,  279,
      279,  302,  303,  303,  304,  279,  279,  279,  279,  304,
      279,  279,  279,  279,  279,  305,  306,  279,  279,  279,

      279,  279,  279,  279,  279,  279,  307,  279,  279,  312,
      308,  279,  313,  309,  279,  314,  310,  315,  279,  279,
      316,  279,  279,  302,  279,  302,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  312,  313,  314,
      315,  279,  279,  316,  279,  302,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,    0,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,

      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279
    } ;

static yyconst flex_int16_t yy_nxt[896] =
    {   0,
      279,  279,  279,   41,   41,   44,   45,   46,   44,   45,
       46,   44,   45,   46,  112,  113,   42,   42,   44,   45,
       46,   44,   45,   46,  279,   49,  279,   48,   50,   44,
       45,   46,  279,   49,   48,  279,   50,   60,   61,   62,
       60,   61,   62,  114,   63,   64,   65,   63,   64,   65,
       47,  184,  185,   47,   44,   45,   46,  132,   51,  112,
      113,   52,   66,  278,  133,   66,   67,   68,   69,  134,
       53,  144,   54,   67,   68,   69,  135,   71,   72,   73,
       71,   72,   73,  279,   66,  238,  146,  277,  114,   55,
      238,   66,   74,  103,  104,   74,  246,   56,   44,   45,

       46,  276,   51,   85,   86,   52,   87,  105,   88,  106,
       85,   86,  275,   87,   53,   88,   54,   40,  184,  185,
       85,   86,   85,   86,   40,   90,   91,   90,   91,  209,
      209,  103,  104,   55,   40,  239,   40,  274,  116,  117,
      239,   56,   44,   45,   46,  105,   57,  106,  219,   58,
      108,  109,  108,  109,  118,  119,  165,  110,   59,  110,
       54,  116,  117,  166,  210,  174,  175,  180,  181,  220,
      273,  167,  176,  212,  212,  187,  188,  118,  119,  272,
      204,  215,  215,  180,  181,   56,   44,   45,   46,  271,
       57,  189,  190,   58,  205,  240,  182,  184,  185,  225,

      240,  206,   59,  270,   54,  184,  185,  269,  213,  279,
      279,  279,  226,  229,  229,  268,  216,  230,  230,  209,
      209,  267,  151,  249,  246,  279,  185,  230,  230,   56,
       40,   75,   76,   77,   40,   78,   40,   40,   79,   40,
       40,   80,   40,   40,   81,   40,   40,   82,   83,   40,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   81,
       40,   40,   81,   81,   81,   81,   81,   81,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   81,   93,
       94,  266,   95,  265,   96,   97,  187,  188,  212,  212,
      264,  156,  263,   98,  262,   99,  215,  215,  249,  218,

      180,  181,  189,  190,  261,  229,  229,  260,  100,   93,
       94,  259,   95,  258,   96,   97,  225,  127,  127,  128,
      128,  257,  256,   98,  255,   99,  161,  218,  156,  226,
      151,  254,  253,  252,  251,  250,  248,  247,  100,   93,
       94,  245,   95,  243,   96,   97,  242,  161,  218,  156,
      151,  237,  236,   98,  235,  101,  234,  202,  233,  200,
      233,  232,  231,  195,  195,  228,  227,  187,  100,   93,
       94,  180,   95,  224,   96,   97,  178,  223,  174,  279,
      172,  168,  222,   98,  218,  101,  163,  161,  156,  158,
      157,  151,  154,  152,  147,  208,  142,  140,  100,   40,

       40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
       40,   40,   40,   40,   40,   43,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   43,   43,   43,   43,   43,
       43,   70,   70,   70,   70,   70,   70,   70,   70,   70,
       70,   70,   70,   70,   70,   70,   70,   84,   84,   84,
       84,   84,   84,   84,   84,   84,   84,   84,   84,   84,
       84,   84,   84,   89,   89,   89,   89,   89,   89,   89,
       89,   89,   89,   89,   89,   89,   89,   89,   89,   92,
       92,   92,   92,   92,   92,   92,   92,   92,   92,   92,
       92,   92,   92,   92,   92,  102,  102,  102,  102,  102,

      102,  102,  102,  102,  102,  102,  102,  102,  102,  102,
      102,  107,  107,  107,  107,  107,  107,  107,  107,  107,
      107,  107,  107,  107,  107,  107,  107,  111,  111,  111,
      111,  111,  111,  111,  111,  111,  111,  111,  111,  111,
      111,  111,  111,  115,  115,  115,  115,  115,  115,  115,
      115,  115,  115,  115,  115,  115,  115,  115,  115,  145,
      138,  136,  203,  202,  201,  145,  200,  199,  198,  145,
      145,  195,  145,  150,  150,  150,  195,  194,  193,  150,
      150,  192,  150,  151,  122,  151,  191,  151,  151,  151,
      151,  151,  151,  186,  151,  151,  151,  151,  151,  155,

      179,  178,  173,  155,  172,  170,  168,  155,  155,  163,
      155,  156,  162,  156,  156,  156,  161,  156,  156,  156,
      156,  158,  156,  156,  156,  156,  156,  159,  157,  154,
      153,  159,  152,  149,  148,  159,  159,  147,  159,  160,
      143,  160,  142,  160,  141,  160,  160,  160,  160,  140,
      129,  160,  160,  139,  160,  164,  138,  137,  136,  164,
      131,  130,  129,  164,  164,  126,  164,  169,  125,  169,
      169,  169,  169,  169,  169,  169,  169,  124,  123,  169,
      169,  169,  169,  171,  122,  171,  171,  171,  171,  171,
      171,  171,  171,  171,  171,  171,  171,  171,  171,  177,

      121,  177,  177,  177,  177,  177,  177,  177,  177,  177,
      177,  177,  177,  177,  177,  183,  120,  183,  183,  183,
      183,  183,  183,  183,  183,  183,  183,  183,  183,  183,
      183,  184,  184,  184,  184,  184,  184,  184,  184,  184,
      184,  184,  184,  184,  184,  184,  184,  196,  279,  279,
      196,  196,  279,  279,  279,  279,  196,  196,  279,  196,
      197,  197,  197,  279,  279,  279,  279,  197,  197,  279,
      197,  207,  207,  207,  279,  279,  279,  207,  207,  279,
      207,  211,  211,  211,  211,  279,  279,  211,  211,  279,
      211,  214,  214,  214,  214,  279,  279,  214,  214,  279,

      214,  217,  217,  217,  217,  279,  279,  217,  217,  279,
      217,  221,  279,  279,  279,  221,  221,  279,  221,  241,
      279,  241,  279,  241,  279,  241,  241,  241,  241,  279,
      279,  241,  241,  279,  241,  244,  244,  244,  279,  279,
      279,  244,  244,  279,  244,   39,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279

    } ;

static yyconst flex_int16_t yy_chk[896] =
    {   0,
        0,    0,    0,    1,    2,    3,    3,    3,    4,    4,
        4,    5,    5,    5,   35,   35,    1,    2,    6,    6,
        6,    7,    7,    7,    0,    7,    0,    5,    7,    8,
        8,    8,    0,    8,    6,    0,    8,   13,   13,   13,
       14,   14,   14,   35,   15,   15,   15,   16,   16,   16,
        3,  115,  115,    4,    9,    9,    9,   57,    9,   36,
       36,    9,   15,  274,   57,   16,   17,   17,   17,   58,
        9,   74,    9,   18,   18,   18,   58,   19,   19,   19,
       20,   20,   20,  224,   17,  312,   74,  273,   36,    9,
      312,   18,   19,   31,   31,   20,  224,    9,   10,   10,

       10,  272,   10,   23,   23,   10,   23,   31,   23,   31,
       24,   24,  271,   24,   10,   24,   10,   23,  118,  118,
       25,   25,   26,   26,   24,   25,   25,   26,   26,  154,
      154,   32,   32,   10,   25,  313,   26,  270,   37,   37,
      313,   10,   11,   11,   11,   32,   11,   32,  165,   11,
       33,   33,   34,   34,   37,   37,   98,   33,   11,   34,
       11,   38,   38,   98,  154,  110,  110,  114,  114,  165,
      268,   98,  110,  158,  158,  119,  119,   38,   38,  267,
      144,  163,  163,  182,  182,   11,   12,   12,   12,  266,
       12,  119,  119,   12,  144,  314,  114,  183,  183,  182,

      314,  144,   12,  265,   12,  184,  184,  264,  158,  185,
      185,  246,  182,  193,  193,  262,  163,  194,  194,  209,
      209,  261,  209,  230,  246,  185,  185,  230,  230,   12,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   27,
       27,  260,   27,  259,   27,   27,  190,  190,  212,  212,
      258,  212,  257,   27,  255,   27,  215,  215,  229,  215,

      226,  226,  190,  190,  253,  229,  229,  252,   27,   28,
       28,  251,   28,  250,   28,   28,  226,  290,  290,  291,
      291,  248,  245,   28,  243,   28,  241,  240,  239,  226,
      238,  237,  236,  235,  232,  231,  228,  227,   28,   29,
       29,  222,   29,  220,   29,   29,  219,  218,  217,  214,
      211,  208,  206,   29,  205,   29,  204,  203,  202,  201,
      200,  199,  198,  197,  196,  192,  191,  188,   29,   30,
       30,  181,   30,  178,   30,   30,  177,  176,  175,  172,
      171,  168,  167,   30,  164,   30,  161,  160,  159,  157,
      156,  155,  152,  151,  147,  146,  142,  140,   30,  280,

      280,  280,  280,  280,  280,  280,  280,  280,  280,  280,
      280,  280,  280,  280,  280,  281,  281,  281,  281,  281,
      281,  281,  281,  281,  281,  281,  281,  281,  281,  281,
      281,  282,  282,  282,  282,  282,  282,  282,  282,  282,
      282,  282,  282,  282,  282,  282,  282,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
      283,  283,  283,  284,  284,  284,  284,  284,  284,  284,
      284,  284,  284,  284,  284,  284,  284,  284,  284,  285,
      285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
      285,  285,  285,  285,  285,  286,  286,  286,  286,  286,

      286,  286,  286,  286,  286,  286,  286,  286,  286,  286,
      286,  287,  287,  287,  287,  287,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  287,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
      288,  288,  288,  289,  289,  289,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  289,  289,  289,  292,
      138,  136,  135,  134,  133,  292,  132,  131,  130,  292,
      292,  128,  292,  293,  293,  293,  127,  126,  125,  293,
      293,  124,  293,  294,  122,  294,  121,  294,  294,  294,
      294,  294,  294,  117,  294,  294,  294,  294,  294,  295,

      113,  111,  109,  295,  107,  104,  100,  295,  295,   96,
      295,  296,   94,  296,  296,  296,   92,  296,  296,  296,
      296,   90,  296,  296,  296,  296,  296,  297,   89,   88,
       86,  297,   84,   80,   77,  297,  297,   75,  297,  298,
       73,  298,   71,  298,   69,  298,  298,  298,  298,   67,
       66,  298,  298,   65,  298,  299,   63,   62,   60,  299,
       56,   55,   54,  299,  299,   50,  299,  300,   49,  300,
      300,  300,  300,  300,  300,  300,  300,   47,   46,  300,
      300,  300,  300,  301,   44,  301,  301,  301,  301,  301,
      301,  301,  301,  301,  301,  301,  301,  301,  301,  302,

       42,  302,  302,  302,  302,  302,  302,  302,  302,  302,
      302,  302,  302,  302,  302,  303,   41,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  304,  304,  304,  304,  304,  304,  304,  304,  304,
      304,  304,  304,  304,  304,  304,  304,  305,   39,    0,
      305,  305,    0,    0,    0,    0,  305,  305,    0,  305,
      306,  306,  306,    0,    0,    0,    0,  306,  306,    0,
      306,  307,  307,  307,    0,    0,    0,  307,  307,    0,
      307,  308,  308,  308,  308,    0,    0,  308,  308,    0,
      308,  309,  309,  309,  309,    0,    0,  309,  309,    0,

      309,  310,  310,  310,  310,    0,    0,  310,  310,    0,
      310,  311,    0,    0,    0,  311,  311,    0,  311,  315,
        0,  315,    0,  315,    0,  315,  315,  315,  315,    0,
        0,  315,  315,    0,  315,  316,  316,  316,    0,    0,
        0,  316,  316,    0,  316,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
      279,  279,  279,  279,  279

    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "scanner.l"
/*
    Copyright (C) 2010 Alexey Bobkov

    This file is part of Fb2toepub converter.

    Fb2toepub converter is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Fb2toepub converter is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Fb2toepub converter.  If not, see <http://www.gnu.org/licenses/>.
*/
#line 24 "scanner.l"
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include "scanner.h"
#include <vector>

namespace Fb2ToEpub
{
    static const LexScanner::Token  lt      (LexScanner::DATA, "&lt;", 4),
                                    gt      (LexScanner::DATA, "&gt;", 4),
                                    amp     (LexScanner::DATA, "&amp;", 5),
                                    apos    (LexScanner::DATA, "&apos;", 6),
                                    quot    (LexScanner::DATA, "&quot;", 6),
                                    unknown (LexScanner::DATA, "?", 1);

    //-----------------------------------------------------------------------
    class ScannerImpl : public Fb2ToEpub::LexScanner, public yyFlexLexer, Noncopyable
    {
        Ptr<InStm>	                stm_;
        strvector                   tagStack_;
        std::vector<Token>          tokenStack_;
        bool                        skipMode_;
        bool                        dataMode_;
        int                         doctypeCnt_;
        Loc                         loc_;
        int                         stateCaller_;
        bool                        attrHasValue_;
        Token                       last_;

        Token ScanToken();

        void ScanAndConcatenateTo(Token *t)
        {
            for(;;)     // concatenate all DATA together
            {
                Token t1 = ScanToken();
                t1.loc_ = loc_;

                if(t1.type_ != t->type_)
                {
                    UngetToken(t1);
                    return;
                }

                t->s_           += t1.s_;
                t->size_        += t1.size_;
                t->loc_.lstLn_  = t1.loc_.lstLn_;
                t->loc_.lstCol_ = t1.loc_.lstCol_;
            }
        }

        void NewLn()
        {
            ++loc_.lstLn_;
            loc_.lstCol_ = 1;
        }

        void OnError(const Loc &loc, const String &what)
        {
            ParserError(stm_->UIFileName(), loc, what);
        }

    protected:
        //virtual
        void LexerError(const char* msg)
        {
            ExternalError(msg);
        }

    public:
        explicit ScannerImpl(InStm *stm)
                            :   stm_            (stm),
                                skipMode_       (false),
                                dataMode_       (false),
                                doctypeCnt_     (0),
                                loc_            (1,1,1,1),
                                stateCaller_    (0),
                                attrHasValue_   (false),
                                last_           (STOP)
        {
        }

        //-----------------------------------------------------------------------
        //virtual
        const Token& GetToken()
        {
            while(tokenStack_.size())
            {
                Token t = tokenStack_.back();
                tokenStack_.pop_back();
                if(t.type_ != DATA || dataMode_)
                    return last_ = t;
            }

            Token t = ScanToken();
            t.loc_ = loc_;
            if(t.type_ == DATA || t.type_ == VALUE)
                ScanAndConcatenateTo(&t);

            return last_ = t;
        }
        
        //-----------------------------------------------------------------------
        //virtual
        void UngetToken(const Token &t)
        {
            tokenStack_.push_back(t);
        }

        //-----------------------------------------------------------------------
        //virtual
        bool SetSkipMode(bool newMode)
        {
            bool old = skipMode_;
            skipMode_ = newMode;
            return old;
        }

        //-----------------------------------------------------------------------
        //virtual
        bool SetDataMode(bool newMode)
        {
            bool old = dataMode_;
            dataMode_ = newMode;
            return old;
        }

        //-----------------------------------------------------------------------
        //virtual
        void Error(const String &what)
        {
            OnError(last_.loc_, what);
        }

        //-----------------------------------------------------------------------
        //virtual
        int LexerInput(char* buf, int max_size);
    };
};

static Fb2ToEpub::LexScanner::Token yyterminate()
{
    return Fb2ToEpub::LexScanner::STOP;
}
#define YY_USER_ACTION  {\
                            loc_.fstLn_ = loc_.lstLn_; \
                            loc_.fstCol_ = loc_.lstCol_; \
                            loc_.lstCol_ += yyleng; \
                            /*printf("line: %d state: %d act: %d len: %d \"%s\"\n", loc_.fstLn_, (YY_START), yy_act, yyleng, yytext);*/ \
                        }
#define YY_DECL	 Fb2ToEpub::LexScanner::Token Fb2ToEpub::ScannerImpl::ScanToken()

/*
 * The X<n>, X<n>_WS modes are used for XML header parsing.
 * The OUTSIDE mode is used outside XML top-level element.
 * The MARKUP, MARKUP1 and MARKUP2 modes are used inside markup.
 * The D<n> modes are used for the content of elements, i.e.,
 * between the ">" and "<" of element tags.
 * The DOCTYPE mode is used to skip DOCTYPE definition.
 * The COMMENT, CDB, RESERVED modes are used to ignore comment, CDATA block, XML reserved stuff
 */



#line 888 "scanner.cpp"

#define INITIAL 0
#define X0 1
#define X1 2
#define X2 3
#define X3 4
#define X4 5
#define X0_WS 6
#define X3_WS 7
#define X4_WS 8
#define OUTSIDE 9
#define MARKUP 10
#define MARKUP1 11
#define MARKUP2 12
#define D1 13
#define D2 14
#define DOCTYPE 15
#define COMMENT 16
#define CDB 17
#define RESERVED 18

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
#define ECHO LexerOutput( yytext, yyleng )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
\
	if ( (result = LexerInput( (char *) buf, max_size )) < 0 ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) LexerError( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1
#define YY_DECL int yyFlexLexer::yylex()
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 226 "scanner.l"


    /* XML declaration */

#line 1011 "scanner.cpp"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = & std::cin;

		if ( ! yyout )
			yyout = & std::cout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE );
		}

		yy_load_buffer_state(  );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 280 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 279 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 230 "scanner.l"
{BEGIN(X0_WS); return Token(XMLDECL);}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 231 "scanner.l"
{BEGIN(X0);}
	YY_BREAK
case 3:
/* rule 3 can match eol */
YY_RULE_SETUP
#line 232 "scanner.l"
{NewLn(); BEGIN(X0);}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 233 "scanner.l"
{BEGIN(X1);}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 234 "scanner.l"
{BEGIN(X2);}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 235 "scanner.l"
{
                                    BEGIN(X3_WS);
                                    yytext[yyleng-1] = '\0';
                                    return Token(VERSION, yytext+1);
                                }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 240 "scanner.l"
{BEGIN(X3);}
	YY_BREAK
case 8:
/* rule 8 can match eol */
YY_RULE_SETUP
#line 241 "scanner.l"
{NewLn(); BEGIN(X3);}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 242 "scanner.l"
{return ENCODING;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 243 "scanner.l"
{return EQ;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 244 "scanner.l"
{
                                    BEGIN(X4_WS);
                                    yytext[yyleng-1] = '\0';
                                    return Token(VALUE, yytext+1);
                                }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 249 "scanner.l"
{BEGIN(X4);}
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 250 "scanner.l"
{NewLn(); BEGIN(X4);}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 251 "scanner.l"
{BEGIN(X4); return STANDALONE;}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 252 "scanner.l"
{return EQ;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 253 "scanner.l"
{
                                    yytext[yyleng-1] = '\0';
                                    return Token(VALUE, yytext+1);
                                }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 257 "scanner.l"
{BEGIN(OUTSIDE); return CLOSE;}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 258 "scanner.l"
{}
	YY_BREAK
case 19:
/* rule 19 can match eol */
YY_RULE_SETUP
#line 259 "scanner.l"
{NewLn();}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 260 "scanner.l"
{OnError(loc_, "xml declaration: unexpected character"); yyterminate();}
	YY_BREAK
/* Skip comment */
case 21:
YY_RULE_SETUP
#line 265 "scanner.l"
{stateCaller_ = D1; BEGIN(COMMENT);}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 266 "scanner.l"
{stateCaller_ = OUTSIDE; BEGIN(COMMENT);}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 267 "scanner.l"
{/* eat */}
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 268 "scanner.l"
{NewLn();}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 269 "scanner.l"
{BEGIN(stateCaller_);}
	YY_BREAK
/* Skip CDATA block */
case 26:
YY_RULE_SETUP
#line 274 "scanner.l"
{stateCaller_ = D1; BEGIN(CDB);}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 275 "scanner.l"
{stateCaller_ = OUTSIDE; BEGIN(CDB);}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 276 "scanner.l"
{/* eat */}
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 277 "scanner.l"
{NewLn();}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 278 "scanner.l"
{BEGIN(stateCaller_);}
	YY_BREAK
/* Skip DOCTYPE */
case 31:
YY_RULE_SETUP
#line 283 "scanner.l"
{doctypeCnt_ = 1; BEGIN(DOCTYPE);}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 284 "scanner.l"
{++doctypeCnt_;}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 285 "scanner.l"
{/* eat */}
	YY_BREAK
case 34:
/* rule 34 can match eol */
YY_RULE_SETUP
#line 286 "scanner.l"
{NewLn();}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 287 "scanner.l"
{
                                    if(--doctypeCnt_ <= 0)
                                        BEGIN(OUTSIDE);
                                }
	YY_BREAK
/* Skip reserved xml element */
case 36:
YY_RULE_SETUP
#line 295 "scanner.l"
{stateCaller_ = D1; BEGIN(RESERVED);}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 296 "scanner.l"
{stateCaller_ = OUTSIDE; BEGIN(RESERVED);}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 297 "scanner.l"
{/* eat */}
	YY_BREAK
case 39:
/* rule 39 can match eol */
YY_RULE_SETUP
#line 298 "scanner.l"
{NewLn();}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 299 "scanner.l"
{BEGIN(stateCaller_);}
	YY_BREAK
/* Content */
case 41:
YY_RULE_SETUP
#line 304 "scanner.l"
{}
	YY_BREAK
case 42:
/* rule 42 can match eol */
YY_RULE_SETUP
#line 305 "scanner.l"
{NewLn();}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 306 "scanner.l"
{
                                    BEGIN(D1);
                                    if(dataMode_)
                                        return  skipMode_ ?
                                                Token(DATA, yyleng) :
                                                Token(DATA, yytext, yyleng);
                                }
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 313 "scanner.l"
{
                                    NewLn();
                                    BEGIN(D1);
                                    if(dataMode_)
                                        return  skipMode_ ?
                                                Token(DATA, 1) :
                                                Token(DATA, "\n", 1);
                                }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 321 "scanner.l"
{
                                    BEGIN(yyleng >= 2 ? D2 : D1);   // if number of "]" >= 2, disable ">"
                                    if(dataMode_)
                                        return  skipMode_ ?
                                                Token(DATA, yyleng) :
                                                Token(DATA, yytext, yyleng);
                                }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 328 "scanner.l"
{
                                    if(dataMode_)
                                        return gt;
                                }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 332 "scanner.l"
{
                                    BEGIN(D1);
                                    if(dataMode_)
                                        return apos;
                                }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 337 "scanner.l"
{
                                    BEGIN(D1);
                                    if(dataMode_)
                                        return quot;
                                }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 342 "scanner.l"
{
                                    char *tagName = &yytext[1];
                                    tagStack_.push_back(tagName);
                                    BEGIN(MARKUP);
                                    return Token(START, tagName);
                                }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 348 "scanner.l"
{
                                    char *tagName = &yytext[2];
                                    if(!tagStack_.size())
                                        OnError(loc_, "tag stack is empty #0");
                                    if(tagStack_.back().compare(tagName))
                                        OnError(loc_, "tag mismatch");
                                    tagStack_.pop_back();
                                    BEGIN(MARKUP);
                                    return Token(END, tagName);
                                }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 358 "scanner.l"
{OnError(loc_, "not implemented"); yyterminate();}
	YY_BREAK
/* Garbage */
case 52:
YY_RULE_SETUP
#line 363 "scanner.l"
{/* ignore outside garbage */}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 364 "scanner.l"
{
                                    // error character - try to process
                                    BEGIN(D1);
                                    if(dataMode_)
                                        switch(yytext[0])
                                        {
                                        case '<':   return lt;
                                        case '>':   return gt;
                                        case '&':   return amp;
                                        case '\'':  return apos;
                                        case '"':   return quot;
                                        default:    return unknown;
                                        }
                                }
	YY_BREAK
/* Markup */
case 54:
YY_RULE_SETUP
#line 382 "scanner.l"
{}
	YY_BREAK
case 55:
/* rule 55 can match eol */
YY_RULE_SETUP
#line 383 "scanner.l"
{NewLn();}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 384 "scanner.l"
{return EQ;}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 385 "scanner.l"
{attrHasValue_ = false; return Token(NAME, yytext);}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 386 "scanner.l"
{BEGIN(MARKUP1);}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 387 "scanner.l"
{BEGIN(MARKUP2);}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 388 "scanner.l"
{
                                    attrHasValue_ = true;
                                    if(skipMode_)
                                        return Token(VALUE);
                                    std::vector<char> buf;
                                    Decode(yytext, &buf, true, true);
                                    return Token(VALUE, &buf[0]);
                                }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 396 "scanner.l"
{
                                    attrHasValue_ = true;
                                    if(skipMode_)
                                        return Token(VALUE);
                                    std::vector<char> buf;
                                    Decode(yytext, &buf, true, true);
                                    return Token(VALUE, &buf[0]);
                                }
	YY_BREAK
case 62:
/* rule 62 can match eol */
YY_RULE_SETUP
#line 404 "scanner.l"
{
                                    attrHasValue_ = true;
                                    NewLn();
                                    return skipMode_ ? Token(VALUE) : Token(VALUE, "\n");
                                }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 409 "scanner.l"
{
                                    BEGIN(MARKUP);
                                    if(!attrHasValue_)
                                        return Token(VALUE);
                                    attrHasValue_ = false;
                                }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 415 "scanner.l"
{
                                    BEGIN(MARKUP);
                                    if(!attrHasValue_)
                                        return Token(VALUE);
                                    attrHasValue_ = false;
                                }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 421 "scanner.l"
{
                                    if(!tagStack_.size())
                                        OnError(loc_, "tag stack is empty #1");
                                    tagStack_.pop_back();
                                    BEGIN(tagStack_.size() ? D1 : OUTSIDE);
                                    return SLASHCLOSE;
                                }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 428 "scanner.l"
{
                                    BEGIN(tagStack_.size() ? D1 : OUTSIDE);
                                    return CLOSE;
                                }
	YY_BREAK
/* Default */
case 67:
/* rule 67 can match eol */
YY_RULE_SETUP
#line 436 "scanner.l"
{OnError(loc_, "default: unrecognized char"); yyterminate();}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 438 "scanner.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 1559 "scanner.cpp"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(X0):
case YY_STATE_EOF(X1):
case YY_STATE_EOF(X2):
case YY_STATE_EOF(X3):
case YY_STATE_EOF(X4):
case YY_STATE_EOF(X0_WS):
case YY_STATE_EOF(X3_WS):
case YY_STATE_EOF(X4_WS):
case YY_STATE_EOF(OUTSIDE):
case YY_STATE_EOF(MARKUP):
case YY_STATE_EOF(MARKUP1):
case YY_STATE_EOF(MARKUP2):
case YY_STATE_EOF(D1):
case YY_STATE_EOF(D2):
case YY_STATE_EOF(DOCTYPE):
case YY_STATE_EOF(COMMENT):
case YY_STATE_EOF(CDB):
case YY_STATE_EOF(RESERVED):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap(  ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */

/* The contents of this function are C++ specific, so the () macro is not used.
 */
yyFlexLexer::yyFlexLexer( std::istream* arg_yyin, std::ostream* arg_yyout )
{
	yyin = arg_yyin;
	yyout = arg_yyout;
	yy_c_buf_p = 0;
	yy_init = 0;
	yy_start = 0;
	yy_flex_debug = 0;
	yylineno = 1;	// this will only get updated if %option yylineno

	yy_did_buffer_switch_on_eof = 0;

	yy_looking_for_trail_begin = 0;
	yy_more_flag = 0;
	yy_more_len = 0;
	yy_more_offset = yy_prev_more_offset = 0;

	yy_start_stack_ptr = yy_start_stack_depth = 0;
	yy_start_stack = NULL;

	yy_buffer_stack = 0;
	yy_buffer_stack_top = 0;
	yy_buffer_stack_max = 0;

	yy_state_buf = 0;

}

/* The contents of this function are C++ specific, so the () macro is not used.
 */
yyFlexLexer::~yyFlexLexer()
{
	delete [] yy_state_buf;
	yyfree(yy_start_stack  );
	yy_delete_buffer( YY_CURRENT_BUFFER );
	yyfree(yy_buffer_stack  );
}

/* The contents of this function are C++ specific, so the () macro is not used.
 */
void yyFlexLexer::switch_streams( std::istream* new_in, std::ostream* new_out )
{
	if ( new_in )
		{
		yy_delete_buffer( YY_CURRENT_BUFFER );
		yy_switch_to_buffer( yy_create_buffer( new_in, YY_BUF_SIZE  ) );
		}

	if ( new_out )
		yyout = new_out;
}

#ifdef YY_INTERACTIVE
int yyFlexLexer::LexerInput( char* buf, int /* max_size */ )
#else
int yyFlexLexer::LexerInput( char* buf, int max_size )
#endif
{
	if ( yyin->eof() || yyin->fail() )
		return 0;

#ifdef YY_INTERACTIVE
	yyin->get( buf[0] );

	if ( yyin->eof() )
		return 0;

	if ( yyin->bad() )
		return -1;

	return 1;

#else
	(void) yyin->read( buf, max_size );

	if ( yyin->bad() )
		return -1;
	else
		return yyin->gcount();
#endif
}

void yyFlexLexer::LexerOutput( const char* buf, int size )
{
	(void) yyout->write( buf, size );
}

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
int yyFlexLexer::yy_get_next_buffer()
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    yy_state_type yyFlexLexer::yy_get_previous_state()
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 280 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    yy_state_type yyFlexLexer::yy_try_NUL_trans( yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 280 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 279);

	return yy_is_jam ? 0 : yy_current_state;
}

    void yyFlexLexer::yyunput( int c, register char* yy_bp)
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

    int yyFlexLexer::yyinput()
{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap(  ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyFlexLexer::yyrestart( std::istream* input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE );
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file );
	yy_load_buffer_state(  );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yyFlexLexer::yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state(  );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

    void yyFlexLexer::yy_load_buffer_state()
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yyFlexLexer::yy_create_buffer( std::istream* file, int size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yyFlexLexer::yy_delete_buffer( YY_BUFFER_STATE b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    void yyFlexLexer::yy_init_buffer( YY_BUFFER_STATE b, std::istream* file )

{
	int oerrno = errno;
    
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

	b->yy_is_interactive = 0;
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yyFlexLexer::yy_flush_buffer( YY_BUFFER_STATE b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state(  );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yyFlexLexer::yypush_buffer_state (YY_BUFFER_STATE new_buffer)
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state(  );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yyFlexLexer::yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state(  );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
void yyFlexLexer::yyensure_buffer_stack(void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

    void yyFlexLexer::yy_push_state( int new_state )
{
    	if ( (yy_start_stack_ptr) >= (yy_start_stack_depth) )
		{
		yy_size_t new_size;

		(yy_start_stack_depth) += YY_START_STACK_INCR;
		new_size = (yy_start_stack_depth) * sizeof( int );

		if ( ! (yy_start_stack) )
			(yy_start_stack) = (int *) yyalloc(new_size  );

		else
			(yy_start_stack) = (int *) yyrealloc((void *) (yy_start_stack),new_size  );

		if ( ! (yy_start_stack) )
			YY_FATAL_ERROR( "out of memory expanding start-condition stack" );
		}

	(yy_start_stack)[(yy_start_stack_ptr)++] = YY_START;

	BEGIN(new_state);
}

    void yyFlexLexer::yy_pop_state()
{
    	if ( --(yy_start_stack_ptr) < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN((yy_start_stack)[(yy_start_stack_ptr)]);
}

    int yyFlexLexer::yy_top_state()
{
    	return (yy_start_stack)[(yy_start_stack_ptr) - 1];
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

void yyFlexLexer::LexerError( yyconst char msg[] )
{
    	std::cerr << msg << std::endl;
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 438 "scanner.l"



namespace Fb2ToEpub
{
    int ScannerImpl::LexerInput(char* buf, int max_size)
    {
        return stm_->Read(buf, max_size);
    }


    Ptr<LexScanner> CreateScanner(InStm *stm)
    {
        return new ScannerImpl(stm);
    }
};

int yyFlexLexer::yylex()
{
    return -1;
}

