/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.xml.util;

import com.adobe.dp.xml.util.SDocumentHandler;
import com.adobe.dp.xml.util.SMap;
import com.adobe.dp.xml.util.SMapIterator;
import com.adobe.dp.xml.util.StringUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class XMLSerializer
implements SDocumentHandler {
    private OutputStream outStream;
    private boolean forgiving;
    private PrintWriter out;
    private StringBuffer prologue;
    private boolean hasEntities;
    private Stack openElements = new Stack();
    private Map prefixMap = new HashMap();
    private Map namespaceMap = new HashMap();
    private String defaultNamespace;
    private boolean closeTag;
    private static char[] newLineChar = new char[]{'\n'};

    public XMLSerializer(OutputStream out, boolean forgiving) {
        this.outStream = out;
        this.forgiving = forgiving;
    }

    public XMLSerializer(OutputStream out) {
        this.outStream = out;
    }

    private String makePrefixForNamespace(String namespace) {
        String prefix;
        int index = namespace.lastIndexOf(47);
        if (index < 0) {
            index = namespace.lastIndexOf(58);
        }
        if (index > 0 && (prefix = namespace.substring(index + 1)).matches("[a-zA-Z][-a-zA-Z0-9_]*")) {
            return prefix;
        }
        return "p";
    }

    private String getPrefix(String namespace) {
        String prefixBase;
        String prefix = (String)this.namespaceMap.get(namespace);
        if (prefix != null) {
            return prefix;
        }
        prefix = prefixBase = this.makePrefixForNamespace(namespace);
        int index = 1;
        while (this.prefixMap.containsKey(prefix)) {
            prefix = String.valueOf(prefixBase) + index;
            ++index;
        }
        this.prefixMap.put(prefix, namespace);
        this.prefixMap.put(namespace, prefix);
        OpenElement e = (OpenElement)this.openElements.peek();
        if (e.localNamespaces == null) {
            e.localNamespaces = new HashSet();
        }
        e.localNamespaces.add(prefix);
        return prefix;
    }

    private boolean sameNamespace(String ns1, String ns2) {
        if (ns1 == ns2) {
            return true;
        }
        if (ns1 == null || ns2 == null) {
            return false;
        }
        return ns1.equals(ns2);
    }

    private void closeTagIfNeeded() {
        if (this.closeTag) {
            this.out.print(">");
            this.closeTag = false;
        }
    }

    private String escapeAttribute(String value) {
        value = StringUtil.replace(value, "&", "&amp;");
        value = StringUtil.replace(value, "<", "&lt;");
        value = StringUtil.replace(value, ">", "&gt;");
        value = StringUtil.replace(value, "\"", "&quot;");
        return value;
    }

    public void startDocument(String version, String encoding) {
        if (encoding == null) {
            encoding = "utf-8";
        }
        try {
            this.out = new PrintWriter(new OutputStreamWriter(this.outStream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("unsupported encoding: '" + encoding + "'");
        }
        this.out.print("<?xml version=\"");
        this.out.print(version);
        this.out.print("\" encoding=\"");
        this.out.print(encoding);
        this.out.println("\"?>");
    }

    public void endDocument() {
        if (!this.openElements.isEmpty()) {
            if (this.forgiving) {
                do {
                    OpenElement e = (OpenElement)this.openElements.pop();
                    this.endElement(e.namespace, e.name);
                } while (!this.openElements.isEmpty());
            } else {
                throw new RuntimeException("unended elements");
            }
        }
        this.closeTagIfNeeded();
        this.out.close();
    }

    public void setDoctype(String doctype, String publicId, String systemId) {
        this.prologue = new StringBuffer("<!DOCTYPE ");
        this.prologue.append(doctype);
        if (publicId != null) {
            this.prologue.append(" PUBLIC \"");
            this.prologue.append(publicId);
            this.prologue.append("\"");
        }
        if (systemId != null) {
            this.prologue.append(" \"");
            this.prologue.append(systemId);
            this.prologue.append("\"");
        }
    }

    public void setPreferredPrefixMap(SMap preferredPrefixes) {
        SMapIterator iterator = preferredPrefixes.iterator();
        while (iterator.hasItem()) {
            String prefix = iterator.getName();
            String namespace = iterator.getValue().toString();
            this.namespaceMap.put(namespace, prefix);
            this.prefixMap.put(prefix, namespace);
            iterator.nextItem();
        }
    }

    public void defineEntity(String entityName, String value) {
        if (!this.hasEntities) {
            this.prologue.append(" [\n");
            this.hasEntities = true;
        }
        this.prologue.append("<!ENTITY ");
        this.prologue.append(entityName);
        this.prologue.append(" \"");
        this.prologue.append(this.escapeAttribute(value));
        this.prologue.append("\">\n");
    }

    public void startElement(String namespace, String name, SMap attributes, boolean makeDefaultNamespace) {
        boolean rootElement;
        boolean bl = rootElement = this.openElements.size() == 0;
        if (this.prologue != null && rootElement) {
            if (this.hasEntities) {
                this.prologue.append("]");
            }
            this.prologue.append(">");
            this.out.println(this.prologue);
        }
        this.closeTagIfNeeded();
        OpenElement e = new OpenElement(namespace, name);
        this.openElements.push(e);
        this.out.print("<");
        String newDefaultNS = null;
        if (!namespace.equals(this.defaultNamespace)) {
            if (makeDefaultNamespace) {
                e.savedDefaultNamespace = this.defaultNamespace;
                this.defaultNamespace = namespace;
                newDefaultNS = namespace;
            } else {
                e.prefix = this.getPrefix(namespace);
                this.out.print(e.prefix);
                this.out.print(":");
            }
        }
        this.out.print(name);
        if (newDefaultNS != null) {
            this.out.print(" xmlns=\"");
            this.out.print(this.escapeAttribute(newDefaultNS));
            this.out.print("\"");
        }
        if (attributes != null) {
            SMapIterator iterator = attributes.iterator();
            while (iterator.hasItem()) {
                this.out.print(" ");
                String attributeNamespace = iterator.getNamespace();
                if (attributeNamespace != null) {
                    String attributePrefix = this.getPrefix(attributeNamespace);
                    this.out.print(attributePrefix);
                    this.out.print(":");
                }
                String attributeName = iterator.getName();
                this.out.print(attributeName);
                this.out.print("=\"");
                String value = this.escapeAttribute(iterator.getValue().toString());
                this.out.print(value);
                this.out.print("\"");
                iterator.nextItem();
            }
        }
        if (e.localNamespaces != null || rootElement) {
            Iterator<Object> prefixes = rootElement ? this.prefixMap.keySet().iterator() : e.localNamespaces.iterator();
            while (prefixes.hasNext()) {
                String nsPrefix = (String)prefixes.next();
                this.out.print(" xmlns:");
                this.out.print(nsPrefix);
                this.out.print("=\"");
                String ns = (String)this.prefixMap.get(nsPrefix);
                this.out.print(this.escapeAttribute(ns));
                this.out.print("\"");
            }
        }
        this.closeTag = true;
    }

    public void endElement(String namespace, String name) {
        if (this.openElements.isEmpty()) {
            if (this.forgiving) {
                return;
            }
            throw new RuntimeException("{" + namespace + "}" + name + ": element closed after document end");
        }
        OpenElement e = (OpenElement)this.openElements.peek();
        if (!this.sameNamespace(e.namespace, namespace) || !e.name.equals(name)) {
            if (this.forgiving) {
                int len = this.openElements.size();
                int i = len - 2;
                while (i >= 0) {
                    e = (OpenElement)this.openElements.elementAt(i);
                    if (this.sameNamespace(e.namespace, namespace) && e.name.equals(name)) break;
                    --i;
                }
                if (i < 0) {
                    return;
                }
                while (true) {
                    e = (OpenElement)this.openElements.peek();
                    if (!this.sameNamespace(e.namespace, namespace) || !e.name.equals(name)) {
                        this.endElement(e.namespace, e.name);
                        continue;
                    }
                    break;
                }
            } else {
                throw new RuntimeException("Illegal nesting: {" + namespace + "}" + name + ", {" + e.namespace + "}" + e.name + " expected");
            }
        }
        this.openElements.pop();
        if (this.closeTag) {
            this.out.print("/>");
            this.closeTag = false;
        } else {
            this.out.print("</");
            if (e.prefix != null) {
                this.out.print(e.prefix);
                this.out.print(":");
            }
            this.out.print(e.name);
            this.out.print(">");
        }
        if (e.savedDefaultNamespace != null) {
            this.defaultNamespace = e.savedDefaultNamespace;
        }
        if (e.localNamespaces != null) {
            Iterator prefixes = e.localNamespaces.iterator();
            while (prefixes.hasNext()) {
                String prefix = (String)prefixes.next();
                String ns = (String)this.prefixMap.remove(prefix);
                this.namespaceMap.remove(ns);
            }
        }
    }

    public void entityReference(String entity) {
        this.closeTagIfNeeded();
        this.out.print("&");
        this.out.print(entity);
        this.out.print(";");
    }

    public void newLine() {
        this.text(newLineChar, 0, 1);
    }

    public void text(char[] text, int offset, int len) {
        this.closeTagIfNeeded();
        int end = offset + len;
        String ent = null;
        int i = offset;
        while (i < end) {
            block8: {
                char c = text[i];
                switch (c) {
                    case '&': {
                        ent = "&amp;";
                        break;
                    }
                    case '<': {
                        ent = "&lt;";
                        break;
                    }
                    case '>': {
                        ent = "&gt;";
                        break;
                    }
                    default: {
                        break block8;
                    }
                }
                if (i > offset) {
                    this.out.write(text, offset, i - offset);
                }
                offset = i + 1;
                this.out.print(ent);
            }
            ++i;
        }
        if (end > offset) {
            this.out.write(text, offset, end - offset);
        }
    }

    static class OpenElement {
        String name;
        String namespace;
        String prefix;
        Set localNamespaces;
        String savedDefaultNamespace;

        OpenElement(String namespace, String name) {
            this.name = name;
            this.namespace = namespace;
        }
    }
}

