/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.fb2.convert;

import com.adobe.dp.epub.io.BufferedDataSource;
import com.adobe.dp.epub.io.ContainerWriter;
import com.adobe.dp.epub.io.FolderContainerWriter;
import com.adobe.dp.epub.io.OCFContainerWriter;
import com.adobe.dp.epub.ncx.TOCEntry;
import com.adobe.dp.epub.opf.BitmapImageResource;
import com.adobe.dp.epub.opf.NCXResource;
import com.adobe.dp.epub.opf.OPSResource;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.ops.Element;
import com.adobe.dp.epub.ops.HTMLElement;
import com.adobe.dp.epub.ops.HyperlinkElement;
import com.adobe.dp.epub.ops.ImageElement;
import com.adobe.dp.epub.ops.OPSDocument;
import com.adobe.dp.epub.ops.SVGElement;
import com.adobe.dp.epub.ops.SVGImageElement;
import com.adobe.dp.epub.ops.TableCellElement;
import com.adobe.dp.epub.ops.XRef;
import com.adobe.dp.epub.style.BaseRule;
import com.adobe.dp.epub.style.InlineStyleRule;
import com.adobe.dp.epub.style.QuotedString;
import com.adobe.dp.epub.style.Rule;
import com.adobe.dp.epub.style.Selector;
import com.adobe.dp.epub.style.SimpleSelector;
import com.adobe.dp.epub.style.SimpleStylesheetParser;
import com.adobe.dp.epub.style.Stylesheet;
import com.adobe.dp.epub.style.ValueList;
import com.adobe.dp.epub.util.ImageDimensions;
import com.adobe.dp.fb2.FB2AuthorInfo;
import com.adobe.dp.fb2.FB2Binary;
import com.adobe.dp.fb2.FB2Date;
import com.adobe.dp.fb2.FB2DateInfo;
import com.adobe.dp.fb2.FB2Document;
import com.adobe.dp.fb2.FB2DocumentInfo;
import com.adobe.dp.fb2.FB2Element;
import com.adobe.dp.fb2.FB2EmptyLine;
import com.adobe.dp.fb2.FB2FormatException;
import com.adobe.dp.fb2.FB2GenreInfo;
import com.adobe.dp.fb2.FB2Hyperlink;
import com.adobe.dp.fb2.FB2Image;
import com.adobe.dp.fb2.FB2Line;
import com.adobe.dp.fb2.FB2OtherElement;
import com.adobe.dp.fb2.FB2Paragraph;
import com.adobe.dp.fb2.FB2PublishInfo;
import com.adobe.dp.fb2.FB2Section;
import com.adobe.dp.fb2.FB2SequenceInfo;
import com.adobe.dp.fb2.FB2StyledText;
import com.adobe.dp.fb2.FB2Subtitle;
import com.adobe.dp.fb2.FB2TableCell;
import com.adobe.dp.fb2.FB2Text;
import com.adobe.dp.fb2.FB2TextAuthor;
import com.adobe.dp.fb2.FB2Title;
import com.adobe.dp.fb2.FB2TitleInfo;
import com.adobe.dp.fb2.convert.EmbeddedFontLocator;
import com.adobe.dp.otf.DefaultFontLocator;
import com.adobe.dp.otf.FontLocator;
import com.adobe.dp.otf.FontProperties;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Converter {
    private static final int RESOURCE_THRESHOLD_MAX = 45000;
    private static final int RESOURCE_THRESHOLD_MIN = 10000;
    private static QuotedString defaultSansSerifFont = new QuotedString("Arial");
    private static QuotedString defaultSerifFont = new QuotedString("Times New Roman");
    private static QuotedString defaultMonospaceFont = new QuotedString("Courier New");
    FB2Document doc;
    Publication epub;
    Stylesheet stylesheet;
    StyleResource styles;
    NCXResource toc;
    int nameCount = 0;
    Hashtable idMap = new Hashtable();
    Hashtable docRules = new Hashtable();
    FB2Document templateDoc;
    Hashtable templateRules;
    FontLocator fontLocator;
    static Hashtable builtinRules;
    static float[] titleFontSizes;
    static /* synthetic */ Class class$0;

    static {
        titleFontSizes = new float[]{2.2f, 1.8f, 1.5f, 1.3f, 1.2f, 1.1f, 1.0f};
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.adobe.dp.fb2.convert.Converter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(clazz.getResourceAsStream("stylesheet.css"), "UTF-8"));
            SimpleStylesheetParser parser = new SimpleStylesheetParser();
            parser.readRules(reader);
            reader.close();
            builtinRules = parser.getRules();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private LinkRecord getLinkRecord(String id) {
        LinkRecord record = (LinkRecord)this.idMap.get(id);
        if (record == null) {
            record = new LinkRecord();
            this.idMap.put(id, record);
        }
        return record;
    }

    private OPSResource newCoverPageResource() {
        OPSResource res = this.epub.createOPSResource("OPS/cover.xhtml");
        res.getDocument().addStyleResource(this.styles);
        this.epub.addToSpine(res);
        return res;
    }

    private OPSResource newOPSResource() {
        String name = "OPS/ch" + ++this.nameCount + ".xhtml";
        OPSResource res = this.epub.createOPSResource(name);
        res.getDocument().addStyleResource(this.styles);
        this.epub.addToSpine(res);
        return res;
    }

    private BitmapImageResource getBitmapImageResource(String name) {
        FB2Binary bin = this.doc.getBinaryResource(name);
        if (bin == null) {
            return null;
        }
        String path = "OPS/images/" + name;
        BitmapImageResource resource = (BitmapImageResource)this.epub.getResourceByName(path);
        if (resource == null) {
            BufferedDataSource data = new BufferedDataSource();
            try {
                data.getOutputStream().write(bin.getData());
            }
            catch (IOException e) {
                throw new Error("unexpected exception: " + e);
            }
            resource = this.epub.createBitmapImageResource(path, bin.getMediaType(), data);
        }
        return resource;
    }

    private String trim(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if ((c & 0xFFFF) > 32) break;
            ++i;
        }
        boolean hadSpace = false;
        while (i < len) {
            char c = s.charAt(i);
            if ((c & 0xFFFF) > 32) {
                if (hadSpace) {
                    sb.append(' ');
                    hadSpace = false;
                }
                sb.append(c);
            } else {
                hadSpace = true;
            }
            ++i;
        }
        return sb.toString();
    }

    private String getStringValue(Object val) {
        if (val instanceof QuotedString) {
            return ((QuotedString)val).getText();
        }
        return val.toString();
    }

    private InlineStyleRule processInlineStyle(String style) {
        InlineStyleRule rule = new InlineStyleRule();
        SimpleStylesheetParser.readProperties(style, (BaseRule)rule);
        return rule;
    }

    private boolean isBuiltIn(String name) {
        return name.equals("serif") || name.equals("sans-serif") || name.equals("monospace");
    }

    private void adjustFontList(BaseRule rule) {
        ValueList fonts = (ValueList)rule.get("font-family");
        if (fonts == null) {
            return;
        }
        Iterator it = fonts.values();
        while (it.hasNext()) {
            FontProperties fp;
            String family = this.getStringValue(it.next());
            if (this.isBuiltIn(family) || !this.fontLocator.hasFont(fp = new FontProperties(family, 400, 0))) continue;
            return;
        }
        ValueList list = new ValueList();
        it = fonts.values();
        boolean inserted = false;
        while (it.hasNext()) {
            Object fn = it.next();
            String family = this.getStringValue(fn);
            if (!inserted) {
                if (family.equals("sans-serif")) {
                    list.add(defaultSansSerifFont);
                    inserted = true;
                } else if (family.equals("serif")) {
                    list.add(defaultSerifFont);
                    inserted = true;
                } else if (family.equals("monospace")) {
                    list.add(defaultMonospaceFont);
                    inserted = true;
                }
            }
            list.add(fn);
        }
        if (!inserted) {
            list.add(defaultSerifFont);
        }
        rule.set("font-family", list);
    }

    void mergeRuleStyle(Rule rule, Hashtable src, SimpleSelector ss) {
        Rule docRule = (Rule)src.get(ss);
        if (docRule != null) {
            Iterator props = docRule.properties();
            while (props.hasNext()) {
                String prop = (String)props.next();
                rule.set(prop, docRule.get(prop));
            }
        }
    }

    void mergeRuleStyle(Rule rule, Hashtable src, String fbName, String fbClass) {
        SimpleSelector ss;
        if (src == null) {
            return;
        }
        if (fbName != null) {
            ss = new SimpleSelector(fbName, null);
            this.mergeRuleStyle(rule, src, ss);
        }
        ss = new SimpleSelector(null, fbClass);
        this.mergeRuleStyle(rule, src, ss);
    }

    private void ensureRule(Selector selector, String fbName, String fbClass) {
        if (this.stylesheet.findRuleForSelector(selector) == null) {
            Rule rule = this.stylesheet.getRuleForSelector(selector);
            this.mergeRuleStyle(rule, builtinRules, fbName, fbClass);
            this.mergeRuleStyle(rule, this.docRules, fbName, fbClass);
            this.mergeRuleStyle(rule, this.templateRules, fbName, fbClass);
            this.adjustFontList(rule);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertElement(OPSDocument ops, Element parent, Object fb, TOCEntry entry, int level, boolean insideTitle) {
        if (fb instanceof FB2Element) {
            Element self;
            String className;
            String name;
            String fbName;
            FB2Element fbe = (FB2Element)fb;
            FB2Title title = null;
            if (fbe instanceof FB2Section) {
                title = ((FB2Section)fbe).getTitle();
            }
            String fbClass = fbName = fbe.getName();
            if (fbe instanceof FB2Section) {
                name = "div";
                ++level;
                className = fbName;
            } else if (fbe instanceof FB2Title) {
                name = "div";
                fbClass = className = "title" + (level > 6 ? 6 : level);
                insideTitle = true;
            } else if (fbe instanceof FB2Subtitle) {
                name = "p";
                className = "subtitle";
            } else if (fbe instanceof FB2TextAuthor) {
                name = "p";
                className = "text-author";
            } else if (fbe instanceof FB2Date) {
                name = "p";
                className = "date";
            } else if (fbe instanceof FB2Paragraph) {
                name = "p";
                fbClass = className = insideTitle ? "title-p" : "p";
            } else if (fbe instanceof FB2Line) {
                name = "p";
                className = "v";
            } else if (fbe instanceof FB2EmptyLine) {
                name = "p";
                className = "empty-line";
            } else if (fbe instanceof FB2Hyperlink) {
                name = "a";
                className = null;
            } else if (fbe instanceof FB2Image) {
                name = "img";
                className = "img";
            } else if (fbe instanceof FB2StyledText) {
                fbClass = className = ((FB2StyledText)fbe).getStyleName();
                name = "span";
            } else if (fbe instanceof FB2Text) {
                className = null;
                if (fbName.equals("emphasis")) {
                    name = "em";
                } else if (fbName.equals("strong")) {
                    name = "strong";
                } else if (fbName.equals("sup")) {
                    name = "sup";
                } else if (fbName.equals("sub")) {
                    name = "sub";
                } else {
                    if (!fbName.equals("code")) throw new RuntimeException("unexpected element: " + fbName);
                    name = "code";
                }
            } else if (fbe instanceof FB2OtherElement) {
                className = null;
                name = fbe.getName();
            } else if (fbe instanceof FB2TableCell) {
                className = null;
                name = fbe.getName();
            } else {
                System.err.println("Unknown fb2 element: " + fbe.getName());
                name = null;
                className = null;
            }
            if (name == null) {
                self = parent;
            } else {
                InlineStyleRule inlineRule;
                String style;
                if (name.equals("img")) {
                    BitmapImageResource resource;
                    ImageElement img = null;
                    FB2Image image = (FB2Image)fbe;
                    String resourceName = image.getResourceName();
                    String alt = image.getAlt();
                    String caption = image.getTitle();
                    if (resourceName != null && (resource = this.getBitmapImageResource(resourceName)) != null) {
                        img = ops.createImageElement(name);
                        img.setImageResource(resource);
                        if (alt != null) {
                            img.setAltText(alt);
                        }
                        SimpleSelector imageContent = this.stylesheet.getSimpleSelector("img", null);
                        this.ensureRule(imageContent, null, "image-content");
                    }
                    if (img == null) {
                        return;
                    }
                    name = "div";
                    self = ops.createElement(name);
                    self.add(img);
                    if (caption != null && caption.length() > 0) {
                        HTMLElement captionElement = ops.createElement("p");
                        captionElement.setClassName("image-title");
                        self.add(captionElement);
                        captionElement.add(caption);
                        SimpleSelector imageTitle = this.stylesheet.getSimpleSelector(null, "image-title");
                        this.ensureRule(imageTitle, null, "image-title");
                    }
                } else if (name.equals("a")) {
                    HyperlinkElement a = ops.createHyperlinkElement("a");
                    String link = ((FB2Hyperlink)fbe).getLinkedId();
                    if (link != null) {
                        LinkRecord record = this.getLinkRecord(link);
                        record.sources.add(a);
                    }
                    self = a;
                } else if (name.equals("td") || name.equals("th")) {
                    FB2TableCell fbt = (FB2TableCell)fbe;
                    TableCellElement td = ops.createTableCellElement(name, fbt.getAlign(), fbt.getColSpan(), fbt.getRowSpan());
                    self = td;
                } else {
                    self = ops.createElement(name);
                }
                if ((style = fbe.getStyle()) != null && (inlineRule = this.processInlineStyle(style)) != null) {
                    this.adjustFontList(inlineRule);
                    self.setStyle(inlineRule);
                }
                if (className != null) {
                    self.setClassName(className);
                }
                parent.add(self);
                if (fbe.getId() != null) {
                    LinkRecord record = this.getLinkRecord(fbe.getId());
                    record.target = self;
                }
                if (title != null && entry != null) {
                    TOCEntry subentry = this.toc.createTOCEntry(this.trim(title.contentAsString()), self.getSelfRef());
                    entry.add(subentry);
                    entry = subentry;
                }
                SimpleSelector selector = this.stylesheet.getSimpleSelector(name, className);
                this.ensureRule(selector, fbName, fbClass);
            }
            Object[] children = fbe.getChildren();
            int i = 0;
            while (i < children.length) {
                this.convertElement(ops, self, children[i], entry, level, insideTitle);
                ++i;
            }
            return;
        } else {
            parent.add(fb);
        }
    }

    public void setTemplate(InputStream templateStream) throws IOException, FB2FormatException {
        BufferedInputStream in = new BufferedInputStream(templateStream);
        byte[] sniff = new byte[4];
        in.mark(4);
        in.read(sniff);
        in.reset();
        SimpleStylesheetParser parser = new SimpleStylesheetParser();
        if (sniff[0] == 80 && sniff[1] == 75 && sniff[2] == 3 && sniff[3] == 4 || sniff[0] == 60 || sniff[0] == -17 && sniff[1] == -69 && sniff[2] == -65 && sniff[3] == 60) {
            this.templateDoc = new FB2Document(in);
            String[] stylesheets = this.templateDoc.getStylesheets();
            if (stylesheets != null && stylesheets.length > 0) {
                int i = 0;
                while (i < stylesheets.length) {
                    parser.readRules(stylesheets[i]);
                    ++i;
                }
            }
        } else {
            this.templateDoc = null;
            parser.readRules(new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8")));
        }
        this.templateRules = parser.getRules();
    }

    public void setTemplateFile(String file) {
        try {
            this.setTemplate(new FileInputStream(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FB2FormatException e) {
            e.printStackTrace();
        }
    }

    private void convertToResource(OPSResource resource, FB2Section section, TOCEntry entry, int level, int index, int length) {
        OPSDocument ops = resource.getDocument();
        Element body = ops.getBody();
        Object[] children = section.getChildren();
        int i = 0;
        while (i < length) {
            this.convertElement(ops, body, children[index + i], entry, level, false);
            ++i;
        }
    }

    private boolean isLargeSection(Object child) {
        return child instanceof FB2Section && ((FB2Section)child).getUTF16Size() >= 10000;
    }

    private void convertSection(FB2Section section, TOCEntry entry, int level) {
        String sectionName;
        int size = section.getUTF16Size();
        FB2Title title = section.getTitle();
        if (section.getName().equals("body") && (sectionName = section.getSectionName()) != null && (sectionName.equals("footnotes") || sectionName.equals("notes"))) {
            entry = null;
            level += 2;
        }
        OPSResource resource = null;
        if (title != null && level > 1) {
            resource = this.newOPSResource();
            if (entry != null) {
                TOCEntry subentry = this.toc.createTOCEntry(this.trim(title.contentAsString()), resource.getDocument().getRootXRef());
                entry.add(subentry);
                entry = subentry;
            }
        }
        Object[] children = section.getChildren();
        if (size <= 45000) {
            if (resource == null) {
                resource = this.newOPSResource();
            }
            this.convertToResource(resource, section, entry, level, 0, children.length);
            resource = null;
        } else {
            size = 0;
            int first = 0;
            int i = 0;
            while (i < children.length) {
                Object child = children[i];
                int childSize = FB2Element.getUTF16Size(child);
                int newSize = size + childSize;
                if (this.isLargeSection(child) || newSize > 45000) {
                    if (first < i) {
                        if (resource == null) {
                            resource = this.newOPSResource();
                        }
                        this.convertToResource(resource, section, entry, level, first, i - first);
                        resource = null;
                    }
                    if (this.isLargeSection(child)) {
                        this.convertSection((FB2Section)child, entry, level + 1);
                    }
                    size = 0;
                    first = ++i;
                    continue;
                }
                size = newSize;
                ++i;
            }
            if (first < i) {
                if (resource == null) {
                    resource = this.newOPSResource();
                }
                this.convertToResource(resource, section, entry, level, first, i - first);
            }
        }
    }

    private boolean isUUID(String id) {
        return id.length() == 36 && id.charAt(8) == '-' && id.charAt(13) == '-' && id.charAt(18) == '-' && id.charAt(23) == '-';
    }

    private void convert() {
        FB2PublishInfo publishInfo;
        String[] stylesheets;
        FB2TitleInfo bookInfo = this.doc.getTitleInfo();
        this.styles = this.epub.createStyleResource("OPS/style.css");
        this.stylesheet = this.styles.getStylesheet();
        if (bookInfo != null) {
            int[] dim;
            FB2Binary binary;
            String coverpageImage;
            FB2SequenceInfo[] sequences;
            FB2GenreInfo[] genres;
            FB2DateInfo date;
            FB2AuthorInfo[] translators;
            String title = bookInfo.getBookTitle();
            this.epub.addDCMetadata("title", title);
            FB2AuthorInfo[] authors = bookInfo.getAuthors();
            if (authors != null) {
                int i = 0;
                while (i < authors.length) {
                    this.epub.addDCMetadata("creator", authors[i].toString());
                    ++i;
                }
            }
            if ((translators = bookInfo.getTranslators()) != null) {
                int i = 0;
                while (i < translators.length) {
                    this.epub.addMetadata(null, "FB2.book-info.translator", translators[i].toString());
                    ++i;
                }
            }
            this.epub.addDCMetadata("language", bookInfo.getLanguage());
            FB2Section annot = bookInfo.getAnnotation();
            if (annot != null) {
                this.epub.addDCMetadata("description", annot.contentAsString());
            }
            if ((date = bookInfo.getDate()) != null) {
                String mr = date.getMachineReadable();
                this.epub.addDCMetadata("date", mr == null ? date.getHumanReadable() : mr);
            }
            if ((genres = bookInfo.getGenres()) != null) {
                int i = 0;
                while (i < genres.length) {
                    this.epub.addMetadata(null, "FB2.book-info.genre", genres[i].toString());
                    ++i;
                }
            }
            if ((sequences = bookInfo.getSequences()) != null) {
                int i = 0;
                while (i < sequences.length) {
                    this.epub.addMetadata(null, "FB2.book-info.sequence", sequences[i].toString());
                    ++i;
                }
            }
            if ((coverpageImage = bookInfo.getCoverpageImage()) != null && (binary = this.doc.getBinaryResource(coverpageImage)) != null && binary.getData() != null && (dim = ImageDimensions.getImageDimensions(binary.getData())) != null) {
                OPSResource coverRes = this.newCoverPageResource();
                OPSDocument coverDoc = coverRes.getDocument();
                Element body = coverDoc.getBody();
                body.setClassName("cover");
                Rule coverBodyRule = this.stylesheet.getRuleForSelector(this.stylesheet.getSimpleSelector("body", "cover"));
                coverBodyRule.set("oeb-column-number", "1");
                coverBodyRule.set("margin", "0px");
                coverBodyRule.set("padding", "0px");
                SVGElement svg = coverDoc.createSVGElement("svg");
                svg.setAttribute("viewBox", "0 0 " + dim[0] + " " + dim[1]);
                svg.setClassName("cover-svg");
                body.add(svg);
                Rule svgRule = this.stylesheet.getRuleForSelector(this.stylesheet.getSimpleSelector("svg", "cover-svg"));
                svgRule.set("width", "100%");
                svgRule.set("height", "100%");
                SVGImageElement image = coverDoc.createSVGImageElement("image");
                image.setAttribute("width", Integer.toString(dim[0]));
                image.setAttribute("height", Integer.toString(dim[1]));
                BitmapImageResource resource = this.getBitmapImageResource(coverpageImage);
                image.setImageResource(resource);
                svg.add(image);
            }
        }
        if ((stylesheets = this.doc.getStylesheets()) != null && stylesheets.length > 0) {
            SimpleStylesheetParser parser = new SimpleStylesheetParser();
            int i = 0;
            while (i < stylesheets.length) {
                parser.readRules(stylesheets[i]);
                ++i;
            }
            this.docRules = parser.getRules();
        }
        this.fontLocator = new EmbeddedFontLocator(this.docRules, this.doc, this.templateRules, this.templateDoc, DefaultFontLocator.getInstance());
        FB2DocumentInfo docInfo = this.doc.getDocumentInfo();
        String ident = null;
        if (docInfo != null) {
            FB2AuthorInfo[] authors = docInfo.getAuthors();
            if (authors != null) {
                int i = 0;
                while (i < authors.length) {
                    this.epub.addMetadata(null, "FB2.document-info.author", authors[i].toString());
                    ++i;
                }
            }
            this.epub.addMetadata(null, "FB2.document-info.program-used", docInfo.getProgramUsed());
            String[] urls = docInfo.getSrcUrls();
            if (urls != null) {
                int i = 0;
                while (i < urls.length) {
                    this.epub.addMetadata(null, "FB2.document-info.src-url", urls[i]);
                    ++i;
                }
            }
            this.epub.addMetadata(null, "FB2.document-info.src-ocr", docInfo.getSrcOcr());
            FB2Section history = docInfo.getHistory();
            if (history != null) {
                this.epub.addMetadata(null, "FB2.document-info.history", history.contentAsString());
            }
            ident = docInfo.getId();
            this.epub.addMetadata(null, "FB2.document-info.id", ident);
            this.epub.addMetadata(null, "FB2.document-info.version", docInfo.getVersion());
            FB2DateInfo date = bookInfo.getDate();
            if (date != null) {
                String mr = date.getMachineReadable();
                this.epub.addMetadata(null, "FB2.document-info.date", mr == null ? date.getHumanReadable() : mr);
            }
        }
        if (ident == null || !this.isUUID(ident)) {
            this.epub.generateRandomIdentifier();
            if (ident != null) {
                this.epub.addDCMetadata("identifier", ident);
            }
        } else {
            this.epub.addDCMetadata("identifier", "urn:uuid:" + ident.toLowerCase());
        }
        if ((publishInfo = this.doc.getPublishInfo()) != null) {
            this.epub.addDCMetadata("publisher", publishInfo.getPublisher());
            this.epub.addMetadata(null, "FB2.publish-info.book-name", publishInfo.getBookName());
            this.epub.addMetadata(null, "FB2.publish-info.city", publishInfo.getCity());
            this.epub.addMetadata(null, "FB2.publish-info.year", publishInfo.getYear());
            String isbn = publishInfo.getISBN();
            if (isbn != null) {
                this.epub.addDCMetadata("identifier", "isbn:" + isbn.toUpperCase());
            }
        }
        Rule bodyRule = this.stylesheet.getRuleForSelector(this.stylesheet.getSimpleSelector("body", null));
        this.mergeRuleStyle(bodyRule, builtinRules, "body", "body");
        this.mergeRuleStyle(bodyRule, this.docRules, "body", "body");
        this.mergeRuleStyle(bodyRule, this.templateRules, "body", "body");
        this.adjustFontList(bodyRule);
        long t0 = System.currentTimeMillis();
        FB2Section[] bodySections = this.doc.getBodySections();
        this.toc = this.epub.getTOC();
        TOCEntry entry = this.toc.getRootTOCEntry();
        int i = 0;
        while (i < bodySections.length) {
            this.convertSection(bodySections[i], entry, 1);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        Enumeration keys = this.idMap.keys();
        while (keys.hasMoreElements()) {
            String id = (String)keys.nextElement();
            LinkRecord record = (LinkRecord)this.idMap.get(id);
            if (record.target == null) continue;
            XRef ref = record.target.getSelfRef();
            Enumeration sources = record.sources.elements();
            while (sources.hasMoreElements()) {
                HyperlinkElement a = (HyperlinkElement)sources.nextElement();
                a.setXRef(ref);
            }
        }
        long t2 = System.currentTimeMillis();
        this.epub.addFonts(this.styles, this.fontLocator);
        long t3 = System.currentTimeMillis();
    }

    public void convert(FB2Document doc, Publication epub) {
        this.doc = doc;
        this.epub = epub;
        this.convert();
    }

    private void invoke(File inFile, File outFile) {
        try {
            long t0 = System.currentTimeMillis();
            FB2Document doc = new FB2Document(new FileInputStream(inFile));
            long t1 = System.currentTimeMillis();
            File epubFileOrFolder = outFile;
            ContainerWriter container = epubFileOrFolder.isDirectory() ? new FolderContainerWriter(epubFileOrFolder) : new OCFContainerWriter(new FileOutputStream(epubFileOrFolder));
            Publication epub = new Publication();
            epub.setTranslit(false);
            epub.useAdobeFontMangling();
            this.convert(doc, epub);
            long t2 = System.currentTimeMillis();
            epub.serialize(container);
            long t3 = System.currentTimeMillis();
        }
        catch (Exception e) {
            System.err.println("While converting " + inFile.getName());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage:");
            System.err.println("  java -jar fb2epub.jar [-style styleset.fb2] file.fb2 file.epub");
            System.err.println("  java -jar fb2epub.jar [-style styleset.fb2] -folders fb2-folder epub-folder");
            System.exit(2);
        }
        String inFile = null;
        String outFile = null;
        String styleFile = null;
        String inFolder = null;
        String outFolder = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-style")) {
                styleFile = args[++i];
            } else if (args[i].equals("-folders")) {
                inFolder = args[++i];
                outFolder = args[++i];
            } else if (inFile == null) {
                inFile = args[i];
            } else if (outFile == null) {
                outFile = args[i];
            } else {
                System.err.println("Too many arguments");
                System.exit(2);
            }
            ++i;
        }
        if (inFile != null && (inFolder != null || outFile == null)) {
            System.err.println("Bad command line syntax");
            System.exit(2);
        }
        if (inFolder != null) {
            String[] list = new File(inFolder).list();
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].endsWith(".fb2") || list[i2].endsWith(".fb2.zip")) {
                    String epubName = String.valueOf(list[i2].substring(0, list[i2].lastIndexOf(".fb2"))) + ".epub";
                    Converter c = new Converter();
                    if (styleFile != null) {
                        c.setTemplateFile(styleFile);
                    }
                    c.invoke(new File(inFolder, list[i2]), new File(outFolder, epubName));
                }
                ++i2;
            }
        } else {
            Converter c = new Converter();
            if (styleFile != null) {
                c.setTemplateFile(styleFile);
            }
            c.invoke(new File(inFile), new File(outFile));
        }
    }

    static class LinkRecord {
        Vector sources = new Vector();
        Element target;

        LinkRecord() {
        }
    }
}

