/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.style;

import com.adobe.dp.epub.style.BaseRule;
import com.adobe.dp.epub.style.QuotedString;
import com.adobe.dp.epub.style.Rule;
import com.adobe.dp.epub.style.SimpleSelector;
import com.adobe.dp.epub.style.ValueList;
import com.adobe.dp.otf.FontProperties;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class SimpleStylesheetParser {
    Hashtable rules = new Hashtable();

    private static int skipWhitespace(Reader reader) throws IOException {
        int ch;
        do {
            reader.mark(1);
            ch = reader.read();
            if (ch >= 0) continue;
            return ch;
        } while (Character.isWhitespace((char)ch));
        reader.reset();
        return ch;
    }

    private static void skipRule(Reader reader) throws IOException {
        boolean started = false;
        int counter = 0;
        while (!started && counter > 0) {
            int ch = reader.read();
            if (ch < 0) {
                return;
            }
            if (ch == 123) {
                started = true;
                ++counter;
                continue;
            }
            if (ch != 125) continue;
            --counter;
        }
    }

    private static String readName(Reader reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            reader.mark(1);
            int ch = reader.read();
            if (ch < 0) {
                return null;
            }
            if (ch != 45 && !Character.isLetterOrDigit((char)ch)) {
                reader.reset();
                return sb.toString();
            }
            sb.append((char)ch);
        }
    }

    private static int hexValue(int ch) {
        if (48 <= ch && ch <= 57) {
            return ch - 48;
        }
        if (97 <= ch && ch <= 102) {
            return ch - 87;
        }
        if (65 <= ch && ch <= 70) {
            return ch - 55;
        }
        return -1;
    }

    private static Object readValue(Reader reader, boolean partOfList) throws IOException {
        int ch = SimpleStylesheetParser.skipWhitespace(reader);
        StringBuffer sb = new StringBuffer();
        if (ch == 39 || ch == 34) {
            int fin = ch;
            reader.read();
            while ((ch = reader.read()) >= 0 && ch != fin) {
                if (ch == 92) {
                    ch = reader.read();
                    if (ch == 10) continue;
                    if (ch == 13) {
                        reader.mark(1);
                        ch = reader.read();
                        if (ch == 10) continue;
                        reader.reset();
                        continue;
                    }
                    if (SimpleStylesheetParser.hexValue(ch) >= 0) {
                        int unival = SimpleStylesheetParser.hexValue(ch);
                        int i = 0;
                        while (i < 6) {
                            reader.mark(1);
                            ch = reader.read();
                            if (ch < 0 || ch == 32 || ch == 10) break;
                            if (ch == 13) {
                                reader.mark(1);
                                ch = reader.read();
                                if (ch == 10) break;
                                reader.reset();
                                break;
                            }
                            int hv = SimpleStylesheetParser.hexValue(ch);
                            if (hv < 0) {
                                reader.reset();
                                break;
                            }
                            unival = unival << 4 | hv;
                            ++i;
                        }
                        ch = unival;
                    }
                }
                sb.append((char)ch);
            }
            return new QuotedString(sb.toString());
        }
        int braceCount = 0;
        boolean done = false;
        while (true) {
            reader.mark(1);
            ch = reader.read();
            if (ch < 0) break;
            switch (ch) {
                case 123: {
                    ++braceCount;
                    break;
                }
                case 125: {
                    if (braceCount == 0) {
                        done = true;
                        break;
                    }
                    --braceCount;
                    break;
                }
                case 59: {
                    if (braceCount != 0) break;
                    done = true;
                    break;
                }
                case 44: {
                    if (!partOfList) break;
                    done = true;
                }
            }
            if (done) {
                reader.reset();
                break;
            }
            sb.append((char)ch);
        }
        return sb.toString().trim();
    }

    public static ValueList readValueList(Reader reader) throws IOException {
        ValueList list = new ValueList();
        Object value;
        while ((value = SimpleStylesheetParser.readValue(reader, true)) != null) {
            list.add(value);
            int ch = SimpleStylesheetParser.skipWhitespace(reader);
            if (ch != 44) {
                return list;
            }
            reader.read();
        }
        return list;
    }

    public static ValueList readValueList(String value) {
        try {
            return SimpleStylesheetParser.readValueList(new StringReader(value));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void readProperties(Reader reader, BaseRule rule) throws IOException {
        int ch;
        while (Character.isLetter((char)(ch = SimpleStylesheetParser.skipWhitespace(reader))) || ch == 45) {
            String prop = SimpleStylesheetParser.readName(reader);
            ch = SimpleStylesheetParser.skipWhitespace(reader);
            if (ch != 58) break;
            reader.read();
            SimpleStylesheetParser.skipWhitespace(reader);
            Object value = prop.equals("font-family") ? SimpleStylesheetParser.readValueList(reader) : SimpleStylesheetParser.readValue(reader, false);
            if (value == null) break;
            rule.set(prop, value);
            reader.mark(1);
            ch = reader.read();
            if (ch == 59) continue;
            reader.reset();
            break;
        }
    }

    public static void readProperties(String value, BaseRule rule) {
        try {
            SimpleStylesheetParser.readProperties(new StringReader(value), rule);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static FontProperties makeFontProperties(Rule rule) {
        Object family = rule.get("font-family");
        if (family == null) {
            return null;
        }
        String familyText = family instanceof QuotedString ? ((QuotedString)family).getText() : family.toString();
        int weight = 400;
        Object w = rule.get("font-weight");
        if (w != null) {
            String ws = w.toString();
            if (ws.equals("bold")) {
                weight = 700;
            } else if (ws.endsWith("00")) {
                try {
                    weight = Integer.parseInt(ws);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        int style = 0;
        Object s = rule.get("font-style");
        if (s != null) {
            if (s.equals("italic")) {
                style = 1;
            } else if (s.equals("oblique")) {
                style = 2;
            }
        }
        return new FontProperties(familyText, weight, style);
    }

    private static String getFontSrcURL(Rule rule) {
        String src;
        Object srcObj = rule.get("src");
        if (srcObj != null && (src = srcObj.toString().trim()).startsWith("url(") && src.endsWith(")")) {
            return src.substring(4, src.length() - 1).trim();
        }
        return null;
    }

    public void readRules(Reader reader) throws IOException {
        Vector<SimpleSelector> selectors = new Vector<SimpleSelector>();
        int ch;
        while ((ch = SimpleStylesheetParser.skipWhitespace(reader)) >= 0) {
            String name = null;
            String cls = null;
            boolean fontFace = false;
            if (Character.isLetter((char)ch) || ch == 45) {
                name = SimpleStylesheetParser.readName(reader);
                if (name == null) {
                    return;
                }
                ch = SimpleStylesheetParser.skipWhitespace(reader);
            }
            if (ch == 46) {
                reader.read();
                cls = SimpleStylesheetParser.readName(reader);
                if (cls == null) {
                    return;
                }
                ch = SimpleStylesheetParser.skipWhitespace(reader);
            } else if (ch == 64) {
                reader.read();
                String atRule = SimpleStylesheetParser.readName(reader);
                if (atRule != null && atRule.equals("font-face")) {
                    fontFace = true;
                    ch = SimpleStylesheetParser.skipWhitespace(reader);
                } else {
                    SimpleStylesheetParser.skipRule(reader);
                    continue;
                }
            }
            SimpleSelector selector = new SimpleSelector(name, cls);
            selectors.add(selector);
            if (ch == 44) {
                reader.read();
                continue;
            }
            if (ch != 123) {
                return;
            }
            reader.read();
            Rule rule = null;
            if (!fontFace && selectors.size() == 1) {
                rule = (Rule)this.rules.get(selector);
                if (rule == null) {
                    rule = new Rule(selector);
                    this.rules.put(selector, rule);
                }
            } else {
                rule = new Rule(selector);
            }
            SimpleStylesheetParser.readProperties(reader, (BaseRule)rule);
            if (fontFace) {
                FontProperties props;
                String src = SimpleStylesheetParser.getFontSrcURL(rule);
                if (src != null && (props = SimpleStylesheetParser.makeFontProperties(rule)) != null) {
                    this.rules.put(props, src);
                }
            } else if (selectors.size() != 1) {
                Iterator it = selectors.iterator();
                while (it.hasNext()) {
                    selector = (SimpleSelector)it.next();
                    Rule tr = (Rule)this.rules.get(selector);
                    if (tr == null) {
                        tr = new Rule(selector);
                        this.rules.put(selector, tr);
                    }
                    Iterator props = rule.properties();
                    while (props.hasNext()) {
                        String prop = (String)props.next();
                        tr.set(prop, rule.get(prop));
                    }
                }
            }
            selectors.clear();
            reader.mark(1);
            ch = reader.read();
            if (ch == 125) continue;
            reader.reset();
        }
        return;
    }

    public void readRules(String value) {
        try {
            this.readRules(new StringReader(value));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Hashtable getRules() {
        return this.rules;
    }
}

