/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.style;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public abstract class BaseRule {
    Hashtable properties;

    BaseRule() {
        this.properties = new Hashtable();
    }

    BaseRule(Hashtable props) {
        this.properties = props;
    }

    public Object get(String property) {
        return this.properties.get(property);
    }

    public void set(String property, Object value) {
        if (value == null) {
            this.properties.remove(property);
        } else {
            this.properties.put(property, value);
        }
    }

    public Iterator properties() {
        return this.properties.keySet().iterator();
    }

    public abstract void serialize(PrintWriter var1);

    public void serializeProperties(PrintWriter out, boolean newlines) {
        Enumeration keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            Object property = keys.nextElement();
            if (newlines) {
                out.print('\t');
            }
            out.print(property);
            out.print(": ");
            out.print(this.properties.get(property));
            out.print(";");
            if (newlines) {
                out.println();
                continue;
            }
            out.print(' ');
        }
    }
}

