/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.opf;

import com.adobe.dp.epub.io.DataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Resource {
    String id;
    String name;
    String mediaType;
    DataSource source;

    public Resource(String name, String type, DataSource source) {
        this.mediaType = type;
        this.name = name;
        this.source = source;
    }

    public String getName() {
        return this.name;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String makeReference(Resource target, String fragment) {
        int m;
        StringBuffer ref = new StringBuffer();
        int index = 0;
        while (true) {
            String tn;
            String mn;
            int m2 = this.name.indexOf(47, index);
            int t = target.name.indexOf(47, index);
            if (m2 < 0 || m2 != t || !(mn = this.name.substring(index, m2)).equals(tn = target.name.substring(index, t))) break;
            index = m2 + 1;
        }
        String tail = target.name.substring(index);
        while ((m = this.name.indexOf(47, index)) >= 0) {
            ref.append("../");
            index = m + 1;
        }
        ref.append(tail);
        if (fragment != null) {
            ref.append("#");
            ref.append(fragment);
        }
        return ref.toString();
    }

    public void serialize(OutputStream out) throws IOException {
        try {
            int len;
            byte[] buffer = new byte[4096];
            InputStream in = this.source.getInputStream();
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        out.close();
    }

    public boolean canCompress() {
        return true;
    }
}

