/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.opf;

import com.adobe.dp.epub.io.ContainerWriter;
import com.adobe.dp.epub.io.DataSource;
import com.adobe.dp.epub.opf.AdobeFontResource;
import com.adobe.dp.epub.opf.BitmapImageResource;
import com.adobe.dp.epub.opf.FontResource;
import com.adobe.dp.epub.opf.IDPFFontResource;
import com.adobe.dp.epub.opf.NCXResource;
import com.adobe.dp.epub.opf.OPFResource;
import com.adobe.dp.epub.opf.OPSResource;
import com.adobe.dp.epub.opf.Resource;
import com.adobe.dp.epub.opf.StyleResource;
import com.adobe.dp.epub.otf.FontSubsetter;
import com.adobe.dp.otf.DefaultFontLocator;
import com.adobe.dp.otf.FontLocator;
import com.adobe.dp.xml.util.SMapImpl;
import com.adobe.dp.xml.util.XMLSerializer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Publication {
    public static final String dcns = "http://purl.org/dc/elements/1.1/";
    public static final String ocfns = "urn:oasis:names:tc:opendocument:xmlns:container";
    public static final String encns = "http://www.w3.org/2001/04/xmlenc#";
    public static final String deencns = "http://ns.adobe.com/digitaleditions/enc";
    boolean translit;
    boolean useIDPFFontMangling = true;
    Hashtable resourcesByName = new Hashtable();
    Hashtable resourcesById = new Hashtable();
    Hashtable namingIndices = new Hashtable();
    Vector spine = new Vector();
    Vector metadata = new Vector();
    NCXResource toc;
    OPFResource opf;
    int idCount = 1;
    private String contentFolder;

    public Publication() {
        this("OPS");
    }

    public Publication(String contentFolder) {
        this.contentFolder = contentFolder;
        this.toc = new NCXResource(this, String.valueOf(contentFolder) + "/toc.ncx");
        this.opf = new OPFResource(this, String.valueOf(contentFolder) + "/content.opf");
        this.resourcesByName.put(this.toc.name, this.toc);
        this.resourcesByName.put(this.opf.name, this.opf);
    }

    public Publication(File file) throws IOException {
        ZipFile zip = new ZipFile(file);
        ZipEntry container = zip.getEntry("META-INF/container.xml");
        if (container == null) {
            throw new IOException("Not an EPUB file: META-INF/container.xml missing");
        }
        String opfName = Publication.processOCF(zip.getInputStream(container));
        this.opf = new OPFResource(this, opfName);
        this.opf.parse(zip.getInputStream(zip.getEntry(opfName)));
    }

    public String getContentFolder() {
        return this.contentFolder;
    }

    public void useAdobeFontMangling() {
        this.useIDPFFontMangling = false;
    }

    public void useIDPFFontMangling() {
        this.useIDPFFontMangling = true;
    }

    private static String processOCF(InputStream ocfStream) throws IOException {
        throw new IOException("Not yet implemented");
    }

    public void setTranslit(boolean translit) {
        this.translit = translit;
    }

    public boolean isTranslit() {
        return this.translit;
    }

    private static void addRandomHexDigit(StringBuffer sb, Random r, int count, int mask, int value) {
        int i = 0;
        while (i < count) {
            int v = r.nextInt(16) & mask | value;
            if (v < 10) {
                sb.append((char)(48 + v));
            } else {
                sb.append((char)(87 + v));
            }
            ++i;
        }
    }

    public String generateRandomIdentifier() {
        StringBuffer sb = new StringBuffer("urn:uuid:");
        SecureRandom sr = new SecureRandom();
        Publication.addRandomHexDigit(sb, sr, 8, 15, 0);
        sb.append('-');
        Publication.addRandomHexDigit(sb, sr, 4, 15, 0);
        sb.append('-');
        sb.append('4');
        Publication.addRandomHexDigit(sb, sr, 3, 15, 0);
        sb.append('-');
        Publication.addRandomHexDigit(sb, sr, 1, 3, 8);
        Publication.addRandomHexDigit(sb, sr, 3, 15, 0);
        sb.append('-');
        Publication.addRandomHexDigit(sb, sr, 12, 15, 0);
        String id = sb.toString();
        this.addDCMetadata("identifier", id);
        return id;
    }

    public NCXResource getTOC() {
        return this.toc;
    }

    public OPFResource getOPF() {
        return this.opf;
    }

    public String getDCMetadata(String name) {
        return this.getMetadata(dcns, name, 0);
    }

    public void addDCMetadata(String name, String value) {
        if (value != null) {
            this.addMetadata(dcns, name, value);
        }
    }

    public String getMetadata(String ns, String name, int index) {
        Iterator it = this.metadata.iterator();
        while (it.hasNext()) {
            SimpleMetadata md = (SimpleMetadata)it.next();
            if (!(ns == null ? md.ns == null : md.ns != null && md.ns.equals(ns)) || !md.name.equals(name)) continue;
            if (index == 0) {
                return md.value;
            }
            --index;
        }
        return null;
    }

    public void addMetadata(String ns, String name, String value) {
        if (value == null) {
            return;
        }
        this.metadata.add(new SimpleMetadata(ns, name, value));
    }

    private String getAdobePrimaryUUID() {
        Iterator it = this.metadata.iterator();
        while (it.hasNext()) {
            SimpleMetadata item = (SimpleMetadata)it.next();
            if (item.ns == null || !item.ns.equals(dcns) || !item.name.equals("identifier") || !item.value.startsWith("urn:uuid:")) continue;
            return item.value.substring(9);
        }
        String value = this.generateRandomIdentifier();
        return value.substring(9);
    }

    public String getPrimaryIdentifier() {
        Iterator it = this.metadata.iterator();
        while (it.hasNext()) {
            SimpleMetadata item = (SimpleMetadata)it.next();
            if (item.ns == null || !item.ns.equals(dcns) || !item.name.equals("identifier")) continue;
            return item.value;
        }
        return this.generateRandomIdentifier();
    }

    public String makeUniqueResourceName(String baseName) {
        String name;
        String suffix;
        if (this.resourcesByName.get(baseName) == null) {
            return baseName;
        }
        int index = baseName.lastIndexOf(46);
        if (index < 0) {
            suffix = "";
        } else {
            suffix = baseName.substring(index);
            baseName = baseName.substring(0, index);
        }
        Integer lastIndex = (Integer)this.namingIndices.get(baseName);
        index = lastIndex == null ? 1 : lastIndex + 1;
        while (this.resourcesByName.get(name = String.valueOf(baseName) + "-" + index + suffix) != null) {
            ++index;
        }
        this.namingIndices.put(baseName, new Integer(index));
        return name;
    }

    public OPSResource createOPSResource(String name) {
        OPSResource resource = new OPSResource(name);
        this.resourcesByName.put(name, resource);
        return resource;
    }

    public BitmapImageResource createBitmapImageResource(String name, String mediaType, DataSource data) {
        BitmapImageResource resource = new BitmapImageResource(name, mediaType, data);
        this.resourcesByName.put(name, resource);
        return resource;
    }

    public StyleResource createStyleResource(String name) {
        StyleResource resource = new StyleResource(name);
        this.resourcesByName.put(name, resource);
        return resource;
    }

    public Resource createResource(String name, String mediaType, DataSource data) {
        Resource resource = new Resource(name, mediaType, data);
        this.resourcesByName.put(name, resource);
        return resource;
    }

    public FontResource createFontResource(String name, DataSource data) {
        IDPFFontResource resource = this.useIDPFFontMangling ? new IDPFFontResource(name, data) : new AdobeFontResource(name, data);
        this.resourcesByName.put(name, resource);
        return resource;
    }

    public void addToSpine(Resource resource) {
        this.spine.add(resource);
    }

    public Iterator resources() {
        return this.resourcesByName.values().iterator();
    }

    public Iterator spine() {
        return this.spine.iterator();
    }

    public Resource getResourceByName(String name) {
        return (Resource)this.resourcesByName.get(name);
    }

    String assignId(Resource res) {
        if (res.id == null) {
            res.id = this.makeId();
            this.resourcesById.put(res.id, res);
        }
        return res.id;
    }

    String makeId() {
        String id;
        while (this.resourcesById.get(id = "id" + this.idCount++) != null) {
        }
        return id;
    }

    public void addFonts(StyleResource styleResource) {
        this.addFonts(styleResource, DefaultFontLocator.getInstance());
    }

    public void addFonts(StyleResource styleResource, FontLocator locator) {
        FontSubsetter subsetter = new FontSubsetter(this, styleResource, locator);
        Iterator res = this.resources();
        while (res.hasNext()) {
            Object next = res.next();
            if (!(next instanceof OPSResource)) continue;
            OPSResource ops = (OPSResource)next;
            ops.getDocument().addFonts(subsetter, styleResource);
        }
        subsetter.addFonts(this);
    }

    public static String strip(String source) {
        return source.replaceAll("\\s+", "");
    }

    private byte[] makeXORMask() {
        ByteArrayOutputStream mask;
        block13: {
            block12: {
                mask = new ByteArrayOutputStream();
                if (!this.useIDPFFontMangling) break block12;
                try {
                    MessageDigest sha = MessageDigest.getInstance("SHA-1");
                    String temp = Publication.strip(this.getPrimaryIdentifier());
                    sha.update(temp.getBytes("UTF-8"), 0, temp.length());
                    mask.write(sha.digest());
                }
                catch (NoSuchAlgorithmException e) {
                    System.err.println("No such Algorithm (really, did I misspell SHA-1?");
                    System.err.println(e.toString());
                    return null;
                }
                catch (IOException e) {
                    System.err.println("IO Exception. check out mask.write...");
                    System.err.println(e.toString());
                    return null;
                }
                if (mask.size() != 20) {
                    System.err.println("makeXORMask should give 20 byte mask, but isn't");
                    return null;
                }
                break block13;
            }
            String opfUID = this.getAdobePrimaryUUID();
            int acc = 0;
            int len = opfUID.length();
            int i = 0;
            while (i < len) {
                block17: {
                    int n;
                    block15: {
                        char c;
                        block16: {
                            block14: {
                                c = opfUID.charAt(i);
                                if ('0' > c || c > '9') break block14;
                                n = c - 48;
                                break block15;
                            }
                            if ('a' > c || c > 'f') break block16;
                            n = c - 87;
                            break block15;
                        }
                        if ('A' > c || c > 'F') break block17;
                        n = c - 55;
                    }
                    if (acc == 0) {
                        acc = 0x100 | n << 4;
                    } else {
                        mask.write(acc | n);
                        acc = 0;
                    }
                }
                ++i;
            }
            if (mask.size() != 16) {
                return null;
            }
        }
        return mask.toByteArray();
    }

    public void serialize(ContainerWriter container) throws IOException {
        XMLSerializer ser;
        Enumeration names = this.resourcesByName.keys();
        byte[] mask = this.makeXORMask();
        boolean needEnc = false;
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Resource res = (Resource)this.resourcesByName.get(name);
            if (mask != null && res instanceof AdobeFontResource) {
                ((AdobeFontResource)res).setXORMask(mask);
                needEnc = true;
            }
            if (mask != null && res instanceof IDPFFontResource) {
                ((IDPFFontResource)res).setXORMask(mask);
                needEnc = true;
            }
            OutputStream out = container.getOutputStream(name, res.canCompress());
            res.serialize(out);
        }
        if (needEnc) {
            ser = new XMLSerializer(container.getOutputStream("META-INF/encryption.xml"));
            ser.startDocument("1.0", "UTF-8");
            ser.startElement(ocfns, "encryption", null, true);
            names = this.resourcesByName.keys();
            while (names.hasMoreElements()) {
                SMapImpl attrs;
                String name = (String)names.nextElement();
                Resource res = (Resource)this.resourcesByName.get(name);
                if (res instanceof FontResource && this.useIDPFFontMangling) {
                    attrs = new SMapImpl();
                    ser.startElement(encns, "EncryptedData", null, true);
                    attrs.put(null, "Algorithm", "http://www.idpf.org/2008/embedding");
                    ser.startElement(encns, "EncryptionMethod", attrs, false);
                    ser.endElement(encns, "EncryptionMethod");
                    ser.startElement(encns, "CipherData", null, false);
                    attrs = new SMapImpl();
                    attrs.put(null, "URI", name);
                    ser.startElement(encns, "CipherReference", attrs, false);
                    ser.endElement(encns, "CipherReference");
                    ser.endElement(encns, "CipherData");
                    ser.endElement(encns, "EncryptedData");
                    continue;
                }
                if (!(res instanceof FontResource)) continue;
                ser.startElement(encns, "EncryptedData", null, true);
                attrs = new SMapImpl();
                attrs.put(null, "Algorithm", "http://ns.adobe.com/pdf/enc#RC");
                ser.startElement(encns, "EncryptionMethod", attrs, false);
                ser.endElement(encns, "EncryptionMethod");
                ser.startElement(encns, "CipherData", null, false);
                attrs = new SMapImpl();
                attrs.put(null, "URI", name);
                ser.startElement(encns, "CipherReference", attrs, false);
                ser.endElement(encns, "CipherReference");
                ser.endElement(encns, "CipherData");
                ser.endElement(encns, "EncryptedData");
            }
            ser.endElement(ocfns, "encryption");
            ser.endDocument();
        }
        ser = new XMLSerializer(container.getOutputStream("META-INF/container.xml"));
        ser.startDocument("1.0", "UTF-8");
        SMapImpl attrs = new SMapImpl();
        attrs.put(null, "version", "1.0");
        ser.startElement(ocfns, "container", attrs, true);
        ser.startElement(ocfns, "rootfiles", null, false);
        attrs = new SMapImpl();
        attrs.put(null, "full-path", this.opf.name);
        attrs.put(null, "media-type", this.opf.mediaType);
        ser.startElement(ocfns, "rootfile", attrs, true);
        ser.endElement(ocfns, "rootfile");
        ser.endElement(ocfns, "rootfiles");
        ser.endElement(ocfns, "container");
        ser.endDocument();
        container.close();
    }

    static class SimpleMetadata {
        String ns;
        String name;
        String value;

        SimpleMetadata(String ns, String name, String value) {
            this.name = name;
            this.ns = ns;
            this.value = value;
        }
    }
}

