/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.opf;

import com.adobe.dp.epub.ncx.TOCEntry;
import com.adobe.dp.epub.opf.Publication;
import com.adobe.dp.epub.opf.Resource;
import com.adobe.dp.epub.ops.XRef;
import com.adobe.dp.epub.util.Translit;
import com.adobe.dp.xml.util.SMapImpl;
import com.adobe.dp.xml.util.XMLSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public class NCXResource
extends Resource {
    Publication owner;
    TOCEntry rootTOCEntry = new TOCEntry("", null);
    int entryCount;
    private static final String ncxns = "http://www.daisy.org/z3986/2005/ncx/";

    public NCXResource(Publication owner, String name) {
        super(name, "application/x-dtbncx+xml", null);
        this.owner = owner;
    }

    public TOCEntry getRootTOCEntry() {
        return this.rootTOCEntry;
    }

    public TOCEntry createTOCEntry(String title, XRef xref) {
        return new TOCEntry(title, xref);
    }

    public void serialize(OutputStream out) throws IOException {
        XMLSerializer ser = new XMLSerializer(out);
        ser.startDocument("1.0", "UTF-8");
        SMapImpl attrs = new SMapImpl();
        attrs.put(null, "version", "2005-1");
        String lang = this.owner.getDCMetadata("language");
        if (lang != null) {
            attrs.put(null, "xml:lang", lang);
        }
        ser.startElement(ncxns, "ncx", attrs, true);
        ser.newLine();
        ser.startElement(ncxns, "head", null, false);
        ser.newLine();
        attrs = new SMapImpl();
        attrs.put(null, "name", "dtb:uid");
        String uid = this.owner.getDCMetadata("identifier");
        if (uid == null) {
            uid = "";
        }
        attrs.put(null, "content", uid);
        ser.startElement(ncxns, "meta", attrs, false);
        ser.endElement(ncxns, "meta");
        ser.newLine();
        attrs = new SMapImpl();
        attrs.put(null, "name", "dtb:depth");
        int depth = NCXResource.calculateDepth(this.rootTOCEntry);
        attrs.put(null, "content", Integer.toString(depth));
        ser.startElement(ncxns, "meta", attrs, false);
        ser.endElement(ncxns, "meta");
        ser.newLine();
        attrs = new SMapImpl();
        attrs.put(null, "name", "dtb:totalPageNumber");
        attrs.put(null, "content", "0");
        ser.startElement(ncxns, "meta", attrs, false);
        ser.endElement(ncxns, "meta");
        ser.newLine();
        attrs = new SMapImpl();
        attrs.put(null, "name", "dtb:maxPageNumber");
        attrs.put(null, "content", "0");
        ser.startElement(ncxns, "meta", attrs, false);
        ser.endElement(ncxns, "meta");
        ser.newLine();
        ser.endElement(ncxns, "head");
        ser.newLine();
        ser.startElement(ncxns, "docTitle", null, false);
        ser.startElement(ncxns, "text", null, false);
        String title = this.owner.getDCMetadata("title");
        if (title == null) {
            title = "";
        }
        if (this.owner.isTranslit()) {
            title = Translit.translit(title);
        }
        char[] arr = title.toCharArray();
        ser.text(arr, 0, arr.length);
        ser.endElement(ncxns, "text");
        ser.endElement(ncxns, "docTitle");
        ser.newLine();
        ser.startElement(ncxns, "navMap", null, false);
        ser.newLine();
        this.entryCount = 1;
        this.serializeChildEntries(this.rootTOCEntry, ser);
        ser.endElement(ncxns, "navMap");
        ser.newLine();
        ser.endElement(ncxns, "ncx");
        ser.newLine();
        ser.endDocument();
    }

    private static int calculateDepth(TOCEntry entry) {
        Iterator it = entry.content();
        int maxDepth = 0;
        while (it.hasNext()) {
            TOCEntry child = (TOCEntry)it.next();
            int depth = NCXResource.calculateDepth(child);
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth + 1;
    }

    private void serializeChildEntries(TOCEntry entry, XMLSerializer ser) {
        Iterator it = entry.content();
        while (it.hasNext()) {
            TOCEntry child = (TOCEntry)it.next();
            SMapImpl attrs = new SMapImpl();
            attrs.put(null, "playOrder", Integer.toString(this.entryCount));
            attrs.put(null, "id", "id" + this.entryCount);
            ++this.entryCount;
            ser.startElement(ncxns, "navPoint", attrs, false);
            ser.newLine();
            ser.startElement(ncxns, "navLabel", null, false);
            ser.newLine();
            ser.startElement(ncxns, "text", null, false);
            String title = child.getTitle();
            if (title == null) {
                title = "";
            }
            if (this.owner.isTranslit()) {
                title = Translit.translit(title);
            }
            char[] arr = title.toCharArray();
            ser.text(arr, 0, arr.length);
            ser.endElement(ncxns, "text");
            ser.newLine();
            ser.endElement(ncxns, "navLabel");
            ser.newLine();
            attrs = new SMapImpl();
            attrs.put(null, "src", child.getXRef().makeReference(this));
            ser.startElement(ncxns, "content", attrs, false);
            ser.endElement(ncxns, "content");
            ser.newLine();
            this.serializeChildEntries(child, ser);
            ser.endElement(ncxns, "navPoint");
            ser.newLine();
        }
    }
}

