/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.io;

import com.adobe.dp.epub.io.ContainerSource;
import com.adobe.dp.epub.io.DataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipContainerSource
extends ContainerSource {
    ZipFile zip;

    public ZipContainerSource(File zip) throws ZipException, IOException {
        this.zip = new ZipFile(zip);
    }

    public DataSource getDataSource(String name) {
        ZipEntry entry = this.zip.getEntry(name);
        if (entry == null) {
            return null;
        }
        return new DataSourceImpl(entry);
    }

    class DataSourceImpl
    extends DataSource {
        ZipEntry entry;

        DataSourceImpl(ZipEntry entry) {
            this.entry = entry;
        }

        public InputStream getInputStream() throws IOException {
            return ZipContainerSource.this.zip.getInputStream(this.entry);
        }
    }
}

