/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dp.epub.io;

import com.adobe.dp.epub.io.ContainerWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class OCFContainerWriter
extends ContainerWriter {
    ZipOutputStream zip;

    public OCFContainerWriter(OutputStream out) throws IOException {
        this(out, "application/epub+zip");
    }

    public OCFContainerWriter(OutputStream out, String mime) throws IOException {
        this.zip = new ZipOutputStream(out);
        try {
            byte[] bytes = mime.getBytes("UTF-8");
            ZipEntry mimetype = new ZipEntry("mimetype");
            mimetype.setMethod(0);
            mimetype.setSize(bytes.length);
            mimetype.setCompressedSize(bytes.length);
            CRC32 crc = new CRC32();
            crc.update(bytes);
            mimetype.setCrc(crc.getValue());
            this.zip.putNextEntry(mimetype);
            this.zip.write(bytes);
            this.zip.closeEntry();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public OutputStream getOutputStream(String name, boolean eligibleForCompression) throws IOException {
        if (eligibleForCompression) {
            this.zip.putNextEntry(new ZipEntry(name));
            return new CompressedEntryStream();
        }
        return new StoredEntryStream(name);
    }

    public void close() throws IOException {
        this.zip.close();
    }

    class CompressedEntryStream
    extends OutputStream {
        CompressedEntryStream() {
        }

        public void write(int b) throws IOException {
            OCFContainerWriter.this.zip.write(b);
        }

        public void close() throws IOException {
            OCFContainerWriter.this.zip.closeEntry();
        }

        public void flush() throws IOException {
            OCFContainerWriter.this.zip.flush();
        }

        public void write(byte[] arg0, int arg1, int arg2) throws IOException {
            OCFContainerWriter.this.zip.write(arg0, arg1, arg2);
        }
    }

    class StoredEntryStream
    extends OutputStream {
        String name;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        StoredEntryStream(String name) {
            this.name = name;
        }

        public void write(int b) throws IOException {
            this.buffer.write(b);
        }

        public void close() throws IOException {
            byte[] bytes = this.buffer.toByteArray();
            ZipEntry entry = new ZipEntry(this.name);
            entry.setMethod(0);
            entry.setSize(bytes.length);
            entry.setCompressedSize(bytes.length);
            CRC32 crc = new CRC32();
            crc.update(bytes);
            entry.setCrc(crc.getValue());
            OCFContainerWriter.this.zip.putNextEntry(entry);
            OCFContainerWriter.this.zip.write(bytes);
            OCFContainerWriter.this.zip.closeEntry();
        }

        public void flush() throws IOException {
        }

        public void write(byte[] buf, int arg1, int arg2) throws IOException {
            this.buffer.write(buf, arg1, arg2);
        }
    }
}

